<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With*');
header("Content-Type: application/json; charset=UTF-8");


if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Web_service_crm extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('cotizaciones_model');
        $this->load->model('gsatelite');
    }

    /**
     * @author René Castaneda
     * @since 12-11-2018
     * @return 
     */
    function index() {
        
    }

    /**
     * @author René Castaneda
     * @since 12-11-2018
     * @return Obtener departamentos.
     */
    public function obtener_departamento() {   
        if($_POST){
            //query
            $where['dep_estado'] = 1;

            if (isset($_POST['todos'])) {
                if ($_POST['todos'] == 0) {
                    if (isset($_POST['id_depto'])) 
                    $where['dep_id'] = $_POST['id_depto'];

                    if (isset($_POST['nombre_depto'])) 
                        $where['dep_nombre'] = $_POST['nombre_depto'];
                    
                    if (!isset($_POST['id_depto']) && !isset($_POST['nombre_depto']) ) 
                        $where['dep_id']= 0;

                } else if ($_POST['todos'] == 1) {
                    $where              = null;
                    $where['dep_estado'] = 1;
                } else {
                    $departamentos['info'] = "Formato incorrecto.";
                    echo json_encode($departamentos);
                    die();
                }

                $campos = "dep_id AS id_depto, pai_id AS id_pais, dep_nombre AS nombre_depto, pai_nombre AS nombre_pais";
                $departamentos = $this->cotizaciones_model->obtener_departamento($where,$campos);
                if (count($departamentos)<=0) {
                    $departamentos['info'] = "Sin Registros";
                }
                echo json_encode($departamentos);
                die();
            } else {
                $departamentos['info'] = "Todos es requerido";
                echo json_encode($departamentos);
                die();
            }
        } else {
            $departamentos['info'] = "Acceso Denegado";
            echo json_encode($departamentos);
            die();
        }
    }

    /**
     * @author René Castaneda
     * @since 12-11-2018
     * @return Obtener municipios.
     */
    public function obtener_municipio()
    {           
        //query
        $where['mun_estado'] = 1;
        if (isset($_POST['id_depto'])) {
            $where['mun_id_dep'] = $_POST['id_depto'];
        } 
            
        if (isset($_POST['id_mun'])) 
            $where['mun_id'] = $_POST['id_mun'];

        $campos = "mun_id AS id_mun, dep_id AS id_depto, mun_nombre AS nombre_mun, dep_nombre AS nombre_depto";
        $query_datos = $this->cotizaciones_model->obtener_municipios($where,$campos);
        if (count($query_datos)<=0) {
            $query_datos['info'] = "Sin Registros";
        }
        echo json_encode($query_datos);
        die();
        
    }

    /**
     * @author René Castaneda
     * @since 12-11-2018
     * @return Obtener tipo de documentos.
     */
    public function obtener_tipo_documento()
    {   
        
        //query
        $where['tde_estado'] = 1;
        if (isset($_POST['id_tipo_doc'])) 
            $where['tde_id'] = $_POST['id_tipo_doc'];

        if (isset($_POST['nombre_doc'])) 
            $where['tde_nombre'] = $_POST['nombre_doc'];

        $campos = "tde_id AS id_tipo_doc, tde_nombre AS nombre_doc, tde_mascara AS mascara_doc";
        $this->db->select($campos);
        $query_datos = $this->gsatelite->get_tabla('tde_tipo_documento',$where);
        if (count($query_datos)<=0) {
            $query_datos['info'] = "Sin Registros";
        }
        echo json_encode($query_datos);
        die();
    }

    /**
     * @author René Castaneda
     * @since 14-11-2018
     * @return Obtener cliente
     */
    public function obtener_cliente()
    {   
        
        //query
        //json_encode($_POST); die();
        $where['cli_estado'] = 1;
        if (isset($_POST['id_cliente'])) 
            $where['cli_id'] = $_POST['id_cliente'];

        if (isset($_POST['tipo_doc'])) 
            $where['dcc_id_tde'] = $_POST['tipo_doc'];

        if (isset($_POST['valor_doc'])) 
            $where['dcc_valor'] = $_POST['valor_doc'];

        if (isset($_POST['nombre_cliente'])) 
            $where['cli_nombre'] = $_POST['nombre_cliente'];

        if (isset($_POST['apellido_cliente'])) 
            $where['cli_apellido'] = $_POST['apellido_cliente'];

        if (isset($_POST['correo'])) 
            $where['cli_email'] = $_POST['correo'];

        $campos = "
        cli_id AS id_cliente,
        cli_personeria AS personeria,
        (IF(cli_personeria=1,'natural',(IF(cli_personeria=2,'Jurídica',null)))) personeria,
        cli_codigo AS codigo_cliente,
        cli_nombre AS nombre,
        cli_apellido AS apellido,
        cli_representante AS representante,
        cli_email AS correo,
        pai_nombre AS nacionalidad,
        pai_id AS id_pais,
        pro_nombre AS profesion,
        cli_lugar_trabajo AS lugar_trabajo,
        cli_cargo AS cargo,
        GROUP_CONCAT(DISTINCT CONCAT(tmc_id,'#', tmc_nombre) SEPARATOR '@@') AS medio_contacto,
        tpn_id_tlp AS id_lista_precio,
        tlp_nombre AS lista_precio,
        GROUP_CONCAT(DISTINCT CONCAT_WS('#', txc_id_tit, tit_nombre, txc_numero) SEPARATOR '@@') AS telefonos,
        tpc_nombre AS tipo_cliente,
        cli_direccion AS direccion,
        cli_id_mun AS id_municipio,
        mun_id_dep AS id_departamento,
        zog_nombre AS zona_geografica,
        cli_encargado_pago AS persona_autorizada,
        cli_sitio_web AS sitio_web,
        sec_nombre AS sector,
        cac_nombre AS segmento,
        cli_fecha_nacimiento AS fecha_nacimiento,
        gir_nombre AS giro,
        cli_registro AS registro,
        cli_fecha_registro AS fecha_registro,
        cli_observacion AS observaciones,
        GROUP_CONCAT(DISTINCT CONCAT_WS('#', dcc_id_tde, tde_nombre, dcc_valor) SEPARATOR '@@') AS documentos
        ";
        $query_datos = $this->cotizaciones_model->obtener_cliente($where,$campos);
        $datos_array = array();
        foreach ($query_datos as $fila) {
    
            //ordenar los medio de contactos
            if (trim($fila['medio_contacto']) != "") {
                $medio_contacto = explode('@@', trim($fila['medio_contacto']));
                $medio_contacto_array = array();
                for ($k=0; $k < count($medio_contacto) ; $k++) { 
                    $detalles = explode('#', $medio_contacto[$k]);
                    $medio_contac['id_medio'] = $detalles[0];
                    $medio_contac['nombre_medio'] = $detalles[1];
                    $medio_contacto_array[] = $medio_contac;
                }
                $fila['medio_contacto'] = $medio_contacto_array; //reasignar
            }

            //ordenar los telefonos
            if (trim($fila['telefonos']) != "") {
                $telefono = explode('@@', trim($fila['telefonos']));
                $telefono_array = array();
                for ($k=0; $k < count($telefono) ; $k++) { 
                    $detalles = explode('#', $telefono[$k]);
                    $tel['id_tipo'] = $detalles[0];
                    $tel['nombre_tipo'] = $detalles[1];
                    $tel['valor'] = $detalles[2];
                    $telefono_array[] = $tel;
                }
                $fila['telefonos'] = $telefono_array; //reasignar
            }

            //ordenar los telefonos
            if (trim($fila['documentos']) != "") {
                $documentos = explode('@@', trim($fila['documentos']));
                $documentos_array = array();
                for ($k=0; $k < count($documentos) ; $k++) { 
                    $detalles = explode('#', $documentos[$k]);
                    $doc['id_tipo'] = $detalles[0];
                    $doc['nombre_tipo'] = $detalles[1];
                    $doc['valor'] = $detalles[2];
                    $documentos_array[] = $doc;
                }
                $fila['documentos'] = $documentos_array; //reasignar
            }

         //contactos   
        $contactos = array();
        $query_contactos = $this->gsatelite->get_tabla('con_contacto',array('con_id_cli'=>$fila['id_cliente'], 'con_estado'=>1));
        foreach ($query_contactos as $fila_con) {
            if ($fila_con['con_id'] > 0 ) {
                $contac['id_contacto'] = $fila_con['con_id'];
                $contac['nombre'] = $fila_con['con_nombre'];
                $contac['apellido'] = $fila_con['con_apellidos'];
                $contac['cargo'] = $fila_con['con_cargo'];
                $contac['telefono'] = $fila_con['con_telefono'];
                $contac['email'] = $fila_con['con_email'];
                $contactos = $contac;
            }
        }
        $fila['contactos'] = $contactos;
        //sucursales
        $sucursales = array();
        $query_sucursales = $this->cotizaciones_model->get_sucursal_cliente(array('scl_id_cli'=>$fila['id_cliente'], 'scl_estado'=>1));
        foreach ($query_sucursales as $fila_suc) {
            if ($fila_suc['scl_id'] > 0 ) {
                $suc['id_sucursal '] = $fila_suc['scl_id'];
                $suc['codigo'] = $fila_suc['scl_codigo'];
                $suc['nombre'] = $fila_suc['scl_nombre'];
                $suc['direccion'] = $fila_suc['scl_direccion'];
                $suc['id_depto'] = $fila_suc['mun_id_dep'];
                $suc['nombre_depto'] = $fila_suc['dep_nombre'];
                $suc['id_mun'] = $fila_suc['scl_id_mun'];
                $suc['nombre_mun'] = $fila_suc['mun_nombre'];
                $sucursales = $suc;
            }
        }
        $fila['sucursales'] = $sucursales;

        $datos_array[] = $fila;
        }
        if (count($datos_array)<=0) {
            $query_datos['info'] = "Sin Registros";
        }
        echo json_encode($datos_array);
        die();
    }

    /**
     * @author Francisco Orozco
     * @since 20-12-2018
     * @return Obtener categorias.
    */
    public function obtener_categorias() {   
        if($_POST){
            //query
            $where['tia_padre']     = null;
            $where['tia_estado']    = 1;
            $like                   = null;
            if (isset($_POST['todos'])) { 
                if (is_numeric($_POST['todos']) && intval($_POST['todos']) == 0) { 
                    if (isset($_POST['id_categoria']) && intval($_POST['id_categoria'])) 
                    $where['tia_id'] = $_POST['id_categoria'];

                    if (isset($_POST['nombre_categoria'])) 
                        $like['tia_nombre'] = $this->clean_string($_POST['nombre_categoria']);

                    if (!isset($_POST['nombre_categoria']) && !isset($_POST['id_categoria'])) {
                        $datos_array['info'] = "Se esperaba nombre de la categoría o su id.";
                        echo json_encode($datos_array);
                        die();
                    }    

                    if (!intval($_POST['id_categoria']) && isset($_POST['id_categoria']) ) {
                        $datos_array['info'] = "Formato del id de la categoría es incorreto.";
                        echo json_encode($datos_array);
                        die();
                    }    
                } else if (is_numeric($_POST['todos']) && intval($_POST['todos']) == 1 ) {
                    $where                  = null;
                    $where['tia_padre']     = null;
                    $where['tia_estado']    = 1;
                } else {
                    $datos_array['info'] = "Formato incorrecto.";
                    echo json_encode($datos_array);
                    die();
                }
            } else {
                $datos_array['info'] = "Todos es requerido";
                echo json_encode($datos_array);
                die();
            }

            $campos = "
            tia_id AS id_categoria, 
            tia_nombre AS nombre_categoria, 
            tia_codigo AS codigo,
            IF ( ixr_id_tia IS NOT NULL,
                GROUP_CONCAT(DISTINCT CONCAT_WS('#', 
                    ixr_id_tia, 
                    imp_nombre,
                    IF(imp_porcentaje > 0, imp_porcentaje, imp_valor),
                    IF(imp_porcentaje > 0, 'porcentaje', 'valor') 
                ) SEPARATOR '@@')
            ,'') AS impuestos,
            GROUP_CONCAT(DISTINCT CONCAT_WS('#', 
                cxr_id_car, 
                car_nombre,
                IFNULL(car_codigo,'')
            ) SEPARATOR '@@') AS caracteriticas
            ";
            $query_datos = $this->cotizaciones_model->obtener_categorias($where,$like,$campos);
            $datos_array = array();            
            if (count($query_datos) > 0) {
                foreach ($query_datos as $fila) { 
                     //ordenar los impuestos
                    if (trim($fila['impuestos']) != "") {
                        $impuestos = explode('@@', trim($fila['impuestos']));
                        $impuestos_array = array();
                        for ($k=0; $k < count($impuestos) ; $k++) { 
                            $detalles = explode('#', $impuestos[$k]);
                            $impuesto['id_impuesto']          = $detalles[0];
                            $impuesto['nombre_impuesto']    = $detalles[1];
                            $impuesto['calculo_impuesto']   = $detalles[2];
                            $impuesto['tipo_impuesto']      = $detalles[3];
                            $impuestos_array[] = $impuesto;
                        }
                        $fila['impuestos'] = $impuestos_array; //reasignar
                    }

                    if (trim($fila['caracteriticas']) != "") {
                        $caracteriticas = explode('@@', trim($fila['caracteriticas']));
                        $caracteriticas_array = array();
                        for ($k=0; $k < count($caracteriticas) ; $k++) { 
                            $detalles = explode('#', $caracteriticas[$k]);
                            $caracteritica['id_caracteristica']     = $detalles[0];
                            $caracteritica['nombre_caracteristica'] = $detalles[1];
                            $caracteritica['codigo_caracteristica'] = $detalles[2];
                            $caracteriticas_array[] = $caracteritica;
                        }
                        $fila['caracteriticas'] = $caracteriticas_array; //reasignar
                    }
                    $datos_array[] = $fila;
                }
            }
            if (count($datos_array)<=0) {
                $datos_array['info'] = "Sin Registros";
            }
            $respuesta['info'] = "ok";
            $respuesta['respuesta'] = $datos_array;
            echo json_encode($respuesta);
            die();
        } else {
            $datos_array['info'] = "Acceso Denegado";
            echo json_encode($datos_array);
            die();
        }
    }

    /**
     * @author Francisco Orozco
     * @since 20-12-2018
     * @return Obtener subcategorias.
    */
    public function obtener_subcategorias() {   
        if($_POST){
            //query
            $where['tia_padre IS NOT NULL'] = NULL;
            $where['tia_estado']            = 1;
            $like                           = NULL;
            if (isset($_POST['todos'])) { 
                if (is_numeric($_POST['todos']) && intval($_POST['todos']) == 0) { 
                    if (isset($_POST['id_categoria_padre']) && intval($_POST['id_categoria_padre'])) 
                        $where['tia_padre'] = $_POST['id_categoria_padre'];

                    if (isset($_POST['id_subcategoria']) && intval($_POST['id_subcategoria'])) 
                        $where['tia_id'] = $_POST['id_subcategoria'];

                    if (isset($_POST['nombre_subcategoria'])) 
                        $like['tia_nombre'] = $this->clean_string($_POST['nombre_subcategoria']);

                    if (!isset($_POST['nombre_subcategoria']) && !isset($_POST['id_categoria_padre']) && !isset($_POST['id_subcategoria'])) {
                        $datos_array['info'] = "Se esperaba nombre de la subcategoría o id de subcategoría o id de la categoría padre.";
                        echo json_encode($datos_array);
                        die();
                    }    

                    if (!intval($_POST['id_categoria_padre']) && isset($_POST['id_categoria_padre']) ) {
                        $datos_array['info'] = "Formato del id de la categoría padre es incorreto.";
                        echo json_encode($datos_array);
                        die();
                    }   
                    
                    if (!intval($_POST['id_subcategoria']) && isset($_POST['id_subcategoria']) ) {
                        $datos_array['info'] = "Formato del id de la subcategoría es incorreto.";
                        echo json_encode($datos_array);
                        die();
                    }   
                } else if (is_numeric($_POST['todos']) && intval($_POST['todos']) == 1 ) {
                    $where                          = null;
                    $where['tia_estado']            = 1;
                    $where['tia_padre IS NOT NULL'] = NULL;
                } else {
                    $datos_array['info'] = "Formato incorrecto.";
                    echo json_encode($datos_array);
                    die();
                }
            } else {
                $datos_array['info'] = "Todos es requerido";
                echo json_encode($datos_array);
                die();
            }

            $campos = "
            tia_id AS id_subcategoria, 
            tia_nombre AS nombre_subcategoria, 
            tia_codigo AS codigo_subcategoria,
            IF ( ixr_id_tia IS NOT NULL,
                GROUP_CONCAT(DISTINCT CONCAT_WS('#', 
                    ixr_id_tia, 
                    imp_nombre,
                    IF(imp_porcentaje > 0, imp_porcentaje, imp_valor),
                    IF(imp_porcentaje > 0, 'porcentaje', 'valor') 
                ) SEPARATOR '@@')
            ,'') AS impuestos_subcategoria,
            GROUP_CONCAT(DISTINCT CONCAT_WS('#', 
                cxr_id_car, 
                car_nombre,
                IFNULL(car_codigo,'')
            ) SEPARATOR '@@') AS caracteriticas_subcategoria
            ";
            $query_datos = $this->cotizaciones_model->obtener_categorias($where,$like,$campos);
            $datos_array = array();            
            if (count($query_datos) > 0) {
                foreach ($query_datos as $fila) { 
                     //ordenar los impuestos
                    if (trim($fila['impuestos_subcategoria']) != "") {
                        $impuestos = explode('@@', trim($fila['impuestos_subcategoria']));
                        $impuestos_array = array();
                        for ($k=0; $k < count($impuestos) ; $k++) { 
                            $detalles = explode('#', $impuestos[$k]);
                            $impuesto['id_impuesto']          = $detalles[0];
                            $impuesto['nombre_impuesto']    = $detalles[1];
                            $impuesto['calculo_impuesto']   = $detalles[2];
                            $impuesto['tipo_impuesto']      = $detalles[3];
                            $impuestos_array[] = $impuesto;
                        }
                        $fila['impuestos_subcategoria'] = $impuestos_array; //reasignar
                    }

                    if (trim($fila['caracteriticas_subcategoria']) != "") {
                        $caracteriticas = explode('@@', trim($fila['caracteriticas_subcategoria']));
                        $caracteriticas_array = array();
                        for ($k=0; $k < count($caracteriticas) ; $k++) { 
                            $detalles = explode('#', $caracteriticas[$k]);
                            $caracteritica['id_caracteristica']     = $detalles[0];
                            $caracteritica['nombre_caracteristica'] = $detalles[1];
                            $caracteritica['codigo_caracteristica'] = $detalles[2];
                            $caracteriticas_array[] = $caracteritica;
                        }
                        $fila['caracteriticas_subcategoria'] = $caracteriticas_array; //reasignar
                    }
                    $datos_array[] = $fila;
                }
            }
            if (count($datos_array)<=0) {
                $datos_array['info'] = "Sin Registros";
            }
            $respuesta['info'] = "ok";
            $respuesta['respuesta'] = $datos_array;
            echo json_encode($respuesta);
            die();
        } else {
            $datos_array['info'] = "Acceso Denegado";
            echo json_encode($datos_array);
            die();
        }
    }

    /**
     * @author Francisco Orozco
     * @since 20-12-2018
     * @return Obtener productos por subcategorias.
    */
    public function obtener_productos_subcategorias() {  
        $where['tia_padre IS NOT NULL'] = NULL;
        $where['tia_estado']            = 1;
        $where['cva_defecto']           = 1;
        $like                           = NULL; 
        if($_POST){
            if (isset($_POST['todos'])) {
                if (is_numeric($_POST['todos']) && intval($_POST['todos']) == 0) { 
                    if (isset($_POST['id_subcategoria']) && intval($_POST['id_subcategoria'])) 
                        $where['tia_id'] = $_POST['id_subcategoria'];

                    if (isset($_POST['nombre_subcategoria'])) 
                        $like['tia_nombre'] = $this->clean_string($_POST['nombre_subcategoria']);
                    
                    if (!isset($_POST['nombre_subcategoria']) && !isset($_POST['id_subcategoria'])) {
                        $datos_array['info'] = "Se esperaba nombre de la subcategoría o id de subcategoría.";
                        echo json_encode($datos_array);
                        die();
                    }   
                    
                    if (!intval($_POST['id_subcategoria']) && isset($_POST['id_subcategoria']) ) {
                        $datos_array['info'] = "Formato del id de la subcategoría es incorreto.";
                        echo json_encode($datos_array);
                        die();
                    }   
                } else if (is_numeric($_POST['todos']) && intval($_POST['todos']) == 1 ) {
                    $where                          = null;
                    $where['tia_estado']            = 1;
                    $where['tia_padre IS NOT NULL'] = NULL;
                    $where['cva_defecto']           = 1;
                } else {
                    $datos_array['info'] = "Formato incorrecto.";
                    echo json_encode($datos_array);
                    die();
                }
            } else {
                $datos_array['info'] = "Todos es requerido";
                echo json_encode($datos_array);
                die();
            }

            $campos = "
            art_id AS id_producto,
            art_codigo AS codigo_producto,
            art_nombre AS nombre_producto,
            mrp_id AS id_marca,
            mrp_nombre AS nombre_marca,
            mep_nombre AS nombre_medida,
            art_sinonimo AS sinonimo_producto,
            art_descripcion AS descripcion_producto,
            art_foto AS url_imagen_producto,
            art_minimo AS cantidad_minima_producto
            ";
            $query_datos = $this->cotizaciones_model->obtener_productos($where,$like,$campos);            
            $datos_array = array();
            if (count($query_datos) > 0) {
                foreach ($query_datos as $fila) { 
                    if (  $fila['url_imagen_producto'] != "") {
                        $fila['url_imagen_producto'] = base_url('assets/uploads/images/' . $fila['url_imagen_producto']);
                    }
                    $datos_array[] = $fila;
                }
            } 
            if (count($datos_array)<=0) {
                $datos_array['info'] = "Sin Registros";
            }
            $respuesta['info'] = "ok";
            $respuesta['respuesta'] = $datos_array;
            echo json_encode($respuesta);
            die();
        } else {
            $datos_array['info'] = "Acceso Denegado";
            echo json_encode($datos_array);
            die();
        }
    }

    /**
     * @author Francisco Orozco
     * @since 02-01-2019
     * @return Obtener detalle de productos 
    */
    public function obtener_detalle_producto() {  
        if($_POST){
            if ( isset($_POST['id_producto']) ) { 
                if (is_numeric($_POST['id_producto']) && intval($_POST['id_producto']) > 0) { 
                    $where['art_id'] = $_POST['id_producto'];                
                } else {
                    $datos_array['info'] = "Formato incorrecto.";
                    echo json_encode($datos_array);
                    die();
                }
                $campos = "
                art_id AS id_producto,
                art_codigo AS codigo_producto,
                art_nombre AS nombre_producto,
                mrp_id AS id_marca,
                mrp_nombre AS nombre_marca,
                mep_nombre AS nombre_medida,
                art_sinonimo AS sinonimo_producto,
                art_descripcion AS descripcion_producto,
                art_foto AS url_imagen_producto,
                art_minimo AS cantidad_minima_producto,
                GROUP_CONCAT(DISTINCT CONCAT_WS('#', 
                    cxr_id_car, 
                    car_nombre,
                    IFNULL(cxu_valor,'')
                ) SEPARATOR '@@') AS caracteriticas_producto,
                GROUP_CONCAT(DISTINCT CONCAT_WS('#', 
                    cva_id_mep, 
                    mep_nombre,
                    cva_conversion,
                    cva_defecto
                ) SEPARATOR '@@') AS medida_producto,
                GROUP_CONCAT(DISTINCT CONCAT_WS('#', 
                    gia_id, 
                    gia_url
                ) SEPARATOR '@@') AS imagenes_producto
                ";
                $query_datos = $this->cotizaciones_model->obtener_productos($where,$like,$campos);            
                $datos_array = array();  
                if (count($query_datos) > 0) {
                    foreach ($query_datos as $fila) { 
                        //ordenar caracteristicas
                        if (trim($fila['caracteriticas_producto']) != "") {
                        $caracteriticas             = explode('@@', trim($fila['caracteriticas_producto']));
                            $caracteriticas_array   = array();
                            for ($k=0; $k < count($caracteriticas) ; $k++) { 
                                $detalles = explode('#', $caracteriticas[$k]);
                                $caracteritica['id_caracteristica']     = $detalles[0];
                                $caracteritica['nombre_caracteristica'] = $detalles[1];
                                $caracteritica['valor_caracteristica']  = $detalles[2];
                                $caracteriticas_array[] = $caracteritica;
                            }
                            $fila['caracteriticas_producto'] = $caracteriticas_array; //reasignar
                        }
                        //ordenar medidas
                        if (trim($fila['medida_producto']) != "") {
                            $medidas        = explode('@@', trim($fila['medida_producto']));
                            $medidas_array  = array();
                            for ($k=0; $k < count($medidas) ; $k++) { 
                                $detalles = explode('#', $medidas[$k]);
                                $medida['id_medida']        = $detalles[0];
                                $medida['nombre_medida']    = $detalles[1];
                                $medida['conversion']       = $detalles[2];
                                $medida['defecto']          = $detalles[3];
                                $medidas_array[]            = $medida;
                            }
                            $fila['medida_producto'] = $medidas_array; //reasignar
                        }
                        //ordenar imagenes                      
                        if (trim($fila['imagenes_producto']) != "") {
                            $imagenes       = explode('@@', trim($fila['imagenes_producto']));
                            $imagenes_array = array();
                            for ($k=0; $k < count($imagenes) ; $k++) { 
                                $detalles = explode('#', $imagenes[$k]);
                                $imagen['id_magen']     = $detalles[0];
                                if ( $detalles[1] != "") {
                                    $imagen['url_imagen'] = base_url('assets/uploads/images/' . $detalles[1]);
                                } else {
                                    $imagen['url_imagen']  = "";
                                }
                                $imagenes_array[]       = $imagen;
                            }
                            $fila['imagenes_producto'] = $imagenes_array; //reasignar
                        }
                        $datos_array[] = $fila;
                    }
                } 
                if (count($datos_array)<=0) {
                    $datos_array['info'] = "Sin Registros";
                }
                $respuesta['info'] = "ok";
                $respuesta['respuesta'] = $datos_array;
                echo json_encode($respuesta);
                die();      
            } else {
                $datos_array['info'] = "Se esperaba el id del producto.";
                echo json_encode($datos_array);
                die();
            }
        } else {
            $datos_array['info'] = "Acceso Denegado";
            echo json_encode($datos_array);
            die();
        }
    }
    
    /**
     * @author Francisco Orozco
     * @since 21-12-2018
     * @return Limpiar de caracteres raros una cadena(string)
     */
    function clean_string($string="",$sustituto_espacio="_"){

        $string = trim($string);

        //Esta parte se encarga de eliminar cualquier caracter extraño
        $string = str_replace(
            array("\\", "¨", "º", "-", "~","*",
                "#", "@", "|", "!", "\"",
                "·", "$", "%", "&", "/",
                "(", ")", "?", "'", "¡",
                "¿", "[", "^", "`", "]",
                "+", "}", "{", "¨", "´",
                ">", "< ", ";", ",", ":",
                "."),
            "$sustituto_espacio",
            $string
        );
        return $string;
    }

} // End class
