<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Transacciones
 * @author Alexis Beltran
 * 
 * @package   
 * @author erpConamype
 * @copyright satelite
 * @version 2013
 * @access public
 */
class Transacciones extends CI_Controller {

    /**
     * Transacciones::__construct()
     * 
     * @return
     */
    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('consultas');
        $this->load->model('utm_model');
        $this->load->model('gsatelite');
        //	ob_end_clean();
    }

    /**
     * Transacciones::index()
     * 
     * @return
     */
    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    /**
     * Transacciones::tra_consulta()
     * @author Alexis Beltran
     * 
     * @return
     */
    function tra_consulta() {
        redirect('utm/cuentas/tra_consulta');
        //die();
        $crud = new grocery_CRUD;
        $crud->set_table('tra_transaccion');
        $crud->set_subject('Transacción');
        $crud->unset_edit();
        $crud->columns('Orden', 'tra_id_cub', 'tra_fecha', 'tra_id_ttb','Número de cheque', 'tra_monto', 'Saldo');
        $crud->fields('tra_id_cub', 'tra_fecha', 'tra_id_ttb', 'tra_monto');
        $crud->add_action('Editar', '', 'utm/transacciones/editar_transaccion', 'icomoon-icon-pencil-5');

        $crud->display_as('tra_id_cub', 'Cuenta Bancaria')
                ->display_as('tra_id_ttb', 'Tipo')
                ->display_as('tra_fecha', 'Fecha de transacción')
                ->display_as('tra_monto', 'Monto')
                ->display_as('Orden', 'Nº')


                //->callback_column('tra_monto',array($this,'_format_money'))
                ->callback_column('tra_fecha', array($this, '_format_date'))
                ->callback_column('Orden', function($key, $row) {
                    $cub = $row->tra_id_cub;
                    $fila = $row->tra_id;

                    $query = $this->db->query("select COUNT(*) orden from tra_transaccion where tra_id_cub=$cub and tra_id<=$fila")->row_array();
                    return $query["orden"];
                })
                ->callback_column('Número de cheque', function($key, $row) {
                    $fila = $row->tra_id;
                    $query = $this->db->query("SELECT che_numero from che_cheque where che_id_tra = $fila")->row_array();
                    if(count($query)>0){
                      return $query["che_numero"];
                    }else{
                      return '';
                    }
                })

                /* --------------------Inicia calculo saldo-------------- */
                ->callback_column('Saldo', function($key, $row) {

                    $cuenta = $row->tra_id_cub;
                    $tra_id = $row->tra_id;
                    $monto_tran = $row->tra_monto;
                    $monto = number_format($monto_tran, 2);

                    $dbl_monto = number_format($monto_tran, 2);
                    $query = $this->db->select('saldo, tra_monto, cub_saldo_inicial, SUM(tra_monto) as suma')
                            ->from('vw_cuentas_bancarias')
                            ->join('tra_transaccion', 'vw_cuentas_bancarias.cub_id=tra_transaccion.tra_id_cub')
                            ->join('cub_cuenta_bancaria', 'tra_id_cub=cub_cuenta_bancaria.cub_id')
                            ->where('tra_id_cub', $cuenta)
                            ->where('tra_id <=', $tra_id)
                            ->get();
                    $resultado = $query->row_array();

                    $sld = ($resultado['cub_saldo_inicial'] + $resultado['suma']);
                    $saldo_final = number_format($sld, 2);

                    return $saldo_final;
                })
        /* ------------------------------------------------------------------ */
        ;

        ///***************** Primer y Último día del mes  ************************///      
        $mes = date('m');
        $year = date('Y');
        $dia = date("d", mktime(0, 0, 0, $mes + 1, 0, $year));

        $primer_dia = date('Y-m-d', mktime(0, 0, 0, $mes, 1, $year));
        $ultimo_dia = date('Y-m-d', mktime(0, 0, 0, $mes, $dia, $year));
        /************************************************************************ */

        if (($cub_id = $this->input->get('cub_id')) > 0) {
            $crud->where('tra_id_cub', $cub_id);
            if (($fecha_desde = $this->input->get('fecha_desde')) <> '' && ($fecha_hasta = $this->input->get('fecha_hasta')) <> '') {
                $fecha_desde1 = date('Y-m-d', strtotime($fecha_desde));
                $fecha_hasta1 = date('Y-m-d', strtotime($fecha_hasta));
                $crud->where('tra_fecha >=', $fecha_desde1 . ' 00:00:00');
                $crud->where('tra_fecha <= ', $fecha_hasta1 . ' 23:23:59');
            }
        } else {

            $crud->where('tra_fecha >= ', $primer_dia . ' 00:00:00');
            $crud->where('tra_fecha <= ', $ultimo_dia . ' 23:23:59');
        }

        $crud->set_primary_key('cub_id', 'vw_cuentas_bancarias')
                ->set_relation('tra_id_cub', 'vw_cuentas_bancarias', 'cuenta');

        $crud->set_relation('tra_id_ttb', 'ttb_tipo_transact_bancaria', 'ttb_nombre');


        $crud->set_language('spanish');
        $crud->unset_print();
        $crud->unset_export();
        $output = $crud->render();

        $cuentas[0] = 'Seleccione';
        foreach ($this->db->get('vw_cuentas_bancarias')->result() as $row) {
            $cuentas[$row->cub_id] = $row->cuenta;
        }

        

        $data = array(
            'cuentas' => $cuentas,
            'titulo_personal' => "Consulta de transacciones"
        );

        $this->_cargarvista($data, $output);
    }

    /**
     * Transacciones::tra_deposito()
     * @author Alexis Beltran
     * 
     * @return
     */
    function tra_deposito() {
        $this->_cargarvista(0, 0);
    }

    /**
     * Transacciones::tra_retiro()
     * @author Alexis Beltran
     * 
     * @return
     */
    function tra_retiro() {
        $this->_cargarvista(0, 0);
    }

    /**
     * Transacciones::tra_add()
     * @author Alexis Beltran
     * 
     * @return
     */
    function tra_add() {
        if ($_POST) {
            $tipo_transaccion = $this->gsatelite->get_registro('ttb_tipo_transact_bancaria', array('ttb_id' => $_POST['tra_tipo']));
            $cuenta_origen = $tipo_transaccion->ttb_id_ttb_retiro;
            $cuenta_destino = $tipo_transaccion->ttb_id_ttb_deposito;
            $registro_cub = $this->gsatelite->get_tabla('cub_cuenta_bancaria',array('cub_id'=>$this->input->post('cub_id')));//"CUENTA ORIGEN"
            //$tipos_proceso=$this->inventario_model->cargar_registro('tip_tipo_proceso','tip_id',$proceso);
            if ($this->input->post('cub_id') > 0 && $this->input->post('tra_fecha') && $this->input->post('monto') > 0.0) {
                //verificamos si hay fondos
                $row = $this->db->get_where('vw_cuentas_bancarias', "cub_id = " . $this->input->post('cub_id'), 1)->row();
                //SI NO ES DEPOSITO Y EL MONTO > SALDO Y NO PERMITE SOBREGIRO
                if ($tipo_transaccion->ttb_deposito != 1 && $row->saldo < $this->input->post('monto') && $registro_cub[0]['cub_permite_sobregiro'] != 1 ) {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Aviso", 'texto_alerta' => "El Monto a ejecutar es mayor del disponible.");
                    $this->session->set_flashdata($alerta);
                    redirect('utm/cuentas/tra_transferencia');
                }
                //Transaccion Origen
                $origen = array(
                    'tra_id_cub' => $this->input->post('cub_id'),
                    'tra_id_ttb' => ($tipo_transaccion->ttb_transferencia == 1) ? $cuenta_origen : $this->input->post('tra_tipo'),
                    'tra_fecha' => date("Y-m-d H:i:s", strtotime($this->input->post('tra_fecha') . date('H:i:s'))),
                    'tra_operacion' => $this->input->post('operacion'),
                    'tra_monto' => ($tipo_transaccion->ttb_deposito == 1) ? $this->input->post('monto') : -$this->input->post('monto'),
                    'tra_comprobante' => $this->input->post('comprobante'),
                    'tra_estado' => 1,
                    'tra_fecha_crea' => date('Y-m-d H:i:s'),
                    'tra_usu_crea' => $this->tank_auth->get_user_id(),
                    'tra_fecha_mod' => date('Y-m-d H:i:s'),
                    'tra_usu_mod' => $this->tank_auth->get_user_id(),
                    'tra_aplicar' => ($this->input->post('aplicar')) ? 1 : 0
                );
                $registro = $this->gsatelite->ingresar('tra_transaccion', $origen);
                $registroSegunda = 0;
                //Transferencia Destino (SI VIENE CUENTA DESTINO ES UNA TRANSFERENCIA ENTRE CUENTAS)
                if ($tipo_transaccion->ttb_transferencia == 1 AND  $this->input->post('cub_destino') > 0 ) {
                    $destino = array(
                        'tra_id_cub' => $this->input->post('cub_destino'),
                        'tra_id_ttb' => $cuenta_destino,
                        'tra_fecha' => date("Y-m-d H:i:s", strtotime($this->input->post('tra_fecha') . date('H:i:s'))),
                        'tra_operacion' => $this->input->post('operacion'),
                        'tra_monto' => $this->input->post('monto'),
                        'tra_comprobante' => $this->input->post('comprobante'),
                        'tra_estado' => 1,
                        'tra_fecha_crea' => date('Y-m-d H:i:s'),
                        'tra_usu_crea' => $this->tank_auth->get_user_id(),
                        'tra_fecha_mod' => date('Y-m-d H:i:s'),
                        'tra_usu_mod' => $this->tank_auth->get_user_id(),
                        'tra_aplicar' => ($this->input->post('aplicar')) ? 1 : 0
                    );
                    $registroSegunda = $this->gsatelite->ingresar('tra_transaccion', $destino);
                }
                
                //SE GENERA LA PARTIDA MANUAL O AUTOMATICA
                // SI NO SE HA HECHO UNA PARTIDA MANUAL, EL CONTADOR SOLO CONTO LA FILA "DE TITULO", SI VIENEN MAS SE RESPETA ESA PARTIDA 
                if($this->input->post('contador_det_partida') > 1){
                    $permite_generar = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_BANCO');
                    if($permite_generar == 1 && $registro > 0 && ($this->input->post('cub_destino') == 0 || $registroSegunda > 0)){
                        //Se verifica el parametro generar partida y para las transferencias se verifica que se haya ingresado tambien la segunda transacccion
                        $this->load->library('../controllers/modulo_contabilidad/procesos');
                        //Preparando arreglo
                        $array_partida_manual = [];

                        //$array_partida_manual['id_prc'] = $this->input->post('id_prc');
                        $array_partida_manual['concepto_gral'] = $this->input->post('concepto_gral');
                        //$array_partida_manual['volver'] = $this->input->post('volver');
                        $array_partida_manual['tipo'] = $this->input->post('tipo');
                        $array_partida_manual['fecha'] = $this->input->post('fecha');
                        $array_partida_manual['cuenta'] = $this->input->post('cuenta');
                        $array_partida_manual['debe'] = $this->input->post('debe');
                        $array_partida_manual['haber'] = $this->input->post('haber');
                        $array_partida_manual['contador_det_partida'] = $this->input->post('contador_det_partida');
                        $array_partida_manual['validacion_det_partida'] = $this->input->post('validacion_det_partida');
                        $array_partida_manual['slcCntOculto'] = $this->input->post('slcCntOculto');
                        $array_partida_manual['detalle_c'] = $this->input->post('detalle_c');
                        $array_partida_manual['detalle_d'] = $this->input->post('detalle_d');
                        $array_partida_manual['detalle_h'] = $this->input->post('detalle_h');
                        $array_partida_manual['detalle_con'] = $this->input->post('detalle_con');
                        $array_partida_manual['total_debe'] = $this->input->post('total_debe');
                        $array_partida_manual['total_haber'] = $this->input->post('total_haber');
                        $array_partida_manual['idtrans'] = $registro;//Origen
                        $array_partida_manual['proceso'] = 'banco_trasferencia';
                        if ($registroSegunda > 0) {
                            $array_partida_manual['idtrans_dest'] = $registroSegunda;//Destino
                        }                        
                        //print_r($array_partida_manual); die();
                        $this->procesos->agregar_partida($array_partida_manual);
                    }
                }else{
                    //Se genera la partida de la transaccion
                    $this->generar_partida_contable_transaccion($registro, $registroSegunda);    
                }
                if ($registro > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Aviso", 'texto_alerta' => "Se ha registrado con exito la transacción.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Aviso", 'texto_alerta' => "Error al aprocesar la transacción. Valores Incorectos.");
                }
                $this->session->set_flashdata($alerta);

                $redir = $this->input->post('tipo_btn');
                if ($redir == 1) {
                    redirect('utm/cuentas/tra_transferencia');
                } else {
                    redirect('utm/cuentas/transacciones');
                }
            } // Fin del if validaro
        } // Fin del post
    }

    /**
     * Transacciones::tra_transferencia()
     * @author Alexis Beltran
     * 
     * @return
     */
    function tra_transferencia() {
        redirect('utm/cuentas/tra_transferencia');
        //tipo_cuenta
        $tipo_cuentas[0] = 'seleccione';

        //cuentas
        $cuentas[0] = 'Seleccione';
        foreach ($this->db->get('vw_cuentas_bancarias')->result() as $row) {
            $cuentas[$row->cub_id] = $row->cuenta . "  ($ $row->saldo )";
        }

        //Tipos
        $tipos = $this->gsatelite->get_tabla('ttb_tipo_transact_bancaria', array('ttb_estado' => 1));

        $data = array(
            'cuentas' => $cuentas,
            'tipos' => $tipos,
            'titulo_personal' => "Agregar transacción"
        );
        //var_dump($data); die();
        $this->_cargarvista($data, 0);
    }

    function conciliacion($consulta = null) {
		redirect('utm/cuentas/conciliacion');
        $permisos = $this->gsatelite->get_permisos_opcion('utm/transacciones/conciliacion');

        if ($_POST) {
            if ($consulta != null) {
                $post_array = $this->input->post();
                $data = null;

                $cuenta         = $post_array['cuenta'];
                $estado         = $post_array['estado'];
               
                $where = null;
                if ($cuenta > 0) {
                    $where['cub_id'] = $cuenta;
                }
                if ($estado != '') {
                    $where['tra_conciliado'] = $estado;
                }

                $data['conciliaciones'] = $this->utm_model->get_conciliaciones($where);
               
                $html = $this->load->view('utm/transacciones/consultar_conciliaciones', $data, true);

                echo $html;
                die();
            }
        }

        //$cuentas[0] = 'Seleccione';
        foreach ($this->db->get('vw_cuentas_bancarias')->result() as $row) {
            $cuentas[$row->cub_id] = $row->cuenta;
        }

        $data = array(
            'cuentas' => $cuentas
        );

        $data['conciliaciones'] = $this->utm_model->get_conciliaciones(array('tra_conciliado' => 0));
        //var_dump($data['conciliaciones']);die();
        $data['titulo_personal'] = "Conciliación";
        $this->_cargarvista($data);
    }

    function conciliar($tra_id = null, $revetir = null) {
        if ($this->input->post()) {
            $post_array = $this->input->post();
            $transacciones = $post_array['transaccion'];
            $conciliar = $post_array['conciliar'];
            $aplicar = $post_array['aplicar'];

            if (count($transacciones) > 0) {
                for ($i = 0; $i < count($transacciones); $i++) {
                    $transaccion_array[] = array(
                        'tra_id' => $transacciones[$i],
                        'tra_conciliado' => $conciliar[$i],
                        'tra_aplicar' => $aplicar[$i],
                        'tra_fecha_mod' => date('Y-m-d H:i:s'),
                        'tra_usu_mod' => $this->tank_auth->get_user_id()
                    );
                }
            }

            @$this->db->update_batch('tra_transaccion', $transaccion_array, 'tra_id');
        }

        /* if ($tra_id) {
          $this->db->update('tra_transaccion', array('tra_conciliado' => 1), array('tra_id' => $tra_id));
          }
          $cub_id = $this->input->get('cub_id');
          $link = ($cub_id > 0) ? '?cub_id=' . $cub_id : ''; */
        $link = '';
        $this->gsatelite->show_dialog('Conciliación Realizada con éxito.', base_url("utm/transacciones/conciliacion{$link}"));
    }

    function mostrar_cuentas() {
        $option = "";
        $tipo_cuenta = $this->input->post('tipo');
        $var = "<option value='0'>seleccione una opcion</option>";
        $cuentas_bancarias = $this->consultas->cuentas_x_clasificacion($tipo_cuenta);
        foreach ($cuentas_bancarias as $key) {
            $var .= "<option value='" . $key['cub_id'] . "'>" . $key['ban_nombre'] . ': ' . $key['cub_numero'] . "</option>";
        }

        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function _format_money($valor) {
        return '<span style="display: inline-block">$</span><div style="display: inline-block;float: right;">' . number_format($valor, 2) . '</div>';
    }

    /**
     * Transacciones::_format_date()
     * @author Alexis Beltran
     * 
     * @param mixed $valor
     * @return
     */
    function _format_date($valor) {
        $date = new DateTime($valor);
        return '<div>' . $date->format('d/m/Y') . '</div>';
        //return '<div style="display: inline-block;float: right;">' . $date->format('d/m/Y') . '</div>';
    }

    function editar_transaccion($id_trans, $ver=null) {
        //tipo_cuenta
        $tipo_cuentas[0] = 'seleccione';

        $transaccion = $this->gsatelite->get_tabla('tra_transaccion', array('tra_id' => $id_trans));
        $id_cub = $transaccion[0]['tra_id_cub'];
        $id_ttb = $transaccion[0]['tra_id_ttb'];

        //die(print_r($transaccion));

        /*         * ******* cuentas en caso de mostrar un dropdown ***************** */
        $cuentas[0] = 'Seleccione';
        foreach ($this->db->get('vw_cuentas_bancarias')->result() as $row) {
            $cuentas[$row->cub_id] = $row->cuenta . "  ($ $row->saldo )";
        }
        /*         * **************************************************************** */

        $cub_select = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $id_cub))->row();
        $cuenta_select = $cub_select->cuenta . "  ($ $cub_select->saldo )";

        //Tipo de transacción seleccionada
        // $this->db->where('ttb_id = 1 OR ttb_id = 2');
        $tipos = $this->gsatelite->get_tabla('ttb_tipo_transact_bancaria', array('ttb_estado' => 1));

        $data = array(
            'cuentas' => $cuentas,
            'tipos' => $tipos,
            'cub' => $id_cub,
            // 'clc' => $id_clc,
            'id_ttb' => $id_ttb,
            'transaccion' => $transaccion,
            'id_trans' => $id_trans,
            'cub_selec' => $cuenta_select
        );
        
        $data['ver'] = ($ver != null) ? 'disabled="disabled"' : '';
        if($ver!=null){
            $data['titulo_personal'] =  "Ver transacción";
            $this->gsatelite->cargar_vista_masterpage('utm/transacciones/editar_transaccion', $data, true);
        }else{
            $data['titulo_personal'] = "Editar transacción";
            $this->_cargarvista($data, 0);
        }
    }

    function actualizar_transaccion() {
        if ($_POST) {
            $tipo_transaccion = $this->gsatelite->get_registro('ttb_tipo_transact_bancaria', array('ttb_id' => $_POST['tra_tipo']));
            $cuenta_origen = $tipo_transaccion->ttb_id_ttb_retiro;
            $cuenta_destino = $tipo_transaccion->ttb_id_ttb_deposito;

            //$tipos_proceso=$this->inventario_model->cargar_registro('tip_tipo_proceso','tip_id',$proceso);
            if ($this->input->post('cub_id') > 0 && $this->input->post('fecha') && $this->input->post('monto') > 0.0) {
                //verificamos si hay fondos
                $row = $this->db->get_where('vw_cuentas_bancarias', "cub_id = " . $this->input->post('cub_id'), 1)->row();
                if ($tipo_transaccion->ttb_deposito != 1 && $row->saldo < $this->input->post('monto')) {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Aviso", 'texto_alerta' => "El Monto a ejecutar es mayor del disponible.");
                    $this->session->set_flashdata($alerta);
                    redirect('utm/transacciones/tra_transferencia');
                }

                $id_trans = $this->input->post('id_trans');
                //Transaccion Origen
                $origen = array(
                    'tra_id_cub' => $this->input->post('cub_id'),
                    'tra_id_ttb' => ($tipo_transaccion->ttb_transferencia == 1) ? $cuenta_origen : $this->input->post('tra_tipo'),
                    'tra_fecha' => date("Y-m-d H:i:s", strtotime($this->input->post('fecha') . date('H:i:s'))),
                    'tra_operacion' => $this->input->post('operacion'),
                    'tra_monto' => ($tipo_transaccion->ttb_deposito == 1) ? $this->input->post('monto') : -$this->input->post('monto'),
                    'tra_comprobante' => $this->input->post('comprobante'),
                    'tra_estado' => 1,
                    'tra_fecha_mod' => date('Y-m-d H:i:s'),
                    'tra_usu_mod' => $this->tank_auth->get_user_id(),
                    'tra_aplicar' => ($this->input->post('aplicar')) ? 1 : 0
                );
                $registro = $this->gsatelite->actualizar_array('tra_transaccion', $origen, array('tra_id' => $id_trans));

                //Transferencia Destino
                if ($tipo_transaccion->ttb_transferencia == 1) {
                    $destino = array(
                        'tra_id_cub' => $this->input->post('cub_destino'),
                        'tra_id_ttb' => $cuenta_destino,
                        'tra_fecha' => date("Y-m-d H:i:s", strtotime($this->input->post('fecha') . date('H:i:s'))),
                        'tra_operacion' => $this->input->post('operacion'),
                        'tra_monto' => $this->input->post('monto'),
                        'tra_comprobante' => $this->input->post('comprobante'),
                        'tra_estado' => 1,
                        'tra_fecha_mod' => date('Y-m-d H:i:s'),
                        'tra_usu_mod' => $this->tank_auth->get_user_id(),
                        'tra_aplicar' => ($this->input->post('aplicar')) ? 1 : 0
                    );
                    $registro = $this->gsatelite->actualizar_array('tra_transaccion', $destino, array('tra_id' => $id_trans));
                }

                if ($registro > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Aviso", 'texto_alerta' => "Se ha registrado con exito la transacción.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Aviso", 'texto_alerta' => "Error al aprocesar la transacción. Valores Incorectos.");
                }

                $this->session->set_flashdata($alerta);

                $redir = $this->input->post('tipo_btn');
                if ($redir == 1) {
                    redirect('utm/cuentas/editar_transaccion/' . $id_trans);
                } else {
                    redirect('utm/cuentas/transacciones');
                }
            } // Fin del if validaro
        } // Fin del post
    }

    public function comprobar_monto() {
        $monto = $this->input->post('monto');
        $id_cub = $this->input->post('cuenta');
        $tip_tran = $this->input->post('tipo');
        $obt_saldo = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $id_cub))->row();
            
        $obt_min = $this->db->get_where('cub_cuenta_bancaria', array('cub_id' => $id_cub))->row();

        $tipo_transaccion = $this->gsatelite->get_registro('ttb_tipo_transact_bancaria', array('ttb_id' => $tip_tran));



        $saldo = $obt_saldo->saldo;
        $minimo = $obt_min->cub_saldo_minimo;
        $saldo_final = $saldo - $minimo;
        $respp = $tipo_transaccion->ttb_deposito;

     
        if ($respp != 1) {
            if ($monto < $saldo_final || $monto == $saldo_final || $obt_min->cub_permite_sobregiro == 1 ) {
                $respues = ($monto < $saldo_final || $monto == $saldo_final)? 0:(($obt_min->cub_permite_sobregiro == 1)? 2:1);
                echo json_encode(array('resp' => $respues, 'tipo' => $respp));
            } else {
                echo json_encode(array('resp' => 1, 'res' => $respp));
            }
        }
         else {
            echo json_encode(array('resp' => 0, 'res' => $respp, 'res1' => $minimo));
        }
    }

    function _callback_acciones_conciliacion($primary_key, $row) {

        if ($row->tra_conciliado == 1) {
            return base_url('conciliar/' . $row->tra_id . '/1');
        } else {
            return base_url('conciliar/' . $row->tra_id);
        }
    }

    /**
     * Transacciones::_cargarvista()
     * 
     * @param integer $data
     * @param integer $crud
     * @return
     */
    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }
    
    /*
    * @author Mario Marquez
    * @since 2018-08-29
    * @param id de las transacciones "principal": Primera Transaccion Deposito/Retiro. "Secundaria": Segunda cuenta en transferencias
    */
    
    public function generar_partida_contable_transaccion($tra_id_principal, $tra_id_secundaria) {
        $transaccion_data = $this->utm_model->get_conciliaciones_bancarias(array('tra_id' => $tra_id_principal));
        $trans_secundaria = $this->utm_model->get_conciliaciones_bancarias(array('tra_id' => $tra_id_secundaria));
        // var_dump($transaccion_data);var_dump($trans_secundaria); die(); //////////////////

        //Obtener tipo de partida
        $tipo_partida_id = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('INGRESO'));

        //Se genera correlativo y codigo de partida
        $tipo_abr = $this->gsatelite->get_campo('tpd_tipo_partida', 'tpd_prefijo', array('tpd_id' => $tipo_partida_id));
        $corr = $this->db->select('IFNULL(MAX(pct_correlativo)+1,1) as correlativo', false)->from('pct_partida_contable')->get()->row();
        $numero = str_pad($corr->correlativo, 5, '0', STR_PAD_LEFT);
        $codigoPartida = $tipo_abr . '-' . $numero;

        //Obtener concepto de la partida contable
        $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 15)); //Id Partida Banco Transacción
        if (count($pct_concepto) > 0) {
            $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
        } else {
            $pct_concepto = 'Concepto no definido';
        }
        if ($tra_id_secundaria > 0) {
            $concepto_ptda = 'Partida Banco Transferencia - De Cuenta Bancaria - ' . $transaccion_data[0]['cub_numero'] . ' - A Cuenta Bancaria - ' . $trans_secundaria[0]['cub_numero'];
            $concepto_deta = 'Partida Banco Transferencia - De Cuenta - ' . $transaccion_data[0]['cub_numero'] . ' - A Cuenta - ' . $trans_secundaria[0]['cub_numero'];
        } else {
            $concepto_ptda = $pct_concepto . ' - Cuenta Bancaria - ' . $transaccion_data[0]['cub_numero'];
            $concepto_deta =  $pct_concepto;
        }

        /*         * ************************************Parte Debe***************************************** */
        //Se ha definido tipo de cuenta de CAJA siempre sin importar el tipo de pago
        $tipo_cuenta_debe = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('BANCOS'));

        if ($tra_id_secundaria > 0) {
            $cuentas_debe = $this->utm_model->get_cuenta_contable_transaccion($tra_id_secundaria, $tipo_cuenta_debe);
        } else {
            $cuentas_debe = $this->utm_model->get_cuenta_contable_transaccion($tra_id_principal, $tipo_cuenta_debe);
        }

        //Total de la partida
        $totalPartida = array_sum(array_column($cuentas_debe, 'total_abonar'));

        //Ingreso en la pct_partida contable
        $array_partida = array(
            'pct_id_tpd' => $tipo_partida_id,
            'pct_id_prc' => null,
            'pct_concepto' => $concepto_ptda,
            'pct_modulo' => 1,
            'pct_fecha' => $transaccion_data[0]['tra_fecha'],
            'pct_total' => number_format(abs($totalPartida), 2, '.', ''),
            'pct_estado' => 1,
            'pct_fecha_crea' => date('Y-m-d H:i:s'),
            'pct_fecha_mod' => date('Y-m-d H:i:s'),
            'pct_usu_crea' => $this->tank_auth->get_user_id(),
            'pct_usu_mod' => $this->tank_auth->get_user_id(),
            'pct_correlativo' => $corr->correlativo,
            'pct_codigo' => $codigoPartida
        );

        $pct_id = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);

        //Ingreso detalle partida debe
        foreach ($cuentas_debe as $debe) {
            $array_detalle = array(
                'dpc_id_cnt' => $debe['cnt_id'],
                'dpc_id_pct' => $pct_id,
                'dpc_concepto' => $concepto_deta,
                'dpc_debe' => number_format(abs($debe['total_abonar']), 2, '.', ''),
                'dpc_haber' => 0.00,
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );

            $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }
        /*         * ************************************Fin Parte Debe***************************************** */

        /*         * ************************************Parte Hbaer***************************************** */
        //Se ha definido tipo de cuenta de BANCOS siempre sin importar el tipo de pago
        $tipo_cuenta_haber = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('CAJA'));
        if ($tra_id_secundaria > 0) {
            $cuentas_haber = $this->utm_model->get_cuenta_contable_transaccion($tra_id_principal, $tipo_cuenta_debe);
        } else {
            $cuentas_haber = $this->utm_model->get_cuenta_contable_transaccion($tra_id_principal, $tipo_cuenta_haber);
        }


        //Ingreso detalle partida debe
        foreach ($cuentas_haber as $haber) {
            $array_detalle = array(
                'dpc_id_cnt' => $haber['cnt_id'],
                'dpc_id_pct' => $pct_id,
                'dpc_concepto' => $concepto_deta,
                'dpc_debe' => 0.00,
                'dpc_haber' => number_format(abs($haber['total_abonar']), 2, '.', ''),
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );

            $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
            /* ************************************Fin Parte Debe***************************************** */
        }
        
        $transaccion_array = array(
            'tra_id_pct' => $pct_id,
            'tra_fecha_mod' => date('Y-m-d H:i:s'),
            'tra_usu_mod' => $this->tank_auth->get_user_id()
        );
        
        $this->gsatelite->actualizar_array('tra_transaccion', $transaccion_array, array('tra_id' => $tra_id_principal));
        if ($tra_id_secundaria > 0) {
            $this->gsatelite->actualizar_array('tra_transaccion', $transaccion_array, array('tra_id' => $tra_id_secundaria));
        }
    }
    
    
    public function partidas_transacciones_pendientes_masiva() {


        //if ($this->input->post()) {
            ini_set('memory_limit', '4048M');
            ini_set('max_execution_time', '9999');
            ini_set('max_input_vars', '15000');
            
            $tipoTransaccion = 1; //deposito //$this->input->post('tipo_transaccion');
            //Se obtienen las transacciones por el tipo de Transacccion
            $lstTransaccionesPendientes = $this->gsatelite->get_tabla('tra_transaccion', array('tra_id_pct IS NULL' => null, 'tra_id_ttb' => $tipoTransaccion));
            
            $contadorPartidas = 0;
            switch ($tipoTransaccion) {
                case 1: {
                        foreach ($lstTransaccionesPendientes as $transaccion) {
                            $this->generar_partida_contable_transaccion($transaccion['tra_id']);
                            $contadorPartidas++;
                        }
                    }
            }
            
            $respuesta = array(
                'cantidad_partidas' => $contadorPartidas
            );
            
            echo json_encode($respuesta);die();
      //  }

        //$data['titulo_personal'] = "Partidas Contables Masivas - Transacciones";

        //cargarvista($data);
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */