<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Reporteria extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('consultas');
        $this->load->model('utm_model');
        $this->load->model('inventario_model');
        $this->load->model('gsatelite');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
        // if (ob_get_contents()) ob_end_clean();
        // date_default_timezone_set('America/El_Salvador');
    }

    public function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function reporte_general() {

        $this->_cargarvista();
    }

    function retensiones_de_pago() {
        $data['proveedor'] = $this->consultas->cargar_todo('prv_proveedor');
        $data['titulo_personal'] = "Reporte de retenciones de pago";
        $data['tipos_retencion'] = str_replace('<option value="0">Seleccione</option>','',$this->gsatelite->get_dropdown('ret_retencion','ret_nombre','',array('ret_estado' =>1),null,null,'ret_id',true));
        $this->_cargarvista(null, $data);
    }

    function reporte_bodega() {
        $data['bodegas'] = $this->consultas->cargar_todo('bod_bodega');
        $this->_cargarvista(null, $data);
    }

    function articulos_pedido() {
        $data['estadisticas'] = $this->consultas->existencias_capas();
        $this->_cargarvista(null, $data);
    }

    function generar_pdf_articulos_pedido() {
        $data['articulos'] = $this->consultas->existencias_capas();
        //  echo $this->db->last_query();die();
        //$this->load->library('pdf');
        $reporte = $this->pdf->reportePDF('utm/reporteria/generar_pdf_articulos_pedido', $data, 'pedido de articulos');
    }


    /**
    * @author Nelson Soriano
    * @since  15-01-2019
    * @return none
    * @param  none
    **/

    public function reporte_nota_abono(){

        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        $cuentas = $this->gsatelite->get_tabla('cub_cuenta_bancaria', array('cub_estado' => 1));      
        $opciones_cuenta = "<option value=''></option>";
        if (count($cuentas) > 0) {
            foreach ($cuentas as $cub) {
                $opciones_cuenta .= "<option value='" . $cub['cub_id'] . "'>" . $cub['cub_numero'] . " - " . $cub['cub_nombre'] . "</option>";
            }
        }
        $data['cuentas'] = $opciones_cuenta;
        $data['titulo_personal'] = 'Reporte Notas de Abono';
        $this->_cargarvista(null, $data);       
       
    }

    /**
    * @author Nelson Soriano
    * @since  15-01-2019
    * @return 
    * @param  Flag para imprimir reporte en excel o pdf
    **/

    public function mostrar_reporte_nota_abono($reporte = 0){
        satelite_validar();
        $permisos               = $this->gsatelite->get_permisos_opcion('reporte_nota_abono');
        $data['permisos']       = $permisos;        
        $desde                  = $this->input->post('txtFecha_desde');
        $hasta                  = $this->input->post('txtFecha_hasta');
        $cuenta                 = ($this->input->post('slcCuentas') != '')?$this->input->post('slcCuentas'):null;
        $where['nta_estado']    = '1';
       if($desde !='' and $hasta!='') {
            $where['date_format(nta_fecha,"%Y-%m-%d") >=']=date_format(date_create($desde), 'Y-m-d');
            $where['date_format(nta_fecha,"%Y-%m-%d") <=']=date_format(date_create($hasta), 'Y-m-d');
        }
        $titulo_cuenta = '';
        if($cuenta){
            $where['cub_id']     = $cuenta;
            $titulo              = $this->gsatelite->get_campo('cub_cuenta_bancaria','cub_numero',array('cub_id' => $cuenta));
            $titulo_cuenta       = 'Cuenta #: '.$titulo;
        }
        $info = $this->consultas->get_reporte_notas($where); 
        $data['es_reporte']     = $reporte;
        $data['txtFecha_desde'] = $desde;
        $data['txtFecha_hasta'] = $hasta;
        $data['cuenta']         = $cuenta;        
        $data['periodo']        = date_format(date_create($desde), 'd-m-Y') . ' A ' . date_format(date_create($hasta), 'd-m-Y');
        $data['registros']      = $info;
        $tipo_accion = $this->input->post('tipo_accion');
        $data['accion'] = $tipo_accion;
        $html = $this->load->view('utm/reporteria/mostrar_reporte_nota_abono',$data,true);
        if ($reporte) {
            $filtro_titulo = ($desde==$hasta)? "De: ".date_format(date_create($desde), 'd-m-Y').'<br>'.$titulo_cuenta:"De: ".$data['periodo'].'<br>'.$titulo_cuenta.'<br><br><br>';
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=Transferencias Bancarias".date('d-m-Y_His').".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='6' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                  <tr><th colspan='6' align='center' >Transferencias Bancarias</th></tr>
                  <tr><th colspan='6' align='center' >".$filtro_titulo. "</th></tr>
                  </table>";
                echo $html; die();
            } else { 
                $this->load->library('pdf');
                $html_header=$this->load->view('reporte/header', array('titulo' => "Reporte Transferencias Bancarias <br /> $filtro_titulo", 'solotitulo'=> true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                $this->pdf->makePDF($html_header.$html,'L', 'notas_abono','Letter');
                die();
            }
        }
        echo json_encode(array('html'=>$html));

    }

    function vista_previa() {
        $par = $this->input->post('bodega');
        $rs = $this->consultas->existencias_bodega($par);

        echo '<table id="table" class="data_table">';
        echo '<thead>';
        echo '<th class="center" style="width: 25%;">Articulos</th>';
        echo '<th class="center" style="width: 25%;">Serie</th>';
        echo '<th class="center" style="width: 25%;">Ultimo correlativo usado</th>';
        echo '<th class="center" style="width: 25%;">Ultimo correlativo asignado</th>';
        echo '<th class="center" style="width: 25%;">Cantidad</th>';
        echo '</thead>';
        echo '<tbody>';
        foreach ($rs as $informacion) {
            echo '<tr>';
            echo '<td>' . $informacion['art_nombre'] . '</td>';
            echo '<td>' . $informacion['ser_nombre'] . '</td>';
            echo '<td>' . $informacion['usado'] . '</td>';
            echo '<td>' . $informacion['asignado'] . '</td>';
            echo '<td>' . number_format($informacion['total'], 0) . '</td>';
            echo '</tr>';
        }
        echo '</tbody>';
        echo '</table>';
    }

    function vista_previa_articulo_especifico() {
        $sar_id = $this->input->post('sar_id');

        $rs = $this->db->query('SELECT art_nombre,SUM(sar_cant_actual) AS total,ser_nombre,ser_id,
          (SELECT MAX(cor_correlativo.cor_numero) FROM cor_correlativo WHERE cor_id_ser = ser_id AND cor_correlativo.cor_estado = 0) AS usado,
          (SELECT MAX(cor_correlativo.cor_numero) FROM cor_correlativo WHERE cor_id_ser = ser_id AND cor_correlativo.cor_estado = 2) AS asignado
          FROM sar_saldo_articulo
          INNER JOIN art_articulo ON sar_saldo_articulo.sar_id_art = art_articulo.art_id
          INNER JOIN ser_serie ON art_articulo.art_id = ser_serie.ser_id_art
          WHERE sar_saldo_articulo.`sar_id` =' . $sar_id)->
                result_array();

        echo '<table id="table" class="data_table">';
        echo '<thead>';
        echo '<th class="center" style="width: 25%;">Articulos</th>';
        echo '<th class="center" style="width: 25%;">Serie</th>';
        echo '<th class="center" style="width: 25%;">Ultimo correlativo usado</th>';
        echo '<th class="center" style="width: 25%;">Ultimo correlativo asignado</th>';
        echo '<th class="center" style="width: 25%;">Cantidad</th>';
        echo '</thead>';
        echo '<tbody>';
        foreach ($rs as $informacion) {
            echo '<tr>';
            echo '<td>' . $informacion['art_nombre'] . '</td>';
            echo '<td>' . $informacion['ser_nombre'] . '</td>';
            echo '<td>' . $informacion['usado'] . '</td>';
            echo '<td>' . $informacion['asignado'] . '</td>';
            echo '<td>' . number_format($informacion['total'], 0) . '</td>';
            echo '</tr>';
        }
        echo '</tbody>';
        echo '</table>';
    }

    function vista_previa_articulo() {
        $bodega = $this->input->post('id_bodega');
        $articulos_en_bodega = $this->db->query('SELECT * FROM art_articulo AS art
            INNER JOIN sar_saldo_articulo sar ON sar.`sar_id_art` = art.`art_id`
            INNER JOIN bod_bodega bod ON bod.`bod_id` = sar.`sar_id_bod`
            where bod.bod_id=' . $bodega . '
            GROUP BY art.`art_id`
            ')->result_array();
        $html = '<option value="0" >Ninguno</option>';
        foreach ($articulos_en_bodega as $key) {
            $html .= '<option value=' . $key['sar_id'] . '>' . $key['art_nombre'] .
                    '</option>';
        }

        echo $html;
    }

    function vista_previa_ventas() {
        $par = $this->input->post('bodega');
        $fecha = $this->input->post('fecha');
        $rs = $this->consultas->reporte_diario($fecha); //la fecha va nula. (pero la funcion verifica si esta nula y por defecto coloca la actual)

        $data["detalle_caja"] = $this->consultas->detalle_cajas_aperturadas($fecha);

        $data["fecha"] = ($fecha == null) ? date("d-m-Y") : $fecha;
        $data["rs"] = $rs;
        $this->load->view('utm/reporteria/vista_previa_ventas', $data);
    }

    function especies_vendidas() {
        $this->_cargarvista();
    }

    function reporte_diario() {
        $this->_cargarvista();
    }

    function reporte_caja() {
        $this->_cargarvista();
    }

    function constancia_empleado() {
        $data['puesto'] = $this->consultas->cargar_todo('pto_puesto');
        $this->_cargarvista(null, $data);
    }

    function generar_pdf_especies_vendidas() {
        $fecha_b = date("Y-m-d", strtotime($this->input->post('fecha_inicio')));
        $fecha_b2 = date("Y-m-d", strtotime($this->input->post('fecha_final')));

        // hecho por Leonel
        $data['especies'] = $this->consultas->especies_vendidas($fecha_b, $fecha_b2);

        //$this->load->library('pdf');
        $reporte = $this->pdf->reportePDF('utm/reporteria/generar_pdf_especies_vendidas', $data, 'especies vendidas');
    }

    function constancia_pdf() {
        $tipo_constancia = $this->input->post('constancia');
        $empleado = $this->input->post('empleado_alcaldia');
        switch ($tipo_constancia) {

            case 'tiempo':
                $data['informacion'] = $this->consultas->informacion_empleado($empleado);
                //$this->load->library('pdf');
                $reporte = $this->pdf->reportePDF('utm/reporteria/constancia_tiempo', $data, 'constancia de tiempo');
                break;

            case 'sueldo':
                $data['informacion'] = $this->consultas->informacion_empleado($empleado);
                //$this->load->library('pdf');
                $reporte = $this->pdf->reportePDF('utm/reporteria/constancia_sueldo', $data, 'constancia de sueldo');
                break;

            case 'renta':
                $data['informacion'] = $this->consultas->constancia_renta($empleado);
                //$this->load->library('pdf');
                $reporte = $this->pdf->reportePDF('utm/reporteria/constancia_renta', $data, 'constancia de renta');
                break;
        }
    }

    function generar_pdf_caja() {
        $fecha1 = $this->input->post('fecha_inicio');
        $fecha2 = $this->input->post('fecha_final');
        $f1 = $this->input->post('fecha_inicio');
        $f2 = $this->input->post('fecha_final');

        $arreglo1 = explode("-", $fecha1);
        $arreglo2 = explode("-", $fecha2);

        $fecha1 = join('-', array_reverse($arreglo1));
        $fecha2 = join('-', array_reverse($arreglo2));

        //$this->load->library('Pdf');
        $this->load->library('texto');
        //hecho por Leonel
        $data['cajas'] = $this->consultas->reporte_rango_caja($fecha1, $fecha2);
        //echo $this->db->last_query(); die();
        $data["cab"] = $this->load->view("reporte/header_uatm", null, true);
        $data["detalle_caja"] = $this->consultas->detalle_cajas_aperturadas($fecha1, $fecha2);
        $data["fecha"] = array(date("d-m-Y", strtotime($fecha1)), date("d-m-Y", strtotime($fecha2)));

        //$this->load->library('pdf');
        $reporte = $this->pdf->reportePDF('utm/reporteria/generar_pdf_caja2', $data, "Venta en Caja ( $f1 / $f2 )");
    }

    function generar_pdf() {
        $tipo_proceso = $this->input->post('proceso');
        $fecha_b = date("Y-m-d", strtotime($this->input->post('fecha_inicio')));
        $fecha_b2 = date("Y-m-d", strtotime($this->input->post('fecha_final')));
        $pro = '';

        if ($tipo_proceso == 1) {
            $pro = 'compras';
            $data['inventario'] = $this->consultas->detalles_inventario($tipo_proceso, $fecha_b, $fecha_b2);
        } elseif ($tipo_proceso == 3) {
            $pro = 'compras y salidas';
            $data['inventario'] = $this->consultas->detalle_todo($fecha_b, $fecha_b2);
        } else {
            $pro = 'salidas';
            $data['inventario'] = $this->consultas->detalles_inventario($tipo_proceso, $fecha_b, $fecha_b2);
        }

        //hecho por Leonel
        //$this->load->library('pdf');
        $reporte = $this->pdf->reportePDF('utm/reporteria/generar_pdf', $data, $pro .
                ' realizadas');
    }

    function generar_pdf_cuenta_presupuestaria() {
        $fecha_b = date("Y-m-d", strtotime($this->input->post('fecha_inicio')));
        $fecha_b2 = date("Y-m-d", strtotime($this->input->post('fecha_final')));
        $prueba = $this->consultas->generar_informacion_cuentas($fecha_b, $fecha_b2);


        $data['informacion'] = $prueba;
        //$this->load->library('pdf');
        $reporte = $this->pdf->reportePDF('utm/reporteria/generar_pdf_cuenta', $data, 'ingresoss');
    }

    function generar_cuentas_bancarias_pdf() {
        $tipo_cuenta = ($this->input->post('tipo_cuenta')) ? 'general' : 'proyecto';
        $banco = $this->input->post('banco');
        $set_cuentas = 0;
        ($tipo_cuenta == "proyecto") ? $set_cuentas = 2 : $set_cuentas = 1;
        if ($banco == 0) { //TODOS LOS BANCOS
            $reporte = "";
            $all_bancos = $this->consultas->cargar_todo('ban_banco');
            $i = 1;
            $saldo_inicial = 0;
            $saldo_minimo = 0;
            $detalles_consolidado = array();
            foreach ($all_bancos as $fila) {
                $id_banco = $fila['ban_id'];
                $reporte .= $this->load->view('reporte/header_uatm', array('titulo' => 'cuentas bancarias'), true);
                $banco = $this->consultas->cargar_registros('ban_banco', 'ban_id', $id_banco);
                $data['banco'] = $banco;
                $data['salto'] = ($i == count($all_bancos)) ? false : true;
                $i++;
                $data['informacion'] = $this->consultas->generar_cuentas($id_banco, $set_cuentas);
                $tot = $this->consultas->generar_totales($id_banco, $set_cuentas);
                $nombre_banco = $banco[0]['ban_nombre'];
                $total1 = (isset($tot['total_inicial'])) ? $tot['total_inicial'] : 0;
                $total2 = (isset($tot['total_minimo'])) ? $tot['total_minimo'] : 0;
                $total3 = (isset($tot['total'])) ? $tot['total'] : 0;
                $detalles_consolidado[] = array('nombre' => $nombre_banco, 'total1' => $total1, 'total2' => $total2, 'total3' => $total3);
                $saldo_inicial += $total1;
                $saldo_minimo += $total2;
                $data['totales'] = $tot;

                $reporte .= $this->load->view('utm/reporteria/generar_pdf_cuenta_bancaria', $data, true);
            }
            $data['cabezera'] = $this->load->view('reporte/header_uatm', array('titulo' => 'Consolidado cuentas presupuestarias'), true);
            $data['total_saldo_inicial'] = $saldo_inicial;
            $data['total_saldo_minimo'] = $saldo_minimo;
            $data['detalles'] = $detalles_consolidado;
            $reporte .= $this->load->view('utm/reporteria/generar_pdf_cuenta_bancaria', $data, true);

            //libreria pdf
            //$this->load->library('pdf');
            $this->pdf->makePDF($reporte, "P", "cuentas presupuestaria");
        } else { //UN BANCO EN ESPECIFICO
            $data['banco'] = $this->consultas->cargar_registros('ban_banco', 'ban_id', $banco);
            $data['informacion'] = $this->consultas->generar_cuentas($banco, $set_cuentas);
            $data['totales'] = $this->consultas->generar_totales($banco, $set_cuentas);
            //$this->load->library('pdf');
            $reporte = $this->pdf->reportePDF('utm/reporteria/generar_pdf_cuenta_bancaria', $data, 'cuentas presupuestaria');
        }
    }

    public function generar_pdf_bodega() {
        $bodega = $this->input->post('bodegas');
        $par = $bodega;
        $articulos = $this->input->post('articulos');
        if ($articulos == 0 || !$articulos) {
            $rs = $this->consultas->existencias_bodega($par);
        } else {
            $rs = $this->db->query('SELECT art_nombre,SUM(sar_cant_actual) AS total,ser_nombre,ser_id,
              (SELECT MAX(cor_correlativo.cor_numero) FROM cor_correlativo WHERE cor_id_ser = ser_id AND cor_correlativo.cor_estado = 0) AS usado,
              (SELECT MAX(cor_correlativo.cor_numero) FROM cor_correlativo WHERE cor_id_ser = ser_id AND cor_correlativo.cor_estado = 2) AS asignado
              FROM sar_saldo_articulo
              INNER JOIN art_articulo ON sar_saldo_articulo.sar_id_art = art_articulo.art_id
              INNER JOIN ser_serie ON art_articulo.art_id = ser_serie.ser_id_art
              WHERE sar_saldo_articulo.`sar_id` =' . $articulos . '
              GROUP BY art_articulo.art_nombre')->result_array();
        }
        //hecho por Leonel
        // $data['bodega'] = $this->consultas->existencias_bodega($bodega);
        $data['bodega'] = $rs;
        //$this->load->library('pdf');
        $reporte = $this->pdf->reportePDF('utm/reporteria/generar_pdf_bodega', $data, 'existencias en bodega');
    }

     /**
    * @author Nelson Soriano
    * @since  15-04-2019
    * @return vista de reporte de retenciones
    * @param  parametros para filtrar el reporte por fechas, tipo retencion, tipo de reporte
    **/
    function generar_reporte_retension_pagos($reporte = null) {
        $f_inicial    = ($this->input->post('fecha_inicio') !== '')?$this->input->post('fecha_inicio'):null;
        $f_final      = ($this->input->post('fecha_fin')    !== '')?$this->input->post('fecha_fin')   :null;
        $proveedor    = ($this->input->post('proveedor')    !== '')?$this->input->post('proveedor')  :null;
        $t_tp         = ($this->input->post('tp')           !== '')?$this->input->post('tp')         :null;
        $t_tipo       = ($this->input->post('tipo')         !== '')?$this->input->post('tipo')       :3;

        // se construyen los filtros
        // case 3 todos los tipos [cheques,notas de abono]
        // case 1 solo chques
        // case 2 solo notas de abono
        $where_nota = null;
        $where_cheq = null;
        $data['tipo_reporte'] = '';
        $data['registros_cheques'] = array();
        $data['registros_nota']    = array();
        $titulo     = '';
        switch ($t_tipo) {
            case 3:
                if (($f_inicial !== null) && ($f_final !== null)) {
                    // fechas nota de abono
                    $where_nota['date_format(nta_fecha,"%Y-%m-%d") >='] = date_format(date_create($f_inicial),'Y-m-d');
                    $where_nota['date_format(nta_fecha,"%Y-%m-%d") <='] = date_format(date_create($f_final),'Y-m-d');
                    // fechas cheques
                    $where_cheq['date_format(che_fecha,"%Y-%m-%d") >='] = date_format(date_create($f_inicial),'Y-m-d');
                    $where_cheq['date_format(che_fecha,"%Y-%m-%d") <='] = date_format(date_create($f_final),'Y-m-d');
                    $titulo .= "<p>Desde: ".$f_inicial.'&nbsp;&nbsp;&nbsp;&nbsp; Hasta: '.$f_final."</p>";
                }

                if ($proveedor !== null) {
                        $where_nota['nta_id_prv'] = $proveedor;
                        $where_cheq['che_id_prv'] = $proveedor;
                        $p = $this->consultas->obtener_prov($proveedor);
                        $titulo .= "<p>".$p[0]['proveedor']."</p>";
                    }

                if ($t_tp !== null) {
                    $where_nota['rdn_id_ret'] = $t_tp;
                    $where_cheq['rdc_id_ret'] = $t_tp;
                    $titulo .= "<p>Tipo de retencion: ".$this->gsatelite->get_campo('ret_retencion','ret_nombre',array('ret_id'=> $t_tp ))."</p>";
                }

                // procesamos las consultas 
                $data['registros_cheques'] = $this->consultas->obtener_retension_cheques($where_cheq);
                $data['registros_nota']    = $this->consultas->obtener_retension_notas($where_nota);
                break;
            
            case 1:
                # solo cheques
                if (($f_inicial !== null) && ($f_final !== null)) {
                    // fechas cheques
                    $where_cheq['date_format(che_fecha,"%Y-%m-%d") >='] = date_format(date_create($f_inicial),'Y-m-d');
                    $where_cheq['date_format(che_fecha,"%Y-%m-%d") <='] = date_format(date_create($f_final),'Y-m-d');
                    $titulo .= "<p>Desde: ".$f_inicial.'&nbsp;&nbsp;&nbsp;&nbsp; Hasta: '.$f_final."</p>";
                }

                if ($proveedor !== null) {
                    $where_cheq['che_id_prv'] = $proveedor;
                    $p =$this->consultas->obtener_prov($proveedor);
                    $titulo .= "<p>".$p[0]['proveedor']."</p>";
                }

                if ($t_tp !== null) {
                    $where_cheq['rdc_id_ret'] = $t_tp;
                    $titulo .= "<p>Tipo de retencion: ".$this->gsatelite->get_campo('ret_retencion','ret_nombre',array('ret_id'=> $t_tp ))."</p>";
                }

                // procesamos las consultas 
                $data['registros_cheques'] = $this->consultas->obtener_retension_cheques($where_cheq);
                break;
            case 2:
                if (($f_inicial !== null) && ($f_final !== null)) {
                    // fechas nota de abono
                    $where_nota['date_format(nta_fecha,"%Y-%m-%d") >='] = date_format(date_create($f_inicial),'Y-m-d');
                    $where_nota['date_format(nta_fecha,"%Y-%m-%d") <='] = date_format(date_create($f_final),'Y-m-d');
                    $titulo .= "<p>Desde: ".$f_inicial.'&nbsp;&nbsp;&nbsp;&nbsp; Hasta: '.$f_final."</p>";
                }

                if ($proveedor !== null) {
                        $where_nota['nta_id_prv'] = $proveedor;
                        $p =$this->consultas->obtener_prov($proveedor);
                        $titulo .= "<p>".$p[0]['proveedor']."</p>";
                    }

                if ($t_tp !== null) {
                    $where_nota['rdn_id_ret'] = $t_tp;
                    $titulo .= "<p>Tipo de retencion: ".$this->gsatelite->get_campo('ret_retencion','ret_nombre',array('ret_id'=> $t_tp ))."</p>";
                }
                // procesamos las consultas 
                $data['registros_nota']    = $this->consultas->obtener_retension_notas($where_nota);
            break;
        }

        $data['tipo_reporte'] = $this->input->post('tipo_reporte_x');
        $html = $this->load->view('utm/reporteria/generar_reporte_retension_pagos',$data,true);
        //procesamos el tipo de reporte excel/pdf segun el usuario haya seleccionado
        if ($reporte !== null) {
            $reporte_tipo = $this->input->post('tipo_reporte_x');
            switch ($reporte_tipo) {
                // pdf
                case 1:
                    $data['titulo']             = 'retenciones de pago.';
                    $header                     = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte']  = 'retenciones_de_pago_' . date('dmY');
                    $reporte                    = $header.$titulo. $html;
                    $this->pdf->makePdf($reporte, 'L', 'retenciones_de_pagos', 'Letter');
                    break;
                // excel
                case 2:
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=retenciones_de_pagos-".date('d-m-Y_His').".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='0'>
                    <tr><th colspan='7' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                    <tr><th colspan='7' align='center' >Reporte de retenciones de pago</th></tr>
                    <tr><th colspan='7' align='center' >".$titulo. "</th></tr>
                    </table>";
                    echo $html;
                  die();
                    break;
            }
        }

        echo $html;
        die();
    }

    function generar_pdf_ventas() {

        //hecho por Leonel
        $data['reportes'] = $this->consultas->reporte_diario();
        //$this->load->library('pdf');
        $fecha = date("d-m-Y");
        $data["cab"] = $this->load->view("reporte/header_uatm", null, true);
        $data["detalle_caja"] = $this->consultas->detalle_cajas_aperturadas($fecha);
        $data["fecha"] = $fecha;
        $reporte = $this->pdf->reportePDF('utm/reporteria/venta', $data, "Ventas Realizadas $fecha ", 'L');
    }

    function detalle_egreso() {
        $data['bancos'] = $this->consultas->cargar_todo('ban_banco');
        $this->_cargarvista(null, $data);
    }

   

    function libro_especie() {
        $this->db->where('art_articulo.art_aplica_serie', 1);
        $data['especie'] = $this->consultas->cargar_todo('art_articulo');
        $this->_cargarvista(null, $data);
    }

    function obtener_cub() {

        $banco_id = $this->input->post('banco_id');
        $cub = $this->db->query('select * from cub_cuenta_bancaria where cub_id_ban =' . $banco_id)->result_array();

        $html = ''; // '<option value="0">Elija una cuenta</option>';
        foreach ($cub as $key) {
            $html .= '<option value=' . $key['cub_id'] . '>' . $key['cub_numero'] . '-' . $key['cub_nombre'] . '</option>';
        }

        echo $html;
    }

    function generar_detalle_egreso_pdf() {
        $bancos = $this->input->post('bancos');
        $data['informacion'] = $this->consultas->obtenter_detalles_egresos($bancos);
        $data['bancos'] = $this->consultas->cargar_registros('ban_banco', 'ban_id', $banco);
        //$this->load->library('pdf');
        $reporte = $this->pdf->reportePDF('utm/reporteria/egreso_pdf', $data, 'Detalles de egresos');
    }
    /** SAT_4565 SE SOLICITO ELIMINAR ESTE REPORTE, SE DEJA COMENTADO EL CODIGO
    function generar_libro_banco_pdf($aplicar = 0) { //print_r($_POST);die();
        $reporte        = ($this->input->post('reporte')) ? $this->input->post('reporte') : 0 ;
        $bancos         = $this->input->post('bancos');
        $cub            = $this->input->post('cub');
        $fecha_a        = date("Y-m-d", strtotime($this->input->post('fecha_a')));
        $fecha_b        = date("Y-m-d", strtotime($this->input->post('fecha_b')));
        $data['header']       = $this->input->post('header');

        $data['informacion_general'] = $this->consultas->obtenter_detalles_egresos($bancos, $cub);
        $data['informacion'] = $this->consultas->merge_tra_cheque($bancos, $cub, $fecha_a, $fecha_b, $aplicar);

        # print_r($this->db->last_query()); exit;
        $data['bancos']         = $this->consultas->cargar_registros('ban_banco', 'ban_id', $bancos);
        $data['saldo_inicial']  = $this->utm_model->getSaldoAFecha($cub, $fecha_a);
        $data['fecha_a']        = $fecha_a;
        $data['fecha_b']        = $fecha_b;

        //////////////////////////////////////////////////////////////////////
        if ($reporte == 1) { //print_r($data);die();
            //Tipo de reporte
            $data['tipo_reporte'] = $this->input->post('tipo_reporte');
            //Nombre archivo
            $filename = 'rpt_libro_banco' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;

            $html = $this->load->view('utm/reporteria/libro_banco_pdf', $data, true);

            $tipo_reporte = $this->input->post('tipo_reporte');

            if ($tipo_reporte == 'pdf') {

                $data['titulo'] = 'Libro Bancos';

                $header = $this->load->view('reporte/header', $data, true);

                $GLOBALS['nombre_reporte'] = 'Reporte_libro_bancos' . date('dmY');

                $reporte = $header . $html;

                $this->pdf->makePdf($reporte, 'L', 'Reporte_libro_bancos', 'Letter');

            } elseif ($tipo_reporte == 'excel') {

                $filename = 'rpt_libro_banco' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                $data['titulo'] = 'libro banco';

                $data['filename'] = $filename;

                echo $html;
            }
        } else { //print_r($data);die();
            $data['titulo'] = 'Transacciones no Aplicadas';
            $html = $this->load->view('utm/reporteria/libro_banco_pdf', $data, true);
            echo $html; die();
        }
    }**/

    public function __() {
        $init_amount = $this->db->query('

            ');
    }
    
    function generar_libro_especie_pdf() {
        ini_set('memory_limit', '512M');
        $especie = $this->input->post('especie');
        $fecha_a = $this->input->post('fecha_a');
        $fecha_b = $this->input->post('fecha_b');
        //obtener el nombre del ticket.
        $producto = (array) $this->gsatelite->get_registro('art_articulo', 'art_id', $especie);
        //print_r($producto); die();
        $unidad_med = (array) $this->gsatelite->get_registro('mep_medida_producto', 'mep_id', $producto['art_id_mep']);
        $saldo_inicio = $this->inventario_model->get_saldo_inicio_especie($especie, $fecha_a, $fecha_b);
        // echo $this->db->last_query();
        // print_r($saldo_inicio); die();

        $detalles = $this->inventario_model->get_detalle_movimientos_especie($especie, $fecha_a, $fecha_b);
        //echo $this->db->last_query(); die();
        $saldo_final = $this->inventario_model->get_saldo_final_especie($especie, $fecha_a, $fecha_b);

        //$this->load->library('pdf');
        $data = array('nombre_especie' => $producto['art_nombre'],
            'saldo_inicio' => $saldo_inicio,
            'unidad_med' => $unidad_med,
            'saldo_final' => $saldo_final,
            'detalles_movimientos' => $detalles,
            'fecha_a' => $fecha_a,
            'fecha_b' => $fecha_b,
            'producto' => $producto
        );

        $html_cab = $this->load->view('reporte/header_utm', array('titulo' => ''), true);
        $data["cabezera"] = $html_cab;
        $html = $this->load->view('utm/reporteria/libro_especie_pdf', $data, true);
        $this->pdf->makePDF($html, 'P');
    }

    /* ANTERIOR */

    function generar_libro_especie_pdf_ANTERIOR() {
        ini_set('memory_limit', '512M');
        $especie = $this->input->post('especie');
        $fecha_a = $this->input->post('fecha_a');
        $fecha_b = $this->input->post('fecha_b');
        //obtener el nombre del ticket.
        $especies = $this->db->query('select * from art_articulo where art_id=' . $especie)->row_array();

        //saldo incicial de especies
        $saldo_inicial = $this->db->query('SELECT  COUNT(*) AS saldo_inicial, GROUP_CONCAT(cor.cor_inicio) AS inicios,
      GROUP_CONCAT(cor.cor_fin) AS finales, dee.dee_precio as precio FROM  dee_detalle_mov AS dee
        INNER JOIN cor_correlativo cor ON cor.`cor_id_dee` = dee.`dee_id`
        WHERE dee.`dee_id_art` = ' . $especie . '
        AND cor.`cor_estado` = 1  AND cor.cor_tipo=1
        AND DATE_FORMAT(cor.`cor_fecha`,"%Y-%m-%d") BETWEEN "' . $fecha_a . '" AND "' . $fecha_b . '"  ')->row_array();
        //  cor.`cor_estado` = 0
        //echo $this->db->last_query(); die();
        /*        print 'SELECT COUNT(*) AS saldo_inicial, dee.dee_precio as precio FROM  dee_detalle_mov AS dee
          INNER JOIN cor_correlativo cor ON cor.`cor_id_dee` = dee.`dee_id`
          WHERE dee.`dee_id_art` = ' . $especie . '
          AND cor.`cor_estado` = 0
          AND cor.`cor_fecha` BETWEEN "' . $fecha_a . '" AND "' . $fecha_b . '"';

          exit(); */
        //obtener el ultimo cor_numero al q se le dio salida
        $saldo_final_mes = $this->db->query('SELECT COUNT(*) AS total_vendidas_mes, dee.dee_precio as precio FROM  dee_detalle_mov AS dee
                INNER JOIN cor_correlativo cor ON cor.`cor_id_dee` = dee.`dee_id`
                WHERE dee.`dee_id_art` = ' . $especie . '
                AND cor.`cor_estado` = 1 AND cor.cor_tipo=2
               AND DATE_FORMAT(cor.`cor_fecha`,"%Y-%m-%d") BETWEEN "' . $fecha_a . '" AND "' . $fecha_b .
                        '"
                ')->row_array();
        // cor.`cor_estado` = 1
        //array con todas las fechas de los movimientos
        $data_especie = $this->db->query('SELECT * FROM  dee_detalle_mov AS dee
                INNER JOIN cor_correlativo cor ON cor.`cor_id_dee` = dee.`dee_id`
                WHERE dee.`dee_id_art` = ' . $especie . '
                AND cor.`cor_estado` = 1
                AND DATE_FORMAT(cor.`cor_fecha`,"%Y-%m-%d") BETWEEN "' . $fecha_a . '" AND "' . $fecha_b .
                        '"')->result_array();
        // cor.`cor_estado` = 0
        // echo $this->db->last_query(); die();
        //$this->load->library('pdf');
        $data = array('nombre_especie' => $especies['art_nombre'],
            'cor_inicios' => $saldo_inicial['inicios'],
            'cor_finales' => $saldo_inicial['finales'],
            'saldo_inicial' => $saldo_inicial['saldo_inicial'],
            'precio' => $saldo_inicial['precio'],
            'data_especie' => $data_especie,
            'total_vendidas' => $saldo_final_mes['total_vendidas_mes'],
            'fecha_a' => $fecha_a,
            'fecha_b' => $fecha_b,
            'especie' => $especie
        );

        // $this->load->view('utm/reporteria/libro_especie_pdf', $data);
        $html_cab = $this->load->view('reporte/header_utm', array('titulo' => ''), true);
        $data["cabezera"] = $html_cab;
        $html = $this->load->view('utm/reporteria/libro_especie_pdf', $data, true);
        $this->pdf->makePDF($html, 'P');

        /*  $reporte = $this->pdf->reportePDF_libro_especie('utm/reporteria/libro_especie_pdf',
          $data, 'Libro de especie', 'UTM'); */
    }

    function detalle_remesa() {
        $data['caja'] = $this->consultas->cargar_todo('caj_caja');
        $this->_cargarvista(null, $data);
    }

    function generar_pdf_detalle_remesa() {
        $caja = $this->input->post('caja');
        $data['informacion'] = $this->consultas->obtener_detalle_remesa($caja);
        //$this->load->library('pdf');
        $reporte = $this->pdf->reportePDF('utm/reporteria/remesa_pdf', $data, 'Detalles de remesas');
    }

    function detalle_pedido() {
        $id = $this->input->post('aEnviar');
        $baseUrl_href = base_url('utm/reporteria/generar_pdf_detalle_pedido') . "/$id";
        $obtener_query = $this->consultas->obtener_detalle_pedido($id);
        // echo $this->db->last_query(); die();
        $segundo_cargo = $this->consultas->cargar_registros('dee_detalle_mov', 'dee_id_moi', $id);

        $data = array(
            'id' => $id
            , 'baseUrl_href' => $baseUrl_href
            , 'obtener_query' => $obtener_query
            , 'segundo_cargo' => $segundo_cargo
        );
        $html = $this->load->view('utm/reporteria/detalle_pedido', $data, true);
        echo $html;
    }

    function generar_pdf_detalle_pedido($id) {
        $obtener_query = $this->consultas->obtener_detalle_pedido($id);
        $segundo_cargo = $this->consultas->cargar_registros('dee_detalle_mov', 'dee_id_moi', $id);
        $datos = array(
            'id' => $id
            , 'obtener_query' => $obtener_query
            , 'segundo_cargo' => $segundo_cargo
        );
        //$datos['tabla'] = $data;
        //$this->load->library('pdf');
        $reporte = $this->pdf->reportePDF('utm/reporteria/generar_pdf_detalle_pedido', $datos, 'detalles por pedido');
    }

    function reporte_cuenta_presupuestaria() {
        $data['titulo_personal'] = "Reporte de cuentas presupuestaria";
        $this->_cargarvista($data);
    }

    function cuentas_bancarias() {
        $data['bancos'] = $this->consultas->cargar_todo('ban_banco');
        $this->_cargarvista(null, $data);
    }

    function control_egresos($reporte = 0) {
        $data['clasificacion'] = $this->consultas->cargar_todo('tpc_tipo_cuenta');
        $data['ttb'] = str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('ttb_tipo_transact_bancaria','ttb_nombre','',array('ttb_estado' =>1, 'ttb_retiro > 0 OR ttb_id_ttb_retiro IS NOT NULL' => null),null,null,'ttb_id',true));
        $data['titulo_personal'] = "Control de egresos";
        $data['bancos'] = $this->gsatelite->get_tabla('ban_banco', array('ban_estado' => 1));
        if ($reporte == 1) {
            extract($this->input->get());
            $fecha_desde = $this->input->post('hfecha_desde');
            $fecha_hasta = $this->input->post('hfecha_hasta');
            $tipo = $this->input->post('htipo');
            /*****************/
            $where['tra_estado'] = 1;
            $banco = ($this->input->post('hbanco')) ? $this->input->post('hbanco') : '';
            $cuenta = ($this->input->post('hcuenta')) ? $this->input->post('hcuenta') : '';
            $ttb = ($this->input->post('httb') !== '') ? $this->input->post('httb') : null;
            if(trim($banco) != ""){
                $where['cub_id_ban'] = $banco;
            }
            if(trim($cuenta) != ""){
                $where['cub_id'] = $cuenta;
            }
            /*****************/
            if ($ttb !== null) {
                $where['ttb_id'] = $ttb;
            }
            $data['fecha_inicio'] = $fecha_desde;
            $data['fecha_fin'] = $fecha_hasta;
            $data['tipo_reporte'] = $this->input->post('tipo_reporte');
            $filename = 'rpt_control_egresos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['transacciones'] = $this->consultas->rpt_control_egresos('E', date('Y-m-d', strtotime($fecha_desde)), date('Y-m-d', strtotime($fecha_hasta)), $tipo, $where);
            $html = $this->load->view('utm/reporteria/control_egresos_pdf', $data, true);

            /*************************************************************/
            $tipo_reporte = $this->input->post('tipo_reporte');
            //print_r($tipo_reporte); die();
            if ($tipo_reporte == 'pdf') {

                $data['titulo'] = 'control de egresos';

                $header = $this->load->view('reporte/header', $data, true);

                $GLOBALS['nombre_reporte'] = 'Reporte_control_egresos' . date('dmY');

                $reporte = $header . $html;

                //echo $reporte; die();
                $this->pdf->makePdf($reporte, 'L', 'Reporte_control_egresos', 'Letter');

            } elseif ($tipo_reporte == 'excel') {

                $filename = 'rpt_control_egresos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                $data['titulo'] = 'control de egresos';

                $data['filename'] = $filename;

                echo $html;
            }


        } else {
            $this->_cargarvista(null, $data);
        }
    }

    function control_ingresos($reporte = 0) {
        $data['origen'] = ($this->input->get('origen')) ? $this->input->post('origen') : '';
        $data['clasificacion'] = $this->consultas->cargar_todo('tpc_tipo_cuenta');
        $data['titulo_personal'] = "Control de ingresos";
        $data['bancos'] = $this->gsatelite->get_tabla('ban_banco', array('ban_estado' => 1));
        //print_r($data['bancos']);
        if ($reporte == 1) {
            extract($this->input->get());
            $fecha_desde = $this->input->post('hfecha_desde');
            $fecha_hasta = $this->input->post('hfecha_hasta');
            $tipo = $this->input->post('htipo');
            $data['fecha_desde'] = $fecha_desde;
            $data['fecha_hasta'] = $fecha_hasta;
            /*****************/
            $where = null;
            $banco = ($this->input->post('hbanco')) ? $this->input->post('hbanco') : '';
            $cuenta = ($this->input->post('hcuenta')) ? $this->input->post('hcuenta') : '';
            if(trim($banco) != ""){
                $where['cub_id_ban'] = $banco;
            }
            if(trim($cuenta) != ""){
                $where['cub_id'] = $cuenta;
            }
            /*****************/
            $data['tipo_reporte'] = $this->input->post('tipo_reporte');
            $filename = 'rpt_control_ingresos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['transacciones'] = $this->consultas->rpt_control_egresos('I', date('Y-m-d', strtotime($fecha_desde)), date('Y-m-d', strtotime($fecha_hasta)), $tipo, $where);
            //$html = $this->load->view('reporte/header', array('titulo' => 'REPORTE DE CONTROL DE INGRESOS'), true);
            $html = $this->load->view('utm/reporteria/control_ingresos_pdf', $data, true);
            /*************************************************************/
            $tipo_reporte = $this->input->post('tipo_reporte');
            if ($tipo_reporte == 'pdf') {
                $data['titulo'] = 'control de ingresos';
                $header = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte'] = 'Reporte' . date('dmY');
                $reporte = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Reporte', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                $filename = 'rpt_compras_producto_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['titulo'] = 'control de ingresos';
                $data['filename'] = $filename;
                echo $html;
            }


        } else {
            $this->_cargarvista(null, $data);
        }
    }

    function ajax_control_ingresos() {
        $data['origen'] = ($this->input->post('origen')) ? $this->input->post('origen') : '';
        $data['titulo_personal'] = "Control de ingresos";
        $fecha_desde = ($this->input->post('fecha_desde')) ? $this->input->post('fecha_desde') : '';
        $fecha_hasta = ($this->input->post('fecha_hasta')) ? $this->input->post('fecha_hasta') : '';
        $tipo = ($this->input->post('tipo')) ? $this->input->post('tipo') : '';
        /*****************/
        $where = null;
        $banco = ($this->input->post('banco')) ? $this->input->post('banco') : '';
        $cuenta = ($this->input->post('cuenta')) ? $this->input->post('cuenta') : '';
        if(trim($banco) != ""){
            $where['cub_id_ban'] = $banco;
        }
        if(trim($cuenta) != ""){
            $where['cub_id'] = $cuenta;
        }
        /*****************/
        $data['transacciones'] = $this->consultas->rpt_control_egresos('I', date('Y-m-d', strtotime($fecha_desde)), date('Y-m-d', strtotime($fecha_hasta)), $tipo, $where);
        $data['tipo_reporte'] = '';
        $html = $this->load->view('utm/reporteria/control_ingresos_pdf', $data, true);
        echo $html;
    }

    function ajax_control_egresos() {
        $fecha_desde = ($this->input->post('fecha_desde')) ? $this->input->post('fecha_desde') : '';
        $fecha_hasta = ($this->input->post('fecha_hasta')) ? $this->input->post('fecha_hasta') : '';
        $tipo = ($this->input->post('tipo')) ? $this->input->post('tipo') : '';
        /*****************/
        $where['tra_estado'] = 1;
        $banco  = ($this->input->post('banco')) ? $this->input->post('banco') : '';
        $cuenta = ($this->input->post('cuenta')) ? $this->input->post('cuenta') : '';
        $ttb    = ($this->input->post('ttb') !== '') ? $this->input->post('ttb') : null; 
        if(trim($banco) != ""){
            $where['cub_id_ban'] = $banco;
        }
        if(trim($cuenta) != ""){
            $where['cub_id'] = $cuenta;
        }
        if ($ttb !== null) {
          $where['ttb_id'] = $ttb;
        }
        /*****************/
        $data['transacciones'] = $this->consultas->rpt_control_egresos('E', date('Y-m-d', strtotime($fecha_desde)), date('Y-m-d', strtotime($fecha_hasta)), $tipo, $where);
        // print_r($this->db->last_query());die();
        $html = $this->load->view('utm/reporteria/control_egresos_pdf', $data, true);
        echo $html;
    }

    public function detalle_isam() {
        $ids_funos = $this->input->post('ids_funos');
        // echo $ids_funos;
        $data['ids_funos'] = $ids_funos;
        $this->load->view('utm/reporteria/detalle_funos', $data);
    }

    public function comprobante_diario_f1() {
        $this->load->model('Reportes_utm_model');
        //por defecto el inicio y el fin del mes actual
        $fecha1 = date('Y-m-01');
        $fecha2 = date('Y-m-t');

        if ($_POST) {
            $fecha1 = ($_POST['fecha_ini'] != "") ? date('Y-m-d', strtotime($_POST['fecha_ini'])) : date('Y-m-01');
            $fecha2 = ($_POST['fecha_fin'] != "") ? date('Y-m-d', strtotime($_POST['fecha_fin'])) : date('Y-m-t');

            if ($fecha1)
                $data['f1'] = $this->Reportes_utm_model->get_f1($fecha1, $fecha2);
            $data['f1s'] = $this->Reportes_utm_model->get_f1s($fecha1, $fecha2);

            $data['post'] = array(date('d-m-Y', strtotime($fecha1)), date('d-m-Y', strtotime($fecha2)));
            if ($_POST['btn'] == 'pdf') {
                //$this->load->library('pdf');
                $reporte = $this->pdf->reportePDF('utm/reporteria/comprobante_diario_f1_pdf', $data, 'Comprobante de Recibo de Ingresos');
            }
        } else {

            $data['f1'] = $this->Reportes_utm_model->get_f1();
            $data['f1s'] = $this->Reportes_utm_model->get_f1s($fecha1, $fecha2);
        }

        $this->_cargarvista($data);
    }

    
    /** SAT_4565 SE SOLICITO ELIMINAR ESTE REPORTE, SE DEJA COMENTADO EL CODIGO DESDE 27-04-2019
    function trans_aplicar() {
        $data['bancos'] = $this->consultas->cargar_todo('ban_banco');
        $data['titulo_personal'] = "Transacciones no aplicadas";
        $this->_cargarvista(null, $data);
    }
    **/

    public function cheques_emitidos() {
        $data['bancos'] = $this->gsatelite->get_dropdown('ban_banco', '{ban_nombre}', 'bancos', array('ban_estado' => 1), null, null, null, true);
        $data['proveedores'] = $this->gsatelite->get_dropdown('prv_proveedor', '{prv_nombre} {prv_apellido}', null, array('prv_estado' => 1), null, null, null, true);
        $data['titulo_personal'] = "Cheques Emitidos";
        $this->_cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */

    public function reporte_cheques_emitidos($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();
            //var_dump($post_array);die();
            /* Si es consulta ajax se toman los nombres del Jquery, De lo contrario, se toman los filtros de impresión */
            if ($flag == 1) {
                $fecha_ini = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
                $banco     = ($post_array['banco'] != '') ? $post_array['banco'] : null;
                $cuenta    = ($post_array['cuenta'] != '') ? $post_array['cuenta'] : null;
                $proveedor = ($post_array['proveedor'] != '') ? $post_array['proveedor'] : null;
                $estado    = ($post_array['estado'] !== '') ? $post_array['estado'] : null;
            } else {
                $banco = ($post_array['filtro_banco'] != '') ? $post_array['filtro_banco'] : null;
                $proveedor = ($post_array['filtro_proveedor'] != '') ? $post_array['filtro_proveedor'] : null;
                $cuenta = ($post_array['filtro_cuenta'] != '') ? $post_array['filtro_cuenta'] : null;
                $fecha_ini = ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                $fecha_fin = ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;
                $estado    = ($post_array['filtro_estado'] !== '') ? $post_array['filtro_estado'] : null;
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = null;
            //Se crean las condicionales del reporte
            if ($banco) {
                $where['ban_id'] = $banco;
                $data['banco'] = $this->gsatelite->get_registro('ban_banco', array('ban_id'=>$banco));
            }
            if ($proveedor) {
                $where['che_id_prv'] = $proveedor;
            }
            if ($cuenta) {
                $where['cub_id'] = $cuenta;
            }
            if ($fecha_ini != '' && $fecha_fin != '') {
                $where['che_fecha >='] = $fecha_ini;
                $where['che_fecha <='] = $fecha_fin;
                $data['fecha_inicio'] = $fecha_ini;
                $data['fecha_fin'] = $fecha_fin;
            }
            if ($estado !== null) {
                $estado = ((int)$estado === 2)?0:$estado;
                $where['che_estado'] = $estado;
            }
            $data['order_by'] = "che_fecha ASC";
            $data['reporte'] = $this->utm_model->get_cheques_emitidos($where);
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_cheques_emitidos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('utm/reporteria/reporte_cheques_emitidos', $data, true);
            if (count($data['reporte']) > 0) {
                $montos = array_column($data['reporte'], 'che_monto');
                $total = array_sum($montos);
                $pie = '<tr><th colspan="8" style="text-align:right;">Total $</th><th style="text-align:right;">' . number_format($total, 2) . '</th></tr>';
            } else {
                $pie = '';
            }
            if ($flag) {
                echo json_encode(array('tabla' => $html, 'pie' => $pie));
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Cheques Emitidos';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_Cheques_Emitidos_' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Cheques_Emitidos', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    echo $html;
                }
            }
        }
    }

    /*
     * @author: Mario Marquez
     */

    public function conciliaciones_bancarias() {
        //$this->db->join('ban_banco','ban_id = cub_id_ban','inner');
        $select = $this->gsatelite->get_dropdown('ban_banco', '{ban_prefijo}:{ban_nombre}', '', array('ban_estado'=>1) ,null,null,'ban_id',true);
        $data['bancos'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        /*$data['cuentas'] = $this->gsatelite->get_dropdown('cub_cuenta_bancaria', '{ban_nombre}: {cub_numero}', 'cuentas', array('cub_estado' => 1), null, null, null, true);*/
        $data['titulo_personal'] = "Detalle de conciliaciones bancarias";
        $this->_cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */

    public function reporte_conciliaciones_bancarias($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();
            //var_dump($post_array);die();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            if ($flag == 1) {
                $cuenta = ($post_array['cuenta'] != '') ? $post_array['cuenta'] : null;
                $banco = ($post_array['banco'] != '') ? $post_array['banco'] : null;
                $fecha_ini = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
            } else {
                $cuenta = ($post_array['filtro_cuenta'] != '') ? $post_array['filtro_cuenta'] : null;
                $banco = ($post_array['ban_banco'] != '') ? $post_array['ban_banco'] : null;
                $fecha_ini = ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                $fecha_fin = ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;
            }



            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;

            if ($cuenta != null) {
                $where['cub_id'] = $cuenta;

                $this->db->join('ban_banco','ban_id = cub_id_ban','inner');
                $cuenta_data = $this->gsatelite->get_tabla('cub_cuenta_bancaria', array('cub_id' => $cuenta));
                $data['cuenta'] = $cuenta_data[0]['ban_nombre'] . " - " . $cuenta_data[0]['cub_numero'];
            }

            //Se crean las condicionales del reporte
            if ($fecha_ini != '' && $fecha_fin != '') {
                $where['DATE_FORMAT(tra_fecha,"%Y-%m-%d") >='] = $fecha_ini;
                $where['DATE_FORMAT(tra_fecha,"%Y-%m-%d") <='] = $fecha_fin;
                $data['fecha_inicio'] = $fecha_ini;
                $data['fecha_fin'] = $fecha_fin;
            }
            //print_r($where); die();
            $where['tra_conciliado']  = 1;

            $tipos_transacciones         = json_decode($this->gsatelite->get_parametro('SYS_TIPO_TRANSACCION'));
            $where['tra_id_ttb !=']  = $tipos_transacciones->ANULACION_CHEQUE;
            
            $data['order_by'] = $order = "tra_fecha, tra_id ASC";

            $data['reporte'] = $this->utm_model->get_conciliaciones_bancarias($where, $order);
            //print_r($this->db->last_query());die();
            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_conciliaciones_bancarias_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;
            //print_r($data);
            $html = $this->load->view('utm/reporteria/reporte_conciliaciones_bancarias', $data, true);

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Detalle de Conciliaciones Bancarias';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Conciliaciones_Bancarias_' . date('dmY');

                    $reporte = $header . $html;
                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'P', 'reporte_conciliaciones_bancarias', 'Letter');
                    //echo $reporte;die();
                    //$this->pdf->SetMargins(10, 10, 10, 50);
                    //$this->pdf->reportePDF('utm/reporteria/reporte_conciliaciones_bancarias',$reporte, '');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_conciliaciones_bancarias_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Detalle de Conciliaciones Bancarias';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }
    /**
    * @author Manuel Anzora
    * @since 2018-12-06
    * @return reporte consolidado de conciliacion bancaria
    */

    public function resumen_conciliaciones(){
         $data['bancos'] = $this->gsatelite->get_dropdown('ban_banco', '{ban_prefijo}:{ban_nombre}', '', array('ban_estado'=>1) ,null,null,'ban_id',true);
        /*$data['cuentas'] = $this->gsatelite->get_dropdown('cub_cuenta_bancaria', '{ban_nombre}: {cub_numero}', 'cuentas', array('cub_estado' => 1), null, null, null, true);*/
        $data['titulo_personal'] = "Resumen de conciliaciones bancarias";
        $this->_cargarvista($data);
    }
    /**
    * @author Manuel Anzora
    * @since 2018-12-06
    * @return reporte consolidado de conciliacion bancaria
    * $flag = 1 si se accede desde ajax
    */
    public function reporte_resumen_conciliaciones($flag=null){
        if($_POST){
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            if ($flag == 1) {
                $cuenta = ($post_array['cuenta'] != '') ? $post_array['cuenta'] : null;
                $banco = ($post_array['banco'] != '') ? $post_array['banco'] : null;
                $fecha_ini = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
            } else {
                $cuenta = ($post_array['filtro_cuenta'] != '') ? $post_array['filtro_cuenta'] : null;
                $banco = ($post_array['ban_banco'] != '') ? $post_array['ban_banco'] : null;
                $fecha_ini = ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                $fecha_fin = ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;

            if ($cuenta != null) {
                $where['cub_id'] = $cuenta;

                $this->db->join('ban_banco','ban_id = cub_id_ban','inner');
                $cuenta_data = $this->gsatelite->get_tabla('cub_cuenta_bancaria', array('cub_id' => $cuenta));
                $data['cuenta'] = $cuenta_data[0]['ban_nombre'] . " - " . $cuenta_data[0]['cub_numero'];
            }

            //Se crean las condicionales del reporte
            if ($fecha_ini != '' && $fecha_fin != '') {
                $where['DATE(tra_fecha) >='] = $fecha_ini;
                $where['DATE(tra_fecha) <='] = $fecha_fin;
                $data['fecha_inicio'] = $fecha_ini;
                $data['fecha_fin'] = $fecha_fin;
            }
            $where['tra_conciliado']  = 1;
            // $where['tra_aplicar']  = 0;
            $data['reporte'] = $this->utm_model->get_resumen_conciliaciones_bancarias($where);
            
            $condition = ['cub_id'=>$cuenta, 'fecha'=> $fecha_fin];
            $data['saldos'] = $this->utm_model->get_saldos_resumen_consolidacion($condition);
            //print_r($this->db->last_query());
            //print_r($data['saldos']);
            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_resumen_conciliaciones_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;
            //$header = $this->load->view('reporte/header', $data, true);
            $html = $this->load->view('utm/reporteria/reporte_resumen_conciliaciones', $data, true);

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Resumen Conciliaciones Bancarias';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Resumen_Conciliaciones_' . date('dmY');

                    $reporte = $header . $html;
                    

                    $GLOBALS['nombre_reporte'] = 'Reporte_Resumen_Conciliaciones_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'P', 'Reporte_Resumen_Conciliaciones_', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_resumen_conciliaciones_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Resumen de Conciliaciones Bancarias';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    function listado_retencion_cheques() {
        $data['proveedor'] = $this->consultas->cargar_todo('prv_proveedor');
        $data['titulo_personal'] = "Listado de Retenciones de cheques";

        $data['proveedores'] = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
        $tipo_nit = $this->gsatelite->get_parametro('TIPO_DOCUMENTO_NIT_PROVEEDOR');

        $data['documento_nit'] = $this->gsatelite->get_tabla('tde_tipo_documento', array('tde_id' => $tipo_nit));

        $this->_cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */

    public function reporte_retencion_cheques($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();
            if ($flag == 1) {
                $proveedor = ($post_array['proveedor'] != '') ? $post_array['proveedor'] : null;
                $nit       = ($post_array['nit'] != '') ? $post_array['nit'] : null;
                $fecha_ini = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
                $tipo      = ($post_array['tipo'] !== '')?$post_array['tipo'] : 3;    
            } else {
                $proveedor = ($post_array['filtro_proveedor'] != '') ? $post_array['filtro_proveedor'] : null;
                $nit       = ($post_array['filtro_nit'] != '') ? $post_array['filtro_nit'] : null;
                $fecha_ini = ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                $fecha_fin = ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;
                $tipo      = ($post_array['filtro_tipo'] !== '')?$post_array['filtro_tipo'] : 3; 
            }

            switch ($tipo) {
                case 3:
                    if (($fecha_ini !== null) && ($fecha_fin !== null)) {
                        // fechas nota de abono
                        $where_nota['date_format(nta_fecha,"%Y-%m-%d") >='] = date_format(date_create($fecha_ini),'Y-m-d');
                        $where_nota['date_format(nta_fecha,"%Y-%m-%d") <='] = date_format(date_create($fecha_fin),'Y-m-d');
                        // fechas cheques
                        $where_cheq['date_format(che_fecha,"%Y-%m-%d") >='] = date_format(date_create($fecha_ini),'Y-m-d');
                        $where_cheq['date_format(che_fecha,"%Y-%m-%d") <='] = date_format(date_create($fecha_fin),'Y-m-d');
                        // $titulo .= "<p>Desde: ".$f_inicial.'&nbsp;&nbsp;&nbsp;&nbsp; Hasta: '.$f_final."</p>";
                        $data['fecha_inicio']   = $fecha_ini;
                        $data['fecha_fin']      = $fecha_fin;
                    }
                    if ($proveedor != null) {
                        $where_cheq['che_id_prv']    = $proveedor;
                        $where_nota['nta_id_prv']    = $proveedor;
                        $proveedor                   = $this->gsatelite->get_tabla('prv_proveedor',array('prv_id'=>$proveedor));
                        $nombre_proveedor            = $proveedor[0]['prv_nombre'];
                        if($proveedor[0]['prv_tipo_pers'] == 1){
                            $nombre_proveedor = $proveedor[0]['prv_apellido'];
                        }
                        $data['proveedor'] = $nombre_proveedor;                   
                    }
                    if ($nit != null) {
                        $where_cheq['dcp_valor'] = $nit;
                        $where_nota['dcp_valor'] = $nit;
                        $data['nit'] = $nit;
                    }
                    $where_cheq["dch_retencion > 0"] = NULL;
                    $order_by = "che_fecha ASC";
                    // procesamos las consultas 
                    $data['reporte'] = $this->utm_model->get_retencion_cheques($where_cheq, $order_by);
                    // print_r($this->db->last_query());die(); 
                    $data['registros_nota']    = $this->consultas->obtener_retension_notas2($where_nota);
                    // print_r($this->db->last_query());die(); 
                break;            
                case 1:
                    # solo cheques
                    if (($fecha_ini !== null) && ($fecha_fin !== null)) {
                    // fechas cheques
                        $where_cheq['date_format(che_fecha,"%Y-%m-%d") >='] = date_format(date_create($fecha_ini),'Y-m-d');
                        $where_cheq['date_format(che_fecha,"%Y-%m-%d") <='] = date_format(date_create($fecha_fin),'Y-m-d');
                    }
                    if ($proveedor !== null) {
                        $where_cheq['che_id_prv'] = $proveedor;
                        $proveedor                   = $this->gsatelite->get_tabla('prv_proveedor',array('prv_id'=>$proveedor));
                        $nombre_proveedor            = $proveedor[0]['prv_nombre'];
                        if($proveedor[0]['prv_tipo_pers'] == 1){
                            $nombre_proveedor = $proveedor[0]['prv_apellido'];
                        }
                        $data['proveedor']        = $nombre_proveedor;
                    }
                    if ($nit != null) {
                        $where_cheq['dcp_valor'] = $nit;
                        $data['nit']             = $nit;
                    }
                    $where_cheq["dch_retencion > 0"] = NULL;
                    $data['fecha_inicio']   = $fecha_ini;
                    $data['fecha_fin']      = $fecha_fin;
                    // procesamos las consultas 
                    $data['reporte'] = $this->utm_model->get_retencion_cheques($where_cheq, $order_by);
                    //print_r($this->db->last_query());die();
                break;
                case 2:
                    if (($fecha_ini !== null) && ($fecha_fin !== null)) {
                        // fechas nota de abono
                        $where_nota['date_format(nta_fecha,"%Y-%m-%d") >='] = date_format(date_create($fecha_ini),'Y-m-d');
                        $where_nota['date_format(nta_fecha,"%Y-%m-%d") <='] = date_format(date_create($fecha_fin),'Y-m-d');

                    }
                    if ($proveedor !== null) {
                        $where_nota['nta_id_prv'] = $proveedor;
                        $data['proveedor']        = $nombre_proveedor;
                    }
                    if ($nit != null) {
                        $where_nota['dcp_valor'] = $nit;
                        $data['nit']             = $nit;
                    }
                    // procesamos las consultas 
                    $data['fecha_inicio']   = $fecha_ini;
                    $data['fecha_fin']      = $fecha_fin;
                    $data['registros_nota']    = $this->consultas->obtener_retension_notas2($where_nota);
                break;
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = null;
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_retenciones_cheques_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('utm/reporteria/reporte_retencion_cheques', $data, true);

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Retención de Cheques';
                    $data['subtitulo'] = 'Período: ' . formatear_fecha('d-m-Y', $fecha_ini) . ' al ' . formatear_fecha('d-m-Y', $fecha_fin);
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_Retenciones_Cheques_' . date('dmY');
                    $reporte = $header . $html;
                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Retenciones_Cheques', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_retenciones_cheques_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Retención de Cheques';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    public function libro_bancos() {
        $this->db->join('ban_banco','ban_id = cub_id_ban','inner');
        $data['cuentas'] = $this->gsatelite->get_dropdown('cub_cuenta_bancaria', '{ban_nombre}: {cub_numero}', 'cuentas', array('cub_estado' => 1), null, null, null, true);
        $data['titulo_personal'] = "Reporte Libro de Bancos";
        $this->_cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */

    public function reporte_libro_bancos($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();
            //var_dump($post_array);die();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            if ($flag == 1) {
                $cuenta = ($post_array['cuenta'] != '') ? $post_array['cuenta'] : null;
                $fecha_ini = ($post_array['fecha_ini'] != '') ? date_format(date_create($post_array['fecha_ini']),'Y-m-d') : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date_format(date_create($post_array['fecha_fin']),'Y-m-d') : null;
            } else {
                $cuenta = ($post_array['filtro_cuenta'] != '') ? $post_array['filtro_cuenta'] : null;
                $fecha_ini = ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                $fecha_fin = ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;
            }

            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;

            //Se crean las condicionales del reporte
            if ($fecha_ini != '' && $fecha_fin != '') {
                $where['date_format(tra_fecha,"%Y-%m-%d") >='] = $fecha_ini;
                $where['date_format(tra_fecha,"%Y-%m-%d") <='] = $fecha_fin;
                $data['fecha_inicio'] = $fecha_ini;
                $data['fecha_fin'] = $fecha_fin;
            }
            if ($cuenta != null) {
                $where['tra_id_cub'] = $cuenta;

                $this->db->join('ban_banco','ban_id = cub_id_ban','inner');
                $cuenta_info = $this->gsatelite->get_tabla('cub_cuenta_bancaria', array('cub_id' => $cuenta));
                $data['cuenta'] = $cuenta_info[0]['ban_nombre'] . " - " . $cuenta_info[0]['cub_numero'];
                $data['saldo_inicial'] = $this->utm_model->getSaldoAFecha($cuenta, $fecha_ini);
            }
            $aplicadas = $this->input->post('aplicadas');            
                if($aplicadas==0){
                    //$where['tra_aplicar'] = 1;
                }  
            $order_by = "tra_fecha ASC";
            $data['cuenta'] = $cuenta_info[0];
            $data['reporte'] = $this->utm_model->get_detalle_libro_bancos($where, $order_by);
            // print_r($this->db->last_query());die();
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_libro_bancos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;
            $html = $this->load->view('utm/reporteria/detalle_reporte_libro_bancos', $data, true);//antes: reporte_libro_bancos

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Libro de Bancos';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_Retenciones_Cheques_' . date('dmY');
                    $reporte = $header . $html;
                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Libro_Bancos', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    echo $html;
                }
            }
        }
    }

    public function get_cubxtipo_cuenta() {
        $tpc_id = $this->input->post('tpc_id');
        $ban_id = $this->input->post('ban_id');
        $res = $this->gsatelite->get_dropdown('cub_cuenta_bancaria', '{cub_numero} - {cub_nombre}', 'cuenta_bancaria', array('cub_estado' => 1, 'cub_id_tpc' => $tpc_id, 'cub_id_ban'=> $ban_id), null, null, null, true);
        $res = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $res);
        echo json_encode(array('options' => $res));
        //print_r($res); die();
    }

    public function get_bancos_cuentas() {
        satelite_validar(true);

        if ($this->input->post()) {
            $banco      = $this->input->post('banco');

            $cuentas    = $this->gsatelite->get_tabla('cub_cuenta_bancaria', array('cub_id_ban'=>$banco, 'cub_estado'=>1));

            $html       = '<option value=""></option>';
            foreach ($cuentas as $key => $value) {
                 $html .= '<option value="'.$value['cub_id'].'">'.$value['cub_numero'].' - '.$value['cub_nombre'].'</option>';
             }

             echo json_encode(array('html'=>$html));
             die();
        }
    }

    /**
    * @author Habby Lovo
    * @since 2018-02-05
    * @return reporte consolidado de compras por proyecto
    */
    public function cheques_proyecto($consulta=0){
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        if ($_POST) {
            if ($consulta > 0) {
                $post_array = $_POST;

                $fecha_ini = $post_array['fecha_ini'];
                $fecha_fin = $post_array['fecha_fin'];
                $cliente = $post_array['cliente'];
                $proyecto = $post_array['proyecto'];
                $estado = $post_array['estado'];

                $data['fecha_ini']  = $fecha_ini;
                $data['fecha_fin']  = $fecha_fin;
                $data['cliente_id']  = $cliente;
                $data['proyecto']  = $proyecto;
                $data['estado']   = $estado;


                $where = null;

                if ($fecha_ini != '' && $fecha_fin != '') {
                    $where['che_fecha >='] = date('Y-m-d', strtotime($fecha_ini));
                    $where['che_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
                }

                if(trim($cliente) != ""){
                    $where['pcl_id_cli'] = $cliente;
                }
                if(trim($proyecto) != ""){
                    $where['pcl_id'] = $proyecto;
                }
                if(trim($estado) != ""){
                    $where['pcl_id_epr'] = $estado;
                }

                $proyectos = $this->utm_model->get_documento_proyecto_detalle($where);
                if(count($proyectos) == 1){
                    $proyectos[0] = array_filter($proyectos[0]);
                    $proyectos = array_filter($proyectos);
                }
                $data['proyectos'] = $proyectos;
                $data['tipo_reporte'] = 'grid';
                $html = $this->load->view('utm/reporteria/grid_cheques_proyecto', $data, true);
                echo $html;
                die();
            }
        } else {
            $cli = $this->gsatelite->get_tabla('cli_cliente',array('cli_estado' =>1));
            $est = $this->gsatelite->get_tabla('epr_estado_proyecto',array('epr_estado' =>1));
            $data['clientes'] = $cli;
            $data['estados'] = $est;
            $data['titulo_personal'] = "Consolidado de compras por proyecto";
            cargarvista($data);
        }
    }

    public function imprimir_cheques_proyecto(){
        $post_array = $_POST;

        $fecha_ini = $post_array['rpt_txtFechaIni'];
        $fecha_fin = $post_array['rpt_txtFechaFin'];
        $cliente = $post_array['rpt_cliente'];
        $proyecto = $post_array['rpt_proyecto'];
        $estado = $post_array['rpt_estado'];
        $tipo = $post_array['rpt_tipo'];

        $data['fecha_ini']  = $fecha_ini;
        $data['fecha_fin']  = $fecha_fin;
        $data['cliente_id']  = $cliente;
        $data['proyecto']  = $proyecto;
        $data['estado']   = $estado;

        $where = null;

        if ($fecha_ini != '' && $fecha_fin != '') {
            $where['che_fecha >='] = date('Y-m-d', strtotime($fecha_ini));
            $where['che_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
        }

        if(trim($cliente) != ""){
            $where['pcl_id_cli'] = $cliente;
        }
        if(trim($proyecto) != ""){
            $where['pcl_id'] = $proyecto;
        }
        if(trim($estado) != ""){
            $where['pcl_id_epr'] = $estado;
        }

        $proyectos = $this->utm_model->get_documento_proyecto_detalle($where);
        if(count($proyectos) == 1){
            $proyectos[0] = array_filter($proyectos[0]);
            $proyectos = array_filter($proyectos);
        }
        $data['proyectos'] = $proyectos;
        $data['tipo_reporte'] = $tipo;

        if($tipo == 'excel'){
            $filename = 'rpt_listado_proyectos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $this->load->view('utm/reporteria/grid_cheques_proyecto', $data);
            //$this->load->view('cotizaciones/consultas/reporte_listado_proyectos', $data);
        } else{
            $this->load->library('pdf');
            $data['titulo'] = 'Listado de compras por proyecto';
            $data['solotitulo'] = '1';

            $header = $this->load->view('reporte/header', $data, true);
            $html = $this->load->view('utm/reporteria/grid_cheques_proyecto', $data, true);
            $GLOBALS['nombre_reporte'] = 'rpt_listado_proyectos' . date('dmY');

            $this->pdf->makePdf($header.$html, 'L', 'rpt_listado_proyectos', 'Letter');
        }
    }

    public function resumen_cuentas_bancarias($consulta=0){
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        if ($_POST) {
            if ($consulta > 0) {
                $post_array = $_POST;

                $banco = $post_array['banco'];
                $cuenta = $post_array['cuenta'];

                $data['banco']  = $banco;
                $data['cuenta']  = $cuenta;

                $where = null;

                if(trim($banco) != ""){
                    $where['ban_id'] = $banco;
                }
                if(trim($cuenta) != ""){
                    $where['cub_id'] = $cuenta;
                }

                $cuentas_reg = $this->utm_model->get_cuentas_bancarias_rpt($where);

                $data['cuentas'] = $cuentas_reg;
                $data['tipo_reporte'] = 'grid';
                $html = $this->load->view('utm/reporteria/imprimir_cuentas_bancarias', $data, true);
                echo $html;
                die();
            }
        } else {
            // Catalogo de Bancos
            $select = $this->gsatelite->get_dropdown('ban_banco', '{ban_nombre}', '', array('ban_estado' => 1), null, '', 'ban_id', true);
            $data["bancos_slc"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $data['titulo_personal'] = "Reporte de saldos por cuentas bancarias";
            cargarvista($data);
        }
    }

    function imprimir_cuentas_bancarias(){

        $banco = $this->input->post('rpt_slcBanco');
        $cuenta = $this->input->post('rpt_slcCuenta');

        $data['banco']  = $banco;
        $data['cuenta']  = $cuenta;

        $where = null;

        if(trim($banco) != ""){
            $where['ban_id'] = $banco;
        }
        if(trim($cuenta) != ""){
            $where['cub_id'] = $cuenta;
        }

        $cuentas_reg = $this->utm_model->get_cuentas_bancarias_rpt($where);
        $data['cuentas'] = $cuentas_reg;

        $tipo = $this->input->post('rpt_tipo');
        $data['tipo_reporte'] = $tipo;

        if($tipo == 'excel'){
            $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $this->load->view('utm/reporteria/imprimir_cuentas_bancarias', $data);
        } else{
            $data['titulo'] = 'saldos por cuentas bancarias';
            $header = $this->load->view('reporte/header', $data, true);
            $html = $this->load->view('utm/reporteria/imprimir_cuentas_bancarias', $data, true);
            $GLOBALS['nombre_reporte'] = 'Abono_detallado' . date('dmY');
            $this->pdf->makePdf($header.$html, 'L', 'Abono_detallado', 'Letter');
        }
    }

    public function informe_transaccion($id = null)
    {
      satelite_validar();

      if(trim($id) != null){
          $where['tra_id'] = $id;
      }

      $info = $this->utm_model->get_info_trans($where);
    //  var_dump($info);die();
      $data['info'] = $info;

      $data['titulo'] = 'Transacciones';
      $header = $this->load->view('reporte/header', $data, true);
      $html = $this->load->view('utm/reporteria/informe_transaccion', $data, true);
      $GLOBALS['nombre_reporte'] = 'Abono_detallado' . date('dmY');
      $this->pdf->makePdf($header.$html, 'P', 'Abono_detallado', 'Letter');
    }

    public function get_cuentas_banco(){
        $banco = (trim($this->input->post('banco')) != "") ? $this->input->post('banco') : null;

        $cuentas_reg = $this->gsatelite->get_tabla('cub_cuenta_bancaria', array('cub_id_ban'=>$banco, 'cub_estado'=>1));
        //print_r($this->db->last_query());
        $select = "<option value=''></option>";
        foreach ($cuentas_reg as $key => $value) {
            $select .= "<option value='".$value['cub_id']."'>".$value['cub_numero'].' - '.$value['cub_nombre']."</option>";
        }
        echo json_encode(array('cuentas'=>$select));
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }
    
    /**
    * @author Manuel Anzora
    * @since 2018-12-05
    * @return obtiene cuentas contables, via ajax
    */
    public function get_cuentas(){
        if($_POST){
            $select = '<option value=""></option>';
            $banco = $this->input->post('banco');
            $cuentas = $this->gsatelite->get_dropdown('cub_cuenta_bancaria', '{cub_nombre}:{cub_numero}', '', array('cub_estado'=>1, 'cub_id_ban'=>$banco) ,null,null,'cub_id',true);
            $select .= str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $cuentas); 
            echo $select;
        }
    }

    public function rendicion_cuentas($flag = null){
        satelite_validar();
        if ($this->input->post()){
            $post_array = $this->input->post();
            /* Si es consulta ajax se toman los nombres del Jquery. De lo contrario, se toman los filtros de impresión */
            if ($flag) {
                $txtFechaIni  = ($post_array['txtFechaIni'] != '') ? $post_array['txtFechaIni'] : null;                
                $txtFechaFin  = ($post_array['txtFechaFin'] != '') ? $post_array['txtFechaFin'] : null;
                $slcBanco     = ($post_array['slcBanco'] != '')    ? $post_array['slcBanco']    : null;
                $slcCuenta    = ($post_array['slcCuenta'] != '')   ? $post_array['slcCuenta']   : null;
                $tipo_reporte = $post_array['tipo_reporte']; 
            } else {
                $txtFechaIni  = ($post_array['h_txtFechaIni'] != '') ? $post_array['h_txtFechaIni'] : null;                
                $txtFechaFin  = ($post_array['h_txtFechaFin'] != '') ? $post_array['h_txtFechaFin'] : null;
                $slcBanco     = ($post_array['h_slcBanco'] != '')    ? $post_array['h_slcBanco']    : null;
                $slcCuenta    = ($post_array['h_slcCuenta'] != '')   ? $post_array['h_slcCuenta']   : null;
                $tipo_reporte = $post_array['tipo_reporte']; 
                                
                $meses   = array("","ENERO","FEBRERO","MARZO","ABRIL","MAYO","JUNIO","JULIO","AGOSTO","SEPTIEMBRE","OCTUBRE","NOVIEMBRE","DICIEMBRE");                 
                $inicial = explode("-", $txtFechaIni);
                $m_i     = (int)$inicial[1];
                $final   = explode("-", $txtFechaFin);
                $m_f     = (int)$final[1];

                $data['banco_txt']  = ($post_array['h_banco_txt'] != '')  ? '<b>BANCO: </b>' .  $post_array['h_banco_txt']  : null;
                $data['cuenta_txt'] = ($post_array['h_cuenta_txt'] != '') ? '<b>CUENTA: </b>' . $post_array['h_cuenta_txt'] : null; 
                $data['periodo']    = 'DEL ' . $inicial[0] . ' DE ' . $meses[$m_i] . ' DE ' . $inicial[2] . ' HASTA EL '. $final[0] . ' DE '. $meses[$m_f] . ' DE ' . $final[2];
            }

            $where = array();
            if ($slcBanco != null) {
                $where['ban_id'] = $slcBanco;
            }
            if ($slcCuenta != null) {
                $where['cub_id'] = $slcCuenta;
            }
            if ($txtFechaIni != null && $txtFechaFin != null) {
                $where['DATE(tra_fecha) >='] = formatear_fecha('Y-m-d', $txtFechaIni);
                $where['DATE(tra_fecha) <='] = formatear_fecha('Y-m-d', $txtFechaFin);
            }
            $ultimo_saldo = $this->utm_model->ultimo_saldo($slcCuenta, formatear_fecha('Y-m-d', $txtFechaIni));
            $ingresos     = $this->utm_model->ingresos_cuenta($where);
            $egresos      = $this->utm_model->egresos_x_rubro($where);

            $data['ultimo_saldo'] = $ultimo_saldo;
            $data['ingresos']     = $ingresos;
            $data['egresos']      = $egresos;
            
            $filename = 'rpt_rendicion_ctas' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);          
            $data['filename']     = $filename;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['empresa']      = mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');      
            $data['titulo']       = "Estado de Rendición de cuentas";
            $data['sub_titulo']   = "(Cifras expresadas en Dólares de los Estados Unidos de América)";
            $html = $this->load->view('utm/reporteria/filtrar_rendicion_cuentas', $data, true);
            
            if ($flag) {                
                echo $html;
                die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    $GLOBALS['nombre_reporte']  = 'reporte_rendicion_cuentas_' . date('dmY');
                    $header                     = $this->load->view('reporte/header', $data, true);
                    $reporte                    = $html;
                    //$margenes                   = array(10,0,10);
                    $this->pdf->makePdf($reporte, 'P','','Letter');
                } 
                elseif ($tipo_reporte == 'excel') {
                    //$data['titulo']     = 'Estado de Rendición de cuentas';
                    echo $html;
                }
            }
            
        } else {
            $select_bancos           = $this->gsatelite->get_dropdown('ban_banco', '{ban_nombre}', 'bancos', array('ban_estado' => 1), null, null, null, true);
            $data["bancos"]          = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select_bancos);
            $data['titulo_personal'] = "Rendicion de Cuentas";
            $this->_cargarvista($data);
        }
    }

    /*Obtiene todas las cuentas asociadas a un grupo de bancos*/
    public function cuentas_x_bancos(){        
        if ($this->input->post()){
            $bancos = $this->input->post('id_banco');
            //$in     = implode(',', $bancos);
            //$where  = "cub_estado = 1 AND cub_id_ban in (".$in.")";
            $where  = "cub_estado = 1 AND cub_id_ban =".$bancos;
            $this->db->join('ban_banco','cub_id_ban = ban_id','inner');
            $ctas   = $this->gsatelite->get_dropdown('cub_cuenta_bancaria', 'Cuenta: {cub_numero} ({cub_nombre})', 'cuentas', $where, null, null, null, true);
            //$select = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $ctas);            
            echo $ctas;
            die();            
        }   
    }

    public function flujo_efectivo($flag = null){
        satelite_validar();
        if ($this->input->post()){
            $post_array = $this->input->post();
            /* Si es consulta ajax se toman los nombres del Jquery. De lo contrario, se toman los filtros de impresión */
            if ($flag) {
                $txtFechaIni  = ($post_array['txtFechaIni'] != '') ? $post_array['txtFechaIni'] : null;                
                $txtFechaFin  = ($post_array['txtFechaFin'] != '') ? $post_array['txtFechaFin'] : null;
                $slcBanco     = ($post_array['slcBanco'] != '')    ? $post_array['slcBanco']    : null;
                $slcCuenta    = ($post_array['slcCuenta'] != '')   ? $post_array['slcCuenta']   : null;
                $tipo_reporte = $post_array['tipo_reporte']; 
            } else {
                $txtFechaIni  = ($post_array['h_txtFechaIni'] != '') ? $post_array['h_txtFechaIni'] : null;                
                $txtFechaFin  = ($post_array['h_txtFechaFin'] != '') ? $post_array['h_txtFechaFin'] : null;
                $slcBanco     = ($post_array['h_slcBanco'] != '')    ? $post_array['h_slcBanco']    : null;
                $slcCuenta    = ($post_array['h_slcCuenta'] != '')   ? $post_array['h_slcCuenta']   : null;
                $tipo_reporte = $post_array['tipo_reporte']; 
                                
                $meses   = array("","ENERO","FEBRERO","MARZO","ABRIL","MAYO","JUNIO","JULIO","AGOSTO","SEPTIEMBRE","OCTUBRE","NOVIEMBRE","DICIEMBRE");                 
                $inicial = explode("-", $txtFechaIni);
                $m_i     = (int)$inicial[1];
                $final   = explode("-", $txtFechaFin);
                $m_f     = (int)$final[1];

                $data['banco_txt']  = ($post_array['h_banco_txt'] != '')  ? '<b>BANCO: </b>' .  $post_array['h_banco_txt']  : null;
                $data['cuenta_txt'] = ($post_array['h_cuenta_txt'] != '') ? '<b>CUENTA: </b>' . $post_array['h_cuenta_txt'] : null;                 
                $data['periodo']    = 'ENTRE EL ' . $inicial[0] . ' DE ' . $meses[$m_i] . ' DE ' . $inicial[2] . ' Y EL '. $final[0] . ' DE '. $meses[$m_f] . ' DE ' . $final[2];
                $data['cuenta']     = ($post_array['h_cuenta_txt'] != '') ? $post_array['h_cuenta_txt'] : null; 
            }        
            
            $where = array();
            if ($slcBanco != null) {
                $where['ban_id'] = $slcBanco;
            }
            if ($slcCuenta != null) {
                $where['cub_id'] = $slcCuenta;
            }
            if ($txtFechaIni != null && $txtFechaFin != null) {
                $where['DATE(tra_fecha) >='] = formatear_fecha('Y-m-d', $txtFechaIni);
                $where['DATE(tra_fecha) <='] = formatear_fecha('Y-m-d', $txtFechaFin);
            }
            $filename     = 'rpt_flujo_efectivo_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);          
            $ultimo_saldo = $this->utm_model->ultimo_saldo($slcCuenta, formatear_fecha('Y-m-d', $txtFechaIni));
            $ingresos     = $this->utm_model->ingresos_cuenta($where);
            $egresos      = $this->utm_model->egresos_cuenta($where);
            $dpv_pdtes    = $this->utm_model->pagos_dpv_pdtes();

            $data['ultimo_saldo'] = $ultimo_saldo;
            $data['ingresos']     = $ingresos;
            $data['egresos']      = $egresos;
            $data['dpv_pdtes']    = $dpv_pdtes;            
            $data['filename']     = $filename;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['empresa']      = mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');      
            $data['titulo']       = "Reporte de Proyecciones";
            $data['sub_titulo']   = "(Cifras expresadas en Dólares de los Estados Unidos de América)";

            $html = $this->load->view('utm/reporteria/filtrar_flujo_efectivo', $data, true);
            
            if ($flag) {                
                echo $html;
                die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    $GLOBALS['nombre_reporte']  = 'reporte_rendicion_cuentas_' . date('dmY');
                    //$header                     = $this->load->view('reporte/header', $data, true);
                    $reporte                    = $html;
                    $this->pdf->makePdf($reporte, 'P','','Letter');
                } 
                elseif ($tipo_reporte == 'excel') {
                    echo $html;
                    die();
                }
            }
            
        } else {
            $select_bancos           = $this->gsatelite->get_dropdown('ban_banco', '{ban_nombre}', 'bancos', array('ban_estado' => 1), null, null, null, true);
            $data["bancos"]          = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select_bancos);
            $data['titulo_personal'] = "Flujo de Efectivo";
            $this->_cargarvista($data);
        }
    }

    /**
    * @author Nelson Soriano
    * @since  26-04-2019
    * @return Pantalla con los filtros para procesar el reporte de cheques no cobrados
    */
    public function cheques_no_cobrados(){
        satelite_validar();
        $data['permisos']       = $this->gsatelite->get_permisos_opcion();
        $cuentas                = $this->utm_model->get_cuentasx(array('cub_estado' => 1));
        $options                = '';
        foreach ($cuentas as $key => $valor) {
            $options .= '<option value="'.$valor["id"].'">'.$valor["cuenta"].'</option>';               
        }       
        $data['cub'] = $options;               
        $data['titulo_personal']    = 'Cheques no cobrados';
        $this->_cargarvista($data);
    }

    /**
    * @author Nelson Soriano
    * @since  26-04-2019
    * @return retorna preview del reporte / word / excel
    */

     public function ver_cheques_no_cobrados($reporte = false){
        satelite_validar();
        // Captura de filtros del reporte
        $fecha_ini     = ($this->input->post('fecha_ini') !== '')?$this->input->post('fecha_ini'):null;
        $fecha_fin     = ($this->input->post('fecha_fin') !== '')?$this->input->post('fecha_fin'):null;
        $cuenta        = ($this->input->post('cuenta') !== '')?$this->input->post('cuenta'):null;
        $filtro_titulo = '';
        //Construimos las condicionales
        $where['tra_aplicar']     = 0;
        $where['che_estado']      = 1;

        if (($fecha_ini !== null) && ($fecha_fin !== null)) {
            $where['date_format(che_fecha,"%Y-%m-%d") >='] = date_format(date_create($fecha_ini),'Y-m-d');
            $where['date_format(che_fecha,"%Y-%m-%d") <='] = date_format(date_create($fecha_fin),'Y-m-d');     
            $filtro_titulo  .= 'Desde: '.$fecha_ini.'<br>';
            $filtro_titulo  .= 'Hasta: '.$fecha_fin.'<br>';       
        }

        if ($cuenta !== null) {
            $where['cub_id'] = $cuenta;
            $filtro_titulo  .= 'Cuenta: '.$this->gsatelite->get_campo('cub_cuenta_bancaria','cub_nombre',array('cub_id' =>$cuenta));
        }

        $data['info'] = $this->utm_model->get_no_pagados($where,'che_id');       
        $html = $this->load->view('utm/reporteria/ver_cheques_no_cobrados', $data, true);

        if (((int) $reporte == 1)) {
            $tipo = $this->input->post('rpt_tipo');
           switch ($tipo) {
               case 'excel':
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=cheques_no_pagados-".date('d-m-Y_His').".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='0'>
                    <tr><th colspan='5' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                    <tr><th colspan='5' align='center' >Cheques no pagados</th></tr>
                    <tr><th colspan='5' align='center' >".$filtro_titulo. "</th></tr>
                    </table>";
                    echo $html;
                    die();
                   break;

                case 'pdf':
                    $this->load->library('pdf');
                    $html_header=$this->load->view('reporte/header', array('titulo' => "Cheques no pagados. <br /> $filtro_titulo", 'solotitulo'=> true), true);
                    $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                    $this->pdf->makePDF($html_header.$html,'lanscape', 'notas_abono','Legal');
                    die();
                   break;
           }
        }
        echo $html;
        die();
     }

    /**
    * @author Nelson Soriano
    * @since  29-04-2019
    * @return Vista y controles para gestionar el reporte
    * @param  none
    * @descroption: Reporte de transacciones no conciliadas por tipo
    **/

    public function transacciones_no_conciliadas(){
        satelite_validar();
        $data['permisos']       = $this->gsatelite->get_permisos_opcion();
        $cuentas                = $this->utm_model->get_cuentasx(array('cub_estado' => 1));
        $options                = '';
        foreach ($cuentas as $key => $valor) {
            $options .= '<option value="'.$valor["id"].'">'.$valor["cuenta"].'</option>';               
        }       
        $data['cub'] = $options;               
        $data['titulo_personal']    = 'Cheques no cobrados';
        $this->_cargarvista($data);
    }

    public function generar_reporte_transacciones_na($reporte = null){
        satelite_validar();
        //ini_set( 'memory_limit', '81928M' );
        ini_set('max_execution_time', '9999');
        $desde    = ($this->input->post('fecha_ini') !== '')?$this->input->post('fecha_ini'):null;
        $hasta    = ($this->input->post('echa_fin') !== '')?$this->input->post('echa_fin'):null;
        $cuenta   = ($this->input->post('cuenta'))?(int)$this->input->post('cuenta'):null;

        if ( ($desde !== null) && ($hasta !== null) && ($cuenta !== null)) {
            $where_saldo2['date_format(tra_fecha,"%Y-%m-%d") >=']  = date_format(date_create($desde),'Y-m-d');
            $where_saldo2['date_format(tra_fecha,"%Y-%m-%d") <='] = date_format(date_create($hasta),'Y-m-d');
            $data['info']    = array('33'=>1);
            $desde           = date_format(date_create($desde),'Y-m-d');
            $fin             = date_format(date_create($hasta),'Y-m-d');
            $numero          = $this->gsatelite->get_campo('cub_cuenta_bancaria','cub_numero',array('cub_id' => $cuenta));
            $id              = $this->gsatelite->get_campo('cub_cuenta_bancaria','cub_id_ban',array('cub_id' => $cuenta));
            $banco           = $this->gsatelite->get_campo('ban_banco','ban_nombre',array('ban_id' => $id));
            $data['cuenta']  = $banco.': '.$numero;
            $data['desde']   = $desde;
            $data['hasta']   = $fin;
            $data['saldo_contable']  = $this->utm_model->get_saldo_contable($desde,$fin,$cuenta);
            $data['saldo_trans_dep'] = $this->utm_model->get_transact_no_conciliadas(array('tra_id_cub' => $cuenta,'date_format(tra_fecha,"%Y-%m-%d") >= ' => $desde,'date_format(tra_fecha,"%Y-%m-%d") <= ' =>$fin,'tra_estado' => 1,'ttb_deposito' => 1,'ttb_estado' => 1));
            $data['saldo_trans_ret'] = $this->utm_model->get_transact_no_conciliadas(array('tra_id_cub' => $cuenta,'date_format(tra_fecha,"%Y-%m-%d") >= ' => $desde,'date_format(tra_fecha,"%Y-%m-%d") <= ' =>$fin,'tra_estado' => 1,'ttb_retiro'   => 1,'ttb_estado' => 1));
            $data['decimales']       = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $data['tipo']            = $this->input->post('rpt_tipo');
            $html = $this->load->view('utm/reporteria/generar_reporte_transacciones_na',$data,true);
            if ($reporte !== null) {
                $tipo = $this->input->post('rpt_tipo');
                switch ($tipo) {
                case 'pdf':
                    $this->load->library('pdf');
                    $html_header=$this->load->view('reporte/header', array('titulo' => "", 'solotitulo'=> true), true);
                    $this->pdf->setPrintFooter(false);
                    $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                    $this->pdf->makePDF($html_header.str_replace('font-size: 14px;','font-size: 10px;',$html),'P');
                    die();
                    break;
                
                case 'excel':
                    $filtro_titulo = '';
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=transacciones_no_conciliadas-".date('d-m-Y_His').".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='0'>
                    <tr><th colspan='5' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                    <tr><th colspan='5' align='center' ></th></tr>
                    <tr><th colspan='5' align='center' >".$filtro_titulo. "</th></tr>
                    </table>";
                    echo $html;
                  die();
                    break;
                }
                    
            }
            echo $html;

        }else{
            echo "Campos con * son requeridos";
        }


    }


}/* End of file reporteria.php */
/* Location: ./application/controllers/reporteria.php */
?>
