﻿<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Index extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
	}

	function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
			$data['titulo_personal'] = "BANCOS";
			$this->_cargarvista($data);
		}
	}
    
    function gestion_bancos(){
        $r = $this->_import_controller('utm/bancos');
        $r->gestion_bancos();
    }
    
    function _import_controller($path) {
    
        static $controllers = array();
        
        if(!isset($controllers[$path])) {
        
            $parts = preg_split("~/~", $path, -1, PREG_SPLIT_NO_EMPTY);
            $c = ucfirst(array_pop($parts));
            $file = APPPATH .'/controllers/'. implode('/', $parts) .'/'. strtolower($c) . EXT;
            $error = "Could not load controller [{$controller}]";
        
            if(file_exists($file)) {
                require_once $file;
            
                if(!class_exists($c, FALSE)) {
                    throw new Exception($error);
                }
            
                $controllers[$path] = new $c;
            
            } else {
                throw new Exception($error);
            }
        }
        
        return $controllers[$path];
    }
	
	function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */