<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Cuentas
 * @author Alexis Beltran
 *
 * @package
 * @author erpConamype
 * @copyright satelite
 * @version 2013
 * @access public
 */
class Cuentas extends CI_Controller
{

    //EST_CREADO = 1;
    //EST_FIRMADO = 2;

    protected $che_add_detalle = 0;

    /**
     * Cuentas::__construct()
     *
     * @return
     */
    function __construct()
    {
        parent::__construct();
        satelite_validar();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('utm_model');
        $this->load->model('compras_model');
        $this->load->model('contabilidad_model');
        // $this->load->library('Procesos');
        /* if (ob_get_contents()) ob_end_clean();
          date_default_timezone_set('America/El_Salvador');
         */
    }

    /**
     * Cuentas::index()
     *
     * @return
     */
    function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function get_disponible_cub($registro = 0)
    {
        $r = true;
        if (!$registro) {
            $registro = $this->input->post('chq_id');
            $r = false;
        }
        $this->db->join('chq_chequera', 'chq_id_cub = cub_id');
        $cuenta = $this->db->get_where('cub_cuentas_bancarias', array('chq_id' => $registro))->row();
        if ($r) {
            return $cuenta->disponible;
        } else {
            die($cuenta->disponible);
        }
    }

    /**
     * @author Melbin Cruz
     *
     */
    function anular_cheque($id_cheque = NULL)
    {
        satelite_validar();
        if ($_POST) {
            // Actualizar el estado del cheque
            $id_cheque      = $this->input->post('id_cheque');
            $no             = $this->gsatelite->get_campo('che_cheque', 'che_numero', array('che_id' => $id_cheque));
            $id_cuenta      = $this->input->post('id_cuenta');
            $justificacion  = $this->input->post('justificar_anulacion');
            $monto          = $this->input->post('monto');

            $cheque = array(
                'che_motivo_anulacion'  => $justificacion,
                'che_estado'            => 0,
                'che_fecha_mod'         => date('Y-m-d H:i:s'),
                'che_usu_mod'           => $this->tank_auth->get_user_id(),
                'che_id_usu_anulacion'  => $this->tank_auth->get_user_id(),
                'che_fecha_anulacion'   => date('Y-m-d H:i:s')
            );

            $registro = $this->gsatelite->actualizar_array('che_cheque', $cheque, array('che_id' => $id_cheque));

            // inactivar Transaccion
            $transacion = $this->gsatelite->get_tabla('che_cheque', array('che_id' => $id_cheque));

            if ($registro == 1) {
                $tipo = 1; //Deposito

                $array_tra = array(
                    'tra_estado'    => 0,
                    'tra_fecha_mod' => date("Y-m-d H:i:s"),
                    'tra_usu_mod'   => $this->tank_auth->get_user_id()
                );

                $transaccion = $this->gsatelite->actualizar_array('tra_transaccion', $array_tra, array('tra_id' => $transacion[0]['che_id_tra']));

                // Revertimos el saldo
                $info_cheque = $this->gsatelite->get_tabla('che_cheque', array('che_id' => $id_cheque));
                $monto       = $info_cheque[0]['che_monto'];
                $ttb         = json_decode($this->gsatelite->get_parametro('SYS_TIPO_TRANSACCION'));
                $ttb         = $ttb->ANULACION_CHEQUE;
                $transaccion_old = $this->gsatelite->get_tabla('tra_transaccion', array('tra_id' => $info_cheque[0]['che_id_tra']));
                $array_tra = array(
                    'tra_id_cub'        => $transaccion_old[0]['tra_id_cub'],
                    'tra_id_ttb'        => $ttb,
                    'tra_fecha'         => date("Y-m-d H:i:s"),
                    'tra_operacion'     => 'ENTRADA POR ANULACION DE CHEQUE',
                    'tra_monto'         => $info_cheque[0]['che_monto'],
                    'tra_comprobante'   => $info_cheque[0]['che_numero'],
                    'tra_conciliado'    => 0,
                    'tra_estado'        => 1,
                    'tra_fecha_mod'     => date("Y-m-d H:i:s"),
                    'tra_usu_mod'       => $this->tank_auth->get_user_id(),
                    'tra_usu_crea'      => $this->tank_auth->get_user_id(),
                    'tra_fecha_crea'    => date("Y-m-d H:i:s"),
                    'tra_aplicar'       => 1
                );

                $transaccion = $this->gsatelite->ingresar('tra_transaccion', $array_tra);
                $actualizar = array('che_id_tra_anulacion' => $transaccion);
                $this->db->where('che_id', $id_cheque);
                $this->db->update('che_cheque', $actualizar);
            }

            //revisar los documentos del proveedor
            $detalle_cheque = $this->gsatelite->get_tabla('dch_detalle_cheque', array('dch_id_che' => $id_cheque));

            foreach ($detalle_cheque as $key => $value) {
                if ($value['dch_id_dpv'] != "") {
                    $documento_factura = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id' => $value['dch_id_dpv']));

                    $nuevo_monto_pendiente  = $documento_factura[0]['dpv_monto_pendiente'] + $value['dch_subtotal'];
                    $nuevo_abono            = $documento_factura[0]['dpv_monto_abono'] - $value['dch_subtotal'];

                    $array_dpv = array(
                        'dpv_monto_pendiente'   => $nuevo_monto_pendiente,
                        'dpv_pagado'            => ($nuevo_monto_pendiente <= 0) ? 1 : 0,
                        'dpv_monto_abono'       => $nuevo_abono
                    );
                    $this->gsatelite->actualizar_array('dpv_documento_proveedor', $array_dpv, array('dpv_id' => $value['dch_id_dpv']));
                }
            }

            //generar_contra_partida
            if ($transacion[0]['che_id_pct'] != "") {
                $this->generar_contra_partida($transacion[0]['che_id_pct'], 2, 12);
            }

            if ($transaccion > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Anulación Exitosa", 'texto_alerta' => "Se anuló el cheque correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "No se pudo realizar la operación.");
            }
            $this->session->set_flashdata($alerta);
            redirect('utm/cuentas/gestion_cheques');
        } else {
            $data['cheque']         = $this->gsatelite->get_registro('che_cheque', array('che_id' => $id_cheque));
            $data['chequera']       = $this->gsatelite->get_registro('chq_chequera', array('chq_id' => $data['cheque']->che_id_chq));
            $data['detalle_cuenta'] = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $data['chequera']->chq_id_cub))->row_array();

            //DETALLES DEL CHEQUE
            $where              = null;
            $where['dch_id_che'] = $id_cheque;
            $data['pagos']      = $this->utm_model->get_detalle_cheque($where);

            $html = $this->load->view('utm/cuentas/anular_cheque', $data, true);
            die($html);
        }
    }

    /**
     * @author Alexis Beltran
     * @return Grid de Gestion de Cuentas Bancarias
     * CAMBIO DE NOMBRE DE "gestion_cuentas" A "cuentas_bancarias" FEB/2022 
     */
    function cuentas_bancarias()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD;
        $crud->set_table('cub_cuenta_bancaria');
        $crud->set_subject('cuenta');
        $columns = array(
            'cub_id_ban',
            'cub_numero',
            'cub_nombre',
            'cub_saldo',
            'cub_fecha',
            'cub_estado'
        );
        $display_as = array(
            'cub_id_ban'    => 'Banco',
            'cub_fecha'     => 'Fecha de apertura',
            'cub_numero'    => 'Número',
            'cub_nombre'    => 'Nombre',
            'cub_saldo'     => 'Saldo Actual',
            'cub_id_orf'    => 'Origen de fondos',
            'cub_id_tpc'    => 'Tipo de cuenta',
            'cub_saldo_minimo'  => 'Saldo Mínimo',
            'cub_saldo_inicial' => 'Saldo Inicial',
            'cub_estado'    => 'Estado'
        );
        $required = array(
            'cub_id_ban',
            'cub_numero',
            'cub_nombre',
            'cub_estado',
            'cub_saldo_inicial',
            'cub_id_tpc'
        );
        $add_columns = array(
            'cub_id_ban',
            'cub_numero',
            'cub_nombre',
            'cub_saldo_inicial',
            'cub_saldo_minimo',
            'cub_saldo',
            'cub_estado',
            'cub_id_tpc',
            'cub_fecha',
            'cub_id_orf',
            'cub_usu_mod',
            'cub_fecha_mod'
        );
        $edit_columns = array(
            'cub_numero',
            'cub_nombre',
            'cub_saldo_minimo',
            'cub_id_tpc',
            'cub_id_cnt',
            'cub_fecha',
            'cub_estado',
            'cub_id_orf'
        );
        //set_relation
        $crud->set_relation('cub_id_ban', 'ban_banco', 'ban_nombre', array('ban_estado' => 1));
        $crud->set_relation('cub_id_orf', 'orf_origen_fondos', 'orf_nombre', array('orf_estado' => 1));
        $crud->set_relation('cub_id_tpc', 'tpc_tipo_cuenta', 'tpc_nombre', array('tpc_estado' => 1));
        // $crud->set_relation('cub_id_cnt', 'cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', array('cnt_estado' => 1));
        //Columns
        $crud->columns($columns);
        //Display
        $crud->display_as($display_as);
        $crud->field_type('cub_estado', 'dropdown', array('Cerrada', 'Abierta'));
        $crud->callback_column('cub_saldo_minimo', array($this, '_format_money'));
        $crud->callback_column('cub_saldo_inicial', array($this, '_format_money'));
        $crud->callback_column('cub_fecha', function ($value, $row) {
            $url_actual = uri_string();
            $filtro_fecha = (substr_count($url_actual, 'print') > 0 || substr_count($url_actual, 'export') > 0) ? false : true;
            $filtro = '<span style="display: none;">' . formatear_fecha('YmdHis', $value) . '</span>';
            $ffecha = ($value != "" && $value != null) ? date("d/m/Y", strtotime($value)) : "";
            return ($filtro_fecha) ? $filtro . $ffecha : $ffecha;
        });
        $crud->callback_column('cub_saldo', array($this, '_cuenta_saldo'));
        $crud->add_fields($add_columns);
        $crud->field_type('cub_usu_mod', 'invisible');
        $crud->field_type('cub_fecha_mod', 'invisible');

        $crud->edit_fields();
        //Set_rules
        $crud->set_rules('cub_numero', 'Número de Cuenta', 'required|alpha_dash|campo_unico[cub_cuenta_bancaria.cub_numero]');
        $crud->set_rules('cub_nombre', 'Nombre de la Cuenta', 'required');
        $crud->set_rules('cub_saldo_inicial', 'Saldo Inicial', 'required|numeric');
        $crud->set_rules('cub_saldo_minimo', 'Saldo Mínimo', 'numeric');

        //required
        $crud->required_fields($required);

        //Auditoria
        $crud->callback_before_insert(function ($post_array) {
            $post_array['cub_usu_mod'] = $this->tank_auth->get_user_id();
            $post_array['cub_fecha_mod'] = date('Y-m-d H:i:s');
            $post_array['cub_saldo'] = $this->input->post('cub_saldo_inicial');
            //     $post_array['cub_fecha'] = date('Y-m-d H:i:s'); //fecha de creación
            return $post_array;
        });
        $crud->callback_before_update(function ($post_array) {
            $post_array['cub_usu_mod'] = $this->tank_auth->get_user_id();
            $post_array['cub_fecha_mod'] = date('Y-m-d H:i:s');
            return $post_array;
        });

        // Se inhabilitan las funciones
        $crud->unset_delete();
        $crud->unset_edit();
        $crud->unset_read();

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('cub_estado', 'hidden', 1);
        } else {
            $crud->field_type('cub_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Permisos para editar
        if ($permisos['permite_editar']) {
            $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'utm/cuentas/editar_cuenta_bancaria');
            // Accion de Transacciones
            $crud->add_action('Transacciones', '', '', ' entypo-icon-retweet', function ($primary_key, $row) {
                return base_url() . "utm/cuentas/transacciones/" . $row->cub_id;
            });
            // Accion de Chequeras
            $crud->add_action('Ver Chequeras', '', '', 'icomoon-icon-list-view', function ($primary_key, $row) {
                return base_url() . "utm/cuentas/gestion_chequera?cub_id=" . $row->cub_id;
            });
        }
        // Permisos para ver
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', '', '', 'minia-icon-search', function ($primary_key, $row) {
                return base_url() . "utm/cuentas/editar_cuenta_bancaria/" . $row->cub_id . "/1";
            });
        }
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        $crud->set_language('spanish');
        $output = $crud->render();
        $data['titulo_personal'] = "Gestión cuentas";
        $this->_cargarvista($data, $output);
    }

    public function nombre_unico_cuenta($valor)
    {
        //consultar si existe una cuenta igual
        $banco = ($this->input->post('cub_id_ban') > 0) ? $this->input->post('cub_id_ban') : 0;
        $id_edit = (is_numeric(end(explode('/', uri_string())))) ? end(explode('/', uri_string())) : 0;
        $query = $this->gsatelite->get_tabla('cub_cuenta_bancaria', array('cub_nombre' => $valor, 'cub_id_ban' => $banco, 'cub_id !=' => $id_edit));
        if (count($query) > 0) {
            $this->form_validation->set_message('nombre_unico_cuenta', 'El nombre de la cuenta debe ser unico');
            return false;
        }

        return true;
    }

    /**
     * Cuentas::gestion_chequera()
     * @author Alexis Beltran
     *
     * @return
     */
    function gestion_chequera()
    {
        satelite_validar();
        try {
            $crud = new grocery_CRUD;
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud->set_table('chq_chequera');
            $crud->set_subject('chequera');
            $crud->columns('chq_id_cub', 'chq_numero', 'chq_numero_inicio', 'chq_cantidad', 'chq_tipo')
                ->display_as('chq_id_cub', 'Cuenta Bancaria')
                ->display_as('chq_numero', 'Número')
                ->display_as('chq_numero_inicio', 'Número de Cheque Inicial')
                ->display_as('chq_cantidad', 'Cantidad de Cheques')
                ->display_as('chq_tipo', 'Tipo')
                ->display_as('chq_estado', 'Estado')
                ->field_type('chq_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('chq_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                //->field_type('chq_tipo', 'dropdown', array(1=>'Talonario', 'Voucher'))
                /*
                     * F1: Troqueles ; F2: Intervision
                     */
                ->field_type('chq_tipo', 'dropdown', array(
                    '1' => 'Talonario',
                    '2' => 'Voucher',
                    '3' => 'Tipo CITI',
                    '4' => 'Tipo SCOTIABANK',
                    '5' => 'Tipo BAC F1', //BAC TROQUELES
                    '6' => 'Tipo BAC F2', //BAC SATELITE SOFTWARE   (CHROME: AJUSTAR A AREA DE IMPRESION)
                    '7' => 'Tipo BAC F3', //BAC RAMATER             (CHROME: PREDETERMINADO)
                    '8' => 'Tipo BAC F4', //BAC MAYA COUNTRY
                    '9'  => 'Tipo BAC F5', //BAC CENTRO CULTURAL SALVADOREÑO Con S.S.
                    '10' => 'Tipo SCOTIABANK F1', //SCOTIABANK TROQUELES
                    '11' => 'Tipo SCOTIABANK F2', //SCOTIABANK ESPUMAR
                    '12' => 'Tipo DAVIVIENDA F1', //Davivienda INTERVISION
                    '13' => 'Tipo DAVIVIENDA F2', //DAVIVIENDA ESPUMAR
                    '14' => 'Tipo DAVIVIENDA F3', //DAVIVIENDA MAYA COUNTRY
                    '15' => 'Tipo BANCO AGRICOLA F1', //Banco Agricola INTERVISION
                    '16' => 'Tipo BANCO AGRICOLA F2', //BANCO AGRICOLA RAMATER
                    '17' => 'Tipo BANCO AGRICOLA F3', //BANCO AGRICOLA MAYA COUNTRY
                    '18' => 'Tipo CUSCATLAN F1', //BANCO CUSCATLAN INTERVISION
                    '19' => 'Tipo CUSCATLAN F2', //CUSCATLAN MAYA COUNTRY
                    '20' => 'Tipo CITI F1',      //BANCO CITI ESPUMAR
                    '21' => 'Tipo PROMERICA F1', //PROMERICA ESPUMAR
                    '22' => 'Tipo PROMERICA F2',
                    '23' => 'Tipo BAC F6', //BAC CENTRO CULTURAL SALVADOREÑO Sin S.S.
                    '24' => 'Tipo BANCO AGRICOLA KEYSI', //PROMERICA MAYA COUNTRY
                    '25' => 'BANCO CUSCATLAN', //ASI
                    '26' => 'BANCO AZUL F1' //RAMATER
                ))
                ->unset_delete();
            $crud->set_rules('chq_numero', 'Número', 'required|callback_validar_chequera');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('chq_estado', 'hidden', 1);
            } else {
                $crud->field_type('chq_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            //required
            $crud->required_fields('chq_numero', 'chq_numero_inicio', 'chq_cantidad');
            $crud->callback_before_insert(function($post_array) {
                $existe = $this->utm_model->verifica_chequera($post_array['chq_id_cub'], $post_array['chq_numero'], $post_array['chq_tipo']);
                if ($existe > 0) {
                    return false;
                } else {
                    return true;
                }
            });
            $crud->callback_before_update(function ($post_array, $primary_key) {
                $existe = $this->utm_model->verifica_chequera($post_array['chq_id_cub'], $post_array['chq_numero'], $post_array['chq_tipo'], $primary_key);
                if ($existe > 0) {
                    return FALSE;
                } else {
                    return TRUE;
                }
            });
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver Cheques', '', '', 'icomoon-icon-copy-2 chq_ver', function ($primary_key, $row) {
                    return base_url() . 'utm/cuentas/gestion_cheques?chq_id=' . $primary_key;
                });
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }
            if ($cub_id = $this->input->get('cub_id')) {
                $crud->where('chq_id_cub', $cub_id);
            }

            $crud->set_primary_key('cub_id', 'vw_cuentas_bancarias');
            $crud->set_relation('chq_id_cub', 'vw_cuentas_bancarias', 'cuenta');
            $crud->set_language('spanish');
            $output = $crud->render();
            $data["titulo_personal"] = "Gestión de chequera";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * Cuentas::_format_money()
     * @author Alexis Beltran
     *
     * @param mixed $valor
     * @return
     */
    function _format_money($valor)
    {
        return '<span style="display: inline-block">$</span><div style="display: inline-block;float: right;">' . number_format($valor, 2) . '</div>';
    }

    function _format_nombre($value, $row)
    {
    }

    /**
     * Cuentas::_format_date()
     * @author Alexis Beltran
     *
     * @param mixed $valor
     * @return
     */
    function _format_date($valor)
    {
        $t = explode('-', $valor);
        return '<div style="display: inline-block;float: right;">' . date('d/m/Y', mktime(0, 0, 0, $t[1], $t[2], $t[0])) . '</div>';
    }

    function che_a_firmar()
    {
        $this->load->library('Procesos');
        $per = new Procesos();
        $per->set_variables(1, 3, 102);
        //$per->validar();
        //print_r($per);
        if ($per->set_next_estado($this->input->post('che_id'), 2)) {
            $data['message'] = true;
            echo json_encode($data);
        }
    }

    function che_firmar()
    {
        $paso = 3;
        $this->load->library('Procesos');
        $per = new Procesos();
        $per->set_variables(1, 3, 102);
        $per->validar(true);

        $data = array(
            'titulo' => 'Cheque Firmar',
            'aceptar' => 'Firmar',
            'rechazar' => 'Rechazar',
            'url' => 'utm/cuentas/che_firmar'
        );

        $per->print_validar($paso, $data);
    }

    function che_historico()
    {
        $this->load->library('Procesos');
        $per = new Procesos();
        //$per->set_variables(1);
        $id = $this->input->post('che_id');
        $data = array(
            'tarea' => 'Cheque',
            'registro_id' => $id,
            'historico' => $per->get_historico(1, $id)
        );
        $this->load->view('utm/cuentas/che_historico', $data);
    }

    function che_anular()
    {
        $registro = $this->input->post('registro');
        $campo = $this->gsatelite->get_campo('che_cheque', 'che_numero', array('che_id' => $registro));
        $numero_cheque = (is_object($campo)) ? $campo->che_numero : $campo;

        $paso = 12;
        $this->load->library('Procesos');
        $per = new Procesos();
        $per->set_variables(1, 1, 266);
        $per->validar();

        $data = array('titulo' => 'Anular cheque número: ' . $numero_cheque, 'aceptar' => 'Anular', 'rechazar' => '', 'url' => 'utm/cuentas/che_anular');

        $res = $per->print_validar($paso, $data, true);

        if ($res == 'Ok') {

            $tra_id = $this->gsatelite->get_campo('che_cheque', 'che_id_tra', array('che_id' => $registro));
            echo var_dump($tra_id);
            die();
            //actualizar la transacion
            $this->db->update('tra_transaccion', array('tra_conciliado' => -1), array('tra_id' => $tra_id));
            // var_dump($this->db->last_query());
            die();
            die('reload');
        }
        die($res);
    }

    function che_sig_numero()
    {
        //echo $this->input->post('chq_id');
        $chq_id = $this->input->post('chq_id');
        if ($chq_id && is_numeric($chq_id)) {
            $row = $this->db->query("SELECT get_cheque_numero($chq_id) as numero;")->row();
            if ($row->numero) {
                $info_prefijo_sufijo = $this->db->query('SELECT * FROM chq_chequera AS chq
                    INNER JOIN `cub_cuenta_bancaria` cub ON cub.`cub_id` = chq.`chq_id_cub`
                    INNER JOIN ban_banco ban ON ban.`ban_id` = cub.`cub_id_ban`
                    WHERE chq.`chq_id`=' . $chq_id)->row();
                die($info_prefijo_sufijo->ban_prefijo . $row->numero . $info_prefijo_sufijo->ban_sufijo);
            }
        }
        die('No hay Cheques Disponibles.');
    }

    /**
     * @author Edith Herrera
     * Descripcion: vista Agregar cheque
     * @return
     * @modified: Mario Marquez
     * $chp_id = Id del cheque pendiente, donde se precargara la información
     */
    function agregar_cheque($chp_id = null, $ver = null)
    {
        satelite_validar();
        $redi               = ($this->input->post('redireccion')) ? $this->input->post('redireccion') : 'cheque';
        $data['redireccion'] = $redi;
        $cheques_array      = null;
        $list_idche         = explode('$', $this->input->post('list_id_cheques'));

        if ($chp_id > 0) {
            $list_idche[0] = $chp_id;

            $this->db->join("dpv_documento_proveedor", "dpv_id = chp_id_dpv");
            $cheques_array = $this->gsatelite->get_tabla("chp_cheque_pendiente", array("chp_id" => $chp_id));
        }

        $data['prv'] = $this->gsatelite->get_tabla('prv_proveedor');
        $data['banco'] = $this->utm_model->get_banco();
        $data['retencion'] = $this->gsatelite->get_tabla('ret_retencion');
        $data['cheque_pendiente'] = null;


        foreach ($list_idche as $key => $chp_id) {
            if ($chp_id != null) {
                $cheque_pendiente = $this->utm_model->get_cheques_pendientes(array('chp_id' => $chp_id));
                $data['cheque_pendiente'][$key] = $cheque_pendiente[0];

                if ($cheque_pendiente[0]['dpv_id'] != null) {

                    $documento = $cheque_pendiente[0]['dpv_id'];

                    $monto_cheque_pendiente = $cheque_pendiente[0]['chp_monto'];
                    $respuesta = $this->validar_documento_proveedor($documento, $monto_cheque_pendiente);

                    if (!$respuesta) {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Cheque Pendiente", 'texto_alerta' => "El documento ya contiene abonos realizados, y el cheque supera al monto pendiente.");
                        $this->session->set_flashdata($alerta);
                        redirect('utm/cuentas/cheques_pendientes');
                    }

                    $data['cuenta_contable'] = $this->gsatelite->get_cuenta_contable('dfp_detalle_finanza_proveedor', 'GASTO', array('dfp_id_prv' => $cheque_pendiente[0]['dpv_id_prv']));
                }
            }
        } //fin foreach

        $select                 = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', null, null, '', 'cnt_id', true);
        $data["cuentas"]        = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

        $data["titulo_personal"] = "Gestión de cheques";
        $data['ver']            = $ver;
        $data['pendiente']      = $chp_id;

        $this->db->join("epr_estado_proyecto", "epr_id = pcl_id_epr");
        $proyectos              = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array('epr_cierre !=' => 1), null, '', 'pcl_id', true);
        $proyectos              = str_replace('<option value="0">Seleccione</option>', '', $proyectos);
        $data['proyectos']      = str_replace('<option value="0">Sin Registros</option>', '', $proyectos);
        $data['list_id_cheques'] = $this->input->post('list_id_cheques');

        //************
        $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
        $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
        $cuenta = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array("cnt_estado" => 1, "cnt_id NOT IN ( $padres )" => null), null, null, null, true);
        $data['cuenta'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $cuenta);

        $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('CHEQUE'));
        $id_tipo_partida = ($id_tipo_partida > 0) ? $id_tipo_partida : 0;

        $select_drop = $this->gsatelite->get_dropdown('tpd_tipo_partida', '{tpd_nombre}', '', array('tpd_estado' => 1), $id_tipo_partida, null, null, true);
        $data['tipo'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select_drop);

        $this->db->join("lcc_liquidacion_caja_chica", "lcc_id_cch = cch_id");
        $select_cch = $this->gsatelite->get_dropdown('cch_caja_chica', '{cch_nombre}', '', array('cch_estado' => 1, 'lcc_corte' => 0, 'lcc_estado' => 1), null, null, null, true);
        $data['caja_ch'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select_cch);

        $ano_actual             = date('Y'); // Quemadp
        $mes_actual             = date('m'); // Quemado
        $data['periodo']        = $this->gsatelite->get_tabla('prc_periodo_contable', array('prc_estado' => 1)); //'prc_ano' => $ano_actual, 'prc_mes' => $mes_actual, // Se omitieron parametros para que solo muestre el activo
        $slc_presupuesto        = '<option value=""></option>';
        $slc_general            = '<option value=""></option>';
        $slc_especifica         = '<option value=""></option>';
        if (count($cheques_array)  > 0) {
            $slc_presupuesto        = ($cheques_array[0]['dpv_id_psp'] != "") ? $this->get_presupuestoxproyecto($cheques_array[0]['dpv_id_pcl'], $cheques_array[0]['dpv_id_psp']) : '<option value=""></option>';
            $data['presupuesto']    = $slc_presupuesto;
            $slc_general            = ($cheques_array[0]['dpv_id_acg'] != "") ? $this->get_actividades_generalesxpresupusto($cheques_array[0]['dpv_id_psp'], $cheques_array[0]['dpv_id_acg']) : '<option value=""></option>';
            $data['general']        = $slc_general;
            $slc_especifica         = ($cheques_array[0]['dpv_id_ace'] != "") ? $this->get_actividades_especificas_x_actividad_general($cheques_array[0]['dpv_id_acg'], $cheques_array[0]['dpv_id_psp'], $cheques_array[0]['dpv_id_ace']) : '<option value=""></option>';
            $data['especifica']     = $slc_especifica;
        }
        $data['centro_costo'] =  str_replace('<option value="0">Seleccione</option>', '', $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));

        if ($ver != null) {
            $this->gsatelite->cargar_vista_masterpage('utm/cuentas/agregar_cheque', $data);
        } else {

            $this->_cargarvista($data);
        }
    }

    /**
     * @author Edith Herrera
     * Descripcion: funcion que me permite obtener el numero de cheque segun la chequera seleccionada.
     * @return
     */
    public function validar_transaccion()
    {
        $tran = $this->gsatelite->get_parametro('SYS_TIPO_TRANSACT');
        $tipo_tran = $this->gsatelite->get_tabla('ttb_tipo_transact_bancaria', array('ttb_estado' => 1));
        foreach ($tipo_tran as $key) {
            if ($tran == $key['ttb_id']) {
                echo json_encode(array('resp' => 0));
                die();
            } else {
            }
        }
        echo json_encode(array('resp' => 1));
    }

    function obtener_numero()
    {
        satelite_validar();
        $cod = "";
        $uno = 1;
        $cod = $this->input->post('chq_id');
        $chequera = $this->gsatelite->get_registro('chq_chequera', array('chq_id' => $cod));

        //Se obtiene el numero mayor de cheque segun el id enviado
        $numero = $this->utm_model->get_numero_che($cod);
        $cheque = $numero->numero;

        if ($cheque != '') {
            $cheque++;
            $num_che = $cheque;
            // echo "aumenta";
        } else {
            $num_che = $chequera->chq_numero_inicio;
            // echo "inicial";
        }

        //Se realiza la concatenacion de prefijo y sufijo del banco con el numero correlativo.
        $info_prefijo_sufijo = $this->utm_model->get_prefijo($cod);
        // prefijo_banco=$info_prefijo_sufijo->ban_prefijo.
        //sufijo_banco= .$info_prefijo_sufijo->ban_sufijo
        $final = $num_che;


        $disponible = $this->utm_model->get_disponible($cod);
        $campo = $this->gsatelite->get_campo('chq_chequera', 'chq_id_cub', array('chq_id' => $cod));
        //$saldo=$this->gsatelite->get_campo('cub_cuenta_bancaria','cub_saldo', array('cub_id'=>$campo));
        $saldo = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $chequera->chq_id_cub))->row_array();
        //die(print_r($saldo));
        echo $final . "#" . $disponible[0]["disponibles"] . "#" . $saldo['saldo'] . "#" . $campo . "#" . $saldo['saldo_minimo'];
    }

    public function obtener_numero_automatico($cod)
    {
        satelite_validar();
        $uno = 1;
        $chequera = $this->gsatelite->get_registro('chq_chequera', array('chq_id' => $cod));

        //Se obtiene el numero mayor de cheque segun el id enviado
        $numero = $this->utm_model->get_numero_che($cod);
        $cheque = $numero->numero;

        if ($cheque != '') {
            $cheque++;
            $num_che = $cheque;
            // echo "aumenta";
        } else {
            $num_che = $chequera->chq_numero_inicio;
            // echo "inicial";
        }

        //Se realiza la concatenacion de prefijo y sufijo del banco con el numero correlativo.
        $info_prefijo_sufijo = $this->utm_model->get_prefijo($cod);
        // prefijo_banco=$info_prefijo_sufijo->ban_prefijo.
        //sufijo_banco= .$info_prefijo_sufijo->ban_sufijo
        $final = $num_che;


        $disponible = $this->utm_model->get_disponible($cod);
        $campo = $this->gsatelite->get_campo('chq_chequera', 'chq_id_cub', array('chq_id' => $cod));
        //$saldo=$this->gsatelite->get_campo('cub_cuenta_bancaria','cub_saldo', array('cub_id'=>$campo));
        $saldo = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $chequera->chq_id_cub))->row_array();
        //die(print_r($saldo));
        $numeros = $final . "#" . $disponible[0]["disponibles"] . "#" . $saldo['saldo'] . "#" . $campo . "#" . $saldo['saldo_minimo'];
        return $numeros;
    }

    /**
     * @author Edith Herrera
     * Descripcion: Función que me permite obtener las cuentas dependiendo del banco seleccionado.
     * @return
     */
    function obtener_cuenta()
    {
        satelite_validar(true);
        // DATOS POST
        $id_ban          = (trim($this->input->post('ban_id')) != "") ? $this->input->post('ban_id') : 0;
        $cuenta_bancaria = (trim($this->input->post('cuenta')) != "") ? $this->input->post('cuenta') : 0;
        // Obtener cuentas por Banco
        $where = array("ban_id" => $id_ban, 'chq_estado' => 1);
        $cuenta = $this->utm_model->get_cuenta($where);
        $html   = '';
        $html  .= "<option value=''>Seleccione chequera</option>";
        foreach ($cuenta as $key => $value) {
            if ($value["disponibles"] > 0) {
                $html .= "<option value='" . $value['chq_id'] . "'>" . $value['chq_numero'] . "-" . $value['cub_numero'] . "</option>";
            }
        }
        // Obtener cuentas bancarias
        $cuentas = $this->gsatelite->get_tabla('cub_cuenta_bancaria', array('cub_id_ban' => $id_ban, 'cub_estado' => 1));
        $opciones_cuenta = "<option value=''></option>";
        $new_chq_html  = "<option value=''></option>";
        $saldo_new = null;
        $numeros = null;

        //verifica si vienen datos de las cuentas
        if (count($cuentas) > 0) {
            //condicion si vinen mas de una cuenta bancaria
            if (count($cuentas) > 1) {
                foreach ($cuentas as $cub) {
                    $opciones_cuenta .= "<option value='" . $cub['cub_id'] . "' data-sobregiro='" . $cub['cub_permite_sobregiro'] . "' data-monto_sg='" . $cub['cub_monto_sobregiro'] . "'>" . $cub['cub_numero'] . " - " . $cub['cub_nombre'] . "</option>";
                }
                //ya que vienen varias cuentas no se imprimira nada en la chequera
                $new_chq_html  = "<option value=''></option>";
                //  var_dump($saldo_new);die();
            } else { //ya que solo viene una cuenta bancaria se seleccionara el campo con el valor de la cuenta 
                foreach ($cuentas as $cub) {
                    $opciones_cuenta .= "<option value='" . $cub['cub_id'] . "' selected>" . $cub['cub_numero'] . " - " . $cub['cub_nombre'] . "</option>";

                    //obteniendo datos de la chequera mediante el id de la cuenta
                    $chequera_new = $this->gsatelite->get_registro('chq_chequera', array('chq_id' => $cub['cub_id']));
                    //obteniendo los datos del saldo actual de la cuenta
                    $saldo_new = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $chequera_new->chq_id_cub))->row_array();
                    ////////////////////////////////////// funcion para obtener el saldo de la cuenta ///////////////////////////////////////////////
                    $resultados = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $cub['cub_id']));
                    $query = $this->db->select('saldo, tra_monto, cub_saldo_inicial, SUM(tra_monto) as suma')
                        ->from('vw_cuentas_bancarias')
                        ->join('tra_transaccion', 'vw_cuentas_bancarias.cub_id=tra_transaccion.tra_id_cub')
                        ->join('cub_cuenta_bancaria', 'tra_id_cub=cub_cuenta_bancaria.cub_id')
                        ->where('tra_id_cub', $cub['cub_id'])
                        ->get();
                    $transact = $query->row_array();
                    $suma = $transact['suma'];
                    $saldo_ini = $transact['cub_saldo_inicial'];
                    if ($resultados->num_rows() > 0) {
                        // $saldo_new = $resultados->row()->saldo_new;
                        // $saldo_new = $resultados->row()->saldo_new;
                        // $saldo_minimo = $resultados->row()->saldo_minimo;
                        // if ($saldo_minimo > $saldo_new) {
                        //     //$valor = $saldo_minimo; //NO ES FUNCIONAL
                        //     $valor = $saldo_ini + $suma;
                        // } else {
                        //     $valor = $saldo_ini + $suma;
                        // }
                        $valor = $saldo_ini + $suma;
                    } else {
                        $valor = 0;
                    }
                    $valorx = $this->_format_money($valor);


                    if ($valorx != '') {
                        $saldo_new = $valor;
                    } else {
                        $saldo_new = 0.00;
                    }

                    ////////////////////////////fin de la funcion para obtener el saldo de la cuenta /////////////////////////////////////////

                    //obteniendo los datos de chequera de la cuenta
                    $where2 = array('cub_id' => $cub['cub_id'], 'chq_estado' => 1);
                    $chequeras = $this->utm_model->get_cuenta($where2);
                    $new_chq_html  = "<option value=''></option>";
                    //verificando que existan chequeras en la cuenta
                    // if (count($chequeras)>0) {
                    //si vienen varias chequeras solo pondra los valores en lista
                    // var_dump($this->db->last_query());die();
                    if (count($chequeras) > 1) {
                        foreach ($chequeras as $key => $value) {
                            if ($value["disponibles"] > 0) {
                                $new_chq_html .= "<option value='" . $value['chq_id'] . "'>" . $value['chq_numero'] . "-" . $value['cub_numero'] . "</option>";
                            }
                        }
                    } else { // si solo viene una chequera esta estara seleccionada por defecto
                        foreach ($chequeras as $key => $value) {
                            if ($value["disponibles"] > 0) {
                                $new_chq_html .= "<option value='" . $value['chq_id'] . "' selected>" . $value['chq_numero'] . "-" . $value['cub_numero'] . "</option>";
                            }

                            $numeros = $this->obtener_numero_automatico($value['chq_id']);
                            // var_dump($numeros);die();
                        }
                    }
                    // }
                }
            }
        }
        // Obterner las chequeras de una cuenta
        // $this->db->join('cub_cuenta_bancaria', 'cub_id=chq_id_cub');
        // $chequeras = $this->gsatelite->get_tabla('chq_chequera', array('cub_id'=>$cuenta_bancaria, 'chq_estado'=>1));
        $where2 = array('cub_id' => $cuenta_bancaria, 'chq_estado' => 1);
        $chequeras = $this->utm_model->get_cuenta($where2);
        // var_dump($this->db->last_query());die();
        $chq_html  = "<option value=''></option>";

        //a la hora de hacer un cambio en el select de cuenta bancaria verifica que si existen chequeras en la cuenta
        if (count($chequeras) > 0) {
            // var_dump($chequeras);die();
            //si vienen varias chequeras solo pondra los valores en lista
            if (count($chequeras) > 1) {
                foreach ($chequeras as $key => $value) {
                    if ($value["disponibles"] > 0) {
                        $chq_html .= "<option value='" . $value['chq_id'] . "'>" . $value['chq_numero'] . "-" . $value['cub_numero'] . "</option>";
                    }
                }
            } else { // si solo viene una chequera esta estara seleccionada por defecto
                foreach ($chequeras as $key => $value) {
                    if ($value["disponibles"] > 0) {
                        $chq_html .= "<option value='" . $value['chq_id'] . "' selected>" . $value['chq_numero'] . "-" . $value['cub_numero'] . "</option>";
                    }

                    $numeros = $this->obtener_numero_automatico($value['chq_id']);
                }
            }
        }

        //funcion anterior que mostraba error comentada
        // $detalle_cuenta = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $cuenta_bancaria))->row_array();
        //if(count($detalle_cuenta)>0){ $saldo = $detalle_cuenta['saldo']; }else{ $saldo = ''; }

        //Nueva funcion
        $resultados = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $cuenta_bancaria));
        $query = $this->db->select('saldo, tra_monto, cub_saldo_inicial, SUM(tra_monto) as suma')
            ->from('vw_cuentas_bancarias')
            ->join('tra_transaccion', 'vw_cuentas_bancarias.cub_id=tra_transaccion.tra_id_cub')
            ->join('cub_cuenta_bancaria', 'tra_id_cub=cub_cuenta_bancaria.cub_id')
            ->where('tra_id_cub', $cuenta_bancaria)
            ->get();
        $transact = $query->row_array();
        $suma = $transact['suma'];
        $saldo_ini = $transact['cub_saldo_inicial'];
        if ($resultados->num_rows() > 0) {
            $saldo = $resultados->row()->saldo;
            $saldo = $resultados->row()->saldo;
            $saldo_minimo = $resultados->row()->saldo_minimo;
            if ($saldo_minimo > $saldo) {
                //$valor = $saldo_minimo; //NO ES FUNCIONAL
                $valor = $saldo_ini + $suma;
            } else {
                $valor = $saldo_ini + $suma;
            }
        } else {
            $valor = 0;
        }
        $valorx = $this->_format_money($valor);


        if ($valorx != '') {
            $saldo = $valor;
        } else {
            $saldo = 0.00;
        }

        echo json_encode(array('datos' => $html, 'cuentas' => $opciones_cuenta, 'chequeras' => $chq_html, 'saldo' => '$' . $saldo, 'new_chq_html' => $new_chq_html, 'saldo_new' => $saldo_new, 'numeros' => $numeros, 'many_ctas' => count($cuentas)));
    }

    /**
     * @author Edith Herrera
     * Descripcion: insertar datos del cheque.
     * @return
     */
    function guardar_cheque()
    {
        satelite_validar();
        $otra_partida = ($this->input->post('detalle_c')) ? 1 : 0;
        $this->gsatelite->get_tabla('che_cheque');
        $lis_che = explode('$', $this->input->post('list_id_cheques')); //Estos son los id de los cheques
        if ($this->input->post()) {
            $post_array         = $this->input->post();
            $idprv              = $this->input->post('slcProveedor');
            $idprv              = ($idprv == "") ? null : $idprv;
            $caja_chica_id      = ($this->input->post('slcCajaChica') != "") ? $this->input->post('slcCajaChica') : NULL;
            $idchq              = $this->input->post('slcChequera');
            $num                = $this->input->post('txtNumero');
            $serv               = $this->input->post('txt_valor_monto');
            $ord                = $this->input->post('txtOrden');
            $fecha              = $this->input->post('txtFecha');
            $fche               = date('Y-m-d', strtotime($fecha));
            $con                = $this->input->post('txtConcepto');
            $suj                = $this->input->post('txt_total_monto_sujeto');
            $monto              = $this->input->post('txt_total_monto');
            $aplicar_cheque     = $this->input->post('hdnAplicarTrans');
            $aplica_caja_chica  = $this->input->post('hdnCajaChica');
            $cuenta_cont        = $this->input->post('txtTablaCuenta');
            $permite_generar    = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_BANCO');
            $cuenta_def         = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
            $flag  = 1;
            $flag1 = 0;
            $flag2 = 0;
            if ($cuenta_def != '') {
                $existe_par = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $cuenta_def));
                if (count($existe_par) > 0) {
                    $flag = 1;
                } else {
                    $flag = 0;
                }
            } else {
                if (array_sum($cuenta_cont) <= 0) {
                    $flag1 = 1;
                } else {
                    $flag1 = 0;
                }
                if (count($cuenta_cont) < count($ord)) {
                    $flag2 = 1;
                } else {
                    $flag2 = 0;
                }
            }
            if ($permite_generar == 1 &&  ($flag == 0 || $flag1 == 1 || $flag2 == 1)) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Nuevo cheque", 'texto_alerta' => "Operación no efectuada, favor de configurar los parámetros correspondientes.");
                $this->session->set_flashdata($alerta);
                redirect('utm/cuentas/gestion_cheques');
            }
            $No = $this->gsatelite->get_campo('che_cheque', 'che_id', array('che_id_chq' => $idchq, 'che_numero' => $num));
            if ($No > 0) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Nuevo cheque", 'texto_alerta' => "Este cheque ya existe");
            } else {
                $data = array(
                    //'che_id_chp' => ($chp_id != null) ? $chp_id : null,
                    'che_id_chq'            => $idchq,
                    'che_id_prv'            => $idprv,
                    'che_id_cch'            => $caja_chica_id,
                    //'che_id_tra'            => $this->gsatelite->get_parametro('SYS_TIPO_TRANSACT'),
                    'che_numero'            => trim($num),
                    'che_monto'             => convertirFloat($serv),
                    'che_orden'             => $ord,
                    'che_concepto'          => $con,
                    'che_monto_suj'         => convertirFloat($suj),
                    'che_renta_monto'       => convertirFloat($monto),
                    'che_fecha'             => $fche,
                    'che_aplica_caja_chica' => $aplica_caja_chica,
                    'che_usu_mod'           => $this->tank_auth->get_user_id(),
                    'che_fecha_mod'         => date("Y-m-d H:i:s"),
                    'che_usu_crea'          => $this->tank_auth->get_user_id(),
                    'che_fecha_crea'        => date("Y-m-d H:i:s"),
                    'che_estado'            => 1
                );
                $registro = $this->gsatelite->ingresar('che_cheque', $data);
                // ID el cheque ingresado
                $id = $registro;
                // Variable que se compartira en las vistas para imprimir el cheque
                $this->session->set_flashdata('id_cheque', $id);

                //Se actualiza el cheque pendiente, como generado, dependiendo si es creacion y actualizacion
                $cheque_pend = 0;
                if ($this->input->post('list_id_cheques') == 0) {
                    $chp_id = $this->input->post('hdnChequePendiente');
                    $cheque_pend = $chp_id;
                    if ($id > 0 && $chp_id != 0) {
                        $cheque_pendiente = array(
                            'chp_id_che' => $id,
                            'chp_generado' => 1,
                            'chp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'chp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('chp_cheque_pendiente', $cheque_pendiente, array('chp_id' => $chp_id));
                        $agenda = $this->gsatelite->get_campo('chp_cheque_pendiente', 'chp_id_agp', array('chp_id' => $chp_id));
                        $this->gsatelite->actualizar_array('agp_agenda_pago', array('agp_estado' => 0), array('agp_id' => $agenda));
                    }
                } else {
                    foreach ($lis_che as $key => $chp_id) {
                        if ($id > 0 && $chp_id != 0) {
                            $cheque_pendiente = array(
                                'chp_id_che' => $id,
                                'chp_generado' => 1,
                                'chp_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'chp_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->actualizar_array('chp_cheque_pendiente', $cheque_pendiente, array('chp_id' => $chp_id));
                        }
                    }
                }
                /* ******************************************************************************* */

                $concepto = $this->input->post('txtTablaDescripcion');
                $renta = $this->input->post('txtTablaMontoSujeto');
                $valr = $this->input->post('txtTablaMonto');
                $id_factura = $this->input->post('txtTablaFactura');
                $calculado = $this->input->post('txtTablaRetencion');
                $sub_total = $this->input->post('txtTablaTotal');
                // $cuenta_cont = $this->input->post('txtTablaCuenta');
                //variables para la tabla rdc_retencion_detalle_cheque
                $id_retenciones = $this->input->post('txtTablaRetenciones_id');
                $porcentajes_retencion = $this->input->post('txtTablaRetenciones_procentaje');
                $proyecto                    =  $this->input->post('txt_tabla_proyecto');
                $presupuesto                 = $this->input->post('txt_presupuesto');
                $actividad_general           = $this->input->post('txt_actividad_general');
                $actividad_especifica        = $this->input->post('txt_actividad_especifica');
                $actividad_espeficifica_text = $this->input->post('txt_actividad_espeficifica_text');
                $numero_documento            = $this->input->post('txt_numero_documento');

                //Insetar en la tabla de detalle del cheque
                $tot_ele = count($lis_che);
                foreach ($valr as $key => $value) {
                    $array_det = array(
                        'dch_concepto'              => $concepto[$key],
                        'dch_valor'                 => convertirFloat($value),
                        'dch_retencion'             => convertirFloat($renta[$key]),
                        'dch_retencion_calculada'   => convertirFloat($calculado[$key]),
                        'dch_subtotal'              => convertirFloat($sub_total[$key]),
                        'dch_id_dpv'                => ($id_factura[$key] == null) ? null : $id_factura[$key],
                        // 'dch_id_cnt' => (trim($cuenta_cont[$key]) != "") ? trim($cuenta_cont[$key]) : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'),
                        'dch_id_chp'                => ($lis_che[$key] != 0) ? $lis_che[$key] : null,
                        'dch_estado'                => 1,
                        'dch_usu_mod'               => $this->tank_auth->get_user_id(),
                        'dch_fecha_mod'             => date('Y-m-d H:i:s'),
                        'dch_id_che'                => $id,
                        'dch_usu_crea'              => $this->tank_auth->get_user_id(),
                        'dch_fecha_crea'            => date('Y-m-d H:i:s'),
                        'dch_id_pcl'                => ($proyecto[$key] > 0) ? $proyecto[$key] : NULL,
                        'dch_id_psp'                => ($presupuesto[$key] > 0) ? $presupuesto[$key] : NULL,
                        'dch_id_acg'                => ($actividad_general[$key] > 0) ? $actividad_general[$key] : NULL,
                        'dch_id_ace'                => ($actividad_especifica[$key] > 0) ? $actividad_especifica[$key] : NULL,
                    );

                    $retencion_detalle = $this->gsatelite->ingresar('dch_detalle_cheque', $array_det);

                    //se verificara si se agregaran gastos a presupuestos.  
                    if ($proyecto[$key] != "" && $actividad_especifica[$key] != "" && $actividad_especifica[$key] != "null") {
                        // se verificara si existen registros en gastos conel dpv elegido.
                        $gasto_existente = null;
                        if ($id_factura[$key] != "") {
                            $gasto_existente = $this->gstalite->get_tabla("dgp_detalle_gasto_prespuesto", array("dgp_id_dpv" => $id_factura[$key]));
                        }
                        if (count($gasto_existente) == 0) {
                            $condiciones = array(
                                "dps_id_ace"    => $actividad_especifica[$key],
                                "dps_id_acg"    => $actividad_general[$key],
                                "dps_id_psp"    => $presupuesto[$key]
                            );
                            $detalle_presupuesto = $this->gsatelite->get_tabla("dps_detalle_presupuesto", $condiciones);
                            if ($detalle_presupuesto != null) {
                                $dgp_detalle_gasto_prespuesto = array(
                                    'dgp_id_dps'            => $detalle_presupuesto[0]['dps_id'],
                                    'dgp_id_tgp'            => 5,
                                    'dgp_id_dpv'            => ($id_factura[$key] != "") ? $id_factura[$key] : null,
                                    'dgp_id_dch'            => $retencion_detalle,
                                    'dgp_fecha'             => $fche,
                                    'dgp_descripcion'       => $actividad_espeficifica_text[$key],
                                    'dgp_referencia'        => $numero_documento[$key],
                                    'dgp_cantidad'          => 1,
                                    'dgp_monto'             => convertirFloat($value),
                                    'dgp_total_retencion'   => convertirFloat($renta[$key]),
                                    'dgp_total_impuesto'    => null,
                                    'dgp_sub_monto'         => convertirFloat($sub_total[$key]),
                                    'dgp_origen'            => 2,
                                    'dgp_referencia_origen' => null,
                                    'dgp_estado'            => ($aplicar_cheque == 1) ? 1 : 0,
                                    'dgp_usu_creacion'      => $this->tank_auth->get_user_id(),
                                    'dgp_fecha_creacion'    => date('Y-m-d H:i:s'),
                                    'dgp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                    'dgp_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                                $dgp_id = $this->gsatelite->ingresar('dgp_detalle_gasto_prespuesto', $dgp_detalle_gasto_prespuesto);
                            }
                        }
                    }
                    //Se actualizara el monto pendiente del documento
                    if ($aplicar_cheque == 1) {
                        if ($id_factura[$key] != "") {
                            $documento_factura = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id' => $id_factura[$key]));
                            $nuevo_monto_pendiente = $documento_factura[0]['dpv_monto_pendiente'] - convertirFloat($valr[$key]);
                            $nuevo_abono = $documento_factura[0]['dpv_monto_abono'] + convertirFloat($valr[$key]);
                            $array_dpv = array(
                                'dpv_monto_pendiente' => $nuevo_monto_pendiente,
                                'dpv_pagado' => ($nuevo_monto_pendiente <= 0) ? 1 : 0,
                                'dpv_monto_abono' => $nuevo_abono
                            );
                            $this->gsatelite->actualizar_array('dpv_documento_proveedor', $array_dpv, array('dpv_id' => $id_factura[$key]));
                        }

                        //Aplicar cub_cuenta_bancaria
                        $this->db->join('cub_cuenta_bancaria', 'cub_id = chq_id_cub');
                        $cuenta_bancaria = $this->gsatelite->get_tabla('chq_chequera', array('chq_id' => $idchq));

                        $newSaldo = $cuenta_bancaria[0]['cub_saldo'] - $sub_total[$key];

                        $array_banco = array(
                            'cub_usu_mod' => $this->tank_auth->get_user_id(),
                            'cub_fecha_mod' => date("Y-m-d H:i:s"),
                            'cub_saldo' => $newSaldo
                        );
                        $result = $this->gsatelite->actualizar_array('cub_cuenta_bancaria', $array_banco, array('cub_id' => $cuenta_bancaria[0]['cub_id']));
                    }

                    //insertara las retenciones de cada detalle si es factura
                    if ($id_retenciones[$key] != "") {
                        $id_retenciones_array = explode(",", $id_retenciones[$key]);
                        $porcentajes_retencion_array = explode(",", $porcentajes_retencion[$key]);
                        $total_porcentaje = array_sum($porcentajes_retencion_array);

                        foreach ($id_retenciones_array as $key2 => $value2) {

                            $porcentaje_retencion = convertirFloat($porcentajes_retencion_array[$key2]);
                            $monto_retencion = (convertirFloat($calculado[$key]) * ($porcentaje_retencion / 100)) / ($total_porcentaje / 100);
                            $array_ret = array(
                                'rdc_id_ret' => $value2,
                                'rdc_id_dch' => $retencion_detalle,
                                'rdc_porcentaje' => $porcentajes_retencion_array[$key2],
                                'rdc_monto' => $monto_retencion,
                                'rdc_estado' => 1,
                                'rdc_usu_creacion' => $this->tank_auth->get_user_id(),
                                'rdc_fecha_creacion' => date('Y-m-d H:i:s'),
                                'rdc_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'rdc_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('rdc_retencion_detalle_cheque', $array_ret);
                        }
                    }
                }
                /* ************************************************************************ */

                /* ================================= */
                /* ==  GENERAR PARTIDA CONTABLE   == */
                /* ================================= */
                $permite_generar = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_BANCO');

                if ($permite_generar == 1 && $id > 0 && $idprv > 0) {

                    $where['che_id'] = $id;
                    $groupby         = 'che_id, cnt_id';
                    $datos = $this->generar_partida_contable_cheque($where, $groupby, null, null, false, false);
                    $this->gsatelite->actualizar_array('che_cheque', array('che_id_pct' => $datos['id_pct']), array('che_id' => $id));

                    // SE COMENTA FUNCIONALIDAD DE CONTABILIDAD POR CENTRO DE COSTO PARA ESTABILIZAR LA PARTIDA NORMAL
                    //$pct_id = $this->generar_partida_automatica_cheque($id,2);                    
                    //Actualizar el id de la partida contable en el cheque
                    //$this->gsatelite->actualizar_array('che_cheque',array('che_id_pct' => $pct_id),array('che_id' => $id));
                } else if ($permite_generar == 1 && $cheque_pend > 0 && $otra_partida <= 0) { //preguntar si es cheque pendiente

                    $registro_cheque_pen = $this->gsatelite->get_tabla('chp_cheque_pendiente', array('chp_id' => $cheque_pend));
                    if ($registro_cheque_pen[0]['chp_id_emp'] > 0 &&  $registro_cheque_pen[0]['chp_id_pla'] > 0) {
                        $datos_chp = $this->generar_partida_contable_cheque_planilla($cheque_pend); //se envia como parametro el id del cheque
                    }
                }

                /* ************************************************************************ */
                $cub = $this->input->post('cuenta_chequera');
                $num = $this->input->post('txtNumero');
                $concep = $this->gsatelite->get_campo('ttb_tipo_transact_bancaria', 'ttb_nombre', array('ttb_id' => 6));
                $concepto_transaccion = ($concep != null) ? $concep : "Salida por cheque";

                // $dat="";
                $da = 0;
                if ($cub != '') {
                    $array_tra = array(
                        'tra_id_cub'        => $cub,
                        'tra_id_ttb'        => ($concep != null) ? 6 : null,
                        'tra_fecha'         => (trim($fche) != '') ? $fche : date("Y-m-d H:i:s"),
                        'tra_operacion'     => $concepto_transaccion,
                        'tra_monto'         => (convertirFloat($serv) * (-1)),
                        'tra_comprobante'   => $num,
                        'tra_conciliado'    => $da,
                        'tra_estado'        => 1,
                        'tra_fecha_mod'     => date("Y-m-d H:i:s"),
                        'tra_usu_mod'       => $this->tank_auth->get_user_id(),
                        'tra_usu_crea'      => $this->tank_auth->get_user_id(),
                        'tra_fecha_crea'    => date("Y-m-d H:i:s"),
                        'tra_aplicar'       => $aplicar_cheque
                    );

                    $transaccion = $this->gsatelite->ingresar('tra_transaccion', $array_tra);

                    $actualizar = array('che_id_tra' => $transaccion);
                    $this->db->where('che_id', $id);
                    $this->db->update('che_cheque', $actualizar);

                    /***************Generacion de partida Manual*****************************/
                    if (!$idprv && ($otra_partida > 0)) {
                        $this->load->library('../controllers/modulo_contabilidad/procesos');
                        //Preparando arreglo
                        $array_partida_manual = [];

                        $array_partida_manual['id_prc'] = $this->input->post('id_prc');
                        $array_partida_manual['concepto_gral'] = $this->input->post('concepto_gral');
                        $array_partida_manual['volver'] = $this->input->post('volver');
                        $array_partida_manual['tipo'] = $this->input->post('tipo');
                        $array_partida_manual['fecha'] = $this->input->post('fecha');
                        $array_partida_manual['cuenta'] = $this->input->post('cuenta');
                        $array_partida_manual['debe'] = $this->input->post('debe');
                        $array_partida_manual['haber'] = $this->input->post('haber');
                        $array_partida_manual['contador_det_partida'] = $this->input->post('contador_det_partida');
                        $array_partida_manual['validacion_det_partida'] = $this->input->post('validacion_det_partida');
                        $array_partida_manual['slcCntOculto'] = $this->input->post('slcCntOculto');
                        $array_partida_manual['detalle_c'] = $this->input->post('detalle_c');
                        $array_partida_manual['detalle_d'] = $this->input->post('detalle_d');
                        $array_partida_manual['detalle_h'] = $this->input->post('detalle_h');
                        $array_partida_manual['detalle_con'] = $this->input->post('detalle_con');
                        $array_partida_manual['total_debe'] = $this->input->post('total_debe');
                        $array_partida_manual['total_haber'] = $this->input->post('total_haber');
                        $array_partida_manual['idcheque'] = $id;
                        $array_partida_manual['proceso'] = 'banco_cheque';

                        $this->procesos->agregar_partida($array_partida_manual);
                    }
                    /************************************************************************/

                    if ($registro != 0) {
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Nuevo cheque", 'texto_alerta' => "Transacción efectuada correctamente");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Nuevo cheque", 'texto_alerta' => "Transacción no efectuada, favor verificar información");
                    }
                }
            }
            if ($this->input->post('id_pago_orden') > 0) {
                $this->utm_model->update_estado_pago($this->input->post('id_pago_orden'));
            }
        }

        $this->session->set_flashdata($alerta);

        $opc = $this->input->post('valor');
        if ($opc == 3) {
            redirect('utm/cuentas/cheques_consolidados');
        }
        if ($opc == 4) {
            redirect('utm/cuentas/cheques_consolidados');
        }

        if ($chp_id != 0) {
            redirect('utm/cuentas/cheques_pendientes');
        } else {

            if ($opc == 1) {
                redirect('utm/cuentas/agregar_cheque');
            }
            if ($opc == 2) {
                redirect('utm/cuentas/gestion_cheques');
            }
        }
    }

    /**
     * @author Edith Herrera
     * Descripcion: vista Editar cheque
     * @return
     */
    function editar_cheque($cod_che = null, $ver = null)
    {
        satelite_validar();
        $data['prv'] = $this->gsatelite->get_tabla('prv_proveedor');
        $data['datos'] = $this->gsatelite->get_tabla('che_cheque', array('che_id' => $cod_che));

        //detalle
        $where = null;
        $where['dch_id_che'] = $cod_che;
        $data['pagos'] = $this->utm_model->get_detalle_cheque($where);

        $data['id_cuenta'] = $this->gsatelite->get_campo('chq_chequera', 'chq_id_cub', array('chq_id' => $data['datos'][0]['che_id_chq']));
        $data['cuenta'] = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $data['id_cuenta']))->row_array();

        $id_ban = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_id_ban', array('cub_id' => $data['id_cuenta']));

        $data['banco'] = $this->gsatelite->get_campo('ban_banco', 'ban_nombre', array('ban_id' => $id_ban));
        $data['chequera'] = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_numero', array('cub_id' => $data['id_cuenta'])); //.$value['chq_numero']."-".$value['cub_numero']
        $data['chequera2'] = $this->gsatelite->get_campo('chq_chequera', 'chq_numero', array('chq_id' => $data['datos'][0]['che_id_chq']));
        $data['retencion'] = $this->gsatelite->get_tabla('ret_retencion');

        $data["titulo_personal"] = "Gestión Cheques";
        $data['ver'] = $ver;

        if ($ver != null && $ver == 2) {
            $this->gsatelite->cargar_vista_masterpage('utm/cuentas/editar_cheque', $data);
        } else {
            $this->_cargarvista($data);
        }
    }

    function guardar_edicion_cheque()
    {
        satelite_validar();
        try {

            //------------Nuevos datos-------------------------------------------------------/

            $cheque_id = $this->input->post('txtcheque');
            $che_orden = $this->input->post('txtOrden');
            $che_fecha = date('Y-m-d', strtotime($this->input->post('txtFecha')));
            $che_concepto = $this->input->post('txtConcepto');
            $che_monto = $this->input->post('txt_valor_monto');
            $che_monto_suj = $this->input->post('txt_total_monto_sujeto');
            $che_renta_monto = $this->input->post('txt_total_monto');

            //------------Obtener datos del cheque -------------------------------------------/

            $datos_cheque = $this->gsatelite->get_tabla('che_cheque', array('che_id' => $cheque_id));

            //------------Actualizar la transaccion ------------------------------------------/

            $array_tra = null;
            $array_tra['tra_monto'] = $che_monto * -1;
            $array_tra['tra_fecha_mod'] = date("Y-m-d H:i:s");
            $array_tra['tra_usu_mod'] = $this->tank_auth->get_user_id();

            $this->gsatelite->actualizar_array('tra_transaccion', $array_tra, array('tra_id' => $datos_cheque[0]['che_id_tra']));

            //------------Actualizar cheque --------------------------------------------------/

            $array_che = null;

            $array_che['che_orden'] = $che_orden;
            $array_che['che_fecha'] = $che_fecha;
            $array_che['che_concepto'] = $che_concepto;
            $array_che['che_monto'] = $che_monto;
            $array_che['che_monto_suj'] = $che_monto_suj;
            $array_che['che_renta_monto'] = $che_renta_monto;
            $array_che['che_fecha_mod'] = date("Y-m-d H:i:s");
            $array_che['che_usu_mod'] = $this->tank_auth->get_user_id();

            $this->gsatelite->actualizar_array('che_cheque', $array_che, array('che_id' => $cheque_id));

            //------------Actualizar  detalle cheque y actualizar retencion---------------------/

            $dch_id = $this->input->post('txtTablaDetalle');

            $dch_concepto = $this->input->post('txtTablaDescripcion');
            $dch_valor = $this->input->post('txtTablaMonto');
            $dch_retencion_calculada = $this->input->post('txtTablaRetencion');
            $dch_subtotal = $this->input->post('txtTablaTotal');
            $dch_id_dpv = $this->input->post('txtTablaFactura');
            $dch_retencion = $this->input->post('txtTablaMontoSujeto');

            //variables para la tabla rdc_retencion_detalle_cheque
            $id_retenciones = $this->input->post('txtTablaRetenciones_id');
            $porcentajes_retencion = $this->input->post('txtTablaRetenciones_procentaje');

            //obtener los detalles antiguos
            $detalles_cheque = $this->gsatelite->get_tabla('dch_detalle_cheque', array('dch_id_che' => $cheque_id));

            //eliminacion de detalles que no existen y sus retenciones
            foreach ($detalles_cheque as $det) {
                if (!in_array($det['dch_id'], $dch_id)) {
                    $this->gsatelite->borrado_general('dch_detalle_cheque', array('dch_id' => $det['dch_id']));
                    $this->gsatelite->borrado_general('rdc_retencion_detalle_cheque', array('rdc_id_dch' => $det['dch_id']));
                }
            }

            //actualizar detalles y retenciones
            foreach ($dch_id as $key => $value) {
                if ($value != "") {
                    //actualizar
                    //se borran las retenciones del detalle
                    $this->gsatelite->borrado_general('rdc_retencion_detalle_cheque', array('rdc_id_dch' => $value));

                    $array_det = array(
                        'dch_concepto' => $dch_concepto[$key],
                        'dch_valor' => $dch_valor[$key],
                        'dch_retencion' => $dch_retencion[$key],
                        'dch_retencion_calculada' => $dch_retencion_calculada[$key],
                        'dch_subtotal' => $dch_subtotal[$key],
                        'dch_id_dpv' => ($dch_id_dpv[$key] == "") ? null : $dch_id_dpv[$key],
                        'dch_estado' => 1,
                        'dch_usu_mod' => $this->tank_auth->get_user_id(),
                        'dch_fecha_mod' => date('Y-m-d H:i:s'),
                        'dch_id_che' => $cheque_id
                    );
                    $this->gsatelite->actualizar_array('dch_detalle_cheque', $array_det, array('dch_id' => $value));

                    if ($id_retenciones[$key] != "") {
                        $id_retenciones_array = split(",", $id_retenciones[$key]);
                        $porcentajes_retencion_array = split(",", $porcentajes_retencion[$key]);

                        foreach ($id_retenciones_array as $key2 => $value2) {
                            $array_ret = array(
                                'rdc_ret_id' => $value2,
                                'rdc_id_dch' => $value,
                                'rdc_porcentaje' => $porcentajes_retencion_array[$key2],
                                'rdc_estado' => 1,
                                'rdc_usu_creacion' => $this->tank_auth->get_user_id(),
                                'rdc_fecha_creacion' => date('Y-m-d H:i:s'),
                                'rdc_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'rdc_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('rdc_retencion_detalle_cheque', $array_ret);
                        }
                    }
                } else {
                    //insertar
                    $array_det = array(
                        'dch_concepto' => $dch_concepto[$key],
                        'dch_valor' => $dch_valor[$key],
                        'dch_retencion' => $renta[$key],
                        'dch_retencion_calculada' => $dch_retencion_calculada[$key],
                        'dch_subtotal' => $sub_total[$key],
                        'dch_id_dpv' => ($dch_id_dpv[$key] == "") ? null : $dch_id_dpv[$key],
                        'dch_estado' => 1,
                        'dch_usu_mod' => $this->tank_auth->get_user_id(),
                        'dch_fecha_mod' => date('Y-m-d H:i:s'),
                        'dch_id_che' => $cheque_id,
                        'dch_usu_crea' => $this->tank_auth->get_user_id(),
                        'dch_fecha_crea' => date('Y-m-d H:i:s')
                    );
                    $retencion_detalle = $this->gsatelite->ingresar('dch_detalle_cheque', $array_det);

                    if ($id_retenciones[$key] != "") {
                        $id_retenciones_array = split(",", $id_retenciones[$key]);
                        $porcentajes_retencion_array = split(",", $porcentajes_retencion[$key]);

                        foreach ($id_retenciones_array as $key2 => $value2) {
                            $array_ret = array(
                                'rdc_ret_id' => $value2,
                                'rdc_id_dch' => $retencion_detalle,
                                'rdc_porcentaje' => $porcentajes_retencion_array[$key2],
                                'rdc_estado' => 1,
                                'rdc_usu_creacion' => $this->tank_auth->get_user_id(),
                                'rdc_fecha_creacion' => date('Y-m-d H:i:s'),
                                'rdc_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'rdc_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('rdc_retencion_detalle_cheque', $array_ret);
                        }
                    }
                } // end if
            } //end for detalle

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Edición Exitosa", 'texto_alerta' => "Se editó el cheque correctamente.");
        } catch (Exception $e) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "No se pudo realizar la operación.");
        }

        $this->session->set_flashdata($alerta);

        $opc = $this->input->post('valor');
        if ($opc == 1) {
            redirect('utm/cuentas/editar_cheque/' . $cheque_id);
        }
        if ($opc == 2) {
            redirect('utm/cuentas/gestion_cheques');
        }
    }

    /**
     * Cuentas::gestion_cheques()
     * @author Alexis Beltran
     *
     * @return
     */
    function gestion_cheques()
    {
        $edicion = NULL;
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('utm/cuentas/gestion_cheques');
        try {
            $vista_cheque = $this->db->table_exists("vw_chequeras");
            if (!$vista_cheque) {
                $this->gsatelite->show_dialog('Verifique la existencia de la Vista de Chequeras', 'utm/index', 'error', 'Error de Estructura de Base Datos');
            }
            if ($_POST) {
                $this->form_validation = FALSE;
                extract($this->input->post());
            }

            $columns = array(
                'banco',
                // 'che_id_chq',
                'che_numero',
                'che_fecha',
                'che_id_prv',
                'che_orden',
                'che_concepto',
                'che_monto',
                // 'che_monto_suj',
                // 'che_renta_monto',
                'che_estado'
            );

            $display_as = array(
                'che_orden'      => 'A la orden de',
                'che_numero'     => 'Cheque Número',
                'che_fecha'      => 'Fecha',
                'che_id_prv'     => 'Proveedor',
                'che_monto'      => 'Valor del cheque',
                'che_id_chq'     => 'Chequera',
                'che_concepto'   => 'Concepto',
                'che_renta'      => 'Aplica Renta',
                'che_monto_suj'  => 'Monto sujeto a retención',
                'che_renta_monto' => 'Monto de renta',
                'che_usu_mod'    => 'Usuario',
                'che_fecha_mod'  => 'Fecha',
                'che_estado'     => 'Estado'
            );

            $crud = new grocery_CRUD;
            $crud->set_table('che_cheque');
            $crud->set_subject('Cheques');
            $crud->display_as($display_as);
            $crud->callback_column('che_fecha', array($this, '_format_date'));
            $crud->field_type('che_renta', 'hidden');
            $crud->field_type('che_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('che_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->callback_column('che_monto', array($this, '_format_money'));
            $crud->callback_column('che_orden', function ($value, $row) {
                //Se obtiene el valor de tra_aplicar y si es 1 no deberia mostrarse aplicar transaccion
                $aplicar = $this->gsatelite->get_campo('tra_transaccion', 'tra_aplicar', array('tra_id' => $row->che_id_tra));
                $span = ($aplicar == 1) ? '<span class = "remover_accion" style="display: none"></span>' : ''; //si es 1 se pinte un span
                $value = $value . $span; //value es lo que tiene la columna y a eso le agrego el span
                return $value; //reemplaza el texto que tenia
            });

            $crud->callback_column('banco', function ($value, $row) {
                $this->db->join('chq_chequera', 'chq_id = che_id_chq');
                $this->db->join('cub_cuenta_bancaria', 'cub_id = chq_id_cub');
                $this->db->join('ban_banco', 'ban_id = cub_id_ban');
                return $this->gsatelite->get_campo('che_cheque', 'ban_nombre', array('che_id' => $row->che_id));
            });
            $crud->columns($columns);
            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('che_estado', 'hidden', 1);
            } else {
                $crud->field_type('che_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $crud->callback_column('che_estado', function ($value, $row) {
                $estado = '';
                if ($value == 1) {
                    $estado = 'Activo';
                } else {
                    $estado = 'Anulado';
                }
                return $estado;
            });

            // Formato al nombre de la primer colulmna (Chequera)
            $crud->set_primary_key('chq_id', 'vw_chequeras');
            $crud->set_relation('che_id_chq', 'vw_chequeras', '{chq_numero} ({cuenta})');
            $crud->set_relation('che_id_prv', 'prv_proveedor', 'prv_nombre');

            if ($chq_id = $this->input->get('chq_id')) {
                $crud->where('chq_id', $chq_id);
            }
            $crud->callback_column('che_monto_suj', function ($value, $row) {
                $monto_sujeto = $this->gsatelite->get_suma('dch_detalle_cheque', 'dch_retencion', array('dch_id_che' => $row->che_id));
                return $monto_sujeto;
            });
            $crud->callback_column('che_renta_monto', function ($value, $row) {
                $monto_renta = $this->gsatelite->get_suma('dch_detalle_cheque', 'dch_retencion_calculada', array('dch_id_che' => $row->che_id));
                return $monto_renta;
            });

            //filtrado de chequere hecho en el día
            if (isset($filtros)) {
                $crud->where("che_impreso = 0");
                //chequeras en base a cuenta
                if ($cub_id > 0) {
                    $ids = $this->db
                        ->select('Group_concat(chq_id) as ids')
                        ->from('chq_chequera')
                        ->where('chq_id_cub', $cub_id)
                        ->get()
                        ->row()
                        ->ids;
                    $ids = (strlen($ids) > 0) ? $ids : '0';
                    $crud->where("che_id_chq in ({$ids})");
                }

                // filtro por fecha
                if (strlen($fecha_desde) + strlen($fecha_hasta) > 0) {
                    $crud->where('che_fecha >=', date('Y-m-d', strtotime(str_replace('/', '-', $fecha_desde))));
                    $crud->where('che_fecha <=', date('Y-m-d', strtotime(str_replace('/', '-', $fecha_hasta))));
                }

                //filtrado por monto
                if (isset($monto_desde) && isset($monto_hasta) && ($monto_desde + $monto_hasta > 0)) {
                    $crud->where('che_monto >=', $monto_desde);
                    $crud->where('che_monto <=', $monto_hasta);
                }

                // filtrado por estado de cheque
                if ($slc_estado == 1) {
                    $crud->where('che_estado', 1);
                } else if ($slc_estado == 2) {
                    $crud->where('che_estado', 0);
                }
            } else {

                if (!empty($edicion)) {
                    $crud->where('chq_id', $edicion);
                    $filtros = '';
                } else {
                    $crud->where('che_estado', 1);
                    $crud->where('che_fecha', date('Y-m-d'));
                    $filtros = '';
                }
            }

            //Procesos Creacion
            $crud->callback_add_field('che_numero', function () {
                return '<input id="che_numero" name="che_numero" type="text" value="Seleccione una chequera" size="100" readonly="readonly" />';
            });

            $crud->callback_before_insert(function ($post_array, $primary_key = null) {
                $post_array['che_concepto'] = htmlentities($post_array['che_concepto']);
                if (!empty($post_array['che_renta_monto'])) {
                    $post_array['che_monto'] = $post_array['che_monto'] - $post_array['che_renta_monto'];
                }
                return $post_array;
            });

            $crud->callback_after_insert(function ($post_array, $primary_key) {

                //generamos la transaccion
                $cub_id = $this->db->get_where('chq_chequera', array('chq_id' => $post_array['che_id_chq']))->row()->chq_id_cub;

                $this->db->insert('tra_transaccion', array(
                    'tra_id_cub' => $cub_id,
                    'tra_id_usu' => $this->tank_auth->get_user_id(),
                    'tra_fecha' => date("Y-m-d H:i:s"),
                    'tra_monto' => -$post_array['che_monto'],
                    'tra_tipo' => 166,
                    'tra_operacion' => $post_array['che_concepto'],
                    'tra_origen' => 1,
                    'tra_fecha_mod' => date("Y-m-d H:i:s"),
                    'tra_numero' => $post_array['che_numero']
                ));

                //guardamos la transaccion en el cheque
                $tra_id = $this->db->insert_id();
                $this->db->update('che_cheque', array('che_id_tra' => $tra_id), array('che_id' => $primary_key), 1);
            });

            //Proceso de edicion
            $crud->callback_before_update(function ($post_array, $primary_key) {
                $post_array['che_concepto'] = htmlentities($post_array['che_concepto']);
                $post_array['che_monto'] = $post_array['che_monto'] - $post_array['che_renta_monto'];
                return $post_array;
            });

            $crud->callback_after_update(function ($post_array, $primary_key) {
                //actualizamos estado
                $tra_id = $this->gsatelite->get_campo('che_cheque', 'che_id_tra', array('che_id' => $primary_key));
                //actualizamos la transaccion
                $this->db->update('tra_transaccion', array('tra_monto' => -$post_array['che_monto']), array('tra_id' => $tra_id));
            });


            // Validaciones
            if ($permisos['permite_ver']) {
                $crud->add_action('Imprimir Cheque', '', 'utm/cuentas/che_voucher', 'icomoon-icon-printer print_cheque', null, "", "[che_estado] == 'Activo'")
                    ->add_action('Imprimir Cheque-Voucher', '', 'utm/cuentas/voucher', 'icomoon-icon-printer print_cheque', null, "", "[che_estado] == 'Activo'")
                    ->add_action('Imprimir Certificación', '', 'utm/cuentas/certificacion', 'icomoon-icon-printer print_cheque', null, "", "[che_estado] == 'Activo'")
                    ->add_action('Imprimir Remesa', '', 'utm/cuentas/remesa', 'icomoon-icon-printer print_cheque', null, "", "[che_estado] == 'Activo'")
                    ->add_action('Imprimir comp. cheque', '', 'utm/cuentas/comprobante_cheque', 'icomoon-icon-printer print_cheque', null, "", "[che_estado] == 'Activo'")
                    ->add_action('Vericar impresión', '', 'utm/cuentas/verificar_impresion', 'icomoon-icon-printer verificar_cheque', null, "", "[che_estado] == 'Activo'")
                    ->add_action('Entregar cheque', '', 'utm/cuentas/entregar_cheque', 'icomoon-icon-printer entrega_cheque', null, "", "[che_estado] == 'Activo'");
                $crud->add_action('Ver', '', 'utm/cuentas/ver_cheque', 'icomoon-icon-search-5');
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if ($permisos['permite_editar']) {
                $crud->add_action('Aplica Caja chica', '', 'utm/cuentas/aplicar_caja_chica', 'icomoon-icon-coins ver_en_modal_ajax2', null, "", "[che_estado] == 'Activo' AND [che_id_cch] == ''");
                $crud->add_action('Aplicar Transacción', '', 'utm/cuentas/aplicar_cheque', 'ver_en_modal_ajax2 icomoon-icon-checkmark-2 aplicar_transaccion', null, "", "[che_estado] == 'Activo'");
            }
            if ($permisos['permite_eliminar']) {
                $crud->add_action('Anular', '', 'utm/cuentas/anular_cheque', 'ver_en_modal_ajax2 icomoon-icon-cancel-3', null, "", "[che_estado] == 'Activo'");
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }
            $permiso_partida = $this->gsatelite->get_permisos_opcion("modulo_contabilidad/procesos/partida_contable", "editar", null, true);
            if ($permiso_partida > 0) {
                $crud->add_action('Editar partida', '', '', 'icomoon-icon-pencil-5', array($this, 'editar_partida_cheque'), "", "[che_id_pct] != null");
            }

            $crud->unset_export();
            $crud->unset_print();
            $crud->unset_edit();
            $crud->unset_delete();

            $crud->add_fields('che_id_prv', 'che_id_chq', 'che_numero', 'che_monto', 'che_orden', 'che_fecha', 'che_concepto', 'che_renta', 'che_monto_suj', 'che_renta_monto', 'che_usu_mod', 'che_fecha_mod', 'che_estado');
            $crud->edit_fields('che_orden', 'che_fecha', 'che_concepto', 'che_monto', 'che_renta', 'che_monto_suj', 'che_renta_monto');

            $crud->required_fields('che_id_chq', 'che_numero', 'che_orden', 'che_monto', 'che_fecha');
            $crud->set_rules('che_numero', 'Número', 'required')
                ->set_rules('che_orden', 'A la orden', 'required|alpha')
                ->set_rules('che_concepto', 'Concepto', 'required');
            $crud->set_language('spanish');

            $data = array(
                'filtros' => $filtros,
                'titulo_personal' => "Gestión de cheques"
            );

            $output = $crud->render();
            $url = explode('/', uri_string());

            if (end($url) == 'add') {
                redirect('utm/cuentas/agregar_cheque');
            }
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function editar_partida_cheque($primary_key, $row){
        return site_url('modulo_contabilidad/procesos/editar_partida') . '/' . $row->che_id_pct . '/3';
    }

    function obtener_datos_cub()
    {
        $monto = $this->input->post('monto');

        $cuenta_bancaria = $this->input->post('cuenta_bancaria');
        $cub = $this->db->query('SELECT * FROM `chq_chequera` where chq_id =' . $cuenta_bancaria)->row_array();
        $cuenta_banco = $cub['chq_id_cub'];
        $datos_cuenta = $this->db->query("SELECT `cub_cuenta_bancaria`.`cub_id`           AS `cub_id`,
          CONCAT(`ban_banco`.`ban_nombre`,': ',`cub_cuenta_bancaria`.`cub_numero`) AS `cuenta`,
          `cub_cuenta_bancaria`.`cub_nombre`       AS `nombre`,
          IF((COUNT(`tra_transaccion`.`tra_monto`) > 0),(`cub_cuenta_bancaria`.`cub_saldo_inicial` + 
          SUM(`tra_transaccion`.`tra_monto`)),`cub_cuenta_bancaria`.`cub_saldo_inicial`) AS `saldo`,
          `cub_cuenta_bancaria`.`cub_saldo_minimo` AS `saldo_minimo`
        FROM ((`cub_cuenta_bancaria`
            LEFT JOIN `tra_transaccion`
              ON ((`tra_transaccion`.`tra_id_cub` = `cub_cuenta_bancaria`.`cub_id`)))
           LEFT JOIN `ban_banco`
             ON ((`cub_cuenta_bancaria`.`cub_id_ban` = `ban_banco`.`ban_id`)))
     WHERE tra_conciliado >= 0 AND cub_cuenta_bancaria.`cub_id` =" . $cuenta_banco)->row_array();

        $disponible = $datos_cuenta['saldo'];
        if ($monto <= $disponible) {
            echo 1;
        } else {
            echo 0;
        }
    }

    function obtener_a_la_orden_de()
    {
        $id_proveedor = $this->input->post('id_proveedor');
        $proveedor = $this->db->query('select * from prv_proveedor where prv_id=' . $id_proveedor)->row_array();
        echo $proveedor['prv_extender_a'];
    }

    function che_add_detalle($che_id = 0)
    {

        if ($che_id > 0) {

            $this->che_add_detalle = $che_id;
            $crud = new grocery_CRUD;
            $crud->set_table('dch_detalle_cheque')->set_subject('Detalle');
            $crud->display_as('dch_id_cpr', 'Cuenta Presupuestaria')
                ->display_as('dch_parcial', 'Parcial')
                ->display_as('dch_factura', 'Factura')
                ->display_as('dch_haber', 'Haber')
                ->display_as('dch_detalle_abierto', 'Detalle');
            $crud->where('dch_id_che', $che_id);
            $crud->columns('dch_id_cpr', 'dch_parcial', 'dch_factura', 'dch_detalle_abierto');
            $crud->set_relation('dch_id_cpr', 'cpr_cuenta_presupuesto', '{cpr_numero} {cpr_nombre}', "LENGTH(cpr_numero) = 5");
            $crud->add_fields('dch_id_cpr', 'dch_parcial', 'dch_factura', 'dch_detalle_abierto');
            $crud->set_rules('dch_parcial', 'Parcial', 'required|numeric|decimal');
            $crud->set_rules('dch_factura', 'Debe', 'required');
            //$crud->set_rules('dch_haber','Haber','required|decimal');
            $crud->required_fields('dch_id_cpr', 'dch_parcial');
            $crud->callback_after_insert(function ($post, $primary) {
                return $this->db->update('dch_detalle_cheque', array('dch_id_che' => $this->che_add_detalle), array('dch_id' => $primary));
            });
            $crud->edit_fields('dch_id_cpr', 'dch_parcial', 'dch_factura', 'dch_detalle_abierto');
            $crud->set_language('spanish');
            $crud->unset_export()->unset_print();
            $output = $crud->render();
            $data['titulo_personal'] = "Agregar detalle";
            $this->_cargarvista($data, $output);
        }
    }

    function rpt_cheques_rechazados()
    {
        //(new Procesos())->validar_user();
        try {
            $this->load->library('pdf');

            $fecha_ini = '2013-07-01';
            $fecha_fin = '2013-07-30';
            $cuenta = 'Todas';

            //carga de datos
            $this->db->select(
                'che_cheque.che_id,
  vw_cuentas_bancarias.cub_id,
  vw_cuentas_bancarias.cuenta,
  che_cheque.che_numero,
  che_cheque.che_monto,
  che_cheque.che_orden,
  che_cheque.che_concepto,
  che_cheque.che_fecha,
  users.username,
  try_trayecto.try_fecha_fin as try_fecha,
  try_trayecto.try_obs'
            );
            $this->db->join('try_trayecto', 'che_id = try_registro_id');
            $this->db->join('pas_paso', 'try_id_pas = pas_id');
            $this->db->join('users', 'try_id_use = id');
            $this->db->join('chq_chequera', 'che_id_chq = chq_id');
            $this->db->join('vw_cuentas_bancarias', 'chq_id_cub = cub_id');
            //$this->db->where("try_fecha_fin Between '$fecha_ini' And '$fecha_fin'");
            $this->db->where(array(
                'pas_id_tar' => 1,
                'try_aceptado' => 3
            ));
            $this->db->group_by('che_id');

            $data = array(
                'cheques' => $this->db->get('che_cheque')->result(),
                'cuenta' => $cuenta,
                'fecha_ini' => $fecha_ini,
                'fecha_fin' => $fecha_fin,
                'titulo' => 'Reporte de Cheques Rechazados'
            );


            $html = $this->load->view('utm/cuentas/rpt_che_rechazados', $data, true);

            //echo $html;
            //Impresion
            $this->pdf->setPageOrientation('L');
            $this->pdf->makePDF($html);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function rpt_cheques_anulados()
    {
        //(new Procesos())->validar_user();
        try {
            $this->load->library('pdf');

            $fecha_ini = '2013-07-01';
            $fecha_fin = '2013-07-30';
            $cuenta = 'Todas';

            //carga de datos
            $this->db->select(
                'che_cheque.che_id,
  vw_cuentas_bancarias.cub_id,
  vw_cuentas_bancarias.cuenta,
  che_cheque.che_numero,
  che_cheque.che_monto,
  che_cheque.che_orden,
  che_cheque.che_concepto,
  che_cheque.che_fecha,
  users.username,
  try_trayecto.try_fecha_fin as try_fecha,
  try_trayecto.try_obs'
            );
            $this->db->join('try_trayecto', 'che_id = try_registro_id');
            $this->db->join('pas_paso', 'try_id_pas = pas_id');
            $this->db->join('users', 'try_id_use = id');
            $this->db->join('chq_chequera', 'che_id_chq = chq_id');
            $this->db->join('vw_cuentas_bancarias', 'chq_id_cub = cub_id');
            //$this->db->where("try_fecha_fin Between '$fecha_ini' And '$fecha_fin'");
            $this->db->where(array(
                'pas_id_tar' => 1,
                'try_id_pas' => 12
            ));
            $this->db->group_by('che_id');

            $data = array(
                'cheques' => $this->db->get('che_cheque')->result(),
                'cuenta' => $cuenta,
                'fecha_ini' => $fecha_ini,
                'fecha_fin' => $fecha_fin,
                'titulo' => 'Reporte de Cheques Anulados'
            );


            $html = $this->load->view('utm/cuentas/rpt_che_rechazados', $data, true);

            //echo $html;
            //Impresion
            $this->pdf->setPageOrientation('L');
            $this->pdf->makePDF($html);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function verificar_impresion($che_id)
    {
        if ($che_id > 0) {
            $descripcion = $this->input->post('descripcion');
            $fecha_cheque = date('Y-m-d H:i:s');
            $actualizar_cheque = array(
                "che_impreso" => 1,
                "che_fecha_impreso" => $fecha_cheque,
                "che_observacion_impreso" => $descripcion,
                "che_id_usu_impreso" => $this->tank_auth->get_user_id(),
                "che_usu_mod" => $this->tank_auth->get_user_id(),
                "che_fecha_mod" => $fecha_cheque,

            );
            $this->gsatelite->actualizar_array('che_cheque', $actualizar_cheque, array('che_id' => $che_id));
            redirect('utm/cuentas/gestion_cheques');
        }
    }


    function che_voucher($che_id = 0)
    {
        $lugar_ = $this->gsatelite->get_parametro('SYS_DEPARTAMENTO');
        if ($che_id > 0) {
            $this->db->select('*, dch_detalle_cheque.dch_id As dch_id');
            //$this->db->join('cpr_cuenta_presupuesto', 'dch_id_cpr = cpr_id', 'left');
            $detalle = $this->db->get_where('dch_detalle_cheque', array('dch_id_che' => $che_id))->result();

            $form = $this->db->query('
            Select *,
              che_cheque.che_id As che_id,
              ban_banco.ban_nombre As banco,
              cub_cuenta_bancaria.cub_numero As cuenta,
              cub_cuenta_bancaria.cub_nombre As cuenta_nombre,
              che_cheque.che_numero As cheque,
              che_cheque.che_concepto As concepto,
              che_cheque.che_monto as monto
            From
              ban_banco
              Inner Join cub_cuenta_bancaria On cub_cuenta_bancaria.cub_id_ban = ban_banco.ban_id
              Inner Join chq_chequera On chq_chequera.chq_id_cub = cub_cuenta_bancaria.cub_id
              Inner Join che_cheque On che_cheque.che_id_chq = chq_chequera.chq_id
            Where
              che_cheque.che_id = ' . $che_id . '
            ')->row();

            // $che = new Procesos();
            // $historico = $che->get_historico(1, $che_id);
            // $history = array();
            // foreach($historico as $row){
            //     $history[$row->paso] = $row;
            // }
            //print_r($historico); die();
            $proveed = $form->che_id_prv;
            $data_prv = array();
            if ($proveed != null) {
                $data_prv = $this->db->query('select * from prv_proveedor where prv_id=' . $proveed)->row_array();
            }
            $data = array(
                'banco' => $form->banco, 'cuenta' => $form->cuenta, 'cuenta_nombre' => $form->cuenta_nombre, 'cheque' => $form->cheque, 'concepto' => $form->concepto, 'renta' => $form->che_renta, 'valor_servicio' => $form->che_monto, 'monto_sujeto_retencion' => $form->che_monto_suj, 'valor_renta' => $form->che_renta_monto, 'che_orden' => $form->che_orden, 'nit' => $data_prv['prv_nit'], 'form' => $form, 'detalle' => $detalle
                // , 'creo' => $history['Creado']->username . ': ' . $history['Creado']->fecha
                //, 'autorizo' => $history['Firmado']->username . ': ' . $history['Creado']->fecha
            );
            // var_dump($form->chq_tipo); die();
            //forma de impresion
            switch ($form->chq_tipo) {
                case 1:
                    //FORMATO DE IMPRECION DE CHEQUE PARA CYP
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 12, 0, 0);
                    $this->pdf->SetAutoPageBreak(FALSE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));

                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');


                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' DE ' . $meses[(int) $date[1]] . ' DE ' . $date[0];
                    $fecha = strtoupper($fecha);
                    // $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    // $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);
                    $centavitos = explode('.', number_format(($cheque->che_monto - (int) $cheque->che_monto), 2));
                    $centavos = ' ' . $centavitos[1] . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);
                    $valor_letras .= ($centavitos[1] > 0) ? "" : $centavos;
                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //fecha
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(35, 8);
                    $this->pdf->Cell(0, 8, $lugar_ . ', ' . $fecha, $borde, 0, '', false, '', 3, false, 'T', 'B');
                    //monto
                    $this->pdf->SetXY(125, 7, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(25, 13);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');
                    //textMonto
                    $this->pdf->SetXY(25, 19);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    /*
                    $this->pdf->SetXY(10, 70);
                    $this->pdf->Cell(75, 8, 'RENTA RETENIDO $ ' . number_format($cheque->che_renta_monto, 2), $borde, 0, '', false, '', 3, false, 'T', 'M');
                    $this->pdf->SetXY(85, 70);
                    $this->pdf->Cell(75, 8, 'IVA RETENIDO   $ ' . number_format($cheque->che_iva_monto, 2), $borde, 0, '', false, '', 3, false, 'T', 'M');*/
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);



                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    // $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();
                    $this->pdf->setPrintFooter(false);
                    $this->pdf->boletaPDF('I');
                    break;

                case 2:
                    //Voucher Sonsonate
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();
                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', 'letter', array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));


                    //voucher
                    $this->pdf->SetXY(12.0, 22.0, true);
                    $this->pdf->Cell(188.0, 240.0, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(22.0, 27.0, true);
                    $this->pdf->Cell(167.0, 69.0, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavitos = explode('.', number_format(($cheque->che_monto - (int) $cheque->che_monto), 2));
                    $centavos = ' ' . $centavitos[1] . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);
                    $valor_letras .= ($centavitos[1] > 0) ? "" : $centavos;
                    //fecha
                    $this->pdf->SetXY(30, 33);
                    $this->pdf->Cell(80, 8, $lugar_ . ', ' . $fecha, $borde, 0, '', false, '', 3, false, 'T', 'B');
                    //monto
                    $this->pdf->SetXY(132, 33, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(52, 49);
                    $this->pdf->Cell(136, 8, mb_strtoupper($cheque->che_orden, 'UTF-8'), $borde, 0, '', false, '', 0, false, 'T', 'B');
                    //textMonto
                    $this->pdf->SetXY(47, 60);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/* this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');
                    //Cuenta
                    $this->pdf->SetXY(13, 101);
                    $this->pdf->Cell(50, 8, $data['cheque'], $borde, 0, 'C', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(66, 101);
                    $this->pdf->Cell(62, 8, $data['banco'], $borde, 0, 'C', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(131, 101);
                    $this->pdf->Cell(67, 8, $data['cuenta'], $borde, 0, 'C', false, '', 0, false, 'T', 'B');

                    //concepto
                    $this->pdf->writeHTMLCell(185, 13, 13, 117, $cheque->che_concepto, $borde, 0, false, true, 'C');

                    //cheque
                    $ay = 170;
                    $ax = 30;

                    $this->pdf->SetXY(30.0, 170.0, true);
                    $this->pdf->Cell(154.0, 70.0, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(25 + $ax, 15 + $ay);
                    $this->pdf->Cell(80, 8, $lugar_ . ', ' . $fecha, $borde, 0, '', false, '', 3, false, 'T', 'B');
                    $this->pdf->SetXY(113 + $ax, 15 + $ay, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, 'R', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(20 + $ax, 23 + $ay);
                    $this->pdf->Cell(130, 7, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(20 + $ax, 30 + $ay);
                    $this->pdf->Cell(130, 7, strtoupper($this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos, $borde, 0, '', false, '', 0, false, 'T', 'B');



                    $this->pdf->boletaPDF('I');
                    break;


                case 3:
                    $this->load->library('EnLetras');
                    $data['cheque'] = $this->db->get_where('che_cheque', array('che_id' => $che_id))->result_array();
                    $cub = $this->gsatelite->get_campo('che_cheque', 'che_id_chq', array('che_id' => $che_id));
                    $chq = $this->gsatelite->get_campo('chq_chequera', 'chq_id_cub', array('chq_id' => $cub));
                    $data['cuenta'] = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_numero', array('cub_id' => $chq));

                    $this->load->library('pdf');
                    $html = $this->load->view('utm/cuentas/tipo_citi', $data, true);
                    $this->pdf->addPagina($html, 'P');

                    $this->pdf->boletaPDF('I');
                    break;

                case 4:
                    $this->load->library('EnLetras');
                    $data['cheque'] = $this->db->get_where('che_cheque', array('che_id' => $che_id))->result_array();
                    $cub = $this->gsatelite->get_campo('che_cheque', 'che_id_chq', array('che_id' => $che_id));
                    $chq = $this->gsatelite->get_campo('chq_chequera', 'chq_id_cub', array('chq_id' => $cub));
                    $data['cuenta'] = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_numero', array('cub_id' => $chq));
                    //echo json_encode($data['cheque']);
                    //echo json_encode($data['cuenta']);
                    //exit();
                    $this->load->library('pdf');
                    $html = $this->load->view('utm/cuentas/tipo_scotiabank', $data, true);
                    $this->pdf->addPagina($html, 'P');

                    $this->pdf->boletaPDF('I');
                    break;

                case 5:
                    //Cheque Voucher
                    //BAC TROQUELES
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 12, 0, 0);
                    $this->pdf->SetAutoPageBreak(FALSE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' DE ' . $meses[(int) $date[1]] . ' DE ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //fecha
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(33, 9);
                    $this->pdf->Cell(0, 8, mb_strtoupper($lugar_, 'UTF-8') . ', ' . $dia . ' DE ' . $mes, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Anio
                    $this->pdf->SetXY(77, 9);
                    $this->pdf->Cell(80, 8, ' DE ' . $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //monto
                    $this->pdf->SetXY(105, 9, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(25, 14);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(25, 19);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    // Cantidad que aparece a un lado
                    // $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();
                    $this->pdf->setPrintFooter(false);

                    $this->pdf->boletaPDF('I');
                    break;

                case 6:
                    //Cheque Voucher
                    //BAC INTERVISION | SAT
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();
                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('dejavusans');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'dejavusans',
                        'style' => '',
                        'size' => 7
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' DE ' . strtoupper($meses[(int) $date[1]]) . ' DE ' . $date[0];

                    $monto = explode('.', number_format($cheque->che_monto, 2, '.', ''));
                    $centativos = $cheque->che_monto - (int) $cheque->che_monto;
                    $centavos = ($monto[1] > 0) ? ' CON ' . $monto[1] . '/100' : ' CON 00/100';
                    $valor_letras = $this->texto->ValorEnLetras($monto[0]);
                    // $centavos = ' ' . (number_format($centativos, 2)) . '/100';
                    // $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);
                    $valor_letras .=  $centavos;

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //lugar y dia, mes
                    $this->pdf->SetFont('dejavusans', '', 7);
                    $this->pdf->SetXY(25, 0);//    $this->pdf->SetXY(28, 2.0);
                    $this->pdf->Cell(80, 7, $lugar_ . ', ' . $dia . ' de ' . $mes . ' de ' . $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');//80|8

                    //Monto
                    $this->pdf->SetXY(95, 0, true);//  $this->pdf->SetXY(98, 2.0, true);
                    $this->pdf->Cell(33, 7, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');//35|8

                    //AlaOrden
                    $this->pdf->SetXY(18, 4.9);// $this->pdf->SetXY(18, 7.4);
                    $this->pdf->Cell(140, 8, mb_strtoupper($cheque->che_orden, 'UTF-8'), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(18, 9.9);/// $this->pdf->SetXY(18, 12.1);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    // $this->pdf->SetXY(-10, -20);
                    // $this->pdf->StartTransform();
                    // $this->pdf->Rotate(90);
                    // $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    // $this->pdf->StopTransform();
                    $this->pdf->setPrintFooter(false); //
                    $this->pdf->boletaPDF('I');
                    break;

                case 7:
                    //Cheque Voucher
                    //BAC ESPUMAR
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();
                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 8
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' DE ' . strtoupper($meses[(int) $date[1]]) . ' DE ' . $date[0];
                    $fecha = strtoupper($fecha);

                    $monto = explode('.', number_format($cheque->che_monto, 2, '.', ''));
                    $centativos = $cheque->che_monto - (int) $cheque->che_monto;
                    $centavos = ($monto[1] > 0) ? ' CON ' . $monto[1] . '/100' : ' CON 00/100';
                    $valor_letras = $this->texto->ValorEnLetras($monto[0]);
                    $valor_letras .=  $centavos;

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //LUGAR Dia Mes AÑO
                    $this->pdf->SetFont('helvetica', '', 8);
                    $this->pdf->SetXY(34, 13);
                    $this->pdf->Cell(80, 8, strtoupper($lugar_) . ', ' . $dia . ' DE ' . $mes . ' DE ' . $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Anio
                    // $this->pdf->SetXY(28, 2);
                    // $this->pdf->Cell(80, 8, $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(117, 13);
                    $this->pdf->Cell(34, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(26, 19);
                    $this->pdf->Cell(140, 8, mb_strtoupper($cheque->che_orden, 'UTF-8'), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(22, 25);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    // $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();

                    $this->pdf->setPrintFooter(false); //
                    $this->pdf->boletaPDF('I');
                    break;

                case 8:
                    //Cheque Voucher
                    //BAC MAYA COUNTRY
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //Dia
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(77, 16);
                    $this->pdf->Cell(80, 8, $lugar_ . ', ' . $dia . ' de ' . $mes, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Anio
                    $this->pdf->SetXY(124, 16);
                    $this->pdf->Cell(80, 8, $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(155, 16, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(50, 24);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(50, 32);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();

                    $this->pdf->boletaPDF('I');
                    break;

                case 9:
                    //Cheque Voucher
                    //BAC CENTRO CULTURAL SALVADOREÑO
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    /* *************** TAMANO DE LA PAGINA ********************** */
                    /* Formato que estaba antes: array(170, 215) */
                    $formato = "170,216";
                    $formato_array = explode(",", $formato); //convierte el formato a array por si se quiere un formato personalizado de pagina
                    $formato = (count($formato_array) > 1) ? $formato_array : $formato;
                    /* ********************************************************** */

                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', $formato, array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));

                    /* ********************** Colocar Border a la pagina ******************************* */
                    // $this->pdf->SetLineStyle( array( 'width' => 2, 'color' => array(0,0,0)));
                    // $this->pdf->Line(0,0,$this->pdf->getPageWidth(),0);
                    // $this->pdf->Line($this->pdf->getPageWidth(),0,$this->pdf->getPageWidth(),$this->pdf->getPageHeight());
                    // $this->pdf->Line(0,$this->pdf->getPageHeight(),$this->pdf->getPageWidth(),$this->pdf->getPageHeight());
                    // $this->pdf->Line(0,0,0,$this->pdf->getPageHeight());
                    /* ********************************************************************************** */

                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //lugar y dia
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(75, 14);
                    $this->pdf->Cell(80, 8, $dia, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Mes
                    $this->pdf->SetXY(95, 14);
                    $this->pdf->Cell(80, 8, $mes, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Anio
                    $this->pdf->SetXY(120, 14);
                    $this->pdf->Cell(80, 8, $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(140, 14, true);
                    $this->pdf->Cell(33, 8, '**** ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(45, 23);
                    $this->pdf->Cell(140, 8, '*** ' . strtoupper($cheque->che_orden) . ' ***', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(45, 32);
                    $this->pdf->Cell(140, 8, '*** ' . strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/ . ' ***', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();

                    $this->pdf->boletaPDF('I');
                    break;

                case 10:
                    //Cheque Voucher
                    //SCOTIABANK TROQUELES
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //lugar y dia
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(50, 7);
                    $this->pdf->Cell(80, 8, $lugar_ . ', ' . $dia, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Mes
                    $this->pdf->SetXY(80, 7);
                    $this->pdf->Cell(80, 8, $mes, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Anio
                    $this->pdf->SetXY(110, 7);
                    $this->pdf->Cell(80, 8, $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(125, 7, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(20, 25);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(20, 30);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();

                    $this->pdf->boletaPDF('I');
                    break;

                case 11:
                    //Cheque Voucher
                    //SCOTIABANK ESPUMAR
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //lugar y dia
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(65, 15);
                    $this->pdf->Cell(80, 8, $lugar_ . ', ' . $dia, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Mes
                    $this->pdf->SetXY(92, 15);
                    $this->pdf->Cell(80, 8, $mes, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Anio
                    $this->pdf->SetXY(125, 15);
                    $this->pdf->Cell(80, 8, $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(150, 15, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(55, 23);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(55, 32);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();

                    $this->pdf->boletaPDF('I');
                    break;

                case 12:
                    //Cheque Voucher
                    //Davivienda INTERVISION
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //lugar y dia, mes
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(30, 7);
                    $this->pdf->Cell(80, 8, $lugar_ . ', ' . $dia . ' de ' . $mes, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Anio
                    $this->pdf->SetXY(78, 7);
                    $this->pdf->Cell(80, 8, $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(110, 7, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(20, 13);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(20, 18);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();

                    $this->pdf->boletaPDF('I');
                    break;

                case 13:
                    //Cheque Voucher
                    //DAVIVIENDA ESPUMAR
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //Dia Mes
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(85, 15);
                    $this->pdf->Cell(80, 8, 'S.S ' . $dia . ' de ' . $mes . ' de ' . $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(155, 15, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(50, 22);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(50, 30);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();

                    $this->pdf->boletaPDF('I');
                    break;

                case 14:
                    //Cheque Voucher
                    //DAVIVIENDA MAYA COUNTRY
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //Dia
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(77, 15);
                    $this->pdf->Cell(80, 8, $lugar_ . ', ' . $dia . ' de ' . $mes . ' de ' . $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(155, 16, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(50, 23);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(50, 31);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();

                    $this->pdf->boletaPDF('I');
                    break;

                case 15:
                    //Cheque Voucher
                    //Banco Agricola INTERVISION
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //lugar y dia, mes
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(30, 7);
                    $this->pdf->Cell(80, 8, $lugar_ . ', ' . $dia . ' de ' . $mes, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Anio
                    $this->pdf->SetXY(80, 7);
                    $this->pdf->Cell(80, 8, $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(110, 7, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(20, 13);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(20, 19);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();

                    $this->pdf->boletaPDF('I');
                    break;

                case 16:
                    //Cheque Voucher
                    //BANCO AGRICOLA ESPUMAR
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();
                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 7
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' DE ' . strtoupper($meses[(int) $date[1]]) . ' DE ' . $date[0];
                    $fecha = strtoupper($fecha);

                    $monto = explode('.', number_format($cheque->che_monto, 2, '.', ''));
                    $centativos = $cheque->che_monto - (int) $cheque->che_monto;
                    $centavos = ($monto[1] > 0) ? ' CON ' . $monto[1] . '/100' : ' CON 00/100';
                    $valor_letras = $this->texto->ValorEnLetras($monto[0]);
                    $valor_letras .=  $centavos;

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //LUGAR Y FECHA
                    $this->pdf->SetFont('helvetica', '', 8);
                    $this->pdf->SetXY(35, 13);
                    $this->pdf->Cell(80, 8, strtoupper($lugar_) . ', ' . $dia . ' DE ' . $mes . ' DE ' . $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Mes
                    // $this->pdf->SetXY(95, 16);
                    // $this->pdf->Cell(80, 8, $mes, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    // //Anio
                    // $this->pdf->SetXY(124, 16);
                    // $this->pdf->Cell(80, 8, $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(121, 13, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(27, 19);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(27, 25);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    // $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();
                    $this->pdf->setPrintFooter(false); //
                    $this->pdf->boletaPDF('I');
                    break;

                case 17:
                    //Cheque Voucher
                    //BANCO AGRICOLA MAYA COUNTRY
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //Dia
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(77, 16);
                    $this->pdf->Cell(80, 8, $lugar_ . ', ' . $dia . ' de ' . $mes, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Anio
                    $this->pdf->SetXY(124, 16);
                    $this->pdf->Cell(80, 8, $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(155, 16, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(50, 24);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(50, 32);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();

                    $this->pdf->boletaPDF('I');
                    break;

                case 18:
                    //Cheque Voucher
                    //BANCO CUSCATLAN INTERVISION
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //lugar y dia, mes
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(30, 7);
                    $this->pdf->Cell(80, 8, $lugar_ . ', ' . $dia . ' de ' . $mes . ' de ' . $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(110, 7, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(22, 13);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(20, 19);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();

                    $this->pdf->boletaPDF('I');
                    break;

                case 19:
                    //Cheque Voucher
                    //CUSCATLAN MAYA COUNTRY
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //Dia
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(77, 16);
                    $this->pdf->Cell(80, 8, $lugar_ . ', ' . $dia . ' de ' . $mes . ' de ' . $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(155, 16, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(55, 24);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(50, 32);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();

                    $this->pdf->boletaPDF('I');
                    break;

                case 20:
                    //Cheque Voucher
                    //BANCO CITI ESPUMAR
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //lugar y dia, mes
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(40, 13);
                    $this->pdf->Cell(80, 8, $lugar_ . ', ' . $dia . ' de ' . $mes . ' de ' . $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(155, 13, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(50, 22);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(50, 30);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();

                    $this->pdf->boletaPDF('I');
                    break;

                case 21:
                    //Cheque Voucher
                    //PROMERICA ESPUMAR
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //Dia Mes
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(85, 15);
                    $this->pdf->Cell(80, 8, $lugar_ . ', ' . $dia . ' de ' . $mes . ' de ' . $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(155, 15, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(50, 22);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(50, 30);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();

                    $this->pdf->boletaPDF('I');
                    break;

                case 22:
                    //Cheque Voucher
                    //PROMERICA MAYA COUNTRY
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));


                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //Dia
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(77, 15);
                    $this->pdf->Cell(80, 8, $lugar_ . ', ' . $dia . ' de ' . $mes . ' de ' . $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(155, 16, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(50, 23);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(50, 31);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();

                    $this->pdf->boletaPDF('I');
                    break;

                case 23:
                    //Cheque Voucher
                    //BAC CENTRO CULTURAL SALVADOREÑO Con S.S.
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    /* *************** TAMANO DE LA PAGINA ********************** */
                    /* Formato que estaba antes: array(170, 215) */
                    $formato = "170,216";
                    $formato_array = explode(",", $formato); //convierte el formato a array por si se quiere un formato personalizado de pagina
                    $formato = (count($formato_array) > 1) ? $formato_array : $formato;
                    /* ********************************************************** */

                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', $formato, array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));

                    /* ********************** Colocar Border a la pagina ******************************* */
                    // $this->pdf->SetLineStyle( array( 'width' => 2, 'color' => array(0,0,0)));
                    // $this->pdf->Line(0,0,$this->pdf->getPageWidth(),0);
                    // $this->pdf->Line($this->pdf->getPageWidth(),0,$this->pdf->getPageWidth(),$this->pdf->getPageHeight());
                    // $this->pdf->Line(0,$this->pdf->getPageHeight(),$this->pdf->getPageWidth(),$this->pdf->getPageHeight());
                    // $this->pdf->Line(0,0,0,$this->pdf->getPageHeight());
                    /* ********************************************************************************** */

                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];


                    $this->pdf->SetFont('helvetica', 'B', 7);
                    // Ubicacion S.S.
                    $this->pdf->SetXY(65, 14);
                    $this->pdf->Cell(80, 8, $lugar_ . ',', $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //lugar y dia
                    $this->pdf->SetXY(75, 14);
                    $this->pdf->Cell(80, 8, $dia, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Mes
                    $this->pdf->SetXY(95, 14);
                    $this->pdf->Cell(80, 8, $mes, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Anio
                    $this->pdf->SetXY(120, 14);
                    $this->pdf->Cell(80, 8, $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(140, 14, true);
                    $this->pdf->Cell(33, 8, '**** ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(45, 23);
                    $this->pdf->Cell(140, 8, '*** ' . strtoupper($cheque->che_orden) . ' ***', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(45, 32);
                    $this->pdf->Cell(140, 8, '*** ' . strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/ . ' ***', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();

                    $this->pdf->boletaPDF('I');
                    break;
                case 24:
                    //FORMATO DE IMPRESION DE CHEQUE PARA KEYSI
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();

                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(2, 13, 0, 0);
                    $this->pdf->SetAutoPageBreak(FALSE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 6
                    ));

                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');


                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' DE ' . $meses[(int) $date[1]]; //. ' DE ' . $date[0];
                    $fecha = strtoupper($fecha);
                    $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                    $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //fecha
                    $this->pdf->SetFont('helvetica', 'B', 7);
                    $this->pdf->SetXY(35, 4);
                    $this->pdf->Cell(0, 8, $lugar_ . ', ' . $fecha, $borde, 0, '', false, '', 3, false, 'T', 'B');
                    $this->pdf->SetXY(90, 4);
                    $this->pdf->Cell(0, 8, $date[0], $borde, 0, '', false, '', 3, false, 'T', 'B');
                    //monto
                    $this->pdf->SetXY(115, 4, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(25, 10);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');
                    //textMonto
                    $this->pdf->SetXY(25, 17);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/, $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    /*
                    $this->pdf->SetXY(10, 70);
                    $this->pdf->Cell(75, 8, 'RENTA RETENIDO $ ' . number_format($cheque->che_renta_monto, 2), $borde, 0, '', false, '', 3, false, 'T', 'M');
                    $this->pdf->SetXY(85, 70);
                    $this->pdf->Cell(75, 8, 'IVA RETENIDO   $ ' . number_format($cheque->che_iva_monto, 2), $borde, 0, '', false, '', 3, false, 'T', 'M');*/
                    //$this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);



                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    // $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();
                    $this->pdf->setPrintFooter(false);
                    $this->pdf->boletaPDF('I');
                    break;
                case 25:
                    $this->load->library('EnLetras');
                    $data['cheque'] = $this->db->get_where('che_cheque', array('che_id' => $che_id))->result_array();
                    $cub            = $this->gsatelite->get_campo('che_cheque', 'che_id_chq', array('che_id' => $che_id));
                    $chq            = $this->gsatelite->get_campo('chq_chequera', 'chq_id_cub', array('chq_id' => $cub));
                    $data['cuenta'] = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_numero', array('cub_id' => $chq));

                    $this->load->library('pdf');
                    $html           = $this->load->view('utm/cuentas/cheque_cuscatlan', $data, true);
                    $this->pdf->addPagina($html, 'P');
                    $this->pdf->boletaPDF('I');
                    break;

                case 26:
                    //BANCO AZUL RAMATER
                    $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();
                    $this->load->library('pdf');
                    $this->load->library('texto');

                    $borde = 0;
                    $this->pdf->SetFont('helveticaB');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(TRUE, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', array(170, 215), array(
                        'family' => 'helveticaB',
                        'style' => '',
                        'size' => 7
                    ));

                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');

                    $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $date = explode('-', $cheque->che_fecha);
                    $fecha = $date[2] . ' DE ' . strtoupper($meses[(int) $date[1]]) . ' DE ' . $date[0];
                    $fecha = strtoupper($fecha);

                    $monto = explode('.', number_format($cheque->che_monto, 2, '.', ''));
                    $centativos = $cheque->che_monto - (int) $cheque->che_monto;
                    $centavos = ($monto[1] > 0) ? ' CON ' . $monto[1] . '/100' : ' CON 00/100';
                    $valor_letras = $this->texto->ValorEnLetras($monto[0]);
                    $valor_letras .=  $centavos;

                    $array_fecha = explode('DE', $fecha);
                    $dia = $array_fecha[0];
                    $mes = $array_fecha[1];
                    $anio = $array_fecha[2];

                    //LUGAR Y FECHA
                    $this->pdf->SetFont('helvetica', '', 8);
                    $this->pdf->SetXY(35, 13);
                    $this->pdf->Cell(80, 8, strtoupper($lugar_) . ', ' . $fecha, $borde, 0, '', false, '', 3, false, 'T', 'B');

                    //Monto
                    $this->pdf->SetXY(123, 13, true);
                    $this->pdf->Cell(33, 8, ' ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //AlaOrden
                    $this->pdf->SetXY(38, 22);
                    $this->pdf->Cell(140, 8, strtoupper($cheque->che_orden), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //textMonto
                    $this->pdf->SetXY(23, 27);
                    $this->pdf->Cell(140, 8, strtoupper($valor_letras), $borde, 0, '', false, '', 0, false, 'T', 'B');

                    //detalle
                    if (!isset($cheque->che_iva_monto)) {
                        $cheque->che_iva_monto = 0.0;
                    }
                    //pie
                    $this->pdf->SetXY(5, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(43, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(81, -15);
                    $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');

                    $this->pdf->SetXY(-10, -20);
                    $this->pdf->StartTransform();
                    $this->pdf->Rotate(90);
                    // $this->pdf->Cell(100, 0, $cheque->che_id . '.' . $cheque->che_id_chq . '.' . $cheque->che_numero, $borde);
                    $this->pdf->StopTransform();
                    $this->pdf->setPrintFooter(false); //
                    $this->pdf->boletaPDF('I');
                    break;

                default:

                    //Voucher Chalate

                    $this->load->library('pdf');
                    $html = $this->load->view('utm/cuentas/che_voucher', $data, true);
                    //die($html);
                    $this->pdf->addPagina($html, 'P');

                    $this->pdf->boletaPDF('I');
            }
        }
    }

    function voucher($che_id = 0)
    {
        if ($che_id > 0) {
            $this->db->select('*,dch_detalle_cheque.dch_id As dch_id');
            $detalle = $this->db->get_where('dch_detalle_cheque', array('dch_id_che' => $che_id))->result_array();
            // Configuracion para la cuenta contable de la cuenta bancaria
            $tcn_id     = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('BANCOS'));
            $consultar  = $this->gsatelite->get_tabla('tcn_tipo_cuenta', array('tcn_id' => $tcn_id, 'tcn_estado' => 1));
            $tcn_id     = (count($consultar) > 0) ? $tcn_id : null;
            $form = $this->db->query('
            Select *,
              che_cheque.che_id                 As che_id,
              ban_banco.ban_nombre              As banco,
              cub_cuenta_bancaria.cub_numero    As cuenta,
              cub_cuenta_bancaria.cub_nombre    As cuenta_nombre,
              che_cheque.che_numero             As cheque,
              che_cheque.che_concepto           As concepto,
              che_cheque.che_monto              As monto,
              (
                SELECT cnt_cuenta FROM cxb_cuentaxcuenta_bancaria
                JOIN cnt_cuenta_contable ON cnt_id = cxb_id_cnt
                WHERE cxb_id_cub = cub_id AND cxb_id_tcn = ' . $tcn_id . '
              )  As cuenta_contable
            From
              ban_banco
              Inner Join cub_cuenta_bancaria    On cub_cuenta_bancaria.cub_id_ban   = ban_banco.ban_id
              Inner Join chq_chequera           On chq_chequera.chq_id_cub          = cub_cuenta_bancaria.cub_id
              Inner Join che_cheque             On che_cheque.che_id_chq            = chq_chequera.chq_id
              Inner Join dch_detalle_cheque     On dch_detalle_cheque.dch_id_che    = che_cheque.che_id
              Left Join dpv_documento_proveedor On dpv_documento_proveedor.dpv_id   = dch_detalle_cheque.dch_id_dpv
            Where
              che_cheque.che_id = ' . $che_id . '
                        ')->row();
            $proveed    = $form->che_id_prv;
            $data_prv   = array();
            if ($proveed != null) {
                $data_prv = $this->db->query('select * from prv_proveedor where prv_id=' . $proveed)->row_array();
            }
            // Obtener el usuario que creo el cheque
            $che_user   = $this->gsatelite->get_campo('che_cheque', 'che_usu_crea', array('che_id' => $che_id));
            $user       = $this->gsatelite->get_campo('users', 'username', array('id' => $che_user));
            // Cuenta por defecto si no se ha asignado ninguna
            $cnt_defecto    = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
            $defecto_cnt    = $this->gsatelite->get_campo('cnt_cuenta_contable', 'cnt_cuenta', array('cnt_id' => $cnt_defecto, 'cnt_estado' => 1));
            $che_retencion = $this->utm_model->get_detalle_cheque(array('dch_id_che' => $che_id));
            $data = array(
                'banco'           => $form->banco, 'cuenta'          => $form->cuenta, 'cuenta_nombre'   => $form->cuenta_nombre, 'cheque'          => $form->cheque, 'concepto'        => $form->concepto, 'renta'           => $form->che_renta, 'valor_servicio'  => $form->che_monto, 'monto_sujeto_retencion' => $form->che_monto_suj, 'valor_renta'     => $form->che_renta_monto, 'che_orden'       => $form->che_orden, 'nit'             => $data_prv['prv_nit'], 'form'            => $form, 'detalle'         => $detalle, 'che_usu_crea'    => $user, 'cuenta_contable' => ($form->cuenta_contable != '' || $form->cuenta_contable != null) ? $form->cuenta_contable : $defecto_cnt, 'che_retencion'   => $che_retencion, 'num_dpv'         => $form->dpv_numero_documento
                // , 'creo' => $history['Creado']->username . ': ' . $history['Creado']->fecha
                // , 'autorizo' => $history['Firmado']->username . ': ' . $history['Creado']->fecha
            );
            // var_dump($form->chq_tipo);die();
            // Buscar archivo en la tabla frq
            $fr_cheque = $this->gsatelite->get_tabla('frq_formato_cheque', array('frq_tipo' => $form->chq_tipo, 'frq_id_ban' => $form->ban_id, 'frq_activo' => 1, 'frq_estado' => 1));
            // var_dump($fr_cheque);die();
            if (!(empty($fr_cheque))) {
                $this->load->library('pdf');
                $this->load->library('EnLetras');
                $data['cheque'] = $this->db->get_where('che_cheque', array('che_id' => $che_id))->result_array();
                $cub = $this->gsatelite->get_campo('che_cheque', 'che_id_chq', array('che_id' => $che_id));
                $chq = $this->gsatelite->get_campo('chq_chequera', 'chq_id_cub', array('chq_id' => $cub));
                $data['cuenta'] = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_numero', array('cub_id' => $chq));
                $data['voucher'] = $this->contabilidad_model->get_detalle_partida($form->che_id_pct);
                $html = $this->load->view('utm/cuentas/' . $fr_cheque[0]['frq_archivo'], $data, true);
                $this->pdf->SetMargins(10, 0, 5);
                $this->pdf->addPagina($html, 'P');
                $this->pdf->boletaPDF('I');
                die();
                //Si no encontro nada en la frq hace el switch
            } else {
                switch ($form->chq_tipo) {
                    case 1:
                        $this->load->library('EnLetras');
                        $this->load->library('pdf');
                        $this->load->library('texto');
                        $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();
                        $data['date'] = explode('-', $cheque->che_fecha);
                        $data['defecto_cnt_nom'] = $defecto_cnt_nom;
                        $data['voucher'] = $this->contabilidad_model->get_detalle_partida($form->che_id_pct);
                        $this->pdf->SetFont('Calibri', 'B', 9);
                        $this->pdf->AddPage('P', 'LETTER');
                        $this->pdf->SetMargins(0, 0, 0);
                        $this->pdf->SetAutoPageBreak(FALSE, 0);
                        $this->pdf->setCellPaddings(0, 0, 0, 0);
                        $this->pdf->setPrintFooter(false);
                        $this->pdf->SetXY(0, 0, true);
                        $html  = $this->load->view('utm/cuentas/voucher', $data, true);
                        $this->pdf->writeHTML($html, true, false, false, false, '');
                        $this->pdf->boletaPDF('I');
                        break;
                    case 2: //Voucher                                    
                        $this->load->library('EnLetras');
                        $data['cheque'] = $this->db->get_where('che_cheque', array('che_id' => $che_id))->result_array();
                        $cub            = $this->gsatelite->get_campo('che_cheque', 'che_id_chq', array('che_id' => $che_id));
                        $chq            = $this->gsatelite->get_campo('chq_chequera', 'chq_id_cub', array('chq_id' => $cub));
                        $data['cuenta'] = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_numero', array('cub_id' => $chq));
                        $data['voucher'] = $this->contabilidad_model->get_detalle_partida($form->che_id_pct);
                        $this->load->library('pdf');
                        $html           = $this->load->view('utm/cuentas/voucher_banco_hipotecario', $data, true);
                        ////////////////// configuracion de pagina
                        $fuente             = "calibrib";
                        $size               = 8;
                        $formato            = "Letter";
                        $formato_array      = explode(",", $formato); //convierte el formato a array por si se quiere un formato personalizado de pagina
                        $formato            = (count($formato_array) > 1) ? $formato_array : $formato; //si tiene mas de un elemento se toma el array y si no el valor del formato
                        $orientacion        = "P";
                        $margins            = "0,0,0";
                        $setCellPaddings    = "0,0,0";
                        $this->pdf->setPrintHeader(false);
                        $this->pdf->SetFont($fuente);
                        $this->pdf->setCellPaddings($setCellPaddings);
                        $this->pdf->SetAutoPageBreak(true, 0);
                        $this->pdf->SetMargins($margins); //274, 155
                        $this->pdf->AddPage(
                            $orientacion,
                            $formato,
                            array(
                                'family' => $fuente,
                                'style' => '',
                                'size' => $size
                            )
                        );
                        //////////////////
                        $this->pdf->setPrintFooter(false);
                        $this->pdf->writeHTML($html, true, false, false, false, '');
                        $this->pdf->boletaPDF('I');
                        break;
                    case 9: // cheque voucher de Centro cultural
                        //Cheque Voucher
                        //BAC CENTRO CULTURAL SALVADOREÑO 
                        $cheque = $this->db->get_where('che_cheque', array('che_id' => $che_id), 1)->row();
                        $this->load->library('pdf');
                        $this->load->library('texto');
                        $borde = 0;
                        /* *************** TAMANO DE LA PAGINA ********************** */
                        /* Formato que estaba antes: array(170, 215) */
                        $formato = "170,216";
                        $formato_array = explode(",", $formato); //convierte el formato a array por si se quiere un formato personalizado de pagina
                        $formato = (count($formato_array) > 1) ? $formato_array : $formato;
                        /* ********************************************************** */
                        $this->pdf->SetFont('helveticaB');
                        $this->pdf->setCellPaddings(0, 0, 0, 0);
                        $this->pdf->SetAutoPageBreak(TRUE, 0);
                        $this->pdf->SetMargins(10, 0, 5);
                        $this->pdf->AddPage('P', $formato, array(
                            'family' => 'helveticaB',
                            'style' => '',
                            'size' => 6
                        ));
                        /* ********************** Colocar Border a la pagina ******************************* */
                        // $this->pdf->SetLineStyle( array( 'width' => 2, 'color' => array(0,0,0)));
                        // $this->pdf->Line(0,0,$this->pdf->getPageWidth(),0);
                        // $this->pdf->Line($this->pdf->getPageWidth(),0,$this->pdf->getPageWidth(),$this->pdf->getPageHeight());
                        // $this->pdf->Line(0,$this->pdf->getPageHeight(),$this->pdf->getPageWidth(),$this->pdf->getPageHeight());
                        // $this->pdf->Line(0,0,0,$this->pdf->getPageHeight());
                        /* ********************************************************************************** */
                        $this->pdf->SetXY(0.2, 0.2, true);
                        $this->pdf->Cell(169.6, 214.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                        $meses = array(1 => 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                        $date = explode('-', $cheque->che_fecha);
                        $fecha = $date[2] . ' de ' . $meses[(int) $date[1]] . ' de ' . $date[0];
                        $fecha = strtoupper($fecha);
                        $centavos = ' ' . ($cheque->che_monto - (int) $cheque->che_monto) . '/100';
                        $valor_letras = $this->texto->ValorEnLetras($cheque->che_monto);
                        $array_fecha = explode('DE', $fecha);
                        $dia = $array_fecha[0];
                        $mes = $array_fecha[1];
                        $anio = $array_fecha[2];
                        $this->pdf->SetFont('helvetica', 'B', 7);
                        // Ubicacion S.S.
                        //$this->pdf->SetXY(65, 14);
                        //$this->pdf->Cell(80, 8, 'SS,', $borde, 0, '', false, '', 3, false, 'T', 'B');
                        //lugar y dia
                        $this->pdf->SetXY(75, 14);
                        $this->pdf->Cell(80, 8, $dia, $borde, 0, '', false, '', 3, false, 'T', 'B');
                        //Mes
                        $this->pdf->SetXY(95, 14);
                        $this->pdf->Cell(80, 8, $mes, $borde, 0, '', false, '', 3, false, 'T', 'B');
                        //Anio
                        $this->pdf->SetXY(120, 14);
                        $this->pdf->Cell(80, 8, $anio, $borde, 0, '', false, '', 3, false, 'T', 'B');
                        //Monto
                        $this->pdf->SetXY(140, 14, true);
                        $this->pdf->Cell(33, 8, '**** ' . strtoupper(number_format($cheque->che_monto, 2)), $borde, 0, '', false, '', 0, false, 'T', 'B');
                        //AlaOrden
                        $this->pdf->SetXY(45, 23);
                        $this->pdf->Cell(140, 8, '*** ' . strtoupper($cheque->che_orden) . ' ***', $borde, 0, '', false, '', 0, false, 'T', 'B');
                        //textMonto
                        $this->pdf->SetXY(45, 32);
                        $this->pdf->Cell(140, 8, '*** ' . strtoupper($valor_letras)/*$this->texto->ValorEnLetras((int) $cheque->che_monto, '')) . $centavos*/ . ' ***', $borde, 0, '', false, '', 0, false, 'T', 'B');
                        // Detalle del Boucher
                        //Debe
                        $this->pdf->SetXY(90, 90);
                        $this->pdf->Cell(140, 8, 'DEBE', $borde, 0, '', false, '', 0, false, 'T', 'B');
                        //Haber
                        $this->pdf->SetXY(120, 90);
                        $this->pdf->Cell(140, 8, 'HABER', $borde, 0, '', false, '', 0, false, 'T', 'B');
                        //Por
                        //Haber
                        $this->pdf->SetXY(140, 90);
                        $this->pdf->Cell(140, 8, 'POR ' . $cheque->che_monto, $borde, 0, '', false, '', 0, false, 'T', 'B');
                        //Orden
                        $this->pdf->SetXY(10, 100);
                        $this->pdf->Cell(140, 8, $cheque->che_orden, $borde, 0, '', false, '', 0, false, 'T', 'B');
                        //Orden
                        $this->pdf->SetXY(90, 100);
                        $this->pdf->Cell(140, 8, $cheque->che_monto, $borde, 0, '', false, '', 0, false, 'T', 'B');
                        $cub            = $this->gsatelite->get_campo('che_cheque', 'che_id_chq', array('che_id' => $cheque->che_id));
                        $chq            = $this->gsatelite->get_campo('chq_chequera', 'chq_id_cub', array('chq_id' => $cub));
                        $cuenta         = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_numero', array('cub_id' => $chq));
                        //Cuenta
                        $this->pdf->SetXY(10, 105);
                        $this->pdf->Cell(140, 8, 'Codigo.Cta. N ' . $cuenta, $borde, 0, '', false, '', 0, false, 'T', 'B');
                        //Banco
                        $this->pdf->SetXY(10, 115);
                        $this->pdf->Cell(140, 8, $data['banco'], $borde, 0, '', false, '', 0, false, 'T', 'B');
                        //Haber monto
                        $this->pdf->SetXY(120, 115);
                        $this->pdf->Cell(140, 8, $cheque->che_monto, $borde, 0, '', false, '', 0, false, 'T', 'B');
                        //Balance
                        $this->pdf->SetXY(10, 122);
                        $this->pdf->Cell(140, 8, 'Balance', $borde, 0, '', false, '', 0, false, 'T', 'B');
                        //Balance
                        $this->pdf->SetXY(90, 125);
                        $this->pdf->Cell(140, 8, $cheque->che_monto, $borde, 0, '', false, '', 0, false, 'T', 'B');
                        //Balance
                        $this->pdf->SetXY(120, 125);
                        $this->pdf->Cell(140, 8, $cheque->che_monto, $borde, 0, '', false, '', 0, false, 'T', 'B');
                        if (!isset($cheque->che_iva_monto)) {
                            $cheque->che_iva_monto = 0.0;
                        }
                        $this->pdf->writeHTMLCell(150, 92, 10, 108, $cheque->che_concepto, $borde);
                        //pie
                        $this->pdf->setPrintFooter(false);
                        $this->pdf->SetXY(5, -15);
                        $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                        $this->pdf->SetXY(43, -15);
                        $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                        $this->pdf->SetXY(81, -15);
                        $this->pdf->Cell(35, 8, '', $borde, 0, '', false, '', 0, false, 'T', 'B');
                        $this->pdf->boletaPDF('I');
                        break;
                    case 14: //|| 17 || 19 || 22: 
                    case 17:
                    case 19:
                    case 22:
                        $this->load->library('EnLetras');
                        $data['cheque'] = $this->db->get_where('che_cheque', array('che_id' => $che_id))->result_array();
                        $cub            = $this->gsatelite->get_campo('che_cheque', 'che_id_chq', array('che_id' => $che_id));
                        $chq            = $this->gsatelite->get_campo('chq_chequera', 'chq_id_cub', array('chq_id' => $cub));
                        $data['cuenta'] = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_numero', array('cub_id' => $chq));
                        $this->load->library('pdf');
                        $html           = $this->load->view('utm/cuentas/voucher_scotiabank', $data, true);
                        ////////////////// configuracion de pagina
                        $fuente             = "calibrib";
                        $size               = 8;
                        $formato            = "Letter";
                        $formato_array      = explode(",", $formato); //convierte el formato a array por si se quiere un formato personalizado de pagina
                        $formato            = (count($formato_array) > 1) ? $formato_array : $formato; //si tiene mas de un elemento se toma el array y si no el valor del formato
                        $orientacion        = "P";
                        $margins            = "0,0,0";
                        $setCellPaddings    = "0,0,0";
                        $this->pdf->setPrintHeader(false);
                        $this->pdf->SetFont($fuente);
                        $this->pdf->setCellPaddings($setCellPaddings);
                        $this->pdf->SetAutoPageBreak(true, 0);
                        $this->pdf->SetMargins($margins); //274, 155
                        $this->pdf->AddPage(
                            $orientacion,
                            $formato,
                            array(
                                'family' => $fuente,
                                'style' => '',
                                'size' => $size
                            )
                        );
                        //////////////////
                        $this->pdf->setPrintFooter(false);
                        $this->pdf->writeHTML($html, true, false, false, false, '');
                        $this->pdf->boletaPDF('I');
                        break;
                    case '24': //Voucher Agricola Keysi                    
                        $this->load->library('EnLetras');
                        $data['cheque'] = $this->db->get_where('che_cheque', array('che_id' => $che_id))->result_array();
                        $cub            = $this->gsatelite->get_campo('che_cheque', 'che_id_chq', array('che_id' => $che_id));
                        $chq            = $this->gsatelite->get_campo('chq_chequera', 'chq_id_cub', array('chq_id' => $cub));
                        $data['cuenta'] = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_numero', array('cub_id' => $chq));
                        $this->load->library('pdf');
                        $html           = $this->load->view('utm/cuentas/voucher_agricola', $data, true);
                        $this->pdf->addPagina($html, 'P');
                        $this->pdf->boletaPDF('I');
                        break;
                    case '25': //Voucher Cuscatlan ASI
                        $this->load->library('EnLetras');
                        $data['cheque'] = $this->db->get_where('che_cheque', array('che_id' => $che_id))->result_array();
                        $cub            = $this->gsatelite->get_campo('che_cheque', 'che_id_chq', array('che_id' => $che_id));
                        $chq            = $this->gsatelite->get_campo('chq_chequera', 'chq_id_cub', array('chq_id' => $cub));
                        $data['cuenta'] = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_numero', array('cub_id' => $chq));
                        $this->load->library('pdf');
                        $html           = $this->load->view('utm/cuentas/voucher_cuscatlan', $data, true);
                        $this->pdf->addPagina($html, 'P');
                        $this->pdf->boletaPDF('I');
                        break;
                    default:
                        $this->load->library('EnLetras');
                        $data['cheque'] = $this->db->get_where('che_cheque', array('che_id' => $che_id))->result_array();
                        $cub            = $this->gsatelite->get_campo('che_cheque', 'che_id_chq', array('che_id' => $che_id));
                        $chq            = $this->gsatelite->get_campo('chq_chequera', 'chq_id_cub', array('chq_id' => $cub));
                        $data['cuenta'] = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_numero', array('cub_id' => $chq));
                        $data['voucher'] = $this->contabilidad_model->get_detalle_partida($form->che_id_pct);
                        $this->load->library('pdf');
                        $html           = $this->load->view('utm/cuentas/voucher_scotiabank', $data, true);
                        $this->pdf->addPagina($html, 'P');
                        $this->pdf->boletaPDF('I');
                        break;
                }
            }
        }
    }

    function certificacion($che_id = 0)
    {
        if ($che_id > 0) {
            $this->db->select('*,
              dch_detalle_cheque.dch_id As dch_id
            ');
            //$this->db->join('cpr_cuenta_presupuesto', 'dch_id_cpr = cpr_id', 'left');
            $detalle = $this->db->get_where('dch_detalle_cheque', array('dch_id_che' => $che_id))->result();

            $form = $this->db->query('
            Select *,
              che_cheque.che_id As che_id,
              ban_banco.ban_nombre As banco,
              cub_cuenta_bancaria.cub_numero As cuenta,
              cub_cuenta_bancaria.cub_nombre As cuenta_nombre,
              che_cheque.che_numero As cheque,
              che_cheque.che_concepto As concepto,
              che_cheque.che_monto as monto
            From
              ban_banco
              Inner Join cub_cuenta_bancaria On cub_cuenta_bancaria.cub_id_ban = ban_banco.ban_id
              Inner Join chq_chequera On chq_chequera.chq_id_cub = cub_cuenta_bancaria.cub_id
              Inner Join che_cheque On che_cheque.che_id_chq = chq_chequera.chq_id
            Where
              che_cheque.che_id = ' . $che_id . '
                        ')->row();
            // $che = new Procesos();
            // $historico = $che->get_historico(1, $che_id);
            // $history = array();
            // foreach($historico as $row){
            //     $history[$row->paso] = $row;
            // }
            //print_r($historico); die();
            $proveed = $form->che_id_prv;
            $data_prv = array();
            if ($proveed != null) {
                $data_prv = $this->db->query('select * from prv_proveedor where prv_id=' . $proveed)->row_array();
            }

            $data = array(
                'banco' => $form->banco, 'cuenta' => $form->cuenta, 'cuenta_nombre' => $form->cuenta_nombre, 'cheque' => $form->cheque, 'concepto' => $form->concepto, 'renta' => $form->che_renta, 'valor_servicio' => $form->che_monto, 'monto_sujeto_retencion' => $form->che_monto_suj, 'valor_renta' => $form->che_renta_monto, 'che_orden' => $form->che_orden, 'nit' => $data_prv['prv_nit'], 'form' => $form, 'detalle' => $detalle
                // , 'creo' => $history['Creado']->username . ': ' . $history['Creado']->fecha
                //, 'autorizo' => $history['Firmado']->username . ': ' . $history['Creado']->fecha
            );


            //forma de impresion
            switch ($form->chq_tipo) {
                default:
                    $this->load->library('EnLetras');
                    $data['nombre_cuenta'] = $form->cuenta_nombre;
                    $data['cheque'] = $this->db->get_where('che_cheque', array('che_id' => $che_id))->result_array();
                    $cub = $this->gsatelite->get_campo('che_cheque', 'che_id_chq', array('che_id' => $che_id));
                    $chq = $this->gsatelite->get_campo('chq_chequera', 'chq_id_cub', array('chq_id' => $cub));
                    $data['cuenta'] = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_numero', array('cub_id' => $chq));
                    //echo json_encode($data['cheque']);
                    //echo json_encode($data['cuenta']);
                    //exit();
                    $this->load->library('pdf');
                    $html = $this->load->view('utm/cuentas/certificacion_scotiabank', $data, true);
                    $this->pdf->addPagina($html, 'P');

                    $this->pdf->boletaPDF('I');
                    break;
            }
        }
    }

    function remesa($che_id = 0)
    {
        if ($che_id > 0) {
            $this->db->select('*,
              dch_detalle_cheque.dch_id As dch_id
            ');
            //$this->db->join('cpr_cuenta_presupuesto', 'dch_id_cpr = cpr_id', 'left');
            $detalle = $this->db->get_where('dch_detalle_cheque', array('dch_id_che' => $che_id))->result();

            $form = $this->db->query('
            Select *,
              che_cheque.che_id As che_id,
              ban_banco.ban_nombre As banco,
              cub_cuenta_bancaria.cub_numero As cuenta,
              cub_cuenta_bancaria.cub_nombre As cuenta_nombre,
              che_cheque.che_numero As cheque,
              che_cheque.che_concepto As concepto,
              che_cheque.che_monto as monto
            From
              ban_banco
              Inner Join cub_cuenta_bancaria On cub_cuenta_bancaria.cub_id_ban = ban_banco.ban_id
              Inner Join chq_chequera On chq_chequera.chq_id_cub = cub_cuenta_bancaria.cub_id
              Inner Join che_cheque On che_cheque.che_id_chq = chq_chequera.chq_id
            Where
              che_cheque.che_id = ' . $che_id . '
                        ')->row();
            // $che = new Procesos();
            // $historico = $che->get_historico(1, $che_id);
            // $history = array();
            // foreach($historico as $row){
            //     $history[$row->paso] = $row;
            // }
            //print_r($historico); die();
            $proveed = $form->che_id_prv;
            $data_prv = array();
            if ($proveed != null) {
                $data_prv = $this->db->query('select * from prv_proveedor where prv_id=' . $proveed)->row_array();
            }
            $data = array(
                'banco' => $form->banco, 'cuenta' => $form->cuenta, 'cuenta_nombre' => $form->cuenta_nombre, 'cheque' => $form->cheque, 'concepto' => $form->concepto, 'renta' => $form->che_renta, 'valor_servicio' => $form->che_monto, 'monto_sujeto_retencion' => $form->che_monto_suj, 'valor_renta' => $form->che_renta_monto, 'che_orden' => $form->che_orden, 'nit' => $data_prv['prv_nit'], 'form' => $form, 'detalle' => $detalle
                // , 'creo' => $history['Creado']->username . ': ' . $history['Creado']->fecha
                //, 'autorizo' => $history['Firmado']->username . ': ' . $history['Creado']->fecha
            );


            //forma de impresion
            switch ($form->chq_tipo) {
                default:
                    $this->load->library('EnLetras');
                    $data['nombre_cuenta'] = $form->cuenta_nombre;
                    $data['cheque'] = $this->db->get_where('che_cheque', array('che_id' => $che_id))->result_array();
                    $cub = $this->gsatelite->get_campo('che_cheque', 'che_id_chq', array('che_id' => $che_id));
                    $chq = $this->gsatelite->get_campo('chq_chequera', 'chq_id_cub', array('chq_id' => $cub));
                    $data['cuenta'] = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_numero', array('cub_id' => $chq));
                    //echo json_encode($data['cheque']);
                    //echo json_encode($data['cuenta']);
                    //exit();
                    $this->load->library('pdf');
                    $html = $this->load->view('utm/cuentas/remesa_scotiabank', $data, true);
                    $this->pdf->addPagina($html, 'P');

                    $this->pdf->boletaPDF('I');
                    break;
            }
        }
    }

    /**
     * Cuentas::_cuenta_saldo()
     * @author Alexis Beltran
     *
     * @param mixed $value
     * @param mixed $row
     * @return
     */
    function _cuenta_saldo($value, $row)
    {

        $resultados = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $row->cub_id));
        $query = $this->db->select('saldo, tra_monto, cub_saldo_inicial, SUM(tra_monto) as suma')
            ->from('vw_cuentas_bancarias')
            ->join('tra_transaccion', 'vw_cuentas_bancarias.cub_id=tra_transaccion.tra_id_cub')
            ->join('cub_cuenta_bancaria', 'tra_id_cub=cub_cuenta_bancaria.cub_id')
            ->where('tra_id_cub', $row->cub_id)
            ->get();
        $transact = $query->row_array();
        $suma = $transact['suma'];
        $saldo_ini = $transact['cub_saldo_inicial'];
        if ($resultados->num_rows() > 0) {
            $saldo = $resultados->row()->saldo;
            $saldo = $resultados->row()->saldo;
            $saldo_minimo = $resultados->row()->saldo_minimo;
            if ($saldo_minimo > $saldo) {
                //$valor = $saldo_minimo; //NO ES FUNCIONAL
                $valor = $saldo_ini + $suma;
            } else {
                $valor = $saldo_ini + $suma;
            }
        } else {
            $valor = 'v2';
        }
        return $this->_format_money($valor);
    }

    function orden_compra_uaci()
    {
        $q_orden = $this->utm_model->get_orden_compra();
        $data['titulo_personal'] = 'Pagos de Orden de compra UACI';
        $data['registros'] = $q_orden;
        $this->_cargarvista($data);
    }

    function agregar_cheque_orden($id_pago = 0)
    {
        satelite_validar();
        $data['prv'] = $this->gsatelite->get_tabla('prv_proveedor');
        $this->gsatelite->get_tabla('che_cheque');
        $data['banco'] = $this->utm_model->get_banco();

        $registro = $this->utm_model->get_orden_compra(array('pag_id' => $id_pago));
        $data['registro_pago'] = $registro[0];
        $proveedor = $this->gsatelite->get_tabla('prv_proveedor', array('prv_codigo' => $registro[0]['prv_codigo']));
        if (!$proveedor) {
            $proveedor = $this->gsatelite->get_tabla('prv_proveedor', array('prv_nombre' => $registro[0]['prv_nombre']));
        }
        $data['proveedor_orc'] = $proveedor[0];
        $data['titulo_personal'] = 'Cheque de Orden de compra';
        $this->_cargarvista($data);
    }

    public function validar_num_cheque()
    {
        $id_chequera = $this->input->post('id_chequera');
        $numero = $this->input->post('numero');
        $rango = $this->utm_model->rango_num_cheq($id_chequera);
        $usados = $this->utm_model->num_usados_chequera($id_chequera);
        $ini = $rango[0]['chq_numero_inicio'];
        $fin = $ini + $rango[0]['chq_cantidad'] - 1;
        $resp = 0;
        if ($numero < $ini || $numero > $fin) {
            $resp = 1;
            echo json_encode(array('resp' => $resp));
            die();
        }
        foreach ($usados as $usa) {
            $usado = $usa['che_numero'];
            if ($numero == $usado) {
                $resp = 2;
                echo json_encode(array('resp' => $resp));
                die();
            }
        }
        echo json_encode(array('resp' => $resp));
    }

    public function cheques_pendientes()
    {

        $data['titulo_personal'] = "Cheques Pendientes";

        $where['chp_generado'] = 0;
        $where['chp_estado'] = 1;
        $where['date(chp_fecha) >='] = date('Y-m-d');
        $where['date(chp_fecha) <='] = date('Y-m-d');
        $data['txtFechaIni']  = date('d-m-Y');
        $data['txtFechaFin']  = date('d-m-Y');

        if (trim($this->input->post('txtFechaIni')) != '') {
            $data['txtFechaIni']  = $this->input->post('txtFechaIni');
            $where['date(chp_fecha) >='] = formatear_fecha('Y-m-d', $this->input->post('txtFechaIni'));
        }
        if (trim($this->input->post('txtFechaFin')) != '') {
            $data['txtFechaFin']  = $this->input->post('txtFechaFin');
            $where['date(chp_fecha) <='] = formatear_fecha('Y-m-d', $this->input->post('txtFechaFin'));
        }
        $data['cheques'] = $this->utm_model->get_cheques_pendientes($where);
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();;

        $this->_cargarvista($data);
    }

    public function anular_cheque_pendiente($chp_id, $agp)
    {
        $registro = $this->gsatelite->actualizar_array('chp_cheque_pendiente', array('chp_estado' => 0), array('chp_id' => $chp_id));
        $registro = $this->gsatelite->actualizar_array('agp_agenda_pago', array('agp_estado' => 0), array('agp_id' => $agp));

        if ($registro == 1) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cheque Pendiente Anulado", 'texto_alerta' => "Se anulo el cheque pendiente correctamente");
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "No se pudo eliminar la orden.");
        }

        $this->session->set_flashdata($alerta);
        redirect('utm/cuentas/cheques_pendientes');
    }

    public function get_factura_like()
    {
        $where     = null;
        $result    = "";
        $factura   = (trim($this->input->post('factura')) != "") ? $this->input->post('factura') : null;
        $proveedor = (trim($this->input->post('proveedor')) > 0) ? $this->input->post('proveedor') : "";

        if ($proveedor != "") {
            $where['dpv_id_prv'] = $proveedor;
            $where['dpv_pagado'] = 0;
        }

        $where['dpv_estado'] = 1;
        $result = array();
        $documentos = $this->utm_model->get_factura_like($factura, $where, 'dpv_id');

        if (count($documentos) > 0) {
            foreach ($documentos as $dpv) {
                if ($dpv['cheques_pendientes'] == 0) {
                    $result[] = $dpv;
                }
            }
        }

        echo json_encode($result);
    }

    public function get_datos_factura()
    {
        $id_factura = $this->input->post('id_factura');
        $result = $id_factura;
        $where['dpv_estado'] = 1;
        $where['dpv_id'] = $id_factura;

        $result = $this->utm_model->get_factura_like(null, $where);

        echo json_encode($result);
    }

    public function get_monto_pendiente()
    {
        $dpv_id = $this->input->post('documento');
        $result = $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_monto_pendiente', array('dpv_id' => $dpv_id));
        echo json_encode($result);
    }

    public function ver_cheque($cod_che = null)
    {
        satelite_validar();
        $data['prv'] = $this->gsatelite->get_tabla('prv_proveedor');
        $data['ace'] = $this->gsatelite->get_tabla('ace_actividad_especifica');
        $data['acg'] = $this->gsatelite->get_tabla('acg_actividad_general');
        $data['pcl'] = $this->gsatelite->get_tabla('pcl_proyecto_cliente');
        $data['psp'] = $this->gsatelite->get_tabla('psp_presupuesto');
        $data['datos'] = $this->gsatelite->get_tabla('che_cheque', array('che_id' => $cod_che));

        //detalle
        $where = null;
        $where['dch_id_che'] = $cod_che;
        $data['pagos'] = $this->utm_model->get_detalle_cheque($where);

        $data['id_cuenta'] = $this->gsatelite->get_campo('chq_chequera', 'chq_id_cub', array('chq_id' => $data['datos'][0]['che_id_chq']));
        $data['cuenta'] = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $data['id_cuenta']))->row_array();

        $id_ban = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_id_ban', array('cub_id' => $data['id_cuenta']));

        $data['banco'] = $this->gsatelite->get_campo('ban_banco', 'ban_nombre', array('ban_id' => $id_ban));
        $data['chequera'] = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_numero', array('cub_id' => $data['id_cuenta'])); //.$value['chq_numero']."-".$value['cub_numero']
        $data['chequera2'] = $this->gsatelite->get_campo('chq_chequera', 'chq_numero', array('chq_id' => $data['datos'][0]['che_id_chq']));
        $data['retencion'] = $this->gsatelite->get_tabla('ret_retencion');

        $data["titulo_personal"] = "Gestión Cheques";
        $this->_cargarvista($data);
    }

    public function ver_nota_abono($ntaid = 0)
    {
        satelite_validar();
        $detppal = $this->utm_model->get_notas_abono(array('nta_id' => $ntaid));
        $detrows = $this->utm_model->get_detalle_nota_abono(array('dna_id_nta' => $ntaid));
        $drp_ban = $this->gsatelite->get_dropdown('ban_banco', '{ban_nombre}', '', array('ban_estado' => 1), $dets[0]['cub_id_ban'], null, null, true);
        $drp_cta = $this->gsatelite->get_dropdown('cub_cuenta_bancaria', '{cub_numero} - {cub_nombre}', '', array('cub_estado' => 1), $dets[0]['cub_id'], null, null, true);
        $drp_prv = $this->gsatelite->get_dropdown('prv_proveedor', "[CASE WHEN prv_tipo_pers = 1 THEN CONCAT_WS(' ',prv_codigo, '-' ,prv_nombre,prv_apellido)ELSE CONCAT_WS(' ',prv_codigo, '-' ,prv_nombre) END]", '', array('prv_estado' => 1), $dets[0]['nta_id_prv'], null, null, true);
        $data['bancos'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $drp_ban);
        $data['cuentas'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $drp_cta);
        $data['proveedores'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $drp_prv);
        $data['det_rows'] = $detrows;
        $data['detalles'] = $detppal;
        $data['titulo_personal'] = "Ver Transferencia Bancaria";
        $this->_cargarvista($data);
    }

    function comprobante_transferencias($id)
    {
        $data['nota_abo'] = $this->utm_model->get_notas_abono(array('nta_id' => $id));
        $data['detalles'] = $this->utm_model->get_detalle_nota_abono(array('dna_id_nta' => $id));

        $this->db->join('dpc_detalle_partida ', 'dpc_id_pct = pct_id');
        $this->db->join('cnt_cuenta_contable ', 'cnt_id = dpc_id_cnt');
        $data['partidas'] = $this->gsatelite->get_tabla('pct_partida_contable', array('pct_id' => $data['nota_abo'][0]['nta_id_pct']));
        $data['dep_empresa'] = $this->gsatelite->get_parametro('SYS_DEPARTAMENTO');
        $data['empresa'] = $this->gsatelite->get_parametro('SYS_EMPRESA');
        $data['logo'] = $this->gsatelite->get_parametro('SYS_LOGOTIPO');
        $html = $this->load->view('utm/cuentas/detalle_comprobante_nota_abono', $data, true);
        $this->load->library('pdf');
        $this->pdf->makePDF($html, 'P');
    }

    public function _callback_webpage_url($value, $row)
    {
        return "<a href='" . site_url('admin/sub_webpages/' . $row->id) . "'>$value</a>";
    }

    public function aplicar_cheque($id_cheque = NULL)
    {
        $data['cheque'] = $this->gsatelite->get_registro('che_cheque', array('che_id' => $id_cheque));
        $data['chequera'] = $this->gsatelite->get_registro('chq_chequera', array('chq_id' => $data['cheque']->che_id_chq));
        $data['detalle_cuenta'] = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $data['chequera']->chq_id_cub))->row_array();

        $this->db->join('tra_transaccion', 'tra_id = che_id_tra');
        $data['aplicado'] = $this->gsatelite->get_tabla('che_cheque', array('che_id' => $id_cheque));
        //DETALLES DEL CHEQUE
        $where = null;
        $where['dch_id_che'] = $id_cheque;
        $data['pagos'] = $this->utm_model->get_detalle_cheque($where);

        $html = $this->load->view('utm/cuentas/aplicar_cheque', $data, true);
        die($html);
    }

    public function aplicar_transaccion_cheque($id_cheque = NULL)
    {
        $cheque = $this->gsatelite->get_tabla('che_cheque', array('che_id' => $id_cheque));


        //=================================//
        //==  GENERAR PARTIDA CONTABLE   ==//
        //=================================//
        // $permite_generar = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_BANCO');
        // if ($permite_generar == 1 and $id_cheque > 0) {
        //     // Generar partida de planilla
        //     $this->partida_contable_cheque($id_cheque);
        // }
        //alicar la transacción

        $array_tra = array(
            'tra_fecha_mod' => date("Y-m-d H:i:s"),
            'tra_usu_mod' => $this->tank_auth->get_user_id(),
            'tra_aplicar' => 1
        );
        $this->gsatelite->actualizar_array('tra_transaccion', $array_tra, array('tra_id' => $cheque[0]['che_id_tra']));
        //aplicar documento proveedor
        $detalle_cheque = $this->gsatelite->get_tabla('dch_detalle_cheque', array('dch_id_che' => $cheque[0]['che_id']));

        foreach ($detalle_cheque as $det) {
            if ($det['dch_id_dpv'] != null) {
                $documento_factura = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id' => $det['dch_id_dpv']));

                $nuevo_monto_pendiente = $documento_factura[0]['dpv_monto_pendiente'] - $det['dch_valor'];
                $nuevo_abono = $documento_factura[0]['dpv_monto_abono'] + $det['dch_valor'];

                $array_dpv = array(
                    'dpv_monto_pendiente' => $nuevo_monto_pendiente,
                    'dpv_pagado' => ($nuevo_monto_pendiente <= 0) ? 1 : 0,
                    'dpv_monto_abono' => $nuevo_abono
                );
                $this->gsatelite->actualizar_array('dpv_documento_proveedor', $array_dpv, array('dpv_id' => $det['dch_id_dpv']));
            }
        }
        //aplicar cub_cuenta_bancaria
        $this->db->join('cub_cuenta_bancaria', 'cub_id = chq_id_cub');
        $cuenta_bancaria = $this->gsatelite->get_tabla('chq_chequera', array('chq_id' => $cheque[0]['che_id_chq']));

        $newSaldo = $cuenta_bancaria[0]['cub_saldo'] - $cheque[0]['che_monto'];

        $array_banco = array(
            'cub_usu_mod' => $this->tank_auth->get_user_id(),
            'cub_fecha_mod' => date("Y-m-d H:i:s"),
            'cub_saldo' => $newSaldo
        );
        $result = $this->gsatelite->actualizar_array('cub_cuenta_bancaria', $array_banco, array('cub_id' => $cuenta_bancaria[0]['cub_id']));

        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Transacción", 'texto_alerta' => "La transacción efectuada correctamente");
        $this->session->set_flashdata($alerta);
        redirect('utm/cuentas/gestion_cheques');
    }

    /*
     * @author: Mario Marquez
     * Notas de Abono Pendientes
     */

    public function notas_pendientes()
    {
        $data['titulo_personal'] = "Transferencias Pendientes";

        $where = array('ntp_generado' => 0, 'ntp_estado >' => 0);

        $data['notas'] = $this->utm_model->get_notas_abono_pendientes($where);
        $data["permisos"] = $this->gsatelite->get_permisos_opcion();
        $this->_cargarvista($data);
    }

    public function notas_abono($consulta = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            if ($this->input->post()) {
                if ($consulta > 0) {
                    $post_array = $this->input->post();
                    $cuenta_bancaria = ($post_array['cuenta'] != '') ? $post_array['cuenta'] : null;
                    $fecha_inicio = $post_array['fecha_ini'];
                    $fecha_fin = $post_array['fecha_fin'];
                    $where = null;
                    if ($cuenta_bancaria != null) {
                        $where['nta_id_cub'] = $cuenta_bancaria;
                    }
                    if ($fecha_inicio != '' && $fecha_fin != '') {
                        $where['DATE(nta_fecha) >='] = formatear_fecha('Y-m-d', $fecha_inicio);
                        $where['DATE(nta_fecha) <='] = formatear_fecha('Y-m-d', $fecha_fin);
                    }
                    $notas_abono = $this->utm_model->get_notas_abono($where);
                    $data['notas_abono'] = $notas_abono;
                    $html = $this->load->view('utm/cuentas/consultar_notas_abono', $data, true);
                    echo $html;
                    die();
                }
            } else {
                $where = array(
                    'DATE(nta_fecha) >=' => date('Y-m-d'),
                    'DATE(nta_fecha) <=' => date('Y-m-d'),
                );
                $data['notas_abono'] = $this->utm_model->get_notas_abono($where);
                $data['cuentas_bancarias'] = $this->gsatelite->get_dropdown('vw_cuentas_bancarias', '{cuenta} {nombre}', '', '', null, '', 'cub_id', true);
                $data['titulo_personal'] = 'Notas de Abono';
                $this->_cargarvista($data);
            }
        }
    }

    function agregar_nota_abono($ntp_id = null, $ver = null)
    {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            $slcProveedor = ($post_array['slcProveedor'] != '') ? $post_array['slcProveedor'] : null;
            $hdnNotaPendiente = ($post_array['hdnNotaPendiente'] != '') ? $post_array['hdnNotaPendiente'] : null;
            $txtOdenDe = ($post_array['hnd_txtOdenDe'] != '') ? $post_array['hnd_txtOdenDe'] : null;
            $txtConcepto = ($post_array['txtConcepto'] != '') ? $post_array['txtConcepto'] : null;
            $hdnAplicarTrans = ($post_array['hdnAplicarTrans'] != '') ? $post_array['hdnAplicarTrans'] : 0;
            $slcCuenta = ($post_array['slcCuenta'] != '') ? $post_array['slcCuenta'] : null;
            $montoNota = ($post_array['txt_valor_monto'] != '') ? convertirFloat($post_array['txt_valor_monto']) : null;
            $txtFechaNota = ($post_array['txtFechaNota'] != '') ? formatear_fecha('Y-m-d H:i:s', $post_array['txtFechaNota'] . date('H:i:s')) : date('Y-m-d H:i:s');
            $aplica_cch = (isset($post_array['radio_anticipo_cch']) && $post_array['radio_anticipo_cch'] == 1) ? 1 : 0;
            $nta_anticipo = (isset($post_array['radio_anticipo_cch']) && $post_array['radio_anticipo_cch'] == 2) ? 1 : 0;
            $nta_id_cch = (isset($post_array['radio_anticipo_cch']) && $post_array['slcCajaChica'] > 0) ? $post_array['slcCajaChica'] : null;
            //$montoRetencion = ($post_array['txt_total_monto'] != '') ? convertirFloat($post_array['txt_total_monto']) : null;
            //$montoSujeto = ($post_array['txt_total_monto_sujeto'] != '') ? convertirFloat($post_array['txt_total_monto_sujeto']) : null;
            $num_nota = $this->gsatelite->count('nta_nota_abono');

            $codigo = $num_nota + 1;
            $idprv = $slcProveedor;
            $nota_array = array(
                'nta_id_prv' => $slcProveedor,
                'nta_id_ntp' => $hdnNotaPendiente,
                'nta_id_cub' => $slcCuenta,
                'nta_id_cch' => $nta_id_cch,
                'nta_anticipo' => $nta_anticipo,
                'nta_aplica_caja_chica' => $aplica_cch,
                'nta_monto' => $montoNota,
                'nta_codigo' => $codigo,
                'nta_orden' => $txtOdenDe,
                'nta_concepto' => $txtConcepto,
                'nta_fecha' => $txtFechaNota,
                'nta_estado' => 1,
                'nta_usu_creacion' => $this->tank_auth->get_user_id(),
                'nta_fecha_creacion' => date('Y-m-d H:i:s'),
                'nta_usu_modificacion' => $this->tank_auth->get_user_id(),
                'nta_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $nta_id = $this->gsatelite->ingresar('nta_nota_abono', $nota_array);
            // ID de la nota de abono
            $id = $nta_id;
            if ($nta_id > 0) {

                //Se cambia el estado a la nota de abono pendiente, si existe
                if ($hdnNotaPendiente != null) {
                    $nota_pendiente = array(
                        'ntp_generado' => 1,
                        'ntp_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'ntp_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('ntp_nota_abono_pendiente', $nota_pendiente, array('ntp_id' => $hdnNotaPendiente));
                    $agenda = $this->gsatelite->get_campo('ntp_nota_abono_pendiente', 'ntp_id_agp', array('ntp_id' => $hdnNotaPendiente));
                    $this->gsatelite->actualizar_array('agp_agenda_pago', array('agp_estado' => 0), array('agp_id' => $agenda));
                }
                if ($nta_anticipo > 0) {
                    //GUARDAR EN LA ATT
                    $agrega = array(
                        'att_id_nta' => $nta_id,
                        'att_saldo_inicial' => $montoNota,
                        'att_saldo_pendiente' => $montoNota,
                        'att_estado' => 1,
                        'att_usu_creacion' => $this->tank_auth->get_user_id(),
                        'att_fecha_creacion' => date('Y-m-d H:i:s'),
                        'att_usu_mod' => $this->tank_auth->get_user_id(),
                        'att_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('att_anticipo_transferencia', $agrega);
                }

                //Se procesan los detalles del cheque
                $facturas = $post_array['hdnFactura'];
                $descripciones = $post_array['txtTablaDescripcion'];
                $montosDetalle = $post_array['txtTablaMonto'];
                $montosSujetos = $post_array['txtTablaMontoSujeto'];
                $cuentasContables = $post_array['txtTablaCuenta'];
                $montosPendientes = $post_array['txtTablaMontoPendiente'];
                $retenciones = $post_array['txtTablaRetenciones_id'];
                $porcentajes = $post_array['txtTablaRetenciones_porcentaje'];
                $retencionMontos = $post_array['txtTablaRetencion'];
                $subtotales = $post_array['txtTablaTotal'];
                $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
                $proyecto                   = $this->input->post('txt_tabla_proyecto');
                $presupuesto                = $this->input->post('txt_presupuesto');
                $actividad_general          = $this->input->post('txt_actividad_general');
                $actividad_especifica       = $this->input->post('txt_actividad_especifica');
                $actividad_espeficifica_text = $this->input->post('txt_actividad_espeficifica_text');
                $totalRetenciones = 0;
                $totalRetencionesCalc = 0;

                if (count($montosDetalle) > 0) {
                    for ($i = 0; $i < count($montosDetalle); $i++) {
                        //dna_detalle_nota_abono

                        $factura_id = ($facturas[$i] != '') ? $facturas[$i] : null;
                        $concepto = ($descripciones[$i] != '') ? $descripciones[$i] : null;
                        $monto = ($montosDetalle[$i]) ? convertirFloat($montosDetalle[$i]) : 0;
                        $montoSujeto = ($montosSujetos[$i]) ? convertirFloat($montosSujetos[$i]) : 0;
                        $montoRetencion = ($retencionMontos[$i]) ? convertirFloat($retencionMontos[$i]) : 0;
                        $subtotal = ($subtotales[$i]) ? convertirFloat($subtotales[$i]) : 0;

                        if ($this->input->post('slcCuentaCont')) {
                            $cuenta_id = ($cuentasContables[$i] != '') ? $cuentasContables[$i] : $cuenta_defecto;
                        } else {
                            $cuenta_id = NULL;
                        }


                        $totalRetenciones += $montoSujeto;
                        $totalRetencionesCalc += $montoRetencion;

                        $detalle_array = array(
                            'dna_id_nta'                => $nta_id,
                            'dna_id_dpv'                => $factura_id,
                            'dna_concepto'              => $concepto,
                            'dna_id_cnt'                => $cuenta_id,
                            'dna_valor'                 => $monto,
                            'dna_retencion'             => $montoSujeto,
                            'dna_retencion_calculada'   => $montoRetencion,
                            'dna_subtotal'              => $subtotal,
                            'dna_id_pcl'                => ($proyecto[$i] > 0) ? $proyecto[$i] : NULL,
                            'dna_id_psp'                => ($presupuesto[$i] > 0) ? $presupuesto[$i] : NULL,
                            'dna_id_acg'                => ($actividad_general[$i] > 0) ? $actividad_general[$i] : NULL,
                            'dna_id_ace'                => ($actividad_especifica[$i] > 0) ? $actividad_especifica[$i] : NULL,
                            'dna_estado'                => 1,
                            'dna_usu_creacion'          => $this->tank_auth->get_user_id(),
                            'dna_fecha_creacion'        => date('Y-m-d H:i:s'),
                            'dna_usu_modificacion'      => $this->tank_auth->get_user_id(),
                            'dna_fecha_modificacion'    => date('Y-m-d H:i:s')
                        );
                        $dna_id = $this->gsatelite->ingresar('dna_detalle_nota_abono', $detalle_array);

                        if ($dna_id > 0) {

                            //se verificara si se agregaran gastos a presupuestos.  
                            if ($proyecto[$i] != "" && $actividad_especifica[$i] != "") {
                                // se verificara si existen registros en gastos conel dpv elegido.

                                $gasto_existente = null;
                                if ($factura_id[$i] != null) {
                                    $gasto_existente = $this->gsatelite->get_tabla("dgp_detalle_gasto_prespuesto", array("dgp_id_dpv" => $factura_id[$i]));
                                }

                                if (count($gasto_existente) == 0) {
                                    $condiciones = array(
                                        "dps_id_ace"    => $actividad_especifica[$i],
                                        "dps_id_acg"    => $actividad_general[$i],
                                        "dps_id_psp"    => $presupuesto[$i]
                                    );

                                    $detalle_presupuesto = $this->gsatelite->get_tabla("dps_detalle_presupuesto", $condiciones);

                                    if ($detalle_presupuesto != null) {

                                        $dgp_detalle_gasto_prespuesto = array(
                                            'dgp_id_dps'            => $detalle_presupuesto[0]['dps_id'],
                                            'dgp_id_tgp'            => 5,
                                            'dgp_id_dpv'            => ($factura_id[$i] > 0) ? $factura_id[$i] : NULL,
                                            'dgp_id_dna'            => $dna_id,
                                            'dgp_fecha'             => date('Y-m-d H:i:s'),
                                            'dgp_descripcion'       => $actividad_espeficifica_text[$i],
                                            'dgp_referencia'        => '',
                                            'dgp_cantidad'          => 1,
                                            'dgp_monto'             => convertirFloat($monto),
                                            'dgp_total_retencion'   => convertirFloat($montoRetencion),
                                            'dgp_total_impuesto'    => null,
                                            'dgp_sub_monto'         => convertirFloat($subtotal),
                                            'dgp_origen'            => 2,
                                            'dgp_referencia_origen' => null,
                                            'dgp_estado'            => ($hdnAplicarTrans == 1) ? 1 : 0,
                                            'dgp_usu_creacion'      => $this->tank_auth->get_user_id(),
                                            'dgp_fecha_creacion'    => date('Y-m-d H:i:s'),
                                            'dgp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                            'dgp_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );
                                        $dgp_id = $this->gsatelite->ingresar('dgp_detalle_gasto_prespuesto', $dgp_detalle_gasto_prespuesto);
                                    }
                                }
                            }

                            //Se modifica el monto de del documento por proveedor
                            if ($factura_id != null && $hdnAplicarTrans == 1) {
                                $documento_factura = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id' => $factura_id));

                                $nuevo_monto_pendiente = $documento_factura[0]['dpv_monto_pendiente'] - $monto;
                                $nuevo_abono = $documento_factura[0]['dpv_monto_abono'] + $monto;

                                $array_dpv = array(
                                    'dpv_monto_pendiente' => $nuevo_monto_pendiente,
                                    'dpv_pagado' => ($nuevo_monto_pendiente <= 0) ? 1 : 0,
                                    'dpv_monto_abono' => $nuevo_abono
                                );
                                $this->gsatelite->actualizar_array('dpv_documento_proveedor', $array_dpv, array('dpv_id' => $factura_id));
                            }

                            //insertara las retenciones de cada detalle
                            if ($retenciones[$i] != "") {
                                $id_retenciones_array = split(",", $retenciones[$i]);
                                $porcentajes_retencion_array = split(",", $porcentajes[$i]);

                                foreach ($id_retenciones_array as $key => $value) {
                                    $retencion_id = $value;
                                    $porcentaje = convertirFloat($porcentajes_retencion_array[$key]);
                                    $monto_retencion = ($montoSujeto * ($porcentaje / 100));

                                    $array_ret = array(
                                        'rdn_id_ret' => $retencion_id,
                                        'rdn_id_dna' => $dna_id,
                                        'rdn_porcentaje' => $porcentaje,
                                        'rdn_monto' => $monto_retencion,
                                        'rdn_estado' => 1,
                                        'rdn_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'rdn_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'rdn_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'rdn_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->ingresar('rdn_retencion_detalle_nota', $array_ret);
                                }
                            }
                        }
                    }
                }

                //Se ingresa la transaccion
                $tipo_transaccion = $this->gsatelite->get_parametro('SYS_TIPO_TRANSACCION', null, null, array('SALIDA_NOTA'));
                $concep = $this->gsatelite->get_campo('ttb_tipo_transact_bancaria', 'ttb_nombre', array('ttb_id' => $tipo_transaccion));
                if (is_null($tipo_transaccion) || is_null($concep)) {
                    $hubo_tra = false;
                    $transaccion = null;
                } else {
                    $hubo_tra = true;
                    $concepto_transaccion = ($concep != null) ? $concep : "Salida por Transferencia Bancaria";
                    $fecha_tra = (trim($txtFechaNota) != '') ? $txtFechaNota : date("Y-m-d H:i:s");
                    $array_tra = array(
                        'tra_id_cub' => $slcCuenta,
                        'tra_id_ttb' => $tipo_transaccion,
                        'tra_fecha' => $fecha_tra,
                        'tra_operacion' => $concepto_transaccion,
                        'tra_monto' => ($montoNota * (-1)),
                        'tra_comprobante' => $codigo,
                        'tra_conciliado' => 0,
                        'tra_estado' => 1,
                        'tra_fecha_mod' => date("Y-m-d H:i:s"),
                        'tra_usu_mod' => $this->tank_auth->get_user_id(),
                        'tra_usu_crea' => $this->tank_auth->get_user_id(),
                        'tra_fecha_crea' => date("Y-m-d H:i:s"),
                        'tra_aplicar' => $hdnAplicarTrans
                    );
                    $transaccion = $this->gsatelite->ingresar('tra_transaccion', $array_tra);
                }

                //Se actualiza la nota de abono
                $nota_array = array(
                    'nta_id_tra' => $transaccion,
                    'nta_monto_sujeto' => $totalRetenciones,
                    'nta_monto_retencion' => $totalRetencionesCalc,
                );
                $this->gsatelite->actualizar_array('nta_nota_abono', $nota_array, array('nta_id' => $nta_id));

                //Se modifica la cuenta bancaria si aplica la transacción
                if ($hdnAplicarTrans == 1) {
                    $cuenta_bancaria = $this->gsatelite->get_tabla('cub_cuenta_bancaria', array('cub_id' => $slcCuenta));
                    $newSaldo = $cuenta_bancaria[0]['cub_saldo'] - $montoNota;
                    $array_banco = array(
                        'cub_usu_mod' => $this->tank_auth->get_user_id(),
                        'cub_fecha_mod' => date("Y-m-d H:i:s"),
                        'cub_saldo' => $newSaldo
                    );
                    $this->gsatelite->actualizar_array('cub_cuenta_bancaria', $array_banco, array('cub_id' => $cuenta_bancaria[0]['cub_id']));

                    // $partida_automatica = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_BANCO');
                    // if ($partida_automatica == 1) {
                    // $this->partida_contable_nota_abono($nta_id);
                    // }
                }
                /* ************************************************************************ */
                // if ($aplicar_cheque == 1) {
                /* ============================================= */
                /* ==  GENERAR PARTIDA CONTABLE NOTA DE ABONO == */
                /* ============================================= */
                $permite_generar = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_BANCO');
                $trae_partida = ($this->input->post('contador_det_partida') > 1 && $this->input->post('validacion_det_partida') != "") ? true : false;
                if ($permite_generar == 1 && $id > 0 && $idprv > 0) {
                    //Generar partida de nota de abono
                    $nta_id_pct = $this->generar_partida_automatica_nota_abono($id, 2);
                    //Actualizar el id de la partida contable en la nota de abono
                    if ($nta_id_pct > 0) {
                        $this->gsatelite->actualizar_array('nta_nota_abono', array('nta_id_pct' => $nta_id_pct), array('nta_id' => $id));
                    }
                }
                /***************Generacion de partida Manual*****************************/
                if ($trae_partida || ($permite_generar == 1 && $id > 0 && $idprv > 0)) {
                    // if(!empty($this->input->post('cuenta'))){
                    $this->load->library('../controllers/modulo_contabilidad/procesos');
                    //Preparando arreglo
                    $array_partida_manual = [];
                    $array_partida_manual['nta_id'] = $id;
                    $array_partida_manual['id_prc'] = $this->input->post('id_prc');
                    $array_partida_manual['concepto_gral'] = $this->input->post('concepto_gral');
                    $array_partida_manual['volver'] = $this->input->post('volver');
                    $array_partida_manual['tipo'] = $this->input->post('tipo');
                    $array_partida_manual['fecha'] = $this->input->post('fecha');
                    $array_partida_manual['cuenta'] = $this->input->post('cuenta');
                    $array_partida_manual['debe'] = $this->input->post('debe');
                    $array_partida_manual['haber'] = $this->input->post('haber');
                    $array_partida_manual['contador_det_partida'] = $this->input->post('contador_det_partida');
                    $array_partida_manual['validacion_det_partida'] = $this->input->post('validacion_det_partida');
                    $array_partida_manual['slcCntOculto'] = $this->input->post('slcCntOculto');
                    $array_partida_manual['detalle_c'] = $this->input->post('detalle_c');
                    $array_partida_manual['detalle_d'] = $this->input->post('detalle_d');
                    $array_partida_manual['detalle_h'] = $this->input->post('detalle_h');
                    $array_partida_manual['detalle_con'] = $this->input->post('detalle_con');
                    $array_partida_manual['total_debe'] = $this->input->post('total_debe');
                    $array_partida_manual['total_haber'] = $this->input->post('total_haber');
                    $array_partida_manual['proceso'] = 'banco_trasferencia';
                    $this->procesos->agregar_partida($array_partida_manual);
                    // }
                }
                /************************************************************************/

                if ($nta_id != 0) {
                    if ($hubo_tra) {
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Transferencia Bancaria", 'texto_alerta' => "Transferencia Bancaria #" . $codigo . " Ingresada correctamente");
                    } else {
                        $alerta = array('tipo_alerta' => 'info', 'titulo_alerta' => "Transferencia Bancaria", 'texto_alerta' => "Transferencia Bancaria #" . $codigo . " Ingresada correctamente. No se ingresó la transacción, verifique el parámetro e ingrese la transacción manualmente. ");
                    }
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Transferencia Bancaria", 'texto_alerta' => "Transacción no efectuada, favor verificar información");
                }

                $this->session->set_flashdata($alerta);

                if ($hdnNotaPendiente != null) {
                    redirect('utm/cuentas/notas_pendientes');
                } else {
                    $opc = $this->input->post('btnCrear');
                    if ($opc == 1) {
                        redirect('utm/cuentas/agregar_nota_abono');
                    }
                    if ($opc == 2) {
                        redirect('utm/cuentas/notas_abono');
                    }
                }
            }
        }
        $data['proveedores'] = $this->gsatelite->get_dropdown('prv_proveedor', "[CASE WHEN prv_tipo_pers = 1 THEN CONCAT_WS(' ',prv_codigo, '-' ,prv_nombre,prv_apellido)ELSE CONCAT_WS(' ',prv_codigo, '-' ,prv_nombre) END]", 'provedor', array('prv_estado' => 1), null, null, null, true);
        $data['bancos'] = $this->utm_model->get_banco();
        $data['retencion'] = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
        $data['nota_pendiente'] = null;
        $data['cuenta_contable'] = null;
        if ($ntp_id != null) {
            $nota_pendiente = $this->utm_model->get_notas_abono_pendientes(array('ntp_id' => $ntp_id));
            $data['nota_pendiente'] = $nota_pendiente[0];
            if ($nota_pendiente[0]['dpv_id_prv'] != null) {
                $tipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('CUENTA_POR_PAGAR'));
                $cuentas = $this->gsatelite->get_tabla('dfp_detalle_finanza_proveedor', array('dfp_id_prv' => $nota_pendiente[0]['dpv_id_prv'], 'dfp_id_tcn' => $tipo_cnt));
                $id = (count($cuentas) > 0) ? $cuentas[0]['dfp_id'] : 0;
                $data['cuenta_contable'] = $this->gsatelite->get_cuenta_contable('dfp_detalle_finanza_proveedor', 'CUENTA_POR_PAGAR', array('dfp_id' => $id));
            }
        }
        //************
        $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
        $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
        $cuenta = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array("cnt_estado" => 1, "cnt_id NOT IN ( $padres )" => NULL), null, null, null, true);
        $data['cuenta'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $cuenta);
        $select_drop   = $this->gsatelite->get_dropdown('tpd_tipo_partida', '{tpd_nombre}', '', array('tpd_estado' => 1), null, null, null, true);
        $data['tipo'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select_drop);

        $ano_actual         = date('Y'); // Quemadp
        $mes_actual         = date('m'); // Quemado
        $data['periodo']    = $this->gsatelite->get_tabla('prc_periodo_contable', array('prc_estado' => 1)); //'prc_ano' => $ano_actual, 'prc_mes' => $mes_actual, // Se omitieron parametros para que solo muestre el activo

        $this->db->join("epr_estado_proyecto", "epr_id = pcl_id_epr");
        $proyectos              = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array('epr_cierre !=' => 1), null, '', 'pcl_id', true);
        $proyectos              = str_replace('<option value="0">Seleccione</option>', '', $proyectos);
        $data['proyectos']      = str_replace('<option value="0">Sin Registros</option>', '', $proyectos);
                      $this->db->join("lcc_liquidacion_caja_chica", "lcc_id_cch = cch_id");
        $slct_cch = $this->gsatelite->get_dropdown('cch_caja_chica','{cch_nombre}','',array('cch_estado'=>1,'lcc_corte'=>0,'lcc_estado'=>1),null,null,'cch_id',true);
        $data['caja_ch'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $slct_cch);

        $data['titulo_personal'] = "Agregar Transferencia Bancaria";
        $data['ver'] = $ver;
        if ($ver != null) {
            $this->gsatelite->cargar_vista_masterpage('utm/cuentas/agregar_nota_abono', $data);
        } else {
            $par_tp_tra = $this->gsatelite->get_parametro('SYS_TIPO_TRANSACCION', null, null, array('SALIDA_NOTA'));
            $hay_rw_ttb = $this->gsatelite->get_tabla('ttb_tipo_transact_bancaria', array('ttb_id' => $par_tp_tra));
            if (is_null($par_tp_tra) || count($hay_rw_ttb) == 0) { //SI NO EXISTE EL PARAMETRO O NO ESTA BIEN CONFIURADO ABORTAR OPERACION
                $url = (is_null($ntp_id)) ? 'utm/cuentas/notas_abono' : 'utm/cuentas/notas_pendientes';
                $this->gsatelite->show_dialog('Verifique la configuración del parámetro e inténtelo de nuevo', $url, 'error', 'Error de Parámetro ');
            }
            cargarvista($data);
        }
    }

    /*
     * @author: Mario Marquez
     * $cli_busqueda: Parametro de busqueda, desde otra funcion
     * Si no se llena sera un Json
     */

    public function get_cuentas_contables_like($cnt_busqueda = null)
    {
        $cuenta = ($cnt_busqueda != null) ? $cnt_busqueda : $this->input->post('cuenta');
        $tipo_cuenta = ($this->input->post('tipo') != '') ? $this->input->post('tipo') : null;
        $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
        $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
        $resultado = null;
        $arreglo = array();
        if ($cuenta != null) {

            $where = array(
                "cnt_estado" => 1,
                "cnt_id NOT IN ( $padres )" => null
            );

            if ($tipo_cuenta != null) {
                $where['cnt_id_tcn'] = $tipo_cuenta;
            }

            $like = array("CONCAT_WS(' ',cnt_cuenta,' - ',cnt_nombre)" => $cuenta);

            $resultado = $this->utm_model->get_cuentas_like($where, $like);
            //print_r($this->db->last_query());die();


            if (count($resultado) > 0) {
                foreach ($resultado as $key => $value) {
                    $arreglo[$key]['cuenta'] = $value['cnt_id'];
                    $arreglo[$key]['cuenta_nombre'] = $value['cuenta_contable'];
                }
            }
        }
        if ($cnt_busqueda != null) {
            return $resultado;
        }

        echo json_encode($arreglo);
    }

    public function get_cuentas_cuenta_proveedor()
    {
        $tipo_cnt = $this->input->post('tipo');
        $proveedor = $this->input->post('proveedor');

        $arreglo = array();
        if ($tipo_cnt != null && $proveedor != null) {
            $cuenta_contable = $this->gsatelite->get_cuenta_contable('dfp_detalle_finanza_proveedor', $tipo_cnt, array('dfp_id_prv' => $proveedor));
            $cta_por_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
            $arreglo['cuenta'] = $cuenta_contable['cnt_id'];
            $arreglo['cta_prv'] = ($cuenta_contable['cnt_id'] == $cta_por_defecto) ? 0 : 1;
            $arreglo['cuenta_nombre'] = $cuenta_contable['cnt_cuenta'] . ' - ' . $cuenta_contable['cnt_nombre'];
        }
        echo json_encode($arreglo);
    }

    public function get_dpvsx()
    {
        $proveedor = $this->input->post('prv');
        // traemos los DPV ligados al proveedor
        // se agregan las cuentas bancarias de cada proveedor si existen
        $where  = null;
        $result = "";
        $dpv    = '';
        $option = '<option></option>';
        $select = '<option></option>';
        if ($proveedor != "") {
            $where['dpv_id_prv'] = $proveedor;
            $where['dpv_pagado'] = 0;
            $where['dpv_estado'] = 1;
            if (!isset($factura)) {
                $factura = null;
            }
            $result = array();
            $this->db->join('ban_banco', 'ban_id = dbp_id_ban');
            $cta_bancos = $this->gsatelite->get_tabla('dbp_detalle_banco_proveedor', array('dbp_id_prv' => $proveedor));
            $documentos = $this->utm_model->get_factura_like($factura, $where, 'dpv_id');
            // print_r($this->db->last_query());
            if (count($documentos) > 0) {
                foreach ($documentos as $dpv) {
                    if ($dpv['cheques_pendientes'] == 0) {
                        $option .= '<option value="' . $dpv['dpv_id'] . '">' . $dpv['dpv_numero_documento'] . '   ($' . number_format($dpv['dpv_monto_pendiente'], 2) . ')</option>';
                    }
                }
            }
            if (count($cta_bancos) > 0) {
                foreach ($cta_bancos as $key => $value) {
                    $select .= '<option value="' . $value['dbp_id'] . '" data-banco="' . $value['ban_id'] . '">' . $value['ban_prefijo'] . ': ' . $value['dbp_cuenta_banco'] . '</option>';
                }
            }
        }
        // var_dump($select);die();
        echo json_encode(array('options' => $option, 'bancos' => $select));
    }

    public function validar_documento_proveedor($docuento = null, $monto_agregado = null)
    {

        $dpv_id = ($docuento != null) ? $docuento : $this->input->post('documento');
        $monto = ($monto_agregado != null) ? $monto_agregado : $this->input->post('monto');

        $where = array(
            'che_id_usu_anulacion IS NULL' => NULL,
            'dch_id_dpv' => $dpv_id
        );

        $this->db->join('che_cheque', 'che_id = dch_id_che', 'inner');
        $monto_pagado = $this->gsatelite->get_suma('dch_detalle_cheque', 'dch_valor', $where);
        $this->db->join('che_cheque', 'che_id = dch_id_che', 'inner');
        $monto_retencion = $this->gsatelite->get_suma('dch_detalle_cheque', 'dch_valor', $where);
        if ($monto_retencion > 0) {
            $monto_pagado = $monto_pagado - $monto_retencion;
        }

        $monto_documento = $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_total', array('dpv_id' => $dpv_id));

        $correcto = true;

        if (round(($monto_pagado + $monto), 2) > round($monto_documento, 2)) {
            $correcto = false;
        }


        if ($docuento != null) {
            return $correcto;
        }

        echo json(array('respuesta' => $docuento));
    }

    /*
     * @author: Mario Marquez
     * @since 2017-07-28
     * @return generación de la partida contable apartir de la aplicación de una Nota de abono
     */

    public function partida_contable_nota_abono($nta_id = null)
    {
        //Se obtiene la tabla de origen en este caso Notas de abono
        $origen = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_tabla' => 'nta_nota_abono'));
        //Se obtiene el tipo de partida por defecto
        $tipo_partida_defecto = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');

        //Se asigna a la variable asociar a la partida en caso exista, sino se agrega la defecto
        $tipo_id = $tipo_partida_defecto;
        $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('GASTO'));
        $consultar_tipo_partida = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $tipo_partida));
        if (count($consultar_tipo_partida) > 0) {
            $tipo_id = $tipo_partida;
        }

        $nota_abono = $this->utm_model->get_notas_abono(array('nta_id' => $nta_id));

        //Concepto partida nota de abono
        $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 15));
        if (count($pct_concepto) > 0) {
            $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
        } else {
            $pct_concepto = 'Concepto no definido';
        }

        if (count($nota_abono) > 0) {
            $concepto_partida = $pct_concepto . ' - ' . $nota_abono[0]['nta_codigo'];
            $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo');
            $codigo_nota = ($nota_abono[0]['nta_codigo']) ? $nota_abono[0]['nta_codigo'] : '';

            $total_partida = $nota_abono[0]['nta_monto'] + $nota_abono[0]['nta_monto_retencion'];
            $partida_array = array(
                'pct_id_orp' => (count($origen) > 0) ? $origen[0]['orp_id'] : null,
                'pct_id_tpd' => ($tipo_id > 0) ? $tipo_id : null,
                'pct_concepto' => $concepto_partida,
                'pct_total' => $total_partida,
                'pct_fecha' => date('Y-m-d H:i:s'),
                'pct_correlativo' => ($correlativo_partida > 0) ? ($correlativo_partida + 1) : 1,
                'pct_codigo' => $codigo_nota,
                'pct_estado' => 1,
                'pct_usu_crea' => $this->tank_auth->get_user_id(),
                'pct_fecha_crea' => date('Y-m-d H:i:s'),
                'pct_usu_mod' => $this->tank_auth->get_user_id(),
                'pct_fecha_mod' => date('Y-m-d H:i:s')
            );

            $partida_id = $this->gsatelite->ingresar('pct_partida_contable', $partida_array);

            if ($partida_id > 0) {
                $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');

                //Se obtiene la cuenta asociada a la cuenta bancaria de la nota de abono
                $cnt_cuenta_bancaria = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_id_cnt', array('cub_id' => $nota_abono[0]['nta_id_cub']));
                $cuenta_bancaria = $this->gsatelite->get_campo('cub_cuenta_bancaria', 'cub_numero', array('cub_id' => $nota_abono[0]['nta_id_cub']));

                $cuenta_detalles = ($cnt_cuenta_bancaria != null) ? $cnt_cuenta_bancaria : $cuenta_defecto;

                //Se ingresa el detalle Cargado
                $detalle_partida_array = array(
                    'dpc_id_cnt' => $cuenta_detalles,
                    'dpc_id_pct' => $partida_id,
                    'dpc_concepto' => 'Cargo Cuenta Bancaria por Transferencia - ' . $cuenta_bancaria,
                    'dpc_debe' => $nota_abono[0]['nta_monto'] + $nota_abono[0]['nta_monto_retencion'],
                    'dpc_haber' => 0,
                    'dpc_estado' => 1,
                    'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                    'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                    'dpc_usu_mod' => $this->tank_auth->get_user_id(),
                    'dpc_fecha_mod' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('dpc_detalle_partida', $detalle_partida_array);

                //Se obtienen los detalles de la nota de abono
                $select = "IFNULL(cnt_id," . $cuenta_defecto . ") as id_cuenta_contable, SUM(dna_subtotal) as monto";
                $group_by = "";
                $where_detalle = array('dna_id_nta' => $nta_id);

                $detalle_nota = $this->utm_model->get_detalle_nota_abono($where_detalle, $select, $group_by);

                //Si contiene detalles se procesan sino se elimina la partida agregada
                if (count($detalle_nota) > 0) {
                    $detalle_partida_array = array();
                    foreach ($detalle_nota as $dna) {
                        $detalle_partida_array[] = array(
                            'dpc_id_cnt' => $dna['id_cuenta_contable'],
                            'dpc_id_pct' => $partida_id,
                            'dpc_concepto' => 'Cargo Cuenta Bancaria Transferencia - ' . $codigo_nota,
                            'dpc_debe' => 0,
                            'dpc_haber' => $dna['monto'],
                            'dpc_estado' => 1,
                            'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                            'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                            'dpc_usu_mod' => $this->tank_auth->get_user_id(),
                            'dpc_fecha_mod' => date('Y-m-d H:i:s')
                        );
                    }

                    //Se obtienen las retenciones de cada detalle
                    //rdn_retencion_detalle_nota

                    $select_retencion = "ret_id, ret_nombre,SUM(rdn_monto) as monto";

                    $this->db->join('dna_detalle_nota_abono', 'dna_id = rdn_id_dna', 'inner');
                    $this->db->group_by('ret_id');
                    $retenciones = $this->utm_model->get_retenciones_detalle_nota(array('dna_id_nta' => $nta_id), $select_retencion);
                    if (count($retenciones) > 0) {
                        foreach ($retenciones as $ret) {
                            $cuenta_contable = $this->gsatelite->get_cuenta_contable('dcr_detalle_cuenta_retencion', 'GASTO', array('dcr_id_ret' => $ret['ret_id']));
                            $detalle_partida_array[] = array(
                                'dpc_id_cnt' => ($cuenta_contable != null) ? $cuenta_contable['cnt_id'] : $cuenta_defecto,
                                'dpc_id_pct' => $partida_id,
                                'dpc_concepto' => 'Retencion - ' . $ret['ret_nombre'],
                                'dpc_debe' => 0,
                                'dpc_haber' => $ret['monto'],
                                'dpc_estado' => 1,
                                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                                'dpc_usu_mod' => $this->tank_auth->get_user_id(),
                                'dpc_fecha_mod' => date('Y-m-d H:i:s')
                            );
                        }
                    }

                    //ejecutar insert batch
                    $n_detalles_ingresos = $this->gsatelite->ingresar('dpc_detalle_partida', $detalle_partida_array, true);
                } else {
                    $this->gsatelite->borrado_general('dpc_detalle_partida', array('dpc_id_pct' => $partida_id));
                    $this->gsatelite->borrado_general('pct_partida_contable', array('pct_id' => $partida_id));
                }

                //Se asocia la nota de abono con la partida contable
                $nota_array = array(
                    'nta_id_pct' => $partida_id,
                );
                $this->gsatelite->actualizar_array('nta_nota_abono', $nota_array, array('nta_id' => $nta_id));
            }
            return $partida_id;
        }
    }

    /*
     * @author: Mario Marquez
     * @since 2017-07-28
     * @return anulación de notas de abono Pendientes
     */

    public function anular_nota_pendiente($ntp_id, $agp)
    {
        $registro = $this->gsatelite->actualizar_array('ntp_nota_abono_pendiente', array('ntp_estado' => 0), array('ntp_id' => $ntp_id));
        $registro2 = $this->gsatelite->actualizar_array('agp_agenda_pago', array('agp_estado' => 0), array('agp_id' => $agp));
        if ($registro == 1 && $registro2 == 1) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Transferencia Bancaria Pendiente Anulada", 'texto_alerta' => "Se anulo la Transferencia Bancaria Pendiente correctamente");
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "No se pudo eliminar la orden.");
        }

        $this->session->set_flashdata($alerta);
        redirect('utm/cuentas/notas_pendientes');
    }

    /**
     * @author Edith Herrera
     * @since 2017-07-28
     * @return generación de la partida contable apartir de la autorización del cheque o la bandera al crear el cheque.
     */
    public function partida_contable_cheque($id_cheque)
    {
        $origen = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_tabla' => 'che_cheque'));

        $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');
        $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('GASTO'));
        $consultar = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $tipo_partida));
        if (count($consultar) > 0) {
            $id_tipo_partida = $tipo_partida;
        }

        $datos_cheque = $this->utm_model->get_info_cheque($id_cheque);
        $retenciones = $this->utm_model->get_retenciones_cheque($id_cheque);

        //Concepto Banco Cheque
        $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 16));
        if (count($pct_concepto) > 0) {
            $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
        } else {
            $pct_concepto = 'Concepto no definido';
        }

        if (count($datos_cheque) > 0) {
            if ($datos_cheque[0]['che_concepto'] != '') {
                $concepto_partida = $pct_concepto . " - Número: " . $datos_cheque[0]['che_numero'] . ' - ' . $datos_cheque[0]['che_concepto'];
            } else {
                $concepto_partida = $pct_concepto . " - Número: " . $datos_cheque[0]['che_numero'];
            }
            ///////////////////////////////////////////////////////////////////////////

            $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo');
            $numero_cheque = ($datos_cheque[0]['che_numero']) ? $datos_cheque[0]['che_numero'] : '';

            $array_insert = array(
                'pct_id_orp' => (count($origen) > 0) ? $origen[0]['orp_id'] : null, 'pct_id_tpd' => ($id_tipo_partida > 0) ? $id_tipo_partida : null, 'pct_concepto' => $concepto_partida, 'pct_total' => 0 // se actualizará posteriormente
                , 'pct_fecha' => formatear_fecha('Y-m-d', $datos_cheque[0]['che_fecha']), 'pct_correlativo' => ($correlativo_partida > 0) ? ($correlativo_partida + 1) : 1, 'pct_codigo' => $numero_cheque, 'pct_estado' => 1, 'pct_usu_crea' => $this->tank_auth->get_user_id(), 'pct_fecha_crea' => date('Y-m-d H:i:s'), 'pct_usu_mod' => $this->tank_auth->get_user_id(), 'pct_fecha_mod' => date('Y-m-d H:i:s')
            );


            $id_partida = $this->gsatelite->ingresar('pct_partida_contable', $array_insert);
            if ($id_partida > 0) {
                // Actualizar la partida en el cheque
                $act = $this->gsatelite->actualizar_array('che_cheque', array('che_id_pct' => $id_partida), array('che_id' => $id_cheque));

                // GENERAR LOS DETALLES PARA LA PARTIDA CONTABLE
                $total_partida = 0;
                $total_subtotal = 0;
                $array_insert_cargo = array();
                $array_insert_banco = array();
                foreach ($datos_cheque as $det_che) {
                    $total_partida += $det_che['valor'];
                    $total_subtotal += $det_che['subtotal'];
                    $array_insert_cargo[] = array(
                        'dpc_id_cnt' => $det_che['id_cuenta_contable'], 'dpc_id_pct' => $id_partida, 'dpc_concepto' => ($det_che['dch_concepto'] != '') ? $det_che['dch_concepto'] : 'Detalle de cheque ' . $numero_cheque, 'dpc_debe' => 0, 'dpc_haber' => $det_che['subtotal'], 'dpc_estado' => 1, 'dpc_usu_crea' => $this->tank_auth->get_user_id(), 'dpc_fecha_crea' => date('Y-m-d H:i:s'), 'dpc_usu_mod' => $this->tank_auth->get_user_id(), 'dpc_fecha_mod' => date('Y-m-d H:i:s')
                    );

                    $array_insert_banco[] = array(
                        'dpc_id_cnt' => $det_che['id_cuenta_banco'], 'dpc_id_pct' => $id_partida, 'dpc_concepto' => ($det_che['dch_concepto'] != '') ? $det_che['dch_concepto'] : 'Detalle de cheque ' . $numero_cheque, 'dpc_debe' => $det_che['valor'], 'dpc_haber' => 0, 'dpc_estado' => 1, 'dpc_usu_crea' => $this->tank_auth->get_user_id(), 'dpc_fecha_crea' => date('Y-m-d H:i:s'), 'dpc_usu_mod' => $this->tank_auth->get_user_id(), 'dpc_fecha_mod' => date('Y-m-d H:i:s')
                    );
                }

                $n_detalles_banco = $this->gsatelite->ingresar('dpc_detalle_partida', $array_insert_banco, true); // Ejecutar insert batch

                $n_detalles_ingresos = $this->gsatelite->ingresar('dpc_detalle_partida', $array_insert_cargo, true); // Ejecutar insert batch
            }

            // Actualizar el total de partida
            $pct_array = array(
                'pct_total' => $total_partida,
            );
            $this->gsatelite->actualizar_array('pct_partida_contable', $pct_array, array('pct_id' => $id_partida));

            $array_insert_retencion = array();
            if (count($retenciones) > 0) {
                foreach ($retenciones as $ret) {
                    $array_insert_retencion[] = array(
                        'dpc_id_cnt' => $ret['cuenta'], 'dpc_id_pct' => $id_partida, 'dpc_concepto' => ($ret['ret_nombre'] != '') ? $ret['ret_nombre'] : 'Retención', 'dpc_debe' => 0, 'dpc_haber' => $ret['retencion'], 'dpc_estado' => 1, 'dpc_usu_crea' => $this->tank_auth->get_user_id(), 'dpc_fecha_crea' => date('Y-m-d H:i:s'), 'dpc_usu_mod' => $this->tank_auth->get_user_id(), 'dpc_fecha_mod' => date('Y-m-d H:i:s')
                    );
                }
                $n_detalles_retencion = $this->gsatelite->ingresar('dpc_detalle_partida', $array_insert_retencion, true); // Ejecutar insert batch para las retenciones.
            }

            return $id_partida;
        }
    }

    /**
     * @author Melbin Cruz
     *
     */
    function anular_nota_abono($id_nota = NULL)
    {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();

            // Actualizar el estado del cheque
            $id_nota = $this->input->post('id_nota_abono');
            //$no = $this->gsatelite->get_campo('che_cheque', 'che_numero', array('che_id' => $id_cheque));
            $id_cuenta = $this->input->post('id_cuenta');
            $justificacion = $this->input->post('justificar_anulacion');
            $monto = $this->input->post('monto');

            $cheque = array(
                'nta_motivo_anulacion'  => $justificacion,
                'nta_fecha_anulacion'   => date('Y-m-d H:i:s'),
                'nta_estado'            => 0,
                'nta_usu_modificacion'  => $this->tank_auth->get_user_id(),
                'nta_id_usu_anulacion'  => $this->tank_auth->get_user_id(),
                'nta_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $registro = $this->gsatelite->actualizar_array('nta_nota_abono', $cheque, array('nta_id' => $id_nota));

            // inactivar Transaccion

            $transacion = $this->gsatelite->get_tabla('nta_nota_abono', array('nta_id' => $id_nota));

            if ($registro == 1) {
                $tipo = 1; //Deposito
                $array_tra = array(
                    'tra_estado' => 0,
                    'tra_fecha_mod' => date("Y-m-d H:i:s"),
                    'tra_usu_mod' => $this->tank_auth->get_user_id()
                );
                $transaccion = $this->gsatelite->actualizar_array('tra_transaccion', $array_tra, array('tra_id' => $transacion[0]['nta_id_tra']));
            }

            //revisar los documentos del proveedor
            $detalle_cheque = $this->gsatelite->get_tabla('dna_detalle_nota_abono', array('dna_id_nta' => $id_nota));

            foreach ($detalle_cheque as $key => $value) {
                if ($value['dna_id_dpv'] != "") {
                    $documento_factura = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id' => $value['dna_id_dpv']));
                    $nuevo_monto_pendiente = $documento_factura[0]['dpv_monto_pendiente'] + $value['dna_subtotal'];
                    $nuevo_abono = $documento_factura[0]['dpv_monto_abono'] - $value['dna_subtotal'];

                    $array_dpv = array(
                        'dpv_monto_pendiente'   => $nuevo_monto_pendiente,
                        'dpv_pagado'            => ($nuevo_monto_pendiente <= 0) ? 1 : 0,
                        'dpv_monto_abono'       => $nuevo_abono
                    );
                    $this->gsatelite->actualizar_array('dpv_documento_proveedor', $array_dpv, array('dpv_id' => $value['dna_id_dpv']));
                }
            }

            //generar_contra_partida
            if ($transacion[0]['nta_id_pct'] != "") {
                $this->generar_contra_partida($transacion[0]['nta_id_pct'], 2, 12);
            }

            if ($transaccion > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Anulación Exitosa", 'texto_alerta' => "Se anuló el cheque correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "No se pudo realizar la operación.");
            }
            $this->session->set_flashdata($alerta);
            redirect('utm/cuentas/notas_abono');
        } else {
            $data['nota_abono'] = $this->gsatelite->get_registro('nta_nota_abono', array('nta_id' => $id_nota));
            $data['detalle_cuenta'] = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $data['nota_abono']->nta_id_cub))->row_array();

            $this->db->join('tra_transaccion', 'tra_id = nta_id_tra');
            $data['aplicado'] = $this->gsatelite->get_tabla('nta_nota_abono', array('nta_id' => $id_nota));
            //DETALLES DE LA NOTA DE ABONO
            $where = null;
            $where['dna_id_nta'] = $id_nota;
            $data['pagos'] = $this->utm_model->get_detalle_nota_abono($where);


            //$this->gsatelite->cargar_vista_masterpage('utm/cuentas/anular_nota_abono', $data);
            $html = $this->load->view('utm/cuentas/anular_nota_abono', $data, true);
            die($html);
        }
    }

    function validar_chequera()
    {
        if (is_numeric(end(explode("/", uri_string())))) {

            $chequera = end(explode("/", uri_string()));
            $num_inicial = $this->input->post('chq_numero_inicio');
            $chq_cantidad = $this->input->post('chq_cantidad');
            $total_cheques = $this->gsatelite->count('che_cheque', array('che_id_chq' => $chequera));
            $numero_inicial_bd = $this->gsatelite->get_campo('chq_chequera', 'chq_numero_inicio', array('chq_id' => $chequera));

            if ($total_cheques > 0 && $num_inicial != $numero_inicial_bd) {
                $this->form_validation->set_message('validar_chequera', 'No puede modificar el número de cheque inicial, ya se han emitido ' . $total_cheques . ' cheques.');
                return false;
            }

            if ($total_cheques > $chq_cantidad) {
                $this->form_validation->set_message('validar_chequera', 'La cantidad de cheques no puede ser menor a los ya emitidos, ya se han emitido ' . $total_cheques . ' cheques.');
                return false;
            }
        }
        return true;
    }

    /**
     * @author Elman Ortiz
     * Descripcion: vista Cheques consolidados
     */
    function cheques_consolidados()
    {
        satelite_validar();
        $data['titulo_personal'] = "Cheques Consolidados";

        //$where = array('chp_generado' => 0, 'chp_estado' => 1, 'dpv_id_prv' => 15, 'dpv_monto_pendiente >' => 0);
        //$data['cheques'] = $this->utm_model->get_cheques_pendientes($where);

        $where['dpv_monto_pendiente >'] = 0;
        $data["permisos"] = $this->gsatelite->get_permisos_opcion();
        $data['list_prov'] = $this->get_prov_dropdown_che_con($where);
        $this->_cargarvista($data);
    }

    /**
     * @author Elman Ortiz
     * Descripcion: Devuelve array con los proveedores que tienen documentos pendientes de pago
     */
    function get_prov_dropdown_che_con($where)
    {
        $opt_prov;
        $list_prov = $this->utm_model->get_prov_che_con($where);
        foreach ($list_prov  as $key => $value) {
            $opt_prov[$key]['idprov'] = $value['prv_id'];
            if ($value['prv_tipo_pers'] == 1) { //Si es persona  lleva nombre apellido
                $opt_prov[$key]['nombreprov'] = $value['prv_id'] . '-' . $value['prv_nombre'] . ' ' . $value['prv_apellido'];
            } else { //Si es empresa solo lleva apellido
                $opt_prov[$key]['nombreprov'] = $value['prv_id'] . '-' . $value['prv_apellido'];
            }
        }
        return $opt_prov;
    }

    /**
     * @author Elman Ortiz
     * Descripcion: Devuelve array con los proveedores que tienen documentos pendientes de pago
     */
    function ajax_get_cheque_pendxprov($where = null)
    {
        $prv_id = $this->input->post('prv_id');

        $fecha_desde = $this->input->post('fecha_desde');
        $fecha_desde = ($fecha_desde) ? formatear_fecha('Y-m-d H:i:s', $fecha_desde) : '';

        $fecha_hasta = $this->input->post('fecha_hasta');
        $fecha_hasta = ($fecha_hasta) ? formatear_fecha('Y-m-d H:i:s', $fecha_hasta . " 23:59:59") : '';
        if ((!empty($fecha_desde)) && (!empty($fecha_hasta))) {
            $where = array(
                'chp_generado' => 0, 'chp_estado' => 1, 'dpv_id_prv' => $prv_id,
                'chp_fecha >= ' => $fecha_desde, 'chp_fecha <=' => $fecha_hasta
            );
        } else {
            if ((empty($fecha_desde)) && (empty($fecha_hasta))) {
                $where = array('chp_generado' => 0, 'chp_estado' => 1, 'dpv_id_prv' => $prv_id);
            } else {
                if (empty($fecha_desde)) {
                    $where = array(
                        'chp_generado' => 0, 'chp_estado' => 1, 'dpv_id_prv' => $prv_id,
                        'chp_fecha <=' => $fecha_hasta
                    );
                } else {
                    $where = array(
                        'chp_generado' => 0, 'chp_estado' => 1, 'dpv_id_prv' => $prv_id,
                        'chp_fecha >=' => $fecha_desde
                    );
                }
            }
        }
        //print_r($where); die();
        //$where = array('chp_generado' => 0, 'chp_estado' => 1, 'dpv_id_prv' => $prv_id);
        $data['che_prov'] = $this->utm_model->get_cheque_pendiente_proveedor($where);
        $html = $this->load->view('utm/cuentas/grid_body_cheque_proveedor', $data, true);

        echo json_encode(array('datos' => $html));
    }


    /**
     * @author Luis Navarro
     * @fecha: 23/03/2018
     * @descripcion: Retorna la vista para agregar cuenta bancaria
     */
    function agregar_cuenta_bancaria()
    {
        satelite_validar();
        if ($this->input->post()) {
            // print_r($_POST);die();
            /**** Datos recibidos POST ****/
            $slcBanco         = (trim($this->input->post('slcBanco')) != '') ? $this->input->post('slcBanco') : NULL;
            $txtNumeroCuenta  = (trim($this->input->post('txtNumeroCuenta')) != '') ? $this->input->post('txtNumeroCuenta') : NULL;
            $slcTipoCuenta    = (trim($this->input->post('slcTipoCuenta')) != '') ? $this->input->post('slcTipoCuenta') : NULL;
            $txtNombreCuenta  = (trim($this->input->post('txtNombreCuenta')) != '') ? $this->input->post('txtNombreCuenta') : NULL;
            $txtFechaApertura = $this->input->post('txtFechaApertura');
            //$txtSaldoActual   = $this->input->post('txtSaldoActual');
            $txtSaldInicial   = $this->input->post('txtSaldInicial');
            $txtSaldMinimo    = $this->input->post('txtSaldMinimo');
            $slcOrigenFondos  = (trim($this->input->post('slcOrigenFondos')) != '') ? $this->input->post('slcOrigenFondos') : NULL;
            $slcChequeDefecto = (trim($this->input->post('slcChequeDefecto')) != '') ? $this->input->post('slcChequeDefecto') : NULL;
            /* *** Datos POST Array **** */
            $centro_costo_cec    = $this->input->post('centro_costo_cec');
            $tipo_cuenta_tcn     = $this->input->post('tipo_cuenta_tcn');
            $cuenta_contable_cnt = $this->input->post('cuenta_contable_cnt');
            /* *************************** */

            /* **** DATOS a Guardar **** */
            $datos_cuenta_bancaria = array(
                'cub_id_ban'    => $slcBanco,
                'cub_id_orf'    => $slcOrigenFondos,
                'cub_id_tpc'    => $slcTipoCuenta,
                'cub_numero'    => $txtNumeroCuenta,
                'cub_nombre'    => $txtNombreCuenta,
                'cub_saldo_inicial' => $txtSaldInicial,
                'cub_saldo_minimo'  => (trim($txtSaldMinimo) != '') ? $txtSaldMinimo : NULL,
                'cub_fecha'     => formatear_fecha('Y-m-d', $txtFechaApertura),
                'cub_saldo'     => $txtSaldInicial,
                'cub_tipo_defecto' => $slcChequeDefecto,
                'cub_permite_sobregiro' => (trim($this->input->post('chkPermiteSobregiro')) == '1') ? 1 : 0,
                'cub_monto_sobregiro' => (trim($this->input->post('txtMontoSobgiro')) != '') ? $this->input->post('txtMontoSobgiro') : 0,
                'cub_estado'    => 1,
                'cub_usu_mod'   => $this->tank_auth->get_user_id(),
                'cub_fecha_mod' => date('Y-m-d H:i:s')
            );
            /* **** Insercion *****/
            // Ficha Generales
            $id_cuenta_bancaria = $this->gsatelite->ingresar('cub_cuenta_bancaria', $datos_cuenta_bancaria);

            // Ficha Finanzas
            for ($x = 0; $x < count($centro_costo_cec); $x++) {
                if (trim($centro_costo_cec[$x]) != "" && trim($tipo_cuenta_tcn[$x]) != "" && trim($cuenta_contable_cnt[$x]) != "") {
                    $datos_cuentas_contables = array(
                        'cxb_id_cec'             => $centro_costo_cec[$x],
                        'cxb_id_cnt'             => $cuenta_contable_cnt[$x],
                        'cxb_id_tcn'             => $tipo_cuenta_tcn[$x],
                        'cxb_id_cub'             => $id_cuenta_bancaria,
                        'cxb_estado'             => 1,
                        'cxb_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'cxb_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'cxb_usu_creacion'       => $this->tank_auth->get_user_id(),
                        'cxb_fecha_creacion'     => date('Y-m-d H:i:s')
                    );
                    $reg_detalle = $this->gsatelite->ingresar('cxb_cuentaxcuenta_bancaria', $datos_cuentas_contables);
                }
            }

            if ($id_cuenta_bancaria > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registros procesados", 'texto_alerta' => "Registros procesados correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error de inserción", 'texto_alerta' => "El registro no pudo ser procesado");
            }
            $this->session->set_flashdata($alerta);

            $tipo_btn =  $this->input->post('btn_enviar');
            if ($tipo_btn == 1) {
                redirect('utm/cuentas/agregar_cuenta_bancaria');
            } else { //Regresar a la lista
                redirect('utm/cuentas/cuentas_bancarias');
            }
        } else {
            /* ************************************** Tab Generales ************************************** */
            // Catalogo de Bancos
            $select = $this->gsatelite->get_dropdown('ban_banco', '{ban_nombre}', '', array('ban_estado' => 1), null, '', 'ban_id', true);
            $data["bancos"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            // Catalogo de Tipos de Cuentas
            $select = $this->gsatelite->get_dropdown('tpc_tipo_cuenta', '{tpc_nombre}', '', array('tpc_estado' => 1), null, '', 'tpc_id', true);
            $data["tipo_cuenta_bancaria"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            // Catalogos de Origen de Fondos
            $select = $this->gsatelite->get_dropdown('orf_origen_fondos', '{orf_nombre}', '', array('orf_estado' => 1), null, '', 'orf_id', true);
            $data["origen_fondos"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            /* ******************************************************************************************* */

            /* ************************************** Tab Finanzas ************************************** */
            // centro de costo
            $select = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            // tipo de cuenta
            $select = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
            $data["tipo_cuenta"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            // cuenta contable
            $select = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
            $data["cuen_con"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            /* ******************************************************************************************* */
            $data['titulo_personal'] = "Agregar Cuenta Bancaria";
            $this->_cargarvista($data);
        }
    }

    /**
     * @author Luis Navarro
     * @fecha: 24/03/2018
     * @descripcion: Funcion para validar si existe la cuenta bancaria
     */
    function validar_numero_cuenta_bancaria()
    {
        satelite_validar(true);
        if ($this->input->post()) {
            $numero_bancaria = $this->input->post('numero_cuenta');
            $cuentas         = $this->gsatelite->get_tabla('cub_cuenta_bancaria', array('cub_numero' => $numero_bancaria, 'cub_estado' => 1));

            echo json_encode(array('cantidad_cub' => count($cuentas), 'cuentas' => $cuentas));
            die();
        }
    }

    /**
     * @author Luis Navarro
     * @fecha: 26/03/2018
     * @descripcion: Funcion para retornar la vista de editar cuentas bancarias
     */
    function editar_cuenta_bancaria($cuenta = null, $opcion = null)
    {
        satelite_validar();
        if ($cuenta != null) {
            if ($this->input->post()) {
                // print_r($_POST);die();
                /**** Datos recibidos POST ****/
                $slcBanco         = (trim($this->input->post('slcBanco')) != '') ? $this->input->post('slcBanco') : NULL;
                $txtNumeroCuenta  = (trim($this->input->post('txtNumeroCuenta')) != '') ? $this->input->post('txtNumeroCuenta') : NULL;
                $slcTipoCuenta    = (trim($this->input->post('slcTipoCuenta')) != '') ? $this->input->post('slcTipoCuenta') : NULL;
                $txtNombreCuenta  = (trim($this->input->post('txtNombreCuenta')) != '') ? $this->input->post('txtNombreCuenta') : NULL;
                $txtFechaApertura = $this->input->post('txtFechaApertura');
                $txtSaldoActual   = $this->input->post('txtSaldoActual');
                $txtSaldInicial   = $this->input->post('txtSaldInicial');
                $txtSaldMinimo    = $this->input->post('txtSaldMinimo');
                $slcEstado        = $this->input->post('slcEstado');
                $slcOrigenFondos  = (trim($this->input->post('slcOrigenFondos')) != '') ? $this->input->post('slcOrigenFondos') : NULL;
                $slcChequeDefecto = (trim($this->input->post('slcChequeDefecto')) != '') ? $this->input->post('slcChequeDefecto') : NULL;
                /* *** Datos POST Array **** */
                $centro_costo_cec    = $this->input->post('centro_costo_cec');
                $tipo_cuenta_tcn     = $this->input->post('tipo_cuenta_tcn');
                $cuenta_contable_cnt = $this->input->post('cuenta_contable_cnt');

                /* **** DATOS a Guardar **** */
                $datos_cuenta_bancaria = array(
                    'cub_id_ban'    => $slcBanco,
                    'cub_id_orf'    => $slcOrigenFondos,
                    'cub_id_tpc'    => $slcTipoCuenta,
                    'cub_numero'    => $txtNumeroCuenta,
                    'cub_nombre'    => $txtNombreCuenta,
                    'cub_saldo_inicial' => $txtSaldInicial,
                    'cub_saldo_minimo'  => (trim($txtSaldMinimo) != '') ? $txtSaldMinimo : NULL,
                    'cub_fecha'     => formatear_fecha('Y-m-d', $txtFechaApertura),
                    'cub_saldo'     => $txtSaldInicial,
                    'cub_tipo_defecto' => $slcChequeDefecto,
                    'cub_permite_sobregiro' => (trim($this->input->post('chkPermiteSobregiro')) == '1') ? 1 : 0,
                    'cub_monto_sobregiro' => (trim($this->input->post('txtMontoSobgiro')) != '') ? $this->input->post('txtMontoSobgiro') : 0,
                    'cub_estado'    => (is_numeric($slcEstado)) ? $slcEstado : 1,
                    'cub_usu_mod'   => $this->tank_auth->get_user_id(),
                    'cub_fecha_mod' => date('Y-m-d H:i:s')
                );
                $consulta_cub = $this->gsatelite->actualizar_array('cub_cuenta_bancaria', $datos_cuenta_bancaria, array('cub_id' => $cuenta));
                /* ************ Ficha de Finanzas *************** */
                //Se eliminan las cuentas asociadas
                $this->gsatelite->borrado_general('cxb_cuentaxcuenta_bancaria', array('cxb_id_cub' => $cuenta));
                for ($x = 0; $x < count($centro_costo_cec); $x++) {
                    if (trim($centro_costo_cec[$x]) != "" && trim($tipo_cuenta_tcn[$x]) != "" && trim($cuenta_contable_cnt[$x]) != "") {
                        $datos = array(
                            'cxb_id_cec'            => $centro_costo_cec[$x],
                            'cxb_id_cnt'            => $cuenta_contable_cnt[$x],
                            'cxb_id_tcn'            => $tipo_cuenta_tcn[$x],
                            'cxb_id_cub'            => $cuenta,
                            'cxb_estado'            => 1,
                            'cxb_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'cxb_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'cxb_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'cxb_fecha_creacion'    => date('Y-m-d H:i:s')
                        );
                        $reg_detalle = $this->gsatelite->ingresar('cxb_cuentaxcuenta_bancaria', $datos);
                    }
                }
                if ($consulta_cub > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro Actualizado", 'texto_alerta' => "El registro se ha modificado correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser modificado, verifique la informacion ingresada.");
                }
                $this->session->set_flashdata($alerta);
                $redireccion = $this->input->post('btn_enviar');
                if ($redireccion == 1) {
                    redirect('utm/cuentas/editar_cuenta_bancaria/' . $cuenta);
                } elseif ($redireccion == 2) {
                    redirect('utm/cuentas/cuentas_bancarias');
                }
            } else {
                // Obtener los datos
                $data['finanzas']        = $this->utm_model->get_cuentas_x_cuentas_bancarias(array('cxb_id_cub' => $cuenta));
                $data['cuenta_bancaria'] = $this->utm_model->get_cuentas_bancarias(array('cub_id' => $cuenta));
                $data['opcion']          = (isset($opcion) && $opcion > 0) ? $opcion : 0;
                //print_r($data['cuenta_bancaria']); die();
                /* **** Ficha Generales *** */
                $select         = $this->gsatelite->get_dropdown('ban_banco', '{ban_nombre}', '', array('ban_estado' => 1), $data['cuenta_bancaria'][0]['cub_id_ban'], '', 'ban_id', true);
                $data["bancos"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $select         = $this->gsatelite->get_dropdown('orf_origen_fondos', '{orf_nombre}', '', array('orf_estado' => 1), $data['cuenta_bancaria'][0]['cub_id_orf'], '', 'orf_id', true);
                $data["origen_fondos"]   = str_replace('<option value="0">Seleccione</option>', '', $select);
                $select         = $this->gsatelite->get_dropdown('tpc_tipo_cuenta', '{tpc_nombre}', '', array('tpc_estado' => 1), $data['cuenta_bancaria'][0]['cub_id_tpc'], '', 'tpc_id', true);
                $data["tipo_cuenta_ban"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                /* ****** Ficha de Finanza **** */
                //centro de costo
                $select = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
                $data["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                //tipo de cuenta
                $select = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
                $data["tipo_cuenta"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                //cuenta contable
                $select = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
                $data["cuen_con"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                $data['titulo_personal'] = "Gestión de Cuentas";
                $this->_cargarvista($data);
            }
        }
    }

    /**
     * @author Luis Navarro
     * @fecha: 26/03/2018
     * @descripcion: Funcion para retornar datos o registrar partidas
     */
    function generar_partida_contable_cheque($where = null, $groupby = null, $orderby = null, $info = null, $consolidada = false, $return = false)
    {
        // Configuraciones para los datos de la partida
        // Total debe
        $total_debe = 0.0000;
        // Total Haber
        $total_haber = 0.0000;
        // Cuenta por Defecto
        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        //Correlativo de la partida contable
        $correlativo_partida    = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo') + 1;
        //Determinar el origen de la partida
        $origen         = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_id' => 3));
        // Verificar si existe el origen, sino coloca null
        $orp_partida    = (count($origen) > 0) ? $origen[0]['orp_id'] : null;
        //Tipo de partida
        $tipo_partida   = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('EGRESOS'));
        // Consultar si existe el registro
        $consultar      = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $tipo_partida));
        if (count($consultar) > 0) {
            $id_tipo_partida = $tipo_partida;
            // Generador de Codigo para la partida contable
            $numero         = str_pad($correlativo_partida, 5, '0', STR_PAD_LEFT);
            $codigo         = $consultar[0]['tpd_prefijo'] . '-' . $numero;   // Codigo que tendra la partida
        }

        // Campos para Agrupar
        $groupby = (trim($groupby) != "") ? $groupby : null;
        // Campos para ordenar
        $orderby = (trim($orderby) != "") ? $orderby : null;
        // Campos para la busqueda
        $where   = (count($where) > 0) ? $where : null;
        // Obtener las cuentas contables para proveedor
        $proveedor_cnt = $this->utm_model->get_cuentas_x_proveedores_cheque($where, $groupby, $orderby);
        // Obtener las cuentas contables por bancos
        $bancos_cnt = $this->utm_model->get_cuentas_x_bancos_cheque($where, $groupby, $orderby);
        // Verificar si viene datos por info
        $proveedor_cnt = (isset($info['proveedor_cnt'])) ? $info['proveedor_cnt'] : $proveedor_cnt;
        $bancos_cnt    = (isset($info['bancos_cnt'])) ? $info['bancos_cnt'] : $bancos_cnt;

        // Retorna datos o guarda partidas
        if ($return) {
            // Retorna un arreglo con las cuentas tanto para proveedor y banco
            return array('proveedor_cuentas' => $proveedor_cnt, 'banco_cuentas' => $bancos_cnt);
            die();
        } else {
            $fecha_partida = (isset($info['che_fecha'])) ? $info['che_fecha'] : date('Y-m-d H:i:s');
            // Cargar datos si es consolidada
            if ($consolidada) {
                $concepto    = (isset($info['concepto'])) ? $info['concepto'] : '';
                $total_debe  = (isset($info['total_pct'])) ? $info['total_pct'] : 0;
                $total_haber = (isset($info['total_pct'])) ? $info['total_pct'] : 0;
            } else {
                // Concepto para la partida
                //Partida realizada para pago en cheque para Proveedor
                $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 16));
                if (count($pct_concepto) > 0) {
                    $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
                } else {
                    $pct_concepto = 'Concepto no definido';
                }

                $informacion = ($codigo != '') ? $pct_concepto . ' - ' . $codigo : $pct_concepto;
                $concepto    = (isset($proveedor_cnt[0]['che_concepto']) && trim($proveedor_cnt[0]['che_concepto']) != "") ? $proveedor_cnt[0]['che_concepto'] : $informacion;

                // Verificar si hay registros para realizar la partida
                if (count($proveedor_cnt) > 0 && count($bancos_cnt) > 0) {
                    // Asignar las cuentas de proveedor para obtener la suma total debe
                    $total_debe = (isset($info['total_pct'])) ? $info['total_pct'] : $proveedor_cnt[0]['che_monto'];

                    // Aignar las cuentas de Bancos
                    $total_haber = (isset($info['total_pct'])) ? $info['total_pct'] : $bancos_cnt[0]['che_monto'];
                }

                //Se obtiene la info del cheque si es individual

                if (isset($where['che_id'])) {
                    $data_cheque = $this->gsatelite->get_tabla('che_cheque', array('che_id' => $where['che_id']));

                    $fecha_partida = $data_cheque[0]['che_fecha'];

                    $concepto .= " - Cheque #" . $data_cheque[0]['che_numero'];

                    //Si esta asociado a un proveedor se coloca en el concepto
                    if ($data_cheque[0]['che_id_prv'] != null) {
                        $data_proveedor = $this->gsatelite->get_tabla('prv_proveedor', array('prv_id' => $data_cheque[0]['che_id_prv']));

                        $nombre_proveedor = ($data_proveedor[0]['prv_tipo_pers'] == 1) ? $data_proveedor[0]['prv_nombre'] . ' ' . $data_proveedor[0]['prv_apellido'] : $data_proveedor[0]['prv_apellido'];

                        $concepto .= " - " . $nombre_proveedor;

                        //Se verifica los detalles para anexar los numeros de documento en el concepto
                        $detalle_cheque = $this->utm_model->get_detalle_cheque(array('dch_id_che' => $where['che_id']));

                        $documentosCheque = implode(',', array_column($detalle_cheque, 'dpv_numero_documento'));

                        if ($documentosCheque != '') {
                            $concepto .= " - Facturas #" . $documentosCheque;
                        }
                    }
                    //Se obtienen las facturas del cheque


                }
            }
            // Proceso para Guardar la partida
            $array_partida = array(
                'pct_id_tpd'      => $id_tipo_partida,
                'pct_id_orp'      => $orp_partida,
                'pct_id_prc'      => (isset($info['periodo'])) ? $info['periodo'] : null,
                'pct_concepto'    => (isset($info['concepto'])) ? $info['concepto'] : $concepto,
                'pct_total'       => number_format($total_debe, 4, '.', ''),
                'pct_fecha'       => $fecha_partida, //date('Y-m-d H:i:s'),
                'pct_correlativo' => $correlativo_partida,
                'pct_codigo'      => (isset($codigo)) ? $codigo : null,
                'pct_estado'      => 1,
                'pct_fecha_crea'  => date('Y-m-d H:i:s'),
                'pct_usu_crea'    => $this->tank_auth->get_user_id(),
                'pct_fecha_mod'   => date('Y-m-d H:i:s'),
                'pct_usu_mod'     => $this->tank_auth->get_user_id()
            );
            // Se realiza el registro de la partida y se obtiene su ID
            $id_pct = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
            //Ingresar los detalles de la partida para proveedor
            if (count($proveedor_cnt) > 0) {
                foreach ($proveedor_cnt as $llave => $dato) {
                    $dpc_id_cnt    = ($dato['cnt_id'] > 0) ? $dato['cnt_id'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
                    $array_detalle = array(
                        'dpc_id_cnt'    => $dpc_id_cnt,
                        'dpc_id_pct'    => $id_pct,
                        'dpc_concepto'  => 'Pago a Proveedor',
                        'dpc_debe'      => number_format($dato['che_monto'], 4, '.', ''),
                        'dpc_haber'     => 0.00,
                        'dpc_estado'    => 1,
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                        'dpc_usu_crea'  => $this->tank_auth->get_user_id(),
                        'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                        'dpc_usu_mod'   => $this->tank_auth->get_user_id()
                    );
                    // Se realiza el registro del detalle de la partida
                    $detalle_debe = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                }
            }
            //Ingresar los detalles de la partida para Bancos
            if (count($bancos_cnt) > 0) {
                foreach ($bancos_cnt as $llave => $dato) {
                    $dpc_id_cnt    = ($dato['cnt_id'] > 0) ? $dato['cnt_id'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
                    $array_detalle = array(
                        'dpc_id_cnt'    => $dpc_id_cnt,
                        'dpc_id_pct'    => $id_pct,
                        'dpc_concepto'  => 'Pago a Proveedor',
                        'dpc_debe'      => 0.00,
                        'dpc_haber'     => number_format($dato['che_monto'], 4, '.', ''),
                        'dpc_estado'    => 1,
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                        'dpc_usu_crea'  => $this->tank_auth->get_user_id(),
                        'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                        'dpc_usu_mod'   => $this->tank_auth->get_user_id()
                    );
                    // Se realiza el registro del detalle de la partida
                    $detalle_haber = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                }
            }
            // Retornar datos de la partida
            return array('id_pct' => $id_pct, 'total_debe' => $total_debe, 'total_haber' => $total_haber);
        }
    }

    /**
     * @author Luis Navarro
     * @fecha: 26/03/2018
     * @descripcion: Funcion para retornar las facturas por proveedor
     */
    public function get_factura_x_proveedor()
    {
        $where     = null;
        $proveedor = (trim($this->input->post('proveedor')) != "") ? $this->input->post('proveedor') : null;

        if ($proveedor != "") {
            $where['dpv_id_prv'] = $proveedor;
            $where['dpv_pagado'] = 0;
        }
        $facturas_emitidas = $this->gsatelite->get_tabla('chp_cheque_pendiente', array('chp_estado' => 1, 'chp_id_dpv != NULL ' => NULL));

        $where['dpv_estado'] = 1;
        $documentos = $this->utm_model->get_factura_like(null, $where, 'dpv_id', $facturas_emitidas);
        $html = '<option value=""></option>';
        $pendiente = 0;
        if (count($documentos) > 0) {
            foreach ($documentos as $dpv) {
                if ($dpv['cheques_pendientes'] == 0) {
                    if ($dpv['pendiente'] != '' && $dpv['pendiente'] > 0) {
                        $pendiente = floatval($dpv['pendiente']);
                    } else {
                        $pendiente = floatval($dpv['dpv_monto_pendiente']);
                    }
                    $html .= '<option data-documento="' . $dpv['dpv_numero_documento'] . '" value="' . $dpv['dpv_id'] . '">' . $dpv['dpv_numero_documento'] . ' - $' . number_format($pendiente, 2) . '</option>';
                }
            }
        }

        echo json_encode($html);
    }

    /**
     * @author:      Nelson Soriano
     * @since:       17/04/2019
     * @Descripcion: Plantilla html para preseleccionar las conciliaciones en la vista
     */
    public function conciliacion_excel()
    {
        //Recibimos la plantilla excel
        if ($_FILES) {
            $this->load->library('excel/excel_reader.php');
            $excel = new Excel_reader;
            $excel->read($_FILES["excel_plantilla"]["tmp_name"]);

            $nr_sheets   = count($excel->sheets);
            $excel_data  = '';
            $contador    = 1;
            for ($i = 0; $i < $nr_sheets; $i++) {
                if ($excel->sheets[$i]['numCols'] == 3) {
                    for ($j = 1; $j <= count($excel->sheets[$i]['cells']); $j++) {
                        if ($j > 1) {
                            echo '<tr style="text-align:center;font-weight:bold;font-size:12px;"><td style="border: 1px solid #c4c4c4">' . $contador . '</td><td style="border: 1px solid #c4c4c4"><input  type="text" value="' . $excel->sheets[$i]['cells'][$j][1] . '"  class="cuentax_' . $contador . ' cuentax  tables-input " readonly/></td>';
                            echo '<td style="border: 1px solid #c4c4c4"><input type="text" value="' . $excel->sheets[$i]['cells'][$j][2] . '"  class="referenciax_' . $contador . ' referenciax  tables-input " readonly/></td>';
                            echo '<td style="border: 1px solid #c4c4c4"><input type="text" value="$' . $excel->sheets[$i]['cells'][$j][3] . '"  class="montox_' . $contador . ' montox  tables-input " readonly/>';
                            $contador++;
                            $cuenta   = trim($excel->sheets[$i]['cells'][$j][1]);
                            $ref      = trim($excel->sheets[$i]['cells'][$j][2]);
                            $monto    = number_format(trim($excel->sheets[$i]['cells'][$j][3]), 2, '.', '');
                            $busqueda = $cuenta . $ref . $monto;
                            echo '<input type="hidden" class="valores_to_compare" value="' . $busqueda . '"></td></tr>';
                        }
                    }
                } else {
                    $excel_data .= '<tr><td colspan="3"><center><h4>(<em>' . $excel->boundsheets[$i]['name'] . '</em>)</h4></center></td><center><h4>';
                    $excel_data .= '<tr><td colspan="3"><center>La hoja actual no cumple con el formato de columnas: <br/> "[CUENTA][REFERENCIA][MONTO]"</h4></center</td></tr>';
                    $excel_data .= '<tr><td colspan="3"><h4>Favor revisar documento de excel y cantidad de columnas</h4></center><br/></td></tr>';
                }
            }
            echo $excel_data;
        }
    }

    function conciliacion($consulta = null)
    {
        $permisos = $this->gsatelite->get_permisos_opcion();
        if ($_POST) {
            if ($consulta != null) {

                $post_array = $this->input->post();
                $data = null;

                $cuenta         = $post_array['cuenta'];
                $estado         = $post_array['estado'];
                $fecha_inicio   = $this->input->post('fecha_inicio');
                $fecha_fin      = $this->input->post('fecha_fin');

                $where = null;

                if ($cuenta > 0) {
                    $where['cub_id'] = $cuenta;
                }
                if ($estado != '') {
                    $where['tra_conciliado'] = $estado;
                }
                if ($fecha_inicio != "" &&  $fecha_fin != "") {
                    $where['DATE(tra_fecha) >='] = date('Y-m-d', strtotime($fecha_inicio));
                    $where['DATE(tra_fecha) <='] = date('Y-m-d', strtotime($fecha_fin));
                }
                $data['conciliaciones'] = $this->utm_model->get_conciliaciones($where);
                $html = $this->load->view('utm/transacciones/consultar_conciliaciones', $data, true);
                echo $html;
                die();
            }
        } else {
            //$cuentas[0] = 'Seleccione';
            foreach ($this->db->get('vw_cuentas_bancarias')->result() as $row) {
                $cuentas[$row->cub_id] = $row->cuenta;
            }
            $data = array(
                'cuentas' => $cuentas
            );
            $where = array(
                'tra_conciliado'    => 0,
                'DATE(tra_fecha)'   => date('Y-m-d')
            );
            //se definio que no debe de precargar informacion 29/06/2018
            $data['conciliaciones'] = null;
            $data['titulo_personal'] = "Conciliación";
            $data['permisos'] = $permisos;
            cargarvista($data, null, 'utm/transacciones/conciliacion');
            //$this->_cargarvista($data);
        }
    }

    function _format_date2($valor)
    {
        $date = new DateTime($valor);
        return $date->format('d-m-Y H:i:s');
    }

    function transacciones($cub_id = 0)
    {
        $crud = new grocery_CRUD;
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('tra_transaccion');
        $crud->set_subject('Transacción');
        $crud->unset_edit();
        $crud->columns('tra_fecha', 'tra_id_cub', 'tra_id_ttb', 'Número de cheque', 'tra_monto', 'Saldo'); //'Orden', 
        $crud->fields('tra_id_cub', 'tra_fecha', 'tra_id_ttb', 'tra_monto');
        $crud->display_as('tra_id_cub', 'Cuenta Bancaria')
            ->display_as('tra_id_ttb', 'Tipo')
            ->display_as('tra_fecha', 'Fecha de transacción')
            ->display_as('tra_monto', 'Monto')
            ->display_as('Orden', 'Nº')
            ->callback_column('tra_fecha', array($this, '_format_date2'))
            // ->callback_column('Orden', function($key, $row) {
            //     $cub = $row->tra_id_cub;
            //     $fila = $row->tra_id;
            //     $query = $this->db->query("select COUNT(*) orden from tra_transaccion where tra_id_cub = $cub and tra_id <= $fila")->row_array();
            //     return $query["orden"];
            // })
            ->callback_column('Número de cheque', function ($key, $row) {
                $fila = $row->tra_id;
                $query = $this->db->query("SELECT che_numero from che_cheque where che_id_tra = $fila")->row_array();
                return (count($query) > 0) ? $query["che_numero"] : '';
            })
            /* --------------------Inicia calculo saldo-------------- */
            ->callback_column('Saldo', function ($key, $row) {
                $cuenta = $row->tra_id_cub;
                $tra_fecha = formatear_fecha('Y-m-d H:i:s', $row->tra_fecha);
                // $monto_tran = $row->tra_monto;
                // $monto = number_format($monto_tran, 2);
                // $dbl_monto = number_format($monto_tran, 2);
                $query = $this->db->select('saldo, tra_monto, MAX(tra_fecha), cub_saldo_inicial, SUM(tra_monto) as suma')
                    ->from('vw_cuentas_bancarias')
                    ->join('tra_transaccion', 'vw_cuentas_bancarias.cub_id=tra_transaccion.tra_id_cub')
                    ->join('cub_cuenta_bancaria', 'tra_id_cub=cub_cuenta_bancaria.cub_id')
                    ->where('tra_id_cub', $cuenta)
                    ->where('tra_fecha <=', $tra_fecha)
                    ->get();
                $resultado = $query->row_array();
                // var_dump($resultado);
                // var_dump($this->db->last_query());die();
                $sld = ($resultado['cub_saldo_inicial'] + $resultado['suma']);
                $saldo_final = number_format($sld, 2);
                return $saldo_final;
            });
        ///***************** Primer y Último día del mes  ************************///
        $mes = date('m');
        $year = date('Y');
        $dia = date("d", mktime(0, 0, 0, $mes + 1, 0, $year));
        $primer_dia = date('Y-m-d', mktime(0, 0, 0, $mes, 1, $year));
        $ultimo_dia = date('Y-m-d', mktime(0, 0, 0, $mes, $dia, $year));
        /************************************************************************ */
        if ($this->input->post()) {
            $cub_id = ($this->input->post('cub_id') > 0) ? $this->input->post('cub_id') : $cub_id;
            $crud->where('tra_id_cub', $cub_id);
            if ($this->input->post('fecha_desde') != '' && $this->input->post('fecha_hasta') != '') {
                $fecha_desde = $this->input->post('fecha_desde');
                $fecha_hasta = $this->input->post('fecha_hasta');
                $fecha_desde1 = formatear_fecha('Y-m-d', $fecha_desde) . ' 00:00:00';
                $fecha_hasta1 = formatear_fecha('Y-m-d', $fecha_hasta) . ' 23:23:59';
                $primer_dia = formatear_fecha('d-m-Y', $fecha_desde1);
                $ultimo_dia = formatear_fecha('d-m-Y', $fecha_hasta1);
                $crud->where('tra_fecha >= ', $fecha_desde1);
                $crud->where('tra_fecha <= ', $fecha_hasta1);
            }
        } else {
            if ($cub_id > 0) {
                $crud->where('tra_id_cub', $cub_id);
            }
            $fecha_desde1 = formatear_fecha('Y-m-d', $primer_dia) . ' 00:00:00';
            $fecha_hasta1 = formatear_fecha('Y-m-d', $ultimo_dia) . ' 23:23:59';
            $crud->where('tra_fecha >= ', $fecha_desde1);
            $crud->where('tra_fecha <= ', $fecha_hasta1);
        }
        $crud->set_primary_key('cub_id', 'vw_cuentas_bancarias')
            ->set_relation('tra_id_cub', 'vw_cuentas_bancarias', 'cuenta');
        $crud->set_relation('tra_id_ttb', 'ttb_tipo_transact_bancaria', 'ttb_nombre');
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if ($permisos['permite_editar']) {
            $crud->add_action('Editar', '', 'utm/cuentas/editar_transaccion', 'icomoon-icon-pencil-5');
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Imprimir', '', 'utm/reporteria/informe_transaccion', 'icomoon-icon-printer imp');
        }
        $crud->unset_read();
        $crud->set_language('spanish');
        $crud->unset_print();
        $crud->unset_export();
        $output = $crud->render();
        $cuentas[0] = 'Seleccione';
        foreach ($this->db->get('vw_cuentas_bancarias')->result() as $row) {
            $cuentas[$row->cub_id] = $row->cuenta;
        }
        $data = array(
            'cuentas' => $cuentas,
            'titulo_personal' => "Transacción"
        );
        $data['cub_id'] =  $cub_id;
        $data['primer_dia'] = formatear_fecha('d-m-Y', $primer_dia);
        $data['ultimo_dia'] = formatear_fecha('d-m-Y', $ultimo_dia);
        $this->_cargarvista($data, $output);
    }

    function editar_transaccion($id_trans, $ver = null)
    {
        //tipo_cuenta
        $tipo_cuentas[0] = 'seleccione';
        $transaccion = $this->gsatelite->get_tabla('tra_transaccion', array('tra_id' => $id_trans));
        $id_cub = $transaccion[0]['tra_id_cub'];
        $id_ttb = $transaccion[0]['tra_id_ttb'];
        /*         * ******* cuentas en caso de mostrar un dropdown ***************** */
        $cuentas[0] = 'Seleccione';
        foreach ($this->db->get('vw_cuentas_bancarias')->result() as $row) {
            $cuentas[$row->cub_id] = $row->cuenta . "  ($ $row->saldo )";
        }
        /*         * **************************************************************** */

        $cub_select = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $id_cub))->row();
        $cuenta_select = $cub_select->cuenta . "  ($ $cub_select->saldo )";
        //Tipo de transacción seleccionada
        // $this->db->where('ttb_id = 1 OR ttb_id = 2');
        $tipos = $this->gsatelite->get_tabla('ttb_tipo_transact_bancaria', array('ttb_estado' => 1));

        $data = array(
            'cuentas' => $cuentas,
            'tipos' => $tipos,
            'cub' => $id_cub,
            'id_ttb' => $id_ttb,
            'transaccion' => $transaccion,
            'id_trans' => $id_trans,
            'cub_selec' => $cuenta_select
        );
        $data['ver'] = ($ver != null) ? 'disabled="disabled"' : '';
        if ($ver != null) {
            $data['titulo_personal'] =  "Ver transacción";
            $this->gsatelite->cargar_vista_masterpage('utm/transacciones/editar_transaccion', $data, true);
        } else {
            $data['titulo_personal'] = "Editar transacción";
            cargarvista($data, null, 'utm/transacciones/editar_transaccion');
        }
    }

    function tra_transferencia()
    {
        //tipo_cuenta
        $this->load->model('consultas');
        $tipo_cuentas[0] = 'seleccione';

        //cuentas
        $cuentas[0] = 'Seleccione';
        foreach ($this->db->get('vw_cuentas_bancarias')->result() as $row) {
            $cuentas[$row->cub_id] = $row->cuenta . "  ($ $row->saldo )";
        }

        //Tipos
        $tipos = $this->gsatelite->get_tabla('ttb_tipo_transact_bancaria', array('ttb_estado' => 1));

        $data = array(
            'cuentas' => $cuentas,
            'tipos' => $tipos,
            'titulo_personal' => "Agregar transacción"
        );

        //************
        $data['cuenta'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
        $select_drop = $this->gsatelite->get_dropdown('tpd_tipo_partida', '{tpd_nombre}', '', array('tpd_estado' => 1), null, null, null, true);
        $data['tipo'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select_drop);

        $ano_actual         = date('Y'); // Quemadp
        $mes_actual         = date('m'); // Quemado
        $data['periodo']    = $this->gsatelite->get_tabla('prc_periodo_contable', array('prc_estado' => 1)); //'prc_ano' => $ano_actual, 'prc_mes' => $mes_actual, // Se omitieron parametros para que solo muestre el activo

        cargarvista($data, null, 'utm/transacciones/tra_transferencia');
    }

    /*******************************************************************/
    /**
     * @author Elman Ortiz
     * @fecha: 27/03/2018
     * @descripcion: Funcion para retornar datos o registrar partidas para notas de abono
     * deprecado: 27/03/2019
     */
    function generar_partida_contable_nota_abono($where = null, $groupby = null, $orderby = null, $info = null, $consolidada = false, $return = false, $info_extra = false)
    {
        // Configuraciones para los datos de la partida

        $where2['cub_id'] = $info_extra['cub_id'];
        // print_r($where2);die();
        // Total debe
        $total_debe = 0.0000;
        // Total Haber
        $total_haber = 0.0000;
        // Cuenta por Defecto
        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        //Correlativo de la partida contable
        $correlativo_partida    = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo') + 1;
        //Determinar el origen de la partida
        $origen         = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_id' => 3));
        // Verificar si existe el origen, sino coloca null
        $orp_partida    = (count($origen) > 0) ? $origen[0]['orp_id'] : null;
        //Tipo de partida
        $tipo_partida   = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('EGRESOS'));
        // Consultar si existe el registro
        $consultar      = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $tipo_partida));

        if (count($consultar) > 0) {
            $id_tipo_partida = $tipo_partida;
            // Generador de Codigo para la partida contable
            $numero         = str_pad($correlativo_partida, 5, '0', STR_PAD_LEFT);
            $codigo         = $consultar[0]['tpd_prefijo'] . '-' . $numero;   // Codigo que tendra la partida
        }
        // Campos para Agrupar
        $groupby = (trim($groupby) != "") ? $groupby : null;
        // Campos para ordenar
        $orderby = (trim($orderby) != "") ? $orderby : null;
        // Campos para la busqueda
        $where   = (count($where) > 0) ? $where : null;
        // Obtener las cuentas contables para proveedor
        $proveedor_cnt = $this->utm_model->get_cuentas_x_proveedores_nota_abono($where, $groupby, $orderby);
        // Obtener las cuentas contables por bancos
        $bancos_cnt = $this->utm_model->get_cuentas_x_bancos_nota_abono($where, $groupby, $orderby, $where2);
        //print_r($proveedor_cnt); die();
        // Verificar si viene datos por info
        $proveedor_cnt = (isset($info['proveedor_cnt'])) ? $info['proveedor_cnt'] : $proveedor_cnt;
        $bancos_cnt    = (isset($info['bancos_cnt'])) ? $info['bancos_cnt'] : $bancos_cnt;

        // Retorna datos o guarda partidas
        if ($return) {
            // Retorna un arreglo con las cuentas tanto para proveedor y banco
            // print_r($proveedor_cnt);
            // print_r($bancos_cnt);
            // die();
            return array('proveedor_cuentas' => $proveedor_cnt, 'banco_cuentas' => $bancos_cnt);
            die();
        } else {
            // Cargar datos si es consolidada
            if ($consolidada) {
                $concepto    = (isset($info['concepto'])) ? $info['concepto'] : '';
                $total_debe  = (isset($info['total_pct'])) ? $info['total_pct'] : 0;
                $total_haber = (isset($info['total_pct'])) ? $info['total_pct'] : 0;
            } else {
                // Concepto para la partida
                //Partida realizada para pago en cheque para Proveedor
                $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 16));
                if (count($pct_concepto) > 0) {
                    $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
                } else {
                    $pct_concepto = 'Concepto no definido';
                }

                $informacion = $pct_concepto . ' - ' . $codigo;
                $concepto    = (isset($proveedor_cnt[0]['nta_concepto']) && trim($proveedor_cnt[0]['nta_concepto']) != "") ? $proveedor_cnt[0]['nta_concepto'] : $informacion;

                // Verificar si hay registros para realizar la partida
                if (count($proveedor_cnt) > 0 && count($bancos_cnt) > 0) {
                    // Asignar las cuentas de proveedor para obtener la suma total debe
                    $total_debe = (isset($info['total_pct'])) ? $info['total_pct'] : $proveedor_cnt[0]['nta_monto'];

                    // Aignar las cuentas de Bancos
                    $total_haber = (isset($info['total_pct'])) ? $info['total_pct'] : $bancos_cnt[0]['nta_monto'];
                }
            }

            // Proceso para Guardar la partida
            $array_partida = array(
                'pct_id_tpd'      => $id_tipo_partida,
                'pct_id_orp'      => $orp_partida,
                'pct_id_prc'      => (isset($info['periodo'])) ? $info['periodo'] : null,
                'pct_concepto'    => (isset($info['concepto'])) ? $info['concepto'] : $concepto,
                'pct_total'       => number_format($total_debe, 4, '.', ''),
                'pct_fecha'       => (isset($info['nta_fecha'])) ? $info['nta_fecha'] : date('Y-m-d H:i:s'),
                'pct_correlativo' => $correlativo_partida,
                'pct_codigo'      => (isset($codigo)) ? $codigo : null,
                'pct_estado'      => 1,
                'pct_fecha_crea'  => date('Y-m-d H:i:s'),
                'pct_usu_crea'    => $this->tank_auth->get_user_id(),
                'pct_fecha_mod'   => date('Y-m-d H:i:s'),
                'pct_usu_mod'     => $this->tank_auth->get_user_id()
            );

            // Se realiza el registro de la partida y se obtiene su ID
            $id_pct = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
            //Ingresar los detalles de la partida para proveedor
            if (count($proveedor_cnt) > 0) {
                foreach ($proveedor_cnt as $llave => $dato) {
                    $dpc_id_cnt    = ($dato['cnt_id'] > 0) ? $dato['cnt_id'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
                    $array_detalle = array(
                        'dpc_id_cnt'    => $dpc_id_cnt,
                        'dpc_id_pct'    => $id_pct,
                        'dpc_concepto'  => 'Pago a Proveedor',
                        'dpc_debe'      => number_format($dato['che_monto'], 4, '.', ''),
                        'dpc_haber'     => 0.00,
                        'dpc_estado'    => 1,
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                        'dpc_usu_crea'  => $this->tank_auth->get_user_id(),
                        'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                        'dpc_usu_mod'   => $this->tank_auth->get_user_id()
                    );
                    // Se realiza el registro del detalle de la partida
                    $detalle_debe = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                }
            }
            //Ingresar los detalles de la partida para Bancos
            if (count($bancos_cnt) > 0) {
                foreach ($bancos_cnt as $llave => $dato) {
                    $dpc_id_cnt    = ($dato['cnt_id'] > 0) ? $dato['cnt_id'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
                    $array_detalle = array(
                        'dpc_id_cnt'    => $dpc_id_cnt,
                        'dpc_id_pct'    => $id_pct,
                        'dpc_concepto'  => 'Partida Banco Transferencia Bancaria',
                        'dpc_debe'      => 0.00,
                        'dpc_haber'     => number_format($dato['che_monto'], 4, '.', ''),
                        'dpc_estado'    => 1,
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                        'dpc_usu_crea'  => $this->tank_auth->get_user_id(),
                        'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                        'dpc_usu_mod'   => $this->tank_auth->get_user_id()
                    );
                    // Se realiza el registro del detalle de la partida
                    $detalle_haber = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                }
            }
            // Retornar datos de la partida
            return array('id_pct' => $id_pct, 'total_debe' => $total_debe, 'total_haber' => $total_haber);
        }
    }


    function calcular_saldo_banco()
    {
        $banco  = $this->input->post('banco');
        $fecha_inicio = $this->input->post('fecha_inicio');
        $fecha_fin = $this->input->post('fecha_fin');
        $saldo  = 0;
        //Si vienen fechas se calcula el saldo a la fecha.
        if ($fecha_inicio != '' && $fecha_fin != '') {
            $where = array(
                'DATE(tra_fecha) <=' => formatear_fecha('Y-m-d', $fecha_fin),
                'tra_id_cub' => $banco
            );
            $saldo = $this->gsatelite->get_suma('tra_transaccion', 'tra_monto', $where);
            $saldo += $this->gsatelite->get_campo("cub_cuenta_bancaria", "cub_saldo_inicial", array("cub_id" => $banco));
        } else {
            $saldo = $this->gsatelite->get_campo("vw_cuentas_bancarias", "saldo", array("cub_id" => $banco));
        }

        echo ($saldo != "") ? $saldo : 0;
        die();
    }
    /*******************************************************************/
    //Obtiene las cuentas contables de gasto de acuerdo a la categoria del producto
    public function get_cuentas_contables_like_prorrateo()
    {
        $tipo_cuenta = ($this->input->post('tipo') != '') ? $this->input->post('tipo') : null;
        $cat_art = ($this->input->post('cat_art') != '') ? $this->input->post('cat_art') : null;

        $resultado = null;
        $arreglo = array();
        $html = "<option value=''></option>";

        $where = array(
            'cnt_estado' => 1
        );

        if ($tipo_cuenta != null) {
            //  $where['dta_id_tcn'] = $tipo_cuenta;
        }

        if ($cat_art) {
            $where['tia_id'] = $cat_art;
            $resultado = $this->utm_model->get_cuentas_like_prorrateo($where);
        } else {
            $resultado = [];
        }


        //print_r($this->db->last_query()); die();
        if (count($resultado) > 0) {
            foreach ($resultado as $key => $value) {
                $html .= "<option value='" . $value['cnt_id'] . "'>" . $value['cuenta_contable'] . "</option>";
            }
        }

        if (count($resultado) > 0) {
            echo json_encode($html);
        } else {
            echo json_encode($html);
        }
    }

    /**
     * @author René Castaneda
     * @since: 07/01/2019
     * @return: totalización masiva de las partida contables correspondientes a cheques.
     */
    public function generar_partida_masiva_cheque()
    {
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');

        //obtener los cheques y omitir los anulados.
        $query_registros = $this->gsatelite->get_tabla("che_cheque", array('che_id_pct is null  and che_id_prv is not NULL AND che_estado = 1' => null));
        $array_resultados = array();
        foreach ($query_registros as $fila) {
            //Generar partida de cheque
            $where['che_id'] = $fila['che_id'];
            $groupby         = 'che_id, cnt_id';
            $datos = $this->generar_partida_contable_cheque($where, $groupby, null, null, false, false);
            $this->gsatelite->actualizar_array('che_cheque', array('che_id_pct' => $datos['id_pct']), array('che_id' => $fila['che_id']));

            $array_resultados[] = array("id_che" => $fila['che_id'], "id_pct" => $datos['id_pct']);
        }

        echo json_encode(array('cantidad_partidas' => count($array_resultados)));
        die();
    }

    public function generar_partida_contable_cheque_planilla($idcheque_pendiente)
    {
        $where['chp_id'] = $idcheque_pendiente;
        $datos_cheque_conta = $this->contabilidad_model->get_cheque_pendiente_info($where);

        $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('GASTO'));
        $agregar_pct = 0;
        if ($datos_cheque_conta) {
            $tipo_abr   = $this->gsatelite->get_campo('tpd_tipo_partida', 'tpd_prefijo', array('tpd_id' => $tipo_partida));
            $corr       = $this->db->select('IFNULL(MAX(pct_correlativo)+1,1) as correlativo', false)->from('pct_partida_contable')->get()->row();

            $numero     = str_pad($corr->correlativo, 5, '0', STR_PAD_LEFT);
            $codigo     = $tipo_abr . '-' . $numero;

            //$modulo = $this->input->post('modulo');

            $array_partida = array(
                'pct_id_tpd'    => $tipo_partida,
                //'pct_id_prc'    => $tipo_partida,
                'pct_concepto'  => $datos_cheque_conta['concepto'],
                'pct_modulo'    => 5, //banco
                'pct_fecha'     => $datos_cheque_conta['che_fecha'],
                'pct_total'     => number_format($datos_cheque_conta['che_monto'], 2, '.', ''),
                'pct_estado'    => 1,
                'pct_fecha_crea' => date('Y-m-d H:i:s'),
                'pct_fecha_mod' => date('Y-m-d H:i:s'),
                'pct_usu_crea'  => $this->tank_auth->get_user_id(),
                'pct_usu_mod'   => $this->tank_auth->get_user_id(),
                'pct_correlativo' => $corr->correlativo,
                'pct_codigo'    => $codigo
            );

            $agregar_pct    = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);

            $array_detalle[] = array(
                'dpc_id_cnt'    => $datos_cheque_conta['cuenta_empleado'],
                'dpc_id_pct'    => $agregar_pct,
                'dpc_concepto' =>  $datos_cheque_conta['concepto'],
                'dpc_debe'      => $datos_cheque_conta['che_monto'],
                'dpc_haber'     => 0,
                'dpc_estado'    => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea'  => $this->tank_auth->get_user_id(),
                'dpc_usu_mod'   => $this->tank_auth->get_user_id()
            );

            $array_detalle[] = array(
                'dpc_id_cnt'    => $datos_cheque_conta['cuenta_banco'],
                'dpc_id_pct'    => $agregar_pct,
                'dpc_concepto' => $datos_cheque_conta['concepto'],
                'dpc_debe'      => 0,
                'dpc_haber'     => $datos_cheque_conta['che_monto'],
                'dpc_estado'    => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea'  => $this->tank_auth->get_user_id(),
                'dpc_usu_mod'   => $this->tank_auth->get_user_id()
            );

            $detalle    = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle, true);

            if ($agregar_pct > 0) {
                $this->gsatelite->actualizar_array('che_cheque', array('che_id_pct' => $agregar_pct), array('che_id' => $datos_cheque_conta['che_id']));
            }

            return $agregar_pct;
        }
    }

    function comprobante_cheque($id)
    {
        $this->db->join('chq_chequera', 'chq_id = che_id_chq');
        $this->db->join('cub_cuenta_bancaria', 'cub_id = chq_id_cub');
        $this->db->join('ban_banco', 'ban_id = cub_id_ban');
        $this->db->join('emp_empleado', 'emp_id_usu = che_usu_crea AND emp_estado = 1', 'left');
        $data['cheque'] = $this->gsatelite->get_tabla('che_cheque', array('che_id' => $id));
        // $data['cheque'] = $this->db->get_where('che_cheque', array('che_id' => $che_id))->result_array();

        $this->db->join('dpc_detalle_partida ', 'dpc_id_pct = pct_id');
        $this->db->join('cnt_cuenta_contable ', 'cnt_id = dpc_id_cnt');
        $data['partidas'] = $this->gsatelite->get_tabla('pct_partida_contable', array('pct_id' => $data['cheque'][0]['che_id_pct']));
        // print_r($data['partidas']);die();
        $data['dep_empresa'] = $this->gsatelite->get_parametro('SYS_DEPARTAMENTO');
        $data['empresa'] = $this->gsatelite->get_parametro('SYS_EMPRESA');

        $data['logo'] = $this->gsatelite->get_parametro('SYS_LOGOTIPO');

        $this->load->library('pdf');

        $html = $this->load->view('utm/cuentas/detalle_comprobante_cheque', $data, true);
        ////////////////// configuracion de pagina
        $fuente             = "calibrib";
        $size               = 8;
        $formato            = "Letter";
        $formato_array      = explode(",", $formato); //convierte el formato a array por si se quiere un formato personalizado de pagina
        $formato            = (count($formato_array) > 1) ? $formato_array : $formato; //si tiene mas de un elemento se toma el array y si no el valor del formato
        $orientacion        = "P";
        $setCellPaddings    = "0,0,0";
        $this->pdf->setPrintHeader(false);
        $this->pdf->SetFont($fuente);
        $this->pdf->setCellPaddings($setCellPaddings);
        $this->pdf->SetAutoPageBreak(true, 0);
        $this->pdf->SetMargins("0","0","0"); //274, 155
        $this->pdf->AddPage(
            $orientacion,
            $formato,
            array(
                'family' => $fuente,
                'style' => '',
                'size' => $size
            )
        );
        //////////////////
        $this->pdf->setPrintFooter(false);
        $this->pdf->writeHTML($html, true, false, false, false, '');
        $this->pdf->boletaPDF('I');
        // print_r($id);
    }

    /**
     * Cuentas::_cargarvista()
     * @param integer $data
     * @param integer $crud
     * @return
     */
    function _cargarvista($data = 0, $crud = 0)
    {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    /** 
     * @author Francisco Orozco
     * @since: 21/02/2019
     * Descripcion: Se obtienen los presupuestos que depende de un proyecto
     * @return presupuestos
     */
    public function get_presupuestoxproyecto($proyecto = "", $seleccionado = "", $evaluar_post = true)
    {
        if ($_POST && $evaluar_post) {
            $proyecto = ($this->input->post('proyecto') != false) ? $this->input->post('proyecto') : $proyecto;
        }
        $where = array(
            'psp_estado'            => 1,
            'psp_id_pcl'            => $proyecto,
            'psp_estado_prespuesto' => 2
        );
        $presupuestos   = $this->gsatelite->get_tabla("psp_presupuesto", $where);
        $html           = '<option value=""></option>';
        foreach ($presupuestos as $value) {
            $selected   = "";
            if ($value['psp_id'] == $seleccionado) {
                $selected = "selected";
            }
            $html .= '<option value="' . $value['psp_id'] . '" ' . $selected . '>' . $value['psp_nombre'] . '</option>';
        }
        if ($_POST && $evaluar_post) {
            echo trim($html);
        } else {
            return trim($html);
        }
    }

    /**
     * @author Francisco Orozco
     * @since: 21/02/2019
     * Descripcion: Se obtienen las actividades general de un presupuesto
     * @return actividades generales
     */
    function get_actividades_generalesxpresupusto($presupuesto = "", $seleccionado = "", $evaluar_post = true, $evaluar_usuario = true)
    {
        satelite_validar();
        if ($_POST && $evaluar_post) {
            $presupuesto = $this->input->post('presupuesto');
        }
        $where = array(
            'dps_estado'    => 1,
            'dps_id_psp'    => $presupuesto
        );
        $select                 = "*, 
            (
                sum(dps_presupuesto_actividad) - IFNULL(
                    (
                        SELECT
                            SUM(dgp_monto)
                        FROM
                            dgp_detalle_gasto_prespuesto
                        WHERE
                            dgp_id_dps = dps_id
                        AND dgp_estado = 1
                    ),
                    0
                )
            ) AS total,
            (
                SELECT
                    IFNULL(
                        (
                            sum(orc_total) - sum(dpv_total)
                        ) + sum(dpv_monto_pendiente),
                        0
                    )
                FROM
                    orc_orden_compra
                LEFT JOIN dpv_documento_proveedor ON dpv_id_orc = orc_id
                WHERE
                    orc_id_psp = dps_id_psp
                AND orc_id_acg = dps_id_acg
                AND dpv_id = NULL
            ) AS monto_comprometido,
            (
                SELECT
                    GROUP_CONCAT(uxa_id_usu)
                FROM
                    uxa_usuarioxactividad_general
                WHERE
                    uxa_id_acg = acg_id
            ) AS usuarios";
        $group_by               = "acg_id";
        $actividades_generales  = $this->compras_model->get_actividades_x_presupusto($select, $where, $group_by);

        $html                   = '<option value=""></option>';
        foreach ($actividades_generales as $value) {
            $selected           = "";
            $usuarios_permitidos = array($this->tank_auth->get_user_id());
            if ($evaluar_usuario == true) {
                $usuarios_permitidos = explode(",", $value['usuarios']);
            }

            $disponible = $value['total'] - $value['monto_comprometido'];
            if ($value['acg_id'] == $seleccionado) {
                $selected = "selected";
            }
            if (in_array($this->tank_auth->get_user_id(), $usuarios_permitidos)) {
                $html .= '<option value="' . $value['acg_id'] . '" ' . $selected . '>' . $value['acg_codigo'] . ' - ' . $value['acg_nombre'] . ' ($' . number_format($disponible, 2, ".", ",") . ')</option>';
            }
        }
        if ($_POST && $evaluar_post) {
            echo trim($html);
        } else {
            return trim($html);
        }
    }

    /**
     * @author Francisco Orozco
     * @since: 21/02/2019
     * Descripcion: Se obtienen las actividades especificas de un de una actividad general
     * @return actividades especificas
     */
    function get_actividades_especificas_x_actividad_general($general = "", $presupuesto = "", $seleccionado = "", $edicion = false, $evaluar_post = true)
    {
        satelite_validar();

        if ($_POST && $evaluar_post) {
            $general    = ($this->input->post('general') != false) ? $this->input->post('general') : $general;
            $presupuesto = ($this->input->post('presupuesto') != false) ? $this->input->post('presupuesto') : $presupuesto;
            $periodo    = ($this->input->post('fecha') != false) ? date('Ym', strtotime($this->input->post('fecha'))) : date('Ym');
            $fecha      = ($this->input->post('fecha') != false) ? date('Y-m-d', strtotime($this->input->post('fecha'))) : date('Y-m-d');
        } else {
            $periodo    = date('Ym');
            $fecha      = date('Y-m-d');
        }

        $where = array(
            'dps_estado'    => 1,
            'dps_id_psp'    => $presupuesto,
            'dps_id_acg'    => $general
        );
        $select                 = '*,
            (
                IFNULL(
                    (
                        SELECT
                            SUM(dgp_monto)
                        FROM
                            dgp_detalle_gasto_prespuesto
                        INNER JOIN dpv_documento_proveedor ON dpv_id = dgp_id_dpv
                        LEFT JOIN orc_orden_compra ON orc_id = dpv_id_orc
                        LEFT JOIN rxi_requisicion_inventario ON rxi_id = orc_id_rxi
                        WHERE
                            dgp_id_dps = dps_id
                        AND dgp_estado = 1
                    ),
                    0
                )
            ) AS utilizado,
            (
                sum(dps_presupuesto_actividad) - IFNULL(
                    (
                        SELECT
                            SUM(dgp_monto)
                        FROM
                            dgp_detalle_gasto_prespuesto
                        WHERE
                            dgp_id_dps = dps_id
                        AND dgp_estado = 1
                    ),
                    0
                )
            ) AS total,
            (
                SELECT
                    IFNULL(
                        (
                            sum(orc_total) - IFNULL(sum(dpv_total), 0)
                        ) + IFNULL(sum(dpv_monto_pendiente), 0),
                        0
                    )
                FROM
                    orc_orden_compra
                LEFT JOIN dpv_documento_proveedor ON dpv_id_orc = orc_id
                WHERE
                    orc_id_psp = dps_id_psp
                AND orc_id_ace = dps_id_ace
            ) AS monto_comprometido,
            (
                SELECT
                    pcp_monto
                FROM
                    pcp_plan_compra_presupuesto
                WHERE
                    pcp_estado = 1
                AND pcp_id_dps = dps_id
                AND "' . $periodo . '" = pcp_periodo
            ) AS permitido,
            (
                SELECT
                    IFNULL(sum(orc_total), 0)
                FROM
                    orc_orden_compra
                WHERE
                    orc_id_psp = dps_id_psp
                AND orc_id_ace = dps_id_ace
                AND orc_fecha_orden >= DATE_FORMAT("' . $fecha . '", "%Y-%m-01")
                AND orc_fecha_orden <= LAST_DAY("' . $fecha . '")
            ) AS monto_comprometido_mensual,
            (
                SELECT
                    IFNULL(sum(dpv_total), 0)
                FROM
                    dpv_documento_proveedor
                WHERE
                    dpv_id_psp = dps_id_psp
                AND dpv_id_ace = dpv_id_ace
                AND ISNULL(dpv_id_orc)
                AND dpv_fecha_documento >= DATE_FORMAT("' . $fecha . '", "%Y-%m-01")
                AND dpv_fecha_documento <= LAST_DAY("' . $fecha . '")
            ) AS monto_pagado_mensual
            /*,(
                SELECT
                    COUNT(pcp_id)
                FROM
                    pcp_plan_compra_presupuesto
                WHERE
                    pcp_estado = 1
                AND pcp_id_dps = dps_id
            ) AS planes*/';
        $group_by               = "ace_id";
        $actividades_generales  = $this->compras_model->get_actividades_x_presupusto($select, $where, $group_by);
        $html                   = '<option value=""></option>';
        foreach ($actividades_generales as $value) {
            $selected           = "";
            $disponible         = ($value['total'] - $value['monto_comprometido']);
            $disponible_mensual = "";
            //if ( $value['planes'] > 0 ) {
            $disponible_mensual = $value['permitido'] - ($value['monto_comprometido_mensual'] + $value['monto_pagado_mensual']);
            $disponible_mensual = number_format($disponible_mensual, 2, ".", ",");
            //}
            if ($value['ace_id'] == $seleccionado) {
                $selected = "selected";
            }
            if ($disponible > 0 or $edicion == true) {
                $html .= '<option data-monto_disponible_mensual="' . $disponible_mensual . '" data-monto_disponible="' . number_format($disponible, 2, ".", "") . '" data-nombre="' . $value['ace_nombre'] . '" value="' . $value['ace_id'] . '" ' . $selected . '>' . $value['ace_codigo'] . ' - ' . $value['ace_nombre'] . ' (' . number_format($disponible, 2, ".", ",") . ')</option>';
            }
        }
        if ($_POST && $evaluar_post) {
            echo trim($html);
        } else {
            return trim($html);
        }
    }

    public function aplicar_nota($id_nta = NULL)
    {
        $data['nota']           = $this->gsatelite->get_registro('nta_nota_abono', array('nta_id' => $id_nta));
        $data['detalle_cuenta'] = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $data['nota']->nta_id_cub))->row_array();
        $data['detalle']       = $this->utm_model->get_detalle_nota(array('nta_id' => $id_nta));
        $html                   = $this->load->view('utm/cuentas/aplicar_nota', $data, true);
        die($html);
    }

    public function aplicar_transaccion_nota($id_nota = NULL)
    {
        $nota = $this->gsatelite->get_tabla('nta_nota_abono', array('nta_id' => $id_nota));


        $array_tra = array(
            'tra_fecha_mod' => date("Y-m-d H:i:s"),
            'tra_usu_mod' => $this->tank_auth->get_user_id(),
            'tra_aplicar' => 1
        );
        $this->gsatelite->actualizar_array('tra_transaccion', $array_tra, array('tra_id' => $nota[0]['nta_id_tra']));
        //aplicar documento proveedor
        $detalle_nota = $this->gsatelite->get_tabla('dna_detalle_nota_abono', array('dna_id_nta' => $cheque[0]['nta_id']));

        foreach ($detalle_nota as $det) {
            if ($det['dna_id_dpv'] != null) {
                $documento_factura = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id' => $det['dna_id_dpv']));

                $nuevo_monto_pendiente = $documento_factura[0]['dpv_monto_pendiente'] - $det['dna_valor'];
                $nuevo_abono = $documento_factura[0]['dpv_monto_abono'] + $det['dna_valor'];

                $array_dpv = array(
                    'dpv_monto_pendiente' => $nuevo_monto_pendiente,
                    'dpv_pagado' => ($nuevo_monto_pendiente <= 0) ? 1 : 0,
                    'dpv_monto_abono' => $nuevo_abono
                );
                $this->gsatelite->actualizar_array('dpv_documento_proveedor', $array_dpv, array('dpv_id' => $det['dna_id_dpv']));
            }
        }
        //aplicar cub_cuenta_bancaria
        //$this->db->join('cub_cuenta_bancaria', 'cub_id = nta_id_cub');
        $cuenta_bancaria = $this->gsatelite->get_tabla('chq_chequera', array('chq_id_cub' => $nota[0]['nta_id_cub']));

        $newSaldo = $cuenta_bancaria[0]['cub_saldo'] - $cheque[0]['nta_monto'];

        $array_banco = array(
            'cub_usu_mod' => $this->tank_auth->get_user_id(),
            'cub_fecha_mod' => date("Y-m-d H:i:s"),
            'cub_saldo' => $newSaldo
        );
        $result = $this->gsatelite->actualizar_array('cub_cuenta_bancaria', $array_banco, array('cub_id' => $cuenta_bancaria[0]['cub_id']));

        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Transacción", 'texto_alerta' => "La transacción efectuada correctamente");
        $this->session->set_flashdata($alerta);
        redirect('utm/cuentas/notas_abono');
    }

    /**
     * @author Jose Marlon
     * @since: 27/05/2019
     * @return: vista de cheques anexados en documento proveedor
     */
    public function anexos_cheques($id_dpv = null)
    {
        if ($id_dpv != null) {
            $data['anexos_doc'] = $this->gsatelite->get_tabla('adp_anexo_documento', array('adp_id_dpv' => $id_dpv));
            $this->gsatelite->cargar_vista_masterpage('utm/cuentas/anexos_cheques', $data);
        }
    }

    /**
     * @author Francisco Orozco
     * @since  31/07/2019
     * @param  INT cheque   
     * @param  INT tipo_proceso         
     * Descripcion: si tipo = 1 crear un arreglo de la partida contable y si es 2 realiza una insercion en la bd
     * proceso evaluar automaticamente si es de editar
     */
    public function generar_partida_automatica_cheque($che_id = null, $tipo_proceso = 1)
    {
        satelite_validar();
        if ($che_id > 0) {
            //variables globales
            $proceso_partida    = null;
            $fecha_global       = date('Y-m-d H:i:s');
            $usuario_global     = $this->tank_auth->get_user_id();

            //obtencion de datos del cheque
            $this->db->join("che_cheque", "che_id = dch_id_che");
            $this->db->join("dpv_documento_proveedor", "dpv_id = dch_id_dpv");
            $detalles_cheque    = $this->gsatelite->get_tabla("dch_detalle_cheque", array("dch_id_che" => $che_id));
            $cxb_id_tcn         = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('BANCOS'));
            $cuenta_banco       = "";

            //Determinar el origen de la partida
            $pct_id_orp         = $this->gsatelite->get_campo('orp_origen_partida', 'orp_id', array('orp_tabla' => "che_cheque"));
            $pct_id_orp         = ($pct_id_orp != "") ? $pct_id_orp : null;

            //Tipo de partida
            $pct_id_tpd         = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('EGRESOS'));

            //verificacion de periodo contable 
            $this->db->limit(1);
            $this->db->order_by("prc_id", "DESC");
            $prc_id = $this->gsatelite->get_tabla("prc_periodo_contable", array("prc_estado" => 1));

            if ($cxb_id_tcn != "") {
                $where_banco["che_id"]      = $che_id;
                $where_banco["cxb_id_tcn"]  = $cxb_id_tcn;
                $cuenta_banco_array         = $this->utm_model->get_cuentas_banco_cheque($where_banco);
                $cuenta_banco               = $cuenta_banco_array[0]["cnt_id"];
            }

            if ($cuenta_banco == "") {
                $cuenta_banco = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
            }

            if ($detalles_cheque > 0) {
                //concepto
                $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 16));
                if (count($pct_concepto) > 0) {
                    $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
                } else {
                    $pct_concepto = 'Concepto no definido';
                }

                //Generacion de correlativo
                $pct_correlativo    = $this->gsatelite->get_max("pct_partida_contable", "pct_id") + 1;

                // Consultar si existe el registro
                $consultar          = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $pct_id_tpd));
                if (count($consultar) > 0) {
                    // Generador de Codigo para la partida contable
                    $numero         = str_pad($pct_correlativo, 5, '0', STR_PAD_LEFT);
                    $codigo         = $consultar[0]['tpd_prefijo'] . '-' . $numero;   // Codigo que tendra la partida
                }

                if (count($detalles_cheque) > 0) {
                    $pct_total      = $detalles_cheque[0]["che_monto"];
                    $pct_fecha      = $detalles_cheque[0]["che_fecha"];

                    $proceso_partida["Encabezado_partida_contable"] = array(
                        'pct_id_tpd'        => $pct_id_tpd,
                        'pct_id_prc'        => $prc_id[0]["prc_id"],
                        'pct_id_padre'      => null,
                        'pct_id_orp'        => $pct_id_orp,
                        'pct_concepto'      => $pct_concepto,
                        'pct_total'         => $pct_total,
                        'pct_fecha'         => $pct_fecha,
                        'pct_correlativo'   => $pct_correlativo,
                        'pct_codigo'        => (isset($codigo)) ? $codigo : null,
                        'pct_modulo'        => 12,
                        'pct_estado'        => 1,
                        'pct_fecha_crea'    => $fecha_global,
                        'pct_fecha_mod'     => $fecha_global,
                        'pct_usu_crea'      => $usuario_global,
                        'pct_usu_mod'       => $usuario_global
                    );
                }

                //declarcion de array acumulativos
                $acumulacion_debe   = array(); //sera conformado por una llave de "centro de costo + cuenta"
                $acumulacion_haber  = array(); //sera conformado por una llave de "centro de costo + cuenta"

                $contador_detalles  = 0;
                $contador_debe      = 0;
                $contador_haber     = 0;
                $contador_centros   = 0;
                $pct_id             = array();

                //Se obtendran los id de las cuentas del documento de proveedor.
                foreach ($detalles_cheque as $detalle_cheque) {
                    array_push($pct_id, $detalle_cheque["dpv_id_pct"]);
                }

                //variables globales 
                if (count($pct_id) > 0) {
                    //Encabezado de la partida de origen
                    $this->db->where_in("pct_id", $pct_id);
                    $partida_contable_prv   = $this->utm_model->get_partida_contable_cheque();

                    // se obtendran los centros de costos
                    $centros_array      = array_column($partida_contable_prv, 'pcc_id_cec');
                    $centros_array      = array_unique($centros_array);

                    //se creara arreglo de los detalles de la partidas                          
                    foreach ($centros_array as $centros) {
                        //$contador_centros = 0;
                        $contador_debe = 0;
                        $contador_haber = 0;
                        //creacion de pcc
                        $proceso_partida["pcc_partida_centro_costo"][] = array(
                            'pcc_id_cec'            => $centros,
                            'pcc_codigo'            => $partida_contable_prv[0]['pct_codigo'],
                            'pcc_descripcion'       => "",
                            'pcc_estado'            => 1,
                            'pcc_usu_creacion'      => $usuario_global,
                            'pcc_fecha_creacion'    => $fecha_global,
                            'pcc_usu_modificacion'  => $usuario_global,
                            'pcc_fecha_modificacion' => $fecha_global
                        );

                        foreach ($partida_contable_prv as $detalle) {
                            //creacion de llaves
                            $llave_evaluacion_d = $centros . "_" . $detalle['dpc_id_cnt'];
                            $llave_evaluacion_h = $centros . "_" . $cuenta_banco;
                            $pago_detalle       = $detalle["dch_subtotal"];

                            //////////////Se obtienen los haber del dpv////////////////////////
                            if ($centros == $detalle['pcc_id_cec']  && $detalle['dpc_haber'] > 0) {
                                //////////////proceso para debe////////////////////////
                                if (isset($acumulacion_debe[$llave_evaluacion_d])) {
                                    //acumulacion de debe
                                    $acumulacion_debe[$llave_evaluacion_d]['dpc_debe'] += (number_format((($pago_detalle * $detalle['dpc_porcentaje_prorrateo']) / 100), 4, '.', ''));

                                    //variables para actualizar el array agregado anteriormente
                                    $posicion_centros   = $acumulacion_debe[$llave_evaluacion_d]['posicion_centros'];
                                    $posicion_debe      = $acumulacion_debe[$llave_evaluacion_d]['posicion_debe'];
                                    $dpc_debe           = $acumulacion_debe[$llave_evaluacion_d]['dpc_debe'];

                                    //actualzar array
                                    $proceso_partida["dpc_detalle_partida"]["debe"][$posicion_centros][$posicion_debe]['dpc_debe'] += (number_format((($pago_detalle * $detalle['dpc_porcentaje_prorrateo']) / 100), 4, '.', ''));
                                } else {
                                    $proceso_partida["dpc_detalle_partida"]["debe"][$contador_centros][] = array(
                                        'dpc_id_cnt'                => $detalle['dpc_id_cnt'],
                                        'dpc_concepto'              => $detalle['dpc_concepto'],
                                        'dpc_debe'                  => number_format((($pago_detalle * $detalle['dpc_porcentaje_prorrateo']) / 100), 4, '.', ''),
                                        'dpc_haber'                 => 0.0000,
                                        'dpc_porcentaje_prorrateo'  => $detalle['dpc_porcentaje_prorrateo'],
                                        'dpc_estado'                => 1,
                                        'dpc_fecha_crea'            => $fecha_global,
                                        'dpc_fecha_mod'             => $fecha_global,
                                        'dpc_usu_crea'              => $usuario_global,
                                        'dpc_usu_mod'               => $usuario_global
                                    );

                                    //acumulacion de debe                                   
                                    $acumulacion_debe[$llave_evaluacion_d] = array(
                                        "dpc_debe"          => number_format((($pago_detalle * $detalle['dpc_porcentaje_prorrateo']) / 100), 4, '.', ''),
                                        "posicion_centros"  => $contador_centros,
                                        "posicion_debe"     => $contador_debe
                                    );
                                    $contador_debe++;
                                }

                                //////////////proceso para haber////////////////////////
                                if (isset($acumulacion_haber[$llave_evaluacion_h])) {
                                    //acumulacion de haber
                                    $acumulacion_haber[$llave_evaluacion_h]["dpc_haber"] += (number_format((($pago_detalle * $detalle['dpc_porcentaje_prorrateo']) / 100), 4, '.', ''));

                                    //variables para actualizar el array agregado anteriormente
                                    $posicion_centros   = $acumulacion_haber[$llave_evaluacion_h]['posicion_centros'];
                                    $posicion_haber     = $acumulacion_haber[$llave_evaluacion_h]['posicion_haber'];
                                    $dpc_haber          = $acumulacion_haber[$llave_evaluacion_h]['dpc_haber'];
                                    //actualzar array
                                    $proceso_partida["dpc_detalle_partida"]["haber"][$posicion_centros][$posicion_haber]['dpc_haber'] = $dpc_haber;
                                } else {
                                    $proceso_partida["dpc_detalle_partida"]["haber"][$contador_centros][] = array(
                                        'dpc_id_cnt'                => $cuenta_banco,
                                        'dpc_concepto'              => $detalle['dpc_concepto'],
                                        'dpc_debe'                  => 0.0000,
                                        'dpc_haber'                 => number_format((($pago_detalle * $detalle['dpc_porcentaje_prorrateo']) / 100), 4, '.', ''),
                                        'dpc_porcentaje_prorrateo'  => $detalle['dpc_porcentaje_prorrateo'],
                                        'dpc_estado'                => 1,
                                        'dpc_fecha_crea'            => $fecha_global,
                                        'dpc_fecha_mod'             => $fecha_global,
                                        'dpc_usu_crea'              => $usuario_global,
                                        'dpc_usu_mod'               => $usuario_global
                                    );

                                    //acumulacion de haber
                                    $acumulacion_haber[$llave_evaluacion_h] = array(
                                        "dpc_haber"         => number_format((($pago_detalle * $detalle['dpc_porcentaje_prorrateo']) / 100), 4, '.', ''),
                                        "posicion_centros"  => $contador_centros,
                                        "posicion_haber"    => $contador_haber
                                    );
                                    $contador_haber++;
                                }
                            }
                        }
                        $contador_centros++;
                    }
                }
            }
            if ($tipo_proceso == 1) {
                return $proceso_partida;
            } else {
                //insertar en pct_partida_contable                    
                $id_pct = $this->gsatelite->ingresar('pct_partida_contable', $proceso_partida["Encabezado_partida_contable"]);
                foreach ($proceso_partida["pcc_partida_centro_costo"] as $centro_contador => $partida_centro) {
                    //se agregaran partdas por centro de costo
                    $partida_centro["pcc_id_pct"] = $id_pct;
                    $id_pcc = $this->gsatelite->ingresar('pcc_partida_centro_costo', $partida_centro);

                    //se agregaran los detalles de partida
                    //debe
                    foreach ($proceso_partida["dpc_detalle_partida"]["debe"][$centro_contador] as $debe) {
                        $debe["dpc_id_pcc"] = $id_pcc;
                        $debe["dpc_id_pct"] = $id_pct;
                        $this->gsatelite->ingresar('dpc_detalle_partida', $debe);
                    }

                    //haber
                    foreach ($proceso_partida["dpc_detalle_partida"]["haber"][$centro_contador] as $haber) {
                        $haber["dpc_id_pcc"] = $id_pcc;
                        $haber["dpc_id_pct"] = $id_pct;
                        $this->gsatelite->ingresar('dpc_detalle_partida', $haber);
                    }
                }
                return $id_pct;
            }
        }
        return 0;
    }

    /**
     * @author Francisco Orozco
     * @since  07/07/2019
     * @param  INT Nota de abono   
     * @param  INT tipo_proceso         
     * Descripcion: si tipo = 1 crear un arreglo de la partida contable y si es 2 realiza una insercion en la bd
     * proceso evaluar automaticamente si es de editar
     */
    public function generar_partida_automatica_nota_abono($nta_id = null, $tipo_proceso = 1)
    {
        satelite_validar();

        if ($nta_id > 0) {
            //variables globales
            $proceso_partida    = null;
            $fecha_global       = date('Y-m-d H:i:s');
            $usuario_global     = $this->tank_auth->get_user_id();

            //obtencion de datos del cheque
            $this->db->join("nta_nota_abono", "nta_id = dna_id_nta");
            $this->db->join("dpv_documento_proveedor", "dpv_id = dna_id_dpv");
            $detalles_nota      = $this->gsatelite->get_tabla("dna_detalle_nota_abono", array("dna_id_nta" => $nta_id));
            $cxb_id_tcn         = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('BANCOS'));
            $cuenta_banco       = "";

            //Determinar el origen de la partida
            $pct_id_orp         = $this->gsatelite->get_campo('orp_origen_partida', 'orp_id', array('orp_tabla' => "nta_nota_abono"));
            $pct_id_orp         = ($pct_id_orp != "") ? $pct_id_orp : null;

            //Tipo de partida
            $pct_id_tpd         = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('EGRESOS'));

            //verificacion de periodo contable 
            $this->db->limit(1);
            $this->db->order_by("prc_id", "DESC");
            $prc_id = $this->gsatelite->get_tabla("prc_periodo_contable", array("prc_estado" => 1));

            if ($cxb_id_tcn != "") {
                $where_banco["nta_id"]      = $nta_id;
                $where_banco["cxb_id_tcn"]  = $cxb_id_tcn;
                $cuenta_banco_array         = $this->utm_model->get_cuentas_banco_nota_abono($where_banco);
                $cuenta_banco               = $cuenta_banco_array[0]["cnt_id"];
            }

            if ($cuenta_banco == "") {
                $cuenta_banco = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
            }

            if (count($detalles_nota) > 0) {
                //concepto
                $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 15));

                if (count($pct_concepto) > 0) {
                    $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
                } else {
                    $pct_concepto = 'Concepto no definido';
                }

                //Generacion de correlativo
                $pct_correlativo    = $this->gsatelite->get_max("pct_partida_contable", "pct_id") + 1;

                // Consultar si existe el registro
                $consultar          = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $pct_id_tpd));

                if (count($consultar) > 0) {
                    // Generador de Codigo para la partida contable
                    $numero         = str_pad($pct_correlativo, 5, '0', STR_PAD_LEFT);
                    $codigo         = $consultar[0]['tpd_prefijo'] . '-' . $numero;   // Codigo que tendra la partida
                }


                $pct_total      = $detalles_nota[0]["nta_monto"] + $detalles_nota[0]["nta_monto_retencion"];
                $pct_fecha      = $detalles_nota[0]["nta_fecha"];

                $proceso_partida["Encabezado_partida_contable"] = array(
                    'pct_id_tpd'        => $pct_id_tpd,
                    'pct_id_prc'        => $prc_id[0]["prc_id"],
                    'pct_id_padre'      => null,
                    'pct_id_orp'        => $pct_id_orp,
                    'pct_concepto'      => $pct_concepto,
                    'pct_total'         => $pct_total,
                    'pct_fecha'         => $pct_fecha,
                    'pct_correlativo'   => $pct_correlativo,
                    'pct_codigo'        => (isset($codigo)) ? $codigo : null,
                    'pct_modulo'        => 12,
                    'pct_estado'        => 1,
                    'pct_fecha_crea'    => $fecha_global,
                    'pct_fecha_mod'     => $fecha_global,
                    'pct_usu_crea'      => $usuario_global,
                    'pct_usu_mod'       => $usuario_global
                );

                //declarcion de array acumulativos
                $acumulacion_debe   = array(); //sera conformado por una llave de "centro de costo + cuenta"
                $acumulacion_haber  = array(); //sera conformado por una llave de "centro de costo + cuenta"

                $contador_detalles  = 0;
                $contador_debe      = 0;
                $contador_haber     = 0;
                $contador_centros   = 0;
                $pct_id             = array();

                //Se obtendran los id de las cuentas del documento de proveedor.
                foreach ($detalles_nota as $detalle_nota) {
                    array_push($pct_id, $detalle_nota["dpv_id_pct"]);
                }

                //variables globales 
                if (count($pct_id) > 0) {
                    //Encabezado de la partida de origen
                    $this->db->where_in("pct_id", $pct_id);
                    $partida_contable_prv   = $this->utm_model->get_partida_contable_nota_abono();
                    // se obtendran los centros de costos
                    $centros_array      = array_column($partida_contable_prv, 'pcc_id_cec');
                    $centros_array      = array_unique($centros_array);

                    //se creara arreglo de los detalles de la partidas                          
                    foreach ($centros_array as $centros) {
                        //$contador_centros = 0;
                        $contador_debe = 0;
                        $contador_haber = 0;
                        //creacion de pcc
                        $proceso_partida["pcc_partida_centro_costo"][] = array(
                            'pcc_id_cec'            => $centros,
                            'pcc_codigo'            => $partida_contable_prv[0]['pct_codigo'],
                            'pcc_descripcion'       => "",
                            'pcc_estado'            => 1,
                            'pcc_usu_creacion'      => $usuario_global,
                            'pcc_fecha_creacion'    => $fecha_global,
                            'pcc_usu_modificacion'  => $usuario_global,
                            'pcc_fecha_modificacion' => $fecha_global
                        );

                        foreach ($partida_contable_prv as $detalle) {
                            //creacion de llaves
                            $llave_evaluacion_d = $centros . "_" . $detalle['dpc_id_cnt'];
                            $llave_evaluacion_h = $centros . "_" . $cuenta_banco;
                            $pago_detalle       = $detalle["dna_valor"];

                            //////////////Se obtienen los haber del dpv////////////////////////
                            if ($centros == $detalle['pcc_id_cec']  && $detalle['dpc_haber'] > 0) {
                                //////////////proceso para debe////////////////////////
                                if (isset($acumulacion_debe[$llave_evaluacion_d])) {
                                    //acumulacion de debe
                                    $acumulacion_debe[$llave_evaluacion_d]['dpc_debe'] += (number_format((($pago_detalle * $detalle['dpc_porcentaje_prorrateo']) / 100), 4, '.', ''));

                                    //variables para actualizar el array agregado anteriormente
                                    $posicion_centros   = $acumulacion_debe[$llave_evaluacion_d]['posicion_centros'];
                                    $posicion_debe      = $acumulacion_debe[$llave_evaluacion_d]['posicion_debe'];
                                    $dpc_debe           = $acumulacion_debe[$llave_evaluacion_d]['dpc_debe'];

                                    //actualzar array
                                    $proceso_partida["dpc_detalle_partida"]["debe"][$posicion_centros][$posicion_debe]['dpc_debe'] += (number_format((($pago_detalle * $detalle['dpc_porcentaje_prorrateo']) / 100), 4, '.', ''));
                                } else {
                                    $proceso_partida["dpc_detalle_partida"]["debe"][$contador_centros][] = array(
                                        'dpc_id_cnt'                => $detalle['dpc_id_cnt'],
                                        'dpc_concepto'              => $detalle['dpc_concepto'],
                                        'dpc_debe'                  => number_format((($pago_detalle * $detalle['dpc_porcentaje_prorrateo']) / 100), 4, '.', ''),
                                        'dpc_haber'                 => 0.0000,
                                        'dpc_porcentaje_prorrateo'  => $detalle['dpc_porcentaje_prorrateo'],
                                        'dpc_estado'                => 1,
                                        'dpc_fecha_crea'            => $fecha_global,
                                        'dpc_fecha_mod'             => $fecha_global,
                                        'dpc_usu_crea'              => $usuario_global,
                                        'dpc_usu_mod'               => $usuario_global
                                    );

                                    //acumulacion de debe                                   
                                    $acumulacion_debe[$llave_evaluacion_d] = array(
                                        "dpc_debe"          => number_format((($pago_detalle * $detalle['dpc_porcentaje_prorrateo']) / 100), 4, '.', ''),
                                        "posicion_centros"  => $contador_centros,
                                        "posicion_debe"     => $contador_debe
                                    );
                                    $contador_debe++;
                                }

                                //////////////proceso para haber////////////////////////
                                if (isset($acumulacion_haber[$llave_evaluacion_h])) {
                                    //acumulacion de haber
                                    $acumulacion_haber[$llave_evaluacion_h]["dpc_haber"] += (number_format((($pago_detalle * $detalle['dpc_porcentaje_prorrateo']) / 100), 4, '.', ''));

                                    //variables para actualizar el array agregado anteriormente
                                    $posicion_centros   = $acumulacion_haber[$llave_evaluacion_h]['posicion_centros'];
                                    $posicion_haber     = $acumulacion_haber[$llave_evaluacion_h]['posicion_haber'];
                                    $dpc_haber          = $acumulacion_haber[$llave_evaluacion_h]['dpc_haber'];
                                    //actualzar array
                                    $proceso_partida["dpc_detalle_partida"]["haber"][$posicion_centros][$posicion_haber]['dpc_haber'] = $dpc_haber;
                                } else {
                                    $proceso_partida["dpc_detalle_partida"]["haber"][$contador_centros][] = array(
                                        'dpc_id_cnt'                => $cuenta_banco,
                                        'dpc_concepto'              => $detalle['dpc_concepto'],
                                        'dpc_debe'                  => 0.0000,
                                        'dpc_haber'                 => number_format((($pago_detalle * $detalle['dpc_porcentaje_prorrateo']) / 100), 4, '.', ''),
                                        'dpc_porcentaje_prorrateo'  => $detalle['dpc_porcentaje_prorrateo'],
                                        'dpc_estado'                => 1,
                                        'dpc_fecha_crea'            => $fecha_global,
                                        'dpc_fecha_mod'             => $fecha_global,
                                        'dpc_usu_crea'              => $usuario_global,
                                        'dpc_usu_mod'               => $usuario_global
                                    );

                                    //acumulacion de haber
                                    $acumulacion_haber[$llave_evaluacion_h] = array(
                                        "dpc_haber"         => number_format((($pago_detalle * $detalle['dpc_porcentaje_prorrateo']) / 100), 4, '.', ''),
                                        "posicion_centros"  => $contador_centros,
                                        "posicion_haber"    => $contador_haber
                                    );
                                    $contador_haber++;
                                }
                            }
                        }
                        $contador_centros++;
                    }
                }
            }
            if ($tipo_proceso == 1) {
                return $proceso_partida;
            } else {
                //insertar en pct_partida_contable                    
                $id_pct = $this->gsatelite->ingresar('pct_partida_contable', $proceso_partida["Encabezado_partida_contable"]);
                foreach ($proceso_partida["pcc_partida_centro_costo"] as $centro_contador => $partida_centro) {
                    //se agregaran partdas por centro de costo
                    $partida_centro["pcc_id_pct"] = $id_pct;
                    $id_pcc = $this->gsatelite->ingresar('pcc_partida_centro_costo', $partida_centro);

                    //se agregaran los detalles de partida
                    //debe
                    foreach ($proceso_partida["dpc_detalle_partida"]["debe"][$centro_contador] as $debe) {
                        $debe["dpc_id_pcc"] = $id_pcc;
                        $debe["dpc_id_pct"] = $id_pct;
                        $this->gsatelite->ingresar('dpc_detalle_partida', $debe);
                    }

                    //haber
                    foreach ($proceso_partida["dpc_detalle_partida"]["haber"][$centro_contador] as $haber) {
                        $haber["dpc_id_pcc"] = $id_pcc;
                        $haber["dpc_id_pct"] = $id_pct;
                        $this->gsatelite->ingresar('dpc_detalle_partida', $haber);
                    }
                }
                return $id_pct;
            }
        }
        return 0;
    }

    /**
     * @author Francisco Orozco
     * @since  22/07/2019
     * @param  INT Id de partida padre
     * @param  INT tipo_proceso         
     * @return INT Id de partida o si es error retorna 0
     * Descripcion: si tipo = 1 crear un arreglo de la partida contable y si es 2 realiza una insercion en la bd
     */
    public function generar_contra_partida($pct_id = null, $tipo_proceso = 1, $modulo = null)
    {
        satelite_validar();

        //tipo_proceso = 1 : return array
        //tipo_proceso = 2 : Insercion          
        if ($pct_id > 0) {
            //variables globales 
            $proceso_partida = null;
            $fecha_global   = date('Y-m-d H:i:s');
            $usuario_global = $this->tank_auth->get_user_id();

            //Encabezado de la partida de origen
            $partida_contable_old   = $this->compras_model->get_partida_contable(array("pct_id" => $pct_id));

            //obtener id del origen de la partida contable
            $this->db->limit(1);
            $pct_id_orp     = $this->gsatelite->get_campo("orp_origen_partida", "orp_id", array("orp_tabla" => "dpv_documento_proveedor", "orp_estado" => 1));
            $pct_id_orp     = ($pct_id_orp != "") ? $pct_id_orp : NULL;

            //Generacion de correlativo
            $pct_correlativo = $this->gsatelite->get_max("pct_partida_contable", "pct_id") + 1;

            //Tipo de partida
            $tipo_partida   = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('INGRESO'));

            $proceso_partida["Encabezado_partida_contable"]   = array(
                'pct_id_tpd'        => $tipo_partida,
                'pct_id_prc'        => $partida_contable_old[0]["pct_id_prc"],
                'pct_id_padre'      => $partida_contable_old[0]["pct_id"],
                'pct_id_orp'        => $pct_id_orp,
                'pct_concepto'      => "Anulación-" . $partida_contable_old[0]["pct_concepto"],
                'pct_total'         => $partida_contable_old[0]["pct_total"],
                'pct_fecha'         => $fecha_global,
                'pct_correlativo'   => $pct_correlativo,
                'pct_codigo'        => $partida_contable_old[0]["pct_codigo"],
                'pct_modulo'        => $modulo,
                'pct_observacion'   => $partida_contable_old[0]["pct_observacion"],
                'pct_estado'        => 1,
                'pct_fecha_crea'    => $fecha_global,
                'pct_fecha_mod'     => $fecha_global,
                'pct_usu_crea'      => $usuario_global,
                'pct_usu_mod'       => $usuario_global
            );


            // se obtendran los centros de costos
            $centros_array      = array_column($partida_contable_old, 'pcc_id_cec');
            $centros_array      = array_unique($centros_array);
            $contador_centros   = 0;
            $contador_detalles  = 0;
            //se creara arreglo de los detalles de la partidas              
            foreach ($centros_array as $centros) {
                //creacion de pcc
                if ($centros == '') {
                    $row   = $this->gsatelite->get_tabla('cec_centro_costo', array('cec_estado' => 1, 'cec_defecto' => 1));
                    $centros = $row[0]['cec_id'];
                }
                $proceso_partida["pcc_partida_centro_costo"][] = array(
                    'pcc_id_cec'             => $centros,
                    'pcc_codigo'             => $partida_contable_old[0]['pct_codigo'],
                    'pcc_descripcion'        => "",
                    'pcc_estado'             => 1,
                    'pcc_usu_creacion'       => $usuario_global,
                    'pcc_fecha_creacion'     => $fecha_global,
                    'pcc_usu_modificacion'   => $usuario_global,
                    'pcc_fecha_modificacion' => $fecha_global
                );

                foreach ($partida_contable_old as $detalle) {

                    //////////////proceso para debe////////////////////////
                    if ($centros == $detalle['pcc_id_cec']  && $detalle['dpc_haber'] > 0) {
                        $proceso_partida["dpc_detalle_partida"]["debe"][$contador_centros][] = array(
                            'dpc_id_cnt'                => $detalle['dpc_id_cnt'],
                            'dpc_concepto'              => $detalle['dpc_concepto'],
                            'dpc_debe'                  => number_format($detalle['dpc_haber'], 4, '.', ''),
                            'dpc_haber'                 => 0.0000,
                            'dpc_porcentaje_prorrateo'  => $detalle['dpc_porcentaje_prorrateo'],
                            'dpc_estado'                => 1,
                            'dpc_fecha_crea'            => $fecha_global,
                            'dpc_fecha_mod'             => $fecha_global,
                            'dpc_usu_crea'              => $usuario_global,
                            'dpc_usu_mod'               => $usuario_global
                        );
                    }

                    //////////////proceso para haber////////////////////////
                    if ($centros == $detalle['pcc_id_cec']  && $detalle['dpc_debe'] > 0) {
                        $proceso_partida["dpc_detalle_partida"]["haber"][$contador_centros][] = array(
                            'dpc_id_cnt'                => $detalle['dpc_id_cnt'],
                            'dpc_concepto'              => $detalle['dpc_concepto'],
                            'dpc_debe'                  => 0.0000,
                            'dpc_haber'                 => number_format($detalle['dpc_debe'], 4, '.', ''),
                            'dpc_porcentaje_prorrateo'  => $detalle['dpc_porcentaje_prorrateo'],
                            'dpc_estado'                => 1,
                            'dpc_fecha_crea'            => $fecha_global,
                            'dpc_fecha_mod'             => $fecha_global,
                            'dpc_usu_crea'              => $usuario_global,
                            'dpc_usu_mod'               => $usuario_global
                        );
                    }
                }
                $contador_centros++;
            }

            //Si no hay centros de costos
            // var_dump($centros_array[0]);
            if ($centros_array[0] == null) {
                foreach ($partida_contable_old as $detalle) {
                    //////////////proceso para debe////////////////////////
                    if ($detalle['dpc_haber'] > 0) {
                        $proceso_partida["dpc_detalle_partida"]["debe"] = array(
                            'dpc_id_cnt'                => $detalle['dpc_id_cnt'],
                            'dpc_concepto'              => $detalle['dpc_concepto'],
                            'dpc_debe'                  => number_format($detalle['dpc_haber'], 4, '.', ''),
                            'dpc_haber'                 => 0.0000,
                            'dpc_porcentaje_prorrateo'  => $detalle['dpc_porcentaje_prorrateo'],
                            'dpc_estado'                => 1,
                            'dpc_fecha_crea'            => $fecha_global,
                            'dpc_fecha_mod'             => $fecha_global,
                            'dpc_usu_crea'              => $usuario_global,
                            'dpc_usu_mod'               => $usuario_global
                        );
                    }

                    //////////////proceso para haber////////////////////////
                    if ($detalle['dpc_debe'] > 0) {
                        $proceso_partida["dpc_detalle_partida"]["haber"] = array(
                            'dpc_id_cnt'                => $detalle['dpc_id_cnt'],
                            'dpc_concepto'              => $detalle['dpc_concepto'],
                            'dpc_debe'                  => 0.0000,
                            'dpc_haber'                 => number_format($detalle['dpc_debe'], 4, '.', ''),
                            'dpc_porcentaje_prorrateo'  => $detalle['dpc_porcentaje_prorrateo'],
                            'dpc_estado'                => 1,
                            'dpc_fecha_crea'            => $fecha_global,
                            'dpc_fecha_mod'             => $fecha_global,
                            'dpc_usu_crea'              => $usuario_global,
                            'dpc_usu_mod'               => $usuario_global
                        );
                    }
                }
            }
            //var_dump($proceso_partida);die();

            if ($tipo_proceso == 1) {
                return $proceso_partida;
            } else {
                //insertar en pct_partida_contable

                $id_pct = $this->gsatelite->ingresar('pct_partida_contable', $proceso_partida["Encabezado_partida_contable"]);
                //Si hay detalles de centro de costos
                if ($centros_array[0] != null) {
                    foreach ($proceso_partida["pcc_partida_centro_costo"] as $centro_contador => $partida_centro) {
                        //se agregaran partdas por centro de costo
                        $partida_centro["pcc_id_pct"] = $id_pct;
                        $id_pcc = $this->gsatelite->ingresar('pcc_partida_centro_costo', $partida_centro);

                        //se agregaran los detalles de partida

                        //debe
                        foreach ($proceso_partida["dpc_detalle_partida"]["debe"][$centro_contador] as $debe_contador => $debe) {
                            $debe["dpc_id_pcc"] = $id_pcc;
                            $debe["dpc_id_pct"] = $id_pct;
                            $this->gsatelite->ingresar('dpc_detalle_partida', $debe);
                        }

                        //haber
                        foreach ($proceso_partida["dpc_detalle_partida"]["haber"][$centro_contador] as $contador_haber => $haber) {
                            $haber["dpc_id_pcc"] = $id_pcc;
                            $haber["dpc_id_pct"] = $id_pct;
                            $this->gsatelite->ingresar('dpc_detalle_partida', $haber);
                        }
                    }
                } else {
                    $proceso_partida["dpc_detalle_partida"]["debe"]["dpc_id_pct"] = $id_pct;
                    $proceso_partida["dpc_detalle_partida"]["haber"]["dpc_id_pct"] = $id_pct;
                    $this->gsatelite->ingresar('dpc_detalle_partida', $proceso_partida["dpc_detalle_partida"]["debe"]);
                    $this->gsatelite->ingresar('dpc_detalle_partida', $proceso_partida["dpc_detalle_partida"]["haber"]);
                }

                return $id_pct;
            }
        }
        return 0;
    }

    function test_partida($id_chque = 0)
    {
        $where['che_id'] = $id;
        $groupby         = 'che_id, cnt_id';
        $datos = $this->generar_partida_contable_cheque($where, $groupby, null, null, false, false);
        $this->gsatelite->actualizar_array('che_cheque', array('che_id_pct' => $datos['id_pct']), array('che_id' => $fila['che_id']));
        print_r($datos);
    }

    function entregar_cheque($id)
    {
        $this->db->join('chq_chequera', 'chq_id = che_id_chq');
        $this->db->join('cub_cuenta_bancaria', 'cub_id = chq_id_cub');
        $this->db->join('ban_banco', 'ban_id = cub_id_ban');
        $this->db->join('emp_empleado', 'emp_id_usu = che_usu_crea');
        $data['cheque'] = $this->gsatelite->get_tabla('che_cheque', array('che_id' => $id));
        // $data['cheque'] = $this->db->get_where('che_cheque', array('che_id' => $che_id))->result_array();

        $this->db->join('dpv_documento_proveedor ', 'dpv_id = dch_id_dpv', 'left');
        $this->db->join('tif_tipo_factura ', 'tif_id = dpv_id_tif', 'left');
        $data['detalle_cheque'] = $this->gsatelite->get_tabla('dch_detalle_cheque', array('dch_id_che' => $data['cheque'][0]['che_id']));
        $data['dep_empresa'] = $this->gsatelite->get_parametro('SYS_DEPARTAMENTO');
        $data['empresa'] = $this->gsatelite->get_parametro('SYS_EMPRESA');

        $data['logo'] = $this->gsatelite->get_parametro('SYS_LOGOTIPO');

        // print_r($data['logo']);die;
        $this->load->library('pdf');

        $html = $this->load->view('utm/cuentas/detalle_comprobante_cheque_entrega', $data, true);
        ////////////////// configuracion de pagina
        $fuente             = "calibrib";
        $size               = 8;
        $formato            = "Letter";
        $formato_array      = explode(",", $formato); //convierte el formato a array por si se quiere un formato personalizado de pagina
        $formato            = (count($formato_array) > 1) ? $formato_array : $formato; //si tiene mas de un elemento se toma el array y si no el valor del formato
        $orientacion        = "P";
        $margins            = "0,0,0";
        $setCellPaddings    = "0,0,0";
        $this->pdf->setPrintHeader(false);
        $this->pdf->SetFont($fuente);
        $this->pdf->setCellPaddings($setCellPaddings);
        $this->pdf->SetAutoPageBreak(true, 0);
        $this->pdf->SetMargins($margins); //274, 155
        $this->pdf->AddPage(
            $orientacion,
            $formato,
            array(
                'family' => $fuente,
                'style' => '',
                'size' => $size
            )
        );
        //////////////////
        $this->pdf->setPrintFooter(false);
        $this->pdf->writeHTML($html, true, false, false, false, '');
        $this->pdf->boletaPDF('I');
        // print_r($id);
    }

    public function aplicar_caja_chica($id_cheque = NULL)
    {
        satelite_validar();
        if ($_POST) {
            $caja_chica_id = $this->input->post('slcCajaChica');
            $exito = $this->gsatelite->actualizar_array('che_cheque', array('che_id_cch' => $caja_chica_id, 'che_aplica_caja_chica' => 1), array('che_id' => $id_cheque));
            if ($exito > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Aplicación Exitosa", 'texto_alerta' => "Se aplico a Caja Chica Correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "No se pudo realizar la operación.");
            }
            $this->session->set_flashdata($alerta);
            redirect('utm/cuentas/gestion_cheques');
        } else {
            $cheque = $this->gsatelite->get_registro('che_cheque', array('che_id' => $id_cheque));
            if ($cheque->che_estado == 0) {
                $data['puede_aplicar'] = 0;
                $data['inactivo'] = 1;
            } elseif ($cheque->che_id_cch != "") {
                $data['puede_aplicar'] = 0;
                $data['caja_chica_nombre'] = $this->gsatelite->get_campo('cch_caja_chica', 'cch_nombre', array('cch_id' => $cheque->che_id_cch));
            } else {
                $data['puede_aplicar'] = 1;
            }
            $this->db->join("lcc_liquidacion_caja_chica", "lcc_id_cch = cch_id");
            $select_cch = $this->gsatelite->get_dropdown('cch_caja_chica', '{cch_nombre}', '', array('cch_estado' => 1, 'lcc_corte' => 0, 'lcc_estado' => 1), null, null, null, true);
            $data['caja_ch'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select_cch);
            $data['cheque'] = $cheque;
            $data['chequera'] = $this->gsatelite->get_registro('chq_chequera', array('chq_id' => $cheque->che_id_chq));
            $data['detalle_cuenta'] = $this->db->get_where('vw_cuentas_bancarias', array('cub_id' => $data['chequera']->chq_id_cub))->row_array();
            $data['pagos'] = $this->utm_model->get_detalle_cheque(array('dch_id_che' => $id_cheque));
            $html = $this->load->view('utm/cuentas/aplicar_cheque_caja_chica', $data, true);
            die($html);
        }
    }
}
/* End of file cuentas.php */
/* Location: ./application/controllers/bacos/cuentas.php */
