﻿<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Catalogos extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('consultas');
		$this->load->model('gsatelite');
		$this->load->library('grocery_CRUD');
        
        if(ob_get_contents()) ob_end_clean();
	}

	function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {			
			$this->_cargarvista();
		}
	}

	/**
	 * CRUD de Mantenimiento de tipos de proceso de inventario
	 * @author 	Marlon Beltran A.
	 *
	 * 07/16/2014
	 */
	public function tipo_proc_ent_sal()
	{
	   //$this->load->library('grocery_crud_extended'); 
	   $crud = new grocery_CRUD; 
	   
	   $crud->set_table('tip_tipo_proceso')
		->set_subject('Tipo de Proceso')
		
		->columns('tip_nombre','tip_entrada','tip_salida','tip_traslado','tip_estado')
		->unique_fields('tip_nombre')//set_rule con funcion de campo unico *pendiente
		
		->display_as('tip_nombre','Nombre')
		->display_as('tip_descripcion','Descripción')
		->display_as('tip_entrada','Entrada')
		->display_as('tip_salida','Salida')
		->display_as('tip_traslado','Traslado')
		->display_as('tip_estado','Estado')
		
		->field_type('tip_entrada', 'dropdown', array('No', 'Sí'))
		->field_type('tip_salida', 'dropdown', array('No', 'Sí'))
		->field_type('tip_traslado', 'dropdown', array('No', 'Sí'))             
		->field_type('tip_estado', 'dropdown', array('Inactivo', 'Activo'))
		->field_type('tip_usr_mod', 'hidden', $this->tank_auth->get_user_id()) // default
		->field_type('tip_fecha_mod', 'hidden', date('Y-m-d H:i:s')) // default
		
		->fields('tip_nombre', 'tip_descripcion', 'tip_entrada', 'tip_salida', 'tip_traslado', 'tip_estado', 'tip_fecha_mod', 'tip_usr_mod')
		
		->required_fields('tip_nombre', 'tip_estado', 'tip_entrada', 'tip_salida', 'tip_traslado')
		
		->unset_print()
		->unset_export()
		->unset_delete();
		
		$output = $crud->render();
		
	   $this->_cargarvista(null, $output);
	}
  
    /**
     * Catalogos: mantenimiento de la tabla gen_generador
     * @author René Castaneda
     * 
     * @return
     */
    public function generadores()
    {
        satelite_validar();
        
        $crud = new grocery_CRUD;
        $crud->set_table('gen_generador')
           ->set_subject('Generador')
           ->columns('gen_nombre', 'gen_estado')
           ->fields('gen_nombre','gen_estado')
           ->display_as('gen_nombre','Nombre')
           ->display_as('gen_estado','Estado')
           ->required_fields('gen_nombre','gen_estado')     
           ->field_type('gen_estado','dropdown',array('1' => 'Activado', '0' => 'Desactivado'))
        ;
        
        $crud->callback_before_insert(function($post_array,$primary_key){
        	//verificar si no existe un registro con el mismo nombre
        	$nombreGen = $post_array['gen_nombre'];
        
            $existe=$this->consultas->existeNombre('gen_generador','gen_nombre',$nombreGen,0,0);
        
        	return !($existe > 0);
        
        });//callback
        
        $crud->callback_before_update(function($post_array,$primary_key){
            //verificar si no existe un registro con el mismo nombre
        
        	$id_gen = $post_array['gen_id'];
        	$nombre_generador = $post_array['gen_nombre'];
        
        	$nombre = $this->gsatelite->get_campo('gen_generador', 'gen_nombre', array('gen_id' => $primary_key));
        	$nombre_gen_actual = $nombre;
        
        	$existe=$this->consultas->existeNombre('gen_generador','gen_nombre',$nombre_generador,1,$nombre_gen_actual);
        
            return !($existe > 0);
        
        });//callback
        $crud->set_lang_string('update_error','Error!\nFavor Verificar lo Siguiente:\n\n*No pueden existir nombres repetidos.');
        $crud->set_lang_string('insert_error','Error!\nFavor Verificar lo Siguiente:\n\n*No pueden existir nombres repetidos.');    
                
        $crud->unset_delete();
        $this->_cargarvista(null, $crud->render());
    }
   
    /**
     * CRUD Tasa Municipales
     * 
     * @author Alexis Beltran
     * @return void
     */
    public function tasa_municipal()
    {
		satelite_validar();
        
        $crud = new grocery_CRUD;
        $crud->set_table('srv_servicio')
            ->set_subject('Tasa Municipal')
            ->display_as('srv_id', 'Id')
            ->display_as('srv_id_csr', 'Categoría')
            ->display_as('srv_nombre', 'Nombre')
            ->display_as('srv_estado', 'Estado')
            ->columns('srv_id', 'srv_id_csr', 'srv_nombre', 'srv_estado')
            ->fields('srv_id_csr', 'srv_nombre', 'srv_estado')
        ;
        
        $crud->set_relation('srv_id_csr', 'csr_categoria_servicio', 'csr_nombre', array('csr_id_tsr' => 2));
       $url=split('/', current_url());
       if( end($url) == 'tasa_municipal' or $url[(count($url)-2)]=='success' ){
            $this->db->where('csr_id_tsr', 2);
        }  
        
        $crud->field_type('srv_estado', 'dropdown', array('Inactivo','Activo'));
        
        $crud->add_action('Detalle', '', 'utm/catalogos/detalle_tasa_municipal', 'tbutton');
        
        $crud->required_fields('srv_id_csr', 'srv_nombre', 'srv_estado');
        $crud->unset_delete();
        $output = $crud -> render();
      
        $this->_cargarvista(null,$output);
    }
    
    /**
     * CRUD Detalle de Tasa Municipales
     * 
     * @author Alexis Beltran
     * @param int $srv_id
     * @return
     */

    public function detalle_tasa_municipal($srv_id)
    {
		satelite_validar();
        
        $crud = new grocery_CRUD;
        $crud->set_table('dts_detalle_tasa_municipal');
        $crud->set_subject('Detalle');
        
        $crud
            ->display_as('dts_id_cpr', 'Cuenta Presupuesto')
            ->display_as('dts_valor', 'Valor')
            ->display_as('dts_estado', 'Estado')
        ;
        
        $crud->set_relation('dts_id_cpr', 'cpr_cuenta_presupuesto', '{cpr_numero} {cpr_nombre}');
        
        $crud->columns('dts_id_cpr', 'dts_valor', 'dts_estado');
        $crud->fields('dts_id_cpr', 'dts_valor', 'dts_estado', 'dts_id_srv', 'dts_usu_mod', 'dts_fecha_mod');
        
        $crud->where('dts_id_srv', $srv_id);
        
        $crud->field_type('dts_estado', 'dropdown', array('Inactivo','Activo'));
        $crud->field_type('dts_id_srv', 'hidden', $srv_id);
        $crud->field_type('dts_usu_mod', 'invisible');
        $crud->field_type('dts_fecha_mod', 'invisible');
      
        $crud->required_fields('dts_id_cpr', 'dts_valor', 'dts_estado');
        $crud->set_rules('dts_valor', 'Valor', 'decimal|required');
        
        //Auditoria
        $crud->callback_before_insert(function($post_array){
            $post_array['dts_usu_mod'] = $this->tank_auth->get_user_id();
            $post_array['dts_fecha_mod'] = date('Y-m-d H:i:s');
            //print_r($post_array); die();
            return $post_array;
        });
        $crud->callback_before_update(function($post_array){
            $post_array['dts_usu_mod'] = $this->tank_auth->get_user_id();
            $post_array['dts_fecha_mod'] = date('Y-m-d H:i:s');
            return $post_array;
        });
        
        
        $crud->unset_delete();
        $this->_cargarvista(null, $crud->render());    
    }
   

    /**
     * Catalogos: mantenimiento de la tabla grs_grupo_servicio
     * @author René Castaneda
     */
    public function grupos_servicios()
    {
        satelite_validar();  
        $idsSer = $this->consultas->ids_servicios_funo();
        $crud = new grocery_CRUD;
        $crud->set_table('grs_grupo_servicio')
           ->set_subject('Grupos de Servicios')
           ->columns('grs_nombre','grs_descripcion','grs_estado','servicios')
           ->fields('grs_nombre','grs_descripcion','grs_estado','servicios','grs_fecha_mod','grs_usu_mod')
           ->set_rules('grs_nombre','Nombre','trim|required|campo_unico[grs_grupo_servicio.grs_nombre]')
           ->display_as('grs_nombre','Nombre')
           ->display_as('grs_descripcion','Descripción')
           ->display_as('grs_estado','Estado')
           ->required_fields('grs_nombre','grs_estado','servicios')     
           ->field_type('grs_estado','dropdown',array('1' => 'Activado', '0' => 'Desactivado'))
           ->field_type('grs_usu_mod','invisible')
           ->field_type('grs_fecha_mod','invisible')
           ;
         //  echo $idsSer; die();
           $crud->set_relation_n_n('servicios', 'sxg_servicio_grupo', 'srv_servicio', 
                                'sxg_id_grs' ,'sxg_id_srv','srv_nombre', null, "srv_id in ($idsSer)");
        
        $crud->callback_before_insert(function($post_array,$primary_key){
            //AUDITORIA
            $post_array['grs_usu_mod'] = $this->tank_auth->get_user_id();
            $post_array['grs_fecha_mod'] = date('Y-m-d H:i:s');
           // echo print_r($post_array); die();
            return $post_array;
        });
        $crud->callback_before_update(function($post_array,$primary_key){
            //AUDITORIA
            $post_array['grs_usu_mod'] = $this->tank_auth->get_user_id();
            $post_array['grs_fecha_mod'] = date('Y-m-d H:i:s');
            return $post_array;
        });  
        $crud->callback_after_insert(function($post_array,$primary_key){
        //DESPUES DE QUE SE HAYA REALIZADO LA INSERCCION DEL REGISTRO 
        //SE DEBERAN ACTUALIZAR LOS CAMPOS de auditoria que estan vacios en la tabla de detalles (NULL)
            $datosAuditoria = array(
             'sxg_estado'    => 1, 
             'sxg_usu_mod'   => $this->tank_auth->get_user_id(),
             'sxg_fecha_mod' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar('sxg_servicio_grupo',$datosAuditoria,'sxg_id_grs',$primary_key);
            return TRUE; 
          });

        $crud->callback_after_update(function($post_array,$primary_key){
        //DESPUES DE QUE SE HAYA REALIZADO LA INSERCCION DEL REGISTRO 
        //SE DEBERAN ACTUALIZAR LOS CAMPOS de auditoria que estan vacios en la tabla de detalles (NULL)
            $datosAuditoria = array(
             'sxg_estado'    => 1, 
             'sxg_usu_mod'   => $this->tank_auth->get_user_id(),
             'sxg_fecha_mod' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar('sxg_servicio_grupo',$datosAuditoria,'sxg_id_grs',$primary_key);
            return TRUE; 

                    });   
        $crud->unset_delete();
        $this->_cargarvista(null, $crud->render());
    }

	
	function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}

}
