﻿<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Catalogo extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('consultas');
		$this->load->model('gsatelite');
		$this->load->library('grocery_CRUD');
        
        if(ob_get_contents()) ob_end_clean();
	}

	function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {			
			$this->_cargarvista();
		}
	}
  
	public function add_articulos()
    {
      
      $objeto_crud = new grocery_CRUD;
      $objeto_crud->set_table('art_articulo');
      $objeto_crud->set_subject('Artículo');
      $objeto_crud->set_relation('art_id_tia','tia_tipo_articulo','tia_nombre');
      $objeto_crud->set_relation('art_id_uni','uni_unidad_medida','uni_nombre');

      $objeto_crud->add_fields('art_nombre','art_codigo','art_minimo','art_maximo','art_id_tia','art_id_uni');
      $objeto_crud->columns('art_codigo','art_id_uni','art_id_tia','art_nombre');
      $objeto_crud->display_as('art_id_tia','categoria del articulo');
      $objeto_crud->display_as('art_nombre','Nombre del articulo');
      $objeto_crud->display_as('art_minimo','cantidad minima del articulo');
      $objeto_crud->display_as('art_maximo','cantidad maxima del articulo');
      $objeto_crud->display_as('art_id_uni','unidad de articulo');

      $objeto_crud->set_rules('art_nombre','nombre del articulo','required');
      $objeto_crud->set_rules('art_codigo','codigo del articulo','required');
      $objeto_crud->set_rules('art_minimo','cantidad minima del articulo','required||integer');
      $objeto_crud->set_rules('art_maximo','cantidad maxima del articulo','required||integer');
      $objeto_crud->set_rules('art_id_tia','categoria del articulo','required');
      $objeto_crud->set_rules('art_id_uni','unidad de medida del articulo','required');
      $objeto_crud->unset_delete();
      $output = $objeto_crud -> render();
      $this->_cargarvista(null,$output);
   }

    public function add_tipo()
    {
        $crud = new grocery_CRUD;
        $crud->set_table('tia_tipo_articulo');
        $crud->set_subject('Tipo de Artículo');
        $crud->add_fields('tia_nombre', 'tia_estado');
        $crud->columns('tia_nombre');
        $crud->display_as('tia_nombre', 'Nombre de catogoria');
        $crud->display_as('tia_estado', 'Estado de categoria');
        $crud->set_rules('tia_nombre','nombre de categoria','required');
        $crud->set_rules('tia_estado','estado de la catogoria','required||integer');
        $crud->unset_delete();
        $output = $crud->render();
        $this->_cargarvista(null, $output);
    }

    public function ingresar_tipo_unidad()
    {
        $crud = new grocery_CRUD;
        $crud->set_table('uni_unidad_medida');
        $crud->set_subject('Unidad de Medida');

        $crud->add_fields('uni_nombre', 'uni_abreviacion');
        $crud->columns('uni_nombre', 'uni_abreviacion');

        $crud->display_as('uni_nombre', 'Nombre');
        $crud->display_as('uni_abreviacion', 'Abreviación');

        $crud->set_rules('uni_nombre','Nombre','required');
        $crud->set_rules('uni_abreviacion','Abreviación','required');

        $output = $crud->render();
        $this->_cargarvista(null, $output);
    }


//Tasas municipales
   //Falta: drop down de estados, almacenar usuario auditoria


    public function tasa_municipal()
    {
      
      $crud = new grocery_CRUD;
      $crud->set_table('srv_servicio');
      $crud->set_subject('Tasa Municipal');
      $crud->set_relation('tas_id_cts','cts_categoria_tasa_mun','cts_nombre');
      //$crud->set_relation('tas_id_cpr','cpr_cuenta_presupuesto','cpr_nombre');
      //$csr_ids = $this->db->select('csr_id')->get_where('csr_categoria_servicio', array('csr_id_tsr' => 2))
      //$crud->where('srv_id_csr', );
      $this->db->join('csr_categoria_servicio', 'csr_id = srv_id_csr');
      $this->db->where('csr_id_tsr', 2);
      $crud->add_fields('tas_nombre','tas_id_cpr','tas_valor_tasa','tas_unidad_cobro','tas_variable_fijo','tas_id_cts','tas_estado');
      $crud->columns('tas_id_cts', 'tas_nombre','tas_valor_tasa');
      $crud->display_as('tas_id_cts','categoria de la tasa');
      $crud->display_as('tas_nombre','Nombre de la tasa');
      $crud->display_as('tas_valor_tasa','Valor de la tasa');
      $crud->display_as('tas_unidad_cobro','Unidad de cobro');
      $crud->display_as('tas_variable_fijo','Variable/Fijo');
      $crud->display_as('tas_id_cts','Categoria de Tasa');
      $crud->display_as('tas_estado','Estado de Tasa');
      $crud->set_rules('tas_nombre','nombre de tasa','required');      
      //$crud->set_rules('art_maximo','cantidad maxima del articulo','required||integer');
      
      $crud->unset_delete();
      $output = $crud -> render();
      $this->_cargarvista(null,$output);
   }
   
    public function detalle_tasa_municipal(){
        try{
            $crud = new grocery_CRUD();
            $crud
                ->set_table('dsr_detalle_servicio')
                ->set_subject('Detalle')
                ->set_relation('dsr_id_cpr', 'cpr_cuenta_presupuesto', '{cpr_numero} {cpr_nombre}')
                ->columns('dsr_id_cpr', 'dsr_monto', 'dsr_')
                
            ;
            $crud->callback_delete(function($key){
                $this->db->update('dsr_detalle_servicio', array('dsr_estado' => 0), array('dsr_id' => $key));
            });
            $this->_cargarvista(null, $crud->render());
        }catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}   
    }


    //categoria Tasas municipales
    //Falta: drop down de estados, almacenar usuario auditoria
    public function agregar_categoria_tasa()
        {
          
          $crud = new grocery_CRUD;
          $crud->set_table('cts_categoria_tasa_mun');
          $crud->set_subject('Categoria Tasa Municipal');
          
    
          $crud->add_fields('cts_nombre','cts_estado');
          $crud->columns('cts_nombre','cts_estado');
          $crud->display_as('cts_nombre','Nombre de categoria');
          $crud->display_as('cts_estado','Estado de categoria');
          $crud->set_rules('cts_nombre','nombre de categoria','required');      
          
          $crud->unset_delete();
          $output = $crud -> render();
          $this->_cargarvista(null,$output);
       }

	
	function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */