<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Caja
 * 
 * @package Municipalidad   
 * @copyright satelite
 * @version 2013
 * @access public
 */
class Caja extends CI_Controller
{
	/**
	 * Caja::__construct()
	 * 
	 * @return
	 */
	function __construct()
	{
        parent::__construct();
        $this->load->library('grocery_CRUD');
        //$this->load->library('grocery_CRUD_extended');
        $this->load->model('consultas');
        $this->load->model('gsatelite');
        $this->load->model('caja_model');
        $this->load->model('utm_model');

    }
    
	/**
	 * Caja::index()
	 * 
	 * @return
	 */
	function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {			
			$this->_cargarvista();
		}
	}

    /**
    * @author Boris Estrada
    * Mantenimiento de caja
    */
    function mantenimiento()
    {
        satelite_validar();
        try{
            $crud = new grocery_CRUD_extended();
            $crud->set_table('caj_caja');
            $crud->set_subject('Caja');
            
            $crud->callback_column('usuario',array($this,'_usuario'))->display_as('usuario', 'Usuario actual');
            $crud->unique_fields('caj_nombre');
            $crud->required_fields('caj_nombre', 'caj_estado', 'generadores');
            /*GRID*/
            
            /*ADD*/
            $crud->fields('caj_nombre', 'caj_estado', 'generadores');
            $crud->columns('caj_nombre', 'caj_estado', 'usuario', 'generadores');
            
            /*EDIT*/
            $crud->edit_fields('caj_nombre', 'caj_estado','generadores');
            
            /*RELACION MUCHO A MUCHOS CON gen_generador*/
            $crud->set_relation_n_n('generadores', 'gxc_generadorxcaja', 'gen_generador', 'gxc_id_caj' ,'gxc_id_gen','gen_nombre',NULL, array('gen_estado' => 1) );
            
            $crud->display_as('caj_nombre', 'Nombre de la caja');
            $crud->display_as('generadores', 'Generadores');
            $crud->display_as('caj_estado','Estado')->field_type('caj_estado', 'dropdown', array('1'=>'Activo', '0'=>'Inactivo'));   
            $output = $crud->render();  
            $this->_cargarvista(null,$output);
        }catch(exception $e){
            show_error($e->getmessage().' --- '.$e->gettraceasstring());
        }
    }

    public function _usuario($value, $row)
    {
      $datos= $this->db->query("SELECT emp_nombres, emp_apellidos 
        FROM cxu_cajaxusuario 
        LEFT JOIN users ON id=cxu_id_usu 
        LEFT JOIN emp_empleado ON empleado=emp_id 
        WHERE cxu_id_caj=".$row->caj_id." 
        AND cxu_estado=1
        AND cxu_tipo=1
        AND cxu_fecha_proceso='".date('Y-m-d')."'
        ")->row_array();

      if($datos){
        if ($datos["emp_nombres"]!='' && $datos["emp_apellidos"]!='') {
          return $datos["emp_nombres"]." ".$datos["emp_apellidos"];
      }else{
          return '';
      }
  }
}

public function comprobar_usuario(){
    $usuario=$this->input->post('usuario');
    $registro=$this->gsatelite->get_tabla(
        'cxu_cajaxusuario'
        , array('cxu_id_usu'=>$usuario, 'cxu_estado'=>1, 'cxu_fecha_proceso'=>date('Y-m-d'), 'cxu_tipo'=>1)
        );
    if($registro[0]['cxu_id_caj']!=''){
        $valor=$registro[0]['cxu_id_caj'];
    }else{
        $valor=0;
    }
    echo $valor;
}

    /**
     * Caja::caja_gestion()
     * @author Alexis Beltran
     * @author René Castaneda
     * 
     * @return
     */
    function caja_gestion(){
        satelite_validar();
        $valorPost=$this->input->post('gen-caja');
        if($valorPost != "" ) {
            $generador=$this->input->post('gen-caja');
            if($generador != "todos" ) {
                $data['funo'] = $this->caja_model->get_funoxGenerador($generador);
                $data['id_generador'] =  $generador; //llevar el id del generador
                $data['funo'] = $this->consultas->carga_laboral($generador); 

            }else{ 
                $data['funo'] = $this->consultas->carga_laboral(); 
            }
        }else{
            $data['funo'] = $this->consultas->carga_laboral(); 
        }
        $caja_usuario =  $this->utm_model->caja($this->tank_auth->get_user_id());
        $id_caja = 0;
        
        $data['caja_usuario'] =  @$this->gsatelite->get_campo('caj_caja', 'caj_nombre', array('caj_id'=>$caja_usuario));
        if($data['caja_usuario']==''){
            $data['caja_usuario']="Sin Asignar";
        }
        $data['generadores_caja'] = $this->caja_model->get_generadoresxCaja(@$caja_usuario);
        #print_r($this->db->last_query()); exit;
        $this->_cargarvista(null,$data);
    }

    /**
    * Caja::funo_impreso()
    * 
    * @author Alexis Beltran
    * @return void
    */
    function funo_impreso()
    {

        $this->_cargarvista();
    }
    
    /**
     * Caja::get_recibos()
     * 
     * @author Alexis Beltran
     * @return void
     */
    function get_recibos()
    {
        satelite_validar(true);
        
        extract($this->input->post());
        $result = array('response' => false);
        
        if( $cnt_id > 0 ){

            $recibos = $this->db
            ->select('fun_funo.*, IF( MIN(det_fecha) = MAX(det_fecha), DATE_FORMAT(det_fecha,"%Y%m"), CONCAT(DATE_FORMAT(MIN(det_fecha),"%Y%m"), " - ", DATE_FORMAT(MAX(det_fecha),"%Y%m"))) as periodo')
            ->from('fun_funo')
            ->join('fxd_funoxdetalle_cntc', 'fxd_id_fun = fun_id')
            ->join('det_detalle_cntc', 'det_id = fxd_id_det')
            ->join('sxc_servicioxcuenta_corriente', 'sxc_id = det_id_sxc')
            ->where('sxc_cnt_id', $cnt_id)
            ->group_by('fun_id')
            ->get()
            ->result()
            ;
            
            $result['response'] = true;
            $result['html'] = $this->load->view('utm/caja/tabla_recibos', array('recibos'=> $recibos), true);
        }
        
        die(json_encode($result));
    }

    function anular_transaccion()
    {
        satelite_validar();
        
        $data['funo'] = $this->consultas->load_anular();

        
        $this->_cargarvista(null,$data);
    }
    
    function administracion_caja()
    {
        satelite_validar(true);
        $estado=array(1);
        $data['caja']     = $this->consultas->cargar_todo('caj_caja', $estado);
        $data['usuario']  = $this->consultas->usuarios_caja('users');
        
        $this->_cargarvista(null,$data);
    }


    //esta funcion nos servira para poder realizar cualquier proceso que 
    //nos sea permitido entre los cuales hacemos mencion apertura de caja,corte de caja,cierre de caja
    function realizar_proceso()
    {

        $proceso=$this->input->post('proceso');
        $caja=$this->input->post('caja');
        $usuario=$this->input->post('usuario');
        $secuencia=$this->utm_model->secuencia($caja, $usuario);
        #print_r($this->db->last_query()); exit;
        
        if($proceso!=0){

            if($this->gsatelite->get_parametro('SYS_APERTURA_CAJA')=='false'){
                $var= date("w");
            }else{
                $var=1;
            }
            
            if($var == 0 ){
                $ab = 3;
            }else{ 

                $monto = 0;
                $monto = $this->input->post('monto');
                $ab = 0;
                
                $total_caja = $this->consultas->obtener_total_cierre_caja($this->tank_auth->get_user_id());
                
                if ($proceso==5) {#proceso 5 es una re-apertura
                    $proceso=1;
                    $sec=$secuencia[0]['secuencia']+1;
                }else{
                    if($proceso==2 || $proceso==3){
                        $secuencia=$this->gsatelite->get_tabla('cxu_cajaxusuario', array('cxu_estado'=>1,'cxu_id_caj'=>$caja, 'cxu_tipo'=>1, 'cxu_fecha_proceso'=>date('Y-m-d')));
                        $sec=$secuencia[0]['cxu_sec'];
                    }else{
                        $sec=0;
                    }
                }
                
                if($this->input->post('proceso') == 3){
                    if($sl == $total_caja->total){
                        $arreglo_para_proceso = array(
                            'cxu_id_caj' => $caja,
                            'cxu_id_usu'  => $usuario,
                            'cxu_tipo' => $proceso,
                            'cxu_monto' => $monto,
                            'cxu_fecha'=>date('Y-m-d h:i:s'),
                            'cxu_fecha_proceso'=>date('Y-m-d'),
                            'cxu_usu_mod'=>$this->tank_auth->get_user_id(),
                            'cxu_fecha_mod'=>date('Y-m-d'),
                            'cxu_sec'=>$sec
                            );
                        
                        $this->gsatelite->actualizar('cxu_cajaxusuario', array('cxu_estado'=>0), array('cxu_id_caj'=>$caja,'cxu_id_usu'=>$usuario, 'cxu_fecha_proceso'=>date('Y-m-d')));
                        $vf = $this->gsatelite->ingresar('cxu_cajaxusuario',$arreglo_para_proceso);
                        
                        $ab = 1;
                    }else{
                        $ab = 2;
                    }
                }else{

                    $arreglo_para_proceso = array(
                        'cxu_id_caj' => $this->input->post('caja'),
                        'cxu_id_usu'  => $usuario,
                        'cxu_tipo' => $proceso,
                        'cxu_monto' => $monto,
                        'cxu_fecha'=>date('Y-m-d h:i:s'),
                        'cxu_fecha_proceso'=>date('Y-m-d'),
                        'cxu_usu_mod'=>$this->tank_auth->get_user_id(),
                        'cxu_fecha_mod'=>date('Y-m-d'),
                        'cxu_sec'=>$sec
                        );
                    
                    if($proceso==2 || $proceso==3){//En cierre de caja es necesario poner a cero el estado del registro de apertura de la caja
                        $this->gsatelite->actualizar('cxu_cajaxusuario', array('cxu_estado'=>0), array('cxu_id_caj'=>$caja,'cxu_tipo'=>1,'cxu_id_usu'=>$usuario, 'cxu_fecha_proceso'=>date('Y-m-d')));
                    }
                    $vf = $this->gsatelite->ingresar('cxu_cajaxusuario',$arreglo_para_proceso);
                    
                    if($vf != ""){
                        $ab = 1;
                    }
                }//end else proceso
            }
            if($ab==1){
                $alerta=array('tipo_alerta'=> 'note_success','titulo_alerta'=>"Operación correcta",'texto_alerta'=>"Proceso realizado correctamente.");
                $this->session->set_flashdata($alerta);
            }

            echo $ab;

        }else{
            echo 0;
        }

    }//realizar_proceso

    function comprobar_caja(){
        $caja=$this->input->post('caja');
        $resultado=$this->gsatelite->get_tabla('cxu_cajaxusuario', array('cxu_estado'=>1,'cxu_id_caj'=>$caja, 'cxu_tipo'=>1, 'cxu_fecha_proceso'=>date('Y-m-d')));
        if (count($resultado)==0) {
            echo 0;
        }else{
            echo 1;
        }
    }

    /**
    * @author Boris Estrada
    * 
    */
    function tipo_proceso()
    {
        satelite_validar(true);
        $caja = $this->input->post('id');
        $usuario =$this->input->post('usuario');
        $manejador = $this->utm_model->obtener_proceso($caja, $usuario);
        
        
        if(count($manejador) == 0)
        {
            ?>
            <option value="1">Apertura</option>
            <?php
        }else{
            $cierre=0;
            
            
            foreach ($manejador as $key) {
                if ($key['cxu_tipo'] == 3)
                    $cierre=1;
            }//end foreach
            if($cierre== 0){
                foreach ($manejador as $key) {
                    if ($key['cxu_tipo'] == 2)
                        $cierre=1;
                }//end foreach
                if($cierre== 0){
                    ?>
                    <option value="2">Corte de caja</option>
                    <option value="3">Cierre de caja</option>
                    <?php
                }else{
                    ?>
                    <option value="5">Re-apertura</option>
                    <?php
                }//end if
            } else {
                ?>
                <option value="0">La caja se encuentra cerrada</option> //Se encuentra cerrada
                <?php
            }
        }//end else
    }


    function funo_libre()
    {
        satelite_validar();
        
        if( $_POST ){
            extract($this->input->post());
            $result = 0;    
            $funo_id = $this->consultas->generar_funo_libre($contribuyente, $concepto, $detalle, 1, $valor_fiestas);
            
            
            if( $funo_id ){
              $this->gsatelite->show_dialog('F-1 Generado', 'utm/caja/funo_libre');
          }else{
              $this->gsatelite->show_dialog('F-1 No Generado', 'utm/caja/funo_libre', 'error');
          }    
      }else{

        $data['cierre'] = 0;

        $obtener_tipo = $this->consultas->obtener_proceso_usuario($this->tank_auth->get_user_id());

        if(count($obtener_tipo) == 0){
            $data['cierre'] = 1;
        }

        foreach ($obtener_tipo as $proceso) {
            if($proceso['cxu_tipo'] == 3){
              $data['cierre'] = 2;
          }
      }

      $data['cuentas'] = $this->gsatelite->get_dropdown('cpr_cuenta_presupuesto', '{cpr_numero} {cpr_nombre}', 'cuenta', array('LENGTH(cpr_numero)>=' => 5));
      $this->_cargarvista(null,$data);
  }
}

function libre(){
 satelite_validar();
 if( $_POST ){
    extract($this->input->post());
    $monto_fiestas=0;
    if($fiestas=='on'){
        $monto_fiestas=$valor_fiestas;
    }
    $result = 0;    
    $funo_id = $this->consultas->generar_funo_libre($contribuyente, $concepto, $detalle, 1, $monto_fiestas);     
    if( $funo_id ){
      $this->gsatelite->show_dialog('F-1 Generado', 'utm/caja/libre');
  }else{
      $this->gsatelite->show_dialog('F-1 No Generado', 'utm/caja/libre', 'error');
  }    
}else{
    $data['cierre'] = 0;
    $obtener_tipo = $this->consultas->obtener_proceso_usuario($this->tank_auth->get_user_id());
    if(count($obtener_tipo) == 0){
        $data['cierre'] = 1;
    }
    foreach ($obtener_tipo as $proceso) {
        if($proceso['cxu_tipo'] == 3){
          $data['cierre'] = 2;
      }
  }
  $data['cuentas'] = $this->gsatelite->get_dropdown('cpr_cuenta_presupuesto', '{cpr_numero} {cpr_nombre}', 'cuenta', array('LENGTH(cpr_numero)>=' => 5));
  $this->_cargarvista(null,$data);
}
}
    /**
     * Caja::funo_detalle()
     * 
     * @author Alexis Beltran
     * @return void
     */
    function funo_detalle($es_grupo=0)
    {
        satelite_validar();
        extract($this->input->post());
        if($es_grupo==0) { //es el id de una tasa normal
       // echo print_r($this->input->post()); die();
            $detalle = $this->consultas->calcular_funo($tas_id);
       // echo $this->db->last_query(); die();
       // echo print_r($detalle); die();
       // echo $this->db->last_query(); die();
            $suma = 0;
            $data["detalle"] = $detalle;
            $data["tas_id"] = $tas_id;
            $data["cantidad"] = $cantidad;

            foreach( $detalle as $row ){
                $suma += $row->valor * $cantidad ;
                $row->monto = $row->valor * $cantidad;
            } 

            $response = array(
                'result'    => 1
                , 'html'      => $this->load->view('utm/caja/funo_detalle', $data, true)
                , 'total'     => number_format($suma, 2)
                );

        }
      elseif ($es_grupo==1) { //se trata de un grupo (con tiene id de servicios)
      //preguntar por los servicios que contiene ese grupo
          $servicios_grupo = $this->caja_model->get_servicosxgrupo($gru_id);
          $suma = 0;
          $html="";
      $sinDetalles=0; //validar que los servicios poseean una tarifa asignada

      foreach ($servicios_grupo as $ser) {
         $id_servicio = $ser['sxg_id_srv'];
         $detalle = $this->consultas->calcular_funo($id_servicio);
         $data["detalle"] = $detalle;
         $data["tas_id"] = $id_servicio;
         $data["cantidad"] = $cantidad;
         $sumaValidar=0;
         foreach( $detalle as $row ){
            $suma += $row->valor * $cantidad ;
            $sumaValidar += $row->valor * $cantidad ;
            $row->monto = $row->valor * $cantidad;
        }
        if($sumaValidar>0) {
            //crear los detalles de los servicios que poseen tarifas asignadas
            $html .= $this->load->view('utm/caja/funo_detalle', $data, true);
        }
        else {
            $sinDetalles++; //contar los servicios que no poseen tarifas asignadas
        }

    }

    $response = array(
        'result'    => 1
        , 'html'      => $html
        , 'verificar'  => $sinDetalles
        , 'total_servicios'  => count($servicios_grupo)
        , 'total'     => number_format($suma, 2)
        );

}

die(json_encode($response));
}

    /**
     * Caja::funo_detalle()
     * 
     * @author Alexis Beltran
     * @return void
     */
    function funo_detalle_cpr()
    {
        extract($this->input->post());
        $detalle = $this->db->get_where('cpr_cuenta_presupuesto', array('cpr_id' => $cpr_id))->row();
        $data = array(
            'cpr_id'    => $detalle->cpr_id
            , 'codigo'    => $detalle->cpr_numero
            , 'cuenta'    => $detalle->cpr_nombre
            , 'monto'     => $monto
            , 'tipo'      => false
            );
        $response = array(
            'result'    => 1
            , 'html'      => $this->load->view('utm/caja/funo_detalle', $data, true)
            , 'total'     => 0
            );
        die(json_encode($response));
    }
    
    function funo_servicios()
    {
        satelite_validar();

        if( $_POST ){
            extract($this->input->post());

            $arrays = array(
                'impu'=>$valor_fiestas
                ,'cant'=>$cantidad
                ,'tot'=>$totales
                ,'cpr_Id'=>$cpr_IDs
                );
            $result = 0;   
            $funo_id = $this->consultas->generar_funo($contribuyente, $concepto, $arrays, $inputTotal);

            if( $funo_id ){
                $this->gsatelite->show_dialog('Liquidación Generada', 'utm/caja/funo_servicios');
            }else{
                $this->gsatelite->show_dialog('Liquidación No Generada', 'utm/caja/funo_servicios', 'error');
            }    
        }else{
            $this->db->join('csr_categoria_servicio', 'csr_id = srv_id_csr AND csr_id_tsr = 2 AND srv_estado= 1 and (srv_tipo = 1 or srv_tipo is null) ');
            $data['tasas'] = $this->gsatelite->get_dropdown('srv_servicio', '{srv_id} {srv_descripcion}', 'tasa', null, null,' id="tasa"');
            
            /*$this->db->join('sxg_servicio_grupo', 'sxg_servicio_grupo.sxg_id_grs = grs_grupo_servicio.grs_id AND sxg_estado= 1 ');
            $this->db->join('srv_servicio', 'sxg_servicio_grupo.sxg_id_srv = srv_servicio.srv_id AND sxg_estado= 1 ');
            $this->db->join('csr_categoria_servicio', 'csr_id = srv_id_csr AND csr_id_tsr = 2 AND srv_estado= 1 ');
            */
            $data['grupo_ser'] = $this->gsatelite->get_dropdown('grs_grupo_servicio', 'grs_nombre', 'grupo_ser', array('grs_estado'=>1), null,' id="grupo_ser"');
            $this->_cargarvista(null,$data);
        }
    }
    
    /*public function funo_servicios_config()
    {
        satelite_validar();
        $crud = new grocery_CRUD();
        $crud->set_table('srv_servicio')->set_subject('Servicio');
        $crud
            ->columns('srv_id_csr', 'srv_nombre', 'srv_estado')
            ->display_as('srv_nombre', 'Servicio')
            ->display_as('srv_id_csr', 'Categoria')->set_relation('srv_id_csr', 'csr_categoria_servicio', 'csr_nombre', array('csr_id_tsr in ' => '(6)'))
            ->display_as('srv_estado', 'Estado')->field_type('tas_estado', 'dropdown', array('Inactivo', 'Activo'))
        ;
        $crud->add_action('Cuentas', '', '', 'tbutton link', function($value, $row){
            return base_url('utm/caja/funo_servicios_cuentas/'.$row->tas_id);
        });
        
        $this->_cargarvista(null,$crud->render());
    }*/
    
    /*function funo_servicios_cuentas($tas_id){
      if (!$this->tank_auth->is_logged_in()) {
        redirect('/auth/login/');
      }
      $crud = new grocery_CRUD();
      $crud->set_table('tas_tasa_municipal')->set_subject('Servicio');
      $crud
      ->columns('tas_id_cts', 'tas_nombre', 'tas_estado')
      ->display_as('tas_nombre', 'Servicio')
      ->display_as('tas_id_cts', 'Categoria')->set_relation('tas_id_cts', 'cts_categoria_tasa_mun', 'cts_nombre')
      ->display_as('tas_estado', 'Estado')->field_type('tas_estado', 'dropdown', array('Inactivo', 'Activo'))
      ;
      $crud->add_action('Cuentas', '', '', 'tbutton link', function($value, $row){
        return base_url('utm/caja/funo_servicios_cuentas/'.$row->tas_id);
      });

      $this->_cargarvista(null,$crud->render());
  }*/

    /*public function funo_guardar(){
      if (!$this->tank_auth->is_logged_in()) {
        redirect('/auth/login/');
      }

  }*/

  public function funo_especie()
  {
    satelite_validar();
    $data['cierre'] = 0;

    $obtener_tipo = $this->consultas->obtener_proceso_usuario($this->tank_auth->get_user_id());

    if(count($obtener_tipo) == 0){
        $data['cierre'] = 1;
    }
    foreach ($obtener_tipo as $proceso) {
        if($proceso['cxu_tipo'] == 3){
            $data['cierre'] = 2;
        }
    }
    $data['bodega']    = $this->consultas->cargar_todo2('bod_bodega');
    $this->_cargarvista(null,$data);
}

/* Funcion para genera vista previa de f-1 libre */
function generar_funoL()
{
    satelite_validar();

    $datos = $this->input->post('datos');
    $subtotal = '';
    $srv = '';
    $montos = '';

    foreach ($datos as $key ) {
        $subtotal +=$key['monto'];
        $srv .= $key['servicio']."\n";
        $montos .= $key['monto']."\n";
    }

    $total = $subtotal * 0.05;
    $monto_final = $subtotal + $total;

    $insertar_funo = array(
        'fun_concepto'      => $this->input->post('concepto'),
        'fun_fecha'         => date("Y-m-d"),
        'fun_subtotal'      =>$subtotal,
        'fun_impuesto'      =>0.05,
        'fun_total'         =>$monto_final,
        'fun_contribuyente' =>$this->input->post('contribuyente'),
        'fun_estado'        => 1,
        'fun_tipo'          => 2
        );

    $id_funo = $this->gsatelite->ingresar('fun_funo',$insertar_funo);

    foreach ($datos as $valores) {
        $arreglo_detalles = array(
            'fud_id_fun' => $id_funo,
            'fud_monto'  => $valores['monto'],
            'fud_id_tas' => $valores['servicio']
            );

        $this->gsatelite->ingresar('fud_funo_deta_libre',$arreglo_detalles);
    }

    $data = true;

    if($data){
        echo json_encode($data);
    }
    }//generar_funoL


    public function detalle_pago()
    {
        $funo=$this->input->post('funo');
        $data['datos']=$this->utm_model->get_funo_detalle_print($funo);
        $tabla=$this->load->view('utm/caja/detalles_caja', $data);
        
        echo $tabla;
    }

    public function detalle_caja($ajax_object = null)
    {
        $id = '';
        $id_detalle = '';
        $impuesto ='';
        $contribuyente = '';
        $total = '';
        if($this->input->post('aEnviar')){
            $id = $this->input->post('aEnviar');    
        }else{
            $objeto = $ajax_object;
        }
        
        $concepto = '';
        $obtener_query = $this->consultas->cargar_detalle_funo_esp($id);
        
        foreach ($obtener_query as $key2) {
            $id_detalle.=$key2['fun_id'];
            $impuesto.=$key2['fun_impuesto'];
            $contribuyente.=$key2['fun_contribuyente'];
            //$total.=$key2['fun_total'];
            $concepto.=$key2['fun_concepto'];
        }
        
        $cierre = 0;
        $obtener_tipo = $this->consultas->obtener_proceso_usuario($this->tank_auth->get_user_id());
        
        switch ($obtener_tipo[0]['cxu_tipo']) {
            case 1:
        echo 1; //Abierta
        break;
        
        case 2:
        echo 2; //Corte
        break;
        
        case 3:
        echo 3; //Cerrada
        break;
        
        default:
        echo 2; //No ha sido abierta
        break;
    }
}

    /*
    public function detalle_caja_impreso()
    {
      $id = '';
      $id_detalle = '';
      $impuesto ='';
      $contribuyente = '';
      $total = '';
      $objeto = $this->input->post('aEnviar');
      $concepto = '';
    
      $obtener_query = $this->consultas->cargar_detalle_funo_esp($objeto);
      echo '<div id="modal_window_4" class="modal white">';
      echo '<h4>Resultados de la busqueda de Especie</h4>';
      echo '<div class="content_modal">';
    
      echo '<table id="table" class="data_table">';
      echo '<thead>';
      echo '<th class="center" style="width: 25%;">concepto</th>';
      echo '<th class="center" style="width: 25%;">fecha</th>';
      echo '<th class="center" style="width: 25%;">subtotal</th>';
      echo '<th class="center" style="width: 25%;">impuesto</th>';
      echo '<th class="center" style="width: 25%;">total</th>';
      echo '<th class="center" style="width: 25%;">Contribuyente</th>';
      echo '</thead>';
      echo '<tbody>';
    
      foreach ($obtener_query as $key2) {
       echo '<tr>';
       echo '<td>'.$key2['fun_concepto'].'</td>';
       echo '<td>'.$key2['fun_fecha'].'</td>';
       echo '<td>'.$key2['fun_subtotal'].'</td>';
       echo '<td>'.$key2['fun_impuesto'].'</td>';
       echo '<td>'.$key2['fun_total'].'</td>';
       echo '<td>'.$key2['fun_contribuyente'].'</td>';
       echo '</tr>';
       $id_detalle.=$key2['fun_id'];
       $impuesto.=$key2['fun_impuesto'];
       $contribuyente.=$key2['fun_contribuyente'];
       $total.=$key2['fun_total'];
       $concepto.=$key2['fun_concepto'];
     }
     echo '</tbody>';
     echo '</table>';
     echo '<form method="post" action="'.base_url().'utm/caja/generar_pdf">';
     echo '<input type="hidden" name="identificador" id="identificador" value="'.$objeto.'">';
     echo '<input type="hidden" name="identidad_detalle" id="identidad_detalle" value="'.$id_detalle.'"/>';
     echo '<input type="hidden" name="impuesto" id="impuesto" value="'.$impuesto.'"/>';
     echo '<input type="hidden" name="concepto" id="concepto" value="'.$concepto.'"/>';
     echo '<input type="hidden" name="contribuyente" id="contribuyente" value="'.$contribuyente.'"/>';
     echo '<input type="hidden" name="total" id="total" value="'.$total.'"/>';
     echo '<br/>';
     echo '<br/>';
     $cierre = 0;
     $obtener_tipo = $this->consultas->obtener_proceso_usuario($this->tank_auth->get_user_id());
    
     if(count($obtener_tipo) == 0){
      $cierre = 1;
    }
    foreach ($obtener_tipo as $proceso) {
     if($proceso['cxu_tipo'] == 3){
      $cierre = 2;
    }
    }
    
    
    echo '</form>';
    echo '</div>';
    echo '</div>';
}*/

    /**
     * Caja::comprobar_numero_recibo()
     * 
     * @return void
     */
    public function comprobar_numero_recibo(){
        $numero=$this->input->post('numero');
        $datos=$this->gsatelite->get_tabla('fun_funo', array('fun_numero'=>$numero));
        
        if(count($datos)!=0){
            $existe=1;
        }else{
            $existe=0;
        }
        
        
        echo $existe;
    }
    
    /**
     * Caja::generar_pdf()
     * 
     * @author Alexis
     * @param mixed $fun_id
     * @param int $banco id del banco al que pertenece el cheque 
     * @param string $numerocheque número de cheque 
     * @param string(decimal) $montocheque monto al que equivale al cheque
     * @description Los parametros $banco,$numerocheque,$monto solo existiran si 
     *              el tipo de pago seleccionado en la  vista es igual al tipo cheque 
     * @return void
     */
    public function generar_pdf($identificador = null, $numero=null, $tipo_pago= 1, $banco=0,$numerocheque='',$montocheque='' )
    {          
        if( $identificador == null ){
            $identificador = $this->input->post('identificador');
        }
        if($this->gsatelite->get_parametro('UATM_LIQUIDACIONES')==1){

            $liquidacion=$this->gsatelite->get_registro('liq_liquidacion', array('liq_id'=>$identificador));
            $subtotal=$liquidacion->{'liq_subtotal'};
            $fiestas = round($liquidacion->{'liq_subtotal'} * $this->gsatelite->get_parametro('UATM_FIESTAS'), 2);
            $multa = round($liquidacion->{'liq_multa'}, 2);
            $interes = round($liquidacion->{'liq_interes'}, 2);
            $data = array(
                'fun_id_liq'=>$identificador
                ,'fun_concepto' => $liquidacion->{'liq_concepto'}
                , 'fun_contribuyente' => trim($liquidacion->{'liq_contribuyente'})
                , 'fun_id_gen' => 1
                , 'fun_fecha' => date('Y-m-d H:i:s')
                , 'fun_subtotal' => $subtotal
                , 'fun_impuesto' => $fiestas
                , 'fun_multa' => $multa
                , 'fun_interes' => $interes
                , 'fun_total' => round($subtotal+$interes+$multa+$fiestas, 2)
              , 'fun_creado_por' => $this->tank_auth->get_user_id() //OBSOLETO
              , 'fun_id_usu' => $this->tank_auth->get_user_id()
              , 'fun_usu_mod' => $this->tank_auth->get_user_id()
              , 'fun_fecha_mod' => date('Y-m-d H:i:s')
              );
            $this->db->insert('fun_funo', $data);
            $fun_id = $this->db->insert_id();
            $detalles_liquidacion=$this->gsatelite->get_tabla('lxd_liquidacionxdetalle_cntc', array('lxd_id_liq'=>$identificador));
            foreach ($detalles_liquidacion as $detalle) {
                $this->db->insert('fxd_funoxdetalle_cntc', array('fxd_id_fun'=>$fun_id, 'fxd_id_det'=>$detalle['lxd_id_det']));
            }
        }else{
            $fun_id=$identificador;
        }

        if (is_numeric($fun_id) && $fun_id > 0) {
            $funo = $this->db->get_where('fun_funo', array('fun_id' => $fun_id), 1)->row();
        }else{
            $this->gsatelite->show_dialog('Sin id de liquidaci&oacute;n', 'utm/caja/carga_laboral', 'error');
        }

        if (isset($funo->fun_id) && $funo->fun_id == $fun_id) {

            $obtener_caja = $this->consultas->obtener_proceso_usuario2($this->tank_auth->get_user_id());


            //SE COMENTÓ LA CONDICIONAL DE QUE SEAN PROCESADOS SI SON DE TIPO 1
            //PARA QUE APARESCAN EN EL REPORTE.
            if ( /*$funo->fun_tipo == 1 && */  $funo->fun_estado > 0) {
                    //registramos el pago en historia de caja

                $arreglo_insertar_detalle_caja = array(
                    'fxc_id_cxu' => (int)$obtener_caja['cxu_id'],
                    'fxc_id_fun' => $funo->fun_id,
                    'fxc_fecha' => date('Y-m-d H:i:s'),
                    'fxc_monto' => $funo->fun_total,
                    'fxc_usu_mod' => $this->tank_auth->get_user_id(),
                    'fxc_fecha_mod' => date('Y-m-d H:i:s'),
                    'fxc_id_tpg' => $tipo_pago
                    );

                $id_fxc = $this->gsatelite->ingresar('fxc_funoxcaja', $arreglo_insertar_detalle_caja);

                    //preguntar por las variables que contienen el detalle del pago con cheque
                    if($banco != 0 and $numerocheque != "" and $montocheque != "") { //preguntar si existen los datos relacionados al tipo de pago cheque
                        //estructurar el código(array) para realizar la inserccion  a la base de datos. (chc_cheque)
                        $arreglo_detalles_cheque = array(
                            'chc_id_fxc'    => $id_fxc,
                            'chc_id_ban'    => $banco,
                            'chc_numero'    => $numerocheque,
                            'chc_monto'     => $montocheque,
                            'chc_fecha'     => date("Y-m-d H:i:s"),
                            'chc_usu_mod'   => $this->tank_auth->get_user_id(),
                            'chc_fecha_mod' => date("Y-m-d H:i:s")
                            );
                        
                        $this->gsatelite->ingresar('chc_cheque_caja', $arreglo_detalles_cheque);
                    }
                    
                    //actualizaos los detalles del f1
                    $cargos = $this->db
                    ->from('fxd_funoxdetalle_cntc')
                    ->join('det_detalle_cntc', 'det_id = fxd_id_det')
                    ->where('fxd_id_fun', $fun_id)
                    ->get()
                    ->result()
                    ;
                    

                    foreach ($cargos as $row) {
                        $det_id = $row->fxd_id_det;
                        //aplicacion de cuenta presupuesto en base a la fecha de pago
                        $cpr_id = $this->caja_model->getIdCuentaPresupuestaria($det_id);

                        $det_updt = array(
                            'det_estado' => 0
                            , 'det_fecha_pago' => date('Y-m-d H:i:s')
                            , 'det_id_cpr' => $cpr_id
                            , 'det_fecha_mod' => date('Y-m-d H:i:s')
                            );
                        
                        $this->db->update(
                            'det_detalle_cntc'
                            , $det_updt
                            , array('det_id' => $det_id)
                            );
                        
                        //aplicamos el abono
                        $abono = array(
                            'abo_id_det'    => $det_id
                            , 'abo_id_fun'    => $fun_id
                        //  , 'abo_tipo'      => 1
                            , 'abo_monto'     => $row->det_monto
                            , 'abo_fecha'     => date('Y-m-d H:i:s')
                            , 'abo_usu_mod'   => $this->tank_auth->get_user_id()
                            , 'abo_fecha_mod' => date('Y-m-d H:i:s')
                            );
                        $this->db->insert('abo_abono', $abono);
                    }
                }
                
                //Pagamos el F-1
                if( $funo->fun_estado > 0 ){
                    $arreglo_actualizar_funo = array(
                        'fun_estado' => 0,
                        'fun_numero' => $numero,
                        'fun_id_caj' => $obtener_caja['cxu_id_caj']
                        );
                    $this->gsatelite->actualizar('fun_funo', $arreglo_actualizar_funo, 'fun_id', $fun_id);      
                    if($this->gsatelite->get_parametro('UATM_LIQUIDACIONES')==1){
                        $pagar_liquidacion = array(
                            'liq_id_usu' => $this->tank_auth->get_user_id(),
                            'liq_usu_mod' => $this->tank_auth->get_user_id(),
                            'liq_estado'=>0,
                            'liq_id_esl' => 2/*Pagado*/
                            );
                        $this->gsatelite->actualizar_registro('liq_liquidacion', $pagar_liquidacion, array('liq_id'=>$identificador));     
                    }              
                }
                
                if($this->gsatelite->get_parametro('ALCALDIA')==2){
                    //Composición del PDF
                    $detalle = $this->utm_model->get_funo_detalle_print($fun_id);
                    $this->load->library('pdf');
                    $this->load->library('texto');
                    $borde = 0;
                    $linea = 8;
                    $ajusteX = 0;
                    $ajusteY = 0;
                    $this->pdf->SetFont('helvetica');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(true, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('P', 'letter'/*array(180, 140)*/, array(
                        'family' => 'helvetica',
                        'style' => '',
                        'size' => 6)
                    );
                    $this->pdf->setPrintFooter(false);
                    
                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(215.6, 139.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(0.2, 140.2, true);
                    $this->pdf->Cell(107.6, 130.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(108.2, 140.2, true);
                    $this->pdf->Cell(107.6, 130.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                    
                    $meses = array(
                        1 => 'Enero',
                        'Febrero',
                        'Marzo',
                        'Abril',
                        'Mayo',
                        'Junio',
                        'Julio',
                        'Agosto',
                        'Septiembre',
                        'Octubre',
                        'Noviembre',
                        'Diciembre'
                        );
                    $fecha = explode('-', $funo->fun_fecha);
                    //$fecha = $date[2] . ' de ' . $meses[(int)$date[1]] . ' de ' . $date[0];
                    //$fecha = strtoupper($fecha);
                    $dia = (int)$fecha[2];
                    $mes = strtoupper($meses[(int)$fecha[1]]);
                    $anio = $fecha[0];
                    $centavos = ' ' . ($funo->fun_total - (int)$funo->fun_total) . '/100';
                    var_dump($fecha); exit;
                    //numero
                    //$this->pdf->SetXY( 25+$ajusteX, 23+$ajusteY); $this->pdf->Cell(70, $linea, 'CHALATENANGO, ', $borde,0,'L',false,'', 3,false,'T', 'B');
                    
                    //fecha
                    /*
                    $this->pdf->SetXY(25 + $ajusteX, 22 + $ajusteY);
                    $this->pdf->Cell(70, $linea, $this->gsatelite->get_parametro('NOMBRE_MUNICIPIO'), $borde, 0, 'L', false, '', 3, false, 'T', 'B');
                    $this->pdf->SetXY(100 + $ajusteX, 22 + $ajusteY);
                    $this->pdf->Cell(15, $linea, $dia, $borde, 0, 'C', false, '', 3, false, 'T', 'B');
                    $this->pdf->SetXY(122 + $ajusteX, 22 + $ajusteY);
                    $this->pdf->Cell(33, $linea, $mes, $borde, 0, 'C', false, '', 3, false, 'T', 'B');
                    $this->pdf->SetXY(163 + $ajusteX, 22 + $ajusteY);
                    $this->pdf->Cell(13, $linea, $anio, $borde, 0, 'C', false, '', 3, false, 'T', 'B');
                    */
                    $this->pdf->SetXY(10 + $ajusteX, 27 + $ajusteY);
                    $this->pdf->Cell(30, $linea, 'Fecha '.$identificador, $borde, 0, 'L', false, '', 3, false, 'T', 'B');
                    
                    //Recibo
                    $this->pdf->SetXY(175 + $ajusteX, 27 + $ajusteY);
                    $this->pdf->Cell(30, $linea, 'No. '.$identificador, $borde, 0, 'L', false, '', 3, false, 'T', 'B');
                    
                    //monto
                    $this->pdf->SetXY(37 + $ajusteX, 33 + $ajusteY, true);
                    //$this->pdf->Cell(28, $linea, ' $ ' . strtoupper(number_format($funo->fun_total, 2)), $borde, 0, 'C', false, '', 0, false, 'T', 'B');
                    
                    //AlaOrden
                    //$this->pdf->MultiCell(60, 16, strtoupper($funo->fun_contribuyente), $borde, 'C', false, 0, 5 + $ajusteX, 50 + $ajusteY);
                    //textMonto
                    $this->pdf->MultiCell(100, 10, strtoupper($this->texto->ValorEnLetras((int)$funo->fun_total, '')) . ' ' . round($centavos * 100, 2) . '/100 DOLARES', $borde, 'C', false, 0, 5 + $ajusteX, 125 + $ajusteY);
                    
                    //detalle
                    $concepto = trim(preg_replace('/\s\s+/', " ", strtoupper($funo->fun_concepto)));
                    $this->pdf->writeHTMLCell(200, 30, 8 + $ajusteX, 35 + $ajusteY, $concepto, $borde, 0, false, true, 'L');
                    
                    //detalle
                    $this->pdf->SetFont('courier', '', 10);
                    $pos = 75 + $ajusteY;
                    $d_linea = 5;
                    
                    foreach ($detalle as $row) {
                        $this->pdf->SetXY(40, $pos);
                        $this->pdf->Cell(100, $d_linea, strtoupper($row->numero . ' ' . $row->nombre), $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                        $this->pdf->Cell(2, $d_linea, '$', $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                        $this->pdf->SetXY(150, $pos);
                        $this->pdf->Cell(25, $d_linea, number_format($row->monto, 2) . ' ', $borde, 0, 'R', false, '', 0, false, 'T', 'B');
                        
                        //nueva linea
                        $pos += $d_linea;
                    }
                    //Detalle Tesoreria
                    $this->pdf->SetXY(10 + $ajusteX, 162 + $ajusteY);
                    $this->pdf->Cell(30, $linea, 'Fecha '.$identificador, $borde, 0, 'L', false, '', 3, false, 'T', 'B');
                    $this->pdf->SetXY(70 + $ajusteX, 162 + $ajusteY);
                    $this->pdf->Cell(30, $linea, 'No. '.$identificador, $borde, 0, 'L', false, '', 3, false, 'T', 'B');
                    $this->pdf->writeHTMLCell(100, 20, 6 + $ajusteX, 170 + $ajusteY, $concepto, $borde, 0, false, true, 'L');
                    
                    $pos = 200 + $ajusteY;
                    $d_linea = 5;
                    
                    foreach ($detalle as $row) {
                        $this->pdf->SetXY(15, $pos);
                        $this->pdf->Cell(65, $d_linea, strtoupper($row->numero . ' ' . $row->nombre), $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                        $this->pdf->Cell(2, $d_linea, '$', $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                        $this->pdf->SetXY(80, $pos);
                        $this->pdf->Cell(25, $d_linea, number_format($row->monto, 2) . ' ', $borde, 0, 'R', false, '', 0, false, 'T', 'B');
                        
                        //nueva linea
                        $pos += $d_linea;
                    }
                    //Detalle Contabiidad
                    $this->pdf->SetXY(113 + $ajusteX, 162 + $ajusteY);
                    $this->pdf->Cell(30, $linea, 'Fecha '.$identificador, $borde, 0, 'L', false, '', 3, false, 'T', 'B');
                    $this->pdf->SetXY(175 + $ajusteX, 162 + $ajusteY);
                    $this->pdf->Cell(30, $linea, 'No. '.$identificador, $borde, 0, 'L', false, '', 3, false, 'T', 'B');
                    $this->pdf->writeHTMLCell(100, 20, 110 + $ajusteX, 170 + $ajusteY, $concepto, $borde, 0, false, true, 'L');
                    
                    $pos = 200 + $ajusteY;
                    $d_linea = 5;
                    
                    foreach ($detalle as $row) {
                        $this->pdf->SetXY(110, $pos);
                        $this->pdf->Cell(65, $d_linea, strtoupper($row->numero . ' ' . $row->nombre), $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                        $this->pdf->Cell(2, $d_linea, '$', $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                        $this->pdf->SetXY(175, $pos);
                        $this->pdf->Cell(25, $d_linea, number_format($row->monto, 2) . ' ', $borde, 0, 'R', false, '', 0, false, 'T', 'B');
                        
                        //nueva linea
                        $pos += $d_linea;
                    }
                    
                    //pie
                    $pos = 140;
                    $this->pdf->SetFont('courierB', '', 12);
                    $this->pdf->SetXY(107 + $ajusteX, $pos-15);
                    $this->pdf->Cell(23, $linea, '', $borde, 0, 'C', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(130 + $ajusteX, $pos-15);
                    $this->pdf->Cell(23, $linea, '', $borde, 0, 'C', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(153 + $ajusteX, $pos-15);
                    $this->pdf->Cell(23, $linea, '$ ' . strtoupper(number_format($funo->fun_total, 2)) . ' ', $borde, 0, 'R', false, '', 0, false, 'T', 'B');
                    
                    $this->pdf->boletaPDF('I');
                }else{
                    //Composición del PDF
                    $detalle = $this->utm_model->get_funo_detalle_print($fun_id);


                    $this->load->library('pdf');
                    $this->load->library('texto');
                    $borde = 0;
                    $linea = 8;
                    $ajusteX = 0;
                    $ajusteY = 0;
                    $this->pdf->SetFont('helvetica');
                    $this->pdf->setCellPaddings(0, 0, 0, 0);
                    $this->pdf->SetAutoPageBreak(true, 0);
                    $this->pdf->SetMargins(10, 0, 5);
                    $this->pdf->AddPage('L', array(180, 140), array(
                        'family' => 'helvetica',
                        'style' => '',
                        'size' => 6)
                    );
                    $this->pdf->setPrintFooter(false);
                    
                    $this->pdf->SetXY(0.2, 0.2, true);
                    $this->pdf->Cell(179.6, 129.6, '', $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                    
                    $meses = array(
                        1 => 'Enero',
                        'Febrero',
                        'Marzo',
                        'Abril',
                        'Mayo',
                        'Junio',
                        'Julio',
                        'Agosto',
                        'Septiembre',
                        'Octubre',
                        'Noviembre',
                        'Diciembre'
                        );
                    $fecha = explode('-', $funo->fun_fecha);
                    //$fecha = $date[2] . ' de ' . $meses[(int)$date[1]] . ' de ' . $date[0];
                    //$fecha = strtoupper($fecha);
                    $dia = (int)$fecha[2];
                    $mes = strtoupper($meses[(int)$fecha[1]]);
                    $anio = $fecha[0];
                    $centavos = ' ' . ($funo->fun_total - (int)$funo->fun_total) . '/100';
                    
                    //numero
                    //$this->pdf->SetXY( 25+$ajusteX, 23+$ajusteY); $this->pdf->Cell(70, $linea, 'CHALATENANGO, ', $borde,0,'L',false,'', 3,false,'T', 'B');
                    
                    //fecha
                    $this->pdf->SetXY(25 + $ajusteX, 22 + $ajusteY);
                    $this->pdf->Cell(70, $linea, $this->gsatelite->get_parametro('NOMBRE_MUNICIPIO'), $borde, 0, 'L', false, '', 3, false, 'T', 'B');
                    $this->pdf->SetXY(100 + $ajusteX, 22 + $ajusteY);
                    $this->pdf->Cell(15, $linea, $dia, $borde, 0, 'C', false, '', 3, false, 'T', 'B');
                    $this->pdf->SetXY(122 + $ajusteX, 22 + $ajusteY);
                    $this->pdf->Cell(33, $linea, $mes, $borde, 0, 'C', false, '', 3, false, 'T', 'B');
                    $this->pdf->SetXY(163 + $ajusteX, 22 + $ajusteY);
                    $this->pdf->Cell(13, $linea, $anio, $borde, 0, 'C', false, '', 3, false, 'T', 'B');
                    
                    //monto
                    $this->pdf->SetXY(37 + $ajusteX, 33 + $ajusteY, true);
                    $this->pdf->Cell(28, $linea, ' $ ' . strtoupper(number_format($funo->fun_total, 2)), $borde, 0, 'C', false, '', 0, false, 'T', 'B');
                    
                    //AlaOrden
                    $this->pdf->MultiCell(60, 16, strtoupper($funo->fun_contribuyente), $borde, 'C', false, 0, 5 + $ajusteX, 50 + $ajusteY);
                    //textMonto
                    $this->pdf->MultiCell(60, 16, strtoupper($this->texto->ValorEnLetras((int)$funo->fun_total, '')) . ' ' . round($centavos * 100, 2) . '/100 DOLARES', $borde, 'C', false, 0, 5 + $ajusteX, 80 + $ajusteY);
                    
                    //detalle
                    $concepto = trim(preg_replace('/\s\s+/', " ", strtoupper($funo->fun_concepto)));
                    $this->pdf->writeHTMLCell(100, 30, 75 + $ajusteX, 45 + $ajusteY, $concepto, $borde, 0, false, true, 'C');
                    
                    //detalle
                    $this->pdf->SetFont('courier', '', 10);
                    $pos = 75 + $ajusteY;
                    $d_linea = 5;
                    foreach ($detalle as $row) {
                        $this->pdf->SetXY(70, $pos);
                        $this->pdf->Cell(80, $d_linea, strtoupper($row->numero . ' ' . $row->nombre), $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                        $this->pdf->Cell(2, $d_linea, '$', $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                        $this->pdf->SetXY(150, $pos);
                        $this->pdf->Cell(25, $d_linea, number_format($row->monto, 2) . ' ', $borde, 0, 'R', false, '', 0, false, 'T', 'B');
                        
                        //nueva linea
                        $pos += $d_linea;
                    }
                    
                    //pie
                    $this->pdf->SetFont('courierB', '', 12);
                    $this->pdf->SetXY(107 + $ajusteX, -15);
                    $this->pdf->Cell(23, $linea, '', $borde, 0, 'C', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(130 + $ajusteX, -15);
                    $this->pdf->Cell(23, $linea, '', $borde, 0, 'C', false, '', 0, false, 'T', 'B');
                    $this->pdf->SetXY(153 + $ajusteX, -15);
                    $this->pdf->Cell(23, $linea, '$ ' . strtoupper(number_format($funo->fun_total, 2)) . ' ', $borde, 0, 'R', false, '', 0, false, 'T', 'B');
                    
                    $this->pdf->boletaPDF('I');
                }
            }

            $this->gsatelite->show_dialog('No Existe', 'tesoreria/cuentas/gestion_cheques', 'error');

        }


        /*Esta funcion nos ayudara al momento de querer anular cualquier f-1 que el usuario considere apropiado en su momento anular*/
        /*Ronald Ortiz Date:Monday 01th, July, 2013 04:55:50 pm*/
        function anular_funo(){
            $valor = $this->input->post('datos');
            if($valor != ""){
                if($this->gsatelite->get_parametro('UATM_LIQUIDACIONES')==1){
                    $arreglo_actualizar_estado = array('liq_id_esl'=>3, 'liq_estado' => 0);
                    $this->gsatelite->actualizar_registro('liq_liquidacion',$arreglo_actualizar_estado, array('liq_id'=>$valor));
                }else{   
                    $arreglo_actualizar_estado = array('fun_estado' => '-2', 'fun_fecha_anulacion'=>date('Y-m-d')); /*-2 Anulado, -1 Revertido*/
                    $this->gsatelite->actualizar('fun_funo',$arreglo_actualizar_estado,'fun_id',$valor);
                }
                $data = 1;
            } else{
                $data = 0;
            }
            $response = array( "resultado" => $data );
            echo json_encode($response); 
        }

    /**
     * Caja::actualiza_impuesto()
     * 
     * @return void
     */
    function actualiza_impuesto()
    {
        $funo     = $this->input->post('funo');
        $impuesto = $this->input->post('con_impuesto');
        $data_funo = $this->db->query('select * from fun_funo where fun_id ='.$funo)->row_array();
        $subtotal = $data_funo['fun_subtotal'];
        if($impuesto == 1){
            if( $data_funo['fun_impuesto'] <= 0 ){
                $nuevo_total = round(($data_funo['fun_total'] + ($data_funo['fun_subtotal']*0.05)),2); 
                
                $n_total= $nuevo_total;
                //hacer valer los 5%
                $this->db->query('update fun_funo set fun_impuesto= 0.05, fun_total='.$n_total.' where fun_id='.$funo);
            }
        }
        if($impuesto == 0){

            $nuevo_total = round(($data_funo['fun_total'] - ($data_funo['fun_subtotal']*0.05)),2);
            $n_total= $nuevo_total;
            //hacer valer los 5%
            $this->db->query('update fun_funo set fun_impuesto= 0.00, fun_total='.$n_total.' where fun_id='.$funo);

        }
        
        $this->detalle_caja($funo);
    }

    /**
    * @author René Castaneda
    * @return consulta de los pagos que ya fueron efectuados (mediante un filtro)
    *
    */

    function pagos_realizados() {
        satelite_validar();
        $data=array();
        if($_POST){ //preguntar si existe el post
            $opcion=$this->input->post('opcionF');
            $criterio=$this->input->post('filtro');
            if($opcion==1){ //# comprobante
                $data['funo'] = $this->caja_model->funos_pagados(array('fun_numero' => $criterio));
                $html= $this->load->view('utm/caja/detalles_funo_pagados', $data, true);
                echo json_encode(array('resultado'=>$html));
            }
            elseif($opcion==2) { //nombre de contribuyente
                $this->db->like('fun_contribuyente',$criterio);
                $data['funo'] = $this->caja_model->funos_pagados();
                $html= $this->load->view('utm/caja/detalles_funo_pagados', $data, true);
                echo json_encode(array('resultado'=>$html));
            }
            elseif ($opcion==3) { //fecha generado
                $criterio = str_replace('/', '-', $criterio);
                $criterio = date('Y-m-d', strtotime($criterio));
                $data['funo'] = $this->caja_model->funos_pagados(array("DATE_FORMAT(fun_fecha,'%Y-%m-%d')" => $criterio));
                $html= $this->load->view('utm/caja/detalles_funo_pagados', $data, true);
                echo json_encode(array('resultado'=>$html));
            }
        } else {
          $this->_cargarvista(null,$data);  
      } 

  }

    /**
    * @author René Castaneda
    */
    function revertir_pago_realizado() {
     satelite_validar(true);
     $id_funo= $this->input->post('identificador');
         //echo $id_funo; die();
     if($id_funo != null and $id_funo > 0 ) {
            //preguntar por el registro completo del funo
        $reg_funo = $this->gsatelite->get_registro('fun_funo','fun_id', $id_funo);
            //crear un nuevo funo identico al anterior
        $Nuevofuno = array(
           'fun_id_usu'         => $reg_funo->fun_id_usu
           , 'fun_id_liq'        => $reg_funo->fun_id_liq
           , 'fun_id_gen'        => $reg_funo->fun_id_gen
           , 'fun_concepto'      => $reg_funo->fun_concepto
           , 'fun_contribuyente' => $reg_funo->fun_contribuyente
           , 'fun_fecha'         => $reg_funo->fun_fecha
           , 'fun_subtotal'      => $reg_funo->fun_subtotal
           , 'fun_impuesto'      => $reg_funo->fun_impuesto
           , 'fun_multa'         => $reg_funo->fun_multa
           , 'fun_interes'       => $reg_funo->fun_interes
           , 'fun_total'         => $reg_funo->fun_total
           , 'fun_estado'        => 1
           , 'fun_tipo'          => $reg_funo->fun_tipo
           , 'fun_usu_mod'       => $this->tank_auth->get_user_id()
           , 'fun_fecha_mod'     => date("Y-m-d H:i:s")
           );
        $id_nuevoFuno = $this->gsatelite->ingresar('fun_funo', $Nuevofuno);
            //actualizar funo que se revirtio
        $ActualizarFun = array(
            'fun_estado'    => -1
            ,'fun_usu_mod'  => $this->tank_auth->get_user_id()
            ,'fun_fecha_mod'=>date("Y-m-d H:i:s")
            );
        $this->gsatelite->actualizar('fun_funo',$ActualizarFun,'fun_id',$id_funo);

        if( $reg_funo->fun_tipo == 1 ) { 
               //los funo de tipo 1 crean un fxc_funoxcaja
           $ActualizarFxc = array(
            'fxc_estado'    => -1
            ,'fxc_usu_mod'  => $this->tank_auth->get_user_id()
            ,'fxc_fecha_mod'=>date("Y-m-d H:i:s")
            );
           $this->gsatelite->actualizar('fxc_funoxcaja',$ActualizarFxc,'fxc_id_fun',$id_funo);
           $Actualizarabono = array(
             'abo_estado'   => -1
             ,'abo_usu_mod'  => $this->tank_auth->get_user_id()
             ,'abo_fecha_mod'=> date('Y-m-d H:i:s')
             );
           $this->gsatelite->actualizar('abo_abono',$Actualizarabono,'abo_id_fun',$id_funo);

                //consultamos los detalles
           $detalles = $this->caja_model->detallesxfuno($id_funo);
           foreach ($detalles as $row) {
            $det_id = $row->fxd_id_det;
            $reg_det = $this->gsatelite->get_registro('det_detalle_cntc','det_id', $det_id);
            $NuevoDet = array(
                'det_id_sxc'      => $reg_det->det_id_sxc
                ,'det_id_cpr'     =>  $reg_det->det_id_cpr
                ,'det_fecha'      =>  $reg_det->det_fecha
                ,'det_fecha_cargo'=>  $reg_det->det_fecha_cargo
                ,'det_monto'      =>  $reg_det->det_monto
                ,'det_origen'     =>  $reg_det->det_origen
                ,'det_estado'     =>  1
                ,'det_user_mod'   =>  $reg_det->det_user_mod
                ,'det_fecha_mod'  => date('Y-m-d H:i:s')
                ,'det_monto_multa'=> $reg_det->det_monto_multa
                ,'det_multa_id'   => $reg_det->det_multa_id
                );
            $id_nuevoDet = $this->gsatelite->ingresar('det_detalle_cntc', $NuevoDet);

            //en el caso de riego actualizar los registros que contiene el antiguo det_id
            $this->gsatelite->actualizar('rie_riego',array('rie_id_det'=>$id_nuevoDet),'rie_id_det', $det_id);
            //en el caso de galonaje actualizar los registros que contiene el antiguo det_id
            $this->gsatelite->actualizar('gal_galonaje',array('gal_id_det'=>$id_nuevoDet),'gal_id_det', $det_id);
            
                        //crear un nuevos fxd 
                        //NOTA: los antiguos fxd no se actualizan porque no manejan estado
            $NuevoFxd = array(
                'fxd_id_det'   => $id_nuevoDet
                ,'fxd_id_fun' => $id_nuevoFuno
                );
            $id_nuevoFxd = $this->gsatelite->ingresar('fxd_funoxdetalle_cntc', $NuevoFxd);

            $ActualizarDet = array(
                'det_estado'     => -1
                , 'det_user_mod' => $this->tank_auth->get_user_id()
                , 'det_fecha_mod'=> date('Y-m-d H:i:s')
                );
            
            $this->gsatelite->actualizar('det_detalle_cntc',$ActualizarDet,'det_id',$det_id);
        } 

    }

    if($id_nuevoFuno>0) {
        echo json_encode(array('exito'=>1));
    }  
    else {
        echo json_encode(array('exito'=>0));
    }
}


}		

    /**
     * @author Boris Estrada
     * @param INT - ID de la cuenta
     * Consultar el saldo disponible de una cuenta acumulado en notas de crédito
     */
    function saldo_nota_credito(){
        $funo=$this->input->post('funo');
        $campo=$this->gsatelite->get_campo('fxd_funoxdetalle_cntc', 'fxd_id_det', array('fxd_id_fun'=>$funo));
        $detalle=(is_object($campo))? $campo->fxd_id_det: $campo;
        $campo=$this->gsatelite->get_campo('det_detalle_cntc', 'det_id_sxc', array('det_id'=>$detalle));
        $servicio_cuenta=(is_object($campo))? $campo->det_id_sxc: $campo;
        $campo=$this->gsatelite->get_campo('sxc_servicioxcuenta_corriente', 'sxc_cnt_id', array('sxc_id'=>$servicio_cuenta));
        $cuenta=(is_object($campo))? $campo->sxc_cnt_id: $campo;
        $saldo=$this->uatm->saldo_nota_credito($cuenta);
        $array_datos=array(
            'saldo'=>$saldo
            );
        echo json_encode($array_datos);
    }	  
    /**
     * @author Boris Estrada
     * @param INT - ID de la cuenta
     * @param FLOAT - Monto a descontar del saldo de credito
     */
    function actualizar_credito(){
        $funo=$this->input->post('funo');
        $descontar=$this->input->post('descontar');
        $funo=$this->input->post('funo');
        $campo=$this->gsatelite->get_campo('fxd_funoxdetalle_cntc', 'fxd_id_det', array('fxd_id_fun'=>$funo));
        $detalle=(is_object($campo))? $campo->fxd_id_det: $campo;
        $campo=$this->gsatelite->get_campo('det_detalle_cntc', 'det_id_sxc', array('det_id'=>$detalle));
        $servicio_cuenta=(is_object($campo))? $campo->det_id_sxc: $campo;
        $campo=$this->gsatelite->get_campo('sxc_servicioxcuenta_corriente', 'sxc_cnt_id', array('sxc_id'=>$servicio_cuenta));
        $cuenta=(is_object($campo))? $campo->sxc_cnt_id: $campo;
        $notas=$this->gsatelite->get_tabla('ntc_nota_credito', array('ntc_id_cnt'=>$cuenta, 'ntc_estado'=>1));
        $cantidad=count($notas);

        for ($i=0; $i <= $cantidad ; $i++) { 
            $monto_real=$notas[$i]['ntc_monto']-$notas[$i]['ntc_monto_cancelado'];

            if($monto_real>$descontar){
                $descontado=$descontar;
                $this->gsatelite->actualizar_registro('ntc_nota_credito', array('ntc_monto_cancelado'=>$notas[$i]['ntc_monto_cancelado']+$descontado, 'ntc_usu_mod'=>$this->tank_auth->get_user_id(), 'ntc_fecha_mod'=>date('Y-m-d H:i:s')), array('ntc_id'=>$notas[$i]['ntc_id']));
            }else{
                /*Lo que se descuenta es mayor o igual*/
                $descontado=$monto_real;
                $this->gsatelite->actualizar_registro('ntc_nota_credito', array('ntc_monto_cancelado'=>$notas[$i]['ntc_monto_cancelado']+$descontado, 'ntc_estado'=>0, 'ntc_usu_mod'=>$this->tank_auth->get_user_id(), 'ntc_fecha_mod'=>date('Y-m-d H:i:s')), array('ntc_id'=>$notas[$i]['ntc_id']));
            }
            $descontar-=$descontado;
            if($descontar==0){
                $i=$cantidad;
            }
        }  
    }

    function _cargarvista($data=0,$crud=0)
    {	
        $this->load->view('vacia',$crud);	
        if($data!=0)
            $data=array_merge($data,$this->masterpage->getUsuario());
        else
            $data=$this->masterpage->getUsuario();

        $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content',$data);
        $this->masterpage->show();
    }
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */