<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Bancos
 * 
 * @package   
 * @author erpConamype
 * @copyright satelite
 * @version 2013
 * @access public
 */
class Bancos extends CI_Controller
{
	/**
	 * Bancos::__construct()
	 * 
	 * @return
	 */
	function __construct()
	{
		parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->library('Procesos');
	}

	/**
	 * Bancos::index()
	 * 
	 * @return
	 */
	function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {			
			$this->_cargarvista();
		}
	}
    
    /**
     * Bancos::gestion_bancos()
     * @author Alexis Beltran
     * 
     * @return
     */
    function gestion_bancos(){
        //(new Procesos())->validar_user();
        satelite_validar();
        try
		{
            
            $crud = new grocery_CRUD;
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud->set_table('ban_banco');
            $crud->set_subject('Banco');
            $crud->columns('ban_nombre','ban_prefijo','ban_sufijo','ban_contacto','ban_estado');
            $crud->display_as('ban_nombre','Nombre');
            $crud->display_as('ban_estado','Estado');
            $crud->display_as('ban_contacto','Ejecutivo');
            $crud->display_as('ban_telefono','Teléfono');
            $crud->display_as('ban_observacion','Observaciones');
            $crud->display_as('ban_prefijo','Prefijo de chequera');
            $crud->display_as('ban_sufijo','Sufijo de chequera');

             if(end(explode('/',uri_string()))=='add') {
            $crud->field_type('ban_estado','hidden',1);
            }
            else {
            $crud->field_type('ban_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $crud->required_fields('ban_nombre');
            $crud->add_fields('ban_nombre','ban_prefijo','ban_sufijo','ban_contacto','ban_telefono','ban_observacion','ban_estado');
            $crud->edit_fields('ban_nombre','ban_prefijo','ban_sufijo','ban_contacto','ban_telefono','ban_observacion','ban_estado');
            
            $crud->field_type('ban_usu_mod','hidden',$this->tank_auth->get_user_id());
    		$crud->field_type('ban_fecha_mod','hidden',date('Y-m-d H:i:s'));
            $crud->set_rules('ban_nombre','Nombre','trim|required|campo_unico[ban_banco.ban_nombre]');

            $crud->unset_delete();
            $crud->set_language('spanish');
            $data['titulo_personal']="Gestión bancos";
            // Validar Permisos. Agregado por Luis Navarro
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }

            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }
            $output = $crud->render();
            $this->_cargarvista($data, $output);
		}
		catch(Exception $e)
		{
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }

    
    /**
     * Bancos::gestion_bancos()
     * @author Melbin Cruz
     * 
     * @return
     */
    //Nota: catalogo compartido con expediente de personal==> controller: catalogos.php (function tipo_cuenta) //added by Rene Castaneda 07/12/2017
    function gestion_cuenta(){
        //(new Procesos())->validar_user();
        satelite_validar();
        try
		{
            $crud = new grocery_CRUD;
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud->set_table('tpc_tipo_cuenta');
            $crud->columns('tpc_nombre','tpc_estado');
            $crud->set_subject('cuentas');
            $crud->display_as('tpc_nombre','Nombre');
            $crud->display_as('tpc_estado','Estado');

            if(end(explode('/',uri_string()))=='add') {
            $crud->field_type('tpc_estado','hidden',1);
            }
            else {
            $crud->field_type('tpc_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $crud->required_fields('tpc_nombre');
            $crud->add_fields('tpc_nombre','tpc_estado','tpc_usu_mod','tpc_fecha_mod');
            $crud->edit_fields('tpc_nombre','tpc_estado','tpc_usu_mod','tpc_fecha_mod');
            
            $crud->field_type('tpc_usu_mod','hidden',$this->tank_auth->get_user_id());
    		$crud->field_type('tpc_fecha_mod','hidden',date('Y-m-d h:i:s'));
            $crud->set_rules('tpc_nombre','Nombre','trim|required|campo_unico[tpc_tipo_cuenta.tpc_nombre]');
            
            $crud->unset_delete();
        
            // Validar permisos. Agregado por Luis Navarro
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_ver"]) {
               $crud->unset_read();
            }

            $crud->set_language('spanish');
            $data['titulo_personal']="Tipo de cuenta";
            $output = $crud->render();
            $vista = 'utm/bancos/gestion_cuenta';
            cargarvista($data, $output, $vista);
            //$this->_cargarvista($data, $output);
		}
		catch(Exception $e)
		{
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }

    /**
     * @author Melbin Cruz
     * 
     * @return
     */
    function gestion_fondos(){

		  //(new Procesos())->validar_user();
          satelite_validar();
        try
		{
            $crud = new grocery_CRUD;
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud->set_table('orf_origen_fondos');
            $crud->set_subject('Fondos');
            $crud->columns('orf_nombre','orf_estado');
            
            $crud->display_as('orf_nombre','Nombre');
            $crud->display_as('orf_estado','Estado');

             if(end(explode('/',uri_string()))=='add') {
            $crud->field_type('orf_estado','hidden',1);
            }
            else {
            $crud->field_type('orf_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $crud->required_fields('orf_nombre');
            $crud->add_fields('orf_nombre','orf_estado','orf_usu_mod','orf_fecha_mod');
            $crud->edit_fields('orf_nombre','orf_estado','orf_usu_mod','orf_fecha_mod');
            
            $crud->field_type('orf_usu_mod','hidden',$this->tank_auth->get_user_id());
    		$crud->field_type('orf_fecha_mod','hidden',date('Y-m-d h:i:s'));
            $crud->set_rules('orf_nombre','Nombre','trim|required|campo_unico[orf_origen_fondos.orf_nombre]');
            
            $crud->unset_delete();
            // Validar permisos. Agregado por Luis Navarro
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            $crud->set_language('spanish');
            $data['titulo_personal']="Gestión fondos";
            $output = $crud->render();
            $this->_cargarvista($data, $output);
		}
		catch(Exception $e)
		{
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
    }

    
	/**
	 * Bancos::_cargarvista()
	 * 
	 * @param integer $data
	 * @param integer $crud
	 * @return
	 */
	function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */