<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reportes extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->database();
		$this->load->helper('url');
		$this->load->model('entradas_model');
    $this->load->model('transporte_model');
		$this->load->library('grocery_CRUD');
		$this->load->library('pdf');
    $this->load->library('excel/excel_reader.php');
		//$this->load->library('ssrsphp/library/SSRS/Report');

	}

	// All your functions goes here
	public function prueba()
	{
		satelite_validar();
		
		try {

			$data['titulo_personal']="Prueba de reporte";
			$this->_cargarvista($data,null);

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} // end of prueba

	public function reporte_cupones_combustible()
	{
		satelite_validar();
		
		try {
      //$distribucion_combustible=$this->entradas_model->get_distribucion_combustible();
			
      $data['titulo_personal']="Reporte de cupones de combustible";
			$this->_cargarvista($data,null);

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} // end of prueba

	


	

	
	


	public function reporte_entrega_vehiculo($id_solicitud=null)
	{
		satelite_validar();
		try {
			$data['titulo_personal']="Reporte Misión Oficial";
			$data['id_solicitud']=$id_solicitud;
			//$this->_cargarvista($data,null);

			$this->gsatelite->cargar_vista_masterpage("transporte/reportes/reporte_entrega_vehiculo",$data);

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} 




	public function reporte_control_combustible()
	{
		satelite_validar();
		try {
			$data['titulo_personal']="Reporte Control Combustible";
			$this->_cargarvista($data,null);

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} 

	public function reporte_distribucion_combustible()
	{
		satelite_validar();
		try {
			$data['titulo_personal']="Reporte Distribución Combustible";
			$this->_cargarvista($data,null);

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} 

	public function reporte_ejecucion_contratos()
	{
		satelite_validar();
		try {
			$data['titulo_personal']="Reporte Ejecución de Contratos";
			$this->_cargarvista($data,null);

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}

	

	/*public function imprimir_sol_comb_departamentales($id_solicitud=null)
	{
		satelite_validar();
		try {
			$data['titulo_personal']="Reporte Soliciutd de Combustible";
			$data['id_dtc']=$id_solicitud;
			$this->_cargarvista($data,null);

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}		
	}*/

	

	

		public function reporte_hoja_seguimiento_contrato()
	{
		satelite_validar();
		try {
			$data['titulo_personal']="Reporte Hoja de Seguimiento Contrato";
			$this->_cargarvista($data,null);

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} 
public function imprimir_solicitud_transporte($id_solicitud)
	{
		satelite_validar();
		
		try {

          $solicitud_transporte=$this->entradas_model->get_solicitud_transporte($id_solicitud);

          $cadena="";

            //$rows="REPORTES DE NOTAS POR ALUMNO";

                $rows=$this->load->view('reporte/header', array('titulo' => "Solicitud de Transporte"), true);
               
             	
                foreach ($solicitud_transporte as $key => $sld) {

               // $estado= (!empty($sld['esk_nombre'])) ?$sld['esk_nombre']: "Sin asignar";
                $hora = date("h:i a", strtotime($sld['dtt_hora_salida']));

             	$cadena.='<br><br><br><br><table  style="">';

               	$cadena.='<tr>';
                $cadena.='<td style="text-align:left; height: 20px; width:23%; font-size: 10px; font-weight:bold;">Estado:</td>';
              	$cadena.='<td style="font-size: 10px; width:60%; text-align:left;">'.$sld['estado'].'</td>';
                $cadena.='</tr>';

                $cadena.='<tr>';
                $cadena.='<td style="text-align:left; height: 20px; font-size: 10px; font-weight:bold;">Medio de recepción:</td>';
              	$cadena.='<td style="font-size: 10px; text-align:left;">'.$sld['mrc_nombre'].'</td>';
                $cadena.='</tr>';

                $cadena.='<tr>';
                $cadena.='<td style="text-align:left; height: 20px; font-size: 10px; font-weight:bold;">Fecha de salida:</td>';
              	$cadena.='<td style="font-size: 10px; text-align:left;">'.$sld['fecha'].'</td>';
                $cadena.='</tr>';

                $cadena.='<tr>';
                $cadena.='<td style="text-align:left; height: 20px; font-size: 10px; font-weight:bold;">Hora de salida:</td>';
              	$cadena.='<td style="font-size: 10px; text-align:left;">'.$hora.'</td>';
                $cadena.='</tr>';

                $cadena.='<tr>';
                $cadena.='<td style="text-align:left; height: 20px; font-size: 10px; font-weight:bold;">Cantidad personas:</td>';
              	$cadena.='<td style="font-size: 10px; text-align:left;">'.$sld['dtt_cantidad_per'].'</td>';
                $cadena.='</tr>';

                $cadena.='<tr>';
                $cadena.='<td style="text-align:left; height: 20px; font-size: 10px; font-weight:bold;">Destino:</td>';
              	$cadena.='<td style="font-size: 10px;  text-align:left;">'.$sld['ubicaciones'].'</td>';
                $cadena.='</tr>';
				$cadena.='</table><br><br><br><br>';

				$cadena.='<table  style="">';
                $cadena.='<tr>';
                $cadena.='<td style="text-align:left; height:20px; width:37%; font-weight:bold; font-size: 10px;">Destino y Actividad a Realizar:</td>';
              	$cadena.='<td style="font-size: 10px; ">'.$sld['destino_actividad'].'</td>';
                $cadena.='</tr>';
                $cadena.='</table>';


            		}

          

            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']     = $rows;
            $data['table_tbody']      = $cadena;
            $data['filename']         = $filename;
            //$data['titulo_personal']="Reporte Solicitud de Transporte";
            
               $this->pdf->reportePDF('transporte/reportes/imprimir_solicitud_transporte', $data,'');
                 //$this->load->view('transporte/reportes/imprimir_solicitud_transporte',$data);
         
			

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}


	
	public function imprimir_seguimiento_contratos($id_solicitud)
	{
		satelite_validar();		
		try {
			$seguimientos_contratos = $this->entradas_model->get_seguimientos_contratos($id_solicitud); 
          	// die(print_r(var_dump($seguimientos_contratos),true));
			$per_garantia=$seguimientos_contratos[0]['periodo_garantia'];
			$fecha_gar=explode('-', $per_garantia);
			$per_anticipo=$seguimientos_contratos[0]['periodo_anticipo'];
			$fecha_anti=explode('-', $per_anticipo);
			if(trim($fecha_anti[0])=='' && trim($fecha_anti[1])==''){
				$periodo_antic="NO APLICA";
			}else{
				$periodo_antic=$per_anticipo;
			}
			if(trim($fecha_gar[0])=='' && trim($fecha_gar[1])=='') {
				$periodo_gar="NO APLICA";
			}else{
				$periodo_gar=$per_garantia;
			}
			$cadena="";
			$rows=$this->load->view('reporte/header', array('titulo' => "Seguimiento de Contrato"), true);

			$cadena.='<br><br><table cellpadding="4" style="">';

			$cadena.='<tr>';
			$cadena.='<td style="text-align:left; height:15px; width:40%; height: 20px; font-size: 10px; font-weight:bold;">Nombre de la institución:</td>';
			$cadena.='<td style="font-size: 10px; height:15px; width:60%; text-align:left;">'.$seguimientos_contratos[0]['con_institucion'].'</td>';
			$cadena.='</tr>';

			$cadena.='<tr>';
			$cadena.='<td style="text-align:left; height: 15px; font-size: 10px; font-weight:bold;">Código de proceso de contratación:</td>';
			$cadena.='<td style="font-size: 10px; height:15px; text-align:left;">'.$seguimientos_contratos[0]['con_codigo'].'</td>';
			$cadena.='</tr>';

			$cadena.='<tr>';
			$cadena.='<td style="text-align:left; height: 20px; font-size: 10px; font-weight:bold;">Número y nombre del contrato:</td>';
			$cadena.='<td style="font-size: 10px; text-align:left;">'.$seguimientos_contratos[0]['cod_contrato'].'</td>';
			$cadena.='</tr>';

			$cadena.='<tr>';
			$cadena.='<td style="text-align:left; height: 20px; font-size: 10px; font-weight:bold;">Número de resolución adjudicativa:</td>';
			$cadena.='<td style="font-size: 10px; text-align:left;">'.$seguimientos_contratos[0]['numero_resolucion'].'</td>';
			$cadena.='</tr>';

			$cadena.='<tr>';
			$cadena.='<td style="text-align:left; height: 20px; font-size: 10px; font-weight:bold;">Nombre del contratista:</td>';
			$cadena.='<td style="font-size: 10px; text-align:left;">'.$seguimientos_contratos[0]['nombre_contratista'].'</td>';
			$cadena.='</tr>';

			$cadena.='<tr>';
			$cadena.='<td style="text-align:left; height: 20px; font-size: 10px; font-weight:bold;">Nombre y cargo del administrador del contrato:</td>';
			$cadena.='<td style="font-size: 10px; text-align:left;"><br>'.$seguimientos_contratos[0]['jefe_transporte'].'</td>';
			$cadena.='</tr>';

			$cadena.='<tr>';
			$cadena.='<td style="text-align:left; height: 20px; font-size: 10px; font-weight:bold;">Periodo de la vigencia de la garantía de cumplimiento del contrato:</td>';
			$cadena.='<td style="font-size: 10px; text-align:left;"><br>'.$periodo_gar.'</td>';
			$cadena.='</tr>';

			$cadena.='<tr>';
			$cadena.='<td style="text-align:left; height: 20px; font-size: 10px; font-weight:bold;">Periodo de vigencia de la garantía de buena inversión de anticipo:</td>';
			$cadena.='<td style="font-size: 10px; text-align:left;"><br>'.$periodo_antic.'</td>';
			$cadena.='</tr>';

			$cadena.='</table><br><br><br><br><br>';
	
			//segunda tabla

			$cadena.='<table style="border:1px solid black; font-size: 10px; ">';
			$cadena.='<tr >';
			$cadena.='<td style="text-align:center; background-color:#BBD6ED; border:1px solid black; font-weight:bold; height: 15px; width:50%;">Obligaciones contractuales del contratista</td>';
			$cadena.='<td style="text-align:center; background-color:#BBD6ED; border:1px solid black; font-weight:bold; height: 15px; width:25%;">Fecha desde</td>';
			$cadena.='<td style="text-align:center; background-color:#BBD6ED; border:1px solid black; font-weight:bold; height: 15px; width:25%;">Fecha hasta</td>';
			$cadena.='</tr>';

			foreach ($seguimientos_contratos as $key => $val) {
				$cadena.='<tr>';
				$cadena.='<td style="border: 1px solid gray;" >'.$val['obligaciones'].'</td>';
				$cadena.='<td style="border: 1px solid gray;">'.date('d/m/Y', strtotime($val['seg_desde'])).'</td>';
				$cadena.='<td style="border: 1px solid gray;">'.date('d/m/Y', strtotime($val['seg_hasta'])).'</td>';
				$cadena.='</tr>';
			}

			$cadena.='</table>';  

			$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']     = $rows;
            $data['table_tbody']      = $cadena;
            $data['table_tbody2']     = $cadena2;
            $data['filename']         = $filename;

            $this->pdf->reportePDF('transporte/reportes/imprimir_seguimiento_contratos',$data,'');

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}

	public function imprimir_ejecucion_contratos()
	{
		satelite_validar();
		
		try {

			$fecha_ini=$this->input->post('desde');
			$fecha_fin=$this->input->post('hasta');
			$tipo=$this->input->post('tipo');
			$fecha_inicio=date('Y-m-d', strtotime($fecha_ini));
			$fecha_fin=date('Y-m-d', strtotime($fecha_fin));

			$ejecucion_contratos=$this->entradas_model->get_ejecucion_contratos($fecha_inicio, $fecha_fin);
         // die(print_r($this->db->last_query()));

           //die(print_r($ejecucion_contratos,true));


			$cadena="";

            //$rows="REPORTES DE NOTAS POR ALUMNO";

			$rows=$this->load->view('reporte/header_sen', array('titulo' => "Ejecución Contratos"), true);



			$cadena.='<table id="ejecucion" class="responsive table table-bordered" cellpadding="2" style="border:1px solid black;" border="1">';

			$cadena.='<thead><tr style="background-color: #99b2ff;">';
			$cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Contrato Nº</th>';
			$cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Inicio de Ejecución</th>';
			$cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Fecha Fin de Contrato</th>';
			$cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Descripción</th>';
			$cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Institución</th>';

			$cadena.='</tr></thead>';

			foreach ($ejecucion_contratos as $key => $sld) {

				$cadena.='<tbody><tr><td>'.$sld['con_numero'].'</td>';
				$cadena.='<td>'.$sld['inicio_ejecucion'].'</td>';
				$cadena.='<td>'.$sld['fin_contrato'].'</td>';
				$cadena.='<td>'.$sld['descripcion'].'</td>';
				$cadena.='<td>'.$sld['con_institucion'].'</td></tr></tbody>';
			}

			$cadena.='</table>';

			$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

			$data['table_header']     = $rows;
			$data['table_tbody']      = $cadena;

			$data['filename']         = $filename;

			if($tipo==''){
                //$this->load->view('transporte/reportes/cupones_combustible_detalle',$data);
				echo json_encode(array('tbody'=>$cadena));
			}else if($tipo!=''){
				$this->pdf->reportePDF('transporte/reportes/imprimir_ejecucion_contratos',$data, '');
			}

         
			

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}


	public function control_combustible($id_solicitud=null)
	{
		satelite_validar();		
		try {
			$fecha_ini=$this->input->post('desde');
			$fecha_fin=$this->input->post('hasta');
			$tipo=$this->input->post('tipo');
			$fecha_inicio=date('Y-m-d', strtotime($fecha_ini));
			$fecha_fin=date('Y-m-d', strtotime($fecha_fin));

			$control_comb = $this->entradas_model->get_control_combustible($fecha_inicio, $fecha_fin);
        	//$solicitud_transporte=$this->entradas_model->get_solicitud_transporte($id_solicitud);
          	//die(print_r($control_comb,true));
			$cadena="";
			$empresa=$this->gsatelite->get_parametro('SYS_EMPRESA');
			$rows=$this->load->view('reporte/header_sen', array('titulo' => "Control de Combustible "), true);

			$mensaje="<label>INFORME DE INGRESOS Y EGRESOS DE CUPONES DE COMBUSTIBLE ENTREGADOS PARA CONSUMO OFICIAL Y MANTENIMIENTO DE VEHÍCULOS DE ".mb_strtoupper($empresa, 'UTF-8')."</label>";

			$tabla='<meta http-equiv="content-type" content="text/html; charset=utf-8">
			<table id="combustible" class="responsive table table-bordered" border="1" style="border:1px solid black;">';

			$head='<tr>';
			$head.='<th style="text-align:center; font-weight:bold; width: 20%; border:1px solid black;" rowspan="2">Fechas</th>';
			$head.='<th style="text-align:center; font-weight:bold; width: 25%; border:1px solid black;" rowspan="2">Detalle</th>';
			$head.='<th style="text-align:center; font-weight:bold; width: 25%; border:1px solid black;" rowspan="2">Proveedor</th>';
			$head.='<th style="text-align:center; font-weight:bold; width: 20%; border:1px solid black;"  colspan="2" >Cupones</th>';
			$head.='<th style="text-align:center; font-weight:bold; width: 10%; border:1px solid black;" >Saldo</th>';
			$head.='</tr>';
			$head.='<tr>';
			$head.='<th style="text-align:center; font-weight:bold; width: 10%; border:1px solid black;" >Series</th>';
			$head.='<th style="text-align:center; font-weight:bold; width: 10%; border:1px solid black;" >Salidas</th>';
			$head.='<th style="text-align:center; font-weight:bold; width: 10%; border:1px solid black;" >Cupones</th>';
			$head.='</tr>';


			foreach ($control_comb as $key => $sld) {
                $saldo_restante = $sld['gran_total'] - ($sld['salida'] + $sld['utilizados']);
                //$dos="";
				$cadena.="<tr><td>".$sld['fecha_inicio']."</td>";
				$cadena.="<td>".$sld['ddt_actividad']."</td>";
				$cadena.="<td>".$sld['nombre_proveedor']."</td>";
				$cadena.="<td>".$sld['serie_inicio'] . "/" . $sld['serie_fin']."</td>";
				$cadena.="<td>".$sld['salida']."</td>";
				$cadena.="<td>".$saldo_restante."</td></tr>";

			}

			$tabla.='</table>';



			$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

			$data['mensaje']     = $mensaje;
			$data['table_header']     = $rows;
			$data['table']            = $tabla;
			$data['table_thead']      = $head;
			$data['table_tbody']      = $cadena;
			$data['filename']         = $filename;
            //$data['titulo_personal']="Reporte Solicitud de Transporte";

			if($tipo==''){
                //$this->load->view('transporte/reportes/cupones_combustible_detalle',$data);
				echo json_encode(array('tabla'=>$tabla,'head'=>$head,'tbody'=>$cadena));
			}else if($tipo!=''){
				$this->pdf->reportePDF('transporte/reportes/control_combustible', $data, '');
			}

                 //$this->load->view('transporte/reportes/imprimir_solicitud_transporte',$data);

			

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}



	public function imprimir_sol_comb_departamentales($id_solicitud=null)
	{
		satelite_validar();
		try {
			$solicitud_transporte_dep=$this->entradas_model->get_solicitud_combustible_departamental($id_solicitud);
			//die(print_r($solicitud_transporte_dep,true));

			$cadena="";

			$anio=date("Y");
			$rows=$this->load->view('reporte/header', array('titulo' => "Solicitud de Combustibles para la Ejecución de los Programas Legislativos "."<BR><BR><BR>"." OFICINA DEPARTAMENTAL DE SANTA ANA ".$anio.""), true);

			$cadena.='<table style="border:1px solid black;">';
			$cadena.='<thead>';
			$cadena.='<tr style="background-color: #99b2ff;">';
			$cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">No</th>';
			$cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Municipio</th>';
			$cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Lugar de Vista</th>';
			$cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Distancia en Kilómetros (Ida y Vuelta)</th>';

			$cadena.='</tr>';
			$cadena.='</thead>';

			foreach ($solicitud_transporte_dep as $key => $sld) {
				
				$cadena.='<tbody>';

				$cadena.='<tr><td>'.$sld['ddt_id'].'</td>';
				$cadena.='<td>'.$sld['destino'].'</td>';
				$cadena.='<td>'.$sld['lugar_visita'].'</td>';
				$cadena.='<td>'.$sld['kilometraje'].'</td></tr>';

				$cadena.='</tbody>';

			}

			$cadena.='<tfoot>';
			$cadena.='<tr style="border:1px solid black">';
			$cadena.='<th height="15px" style="text-align:center; font-weight:bold;"></th>';
			$cadena.='<th height="15px"  style="text-align:right; font-weight:bold;">Subtotal:</th>';
			$cadena.='<th height="15px" style="text-align:center; font-weight:bold;"></th>';
			$cadena.='<th height="15px" style="text-align:right; font-weight:bold;">Kilometraje:</th>';

			$cadena.='<th height="15px" style="text-align:center; font-weight:bold;"></th>';
			$cadena.='</tr>';
			$cadena.='</tfoot>';
			$cadena.='</table><br><br><br><br><br>';

			foreach ($solicitud_transporte_dep as $key => $sld) {
				$cadena2.='<table>';
				$cadena2.='<tr >';
				$cadena2.='<td style="text-align:right; height: 15px; width:70%; ">Total:</td>';
				$cadena2.='<td style="text-align:center; height: 15px; width:10%; ">'.$sld['km_total'].'</td>';
				$cadena2.='<td style="text-align:right; height: 15px; width:10%; ">Kilometraje:</td>';
				$cadena2.='<td style="text-align:center; height: 15px; width:10%; ">'.$sld['kilometraje'].'</td>';

				$cadena2.='</tr>';

			}

			$cadena2.='</table>';

            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']= $rows;
            $data['table_tbody']= $cadena;
            $data['table_tbody2']= $cadena2;
            $data['filename']= $filename;
            
            $this->pdf->reportePDF('transporte/reportes/imprimir_sol_comb_departamentales', $data, '');
                 //$this->load->view('transporte/reportes/imprimir_solicitud_transporte',$data);

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}	
	}



	public function imprimir_solicitud_combustible($id_solicitud=null)
	{
		satelite_validar();
		try {
			$get_solicitud_combustible=$this->entradas_model->get_solicitud_combustible($id_solicitud);
           	//die(print_r($get_solicitud_combustible,true));
			$cadena="";

			$anio=date("Y");
			$rows=$this->load->view('reporte/header', array('titulo' => "Solicitud de Combustibles".$anio.""), true);

			$cadena.='<table style="border:1px solid black;">';

			$cadena.='<tr style="background-color: #99b2ff;">';
			$cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;"> Nº Ticket</th>';
			$cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Placa</th>';
			$cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Tipo Combustible</th>';
			$cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Estado</th>';
			$cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Fecha de Salida</th>';
			$cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Última Actualización</th>';
			$cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Destino y Actividad a Realizar</th>';
			$cadena.='</tr>';

			foreach ($get_solicitud_combustible as $key => $sld) {
				$estado = (trim($sld['estado_tkt']) != "")? trim($sld['estado_tkt']) : 'Sin asignar';
				$cadena.='<tr><td>'.$sld['dtc_id_tkt'].'</td>';
				$cadena.='<td>'.$sld['veh_placa'].'</td>';
				$cadena.='<td>'.$sld['tpc_nombre'].'</td>';
				$cadena.='<td>'.$estado.'</td>';
				$cadena.='<td>'.$sld['fecha_salida'].'</td>';
				$cadena.='<td>'.$sld['fecha_actualizacion'].'</td>';
				$cadena.='<td>'.$sld['destino_actividad'].'</td></tr>';
			}
            $cadena.='</table>';

            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']= $rows;
            $data['table_tbody']= $cadena;
            $data['filename']= $filename;
            
            $this->pdf->reportePDF('transporte/reportes/imprimir_solicitud_combustible', $data, '');

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}	
	}

	public function cupones_combustible()
	{
		satelite_validar();
		try {

			/*$data['titulo_personal']="Reporte de cupones de combustible";
			$this->_cargarvista($data,null);*/
      $fecha_ini=$this->input->post('desde');
      $fecha_fin=$this->input->post('hasta');
      $tipo=$this->input->post('tipo');
      $fecha_inicio=date('Y-m-d', strtotime($fecha_ini));
      $fecha_fin=date('Y-m-d', strtotime($fecha_fin));
      //die(print_r($fecha_ini.'/'.$fecha_fin));


			$distribucion_combustible=$this->entradas_model->get_distribucion_combustible($fecha_inicio,$fecha_fin);
      //die(print_r($distribucion_combustible,true));

            $cadena="";
            //$rows="REPORTES DE NOTAS POR ALUMNO";
            $rows=$this->load->view('reporte/header_sen', array('titulo' => "Distribución de Cupones de Combustible"), true);
	
				$cadena.='<table style="border:1px solid black;" cellpadding="2" border="1" id="cupones" class="responsive table table-bordered">';

                $cadena.='<thead><tr style="background-color: #99b2ff;">';
                $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Fecha</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Número de Solicitud</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Fecha Inicio</th>';
                //$cadena.='<!-- <th style="text-align:center; font-weight:bold;border:1px solid black;">Hora Misión</th> -->';

                $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Ticket</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Nº de vale</th>';

               $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Solicitante</th>';

               $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Tipo de fondo</th>';

                $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Placa</th>';

               $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;" colspan ="2">Serie Cupones</th>';
               
                $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Cantidad</th>';

               $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Total</th>';

                $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Destino Actividad a Realizar</th>';
                
               // $cadena.='<!-- <th style="text-align:center; font-weight:bold;border:1px solid black;">Salida</th> -->';

                $cadena.='</tr></thead>';

             	 foreach ($distribucion_combustible as $key => $sld) {

                $cadena.='<tbody><tr><td>'.$sld['fecha'].'</td>';
                $cadena.='<td>'.$sld['num_solicitud'].'</td>';
                $cadena.='<td>'.$sld['fecha_inicio'].'</td>';
               // $cadena.='<!-- <td>'.$sld['hora'].'</td> -->';
                $cadena.='<td>'.$sld['num_recibo'].'</td>';
                $cadena.='<td>'.implode(',', array_unique(explode(',', $sld['num_vale2']))).'</td>';
                $cadena.='<td>'.$sld['emp_nombre'].' '.$sld['emp_apellido'].'</td>';
                $cadena.='<td>'.$sld['tpf_nombre'].'</td>';
                $cadena.='<td>'.$sld['veh_placa'].'</td>';

                $cadena.='<td>'.$sld['serie_inicio'].'</td>';
                $cadena.='<td>'.$sld['serie_fin'].'</td>';

                $cadena.='<td>'.$sld['cantidad'].'</td>';

                $cadena.='<td>'.$sld['total'].'</td>';

                $cadena.='<td>'.$sld['dtc_destino'].'</td>';

               // $cadena.='<!-- <td>'.$sld['salida'].'</td> -->';
                $cadena.=' </tr></tbody>';
            }

            $cadena.='</table>';

          
            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']     = $rows;
            $data['table_tbody']      = $cadena;
            
            $data['filename']         = $filename;
              if($tipo==''){
                //$this->load->view('transporte/reportes/cupones_combustible_detalle',$data);
                echo json_encode(array( 'tbody'=>$cadena));
              }else if($tipo!=''){
                $this->pdf->reportePDF_legal('transporte/reportes/imprimir_ejecucion_contratos',$data,'','L','','legal');
              }

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}


	public function reporte_mision_oficial($id_solicitud=1)
	{
		satelite_validar();
		try {
			$mision_oficial=$this->entradas_model->get_mision_oficial($id_solicitud);
           
           //die(print_r($mision_oficial,true));
          $this->load->library('EnLetras');
          $date=date('Y-m-d');
          $mes_anio=$this->enletras->mes_anio($date, 2);

          $empresa=$this->gsatelite->get_parametro('SYS_EMPRESA');
            $cadena="";

                $rows=$this->load->view('reporte/header', array('titulo' => "Misión Oficial "), true);
               
                $cadena.='<table style="">';

             foreach ($mision_oficial as $key => $sld) {
              $destinos=$this->entradas_model->get_ubicacion($sld['tkt_id']);
              $mes_num=date('n', strtotime($sld['dtt_fecha_salida']));

              $mes=$this->enletras->mes_anio(null,3,$mes_num);
              //die(print_r($mes_num.'/'));
              $ubi=array();
              if(count($destinos)>1){
                foreach ($destinos as $des) {
                  $ubi[]=$des['ubt_nombre'];
                }
                $ubicacion=implode(', ', $ubi);
              }else if(count($destinos)==1){
                $ubicacion=$destinos[0]['ubt_nombre'];
              }

              $cadena.='<tr>';
              $cadena.='<td style="text-align:justify; font-size:12px font-weight:bold; "><br><br>	
				El suscrito señor '.$sld['jefe_transporte'].' en su 
				 calidad de '.$sld['puesto_transporte'].' 
				de '.$empresa.'; hace constar que:<br><br>

				El vehículo con las siguientes características:

                </td>';
                $cadena.='</tr>';

                $cadena.='<tr>';
                $cadena.='<td> <br><br><br><br>

      <table style="border:none; width: 100%; text-align:center;" cellpadding="2">
        <tr>
          <td style="height:15px; font-size:11px; font-weight:bold; border-bottom:1px solid black; background-color: #BBD6ED;">Placa</td>
          <td style="height:15px; font-size:11px; font-weight:bold; border-bottom:1px solid black; background-color: #BBD6ED;">Clase</td>
          <td style="height:15px; font-size:11px; font-weight:bold; border-bottom:1px solid black; background-color: #BBD6ED;">Año</td>
          <td style="height:15px; font-size:11px; font-weight:bold; border-bottom:1px solid black; background-color: #BBD6ED;">Capacidad</td>
				  <td style="height:15px; font-size:11px; font-weight:bold; border-bottom:1px solid black; background-color: #BBD6ED;">Marca</td>
				  <td style="height:15px; font-size:11px; font-weight:bold; border-bottom:1px solid black; background-color: #BBD6ED;">Modelo</td>
				  <td style="height:15px; font-size:11px; font-weight:bold; border-bottom:1px solid black; background-color: #BBD6ED;">Color</td>
        </tr>
        <tr>
          <td style="height:25px; font-size:11px font-weight:bold;">'.$sld['veh_placa'].'</td>
          <td style="height:25px; font-size:11px font-weight:bold;">'.$sld['tvh_nombre'].'</td>
          <td style="height:25px; font-size:11px font-weight:bold;">'.$sld['veh_ano'].'</td>
          <td style="height:25px; font-size:11px font-weight:bold;">'.$sld['veh_capacidad'].'</td>
          <td style="height:25px; font-size:11px font-weight:bold;">'.$sld['marca_vehiculo'].'</td>
          <td style="height:25px; font-size:11px font-weight:bold;">'.$sld['modelo_vehiculo'].'</td>
				  <td style="height:25px; font-size:11px font-weight:bold;">'.$sld['color'].'</td>
        </tr>

			</table>

				</td>';
				$cadena.='</tr>';
				$cadena.='<tr><td style="text-align:justify; font-size:12px font-weight:bold; ">	
						<br><br><br>
					Es propiedad de '.$empresa.',  será conducido  por  el  señor 
					'.$sld['solicitante'].'
					quien      se       identifica     con      su       licencia       de       conducir    N°
					'.$sld['mot_licencia'].' y está autorizado para  cobertura  de
					actividad                  oficial              con             destino  a 
					'.$ubicacion.'. <br><br>Encargado de misión '.$sld['encargado'].'
					el día
					'.$sld['dia'].' de '.strtolower($mes).' del presente año,  por  lo  que se les
					ruega a las autoridades brindarle las consideraciones del caso.<br>
					</td>';
                $cadena.='</tr>';
                $cadena.='<tr><td style="text-align:center; font-size:12px font-weight:bold;">	
                	<br><br><br><br>

					San Salvador, '.$mes_anio.'<br><br><br><br><br>
					</td>';
                $cadena.='</tr>';

                $cadena.='<tr><td style="text-align:center; font-size:12px font-weight:bold;">	
								'.$sld['autoriza'].'							
					</td>';
                $cadena.='</tr>';
                  $cadena.='<tr><td style="text-align:center; font-size:10px font-weight:bold;">	
								Administración							
					</td>';
                $cadena.='</tr>';

           		 }

            	$cadena.='</table> ';

             	


            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']= $rows;
            $data['table_tbody']= $cadena;
            $data['filename']= $filename;
            
               $this->pdf->reportePDF('transporte/reportes/reporte_mision_oficial', $data,'');
                 //$this->load->view('transporte/reportes/imprimir_solicitud_transporte',$data);

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} 

/*
	public function autorizacion_vehiculo($id_solicitud=1)
	{
		satelite_validar();
		try {
			//$get_autorizacion_vehiculo=$this->entradas_model->get_autorizacion_vehiculo($id_solicitud);
           
           //die(print_r($get_autorizacion_vehiculo,true));


            $cadena="";

           		$anio=date("Y");
                $rows=$this->load->view('reporte/header', array('titulo' => "Solicitud de Combustibles".$anio.""), true);
               
                $cadena.='<table style="border:1px solid black;">';

                $cadena.='<tr style="background-color: #99b2ff;">';
                $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;"> Nº Ticket</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Placa</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Tipo Combustible</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Estado</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Fecha de Salida</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Última Actualización</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;border:1px solid black;">Destino y Actividad a Realizar</th>';
              


                $cadena.='</tr>';

             	 //foreach ($get_autorizacion_vehiculo as $key => $sld) {

                $cadena.='<tr><td>'.$sld['dtc_id_tkt'].'</td>';
                $cadena.='<td>'.$sld['veh_placa'].'</td>';
                $cadena.='<td>'.$sld['tpc_nombre'].'</td>';
                $cadena.='<td>Sin asignar</td>';
                $cadena.='<td>'.$sld['fecha_salida'].'</td>';
                $cadena.='<td>'.$sld['fecha_actualizacion'].'</td>';
                $cadena.='<td>'.$sld['destino_actividad'].'</td></tr>';
           // }

            $cadena.='</table>';

             	


            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']= $rows;
            $data['table_tbody']= $cadena;
            $data['filename']= $filename;
            
               $this->pdf->reportePDF('transporte/reportes/autorizacion_vehiculo', $data);
                 //$this->load->view('transporte/reportes/imprimir_solicitud_transporte',$data);
         
			

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}	
	}*/
	public function reporte_autorizacion_vehiculo($id_solicitud=1)
	{
		satelite_validar();
		try {
			$get_autorizacion_vehiculo = $this->entradas_model->get_autorizacion_vehiculo($id_solicitud);
           
            $cadena="";

           		$anio=date("Y");
                $rows=$this->load->view('reporte/header', array('titulo' => "Solicitud y Autorización de vehículos y combustible"), true);
               
            $cadena.='<table border="0" style="font-size:9px">';
                
              foreach ($get_autorizacion_vehiculo as $key => $sld) {
                $cadena.='<tr>';
                $cadena.='<td  style="text-align:left; height: 30px; font-weight:bold; width:30%">Unidad o persona solicitante:</td>';
                $cadena.='<td   style="text-align:left; height: 30px; width:70%">'.$sld['solicitante'].'</td>';
                $cadena.='</tr>';
                $cadena.='<tr>';
                $cadena.='<td style="text-align:left; height: 30px; font-weight:bold;">Hora y fecha de solicitud:</td>';
                $cadena.='<td  style="text-align:left; height: 30px; ">'.date('d/m/Y', strtotime($sld['fecha_solicitud'])).' , '.$sld['hora_solicitud'].'</td>';
                $cadena.='</tr>';
                //$cadena.='</tr>';
                $cadena.='<tr>';
                $cadena.='<td style="text-align:left; height: 30px; font-weight:bold;">Cantidad de personas:</td>';
                $cadena.='<td  style="text-align:left; height: 30px;">'.$sld['cantidad_personas'].'</td>';
                $cadena.='</tr>';
                $cadena.='<tr>';
                $cadena.='<td  style="text-align:left; height: 30px; font-weight:bold;">Motorista:</td>';
                $cadena.='<td  style="text-align:left; height: 30px;">'.$sld['motorista'].'</td>';
                $cadena.='</tr>';
                $cadena.='<tr>';
                $cadena.='<td  style="text-align:left; height: 30px; font-weight:bold;">Destino y actividad a realizar:</td>';
                $cadena.='<td  style="text-align:left; height: 30px;">'.$sld['dtt_actividad'].'</td>';
                $cadena.='</tr>';
              $cadena.='</table><br><br><br>';

              $cadena.='<table border="0" width="90%" style="font-size:9px">';
                $cadena.='<tr>';
                $cadena.='<td style="text-align:left; height: 30px; font-weight:bold;">&nbsp;Tipo vehículo:</td>';
                $cadena.='<td style="text-align:left; height: 30px;">'.$sld['tipo_veh'].'</td>';
                $cadena.='<td style="text-align:left; height: 30px; font-weight:bold;">Placa:</td>';
                $cadena.='<td style="text-align:left; height: 30px;">'.$sld['veh_placa'].'</td>';
                $cadena.='</tr>';
                $cadena.='<tr >';
                $cadena.='<td style="text-align:left; height: 30px; font-weight:bold;">&nbsp;Modo de gasolina:</td>';
                $cadena.='<td style="text-align:left; height: 30px;">'.$sld['modo_combustible'].'</td>';
                $cadena.='<td style="text-align:left; height: 30px; font-weight:bold;">Cantidad de vales:</td>';
                $cadena.='<td style="text-align:left; height: 30px;">'.$sld['vales'].'</td>';
                $cadena.='</tr>';
                $cadena.='<tr >';
                $cadena.='<td style="text-align:left; height: 30px; font-weight:bold;">&nbsp;Valor por vale:</td>';
                $cadena.='<td style="text-align:left; height: 30px;">'.$sld['valor'].'</td>';
                $cadena.='<td style="text-align:left; height: 30px; font-weight:bold;">Serie(s)  Vale(s):</td>';
                $cadena.='<td style="text-align:left; height: 30px;">'.$sld['series_vales'].'</td>';
                $cadena.='</tr>';
                $cadena.='</table><br><br><br><br><br><br><br><br>';

              $cadena.='<table border="0" style="font-size:9px">';
                $cadena.='<tr>';
                $cadena.='<td style="text-align:left; height: 30px; width:45%;">F. _________________________________________________</td>';
                $cadena.='<td style="text-align:left; height: 30px; width:10%; font-weight:bold;"></td>';
               	$cadena.='<td style="text-align:left; height: 30px; width:45%;">F. _________________________________________________</td>';
                $cadena.='</tr>';

                $cadena.='<br><br><br><br><tr>';
                $cadena.='<td style="text-align:center; height: 30px; ">Jefe de Unidad</td>';
                $cadena.='<td style="text-align:center; height: 30px;  font-weight:bold;"></td>';
                $cadena.='<td style="text-align:center; height: 30px; ">Autoriza</td>';
                $cadena.='</tr>';

                // Si se crea la tabla mdt_modificacion_ticket, esta parte tendria que ser otro foreach,
                // La que pueden haber multiples registros de Log para esta solicitud.
                // $cadena.='<br><br><tr>';
                // $cadena.='<td style="text-align:left; height: 30px;  font-weight:bold;">Log de actualizaciones: </td>';
                // $cadena.='<td style="text-align:left;"></td>';
                // $cadena.='<td style="text-align:left;"></td>';
                // $cadena.='</tr>';
                // $cadena.='<tr>';
                // $cadena.='<td style="text-align:left; height: 30px;  font-weight:bold;">'.$sld['fecha_creacion'].'</td>';
                // $cadena.='<td style="text-align:left; height: 30px;  font-weight:bold;"></td>';
                // $cadena.='<td style="text-align:left; height: 30px;  font-weight:bold;"></td>';
                // $cadena.='</tr>';
                // $cadena.='<tr >';
                // $cadena.='<td style="text-align:left; height: 30px;  font-weight:bold;">Tarea creada por: </td>';
                // $cadena.='<td style="text-align:left; height: 30px;  font-weight:bold;">'.$sld['usuario_creacion'].'</td>';
                // $cadena.='<td style="text-align:left;  height: 30px; font-weight:bold;"></td>';
                // $cadena.='</tr>';

                // $cadena.='<tr >';
                // $cadena.='<td style="text-align:left; height: 30px;  font-weight:bold;">'.$sld['fecha_modificacion'].'</td>';
                // $cadena.='<td style="text-align:left; height: 30px;  font-weight:bold;"></td>';
                // $cadena.='<td style="text-align:left; height: 30px;  font-weight:bold;"></td>';
                // $cadena.='</tr>';
                // $cadena.='<tr >';
                // $cadena.='<td style="text-align:left; height: 30px;  font-weight:bold;">Tarea modificada por: Jorge Torres </td>';
                // $cadena.='<td style="text-align:left; height: 30px;  font-weight:bold;">'.$sld['usuario_modifica'].'</td>';
                // $cadena.='<td style="text-align:left; height: 30px;  font-weight:bold;"></td>';
                // $cadena.='</tr>';
                   }
                $cadena.='</table>';  

             	
            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']= $rows;
            $data['table_tbody']= $cadena;
            $data['filename']= $filename;
            
               $this->pdf->reportePDF('transporte/reportes/reporte_autorizacion_vehiculo', $data,'');
                 //$this->load->view('transporte/reportes/imprimir_solicitud_transporte',$data);
         
			
		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} 


	public function reporte_orden_trabajo($gmt_id=1)
	{
		satelite_validar();
		try {
			$orden_trabajo=$this->entradas_model->get_orden_trabajo($gmt_id);

      $cadena="";
        $rows=$this->load->view('reporte/header', array('titulo' => "Orden de Trabajo"), true);
          
      $cadena.='<table style="">';
                
			$cadena.='<table style="width: 100%;">';
				 foreach ($orden_trabajo as $key => $sld) {
             
				$cadena.='<tr>
				<td  style="height:25px; text-align:justify; font-size:11px; width:30%; font-weight:bold;">Orden de trabajo N°:</td>
				<td style="height:25px; text-align:justify; width:60%; font-size:11px;">'.$sld['orden_n']."/".$sld['veh_ano'].'</td>
				</tr>
				<tr>
				<td  style="height:25px; text-align:justify; font-size:11px; font-weight:bold;">Fecha:</td>
				<td style="height:25px; text-align:justify; font-size:11px;">'.$sld['fecha_sugerida'].'</td>
				</tr>
				<tr>
				<td  style="height:25px; text-align:justify; font-size:11px; font-weight:bold; ">Contratista: </td>
				<td style="height:25px; text-align:justify; font-size:11px;">'.$sld['contratistas'].'</td>
				</tr>

				<tr>
				<td  style="height:25px; text-align:justify; font-size:11px; font-weight:bold; ">&nbsp;</td>
				<td style="height:25px; text-align:justify; font-size:11px; font-weight:bold; ">&nbsp;</td>
				</tr>
			</table>
      <table style="width: 90%;" cellpadding="2">
        <tr>
				  <td colspan="4"  style="height:15px; text-align:center; font-size:11px; font-weight:bold; border-bottom:1px solid black; background-color: #BBD6ED;">DATOS DEL VEHÍCULO</td>
				</tr>
				<tr>
  				<td style="height:25px; text-align:justify; font-size:11px; width:20%; font-weight:bold;">&nbsp;Placa:</td>
  				<td style="height:25px; text-align:justify; font-size:11px; width:30%;">'.$sld['veh_placa'].'</td>
  				<td style="height:25px; text-align:justify; font-size:11px; width:20%; font-weight:bold;">Marca:</td>
  				<td style="height:25px; text-align:justify; font-size:11px; width:30%;">'.$sld['marca'].'</td>
				</tr>
				<tr>
				<td style="height:25px; text-align:justify; font-size:11px; font-weight:bold;">&nbsp;Modelo:</td>
				<td style="height:25px; text-align:justify; font-size:11px;">'.$sld['modelo'].'</td>
				<td style="height:25px; text-align:justify; font-size:11px; font-weight:bold;">Año:</td>
				<td style="height:25px; text-align:justify; font-size:11px;">'.$sld['veh_ano'].'</td>
				</tr>

				<tr>
				<td style="height:25px; text-align:justify; font-size:11px; font-weight:bold;">&nbsp;Kilometraje:</td>
				<td style="height:25px; text-align:justify; font-size:11px;">'.$sld['kilometraje'].'</td>
				</tr>
				<tr>
				<td  style="height:25px; text-align:justify; font-size:11px; font-weight:bold; ">&nbsp;</td>
				<td style="height:25px; text-align:justify; font-size:11px; font-weight:bold; ">&nbsp;</td>
				</tr>

        <tr>
          <td colspan="4"  style="height:15px; text-align:center; font-size:11px; font-weight:bold; border-bottom:1px solid black; background-color: #BBD6ED;">DETALLE DEL SERVICIO</td>
        </tr>

				<tr>
				<td style="height:25px; text-align:justify; font-size:11px; font-weight:bold; width:40%;">&nbsp;Tipo de Mantenimiento:</td>
				<td style="height:25px; text-align:justify; font-size:11px; width:60%;">'.$sld['tipo_mantenimiento'].'</td>
				</tr>
				<tr>
				<td style="height:25px; text-align:justify; font-size:11px; font-weight:bold;">&nbsp;Reportes Adicionales:</td>
				<td style="height:25px; text-align:justify; font-size:11px;">'.$sld['detalle_mant'].'</td>
				</tr>
				<tr>
				<td  style="height:25px; text-align:justify; font-size:11px; font-weight:bold; ">&nbsp;</td>
				<td style="height:25px; text-align:justify; font-size:11px; font-weight:bold; ">&nbsp;</td>
				</tr>
        <tr>
          <td></td>
        </tr>
				<tr>
				<td colspan="2" style="height:25px; text-align:Center; font-size:11px; font-weight:bold;"><br><br><br><br><br><br>Autoriza, '.$sld['admin_contrato'].'</td>
				</tr>


				';
					}
      $cadena.='</table> ';

             	


            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']= $rows;
            $data['table_tbody']= $cadena;
            $data['filename']= $filename;
            
               $this->pdf->reportePDF('transporte/reportes/reporte_orden_trabajo', $data,'');
                 //$this->load->view('transporte/reportes/imprimir_solicitud_transporte',$data);
         




		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} 
	public function reporte_recibo_cupones_combustible($id=null)
	{
		satelite_validar();
		try {
			$recibo_cupones_combustible=$this->entradas_model->get_recibo_cupones_combustible($id);

			$recibo_cupones_combustible2=$this->entradas_model->get_recibo_cupones_combustible2($id);

           	//die(print_r($recibo_cupones_combustible2,true));
			$cadena="";

			$rows=$this->load->view('reporte/header', array('titulo' => "Recibo de Cupones de Combustible"), true);

			$cadena.='<table style="">';

			$empresa=$this->gsatelite->get_parametro('SYS_EMPRESA');       
			$cadena.='<table style=" width: 100%;">';
			foreach ($recibo_cupones_combustible as $key => $sld) {
				$fecha=date('d/m/Y', strtotime($sld['fecha']));
				$cadena.='<tr>
				<td  style="height:25px; text-align:justify; font-size:11px; font-weight:bold; ">Tipo Combustible: <span style="font-weight:normal;">'.$sld['combustible'].'</span></td>
				<td style="height:25px; text-align:justify; font-size:11px; font-weight:bold; ">Nº: <span style="font-weight:normal;">'.$sld['dtc_id_tkt'].'</span></td>
				
				</tr>

				<tr>
				<td  style="height:25px; text-align:justify; font-size:11px; font-weight:bold; ">Fecha: <span style="font-weight:normal;">'.$fecha.'</span></td>
				<td style="height:25px; text-align:justify; font-size:11px; font-weight:bold; ">Por: <span style="font-weight:normal; ">'.$sld['usuario_recibe'].'</span></td>
				</tr>
				<tr>
				<td colspan="2" style="height:25px; text-align:justify; font-size:11px font-weight:bold; ">Recibí del encargado(a) del fondo de combustible de '.$empresa.', la cantidad de 
				<span style="font-weight:bold; ">'.$sld['cantidad_vales'].'</span> cupones de combustibles para <span style="font-weight:bold; ">'.$sld['cupones_para'].'</span>
				<br><br>
				</td>
				</tr>
				<tr>
				<td colspan="2" style="height:25px; text-align:justify; font-size:11px font-weight:bold; ">Placa del vehículo: <span style="font-weight:bold; ">'.$sld['placa'].'</span></td>
				</tr>';
			}

			$cadena.='<tr>
			<td  colspan="2" style="height:25px; text-align:justify; font-size:11px font-weight:bold; ">

			<br><br><table style="border:1px solid black;" cellpadding="2">
			<tr>
			<td colspan="4"  style="border:1px solid black;">DETALLE</td>

			</tr>
			<tr>
			<td rowspan="2" style="border:1px solid black;width:30%">Numeración del Nº</td>
			<td  style="border:1px solid black; width:30%">Cupones entregados al Nº</td>
			<td rowspan="2" style="border:1px solid black; width:20%">Cantidad</td>
			<td rowspan="2" style="border:1px solid black; width:20%">Valor total</td>
			</tr>
			<tr>
			<td >TOTALES</td>
			</tr>';

			foreach ($recibo_cupones_combustible2 as $key => $sld) {

				$cadena.='<tr>
				<td  style="border:1px solid black;">'.$sld['inicio'].'</td>
				<td  style="border:1px solid black;">'.$sld['fin'].'</td>
				<td  style="border:1px solid black;">'.$sld['cantidad'].'</td>
				<td  style="border:1px solid black;">'.$sld['valor_total'].'</td>
				</tr>';
			}

			$cadena.='</table><br><br><br><br>
			</td>
			</tr>

			<tr>
			<td colspan="2" style="height:25px; text-align:justify; font-size:11px font-weight:bold;  ">

			<br><br><table >
			<tr>
			<td  style="height:50px; text-align:justify;  width:25%;">Entrega:</td>
			<td style="height:50px; text-align:justify;   width:10%;"></td>
			<td style="height:50px; text-align:justify;   width:25%;">Recibe:</td>
			<td style="height:50px; text-align:justify;   width:10%;"></td>
			<td style="height:50px; text-align:justify;   width:25%;">Autoriza:</td>
			</tr>
			<tr>
			<td  style=" text-align:justify; ">F.</td>
			<td style=" text-align:justify;  "></td>
			<td style=" text-align:justify; ">F.</td>
			<td style=" text-align:justify;  "></td>
			<td style=" text-align:justify;  ">F.</td>
			</tr>
			';

			foreach ($recibo_cupones_combustible as $key => $sld) {
				$cadena.='
				<tr>
				<td  style="height:25px; text-align:justify; font-size:7px;border-top:1px solid black; "></td>
				<td style="height:25px; text-align:justify; "></td>
				<td style="height:25px; text-align:justify; border-top:1px solid black;">'.$sld['usuario_recibe'].'</td>
				<td style="height:25px; text-align:justify;  "></td>
				<td style="height:25px; text-align:justify; font-size:7px;border-top:1px solid black;"></td>
				</tr>';
			}

			$cadena.='<tr>
			<td  style="height:25px; font-size:9px; text-align:left;">Encargado(a) de fondos combustible</td>
			<td style="height:25px; text-align:justify;"></td>
			<td style="height:25px; text-align:justify; border-top:1px solid black; font-size:7px;"><span style="font-weight:bold; ">Nombre</span></td>
			<td style="height:25px; text-align:justify;"></td>
			<td style="height:25px; font-size:9px; text-align:justify;">Gerencia administrativa</td>
			</tr><tr>
			<td  style=" text-align:justify;"></td>
			<td style=" text-align:justify;"></td>
			<td style=" text-align:justify; font-size:7px; "><span style="font-weight:bold; "></span></td>
			<td style=" text-align:justify;"></td>
			<td style=" text-align:justify;"></td>
			</tr></table><br><br>
			</td>
			</tr>
			';
					//}
			$cadena.='</table> ';
			$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

			$data['table_header']= $rows;
			$data['table_tbody']= $cadena;
			$data['filename']= $filename;

			$this->pdf->reportePDF('transporte/reportes/reporte_recibo_cupones_combustible', $data, '');
                 //$this->load->view('transporte/reportes/imprimir_solicitud_transporte',$data);

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} 



public function imprimir_recepcion_vehiculo($id=null,$id2=null)
  {
    satelite_validar();
    try {
      
      $recepcion_vehiculo1=$this->entradas_model->get_recepcion_vehiculo1($id2);
      $recepcion_vehiculo2=$this->entradas_model->get_recepcion_vehiculo2($id2,$id);
      $recepcion_vehiculo3=$this->entradas_model->get_recepcion_vehiculo3($id2,$id);// en caso de ser entrada (query3)
           
           
        //die(print_r($recepcion_vehiculo3,true));
      $subtitulo="Departamento de Transporte";
      $cadena="";

      $rows=$this->load->view('reporte/header', array('titulo' => "Formulario de Recepción/Entrega de Vehículos"), true);
      $data['areas']=$this->gsatelite->get_tabla('are_area');         
      //$cadena.='<table style="">';             
      $cadena.='<table style=" width: 100%;">';

      foreach ($recepcion_vehiculo2 as $key => $sld) {
         
        $cadena.='<tr>
        <td colspan="7" style="height:15px; text-align:justify; font-size:11px; font-weight:bold;">Tipo: <span style="font-weight:normal; ">'.$sld['rec_tipo'].'</span></td>
        </tr>';
      }
$cadena.='<tr>
        <td colspan="7" style="height:15px; text-align:justify; font-size:11px; font-weight:bold;  "><span style="font-weight:bold; "></span></td>
        </tr>

        <tr>
        <td colspan="7" style="height:25px; text-align:center; font-size:11px; font-weight:bold;">Recepción <span style="font-weight:bold; "></span></td>
        </tr>
          <tr>
        <td  style=" text-align:justify; font-size:11px font-weight:bold;  ">&nbsp; <span style="font-weight:bold; "></span></td>
        <td style=" text-align:justify; font-size:11px font-weight:bold; ">&nbsp; <span style="font-weight:bold; "></span></td>
        <td  style=" text-align:justify; font-size:11px font-weight:bold; ">&nbsp; <span style="font-weight:bold; "></span></td>
        <td style=" text-align:justify; font-size:11px font-weight:bold; ">&nbsp; <span style="font-weight:bold; "></span></td>
        <td  style=" text-align:justify; font-size:11px font-weight:bold; ">&nbsp; <span style="font-weight:bold; "></span></td>
        <td style=" text-align:justify; font-size:11px font-weight:bold; ">&nbsp;<span style="font-weight:bold; "></span></td>
        <td  style=" text-align:justify; font-size:11px font-weight:bold; ">&nbsp; <span style="font-weight:bold; "></span></td>
        </tr>
        <tr>
          <td  style="height:25px; text-align:justify; font-size:9px; width:25%; font-weight:bold;">Fecha/Hora de recepción: <span style="font-weight:bold; "></span></td>
          <td  style="height:15px; text-align:justify; font-size:10px; width:25%; font-weight:bold;"> <span style="font-weight:normal; ">'.date('d-m-Y', strtotime($sld['rec_fecha'])).'</span></td>
          <td  style="height:25px; text-align:justify; font-size:9px;  font-weight:bold; width:25%;">Kilometraje:<span style="font-weight:bold; "></span></td>
          <td  style="height:15px; text-align:justify; font-size:9px; font-weight:bold;"> <span style="font-weight:normal; ">'.$sld['rec_kilometraje'].'</span></td>
        </tr>
        ';
        
      foreach ($recepcion_vehiculo2 as $key => $sld) {
      $cadena.='
        <tr>
          <td  style="height:25px; text-align:justify; font-size:9px; font-weight:bold;">Placa:<span style="font-weight:bold; "></span></td>
          <td  style="height:15px; text-align:justify; font-size:9px; font-weight:bold;"> <span style="font-weight:normal; ">'.$recepcion_vehiculo1[0]['veh_placa'].'</span></td>
          <td  style="height:25px; text-align:justify; font-size:9px; font-weight:bold;">Condición del tanque:<span style="font-weight:bold; "></span></td>
          <td  style="height:15px; text-align:justify; font-size:9px font-weight:bold;"> <span style="font-weight:normal; ">'.$sld['rec_tanque'].'</span></td>
        </tr>';
      }
      //foreach ($recepcion_vehiculo1 as $key => $sld) {
          $cadena.='
            ';
      //} 
      foreach ($recepcion_vehiculo2 as $key => $sld) {
              $cadena.='
          ';
      }

 $cadena.='
        <tr>
          <td style="height:25px; text-align:justify; font-size:11px font-weight:bold; ">&nbsp; <span style="font-weight:bold; "></span></td>
          <td style="height:25px; text-align:justify; font-size:11px font-weight:bold; ">&nbsp; <span style="font-weight:bold; "></span></td>
          <td style="height:25px; text-align:justify; font-size:11px font-weight:bold; ">&nbsp; <span style="font-weight:bold; "></span></td>
          <td style="height:25px; text-align:justify; font-size:11px font-weight:bold; ">&nbsp; <span style="font-weight:bold; "></span></td>
          <td style="height:25px; text-align:justify; font-size:11px font-weight:bold; ">&nbsp; <span style="font-weight:bold; "></span></td>
          <td style="height:25px; text-align:justify; font-size:11px font-weight:bold; ">&nbsp;<span style="font-weight:bold; "></span></td>
          <td style="height:25px; text-align:justify; font-size:11px font-weight:bold; ">&nbsp; <span style="font-weight:bold; "></span></td>
        </tr>

        <tr>
          <td rowspan="20" style="height:25px; text-align:justify; width:20%; font-weight:bold; "> <span style="font-weight:bold; "></span></td>
          <td style="height:25px; text-align:justify; font-size:9px; font-weight:bold; border: 1px solid black;">Componentes<span style="font-weight:bold; "></span></td>
          <td style="height:25px; text-align:justify; font-size:9px; font-weight:bold; border: 1px solid black;">Si/No<span style="font-weight:bold; "></span></td>
        </tr>
        ';
//         }
        $i = 0;
      foreach ($recepcion_vehiculo1 as $key => $sld) {
          $cadena.='<tr>
        <td style="height:25px; text-align:justify; font-size:9px; font-weight:normal; border: 1px solid black;">'.$sld['hev_nombre'].'</td>
        <td style="height:25px; text-align:justify; font-size:9px; font-weight:normal; border: 1px solid black;">'.$sld['estado'].'</td>
        </tr>
        ';
      $i += 1;
      }
      if ($i == 1) {
       $cadena.='<tr>
        <td style="height:25px; text-align:justify; font-weight:bold; border: 1px solid black;"></td>
        <td style="height:25px; text-align:justify; font-weight:bold; border: 1px solid black;"></td>
        </tr>
          <tr>
        <td style="height:25px; text-align:justify; font-weight:bold; border: 1px solid black;"></td>
        <td style="height:25px; text-align:justify; font-weight:bold; border: 1px solid black;"></td>
        </tr>';
      }
      if ($i == 2) {
       $cadena.='<tr>
        <td style="height:25px; text-align:justify;  font-weight:bold; border: 1px solid black;"></td>
        <td style="height:25px; text-align:justify; font-weight:bold; border: 1px solid black;"></td>
        </tr>';
      }
      if ($i > 2) {
       
      }
      
//         }
     /* foreach ($recepcion_vehiculo2 as $key => $sld) {
        $cadena.='<tr>
          <td colspan="4"  style="height:25px; text-align:justify;  font-weight:bold; border: 1px solid black; ">OBSERVACIONES: '.$sld['rec_observacion'].'</td>
          </tr>';
      }*/
        $cadena.='</table> ';
        
        $cadena.='<br><br><br><br><br><br>
                <table>
                <tr>
                  <td style="height:25px; width:15%; text-align:justify; font-weight:bold;"></td>
                  <td style="height:20px; text-align:justify; font-weight:bold; border-top: 1px solid black;">Recibe</td>
                  <td style="height:25px; text-align:justify; font-weight:bold;"></td>
                  <td style="height:25px; text-align:justify; font-weight:bold; border-top: 1px solid black;">Entrega</td>
                  <td style="height:25px; text-align:justify; font-weight:bold;"></td>

                </tr>
                <tr>
                  <td>
                  </td>
                </tr>
                <tr>
                  <td style="height:25px; width:15%; text-align:justify; font-weight:bold;"></td>
                  <td style="height:15px; text-align:justify; font-weight:bold; border: 1px solid black;">Fecha/Hora de entrega</td>

                  <td style="height:20px; text-align:justify; font-weight:bold;">&nbsp;</td>

                  <td style="height:20px; text-align:justify; font-weight:bold; ">&nbsp;</td>

                  <td style="height:20px; text-align:justify; font-weight:bold; ">&nbsp;</td>
                </tr> ';
//         }
          foreach ($recepcion_vehiculo2 as $key => $sld) {
          $cadena.='
            <tr>
            <td style="height:25px; width:15%; text-align:justify; font-weight:bold;"></td>
            <td style="height:25px; text-align:justify; font-weight:normal; border: 1px solid black;">'.$sld['rec_fecha'].'</td>

            <td style="height:25px; text-align:justify; font-weight:bold; ">&nbsp;</td>

            <td style="height:25px; text-align:justify; font-weight:bold; border-TOP: 1px solid black;">Recibe conforme</td>

            <td style="height:25px; text-align:justify; font-weight:bold; ">&nbsp;</td>

          </tr>
          <tr>
            <td style="height:25px; width:15%; text-align:justify; font-weight:bold;"></td>
            <td style="height:25px; text-align:justify; font-weight:bold; ">&nbsp;</td>

            <td style="height:25px; text-align:justify; font-weight:bold; ">&nbsp;</td>

            <td style="height:25px; text-align:justify; font-weight:bold; ">&nbsp;</td>

            <td style="height:25px; text-align:justify; font-weight:bold; ">&nbsp;</td>

          </tr>
          <tr>
            <td style="height:25px; width:15%; text-align:justify; font-weight:bold;"></td>
            <td style="height:15px; text-align:justify; font-weight:bold; border: 1px solid black;">Kilometraje</td>

            <td style="height:25px; text-align:justify; font-weight:bold;">&nbsp;</td>

            <td style="height:25px; text-align:justify; font-weight:bold; ">&nbsp;</td>

            <td style="height:25px; text-align:justify; font-weight:bold; ">&nbsp;</td>

          </tr>
          <tr>
            <td style="height:25px; width:15%; text-align:justify; font-weight:bold;"></td>
            <td style="height:25px; text-align:justify; font-weight:normal; border: 1px solid black;">'.$sld['rec_kilometraje'].'</td>

            <td style="height:25px; text-align:justify; font-weight:bold; ">&nbsp;</td>

            <td style="height:25px; text-align:justify; font-weight:bold; border-TOP: 1px solid black;">Entrega</td>

            <td style="height:25px; text-align:justify; font-weight:bold; ">&nbsp;</td>';
                  
        $cadena.='
          </tr>
              <tr>
            <td style="height:25px; text-align:justify; font-weight:bold; ">&nbsp;</td>

            <td style="height:25px; text-align:justify; font-weight:bold; ">&nbsp;</td>

            <td style="height:25px; text-align:justify; font-weight:bold; ">&nbsp;</td>

            <td style="height:25px; text-align:justify; font-weight:bold; ">&nbsp;</td>

            </tr>
            </table> ';

        $cadena.='<table> 
          <tr>
          <td style="height:25px; WIDTH=50px; text-align:left; "><b>Observaciones:</b>'.$sld['rec_observacion'].'</td>
          
          </tr>';
        }

// 									//}
        $cadena.='</table> ';

       // echo $cadena;
        //die();

             	 $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']= $rows;
            $data['subtitulo']= $subtitulo;
            $data['table_tbody']= $cadena;
            $data['filename']= $filename;
            
               $this->pdf->reportePDF('transporte/reportes/imprimir_recepcion_vehiculo', $data,'');
                 //$this->load->view('transporte/reportes/imprimir_solicitud_transporte',$data);
         


		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} 

  public function reporte_combustible()
  {
    {
     if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
        } else {  
            $data['estados'] = $this->gsatelite->get_tabla('esk_estado_ticket');
            $data["titulo_personal"] ="Reporte Combustible";

            $this->_cargarvista($data);
        }
  }
  }

  function consultar_combustible(){
      
    $fecha_ini=$this->input->post('desde');
    $fecha_fin=$this->input->post('hasta');
    $estado=$this->input->post('estado');
  
    $fecha_inicio=date('Y-m-d', strtotime($fecha_ini));
    $fecha_fn=date('Y-m-d', strtotime($fecha_fin));

    $data['combustible']=$this->entradas_model->get_combustible_gasto($fecha_inicio, $fecha_fn,$estado);
   // print_r($this->db->last_query());
    $respuesta=array(
      'html'=>$this->load->view('transporte/reportes/consultar_combustible', $data, true),
      'combustible'=>(count($data['carga_datos'])>0)? 1: 0
      );
    echo json_encode($respuesta);
  }

  function imprimir_combustible_pdf(){
      
    $fecha_ini=$this->input->post('desde');
    $fecha_fin=$this->input->post('hasta');
    $tipo=$this->input->post('tipo');
    $estado=$this->input->post('estados');

    $fecha_inicio=date('Y-m-d', strtotime($fecha_ini));
    $fecha_fn=date('Y-m-d', strtotime($fecha_fin));

    $data['combustible']=$this->entradas_model->get_combustible_gasto($fecha_inicio, $fecha_fn, $estado);
    //print_r($this->db->last_query()); die();
    if ($tipo == 1) {
        $this->load->library('pdf');
     //   load->view('reporte/header', array('titulo' => "Ejecución Contratos"), true);
        $html=$this->load->view('reporte/header_sen', array('titulo' => 'Reporte de consumo de combustible', 'solotitulo' => true, 'subtitulo'=> 'DEL '.$fecha_ini.' AL '.$fecha_fin.''), true);
        $html.=$this->load->view('transporte/reportes/consultar_combustible_pdf', $data, true);
        $this->pdf->makePDF($html);
    }else{
                    $this->load->view('transporte/reportes/consultar_combustible_exl', $data);
    }
  }


   /**
  * @author René Castaneda
  * @since 2020-12-10
  * @return/descripción reporte vehículos
   */
  public function reporte_vehiculo()
  {   
      satelite_validar();
      $permisos = $this->gsatelite->get_permisos_opcion();
      $data['permisos']=$permisos;
                        $this->db->join('veh_vehiculo', 'veh_id_emp = emp_id');
                        $this->db->group_by('emp_id');
      $slcResponsable = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), null, '', 'emp_id', true);
      $data['slcResponsable'] = str_replace('<option value="0">Seleccione</option>', '', $slcResponsable);
      $slcTipo = $this->gsatelite->get_dropdown('tvh_tipo_vehiculo', '{tvh_nombre}', '', array('tvh_estado' => '1'), null, '', 'tvh_id', true);
      $data['slcTipo'] = str_replace('<option value="0">Seleccione</option>', '', $slcTipo);
      $slcMarca = $this->gsatelite->get_dropdown('mrv_marca', '{mrv_nombre}', '', array('mrv_estado' => '1'), null, '', 'mrv_id', true);
      $data['slcMarca'] = str_replace('<option value="0">Seleccione</option>', '', $slcMarca);
      $slcTipCombustible = $this->gsatelite->get_dropdown('tpc_tipo_combustible', '{tpc_nombre}', '', array('tpc_estado' => '1'), null, '', 'tpc_id', true);
      $data['slcTipCombustible'] = str_replace('<option value="0">Seleccione</option>', '', $slcTipCombustible);

      $data['titulo_personal'] = "Reporte Vehículos";
      cargarvista($data);
  }

  /**
  * @author René Castaneda
  * @since 2020-12-10
  * @return filtrar vehículos
   */
  public function filtrar_reporte_vehiculo($es_reporte=0)
  {   
      satelite_validar();
      $registros = array();
      $permisos = $this->gsatelite->get_permisos_opcion('reporte_vehiculo');
      $data['permisos']=$permisos;
      $data["es_reporte"] = $es_reporte;
      $data["post"] = $this->input->post();
      $txtFecha_desde =  $this->input->post('txtFecha_desde');
      $txtFecha_hasta = $this->input->post('txtFecha_hasta');
      $slcResponsable =  $this->input->post('slcResponsable');
      $slcTipo = $this->input->post('slcTipo');
      $slcMarca = $this->input->post('slcMarca');
      $slcTipCombustible = $this->input->post('slcTipCombustible');
      $slcEstado = $this->input->post('slcEstado');

      
      if ($this->input->post()) {                        
          if ($slcResponsable > 0) {
              $where["veh_id_emp"]=$slcResponsable;
          }
          if ($slcTipo > 0) {
              $where["veh_id_tvh"]=$slcTipo;
          }
          if (is_numeric($slcEstado)) {
              $where['veh_estado'] = $slcEstado;
          }
          if ($slcMarca > 0) {
              $where['veh_id_mrv']=$slcMarca;
          }
          if ($slcTipCombustible > 0) {
              $where['veh_id_tpc']=$slcTipCombustible;
          }
          if ($txtFecha_desde != "") {
              $where['DATE(veh_fecha_vence_seguro) >=']=formatear_fecha('Y-m-d', $txtFecha_desde);
          }
          if ($txtFecha_hasta > 0) {
              $where['DATE(veh_fecha_vence_seguro) <=']=formatear_fecha('Y-m-d', $txtFecha_hasta);
          }
      }
     
     $registros=$this->transporte_model->get_vehiculo($where);
      
      $data['registros'] = $registros;
      $html = $this->load->view('transporte/reportes/filtrar_reporte_vehiculo', $data, true);

      if ($es_reporte) {
          $tipo_accion = $this->input->post('tipo_accion');
          if ($tipo_accion) { //excel
              header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
              header("Content-Disposition: attachment;filename=reporte_vehiculo_".date('d-m-Y_His').".xls"); 
              header("Pragma: no-cache");
              header("Expires: 0");
              echo '<meta charset="utf-8" />';
              echo "<table border='0'>
                <tr><th colspan='30' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                <tr><th colspan='30' align='center' >Reporte Vehículo</th></tr>
                </table>";
              echo $html; die();
          } else { //pdf
              ini_set( 'memory_limit', '2048M' );
              ini_set('max_execution_time', '9999');

              $this->load->library('pdf');
              $html_header=$this->load->view('reporte/header', array('titulo' => "Reporte Vehículo", 'solotitulo'=> true), true);
              $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
              $this->pdf->makePDF($html_header.$html,'lanscape', 'reporte_vehiculo','Legal');
              die();
          }
      }
      echo json_encode(array('html'=>$html));
  }

   /**
  	* @author René Castaneda
	* @since 2020-12-10	
	* @return descripción reporte mtto vehículos
   */
	public function reporte_mtto_vehiculo()
	{   
		satelite_validar();
		$permisos = $this->gsatelite->get_permisos_opcion();
		$data['permisos']=$permisos;
						  $this->db->join('veh_vehiculo', 'veh_id_emp = emp_id');
						  $this->db->group_by('emp_id');
		$slcResponsable = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), null, '', 'emp_id', true);
		$data['slcResponsable'] = str_replace('<option value="0">Seleccione</option>', '', $slcResponsable);

					   $this->db->join('mrv_marca', 'mrv_id=veh_id_mrv', 'left');
					   $this->db->join('mdv_modelo_veh', 'mdv_id=veh_id_mdv','left');
		$slcVehiculo = $this->gsatelite->get_dropdown('veh_vehiculo', '{veh_placa} / {mrv_nombre} / {mdv_nombre}', '', null, null, '', 'veh_id', true);
		$data['slcVehiculo'] = str_replace('<option value="0">Seleccione</option>', '', $slcVehiculo);
		$slcTipoMtto = $this->gsatelite->get_dropdown('tmn_tipo_mantto', '{tmn_nombre}', '', array('tmn_estado' => '1'), null, '', 'tmn_id', true);
		$data['slcTipoMtto'] = str_replace('<option value="0">Seleccione</option>', '', $slcTipoMtto);
		$slcTipoOperacion = $this->gsatelite->get_dropdown('opm_operacion_mantto', '{opm_nombre}', '', array('opm_id' => '0'), null, '', 'opm_id', true);
		$data['slcTipoOperacion'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $slcTipoOperacion);
		$slcEstado = $this->gsatelite->get_dropdown('emt_estado_mantenimiento', '{emt_nombre}', '', array('emt_estado' => '1'), null, '', 'emt_id', true);
		$data['slcEstado'] = str_replace('<option value="0">Seleccione</option>', '', $slcEstado);

						$this->db->join('gmt_gestion_mantto', 'gmt_id_prv = prv_id');
						$this->db->group_by('prv_id');
		$slcProveedor = $this->gsatelite->get_dropdown('prv_proveedor', '{prv_nombre} {prv_apellido}', '', array('prv_estado' => '1'), null, '', 'prv_id', true);
		$data['slcProveedor'] = str_replace('<option value="0">Seleccione</option>', '', $slcProveedor);

		$data['titulo_personal'] = "Reporte Mtto Vehículos";
		cargarvista($data);
	}

  	/**
  	* @author René Castaneda
  	* @since 2020-12-10
  	* @return filtrar mtto vehículos
   	*/
  	public function filtrar_reporte_mtto_vehiculo($es_reporte=0)
  	{   
  		satelite_validar();
  		$registros = array();
  		$permisos = $this->gsatelite->get_permisos_opcion('reporte_mtto_vehiculo');
  		$data['permisos']=$permisos;
  		$data["es_reporte"] = $es_reporte;
  		$data["post"] = $this->input->post();
  		$txtFecha_desde =  $this->input->post('txtFecha_desde');
  		$txtFecha_hasta = $this->input->post('txtFecha_hasta');
  		$slcResponsable =  $this->input->post('slcResponsable');
  		$slcVehiculo = $this->input->post('slcVehiculo');
  		$slcTipoMtto = $this->input->post('slcTipoMtto');
  		$slcTipoOperacion = $this->input->post('slcTipoOperacion');
  		$slcProveedor = $this->input->post('slcProveedor');
  		$slcEstado = $this->input->post('slcEstado');
  		$where = array();
  		if ($this->input->post()) {
  			if ($slcResponsable > 0) {
  				$where["veh_id_emp"]=$slcResponsable;
  			}
  			if ($slcVehiculo > 0) {
  				$where["veh_id"]=$slcVehiculo;
  			}
  			if ($slcTipoMtto > 0) {
  				$where['opm_id_tmn']=$slcTipoMtto;
  			}
  			if ($slcTipoOperacion > 0) {
  				$where['gmt_id_opm']=$slcTipoOperacion;//gmt_id_opm_id_tmn
  			}
  			if ($slcEstado > 0) {
  				$where['gmt_id_emt']=$slcEstado;
  			}
  			if ($slcProveedor > 0) {
  				$where['gmt_id_prv']=$slcProveedor;
  			}
  			if ($txtFecha_desde != "") {
  				$where['DATE(gmt_fecha) >=']=formatear_fecha('Y-m-d', $txtFecha_desde);
  			}
  			if ($txtFecha_hasta > 0) {
  				$where['DATE(gmt_fecha) <=']=formatear_fecha('Y-m-d', $txtFecha_hasta);
  			}
  		}
  		$registros=$this->transporte_model->get_mtto_vehiculo($where);

  		$data['registros'] = $registros;
  		$html = $this->load->view('transporte/reportes/filtrar_reporte_mtto_vehiculo', $data, true);

  		if ($es_reporte) {
  			$tipo_accion = $this->input->post('tipo_accion');
  			if ($tipo_accion) { //excel
  				header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
  				header("Content-Disposition: attachment;filename=reporte_mtto_vehiculo_".date('d-m-Y_His').".xls"); 
  				header("Pragma: no-cache");
  				header("Expires: 0");
  				echo '<meta charset="utf-8" />';
  				echo "<table border='0'>
  				<tr><th colspan='13' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
  				<tr><th colspan='13' align='center' >Reporte Mantenimiento Vehículo</th></tr>
  				</table>";
  				echo $html; die();
  			} else {
  				 //pdf
  				ini_set( 'memory_limit', '2048M' );
  				ini_set('max_execution_time', '9999');
  				$this->load->library('pdf');
  				$html_header=$this->load->view('reporte/header', array('titulo' => "Reporte Mantenimiento Vehículo", 'solotitulo'=> true), true);
  				$html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
  				$this->pdf->makePDF($html_header.$html,'lanscape', 'reporte_mtto_vehiculo','Ledger');
  				die();
  			}
  		}
  		echo json_encode(array('html'=>$html));
  }

  /**
  * @author René Castaneda
  * @since 2020-12-11
  * @return filtrar las operaciones dependiendo el tipo
   */
  public function filtrar_operacion_option()
  {
      $buscar = array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>');
      $where['opm_id_tmn'] = $this->input->post('slcTipoMtto');
      if ($where['opm_id_tmn'] > 0 ) {
          $data['options'] = $this->gsatelite->get_dropdown('opm_operacion_mantto', '{opm_nombre}','', $where, null, '', 'opm_id', true);
      } else {
          $data['options'] = $this->gsatelite->get_dropdown('opm_operacion_mantto', '{opm_nombre}','', array('opm_id'=>0), null, '', 'opm_id', true);
      }
      $data['options'] = str_replace($buscar, '<option value=""></option>', $data['options']);
      die(json_encode($data));
  }

   /**
  * @author René Castaneda
  * @since 2021-03-20
  * @return/descripción reporte seguimiento mtto vehículos
   */
  public function reporte_seguimiento_mtto()
  {   
      satelite_validar();
      $permisos = $this->gsatelite->get_permisos_opcion();
      $data['permisos']=$permisos;
                        $this->db->join('veh_vehiculo', 'veh_id_emp = emp_id');
                        $this->db->group_by('emp_id');
      $slcResponsable = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), null, '', 'emp_id', true);
      $data['slcResponsable'] = str_replace('<option value="0">Seleccione</option>', '', $slcResponsable);

                      $this->db->join('mrv_marca', 'mrv_id=veh_id_mrv', 'left');
                      $this->db->join('mdv_modelo_veh', 'mdv_id=veh_id_mdv','left');
      $slcVehiculo = $this->gsatelite->get_dropdown('veh_vehiculo', '{veh_placa} / {mrv_nombre} / {mdv_nombre}', '', null, null, '', 'veh_id', true);
      $data['slcVehiculo'] = str_replace('<option value="0">Seleccione</option>', '', $slcVehiculo);
      $slcTipoMtto = $this->gsatelite->get_dropdown('tmn_tipo_mantto', '{tmn_nombre}', '', array('tmn_estado' => '1'), null, '', 'tmn_id', true);
      $data['slcTipoMtto'] = str_replace('<option value="0">Seleccione</option>', '', $slcTipoMtto);
      $slcTipoOperacion = $this->gsatelite->get_dropdown('opm_operacion_mantto', '{opm_nombre}', '', array('opm_id' => '0'), null, '', 'opm_id', true);
      $data['slcTipoOperacion'] = str_replace('<option value="0">Seleccione</option>', '', $slcTipoOperacion);
      $slcEstado = $this->gsatelite->get_dropdown('emt_estado_mantenimiento', '{emt_nombre}', '', array('emt_estado' => '1'), null, '', 'emt_id', true);
      $data['slcEstado'] = str_replace('<option value="0">Seleccione</option>', '', $slcEstado);

                        $this->db->join('gmt_gestion_mantto', 'gmt_id_prv = prv_id');
                        $this->db->group_by('prv_id');
      $slcProveedor = $this->gsatelite->get_dropdown('prv_proveedor', '{prv_nombre} {prv_apellido}', '', array('prv_estado' => '1'), null, '', 'prv_id', true);
      $data['slcProveedor'] = str_replace('<option value="0">Seleccione</option>', '', $slcProveedor);

      $data['titulo_personal'] = "Reporte Seguimiento Mtto";
      cargarvista($data);
  }

  /**
  * @author René Castaneda
  * @since 2021-03-14
  * @return filtrar mtto vehículos
   */
  public function filtrar_reporte_seguimiento_mtto($es_reporte=0)
  {   
      satelite_validar();
      $registros = array();
      $permisos = $this->gsatelite->get_permisos_opcion('reporte_seguimiento_mtto');
      $data['permisos']=$permisos;
      $data["es_reporte"] = $es_reporte;
      $data["post"] = $this->input->post();
      $txtFecha_desde =  $this->input->post('txtFecha_desde');
      $txtFecha_hasta = $this->input->post('txtFecha_hasta');
      $slcResponsable =  $this->input->post('slcResponsable');
      $slcVehiculo = $this->input->post('slcVehiculo');
      $slcTipoMtto = $this->input->post('slcTipoMtto');
      $slcTipoOperacion = $this->input->post('slcTipoOperacion');
      $slcProveedor = $this->input->post('slcProveedor');
      $slcEstado = $this->input->post('slcEstado');
      $where_string = '';
      if ($this->input->post()) {                        
          if ($slcResponsable > 0) {
              $where["veh_id_emp"]=$slcResponsable;
          }
          if ($slcVehiculo > 0) {
              $where["veh_id"]=$slcTipo;
          }
          if ($slcTipoMtto > 0) {
              $where['opm_id_tmn']=$slcTipoMtto;
          }
          if ($slcTipoOperacion > 0) {
              $where['gmt_id_opm_id_tmn']=$slcTipoOperacion;
          }
        /*  if ($slcEstado > 0) {
              $where['gmt_id_emt']=$slcEstado;
          }
          if ($slcProveedor > 0) {
              $where['gmt_id_prv']=$slcProveedor;
          } */
          if ($txtFecha_desde != "") {
              $where['DATE(gmt_fecha_prox) >='] = formatear_fecha('Y-m-d', $txtFecha_desde);
              $where_string = "DATE(gmt_fecha) >= '".formatear_fecha('Y-m-d', $txtFecha_desde)."'";
          }
          if ($txtFecha_hasta > 0) {
              $where['DATE(gmt_fecha_prox) <='] = formatear_fecha('Y-m-d', $txtFecha_hasta);
              $where_string .= ($where_string != '')? "AND DATE(gmt_fecha) <= '".formatear_fecha('Y-m-d', $txtFecha_hasta)."'":"DATE(gmt_fecha) <= '".formatear_fecha('Y-m-d', $txtFecha_hasta)."'";
          }
      }
     if (trim($where_string) != '') {
       $registros=$this->transporte_model->get_seguimiento_mtto($where, "($where_string AND IFNULL(emt_seguimiento,0) = 1)");
       //echo $this->db->last_query(); die();
     } else {
      $registros=$this->transporte_model->get_seguimiento_mtto($where);
     }
     //echo $this->db->last_query(); die();

      $data['registros'] = $registros;
      $html = $this->load->view('transporte/reportes/filtrar_reporte_seguimiento_mtto', $data, true);

      if ($es_reporte) {
          $tipo_accion = $this->input->post('tipo_accion');
          if ($tipo_accion) { //excel
              header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
              header("Content-Disposition: attachment;filename=reporte_mtto_vehiculo_".date('d-m-Y_His').".xls"); 
              header("Pragma: no-cache");
              header("Expires: 0");
              echo '<meta charset="utf-8" />';
              echo "<table border='0'>
                <tr><th colspan='13' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                <tr><th colspan='13' align='center' >Reporte Mantenimiento Vehículo</th></tr>
                </table>";
              echo $html; die();
          } else { //pdf
              ini_set( 'memory_limit', '2048M' );
              ini_set('max_execution_time', '9999');

              $this->load->library('pdf');
              $html_header=$this->load->view('reporte/header', array('titulo' => "Reporte Mantenimiento Vehículo", 'solotitulo'=> true), true);
              $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
              $this->pdf->makePDF($html_header.$html,'lanscape', 'reporte_mtto_vehiculo','Ledger');
              die();
          }
      }
      echo json_encode(array('html'=>$html));
  }

  /**
  * @author René Castaneda
  * @since 2021-04-24
  * @return filtrar mtto vehículos
   */
  public function notificacion_mtto()
  {   
      $this->gsatelite->actualizar_array('par_parametro',array('par_valor'=>date('Y-m-d')), array('par_codigo'=>'SYS_FECHA_NOTIFICACION_MTTO'));
      $registros = array();
      $data["es_reporte"] = 0;
      $fecha1 = date_create(date("Y-m-d"));
      date_add($fecha1, date_interval_create_from_date_string("-155 days"));

      $fecha2 = date_create(date("Y-m-d"));
      date_add($fecha2, date_interval_create_from_date_string("5 days"));

      $txtFecha_desde =  date_format($fecha1,"d-m-Y");
      $txtFecha_hasta = date_format($fecha2,"d-m-Y");
      $where_string = '';
      if ($txtFecha_desde != "") {
          $where['DATE(gmt_fecha_prox) >='] = formatear_fecha('Y-m-d', $txtFecha_desde);
          $where_string = "DATE(gmt_fecha) >= '".formatear_fecha('Y-m-d', $txtFecha_desde)."'";
      }
      if ($txtFecha_hasta > 0) {
          $where['DATE(gmt_fecha_prox) <='] = formatear_fecha('Y-m-d', $txtFecha_hasta);
          $where_string .= ($where_string != '')? "AND DATE(gmt_fecha) <= '".formatear_fecha('Y-m-d', $txtFecha_hasta)."'":"DATE(gmt_fecha) <= '".formatear_fecha('Y-m-d', $txtFecha_hasta)."'";
      }
      
      $registros=$this->transporte_model->get_seguimiento_mtto($where, "($where_string AND IFNULL(emt_seguimiento,0) = 1)");
      $data['registros'] = $registros;
      $html = $this->load->view('transporte/reportes/notificacion_mtto', $data, true);

      $correos = $this->gsatelite->get_parametro('SYS_CORREO_MANTTO');
      $para = $correos;
      $mensaje = $html;
      $respuesta['exito'] = 0;
      if (count($registros) > 0 && substr_count($correos,'@') > 0 ) {
          $enviarCorreo = $this->gsatelite->envio_correo("notificaciones@gruposatelite.net","Sistema de transporte",$para,"Notificación de Mantenimiento",$mensaje);
          $respuesta['exito'] = $enviarCorreo;
      }
      die(json_encode($respuesta));
  }

 
	function _cargarvista($data=0,$crud=0, $modulo_principal=null)
	{ 
	    $this->load->view('vacia',$crud); 
	    if($data!=0)
	      $data=array_merge($data,$this->masterpage->getUsuario($modulo_principal));
	    else
	      $data=$this->masterpage->getUsuario($modulo_principal);  
	     
	    $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
	    $this->masterpage->setMasterPage('masterpage_default');
	    $this->masterpage->addContentPage($vista, 'content',$data);
	    $this->masterpage->show();
	} // end of _cargarvista

} // End of class reportes