<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Procesos extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->database();
		$this->load->helper('url');
		$this->load->model('entradas_model');
		$this->load->model('transporte_model');
		$this->load->model('gsatelite2');
		$this->load->library('grocery_CRUD');
		
	}

	// All your functions goes here

	public function gestion_vehiculo()
	{
		satelite_validar();
		try{

			$crud = new grocery_CRUD();
			$crud->unset_export();
			$crud->unset_print();
			$crud->unset_add();
			$crud->unset_edit();
			$crud->unset_delete();
			$crud->unset_read();

			$crud->set_table('veh_vehiculo');
			$crud->set_subject('');
			
			$columnas = array(
							'veh_id_emp',
							'veh_placa',
							// 'veh_id_tvh',
							'veh_id_mrv',
							'veh_id_mdv',
							'veh_ano',
							'veh_id_ach',
							'veh_gps',
							'veh_tel_gps',
							'Deposito',
							'Cuota',
							'Motorista',
							);

			$display_as = array(
							'veh_placa' => 'Placa',
							'veh_id_mrv' => 'Marca',
							'veh_id_mdv' => 'Modelo',
							'veh_ano' => 'Año',
							'veh_id_emp' => 'Responsable',
							'veh_id_tvh' => 'Tipo de vehículo',
							'veh_id_ach' => 'Aceite',
							'veh_gps' => 'ID GPS',
							'veh_tel_gps' => 'Tél. GPS', 
							'veh_id_stv' => 'Estatus'
							);

			$crud->set_relation('veh_id_tvh','tvh_tipo_vehiculo','tvh_nombre', array('tvh_estado' => 1));
			$crud->set_relation('veh_id_mrv','mrv_marca','mrv_nombre', array('mrv_estado' => 1));
			$crud->set_relation('veh_id_mdv','mdv_modelo_veh','mdv_nombre', array('mdv_estado' => 1));
			$crud->set_relation('veh_id_ach', 'ach_aceite_vehiculo', 'ach_nombre', array('ach_estado' => 1));
			$crud->set_relation('veh_id_stv','stv_status_vehiculo','stv_nombre', array('stv_estado' => 1));
			$crud->set_relation('veh_id_emp', 'emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', array('emp_estado' => 1));
			$crud->columns($columnas);
			$crud->display_as($display_as);
			$crud->add_action('Recorrido', '', 'transporte/procesos/registrar_vehiculo','icomoon-icon-checkmark-2 ver_en_modal');
			$crud->add_action('Asignación', '', 'transporte/procesos/asignar_vehiculo','icomoon-icon-clipboard-2 ver_en_modal');
			//pendiente estabilizar
			//$crud->add_action('Recepción', '', 'transporte/procesos/recepcion_vehiculo','minia-icon-calendar-2 ver_en_modal');
			$crud->add_action('Mantenimientos', '', 'transporte/procesos/mantenimiento_veh/0','silk-icon-checklist ver_en_modal');
			$crud->callback_column('Deposito', function($value, $row) {
					$q = $this->transporte_model->get_asignacion_last(array('asv_id_veh'=>$row->veh_id, 'asv_estado'=>1)); 
				    return ($q)? $q['asv_deposito']:'';
			});
			$crud->callback_column('Cuota', function($value, $row) {
					$q = $this->transporte_model->get_asignacion_last(array('asv_id_veh'=>$row->veh_id, 'asv_estado'=>1)); 
				    return ($q)? $q['asv_cuota']:'';
			});
			$crud->callback_column('Motorista', function($value, $row) {
					$q = $this->transporte_model->get_asignacion_last(array('asv_id_veh'=>$row->veh_id, 'asv_estado'=>1)); 
				    return ($q)? $q['emp_codigo'].' '.$q['emp_nombre'].' '.$q['emp_apellido']:'';
			});
			$output = $crud->render();
   			$data['titulo_personal']="Gestión de vehículos";
			$this->_cargarvista($data,$output);

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} // End gestion_vehiculo

	public function registrar_vehiculo($id_vehiculo=0)
	{

		satelite_validar();
		
		$empleados_array=array();
					   $this->db->join('emp_empleado','emp_id=mot_empleado');
		$motorista_q = $this->gsatelite->get_tabla('mot_motorista', array('mot_estado'=>1));
		foreach ($motorista_q as $mot) {
			$empleados_array[$mot['mot_id']] = $mot['emp_codigo']. ' - ' . $mot['emp_nombre'].' '.$mot['emp_apellido'];
		}

		$fechaInicio = ($_POST && isset($_POST['txtFechaInicio']) && trim($_POST['txtFechaInicio']) != '')? formatear_fecha('Y-m-d',$_POST['txtFechaInicio']):date('Y-m-01');

		$fechaFin = ($_POST && isset($_POST['txtFechaFin']) && trim($_POST['txtFechaFin']) != '')? formatear_fecha('Y-m-d',$_POST['txtFechaFin']):date('Y-m-t');

		$whereVeh['rev_id_veh'] = $id_vehiculo;
		$whereVeh['rev_fecha >='] = $fechaInicio;
		$whereVeh['rev_fecha <='] = $fechaFin;
		
		try{
			$permisos= $this->gsatelite->get_permisos_opcion('gestion_vehiculo');
			$crud = new grocery_CRUD();
			$crud->unset_export();
			$crud->unset_print();
			$crud->unset_add();
			$crud->unset_edit();
			$crud->unset_read();
			$crud->set_table('rev_registro_vehiculo');
			$crud->set_subject('');
			
			$columns = array(
							'rev_fecha',
							'rev_km_final',
							'rev_id_mot',
							'rev_gps'
							);

			$edit_fields = array(
							'rev_fecha',
							'rev_km_inicial',
							'rev_km_final',
							'rev_km_recorridos',
							'lugares',
							'rev_id_mot',
							'rev_tanque_salida',
							'rev_tanque_regreso',
							'rev_estado',
							'rev_usu_modificacion',
							'rev_fecha_modificacion'
							);

			$display_as = array(
							'rev_id_mot' => 'Motorista',
							'rev_fecha'	 => 'Fecha',
							'rev_km_inicial' => 'Kilometraje inicial',
							'rev_km_final'	 => 'Kilometraje final',
							'rev_km_recorridos'  => 'Kms. recorridos',
							'lugares'			 => 'Lugares visitados',
							'rev_tanque_salida'  => 'Salida',
							'rev_tanque_regreso' => 'Regreso',
							'rev_estado'		 => 'Estado',
							'rev_gps'		 => 'Coordenas GPS'
							);

			$crud->field_type('rev_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
			$crud->where($whereVeh);
			$crud->set_relation_n_n('lugares','luv_lugarxvehiculo','mun_municipio','luv_id_rev','luv_id_mun','{mun_nombre}',null,null);
			$crud->columns($columns);
			$crud->edit_fields($edit_fields);
			$crud->display_as($display_as);
			$crud->field_type('rev_id_mot', 'dropdown', $empleados_array);
			$crud->callback_column('rev_gps', function($value, $row) {
				$lnk_mapa="";
				if (is_numeric($row->rev_latitud) && is_numeric($row->rev_longitud)) {
					
					$lat = $row->rev_latitud;
					$lng = $row->rev_longitud;
					$lnk_mapa = '<a class="lnk_mapa ver_en_modal"
					    data-fancybox
					    data-type="iframe"
					    src="https://www.google.com/maps/embed?pb=!1m14!1m12!1m3!1d1000!2d'.$lng.'!3d'.$lat.'!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!5e0!3m2!1ses!2ssv!4v'.time().'"
					    href="javascript:;">
					    Ver mapa
					</a>';


				}
			    return $lnk_mapa;
			});

			// Validaciones
		    if($permisos['permite_editar']) { 
		      $crud->add_action('Editar','icon16 icomoon-icon-pencil-5','transporte/procesos/editar_registro_vehiculo/'.$id_vehiculo);
		    }
		    if(!$permisos['permite_eliminar']) { $crud->unset_delete();} 
		    

			$output = $crud->render();
			$data['permisos'] = $permisos;
			$data['vehiculo_registro'] = $this->entradas_model->get_detalle_vehiculo($id_vehiculo);
			$data['titulo_personal']="Registro de vehículo";
	      	cargarvista_modal($data,$output);

		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} // End registrar vehiculo

	public function editar_registro_vehiculo($id_vehiculo=0, $id_registro=0)
	{
		satelite_validar();
		if($_POST){
			//die(print_r($_POST,true));

			$registro_vehiculo = array(
				'rev_id_mot' => $this->input->post('motorista'),
				'rev_fecha'	 => date('Y-m-d H:i:s',strtotime($_POST['fecha_registro'].date('H:i:s'))),
				'rev_km_inicial' 		=> ($this->input->post('km_inicial')>0)? $this->input->post('km_inicial'):null,
				'rev_km_final' 			=> ($this->input->post('km_final') > 0)? $this->input->post('km_final'):null,
				'rev_km_recorridos' 	=> ($this->input->post('km_recorridos') > 0)? $this->input->post('km_recorridos'):null,	
				'rev_tanque_salida'		=> (str_replace('%','', $_POST['tanque_salida']) > 0)? str_replace('%','', $_POST['tanque_salida']):null,
				'rev_tanque_regreso'	=> (str_replace('%','', $_POST['tanque_regreso']) > 0)? str_replace('%','', $_POST['tanque_regreso']):null,
				'rev_otros_lugares'		=> (!empty($_POST['otros_lugares']))? $_POST['otros_lugares']:null,
				'rev_latitud' 		=> is_numeric($this->input->post('txtLatitud'))? $this->input->post('txtLatitud'):null,
				'rev_longitud' 		=> is_numeric($this->input->post('txtLongitud'))? $this->input->post('txtLongitud'):null,

				'rev_estado'			=> $_POST['estado'],
				'rev_usu_modificacion'	=> $this->tank_auth->get_user_id(),
				'rev_fecha_modificacion'=> date('Y-m-d H:i:s')
				);
// Aca me he quedado
			$rev_id = $this->gsatelite->actualizar_array('rev_registro_vehiculo', $registro_vehiculo, array('rev_id'=>$_POST['id_rev']));

			if($rev_id>0){
				// Eliminar los lugares visitados anteriores
				 $this->gsatelite->borrado_general('luv_lugarxvehiculo',array('luv_id_rev'=>$_POST['id_rev']));

				// Ingresar los lugares visitados
				$lugares = $this->input->post('lugares_visitados');

				foreach ($lugares as $key => $value) {
					if ($value > 0) {
						$lugares_array = array(
							'luv_id_mun'	=> $value,
							'luv_id_rev'	=> $_POST['id_rev']
							);

						$this->gsatelite->ingresar('luv_lugarxvehiculo', $lugares_array);
					}
				}
				$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registro ingresado",'texto_alerta'=>"El registro se guardó correctamente");	
			} else {
				$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Error de inserción",'texto_alerta'=>"El registro no pudo guardarse");
			}	
			$this->session->set_flashdata($alerta);
			redirect('transporte/procesos/registrar_vehiculo/'.$_POST['id_vehiculo']);

		} else {
			// All your code goes here
	    	$data['vehiculo_registro'] 	= $this->entradas_model->get_detalle_vehiculo($id_vehiculo);
			$data['rev_datos']			= $this->gsatelite->get_registro('rev_registro_vehiculo', array('rev_id'=>$id_registro));
			//print_r($data['rev_datos']); die();
			$data['motorista']			= $this->gsatelite->get_dropdown_empleado('mot_motorista', '{mot_empleado}','', array('mot_estado' => '1'), $data['rev_datos']->rev_id_mot, '', 'mot_id', true);

		      $lugares = $this->gsatelite->get_tabla('luv_lugarxvehiculo',array('luv_id_rev'=>$data['rev_datos']->rev_id));
		      $seleccionados =array();
		      foreach ($lugares as $lugar) {  
		      	$seleccionados[] = $lugar['luv_id_mun'];  
		      }
		      $items = (count($seleccionados)>0)? $seleccionados:null;
		      $data['municipios'] = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}','', null, $items, '', 'mun_id', true);
		      //$data['municipios'] = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}','', array('mun_estado' => '1'), $items, '', 'mun_id', true);
			
			$data['titulo_personal']="Edición de recorrido de vehículo";
	      	cargarvista_modal($data,null);
		}
	}

	public function agregar_vehiculo($id_vehiculo=0)
	{
		satelite_validar();
		if($_POST){
			// Procesar el POST
			//die(print_r($_POST,true));
			$registro_vehiculo = array(
				'rev_id_veh' => $this->input->post('id_vehiculo'),
				'rev_id_mot' => $this->input->post('motorista'),
				'rev_fecha'	 => date('Y-m-d H:i:s',strtotime($_POST['fecha_registro'].date(' H:i:s'))),
				'rev_km_inicial' 		=> ($this->input->post('km_inicial')>0)? $this->input->post('km_inicial'):null,
				'rev_km_final' 			=> ($this->input->post('km_final')>0)? $this->input->post('km_final'):null,
				'rev_km_recorridos' 	=> ($this->input->post('km_recorridos')>0)? $this->input->post('km_recorridos'):null,	
				'rev_tanque_salida'		=> (str_replace('%','', $_POST['tanque_salida']) > 0)? str_replace('%','', $_POST['tanque_salida']):null,
				'rev_tanque_regreso'	=> (str_replace('%','', $_POST['tanque_regreso']) > 0)? str_replace('%','', $_POST['tanque_regreso']):null,
				'rev_otros_lugares'		=> (!empty($_POST['otros_lugares']))? $_POST['otros_lugares']:null,
				'rev_latitud' 		=> is_numeric($this->input->post('txtLatitud'))? $this->input->post('txtLatitud'):null,
				'rev_longitud' 		=> is_numeric($this->input->post('txtLongitud'))? $this->input->post('txtLongitud'):null,
				'rev_estado'			=> 1,
				'rev_usu_creacion'		=> $this->tank_auth->get_user_id(),
				'rev_usu_modificacion'	=> $this->tank_auth->get_user_id(),
				'rev_fecha_creacion'	=> date('Y-m-d H:i:s'),
				'rev_fecha_modificacion'=> date('Y-m-d H:i:s')
				);

			$rev_id = $this->gsatelite->ingresar('rev_registro_vehiculo', $registro_vehiculo);

			if($rev_id>0){
				// Ingresar los lugares visitados
				$lugares = $this->input->post('lugares_visitados');

				foreach ($lugares as $key => $value) {
					if ($rev_id > 0) {
						$lugares_array = array(
							'luv_id_mun'	=> $value,
							'luv_id_rev'	=> $rev_id
							);

						$this->gsatelite->ingresar('luv_lugarxvehiculo', $lugares_array);
					}
				}
				$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registro ingresado",'texto_alerta'=>"El registro se guardó correctamente");	
			} else {
				$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Error de inserción",'texto_alerta'=>"El registro no pudo guardarse");
			}	
			$this->session->set_flashdata($alerta);
			redirect('transporte/procesos/registrar_vehiculo/'.$_POST['id_vehiculo']);
			// Fin del POST
		} else {
			// Cuando se le da click al boton Agregar

			$data['vehiculo_registro'] 	= $this->entradas_model->get_detalle_vehiculo($id_vehiculo);
			//$data['municipios'] 		= $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}','', array('mun_estado' => '1'), null, '', 'mun_id', true);
			$data['municipios'] 		= $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}','', null, null, '', 'mun_id', true);
			//$data['motorista']			= $this->gsatelite->get_dropdown('mot_motorista', '{mot_empleado}','', array('mot_estado' => '1'), null, '', 'mot_id', true);
			$data['motorista'] = $this->gsatelite->get_dropdown_empleado('mot_motorista', '{mot_empleado}','', array('mot_estado' => '1'), null, '', 'mot_id', true);
			$data['titulo_personal']="Recorrido de vehículo";
			cargarvista_modal($data);
		}
	} // End agregar vehiculo


	public function asignar_vehiculo($id_vehiculo=0)
	{

		satelite_validar();
		$empleados_array=array();
					   $this->db->join('emp_empleado','emp_id=mot_empleado');
		$motorista_q = $this->gsatelite->get_tabla('mot_motorista', array('mot_estado'=>1));
		foreach ($motorista_q as $mot) {
			$empleados_array[$mot['mot_id']] = $mot['emp_codigo']. ' - ' . $mot['emp_nombre'].' '.$mot['emp_apellido'];
		}

		if ($id_vehiculo > 0) {
						   $this->db->order_by('asv_fecha','DESC');
						   $this->db->order_by('asv_id','DESC');
						   $this->db->limit(1);
			$q_activa = $this->gsatelite->get_tabla('asv_asignacion_vehiculo', array('asv_estado'=>1,'asv_id_veh'=>$id_vehiculo));
			if ($q_activa) {
				$this->gsatelite->actualizar_array('asv_asignacion_vehiculo',array('asv_estado'=>0),array('asv_estado'=>1,'asv_id_veh'=>$id_vehiculo,'asv_id !='=>$q_activa[0]['asv_id']));
			}
		}

		$fechaInicio = ($_POST && isset($_POST['txtFechaInicio']) && trim($_POST['txtFechaInicio']) != '')? formatear_fecha('Y-m-d',$_POST['txtFechaInicio']):'';

		$fechaFin = ($_POST && isset($_POST['txtFechaFin']) && trim($_POST['txtFechaFin']) != '')? formatear_fecha('Y-m-d',$_POST['txtFechaFin']):'';

		$motoristaID = ($_POST && isset($_POST['slcMotorista']) && $_POST['slcMotorista'] > 0)? $_POST['slcMotorista']:null;

		$data['motorista_option'] = $this->gsatelite->get_dropdown_empleado('mot_motorista', '{mot_empleado}','', array('mot_estado' => '1'), $motoristaID, '', 'mot_id', true);
		
		$whereFiltro['asv_id_veh'] = $id_vehiculo;
		if($fechaInicio != '')
			$whereFiltro['asv_fecha >='] = $fechaInicio;
		if($fechaFin != '')
			$whereFiltro['asv_fecha <='] = $fechaFin;
		if($motoristaID > 0)
			$whereFiltro['asv_id_mot'] = $motoristaID;

		try{
			$permisos= $this->gsatelite->get_permisos_opcion('gestion_vehiculo');
			$crud = new grocery_CRUD();
			$data['statusCRUD'] = $crud->getState();
			//$crud->unset_export();
			//$crud->unset_print();
			$crud->set_table('asv_asignacion_vehiculo');
			$crud->set_subject('');
			
			$columns = array(
							'asv_fecha',
							'asv_fecha_contrato',
							'asv_id_mot',
							'asv_deposito',
							'asv_cuota',
							'asv_observacion',
							'asv_estado'
							);

			$add_fields = array(
							'asv_id_veh',
							'asv_id_uni',
							'asv_id_mot',
							'asv_fecha',
							'asv_fecha_contrato',
							'asv_deposito',
							'asv_cuota',
							'asv_observacion',
							'asv_estado',
							'asv_usu_modificacion',
							'asv_usu_creacion',
							'asv_fecha_modificacion',
							'asv_fecha_creacion'
				);

			$edit_fields = array(
							'asv_id_uni',
							'asv_id_mot',
							'asv_fecha',
							'asv_fecha_contrato',
							'asv_deposito',
							'asv_cuota',
							'asv_observacion',
							'asv_estado',
							'asv_usu_modificacion',
							'asv_fecha_modificacion'
							);

			$display_as = array(
							'asv_id_uni'		=> 'Unidad',
							'asv_id_mot'		=> 'Motorista',
							'asv_fecha'			=> 'Fecha Inicio',
							'asv_estado'		=> 'Estado',
							'asv_fecha_contrato'=> 'Fecha Fin',
							'asv_deposito'		=> 'Deposito',
							'asv_cuota'			=> 'Cuota',
							'asv_observacion'	=> 'Observación',
							);

			$crud->field_type('asv_id_veh', 'hidden', $id_vehiculo);
			$crud->field_type('asv_usu_creacion', 'hidden');
			$crud->field_type('asv_usu_modificacion', 'hidden');
			$crud->field_type('asv_fecha_creacion', 'hidden');
			$crud->field_type('asv_fecha_modificacion', 'hidden');	
			
			$crud->required_fields('asv_id_unidad', 'asv_id_mot', 'asv_estado', 'asv_fecha');
			$crud->where($whereFiltro);
			$crud->field_type('asv_id_mot', 'dropdown', $empleados_array);
			$crud->set_relation('asv_id_uni','uni_unidad','uni_nombre', array('uni_estado' => 1));

			$crud->columns($columns);
			$crud->add_fields($add_fields);
			$crud->edit_fields($edit_fields);
			$crud->display_as($display_as);
			$crud->callback_before_insert(array($this, '_log_usuario_insert'));
    		$crud->callback_before_update(array($this, '_log_usuario_update'));

			// Validaciones
			if(!$permisos['permite_agregar']) { $crud->unset_add();} 
			if(!$permisos['permite_editar']) { $crud->unset_edit();}
			if(!$permisos['permite_eliminar']) { $crud->unset_delete();} 
			if($permisos['permite_ver']) {
			  $crud->add_action('Ver','minia-icon-search',uri_string().'/read');
			}
			if (end(explode('/', uri_string())) == 'add') {
			    $crud->field_type('asv_estado', 'hidden', 1);
			} else {
				$crud->field_type('asv_estado', 'dropdown', array('4' => 'Cerrado', '3' => 'Abierto', '2' => 'Sin asignar', '1' => 'Asignado', '0' => 'Fuera de servicio'));
			}

			$output = $crud->render();

			$data['permisos'] = $permisos;
			$data['vehiculo_registro'] = $this->entradas_model->get_detalle_vehiculo($id_vehiculo);
			$data['titulo_personal']="Asignación de vehículo";
	      	cargarvista_modal($data,$output);

		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} // End asignar vehiculo

	public function recepcion_vehiculo($id_vehiculo = 0)
	{
		satelite_validar();
		$permisos= $this->gsatelite->get_permisos_opcion('gestion_vehiculo');

		try{

			$crud = new grocery_CRUD();
			$crud->unset_export();
			$crud->unset_print();
			$crud->unset_add();
			$crud->unset_edit();

			$crud->set_table('rec_recepcion_vehiculo');
			$crud->set_subject('');
			
			$columnas = array(
							'rec_fecha',
							'rec_id_tir',
							'rec_estado'
							);

			$display_as = array(
							'rec_fecha'		=> 'Fecha',
							'rec_id_tir'	=> 'Tipo',
							'rec_estado'	=> 'Estado'
							);

			$crud->field_type('rec_estado', 'dropdown', array('2' => 'Entregado','1' => 'Recibido', '0' => 'Inactivo'));
			$crud->set_relation('rec_id_tir','tir_tipo_recepcion_veh','tir_nombre', array('tir_estado' => 1));
			$crud->where('rec_id_veh',$id_vehiculo);

			$crud->columns($columnas);
			$crud->display_as($display_as);

			// Validaciones
		    if($permisos['permite_editar']) { 
		      $crud->add_action('Editar','icon16 icomoon-icon-pencil-5','transporte/procesos/editar_recepcion_vehiculo/'.$id_vehiculo);
		    }
		    if(!$permisos['permite_eliminar']) { $crud->unset_delete();} 
		    if($permisos['permite_ver']) {
		 //     $crud->add_action('Ver','minia-icon-search',uri_string().'/read');
		    }  

		    // Imprimir reporte
		    $crud->add_action('Imprimir','icomoon-icon-printer','transporte/reportes/imprimir_recepcion_vehiculo/'.$id_vehiculo);

		    $crud->callback_column('rec_estado',array($this,'_callback_reporte'));

			$output = $crud->render(); 
			$data['permisos'] = $permisos;
			$data['vehiculo_registro'] = $this->entradas_model->get_detalle_vehiculo($id_vehiculo);
   			$data['titulo_personal']="Recepción/Entrega de vehículo";

			cargarvista_modal($data,$output);

		} catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} // End recepcion vehiculo

	public function _callback_reporte($value, $row)
	{
	 
	 if($value==2){
	 	return "Entregado";	
	 }  else if($value==1) {
	 	return "<span class='no_imprime'>Recibido</span>";
	 } else {
	 	return "<span class='no_imprime'>Inactivo</span>";
	 }
	 
	}
 

	public function agregar_recepcion_vehiculo($id_vehiculo=0)
	{
		satelite_validar();
		if($_POST){
			
			$rec_array = array(
				'rec_id_veh'	=> $_POST['id_vehiculo'],
				'rec_id_tir'	=> (!empty($_POST['tipo_recepcion']))? $_POST['tipo_recepcion']:null,
				'rec_fecha'		=> date('Y-m-d',strtotime($_POST['fecha_registro'])),
				'rec_kilometraje'	=> ($_POST['kilometraje']>0)? $_POST['kilometraje']: 0,
				'rec_tanque'		=> (!empty($_POST['tanque_condicion']))? $_POST['tanque_condicion']:0,
				'rec_observacion'	=> (!empty($_POST['observacion']))? $_POST['observacion']:null,
				'rec_user_recibe'	=> !empty($_POST['persona_recibe'])? $_POST['persona_recibe']:null, // Pendiente, sera un  WS el que lo determine
				'rec_user_entrega'	=> !empty($_POST['persona_entrega'])? $_POST['persona_entrega']:null, // Pendiente, sera un  WS el que lo determine
				'rec_tipo'			=> 1, //1=Recepcion, 2=Entrega
				'rec_estado'		=> $_POST['estado'],
				'rec_otros_recibe'	=> $this->input->post('otros_recibe'),
				'rec_otros_entrega'	=> $this->input->post('otros_entrega'),
				'rec_usu_creacion'	=> $this->tank_auth->get_user_id(),
				'rec_usu_modificacion'	=> $this->tank_auth->get_user_id(),
				'rec_fecha_creacion'	=> date('Y-m-d H:i:s'),
				'rec_fecha_modificacion'=> date('Y-m-d H:i:s')
				);

			$rec_id = $this->gsatelite->ingresar('rec_recepcion_vehiculo', $rec_array);

			if($rec_id>0){
				$tools = $_POST['herramientas'];
				$estados = $_POST['condicion_tool'];

				if(!empty($tools) && count($tools) == count($estados)){
					foreach ($tools as $key => $value) {
					$detalle_array = array(
						'dxr_id_rec'	=> $rec_id,	
						'dxr_id_hev'	=> $value,
						'dxr_estado'	=> $estados[$key]
						);		

					$this->gsatelite->ingresar('dxr_detallexrecepcion', $detalle_array);	
					}
				}
			}

			if($rec_id > 0){
			    $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registro ingresado",'texto_alerta'=>"El registro se guardó correctamente.");  
			} else {
			    $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error",'texto_alerta'=>"El registro no se guardó.");  
			}
			  
			$this->session->set_flashdata($alerta);      
			redirect('/transporte/procesos/recepcion_vehiculo/'.$_POST['id_vehiculo']);
		} else {
			// Cuando se le da click al boton Agregar
			$data['vehiculo_registro'] 	= $this->entradas_model->get_detalle_vehiculo($id_vehiculo);
			$data['tipo_recepcion'] 	= $this->gsatelite->get_dropdown('tir_tipo_recepcion_veh', '{tir_nombre}','', array('tir_estado' => '1'), null, '', 'tir_id', true);
			$data['tools']				= $this->gsatelite->get_dropdown('hev_herramienta_vehiculo', '{hev_nombre}','', array('hev_estado' => '1'), null, '', 'hev_id', true);
			
			$data['recibe']=$this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}','', array('emp_estado'=>'1'), null, '', 'emp_id', true);
			$data['entrega']=$this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}','', array('emp_estado'=>'1'), null, '', 'emp_id', true);


			$data['titulo_personal'] = "Recepción/Entrega de vehículos";
			//$this->_cargarvista($data,null, 'gestion_vehiculo');
			cargarvista_modal($data);
		}
	}

	public function editar_recepcion_vehiculo($id_vehiculo=0, $id_registro=0)
	{
		satelite_validar();
		if($_POST){
			if($_POST['es_entrega']==1){
			$rec_array = array(
				'rec_fecha'		=> date('Y-m-d',strtotime($_POST['fecha_registro2'])),
				'rec_kilometraje'	=> ($_POST['kilometraje2']>0)? $_POST['kilometraje2']: 0,
				'rec_tanque'		=> (!empty($_POST['tanque_condicion2']))? $_POST['tanque_condicion2']:0,
				'rec_observacion'	=> (!empty($_POST['observacion2']))? $_POST['observacion2']:null,
				'rec_user_recibe'	=> !empty($_POST['persona_recibe2'])? $_POST['persona_recibe2']:null, // Pendiente, sera un  WS el que lo determine
				'rec_user_entrega'	=> !empty($_POST['persona_entrega2'])? $_POST['persona_entrega2']:null, // Pendiente, sera un  WS el que lo determine
				'rec_tipo'			=> 2, //1=Recepcion, 2=Entrega
				'rec_estado'		=> $_POST['estado2'],
				'rec_usu_creacion'	=> $this->tank_auth->get_user_id(),
				'rec_usu_modificacion'	=> $this->tank_auth->get_user_id(),
				'rec_fecha_creacion'	=> date('Y-m-d H:i:s'),
				'rec_fecha_modificacion'=> date('Y-m-d H:i:s')
				);

			$rec_id = $this->gsatelite->actualizar_array('rec_recepcion_vehiculo', $rec_array, array('rec_id'=>$_POST['rec_id']));

			if($rec_id>0){
				$tools = $_POST['herramientas2'];
				$estados = $_POST['condicion_tool2'];

				// Eliminar registros anteriores
				$this->gsatelite->borrado_general('dxr_detallexrecepcion', array('dxr_id_rec'=>$_POST['rec_id']));

				if(!empty($tools) && count($tools) == count($estados)){

					// Insertamos los nuevos valores
					foreach ($tools as $key => $value) {
					$detalle_array = array(
						'dxr_id_rec'	=> $_POST['rec_id'],	
						'dxr_id_hev'	=> $value,
						'dxr_estado'	=> $estados[$key]
						);		

					$this->gsatelite->ingresar('dxr_detallexrecepcion', $detalle_array);	
					}
				}
			}

			if($rec_id > 0){
			    $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registro ingresado",'texto_alerta'=>"El registro se editó correctamente.");  
			} else {
			    $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error",'texto_alerta'=>"El registro no se guardó.");  
			}
			  
			$this->session->set_flashdata($alerta);      
			redirect('/transporte/procesos/recepcion_vehiculo/'.$_POST['id_vehiculo']);
		} // End de edicion de entrega
		else {

			$rec_array = array(
				'rec_id_tir'	=> (!empty($_POST['tipo_recepcion']))? $_POST['tipo_recepcion']:null,
				'rec_fecha'		=> date('Y-m-d',strtotime($_POST['fecha_registro'])),
				'rec_kilometraje'	=> ($_POST['kilometraje']>0)? $_POST['kilometraje']: 0,
				'rec_tanque'		=> (!empty($_POST['tanque_condicion']))? $_POST['tanque_condicion']:0,
				'rec_observacion'	=> (!empty($_POST['observacion']))? $_POST['observacion']:null,
				'rec_user_recibe'	=> !empty($_POST['persona_recibe'])? $_POST['persona_recibe']:null, // Pendiente, sera un  WS el que lo determine
				'rec_user_entrega'	=> !empty($_POST['persona_entrega'])? $_POST['persona_entrega']:null, // Pendiente, sera un  WS el que lo determine
				'rec_tipo'			=> 1, //1=Recepcion, 2=Entrega
				'rec_estado'		=> $_POST['estado'],
				'rec_usu_creacion'	=> $this->tank_auth->get_user_id(),
				'rec_usu_modificacion'	=> $this->tank_auth->get_user_id(),
				'rec_fecha_creacion'	=> date('Y-m-d H:i:s'),
				'rec_fecha_modificacion'=> date('Y-m-d H:i:s')
				);

			$rec_id = $this->gsatelite->actualizar_array('rec_recepcion_vehiculo', $rec_array, array('rec_id'=>$_POST['rec_id']));

			if($rec_id>0){
				$tools = $_POST['herramientas'];
				$estados = $_POST['condicion_tool'];

				// Eliminar registros anteriores
				$this->gsatelite->borrado_general('dxr_detallexrecepcion', array('dxr_id_rec'=>$_POST['rec_id']));

				if(!empty($tools) && count($tools) == count($estados)){
					foreach ($tools as $key => $value) {
					$detalle_array = array(
						'dxr_id_rec'	=> $_POST['rec_id'],	
						'dxr_id_hev'	=> $value,
						'dxr_estado'	=> $estados[$key]
						);		

					$this->gsatelite->ingresar('dxr_detallexrecepcion', $detalle_array);	
					}
				}
			}

			if($rec_id > 0){
			    $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registro ingresado",'texto_alerta'=>"El registro se editó correctamente.");  
			} else {
			    $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error",'texto_alerta'=>"El registro no se guardó.");  
			}
			  
			$this->session->set_flashdata($alerta);      
			redirect('/transporte/procesos/recepcion_vehiculo/'.$_POST['id_vehiculo']);	
	  }	// End de edicion de Recepcion

		} else {
			// All your querys goes here
			$data['vehiculo_registro'] 	= $this->entradas_model->get_detalle_vehiculo($id_vehiculo);
			$data['rec_datos']			= $this->gsatelite->get_registro('rec_recepcion_vehiculo', array('rec_id'=>$id_registro));
			$data['tipo_recepcion']		= $this->gsatelite->get_dropdown('tir_tipo_recepcion_veh', '{tir_nombre}','', array('tir_estado' => '1'), (!empty($data['rec_datos']->rec_id_tir))? $data['rec_datos']->rec_id_tir:null, '', 'tir_id', true);
			$data['tools']				= $this->gsatelite->get_dropdown('hev_herramienta_vehiculo', '{hev_nombre}','', array('hev_estado' => '1'), null, '', 'hev_id', true);	
			$this->db->join('hev_herramienta_vehiculo', 'hev_id = dxr_id_hev');
			$datos['detalles']			= $this->gsatelite->get_tabla('dxr_detallexrecepcion', array('dxr_id_rec'=>$id_registro));
			$datos['id_tabla']		= ($data['rec_datos']->rec_tipo==2)? '2':'';
			$data['dxr_detalles']	    = $this->load->view('transporte/procesos/detalle_herramientas_tabla', $datos, true);

			//print_r($data['rec_datos']); die();

			$data['recibe']=$this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}','', array('emp_estado'=>'1'), $data['rec_datos']->rec_user_recibe, '', 'emp_id', true);
			$data['entrega']=$this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}','', array('emp_estado'=>'1'), $data['rec_datos']->rec_user_entrega, '', 'emp_id', true);

			$data['titulo_personal']="Edición de recepción/entrega de vehículos";
	      	cargarvista_modal($data);
		}
	 } 

	public function agregar_entrega_vehiculo()
	{

		satelite_validar();
		if($_POST){
			//die(print_r($_POST,true));
			$rec_array = array(
				'rec_id_veh'	=> $_POST['id_vehiculo'],
				'rec_fecha'		=> date('Y-m-d',strtotime($_POST['fecha_registro2'])),
				'rec_kilometraje'	=> ($_POST['kilometraje2']>0)? $_POST['kilometraje2']: 0,
				'rec_tanque'		=> (!empty($_POST['tanque_condicion2']))? $_POST['tanque_condicion2']:0,
				'rec_observacion'	=> (!empty($_POST['observacion2']))? $_POST['observacion2']:null,
				'rec_user_recibe'	=> $_POST['persona_recibe2'], // Pendiente, sera un  WS el que lo determine
				'rec_user_entrega'	=> $_POST['persona_entrega2'], // Pendiente, sera un  WS el que lo determine
				'rec_tipo'			=> 2, //1=Recepcion, 2=Entrega
				'rec_estado'		=> $_POST['estado2'],
				'rec_otros_recibe'	=> $this->input->post('otros_recibe2'),
				'rec_otros_entrega'	=> $this->input->post('otros_entrega2'),
				'rec_usu_creacion'	=> $this->tank_auth->get_user_id(),
				'rec_usu_modificacion'	=> $this->tank_auth->get_user_id(),
				'rec_fecha_creacion'	=> date('Y-m-d H:i:s'),
				'rec_fecha_modificacion'=> date('Y-m-d H:i:s')
				);

			$rec_id = $this->gsatelite->ingresar('rec_recepcion_vehiculo', $rec_array);

			if($rec_id>0){
				$tools = $_POST['herramientas2'];
				$estados = $_POST['condicion_tool2'];

				if(!empty($tools) && count($tools) == count($estados)){
					foreach ($tools as $key => $value) {
					$detalle_array = array(
						'dxr_id_rec'	=> $rec_id,	
						'dxr_id_hev'	=> $value,
						'dxr_estado'	=> $estados[$key]
						);		

					$this->gsatelite->ingresar('dxr_detallexrecepcion', $detalle_array);	
					}	
				}
			}

			if($rec_id > 0){
			    $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registro ingresado",'texto_alerta'=>"El registro se guardó correctamente.");  
			} else {
			    $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error",'texto_alerta'=>"El registro no se guardó.");  
			}
			  
			$this->session->set_flashdata($alerta);      
			redirect('/transporte/procesos/recepcion_vehiculo/'.$_POST['id_vehiculo']);
		}
	} // End agregar entrada vehiculo



   /*
	* Edith Herrera
	*/
public function solicitud_transporte($consulta=null)
	{
		satelite_validar();
		
			$permisos= $this->gsatelite->get_permisos_opcion('solicitud_transporte');
			
			$data['permisos']=$permisos;				
			$data['listado']=$this->entradas_model->get_detalle_solicitud();

			if($consulta){
		 		if($this->input->post()){
		 			$fecha_ini = date("Y-m-d",strtotime($this->input->post('fecha_ini'))) ;
		 			$fecha_fin = date("Y-m-d",strtotime($this->input->post('fecha_fin'))) ;
		 			$where=array('dtt_fecha_salida >='=>$fecha_ini,'dtt_fecha_salida <='=>$fecha_fin);
		 			$data['registros'] = $this->entradas_model->get_detalle_solicitud($fecha_ini,$fecha_fin);
		 			$html = $this->load->view('transporte/procesos/detalle_solicitud_transporte', $data, true);
		 			echo $html;

		 		}
		 		die();
	 		}
			$data['titulo_personal']="Solicitud de servicio de transporte";
			$this->_cargarvista($data);
	}

   /*
	* Edith Herrera
	*/
	public function crear_solicitud()
	{
		satelite_validar();
					
			$data['listado']=$this->gsatelite->get_tabla('dtt_detalle_ticket_trans');
			$data['vehiculos'] = $this->gsatelite->get_dropdown('tvh_tipo_vehiculo', '{tvh_nombre}','', array('tvh_estado' => '1'), null, '', 'tvh_id', true);
			$data['destinos']=$this->gsatelite->get_dropdown('ubt_ubicacion_tarea', '{ubt_nombre}','', array('ubt_estado' => '1'), null, '', 'ubt_id', true);
			$data['estados'] = $this->gsatelite->get_dropdown('esk_estado_ticket', '{esk_nombre}','', array('esk_estado' => '1'), array('esk_id'=>2), '', 'esk_id', true);
			$data['medios_recepcion'] = $this->gsatelite->get_dropdown('mrc_medio_recepcion', '{mrc_nombre}','', array('mrc_estado' => '1'), null, '', 'mrc_id', true);	
			$data['select_encargado']=$this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}','', array('emp_estado'=>'1'), null, '', 'emp_id', true);
			//$data['select_encargado']=$this->gsatelite->get_dropdown_empleado('mot_motorista', '{mot_empleado}','', array('mot_estado' => '1'), null, '', 'mot_id', true);
			//$data['select_acompanante']=$this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}','', array('emp_estado'=>'1'), null, '', 'emp_id', true);

			$data['titulo_personal']="Creación de solicitud de transporte";
			$this->_cargarvista($data);	
	}

	public function cargar_acompaniante()
	{
		$emp_id = $this->input->post('emp_id');
		
		$data = array('');
		if($emp_id!=0){
			$data = $this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}','','emp_id != '.$emp_id, null, '', 'emp_id', true);
		}
		
		echo json_encode(array('drop'=>$data));
	}

   /*
	* Edith Herrera
	*/
	public function guardar_solicitud()
	{
		satelite_validar();
		if($_POST){
		//	die(print_r($_POST,true));
		$id_esk=$this->gsatelite->get_parametro('ID_ESTADO_TICKET');
			
		$solicitud_tkt=array(
			// 'tkt_id_prd'=> , //Prioridad
			// 'tkt_id_esk'=> , //Estado del tickets
			// 'tkt_id_flu'=> , //flujo
			// 'tkt_id_sue'=> , //Sub-especialidad
		    'tkt_requerimiento'=>$this->input->post('actividad_des'),//requerimiento
		    'tkt_descripcion'=>$this->input->post('descripcion'),//descripcion
		    'tkt_id_esk'=>$id_esk,//($this->input->post('estado'))?$this->input->post('estado'):null, //Estado del tickets
		    'tkt_estado'=>1, //estado
		    'tkt_id_mrc'=>  3,//!(empty($_POST['medio']))? $this->input->post('medio'): null,
		    'tkt_usu_creacion'=>$this->tank_auth->get_user_id(),
		    'tkt_usu_modificacion'=>$this->tank_auth->get_user_id(),
		    'tkt_fecha_creacion'=>date('Y-m-d H:i:s'),
		    'tkt_fecha_modificacion'=>date('Y-m-d H:i:s'),
		    'tkt_usuario_solicita'=>$this->tank_auth->get_user_id()
		);

		$ingresar_solicitud=$this->gsatelite->ingresar('tkt_ticket', $solicitud_tkt);

		$fecha=$this->input->post('fecha');
		$f_salida=date('Y-m-d', strtotime($fecha));

		$salida=date('H:i:s', strtotime($this->input->post('hora')));

		$solicitud_dtt=array(
			'dtt_id_tkt'=>$ingresar_solicitud,
			'dtt_fecha_modificacion'=>date('Y-m-d H:i:s'),
			'dtt_fecha_salida'=>$f_salida,
			'dtt_hora_salida'=>$salida,
			'dtt_cantidad_per'=>$this->input->post('personas'),
			'dtt_encargado'=>($this->input->post('encargado')>0)? $this->input->post('encargado'):null,
			'dtt_otro_encargado'=>$this->input->post('otro_encargado'),
			'dtt_acompanante'=> ($this->input->post('acompaniante')>0)? $this->input->post('acompaniante'):null,
			'dtt_otro_acompanante'=> (trim($_POST['otro_acompaniante'])!='')? $_POST['otro_acompaniante']:null,
			'dtt_num_contacto'=>$this->input->post('contacto'),
			'dtt_descripcion'=>$this->input->post('descripcion'),// igual a tkt?
			'dtt_actividad'=>($this->input->post('actividad_des'))?$this->input->post('actividad_des'):'',
			'dtt_id_tvh'=>$this->input->post('vehiculo'),
			'dtt_estado'=>1,
			'dtt_usu_creacion'=>$this->tank_auth->get_user_id(),
			'dtt_usu_modificacion'=>$this->tank_auth->get_user_id(),
			'dtt_fecha_creacion'=>date('Y-m-d H:i:s'),
		);
		$ingresar_detalle=$this->gsatelite->ingresar('dtt_detalle_ticket_trans', $solicitud_dtt);

		$ubicaciones=$this->input->post('destino');

		for ($i=0; $i <count($ubicaciones) ; $i++) { 
			if($ubicaciones[$i]>0){
				$ubicaxticket=array(
					'uxt_id_ubt'=>$ubicaciones[$i],
					'uxt_id_dtt'=>$ingresar_detalle,
					'uxt_estado'=> 1,
					'uxt_usu_creacion'=>$this->tank_auth->get_user_id(),
					'uxt_usu_modificacion'=>$this->tank_auth->get_user_id(),
					'uxt_fecha_creacion'=>date('Y-m-d H:i:s'),
					'uxt_fecha_modificacion'=>date('Y-m-d H:i:s')
				);
			$uxt=$this->gsatelite->ingresar('uxt_ubicaxticket',$ubicaxticket);
			}
		}

			// Guardar los Anexos
			$rutas 		= $this->input->post("ruta");
			$carpeta 	= $this->input->post("nombreCarpeta");

			if (count($rutas) > 0) {
				$carpeta = $carpeta;
				for ($i = 0; $i < count($rutas); $i++) {
					if ($rutas[$i] != "") {
						$img = $rutas[$i];
						$titulo = $this->input->post("titulo_doc" . $i);
						//die(print_r($img.'/'.$carpeta.'/'.$titulo.'/'.$ingresar_solicitud));
						$this->datos_imagen_gral($img,$carpeta,$titulo,$ingresar_solicitud);
					}
				}
			} // End guardar anexos


		if($ingresar_solicitud>0){
			$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Ingreso de solicitud",'texto_alerta'=>"El registro se guardó correctamente.");  
		} else {
			$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Ingreso de solicitud",'texto_alerta'=>"El registro no se guardó.");  
		}
		$this->session->set_flashdata($alerta); 

		$boton=$this->input->post('tipo_btn');
		if ($boton==1) {
			redirect('/transporte/procesos/crear_solicitud');
		}else if($boton==2){
			redirect('/transporte/procesos/solicitud_transporte');
		}
	  } // End IF POST
	}


	 /*
	* Edith Herrera
	*/
	public function editar_solicitud($id_soli)
	{
		satelite_validar();
					
			$data['listado']=$this->gsatelite->get_tabla('dtt_detalle_ticket_trans');
			$data['destinos']=$this->entradas_model->get_ubicacion($id_soli);
			$data['registros'] = $this->entradas_model->get_detalle_ticket(null,null,$id_soli);
			
			$data['anexos']= $this->entradas_model->get_anexos($id_soli);
			$data['medios_recepcion'] = $this->gsatelite->get_dropdown('mrc_medio_recepcion', '{mrc_nombre}','', array('mrc_estado' => '1'), !empty($data['registros'][0]['tkt_id_mrc'])? $data['registros'][0]['tkt_id_mrc']:null , '', 'mrc_id', true);	
			$data['select_encargado']=$this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}','', array('emp_estado'=>'1'), $data['registros'][0]['dtt_encargado'], '', 'emp_id', true);
			$data['select_acompanante']=$this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}','', array('emp_estado'=>'1'), $data['registros'][0]['dtt_acompanante'], '', 'emp_id', true);
			$data['estados'] = $this->gsatelite->get_dropdown('esk_estado_ticket', '{esk_nombre}','', array('esk_estado' => '1'), (!empty($data['registros'][0]['tkt_id_esk']))? $data['registros'][0]['tkt_id_esk']:null, '', 'esk_id', true);
			//die(print_r($data['anexo']));

			$data['titulo_personal']="Modificación de solicitudes de transporte";
			$this->_cargarvista($data);	
	}


	/*
	* Edith Herrera
	*/
	public function actualizar_solicitud()
	{
		satelite_validar();
		$id_esk=$this->gsatelite->get_parametro('ID_ESTADO_TICKET');

		$solicitud_tkt=array(
			// 'tkt_id_prd'=> , //Prioridad
			// 'tkt_id_esk'=> , //Estado del tickets
			// 'tkt_id_flu'=> , //flujo
			// 'tkt_id_sue'=> , //Sub-especialidad
		    'tkt_requerimiento'=>$this->input->post('actividad_des'),//requerimiento
		    'tkt_descripcion'=>$this->input->post('descripcion'),//descripcion
		    'tkt_id_esk'=>$id_esk, //Estado del tickets
		    'tkt_estado'=>1, //estado
		    'tkt_id_mrc'=> 3,//!(empty($_POST['medio']))? $this->input->post('medio'): null,
		    'tkt_usu_creacion'=>$this->input->post('usu_creacion'),
		    'tkt_usu_modificacion'=>$this->tank_auth->get_user_id(),
		    'tkt_fecha_creacion'=>$this->input->post('fec_creacion'),
		    'tkt_fecha_modificacion'=>date('Y-m-d H:i:s'),
		    'tkt_usuario_solicita'=>$this->tank_auth->get_user_id()
		);
		$id=$this->input->post('solicitud_id');
		$solicitud=$this->db->where('tkt_id',$id)->update('tkt_ticket',$solicitud_tkt);

		$salida=date('H:i:s', strtotime($this->input->post('hora')));

		$fecha=$this->input->post('fecha');
		$fec_salida=date('Y-m-d', strtotime($fecha));

		$solicitud_dtt=array(
			'dtt_id_tkt'=>$this->input->post('solicitud_id'),
			'dtt_fecha_modificacion'=>date('Y-m-d H:i:s'),
			'dtt_fecha_salida'=>$fec_salida,
			'dtt_hora_salida'=>$salida,
			'dtt_cantidad_per'=>$this->input->post('personas'),
			'dtt_num_contacto'=>$this->input->post('contacto'),
			'dtt_encargado'=>$this->input->post('encargado'),
			'dtt_otro_encargado'=>$this->input->post('otro_encargado'),
			'dtt_acompanante'=> (!empty($_POST['acompaniante']) && $_POST['acompaniante']>0)? $_POST['acompaniante']:null,
			'dtt_otro_acompanante'=> (!empty($_POST['otro_acompaniante']))? $_POST['otro_acompaniante']:null,
			'dtt_descripcion'=>$this->input->post('descripcion'),// igual a tkt?
			'dtt_actividad'=>$this->input->post('actividad_des'),
			'dtt_id_tvh'=>$this->input->post('vehiculo'),
			'dtt_estado'=>1,
			'dtt_usu_creacion'=>$this->input->post('det_usu_creacion'),
			'dtt_usu_modificacion'=>$this->tank_auth->get_user_id(),
			'dtt_fecha_creacion'=>$this->input->post('det_creacion'),
		);
		$id_detalle=$this->input->post('detalle');
		$detalle=$this->db->where('dtt_id',$id_detalle)->update('dtt_detalle_ticket_trans',$solicitud_dtt);
		
		$this->db->where('uxt_id_dtt', $id_detalle);
  		$this->db->delete('uxt_ubicaxticket');
		
		$ubicaciones=$this->input->post('destino');

		for ($i=0; $i <count($ubicaciones) ; $i++) { 
			if($ubicaciones[$i]>0){
				$ubicaxticket=array(
					'uxt_id_ubt'=>$ubicaciones[$i],
					'uxt_id_dtt'=> $this->input->post('detalle'),
					'uxt_estado'=> 1,
					'uxt_usu_creacion'=>$this->input->post('det_usu_creacion'),
					'uxt_usu_modificacion'=>$this->tank_auth->get_user_id(),
					'uxt_fecha_creacion'=>$this->input->post('det_creacion'),
					'uxt_fecha_modificacion'=>date('Y-m-d H:i:s')
				);
		//die(print_r($ubicaxticket));
			 $uxt=$this->gsatelite->ingresar('uxt_ubicaxticket',$ubicaxticket);
			}
		}
			// if(isset($_POST['foto_articulo'])){
			//     $foto_articulo = time().'_'.$_POST['foto_articulo'];
			// } 


		   //    $carpeta = $this->input->post("nombreCarpeta");
			  // $id_foto=isset($foto_articulo)? $foto_articulo :'';
			  // $foto_eliminar=$this->input->post('id_foto');
			  // $anexo=$this->input->post('id_anx');
			  // $creacion=$this->input->post('det_creacion');
			  // $usuario=$this->input->post('det_usu_creacion');
			  // //die(print_r($carpeta.'/'.$id_foto.'--'.$foto_eliminar));
			  // if(!empty($id_foto))
			  // {
			  //   $img = $id_foto;                   // La imagen se guardara con este nombre, en la carpeta oficial. 
			  //   $titulo = $_POST['foto_articulo']; // Nombre original, para borrarlo de la carpeta temporal. 
			  //   $eliminar = $foto_eliminar;
			  //   if(!empty($eliminar)){
			  //   	//die(print_r($img.'/'.$titulo.'/'.$eliminar));
			  //  $this->datos_reemplazar_imagen($img,$carpeta,$titulo,$eliminar,$anexo,$creacion,$usuario);
			  // }
			  // else{
			  //  $soli=$this->input->post('solicitud_id');
			  //   $this->datos_imagen_gral($titulo,$carpeta,$img,$soli);
			  // }
			  // }

		// Guardar los Anexos
			$rutas 		= $this->input->post("ruta");
			$carpeta 	= $this->input->post("nombreCarpeta");

			if (count($rutas) > 0) {
				$carpeta = $carpeta;
				for ($j = 0; $j < count($rutas); $j++) {
					if ($rutas[$j] != "") {
						$img = $rutas[$j];
						//die(print_r($rutas[$j]));
						$titulo = $this->input->post("titulo_doc" . $j);
						$this->datos_imagen_gral($img,$carpeta,$titulo, $this->input->post('solicitud_id'));
				//die(print_r($img));
					}
				}
			} // End guardar anexos


		if($solicitud>0){
			$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Actualización de solicitud",'texto_alerta'=>"El registro se guardó correctamente.");  
		} else {
			$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Actualización de solicitud",'texto_alerta'=>"El registro no se guardó.");  
		}
		$this->session->set_flashdata($alerta); 

		$boton=$this->input->post('tipo_btn');
		$tkt= $this->input->post('solicitud_id');
		if ($boton==1) {
			redirect('/transporte/procesos/editar_solicitud/'.$tkt);
		}else if($boton==2){
			redirect('/transporte/procesos/solicitud_transporte');
		}

	}


	/*
	* Edith Herrera
	*/
   // Funciones para subir imagenes
    public function guardar_gral($parametros, $carpeta=null)
    {
        $datos= @explode($parametros);
        $carpeta=$parametros;
        $image = $this->upload_gral($carpeta);

        echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
    }

    /*
	* Edith Herrera
	*/
       function upload_gral($carpeta)
    {
    	if ($carpeta=="assets") {
    		$ruta=FCPATH . "assets/uploads/images";
    	}else{
    		$ruta=FCPATH . "public/temp/" . $carpeta;
    	}
        
        if(!file_exists($ruta)){
            mkdir($ruta, 0777);
        }

        $obj = &get_instance();
        $config['upload_path'] = $ruta;
        $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx';
        $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return true;
        } else {
            $data = array('upload_data' => $obj->upload->data());
            return $data;
        }
        print_r($data);
    }

    /*
	* Edith Herrera
	*/
    function eliminar_imagen_gral($carpeta="")
    { 
      $url = $this->input->post("url");
      $edicion = $this->input->post('edicion');
      $anx_id = $this->input->post('anx_id');
      
      if(isset($anx_id) && !empty($anx_id)){
      	$this->db->delete('axt_anexoxticket', array('axt_id_anx' => $anx_id));
      	$this->db->delete('anx_anexo', array('anx_id' => $anx_id));
      }
      if(!empty($edicion)){
        unlink("uploads/anexos_detalle_ticket/".$url);
      } else {
        $carp = ($carpeta != "") ? $carpeta : "anexos_detalle_ticket";  
        unlink("public/temp/$carp/" . $url);
      }
      echo $url;
    }

    /*
	* Edith Herrera
	*/
     public function datos_imagen_gral($img, $carpeta, $titulo_doc, $id_tkt){

     	$extencion =end(explode(".",$img));
		
		$nombre= trim($img);
		$ruta= "public/temp/".$carpeta."/".$nombre;

	   // $ruta= "public/temp/".$carpeta."/".$img; // Ruta de la imagen temporal
	   
	    $carpeta_destino= "uploads/anexos_detalle_ticket/".$titulo_doc.".".trim($extencion)."";
     	
	   // die(print_r($ruta.'**'.$carpeta_destino));
	    	$dir=$this->gsatelite->get_campo('anx_anexo','anx_url',array('anx_url'=>$carpeta_destino,'anx_estado'=>1));
			//die(print_r(count($dir)));
			if(count($dir)<=0){
			$array_anex=array(
				'anx_url'=> $carpeta_destino,
				'anx_estado'=>1,
				/*'anx_usu_creacion'=>$this->tank_auth->get_user_id(),
				'anx_usu_modificacion'=>$this->tank_auth->get_user_id(),
				'anx_fecha_creacion'=>date('Y-m-d H:i:s'),
				'anx_fecha_modificacion'=>date('Y-m-d H:i:s')*/
				'anx_usu_crea'=>$this->tank_auth->get_user_id(),
				'anx_usu_mod'=>$this->tank_auth->get_user_id(),
				'anx_fecha_crea'=>date('Y-m-d H:i:s'),
				'anx_fecha_mod'=>date('Y-m-d H:i:s')
				);
			$this->db->insert("anx_anexo",$array_anex);
			$id_anexo= $this->db->insert_id();

			$array_anex_doc=array(
				'axt_id_tkt'=> $id_tkt,
				'axt_id_anx' => $id_anexo,
				'axt_estado'=>1,
				'axt_usu_creacion'=>$this->tank_auth->get_user_id(),
				'axt_usu_modificacion'=>$this->tank_auth->get_user_id(),
				'axt_fecha_creacion'=>date('Y-m-d H:i:s'),
				'axt_fecha_modificacion'=>date('Y-m-d H:i:s')

				);
			$this->db->insert("axt_anexoxticket",$array_anex_doc);
			$carpeta_destino= "uploads/anexos_detalle_ticket/".$titulo_doc.".".trim($extencion)."";

	    if(!copy($ruta,$carpeta_destino)){
	    	die(print_r("no se copio el archivo")); 
	    }	
	    unlink($ruta);
	 } 

  }

  /*
	* Edith Herrera
	*/
   function datos_reemplazar_imagen($img,$carpeta,$titulo,$eliminar,$id_anx,$creacion,$usuario)
  {
    $drop_oficial = $eliminar; // Ruta de la imagen temporal
    unlink($drop_oficial);

    $extencion =end(explode(".",$img));
		
	$nombre= trim($img);
	$ruta_temp= "public/temp/".$carpeta."/".$nombre;

    //$ruta_temp = "public/temp/".$carpeta."/".$titulo; // Ruta de la imagen temporal
     $carpeta_destino= "uploads/anexos_detalle_ticket/".$titulo_doc.".".trim($extencion)."";

	$dir=$this->gsatelite->get_campo('anx_anexo','anx_url',array('anx_url'=>$drop_oficial,'anx_id'=>$id_anx,'anx_estado'=>1));
			if(count($dir)>0){
			$array_anex=array(
				'anx_url'=> $carpeta_destino,
				'anx_estado'=>1,
				'anx_usu_creacion'=>$usuario,
				'anx_usu_modificacion'=>$this->tank_auth->get_user_id(),
				'anx_fecha_creacion'=>$creacion,
				'anx_fecha_modificacion'=>date('Y-m-d H:i:s')
				);

			$this->db->where('anx_id',$id_anx)->update('anx_anexo',$array_anex);
}
    copy($ruta_temp,$carpeta_destino);
    unlink($ruta_temp);
  }


   	function inactivar_solicitud($solicitud,$tipo=null)
   	{
   		satelite_validar();
   		$solicitud=$this->db->where('tkt_id',$solicitud)
   		           ->update('tkt_ticket',array('tkt_estado'=>0));
   		if ($solicitud>0) {        	
   			$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"NOTA",'texto_alerta'=>"El registro fue eliminado correctamente.");  
   		}
	$this->session->set_flashdata($alerta); 
	if($tipo != null){
		if($tipo==2){
			redirect('/transporte/procesos/solicitud_mantenimiento');
		}else if($tipo==1){	
			redirect('/transporte/procesos/solicitud_transporte');
		}else if($tipo==3){
			redirect('/transporte/procesos/solicitud_combustible');
		}
	}
   	}


 /*
	* Edith Herrera
	*/
public function solicitud_mantenimiento($consulta=null)
	{
		satelite_validar();
		
			$permisos= $this->gsatelite->get_permisos_opcion('solicitud_mantenimiento');
			
			$data['permisos']=$permisos;				
			$data['listado']=$this->entradas_model->get_solicitud_mantto();

			if($consulta){
		 		if($this->input->post()){
		 			$fecha_ini = date("Y-m-d",strtotime($this->input->post('fecha_ini'))) ;
		 			$fecha_fin = date("Y-m-d",strtotime($this->input->post('fecha_fin'))) ;
		 			$where=array('dtm_fecha_sugerida >='=>$fecha_ini,'dtm_fecha_sugerida <='=>$fecha_fin);
		 			$data['registros'] = $this->entradas_model->get_solicitud_mantto($fecha_ini,$fecha_fin);
		 			
		 			$html = $this->load->view('transporte/procesos/detalle_solicitud_mantto', $data, true);
		 			echo $html;
		 		}
		 		die();
	 		}	
			$data['titulo_personal']="Solicitudes de servicio de mantenimiento";
			$this->_cargarvista($data);
	}

	public function anexos_mantto($id_tkt=null,$tipo=null)
	{
		satelite_validar();

		$this->gsatelite->verificar_registro_real('tkt_ticket',$id_tkt);
		$ids=$this->entradas_model->get_tipo_url($id_tkt);
		$anx=array(0);
		for ($i=0; $i < count($ids); $i++) { 
			$anx[]=$ids[$i]['axt_id_anx'];
		}
		$GLOBALS['id_ticket']=$id_tkt;
                $crud = new grocery_CRUD();
                $this->load->config('grocery_crud');
                $this->config->set_item('grocery_crud_file_upload_allow_file_types','pdf|jpeg|jpg|png|doc|xls|ppt|docx|xlsx|pptx');
                    
                $crud->set_table('anx_anexo')
                     ->set_subject('Anexos de solicitud')
                     
                     ->columns('Ticket','anx_url','anx_estado')
                     ->set_relation_n_n('Ticket', 'axt_anexoxticket', 'tkt_ticket', 'axt_id_anx', 'axt_id_tkt','tkt_id')
                     ->fields('anx_url','anx_estado','anx_usu_crea','anx_usu_mod','anx_fecha_crea','anx_fecha_mod')
                     ->display_as('anx_url', 'Anexo')
                     ->display_as('anx_estado', 'Estado')
                     ->required_fields('anx_url','anx_estado')
                     ->field_type('anx_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('anx_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('anx_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
                     ->field_type('anx_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                     ->set_field_upload('anx_url','uploads/anexos_detalle_ticket')
                     ->unset_print()
                     ->unset_delete()
                     ->unset_export();

                     $crud->where("anx_id in (".implode($anx,',').")");
                    
                    
                     if(end(explode('/',uri_string()))=='add') {
                     $crud->field_type('anx_estado','hidden',1);
                     }
                     else {
                     $crud->field_type('anx_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                     }

                    $crud->callback_after_insert(function($post_array,$primary_key){
     
	                    $this->db->insert('axt_anexoxticket', array(
	                        'axt_id_tkt'    => $GLOBALS['id_ticket'],
	                        'axt_id_anx'    => $primary_key,
	                        'axt_estado'     => 1,
	                        'axt_usu_creacion'     => $this->tank_auth->get_user_id() ,
	                        'axt_usu_modificacion' => $this->tank_auth->get_user_id(),
	                        'axt_fecha_creacion' => date("Y-m-d H:i:s"),
	                        'axt_fecha_modificacion' => date("Y-m-d H:i:s")
	                    ));
	                });
                    $crud->callback_after_update(function($post_array,$primary_key){
     
	                    $this->db->insert('axt_anexoxticket', array(
	                        'axt_id_tkt'    => $GLOBALS['id_ticket'],
	                        'axt_id_anx'    => $primary_key,
	                        'axt_estado'     => 1,
	                        'axt_usu_creacion'     => $this->tank_auth->get_user_id() ,
	                        'axt_usu_modificacion' => $this->tank_auth->get_user_id(),
	                        'axt_fecha_creacion' => date("Y-m-d H:i:s"),
	                        'axt_fecha_modificacion' => date("Y-m-d H:i:s")
	                    ));
	                });
		
                     $data['titulo_personal'] = "Anexos de solicitud";
                     $output = $crud->render();
                     $this->_cargarvista($data,$output);

	}



/*
**@autor: christian
**@descripcion: da seguimiento al contrato 
*/
public function seguimiento_contrato($value='') {
		satelite_validar();

		try {
	
			$permisos= $this->gsatelite->get_permisos_opcion('seguimiento_contrato');
			$crud = new grocery_CRUD();
			$crud->unset_export();
			$crud->unset_print();
			$crud->unset_add();
			$crud->unset_edit();
			$crud->unset_delete();
			$crud->set_table('con_contrato_gasol');
			$crud->set_subject('');
			
			$columnas = array(
				'con_numero',
				'con_nombre',
				'con_institucion',
				'con_resolucion',
				'con_vigencia_desde',
				'con_vigencia_hasta',
				'con_estado'
			);

			$campos = array(
				'con_numero',
				'con_nombre',
				'con_institucion',
				'con_codigo',
				'con_resolucion',
				'con_vigencia_desde',
				'con_vigencia_hasta',
				'con_gar_cum_desde',
				'con_gar_cum_hasta',
				'con_antic_desde',
				'con_antic_hasta',
				'con_buena_desde',
				'con_buena_hasta',
				'con_otras_desde',
				'con_otras_hasta',
				'con_estado',
				'con_fecha_creacion',
				'con_fecha_modificacion',
				'con_usu_creacion',
				'con_usu_modificacion'
			);

			$display_as = array(
				'con_numero' 	=> 'Número',
				'con_nombre'	=> 'Nombre',
				'con_institucion'	=> 'Institución',
				'con_codigo'		=> 'Código',
				'con_resolucion'	=> 'Resolución',
				'con_vigente_desde'	=> 'Vigencia desde',
				'con_gar_cum_desde'	=> 'Vigencia garantía desde',
				'con_vigente_hasta'	=> 'Vigencia hasta',
				'con_antic_desde'		=> 'Vigencia garantía anticipo desde',
				'con_gar_cum_hasta'		=> 'Vigencia garantía hasta',
				'con_buena_desde'		=> 'Vigencia garantía buena obra desde',
				'con_buena_hasta'		=> 'Vigencia garantía buena obra hasta',
				'con_antic_hasta'		=> 'Vigencia garantía anticipo hasta',
				'con_otras_desde'		=> 'Vigencia otras garantías desde',
				'con_otras_hasta'		=> 'Vigencia otras garantías hasta',
				'con_estado'			=> 'Estado'
			);

			$crud->field_type('con_usu_creacion', 'hidden');
			$crud->field_type('con_usu_modificacion', 'hidden');
			$crud->field_type('con_fecha_creacion', 'hidden');
			$crud->field_type('con_fecha_modificacion', 'hidden');	
			$crud->field_type('con_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
			$crud->set_rules('con_numero','Número','campo_unico[con_contrato.con_numero]|required');
			$crud->required_fields('con_numero','con_nombre', 'con_codigo', 'con_resolucion', 'con_vigente_desde', 'con_vigente_hasta','con_estado');
			
			$crud->columns($columnas);
			$crud->fields($campos);
			$crud->display_as($display_as);
			$crud->add_action('Hoja de Seguimiento', 'icon16 icomoon-icon-printer', 'transporte/reportes/imprimir_seguimiento_contratos');
 
		    // Validaciones
		    if($permisos['permite_editar']) { 
		      $crud->add_action('seguimiento','icon16 icomoon-icon-pencil-5','transporte/procesos/editar_contrato');
		   
		    }

		    //$crud->add_action('Ejecucion contratos','icon16 icomoon-icon-printer','transporte/reportes/imprimir_ejecucion_contratos');

			$output = $crud->render();
			$data['permisos'] = $permisos;
			$data['titulo_personal']="Catálogo de contratos";
			// $this->_catalogo_output($data, $output);
	      	$this->_cargarvista($data,$output);
		} catch(Exception $e) {
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} // End contrato


	function editar_contrato($id_contrato=0, $ver=0)
	{
		satelite_validar();
		if($_POST){
			
			//die(print_r($_POST,true));
		  
			// Alcamenado de las Obligaciones
		 	 $obligaciones	=	$_POST['obligaciones'];
		  	 $fecha_inicio	=	$_POST['periodo_desde'];
			 $fecha_fin		=	$_POST['periodo_hasta'];
			 $id_contrato	=   $_POST['id_contrato'];
			 $obc_id=0;

			 if(count($obligaciones)>0){
			 	// Eliminamos los registros anteriores
			 	$obligacion_tabla = $this->gsatelite->get_tabla('obc_obligacion_contrato', array('obc_id_con'=>$id_contrato));
			 	$obligacion_array = array();
			 	foreach ($obligacion_tabla as $key => $value) {
			 		$obligacion_array[] = $value['obc_id'];	
			 	}
			 
			 	$this->db->where_in('seg_id_obc', $obligacion_array)
			 	         ->delete('seg_seguimiento_cont')
			 	;

			 	 foreach ($obligaciones as $key => $value) {
		  	  	
			  	  	$oblixcontrato=array(
			        'seg_id_obc'  => $value,
			        'seg_desde'  => (count($fecha_inicio)>0) ? date('Y-m-d', strtotime($fecha_inicio[$key])) : date('Y-m-d'),
			        'seg_hasta'  => (count($fecha_fin)>0) ? date('Y-m-d', strtotime($fecha_fin[$key])) : date('Y-m-d'),
			        'seg_estado'	=> 1,
			        'seg_fecha_creacion'=> date('Y-m-d H-i-s'),
			        'seg_usu_creacion' => $this->tank_auth->get_user_id(),
			        'seg_usu_modificacion' => $this->tank_auth->get_user_id(),
			        'seg_fecha_modificacion'=> date('Y-m-d H-i-s')
			      );
			    
			    $seg_id=$this->gsatelite->ingresar('seg_seguimiento_cont', $oblixcontrato);
			    }
			 }
		  
		  // Mostrar alerta
		if($seg_id > 0){
			$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Ingreso de contrato",'texto_alerta'=>"El registro se editó correctamente.");  
		} else {
		    $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Ingreso de contrato",'texto_alerta'=>"El registro no se editó.");  
		}
		  
		$this->session->set_flashdata($alerta);      
		redirect('/transporte/procesos/seguimiento_contrato');
	
		} else {
			//All your code goes here
			
				$contrato = $this->gsatelite->get_registro('con_contrato_gasol', array('con_id'=>$id_contrato));

			if(count($contrato)>0){
				$data['permite_ver'] = $ver;
				$data['contrato'] = $contrato;	

				$data['proveedores'] 	= $this->gsatelite->get_dropdown('prv_proveedor', '{prv_nombre} {prv_apellido}','', array('prv_estado' => '1'), $contrato->con_id_prv, '', 'prv_id', true);

				// desarrollonndo
				$datos['obligaciones'] = $this->entradas_model->obligcacionxcontrato($id_contrato);

				$data['html'] = $this->load->view('transporte/procesos/tabla_obligaciones_edicion', $datos, true); // Devuelve la tabla de resultados
				
				// Fin desarrollando

				$obligaciones = $this->gsatelite->get_tabla('obc_obligacion_contrato', array('obc_id_con'=>$contrato->con_id, 'obc_estado'=>1));
				
				$option = '';
				$fecha_inicio =	'';
				$fecha_fin 	  = '';	
				foreach ($obligaciones as $key => $value) {
					if(!empty($value['obc_desde'])){
						$option .= "<option value='".$value['obc_id']."' selected>".$value['obc_nombre']."</option>";	
						if(empty($fecha_inicio)){
							$fecha_inicio = $value['obc_desde'];
							$fecha_fin    = $value['obc_hasta'];	
						}
					}
					else{
						$option .= "<option value='".$value['obc_id']."' > ".$value['obc_nombre']."</option>";	
					}
				}
				$data['obligaciones'] = $option;
				$data['fecha_inicio'] = (!empty($fecha_inicio))? date('d-m-Y', strtotime($fecha_inicio)):'';
				$data['fecha_fin']	  = (!empty($fecha_fin)) ? date('d-m-Y', strtotime($fecha_fin)):'';
				
				if($ver!=0){
					$data['titulo_personal']="Ver contrato";
				} else {
					$data['titulo_personal']="Editar contrato";	
				}
				
	    		$this->_cargarvista($data,null,'seguimiento_contrato');
    		}
		}
	}



	/*
	* Edith Herrera
	* Crear solicitud de mantenimiento
	*/
	public function crear_solicitud_mantto()
	{
		satelite_validar();
			
			$data['listado']=$this->gsatelite->get_tabla('dtm_detalle_ticket_mantto');
			$data['tipo_solicitud'] = $this->gsatelite->get_dropdown('tsm_tipo_sol_mantto', '{tsm_nombre}','', array('tsm_estado' => '1'), null, '', 'tsm_id', true);
			$this->db->join('mdv_modelo_veh','veh_id_mdv = mdv_id');
			$data['vehiculos'] = $this->gsatelite->get_dropdown('veh_vehiculo', '{veh_placa} - {mdv_nombre}','', array('veh_estado' => 1), null, '', 'veh_id', true);
			$data['estados'] = $this->gsatelite->get_dropdown('esk_estado_ticket', '{esk_nombre}','', array('esk_estado' => '1'), array('esk_id'=>2), '', 'esk_id', true);
			$data['medios_recepcion'] = $this->gsatelite->get_dropdown('mrc_medio_recepcion', '{mrc_nombre}','', array('mrc_estado' => '1'), null, '', 'mrc_id', true);	
			$data['titulo_personal']="Creación de solicitud de mantenimiento";
			$data['server_time'] = date('Y-m-d H:i:s');
			$this->_cargarvista($data);	
	}

		function cargarSerie()
	{
		$veh_id = $this->input->post('vehiculo_id');
		$detalle = $this->entradas_model->get_detalle_vehiculo($veh_id);
		echo json_encode(array('veh_detalle'=>$detalle));
	}

	public function guardar_solicitud_mantto(){
		satelite_validar();
			$id_esk=$this->gsatelite->get_parametro('ID_ESTADO_TICKET');
		
		$solicitud_tkt=array(
			// 'tkt_id_prd'=> , //Prioridad
			'tkt_id_esk'=>$id_esk,
			 //($this->input->post('estado'))?$this->input->post('estado'):null, //Estado del tickets
			// 'tkt_id_flu'=> , //flujo
			// 'tkt_id_sue'=> , //Sub-especialidad
		    'tkt_requerimiento'=>$this->input->post('suministro'),//requerimiento
		    'tkt_descripcion'=>$this->input->post('suministro'),//descripcion
		    'tkt_estado'=>1, //estado
		    'tkt_id_mrc'=> 3,//!(empty($_POST['medio']))? $this->input->post('medio'): null,
		    'tkt_usu_creacion'=>$this->tank_auth->get_user_id(),
		    'tkt_usu_modificacion'=>$this->tank_auth->get_user_id(),
		    'tkt_fecha_creacion'=>date('Y-m-d H:i:s'),
		    'tkt_fecha_modificacion'=>date('Y-m-d H:i:s'),
		    'tkt_usuario_solicita'=>$this->tank_auth->get_user_id()
		);
		$ingresar_solicitud=$this->gsatelite->ingresar('tkt_ticket', $solicitud_tkt);
		
		$fecha=date('Y-m-d', strtotime($this->input->post('fecha')));
		$hora=date('H:i:s', strtotime($this->input->post('hora')));

		$solicitud_dtm=array(
			'dtm_id_tkt'=>$ingresar_solicitud,
			'dtm_id_veh'=>$this->input->post('placa'),
			'dtm_cantidad'=>($this->input->post('cantidad'))?$this->input->post('cantidad'):0,
			'dtm_detalle_suministro'=>$this->input->post('suministro'),// igual a tkt?
			'dtm_fecha_sugerida'=>$fecha,
			'dtm_hora_sugerida'=>$hora,
			'dtm_estado'=>1,
			'dtm_usu_creacion'=>$this->tank_auth->get_user_id(),
			'dtm_usu_modificacion'=>$this->tank_auth->get_user_id(),
			'dtm_fecha_creacion'=>date('Y-m-d H:i:s'),
			'dtm_fecha_modificacion'=>date('Y-m-d H:i:s'),
			'dtm_id_tsm'=>$this->input->post('tipo_soli'),
		);
		//die(print_r($solicitud_dtm));
			$ingresar_detalle=$this->gsatelite->ingresar('dtm_detalle_ticket_mantto', $solicitud_dtm);

		if($ingresar_solicitud>0){
			$this->enviar_correo_mantto($ingresar_solicitud);
			$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Ingreso de solicitud",'texto_alerta'=>"El registro se guardó correctamente.");  
		} else {
			$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Ingreso de solicitud",'texto_alerta'=>"El registro no se guardó.");  
		}
			$this->session->set_flashdata($alerta); 

			$boton=$this->input->post('tipo_btn');
		if ($boton==1) {
			redirect('/transporte/procesos/crear_solicitud_mantto');
		}else if($boton==2){
			redirect('/transporte/procesos/solicitud_mantenimiento');
		}
	}

	public function editar_solicitud_mantto($id_soli){
		satelite_validar();
		$es_admin = $this->gsatelite->es_administrador($this->tank_auth->get_user_id());
			$data['registros'] = $this->entradas_model->get_solicitud_mantto(null,null,$id_soli, $es_admin['usuario']);

			$this->db->join('mdv_modelo_veh','veh_id_mdv = mdv_id');
			$data['vehiculos'] = $this->gsatelite->get_dropdown('veh_vehiculo', '{veh_placa} - {mdv_nombre}','', array('veh_estado' => 1), !empty($data['registros'][0]['veh_id'])? $data['registros'][0]['veh_id']:null, '', 'veh_id', true);
			//$data['medios_recepcion'] = $this->gsatelite->get_dropdown('mrc_medio_recepcion', '{mrc_nombre}','', array('mrc_estado' => '1'), !empty($data['registros'][0]['tkt_id_mrc'])? $data['registros'][0]['tkt_id_mrc']:null , '', 'mrc_id', true);	
			//$data['destinos']=$this->entradas_model->get_ubicacion($id_soli);
		
		$data['titulo_personal']="Modificación de solicitud de mantenimiento";
		$this->_cargarvista($data);	
	}


public function actualizar_solicitud_mantto(){
		satelite_validar();
		$id_esk=$this->gsatelite->get_parametro('ID_ESTADO_TICKET');
		$solicitud_tkt=array(
			// 'tkt_id_prd'=> , //Prioridad
			'tkt_id_esk'=>$id_esk, //Estado del tickets
			// 'tkt_id_flu'=> , //flujo
			// 'tkt_id_sue'=> , //Sub-especialidad
		    'tkt_requerimiento'=>$this->input->post('suministro'),//requerimiento
		    'tkt_descripcion'=>$this->input->post('suministro'),//descripcion
		    'tkt_estado'=>1, //estado
		    'tkt_id_mrc'=> 3,//!(empty($_POST['medio']))? $this->input->post('medio'): null,
		    'tkt_usu_creacion'=>$this->input->post('usu_creacion'),
		    'tkt_usu_modificacion'=>$this->tank_auth->get_user_id(),
		    'tkt_fecha_creacion'=>$this->input->post('fec_creacion'),
		    'tkt_fecha_modificacion'=>date('Y-m-d H:i:s'),
		    'tkt_usuario_solicita'=>$this->tank_auth->get_user_id()
		);

		$ingresar_solicitud = $this->gsatelite->actualizar_array('tkt_ticket', $solicitud_tkt, array('tkt_id'=>$_POST['id_soli']));

		//die(print_r($solicitud_tkt));
		$fecha=date('Y-m-d', strtotime($this->input->post('fecha')));
		$hora=date('H:i:s', strtotime($this->input->post('hora')));

		$solicitud_dtm=array(
			'dtm_id_tkt'=>$this->input->post('id_soli'),
			'dtm_id_veh'=>$this->input->post('placa'),
			'dtm_cantidad'=>($this->input->post('cantidad'))?$this->input->post('cantidad'):0,
			'dtm_detalle_suministro'=>$this->input->post('suministro'),// igual a tkt?
			'dtm_fecha_sugerida'=>$fecha,
			'dtm_hora_sugerida'=>$hora,
			'dtm_estado'=>1,
			'dtm_usu_creacion'=>$this->input->post('usu_creacion'),
			'dtm_usu_modificacion'=>$this->tank_auth->get_user_id(),
			'dtm_fecha_creacion'=>$this->input->post('fec_creacion'),
			'dtm_fecha_modificacion'=>date('Y-m-d H:i:s'),
			'dtm_id_tsm'=>$this->input->post('tipo_soli'),
		);
		
			$ingresar_detalle=$this->gsatelite->actualizar_array('dtm_detalle_ticket_mantto', $solicitud_dtm, array('dtm_id_tkt'=>$_POST['id_soli']));

		if($ingresar_detalle>0){
			$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Ingreso de solicitud",'texto_alerta'=>"El registro se guardó correctamente.");  
		} else {
			$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Ingreso de solicitud",'texto_alerta'=>"El registro no se guardó.");  
		}
			$this->session->set_flashdata($alerta); 

			$boton=$this->input->post('tipo_btn');
		if ($boton==1) {
			redirect('/transporte/procesos/editar_solicitud_mantto/'.$_POST['id_soli']);
		}else if($boton==2){
			redirect('/transporte/procesos/solicitud_mantenimiento');
		}
	}



	/*
	* Edith Herrera
	*/
public function solicitud_combustible($consulta=null)
	{
		satelite_validar();
			$permisos= $this->gsatelite->get_permisos_opcion('solicitud_combustible');
			$data['permisos']=$permisos;				
			$data['listado']=$this->entradas_model->detalle_combustible();
			if($consulta){
		 		if($this->input->post()){
		 			$fecha_ini = date("Y-m-d",strtotime($this->input->post('fecha_ini')));
		 			$fecha_fin = date("Y-m-d",strtotime($this->input->post('fecha_fin')));
		 			$tipo 	   = $this->input->post('fecha_tipo');
		 			//$where=array('dtc_fecha_solicitud >='=>$fecha_ini,'dtc_fecha_solicitud <='=>$fecha_fin);
		 			$data['registros'] = $this->entradas_model->detalle_combustible($fecha_ini,$fecha_fin, null, $tipo);
		 			$html = $this->load->view('transporte/procesos/detalle_soli_combustible', $data, true);
		 			echo $html;
		 		}
		 		die();
	 		}	
			$data['titulo_personal']="Solicitudes de combustible";
			$this->_cargarvista($data);
	}


/*
	* Edith Herrera
	* Crear solicitud de mantenimiento
	*/
	public function crear_solicitud_combustible($consulta=null)
	{
		satelite_validar();
					
			$data['listado']=$this->gsatelite->get_tabla('dtc_detalle_ticket_combustible');
			$data['motorista'] = $this->gsatelite->get_dropdown_empleado('mot_motorista', '{mot_empleado}','', array('mot_estado' => '1'), null, '', 'mot_id', true);
			$data['vehiculos'] = $this->gsatelite->get_dropdown('veh_vehiculo', '{veh_placa}','', array('veh_estado' => '1'), null, '', 'veh_id', true);
			$data['combustible'] = $this->gsatelite->get_dropdown('tpc_tipo_combustible', '{tpc_nombre}','', array('tpc_estado' => '1'), null, '', 'tpc_id', true);
			$data['estado'] = $this->gsatelite->get_dropdown('esk_estado_ticket', '{esk_nombre}','', array('esk_estado' => '1'), array('esk_id'=>2), '', 'esk_id', true);
			$data['municipio'] = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}','', null, null, '', 'mun_id', true);
			//$data['municipio'] = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}','', array('mun_estado' => '1'), null, '', 'mun_id', true);
			$data['medios_recepcion'] = $this->gsatelite->get_dropdown('mrc_medio_recepcion', '{mrc_nombre}','', array('mrc_estado' => '1'), null, '', 'mrc_id', true);	
			$data['select_encargado']=$this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}','', array('emp_estado'=>'1'), null, '', 'emp_id', true);	
			$es_admin = $this->gsatelite->es_administrador($this->tank_auth->get_user_id());
			$data['es_administrador'] = $es_admin['usuario'];

			if($consulta){
		 		if($this->input->post()){
		 			$veh_id = $this->input->post('vehiculo');
		 			$combustible = $this->entradas_model->obtener_combustible($veh_id);

		 			
		 			echo json_encode(array('combustible'=>$combustible->tpc_nombre, 'fondo'=>$combustible->tpf_nombre));
		 		}
		 		die();
	 		}

			$data['titulo_personal']="Creación de solicitud de combustible";
			$this->_cargarvista($data);	
	}

	public function guardar_solicitud_combustible(){
		satelite_validar();
		
		// Calcular el id del combustible
		$id_combustible = 0;
		if(empty($_POST['vehiculo']) && !empty($_POST['tipo_combustible'])){
			$id_combustible = $_POST['tipo_combustible'];	
		} else {
			$id_combustible = $this->gsatelite->get_campo('veh_vehiculo','veh_id_tpc', array('veh_id'=>$_POST['vehiculo']));
		}
			$id_esk=$this->gsatelite->get_parametro('ID_ESTADO_TICKET');

		$solicitud_tkt=array(
			// 'tkt_id_prd'=> , //Prioridad
			'tkt_id_esk'=>$id_esk,//($this->input->post('estado'))?$this->input->post('estado'):null, //Estado del tickets
			// 'tkt_id_flu'=> , //flujo
			// 'tkt_id_sue'=> , //Sub-especialidad
		    'tkt_requerimiento'=>'',//requerimiento
		    'tkt_descripcion'=>'Ticket de combustible',//descripcion
		    'tkt_estado'=>1, //estado
		    'tkt_id_mrc'=> 3,//!(empty($_POST['medio']))? $this->input->post('medio'): null,
		    'tkt_usu_creacion'=>$this->tank_auth->get_user_id(),
		    'tkt_usu_modificacion'=>$this->tank_auth->get_user_id(),
		    'tkt_fecha_creacion'=>date('Y-m-d H:i:s'),
		    'tkt_fecha_modificacion'=>date('Y-m-d H:i:s'),
		    'tkt_usuario_solicita'=>$this->tank_auth->get_user_id()
		);
		//die(print_r($solicitud_tkt));
		$ingresar_solicitud=$this->gsatelite->ingresar('tkt_ticket', $solicitud_tkt);
		
		$fecha_desde=date('Y-m-d', strtotime($this->input->post('fecha_desde')));
		$fecha_hasta=date('Y-m-d', strtotime($this->input->post('fecha_hasta')));
		//$fecha_soli=date('Y-m-d', strtotime($this->input->post('fecha_solicitud')));



		$solicitud_dtc=array(
			'dtc_id_tkt'=>$ingresar_solicitud,
			'dtc_id_mot'=> (!empty($_POST['motorista']))? $this->input->post('motorista'):NULL,
			'dtc_id_veh'=>($this->input->post('vehiculo'))?$this->input->post('vehiculo'):NULL,
			'dtc_vales'=>($this->input->post('cantidad'))? $this->input->post('cantidad'): NULL,
			'dtc_vale_valor'=>($this->input->post('valor'))?$this->input->post('valor'):NULL,
			'dtc_periodo_desde'=>$fecha_desde,// igual a tkt?
			'dtc_periodo_hasta'=>$fecha_hasta,
			'dtc_id_emp_resp' => (!empty($_POST['responsable']))? $this->input->post('responsable') : NULL,
			'dtc_fecha_solicitud'=> date('Y-m-d H:i:s'),
			'dtc_id_tpc' => $id_combustible,
			'dtc_destino'=>$this->input->post('destino'),
			'dtc_estado'=>1,
			'dtc_usu_creacion'=>$this->tank_auth->get_user_id(),
			'dtc_usu_modificacion'=>$this->tank_auth->get_user_id(),
			'dtc_fecha_creacion'=>date('Y-m-d H:i:s'),
			'dtc_fecha_modificacion'=>date('Y-m-d H:i:s')
		);

		$ingresar_detalle=$this->gsatelite->ingresar('dtc_detalle_ticket_combustible', $solicitud_dtc);

		if($this->input->post('oficina')){
			$cant_detalle=count($this->input->post('detalle_fecha'));
			$destino=$this->input->post('detalle_destino');
			$actividad=$this->input->post('detalle_actividad');
			$contacto=$this->input->post('detalle_contacto');
			$kilo=$this->input->post('detalle_kilo');
			$fe_det=$this->input->post('detalle_fecha');
			for ($i=0; $i < $cant_detalle; $i++) { 
				if($fe_det[$i] != '' || $fe_det[$i] != null){ 
					$kilometraje= number_format($kilo[$i],2);
					$fecha_det=date('Y-m-d', strtotime($fe_det[$i]));
					$detalle_destino=array(
						'ddt_id_dtc'=>$ingresar_detalle,
						'ddt_destino'=>$destino[$i],
						'ddt_actividad'=>$actividad[$i],
						'ddt_persona_contacto'=>$contacto[$i],
						'ddt_kilometraje'=>$kilometraje,
						'ddt_fecha_destino'=>$fecha_det,
						'ddt_estado'=>1,
						'ddt_usu_creacion'=>$this->tank_auth->get_user_id(),
						'ddt_usu_modificacion'=>$this->tank_auth->get_user_id(),
						'ddt_fecha_creacion'=>date('Y-m-d H:i:s'),
						'ddt_fecha_modificacion'=>date('Y-m-d H:i:s')
					);
			//die(print_r($detalle_destino));
					$this->gsatelite->ingresar('ddt_detalle_destino',$detalle_destino);
				}
			}
		}


		if(count($this->input->post('detalle_fecha_fac')) > 0){
			$cant_fac=count($this->input->post('detalle_fecha_fac'));
			$numero=$this->input->post('detalle_factura');
			$galones=$this->input->post('detalle_galones');
			$prec=$this->input->post('detalle_precio');
			$subt=$this->input->post('detalle_subtotal');
			$fec_factura=$this->input->post('detalle_fecha_fac');
			
			for ($i=0; $i < $cant_fac; $i++) { 
				if($numero != '' && $numero != null){ 
					$galon= number_format($galones[$i],2);
					$precio= number_format($prec[$i],2);
					$subtotal= number_format($subt[$i],2);
					$fecha_factura=date('Y-m-d H:i:s', strtotime($fec_factura[$i]));
					$detalle_factura=array(
						'dtf_id_dtc'=>$ingresar_detalle,
						'dtf_fecha_factura'=>$fecha_factura,
						'dtf_numero_factura'=>$numero[$i],
						'dtf_galones'=>$galon,
						'dtf_precio'=>$precio,
						'dtf_subtotal'=>$subtotal,
						'dtf_estado'=>1,
						'dtf_usu_creacion'=>$this->tank_auth->get_user_id(),
						'dtf_usu_modificacion'=>$this->tank_auth->get_user_id(),
						'dtf_fecha_creacion'=>date('Y-m-d H:i:s'),
						'dtf_fecha_modificacion'=>date('Y-m-d H:i:s')
					);
					//die(print_r($detalle_factura));
				$this->gsatelite->ingresar('dtf_detalle_factura',$detalle_factura);
				}
			}
		}

		// Guardar los Anexos
			$rutas 		= $this->input->post("ruta");
			$carpeta 	= $this->input->post("nombreCarpeta");

			if (count($rutas) > 0) {
				$carpeta = $carpeta;
				for ($i = 0; $i < count($rutas); $i++) {
					if ($rutas[$i] != "") {
						$img = $rutas[$i];
						$titulo = $this->input->post("titulo_doc" . $i);
						//die(print_r($img.'/'.$carpeta.'/'.$titulo.'/'.$ingresar_solicitud));
						$this->datos_imagen_gral($img,$carpeta,$titulo,$ingresar_solicitud);
					}
				}
			} // End guardar anexos

		if($ingresar_detalle>0){
			$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Ingreso de solicitud",'texto_alerta'=>"El registro se guardó correctamente.");  
		} else {
			$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Ingreso de solicitud",'texto_alerta'=>"El registro no se guardó.");  
		}
			$this->session->set_flashdata($alerta); 

			$boton=$this->input->post('boton');

		if ($boton==1) {
			redirect('/transporte/procesos/crear_solicitud_combustible');
		}else if($boton==2){
			redirect('/transporte/procesos/solicitud_combustible');
		}
	}


public function editar_solicitud_combustible($id_soli){
		satelite_validar();
			$data['registros'] = $this->entradas_model->detalle_combustible(null,null,$id_soli);
			$data['destinos']=$this->entradas_model->get_detalles_combustible($id_soli);
			$data["anexos"]			= $this->entradas_model->get_anexos($id_soli);
			$data['facturas']=$this->entradas_model->get_facturas($id_soli);
			$data['combustible'] = $this->gsatelite->get_dropdown('tpc_tipo_combustible', '{tpc_nombre}','', array('tpc_estado' => '1'), array('tpc_id'=>$data['registros'][0]['dtc_id_tpc']), '', 'tpc_id', true);
			$data['medios_recepcion'] = $this->gsatelite->get_dropdown('mrc_medio_recepcion', '{mrc_nombre}','', array('mrc_estado' => '1'), !empty($data['registros'][0]['tkt_id_mrc'])? $data['registros'][0]['tkt_id_mrc']:null , '', 'mrc_id', true);	
			$data['select_encargado'] = $this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}','', array('emp_estado'=>'1'), !empty($data['registros'][0]['dtc_id_emp_resp'])? $data['registros'][0]['dtc_id_emp_resp']:null, '', 'emp_id', true);	
			$data['motorista']	= $this->gsatelite->get_dropdown_empleado('mot_motorista', '{mot_empleado}','', array('mot_estado' => '1'), !empty($data['registros'][0]['dtc_id_mot'])? $data['registros'][0]['dtc_id_mot']:null, '', 'mot_id', true);
			$es_admin = $this->gsatelite->es_administrador($this->tank_auth->get_user_id());
			$data['es_administrador'] = $es_admin['usuario'];
		$data['titulo_personal']="Modificación de solicitud de combustible";
		$this->_cargarvista($data);	
	}


public function actualizar_solicitud_combustible(){
		satelite_validar();
		$id_esk=$this->gsatelite->get_parametro('ID_ESTADO_TICKET');
		$creacion=$this->input->post('creacion');
		$solicitud_tkt=array(
			// 'tkt_id_prd'=> , //Prioridad
			'tkt_id_esk'=>$id_esk, //Estado del tickets
			// 'tkt_id_flu'=> , //flujo
			// 'tkt_id_sue'=> , //Sub-especialidad
		    'tkt_requerimiento'=>'',//requerimiento
		    'tkt_descripcion'=>'Ticket de combustible',//descripcion
		    'tkt_estado'=>1, //estado
		    'tkt_id_mrc'=> !(empty($_POST['medio']))? $this->input->post('medio'): null,
		    'tkt_usu_creacion'=>$this->input->post('usuario'),
		    'tkt_usu_modificacion'=>$this->tank_auth->get_user_id(),
		    'tkt_fecha_creacion'=>$creacion,
		    'tkt_fecha_modificacion'=>date('Y-m-d H:i:s'),
		    'tkt_usuario_solicita'=>$this->tank_auth->get_user_id()
		);
		//die(print_r($solicitud_tkt));
		$ingresar_solicitud=$this->gsatelite->actualizar_array('tkt_ticket', $solicitud_tkt, array('tkt_id'=>$this->input->post('tkt_id')));
	
		// Calcular el id del combustible
		$id_combustible = 0;
		if(empty($_POST['vehiculo']) && !empty($_POST['tipo_combustible'])){
			$id_combustible = $_POST['tipo_combustible'];	
		} else {
			$id_combustible = $this->gsatelite->get_campo('veh_vehiculo','veh_id_tpc', array('veh_id'=>$_POST['vehiculo']));
		}

		$fecha_desde=date('Y-m-d', strtotime($this->input->post('fecha_desde')));
		$fecha_hasta=date('Y-m-d', strtotime($this->input->post('fecha_hasta')));
		//$fecha_soli=date('Y-m-d', strtotime($this->input->post('fecha_solicitud')));
		$creacion= date_format($this->input->post('fecha_creacion'),'Y-m-d H:i:s');
		$solicitud_dtc=array(
			'dtc_id_tkt'=>$this->input->post('tkt_id'),
			'dtc_id_mot'=> (!empty($_POST['motorista']))? $this->input->post('motorista'):NULL,
			'dtc_id_veh'=>($this->input->post('vehiculo'))?$this->input->post('vehiculo'):NULL,
			'dtc_vales'=> ($this->input->post('cantidad'))? $this->input->post('cantidad'):NULL,
			'dtc_vale_valor'=>($this->input->post('valor'))?$this->input->post('valor'):NULL,
			'dtc_periodo_desde'=>$fecha_desde,// igual a tkt?
			'dtc_periodo_hasta'=>$fecha_hasta,
			'dtc_id_tpc' => $id_combustible,
			'dtc_id_emp_resp' => (!empty($_POST['responsable']))? $this->input->post('responsable') : NULL,
			// 'dtc_fecha_solicitud'=>$fecha_soli,
			'dtc_destino'=>$this->input->post('destino'),
			'dtc_estado'=>1,
			//'dtc_usu_creacion'=>$this->input->post('usuario'),
			'dtc_usu_modificacion'=>$this->tank_auth->get_user_id(),
			//'dtc_fecha_creacion'=>$creacion,
			'dtc_fecha_modificacion'=>date('Y-m-d H:i:s')
		);
		//die(print_r($solicitud_dtc));
		$ingresar_detalle=$this->gsatelite->actualizar_array('dtc_detalle_ticket_combustible', $solicitud_dtc, array('dtc_id'=>$_POST['detalle']));
		
		
	//----Eliminar el detalle del destino por solicitud-----
        $this->gsatelite->borrado_general('ddt_detalle_destino',array('ddt_id_dtc'=>$this->input->post('detalle')));
    //-----------------------------------------------------
        $creacion= date_format($this->input->post('fecha_creacion'),'Y-m-d H:i:s');
		if($this->input->post('oficina')){
			$cant_detalle=count($this->input->post('detalle_fecha'));
			$destino=$this->input->post('detalle_destino');
			$actividad=$this->input->post('detalle_actividad');
			$contacto=$this->input->post('detalle_contacto');
			$kilo=$this->input->post('detalle_kilo');
			$fe_det=$this->input->post('detalle_fecha');
			for ($i=0; $i < $cant_detalle; $i++) { 
				
				if($fe_det[$i] != '' || $fe_det[$i] != null){  
					$kilometraje= number_format($kilo[$i],2);
					$fecha_det=date('Y-m-d', strtotime($fe_det[$i]));
				$detalle_destino=array(
					'ddt_id_dtc'=>$this->input->post('detalle'),
					'ddt_destino'=>$destino[$i],
					'ddt_actividad'=>$actividad[$i],
					'ddt_persona_contacto'=>$contacto[$i],
					'ddt_kilometraje'=>$kilometraje,
					'ddt_fecha_destino'=>$fecha_det,
					'ddt_estado'=>1,
					'ddt_usu_creacion'=>$this->input->post('usuario'),
					'ddt_usu_modificacion'=>$this->tank_auth->get_user_id(),
					'ddt_fecha_creacion'=>$creacion,
					'ddt_fecha_modificacion'=>date('Y-m-d H:i:s')
				);
				$this->gsatelite->ingresar('ddt_detalle_destino',$detalle_destino);
				}
			}
		}


		//----Eliminar el detalle del destino por solicitud-----
        	$this->gsatelite->borrado_general('dtf_detalle_factura',array('dtf_id_dtc'=>$this->input->post('detalle')));
    	//-----------------------------------------------------
		if($this->input->post('detalle_fecha_fac')){
			$cantidad_fac=count($this->input->post('detalle_fecha_fac'));
			$factura=$this->input->post('detalle_factura');
			$galones=$this->input->post('detalle_galones');
			$precio_fac=$this->input->post('detalle_precio');
			$subt_fac=$this->input->post('detalle_subtotal');
			$fecha_fac=$this->input->post('detalle_fecha_fac');
			

			for ($j=0; $j < $cantidad_fac; $j++) { 
				$galon= number_format($galones[$j],2);
				$precio= number_format($precio_fac[$j],2);
				$subtotal= number_format($subt_fac[$j],2);
				$fecha_factura=date('Y-m-d H:i:s', strtotime($fecha_fac[$j]));
				$detalle_factura=array(
					'dtf_id_dtc'=>$this->input->post('detalle'),
					'dtf_fecha_factura'=>$fecha_factura,
					'dtf_numero_factura'=>$factura[$j],
					'dtf_galones'=>$galon,
					'dtf_precio'=>$precio,
					'dtf_subtotal'=>$subtotal,
					'dtf_estado'=>1,
					'dtf_usu_creacion'=>$this->input->post('usuario'),
					'dtf_usu_modificacion'=>$this->tank_auth->get_user_id(),
					'dtf_fecha_creacion'=>$creacion,
					'dtf_fecha_modificacion'=>date('Y-m-d H:i:s')
				);
				//die(print_r($detalle_factura));
				$this->gsatelite->ingresar('dtf_detalle_factura',$detalle_factura);
				}
			}

		
		// Guardar los Anexos
			$rutas 		= $this->input->post("ruta");
			$carpeta 	= $this->input->post("nombreCarpeta");
			if (count($rutas) > 0) {
				$carpeta = $carpeta;
				for ($j = 0; $j < count($rutas); $j++) {
					if ($rutas[$j] != "") {
						$img = $rutas[$j];
						//die(print_r($rutas[$j]));
						$titulo = $this->input->post("titulo_doc" . $j);
						$this->datos_imagen_gral($img,$carpeta,$titulo, $this->input->post('tkt_id'));
				//die(print_r($img));
					}
				}
			} // End guardar anexos


				//die(print_r($detalle_destino));

		if($ingresar_detalle>0){
			$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Ingreso de solicitud",'texto_alerta'=>"El registro se guardó correctamente.");  
		} else {
			$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Ingreso de solicitud",'texto_alerta'=>"El registro no se guardó.");  
		}
			$this->session->set_flashdata($alerta); 

			$boton=$this->input->post('tipo_btn');
			$id=$this->input->post('tkt_id');
		if ($boton==1) {
			redirect('/transporte/procesos/editar_solicitud_combustible/'.$id);
		}else if($boton==2){
			redirect('/transporte/procesos/solicitud_combustible');
		}
	}



	// function facturas(){
	// 	satelite_validar();
	// 		$datos['titulo_personal']="Facturas";
	// 	 $this->gsatelite->cargar_vista_masterpage('transporte/procesos/facturas',$datos);
	// }



	//======================================================================
// INICIO DE CALLBACKS
//======================================================================
	function _log_usuario_insert($post_array)
	{
		reset($post_array);
	    $sufijo = explode("_", key($post_array));
	    $post_array[$sufijo[0] . '_usu_modificacion'] = $this->tank_auth->get_user_id();
		$post_array[$sufijo[0] . '_fecha_modificacion'] = date('Y-m-d H:i:s');
		$post_array[$sufijo[0] . '_usu_creacion'] = $this->tank_auth->get_user_id();
		$post_array[$sufijo[0] . '_fecha_creacion'] = date('Y-m-d H:i:s');
  		return $post_array;
	}

	function _log_usuario_update($post_array)
	{
	    reset($post_array);
	    $sufijo = explode("_", key($post_array));
		$post_array[$sufijo[0] . '_usu_modificacion'] = $this->tank_auth->get_user_id();
		$post_array[$sufijo[0] . '_fecha_modificacion'] = date('Y-m-d H:i:s');
		return $post_array;
	}

	function prueba_server() {
		
    echo phpinfo();
	//$r =	$this->gsatelite->user_active_directory('rene.castaneda','Nuevo1010');
 	//	print_r($r); die();

	}


function enviar_correo_mantto($id=null){
	if($id!=null) {
		$info=$this->entradas_model->get_info_mantto($id);
		$correo=$this->gsatelite->get_parametro('SYS_CORREO_MANTTO');
		$envia_correo=$this->gsatelite->get_parametro('CORREO_ADMIN');
		$id_llantas=$this->gsatelite->get_parametro('SYS_MANTTO_LLANTAS');

		$fecha_sugerida=date('d-m-Y', strtotime($info[0]['dtm_fecha_sugerida']));
		$hora_sugerida=date("h:i A", strtotime($info[0]['dtm_hora_sugerida']));
		$id_usu=$this->tank_auth->get_user_id();
		$id_emp=$this->gsatelite->get_campo('users', 'usu_id_emp', array('id'=>$id_usu));
		$emp=$this->gsatelite->get_tabla('emp_empleado', array('emp_id'=>$id_emp));
		$empleado=$emp[0]['emp_nombre'].' '.$emp[0]['emp_apellido'];

	/********* Tabla de solicitud de mantenimiento ***************/
		$msj.="<p>Estimado usuario</p>
			   <p>Por este medio se le da a conocer la información de la nueva solicitud pendiente de revisar.</p>";
		$msj.="<table cellspacing='0' cellpadding='1' align='center'>";
		$msj.="<tr><th style='border:black 2px solid; background-color:#A5BBE9'>Tipo de solicitud</th>";
		if($info[0]['tsm_id']==$id_llantas){
			$msj.="<th style='border:black 2px solid; background-color:#A5BBE9'>Cantidad</th>";
		}
		$msj.="<th style='border:black 2px solid; background-color:#A5BBE9'>Placa de vehículo</th>";
		$msj.="<th style='border:black 2px solid; background-color:#A5BBE9'>Tipo de fondo</th>";
		$msj.="<th style='border:black 2px solid; background-color:#A5BBE9'>Detalle de suministro o servicio</th>";
		$msj.="<th style='border:black 2px solid; background-color:#A5BBE9'>Fecha sugerida de servicio</th>";
		$msj.="<th style='border:black 2px solid; background-color:#A5BBE9'>Hora sugerida</th>";
		$msj.="</tr>";

		$msj.="<tr><td style='border:black 2px solid; text-align:center;'>".$info[0]['tsm_nombre']."</td>";
		if($info[0]['tsm_id']==$id_llantas){
			$msj.="<td style='border:black 2px solid; text-align:center;'>".$info[0]['dtm_cantidad']."</td>";
		}
		$msj.="<td style='border:black 2px solid; text-align:center;'>".$info[0]['veh_placa'].' - '.$info[0]['mdv_nombre']."</td>";
		$msj.="<td style='border:black 2px solid; text-align:center;'>".$info[0]['tpf_nombre']."</td>";
		$msj.="<td style='border:black 2px solid; text-align:center;'>".$info[0]['dtm_detalle_suministro']."</td>";
		$msj.="<td style='border:black 2px solid; text-align:center;'>".$fecha_sugerida."</td>";
		$msj.="<td style='border:black 2px solid; text-align:center;'>".$hora_sugerida."</td>";
		$msj.="</tr>";
		$msj.="</table>";
	/*************************************************************/

	$asunto = "Solicitud de mantenimiento";
	$mensaje=$msj;

	$estado =  $this->gsatelite->envio_correo($envia_correo,$empleado,$correo,$asunto,$mensaje,'',null);
	if($estado) {
		return 1;	
	}
	
	} else {
		return 0;
	}
}

/**
 * Descripción:
 * Función para gestionar los mantenimiento a los vehículos
 * @author René Castaneda - Grupo Satélite
 * @since 2020-12-03
 * @param ninguno
 * @return view
 */

function mantenimiento_veh($id_veh = 0, $id_modal=null) {
    satelite_validar();
    $id_veh_url = $id_veh;
    $crud = new grocery_CRUD();
    $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
    $permisos = $this->gsatelite->get_permisos_opcion('mantenimiento_veh');

    $id_veh = ($id_modal > 0 && is_numeric($id_veh_url))? $id_modal:$id_veh;
    $where_mtto = array();
    if ($id_veh > 0 ) {
    	$where_mtto['gmt_id_veh'] = $id_veh;
    }
    if ($_POST) {
    	if ($this->input->post('slcVehiculo') > 0) {
    		$where_mtto['gmt_id_veh'] = $this->input->post('slcVehiculo');
    	}
    	if ($this->input->post('txtFecha_desde') != '') {
    		$where_mtto['DATE(gmt_fecha) >='] = formatear_fecha('Y-m-d', $this->input->post('txtFecha_desde'));
    	}
    	if ($this->input->post('txtFecha_hasta') != '') {
    		$where_mtto['DATE(gmt_fecha) <='] = formatear_fecha('Y-m-d', $this->input->post('txtFecha_hasta'));
    	}
    	if ($this->input->post('slcEstado') > 0) {
    		$where_mtto['gmt_id_emt'] = $this->input->post('slcEstado');
    	}
    		
    }

    $opm_array = array();
    		  $this->db->join('tmn_tipo_mantto', 'tmn_id=opm_id_tmn');
    $opmReg = $this->gsatelite->get_tabla('opm_operacion_mantto', array('opm_estado' => 1));
    foreach ($opmReg as $f) {
        $opm_array[$f['opm_id']] = $f['tmn_nombre'] . " - " . $f['opm_nombre'];
    }
    $data['id_modal'] = $id_modal;

    if ($id_modal > 0 && is_numeric($id_veh_url)) {
    	$where_veh['veh_id'] = $id_modal;
    } else {
    	$where_veh['veh_estado'] = 1;
    }

    $selected = ($where_mtto['gmt_id_veh'] > 0)? $where_mtto['gmt_id_veh']:null;
    					   $this->db->join('mrv_marca', 'mrv_id=veh_id_mrv', 'left');
    					   $this->db->join('mdv_modelo_veh', 'mdv_id=veh_id_mdv','left');
    $data['slcVehiculo'] = $this->gsatelite->get_dropdown('veh_vehiculo', '{veh_placa} / {mrv_nombre} / {mdv_nombre}', '', $where_veh, $selected, '', 'veh_id', true);

    $selected = ($where_mtto['gmt_id_emt'] > 0)? $where_mtto['gmt_id_emt']:null;
    $data['slcEstado'] = $this->gsatelite->get_dropdown('emt_estado_mantenimiento', '{emt_nombre}', '', array('emt_estado'=>1), $selected, '', 'emt_id', true);

    $crud->set_table('gmt_gestion_mantto');
    $crud->set_subject('Mantenimiento');
    $this->load->config('grocery_crud');
    $this->config->set_item('grocery_crud_file_upload_allow_file_types','pdf|jpeg|jpg|png|doc|xls|ppt|docx|xlsx|pptx');

    $id_veh = ($id_veh > 0) ? $id_veh:0;

    $data['id_veh'] = $id_veh;
    $columns = array(
        'gmt_id_veh',
        'gmt_id_opm',
        'gmt_fecha',
        'gmt_fecha_prox',
        'gmt_kilometraje',
        'ult_kilometraje',
        'gmt_reporte',
        'gmt_total_factura',
        'gmt_id_emt'
    );

    $display_as = array(
    	'gmt_id_veh'=>'Vehículo',
    	'gmt_id_opm'=>'Operación',
    	'gmt_id_emt'=>'Estado Mtto.',
    	'gmt_fecha'=>'Fecha',
    	'gmt_fecha_prox'=>'Próximo (sugerido)',
    	'gmt_kilometraje'=>'Kilometraje',
    	'ult_kilometraje'=>'Ult. Kilometraje',
    	'gmt_reporte'=>'Reporte',
    	'gmt_id_prv'=>'Proveedor',
    	'gmt_factura'=>'Factura',
    	'gmt_total_factura'=>'Costo',
    	'gmt_observacion'=>'Observación',
    	'gmt_anexo'=>'Anexo',
    	'gmt_estado'=>'Estado',
    );

    $required = array(
        'gmt_id_veh',
        'gmt_id_opm',
        'gmt_id_emt',
        'gmt_fecha',
        'gmt_reporte',
        'gmt_estado'
    );

    $add_columns = array(
    	'gmt_id_veh',
    	'gmt_id_opm',
    	'gmt_id_emt',
    	'gmt_fecha',
    	'gmt_fecha_prox',
    	'gmt_kilometraje',
    	'gmt_reporte',
    	'gmt_id_prv',
    	'gmt_factura',
    	'gmt_total_factura',
    	'gmt_observacion',
    	'gmt_anexo',
        'gmt_estado',
        'gmt_fecha_creacion',
        'gmt_usu_creacion',
        'gmt_fecha_modificacion',
        'gmt_usu_modificacion'
    );

    $edit_columns = array(
    		'gmt_id_veh',
    		'gmt_id_opm',
    		'gmt_id_emt',//considerar quitar y solo se modifique desde seguimiento
    		'gmt_fecha',
    		'gmt_fecha_prox',
    		'gmt_kilometraje',
    		'gmt_reporte',
    		'gmt_id_prv',
    		'gmt_factura',
    		'gmt_total_factura',
    		'gmt_observacion',
    		'gmt_anexo',
    	    'gmt_estado',
    	    'gmt_fecha_modificacion',
    	    'gmt_usu_modificacion'
    );

    if (count($where_mtto) > 0) {
    	$crud->where($where_mtto);
    } else {
    	if (!$_POST) {
    		$crud->where('gmt_id',0);
    	} 
    }

    $where_slcVeh['veh_estado'] = 1;
    if ($where_veh['veh_id'] > 0) {
    	$where_slcVeh['veh_id'] = $where_veh['veh_id'];
    }

    $crud->columns($columns);
    $crud->display_as($display_as);
    $crud->required_fields($required);
    $crud->add_fields($add_columns);
    $crud->edit_fields($edit_columns);
    $crud->set_relation('gmt_id_veh', 'veh_vehiculo', 'veh_placa', $where_slcVeh);
   //$crud->set_relation('gmt_id_opm', 'opm_operacion_mantto', 'opm_nombre', array('opm_estado' => 1));
    $crud->field_type('gmt_id_opm', 'dropdown', $opm_array);
    $crud->set_relation('gmt_id_prv', 'prv_proveedor', '{prv_nombre} {prv_apellido}', array('prv_estado' => 1));
    if ($accion == 'add' || $accion == 'edit') {
    $crud->set_relation('gmt_id_emt', 'emt_estado_mantenimiento', '{emt_orden} {emt_nombre}', array('emt_estado' => 1));
    }
    $crud->field_type('gmt_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
    $crud->field_type('gmt_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
    $crud->field_type('gmt_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
    $crud->field_type('gmt_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
    $crud->field_type('gmt_fecha_prox', 'hidden');
    $crud->set_field_upload('gmt_anexo','uploads/anexos_mantto_veh');

    $crud->unset_export();
    $crud->unset_print();
    $crud->callback_column('gmt_id_emt', function($value, $row) {
    		$return = '';
    	    if($row->gmt_id_emt > 0){
    	    	$reg = $this->gsatelite->get_tabla('emt_estado_mantenimiento',array('emt_id'=>$row->gmt_id_emt));
    	    	$color_ = (trim($reg[0]['emt_color_indicador']) !='')? $reg[0]['emt_color_indicador']:'#ffffff';
    	    	$return = '<span class="estadoMtto" color="'.$color_.'">'.$reg[0]['emt_nombre'].'</span>';
    	    }
    	    return $return; 
    });
    $crud->callback_column('gmt_fecha', function($value, $row) {
    	    return ($row->gmt_fecha)? formatear_fecha('Y-m-d', $row->gmt_fecha):'';
    });
    $crud->callback_column('gmt_fecha_prox', function($value, $row) {
    	    return ($row->gmt_fecha_prox)? formatear_fecha('Y-m-d', $row->gmt_fecha_prox):'';
    });
    $crud->callback_column('ult_kilometraje', function($value, $row) {
    			$this->db->order_by('rev_fecha','DESC');
    			$this->db->limit(1);
    	   $q = $this->gsatelite->get_tabla('rev_registro_vehiculo',array('rev_id_veh'=>$row->gmt_id_veh));
    	    return ($q)? $q[0]['rev_km_final']:'';
    });
    $crud->callback_before_insert(function($post_array, $primary_key) {
    	$next = null;
        if ($post_array['gmt_id_opm'] > 0) {
        	$reg_ = $this->gsatelite->get_tabla('opm_operacion_mantto',array('opm_id'=>$post_array['gmt_id_opm']));
        	$reg_est = $this->gsatelite->get_tabla('emt_estado_mantenimiento',array('emt_id'=>$post_array['gmt_id_emt']));
        	if ($reg_ && $reg_[0]['opm_tipo_recurrencia'] == 1 
        		&& $post_array['gmt_fecha'] != '' 
        		&& $reg_[0]['opm_valor_recurrencia'] > 0
        		&& $reg_est[0]['emt_seguimiento_prox'] == 1 
        		) {
        		$date = new DateTime($post_array['gmt_fecha']);
        		$date->modify('+'.intval($reg_[0]['opm_valor_recurrencia']).' day');
        		$next = $date->format('Y-m-d');
        	}
        }
        $post_array['gmt_fecha_prox'] = $next;
        return   $post_array; 
    })
    ->callback_before_update(function($post_array, $primary_key) {
    		$next = null;
    	    if ($post_array['gmt_id_opm'] > 0) {
    	    	$reg_ = $this->gsatelite->get_tabla('opm_operacion_mantto',array('opm_id'=>$post_array['gmt_id_opm']));
    	    	$reg_est = $this->gsatelite->get_tabla('emt_estado_mantenimiento',array('emt_id'=>$post_array['gmt_id_emt']));
    	    	if ($reg_ && $reg_[0]['opm_tipo_recurrencia'] == 1 
    	    		&& $post_array['gmt_fecha'] != ''
    	    		&& $reg_[0]['opm_valor_recurrencia'] > 0 
    	    		&& $reg_est[0]['emt_seguimiento_prox'] == 1 
    	    		) {
    	    		$date = new DateTime($post_array['gmt_fecha']);
    	    		$date->modify('+'.intval($reg_[0]['opm_valor_recurrencia']).' day');
    	    		$next = $date->format('Y-m-d');
    	    	}
    	    }
    	    $post_array['gmt_fecha_prox'] = $next;   
    	    return   $post_array;  
    })
    ->callback_after_insert(function($post_array, $primary_key) {
            if ($post_array['gmt_id_emt'] > 0) {
            	$array_insert = array(
            		'smv_id_gmt'=>$primary_key,
            		'smv_id_emt'=>$post_array['gmt_id_emt'],
            		'smv_seguimiento'=>$post_array['gmt_reporte'],
            		'smv_fecha'=>$post_array['gmt_fecha'],
            		'smv_estado'=>1,
            		'smv_usu_creacion'=>$this->tank_auth->get_user_id(),
            		'smv_fecha_creacion'=>date('Y-m-d H:i:s'),
            		'smv_usu_modificacion'=>$this->tank_auth->get_user_id(),
            		'smv_fecha_modificacion'=>date('Y-m-d H:i:s')
            	);
            $this->gsatelite->ingresar('smv_seguimiento_mtto_veh',$array_insert);
            }
            return   true; 
        })
        ->callback_after_update(function($post_array, $primary_key) {
        	if ($post_array['gmt_id_emt'] > 0) {
        				   $this->db->order_by('smv_id','DESC');
        				   $this->db->limit(1);
        		$reg_seg = $this->gsatelite->get_tabla('smv_seguimiento_mtto_veh',array('smv_id_gmt'=>$primary_key));
        		if ($reg_seg && $reg_seg[0]['gmt_id_emt'] != $post_array['gmt_id_emt']) { //si es otro estado agregar otro seguimiento
            		$array_insert = array(
	        			'smv_id_gmt'=>$primary_key,
	        			'smv_id_emt'=>$post_array['gmt_id_emt'],
	        			'smv_seguimiento'=>$post_array['gmt_reporte'],
	        			'smv_fecha'=>$post_array['gmt_fecha'],
	        			'smv_estado'=>1,
	        			'smv_usu_creacion'=>$this->tank_auth->get_user_id(),
	        			'smv_fecha_creacion'=>date('Y-m-d H:i:s'),
	        			'smv_usu_modificacion'=>$this->tank_auth->get_user_id(),
	        			'smv_fecha_modificacion'=>date('Y-m-d H:i:s')
	        		);
	        	$this->gsatelite->ingresar('smv_seguimiento_mtto_veh',$array_insert);
        		}
        	}
        	return   true; 
        });
    
    if ($accion == 'add') {
        $crud->field_type('gmt_estado', 'hidden', 1);
    } else {
        $crud->field_type('gmt_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
    }
	if (!($id_modal > 0 && is_numeric($id_veh_url))){
    	$crud->add_action(' Seguimiento', '', 'transporte/procesos/seguimiento_mtto','silk-icon-checklist ver_en_modal');
    }
    // Validaciones
    if (!$permisos['permite_agregar']) {
        $crud->unset_add();
    }
    if (!$permisos['permite_editar']) {
        $crud->unset_edit();
    }
    if (!$permisos['permite_eliminar']) {
        $crud->unset_delete();
    }
    if (!$permisos['permite_ver']) {
        $crud->unset_read();
    }
/*    if ($id_veh <= 0) {
    	$crud->unset_add();
    	$crud->unset_edit();
    	$crud->unset_delete();
    	$crud->unset_read();
    }*/
    $output = $crud->render();

    $data['titulo_personal'] = "Mantenimiento vehículo";
    if ($id_modal > 0 && is_numeric($id_veh_url)) {
     	cargarvista_modal($data, $output);
     }
    else {
    	cargarvista($data, $output);
    }
} //Fin mantenimiento vehiculo

/**
 * Descripción:
 * Función para gestionar seguimiento de los mantenimiento de vehículos
 * @author René Castaneda - Grupo Satélite
 * @since 2021-10-01
 * @param $id_mtto int
 * @return view
 */
function seguimiento_mtto($id_mtto=0) {
    satelite_validar();
    try {
    			   $this->db->order_by('smv_id','DESC');
    			   $this->db->limit(1);
    	$reg_seg = $this->gsatelite->get_tabla('smv_seguimiento_mtto_veh',array('smv_id_gmt'=>$id_mtto));

    				$this->db->join('opm_operacion_mantto','opm_id=gmt_id_opm','left');
    	$reg_mtto = $this->gsatelite->get_tabla('gmt_gestion_mantto',array('gmt_id'=>$id_mtto));
		if ($reg_seg && $reg_seg[0]['smv_id_emt'] != $reg_mtto['gmt_id_emt']) { //si es otro estado realizar un update
    		$array_update = array(
    			'gmt_id_emt'=>$reg_seg[0]['smv_id_emt'],
    			'gmt_usu_modificacion'=>$this->tank_auth->get_user_id(),
    			'gmt_fecha_modificacion'=>date('Y-m-d H:i:s')
    		);
    	$this->gsatelite->actualizar_array('gmt_gestion_mantto',$array_update,array('gmt_id'=>$id_mtto));
		}

		$data['reg_mtto'] = $reg_mtto[0];

							   $this->db->join('mrv_marca', 'mrv_id=veh_id_mrv', 'left');
							   $this->db->join('mdv_modelo_veh', 'mdv_id=veh_id_mdv','left');
		$Vehiculo = $this->gsatelite->get_tabla('veh_vehiculo', array('veh_id'=>$reg_mtto[0]['gmt_id_veh']));
		$data['Vehiculo'] = $Vehiculo[0];

        $crud = new grocery_CRUD();
        $permisos = $this->gsatelite->get_permisos_opcion('mantenimiento_veh');

        $this->load->config('grocery_crud');
        $this->config->set_item('grocery_crud_file_upload_allow_file_types','pdf|jpeg|jpg|png|doc|xls|ppt|docx|xlsx|pptx');
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        //Columnas a mostrar en READ
        $columns = array(
            'smv_fecha',
            'smv_seguimiento',
            'smv_id_emt',
            'smv_fecha_prox',
        );

        //Alias para las columnas
        $alias = array(
            'smv_fecha' => 'Fecha',
            'smv_estado' => 'Estado',
            'smv_id_emt' => 'Estado Mtto',
            'smv_seguimiento' => 'Seguimiento',
            'smv_fecha_prox' => 'Prox. seguimiento',
            'smv_anexo' => 'Anexo'
        );


        //Columnas a mostrar en ADD
        $add_columns = array(
            'smv_fecha',
            'smv_id_emt',
            'smv_id_gmt',
            'smv_seguimiento',
            'smv_fecha_prox',
            'smv_anexo',
            'smv_estado',
            'smv_fecha_creacion',
            'smv_usu_creacion',
            'smv_fecha_modificacion',
            'smv_usu_modificacion',
        );

        $required_fields = array(
            'smv_fecha',
            'smv_seguimiento',
            'smv_id_gmt',
            'smv_id_emt',
        );

        //Columnas a mostrar en EDIT
        $edit_columns = $add_columns;

        $crud->set_table('smv_seguimiento_mtto_veh')
                ->set_subject('')
                ->where('smv_id_gmt',$id_mtto)
                ->columns($columns)
                ->display_as($alias)
                ->add_fields($add_columns)
                ->edit_fields($edit_columns)
                ->required_fields($required_fields)
                ->field_type('smv_id_gmt', 'hidden', $id_mtto)
                ->field_type('smv_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('smv_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('smv_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('smv_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ;
         if ($accion == 'add' || $accion == 'edit') {
         	$crud->set_relation('smv_id_emt', 'emt_estado_mantenimiento', '{emt_orden} {emt_nombre}', array('emt_estado' => 1));
         }
         $crud->callback_column('smv_id_emt', function($value, $row) {
         		$return = '';
         	    if($row->smv_id_emt > 0){
         	    	$reg = $this->gsatelite->get_tabla('emt_estado_mantenimiento',array('emt_id'=>$row->smv_id_emt));
         	    	$color_ = (trim($reg[0]['emt_color_indicador']) !='')? $reg[0]['emt_color_indicador']:'#ffffff';
         	    	$return = '<span class="estadoMtto" color="'.$color_.'">'.$reg[0]['emt_nombre'].'</span>';
         	    }
         	    return $return; 
         });
        $crud->set_field_upload('smv_anexo','uploads/anexos_seguimiento_mantto_veh');
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('smv_estado', 'hidden', 1);
        } else {
            $crud->field_type('smv_estado', 'dropdown', array('1' => 'Activado', '0' => 'Inactivo'));
        }

        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        $output = $crud->render();

        $data['titulo_personal'] = 'Seguimiento de mantenimiento veh.';
        cargarvista_modal($data, $output);
    } catch (Exception $e) {
        show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
    }
    
}
	/**
	 * Descripción:
	 * Función para validar el kilometraje
	 * @author René Castaneda - Grupo Satélite
	 * @since 2021-07-01
	 * @param $idVeh int
	 * @return json
	 */
	function get_kilometraje_veh($idVeh=0)
	{
		$idVeh = (isset($_POST['id_veh']))? $_POST['id_veh']: $idVeh;
		$respuesta['km'] = 0;
		if ($idVeh > 0) 
		{
			$q = $this->gsatelite->get_max('rev_registro_vehiculo','rev_km_final', array('rev_id_veh'=>$idVeh, 'rev_estado'=>1)); 
			$respuesta['km'] = ($q)? round($q,2):0;
		}
		$respuesta['km_f'] = number_format($respuesta['km'],2); 
		die(json_encode($respuesta));
	}

	function _cargarvista($data=0,$crud=0, $modulo_principal=null)
	{ 
	    $this->load->view('vacia',$crud); 
	    if($data!=0)
	      $data=array_merge($data,$this->masterpage->getUsuario($modulo_principal));
	    else
	      $data=$this->masterpage->getUsuario($modulo_principal);  
	     
	    $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
	    $this->masterpage->setMasterPage('masterpage_default');
	    $this->masterpage->addContentPage($vista, 'content',$data);
	    $this->masterpage->show();
	}

} // End Controller Procesos
