<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Inicio_trans extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->helper('url');
        $this->load->model('entradas_model');
        $this->load->model('gsatelite2');
        $this->load->library('grocery_CRUD');
    }

    // All your functions goes here

    public function gestion_solicitud(){
        satelite_validar();
        try {

            if ($_POST){

                $fecha_inicio = !empty($_POST['fecha_inicio']) ? date('Y-m-d', strtotime($_POST['fecha_inicio'])) : null;
                $fecha_fin = !empty($_POST['fecha_fin']) ? date('Y-m-d', strtotime($_POST['fecha_fin'])) : null;
                $solicitante = !empty($_POST['usuario']) ? $_POST['usuario'] : 0;
                $destino = !empty($_POST['destino']) ? $_POST['destino'] : null;
                $estatus = !empty($_POST['estatus']) ? $_POST['estatus'] : null;
                $tipo_consulta = $_POST['tipo_soli'];

                $data['detalle_ticket'] = $this->entradas_model->get_all_tickets($fecha_inicio, $fecha_fin, $solicitante, $destino, $estatus, $tipo_consulta);
                //print_r($this->db->last_query()); exit();
                $html = $this->load->view('transporte/inicio_trans/tabla_tickets', $data, true);
                //die(print_r($data['detalle_ticket'],true));
                // Arreglar los filtros
                echo json_encode(array('resultado' => $html));
            }
            else{
                // Show the view
                $this->load->model('gsatelite2');
                $data['users'] = $this->gsatelite2->get_dropdown('users', '{username}', '', array('activated' =>1), null, null, 'id', true);
                $data['usuarios'] = $this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), null, '', 'emp_id', true);
                $data['destiono_ticket'] = $this->gsatelite->get_dropdown('ubt_ubicacion_tarea', '{ubt_nombre}', '', array('ubt_estado' => '1'), null, '', 'ubt_id', true);
                $data['status_ticket'] = $this->gsatelite->get_dropdown('esk_estado_ticket', '{esk_nombre}', '', array('esk_estado' => '1'), null, '', 'esk_id', true);
                $data['titulo_personal'] = "Gestión de solicitud";
                $this->_cargarvista($data, null);
            }
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

// End gestion_solicitudes

    public function editar_ticket($id_ticket = null) {
        satelite_validar();
        if ($_POST) {
            
            $detalle_ticket_array = array(
                'dtt_hora_salida' => date('H:i:s', strtotime($this->input->post('time'))),
                'dtt_fecha_salida' => date('Y-m-d', strtotime($this->input->post('fecha_salida'))),
                'dtt_cantidad_per' => $this->input->post('cantidad_personas'),
                'dtt_encargado' => $this->input->post('encargado_mision'),
                'dtt_num_contacto' => $this->input->post('tel_contacto'),
                'dtt_acompanante' => (!empty($_POST['acompaniante']))? $this->input->post('acompaniante') : null,
                'dtt_descripcion' => $this->input->post('desc_corta'),
                'dtt_actividad' => ($this->input->post('destino_actividad'))?$this->input->post('destino_actividad'):'',
                'dtt_usu_modificacion' => $this->tank_auth->get_user_id(),
                'dtt_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            
            $this->gsatelite->actualizar_array('tkt_ticket',array('tkt_id_esk'=>$this->input->post('estado')),array('tkt_id'=>$_POST['id_ticket']));
            $this->gsatelite->actualizar_array('dtt_detalle_ticket_trans', $detalle_ticket_array, array('dtt_id_tkt' => $_POST['id_ticket']));
            
            // Eliminar los destinos anteriores
            $num_borrados = $this->gsatelite->borrado_general('uxt_ubicaxticket', array('uxt_id_dtt' => $_POST['id_detalle_ticket']));

            if ($num_borrados > 0) {
                // Ingresar los destino
                $destinos = $_POST['destino'];

                for ($i = 0; $i < count($destinos); $i++) {
                    if (!empty($destinos[$i])) {
                        $ubicacion_array = array(
                            'uxt_id_ubt' => $destinos[$i],
                            'uxt_id_dtt' => $_POST['id_detalle_ticket'],
                            'uxt_estado' => 1,
                            'uxt_usu_creacion' => $this->tank_auth->get_user_id(),
                            'uxt_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'uxt_fecha_creacion' => date('Y-m-d H:i:s'),
                            'uxt_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('uxt_ubicaxticket', $ubicacion_array);
                    }
                }
            } // End ubicaciones 
            // Ingresar el registro gtr_gestion_transporte

            $gestion_array = array(
                'gtr_id_veh' => $this->input->post('placas'),
                'gtr_id_mot' => $this->input->post('motoristas'),
                'gtr_id_tkt' => $this->input->post('id_ticket'),
                'gtr_id_esk' => $this->input->post('estado'),
                'gtr_id_autoriza' => $this->input->post('autoriza'),
                'gtr_descripcion' => $this->input->post('observaciones'),
                'gtr_estado' => 1,
                'gtr_modo_combustible' => $this->input->post('combustible'),
                'gtr_usu_modificacion' => $this->tank_auth->get_user_id(),
                'gtr_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            if (!empty($_POST['gtr_id'])) {
                $this->gsatelite->actualizar_array('gtr_gestion_transporte', $gestion_array, array('gtr_id' => $_POST['gtr_id']));
                $id_gtr = $_POST['gtr_id'];
            } else {
                $gestion_array['gtr_usu_creacion'] = $this->tank_auth->get_user_id();
                $gestion_array['gtr_fecha_creacion'] = date('Y-m-d H:i:s');
                $id_gtr = $this->gsatelite->ingresar('gtr_gestion_transporte', $gestion_array);
            }

            // Ingresar los vales por gestion transporte
            if ($id_gtr > 0 && $_POST['combustible'] == 2) {

                $series = $this->input->post('series');
                $cantidad = $this->input->post('cantidad');
                $inicio = $this->input->post('inicio');
                $fin = $this->input->post('fin');
                $valor = $this->input->post('valor');

                // Si esa serie ya fue utilizada no Eliminarlo. (Pendiente)
                $num_borrados = $this->gsatelite->borrado_general('vxg_valexgestion_trans', array('vxg_id_gtr' => $id_gtr));

                for ($i = 0; $i < count($series); $i++) {
                    if (!empty($series[$i])) {

                        $vales_array = array(
                            'vxg_id_gtr' => $id_gtr,
                            'vxg_id_srv' => $series[$i],
                            'vxg_inicio' => $inicio[$i],
                            'vxg_fin' => $fin[$i],
                            'vxg_estado' => 1,
                            'vxg_fecha_creacion' => date('Y-m-d H:i:s'),
                            'vxg_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'vxg_usu_creacion' => $this->tank_auth->get_user_id(),
                            'vxg_usu_modificacion' => $this->tank_auth->get_user_id()
                        );

                        $this->gsatelite->ingresar('vxg_valexgestion_trans', $vales_array);
                    }
                } // End for	
            }

            // Guardar los Anexos
            $rutas = $this->input->post("ruta");
            $carpeta = $this->input->post("nombreCarpeta");

            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $this->input->post("titulo_doc" . $i);
                        $this->datos_imagen_gral($img, $this->input->post('id_ticket'), $carpeta, $titulo);
                    }
                }
            } // End guardar anexos

            if ($id_gtr > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se guardó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Error de inserción", 'texto_alerta' => "El registro no pudo guardarse");
            }
            $this->session->set_flashdata($alerta);
            redirect('transporte/inicio_trans/gestion_solicitud');
        } else {
            // Your code goes here to show the view

            $detalle_ticket = $this->entradas_model->get_detalle_ticket(null, null, $id_ticket);
            $data['detalle_ticket'] = $detalle_ticket[0];
            
            $ticket_edicion = $this->entradas_model->get_detalle_ticket_edicion($id_ticket);
            $data['ticket_edicion'] = !empty($ticket_edicion) ? $ticket_edicion[0] : '';
            if (!empty($ticket_edicion)) {
                $datos['vales_array'] = $this->entradas_model->tabla_vales_gestion($ticket_edicion[0]['gtr_id']);
                $data["html"] = $this->load->view('transporte/inicio_trans/tabla_detalle_tickets', $datos, true);
            }

            $data["anexos"] = $this->entradas_model->get_anexos($id_ticket);

            $ubicaciones = $this->gsatelite->get_tabla('uxt_ubicaxticket', array('uxt_id_dtt' => $detalle_ticket[0]['dtt_id']));
            $seleccionados = array();
            foreach ($ubicaciones as $lugar) {
                $seleccionados[] = $lugar['uxt_id_ubt'];
            }
            $items = (count($seleccionados) > 0) ? $seleccionados : null;
            $data['destinos'] = $this->gsatelite->get_dropdown('ubt_ubicacion_tarea', '{ubt_nombre}', '', array('ubt_estado' => '1'), $items, '', 'ubt_id', true);
            $data['tipo_vehiculo'] = $this->gsatelite->get_dropdown('tvh_tipo_vehiculo', '{tvh_nombre}', '', array('tvh_estado' => '1'), !empty($ticket_edicion) ? $ticket_edicion[0]['tvh_id'] : '', '', 'tvh_id', true);

            if (empty($ticket_edicion)) {
                // Manejar la asignacion de vehiculo al motorista (No mostrar el motorista que posee asignacion para ese dia)  
                //	$this->db->join('asv_asignacion_vehiculo', 'asv_id_mot = mot_id','left');
                //	$this->db->where('asv_fecha !=', date('Y-m-d'));	
            }

            $data['select_encargado'] = $this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), !empty($detalle_ticket[0]['dtt_encargado']) ? $detalle_ticket[0]['dtt_encargado'] : null, '', 'emp_id', true);
            $data['select_acompanante'] = $this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), !empty($detalle_ticket[0]['dtt_encargado']) ? $detalle_ticket[0]['dtt_acompanante'] : null, '', 'emp_id', true);
            
            $data['motoristas'] = $this->gsatelite->get_dropdown_empleado('mot_motorista', '{mot_empleado}', '', array('mot_estado' => '1'), !empty($ticket_edicion) ? $ticket_edicion[0]['gtr_id_mot'] : '', '', 'mot_id', true);
            $data['usuario_autoriza'] = $this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), !empty($ticket_edicion) ? $ticket_edicion[0]['gtr_id_autoriza'] : '', '', 'emp_id', true);
            $data['contratos'] = $this->gsatelite->get_dropdown('con_contrato_gasol', '{con_nombre}', '', array('con_estado' => '1'), null, '', 'con_id', true);
            //  $data['tipo_combustible'] = 	$this->gsatelite->get_dropdown('tpc_tipo_combustible', '{tpc_nombre}','', array('tpc_estado' => '1'), !empty($ticket_edicion)? $ticket_edicion[0]['gtr_id_tpc']:'', '', 'tpc_id', true);		
            $data['estado'] = $this->gsatelite->get_dropdown('esk_estado_ticket', '{esk_nombre}', '', array('esk_estado' => '1'), !empty($detalle_ticket) ? $detalle_ticket[0]['esk_id']: '', '', 'esk_id', true);
            
            if (!empty($ticket_edicion)) {
                $data['placas'] = $this->gsatelite->get_dropdown('veh_vehiculo', '{veh_placa}', '', array('veh_estado' => '1', 'veh_id_tvh' => $ticket_edicion[0]['tvh_id']), $ticket_edicion[0]['veh_id'], '', 'veh_id', true);
            }

            $data['titulo_personal'] = "Gestión de solicitudes para transporte";
            $this->_cargarvista($data, null);
        }
    }

// End editar ticket

    public function editar_ticket_mantto($id_ticket = null) {
        satelite_validar();

        if ($_POST) {

            //die(print_r($_POST,true));
            // Actualizar el detalle del Ticket
            $detalle_ticket_array = array(
                'dtm_id_veh' => $this->input->post('placa'),
                'dtm_id_tsm' => (!empty($_POST['tipo_solicitud'])) ? $_POST['tipo_solicitud'] : null,
                'dtm_cantidad' => $this->input->post('cantidad'),
                'dtm_detalle_suministro' => $this->input->post('detalle_suministro'),
                'dtm_fecha_sugerida' => date('Y-m-d', strtotime($this->input->post('fecha_sugerida'))),
                'dtm_hora_sugerida' => date('H:i:s', strtotime($this->input->post('time'))),
                'dtm_estado' => 1,
                'dtm_usu_modificacion' => $this->tank_auth->get_user_id(),
                'dtm_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $this->gsatelite->actualizar_array('dtm_detalle_ticket_mantto', $detalle_ticket_array, array('dtm_id_tkt' => $_POST['id_ticket']));

            // Actualizar el Ticket
            $this->gsatelite->actualizar_array('tkt_ticket', array('tkt_id_esk' => $_POST['estado']), array('tkt_id' => $_POST['id_ticket']));

            // Agregar el registro de gestion de mantenimiento
            $gestion_array = array(
                'gmt_id_dtm' => $this->input->post('id_detalle_ticket'),
                'gmt_id_con' => $this->input->post('contrato'),
                'gmt_kilometraje' => $this->input->post('kilometraje'),
                'gmt_reporte' => $this->input->post('reporte_adicional'),
                'gmt_observacion' => $this->input->post('observaciones'),
                'gmt_factura' => (!empty($_POST['factura'])) ? $this->input->post('factura') : null,
                'gmt_total_factura' => (!empty($_POST['total_factura'])) ? $this->input->post('total_factura') : null,
                'gmt_estado' => 1,
                'gmt_usu_modificacion' => $this->tank_auth->get_user_id(),
                'gmt_fecha_modificacion' => date('Y-m-d H:i:s'),
                'gmt_id_tmn' => ($this->input->post('tipo_mantto') > 0) ? $this->input->post('tipo_mantto') : null
            );

            if (!empty($_POST['gmt_id'])) {
                $this->gsatelite->actualizar_array('gmt_gestion_mantto', $gestion_array, array('gmt_id' => $_POST['gmt_id']));
                $gmt_id = $_POST['gmt_id'];
            } else {
                $gestion_array['gmt_usu_creacion'] = $this->tank_auth->get_user_id();
                $gestion_array['gmt_fecha_creacion'] = date('Y-m-d H:i:s');
                $gmt_id = $this->gsatelite->ingresar('gmt_gestion_mantto', $gestion_array);
            }

            // Eliminar las operaciones anteriores
            $num_borrados = $this->gsatelite->borrado_general('oxg_operacionxgestion', array('oxg_id_gmt' => $gmt_id));

            if ($num_borrados >= 0) {
                // Ingresar los destino
                $operaciones = $_POST['operaciones'];

                for ($i = 0; $i < count($operaciones); $i++) {
                    if (!empty($operaciones[$i])) {
                        $opc_array = array(
                            'oxg_id_opm' => $operaciones[$i],
                            'oxg_id_gmt' => $gmt_id,
                            'oxg_estado' => 1,
                            'oxg_usu_creacion' => $this->tank_auth->get_user_id(),
                            'oxg_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'oxg_fecha_creacion' => date('Y-m-d H:i:s'),
                            'oxg_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('oxg_operacionxgestion', $opc_array);
                    }
                }
            } // operaciones
            // Guardar los Anexos
            $rutas = $this->input->post("ruta");
            $carpeta = $this->input->post("nombreCarpeta");

            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $this->input->post("titulo_doc" . $i);
                        $this->datos_imagen_gral($img, $this->input->post('id_ticket'), $carpeta, $titulo);
                    }
                }
            } // End guardar anexos

            if ($gmt_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se guardó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Error de inserción", 'texto_alerta' => "El registro no pudo guardarse");
            }
            $this->session->set_flashdata($alerta);
            redirect('transporte/inicio_trans/gestion_solicitud');
        } else {
            // All your code goes here
            $detalle_ticket = $this->entradas_model->get_detalle_ticket_mantto($id_ticket);
            //die(var_dump($detalle_ticket));
            $data['detalle_ticket'] = $detalle_ticket[0];

            $ticket_edicion = $this->entradas_model->get_detalle_ticket_mantto_edicion($detalle_ticket[0]['dtm_id']);
            //die(var_dump($ticket_edicion));
            $data['ticket_edicion'] = !empty($ticket_edicion) ? $ticket_edicion : '';
            //echo $ticket_edicion['con_id_prv'];
            $data['tipo_solicitud'] = $this->gsatelite->get_dropdown('tsm_tipo_sol_mantto', '{tsm_nombre}', '', array('tsm_estado' => '1'), $detalle_ticket[0]['dtm_id_tsm'], '', 'tsm_id', true);
            $data['placas'] = $this->gsatelite->get_dropdown('veh_vehiculo', '{veh_placa}', '', array('veh_estado' => '1'), $detalle_ticket[0]['veh_id'], '', 'veh_id', true);
            $data['estado'] = $this->gsatelite->get_dropdown('esk_estado_ticket', '{esk_nombre}', '', array('esk_estado' => '1'), $detalle_ticket[0]['esk_id'], '', 'esk_id', true);
            $data['proveedor'] = $this->gsatelite->get_dropdown('prv_proveedor', '{prv_nombre}', '', array('prv_estado' => '1'), (!empty($ticket_edicion['con_id_prv'])) ? $ticket_edicion['con_id_prv'] : null, '', 'prv_id', true);
            //$data['mantenimiento'] 		= 	$this->gsatelite->get_dropdown('tmn_tipo_mantto', '{tmn_nombre}','', array('tmn_estado' => '1'), /*(!empty($ticket_edicion['gmt_id_tmn']))? $ticket_edicion['gmt_id_tmn']:*/null, '', 'tmn_id', true);
            $data['mantenimiento'] = $this->gsatelite->get_dropdown('tmn_tipo_mantto', '{tmn_nombre}', '', array('tmn_estado' => '1'), (!empty($ticket_edicion['gmt_id_tmn'])) ? $ticket_edicion['gmt_id_tmn'] : null, '', 'tmn_id', true);

            if (!empty($ticket_edicion['con_id_prv'])) {
                $data['contratos'] = $this->gsatelite->get_dropdown('con_contrato_gasol', '{con_nombre}', '', array('con_estado' => '1', 'con_id_prv' => $ticket_edicion['con_id_prv']), $ticket_edicion['con_id'], '', 'con_id', true);
            }
            $items = '';
            if (!empty($ticket_edicion)) {

                $operaciones = $this->gsatelite->get_tabla('oxg_operacionxgestion', array('oxg_id_gmt' => $ticket_edicion['gmt_id']));
                $seleccionados = array();
                foreach ($operaciones as $op) {
                    $seleccionados[] = $op['oxg_id_opm'];
                }
                $items = (count($seleccionados) > 0) ? $seleccionados : null;
            }

            $data["anexos"] = $this->entradas_model->get_anexos($id_ticket);
            $data['operaciones'] = $this->gsatelite->get_dropdown('opm_operacion_mantto', '{opm_nombre}', '', array('opm_estado' => '1'), $items, '', 'opm_id', true);

            $data['titulo_personal'] = "Gestión de solicitudes de servicio";
            $this->_cargarvista($data, null);
        }
    }

// End editar ticket mantto

    public function editar_ticket_combustible($id_ticket = null) {
        satelite_validar();
        if ($_POST) {
            //die(print_r($_POST,true));

            $detalle_ticket_array = array(
                'dtc_id_mot' => $this->input->post('motorista'),
                'dtc_periodo_desde' => date('Y-m-d', strtotime($this->input->post('periodo_desde'))),
                'dtc_periodo_hasta' => date('Y-m-d', strtotime($this->input->post('periodo_hasta'))),
                'dtc_fecha_solicitud' => date('Y-m-d', strtotime($this->input->post('fecha_solicitud'))),
                'dtc_id_emp_resp'   => $this->input->post('responsable'),
                'dtc_destino' => (!empty($_POST['destino'])) ? $_POST['destino'] : null,
                'dtc_usu_modificacion' => $this->tank_auth->get_user_id(),
                'dtc_fecha_modificacion' => date('Y-m-d H:i:s'),
                'dtc_vale_valor' => ($this->input->post('valor_vales')) ? $this->input->post('valor_vales') : null,
            );

            $this->gsatelite->actualizar_array('dtc_detalle_ticket_combustible', $detalle_ticket_array, array('dtc_id_tkt' => $_POST['id_ticket']));

            // Actualizar el Ticket
            $this->gsatelite->actualizar_array('tkt_ticket', array('tkt_id_esk' => $_POST['estado']), array('tkt_id' => $_POST['id_ticket']));

            // Ingresar el registro gtr_gestion_transporte

            $gestion_array = array(
                'gtc_id_dtc' => $_POST['id_detalle_ticket'],
                'gtc_observacion' => (!empty($_POST['observaciones'])) ? $_POST['observaciones'] : null,
                'gtc_estado' => 1,
                'gtc_usuario_recibe' => (!empty($_POST['recibe'])) ? $_POST['recibe'] : null,
                'gtc_usu_modificacion' => $this->tank_auth->get_user_id(),
                'gtc_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            if (($_POST['gtc_id'])>0) {
                $this->gsatelite->actualizar_array('gtc_gestion_combustible', $gestion_array, array('gtc_id' => $_POST['gtc_id']));
                $id_gtc = $_POST['gtc_id'];
            } else {
                $gestion_array['gtc_usu_creacion'] = $this->tank_auth->get_user_id();
                $gestion_array['gtc_fecha_creacion'] = date('Y-m-d H:i:s');
                $id_gtc = $this->gsatelite->ingresar('gtc_gestion_combustible', $gestion_array);
            }

            // Ingresar los vales por gestion transporte
            if ($id_gtc > 0) {
                $series = $this->input->post('series');
                $cantidad = $this->input->post('cantidad');
                $inicio = $this->input->post('inicio');
                $fin = $this->input->post('fin');
                $valor = $this->input->post('valor');
                $vale=$this->input->post('vale');

                // Si esa serie ya fue utilizada no Eliminarlo. (Pendiente)
                $num_borrados = $this->gsatelite->borrado_general('vxc_valesxgestion_comb', array('vxc_id_gtc' => $id_gtc));

                for ($i = 0; $i < count($series); $i++) {
                    if (!empty($series[$i])) {

                        $vales_array = array(
                            'vxc_id_gtc' => $id_gtc,
                            'vxc_id_srv' => $series[$i],
                            'vxc_inicio' => $inicio[$i],
                            'vxc_fin' => $fin[$i],
                            'vxc_estado' => 1,
                            'vxc_fecha_creacion' => date('Y-m-d H:i:s'),
                            'vxc_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'vxc_usu_creacion' => $this->tank_auth->get_user_id(),
                            'vxc_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'vxc_monto'=>number_format($vale[$i],2),
                        );

                        $this->gsatelite->ingresar('vxc_valesxgestion_comb', $vales_array);
                    }
                } // End for	
            }

            // Guardar los Anexos
            $rutas = $this->input->post("ruta");
            $carpeta = $this->input->post("nombreCarpeta");

            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $this->input->post("titulo_doc" . $i);
                        $this->datos_imagen_gral($img, $this->input->post('id_ticket'), $carpeta, $titulo);
                    }
                }
            } // End guardar anexos

            if ($id_gtc > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se guardó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Error de inserción", 'texto_alerta' => "El registro no pudo guardarse");
            }
            $this->session->set_flashdata($alerta);
            redirect('transporte/inicio_trans/gestion_solicitud');
        } else {
            // All your code goes here
            $detalle_ticket = $this->entradas_model->get_detalle_ticket_combustible($id_ticket);
            $data['detalle_ticket'] = $detalle_ticket[0];

            $ticket_edicion = $this->gsatelite->get_registro('gtc_gestion_combustible', array('gtc_id_dtc' => $detalle_ticket[0]['dtc_id']));

            $data['ticket_edicion'] = !empty($ticket_edicion) ? $ticket_edicion : '';

            // Si es una edición
            if (!empty($ticket_edicion)) {
                $datos['vales_array'] = $this->entradas_model->tabla_vales_gestion_combustible($ticket_edicion->gtc_id);
                $data["html"] = $this->load->view('transporte/inicio_trans/tabla_detalle_tickets_combustible', $datos, true);

                $destino['detalle_destino'] = $this->gsatelite->get_tabla('ddt_detalle_destino', array('ddt_id_dtc' => $detalle_ticket[0]['dtc_id'], 'ddt_estado' => 1));
                $data["tabla_detalles"] = $this->load->view('transporte/inicio_trans/tabla_detalles_destino', $destino, true);
            }
            
            $data["anexos"] = $this->entradas_model->get_anexos($id_ticket);




            $data['users'] = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' =>1),  $ticket_edicion->gtc_usuario_recibe, null, 'emp_id', true);
            $data['vehiculo'] = $this->gsatelite->get_dropdown('veh_vehiculo', '{veh_placa}', '', array('veh_estado' => '1'), $detalle_ticket[0]['dtc_id_veh'], '', 'veh_id', true);
            $data['estado'] = $this->gsatelite->get_dropdown('esk_estado_ticket', '{esk_nombre}', '', array('esk_estado' => '1'), $detalle_ticket[0]['tkt_id_esk'], '', 'esk_id', true);
            //$data['motorista'] 	= 	$this->gsatelite->get_dropdown('mot_motorista', '{mot_empleado}','', array('mot_estado' => '1'), $detalle_ticket[0]['dtc_id_mot'], '', 'mot_id', true);
            $data['motorista'] = $this->gsatelite->get_dropdown_empleado('mot_motorista', '{mot_empleado}', '', array('mot_estado' => '1'), $detalle_ticket[0]['dtc_id_mot'], '', 'mot_id', true);
            $data['combustible'] = $this->gsatelite->get_dropdown('tpc_tipo_combustible', '{tpc_nombre}', '', array('tpc_estado' => '1'), $detalle_ticket[0]['dtc_id_tpc'], '', 'tpc_id', true);
            $data['contratos'] = $this->gsatelite->get_dropdown('con_contrato_gasol', '{con_nombre}', '', array('con_estado' => '1'), null, '', 'con_id', true);
            $data['select_encargado']=$this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}','', array('emp_estado'=>'1'), $detalle_ticket[0]['dtc_id_emp_resp'], '', 'emp_id', true);

            $this->load->model('gsatelite2');
            $data['persona_recibe'] = $this->gsatelite2->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), !empty($ticket_edicion->gtc_usuario_recibe) ? $ticket_edicion->gtc_usuario_recibe : '', '', 'emp_id', true);

            $data['titulo_personal'] = "Gestión de solicitudes para combustible";
            $this->_cargarvista($data, null);
        }
    }

// End editar ticket combustible

    public function ver_detalle_factura($id_dtc = 0) {
        satelite_validar();
        $data['id_dtc'] = $id_dtc;
        $data['ticket'] = $this->gsatelite->get_campo('dtc_detalle_ticket_combustible', 'dtc_id_tkt', array('dtc_id' => $id_dtc));
        $data['detalle_facturas'] = $this->gsatelite->get_tabla('dtf_detalle_factura', array('dtf_id_dtc' => $id_dtc));
        $this->load->view('transporte/inicio_trans/tabla_factura', $data, FALSE);
    }

    /* 	
      // cargar placas por tipo de vehiculo
      // @autor: Melbin Cruz
     */

    public function cargar_placas() {
        $id_tipo = $this->input->post('id_tipo');
        $placas_options = $this->gsatelite->get_dropdown('veh_vehiculo', '{veh_placa}', '', array('veh_estado' => '1', 'veh_id_tvh' => $id_tipo), '', '', 'veh_id', true);
        echo json_encode(array('placas' => $placas_options));
    }

    public function cargar_contratos() {
        $prv_id = $this->input->post('prv_id');
        $contratos_options = $this->gsatelite->get_dropdown('con_contrato_gasol', '{con_nombre}', '', array('con_estado' => '1', 'con_id_prv' => $prv_id), '', '', 'con_id', true);
        echo json_encode(array('contratos' => $contratos_options));
    }

    public function cargar_series() {
        $id_contrato = $this->input->post('id_contrato');
        $serie_options = $this->gsatelite->get_dropdown('srv_serie_vale', '{srv_nombre} :: {srv_inicio} - {srv_fin}', '', array('srv_estado' => '1', 'srv_id_con' => $id_contrato), '', '', 'srv_id', true);
        echo json_encode(array('series' => $serie_options));
    }

    // Este sera eliminado
    public function get_tickets_libres() {
        $id_serie = $this->input->post('id_serie');
        $serie_vale = $this->gsatelite->get_registro('srv_serie_vale', array('srv_id' => $id_serie));
        //$vales_asignados = $this->gsatelite->get_tabla('vxg_valexgestion_trans', array('vxg_id_srv'=>$id_serie));
        $vales_asignados = $this->entradas_model->get_valesxasignacion($id_serie);

        $cantidad = 0;
        $ultimo = 0;
        $valor = $serie_vale->srv_valor;
        foreach ($vales_asignados as $key => $value) {
            $cantidad += intval($value['vxg_fin'] - $value['vxg_inicio'] + 1);
            $ultimo = $value['vxg_fin'];
        }
        $vales_en_serie = intval($serie_vale->srv_fin);
        $resultado = $vales_en_serie - $cantidad;
        echo json_encode(array('tickets' => $resultado, 'ultimo_asignado' => $ultimo, 'valor' => $valor));
    }

    public function calcular_espacios($id_serie = 0, $vales_inicio_temp = null, $vales_fin_temp = null) {
        $serie_vale = $this->gsatelite->get_registro('srv_serie_vale', array('srv_id' => $id_serie));
        $vales_asignados = $this->entradas_model->get_valesxasignacion($id_serie);

        $vales_unificado = array();
        $vales_unificado_inicio = array();
        $vales_unificado_fin = array();
        $flag = false;  // Si no hay datos temporales, y tampoco hay registros en la base. 
        // Separamos los vales registrados de la base, habra que volver a ordenar el unificado.
        if (!empty($vales_asignados)) {
            foreach ($vales_asignados as $key => $value) {
                array_push($vales_unificado_inicio, $value['vxg_inicio']);
                array_push($vales_unificado_fin, $value['vxg_fin']);
            }
        } else {
            if (empty($vales_inicio_temp)) {
                $flag = true;
                array_push($vales_unificado_inicio, $serie_vale->srv_inicio);
                array_push($vales_unificado_fin, $serie_vale->srv_fin);
            }
        }

        // Si hay registros temporales, ordenarlos.
        if (count($vales_inicio_temp) > 0 && !empty($vales_inicio_temp)) {
            // Ordenar los vales temporales de menor a mayor
            sort($vales_inicio_temp);
            sort($vales_fin_temp);

            foreach ($vales_inicio_temp as $key => $value) {
                array_push($vales_unificado_inicio, $value);
                array_push($vales_unificado_fin, $vales_fin_temp[$key]);
            }
        }

        // Unificar las series (inicio y fin) de los temporales y registros de la db
        sort($vales_unificado_inicio);
        sort($vales_unificado_fin);

        foreach ($vales_unificado_inicio as $key => $value) {
            array_push($vales_unificado, array('vales_inicio' => $value, 'vales_fin' => $vales_unificado_fin[$key]));
        }

        // Obtener los vales libres
        // Si no hay registros en la base y tampoco hay temporales. Devolver el inicio y el fin de la serie como tal.
        if ($flag) {
            return $vales_unificado;
        } else {
            $vales_libres = array();
            $srv_inicio = $serie_vale->srv_inicio;
            $srv_fin = $serie_vale->srv_fin;

            for ($i = 0; $i < count($vales_unificado); $i++) {
                // $srv_inicio ira intercalando valores				

                $vale_inicio = $vales_unificado[$i]['vales_inicio'];
                $vale_fin = $vales_unificado[$i]['vales_fin'];

                if ($srv_inicio < $vale_inicio) {
                    array_push($vales_libres, array('vales_inicio' => $srv_inicio, 'vales_fin' => $vale_inicio - 1));
                }

                $srv_inicio = $vale_fin + 1;
            }

            // verificar si el ultimo elemento es menor al fin de la serie

            if (count($vales_unificado) > 0 && $vales_unificado[count($vales_unificado) - 1]['vales_fin'] < $srv_fin) {
                $inicio_ultimo = $vales_unificado[count($vales_unificado) - 1]['vales_fin'] + 1;
                array_push($vales_libres, array('vales_inicio' => $inicio_ultimo, 'vales_fin' => $srv_fin));
            }

            return $vales_libres;
        }
    }

// End calcular espacios

    /**
     * @author Melbin Cruz
     * @param int id de la serie, array de vales temporales
     * @return Una tabla con los rangos de vales libres.
     */
    public function get_rangos_libres() {
        $id_serie = $this->input->post('id_serie');
        $vales_inicio_temp = $this->input->post('vales_inicio');
        $vales_fin_temp = $this->input->post('vales_fin');

        $serie_vale = $this->gsatelite->get_registro('srv_serie_vale', array('srv_id' => $id_serie));
        $vales_libres_ordenados = $this->calcular_espacios($id_serie, $vales_inicio_temp, $vales_fin_temp);
      
        $data = array('vales_disponibles' => $vales_libres_ordenados);
        $tabla_vales = $this->load->view('transporte/inicio_trans/tabla_vales', $data, true);

        echo json_encode(array('tabla_vales' => $tabla_vales, 'valor' => $serie_vale->srv_valor));
    }

// End get_rango_libres

    public function validar_rango_correlativo() {
        $id_serie = $this->input->post('id_serie');
        $vales_inicio_temp = $this->input->post('vales_inicio');
        $vales_fin_temp = $this->input->post('vales_fin');
        $inicio_input = $this->input->post('inicio_input');
        $fin_input = $this->input->post('fin_input');

        $serie_vale = $this->gsatelite->get_registro('srv_serie_vale', array('srv_id' => $id_serie));
        $vales_libres_ordenados = $this->calcular_espacios($id_serie, $vales_inicio_temp, $vales_fin_temp);

        $data = array('vales_disponibles' => $vales_libres_ordenados);
        $tabla_vales = $this->load->view('transporte/inicio_trans/tabla_vales', $data, true);

        // Verificar si el rago de vales solicitados esta disponible.

        $espacio = false; //variable que cambiará a true si hay espacio disponible para el rango de los vales
        if ($id_serie > 0 and $inicio_input != "" and $fin_input != "") {

            $inicios = array();
            $finales = array();
            foreach ($vales_libres_ordenados as $key => $value) {
                array_push($inicios, $value['vales_inicio']);
                array_push($finales, $value['vales_fin']);
            }

            if (count($inicios) > 0) {
                $segir = true; //bandera para detener el for
                for ($i = 0; (($i < count($inicios)) and $segir); $i++) {
                    //validar que las cantidades encaje en un rango
                    if (($inicio_input >= $inicios[$i]) and ( $fin_input <= $finales[$i])) {
                        $segir = false;
                        $espacio = true;
                    }
                }
            }
        } // End if

        echo json_encode(array('tabla_vales' => $tabla_vales, 'espacio' => $espacio, 'valor' => $serie_vale->srv_valor));
    }

    public function guardar_gral($parametros, $carpeta = null) {

        $datos = @explode($parametros);
        $carpeta = $parametros;


        $image = $this->upload_gral($carpeta);

        //echo base_url().'/public/temp/'.$image['upload_data']['raw_name'].$image['upload_data']['file_ext'];
        echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
        //echo $image['upload_data']['client_name'];
    }

    function eliminar_imagen_gral($carpeta = "") {

        $url = $this->input->post("url");
        echo $url;
        $carp = ($carpeta != "") ? $carpeta : "archivos";
        unlink("./public/temp/$carp/" . $url);
    }

    function upload_gral($carpeta) {
        if ($carpeta == "assets") {
            $ruta = FCPATH . "assets/uploads/images";
        } else {
            $ruta = FCPATH . "public/temp/" . $carpeta;
        }

        if (!file_exists($ruta)) {
            mkdir($ruta, 0777);
        }

        $obj = &get_instance();
        $config['upload_path'] = $ruta;
        $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx';
        $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return true;
        } else {
            $data = array('upload_data' => $obj->upload->data());
            return $data;
        }
        print_r($data);
    }

    public function datos_imagen_gral($img, $id_tkt = 0, $carpeta, $titulo_doc, $tipo = 0) {
        $extencion = end(explode(".", $img));
        $datos_1 = $this->session->keep_flashdata('datos_1');
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        /* if($extencion=='jpg' || $extencion=='jepg' || $extencion=='png'){
          $tipo=1;
          }
          else{$tipo=0;} */

        $destino = "uploads/anexos_detalle_ticket/" . $titulo_doc . "." . trim($extencion) . "";
        $dir = $this->gsatelite->get_campo('anx_anexo', 'anx_url', array('anx_url' => $destino, 'anx_estado' => 1));

        // Si no existe ese Anexo, agregarlo
        if (count($dir) <= 0) {
            $array_anex = array(
                'anx_url' => $destino,
                // 'anx_nombre'=>$titulo_doc,	
                'anx_estado' => 1,
                'anx_usu_crea' => $this->tank_auth->get_user_id(),
                'anx_usu_mod' => $this->tank_auth->get_user_id(),
                'anx_fecha_crea' => date('Y-m-d H:i:s'),
                'anx_fecha_mod' => date('Y-m-d H:i:s')
                    // 'anx_imagen'=>$tipo
            );

            $id_anexo = $this->gsatelite->ingresar("anx_anexo", $array_anex);

            $array_anex_doc = array(
                'axt_id_tkt' => $id_tkt,
                'axt_id_anx' => $id_anexo,
                'axt_estado' => 1,
                'axt_usu_creacion' => $this->tank_auth->get_user_id(),
                'axt_usu_modificacion' => $this->tank_auth->get_user_id(),
                'axt_fecha_creacion' => date('Y-m-d H:i:s'),
                'axt_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $id_axt = $this->gsatelite->ingresar("axt_anexoxticket", $array_anex_doc);
            $carpeta_destino = "uploads/anexos_detalle_ticket/" . $titulo_doc . "." . trim($extencion) . "";

            copy($ruta, $carpeta_destino);
            unlink($ruta);
        }
    }

// End datos_imagen_gral

    function eliminar_vales_transporte() {
        $vxg_id = $this->input->post('vxg_id');

        // Pendiente verificar si ya se han sacado tickets de esa asignacion.
        $this->gsatelite->borrado_general('vxg_valexgestion_trans', array('vxg_id' => $vxg_id));
    }

    public function eliminar_vales_combustible() {
        $vxc_id = $this->input->post('vxc_id');
        // Pendiente verificar si ya se han sacado tickets de esa asignacion.
        $this->gsatelite->borrado_general('vxc_valesxgestion_comb', array('vxc_id' => $vxc_id));
    }

    function cargar_tipo_fondo()
    {
        $placa=$this->input->post('placa');
        $tipo_fondo=$this->gsatelite->get_campo('veh_vehiculo', 'veh_id_tpf', array('veh_id'=>$placa));
        $tpf_nombre=$this->gsatelite->get_campo('tpf_tipo_fondo','tpf_nombre', array('tpf_id'=>$tipo_fondo));
        //die(print_r($tipo_fondo.'/'.$tpf_nombre));
        echo json_encode($tpf_nombre);
    }


    function _cargarvista($data = 0, $crud = 0, $modulo_principal = null) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario($modulo_principal));
        else
            $data = $this->masterpage->getUsuario($modulo_principal);

        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

}

// End of class