<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Cruds extends CI_Controller {

    public function __construct() {
        parent::__construct();

        $this->load->database();
        $this->load->helper('url');
        $this->load->model('entradas_model');
        $this->load->library('grocery_CRUD');
        //$this->load->library('../controllers/inventario/mantenimiento');
    }

    // public function _catalogo_output($output = null)
    // {
    // 	$this->load->view('cruds.php',$output);
    // }

    function _catalogo_output($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        //$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
        $vista = 'cruds.php';
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    public function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->load->view('vacia');
        }
    }

//======================================================================
// INICIO DE CRUDS DE FLUJO
//======================================================================


    public function rol() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('rol');
        try {
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('rol_rol');
            $crud->set_subject('Rol');

            $columnas = array(
                'rol_nombre',
                'rol_estado'
            );

            $campos = array(
                'rol_nombre',
                'rol_estado',
                'rol_usu_creacion',
                'rol_usu_modificacion',
                'rol_fecha_creacion',
                'rol_fecha_modificacion'
            );

            $display_as = array(
                'rol_nombre' => 'Nombre',
                'rol_estado' => 'Estado',
                'rol_usu_creacion' => 'Usuario Creacion',
                'rol_usu_modificacion' => 'Usuario Modificacion',
                'rol_fecha_creacion' => 'Fecha Creacion',
                'rol_fecha_modificacion' => 'Fecha Modificacion'
            );


            $crud->field_type('rol_usu_creacion', 'hidden');
            $crud->field_type('rol_usu_modificacion', 'hidden');
            $crud->field_type('rol_fecha_creacion', 'hidden');
            $crud->field_type('rol_fecha_modificacion', 'hidden');
            $crud->field_type('rol_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'transporte/cruds/rol/read');
            }

            $output = $crud->render();

            $this->_catalogo_output(null, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

//======================================================================
// FIN DE CRUDS DE FLUJO
//======================================================================
//======================================================================
// INICIO DE CRUDS DE PROVEEDOR
//======================================================================

    public function proveedores() {
        satelite_validar();
        $this->load->library('../controllers/modulo_compras/catalogos');
        $this->catalogos->proveedores(null,array('transporte/cruds/proveedores','modulo_compras/catalogos/proveedores'));
        die('éxito');
    }

// End proveedor

    public function pais() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('pais');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('pai_pais');
            $crud->set_subject('País');

            $columnas = array(
                'pai_nombre',
                'pai_nacionalidad',
                'pai_estado'
            );

            // $campos = array(
            // 				'pai_nombre',
            // 				'pai_nacionalidad',
            // 				'pai_estado',
            // 				'pai_usu_crea',
            // 				'pai_usu_mod',
            // 				'pai_fecha_crea',
            // 				'pai_fecha_mod'
            // 				);

            $display_as = array(
                'pai_nombre' => 'Nombre',
                'pai_nacionalidad' => 'Nacionalidad',
                'pai_estado' => 'Estado',
                'pai_usu_cre' => 'Usuario Creacion',
                'pai_usu_mod' => 'Usuario Modificacion',
                'pai_fecha_crea' => 'Fecha Creacion',
                'pai_fecha_mod' => 'Fecha Modificacion'
            );


            $crud->field_type('pai_usu_crea', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('pai_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('pai_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('pai_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('pai_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->required_fields('pai_nombre', 'pai_estado');
            $crud->set_rules('pai_nombre', 'Nombre', 'campo_unico[pai_pais.pai_nombre]|required');

            $crud->columns($columnas);
            //$crud->fields($campos);
            $crud->display_as($display_as);
            //$crud->callback_before_insert(array($this, '_log_usuario_insert'));
            //$crud->callback_before_update(array($this, '_log_usuario_update'));

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('pai_estado', 'hidden', 1);
            } else {
                $crud->field_type('pai_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de países";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function departamento() {
        satelite_validar();

        $this->load->library('../controllers/sistema/catalogo');
        $this->catalogo->departamentos(array('transporte/cruds/departamento','sistema/catalogo/departamentos'));
        die('éxito');

        try {
            $permisos = $this->gsatelite->get_permisos_opcion('departamento');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('dep_departamento');
            $crud->set_subject('');

            $columnas = array(
                'dep_nombre',
                'dep_id_pai',
                'dep_estado'
            );

            $campos = array(
                'dep_nombre',
                'dep_id_pai',
                'dep_estado',
                'dep_usu_creacion',
                'dep_usu_modificacion',
                'dep_fecha_creacion',
                'dep_fecha_modificacion'
            );

            $display_as = array(
                'dep_nombre' => 'Nombre',
                'dep_id_pai' => 'País',
                'dep_estado' => 'Estado',
                'dep_usu_creacion' => 'Usuario Creacion',
                'dep_usu_modificacion' => 'Usuario Modificacion',
                'dep_fecha_creacion' => 'Fecha Creacion',
                'dep_fecha_modificacion' => 'Fecha Modificacion'
            );


            $crud->field_type('dep_usu_creacion', 'hidden');
            $crud->field_type('dep_usu_modificacion', 'hidden');
            $crud->field_type('dep_fecha_creacion', 'hidden');
            $crud->field_type('dep_fecha_modificacion', 'hidden');
            $crud->field_type('dep_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->required_fields('dep_id_pai', 'dep_nombre', 'dep_estado');
            $crud->set_rules('dep_nombre', 'Nombre', 'campo_unico[dep_departamento.dep_nombre]|required');

            $crud->set_relation('dep_id_pai', 'pai_pais', 'pai_nombre', array('pai_estado' => 1));

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('dep_estado', 'hidden', 1);
            } else {
                $crud->field_type('dep_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de departamentos";

            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function municipio() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('municipio');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('mun_municipio');
            $crud->set_subject('');

            $columnas = array(
                'mun_nombre',
                'mun_id_dep'
                    //'mun_estado'
            );

            $campos = array(
                'mun_nombre',
                'mun_id_dep',
                //'mun_estado',
                'mun_usu_creacion',
                'mun_usu_modificacion',
                'mun_fecha_creacion',
                'mun_fecha_modificacion'
            );

            $display_as = array(
                'mun_nombre' => 'Nombre',
                'mun_id_dep' => 'Departamento',
                //'mun_estado' => 'Estado',
                'mun_usu_creacion' => 'Usuario Creacion',
                'mun_usu_modificacion' => 'Usuario Modificacion',
                'mun_fecha_creacion' => 'Fecha Creacion',
                'mun_fecha_modificacion' => 'Fecha Modificacion'
            );


            $crud->field_type('mun_usu_creacion', 'hidden');
            $crud->field_type('mun_usu_modificacion', 'hidden');
            $crud->field_type('mun_fecha_creacion', 'hidden');
            $crud->field_type('mun_fecha_modificacion', 'hidden');
            //$crud->field_type('mun_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->required_fields('mun_id_dep', 'mun_nombre', 'mun_estado');
            $crud->set_rules('mun_nombre', 'Nombre', 'campo_unico[mun_municipio.mun_nombre]|required');

            $crud->set_relation('mun_id_dep', 'dep_departamento', 'dep_nombre', array('dep_estado' => 1));

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de municipios";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function tipo_documento() {
        try {
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('tpd_tipo_documento');
            $crud->set_subject('');

            $columnas = array(
                'tpd_nombre',
                'tpd_mascara',
                'tpd_estado'
            );

            $campos = array(
                'tpd_nombre',
                'tpd_mascara',
                'tpd_estado',
                'tpd_usu_creacion',
                'tpd_usu_modificacion',
                'tpd_fecha_creacion',
                'tpd_fecha_modificacion',
            );

            $display_as = array(
                'tpd_nombre' => 'Nombre',
                'tpd_estado' => 'Estado',
                'tpd_usu_creacion' => 'Usuario Creacion',
                'tpd_usu_modificacion' => 'Usuario Modificacion',
                'tpd_fecha_creacion' => 'Fecha Creacion',
                'tpd_fecha_modificacion' => 'Fecha Modificacion',
                'tpd_mascara' => 'tipo de  mascara'
            );


            $crud->field_type('tpd_usu_creacion', 'hidden');
            $crud->field_type('tpd_usu_modificacion', 'hidden');
            $crud->field_type('tpd_fecha_creacion', 'hidden');
            $crud->field_type('tpd_fecha_modificacion', 'hidden');
            $crud->field_type('tpd_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->required_fields('tpd_nombre', 'tpd_estado');
            $crud->set_rules('tpd_nombre', 'Nombre', 'campo_unico[tpd_tipo_documento.tpd_nombre]|required');

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de tipos de documento";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

//======================================================================
// FIN DE CRUDS DE PROVEEDOR
//======================================================================
//======================================================================
// FIN DE CRUDS DE SEGURIDAD
//======================================================================

    public function usuario() {
        try {
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('usu_usuario');
            $crud->set_subject('Usuario');

            $columnas = array(
                'usu_login',
                'usu_estado'
            );

            $campos = array(
                'usu_login',
                'usu_estado',
                'usu_usu_creacion',
                'usu_usu_modificacion',
                'usu_fecha_creacion',
                'usu_fecha_modificacion'
            );

            $display_as = array(
                'usu_login' => 'Login',
                'usu_estado' => 'Estado',
                'usu_usu_creacion' => 'Usuario Creacion',
                'usu_usu_modificacion' => 'Usuario Modificacion',
                'usu_fecha_creacion' => 'Fecha Creacion',
                'usu_fecha_modificacion' => 'Fecha Modificacion'
            );


            $crud->field_type('usu_usu_creacion', 'hidden');
            $crud->field_type('usu_usu_modificacion', 'hidden');
            $crud->field_type('usu_fecha_creacion', 'hidden');
            $crud->field_type('usu_fecha_modificacion', 'hidden');
            $crud->field_type('usu_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));


            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            $output = $crud->render();

            $this->_catalogo_output(null, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function usuario_rol() {
        try {
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('uxr_usuarioxrol');
            $crud->set_subject('Usuarios por rol');

            $columnas = array(
                'uxr_id_usu',
                'uxr_id_rol',
                'uxr_estado'
            );

            $campos = array(
                'uxr_id_usu',
                'uxr_id_rol',
                'uxr_estado',
                'uxr_usu_creacion',
                'uxr_usu_modificacion',
                'uxr_fecha_creacion',
                'uxr_fecha_modificacion'
            );

            $display_as = array(
                'uxr_id_usu' => 'Usuario',
                'uxr_id_rol' => 'Rol',
                'uxr_estado' => 'Estado',
                'uxr_usu_creacion' => 'UsuRario Creacion',
                'uxr_usu_modificacion' => 'Usuario Modificacion',
                'uxr_fecha_creacion' => 'Fecha Creacion',
                'uxr_fecha_modificacion' => 'Fecha Modificacion'
            );


            $crud->field_type('uxr_usu_creacion', 'hidden');
            $crud->field_type('uxr_usu_modificacion', 'hidden');
            $crud->field_type('uxr_fecha_creacion', 'hidden');
            $crud->field_type('uxr_fecha_modificacion', 'hidden');
            $crud->field_type('uxr_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));

            $crud->set_relation('uxr_id_usu', 'usu_usuario', 'usu_login', array('usu_estado' => 1));
            $crud->set_relation('uxr_id_rol', 'rol_rol', 'rol_nombre', array('rol_estado' => 1));


            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            $output = $crud->render();

            $this->_catalogo_output(null, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

//======================================================================
// FIN DE CRUDS DE SEGURIDAD
//======================================================================
//======================================================================
// INICIO DE CRUDS DE TRANSPORTE
//======================================================================

    public function motorista($otro_modulo = null,$permiso = null) {
        satelite_validar();

        $empleados_array = array();
        $qemp = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado' => 1));
        foreach ($qemp as $f) {
            $empleados_array[$f['emp_id']] = $f['emp_nombre'] . " " . $f['emp_apellido'];
        }
        $permisos = $this->gsatelite->get_permisos_opcion('motorista');
        $ruta = $permisos['modulo'] . '/' . $permisos['control'];
        $data['ruta'] = $ruta;
        try {
            
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('mot_motorista');
            $crud->set_subject('');

            $columnas = array(
                // 'mot_nombre',
                'mot_empleado',
                'mot_id_tlc',
                'mot_licencia'
            );

            $campos = array(
                // 'mot_nombre',
                'mot_empleado',
                'mot_id_tlc',
                'mot_licencia',
                'mot_correo',
                'mot_telefono',
                'mot_radio',
                'mot_fecha_venci',
                'mot_estado',
                'mot_usu_creacion',
                'mot_usu_modificacion',
                'mot_fecha_creacion',
                'mot_fecha_modificacion'
            );

            $display_as = array(
                'mot_nombre' => 'Nombre',
                'mot_empleado' => 'Empleado',
                'mot_licencia' => 'Licencia',
                'mot_id_tlc' => 'Tipo licencia',
                'mot_correo' => 'Correo',
                'mot_telefono' => 'Teléfono',
                'mot_radio' => 'Radio',
                'mot_fecha_venci' => 'Fecha Vencimiento',
                'mot_estado' => 'Estado',
                'mot_usu_creacion' => 'Usuario creacion',
                'mot_usu_modificacion' => 'Usuario modificacion',
                'mot_fecha_creacion' => 'Fecha creacion',
                'mot_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('mot_usu_creacion', 'hidden');
            $crud->field_type('mot_usu_modificacion', 'hidden');
            $crud->field_type('mot_fecha_creacion', 'hidden');
            $crud->field_type('mot_fecha_modificacion', 'hidden');
            $crud->field_type('mot_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->field_type('mot_empleado', 'dropdown', $empleados_array);
            $crud->set_rules('mot_empleado', 'Empleado', 'campo_unico[mot_motorista.mot_empleado]|required');

            $crud->set_relation('mot_id_tlc', 'tlc_tipo_licencia', 'tlc_nombre', array('tlc_estado' => 1));

            $crud->set_rules('mot_correo', 'correo', 'valid_email');


            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));
            $crud->required_fields('mot_nombre', 'mot_empleado', 'mot_estado');
            $crud->add_action('Horario', '', 'transporte/cruds/detalle_horario', 'icomoon-icon-calendar'); //ver_en_modal
            $url_array = explode('/', uri_string());
            if (end($url_array) == 'add') {
                $crud->field_type('mot_estado', 'hidden', 1);
            } else {
                $crud->field_type('mot_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $crud->unset_edit();
            if ($permisos['permite_editar']) {
                $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', $ruta . '/editar_motorista', 'editar_motoristax');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de motoristas";
            cargarvista($data, $output, 'transporte/cruds/motorista');
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function vehiculo() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('vehiculo');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('veh_vehiculo');
            $crud->set_subject('');

            $columnas = array(
                'veh_placa',
                'veh_id_tvh',
                'veh_id_emp',
                'veh_observacion',
                'veh_id_stv'
            );

            $campos = array(
                'veh_placa',
                'veh_id_mrv',
                'veh_id_mdv',
                'veh_id_tvh',
                'veh_id_emp',
                'veh_ano',
                'veh_id_tpm',
                'veh_id_trm',
                'veh_id_clv',
                'veh_id_trc',
                'veh_capacidad',
                'veh_id_tpc',
                'veh_id_stv',
                'veh_num_llantas',
                'veh_id_tpl',
                'veh_id_tpf',
                //'veh_activo_fijo',
                'veh_chasis',
                'veh_vin',
                'veh_motor',
                'veh_vencimiento_tar',
                'veh_observacion',
                'veh_id_cfv',
                'veh_id_ach',
                'veh_estado',
                'veh_fotografia',
                //
                'veh_id_cms',
                'veh_fecha_vence_seguro',
                'veh_poliza_seguro',
                'veh_gps',
                'veh_tel_gps',
                //
                'veh_usu_creacion',
                'veh_usu_modificacion',
                'veh_fecha_creacion',
                'veh_fecha_modificacion'
            );

            $display_as = array(
                'veh_placa' => 'Placa',
                'veh_id_mrv' => 'Marca',
                'veh_ano' => 'Año',
                'veh_capacidad' => 'Capacidad',
                'veh_num_llantas' => 'No llantas',
                'veh_chasis' => 'No chasis',
                'veh_vin' => 'No VIN',
                'veh_motor' => 'No Motor',
                'veh_vencimiento_tar' => 'Vencimiento',
                'veh_id_mdv' => 'Modelo',
                'veh_id_tvh' => 'Tipo de vehículo',
                'veh_id_emp' => 'Responsable',
                'veh_id_clv' => 'Color',
                'veh_id_stv' => 'Estatus',
                'veh_id_trm' => 'Transmisión',
                'veh_id_trc' => 'Tracción',
                'veh_id_cfv' => 'Clasificación',
                'veh_id_tpm' => 'Tipo de motor',
                'veh_id_tpl' => 'Serie llanta',
                'veh_id_tpc' => 'Tipo de combustible',
                'veh_id_tpf' => 'Tipo de fondo',
                'veh_id_ach' => 'Tipo aceite',
                'veh_observacion' => 'Observación',
                //'veh_activo_fijo' => 'Activo fijo',
                'veh_fotografia' => 'Fotografía',
                'veh_estado' => 'Estado',
                'veh_usu_creacion' => 'Usuario creacion',
                'veh_usu_modificacion' => 'Usuario modificacion',
                'veh_fecha_creacion' => 'Fecha creacion',
                'veh_fecha_modificacion' => 'Fecha modificacion',

                'veh_id_cms' => 'Compañía de Seguro',
                'veh_fecha_vence_seguro' => 'Fecha vencimiento',
                'veh_poliza_seguro' => 'No. Poliza',
                'veh_gps' => 'ID GPS',
                'veh_tel_gps' => 'Tél. GPS'
            );


            $crud->field_type('veh_usu_creacion', 'hidden');
            $crud->field_type('veh_usu_modificacion', 'hidden');
            $crud->field_type('veh_fecha_creacion', 'hidden');
            $crud->field_type('veh_fecha_modificacion', 'hidden');

            $crud->set_rules('veh_placa', 'Placa', 'trim|required|campo_unico[veh_vehiculo.veh_placa]');

            $crud->set_relation('veh_id_mdv', 'mdv_modelo_veh', 'mdv_nombre', array('mdv_estado' => 1));
            $crud->set_relation('veh_id_ach', 'ach_aceite_vehiculo', 'ach_nombre', array('ach_estado' => 1));
            $crud->set_relation('veh_id_tvh', 'tvh_tipo_vehiculo', 'tvh_nombre', array('tvh_estado' => 1));
            $crud->set_relation('veh_id_emp', 'emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', array('emp_estado' => 1));
            $crud->set_relation('veh_id_clv', 'clv_color_vehiculo', 'clv_nombre', array('clv_estado' => 1));
            $crud->set_relation('veh_id_trm', 'trm_transmision', 'trm_nombre', array('trm_estado' => 1));
            $crud->set_relation('veh_id_trc', 'trc_traccion', 'trc_nombre', array('trc_estado' => 1));
            $crud->set_relation('veh_id_cfv', 'cfv_clasif_vehiculo', 'cfv_nombre', array('cfv_estado' => 1));
            $crud->set_relation('veh_id_tpm', 'tpm_tipo_motor', 'tpm_nombre', array('tpm_estado' => 1));
            $crud->set_relation('veh_id_tpl', 'tpl_tipo_llanta', 'tpl_nombre', array('tpl_estado' => 1));
            $crud->set_relation('veh_id_tpf', 'tpf_tipo_fondo', 'tpf_nombre', array('tpf_estado' => 1));
            $crud->set_relation('veh_id_tpc', 'tpc_tipo_combustible', 'tpc_nombre', array('tpc_estado' => 1));
            $crud->set_relation('veh_id_mrv', 'mrv_marca', 'mrv_nombre', array('mrv_estado' => 1));
            $crud->set_relation('veh_id_stv', 'stv_status_vehiculo', 'stv_nombre', array('stv_estado' => 1));
            $crud->set_relation('veh_id_cms', 'cms_compania_seguro', 'cms_nombre', array('cms_estado' => 1));
            $crud->required_fields('veh_id_tpc', 'veh_placa');
            $crud->set_field_upload('veh_fotografia', 'uploads/catalogos/vehiculos');

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('veh_estado', 'hidden', 1);
            }
            else{
                $crud->field_type('veh_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'transporte/cruds/vehiculo/read');
            }

            $output = $crud->render();

            array_push($output->js_files, base_url() . "js/transporte/vehiculo.js");
            $data['titulo_personal'] = "Vehículos";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function tipo_vehiculo() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('tipo_vehiculo');
        //print_r($permisos); die();
        try {
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('tvh_tipo_vehiculo');
            $crud->set_subject('');

            $columnas = array(
                'tvh_nombre',
                'tvh_estado'
            );

            $campos = array(
                'tvh_nombre',
                'tvh_estado',
                'tvh_usu_creacion',
                'tvh_usu_modificacion',
                'tvh_fecha_creacion',
                'tvh_fecha_modificacion'
            );

            $display_as = array(
                'tvh_nombre' => 'Nombre',
                'tvh_estado' => 'Estado',
                'tvh_usu_creacion' => 'Usuario creacion',
                'tvh_usu_modificacion' => 'Usuario modificacion',
                'tvh_fecha_creacion' => 'Fecha creacion',
                'tvh_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('tvh_usu_creacion', 'hidden');
            $crud->field_type('tvh_usu_modificacion', 'hidden');
            $crud->field_type('tvh_fecha_creacion', 'hidden');
            $crud->field_type('tvh_fecha_modificacion', 'hidden');
            $crud->field_type('tvh_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('tvh_nombre', 'Nombre', 'campo_unico[tvh_tipo_vehiculo.tvh_nombre]|required');
            $crud->required_fields('tvh_nombre', 'tvh_estado');

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de tipos de vehículo";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function tipo_aceite() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('tipo_aceite');
        try {
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('ach_aceite_vehiculo');
            $crud->set_subject('');

            $columnas = array(
                'ach_nombre',
                'ach_estado'
            );

            $campos = array(
                'ach_nombre',
                'ach_estado',
                'ach_usu_creacion',
                'ach_usu_modificacion',
                'ach_fecha_creacion',
                'ach_fecha_modificacion'
            );

            $display_as = array(
                'ach_nombre' => 'Nombre',
                'ach_estado' => 'Estado',
                'ach_usu_creacion' => 'Usuario creacion',
                'ach_usu_modificacion' => 'Usuario modificacion',
                'ach_fecha_creacion' => 'Fecha creacion',
                'ach_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('ach_usu_creacion', 'hidden');
            $crud->field_type('ach_usu_modificacion', 'hidden');
            $crud->field_type('ach_fecha_creacion', 'hidden');
            $crud->field_type('ach_fecha_modificacion', 'hidden');
            $crud->field_type('ach_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('ach_nombre', 'Nombre', 'campo_unico[ach_aceite_vehiculo.ach_nombre]|required');
            $crud->required_fields('tvh_nombre', 'tvh_estado');

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Tipos de aceite vehículo";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function sub_especialidad() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('sub_especialidad');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('sue_sub_especialidad');
            $crud->set_subject('');

            $columnas = array(
                'sue_nombre',
                'sue_id_esp',
                'sue_estado'
            );

            $campos = array(
                'sue_nombre',
                'sue_id_esp',
                'sue_estado',
                'sue_usu_creacion',
                'sue_usu_modificacion',
                'sue_fecha_creacion',
                'sue_fecha_modificacion'
            );

            $display_as = array(
                'sue_nombre' => 'Nombre',
                'sue_id_esp' => 'Especialidad',
                'sue_estado' => 'Estado',
                'sue_usu_creacion' => 'Usuario creacion',
                'sue_usu_modificacion' => 'Usuario modificacion',
                'sue_fecha_creacion' => 'Fecha creacion',
                'sue_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('sue_usu_creacion', 'hidden');
            $crud->field_type('sue_usu_modificacion', 'hidden');
            $crud->field_type('sue_fecha_creacion', 'hidden');
            $crud->field_type('sue_fecha_modificacion', 'hidden');
            $crud->field_type('sue_estado', 'dropdown', array('1' => 'activo', '0' => 'inactivo'));

            $crud->set_relation('sue_id_esp', 'esp_especialidad', 'esp_nombre', array('esp_estado' => 1));
            $crud->set_rules('sue_nombre', 'Nombre', 'campo_unico[sue_sub_especialidad.sue_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'transporte/cruds/sub_especialidad/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de subespecialidades";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function ubicacion_tarea() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('ubicacion_tarea');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('ubt_ubicacion_tarea');
            $crud->set_subject('Destino');

            $columnas = array(
                'ubt_nombre',
                'ubt_estado'
            );

            $campos = array(
                'ubt_nombre',
                'ubt_estado',
                'ubt_usu_creacion',
                'ubt_usu_modificacion',
                'ubt_fecha_creacion',
                'ubt_fecha_modificacion'
            );

            $display_as = array(
                'ubt_nombre' => 'Nombre',
                'ubt_estado' => 'Estado',
                'ubt_usu_creacion' => 'Usuario creacion',
                'ubt_usu_modificacion' => 'Usuario modificacion',
                'ubt_fecha_creacion' => 'Fecha creacion',
                'ubt_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('ubt_usu_creacion', 'hidden');
            $crud->field_type('ubt_usu_modificacion', 'hidden');
            $crud->field_type('ubt_fecha_creacion', 'hidden');
            $crud->field_type('ubt_fecha_modificacion', 'hidden');
            $crud->field_type('ubt_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('ubt_nombre', 'Nombre', 'campo_unico[ubt_ubicacion_tarea.ubt_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'transporte/cruds/ubicacion_tarea/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo Destinos";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

//======================================================================
// FIN DE CRUDS DE TRANSPORTE
//======================================================================
//======================================================================
// INICIO DE CRUDS DE MANTENIMIENTOS
//======================================================================

    public function tipo_mantenimiento() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('tipo_mantenimiento');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('tmn_tipo_mantto');
            $crud->set_subject('');

            $columnas = array(
                'tmn_nombre',
                'tmn_descripcion',
                'tmn_estado'
            );

            $campos = array(
                'tmn_nombre',
                'tmn_descripcion',
                'tmn_estado',
                'tmn_usu_creacion',
                'tmn_usu_modificacion',
                'tmn_fecha_creacion',
                'tmn_fecha_modificacion'
            );

            $display_as = array(
                'tmn_nombre' => 'Nombre',
                'tmn_estado' => 'Estado',
                'tmn_descripcion' => 'Descripción',
                'tmn_usu_creacion' => 'Usuario creacion',
                'tmn_usu_modificacion' => 'Usuario modificacion',
                'tmn_fecha_creacion' => 'Fecha creacion',
                'tmn_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('tmn_usu_creacion', 'hidden');
            $crud->field_type('tmn_usu_modificacion', 'hidden');
            $crud->field_type('tmn_fecha_creacion', 'hidden');
            $crud->field_type('tmn_fecha_modificacion', 'hidden');
            $crud->field_type('tmn_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('tmn_nombre', 'Nombre', 'campo_unico[tmn_tipo_mantto.tmn_nombre]|required');
            $crud->required_fields('tmn_nombre', 'tmn_estado');
            $crud->add_action('Operación', ' icomoon-icon-clipboard-2', 'transporte/cruds/operacion_mtto');
            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de tipos de mantenimiento";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function operacion_mtto($id_tipo = 0) {

        satelite_validar();
        try {
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('opm_operacion_mantto');
            $crud->set_subject('');

            $columnas = array(
                'opm_nombre',
                'opm_descripcion',
                'opm_tipo_recurrencia',
                'opm_valor_recurrencia',
                'opm_estado'
            );

            $campos = array(
                'opm_nombre',
                'opm_descripcion',
                'opm_tipo_recurrencia',
                'opm_valor_recurrencia',
                'opm_estado',
                'opm_id_tmn',
                'opm_usu_creacion',
                'opm_usu_modificacion',
                'opm_fecha_creacion',
                'opm_fecha_modificacion'
            );

            $display_as = array(
                'opm_nombre' => 'Nombre',
                'opm_tipo_recurrencia' => 'Tipo recurrencia',
                'opm_valor_recurrencia' => 'Valor recurrencia',
                'opm_nombre' => 'Nombre',
                'opm_estado' => 'Estado',
                'opm_descripcion' => 'Descripción',
            );

            $crud->field_type('opm_id_tmn', 'hidden');
            $crud->field_type('opm_usu_creacion', 'hidden');
            $crud->field_type('opm_usu_modificacion', 'hidden');
            $crud->field_type('opm_fecha_creacion', 'hidden');
            $crud->field_type('opm_fecha_modificacion', 'hidden');
            $crud->field_type('opm_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->field_type('opm_tipo_recurrencia', 'dropdown', array('1' => 'Tiempo (días)', '2' => 'Recorrido (kms)'));
            $crud->set_rules('opm_nombre', 'Nombre', "trim|required|campo_unico2[opm_operacion_mantto.opm_nombre.opm_id_tmn.$id_tipo]");
            $crud->required_fields('opm_nombre', 'opm_estado');

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));
            $crud->where('opm_id_tmn', $id_tipo);
            $output = $crud->render();
            $data['tipo_mtto'] = $this->gsatelite->get_campo('tmn_tipo_mantto', 'tmn_nombre', array('tmn_id' => $id_tipo));
            $data['omp_id'] = $id_tipo;
            $data['titulo_personal'] = "Catálogo de operaciones de tipo mantenimiento";
            $this->_cargarvista($data, $output, 'tipo_mantenimiento');
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

// End opcion por mantenimiento
//======================================================================
// FIN DE CRUDS DE MANTENIMIENTOS
//======================================================================
//======================================================================
// INICIO DE CRUDS DE TICKETS
//======================================================================

    public function estado_ticket() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('estado_ticket');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('esk_estado_ticket');
            $crud->set_subject('');

            $columnas = array(
                'esk_nombre',
                'esk_estado',
                'esk_edita_usuario'
            );

            $campos = array(
                'esk_nombre',
                'esk_estado',
                'esk_usu_creacion',
                'esk_usu_modificacion',
                'esk_fecha_creacion',
                'esk_fecha_modificacion',
                'esk_edita_usuario'
            );

            $display_as = array(
                'esk_nombre' => 'Nombre',
                'esk_estado' => 'Estado',
                'esk_usu_creacion' => 'Usuario creacion',
                'esk_usu_modificacion' => 'Usuario modificacion',
                'esk_fecha_creacion' => 'Fecha creacion',
                'esk_fecha_modificacion' => 'Fecha modificacion',
                'esk_edita_usuario' => 'Edicion de usuario'
            );


            $crud->field_type('esk_usu_creacion', 'hidden');
            $crud->field_type('esk_usu_modificacion', 'hidden');
            $crud->field_type('esk_fecha_creacion', 'hidden');
            $crud->field_type('esk_fecha_modificacion', 'hidden');
            $crud->field_type('esk_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->field_type('esk_edita_usuario', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('esk_nombre', 'Nombre', 'campo_unico[esk_estado_ticket.esk_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'transporte/cruds/estado_ticket/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de estados de tickets";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    // Solo falta guardarlo, y crear la opc
    public function medio_recepcion_ticket() {

        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('medio_recepcion_ticket');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('mrc_medio_recepcion');
            $crud->set_subject('');

            $columnas = array(
                'mrc_nombre',
                'mrc_estado'
            );

            $campos = array(
                'mrc_nombre',
                'mrc_estado',
                'mrc_usu_creacion',
                'mrc_usu_modificacion',
                'mrc_fecha_creacion',
                'mrc_fecha_modificacion'
            );

            $display_as = array(
                'mrc_nombre' => 'Nombre',
                'mrc_estado' => 'Estado',
                'mrc_usu_creacion' => 'Usuario creacion',
                'mrc_usu_modificacion' => 'Usuario modificacion',
                'mrc_fecha_creacion' => 'Fecha creacion',
                'mrc_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('mrc_usu_creacion', 'hidden');
            $crud->field_type('mrc_usu_modificacion', 'hidden');
            $crud->field_type('mrc_fecha_creacion', 'hidden');
            $crud->field_type('mrc_fecha_modificacion', 'hidden');
            $crud->field_type('mrc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('mrc_nombre', 'Nombre', 'campo_unico[mrc_medio_recepcion.mrc_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'transporte/cruds/medio_recepcion_ticket/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de medio de recepción";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function prioridad() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('prioridad');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('prd_prioridad');
            $crud->set_subject('');

            $columnas = array(
                'prd_nombre',
                'prd_estado'
            );

            $campos = array(
                'prd_nombre',
                'prd_estado',
                'prd_usu_creacion',
                'prd_usu_modificacion',
                'prd_fecha_creacion',
                'prd_fecha_modificacion'
            );

            $display_as = array(
                'prd_nombre' => 'Nombre',
                'prd_estado' => 'Estado',
                'prd_usu_creacion' => 'USuario creacion',
                'prd_usu_modificacion' => 'USuario modificacion',
                'prd_fecha_creacion' => 'FECHA creacion',
                'prd_fecha_modificacion' => 'FECHA modificacion'
            );


            $crud->field_type('prd_usu_creacion', 'hidden');
            $crud->field_type('prd_usu_modificacion', 'hidden');
            $crud->field_type('prd_fecha_creacion', 'hidden');
            $crud->field_type('prd_fecha_modificacion', 'hidden');
            $crud->field_type('prd_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('prd_nombre', 'Nombre', 'campo_unico[prd_prioridad.prd_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'transporte/cruds/prioridad/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de prioridades";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function especialidad() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('especialidad');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('esp_especialidad');
            $crud->set_subject('');

            $columnas = array(
                'esp_nombre',
                'esp_estado'
            );

            $campos = array(
                'esp_nombre',
                'esp_estado',
                'esp_usu_creacion',
                'esp_usu_modificacion',
                'esp_fecha_creacion',
                'esp_fecha_modificacion'
            );

            $display_as = array(
                'esp_nombre' => 'Nombre',
                'esp_estado' => 'Estado',
                'esp_usu_creacion' => 'Usuario creacion',
                'esp_usu_modificacion' => 'Usuario modificacion',
                'esp_fecha_creacion' => 'Fecha creacion',
                'esp_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('esp_usu_creacion', 'hidden');
            $crud->field_type('esp_usu_modificacion', 'hidden');
            $crud->field_type('esp_fecha_creacion', 'hidden');
            $crud->field_type('esp_fecha_modificacion', 'hidden');
            $crud->field_type('esp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('esp_nombre', 'Nombre', 'campo_unico[esp_especialidad.esp_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'transporte/cruds/especialidad/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de especialidades";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

//======================================================================
// FIN DE CRUDS DE TICKETS
//======================================================================
//======================================================================
// INICIO DE CRUDS DE VEHICULOS
//======================================================================

    public function clasificacion() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('clasificacion');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('cfv_clasif_vehiculo');
            $crud->set_subject('');

            $columnas = array(
                'cfv_nombre',
                'cfv_estado'
            );

            $campos = array(
                'cfv_nombre',
                'cfv_estado',
                'cfv_usu_creacion',
                'cfv_usu_modificacion',
                'cfv_fecha_creacion',
                'cfv_fecha_modificacion'
            );

            $display_as = array(
                'cfv_nombre' => 'Nombre',
                'cfv_estado' => 'Estado',
                'cfv_usu_creacion' => 'Usuario creacion',
                'cfv_usu_modificacion' => 'Usuario modificacion',
                'cfv_fecha_creacion' => 'Fecha creacion',
                'cfv_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('cfv_usu_creacion', 'hidden');
            $crud->field_type('cfv_usu_modificacion', 'hidden');
            $crud->field_type('cfv_fecha_creacion', 'hidden');
            $crud->field_type('cfv_fecha_modificacion', 'hidden');
            $crud->field_type('cfv_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('cfv_nombre', 'Nombre', 'campo_unico[cfv_clasif_vehiculo.cfv_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de clasificación de vehículos";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function tipo_llanta() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('tipo_llanta');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('tpl_tipo_llanta');
            $crud->set_subject('');

            $columnas = array(
                'tpl_nombre',
                'tpl_estado'
            );

            $campos = array(
                'tpl_nombre',
                'tpl_estado',
                'tpl_usu_creacion',
                'tpl_usu_modificacion',
                'tpl_fecha_creacion',
                'tpl_fecha_modificacion'
            );

            $display_as = array(
                'tpl_nombre' => 'Nombre',
                'tpl_estado' => 'Estado',
                'tpl_usu_creacion' => 'Usuario creacion',
                'tpl_usu_modificacion' => 'Usuario modificacion',
                'tpl_fecha_creacion' => 'Fecha creacion',
                'tpl_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('tpl_usu_creacion', 'hidden');
            $crud->field_type('tpl_usu_modificacion', 'hidden');
            $crud->field_type('tpl_fecha_creacion', 'hidden');
            $crud->field_type('tpl_fecha_modificacion', 'hidden');
            $crud->field_type('tpl_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('tpl_nombre', 'Nombre', 'campo_unico[tpl_tipo_llanta.tpl_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de series de llantas";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function tipo_combustible() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('tipo_combustible');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('tpc_tipo_combustible');
            $crud->set_subject('');

            $columnas = array(
                'tpc_nombre',
                'tpc_estado'
            );

            $campos = array(
                'tpc_nombre',
                'tpc_estado',
                'tpc_usu_creacion',
                'tpc_usu_modificacion',
                'tpc_fecha_creacion',
                'tpc_fecha_modificacion'
            );

            $display_as = array(
                'tpc_nombre' => 'Nombre',
                'tpc_estado' => 'Estado',
                'tpc_usu_creacion' => 'Usuario creacion',
                'tpc_usu_modificacion' => 'Usuario modificacion',
                'tpc_fecha_creacion' => 'Fecha creacion',
                'tpc_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('tpc_usu_creacion', 'hidden');
            $crud->field_type('tpc_usu_modificacion', 'hidden');
            $crud->field_type('tpc_fecha_creacion', 'hidden');
            $crud->field_type('tpc_fecha_modificacion', 'hidden');
            $crud->field_type('tpc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('tpc_nombre', 'Nombre', 'campo_unico[tpc_tipo_combustible.tpc_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de tipos de combustible";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function transmision() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('transmision');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('trm_transmision');
            $crud->set_subject('');

            $columnas = array(
                'trm_nombre',
                'trm_estado'
            );

            $campos = array(
                'trm_nombre',
                'trm_estado',
                'trm_usu_creacion',
                'trm_usu_modificacion',
                'trm_fecha_creacion',
                'trm_fecha_modificacion'
            );

            $display_as = array(
                'trm_nombre' => 'Nombre',
                'trm_estado' => 'Estado',
                'trm_usu_creacion' => 'Usuario creacion',
                'trm_usu_modificacion' => 'Usuario modificacion',
                'trm_fecha_creacion' => 'Fecha creacion',
                'trm_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('trm_usu_creacion', 'hidden');
            $crud->field_type('trm_usu_modificacion', 'hidden');
            $crud->field_type('trm_fecha_creacion', 'hidden');
            $crud->field_type('trm_fecha_modificacion', 'hidden');
            $crud->field_type('trm_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('trm_nombre', 'Nombre', 'campo_unico[trm_transmision.trm_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de transmisiones";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function tipo_motor() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('tipo_motor');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('tpm_tipo_motor');
            $crud->set_subject('');

            $columnas = array(
                'tpm_nombre',
                'tpm_estado'
            );

            $campos = array(
                'tpm_nombre',
                'tpm_estado',
                'tpm_usu_creacion',
                'tpm_usu_modificacion',
                'tpm_fecha_creacion',
                'tpm_fecha_modificacion'
            );

            $display_as = array(
                'tpm_nombre' => 'Nombre',
                'tpm_estado' => 'Estado',
                'tpm_usu_creacion' => 'Usuario creacion',
                'tpm_usu_modificacion' => 'Usuario modificacion',
                'tpm_fecha_creacion' => 'Fecha creacion',
                'tpm_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('tpm_usu_creacion', 'hidden');
            $crud->field_type('tpm_usu_modificacion', 'hidden');
            $crud->field_type('tpm_fecha_creacion', 'hidden');
            $crud->field_type('tpm_fecha_modificacion', 'hidden');
            $crud->field_type('tpm_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('tpm_nombre', 'Nombre', 'campo_unico[tpm_tipo_motor.tpm_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de tipos de motor";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function color_vehiculo() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('color_vehiculo');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('clv_color_vehiculo');
            $crud->set_subject('');

            $columnas = array(
                'clv_nombre',
                'clv_estado'
            );

            $campos = array(
                'clv_nombre',
                'clv_estado',
                'clv_usu_creacion',
                'clv_usu_modificacion',
                'clv_fecha_creacion',
                'clv_fecha_modificacion'
            );

            $display_as = array(
                'clv_nombre' => 'Nombre',
                'clv_estado' => 'Estado',
                'clv_usu_creacion' => 'Usuario creacion',
                'clv_usu_modificacion' => 'Usuario modificacion',
                'clv_fecha_creacion' => 'Fecha creacion',
                'clv_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('clv_usu_creacion', 'hidden');
            $crud->field_type('clv_usu_modificacion', 'hidden');
            $crud->field_type('clv_fecha_creacion', 'hidden');
            $crud->field_type('clv_fecha_modificacion', 'hidden');
            $crud->field_type('clv_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('clv_nombre', 'Nombre', 'campo_unico[clv_color_vehiculo.clv_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de colores de vehículo";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function traccion() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('traccion');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('trc_traccion');
            $crud->set_subject('');

            $columnas = array(
                'trc_nombre',
                'trc_estado'
            );

            $campos = array(
                'trc_nombre',
                'trc_estado',
                'trc_usu_creacion',
                'trc_usu_modificacion',
                'trc_fecha_creacion',
                'trc_fecha_modificacion'
            );

            $display_as = array(
                'trc_nombre' => 'Nombre',
                'trc_estado' => 'Estado',
                'trc_usu_creacion' => 'Usuario creacion',
                'trc_usu_modificacion' => 'Usuario modificacion',
                'trc_fecha_creacion' => 'Fecha creacion',
                'trc_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('trc_usu_creacion', 'hidden');
            $crud->field_type('trc_usu_modificacion', 'hidden');
            $crud->field_type('trc_fecha_creacion', 'hidden');
            $crud->field_type('trc_fecha_modificacion', 'hidden');
            $crud->field_type('trc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('trc_nombre', 'Nombre', 'campo_unico[trc_traccion.trc_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de tracciones";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function modelo() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('modelo');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('mdv_modelo_veh');
            $crud->set_subject('');

            $columnas = array(
                'mdv_nombre',
                'mdv_id_mrv',
                'mdv_estado'
            );

            $campos = array(
                'mdv_nombre',
                'mdv_id_mrv',
                'mdv_estado',
                'mdv_usu_creacion',
                'mdv_usu_modificacion',
                'mdv_fecha_creacion',
                'mdv_fecha_modificacion'
            );

            $display_as = array(
                'mdv_nombre' => 'Nombre',
                'mdv_id_mrv' => 'Marca',
                'mdv_estado' => 'Estado',
                'mdv_usu_creacion' => 'Usuario creacion',
                'mdv_usu_modificacion' => 'Usuario modificacion',
                'mdv_fecha_creacion' => 'Fecha creacion',
                'mdv_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('mdv_usu_creacion', 'hidden');
            $crud->field_type('mdv_usu_modificacion', 'hidden');
            $crud->field_type('mdv_fecha_creacion', 'hidden');
            $crud->field_type('mdv_fecha_modificacion', 'hidden');
            $crud->field_type('mdv_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));

            $crud->set_relation('mdv_id_mrv', 'mrv_marca', 'mrv_nombre', array('mrv_estado' => 1));
            $crud->set_rules('mdv_nombre', 'Nombre', 'campo_unico[mdv_modelo_veh.mdv_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de modelos de vehículo";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function marca() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('marca');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('mrv_marca');
            $crud->set_subject('');

            $columnas = array(
                'mrv_nombre',
                'mrv_estado'
            );

            $campos = array(
                'mrv_nombre',
                'mrv_estado',
                'mrv_usu_creacion',
                'mrv_usu_modificacion',
                'mrv_fecha_creacion',
                'mrv_fecha_modificacion'
            );

            $display_as = array(
                'mrv_nombre' => 'Nombre',
                'mrv_estado' => 'Estado',
                'mrv_usu_creacion' => 'Usuario creacion',
                'mrv_usu_modificacion' => 'Usuario modificacion',
                'mrv_fecha_creacion' => 'Fecha creacion',
                'mrv_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('mrv_usu_creacion', 'hidden');
            $crud->field_type('mrv_usu_modificacion', 'hidden');
            $crud->field_type('mrv_fecha_creacion', 'hidden');
            $crud->field_type('mrv_fecha_modificacion', 'hidden');
            $crud->field_type('mrv_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('mrv_nombre', 'Nombre', 'campo_unico[mrv_marca.mrv_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de marcas";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function contrato() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('contrato');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->unset_add();
            $crud->unset_edit();
            $crud->set_table('con_contrato_gasol');
            $crud->set_subject('');

            $columnas = array(
                'con_numero',
                'con_nombre',
                'con_institucion',
                'con_resolucion',
                'con_vigencia_desde',
                'con_vigencia_hasta',
                'con_estado'
            );

            $campos = array(
                'con_numero',
                'con_nombre',
                'con_institucion',
                'con_codigo',
                'con_resolucion',
                'con_vigencia_desde',
                'con_vigencia_hasta',
                'con_gar_cum_desde',
                'con_gar_cum_hasta',
                'con_antic_desde',
                'con_antic_hasta',
                'con_buena_desde',
                'con_buena_hasta',
                'con_otras_desde',
                'con_otras_hasta',
                'con_estado',
                'con_fecha_creacion',
                'con_fecha_modificacion',
                'con_usu_creacion',
                'con_usu_modificacion'
            );

            $display_as = array(
                'con_numero' => 'Número',
                'con_nombre' => 'Nombre',
                'con_institucion' => 'Contratista',
                'con_codigo' => 'Código',
                'con_resolucion' => 'Resolución',
                'con_vigente_desde' => 'Vigencia desde',
                'con_gar_cum_desde' => 'Vigencia garantía desde',
                'con_vigente_hasta' => 'Vigencia hasta',
                'con_antic_desde' => 'Vigencia garantía anticipo desde',
                'con_gar_cum_hasta' => 'Vigencia garantía hasta',
                'con_buena_desde' => 'Vigencia garantía buena obra desde',
                'con_buena_hasta' => 'Vigencia garantía buena obra hasta',
                'con_antic_hasta' => 'Vigencia garantía anticipo hasta',
                'con_otras_desde' => 'Vigencia otras garantías desde',
                'con_otras_hasta' => 'Vigencia otras garantías hasta',
                'con_estado' => 'Estado'
            );


            $crud->field_type('con_usu_creacion', 'hidden');
            $crud->field_type('con_usu_modificacion', 'hidden');
            $crud->field_type('con_fecha_creacion', 'hidden');
            $crud->field_type('con_fecha_modificacion', 'hidden');
            $crud->field_type('con_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('con_numero', 'Número', 'campo_unico[con_contrato.con_numero]|required');
            $crud->required_fields('con_numero', 'con_nombre', 'con_codigo', 'con_resolucion', 'con_vigente_desde', 'con_vigente_hasta', 'con_estado');

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            // Validaciones
            if ($permisos['permite_editar']) {
                $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'transporte/cruds/editar_contrato');
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'transporte/cruds/editar_contrato', 'ver');
            }

            // $crud->add_action('Exportar','icon16 icomoon-icon-file-excel','transporte/cruds/exportar_contrato'); 

            $output = $crud->render();
            $data['permisos'] = $permisos;
            $data['titulo_personal'] = "Catálogo de contratos";
            // $this->_catalogo_output($data, $output);
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

// End contrato

    public function exportar_contrato($id_contrato) {

        require_once('libraries/ssrsphp/bin/SSRSReport.php');
        define("UID", "GRUPOSATELITE\melbin.cruz");
        define("PASWD", "123456qwerty!@#$%^"); //123456qwerty!@#$%^
        define("SERVICE_URL", "http://192.168.1.20:8089/ReportServer/");
        define("REPORT", "/Ejecucion de contratos/EjecucionContratos");
        //define("FILENAME", "reporte_cupones_combustible_".date('d-m-Y H:i').".pdf");
        define("FILE_EXCEL", "reporte_contratos_" . date('d-m-Y H:i') . ".xls");

        try {
            $ssrs_report = new SSRSReport(new Credentials(UID, PASWD), SERVICE_URL);

            // Load the report and specify the params required for its execution
            $executionInfo = $ssrs_report->LoadReport2(REPORT, NULL);

            $parameters = array();
            $parameters[0] = new ParameterValue();
            $parameters[0]->Name = "id_contrato";
            $parameters[0]->Value = $id_contrato;
            $ssrs_report->SetExecutionParameters2($parameters);

            /* Renderizado a EXCEL */
            $renderAsEXCEL = new RenderAsEXCEL();
            $result_EXCEL = $ssrs_report->Render2($renderAsEXCEL, PageCountModeEnum::$Estimate, $Extension, $MimeType, $Encoding, $Warnings, $StreamIds);

            $nombre = "reporte_contratos_" . date('d-m-Y_H-i-s') . ".xls";
            $handle = fopen("C:\\Users\\melbin.cruz\\Desktop\\" . $nombre, 'wb');
            fwrite($handle, $result_EXCEL);
            fclose($handle);

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Exito", 'texto_alerta' => "Se exporto el reporte al escritorio de forma correcta.");
            $this->session->set_flashdata($alerta);
            redirect('transporte/cruds/contrato');
            //echo "<script>window.close();</script>"; 
        } catch (SSRSReportException $serviceException) {
            echo $serviceException->GetErrorMessage();
        }
    }

    public function agregar_contrato() {
        satelite_validar();

        if ($_POST) {
            //		die(print_r($_POST,true));


            $array_contrato = array(
                'con_id_prv' => $this->input->post('nombre_contratista'),
                'con_id_administrador' => ($this->input->post('admin_contrato') > 0) ? $this->input->post('admin_contrato') : null,
                'con_numero' => $this->input->post('numero_contrato'),
                'con_nombre' => $this->input->post('nombre_contrato'),
                'con_institucion' => $this->input->post('nombre_institucion'),
                'con_codigo' => $this->input->post('codigo_cont'),
                'con_resolucion' => $this->input->post('numero_resolucion'),
                'con_vigencia_desde' => ($_POST['periodo_vigencia_inicio']) ? date('Y-m-d', strtotime($_POST['periodo_vigencia_inicio'])) : null,
                'con_vigencia_hasta' => ($_POST['periodo_vigencia_fin']) ? date('Y-m-d', strtotime($_POST['periodo_vigencia_fin'])) : null,
                'con_gar_cum_desde' => ($_POST['periodo_garantia_cont_inicio']) ? date('Y-m-d', strtotime($_POST['periodo_garantia_cont_inicio'])) : null,
                'con_gar_cum_hasta' => ($_POST['periodo_garantia_cont_fin']) ? date('Y-m-d', strtotime($_POST['periodo_garantia_cont_fin'])) : null,
                'con_antic_desde' => ($_POST['periodo_anticipo_inicio']) ? date('Y-m-d', strtotime($_POST['periodo_anticipo_inicio'])) : null,
                'con_antic_hasta' => ($_POST['periodo_anticipo_fin']) ? date('Y-m-d', strtotime($_POST['periodo_anticipo_fin'])) : null,
                'con_buena_desde' => ($_POST['periodo_garantia_buena_inicio']) ? date('Y-m-d', strtotime($_POST['periodo_garantia_buena_inicio'])) : null,
                'con_buena_hasta' => ($_POST['periodo_garantia_buena_fin']) ? date('Y-m-d', strtotime($_POST['periodo_garantia_buena_fin'])) : null,
                'con_otras_desde' => ($_POST['periodo_otras_inicio']) ? date('Y-m-d', strtotime($_POST['periodo_otras_inicio'])) : null,
                'con_otras_hasta' => ($_POST['periodo_otras_fin']) ? date('Y-m-d', strtotime($_POST['periodo_otras_fin'])) : null,
                'con_estado' => $this->input->post('estado'),
                'con_fecha_creacion' => date('Y-m-d H:i:s'),
                'con_fecha_modificacion' => date('Y-m-d H:i:s'),
                'con_usu_creacion' => $this->tank_auth->get_user_id(),
                'con_usu_modificacion' => $this->tank_auth->get_user_id()
            );

            $contrato_id = $this->gsatelite->ingresar('con_contrato_gasol', $array_contrato);

            // Alcamenado de las Obligaciones
            $obligaciones = $_POST['obligaciones'];

            for ($i = 0; $i < count($obligaciones); $i++) {
                if (!empty($obligaciones[$i])) {

                    $oblixcontrato = array(
                        'obc_id_con' => $contrato_id,
                        'obc_nombre' => $obligaciones[$i],
                        'obc_desde' => null,
                        'obc_hasta' => null,
                        'obc_cumplimiento' => null,
                        'obc_estado' => 1,
                        'obc_usu_creacion' => $this->tank_auth->get_user_id(),
                        'obc_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'obc_fecha_creacion' => date('Y-m-d H-i-s'),
                        'obc_fecha_modificacion' => date('Y-m-d H-i-s')
                    );

                    $obc_id = $this->gsatelite->ingresar('obc_obligacion_contrato', $oblixcontrato);
                }
            } // End Obligaciones
            // Mostrar alerta
            if ($contrato_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro no se guardó.");
            }

            $this->session->set_flashdata($alerta);
            redirect('/transporte/cruds/contrato');
        } else {
            $data['departamentos'] = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', array('dep_estado' => '1'), null, '', 'dep_id', true);
            $data['proveedores'] = $this->gsatelite->get_dropdown('prv_proveedor', '{prv_nombre}', '', array('prv_estado' => '1'), null, '', 'prv_id', true);
            $data['administradores'] = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), null, '', 'emp_id', true);

            $data['titulo_personal'] = "Agregar contrato";
            $this->_cargarvista($data, null, 'contrato');
        }
    }

// End agregar contrato

    public function nameuser_check_insert($str) {
        $id = end(explode("/", uri_string()));
        if (is_numeric($id)) {
            $username_old = $this->db->where("id", $id)->get('users')->row()->tia_nombre;

            $num_row = $this->db->where('username', $str)->where('id !=', $id)->get('users')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('nameuser_check_insert', 'El nombre del usuario ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('username', $str)->get('users')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('nameuser_check_insert', 'El nombre del usuario ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    function editar_contrato($id_contrato = 0, $ver = 0) {
        satelite_validar();

        if ($_POST) {

            // $id_contrato=$this->input->post('id_contrato');
            // $numero=$this->input->post('numero_contrato');
            // $username_old = $this->db->where("con_id",$id_contrato)->get('con_contrato_gasol')->row()->con_numero;
            // $num_row = $this->db->where('con_numero',$numero)->where('con_id !=',$id_contrato)->get('con_contrato_gasol')->num_rows();
            // if ($num_row >= 1)
            // { 
            // 	$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Ingreso de contrato",'texto_alerta'=>"El Número de contrato debe ser único.");  
            // 	$this->session->set_flashdata($alerta);      
            // 	redirect('/transporte/cruds/editar_contrato/'.$id_contrato);	
            // }
            // else
            // {
            $array_contrato = array(
                'con_id_prv' => $this->input->post('nombre_contratista'),
                'con_id_administrador' => ($this->input->post('admin_contrato') > 0) ? $this->input->post('admin_contrato') : null,
                'con_numero' => $this->input->post('numero_contrato'),
                'con_nombre' => $this->input->post('nombre_contrato'),
                'con_institucion' => $this->input->post('nombre_institucion'),
                'con_codigo' => $this->input->post('codigo_cont'),
                'con_resolucion' => $this->input->post('numero_resolucion'),
                'con_vigencia_desde' => ($_POST['periodo_vigencia_inicio']) ? date('Y-m-d', strtotime($_POST['periodo_vigencia_inicio'])) : null,
                'con_vigencia_hasta' => ($_POST['periodo_vigencia_fin']) ? date('Y-m-d', strtotime($_POST['periodo_vigencia_fin'])) : null,
                'con_gar_cum_desde' => ($_POST['periodo_garantia_cont_inicio']) ? date('Y-m-d', strtotime($_POST['periodo_garantia_cont_inicio'])) : null,
                'con_gar_cum_hasta' => ($_POST['periodo_garantia_cont_fin']) ? date('Y-m-d', strtotime($_POST['periodo_garantia_cont_fin'])) : null,
                'con_antic_desde' => ($_POST['periodo_anticipo_inicio']) ? date('Y-m-d', strtotime($_POST['periodo_anticipo_inicio'])) : null,
                'con_antic_hasta' => ($_POST['periodo_anticipo_fin']) ? date('Y-m-d', strtotime($_POST['periodo_anticipo_fin'])) : null,
                'con_buena_desde' => ($_POST['periodo_garantia_buena_inicio']) ? date('Y-m-d', strtotime($_POST['periodo_garantia_buena_inicio'])) : null,
                'con_buena_hasta' => ($_POST['periodo_garantia_buena_fin']) ? date('Y-m-d', strtotime($_POST['periodo_garantia_buena_fin'])) : null,
                'con_otras_desde' => ($_POST['periodo_otras_inicio']) ? date('Y-m-d', strtotime($_POST['periodo_otras_inicio'])) : null,
                'con_otras_hasta' => ($_POST['periodo_otras_fin']) ? date('Y-m-d', strtotime($_POST['periodo_otras_fin'])) : null,
                'con_estado' => $this->input->post('estado'),
                'con_fecha_modificacion' => date('Y-m-d H:i:s'),
                'con_usu_modificacion' => $this->tank_auth->get_user_id()
            );
            //die(print_r($_POST,true));
            //die(print_r($array_contrato,true));
            // Eliminar obligaciones que no posean un seguimiento
            $obligacion_tabla = $this->entradas_model->obligcacionxcontrato($_POST['id_contrato']);

            $obligacion_array = array();
            foreach ($obligacion_tabla as $key => $value) {
                $obligacion_array[] = $value['obc_id'];  // Las que no hay que eliminar
            }
            if (count($obligacion_array) > 0) {
                $this->db->where('obc_id_con', $_POST['id_contrato'])->where_not_in('obc_id', $obligacion_array)->delete('obc_obligacion_contrato');
            } else {
                $this->db->where('obc_id_con', $_POST['id_contrato'])->delete('obc_obligacion_contrato');
            }


            $contrato_id = $this->gsatelite->actualizar_array('con_contrato_gasol', $array_contrato, array('con_id' => $_POST['id_contrato']));

            // Si hay Obligaciones para este contrato eliminarlas.  (No, ya que se agrego seg_seguimiento_cont)
            //$this->gsatelite->borrado_general('obc_obligacion_contrato', array('obc_id_con'=>$_POST['id_contrato']));	
            // Alcamenado de las Obligaciones
            $obligaciones = $_POST['obligaciones'];

            for ($i = 0; $i < count($obligaciones); $i++) {
                if (!empty($obligaciones[$i])) {

                    $oblixcontrato = array(
                        'obc_id_con' => $_POST['id_contrato'],
                        'obc_nombre' => $obligaciones[$i],
                        'obc_desde' => null,
                        'obc_hasta' => null,
                        'obc_cumplimiento' => null,
                        'obc_estado' => 1,
                        'obc_usu_creacion' => $this->tank_auth->get_user_id(),
                        'obc_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'obc_fecha_creacion' => date('Y-m-d H-i-s'),
                        'obc_fecha_modificacion' => date('Y-m-d H-i-s')
                    );

                    $obc_id = $this->gsatelite->ingresar('obc_obligacion_contrato', $oblixcontrato);
                }
            } // End Obligaciones
            // Mostrar alerta
            if ($contrato_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro se editó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro no se editó.");
            }

            $this->session->set_flashdata($alerta);
            redirect('/transporte/cruds/contrato');

            //}
        } else {
            //All your code goes here

            $contrato = $this->gsatelite->get_registro('con_contrato_gasol', array('con_id' => $id_contrato));
            if (is_object($contrato)) {
                $data['permite_ver'] = $ver;
                $data['contrato'] = $contrato;

                $data['proveedores'] = $this->gsatelite->get_dropdown('prv_proveedor', '{prv_nombre}', '', array('prv_estado' => '1'), $contrato->con_id_prv, '', 'prv_id', true);

                $data['admin_contrato'] = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), $contrato->con_id_administrador, '', 'emp_id', true);

                //$datos['obligaciones'] = $this->gsatelite->get_tabla('obc_obligacion_contrato', array('obc_id_con'=>$contrato->con_id, 'obc_estado'=>1));
                $datos['obligaciones'] = $this->entradas_model->get_obligaciones($contrato->con_id);

                $data['obligaciones'] = $this->load->view('transporte/cruds/tabla_obligaciones', $datos, true);

                if ($ver != 0) {
                    $data['titulo_personal'] = "Ver contrato";
                } else {
                    $data['titulo_personal'] = "Editar contrato";
                }

                $this->_cargarvista($data, null, 'contrato');
            }
        }
    }

    public function serie_vales() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('serie_vales');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('srv_serie_vale');
            $crud->set_subject('');

            $columnas = array(
                'srv_fecha_emision',
                'srv_nombre',
                //'srv_cantidad',
                'srv_inicio',
                'srv_fin',
                'srv_valor',
                'srv_id_con',
                'srv_estado'
            );

            $add_columns = array(
                // 'srv_nombre',
                'srv_id_con',
                'srv_nombre',
                'srv_inicio',
                'srv_fin',
                'srv_fecha_recibido',
                'srv_fecha_emision',
                'srv_fecha_vencimiento',
                'proveedor',
                'srv_cantidad',
                'srv_valor',
                'srv_observaciones',
                'srv_estado',
                'srv_fecha_modificacion',
                'srv_usu_creacion',
                'srv_usu_modificacion',
                'srv_fecha_creacion'
            );

            $edit_columns = array(
                'srv_id_con',
                'srv_nombre',
                'srv_inicio',
                'srv_fin',
                'srv_fecha_recibido',
                'srv_fecha_emision',
                'srv_fecha_vencimiento',
                'proveedor',
                'srv_cantidad',
                'srv_valor',
                'srv_observaciones',
                'srv_estado',
                'srv_fecha_modificacion',
                'srv_usu_modificacion'
            );

            $display_as = array(
                'srv_nombre' => 'Nombre',
                'srv_fecha_emision' => 'Fecha emisión',
                'srv_fecha_vencimiento' => 'Fecha vencimiento',
                'srv_fecha_recibido' => 'Fecha recibido',
                'srv_observaciones' => 'Obs.',
                'srv_cantidad' => 'Cantidad',
                'srv_inicio' => 'Inicio serie',
                'srv_fin' => 'Fin serie',
                'proveedor' => 'Proveedor',
                'srv_valor' => 'Monto',
                'srv_id_con' => 'Contrato',
                'srv_estado' => 'Estado'
            );


            $crud->field_type('srv_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('srv_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('srv_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('srv_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));

            $crud->field_type('srv_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('srv_nombre', 'Nombre', 'campo_unico[srv_serie_vale.srv_nombre]|required');
            $crud->required_fields('srv_id_con', 'srv_nombre', 'srv_fecha_emision', 'srv_fecha_vencimiento', 'srv_fecha_recibido', 'srv_inicio', 'srv_fin', 'srv_cantidad', 'srv_estado');
            $crud->set_relation('srv_id_con', 'con_contrato_gasol', 'con_nombre', array('con_estado' => 1));
            $crud->columns($columnas);
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->display_as($display_as);

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de series de vales";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

// End vales
    // public function contactos()
    // {
    // 	satelite_validar();
    // 	try{
    // 		$permisos= $this->gsatelite->get_permisos_opcion('contactos');
    // 		$crud = new grocery_CRUD();
    // 		$crud->unset_export();
    // 		$crud->unset_print();
    // 		$crud->set_table('con_contacto');
    // 		$crud->set_subject('');
    // 		$columnas = array(
    // 						'con_id_prv',
    // 						'con_nombre',
    // 						'con_apellidos',
    // 						'con_cargo',
    // 						'con_telefono_movil',
    // 						'con_email',
    // 						'con_estado'
    // 						);
    // 		$campos = array(
    // 						'con_id_prv',
    // 						'con_nombre',
    // 						'con_apellidos',
    // 						'con_cargo',
    // 						'con_telefono',
    // 						'con_telefono_movil',
    // 						'con_email',
    // 						'con_estado',
    // 						'con_fecha_modificacion',
    // 						'con_usu_creacion',
    // 						'con_usu_modificacion',
    // 						'con_fecha_creacion'
    // 						);
    // 		$display_as = array(
    // 						'con_id_prv' 			=> 'Proveedor',
    // 						'con_nombre'			=> 'Nombre',
    // 						'con_apellidos'			=> 'Apellidos',
    // 						'con_cargo'				=> 'Cargo',
    // 						'con_telefono'			=> 'Teléfono',
    // 						'con_telefono_movil'	=> 'Teléfono Móvil',
    // 						'con_email'				=> 'Correo',
    // 						'con_estado'			=> 'Estado'
    // 						);
    // 		$crud->field_type('con_usu_creacion', 'hidden');
    // 		$crud->field_type('con_usu_modificacion', 'hidden');
    // 		$crud->field_type('con_fecha_creacion', 'hidden');
    // 		$crud->field_type('con_fecha_modificacion', 'hidden');	
    // 		$crud->field_type('con_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
    // 		$crud->required_fields('con_nombre', 'con_apellidos', 'con_cargo', 'con_estado');
    // 		$crud->set_relation('con_id_prv','prv_proveedor','{prv_nombre}', array('prv_estado' => 1));	
    // 		$crud->set_rules('con_email','correo','valid_email');	
    // 		$crud->columns($columnas);
    // 		$crud->fields($campos);
    // 		$crud->display_as($display_as);
    // 		$crud->callback_before_insert(array($this, '_log_usuario_insert'));
    //    		$crud->callback_before_update(array($this, '_log_usuario_update'));
    // 	    // Validaciones
    // 	    if(!$permisos['permite_agregar']) { $crud->unset_add();} 
    // 	    if(!$permisos['permite_editar']) { $crud->unset_edit();}
    // 	    if(!$permisos['permite_eliminar']) { $crud->unset_delete();} 
    // 	    if($permisos['permite_ver']) {
    // 	      $crud->add_action('Ver','minia-icon-search','transporte/cruds/contactos/read');
    // 	     } 
    // 		$output = $crud->render();
    // 		$data['titulo_personal']="Catálogo de contactos";
    //       	$this->_cargarvista($data,$output);
    // 	}catch(Exception $e){
    // 		show_error($e->getMessage().' --- '.$e->getTraceAsString());
    // 	}
    // } // End contactos_proveedor

    public function tipo_licencia() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('tipo_licencia');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('tlc_tipo_licencia');
            $crud->set_subject('');

            $columnas = array(
                'tlc_nombre',
                'tlc_estado'
            );

            $campos = array(
                'tlc_nombre',
                'tlc_estado',
                'tlc_usu_creacion',
                'tlc_usu_modificacion',
                'tlc_fecha_creacion',
                'tlc_fecha_modificacion'
            );

            $display_as = array(
                'tlc_nombre' => 'Nombre',
                'tlc_estado' => 'Estado',
            );


            $crud->field_type('tlc_usu_creacion', 'hidden');
            $crud->field_type('tlc_usu_modificacion', 'hidden');
            $crud->field_type('tlc_fecha_creacion', 'hidden');
            $crud->field_type('tlc_fecha_modificacion', 'hidden');
            $crud->field_type('tlc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('tlc_nombre', 'Nombre', 'campo_unico[tlc_tipo_licencia.tlc_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de tipos de licencia";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

//======================================================================
// FIN DE CRUDS DE VEHICULOS
//======================================================================
//======================================================================
// INICIO DE CALLBACKS
//======================================================================
    function _log_usuario_insert($post_array) {
        reset($post_array);
        $sufijo = explode("_", key($post_array));
        $post_array[$sufijo[0] . '_usu_modificacion'] = $this->tank_auth->get_user_id();
        $post_array[$sufijo[0] . '_fecha_modificacion'] = date('Y-m-d H:i:s');
        $post_array[$sufijo[0] . '_usu_creacion'] = $this->tank_auth->get_user_id();
        $post_array[$sufijo[0] . '_fecha_creacion'] = date('Y-m-d H:i:s');
        return $post_array;
    }

    function _log_usuario_update($post_array) {
        reset($post_array);
        $sufijo = explode("_", key($post_array));
        $post_array[$sufijo[0] . '_usu_modificacion'] = $this->tank_auth->get_user_id();
        $post_array[$sufijo[0] . '_fecha_modificacion'] = date('Y-m-d H:i:s');
        return $post_array;
    }

//======================================================================
// FIN DE CALLBACKS
//======================================================================
//======================================================================
// INICIO DE AJAX
//======================================================================
    function cargarDepartamentos() {
        $this->db->select()
                ->where('dep_estado', 1)
                ->from('dep_departamento');
        $query = $this->db->get();
        $departamentos = $query->result_array();
        echo json_encode($departamentos);
    }

    /**
     * * @autor: Christian Menendez
     * *
     */
    function cargarTamanios() {
        $this->db->select()
                ->where('tap_nombre', 1)
                ->from('tap_tamano_prov');
        $query = $this->db->get();
        $tamanios = $query->result_array();
        echo json_encode($tamanios);
    }

    function cargarMunicipios() {
        $dep_id = $_POST['dep_id'];
        $this->db->where('mun_id_dep', $dep_id);
        $municipios = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', null, null, '', 'mun_id', true);
        echo json_encode(array('drop' => $municipios));
        // $dep_id = $_POST['dep_id'];
        // if(isset($_POST['mun_id']))
        // 	$mun_id = $_POST['mun_id'];
        // else
        // 	$mun_id = 0;
        // if($mun_id >0)
        // {
        // 	$this->db->select()
        //           ->where(array('mun_id' => $mun_id ))
        //           ->from('mun_municipio');         
        //        $query=$this->db->get();        
        // 	$municipio = $query->row_array();
        // 	$dep_id = $municipio['mun_id_dep'];	
        // }
        // $this->db->select()
        //           ->where(array('mun_id_dep' => $dep_id, 'mun_estado'=>1 ))
        //           ->from('mun_municipio');         
        //       $query=$this->db->get();        
        // $municipios = $query->result_array();
        // echo json_encode($municipios);
    }

    function cargarMarcas() {
        $this->db->select()
                ->where('mrv_estado', 1)
                ->from('mrv_marca');
        $query = $this->db->get();
        $marcas = $query->result_array();
        echo json_encode($marcas);
    }

    function cargarModelos() {
        $mrv_id = $_POST['mrv_id'];
        if (isset($_POST['mdv_id']))
            $mdv_id = $_POST['mdv_id'];
        else
            $mdv_id = 0;

        if ($mdv_id > 0) {
            $this->db->select()
                    ->where(array('mdv_id' => $mdv_id))
                    ->from('mdv_modelo_veh');
            $query = $this->db->get();
            $modelo = $query->row_array();
            $mrv_id = $modelo['mdv_id_mrv'];
        }

        $this->db->select()
                ->where(array('mdv_id_mrv' => $mrv_id, 'mdv_estado' => 1))
                ->from('mdv_modelo_veh');
        $query = $this->db->get();
        $modelos = $query->result_array();
        echo json_encode($modelos);
    }

    function cargar_modelos() {
        $mrv_id = $_POST['mrv_id'];
        $modelo = $_POST['modelo'];
        if (empty($_POST['mrv_id'])) {
            $mrv_id = 0;
        }
        $cadena = '<option value=""></option>';

        if ($mrv_id > 0) {
            $this->db->select()
                    ->where(array('mdv_id_mrv' => $mrv_id, 'mdv_estado' => 1))
                    ->from('mdv_modelo_veh')
            ;
            $resultado = $this->db->get()->result_array();
            if (count($resultado) > 0) {
                $selected = '';
                foreach ($resultado as $key => $value) {
                    if ($value['mdv_id'] == $modelo) {
                        $selected = 'selected';
                    }
                    $cadena .= "<option value='" . $value['mdv_id'] . "' $selected>" . $value['mdv_nombre'] . '</option>';
                }
            }
        }
        echo json_encode(array('modelos' => $cadena));
    }

//======================================================================
// FIN DE AJAX
//======================================================================	

    /**
     * @author René Castaneda
     * */
    function detalle_horario($id_motorista, $consulta = false) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('mot_motorista', $id_motorista);
        if ($consulta) {
            if ($this->input->post()) {
                $id_mot = $this->input->post('id_motorista');
                $fecha_ini = date("Y-m-d", strtotime($this->input->post('fecha_ini')));
                $fecha_fin = date("Y-m-d", strtotime($this->input->post('fecha_fin')));
                $where = array('hrm_id_mot' => $id_mot, 'hrm_desde_fecha >=' => $fecha_ini, 'hrm_desde_fecha <=' => $fecha_fin);
                $datos['registros'] = $this->gsatelite->get_tabla('hrm_horario_motorista', $where);
                //print_r($this->db->last_query()); die();
                $html = $this->load->view('transporte/cruds/detalle_horario_consulta', $datos, true);
                echo $html;
            }
            die();
        }
        $data['id_motorista'] = $id_motorista;
        //$data['registro_motorista'] = (array) $this->gsatelite->get_registro('mot_motorista','mot_id',$id_motorista);
        $emp = $this->gsatelite->get_campo('mot_motorista', 'mot_empleado', array('mot_id' => $id_motorista));
        $data['motorista'] = (array) $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $emp));
        $data['titulo_personal'] = "HORARIO MOTORISTA";
        $this->_cargarvista($data, null, 'motorista');
    }

    /**
     * @author René Castaneda
     * */
    function agregar_horario($id_motorista, $guardar = false) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('mot_motorista', $id_motorista);
        if ($guardar) { //peticion ajax para guardar
            if ($this->input->post('fecha_h') != "" and $this->input->post('hora_ini') != "" and $this->input->post('hora_ini') != "") {
                //preguntar si ya existe el registro
                $ingresar_q = array(
                    'hrm_id_mot' => $id_motorista
                    , 'hrm_desde_hora' => $this->input->post('hora_ini')
                    , 'hrm_hasta_hora' => $this->input->post('hora_fin')
                    , 'hrm_desde_fecha' => date("Y-m-d", strtotime($this->input->post('fecha_h')))
                    , 'hrm_hasta_fecha' => date("Y-m-d", strtotime($this->input->post('fecha_h')))
                );
                $consultar = $this->gsatelite->get_tabla('hrm_horario_motorista', $ingresar_q);
                if (count($consultar) > 0) {
                    echo "Registro duplicado, favor revisar.";
                    die();
                }
                $ingresar = array(
                    'hrm_id_mot' => $id_motorista
                    , 'hrm_desde_hora' => $this->input->post('hora_ini')
                    , 'hrm_hasta_hora' => $this->input->post('hora_fin')
                    , 'hrm_desde_fecha' => date("Y-m-d", strtotime($this->input->post('fecha_h')))
                    , 'hrm_hasta_fecha' => date("Y-m-d", strtotime($this->input->post('fecha_h')))
                    , 'hrm_usu_creacion' => $this->tank_auth->get_user_id()
                    , 'hrm_usu_modificacion' => $this->tank_auth->get_user_id()
                    , 'hrm_fecha_creacion' => date("Y-m-d H:i:s")
                    , 'hrm_fecha_modificacion' => date("Y-m-d H:i:s")
                    , 'hrm_estado' => 1
                );
                $this->gsatelite->ingresar('hrm_horario_motorista', $ingresar);
                echo "1";
                die();
            } else {
                echo "Todos campos son obligatorios";
                die();
            }
        }
        $data['id_motorista'] = $id_motorista;
        $data['registro_motorista'] = (array) $this->gsatelite->get_registro('mot_motorista', 'mot_id', $id_motorista);
        $data['titulo_personal'] = "HORARIO MOTORISTA";
        $this->load->view('transporte/cruds/agregar_horario', $data, FALSE);
    }

    /**
     * @author René Castaneda
     * */
    function editar_horario($id_horario, $actualizar = false) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('hrm_horario_motorista', $id_horario);

        if ($actualizar) { //peticion ajax para guardar
            $id_motorista = $this->input->post('id_motorista');
            if ($this->input->post('fecha_h') != "" and $this->input->post('hora_ini') != "" and $this->input->post('hora_ini') != "") {
                //preguntar si ya existe el registro
                $ingresar_q = array(
                    'hrm_id_mot' => $id_motorista
                    , 'hrm_desde_hora' => $this->input->post('hora_ini')
                    , 'hrm_hasta_hora' => $this->input->post('hora_fin')
                    , 'hrm_desde_fecha' => date("Y-m-d", strtotime($this->input->post('fecha_h')))
                    , 'hrm_hasta_fecha' => date("Y-m-d", strtotime($this->input->post('fecha_h')))
                    , 'hrm_id !=' => $id_horario
                );
                $consultar = $this->gsatelite->get_tabla('hrm_horario_motorista', $ingresar_q);
                if (count($consultar) > 0) {
                    echo "Registro duplicado, favor revisar.";
                    die();
                }
                $ingresar = array(
                    'hrm_id_mot' => $id_motorista
                    , 'hrm_desde_hora' => $this->input->post('hora_ini')
                    , 'hrm_hasta_hora' => $this->input->post('hora_fin')
                    , 'hrm_desde_fecha' => date("Y-m-d", strtotime($this->input->post('fecha_h')))
                    , 'hrm_hasta_fecha' => date("Y-m-d", strtotime($this->input->post('fecha_h')))
                    , 'hrm_usu_modificacion' => $this->tank_auth->get_user_id()
                    , 'hrm_fecha_modificacion' => date("Y-m-d H:i:s")
                    , 'hrm_estado' => 1
                );
                //$this->gsatelite->ingresar('hrm_horario_motorista',$ingresar);
                $this->gsatelite->actualizar_array('hrm_horario_motorista', $ingresar, array('hrm_id' => $id_horario));
                echo "1";
                die();
            } else {
                echo "Todos campos son obligatorios";
                die();
            }
        }

        $registro_horario = (array) $this->gsatelite->get_registro('hrm_horario_motorista', 'hrm_id', $id_horario);
        $id_motorista = $registro_horario['hrm_id_mot'];
        $data['id_motorista'] = $id_motorista;
        $data['id_horario'] = $registro_horario['hrm_id'];
        $data['registro_horario'] = $registro_horario;
        $data['es_actualizar'] = true;
        $data['registro_motorista'] = (array) $this->gsatelite->get_registro('mot_motorista', 'mot_id', $id_motorista);
        $data['titulo_personal'] = "HORARIO MOTORISTA";
        $this->load->view('transporte/cruds/agregar_horario', $data, FALSE);
    }

    function eliminar_horario($id_detalle) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('hrm_horario_motorista', $id_detalle);
        $r = $this->gsatelite->borrado_general('hrm_horario_motorista', array('hrm_id' => $id_detalle));
        echo $r;
    }

    /**
     * @author Christian Menendez
     * */
    public function actividad_economica() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('actividad_economica');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('acp_act_economica_prov');
            $crud->set_subject('');

            $columnas = array(
                'acp_nombre',
                'acp_estado'
            );

            $campos = array(
                'acp_nombre',
                'acp_estado',
                'acp_usu_creacion',
                'acp_usu_modificacion',
                'acp_fecha_creacion',
                'acp_fecha_modificacion'
            );

            $display_as = array(
                'acp_nombre' => 'Nombre',
                'acp_estado' => 'Estado',
                'acp_usu_creacion' => 'Usuario creacion',
                'acp_usu_modificacion' => 'Usuario modificacion',
                'acp_fecha_creacion' => 'Fecha creacion',
                'acp_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('acp_usu_creacion', 'hidden');
            $crud->field_type('acp_usu_modificacion', 'hidden');
            $crud->field_type('acp_fecha_creacion', 'hidden');
            $crud->field_type('acp_fecha_modificacion', 'hidden');
            $crud->field_type('acp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('acp_nombre', 'Nombre', 'campo_unico[acp_act_economica_prov.acp_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de actividad económica";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function tamanio_proveedor() {

        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('tamanio_proveedor');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('tap_tamano_prov');
            $crud->set_subject('');

            $columnas = array(
                'tap_nombre',
                'tap_estado'
            );

            $campos = array(
                'tap_nombre',
                'tap_estado',
                'tap_usu_creacion',
                'tap_usu_modificacion',
                'tap_fecha_creacion',
                'tap_fecha_modificacion'
            );

            $display_as = array(
                'tap_nombre' => 'Nombre',
                'tap_estado' => 'Estado'
            );


            $crud->field_type('tap_usu_creacion', 'hidden');
            $crud->field_type('tap_usu_modificacion', 'hidden');
            $crud->field_type('tap_fecha_creacion', 'hidden');
            $crud->field_type('tap_fecha_modificacion', 'hidden');
            $crud->field_type('tap_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('tap_nombre', 'Nombre', 'campo_unico[tap_tamano_prov.tap_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de tamaño de proveedor";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

// End tamanio proveedor

    function get_proveedor() {
        $id_contrato = $this->input->post('id_contrato');
        $prv_nombre = $this->entradas_model->get_proveedor_contrato($id_contrato);
        echo json_encode($prv_nombre);
    }

    function tipo_solicitud() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('tipo_solicitud');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('tsm_tipo_sol_mantto');
            $crud->set_subject('');

            $columnas = array(
                'tsm_nombre',
                'tsm_estado'
            );

            $campos = array(
                'tsm_nombre',
                'tsm_estado',
                'tsm_usu_creacion',
                'tsm_usu_modificacion',
                'tsm_fecha_creacion',
                'tsm_fecha_modificacion'
            );

            $display_as = array(
                'tsm_nombre' => 'Nombre',
                'tsm_estado' => 'Estado',
                'tsm_usu_creacion' => 'Usuario creacion',
                'tsm_usu_modificacion' => 'Usuario modificacion',
                'tsm_fecha_creacion' => 'Fecha creacion',
                'tsm_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('tsm_usu_creacion', 'hidden');
            $crud->field_type('tsm_usu_modificacion', 'hidden');
            $crud->field_type('tsm_fecha_creacion', 'hidden');
            $crud->field_type('tsm_fecha_modificacion', 'hidden');
            //$crud->field_type('tsm_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('tsm_nombre', 'Nombre', 'campo_unico[tsm_tipo_sol_mantto.tsm_nombre]|required');
            $crud->required_fields($columnas);
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tsm_estado', 'hidden', 1);
            } else {
                $crud->field_type('tsm_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'transporte/cruds/tipo_solicitud/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de tipos de solicitud";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function validar_codigo() {
        $codigo = $this->input->post('codigo');
        $id = $this->input->post('id');

        if ($id > 0) {
            $validar_codigo = $this->db->select('con_numero,con_id')
                            ->from('con_contrato_gasol')
                            ->where('con_id <>', $id)
                            ->where('con_numero', $codigo)
                            ->get()->result_array();
            if (count($validar_codigo) > 0) {
                if ($validar_codigo[0]['con_id'] == $id) {
                    $id = $validar_codigo[0]['con_id'];
                }
            } else {
                $id = 0;
            }
        } else {
            $validar_codigo = $this->db->select('con_numero,con_id')
                            ->from('con_contrato_gasol')
                            ->where('con_numero', $codigo)
                            ->get()->result_array();
            if (count($validar_codigo) > 0) {
                $id = $validar_codigo[0]['con_id'];
            } else {
                $id = 0;
            }
        }
        $data = array(
            'id' => $id,
            'response' => true);
        echo json_encode($data);
    }

    function tipo_fondo() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('tipo_fondo');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('tpf_tipo_fondo');
            $crud->set_subject('Tipo de fondo');

            $columnas = array(
                'tpf_nombre',
                'tpf_estado'
            );

            $campos = array(
                'tpf_nombre',
                'tpf_estado',
                'tpf_usu_creacion',
                'tpf_usu_modificacion',
                'tpf_fecha_creacion',
                'tpf_fecha_modificacion'
            );

            $display_as = array(
                'tpf_nombre' => 'Nombre',
                'tpf_estado' => 'Estado',
                'tpf_usu_creacion' => 'Usuario creacion',
                'tpf_usu_modificacion' => 'Usuario modificacion',
                'tpf_fecha_creacion' => 'Fecha creacion',
                'tpf_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('tpf_usu_creacion', 'hidden');
            $crud->field_type('tpf_usu_modificacion', 'hidden');
            $crud->field_type('tpf_fecha_creacion', 'hidden');
            $crud->field_type('tpf_fecha_modificacion', 'hidden');
            //$crud->field_type('tsm_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('tpf_nombre', 'Nombre', 'campo_unico[tpf_tipo_fondo.tpf_nombre]|required');
            $crud->required_fields($columnas);
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tpf_estado', 'hidden', 1);
            } else {
                $crud->field_type('tpf_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'transporte/cruds/tipo_fondo/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de tipos de fondos";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function tipos_recepcion() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('tipos_recepcion');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('tir_tipo_recepcion_veh');
            $crud->set_subject('');

            $columnas = array(
                'tir_nombre',
                'tir_descripcion',
                'tir_estado'
            );

            $campos = array(
                'tir_nombre',
                'tir_descripcion',
                'tir_estado',
                'tir_usu_creacion',
                'tir_usu_modificacion',
                'tir_fecha_creacion',
                'tir_fecha_modificacion'
            );

            $display_as = array(
                'tir_nombre'        => 'Nombre',
                'tir_descripcion'   => 'Descripción',
                'tir_estado'        => 'Estado',
                'tir_usu_creacion'  => 'Usuario creación',
                'tir_usu_modificacion'  => 'Usuario modificación',
                'tir_fecha_creacion'    => 'Fecha reacion',
                'tir_fecha_modificacion'=> 'Fecha Modificación',
            );

            $required = array(
                'tir_nombre', 'tir_descripcion'
            );


            $crud->field_type('tir_usu_creacion', 'hidden');
            $crud->field_type('tir_usu_modificacion', 'hidden');
            $crud->field_type('tir_fecha_creacion', 'hidden');
            $crud->field_type('tir_fecha_modificacion', 'hidden');
            //$crud->field_type('tir_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('tir_nombre', 'Nombre', 'campo_unico[tlc_tipo_licencia.tlc_nombre]|required');

            $crud->required_fields($required);
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tir_estado', 'hidden', 1);
            } else {
                $crud->field_type('tir_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $crud->columns($columnas);
            //$crud->fields($campos);
            $crud->field_type('tir_nombre', 'texteditor');
            $crud->field_type('tir_descripcion', 'texteditor');

            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'transporte/cruds/tipos_recepcion/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Tipos recepción";
            $this->_catalogo_output($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function herramientas_vehiculos() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('herramientas_vehiculos');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('hev_herramienta_vehiculo');
            $crud->set_subject('');

            $columnas = array(
                'hev_nombre',
                'hev_descripcion',
                'hev_estado'
            );

            $campos = array(
                'hev_nombre',
                'hev_descripcion',
                'hev_estado',
                'hev_usu_creacion',
                'hev_usu_modificacion',
                'hev_fecha_creacion',
                'hev_fecha_modificacion'
            );

            $display_as = array(
                'hev_nombre' => 'Nombre',
                'hev_descripcion' => 'Descripción',
                'hev_estado' => 'Estado',
                'hev_usu_creacion' => 'Usuario creación',
                'hev_usu_modificacion' => 'Usuario modificación',
                'hev_fecha_creacion' => 'Fecha reacion',
                'hev_fecha_modificacion' => 'Fecha Modificación',
            );


            $crud->field_type('hev_usu_creacion', 'hidden');
            $crud->field_type('hev_usu_modificacion', 'hidden');
            $crud->field_type('hev_fecha_creacion', 'hidden');
            $crud->field_type('hev_fecha_modificacion', 'hidden');
            //$crud->field_type('hev_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('hev_nombre', 'Nombre', 'campo_unico[tlc_tipo_licencia.tlc_nombre]|required');
            //		$crud->required_fields($columnas);
            $crud->required_fields('hev_nombre', 'hev_descripcion');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('hev_estado', 'hidden', 1);
            } else {
                $crud->field_type('hev_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            $crud->callback_add_field('hev_nombre', function () {
                return '<input type="text" maxlength="100" value="" name="hev_nombre">';
            });
            $crud->columns($columnas);
            //	$crud->fields($campos);
            //	$crud->field_type('hev_nombre', 'texteditor', 'maxlength="10"');
            $crud->field_type('hev_descripcion', 'texteditor');

            $crud->display_as($display_as);
            $crud->callback_before_insert(array($this, '_log_usuario_insert'));
            $crud->callback_before_update(array($this, '_log_usuario_update'));

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'transporte/cruds/herramientas_vehiculos/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Herramientas de vehículos";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function compania_seguros() {
        satelite_validar();
        $campos = array(
            'cms_nombre' => 'Nombre',
            'cms_descripcion' => 'Descripcion'
        );

        $add_fields = array(
            'cms_nombre',
            'cms_descripcion',
            'cms_estado',
            'cms_usu_creacion',
            'cms_fecha_creacion',
            'cms_usu_modificacion',
            'cms_fecha_modificacion'
        );

        $edit_fields = array(
            'cms_nombre',
            'cms_descripcion',
            'cms_estado',
            'cms_usu_creacion',
            'cms_fecha_creacion',
            'cms_usu_modificacion',
            'cms_fecha_modificacion'
        );

        $required_fields = array(
            'cms_nombre'
        );

        $display_as = array(
            'cms_nombre' => 'Nombre',
            'cms_estado' => 'Estado',
            'cms_descripcion' => 'Descripcion'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('cms_compania_seguro')
            ->set_subject('Compañía de seguro')
            ->columns('cms_nombre', 'cms_estado')
            ->display_as($display_as)
            ->add_fields($add_fields)
            ->edit_fields($edit_fields)
            ->required_fields($required_fields)
            ->set_rules('cms_nombre', 'Nombre', 'trim|campo_unico[cms_compania_seguro.cms_nombre]|required')
            ->field_type('cms_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('cms_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('cms_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('cms_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
        ;
        $crud->callback_add_field('cms_descripcion',function () {
            return '<input type="text" name="cms_descripcion" value="">';
        });
        $crud->callback_edit_field('cms_descripcion', function ($value) {
            return '<input type="text" name="cms_descripcion" value="'.$value.'">';
        });
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('cms_estado', 'hidden', 1);
        } else {
            $crud->field_type('cms_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $data['titulo_personal'] = "Catalogo compañias de seguro";
        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    /**
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-11-16
     * @return Vista de agregar proveedor - Funcionalidad compartida con el modulo de modulo de compraas
    */
    public function agregar_proveedor() {
        satelite_validar();
        $this->load->library('../controllers/modulo_compras/catalogos');
        $this->catalogos->agregar_proveedor(null, array('transporte/cruds/proveedores', 'modulo_compras/catalogos/agregar_proveedor'));
        die('éxito');
    }

    /**
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-11-16
     * @return Vista de Editar proveedor - Funcionalidad compartida con el modulo de modulo de compraas
    */
    public function editar_proveedor($prv_id) {
        satelite_validar();

        $this->load->library('../controllers/modulo_compras/catalogos');
        $this->catalogos->editar_proveedor($prv_id, null, array('transporte/cruds/proveedores', 'modulo_compras/catalogos/editar_proveedor'));
        die('éxito');
    }

    function _cargarvista($data = 0, $crud = 0, $modulo_principal = null) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario($modulo_principal));
        else
            $data = $this->masterpage->getUsuario($modulo_principal);

        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }   

    /**
     * @author Nelson Soriano
     * @since  23-08-2019
    */

    public function agregar_motorista($url = null,$retorno = null){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('motorista');
        $ruta = $permisos['modulo'] . '/' . $permisos['control'];
        $data['ruta'] = $ruta;
        if ($_POST) {
            $datos = $this->input->post();
            $redirect = $datos['txt_ruta'];
            $retorno  = $datos['txt_retorno'];
            $opcion   = $datos['btnCrear'];           
            
            $motorista = array(
                'mot_id_tlc'                => ($datos['slcTipoLicencia'] >0)? $datos['slcTipoLicencia']:null,
                'mot_empleado'              => $datos['slcEmpleado'],
                'mot_licencia'              => $datos['txtLicencia'],
                'mot_correo'                => $datos['txtEmail'],
                'mot_telefono'              => $datos['txtTelefono'],
                'mot_radio'                 => $datos['txtRadio'],
                'mot_fecha_venci'           => date_format(date_create($datos['txtFechaVencimiento']),'Y-m-d H:i:s'),
                'mot_descripcion_vehiculo'  => $datos['txtVehiculo'],
                'mot_posee_ayudante'        => ($datos['ayudante_activo'] != '')?$datos['ayudante_activo']:0,
                'mot_estado'                => 1,
                'mot_usu_creacion'          => $this->tank_auth->get_user_id(),
                'mot_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'mot_fecha_creacion'        => date('Y-m-d H:i:s'),
                'mot_fecha_modificacion'    => date('Y-m-d H:i:s')
            );
            $mot = $this->gsatelite->ingresar('mot_motorista',$motorista);
            if ($mot) {
                if (is_array($datos['slcEmpleadoAyudantes']) && count($datos['slcEmpleadoAyudantes']) >0) {
                    while (list($key,$val) = each($datos['slcEmpleadoAyudantes'])) {
                        if ($val > 0 && $mot > 0) {
                            $ayudantes  = array(
                                'exm_id_emp'             => $val,
                                'exm_id_mot'             => $mot,
                                'exm_estado'             => 1,
                                'exm_usu_creacion'       => $this->tank_auth->get_user_id(),
                                'exm_fecha_creacion'     => date('Y-m-d H:i:s'),
                                'exm_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                'exm_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('exm_empleadoxmotorista',$ayudantes);
                        }
                    }
                }

                //Anexos
                $carpeta = $this->input->post("nombreCarpeta");
                $rutas = $this->input->post("ruta");
                if (count($rutas) > 0) {
                    $carpeta = $carpeta;
                    for ($i = 0; $i < count($rutas); $i++) {
                        if ($rutas[$i] != "") {
                            $img = $rutas[$i];
                            $titulo = $this->input->post("titulo_doc". $i);
                            $this->datos_imagen_gral3($img, $mot, $carpeta, $titulo);

                        }
                    }
                } 

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Informacion almacenada", 'texto_alerta' => "Informacion almacenada con exito");
                $this->session->set_flashdata($alerta);
                if ($opcion == 1) {
                    redirect($redirect); 
                }else{
                    redirect($retorno);
                }
            }else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Error al ingresar informacion, intenta de nuevo");
                $this->session->set_flashdata($alerta);
                redirect($redirect);
            }

        }else{
            $data['urlx']            = ($url == null) ? 'transporte/cruds/agregar_motorista': $url;
            $data['retornox']        = ($retorno == null) ? 'transporte/cruds/motorista': $retorno;
            $data['titulo_personal'] = 'Agregar Motorista';
            $data['modulo']          = 'modulo_cuentas_pagar';

                                       $this->db->where('emp_id NOT IN (SELECT mot_empleado FROM mot_motorista)',null,false);
            $registros               = $this->gsatelite->get_tabla('emp_empleado',array('emp_estado' => 1));
            $opc                     = '';
            foreach ($registros as $key => $val) {
                $opc .= '<option value="'.$val['emp_id'].'" data-nombres="'.$val['emp_nombre'].'" data-apellidos="'.$val['emp_apellido'].'" data-correo="'.$val['emp_email'].'" data-codigo="'.$val['emp_codigo'].'">'.$val['emp_nombre']." ".$val['emp_apellido'].'</option>'; 
            }
            $data['slcEmp']          = $opc;
            $data['empleado']        = $this->gsatelite->get_dropdown('emp_empleado','{emp_nombre} {emp_apellido}','',array('emp_estado' => 1),'','','emp_id',true);
            $data['tipo_licencia']   = $this->gsatelite->get_dropdown('tlc_tipo_licencia','tlc_nombre','',array('tlc_estado' => 1),'','','tlc_id',true);
            cargarvista($data,null,'transporte/cruds/agregar_motorista');
        }
    } 

    public function editar_motorista($id_mot,$url = null,$retorno = null){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('motorista');
        $ruta = $permisos['modulo'] . '/' . $permisos['control'];
        $data['ruta'] = $ruta;
        if ($_POST) {
            $datos = $this->input->post();
            $redirect = $datos['txt_ruta'];
            $retorno  = $datos['txt_retorno'];
            $opcion   = $datos['btnCrear'];
            $motorista = array(
                'mot_id_tlc'                => ($datos['slcTipoLicencia'] >0)? $datos['slcTipoLicencia']:null,
                'mot_empleado'              => $datos['slcEmpleado'],
                'mot_licencia'              => $datos['txtLicencia'],
                'mot_correo'                => $datos['txtEmail'],
                'mot_telefono'              => $datos['txtTelefono'],
                'mot_radio'                 => $datos['txtRadio'],
                'mot_fecha_venci'           => date_format(date_create($datos['txtFechaVencimiento']),'Y-m-d H:i:s'),
                'mot_descripcion_vehiculo'  => $datos['txtVehiculo'],
                'mot_posee_ayudante'        => ($datos['ayudante_activo'] != '')?$datos['ayudante_activo']:0,
                'mot_estado'                => 1,
                'mot_usu_creacion'          => $this->tank_auth->get_user_id(),
                'mot_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'mot_fecha_creacion'        => date('Y-m-d H:i:s'),
                'mot_fecha_modificacion'    => date('Y-m-d H:i:s')
            );
            $mot = $this->gsatelite->actualizar_array('mot_motorista',$motorista,array('mot_id' => $id_mot));
            if ($mot) {
                if (is_array($datos['slcEmpleadoAyudantes']) && count($datos['slcEmpleadoAyudantes']) >0) {
                    $this->gsatelite->borrado_general('exm_empleadoxmotorista',array('exm_id_mot' => $id_mot));
                    while (list($key,$val) = each($datos['slcEmpleadoAyudantes'])) {
                        if ($val > 0 && $id_mot > 0) {
                            $ayudantes  = array(
                                'exm_id_emp'             => $val,
                                'exm_id_mot'             => $id_mot,
                                'exm_estado'             => 1,
                                'exm_usu_creacion'       => $this->tank_auth->get_user_id(),
                                'exm_fecha_creacion'     => date('Y-m-d H:i:s'),
                                'exm_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                'exm_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('exm_empleadoxmotorista',$ayudantes);
                        }
                    }
                }

                //Anexos//
                    $Anexo_proyecto  = $this->input->post('Anexo_proyecto');
                    $dataAnexos = $this->gsatelite->get_tabla('anm_anexo_motorista', array('anm_id_mot' => $id_mot));
                    if (!is_array($Anexo_proyecto)) {
                        $Anexo_proyecto = array();
                    }
                    foreach ($dataAnexos as $data) {
                        if (!in_array($data['anm_id'], $Anexo_proyecto)) {
                            $this->gsatelite->borrado_general('anm_anexo_motorista', array('anm_id' => $data['anm_id']));
                            $ruta_nxp = $data['anm_url'];
                            unlink($ruta_nxp);
                        }
                    }

                    $rutas = $this->input->post("ruta");
                    $carpeta = $this->input->post("nombreCarpeta");
                    if (count($rutas) > 0) {
                        $carpeta = $carpeta;
                        for ($i = 0; $i < count($rutas); $i++) {
                            if ($rutas[$i] != "") {
                                $img = $rutas[$i];
                                $titulo = $this->input->post("titulo_doc" . $i);
                                $this->datos_imagen_gral3($img, $id_mot, $carpeta, $titulo);

                            }
                        }
                    }
                /* Anexos */
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Informacion Actualizada", 'texto_alerta' => "Informacion actualizada con exito");
                $this->session->set_flashdata($alerta);
                if ($opcion == 1) {
                    redirect($redirect.'/'.$id_mot); die();
                }else{
                    redirect($retorno);
                }
                
            }else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Error al actualizar informacion, intenta de nuevo");
                $this->session->set_flashdata($alerta);
                redirect($redirect.'/'.$id_mot);
            }

        
        }else{
            $data['urlx']            = ($url == null)?'transporte/cruds/editar_motorista':$url;
            $data['retornox']        = ($retorno == null)?'transporte/cruds/motorista':$retorno;
            $data['titulo_personal'] = 'Editar Motorista';
            $data['modulo']          = 'modulo_cuentas_pagar';
                                       $this->db->join('emp_empleado', 'emp_id = mot_empleado','left');
                                       $this->db->join('exm_empleadoxmotorista', 'exm_id_mot = mot_id','LEFT');
            $data['info']            = $this->gsatelite->get_tabla('mot_motorista',array('mot_id' => $id_mot));

                                       $this->db->where("emp_id NOT IN (SELECT mot_empleado FROM mot_motorista WHERE mot_id !=$id_mot)",null,false);  
            $registros               = $this->gsatelite->get_tabla('emp_empleado',array('emp_estado' => 1));
            $opc                     = '<option></option>';
            $id = $data['info'][0]['mot_empleado'];
            foreach ($registros as $key => $val) {
                if ($val['emp_id'] == $id) {
                   $opc .= '<option selected="selected" value="'.$val['emp_id'].'" data-nombres="'.$val['emp_nombre'].'" data-apellidos="'.$val['emp_apellido'].'" data-correo="'.$val['emp_email'].'" data-codigo="'.$val['emp_codigo'].'">'.$val['emp_nombre']." ".$val['emp_apellido'].'</option>'; 
                }
                $opc .= '<option value="'.$val['emp_id'].'" data-nombres="'.$val['emp_nombre'].'" data-apellidos="'.$val['emp_apellido'].'" data-correo="'.$val['emp_email'].'" data-codigo="'.$val['emp_codigo'].'">'.$val['emp_nombre']." ".$val['emp_apellido'].'</option>'; 
            }

            $data['slcEmp']          = $opc;
            $data['anexos']          = $this->gsatelite->get_tabla('anm_anexo_motorista',array('anm_id_mot' => $id_mot));
            $data['empleado']        = $this->gsatelite->get_dropdown('emp_empleado','{emp_nombre} {emp_apellido}','',array('emp_estado' => 1),$data['info'][0]['mot_empleado'],'','emp_id',true);
            $data['ayudantes']       = $this->gsatelite->get_dropdown('emp_empleado','{emp_nombre} {emp_apellido}','',array('emp_estado' => 1),array_column($data['info'],'exm_id_emp'),'','emp_id',true);
            $data['tipo_licencia']   = $this->gsatelite->get_dropdown('tlc_tipo_licencia','tlc_nombre','',array('tlc_estado' => 1),$data['info'][0]['mot_id_tlc'],'','tlc_id',true);
            $data['mot']             = $id_mot;
            cargarvista($data,null,'transporte/cruds/editar_motorista');
        }
    }

    public function guardar_gral($parametros, $carpeta = null) {
        $datos = @explode($parametros);
        $carpeta = $parametros;

        $image = $this->upload_gral($carpeta);
        echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
    }

     function upload_gral($carpeta) {

        if ($carpeta == "assets") {
            $ruta = FCPATH . "assets/uploads/images";
        } else {
            $ruta = FCPATH . "public/temp/" . $carpeta;
        }

        if (!file_exists($ruta)) {
            mkdir($ruta, 0777);
        }
        $obj = &get_instance();
        $config['upload_path'] = $ruta;
        $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx';
        $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return true;
        } else {
            $data = array('upload_data' => $obj->upload->data());
            return $data;
        }
        print_r($data);
    }

    public function datos_imagen_gral3($img, $mot, $carpeta, $titulo_doc, $tipo = 0) {
        $extencion = end(explode(".", $img));
        $datos_1 = $this->session->keep_flashdata('datos_1');
        $nombre = trim($img);
        $ruta = "public/temp/".$carpeta . "/" . $nombre;
        $destino = "uploads/anexos_motoristas/" . $titulo_doc . "." . trim($extencion) . "";
        $dir = $this->gsatelite->get_campo('anm_anexo_motorista', 'anm_url', array('anm_url' => $destino, 'anm_estado' => 1));
        // Si ya existe, no se ingresa.

        if (count($dir) <= 0) {
            $array_anex = array(

                'anm_id_mot'             => $mot,
                'anm_url'                => $destino,
                'anm_nombre'             => $nombre, 
                'anm_estado'             => 1,
                'anm_usu_creacion'       => $this->tank_auth->get_user_id(),
                'anm_fecha_creacion'     => date('Y-m-d H:i:s'),
                'anm_usu_modificacion'   => $this->tank_auth->get_user_id(),
                'anm_fecha_modificacion' => date('Y-m-d H:i:s')

            );

            $this->db->insert("anm_anexo_motorista", $array_anex);
            $id_anexo = $this->db->insert_id();
            $carpeta_destino = "uploads/anexos_motoristas/" . $titulo_doc . "." . trim($extencion) . "";
            copy($ruta, $carpeta_destino);
            unlink($ruta);
        }
    }

    /**
     * Descripción:
     * Función para gestionar estados de mantenimiento
     * @author René Castaneda - Grupo Satélite
     * @since 2021-10-01
     * @param none
     * @return view
     */
    function estado_mantenimiento() {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            try {
                $crud = new grocery_CRUD();
                $permisos = $this->gsatelite->get_permisos_opcion();
                //Columnas a mostrar en READ
                $columns = array(
                    'emt_orden',
                    'emt_nombre',
                    'emt_cerrado',
                    'emt_estado',
                    'emt_seguimiento',
                    'emt_seguimiento_prox',
                );

                //Alias para las columnas
                $alias = array(
                    'emt_nombre' => 'Nombre',
                    'emt_estado' => 'Estado',
                    'emt_cerrado' => 'Cerrado',
                    'emt_seguimiento' => 'Brindar Seguimiento',
                    'emt_seguimiento_prox' => 'Aplica prox. seguimiento',
                    'emt_orden' => 'Orden Sugerido',
                    'emt_color_indicador' => 'Color Indicador'
                );


                //Columnas a mostrar en ADD
                $add_columns = array(
                    'emt_nombre',
                    'emt_estado',
                    'emt_cerrado',
                    'emt_seguimiento',
                    'emt_seguimiento_prox',
                    'emt_orden',
                    'emt_color_indicador',
                    'emt_fecha_creacion',
                    'emt_usu_creacion',
                    'emt_fecha_modificacion',
                    'emt_usu_modificacion',
                );

                $required_fields = array(
                    'emt_nombre',
                    'emt_estado',
                    'emt_cerrado',
                    'emt_seguimiento',
                    'emt_seguimiento_prox',
                );

                //Columnas a mostrar en EDIT
                $edit_columns = $add_columns;

                $crud->set_table('emt_estado_mantenimiento')
                        ->set_subject('')
                        ->columns($columns)
                        ->display_as($alias)
                        ->add_fields($add_columns)
                        ->edit_fields($edit_columns)
                        ->required_fields($required_fields)
                        ->set_rules('emt_nombre', 'Nombre', 'trim|required|campo_unico[emt_estado_mantenimiento.emt_nombre]')
                        ->set_rules('emt_orden', 'Orden', 'trim|required|campo_unico[emt_estado_mantenimiento.emt_orden]')
                        ->field_type('emt_cerrado', 'dropdown', array('1' => 'Si', '0' => 'No'))
                        ->field_type('emt_seguimiento', 'dropdown', array('1' => 'Sí', '0' => 'No'))
                        ->field_type('emt_seguimiento_prox', 'dropdown', array('1' => 'Sí', '0' => 'No'))
                        ->field_type('emt_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('emt_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('emt_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('emt_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                        ;
                $crud->callback_field('emt_color_indicador',array($this,'field_callback_1'));
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('emt_estado', 'hidden', 1);
                } else {
                    $crud->field_type('emt_estado', 'dropdown', array('1' => 'Activado', '0' => 'Inactivo'));
                }

                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                $output = $crud->render();

                $data['titulo_personal'] = 'Estados de mantenimiento';
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    function field_callback_1($value = '', $primary_key = null)
    {
        return '
        <div class="span10" style="display: flex">
            <input type="text" id="field-emt_color_indicador" name="emt_color_indicador" style="width:35% !important;display: inline-block;" value="'.$value.'">
            <div id="colorSelector" style="margin-left:7px;">
                <div style="background-color:'.$value.'"></div>
            </div>
        </div>
        ';
    }

}
