<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Configuracion extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->database();
		$this->load->helper('url');

		$this->load->library('grocery_CRUD');
	}

	public function flujo()
	{
		try{
			$permisos= $this->gsatelite->get_permisos_opcion('flujo');
			$crud = new grocery_CRUD();
			$crud->unset_export();
			$crud->unset_print();
			$crud->set_table('flu_flujo');
			$crud->set_subject('');
			
			$columnas = array(
							'flu_nombre',
							'flu_descripcion',
							'flu_estado'							
							);

			$campos = array(
							'flu_nombre',
							'flu_descripcion',
							'flu_estado',
							'flu_usu_creacion',
							'flu_usu_modificacion',
							'flu_fecha_creacion',
							'flu_fecha_modificacion'
							);

			$display_as = array(
							'flu_nombre' => 'Nombre',
							'flu_descripcion' => 'Descripción',
							'flu_estado' => 'Estado',
							'flu_usu_creacion' => 'Usuario Creación',
							'flu_usu_modificacion' => 'Usuario Modificación',
							'flu_fecha_creacion' => 'Fecha Creación',
							'flu_fecha_modificacion' => 'Fecha Modificación'
							);

			
			$crud->field_type('flu_usu_creacion', 'hidden');
			$crud->field_type('flu_usu_modificacion', 'hidden');
			$crud->field_type('flu_fecha_creacion', 'hidden');
			$crud->field_type('flu_fecha_modificacion', 'hidden');	
			$crud->field_type('flu_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
			$crud->set_rules('flu_nombre','Nombre','campo_unico[flu_flujo.flu_nombre]|required');

			$crud->columns($columnas);
			$crud->fields($campos);
			$crud->display_as($display_as);
			$crud->required_fields('flu_nombre', 'flu_estado');
			$crud->callback_before_insert(array($this, '_log_usuario_insert'));
    		$crud->callback_before_update(array($this, '_log_usuario_update'));

    		// Validaciones
		    if(!$permisos['permite_agregar']) { $crud->unset_add();} 
		    if(!$permisos['permite_editar']) { $crud->unset_edit();}
		    if(!$permisos['permite_eliminar']) { $crud->unset_delete();} 
		    if($permisos['permite_ver']) {
		      $crud->add_action('Ver','minia-icon-search','transporte/configuracion/flujo/read');
		     } 

			$output = $crud->render();
			$data['titulo_personal']="Catálogo de flujos de trabajo";

			$this->_catalogo_output($data, $output);

		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	} // End flujo

	


		public function accion()
	{
		try{
			satelite_validar();
			$permisos= $this->gsatelite->get_permisos_opcion('accion');
			$crud = new grocery_CRUD();
			$crud->unset_export();
			$crud->unset_print();			
			$crud->set_table('acc_accion');
			$crud->set_subject('');
			
			$columnas = array(
							'acc_nombre',
							'acc_icono'							
							);

			$campos = array(
							'acc_nombre',
							'acc_icono',
							'acc_usu_creacion',
							'acc_usu_modificacion',
							'acc_fecha_creacion',
							'acc_fecha_modificacion'
							);

			$display_as = array(
							'acc_nombre' => 'Nombre',
							'acc_icono' => 'Icono',
							'acc_usu_creacion' => 'Usuario Creacion',
							'acc_usu_modificacion' => 'Usuario Modificacion',
							'acc_fecha_creacion' => 'Fecha Creacion',
							'acc_fecha_modificacion' => 'Fecha Modificacion'
							);

			$this->load->config('grocery_crud');
    		$this->config->set_item('grocery_crud_file_upload_allow_file_types',
                                                            'gif|jpeg|jpg|png');

			//$crud->callback_before_upload(array($this,'formato_img_callback_before_upload'));

			$crud->field_type('acc_usu_creacion', 'hidden');
			$crud->field_type('acc_usu_modificacion', 'hidden');
			$crud->field_type('acc_fecha_creacion', 'hidden');
			$crud->field_type('acc_fecha_modificacion', 'hidden');	

			$crud->set_field_upload('acc_icono','uploads/catalogos/acciones');
			$crud->set_rules('acc_nombre','Nombre','campo_unico[acc_accion.acc_nombre]|required');
			
			$crud->columns($columnas);
			$crud->fields($campos);
			$crud->required_fields('acc_nombre');
			$crud->display_as($display_as);
			$crud->callback_before_insert(array($this, '_log_usuario_insert'));
    		$crud->callback_before_update(array($this, '_log_usuario_update'));

    		// Validaciones
		    if(!$permisos['permite_agregar']) { $crud->unset_add();} 
		    if(!$permisos['permite_editar']) { $crud->unset_edit();}
		    if(!$permisos['permite_eliminar']) { $crud->unset_delete();} 
		    if($permisos['permite_ver']) {
		      $crud->add_action('Ver','minia-icon-search','transporte/configuracion/accion/read');
		     } 

			$output = $crud->render();
			$data['titulo_personal']="Catálogo de acciones";
			$this->_catalogo_output($data, $output);

		}catch(Exception $e){
			show_error($e->getMessage().' --- '.$e->getTraceAsString());
		}
	}



	   /**
   * @author Christian  
   * @return Mantenimiento Etapas Entregables
   */
 //Examples of what the $files_to_upload and $field_info will be:    
  /* function formato_img_callback_before_upload($files_to_upload,$field_info)
{

    foreach($files_to_upload as $value) {
        $ext = pathinfo($value['name'], PATHINFO_EXTENSION);
    }

    $allowed_formats = array("jpg","gif","pdf","png","ico");
    if(in_array($ext,$allowed_formats))
    {
        return true;
    }
    else
    {
    	//$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Compomente ingresado",'texto_alerta'=>"La operación a sido realizada con exito");
        //return 'El formato de archivo es incorrecto';    
    	return 'aaa';
    }

         
}*/

	//======================================================================
// INICIO DE CALLBACKS
//======================================================================
	function _log_usuario_insert($post_array)
	{
		reset($post_array);
	    $sufijo = explode("_", key($post_array));
	    $post_array[$sufijo[0] . '_usu_modificacion'] = $this->tank_auth->get_user_id();
		$post_array[$sufijo[0] . '_fecha_modificacion'] = date('Y-m-d H:i:s');
		$post_array[$sufijo[0] . '_usu_creacion'] = $this->tank_auth->get_user_id();
		$post_array[$sufijo[0] . '_fecha_creacion'] = date('Y-m-d H:i:s');
  		return $post_array;
	}

	function _log_usuario_update($post_array)
	{
	    reset($post_array);
	    $sufijo = explode("_", key($post_array));
		$post_array[$sufijo[0] . '_usu_modificacion'] = $this->tank_auth->get_user_id();
		$post_array[$sufijo[0] . '_fecha_modificacion'] = date('Y-m-d H:i:s');
		return $post_array;
	}	
//======================================================================
// FIN DE CALLBACKS
//======================================================================

	function _catalogo_output($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		//$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$vista = 'cruds.php';
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}

	function _cargarvista($data=0,$crud=0)
	  { 
	    $this->load->view('vacia',$crud); 
	    if($data!=0)
	      $data=array_merge($data,$this->masterpage->getUsuario());
	    else
	      $data=$this->masterpage->getUsuario();    
	    $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
	    $this->masterpage->setMasterPage('masterpage_default');
	    $this->masterpage->addContentPage($vista, 'content',$data);
	    $this->masterpage->show();
	  }
} // End of class Configuracion 