<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Reportes extends CI_Controller{

	function __construct(){
		parent::__construct();
		$this->load->model('tarificador_model');
		$this->load->model('facturacion_model');
		$this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
	}

	function index(){
		if(!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		}
		else{
			$data['titulo_personal']='Tarificador';		
			$this->_cargarvista();
		}
	}

	/**
	*  Reporte "Detalle Facturacion"
    */
	function detalle_facturacion(){
		if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		}
		else{


			$data['factura'] = $this->gsatelite->get_tabla('fac_factura',array('fac_estado'=>1));

			$data["titulo_personal"] ="Detalle de Costo por Facturación";

			$this->_cargarvista($data);
		}
	}

	public function consultar_detalle_facturacion($return=null){

		$factura= ($this->input->post('factura')!='') ? $this->input->post('factura') : 0;

		$listado_detalle = $this->tarificador_model->reporte_detalle_facturacion($factura);
                
		$cadena="";
		$total_general = 0;

		foreach ($listado_detalle as $key => $det) {
                        
                        $detalle_costo = (json_decode($det['detalle_costo']!=NULL))? implode(', ', json_decode($det['detalle_costo'])): '$'.$det['costo'];
                        
			$cadena.="<tr>";
			$cadena.="<td>".$det['numero_telefono']."</td>";
			$cadena.="<td>".$det['numero_destino']."</td>";
			$cadena.="<td>".$det['Pais_Operador']."</td>";
			$cadena.="<td>".$det['fecha']."</td>";
			$cadena.="<td>".$det['hora']."</td>";
			$cadena.="<td>".$det['minutos']."</td>";
			$cadena.="<td>".$detalle_costo."</td>";
			$cadena.="<td>".$det['total']."</td>";

			$cadena.='</tr>';
			$total_general+=$det['total'];
		}

		$cadena.='<tr>';
    	$cadena.='<td colspan="7" style="text-align:left;">Total de costo por facturación</td>';
    	$cadena.='<td>'.number_format($total_general,2).'</td>';
    	$cadena.='</tr>';

		if (!empty($listado_detalle)) {

			$arreglo=array('drop'=>$cadena);
			

		}else {
			$arreglo=array('drop'=>"<tr><td colspan='8'>No existen datos</td></tr>");
		}

		if($return!=null){
			return $arreglo;
		}
		else{
			echo json_encode($arreglo);	
		}		
    }

     public function reporte_detalle_facturacion($tipo=null,$origen=null){
    	if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		}

		$factura= ($this->input->post('factura')!='') ? $this->input->post('factura') : 0;

		$listado_detalle = $this->tarificador_model->reporte_detalle_facturacion($factura);

		$cadena="";
		$total_general = 0;

    	$rows=$this->load->view('reporte/header', array('titulo' => "Detalle de Costo por Facturación"), true);
    	//<meta http-equiv="content-type" content="text/html; charset=utf-8">
    	if($tipo==2){ $cadena.='<table></table>'; }
    	$cadena='<table class="tabla" style="border:1px solid black;">';
    	$cadena.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Origen</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Terminación</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Nombre Destino</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Fecha</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Hora</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Minutos</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Costo ($)</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Total ($)</th>';
    	$cadena.='</tr>';

    	foreach ($listado_detalle as $det) {

                $detalle_costo = (json_decode($det['detalle_costo']!=NULL))? implode(', ', json_decode($det['detalle_costo'])): '$'.$det['costo'];
    		$cadena.="<tr style='border:1px solid black;'>";
			$cadena.="<td>".$det['numero_telefono']."</td>";
			$cadena.="<td>".$det['numero_destino']."</td>";
			$cadena.="<td>".$det['Pais_Operador']."</td>";
			$cadena.="<td>".$det['fecha']."</td>";
			$cadena.="<td>".$det['hora']."</td>";
			$cadena.="<td>".$det['minutos']."</td>";
			$cadena.="<td>".$detalle_costo."</td>";
			$cadena.="<td>".number_format($det['total'],2)."</td>";

			$cadena.='</tr>';
			$total_general+=$det['total'];
    	}

    	$cadena.='<tr>';
    	$cadena.='<td colspan="2" >Total de costo por facturación</td>';
    	$cadena.='<td colspan="5"></td><td>'.number_format($total_general,2).'</td>';
    	$cadena.='</tr>';

    	$cadena.='</table>';

    	$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

    	if($tipo==1){
    		$data['table_header']     = $rows;
    		$data['table_tbody']      = $cadena;
    		
    		$this->pdf->reportePDF('tarificador/reportes/reporte_pdf.php', $data);
    	}
    	else if($tipo==2){
    		$data['table_header']     = "REPORTES DE DETALLE DE COSTOS POR FACTURACIÓN";
    		$data['table_tbody']      = $cadena;
    		$data['filename']         = $filename;
    		$this->load->view('tarificador/reportes/reporte_excel.php', $data);
    	}
    }

    /**
	*  Reporte "Detalle CDR"
    */
	function detalle_cdr($cdd_id=null){
		if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		} else {

			$listado_cdr = $this->tarificador_model->get_listado_cdr();

			$data['listado_cdr']= $listado_cdr;

			//Dropdown de numeros de origen
			$this->db->group_by('cdd_numero_origen');
			$data['cdr'] = $this->gsatelite->get_tabla('cdd_cdr_detalle');
							//$tde_id=$this->gsatelite->get_parametro('SYS_TIPO_DOC');
                            //$this->db->join('dcc_documento_cliente', 'dcc_id_cli=cli_id AND dcc_id_tde='.$tde_id.'', 'left');
            $data['clientes']=$this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', null, null, '','cli_id', true);
			$data['servicios'] = $this->gsatelite->get_dropdown('src_servicio', '{src_nombre}','', null, null, '', 'src_id', true);

			$data["titulo_personal"] ="Consulta de CDR";

			$this->_cargarvista($data);
		}
	}

	public function consultar_detalle_cdr($return=null){

		$origen = ($this->input->post('origen')!='') ? $this->input->post('origen') : "";

		$fecha_ini = ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

		$fecha_fin = ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

		$procesado = ($this->input->post('procesado')!='') ? $this->input->post('procesado') : "";

		$procesado = ( $procesado == 2 ) ? 0 : $procesado;

		if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

		$listado_cdr = $this->tarificador_model->get_listado_cdr($origen,$fecha_ini,$fecha_fin,$procesado);

		$cadena="";

		foreach ($listado_cdr as $key => $cdr) {
                        $detalle_costo = (json_decode($cdr['detalle_costo']!=NULL))? implode(', ', json_decode($cdr['detalle_costo'])): $cdr['costo'];
                        
			$cadena.="<tr style='border:1px solid black;'>";
                        
                        $cadena.="<td>".$cdr['coe_codigo']."</td>";
			$cadena.="<td>".$cdr['origen']."</td>";
			$cadena.="<td>".$cdr['Terminacion']."</td>";
			$cadena.="<td>".$cdr['servicio']."</td>";
			$cadena.="<td>".$cdr['nombre_destino']."</td>";
			$cadena.="<td>".$cdr['fecha']."</td>";
			$cadena.="<td>".$cdr['hora']."</td>";
			$cadena.="<td>".$cdr['minutos']."</td>";
			$cadena.="<td>".$detalle_costo."</td>";
			$cadena.="<td>$".$cdr['total']."</td>";
			//$cadena.='<td style="text-align:center">'.$cdr['procesado'].'</td>';

			$cadena.='</tr>';
		}

		if (!empty($listado_cdr)){
			$arreglo=array('drop'=>$cadena);
		}
		else {
			$arreglo=array('drop'=>"<tr><td colspan='10'>No existen datos</td></tr>");		
		}

		if($return!=null){
			return $arreglo;
		}
		else{
			echo json_encode($arreglo);
		}
    }

    public function reporte_detalle_cdr($tipo=null,$origen=null){
    	if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		}

		$origen = ($this->input->post('origen')!='') ? $this->input->post('origen') : "";

		$procesado = ($this->input->post('procesado')!='') ? $this->input->post('procesado') : "";

		$fecha_ini = ($this->input->post('fecha_inicio')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_inicio'))) : "";

		$fecha_fin = ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

		if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

		$procesado = ( $procesado == 2 ) ? 0 : $procesado;

    	$listado_cdr = $this->tarificador_model->get_listado_cdr($origen,$fecha_ini,$fecha_fin,$procesado);

    	$cadena="";

    	$rows=$this->load->view('reporte/header', array('titulo' => "Detalle de CDR"), true);
    	//<meta http-equiv="content-type" content="text/html; charset=utf-8">
    	if($tipo==2){ $cadena.='<table></table>'; }
    	$cadena='<table class="tabla" style="border:1px solid black;">';
    	$cadena.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
        $cadena.='<th style="text-align:center; font-weight:bold;">Código error</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Origen</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Terminación</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Servicio</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Nombre Destino</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Fecha</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Hora</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Minutos</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Costo ($)</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Total ($)</th>';
    	//$cadena.='<th style="text-align:center; font-weight:bold;">Procesado</th>';
    	$cadena.='</tr>';

    	foreach ($listado_cdr as $cdr) {
                $detalle_costo = (json_decode($cdr['detalle_costo']!=NULL))? implode(', ', json_decode($cdr['detalle_costo'])): $cdr['costo'];
                
    		$cadena.='<tr style="border:1px solid black;">';
                        $cadena.="<td>".$cdr['coe_codigo']."</td>";
			$cadena.="<td>".$cdr['origen']."</td>";
			$cadena.="<td class='text'>".$cdr['Terminacion']."</td>";
			$cadena.="<td>".$cdr['servicio']."</td>";
			$cadena.="<td>".$cdr['nombre_destino']."</td>";
			$cadena.="<td>".$cdr['fecha']."</td>";
			$cadena.="<td>".$cdr['hora']."</td>";
			$cadena.="<td>".$cdr['minutos']."</td>";
			$cadena.="<td>".$detalle_costo."</td>";
			$cadena.="<td>$".number_format($cdr['total'],2)."</td>";
			// $cadena.='<td style="text-align:center">'.$cdr['procesado'].'</td>';
    		$cadena.="</tr>";
    	}

    	$cadena.='</table>';

    	$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

    	if($tipo==1){
    		$data['table_header']     = $rows;
    		$data['table_tbody']      = $cadena;
    		
    		$this->pdf->reportePDF('tarificador/reportes/reporte_pdf.php', $data,null,'L');
    	}
    	else if($tipo==2){
    		$data['table_header']     = "REPORTES DE LISTADO DE CDR";
    		$data['table_tbody']      = $cadena;
    		$data['filename']         = $filename;
    		$this->load->view('tarificador/reportes/reporte_excel.php', $data);
    	}
    }

    function obtener_cdr_cliente_servicio($cliente=null,$servicio=null){
    	if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		}
		else{

			$opciones = '';
			if($_POST){
				$cliente = ($this->input->post('cliente')!='') ? $this->input->post('cliente') : null;
				$servicio = ($this->input->post('servicio')) ? $this->input->post('servicio'): null;
			}

			$where=null;

			if($cliente!=null && $servicio==null){
				$where = 'cli_id = '.$cliente;
			}

			else if($servicio!=null && $cliente==null){
				$where = 'src_id = '.$servicio;
			}
			else if($servicio!=null && $cliente!=null){
				$where='cli_id = '.$cliente.' AND src_id = '.$servicio.'';
			}

			if($where!=null){
				//die(var_dump($where));
				$result = $this->tarificador_model->get_cdr_cliente_servicio($where);
				//die(var_dump($result));
				$opciones = '<option value="">Seleccione</option>';
				if(count($result)>0){
					
					foreach($result as $res){
						
						$opciones.= '<option value="'.$res['numero_origen'].'">'.$res['numero_origen'].'</option>';
					}
				}
				echo $opciones;
			}
			else{
				$opciones = '';
			}
		}
    }

    function clientes(){
    	if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		} else {

			$listado_clientes = $this->tarificador_model->reporte_clientes();
			//die(var_dump($listado_clientes));
			$data['listado_clientes']= $listado_clientes;

			$data['tipos'] = $this->gsatelite->get_dropdown('tpc_tipo_cliente', '{tpc_nombre}','',array('tpc_estado'=>1), null, '', 'tpc_id', true);

			$data["titulo_personal"] ="Reporte de Clientes";

			$this->_cargarvista($data);
		}
    }

    public function consultar_reporte_clientes($return=null){

		$tipo_cliente = ($this->input->post('tipo')!='') ? $this->input->post('tipo') : 0;

		$listado_clientes = $this->tarificador_model->reporte_clientes($tipo_cliente);

		$cadena="";

		foreach ($listado_clientes as $key => $cli) {

			$cadena.="<tr style='border:1px solid black;'>";
			$cadena.="<td>".$cli['codigo']."</td>";
			$cadena.="<td>".$cli['nombre']."</td>";
			$cadena.="<td>".$cli['NIT']."</td>";
			$cadena.="<td>".$cli['DUI']."</td>";
			$cadena.="<td>".$cli['razon_social']."</td>";
			$cadena.="<td>".$cli['tipo_cliente']."</td>";
			$cadena.='</tr>';
		}

		if (!empty($listado_clientes)){
			$arreglo=array('drop'=>$cadena);
		}
		else {
			$arreglo=array('drop'=>"<tr><td colspan='6'>No existen datos</td></tr>");		
		}

		if($return!=null){
			return $arreglo;
		}
		else{
			echo json_encode($arreglo);
		}
    }

    function reporte_clientes($tipo=null){
    	if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		}

		$tipo_cliente = ($this->input->post('tipo')!='') ? $this->input->post('tipo') : 0;

		$listado_clientes = $this->tarificador_model->reporte_clientes($tipo_cliente);

		$cadena="";

    	$rows=$this->load->view('reporte/header', array('titulo' => "Clientes"), true);
    	//<meta http-equiv="content-type" content="text/html; charset=utf-8">
    	if($tipo==2){ $cadena.='<table></table>'; }
    	$cadena='<table class="tabla" style="border:1px solid black;">';
    	$cadena.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Código</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Nombre</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">NIT</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">DUI</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Razon Social</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Tipo Cliente</th>';
    	$cadena.='</tr>';

    	foreach ($listado_clientes as $key => $cli) {

			$cadena.="<tr style='border:1px solid black;'>";
			$cadena.="<td>".$cli['codigo']."</td>";
			$cadena.="<td>".$cli['nombre']."</td>";
			$cadena.="<td>".$cli['NIT']."</td>";
			$cadena.="<td>".$cli['DUI']."</td>";
			$cadena.="<td>".$cli['razon_social']."</td>";
			$cadena.="<td>".$cli['tipo_cliente']."</td>";
			$cadena.='</tr>';
		}

    	$cadena.='</table>';

    	$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

    	if($tipo==1){
    		$data['table_header']     = $rows;
    		$data['table_tbody']      = $cadena;
    		
    		$this->pdf->reportePDF('tarificador/reportes/reporte_pdf.php', $data);
    	}
    	else if($tipo==2){
    		$data['table_header']     = "REPORTE DE CLIENTES";
    		$data['table_tbody']      = $cadena;
    		$data['filename']         = $filename;
    		$this->load->view('tarificador/reportes/reporte_excel.php', $data);
    	}
    }



    //REPORTE FACTURACIÓN
    function consolidado_min(){
    	if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		} else {

			$data['listado_departamentos'] = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}','', null, null, '', 'dep_id', true);

			$data['departamentos']  =$this->gsatelite->get_tabla('dep_departamento');


			$data["titulo_personal"] ="Consolidado de Minutos";

			$this->_cargarvista($data);
		}
    }
    
    function cdr_no_procesados($tipo=NULL)
    {
        satelite_validar();
        if($_POST){
            $fecha_inicio = ($this->input->post('fecha_inicio')!='')? $this->input->post('fecha_inicio'):date('Y-m-1');
            $fecha_fin  =   (($this->input->post('fecha_fin')!=''))? $this->input->post('fecha_fin'):date('Y-m-t');
     		       
            $condiciones = array(
              'cdr_estado'  =>  0,
              'cdr_procesado'=> 0,
              'cdr_fecha_proceso >=' =>    date('Y-m-d', strtotime($fecha_inicio)),
              'cdr_fecha_proceso <=' =>    date('Y-m-d', strtotime($fecha_fin))
            );
            //die(var_dump($_POST));
            $this->db->order_by('cdr_fecha_proceso','DESC');
            $data['cdr_lista'] = $this->gsatelite->get_tabla('cdr_resumen', $condiciones);
            
            $data['tipo'] = $tipo;
            $html =   $this->load->view('tarificador/reportes/tabla_cdr_no_procesados', $data, true);
            
            $rows=$this->load->view('reporte/header', array('titulo' => "CDR no procesados"), true);
     
            if($tipo==1){
                $data['table_header']     = $rows;
    		$data['table_tbody']      = $html;
    		$this->pdf->reportePDF('tarificador/reportes/reporte_pdf.php', $data,null,'L');
                
            } else if($tipo==2){
                $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
                $data['table_header']     = "CDR no procesados";
    		$data['table_tbody']      = $html;
    		$data['filename']         = $filename;
    		$this->load->view('tarificador/reportes/reporte_excel.php', $data);
            } else {
                die(json_encode(array('drop'=>$html)));
            }   
        } else {
            $condiciones = array(
              'cdr_estado'  =>  0,
              'cdr_procesado'=> 0,
              'cdr_fecha_proceso >=' =>    date('Y-m-1'),
              'cdr_fecha_proceso <=' =>    date('Y-m-t') 
            );
            
            $data['cdr_lista'] = $this->gsatelite->get_tabla('cdr_resumen', $condiciones);
            $data["titulo_personal"] ="CDR no procesados";
            $this->_cargarvista($data);
        }
    } // End cdr_no_procesados

    public function consultar_consolidado_min($return=null){

		$depto= ($this->input->post('depto')!='') ? $this->input->post('depto') : 0;

		$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

		$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

		if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

		$cadena="";

		if($depto>0){
			$departamento = $this->gsatelite->get_tabla('dep_departamento',array('dep_id'=>$depto));

			$listado_cdr = $this->tarificador_model->get_consolidado_min($depto,$fecha_ini,$fecha_fin);

			$cadena.="<tr>";
			$cadena.="<td>".$departamento[0]['dep_nombre']."</td>";

			if(count($listado_cdr)>0){
				$cadena.="<td  style='padding: 0px;'>
				<table class='table_sub'>";

				//Nombre
				foreach($listado_cdr as $lst) { 
					$cadena.='<tr style="border:1px solid black;">';
					$cadena.='<td>'.$lst['ppa_nombre'].'</td>';
					$cadena.='</tr>';
				}
				$cadena.='</table></td>';

				//Minutos
				$cadena.="<td style='padding: 0px;'>
				<table class='table_sub'>";

				//Nombre
				foreach($listado_cdr as $lst) { 
					$cadena.='<tr>';
					$cadena.='<td>'.$lst['minutos'].'</td>';
					$cadena.='</tr>';
				}
				$cadena.='</table></td>';

				//Total
				$cadena.="<td style='padding: 0px;'>
				<table class='table_sub'>";

				//Nombre
				foreach($listado_cdr as $lst) { 
					$cadena.='<tr>';
					$cadena.='<td>'.number_format($lst['total'],2).'</td>';
					$cadena.='</tr>';
				}
				$cadena.='</table></td>';
			}
			else{ 
				$cadena.="<td>--</td>";
				$cadena.="<td>0.00</td>";
				$cadena.="<td>$0.00</td>";
			}
		}
		else{
			$departamento = $this->gsatelite->get_tabla('dep_departamento');

			foreach($departamento as $dep){
				$listado_cdr = $this->tarificador_model->get_consolidado_min($dep['dep_id'],$fecha_ini,$fecha_fin);

				$cadena.="<tr>";
				$cadena.="<td>".$dep['dep_nombre']."</td>";

					if(count($listado_cdr)>0){
						$cadena.="<td  style='padding: 0px;'>
						<table class='table_sub'>";

						//Nombre
						foreach($listado_cdr as $lst) { 
							$cadena.='<tr>';
							$cadena.='<td>'.$lst['ppa_nombre'].'</td>';
							$cadena.='</tr>';
						}
						$cadena.='</table></td>';

						//Minutos
						$cadena.="<td style='padding: 0px;'>
						<table class='table_sub'>";

						foreach($listado_cdr as $lst) { 
							$cadena.='<tr>';
							$cadena.='<td>'.$lst['minutos'].'</td>';
							$cadena.='</tr>';
						}
						$cadena.='</table></td>';

						//Total
						$cadena.="<td style='padding: 0px;'>
						<table class='table_sub'>";

						foreach($listado_cdr as $lst) { 
							$cadena.='<tr>';
							$cadena.='<td>'.number_format($lst['total'],2).'</td>';
							$cadena.='</tr>';
						}
						$cadena.='</table></td>';
					}
					else{ 
						$cadena.="<td>--</td>";
						$cadena.="<td>0.00</td>";
						$cadena.="<td>$0.00</td>";
					}
				}
		}

		if ($cadena!=''){
			$arreglo=array('drop'=>$cadena);
		}
		else {
			$arreglo=array('drop'=>"<tr><td colspan='4'>No existen datos</td></tr>");		
		}

		if($return!=null){
			return $arreglo;
		}
		else{
			echo json_encode($arreglo);
		}
    }

    public function reporte_consolidado_min($tipo=null){
    	if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		}

		$depto= ($this->input->post('depto')!='') ? $this->input->post('depto') : 0;

		$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

		$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

		if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

		$cadena="";

    	$rows=$this->load->view('reporte/header', array('titulo' => "Consolidado de productos"), true);
    	//<meta http-equiv="content-type" content="text/html; charset=utf-8">
    	if($tipo==2){ $cadena.='<table></table>'; }
    	$cadena='<table class="tabla" style="border:1px solid black;">';
    	$cadena.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Departamento</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Destino</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Minutos</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Monto Total ($)</th>';
    	$cadena.='</tr>';

    	if($depto>0){
			$departamento = $this->gsatelite->get_tabla('dep_departamento',array('dep_id'=>$depto));

			$listado_cdr = $this->tarificador_model->get_consolidado_min($depto,$fecha_ini,$fecha_fin);

			$cadena.="<tr style='border:1px solid black;'>";
			$cadena.="<td>".$departamento[0]['dep_nombre']."</td>";

			if(count($listado_cdr)>0){
				$cadena.="<td  style='padding: 0px;'>
				<table class='tabla'>";

				//Nombre
				foreach($listado_cdr as $lst) { 
					$cadena.='<tr style="border:1px solid black;">';
					$cadena.='<td style="">'.$lst['ppa_nombre'].'</td>';
					$cadena.='</tr>';
				}
				$cadena.='</table></td>';

				//Minutos
				$cadena.="<td style='padding: 0px;'>
				<table class='tabla'>";

				//Nombre
				foreach($listado_cdr as $lst) { 
					$cadena.='<tr style="border:1px solid black;">';
					$cadena.='<td style="">'.$lst['minutos'].'</td>';
					$cadena.='</tr>';
				}
				$cadena.='</table></td>';

				//Total
				$cadena.="<td style='padding: 0px;'>
				<table class='tabla'>";

				//Nombre
				foreach($listado_cdr as $lst) { 
					$cadena.='<tr style="border:1px solid black;">';
					$cadena.='<td style="">'.number_format($lst['total'],2).'</td>';
					$cadena.='</tr>';
				}
				$cadena.='</table></td>';
			}
			else{ 
				$cadena.="<td>--</td>";
				$cadena.="<td>0.00</td>";
				$cadena.="<td>$0.00</td>";
			}
			$cadena.='</tr>';
		}
		else{
			$departamento = $this->gsatelite->get_tabla('dep_departamento');

			foreach($departamento as $dep){
				$listado_cdr = $this->tarificador_model->get_consolidado_min($dep['dep_id'],$fecha_ini,$fecha_fin);

				$cadena.="<tr style='padding: 0px;border:1px solid black;'>";
				$cadena.="<td>".$dep['dep_nombre']."</td>";

					if(count($listado_cdr)>0){
						$cadena.="<td  style='padding: 0px;'>
						<table class='' style=''>";

						//Nombre
						foreach($listado_cdr as $lst) { 
							$cadena.='<tr style="padding: 0px;">';
							$cadena.='<td style="">'.$lst['ppa_nombre'].'</td>';
							$cadena.='</tr>';
						}
						$cadena.='</table></td>';

						//Minutos
						$cadena.="<td style='padding: 0px;'>
						<table class='' style=''>";

						foreach($listado_cdr as $lst) {
							$cadena.='<tr style="padding: 0px;">';
							$cadena.='<td style="">'.$lst['minutos'].'</td>';
							$cadena.='</tr>';
						}
						$cadena.='</table></td>';

						//Total
						$cadena.="<td style='padding: 0px;'>
						<table class='' style=''>";

						foreach($listado_cdr as $lst) {
							$cadena.='<tr style="padding: 0px;">';
							$cadena.='<td style="">'.number_format($lst['total'],2).'</td>';
							$cadena.='</tr>';
						}
						$cadena.='</table></td>';
					}
					else{ 
						$cadena.="<td>--</td>";
						$cadena.="<td>0.00</td>";
						$cadena.="<td>$0.00</td>";
					}

				$cadena.='</tr>';
				}
		}

    	$cadena.='</table>';

    	$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

    	if($tipo==1){
    		$data['table_header']     = $rows;
    		$data['table_tbody']      = $cadena;
    		
    		$this->pdf->reportePDF('tarificador/reportes/reporte_pdf.php', $data,null,'L');
    	}
    	else if($tipo==2){
    		$data['table_header']     = "REPORTES DE CONSOLIDADO DE PRODUCTOS";
    		$data['table_tbody']      = $cadena;
    		$data['filename']         = $filename;
    		$this->load->view('tarificador/reportes/reporte_excel.php', $data);
    	}
    }


    function consolidado_pro(){
    	if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		} else {

			$consolidado_pro = $this->tarificador_model->get_consolidado_prod();

			$data['consolidado_pro'] = $consolidado_pro;
			//die(var_dump($consolidado_pro));
			$data['servicios'] = $this->gsatelite->get_dropdown('src_servicio', '{src_nombre}','', array('src_estado'=>1), null, '', 'src_id', true);

			$data['departamentos'] = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}','', null, null, '', 'dep_id', true);

			$data["titulo_personal"] ="Consolidado de Productos";

			$this->_cargarvista($data);
		}
    }

    public function consultar_consolidado_pro($return=null){

		$servicio= ($this->input->post('servicio')!='') ? $this->input->post('servicio') : 0;

		$departamento= ($this->input->post('depto')!='') ? $this->input->post('depto') : 0;

		$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

		$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

		if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

		$consolidado_pro = $this->tarificador_model->get_consolidado_prod($servicio,$departamento,$fecha_ini,$fecha_fin);

		$cadena="";

		foreach ($consolidado_pro as $key => $con) {

			$cadena.="<tr>";
			$cadena.="<td>".$con['departamento']."</td>";
			$cadena.="<td>".$con['producto']."</td>";
			$cadena.="<td>".$con['cantidad_cliente']."</td>";
			$cadena.="<td>".number_format($con['monto_total'],2)."</td>";
			$cadena.='</tr>';
		}

		if ($cadena!=''){
			$arreglo=array('drop'=>$cadena);
		}
		else {
			$arreglo=array('drop'=>"<tr><td colspan='4'>No existen datos</td></tr>");		
		}

		if($return!=null){
			return $arreglo;
		}
		else{
			echo json_encode($arreglo);
		}
    }

    public function reporte_consolidado_pro($tipo=null){
    	if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		}

		$servicio= ($this->input->post('servicio')!='') ? $this->input->post('servicio') : 0;

		$departamento= ($this->input->post('depto')!='') ? $this->input->post('depto') : 0;

		$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

		$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

		if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

		$consolidado_pro = $this->tarificador_model->get_consolidado_prod($servicio,$departamento,$fecha_ini,$fecha_fin);

		$cadena="";


    	$rows=$this->load->view('reporte/header', array('titulo' => "Consolidado de productos"), true);
    	//<meta http-equiv="content-type" content="text/html; charset=utf-8">
    	if($tipo==2){ $cadena.='<table></table>'; }
    	$cadena='<table class="tabla" style="border:1px solid black;">';
    	$cadena.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Departamento</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Producto</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Cantidad de Clientes</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Monto Total ($)</th>';
    	$cadena.='</tr>';

    	foreach ($consolidado_pro as $key => $con) {
    		$cadena.="<tr style='border:1px solid black;'>";
    		$cadena.="<td>".$con['departamento']."</td>";
    		$cadena.="<td>".$con['producto']."</td>";
    		$cadena.="<td>".$con['cantidad_cliente']."</td>";
    		$cadena.="<td>$".number_format($con['monto_total'],2)."</td>";
    		$cadena.='</tr>';
    	}

    	$cadena.='</table>';

    	$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

    	if($tipo==1){
    		$data['table_header']     = $rows;
    		$data['table_tbody']      = $cadena;
    		
    		$this->pdf->reportePDF('tarificador/reportes/reporte_pdf.php', $data,null,'L');
    	}
    	else if($tipo==2){
    		$data['table_header']     = "REPORTES DE CONSOLIDADO DE PRODUCTOS";
    		$data['table_tbody']      = $cadena;
    		$data['filename']         = $filename;
    		$this->load->view('tarificador/reportes/reporte_excel.php', $data);
    	}
    }

    function consolidado_vend(){
    	if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		} else {

			$consolidado_ven = $this->tarificador_model->get_consolidado_vend();

			$data['consolidado_ven'] = $consolidado_ven;
			//die(var_dump($consolidado_ven));
			$data['servicios'] = $this->gsatelite->get_dropdown('src_servicio', '{src_nombre}','', array('src_estado'=>1), null, '', 'src_id', true);

			$data['vendedores'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_nombre} {ven_apellidos}','', array('ven_estado'=>1), null, '', 'ven_id', true);

			$data['departamentos'] = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}','', null, null, '', 'dep_id', true);

			$data["titulo_personal"] ="Consolidado de Vendedores";

			$this->_cargarvista($data);
		}
    }

    public function consultar_consolidado_vend($return=null){

    	$vendedor= ($this->input->post('vendedor')!='') ? $this->input->post('vendedor') : 0;

		$servicio= ($this->input->post('servicio')!='') ? $this->input->post('servicio') : 0;

		$departamento= ($this->input->post('depto')!='') ? $this->input->post('depto') : 0;

		$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

		$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

		if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

		$consolidado_ven = $this->tarificador_model->get_consolidado_vend($vendedor,$servicio,$departamento,$fecha_ini,$fecha_fin);

		$cadena="";

		foreach ($consolidado_ven as $key => $con){

			$cadena.="<tr>";
			$cadena.="<td>".$con['ven_nombre']."</td>";
			$cadena.="<td>".$con['departamento']."</td>";
			$cadena.="<td>".$con['producto']."</td>";
			$cadena.="<td>".$con['cantidad_clientes']."</td>";
			$cadena.="<td>$".number_format($con['monto_total'],2)."</td>";
			$cadena.='</tr>';
		}

		if ($cadena!=''){
			$arreglo=array('drop'=>$cadena);
		}
		else {
			$arreglo=array('drop'=>"<tr><td colspan='5'>No existen datos</td></tr>");		
		}

		if($return!=null){
			return $arreglo;
		}
		else{
			echo json_encode($arreglo);
		}
    }

    public function reporte_consolidado_vend($tipo=null){
    	if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		}

		$vendedor= ($this->input->post('vendedor')!='') ? $this->input->post('vendedor') : 0;

		$servicio= ($this->input->post('servicio')!='') ? $this->input->post('servicio') : 0;

		$departamento= ($this->input->post('depto')!='') ? $this->input->post('depto') : 0;

		$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

		$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

		if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

		$consolidado_ven = $this->tarificador_model->get_consolidado_vend($vendedor,$servicio,$departamento,$fecha_ini,$fecha_fin);


		$cadena="";


    	$rows=$this->load->view('reporte/header', array('titulo' => "Consolidado de vendedores"), true);
    	//<meta http-equiv="content-type" content="text/html; charset=utf-8">
    	if($tipo==2){ $cadena.='<table></table>'; }
    	$cadena='<table class="tabla" style="border:1px solid black;">';
    	$cadena.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Vendedor</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Departamento</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Producto</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Cantidad de Clientes</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Monto Total ($)</th>';
    	$cadena.='</tr>';

    	foreach ($consolidado_ven as $key => $con) {
    		$cadena.="<tr style='border:1px solid black;'>";
			$cadena.="<td >".$con['ven_nombre']."</td>";
			$cadena.="<td>".$con['departamento']."</td>";
			$cadena.="<td>".$con['producto']."</td>";
			$cadena.="<td>".$con['cantidad_clientes']."</td>";
			$cadena.="<td>$".number_format($con['monto_total'],2)."</td>";
			$cadena.='</tr>';
    	}

    	$cadena.='</table>';

    	$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

    	if($tipo==1){
    		$data['table_header']     = $rows;
    		$data['table_tbody']      = $cadena;
    		
    		$this->pdf->reportePDF('tarificador/reportes/reporte_pdf.php', $data,null,'L');
    	}
    	else if($tipo==2){
    		$data['table_header']     = "REPORTES DE CONSOLIDADO DE VENDEDORES";
    		$data['table_tbody']      = $cadena;
    		$data['filename']         = $filename;
    		$this->load->view('tarificador/reportes/reporte_excel.php', $data);
    	}
    }

    function consolidado_promo(){
    	if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		} else {

			$consolidado_promo = $this->tarificador_model->get_consolidado_promo();

			$data['consolidado_promo'] = $consolidado_promo;
			//die(var_dump($consolidado_promo));
			$data['promociones'] = $this->gsatelite->get_dropdown('pln_plan_promocion', '{pln_nombre}','', array('pln_estado'=>1), null, '', 'pln_id', true);

			$data['vendedores'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_nombre} {ven_apellidos}','', array('ven_estado'=>1), null, '', 'ven_id', true);

			$data['departamentos'] = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}','', null, null, '', 'dep_id', true);

			$data["titulo_personal"] ="Consolidado de Planes/Promociones";

			$this->_cargarvista($data);
		}
    }

    public function consultar_consolidado_promo($return=null){

    	$promo= ($this->input->post('promo')!='') ? $this->input->post('promo') : 0;

		$departamento= ($this->input->post('depto')!='') ? $this->input->post('depto') : 0;

		$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

		$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

		if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

		$consolidado_promo = $this->tarificador_model->get_consolidado_promo($departamento,$promo,$fecha_ini,$fecha_fin);

		$cadena="";

		foreach ($consolidado_promo as $key => $con){

			$cadena.="<tr>";
			$cadena.="<td>".$con['dep_nombre']."</td>";
			$cadena.="<td>".$con['plan']."</td>";
			$cadena.="<td>".$con['clientes']."</td>";
			$cadena.="<td>$".$con['monto_total']."</td>";
			$cadena.='</tr>';
		}

		if ($cadena!=''){
			$arreglo=array('drop'=>$cadena);
		}
		else {
			$arreglo=array('drop'=>"<tr><td colspan='4'>No existen datos</td></tr>");		
		}

		if($return!=null){
			return $arreglo;
		}
		else{
			echo json_encode($arreglo);
		}
    }

    public function reporte_consolidado_promo($tipo=null){
    	if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		}

		$promo= ($this->input->post('promo')!='') ? $this->input->post('promo') : 0;

		$departamento= ($this->input->post('depto')!='') ? $this->input->post('depto') : 0;

		$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

		$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

		if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

		$consolidado_promo = $this->tarificador_model->get_consolidado_promo($departamento,$promo,$fecha_ini,$fecha_fin);

		$cadena="";

    	$rows=$this->load->view('reporte/header', array('titulo' => "Consolidado de promociones"), true);
    	//<meta http-equiv="content-type" content="text/html; charset=utf-8">
    	if($tipo==2){ $cadena.='<table></table>'; }
    	$cadena='<table class="tabla" style="border:1px solid black;">';
    	$cadena.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Departamento</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Plan</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Clientes</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Monto Total ($)</th>';
    	$cadena.='</tr>';

    	foreach ($consolidado_promo as $key => $con) {
    		$cadena.="<tr style='border:1px solid black;'>";
			$cadena.="<td>".$con['dep_nombre']."</td>";
			$cadena.="<td>".$con['plan']."</td>";
			$cadena.="<td>".$con['clientes']."</td>";
			$cadena.="<td>$".number_format($con['monto_total'],2)."</td>";
			$cadena.='</tr>';
    	}

    	$cadena.='</table>';

    	$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

    	if($tipo==1){
    		$data['table_header']     = $rows;
    		$data['table_tbody']      = $cadena;
    		
    		$this->pdf->reportePDF('tarificador/reportes/reporte_pdf.php', $data,null,'L');
    	}
    	else if($tipo==2){
    		$data['table_header']     = "REPORTES DE CONSOLIDADO DE PROMOCIONES";
    		$data['table_tbody']      = $cadena;
    		$data['filename']         = $filename;
    		$this->load->view('tarificador/reportes/reporte_excel.php', $data);
    	}
    }

  
    function plan_pagos(){
    	if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		} else {

			$data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', null, null, '', 'cli_id', true);

			$data["titulo_personal"] ="Reporte Consulta Plan de Pagos";

			$this->_cargarvista($data);
		}
    }

    public function consultar_plan_pagos($return=null){

		$plan= ($this->input->post('plan')!='') ? $this->input->post('plan') : 0;

		// $fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

		// $fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

		// if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

		$facxplan = $this->tarificador_model->get_facturas_plan_pago(array('plg_id'=>$plan));

		$this->db->order_by('cpl_numero ASC');
		$cuotas_plan = $this->tarificador_model->get_cuotas_plan_pago(array('plg_id'=>$plan));

		$cadena_fac="";
		$cadena_cuo="";

		$total_facturas = array_sum(array_column($facxplan,'fac_total'));
		foreach ($facxplan as $key => $fac) {

			$periodo = date('d-m-Y',strtotime($fac['fxs_fecha_inicio'])).' - '.date('d-m-Y',strtotime($fac['fxs_fecha_fin']));
			if ($fac['fac_estado']==1) { $estado = 'Pendiente'; } else if($fac['fac_estado']==2) { $estado = 'Pagada'; } else if($fac['fac_estado']==0) { $estado = 'Anulada'; }

			$cadena_fac.="<tr>";
			$cadena_fac.="<td>".$fac['src_nombre']."</td>";
			$cadena_fac.="<td>".$fac['fac_numero']."</td>";
			$cadena_fac.="<td>".$periodo."</td>";
			$cadena_fac.="<td>$".$fac['fac_total']."</td>";
			$cadena_fac.="<td>".$estado."</td>";
			$cadena_fac.='</tr>';
		}
		$cadena_fac.="<tr>";
		$cadena_fac.= "<td colspan='3' style='font-weight:bold;'>Total</td>";
		$cadena_fac.= "<td colspan='2'>$".number_format($total_facturas,2)."</td>";
		$cadena_fac.='</tr>';

		$total_cuotas = array_sum(array_column($cuotas_plan,'cpl_total'));
		foreach ($cuotas_plan as $key => $cuo) {

			$fecha_ven = date('d-m-Y',strtotime($cuo['cpl_fecha_vencimiento']));
			if ($cuo['cpl_estado']==1) { $estado = 'Pendiente'; } else if($cuo['cpl_estado']==2) { $estado = 'Cancelada'; } else if($cuo['cpl_estado']==0) { $estado = 'Anulado'; }
			if($cuo['paf_fecha_pag']!= null){ $fecha_pago=date('d-m-Y', strtotime($cuo['paf_fecha_pag'])); }else{ $fecha_pago=''; }

			$cadena_cuo.="<tr>";
			$cadena_cuo.="<td>".$cuo['cpl_numero']."</td>";
			$cadena_cuo.="<td>".$cuo['paf_numero']."</td>";
			$cadena_cuo.="<td>".$fecha_ven."</td>";
			$cadena_cuo.="<td>".$fecha_pago."</td>";
			$cadena_cuo.="<td>$".number_format($cuo['cpl_monto'],2)."</td>";
			$cadena_cuo.="<td>$".number_format($cuo['cpl_interes'],2)."</td>";
			$cadena_cuo.="<td>$".number_format($cuo['cpl_total'],2)."</td>";
			$cadena_cuo.="<td>".$estado."</td>";
			// $cadena_cuo.="<td>".''."</td>";
			$cadena_cuo.='</tr>';
		}

		$cadena_cuo.="<tr>";
		$cadena_cuo.= "<td colspan='6' style='font-weight:bold;'>Total</td>";
		$cadena_cuo.= "<td colspan='2'>$".number_format($total_cuotas,2)."</td>";
		$cadena_cuo.='</tr>';

		if ($cadena_fac!='' && $cadena_cuo!=''){
			$arreglo=array('facturas'=>$cadena_fac,'cuotas'=>$cadena_cuo);
		}
		else {
			$arreglo=array('drop'=>"<tr><td colspan='8'>No existen datos</td></tr>");		
		}

		if($return!=null){
			return $arreglo;
		}
		else{
			echo json_encode($arreglo);
		}
    }

    public function reporte_plan_pagos($tipo=null){
    	if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		}

		$plan= ($this->input->post('plan')!='') ? $this->input->post('plan') : 0;

		$facxplan = $this->tarificador_model->get_facturas_plan_pago(array('plg_id'=>$plan));

		$cuotas_plan = $this->tarificador_model->get_cuotas_plan_pago(array('plg_id'=>$plan));

		$cadena_fac="";
		$cadena_cuo="";

    	$rows=$this->load->view('reporte/header', array('titulo' => "Plan de Pagos"), true);
    	//<meta http-equiv="content-type" content="text/html; charset=utf-8">
    	if($tipo==2){ $cadena_fac.='<table></table>'; }

    	$header_pagos = '';
    	
    	//Facturas
    	$cadena_fac='<table class="tabla" style="border:1px solid black;">';
    	$cadena_fac.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
    	$cadena_fac.='<th style="text-align:center; font-weight:bold;">Producto</th>';
    	$cadena_fac.='<th style="text-align:center; font-weight:bold;">Factura</th>';
    	$cadena_fac.='<th style="text-align:center; font-weight:bold;">Periodo</th>';
    	$cadena_fac.='<th style="text-align:center; font-weight:bold;">Total</th>';
    	$cadena_fac.='<th style="text-align:center; font-weight:bold;">Estado</th>';
    	$cadena_fac.='</tr>';


    	$total_facturas = array_sum(array_column($facxplan,'fac_total'));
    	foreach ($facxplan as $key => $fac) {

			$periodo = date('d-m-Y',strtotime($fac['fxs_fecha_inicio'])).' - '.date('d-m-Y',strtotime($fac['fxs_fecha_fin']));
			if ($fac['fac_estado']==1) { $estado = 'Pendiente'; } else if($fac['fac_estado']==2) { $estado = 'Pagada'; } else if($fac['fac_estado']==0) { $estado = 'Anulada'; }

			$cadena_fac.="<tr style='border:1px solid black;'>";
			$cadena_fac.="<td>".$fac['src_nombre']."</td>";
			$cadena_fac.="<td>".$fac['fac_numero']."</td>";
			$cadena_fac.="<td>".$periodo."</td>";
			$cadena_fac.="<td>$".$fac['fac_total']."</td>";
			$cadena_fac.="<td>".$estado."</td>";
			$cadena_fac.='</tr>';
		}
		$cadena_fac.="<tr>";
		$cadena_fac.= '<td colspan="3" style="font-weight:bold;text-align:left;">Total</td>';
		$cadena_fac.= '<td colspan="2" style="text-align:left;">$'.number_format($total_facturas,2).'</td>';
		$cadena_fac.='</tr>';

    	$cadena_fac.='</table>';

    	//Cuotas
    	$cadena_cuo='<table class="tabla" style="border:1px solid black;">';
    	$cadena_cuo.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
    	$cadena_cuo.='<th style="text-align:center; font-weight:bold;">No.</th>';
    	$cadena_cuo.='<th style="text-align:center; font-weight:bold;">Correlativo</th>';
    	$cadena_cuo.='<th style="text-align:center; font-weight:bold;">Vencimiento</th>';
    	$cadena_cuo.='<th style="text-align:center; font-weight:bold;">Fecha de pago</th>';
    	$cadena_cuo.='<th style="text-align:center; font-weight:bold;">Monto</th>';
    	$cadena_cuo.='<th style="text-align:center; font-weight:bold;">Interés</th>';
    	$cadena_cuo.='<th style="text-align:center; font-weight:bold;">Total</th>';
    	$cadena_cuo.='<th style="text-align:center; font-weight:bold;">Estado</th>';
    	// $cadena_cuo.='<th style="text-align:center; font-weight:bold;">Fecha de Pago</th>';
    	$cadena_cuo.='</tr>';
    	
    	$total_cuotas = array_sum(array_column($cuotas_plan,'cpl_total'));
    	foreach ($cuotas_plan as $key => $cuo) {

			$fecha_ven = date('d-m-Y',strtotime($cuo['cpl_fecha_vencimiento']));
			if ($cuo['cpl_estado']==1) { $estado = 'Pendiente'; } else if($cuo['cpl_estado']==2) { $estado = 'Cancelada'; } else if($cuo['cpl_estado']==0) { $estado = 'Anulado'; }
			if($cuo['paf_fecha_pag']!= null){ $fecha_pago=date('d-m-Y', strtotime($cuo['paf_fecha_pag'])); }else{ $fecha_pago=''; }

			$cadena_cuo.="<tr style='border:1px solid black;'>";
			$cadena_cuo.="<td>".$cuo['cpl_numero']."</td>";
			$cadena_cuo.="<td>".$cuo['paf_numero']."</td>";
			$cadena_cuo.="<td>".$fecha_ven."</td>";
			$cadena_cuo.="<td>".$fecha_pago."</td>";
			$cadena_cuo.="<td>$".number_format($cuo['cpl_monto'],2)."</td>";
			$cadena_cuo.="<td>$".number_format($cuo['cpl_interes'],2)."</td>";
			$cadena_cuo.="<td>$".number_format($cuo['cpl_total'],2)."</td>";
			$cadena_cuo.="<td>".$estado."</td>";
			// $cadena_cuo.="<td>".''."</td>";
			$cadena_cuo.='</tr>';
		}

		$cadena_cuo.="<tr>";
		$cadena_cuo.= '<td colspan="6" style="font-weight:bold;text-align:left;">Total</td>';
		$cadena_cuo.= '<td colspan="2" style="text-align:left;">$'.number_format($total_cuotas,2).'</td>';
		$cadena_cuo.='</tr>';

		$cadena_cuo.='</table>';

		$cadena=$cadena_fac.'<br><br>'.$cadena_cuo;
		//die(print_r($cadena_cuo));
    	
    	$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

    	if($tipo==1){
    		$data['table_header']     = $rows;
    		$data['table_tbody_fac']      = $cadena_fac;
    		$data['table_tbody_cuo']      = $cadena_cuo;
    		
    		$this->pdf->reportePDF('tarificador/reportes/reporte_plan_pagos.php', $data);
    	}
    	else if($tipo==2){
    		$data['table_header']     = "REPORTE DE PLANES DE PAGO";
    		$data['table_tbody']      = $cadena;
    		$data['filename']         = $filename;
    		$this->load->view('tarificador/reportes/reporte_excel.php', $data);
    	}
    }

  
    
    function imprimir_comprobante_pago()
    { 
        satelite_validar();
        if($_GET['fac_id']==NULL && $_GET['cpl_id']=NULL) { redirect('/auth/login/'); }
        $data['cabezera']	=  explode('/', $this->gsatelite->get_parametro('SYS_CABEZERA_RECIBO_PAGO'));
        
        $data['datos_recibo']	=	$this->tarificador_model->comprobante_pago($_GET['fac_id'], $_GET['cpl_id']);
        $GLOBALS['nombre_reporte'] = 'Factura_'.$data['datos_recibo']->fac_numero.'_'.date('Y-m-d_H-m-s');
    	$this->pdf->setPrintFooter(false);

    	$this->pdf->reportePDF("tarificador/impresiones/comprobante_pago", $data);
    }

    //Impresiones
    function imprimir_factura_general($fac_id=null, $fecha_inicio=null, $fecha_fin=null, $cli_id=null){
    	if (!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		}
		if($fac_id==null) { redirect('/auth/login/'); }
    	$rows = $this->load->view('reporte/header', array('titulo' => "Listado de CDR"), true);
    	$data['table_header']     = $rows;
    	$nombre_factura_servicios = $this->gsatelite->get_parametro('FACTURA_SERVICIOS');
    	$cli_id = $this->gsatelite->get_campo('fac_factura','fac_id_cli',array('fac_id'=>$fac_id));
    	
    	// Si solo biene el ID ir a la base a traerse el sxc y la fecha inicio y fecha fin de la tabla fxs_facturaxservicio
    	if(empty($sxc)){
    		$factura_detalle = $this->gsatelite->get_registro('fxs_facturaxservicio', array('fxs_id_fac'=>$fac_id));
    		$sxc = $factura_detalle->fxs_id_sxc;
    		$fecha_inicio = $factura_detalle->fxs_fecha_inicio;
    		$fecha_fin 	=	$factura_detalle->fxs_fecha_fin;
    	}
    	
    	$fecha_ini=date('Y-m-d', strtotime($fecha_inicio));
    	$fec_fin=date('Y-m-d', strtotime($fecha_fin));
    
    	$data['fecha_ini']=$fecha_ini;
    	$data['fecha_fin']=$fecha_fin;
    	$data['cliente'] = $this->gsatelite->get_tabla('cli_cliente',array('cli_id'=>$cli_id));
    	$data['cliente_fac'] = $this->tarificador_model->get_info_cliente_factura(array('fac_id'=>$fac_id));

    	$data['telefono_principal'] = $this->gsatelite->get_campo('txs_telefonoxservicio','txs_numero',array('txs_id_sxc'=>$data['cliente_fac'][0]['sxc_id'],'txs_principal'=>1));

    	$data['facturas_pendientes'] = $this->tarificador_model->get_facturas_pendientes($fac_id,$cli_id);

    	$data['total_pagos'] = $this->gsatelite->get_suma('paf_pago_factura','paf_total',array('paf_id_fac'=>$fac_id));

    	$data['cargos_mensuales'] = $this->tarificador_model->get_cargos_factura($fac_id,1,$fecha_ini,$fec_fin);
        
    	$data['cargos_adicionales'] = $this->tarificador_model->get_cargos_factura($fac_id,2,$fecha_ini,$fec_fin);
    	$data['minutos_consumidos'] = $this->tarificador_model->get_factura_min_consumidos($fac_id,1);
        
    	$data['minIncluidos']  =   $this->tarificador_model->get_minutosIncluidosEnFactura($fecha_ini, $fecha_fin, $cli_id, $fac_id);
        
        $where=array('sxc_id'=>$sxc, 'date_format(caf_fecha,"%Y-%m-%d") >='=>date('Y-m-d', strtotime($fecha_ini)),
				'date_format(caf_fecha,"%Y-%m-%d") <='=>date('Y-m-d', strtotime($fec_fin))
    		);
        $data['detalle_caf_fijos'] = $this->facturacion_model->get_fijos_caf($where,1,1);

    	$data['detalle_impuestos'] = $this->facturacion_model->detalle_impuestos_factura($fac_id,$fecha_ini,$fec_fin);

    	$data['detalle_llamadas'] = $this->tarificador_model->get_factura_min_consumidos($fac_id);
    	$data['empresa_nit'] = $this->gsatelite->get_parametro('SYS_NIT');

    	$GLOBALS['nombre_reporte'] = 'Factura_'.$data['cliente_fac'][0]['fac_numero'].'_'.date('Y-m-d_H-m-s');
    	$this->pdf->setPrintFooter(false);
    	$this->pdf->reportePDF("tarificador/impresiones/$nombre_factura_servicios", $data);
    }

	function _cargarvista($data=0,$crud=0){   
        $this->load->view('vacia',$crud);   
        if($data!=0)
            $data=array_merge($data,$this->masterpage->getUsuario());
        else
            $data=$this->masterpage->getUsuario();      
        $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content',$data);
        $this->masterpage->show();
    }
}
?>