<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Procesos extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('tarificador_model');
       
    }

    function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {            
            $data['titulo_personal']='Tarificador';
            $this->_cargarvista(null,$data);
        }
    }

   
    function planes($id_articulo=null, $serv=null)
    {
        satelite_validar();
        $crud= new grocery_CRUD();
        $crud->unset_add();   
        $crud->unset_edit();
        $columns= array(
                'pln_nombre',
                'pln_minuto',
                'pln_costo',
                'pln_desde',
                'pln_hasta',
                'pln_tipo'
            );
        $alias= array(
                //'pln_id_art'=>'Producto / Servicio',
                'pln_id_src'=>'Servicio',
                'pln_nombre'=>'Nombre',
                'pln_minuto'=>'Minutos incluidos',
                'pln_costo' =>'Costo',
                'pln_desde' =>'Desde',
                'pln_hasta' =>'Hasta',
                'pln_tipo'  =>'Tipo',
                'pln_estado'=>'Estado'
             );
        $fields= array(
                'pln_id_src',
                'pln_nombre',
                'pln_minuto',
                'pln_costo',
                'pln_desde',
                'pln_hasta',
                'pln_tipo',
                'pln_estado',
                'pln_fecha_crea',
                'pln_fecha_mod',
                'pln_usu_crea',
                'pln_usu_mod'
            );
        $required= array(
                'pln_nombre',
                'pln_minuto',
                'pln_costo',
                'pln_desde',
                'pln_hasta',
                'pln_tipo',
                'pln_estado',
                'pln_fecha_crea',
                'pln_fecha_mod',
                'pln_usu_crea',
                'pln_usu_mod'
            );
        $crud->set_table('pln_plan_promocion')
             ->set_subject('Plan/Promoción')
             ->columns($columns)
             ->display_as($alias)
             ->add_fields($fields)
             ->edit_fields($fields)
             ->required_fields($required)
             ->set_relation('pln_id_src','src_servicio','src_nombre', array('src_estado'=>1))
             ->set_rules('pln_minutos','Minutos incluidos','trim|required|is_numeric')
             ->set_rules('pln_nombre','Nombre','trim|required|callback_planes_nombre_unico')
             ->set_rules('pln_costo','Costo','trim|required|is_numeric')
             ->field_type('pln_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
             ->field_type('pln_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
             ->field_type('pln_usu_crea', 'hidden', $this->tank_auth->get_user_id())
             ->field_type('pln_usu_mod', 'hidden', $this->tank_auth->get_user_id())
             ->add_action('Editar', 'icomoon-icon-pencil-5', 'tarificador/procesos/editar_plan')
             ->add_action('Tarifas','icomoon-icon-bars','tarificador/procesos/tarifas','')
             ->field_type('pln_tipo','dropdown', array('1' => 'Plan', '2' => 'Promoción'))
             ->callback_before_insert(function($post_array,$primary_key){
                        //VERIFICAR SI LA FECHA DE PRESENTACION NO SEA MAYOR A LA ACTUAL
                        //$hoy = date('Y-m-d H:i:s');
                        $datetime1 = new DateTime(date("Y-m-d H:i:s", strtotime($post_array['pln_desde'])));//fecha desde
                        $datetime2 = new DateTime(date("Y-m-d H:i:s", strtotime($post_array['pln_hasta'])));//fecha hasta

                        if ($datetime1<=$datetime2) { return TRUE; }
                        else { return FALSE; }

                    })
            ->callback_before_update(function($post_array,$primary_key){
                        //VERIFICAR SI LA FECHA DE PRESENTACION NO SEA MAYOR A LA ACTUAL
                        //$hoy = date('Y-m-d H:i:s');
                        $datetime1 = new DateTime(date("Y-m-d H:i:s", strtotime($post_array['pln_desde'])));//fecha desde
                        $datetime2 = new DateTime(date("Y-m-d H:i:s", strtotime($post_array['pln_hasta'])));//fecha hasta

                        if ($datetime1<=$datetime2) { return TRUE; }
                        else { return FALSE; }

                    })
            ->set_lang_string('update_error','Verifique las fechas del período.')
            ->set_lang_string('insert_error','Verifique las fechas del período.')
             ;
        $crud->callback_column('pln_desde',array($this,'_column_to_date'));
        $crud->callback_column('pln_hasta',array($this,'_column_to_date'));

        if(end(explode('/',uri_string()))=='add') {
            $crud->field_type('pln_estado','hidden',1);
        }else {
            $crud->field_type('pln_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        if($id_articulo>0){
            $crud->where('pln_id_src',$id_articulo);
        }
        if($serv>0){
            $crud->where('pln_id_src',$serv);
        }

        $output = $crud->render();
        if($id_articulo > 0){

            $nombre=$this->gsatelite->get_campo('src_servicio','src_nombre',array('src_id'=>$id_articulo));
            $data['id_articulo']=$id_articulo;
            $data['titulo_personal']="Planes/Promociones - Servicio: ".$nombre;
        }else{
            $data['titulo_personal']="Planes/Promociones";
        }

        if($serv > 0){
               $select=$this->gsatelite->get_dropdown('src_servicio', '{src_nombre}','',array('src_estado'=>1), $serv, '', 'src_id', true);
               $data["servicios"] = str_replace('<option value="0" selected>Seleccione </option>', '',$select);
        }else{
                $select=$this->gsatelite->get_dropdown('src_servicio', '{src_nombre}','',array('src_estado'=>1), null, '', 'src_id', true);
                $data["servicios"] = str_replace('<option value="0" selected>Seleccione </option>', '',$select);
        }

        $this->_cargarvista($data,$output);
    }

    function _column_to_date($value,$row){
        return date('d-m-Y',strtotime($value));
    }

    function tarifas($id_plan=null, $estado=null)
    {
        satelite_validar();

        $serv=0;
        $plan=0;
        $est=null;
        $serv=$this->input->post('servicio');
        $plan=$this->input->post('plan');
        $est=$this->input->post('estado_filt');
        //print_r($serv.'/'.$plan.'/'.$est);

        $crud= new grocery_CRUD();
        if($estado != null && $estado >= 0){
            //die(print_r(">=0"));
            $crud->where('trf_estado',$estado);
        }else if($est != null && $est >= 0){
            //die(print_r(">=0"));
            $crud->where('trf_estado',$est);
        }

         if($id_plan != null && $id_plan >= 0){
            $crud->where('trf_id_pln',$id_plan);
        }else if($plan != null && $plan > 0 && $plan!=''){
            $crud->where('trf_id_pln',$plan);
        }
        $crud->unset_print();
        $crud->unset_export();
        $columns= array(
                'trf_nombre',
                'trf_id_ppa',
                'trf_costo',
                'trf_id_dia_desde',
                'trf_desde_horario',
                'trf_id_dia_hasta',
                'trf_hasta_horario',
                'trf_desde',
                'trf_hasta',
                'trf_desde_minuto',
                'trf_hasta_minuto',
                'trf_estado'
            );
        $alias= array(
                'trf_id_pln'=>'Plan/Promoción',
                'trf_nombre'=>'Nombre',
                'trf_id_ppa'=>'Destino',
                'trf_costo'=>'Costo',
                'trf_id_dia_desde'=>'Día desde',
                'trf_desde_horario'=>'Hora desde',
                'trf_id_dia_hasta'=>'Día hasta',
                'trf_hasta_horario'=>'Hora hasta',
                'trf_desde'=>'Fecha desde',
                'trf_hasta'=>'Fecha hasta',
                'trf_desde_minuto'=>'Minutos desde',
                'trf_hasta_minuto'=>'Minutos hasta',
                'trf_estado'=>'Estado'
             );
     

        $crud->set_table('trf_tarifa')
             ->set_subject('Tarifa')
             ->columns($columns)
             ->display_as($alias)
             ->set_relation('trf_id_ppa','ppa_parametro_pais','{ppa_nombre} || {ppa_desde_codigo}', array('ppa_estado'=>1))
             ->set_relation('trf_id_dia_desde','dia_dia','dia_nombre', array('dia_estado'=>1))
             ->set_relation('trf_id_dia_hasta','dia_dia','dia_nombre', array('dia_estado'=>1))
             ->unset_edit();
             if($id_plan==null){
                $crud->add_action('Editar','icomoon-icon-pencil-5','tarificador/procesos/editar_tarifa/0');
             }else if($id_plan > 0){
                $crud->add_action('Editar','icomoon-icon-pencil-5','tarificador/procesos/editar_tarifa/'.$id_plan,'plan');
             }

            $crud->callback_column('trf_estado',array($this,'_validar_tarifa'));
        if(end(explode('/',uri_string()))=='add') {
            $crud->field_type('trf_estado','hidden',1);
        }else {
            $crud->field_type('trf_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
           $crud->callback_column('trf_desde',array($this,'_cambiar_formato'));
           $crud->callback_column('trf_hasta',array($this,'_cambiar_formato'));

        $output = $crud->render();
        if($id_plan > 0){
            $data['nombre']=$this->tarificador_model->get_info($id_plan);
        }

            $data['titulo_personal']="Tarifas de planes y promociones";
            if($estado != null){
                $data['estado']=$estado;
            }

            if($est!=null){
                $data['est']=$est;
            }
            if($serv > 0){
               $select=$this->gsatelite->get_dropdown('src_servicio', '{src_nombre}','',array('src_estado'=>1), $serv, '', 'src_id', true);
               $data["servicios"] = str_replace('<option value="0" selected>Seleccione </option>', '',$select);
            }else{
                $select=$this->gsatelite->get_dropdown('src_servicio', '{src_nombre}','',array('src_estado'=>1), null, '', 'src_id', true);
                $data["servicios"] = str_replace('<option value="0" selected>Seleccione </option>', '',$select);
            }

            if($plan > 0){
                $planes=$this->gsatelite->get_dropdown('pln_plan_promocion', '{pln_nombre}','',array('pln_estado'=>1), $plan, '', 'pln_id', true);
                $data["planes"] = str_replace('<option value="0" selected>Seleccione</option>', '',$planes);
            }else{
                $planes=$this->gsatelite->get_dropdown('pln_plan_promocion', '{pln_nombre}','',array('pln_estado'=>1), null, '', 'pln_id', true);
                $data["planes"] = str_replace('<option value="0" selected>Seleccione</option>', '',$planes);
                
            }

        
        $this->_cargarvista($data,$output);
    }

    function importar_tarifas()
    {
        satelite_validar();
        if($_FILES) {
          setlocale(LC_CTYPE, "en.UTF16");
          $file = fopen($_FILES["excel_tarifas"]["tmp_name"],"r");
          $cabezera = fgetcsv($file);
          $excel_data = '';
          
          if( count($cabezera)==12 ){

            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');

            // Guardamos el archivo, para muestra del Usuario
            $carpeta_destino="uploads/archivos/erp_csv/archivo_tarifas.csv";
            @move_uploaded_file($_FILES["excel_tarifas"]["tmp_name"], $carpeta_destino);

            $tarifas_array = array();
            while ( ( $dataRow = fgetcsv($file, 1000, ',')) !== FALSE ){
                array_push($tarifas_array, array_map("utf8_encode", $dataRow));
            }
            
            $data['tarifas'] = $tarifas_array;
            $excel_data .='<center><h4>(<em>'. $_FILES["excel_tarifas"]["name"] .'</em>)</h4></center><br/><center><h3>';
            $excel_data .=   $this->load->view('tarificador/procesos/tabla_tarifas', $data, true);

          } else {
                $excel_data .='<center><h4>(<em>'. $_FILES["excel_tarifas"]["name"] .'</em>)</h4></center><br/><center><h3>';
                $excel_data .='La hoja actual no cumple con el formato de columnas</h3><br/>';
                $excel_data .='<h4>Favor revisar documento csv y cantidad de columas</h4></center><br/>';
          }
          fclose($file);
      
        $tabla_html =   $excel_data;
        echo json_encode(array('drop'=>$tabla_html));
   
        }
        else {
            $data['titulo_personal'] = "Cargar tarifas";
            $this->_cargarvista($data,null);
        }
       
    }

    function procesar_tarifas()
    {

        satelite_validar();
        if($_POST){
            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');
            
            $insertar_array = array();
            $planes_fields = array();
            $codigos_array = array();
            $planes_nombre    =   $this->input->post('plan');
            $codigos       =   $this->input->post('codigo');
            $planes_array = $this->tarificador_model->get_plan_promocion();
            $dias_desde    = $this->input->post('dia_desde');
            $dias_hasta    = $this->input->post('dia_hasta');
            $dias_array = array('1'=>'lunes', '2'=>'martes', '3'=>'miercoles', '4'=>'jueves', '5'=>'viernes', '6'=>'sabado', '7'=>'domingo');    
            $dias_desde_array = array();
            $dias_hasta_array = array();
            
            // Buscar los Ids de los Codigos
            $codigos_db = $this->db->select('ppa_id, ppa_desde_codigo')->get('ppa_parametro_pais')->result_array();
            $codigos_db_id = array_column($codigos_db, 'ppa_id');
            $codigos_db_ppa   = array_column($codigos_db, 'ppa_desde_codigo');   
            
            foreach ($codigos as $key => $codigo){
                $indice = array_search(trim($codigo), $codigos_db_ppa);
                if( $indice !== FALSE ){
                    array_push ($codigos_array, $codigos_db_id[$indice]);
                } else {
                    array_push ($codigos_array, 'NO');
                }
            }
            
            // Buscar los codigos de los planes
            foreach ($planes_nombre as $nombre_buscar) {
                $indice = NULL;

                foreach ($planes_array as $plan) {
                    if( mb_strtolower(str_replace(' ','', trim($plan->pln_nombre)), 'UTF-8') ==  mb_strtolower(str_replace(' ', '', trim($nombre_buscar)), 'UTF-8') ){
                        $indice = $plan->pln_id;
                        break;    
                    }
                }
                
                if($indice != NULL){
                    array_push($planes_fields, $indice);
                } else {
                    array_push($planes_fields, 'NO');
                }
            }

            // Obtener el indice del dia_desde
            foreach ($dias_desde as $value) {
                array_push($dias_desde_array,  (array_search( mb_strtolower(str_replace(' ', '', $value), 'UTF-8'), $dias_array)) );
            }

            // Obtener el indice del dia_hasta
            foreach ($dias_hasta as $value) {
                array_push($dias_hasta_array,  (array_search( mb_strtolower(str_replace(' ', '', $value), 'UTF-8'), $dias_array)) );
            }
        
            $nombre         =   $this->input->post('nombre');
            $costo          =   $this->input->post('costo');
            $fecha_efectiva =   $this->input->post('fecha_efectiva');
            $fecha_terminacion =   $this->input->post('fecha_terminacion');
            $minutos_desde     =   $this->input->post('minutos_desde');
            $minutos_hasta     =   $this->input->post('minutos_hasta');
            $hora_desde     =   $this->input->post('hora_desde');
            $hora_hasta     =   $this->input->post('hora_hasta');
            
            foreach ($planes_fields as $key => $value) {
                if(!empty($value) && $value != 'NO' && isset($codigos_array[$key]) && $codigos_array[$key]!='NO'){
                    $temp_array = array(
                            'trf_id_pln'    =>  $value,
                            'trf_id_dia_desde'  => (!empty($dias_desde_array[$key]))? $dias_desde_array[$key]:null,
                            'trf_id_dia_hasta'  => (!empty($dias_hasta_array[$key]))? $dias_hasta_array[$key]:null,
                            'trf_id_ppa'        => (!empty($codigos_array[$key]))? $codigos_array[$key]:null,
                            'trf_nombre'        => (!empty($nombre[$key]))? $nombre[$key]:null,
                            'trf_costo'         => (!empty($costo[$key]))? $costo[$key]:null,
                            'trf_desde'         => (!empty($fecha_efectiva[$key]))? date('Y-m-d H:i:s', strtotime($fecha_efectiva[$key])): date('Y-m-d "H:i:s'),
                            'trf_hasta'         => (!empty($fecha_terminacion[$key]))? date('Y-m-d H:i:s', strtotime($fecha_terminacion[$key])): null,
                            'trf_desde_minuto'  => (!empty($minutos_desde[$key]))? $minutos_desde[$key]: null,
                            'trf_hasta_minuto'  => (!empty($minutos_hasta[$key]))? $minutos_hasta[$key]: null,
                            'trf_desde_horario' => (!empty($hora_desde[$key]))? date('H:i:s', strtotime($hora_desde[$key])):null,  
                            'trf_hasta_horario' => (!empty($hora_hasta[$key]))? date('H:i:s', strtotime($hora_hasta[$key])):null,
                            'trf_estado'        =>  1,
                            'trf_fecha_crea'    => date('Y-m-d H:i:s'),
                            'trf_fecha_mod'     => date('Y-m-d H:i:s'),
                            'trf_usu_crea'      => $this->tank_auth->get_user_id(),
                            'trf_usu_mod'       => $this->tank_auth->get_user_id()
                        );

                    array_push($insertar_array, $temp_array);
                }
            } // End foreach

        if(count($insertar_array)>0){
           @$this->db->insert_batch('trf_tarifa', $insertar_array);
           $this->gsatelite->show_dialog('Archivo guardado correctamente.','tarificador/procesos/importar_tarifas','success');
        } else {
            $this->gsatelite->show_dialog('No se pudo guardar el archivo.','tarificador/procesos/importar_tarifas','error');
        }
    
    } // End POST  
}

    function agregar_tarifa($plan=null)
    {
        satelite_validar();
        if($_POST){
            if($plan>0){
                $info_plan=$this->tarificador_model->get_info($plan);
                $plan=$info_plan->pln_id;

            }else{
                $plan=$this->input->post('planes');
            }

            
            $fecha_desde=date('Y-m-d', strtotime($this->input->post('fecha_desde')));
            $fecha_hasta= ($this->input->post('fecha_hasta')!='') ? date('Y-m-d', strtotime($this->input->post('fecha_hasta'))) : null;
            $hora_desde=date('H:i:s', strtotime($this->input->post('hora_desde')));
            $hora_hasta=date('H:i:s', strtotime($this->input->post('hora_hasta')));

            $cst=$this->input->post('costo');
            $costo=number_format($cst,2);

            $array_tar=array(
                'trf_id_pln'       =>$plan,
                'trf_id_dia_desde' =>($this->input->post('dia_desde')>0)?$this->input->post('dia_desde'):null,
                'trf_id_dia_hasta' =>($this->input->post('dia_hasta')>0)?$this->input->post('dia_hasta'):null,
                'trf_id_ppa'       =>($this->input->post('pais')>0)?$this->input->post('pais'):null,
                'trf_nombre'       =>$this->input->post('nombre'),
                'trf_costo'        =>$costo,
                'trf_desde'        =>$fecha_desde,
                'trf_hasta'        =>$fecha_hasta,
                'trf_desde_minuto' =>($this->input->post('minutos_desde')!='')?$this->input->post('minutos_desde'):null,
                'trf_hasta_minuto' =>($this->input->post('minutos_hasta')!='')?$this->input->post('minutos_hasta'):null,
                'trf_desde_horario'=>($this->input->post('hora_desde')!='')?$hora_desde:null,
                'trf_hasta_horario'=>($this->input->post('hora_hasta')!='')?$hora_hasta:null,
                'trf_estado'       =>1,
                'trf_fecha_crea'   =>date('Y-m-d H:i:s'),
                'trf_fecha_mod'    =>date('Y-m-d H:i:s'),
                'trf_usu_crea'     =>$this->tank_auth->get_user_id(),
                'trf_usu_mod'      =>$this->tank_auth->get_user_id()
                );
            $id_trf=$this->gsatelite->ingresar('trf_tarifa', $array_tar);
            
        if($id_trf>0){
            $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Tarifa Ingresada",'texto_alerta'=>"El registro se ingresó correctamente");
            $this->session->set_flashdata($alerta);
        }
        $plan_id=$this->input->post('plan');
        $boton=$this->input->post('boton');
        if ($boton =='2') {
            if(!empty($plan_id)){
                redirect('tarificador/procesos/tarifas/'.$plan_id);     
            }else{
                redirect('tarificador/procesos/tarifas');      
            }
        }
         if($boton == '1'){ 
            if(!empty($plan_id)){
                redirect('tarificador/procesos/agregar_tarifa/'.$plan_id);    
            }else{
                redirect('tarificador/procesos/agregar_tarifa');     
            }
        }

        }else{
            if($plan>0){
              $data['plan']=$this->tarificador_model->get_info($plan);  
            }
            
            $data['tarifas']=$this->gsatelite->get_tabla('trf_tarifa', array('trf_estado'=>1));
            //$data['pais']=$this->gsatelite->get_dropdown('ppa_parametro_pais', 'ppa_nombre','', array('ppa_estado'=>1), null, '','ppa_id', true);
            $data['dias']=$this->gsatelite->get_dropdown('dia_dia', 'dia_nombre','',array('dia_estado'=>1), null, '', 'dia_id', true);
            //'dia_id >='=>1, 'dia_id <='=>5
            $data['lst_planes']=$this->gsatelite->get_dropdown('pln_plan_promocion', 'pln_nombre','',array('pln_estado'=>1), null, '','pln_id', true);

            $data['titulo_personal']="Tarifas de planes y promociones";
            $this->_cargarvista($data);
        }
    }

    function editar_tarifa($id_pln=null,$id_tar=null)
    {
        satelite_validar();
        if($_POST){
           
            $id_tarifa=$this->input->post('id_trf');
            //die(print_r($id_tarifa));

            $fecha_desde=date('Y-m-d', strtotime($this->input->post('fecha_desde')));
            $fecha_hasta=($this->input->post('fecha_hasta')!='') ? date('Y-m-d', strtotime($this->input->post('fecha_hasta'))) : null;
            $hora_desde=date('H:i:s', strtotime($this->input->post('hora_desde')));
            $hora_hasta=date('H:i:s', strtotime($this->input->post('hora_hasta')));

            $cst=$this->input->post('costo');
            $costo=number_format($cst,2);

            $array_tar=array(
                'trf_id_pln'       =>$this->input->post('planes'),
                'trf_id_dia_desde' =>($this->input->post('dia_desde')>0)?$this->input->post('dia_desde'):null,
                'trf_id_dia_hasta' =>($this->input->post('dia_hasta')>0)?$this->input->post('dia_hasta'):null,
                'trf_id_ppa'       =>($this->input->post('pais')>0)?$this->input->post('pais'):null,
                'trf_nombre'       =>$this->input->post('nombre'),
                'trf_costo'        =>$costo,
                'trf_desde'        =>$fecha_desde,
                'trf_hasta'        =>$fecha_hasta,
                'trf_desde_minuto' =>($this->input->post('minutos_desde')!='')?$this->input->post('minutos_desde'):null,
                'trf_hasta_minuto' =>($this->input->post('minutos_hasta')!='')?$this->input->post('minutos_hasta'):null,
                'trf_desde_horario'=>($this->input->post('hora_desde')!='')?$hora_desde:null,
                'trf_hasta_horario'=>($this->input->post('hora_hasta')!='')?$hora_hasta:null,
                'trf_estado'       =>($this->input->post('estado')=='1') ? 1 : 0,
                'trf_fecha_crea'   =>date('Y-m-d H:i:s'),
                'trf_fecha_mod'    =>date('Y-m-d H:i:s'),
                'trf_usu_crea'     =>$this->tank_auth->get_user_id(),
                'trf_usu_mod'      =>$this->tank_auth->get_user_id()
                );
            
            $id_trf=$this->gsatelite->actualizar_array('trf_tarifa', $array_tar, array('trf_id'=>$id_tarifa));
            
        if($id_trf>0){
            $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Tarifa Actualizada",'texto_alerta'=>"El registro se actualizó correctamente");
            $this->session->set_flashdata($alerta);
        }
        $boton=$this->input->post('boton');
        $plan_id=$this->input->post('plan');
        if ($boton =='2') {
            if(!empty($plan_id)){
                redirect('tarificador/procesos/tarifas/'.$plan_id);     
            }else{
                redirect('tarificador/procesos/tarifas');      
            }     
        }else if($boton == '1'){ 
            redirect('tarificador/procesos/editar_tarifa/'.$id_pln.'/'.$id_tarifa);
        }

        }else{
           
            $tarifa=$this->gsatelite->get_tabla('trf_tarifa', array('trf_id'=>$id_tar));

            $data['tarifas']=$tarifa[0];
            //$data['pais']=$this->gsatelite->get_dropdown('ppa_parametro_pais', 'ppa_nombre','', array('ppa_estado'=>1), $tarifa[0]['trf_id_ppa'], '','ppa_id', true);
            $data['pais'] = $this->gsatelite->get_registro('ppa_parametro_pais', array('ppa_id'=>$tarifa[0]['trf_id_ppa']));
            $plan=$this->tarificador_model->get_info($tarifa[0]['trf_id_pln']);
           
            $data['plan']=$plan;
            //$data['id_plan']=$plan->pln_id;
            $data['id_plan']=$id_pln;
            $data['dia_desde']=$this->gsatelite->get_dropdown('dia_dia', 'dia_nombre','',array('dia_estado'=>1), $tarifa[0]['trf_id_dia_desde'], '', 'dia_id', true);
            $data['dia_hasta']=$this->gsatelite->get_dropdown('dia_dia', 'dia_nombre','',array('dia_estado'=>1), $tarifa[0]['trf_id_dia_hasta'], '', 'dia_id', true);
            $data['estado']=$this->gsatelite->get_campo('trf_tarifa', 'trf_estado', array('trf_id'=>$id_tar));
            if(!empty($plan)){     
                $id=$plan->src_id;
            }
            if(!empty($id)){
               $data['lst_planes']=$this->gsatelite->get_dropdown('pln_plan_promocion', 'pln_nombre','',array('pln_estado'=>1, 'pln_id_src'=>$id), $tarifa[0]['trf_id_pln'], '','pln_id', true); 
            }else{
                $data['lst_planes']=$this->gsatelite->get_dropdown('pln_plan_promocion', 'pln_nombre','',array('pln_estado'=>1), $tarifa[0]['trf_id_pln'], '','pln_id', true);
            }

            $data['titulo_personal']="Tarifas de planes y promociones";
            $this->_cargarvista($data);
        }
    }

    function get_pais(){
        $id_pai=$this->input->post('pais');
        $nombre_pai=$this->gsatelite->get_campo('pai_pais','pai_nombre',array('pai_id'=>$id_pai));
        echo json_encode($nombre_pai);
    }

      /**
  **/
   function planes_nombre_unico(){
        $nom_pln = trim($this->input->post('pln_nombre'));
       // $mod_carac = $this->input->post('car_modulo');

        if(end(explode('/',uri_string()))=='add') {
            $where = array('pln_plan_promocion.pln_nombre'=>$nom_pln);
            $query = $this->db->select('pln_plan_promocion.pln_id')
                          ->from('pln_plan_promocion');
            $this->db->where($where);
        }else{
            $id_pln = end(explode('/',uri_string()));
            $where = array('pln_plan_promocion.pln_nombre'=>$nom_pln);
            $query = $this->db->select('pln_plan_promocion.pln_id')
                          ->from('pln_plan_promocion');
            $this->db->where($where);
            $this->db->where_not_in('pln_plan_promocion.pln_id',$id_pln);
        }
        $result = $query->get()->result();
        //die(print($this->db->last_query()));
        if(count($result)>0){
            $this->form_validation->set_message('planes_nombre_unico','El campo Nombre debe ser único.');  
            return false;
        }
        else{
            return true;
        }
   }

   function producto_cliente($id_cliente=null)
   {
    satelite_validar();
    if($_POST){
            //die(print_r(var_dump($_POST),true));
            $id_cli=$this->input->post('id_cliente');
            if (isset($_POST['detalle_pro'])) {
                $cliente=$this->input->post('detalle_cli');
                $producto=$this->input->post('detalle_pro');
                $telefono=$this->input->post('telefonos');
                $fecha=$this->input->post('detalle_fec');
                $periodo=$this->input->post('detalle_con');
                $sxc_id=$this->input->post('id_sxc');
                $sxc_bd=$this->input->post('ids_sxc_bd');
            //---------------------------------
                $ids_sxc = explode(',', $sxc_bd);
                 //verificar cuantos datos hay en BD con el mismo id_axc
                $id_base= $this->db->select('sxc_id')->from('sxc_servicioxcliente')->where_in('sxc_id', $ids_sxc)->get()->result_array();
                //Se recorre el arreglo multidimencional $id_base para estructurarlo.
                    foreach ($id_base as $idb) {
                        $db[]=$idb['sxc_id'];
                    }
                $nuevo_arr=$db;
            //------------------------------------- 
                    foreach ($cliente as $dato => $val) {

                        $f_format=date('Y-m-d', strtotime($fecha[$dato]));
                        $array= array(
                                    'sxc_id_cli'=>$val,
                                    'sxc_id_src'=>$producto[$dato],
                                    'sxc_id_pcn'=>$periodo[$dato],
                                    'sxc_fecha_contrato'=>$f_format,
                                    'sxc_estado'=>1,
                                    'sxc_fecha_crea'=>date('Y-m-d H:i:s'),
                                    'sxc_fecha_mod'=>date('Y-m-d H:i:s'),
                                    'sxc_usu_crea'=>$this->tank_auth->get_user_id(),
                                    'sxc_usu_mod'=>$this->tank_auth->get_user_id()
                                    );
                        if(in_array($sxc_id[$dato],$nuevo_arr)) {
                            //Si existe, se debe actualizar.
                            $sxc_act=$this->gsatelite->actualizar_array('sxc_servicioxcliente', $array, array('sxc_id'=>$sxc_id[$dato]));
                
                        } else if($sxc_id[$dato] == 0 || !in_array($sxc_id[$dato],$nuevo_arr)) {
                            //Si no existe, se debe insertar. 
                          $sxc_ing = $this->gsatelite->ingresar('sxc_servicioxcliente',$array);                         
                        } 
                        if($sxc_id[$dato]>0){  $sxc=$sxc_id[$dato];
                        }else{  $sxc=$sxc_ing; }

                        $numeros=explode(',', $telefono[$dato]);
                        if(!empty($numeros)){
                            $this->gsatelite->borrado_general('txs_telefonoxservicio',array('txs_id_sxc'=>$sxc));
                        }

                        $i = 1;           
                        foreach ($numeros as $num) {
                            $principal = ($i==1) ? 1 : 0;
                            $array_tel=array(
                                    'txs_id_sxc'=>$sxc,
                                    'txs_numero'=> trim($num),
                                    'txs_principal'=>$principal,
                                    'txs_estado'=>1,
                                    'txs_usu_mod'=>$this->tank_auth->get_user_id(),
                                    'txs_fecha_mod'=>date('Y-m-d H:i:s'),
                                    'txs_fecha_crea'=>date('Y-m-d H:i:s'),
                                    'txs_usu_crea'=>$this->tank_auth->get_user_id()
                                );
                            $txs = $this->gsatelite->ingresar('txs_telefonoxservicio',$array_tel);
                            $i++;
                        }

                    }

                    for ($i=0; $i < count($nuevo_arr); $i++) { 
                      if($nuevo_arr[$i] >0 && !in_array($nuevo_arr[$i], $sxc_id)){
                                    $this->gsatelite->borrado_general('txs_telefonoxservicio',array('txs_id_sxc'=>$nuevo_arr[$i]));
                           $sxc_act=$this->gsatelite->borrado_general('sxc_servicioxcliente',array('sxc_id'=>$nuevo_arr[$i]));
                        }
                    }
            }
            if (isset($_POST['detalle_p'])) {
                $cliente=$this->input->post('detalle_c');
                $producto=$this->input->post('detalle_p');
                $telefono=$this->input->post('telefonos_t');
                $fecha=$this->input->post('detalle_f');
                $periodo=$this->input->post('detalle_o');
               // $nume=$this->input->post('numeros_n');
                    foreach ($cliente as $dato => $val) {
                //die(print_r($_POST));
                        $f_format=date('Y-m-d', strtotime($fecha[$dato]));
                        $array_sxc= array(
                                    'sxc_id_cli'=>$val,
                                    'sxc_id_src'=>$producto[$dato],
                                    'sxc_id_pcn'=>$periodo[$dato],
                                    'sxc_fecha_contrato'=>$f_format,
                                    'sxc_estado'=>1,
                                    'sxc_fecha_crea'=>date('Y-m-d H:i:s'),
                                    'sxc_fecha_mod'=>date('Y-m-d H:i:s'),
                                    'sxc_usu_crea'=>$this->tank_auth->get_user_id(),
                                    'sxc_usu_mod'=>$this->tank_auth->get_user_id()
                                    );
                    $sxc=$this->gsatelite->ingresar('sxc_servicioxcliente', $array_sxc);
                        
                        $numeros=explode(',', $telefono[$dato]);
                        $i = 1;
                        foreach ($numeros as $num) {
                            $principal = ($i==1) ? 1 : 0;
                            $array_telnew=array(
                                    'txs_id_sxc'=>$sxc,
                                    'txs_numero'=> trim($num),
                                    'txs_principal'=>$principal,
                                    'txs_estado'=>1,
                                    'txs_usu_mod'=>$this->tank_auth->get_user_id(),
                                    'txs_fecha_mod'=>date('Y-m-d H:i:s'),
                                    'txs_fecha_crea'=>date('Y-m-d H:i:s'),
                                    'txs_usu_crea'=>$this->tank_auth->get_user_id()
                                );
                            $txs = $this->gsatelite->ingresar('txs_telefonoxservicio',$array_telnew); 
                            $i++;
                        }
                    }
            }
            if($sxc>0 || $sxc_act>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Producto por cliente",'texto_alerta'=>"Registro(s) ingresado(s) con éxito");
            }else{
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Producto por cliente",'texto_alerta'=>"Ocurrió un error al ingresar la información");
            }
                    $this->session->set_flashdata($alerta);
                    $id_cliente=$this->input->post('id_cliente');
                    $boton=$this->input->post('boton');
            if ($boton =='2') {
                redirect('tarificador/procesos/clientes');
            }else if($boton == '1'){ 
                redirect('tarificador/procesos/producto_cliente/'.$id_cliente);
            }

    }else{
        if($id_cliente>0){
            $data['id_cliente']=$id_cliente;
                            //$tde_id=$this->gsatelite->get_parametro('SYS_TIPO_DOC');
                            //$this->db->join('dcc_documento_cliente', 'dcc_id_cli=cli_id AND dcc_id_tde='.$tde_id.'', 'left');
            $data['cliente']=$this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', array('cli_estado'=>1, 'cli_id'=>$id_cliente), $id_cliente, '','cli_id', true);
            $prod_cliente=$this->tarificador_model->get_productoxcliente($id_cliente);
            $data['prodxcliente']=$prod_cliente;
            $ids=array();
            $num=array();
            foreach ($prod_cliente as $key => $value) {
                $ids[]=$value['sxc_id'];
            }
            $datos=$ids;
           $data['datos']=$datos;
        }else{
                            //$tde_id=$this->gsatelite->get_parametro('SYS_TIPO_DOC');
                            //$this->db->join('dcc_documento_cliente', 'dcc_id_cli=cli_id AND dcc_id_tde='.$tde_id.'', 'left');
            $data['cliente']=$this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', array('cli_estado'=>1), null, '','cli_id', true);
        }

        /*$data['producto']=$this->gsatelite->get_dropdown('art_articulo', 'art_nombre','', array('art_estado'=>1), null, '','art_id', true);*/
        $data['producto']=$this->gsatelite->get_dropdown('src_servicio', 'src_nombre','', array('src_estado'=>1), null, '','src_id', true);
        $data['periodo']=$this->gsatelite->get_dropdown('pcn_periodo_contrato', '{pcn_nombre} ({pcn_duracion} meses)','', array('pcn_estado'=>1), null, '','pcn_id', true);
        $data['titulo_personal']="Producto por cliente";
        $this->_cargarvista($data);
    }
   }

       function clientes()
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->clientes('no','tarificador');
    }

        function anular_factura()
    {
        satelite_validar();
        $this->load->library('../controllers/facturacion/facturar');
        $info =  $this->facturar->anular_factura(true);
        $data['html'] = $this->load->view('facturacion/facturar/anular_factura', $info, true);
        $this->_cargarvista(null, $data);
    }

    function editar_cliente($id_cliente)
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $info=$this->mantenimientos->editar_cliente($id_cliente,null,true);
        $data['html']=$this->load->view('cotizaciones/mantenimientos/editar_cliente',$info, true);
        $this->_cargarvista(null,$data);
    }

    function nuevo_cliente()
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $info=$this->mantenimientos->nuevo_cliente(null,null,true);
        $data['html']=$this->load->view('cotizaciones/mantenimientos/nuevo_cliente',$info, true);
        $this->_cargarvista(null,$data);
    }
    function promo_cliente($id_sxc=null)
    {
        satelite_validar();

         if($_POST){
             //die(print_r($_POST,true));
            // Registros que fueron editados 
            if (isset($_POST['detalle_i'])) {
                $sxc=$this->input->post('id_sxc');
                $pxl_id=$this->input->post('id_pxl');
                $plan=$this->input->post('detalle_pln');
                $promocion=$this->input->post('detalle_prom');
                $fecha_ini=$this->input->post('detalle_i');
                $fecha_fn=$this->input->post('detalle_f');
                $telefono = $this->input->post('telefonos');
                
                //verificar cuantos datos hay en la BD para el id_sxc editado
                $id_base= $this->db->select('pxl_id')->from('pxl_plan_promoxcliente')->where('pxl_id_sxc',$sxc)->get()->result_array();
                $nuevo_arr = array_column($id_base, 'pxl_id');

                foreach ($fecha_ini as $data => $val) {
                    
                        $ini_format=date('Y-m-d', strtotime($fecha_ini[$data]));
                        $fin_format=date('Y-m-d', strtotime($fecha_fn[$data]));
                        
                        $array_pxl= array(
                            'pxl_id_pln'=>($plan[$data]>0)?$plan[$data]:$promocion[$data],
                            'pxl_id_sxc'=>$sxc,
                            'pxl_fecha_inicio'=>$ini_format,
                            'pxl_fecha_fin'=>$fin_format,
                            'pxl_estado'=>1,
                            'pxl_fecha_mod'=>date('Y-m-d H:i:s'),
                            'pxl_usu_mod'=>$this->tank_auth->get_user_id()
                        );
                        
                       if(in_array($pxl_id[$data],$nuevo_arr)) {
                            //Si existe, se debe actualizar.
                            $pxl_registro = $this->gsatelite->actualizar_array('pxl_plan_promoxcliente', $array_pxl, array('pxl_id'=>$pxl_id[$data]));
                        } else if($pxl_id[$data] == 0 || !in_array($pxl_id[$data],$nuevo_arr)) {
                            //Si no existe, se debe insertar. 
                            $array_pxl['pxl_fecha_crea']    = date('Y-m-d H:i:s');
                            $array_pxl['pxl_usu_crea']  =   $this->tank_auth->get_user_id();
                          $pxl_registro_nuevo = $this->gsatelite->ingresar('pxl_plan_promoxcliente',$array_pxl);                         
                        } 
                        if($pxl_id[$data]>0){  $pxl=$pxl_id[$data];
                        }else{  $pxl=$pxl_registro_nuevo; }
                        
                        $numeros= (!empty($telefono[$data]))? explode(',', $telefono[$data]): array();
                        
                            $this->gsatelite->borrado_general('txp_telefonoxplan',array('txp_id_pxl'=>$pxl));

                            foreach ($numeros as $num) {
                                $array_tel=array(
                                        'txp_id_pxl'=>$pxl,
                                        'txp_numero'=> trim($num),
                                        'txp_estado'=>1,
                                        'txp_usu_mod'=>$this->tank_auth->get_user_id(),
                                        'txp_fecha_mod'=>date('Y-m-d H:i:s'),
                                        'txp_fecha_crea'=>date('Y-m-d H:i:s'),
                                        'txp_usu_crea'=>$this->tank_auth->get_user_id()
                                    );
                                $txp = $this->gsatelite->ingresar('txp_telefonoxplan',$array_tel);
                            }
                      
                    } // End foreach
                    
                    for ($i=0; $i < count($nuevo_arr); $i++) { 
                      if($nuevo_arr[$i] >0 && !in_array($nuevo_arr[$i], $pxl_id)){
                            $this->gsatelite->borrado_general('txp_telefonoxplan',array('txp_id_pxl'=>$nuevo_arr[$i]));
                            $pxl_registro   =   $this->gsatelite->borrado_general('pxl_plan_promoxcliente',array('pxl_id'=>$nuevo_arr[$i]));
                        }
                    }
            }
            
            if (isset($_POST['detalle_fi'])) {
                $sxc=$this->input->post('id_sxc');
                $plan=$this->input->post('detalle_plan');
                $promocion=$this->input->post('detalle_promo');
                $fecha_inicio=$this->input->post('detalle_fi');
                $fecha_fin=$this->input->post('detalle_ff');
                $telefono   =   $this->input->post('telefonos_t');

                foreach ($fecha_inicio as $data => $val) {
                    $ini_format=date('Y-m-d', strtotime($fecha_inicio[$data]));
                    $fin_format=date('Y-m-d', strtotime($fecha_fin[$data]));
                    $array_pxl= array(
                        'pxl_id_pln'=>($plan[$data]>0)?$plan[$data]:$promocion[$data],
                        'pxl_id_sxc'=>$sxc,
                        'pxl_fecha_inicio'=>$ini_format,
                        'pxl_fecha_fin'=>$fin_format,
                        'pxl_estado'=>1,
                        'pxl_fecha_crea'=>date('Y-m-d H:i:s'),
                        'pxl_fecha_mod'=>date('Y-m-d H:i:s'),
                        'pxl_usu_crea'=>$this->tank_auth->get_user_id(),
                        'pxl_usu_mod'=>$this->tank_auth->get_user_id()
                        );
                $pxl=$this->gsatelite->ingresar('pxl_plan_promoxcliente', $array_pxl);

                $numeros= (!empty($telefono[$data]))? explode(',', $telefono[$data]): array();
                    if(count($numeros)>0){
                        foreach ($numeros as $num) {
                        $array_telnew=array(
                                'txp_id_pxl'=>$pxl,
                                'txp_numero'=> trim($num),
                                'txp_estado'=>1,
                                'txp_usu_mod'=>$this->tank_auth->get_user_id(),
                                'txp_fecha_mod'=>date('Y-m-d H:i:s'),
                                'txp_fecha_crea'=>date('Y-m-d H:i:s'),
                                'txp_usu_crea'=>$this->tank_auth->get_user_id()
                            );
                        $txp = $this->gsatelite->ingresar('txp_telefonoxplan',$array_telnew); 
                        }
                    }
                }
            }
            if($pxl>0 || $pxl_registro>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Plan/Promoción por cliente",'texto_alerta'=>"Registro(s) ingresado(s) con éxito");
            }else{
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Plan/Promoción por cliente",'texto_alerta'=>"Ocurrió un error al ingresar la información");
            }
                    $this->session->set_flashdata($alerta);
                    $id_sxc=$this->input->post('id_sxc');
                    $id_cliente=$this->input->post('id_cliente');
                    $boton=$this->input->post('boton');
            if ($boton =='2') {
                redirect('tarificador/procesos/producto_cliente/'.$id_cliente);
            }else if($boton == '1'){ 
                redirect('tarificador/procesos/promo_cliente/'.$id_sxc);
            }

    }else{
         if($id_sxc>0){
            $info=$this->tarificador_model->get_promoxcliente($id_sxc);
            $data['promoxcliente']=$info;
             // $data['producto']=$this->gsatelite->get_dropdown('art_articulo', 'art_nombre','', array('art_estado'=>1, 'art_id'=>$info[0]['pxc_id_art']), $info[0]['pxc_id_art'], '','art_id', true);
            $data['producto']=$this->gsatelite->get_dropdown('src_servicio', 'src_nombre','', array('src_estado'=>1, 'src_id'=>$info[0]['sxc_id_src']), $info[0]['sxc_id_src'], '','src_id', true);
             $data['cliente']=$this->gsatelite->get_dropdown('cli_cliente', 'cli_nombre','', array('cli_estado'=>1, 'cli_id'=>$info[0]['sxc_id_cli']), $info[0]['sxc_id_cli'], '','cli_id', true);
             $data['numero']=$info[0]['sxc_numero'];
             $data['id_sxc']=$info[0]['sxc_id'];
             $data['id_src']=$info[0]['sxc_id_src'];
             $data['id_cli']=$info[0]['sxc_id_cli'];
             $data['promo_cliente']=$this->tarificador_model->get_planes_cliente($id_sxc);

             $data['planes']=$this->gsatelite->get_dropdown('pln_plan_promocion', 'pln_nombre','', array('pln_estado'=>1, 'pln_tipo'=>1,'pln_id_src'=>$info[0]['sxc_id_src']), null, '','pln_id', true);
             $data['promociones']=$this->gsatelite->get_dropdown('pln_plan_promocion', 'pln_nombre','', array('pln_estado'=>1, 'pln_tipo'=>2,'pln_id_src'=>$info[0]['sxc_id_src']), null, '','pln_id', true);

         }else{
            $data['cliente']=$this->gsatelite->get_dropdown('cli_cliente', 'cli_nombre','', array('cli_estado'=>1), null, '','cli_id', true);
            // $data['producto']=$this->gsatelite->get_dropdown('art_articulo', 'art_nombre','', array('art_estado'=>1), null, '','art_id', true);
            $data['producto']=$this->gsatelite->get_dropdown('src_servicio', 'src_nombre','', array('src_estado'=>1), null, '','src_id', true);

            $data['planes']=$this->gsatelite->get_dropdown('pln_plan_promocion', 'pln_nombre','', array('pln_estado'=>1, 'pln_tipo'=>1), null, '','pln_id', true);
            $data['promociones']=$this->gsatelite->get_dropdown('pln_plan_promocion', 'pln_nombre','', array('pln_estado'=>1, 'pln_tipo'=>2), null, '','pln_id', true);
        }

        
        // $data['periodo']=$this->gsatelite->get_dropdown('pcn_periodo_contrato', 'pcn_nombre','', array('pcn_estado'=>1), null, '','pcn_id', true);
        $data['titulo_personal']="Asignación de Planes / Promociones por cliente";
        $this->_cargarvista($data);
    }

    }

    function verificar_detalle()
    {
        $id_pxc=$this->input->post('id_sxc');
        $datos=$this->tarificador_model->get_planes_cliente($id_pxc);
        if(count($datos)>0){
            $result=1;
        }else{
            $result=0;
        }
        echo json_encode($result);
    }
    
    /**
    *  @author Melbin Cruz
    */
    
   function carga_masiva_cdr()
   {
       //Aca el codigo para cargar de manera masiva los CDR
        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', '9999');
        
        $files = glob(FCPATH.'/temp/cdr_csv/*.csv'); //getcwd()

        foreach($files as $key => $filepath) {
          $cdr_detalle = array();
          if ($handle = fopen($filepath, "r")) {
              chmod($files[$key], 0777);
                $cabezera = fgetcsv($handle);
                
                $nombre_archivo = str_replace('.csv', '',  end(explode("/", $files[$key]))).'_'.date('d_m_Y_H_i_s').'.csv';
                
                $cdr_tmp_array = array(
                   'cdr_fecha_proceso'    => date('Y-m-d H:i:s'),
                   'cdr_archivo'            => $nombre_archivo,
                   'cdr_estado'             => 1,
                   'cdr_fecha_crea'         => date('Y-m-d H:i:s'),
                   'cdr_fecha_mod'          => date('Y-m-d H:i:s'),
                   'cdr_usu_crea'           => $this->tank_auth->get_user_id(),
                   'cdr_usu_mod'            => $this->tank_auth->get_user_id(),
                   'cdr_procesado'          => (count($cabezera)==21)? 1:0,
                );
                $id_cdr = $this->gsatelite->ingresar('cdr_resumen', $cdr_tmp_array);
                
                if(count($cabezera)==21){
                    while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                        $data['cdr_id'] = $id_cdr;
                        array_push($cdr_detalle, $data);
                    }
                }
            fclose($handle);
            // Enviar el array para procesamiento
            if(count($cdr_detalle)>0) {
                $proceso_exitoso = $this->procesar_cdr_masivo($cdr_detalle);
                if(empty($proceso_exitoso['motivo'])){
                    $carpeta_destino="uploads/archivos/cdr_procesados/$nombre_archivo";
                    rename($files[$key], $carpeta_destino);
                } else {
                    @$this->db->where('cdr_id', $id_cdr)->update('cdr_resumen', array('cdr_estado'=>1, 'cdr_procesado'=>0,'cdr_observacion'=>$proceso_exitoso['motivo']));
                    $carpeta_destino="uploads/archivos/cdr_no_procesados/$nombre_archivo";
                    rename($files[$key], $carpeta_destino);    
                }
                
            } else {
                @$this->db->where('cdr_id', $id_cdr)->update('cdr_resumen', array('cdr_estado'=>1, 'cdr_procesado'=>0,'cdr_observacion'=>'El archivo no cumple con el número de columnas requeridas'));
                $carpeta_destino="uploads/archivos/cdr_no_procesados/$nombre_archivo";
                rename($files[$key], $carpeta_destino);
            }
            
          }
        } // End foreach 
       
       redirect('/auth/login/');
   }
   
   /**
    *  @author Melbin Cruz
    */
    function procesar_cdr_masivo($cdr_detalle=NULL)
    {
        satelite_validar();
        
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        
        $cdd_actualizar = array();
        $tempCdd_array = array();
        $cdd_usuario = array();
        $cdd_dominio = array();
        $cdd_numero_origen = array();
        $cdd_numero_destino = array();
        $cdd_fecha_inicio = array();
        $cdd_fecha_fin = array();    
        $cdd_duracion = array();
        $cdd_duracion_min = array();
        $cdr_array = array();
        
        foreach ($cdr_detalle as $fila) {
            if(empty($fila[0]) || !is_numeric($fila[0]) ){
                $temp = array('motivo'=>'Al menos un registro tiene un valor Vacio o no Numérico en la columna User');
                return $temp;
            } else 
            if(empty($fila[2]) || !is_numeric($fila[2]) || !ctype_digit($fila[2])){
                $temp = array('motivo'=>'Al menos un registro tiene un valor Vacio o no Numérico en la columna Orig Number');
                return $temp;
            } else
            if(empty($fila[4]) || !is_numeric($fila[4]) || !ctype_digit($fila[4])){
                $temp = array('motivo'=>'Al menos un registro tiene un valor Vacio o no Numérico en la columna Term Number');
                return $temp;
            } else 
            if(empty($fila[9])){
                $temp = array('motivo'=>'Al menos un registro tiene una fecha con formato invalido en la columna Answer Time');
                return $temp;
            } else
            if(empty($fila[10])){
                $temp = array('motivo'=>'Al menos un registro tiene una fecha con formato invalido en la columna Hangup Time');
                return $temp;
            } else 
            if(empty($fila[12])){
                $temp = array('motivo'=>'Al menos un registro NO tiene duración de llamada en la columna Duration (s) ');
                return $temp;
            } else {
                array_push($cdd_usuario, $fila[0]);
                array_push($cdd_dominio, $fila[1]);
                array_push($cdd_numero_origen, $fila[2]);
                array_push($cdd_numero_destino, $fila[4]);
                array_push($cdd_fecha_inicio, $fila[9]);
                array_push($cdd_fecha_fin, $fila[10]);
                array_push($cdd_duracion, $fila[12]);
                array_push($cdd_duracion_min, number_format($fila[12]/60,2));
                array_push($cdr_array, $fila['cdr_id']);
            }
        }
        
        foreach ($cdd_usuario as $key => $value) {

            if(!empty($value)){
            $array_condicion = array(
                    'cdd_id_cdr'    =>  $cdr_array[$key],
                    'cdd_usuario'   =>  $value,
                    'cdd_dominio'   =>  $cdd_dominio[$key],
                    'cdd_numero_origen' =>  $cdd_numero_origen[$key],
                    'cdd_numero_destino'  =>    $cdd_numero_destino[$key],
                    'cdd_fecha_inicio'  =>  date('Y-m-d H:i:s', strtotime($cdd_fecha_inicio[$key])),
                    'cdd_fecha_fin'     =>  date('Y-m-d H:i:s', strtotime($cdd_fecha_fin[$key])),
                    'cdd_duracion'      =>  $cdd_duracion[$key],
                    'cdd_duracion_min'  =>  $cdd_duracion_min[$key],
                    'cdd_estado'        =>  1,
                    'cdd_costo_unit'    => '0.00',
                    'cdd_costo_total'   => '0.00',
                    'cdd_procesado'     => 0,
                    'cdd_fecha_crea'    =>  date('Y-m-d H:i:s'),
                    'cdd_fecha_mod'     =>  date('Y-m-d H:i:s'),
                    'cdd_usu_crea'       => $this->tank_auth->get_user_id(),
                    'cdd_usu_mod'        => $this->tank_auth->get_user_id()
                );
            
            // Verificar si esa llamada no se ha ingresado antes 
            $temp_array = array(
                    'cdd_numero_origen' => $cdd_numero_origen[$key],
                    'cdd_fecha_inicio'  => date('Y-m-d H:i:s', strtotime($cdd_fecha_inicio[$key]))
                );

            $duplicado = $this->tarificador_model->buscar_duplicados('cdd_cdr_detalle', $temp_array);

            if($duplicado == 0){

                $id_detalle = $this->gsatelite->ingresar('cdd_cdr_detalle', $array_condicion);
                // Obtener el prefijo de pais del numero destino
                $numero_destino = $cdd_numero_destino[$key];     // Term Number
                $filtro_uno = substr($numero_destino,0,1);   // Primer caracter
                $cadena_inicio = substr($numero_destino, 0, $this->tarificador_model->get_codigo_pais_length($filtro_uno) );
                
                $flagEncontrado = false;
                for ($i = strlen($cadena_inicio); $i > 0 ; $i--) { 
                    $cadena_busqueda  =  substr($cadena_inicio, 0, $i);
                    $contador = $this->tarificador_model->get_codigo_pais($cadena_busqueda);
                    if($contador==1){
                        $temp_array = array(
                                'cdd_id'        => $id_detalle,
                                'cdd_destino'   => $cadena_busqueda
                            );
                        array_push($cdd_actualizar, $temp_array);
                        $flagEncontrado = true;
                        break;
                    }
                } // End for
                
                // Si no hay codigo de pais en el Sistema, colocar ese codigo de error en la fila cdr_detalle
                if(!$flagEncontrado)
                    array_push($tempCdd_array, array('cdd_id'=>$id_detalle,'cdd_id_coe'=>4));
            }
        }   // End if
    } // End foreach
    
    if(count($tempCdd_array)>0)
       @$this->db->update_batch('cdd_cdr_detalle', $tempCdd_array, 'cdd_id');  

    if(count($cdd_actualizar)>0){
        @$this->db->update_batch('cdd_cdr_detalle', $cdd_actualizar, 'cdd_id');    
    }
  } // End procesar_cdr 

    /**
    *  @author Melbin Cruz
    */
    function cargar_cdr()
    {
      //  satelite_validar();
        if($_FILES) {
          ini_set( 'memory_limit', '2048M' );
          ini_set('max_execution_time', '9999');      
          
          $file = fopen($_FILES["excel_cdr"]["tmp_name"],"r");
          
          $cabezera = fgetcsv($file);
          $excel_data = '';
          $ruta='';
          if( count($cabezera)==21 ){
            
            // Guardamos el archivo, para muestra del Usuario
            $carpeta_destino="uploads/archivos/erp_csv/archivo_cdr.csv";
            @move_uploaded_file($_FILES["excel_cdr"]["tmp_name"], $carpeta_destino);
            $ruta = $_FILES["excel_cdr"]["tmp_name"];
            $cdr_filas = array();
            while(! feof($file)) 
            {
               array_push($cdr_filas, fgetcsv($file)); 
            }
            
            $data['cdr_filas'] = $cdr_filas;
            $excel_data .='<center><h4>(<em>'. $_FILES["excel_cdr"]["name"] .'</em>)</h4></center><br/><center><h3>';
            $excel_data .=   $this->load->view('tarificador/procesos/tabla_cdr', $data, true);

          } else {
              
                $excel_data .='<center><h4>(<em>'. $_FILES["excel_cdr"]["name"] .'</em>)</h4></center><br/><center><h3>';
                $excel_data .='La hoja actual no cumple con el formato de columnas</h3><br/>';
                $excel_data .='<h4>Favor revisar documento csv y cantidad de columnas</h4></center><br/>';
          }
          fclose($file);
        
        $tabla_html =   $excel_data;
        echo json_encode(array('drop'=>$tabla_html,'ruta'=>$ruta));
   
        }
        else {
            $data['titulo_personal'] = "Cargar CDR";
            $this->_cargarvista($data,null);
        }
    }
    

    /**
    *  @author Melbin Cruz
    */
    function procesar_cdr()
    {
        satelite_validar();
        
        if($_POST){
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');

        $cdr_resumen = array(
                'cdr_fecha_proceso'     => date('Y-m-d H:i:s'),
                'cdr_archivo'           => (!empty($_POST['cdr_nombre']))? $_POST['cdr_nombre']: date('Y-m-d-H:i:s'),
                'cdr_procesado'         => 1,
                'cdr_estado'            => 1,
                'cdr_fecha_crea'        => date('Y-m-d H:i:s'),
                'cdr_fecha_mod'        => date('Y-m-d H:i:s'),
                'cdr_usu_crea'          => $this->tank_auth->get_user_id(),
                'cdr_usu_mod'           => $this->tank_auth->get_user_id()
            );
        $id_cdr = $this->gsatelite->ingresar('cdr_resumen', $cdr_resumen);
        
        $cdd_actualizar = array();
        $tempCdd_array = array();
        // Ingresar el detalle del CDR anterior
        $cdd_usuario    =   $this->input->post('cdd_usuario');
        $cdd_dominio    =   $this->input->post('cdd_dominio');
        $cdd_numero_origen  =   $this->input->post('cdd_numero_origen');
        $cdd_numero_destino =   $this->input->post('cdd_numero_destino');
        $cdd_fecha_inicio   =   $this->input->post('cdd_fecha_inicio');
        $cdd_fecha_fin      =   $this->input->post('cdd_fecha_fin');
        $cdd_duracion       =   $this->input->post('cdd_duracion');
        $cdd_duracion_min   =   $this->input->post('cdd_duracion_min');

        foreach ($cdd_usuario as $key => $value) {

            if(!empty($value)){
            $array_condicion = array(
                    'cdd_id_cdr'    =>  $id_cdr,
                    'cdd_usuario'   =>  $value,
                    'cdd_dominio'   =>  $cdd_dominio[$key],
                    'cdd_numero_origen' =>  $cdd_numero_origen[$key],
                    'cdd_numero_destino'  =>    $cdd_numero_destino[$key],
                    'cdd_fecha_inicio'  =>  date('Y-m-d H:i:s', strtotime($cdd_fecha_inicio[$key])),
                    'cdd_fecha_fin'     =>  date('Y-m-d H:i:s', strtotime($cdd_fecha_fin[$key])),
                    'cdd_duracion'      =>  $cdd_duracion[$key],
                    'cdd_duracion_min'  =>  $cdd_duracion_min[$key],
                    'cdd_estado'        =>  1,
                    'cdd_costo_unit'    => '0.00',
                    'cdd_costo_total'   => '0.00',
                    'cdd_procesado'     => 0,
                    'cdd_fecha_crea'    =>  date('Y-m-d H:i:s'),
                    'cdd_fecha_mod'     =>  date('Y-m-d H:i:s'),
                    'cdd_usu_crea'       => $this->tank_auth->get_user_id(),
                    'cdd_usu_mod'        => $this->tank_auth->get_user_id()
                );
            
            // Verificar si esa llamada no se ha ingresado antes 
            $temp_array = array(
                    'cdd_numero_origen' => $cdd_numero_origen[$key],
                    'cdd_fecha_inicio'  => date('Y-m-d H:i:s', strtotime($cdd_fecha_inicio[$key]))
                );
            
            $duplicado = $this->tarificador_model->buscar_duplicados('cdd_cdr_detalle', $temp_array);
            if($duplicado == 0){

                $id_detalle = $this->gsatelite->ingresar('cdd_cdr_detalle', $array_condicion);
                // Obtener el prefijo de pais del numero destino
                $numero_destino = $cdd_numero_destino[$key];     // Term Number
                $filtro_uno = substr($numero_destino,0,1);   // Primer caracter
                $cadena_inicio = substr($numero_destino, 0, $this->tarificador_model->get_codigo_pais_length($filtro_uno) );
                $flagEncontrado = false;
                for ($i = strlen($cadena_inicio); $i > 0 ; $i--) { 
                    $cadena_busqueda  =  substr($cadena_inicio, 0, $i);
                    $contador = $this->tarificador_model->get_codigo_pais($cadena_busqueda);
                    if($contador==1){
                        $temp_array = array(
                                'cdd_id'        => $id_detalle,
                                'cdd_destino'   => $cadena_busqueda
                            );
                        array_push($cdd_actualizar, $temp_array);
                        $flagEncontrado = true;
                        break;
                    }
                } // End for
                
                // Si no hay codigo de pais en el Sistema, colocar ese codigo de error en la fila cdr_detalle
                if(!$flagEncontrado)
                    array_push($tempCdd_array, array('cdd_id'=>$id_detalle,'cdd_id_coe'=>4));
            }
        }   // End if
    } // End foreach
    
    if(count($tempCdd_array)>0)
       @$this->db->update_batch('cdd_cdr_detalle', $tempCdd_array, 'cdd_id');    
    
    if(count($cdd_actualizar)>0){
        //Copiamos el archivo a la carpeta de CDR procesados
        $carpeta_destino="uploads/archivos/cdr_procesados/".$this->input->post('cdr_nombre');
        if($this->input->post('cdr_ruta')) rename($this->input->post('cdr_ruta'), $carpeta_destino);
        
        @$this->db->update_batch('cdd_cdr_detalle', $cdd_actualizar, 'cdd_id');    
        $this->gsatelite->show_dialog('CDR guardado correctamente.','tarificador/procesos/cargar_cdr','success');
    } else {
        $this->gsatelite->actualizar_array('cdr_resumen', array('cdr_estado'=>0, 'cdr_procesado'=>0, 'cdr_observacion'=>'0004'), array('cdr_id'=>$id_cdr));
        $this->gsatelite->show_dialog('No se pudo guardar el Archivo.','tarificador/procesos/cargar_cdr','error');
    }
    
    } // End POST
  } // End procesar_cdr 

   /**
    *  @author Melbin Cruz
    */
  
   function procesar_costo_llamada_automatico()
   {
       $this->calcular_costo_llamada(date('Y-m-01'), date('Y-m-d'), false);
       redirect('/auth/login/');
   }

   /**
    *  @author Melbin Cruz
    */
  function calcular_costo_llamada($fecha_inicio=null, $fecha_fin=null, $flag=TRUE)
  {     
      if($flag)
        satelite_validar(true);
        
        if($_POST){
            $fecha_inicio = date('Y-m-d',strtotime($this->input->post('fecha_ini')));
            $fecha_fin = date('Y-m-d',strtotime($this->input->post('fecha_fin')));
            (int)$cliente = $this->input->post('cliente');
           
            if($cliente>0){
                $tel_cliente = $this->tarificador_model->get_numero_cliente($cliente);
            
                $numero_principal=$tel_cliente[0]['cdd_numero_origen'];
                if($numero_principal==""){
                    $numero_principal=0;
                }
            }else{
                $numero_principal=null;
            }
        }
        
        // Buscar codigos de paises para las llamadas que no tengan uno
        $cdd_actualizar = array();
        $llamadasSinCodigo = $this->db->select('cdd_id, cdd_numero_destino, cdd_destino')->from('cdd_cdr_detalle')->where(array('cdd_fecha_inicio >= '=>$fecha_inicio, 'cdd_fecha_inicio <='=>$fecha_fin, 'cdd_destino IS NULL' =>NULL))->get()->result();
        if(count($llamadasSinCodigo)>0){
            foreach ($llamadasSinCodigo as $key => $llamada) {
                // Obtener el prefijo de pais del numero destino
                $numero_destino = $llamada->cdd_numero_destino;     // Term Number
                $filtro_uno = substr($numero_destino,0,1);   // Primer caracter
                $cadena_inicio = substr($numero_destino, 0, $this->tarificador_model->get_codigo_pais_length($filtro_uno) );
                $flagEncontrado = false;
                for ($i = strlen($cadena_inicio); $i > 0 ; $i--) { 
                    $cadena_busqueda  =  substr($cadena_inicio, 0, $i);
                    $contador = $this->tarificador_model->get_codigo_pais($cadena_busqueda);
                    if($contador==1){
                        $temp_array = array(
                                'cdd_id'        => $llamada->cdd_id,
                                'cdd_destino'   => $cadena_busqueda,
                                'cdd_id_coe'    => NULL
                            );
                        array_push($cdd_actualizar, $temp_array);
                        $flagEncontrado = true;
                        break;
                    }
                } // End for
            }
        }
        
        if(count($cdd_actualizar)>0){
            @$this->db->update_batch('cdd_cdr_detalle', $cdd_actualizar, 'cdd_id');    
        }
        
        // Se resetean los costos para volver a calcularlos
        $this->db->where(array('cdd_fecha_inicio >= '=>$fecha_inicio, 'cdd_fecha_inicio <='=>$fecha_fin, 'cdd_destino <>' => ''))->update('cdd_cdr_detalle',array('cdd_procesado'=>0,'cdd_costo_unit'=>0,'cdd_costo_total'=>0,'cdd_detalle_costo'=>NULL, 'cdd_detalle_costo_factura'=>NULL, 'cdd_id_coe'=>NULL));
        
        // Los numeros favoritos se colocan como procesados, ya que estos tendran un costo de $0.
        $numeros_favoritos  =  $this->tarificador_model->favoritosCliente($fecha_inicio, $fecha_fin);
        
        $tmp_favoritos = array();
        if(count($numeros_favoritos)>0){
            foreach ($numeros_favoritos as $key => $value){
                $tmp_array = array(
                    'cdd_id'    =>  $value['cdd_id'],
                    'cdd_detalle_costo' => json_encode(array('Llamada gratis por ser a número favorito.')),
                    'cdd_id_coe'    =>  NULL,
                    'cdd_procesado' =>  1,
                );
                array_push($tmp_favoritos, $tmp_array);
            }
        }
        if(!empty($tmp_favoritos))
            @$this->db->update_batch('cdd_cdr_detalle', $tmp_favoritos, 'cdd_id');     
        
        $planes_minutos_incluidos = $this->tarificador_model->get_planes_minutos_incluidos($fecha_inicio, $fecha_fin, $numero_principal);
        $cdr_detalle = $this->tarificador_model->get_cdr($fecha_inicio, $fecha_fin, $numero_principal);

        // Este array guadara los datos de las llamadas que se pasan de sus minutos gratis
        $llamadas_exceden    =  array();
        $actualizar_cdr      =  array();
        $subtotal = 0;
        
        foreach ($planes_minutos_incluidos as $key => $plan_fila) {
            $minutos_gratis = floatval($plan_fila['pln_minuto']);

            // Si es otro numero, reiniciar el subtotal
            if( $key > 0 && ( $plan_fila['txs_numero'] != $planes_minutos_incluidos[$key-1]['txs_numero'] )){
                $subtotal = 0;
            }
            // Si es un plan distinto: Reiniciar el subtotal
            if( $key >0 && ( $plan_fila['pln_id'] != $planes_minutos_incluidos[$key-1]['pln_id'] )){
                $subtotal = 0;
            }
           
            if( floatval($subtotal) < floatval($minutos_gratis)){ 
            foreach ($cdr_detalle as $indice => $cdr_fila) {
                if($plan_fila['txs_numero'] == $cdr_fila['cdd_numero_origen'] && $plan_fila['ppa_desde_codigo'] == $cdr_fila['cdd_destino'])
                {
                    if (date('Y-m-d', strtotime($plan_fila['pxl_fecha_fin'])) >= date('Y-m-d', strtotime($cdr_fila['cdd_fecha_inicio'])))
                    {
                        
                        $minutos_libres = $minutos_gratis - floatval($subtotal);
                        $cobroDetalle = (json_decode($cdr_fila['cdd_detalle_costo'])!= NULL)? json_decode($cdr_fila['cdd_detalle_costo']): array();
                        $cobroDetalleFactura = (json_decode($cdr_fila['cdd_detalle_costo_factura'])!= NULL)? json_decode($cdr_fila['cdd_detalle_costo_factura']): array();
                        $tipoPlan = ($plan_fila['pln_tipo']==1)? 'el plan': 'la promoción';
                        
                        if( floatval($cdr_fila['cdd_duracion_min']) > floatval($minutos_libres) ) {
                            if($minutos_libres > 0){
                                $cdr_detalle[$indice]['cdd_duracion_min']  -= $minutos_libres; // Para recalcular sobre el objeto actualizado
                                $cdr_detalle[$indice]['consolidar_minutos']  = 1; 
                                $cdr_fila['cdd_duracion_min'] -=   $minutos_libres;
                                $cdr_fila['flag'] = 1;
                                
                               // Obtener el JSON y pasarlo a un array normal
                                $cadena  = $minutos_libres .' min incluidos en '.$tipoPlan.' ('.$plan_fila['pln_nombre'].')';
                                array_push($cobroDetalle, $cadena);
                                $cdr_detalle[$indice]['cdd_detalle_costo'] = json_encode($cobroDetalle);
                                $cdr_fila['cdd_detalle_costo'] = json_encode($cobroDetalle);
                               // Detalle para la factura
                                array_push($cobroDetalleFactura, $minutos_libres.'/$0.00');
                                $cdr_detalle[$indice]['cdd_detalle_costo_factura'] = json_encode($cobroDetalleFactura);
                                $cdr_fila['cdd_detalle_costo_factura'] = json_encode($cobroDetalleFactura);
                                
                                $tmp_array = array(
                                    'cdd_detalle_costo' =>  json_encode($cobroDetalle),
                                    'cdd_detalle_costo_factura' => json_encode($cobroDetalleFactura),
                                    'cdd_procesado' =>  1,
                                    'cdd_id'    =>  $cdr_fila['cdd_id']
                                );
                                array_push($actualizar_cdr, $tmp_array); //Estado procesado, por rendimiento de query
                                
                                $subtotal += $minutos_libres; 

                                // Actualizar o agregar un registro a actualizar_cdr
                                $flag=true;
                                if(count($llamadas_exceden)>0){
                                    foreach ($llamadas_exceden as $i => $fila) {
                                        if($fila['cdd_id'] == $cdr_fila['cdd_id']){
                                            $llamadas_exceden[$i]['cdd_duracion_min']  -= $minutos_libres;
                                            $flag=false;
                                            break;
                                        }
                                    }
                                    if($flag) // Si flag es true, No se encontro el registro y habra que ingresarlo.
                                        array_push($llamadas_exceden, $cdr_fila); //Estado procesado, por rendimiento de query
                                } else {
                                    array_push($llamadas_exceden, $cdr_fila); //Estado procesado, por rendimiento de query
                                }
                            }
                            break;
                        } else {
                            // Eliminamos el registro del CDR, ya que no volvera a ser procesado.
                            unset($cdr_detalle[$indice]);
                            $subtotal += $cdr_fila['cdd_duracion_min'];
                            
                        // Si existe el registro en llamadas_exceden, hay que sacarlo ya que no debe ser procesado.
                            foreach ($llamadas_exceden as $i => $fila) {
                                if($fila['cdd_id'] == $cdr_fila['cdd_id']){
                                    unset($llamadas_exceden[$i]);
                                    break;
                                }
                            }
                        
                            // Actualizar el registro (procesado = 1)
                            $cadena  = $cdr_fila['cdd_duracion_min'] .' min incluidos en '.$tipoPlan.' ('.$plan_fila['pln_nombre'].')';
                            array_push($cobroDetalle, $cadena);
                            array_push($cobroDetalleFactura, $cdr_fila['cdd_duracion_min'].'/$0.00');
                            
                            $tmp_array = array(
                                'cdd_detalle_costo' =>  json_encode($cobroDetalle),
                                'cdd_detalle_costo_factura' => json_encode($cobroDetalleFactura),
                                'cdd_procesado' =>  1,
                                'cdd_id'    =>  $cdr_fila['cdd_id']
                              );
                            
                            // Dejar solo el registro mas reciente
                            foreach ($actualizar_cdr as $i => $fila) {
                                if($fila['cdd_id'] == $cdr_fila['cdd_id']){
                                    unset($actualizar_cdr[$i]);
                                    break;
                                }
                            }
                            array_push($actualizar_cdr, $tmp_array);
                        }
                    }
                }  
            } // End foreach cdr
         }
        }
        //$actualizar_cdr = array_unique($actualizar_cdr);
        
        // Actualizar los registros que tengan llamada gratis (cdd_procesado = 1)
        if(count($actualizar_cdr)>0){
           @$this->db->update_batch('cdd_cdr_detalle', $actualizar_cdr, 'cdd_id');
           //@$this->db->where_in('cdd_id', $actualizar_cdr)->update('cdd_cdr_detalle',array('cdd_procesado'=>1));
        }
        
        // Calcular las promociones
         $promociones = $this->tarificador_model->get_promociones($fecha_inicio, $fecha_fin, $numero_principal);
         $cdr_detalle = $this->tarificador_model->get_cdr($fecha_inicio, $fecha_fin, $numero_principal);
        
        // Llamadas que quedaron pendientes de cobrar en el paso anterior 
        $cdr_detalle =  array_merge($llamadas_exceden, $cdr_detalle);
        
        /* Minutos promocionales */
        $llamadas_exceden    =  array();
        $actualizar_cdr      =  array();
        
        $minutos_consolidados = 0;      // Cuando los minutos de las tarifas no son secuenciales.
        $minutosLibresAnterior   =   0;
       
        foreach ($promociones as $key => $promocion_fila) {

            foreach ($cdr_detalle as $indice => $cdr_fila) {
                
                // Si es otro numero de telefono, reiniciar el contador de minutos_consolidados
                if( $key > 0 && ( $promocion_fila['txs_numero'] != $promociones[$key-1]['txs_numero'] )){
                    $minutos_consolidados = 0;
                    $minutosLibresAnterior= 0;
                }
                if($cdr_fila['cdd_procesado']==0)
                if($promocion_fila['txs_numero'] == $cdr_fila['cdd_numero_origen'] && $promocion_fila['ppa_desde_codigo'] == $cdr_fila['cdd_destino'])
                  {
                    // Verificar si la promocion estaba vigente en la fecha de la llamada
                    if( $cdr_fila['cdd_fecha_inicio'] >= $promocion_fila['pxl_fecha_inicio'] && $cdr_fila['cdd_fecha_inicio'] <= $promocion_fila['pxl_fecha_fin'] ){
                        // Verificar si la tarifa esta vigente
                        if( $cdr_fila['cdd_fecha_inicio'] >= $promocion_fila['trf_desde'] && ( empty($promocion_fila['trf_hasta']) || ( !empty($promocion_fila['trf_hasta']) && date('Y-m-d', strtotime($promocion_fila['trf_hasta'])) >= date('Y-m-d', strtotime($cdr_fila['cdd_fecha_inicio'])) ) )){
                            // Si esta vigente, validar dias habiles
                            if ( empty($promocion_fila['trf_id_dia_desde']) || ( date('N', strtotime($cdr_fila['cdd_fecha_inicio'])) >= $promocion_fila['trf_id_dia_desde'] && date('N', strtotime($cdr_fila['cdd_fecha_inicio'])) <= $promocion_fila['trf_id_dia_hasta'] )){
                                // Validar horarios
                                if( (empty($promocion_fila['trf_desde_horario']) && empty($promocion_fila['trf_hasta_horario'])) || ( !empty($promocion_fila['trf_hasta_horario']) &&  date('H:i:s', strtotime($cdr_fila['cdd_fecha_inicio'])) <= $promocion_fila['trf_hasta_horario'] ) || ( date('H:i:s', strtotime($cdr_fila['cdd_fecha_inicio'])) >= $promocion_fila['trf_desde_horario'] && date('H:i:s', strtotime($cdr_fila['cdd_fecha_inicio'])) <= $promocion_fila['trf_hasta_horario'] ) ){
                                    // Calcular los minutos que aplican
                                    $min_promo_desde = (!empty($promocion_fila['trf_desde_minuto']))? floatval($promocion_fila['trf_desde_minuto']): 0;
                                    $min_promo_hasta = (!empty($promocion_fila['trf_hasta_minuto']))? floatval($promocion_fila['trf_hasta_minuto']): 0;
                                    $desde_activado = ($min_promo_desde>0 && $min_promo_hasta==0)? true:false;
                                    $minutos_promocion  = $min_promo_hasta - $min_promo_desde;
                                    $minutos_hablados   = floatval($cdr_fila['cdd_duracion_min']);
                                    $costo_acarreo = (!empty($cdr_fila['cdd_costo_total']))? floatval($cdr_fila['cdd_costo_total']): 0; 
                                    $cobroDetalle = (json_decode($cdr_fila['cdd_detalle_costo'])!= NULL)? json_decode($cdr_fila['cdd_detalle_costo']): array();
                                    $cobroDetalleFactura = (json_decode($cdr_fila['cdd_detalle_costo_factura'])!= NULL)? json_decode($cdr_fila['cdd_detalle_costo_factura']): array();
                                    $minDetalleCosto=0;
                                    $minutos_cobrados_normal = 0;
                                    $minutos_aplica_promocion = 0;
                                    $min_promo=0;
                                    $minutos_cobro_normal=0;
                                    $procesadoCompleto = 0;
                                    $FlagLlamadaExcede = false;
                                    
                                    // Si los minutos de esta tarifa ya fueron cosumidos pasar a la siguiente.
                                    if( ($min_promo_desde == $min_promo_hasta) && $minutosLibresAnterior > 0 ){
                                        break;
                                    }
                                    
                                    // Cuando hay un promocion que  No tiene Fin
                                    if($desde_activado){
                                        $minutos_consolidados = $min_promo_desde;
                                    }
                                    
                                    // Verificar si hay minutos hablados, de un bucle anterior.
                                    $calculoDesde    =   ($minutos_consolidados>0)? $min_promo_desde - floatval($minutos_consolidados):0; 
                                    $min_promo_desde  =    ($calculoDesde>0)? $calculoDesde: 0; 
                                    if($calculoDesde<0){
                                        $min_promo=0;
                                        $minutos_consolidados=0;
                                        $minutosLibresAnterior=0;
                                    }
                                    if($minutos_promocion == 0 || $minutos_promocion >= $minutos_hablados){
                                        
                                       $estado=1; // No procede 
                                       if($minutos_promocion>= $minutos_hablados){
                                           $procesadoCompleto = 1;
                                       }
                                       
                                       $cdr_detalle[$indice]['cdd_procesado'] = 1;
                                       
                                        // Hacer el cobro total de los minutos con la tarifa de la promocion
                                        $costo = floatval($promocion_fila['trf_costo'])*floatval($cdr_fila['cdd_duracion_min']) + $costo_acarreo;
                                        $cdr_fila['cdd_costo_total'] = $costo;
                                        $cdr_fila['flag'] = 0;
                                        $cdr_detalle[$indice]['flag']   =   0;
                                        $minDetalleCosto =   $cdr_fila['cdd_duracion_min'];
                                 
                                    } else { // Si habló mas del tiempo de promoción.

                                        // Hay una tarifa que No tiene minutos hasta.
                                        $estado = 0;
                                        $FlagLlamadaExcede=true;
                                        if($desde_activado){
                                            $estado=1;
                                            $FlagLlamadaExcede = false;
                                            $procesadoCompleto=1;
                                            $minutos_cobrados_normal = ($cdr_fila['cdd_duracion_min'] > $min_promo_desde)? $min_promo_desde:0;
                                            $minutos_aplica_promocion= ($cdr_fila['cdd_duracion_min'] > $min_promo_desde)? floatval($cdr_fila['cdd_duracion_min']) - $min_promo_desde:0;
                                        } 
                                        
                                        $minutos_cobro_normal = ($minutos_cobrados_normal>0)? $minutos_cobrados_normal: $minutos_hablados - $minutos_promocion;
                                        $min_promo = ($minutos_aplica_promocion>0)? $minutos_aplica_promocion: $minutos_promocion;
                                        $minDetalleCosto = $min_promo;
                                        $costo_parcial = floatval($promocion_fila['trf_costo'])*$min_promo + $costo_acarreo;
                                        $cdr_detalle[$indice]['cdd_costo_total'] = $cdr_fila['cdd_costo_total'] = $costo_parcial;
                                        $cdr_detalle[$indice]['cdd_duracion_min'] = $cdr_fila['cdd_duracion_min']= $minutos_cobro_normal;
                                        $cdr_detalle[$indice]['cdd_procesado']  =   $estado; // Por prevencion
                                        
                                        // Estas doslineas no se aun para que son
                                        $cdr_fila['flag'] = 2;
                                        $cdr_detalle[$indice]['flag'] = 2;
                                        
                                    } // Fin de if (Si hablo mas del tiempo de promocion)
                                    
                                    // Registrar el detalle del cobro: Obtenemos el JSON y lo pasamos a un array normal
                                        $cadena  = $minDetalleCosto .' min a $'.$promocion_fila['trf_costo'].' = $'.(floatval($promocion_fila['trf_costo'])*$minDetalleCosto).' ('.$promocion_fila['pln_nombre'].', Tarifa: '.$promocion_fila['trf_nombre'].')';
                                        array_push($cobroDetalle, $cadena);
                                        $cdr_detalle[$indice]['cdd_detalle_costo'] = json_encode($cobroDetalle);
                                        $cdr_fila['cdd_detalle_costo']  =   json_encode($cobroDetalle);
                                    
                                    // Registrar el detalle para la factura
                                        array_push($cobroDetalleFactura, $minDetalleCosto.'/$'.$promocion_fila['trf_costo']);
                                        $cdr_detalle[$indice]['cdd_detalle_costo_factura'] = json_encode($cobroDetalleFactura);
                                        $cdr_fila['cdd_detalle_costo_factura'] = json_encode($cobroDetalleFactura);
                                        
                                      // Buscar en $llamadas_exceden si existe el registro actualizar, si no existe ingresarlo como nuevo.
                                        $flag=true;
                                        if(count($llamadas_exceden)>0){
                                            foreach ($llamadas_exceden as $i => $fila) {
                                                if($fila['cdd_id'] == $cdr_fila['cdd_id']){
                                                    if($procesadoCompleto){
                                                        unset($llamadas_exceden[$i]);
                                                    } else {
                                                        $llamadas_exceden[$i]   =   $cdr_fila;
                                                    }
                                                    $flag=false;
                                                    break;
                                                }
                                            }
                                            if($flag && $FlagLlamadaExcede) // Si flag es true, No se encontro el registro y habra que ingresarlo.
                                                array_push($llamadas_exceden, $cdr_fila);        
                                        } else {
                                            if(!$estado && $FlagLlamadaExcede) //Si las tarifas tienen limite
                                            array_push($llamadas_exceden, $cdr_fila);    
                                        }
                                    
                                    // Guardamos el registro para actualizarlo en la Base de Datos
                                    $temp_array = array(
                                                'cdd_id'    =>  $cdr_fila['cdd_id'],
                                                'cdd_costo_unit' => $promocion_fila['trf_costo'],
                                                'cdd_costo_total'=> $cdr_fila['cdd_costo_total'],
                                                'cdd_detalle_costo'  =>  json_encode($cobroDetalle),
                                                'cdd_detalle_costo_factura' => json_encode($cobroDetalleFactura),
                                                'cdd_procesado'  => 1
                                            );
                                    
                                    // Descontar los minutos del Array de planes/promociones
                                        if($min_promo_hasta>0){
                                            $minutosLibresAnterior = $min_promo_hasta;
                                            $promocion_fila['trf_hasta_minuto'] -= (isset($min_promo) && $min_promo>0)? $min_promo: floatval($minutos_hablados);
                                            $minutos_consolidados += (isset($min_promo) && $min_promo>0)? $min_promo: floatval($cdr_fila['cdd_duracion_min']);
                                        }
                                        
//                                    // Si 'Hasta Minutos' esta vacio, reiniciar el contador de minutos consolidados
//                                    if(empty($promocion_fila['trf_hasta_minuto']))
//                                        //$minutos_consolidados = 0;
                                    
                                    // Buscar en $actualizar_cdr si existe el registro actualizar, si no existe ingresarlo como nuevo.
                                        $flag=true;
                                        if(count($actualizar_cdr)>0){
                                            foreach ($actualizar_cdr as $i => $fila) {
                                                if($fila['cdd_id'] == $temp_array['cdd_id']){
                                                    $actualizar_cdr[$i]   =   $temp_array;
                                                    $flag=false;
                                                    break;
                                                }
                                            }
                                            if($flag) // Si flag es true, No se encontro el registro y habra que ingresarlo.
                                                array_push($actualizar_cdr, $temp_array);        
                                        } else {
                                            array_push($actualizar_cdr, $temp_array);    
                                        }
                                }
                            }
                        }  
                    }
                }
            }// End foreach cdr
        }//End foreach promociones
        //Actualizar las llamadas con minutos promocionales
       
        if(count($actualizar_cdr)>0){
            @$this->db->update_batch('cdd_cdr_detalle', $actualizar_cdr, 'cdd_id');     
        }
        
        // Calcular las tarifas a costo normal de los clientes
         $tarifas_por_plan = $this->tarificador_model->get_planes($fecha_inicio, $fecha_fin, $numero_principal);
         $cdr_detalle_fin = $this->tarificador_model->get_cdr($fecha_inicio, $fecha_fin, $numero_principal);

        // Agregar las llamadas a tarifas_por_plan que no fueron procesadas en las promociones, y traen acarreo de minutos.
        $llamadas_sin_promociones = array();
        foreach ($cdr_detalle as $key => $value) {
            if($value['flag']==1)
                array_push($llamadas_sin_promociones, $value);
        }
        
        $cdr_detalle_fin =  array_merge($llamadas_sin_promociones , $cdr_detalle_fin);
        
        // Agregar las llamadas que se pasaron de sus minutos promocionales, Y las que no tenian ni minutos gratis ni Promociones. 
        $cdr_detalle_fin =  array_merge($llamadas_exceden , $cdr_detalle_fin);
        
       $actualizar_cdr  =  array();
       $minutos_consolidados = 0;
       $minutosLibresAnterior   =   0;
       $numeroProcesado = 0;
        foreach ($tarifas_por_plan as $key => $tarifa_fila) {
            
            foreach ($cdr_detalle_fin as $indice => $cdr_fila) {
                
                // Si es otro numero de telefono, reiniciar el contador de minutos_consolidados
                if( $key > 0 && ( $tarifa_fila['txs_numero'] != $numeroProcesado )){
                    $minutos_consolidados = 0;
                    $minutosLibresAnterior= 0;
                }
                
                if($cdr_fila['cdd_procesado']==0)
                if($tarifa_fila['txs_numero'] == $cdr_fila['cdd_numero_origen'] && $tarifa_fila['ppa_desde_codigo'] == $cdr_fila['cdd_destino'])
                  {                    
                    // Verificar si el plan estaba vigente en la fecha de la llamada
                    if( $cdr_fila['cdd_fecha_inicio'] >= $tarifa_fila['pxl_fecha_inicio'] && $cdr_fila['cdd_fecha_inicio'] <= $tarifa_fila['pxl_fecha_fin'] ){
                        // Verificar si la tarifa esta vigente
                        if( $cdr_fila['cdd_fecha_inicio'] >= $tarifa_fila['trf_desde'] && ( empty($tarifa_fila['trf_hasta']) || ( !empty($tarifa_fila['trf_hasta']) && date('Y-m-d', strtotime($tarifa_fila['trf_hasta'])) >= date('Y-m-d', strtotime($cdr_fila['cdd_fecha_inicio'])) ) )){   
                            // Si esta vigente, valiar dias habiles
                            if ( empty($tarifa_fila['trf_id_dia_desde']) || ( date('N', strtotime($cdr_fila['cdd_fecha_inicio'])) >= $tarifa_fila['trf_id_dia_desde'] && date('N', strtotime($cdr_fila['cdd_fecha_inicio'])) <= $tarifa_fila['trf_id_dia_hasta'] )){
                                // Validar horarios
                                if( (empty($tarifa_fila['trf_desde_horario']) && empty($tarifa_fila['trf_hasta_horario'])) || ( !empty($tarifa_fila['trf_hasta_horario']) &&  date('H:i:s', strtotime($cdr_fila['cdd_fecha_inicio'])) <= $tarifa_fila['trf_hasta_horario'] ) || ( date('H:i:s', strtotime($cdr_fila['cdd_fecha_inicio'])) >= $tarifa_fila['trf_desde_horario'] && date('H:i:s', strtotime($cdr_fila['cdd_fecha_inicio'])) <= $tarifa_fila['trf_hasta_horario'] ) ){
                                    
                                    // Calcular los minutos que aplican (Nuevo)
                                    $min_desde = (!empty($tarifa_fila['trf_desde_minuto']))? floatval($tarifa_fila['trf_desde_minuto']): 0;
                                    $min_hasta = (!empty($tarifa_fila['trf_hasta_minuto']))? floatval($tarifa_fila['trf_hasta_minuto']): 0;
                                    $cobroDetalle = (json_decode($cdr_fila['cdd_detalle_costo'])!= NULL)? json_decode($cdr_fila['cdd_detalle_costo']): array();
                                    $cobroDetalleFactura = (json_decode($cdr_fila['cdd_detalle_costo_factura'])!= NULL)? json_decode($cdr_fila['cdd_detalle_costo_factura']): array();
                                    
                                    // Si los minutos de esta tarifa ya fueron consumidos pasar a la siguiente.
                                    if( ($min_desde == $min_hasta) && $minutosLibresAnterior > 0 ){
                                        break;
                                    }
                                    
                                    $minutos_consolidados   =   ($min_desde==0)? 0: $minutos_consolidados;
                                    
                                    $desde_activado = ($min_desde>0 && $min_hasta==0)? true:false;
                                    $minutos_tarifa  = $min_hasta - $min_desde;
                                    $minutos_sin_cobrar = 0;
                                    
                                    // Cuando hay un tarifa que  No tiene Fin
                                    if($desde_activado){
                                        $minutos_consolidados = $min_desde;
                                    }
                                    
                                    // Verificar si hay minutos hablados, de un bucle anterior.
                                    $calculoDesde    =   ($minutos_consolidados>0)? $min_desde - floatval($minutos_consolidados):0; 
                                    $min_desde  =    ($calculoDesde>=0)? $calculoDesde: 0; 
                                    if($calculoDesde<0){
                                        $minutos_hablados=0;
                                        $minutos_consolidados=0;
                                        $minutosLibresAnterior=0;
                                    }
                                   
                                    
                                    $minutos_hablados   = floatval($cdr_fila['cdd_duracion_min']);

                                    // Si esta activado el cobro desde el minuto N, y se dejo vacio el Hasta.
                                    if($desde_activado){
                                        //$minutos_sin_cobrar = ($cdr_fila['cdd_duracion_min'] > $min_desde)? $min_desde:0;
                                        $minutos_hablados   = ($cdr_fila['cdd_duracion_min'] > $min_desde)? floatval($cdr_fila['cdd_duracion_min']) - $min_desde: 0;
                                        $minutos_consolidados   += ($minutos_hablados>0)? $minutos_hablados: floatval($cdr_fila['cdd_duracion_min']);
                                    }

                                    // Si hay un Hasta
                                    if($min_hasta>0){
                                        $min_aplica     =  ( ( $min_hasta - $min_desde ) <= $minutos_tarifa  ) ? $min_hasta - $min_desde : $minutos_tarifa;
                                        if($min_aplica < $minutos_hablados){
                                            $minutos_sin_cobrar =   floatval($minutos_hablados) - floatval($min_aplica);
                                            $minutos_hablados   =   $min_aplica;    // Minutos que se cobraran
                                        }
                                    }   

                                    if( $minutos_hablados>0 ){
                                       // Hacer el cobro de los minutos
                                        $costo_total    =   (floatval($tarifa_fila['trf_costo'])*$minutos_hablados) + $cdr_fila['cdd_costo_total'];
                                        
                                       // Obtener el JSON y pasarlo a un array normal
                                        $cadena  = $minutos_hablados .' min a $'.$tarifa_fila['trf_costo'].' = $'.(floatval($tarifa_fila['trf_costo'])*$minutos_hablados).' ('.$tarifa_fila['pln_nombre'].', Tarifa: '.$tarifa_fila['trf_nombre'].')';
                                        array_push($cobroDetalle, $cadena);
                                        $cdr_detalle_fin[$indice]['cdd_detalle_costo'] = json_encode($cobroDetalle);
                                       
                                      // Detalle para la factura  
                                        array_push($cobroDetalleFactura, $minutos_hablados.'/$'.$tarifa_fila['trf_costo']);
                                        $cdr_detalle_fin[$indice]['cdd_detalle_costo_factura'] = json_encode($cobroDetalleFactura);
                                        $cdr_detalle_fin['cdd_detalle_costo_factura'] = json_encode($cobroDetalleFactura);
                                        
                                       // Descontar los minutos del Array de planes/promociones
                                        if($min_hasta>0){
                                            $minutosLibresAnterior = floatval($tarifa_fila['trf_hasta_minuto']);
                                            $tarifa_fila['trf_hasta_minuto']  -=    $minutos_hablados;
                                        }  
                                    } else {
                                        $costo_total    =   $cdr_fila['cdd_costo_total'];
                                    }
                                    
                                        $temp_array = array(
                                                'cdd_id'    =>  $cdr_fila['cdd_id'],
                                                'cdd_costo_unit' => $tarifa_fila['trf_costo'],
                                                'cdd_costo_total'=> $costo_total,
                                                'cdd_detalle_costo' => json_encode($cobroDetalle),
                                                'cdd_detalle_costo_factura' => json_encode($cobroDetalleFactura),
                                                'cdd_procesado'  => 1
                                            );
                                        $cdr_detalle_fin[$indice]['cdd_procesado'] = 1;

                                        // Validaciones
                                        if($minutos_sin_cobrar>0){
                                            $temp_array['cdd_procesado'] = 0;
                                            $cdr_detalle_fin[$indice]['cdd_procesado'] = 0;
                                            $minutos_consolidados   += $minutos_hablados;
                                            $cdr_detalle_fin[$indice]['cdd_duracion_min']   = $minutos_sin_cobrar;
                                            $cdr_detalle_fin[$indice]['cdd_costo_total']    = $costo_total;
                                        } else {
                                            //$tarifa_fila['min_hasta_consolidado']   = 0;
                                        }
                                        
                                        // Validar bien esto
                                        $numeroProcesado =$tarifa_fila['txs_numero'];
                                        
                                        //
                                        if($minutos_hablados==0 && (isset($minutos_consolidados)) ){
                                            // procesar la llamada (Ya que se tomara como minutos gratis)
                                            $cdr_detalle_fin[$indice]['cdd_procesado'] = 1;
                                            $temp_array['cdd_procesado'] = 1;
                                        }
                                        
                                        // Buscar en $actualizar_cdr si existe el registro actualizar, si no existe ingresarlo como nuevo.
                                        $flag=true;
                                        if(count($actualizar_cdr)>0){
                                            foreach ($actualizar_cdr as $i => $fila) {
                                                if($fila['cdd_id'] == $temp_array['cdd_id']){
                                                    $actualizar_cdr[$i]   =   $temp_array;
                                                    $flag=false;
                                                    break;
                                                }
                                            }
                                            if($flag) // Si flag es true, No se encontro el registro y habra que ingresarlo.
                                                array_push($actualizar_cdr, $temp_array);        
                                        } else {
                                            array_push($actualizar_cdr, $temp_array);    
                                        }  
                                }
                            }
                        }       
                    }
                }  
            } // End foreach cdr
        } // End foreach tarifas_por_plan

        //Actualizar el costo normal de las llamadas
        if(count($actualizar_cdr)>0){
            @$this->db->update_batch('cdd_cdr_detalle', $actualizar_cdr, 'cdd_id');    
        }
        
        // Si hay tarifas vencidas, anularlas
        $tarifas = $this->gsatelite->get_tabla('trf_tarifa', array('trf_estado'=>1));
        $tarifas_vencidas = array();
        foreach ($tarifas as $key => $value) {
                if(!empty($value['trf_hasta']) && date('Y-m-d', strtotime($value['trf_hasta'])) < date('Y-m-d') ){
                    array_push($tarifas_vencidas, $value['trf_id']);

                }else if(!empty($value['trf_hasta']) && date('Y-m-d', strtotime($value['trf_hasta'])) == date('Y-m-d') && date('H:i', strtotime($value['trf_hasta_horario']))<=date('H:i')){
                    array_push($tarifas_vencidas, $value['trf_id']);
                }
        }
        
        if(count($tarifas_vencidas)>0){
            @$this->db->where_in('trf_id', $tarifas_vencidas)->update('trf_tarifa', array('trf_estado'=>0));
        }
        
        // Calcular el codigo de error de todas aquellas llamadas que No fueron procedas.
        $whereCodigo = array('cdd_fecha_inicio >= '=>$fecha_inicio, 'cdd_fecha_inicio <='=>date('Y-m-d 23:59:59', strtotime($fecha_fin)),'cdd_procesado'=>0, 'cdd_destino <>'=>'', 'cdr_estado'=>1,'cdr_procesado'=>1);
            if($numero_principal>=0 && !is_null($numero_principal)){
                $whereCodigo['cdd_numero_origen']=$numero_principal;
            }
            
        $cdrLlamanasNoProcesadas   =   $this->tarificador_model->getTarifasCdrActivo($whereCodigo);
        $tarifasPromoPlan =   $this->tarificador_model->get_planesPromociones($fecha_inicio, $fecha_fin, $numero_principal);
        
        $numerosClienteDB = array_unique(array_column($tarifasPromoPlan, 'txs_numero'));
        $codigosDestinoDB = array_unique(array_column($tarifasPromoPlan, 'ppa_desde_codigo'));
        $clienteDestinoDB = array();
        
        foreach($tarifasPromoPlan as $indice => $fila){
            array_push($clienteDestinoDB, $fila['txs_numero'].'#'.$fila['ppa_desde_codigo']);
        }
        
        $actualizarArray = array();
        foreach ($cdrLlamanasNoProcesadas as $key => $cdrFila)
        {
          
          // El número de telefono no esta asociado a un servicio
            if(!in_array($cdrFila['cdd_numero_origen'], $numerosClienteDB)){
                array_push($actualizarArray, array('cdd_id_coe'=>1, 'cdd_id'=>$cdrFila['cdd_id']));
                continue;
            }
            
            // No existe el código de destino en el Sistema
            if(!in_array($cdrFila['cdd_destino'], $codigosDestinoDB)){
                array_push($actualizarArray, array('cdd_id_coe'=>2, 'cdd_id'=>$cdrFila['cdd_id']));
                continue;
            }
            
            // Pensarlo mejor
            if(!in_array($cdrFila['cdd_numero_origen'].'#'.$cdrFila['cdd_destino'], $clienteDestinoDB)  )
            {
                array_push($actualizarArray, array('cdd_id_coe'=>8, 'cdd_id'=>$cdrFila['cdd_id']));
                continue;
            }
            
            foreach ($tarifasPromoPlan as $key2 => $tarifaFila){
                $codigoError = 0;
                
                if($cdrFila['cdd_numero_origen'] == $tarifaFila['txs_numero'] && empty($tarifaFila['ppa_desde_codigo']))
                {
                    $codigoError = (isset($tarifaFila['pln_id']) && $tarifaFila['pln_estado']==1)? 8: 5;
                }
                
                if($codigoError==0 && $cdrFila['cdd_numero_origen'] == $tarifaFila['txs_numero'] && $cdrFila['cdd_destino'] == $tarifaFila['ppa_desde_codigo'])
                  {
                    // Verificar si el plan estaba vigente en la fecha de la llamada
                    if( $cdrFila['cdd_fecha_inicio'] >= $tarifaFila['pxl_fecha_inicio'] && $cdrFila['cdd_fecha_inicio'] <= $tarifaFila['pxl_fecha_fin'] ){

                        $codigoError = (isset($tarifaFila['pln_id']) && $tarifaFila['pln_estado']==0)? 5: 0;

                        // Verificar si la tarifa esta vigente
                        if( $codigoError==0 && $cdrFila['cdd_fecha_inicio'] >= $tarifaFila['trf_desde'] && ( empty($tarifaFila['trf_hasta']) || ( !empty($tarifaFila['trf_hasta']) && date('Y-m-d', strtotime($tarifaFila['trf_hasta'])) >= date('Y-m-d', strtotime($cdrFila['cdd_fecha_inicio'])) ) )){   

                            $codigoError = (isset($tarifaFila['trf_id']) && $tarifaFila['trf_estado']==0 )? 7: 0;

                        } else {
                            $codigoError = (!isset($tarifaFila['trf_id']))? 8: 0;
                        }
                    } else {
                        $codigoError = (!isset($tarifaFila['pln_id']))? 6: 0;
                    }
                 }

                if($codigoError) {array_push($actualizarArray, array('cdd_id_coe'=>$codigoError, 'cdd_id'=>$cdrFila['cdd_id'])); break;};
            }
        }
        
        if(count($actualizarArray)>0){
            @$this->db->update_batch('cdd_cdr_detalle', $actualizarArray, 'cdd_id');    
        }
        
        /**
        * @author: Mario Marquez
        */
        //peticion ajax
        if($_POST){
            //obtengo los registros en base al rango de fecha
            $where = array('cdd_fecha_inicio >= '=>$fecha_inicio, 'cdd_fecha_inicio <='=>date('Y-m-d 23:59:59', strtotime($fecha_fin)),'cdd_procesado'=>1,'cdr_estado'=>1,'cdr_procesado'=>1);
            if($numero_principal>=0 && $numero_principal!=''){
                $where['cdd_numero_origen']=$numero_principal;
            }
            
            $detalle = $this->tarificador_model->getTarifasCdrActivo($where);

            //Obtener los registros que no fueron procesados
            $where_no = array('cdd_fecha_inicio >= '=>$fecha_inicio, 'cdd_fecha_inicio <='=>date('Y-m-d 23:59:59', strtotime($fecha_fin)),'cdd_procesado'=>0,'cdr_estado'=>1,'cdr_procesado'=>1);
            if($numero_principal>=0 && !is_null($numero_principal)){
                $where_no['cdd_numero_origen']=$numero_principal;
            }
            
            $llamanas_no_procesadas = $this->tarificador_model->getTarifasCdrActivo($where_no);
            
            $cadena='';

            if (!empty($detalle)) {

                foreach ($detalle as $key => $det) {
                    $detalle_costo = (json_decode($det['cdd_detalle_costo_factura']!=NULL))? implode(', ', json_decode($det['cdd_detalle_costo_factura'])): '$'.$det['cdd_costo_unit'];
                    
                    $cadena.="<tr>";
                    $cadena.="<td>".$det['cdd_numero_origen']."</td>";
                    $cadena.="<td>".$det['cdd_numero_destino']."</td>";
                    $cadena.="<td>".date('d-m-Y', strtotime($det['cdd_fecha_inicio']))."</td>";
                    $cadena.="<td>".date('H:i:s', strtotime($det['cdd_fecha_inicio']))."</td>";
                    $cadena.="<td>".$det['cdd_duracion_min']."</td>";
                    $cadena.="<td>".$detalle_costo."</td>";
                    $cadena.="<td>$".$det['cdd_costo_total']."</td>";
                    $cadena.='<td><div class="tools">
                                              <div class="btn-group"> 
                                                <button  type="button" class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button> 
                                                <button type="button" class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button> 
                                                 <ul class="dropdown-menu"> 
                                                  <li style="text-align:left;">  
                                                    <a href="'.  base_url('tarificador/procesos/getDetalleCosto/'.$det['cdd_id']).'" title="Detalle de la llamada" id="ver_'.$key.'"  class="ver_en_modal_ctel" data-contador="'.$key.'" fila="DH'.$key.'" >
                                                    <span class="icomoon-icon-search-5" data-original-title="Detalle de la llamada"></span>Detalle
                                                    </a>
                                                  </li>';
                    $cadena.=" </ul></div></div></td>";
                    $cadena.='</tr>';
                }
                $arreglo=array('drop'=>$cadena);
            } 
            
            if(!empty($llamanas_no_procesadas)){
                foreach ($llamanas_no_procesadas as $key => $det) {
                    $detalle_costo = (json_decode($det['cdd_detalle_costo_factura']!=NULL))? implode(', ', json_decode($det['cdd_detalle_costo_factura'])): '$'.$det['cdd_costo_unit'];
                    
                    $cadena.="<tr style='background-color: rgb(242, 161, 161);' >";
                    $cadena.="<td>".$det['cdd_numero_origen']."</td>";
                    $cadena.="<td>".$det['cdd_numero_destino']."</td>";
                    $cadena.="<td>".date('d-m-Y', strtotime($det['cdd_fecha_inicio']))."</td>";
                    $cadena.="<td>".date('H:i:s', strtotime($det['cdd_fecha_inicio']))."</td>";
                    $cadena.="<td>".$det['cdd_duracion_min']."</td>";
                    $cadena.="<td>".$detalle_costo."</td>";
                    $cadena.="<td>$".$det['cdd_costo_total']."</td>";
                    $cadena.='<td><div class="tools">
                                              <div class="btn-group"> 
                                                <button  type="button" class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button> 
                                                <button type="button" class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button> 
                                                 <ul class="dropdown-menu"> 
                                                  <li style="text-align:left;">  
                                                    <a href="'.base_url('tarificador/procesos/getDetalleCosto/'.$det['cdd_id']).'" title="Ver" id="ver_'.$key.'"  class="ver_en_modal_ctel" data-contador="'.$key.'" fila="DH'.$key.'" >
                                                    <span class="icomoon-icon-search-5" data-original-title="Detalle de la llamada"></span>Detalle
                                                    </a>
                                                  </li>';
                    $cadena.=" </ul></div></div></td>";
                    $cadena.='</tr>';
                }
                $arreglo=array('drop'=>$cadena);
            }
            if(empty($cadena))
                $arreglo=array('drop'=>"<tr><td colspan='8'>No se encontraron datos</td></tr>",'ninguno'=>1);
            
            echo json_encode($arreglo);
        }
        
   }// End calcular_costo_llamada
   
   function getDetalleCosto($cddId)
   {
       $data['detalle_llamada'] = $this->tarificador_model->getDetalleCosto(array('cdd_id'=>$cddId));
       $this->gsatelite->cargar_vista_masterpage('tarificador/procesos/tabla_detalle_llamada', $data);
   }

   function cargo_adicional($id_sxc=null){
        satelite_validar();

            $fijo=$this->gsatelite->get_parametro('SYS_CARGO_FIJO');
            $consumo=$this->gsatelite->get_parametro('SYS_CARGO_CONSUMO');
            $info=$this->tarificador_model->get_info_cargos($id_sxc);
             $data['info']=$info;
            $data['id_sxc']=$info[0]['sxc_id'];
            $data['infoxfac']=$this->tarificador_model->get_info_cargoxfac($id_sxc, $fijo, $consumo);
            //die(print_r($data['infoxfac']));
            $data['titulo_personal']='Cargos adicionales por cliente';
            $this->_cargarvista($data);  
    }

    function nuevo_cargo($id_sxc=null){
       satelite_validar();
        if($_POST){
            $fecha=date('Y-m-d', strtotime($this->input->post('fecha_contrato')));
            $costo=$this->input->post('costo');
            $array_caf=array(
                'caf_id_sxc'=>$this->input->post('id_sxc'),
                'caf_id_tcs'=>$this->input->post('cargo'),
                'caf_fecha'=>$fecha,
                'caf_valor'=>number_format($costo,2),
                'caf_estado'=>1,
                'caf_fecha_crea'=>date('Y-m-d H:i:s'),
                'caf_fecha_mod'=>date('Y-m-d H:i:s'),
                'caf_usu_crea'=>$this->tank_auth->get_user_id(),
                'caf_usu_mod'=>$this->tank_auth->get_user_id(),
                'caf_impuesto'=>0,
                'caf_subtotal'=>number_format($costo,2),
                'caf_nombre'=>'',
                'caf_sistema'=>0
                );
            $caf=$this->gsatelite->ingresar('caf_cargo_facturacion', $array_caf);

            if($caf>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Cargos adicionales por cliente",'texto_alerta'=>"Registro(s) ingresado(s) con éxito");
            }else{
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Cargos adicionales por cliente",'texto_alerta'=>"Ocurrió un error al ingresar la información");
            }
             $this->session->set_flashdata($alerta);
            $sxc=$this->input->post('id_sxc');
            $boton=$this->input->post('boton');
            if ($boton =='2') {
                redirect('tarificador/procesos/cargo_adicional/'.$sxc);
            }else if($boton == '1'){ 
                redirect('tarificador/procesos/nuevo_cargo/'.$sxc);
            }

        }else{
            if($id_sxc != null){
                $data['id_sxc']=$id_sxc;
            }
            $select=$this->gsatelite->get_dropdown('tcs_tipo_cargo_servicio', 'tcs_nombre','', array('tcs_estado'=>1), null, '','tcs_id', true);
            $data['cargos'] = str_replace('<option value="0">Seleccione</option>', '',$select);
            $data['titulo_personal']='Cargos adicionales';
            $this->_cargarvista($data);
        } 
    }

    function get_cargo_costo()
    {
        $cargo=$this->input->post('id_cargo');

        $costo=(float)$this->gsatelite->get_campo('tcs_tipo_cargo_servicio', 'tcs_valor', array('tcs_id'=>$cargo));
        echo json_encode($costo);
    }

    function eliminar_cargo_cliente($caf_id=null)
    {
        satelite_validar();

            $sxc_id=$this->gsatelite->get_campo('caf_cargo_facturacion', 'caf_id_sxc', array('caf_id' =>$caf_id));

        if($caf_id>0){
            $cxs=$this->gsatelite->get_campo('cxs_cargoxfacturacion_serv', 'cxs_id_caf', array('cxs_id_caf'=>$caf_id));
            //die(print_r($cxs));
            if($cxs<=0 || $cxs == ''){

                $ixg=$this->gsatelite->get_campo('ixg_impuestoxcargo', 'ixg_id_caf', array('ixg_id_caf'=>$caf_id));
                if($ixg<=0 || $ixg == '') {
                    $del=$this->gsatelite->borrado_general('caf_cargo_facturacion',array('caf_id'=>$caf_id));    
                }
            }
        }

       if($del>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Cargo adicional por cliente",'texto_alerta'=>"El cargo para este cliente ha sido eliminado");
            }else if($cxs>0 || $cxs != ''){
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"NOTA",'texto_alerta'=>"El registro posee integridad referencial <br />&nbsp;No podrá ser eliminado.");
            }
            else{
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Cargo adicional por cliente",'texto_alerta'=>"Ocurrió un error al eliminar el cargo adicional");
            }
            $this->session->set_flashdata($alerta);
                    
                    
            redirect('tarificador/procesos/cargo_adicional/'.$sxc_id);

    }
  
    function editar_cargo($id_sxc=null, $id_caf=null)
    {
       satelite_validar();
        if($_POST){
            $fecha=date('Y-m-d', strtotime($this->input->post('fecha_contrato')));
            $costo=$this->input->post('costo');
            $array_caf=array(
                'caf_id_sxc'=>$this->input->post('id_sxc'),
                'caf_id_tcs'=>$this->input->post('cargo'),
                'caf_fecha'=>$fecha,
                'caf_valor'=>number_format($costo,2),
                'caf_estado'=>($this->input->post('estado')==1)?$this->input->post('estado'):0,
                'caf_fecha_crea'=>date('Y-m-d H:i:s'),
                'caf_fecha_mod'=>date('Y-m-d H:i:s'),
                'caf_usu_crea'=>$this->tank_auth->get_user_id(),
                'caf_usu_mod'=>$this->tank_auth->get_user_id()
                );
            $caf_edit=$this->gsatelite->actualizar_array('caf_cargo_facturacion', $array_caf, array('caf_id'=>$id_caf));

            if($caf_edit>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Cargos adicionales por cliente",'texto_alerta'=>"Registro(s) ingresado(s) con éxito");
            }else{
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Cargos adicionales por cliente",'texto_alerta'=>"Ocurrió un error al ingresar la información");
            }
             $this->session->set_flashdata($alerta);
            $sxc=$this->input->post('id_sxc');
            $caf=$this->input->post('id_caf');
            $boton=$this->input->post('boton');
            if ($boton =='2') {
                redirect('tarificador/procesos/cargo_adicional/'.$sxc);
            }else if($boton == '1'){ 
                redirect('tarificador/procesos/editar_cargo/'.$sxc.'/'.$caf);
            }

        }else{
            if($id_sxc != null){
                $data['id_sxc']=$id_sxc;
            }
            if($id_caf != null){
                $data['id_caf']=$id_caf;
                $datos=$this->gsatelite->get_tabla('caf_cargo_facturacion', array('caf_id'=>$id_caf));
                $data['datos']=$datos[0];
            }
            $select=$this->gsatelite->get_dropdown('tcs_tipo_cargo_servicio', 'tcs_nombre','', array('tcs_estado'=>1), $datos[0]['caf_id_tcs'], '','tcs_id', true);
            $data['cargos'] = str_replace('<option value="0">Seleccione</option>', '',$select);

            $data['titulo_personal']='Cargos adicionales';
            $this->_cargarvista($data);
        } 
    }

    function costeo_llamadas(){
        satelite_validar();
                                //$tde_id=$this->gsatelite->get_parametro('SYS_TIPO_DOC');
                                //$this->db->join('dcc_documento_cliente', 'dcc_id_cli=cli_id AND dcc_id_tde='.$tde_id.'', 'left');
        $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', array('cli_estado'=>1), null, '', 'cli_id', true);
        $data['titulo_personal'] = 'Costeo de llamadas';
        $this->_cargarvista($data);
    }

    function catalogo_servicios(){
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->catalogo_servicios();
    }

    function buscar_destino()
    {    
        $prefijo = $this->input->post('buscar');
        $resultado = $this->tarificador_model->get_codigo_paises($prefijo);
        echo json_encode($resultado);
    }

    public function check_codigo_cliente($cod=null,$alm_id=0){

        if($_POST){
            $cod = $this->input->post('codigo');  
            $cli_id = $this->input->post('cli');   
        }

       // if($cod!='' && $cod!=null) {
            
            if($cli_id!=0){
                $result = $this->gsatelite->get_tabla('cli_cliente',array('cli_codigo'=>$cod,'cli_id <>'=>$cli_id));
            }else{
                $result = $this->gsatelite->get_tabla('cli_cliente',array('cli_codigo'=>$cod));    
            }
           
            if(count($result)>0) {
                print json_encode(
                       array('exists'  => true )
                );
            }

            else {
                print json_encode(
                    array('exists'  => false)   
                );
            }
        //}
    }

    function financiamiento(){
        //satelite_validar(false);

        $listado_planes = $this->tarificador_model->get_listado_planes_pago();

        $data['listado_planes'] = $listado_planes;

        $data['titulo_personal'] = 'Planes de pago';

        $this->_cargarvista($data);
    }

    function agregar_financiamiento(){
        satelite_validar();


        if($_POST){
            //die(var_dump($_POST));

            $facturas = $this->input->post('facturas');
            $tipo_btn = $this->input->post('tipo_btn');

            $monto_deuda = $this->input->post('monto_deuda');

            $num_cuotas = $this->input->post('num_cuotas');
            $total_cuotas = count($num_cuotas);
            $vencimientos = $this->input->post('vencimientos');
            $impuestos = $this->input->post('impuestos');
            $montos = $this->input->post('montos');
            $totales = $this->input->post('totales');
            $observacion = $this->input->post('observacion');
            $fecha_plan = date('Y-m-d',strtotime($this->input->post('fecha_plan')));
            
            // $cpl_array = array();
            // for ($i=0; $i < count($num_cuotas); $i++) { 

            //     $fecha = date('Y-m-d',strtotime($vencimientos[$i]));

            //     $cpl_array[] = $fecha;

            //     //$cpl_ids[] = $this->gsatelite->ingresar('cpl_cuota_plan_pago',$cpl_array);
            // }
            // var_dump($vencimientos);
            // die(var_dump($cpl_array));

            $plan_array = array(
                'plg_numero' =>1,
                'plg_monto_deuda'=>floatval($monto_deuda),
                'plg_cuotas' => $total_cuotas,
                'plg_fecha_plan' => $fecha_plan,
                'plg_fecha_primera_cuota' => date('Y-m-d',strtotime($vencimientos[0])),
                'plg_observacion' => $observacion,
                'plg_estado' => 1,
                'plg_fecha_crea' => date('Y-m-d H:i:s'),
                'plg_fecha_mod' => date('Y-m-d H:i:s'),
                'plg_usu_crea' => $this->tank_auth->get_user_id(),
                'plg_user_mod' => $this->tank_auth->get_user_id(),
            );

            $plan_id = $this->gsatelite->ingresar('plg_plan_pago',$plan_array);
            
            $fxs_ids = array();
            //INGRESAR FxP
            $total_impuestos = array_sum($impuestos);
            for ($i=0; $i < count($facturas); $i++) { 
                // Calculamos el porcentaje de cada factura contra el total de la deuda
                $total_factura = $this->gsatelite->get_campo('fac_factura','fac_total', array('fac_id'=>$facturas[$i]));
                $total_factura = ($total_impuestos>0)? floatval($total_factura) + floatval($total_impuestos / count($facturas)): $total_factura;
                $porcentaje_por_factura = floatval($total_factura)/floatval($monto_deuda);
                
                $fxp_array = array(
                    'fxp_id_fac' => $facturas[$i],
                    'fxp_id_plg' => $plan_id,
                    'fxp_porcentaje' => round($porcentaje_por_factura,2),
                    'fxp_estado' => 1,
                    'fxp_fecha_mod' => date('Y-m-d H:i:s'),
                    'fxp_fecha_crea' => date('Y-m-d H:i:s'),
                    'fxp_usu_crea' => $this->tank_auth->get_user_id(),
                    'fxp_user_mod' => $this->tank_auth->get_user_id(),
                );

                $fxs_ids[] = $this->gsatelite->ingresar('fxp_facturaxplan_pago',$fxp_array);
            }

            //INGRESAR CUOTAS
            $cpl_ids = array();
            //INGRESAR FxP
            for ($i=0; $i < count($num_cuotas); $i++) { 

                $fecha = date('Y-m-d',strtotime($vencimientos[$i]));

                $cpl_array = array(
                    'cpl_id_plg' => $plan_id,
                    'cpl_numero'=>$num_cuotas[$i],
                    'cpl_monto' => $montos[$i],
                    'cpl_interes' => ($impuestos[$i]!='') ?$impuestos[$i] : 0,
                    'cpl_total' => $totales[$i],
                    'cpl_fecha_vencimiento' => $fecha,
                    'cpl_estado' => 1,
                    'cpl_fecha_mod' => date('Y-m-d H:i:s'),
                    'cpl_fecha_crea' => date('Y-m-d H:i:s'),
                    'cpl_usu_crea' => $this->tank_auth->get_user_id(),
                    'cpl_user_mod' => $this->tank_auth->get_user_id(),
                );

                $cpl_ids[] = $this->gsatelite->ingresar('cpl_cuota_plan_pago',$cpl_array);
            }


            if($plan_id>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Procesado",'texto_alerta'=>"Registro(s) ingresado(s) con éxito");
            }else{
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error",'texto_alerta'=>"Ocurrió un error al ingresar la información");
            }
            
            $this->session->set_flashdata($alerta);

            if ($tipo_btn =='2') {
                redirect('tarificador/procesos/financiamiento');
            }else{ 
                redirect('tarificador/procesos/agregar_financiamiento');
            }

        }

        $data['titulo_personal']  = 'Financiamiento';
        $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', array('cli_estado'=>1), null, '', 'cli_id', true);

        $interes = $this->gsatelite->get_parametro('SYS_IMP_CUOTA');

        $data['max_cuotas'] = $this->gsatelite->get_parametro('SYS_NUM_MAX_CUOTA');

        $interes = $interes/100;

        $data['interes'] = $interes;

        $this->_cargarvista($data);
    }

    function editar_financiamiento($plg_id=null,$pagadas=0){
        satelite_validar();

        if($plg_id==null) { redirect('tarificador/procesos/financiamiento'); }
        if($_POST){
            //die(var_dump($_POST));

            $facturas = $this->input->post('facturas');
            $tipo_btn = $this->input->post('tipo_btn');

            $monto_deuda = $this->input->post('monto_deuda');

            $num_cuotas = $this->input->post('num_cuotas');
            
            $total_cuotas = (count($num_cuotas)>0) ? count($num_cuotas) : $this->input->post('cuotas_total');

            $vencimientos = $this->input->post('vencimientos');
            $impuestos = $this->input->post('impuestos');
            $montos = $this->input->post('montos');
            $totales = $this->input->post('totales');
            $observacion = $this->input->post('observacion');
            $fecha_plan = date('Y-m-d',strtotime($this->input->post('fecha_plan')));

            $plan_array = array(
                'plg_monto_deuda'=>floatval($monto_deuda),
                'plg_cuotas' => $total_cuotas,
                'plg_fecha_plan' => $fecha_plan,
                'plg_fecha_primera_cuota' => date('Y-m-d',strtotime($vencimientos[0])),
                'plg_observacion' => $observacion,
                'plg_estado' => 1,
                'plg_fecha_crea' => date('Y-m-d H:i:s'),
                'plg_fecha_mod' => date('Y-m-d H:i:s'),
                'plg_usu_crea' => $this->tank_auth->get_user_id(),
                'plg_user_mod' => $this->tank_auth->get_user_id(),
            );

            $result = $this->gsatelite->actualizar_array('plg_plan_pago',$plan_array,array('plg_id'=>$plg_id));

            $total_impuestos = array_sum($impuestos);
            if(count($facturas)>0 && $facturas!=''){
                $fxs_ids = array();
                //INGRESAR FxP
                for ($i=0; $i < count($facturas); $i++) { 

                    // Calculamos el porcentaje de cada factura contra el total de la deuda
                $total_factura = $this->gsatelite->get_campo('fac_factura','fac_total', array('fac_id'=>$facturas[$i]));
                $total_factura = ($total_impuestos>0)? floatval($total_factura) + floatval($total_impuestos / count($facturas)): $total_factura;
                $porcentaje_por_factura = floatval($total_factura)/floatval($monto_deuda);

                    $fxp_array = array(
                        'fxp_id_fac' => $facturas[$i],
                        'fxp_id_plg' => $plg_id,
                        'fxp_porcentaje' => round($porcentaje_por_factura,2),
                        'fxp_estado' => 1,
                        'fxp_fecha_mod' => date('Y-m-d H:i:s'),
                        'fxp_fecha_crea' => date('Y-m-d H:i:s'),
                        'fxp_usu_crea' => $this->tank_auth->get_user_id(),
                        'fxp_user_mod' => $this->tank_auth->get_user_id(),
                        );

                    $fxs_ids[] = $this->gsatelite->ingresar('fxp_facturaxplan_pago',$fxp_array);
                } 
            } 

            if(count($num_cuotas)>0 && $num_cuotas!=''){
            //INGRESAR CUOTAS
                $cpl_ids = array();
            //INGRESAR FxP
                for ($i=0; $i < count($num_cuotas); $i++) { 

                    $fecha = date('Y-m-d',strtotime($vencimientos[$i]));

                    $cpl_array = array(
                        'cpl_id_plg' => $plg_id,
                        'cpl_numero'=>$num_cuotas[$i],
                        'cpl_monto' => $montos[$i],
                        'cpl_interes' => ($impuestos[$i]!='') ?$impuestos[$i] : 0,
                        'cpl_total' => $totales[$i],
                        'cpl_fecha_vencimiento' => $fecha,
                        'cpl_estado' => 1,
                        'cpl_fecha_mod' => date('Y-m-d H:i:s'),
                        'cpl_fecha_crea' => date('Y-m-d H:i:s'),
                        'cpl_usu_crea' => $this->tank_auth->get_user_id(),
                        'cpl_user_mod' => $this->tank_auth->get_user_id(),
                        );

                    $cpl_ids[] = $this->gsatelite->ingresar('cpl_cuota_plan_pago',$cpl_array);
                }
            }

            if($result>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Procesado",'texto_alerta'=>"Registro(s) actualizado(s) con éxito");
            }else{
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error",'texto_alerta'=>"Ocurrió un error al actualizar la información");
            }
            
            $this->session->set_flashdata($alerta);

            if ($tipo_btn =='2') {
                redirect('tarificador/procesos/financiamiento');
            }else{ 
                redirect('tarificador/procesos/editar_financiamiento/'.$plg_id);
            }

        }

        $data['titulo_personal']  = 'Financiamiento';

        $facxplan = $this->tarificador_model->get_facturas_plan_pago(array('plg_id'=>$plg_id));
        $cliente_id = $facxplan[0]['cli_id'];
        $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', array('cli_estado'=>1), $cliente_id, '', 'cli_id', true);

        $data['facturas'] = $this->cargar_facturas($cliente_id);

        $data['facxplan'] = $facxplan;

        $data['cuotas_plan'] = $this->tarificador_model->get_cuotas_plan_pago(array('plg_id'=>$plg_id));
        $data['plg_id'] = $plg_id;

        $interes = $this->gsatelite->get_parametro('SYS_IMP_CUOTA');

        $data['max_cuotas'] = intval($this->gsatelite->get_parametro('SYS_NUM_MAX_CUOTA'));
        $data['pagadas'] = $pagadas;
        $interes = $interes/100;

        $data['interes'] = $interes;

        $this->_cargarvista($data);
    }

    public function cargar_facturas($cli_id=0){

        if($_POST){
            $cli_id = $this->input->post('cli');   
        }

        $listado = $this->tarificador_model->get_facturas_cliente(array('sxc_id_cli'=>$cli_id,'fac_estado'=>1));
        

        $opciones = "<option value='0'>Seleccione</option>";

        if(count($listado)>0){
            foreach ($listado as $list){

                $periodo = date('d-m-Y',strtotime($list['fxs_fecha_inicio'])).' - '.date('d-m-Y',strtotime($list['fxs_fecha_fin']));
                $fecha_ven = date('d-m-Y',strtotime($list['fac_fecha_vencimiento']));
                $nombre_fac = $list['fac_numero'].' Monto $'.$list['fac_total'].' Vence '.$fecha_ven;

                $opciones.='<option value="'.$list['fac_id'].'" data-servicio="'.$list['src_nombre'].'" data-num_fac="'.$list['fac_numero'].'" data-periodo="'.$periodo.'" data-total="'.$list['fac_total'].'" data-estado="'.$list['fac_estado'].'">'.$nombre_fac.'</option>';
            }
        }

        if($_POST){
            echo $opciones;    
        }
        else{
            return $opciones;
        }        
    }

    public function cargar_planes($cli_id=0){

        if($_POST){
            $cli_id = $this->input->post('cli');   
        }

        $this->db->group_by('plg_id');
        $listado = $this->tarificador_model->get_facturas_plan_pago(array('cli_id'=>$cli_id));
        

        $opciones = "<option value='0'>Seleccione</option>";

        if(count($listado)>0){
            foreach ($listado as $list){

                $fecha_plan =  date('d-m-Y',strtotime($list['plg_fecha_plan']));

                $nombre_plan = "Plan - ".$list['plg_id']." - Monto ".$list['plg_monto_deuda']." Cuotas ".$list['plg_cuotas']." ".$fecha_plan
                ;

                $opciones.='<option value="'.$list['plg_id'].'">'.$nombre_plan.'</option>';
            }
        }

        if($_POST){
            echo $opciones;    
        }
        else{
            return $opciones;
        }        
    }

    function e_registros_plan_pago($plan=null){
        if (!$this->tank_auth->is_logged_in()) {
          redirect('/auth/login/');
        }
        else{
            if($_POST){

                $factura = $this->input->post('factura');
                $plan = $this->input->post('plan');
                if($factura>0){
                    $where_fxp = array('fxp_id_fac'=>$factura,'fxp_id_plg'=>$plan);

                    $result = $this->gsatelite->borrado_general('fxp_facturaxplan_pago',$where_fxp);    
                }
                
                $where_cpl = array('cpl_id_plg'=>$plan);
                $result = $this->gsatelite->borrado_general('cpl_cuota_plan_pago',$where_cpl);

                echo $result;
            }
            else{
                if($plan!=null){
                    $where_fxp = array('fxp_id_plg'=>$plan);

                    $result = $this->gsatelite->borrado_general('fxp_facturaxplan_pago',$where_fxp);    
                
                    $where_cpl = array('cpl_id_plg'=>$plan);
                    $result = $this->gsatelite->borrado_general('cpl_cuota_plan_pago',$where_cpl);

                    $result = $this->gsatelite->borrado_general('plg_plan_pago',array('plg_id'=>$plan));

                    if($result>0){
                        $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Procesado",'texto_alerta'=>"Registro(s) eliminado(s) con éxito");
                    }else{
                        $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error",'texto_alerta'=>"Ocurrió un error al eliminar la información");
                    }

                    $this->session->set_flashdata($alerta);
                    redirect('tarificador/procesos/financiamiento');
                }
            }
        }
    }

    function agregar_plan()
    {
        if($_POST){
            //die(print_r($_POST,true));
            $temp_array = array(
              'pln_nombre'  =>  (!empty($_POST['nombre']))? $_POST['nombre']:NULL,
              'pln_minuto'  =>  (($_POST['minutos'])!='')? $_POST['minutos']:NULL,
              'pln_costo'   =>  (!empty($_POST['costo']))? $_POST['costo']:NULL,
              'pln_desde'   =>  date('Y-m-d', strtotime($_POST['fecha_desde'])),
              'pln_hasta'   =>  date('Y-m-d', strtotime($_POST['fecha_hasta'])),
              'pln_tipo'    =>  $this->input->post('tipo'),
              'pln_id_src'  =>  (!empty($_POST['servicio']))? $this->input->post('servicio'):NULL,  
              'pln_estado'  =>  1,
              'pln_fecha_crea'  => date('Y-m-d H:i:s'),
              'pln_fecha_mod'   => date('Y-m-d H:i:s'),
              'pln_usu_crea'    => $this->tank_auth->get_user_id(),
              'pln_usu_mod'     => $this->tank_auth->get_user_id()
            );
            
            $id_plan = $this->gsatelite->ingresar('pln_plan_promocion', $temp_array);
            
            if($id_plan>0){
                $codigos = explode(',', $this->input->post('codigos_aplica'));
                
                $this->gsatelite->borrado_general('pxp_parametro_paixplan', array('pxp_id_pln' => $id_plan));
                foreach ($codigos as $key => $value)
                {
                    if(!empty($value)){
                        $temp_array_codigos = array(
                          'pxp_id_ppa'  =>  $value,
                          'pxp_id_pln'  =>  $id_plan,
                          'pxp_estado'  =>  1,
                          'pxp_fecha_mod'   => date('Y-m-d H:i:s'),
                          'pxp_fecha_crea'  => date('Y-m-d H:i:s'), 
                          'pxp_usu_crea'    => $this->tank_auth->get_user_id(),
                          'pxp_usu_mod'     => $this->tank_auth->get_user_id(),
                        );
                        $this->gsatelite->ingresar('pxp_parametro_paixplan', $temp_array_codigos);
                    }
                }
                $enviar = ($_POST['volver'])? "planes":'agregar_plan';
                $this->gsatelite->show_dialog('Registro ingresado exitosamente', "tarificador/procesos/$enviar", 'success');
            } else {
                $this->gsatelite->show_dialog('No se pudo guardar el registro', 'tarificador/procesos/planes', 'error');
            }
         
        } else {
            $data['servicios'] = $this->gsatelite->get_dropdown('src_servicio', 'src_nombre', '', array('src_estado' => 1), null, '', 'src_id', true);
            
            $data['titulo_personal'] = "Planes/Promociones";
            $this->_cargarvista($data);
        }
    } // End of agregar_plan

    function editar_plan($id_plan=NULL)
    {
        satelite_validar();
        if($_POST){
            
            $temp_array = array(
              'pln_nombre'  =>  (!empty($_POST['nombre']))? $_POST['nombre']:NULL,
              'pln_minuto'  =>  (($_POST['minutos'])!='')? $_POST['minutos']:NULL,
              'pln_costo'   =>  (!empty($_POST['costo']))? $_POST['costo']:NULL,
              'pln_desde'   =>  date('Y-m-d', strtotime($_POST['fecha_desde'])),
              'pln_hasta'   =>  date('Y-m-d', strtotime($_POST['fecha_hasta'])),
              'pln_tipo'    =>  $this->input->post('tipo'),
              'pln_id_src'  =>  (!empty($_POST['servicio']))? $this->input->post('servicio'):NULL,  
              'pln_estado'  =>  (!empty($_POST['estado']))? $_POST['estado']:1,
              'pln_fecha_mod'   => date('Y-m-d H:i:s'),
              'pln_usu_mod'     => $this->tank_auth->get_user_id()
            );
            
            $id_plan = $this->gsatelite->actualizar_array('pln_plan_promocion', $temp_array, array('pln_id'=>$_POST['pln_id']));
            
            if($id_plan>0){
                $codigos = explode(',', $this->input->post('codigos_aplica'));
                
                $this->gsatelite->borrado_general('pxp_parametro_paixplan', array('pxp_id_pln' => $_POST['pln_id']));
                foreach ($codigos as $key => $value)
                {
                    if(!empty($value)){
                        $temp_array_codigos = array(
                          'pxp_id_ppa'  =>  $value,
                          'pxp_id_pln'  =>  $_POST['pln_id'],
                          'pxp_estado'  =>  1,
                          'pxp_fecha_mod'   => date('Y-m-d H:i:s'),
                          'pxp_fecha_crea'  => date('Y-m-d H:i:s'), 
                          'pxp_usu_crea'    => $this->tank_auth->get_user_id(),
                          'pxp_usu_mod'     => $this->tank_auth->get_user_id(),
                        );
                        $this->gsatelite->ingresar('pxp_parametro_paixplan', $temp_array_codigos);
                    }
                }
                $enviar = ($_POST['volver'])? 'planes':"editar_plan/".$_POST['pln_id'];
                $this->gsatelite->show_dialog('Registro editado con exito', "tarificador/procesos/$enviar", 'success');
            } else {
                $this->gsatelite->show_dialog('No se pudo editar el registro', 'tarificador/procesos/planes', 'error');
            }
            
        } else {
            $plan = $this->gsatelite->get_tabla('pln_plan_promocion', array('pln_id'=>$id_plan));
            $data['plan'] = $plan[0];
            $data['servicios'] = $this->gsatelite->get_dropdown('src_servicio', 'src_nombre', '', array('src_estado' => 1), (!empty($plan[0]['pln_id_src']))? $plan[0]['pln_id_src']:null , '', 'src_id', true);
            $data['codigos'] = $this->tarificador_model->get_codigos_llamada_gratis($id_plan);
            $data['titulo_personal'] = "Edición de Planes/Promociones";
            $this->_cargarvista($data);
        }
    }// End funcion editar_plan

    function get_planes()
    {
        $id_src=$this->input->post('id_src');
        $planes=$this->gsatelite->get_tabla('pln_plan_promocion', array('pln_id_src'=>$id_src, 'pln_estado'=>1));
        $options='<option value="0">Seleccione</option>';
        foreach ($planes as $pln => $value) {
            $options.='<option value="'.$value['pln_id'].'">'.$value['pln_nombre'].'</option>';
        }
       
       echo json_encode($options);
    }

    public function _cambiar_formato($value, $row){
        $acceso_formateado = null;

        if(!is_null($value)){
            $fecha = date('d-m-Y',strtotime($value));
            return $fecha;
        }
    }

    public function validar_telefono($telefono = null){
        if($_POST){
            $telefono = $this->input->post('num_telefono');
        }

        $where = array('txs_numero'=>$telefono);
        $count = $this->gsatelite->count('txs_telefonoxservicio',$where);

        if($_POST){
            if($count>0){
                echo json_encode(array('existe'=>1));
            }
            else{
                echo json_encode(array('existe'=>0));
            }
        }
        else{
            if($count>0){
                return true;
            }
            else{
                return false;
            }
        }
    }

    function _validar_tarifa($value, $row){

        $id=$row->trf_id;
        $hora=$row->trf_hasta_horario;
        $fecha_hasta=$row->trf_hasta;
        $fecha_campo=$this->gsatelite->get_campo('trf_tarifa', 'trf_hasta', array('trf_id'=>$id));
        $fecha=date('Y-m-d', strtotime($fecha_campo));
        $hoy=date('Y-m-d');
        $est=0;

        if(!empty($fecha_campo) && $fecha < $hoy){
            $est=$this->gsatelite->actualizar_array('trf_tarifa', array('trf_estado'=>0), array('trf_id'=>$id));
        }else if(!empty($fecha_campo) && $fecha == $hoy && date('H:i', strtotime($hora))<=date('H:i')){
            $est=$this->gsatelite->actualizar_array('trf_tarifa', array('trf_estado'=>0), array('trf_id'=>$id));  
        }
        $estado=$this->gsatelite->get_campo('trf_tarifa', 'trf_estado', array('trf_id'=>$id));

        if($estado==0){
            return "Inactivo"; 
        }else if($estado==1){
            return "Activo"; 
        }

    }

    function _cargarvista($data=0,$crud=0)
    {   
        $this->load->view('vacia',$crud);   
        if($data!=0)
            $data=array_merge($data,$this->masterpage->getUsuario());
        else
            $data=$this->masterpage->getUsuario();
        $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content',$data);
        $this->masterpage->show();
    }
}