<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Entradas extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('tarificador_model');
        $this->load->library('excel/excel_reader.php');
        //$this->load->library('../controllers/inventario/mantenimiento');
    }

    function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {            
            $data['titulo_personal']='Tarificador';
            $this->_cargarvista(null,$data);
        }
    }

    function paises(){
        satelite_validar();
        $this->load->library('../controllers/transporte/cruds');
        $this->cruds->pais();

        // $this->load->library('../controllers/inventario/mantenimiento');
        // satelite_validar();
        // $titulo="Productos y servicios";
        // $this->mantenimiento->articulo($titulo);
    }

    function codigo_paises($ppa_id=0, $codigo=0)
    {
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');

        satelite_validar();
        try{
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->limit(100);
            $crud->set_table('ppa_parametro_pais');
            $crud->set_relation('ppa_id_pai','pai_pais','{pai_nombre}',array('pai_estado'=>1));
            $crud->set_subject('Código de país');
            if($codigo>0){
                $crud->where("ppa_desde_codigo like '".$codigo."%'");
            }
            if($ppa_id>0){
                $crud->where('ppa_id',$ppa_id);
            }
            if($codigo==0 && $ppa_id==0){  $crud->where('ppa_id',$ppa_id); }

            $columnas = array(
                'ppa_id_pai',
                'ppa_nombre',
                'ppa_desde_codigo',
                'ppa_fecha_efectiva',
                'ppa_local',
                'ppa_comentario',

            );

            $required = array(
                'ppa_id_pai',
                'ppa_nombre',
                'ppa_desde_codigo',
                //'ppa_hasta_codigo',
                'ppa_fecha_efectiva',
                //'ppa_local',
                'ppa_estado',
                'ppa_usu_crea',
                'ppa_usu_mod',
                'ppa_fecha_crea',
                'ppa_fecha_mod',

            );

            $campos = array(
                'ppa_id_pai',
                'ppa_nombre',
                'ppa_desde_codigo',
                //'ppa_hasta_codigo',
                'ppa_fecha_efectiva',
                'ppa_local',
                'ppa_comentario',
                'ppa_estado',
                'ppa_usu_crea',
                'ppa_usu_mod',
                'ppa_fecha_crea',
                'ppa_fecha_mod',
            );

            $display_as = array(
                'ppa_id_pai' => 'Destino/País',
                'ppa_nombre'=>'Ruta destino',
                'ppa_desde_codigo' => 'Código desde',
                //'ppa_hasta_codigo' => 'Código hasta',
                'ppa_fecha_efectiva' => 'Fecha efectiva',
                'ppa_local' => 'Local',
                'ppa_comentario' => 'Comentarios',
                'ppa_estado'=>"Estado",
            );
            
            $crud->field_type('ppa_usu_crea', 'hidden',$this->tank_auth->get_user_id());
            $crud->field_type('ppa_usu_mod', 'hidden',$this->tank_auth->get_user_id());
            $crud->field_type('ppa_fecha_crea', 'hidden',date('Y-m-d H:i:s'));
            $crud->field_type('ppa_fecha_mod', 'hidden',date('Y-m-d H:i:s')); 
            $crud->set_rules('ppa_desde_codigo','Código desde','trim|required|campo_unico[ppa_parametro_pais.ppa_desde_codigo]');

            if(end(explode('/',uri_string()))=='add') {
                $crud->field_type('ppa_estado','hidden',1);
            }else {
                $crud->field_type('ppa_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if($ppa_id!=0){
                $data['pais'] = $this->gsatelite->get_tabla('ppa_parametro_pais', array('ppa_id'=>$ppa_id));
            }

            $crud->field_type('ppa_comentario','text','');

            $crud->set_rules('ppa_hasta_codigo','Código hasta','required|callback_validar_codigos_pais');

            $crud->callback_add_field('ppa_local',array($this,'_do_checkbox_grocery_add'));
            $crud->callback_edit_field('ppa_local',array($this,'_do_checkbox_grocery'));

            $crud->callback_column('ppa_local',function($value, $row){
                    if($value==1){
                        return "X";
                    }
                    else{
                        return '';
                    }
                }
            );
            $crud->callback_column('ppa_fecha_efectiva',function($value,$row){
                        $fecha=date('d-m-Y H:i', strtotime($value));
                          return $fecha; 
                       
                    });

            $crud->callback_before_insert(array($this,'_validar_codigos_pais'));

            $crud->required_fields($required);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            ini_set('memory_limit', '2048M');
            ini_set('max_execution_time', '9999');
            $output = $crud->render();
            $data['codigo']=$codigo;
            $data['titulo_personal']="Código de países";
            $this->_cargarvista($data, $output);

        }catch(Exception $e){
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }
    }

    function _do_checkbox_grocery($value, $row){
        $checked = ($value === '1') ? ' checked' : '';
        return '<div>
            <input type="hidden" id="field-ppa_local" name="ppa_local" value="'.$value.'" />
            <input type="checkbox" id="check_local" class="inline_checkbox" data-id="' . $row->id . '"' . $checked . '/></div>';
    }

    function _do_checkbox_grocery_add($value, $row){
        $checked = '';
        return '<div>
            <input type="hidden" id="field-ppa_local" name="ppa_local" value="0" />
            <input type="checkbox" id="check_local" class="inline_checkbox" data-id="' . $row->id . '"' . $checked . '/></div>';
    }

    function validar_codigos_pais(){

        $codigo_desde = $this->input->post('ppa_desde_codigo');
        $codigo_hasta = $this->input->post('ppa_hasta_codigo');

        if($codigo_hasta<$codigo_desde){
            $this->form_validation->set_message('validar_codigos_pais','El %s no puede ser menor al Código desde');
            return false;
        }
        return true;
    }

    function tipo_cliente()
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->tipo_cliente();
    }

    function tipo_pago()
    {
      satelite_validar();
      $this->load->library('../controllers/cotizaciones/mantenimientos');
      $this->mantenimientos->tipo_pago();   
    }
    function profesion()
    {
      satelite_validar();
      $this->load->library('../controllers/expediente_personal/catalogos');
      $this->catalogos->profesion();   
    }
    function periodo_contrato()
    {
        satelite_validar();

         try{
            // $permisos= $this->gsatelite->get_permisos_opcion('tipo_solicitud');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('pcn_periodo_contrato');
            $crud->set_subject('Período de contrato');
            
            $columnas = array(
                'pcn_nombre',
                'pcn_duracion',
                'pcn_estado'
            );

            $required = array(
                'pcn_nombre',
                'pcn_duracion',
                'pcn_estado'

            );

            $campos = array(
                'pcn_nombre',
                'pcn_duracion',
                'pcn_estado',
                'pcn_fecha_crea',
                'pcn_fecha_mod',
                'pcn_usu_crea',
                'pcn_usu_mod'
            );

            $display_as = array(
                'pcn_nombre'=>'Nombre',
                'pcn_duracion'=>'Duración',
                'pcn_estado'=>'Estado'
            );
            
            $crud->field_type('pcn_usu_crea', 'hidden',$this->tank_auth->get_user_id());
            $crud->field_type('pcn_usu_mod', 'hidden',$this->tank_auth->get_user_id());
            $crud->field_type('pcn_fecha_crea', 'hidden',date('Y-m-d H:i:s'));
            $crud->field_type('pcn_fecha_mod', 'hidden',date('Y-m-d H:i:s')); 

            if(end(explode('/',uri_string()))=='add') {
                $crud->field_type('pcn_estado','hidden',1);
            }else {
                $crud->field_type('pcn_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $crud->set_rules('pcn_nombre','Nombre','required|campo_unico[pcn_periodo_contrato.pcn_nombre]');
            $crud->set_rules('pcn_duracion','Duración', 'required|is_numeric');


            $crud->required_fields($required);
            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);

            $output = $crud->render();
            $data['titulo_personal']="Período de contrato";
            $this->_cargarvista($data, $output);

        }catch(Exception $e){
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }
    }
    function cargo_adicional()
    {
        satelite_validar();

         try{
            // $permisos= $this->gsatelite->get_permisos_opcion('tipo_solicitud');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->unset_delete();
            $crud->set_table('tcs_tipo_cargo_servicio');
            $crud->set_subject('Cargo de servicio');
            
            $columnas = array(
                'tcs_nombre',
                'tcs_valor',
                'tcs_estado'
            );

            $required = array(
                'tcs_nombre',
                'tcs_valor',
                'tcs_estado'

            );

            $campos = array(
                'tcs_nombre',
                'tcs_valor',
                'tcs_estado',
                'tcs_fecha_crea',
                'tcs_fecha_mod',
                'tcs_usu_crea',
                'tcs_usu_mod'
            );

            $display_as = array(
                'tcs_nombre'=>'Nombre',
                'tcs_valor'=>'Valor',
                'tcs_estado'=>'Estado'
            );
            
            $crud->field_type('tcs_usu_crea', 'hidden',$this->tank_auth->get_user_id());
            $crud->field_type('tcs_usu_mod', 'hidden',$this->tank_auth->get_user_id());
            $crud->field_type('tcs_fecha_crea', 'hidden',date('Y-m-d H:i:s'));
            $crud->field_type('tcs_fecha_mod', 'hidden',date('Y-m-d H:i:s')); 

            if(end(explode('/',uri_string()))=='add') {
                $crud->field_type('tcs_estado','hidden',1);
            }else {
                $crud->field_type('tcs_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $crud->set_rules('tcs_nombre','Nombre','required|campo_unico[tcs_tipo_cargo_servicio.tcs_nombre]');
            $crud->set_rules('tcs_valor','Valor', 'required|is_numeric');


            $crud->required_fields($required);
            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
            $crud->unset_delete();

            $output = $crud->render();
            $data['titulo_personal']="Cargo de servicio";
            $this->_cargarvista($data, $output);

        }catch(Exception $e){
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }

    }

    function tipo_servicio()
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->tipo_servicio();
    }

    function catalogo_servicios()
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->catalogo_servicios();
    }

    function giro_comercial(){
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->giro_comercial();
    }

    function condicion_pago(){
        satelite_validar();
        try{
            // $permisos= $this->gsatelite->get_permisos_opcion('tipo_solicitud');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('tpg_tipo_pago');
            $crud->set_subject('Condición');
            
            $columnas = array(
                'tpg_nombre',
                'tpg_estado'
            );

            $required = array(
                'tpg_nombre',
                'tpg_estado'
            );

            // $campos = array(
            //     'tif_nombre',
            //     'tif_abreviacion',
            //     'tif_estado',
            //     'tif_fecha_crea',
            //     'tif_fecha_mod',
            //     'tif_usu_crea',
            //     'tif_usu_mod'
            // );

            $display_as = array(
                'tpg_nombre'=>'Nombre',
                'tpg_estado'=>'Estado',
            );
            
            $crud->field_type('tpg_usu_crea', 'hidden',$this->tank_auth->get_user_id());
            $crud->field_type('tpg_usu_mod', 'hidden',$this->tank_auth->get_user_id());
            $crud->field_type('tpg_fecha_crea', 'hidden',date('Y-m-d H:i:s'));
            $crud->field_type('tpg_fecha_mod', 'hidden',date('Y-m-d H:i:s')); 

            if(end(explode('/',uri_string()))=='add') {
                $crud->field_type('tpg_estado','hidden',1);
            }else {
                $crud->field_type('tpg_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo','-1' => 'Eliminado'));
            }

            $crud->set_rules('tpg_nombre','Nombre','required|campo_unico[tpg_tipo_pago.tpg_nombre]');

            $crud->required_fields($required);
            $crud->columns($columnas);
            //$crud->fields($campos);
            $crud->display_as($display_as);

            $output = $crud->render();
            $data['titulo_personal']="Condición de Pago";
            $this->_cargarvista($data, $output);

        }catch(Exception $e){
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }
    }

    function tipo_comprobante(){
        satelite_validar();
        try{
            // $permisos= $this->gsatelite->get_permisos_opcion('tipo_solicitud');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('tif_tipo_factura');
            $crud->set_subject('Tipo de Comprobante');
            
            $columnas = array(
                'tif_nombre',
                'tif_abreviacion',
                'tif_estado'
            );

            $required = array(
                'tif_nombre',
                'tif_abreviacion',
                'tif_estado'
            );

            // $campos = array(
            //     'tif_nombre',
            //     'tif_abreviacion',
            //     'tif_estado',
            //     'tif_fecha_crea',
            //     'tif_fecha_mod',
            //     'tif_usu_crea',
            //     'tif_usu_mod'
            // );

            $display_as = array(
                'tif_nombre'=>'Nombre',
                'tif_abreviacion'=>'Abreviación',
                'tif_estado'=>'Estado',
            );
            
            $crud->field_type('tif_usu_crea', 'hidden',$this->tank_auth->get_user_id());
            $crud->field_type('tif_usu_mod', 'hidden',$this->tank_auth->get_user_id());
            $crud->field_type('tif_fecha_crea', 'hidden',date('Y-m-d H:i:s'));
            $crud->field_type('tif_fecha_mod', 'hidden',date('Y-m-d H:i:s')); 

            if(end(explode('/',uri_string()))=='add') {
                $crud->field_type('tif_estado','hidden',1);
            }else {
                $crud->field_type('tif_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $crud->set_rules('tif_nombre','Nombre','required|campo_unico[tif_tipo_factura.tif_nombre]');

            $crud->required_fields($required);
            $crud->columns($columnas);
            //$crud->fields($campos);
            $crud->display_as($display_as);

            $output = $crud->render();
            $data['titulo_personal']="Tipo de Comprobante";
            $this->_cargarvista($data, $output);

        }catch(Exception $e){
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }
    }

    function tipo_doc(){
        satelite_validar();
        $this->load->library('../controllers/sistema/catalogo');
        $this->catalogo->tipo_documento();
    }

        function importar_codigo_pais()
    {
        satelite_validar();
        if($_FILES) {
          
          $file = fopen($_FILES["excel_codigos"]["tmp_name"],"r");
          $cabezera = fgetcsv($file);
          $excel_data = '';
          
          if( count($cabezera)==5 ){
            
            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');  
            // Guardamos el archivo, para muestra del Usuario
            $carpeta_destino="uploads/archivos/erp_csv/codigo_paises.csv";
            @move_uploaded_file($_FILES["excel_codigos"]["tmp_name"], $carpeta_destino);

            $paises_array = array();
            while(! feof($file)) 
            {
               array_push($paises_array, fgetcsv($file)); 
            }
            
            $data['paises'] = $paises_array;
            $excel_data .='<center><h4>(<em>'. $_FILES["excel_codigos"]["name"] .'</em>)</h4></center><br/><center><h3>';
            $excel_data .=   $this->load->view('tarificador/entradas/tabla_codigo_paises', $data, true);

          } else {
                $excel_data .='<center><h4>(<em>'. $_FILES["excel_codigos"]["name"] .'</em>)</h4></center><br/><center><h3>';
                $excel_data .='La hoja actual no cumple con el formato de columnas</h3><br/>';
                $excel_data .='<h4>Favor revisar documento csv y cantidad de columas</h4></center><br/>';
          }
          fclose($file);
      
        $tabla_html =   $excel_data;
        echo json_encode(array('drop'=>$tabla_html));
   
        }
        else {
            $data['titulo_personal'] = "Cargar código de países";
            $this->_cargarvista($data,null);
        }
       
    }


    function procesar_codigo_paises()
    {
        satelite_validar();

        if($_POST){
            
            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');    
            $insertar_array = array();
            $codigo_paises = array();
            $paises    =   $this->input->post('pais');
            $paises_array = $this->tarificador_model->get_paises();
            
            // Buscar los codigos de los paises
            foreach ($paises as $buscar) {
                $indice = NULL;

                foreach ($paises_array as $pais_base) {
                    if( strtolower(str_replace(' ','', $pais_base->pai_nombre)) == strtolower(str_replace(' ', '', $buscar)) ){
                        $indice = $pais_base->pai_id;
                        break;    
                    }
                }
                
                if($indice != NULL){
                    array_push($codigo_paises, $indice);
                } else {
                    array_push($codigo_paises, 'NO');
                }
            }

            $codigo_nombre  =   $this->input->post('codigo_nombre');
            $codigo         =  $this->input->post('codigo');
            $fecha_efectiva =   $this->input->post('fecha_efectiva');
            $comentario     = $this->input->post('comentario');

            foreach ($codigo_paises as $key => $value) {

                if(!empty($value) && $value != 'NO'){
                    if(is_numeric($codigo[$key])){
                        $array_temp = array(
                            'ppa_id_pai'    =>  $value,
                            'ppa_nombre'    =>  $codigo_nombre[$key],
                            'ppa_desde_codigo'  => $codigo[$key],
                            'ppa_hasta_codigo'  => $codigo[$key],
                            'ppa_local'         => 0,
                            'ppa_comentario'    => $comentario[$key],
                            'ppa_fecha_efectiva'=> date('Y-m-d H:i:s', strtotime($fecha_efectiva[$key])),
                            'ppa_estado'        => 1,
                            'ppa_fecha_crea'    =>  date('Y-m-d H:i:s'),
                            'ppa_fecha_mod'     =>  date('Y-m-d H:i:s'),
                            'ppa_usu_crea'       => $this->tank_auth->get_user_id(),
                            'ppa_usu_mod'        => $this->tank_auth->get_user_id()
                            );

                        array_push($insertar_array, $array_temp);
                    }
                }   // End if
            } // End foreach

        if(count($insertar_array)>0){
           @$this->db->insert_batch('ppa_parametro_pais', $insertar_array);
           $this->gsatelite->show_dialog('Archivo guardado correctamente.','tarificador/entradas/importar_codigo_pais','success');
        } else {
            $this->gsatelite->show_dialog('No se pudo guardar el archivo.','tarificador/entradas/importar_codigo_pais','error');
        }
    
    } // End POST  
}

    public function verificar_codigo_pais()
    {
        $codigos = $this->input->post('arreglo');
        $repetidos = array_filter(array_count_values($codigos), function($count) {
            return $count > 1;
        });

        $mensaje="";
        foreach ($repetidos as $key => $value) {
            $mensaje= "El código '$key' se repite $value veces en los registros a ingresar";
        }
        if($mensaje!="" || !empty($mensaje)){
           echo json_encode(array('repetido'=>$mensaje, 'enviar'=>0, 'existe'=>0, 'valRep'=>$key));
            die();
        }
        $resp=0;
        if($mensaje == "" && !empty($codigos)){
            $resp=array();
            foreach ($codigos as $cod => $code) {
                $existe=$this->db->limit(1)->where('ppa_desde_codigo',$code)->get('ppa_parametro_pais')->result_array();
               
                if(count($existe)>0){
                    $resp[]=$existe[0]['ppa_desde_codigo'];
                }
            }
            if(!empty($resp)){
                echo json_encode(array('repetido'=>'', 'enviar'=>0, 'existe'=>$resp));
                die();
            }
        }
        
            if(($resp==0 || count($resp)==0) && $mensaje==""){
                echo json_encode(array('repetido'=>'', 'enviar'=>1, 'existe'=>0));
            }

    }

    function centros_costo($per_inv=null){
        satelite_validar();
        try{
            if(count($per_inv)>0){
                $permisos=$per_inv;
            }else{
                $permisos = $this->gsatelite->get_permisos_opcion();
            }
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('cec_centro_costo');
            $crud->set_subject('Centro de costos');
            
            $columnas = array(
                'cec_nombre',
                'cec_observacion',
                'cec_estado',
            );

            $required = array(
                'cec_nombre',
                'cec_estado',
            );

            // $campos = array(
            //     'tif_nombre',
            //     'tif_abreviacion',
            //     'tif_estado',
            //     'tif_fecha_crea',
            //     'tif_fecha_mod',
            //     'tif_usu_crea',
            //     'tif_usu_mo'
            // );

            $display_as = array(
                'cec_nombre'=>'Nombre',
                'cec_cuenta_contable'=>'Cuenta contable',
                'cec_observacion'=>'Observación',
                'cec_estado'=>'Estado',
            );
            
            
            $crud->field_type('cec_usu_mod', 'hidden',$this->tank_auth->get_user_id());
            $crud->field_type('cec_fecha_mod', 'hidden',date('Y-m-d H:i:s'));
            if(end(explode('/',uri_string()))=='add') {
                $crud->field_type('cec_estado','hidden',1);
                //$crud->field_type('cec__fecha_crea', 'hidden',date('Y-m-d H:i:s'));
                //$crud->field_type('cec__usu_crea', 'hidden',$this->tank_auth->get_user_id());
                
            }else {
                $crud->field_type('cec_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $crud->set_rules('cec_nombre','Nombre','trim|required|campo_unico[cec_centro_costo.cec_nombre]');
            
            $crud->required_fields($required);
            $crud->columns($columnas);
            //$crud->fields($campos);
            $crud->display_as($display_as);

             // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }

                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }

                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                if ($permisos['permite_ver']) {
                    if(count($per_inv)>0){
                        $crud->add_action('Ver', 'minia-icon-search', 'inventario/mantenimiento/centros_costo/read');
                    }else{
                        $crud->add_action('Ver', 'minia-icon-search', 'tarificador/entradas/centros_costo/read');

                    }
                }

            $output = $crud->render();
            $data['titulo_personal']="Centro de costos";
            $this->_cargarvista($data, $output);

        }catch(Exception $e){
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }
    }

    function exportar_pais_excel($ppa_id=0, $codigo=0){
        satelite_validar();
        $listado_paises=$this->tarificador_model->get_codigos_pais_excel($ppa_id,$codigo);

        $cadena="";

        if($tipo==2){ $cadena.='<table></table>'; }
        $cadena='<table class="tabla" style="border:1px solid black;">';
        $cadena.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
        $cadena.='<th style="text-align:center; font-weight:bold;">Destino/País</th>';
        $cadena.='<th style="text-align:center; font-weight:bold;">Ruta destino</th>';
        $cadena.='<th style="text-align:center; font-weight:bold;">Código desde</th>';
        $cadena.='<th style="text-align:center; font-weight:bold;">Fecha efectiva</th>';
        $cadena.='<th style="text-align:center; font-weight:bold;">Local</th>';
        $cadena.='<th style="text-align:center; font-weight:bold;">Comentarios</th>';
        $cadena.='</tr>';

        if($cod['ppa_local']==1){ $local="X"; }else{ $local=''; }
        foreach ($listado_paises as $key => $cod) {
            $cadena.="<tr style='border:1px solid black;'>";
            $cadena.="<td>".$cod['pai_nombre']."</td>";
            $cadena.="<td>".$cod['ppa_nombre']."</td>";
            $cadena.="<td>".$cod['ppa_desde_codigo']."</td>";
            $cadena.="<td>".$cod['ppa_fecha_efectiva']."</td>";
            $cadena.="<td>".$local."</td>"; 
            $cadena.="<td>".$cod['ppa_comentario']."</td>";
            $cadena.='</tr>';
        }

        $cadena.='</table>';
        $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']     = "Código de países";
            $data['table_tbody']      = $cadena;
            $data['filename']         = $filename;
            $this->load->view('tarificador/reportes/reporte_excel.php', $data);
    }

    function sector_cliente()
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->sector_cliente();
    }

    function segmento_cliente()
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->segmento_cliente();
    }
    
    function codigo_error(){
        satelite_validar();
        try{
            // $permisos= $this->gsatelite->get_permisos_opcion('tipo_solicitud');
            $crud = new grocery_CRUD();
            $crud->unset_add();
            $crud->unset_delete();
            $crud->set_table('coe_codigo_error');
            $crud->set_subject('');
            
            $columnas = array(
                'coe_codigo',
                'coe_descripcion',
                'coe_estado'
            );

            $required = array(
                'coe_descripcion'
            );

            $display_as = array(
                'coe_codigo'    =>  'Código',
                'coe_descripcion'   =>  'Descripción',
                'coe_estado'    => 'Estado'
            );
            
            $crud->field_type('coe_usu_creacion', 'hidden',$this->tank_auth->get_user_id());
            $crud->field_type('coe_usu_modificacion', 'hidden',$this->tank_auth->get_user_id());
            $crud->field_type('coe_fecha_creacion', 'hidden',date('Y-m-d H:i:s'));
            $crud->field_type('coe_fecha_modificacion', 'hidden',date('Y-m-d H:i:s')); 

            if(end(explode('/',uri_string()))=='add') {
                $crud->field_type('coe_estado','hidden',1);
            }else {
                $crud->field_type('coe_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $crud->set_rules('coe_codigo','Código','required|campo_unico[coe_codigo_error.coe_codigo]');
            $crud->add_action('Ver','minia-icon-search',uri_string().'/read');

            $crud->required_fields($required);
            $crud->columns($columnas);
            $crud->edit_fields('coe_codigo','coe_descripcion');
            $crud->display_as($display_as);

            $output = $crud->render();
            $data['titulo_personal']="Código Error Llamada";
            $this->_cargarvista($data, $output);

        }catch(Exception $e){
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }
    }

    function _cargarvista($data=0,$crud=0)
    {   
        $this->load->view('vacia',$crud);   
        if($data!=0)
            $data=array_merge($data,$this->masterpage->getUsuario());
        else
            $data=$this->masterpage->getUsuario();
        $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content',$data);
        $this->masterpage->show();
    }
}