<!-- ******************* Controlador para la gestión de mantenimientos compratidos ********************************* -->
<?php


if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Mantenimientos_compartidos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('sistema');
        $this->model = $this->sistema;
    }

    /**
    * @author Edith Herrera
    * @since  03/10/2017
    * @return Mantenimiento tabla esn_estado_atencion
    * Módulos: producción y cotizaciones.
    */

     function estimacion($permisos=null, $modulo = 'proyectos') {
        satelite_validar();
        
        if($permisos==null){
            $permisos = $this->gsatelite->get_permisos_opcion('inventario/mantenimiento/articulo');
        }

        $total_horas = $this->gsatelite->get_parametro("SYS_HORAS_PRODUCCION");
        $data['total_horas'] = $total_horas;

        $crud = new grocery_CRUD;
        $alias = array(
            'esm_codigo' => 'Código',
            'esm_nombre' => 'Nombre',
            'esm_monto'  => 'Monto',
            'esm_tipo_calculo'  => 'Tipo de cálculo',
            'esm_calculo_etapa' => 'Calculado Etapas',
            'esm_calculado' => 'Monto Calculado',
            'esm_estado' => 'Estado',
            'esm_id_cnt' => 'Cuenta Contable'
            );
        $colums = array(
            'esm_codigo',
            'esm_nombre',
            'esm_monto',
            'esm_tipo_calculo',
            'esm_estado');
        $edit = array(
            'esm_codigo',
            'esm_tipo_calculo',
            'esm_estado',
            'esm_nombre',
            'esm_calculado',
            'esm_calculo_etapa',
            'esm_monto',
            'esm_id_cnt',
            'esm_usu_modificacion',
            'esm_fecha_modificacion');
        $add = array(
            'esm_codigo',
            'esm_tipo_calculo',
            'esm_estado',
            'esm_nombre',
            'esm_calculado',
            'esm_calculo_etapa',
            'esm_monto',
            'esm_id_cnt',
            'esm_usu_modificacion',
            'esm_fecha_modificacion',
            'esm_usu_creacion',
            'esm_fecha_creacion');
        $req = array(
            'esm_codigo',
            'esm_nombre',
            'esm_tipo_calculo',
            'esm_estado',
            'esm_usu_modificacion',
            'esm_fecha_modificacion');

        $crud->set_table('esm_estimacion')
                ->set_subject('Gastos Indirectos de Fabricación')
                ->display_as($alias)
                ->columns($colums)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($req)
                ->field_type('esm_tipo_calculo', 'dropdown', array('1' => 'Monto', '0' => 'Porcentaje'))
                ->field_type('esm_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('esm_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                ->set_rules('esm_nombre', 'Nombre', 'trim|required|campo_unico[esm_estimacion.esm_nombre]')
                ->set_rules('esm_monto','Monto', 'trim|is_numeric')
                ->set_relation('esm_id_cnt', 'cnt_cuenta_contable', '{cnt_cuenta} {cnt_nombre}', array('cnt_estado' => 1, 'cnt_id_nic >' => 2))
                ->callback_column('esm_monto', function($value, $row) {
                        $decimales = ($this->gsatelite->get_parametro("NUMERO_DECIMALES")!=null)?$this->gsatelite->get_parametro("NUMERO_DECIMALES"):2;
                        return number_format($row->esm_monto, $decimales);
                    })
                ->callback_field('esm_monto', function($value){
                        $decimales = ($this->gsatelite->get_parametro("NUMERO_DECIMALES")!=null)?$this->gsatelite->get_parametro("NUMERO_DECIMALES"):2;
                        return '<input id="field-esm_monto" name="esm_monto" type="text" class="span12 soloDecimales text" value="' . number_format($value, $decimales,'.','') . '" maxlength="19,6">';
                })
                ->unset_delete();
                $data['esm_id'] = 0;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('esm_estado', 'hidden', 1);
            $crud->field_type('esm_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('esm_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $data['esm_id'] = end(explode('/', uri_string()));
            $crud->field_type('esm_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
        }

            $crud->callback_add_field('esm_calculado', function() {
                return '<input type="checkbox" id="chkCalculado" class="nostyle chk"><input type="hidden" id="field-esm_calculado" name="esm_calculado" value="0">';
            });
            $crud->callback_add_field('esm_calculo_etapa', function() {
                return '<input type="checkbox" id="chkCalculadoEtapa" class="nostyle chk"><input type="hidden" id="field-esm_calculo_etapa" name="esm_calculo_etapa" value="0">';
            });

            $crud->callback_edit_field('esm_calculado', function($value, $primary_key) {
                $leer    = ($this->uri->rsegments[3] == 'read')?'readonly ':'';
                $defecto = ($value > 0) ? 'checked' : ''; 
                return '<input type="checkbox" id="chkCalculado" '.$defecto.' class="nostyle chk" '.$leer.'><input type="hidden" id="field-esm_calculado" name="esm_calculado" value="'.$value.'">';
            });
            $crud->callback_edit_field('esm_calculo_etapa', function($value, $primary_key) {
                $leer    = ($this->uri->rsegments[3] == 'read')?'readonly ':'';
                $defecto = ($value > 0) ? 'checked' : ''; 
                return '<input type="checkbox" id="chkCalculadoEtapa" '.$defecto.' class="nostyle chk" '.$leer.'><input type="hidden" id="field-esm_calculo_etapa" name="esm_calculo_etapa" value="'.$value.'">';
            });


        // Permisos
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            else{
                 $crud->add_action('Detalle Cálculo', 'icomoon-icon-clipboard-2', $modulo . '/mantenimientos/detalle_calculo_estimacion');
            }

            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }

            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }

            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
        $output = $crud->render();
        $data['titulo_personal'] = "Gastos Indirectos de Fabricación";
        $this->_cargarvista($data, $output);
    }
    
     /**
    * @author Habby Lovo
    * @since  13/11/2017 
    * @return Mantenimiento tabla mob_mano_obra
    * Módulos: producción y cotizaciones.
    */
    function mano_obra($modulo, $permisos=null) {
        satelite_validar();
        if($permisos == null){
            $permisos = $this->gsatelite->get_permisos_opcion('inventario/mantenimiento/articulo');
        }
        try {
            $total_horas = $this->gsatelite->get_parametro("SYS_HORAS_PRODUCCION");
            $data['total_horas'] = $total_horas;
            $crud = new grocery_CRUD;
            // Variable para permisos. Agregado por Luis Navarro
            $permisos = $this->gsatelite->get_permisos_opcion();
            $alias = array(
                'mob_codigo' => 'Código',
                'mob_nombre' => 'Nombre',
                'mob_precio' => 'Monto',
                'mob_calculo_etapa' => 'Calculado Etapas',
                'mob_calculado' => 'Monto Calculado',
                'mob_estado' => 'Estado',
                'mob_id_cnt' => 'Cuenta Contable'
            );

            $colums = array(
                'mob_codigo',
                'mob_nombre',
                'mob_precio',                
                'mob_calculado',
                'mob_calculo_etapa',
                'mob_estado'
            );
            $edit = array(
                'mob_codigo',
                'mob_nombre',
                'mob_precio',
                'mob_calculado',
                'mob_calculo_etapa',
                'mob_id_cnt',
                'mob_estado',
                'mob_usu_mod',
                'mob_fecha_mod'
            );
            $add = array(
                'mob_codigo',
                'mob_nombre',
                'mob_precio',
                'mob_calculado',
                'mob_calculo_etapa',
                'mob_id_cnt',
                'mob_estado',
                'mob_usu_mod',
                'mob_fecha_mod'
            );
            $req = array(
                'mob_codigo',
                'mob_nombre',
                'mob_precio',
                'mob_estado',
                'mob_usu_mod',
                'mob_fecha_mod'
            );

            $crud->set_table('mob_mano_obra')
                    ->set_subject('Mano de obra')
                    ->display_as($alias)
                    ->columns($colums)
                    ->add_fields($add)
                    ->edit_fields($edit)
                    ->required_fields($req)
                    ->field_type('mob_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('mob_fecha_mod', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('mob_total_hora', 'integer', $total_horas)
                    ->set_rules('mob_nombre', 'Nombre', 'trim|required|campo_unico[mob_mano_obra.mob_nombre]')
                    ->set_relation('mob_id_cnt', 'cnt_cuenta_contable', '{cnt_cuenta} {cnt_nombre}', array('cnt_estado' => 1, 'cnt_id_nic >' => 2))
                    ->callback_column('mob_precio', function($value, $row) {
                            $decimales = ($this->gsatelite->get_parametro("NUMERO_DECIMALES")!=null)?$this->gsatelite->get_parametro("NUMERO_DECIMALES"):2;
                            return number_format($row->mob_precio, $decimales);
                        })
                    ->callback_column('mob_calculado', function($value, $row) {
                            return ($value == 1)?"Si":"No";
                        })
                    ->callback_column('mob_calculo_etapa', function($value, $row) {
                            return ($value == 1)?"Si":"No";
                        })
                    ->callback_field('mob_precio', function($value){
                        $decimales = ($this->gsatelite->get_parametro("NUMERO_DECIMALES")!=null)?$this->gsatelite->get_parametro("NUMERO_DECIMALES"):2;
                            
                        return '<input id="field-mob_precio" name="mob_precio" type="text" class="span12 soloDecimales text" decimales="'.$decimales.'" value="'.number_format($value, $decimales,'.','').'" maxlength="19,6">';
                    })
                    
                    ;

            $data['mob_id'] = 0;
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('mob_estado', 'hidden', 1);
            } else {
                $data['mob_id'] = end(explode('/', uri_string()));
                $crud->field_type('mob_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $crud->callback_add_field('mob_calculado', function() {
                return '<input type="checkbox" id="chkCalculado" class="nostyle chk"><input type="hidden" id="field-mob_calculado" name="mob_calculado" value="0">';
            });
            $crud->callback_add_field('mob_calculo_etapa', function() {
                return '<input type="checkbox" id="chkCalculadoEtapa" class="nostyle chk"><input type="hidden" id="field-mob_calculo_etapa" name="mob_calculo_etapa" value="0">';
            });

            $crud->callback_edit_field('mob_calculado', function($value, $primary_key) {
                $leer    = ($this->uri->rsegments[3] == 'read')?'readonly ':'';
                $defecto = ($value)?'checked':''; 
                return '<input type="checkbox" id="chkCalculado" '.$defecto.' class="nostyle chk" '.$leer.'><input type="hidden" id="field-mob_calculado" name="mob_calculado" value="'.$value.'">';
            });
            $crud->callback_edit_field('mob_calculo_etapa', function($value, $primary_key) {
                $leer = ($this->uri->rsegments[3] == 'read') ? 'readonly' : '';
                $dfct = ($value) ? 'checked' : ''; 
                return '<input type="checkbox" id="chkCalculadoEtapa" '.$dfct.' class="nostyle chk" '.$leer.'><input type="hidden" id="field-mob_calculo_etapa" name="mob_calculo_etapa" value="'.$value.'">';
            });

            // Administrar Permisos CRUD. Agregado por Luis Navarro
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            else{
                 $crud->add_action('Detalle Cálculo', 'icomoon-icon-clipboard-2', $modulo.'/mantenimientos/detalle_calculo_mano_obra');
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', $modulo.'/mantenimientos/mano_obra/read');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Mano de obra";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function detalle_calculo_mano_obra($mob_id) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('proyectos/mantenimientos/mano_obra');

        $mano_obra = $this->gsatelite->get_tabla('mob_mano_obra', array('mob_id' => $mob_id));
        $data['mano_obra'] = $mano_obra;
        $data['decimales'] = $this->gsatelite->get_parametro("NUMERO_DECIMALES");

        $crud = new grocery_CRUD;
        $alias = array(
            'dec_nombre' => 'Nombre',
            'dec_monto' => 'Monto',
            'dec_estado' => 'Estado'
        );

        $colums = array(
            'dec_nombre',
            'dec_monto',
            'dec_estado'
        );
        $edit = array(
            'dec_nombre',
            'dec_monto',
            'dec_estado',
            'dec_usu_modificacion',
            'dec_fecha_modificacion'
        );

        $add = array(
            'dec_nombre',
            'dec_monto',
            'dec_id_mob',
            'dec_estado',
            'dec_usu_creacion',
            'dec_fecha_creacion',
            'dec_fecha_modificacion',
            'dec_usu_modificacion'
        );

        $crud->set_table('dec_detalle_calculo')
                ->set_subject('Detalle Cálculo')
                ->display_as($alias)
                ->columns($colums)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($add)
                ->where('dec_id_mob', $mob_id)
                ->field_type('dec_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('dec_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                //->set_rules('dec_nombre', 'Nombre', 'trim|required|campo_unico[acp_act_economica_prov.acp_nombre]')
                ->set_rules('dec_nombre', 'Nombre', 'trim|required')
                ->field_type('dec_id_mob', 'hidden', convertirFloat($mano_obra[0]['mob_id']))
                ->unset_print()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('dec_estado', 'hidden', 1)
                    ->field_type('dec_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('dec_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('dec_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $crud->callback_after_insert(array($this,'actualizar_monto_mob'));
        $crud->callback_after_update(array($this,'actualizar_monto_mob'));

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Detalle Cálculo";
        $this->_cargarvista($data, $output);
    }

    public function actualizar_monto_mob($post_array,$key){
        $mob_id = $this->gsatelite->get_campo('dec_detalle_calculo', 'dec_id_mob', array('dec_id' => $key));
        $mob_calculado = $this->gsatelite->get_campo('mob_mano_obra', 'mob_calculado', array('mob_id' => $mob_id));
        $suma = $this->gsatelite->get_suma('dec_detalle_calculo', 'dec_monto', array('dec_estado' => 1, 'dec_id_mob' => $mob_id));
        if ($mob_calculado > 0) {
            $actualizar = array('mob_precio' => $suma, 'mob_usu_mod' => $this->tank_auth->get_user_id(), 'mob_fecha_mod' => date('Y-m-d H:i:s'));
            $this->db->where('mob_id', $mob_id)->update('mob_mano_obra', $actualizar);
        }        
        return true;
    }

    function detalle_calculo_estimacion($esm_id) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('proyectos/mantenimientos/estimacion');

        $estimacion = $this->gsatelite->get_tabla('esm_estimacion', array('esm_id' => $esm_id));
        $data['estimacion'] = $estimacion;
        $data['decimales'] = $this->gsatelite->get_parametro("NUMERO_DECIMALES");

        $crud = new grocery_CRUD;
        $alias = array(
            'dxe_nombre' => 'Nombre',
            'dxe_monto' => 'Monto',
            'dxe_estado' => 'Estado'
        );

        $colums = array(
            'dxe_nombre',
            'dxe_monto',
            'dxe_estado'
        );
        $edit = array(
            'dxe_nombre',
            'dxe_monto',
            'dxe_estado',
            'dxe_usu_modificacion',
            'dxe_fecha_modificacion'
        );

        $add = array(
            'dxe_nombre',
            'dxe_monto',
            'dxe_id_esm',
            'dxe_estado',
            'dxe_usu_creacion',
            'dxe_fecha_creacion',
            'dxe_fecha_modificacion',
            'dxe_usu_modificacion'
        );

        $crud->set_table('dxe_detallexestimacion')
                ->set_subject('Detalle Cálculo')
                ->display_as($alias)
                ->columns($colums)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($add)
                ->where('dxe_id_esm', $esm_id)
                ->field_type('dxe_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('dxe_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                //->set_rules('dec_nombre', 'Nombre', 'trim|required|campo_unico[acp_act_economica_prov.acp_nombre]')
                ->set_rules('dxe_nombre', 'Nombre', 'trim|required')
                ->field_type('dxe_id_esm', 'hidden', convertirFloat($estimacion[0]['esm_id']))
                ->unset_print()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('dxe_estado', 'hidden', 1)
                    ->field_type('dxe_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('dxe_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('dxe_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $crud->callback_after_insert(array($this,'actualizar_monto_gif'));
        $crud->callback_after_update(array($this,'actualizar_monto_gif'));

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Detalle Cálculo - GIF";
        $this->_cargarvista($data, $output);
    }

    public function actualizar_monto_gif($post_array,$key){
        $esm_id = $this->gsatelite->get_campo('dxe_detallexestimacion', 'dxe_id_esm', array('dxe_id' => $key));
        $esm_calculado = $this->gsatelite->get_campo('esm_estimacion', 'esm_calculado', array('esm_id' => $esm_id));
        $suma = $this->gsatelite->get_suma('dxe_detallexestimacion', 'dxe_monto', array('dxe_estado' => 1, 'dxe_id_esm' => $esm_id));
        if ($esm_calculado > 0) {
            $actualizar = array('esm_monto' => $suma, 'esm_usu_modificacion' => $this->tank_auth->get_user_id(), 'esm_fecha_modificacion' => date('Y-m-d H:i:s'));
            $this->db->where('esm_id', $esm_id)->update('esm_estimacion', $actualizar);
        }
        return true;
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

} // End of Class
/* End of file mantenimientos_compartidos.php */
/* Location: ./application/controllers/sistema/mantenimientos_compartidos.php */