<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Configuraciones extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('sistema');
    }

    function configura_formularios() {
        $data['modulos'] = $this->sistema->get_modulos();
        $data['formularios'] = [];
        $data['configuraciones'] = [];
        $data['filtro_modulo'] = '';
        $data['filtro_formulario'] = '';

        $data['modulo']  = 'sistema';
        $data['control'] = 'configuraciones';
        $data['funcion'] = 'configura_formularios';
        $data['titulo']  = 'Configuración de Formularios';

         $this->gsatelite->cargar_vista_masterpage('sistema/configuraciones/configura_formularios', $data);
    }

    function generateJsonForm() {
        $url = $this->input->post('url', TRUE);

        if (empty($url)) {
            return rJson([
                'status'  => 'error',
                'message' => 'No se recibió la URL del formulario'
            ], 400, true);
        }

        $this->db->where('cfp_url', $url);
        $this->db->where('cfp_estado', 1);
        $query = $this->db->get('cfp_configuracion_formularios_pantalla');
        $result = $query->result_array();

        if (empty($result)) {
            return rJson([
                'status'  => 'empty',
                'message' => 'Sin configuraciones para esta URL'
            ], 204, true);
        }

        $response = array();
        foreach ($result as $row) {
            $response[] = array(
                'id_element'   => $row['cfp_id_element'],
                'label'        => $row['cfp_label'],
                'tipo'         => $row['cfp_tipo'],
                'mostrar'      => (int)$row['cfp_mostrar'],
                'obligatorio'  => (int)$row['cfp_obligatorio'],
                'defecto'      => $row['cfp_defecto'],
                'editable'     => (int)$row['cfp_editable'],
                'evento_js'    => $row['cfp_evento_js'],
                'orden'        => isset($row['cfp_orden']) ? (int)$row['cfp_orden'] : null,
            );
        }

        return rJson([
            'status' => 'ok',
            'count'  => count($response),
            'data'   => $response
        ], 200, true);
    }


    function get_formularios_by_modulo() {
        $modulo = $this->input->post('modulo', TRUE);
        if (empty($modulo)) {

            return rJson(['status' => 'error', 'message' => 'Módulo no especificado'], 400, true);
        }

        $formularios = $this->sistema->get_formularios($modulo);

        return rJson(['status' => 'ok', 'data' => $formularios], 200, true);

    }


    function get_configuracion_formularios() {
        $modulo = $this->input->post('modulo', TRUE);
        $formulario = $this->input->post('formulario', TRUE);

        if (empty($modulo)) {
            return rJson(['status' => 'error', 'message' => 'Módulo no especificado'], 400, true);
        }

        $registros = $this->sistema->listar($modulo, $formulario);
        $data = [];

        foreach ($registros as $row) {
            $partes = explode('|', $row->cfp_label);
            $tab = isset($partes[1]) ? trim($partes[1]) : 'General';
            $campo = isset($partes[2]) ? trim($partes[2]) : trim($row->cfp_label);

            $data[] = [
                'id'          => $row->cfp_id,
                'modulo'      => $row->cfp_modulo,
                'formulario'  => $row->cfp_formulario,
                'tab'         => $tab,
                'campo'       => $campo,
                'tipo'        => $row->cfp_tipo,
                'mostrar'     => (int)$row->cfp_mostrar,
                'obligatorio' => (int)$row->cfp_obligatorio,
                'editable'    => (int)$row->cfp_editable,
                'defecto'     => $row->cfp_defecto
            ];
        }

        return rJson([
            'status' => 'ok',
            'count'  => count($data),
            'data'   => $data
        ], 200, true);
    }


    function update_campo() {
        $id    = $this->input->post('id', TRUE);
        $campo = $this->input->post('campo', TRUE);
        $valor = $this->input->post('valor', TRUE);

        if (!$id || !$campo) {
            return rJson(['status' => 'error', 'message' => 'Parámetros incompletos'], 400, true);
        }

        $usuario = $this->session->userdata('usu_id') ?: 1;
        $ok = $this->sistema->update_campo($id, $campo, $valor, $usuario);

        return rJson([
            'status'  => $ok ? 'ok' : 'error',
            'message' => $ok ? 'Actualizado correctamente' : 'No se pudo actualizar'
        ], 200, true);
    }

    private function _cargarvista($data = 0) {
        $data = ($data != 0)
            ? array_merge($data, $this->masterpage->getUsuario())
            : $this->masterpage->getUsuario();

        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }
}
