<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Catalogo extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('sistema');
        $this->load->model('consultas');
        $this->model = $this->sistema;
    }

    function parentesco() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $crud = new grocery_CRUD();
            $crud->set_subject('parentesco');
            $crud->set_table('pat_parentesco');
            $columns = array('pat_nombre', 'pat_estado');
            $add_columns = array('pat_nombre', 'pat_estado', 'pat_fecha_mod', 'pat_usu_mod');
            $edit_columns = $add_columns;
            $alias = array(
                'pat_estado' => 'Estado',
                'pat_nombre' => 'Nombre');
            $crud->display_as($alias)
                    ->columns($columns)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->set_rules('pat_nombre', 'Nombre', 'campo_unico[pat_parentesco.pat_nombre]|required')
                    ->field_type('pat_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('pat_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->required_fields($add_columns);
            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('pat_estado', 'hidden', 1);
            } else {
                $crud->field_type('pat_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Parentescos";
            $this->_cargarvista($data, $output);
        }
    }

    public function carga_logos(){
        satelite_validar();
        if ($_POST) {
            $nombre_cust = $_POST["nombre_act"];
            $nombre_sist = $_POST["titulo_foto_empleado"];
            $nombre_carg = $_POST["foto_empleado"];
            $ruta = FCPATH . "public/temp/logos/" . $nombre_cust;
            $existe = file_exists($ruta);
            if ($nombre_cust == $nombre_carg && $existe) {
                $desde = 'public/temp/logos/' . $nombre_carg;
                $hacia = 'media/imagenes/sistema/' . $nombre_carg;
                rename($desde, $hacia);
                $alerta = array('tipo_alerta'=> 'success','titulo_alerta'=>"Carga Completada",'texto_alerta'=>"La carga del archivo a sido exitosa");
            } else {
                $alerta = array('tipo_alerta'=> 'error','titulo_alerta'=>"No se pudo cargar el archivo",'texto_alerta'=>"Verifique los datos y vuelva a intentar");
            }            
            $this->session->set_flashdata($alerta);
            redirect('sistema/catalogo/carga_logos');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $data['titulo_personal'] = "Imagen Logotipo";
            $this->_cargarvista($data);
        }
        
    }

    public function carga_imagenes(){
        satelite_validar();
        if ($_POST) {
            // var_dump($_POST);die();
            $uso_destino = $_POST["slct_destino"];
            $nombre_actual = $_POST["nombre_act"];
            $nombre_cargar = $_POST["foto_empleado"];
            $ruta = FCPATH . "public/temp/fotos/" . $nombre_actual;
            $existe = file_exists($ruta);
            if ($nombre_actual == $nombre_cargar && $existe) {
                $desde = 'public/temp/fotos/' . $nombre_actual;
                switch ($uso_destino) {
                    case '1':
                        $hacia = 'media/acciones_personal/firma_constancias.png';
                        break;                    
                }
                rename($desde, $hacia);
                $alerta = array('tipo_alerta'=> 'success','titulo_alerta'=>"Carga Completada",'texto_alerta'=>"La carga del archivo a sido exitosa");
            } else {
                $alerta = array('tipo_alerta'=> 'error','titulo_alerta'=>"No se pudo cargar el archivo",'texto_alerta'=>"Verifique los datos y vuelva a intentar");
            }            
            $this->session->set_flashdata($alerta);
            redirect('sistema/catalogo/carga_imagenes');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $data['titulo_personal'] = "Cargar Imágenes";
            $this->_cargarvista($data);
        }
        
    }

    function pais() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $permisos = $this->gsatelite->get_permisos_opcion();
            $data['permisos'] = $permisos;
            $crud = new grocery_CRUD();
            $crud->set_subject('País');
            $crud->set_table('pai_pais');
            $columns = array('pai_id', 'pai_nombre', 'pai_nacionalidad', 'pai_defecto', 'pai_estado');
            $add_columns = array('pai_nombre', 'pai_nacionalidad', 'pai_defecto', 'pai_estado', 'pai_usu_mod', 'pai_fecha_mod', 'pai_usu_crea', 'pai_fecha_crea');
            $edit_columns = $add_columns;
            $alias = array(
                'pai_id' => 'ID',
                'pai_nombre' => 'Nombre',
                'pai_nacionalidad' => 'Nacionalidad',
                'pai_defecto'       => 'Defecto',
                'pai_estado' => 'Estado');
            $crud->display_as($alias)
                    ->columns($columns)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->callback_column('pai_defecto', function($value, $row) {
                        $val = ($value == null || $value == 0)?'':'X';       
                        return $val;                    
                       
                    })
                    ->field_type('pai_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('pai_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('pai_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('pai_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->set_rules('pai_nombre', 'Nombre', 'campo_unico[pai_pais.pai_nombre]|required')
                    ->required_fields('pai_nombre', 'pai_estado')
                    ->callback_add_field('pai_defecto', function() {
                        return '<input type="checkbox" id="chkvalidar" class="nostyle"><input type="hidden" id="field-pai_defecto" name="pai_defecto" value="0">';
                    })
                    ->callback_edit_field('pai_defecto', function($value, $primary_key) {
                        $leer    = ($this->uri->rsegments[3] == 'read')?'readonly ':'';
                        $defecto = ($value)?'checked':''; 
                        return '<input type="checkbox" id="chkvalidar" '.$defecto.' class="nostyle" '.$leer.'><input type="hidden" id="field-pai_defecto" name="pai_defecto" value="'.$value.'">';
                    })
                    ->callback_before_insert(function($post_array){
                        $CI = & get_instance();
                        $CI->gsatelite->actualizar_array('pai_pais', array('pai_defecto'=>0), array());
                        return $post_array;
                    })
                    ->callback_before_update(function($post_array){
                        $CI = & get_instance();
                        $CI->gsatelite->actualizar_array('pai_pais', array('pai_defecto'=>0), array());
                        return $post_array;
                    });
                    // ->field_type('pai_defecto', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('pai_estado', 'hidden', 1);
            } else {
                $crud->field_type('pai_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }else{
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }     

            $output = $crud->render();
            $data['titulo_personal'] = "País";
            cargarvista($data, $output, 'sistema/catalogo/pais');
        }
    }

    function profesion($per_inv = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if (count($per_inv) > 0) {
                $permisos = $per_inv;
            } else {
                $permisos = $this->gsatelite->get_permisos_opcion();
            }

            $crud = new grocery_CRUD();
            $crud->set_subject('profesión');
            $crud->set_table('pro_profesion');
            $crud->display_as('pro_nombre', 'Nombre')
                    ->display_as('pro_estado', 'Estado')
                    ->add_fields('pro_nombre', 'pro_estado', 'pro_usu_crea', 'pro_fecha_crea', 'pro_usu_mod', 'pro_fecha_mod')
                    ->edit_fields('pro_nombre', 'pro_estado', 'pro_usu_mod', 'pro_fecha_mod')
                    ->columns('pro_nombre', 'pro_estado')
                    ->required_fields('pro_nombre', 'pro_estado')
                    ->set_rules('pro_nombre', 'Nombre', 'campo_unico[pro_profesion.pro_nombre]|required')
                    ->field_type('pro_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('pro_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('pro_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('pro_usu_mod', 'hidden', $this->tank_auth->get_user_id())
            ;

            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('pro_estado', 'hidden', 1);
            } else {
                $crud->field_type('pro_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }

            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }

            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }

            if (!$permisos['permite_ver']) {
                /*if (count($per_inv) > 0) {
                    $crud->add_action('Ver', 'minia-icon-search', 'inventario/mantenimiento/profesion/read');
                } else {
                    $crud->add_action('Ver', 'minia-icon-search', 'sistea/catalogo/profesion/read');
                }*/
                $crud->unset_read();
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Profesión";
            //$this->_cargarvista($data, $output);
            cargarvista($data,$output,'sistema/catalogo/profesion');
        }
    }

    function tipo_documento() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $crud = new grocery_CRUD();
            $crud->set_subject('Tipo documento');
            $crud->set_table('tde_tipo_documento');
            $crud->display_as('tde_nombre', 'Nombre')
                    ->display_as('tde_estado', 'Estado')
                    ->fields('tde_nombre', 'tde_estado', 'tde_usu_mod', 'tde_fecha_mod')
                    ->columns('tde_nombre', 'tde_estado')
                    ->required_fields('tde_nombre', 'tde_estado')
                    ->set_rules('tde_nombre', 'Nombre', 'campo_unico[tde_tipo_documento.tde_nombre]|required')
                    ->field_type('tde_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('tde_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('tde_estado', 'hidden', 1);
            } else {
                $crud->field_type('tde_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Tipos de documentos";
            $this->_cargarvista($data, $output);
        }
    }

    function departamentos_empresa() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $query_padres = "SELECT are_id FROM are_area WHERE are_padre IS NULL";
            $padres = $this->db->query($query_padres)->result_array();
            $cadena_in = "";
            foreach ($padres as $key => $value) {
                if ($value['are_id'] != "") {
                    $cadena_in .= $value['are_id'] . ",";
                }
            }
            $cadena_final = substr($cadena_in, 0, -1);

            $query_no_tienen_hijos = "SELECT are_id FROM are_area WHERE are_id IN (" . $cadena_final . ")";
            $no_tienen_hijos = $this->db->query($query_no_tienen_hijos)->result_array();
            $cadena_in2 = "";
            foreach ($no_tienen_hijos as $key2 => $value2) {
                if ($value2['are_id'] != "") {
                    $cadena_in2 .= $value2['are_id'] . ",";
                }
            }
            /* print_r($this->db->last_query());
              exit(); */
            $cadena_final2 = substr($cadena_in2, 0, -1);
            $crud = new grocery_CRUD();
            $crud->set_subject('Departamentos');
            $crud->set_table('are_area');
            $crud->display_as('are_nombre', 'Nombre')
                    ->display_as('are_padre', 'Padre');
            $add_columns = array('are_padre', 'are_nombre');
            $edit_columns = $add_columns;
            $crud->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->columns($add_columns)
                    ->required_fields('are_nombre')
                    ->set_relation('are_padre', 'are_area', 'are_nombre', "are_id in({$cadena_final2})")
                    ->set_rules('are_nombre', 'Nombre', 'campo_unico[are_area.are_nombre]|required');
            $output = $crud->render();
            $data['titulo_personal'] = "Áreas y departamentos";
            $this->_cargarvista($data, $output);
        }
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function anuncio() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['anuncios'] = $this->sistema->get_tabla("anu_anuncio");
            $this->_cargarvista($data);
        }
    }

    function agregar() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->form_validation->set_rules('titulo', 'Título', 'required');
            $this->form_validation->set_rules('descripcion', 'Descripción', 'required');
            $this->form_validation->set_rules('texto', 'Texto', 'required');
            if ($this->form_validation->run() == FALSE) {
                $this->_cargarvista();
            } else {
                $this->load->library('upload', $config);
                $reg = 0;
                $anuncio = array
                    ('anu_titulo' => $_POST['titulo'],
                    'anu_descripcion' => $_POST['descripcion'],
                    'anu_texto' => $_POST['texto'],
                    'anu_estado' => 1
                );
                $reg = $this->sistema->add_registro('anu_anuncio', $anuncio);
                if ($reg > 0)
                    $alerta = array('registro' => $reg, 'tipo_alerta' => 'note_success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente");
                else
                    $alerta = array('tipo_alerta' => 'note_error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no se pudo ingresar verifique la informacion ingresada");
                $this->session->set_flashdata($alerta);
                redirect('/sistema/catalogos/anuncio');
            }
        }
    }

    function subir_imagen($id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['anuncio'] = $this->sistema->get_registro("anu_anuncio", array('anu_id' => (int) $id));
            if ($_POST) {
                $nombre = date("dmy-His");
                $config['upload_path'] = './uploads/anuncios/';
                $config['allowed_types'] = 'jpg|png';
                $config['max_size'] = '5000';
                //$config['max_width']  = '1024';
                //$config['max_height']  = '768';
                $config['file_name'] = $nombre;
                $this->load->library('upload', $config);
                if (!$this->upload->do_upload()) {
                    $error = array('error' => $this->upload->display_errors());
                    $alerta = array('tipo_alerta' => 'note_error', 'titulo_alerta' => "No se cargo la imagen", 'texto_alerta' => $error['error']);
                    $this->session->set_flashdata($alerta);
                    redirect('sistema/catalogos/subir_imagen/' . $id);
                } else {
                    $this->sistema->mod_registro('anu_anuncio', array('anu_id' => $id), array('anu_imagen' => $nombre . $this->upload->get_extension($_POST['userfile1'])));
                    $alerta = array('tipo_alerta' => 'note_success', 'titulo_alerta' => "Imagen cargada correctamente", 'texto_alerta' => "La imagen se pudo subir correctamente");
                    $this->session->set_flashdata($alerta);
                    redirect('sistema/catalogos/subir_imagen/' . $id);
                }
            }
            $this->_cargarvista($data);
        }
    }

    function editar($id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['anuncio'] = $this->sistema->get_registro("anu_anuncio", array('anu_id' => (int) $id));
            $this->form_validation->set_rules('titulo', 'Titulo', 'required');
            $this->form_validation->set_rules('descripcion', 'Descripcion', 'required');
            $this->form_validation->set_rules('texto', 'Texto', 'required');
            if ($this->form_validation->run() == FALSE) {
                $this->_cargarvista($data);
            } else {
                $reg = 0;
                $anuncio = array(
                    'anu_titulo' => $_POST['titulo'],
                    'anu_descripcion' => $_POST['descripcion'],
                    'anu_texto' => $_POST['texto']
                );
                $reg = $this->sistema->mod_registro('anu_anuncio', array('anu_id' => $id), $anuncio);
                if ($reg > 0)
                    $alerta = array('registro' => $reg, 'tipo_alerta' => 'note_success', 'titulo_alerta' => "Registro modificado", 'texto_alerta' => "El registro se ha modificado correctamente");
                else
                    $alerta = array('tipo_alerta' => 'note_error', 'titulo_alerta' => "Registro no modificado", 'texto_alerta' => "El registro no se pudo modificar verifique la informacion ingresada");
                $this->session->set_flashdata($alerta);
                redirect('/sistema/catalogos/anuncio');
            }
        }
    }

    function eliminar($id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $anuncio = $this->sistema->get_registro("anu_anuncio", array('anu_id' => (int) $id));
            $result = $this->sistema->del_registro('anu_anuncio', array('anu_id' => (int) $id));
            if ($result != 0)
                unlink('uploads/anuncios/' . $anuncio['anu_imagen']);
            redirect('/sistema/catalogos/anuncio');
        }
    }

    function estado($est, $id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $result = $this->sistema->mod_registro('anu_anuncio', array('anu_id' => (int) $id), array('anu_estado' => (int) $est));
            redirect('/sistema/catalogos/anuncio');
        }
    }

    function opciones() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $crud = new grocery_CRUD();
                $crud->set_table('opc_opcion');
                $crud->set_subject('Opciones');
                $crud->columns('opc_id', 'opc_nombre', 'opc_descripcion', 'opc_orden');
                $crud->display_as('opc_id', 'Id')
                        ->display_as('opc_nombre', 'Nombre de opción')
                        ->display_as('opc_funcion', 'Nombre de función')
                        ->display_as('opc_descripcion', 'Descripción')
                        ->display_as('opc_padre', 'Padre')
                        ->display_as('opc_orden', 'Orden')
                        ->display_as('opc_nivel', 'Nivel')
                        ->display_as('opc_hijo', 'Hijo')
                        ->display_as('opc_icono', 'Icono')
                        ->where('opc_estado', 1)
                        //->fields('opc_nombre','opc_padre','opc_descripcion','opc_nivel','opc_hijo','opc_funcion','opc_icono')
                        ->add_fields('opc_nombre', 'opc_padre', 'opc_orden', 'opc_descripcion', 'opc_nivel', 'opc_hijo', 'opc_funcion', 'opc_icono')
                        ->edit_fields('opc_nombre', 'opc_orden', 'opc_descripcion', 'opc_icono')
                        ->required_fields('opc_nombre', 'opc_padre', 'opc_descripcion', 'opc_nivel', 'opc_hijo', 'opc_funcion')
                        ->unset_add()
                        ->set_rules('opc_nombre', 'Nombre', 'trim|callback_nameopc_check_insert|required')
                        ->set_rules('opc_orden', 'Orden', 'trim|callback_nameopc_check_insert|required')
                        ->unset_delete()
                ;
                /*
                  $crud = new grocery_CRUD();
                  $crud->set_table('prueba');
                  $crud->set_subject('PRUEBA');
                  $crud->columns('id','campo_varchar','campo_numero','campo_fecha');
                 */
                $crud->set_primary_key('opc_id', 'vw_opc')->set_relation('opc_padre', 'vw_opc', 'opc_nombre', null, 'opc_id');
                $data['titulo_personal'] = "Opciones";
                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function nameopc_check_insert($str) {
        $id = end(explode("/", uri_string()));
        if (is_numeric($id)) {
            $username_old = $this->db->where("opc_id", $id)->get('opc_opcion')->row()->tia_nombre;
            $num_row = $this->db->where('opc_nombre', $str)->where('opc_id !=', $id)->get('opc_opcion')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('nameopc_check_insert', 'El nombre de la opción existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('opc_nombre', $str)->get('opc_opcion')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('nameopc_check_insert', 'El nombre de la opción ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    /**
     * Catalogos::get_hijos()
     * @author Alexis Beltran
     *
     * 
     * @param mixed $cat_id
     * @return void
     */
    function get_hijos($cat_id) {
        $this->db->where('cat_tipo', $cat_id)->where('cat_padre', 0)->order_by('cat_nombre');
        $hijos[0] = 'Seleccione';
        foreach ($this->db->get('cat_catalogo')->result() as $row) {
            $hijos[$row->cat_id] = $row->cat_nombre;
        }
        echo form_dropdown('padre', $hijos, '0', 'id="_padre2"');
    }

    /**
     * Catalogos::gestion()
     * @author Alexis Beltran
     * 
     * @return void
     */
    function gestion() {

        if ($this->input->post('cat_tipo')) {
            $cat_id = $this->db->insert('cat_catalogo', array(
                'cat_nombre' => $this->input->post('nombre'),
                'cat_desc' => $this->input->post('desc'),
                'cat_tipo' => ($this->input->post('padre') == 'on') ? '0' : $this->input->post('cat_tipo'),
                'cat_padre' => ($this->input->post('padre') == 'on') ? '1' : '0',
            ));
            if ($this->input->post('padre') == 'on') {
                $this->db->update('cat_catalogo', array('cat_tipo' => $cat_id));
            }
        }
        //obtenemos los catalogos
        $this->db->where('cat_tipo', 'cat_id', FALSE)->order_by('cat_nombre');
        $catalogos[0] = 'Seleccione';
        foreach ($this->db->get('cat_catalogo')->result() as $row) {
            $catalogos[$row->cat_id] = $row->cat_nombre;
        }

        $data = array(
            'catalogos' => $catalogos
        );
        $this->_cargarvista($data, 0, 'sistema/catalogos/gestion');
    }

    function tipo_empleado() {
        try {

            $crud = new grocery_CRUD();
            $crud->set_table('tie_tipo_empleado')->set_subject('Tipo de Empleada/o');

            $crud
                    ->display_as('tie_nombre', 'Nombre')
                    ->columns('tie_nombre')
                    ->fields('tie_nombre', 'tie_fecha_mod', 'tie_usu_mod')
                    ->required_fields('tie_nombre')
                    ->field_type('tie_fecha_mod', 'hidden', date('Y-m-d'))
                    ->field_type('tie_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->set_rules('tie_nombre', 'Nombre', 'is_unique[tie_tipo_empleado.tie_nombre]')
            ;

            $data['titulo_personal'] = "Tipo de Empleada/o";

            $output = $crud->render();
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * 
     * 
     * @autor Alexis Beltran
     * @since 19/10/2013
     *
     * @return void
     */
    function regiones() {
        try {

            $crud = new grocery_CRUD();
            $crud->set_table('reg_region')->set_subject('Región');

            $crud
                    ->display_as('reg_nombre', 'Nombre')
                    ->display_as('reg_id_nir', 'Nivel')
                    ->display_as('reg_codigo', 'Codigo')
                    ->display_as('reg_abr', 'Abreviación')
                    ->display_as('reg_desc', 'Descripción')
                    ->display_as('reg_padre', 'Padre')
                    ->columns('reg_id_nir', 'reg_nombre', 'reg_codigo', 'reg_abr', 'reg_padre')
                    ->fields('reg_id_nir', 'reg_nombre', 'reg_codigo', 'reg_abr', 'reg_desc', 'reg_padre', 'reg_fecha_mod', 'reg_usu_mod')
                    ->required_fields('reg_id_nir', 'reg_nombre', 'reg_codigo', 'reg_abr')
                    ->field_type('reg_fecha_mod', 'hidden', date('Y-m-d'))
                    ->field_type('reg_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->order_by('reg_padre', 'asc')
                    // ->set_rules('reg_codigo', 'Codigo', 'is_unique[reg_region.reg_codigo]')
                    ->callback_before_update(array($this, '_unique_edit'))
                    ->callback_before_insert(array($this, '_unique_add'))
                    ->set_lang_string('update_error', 'Error!\nAlguno de los siguientes criterios no se está cumpliendo:\n\n*El campo -Codigo- no debe repetirse.\n*El campo -Nombre- no debe repetirse simultaneamente')
                    ->set_lang_string('insert_error', 'Error!\nAlguno de los siguientes criterios no se está cumpliendo:\n\n*El campo -Codigo- no debe repetirse.\n*El campo -Nombre- no debe repetirse simultaneamente')
            ;

            $crud->set_relation('reg_id_nir', 'nir_nivel_region', 'nir_nombre');
            $crud->set_relation('reg_padre', 'reg_region', '{reg_id} {reg_nombre}');
            //$crud->callback_after_insert(array($this,'refrescarPadre'));


            /* $this->load->helper('url');
              if ($crud->getState() == 'success')
              {
              $state_info  = $crud->getStateInfo();
              $primary_key = $state_info->primary_key;
              if ($primary_key == 1)
              {
              //redirect('sistema/catalogos/regiones/add', 'refresh');
              redirect($this->uri->uri_string());
              }
              //redirect($this->uri->uri_string());
              } */

            $output = $crud->render();
            $this->_cargarvista(null, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function _unique_edit($post_array, $primary_key) {

        $id = end(explode("/", $_SERVER['REQUEST_URI']));

        $result = $this->model->get_tabla_reg('reg_region', array(
            'reg_codigo' => $post_array['reg_codigo'],
            'reg_id!=(' . $id . ')' => null
                )
        );

        $result2 = $this->model->get_tabla_reg('reg_region', array(
            'reg_nombre' => $post_array['reg_nombre'],
            'reg_id!=(' . $id . ')' => null
                )
        );


        if ((count($result2) <= 0) && (count($result) <= 0)) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function _unique_add($post_array, $primary_key) {

        $id = end(explode("/", $_SERVER['REQUEST_URI']));

        $result = $this->model->get_tabla_reg('reg_region', array(
            'reg_codigo' => $post_array['reg_codigo'],
            'reg_nombre' => $post_array['reg_nombre']
                )
        );

        if ((count($result) <= 0)) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function refrescarPadre($post_array, $primary_key) {
        $padres = $this->sistema->refrescar_padre();
        $option = '';
        foreach ($padres as $key) {
            $option .= '<option value="' . $key['reg_id'] . '"">' . $key['reg_id'] . ' ' . $key['reg_nombre'] . '</option>';
        }
        print_r($option);
    }

    /**
     * 
     * 
     * @autor Antonio Escobar
     * @since 23/10/2013
     *
     * @return void
     */
    function nivel_regiones() {
        try {

            $crud = new grocery_CRUD();
            $crud->set_table('nir_nivel_region')->set_subject('Nivel de Región');

            $crud
                    ->display_as('nir_nombre', 'Nombre')
                    ->columns('nir_nombre')
                    ->fields('nir_nombre', 'nir_usu_mod', 'nir_fecha_mod')
                    ->required_fields('nir_nombre')
                    ->field_type('nir_fecha_mod', 'hidden', date('Y-m-d'))
                    ->field_type('nir_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->set_rules('nir_nombre', 'Nombre', 'is_unique[nir_nivel_region.nir_nombre]')
                    ->order_by('nir_id', 'asc')
            ;

            $data['titulo_personal'] = "Nivel de Región";

            $output = $crud->render();

            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function empleados() {
        $this->load->library('../controllers/inventario/mantenimiento');
        satelite_validar();
        $titulo = "Empleadas/os";
        $this->mantenimiento->empleado($titulo);
    }

    function plazas() {
        $this->load->library('../controllers/expediente_personal/catalogos');
        satelite_validar();
        //$titulo
        $this->catalogos->plazas(1);
    }

    public function agregar_plaza()
    {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->agregar_plaza();
    }

    public function editar_plaza($plz_id, $ver = null, $modulo = null, $ruta = null)
    {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->editar_plaza($plz_id, $ver, $modulo, $ruta);
    }
    

    function areas() {
        $this->load->library('../controllers/expediente_personal/catalogos');
        satelite_validar();
        $this->catalogos->area_empresa();
    }

    function sucursal() {
        $this->load->library('../controllers/expediente_personal/catalogos');
        satelite_validar();
        $this->catalogos->sucursal();
    }

    function duplicar_plaza($id_plaza = null) {
        satelite_validar();
        $cantidad = 0;
        $ajax = false;
        if ($id_plaza == null) {
            $ajax = true;
            $id_plaza = $this->input->post('id_plaza');
            $cantidad = $this->input->post('cantidad');
        } else {
            $id_plaza = $id_plaza;
            $cantidad = 1;
        }

        //die(print_r($id_plaza.'/'.$cantidad));
        $this->gsatelite->verificar_registro_real('plz_plaza', $id_plaza);
        $reg = $this->gsatelite->get_tabla('plz_plaza', array('plz_id' => $id_plaza));
        $reg = $reg[0];
        //die(print_r($reg));

        $exito = 0;
        for ($i = 0; $i < $cantidad; $i++) {
            $detalle = array(
                'plz_nombre' => $reg['plz_nombre'],
                'plz_id_pto' => $reg['plz_id_pto'],
                'plz_id_are' => $reg['plz_id_are'],
                'plz_salario_base' => $reg['plz_salario_base'],
                'plz_id_padre' => $reg['plz_id_padre'],
                'plz_estado' => $reg['plz_estado'],
                'plz_usu_mod' => $this->tank_auth->get_user_id(),
                'plz_fecha_mod' => date('Y-m-d H:i:s'),
                'plz_id_cec' => $reg['plz_id_cec'],
                'plz_horario' => $reg['plz_horario']
            );
            $id = $this->gsatelite->ingresar('plz_plaza', $detalle);
            if ($id > 0) {
                $exito++;
            }
        }
        if ($exito > 0) {
            $alerta = array(
                'tipo_alerta' => 'success'
                , 'titulo_alerta' => 'Éxito'
                , 'texto_alerta' => "<b>$exito</b> Nueva(s) plaza(s) / cargo(s) funcional(es) duplicada(s) con éxito."
            );
            $this->session->set_flashdata($alerta);
        }
        if ($ajax) {
            echo json_encode(array('exito' => $exito));
            die();
        } else {

            if ($id > 0) {
                $this->gsatelite->show_dialog('Nueva plaza / cargo funcional ingresada con éxito.', 'estructura_organizativa/procesos/plazas');
            } else {
                $this->gsatelite->show_dialog('Error en duplicar plaza / cargo funcional', 'estructura_organizativa/procesos/plazas', 'error');
            }
        }
    }

    function centros_costo() {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/mantenimientos');
        $this->mantenimientos->centro_costos('inventario/mantenimiento', 'centros_costo');
    }

    function puesto() {
        /*$this->load->library('../controllers/expediente_personal/catalogos');
        satelite_validar();
        //$titulo
        $this->catalogos->puesto();*/
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->puestos('sistema/catalogo');
    }

    /**
     * Descripción:
     * Función para agregar puesto (tabla pto_puesto)
     * @author Mario Marquez - Grupo Satélite
     * @since 2022-10-27
     * @param Ninguno
     * @return Obtener la vista para agregar un puesto
     */
    function agregar_puesto() {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->agregar_puesto('sistema/catalogo', 'puesto');
    }

    /**
     * Descripción:
     * Función para agregar puesto (tabla pto_puesto)
     * @author Mario Marquez - Grupo Satélite
     * @since 2022-10-27
     * @param Ninguno
     * @return Obtener la vista para editar puesto
     */
    function editar_puesto($pto_id = null) {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->editar_puesto($pto_id, 'sistema/catalogo', 'puesto');
    }

    /**
     * Descripción:
     * Función para agregar puesto (tabla pto_puesto)
     * @author Mario Marquez - Grupo Satélite
     * @since 2022-10-27
     * @param Ninguno
     * @return Obtener la vista para editar puesto
     */
    function eliminar_puesto($pto_id = null) {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->eliminar_puesto($pto_id, 'sistema/catalogo', 'puesto');
    }



    public function departamentos($ruta_vista = null) {
        satelite_validar();

        //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
        $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'sistema/catalogo/departamentos'; //cuando viene la petición de otro modulo.
        $arreglo_url = explode('/', $ruta_permisos);
        $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
        $ruta_vista = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('dep_departamento');
            $crud->set_subject('');

            $columnas = array(
                'dep_id',
                'dep_nombre',
                'dep_id_pai',
                'dep_estado'
            );

            $add_fields = array(
                'dep_nombre',
                'dep_id_pai',
                'dep_estado',
                'dep_usu_creacion',
                'dep_usu_modificacion',
                'dep_fecha_creacion',
                'dep_fecha_modificacion'
            );

            $edit_fields = array(
                'dep_nombre',
                'dep_id_pai',
                'dep_estado',
                'dep_usu_modificacion',
                'dep_fecha_modificacion'
            );

            $display_as = array(
                'dep_id' => 'ID',
                'dep_nombre' => 'Nombre',
                'dep_id_pai' => 'País',
                'dep_estado' => 'Estado',
                'dep_usu_creacion' => 'Usuario Creacion',
                'dep_usu_modificacion' => 'Usuario Modificacion',
                'dep_fecha_creacion' => 'Fecha Creacion',
                'dep_fecha_modificacion' => 'Fecha Modificacion'
            );

            $crud->field_type('dep_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('dep_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->required_fields('dep_nombre', 'dep_estado');
            $crud->set_rules('dep_nombre', 'Nombre', 'callback_validar_nombre_departamento|required');
            $crud->set_relation('dep_id_pai', 'pai_pais', 'pai_nombre', array('pai_estado' => 1));

            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);

            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('dep_estado', 'hidden', 1);
                $crud->field_type('dep_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('dep_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('dep_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            } else {
                $crud->add_action('Municipios', 'icomoon-icon-clipboard-3', '', 'ver-accion-modal', function($primary_key, $row) {
                    return base_url() . 'sistema/catalogo/municipios/' . $row->dep_id . '/1';
                });
                $crud->add_action('Zonas', 'icomoon-icon-map', '', 'ver-accion-modal', function($primary_key, $row) {
                    return base_url() . 'sistema/catalogo/zona_departamento/' . $row->dep_id . '/1';
                });
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }


            $output = $crud->render();
            $data['titulo_personal'] = "Departamentos";
            $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'sistema/catalogo/departamentos';
            cargarvista($data, $output, $ruta_vista);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function validar_nombre_departamento() {
        $post_array = $this->input->post();
        $nombre = $post_array['dep_nombre'];
        $pais = ($post_array['dep_id_pai'] != '') ? $post_array['dep_id_pai'] : null;

        $urlx = explode('/', uri_string());
        if (!is_numeric(end($urlx))) {
            $where = array('dep_nombre' => $nombre, 'dep_id_pai' => $pais);
            $count = $this->gsatelite->count('dep_departamento', $where);
        } else {
            $id = end($urlx);
            $where = 'dep_nombre  = "' . $nombre . '" AND dep_id_pai = ' . $pais . " AND dep_id <> " . $id;
            $count = $this->gsatelite->count('dep_departamento', $where);
        }

        if ($count > 0) {
            $this->form_validation->set_message('validar_nombre_departamento', 'El %s debe ser uníco por País.');
            return false;
        } else {
            return true;
        }
    }

    public function municipios($departamento = null, $ver_modal = null, $ruta_vista = null) {
        satelite_validar();
        //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
        $ruta_permisos = (is_array($ruta_vista) || $ruta_vista != null) ? $ruta_vista[0] : 'sistema/catalogo/municipios'; //cuando viene la petición de otro modulo.
        $arreglo_url = explode('/', $ruta_permisos);
        $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
        $ruta_vista = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

        $departamento_data = $this->gsatelite->get_tabla('dep_departamento', array('dep_id' => $departamento));


        try {
            $permisos = $this->gsatelite->get_permisos_opcion('sistema/catalogo/departamentos');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('mun_municipio');
            $crud->set_subject('Municipios - ' . $departamento_data[0]['dep_nombre']);

            $columnas = array(
                'mun_id',
                'mun_nombre',
                'mun_id_dep',
                'mun_estado'
            );

            $add_fields = array(
                'mun_nombre',
                'mun_id_dep',
                'mun_estado',
                'mun_usu_creacion',
                'mun_usu_modificacion',
                'mun_fecha_creacion',
                'mun_fecha_modificacion'
            );

            $edit_fields = array(
                'mun_nombre',
                'mun_id_dep',
                'mun_estado',
                'mun_usu_modificacion',
                'mun_fecha_modificacion'
            );

            $display_as = array(
                'mun_id' => 'ID',
                'mun_nombre' => 'Nombre',
                'mun_id_dep' => 'Departamento',
                'mun_estado' => 'Estado',
                'mun_usu_creacion' => 'Usuario Creacion',
                'mun_usu_modificacion' => 'Usuario Modificacion',
                'mun_fecha_creacion' => 'Fecha Creacion',
                'mun_fecha_modificacion' => 'Fecha Modificacion'
            );

            $crud->field_type('mun_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('mun_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('mun_id_dep', 'hidden', $departamento);
            $crud->required_fields('mun_id_dep', 'mun_nombre', 'mun_estado');
            $crud->set_rules('mun_nombre', 'Nombre', 'campo_unico2[mun_municipio.mun_nombre.mun_id_dep.' . $departamento . ']|required');
            $crud->where('mun_id_dep', $departamento);


            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);

            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('mun_estado', 'hidden', 1);
                $crud->field_type('mun_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('mun_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('mun_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if ($state = $crud->getState() != 'add' || $state = $crud->getState() != 'edit') {
                $crud->set_relation('mun_id_dep', 'dep_departamento', 'dep_nombre', array('dep_estado' => 1));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de municipios";

            if ($ver_modal != null) {
                $this->gsatelite->cargar_vista_masterpage('sistema/catalogo/municipios', $data, $output);
            } else {
                cargarvista($data, $output, $ruta_vista);
            }
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function gestion_bancos(){
        satelite_validar();
        try{
            $crud = new grocery_CRUD;
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud->set_table('ban_banco');
            $crud->set_subject('Bancos');
            $crud->columns('ban_nombre','ban_prefijo','ban_sufijo','ban_contacto','ban_estado');
            $crud->display_as('ban_nombre','Nombre');
            $crud->display_as('ban_estado','Estado');
            $crud->display_as('ban_contacto','Ejecutivo');
            $crud->display_as('ban_telefono','Teléfono');
            $crud->display_as('ban_observacion','Observaciones');
            $crud->display_as('ban_prefijo','Prefijo de chequera');
            $crud->display_as('ban_sufijo','Sufijo de chequera');
            $urlx = explode('/',uri_string());
            if(end($urlx)=='add') {
                $crud->field_type('ban_estado','hidden',1);
            } else {
                $crud->field_type('ban_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            $crud->required_fields('ban_nombre');
            $crud->add_fields('ban_nombre','ban_prefijo','ban_sufijo','ban_contacto','ban_telefono','ban_observacion','ban_estado');
            $crud->edit_fields('ban_nombre','ban_prefijo','ban_sufijo','ban_contacto','ban_telefono','ban_observacion','ban_estado');
            $crud->field_type('ban_usu_mod','hidden',$this->tank_auth->get_user_id());
            $crud->field_type('ban_fecha_mod','hidden',date('Y-m-d H:i:s'));
            $crud->set_rules('ban_nombre','Nombre','trim|required|campo_unico[ban_banco.ban_nombre]');
            $crud->set_language('spanish');
            $data['titulo_personal']="Bancos";
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }
            $output = $crud->render();
            $this->_cargarvista($data, $output);
        } catch(Exception $e) {
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }
    }
    
    public function zona_departamento($departamento = null, $ver_modal = null, $ruta_vista = null) {
        satelite_validar();
        //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
        $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'sistema/catalogo/zona_departamento'; //cuando viene la petición de otro modulo.
        $arreglo_url = explode('/', $ruta_permisos);
        $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
        $ruta_vista = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

        $departamento_data = $this->gsatelite->get_tabla('dep_departamento', array('dep_id' => $departamento));

        try {
            $permisos = $this->gsatelite->get_permisos_opcion('sistema/catalogo/departamentos');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('zod_zona_departamento');
            $crud->set_subject('Zonas - ' . $departamento_data[0]['dep_nombre']);

            $columnas = array(
                'zod_nombre',
                'zod_id_dep',
                'zod_estado'
            );

            $add_fields = array(
                'zod_nombre',
                'zod_id_dep',
                'zod_estado',
                'zod_usu_creacion',
                'zod_usu_modificacion',
                'zod_fecha_creacion',
                'zod_fecha_modificacion'
            );

            $edit_fields = array(
                'zod_nombre',
                'zod_id_dep',
                'zod_estado',
                'zod_usu_modificacion',
                'zod_fecha_modificacion'
            );

            $display_as = array(
                'zod_nombre' => 'Nombre',
                'zod_id_dep' => 'Departamento',
                'zod_estado' => 'Estado',
                'zod_usu_creacion' => 'Usuario Creacion',
                'zod_usu_modificacion' => 'Usuario Modificacion',
                'zod_fecha_creacion' => 'Fecha Creacion',
                'zod_fecha_modificacion' => 'Fecha Modificacion'
            );

            $crud->field_type('zod_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('zod_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('zod_id_dep', 'hidden', $departamento);
            $crud->required_fields('zod_id_dep', 'zod_nombre', 'zod_estado');
            $crud->set_rules('zod_nombre', 'Nombre', 'campo_unico2[zod_zona_departamento.zod_nombre.zod_id_dep.' . $departamento . ']|required');
            $crud->where('zod_id_dep', $departamento);

            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);

            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('zod_estado', 'hidden', 1);
                $crud->field_type('zod_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('zod_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('zod_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if ($state = $crud->getState() != 'add' || $state = $crud->getState() != 'edit') {
                $crud->set_relation('zod_id_dep', 'dep_departamento', 'dep_nombre', array('dep_estado' => 1));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de municipios";

            if ($ver_modal != null) {
                $this->gsatelite->cargar_vista_masterpage('sistema/catalogo/zona_departamento', $data, $output);
            } else {
                cargarvista($data, $output, $ruta_vista);
            }
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }


    /**
     * @author Edith Herrera
     * @since  2018-02-14
     * @return Grid del mantenimiento de empresa.
    * */
    function empresa() {
        satelite_validar();
        $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

        $add_fields= array(
            'emr_codigo',
            'emr_nombre',
            'emr_siito_web',
            'emr_correo',
            'emr_telefono',
            'emr_nit',
            'emr_numero_registro',
            'emr_numero_patronal',
            'emr_direccion',
            'emr_pbx',
            'emr_descripcion',
            'emr_valores',
            'emr_mision',
            'emr_vision',
            'emr_id_gir',
            'emr_estado',
            'emr_usu_creacion',
            'emr_fecha_creacion',
            'emr_usu_modificacion',
            'emr_fecha_modificacion'
        );

       $edit_fields= array(
            'emr_codigo',
            'emr_nombre',
            'emr_siito_web',
            'emr_correo',
            'emr_telefono',
            'emr_nit',
            'emr_numero_registro',
            'emr_numero_patronal',
            'emr_direccion',
            'emr_pbx',
            'emr_descripcion',
            'emr_valores',
            'emr_mision',
            'emr_vision',
            'emr_id_gir',
            'emr_estado',
            'emr_usu_modificacion',
            'emr_fecha_modificacion'
        );

       $req_fields= array(
            'emr_codigo',
            'emr_nombre',            
            'emr_estado',
            'emr_usu_modificacion',
            'emr_fecha_modificacion'
        );

       $columns = array(
            'emr_codigo', 
            'emr_nombre', 
            'emr_id_gir', 
            'emr_correo',
            'emr_descripcion',
            'emr_estado'
        );

       $alias = array(
            'emr_codigo' => 'Código',
            'emr_nombre' => 'Nombre',
            'emr_direccion' => 'Dirección',
            'emr_telefono' => 'Teléfono',
            'emr_correo' => 'Correo',
            'emr_nit' => 'NIT',
            'emr_numero_registro' => 'Número de Registro',
            'emr_numero_patronal' => 'Número Patronal',
            'emr_estado' => 'Estado',
            'emr_siito_web' => 'Sitio Web',
            'emr_valores' => 'Valores',
            'emr_mision' => 'Misión',
            'emr_vision' => 'Visión',
            'emr_pbx' => 'PBX',
            'emr_id_gir' => 'Giro',
            'emr_descripcion' => 'Descripción'
       );

        $crud = new grocery_CRUD();
        $crud->set_table('emr_empresa')
                ->set_subject('Empresa')
                ->columns($columns)
                ->display_as($alias)
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($req_fields)
                ->field_type('emr_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('emr_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('emr_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('emr_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('emr_nombre', 'Nombre', 'trim|required|campo_unico[emr_empresa.emr_nombre]')
                ->set_rules('emr_correo', 'Correo', 'trim|valid_email')
                ->set_relation('emr_id_gir', 'gir_giro', 'gir_nombre', array('gir_estado' => 1))
        ;       

                // AGREGAR EL CÓDIGO SEGÚN CORRELATIVO.
                $crud->callback_add_field('emr_codigo', function () {
                    $tabla='emr_empresa';
                    $campo='emr_codigo';
                    $last=$this->consultas->get_max_codigo($tabla,$campo);

                    $code=$last->codigo;
                    $cod= (int)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

                    return '<input id="field-emr_codigo" name="emr_codigo" type="text" readonly maxlength="99" value="'.$codigo.'" >';
                });

                $crud->callback_edit_field('emr_codigo', function ($value, $primary_key) {
                    if($value==''){
                      $tabla='emr_empresa';
                      $campo='emr_codigo';
                      $last=$this->consultas->get_max_codigo($tabla,$campo);

                      $code=$last->codigo;
                      $cod= (int)$code+1;
                      $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                      return '<input id="field-emr_codigo" name="emr_codigo" type="text" readonly maxlength="99" value="'.$codigo.'" >';
                    }else{
                       return '<input id="field-emr_codigo" name="emr_codigo" type="text" readonly maxlength="99" value="'.$value.'" >';
                    }
                });

                $crud->add_action('Configurar', 'icon16 icomoon-icon-list-view ', 'sistema/catalogo/configuracion_empresa', 'fancybox_modal');

                $crud->add_action('Formularios', 'icon16 icomoon-icon-list-view ', 'sistema/configuraciones/configura_formularios', 'fancybox_modal');

                $state = $crud->getState();
                if($state== 'success'){
                    $crud->callback_field('emr_codigo', function ($value, $primary_key) {
                        if($value==''){
                          $tabla='emr_empresa';
                          $campo='emr_codigo';
                          $last=$this->consultas->get_max_codigo($tabla,$campo);

                          $code=$last->codigo;
                          $cod= (int)$code+1;
                          $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                          return '<input id="field-emr_codigo" name="emr_codigo" type="text" readonly maxlength="99" value="'.$codigo.'" >';
                        }else{
                           return '<input id="field-emr_codigo" name="emr_codigo" type="text" readonly maxlength="99" value="'.$value.'" >';
                        }
                    });
                }
        $urlx = explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->field_type('emr_estado', 'hidden', 1);
        } else {
            $crud->field_type('emr_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }


        $output = $crud->render();

        $data['titulo_personal'] = "Empresa";

        //$this->_cargarvista($data, $output);
        cargarvista($data, $output, "sistema/catalogo/empresa");
    }

     public function cambio_empresa_session()
     {
        satelite_validar();
        if ($this->input->post('slcEmpresa_session') > 0 ) {
            $registro_emp = $this->gsatelite->get_registro('emr_empresa', array('emr_id'=>$this->input->post('slcEmpresa_session')));
            $this->session->set_userdata($this->tank_auth->prefijo_sys.'company', $this->input->post('slcEmpresa_session'));
            $this->session->set_userdata($this->tank_auth->prefijo_sys.'company_row', $registro_emp);
            
            $url =  $_SERVER['HTTP_REFERER'];
            if (trim($url) != "") $url = current(explode('/',str_replace(base_url(), '', $url)));
            else $url = "";

            if ($_SERVER['HTTP_REFERER'] != base_url() ) {
                $url = $url ."/index";
            }

            //Crear alerta para confirmación
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cambio efectuado con éxito", 'texto_alerta' => "Se ha cambiado de empresa correctamente");
            $this->session->set_flashdata($alerta);
            $url_modulo_refresh = base_url($url);
           die(json_encode(array('url_modulo_refresh'=>$url_modulo_refresh)));

        }
         $data['slcEmpresa'] = $this->gsatelite->get_dropdown_empresa();
         $html = $this->load->view('sistema/catalogo/cambio_empresa_session', $data, true);
         echo $html;
    }

    /**
    * @author Francisco Orozco
    * @since  2019-01-24
    * @return mantenimiento de monedas
    **/
    public function monedas() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        
        $crud =  new grocery_CRUD();
        $columns = array(
            'mon_nombre',
            'mon_simbolo',
            'mon_conversion',
            'mon_id_pai', 
            'mon_descripcion',
            'mon_defecto',
            'mon_estado'
        );

        $alias = array(
            'mon_nombre'        => 'Nombre',
            'mon_simbolo'       => 'Símbolo',
            'mon_conversion'    => 'Conversión',
            'mon_id_pai'        => 'País', 
            'mon_descripcion'   => 'Descripción',
            'mon_defecto'       => 'Por defecto', 
            'mon_estado'        => 'Estado'
        );

        $add_fields = array(
            'mon_nombre',
            'mon_simbolo',
            'mon_conversion',
            'mon_id_pai', 
            'mon_descripcion',
            'mon_defecto',
            'mon_estado',
            'mon_usu_creacion',
            'mon_fecha_creacion',
            'mon_usu_modificacion',
            'mon_fecha_modificacion'
        );

        $edit_fields = array(
            'mon_nombre',
            'mon_simbolo',
            'mon_conversion',
            'mon_id_pai', 
            'mon_descripcion',
            'mon_defecto',
            'mon_estado',
            'mon_usu_modificacion',
            'mon_fecha_modificacion'
        );

        $required = array(
            'mon_nombre',
            'mon_simbolo',            
            'mon_id_pai', 
            'mon_defecto',
            'mon_estado',
            'mon_usu_modificacion',
            'mon_fecha_modificacion'
        );

        $crud->set_table('mon_moneda')
            ->set_subject('Monedas')
            ->display_as($alias)
            ->columns($columns)
            ->add_fields($add_fields)
            ->edit_fields($edit_fields)
            ->required_fields($required)
            ->set_relation('mon_id_pai', 'pai_pais', 'pai_nombre', array('pai_estado' => 1))
            ->field_type('mon_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('mon_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))            
            ->callback_add_field('mon_defecto', function() {
                return '<input type="checkbox" id="chkvalidar" class="nostyle"><input type="hidden" id="field-mon_defecto" name="mon_defecto" value="0">';
            })
            ->callback_edit_field('mon_defecto', function($value, $primary_key) {
                $leer    = ($this->uri->rsegments[3] == 'read')?'readonly ':'';
                $defecto = ($value)?'checked':''; 
                return '<input type="checkbox" id="chkvalidar" '.$defecto.' class="nostyle" '.$leer.'><input type="hidden" id="field-mon_defecto" name="mon_defecto" value="'.$value.'">';
            })
            ->callback_column('mon_defecto',function($value, $primary_key) {
                if ($value == 1) {
                    return 'Si';
                } else {
                    return 'No';
                }
            })
            ->callback_before_insert(array($this,'resetear_moneda_defecto'))
            ->callback_before_update(array($this,'resetear_moneda_defecto'))
            ->unset_delete()
        ;

        $urlx = explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->field_type('mon_estado', 'hidden', 1)
                    ->field_type('mon_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('mon_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('mon_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        } 

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }
     
        $output = $crud->render();
        $data['titulo_personal'] = "Monedas";
        $this->_cargarvista($data, $output);
    }

    function resetear_moneda_defecto($post_array, $primary_key) {
        if( $post_array['mon_defecto'] == 1) {          
            $registro = $this->gsatelite->actualizar_array('mon_moneda', array("mon_defecto" => 0),array());
        }    
        return $post_array;
    }

    
    /**
    * @author Francisco Orozco
    * @since  2019-01-31
    * @return historico de taza de cambio 
    **/
    public function tasa_cambio() {
        satelite_validar();
        $permisos       = $this->gsatelite->get_permisos_opcion();
        $moneda_defecto = $this->gsatelite->get_tabla("mon_moneda",array("mon_estado" => 1 , "mon_defecto" => 1));
        $crud           =  new grocery_CRUD();
        $columns = array(
            'htc_id_mon',
            'htc_conversion',          
            'htc_fecha_desde', 
            'htc_fecha_hasta', 
            'htc_observacion',
            //'htc_estado'
        );

        $alias = array(
            'htc_id_mon'        => 'Moneda',
            'htc_id_mon_defecto'=> 'Defecto',
            'htc_observacion'   => 'Observación', 
            'htc_conversion'    => 'Conversión',         
            'htc_fecha_desde'   => 'Desde', 
            'htc_fecha_hasta'   => 'Hasta'
        );

        $add_fields = array(    
            'htc_id_mon_defecto',
            'htc_fecha_desde',
            'htc_conversion',
            'htc_id_mon', 
            'htc_fecha_hasta',
            'htc_observacion', 
            'htc_usu_creacion',
            'htc_fecha_creacion',
            'htc_usu_modificacion',
            'htc_fecha_modificacion',
            //'htc_estado'
        );

        $edit_fields = array(
            'htc_id_mon_defecto',
            'htc_fecha_desde',
            'htc_conversion',
            'htc_id_mon',
            'htc_fecha_hasta',
            'htc_observacion', 
            //'htc_estado',
            'htc_usu_modificacion',
            'htc_fecha_modificacion',
        );

        $required = array(
            'htc_id_mon_defecto',
            'htc_id_mon',
            'htc_conversion',
            'htc_fecha_desde',
            'htc_fecha_hasta',
            'htc_usu_modificacion',
            'htc_fecha_modificacion'
        );

        $crud->set_table('htc_historico_taza_cambio')
            ->set_subject('Tasa de cambio')
            ->display_as($alias)
            ->columns($columns)
            ->add_fields($add_fields)
            ->edit_fields($edit_fields)
            ->required_fields($required)
            ->set_relation('htc_id_mon', 'mon_moneda', 'mon_nombre', array('mon_estado' => 1))
            ->set_relation('htc_id_mon_defecto', 'mon_moneda', 'mon_nombre', array('mon_estado' => 1, 'mon_defecto' => 1))
            ->field_type('htc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('htc_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))            
            ->unset_delete()
        ;

        $urlx = explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->field_type('htc_estado', 'hidden', 1)
                    ->field_type('htc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('htc_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('htc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        } 

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }
     
        $output = $crud->render();
        $data['titulo_personal'] = "Tasa de cambio";
        $data['decimales']       = $this->gsatelite->get_parametro("NUMERO_DECIMALES","2");
        $this->_cargarvista($data, $output);
    }

    /**
        * Descripción:
        * clasificacion de los pacientes
        * @author Francisco Orozco - Grupo Satélite
        * @since 2019-09-12
        * @param ninguno
        * @return Mantenimiento de giro comercial
    */
    public function giro_comerciales() {
        satelite_validar();
        $this->load->library('../controllers/modulo_compras/catalogos');
        $this->catalogos->giro_comercial('sistema/catalogo');
    }
         

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    function telefonos() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $data['permisos'] = $permisos;
            $crud = new grocery_CRUD();
            $crud->set_subject('Teléfono');
            $crud->set_table('tit_tipo_telefono');
            $columns = array('tit_nombre', 'tit_mascara', 'tit_estado');
            $add_columns = array('tit_nombre', 'tit_mascara', 'tit_estado', 'tit_usu_mod', 'tit_fecha_mod', 'tit_usu_crea', 'tit_fecha_crea');
            $edit_columns = $add_columns;
            $alias = array(
                'tit_nombre' => 'Nombre',
                'tit_mascara' => 'Máscara',
                'tit_estado' => 'Estado');
            $crud->display_as($alias)
                    ->columns($columns)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->field_type('tit_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('tit_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('tit_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('tit_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->set_rules('tit_nombre', 'Nombre', 'campo_unico[pai_pais.pai_nombre]|required')
                    ->required_fields('tit_nombre', 'tit_mascara', 'tit_estado');
                    // ->field_type('pai_defecto', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('tit_estado', 'hidden', 1);
            }else{
                $crud->field_type('tit_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }else{
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }     

            $output = $crud->render();
            $data['titulo_personal'] = "Teléfonos";
            cargarvista($data, $output, 'sistema/catalogo/pais');
        }
    }

    function configuracion_empresa($id_empresa){
        satelite_validar();
        $data['parametros'] = $this->gsatelite->get_tabla("prm_parametro_empresa", array('prm_id_emr' => $id_empresa, 'prm_estado' => 1));
        //print_r($data['parametros']);die();
        $this->gsatelite->cargar_vista_masterpage('sistema/catalogo/configuracion_empresa',$data);
    }

    function actualizar_parametros($esjson = null){
        satelite_validar();
        if ($_POST) {
            $prm_id = $this->input->post('id');
            $valor = (trim($this->input->post('valor')) != "") ? $this->input->post('valor') : null;
            if ($esjson) {
                $dato = str_replace(array('[', ']'), '', $valor);
                $valor = $dato;
            }
            $exito = $this->gsatelite->actualizar('prm_parametro_empresa', array("prm_valor" => $valor), 'prm_id', $prm_id);
            echo $exito;
            die();
        }
    }

    public function cambio_sucursal_session(){
       satelite_validar();
       if ($this->input->post('slc_sucursal_session') > 0 ) {           
            $sucursal       = $this->input->post('slc_sucursal_session');      
            $this->db->join('usc_usuario_sucursal','usc_id_suc = suc_id');
            $this->db->group_by('suc_id');
            $sucursal_row   = $this->gsatelite->get_registro('suc_sucursal', array('suc_id' => $sucursal ) );
            //print_r($this->db->last_query()); die();
            $this->session->set_userdata($this->tank_auth->prefijo_sys.'branch_office', $sucursal);
            $this->session->set_userdata($this->tank_auth->prefijo_sys.'branch_office_row', $sucursal_row);

            //se quita todas las sucursales por defecto que tengan ligadas el usuario
            $this->gsatelite->actualizar_array('usc_usuario_sucursal', array("usc_defecto" => 0), array('usc_id_usu'=>$this->tank_auth->get_user_id()));
            //se le asigna por defecto a un usuario la sucursual seleccionada para al inicio de seccion aparesca ya seleccionada
            $this->gsatelite->actualizar_array('usc_usuario_sucursal', array("usc_defecto" => 1), array('usc_id_usu'=>$this->tank_auth->get_user_id(),"usc_id_suc" => $sucursal));

            $url =  $_SERVER['HTTP_REFERER'];
            if (trim($url) != "") $url = current(explode('/',str_replace(base_url(), '', $url)));
            else $url = "";

            if ($_SERVER['HTTP_REFERER'] != base_url() ) {
                $url = $url ."/index";
            }
            
            //Crear alerta para confirmación
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cambio efectuado con éxito", 'texto_alerta' => "Se ha cambiado la sucursal correctamente");
            $this->session->set_flashdata($alerta);
            $url_modulo_refresh = base_url($url);
            die(json_encode(array('url_modulo_refresh'=>$url_modulo_refresh)));
        }
            $usuario                = $this->tank_auth->get_user_id();            
            $this->db->join('usc_usuario_sucursal','usc_id_suc = suc_id','inner');
            $sucursales             = $this->gsatelite->get_tabla('suc_sucursal', array('usc_id_usu' => $usuario) );            
            $data['sucursales']     = $sucursales;
            $html = $this->load->view('sistema/catalogo/cambio_sucursal_session', $data, true);
            echo $html;
    }

    public function bk_db()//lamando libreria para hacer hacer backup
    {
        include (APPPATH."libraries/myphp-backup.php");
        $phpbak = new Backup_Database('', '', '', '');
    }
    public function backup()//llamdno vista
    {
        cargarvista("sistema/catalogo/backup");  
    }
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */