<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Acceso extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('sistema');
        $this->load->model('consultas');
        $this->load->model('gsatelite');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function roles() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permiso = $this->gsatelite->get_permisos_opcion();
                $crud = new grocery_CRUD();
                $crud->set_table('rol_rol');
                $crud->set_subject('roles');
                $crud->display_as('rol_nombre', 'Nombre');
                $crud->display_as('rol_descripcion', 'Descripción');
                $crud->display_as('rol_estado', 'Estado');
                $crud->columns('rol_nombre', 'rol_descripcion', 'rol_estado');
                $crud->add_fields('rol_nombre', 'rol_descripcion', 'rol_estado', 'rol_usu_mod', 'rol_fecha_mod');
                $crud->edit_fields('rol_nombre', 'rol_descripcion', 'rol_estado', 'rol_usu_mod', 'rol_fecha_mod');
                $crud->required_fields('rol_nombre', 'rol_descripcion', 'rol_estado');
                $crud->field_type('rol_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
                $crud->field_type('rol_usu_mod', 'hidden', $this->tank_auth->get_user_id());
                $crud->set_rules('rol_nombre', 'Nombre', 'trim|callback_namerol_check_insert|required');
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('rol_estado', 'hidden', 1);
                } else {
                    $crud->field_type('rol_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
                }
                if (!$permiso['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permiso['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permiso['permite_eliminar']) {
                    $crud->unset_delete();
                }
                if (!$permiso['permite_ver']) {
                    $crud->unset_read();
                }
                $output = $crud->render();
                $info['titulo_personal'] = "Roles";
                $this->_cargarvista($info, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function namerol_check_insert($str) {
        $id = end(explode("/", uri_string()));
        if (is_numeric($id)) {
            $username_old = $this->db->where("rol_id", $id)->get('rol_rol')->row()->tia_nombre;
            $num_row = $this->db->where('rol_nombre', $str)->where('rol_id !=', $id)->get('rol_rol')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('namerol_check_insert', 'El nombre del rol ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('rol_nombre', $str)->get('rol_rol')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('namerol_check_insert', 'El nombre del rol ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    function permisos() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {    
            $user = $this->tank_auth->get_user_id();
            $data['rol'] = $this->sistema->cargar_tabla('rol_rol', array('rol_estado' => 1));

            $existe_emr = $this->gsatelite->get_tabla('emr_empresa', array('emr_estado'=>1), array('emr_id', 'ASC'));
            $emp_par = $this->gsatelite->get_parametro('SYS_EMPRESA'); // verificamos que haya registro en el parámetro
            $data['alerta'] = "";
            // Verifica si existe empresa 
            
            if(count($existe_emr)>0){
                                               $this->db->join('emr_empresa', 'emr_id=uxe_id_emr AND emr_estado=1');
                $data['empresa'] = $empresa =  $this->gsatelite->get_tabla('uxe_usuarioxempresa', array('uxe_id_usu'=>$user));
                /******** Si no existe empresa asociada al usuario, se asigna la primer empresa registrada en la BD *******/
                if(count($empresa)<=0){
                    $uxe_emr=array(
                        'uxe_id_emr'=>$existe_emr[0]['emr_id'],
                        'uxe_id_usu'=>$user,
                        'uxe_estado'=>1,
                        'uxe_usu_creacion'=>$this->tank_auth->get_user_id(),
                        'uxe_fecha_creacion'=>date('Y-m-d H:i:s'),
                        'uxe_usu_modificacion'=>$this->tank_auth->get_user_id(),
                        'uxe_fecha_modificacion'=>date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('uxe_usuarioxempresa', $uxe_emr);
                }                
                $data['opc'] = $this->sistema->cargar_menus0();
            }else{ // Si no hay empresa
                /*********************** Si existe parámetro se ingresa la empresa *****************************************/
                if($emp_par!=''){

                    $tabla='emr_empresa';
                    $campo='emr_codigo';
                    $last=$this->consultas->get_max_codigo($tabla,$campo);

                    $code=$last->codigo;
                    $cod= (int)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

                    $arr_emr=array(
                        'emr_codigo'=>$codigo,
                        'emr_nombre'=>$emp_par,
                        'emr_estado'=>1,
                        'emr_usu_creacion'=>$this->tank_auth->get_user_id(),
                        'emr_fecha_creacion'=>date('Y-m-d H:i:s'),
                        'emr_usu_modificacion'=>$this->tank_auth->get_user_id(),
                        'emr_fecha_modificacion'=>date('Y-m-d H:i:s')
                        );

                    $new_emr = $this->gsatelite->ingresar('emr_empresa', $arr_emr);

                    if($new_emr>0){
                        $uxe_emr=array(
                            'uxe_id_emr'=>$new_emr,
                            'uxe_id_usu'=>$user,
                            'uxe_estado'=>1,
                            'uxe_usu_creacion'=>$this->tank_auth->get_user_id(),
                            'uxe_fecha_creacion'=>date('Y-m-d H:i:s'),
                            'uxe_usu_modificacion'=>$this->tank_auth->get_user_id(),
                            'uxe_fecha_modificacion'=>date('Y-m-d H:i:s')
                            );

                        $this->gsatelite->ingresar('uxe_usuarioxempresa', $uxe_emr);
                    }

                    
                    $data['opc'] = $this->sistema->cargar_menus0();
                                    $this->db->join('emr_empresa', 'emr_id=uxe_id_emr AND emr_estado=1');
                    $data['empresa'] = $empresa =  $this->gsatelite->get_tabla('uxe_usuarioxempresa', array('uxe_id_usu'=>$user));

                }else{ // Si no existe en parametro
                    $data['alerta'] = "Es necesario asignar una empresa.";
                }
            }

            $data['titulo_personal'] = "Permisos";
            $this->_cargarvista($data);
        }
    }

    function opciones() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $opciones = $this->sistema->cargar_opcs_validas();
        $opc_vald = implode(',', array_column($opciones, 'opc_id'));
        $edit_fields= array(
            'opc_nombre',
            'opc_descripcion',
            'opc_usu_modificacion',
            'opc_fecha_modificacion'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('opc_opcion')
            ->set_subject('')
            ->columns('modulo_padre', 'opc_nombre', 'opc_descripcion')//'Módulo', 
            ->edit_fields($edit_fields)
            ->required_fields($edit_fields)
            ->display_as('opc_nombre', 'Nombre')
            ->display_as('opc_descripcion', 'Descripción')
            ->display_as('opc_estado', 'Estado')  
            ->display_as('modulo_padre', 'Módulo')
            ->field_type('opc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('opc_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
            ->set_rules('opc_nombre', 'Nombre', 'trim|required|campo_unico[opc_opcion.opc_nombre]')
            ->set_rules('opc_descripcion', 'Descripción', 'trim|required')
            ->where(array("opc_opcion.opc_estado" => 1, "opc_opcion.opc_nivel >" => 0, "opc_padre IN ($opc_vald)" => null))
        ;
        $crud->callback_column('modulo_padre', function ($value, $row) {
            $CI = &get_instance();
            if ($row->opc_nivel > 1) {
                    // HIJA NIVEL 2
                $padre = $CI->gsatelite->get_registro('opc_opcion', array('opc_id' => $row->opc_padre));
                $nivel = $CI->gsatelite->get_campo('opc_opcion', 'opc_nombre', array('opc_id' => $padre->opc_padre));
                $modulo = $nivel . ' > ' . $padre->opc_nombre;
            } else {
                    // MADRE NIVEL 1
                $nivel = $CI->gsatelite->get_campo('opc_opcion', 'opc_nombre', array('opc_id' => $row->opc_padre));
                $modulo = $nivel;
            }
            return $modulo;
        });
        $crud->unset_add();
        $crud->unset_delete();
        if(!$permisos["permite_editar"]){
            $crud->unset_edit();
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }
        $output = $crud->render();
        $data['permisos'] = $permisos;
        $data['titulo_personal'] = "Mantenimiento de Opciones";
        $this->_cargarvista($data, $output);
    }

    function opciones_listado() {
        $post_array = $this->input->post();
        $data['oxr'] = $this->sistema->cargar_opciones($post_array['rol'], $post_array['emr']);
        $data['nivel'] = $post_array['opc'];
                            $this->db->order_by('opc_orden,opc_nombre ASC');
        $data['opciones'] = $this->sistema->cargar_tabla('opc_opcion', array('opc_estado' => 1));
        
        $this->load->view('sistema/acceso/opciones_listado', $data);
    }

    function addopc() {
        $post_array = $this->input->post();
        $this->sistema->add_opc($post_array['rol'], $post_array['opc'], $post_array['empresa']);
    }

    function delopc() {
        $post_array = $this->input->post();
        $this->sistema->del_opc($post_array['rol'], $post_array['opc'], $post_array['empresa']);
    }

    function add_action() {
        $cadena = explode(':', $this->input->post('opc'));
        $rol = $this->input->post('rol');
        $empresa = $this->input->post('empresa');
        $consulta = 0;

        //Formato de $cadena[1] 
        //1=crear, 2=ver, 3=editar, 4=eliminar
        $campo = '';
        switch ($cadena[1]) {
            case '1':
                $campo = 'oxr_insertar';
                break;
            case '2':
                $campo = 'oxr_ver';
                break;
            case '3':
                $campo = 'oxr_editar';
                break;
            case '4':
                $campo = 'oxr_eliminar';
                break;
        }

        $array_update = array(
            $campo => 1
        );

        $this->db->select('opc_id, opc_nombre, opc_nivel, opc_hijo')
                 ->from('opc_opcion')
                 ->where('opc_id', $cadena[0]);

        $query = $this->db->get()->row_array();
        if ($query['opc_nivel'] == '1' && $query['opc_hijo'] == '1') {

            $this->db->select('opc_id, opc_nombre,opc_nivel,opc_hijo')
                    ->from('opc_opcion')
                    ->where('opc_id', $cadena[0])
                    ->or_where('opc_padre', $cadena[0]);

            $query2 = $this->db->get()->result_array();

            if (count($query2) > 0) {
                foreach ($query2 as $key) {
                    $this->gsatelite->actualizar_array('oxr_opcionxrol', $array_update, array('oxr_id_opc' => $key['opc_id'], 'oxr_id_emr' => $empresa, 'oxr_id_rol' => $rol));
                }
            }
        } else {
            $this->gsatelite->actualizar_array('oxr_opcionxrol', $array_update, array('oxr_id_opc' => $cadena[0], 'oxr_id_emr' => $empresa, 'oxr_id_rol' => $rol, 'oxr_estado' => 1));
        }

    }

    // End add_action

    function del_action() {
        $cadena = explode(':', $this->input->post('opc'));
        $rol = $this->input->post('rol');
        $empresa = $this->input->post('empresa');

        //Formato de $cadena[1] 
        //1=crear, 2=ver, 3=editar, 4=eliminar
        $campo = '';
        switch ($cadena[1]) {
            case '1':
                $campo = 'oxr_insertar';
                break;
            case '2':
                $campo = 'oxr_ver';
                break;
            case '3':
                $campo = 'oxr_editar';
                break;
            case '4':
                $campo = 'oxr_eliminar';
                break;
        }

        $array_update = array(
            $campo => 0
        );

        $this->db->select('opc_id, opc_nombre,opc_nivel,opc_hijo')
                 ->from('opc_opcion')
                 ->where('opc_id', $cadena[0]);

        $query = $this->db->get()->row_array();

        if ($query['opc_nivel'] == '1' && $query['opc_hijo'] == '1') {

            $this->db->select('opc_id, opc_nombre,opc_nivel,opc_hijo')
                    ->from('opc_opcion')
                    ->where('opc_id', $cadena[0])
                    ->or_where('opc_padre', $cadena[0]);

            $query2 = $this->db->get()->result_array();

            if (count($query2) > 0) {
                foreach ($query2 as $key) {
                    $this->gsatelite->actualizar_array('oxr_opcionxrol', $array_update, array('oxr_id_opc' => $key['opc_id'], 'oxr_id_emr' => $empresa, 'oxr_id_rol' => $rol));
                }
            }
        } else {
            $this->gsatelite->actualizar_array('oxr_opcionxrol', $array_update, array('oxr_id_opc' => $cadena[0], 'oxr_id_emr' => $empresa, 'oxr_id_rol' => $rol));
        }

        $this->gsatelite->actualizar_array('oxr_opcionxrol', $array_update, array('oxr_id_opc' => $cadena[0], 'oxr_id_emr' => $empresa, 'oxr_id_rol' => $rol, 'oxr_estado' => 1));
    }

    /**
     * @author Melbin Cruz
     */
    function validar_nombre_usuario() {
        $usuario = $this->input->post('usuario');
        $usuario_hid = $this->input->post('usuario_hid');

        if ($usuario_hid == $usuario) {
            echo json_encode(array('respuesta' => 2));
            die(); // Es el mismo ingresado
        }

        if (strpos($usuario, ' ') !== false) {
            echo json_encode(array('respuesta' => 0));
        } else {

            $existe = $this->gsatelite->get_campo('users', 'id', array('username' => $usuario));

            if ($existe > 0) {
                echo json_encode(array('respuesta' => 1)); // Existe
            } else {
                echo json_encode(array('respuesta' => 2)); // No existe
            }
        }
    }

    /**
     * @author Melbin Cruz
     */
    function register_form() {
        satelite_validar();
        if ($_POST) {
            $empleado   = $this->input->post('empleado');
            $usuario    = $this->input->post('usuario');
            $email      = $this->input->post('email');
            $rol        = $this->input->post('rol');
            $empresa    = $this->input->post('empresa');
            $password   = $this->input->post('password');
            $sucursales = $this->input->post('slc_sucursal');
            $pass       = $this->encript_clave($password);
            $datos = array(
                'username' => $usuario,
                'email' => $email,
                'activated' => 1,
                'usu_id_emp' => ($empleado > 0) ? $empleado : null,
                'created' => date('Y-m-d H:i:s'),
                'modified' => date('Y-m-d H:i:s')
            );

            $validacionActiveDirectory = $this->gsatelite->get_parametro_emp('SYS_VALIDAR_ACTIVE_DIRECTORY');

            if ($validacionActiveDirectory == 0) {
                $datos['password'] = $pass['password'];
            }

            $user = $this->gsatelite->ingresar('users', $datos);
            $this->gsatelite->actualizar_array('emp_empleado', array('emp_id_usu' => $user), array('emp_id' => $empleado));
            foreach ($rol as $id) {
                $info = array(
                    'uxr_id_usu' => $user,
                    'uxr_id_rol' => $id
                );
                $this->gsatelite->ingresar('uxr_usuarioxrol', $info);
            }
            if(count($empresa) > 0){
                foreach ($empresa as $emr) {
                    $array_uxe = array(
                        'uxe_id_emr' => $emr,
                        'uxe_id_usu' => $user,
                        'uxe_estado'=>1,
                        'uxe_usu_creacion'=>$this->tank_auth->get_user_id(),
                        'uxe_fecha_creacion'=>date('Y-m-d H:i:s'),
                        'uxe_usu_modificacion'=>$this->tank_auth->get_user_id(),
                        'uxe_fecha_modificacion'=>date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('uxe_usuarioxempresa', $array_uxe);
                }
            }
            if(count($sucursales) > 0 ) {
                foreach ($sucursales as $key => $sucursal) {
                    $usc_usuario_sucursal = array(
                        'usc_id_suc'            => $sucursal,
                        'usc_id_usu'            => $user,
                        'usc_defecto'           => 0,
                        'usc_estado'            => 1,
                        'usc_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'usc_fecha_creacion'    => date('Y-m-d h:i:s'),
                        'usc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'usc_fecha_modificacion'=> date('Y-m-d h:i:s')                   
                    );
                    $this->gsatelite->ingresar('usc_usuario_sucursal', $usc_usuario_sucursal);
                }
            }
            if ($user != 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Creación de usuario", 'texto_alerta' => "Usuario creado correctamente");
            }
            $this->session->set_flashdata($alerta);
            redirect('sistema/acceso/usuarios');
        } else {
            //preguntar por los empleados pendiente de asignar usuarios
            $empleados = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado' => 1));
            $usuarios = $this->gsatelite->get_tabla('users');
            $validacionActiveDirectory = $this->gsatelite->get_parametro_emp('SYS_VALIDAR_ACTIVE_DIRECTORY');

            $users_id = array();
            foreach ($usuarios as $usuario) {
                $users_id[] = $usuario['usu_id_emp'];
            }
            $emp_filtrados = array();
            foreach ($empleados as $key => $value) {
                if (!in_array($value['emp_id'], $users_id)) {
                    $emp_filtrados[] = $empleados[$key];
                }
            }

            $data['validacionActiveDirectory'] = $validacionActiveDirectory;
            $data['consulta_emp'] = $emp_filtrados;
            $data['consulta_rol'] = $this->gsatelite->get_tabla('rol_rol', array('rol_estado' => 1));
            $data['consulta_emr'] = $this->gsatelite->get_tabla('emr_empresa', array('emr_estado' => 1));
            $data['titulo_personal'] = "Usuarios";
            $this->_cargarvista(null, $data);
        }
    }

// End function

    function edit_form($id = null) {
        satelite_validar();
        if ($_POST) {
            $empleado   = $this->input->post('empleado');
            $usuario    = $this->input->post('usuario');
            $email      = $this->input->post('email');
            $rol        = $this->input->post('rol');
            $empresa    = $this->input->post('empresa');
            $estado     = $this->input->post('estado');
            $user_id    = $this->input->post('id');
            $emp_viejo  = $this->input->post('emp_viejo');
            $sucursales = $this->input->post('slc_sucursal');
            $pass = $this->encript_clave($password);            
            $datos = array(
                'username' => $usuario,
                'email' => $email,
                'activated' => $estado,
                'usu_id_emp' => ($empleado > 0) ? $empleado : null,
                'modified' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('users', $datos, array('id' => $user_id));
            if ($emp_viejo != "") {
                $this->gsatelite->actualizar_array('emp_empleado', array('emp_id_usu' => null), array('emp_id' => $emp_viejo));
            }
            $this->gsatelite->actualizar_array('emp_empleado', array('emp_id_usu' => $user_id), array('emp_id' => $empleado));
            $this->gsatelite->borrado_general('uxr_usuarioxrol', array('uxr_id_usu' => $user_id));
            foreach ($rol as $id) {
                $info = array(
                    'uxr_id_usu' => $user_id,
                    'uxr_id_rol' => $id
                );
                $this->gsatelite->ingresar('uxr_usuarioxrol', $info);
            }
            $this->gsatelite->borrado_general('uxe_usuarioxempresa', array('uxe_id_usu' => $user_id));
            if(count($empresa)>0){
                foreach ($empresa as $emr) {
                    $array_uxe = array(
                        'uxe_id_emr' => $emr,
                        'uxe_id_usu' => $user_id,
                        'uxe_estado'=>1,
                        'uxe_usu_creacion'=>$this->tank_auth->get_user_id(),
                        'uxe_fecha_creacion'=>date('Y-m-d H:i:s'),
                        'uxe_usu_modificacion'=>$this->tank_auth->get_user_id(),
                        'uxe_fecha_modificacion'=>date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('uxe_usuarioxempresa', $array_uxe);
                }
            }
            $this->gsatelite->borrado_general('usc_usuario_sucursal', array('usc_id_usu' => $user_id));
            if ( count($sucursales) > 0 ) {
                foreach ($sucursales as $key => $sucursal) {
                    $usc_usuario_sucursal = array(
                        'usc_id_suc'            => $sucursal,
                        'usc_id_usu'            => $user_id,
                        'usc_defecto'           => 0,
                        'usc_estado'            => 1,
                        'usc_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'usc_fecha_creacion'    => date('Y-m-d h:i:s'),
                        'usc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'usc_fecha_modificacion'=> date('Y-m-d h:i:s')                   
                    );
                    $this->gsatelite->ingresar('usc_usuario_sucursal', $usc_usuario_sucursal);
                }
            }
            if ($user_id != 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Modificación de usuario", 'texto_alerta' => "Usuario modificado correctamente");
            }
            $this->session->set_flashdata($alerta);
            redirect('sistema/acceso/usuarios');
        } else {
            $data['id'] = $id;
            $data['titulo_personal'] = "Usuarios";
            $data['usuario']         = $this->gsatelite->get_tabla('users', array('id' => $id));
            $data['usu_rol']         = $this->gsatelite->get_tabla('uxr_usuarioxrol', array('uxr_id_usu' => $id));
            $data['consulta_rol']    = $this->gsatelite->get_tabla('rol_rol', array('rol_estado' => 1));
            $data['empleados']       = $this->sistema->empleado_usuario($data['usuario'][0]['usu_id_emp']);
            $usc_usuario_sucursal    = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $id));
            $users_emr               = $this->gsatelite->get_tabla('uxe_usuarioxempresa', array('uxe_id_usu' => $id)); 
            $empresas                = array_column($users_emr,'uxe_id_emr');
            $suc_id_emr              = "";
            if(count($empresas) > 0) {
                foreach ($empresas as $key => $empresa) {
                    $suc_id_emr .= $empresa.",";
                }
                $suc_id_emr = substr($suc_id_emr, 0, -1);
            }else{
                $suc_id_emr = 0;
            }
            $data['sucursales'] = $this->gsatelite->get_tabla('suc_sucursal', array('suc_id_emr in(' . $suc_id_emr . ')' => null));
            $usu_arr=array();
            if(count($users_emr)>0){
                foreach ($users_emr as $key) {
                   $usu_arr[]=$key['uxe_id_emr'];
                }
            }
            $data['usu_emr']        = $usu_arr;
            $data['consulta_emr']   = $this->gsatelite->get_tabla('emr_empresa', array('emr_estado' => 1));
            $data['usuxsucursal']   = array_column($usc_usuario_sucursal,'usc_id_suc');
            $this->_cargarvista(null, $data);
        }
    }

    function encript_clave($password) {
        $hasher = new PasswordHash(
                $this->config->item('phpass_hash_strength', 'tank_auth'), $this->config->item('phpass_hash_portable', 'tank_auth'));

        $hashed_password = $hasher->HashPassword($password);
        $post_array['password'] = $hashed_password;

        return $post_array;
    }

    function usuarios() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                /* 		//preguntar por los empleados pendiente de asignar usuarios
                  $consulta = $this->gsatelite->get_tabla('emp_empleado',array('emp_estado'=>1));
                  $id_emps=array();
                  foreach ($consulta as $f1) {$id_emps[]=$f1['emp_id'];	}
                  $consulta_u = $this->gsatelite->get_tabla('users');
                  $id_emp_u=array();
                  foreach ($consulta_u as $f2) {$id_emp_u[]=$f2['usu_id_emp'];	}
                  $array_permitidos = array(0);
                  for ($i=0; $i < count($id_emps) ; $i++) {
                  if(!in_array($id_emps[$i],$id_emp_u)){
                  $array_permitidos[]=$id_emps[$i];
                  }
                  }
                  $id_usu_edita= 0;
                  $arreglo = explode('/',uri_string());
                  if(is_numeric(end($arreglo))){
                  $idsi=end($arreglo);
                  $id_usu_edita = $this->gsatelite->get_campo('emp_empleado','emp_id',array('emp_id_usu'=>$idsi));
                  if(!$id_usu_edita) { $id_usu_edita = 0; }
                  }
                  $array_permitidos[] = $id_usu_edita;

                  $cadena_permitidos = implode(',', $array_permitidos);
                 */
                //die($cadena_permitidos);
                $permisos = $this->gsatelite->get_permisos_opcion();
                $validacionActiveDirectory = $this->gsatelite->get_parametro_emp('SYS_VALIDAR_ACTIVE_DIRECTORY');
                $crud = new grocery_CRUD();
                $crud->set_table('users');
                $crud->set_subject('usuarios');
                $crud->columns('username', 'email', 'activated', 'rol');
                $crud->set_relation('usu_id_emp', 'emp_empleado', '{emp_nombre} {emp_apellido}'/* , "emp_id in ( {$cadena_permitidos} )" */);
                $crud->display_as('username', 'Nombre de Usuario')
                        ->display_as('email', 'Correo electrónico')
                        ->display_as('activated', 'Estado')
                        ->display_as('rol', 'Rol')
                        ->display_as('usu_id_emp', 'Empleada/o')
                        ->display_as('username', 'Nombre usuario')
                ;
                if ($permisos['permite_editar']) {
                    $crud->add_action('Editar', '', 'sistema/acceso/edit_form', 'icon16 icomoon-icon-pencil-5')
                        ->add_action('Limpiar Intentos', '', 'sistema/acceso/limpiar_intentos', ' icomoon-icon-unlocked');
                }
                if($validacionActiveDirectory == 0 && $permisos['permite_editar']) {
                        $crud ->add_action('Reiniciar Clave', '', 'sistema/acceso/usuarios_pass', 'brocco-icon-key')
                                ->add_action('Cambiar Clave', '', 'sistema/acceso/cambiar', 'icomoon-icon-key-2');
                }

                //->add_action('Clave', '', 'auth/reset_password','icomoon-icon-key-2')
                $explode_uri_string = explode('/', uri_string());
                if (end($explode_uri_string) == 'add') {
                    $crud->field_type('activated', 'hidden', 1);
                } else {
                    $crud->field_type('activated', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo', '2' => 'Inactivo'));
                }
                $crud->set_relation_n_n('rol', 'uxr_usuarioxrol', 'rol_rol', 'uxr_id_usu', 'uxr_id_rol', 'rol_nombre');

                $crud->add_fields('username', 'email', 'activated', 'rol', 'password', 'usu_id_emp');
                $crud->field_type('password', 'invisible');
                //$crud->field_type('activated','dropdown',array('2'=>'Inactivo','1'=>'Activo'));
                $crud->callback_before_insert(array($this, 'setear_clave'));
                $crud->required_fields('username', 'activated'  , 'rol');
                $crud->set_rules('username', 'Usuario', 'trim|callback_nameuser_check_insert|required');
                $crud->set_rules('email', 'Correo electrónico', 'valid_email');
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                $crud->unset_delete()
                        ->unset_edit();
                $crud->edit_fields('username', 'email', 'activated', 'rol', 'password', 'usu_id_emp');

                //$crud->field_type('password','invisible');
                $crud->callback_after_insert(function($post_array, $primary_key) {
                    //DESPUES DE QUE SE HAYA REALIZADO LA INSERCCION DEL REGISTRO 
                    //actualizar el registro del empleado
                    $datos = array('emp_id_usu' => $primary_key);
                    $this->gsatelite->actualizar_array('emp_empleado', $datos, array('emp_id' => $post_array['usu_id_emp']));
                    return TRUE;
                });
                $crud->callback_before_update(function($post_array, $primary_key) {

                    //al momento de cambiar el nombre de usuario, tambien la contraseña se reinicia
                    $hasher = new PasswordHash(
                            $this->config->item('phpass_hash_strength', 'tank_auth'), $this->config->item('phpass_hash_portable', 'tank_auth'));

                    $hashed_password = $hasher->HashPassword($post_array['username']);
                    $post_array['password'] = $hashed_password;

                    return $post_array;

                    //die(print_r($post_array));
                    //DESPUES DE QUE SE HAYA REALIZADO LA INSERCCION DEL REGISTRO 
                    //actualizar el registro del empleado
                    $campo_id_emp = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id' => $primary_key));
                    $datos = array(
                        'emp_id_usu' => $primary_key
                    );
                    $this->gsatelite->actualizar_array('emp_empleado', $datos, array('emp_id' => $campo_id_emp));
                    return TRUE;
                });
                $crud->callback_after_update(function($post_array, $primary_key) {
                    //die(print_r($post_array));
                    //DESPUES DE QUE SE HAYA REALIZADO LA INSERCCION DEL REGISTRO 
                    //actualizar el registro del empleado
                    $datos = array(
                        'emp_id_usu' => $primary_key
                    );
                    $this->gsatelite->actualizar_array('emp_empleado', $datos, array('emp_id' => $post_array['usu_id_emp']));

                    return TRUE;
                });
                //$crud->callback_after_update(function($))
                $data['titulo_personal'] = "Usuarios";
                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function nameuser_check_insert($str) {
        $id = end(explode("/", uri_string()));
        if (is_numeric($id)) {
            $username_old = $this->db->where("id", $id)->get('users')->row()->tia_nombre;

            $num_row = $this->db->where('username', $str)->where('id !=', $id)->get('users')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('nameuser_check_insert', 'El nombre del usuario ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('username', $str)->get('users')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('nameuser_check_insert', 'El nombre del usuario ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    function cambiar($id) {
        if ($id != null) {
            $nick = $this->sistema->obtenerNickUser($id);
            $data['titulo_personal'] = 'Cambiar Clave para ' . $nick->username;
            $data['llave_u'] = $id;
            $this->_cargarvista($data);
        } else {
            redirect('sistema/acceso/usuarios');
        }
    }

    function cambiar_clave() {
        if ((/*$_POST['clave_viej'] &&*/ $_POST['clave'] && $_POST['clave_conf']) != true) {
            $this->session->set_flashdata('menFaltanTodos', '$.pnotify({
			type: "Aviso",
		    title: "Importante",
    		text: "Debe especificar todos los valores solicitados.",
		    icon: "picon icon24 typ-icon-cancel white",
		    opacity: 0.95,
		    history: false,
		    sticker: false
			});');
            redirect('sistema/acceso/cambiar/' . $_POST['llave']);
        } else {
            if ($_POST['clave'] != $_POST['clave_conf']) {
                $this->session->set_flashdata('menNoIguales', '$.pnotify({
				type: "Aviso",
			    title: "Importante",
	    		text: "Los valores para \'Clave\' y \'Confirmar Clave\' deben ser iguales.",
			    icon: "picon icon24 typ-icon-info white",
			    opacity: 0.95,
			    history: false,
			    sticker: false
				});');
                redirect('sistema/acceso/cambiar/' . $_POST['llave']);
            } else {
                $user = $this->users->get_user_by_id($_POST['llave'], TRUE);
                $hasher = new PasswordHash(
                        $this->config->item('phpass_hash_strength', 'tank_auth'), $this->config->item('phpass_hash_portable', 'tank_auth'));
                if (true || $hasher->CheckPassword($_POST['clave_viej'], $user->password)) {
                    $hashed_password = $hasher->HashPassword($_POST['clave']);
                    $salio = $this->users->change_password($_POST['llave'], $hashed_password);
                    if ($salio == true) {
                        $this->session->set_flashdata('menSISeCambio', '$.pnotify({
						type: "success",
					    title: "Cambiar Clave",
			    		text: "Cambio de Clave realizado con exito.",
					    icon: "picon icon24 typ-icon-info white",
					    opacity: 0.95,
					    history: false,
					    sticker: false
						});');
                    } else {
                        $this->session->set_flashdata('menNoSeCambio', '$.pnotify({
						type: "Aviso",
					    title: "Cambiar Clave",
			    		text: "Imposible realizar cambio de Clave.",
					    icon: "picon icon24 typ-icon-info white",
					    opacity: 0.95,
					    history: false,
					    sticker: false
						});');
                    }
                    redirect('sistema/acceso/usuarios/');
                } else {
                    $this->session->set_flashdata('menClaveMala', '$.pnotify({
					type: "Aviso",
				    title: "Importante",
		    		text: "Valor para \'Clave\' incorrecto.",
				    icon: "picon icon24 typ-icon-cancel white",
				    opacity: 0.95,
				    history: false,
				    sticker: false
					});');
                    redirect('sistema/acceso/cambiar/' . $_POST['llave']);
                }
            }
        }
    }

    function setear_clave($post_array) {
        $hasher = new PasswordHash(
                $this->config->item('phpass_hash_strength', 'tank_auth'), $this->config->item('phpass_hash_portable', 'tank_auth'));

        $hashed_password = $hasher->HashPassword($post_array['username']);
        $post_array['password'] = $hashed_password;

        return $post_array;
    }

    function usuarios_pass($id) {
        $nick = $this->sistema->obtenerNickUser($id);

        if ($id != $this->tank_auth->get_user_id()) {
            $hasher = new PasswordHash(
                    $this->config->item('phpass_hash_strength', 'tank_auth'), $this->config->item('phpass_hash_portable', 'tank_auth'));

            $hashed_password = $hasher->HashPassword($nick->username);

            if ($this->users->change_password($id, $hashed_password) == true) {
                $this->session->set_flashdata('menExito', '$.pnotify({
								type: "Aviso",
							    title: "Usuarios",
					    		text: "Clave reiniciada para ' . $nick->username . '.",
							    icon: "picon icon24 typ-icon-info white",
							    opacity: 0.95,
							    history: false,
							    sticker: false
							});');
            } else {
                $this->session->set_flashdata('menFail', '$.pnotify({
								type: "Aviso",
							    title: "Usuarios",
					    		text: "Clave para ' . $nick->username . ' imposible de reiniciar.",
							    icon: "picon icon24 typ-icon-cancel white",
							    opacity: 0.95,
							    history: false,
							    sticker: false
							});');
            }
        } else {
            $this->session->set_flashdata('menProhibido', '$.pnotify({
								type: "Aviso",
							    title: "Usuarios",
					    		text: "Prohibido reiniciar Clave para ' . $nick->username . ' (usuario actual conectado).",
							    icon: "picon icon24 typ-icon-cancel white",
							    opacity: 0.95,
							    history: false,
							    sticker: false
							});');
        }
        redirect('sistema/acceso/usuarios/');
    }

    function limpiar_intentos($id) {
        $nick = $this->sistema->obtenerNickUser($id);


        //if ($id != $this->tank_auth->get_user_id()) {
            
        $limpiar_intentos = $this->gsatelite->borrado_general('login_attempts', array('login'=>$nick->username));

        if ($limpiar_intentos) {

                $this->session->set_flashdata('menExito', '$.pnotify({
								type: "Aviso",
							    title: "Usuarios",
					    		text: "Intentos reiniciados, puede volver a intentar iniciar sesion.",
							    icon: "picon icon24 typ-icon-info white",
							    opacity: 0.95,
							    history: false,
							    sticker: false
							});');

        } else {

                $this->session->set_flashdata('menFail', '$.pnotify({
								type: "Aviso",
							    title: "Usuarios",
					    		text: "No posee intentos a limpiar u ocurrio un problema en el proceso.",
							    icon: "picon icon24 typ-icon-cancel white",
							    opacity: 0.95,
							    history: false,
							    sticker: false
							});');

        }

        redirect('sistema/acceso/usuarios/');

    }

    /**
     * @author Luis Navarro
     * @since  2018-07-24
     * @return Colocar pantalla por defecto por rol
    **/
    public function set_pantalla_defecto() {
        // var_dump($_POST);die();
        satelite_validar();
        if ($this->input->post()) {
            $empresa  = $this->input->post('emr');
            $rol      = $this->input->post('rol');
            $opc      = $this->input->post('opc');
            $pantalla = $this->input->post('pantalla');
            $defecto  = (int)$this->input->post('defecto');          

            // Resetear
            $this->gsatelite->actualizar_array('oxr_opcionxrol', array('oxr_defecto_inicio' => 0), array('oxr_id_emr' => $empresa, 'oxr_id_rol' => $rol));

            // Verificar si es padre
            // $query['opc_nivel'] == '1' && $query['opc_hijo'] == '1'
            // if (isset($padre[0]['opc_nivel']) && $padre[0]['opc_nivel'] === '1' && $padre[0]['opc_hijo'] === '1') {
            //     echo json_encode(array( 'error'=>true,'cantidad'=>count($padre),'defecto'=>$defecto,'padre'=>true ));
            //     die();
            // }

            if ($defecto === 0) {
                $array_update = array(
                    'oxr_defecto_inicio'     => 0,
                    'oxr_usu_modificacion'   => $this->tank_auth->get_user_id(),
                    'oxr_fecha_modificacion' => date('Y-m-d H:i:s'),
                );

                $this->gsatelite->actualizar_array('oxr_opcionxrol', $array_update, array('oxr_id_opc' => $pantalla, 'oxr_id_emr' => $empresa, 'oxr_id_rol' => $rol));

                echo json_encode(array( 'error' => false,'defecto' => $defecto ));
            
            } elseif ($defecto === 1) {

                $array_update = array(
                    'oxr_defecto_inicio'     => 1,
                    'oxr_usu_modificacion'   => $this->tank_auth->get_user_id(),
                    'oxr_fecha_modificacion' => date('Y-m-d H:i:s'),
                );

                $this->gsatelite->actualizar_array('oxr_opcionxrol', $array_update, array('oxr_id_opc' => $pantalla, 'oxr_id_emr' => $empresa, 'oxr_id_rol' => $rol));

                // print_r($this->db->last_query());die();

                echo json_encode(array( 'error' => false, 'defecto' => $defecto ));

            } else {
                echo json_encode(array( 'error' => true, 'defecto' => $defecto ));
            }
        }
    }

    /**
     * @author Luis Navarro
     * @since  2018-07-25
     * @return Colocar actualizar los permisos 
    **/
    public function set_permisos_opcion() {
        // print_r($_POST);die();
        if ($this->input->post()) {
            $rol        = $this->input->post('rol');
            $empresa    = $this->input->post('empresa');
            $opcion     = $this->input->post('opcion');
            $array_opc  = $this->input->post('array_opc');
            $cantidad   = count($this->input->post('array_opc'));

            if ($cantidad > 0) {
                foreach ($array_opc as $key => $value) {
                    
                    $cadena = explode(':', $value);

                    //Formato de $cadena[1] 
                    //1=crear, 2=ver, 3=editar, 4=eliminar
                    $campo = '';
                    switch ($cadena[1]) {
                        case '1':
                            $campo = 'oxr_insertar';
                            break;
                        case '2':
                            $campo = 'oxr_ver';
                            break;
                        case '3':
                            $campo = 'oxr_editar';
                            break;
                        case '4':
                            $campo = 'oxr_eliminar';
                            break;
                    }

                    $array_update = array(
                        $campo => $opcion
                    );

                    $this->db->select('opc_id, opc_nombre, opc_nivel, opc_hijo')
                             ->from('opc_opcion')
                             ->where('opc_id', $cadena[0]);

                    $query = $this->db->get()->row_array();
                    if ($query['opc_nivel'] == '1' && $query['opc_hijo'] == '1') {

                        $this->db->select('opc_id, opc_nombre,opc_nivel,opc_hijo')
                                ->from('opc_opcion')
                                ->where('opc_id', $cadena[0])
                                ->or_where('opc_padre', $cadena[0]);

                        $query2 = $this->db->get()->result_array();

                        if (count($query2) > 0) {
                            foreach ($query2 as $key) {
                                $this->gsatelite->actualizar_array('oxr_opcionxrol', $array_update, array('oxr_id_opc' => $key['opc_id'], 'oxr_id_emr' => $empresa, 'oxr_id_rol' => $rol));
                            }
                        }
                    } else {
                        $this->gsatelite->actualizar_array('oxr_opcionxrol', $array_update, array('oxr_id_opc' => $cadena[0], 'oxr_id_emr' => $empresa, 'oxr_id_rol' => $rol, 'oxr_estado' => 1));
                    }
                }
            }

            echo json_encode(array('opcion' => $opcion, 'ok' => true));
        }

    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    public function backup_db()
    {
        satelite_validar();
        $datos_conexion  = $this->load->database('', true); //cargar los datos de conexión
        //print_r($datos_conexion); die();
        $db_host = $datos_conexion->hostname; //'192.168.2.57'; //Host del Servidor MySQL
        $db_name = $datos_conexion->database; // 'erp_sonso'; //Nombre de la Base de datos
        $db_user = $datos_conexion->username; // 'desarrollo3'; //Usuario de MySQL
        $db_pass = $datos_conexion->password; //'desarrollo3'; //Password de Usuario MySQL
        $consola = $datos_conexion->console;
        
       // print_r($conexion); die();
        
        $fecha = date("Ymd-His"); //Obtenemos la fecha y hora para identificar el respaldo

        // Construimos el nombre de archivo SQL Ejemplo: mibase_20170101-081120.sql
        $salida_sql = "uploads/db_backups/".$db_name.'_'.$fecha.'.sql'; 
        
        //Comando para genera respaldo de MySQL, enviamos las variales de conexion y el destino
        $dump = "$consola --user=".$db_pass." --password=".$db_pass." --host=".$db_host." ".$db_name." > $salida_sql";
        system($dump, $output); //Ejecutamos el comando para respaldo
        
        $zip = new ZipArchive(); //Objeto de Libreria ZipArchive
        
        //Construimos el nombre del archivo ZIP Ejemplo: mibase_20160101-081120.zip
        $salida_zip = "uploads/db_backups/".$db_name.'_'.$fecha.'.zip';
        
        if($zip->open($salida_zip,ZIPARCHIVE::CREATE)===true) { //Creamos y abrimos el archivo ZIP
            $zip->addFile($salida_sql); //Agregamos el archivo SQL a ZIP
            $zip->close(); //Cerramos el ZIP
            unlink($salida_sql); //Eliminamos el archivo temporal SQL
            header ("Location:".base_url("$salida_zip")); // Redireccionamos para descargar el Arcivo ZIP
            } else {
            echo '<h1>Error :(</h1>'; //Enviamos el mensaje de error
        }
    }

    //traer el nombre de opc_nombre y ponerlo en el titulo
    function nom_menu_en_titulo(){
        $url=$this->input->post('url');
        $base_url = base_url();
        $base_url_array = explode('/', $base_url);
        //print_r($base_url."<br>");
        $url_array = explode($base_url_array[3], $url);
        $url_nose = explode('/', $url_array[1]);
        //print_r($id);

        $id = $this->gsatelite->get_tabla('opc_opcion', array('opc_funcion'=>$url_nose[1]));
        //print_r($id);
        $id2 = $this->gsatelite->get_tabla('opc_opcion', array('opc_funcion'=>$url_nose[2],'opc_padre'=>$id[0]['opc_id']));
        $id3 = $this->gsatelite->get_tabla('opc_opcion', array('opc_funcion'=>$url_nose[3],'opc_padre'=>$id2[0]['opc_id']));

        $titulo = (count($id3) > 0)?$id3[0]['opc_nombre']:'';

        $regresar = json_encode(array("titulo"=>$titulo));

        echo $regresar;
    }

    public function navegador_archivos()
    {
        satelite_validar();
        $data['titulo_personal'] = "Respaldos";
        cargarvista('sistema/acceso/navegador_archivos',$data, null);
        //$this->gsatelite->cargar_vista_masterpage('sistema/acceso/navegador_archivos', $data);
    }

    public function backup_db_v2()
    {
        satelite_validar();
        $datos_conexion  = $this->load->database('', true); //cargar los datos de conexión
       // print_r($datos_conexion); die();
        $db_host = $datos_conexion->hostname; 
        $db_usuario = $datos_conexion->username; 
        $db_clave = $datos_conexion->password; 
        $db_base= $datos_conexion->database; 
        ini_set('memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        $exito = $this->exportarTablas("$db_host", "$db_usuario", "$db_clave", "$db_base");
        if ($exito)
            $this->gsatelite->show_dialog("Proceso realizado con éxito", "sistema/acceso/navegador_archivos");
        else
            $this->gsatelite->show_dialog("Error en realizar proceso", "sistema/acceso/navegador_archivos");
    }



    function exportarTablas($host, $usuario, $pasword, $nombreDeBaseDeDatos)
    {   
        ini_set('memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        //$carpeta = __DIR__ . "\uploads\db_backups";
        //echo $carpeta; die(' llego');
        //set_time_limit(3000);
        $tablasARespaldar = [];
        $mysqli = new mysqli($host, $usuario, $pasword, $nombreDeBaseDeDatos);
        $mysqli->select_db($nombreDeBaseDeDatos);
        $mysqli->query("SET NAMES 'utf8'");
        $tablas = $mysqli->query('SHOW TABLES');
        while ($fila = $tablas->fetch_row()) {
            $tablasARespaldar[] = $fila[0];
        }
        $contenido = "SET SQL_MODE = \"NO_AUTO_VALUE_ON_ZERO\";\r\nSET time_zone = \"+00:00\";\r\n\r\n\r\n/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;\r\n/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;\r\n/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;\r\n/*!40101 SET NAMES utf8 */;\r\n--\r\n-- Database: `" . $nombreDeBaseDeDatos . "`\r\n--\r\n\r\n\r\n";
        $contenido .= " SET FOREIGN_KEY_CHECKS=0;";
        foreach ($tablasARespaldar as $nombreDeLaTabla) {
            if (!empty($nombreDeLaTabla) && substr(trim($nombreDeLaTabla), 0, 3) != 'vw_' ) 
            {
                
            $datosQueContieneLaTabla = $mysqli->query('SELECT * FROM `' . $nombreDeLaTabla . '`');
            $cantidadDeCampos = $datosQueContieneLaTabla->field_count;
            $cantidadDeFilas = $mysqli->affected_rows;
            $esquemaDeTabla = $mysqli->query('SHOW CREATE TABLE ' . $nombreDeLaTabla);
            $filaDeTabla = $esquemaDeTabla->fetch_row();
            $contenido .= "\n\n" . $filaDeTabla[1] . ";\n\n";
            for ($i = 0, $contador = 0; $i < $cantidadDeCampos; $i++, $contador = 0) {
                while ($fila = $datosQueContieneLaTabla->fetch_row()) {
                    //La primera y cada 100 veces
                    if ($contador % 100 == 0 || $contador == 0) {
                        $contenido .= "\nINSERT INTO " . $nombreDeLaTabla . " VALUES";
                    }
                    $contenido .= "\n(";
                    for ($j = 0; $j < $cantidadDeCampos; $j++) {
                        $fila[$j] = str_replace(array("\n"), array("\\n"), addslashes($fila[$j]));
                        if (isset($fila[$j])) {
                            $contenido .= '"' . $fila[$j] . '"';
                        } else {
                            $contenido .= '""';
                        }
                        if ($j < ($cantidadDeCampos - 1)) {
                            $contenido .= ',';
                        }
                    }
                    $contenido .= ")";
                    # Cada 100...
                    if ((($contador + 1) % 100 == 0 && $contador != 0) || $contador + 1 == $cantidadDeFilas) {
                        $contenido .= ";";
                    } else {
                        $contenido .= ",";
                    }
                    $contador = $contador + 1;
                }
            }
            $contenido .= "\n\n\n";
        }
        }
        $contenido .= " SET FOREIGN_KEY_CHECKS=1;";
        $contenido .= "\r\n\r\n/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;\r\n/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;\r\n/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;";
        # Se guardará dependiendo del directorio, en una carpeta llamada respaldos
        $carpeta = "uploads/db_backups";
        if (!file_exists($carpeta)) {
            mkdir($carpeta);
        }
        # Calcular un ID único
        $id = uniqid();
        # También la fecha
        $fecha = date("Y-m-d_H-i-s");
        $usuario = $this->tank_auth->get_username();
        # Crear un archivo que tendrá un nombre como respaldo_2018-10-22_asd123.sql
        $nombreDelArchivo = "$carpeta/respaldo_$usuario"."_".$fecha."_".$id.".sql";
        #Escribir todo el contenido. Si todo va bien, file_put_contents NO devuelve FALSE
        $exito = file_put_contents($nombreDelArchivo, $contenido) !== false;

        // $zip = new ZipArchive(); //Objeto de Libreria ZipArchive
        // //Construimos el nombre del archivo ZIP Ejemplo: mibase_20160101-081120.zip
        // $salida_zip = $nombreDelArchivo.".zip";
        
        // if($zip->open($salida_zip,ZIPARCHIVE::CREATE)===true) { //Creamos y abrimos el archivo ZIP
        //     $zip->addFile($salida_sql); //Agregamos el archivo SQL a ZIP
        //     $zip->close(); //Cerramos el ZIP
        //     unlink($salida_sql); //Eliminamos el archivo temporal SQL
        //     header ("Location:".base_url("$salida_zip")); // Redireccionamos para descargar el Arcivo ZIP
        //     }

        return $exito;
    }

    /**
         * Descripción:
         * Busca municipios
         * @author Francisco Orozco - Grupo Satélite
         * @since  2019-10-02
         * @param  Ninguno
         * @return JSON
    */
    public function get_sucursales(){
        satelite_validar();
        $empresas_drop = '<option value=""></option>';
        $empresas   = $this->input->post('empresa');
        $suc_id_emr = '';
        if ( count($empresas) > 0 ) {
            foreach ($empresas as $empresa) {
                $suc_id_emr .= $empresa.',';
            }
            $suc_id_emr = substr($suc_id_emr, 0, -1);
        }
        
        $where['suc_id_emr in ('.$suc_id_emr.')']= null;

        $empresas_drop  .= $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', $where, '', '', 'suc_id', true);
        $empresas_drop  = str_replace('<option value="0">Seleccione</option>', '', $empresas_drop);
        echo $empresas_drop;
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */