<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Procesos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->library('limpia_texto');
        $this->load->model('consultas');
        $this->load->model('registro_academico_model');
        $this->load->model('proceso_model');
        $this->load->model('personal_model');
        $this->load->model('proyecto_model');
        $this->load->model('gsatelite');
        $this->load->model('expediente_personal_model');
        $this->load->library('excel/excel_reader.php');
        $this->load->library('pdf');
        // $this->load->library('procesos');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function inscribir_programas() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // All your code goes here
            $data['titulo_personal'] = "Inscripción de programa";
            $this->_cargarvista($data);
        }
    }

    function agregar_programa() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                die(print_r("En desarrollo..."));
            } else {
                // falta mandar datos
                $data['alumnos'] = $this->registro_academico_model->obtener_alumnos();
                $data['programas'] = $this->registro_academico_model->obtener_programas();
                $data['titulo_personal'] = "Inscripción programa por alumno";
                $this->_cargarvista($data);
            }
        }
    }

    private function normalizar_codigo_alumno($codigo_alumno) {

        $encoding = mb_detect_encoding($codigo_alumno, 'UTF-8, ISO-8859-1, ISO-8859-15', true);

        if ($encoding !== 'UTF-8') {
            $codigo_alumno = mb_convert_encoding($codigo_alumno, 'UTF-8', $encoding);
        }   

        $caracteres = array(
            'Á' => 'A', 'É' => 'E', 'Í' => 'I', 'Ó' => 'O', 'Ú' => 'U',
            'á' => 'a', 'é' => 'e', 'í' => 'i', 'ó' => 'o', 'ú' => 'u',
            'Ñ' => 'N', 'ñ' => 'n',
            'Ü' => 'U', 'ü' => 'u',
            'Ç' => 'C', 'ç' => 'c'
        );

        return strtr($codigo_alumno, $caracteres);
    }

    /**
     * Gestión de alumnos
     * 
     * @author Edith Herrera
     * @since 11/11/2015
     */
    function gestion_alumnos($consulta = 0) {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                if ($consulta > 0) {
                    $post_array = $_POST;
                    $fecha_inicio = $post_array['fecha_ini'];
                    $fecha_fin    = $post_array['fecha_fin'];
                    $alumno       = $post_array['alumno'];

                    $data['fecha_ini'] = $fecha_inicio;
                    $data['fecha_fin'] = $fecha_fin;
                    $where = null;
                    if ($alumno != '') {
                        $where['alm_id'] = $alumno;
                    }
                    if ($fecha_inicio != '' && $fecha_fin != '' && $alumno == '') {
                        $where['alm_fecha_crea >='] = date('Y-m-d', strtotime($fecha_inicio));
                        $where['alm_fecha_crea <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
                    }
                    $data['alumnos'] = $this->registro_academico_model->obtener_alumnos($where, 'alm_id');
                    $data['tipo_reporte'] = 'grid';
                    $html = $this->load->view('registro_academico/procesos/imprimir_gestion_alumnos', $data, true);

                    echo $html;
                    die();
                }
            } else {
                $data['permisos'] = $this->gsatelite->get_permisos_opcion();
                $data['titulo_personal'] = "Alumnos";
                $this->_cargarvista($data);
            }
        }
    }

    function gestion_alumnos_masivo() {        
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $data['permisos'] = $permisos;
            
            $data['titulo_personal'] = "Alumnos";

            $this->_cargarvista($data);
        }
    }

    function gestion_alumnos_masivo_xls($export = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if (!$_FILES && $export == null) {
                $this->gsatelite->show_dialog('No es posible cargar el listado de alumnos', 'registro_academico/procesos/gestion_alumnos_masivo', 'error' );
            }
            $excel          = new Excel_reader;
            $excel->read($_FILES["excelfile"]["tmp_name"]);

            $datos_excel= $excel->sheets[0];
            $registros  = $datos_excel['cells'];
            $html       = '<tbody id="contenedor">';
            unset($registros[1]);// se quita primera linea de titulos

            //errores
            $num_registro = 1;
            $listado_errores = '';
            $error_contenido_excel = 0;

            foreach ($registros as $fila) {
                $repetido       = false;
                $codigo_alumno       = (isset($fila[1]) && $fila[1] != "") ? $fila[1] : null; //codigo
                $nombre_alumno       = (isset($fila[2]) && $fila[2] != "") ? utf8_encode($fila[2]) : null; //name
                $apellido_alumno     = (isset($fila[3]) && $fila[3] != "") ? utf8_encode($fila[3]) : null; //apellido
                $fecha_nac_alumno    = (isset($fila[4]) && $fila[4] != "") ? $fila[4] : null;//f.nac
                $correo              = (isset($fila[5]) && $fila[5] != "") ? $fila[5] : null;//mail
                $direccion_alumno    = (isset($fila[6]) && $fila[6] != "") ? utf8_encode($fila[6]) : null;//direccion
                $pais_alumno         = (isset($fila[7]) && $fila[7] != "") ? $fila[7] : null;//pai
                $departamento_alumno = (isset($fila[8]) && $fila[8] != "") ? $fila[8] : null;//depar
                $municipio_alumno    = (isset($fila[9]) && $fila[9] != "") ? $fila[9] : null;//munic
                $genero_alumno       = (isset($fila[10]) && $fila[10] != "") ? $fila[10] : null;//f-m alumno
                $estado_civil        = (isset($fila[11]) && $fila[11] != "") ? $fila[11] : null;//est civil
                $dui_alumno          = (isset($fila[12]) && $fila[12] != "") ? $fila[12] : null;//dui
                $nit_alumno          = (isset($fila[13]) && $fila[13] != "") ? $fila[13] : null;//nit
                $telefono_alumno     = (isset($fila[14]) && $fila[14] != "") ? $fila[14] : null;//telefo
                $por_que_medio       = (isset($fila[15]) && $fila[15] != "") ? $fila[15] : null;//por que medio
                $vendedor            = (isset($fila[16]) && $fila[16] != "") ? $fila[16] : null;//vendedo

                $institucion_academica = (isset($fila[17]) && $fila[17] != "") ? $fila[17] : null;//id instit acad
                $nivel_educativo       = (isset($fila[18]) && $fila[18] != "") ? $fila[18] : null;//nivel edu
                $pais_educativo        = (isset($fila[19]) && $fila[19] != "") ? $fila[19] : null;//pais ult educ
                $anio_finalizacion     = (isset($fila[20]) && $fila[20] != "") ? $fila[20] : null;//year acabo ulti

                $contacto_emergencia = (isset($fila[21]) && $fila[21] != "") ? $fila[21] : null;//id parentesc emerg
                $contactar_a         = (isset($fila[22]) && $fila[22] != "") ? utf8_encode($fila[22]) : null;//nombre emerg
                $direccion_contacto  = (isset($fila[23]) && $fila[23] != "") ? utf8_encode($fila[23]) : null;//direcc emerg
                $telefono_contacto   = (isset($fila[24]) && $fila[24] != "") ? $fila[24] : null;//telefono emerg

                $ultima_exp_laboral = (isset($fila[25]) && $fila[25] != "") ? utf8_encode($fila[25]) : null;//nombre empresa
                $direccion_laboral  = (isset($fila[26]) && $fila[26] != "") ? utf8_encode($fila[26]) : null;//direcc empre
                $telefono_laboral   = (isset($fila[27]) && $fila[27] != "") ? $fila[27] : null;//telef empre
                $puesto_laboral     = (isset($fila[28]) && $fila[28] != "") ? utf8_encode($fila[28]) : null;//cargo empre

                $total_errores_registro = 0;
                $errores_encontrados = '';

                // Validar errores
                if ($codigo_alumno === null) {
                    $errores_encontrados .= '<li>Error: CODIGO es requerido</li>';
                    $total_errores_registro++;
                    $error_contenido_excel++;
                }
                if ($nombre_alumno === null) {
                    $errores_encontrados .= '<li>Error: NOMBRE es requerido</li>';
                    $total_errores_registro++;
                    $error_contenido_excel++;
                }
                if ($apellido_alumno === null) {
                    $errores_encontrados .= '<li>Error: APELLIDO es requerido</li>';
                    $total_errores_registro++;
                    $error_contenido_excel++;
                }
                if ($fecha_nac_alumno != null) {
                    $array_fecha_nac = date_parse_from_format('d/m/Y', $fecha_nac_alumno);
                    if ($array_fecha_nac !== false && !checkdate($array_fecha_nac['month'], $array_fecha_nac['day'], $array_fecha_nac['year'])) {
                        $errores_encontrados .= '<li>Error: FECHA NACIMIENTO posee formato incorrecto</li>';
                        $total_errores_registro++;
                        $error_contenido_excel++;
                    }
                }
                if ($correo === null) {
                    $errores_encontrados .= '<li>Error: CORREO es requerido</li>';
                    $total_errores_registro++;
                    $error_contenido_excel++;
                }
                if ($pais_alumno != null) {
                    $nombre_pais = $this->gsatelite->get_campo('pai_pais', 'pai_nombre', array('pai_id' => $pais_alumno));
                    if ($nombre_pais === null) {
                        $errores_encontrados .= '<li>Error: No se encontro registro del correlativo ingresado en PAIS de datos generales del alumno</li>';
                        $total_errores_registro++;
                        $error_contenido_excel++;
                    }
                } else { 
                    $nombre_pais = null;
                }
                if ($departamento_alumno != null) {
                    $nombre_departamento = $this->gsatelite->get_campo('dep_departamento', 'dep_nombre', array('dep_id' => $departamento_alumno));
                    if ($nombre_departamento === null) {
                        $errores_encontrados .= '<li>Error: No se encontro registro del correlativo ingresado en DEPARTAMENTO</li>';
                        $total_errores_registro++;
                        $error_contenido_excel++;
                    }
                } else { 
                    $nombre_departamento = null;
                }
                if ($municipio_alumno != null) {
                    $nombre_municipio = $this->gsatelite->get_campo('mun_municipio', 'mun_nombre', array('mun_id' => $municipio_alumno));
                    if ($nombre_municipio === null) {
                        $errores_encontrados .= '<li>Error: No se encontro registro del correlativo ingresado en MUNICIPIO</li>';
                        $total_errores_registro++;
                        $error_contenido_excel++;
                    }
                } else { 
                    $nombre_municipio = null;
                }
                if ($pais_alumno != null && $departamento_alumno != null) {
                    $verificar_relacion_pai_dep = $this->gsatelite->get_campo('dep_departamento', 'dep_id', array('dep_id' => $departamento_alumno, 'dep_id_pai' => $pais_alumno));
                    if ($verificar_relacion_pai_dep === null) {
                        $errores_encontrados .= '<li>Error: El correlativo del DEPARTAMENTO no esta relacionado al PAIS ingresado</li>';
                        $total_errores_registro++;
                        $error_contenido_excel++;
                    }
                }
                if ($departamento_alumno != null && $municipio_alumno === null) {
                    $errores_encontrados .= '<li>Error: Si ingresa DEPARTAMENTO debe de especificar un MUNICIPIO</li>';
                    $total_errores_registro++;
                    $error_contenido_excel++;
                }
                if ($departamento_alumno !== null && $municipio_alumno !== null) {
                    $verificar_relacion_dep_mun = $this->gsatelite->get_campo('mun_municipio', 'mun_id', array('mun_id' => $municipio_alumno, 'mun_id_dep' => $departamento_alumno));
                    if ($verificar_relacion_dep_mun === null) {
                        $errores_encontrados .= '<li>Error: El correlativo del MUNICIPIO no esta relacionado al DEPARTAMENTO ingresado</li>';
                        $total_errores_registro++;
                        $error_contenido_excel++;
                    }
                }
                if ($genero_alumno === null) {
                    $errores_encontrados .= '<li>Error: GENERO es requerido</li>';
                    $total_errores_registro++;
                    $error_contenido_excel++;
                }
                if ($estado_civil != null) {
                    $nombre_estado_civil = $this->gsatelite->get_campo('esc_estado_civil ', 'esc_nombre', array('esc_id' => $estado_civil));
                    if ($nombre_estado_civil === null) {
                        $errores_encontrados .= '<li>Error: No se encontro registro del correlativo ingresado en ESTADO CIVIL</li>';
                        $total_errores_registro++;
                        $error_contenido_excel++;
                    }
                } else {
                    $nombre_estado_civil = null;
                }

                if ($dui_alumno === null) {
                    $errores_encontrados .= '<li>Error: DUI es requerido</li>';
                    $total_errores_registro++;
                    $error_contenido_excel++;
                } else {
                    if (!preg_match('/^\d{8}-\d$/', $dui_alumno)) {
                        $errores_encontrados .= '<li>Error: Formato del DUI es incorrecto</li>';
                        $total_errores_registro++;
                        $error_contenido_excel++;
                    }

                    $dui_unico_alumno = $this->gsatelite->get_tabla('dca_documento_alumno', array('dca_valor' => $dui_alumno));
                    $dui_unico_cliente = $this->gsatelite->get_tabla('dcc_documento_cliente', array('dcc_valor' => $dui_alumno));
                    if (count($dui_unico_alumno) > 0 || count($dui_unico_cliente) > 0) {
                        $errores_encontrados .= '<li>Error: El DUI ya se encuentra registrado</li>';
                        $total_errores_registro++;
                        $error_contenido_excel++;
                    }

                }

                if ($nit_alumno != null && (!(preg_match('/^\d{4}-\d{6}-\d{3}-\d$/', $nit_alumno) || preg_match('/^\d{8}-\d$/', $nit_alumno)))  ) {
                    $errores_encontrados .= '<li>Error: Formato del NIT es incorrecto</li>';
                    $total_errores_registro++;
                    $error_contenido_excel++;
                }
                if ($telefono_alumno !== null && !preg_match('/^\d{4}-\d{4}$/', $telefono_alumno)) {
                    $errores_encontrados .= '<li>Error: Formato incorrecto del TELEFONO en información personal del alumno </li>';
                    $total_errores_registro++;
                    $error_contenido_excel++;
                }
                if ($institucion_academica !== null) {
                    $nombre_institucion_acad = $this->gsatelite->get_campo('ina_institucion_academica', 'ina_nombre', array('ina_id' => $institucion_academica));
                    if ($nombre_institucion_acad === null) {
                        $errores_encontrados .= '<li>Error: No se encontro registro del correlativo ingresado en ULTIMA INSTITUCION ACADEMICA</li>';
                        $total_errores_registro++;
                        $error_contenido_excel++;
                    }
                } else {
                    $nombre_institucion_acad = null;
                }                
                if ($nivel_educativo !== null) {
                    $nombre_nivel_edu = $this->gsatelite->get_campo('tie_tipo_educacion', 'tie_nombre', array('tie_id' => $nivel_educativo));
                    if ($nombre_nivel_edu === null) {
                        $errores_encontrados .= '<li>Error: No se encontro registro del correlativo ingresado en NIVEL EDUCATIVO</li>';
                        $total_errores_registro++;
                        $error_contenido_excel++;
                    }
                } else {
                    $nombre_nivel_edu = null;
                }
                if ($pais_educativo !== null) {
                    $nombre_pais_edu = $this->gsatelite->get_campo('pai_pais', 'pai_nombre', array('pai_id' => $pais_educativo));
                    if ($nombre_pais_edu === null) {
                        $errores_encontrados .= '<li>Error: No se encontro registro del correlativo ingresado en PAIS de institución académica</li>';
                        $total_errores_registro++;
                        $error_contenido_excel++;
                    }
                } else {
                    $nombre_pais_edu = null;
                }
                if ($anio_finalizacion !== null && filter_var($anio_finalizacion, FILTER_VALIDATE_INT) === false) {
                    $errores_encontrados .= '<li>Error: AÑO FINALIZACION debe de ser entero</li>';
                    $total_errores_registro++;
                    $error_contenido_excel++;
                }
                if ($contacto_emergencia !== null) {
                    $nombre_parentesco = $this->gsatelite->get_campo('pat_parentesco', 'pat_nombre', array('pat_id' => $contacto_emergencia));
                    if ($nombre_parentesco === null) {
                        $errores_encontrados .= '<li>Error: No se encontro registro del correlativo ingresado en CONTACTO DE EMERGENCIA </li>';
                        $total_errores_registro++;
                        $error_contenido_excel++;
                    }
                } else {
                    $nombre_parentesco = null;
                }
                if ($telefono_contacto !== null && !preg_match('/^\d{4}-\d{4}$/', $telefono_contacto)) {
                    $errores_encontrados .= '<li>Error: Formato incorrecto del TELEFONO en contacto de emergencia</li>';
                    $total_errores_registro++;
                    $error_contenido_excel++;
                }
                if ($telefono_laboral !== null && !preg_match('/^\d{4}-\d{4}$/', $telefono_laboral)) {
                    $errores_encontrados .= '<li>Error: Formato incorrecto del TELEFONO en experiencia laboral </li>';
                    $total_errores_registro++;
                    $error_contenido_excel++;
                }
                if ($por_que_medio != null) {
                    $nombre_medio = $this->gsatelite->get_campo('tmc_tipo_medio', 'tmc_nombre', array('tmc_id' => $por_que_medio));
                    if ($nombre_medio == null) {
                        $errores_encontrados .= '<li>Error: No se encontro registro del correlativo ingresado en POR QUE MEDIO SE ENTERO</li>';
                        $total_errores_registro++;
                        $error_contenido_excel++;
                    }
                } else { 
                    $nombre_medio = null;
                }
                if ($vendedor != null) {
                    $saler = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id' => $vendedor));
                    if (count($saler) > 0) {
                        $nombre_vendedor = $saler[0]['ven_codigo'] . ' - ' .$saler[0]['ven_nombre'] . ' ' . $saler[0]['ven_apellidos'];
                    } else {
                        $errores_encontrados .= '<li>Error: No se encontro registro del correlativo ingresado en VENDEDOR</li>';
                        $total_errores_registro++;
                        $error_contenido_excel++;
                    }
                } else { 
                    $nombre_vendedor = null;
                }
                if($total_errores_registro > 0) {
                    $listado_errores .= '<h4>Problemas encontrados en el registro: '.$num_registro.'</h4>';
                    $listado_errores .= '<ul style="list-style: none;">';
                    $listado_errores .= $errores_encontrados;
                    $listado_errores .= '</ul><br/>';
                }
                $num_registro++;
                
                $codigo_alumno_normalizado = $this->normalizar_codigo_alumno($codigo_alumno);
                
                $html .= ($repetido == false)?'<tr>':'<tr style="background-color: #FFF55C;">';
                $html .= '<td>'.$codigo_alumno_normalizado;
                $html .= '<input type="hidden" name="codigo_alumno[]" id="codigo" value="' . $codigo_alumno_normalizado . '"/>';
                $html .= '</td>';
                $html .= '<td>'.$nombre_alumno;
                $html .= '<input type="hidden" name="nombre_alumno[]" id="nombre" value="' . $nombre_alumno . '"/>';
                $html .= '</td>';
                $html .= '<td>'.$apellido_alumno;
                $html .= "<input type='hidden' name='apellido_alumno[]' id='apellido' value='" . $apellido_alumno . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$fecha_nac_alumno;
                $html .= '<input type="hidden" name="fec_nacimiento_alumno[]" id="fecha_nac" value="' . $fecha_nac_alumno . '"/>';
                $html .= '</td>';
                $html .= '<td>'.$correo;
                $html .= "<input type='hidden' name='correo_alumno[]' id='correo' value='" . $correo . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$direccion_alumno;
                $html .= "<input type='hidden' name='direccion_alumno[]' id='direccion_alumno' value='" . $direccion_alumno . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$nombre_pais;
                $html .= "<input type='hidden' name='pais_alumno[]' id='pais_alumno' value='" . $pais_alumno . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$nombre_departamento;
                $html .= "<input type='hidden' name='departamento_alumno[]' id='departamento_alumno' value='" . $departamento_alumno . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$nombre_municipio;
                $html .= "<input type='hidden' name='municipio_alumno[]' id='municipio_alumno' value='" . $municipio_alumno . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$genero_alumno;
                $html .= "<input type='hidden' name='genero_alumno[]' id='genero' value='" . $genero_alumno . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$nombre_estado_civil;
                $html .= "<input type='hidden' name='est_civil_alumno[]' id='estado_civil' value='" . $estado_civil . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$dui_alumno;
                $html .= "<input type='hidden' name='dui_alumno[]' id='dui' value='" . $dui_alumno . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$nit_alumno;
                $html .= "<input type='hidden' name='nit_alumno[]' id='nit' value='" . $nit_alumno . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$telefono_alumno;
                $html .= "<input type='hidden' name='tal_numero[]' id='telefono' value='" . $telefono_alumno . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$nombre_medio;
                $html .= "<input type='hidden' name='medio_contacto[]' id='medio_contacto' value='" . $por_que_medio . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$nombre_vendedor;
                $html .= "<input type='hidden' name='vendedor[]' id='vendedor' value='" . $vendedor . "'/>";
                $html .= '</td>';

                $html .= '<td>'.$nombre_institucion_acad;
                $html .= "<input type='hidden' name='eda_id_ina[]' id='institucion_acad' value='" . $institucion_academica . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$nombre_nivel_edu;
                $html .= "<input type='hidden' name='eda_id_tie[]' id='nivel_educativo' value='" . $nivel_educativo . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$nombre_pais_edu;
                $html .= "<input type='hidden' name='eda_id_pai[]' id='pais_educativo' value='" . $pais_educativo . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$anio_finalizacion;
                $html .= "<input type='hidden' name='eda_anio_fecha_final[]' id='anio_fecha_final' value='" . $anio_finalizacion . "'/>";
                $html .= '</td>';

                $html .= '<td>'.$nombre_parentesco;
                $html .= "<input type='hidden' name='cla_id_pat[]' id='contacto_emergencia' value='" . $contacto_emergencia . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$contactar_a;
                $html .= "<input type='hidden' name='cla_familiar[]' id='contactar_a' value='" . $contactar_a . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$direccion_contacto;
                $html .= "<input type='hidden' name='cla_direccion_fam[]' id='direccion_contacto' value='" . $direccion_contacto . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$telefono_contacto;
                $html .= "<input type='hidden' name='cla_telefono[]' id='telefono_contacto' value='" . $telefono_contacto . "'/>";
                $html .= '</td>';

                $html .= '<td>'.$ultima_exp_laboral;
                $html .= "<input type='hidden' name='eal_empresa[]' id='ultima_exp_laboral' value='" . $ultima_exp_laboral . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$direccion_laboral;
                $html .= "<input type='hidden' name='eal_direccion[]' id='direccion_laboral' value='" . $direccion_laboral . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$telefono_laboral;
                $html .= "<input type='hidden' name='eal_telefono[]' id='telefono_laboral' value='" . $telefono_laboral . "'/>";
                $html .= '</td>';
                $html .= '<td>'.$puesto_laboral;
                $html .= "<input type='hidden' name='eal_puesto[]' id='puesto_laboral' value='" . $puesto_laboral . "'/>";
                $html .= '</td>';

                $html .= '</tr>';
            }

            $html .= '</tbody></table></center>';
            $excel_data = '';

            if ($excel->sheets[0]['numCols'] <= 28 && $error_contenido_excel == 0) {
                $re_h = '<center><table class="table table-bordered contenedor my-sticky-column-table" border="1" id="data_expand" name="data_expand">';     // starts html table
                $re_h .= '<thead>';
                $re_h .= '<tr>';
                $re_h .= '<th>';
                $re_h .= 'CODIGO';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'NOMBRE';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'APELLIDO';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'FECHA DE NACIMIENTO';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'CORREO';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'DIRECCION';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'PAIS';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'DEPARTAMENTO';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'MUNICIPIO';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'GENERO';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'ESTADO CIVIL';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'DUI';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'NIT';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'TELEFONO';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'MEDIO CONTACTO';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'VENDEDOR';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'ULTIMA INSTITUCION ACADEMICA';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'NIVEL EDUCATIVO';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'PAIS';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'AÑO FINALIZACION';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'CONTACTO DE EMERGENCIA';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'CONTACTAR A';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'DIRECCION';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'TELEFONO';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'ULTIMA EXPERIENCIA LABORAL';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'DIRECCION';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'TELEFONO';
                $re_h .= '</th>';
                $re_h .= '<th>';
                $re_h .= 'PUESTO';
                $re_h .= '</th>';
                $re_h .= '</tr>';
                $re_h .= '</thead>';
                $excel_data .= '<center><h4>(<em>' . $excel->boundsheets[0]['name'] . '</em>)</h4></center><div class="table-container">' . $re_h . $html . '</div><br/>';
            } else if ($excel->sheets[0]['numCols'] > 28 && $error_contenido_excel == 0) {
                $excel_data .= '<center><h4>(<em>' . $excel->boundsheets[0]['name'] . '</em>)</h4></center><br/><center><h3>';
                $excel_data .= 'La hoja actual no cumple con el formato de las columnas: "[CODIGO][NOMBRE][APELLIDO][FECHA NACIMIENTO][CORREO][DIRECCION][PAIS][DEPARTAMENTO][MUNICIPIO][GENERO][ESTADO CIVIL][DUI][NIT][TELEFONO][MEDIO CONTACTO][VENDEDOR][INSTITUCION ACADEMICA][NIVEL EDUCATIVO][PAIS][AÑO FINALIZACION][CONTACTO EMERGENCIA][CONTACTAR A][DIRECCION][TELEFONO][EXPERIENCIA LABORAL][DIRECCION][TELEFONO][PUESTO]"</h3><br/>';
                $excel_data .= '<h4>Favor de revisar el documento de excel subido y cantidad de columas seleccionadas</h4></center><br/>';
            } else if ($error_contenido_excel > 0) {
                $excel_data .= '<center><h4>(<em>' . $excel->boundsheets[0]['name'] . '</em>)</h4></center><br/><center>';
                $excel_data .= $listado_errores;
                $excel_data .= '<h4>Favor de revisar el documento de excel subido y contrastarlo con la plantilla para verificar los datos</h4></center>';
            }

            $data['tabla_html'] = $excel_data;

            $data['error_contenido_excel'] = $error_contenido_excel > 0 ? true: false;

            $data['titulo_personal'] = 'Registro masivo de alumnos';
            $this->_cargarvista($data);
        }
    }

    function registro_alumnos_masivo(){
        parse_str($_POST['formulario'], $formAlumnos);

        $codigos = $formAlumnos['codigo_alumno'];
        $nombres = $formAlumnos['nombre_alumno'];
        $apellidos = $formAlumnos['apellido_alumno'];
        $fecha_nacimiento = $formAlumnos['fec_nacimiento_alumno'];
        $correos = $formAlumnos['correo_alumno'];
        $direccion = $formAlumnos['direccion_alumno'];
        $pais = $formAlumnos['pais_alumno'];
        $departamento = $formAlumnos['departamento_alumno'];
        $municipio = $formAlumnos['municipio_alumno'];
        $generos = $formAlumnos['genero_alumno'];
        $estado_civil = $formAlumnos['est_civil_alumno'];
        $duis = $formAlumnos['dui_alumno'];
        $nits = $formAlumnos['nit_alumno'];
        $tel_numero = $formAlumnos['tal_numero'];
        $medio_contacto = $formAlumnos['medio_contacto'];
        $vendedor = $formAlumnos['vendedor'];

        //nivel educativo
        $pais_edu = $formAlumnos['eda_id_pai'];
        $nivel_edu = $formAlumnos['eda_id_tie'];
        $institutcion_edu = $formAlumnos['eda_id_ina'];
        $anio_fecha_finalizacion = $formAlumnos['eda_anio_fecha_final'];
        //contacto de emergencia
        $parentesco = $formAlumnos['cla_id_pat'];
        $nombre_contacto = $formAlumnos['cla_familiar'];
        $direccion_contacto = $formAlumnos['cla_direccion_fam'];
        $telefono_contacto = $formAlumnos['cla_telefono'];
        //experiencia laboral
        $eal_empresa = $formAlumnos['eal_empresa'];
        $eal_direccion = $formAlumnos['eal_direccion'];
        $eal_telefono = $formAlumnos['eal_telefono'];
        $eal_puesto = $formAlumnos['eal_puesto'];

        $alm_registrados = 0;

        $this->db->trans_start();
        $error_ocurrido = false;
        $id_dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
        $id_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $id_tif = $this->gsatelite->get_parametro('SYS_ID_CONSUMIDOR_FINAL');
        $tpg = json_decode($this->gsatelite->get_parametro('SYS_ID_PAGO_EFECTIVO'), true);
        $id_tpg = $tpg['efectivo'];
        // Descripcion: Parametro utilizado para colocar un tipo de lista de precio predeterminada para utilizarse en facturacion.
        $id_tlp = $this->gsatelite->get_parametro('SYS_ID_TIPO_LISTA_PRECIO_ALUMNOS'); // Parametro predetermiado para tipo de lista

        foreach ($codigos as $key => $val) {
            try{
                // Verifica fechas si no es vacía antes de intentar convertirla
                if (!empty($fecha_nacimiento[$key])) {
                    $fecha_nacimiento[$key] = date('Y-m-d', strtotime(str_replace('/', '-', $fecha_nacimiento[$key])));
                } else {
                    $fecha_nacimiento[$key] = null;
                }            
                if (!empty($anio_fecha_finalizacion[$key])) {
                    $fecha_finalizacion = date('Y-m-d', strtotime($anio_fecha_finalizacion[$key].'-12-31'));
                } else {
                    $fecha_finalizacion = null;
                }
                $nombre_factura = $nombres[$key].' '.$apellidos[$key];
                /********************************* Cliente *******************************************************/
                $verificar_cod = $this->registro_academico_model->verificar_codigo(array("alm_codigo" => $codigos[$key]));
                if ($verificar_cod[0]["resultado"] == 1) {
                    $anio = date("y");
                    $apellidos_explode = explode(" ", strtoupper($apellidos[$key]));
                    if(count($apellidos_explode) == 1) {
                        $codigo_temp = substr($apellidos_explode[0], 0, 1).substr($apellidos_explode[0], 0, 1).$anio;
                    } else {
                        $iniciales_apellidos = substr($apellidos_explode[0], 0, 1).substr($apellidos_explode[1], 0, 1);
                        $codigo_temp = $iniciales_apellidos.$anio;
                    }
                    $ultimo_cod = $this->registro_academico_model->obtenerCodigo(trim($codigo_temp), 2);
                    $codigo_resultante =  $codigo_temp.($this->add_leading_zero(($ultimo_cod[0]["resul"] + 1), 4));
                } else {
                    $codigo_resultante = $codigos[$key];
                }

                // $verificar_usu_vendedor = $this->gsatelite->get_registro('ven_vendedor', array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1));
                // $vendedor = ($verificar_usu_vendedor && isset($verificar_usu_vendedor->ven_id)) ? $verificar_usu_vendedor->ven_id :null;

                $alumno_cliente = array(
                    'cli_apellido' => $apellidos[$key],
                    'cli_nombre' => $nombres[$key],
                    'cli_personeria' => 1,
                    'cli_id_tif' => $id_tif,
                    'cli_id_tpg' => $id_tpg,
                    'cli_nombre_factura'=> $nombre_factura,
                    'cli_estado' => 1,
                    'cli_email' => $correos[$key],
                    'cli_usu_mod' => $this->tank_auth->get_user_id(),
                    'cli_fecha_mod' => date('Y-m-d H:i:s'),
                    'cli_direccion' => $direccion[$key],
                    'cli_fecha_crea' => date('Y-m-d H:i:s'),
                    'cli_usu_crea' => $this->tank_auth->get_user_id(),
                    'cli_codigo' => $codigo_resultante,
                    'cli_fecha_registro' =>  date('Y-m-d'),
                    'cli_lugar_trabajo' => $eal_empresa[$key],
                    'cli_cargo' => $eal_puesto[$key],
                    'cli_id_mun' => $municipio[$key],
                    'cli_fecha_nacimiento' => $fecha_nacimiento[$key],
                    'cli_id_ven' => ($vendedor[$key] > 0)? $vendedor[$key] : null
                );
                $alm_cli = $this->gsatelite->ingresar('cli_cliente', $alumno_cliente);
                if ($alm_cli === null || $alm_cli == 0) {
                    $error_ocurrido = true;
                    $this->db->trans_rollback();
                    break;            
                }
                $alumno_cliente = array(
                    'cli_id_cli_asociado' => $alm_cli,
                    'cli_usu_mod' => $this->tank_auth->get_user_id(),
                    'cli_fecha_mod' => date('Y-m-d H:i:s')
                );        
                $actualizacion_asociado_cli = $this->gsatelite->actualizar('cli_cliente', $alumno_cliente, 'cli_id', $alm_cli);
                if ($actualizacion_asociado_cli == 0) {
                    $error_ocurrido = true;
                    $this->db->trans_rollback();
                    break;
                }

                // Insertar el Tipo Lista de precio cliente                
                if (isset($id_tlp) && is_numeric($id_tlp)) {
                    $tipo_precio_cliente_array = array(
                        'tpn_id_cli' => $alm_cli,
                        'tpn_id_tlp' => $id_tlp,                
                        'tpn_estado' => 1,
                        'tpn_usu_creacion' => $this->tank_auth->get_user_id(),
                        'tpn_fecha_creacion' => date('Y-m-d H:i:s'),
                        'tpn_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'tpn_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $registro_tpn = $this->gsatelite->ingresar('tpn_tipo_precio_cliente', $tipo_precio_cliente_array);
                    if ($registro_tpn === null || $registro_tpn == 0) {
                        $error_ocurrido = true;
                        $this->db->trans_rollback();
                        break;
                    }
                }

                /********************************* Usuario *******************************************************/
                $id_rol = $this->gsatelite->get_parametro('SYS_ID_ROL_ALUMNO'); // Rol alumno
                $pass = $this->encript_clave($codigo_resultante);
                $val  = $this->gsatelite->get_tabla('users',array('username' => $codigo_resultante));
                if (count($val) == 0) {
                    $datos = array(
                        'username' => $codigo_resultante,
                        'password' => $pass['password'],
                        'activated' => 1,
                        'banned' =>0,
                        'created' => date('Y-m-d H:i:s'),
                        'modified' => date('Y-m-d H:i:s')
                    );
                    $usu_alm = $this->gsatelite->ingresar('users', $datos);
                    if ($usu_alm === null || $usu_alm == 0) {
                        $error_ocurrido = true;
                        $this->db->trans_rollback();
                        break;
                    }
                    $info = array(
                        'uxr_id_usu' => $usu_alm,
                        'uxr_id_rol' => $id_rol
                    );
                    $registro_roles_usu = $this->gsatelite->ingresar('uxr_usuarioxrol', $info);
                    if ($registro_roles_usu === null || $registro_roles_usu == 0) {
                        $error_ocurrido = true;
                        $this->db->trans_rollback();
                        break;
                    }
                }

                /********************************* Alumno *******************************************************/
                $sucursal = $this->tank_auth->get_sucursal_id();
        
                $alumno_campos = array(
                    'alm_id_suc' => ($sucursal > 0) ? $sucursal : null,
                    'alm_id_pai' => $pais[$key],
                    'alm_id_dep' => $departamento[$key],
                    'alm_id_mun' => $municipio[$key],
                    'alm_id_gen' => $generos[$key] == 'M' ? 1: 2,
                    'alm_id_esc' => $estado_civil[$key],
                    'alm_id_cli' => $alm_cli,
                    'alm_id_usu' => $usu_alm,
                    'alm_codigo' => $codigo_resultante,
                    'alm_nombre' => $nombres[$key],
                    'alm_apellido' => $apellidos[$key],
                    'alm_fecha_nacimiento' => $fecha_nacimiento[$key],
                    'alm_direccion' => $direccion[$key],
                    'alm_email' => $correos[$key],
                    'alm_becado' => 0,
                    'alm_trabaja' => 0,
                    'alm_posee_hijos' => 0,
                    'alm_estado' => 1,
                    'alm_usu_crea' => $this->tank_auth->get_user_id(),
                    'alm_fecha_crea' => date('Y-m-d H:i:s'),
                    'alm_usu_mod' => $this->tank_auth->get_user_id(),
                    'alm_fecha_mod' => date('Y-m-d H:i:s')     
                );
                $alm_id = $this->gsatelite->ingresar('alm_alumno', $alumno_campos);
                if ($alm_id === null || $alm_id == 0) {
                    $error_ocurrido = true;
                    $this->db->trans_rollback();
                    break;
                }

                //DUI
                $dui_alm_campos = array(
                    'dca_id_alm' => $alm_id,
                    'dca_id_tde' => $id_dui,
                    'dca_valor' => $duis[$key],
                    'dca_fecha_vence' => null,
                    'dca_nombre_anexo' => null,
                    'dca_url' => null,
                    'dca_fecha_expedicion' => null,
                    'dca_lugar_expedicion' => null,
                    'dca_estado' => 1,
                    'dca_usu_mod' => $this->tank_auth->get_user_id(),
                    'dca_fecha_mod' => date('Y-m-d H:i:s'),
                    'dca_usu_crea' => $this->tank_auth->get_user_id(),
                    'dca_fecha_crea' => date('Y-m-d H:i:s')
                );
                $registro_dui_alm = $this->gsatelite->ingresar('dca_documento_alumno', $dui_alm_campos);
                if ($registro_dui_alm === null || $registro_dui_alm == 0) {
                    $error_ocurrido = true;
                    $this->db->trans_rollback();
                    break;
                }
                $dui_cli_campos = array(
                    'dcc_id_cli' => $alm_cli,
                    'dcc_id_tde' => $id_dui,
                    'dcc_valor' => $duis[$key],
                    'dcc_fecha_vence' => null,
                    'dcc_nombre_anexo' => null,
                    'dcc_url' => null,
                    'dcc_fecha_expedicion' => null,
                    'dcc_lugar_expedicion' => null,
                    'dcc_estado' => 1,
                    'dcc_usu_mod' => $this->tank_auth->get_user_id(),
                    'dcc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dcc_usu_crea' => $this->tank_auth->get_user_id(),
                    'dcc_fecha_crea' => date('Y-m-d H:i:s')
                );
                $registro_dui_cli = $this->gsatelite->ingresar('dcc_documento_cliente', $dui_cli_campos);
                if ($registro_dui_cli === null || $registro_dui_cli == 0) {
                    $error_ocurrido = true;
                    $this->db->trans_rollback();
                    break;
                }

                //NIT
                if (!empty($nits[$key])) {
                    $nit_alm_campos = array(
                        'dca_id_alm' => $alm_id,
                        'dca_id_tde' => $id_nit,
                        'dca_valor' => $nits[$key],
                        'dca_fecha_vence' => null,
                        'dca_nombre_anexo' => null,
                        'dca_url' => null,
                        'dca_fecha_expedicion' => null,
                        'dca_lugar_expedicion' => null,
                        'dca_estado' => 1,
                        'dca_usu_mod' => $this->tank_auth->get_user_id(),
                        'dca_fecha_mod' => date('Y-m-d H:i:s'),
                        'dca_usu_crea' => $this->tank_auth->get_user_id(),
                        'dca_fecha_crea' => date('Y-m-d H:i:s')
                    );
                    $registro_nit_alm = $this->gsatelite->ingresar('dca_documento_alumno', $nit_alm_campos);
                    if ($registro_nit_alm === null || $registro_nit_alm == 0) {
                        $error_ocurrido = true;
                        $this->db->trans_rollback();
                        break;
                    }
                    $nit_cli_campos = array(
                        'dcc_id_cli' => $alm_cli,
                        'dcc_id_tde' => $id_nit,
                        'dcc_valor' => $nits[$key],
                        'dcc_fecha_vence' => null,
                        'dcc_nombre_anexo' => null,
                        'dcc_url' => null,
                        'dcc_fecha_expedicion' => null,
                        'dcc_lugar_expedicion' => null,
                        'dcc_estado' => 1,
                        'dcc_usu_mod' => $this->tank_auth->get_user_id(),
                        'dcc_fecha_mod' => date('Y-m-d H:i:s'),
                        'dcc_usu_crea' => $this->tank_auth->get_user_id(),
                        'dcc_fecha_crea' => date('Y-m-d H:i:s')
                    );
                    $registro_nit_cli = $this->gsatelite->ingresar('dcc_documento_cliente', $nit_cli_campos);
                    if ($registro_nit_cli === null || $registro_nit_cli == 0) {
                        $error_ocurrido = true;
                        $this->db->trans_rollback();
                        break;
                    }
                }
                if ($medio_contacto[$key] > 0) {
                    $medio_campos = array(
                        'mxl_id_alm' => $alm_id,
                        'mxl_id_tmc' => $medio_contacto[$key],
                        'mxl_estado' => 1,
                        'mxl_usu_creacion' => $this->tank_auth->get_user_id(),
                        'mxl_fecha_creacion' => date('Y-m-d H:i:s'),
                        'mxl_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'mxl_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('mxl_medioxalumno', $medio_campos);
                }

                //TELEFONO
                $telefono_campos = array(
                    'tal_id_alm' => $alm_id,
                    'tal_id_tit' => 1, //"persoanal en AG"
                    'tal_numero' => $tel_numero[$key],
                    'tal_estado' => 1,
                    'tal_usu_crea' => $this->tank_auth->get_user_id(),
                    'tal_usu_mod' => $this->tank_auth->get_user_id(),
                    'tal_fecha_crea' => date('Y-m-d H:i:s'),
                    'tal_fecha_mod' => date('Y-m-d H:i:s')
                );
                $registro_telefono_alumno = $this->gsatelite->ingresar('tal_telefonoxalumno', $telefono_campos);
                $tels_cli = array(
                    'txc_id_cli' => $alm_cli,
                    'txc_id_tit' => 1,
                    'txc_numero' => $tel_numero[$key],
                    'txc_estado' => 1,
                    'txc_usu_mod' => $this->tank_auth->get_user_id(),
                    'txc_fecha_mod' => date('Y-m-d H:i:s')
                );                
                $this->gsatelite->ingresar('txc_telefonoxcliente', $tels_cli);
                if ($registro_telefono_alumno === null || $registro_telefono_alumno == 0) {
                    $error_ocurrido = true;
                    $this->db->trans_rollback();
                    break;
                }
                
                if(!empty($institutcion_edu[$key])) {
                    //DATO ACADEMICO
                    $datos_academicos = array(
                        'eda_id_alm' => $alm_id,
                        'eda_id_pai' => $pais_edu[$key],
                        'eda_id_tie' => $nivel_edu[$key], //nivel educativo
                        'eda_id_ina' => $institutcion_edu[$key],
                        'eda_fecha_final' => $fecha_finalizacion,
                        'eda_estado' => 1,
                        'eda_usu_creacion' => $this->tank_auth->get_user_id(),
                        'eda_fecha_creacion' => date('Y-m-d H:i:s'),
                        'eda_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'eda_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $registro_edu_alm = $this->gsatelite->ingresar('eda_educacion_alumno', $datos_academicos);
                    if ($registro_edu_alm === null || $registro_edu_alm == 0) {
                        $error_ocurrido = true;
                        $this->db->trans_rollback();
                        break;
                    }

                }

                if(!empty($parentesco[$key])){
                    //CONTACTO DE EMERGENCIA
                    $datos_clinicos_campos = array(
                        'cla_id_alm' => $alm_id,
                        'cla_id_pat' => $parentesco[$key],
                        'cla_familiar' => $nombre_contacto[$key],
                        'cla_direccion_fam' => $direccion_contacto[$key],
                        'cla_telefono' => $telefono_contacto[$key],
                        'cla_estado' => 1,
                        'cla_usu_mod' => $this->tank_auth->get_user_id(),
                        'cla_fecha_mod' => date('Y-m-d H:i:s'),
                        'cla_usu_crea' => $this->tank_auth->get_user_id(),
                        'cla_fecha_crea' => date('Y-m-d H:i:s')
                    );
                    $registro_parentesco_alm = $this->gsatelite->ingresar('cla_clinico_alumno', $datos_clinicos_campos);
                    if ($registro_parentesco_alm === null || $registro_parentesco_alm == 0) {
                        $error_ocurrido = true;
                        $this->db->trans_rollback();
                        break;
                    }
                }

                if(!empty($eal_empresa[$key])) {
                    //EXPERIENCIA LABORAL
                    $referencia_lab_campos = array(
                        'eal_id_alm' => $alm_id,
                        'eal_empresa' => $eal_empresa[$key],
                        'eal_direccion' => $eal_direccion[$key],
                        'eal_telefono' => $eal_telefono[$key],
                        'eal_puesto' => $eal_puesto[$key],
                        'eal_jefe_inmediato' => null,
                        'eal_salario' => null,
                        'eal_motivo_retiro' => null,
                        'eal_estado' => 1,
                        'eal_usu_crea' => $this->tank_auth->get_user_id(),
                        'eal_fecha_crea' => date('Y-m-d H:i:s'),
                        'eal_usu_mod' => $this->tank_auth->get_user_id(),
                        'eal_fecha_mod' => date('Y-m-d H:i:s')
                    );                
                    $registro_exp_laboral = $this->gsatelite->ingresar('eal_empleo_alumno', $referencia_lab_campos);
                    if ($registro_exp_laboral === null || $registro_exp_laboral == 0) {
                        $error_ocurrido = true;
                        $this->db->trans_rollback();
                        break;
                    }
                }

            } catch(Exception $e){
                $error_ocurrido = true;
                $this->db->trans_rollback();
                break;
            }
        }

        if (!$error_ocurrido) {
            $this->db->trans_commit();
            $arreglo = array("act" => '1');
        } else {
            $this->db->trans_rollback();
            $arreglo = array("act" => '0');
        }
        
        ob_end_clean();
        echo json_encode($arreglo);
        exit();die();
    }

    /*
     * Registro de alumnos
     * 
     * @author Edith Herrera
     * @since 11/11/2015
     * @author Habby Lovo
     * @since 20/04/2016
     */

    function agregar_alumno() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            // validar parametro
            $idTipoFactura = $this->gsatelite->get_parametro('SYS_ID_CONSUMIDOR_FINAL');
            $vadTipoFactura = $this->gsatelite->get_tabla('tif_tipo_factura', array('tif_id'=>$idTipoFactura, 'tif_estado'=>1));
            if (!$vadTipoFactura > 0) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "No Existe el Parametro", 'texto_alerta' => "El Parametro utilizado no existe"); 
                $this->session->set_flashdata($alerta);  
                redirect(base_url('registro_academico/procesos/gestion_alumnos'));
            }

            //tab_generales
            $religion_drop = $this->gsatelite->get_dropdown('rel_religion', '{rel_nombre}', '', array('rel_estado' => 1), null, '', 'rel_id', true);
            $data['religion'] = str_replace('<option value="0">Seleccione</option>', '', $religion_drop);

            //$grupo_fam_drop = $this->gsatelite->get_dropdown('gfa_grupo_familiar', '{gfa_nombre}', '', array('gfa_estado' => 1), null, '', 'gfa_id', true);
            //$data['grupo_familiar'] = str_replace('<option value="0">Seleccione</option>', '', $grupo_fam_drop);

            $estado_familiar_drop = $this->gsatelite->get_dropdown('esf_estado_familia', '{esf_nombre}', '', array('esf_estado' => 1), null, '', 'esf_id', true);
            $data['estado_familiar'] = str_replace('<option value="0">Seleccione</option>', '', $estado_familiar_drop);

            $financiamiento_drop = $this->gsatelite->get_dropdown('fin_financiamiento', '{fin_nombre}', '', array('fin_estado' => 1), null, '', 'fin_id', true);
            $data['financiamiento'] = str_replace('<option value="0">Seleccione</option>', '', $financiamiento_drop);

            $tipo_trasporte_drop = $this->gsatelite->get_dropdown('ttr_tipo_transporte', '{ttr_nombre}', '', array('ttr_estado' => 1), null, '', 'ttr_id', true);
            $data['tipo_trasporte'] = str_replace('<option value="0">Seleccione</option>', '', $tipo_trasporte_drop);

            $estado_familiar_drop = $this->gsatelite->get_dropdown('esa_estado_alumno', '{esa_nombre}', '', array('esa_estado' => 1), null, '', 'esa_id', true);
            $data['estado_alumno'] = str_replace('<option value="0">Seleccione</option>', '', $estado_familiar_drop);

            $tipo_ingreso_drop = $this->gsatelite->get_dropdown('tin_tipo_ingreso', '{tin_nombre}', '', array('tin_estado' => 1), null, '', 'tin_id', true);
            $data['tipo_ingreso'] = str_replace('<option value="0">Seleccione</option>', '', $tipo_ingreso_drop);

            $tipo_medio_drop = $this->gsatelite->get_dropdown('tmc_tipo_medio', '{tmc_nombre}', '', array('tmc_estado' => 1), null, '', 'tmc_id', true);
            $data['tipo_medio'] = str_replace('<option value="0">Seleccione</option>', '', $tipo_medio_drop);

            $caracteristica_eleccion_drop = $this->gsatelite->get_dropdown('cre_caracteristica_eleccion', '{cre_nombre}', '', array('cre_estado' => 1), null, '', 'cre_id', true);
            $data['caracteristica_eleccion'] = str_replace('<option value="0">Seleccione</option>', '', $caracteristica_eleccion_drop);

            //tab_generales2
            $genero_drop = $this->gsatelite->get_dropdown('gen_genero', '{gen_nombre}', '', '', null, '', 'gen_id', true);
            $data['genero'] = str_replace('<option value="0">Seleccione</option>', '', $genero_drop);

            $estado_civil_drop = $this->gsatelite->get_dropdown('esc_estado_civil', '{esc_nombre}', '', array('esc_estado' => 1), null, '', 'esc_id', true);
            $data['estado_civil'] = str_replace('<option value="0">Seleccione</option>', '', $estado_civil_drop);

            $emr_id = $this->tank_auth->get_empresa_id();
            $id_pai = $this->gsatelite->get_campo('emr_empresa', 'emr_id_pai', array('emr_id'=>$emr_id));
           
            $pais_drop = $this->gsatelite->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), $id_pai, '', 'pai_id', true);
            $data['pais'] = str_replace('<option value="0">Seleccione</option>', '', $pais_drop);
            //die(print_r($id_pai));
            if($id_pai>0){
                $departamento_drop = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', array('dep_id_pai'=>$id_pai), null, '', 'dep_id', true);
                $data['departamentos'] = str_replace('<option value="0">Seleccione</option>', '',$departamento_drop);

                $nacionalidad_drop = $this->gsatelite->get_dropdown('pai_pais', '{pai_nacionalidad}', '', array('pai_estado' => 1, 'pai_id'=>$id_pai), $id_pai, '', 'pai_id', true);
                $data['nacionalidad'] = str_replace('<option value="0">Seleccione</option>', '', $nacionalidad_drop);
            }else{
                $nacionalidad_drop = $this->gsatelite->get_dropdown('pai_pais', '{pai_nacionalidad}', '', array('pai_estado' => 1), null, '', 'pai_id', true);
                $data['nacionalidad'] = str_replace('<option value="0">Seleccione</option>', '', $nacionalidad_drop);
            }            

            $zona_drop = $this->gsatelite->get_dropdown('zon_zona', '{zon_nombre}', '', array('zon_estado' => 1), null, '', 'zon_id', true);
            $data['zona'] = str_replace('<option value="0">Seleccione</option>', '', $zona_drop);

            //tab telefonos
            $redes_drop = $this->gsatelite->get_dropdown('res_red_social', '{res_nombre}', '', array('res_estado' => 1), null, '', 'res_id', true);
            $data['red_social'] = str_replace('<option value="0">Seleccione</option>', '', $redes_drop);


            //tab_datos_academicos
            $institucion_academica_drop = $this->gsatelite->get_dropdown('ina_institucion_academica', '{ina_nombre}', '', array('ina_estado' => 1), null, '', 'ina_id', true);
            $data['institucion_academica'] = str_replace('<option value="0">Seleccione</option>', '', $institucion_academica_drop);
           
            $titulo_educacion_drop = $this->gsatelite->get_dropdown('ted_titulo_educacion', '{ted_nombre}', '', array('ted_estado' => 1), null, '', 'ted_id', true);
            $data['titulo_educacion'] = str_replace('<option value="0">Seleccione</option>', '', $titulo_educacion_drop);

            //tab_familiares
            $parentesco_drop = $this->gsatelite->get_dropdown('pat_parentesco', '{pat_nombre}', '', array('pat_estado' => 1), null, '', 'pat_id', true);
            $data['parentesco'] = str_replace('<option value="0">Seleccione</option>', '', $parentesco_drop);
            $profesion_drop = $this->gsatelite->get_dropdown('pro_profesion', '{pro_nombre}', '', array('pro_estado' => 1), null, '', 'pro_id', true);
            $data['profesion'] = str_replace('<option value="0">Seleccione</option>', '', $profesion_drop);
            //$empleado_drop = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
            //$data['empleado'] = str_replace('<option value="0">Seleccione</option>', '', $empleado_drop);

            //$alumnos_drop = $this->gsatelite->get_dropdown('alm_alumno', '{alm_nombre} {alm_apellido}', '', array('alm_estado' => 1), null, '', 'alm_id', true);
            //$data['alumnos'] = str_replace('<option value="0">Seleccione</option>', '', $alumnos_drop);

            //tab_clinicos
            $tipo_tratamiento_drop = $this->gsatelite->get_dropdown('ttm_tipo_tratamiento', '{ttm_nombre}', '', array('ttm_estado' => 1), null, '', 'ttm_id', true);
            $data['tipo_tratamiento'] = str_replace('<option value="0">Seleccione</option>', '', $tipo_tratamiento_drop);

            //tab_habilidade/pasatiempos
            $habilidades_drop = $this->gsatelite->get_dropdown('tih_tipo_habilidad', '{tih_nombre}', '', array('tih_estado' => 1), null, '', 'tih_id', true);
            $data['tipo_habilidad'] = str_replace('<option value="0">Seleccione</option>', '', $habilidades_drop);

            $pasatiempo_drop = $this->gsatelite->get_dropdown('pst_pasatiempo', '{pst_nombre}', '', array('pst_estado' => 1), null, '', 'pst_id', true);
            $data['tipo_pasatiempo'] = str_replace('<option value="0">Seleccione</option>', '', $pasatiempo_drop);

            $data['tipo_telefono'] = $this->gsatelite->get_tabla('tit_tipo_telefono', array('tit_estado' => 1));
            $data['doc_documentos'] = $this->gsatelite->get_tabla('tde_tipo_documento');
            $data['area_academica'] = $this->gsatelite->get_tabla('ard_area_academica', array('ard_estado' => 1));
            $data['tipo_educacion'] = $this->gsatelite->get_tabla('tie_tipo_educacion', array('tie_estado' => 1));
            $data['idm_idioma'] = $this->gsatelite->get_tabla('idm_idioma', array('idm_estado' => 1));
            $data['nivel_idioma'] = $this->gsatelite->get_tabla('nii_nivel_idioma', array('nii_estado' => 1));

            /* Codigo generado automaticamente para el carnet de estudiante */
            /*
            *   Anio + correlativo - centro cultural
            */
            if($this->gsatelite->get_parametro('SYS_GENERACION_CODIGO_ALUMNO')==1){ 
                $anio        = date('Y');
                $correlativo = $this->gsatelite->count('alm_alumno');
                $data['codigo_carnet']  = $anio.str_pad(($correlativo + 1) , 4, "0", STR_PAD_LEFT);
            }
            /* ************************************************************ */

            $tipos_doc = $this->gsatelite->get_dropdown('tde_tipo_documento', '{tde_nombre}', '', array('tde_estado' => 1), null, '', 'tde_id', true);
            $data['options_tipo_documento'] = str_replace('<option value="0">Seleccione</option>', '', $tipos_doc);

            $tipo_financi = $this->gsatelite->get_dropdown('fin_financiamiento', '{fin_nombre}', '', array('fin_estado' => 1), null, '', 'fin_id', true);
            $data['tipos_fin_financiamiento'] = str_replace('<option value="0">Seleccione</option>', '', $tipo_financi);

            $verificar_usu_vendedor = $this->gsatelite->get_registro('ven_vendedor', array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1));
            
            $vendedor = ($verificar_usu_vendedor && isset($verificar_usu_vendedor->ven_id)) ? $verificar_usu_vendedor->ven_id :null;
                                                    
            $vendedores = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => '1'), $vendedor, '', 'ven_id', true);
            $data['vendedor'] = str_replace('<option value="0">Seleccione</option>', '', $vendedores);

            $data["titulo_personal"] = "Ficha del estudiante";
            $data["permiso_nuevo_cliente"] = $this->gsatelite->get_permisos_opcion('facturacion/entradas/clientes', null, null, true);

            //Incluir sucursales
            $sucursal = $this->tank_auth->get_sucursal_id();
            if (is_null($sucursal) || count($sucursal) == 0 || $sucursal == false) {//SI NO EXISTE EL PARAMETRO O NO ESTA BIEN CONFIURADO ABORTAR OPERACION
                $usuario_sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_estado'=>1,'usc_id_usu'=>$this->tank_auth->get_user_id()));
                if(count($usuario_sucursal) > 0) {
                    $this->_cargarvista($data);
                } else {
                    $url = 'registro_academico/procesos/gestion_alumnos';
                    $this->gsatelite->show_dialog('Verifique que su usuario tenga sucursal', $url, 'error', 'Error de Parámetro');
                }
            } else {
                $this->_cargarvista($data);
            }
        }
    }

    function add_leading_zero($value, $threshold = 2) {
        return sprintf('%0' . $threshold . 's', $value);
    }

    function verificar_codigo_alumno() {
        $opcion = $this->input->post('opcion');
        $datos_alumno = $this->input->post('datos');
        if($opcion == 1){
            $anio = date("Y");
            $ultimo_cod = $this->registro_academico_model->obtenerCodigo($anio);
            $codigo = $anio . ($this->add_leading_zero(($ultimo_cod[0]["resul"] + 1), 4));
        } else if($opcion == 2){
            $anio = date("y");
            $apellidos = explode(" ", strtoupper($datos_alumno['alumno_apellido']));

            if(count($apellidos) == 1) {
                $codigo_temp = substr($apellidos[0], 0, 1).substr($apellidos[0], 0, 1).$anio;
            } else {
                $iniciales_apellidos = substr($apellidos[0], 0, 1).substr($apellidos[1], 0, 1);
                $codigo_temp = $iniciales_apellidos.$anio;
            }

            $ultimo_cod = $this->registro_academico_model->obtenerCodigo(trim($codigo_temp), $opcion);
            $codigo =  $codigo_temp.($this->add_leading_zero(($ultimo_cod[0]["resul"] + 1), 4));
        }
        echo json_encode(array('resp' => $codigo));
    }

    function comprobar_codigo_alumno() {
        $codigo = $this->input->post('codigo');
        $ultimo_cod = $this->registro_academico_model->verificar_codigo(array("alm_codigo" => $codigo));

        echo json_encode(array('resp' => $ultimo_cod[0]["resultado"]));
    }

    /* =============================================================================================
      INICIO DE INGRESO DE ALUMNO
      ===============================================================================================
     */

    public function get_clientes_factura_like() {

        satelite_validar(true);
        
        $cliente = ($this->input->post('cliente') != '') ? $this->input->post('cliente') : null;
        $where  = null;
        $like   = null;
        $arreglo = array();

        if ($cliente != null) {

            $where['cli_estado'] = 1;

            $like = array("CONCAT(cli_nombre, ' ', cli_apellido)" => $cliente);

            $resultado = $this->registro_academico_model->get_clientes($where, $like);
            if (count($resultado) > 0) {
                foreach ($resultado as $key => $value) {
                    $arreglo[$key]['cliente'] = $value['cli_id'];
                    $arreglo[$key]['cliente_nombre'] = $value['cliente'];
                }
            }
        }

        echo json_encode($arreglo);
    }

    /**
     * Ingresar un nuevo alumno
     * 
     * @author Habby Lovo
     * @since 27/04/2017
     */
    function nuevo_alumno() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // var_dump($_POST);die();
            //Tab datos generales
            $dtg_religion = (trim($this->input->post('dtg_religion')) != "") ? $this->input->post('dtg_religion') : null;
            $dtg_profesion = (trim($this->input->post('dtg_profesion')) != "") ? $this->input->post('dtg_profesion') : null;
            $dtg_nmiembros = (trim($this->input->post('dtg_nmiembros')) != "") ? $this->input->post('dtg_nmiembros') : null;
            $dtg_trabajo = (trim($this->input->post('dtg_trabajo')) != "") ? 1 : 0; //ibutton
            $dtg_hijos = (trim($this->input->post('dtg_hijos')) != "") ? 1 : 0; //ibutton
            $dtg_email = (trim($this->input->post('dtg_email')) != "") ? $this->input->post('dtg_email') : null;
            $dtg_gfamiliar = (trim($this->input->post('dtg_gfamiliar')) != "") ? $this->input->post('dtg_gfamiliar') : null;
            $dtg_estfamiliar = (trim($this->input->post('dtg_estfamiliar')) != "") ? $this->input->post('dtg_estfamiliar') : null;
            $dtg_becado = (trim($this->input->post('dtg_becado')) != "") ? 1 : 0; //ibutton
            $dtg_financiamiento = (trim($this->input->post('dtg_financiamiento')) != "") ? $this->input->post('dtg_financiamiento') : null;
            $dtg_trasporte = (trim($this->input->post('dtg_trasporte')) != "") ? $this->input->post('dtg_trasporte') : null;

            $dtg_estestudiante = (trim($this->input->post('dtg_estestudiante')) != "") ? $this->input->post('dtg_estestudiante') : null; //alm
            $dtg_tipingreso = (trim($this->input->post('dtg_tipingreso')) != "") ? $this->input->post('dtg_tipingreso') : null; //alm
            $dtg_observacion = (trim($this->input->post('dtg_observacion')) != "") ? $this->input->post('dtg_observacion') : null; //alm
            $dtg_aspiracion = (trim($this->input->post('dtg_aspiracion')) != "") ? $this->input->post('dtg_aspiracion') : null; //alm
            //Tab datos generales2
            $dtg2_codigo = (trim($this->input->post('dtg2_codigo')) != "") ? $this->input->post('dtg2_codigo') : null; //alm
            $dtg2_nie = (trim($this->input->post('dtg2_nie')) != "") ? $this->input->post('dtg2_nie') : null; //alm
            $dtg2_nombre = (trim($this->input->post('dtg2_nombre')) != "") ? $this->input->post('dtg2_nombre') : null; //alm
            $dtg2_apellido = (trim($this->input->post('dtg2_apellido')) != "") ? $this->input->post('dtg2_apellido') : null; //alm
            $dtg2_genero = (trim($this->input->post('dtg2_genero')) != "") ? $this->input->post('dtg2_genero') : null; //alm
            $dtg2_estcivil = (trim($this->input->post('dtg2_estcivil')) != "") ? $this->input->post('dtg2_estcivil') : null; //alm
            $dtg2_pais_residencia = (trim($this->input->post('dtg2_pais_residencia')) != "") ? $this->input->post('dtg2_pais_residencia') : null;
            $dtg2_departamento_residencia = (trim($this->input->post('dtg2_departamento_residencia')) != "") ? $this->input->post('dtg2_departamento_residencia') : null;
            $dtg2_municipio_residencia = (trim($this->input->post('dtg2_municipio_residencia')) != "") ? $this->input->post('dtg2_municipio_residencia') : null;
            $dtg2_direccion_residencia = (trim($this->input->post('dtg2_direccion_residencia')) != "") ? $this->input->post('dtg2_direccion_residencia') : null; //alm
            $dtg2_distancia_residencia = (trim($this->input->post('dtg2_distancia_residencia')) != "") ? $this->input->post('dtg2_distancia_residencia') : null; //alm
            $dtg2_nacionalidad_nacimiento = (trim($this->input->post('dtg2_nacionalidad_nacimiento')) != "") ? $this->input->post('dtg2_nacionalidad_nacimiento') : null; //alm
            $dtg2_nnacionalidad_nacimiento = (trim($this->input->post('dtg2_nnacionalidad_nacimiento')) != "") ? $this->input->post('dtg2_nnacionalidad_nacimiento') : null; //alm
            $dtg2_departamento_nacimiento = (trim($this->input->post('dtg2_departamento_nacimiento')) != "") ? $this->input->post('dtg2_departamento_nacimiento') : null; //alm
            $dtg2_municipio_nacimiento = (trim($this->input->post('dtg2_municipio_nacimiento')) != "") ? $this->input->post('dtg2_municipio_nacimiento') : null; //alm
            $dtg2_lugar_nacimiento = (trim($this->input->post('dtg2_lugar_nacimiento')) != "") ? $this->input->post('dtg2_lugar_nacimiento') : null; //alm
            $dtg2_nacimiento = (trim($this->input->post('dtg2_nacimiento')) != "") ? date('Y-m-d', strtotime(trim($this->input->post('dtg2_nacimiento')))) : null; //alm
            $dtg2_area_nacimiento = (trim($this->input->post('dtg2_area_nacimiento')) != "") ? $this->input->post('dtg2_area_nacimiento') : null; //alm
            $dtg2_vendedor = (trim($this->input->post('dtg2_vendedor')) != "") ? $this->input->post('dtg2_vendedor') : null; 

            $dtg2_empresa_convenio = (trim($this->input->post('slcEmpresa')) != "") ? $this->input->post('slcEmpresa') : null; //alm

            $dtg_id_asociado = null;
            $dtg_nombre_factura = null;

            $cliente_factura = $this->input->post('txtNombreFac');

            if(isset($cliente_factura) && trim($cliente_factura) != "") {
                $cliente_asociado = $this->gsatelite->get_registro('cli_cliente', 'cli_id', $cliente_factura);

                $dtg_id_asociado = $cliente_factura;
                $dtg_nombre_factura = $cliente_asociado->cli_nombre.' '.$cliente_asociado->cli_apellido;
            } else {
                $dtg_nombre_factura = $dtg2_nombre.' '.$dtg2_apellido;
            }

            /********************************* Cliente *******************************************************/
            $verificar_cod = $this->registro_academico_model->verificar_codigo(array("alm_codigo" => $dtg2_codigo));

            if ($verificar_cod[0]["resultado"] == 1) {
                $anio = date("Y");
                $ultimo_cod = $this->registro_academico_model->obtenerCodigo($anio);
                $codigo = $anio . ($this->add_leading_zero(($ultimo_cod[0]["resul"] + 1), 4));
                $dtg2_codigo = (trim($codigo) != "") ? $codigo : null; //alm
            }

            $id_tif = $this->gsatelite->get_parametro('SYS_ID_CONSUMIDOR_FINAL');
            $tpg = json_decode($this->gsatelite->get_parametro('SYS_ID_PAGO_EFECTIVO'), true);
            $id_tpg = $tpg['efectivo'];
            $lugtrab = (is_array($this->input->post('rlab_lugar')) && count($this->input->post('rlab_lugar')) > 0) ? trim($this->input->post('rlab_lugar')[0]) : null;
            $crgtrab = (is_array($this->input->post('rlab_puesto')) && count($this->input->post('rlab_puesto')) > 0) ? trim($this->input->post('rlab_puesto')[0]) : null;

            $alumno_cliente = array(
                'cli_apellido' => $dtg2_apellido,
                'cli_nombre' => $dtg2_nombre,
                'cli_personeria' => 1,
                'cli_id_tif' => $id_tif,
                'cli_id_tpg' => $id_tpg,
                'cli_observacion' => $dtg_observacion,
                'cli_nombre_factura'=> $dtg_nombre_factura,
                'cli_id_cli_asociado' => $dtg_id_asociado,
                'cli_estado' => 1,
                'cli_email' => $dtg_email,
                'cli_usu_mod' => $this->tank_auth->get_user_id(),
                'cli_fecha_mod' => date('Y-m-d H:i:s'),
                'cli_direccion' => $dtg2_direccion_residencia,
                'cli_fecha_crea' => date('Y-m-d'),
                'cli_usu_crea' => $this->tank_auth->get_user_id(),
                'cli_codigo' => $dtg2_codigo,
                'cli_id_pro' => $dtg_profesion,
                'cli_lugar_trabajo' => $lugtrab,
                'cli_cargo' => $crgtrab,
                'cli_fecha_registro' =>  date('Y-m-d'),
                'cli_id_mun' => $dtg2_municipio_residencia,
                'cli_fecha_nacimiento' => $dtg2_nacimiento,
                'cli_id_ven' => $dtg2_vendedor
            );
            $alm_cli = $this->gsatelite->ingresar('cli_cliente', $alumno_cliente);
            if(!isset($dtg_id_asociado)) {
                $alumno_cliente = array(
                    'cli_id_cli_asociado' => $alm_cli,
                    'cli_usu_mod' => $this->tank_auth->get_user_id(),
                    'cli_fecha_mod' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('cli_cliente', $alumno_cliente, array('cli_id' => $alm_cli));
            }

            // Insertar el Tipo Lista de precio cliente
            // Descripcion: Parametro utilizado para colocar un tipo de lista de precio predeterminada para utilizarse en facturacion.
            $id_tlp = $this->gsatelite->get_parametro('SYS_ID_TIPO_LISTA_PRECIO_ALUMNOS'); // Parametro predetermiado para tipo de lista
            if (isset($id_tlp) && is_numeric($id_tlp)) {
                $tipo_precio_cliente_array = array(
                    'tpn_id_cli' => $alm_cli,
                    'tpn_id_tlp' => $id_tlp,                
                    'tpn_estado' => 1,
                    'tpn_usu_creacion' => $this->tank_auth->get_user_id(),
                    'tpn_fecha_creacion' => date('Y-m-d H:i:s'),
                    'tpn_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'tpn_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('tpn_tipo_precio_cliente', $tipo_precio_cliente_array);
            }

            /********************************* Usuario *******************************************************/           
            $id_rol = $this->gsatelite->get_parametro('SYS_ID_ROL_ALUMNO'); // Rol alumno
            $pass = $this->encript_clave($dtg2_codigo);
            $val  = $this->gsatelite->get_tabla('users',array('username' => $dtg2_codigo));
            if (count($val) == 0) {
                $datos = array(
                    'username' => $dtg2_codigo,
                    'password' => $pass['password'],
                    'activated' => 1,
                    'banned' =>0,
                    'created' => date('Y-m-d H:i:s'),
                    'modified' => date('Y-m-d H:i:s')
                );
                $usu_alm = $this->gsatelite->ingresar('users', $datos);
                $info = array(
                    'uxr_id_usu' => $usu_alm,
                    'uxr_id_rol' => $id_rol
                );
                $this->gsatelite->ingresar('uxr_usuarioxrol', $info);
            }

            /********************************* Alumno *******************************************************/
            $sucursal = $this->tank_auth->get_sucursal_id();
            $alumno_campos = array(
                'alm_id_suc' => ($sucursal > 0) ? $sucursal : null,
                'alm_id_pai' => $dtg2_pais_residencia,
                'alm_id_dep' => $dtg2_departamento_residencia,
                'alm_id_mun' => $dtg2_municipio_residencia,
                'alm_id_gen' => $dtg2_genero,
                'alm_id_esc' => $dtg2_estcivil,
                'alm_id_pro' => $dtg_profesion,
                'alm_id_fin' => $dtg_financiamiento,
                'alm_id_cli' => $alm_cli,
                'alm_id_esf' => $dtg_estfamiliar,
                'alm_id_esa' => $dtg_estestudiante,
                'alm_id_rel' => $dtg_religion,
                'alm_id_gfa' => $dtg_gfamiliar,
                'alm_id_tin' => $dtg_tipingreso,
                'alm_id_ttr' => $dtg_trasporte,
                'alm_id_usu' => $usu_alm,
                'alm_id_pai_nacionalidad' => $dtg2_nacionalidad_nacimiento,
                'alm_id_dep_nacimiento' => $dtg2_departamento_nacimiento,
                'alm_id_mun_nacimiento' => $dtg2_municipio_nacimiento,
                'alm_id_zon' => $dtg2_area_nacimiento,
                'alm_codigo' => $dtg2_codigo,
                'alm_codigo_nie' => $dtg2_nie,
                'alm_nombre' => $dtg2_nombre,
                'alm_apellido' => $dtg2_apellido,
                'alm_fecha_nacimiento' => $dtg2_nacimiento,
                'alm_lugar_nac' => $dtg2_lugar_nacimiento,
                'alm_direccion' => $dtg2_direccion_residencia,
                // 'alm_id_cli_factura'=>$dtg2_empresa_convenio,
                //'alm_vehiculo' => $asdada,
                //'alm_licencia' => $asdada,
                'alm_email' => $dtg_email,
                'alm_observacion' => $dtg_observacion,
                'alm_fotografia' => $this->input->post('foto_empleado'),
                'alm_becado' => $dtg_becado,
                'alm_aspiracion_personal' => $dtg_aspiracion,
                'alm_trabaja' => $dtg_trabajo,
                'alm_posee_hijos' => $dtg_hijos,
                'alm_miembro_familia' => $dtg_nmiembros,
                'alm_distancia' => $dtg2_distancia_residencia,
                'alm_anio_nacionalidad' => $dtg2_nnacionalidad_nacimiento,
                'alm_estado' => 1,
                'alm_usu_crea' => $this->tank_auth->get_user_id(),
                'alm_fecha_crea' => date('Y-m-d H:i:s'),
                'alm_usu_mod' => $this->tank_auth->get_user_id(),
                'alm_fecha_mod' => date('Y-m-d H:i:s')     
            );
            $alm_id = $this->gsatelite->ingresar('alm_alumno', $alumno_campos);

            if($alm_id > 0 && isset($dtg_gfamiliar)) {

                $cantidad_actual = $this->gsatelite->get_campo('gfa_grupo_familiar', 'gfa_cantidad', array('gfa_id' => $dtg_gfamiliar));
                
                $nueva_cantidad = $cantidad_actual + 1;

                $actualizar_cantidad = array(
                    'gfa_cantidad' => $nueva_cantidad,
                    'gfa_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'gfa_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('gfa_grupo_familiar', $actualizar_cantidad, array('gfa_id' => $dtg_gfamiliar));
            }

            /* ===========================================================================================================
                                                  EMPRESA/CONVENIO
            =============================================================================================================
            */
            if ($dtg2_empresa_convenio != '' && $dtg2_empresa_convenio != null) {
                $empresas = explode(',', $dtg2_empresa_convenio);
                foreach ($empresas as $key => $value) {
                    $empresa_dato = array(
                        'clm_id_alm'        => $alm_id,
                        'clm_id_cli'        => $value,
                        'clm_estado'        => 1,
                        'clm_usu_modificacion'      => $this->tank_auth->get_user_id(),
                        'clm_fecha_modificacion'    => date('Y-m-d H:i:s'),
                        'clm_usu_creacion'          => $this->tank_auth->get_user_id(),
                        'clm_fecha_creacion'        => date('Y-m-d H:i:s'),
                    );
                    $emp = $this->gsatelite->ingresar('clm_cliente_alumno', $empresa_dato);
                }
            }

            /* ===========================================================================================================
                                                  FOTO Y ANEXOS DEL ALUMNO
              =============================================================================================================
             */
            $rutas = $this->input->post("ruta");
            $estado_anexo = $this->input->post("estado_anexo");
            $carpeta = $this->input->post("nombreCarpeta");

            //FOTO ALUMNO
            if ($this->input->post('foto_empleado') != "" and $this->input->post('titulo_foto_empleado') != "") { //guardar la foto del empleado
                $titulo = $this->input->post('titulo_foto_empleado');
                $img = $this->input->post('foto_empleado');
                $this->datos_imagen_gral(
                        $img, $alm_id, $carpeta, $titulo, ($titulo . date("Ymds")), 2, 0, 1
                ); //es de tipo foto 
            }
            //ANEXO ALUMNO
            $titulo_anexo = $this->input->post("titulo_doc");
            $reg_anexos_alumn = $this->input->post("reg_anexos_alumn");

            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $this->datos_imagen_gral(
                                $img, $alm_id, $carpeta, $titulo_anexo[$i], ($titulo_anexo[$i] . date("Ymds")), $estado_anexo[$i], $reg_anexos_alumn[$i]
                        );
                    }
                }
            }
            /* ====================================================================================================================
                                            TABLA MXL_MEDIOXALUMNO
            ===================================================================================================================== */
            $dtg_medio = $this->input->post('dtg_medio'); //array tab 1
            for ($x = 0; $x < count($dtg_medio); $x++) {
                $medio_campos = array(
                    'mxl_id_alm' => $alm_id,
                    'mxl_id_tmc' => $dtg_medio[$x],
                    'mxl_estado' => 1,
                    'mxl_usu_creacion' => $this->tank_auth->get_user_id(),
                    'mxl_fecha_creacion' => date('Y-m-d H:i:s'),
                    'mxl_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'mxl_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                if (trim($dtg_medio[$x]) != "") {
                    $this->gsatelite->ingresar('mxl_medioxalumno', $medio_campos);
                }
            }
            $dtg_seleccion = $this->input->post('dtg_seleccion'); //array tab 1
            for ($x = 0; $x < count($dtg_seleccion); $x++) {
                $eleccion_campos = array(
                    'cea_id_alm' => $alm_id,
                    'cea_id_cre' => $dtg_seleccion[$x],
                    'cea_estado' => 1,
                    'cea_usu_creacion' => $this->tank_auth->get_user_id(),
                    'cea_fecha_creacion' => date('Y-m-d H:i:s'),
                    'cea_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'cea_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                if (trim($dtg_seleccion[$x]) != "") {
                    $this->gsatelite->ingresar('cea_caracteristica_eleccionxalumno', $eleccion_campos);
                }
            }
            /*====================================================================================================================
                                     REGISTRO DE TELEFONOS
            ================================================================================================================== */
            $tel_tipo = $this->input->post('tel_tipo'); //array
            $tel_numero = $this->input->post('tel_numero'); //array
            for ($x = 0; $x < count($tel_tipo); $x++) {
                $telefono_campos = array(
                    'tal_id_alm' => $alm_id,
                    'tal_id_tit' => $tel_tipo[$x],
                    'tal_numero' => $tel_numero[$x],
                    'tal_estado' => 1,
                    'tal_usu_crea' => $this->tank_auth->get_user_id(),
                    'tal_usu_mod' => $this->tank_auth->get_user_id(),
                    'tal_fecha_crea' => date('Y-m-d H:i:s'),
                    'tal_fecha_mod' => date('Y-m-d H:i:s')
                );
                $tels_cli = array(
                    'txc_id_cli' => $alm_cli,
                    'txc_id_tit' => $tel_tipo[$x],
                    'txc_numero' => $tel_numero[$x],
                    'txc_estado' => 1,
                    'txc_usu_mod' => $this->tank_auth->get_user_id(),
                    'txc_fecha_mod' => date('Y-m-d H:i:s')
                );
                if (trim($tel_tipo[$x]) != "" && trim($tel_numero[$x]) != "") {
                    $this->gsatelite->ingresar('tal_telefonoxalumno', $telefono_campos);
                    $this->gsatelite->ingresar('txc_telefonoxcliente', $tels_cli);
                }
            }

            $red_tipo = $this->input->post('red_tipo'); //array
            $perfil = $this->input->post('perfil'); //array
            for ($x = 0; $x < count($red_tipo); $x++) {
                $redes_campos = array(
                    'rxa_id_alm' => $alm_id,
                    'rxa_id_res' => $red_tipo[$x],
                    'rxa_referencia' => $perfil[$x],
                    'rxa_estado' => 1,
                    'rxa_usu_creacion' => $this->tank_auth->get_user_id(),
                    'rxa_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'rxa_fecha_creacion' => date('Y-m-d H:i:s'),
                    'rxa_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                if (trim($red_tipo[$x]) != "" && trim($perfil[$x]) != "") {
                    $this->gsatelite->ingresar('rxa_red_socialxalumno', $redes_campos);
                }
            }
            /* ===================================================================================================================
                                            REGISTRO DE DOCUMENTOS
              ==================================================================================================================*/
            $array2 = $this->input->post('numero_documento');
            //$ver2= array_pop($array2);
            $array2_1 = $this->input->post('documento');
            //$ver2_1 = array_pop($array2_1);
            $array_vence_doc = $this->input->post('vence_documento');
            $array_titulo_anexo = $this->input->post('titulo_anexo_doc');
            $array_nombre_anexo = $this->input->post('nombre_anexo_doc');
            $carpeta = $this->input->post("nombre_anexo_carpeta");

            $array_fexp_doc = $this->input->post('fecha_exp_doc');
            $array_lugarexp_doc = $this->input->post('lugar_exp_doc');

            $i = 0;

            if (!empty($array2) && is_array($array2)) {
                foreach ($array2 as $key => $value2) {

                    $titulo_a = trim($array_titulo_anexo[$i]);
                    $url_anexo = "";
                    $f_vence = (trim($array_vence_doc[$i]) != "" and $array_vence_doc[$i] != null ) ? date('Y-m-d', strtotime(trim($array_vence_doc[$i]))) : null;
                    $f_exp = (trim($array_fexp_doc[$i]) != "" and $array_fexp_doc[$i] != null ) ? date('Y-m-d', strtotime(trim($array_fexp_doc[$i]))) : null;
                    if ($titulo_a != "") {
                        $extencion = end(explode(".", $array_nombre_anexo[$i]));
                        //$url_anexo= "uploads/anexos_empleados/".trim($array_titulo_anexo[$i]).".".trim($extencion);
                        $url_anexo = trim($array_titulo_anexo[$i]) . "." . trim($extencion); //se modifico de esta manera porque se uso grocery para su edicion.
                        $this->datos_anexo_documento(trim($array_nombre_anexo[$i]), $carpeta, $titulo_a); //funcion para guardar el anexo
                        $desde = 'uploads/anexos_alumno/' . $url_anexo;
                        $hacia = 'uploads/anexos_cliente/' . $url_anexo;
                        copy($desde, $hacia);
                    }

                    $this->db->insert('dca_documento_alumno', array(
                        'dca_id_alm' => $alm_id,
                        'dca_id_tde' => $array2_1[$i],
                        'dca_valor' => $value2,
                        'dca_fecha_vence' => $f_vence,
                        'dca_nombre_anexo' => $titulo_a,
                        'dca_url' => $url_anexo,
                        'dca_fecha_expedicion' => $f_exp,
                        'dca_lugar_expedicion' => trim($array_lugarexp_doc[$i]),
                        'dca_estado' => 1,
                        'dca_usu_mod' => $this->tank_auth->get_user_id(),
                        'dca_fecha_mod' => date('Y-m-d H:i:s'),
                        'dca_usu_crea' => $this->tank_auth->get_user_id(),
                        'dca_fecha_crea' => date('Y-m-d H:i:s')
                    ));
                    $this->db->insert('dcc_documento_cliente', array(
                        'dcc_id_cli' => $alm_cli,
                        'dcc_id_tde' => $array2_1[$i],
                        'dcc_valor' => $value2,
                        'dcc_fecha_vence' => $f_vence,
                        'dcc_nombre_anexo' => $titulo_a,
                        'dcc_url' => $url_anexo,
                        'dcc_fecha_expedicion' => $f_exp,
                        'dcc_lugar_expedicion' => trim($array_lugarexp_doc[$i]),
                        'dcc_estado' => 1,
                        'dcc_usu_mod' => $this->tank_auth->get_user_id(),
                        'dcc_fecha_mod' => date('Y-m-d H:i:s'),
                        'dcc_usu_crea' => $this->tank_auth->get_user_id(),
                        'dcc_fecha_crea' => date('Y-m-d H:i:s')
                    ));                
                    $i++;
                }
            }
            //**FIN DDE GUARDAR DOCUMENTOS**//

            /* ==================================================================================================================================
              REGISTRO DE FAMILIARES
              ====================================================================================================================================
             */
            $fam_empleado = $this->input->post('fam_empleado'); //array
            $fam_nombre = $this->input->post('fam_nombre'); //array 
            $fam_apellido = $this->input->post('fam_apellido'); //array
            $fam_fecha = $this->input->post('fam_fecha'); //array
            $fam_telefono = $this->input->post('fam_telefono'); //array
            $fam_telefono_cel = $this->input->post('fam_telefono_cel'); //array
            $fam_parentesco = $this->input->post('fam_parentesco'); //array
            $fam_responsable = $this->input->post('fam_responsable'); //array
            $fam_dependencia = $this->input->post('fam_dependencia'); //array
            $fam_profesion = $this->input->post('fam_profesion'); //array
            $fam_email = $this->input->post('fam_email'); //array
            $fam_convivencia_val = $this->input->post('fam_convivencia_val'); //array
            $fam_docTipo = $this->input->post('fam_docTipo'); //array
            $fam_documento = $this->input->post('fam_documento'); //array
            $fam_lugar_trab = $this->input->post('fam_lugar_trab'); //array
            $fam_direccion_trab = $this->input->post('fam_direccion_trab'); //array
            $fam_salario = $this->input->post('fam_salario'); //array

            for ($x = 0; $x < count($fam_nombre); $x++) {
                $registro = explode('_', $fam_empleado[$x]);
                $familia_campos = array(
                    'fal_id_pro' => (isset($fam_profesion[$x]) && trim($fam_profesion[$x]) != "") ? $fam_profesion[$x] : null,
                    'fal_id_tde' => (trim($fam_docTipo[$x]) != "") ? $fam_docTipo[$x] : null,
                    'fal_id_pat' => (trim($fam_parentesco[$x]) != "") ? $fam_parentesco[$x] : null,
                    'fal_id_alm' => $alm_id,
                    'fal_id_emp' => (trim($registro[1]) == 'emp' ) ? $registro[0] : null,
                    'fal_id_alm_familiar' => (trim($registro[1]) == 'alm' ) ? $registro[0] : null,
                    'fal_nombre' => (trim($fam_nombre[$x]) != "") ? $fam_nombre[$x] : null,
                    'fal_apellido' => (trim($fam_apellido[$x]) != "") ? $fam_apellido[$x] : null,
                    'fal_fecha_nacimiento' => (trim($fam_fecha[$x]) != "") ? date('Y-m-d', strtotime($fam_fecha[$x])) : null,
                    'fal_telefono' => (trim($fam_telefono[$x]) != "") ? $fam_telefono[$x] : null,
                    'fal_telefono_cel' => (trim($fam_telefono_cel[$x]) != "") ? $fam_telefono_cel[$x] : null,
                    'fal_responsable' => (trim($fam_responsable[$x]) != "") ? $fam_responsable[$x] : 0,
                    'fal_dependiente' => (trim($fam_dependencia[$x]) != "") ? $fam_dependencia[$x] : null,
                    'fal_correo' => (trim($fam_email[$x]) != "") ? $fam_email[$x] : null,
                    'fal_convivencia' => (trim($fam_convivencia_val[$x]) != "") ? $fam_convivencia_val[$x] : null,
                    'fal_numero_documento' => (trim($fam_documento[$x]) != "") ? $fam_documento[$x] : null,
                    'fal_lugar_trabajo' => (trim($fam_lugar_trab[$x]) != "") ? $fam_lugar_trab[$x] : null,
                    'fal_direccion_trabajo' => (trim($fam_direccion_trab[$x]) != "") ? $fam_direccion_trab[$x] : null,
                    'fal_salario' => (trim($fam_salario[$x]) != "") ? $fam_salario[$x] : null,
                    'fal_estado' => 1,
                    'fal_usu_creacion' => $this->tank_auth->get_user_id(),
                    'fal_fecha_creacion' => date('Y-m-d H:i:s'),
                    'fal_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'fal_fecha_modificacion' => date('Y-m-d H:i:s')
                );

                //trim($fam_profesion[$x]) != "" && trim($fam_docTipo[$x]) != "" && 
                if (trim($fam_parentesco[$x]) != "" && trim($fam_nombre[$x]) != "" && trim($fam_apellido[$x]) != "") {
                    $this->gsatelite->ingresar('fal_familiar_alumno', $familia_campos);
                }
            }            /* ==================================================================================================================================
              REGISTRO DE DATOS ACADEMICOS
              ====================================================================================================================================
             */
            $tipo_edu = $this->input->post('tipo_edu');
            //$nombre_edu = $this->input->post('nombre_edu');
            $titulo_edu = $this->input->post('titulo_edu');
            $institutcion_edu = $this->input->post('institutcion_edu');
            $pais_edu = $this->input->post('pais_edu');
            $fecha_fin_edu = $this->input->post('fecha_fin_edu');
            $observacion_edu = $this->input->post('observacion_edu');
            $repitencia_edu = $this->input->post('datAca_repitencia_val');

            $datos_academicos = array();

            if (!empty($tipo_edu) && is_array($tipo_edu)) {

                foreach ($tipo_edu as $key => $value) {
                    $datos_academicos = array(
                        'eda_id_alm' => $alm_id,
                        'eda_id_pai' => (trim($pais_edu[$key]) != "") ? $pais_edu[$key] : null,/////REUERIDO EN BASE
                        'eda_id_tie' => $value,
                        'eda_id_ted' => (trim($titulo_edu[$key]) != "") ? $titulo_edu[$key] : null,
                        'eda_id_ina' => (trim($institutcion_edu[$key]) != "") ? $institutcion_edu[$key] : null,
                        'eda_fecha_final' => ($fecha_fin_edu[$key] != "") ? date('Y-m-d', strtotime($fecha_fin_edu[$key])) : null,
                        'eda_observacion' => (trim($observacion_edu[$key]) != "") ? $observacion_edu[$key] : null,
                        'eda_repitencia' => (trim($repitencia_edu[$key]) != "") ? $repitencia_edu[$key] : null,
                        'eda_estado' => 1,
                        'eda_usu_creacion' => $this->tank_auth->get_user_id(),
                        'eda_fecha_creacion' => date('Y-m-d H:i:s'),
                        'eda_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'eda_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('eda_educacion_alumno', $datos_academicos);
                }
            }

            //**************** FIN DE DATOS academicos ******************//

            /* ========================================================================================================================
              REGISTRO DE IDIOMAS
              =========================================================================================================================
             */
            $select_idioma = $this->input->post('idioma');
            $nivel_idioma = $this->input->post('nivel');
            $leer_idioma = $this->input->post('leer');
            $escribir_idioma = $this->input->post('escribir');
            $hablar_idioma = $this->input->post('hablar');
            $traductor = $this->input->post('traductor');
            $incorporado = $this->input->post('incorporado');
            $fecha_idm = $this->input->post('fecha_idm');
            $nota_idm = $this->input->post('nota_idm');

            $datos_idioma = array();

            if (!empty($select_idioma) && is_array($select_idioma)) {
                foreach ($select_idioma as $key => $value) {
                    $datos_idioma = array(
                        'ial_id_alm' => $alm_id, //$alm_id,
                        'ial_id_idm' => $value,
                        'ial_id_nii' => $nivel_idioma[$key],
                        'ial_leer' => (trim($leer_idioma[$key]) != "") ? $leer_idioma[$key] : null,
                        'ial_escribir' => (trim($escribir_idioma[$key]) != "") ? $escribir_idioma[$key] : null,
                        'ial_hablar' => (trim($hablar_idioma[$key]) != "") ? $hablar_idioma[$key] : null,
                        'ial_traductor' => (trim($traductor[$key]) != "") ? $traductor[$key] : null,
                        'ial_incorporado' => (trim($incorporado[$key]) != "") ? $incorporado[$key] : null,
                        'ial_fecha_examen' => ($fecha_idm[$key] != "") ? date('Y-m-d', strtotime($fecha_idm[$key])) : null,
                        'ial_nota' => (trim($nota_idm[$key]) != "" && is_numeric($nota_idm[$key])) ? $nota_idm[$key] : null,
                        'ial_estado' => 1,
                        'ial_usu_crea' => $this->tank_auth->get_user_id(),
                        'ial_fecha_crea' => date('Y-m-d H:i:s'),
                        'ial_usu_mod' => $this->tank_auth->get_user_id(),
                        'ial_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('ial_idioma_alumno', $datos_idioma);
                }
            }
            /* ==================================================================================================================================
              REGISTRO DE DATOS CLINICOS
              ====================================================================================================================================
             */
            $dtc_alergia_clinicos = (trim($this->input->post('dtc_alergia_clinicos')) != "") ? $this->input->post('dtc_alergia_clinicos') : null; //clinicos
            $dtc_estatura_clinico = (trim($this->input->post('dtc_estatura_clinico')) != "") ? $this->input->post('dtc_estatura_clinico') : null; //clinicos
            $dtc_peso_clinico = (trim($this->input->post('dtc_peso_clinico')) != "") ? $this->input->post('dtc_peso_clinico') : null; //clinicos
            $dtc_sangre_clinico = (trim($this->input->post('dtc_sangre_clinico')) != "") ? $this->input->post('dtc_sangre_clinico') : null; //clinicos
            $dtc_discapacidad_clinico = (trim($this->input->post('dtc_discapacidad_clinico')) != "") ? $this->input->post('dtc_discapacidad_clinico') : null; //clinicos
            $dtc_enfermedad_clinico = (trim($this->input->post('dtc_enfermedad_clinico')) != "") ? $this->input->post('dtc_enfermedad_clinico') : null; //clinicos
            $dtc_observacion_clinico = (trim($this->input->post('dtc_observacion_clinico')) != "") ? $this->input->post('dtc_observacion_clinico') : null; //clinicos

            $dtc_tratamiento = (trim($this->input->post('dtc_tratamiento')) != "") ? $this->input->post('dtc_tratamiento') : 0; //clinicos
            $dtc_tratamiento_tipo = (trim($this->input->post('dtc_tratamiento_tipo')) != "") ? $this->input->post('dtc_tratamiento_tipo') : null; //clinicos
            $dtc_detalle = (trim($this->input->post('dtc_detalle')) != "") ? $this->input->post('dtc_detalle') : null; //clinicos
            $dtc_medicamento = (trim($this->input->post('dtc_medicamento')) != "") ? $this->input->post('dtc_medicamento') : null; //clinicos

            $dtc_nombre_emergencia = (trim($this->input->post('dtc_nombre_emergencia')) != "") ? $this->input->post('dtc_nombre_emergencia') : null; //clinicos
            $dtc_direccion_emergencia = (trim($this->input->post('dtc_direccion_emergencia')) != "") ? $this->input->post('dtc_direccion_emergencia') : null; //clinicos
            $dtc_parentesco_emergencia = (trim($this->input->post('dtc_parentesco_emergencia')) != "") ? $this->input->post('dtc_parentesco_emergencia') : null; //clinicos
            $dtc_telefono_emergencia = (trim($this->input->post('dtc_telefono_emergencia')) != "") ? $this->input->post('dtc_telefono_emergencia') : null; //clinicos
            $dtc_responsable_emergencia = 1; //clinicos

            $datos_clinicos_campos = array(
                'cla_id_alm' => $alm_id,
                'cla_id_pat' => $dtc_parentesco_emergencia,
                'cla_id_ttm' => $dtc_tratamiento_tipo,
                'cla_estatura' => $dtc_estatura_clinico,
                'cla_peso' => $dtc_peso_clinico,
                'cla_tipo_sangre' => $dtc_sangre_clinico,
                'cla_alergico' => $dtc_alergia_clinicos,
                'cla_discapacidad' => $dtc_discapacidad_clinico,
                'cla_enfermedad' => $dtc_enfermedad_clinico,
                'cla_familiar' => $dtc_nombre_emergencia,
                'cla_direccion_fam' => $dtc_direccion_emergencia,
                'cla_telefono' => $dtc_telefono_emergencia,
                'cla_observacion' => $dtc_observacion_clinico,
                'cla_fam_reponsable' => $dtc_responsable_emergencia,
                'cla_posee_tratamiento' => $dtc_tratamiento,
                'cla_descripcion_tratamiento' => $dtc_detalle,
                'cla_descripcion_medicamento' => $dtc_medicamento,
                'cla_estado' => 1,
                'cla_usu_mod' => $this->tank_auth->get_user_id(),
                'cla_fecha_mod' => date('Y-m-d H:i:s'),
                'cla_usu_crea' => $this->tank_auth->get_user_id(),
                'cla_fecha_crea' => date('Y-m-d H:i:s')
            );

            $this->gsatelite->ingresar('cla_clinico_alumno', $datos_clinicos_campos);

            /* ==================================================================================================================================
              REGISTRO DE REFERENCIAS LABORALES
              ====================================================================================================================================
             */
            $rlab_lugar = $this->input->post('rlab_lugar'); //array
            $rlab_direccion = $this->input->post('rlab_direccion'); //array
            $rlab_telefono = $this->input->post('rlab_telefono'); //array
            $rlab_puesto = $this->input->post('rlab_puesto'); //array
            $rlab_jefe = $this->input->post('rlab_jefe'); //array
            $rlab_salario = $this->input->post('rlab_salario'); //array
            $rlab_motivo = $this->input->post('rlab_motivo'); //array

            for ($x = 0; $x < count($rlab_lugar); $x++) {
                $referencia_lab_campos = array(
                    'eal_id_alm' => $alm_id,
                    'eal_empresa' => (trim($rlab_lugar[$x]) != "") ? $rlab_lugar[$x] : null,
                    'eal_direccion' => (trim($rlab_direccion[$x]) != "") ? $rlab_direccion[$x] : null,
                    'eal_telefono' => (trim($rlab_telefono[$x]) != "") ? $rlab_telefono[$x] : null,
                    'eal_puesto' => (trim($rlab_puesto[$x]) != "") ? $rlab_puesto[$x] : null,
                    'eal_jefe_inmediato' => (trim($rlab_jefe[$x]) != "") ? $rlab_jefe[$x] : null,
                    'eal_salario' => (trim($rlab_salario[$x]) != "") ? $rlab_salario[$x] : null,
                    'eal_motivo_retiro' => (trim($rlab_motivo[$x]) != "") ? $rlab_motivo[$x] : null,
                    'eal_estado' => 1,
                    'eal_usu_crea' => $this->tank_auth->get_user_id(),
                    'eal_fecha_crea' => date('Y-m-d H:i:s'),
                    'eal_usu_mod' => $this->tank_auth->get_user_id(),
                    'eal_fecha_mod' => date('Y-m-d H:i:s')
                );
                if (trim($rlab_lugar[$x]) != "" && trim($rlab_direccion[$x]) != "" && trim($rlab_telefono[$x]) != "" && trim($rlab_puesto[$x]) != "") {
                    $this->gsatelite->ingresar('eal_empleo_alumno', $referencia_lab_campos);
                }
            }
            /* ==================================================================================================================
                                        REGISTRO DE HABILIDADES Y PASATIEMPOS
              ================================================================================================================ */
            $hbl_tipo = $this->input->post('hbl_tipo'); //array
            $hbl_habilidad = $this->input->post('hbl_habilidad'); //array
            $hbl_grupo = $this->input->post('hbl_grupo'); //array
            $hbl_observacion = $this->input->post('hbl_observacion'); //array

            for ($x = 0; $x < count($hbl_tipo); $x++) {
                $habilidad_campos = array(
                    'hxa_id_alm' => $alm_id,
                    'hxa_id_grh' => (trim($hbl_grupo[$x]) != "") ? $hbl_grupo[$x] : null,
                    'hxa_id_hab' => (trim($hbl_habilidad[$x]) != "") ? $hbl_habilidad[$x] : null,
                    'hxa_observacion' => (trim($hbl_observacion[$x]) != "") ? $hbl_observacion[$x] : null,
                    'hxa_estado' => 1,
                    'hxa_usu_creacion' => $this->tank_auth->get_user_id(),
                    'hxa_fecha_creacion' => date('Y-m-d H:i:s'),
                    'hxa_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'hxa_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                if (trim($hbl_habilidad[$x]) != "" ) {
                    $this->gsatelite->ingresar('hxa_habilidadxalumno', $habilidad_campos);
                }
            }

            $hbl_tipo_habilidad = $this->input->post('hbl_tipo_habilidad'); //array
            $hbl_observacion_habilidad = $this->input->post('hbl_observacion_habilidad'); //array

            for ($x = 0; $x < count($hbl_tipo_habilidad); $x++) {
                $pasatiempo_campos = array(
                    'psa_id_alm' => $alm_id,
                    'psa_id_pst' => (trim($hbl_tipo_habilidad[$x]) != "") ? $hbl_tipo_habilidad[$x] : null,
                    'psa_observacion' => (trim($hbl_observacion_habilidad[$x]) != "") ? $hbl_observacion_habilidad[$x] : null,
                    'psa_estado' => 1,
                    'psa_usu_creacion' => $this->tank_auth->get_user_id(),
                    'psa_fecha_creacion' => date('Y-m-d H:i:s'),
                    'psa_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'psa_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                if (trim($hbl_tipo_habilidad[$x]) != "" && trim($hbl_observacion_habilidad[$x]) != "") {
                    $this->gsatelite->ingresar('psa_pasatiempo_alumno', $pasatiempo_campos);
                }
            }


            if ($alm_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de alumnos", 'texto_alerta' => "El registro se guardó correctamente. Código: <b>".$dtg2_codigo."</b>");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de alumnos", 'texto_alerta' => "El registro no se guardó, revise la información a ingresar.");
            }
            $this->session->set_flashdata($alerta);
            $direccionar = $this->input->post('direccionar');
            if ($direccionar == 2) {
                redirect('registro_academico/procesos/gestion_alumnos/');
            } else {
                redirect('registro_academico/procesos/agregar_alumno/');
            }
        }
    }

    function carga_municipios() {
        $pai_id = $this->input->post('pais');
        $municpios = $this->gsatelite->get_tabla('dep_departamento', array('dep_id_pai' => $pai_id));
        $select = '<option value=""></option>';
        foreach ($municpios as $key) {
            $select .= '<option value="' . $key["dep_id"] . '">' . $key["dep_nombre"] . '</option>';
        }
        echo json_encode(array('resp' => $select));
    }

    function cargar_departamento() {
        $dep_id = $this->input->post('departamento');
        $municpios = $this->gsatelite->get_tabla('mun_municipio', array('mun_id_dep' => $dep_id));
        $select = '<option value=""></option>';
        foreach ($municpios as $key) {
            $select .= '<option value="' . $key["mun_id"] . '">' . $key["mun_nombre"] . '</option>';
        }
        echo json_encode(array('resp' => $select));
    }

    function cargar_habilidad() {
        $tipo_habilidad = $this->input->post('tipo_habilidad');
        $registros = $this->registro_academico_model->obtener_habilidad(array('hab_id_tih' => $tipo_habilidad));
        $select = '<option value=""></option>';
        foreach ($registros as $key) {
            $select .= '<option value="' . $key["hab_id"] . '">' . $key["hab_nombre"] . '</option>';
        }
        echo json_encode(array('resp' => $select));
    }

    function cargar_grupo_hbl() {
        $habilidad = $this->input->post('habilidad');
        $registros = $this->registro_academico_model->obtener_grupo_habilidad(array('grh_id_hab' => $habilidad));
        $select = '<option value=""></option>';
        foreach ($registros as $key) {
            $select .= '<option value="' . $key["grh_id"] . '">' . $key["grh_nombre"] . '</option>';
        }
        echo json_encode(array('resp' => $select));
    }

    function verificar_codigo() {
        $n = '';
        $cod_alumno = $this->input->post('codigo');
        $total = $this->registro_academico_model->obtenerCodigo($cod_alumno);
        foreach ($total as $to) {
            $i = $to['resul'] + 1;
        }
        if ($i <= 9) {
            $n = '00' . $i;
        }
        if ($i > 9) {
            $n = '0' . $i;
        }
        if ($i > 99) {
            $n = $i;
        }

        $cod_alumno = $cod_alumno . $n;
        $cod_alumno = strtoupper($cod_alumno);
        echo json_encode(array('codigo_alm' => $cod_alumno));
    }

    public function datos_imagen_gral_docente($img, $id_emp, $carpeta, $titulo_doc, $tipo = 0) {
        $extencion = end(explode(".", $img));
        $datos_1 = $this->session->keep_flashdata('datos_1');
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        /* if($extencion=='jpg' || $extencion=='jepg' || $extencion=='png'){
          $tipo=1;
          }
          else{$tipo=0;} */

        $destino = "uploads/anexos_empleados/" . $titulo_doc . "." . trim($extencion) . "";
        $dir = $this->gsatelite->get_campo('anx_anexo', 'anx_url', array('anx_url' => $destino, 'anx_estado' => 1));
        //die(print_r(count($dir)));
        if (count($dir) <= 0) {
            $array_anex = array(
                'anx_url' => $destino,
                'anx_nombre' => $titulo_doc,
                'anx_estado' => 1,
                'anx_usu_crea' => $this->tank_auth->get_user_id(),
                'anx_usu_mod' => $this->tank_auth->get_user_id(),
                'anx_fecha_crea' => date('Y-m-d H:i:s'),
                'anx_fecha_mod' => date('Y-m-d H:i:s'),
                'anx_imagen' => $tipo
            );
            $this->db->insert("anx_anexo", $array_anex);
            $id_anexo = $this->db->insert_id();
            $array_anex_doc = array(
                'axe_id_emp' => $id_emp,
                'axe_id_anx' => $id_anexo,
                'axe_estado' => 1,
                'axe_usu_mod' => $this->tank_auth->get_user_id(),
                'axe_fecha_mod' => date('Y-m-d H:i:s')
            );
            $this->db->insert("axe_anexoxempleado", $array_anex_doc);
            $carpeta_destino = "uploads/anexos_empleados/" . $titulo_doc . "." . trim($extencion) . "";

            copy($ruta, $carpeta_destino);
            unlink($ruta);
        }
    }

    /* ---------------------
       Anexo de documentos
      -------------------- */

    public function datos_anexo_documento($img, $carpeta, $titulo_doc) {
        $extencion = end(explode(".", $img));
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        $carpeta_destino = "uploads/anexos_alumno/" . $titulo_doc . "." . trim($extencion) . "";
        copy($ruta, $carpeta_destino);
        unlink($ruta);
    }

    /*
      =====================
      FIN DE INGRESO DE ALUMNO
      =====================
     */

    public function guardar_anexo($parametros, $carpeta = null) {
        $datos = @explode($parametros);
        $carpeta = $parametros;
        $image = $this->subir_anexo($carpeta);
        echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
    }

    function subir_anexo($carpeta) {
        if ($carpeta == "assets") {
            $ruta = FCPATH . "assets/uploads/images";
        } else {
            $ruta = FCPATH . "public/temp/" . $carpeta;
        }
        if (!file_exists($ruta)) {
            mkdir($ruta, 0777);
        }
        $obj = &get_instance();
        $config['upload_path'] = $ruta;
        $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx';
        $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return true;
        } else {
            $data = array('upload_data' => $obj->upload->data());
            return $data;
        }
        print_r($data);
    }

    /**
     * Guardar/eliminar/editar un anexo
     * 
     * @author Habby Lovo
     * @since 27/04/2017
     * $img: es nombre de la imagen
     * $alm_id: es el id del alumno al que se le asignara el anexo
     * $carpeta: es el nombre de la carpeta temporal donde se guardaran los anexos
     * $titulo_camp: es el nombre con el que se reconocera el anexo en la bd
     * $titulo_doc: es el nombre del archivo que sera movido a la carpeta de anexos
     * $estado_anx: es para saber si sera editada/eliminada/guardada
     * $id_anx: es el id de la imagen actual, por si se quiere eliminar o editar
     * $tipo: 0 para anexos y 1 para la imagen del alumno
     */
    public function datos_imagen_gral($img, $alm_id, $carpeta, $titulo_camp, $titulo_doc, $estado_anx, $id_anx, $tipo = 0) {
        $extencion = end(explode(".", $img));
        $datos_1 = $this->session->keep_flashdata('datos_1');
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        $titulo_doc = str_replace(' ', '', $titulo_doc);
        $destino = "uploads/anexos_alumno/" . $titulo_doc . "." . trim($extencion) . "";

        if ($estado_anx == 2) {
            $array_anex = array(
                'axl_id_alm' => $alm_id,
                'axl_nombre' => $titulo_camp,
                'axl_url' => $destino,
                'axl_img_perfil' => $tipo,
                'axl_estado' => 1,
                'axl_usu_mod' => $this->tank_auth->get_user_id(),
                'axl_fecha_mod' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->ingresar("axl_anexoxalumno", $array_anex);
            $carpeta_destino = "uploads/anexos_alumno/" . $titulo_doc . "." . trim($extencion) . "";
            copy($ruta, $carpeta_destino);
            unlink($ruta);
        }
        if ($estado_anx == 1) {
            $array_anex = array(
                'axl_nombre' => $titulo_camp,
                'axl_usu_mod' => $this->tank_auth->get_user_id(),
                'axl_fecha_mod' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array("axl_anexoxalumno", $array_anex, array('axl_id_alm' => $alm_id, 'axl_id' => $id_anx));
        }
        if ($estado_anx == 0) {
            $anexo_reg = $this->gsatelite->get_tabla('axl_anexoxalumno', array('axl_id' => $id_anx));
            $this->gsatelite->borrado_general('axl_anexoxalumno', array('axl_id' => $id_anx));
            echo $anexo_reg[0]['axl_url'];
            unlink($anexo_reg[0]['axl_url']);
        }
    }

    function eliminar_anexos($carpeta = "") {
        $nombre_file = $this->input->post("nombre");
        $tipo = $this->input->post("tipo");
        if ($tipo == 1) {
            $url = "./public/temp/$carpeta/$nombre_file";
        }
        echo $url;
        unlink("" . $url);
    }

    /**
     * editar Registro de alumnos
     * 
     * @author Habby Lovo
     * @since 27/04/2017
     */
    public function editar_alumno($alm_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['alm_id'] = $alm_id;
                                       $this->db->join('cli_cliente', 'alm_id_cli_factura=cli_id', 'left');
            $data['registro_alumno'] = $this->gsatelite->get_tabla('alm_alumno', array('alm_id' => $alm_id));


                                  $this->db->join('cli_cliente', 'alm_id_cli = cli_id', 'inner');
            $data['alumno_cli'] = $this->gsatelite->get_tabla('alm_alumno', array('alm_id' => $alm_id));

            $data['datos_cliente_asociado'] = $this->gsatelite->get_registro('cli_cliente', 'cli_id', $data['alumno_cli'][0]['cli_id_cli_asociado']);

            $verificar_usu_vendedor = $this->gsatelite->get_registro('ven_vendedor', array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1));
            
            $vendedor = null;

            if(isset($data['alumno_cli'][0]['cli_id_ven'])) {
                $vendedor = $data['alumno_cli'][0]['cli_id_ven'];
            } else if ($verificar_usu_vendedor && isset($verificar_usu_vendedor->ven_id)) {
                // $vendedor = $verificar_usu_vendedor->ven_id;
            }
                                                    
            $vendedores = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => '1'), $vendedor, '', 'ven_id', true);
            $data['vendedor'] = str_replace('<option value="0">Seleccione</option>', '', $vendedores);


            $this->db->join('cli_cliente', 'clm_id_cli=cli_id');
            $empresas_convenio = $this->gsatelite->get_tabla('clm_cliente_alumno', array('clm_id_alm'=>$alm_id, 'clm_estado'=>1));
            // Construcción de json para enviarlo al select2 multiple
            $json_empresas= array();
            $json_empresas2= array();
            $l=0;
            foreach ($empresas_convenio as $key) { 
                $l++;
                $json_empresas['id']   = $key['cli_id'];
                $json_empresas['text'] = str_replace(array("'"), array("\'"), $key['cli_nombre'].' '.$key['cli_apellido']);
                $json_empresas2[]      =  $json_empresas;
            }
            $data['empresas'] = json_encode($json_empresas2);

            $religion_drop = $this->gsatelite->get_dropdown('rel_religion', '{rel_nombre}', '', array('rel_estado' => 1), $data['registro_alumno'][0]['alm_id_rel'], '', 'rel_id', true);
            $data['religion'] = str_replace('<option value="0">Seleccione</option>', '', $religion_drop);

            $profesion_dtg_drop = $this->gsatelite->get_dropdown('pro_profesion', '{pro_nombre}', '', array('pro_estado' => 1), $data['registro_alumno'][0]['alm_id_pro'], '', 'pro_id', true);
            $data['profesion_dtg'] = str_replace('<option value="0">Seleccione</option>', '', $profesion_dtg_drop);

            //$grupo_fam_drop = $this->gsatelite->get_dropdown('gfa_grupo_familiar', '{gfa_nombre}', '', array('gfa_estado' => 1), $data['registro_alumno'][0]['alm_id_gfa'], '', 'gfa_id', true);
            //$data['grupo_familiar'] = str_replace('<option value="0">Seleccione</option>', '', $grupo_fam_drop);

            $estado_familiar_drop = $this->gsatelite->get_dropdown('esf_estado_familia', '{esf_nombre}', '', array('esf_estado' => 1), $data['registro_alumno'][0]['alm_id_esf'], '', 'esf_id', true);
            $data['estado_familiar'] = str_replace('<option value="0">Seleccione</option>', '', $estado_familiar_drop);

            $data['grupo_familiar'] = $this->gsatelite->get_registro('gfa_grupo_familiar', array('gfa_id' => $data['registro_alumno'][0]['alm_id_gfa']));

            $financiamiento_drop = $this->gsatelite->get_dropdown('fin_financiamiento', '{fin_nombre}', '', array('fin_estado' => 1), $data['registro_alumno'][0]['alm_id_fin'], '', 'fin_id', true);
            $data['financiamiento'] = str_replace('<option value="0">Seleccione</option>', '', $financiamiento_drop);

            $tipo_trasporte_drop = $this->gsatelite->get_dropdown('ttr_tipo_transporte', '{ttr_nombre}', '', array('ttr_estado' => 1), $data['registro_alumno'][0]['alm_id_ttr'], '', 'ttr_id', true);
            $data['tipo_trasporte'] = str_replace('<option value="0">Seleccione</option>', '', $tipo_trasporte_drop);

            $estado_alumno_drop = $this->gsatelite->get_dropdown('esa_estado_alumno', '{esa_nombre}', '', array('esa_estado' => 1), $data['registro_alumno'][0]['alm_id_esa'], '', 'esa_id', true);
            $data['estado_alumno'] = str_replace('<option value="0">Seleccione</option>', '', $estado_alumno_drop);

            $tipo_ingreso_drop = $this->gsatelite->get_dropdown('tin_tipo_ingreso', '{tin_nombre}', '', array('tin_estado' => 1), $data['registro_alumno'][0]['alm_id_tin'], '', 'tin_id', true);
            $data['tipo_ingreso'] = str_replace('<option value="0">Seleccione</option>', '', $tipo_ingreso_drop);

            //multiselect
            $data['tipos_medios_alm'] = $this->gsatelite->get_tabla('mxl_medioxalumno', array('mxl_id_alm' => $alm_id));
            $data['tipos_medios_reg'] = $this->gsatelite->get_tabla('tmc_tipo_medio', array('tmc_estado' => 1));

            $data['caracteristica_eleccion_alm'] = $this->gsatelite->get_tabla('cea_caracteristica_eleccionxalumno', array('cea_id_alm' => $alm_id));
            $data['caracteristica_eleccion_reg'] = $this->gsatelite->get_tabla('cre_caracteristica_eleccion', array('cre_estado' => 1));

            //datos generales 2
            $data['anexo_perfil'] = $this->gsatelite->get_tabla('axl_anexoxalumno', array('axl_id_alm' => $alm_id, 'axl_img_perfil' => 1));

            $genero_drop = $this->gsatelite->get_dropdown('gen_genero', '{gen_nombre}', '', '', $data['registro_alumno'][0]['alm_id_gen'], '', 'gen_id', true);
            $data['genero'] = str_replace('<option value="0">Seleccione</option>', '', $genero_drop);

            $estado_civil_drop = $this->gsatelite->get_dropdown('esc_estado_civil', '{esc_nombre}', '', array('esc_estado' => 1), $data['registro_alumno'][0]['alm_id_esc'], '', 'esc_id', true);
            $data['estado_civil'] = str_replace('<option value="0">Seleccione</option>', '', $estado_civil_drop);

            $pais_res_drop = $this->gsatelite->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), $data['registro_alumno'][0]['alm_id_pai'], '', 'pai_id', true);
            $data['pais_res_dtg2'] = str_replace('<option value="0">Seleccione</option>', '', $pais_res_drop);

            $departamento_res_drop = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', '', $data['registro_alumno'][0]['alm_id_dep'], '', 'dep_id', true);
            $data['departamentos_res_dtg2'] = str_replace('<option value="0">Seleccione</option>', '', $departamento_res_drop);

            $municipios_res_drop = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', '', $data['registro_alumno'][0]['alm_id_mun'], '', 'mun_id', true);
            $data['municipios_res_dtg2'] = str_replace('<option value="0">Seleccione</option>', '', $municipios_res_drop);

            //cambiar luego q solo filtre los departamentos que estan asociados al pais o al municipio y eso
            $pais_nac_drop = $this->gsatelite->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), $data['registro_alumno'][0]['alm_id_pai_nacionalidad'], '', 'pai_id', true);
            $data['pais_nac'] = str_replace('<option value="0">Seleccione</option>', '', $pais_nac_drop);

            $nacionalidad_drop = $this->gsatelite->get_dropdown('pai_pais', '{pai_nacionalidad}', '', array('pai_estado' => 1), $data['registro_alumno'][0]['alm_id_pai_nacionalidad'], '', 'pai_id', true);
            $data['nacionalidad'] = str_replace('<option value="0">Seleccione</option>', '', $nacionalidad_drop);

            $departamento_nac_drop = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', array('dep_id_pai' => $data['registro_alumno'][0]['alm_id_pai_nacionalidad']), $data['registro_alumno'][0]['alm_id_dep_nacimiento'], '', 'dep_id', true);
            $data['departamentos_nac_dtg2'] = str_replace('<option value="0">Seleccione</option>', '', $departamento_nac_drop);

            $municipios_nac_drop = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', array('mun_id_dep' => $data['registro_alumno'][0]['alm_id_dep_nacimiento']), $data['registro_alumno'][0]['alm_id_mun_nacimiento'], '', 'mun_id', true);
            $data['municipios_nac_dtg2'] = str_replace('<option value="0">Seleccione</option>', '', $municipios_nac_drop);

            $zona_drop = $this->gsatelite->get_dropdown('zon_zona', '{zon_nombre}', '', array('zon_estado' => 1), $data['registro_alumno'][0]['alm_id_zon'], '', 'zon_id', true);
            $data['zona'] = str_replace('<option value="0">Seleccione</option>', '', $zona_drop);

            //telefono
            $data['tipo_telefono'] = $this->gsatelite->get_tabla('tit_tipo_telefono');
            $data['telefonos_reg'] = $this->personal_model->get_telefonos_alumnos(array('tal_id_alm' => $alm_id));
            
            $redes_drop = $this->gsatelite->get_dropdown('res_red_social', '{res_nombre}', '', array('res_estado' => 1), null, '', 'res_id', true);
            $data['red_social'] = str_replace('<option value="0">Seleccione</option>', '', $redes_drop);
            $data['red_reg'] = $this->personal_model->get_redes_alumnos(array('rxa_id_alm' => $alm_id));

            //documentos del alumno
            $data['docAlum'] = $this->personal_model->editar_documentos_alm($alm_id);
            $tipos_doc = $this->gsatelite->get_dropdown('tde_tipo_documento', '{tde_nombre}', '', array('tde_estado' => 1), null, '', 'tde_id', true);
            $data['options_tipo_documento'] = str_replace('<option value="0">Seleccione</option>', '', $tipos_doc);

            //familiares que vienen de empleado

            //$empleado_drop = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
            //$data['empleado'] = str_replace('<option value="0">Seleccione</option>', '', $empleado_drop);

            //$alumno_drop = $this->gsatelite->get_dropdown('alm_alumno', '{alm_nombre} {alm_apellido}', '', array('alm_estado' => 1), null, '', 'alm_id', true);
            //$data['alumnos'] = str_replace('<option value="0">Seleccione</option>', '', $alumno_drop);

            $familiar = $this->personal_model->get_familiares_alumnos(array('fal_id_alm' => $alm_id, 'fal_id_emp IS NOT NULL'=>null));
            $familiares = array();

            /********************** Mix de familiares y empleados *****************************************/
            if(count($familiar)>0){
                foreach ($familiar as $fal) {
                    if($fal['fal_id_emp']!=null){
                        $fal_empleado =$this->get_empleado($fal['fal_id_emp']);
                        $fal_empleado['fal_responsable'] = $fal['fal_responsable'];
                        $fal_empleado['fal_convivencia'] = $fal['fal_convivencia'];
                        $fal_empleado['fal_dependiente'] = $fal['fal_dependiente'];
                        $fal_empleado['fal_id_pat'] = $fal['fal_id_pat'];
                        $fal_empleado['pat_nombre'] = $fal['pat_nombre'];
                        $fal_empleado['fal_id_emp'] = $fal['fal_id_emp'];
                    }
                    array_push($familiares, $fal_empleado);
                }
            }

            // Familiares que no depeden del registro de empleados.
            $fal_familiar = $this->personal_model->get_familiares_alumnos(array('fal_id_alm' => $alm_id, 'fal_id_emp IS NULL'=>null));
            if(count($fal_familiar)>0){
                foreach ($fal_familiar as $key) {
                    //die(print_r($key));
                    array_push($familiares, $key);
                }
            }
            $data['familiares_reg'] = $familiar;
            //******************************************************************************************************/

            $titulo_educacion_drop = $this->gsatelite->get_dropdown('ted_titulo_educacion', '{ted_nombre}', '', array('ted_estado' => 1), null, '', 'ted_id', true);
            $data['titulo_educacion'] = str_replace('<option value="0">Seleccione</option>', '', $titulo_educacion_drop);

            $parentesco_drop = $this->gsatelite->get_dropdown('pat_parentesco', '{pat_nombre}', '', array('pat_estado' => 1), null, '', 'pat_id', true);
            $data['parentesco'] = str_replace('<option value="0">Seleccione</option>', '', $parentesco_drop);
            $profesion_drop = $this->gsatelite->get_dropdown('pro_profesion', '{pro_nombre}', '', array('pro_estado' => 1), null, '', 'pro_id', true);
            $data['profesion'] = str_replace('<option value="0">Seleccione</option>', '', $profesion_drop);

            //datos academicos
            $data['tipo_educacion'] = $this->gsatelite->get_tabla('tie_tipo_educacion', array('tie_estado' => 1));
            $institucion_academica_drop = $this->gsatelite->get_dropdown('ina_institucion_academica', '{ina_nombre}', '', array('ina_estado' => 1), null, '', 'ina_id', true);
            $data['institucion_academica'] = str_replace('<option value="0">Seleccione</option>', '', $institucion_academica_drop);

            $pais_drop = $this->gsatelite->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), null, '', 'pai_id', true);
            $data['pais'] = str_replace('<option value="0">Seleccione</option>', '', $pais_drop);

            $data['eda_educacion'] = $this->personal_model->get_datos_academicos_alumnos(array('eda_id_alm' => $alm_id));
            //$data['eda_educacion']=$this->gsatelite->get_tabla('eda_educacion_alumno',array('eda_id_alm'=>$alm_id));
            //idiomas
            $data['idm_idioma'] = $this->gsatelite->get_tabla('idm_idioma', array('idm_estado' => 1));
            $data['nivel_idioma'] = $this->gsatelite->get_tabla('nii_nivel_idioma', array('nii_estado' => 1));
            $data['idioma_reg'] = $this->personal_model->get_idioma_alumnos(array('ial_id_alm' => $alm_id));

            //datos clinicos
            $data['clinicos_reg'] = $this->personal_model->get_clinicos_alumnos(array('cla_id_alm' => $alm_id));
            $parentesco_dtc_drop = $this->gsatelite->get_dropdown('pat_parentesco', '{pat_nombre}', '', array('pat_estado' => 1), $data['clinicos_reg'][0]['cla_id_pat'], '', 'pat_id', true);
            $data['parentesco_dtc'] = str_replace('<option value="0">Seleccione</option>', '', $parentesco_dtc_drop);
            $tipo_tratamiento_drop = $this->gsatelite->get_dropdown('ttm_tipo_tratamiento', '{ttm_nombre}', '', array('ttm_estado' => 1), $data['clinicos_reg'][0]['cla_id_ttm'], '', 'ttm_id', true);
            $data['tipo_tratamiento'] = str_replace('<option value="0">Seleccione</option>', '', $tipo_tratamiento_drop);

            //referencias laborales
            $data['ref_laborales_reg'] = $this->gsatelite->get_tabla('eal_empleo_alumno', array('eal_id_alm' => $alm_id));

            //HABILIDADES PASATIEMPOS
            $data['habilidades_reg'] = $this->personal_model->get_habilidades_alumnos(array('hxa_id_alm' => $alm_id));
            //die(print_r($data['habilidades_reg']));
            $data['pasatiempos_reg'] = $this->personal_model->get_pasatiempo_alumno(array('psa_id_alm' => $alm_id));
            $habilidades_drop = $this->gsatelite->get_dropdown('tih_tipo_habilidad', '{tih_nombre}', '', array('tih_estado' => 1), null, '', 'tih_id', true);
            $data['tipo_habilidad'] = str_replace('<option value="0">Seleccione</option>', '', $habilidades_drop);
            $pasatiempo_drop = $this->gsatelite->get_dropdown('pst_pasatiempo', '{pst_nombre}', '', array('pst_estado' => 1), null, '', 'pst_id', true);
            $data['tipo_pasatiempo'] = str_replace('<option value="0">Seleccione</option>', '', $pasatiempo_drop);

            //ANEXO
            $data['anexos'] = $this->gsatelite->get_tabla('axl_anexoxalumno', array('axl_id_alm' => $alm_id, 'axl_img_perfil' => 0));

            $data['doc_documentos'] = $this->gsatelite->get_tabla('tde_tipo_documento');

            $data["permiso_nuevo_cliente"] = $this->gsatelite->get_permisos_opcion('facturacion/entradas/clientes', null, null, true);

            $data["titulo_personal"] = "Editar ficha del estudiante";
            $this->_cargarvista($data);
        }
    }

    function ingresar_edicion_alumno() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //print_r($_POST);die();
            $alm_id = $this->input->post('alm_id');
            $id_alm_cli = $this->gsatelite->get_campo('alm_alumno', 'alm_id_cli', array('alm_id' => $alm_id));
            $id_alm_gfa = $this->gsatelite->get_campo('alm_alumno', 'alm_id_gfa', array('alm_id' => $alm_id));

            //Tab datos generales
            $dtg_religion = (trim($this->input->post('dtg_religion')) != "") ? $this->input->post('dtg_religion') : null;
            $dtg_profesion = (trim($this->input->post('dtg_profesion')) != "") ? $this->input->post('dtg_profesion') : null;
            $dtg_nmiembros = (trim($this->input->post('dtg_nmiembros')) != "") ? $this->input->post('dtg_nmiembros') : null;
            $dtg_trabajo = (trim($this->input->post('dtg_trabajo')) != "") ? 1 : 0; //ibutton
            $dtg_hijos = (trim($this->input->post('dtg_hijos')) != "") ? 1 : 0; //ibutton
            $dtg_email = (trim($this->input->post('dtg_email')) != "") ? $this->input->post('dtg_email') : null;
            $dtg_gfamiliar = (trim($this->input->post('dtg_gfamiliar')) != "") ? $this->input->post('dtg_gfamiliar') : null;
            $dtg_estfamiliar = (trim($this->input->post('dtg_estfamiliar')) != "") ? $this->input->post('dtg_estfamiliar') : null;
            $dtg_becado = (trim($this->input->post('dtg_becado')) != "") ? 1 : 0; //ibutton
            $dtg_financiamiento = (trim($this->input->post('dtg_financiamiento')) != "") ? $this->input->post('dtg_financiamiento') : null;
            $dtg_trasporte = (trim($this->input->post('dtg_trasporte')) != "") ? $this->input->post('dtg_trasporte') : null;


            $dtg_estestudiante = (trim($this->input->post('dtg_estestudiante')) != "") ? $this->input->post('dtg_estestudiante') : null; //alm
            $dtg_tipingreso = (trim($this->input->post('dtg_tipingreso')) != "") ? $this->input->post('dtg_tipingreso') : null; //alm
            $dtg_observacion = (trim($this->input->post('dtg_observacion')) != "") ? $this->input->post('dtg_observacion') : null; //alm
            $dtg_aspiracion = (trim($this->input->post('dtg_aspiracion')) != "") ? $this->input->post('dtg_aspiracion') : null; //alm
            //Tab datos generales2
            $dtg2_codigo = (trim($this->input->post('dtg2_codigo')) != "") ? $this->input->post('dtg2_codigo') : null; //alm
            $dtg2_nie = (trim($this->input->post('dtg2_nie')) != "") ? $this->input->post('dtg2_nie') : null; //alm
            $dtg2_nombre = (trim($this->input->post('dtg2_nombre')) != "") ? $this->input->post('dtg2_nombre') : null; //alm
            $dtg2_apellido = (trim($this->input->post('dtg2_apellido')) != "") ? $this->input->post('dtg2_apellido') : null; //alm
            $dtg2_genero = (trim($this->input->post('dtg2_genero')) != "") ? $this->input->post('dtg2_genero') : null; //alm
            $dtg2_estcivil = (trim($this->input->post('dtg2_estcivil')) != "") ? $this->input->post('dtg2_estcivil') : null; //alm
            $dtg2_pais_residencia = (trim($this->input->post('dtg2_pais_residencia')) != "") ? $this->input->post('dtg2_pais_residencia') : null;
            $dtg2_departamento_residencia = (trim($this->input->post('dtg2_departamento_residencia')) != "") ? $this->input->post('dtg2_departamento_residencia') : null;
            $dtg2_municipio_residencia = (trim($this->input->post('dtg2_municipio_residencia')) != "") ? $this->input->post('dtg2_municipio_residencia') : null;
            $dtg2_direccion_residencia = (trim($this->input->post('dtg2_direccion_residencia')) != "") ? $this->input->post('dtg2_direccion_residencia') : null; //alm
            $dtg2_distancia_residencia = (trim($this->input->post('dtg2_distancia_residencia')) != "") ? $this->input->post('dtg2_distancia_residencia') : null; //alm
            $dtg2_nacionalidad_nacimiento = (trim($this->input->post('dtg2_nacionalidad_nacimiento')) != "") ? $this->input->post('dtg2_nacionalidad_nacimiento') : null; //alm
            $dtg2_nnacionalidad_nacimiento = (trim($this->input->post('dtg2_nnacionalidad_nacimiento')) != "") ? $this->input->post('dtg2_nnacionalidad_nacimiento') : null; //alm
            $dtg2_departamento_nacimiento = (trim($this->input->post('dtg2_departamento_nacimiento')) != "") ? $this->input->post('dtg2_departamento_nacimiento') : null; //alm
            $dtg2_municipio_nacimiento = (trim($this->input->post('dtg2_municipio_nacimiento')) != "") ? $this->input->post('dtg2_municipio_nacimiento') : null; //alm
            $dtg2_lugar_nacimiento = (trim($this->input->post('dtg2_lugar_nacimiento')) != "") ? $this->input->post('dtg2_lugar_nacimiento') : null; //alm
            $dtg2_nacimiento = (trim($this->input->post('dtg2_nacimiento')) != "") ? date('Y-m-d', strtotime(trim($this->input->post('dtg2_nacimiento')))) : null; //alm
            $dtg2_area_nacimiento = (trim($this->input->post('dtg2_area_nacimiento')) != "") ? $this->input->post('dtg2_area_nacimiento') : null; //alm

            $dtg2_empresa_convenio = (trim($this->input->post('slcEmpresa')) != "") ? $this->input->post('slcEmpresa') : null; //alm
            $dtg2_vendedor = (trim($this->input->post('dtg2_vendedor')) != "") ? $this->input->post('dtg2_vendedor') : null; 

            $dtg_id_asociado = null;
            $dtg_nombre_factura = null;

            $cliente_factura = $this->input->post('txtNombreFac');

            if(isset($cliente_factura) && trim($cliente_factura) != "") {
                $cliente_asociado = $this->gsatelite->get_registro('cli_cliente', 'cli_id', $cliente_factura);

                $dtg_id_asociado = $cliente_factura;
                $dtg_nombre_factura = $cliente_asociado->cli_nombre.' '.$cliente_asociado->cli_apellido;
            } else {
                $dtg_nombre_factura = $dtg2_nombre.' '.$dtg2_apellido;
            }

            $alumno_campos = array(
                'alm_id_pai' => $dtg2_pais_residencia,
                'alm_id_dep' => $dtg2_departamento_residencia,
                'alm_id_mun' => $dtg2_municipio_residencia,
                'alm_id_gen' => $dtg2_genero,
                'alm_id_esc' => $dtg2_estcivil,
                'alm_id_pro' => $dtg_profesion,
                'alm_id_fin' => $dtg_financiamiento,
                //'alm_id_cli' => $asdada,
                'alm_id_esf' => $dtg_estfamiliar,
                'alm_id_esa' => $dtg_estestudiante,
                'alm_id_rel' => $dtg_religion,
                'alm_id_gfa' => $dtg_gfamiliar,
                'alm_id_tin' => $dtg_tipingreso,
                'alm_id_ttr' => $dtg_trasporte,
                'alm_id_pai_nacionalidad' => $dtg2_nacionalidad_nacimiento,
                'alm_id_dep_nacimiento' => $dtg2_departamento_nacimiento,
                'alm_id_mun_nacimiento' => $dtg2_municipio_nacimiento,
                'alm_id_zon' => $dtg2_area_nacimiento,
                'alm_codigo' => $dtg2_codigo,
                'alm_codigo_nie' => $dtg2_nie,
                'alm_nombre' => $dtg2_nombre,
                'alm_apellido' => $dtg2_apellido,
                'alm_fecha_nacimiento' => $dtg2_nacimiento,
                'alm_lugar_nac' => $dtg2_lugar_nacimiento,
                'alm_direccion' => $dtg2_direccion_residencia,
                // 'alm_id_cli_factura'=>$dtg2_empresa_convenio,
                //'alm_vehiculo' => $asdada,
                //'alm_licencia' => $asdada,
                'alm_email' => $dtg_email,
                'alm_observacion' => $dtg_observacion,
                'alm_fotografia' => $this->input->post('foto_empleado'),
                'alm_becado' => $dtg_becado,
                'alm_aspiracion_personal' => $dtg_aspiracion,
                'alm_trabaja' => $dtg_trabajo,
                'alm_posee_hijos' => $dtg_hijos,
                'alm_miembro_familia' => $dtg_nmiembros,
                'alm_distancia' => $dtg2_distancia_residencia,
                'alm_anio_nacionalidad' => $dtg2_nnacionalidad_nacimiento,
                'alm_usu_mod' => $this->tank_auth->get_user_id(),
                'alm_fecha_mod' => date('Y-m-d H:i:s')
            );
            // die(print_r($alumno_cliente));
            $this->gsatelite->actualizar_array('alm_alumno', $alumno_campos, array('alm_id' => $alm_id));

            if(isset($id_alm_gfa) && !isset($dtg_gfamiliar)) {

                $cantidad_actual = $this->gsatelite->get_campo('gfa_grupo_familiar', 'gfa_cantidad', array('gfa_id' => $id_alm_gfa));
                
                $nueva_cantidad = $cantidad_actual - 1;

                $actualizar_cantidad = array(
                    'gfa_cantidad' => $nueva_cantidad,
                    'gfa_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'gfa_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('gfa_grupo_familiar', $actualizar_cantidad, array('gfa_id' => $dtg_gfamiliar));
                
            } else if (!isset($id_alm_gfa) && isset($dtg_gfamiliar)) {

                $cantidad_actual = $this->gsatelite->get_campo('gfa_grupo_familiar', 'gfa_cantidad', array('gfa_id' => $dtg_gfamiliar));
                
                $nueva_cantidad = $cantidad_actual + 1;

                $actualizar_cantidad = array(
                    'gfa_cantidad' => $nueva_cantidad,
                    'gfa_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'gfa_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('gfa_grupo_familiar', $actualizar_cantidad, array('gfa_id' => $dtg_gfamiliar));

            }


            /* ===========================================================================================================
                                                  EMPRESA/CONVENIO
            =============================================================================================================
            */
            $clm_bd = $this->gsatelite->borrado_general('clm_cliente_alumno', array('clm_id_alm'=>$alm_id));
            if ($dtg2_empresa_convenio != '' && $dtg2_empresa_convenio != null) {
                $empresas = explode(',', $dtg2_empresa_convenio);
                foreach ($empresas as $key => $value) {
                    $empresa_dato = array(
                        'clm_id_alm'        => $alm_id,
                        'clm_id_cli'        => $value,
                        'clm_estado'        => 1,
                        'clm_usu_modificacion'      => $this->tank_auth->get_user_id(),
                        'clm_fecha_modificacion'    => date('Y-m-d H:i:s'),
                        'clm_usu_creacion'          => $this->tank_auth->get_user_id(),
                        'clm_fecha_creacion'        => date('Y-m-d H:i:s')
                    );
                    $emp = $this->gsatelite->ingresar('clm_cliente_alumno', $empresa_dato);
                }
            }

            //Se actualiza el cliente
            if ($id_alm_cli != null) {
                $alumno_cliente = array(
                    'cli_apellido' => $dtg2_apellido,
                    'cli_nombre' => $dtg2_nombre,
                    'cli_observacion' => $dtg_observacion,
                    'cli_nombre_factura'=> $dtg_nombre_factura,
                    'cli_id_cli_asociado' => ($dtg_id_asociado) ? $dtg_id_asociado : $id_alm_cli,
                    'cli_estado' => 1,
                    'cli_email' => $dtg_email,
                    'cli_usu_mod' => $this->tank_auth->get_user_id(),
                    'cli_fecha_mod' => date('Y-m-d H:i:s'),
                    'cli_direccion' => $dtg2_direccion_residencia,
                    'cli_id_ven' => $dtg2_vendedor
                );
                $this->gsatelite->actualizar_array('cli_cliente', $alumno_cliente, array('cli_id' => $id_alm_cli));
            }




            /* ===========================================================================================================
              FOTO Y ANEXOS DEL ALUMNO
              =============================================================================================================
             */
            //carpeta donde se guardan los archivos temporales
            $carpeta = $this->input->post("nombreCarpeta");
            //FOTO ALUMNO
            $imagen_alumno = trim($this->input->post('foto_empleado'));
            $titulo_foto_alum = trim($this->input->post('titulo_foto_empleado'));
            $id_foto_alum = trim($this->input->post('id_foto'));
            $url_foto = trim($this->input->post('foto_eliminar'));
            $estado_perfil = trim($this->input->post('cambiar_fot_perfil'));
            $cambiar_foto_defecto = trim($this->input->post('imagen_defecto'));
            if ($imagen_alumno != "" and $titulo_foto_alum != "") {
                $titulo = $titulo_foto_alum;
                $img = $imagen_alumno;
                $this->datos_imagen_gral(
                        $img, $alm_id, $carpeta, $titulo, ($titulo . date("Ymds")), $estado_perfil, $id_foto_alum, 1
                );
                $this->datos_imagen_gral(
                        $img, $alm_id, $carpeta, $titulo, ($titulo . date("Ymds")), 0, $id_foto_alum
                );
            }
            if ($cambiar_foto_defecto == 1) {
                $this->datos_imagen_gral(
                        $img, $alm_id, $carpeta, $titulo, ($titulo . date("Ymds")), 0, $id_foto_alum
                );
            }

            //ANEXO ALUMNO
            $rutas = $this->input->post("ruta"); //ruta son los diferentes archivos que se guardan en anexos
            $titulo_anexo = $this->input->post("titulo_doc"); //titulo de los anexos
            $reg_anexos_alumn = $this->input->post("reg_anexos_alumn"); //id de los anexos existentes
            $estado_anexo = $this->input->post("estado_anexo"); //estado de los anexos ya sea 0 eliminar, 1 actualizar, 2 nuevo anexo
            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $this->datos_imagen_gral(
                                $img, $alm_id, $carpeta, $titulo_anexo[$i], ($titulo_anexo[$i] . date("Ymds")), $estado_anexo[$i], $reg_anexos_alumn[$i]
                        );
                    }
                }
            }
            /* ===============================================================================================================
            TABLA MXL_MEDIOXALUMNO
            ================================================================================================================
            */
            $this->gsatelite->borrado_general('mxl_medioxalumno', array('mxl_id_alm' => $alm_id));

            $dtg_medio = $this->input->post('dtg_medio'); //array tab 1
            for ($x = 0; $x < count($dtg_medio); $x++) {
                $medio_campos = array(
                    'mxl_id_alm' => $alm_id,
                    'mxl_id_tmc' => $dtg_medio[$x],
                    'mxl_estado' => 1,
                    'mxl_usu_creacion' => $this->tank_auth->get_user_id(),
                    'mxl_fecha_creacion' => date('Y-m-d H:i:s'),
                    'mxl_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'mxl_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                if (trim($dtg_medio[$x]) != "") {
                    $this->gsatelite->ingresar('mxl_medioxalumno', $medio_campos);
                }
            }

            $this->gsatelite->borrado_general('cea_caracteristica_eleccionxalumno', array('cea_id_alm' => $alm_id));
            $dtg_seleccion = $this->input->post('dtg_seleccion'); //array tab 1
            for ($x = 0; $x < count($dtg_seleccion); $x++) {
                $eleccion_campos = array(
                    'cea_id_alm' => $alm_id,
                    'cea_id_cre' => $dtg_seleccion[$x],
                    'cea_estado' => 1,
                    'cea_usu_creacion' => $this->tank_auth->get_user_id(),
                    'cea_fecha_creacion' => date('Y-m-d H:i:s'),
                    'cea_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'cea_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                if (trim($dtg_seleccion[$x]) != "") {
                    $this->gsatelite->ingresar('cea_caracteristica_eleccionxalumno', $eleccion_campos);
                }
            }
            /* ==================================================================================================================================
              REGISTRO DE TELEFONOS
              ====================================================================================================================================
             */
            $this->gsatelite->borrado_general('tal_telefonoxalumno', array('tal_id_alm' => $alm_id));
            $tel_tipo = $this->input->post('tel_tipo'); //array
            $tel_numero = $this->input->post('tel_numero'); //array
            for ($x = 0; $x < count($tel_tipo); $x++) {
                $telefono_campos = array(
                    'tal_id_alm' => $alm_id,
                    'tal_id_tit' => $tel_tipo[$x],
                    'tal_numero' => $tel_numero[$x],
                    'tal_estado' => 1,
                    'tal_usu_crea' => $this->tank_auth->get_user_id(),
                    'tal_usu_mod' => $this->tank_auth->get_user_id(),
                    'tal_fecha_crea' => date('Y-m-d H:i:s'),
                    'tal_fecha_mod' => date('Y-m-d H:i:s')
                );
                if (trim($tel_tipo[$x]) != "" && trim($tel_numero[$x]) != "") {
                    $this->gsatelite->ingresar('tal_telefonoxalumno', $telefono_campos);
                }
            }

            $this->gsatelite->borrado_general('rxa_red_socialxalumno', array('rxa_id_alm' => $alm_id));
            $red_tipo = $this->input->post('red_tipo'); //array
            $perfil = $this->input->post('perfil'); //array
            for ($x = 0; $x < count($red_tipo); $x++) {
                $redes_campos = array(
                    'rxa_id_alm' => $alm_id,
                    'rxa_id_res' => $red_tipo[$x],
                    'rxa_referencia' => $perfil[$x],
                    'rxa_estado' => 1,
                    'rxa_usu_creacion' => $this->tank_auth->get_user_id(),
                    'rxa_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'rxa_fecha_creacion' => date('Y-m-d H:i:s'),
                    'rxa_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                if (trim($red_tipo[$x]) != "" && trim($perfil[$x]) != "") {
                    $this->gsatelite->ingresar('rxa_red_socialxalumno', $redes_campos);
                }
            }
            /* =====================================================================================================================
              REGISTRO DE DOCUMENTOS
              ======================================================================================================================
             */
            $array2 = $this->input->post('numero_documento');
            //$ver2= array_pop($array2);
            $array2_1 = $this->input->post('documento');
            //$ver2_1 = array_pop($array2_1);
            $array_vence_doc = $this->input->post('vence_documento');
            $array_titulo_anexo = $this->input->post('titulo_anexo_doc');
            $array_nombre_anexo = $this->input->post('nombre_anexo_doc');
            $carpeta = $this->input->post("nombre_anexo_carpeta");

            $array_fexp_doc = $this->input->post('fecha_exp_doc');
            $array_lugarexp_doc = $this->input->post('lugar_exp_doc');

            $i = 0;

            $this->gsatelite->borrado_general('dca_documento_alumno', array('dca_id_alm' => $alm_id));
            
            if (!empty($array2) && is_array($array2)) {

                foreach ($array2 as $key => $value2) {

                    $titulo_a = trim($array_titulo_anexo[$i]);
                    $url_anexo = "";
                    $f_vence = (trim($array_vence_doc[$i]) != "" and $array_vence_doc[$i] != null ) ? date('Y-m-d', strtotime(trim($array_vence_doc[$i]))) : null;
                    $f_exp = (trim($array_fexp_doc[$i]) != "" and $array_fexp_doc[$i] != null ) ? date('Y-m-d', strtotime(trim($array_fexp_doc[$i]))) : null;
                    if ($titulo_a != "") {
                        $extencion = end(explode(".", $array_nombre_anexo[$i]));
                        //$url_anexo= "uploads/anexos_empleados/".trim($array_titulo_anexo[$i]).".".trim($extencion);
                        $url_anexo = trim($array_titulo_anexo[$i]) . "." . trim($extencion); //se modifico de esta manera porque se uso grocery para su edicion.
                        $this->datos_anexo_documento(trim($array_nombre_anexo[$i]), $carpeta, $titulo_a, $url_anexo); //funcion para guardar el anexo
                    }

                    $documentos_campos = array(
                        'dca_id_alm' => $alm_id,
                        'dca_id_tde' => $array2_1[$i],
                        'dca_valor' => $value2,
                        'dca_fecha_vence' => $f_vence,
                        'dca_nombre_anexo' => $titulo_a,
                        'dca_url' => $url_anexo,
                        'dca_fecha_expedicion' => $f_exp,
                        'dca_lugar_expedicion' => trim($array_lugarexp_doc[$i]),
                        'dca_estado' => 1,
                        'dca_usu_mod' => $this->tank_auth->get_user_id(),
                        'dca_fecha_mod' => date('Y-m-d H:i:s'),
                        'dca_usu_crea' => $this->tank_auth->get_user_id(),
                        'dca_fecha_crea' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('dca_documento_alumno', $documentos_campos);
                    // var_dump($url_anexo);die();
                    // $dce_id= $this->db->insert_id();
                    //$this->db->where('dce_id',$dce_id);
                    // $this->db->update('dce_documento_alm',array('dce_id_alm' => $array2_1[$i]));
                    $i++;
                }
            }
            //**FIN DDE GUARDAR DOCUMENTOS**//

            /* =======================================================================================================================
              REGISTRO DE FAMILIARES
              ========================================================================================================================
             */
            $fam_empleado = $this->input->post('id_emp'); //array
            $fam_nombre = $this->input->post('fam_nombre'); //array
            $fam_apellido = $this->input->post('fam_apellido'); //array
            $fam_fecha = $this->input->post('fam_fecha'); //array
            $fam_telefono = $this->input->post('fam_telefono'); //array
            $fam_telefono_cel = $this->input->post('fam_telefono_cel'); //array
            $fam_parentesco = $this->input->post('fam_parentesco'); //array
            $fam_responsable = $this->input->post('fam_responsable'); //array
            $fam_dependencia = $this->input->post('fam_dependencia'); //array
            $fam_profesion = $this->input->post('fam_profesion'); //array
            $fam_email = $this->input->post('fam_email'); //array
            $fam_convivencia_val = $this->input->post('fam_convivencia_val'); //array
            $fam_docTipo = $this->input->post('fam_docTipo'); //array
            $fam_documento = $this->input->post('fam_documento'); //array
            $fam_lugar_trab = $this->input->post('fam_lugar_trab'); //array
            $fam_direccion_trab = $this->input->post('fam_direccion_trab'); //array
            $fam_salario = $this->input->post('fam_salario'); //array

            $this->gsatelite->borrado_general('fal_familiar_alumno', array('fal_id_alm' => $alm_id));

            for ($x = 0; $x < count($fam_nombre); $x++) {
                $registro = explode('_', $fam_empleado[$x]); // Agregado por Luis Navarro
               // die(print_r($registro));
                $familia_campos = array(
                    'fal_id_pro' => (isset($fam_profesion[$x]) && trim($fam_profesion[$x]) != "") ? $fam_profesion[$x] : null,
                    'fal_id_tde' => (trim($fam_docTipo[$x]) != "") ? $fam_docTipo[$x] : null,
                    'fal_id_pat' => (trim($fam_parentesco[$x]) != "") ? $fam_parentesco[$x] : null,
                    'fal_id_alm' => $alm_id,
                    'fal_id_emp' => (trim($registro[1]) == 'emp' && $registro[0]>0) ? $registro[0] : null,
                    'fal_id_alm_familiar' => (trim($registro[1]) == 'alm' && $registro[0] > 0 ) ? $registro[0] : null,
                    'fal_nombre' => (trim($fam_nombre[$x]) != "") ? $fam_nombre[$x] : null,
                    'fal_apellido' => (trim($fam_apellido[$x]) != "") ? $fam_apellido[$x] : null,
                    'fal_fecha_nacimiento' => (trim($fam_fecha[$x]) != "") ? date('Y-m-d', strtotime($fam_fecha[$x])) : null,
                    'fal_telefono' => (trim($fam_telefono[$x]) != "") ? $fam_telefono[$x] : null,
                    'fal_telefono_cel' => (trim($fam_telefono_cel[$x]) != "") ? $fam_telefono_cel[$x] : null,
                    'fal_responsable' => (trim($fam_responsable[$x]) != "") ? $fam_responsable[$x] : 0,
                    'fal_dependiente' => (trim($fam_dependencia[$x]) != "") ? $fam_dependencia[$x] : null,
                    'fal_correo' => (trim($fam_email[$x]) != "") ? $fam_email[$x] : null,
                    'fal_convivencia' => (trim($fam_convivencia_val[$x]) != "") ? $fam_convivencia_val[$x] : null,
                    'fal_numero_documento' => (trim($fam_documento[$x]) != "") ? $fam_documento[$x] : null,
                    'fal_lugar_trabajo' => (trim($fam_lugar_trab[$x]) != "") ? $fam_lugar_trab[$x] : null,
                    'fal_direccion_trabajo' => (trim($fam_direccion_trab[$x]) != "") ? $fam_direccion_trab[$x] : null,
                    'fal_salario' => (trim($fam_salario[$x]) != "") ? $fam_salario[$x] : null,
                    'fal_estado' => 1,
                    'fal_usu_creacion' => $this->tank_auth->get_user_id(),
                    'fal_fecha_creacion' => date('Y-m-d H:i:s'),
                    'fal_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'fal_fecha_modificacion' => date('Y-m-d H:i:s')
                );

                if (trim($fam_parentesco[$x]) != "" && trim($fam_nombre[$x]) != "" && trim($fam_apellido[$x]) != "") {
                    $id = $this->gsatelite->ingresar('fal_familiar_alumno', $familia_campos);
                }
            }
            /* ==================================================================================================================================
              REGISTRO DE DATOS ACADEMICOS
              ====================================================================================================================================
             */
            $tipo_edu = $this->input->post('tipo_edu');
            //$nombre_edu = $this->input->post('nombre_edu');
            $titulo_edu = $this->input->post('titulo_edu');
            $institutcion_edu = $this->input->post('institutcion_edu');
            $pais_edu = $this->input->post('pais_edu');
            $fecha_fin_edu = $this->input->post('fecha_fin_edu');
            $observacion_edu = $this->input->post('observacion_edu');
            $repitencia_edu = $this->input->post('datAca_repitencia_val');

            //die(print_r($fecha_fin_edu,true));

            $this->gsatelite->borrado_general('eda_educacion_alumno', array('eda_id_alm' => $alm_id));

            $datos_academicos = array();

            if (!empty($tipo_edu) && is_array($tipo_edu)) {
                foreach ($tipo_edu as $key => $value) {
                    $datos_academicos = array(
                        'eda_id_alm' => $alm_id,
                        'eda_id_pai' => (trim($pais_edu[$key]) != "") ? $pais_edu[$key] : null,
                        'eda_id_tie' => $value,
                        'eda_id_ted' => (trim($titulo_edu[$key]) != "") ? $titulo_edu[$key] : null,
                        'eda_id_ina' => (trim($institutcion_edu[$key]) != "") ? $institutcion_edu[$key] : null,
                        'eda_fecha_final' => ($fecha_fin_edu[$key] != "") ? date('Y-m-d', strtotime($fecha_fin_edu[$key])) : null,
                        'eda_observacion' => (trim($observacion_edu[$key]) != "") ? $observacion_edu[$key] : null,
                        'eda_repitencia' => (trim($repitencia_edu[$key]) != "") ? $repitencia_edu[$key] : null,
                        'eda_estado' => 1,
                        'eda_usu_creacion' => $this->tank_auth->get_user_id(),
                        'eda_fecha_creacion' => date('Y-m-d H:i:s'),
                        'eda_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'eda_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    //die(print_r($datos_academicos,true));
                    $this->gsatelite->ingresar('eda_educacion_alumno', $datos_academicos);
                }
            }
            //****************FIN DE DATOS academicos******************//

            /* ==================================================================================================================================
              REGISTRO DE IDIOMAS
              ====================================================================================================================================
             */
            $select_idioma = $this->input->post('idioma');
            $nivel_idioma = $this->input->post('nivel');
            $leer_idioma = $this->input->post('leer');
            $escribir_idioma = $this->input->post('escribir');
            $hablar_idioma = $this->input->post('hablar');
            $traductor = $this->input->post('traductor');
            $incorporado = $this->input->post('incorporado');
            $fecha_idm = $this->input->post('fecha_idm');
            $nota_idm = $this->input->post('nota_idm');

            //die(print_r($nivel_idioma,true));
            $this->gsatelite->borrado_general('ial_idioma_alumno', array('ial_id_alm' => $alm_id));

            $datos_idioma = array();

            if (!empty($select_idioma) && is_array($select_idioma)) {

                foreach ($select_idioma as $key => $value) {
                    $datos_idioma = array(
                        'ial_id_alm' => $alm_id, //$alm_id,
                        'ial_id_idm' => $value,
                        'ial_id_nii' => $nivel_idioma[$key],
                        'ial_leer' => (trim($leer_idioma[$key]) != "") ? $leer_idioma[$key] : null,
                        'ial_escribir' => (trim($escribir_idioma[$key]) != "") ? $escribir_idioma[$key] : null,
                        'ial_hablar' => (trim($hablar_idioma[$key]) != "") ? $hablar_idioma[$key] : null,
                        'ial_traductor' => (trim($traductor[$key]) != "") ? $traductor[$key] : null,
                        'ial_incorporado' => (trim($incorporado[$key]) != "") ? $incorporado[$key] : null,
                        'ial_fecha_examen' => ($fecha_idm[$key] != "") ? date('Y-m-d', strtotime($fecha_idm[$key])) : null,
                        'ial_nota' => (trim($nota_idm[$key]) != "" && is_numeric($nota_idm[$key])) ? $nota_idm[$key] : null,
                        'ial_estado' => 1,
                        'ial_usu_crea' => $this->tank_auth->get_user_id(),
                        'ial_fecha_crea' => date('Y-m-d H:i:s'),
                        'ial_usu_mod' => $this->tank_auth->get_user_id(),
                        'ial_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    //die(print_r($datos_idioma,true));
                    $this->gsatelite->ingresar('ial_idioma_alumno', $datos_idioma);
                }
            }
            /* ==================================================================================================================================
              REGISTRO DE DATOS CLINICOS
              ====================================================================================================================================
             */
            $dtc_alergia_clinicos = (trim($this->input->post('dtc_alergia_clinicos')) != "") ? $this->input->post('dtc_alergia_clinicos') : null; //clinicos
            $dtc_estatura_clinico = (trim($this->input->post('dtc_estatura_clinico')) != "") ? $this->input->post('dtc_estatura_clinico') : null; //clinicos
            $dtc_peso_clinico = (trim($this->input->post('dtc_peso_clinico')) != "") ? $this->input->post('dtc_peso_clinico') : null; //clinicos
            $dtc_sangre_clinico = (trim($this->input->post('dtc_sangre_clinico')) != "") ? $this->input->post('dtc_sangre_clinico') : null; //clinicos
            $dtc_discapacidad_clinico = (trim($this->input->post('dtc_discapacidad_clinico')) != "") ? $this->input->post('dtc_discapacidad_clinico') : null; //clinicos
            $dtc_enfermedad_clinico = (trim($this->input->post('dtc_enfermedad_clinico')) != "") ? $this->input->post('dtc_enfermedad_clinico') : null; //clinicos
            $dtc_observacion_clinico = (trim($this->input->post('dtc_observacion_clinico')) != "") ? $this->input->post('dtc_observacion_clinico') : null; //clinicos

            $dtc_tratamiento = (trim($this->input->post('dtc_tratamiento')) != "") ? $this->input->post('dtc_tratamiento') : 0; //clinicos
            $dtc_tratamiento_tipo = (trim($this->input->post('dtc_tratamiento_tipo')) != "") ? $this->input->post('dtc_tratamiento_tipo') : null; //clinicos
            $dtc_detalle = (trim($this->input->post('dtc_detalle')) != "") ? $this->input->post('dtc_detalle') : null; //clinicos
            $dtc_medicamento = (trim($this->input->post('dtc_medicamento')) != "") ? $this->input->post('dtc_medicamento') : null; //clinicos

            $dtc_nombre_emergencia = (trim($this->input->post('dtc_nombre_emergencia')) != "") ? $this->input->post('dtc_nombre_emergencia') : null; //clinicos
            $dtc_direccion_emergencia = (trim($this->input->post('dtc_direccion_emergencia')) != "") ? $this->input->post('dtc_direccion_emergencia') : null; //clinicos
            $dtc_parentesco_emergencia = (trim($this->input->post('dtc_parentesco_emergencia')) != "") ? $this->input->post('dtc_parentesco_emergencia') : null; //clinicos
            $dtc_telefono_emergencia = (trim($this->input->post('dtc_telefono_emergencia')) != "") ? $this->input->post('dtc_telefono_emergencia') : null; //clinicos
            //$dtc_responsable_emergencia = (trim($this->input->post('dtc_responsable_emergencia')) != "")?$this->input->post('dtc_responsable_emergencia'):null; //clinicos
            $dtc_responsable_emergencia = 1; //clinicos

            $this->gsatelite->borrado_general('cla_clinico_alumno', array('cla_id_alm' => $alm_id));
            $datos_clinicos_campos = array(
                'cla_id_alm' => $alm_id,
                'cla_id_pat' => $dtc_parentesco_emergencia,
                'cla_id_ttm' => $dtc_tratamiento_tipo,
                'cla_estatura' => $dtc_estatura_clinico,
                'cla_peso' => $dtc_peso_clinico,
                'cla_tipo_sangre' => $dtc_sangre_clinico,
                'cla_alergico' => $dtc_alergia_clinicos,
                'cla_discapacidad' => $dtc_discapacidad_clinico,
                'cla_enfermedad' => $dtc_enfermedad_clinico,
                'cla_familiar' => $dtc_nombre_emergencia,
                'cla_direccion_fam' => $dtc_direccion_emergencia,
                'cla_telefono' => $dtc_telefono_emergencia,
                'cla_observacion' => $dtc_observacion_clinico,
                'cla_fam_reponsable' => $dtc_responsable_emergencia,
                'cla_posee_tratamiento' => $dtc_tratamiento,
                'cla_descripcion_tratamiento' => $dtc_detalle,
                'cla_descripcion_medicamento' => $dtc_medicamento,
                'cla_estado' => 1,
                'cla_usu_mod' => $this->tank_auth->get_user_id(),
                'cla_fecha_mod' => date('Y-m-d H:i:s'),
                'cla_usu_crea' => $this->tank_auth->get_user_id(),
                'cla_fecha_crea' => date('Y-m-d H:i:s')
            );

            $this->gsatelite->ingresar('cla_clinico_alumno', $datos_clinicos_campos);

            /* ==================================================================================================================================
              REGISTRO DE REFERENCIAS LABORALES
              ====================================================================================================================================
             */
            $rlab_lugar = $this->input->post('rlab_lugar'); //array
            $rlab_direccion = $this->input->post('rlab_direccion'); //array
            $rlab_telefono = $this->input->post('rlab_telefono'); //array
            $rlab_puesto = $this->input->post('rlab_puesto'); //array
            $rlab_jefe = $this->input->post('rlab_jefe'); //array
            $rlab_salario = $this->input->post('rlab_salario'); //array
            $rlab_motivo = $this->input->post('rlab_motivo'); //array

            $this->gsatelite->borrado_general('eal_empleo_alumno', array('eal_id_alm' => $alm_id));
            for ($x = 0; $x < count($rlab_lugar); $x++) {
                $referencia_lab_campos = array(
                    'eal_id_alm' => $alm_id,
                    'eal_empresa' => (trim($rlab_lugar[$x]) != "") ? $rlab_lugar[$x] : null,
                    'eal_direccion' => (trim($rlab_direccion[$x]) != "") ? $rlab_direccion[$x] : null,
                    'eal_telefono' => (trim($rlab_telefono[$x]) != "") ? $rlab_telefono[$x] : null,
                    'eal_puesto' => (trim($rlab_puesto[$x]) != "") ? $rlab_puesto[$x] : null,
                    'eal_jefe_inmediato' => (trim($rlab_jefe[$x]) != "") ? $rlab_jefe[$x] : null,
                    'eal_salario' => (trim($rlab_salario[$x]) != "") ? $rlab_salario[$x] : null,
                    'eal_motivo_retiro' => (trim($rlab_motivo[$x]) != "") ? $rlab_motivo[$x] : null,
                    'eal_estado' => 1,
                    'eal_usu_crea' => $this->tank_auth->get_user_id(),
                    'eal_fecha_crea' => date('Y-m-d H:i:s'),
                    'eal_usu_mod' => $this->tank_auth->get_user_id(),
                    'eal_fecha_mod' => date('Y-m-d H:i:s')
                );
                if (trim($rlab_lugar[$x]) != "" && trim($rlab_direccion[$x]) != "" && trim($rlab_telefono[$x]) != "" && trim($rlab_puesto[$x]) != "") {
                    $this->gsatelite->ingresar('eal_empleo_alumno', $referencia_lab_campos);
                }
            }
            /* ==================================================================================================================================
              REGISTRO DE HABILIDADES Y PASATIEMPOS
              ====================================================================================================================================
             */
            $hbl_tipo = $this->input->post('hbl_tipo'); //array
            $hbl_habilidad = $this->input->post('hbl_habilidad'); //array
            $hbl_grupo = $this->input->post('hbl_grupo'); //array
            $hbl_observacion = $this->input->post('hbl_observacion'); //array
            $this->gsatelite->borrado_general('hxa_habilidadxalumno', array('hxa_id_alm' => $alm_id));
            
            for ($x = 0; $x < count($hbl_tipo); $x++) {
                $habilidad_campos = array(
                    'hxa_id_alm' => $alm_id,
                    'hxa_id_grh' => (trim($hbl_grupo[$x]) != "") ? $hbl_grupo[$x] : null,
                    'hxa_id_hab' => (trim($hbl_habilidad[$x]) != "") ? $hbl_habilidad[$x] : null,
                    'hxa_observacion' => (trim($hbl_observacion[$x]) != "") ? $hbl_observacion[$x] : null,
                    'hxa_estado' => 1,
                    'hxa_usu_creacion' => $this->tank_auth->get_user_id(),
                    'hxa_fecha_creacion' => date('Y-m-d H:i:s'),
                    'hxa_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'hxa_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                if ( trim($hbl_habilidad[$x]) != "" ) {
                    $this->gsatelite->ingresar('hxa_habilidadxalumno', $habilidad_campos);
                }
            }

            $hbl_tipo_habilidad = $this->input->post('hbl_tipo_habilidad'); //array
            $hbl_observacion_habilidad = $this->input->post('hbl_observacion_habilidad'); //array
            $this->gsatelite->borrado_general('psa_pasatiempo_alumno', array('psa_id_alm' => $alm_id));
            for ($x = 0; $x < count($hbl_tipo_habilidad); $x++) {
                $pasatiempo_campos = array(
                    'psa_id_alm' => $alm_id,
                    'psa_id_pst' => (trim($hbl_tipo_habilidad[$x]) != "") ? $hbl_tipo_habilidad[$x] : null,
                    'psa_observacion' => (trim($hbl_observacion_habilidad[$x]) != "") ? $hbl_observacion_habilidad[$x] : null,
                    'psa_estado' => 1,
                    'psa_usu_creacion' => $this->tank_auth->get_user_id(),
                    'psa_fecha_creacion' => date('Y-m-d H:i:s'),
                    'psa_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'psa_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                if (trim($hbl_tipo_habilidad[$x]) != "" && trim($hbl_observacion_habilidad[$x]) != "") {
                    $this->gsatelite->ingresar('psa_pasatiempo_alumno', $pasatiempo_campos);
                }
            }
            if ($alm_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de alumnos", 'texto_alerta' => "El registro se actualizo correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de alumnos", 'texto_alerta' => "El registro no se actualizo, revise la información a ingresar.");
            }
            $this->session->set_flashdata($alerta);
            $direccionar = $this->input->post('direccionar');
            if ($direccionar == 2) {
                redirect('registro_academico/procesos/gestion_alumnos/');
            } else {
                redirect('registro_academico/procesos/editar_alumno/' . $alm_id);
            }
        }
    }
   
    public function agregar_docente() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $data['genero'] = $this->personal_model->get_genero();
            $data['nacionalidad'] = $this->personal_model->get_nacionalidad();
            $data['pais'] = $this->personal_model->get_nacionalidad();
            $data['estado_civil'] = $this->personal_model->get_estado_civil();
            $data['profesion'] = $this->personal_model->get_profesion();
            $data['tipo_telefono'] = $this->personal_model->get_tipotelefono();
            //$data['afp']=$this->personal_model->get_afp();
            $data['doc_documentos'] = $this->personal_model->get_documentos();
            $tipos_doc = $this->gsatelite->get_dropdown('tde_tipo_documento', '{tde_nombre}', '', array('tde_estado' => 1), null, '', 'tde_id', true);
            $data['options_tipo_documento'] = str_replace('<option value="0">Seleccione</option>', '', $tipos_doc);

            $data['depart'] = $this->gsatelite->get_tabla('dep_departamento');

            // die(print_r($data['depart'],true));
            //$arreglo_ids = $this->expediente_personal_model->get_permitidos_plaza();
            // $this->db->where_not_in('plz_id',$arreglo_ids);
            //  $data['plaza']=$this->gsatelite->get_tabla('plz_plaza',array('plz_estado'=>1));
            //$data['departamento']=$this->personal_model->get_departamento();
            //$data['sucursal']=$this->personal_model->get_sucursal();
            //$data['tipo_contrato']=$this->personal_model->get_tipo_contrato();
            //$data['imagenes']=$this->utm
            // $data['parentescos']=$this->personal_model->get_parentesco();
            $titulo['titulo_personal'] = "Nuevo docente";
            $this->_cargarvista($titulo, $data);
        }
    }

    public function editar_docente() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['genero'] = $this->personal_model->get_genero();
            $data['nacionalidad'] = $this->personal_model->get_nacionalidad();
            $data['pais'] = $this->personal_model->get_nacionalidad();
            $data['estado_civil'] = $this->personal_model->get_estado_civil();
            $data['profesion'] = $this->personal_model->get_profesion();
            $data['tipo_telefono'] = $this->personal_model->get_tipotelefono();
            //$data['afp']=$this->personal_model->get_afp();
            $data['doc_documentos'] = $this->personal_model->get_documentos();
            $tipos_doc = $this->gsatelite->get_dropdown('tde_tipo_documento', '{tde_nombre}', '', array('tde_estado' => 1), null, '', 'tde_id', true);
            $data['options_tipo_documento'] = str_replace('<option value="0">Seleccione</option>', '', $tipos_doc);

            $data['depart'] = $this->gsatelite->get_tabla('dep_departamento');

            // die(print_r($data['depart'],true));
            //$arreglo_ids = $this->expediente_personal_model->get_permitidos_plaza();
            // $this->db->where_not_in('plz_id',$arreglo_ids);
            //  $data['plaza']=$this->gsatelite->get_tabla('plz_plaza',array('plz_estado'=>1));
            //$data['departamento']=$this->personal_model->get_departamento();
            //$data['sucursal']=$this->personal_model->get_sucursal();
            //$data['tipo_contrato']=$this->personal_model->get_tipo_contrato();
            //$data['imagenes']=$this->utm
            // $data['parentescos']=$this->personal_model->get_parentesco();
            $titulo['titulo_personal'] = "Editar docente";
            $this->_cargarvista($titulo, $data);
        }
    }

    function nuevo_docente() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //die(var_dump($_POST));
            //exit();
            $nuevo = array(
                'emp_id_suc' => ($this->input->post('sucursal') != "") ? $this->input->post('sucursal') : 1,
                'emp_id_plz' => ($this->input->post('puesto') != "") ? $this->input->post('puesto') : null,
                'emp_id_afp' => ($this->input->post('afp') != "") ? $this->input->post('afp') : null,
                'emp_nombre' => $this->input->post('nombres'),
                'emp_apellido' => $this->input->post('apellidos'),
                'emp_estado' => $this->input->post('estado'),
                'emp_direccion' => $this->input->post('direccion'),
                'emp_id_are' => ($this->input->post('departamento') != "") ? $this->input->post('departamento') : null,
                'emp_lugar_nac' => $this->input->post('lugar_nacimiento'),
                'emp_id_pai' => ($this->input->post('nacionalidad') != "") ? $this->input->post('nacionalidad') : null,
                'emp_fecha_nac' => date('Y-m-d', strtotime($this->input->post('fecha_nacimiento'))),
                'emp_id_gen' => ($this->input->post('genero') != "") ? $this->input->post('genero') : null,
                'emp_id_pro' => ($this->input->post('profesion') != "") ? $this->input->post('profesion') : null,
                'emp_id_esc' => ($this->input->post('estado_civil') != "") ? $this->input->post('estado_civil') : null,
                'emp_fecha_contrato' => date('Y-m-d', strtotime($this->input->post('fecha_contratacion'))),
                'emp_fecha_retiro' => null, //$this->input->post(''),
                'emp_salario' => ($this->input->post('salario') != "") ? $this->input->post('salario') : 0,
                'emp_salario_hora' => ($this->input->post('salario_hora') != "") ? $this->input->post('salario_hora') : null,
                'emp_salario_hora_nocturna' => ($this->input->post('salario_hora_noc') != "") ? $this->input->post('salario_hora_noc') : null,
                'emp_usu_mod' => $this->tank_auth->get_user_id(),
                'emp_fecha_mod' => date('Y-m-d h:i:s'),
                'emp_codigo' => trim($this->input->post('codigo_emp')),
                'emp_afp' => $this->input->post('num_afp'),
                'emp_seguro' => $this->input->post('num_seg'),
                'emp_id_ban' => ($this->input->post('banco') != "") ? $this->input->post('banco') : null,
                'emp_numero_cuenta' => $this->input->post('cuenta_banco'),
                'emp_observacion_contrato' => trim($this->input->post('observacion_contratacion')),
                'emp_id_tic' => ($this->input->post('tipo_contrato_empleado') != "") ? $this->input->post('tipo_contrato_empleado') : null
            );

            $this->db->insert('emp_empleado', $nuevo);
            $emp_id = $this->db->insert_id();

            $tseg = $this->input->post('tipo_seguro');

            for ($i = 0; $i < count($tseg); $i++) {
                if ($tseg[$i] != null) {
                    $this->db->insert('sxe_seguroxempleado', array('sxe_id_seg' => $tseg[$i],
                        'sxe_id_emp' => $emp_id,
                        'sxe_estado' => 1,
                        'sxe_usu_mod' => $this->tank_auth->get_user_id(),
                        'sxe_fecha_mod' => date('Y-m-d H:i:s')
                    ));
                }
            }

            $tpl = $this->input->post('tipo_contrato');
            for ($i = 0; $i < count($tpl); $i++) {
                if ($tpl[$i] != null) {
                    $this->db->insert('txe_tipo_planillaxempleado', array('txe_id_tpl' => $tpl[$i], 'txe_id_emp' => $emp_id));
                }
            }


            $correos = $this->input->post('correo_empleado');
            for ($i = 0; $i < count($correos); $i++) {
                if ($correos[$i] != null and trim($correos[$i]) != '') {

                    $this->db->insert('cxp_correoxempleado', array('cxp_id_emp' => $emp_id,
                        'cxp_correo' => $correos[$i],
                        'cxp_estado' => 1,
                        'cxp_usu_mod' => $this->tank_auth->get_user_id(),
                        'cxp_fecha_mod' => date('Y-m-d H:i:s')
                    ));
                }
            }

            $array = $this->input->post('telefono');
            $ver = array_pop($array);
            $array_tit = $this->input->post('tipo_telefono');
            $ver_tit = array_pop($array_tit);
            $i = 0;
            foreach ($array as $key => $value) {
                if (trim($value) != "") {
                    $this->db->insert('tel_telefono', array(
                        'tel_numero' => $value,
                        'tel_id_tit' => $array_tit[$i]));

                    $tel_id = $this->db->insert_id();
                    $this->db->insert('txm_telefonoxempleado', array(
                        'txm_id_tel' => $tel_id,
                        'txm_id_emp' => $emp_id));
                }

                $i++;
            }


            $array2 = $this->input->post('numero_documento');
            //$ver2= array_pop($array2);
            $array2_1 = $this->input->post('documento');
            //$ver2_1 = array_pop($array2_1);
            $array_vence_doc = $this->input->post('vence_documento');
            $array_titulo_anexo = $this->input->post('titulo_anexo_doc');
            $array_nombre_anexo = $this->input->post('nombre_anexo_doc');
            $carpeta = $this->input->post("nombre_anexo_carpeta");

            $array_fexp_doc = $this->input->post('fecha_exp_doc');
            $array_lugarexp_doc = $this->input->post('lugar_exp_doc');

            $i = 0;
            foreach ($array2 as $key => $value2) {

                $titulo_a = trim($array_titulo_anexo[$i]);
                $url_anexo = "";
                $f_vence = (trim($array_vence_doc[$i]) != "" and $array_vence_doc[$i] != null ) ? date('Y-m-d', strtotime(trim($array_vence_doc[$i]))) : null;
                $f_exp = (trim($array_fexp_doc[$i]) != "" and $array_fexp_doc[$i] != null ) ? date('Y-m-d', strtotime(trim($array_fexp_doc[$i]))) : null;
                if ($titulo_a != "") {
                    $extencion = end(explode(".", $array_nombre_anexo[$i]));
                    //$url_anexo= "uploads/anexos_empleados/".trim($array_titulo_anexo[$i]).".".trim($extencion);
                    $url_anexo = trim($array_titulo_anexo[$i]) . "." . trim($extencion); //se modifico de esta manera porque se uso grocery para su edicion.
                    $this->datos_anexo_documento(trim($array_nombre_anexo[$i]), $carpeta, $titulo_a); //funcion para guardar el anexo
                }

                $this->db->insert('dce_documento_emp', array(
                    'dce_id_tde' => $array2_1[$i],
                    'dce_id_emp' => $emp_id,
                    'dce_valor' => $value2,
                    'dce_fecha_registro' => date('Y-m-d'),
                    'dce_fecha_vence' => $f_vence,
                    'dce_fecha_expedicion' => $f_exp,
                    'dce_lugar_expedicion' => trim($array_lugarexp_doc[$i]),
                    'dce_nombre_anexo' => $titulo_a,
                    'dce_url' => $url_anexo,
                    'dce_usu_mod' => $this->tank_auth->get_user_id(),
                    'dce_fecha_mod' => date('Y-m-d H:i:s')));
                //  $dce_id= $this->db->insert_id();
                //  $this->db->where('dce_id',$dce_id);
                //  $this->db->update('dce_documento_emp',array('dce_id_tde' => $array2_1[$i]));
                $i++;
            }



            $array3 = $this->input->post('familiar_nombre');
            $array3_1 = $this->input->post('familiar_apellido');
            $array3_2 = $this->input->post('familiar_tipo');
            $array3_3 = $this->input->post('familiar_telefono');
            $array3_4 = $this->input->post('familiar_naci');
            $array3_5 = $this->input->post('familiar_dependencia');
            $i = 0;
            foreach ($array3 as $key => $value3) {
                if ($value3 != "") {
                    $this->db->insert('fam_familiar', array(
                        'fam_nombre' => $value3,
                        'fam_apellido' => $array3_1[$i],
                        'fam_fecha_nacimiento' => (trim($array3_4[$i]) != "") ? date('Y-m-d', strtotime($array3_4[$i])) : null,
                        'fam_dependiente' => $array3_5[$i],
                        'fam_estado' => 1,
                        'fam_id_pat' => $array3_2[$i],
                        'fam_id_emp' => $emp_id,
                        'fam_telefono' => $array3_3[$i],
                        'fam_usu_mod' => $this->tank_auth->get_user_id(),
                        'fam_fecha_mod' => date('Y-m-d H:i:s')));
                }
                $i++;
            }

            $rutas = $this->input->post("ruta");
            $carpeta = $this->input->post("nombreCarpeta");

            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $this->input->post("titulo_doc" . $i);
                        $this->datos_imagen_gral_docente($img, $emp_id, $carpeta, $titulo);
                    }
                }
            }

            if ($this->input->post('foto_empleado') != "" and $this->input->post('titulo_foto_empleado') != "") { //guardar la foto del empleado
                $titulo = $this->input->post('titulo_foto_empleado');
                $img = $this->input->post('foto_empleado');
                $this->datos_imagen_gral_docente($img, $emp_id, $carpeta, $titulo, 1); //es de tipo foto
                //datos_imagen_gral_docente($img,$id_emp,$carpeta,$titulo_doc,$tipo=0)
            }

            $docente_array = array(
                'dct_id_emp' => $emp_id,
                'dct_estado' => 1,
                'dct_usu_crea' => $this->tank_auth->get_user_id(),
                'dct_fecha_crea' => date('Y-m-d H:i:s'),
                'dct_usu_mod' => $this->tank_auth->get_user_id(),
                'dct_fecha_mod' => date('Y-m-d H:i:s')
            );

            $this->gsatelite->ingresar('dct_docente', $docente_array);


            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de personal", 'texto_alerta' => "El registro se guardó correctamente");

            $this->session->set_flashdata($alerta);


            redirect('registro_academico/procesos/index_agregar_docente');
        }
    }

    public function mostrarMunicipio($value = '') {

        $id_depart = $this->input->post('idP');
        //die(print_r($id_depart,TRUE));
        $muni = $this->gsatelite->get_tabla('mun_municipio', array('mun_id_dep' => $id_depart));
        //die(print_r($muni,TRUE));



        if (!empty($muni)) {
            $cadena = "";

            foreach ($muni as $key => $value) {
                $cadena .= "<option value='" . $value['mun_id'] . "'>" . $value['mun_nombre'] . "</option>";
            }

            //die(print_r($cadena,true));
            echo json_encode(array('municipios' => $cadena));
        } else {


            echo json_encode(array('municipios' => "<option value='' >no existen municipios</option>"));
        }
    }
   

    /**
     * Inscripción de alumno
     * 
     * @author Mario Marquez;
     * @since 09/12/2015
     */
    public function inscripcion_alumno($alum_id = null, $lxa_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($alum_id != null && $lxa_id != null) {
                $where = array('lxp_alumnoxpensum.lxp_id_lxa' => $lxa_id);
                $inscripciones = $this->registro_academico_model->obtener_lxp_x_alumno($where);

                $data['inscripciones'] = $inscripciones;
                $data['alum_id'] = $alum_id;
                $data['lxa_id'] = $lxa_id;

                $where = array('alm_alumno.alm_id' => $alum_id);
                $alumno = $this->registro_academico_model->obtener_alumnos($where);
                $data['alumno'] = $alumno;

                $data['titulo_personal'] = "Inscripción de alumno";
                $this->_cargarvista($data);
            } else {
                redirect('registro_academico/procesos/gestion_alumnos');
            }
        }
    }

    public function inscribir_alumno($alum_id = null, $lxa_id = null) {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($alum_id != null && $lxa_id != null) {

                if ($_POST) {
                    $fac = $this->input->post('factura');
                    if ($fac == '') {
                        $fac = NULL;
                    }
                    $nivel_exist = (trim($this->input->post('nivel_exist')) == 0)?null:$this->input->post('niveles');

                    $lxp_array = array(
                        "lxp_id_lxa" => $this->input->post('lxa_id'),
                        "lxp_id_gra" => $this->input->post('grupo'),
                        "lxp_id_def" => $nivel_exist,
                        "lxp_fecha_inscripcion" => formatear_fecha('Y-m-d', $this->input->post('fecha_inscripcion')),
                        "lxp_condicion" => 1,
                        'lxp_exam_ubicacion' => $this->input->post('examen'),
                        "lxp_estado" => 1,
                        "lxp_usu_crea" => $this->tank_auth->get_user_id(),
                        "lxp_usu_mod" => $this->tank_auth->get_user_id(),
                        "lxp_fecha_crea" => date('Y-m-d h:i:s'),
                        "lxp_fecha_mod" => date('Y-m-d h:i:s'),
                        'lxp_id_fac' => $fac,
                    );

                    $id = $this->gsatelite->ingresar('lxp_alumnoxpensum', $lxp_array);

                    if ($id > 0) {
                        $alerta = array('registro' => $id, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la informacion ingresada.");
                    }

                    $this->session->set_flashdata($alerta);

                    redirect('registro_academico/procesos/inscripcion_alumno/' . $alum_id . '/' . $lxa_id);
                }

                $where = array('alm_alumno.alm_id' => $alum_id);
                $alumno = $this->registro_academico_model->obtener_alumnos($where);
                $data['alumno'] = $alumno; //Se muestran los datos del alumno

                $where_ard = array('lxa_alumnoxarea.lxa_id' => $lxa_id);
                $area = $this->registro_academico_model->obtener_areas_x_alumno($where_ard);
                $data['area'] = $area; //Muestra el area donde se esta

                $id_alum = $alum_id;
                /*$facturas_reg = $this->registro_academico_model->facturas_registradas($id_alum);
                //die(print_r($this->db->last_query()));
                $fac_reg = array();
                foreach ($facturas_reg as $fac) {
                    $fac_reg[] = $fac['fac_id'];
                }*/
                //$cat_inscripcion = $this->gsatelite->get_parametro('SYS_TIPO_ARTICULO'); //ya no se esta utilizando

                //Se obtienen las facturas del alumno
                $facturas = $this->registro_academico_model->obtener_facturas(array('alm_id'=>$id_alum, 'pen_id_ard'=>$area[0]['ard_id']),'fac_id');
                //die(print_r($this->db->last_query()));
                $factura_slc = "";
                $fac_temp = '-1';
                $mod_temp = '-1';
                foreach ($facturas as $key) { //recorremos las facturas del alumno
                    $condicion_array = array();
                    $condicion_array2 = array();
                    $condicion_array3 = array();
                    $contador = 0;
                    $contador2 = 0;
                    $contador3 = 0;
                   // die(print_r($key['condicion']));
                    $condiciones = explode(',', $key['condicion']); // separamos el campo condicion, que nos trae, cada registro separado por coma es un id del articulo y la condicion de este

                    $condicion_temp = '-1';
                    for ($x=0; $x < count($condiciones); $x++) { //recorremos las condiciones
                        $condicion_art = explode('-', $condiciones[$x]); //sepramos el id del articulo con la condicion
                        if($condicion_art[0] != $condicion_temp){ //nos crea el indice del arreglo
                            $condicion_array[$condicion_art[0]] = $condicion_art[1];
                            $condicion_temp = $condicion_art[0];
                        }
                        $condicion_array[$condicion_art[0]] = $condicion_art[1]; // sustituye el valor del indice hasta que quede el ultimo para verificar que estado viene
                    }
                    //print_r($condiciones);exit();die();
                    foreach ($condicion_array as $key2) { //recorremos el array creado para verificar si esta en curso o aprobada
                        if($key2 == 1 || $key2 == 2){
                            $contador++; //nos dara el resultado de 1 si esta en curso o aprobada
                        }
                    }

                    $modulos = explode(',', $key['id_mod']); //nos trae todos los modulos de la factura y lo almacenamos en un array
                    $condiciones2 = explode(',', $key['condicion2']); //separamos la cadena se ordena como articulo - condicion - modulo
                    $condicion_temp2 = '-1';
                    for ($x=0; $x < count($condiciones2); $x++) {
                        $condicion2_art = explode('-', $condiciones2[$x]);
                        if($condicion2_art[0] != $condicion_temp2){
                            $condicion_array2[$condicion2_art[0]] = array('condicion'=>$condicion2_art[1], 'modulo'=>$condicion2_art[2]); // Almacenamos la condicion y el modulo de los registros del alumno
                            $condicion_temp2 = $condicion2_art[0];
                        }
                        $condicion_array2[$condicion2_art[0]] = array('condicion'=>$condicion2_art[1], 'modulo'=>$condicion2_art[2]);
                        
                    }
                    /*print_r($modulos);
                    print_r($condicion_array2);*/
                    $condiciones3 = explode(',', $key['condicion3']); //separamos la cadena modulo - modulo requisito
                    $condicion_temp3 = '-1';
                    for ($x=0; $x < count($condiciones3); $x++) {
                        $condicion3_art = explode('-', $condiciones3[$x]);
                        if($condicion3_art[0] != $condicion_temp3){
                            $condicion_array3[$condicion3_art[0]] = array('requisito'=>$condicion3_art[1]); // guardamos el modulo como indice y el requisito como atributo
                            $condicion_temp3 = $condicion3_art[0];
                        }
                        $condicion_array3[$condicion3_art[0]] = array('requisito'=>$condicion3_art[1]);
                    }

                    foreach ($modulos as $key2) { //recorremos los modulos que trae la factura
                        $temp_estado = '';
                        $registros = $condicion_array3[$key2];
                        foreach ($condicion_array2 as $key3) { //recorremos los requisitos del modulo actual
                            if($key3['modulo'] == $registros['requisito']){
                                $temp_estado = $key3['condicion'];
                            } else if(trim($registros['requisito']) != ''){
                                $temp_estado = 3;
                            }
                        }

                        if($temp_estado == 2){
                            $contador2 = 1;
                        } else if(trim($temp_estado) == ''){
                            $contador2 = 1;
                        } else{
                            $contador2 = 0;
                        }

                        if($contador2 == 0){
                            $contador3++;
                        }
                        $temp_estado = '';
                    }
                    $error = 0;
                    if($contador3 == count($modulos)){
                        $error++;
                    }
                    if(!($contador+$contador3 == $key['products'])){
                        if($key['products'] != $contador && $error == 0 && ($key['lxp_condicion'] == '' || $key['lxp_condicion'] == 4 || $key['lxp_condicion'] == 3)){
                            $factura_slc .= '<option value="' . $key['fac_id'] . '" prue="'.$error.'" pru="'.$contador.'">' . $key['fac_numero'] . '</option>';
                        }
                    }
                }
                
                $data['facturas'] = $factura_slc;
               
                $becado = $this->registro_academico_model->obtener_becado($id_alum); //verifica si el alumno es becado
                $data['becado'] = $becado;

                $programas = $this->gsatelite->get_dropdown('prg_programa_estudio', '{prg_nombre}', '', array('prg_estado' => '1'), null, '', 'prg_id', true);
                $data["programas"] = str_replace('<option value=""></option>', '', $programas);

                $data['lxa_id'] = $lxa_id;

                $where = array('ard_area_academica.ard_id' => $area[0]['ard_id']);
                //$data['grupos'] = $this->registro_academico_model->get_GruposAcademicosxArea($where);

                $data['titulo_personal'] = "Inscribir alumno";
                $this->_cargarvista($data);
            }
        }
    }

    /**
     * @author Habby Lovo;
     * @since 14/09/2017
     */
    public function examen_ubicacion(){
        $alm_id = $this->input->post('alumno');
        $ard_id = $this->input->post('area');
        $tipo = $this->input->post('tipo');
        $beca = $this->input->post('beca');
        //$factura_reg = $this->registro_academico_model->obtener_facturas(array('alm_id'=>$alm_id, 'fac_id'=>$fac_id, 'pen_id_ard'=>$ard_id));
        $regresar = '<option value=""></option>';
        $complete = false; //si no hay registros se toma como falso
        if($beca == 1){
            $filtro = array('pen_id_ard'=>$ard_id);
            $alumno_reg = $this->registro_academico_model->obtener_det_alumns(array('lxa_id_ard'=>$ard_id, 'alm_id'=>$alm_id));
            $factura_reg = $this->registro_academico_model->obtener_niveles($filtro);
            if($tipo != 1){
                foreach ($factura_reg as $key) {
                    $cursando = 1;
                    if(count($alumno_reg) > 0){
                        foreach ($alumno_reg as $key1) {
                            if($key['mod_id'] == $key1['mod_id']){
                                if(!($key1['lxp_condicion'] == 1 || $key1['lxp_condicion'] == 2)){
                                    $cursando = 0;
                                }
                            }
                        }
                    } else{
                        $cursando = 0;
                    }
                    
                    if(trim($key['requisito']) != ""){
                        if(count($alumno_reg) > 0){
                            foreach ($alumno_reg as $key1) {
                                if($key['requisito'] == $key1['mod_id']){
                                    if(!($key1['lxp_condicion'] == 1 || $key1['lxp_condicion'] == 3 || $key1['lxp_condicion'] == 4)){
                                        $cursando = 0;
                                    }
                                }
                            }
                        } else{
                            $cursando = 1;
                        }
                    }
                    if($cursando != 1){
                        $complete = true;
                        $regresar .= '<option pro="'.$key['mod_id'].'" value="'.$key['mod_id'].'" tip="1">'.$key['mod_nombre'].'</option>';
                    }
                }
            } else{
                foreach ($factura_reg as $key) {
                    $materia_pasada = 0;
                    $materia_cursando = 0;
                    $materia_existente = 0;
                    $requisito_existente = 0;
                    $cursando = 1;
                    $no_mostrar = 0;
                    if(count($alumno_reg) > 0){
                        $materia_existente = 1;
                        foreach ($alumno_reg as $key1) {
                            if($key['mod_id'] == $key1['mod_id']){
                                if(!($key1['lxp_condicion'] == 1 || $key1['lxp_condicion'] == 2)){
                                    $cursando = 0;
                                }
                                if($key1['lxp_condicion'] == 2){
                                    $materia_pasada++;
                                }
                                if($key1['lxp_condicion'] == 1){
                                    $materia_cursando++;
                                }
                            }
                        }
                    } else{
                        $cursando = 0;
                    }

                    if($materia_existente == 1){
                        if($cursando == 1 && $materia_pasada > 0){ //no mostrarme la materia pasada
                            $no_mostrar = 1;
                        } else if($cursando == 1 && $materia_cursando > 0){
                            $no_mostrar = 1;
                        } else if($cursando == 1 && $materia_pasada == 0 && $materia_cursando == 0){
                            $no_mostrar = 0;
                        }
                    }
                    
                    if(trim($key['requisito']) != ""){
                        if(count($alumno_reg) > 0){
                            foreach ($alumno_reg as $key1) {
                                if($key['requisito'] == $key1['mod_id']){
                                    if(!($key1['lxp_condicion'] == 1 || $key1['lxp_condicion'] == 3 || $key1['lxp_condicion'] == 4)){
                                        $cursando = 0;
                                    }
                                    if($key1['lxp_condicion'] == 1){
                                        $requisito_existente++;
                                    }
                                }
                            }
                        } else{
                            $cursando = 1;
                        }
                    }

                    if($cursando != 0 && $requisito_existente > 0){
                        $no_mostrar = 1;
                    }
                    //echo $no_mostrar;
                    if($no_mostrar != 1){
                        $complete = true;
                        $regresar .= '<option pro="'.$key['mod_id'].'" value="'.$key['mod_id'].'" tip="1">'.$key['mod_nombre'].'</option>';
                    }
                }
            }
        } else{
            $facturas = $this->registro_academico_model->obtener_facturas(array('alm_id'=>$alm_id, 'pen_id_ard'=>$ard_id),'fac_id');
            $factura_slc = "";
            $fac_temp = '-1';
            $mod_temp = '-1';
            foreach ($facturas as $key) {
                $condicion_array = array();
                $condicion_array2 = array();
                $condicion_array3 = array();
                $contador = 0;
                $contador2 = 0;
                $contador3 = 0;
                $condiciones = explode(',', $key['condicion']);
                $condicion_temp = '-1';
                for ($x=0; $x < count($condiciones); $x++) {
                    $condicion_art = explode('-', $condiciones[$x]);
                    if($condicion_art[0] != $condicion_temp){
                        $condicion_array[$condicion_art[0]] = $condicion_art[1];
                        $condicion_temp = $condicion_art[0];
                    }
                    $condicion_array[$condicion_art[0]] = $condicion_art[1];
                }
                //print_r($condiciones);exit();die();
                foreach ($condicion_array as $key2) {
                    if($key2 == 1 || $key2 == 2){
                        $contador++;
                    }
                }

                $modulos = explode(',', $key['id_mod']);
                $condiciones2 = explode(',', $key['condicion2']);
                $condicion_temp2 = '-1';
                for ($x=0; $x < count($condiciones2); $x++) {
                    $condicion2_art = explode('-', $condiciones2[$x]);
                    if($condicion2_art[0] != $condicion_temp2){
                        $condicion_array2[$condicion2_art[0]] = array('condicion'=>$condicion2_art[1], 'modulo'=>$condicion2_art[2]);
                        $condicion_temp2 = $condicion2_art[0];
                    }
                    $condicion_array2[$condicion2_art[0]] = array('condicion'=>$condicion2_art[1], 'modulo'=>$condicion2_art[2]);
                    
                }
                /*print_r($modulos);
                print_r($condicion_array2);*/
                $condiciones3 = explode(',', $key['condicion3']);
                $condicion_temp3 = '-1';
                for ($x=0; $x < count($condiciones3); $x++) {
                    $condicion3_art = explode('-', $condiciones3[$x]);
                    if($condicion3_art[0] != $condicion_temp3){
                        $condicion_array3[$condicion3_art[0]] = array('requisito'=>$condicion3_art[1]);
                        $condicion_temp3 = $condicion3_art[0];
                    }
                    $condicion_array3[$condicion3_art[0]] = array('requisito'=>$condicion3_art[1]);
                }

                foreach ($modulos as $key2) {
                    $temp_estado = '';
                    $registros = $condicion_array3[$key2];
                    foreach ($condicion_array2 as $key3) {
                        if($key3['modulo'] == $registros['requisito']){
                            $temp_estado = $key3['condicion'];
                        } else if(trim($registros['requisito']) != ''){
                            $temp_estado = 3;
                        }
                    }

                    if($temp_estado == 2){
                        $contador2 = 1;
                    } else if(trim($temp_estado) == ''){
                        $contador2 = 1;
                    } else{
                        $contador2 = 0;
                    }

                    if($contador2 == 0){
                        $contador3++;
                    }
                    $temp_estado = '';
                }
                $error = 0;
                if($contador3 == count($modulos)){
                    $error++;
                }
                if(!($contador+$contador3 == $key['products']) || $tipo == 1){
                    if($tipo == 1){
                        if($key['products'] != $contador){
                            $complete = true;
                            $regresar .= '<option value="' . $key['fac_id'] . '">' . $key['fac_numero'] . '</option>';
                        }
                    } else{
                        if($key['products'] != $contador && $error == 0){
                            $complete = true;
                            $regresar .= '<option value="' . $key['fac_id'] . '">' . $key['fac_numero'] . '</option>';
                        }
                    }
                    
                }
            }
        }
        

        echo json_encode(array('complete'=>$complete,'select'=>$regresar));
    }

    public function mostrar_niveles(){
        //la funcion nos muestra los niveles filtrados por la factura, el tipo no aplica a becados
        $alm_id = $this->input->post('alumno'); //id de el alumno
        $fac_id = $this->input->post('factura'); //id de la factura
        $ard_id = $this->input->post('area'); //area academica

        $tipo = $this->input->post('tipo'); //si se activa el flag de examen
        $beca = $this->input->post('beca'); //si el alumno es becado = 1

        //die(print_r($_POST));
        $factura_reg = "";
        $complete = false; //si no hay registros se toma como falso
        $regresar = '<option value=""></option>';

        if($beca == 1){
            $filtro = array('pen_id_ard'=>$ard_id);
            $alumno_reg = $this->registro_academico_model->obtener_det_alumns(array('lxa_id_ard'=>$ard_id, 'alm_id'=>$alm_id)); //nos trae los registros del alumno, para saber si ya tiene antecedentes de los niveles inscritos
            $factura_reg = $this->registro_academico_model->obtener_niveles($filtro); //nos trae todos los niveles
            //print_r($factura_reg);die();
            foreach ($factura_reg as $key) {//recorremos los niveles relacionados con el area
                $cursando = 1; //se establece la variable como 1 para no mostrar el nivel
                if(count($alumno_reg) > 0){ //si no hay registros nos muestra la opcion del nivel
                    foreach ($alumno_reg as $key1) {
                        if($key['mod_id'] == $key1['mod_id']){
                            if(!($key1['lxp_condicion'] == 1 || $key1['lxp_condicion'] == 2)){
                                $cursando = 0;
                            }
                        }
                    }
                } else{
                    $cursando = 0;
                }
                //si el modulo tiene pre requisitos entraria a este if
                if(trim($key['requisito']) != ""){
                    if(count($alumno_reg) > 0){ //si no hay registros de alumnos y tiene requisitos no nos mostrara la opc
                        foreach ($alumno_reg as $key1) {
                            if($key['requisito'] == $key1['mod_id']){ //buscamos en los registros del alumno
                                if(!($key1['lxp_condicion'] == 1 || $key1['lxp_condicion'] == 3 || $key1['lxp_condicion'] == 4)){ //buscamos si ya paso el nivel
                                    $cursando = 0;
                                }
                            }
                        }
                    } else{ //si no hay registros no muestra la opc
                        $cursando = 1;
                    }
                }
                //si $cursado es 0 nos mostrara la opcion
                if($cursando != 1){
                    $regresar .= '<option pro="'.$key['mod_id'].'" value="'.$key['mod_id'].'" pen="'.$key['pen_id'].'" tip="1">'.$key['mod_nombre'].'</option>';
                }
            }
            
        } else{ //el caso que no sea becado
            $filtro = array('alm_id'=>$alm_id, 'fac_id'=>$fac_id, 'pen_id_ard'=>$ard_id);
            $factura_reg = $this->registro_academico_model->obtener_facturas($filtro,'def_id'); //nos trae los registros de la factura ligada con el alumno
            //die(print_r($factura_reg));
            //print_r($this->db->last_query());die();
            $where = array();
            $permit=0;
            foreach ($factura_reg as $key) {
                //se verifica si se esta Inscrito o aprobado, en caso que lo este no mostraria el niveles
                if(!($key['condicion'] == 1 || $key['condicion'] == 2)){ // si la condicion es 3 o 4 entraria aca si reprobo o la retiro
                        $where['lxa_id_ard'] = $key['ard_id'];
                        $where['lxa_id_alm'] = $key['alm_id'];
                        $where['mod_id'] = $key['condicion3'];
                        
                        $reg = $this->registro_academico_model->get_info_prerrequisito($where);
                            //die(print_r($reg));
                        if(!empty($reg) && $reg['lxp_condicion']!=2){
                            $permit=1;
                        }
               // die(print_r($key['condicion']));
                       //die(print_r($key['condicion3'].'/'.$permit));
                    if((trim($key['condicion3']) != '' && $permit==1) || (trim($key['condicion3']) == '' && $permit==1)){ //la condicion3 nos trae si tiene pre requisitos la materia y si ya se curso el requisito y si es asi nos muestra la opcion
                        if($key['condicion2'] == 2 || ($tipo == 1 && ($key['condicion2'] == 3 || $key['condicion2'] == 4 || $key['condicion2'] == ''))){ //si la condicion 2 es igual a 2, significa que ya paso el requisito para llevarla y se mostrara, si el flag de examen esta activo, nos muestra solo si la condicion tiene el estado 3 o 4
                            $regresar .= '<option pro="'.$key['mod_id'].'" value="'.$key['def_id'].'" pen="'.$key['pen_id'].'" tip="0">'.$key['mod_nombre'].'</option>';
                        }
                    } else{
                        //en el caso q no tenga requisito previo nos mostrara la opcion
                        $regresar .= '<option pro="'.$key['mod_id'].'" value="'.$key['def_id'].'" pen="'.$key['pen_id'].'" tip="0">'.$key['mod_nombre'].'</option>';
                    }
                }
            }
        }       
        //print_r($this->db->last_query());exit();die();
        if(count($factura_reg) > 0){
            $complete = true;
        }
        echo json_encode(array('complete'=>$complete,'select'=>$regresar));
    }
    //nos muestra los grupos dependiendo del nivel seleccionado, si el nivel no tiene grupo no mostraria grupo
    public function mostrar_grupos(){
        $mod_id = $this->input->post('nivel');
        $factura_reg = $this->registro_academico_model->obtener_grupo(array('mod_id'=>$mod_id));
        $regresar = '<option value=""></option>';
        $complete = false;
        //print_r($factura_reg);
        foreach ($factura_reg as $key) {
            if($key['cupo_rest'] != 0){
                $regresar .= '<option value="'.$key['gra_id'].'">'.$key['gra_nombre'].' ('.$key['cupo_rest'].')</option>';
            }
        }
        if(count($factura_reg) > 0){
            $complete = true;
        }
        echo json_encode(array('complete'=>$complete,'select'=>$regresar));
    }

    public function eliminar_inscripcion($lxp_id = null, $alm_id, $lxa_id) {
        if ($lxp_id != null) {
            $noa = $this->gsatelite->get_tabla('noa_nota_alumno', array('noa_id_lxp' => $lxp_id));


            if ($noa <= 0 || $noa == '') {
                $where = array('lxp_alumnoxpensum.lxp_id' => $lxp_id);
                $result = $this->gsatelite->borrado_general('lxp_alumnoxpensum', $where);
                if ($result > 0) {
                    $alerta = array('registro' => $result, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro eliminado", 'texto_alerta' => "El registro se ha eliminado correctamente.");
                }
            } else {

                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "NOTA", 'texto_alerta' => "El registro posee integridad referencial <br />&nbsp;No podrá ser eliminado. ");
            }
            $this->session->set_flashdata($alerta);
            redirect('registro_academico/procesos/inscripcion_alumno/' . $alm_id . '/' . $lxa_id);
        } else {
            redirect('registro_academico/procesos/inscripcion_alumno/' . $alm_id . '/' . $lxa_id);
        }
    }

    public function actualizar_inscripcion($lxp_id = null, $estado = null, $alm_id = null, $lxa_id = null) {
        
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['result'] = 0;
            if ($_POST) {
                $lxp_id = $this->input->post('lxp_id');
                $grado = $this->input->post('grado'); // Si se retira una materia perteneciente a un grado
            /********************* Retiro de materias individual o masivo *********************************/ 
                if($grado>0){ // Masivo
                    $materias = $this->registro_academico_model->get_materias_grado(array('grd_id'=>$grado));

                    if(count($materias)>0){
                        foreach ($materias as $key => $value) {      
                            $result = $this->efectuar_retiro_materias($_POST, $value['lxp_id']);
                        }
                        if($result>0){
                            $this->gsatelite->actualizar_array('gxa_gradoxalumno', array('gxa_estado_grado'=>3), array('gxa_id'=>$value['gxa_id']));
                        }
                    }
                }else{ // Individual
                    $result = $this->efectuar_retiro_materias($_POST);
                }
                $data['result'] = $result;
            }

            /////////////////////////////////////////////////////////////////////////////////////////////
            $where = array('alm_id' => $alm_id, 'lxp_id'=>$lxp_id, 'lxa_id'=>$lxa_id);
            $alumno = $this->registro_academico_model->obtener_alumnos($where);
            $data['alumno'] = $alumno;

            $grado=0;
            $nombre_grd = '';
            if(count($alumno)>0){
                $grado = $alumno[0]['gra_id_grd'];
                $nombre_grd = $this->gsatelite->get_campo('grd_grado', 'grd_nombre', array('grd_id'=>$grado));
            }

            $data['causas'] = $this->gsatelite->get_tabla('crt_causa_retiro', array('crt_estado' => 1));
            $data['lxp_id'] = $lxp_id;
            $data['estado'] = $estado;
            $data['alm_id'] = $alm_id;
            $data['lxa_id'] = $lxa_id;
            $data['grado'] = $grado;
            $data['nombre_grd'] = $nombre_grd;
           
            $iframe = $this->input->get('iframe');
            if ($iframe == 1) {
                $this->gsatelite->cargar_vista_masterpage('registro_academico/procesos/actualizar_inscripcion', $data);
            } else {
                $this->_cargarvista($data);
            }
        }
    }

    public function imprimir_inscripcion($lxp_id, $alm_id, $lxa_id) {

               $this->db->join('gra_grupo_academico', 'gra_id = lxp_id_gra');
        $reg = $this->gsatelite->get_registro('lxp_alumnoxpensum', array('lxp_id'=>$lxp_id));
        
        $grado = $reg->gra_id_grd;
        if($grado>0){
            $where = array('gra_id_grd'=>$grado);
        }else{
            $where = array('lxp_alumnoxpensum.lxp_id' => $lxp_id);
        }

        $inscripciones = $this->registro_academico_model->obtener_lxp_x_alumno($where);

        $this->db->order_by('fac_id', 'desc');
        $this->db->join('fac_factura', 'alm_id_cli=fac_id_cli', 'left');
        $data['factura'] = $this->gsatelite->get_tabla('alm_alumno', array('alm_id' => $alm_id, 'fac_id'=>$inscripciones[0]['lxp_id_fac']));
        $data['detalles'] = $this->registro_academico_model->get_frecuencias(); // Detalle de Frecuencia con Horarios
        $alumno = $this->gsatelite->get_tabla('alm_alumno', array('alm_id' => $alm_id, 'alm_estado'=>1));

        $au_id = $inscripciones[0]['gra_id_aul'];
        $aula = $this->gsatelite->get_tabla('aul_aula', array('aul_id' => $au_id));

        $data['frecuencias'] = $this->gsatelite->get_tabla('frh_frecuencia_horario', array('frh_estado'=>1));
        // print_r($au_id); die();
        $data['datos_alum'] = $alumno;
        $data['aula'] = $aula;
        $data['inscripciones'] = $inscripciones;
        $this->load->library('pdf');
        $html = $this->load->view('reporte/header', array('titulo' => 'Comprobante de inscripci&oacute;n', 'solotitulo' => true, 'subtitulo' => ''), true);
        $html .= $this->load->view('registro_academico/procesos/imprimir_inscripcion', $data, true);

        $this->pdf->makePDF($html, 'L');
    }

    function validar_cupos($gra_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $gra_id = $this->input->post('grupo');
                $id_grd = $this->input->post('grado');


                if($id_grd >0){
                              $this->db->limit(1);
                              $this->db->where('grd_id',$id_grd);
                              $this->db->join('grd_grado', 'gra_id_grd=grd_id', 'inner');
                    $grupo = $this->gsatelite->get_registro('gra_grupo_academico');
                    //die(print_r($grupo->gra_id));
                    $gra_id = $grupo->gra_id;
                }
            }

            $cupo = 0;

            $cupo_gra = $this->gsatelite->get_campo('gra_grupo_academico', 'gra_cupo', array('gra_id' => $gra_id));
            if($cupo_gra>0){
                $cupo=$cupo_gra;
            }else{
                $aula = $this->gsatelite->get_campo('gra_grupo_academico', 'gra_id_aul', array('gra_id' => $gra_id));
                if($aula) {
                    $cupo = $this->gsatelite->get_campo('aul_aula', 'aul_capacidad', array('aul_id' => $aula));
                }
                
            }

            $inscritos = $this->gsatelite->count('lxp_alumnoxpensum', array('lxp_id_gra' => $gra_id, 'lxp_condicion' => 1, 'lxp_tipo_inscripcion'=>1));
            $preinscritos = $this->gsatelite->count('lxp_alumnoxpensum', array('lxp_id_gra' => $gra_id, 'lxp_condicion' => 1, 'lxp_tipo_inscripcion'=>2));
           
            $total_ins = $inscritos + $preinscritos;

            if ($cupo <= $total_ins && $cupo != 0) {
                echo json_encode(
                        array('complete' => true, 'inscritos'=>$inscritos, 'preinscritos'=>$preinscritos)
                );
            } else {
                echo json_encode(
                        array('complete' => false)
                );
            }
        }
    }

    function obtener_grupos_inscripcion($ard_id = null, $lxa_id = null, $tipo = null) {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            if ($_POST) {
                $ard_id = $this->input->post('area');
                $lxa_id = $this->input->post('lxa');
                $tipo = $this->input->post('tipo');
            }


            if ($tipo != null && $tipo == "1") {
                //die(var_dump($tipo));
                $where = 'gra_id NOT IN 
                    (SELECT lxp_id_gra FROM lxp_alumnoxpensum AS lxp WHERE lxp_condicion IN 
                    (1,2) AND lxp_id_lxa =' . $lxa_id . ')
                    AND ard_id = ' . $ard_id . '';

                $grupos = $this->registro_academico_model->get_GruposAcademicosxArea($where, 1);
                echo $grupos;
                //var_dump($grupos);
            } else if ($tipo != null && $tipo == "2") {

                $where = array('ard_area_academica.ard_id' => $ard_id);
                $grupos = $this->registro_academico_model->get_GruposAcademicosxArea($where);
                $select = "<option value=''></option>";
                foreach ($grupos as $grupo) {
                    $gra_id = $grupo['gra_id'];

                    $contador = 0;

                    //$where = array('lxp_id_lxa'=>$lxa_id,'lxp_id_gra'=>$gra_id,'lxp_condicion <> '=>'2','lxp_alumnoxpensum.lxp_condicion <> '=>'1');
                    $where = 'lxp_id_lxa = ' . $lxa_id . ' AND lxp_id_gra =' . $gra_id . ' AND lxp_condicion IN(1,2)';
                    //var_dump($where);

                    $no_inscr = $this->gsatelite->count('lxp_alumnoxpensum', $where);
                    $where_pre = array('pen_pensum.pen_id' => $grupo['pen_id']);
                    $prerequisitos = $this->registro_academico_model->obtener_prerrequisitos($where_pre);

                    if (count($prerequisitos) > 0) {
                        foreach ($prerequisitos as $pre) {
                            $where_val = array('pen_pensum.pen_id_mod' => $pre['mod_id'], 'lxp_alumnoxpensum.lxp_id_lxa' => $lxa_id, 'lxp_alumnoxpensum.lxp_condicion' => 2);
                            $validar = $this->registro_academico_model->validar_prerrequisito($where_val);

                            if (!empty($validar) && count($validar) > 0) {
                                $contador ++;
                            }
                        }

                        if (count($prerequisitos) == $contador) {
                            $no_pre = 0;
                        } else {
                            $no_pre = 1;
                        }
                    } else {
                        $no_pre = 0;
                    }

                    if ($no_inscr == 0 && $no_pre == 0) {
                        $select .= "<option data-cupo='" . $grupo['gra_cupo'] . "' value='" . $grupo['gra_id'] . "'>" . $grupo['gra_nombre'] . "</option>";
                    }
                }

                echo $select;
            }
        }
    }

    /**
    * Descripción:
    * Cargar los detalles de alumnos para procesar notas.
    * @author Edith Herrera - Grupo Satélite
    * @since  29-11-2017
    * @param  Ninguno
    * @return Notas por alumno 
    */
    public function procesar_notas($rec=0, $proyeccion=null) {
        satelite_validar();
        $proy = $proyeccion;
        $permisos = $this->gsatelite->get_permisos_opcion();        
        if($_POST){
            $ard_id = $this->input->post('area');
            $gra_id = $this->input->post('grupo');
            $pev_id = $this->input->post('periodo');
            $noa_id = $this->input->post('nota');
            $rec = $this->input->post('valid');
            $proy = $this->input->post('proyeccion');

            $grupos = '';
            if ($ard_id > 0 && $gra_id > 0 && $pev_id > 0 && $noa_id >=0) {
            

                if($noa_id>0){
                    $where = 'gra_id = ' . $gra_id . ' AND gra_id_pyc ='.$proy.' AND lxa_id_ard = ' . $ard_id . ' AND pev_id = ' . $pev_id . ' AND evm_id = ' . $noa_id . '  AND  lxp_condicion NOT IN (4)';
                }else{
                    $where = 'gra_id = ' . $gra_id . ' AND gra_id_pyc ='.$proy.' AND lxa_id_ard = ' . $ard_id . ' AND pev_id = ' . $pev_id . '  AND  lxp_condicion NOT IN (4)';
                }

                //$data['detalles'] = $detalle = $this->registro_academico_model->get_AlumnosxGruposAcademicos($where);
                $data['alumnos'] = $alumnos = $this->registro_academico_model->get_AlumnosxGruposAcademicos($where, null, 'alm_id');

                $data['where']= $where;
                $data['ard_id'] = $ard_id;
                $data['gra_id'] = $gra_id;

                $fecha_ini = '';
                $feha_fin = '';
                $fecha_limite = '';
                $actual = date('d-m-Y');

                if(count($alumnos)>0){
                    $fecha_ini = formatear_fecha('d-m-Y', $alumnos[0]['evm_fecha_inicio']);
                    $fecha_fin = formatear_fecha('d-m-Y', $alumnos[0]['evm_fecha_fin']);
                    $fecha_limite = formatear_fecha('d-m-Y', $alumnos[0]['pyc_fecha_limite_nota']);
                    $fecha_max = formatear_fecha('d-m-Y', $alumnos[0]['evm_fecha_max_nota']);
                }

                $data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
                $html = $this->load->view('registro_academico/procesos/detalle_notas', $data, true);
               
                echo json_encode(array('html'=>$html, 'fecha_ini'=>$fecha_ini, 'fecha_fin'=>$fecha_fin, 'limite'=>$fecha_limite, 'actual'=>$actual, 'valida'=>$rec, 'maxima'=>$fecha_max));
            }
        }else{
            //$sucursal_str = $this->get_sucursales();   
            $otra_proyecc = array();        
            $user = $this->tank_auth->get_user_id();
            $emp  = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id' => $user));
            $dct  = $this->gsatelite->get_campo('dct_docente', 'dct_id', array('dct_id_emp' => $emp));
            $hoy  = date('Y-m-d');
            if($dct > 0){
                $this->db->where('gra_id_dct', $dct);
            } 
                $this->db->group_by('pyc_id');
                //$this->db->join('ard_area_academica','ard_id = pyc_id_ard');
                $this->db->join('gra_grupo_academico','gra_id_pyc = pyc_id');
            $proyeccion = $this->gsatelite->get_tabla('pyc_proyeccion', array('pyc_estado' => 1)); 

            $drop_proyeccion = '<option value=""></option>';
            if(count($proyeccion)>0){
                foreach ($proyeccion as $pyc ) {
                    $select = ($proy != null && $proy == $pyc['pyc_id']) ? 'selected="selected"' : '';
                    $drop_proyeccion .= '<option value="'.$pyc['pyc_id'].'"  '.$select.' >'.$pyc['pyc_nombre'].'</option>';
                    //data-ard="'.$pyc['ard_id'].'"
                    //data-area="'.$pyc['ard_nombre'].'"
                }
            }
            
            if($dct > 0){
                $sustitutos = $this->gsatelite->get_tabla('stm_sustituto_maestro', array('stm_id_dct_sustituto'=>$dct, 'DATE(stm_fecha_inicio) <='=>$hoy, 'DATE(stm_fecha_fin) >='=>$hoy)); 
                $otro_grado = implode(',', array_unique(array_column($sustitutos, 'stm_id_gra')));
                $otro_maest = implode(',', array_unique(array_column($sustitutos, 'stm_id_dct_titular')));
                if ($otro_grado != '' && $otro_maest != '') {
                    $where = array(
                        "gra_id IN ($otro_grado)" => NULL, 
                        "gra_id_dct IN ($otro_maest)" => NULL,
                        "pyc_id_suc in(".$sucursal_str.")" => NULL
                    );

                        $this->db->where($where);
                        $this->db->group_by('pyc_id');
                        //$this->db->join('ard_area_academica','ard_id = pyc_id_ard');
                        $this->db->join('gra_grupo_academico','gra_id_pyc = pyc_id');
                    $otra_proyecc = $this->gsatelite->get_tabla('pyc_proyeccion', array('pyc_estado' => 1));
                }
            }
            if (!(empty($otra_proyecc))){
                foreach ($otra_proyecc as $key => $value) {
                    $select = ($proy != null && $proy == $value['pyc_id']) ? 'selected="selected"' : '';
                    $drop_proyeccion .= '<option value="'.$value['pyc_id'].'" '.$select.' >'.$value['pyc_nombre'].'</option>';
                }
                //data-ard="'.$value['ard_id'].'"
                //data-area="'.$value['ard_nombre'].'"
            }
            $data["proyeccion"] = $drop_proyeccion;
            $data['pyc_id']     = $proy;
            $data['dct_id']     = ($dct!='')? $dct : '';
            $data['gra_id']     = '';
            $data['valid']      = $rec;
            $data['notas']      = $this->gsatelite->get_tabla('pod_ponderacion', array('pod_estado' => 1));
            $data['decimales']  = $this->gsatelite->get_parametro('NUMERO_DECIMALES');

            $data['titulo_personal'] = "Ingreso de notas";
            cargarvista($data, null, 'registro_academico/procesos/procesar_notas');
        }
    }

    public function cargar_GruposxAreaAcademica($proyeccion = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id = ($proyeccion != null) ? $proyeccion : $this->input->post('id');
            $dct = ($this->input->post('dct') != '') ? $this->input->post('dct') : '';
            $hoy = date('Y-m-d');
            $sustitutos = $this->gsatelite->get_tabla('stm_sustituto_maestro', array('stm_id_dct_sustituto'=>$dct, 'DATE(stm_fecha_inicio) <='=>$hoy, 'DATE(stm_fecha_fin) >='=>$hoy)); 
            $otro_maest = implode(',', array_unique(array_column($sustitutos, 'stm_id_dct_titular')));
            $where = array(
                'gra_id_pyc' => $id,
                'gra_finalizado IS NULL' => NULL,
                'gra_cerrado IS NULL' => NULL
            );
            if($dct > 0){
                $this->db->where('gra_id_dct',$dct);            
                if ($otro_maest != '') {
                    $this->db->or_where("gra_id_dct IN ($otro_maest)");
                }
            }
            $grupos = $this->registro_academico_model->get_GruposAcademicosxArea($where, 1);
            die(print_r($grupos));
            echo json_encode($grupos);
            die();
        }
    }

    public function guardar_notas($nota = null, $lxp_id = null, $nota_id = null, $pod_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $proyeccion = $this->input->post('slcProyeccion');
            $noa_lxp = ($lxp_id != null) ? $lxp_id : $this->input->post('id_lxp');
            $evm_id = ($evm_id != null) ? $evm_id : $this->input->post('id_evm');
            $noa = ($nota != null) ? $nota : $this->input->post('nota');

            $obser = ($obser != null) ? $obser : $this->input->post('txtObservacion');
            $promedio_final =  ($this->input->post('promedio_final')!='')?$this->input->post('promedio_final'): 0;
            $valid =($this->input->post('valid')>0)?$this->input->post('valid'):null; // cuando es una rectificación
            if ((array_sum($noa)>0) || ($noa_lxp != null && $noa_lxp != '')) {
                $notas = array();
                foreach ($noa_lxp as $key => $value) {

                    if($value>0){
                        $notas = $this->input->post('nota_'.$value);
                        $obser = $this->input->post('txtObservacion_'.$value);
                        $id_evm = $this->input->post('id_evm_'.$value);
                        $noa_id = $this->input->post('id_noa_'.$value);

                        foreach ($notas as $not => $valor) {
                            $prueba = $valor;
                            $reg_nota=$this->gsatelite->get_tabla('noa_nota_alumno', array('noa_id'=>$noa_id[$not]));
                           
                            //die(print_r($noa_id[$not].'/'.$reg_nota[0]['noa_id_evm'].'/'.$id_evm[$not]));
                            if($noa_id[$not]>0 && $reg_nota[0]['noa_id_evm']==$id_evm[$not]){
                                /*********************** Actualización de notas ********************************/
                                $nota_array = array(
                                    'noa_id_lxp' =>$value,
                                    'noa_id_evm' => $id_evm[$not],
                                    'noa_nota' => $valor,
                                    'noa_observacion' => ($obser[$not]!='')?$obser[$not]:null,
                                    'noa_estado' => 1,
                                    'noa_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'noa_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                $id = $this->gsatelite->actualizar_array('noa_nota_alumno', $nota_array, array('noa_id'=>$noa_id[$not]));
                            }else if(!empty($valor) && ($valor>0||$obser[$not]!='') && $noa_id[$not]<=0){ /*    PARCHE TEMPORAL    */
                                
                                /************************* Ingreso de notas **********************************/
                                $nota_array = array(
                                        'noa_id_lxp' =>$value,
                                        'noa_id_evm' => $id_evm[$not],
                                        'noa_nota' => ($valor > 0) ? $valor : ((is_numeric($obser[$not])) ? $obser[$not] : 0),/*    PARCHE TEMPORAL    */
                                        'noa_observacion' => (false && $obser[$not]!='')?$obser[$not]:null,
                                        'noa_estado' => 1,
                                        'noa_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'noa_fecha_creacion' => date('Y-m-d H:m:s'),
                                        'noa_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'noa_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                   
                                $id = $this->gsatelite->ingresar('noa_nota_alumno', $nota_array);
                                
                            }
                        }

                         $lxp_array = array(
                                'lxp_promedio' =>$promedio_final[$key],
                                'lxp_usu_mod'  => $this->tank_auth->get_user_id(),
                                'lxp_fecha_mod' => date('Y-m-d H:i:s')
                            );

                            $lxp = $this->gsatelite->actualizar_array('lxp_alumnoxpensum', $lxp_array, array('lxp_id'=>$noa_lxp[$key]));

                       
                    } // verifica lxp
                } // End foreach
           

                    if($id>0){
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesamiento de notas", 'texto_alerta' => "La información fue procesada correctamente.");
                    }else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Procesamiento de notas", 'texto_alerta' => "Las información no pudo ser procesada, intente de nuevo.");
                    }

                    // ************************* Proceso de finalización de grupo ********************************//
                    if($valid!=null){
                        $grupo = $this->gsatelite->get_campo('lxp_alumnoxpensum', 'lxp_id_gra', array('lxp_id'=> $noa_lxp[0])); // grupo anterior

                        $cerrado = $this->gsatelite->get_campo('gra_grupo_academico', 'gra_cerrado', array('gra_id'=> $grupo));
                        if($cerrado==1){
                            $data_grupo = $this->cargar_info_grupo($grupo); // Obtener información del grupo
                            $grado = $data_grupo['grd_id']; 

                            $pen_id = $this->gsatelite->get_campo('gra_grupo_academico', 'gra_id_pen', array('gra_id'=> $grupo));
                            $pensum = $this->gsatelite->get_tabla('pen_pensum', array('pen_id'=>$pen_id));
                            $siguiente = $this->registro_academico_model->get_info_siguientenivel(array('pre_id_mod'=>$pensum[0]['pen_id_mod'])); // Debe existir un grupo para el siguiente nivel.
                            $siguiente_pen = $siguiente[0]['pen_id'];
                            
                            $info_grupo = $this->gsatelite->get_registro('gra_grupo_academico', array('gra_id_pen'=>$siguiente_pen));
                           
                            $siguiente_gra = $info_grupo->gra_id; // Grupo a inscribir 
                            $proyeccion = $info_grupo->gra_id_pyc; // Debe ser la proyecci[on del nuevo grupo

                            $this->procesar_fin_grupo($proyeccion, $siguiente_gra, $grupo, $grado, 1);
                        }  
                    }

                    $this->session->set_flashdata($alerta);
                    if($valid!=null){
                        if($proyeccion>0){
                            redirect('registro_academico/procesos/rectificacion_notas/'.$proyeccion);
                        }else{
                            redirect('registro_academico/procesos/rectificacion_notas');
                        }
                    }else{
                        if($proyeccion>0){
                            redirect('registro_academico/procesos/procesar_notas/0/'.$proyeccion);
                        }else{
                            redirect('registro_academico/procesos/procesar_notas');
                        }
                    }
            }
        }
    }

    public function obtener_promedio($lxp_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if (isset($_POST['lxp_id_alm'])) {
                $lxp_id = $this->input->post('lxp_id_alm');
            }

            $where_nota = array('noa_nota_alumno.noa_id_lxp' => $lxp_id);

            $notas = $this->registro_academico_model->get_NotasxAlumno($where_nota);
            $promedio = 0;
            if (count($notas) > 0) {
                foreach ($notas as $noa) {
                    $promedio += $noa['noa_nota'] * $noa['pod_ponderacion'];
                }
            }
            if ($promedio >= 6.5 && $promedio <= 6.9) {
                $promedio = 7.0;
            } else {
                
            }

            if (isset($_POST['lxp_id_alm'])) {
                echo $promedio;
            } else {
                return $promedio;
            }
        }
    }

    //CALLBACKS

    function _fecha_inscripcion($value, $row) {
        $date = new DateTime($value);

        return '<div>' . $date->format('d/m/Y') . '</div>';
    }

    public function check_documento_alumno($tipo = 1) {
        if ($tipo == 1) {
            if ($this->input->post('doc') != null && $this->input->post('doc') != "") {
                $result = $this->gsatelite->get_tabla('dce_documento_alm', array('dce_valor' => $this->input->post('doc')
                    , 'dce_id_tde' => $this->input->post('Tdoc')));

                if (count($result) > 0) {
                    print json_encode(
                                    array('exists' => true)
                    );
                } else {
                    print json_encode(
                                    array('exists' => false)
                    );
                }
            }
        } elseif ($tipo == 2) {
            if ($this->input->post('cod') != null and $this->input->post('cod') != "") {
                $result = $this->gsatelite->get_tabla('emp_empleado', array('emp_codigo' => $this->input->post('cod')));

                if (count($result) > 0) {
                    print json_encode(
                                    array('exists' => true)
                    );
                } else {
                    print json_encode(
                                    array('exists' => false)
                    );
                }
            }
        }
    }

    function check_documento_unico() {
        $tipo_documento = $this->input->post('tipo');
        $documento = $this->input->post('documento');
        $alm_id = $this->input->post('editar');
        if ($alm_id != null) {
            $resultado = $this->gsatelite->get_tabla('dca_documento_alumno', array('dca_id_tde' => $tipo_documento, 'dca_valor' => $documento, 'dca_id_alm' => $alm_id));
            if (count($resultado) > 0) {
                $resultado = array();
            } else {
                $resultado = $this->gsatelite->get_tabla('dca_documento_alumno', array('dca_id_tde' => $tipo_documento, 'dca_valor' => $documento));
            }
        } else {
            $resultado = $this->gsatelite->get_tabla('dca_documento_alumno', array('dca_id_tde' => $tipo_documento, 'dca_valor' => $documento));
        }


        echo count($resultado);
    }

    public function check_codigo_alumno($cod = null, $alm_id = 0) {

        if ($_POST) {
            $cod = $this->input->post('codigo');
            $alm_id = $this->input->post('alm_id');
        }

        if ($cod != '' && $cod != null) {

            if ($alm_id != 0) {
                $result = $this->gsatelite->get_tabla('alm_alumno', array('alm_codigo' => $cod, 'alm_id <>' => $alm_id));
            } else {
                $result = $this->gsatelite->get_tabla('alm_alumno', array('alm_codigo' => $cod));
            }

            if (count($result) > 0) {
                print json_encode(
                                array('exists' => true)
                );
            } else {
                print json_encode(
                                array('exists' => false)
                );
            }
        }
    }

    /**
     * @author Edith Herrera
     * @since  2017-10-27
     * @return Valida que el registro de proyección sea único.
    * */
    function gestion_grupos() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            if ($_POST) {
                $area = $this->input->post('area');
                $nivel = $this->input->post('nivel');
                $frecuencia = $this->input->post('frecuencia');
                $fecha = $this->input->post('fecha');
                $proyeccion = $this->input->post('proyeccion');

                $where = array();
                if ($area != '') {
                    $where['ard_id'] = $area;
                }
                if ($nivel != '') {
                    $where['mod_id'] = $nivel;
                }
                if ($frecuencia != '') {
                    $where['frh_id'] = $frecuencia;
                }
                if ($fecha != '') {
                    $where['gra_fecha_inicio'] = $fecha;
                }
                if ($proyeccion != '') {
                    $where['pyc_id'] = $proyeccion;
                }
          
                $data['grupos'] = $this->registro_academico_model->obtener_grupos($where);
                $html = $this->load->view('registro_academico/procesos/detalle_grupos', $data, true);
                
                echo $html;
            } else {
                
                $sucursal_str = $this->get_sucursales();                          
                //$where['gra_id_suc in('.$sucursal_str.')'] = NULL;
                $data['grupos'] = array();//$this->registro_academico_model->obtener_grupos();

                $sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_estado'=>1,'usc_id_usu'=>$this->tank_auth->get_user_id()));

                $where = (count($sucursal) > 0) ? 'ard_estado = 1 AND (ard_id_suc IS NULL OR ard_id_suc = '.$sucursal[0]['usc_id_suc'].')': 'ard_estado = 1';

                $select = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', $where, null, '', 'ard_id', true);    
                $data["areas"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                //$this->db->where('pyc_id_suc in('.$sucursal_str.')',NULL);
                $proyeccion = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);
                $proyeccion = str_replace('<option value="0">Sin Registros</option>', '', $proyeccion);
                $data["proyeccion"] = str_replace('<option value="0">Seleccione</option>', '', $proyeccion);

                $select = $this->gsatelite->get_dropdown('mod_modulo', '{mod_nombre}', '', array('mod_estado' => 1), null, '', 'mod_id', true);
                $data["nivel"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                $frecuencia = $this->gsatelite->get_dropdown('frh_frecuencia_horario', '{frh_nombre}', '', array('frh_estado' => 1), null, '', 'frh_id', true);
                $data["frecuencia"] = str_replace('<option value="0">Seleccione</option>', '', $frecuencia);

                $data['titulo_personal'] = "Grupos Académicos";

                $this->_cargarvista($data);
            }
        }
    }

    function agregar_grupo($pyc_id=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $post_array = $this->input->post();
                $area = ($post_array['slcArea']>0) ? $post_array['slcArea'] : (($post_array['txtSelArea'] > 0) ? $post_array['txtSelArea'] : null);
                $proyeccion = ($post_array['slcProyeccion']>0) ? $post_array['slcProyeccion'] : null;
                $pyc_id = ($post_array['pyc_id']>0) ? $post_array['pyc_id'] : null;
                $sucursal =  $this->tank_auth->get_sucursal_id();
                // print_r($post_array);die();
                $grupos_academicos = array(
                    'gra_id_suc' => ($sucursal > 0) ? $sucursal : null,
                    'gra_id_aul' => ($post_array['slcAula']>0) ? $post_array['slcAula'] : null,
                    'gra_id_dct' => ($post_array['slcDocente']>0) ? $post_array['slcDocente'] : null,
                    'gra_id_ard' =>  $area,
                    'gra_id_frh' => ($post_array['slcFrecuencia']>0) ? $post_array['slcFrecuencia'] : null,
                    'gra_id_pyc' => ($pyc_id > 0) ? $pyc_id : $proyeccion,
                    'gra_id_scc' => ($post_array['slcSeccion'] > 0) ? $post_array['slcSeccion'] : null,
                    'gra_id_sug' => ($post_array['slcSupervisor'] > 0) ? $post_array['slcSupervisor'] : null,
                    'gra_id_pen' => ($post_array['slcNivel'] > 0) ? $post_array['slcNivel'] : null,
                    'gra_id_grd' => ($post_array['slcGrado'] > 0) ? $post_array['slcGrado'] : null,
                    'gra_nombre' => $post_array['txtNombre'],
                    'gra_fecha_inicio' => formatear_fecha('Y-m-d', $post_array['txtFecha_ini']),
                    'gra_fecha_fin' => formatear_fecha('Y-m-d', $post_array['txtFecha_fin']),
                    'gra_cupo' => ($post_array['txtCupoMax']!='')?$post_array['txtCupoMax']:null,
                    'gra_cupo_minimo' => ($post_array['txtCupoMin']!='')?$post_array['txtCupoMin']:null,
                    'gra_pluriclase' => ($post_array['txtpluriclase']!='')?$post_array['txtpluriclase']:null,
                    'gra_estado' => 1,
                    'gra_usu_crea' => $this->tank_auth->get_user_id(),
                    'gra_usu_mod' => $this->tank_auth->get_user_id(),
                    'gra_fecha_crea' => date('Y-m-d H:i:s'),
                    'gra_fecha_mod' => date('Y-m-d H:i:s')
                );
                //die(print_r($grupos_academicos));
                
                $registro = $this->gsatelite->ingresar('gra_grupo_academico', $grupos_academicos);
            
                if ($registro > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la informacion ingresada.");
                }

                $this->session->set_flashdata($alerta);
                $boton = $this->input->post('direccion');
        
                if ($boton == 1) {
                    if($pyc_id > 0){
                        redirect('registro_academico/procesos/agregar_grupo/'.$pyc_id);
                    }else{
                        redirect('registro_academico/procesos/agregar_grupo');
                    }
                } else if ($boton == 2) {
                    if($pyc_id > 0){
                        redirect('registro_academico/mantenimientos/proyecciones');
                    }else{
                        redirect('registro_academico/procesos/gestion_grupos');
                    }
                }
            } else {

                if($pyc_id!=null){
                    //$sucursal_str   = $this->get_sucursales();                          
                    //$this->db->where('pyc_id_suc in('.$sucursal_str.')',NULL);
                    $proyeccion     = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1, 'pyc_id'=>$pyc_id), $pyc_id, '', 'pyc_id', true);
                    $proyeccion     = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $proyeccion);
                    $data["proyeccion"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $proyeccion);
                    $data['reg_pyc']    = $this->gsatelite->get_registro('pyc_proyeccion', array('pyc_id'=>$pyc_id));

                }else{
                    //$sucursal_str   = $this->get_sucursales();                          
                    //$this->db->where('pyc_id_suc in('.$sucursal_str.')',NULL);
                    $proyeccion     = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);
                    $proyeccion     = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $proyeccion);
                    $data["proyeccion"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $proyeccion);
                }


               /* $programas = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => '1'), null, '', 'ard_id', true);
                $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $programas);*/

                $programas = $this->gsatelite->get_dropdown('mod_modulo', '{mod_nombre}', '', array('mod_estado' => '1'), null, '', 'mod_id', true);
                $programas = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $programas);
                $data["modulos"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $programas);
                
                $frecuencia = $this->gsatelite->get_dropdown('frh_frecuencia_horario', '{frh_nombre}', '', array('frh_estado' => 1), null, '', 'frh_id', true);
                $data["frecuencia"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $frecuencia);
                
                $aulas = $this->gsatelite->get_dropdown('aul_aula', '{aul_nombre}', '', array('aul_estado' => '1'), null, '', 'aul_id', true);
                $data["aulas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $aulas);

                $data["docentes"] = $this->registro_academico_model->obtener_docentes(array('dct_estado' => '1'));

                $aulas = $this->gsatelite->get_dropdown('scc_seccion', '{scc_nombre}', '', array('scc_estado' => '1'), null, '', 'scc_id', true);
                $data["secciones"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $aulas);

                $this->db->join('emp_empleado', 'emp_id=sug_id_emp');
                $data['supervisores'] = $this->gsatelite->get_tabla('sug_supervisor_grupo', array('sug_estado'=>1));

                $data['pyc_id'] = $pyc_id;


                $data["titulo_personal"] = "Grupos académicos";

                //Incluir sucursales
                $sucursal = $this->tank_auth->get_sucursal_id();
                if (is_null($sucursal) || count($sucursal) == 0 || $sucursal == false) {//SI NO EXISTE EL PARAMETRO O NO ESTA BIEN CONFIURADO ABORTAR OPERACION
                    $usuario_sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_estado'=>1,'usc_id_usu'=>$this->tank_auth->get_user_id()));
                    if(count($usuario_sucursal) > 0) {
                        $this->_cargarvista($data);
                    } else {
                        $url = 'registro_academico/procesos/gestion_grupos';
                        $this->gsatelite->show_dialog('Verifique que su usuario tenga sucursal', $url, 'error', 'Error de Parámetro');
                    }
                } else {
                    $this->_cargarvista($data);
                }
            }
        }
    }


      function editar_grupo($gra_id=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
               // print_r($_POST); die();
                $post_array = $this->input->post();
                $gra_id = $post_array['gra_id'];

                $area = ($post_array['slcArea']>0) ? $post_array['slcArea'] : (($post_array['txtSelArea'] > 0) ? $post_array['txtSelArea'] : null);
                $estado = ($post_array['estado']!='') ? $post_array['estado'] : 1;

                $grupos_academicos = array(
                    'gra_id_aul' => ($post_array['slcAula']>0) ? $post_array['slcAula'] : null,
                    'gra_id_dct' => ($post_array['slcDocente']>0) ? $post_array['slcDocente'] : null,
                    'gra_id_ard' =>  $area,
                    'gra_id_frh' => ($post_array['slcFrecuencia']>0) ? $post_array['slcFrecuencia'] : null,
                    'gra_id_pyc' => ($post_array['slcProyeccion']>0) ? $post_array['slcProyeccion'] : null,
                    'gra_id_scc' => ($post_array['slcSeccion']>0) ? $post_array['slcSeccion'] : null,
                    'gra_id_sug' => ($post_array['slcSupervisor']>0) ? $post_array['slcSupervisor'] : null,
                    'gra_id_pen' => ($post_array['slcNivel']>0) ? $post_array['slcNivel'] : null,
                    'gra_id_grd' => ($post_array['slcGrado']>0) ? $post_array['slcGrado'] : null,
                    'gra_nombre' => $post_array['txtNombre'],
                    'gra_fecha_inicio' => formatear_fecha('Y-m-d', $post_array['txtFecha_ini']),
                    'gra_fecha_fin' => formatear_fecha('Y-m-d', $post_array['txtFecha_fin']),
                    'gra_cupo' => ($post_array['txtCupoMax']!='')?$post_array['txtCupoMax']:null,
                    'gra_cupo_minimo' => ($post_array['txtCupoMin']!='')?$post_array['txtCupoMin']:null,
                    'gra_estado' => $estado,
                    'gra_usu_crea' => $this->tank_auth->get_user_id(),
                    'gra_usu_mod' => $this->tank_auth->get_user_id(),
                    'gra_fecha_crea' => date('Y-m-d H:i:s'),
                    'gra_fecha_mod' => date('Y-m-d H:i:s')
                   
                );
              
                $registro = $this->gsatelite->actualizar_array('gra_grupo_academico', $grupos_academicos, array('gra_id'=>$gra_id));

                $boton = $this->input->post('direccion');
                if( $registro > 0 ){
                    $alerta['registroProcesado'] = 1;
                    if($boton == 1){ $alerta['direccion'] = 1; }else{ $alerta['direccion'] = 2;}
                    $this->session->set_flashdata($alerta);
                }

                    redirect('registro_academico/procesos/editar_grupo/'.$gra_id);
            } else {
                $sucursal_str = $this->get_sucursales(); 
                // $where['gra_id_suc in('.$sucursal_str.')'] = NULL;
                $where['gra_id']= $gra_id;
                $grupo = $this->registro_academico_model->obtener_grupos($where);
                $data['grupo']  = $grupo[0];
                $pyc = $grupo[0]['gra_id_pyc'];

                // $this->db->where('pyc_id_suc in('.$sucursal_str.')', NULL);
                $proyeccion     = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), $grupo[0]['gra_id_pyc'], '', 'pyc_id', true);
                $data["proyeccion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $proyeccion);

                $programas = $this->gsatelite->get_dropdown("ard_area_academica", "{ard_nombre}", "", array('ard_estado'=>1), $grupo[0]['gra_id_ard'], null, 'ard_id', true);
                $data["areas"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $programas);
                // var_dump($data['grupo']);die();
                
                $where_md = array('ard_id' => $grupo[0]['ard_id']);
                $pensum = $this->registro_academico_model->obtener_pensum_x_ard($where_md, $grupo[0]['gra_id_pen']);
                $data['modulos'] = $pensum;    

                $frecuencia = $this->gsatelite->get_dropdown('frh_frecuencia_horario', '{frh_nombre}', '', array('frh_estado' => 1,'frh_id'=>$grupo[0]['gra_id_frh']), $grupo[0]['gra_id_frh'], '', 'frh_id', true);
                $data["frecuencia"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $frecuencia);
                
                $aulas = $this->gsatelite->get_dropdown('aul_aula', '{aul_nombre}', '', array('aul_estado' =>1), $grupo[0]['gra_id_aul'], '', 'aul_id', true);
                $data["aulas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $aulas);

                $secciones = $this->gsatelite->get_dropdown('scc_seccion', '{scc_nombre}', '', array('scc_estado' => '1'), $grupo[0]['gra_id_scc'], '', 'scc_id', true);
                $data["secciones"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $secciones);

                //$where2['gra_id_suc in('.$sucursal_str.')'] = NULL;
                $where2['dct_estado'] = 1;
                $docentes   = $this->registro_academico_model->obtener_docentes($where2);
                $option_dct = '<option value=""></option>';
                if(count($docentes)>0){
                  
                    foreach ($docentes as $dct) {
                        if($dct['dct_id']==$grupo[0]['gra_id_dct']){ $select = 'selected="selected"'; }else{ $select=''; }
                        $option_dct .= '<option value="'.$dct['dct_id'].'" '.$select.' >'.$dct['emp_nombre'].' '.$dct['emp_apellido'].'</option>';
                       
                    }
                }
                $data["docentes"] = $option_dct;
                
                $data['cant_alumnos'] = $this->gsatelite->count('lxp_alumnoxpensum', array('lxp_condicion'=>1, 'lxp_id_gra'=>$gra_id));


                $this->db->join('emp_empleado', 'emp_id=sug_id_emp');
                $data['supervisores'] = $this->gsatelite->get_tabla('sug_supervisor_grupo', array('sug_estado'=>1));

                $data['registro'] = $frecuencia = $this->registro_academico_model->get_frecuencias(array('dfr_id_frh'=>$grupo[0]['gra_id_frh']));
                $html = $this->load->view('registro_academico/procesos/detalle_frecuencia', $data, true);
                $data['detalle'] = $html;

                $data['reg_pyc'] = $this->gsatelite->get_registro('pyc_proyeccion', array('pyc_id'=>$grupo[0]['gra_id_pyc']));
                $data['pyc_id'] = $grupo[0]['gra_id_pyc'];

                $data['gra_id']= $gra_id;

                $grados = $this->gsatelite->get_dropdown('grd_grado', '{grd_nombre}', '', array('grd_estado' => '1'), $grupo[0]['gra_id_grd'], '', 'grd_id', true);
                $data["grados"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $grados);

                $data["titulo_personal"] = "Grupos académicos";

                $this->gsatelite->cargar_vista_masterpage('registro_academico/procesos/editar_grupo', $data, true);
            }
        }
    }


    function get_subareas(){
        satelite_validar(true);

        $area = $this->input->post('area');

        $select = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1, 'ard_id_ard_padre'=>$area), null, '', 'ard_id', true);
        $subareas = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

        echo json_encode($subareas);
    }

    function get_detalles_frecuencia(){
        satelite_validar(true);
        $id_frh = $this->input->post('frecuencia');
        $data['registro'] = $frecuencia = $this->registro_academico_model->get_frecuencias(array('dfr_id_frh' => $id_frh, 'dfr_estado' => 1));
        $html = $this->load->view('registro_academico/procesos/detalle_frecuencia', $data, true);
        echo json_encode($html);
    }

    function get_info_proyeccion(){
        satelite_validar(true);

        $id_pyc = $this->input->post('proyeccion');
        $id_alm = $this->input->post('alumno');
        $es_inscripcion_alumno = $this->input->post('flag_inscripcion');
        $ardslctd = ($this->input->post('grupo_acad') > 0) ? $this->input->post('grupo_acad') : null;
        $proyeccion = $this->gsatelite->get_registro('pyc_proyeccion', array('pyc_id'=>$id_pyc));
        $alumno = $this->gsatelite->get_tabla("alm_alumno", array("alm_id" => $id_alm));

        $edad = null;

        $sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_estado'=>1,'usc_id_usu'=>$this->tank_auth->get_user_id()));

        $where = (count($sucursal) > 0) ? 'ard_estado = 1 AND (pyc_id = '.$id_pyc.' OR axy_id_pyc = '.$id_pyc.') AND (ard_id_suc IS NULL OR ard_id_suc = '.$sucursal[0]['usc_id_suc'].')': 'ard_estado = 1 AND (pyc_id = '.$id_pyc.' OR axy_id_pyc = '.$id_pyc.')';

        if($es_inscripcion_alumno) {
            if(isset($alumno[0]['alm_fecha_nacimiento'])) {
                $fec_n = explode('-', $alumno[0]['alm_fecha_nacimiento']);
                $year_ac = date('Y');
                $mes_ac = date('m');
                $day_ac = date('d');
                if ($fec_n[1] == $mes_ac && $fec_n[2] > $day_ac) {
                    $year_ac = $year_ac - 1;
                }
                if ($fec_n[1] > $mes_ac) {
                    $year_ac = $year_ac - 1;
                }
                $edad = ($year_ac - $fec_n[0]);
            }

            if ($edad !== null) {
                $this->db->where("(
                    ($edad >= ard_edad_minima AND $edad <= ard_edad_maxima) OR
                    ($edad >= ard_edad_minima AND ard_edad_maxima IS NULL) OR
                    (ard_edad_minima IS NULL AND  $edad <= ard_edad_maxima) OR
                    (ard_edad_minima IS NULL AND ard_edad_maxima IS NULL)
                )");
            }
        }

            $this->db->join('pyc_proyeccion', 'pyc_id_ard=ard_id', 'LEFT');
            $this->db->join('axy_areas_x_proyecion', 'axy_id_ard = ard_id', 'LEFT');
            $this->db->group_by('ard_id');
        $programas = $this->gsatelite->get_dropdown("ard_area_academica", "{ard_nombre}", "", $where, $ardslctd, '', 'ard_id', true);
        $areas = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $programas);
        $fecha_actual = strtotime(date('Y-m-d'));
        $fecha_maxima_inscripcion = ($proyeccion->pyc_fecha_maxima_inscripcion != "") ? strtotime($proyeccion->pyc_fecha_maxima_inscripcion) : strtotime($proyeccion->pyc_fecha_fin);
        $flag_no_cumple_max_inscripcion = ($fecha_actual > $fecha_maxima_inscripcion) ? true : false;

        echo json_encode(array(
            'inicio' => formatear_fecha('d-m-Y', $proyeccion->pyc_fecha_inicio), 
            'fin' => formatear_fecha('d-m-Y', $proyeccion->pyc_fecha_fin), 
            'fecha_limite_nota' => formatear_fecha('d-m-Y', $proyeccion->pyc_fecha_limite_nota),
            'flag_no_cumple_max_inscripcion' => $flag_no_cumple_max_inscripcion,
            'areas' => $areas,
            'lxa_id' => (isset($proyeccion->lxa_id))?$proyeccion->lxa_id:'',
            'edad_alumno' => $edad
        ));
    }

    function get_info_area() {
        satelite_validar(true);

        $id_alm = $this->input->post('alumno');
        $area = $this->input->post('area');
        $grupo = ($this->input->post('grupo')>0)?$this->input->post('grupo'):null;
        $grado = null;
        if($grupo!=null){
            $grado = $this->gsatelite->get_campo('gra_grupo_academico', 'gra_id_grd', array('gra_id'=>$grupo));
        }

        $alumno = $this->gsatelite->get_tabla("alm_alumno", array("alm_id" => $id_alm));

        if(isset($alumno[0]['alm_fecha_nacimiento'])) {
            $fec_n = explode('-', $alumno[0]['alm_fecha_nacimiento']);
            $year_ac = date('Y');
            $mes_ac = date('m');
            $day_ac = date('d');
            if ($fec_n[1] == $mes_ac && $fec_n[2] > $day_ac) {
                $year_ac = $year_ac - 1;
            }
            if ($fec_n[1] > $mes_ac) {
                $year_ac = $year_ac - 1;
            }
            $edad = ($year_ac - $fec_n[0]);
        } else {
            $edad = null;
        }

            $this->db->join('trd_tipo_area_academica', 'trd_id=ard_id_trd', 'left');
        $registro_area = $this->gsatelite->get_registro('ard_area_academica', array('ard_id'=>$area));

        $slc_grados = $this->gsatelite->get_dropdown('grd_grado', '{grd_nombre}', '', array('grd_estado' => '1', 'grd_id_ard'=>$area), $grado, '', 'grd_id', true);
        $grados = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $slc_grados);

        $verificar_flag_curso = isset($registro_area->ard_id_trd) && (isset($registro_area->trd_es_curso_libre) && $registro_area->trd_es_curso_libre == 1) ? true: false;

        echo json_encode(array(
                "grados" => $grados,
                "verificar_flag_curso" => $verificar_flag_curso,
                "edad_maxima" => $registro_area->ard_edad_maxima,
                "edad_minima" => $registro_area->ard_edad_minima,
                "edad_alumno" => $edad,
            ));
    }

    function cargar_tipo_listado_precio(){
        satelite_validar(true);

        $id = $this->input->post('id');
        $tipo = $this->input->post('tipo');

        if ($tipo == 'curso') {
                        $this->db->join('mod_modulo', 'mod_id = pen_id_mod', 'INNER');
            $art = $this->gsatelite->get_registro("pen_pensum", array("pen_id" => $id));
            $art_id = $art->mod_id_art;
        } else if($tipo == 'grado') {
            $art = $this->gsatelite->get_registro("grd_grado", array("grd_id" => $id));
            $art_id = $art->grd_id_art;
        }

            $this->db->join("tlp_tipo_lista_precio", "tlp_id = lip_id_tlp");
        $options = $this->gsatelite->get_dropdown("lip_listado_precio", "{tlp_nombre}", "", array("lip_id_art" => $art_id, "lip_estado" => 1), null, '', 'lip_id_tlp', true);
        $tipo_listado_precios = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $options);
        

        $verificar_existencia = $this->gsatelite->count("lip_listado_precio", array("lip_id_art" => $art_id, "lip_estado" => 1));

        echo json_encode(array(
            'existencias_tlp' => $verificar_existencia,
            'tipo_listado_precios' => $tipo_listado_precios
        ));
    
    }

    /**
     * @author Edith Herrera
     * @since  28-10-2017
     * @return Duplicar grupo.
    **/
    function duplicar_grupo($id_grupo = null) {
        satelite_validar();
        $cantidad = 0;
        $ajax = false;
        if ($id_grupo == null) {
            $ajax = true;
            $id_grupo = $this->input->post('id_grupo');
            $cantidad = $this->input->post('cantidad');
        } else {
            $id_grupo = $id_grupo;
            $cantidad = 1;
        }

        $registro = $this->gsatelite->get_registro('gra_grupo_academico', array('gra_id'=>$id_grupo));

        $exito = 0;
        for ($i = 0; $i < $cantidad; $i++) {
            $detalle = array(
                    'gra_id_aul' => ($registro->gra_id_aul >0) ? $registro->gra_id_aul : null,
                    'gra_id_dct' => ($registro->gra_id_dct >0) ? $registro->gra_id_dct : null,
                    'gra_id_ard' => ($registro->gra_id_ard >0) ? $registro->gra_id_ard : null,
                    'gra_id_frh' => ($registro->gra_id_frh >0) ? $registro->gra_id_frh : null,
                    'gra_id_pyc' => ($registro->gra_id_pyc >0) ? $registro->gra_id_pyc : null,
                    'gra_id_scc' => ($registro->gra_id_scc >0) ? $registro->gra_id_scc : null,
                    'gra_id_sug' => ($registro->gra_id_sug >0) ? $registro->gra_id_sug : null,
                    'gra_id_pen' => ($registro->gra_id_pen >0) ? $registro->gra_id_pen : null,
                    'gra_nombre' => ($registro->gra_nombre !='') ? $registro->gra_nombre : '',
                    'gra_fecha_inicio' => formatear_fecha('Y-m-d', $registro->gra_fecha_inicio),
                    'gra_fecha_fin' => formatear_fecha('Y-m-d', $registro->gra_fecha_fin),
                    'gra_cupo' => $registro->gra_cupo,
                    'gra_cupo_minimo' => $registro->gra_cupo_minimo,
                    'gra_estado' => $registro->gra_estado,
                    'gra_usu_crea' => $this->tank_auth->get_user_id(),
                    'gra_usu_mod' => $this->tank_auth->get_user_id(),
                    'gra_fecha_crea' => date('Y-m-d H:i:s'),
                    'gra_fecha_mod' => date('Y-m-d H:i:s')
                   
                );

            $id = $this->gsatelite->ingresar('gra_grupo_academico', $detalle);

            if ($id > 0) {
                $exito++;
            }
        }
        if ($exito > 0) {
            $alerta = array(
                'tipo_alerta' => 'success'
                , 'titulo_alerta' => 'Éxito'
                , 'texto_alerta' => "<b>$exito</b> Nuevo(s) grupo(s) duplicado(s) con éxito."
            );
            $this->session->set_flashdata($alerta);
        }

        if ($ajax) {
            echo json_encode(array('exito' => $exito));
            die();
        } else {
            if ($id > 0) {
                $this->gsatelite->show_dialog('Nuevo(s) grupo(s) ingresado(s) con éxito.', 'registro_academico/mantenimientos/gestion_grupos');
            } else {
                $this->gsatelite->show_dialog('Error al duplicar grupo', 'registro_academico/mantenimientos/gestion_grupos', 'error');
            }
        }
    }

        /**
     * @author Edith Herrera
     * @since 2017-10-29
     * @return Grid del mantenimiento de actividades.
    * */
    function actividades() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        if ($_POST) {         
            $post_array     = $_POST;
            $fecha_inicio   = $post_array['fecha_ini'];
            $fecha_fin      = $post_array['fecha_fin'];
            
            //incluir sucursales
            $usuario        = $this->tank_auth->get_user_id();    
            $sucurales_array= $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $usuario));
            $sucursales     = array_column($sucurales_array,'usc_id_suc');            
            $sucursal_str   = 0;
            if ( count($sucursales) > 0 ) {   
                $sucursal_str .= ','.implode(",", $sucursales);             
            }             
            $where['acv_id_suc in('.$sucursal_str.')'] = NULL;

            if ($fecha_inicio != '' && $fecha_fin != '') {
                $where['acv_fecha_actividad >='] = formatear_fecha('Y-m-d', $fecha_inicio);
                $where['acv_fecha_actividad <='] = formatear_fecha('Y-m-d', $fecha_fin);
            }
            
            $actividad          = $this->gsatelite->get_tabla('acv_actividad', $where);            
            $data['detalles']   = $actividad;                   
            $html               = $this->load->view('registro_academico/procesos/detalle_actividades', $data, true);
            echo $html;
        } else {                    
            $data['titulo_personal']= "Actividades";
            $this->_cargarvista($data);
        }
    }

     function agregar_actividad(){
        satelite_validar();
        if($_POST){
            $post_array = $this->input->post();

            $nombre= $post_array['txtNombre'];
            $fecha= ($post_array['txtFecha']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha']):date('Y-m-d H:i:s');
            $objetivo = $post_array['txtObjetivo'];
            $observacion = ($post_array['txtObservacion']!='')?$post_array['txtObservacion']:null;
           
            $redir = $post_array['redireccion'];

            $nombre_carpeta = $this->input->post('nombre_anexo_carpeta');
            $anexos = $this->input->post('ruta');
            $titulos_doc = $this->input->post('titulo_doc');
            $sucursal = $this->tank_auth->get_sucursal_id();
            $array_acv = array(
                    'acv_id_usu'            => $this->tank_auth->get_user_id(),
                    'acv_id_suc'            => ($sucursal > 0) ? $sucursal : null,
                    'acv_nombre'            => $nombre,
                    'acv_fecha_actividad'   => $fecha,
                    'acv_objetivo'          => $objetivo,
                    'acv_observacion'       => $observacion,
                    'acv_estado'            => 1,
                    'acv_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'acv_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'acv_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'acv_fecha_modificacion'=> date('Y-m-d H:i:s')
                );
                            
            $ingreso = $this->gsatelite->ingresar('acv_actividad', $array_acv);

            $participante = $post_array['detalle_p'];

            foreach ($participante as $key => $value) {
                $array_pta=array(
                        'pta_id_acv'=> $ingreso,
                        'pta_nombre' => $value,
                        'pta_estado' => 1,
                        'pta_usu_creacion' => $this->tank_auth->get_user_id(),
                        'pta_fecha_creacion' => date('Y-m-d H:i:s'),
                        'pta_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'pta_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                $this->gsatelite->ingresar('pta_participante_actividad', $array_pta);
            }


            /**************************** ANEXOS *********************************************************/
                if($ingreso > 0){
                    //Anexos
                    if(count($anexos) > 0 && $anexos !=''){
                        for ($i=0; $i < count($anexos); $i++){
                           $extension =end(explode(".",$anexos[$i]));
                           $ruta_destino = "uploads/".$nombre_carpeta."/".$titulos_doc[$i].".".$extension;
                           $ruta_temp = "public/temp/".$nombre_carpeta."/".$anexos[$i];

                           $anv_array = array(
                                'anv_id_acv' =>  $ingreso,
                                'anv_url' => $ruta_destino,
                                'anv_nombre' => $titulos_doc[$i],
                                'anv_estado' => 1,
                                'anv_fecha_creacion' => date('Y-m-d H:i:s'),
                                'anv_fecha_modificacion' => date('Y-m-d H:i:s'),
                                'anv_usu_creacion' => $this->tank_auth->get_user_id(),
                                'anv_usu_modificacion' => $this->tank_auth->get_user_id(),
                            );

                           $axn_id = $this->gsatelite->ingresar('anv_anexo_actividad',$anv_array);
                           if($axn_id>0){
                                if(!copy($ruta_temp,$ruta_destino)){
                                    //die('No se pudo copiar el archivo');
                                }
                                unlink($ruta_temp);
                            }
                            
                        }
                    }
                }
            /*********************************************************************************************/

            if ($ingreso > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la informacion ingresada.");
            }
            $this->session->set_flashdata($alerta);

            if($redir>0){
                redirect('registro_academico/procesos/actividades');
            }else{
                redirect('registro_academico/procesos/agregar_actividad');
            }

        }else{
            $usuario                = $this->tank_auth->get_user_id();            
            $this->db->join('usc_usuario_sucursal','usc_id_suc = suc_id','inner');
            $sucursales             = $this->gsatelite->get_tabla('suc_sucursal', array('usc_id_usu' => $usuario) );
            $data['sucursales']     = $sucursales;            
            $data['titulo_personal'] = "Agregar actividad";


            //Incluir sucursales
            $sucursal = $this->tank_auth->get_sucursal_id();
            if (is_null($sucursal) || count($sucursal) == 0 || $sucursal == false) {//SI NO EXISTE EL PARAMETRO O NO ESTA BIEN CONFIURADO ABORTAR OPERACION
                $usuario_sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_estado'=>1,'usc_id_usu'=>$this->tank_auth->get_user_id()));
                if(count($usuario_sucursal) > 0) {
                    $this->_cargarvista($data, null);
                } else {
                    $url = 'registro_academico/procesos/actividades';
                    $this->gsatelite->show_dialog('Verifique que su usuario tenga sucursal', $url, 'error', 'Error de Parámetro');
                }
            } else {
                $this->_cargarvista($data, null);
            }
        }
    }


  function editar_actividad($acv_id, $ver=null){
        satelite_validar();
        if($_POST){
            $post_array = $this->input->post();
            $nombre= $post_array['txtNombre'];
            $fecha= ($post_array['txtFecha']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha']):date('Y-m-d H:i:s');
            $objetivo = $post_array['txtObjetivo'];
            $observacion = ($post_array['txtObservacion']!='')?$post_array['txtObservacion']:null;
           
            $redir = $post_array['redireccion'];
            $acv_id = $post_array['acv_id'];

            $anexos_acv = $this->input->post('anexos_acv');
            $nombre_carpeta = $this->input->post('nombre_anexo_carpeta');
            $anexos = $this->input->post('ruta');
            $titulos_doc = $this->input->post('titulo_doc');

            $array_acv = array(
                    'acv_id_usu' =>$this->tank_auth->get_user_id(),
                    'acv_nombre' => $nombre,
                    'acv_fecha_actividad' => $fecha,
                    'acv_objetivo' => $objetivo,
                    'acv_observacion' => $observacion,
                    'acv_estado' => 1,
                    'acv_usu_creacion' => $this->tank_auth->get_user_id(),
                    'acv_fecha_creacion' => date('Y-m-d H:i:s'),
                    'acv_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'acv_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                            
            $ingreso = $this->gsatelite->actualizar_array('acv_actividad', $array_acv, array('acv_id'=>$acv_id));

            $participante = $post_array['detalle_p'];

            if(count($participante)>0){ 
                $this->gsatelite->borrado_general('pta_participante_actividad', array('pta_id_acv'=>$acv_id));
                foreach ($participante as $key => $value) {
                    $array_pta=array(
                            'pta_id_acv'=> $acv_id,
                            'pta_nombre' => $value,
                            'pta_estado' => 1,
                            'pta_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pta_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pta_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pta_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    $this->gsatelite->ingresar('pta_participante_actividad', $array_pta);
                }
            }


            /**************************** ANEXOS *********************************************************/

            //Elimino los anexos que hayan sido eliminados
                    
                    $anexos_existentes =  $this->gsatelite->get_tabla('anv_anexo_actividad',array('anv_id_acv'=>$acv_id));
                    foreach($anexos_existentes as $anv){

                        if(!in_array($anv['anv_id'], $anexos_acv)){
                            $this->gsatelite->borrado_general('anv_anexo_actividad',array('anv_id'=>$anv['anv_id']));
                            unlink($anv['anv_url']);    
                        }
                    }  


                if($ingreso > 0){
                    //Anexos
                    if(count($anexos) > 0 && $anexos !=''){
                        for ($i=0; $i < count($anexos); $i++){
                           $extension =end(explode(".",$anexos[$i]));
                           $ruta_destino = "uploads/".$nombre_carpeta."/".$titulos_doc[$i].".".$extension;
                           $ruta_temp = "public/temp/".$nombre_carpeta."/".$anexos[$i];

                           $anv_array = array(
                                'anv_id_acv' =>  $acv_id,
                                'anv_url' => $ruta_destino,
                                'anv_nombre' => $titulos_doc[$i],
                                'anv_estado' => 1,
                                'anv_fecha_creacion' => date('Y-m-d H:i:s'),
                                'anv_fecha_modificacion' => date('Y-m-d H:i:s'),
                                'anv_usu_creacion' => $this->tank_auth->get_user_id(),
                                'anv_usu_modificacion' => $this->tank_auth->get_user_id(),
                            );

                           $axn_id = $this->gsatelite->ingresar('anv_anexo_actividad',$anv_array);
                           if($axn_id>0){
                                if(!copy($ruta_temp,$ruta_destino)){
                                    //die('No se pudo copiar el archivo');
                                }
                                unlink($ruta_temp);
                            }
                            
                        }
                    }
                }
            /*********************************************************************************************/

            if ($ingreso > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la informacion ingresada.");
            }
            $this->session->set_flashdata($alerta);

            if($redir>0){
                redirect('registro_academico/procesos/actividades');
            }else{
                redirect('registro_academico/procesos/editar_actividad/'.$acv_id);
            }

        }else{
            $data['detalle'] = $this->gsatelite->get_tabla('pta_participante_actividad', array('pta_id_acv'=>$acv_id));
            
            $act = $this->gsatelite->get_tabla('acv_actividad', array('acv_id'=>$acv_id));
            $data['actividades'] = $act[0];

            $data['anexos_act'] = $this->gsatelite->get_tabla('anv_anexo_actividad', array('anv_id_acv'=>$acv_id));

            $data['acv_id']=$acv_id;

            $data['ver'] = ($ver>0)?$ver:0;
            
            $data['titulo_personal'] = ($ver>0)? "Ver actividad" : "Editar actividad";
            $this->_cargarvista($data, null);
        }
    }


    function eliminar_actividad($id_acv = NULL) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // Your code goes here.
            
                $registro = $this->gsatelite->borrado_general('anv_anexo_actividad', array('anv_id_acv' => $id_acv));
               
                $registro = $this->gsatelite->borrado_general('pta_participante_actividad', array('pta_id_acv' => $id_acv));
                $registro = $this->gsatelite->borrado_general('acv_actividad', array('acv_id' => $id_acv));
            
            if($registro>0){
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro borrado", 'texto_alerta' => "El registro se ha borrado correctamente.");            
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "NOTA", 'texto_alerta' => "El registro posee integridad referencial <br />&nbsp;No podrá ser eliminado.");
            }

            $this->session->set_flashdata($alerta);
            redirect('registro_academico/procesos/actividades');
        }
    }

     /****************************** ARCHIVOS ***********************************/
    public function guardar_gral($parametros, $carpeta=null)
    {
        $datos= @explode($parametros);
        $carpeta=$parametros;
           
            $image = $this->upload_gral($carpeta);
            if($image==1){
                $postMax = ini_get('post_max_size');
                echo "tamanio".$postMax; // echo out error and solutions...
            }else{
                echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
            }
    }

    public function upload_gral($carpeta){
            if($carpeta=="assets"){
                $ruta = FCPATH . "assets/uploads/images";
            }
            else{
                $ruta = FCPATH. "public/temp/".$carpeta;
            }


        if(empty($_FILES) && empty($_POST) && isset($_SERVER['REQUEST_METHOD']) && strtolower($_SERVER['REQUEST_METHOD']) == 'post'){ //catch file overload error...
                $postMax = ini_get('post_max_size'); //grab the size limits...
                return 1;
        }else{ 

            if(!file_exists($ruta)){
                mkdir($ruta,0777);
            }

            $obj = &get_instance();
            $config['upload_path'] = $ruta;
            $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx|text/plain';
            //$config['allowed_types'] = '*';
            //$_FILES['userfile']['name'] = preg_replace("/[^a-zA-Z0-9.-_]/", "", $_FILES['userfile']['name']);

            $nombre_archivo = explode(".",$_FILES['userfile']['name']);
            $extension = end(explode(".",$_FILES['userfile']['name']));

            $nombre_correcto = $this->limpia_texto->clean_string($nombre_archivo[0]);

            //$_FILES['userfile']['name'] = $this->limpia_texto->clean_string($_FILES['userfile']['name']);
            $_FILES['userfile']['name'] = $nombre_correcto.".".$extension;
            $config['file_name'] = $_FILES['userfile']['name'];

            $obj->load->library('upload',$config);

            if(!$obj->upload->do_upload()){
                $error = array("error" => $obj->upload->display_errors());
                return true;
            }
            else{
                $data = array('upload_data' => $obj->upload->data());
                return $data;
            }
            print_r($data);
            //var_dump($obj);
        }   
    }

    public function eliminar_imagen_gral($carpeta=""){
        if($this->input->post()){
            $url = $this->input->post('url');
            $edicion = $this->input->post('edicion');

            if(!empty($edicion)){
                unlink("uploads/".$carpeta."/".$url);
            }
            else{
                $carp = ($carpeta != "") ? $carpeta : "anx_actividades"; 
                unlink("public/temp/$carp/" . $url);
            }
            echo $url;
        }
    }


    /**
     * @author Edith Herrera
     * @since 2017-10-29
     * @return Grid del mantenimiento de actividades.
    * */
    function solicitud_becas() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        if ($_POST) {
            $post_array = $_POST;

            $area = $post_array['area'];
            $tipo = $post_array['tipo'];

            $where = null;           
            if ($area > 0) {
                $where['slb_id_ard'] = $area;
            }
            
            if ($tipo > 0) {
                $where['slb_id_tbs'] = $tipo;
            }
                     $this->db->join('alm_alumno', 'alm_id=slb_id_alm');
            $becas = $this->gsatelite->get_tabla('slb_solicitud_beca', $where);
            $data['detalles'] = $becas;
                   
            $html = $this->load->view('registro_academico/procesos/detalle_solicitud', $data, true);

            echo $html;
        } else {

            $select = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1), null, '', 'ard_id', true);
            $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

            $beneficiario = $this->gsatelite->get_dropdown('tbs_tipo_beneficiario_solicitud', '{tbs_nombre}', '', array('tbs_estado' => 1), null, '', 'tbs_id', true);
                $data["beneficiario"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $beneficiario);

            $data['titulo_personal'] = "Solicitudes de becas";

            $this->_cargarvista($data);
        }
    }

    function agregar_solicitud() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $post_array = $this->input->post();

                $solicitud = array(
                    'slb_id_usu' => $this->tank_auth->get_user_id(),
                    'slb_id_emp_referencia'=>($post_array['slcEmpleado']>0) ? $post_array['slcEmpleado'] : null,
                    'slb_id_tpb'=>($post_array['slcTipoBeca']>0) ? $post_array['slcTipoBeca'] : null,
                    'slb_id_tbs'=>($post_array['slcTipoBen']>0) ? $post_array['slcTipoBen'] : null,
                    'slb_id_ina' => ($post_array['slcInstitucion']>0) ? $post_array['slcInstitucion'] : null,
                    'slb_id_ard' => ($post_array['slcArea']>0) ? $post_array['slcArea'] : null,
                    'slb_id_frh' => ($post_array['slcFrecuencia']>0) ? $post_array['slcFrecuencia'] : null,
                    'slb_id_pen' => ($post_array['slcNivel']>0) ? $post_array['slcNivel'] : null,
                    'slb_id_alm' => ($post_array['slcSolicitante']>0) ? $post_array['slcSolicitante'] : null,
                    'slb_fecha_solicitud' => formatear_fecha('Y-m-d', $post_array['txtFecha']),
                    'slb_observacion_solicitud' => ($post_array['txtObservacion']!='') ? $post_array['txtObservacion'] : null,
                    'slb_estado' => 1,
                    'slb_estado_solicitud' => 1,
                    'slb_id_grd' => ($this->input->post('slcGrados') != '')?$this->input->post('slcGrados'):null,
                    'slb_id_suc' => $this->tank_auth->get_sucursal_id(),
                    'slb_usu_creacion' => $this->tank_auth->get_user_id(),
                    'slb_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'slb_fecha_creacion' => date('Y-m-d H:i:s'),
                    'slb_fecha_modificacion' => date('Y-m-d H:i:s')
                   
                );
                //die(print_r($solicitud));
                $registro = $this->gsatelite->ingresar('slb_solicitud_beca', $solicitud);
               
                if ($registro > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la informacion ingresada.");
                }

                $this->session->set_flashdata($alerta);
                $boton = $this->input->post('redireccion');
                if ($boton == 0) {
                    redirect('registro_academico/procesos/agregar_solicitud');
                    
                } else if ($boton == 1) {
                    redirect('registro_academico/procesos/solicitud_becas');
                }
            } else {
               
                $programas = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => '1'), null, '', 'ard_id', true);
                $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $programas);
                
                $frecuencia = $this->gsatelite->get_dropdown('frh_frecuencia_horario', '{frh_nombre}', '', array('frh_estado' => 1), null, '', 'frh_id', true);
                $data["frecuencia"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $frecuencia);           
                $tipo_beca = $this->gsatelite->get_dropdown('tpb_tipo_beca', '{tpb_nombre}', '', array('tpb_estado' => 1), null, '', 'tpb_id', true);
                $data["tipo_beca"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_beca);

                $beneficiario = $this->gsatelite->get_dropdown('tbs_tipo_beneficiario_solicitud', '{tbs_nombre}', '', array('tbs_estado' => 1), null, '', 'tbs_id', true);
                $data["beneficiario"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $beneficiario);

                $centro_costo = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
                $data["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $centro_costo);

                //tipo de cuenta
                $tipo_cuenta = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
                $data["tipo_cuenta"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_cuenta);
                //cuenta contable

                $cuenta = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
                $data["cuen_con"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $cuenta);

                $data["titulo_personal"] = "Agregar solicitud de beca";

                //Incluir sucursales
                $sucursal = $this->tank_auth->get_sucursal_id();
                if (is_null($sucursal) || count($sucursal) == 0 || $sucursal == false) {//SI NO EXISTE EL PARAMETRO O NO ESTA BIEN CONFIURADO ABORTAR OPERACION
                    $usuario_sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_estado'=>1,'usc_id_usu'=>$this->tank_auth->get_user_id()));
                    if(count($usuario_sucursal) > 0) {
                        $this->_cargarvista($data);
                    } else {
                        $url = 'registro_academico/procesos/solicitud_becas';
                        $this->gsatelite->show_dialog('Verifique que su usuario tenga sucursal', $url, 'error', 'Error de Parámetro');
                    }
                } else {
                    $this->_cargarvista($data);
                }
            }
        }
    }

    /**
     * @author Edith Herrera
     * @since  2017-10-29
     * @return validar que se pueda seleccionar al docente para el grupo a registrar.
    * */
     function validar_docente() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $pyc = $this->input->post('proyeccion');
            $pluriclase = $this->input->post("pluriclase");
            $frecuencia = $this->input->post('frecuencia');
            $docente = ($this->input->post('docente') != "") ? $this->input->post('docente') : 0;
            $grupo = ($this->input->post('grupo') != "") ? $this->input->post('grupo') : 0;
            $aula  = ($this->input->post('aula') != "") ? $this->input->post('aula') : 0;
            $resp=0;
            
            $grupos = $this->gsatelite->get_tabla('gra_grupo_academico',array('gra_id_frh'=>$frecuencia,'gra_id_aul'=>$aula,'gra_id_dct'=>$docente,'gra_id !='=>$grupo,'gra_id_pyc'=>$pyc));
            $dif_aula  = $this->gsatelite->get_tabla('gra_grupo_academico',array('gra_id_frh'=> $frecuencia,'gra_id_aul !='=>$aula,'gra_id_dct'=>$docente,'gra_id !='=>$grupo,'gra_id_pyc'=>$pyc));
            $aula_freq = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id_frh' => $frecuencia, 'gra_id_aul' => $aula, 'gra_id !='=>$grupo, 'gra_id_pyc'=>$pyc));
            $reg_aula = $this->gsatelite->get_registro('aul_aula', array('aul_id' => $aula));
            $modality = (count($reg_aula) > 0) ? $reg_aula->aul_modalidad : 0;
            
            if(count($grupos)>0 && $pluriclase!=1){
                $resp=1;
            }else if(count($dif_aula)>0 && $pluriclase!=1){
                $resp=2;
            }else if(count($aula_freq)>0){
                $resp=3;
            }else{
                 $resp=0;
            }
            echo json_encode(array('resp' => $resp, 'modalidad_aula' => $modality));
        }
    }

     /**
     * @author Edith Herrera
     * @since  31-10-2017
     * @return Carga el dropdown de empleados o alumnos, de acuerdo a lo requerido.
    * */
    function get_tipo_solicitante($id_tipo=null, $edit=null){
        satelite_validar();
            // 1 = Alumno, 2 = Empleado, 3 = Otros.
            $tipo = ($id_tipo!='')? $id_tipo : $this->input->post('tipo');

            if($tipo==1){
                $select = $this->gsatelite->get_dropdown('alm_alumno', '{alm_nombre} {alm_apellido}', '', array('alm_estado' => 1), $edit, '', 'alm_id', true);
                $result = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
                $class='alumno';
            }else{
                $select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), $edit, '', 'emp_id', true);
                $result = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
                $class='empleado';
            }

            if($id_tipo!=null){
                return array('resp'=>$result, 'tipo'=>$class);
            }else{
                echo json_encode(array('resp'=>$result, 'tipo'=>$class));
            }
    }

    /**
     * @author Edith Herrera
     * @since  31-10-2017
     * @return Obtiene dropdowns de institución y profesión para la solicitud de becas (tipo=otros).
    * */
    function get_dropdowns(){
        satelite_validar();
        
        $select = $this->gsatelite->get_dropdown('ina_institucion_academica', '{ina_nombre}', '', array('ina_estado' => 1), null, '', 'ina_id', true);
        $institucion = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
        
        $select = $this->gsatelite->get_dropdown('pro_profesion', '{pro_nombre}', '', array('pro_estado' => 1), null, '', 'pro_id', true);
        $profesion = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
       
        echo json_encode(array('institucion'=>$institucion, 'profesion'=>$profesion));
    }


    /**
     * @author Edith Herrera
     * @since  31-10-2017
     * @return Grid del mantenimiento de actividades.
    * */
    function get_info_solicitante(){
        satelite_validar(true);

        $solicitante = $this->input->post('solicitante');

            $alumno = $this->registro_academico_model->get_info_alumno(array('alm_id'=>$solicitante));
            $inst =  $alumno->eda_id_ina;
            $prof =  $alumno->alm_id_pro;
            $fecha_nac =  ($alumno->alm_fecha_nacimiento != '')? formatear_fecha('d-m-Y', $alumno->alm_fecha_nacimiento):'';
            $correo =  ($alumno->alm_email != '')?$alumno->alm_email:'';
            $direccion =  ($alumno->alm_direccion != '')?$alumno->alm_direccion:'';
        
        $select = $this->gsatelite->get_dropdown('ina_institucion_academica', '{ina_nombre}', '', array('ina_estado' => 1), $inst, '', 'ina_id', true);
        $institucion = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
        
        $select = $this->gsatelite->get_dropdown('pro_profesion', '{pro_nombre}', '', array('pro_estado' => 1), $prof, '', 'pro_id', true);
        $profesion = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
       
        echo json_encode(array('institucion'=>$institucion, 'profesion'=>$profesion, 'fecha'=>$fecha_nac, 'correo'=>$correo, 'direccion'=>$direccion));
    }

     /**
     * @author Edith Herrera
     * @since  01-11-2017
     * @return Formulario de edición de solicitud.
    * */
    function editar_solicitud($slb_id=null, $ver=null, $return_ver=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $post_array = $this->input->post();
                $slb_id = $post_array['slb_id'];

                $solicitud = array(
                    'slb_id_usu' => $this->tank_auth->get_user_id(),
                    'slb_id_emp_referencia'=>($post_array['slcEmpleado']>0) ? $post_array['slcEmpleado'] : null,
                    'slb_id_tpb'=>($post_array['slcTipoBeca']>0) ? $post_array['slcTipoBeca'] : null,
                    'slb_id_tbs'=>($post_array['slcTipoBen']>0) ? $post_array['slcTipoBen'] : null,
                    'slb_id_ina' => ($post_array['slcInstitucion']>0) ? $post_array['slcInstitucion'] : null,
                    'slb_id_ard' => ($post_array['slcArea']>0) ? $post_array['slcArea'] : null,
                    'slb_id_frh' => ($post_array['slcFrecuencia']>0) ? $post_array['slcFrecuencia'] : null,
                    'slb_id_pen' => ($post_array['slcNivel']>0) ? $post_array['slcNivel'] : null,
                    'slb_id_alm' => ($post_array['slcSolicitante']>0) ? $post_array['slcSolicitante'] : null,
                    'slb_fecha_solicitud' => formatear_fecha('Y-m-d', $post_array['txtFecha']),
                    'slb_observacion_solicitud' => ($post_array['txtObservacion']!='') ? $post_array['txtObservacion'] : null,
                    'slb_estado' => 1,
                    'slb_id_grd' => ($this->input->post('slcGrados') != '')?$this->input->post('slcGrados'):null,
                    'slb_estado_solicitud' => 1,
                    'slb_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'slb_fecha_modificacion' => date('Y-m-d H:i:s')
                );

                    
                $registro = $this->gsatelite->actualizar_array('slb_solicitud_beca', $solicitud, array('slb_id'=>$slb_id));
               
                if ($registro > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la informacion ingresada.");
                }

                $this->session->set_flashdata($alerta);
                $boton = $this->input->post('redireccion');
                if ($boton == 0) {
                    redirect('registro_academico/procesos/editar_solicitud/'.$slb_id);
                    
                } else if ($boton == 1) {
                    redirect('registro_academico/procesos/solicitud_becas');
                }
            } else {
                $solicitud = $this->registro_academico_model->get_info_solicitud(array('slb_id' => $slb_id));
                $data['solicitud'] = $solicitud[0];
                //print_r($solicitud); die();

                $data['disable'] = 'readonly="readonly"';
                $data['select_read'] = 'read';
               
                $data['pensum'] = $this->cargar_pensum($solicitud[0]['slb_id_ard'], $solicitud[0]['slb_id_pen']);

                $select = $this->gsatelite->get_dropdown('ina_institucion_academica', '{ina_nombre}', '', array('ina_estado' => 1), $solicitud[0]['slb_id_ina'], '', 'ina_id', true);
                $data['institucion'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
                
                $select = $this->gsatelite->get_dropdown('pro_profesion', '{pro_nombre}', '', array('pro_estado' => 1), $solicitud[0]['alm_id_pro'], '', 'pro_id', true);
                $data['profesion'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

                $programas = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => '1'), $solicitud[0]['slb_id_ard'], '', 'ard_id', true);
                $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $programas);
                
                $frecuencia = $this->gsatelite->get_dropdown('frh_frecuencia_horario', '{frh_nombre}', '', array('frh_estado' => 1, 'frh_id_ard'=>$solicitud[0]['slb_id_ard']), $solicitud[0]['slb_id_frh'], '', 'frh_id', true);
                $data["frecuencia"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $frecuencia);

                $tipo_beca = $this->gsatelite->get_dropdown('tpb_tipo_beca', '{tpb_nombre}', '', array('tpb_estado' => 1), $solicitud[0]['slb_id_tpb'], '', 'tpb_id', true);
                $data["tipo_beca"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_beca);

                $beneficiario         = $this->gsatelite->get_dropdown('tbs_tipo_beneficiario_solicitud', '{tbs_nombre}', '', array('tbs_estado' => 1), $solicitud[0]['slb_id_tbs'], '', 'tbs_id', true);
                $data["beneficiario"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $beneficiario);   
                $data['grados']       = str_replace('<option value="0">Seleccione</option>','',$this->gsatelite->get_dropdown('grd_grado','grd_nombre','',array('grd_estado' => 1),$solicitud[0]['slb_id_grd'] , '', 'grd_id', true));
                $data['slb_id'] = $slb_id;       
                $data['mod_id'] = 1;
                $data['ver'] = ($ver!=null)?$ver:0;
                $data["titulo_personal"] = ($ver!=null)?"Ver solicitud de beca":"Editar solicitud de beca"; 
                $this->_cargarvista($data);
            }
        }
    }

     function cargar_pensum($area=null, $edit=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            if($area!=null){
                $id_area = $area;
                $where_md = array('ard_id' => $id_area);
                $pensum = $this->registro_academico_model->obtener_pensum_x_ard($where_md, $edit);
                return $pensum;
            }else{
                $id_area = $this->input->post('id');

                $where_md = array('ard_id' => $id_area);
                $pensum = $this->registro_academico_model->obtener_pensum_x_ard($where_md);
                $data['pensum'] = $pensum;
                echo $data['pensum'];
            }
        }
    }

    public function eliminar_solicitud($slb_id) {
        if ($slb_id != null) {
            $where = array('slb_id' => $slb_id, 'slb_estado_solicitud <='=>1);
            $result = $this->gsatelite->borrado_general('slb_solicitud_beca', $where);
            if ($result > 0) {
                $alerta = array('registro' => $result, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro eliminado", 'texto_alerta' => "El registro se ha eliminado correctamente.");
            }else {

                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "NOTA", 'texto_alerta' => "El registro posee integridad referencial <br />&nbsp;No podrá ser eliminado. ");
            }
            $this->session->set_flashdata($alerta);
            redirect('registro_academico/procesos/solicitud_becas');
        } else {
            redirect('registro_academico/procesos/solicitud_becas');
        }
    }

    /**
     * @author Edith Herrera
     * @since  01-11-2017
     * @return autorización de becas.
    * */
    public function autorizacion_becas() {
        satelite_validar();
        //$this->solicitud_becas();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        if ($_POST) {
            $post_array = $_POST;
            $area = $post_array['area'];
            $tipo = $post_array['tipo'];
            //incluir sucursales
            $usuario        = $this->tank_auth->get_user_id();    
            $sucurales_array= $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $usuario));
            $sucursales     = array_column($sucurales_array,'usc_id_suc');            
            $sucursal_str   = 0;
            if ( count($sucursales) > 0 ) {   
                $sucursal_str .= ','.implode(",", $sucursales);
            }
            $where['alm_id_suc in('.$sucursal_str.')'] = NULL;             
            if ($area > 0) {
                $where['slb_id_ard'] = $area;
            }
            if ($tipo > 0) {
                $where['slb_id_tbs'] = $tipo;
            }
            $becas = $this->registro_academico_model->get_info_solicitud($where);
            $data['detalles'] = $becas;          
            $data['autoriza'] = 1;                   
            $html = $this->load->view('registro_academico/procesos/detalle_solicitud', $data, true);
            echo $html;
        } else {

            $select = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1), null, '', 'ard_id', true);
            $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

            $beneficiario = $this->gsatelite->get_dropdown('tbs_tipo_beneficiario_solicitud', '{tbs_nombre}', '', array('tbs_estado' => 1), null, '', 'tbs_id', true);
            $data["beneficiario"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $beneficiario);
            
            $beneficio = $this->gsatelite->get_tabla('tbf_tipo_beneficio', array('tbf_estado' => 1));

            $options = '<option value=""></option>';
            if(count($beneficio)>0){
                foreach ($beneficio as $key) {
                   $options .= '<option value="'.$key['tbf_id'].'" data-desc="'.$key['tbf_porcentaje'].'"  >'.$key['tbf_nombre'].'</option>';
                }
            }
          
            $data["beneficio"] = $options;

            $data['titulo_personal'] = "Autorización de becas";
            $this->_cargarvista($data);
        }

    }

    /**
     * @author Edith Herrera
     * @since  03-11-2017
     * @return autorización de becas.
    * */
    function autorizar_beca(){
        satelite_validar(true);
        $id_soli = $this->input->post('id');
        $tipo = $this->input->post('tipo');
        $descuento = $this->input->post('descuento');
        $fecha = formatear_fecha('Y-m-d', $this->input->post('fecha'));
        $observacion = ($this->input->post('observacion')!='')?$this->input->post('observacion'):null;

        $detalle = array(
            'apb_id_tbf' => $tipo,
            'apb_id_slb' => $id_soli,
            'apb_id_usu_autoriza'  => $this->tank_auth->get_user_id(),
            'apb_fecha_autoriza'   => date('Y-m-d H:i:s'),
            'apb_inicio_beneficio' => $fecha,
            'apb_porcentaje' => $descuento,
            'apb_observacion' => $observacion,
            'apb_estado'=>1,
            'apb_usu_creacion'=> $this->tank_auth->get_user_id(),
            'apb_usu_modificacion' => $this->tank_auth->get_user_id(),
            'apb_fecha_creacion' => date('Y-m-d H:i:s'),
            'apb_fecha_modificacion' => date('Y-m-d H:i:s')
        );
        $id = $this->gsatelite->ingresar('apb_aprobacion_beca', $detalle);
        if($id > 0){
            $act_slb=array(
                'slb_estado_solicitud'=>2,
                'slb_usu_modificacion' =>$this->tank_auth->get_user_id(),
                'slb_fecha_modificacion'=>date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('slb_solicitud_beca', $act_slb, array('slb_id'=>$id_soli));
            // Buscar cuotas en la CMC
            $alm = $this->registro_academico_model->alumo_becado_cmc(array('apb_id' => $id, 'slb_estado_solicitud' => 2));
            $cmcwhere = array(
                'cmc_estado_cargo' => 1, 
                'lxa_id_alm' => $alm['slb_id_alm'], 
                'lxa_id_ard' => $alm['slb_id_ard'], 
                'gra_id_pen' => $alm['slb_id_pen'],
                'cmc_fecha >= ' => formatear_fecha('Y-m-d', $alm['apb_inicio_beneficio'])
            );
            $cuotascmc = $this->registro_academico_model->buscar_cmc_becados($cmcwhere);
            if (count($cuotascmc) > 0) {
                foreach ($cuotascmc as $k => $v) {
                    $prcds = ($v['cmc_monto'] * $alm['apb_porcentaje']) / 100;
                    $nwcuo = ($v['cmc_monto'] - $prcds);
                    $total_impuesto = 0;
                    if ($nwcuo > 0) {
                        $new_estado = 1;
                        $new_estado_cargo = 1;
                        // impuestos de la category
                                $this->db->join('imp_impuesto', 'imp_id = ixr_id_imp');
                        $ixrs = $this->gsatelite->get_tabla('ixr_impuestox_tipo_articulo', array('ixr_id_tia' => $v['id_tia'], 'ixr_estado'=>1));
                        if (count($ixrs) > 0) {
                            foreach ($ixrs as $i) {
                                if($i['imp_valor'] > 0) {
                                    $total_impuesto += $i['imp_valor'];
                                } else {
                                    $porcentaje_impuesto = $nwcuo * ($i['imp_porcentaje'] / 100);
                                    $total_impuesto += $porcentaje_impuesto;
                                }
                            }
                        }
                    } else {
                        $new_estado = 0;
                        $new_estado_cargo = 0;
                    }
                    $cuota_updt = array(
                        "cmc_monto" => $nwcuo,
                        "cmc_impuestos" => $total_impuesto,
                        "cmc_observacion" => "Aprobación de beneficio Beca al " . $alm['apb_porcentaje'] . "%, el día " . formatear_fecha("d-m-Y", $fecha),
                        "cmc_estado_cargo" => $new_estado_cargo,
                        "cmc_estado" => $new_estado,
                        "cmc_usu_modificacion" => $this->tank_auth->get_user_id(),
                        "cmc_fecha_modificacion" => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cmc_cargo_alumnoxcurso', $cuota_updt, array('cmc_id' => $v['cmc_id']));
                    if ($alm['apb_porcentaje'] == 100 && $v['lxp_tipo_inscripcion'] == 1) {
                        $this->gsatelite->actualizar_array('lxp_alumnoxpensum', array('lxp_tipo_inscripcion' => 2), array('lxp_id' => $v['lxp_id']));
                }
            }
        }
        }
        if ($id > 0) {
            $alerta = array(
                'tipo_alerta' => 'success', 
                'titulo_alerta' => 'Éxito', 
                'texto_alerta' => "La solicitud se aprobó correctamente."
            );
            $this->session->set_flashdata($alerta);
        }
        echo json_encode(array('exito' => $id));
    }

    /**
     * @author Edith Herrera
     * @since  03-11-2017
     * @return Denegar becas.
    * */
    function denegar_beca(){
         satelite_validar(true);

            $id_soli = $this->input->post('id');
            $observacion = ($this->input->post('observacion')!='')?$this->input->post('observacion'):null;

            $act_slb=array(
                'slb_id_usu_deniega'=>$this->tank_auth->get_user_id(),
                'slb_fecha_deniega' => date('Y-m-d H:i:s'),
                'slb_observacion_denegar' => $observacion,
                'slb_estado_solicitud'=>3,
                'slb_usu_modificacion' =>$this->tank_auth->get_user_id(),
                'slb_fecha_modificacion'=>date('Y-m-d H:i:s')
            );
            $act = $this->gsatelite->actualizar_array('slb_solicitud_beca', $act_slb, array('slb_id'=>$id_soli));
           

        if ($act > 0) {
            $alerta = array(
                  'tipo_alerta' => 'success'
                , 'titulo_alerta' => 'Éxito'
                , 'texto_alerta' => "La solicitud ha sido denegada"
            );
            $this->session->set_flashdata($alerta);
        }

        echo json_encode(array('exito' => $act));
    }

    /**
     * @author Edith Herrera
     * @since  03-11-2017
     * @return Gestión de alumnos.
    * */
    public function acciones_alumno() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        if ($_POST) {
            $post_array = $_POST;
            $area = $post_array['area'];
            $grupo = $post_array['grupo'];

            $where = null;           
            if ($area > 0) {
                $where['ard_id'] = $area;
            }
            if ($grupo > 0) {
                $where['gra_id'] = $grupo;
            }

            $alumnos = $this->registro_academico_model->obtener_alumnos_grupos(null, $where);
            $data['alumnos'] = $alumnos;
                   
            $html = $this->load->view('registro_academico/procesos/detalle_accion_alumno', $data, true);

            echo $html;
        } else {

            $select = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1), null, '', 'ard_id', true);
            $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

            $grupos = array();//$this->registro_academico_model->obtener_grupos();
            
            $data['titulo_personal'] = "Gestión de alumnos";
            $this->_cargarvista($data);
        }

    }

      function cargar_grupos($area=null, $edit=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            if($area!=null){
                $id_area = $area;
                $where_md = array('ard_area_academica.ard_id' => $id_area);
                $pensum = $this->registro_academico_model->obtener_pensum_x_ard($where_md, $edit);
                return $pensum;
            }else{
                $id_area = $this->input->post('id');

                $where_md = array('ard_area_academica.ard_id' => $id_area);
                $pensum = $this->registro_academico_model->obtener_pensum_x_ard($where_md);
                $data['pensum'] = $pensum;
                echo $data['pensum'];
            }

        }
    }

    /**
     * @author Edith Herrera
     * @since  03-11-2017
     * @return Realizar traslado de alumnos mientras haya cupo disponible
    * */
    function trasladar_alumno(){
        satelite_validar(true);
        $id_alm = $this->input->post('id');
        $area = ($this->input->post('area')!='')?$this->input->post('area'):null;
        $grupo = ($this->input->post('grupo')!='')?$this->input->post('grupo'):null;
        $grupo_org = ($this->input->post('origen')!='')?$this->input->post('origen'):null;
        $area_org = ($this->input->post('area_org')!='')?$this->input->post('area_org'):null;
        $observacion = ($this->input->post('observacion')!='')?$this->input->post('observacion'):null;
        //die(print_r($_POST));
        $where=array();
        if($area!=null){
            $where['gra_id_ard']=$area;
        }
        if($grupo!=null){
            $where['gra_id']=$grupo;
        }

        $inscritos = $this->registro_academico_model->get_alumnos_inscritos($where);
        $restante = $inscritos->gra_cupo - $inscritos->inscritos;

        $get_grupo_org = $this->gsatelite->get_campo('lxp_alumnoxpensum', 'lxp_id_gra', array('lxp_id'=>$grupo_org));

        $alumnos = $this->registro_academico_model->obtener_alumnos_grupos(null, array('alm_id'=>$id_alm, 'gra_id'=>$get_grupo_org, 'lxp_estado'=>1));

        if($area==$area_org){
            $lxa_id = $alumnos[0]['lxa_id'];
        }else{
            /******* Verifica que exista una área asociada al alumno según el grupo de destino ***************************/ 
            $areas_alumno = $this->gsatelite->get_tabla('lxa_alumnoxarea', array('lxa_id_alm'=>$id_alm, 'lxa_id_ard'=>$area));
            
            if(count($areas_alumno)>0){
                $lxa_id = $areas_alumno[0]['lxa_id'];
            }else{
                $area_alm = array(
                        'lxa_id_alm'=>$id_alm,
                        'lxa_id_ard'=>$area,
                        'lxa_fecha_incripcion'=>date('Y-m-d'),
                        'lxa_estado'=>1,
                        'lxa_usu_crea'=>$this->tank_auth->get_user_id(),
                        'lxa_fecha_crea'=>date('Y-m-d H:i:s'),
                        'lxa_usu_mod'=>$this->tank_auth->get_user_id(),
                        'lxa_fecha_mod'=>date('Y-m-d H:i:s')
                    );
                $lxa_id = $this->gsatelite->ingresar('lxa_alumnoxarea', $area_alm);
            }
        }
        //die(print_r($alumnos));
        
        if($restante>=1){
            $array_inactivo = array(
                    'lxp_estado'=>0,
                    'lxp_traslado'=>1,
                    'lxp_usu_mod'=>$this->tank_auth->get_user_id(),
                    'lxp_fecha_mod'=>date('Y-m-d H:i:s')
                );
            $this->gsatelite->actualizar_array('lxp_alumnoxpensum', $array_inactivo, array('lxp_id'=>$alumnos[0]['lxp_id']));

            $array_nuevo = array(
                    'lxp_id_lxa'=>$lxa_id,
                    'lxp_id_gra'=>$grupo,
                    'lxp_id_crt'=>$alumnos[0]['lxp_id_crt'],
                    'lxp_id_fac'=>$alumnos[0]['lxp_id_fac'],
                    'lxp_id_def'=>$alumnos[0]['lxp_id_def'],
                    'lxp_observacion'=>$alumnos[0]['lxp_observacion'],
                    'lxp_condicion'=>1,
                    'lxp_fecha_inscripcion'=>date('Y-m-d H:i:s'),
                    'lxp_exam_ubicacion'=>$alumnos[0]['lxp_exam_ubicacion'],
                    'lxp_estado'=>1,
                    'lxp_usu_crea'=>$this->tank_auth->get_user_id(),
                    'lxp_fecha_crea'=>date('Y-m-d H:i:s'),
                    'lxp_usu_mod'=>$this->tank_auth->get_user_id(),
                    'lxp_fecha_mod'=>date('Y-m-d H:i:s')
                );
            $nuevo = $this->gsatelite->ingresar('lxp_alumnoxpensum', $array_nuevo);


            $array_traslado=array(
                'trl_id_alm'=>$id_alm,
                'trl_id_lxp_origen' => $grupo_org,
                'trl_id_lxp_destino' => $nuevo,
                'trl_fecha_traslado'=>date('Y-m-d H:i:s'),
                'trl_observacion'=>$observacion,
                'trl_estado'=>1,
                'trl_usu_creacion'=>$this->tank_auth->get_user_id(),
                'trl_fecha_creacion'=>date('Y-m-d H:i:s'),
                'trl_usu_modificacion'=>$this->tank_auth->get_user_id(),
                'trl_fecha_modificacion'=>date('Y-m-d H:i:s')
            );
            $ingreso = $this->gsatelite->ingresar('trl_traslado_alumno', $array_traslado);
        }
           

        if ($ingreso > 0) {
            $alerta = array(
                  'tipo_alerta' => 'success'
                , 'titulo_alerta' => 'Éxito'
                , 'texto_alerta' => "El traslado fue realizado con éxito"
            );
            $this->session->set_flashdata($alerta);
        }

        echo json_encode(array('exito' => $ingreso));
    }


    /**
     * @author Edith Herrera
     * @since  06-11-2017
     * @return Cargar grupos por area, segun alumno seleccionado.
    * */
     function cargar_GruposxArea($area=null, $edit=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            
            $id_area = $this->input->post('id');
            $alumno = $this->input->post('alumno');

            $grupos_asignados = $this->registro_academico_model->get_grupos_asignados(array('lxa_id_ard'=>$id_area, 'lxa_id_alm'=>$alumno)); 
            $array_gra = array();
            if(count($grupos_asignados)>0){
                foreach ($grupos_asignados as $key ) {
                    $array_gra[]= $key['gra_id'];
                }
            }else{
                $array_gra = null;
            }
          

            $grupos = $this->registro_academico_model->grupos_alumnoxarea(array('lxa_id_ard'=>$id_area), $array_gra);
            

            $opt_dest = '<option value=""></option>';
            if(count($grupos)>0){
                foreach ($grupos as $grp ) {
                    $opt_dest .= '<option value="'.$grp['gra_id'].'">'.$grp['gra_nombre'].'</option>';
                }
            }
            
            echo json_encode($opt_dest);
        }
    }

    /**
     * @author Edith Herrera
     * @since  06-11-2017
     * @return Cargar grupos por area (Gestión de alumnos) o docente (traslado de alumno).
    * */
    function cargar_select_grupos(){
        satelite_validar(true);
        $id_area = $this->input->post('id');
        $id_dct = $this->input->post('docente');
        $id_pyc = $this->input->post('proyeccion');

        if($id_area>0){
            $this->db->where('gra_id_ard', $id_area);
        }else if($id_dct>0){
            $this->db->where('gra_id_dct', $id_dct);
            if($id_pyc>0){
                $this->db->where('gra_id_pyc', $id_pyc);
            }
        }
        
        //$sucursal_str = $this->get_sucursales();                          
        //$this->db->where('gra_id_suc in('.$sucursal_str.')',NULL);

        $select = $this->gsatelite->get_dropdown('gra_grupo_academico', '{gra_nombre}', '', array('gra_estado' => 1,'gra_finalizado IS NULL' => NULL,'gra_cerrado IS NULL' => NULL), null, '', 'gra_id', true);

        $grupos = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

        echo json_encode($grupos);
    }

    /**
     * @author Edith Herrera
     * @since  06-11-2017
     * @return Cargar grupos de origen (modal de traslado de alumno).
    * */
    function cargar_grupos_origen(){
        satelite_validar(true);
        
        $id_area = $this->input->post('area');
        $alumno = $this->input->post('id');
        $grupo = $this->input->post('grupo');

        $grupos_asignados = $this->registro_academico_model->get_grupos_asignados(array('lxa_id_ard'=>$id_area, 'lxa_id_alm'=>$alumno)); 
       // die(print_r($grupos_asignados));
        $array_lxp = array();
        $opt_asig = '<option value=""></option>';
            if(count($grupos_asignados)>0){
                foreach ($grupos_asignados as $grp ) {
                    if($grupo>0 && $grupo==$grp['gra_id']){ $select='selected="selected"'; }else{ $select=''; }
                    $array_lxp[]= $grp->lxp_id;
                    $opt_asig .= '<option value="'.$grp['lxp_id'].'" '.$select.' > '.$grp['gra_nombre'].' </option>';
                    
                }
            }

        echo json_encode($opt_asig);
    }


    /**
     * @author Edith Herrera
     * @since  2017-11-07
     * @return Grid del mantenimiento de entrevistas.
    * */
    function entrevista() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        if ($_POST) {
            $post_array     = $_POST;
            $fecha_inicio   = $post_array['fecha_ini'];
            $fecha_fin      = $post_array['fecha_fin'];
            $where          = null;               
            $sucursal_str   = $this->get_sucursales();                          

            //$where['ene_id_suc in('.$sucursal_str.')'] = NULL;
                        
            if ($fecha_inicio != '' && $fecha_fin != '') {
                $where['date_format(ene_fecha_creacion, "%Y-%m-%d") >='] = formatear_fecha('Y-m-d', $fecha_inicio);
                $where['date_format(ene_fecha_creacion, "%Y-%m-%d") <=' ] = formatear_fecha('Y-m-d', $fecha_fin);
            }
            
            $entrevista = $this->gsatelite->get_tabla('ene_entrevista_estudiante', $where);
            $data['detalles'] = $entrevista;
                 
            $html = $this->load->view('registro_academico/procesos/detalle_entrevista', $data, true);

            echo $html;
        } else {

            $data['titulo_personal'] = "Entrevista al estudiante";
            $this->_cargarvista($data);
        }
    }

    function agregar_entrevista(){
        satelite_validar();
        if($_POST){
            $post_array = $this->input->post();

            $last=$this->consultas->get_max_codigo('ene_entrevista_estudiante', 'ene_numero');
            $code=$last->codigo;
            $cod= (int)$code+1;
            $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

            $tipo = $post_array['id_check'];
            $fecha = ($post_array['txtFecha']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha']):date('Y-m-d H:i:s');
            $nombre_est = $post_array['txtEstudiante'];
            $motivo = ($post_array['txtMotivo']!='')?$post_array['txtMotivo']:null;
            
            $id_padre = ($post_array['hdnIdPadre']!='')?$post_array['hdnIdPadre']:null;
            $id_madre = ($post_array['hdnIdMadre']!='')?$post_array['hdnIdMadre']:null;
            $slc_resp = ($post_array['slcAlumno']!='')?$post_array['slcAlumno']:null;

            $aspecto = ($post_array['txtAspectos']!='')?$post_array['txtAspectos']:null;
            $acuerdo = ($post_array['txtAcuerdo']!='')?$post_array['txtAcuerdo']:null;
            $otros = ($post_array['txtOtros']!='')?$post_array['txtOtros']:null;
            
            $padre = ($post_array['txtPadre']!='')?$post_array['txtPadre']:null;
            $duiPadre = ($post_array['txtDuiPadre']!='')?$post_array['txtDuiPadre']:null;
            $madre = ($post_array['txtMadre']!='')?$post_array['txtMadre']:null;
            $duiMadre = ($post_array['txtDuiMadre']!='')?$post_array['txtDuiMadre']:null;
            $responsable = ($post_array['txtResponsable']!='')?$post_array['txtResponsable']:null;

            $redir = $post_array['redireccion'];
            $sucursal = $this->tank_auth->get_sucursal_id();
            $array_ene = array(
                    'ene_id_fal_padre'  => $id_padre,
                    'ene_id_fal_madre'  => $id_madre,
                    'ene_id_alm'        => $slc_resp,
                    'ene_id_usu'        => $this->tank_auth->get_user_id(),
                    'ene_id_suc'        => ($sucursal > 0) ? $sucursal : null,
                    'ene_numero'        => $codigo,
                    'ene_fecha_creacion' => $fecha,
                    'ene_nombre_estudiante'=>$nombre_est,
                    'ene_acuerdo'=>$acuerdo,
                    'ene_aspecto_tratado'=>$aspecto,
                    'ene_motivo'=>$motivo,
                    'ene_tipo_estudiante'=>$tipo,
                    'ene_otros'=>$otros,
                    'ene_nombre_madre'=>$madre,
                    'ene_dui_madre'=>$duiMadre,
                    'ene_nombre_padre'=>$padre,
                    'ene_dui_padre'=>$duiPadre,
                    'ene_responsable_entrevista' => $responsable,
                    'ene_estado' => 1,
                    'ene_usu_creacion' => $this->tank_auth->get_user_id(),
                    'ene_fecha_creacion' => date('Y-m-d H:i:s'),
                    'ene_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'ene_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                 
            $ingreso = $this->gsatelite->ingresar('ene_entrevista_estudiante', $array_ene);


            if ($ingreso > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la informacion ingresada.");
            }
            $this->session->set_flashdata($alerta);

            if($redir>0){
                redirect('registro_academico/procesos/entrevista');
            }else{
                redirect('registro_academico/procesos/agregar_entrevista');
            }

        }else{
            $last=$this->consultas->get_max_codigo('ene_entrevista_estudiante', 'ene_numero');
            $code=$last->codigo;
            $cod= (int)$code+1;
            $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
            $data['codigo']=$codigo;

            $tipo_dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');

            if($tipo_dui!=''){
                $get_mask = $this->gsatelite->get_campo('tde_tipo_documento', 'tde_mascara', array('tde_id'=>$tipo_dui));
            }
            $data['mascara']=($get_mask!='')?$get_mask:'';

            $data['titulo_personal'] = "Agregar entrevista";
            $this->_cargarvista($data, null);
        }
    }


    /**
     * @author Edith Herrera
     * @since  07-11-2017
     * @return Carga alumnos para dropdown Ajax, buscando por codigo, nombre o apellido.
    * */
    public function get_alumnos_like() {
        satelite_validar(true);
        $alumno = ($this->input->post('alumno') != '') ? $this->input->post('alumno') : null;
        $where  = null;
        $like   = null;
             
        if ($alumno != '') {
            $like['alm_nombre'] = $alumno;
            $like['alm_apellido'] = $alumno;
            $like['alm_codigo'] = $alumno;
        }

        $where['alm_estado'] = 1;
        //$sucursal_str       = $this->get_sucursales();  
        //$where['alm_id_suc in('.$sucursal_str.')'] = NULL;

        $arreglo = array();
        $alumnos = $this->registro_academico_model->get_alumnos_like($where, $like);

        if (count($alumnos) > 0 ) {
            foreach ($alumnos as $key => $value) {
                $arreglo[$key]['alumno'] = $value['alm_id'];
                $arreglo[$key]['alm_nombre'] = $value['alm_codigo'].' - '.$value['alm_nombre'].' '.$value['alm_apellido'];
            }
        }
        echo json_encode($arreglo);
    }

    /**
     * @author Edith Herrera
     * @since  07-11-2017
     * @return Carga información de los familiares del alumno seleccionado.
    * */
    public function get_familiares_alm(){
        satelite_validar(true);

        $id_alm = $this->input->post('id_alm');

        $alumno= $this->gsatelite->get_tabla('alm_alumno', array('alm_id'=>$id_alm));
        $nombre_alm = $alumno[0]['alm_nombre'].' '.$alumno[0]['alm_apellido'];

        $tipo_dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
        $parentescos = $this->gsatelite->get_parametro('SYS_FAMILIARES_ALUMNO');
        
        $nombre_alumno = '';
        $nombre_padre = '';
        $doc_padre = '';
        $nombre_madre = '';
        $doc_madre = ''; $nombre_resp='';
        if($parentescos!='' && $tipo_dui!=''){
            $padre = $this->gsatelite->get_parametro('SYS_FAMILIARES_ALUMNO', null, null, array('PADRE'));
            $madre = $this->gsatelite->get_parametro('SYS_FAMILIARES_ALUMNO', null, null, array('MADRE'));
            if($padre!='' && $madre!=''){
                $pat_padre = $this->gsatelite->verificar_registro_real('pat_parentesco',$padre, true);
                $pat_madre = $this->gsatelite->verificar_registro_real('pat_parentesco',$madre, true);
                
                if($pat_madre==true && $pat_padre==true){

                    $padre_alm = $this->gsatelite->get_registro('fal_familiar_alumno', array('fal_id_alm'=>$id_alm, 'fal_id_pat'=>$padre, 'fal_id_tde'=>$tipo_dui));
                    $madre_alm = $this->gsatelite->get_registro('fal_familiar_alumno', array('fal_id_alm'=>$id_alm, 'fal_id_pat'=>$madre, 'fal_id_tde'=>$tipo_dui));
                    $resp_alm = $this->gsatelite->get_registro('fal_familiar_alumno', array('fal_id_alm'=>$id_alm, 'fal_responsable'=>1));

                    $id_padre=(count($padre_alm)>0)?$padre_alm->fal_id:'';
                    $nombre_padre=(count($padre_alm)>0)?$padre_alm->fal_nombre.' '.$padre_alm->fal_apellido:'';
                    $doc_padre=(count($padre_alm)>0)?$padre_alm->fal_numero_documento:'';
                   
                    $id_madre=(count($madre_alm)>0)?$madre_alm->fal_id:'';
                    $nombre_madre=(count($madre_alm)>0)?$madre_alm->fal_nombre.' '.$madre_alm->fal_apellido:'';
                    $doc_madre=(count($madre_alm)>0)?$madre_alm->fal_numero_documento:'';

                    $nombre_resp=(count($resp_alm)>0)?$resp_alm->fal_nombre.' '.$resp_alm->fal_apellido:'';                       
                }else{
                    $nombre_padre = ''; $doc_padre = ''; $nombre_madre = ''; $doc_madre = ''; $nombre_resp=''; $id_padre='';
                }
            }else{
                $nombre_padre = ''; $doc_padre = ''; $nombre_madre = ''; $doc_madre = ''; $nombre_resp=''; $id_madre='';
            }
        }
       
        echo json_encode(array('nombre_padre'=>$nombre_padre, 'doc_padre'=>$doc_padre, 'nombre_madre'=>$nombre_madre,'doc_madre'=>$doc_madre, 'nombre_resp'=>$nombre_resp, 'id_padre'=>$id_padre, 'id_madre'=>$id_madre, 'nombre_alm'=>$nombre_alm));
    }

    /**
     * @author Edith Herrera
     * @since  08-11-2017
     * @return Editar entrevista.
    * */
    function editar_entrevista($ene_id, $ver=null){
        satelite_validar();
        if($_POST){
            $post_array = $this->input->post();

            $tipo = $post_array['id_check'];
            $id_ene = $post_array['id_ene'];
            $fecha = ($post_array['txtFecha']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha']):date('Y-m-d H:i:s');
            $nombre_est = $post_array['txtEstudiante'];
            $motivo = ($post_array['txtMotivo']!='')?$post_array['txtMotivo']:null;

            $id_padre = ($post_array['hdnIdPadre']!='')?$post_array['hdnIdPadre']:null;
            $id_madre = ($post_array['hdnIdMadre']!='')?$post_array['hdnIdMadre']:null;
            $slc_resp = ($post_array['slcAlumno']!='')?$post_array['slcAlumno']:null;

            $aspecto = ($post_array['txtAspectos']!='')?$post_array['txtAspectos']:null;
            $acuerdo = ($post_array['txtAcuerdo']!='')?$post_array['txtAcuerdo']:null;
            $otros = ($post_array['txtOtros']!='')?$post_array['txtOtros']:null;
            
            $padre = ($post_array['txtPadre']!='')?$post_array['txtPadre']:null;
            $duiPadre = ($post_array['txtDuiPadre']!='')?$post_array['txtDuiPadre']:null;
            $madre = ($post_array['txtMadre']!='')?$post_array['txtMadre']:null;
            $duiMadre = ($post_array['txtDuiMadre']!='')?$post_array['txtDuiMadre']:null;
            $responsable = ($post_array['txtResponsable']!='')?$post_array['txtResponsable']:null;

            $estado = ($post_array['estado']!='')?$post_array['estado']:null;

            $redir = $post_array['redireccion'];

            $array_ene = array(
                    'ene_id_fal_padre'=>$id_padre,
                    'ene_id_fal_madre'=>$id_madre,
                    'ene_id_alm'=>$slc_resp,
                    'ene_id_usu'=>$this->tank_auth->get_user_id(),
                    'ene_fecha_creacion' => $fecha,
                    'ene_nombre_estudiante'=>$nombre_est,
                    'ene_acuerdo'=>$acuerdo,
                    'ene_aspecto_tratado'=>$aspecto,
                    'ene_motivo'=>$motivo,
                    'ene_tipo_estudiante'=>$tipo,
                    'ene_otros'=>$otros,
                    'ene_nombre_madre'=>$madre,
                    'ene_dui_madre'=>$duiMadre,
                    'ene_nombre_padre'=>$padre,
                    'ene_dui_padre'=>$duiPadre,
                    'ene_responsable_entrevista' => $responsable,
                    'ene_estado' => $estado,
                    'ene_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'ene_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                 
            $registro = $this->gsatelite->actualizar_array('ene_entrevista_estudiante', $array_ene, array('ene_id'=>$id_ene));

            if ($registro > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la informacion ingresada.");
            }
            $this->session->set_flashdata($alerta);

            if($redir>0){
                redirect('registro_academico/procesos/entrevista');
            }else{
                redirect('registro_academico/procesos/editar_entrevista/'.$id_ene);
            }

        }else{
                                $this->db->join('alm_alumno', 'alm_id=ene_id_alm', 'left');
            $data['entrevista']=$this->gsatelite->get_registro('ene_entrevista_estudiante', array('ene_id'=>$ene_id));

            $tipo_dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');

            if($tipo_dui!=''){
                $get_mask = $this->gsatelite->get_campo('tde_tipo_documento', 'tde_mascara', array('tde_id'=>$tipo_dui));
            }
            $data['mascara']=($get_mask!='')?$get_mask:'';
            $data['ene_id']=$ene_id;
            $data['ver']=($ver!='')?$ver:null;

            $data['titulo_personal'] = "Editar entrevista";
            $this->_cargarvista($data, null);
        }
    }

    /**
     * @author Edith Herrera
     * @since  08-11-2017
     * @return Eliminar entrevista.
    * */
    function eliminar_entrevista($id_ene = NULL) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $registro = $this->gsatelite->borrado_general('ene_entrevista_estudiante', array('ene_id' => $id_ene));
            
            if($registro>0){
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro borrado", 'texto_alerta' => "El registro se ha borrado correctamente.");            
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "NOTA", 'texto_alerta' => "El registro posee integridad referencial <br />&nbsp;No podrá ser eliminado.");
            }

            $this->session->set_flashdata($alerta);
            redirect('registro_academico/procesos/entrevista');
        }
    }

    /**
     * @author Edith Herrera
     * @since  09-11-2017
     * @return Grid de disponibilidad del docente.
    * */
    function docente_disp(){
        satelite_validar();
        //incluir sucursales
        $where = null;
        $usuario        = $this->tank_auth->get_user_id();    
        $sucurales_array= $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $usuario));
        $sucursales     = array_column($sucurales_array,'usc_id_suc');            
        $sucursal_str   = 0;
        if ( count($sucursales) > 0 ) {   
            $sucursal_str .= ','.implode(",", $sucursales);             
        }   
        //if ( $sucursal_str != '') {
        //    $where['dct_id_suc in('.$sucursal_str.')'] = NULL;
        //} 
        $data['permisos']       = $this->gsatelite->get_permisos_opcion();
        $data['empleados']      = $this->registro_academico_model->obtener_docentes($where);
        $data['titulo_personal']= "Agregar Docente";
        $this->_cargarvista($data);       
    }

     function agregar_disponibilidad(){
        satelite_validar();
        if($_POST){
            $post_array = $this->input->post();

            $redir = $post_array['redireccion'];
            $empleado= $post_array['slcEmpleado'];
            $sucursal = $this->tank_auth->get_sucursal_id();

            $array_dct = array(
                    'dct_id_emp'            => $empleado,
                    'dct_id_suc'            => ($sucursal > 0) ? $sucursal : null,
                    'dct_estado'            => 1,
                    'dct_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'dct_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'dct_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'dct_fecha_modificacion'=> date('Y-m-d H:i:s')
                );
                            
            $ingreso = $this->gsatelite->ingresar('dct_docente', $array_dct);

        /****************************** Frecuencias **********************************/

            $area_det = $post_array['detalle_a'];
            $frecuencia_det = $post_array['detalle_f'];
            if(count($frecuencia_det)>0){
                foreach ($frecuencia_det as $key => $value) {

                    $comprobar_fxa_id = $this->gsatelite->get_campo('fxa_frecuenciaxarea', 'fxa_id', array('fxa_id_frh'=>$value, 'fxa_id_ard'=>$area_det[$key]));

                    $array_fxd=array(
                            'fxd_id_frh' => $value,
                            'fxd_id_fxa' => $comprobar_fxa_id,
                            'fxd_id_dct' => $ingreso,
                            'fxd_estado' => 1,
                            'fxd_usu_creacion' => $this->tank_auth->get_user_id(),
                            'fxd_fecha_creacion' => date('Y-m-d H:i:s'),
                            'fxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'fxd_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    $this->gsatelite->ingresar('fxd_frecuenciaxdocente', $array_fxd);
                }
            }

        /****************************** Curso / Nivel **********************************/

            $area_de = $post_array['detalle_arm'];
            $nivel_de = $post_array['detalle_n'];

            if(count($nivel_de)>0){
                foreach ($nivel_de as $key => $value) {
                    $array_mpd=array(
                            'mpd_id_dct' => $ingreso,
                            'mpd_id_pen'=> $value,
                            'mpd_estado' => 1,
                            'mpd_usu_creacion' => $this->tank_auth->get_user_id(),
                            'mpd_fecha_creacion' => date('Y-m-d H:i:s'),
                            'mpd_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'mpd_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    $this->gsatelite->ingresar('mpd_modulo_pensumxdocente', $array_mpd);
                } 
            } 

        /****************************** Escalafón **********************************/

            $categoria_de = $post_array['detalle_cat'];
            $clase_de = $post_array['detalle_cl'];

            if(count($clase_de)>0){
                foreach ($clase_de as $key => $value) {
                    $array_exd=array(
                            'exd_id_dct' => $ingreso,
                            'exd_id_tbe'=> $value,
                            'exd_estado' => 1,
                            'exd_usu_creacion' => $this->tank_auth->get_user_id(),
                            'exd_fecha_creacion' => date('Y-m-d H:i:s'),
                            'exd_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'exd_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    $this->gsatelite->ingresar('exd_escalafonxdocente', $array_exd);
                } 
            }          

            if ($ingreso > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la informacion ingresada.");
            }
            $this->session->set_flashdata($alerta);

            if($redir>0){
                redirect('registro_academico/procesos/docente_disp');
            }else{
                redirect('registro_academico/procesos/agregar_disponibilidad');
            }

        }else{

            $sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_estado'=>1,'usc_id_usu'=>$this->tank_auth->get_user_id()));

            $where = (count($sucursal) > 0) ? 'ard_estado = 1 AND (ard_id_suc IS NULL OR ard_id_suc = '.$sucursal[0]['usc_id_suc'].')': 'ard_estado = 1';

            $select = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', $where, null, '', 'ard_id', true);
            $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

            $categoria = $this->gsatelite->get_dropdown('ctf_categoria_escalafon', '{ctf_nombre}', '', array('ctf_estado' => 1), null, '', 'ctf_id', true);
            $data["categoria"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $categoria);
            
            $data['titulo_personal'] = "Agregar Docente";
            $this->_cargarvista($data, null);
        }
    }

    /**
     * @author Edith Herrera
     * @since  10-11-2017
     * @return Cargar información del empleado.
     **/

    function get_empleado($id_emp=null){

        if($id_emp!=null){
            satelite_validar(true);
            // Se obtiene información del empleao para mostrarse como familiar del alumno.
            
            $empleado = $this->registro_academico_model->get_info_empleado(array('emp_id'=>$id_emp)); 

            $nombre_emp = $empleado->emp_nombre.' '.$empleado->emp_apellido;
            $telefono = $this->personal_model->editar_tel_empleado($id_emp, 'txm_id DESC', 1);
            $documento = $this->personal_model->editar_doc_empleado($id_emp, 'dce_id DESC', 1);

                       $this->db->limit(1);
                       $this->db->order_by('cxp_id', 'DESC');
            $correo = $this->gsatelite->get_tabla('cxp_correoxempleado', array('cxp_id_emp' => $id_emp, 'cxp_estado' => 1));
            $arr_emp=array(
                'fal_nombre'=>$empleado->emp_nombre, 
                'fal_apellido'=>$empleado->emp_apellido,
                'fal_fecha_nacimiento'=>($empleado->emp_fecha_nac!='')?formatear_fecha('d-m-Y', $empleado->emp_fecha_nac):'',
                'fal_telefono'=>(isset($telefono[0]['tel_numero']))?$telefono[0]['tel_numero']:'',
                'fal_id_pro'=>($empleado->emp_id_pro!='')?$empleado->emp_id_pro:'', 
                'fal_correo'=>(isset($correo[0]['cxp_correo']))?$correo[0]['cxp_correo']:'',
                'fal_id_tde'=>($documento[0]['tde_id'])?$documento[0]['tde_id']:'',
                'fal_numero_documento'=> ($documento[0]['dce_valor'])?$documento[0]['dce_valor']:'',
                'fal_lugar_trabajo'=>$empleado->suc_nombre,
                'fal_direccion_trabajo'=>$empleado->suc_direccion,
                'fal_salario'=>$empleado->emp_salario,
                'pro_nombre'=>($empleado->pro_nombre!='')?$empleado->pro_nombre:'',
                'tde_nombre'=>($documento[0]['tde_nombre'])?$documento[0]['tde_nombre']:''
                );
           
            return $arr_emp;

        }else{ 
            satelite_validar(true);
            $id_empleado = $this->input->post('empleado');
            $id_dct = $this->input->post('docente');

            /***************** Se valida la existencia del empleado como un docente *******************/
                if($id_dct>0){ $this->db->where('dct_id !=', $id_dct); }
            $es_docente = $this->gsatelite->get_registro('dct_docente', array('dct_id_emp'=>$id_empleado));
           

                $arr_emp=array('docente'=>1);
               
                $empleado = $this->registro_academico_model->get_info_empleado(array('emp_id'=>$id_empleado)); 

                $nombre_emp = $empleado->emp_nombre.' '.$empleado->emp_apellido;
                $telefono = $this->personal_model->editar_tel_empleado($id_empleado, 'txm_id DESC', 1);
                $documento = $this->personal_model->editar_doc_empleado($id_empleado, 'dce_id DESC', 1);

                           $this->db->limit(1);
                           $this->db->order_by('cxp_id', 'DESC');
                $correo = $this->gsatelite->get_tabla('cxp_correoxempleado', array('cxp_id_emp' => $id_empleado, 'cxp_estado' => 1));
                $arr_emp=array(
                    'profesion'=>($empleado->pro_nombre!='')?$empleado->pro_nombre:'', 
                    'genero'=>($empleado->gen_nombre!='')?$empleado->gen_nombre:'', 
                    'nombre'=>($nombre_emp!='')?$nombre_emp:'', 
                    'id_pro'=>($empleado->emp_id_pro!='')?$empleado->emp_id_pro:'', 
                    'emp_nombre'=>$empleado->emp_nombre, 
                    'apellido'=>$empleado->emp_apellido,
                    'fecha'=>($empleado->emp_fecha_nac!='')?formatear_fecha('d-m-Y', $empleado->emp_fecha_nac):'',
                    'telefono'=>(count($telefono)>0 && $telefono[0]['tel_numero'])?$telefono[0]['tel_numero']:'',
                    'correo'=>(count($correo)>0 && $correo[0]['cxp_correo'])?$correo[0]['cxp_correo']:'',
                    'tipoDoc'=>(count($documento)>0 && $documento[0]['tde_id'])?$documento[0]['tde_id']:'',
                    'documento'=> (count($documento)>0 && $documento[0]['dce_valor'])?$documento[0]['dce_valor']:'',
                    'sucursal'=>$empleado->suc_nombre,
                    'direccion_suc'=>$empleado->suc_direccion,
                    'salario'=>$empleado->emp_salario,
                    'docente'=> (count($es_docente)>0) ? 1:0
                    );
            

           
            echo json_encode($arr_emp);
        }

    }

     /**
     * @author Edith Herrera
     * @since  10-11-2017
     * @return Cargar frecuencias por área.
     **/
    function get_frecuencias(){
        satelite_validar(true);
        $area = $this->input->post('area');
                      $this->db->join('fxa_frecuenciaxarea', 'frh_id = fxa_id_frh');
        $frecuencia = $this->gsatelite->get_dropdown('frh_frecuencia_horario', '{frh_nombre}', '', array('frh_estado' => 1, 'fxa_id_ard'=>$area), null, '', 'frh_id', true);
        $select_frh = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $frecuencia);
        echo json_encode($select_frh);
    }


    function editar_disponibilidad($dct_id=null, $ver=null){
        satelite_validar();
        if($_POST){
            // var_dump($_POST);die();
            $post_array = $this->input->post();
            $redir = $post_array['redireccion'];
            $dct_id = $post_array['dct_id'];
            $estado = ($post_array['estado'] != '') ? $post_array['estado'] : 1;
            $empleado = $post_array['slcEmpleado'];

            $array_dct = array(
                'dct_id_emp' =>$empleado,
                'dct_estado' => $estado,
                'dct_usu_modificacion' => $this->tank_auth->get_user_id(),
                'dct_fecha_modificacion' => date('Y-m-d H:i:s')
            );                            
            $ingreso = $this->gsatelite->actualizar_array('dct_docente', $array_dct, array('dct_id'=>$dct_id));
            /************************************ Frecuencia *****************************************/
            $ids_fxd = $post_array['ids_fxd']; 
            $area_det = $post_array['detalle_a'];
            $frecuencia_det = $post_array['detalle_f'];
            $this->gsatelite->borrado_general('fxd_frecuenciaxdocente', array('fxd_id_dct'=>$dct_id));           
            if(count($ids_fxd) > 0){
                foreach ($frecuencia_det as $k => $value) {
                    $comprobar_fxa_id = $this->gsatelite->get_campo('fxa_frecuenciaxarea', 'fxa_id', array('fxa_id_frh'=>$value, 'fxa_id_ard'=>$area_det[$k]));
                    $array_fxd = array(
                        'fxd_id_frh' => $value,
                        'fxd_id_fxa' => $comprobar_fxa_id,
                        'fxd_id_dct' => $dct_id,
                        'fxd_estado' => 1,
                        'fxd_usu_creacion' => $this->tank_auth->get_user_id(),
                        'fxd_fecha_creacion' => date('Y-m-d H:i:s'),
                        'fxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'fxd_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('fxd_frecuenciaxdocente', $array_fxd);
                }
            }           
            /************************************ Curso/ Nivel *****************************************/
            $ids_mpd = $post_array['ids_mpd'];
            $area_de = $post_array['detalle_arm'];
            $nivel_de = $post_array['detalle_n'];
            $this->gsatelite->borrado_general('mpd_modulo_pensumxdocente', array('mpd_id_dct'=>$dct_id));
            if(count($ids_mpd)>0){
                foreach ($nivel_de as $key => $value) {
                    $array_mpd=array(
                            'mpd_id_dct' => $dct_id,
                            'mpd_id_pen'=> $value,
                            'mpd_estado' => 1,
                            'mpd_usu_creacion' => $this->tank_auth->get_user_id(),
                            'mpd_fecha_creacion' => date('Y-m-d H:i:s'),
                            'mpd_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'mpd_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    $this->gsatelite->ingresar('mpd_modulo_pensumxdocente', $array_mpd);
                } 
            }          
            /************************************ Escalafón *****************************************/
            $ids_exd = $post_array['ids_exd'];
            $categoria_de = $post_array['detalle_cat'];
            $clase_de = $post_array['detalle_cl'];
            $this->gsatelite->borrado_general('exd_escalafonxdocente', array('exd_id_dct'=>$dct_id));
            if(count($ids_exd) > 0){
                foreach ($clase_de as $key => $value) {
                    if(($value) > 0){
                        $array_mpd=array(
                                'exd_id_dct' => $dct_id,
                                'exd_id_tbe'=> $value,
                                'exd_estado' => 1,
                                'exd_usu_creacion' => $this->tank_auth->get_user_id(),
                                'exd_fecha_creacion' => date('Y-m-d H:i:s'),
                                'exd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'exd_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                        $this->gsatelite->ingresar('exd_escalafonxdocente', $array_mpd);
                    }
                } 
            }
            if ($ingreso > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro actualizado", 'texto_alerta' => "El registro se ha actualizado correctamente.");
            } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no actualizado", 'texto_alerta' => "El registro no pudo ser actualizado, verifique la informacion ingresada.");
            }
            $this->session->set_flashdata($alerta);

            if($redir>0){
                redirect('registro_academico/procesos/docente_disp');
            }else{
                redirect('registro_academico/procesos/editar_disponibilidad/'.$dct_id);
            }

        }else{
            $data['registro']    = $this->registro_academico_model->get_docentes(array('dct_id'=>$dct_id));// detalles de frecuencia
            $data['detalle_fxd'] = $this->registro_academico_model->get_docentes(array('dct_id'=>$dct_id), 1); //Detalles de frecuencia
            $data['detalle_mpd'] = $this->registro_academico_model->get_docentes(array('dct_id'=>$dct_id), 2); //Detalles de curso/nivel
            $data['detalle_exd'] = $this->registro_academico_model->get_docentes(array('dct_id'=>$dct_id), 3); //Detalles de escalofon
            // var_dump($this->db->last_query());die();
            $select = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1), null, '', 'ard_id', true);
            $data["areas"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);
            $categoria = $this->gsatelite->get_dropdown('ctf_categoria_escalafon', '{ctf_nombre}', '', array('ctf_estado' => 1), null, '', 'ctf_id', true);
            $data["categoria"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $categoria);
            $data['dct_id'] = $dct_id;
            $data['ver'] = ($ver!=null)?$ver:0;
            if($ver!=null){
                $data['titulo_personal'] = "Ver Docente";
            }else{
                $data['titulo_personal'] = "Editar Docente";
            }
            $this->_cargarvista($data, null);
        }
    }

    /**
     * @author Edith Herrera
     * @since  13-11-2017
     * @return Cargar frecuencias por área (dropdown de grupos).
     **/
    function cargar_frecuencia(){
        satelite_validar(true);
        $area = $this->input->post('area');
        $verificar_frh_id_ard = $this->gsatelite->get_tabla('frh_frecuencia_horario', array('frh_id_ard'=>$area));
        if(count($verificar_frh_id_ard) > 0) {
            $select = $this->gsatelite->get_dropdown('frh_frecuencia_horario', '{frh_nombre}', '', array('frh_estado' => 1, 'frh_id_ard'=>$area), null, '', 'frh_id', true);
            $frecuencias = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);
        } else {
                      $this->db->join('frh_frecuencia_horario', 'frh_id = fxa_id_frh');
            $select = $this->gsatelite->get_dropdown('fxa_frecuenciaxarea', '{frh_nombre}', '', array('fxa_estado' => 1, 'frh_estado' => 1, 'fxa_id_ard' => $area), null, '', 'fxa_id_frh', true);
            $frecuencias = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);
        }
        echo $frecuencias;
    }

    /**
     * @author Edith Herrera
     * @since  13-11-2017
     * @return Cargar docente por nivel y/o frecuencia (dropdown de grupos) .
     **/
    function cargar_docente(){
        satelite_validar(true);
        $edit       = $this->input->post('edit'); //""
        $nivel      = $this->input->post('nivel'); //"3"
        $frecuencia = $this->input->post('frecuencia'); ///""
        $pluriclase = $this->input->post('pluriclase'); //"0"
        $proyeccion = $this->input->post('proyeccion'); //"5" 
        $sucursal_str= $this->get_sucursales();

        $where['dct_id_suc IN('.$sucursal_str.')'] = NULL;        
        if($proyeccion>0){
            $reg_pyc = $this->gsatelite->get_registro('pyc_proyeccion', array('pyc_id'=>$proyeccion, 'pyc_estado'=>1));
            $fecha_ini = formatear_fecha('Y-m-d', $reg_pyc->pyc_fecha_inicio);
            $fecha_fin = formatear_fecha('Y-m-d', $reg_pyc->pyc_fecha_fin);
            $where["((DATE(pyc_fecha_inicio) <= '$fecha_ini' AND DATE(pyc_fecha_fin) >= '$fecha_ini') OR (DATE(pyc_fecha_inicio) <= '$fecha_fin' AND DATE(pyc_fecha_fin) >= '$fecha_fin'))"] = NULL;
        }
        $having = null;
        $where['gra_estado'] = 1;
        $where['(gra_cerrado IS NULL OR gra_cerrado = 0)'] = NULL;
        if ($frecuencia > 0) {
            $where['gra_id_frh'] = $frecuencia;
        }
        $asignado = $this->registro_academico_model->get_infoxfrecuencia($where, 'dct_id'); 
        $arr_asignado = array_column($asignado, "dct_id");
      
        $not_in = '0';
        if(count($asignado)>0){
            $not_in = implode(',', array_column($asignado, "dct_id"));
        }

        $where=array();
        if($nivel!=null){
            $where['pen_id']=$nivel;
        }

        if($edit>0){
            $dct_grupo = $this->gsatelite->get_campo('gra_grupo_academico', 'gra_id_dct', array('gra_id'=>$edit));
        }else{
            $dct_grupo = 0;
        }

        if($frecuencia!=null && $edit!=''){
            $having['frh_id'] = $frecuencia;
            if ($pluriclase != 1 && !in_array($dct_grupo, $arr_asignado)) {
                $where["dct_id not in ($not_in)"] = null;
            }
        }else{
            if ($frecuencia > 0) {
                $having['frh_id'] = $frecuencia;
            }
            if ($pluriclase != 1) {
                $where["dct_id not in ($not_in)"] = null;
            }
        }

        // Validación para verificar que no se muestre docente que tenga el horario solicitado
        $docentes = $this->registro_academico_model->get_docentes($where, null, $having);
        $select='';
        $opt_doc = '<option value=""></option>';
        if(count($docentes)>0){

            foreach ($docentes as $llave => $docente) {
                $select = ($edit > 0 && $dct_grupo == $docente['dct_id']) ? 'selected' : '';
                $opt_doc.='<option value="'.$docente['dct_id'].'" '.$select.' >'.$docente['emp_nombre'].' '.$docente['emp_apellido'].'</option>';
            }
        }
        echo $opt_doc;
    }

    /**
     * @author Edith Herrera
     * @since  13-11-2017
     * @return verificar que el registro sea [unico de acuerdo a los datos recibidos.
     **/
    function validar_grupo_unico(){
        satelite_validar(true);

        $edit = $this->input->post('edit');
        $nivel = $this->input->post('nivel');
        $frecuencia = $this->input->post('frecuencia');
        $seccion = $this->input->post('seccion');
        $proyeccion = $this->input->post('proyeccion');

        $where=array();

        if($edit!=null && $edit!=''){
            $where['gra_id !=']=$edit;
        }
        if($nivel!=null){
            $where['gra_id_pen']=$nivel;
        }

        if($frecuencia!=null){
            $where['gra_id_frh']=$frecuencia;
        }
        if($seccion!=null){
            $where['gra_id_scc']=$seccion;
        }
        if($proyeccion!=null){
            $where['gra_id_pyc']=$proyeccion;
        }

        $registro = $this->gsatelite->get_registro('gra_grupo_academico', $where);
        
        if(count($registro)>0){ $resp = 1; }else{ $resp=0; }
        echo json_encode($resp);
    }

    /**
     * @author Edith Herrera
     * @since  15-11-2017
     * @return Grid prácticas profesionales (gestión de alumnos).
    * */
    function practica_profesional($id_alm) {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('acciones_alumno');

        $data['alumno'] = $this->gsatelite->get_registro('alm_alumno', array('alm_id'=>$id_alm));
                             $this->db->join('lgp_lugar_practicas', 'lgp_id=pcf_id_lgp');
        $data['registros'] = $this->gsatelite->get_tabla('pcf_practica_profesional');
     
        $data['titulo_personal'] = "Prácticas profesionales";
        $this->_cargarvista($data);
    }

    /**
     * @author Edith Herrera
     * @since  16-11-2017
     * @return Agregar práctica profesional.
    **/
     function agregar_practica($id_alm){
        satelite_validar();
        if($_POST){
            $post_array = $this->input->post();
            
            $id_alm = $post_array['txtAlmid'];
            $fecha_ini = ($post_array['txtFecha_ini']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha_ini']):null;
            $fecha_fin = ($post_array['txtFecha_fin']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha_fin']):null;
           
            $redir = $post_array['redireccion'];

            $nombre_carpeta = $this->input->post('nombre_anexo_carpeta');
            $anexos = $this->input->post('ruta');
            $titulos_doc = $this->input->post('titulo_doc');

            $array_pcf = array(
                    'pcf_id_alm' =>$id_alm,
                    'pcf_id_lgp' => $post_array['slcLugar'],
                    'pcf_fecha_inicio' => $fecha_ini,
                    'pcf_fecha_fin' => $fecha_fin,
                    'pcf_actividad_realiza' => ($post_array['txtObjetivo']!='')?$post_array['txtObjetivo']:null,
                    'pcf_observacion' => ($post_array['txtObservacion']!='')?$post_array['txtObservacion']:null,
                    'pcf_empleabilidad' =>($post_array['id_check']>1)?1:0,
                    'pcf_plaza' => ($post_array['txtPlaza']!='')?$post_array['txtPlaza']:null,
                    'pcf_estado' => 1,
                    'pcf_usu_creacion' => $this->tank_auth->get_user_id(),
                    'pcf_fecha_creacion' => date('Y-m-d H:i:s'),
                    'pcf_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'pcf_fecha_modificacion' => date('Y-m-d H:i:s')
                );
            //die(print_r($_POST));
                            
            $ingreso = $this->gsatelite->ingresar('pcf_practica_profesional', $array_pcf);
   

            /**************************** ANEXOS *********************************************************/
                if($ingreso > 0){
                    //Anexos
                    if(count($anexos) > 0 && $anexos !=''){
                        for ($i=0; $i < count($anexos); $i++){
                           $extension =end(explode(".",$anexos[$i]));
                           $ruta_destino = "uploads/".$nombre_carpeta."/".$titulos_doc[$i].".".$extension;
                           $ruta_temp = "public/temp/".$nombre_carpeta."/".$anexos[$i];

                           $anv_array = array(
                                'anp_id_pcf' =>  $ingreso,
                                'anp_url' => $ruta_destino,
                                'anp_nombre' => $titulos_doc[$i],
                                'anp_estado' => 1,
                                'anp_fecha_creacion' => date('Y-m-d H:i:s'),
                                'anp_fecha_modificacion' => date('Y-m-d H:i:s'),
                                'anp_usu_creacion' => $this->tank_auth->get_user_id(),
                                'anp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            );

                           $axn_id = $this->gsatelite->ingresar('anp_anexo_practica',$anv_array);
                           if($axn_id>0){
                                if(!copy($ruta_temp,$ruta_destino)){
                                    //die('No se pudo copiar el archivo');
                                }
                                unlink($ruta_temp);
                            }
                            
                        }
                    }
                }
            /*********************************************************************************************/

            if ($ingreso > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la informacion ingresada.");
            }
            $this->session->set_flashdata($alerta);

            if($redir>0){
                redirect('registro_academico/procesos/practica_profesional/'.$id_alm);
            }else{
                redirect('registro_academico/procesos/agregar_practica');
            }

        }else{
            $lugar = $this->gsatelite->get_dropdown('lgp_lugar_practicas', '{lgp_nombre}', '', array('lgp_estado' => 1), null, '', 'lgp_id', true);
            $data["lugar"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $lugar);

            $data['alumno'] = $this->gsatelite->get_registro('alm_alumno', array('alm_id'=>$id_alm));

            $data['titulo_personal'] = "Agregar práctica profesional";
            $this->_cargarvista($data, null);
        }
    }

    /**
     * @author Edith Herrera
     * @since  16-11-2017
     * @return Editar práctica profesional.
    **/
     function editar_practica($pcf_id=null, $ver=null){
        satelite_validar();
        if($_POST){
            $post_array = $this->input->post();
            
            $id_alm = $post_array['txtAlmid'];
            $fecha_ini = ($post_array['txtFecha_ini']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha_ini']):null;
            $fecha_fin = ($post_array['txtFecha_fin']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha_fin']):null;
           
            $redir = $post_array['redireccion'];
            $pcf_id = $post_array['txt_idPcf'];

            $nombre_carpeta = $this->input->post('nombre_anexo_carpeta');
            $anexos = $this->input->post('ruta');
            $titulos_doc = $this->input->post('titulo_doc');

            $array_pcf = array(
                    'pcf_id_alm' =>$id_alm,
                    'pcf_id_lgp' => $post_array['slcLugar'],
                    'pcf_fecha_inicio' => $fecha_ini,
                    'pcf_fecha_fin' => $fecha_fin,
                    'pcf_actividad_realiza' => ($post_array['txtObjetivo']!='')?$post_array['txtObjetivo']:null,
                    'pcf_observacion' => ($post_array['txtObservacion']!='')?$post_array['txtObservacion']:null,
                    'pcf_empleabilidad' =>($post_array['id_check']>1)?1:0,
                    'pcf_plaza' => ($post_array['txtPlaza']!='')?$post_array['txtPlaza']:null,
                    'pcf_estado' => 1,
                    'pcf_usu_creacion' => $this->tank_auth->get_user_id(),
                    'pcf_fecha_creacion' => date('Y-m-d H:i:s'),
                    'pcf_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'pcf_fecha_modificacion' => date('Y-m-d H:i:s')
                );
            //die(print_r($pcf_id));
                            
            $ingreso = $this->gsatelite->actualizar_array('pcf_practica_profesional', $array_pcf, array('pcf_id'=>$pcf_id));
   

            /**************************** ANEXOS *********************************************************/
                if($ingreso > 0){
                    //Anexos
                    if(count($anexos) > 0 && $anexos !=''){
                        for ($i=0; $i < count($anexos); $i++){
                           $extension =end(explode(".",$anexos[$i]));
                           $ruta_destino = "uploads/".$nombre_carpeta."/".$titulos_doc[$i].".".$extension;
                           $ruta_temp = "public/temp/".$nombre_carpeta."/".$anexos[$i];

                           $anv_array = array(
                                'anp_id_pcf' =>  $pcf_id,
                                'anp_url' => $ruta_destino,
                                'anp_nombre' => $titulos_doc[$i],
                                'anp_estado' => 1,
                                'anp_fecha_creacion' => date('Y-m-d H:i:s'),
                                'anp_fecha_modificacion' => date('Y-m-d H:i:s'),
                                'anp_usu_creacion' => $this->tank_auth->get_user_id(),
                                'anp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            );

                           $axn_id = $this->gsatelite->ingresar('anp_anexo_practica',$anv_array);
                           if($axn_id>0){
                                if(!copy($ruta_temp,$ruta_destino)){
                                    //die('No se pudo copiar el archivo');
                                }
                                unlink($ruta_temp);
                            }
                            
                        }
                    }
                }
            /*********************************************************************************************/

            if ($ingreso > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la informacion ingresada.");
            }
            $this->session->set_flashdata($alerta);

            if($redir>0){
                redirect('registro_academico/procesos/practica_profesional/'.$id_alm);
            }else{
                redirect('registro_academico/procesos/editar_practica/'.$pcf_id);
            }

        }else{

            $data['registro'] = $reg = $this->registro_academico_model->get_info_practica(array('pcf_id'=>$pcf_id));
                
            $data['ver'] = ($ver!=null)?$ver:0;

            $lugar = $this->gsatelite->get_dropdown('lgp_lugar_practicas', '{lgp_nombre}', '', array('lgp_estado' => 1), $reg[0]['pcf_id_lgp'], '', 'lgp_id', true);
            $data["lugar"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $lugar);

            $data['titulo_personal'] = "Agregar práctica profesional";
            $this->_cargarvista($data, null);
        }
    }

    function eliminar_practica($id_pcf = NULL, $alm_id=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $registro = $this->gsatelite->borrado_general('anp_anexo_practica', array('anp_id_pcf' => $id_pcf));
               
            $registro = $this->gsatelite->borrado_general('pcf_practica_profesional', array('pcf_id' => $id_pcf));
            
            if($registro>0){
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro borrado", 'texto_alerta' => "El registro se ha borrado correctamente.");            
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "NOTA", 'texto_alerta' => "El registro posee integridad referencial <br />&nbsp;No podrá ser eliminado.");
            }

            $this->session->set_flashdata($alerta);
            redirect('registro_academico/procesos/practica_profesional/'.$alm_id);
        }
    }

    /**
     * @author Edith Herrera
     * @since  21-11-2017
     * @return Cargar clase.
     **/
    function cargar_clase(){
        satelite_validar(true);
        $categoria = $this->input->post('categoria');

        $escalafon = $this->gsatelite->get_dropdown('tbe_tabla_escalafon', '{tbe_clase}', '', array('tbe_estado' => 1, 'tbe_id_ctf'=>$categoria), null, '', 'tbe_id', true);
        $select_tbe = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $escalafon);       
        echo json_encode($select_tbe);
    }

    /**
     * @author Edith Herrera
     * @since  22-11-2017
     * @return Impresión de la solicitud de beca y autorización.
     **/
    public function imprimir_autorizacion($id_solicitud)
    {
        satelite_validar();
        
        try {
            $solicitud = $this->registro_academico_model->get_info_solicitud(array('slb_id'=>$id_solicitud));
            $data['solicitud'] = $solicitud[0];

                        $this->db->limit(1);
                        $this->db->order_by('tal_id', 'DESC');
            $telefono = $this->gsatelite->get_tabla('tal_telefonoxalumno', array('tal_id_alm'=>$solicitud[0]['slb_id_alm']));
            $data['telefono'] = $telefono[0]['tal_numero'];


                        $this->db->limit(1);
                        $this->db->order_by('tal_id', 'DESC');
            $telefono = $this->gsatelite->get_tabla('tal_telefonoxalumno', array('tal_id_alm'=>$solicitud[0]['slb_id_alm']));
            $data['correo'] = $telefono[0]['tal_numero'];

            $tipo_dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
            $tipo_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');

                          $this->db->limit(1);
                          $this->db->order_by('dca_id', 'DESC');
            $data['DUI'] = $this->gsatelite->get_tabla('dca_documento_alumno', array('dca_id_alm'=>$solicitud[0]['slb_id_alm'], 'dca_id_tde'=>$tipo_dui));

                          $this->db->limit(1);
                          $this->db->order_by('dca_id', 'DESC');
            $data['NIT'] = $this->gsatelite->get_tabla('dca_documento_alumno', array('dca_id_alm'=>$solicitud[0]['slb_id_alm'], 'dca_id_tde'=>$tipo_nit));


            $data['frecuencia'] = $frecuencia = $this->registro_academico_model->get_frecuencias(array('dfr_id_frh'=>$solicitud[0]['frh_id']));

            //$html = $this->load->view('registro_academico/procesos/detalle_frecuencia', $data, true);
            //die(print_r($this->db->last_query()));
            //die(print_r($telefono));
            $rows=$this->load->view('reporte/header', array('titulo' => "Solicitud de Beca"), true);

            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']     = $rows;
            $data['filename']         = $filename;
            
            $this->pdf->reportePDF('registro_academico/procesos/imprimir_autorizacion', $data); 
        } catch(Exception $e){
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }
    }


    /**
     * Descripción:
     * Función para mostrar la lista de asistencia
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-20
     * @param ninguno
     * @return Mostrar la lista de asistencia
     */

    function asistencia_grupo() {
        satelite_validar();
         $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        if ($this->input->post()) {
            $proyeccion = $this->input->post('proyeccion');
            $area       = $this->input->post('area');
            $grupo      = $this->input->post('grupo');
            $user       = $this->tank_auth->get_user_id();

            $sucurales_array= $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $user));
            $sucursales     = array_column($sucurales_array,'usc_id_suc');            
            $sucursal_str   = 0;
            if ( count($sucursales) > 0 ) {   
                $sucursal_str .= ','.implode(",", $sucursales);             
            }             
            // $this->db->where('gra_id_suc in('.$sucursal_str.')',NULL);

            if ($grupo != NULL) {
                $where['asg_id_gra'] = $grupo;
            }
            $where['asg_estado'] = 1;
            $data['asistencias'] = $this->registro_academico_model->obtener_asistencia_grupo($where, 'asg_id');
               
            $html = $this->load->view('registro_academico/procesos/detalle_asistencia_grupo', $data, true);
            echo json_encode(array('html'=>$html));
        } else {
            $user= $this->tank_auth->get_user_id();
            $emp = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id'=>$user));
            $dct = $this->gsatelite->get_campo('dct_docente', 'dct_id', array('dct_id_emp'=>$emp));  
            
            //$sucurales_array= $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $user));
            //$sucursales     = array_column($sucurales_array,'usc_id_suc');            
            //$sucursal_str   = 0;
            //if ( count($sucursales) > 0 ) {   
            //    $sucursal_str .= ','.implode(",", $sucursales);             
            //}             
            //$this->db->where('gra_id_suc in('.$sucursal_str.')',NULL);
          
            if($dct > 0 ){
                $this->db->where('gra_id_dct', $dct);
            }

            $this->db->join('gra_grupo_academico','pyc_id = gra_id_pyc');
            $data['proyeccion'] = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);

            $data['titulo_personal'] = 'Asistencia de Grupo';
            $this->_cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función seleccionar areas academicas
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-21
     * @param ninguno
     * @return Para ajax, seleccionar areas academicas
     */
    function select_areas_academica() {
        satelite_validar();
        
        if ($this->input->post()) {
            $pyc = $this->input->post('proyeccion');

            $sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_estado'=>1,'usc_id_usu'=>$this->tank_auth->get_user_id()));

            $where = (count($sucursal) > 0) ? 'ard_estado = 1 AND (pyc_id = '.$pyc.' OR axy_id_pyc = '.$pyc.') AND (ard_id_suc IS NULL OR ard_id_suc = '.$sucursal[0]['usc_id_suc'].')': 'ard_estado = 1 AND (pyc_id = '.$pyc.' OR axy_id_pyc = '.$pyc.')';
            
                $this->db->join('pyc_proyeccion', 'pyc_id_ard=ard_id', 'LEFT');
                $this->db->join('axy_areas_x_proyecion', 'axy_id_ard = ard_id', 'LEFT');
                $this->db->group_by('ard_id');
            $areas = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', $where, null, '', 'ard_id', true);
            $html = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $areas);

            echo json_encode(array('areas'=>$html));
            die();
        }
    }

    /**
     * Descripción:
     * Función para seleccionar grupo de asistencia
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-21
     * @param ninguno
     * @return ajax para seleccionar grupo de asistencia
     */
    function select_grupo_asistencia() {
        satelite_validar();
        if ($this->input->post()) {
            $proyeccion = $this->input->post('proyeccion');
            $area = $this->input->post('area');
            $user = $this->tank_auth->get_user_id();

                        $this->db->join('emp_empleado', 'usu_id_emp = emp_id');
                        $this->db->join('dct_docente', 'dct_id_emp = emp_id', 'left');
            $registro = $this->gsatelite->get_tabla('users', array('id'=>$user));

           
            if(count($registro)>0 && $registro[0]['dct_id']>0){
                $docente = $registro[0]['dct_id'];
                $consulta_gra = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id_pyc'=>$proyeccion, 'gra_id_ard'=>$area, 'gra_estado'=>1, 'gra_id_dct'=>$docente));
            }else{
                $consulta_gra = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id_pyc'=>$proyeccion, 'gra_id_ard'=>$area, 'gra_estado'=>1));
            }
            
            
            $html = '<option value=""></option>';
            foreach ($consulta_gra as $key => $value) {
                $html .= '<option value="'.$value['gra_id'].'">'.$value['gra_nombre'].'</option>';
            }
            $grupos = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $html);
            echo json_encode(array('grupos'=>$grupos));
        }
    }

    /**
     * Descripción:
     * Función para lista de asistencia
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-20
     * @param ninguno
     * @return Mostrar la lista de asistentes
     */    
    function lista_asistencia($grupo = null) {
        satelite_validar();

        // Se declaro variables
        $pyc_grupo = null;
        $pyc_id    = null;

        if ($grupo != null) {
            $pyc_grupo = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id'=>$grupo, 'gra_estado'=>1));
        }

        $pyc_id = (count($pyc_grupo)>0)?$pyc_grupo[0]['gra_id_pyc']:null;

        $user = $this->tank_auth->get_user_id();
        $emp = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id'=>$user));
        $dct = $this->gsatelite->get_campo('dct_docente', 'dct_id', array('dct_id_emp'=>$emp));

        //incluir sucursales
        $sucurales_array= $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $user));
        $sucursales     = array_column($sucurales_array,'usc_id_suc');            
        $sucursal_str   = 0;
        if ( count($sucursales) > 0 ) {   
            $sucursal_str .= ','.implode(",", $sucursales);             
        }                   
          
        if($dct>0){ 
            $this->db->where('gra_id_dct', $dct);        
        }
        //$this->db->where('gra_id_suc in('.$sucursal_str.')', null);   
        $this->db->join('gra_grupo_academico','pyc_id=gra_id_pyc');
        $data['proyeccion'] = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), $pyc_id, '', 'pyc_id', true);
        $data['grupo']      = (count($pyc_grupo)>0)?$pyc_grupo:null;

        $data['titulo_personal'] = 'Lista de Asistencia';
        $this->_cargarvista($data);   
    }

    /**
     * Descripción:
     * Función para mostrar los grupos asignados a proyeccion
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-21
     * @param ninguno
     * @return Mostrar la lista de grupos asignados a proyeccion
     */
    function ajax_area_grupo() {
        satelite_validar();
        if ($this->input->post()) {
            $proyeccion     = $this->input->post('proyeccion');
            $area_pyc       = $this->gsatelite->get_campo('pyc_proyeccion', 'pyc_id_ard', array('pyc_id'=>$proyeccion, 'pyc_estado'=>1));
            $ard_proyeccion = $this->gsatelite->get_campo('ard_area_academica', 'ard_nombre', array('ard_id'=> $area_pyc,'ard_estado'=>1));

            /******************/
            $user = $this->tank_auth->get_user_id();

            $this->db->join('emp_empleado', 'usu_id_emp = emp_id');
            $this->db->join('dct_docente', 'dct_id_emp = emp_id', 'left');
            $registro = $this->gsatelite->get_tabla('users', array('id'=>$user));

           
            if(count($registro)>0 && $registro[0]['dct_id']>0){
                $docente = $registro[0]['dct_id'];
                $consulta_gra = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id_pyc'=>$proyeccion, 'gra_estado'=>1, 'gra_id_dct'=>$docente));
            }else{
                $consulta_gra = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id_pyc'=>$proyeccion, 'gra_estado'=>1));
            }
            /**************************/

            //$consulta_gra = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id_pyc'=>$proyeccion, 'gra_estado'=>1));

            $html = '<option value=""></option>';
            foreach ($consulta_gra as $key => $value) {
                $html .= '<option value="'.$value['gra_id'].'">'.$value['gra_nombre'].'</option>';
            }
            $arr = array('ard_proyeccion'=>$ard_proyeccion, 'option'=>$html);

            echo json_encode($arr);
        }
    }  

    /**
     * Descripción:
     * Función para mostrar los datos de asistencia
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-21
     * @param ninguno
     * @return Mostrar la lista de asistencia
     */
     function ajax_grupo_asistencia() {
        satelite_validar();
        if ($this->input->post()) {
            $gra_id = $this->input->post('grado');
            $consulta_gra = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id'=>$gra_id, 'gra_estado'=>1));
            $consulta_alm = $this->registro_academico_model->get_alumnos_grupo(array('gra_id'=>$gra_id), 'alm_id');
            $docente = '';$frecuencia = '';$seccion = '';$dctId = ''; $inasistencia = '';

            foreach ($consulta_gra as $key => $value) {
                $dctId = $value['gra_id_dct'];
                $dct_emp = $this->gsatelite->get_campo('dct_docente', 'dct_id_emp', array('dct_id'=>$value['gra_id_dct'], 'dct_estado'=>1));
                $inasistencia = $this->gsatelite->get_dropdown('tpi_tipo_inasistencia', '{tpi_nombre}', '', array('tpi_estado' => 1), null, '', 'tpi_id', true);
                $docente = $this->gsatelite->get_tabla('emp_empleado', array('emp_id'=>$dct_emp, 'emp_estado'=>1));
                $seccion = $this->gsatelite->get_campo('scc_seccion', 'scc_nombre', array('scc_id'=>$value['gra_id_scc'], 'scc_estado'=>1));
                $frecuencia = $this->registro_academico_model->get_horario_grupo(array('gra_id'=>$value['gra_id']));
            }
            $html = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $inasistencia);

            // Docente
            $nombreDct = $docente[0]['emp_nombre'].' '.$docente[0]['emp_apellido'];
            echo json_encode(array('docente'=>$nombreDct, 'docenteId'=>$dctId, 'seccion'=>$seccion, 'alumnos'=>$consulta_alm, 'inasistencia'=>$html, 'frecuencia'=>$frecuencia));
        }
     }   

    /**
     * Descripción:
     * Función para guardar la lista de asistencia
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-21
     * @param ninguno
     * @return Guardar Lista de Asistencia
     */
     function guardar_lista_asistencia() {
        satelite_validar();
        if ($this->input->post()) {        
            $grupo      = $this->input->post('slcGrupo');
            $docente    = $this->input->post('docenteId');
            $fecha      = $this->input->post('fechaAsistencia');
            $alumnos    = $this->input->post('idAlm');
            $asistencia = $this->input->post('asistencia');
            $inasistencia = $this->input->post('inasistencia');
            
            $registros = count($alumnos);
            if (trim($fecha) == '') {
                $this->gsatelite->show_dialog('No se ha seleccionado ninguna fecha', 'registro_academico/procesos/lista_asistencia', 'error', 'Error');
                die();
            }

            // Verificar asistencia de este grupo para el dia en especifico
            $verificar = $this->gsatelite->get_tabla('asg_asistencia_grupo', array('asg_id_gra'=>$grupo, 'asg_fecha_asistencia'=>$fecha));
            if (count($verificar)>0) {
                $this->gsatelite->show_dialog('Ya se ha pasado asistencia ese día', 'registro_academico/procesos/lista_asistencia', 'error', 'Error');
                die();
            }
            
            $datos = array (
                'asg_id_gra'=> $grupo,
                'asg_id_dct' => $docente,
                'asg_fecha_asistencia' => formatear_fecha('Y-m-d', $fecha),
                'asg_observacion' => NULL,
                'asg_estado' => 1,
                'asg_usu_creacion' => $this->tank_auth->get_user_id(),
                'asg_fecha_creacion' => date('Y-m-d H:i:s'),
                'asg_usu_modificacion' => $this->tank_auth->get_user_id(),
                'asg_fecha_modificacion' => date('Y-m-d H:i:s') 
            );
        
            $consulta_asg = $this->gsatelite->ingresar('asg_asistencia_grupo', $datos);
            $consulta_dsg = '';
            if ($registros>0){
                foreach ($alumnos as $key => $value) {
                    $datos_array = array(
                        'dsg_id_asg'  => $consulta_asg
                        ,'dsg_id_tpi' => (($inasistencia[$key]!='')?$inasistencia[$key]:NULL)  
                        ,'dsg_id_alm' => $value
                        ,'dsg_asistencia' => (($asistencia[$key]!='')?$asistencia[$key]:0)
                        ,'dsg_estado' => 1
                        ,'dsg_usu_creacion' => $this->tank_auth->get_user_id()
                        ,'dsg_fecha_creacion' => date('Y-m-d H:i:s')
                        ,'dsg_usu_modificacion' => $this->tank_auth->get_user_id()
                        ,'dsg_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    // print_r($datos_array);die();
                    $consulta_dsg = $this->gsatelite->ingresar('dsg_detalle_asistencia', $datos_array);
                }
            }

            if(count($consulta_asg) > 0 && count($consulta_dsg)>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registros procesados",'texto_alerta'=>"Registros procesados correctamente");
            }
            else{
                 $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error de inserción",'texto_alerta'=>"El registro no pudo ser procesado");
            }
            $this->session->set_flashdata($alerta);

            $tipo_btn =  $this->input->post('btnCrear');
            if ($tipo_btn == 1) {
                redirect('registro_academico/procesos/lista_asistencia');
            } else {//Regresar a la lista
                redirect('registro_academico/procesos/asistencia_grupo');  
            }
        }
     } 

    /**
     * Descripción:
     * Función Mostrar la vista de editar
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-21
     * @param $idAsistenciaGrp = Id de la asistencia de grupo alumnos 
     * @return Mostrar la vista de editar
     */
     function editar_lista_asistencia($idAsistenciaGrp, $opcion=NULL) {
        satelite_validar();
        if (isset($idAsistenciaGrp) && is_numeric($idAsistenciaGrp) && trim($idAsistenciaGrp) != '') {
            $data['opcion'] = $opcion;
            $data['proyeccion'] = $this->gsatelite->get_tabla('pyc_proyeccion', array('pyc_estado'=>1));
            $data['asg_asistencia'] = $this->gsatelite->get_tabla('asg_asistencia_grupo', array('asg_id'=>$idAsistenciaGrp, 'asg_estado'=>1));
            $data['gra_grupo'] = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id'=>$data['asg_asistencia'][0]['asg_id_gra'], 'gra_estado'=>1));
            $data['areas'] = $this->gsatelite->get_tabla('ard_area_academica', array('ard_id'=> $data['gra_grupo'][0]['gra_id_ard'],'ard_estado'=>1));
            $data['seccion'] = $this->gsatelite->get_tabla('scc_seccion', array('scc_id'=> $data['gra_grupo'][0]['gra_id_scc'], 'scc_estado'=>1));
            $data['docentes'] = $this->registro_academico_model->obtener_docentes(array('dct_id'=>$data['gra_grupo'][0]['gra_id_dct'], 'dct_estado'=>1));

            $this->db->group_by('alm_id');
            $this->db->join('alm_alumno', 'dsg_id_alm=alm_id');
            $data['dsg_detalle'] = $this->gsatelite->get_tabla('dsg_detalle_asistencia', array('dsg_id_asg'=>$idAsistenciaGrp, 'dsg_estado'=>1));
            $data['inasistencia'] = $this->gsatelite->get_tabla('tpi_tipo_inasistencia', array('tpi_estado'=>1));

            $data['titulo_personal'] = 'Editar Asistencia de Grupo';
            $this->_cargarvista($data);
        } else {
            $this->gsatelite->show_dialog('No hay parametros para procesar asistencia.', 'registro_academico/procesos/asistencia_grupo', 'error', '');
        }

     }

    /**
     * Descripción:
     * Función actualizar los datos de asistencia
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-23
     * @param ninguno 
     * @return Actualizar la asistencia de los alumnos
     */

     function modificar_lista_asistencia() {
        satelite_validar();
        if ($this->input->post()) {
            // print_r($this->input->post());die();
            $asg_id = $this->input->post('asistenciaId'); 
            $dsg_id = $this->input->post('txtdsg'); 
            $alumnos = $this->input->post('txtIdAlm'); 
            $grupo = $this->input->post('slcGrupo');
            $docente = $this->input->post('docenteId');
            $fecha = $this->input->post('fechaAsistencia');
            $asistencia = $this->input->post('asistencia');
            $inasistencia = $this->input->post('inasistencia');
            $mensaje = 'El registro no pudo ser actualizado';
            $registros = count($alumnos);

            foreach ($asistencia as $key => $value) {
                if ($value == 1) $inasistencia[$key] = '';
                
            }
            foreach ($asistencia as $key => $value) {
                if ($value == 1) $asistencia[$key] == 1;
            }
            if (trim($fecha) == '') {
                $this->gsatelite->show_dialog('No se ha seleccionado ninguna fecha', 'registro_academico/procesos/lista_asistencia', 'error', 'Error');
                die();
            }

            $datos = array (
                'asg_id_dct' => $docente,
                'asg_fecha_asistencia' => $fecha,
                'asg_observacion' => NULL,
                'asg_estado' => 1,
                'asg_usu_modificacion' => $this->tank_auth->get_user_id(),
                'asg_fecha_modificacion' => date('Y-m-d H:i:s') 
            );
        
            $consulta_asg = $this->gsatelite->actualizar_array('asg_asistencia_grupo', $datos, array('asg_id'=>$asg_id));
            $consulta_dsg = '';

            $this->gsatelite->borrado_general('dsg_detalle_asistencia', array('dsg_id_asg'=>$asg_id));
            // print_r($this->db->last_query());die();
            if (count($alumnos)>0) {

                foreach ($alumnos as $key => $value) {
                    $datos_array = array(
                         'dsg_id_asg'  => $asg_id
                        ,'dsg_id_tpi' => (($inasistencia[$key]!='')?$inasistencia[$key]:NULL)  
                        ,'dsg_id_alm' => $value
                        ,'dsg_asistencia' => (($asistencia[$key]==1 && is_numeric($asistencia[$key]))?$asistencia[$key]:0)
                        ,'dsg_estado' => 1
                        ,'dsg_usu_modificacion' => $this->tank_auth->get_user_id()
                        ,'dsg_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    // print_r($datos_array);die();
                    $consulta_dsg = $this->gsatelite->ingresar('dsg_detalle_asistencia', $datos_array);
                }
                // var_dump($this->db->last_query());die();
            } else {
                $mensaje = 'No hay registros de alumnos';
            }

            if(count($consulta_asg) > 0 && count($consulta_dsg)>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registros actualizados",'texto_alerta'=>"Registros actualizados correctamente");
            }
            else{
                 $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error de actualización",'texto_alerta'=>$mensaje);
            }
            $this->session->set_flashdata($alerta);

            $tipo_btn =  $this->input->post('btnCrear');
            if($tipo_btn == 1){
                redirect('registro_academico/procesos/editar_lista_asistencia/'.$asg_id);
            }
            else{//Regresar a la lista
                redirect('registro_academico/procesos/asistencia_grupo');  
            }
        }
     }

    /**
     * Descripción:
     * Función para eliminar asistencia de grupo de alumnos
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-21
     * @param $idGrpAsistencia = ID para eliminar la asistencia de grupo
     * @return Eliminar asistencia
     */
    function eliminar_asistencia_grupo($idGrpAsistencia=NULL) {
        satelite_validar();
         $alumnos = $this->gsatelite->get_tabla('dsg_detalle_asistencia', array('dsg_id_asg'=>$idGrpAsistencia)); 
         if (count($alumnos)>0) {
            foreach ($alumnos as $key => $value) {
                $registro = $this->gsatelite->borrado_general('dsg_detalle_asistencia', array('dsg_id' => $value['dsg_id']));      
            }
         }
         $registro = $this->gsatelite->borrado_general('asg_asistencia_grupo', array('asg_id' => $idGrpAsistencia));      
        
        
        if($registro>0){
            $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro borrado", 'texto_alerta' => "El registro se ha borrado correctamente.");            
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "NOTA", 'texto_alerta' => "El registro posee integridad referencial <br />&nbsp;No podrá ser eliminado.");
        }

        $this->session->set_flashdata($alerta);
        redirect('registro_academico/procesos/asistencia_grupo');
    }


    /**
     * Descripción:
     * Función validar la fecha de asistencia
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-21
     * @param ninguno
     * @return Validar Fecha de Asistencia
     */
     function validar_fecha_asistencia() {
        satelite_validar();
        if ($this->input->post()) {

            // POST
            $fecha = formatear_fecha('Y-m-d', $this->input->post('fechaAsistencia'));
            $proyeccion = $this->input->post('proyeccion');
            $grupo = $this->input->post('grupo');
            // Consulta
            $consulta = $this->registro_academico_model->get_validar_fecha_asistencia(array('pyc_id'=>$proyeccion, 'pyc_estado'=>1), $fecha);
            $verificar = $this->gsatelite->get_tabla('asg_asistencia_grupo', array('asg_id_gra'=>$grupo, 'asg_fecha_asistencia'=>$fecha));
            // print_r($this->db->last_query());die();

            echo json_encode(array('registro'=>$consulta, 'asistencias'=>count($verificar)));
        }
     }


    /**
     * Descripción:
     * Función para la vista de Graduciones
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-25
     * @param ninguno
     * @return Mostrar la vista de graduciones
     */     
    function graduaciones() {
        satelite_validar();

        if ($this->input->post()) {
                $data['permisos']               = $this->gsatelite->get_permisos_opcion();
                $data['graduaciones']           = $this->gsatelite->get_tabla('grl_graduacion_alumno', array('grl_estado'=>1));
                $data['detalle_graduaciones']   = $this->gsatelite->get_tabla('dgr_detalle_graduacion', array('dgr_estado'=>1));

                $html = $this->load->view('registro_academico/procesos/detalle_graduaciones', $data, true);
                echo json_encode(array('html'=>$html));

        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion(); // Permisos
            $data['titulo_personal'] = 'Registro de graduaciones';
            $this->_cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función para Agregar Graduciones
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-25
     * @param ninguno
     * @return Mostrar la vista de Agregar Graduciones
     */ 
    function agregar_graduaciones() {
        satelite_validar();

        if ($this->input->post()) {
            // var_dump($_POST);die();
            $nombre = (trim($this->input->post('txtnombre')) != '')?$this->input->post('txtnombre'):'';
            $fecha = (trim($this->input->post('txtfechagraducion')) != '')?$this->input->post('txtfechagraducion'):'';
            $proyeccion = (count($this->input->post('graduacion_proyeccion'))>0)?$this->input->post('graduacion_proyeccion'):'';
            $alumnos = (count($this->input->post('alumnos_graducion'))>0)?$this->input->post('alumnos_graducion'):'';
            // print_r($this->input->post());die();
            $datos = array (
                'grl_nombre' => $nombre,
                'grl_fecha' => formatear_fecha('Y-m-d', $fecha),
                'grl_estado' => 1,
                'grl_usu_creacion' => $this->tank_auth->get_user_id(),
                'grl_fecha_creacion' => date('Y-m-d H:i:s'),
                'grl_usu_modificacion' => $this->tank_auth->get_user_id(),
                'grl_fecha_modificacion' => date('Y-m-d H:i:s') 
                );
        
            $consulta_grl = $this->gsatelite->ingresar('grl_graduacion_alumno', $datos);
            $consulta_dgr = '';

            if (count($alumnos)>0){
                foreach ($alumnos as $key => $value) {
                    $alm = explode(',', $value);
                    foreach ($alm as $k => $v) {

                        $datos_array = array(
                                'dgr_id_grl'  => $consulta_grl
                                ,'dgr_id_alm' =>   $v
                                ,'dgr_id_pyc' => $proyeccion[$key]
                                ,'dgr_estado' => 1
                                ,'dgr_usu_creacion' => $this->tank_auth->get_user_id()
                                ,'dgr_fecha_creacion' => date('Y-m-d H:i:s')
                                ,'dgr_usu_modificacion' => $this->tank_auth->get_user_id()
                                ,'dgr_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $consulta_dgr = $this->gsatelite->ingresar('dgr_detalle_graduacion', $datos_array);
                    }
                }
            }

            if(count($consulta_grl) > 0 && count($consulta_dgr)>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registros procesados",'texto_alerta'=>"Registros procesados correctamente");
            }
            else{
                 $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error de inserción",'texto_alerta'=>"El registro no pudo ser procesado");
            }
            $this->session->set_flashdata($alerta);

            $tipo_btn =  $this->input->post('btnCrear');
            if ($tipo_btn == 1) {
                redirect('registro_academico/procesos/agregar_graduaciones');
            } else {//Regresar a la lista
                redirect('registro_academico/procesos/graduaciones');  
            }            
            
        } else {
            $data['proyeccion'] = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);
            $data['titulo_personal'] = 'Registro de graduaciones';
            $this->_cargarvista($data);   
        }
    }

    /**
     * Descripción:
     * Función para solicitud de ajax para extraer alumnos por proyeccion
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-25
     * @param ninguno
     * @return Mostrar alumnos por proyeccion
     */ 
    function ajax_proyeccion_alumnos() {
        satelite_validar();

        if ($this->input->post()) {
            $where = array();
            $orderby = '';

            $proyeccion = (is_numeric($this->input->post('proyeccion')) && count($this->input->post('proyeccion'))>0)?$this->input->post('proyeccion'):NULL;
            if ($proyeccion == NULL) return false; 
            $data_proyeccion = $this->gsatelite->get_tabla('pyc_proyeccion', array('pyc_id'=>$proyeccion, 'pyc_estado'=>1));
            $area = $this->gsatelite->get_campo('ard_area_academica', 'ard_nombre', array('ard_id'=>$data_proyeccion[0]['pyc_id_ard'], 'ard_estado'=>1));
            // Condiciones para el modelo
            $where['pyc_id'] = $proyeccion;
            $orderby = 'alm_id';
            $alumnos = $this->registro_academico_model->get_alumnos_proyeccion($where, $orderby);
            // Datos
            $datos = array(
                'area' => $area,
                'alumnos' => $alumnos
            );

            echo json_encode($datos);
        }
    }

    /**
     * Descripción:
     * Función para Modificar las Graducionaes
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-27
     * @param ninguno
     * @return Modificar Graduaciones
     */ 
    function modificar_graduaciones($idGraduacion, $opcion=NULL) {
        satelite_validar();

        if ($this->input->post()) {

            $nombre = $this->input->post('txtnombre');
            $fecha = $this->input->post('txtfechagraducion');
            $proyeccion = $this->input->post('graduacion_proyeccion');
            $alumnos = $this->input->post('alumnos_graducion');
            $dgr_detalle = $this->input->post('dgr_detalle');
            // var_dump($this->input->post());die();
            $datos = array (
                            'grl_nombre' => $nombre,
                            'grl_fecha' => formatear_fecha('Y-m-d', $fecha),
                            'grl_estado' => 1,
                            'grl_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'grl_fecha_modificacion' => date('Y-m-d H:i:s') 
                            );
        
            $consulta_grl = $this->gsatelite->actualizar_array('grl_graduacion_alumno', $datos, array('grl_id'=>$idGraduacion));

            $consulta_dgr = '';

            $this->gsatelite->borrado_general('dgr_detalle_graduacion', array('dgr_id_grl'=>$idGraduacion));
            // var_dump($this->db->last_query());die();
            if (count($alumnos)>0) {

                foreach ($alumnos as $key => $value) {
                    $alm = explode(',', $value);
                    foreach ($alm as $k => $v) {

                        $datos_array = array(
                                'dgr_id_grl'  => $idGraduacion
                                ,'dgr_id_alm' =>   $v
                                ,'dgr_id_pyc' => $proyeccion[$key]
                                ,'dgr_estado' => 1
                                ,'dgr_usu_creacion' => $this->tank_auth->get_user_id()
                                ,'dgr_fecha_creacion' => date('Y-m-d H:i:s')
                                ,'dgr_usu_modificacion' => $this->tank_auth->get_user_id()
                                ,'dgr_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $consulta_dgr = $this->gsatelite->ingresar('dgr_detalle_graduacion', $datos_array);
                    }
                }
                // var_dump($this->db->last_query());die();
            } else {
                $mensaje = 'No hay registros de graduaciones';
            }

            if(count($consulta_grl) > 0 && count($consulta_dgr)>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registros actualizados",'texto_alerta'=>"Registros actualizados correctamente");
            }
            else{
                 $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error de actualización",'texto_alerta'=>$mensaje);
            }
            $this->session->set_flashdata($alerta);

            $tipo_btn =  $this->input->post('btnCrear');
            if($tipo_btn == 1){
                redirect('registro_academico/procesos/modificar_graduaciones/'.$idGraduacion);
            }
            else{//Regresar a la lista
                redirect('registro_academico/procesos/graduaciones');  
            }

        } else {
            if (isset($idGraduacion) && is_numeric($idGraduacion) && trim($idGraduacion) != '') {
                $data['opcion'] = $opcion;
                $data['grl_graduacion'] = $this->gsatelite->get_tabla('grl_graduacion_alumno', array('grl_id'=>$idGraduacion, 'grl_estado'=>1));
                $data['dgr_graduacion'] = $this->gsatelite->get_tabla('dgr_detalle_graduacion', array('dgr_id_grl'=>$idGraduacion, 'dgr_estado'=>1));
                $proyeccion = $this->gsatelite->get_tabla('pyc_proyeccion', array('pyc_estado' => 1));
                $where['grl_id'] = $idGraduacion; 
                $data['alumnos'] = $this->registro_academico_model->get_alumnos_graduaciones($where);
                // var_dump($data);
                $pyc_dgr = array();

                foreach ($data['dgr_graduacion'] as $key1 => $value1) {
                    foreach ($proyeccion as $key2 => $value2) {
                        if ($value1['dgr_id_pyc'] == $value2['pyc_id']) {
                            array_push($pyc_dgr, $value2['pyc_nombre']);
                        }
                    }
                }
                $html = '<option value=""></option>';
                foreach ($proyeccion as $key3 => $value3) {
                    $html .= '<option value="'.$value3['pyc_id'].'">'.$value3['pyc_nombre'].'</option>';
                }
                $data['proyeccion'] = $html;
                $data['proyeccion_nombres'] = $pyc_dgr;
                $data['titulo_personal'] = 'Modificación de graduaciones';
                $this->_cargarvista($data); 
            } else {
                $this->gsatelite->show_dialog('No hay parametros para procesar graduación.', 'registro_academico/procesos/graduciones', 'error', '');
            }
        }
    }

    /**
     * Descripción:
     * Función para Eliminar Graduaciones
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-27
     * @param ninguno
     * @return Eliminar Graduaciones
     */ 
    function eliminar_graduaciones($idGraduacion=NULL) {
        satelite_validar();
         $graduacion = $this->gsatelite->get_tabla('grl_graduacion_alumno', array('grl_id'=>$idGraduacion)); 
         $dgr_detalle = $this->gsatelite->get_tabla('dgr_detalle_graduacion', array('dgr_id_grl'=>$idGraduacion)); 
         $registro = '';

         if (count($dgr_detalle)>0) {
            $registro = $this->gsatelite->borrado_general('dgr_detalle_graduacion', array('dgr_id_grl'=>$idGraduacion)); 
         }

         if (count($graduacion)>0) {

            $registro = $this->gsatelite->borrado_general('grl_graduacion_alumno', array('grl_id'=>$idGraduacion)); 

         }
        
        if($registro>0){
            $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro borrado", 'texto_alerta' => "El registro se ha borrado correctamente.");            
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "NOTA", 'texto_alerta' => "El registro posee integridad referencial <br />&nbsp;No podrá ser eliminado.");
        }

        $this->session->set_flashdata($alerta);
        redirect('registro_academico/procesos/graduaciones');
    }

    /**
     * Descripción:
     * Función para Mostrar la vista de Cierre de Curso
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-28
     * @param ninguno
     * @return Mostrar vista de Cierre de Curso
     */ 
    function cierre_curso() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        if ($this->input->post()) {
            $post_array=$this->input->post();
            if(isset($post_array['exportar']) AND $post_array['exportar']>0){
                $proyeccion = (is_numeric($this->input->post('filtro_proyeccion')) && trim($this->input->post('filtro_proyeccion'))>0)?$this->input->post('filtro_proyeccion'):'';
                $docente = (is_numeric($this->input->post('filtro_docente')) && trim($this->input->post('filtro_docente'))>0)?$this->input->post('filtro_docente'):'';
            }else{
                $proyeccion = (is_numeric($this->input->post('proyeccion')) && trim($this->input->post('proyeccion'))>0)?$this->input->post('proyeccion'):'';
                $docente = (is_numeric($this->input->post('docente')) && trim($this->input->post('docente'))>0)?$this->input->post('docente'):'';
            }
            
            $tipo_reporte = ($this->input->post('tipo_reporte'))?$this->input->post('tipo_reporte'):null;

            if($proyeccion != '') {
                $where['pyc_id'] = $proyeccion;
            }
            if($docente != '') {
                $where['dct_id'] = $docente;
            }
    
            $data['grupos_cerrados'] = $this->registro_academico_model->get_cierre_grupo($where);
            
            $detalle = $this->load->view('registro_academico/procesos/detalle_cierre_curso', $data, true);
        
            if($tipo_reporte=='pdf'){
                $data['titulo'] = 'Cierre de curso';

                $data['user']=$this->tank_auth->get_user_id();
                $html=$this->load->view('reporte/header', array('titulo' => "Cierre de curso"), true);
                $html.= $this->load->view('registro_academico/procesos/cierre_export', $data, true);
                $GLOBALS['nombre_reporte'] = 'Cierre de curso'.date('dmY');

                $this->pdf->makePdf($html,'L','Cierre de curso','Letter');
            }else if($tipo_reporte == 'excel'){
                $filename = 'rpt_cierre_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

                $data['titulo'] = 'Cierre de curso';
                $data['filename'] = $filename;
                $data['excel'] = 1;
                $html = $this->load->view('registro_academico/procesos/cierre_export',$data,true);
                echo $html;
                die();
            }else{
                echo $detalle;
                die();
            }


        }

        //incluir sucursales
        $usuario        = $this->tank_auth->get_user_id();    
        $sucurales_array= $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $usuario));
        $sucursales     = array_column($sucurales_array,'usc_id_suc');            
        $sucursal_str   = 0;
        if ( count($sucursales) > 0 ) {   
            $sucursal_str .= ','.implode(",", $sucursales);             
        }             

        //$this->db->where('pyc_id_suc in('.$sucursal_str.')',NULL);
        $proyeccion_drop        = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);
        $proyeccion_drop        = str_replace('<option value="0">Sin Registros</option>', '', $proyeccion_drop);
        $data['proyeccion']     = str_replace('<option value="0">Seleccione</option>', '', $proyeccion_drop);
        $data['titulo_personal']= 'Cierre de Curso';
        $this->_cargarvista($data);
    }    

    /**
     * Descripción:
     * Función para Agregar Cierre de Cursos
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-28
     * @param ninguno
     * @return Agregar cierre de Cursos
     */ 
    function agregar_cierre_curso($idCierre=NULL) {
        satelite_validar();

        if($idCierre != NULL && is_numeric($idCierre)){            
            // Vista para ver los registros
            $dcg = $this->gsatelite->get_tabla('dcg_detalle_cierre_grupo', array('dcg_id'=>$idCierre, 'dcg_estado'=>1));
            $idGrupo = $dcg[0]['dcg_id_gra'];
            $grupo_info = $this->gsatelite->get_tabla('gra_grupo_academico',array('gra_id'=>$idGrupo, 'gra_estado'=>1));
            $consulta_emp = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado'=>1));
            $where['gra_id'] = $dcg[0]['dcg_id_gra'];
            $where['gra_estado'] = 1;

            $consulta = $this->registro_academico_model->get_grupo_info($where);
            $grupo_info = $this->registro_academico_model->obtener_grupos(array('gra_id'=>$idGrupo));
            // Docente
            $docente = $this->gsatelite->get_tabla('dct_docente', array('dct_id'=>$grupo_info[0]['gra_id_dct']));
            $dct = '';
            // Supervisor
            $supervisor = $this->gsatelite->get_tabla('sug_supervisor_grupo', array('sug_id'=>$grupo_info[0]['gra_id_sug']));
            $sug = '';

            // Información del grupo
            $frh_nombre = $this->gsatelite->get_tabla('frh_frecuencia_horario', array('frh_id'=>$grupo_info[0]['gra_id_frh']));
            $data['registro'] = $frecuencia = $this->registro_academico_model->get_frecuencias(array('dfr_id_frh'=>$grupo_info[0]['gra_id_frh']));
            $html = $this->load->view('registro_academico/procesos/detalle_frecuencia', $data, true);

            $fecha_inicio = formatear_fecha('d-m-Y', $grupo_info[0]['gra_fecha_inicio']);
            $fecha_fin = formatear_fecha('d-m-Y', $grupo_info[0]['gra_fecha_fin']);

            // pyc_fecha_limite_nota
            $fecha_limite = formatear_fecha('d-m-Y', $grupo_info[0]['pyc_fecha_limite_nota']);

            if (count($docente)>0) {
                foreach ($consulta_emp as $key => $value) {
                    if ($docente[0]['dct_id_emp'] == $value['emp_id']) {
                        $dct = $value['emp_nombre'].' '.$value['emp_apellido'];
                    }
                }
            }

            if (count($supervisor)>0) {
                foreach ($consulta_emp as $key => $value) {
                    if($supervisor[0]['sug_id_emp'] == $value['emp_id']){
                        $sug = $value['emp_nombre'].' '.$value['emp_apellido'];
                    }
                }
            }
            $data['opcion'] = 1;
            $data['html'] = $html;
            $data['docente'] = $dct;
            $data['frecuencia'] = $frh_nombre;
            $data['supervisor'] = $sug;
            $data['fecha_inicio'] = $fecha_inicio;
            $data['fecha_fin'] = $fecha_fin;
            $data['fecha_limite'] = $fecha_limite;
            $data['grupo_info'] = $grupo_info;
            $data['grupo'] = $consulta;
            $data['cierre_grupo'] =$this->gsatelite->get_tabla('dcg_detalle_cierre_grupo', array('dcg_id_gra'=>$idGrupo, 'dcg_estado'=>1));
 
            $data['proyeccion'] = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), $grupo_info[0]['gra_id_pyc'], '', 'pyc_id', true);
            $data['grupo'] = $this->gsatelite->get_dropdown('gra_grupo_academico', '{gra_nombre}', '', array('gra_estado' => 1), $idGrupo, '', 'gra_id', true);

            $data['titulo_personal'] = 'Ver Cierre de Curso/Nivel';
            $this->_cargarvista($data);
            die();
        } 

        if ($this->input->post()) {
            $grupo = (trim($this->input->post('slcGrupo'))>0 && is_numeric($this->input->post('slcGrupo')))?$this->input->post('slcGrupo'):'';
            $fecha = (count(trim($this->input->post('txtFecha')))>0 && trim($this->input->post('txtFecha')) != '')?$this->input->post('txtFecha'):'';
            $motivo = (trim($this->input->post('txtmotivo')) != '')?$this->input->post('txtmotivo'):'';
            $horas = (trim($this->input->post('txthorapagar'))>0 && is_numeric($this->input->post('txthorapagar')))?$this->input->post('txthorapagar'):'';

            $datos = array (
                'dcg_id_gra' => $grupo,
                'dcg_id_usu' => $this->tank_auth->get_user_id(),
                'dcg_fecha_cierre' => formatear_fecha('Y-m-d', $fecha),
                'dcg_observacion' => $motivo,
                'dcg_horas' => $horas,
                'dcg_procesado_planilla' => '',
                'dcg_estado' => 1,
                'dcg_usu_creacion' => $this->tank_auth->get_user_id(),
                'dcg_fecha_creacion' => date('Y-m-d H:i:s'),
                'dcg_usu_modificacion' => $this->tank_auth->get_user_id(),
                'dcg_fecha_modificacion' => date('Y-m-d H:i:s') 
                );
        
            $consulta = $this->gsatelite->ingresar('dcg_detalle_cierre_grupo', $datos);
            if(count($consulta) > 0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registros procesados",'texto_alerta'=>"Registros procesados correctamente");
            }
            else{
                 $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error de inserción",'texto_alerta'=>"El registro no pudo ser procesado");
            }
            $this->session->set_flashdata($alerta);

            $tipo_btn =  $this->input->post('btnCrear');
            if ($tipo_btn == 1) {
                redirect('registro_academico/procesos/agregar_cierre_curso');
            } else {//Regresar a la lista
                redirect('registro_academico/procesos/cierre_curso');  
            }   

        } else {
            //incluir sucursales
            //$sucursal_str = $this->get_sucursales();                          
            //$this->db->where('pyc_id_suc in('.$sucursal_str.')',NULL);
            $proyeccion_drop = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);
            $data["proyeccion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $proyeccion_drop);
            $data['titulo_personal']= 'Cierre de Curso/Nivel';
            $this->_cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función ajax para obtener todo los grupos por proyeccion
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-28
     * @param ninguno
     * @return Ajax para obtener todo los grupos por proyeccion
     */
    function ajax_select_proyeccion() {
        satelite_validar();

        if ($this->input->post()) {
            
            $proyeccion     = (trim($this->input->post('proyeccion'))>0 && is_numeric($this->input->post('proyeccion')))?$this->input->post('proyeccion'):'';
            $sucursal_str   = $this->get_sucursales();   
            $where = array(
                'pyc_id'    => $proyeccion, 
                'pyc_estado'=> 1, 
                //'gra_estado'=> 1,
                //'pyc_id_suc in('.$sucursal_str.')'=> null,
                //'gra_id_suc in('.$sucursal_str.')'=> null
            );
                    
            $this->db->join('gra_grupo_academico', 'gra_id_pyc=pyc_id', 'inner');
            $consulta =$this->gsatelite->get_tabla('pyc_proyeccion', $where);
            
            $html = '<option value=""></option>';
            foreach ($consulta as $key => $value) {
                $html .= '<option value="'.$value['gra_id'].'">'.$value['gra_nombre'].'</option>';
            }
            $proyeccion = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $html);
            echo json_encode(array('grupos'=>$proyeccion));
        }
    }

    /**
     * Descripción:
     * Función ajax para obtener la información de un grupo
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-28
     * @param ninguno
     * @return Ajax para obtener la informacion de un grupo
     */
    function ajax_select_grupos() {
        satelite_validar();

        if($this->input->post()) {
            $grupo =(trim($this->input->post('grupo'))>0 && is_numeric($this->input->post('grupo')))?$this->input->post('grupo'):'';
            $consulta_emp = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado'=>1));

            $where['gra_id'] = $grupo;
            $consulta = $this->registro_academico_model->get_grupo_info($where);

            // Docente
            $docente = $this->gsatelite->get_tabla('dct_docente', array('dct_id'=>$consulta[0]['gra_id_dct']));
            $dct = '';
            // Supervisor
            $supervisor = $this->gsatelite->get_tabla('sug_supervisor_grupo', array('sug_id'=>$consulta[0]['gra_id_sug']));
            $sug = '';

            // Información del grupo
            $frh_nombre = $this->gsatelite->get_tabla('frh_frecuencia_horario', array('frh_id'=>$consulta[0]['gra_id_frh']));
            $data['registro'] = $frecuencia = $this->registro_academico_model->get_frecuencias(array('dfr_id_frh'=>$consulta[0]['gra_id_frh']));
            $html = $this->load->view('registro_academico/procesos/detalle_frecuencia', $data, true);

            $fecha_inicio = formatear_fecha('d-m-Y', $consulta[0]['gra_fecha_inicio']);
            $fecha_fin = formatear_fecha('d-m-Y', $consulta[0]['gra_fecha_fin']);

            $grupo_info = $this->registro_academico_model->obtener_grupos(array('gra_id'=>$consulta[0]['gra_id']));
            // pyc_fecha_limite_nota
            $fecha_limite = formatear_fecha('d-m-Y', $grupo_info[0]['pyc_fecha_limite_nota']);

            if (count($docente)>0) {
                foreach ($consulta_emp as $key => $value) {
                    if ($docente[0]['dct_id_emp'] == $value['emp_id']) {
                        $dct = $value['emp_nombre'].' '.$value['emp_apellido'];
                    }
                }
            }

            if (count($supervisor)>0) {
                foreach ($consulta_emp as $key => $value) {
                    if($supervisor[0]['sug_id_emp'] == $value['emp_id']){
                        $sug = $value['emp_nombre'].' '.$value['emp_apellido'];
                    }
                }
            }

            echo json_encode(array('datos'=>$consulta, 'docente'=>$dct, 'supervisor'=>$sug, 'frh_nombre'=>$frh_nombre ,'frecuencia'=>$html, 'fecha_inicio'=>$fecha_inicio, 'fecha_fin'=>$fecha_fin, 'fecha_limite'=>$fecha_limite));

        }
    }

    /**
     * Descripción:
     * Función ajax para obtener las horas pagadas a un docente
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-28
     * @param ninguno
     * @return Horas pagadas a un docente
     */
    function ajax_horas_pagadas() {
        satelite_validar();

        if ($this->input->post()) {
            $fechaCierre = (count($this->input->post('fechaCierre'))>0)?$this->input->post('fechaCierre'):'';
            $grupo = (is_numeric($this->input->post('grupo')))?$this->input->post('grupo'):'';
            $grupo_info = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id'=>$grupo, 'gra_estado'=>1));
            // print_r($grupo_info);echo $grupo;die();
            $grupo_frecuencia = $this->registro_academico_model->get_frecuencias(array('dfr_id_frh'=>$grupo_info[0]['gra_id_frh']));
            $contadorHoras = 0;
            // print_r($grupo_frecuencia);die();

            $fechainicioformat = formatear_fecha('d-m-Y', $grupo_info[0]['gra_fecha_inicio']);
            $fechafinformat = formatear_fecha('d-m-Y', $fechaCierre);

            // Se encontro con una funcion que permite procesar los dias
            $fechaInicio=strtotime($fechainicioformat); // Formato 25-02-2008
            $fechaFin=strtotime($fechafinformat); // Formato 01-04-2008
            $dias_ES = array("Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado", "Domingo");
            $dias_EN = array("Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday");
            // Calculo de dias que deben ser pagados
            foreach ($grupo_frecuencia as $key => $value) {
                
                for($i=$fechaInicio; $i<=$fechaFin; $i+=86400){
                    $dia = date("N", $i);
                    // $diaN = date("d", $i);
                    // $mes = date("m", $i);
                    // $anio = date("Y", $i);

                    $nombredia = str_replace($dias_EN, $dias_ES, $dia);
                    if($nombredia == $value['dia_id']){
                        $contadorHoras += ((int)$value['hrg_fin']-(int)$value['hrg_inicio']);    
                    }

                    // echo $nombredia.' '.$diaN.' '.$mes.' '.$anio."<br>";
                }
            }

            // SELECT * FROM lxp_alumnoxpensum 
            // INNER JOIN gra_grupo_academico ON gra_id=lxp_id
            // WHERE gra_id=3 AND lxp_estado=1
            $this->db->join('gra_grupo_academico', 'gra_id=lxp_id', 'inner');
            $alumnosxgrupo = $this->gsatelite->get_tabla('lxp_alumnoxpensum', array('gra_id'=>$grupo, 'lxp_estado'=>1));

            echo json_encode(array('horas'=>$contadorHoras, 'alumnosxgrupo'=>$alumnosxgrupo));
        }
    }

    /**
     * Descripción:
     * Función ajax para obtener los docentes por proyeccion
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-29
     * @param ninguno
     * @return Obtener los docentes por proyeccion
     */
    function ajax_proyeccion_docente() {
        satelite_validar();

        if($this->input->post()) {
            //incluir sucursales
            $usuario        = $this->tank_auth->get_user_id();    
            //$sucurales_array= $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $usuario));
            $sucursales     = array_column($sucurales_array,'usc_id_suc');            
            $sucursal_str   = 0;
            if ( count($sucursales) > 0 ) {   
                $sucursal_str .= ','.implode(",", $sucursales);             
            }             
            //$where['pyc_id_suc in('.$sucursal_str.')'] = NULL;
            //$where['dct_id_suc in('.$sucursal_str.')'] = NULL;

            $proyeccion     = (is_numeric($this->input->post('proyeccion')))?$this->input->post('proyeccion'):'';
            $where['pyc_id']= $proyeccion;
            $docente        = $this->registro_academico_model->get_docentes_proyeccion($where, 'dct_id');
            $html2          = '<option value=""></option>';
            foreach ($docente as $key => $value) {
                $html2 .= '<option value="'.$value['dct_id'].'">'.$value['emp_nombre'].' '.$value['emp_apellido'].'</option>';
            }
            $dct = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $html2);        
            echo $dct;
            die();
        }
    }

    /**
     * Descripción:
     * Función para Inactivar Beca a estudiante autorizado
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-30
     * @param ninguno
     * @return Obtener la inactivacion de la beca
     */
    function inactivar_beca() {
        satelite_validar();

        if ($this->input->post()) {
                $apb_id = $this->input->post('id');
                $motivo = $this->input->post('motivo');
                $fecha = $this->input->post('fecha');
                
                $slb_id = $this->gsatelite->get_campo('apb_aprobacion_beca', 'apb_id_slb', array('apb_id'=>$apb_id));

                $detalle = array(
                        'apb_id_usu_inactivacion'  => $this->tank_auth->get_user_id(),
                        'apb_observacion_inactivacion' => $motivo,
                        'apb_fecha_inactiva'   => formatear_fecha('Y-m-d', $fecha),
                        'apb_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'apb_fecha_modificacion' => date('Y-m-d H:i:s')
                       
                    );
                $id = $this->gsatelite->actualizar_array('apb_aprobacion_beca', $detalle, array('apb_id'=>$apb_id));

                if($id>0){

                    $act_slb=array(
                        'slb_estado_solicitud'=>4,
                        'slb_usu_modificacion' =>$this->tank_auth->get_user_id(),
                        'slb_fecha_modificacion'=>date('Y-m-d H:i:s')
                        );
                    $this->gsatelite->actualizar_array('slb_solicitud_beca', $act_slb, array('slb_id'=>$slb_id));
                }

            if ($id > 0) {
                $alerta = array(
                      'tipo_alerta' => 'success'
                    , 'titulo_alerta' => 'Inactivación de Beca'
                    , 'texto_alerta' => "La beca se inactivó."
                );
                $this->session->set_flashdata($alerta);
            }

            echo json_encode(array('inactivo' => $id));
        }
    }


/**
    * Descripción:
    * Cargar periodos y curso/nivel, según grupo seleccionado.
    * @author Edith Herrera - Grupo Satélite
    * @since  27-11-2017
    * @param  Ninguno
    * @return optiones de periodos y curso según grupo 
    */
    function cargar_peridoxgrupo() {
        satelite_validar(true);
        $area = $this->input->post('area');
        $grupo = $this->input->post('grupo');
        $periodos=$this->registro_academico_model->get_periodosxgrupo(array('gra_id'=>$grupo));
        $nivel = '';
        $opt_periodo='<option value=""></option>';
        if(count($periodos)>0){
            foreach ($periodos as $per) {
                $nivel = $per['mod_nombre'];
                $opt_periodo .= '<option value="'.$per['pev_id'].'">'.$per['pev_nombre'].'</option>';
            }
        }          
        $data['registro'] = $frecuencia = $this->registro_academico_model->get_frecuencias(array('dfr_id_frh'=>$periodos[0]['gra_id_frh']));
        $html = $this->load->view('registro_academico/procesos/detalle_frecuencia', $data, true);           
        $result = array(
            'opt'=>$opt_periodo, 
            'nivel'=>$nivel, 
            'detalle'=>$html, 
            'frecuencia'=>(count($periodos)>0)?$periodos[0]['frh_nombre']:'',
            'area'=>(count($periodos)>0)?$periodos[0]['ard_nombre']:'',
            'aula'=>(count($periodos)>0)?$periodos[0]['aul_nombre']:'',
            'modulo'=>(count($periodos)>0)?$periodos[0]['mod_nombre']:'',
            'seccion'=>(count($periodos)>0 && $periodos[0]['scc_nombre']!='')?$periodos[0]['scc_nombre']:'-',
            'minimo'=>(count($periodos)>0 && $periodos[0]['gra_cupo_minimo']!='')?$periodos[0]['gra_cupo_minimo']:'-',
            'maximo'=>(count($periodos)>0 && $periodos[0]['gra_cupo']!='')?$periodos[0]['gra_cupo']:'-',
            'inicio'=>(count($periodos)>0 && $periodos[0]['gra_fecha_inicio']!='')?formatear_fecha('d-m-Y', $periodos[0]['gra_fecha_inicio']):'-',
            'fin'=>(count($periodos)>0 && $periodos[0]['gra_fecha_fin']!='')?formatear_fecha('d-m-Y', $periodos[0]['gra_fecha_fin']):'-',
            'limite'=>(count($periodos)>0 && $periodos[0]['limite'])?formatear_fecha('d-m-Y', $periodos[0]['limite']):'-'
        );
        echo json_encode($result);
    }


    /**
    * Descripción:
    * Cargar evaluaciones según periodo seleccionado.
    * @author Edith Herrera - Grupo Satélite
    * @since  27-11-2017
    * @param  Ninguno
    * @return opciones de evaluaciones 
    */
    function cargar_notasxperiodo() {
        satelite_validar(true);
            $periodo = $this->input->post('periodo');
            $grupo = $this->input->post('grupo');
           
            $periodos=$this->registro_academico_model->get_periodosxgrupo(array('gra_id'=>$grupo,'pev_id'=>$periodo), 'evm_id');
            //die(print_r($this->db->last_query()));
            $nivel = '';
            $opt_periodo='<option value="0">Seleccionar todas</option>';
            if(count($periodos)>0){
                foreach ($periodos as $per) {
                    $nivel = $per['mod_nombre'];
                    $opt_periodo .= '<option value="'.$per['evm_id'].'" data-lxp="'.$per['lxp_id'].'" >'.$per['tev_nombre'].'</option>';
                }
            }

            echo json_encode(array('opt'=>$opt_periodo));
    }

    /**
     * Descripción:
     * Función mostrar vista de maestro sustituto
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-01
     * @param ninguno
     * @return Mostrar Maestro Sustituto
     */
    function maestro_sustituto() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        if($this->input->post()) {
            $area  = (is_numeric($this->input->post('area')))?$this->input->post('area'):'';
            $nivel = (is_numeric($this->input->post('nivel')))?$this->input->post('nivel'):'';
            $grupo = (is_numeric($this->input->post('grupo')))?$this->input->post('grupo'):'';
            $where = array();
            $html = '';
            if($area != '') {
                $where['gra_id_ard'] = $area;
            }
            if($nivel != '') {
                $where['mod_id'] = $nivel;
            }
            if($grupo != '') {
                $where['gra_id'] = $grupo;
            }
            $where['gra_estado'] = 1;
            $data['grupos'] = $this->registro_academico_model->obtener_maestros_sustituto($where);
            $data['escalafon'] = $this->gsatelite->get_tabla('tbe_tabla_escalafon', array('tbe_estado'=>1));
            $data['frecuencia'] = $this->registro_academico_model->get_frecuencias(array('frh_estado'=>1));
            $html = $this->load->view('registro_academico/procesos/detalle_maestro_sustituto', $data, true);
            echo $html;
            die();
        } else {
            $data['areas'] = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1), null, '', 'ard_id', true);
            $data['grupos'] = $this->gsatelite->get_dropdown('gra_grupo_academico', '{gra_nombre}', '', array('gra_estado' => 1), null, '', 'gra_id', true);
            $data['titulo_personal'] = 'Sustitución de Docentes';
            $this->_cargarvista($data);

        }
    }

    /**
     * Descripción:
     * Función mostrar vista de Agregar Sustituto
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-01
     * @param ninguno
     * @return Mostrar Vista de Agregar Sustituto
     */
    function ajax_areaxnivel(){
        satelite_validar();
        if($this->input->post()) {
            $area = (is_numeric($this->input->post('area')))?$this->input->post('area'):'';

            $consulta = $this->registro_academico_model->get_areaxnivel(array('ard_id'=>$area, 'ard_estado'=>1, 'mod_estado'=>1));
            $html = '<option value=""></option>';
            foreach ($consulta as $key => $value) {
                $html .= '<option value="'.$value['mod_id'].'">'.$value['mod_nombre'].'</option>';
            }
            $niveles = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $html);
            echo json_encode(array('niveles'=>$niveles));
        }
    }

    /**
     * Descripción:
     * Función mostrar vista de Agregar Sustituto
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-01
     * @param ninguno
     * @return Mostrar Vista de Agregar Sustituto
     */
    function agregar_sustituto($docente=NULL) {
        satelite_validar();
        if($this->input->post()) {
            $escalafon = $this->input->post('slcEscalafon');
            $docenteTitular = $this->input->post('txtdocente');
            $docenteSustituto = $this->input->post('slcMaestroSustituto');
            $grupo = $this->input->post('slcGrupo');
            $nalumnos = $this->input->post('txtnalumnos');
            $fechaInicio = $this->input->post('txtfechainicio');
            $fechaFin = $this->input->post('txtfechafin');
            $pagoTitular = $this->input->post('txtpagotitular');
            $pagoSustituto = $this->input->post('txtpagosustituto');
            $tipoPago = $this->input->post('slctipopago');
            $observacion = $this->input->post('txtObservacion');
            $numeroHoras = $this->input->post('');

            $slcPlanilla = $this->input->post('slcPlanilla');
            // print_r($this->input->post());die();

            $datos = array (
                'stm_id_tbe'=> ($escalafon!='')?$escalafon:NULL,
                'stm_id_dct_titular' => $docenteTitular,
                'stm_id_dct_sustituto' => $docenteSustituto,
                'stm_id_gra' => $grupo,
                'stm_id_pla' => ($slcPlanilla > 0)?$slcPlanilla:null,
                'stm_n_alumnos' => $nalumnos,
                'stm_fecha_inicio' => $fechaInicio,
                'stm_fecha_fin' => $fechaFin,
                'stm_pago_titular' => $pagoTitular,
                'stm_pago_sustituto' => $pagoSustituto,
                'stm_tipo_pago' => $tipoPago,
                'stm_observacion' => $observacion,
                'stm_numero_horas' => $numeroHoras,
                'stm_pago_hora_titular' => NULL,
                'stm_pago_hora_sustituto' => NULL,
                'stm_pagado_planilla' => NULL,
                'stm_estado' => 1,
                'stm_usu_creacion' => $this->tank_auth->get_user_id(),
                'stm_fecha_creacion' => date('Y-m-d H:i:s'),
                'stm_usu_modificacion' => $this->tank_auth->get_user_id(),
                'stm_fecha_modificacion' => date('Y-m-d H:i:s') 
                            );

            $consulta_stm = $this->gsatelite->ingresar('stm_sustituto_maestro', $datos);
            $consulta_dhs = '';
            // Horario que llegara a  sustituir
            $horario = $this->input->post('slcHorarioSustituir');

            $datos_array = array(
                 'dhs_id_dfr'  => $horario
                ,'dhs_id_stm' => $consulta_stm
                ,'dhs_estado' => 1
                ,'dhs_usu_creacion' => $this->tank_auth->get_user_id()
                ,'dhs_fecha_creacion' => date('Y-m-d H:i:s')
                ,'dhs_usu_modificacion' => $this->tank_auth->get_user_id()
                ,'dhs_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $consulta_dhs = $this->gsatelite->ingresar('dhs_detalle_horario_sustituir', $datos_array);

            if(count($consulta_stm) > 0 && count($consulta_dhs)>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registros procesados",'texto_alerta'=>"Sustitución procesados correctamente");
            }
            else{
                 $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error de inserción",'texto_alerta'=>"La sustitución no pudo ser procesado");
            }
            $this->session->set_flashdata($alerta);

            $tipo_btn =  $this->input->post('btnCrear');
            if ($tipo_btn == 1) {
                redirect('registro_academico/procesos/agregar_sustituto');
            } else {//Regresar a la lista
                redirect('registro_academico/procesos/maestro_sustituto');  
            }

        } else {
            $html = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1), null, '', 'ard_id', true);
            $data['areas'] = str_replace('<option value="0">Seleccione</option>', '', $html);

            $where['emp_estado'] = 1;
            $data['docentes'] = $this->registro_academico_model->get_empleados_like($where, null, 1);
            
            $data['titulo_personal'] = 'Sustitución de Maestro';
            $this->_cargarvista($data); 
        }
    }

    /**
     * Descripción:
     * Función Ajax para mostrar grupos
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-01
     * @param ninguno
     * @return Obtener los grupos por áreas
     */
    function ajax_areas_grupo() {
        satelite_validar();

        if($this->input->post()) {
            $area = (is_numeric($this->input->post('area')))?$this->input->post('area'):'';

            $where = array(
                            'gra_id_ard'        =>$area, 
                            'gra_estado'        =>1
            );

            // $grupos_info = $this->registro_academico_model->obtener_grupos($where);
            $grupos_info = $this->gsatelite->get_tabla('gra_grupo_academico', $where);
            $html = '<option value=""></option>';
            foreach ($grupos_info as $key => $value) {
                $html .= '<option value="'.$value['gra_id'].'">'.$value['gra_nombre'].'</option>';
            }
            $grupos = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $html);
            echo json_encode(array('grupos'=>$grupos));
        }
    }

    /**
     * Descripción:
     * Función Ajax para mostrar informacion del grupo
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-01
     * @param ninguno
     * @return Obtener los datos de grupo
     */
    function ajax_grupo_info() {
        satelite_validar();

        if($this->input->post()) {
            $grupo = (is_numeric($this->input->post('grupo')))?$this->input->post('grupo'):'';
            $grupo_info = $this->registro_academico_model->get_grupo_info(array('gra_id'=>$grupo, 'gra_estado'=>1)); // Grupo cerrados no
            if(count($grupo_info)>0){
                $grupo_docente = $this->registro_academico_model->obtener_docentes(array('dct_id'=>$grupo_info[0]['gra_id_dct']));
                $grupo_horario = $this->registro_academico_model->get_frecuencias(array('frh_id'=>$grupo_info[0]['gra_id_frh']));

                $fecha_inicio = formatear_fecha('d-m-Y', $grupo_info[0]['gra_fecha_inicio']);
                $fecha_fin = formatear_fecha('d-m-Y', $grupo_info[0]['gra_fecha_fin']);

                // ALumnos Inscritos
                $where['lxp_id_gra'] = $grupo;
                $where['lxp_estado'] = 1;
                $where['lxp_condicion'] = 1;
                // $cantidad = $this->registro_academico_model->get_n_alumnos_inscritos($where); //gra_id=8 AND lxp_estado=1  
                 $cantidad = count($this->gsatelite->get_tabla('lxp_alumnoxpensum', $where));
                // $this->db->last_query();die();         

            } else {
                $this->gsatelite->show_dialog('Error en el grupo', '', 'error', 'Error');
                die();
            }
            
            echo json_encode(array('grupo_info'=>$grupo_info[0], 'grupo_horario'=>$grupo_horario[0], 'fecha_inicio'=>$fecha_inicio, 'fecha_fin'=>$fecha_fin, 'docente'=>$grupo_docente[0], 'n_alumnos'=>$cantidad));
        }
    }

    /**
     * Descripción:
     * Función Obtener docentes 
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-04
     * @param ninguno
     * @return Obtener docente menos el solicitado
     */
    function ajax_obtener_docentes() {
        satelite_validar();

        if($this->input->post()){
            $docente = ($this->input->post('id')>0)?$this->input->post('id'):0;
            $nombres = ($this->input->post('nombres')>0)?$this->input->post('nombres'):'';

            
            $where = NULL;
            $like = NULL;

            if($nombres != '') {
                $like = $nombres;
            }

            $where['dct_estado'] = 1;
            if($docente>0) {
                $where['dct_id !='] = $docente;
            }
            
            $docentes_info = $this->registro_academico_model->obtener_docentes($where, NULL, $like);
            echo json_encode($docentes_info);
        }
    }

    /**
     * Descripción:
     * Función validar la fecha de Grupo
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-04
     * @param ninguno
     * @return Validar Fecha de Grupo de Inicio y Fin
     */
     function validar_fecha_grupo() {
        satelite_validar();
        if ($this->input->post()) {

            $fecha = formatear_fecha('Y-m-d', $this->input->post('fechaInicio'));
            $grupo = $this->input->post('grupo');
            $consulta = $this->registro_academico_model->validar_fecha_grupo(array('gra_id'=>$grupo, 'gra_estado'=>1), $fecha);
            // print_r($this->db->last_query());die();
            echo json_encode(array('registro'=>$consulta));
        }
     }

    /**
     * Descripción:
     * Función Obtener el horaro de un grupo
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-04
     * @param ninguno
     * @return Obtener horario de un grupo
     */
     function obtener_horarios_grupo() {
        if($this->input->post()) {
            $fechaInicio = (count($this->input->post('fechaInicio'))>0)?$this->input->post('fechaInicio'):'';
            $fechaFin = (count($this->input->post('fechaFin'))>0)?$this->input->post('fechaFin'):'';
            $grupo = (is_numeric($this->input->post('grupo')))?$this->input->post('grupo'):'';
            $docente = (is_numeric($this->input->post('docente')))?$this->input->post('docente'):'';
            $sustituto = (is_numeric($this->input->post('sustituto')))?$this->input->post('sustituto'):'';
            $grupo_info = $this->gsatelite->get_registro('gra_grupo_academico', array('gra_id'=>$grupo, 'gra_estado'=>1));
            
            $grupo_frecuencia = $this->registro_academico_model->get_frecuencias(array('dfr_id_frh'=>$grupo_info->gra_id_frh));
            $contadorHoras = 0;

            $where = array(
                'stm_id_dct_titular'    => $docente,
                // 'stm_id_dct_sustituto'  => $sustituto,
                // 'stm_fecha_inicio >='   => formatear_fecha('Y-m-d', $fechaInicio),
                // 'stm_fecha_fin <='      => formatear_fecha('Y-m-d', $fechaFin),
                'stm_id_gra'            => $grupo,
                'stm_estado'            => 1
            );
            // Registros de Sustituto de este grupo seleccioado
            $horariosustituidos = $this->registro_academico_model->obtener_info_maestro_sustituto($where, 'hrg_id');
            $array_hrg = array();
            if (count($horariosustituidos)>0) {
                foreach ($horariosustituidos as $key => $value) {
                    $array_hrg[] = $value['hrg_id'];
                }
            }
            // print_r($array_hrg);die();
            // Grupo Seleccionado
            $array_gra_hrg = array();
            $array_hrg_dias = array();
            $array_dfr = array();
            foreach ($grupo_frecuencia as $key => $value) {
                $array_dfr[] = $value['dfr_id'];
                $array_gra_hrg[] = $value['hrg_id'];
                $array_hrg_dias[] = $value['dia_nombre'];
            }

            $fechainicioformat = formatear_fecha('d-m-Y', $fechaInicio);
            $fechafinformat = formatear_fecha('d-m-Y', $fechaFin);

            $fechaInicio=strtotime($fechainicioformat); // Formato 25-02-2008
            $fechaFin=strtotime($fechafinformat); // Formato 01-04-2008
            $dias_ES = array("Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado", "Domingo");
            $dias_EN = array("Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday");
            // Calculo de dias que deben ser pagados
            $html = '<option value=""></option>';
            
            if (count($array_hrg)>0) {
                foreach ($array_gra_hrg as $key1 => $value1) {
                    foreach ($array_hrg as $key2 => $value2) {
                        if ($value1 == $value2) {
                            unset($array_dfr[$key1]);
                            unset($array_gra_hrg[$key1]);
                            unset($array_hrg_dias[$key1]);
                        }
                    }
                }
            } 
            
            // foreach ($grupo_frecuencia as $key => $value) {
            //     for($i=$fechaInicio; $i<=$fechaFin; $i+=86400){
            //         $dia = date("l", $i);
            //         $nombredia = str_replace($dias_EN, $dias_ES, $dia);
            //         if($nombredia == $value['dia_nombre']){
            //             $contadorHoras += ((int)$value['hrg_fin']-(int)$value['hrg_inicio']); 
            //         }
            //         // echo $nombredia.' '.$diaN.' '.$mes.' '.$anio."<br>";
            //         $html .= '<option value="'.$value['dfr_id'].'">'.$value['dia_nombre'].' '.date("h:i A", strtotime($value['hrg_inicio'])).' - '.date("h:i A", strtotime($value['hrg_fin'])).'</option>';
            //     }
            // }
            // $horariosSustituto = $this->gsatelite->get_tabla('dhs_detalle_horario_sustituir', array('dhs_estado'=>1));
            // print_r($array_gra_hrg);die();
            $horariosGrupo = $this->gsatelite->get_tabla('hrg_horario_grupo', array('hrg_estado'=>1));
            if (count($array_gra_hrg)>0) {
                foreach ($horariosGrupo as $key1 => $value1) {
                    foreach ($array_gra_hrg as $key2 => $value2) {
                        if ($array_gra_hrg[$key2] == $value1['hrg_id']) {
                            $html .= '<option value="'.$array_dfr[$key2].'">'.$array_hrg_dias[$key2].' '.date("h:i A", strtotime($value1['hrg_inicio'])).' - '.date("h:i A", strtotime($value1['hrg_fin'])).'</option>';
                        }
                    }
                }
            }
           
            $horarios = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $html);

            echo json_encode(array('horas'=>$contadorHoras, 'horarios'=>$horarios, 'array_hrg' => $array_hrg, 'array_gra_hrg' => $array_gra_hrg, 'array_hrg_dias' => $array_hrg_dias, 'array_dfr' => $array_dfr));
        }
     }

    /**
     * Descripción:
     * Función Obtener el escalafon de un docente especifico
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-04
     * @param ninguno
     * @return Ottener el escalafon de un docente
     */
     function ajax_escalafon_docente() {
        satelite_validar();

        if($this->input->post()) {
            $docenteSustituto = $this->input->post('docenteSustituto');
            $this->db->join('exd_escalafonxdocente', 'tbe_id=exd_id_tbe', 'inner');
            $consulta = $this->gsatelite->get_tabla('tbe_tabla_escalafon', array('exd_id_dct'=>$docenteSustituto, 'exd_estado'=>1));
            $html = '<option value=""></option>';
            foreach ($consulta as $key => $value) {
                $html .= '<option value="'.$value['tbe_id'].'">'.$value['tbe_clase'].'</option>';
            }
            $escalafon = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $html);
            echo json_encode(array('escalafon'=>$escalafon));
        }
     }

     /**
     * @author Edith Herrera
     * @since  04-12-2017
     * @return Grid de traslado de alumnos (masivo).
     **/
    public function traslado_grupo() {
        satelite_validar();
        
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        if ($_POST) {
            $post_array = $_POST;
            $proyeccion = (isset($post_array['proyeccion']) && $post_array['proyeccion']!='')?$post_array['proyeccion']:$post_array['slcProyeccion'];
            $docente = (isset($post_array['docente']) && $post_array['docente']!='')?$post_array['docente']:$post_array['slcDocente'];
            $grupo = (isset($post_array['grupo']) && $post_array['grupo']!='')?$post_array['grupo']:$post_array['slcGrupo'];
            $tipo_reporte = $post_array['tipo_reporte'];

            $where = null;           
            if ($proyeccion > 0) {
                $where['pyc_id'] = $proyeccion;
            }
            if ($docente > 0) {
                $where['gra_id_dct'] = $docente;
            }
            if ($grupo > 0) {
                $where['gra_id'] = $grupo;
            }

            $alumnos = $this->registro_academico_model->get_traslados_alumno($where);
            //die(print_r($this->db->last_query()));
            
            $data['detalles'] = $alumnos;
                   
            $detalle = $this->load->view('registro_academico/procesos/detalle_traslado', $data, true);

            /****************************************************************************/            

            if($tipo_reporte=='pdf'){
                    $data['titulo'] = 'Traslado de alumnos';

                    $data['user']=$this->tank_auth->get_user_id();
                    $html=$this->load->view('reporte/header', array('titulo' => "Traslado de alumnos"), true);
                    $html.= $this->load->view('registro_academico/procesos/traslado_export', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Traslado de alumnos'.date('dmY');

                    $this->pdf->makePdf($html,'L','Cierre de curso','Letter');
            }else if($tipo_reporte == 'excel'){
                    $filename = 'rpt_traslado_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Traslado de alumnos';
                    $data['filename'] = $filename;
                    $data['excel'] = 1;
                    $html = $this->load->view('registro_academico/procesos/traslado_export',$data,true);
                    echo $html;
                    die();
            }else{
                echo $detalle;
                die();
            }

        } else {
            $select = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);
            $data["proyeccion"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);       
          
            $data['titulo_personal'] = "Traslado de alumnos";
            $this->_cargarvista($data);
        }






    }


    /**
     * @author Edith Herrera
     * @since  05-12-2017
     * @return Se obtienen empleados.
    * */

    public function get_empleados_like($docente=null) {
        satelite_validar(true);
        $empleado = $this->input->post('empleado');

        $where = null;
        $like = null;

        $like = array(
            "CONCAT_WS(' ',emp_codigo,' - ',emp_nombre, emp_apellido)" => $empleado,
        );
        $where['emp_estado'] = 1;

        $sucursal_str = $this->get_sucursales();                          
        $where['dct_id_suc in('.$sucursal_str.')'] = NULL;

        $arreglo = array();
        $empleados = $this->registro_academico_model->get_empleados_like($where, $like, $docente);
        
        if (count($empleados) > 0) {
            foreach ($empleados as $key => $value) {
                if($docente!=null){
                    $arreglo[$key]['empleado'] = $value['dct_id'];    
                }else{
                    $arreglo[$key]['empleado'] = $value['emp_id'];
                }
                $arreglo[$key]['emp_nombre'] = $value['empleado'];
            }
        }
        echo json_encode($arreglo);
    }

    public function get_gfa_like() {
        satelite_validar(true);
        $gfa = ($this->input->post('gfa') != '') ? $this->input->post('gfa') : null;
        $where  = null;
        $like   = null;
             
        if ($gfa != '') {
            $like['gfa_nombre'] = $gfa;
        }

        $where['gfa_estado'] = 1;

        $arreglo = array();
        $grupo_familiares = $this->registro_academico_model->get_gfa_like($where, $like);

        if (count($grupo_familiares) > 0 ) {
            foreach ($grupo_familiares as $key => $value) {
                $arreglo[$key]['gfa'] = $value['gfa_id'];
                $arreglo[$key]['gfa_nombre'] = $value['gfa_nombre'];
            }
        }
        echo json_encode($arreglo);
    }


    /**
     * @author Edith Herrera
     * @since  04-12-2017
     * @return Traslado de alumnos (masivo).
     **/
    public function traslado_alumnos($grupo=null, $trl_id=null) {
        satelite_validar();

        if($_POST){
        /******* Destino **************/
        $grupo_dst = $this->input->post('slcGrupo_dst');
        $observacion = $this->input->post('observacion');
        $proyeccion_dst = $this->input->post('slcProyeccion_dst'); 
        
        /******* Origen **************/
        $proyeccion = $this->input->post('slcProyeccion');
        $grupo = $this->input->post('slcGrupo');

        /******* Detalles ************/
        $alm_id = $this->input->post('alm_id');
        $alm_proyeccion = $this->input->post('alm_proyeccion');
        $alm_grupo = $this->input->post('alm_grupo'); 
        $lxp_id = $this->input->post('alumno_sel');
        $restante = 0;

            if(count($alm_id)>0 && $alm_id[0]!=''){
                foreach ($alm_id as $key => $value) {
              
                    $where=array();
                    if($alm_grupo[$key]!=null){
                        $where['gra_id']=$alm_grupo[$key];
                    }
                    $inscritos = $this->registro_academico_model->get_alumnos_inscritos($where);
                    $restante = $inscritos->gra_cupo - $inscritos->inscritos;

                    $alumnos = $this->registro_academico_model->obtener_alumnos_grupos(null, array('alm_id'=>$alm_id[$key], 'gra_id'=>$alm_grupo[$key], 'lxp_estado'=>1));

                    $notas_alm = $this->gsatelite->get_tabla('noa_nota_alumno', array('noa_id_lxp'=>$alumnos[0]['lxp_id']));

                    if($restante>=1){
                        $array_inactivo = array(
                                'lxp_estado'=>0,
                                'lxp_traslado'=>1,
                                'lxp_usu_mod'=>$this->tank_auth->get_user_id(),
                                'lxp_fecha_mod'=>date('Y-m-d H:i:s')
                            );
                       $this->gsatelite->actualizar_array('lxp_alumnoxpensum', $array_inactivo, array('lxp_id'=>$lxp_id[$key]));

                        $array_nuevo = array(
                                'lxp_id_lxa'=>$alumnos[0]['lxa_id'],
                                'lxp_id_gra'=>$grupo_dst,
                                'lxp_id_crt'=>$alumnos[0]['lxp_id_crt'],
                                'lxp_id_fac'=>$alumnos[0]['lxp_id_fac'],
                                'lxp_id_def'=>$alumnos[0]['lxp_id_def'],
                                'lxp_observacion'=>$alumnos[0]['lxp_observacion'],
                                'lxp_condicion'=>1,
                                'lxp_promedio'=>$alumnos[0]['lxp_promedio'],
                                'lxp_fecha_inscripcion'=>date('Y-m-d H:i:s'),
                                'lxp_exam_ubicacion'=>$alumnos[0]['lxp_exam_ubicacion'],
                                'lxp_estado'=>1,
                                'lxp_usu_crea'=>$this->tank_auth->get_user_id(),
                                'lxp_fecha_crea'=>date('Y-m-d H:i:s'),
                                'lxp_usu_mod'=>$this->tank_auth->get_user_id(),
                                'lxp_fecha_mod'=>date('Y-m-d H:i:s')
                            );

                        $nuevo = $this->gsatelite->ingresar('lxp_alumnoxpensum', $array_nuevo);


                        $array_traslado=array(
                            'trl_id_alm'=>$alm_id[$key],
                            'trl_id_lxp_origen' => $lxp_id[$key],
                            'trl_id_lxp_destino' => $nuevo,
                            'trl_fecha_traslado'=>date('Y-m-d H:i:s'),
                            'trl_observacion'=>$observacion,
                            'trl_estado'=>1,
                            'trl_usu_creacion'=>$this->tank_auth->get_user_id(),
                            'trl_fecha_creacion'=>date('Y-m-d H:i:s'),
                            'trl_usu_modificacion'=>$this->tank_auth->get_user_id(),
                            'trl_fecha_modificacion'=>date('Y-m-d H:i:s')
                        );
                        $ingreso = $this->gsatelite->ingresar('trl_traslado_alumno', $array_traslado);
                    }


            /***********************************************************************************************************************/
                $resp = 0; //Indicador de evaluaciones 0= se continúa con el taslado.
                           // 1 = No existen evaluaciones en el grupo de destino.
                           // 2 = La configuración de evaluaciones no coincide.

                /***************** OBTENER DATOS DEL NUEVO GRUPO HACIA DONDE SE VA A TRASLADAR **********************/
                $grupo_reg = $this->gsatelite->get_registro('gra_grupo_academico',array('gra_id'=>$grupo_dst));
                $gra_pyc_dst = (count($grupo_reg)>0)?$grupo_reg->gra_id_pyc:0;
                $gra_pen_dst = (count($grupo_reg)>0)?$grupo_reg->gra_id_pen:0;
                    /////// OBTENER EVALUACIONES ASOCIADAS AL NUEVO GRUPO //////
                               $this->db->order_by('evm_orden', 'ASC');
                    $evm_new = $this->gsatelite->get_tabla('evm_evaluacion_modulo', array('evm_id_pyc'=>$gra_pyc_dst, 'evm_id_pen'=>$gra_pen_dst));

                if(count($evm_new)>0){
                    /***************** OBTENER DATOS DEL GRUPO DEL CUAL SE VA A RETIRAR *************************/
                    $grupo_reg = $this->gsatelite->get_registro('gra_grupo_academico',array('gra_id'=>$grupo));
                    $gra_pyc = (count($grupo_reg)>0)?$grupo_reg->gra_id_pyc:0;
                    $gra_pen = (count($grupo_reg)>0)?$grupo_reg->gra_id_pen:0;
                        /// OBTENER EVALUACIONES ASOCIADAS AL PENSUM Y PROYECCIÓN ///
                        /// Cantidad de evaluaciones
                                   $this->db->order_by('evm_orden', 'ASC');
                        $evm_act = $this->gsatelite->get_tabla('evm_evaluacion_modulo', array('evm_id_pyc'=>$gra_pyc, 'evm_id_pen'=>$gra_pen));

                                    $this->db->order_by('evm_orden', 'ASC');
                                    $this->db->join('noa_nota_alumno', 'noa_id_evm=evm_id');
                        $evm_nota = $this->gsatelite->get_tabla('evm_evaluacion_modulo', array('evm_id_pyc'=>$gra_pyc, 'evm_id_pen'=>$gra_pen));
                        
                        if(count($evm_act)==count($evm_new)){
                   
                            if(count($evm_nota)){
                                foreach ($evm_nota as $act) {
                                    $evm_id = $this->gsatelite->get_campo('evm_evaluacion_modulo', 'evm_id', array('evm_id_pyc'=>$gra_pyc_dst, 'evm_id_pen'=>$gra_pen_dst, 'evm_orden'=>$act['evm_orden']));

                                    $array_notas = array(
                                        'noa_id_lxp'=>$nuevo,
                                        'noa_id_evm'=>$evm_id,
                                        'noa_nota'=> $act['noa_nota'],
                                        'noa_observacion'=> $act['noa_observacion'],
                                        'noa_fecha'=> $act['noa_fecha'],
                                        'noa_estado'=> $act['noa_estado'],
                                        'noa_usu_creacion'=> $this->tank_auth->get_user_id(),
                                        'noa_fecha_creacion'=> date('Y-m-d H:i:s'),
                                        'noa_usu_modificacion'=> $this->tank_auth->get_user_id(),
                                        'noa_fecha_modificacion'=> date('Y-m-d H:i:s')
                                        );
                                    $ing_nota = $this->gsatelite->ingresar('noa_nota_alumno', $array_notas);
                               
                                //Se eliminan las notas pertenecientes al alumno
                                $this->gsatelite->borrado_general('noa_nota_alumno', array('noa_id'=>$act['noa_id']));
                                }
                            }
                        }
                }
        /***********************************************************************************************************************/
                }
            }


            if ($ingreso > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Traslado de alumnos", 'texto_alerta' => "Registro(s) ingresado(s) correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Traslado de alumnos", 'texto_alerta' => "Registro(s) no ingresado(s), verifique la información a ingresar.");
            }
            $this->session->set_flashdata($alerta);
            $volver = $this->input->post('volver');
            if ($volver > 0) {
                redirect('registro_academico/procesos/traslado_grupo');
            } else {
                redirect('registro_academico/procesos/traslado_alumnos/'.$alm_grupo[0]);
            }

        } else {
            $fecha_actual = date('Y-m-d');
            if($grupo!=null){
                if($trl_id>0){
                    $data['alumnos'] = $alumnos = $this->registro_academico_model->get_traslados_alumno(array('trl_id'=>$trl_id));

                    $info = $this->registro_academico_model->get_info_trasladoxalumno(array('lxp_id'=>$alumnos[0]['origen_id']));
                    $data['info'] = $info[0];

                    $dest = $this->registro_academico_model->get_info_trasladoxalumno(array('lxp_id'=>$alumnos[0]['destino']));

                    $data['dest'] = $dest[0];

                    $select = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), $dest[0]['gra_id_pyc'], '', 'pyc_id', true);
                    $data["pyc_destino"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select); 

                    $grupos = $this->gsatelite->get_dropdown('gra_grupo_academico', '{gra_nombre}', '', array('gra_estado' => 1, 'gra_id_dct'=>$dest[0]['gra_id_dct']), $dest[0]['gra_id'], '', 'gra_id', true);
                    $data["grupos_dst"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $grupos); 

                    $emp = $this->gsatelite->get_campo('dct_docente', 'dct_id_emp', array('dct_id'=>$dest[0]['gra_id_dct']));
                    $nombre = $this->gsatelite->get_registro('emp_empleado', array('emp_id'=>$emp));
                   
                    $data['dct_id_dst']=$dest[0]['gra_id_dct'];
                    $data['dct_nombre_dst'] = $nombre->emp_nombre.' '.$nombre->emp_apellido;
                    
                }else{
                    $info = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id'=>$grupo));
                }
               
                
                $select = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1, 'date_format(pyc_fecha_fin, "%Y-%m-%d") >= date_format("'.$fecha_actual.'", "%Y-%m-%d")'=>null), $info[0]['gra_id_pyc'], '', 'pyc_id', true);

                $data["pyc_select"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select); 

                $grupos = $this->gsatelite->get_dropdown('gra_grupo_academico', '{gra_nombre}', '', array('gra_estado' => 1, 'gra_id_dct'=>$info[0]['gra_id_dct']), $info[0]['gra_id'], '', 'gra_id', true);
                $data["grupos"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $grupos); 

                $emp = $this->gsatelite->get_campo('dct_docente', 'dct_id_emp', array('dct_id'=>$info[0]['gra_id_dct']));
                $nombre = $this->gsatelite->get_registro('emp_empleado', array('emp_id'=>$emp));
               
                $data['dct_id']=$info[0]['gra_id_dct'];
                $data['dct_nombre'] = $nombre->emp_nombre.' '.$nombre->emp_apellido;
            }else{
                $select = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1, 'date_format(pyc_fecha_fin, "%Y-%m-%d") >= date_format("'.$fecha_actual.'", "%Y-%m-%d")'=>null), null, '', 'pyc_id', true);
                $data["proyeccion"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);  
            }
            
            $data['ver'] = ($trl_id>0)?1:0; 
          
            $data['titulo_personal'] = "Traslado de alumnos";
            $this->_cargarvista($data);
        }

    }

     public function ver_alumnos_trs()
      {
          if (!$this->tank_auth->is_logged_in()) {
              redirect('/auth/login/');
          } else {
            if($_POST){
              $proyeccion  = $this->input->post('proyeccion');
              $docente  = $this->input->post('docente');
              $grupo  = $this->input->post('grupo');

              $ids=$this->input->post('array');

              $where = array();
              $data['no_action']=0;
              if($proyeccion>0){
                $where['gra_id_pyc'] = $proyeccion;
              }

              if($docente>0){
                $where['gra_id_dct'] = $docente;
              }

              if($grupo>0){
                $where['gra_id'] = $grupo;
              }
            
              if(!empty($ids)){
                $this->db->where_in('lxp_id', $ids);
                $data['no_action']=1;
              }
              $data['alumnos']= $alumnos =$this->registro_academico_model->get_alumnos_trs($where);
              //die(print_r($this->db->last_query()));
              
              $html = $this->load->view('registro_academico/procesos/detalle_alumno_trs', $data, true);
              echo $html;

            }else{
               $select = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);
            $data["proyeccion"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

              $data['titulo_personal'] = "Traslado de activo fijo";
              $this->_cargarvista($data);
            }
          }
      }


       /**
     * @author Edith Herrera
     * @since  06-12-2017
     * @return Consulta de notas.
    * */
    public function consulta_notas() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        if ($_POST) {
            $post_array = $_POST;
            $area = $post_array['area'];
            $alumno = $post_array['alumno'];
           

            $where = null;           
            if ($area > 0) {
                $where['lxa_id_ard'] = $area;
            }
            if ($alumno > 0) {
                $where['alm_id'] = $alumno;
            }

            $alumnos = $this->registro_academico_model->obtener_notas_alumnos($where);
            $data['alumnos'] = $alumnos;
            $data['minima'] = $this->gsatelite->get_parametro('SYS_NOTA_MINIMA');

            ////////////////////////////////// Configuración de decimales ////////////////////////////////////////
            $decimales = json_decode($this->gsatelite->get_parametro("RA_DECIMALES"),true);
            $data['cant_decimales'] = (isset($decimales['decimales'])>0)?$decimales['decimales']:2; // Cantidad de decimales a mostrar en las notas.
           
            $html = $this->load->view('registro_academico/procesos/detalle_consulta', $data, true);

            echo $html;
        } else {

            $sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_estado'=>1,'usc_id_usu'=>$this->tank_auth->get_user_id()));

            $where = (count($sucursal) > 0) ? 'ard_estado = 1 AND (ard_id_suc IS NULL OR ard_id_suc = '.$sucursal[0]['usc_id_suc'].')': 'ard_estado = 1';

            $select = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', $where, null, '', 'ard_id', true);
            $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
            
            $data['titulo_personal'] = "Consulta de notas";
            $this->_cargarvista($data);
        }

    }


    /**
     * @author Edith Herrera
     * @since  06-12-2017
     * @return Cargar alumnos por area (consulta de notas - filtro).
    * */
    function cargar_select_alumnos(){
        satelite_validar(true);
        $id_area = $this->input->post('id');
        //incluir sucursales
        $usuario        = $this->tank_auth->get_user_id();    
        $sucurales_array= $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $usuario));
        $sucursales     = array_column($sucurales_array,'usc_id_suc');            
        $sucursal_str   = 0;
        if ( count($sucursales) > 0 ) {   
            $sucursal_str .= ','.implode(",", $sucursales);             
        }             
      
        if($id_area>0) {
            $this->db->where('alm_id_suc in('.$sucursal_str.')', NULL);
            $this->db->where('lxa_id_ard', $id_area);
            $this->db->join('lxa_alumnoxarea', 'lxa_id_alm=alm_id');
        }
        $select = $this->gsatelite->get_dropdown('alm_alumno', '{alm_codigo} - {alm_nombre} {alm_apellido}', '', array('alm_estado' => 1), null, '', 'alm_id', true);
        $alumnos= str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

        echo json_encode($alumnos);
    }

    /**
     * @author Edith Herrera
     * @since  07-12-2017
     * @return Encriptar contraseña (usuario de alumno). 
    * */
    function encript_clave($password) {
        $hasher = new PasswordHash(
                $this->config->item('phpass_hash_strength', 'tank_auth'), $this->config->item('phpass_hash_portable', 'tank_auth'));

        $hashed_password = $hasher->HashPassword($password);
        $post_array['password'] = $hashed_password;

        return $post_array;
    }

    /**
     * Descripción:
     * Función de Obtener los datos de Alumnos
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-06
     * @param ninguno
     * @return Obtener los datos de Alumno
     */
    function get_alumno() {

        satelite_validar(true);
        if($this->input->post()) {
            $id_alumno = $this->input->post('id_alumno');
            $alumno = $this->registro_academico_model->obtener_datos_alumnos(array('alm_id'=>$id_alumno, 'alm_estado'=>1)); 
            
            $nombre_alm = $alumno->alm_nombre.' '.$alumno->alm_apellido;
 
            $arr_alm=array(
                'nombre'    => $alumno->alm_nombre,
                'apellido'  => $alumno->alm_apellido,
                'fecha_nac' => formatear_fecha('d-m-Y', $alumno->alm_fecha_nacimiento),
                'telefono'  => $alumno->tal_numero,
                'id_pro'    => $alumno->alm_id_pro,
                'correo'    => $alumno->alm_email,
                'id_tbe'    => $alumno->dce_id_tde,
                'documento' => $alumno->dce_valor
            );
           
            echo json_encode($arr_alm);
            die();
        }

    }

    /**
     * @author Edith Herrera
     * @since  07-12-2017
     * @return Consulta de notas para alumno.
    * */
    public function consulta_notas_alumno() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        if ($_POST) {
            $post_array = $_POST;
            $area = $post_array['area'];
            $user = $this->tank_auth->get_user_id();

            $alumno_reg = $this->gsatelite->get_registro('alm_alumno', array('alm_id_usu'=>$user));  
            
            $alumno = 0;
            $where = null;           
            if ($area > 0) {
                $where['lxa_id_ard'] = $area;
            }
           
            if (!empty($alumno_reg)) {
                $where['alm_id'] = $alumno_reg->alm_id;
                $alumnos = $this->registro_academico_model->obtener_notas_alumnos($where);
                $alumno = $alumno_reg->alm_id;
            }else{
                $alumnos=array();
            }
       
            $data['alumnos'] = $alumnos;
            $data['cant_decimales'] = (isset($decimales['decimales'])>0)?$decimales['decimales']:2; // Cantidad de decimales a mostrar en las notas.
            $html = $this->load->view('registro_academico/procesos/detalle_consulta', $data, true);
            echo json_encode(array('tabla'=>$html, 'alumno'=>$alumno));
        } else {
            $user = $this->tank_auth->get_user_id();

            $alumno = $this->gsatelite->get_registro('alm_alumno', array('alm_id_usu'=>$user)); 
            if(!empty($alumno)){
                $data['alumno'] = $alumno->alm_nombre.' '.$alumno->alm_apellido;
                $areas = $this->gsatelite->get_tabla('lxa_alumnoxarea', array('lxa_id_alm'=>$alumno->alm_id));

                $areas_asig = array();
                if(count($areas)>0 && !empty($areas)){
                    foreach ($areas as $key) {
                        $areas_asig[]=$key['lxa_id_ard'];
                    }
                }
                
                if(!empty($areas_asig)){
                    $this->db->where_in('ard_id', $areas_asig);
                }
            }else{
                $data['alumno'] = '';
            }           
            $select = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1), null, '', 'ard_id', true);
            $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
            
            $data['titulo_personal'] = "Consulta de notas por alumno";
            $this->_cargarvista($data);
        }

    }

    /**
     * @author Edith Herrera
     * @since  07-12-2017
     * @return Eliminar grupo.
    * */
     function grupo_delete($id_grupo = NULL) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $gra = $this->gsatelite->get_campo('lxp_alumnoxpensum', 'lxp_id_gra', array('lxp_id_gra' => $id_grupo));
            if ($gra <= 0 || $gra == '') {
               // $registro_uxg = $this->gsatelite->borrado_general('uxg_uni_grupo', array('uxg_id_gra' => $id_grupo));
           // die(print_r($registro_uxg));
               // if($registro_uxg > 0){
                    $registro = $this->gsatelite->borrado_general('gra_grupo_academico', array('gra_id' => $id_grupo));
                    if ($registro > 0) {
                        $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro borrado", 'texto_alerta' => "El registro ha sido eliminado.");
                    }
               // }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "NOTA", 'texto_alerta' => "Otros registros dependen de éste, por lo que no podrá ser eliminado");
            }

            $this->session->set_flashdata($alerta);
            redirect('registro_academico/procesos/gestion_grupos');
        }
    }

    /**
     * Descripción:
     * Función para ajax para obtener los grupos
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-07
     * @param ninguno
     * @return Obtener los grupos
     */
    function ajax_obtener_grupos() {
        satelite_validar();

        if ($this->input->post()) {
            $area = $this->input->post('area');
            $nivel = $this->input->post('nivel');

            $where = array(
                'ard_id'    => $area,
                'mod_id'    => $nivel,
                'gra_estado'=> 1
            );

            $consulta = $this->registro_academico_model->get_grupo_info($where);
            $html = '<option value=""></option>';
            foreach ($consulta as $key => $value) {
                $html .= '<option value="'.$value['gra_id'].'">'.$value['gra_nombre'].'</option>';
            }
            $grupos = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $html);
            echo json_encode(array('grupos'=>$grupos));
        }   
    }

    /**
     * Descripción:
     * Función ajax para obtener informacion del sustituto
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-07
     * @param ninguno
     * @return Obtener informacion del docente sustituto
     */
    function ajax_info_sustituto() {
        satelite_validar(true);

        if($this->input->post()) {
            $sustituto = $this->input->post("sustituto");
            $where['stm_estado'] = 1;
            if ($sustituto>0) $where['stm_id'] = $sustituto;
            $consulta_stm = $this->registro_academico_model->obtener_maestros_sustituto($where);
            if (count($consulta_stm)>0) {
                $grupo = $this->registro_academico_model->get_grupo_info(array('gra_id'=>$consulta_stm[0]['stm_id_gra']));
                // ALumnos Inscritos
                $where = array();
                $where['lxp_id_gra'] = $consulta_stm[0]['stm_id_gra'];
                $where['lxp_estado'] = 1;
                $where['lxp_condicion'] = 1;
                $cantidad = count($this->gsatelite->get_tabla('lxp_alumnoxpensum', $where));
                $consulta_horario = $this->registro_academico_model->get_frecuencias(array('dfr_id'=>$consulta_stm[0]['dfr_id']));
                $horario = date("h:i A", strtotime($consulta_horario[0]['hrg_inicio'])).' - '.date("h:i A", strtotime($consulta_horario[0]['hrg_fin']));
                $gra_fechaInicio = formatear_fecha('d-m-Y', $grupo[0]['gra_fecha_inicio']);
                $gra_fechaFin = formatear_fecha('d-m-Y', $grupo[0]['gra_fecha_fin']);
                $escalafon = $this->gsatelite->get_tabla('tbe_tabla_escalafon', array('tbe_estado'=>1));
                $datos = array(
                    'sustituto'     => $consulta_stm,
                    'grupo'         => $grupo,
                    'escalafon'     => $escalafon,
                    'fecha_inicio'  => $gra_fechaInicio,
                    'fecha_fin'     => $gra_fechaFin,
                    'n_alumnos'     => $cantidad,
                    'horario'       => $horario
                );

                echo json_encode($datos);
            } else {
                $this->gsatelite->show_dialog('Error en la consulta', '', 'error', 'Error');
            }
            
        }
    }

     /**
     * @author Edith Herrera
     * @since  08-11-2017
     * @return Cargar proyecciones por área.
     * */
    function cargar_select_proyeccion(){
        satelite_validar(true);
        $id_area = $this->input->post('area');

        if($id_area>0){
            $this->db->where('pyc_id_ard', $id_area);
        }
        $select = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);
        $proyecciones = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

        echo json_encode($proyecciones);
    }

    /**
     * Descripción:
     * Función para validar docente sustituto
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-07
     * @param ninguno
     * @return Validar docente sustituto
     */
    function validar_docente_sustituto() {
        satelite_validar();

        if($this->input->post()) {

            $area = $this->input->post('area');
            $grupo = $this->input->post('grupo');
            $docenteTitular = $this->input->post('dct_titular');
            $docenteSustituto = $this->input->post('dct_sustituto');
            $resp=0;
            // print_r($this->input->post());die();
            $where = array(
                'stm_id_dct_titular'    => $docenteTitular,
                'stm_id_dct_sustituto'  => $docenteSustituto,
                'stm_id_gra'            => $grupo,
                'dhs_estado'            => 1 
            );

            $consulta_stm_sustituto = $this->registro_academico_model->obtener_info_maestro_sustituto($where);
            // $horarios = $this->gsatelite->get_tabla('dhs_detalle_horario_sustituir', $where1);
            // $sustituto = $this->gsatelite->get_tabla('stm_sustituto_maestro', $where2);
          
            if(count($consulta_stm_sustituto)>0) {
                $resp=1;
            } else {
                $resp=0;
            }

            echo json_encode(array('resp' => $resp));
        }
    }

    /**
     * Descripción:
     * Función para vista de horarios de supervisor
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-07
     * @param ninguno
     * @return Obtener vista de horarios de supervidor
     */
    function horarios_supervisor() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        if($this->input->post()) {
            $supervisor = (is_numeric($this->input->post('supervisor')))?$this->input->post('supervisor'):'';

            $where = array();
            $html = '';

            if($supervisor != '') {
                $where['hrs_id_sug'] = $supervisor;
            }
            $where['hrs_estado'] = 1;

            $data['supervisor'] = $this->registro_academico_model->obtener_horarios_supervisor($where);
            $html = $this->load->view('registro_academico/procesos/detalle_horarios_supervisor', $data, true);

            echo $html;
            die();
 
        } else {
            $this->db->join('emp_empleado', 'sug_id_emp=emp_id', 'left');
            $supervisores = $this->gsatelite->get_dropdown('sug_supervisor_grupo', '{emp_nombre} {emp_apellido}', '', array('sug_estado' => 1), null, '', 'sug_id', true);
            $data['supervisores'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $supervisores);

            // $html = $this->load->view('registro_academico/procesos/detalle_horarios_supervisor', $data, true);
            $data['titulo_personal'] = "Horarios de Supervidor";
            $this->_cargarvista($data);
        }

    }

    /**
     * Descripción:
     * Función para agregar horario de supervisor
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-07
     * @param ninguno
     * @return La vista para agregar horario de supervisor
     */
    function agregar_horario_supervisor() {
        satelite_validar();

        if($this->input->post()) {
            // Registrar un nuevo horario de supervisor
            // print_r($_POST);die();
            $supervisor = (trim($this->input->post('slcSupervisor')) != '')?$this->input->post('slcSupervisor'):'';
            $fechaInicio = (trim($this->input->post('txtfechainicio')) != '')?$this->input->post('txtfechainicio'):'';
            $fechaFin = (trim($this->input->post('txtfechafin')) != '')?$this->input->post('txtfechafin'):'';
            $escalafon = (trim($this->input->post('slcEscalafon')) != '')?$this->input->post('slcEscalafon'):0;
            $remunerada = (trim($this->input->post('slcRemunerada')) != '')?$this->input->post('slcRemunerada'):NULL;
            $escalafon_valor = (trim($this->input->post('txtValorEscalafon')) != '')?$this->input->post('txtValorEscalafon'):'';
            $total_horas = (trim($this->input->post('txt_total_horas')) != '')?$this->input->post('txt_total_horas'):'';
            
            $dias_entre_fecha = (count($this->input->post('txt_dias_entre_fechas'))>0)?$this->input->post('txt_dias_entre_fechas'):0; // Array
            $dias = (count($this->input->post('dia'))>0)?$this->input->post('dia'):0; // Array
            $horarios = (count($this->input->post('horarios'))>0)?$this->input->post('horarios'):0; // Array
            $horas = (count($this->input->post('horas'))>0)?$this->input->post('horas'):0; // Array
            $diasTotal = (count($this->input->post('diaTotal'))>0)?$this->input->post('diaTotal'):0;

            $contador = 0;// Horas totales

            if (count($horas)>0) {
                foreach ($horas as $key => $value) {
                    $contador += ($horas[$key]*$diasTotal[$key]);   
                }
            }

            // Tabla hrs_horario_supervisor
            $datos = array (
                'hrs_id_sug' => $supervisor,
                'hrs_id_tbe' => $escalafon,
                'hrs_tiempo_pagado' => ($remunerada == 2)?0:1,
                'hrs_fecha_inicio' => formatear_fecha('Y-m-d', $fechaInicio),
                'hrs_fecha_fin' => formatear_fecha('Y-m-d', $fechaFin),
                'hrs_total_horas' => $contador,
                'hrs_valor_hora' => $escalafon_valor,
                'hrs_estado' => 1,
                'hrs_usu_creacion' => $this->tank_auth->get_user_id(),
                'hrs_fecha_creacion' => date('Y-m-d H:i:s'),
                'hrs_usu_modificacion' => $this->tank_auth->get_user_id(),
                'hrs_fecha_modificacion' => date('Y-m-d H:i:s') 
            );
        
            $consulta_hrs = $this->gsatelite->ingresar('hrs_horario_supervisor', $datos);
            $consulta_dhr = '';

            if (count($dias)>0 && count($horarios)>0){
                foreach ($dias as $key => $value) {
                 $datos_array = array(
                         'dhr_id_hrs'  => $consulta_hrs
                        ,'dhr_id_hrg' => $horarios[$key]
                        ,'dhr_id_dia' => $dias[$key]
                        ,'dhr_hora' =>  $horas[$key]
                        ,'dhr_num_dias' => $diasTotal[$key]
                        ,'dhr_estado' => 1
                        ,'dhr_usu_creacion' => $this->tank_auth->get_user_id()
                        ,'dhr_fecha_creacion' => date('Y-m-d H:i:s')
                        ,'dhr_usu_modificacion' => $this->tank_auth->get_user_id()
                        ,'dhr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $consulta_dgr = $this->gsatelite->ingresar('dhr_detalle_horario_supervisor', $datos_array);
                }
            }

            if(count($consulta_hrs) > 0 && count($consulta_dhr)>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registros procesados",'texto_alerta'=>"Registros procesados correctamente");
            }
            else{
                 $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error de inserción",'texto_alerta'=>"El registro no pudo ser procesado");
            }
            $this->session->set_flashdata($alerta);

            $tipo_btn =  $this->input->post('btnCrear');
            if ($tipo_btn == 1) {
                redirect('registro_academico/procesos/agregar_horario_supervisor');
            } else {//Regresar a la lista
                redirect('registro_academico/procesos/horarios_supervisor');  
            }

        } else {
            // Supervisores
            $this->db->join('emp_empleado', 'sug_id_emp=emp_id', 'left');
            $supervisores = $this->gsatelite->get_dropdown('sug_supervisor_grupo', '{emp_nombre} {emp_apellido}', '', array('sug_estado' => 1), null, '', 'sug_id', true);
            $data['supervisores'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $supervisores);

            $this->db->group_by("dia_id");
            $dias = $this->gsatelite->get_dropdown('dia_dia', '{dia_nombre}', '', array('dia_estado' => 1), null, '', 'dia_id', true);
            $data['dias'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $dias);

            $escalafon = $this->gsatelite->get_dropdown('tbe_tabla_escalafon', '{tbe_clase}', '', array('tbe_estado' => 1), null, '', 'tbe_id', true);
            $data['escalafon'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $escalafon);

            $hrg = $this->gsatelite->get_tabla('hrg_horario_grupo', array('hrg_estado'=>1));
            $html = '<option value=""></option>';
            foreach ($hrg as $key => $value) {
                $html .= '<option value="'.$value['hrg_id'].'">'.date("h:i A", strtotime($value['hrg_inicio'])).' - '.date("h:i A", strtotime($value['hrg_fin'])).'</option>';
            }

            $data['horarios'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $html);

            $data['titulo_personal'] = "Horario de Supervidor";
            $this->_cargarvista($data);
        }
    }

    /**
     * @author Edith Herrera
     * @since  09-12-2017
     * @return Cargar Clientes de tipo jurídico.
    * */
    public function get_clientes_like($cli_busqueda = null, $tipo=null) {
        
        $post_array = $this->input->post();
        $cliente = ($cli_busqueda != null) ? $cli_busqueda : $this->input->post('cliente');
        $tipo_cli = (isset($post_array['tipo']) && $post_array['tipo'] != null) ? $post_array['tipo'] : $tipo ;

        $resultado = null;
        $arreglo = array();
        $where = array();
        if ($cliente != null) {
            $where['cli_estado'] = 1;
            if($tipo_cli!=null){
                $where['cli_personeria'] = $tipo_cli;
            }

            $like = array("CONCAT(cli_nombre, ' ', cli_apellido)" => $cliente);

            $resultado = $this->registro_academico_model->get_clientes($where, $like);
            if (count($resultado) > 0) {
                foreach ($resultado as $key => $value) {
                    $arreglo[$key]['cliente'] = $value['cli_id'];
                    $arreglo[$key]['cliente_nombre'] = $value['cliente'];
                }
            }
        }
        if ($cli_busqueda != null) {
            return $resultado;
        }
        echo json_encode($arreglo);
    }

    /**
     * Descripción:
     * Función ajax para obtener el valor del escalfon
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-11
     * @param ninguno
     * @return Obtener el monto del escalafon seleccionado
     */
    function ajax_escalafon() {
        satelite_validar(true);

        if($this->input->post()) {
            $escalafon = (is_numeric($this->input->post("escalafon")))?$this->input->post("escalafon"):0;

            if($escalafon>0) {
                $where = array(
                        "tbe_id"        => $escalafon,
                        "tbe_estado"    => 1
                );
                $consulta = $this->gsatelite->get_registro('tbe_tabla_escalafon', $where);
                $datos = array(
                    "monto" => $consulta->tbe_monto
                );
                echo json_encode($datos);

            } else {
                echo json_encode(array('exito'=>0));
            }
        }
    }

    /**
     * Descripción:
     * Función ajax para obtener el horario de un grupo
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-11
     * @param ninguno
     * @return Obtener el horario inicio y fin
     */
    function ajax_horarios() {
        satelite_validar(true);

        if($this->input->post()) {
            $hrg = (is_numeric($this->input->post("horario")))?$this->input->post("horario"):0;

            if($hrg>0) {
                $where = array(
                        "hrg_id"        => $hrg,
                        "hrg_estado"    => 1
                );
                $consulta = $this->gsatelite->get_registro('hrg_horario_grupo', $where);
                $datos = array(
                    "horario_inicio" => $consulta->hrg_inicio,
                    "horario_fin"    => $consulta->hrg_fin
                );
                echo json_encode($datos);
            }
        }
    }

    /**
     * Descripción:
     * Función para obtener la vista de modificar horario de supervisor
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-12
     * @param $horario = el ID del horario del supervisor
     * @return Obtener la vista de horario de supervisor
     */
    function editar_horarios_supervisor($horario=NULL, $opcion=NULL) {
        satelite_validar();
        if ($horario != NULL) {
            if ($this->input->post()) {
                                
                //print_r($_POST);die();
                $supervisor = (trim($this->input->post('slcSupervisor')) != '')?$this->input->post('slcSupervisor'):'';
                $fechaInicio = (trim($this->input->post('txtfechainicio')) != '')?$this->input->post('txtfechainicio'):'';
                $fechaFin = (trim($this->input->post('txtfechafin')) != '')?$this->input->post('txtfechafin'):'';
                $escalafon = (trim($this->input->post('slcEscalafon')) != '')?$this->input->post('slcEscalafon'):NULL;
                $escalafon_valor = (trim($this->input->post('txtValorEscalafon')) != '')?$this->input->post('txtValorEscalafon'):'';
                $remunerada = (trim($this->input->post('slcRemunerada')) != '')?$this->input->post('slcRemunerada'):NULL;

                $total_horas = (trim($this->input->post('txt_total_horas')) != '')?$this->input->post('txt_total_horas'):'';
                
                $dias_entre_fecha = (count($this->input->post('txt_dias_entre_fechas'))>0)?$this->input->post('txt_dias_entre_fechas'):0; // Array
                $dias = (count($this->input->post('dia'))>0)?$this->input->post('dia'):0; // Array
                $horarios = (count($this->input->post('horarios'))>0)?$this->input->post('horarios'):0; // Array
                $horas = (count($this->input->post('horas'))>0)?$this->input->post('horas'):0; // Array
                $diasTotal = (count($this->input->post('diaTotal'))>0)?$this->input->post('diaTotal'):0;

                $contador = 0;// Horas totales

                if (count($horas)>0) {
                    foreach ($horas as $key => $value) {
                        $contador += ($horas[$key]*$diasTotal[$key]);   
                    }
                }
            
                // Tabla hrs_horario_supervisor
                $datos = array (
                    'hrs_id_tbe' => $escalafon,
                    'hrs_tiempo_pagado' => ($remunerada == 2)?0:1,
                    'hrs_fecha_inicio' => formatear_fecha('Y-m-d', $fechaInicio),
                    'hrs_fecha_fin' => formatear_fecha('Y-m-d', $fechaFin),
                    'hrs_total_horas' =>  $contador,
                    'hrs_valor_hora' => $escalafon_valor,
                    'hrs_estado' => 1,
                    'hrs_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'hrs_fecha_modificacion' => date('Y-m-d H:i:s') 
                    );
            
                $consulta_hrs = $this->gsatelite->actualizar_array('hrs_horario_supervisor', $datos, array('hrs_id'=>$horario));
                $consulta_dhr = '';

                $this->gsatelite->borrado_general('dhr_detalle_horario_supervisor', array('dhr_id_hrs'=>$horario));
                
                if (count($dias) > 0 && count($horarios)>0){
                    foreach ($dias as $key => $value) {
                     $datos_array = array(
                             'dhr_id_hrs'  => $horario
                            ,'dhr_id_hrg' => $horarios[$key]
                            ,'dhr_id_dia' => $dias[$key]
                            ,'dhr_hora' =>  $horas[$key]
                            ,'dhr_num_dias' => $diasTotal[$key]
                            ,'dhr_estado' => 1
                            ,'dhr_usu_creacion' => $this->tank_auth->get_user_id()
                            ,'dhr_fecha_creacion' => date('Y-m-d H:i:s')
                            ,'dhr_usu_modificacion' => $this->tank_auth->get_user_id()
                            ,'dhr_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $consulta_dgr = $this->gsatelite->ingresar('dhr_detalle_horario_supervisor', $datos_array);
                    }
                }

                if(count($consulta_hrs) > 0 && count($consulta_dhr)>0){
                    $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registros actualizados",'texto_alerta'=>"Registros actualizados correctamente");
                }
                else{
                     $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error de actualización",'texto_alerta'=>$mensaje);
                }
                $this->session->set_flashdata($alerta);

                $tipo_btn =  $this->input->post('btnCrear');
                if($tipo_btn == 1){
                    redirect('registro_academico/procesos/editar_horarios_supervisor/'.$horario);
                }
                else{//Regresar a la lista
                    redirect('registro_academico/procesos/horarios_supervisor');  
                }

            } else {
                $data['opcion'] = (is_numeric($opcion))?$opcion:0;

                $where['hrs_id'] = $horario;
                $where['hrs_estado'] = 1;

                $data['horario_supervisor'] = $this->registro_academico_model->obtener_horarios_supervisor($where);
                $data['detalle_horario'] = $this->gsatelite->get_tabla('dhr_detalle_horario_supervisor', array('dhr_id_hrs'=>$horario,'dhr_estado'=>1));

                // Supervisores
                $this->db->join('emp_empleado', 'sug_id_emp=emp_id', 'left');
                $supervisores = $this->gsatelite->get_dropdown('sug_supervisor_grupo', '{emp_nombre} {emp_apellido}', '', array('sug_estado' => 1), $data['horario_supervisor'][0]['hrs_id_sug'], '', 'sug_id', true);
                $data['supervisores'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $supervisores);

                $dias = $this->gsatelite->get_dropdown('dia_dia', '{dia_nombre}', '', array('dia_estado' => 1), null, '', 'dia_id', true);
                $data['dias'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $dias);

                $data['hrg_horario_grupo'] = $this->gsatelite->get_tabla('hrg_horario_grupo', array('hrg_estado'=>1));
                $escalafon = $this->gsatelite->get_dropdown('tbe_tabla_escalafon', '{tbe_clase}', '', array('tbe_estado' => 1), $data['horario_supervisor'][0]['hrs_id_tbe'], '', 'tbe_id', true);
                $data['escalafon'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $escalafon);

                $hrg = $this->gsatelite->get_tabla('hrg_horario_grupo', array('hrg_estado'=>1));
                $html = '<option value=""></option>';
                foreach ($hrg as $key => $value) {
                    $html .= '<option value="'.$value['hrg_id'].'">'.date("h:i A", strtotime($value['hrg_inicio'])).' - '.date("h:i A", strtotime($value['hrg_fin'])).'</option>';
                }
                $data['horarios'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $html);

                $data['detalle_dia'] = $this->gsatelite->get_tabla('dia_dia', array('dia_estado'=>1));
                $data['detalle_hrg'] = $this->gsatelite->get_tabla('hrg_horario_grupo', array('hrg_estado'=>1));

                $data['titulo_personal'] = "Horario de Supervidor";
                $this->_cargarvista($data);
            }
        } 
    }

    /**
     * Descripción:
     * Función para eliminar un horario de supervisor
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-12
     * @param $horario = el ID del horario del supervisor
     * @return Eliminar un horario de supervisor
     */
    function eliminar_horarios_supervisor($horario=NULL) {
        satelite_validar();
        if ($horario != NULL) {

            $registro_dhr =  $this->gsatelite->borrado_general('dhr_detalle_horario_supervisor', array('dhr_id_hrs' => $horario)); 
            $registro_hrs = $this->gsatelite->borrado_general('hrs_horario_supervisor', array('hrs_id' => $horario)); 
             
            if($registro_hrs>0){
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro borrado", 'texto_alerta' => "El registro se ha borrado correctamente.");            
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "NOTA", 'texto_alerta' => "El registro posee integridad referencial <br />&nbsp;No podrá ser eliminado.");
            }

            $this->session->set_flashdata($alerta);
            redirect('registro_academico/procesos/horarios_supervisor');
        }
    }

    /**
     * Descripción:
     * Función para imprimir horario supervisor
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-12
     * @param $horario = el ID del horario del supervisor
     * @return Imprimir horario de supervisor
     */
    function imprimir_horario_supervisor($horario=NULL) {
        satelite_validar();
        if($horario!=NULL) {
            $where['hrs_id'] = $horario;
            $where['hrs_estado'] = 1;
            $html = '';

            $data['horario_supervisor'] = $this->registro_academico_model->obtener_horarios_supervisor($where);
            $data['detalle_horario'] = $this->gsatelite->get_tabla('dhr_detalle_horario_supervisor', array('dhr_id_hrs'=>$horario,'dhr_estado'=>1));

            $data['detalle_dia'] = $this->gsatelite->get_tabla('dia_dia', array('dia_estado'=>1));
            $data['detalle_hrg'] = $this->gsatelite->get_tabla('hrg_horario_grupo', array('hrg_estado'=>1));

            $this->load->library('pdf');
            $html.= $this->load->view('registro_academico/procesos/imprimir_horario_supervisor', $data, true);
            $this->pdf->makePDF($html, 'L');
            // echo $html;
        } else {
            $url = base_url('registro_academico/procesos/horarios_supervisor');
            $this->gsatelite->show_dialog('No se ha seleccionado ningun horario de supervisor', $url, 'error', 'Error en Imprimir Horario');
        }
    }

    /**
     * Descripción:
     * Función para imprimir Cierre Curso/Nivel
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-12
     * @param $cierre = el ID del Curso cerrado
     * @return Imprimir el cierre de Curso/Nivel
     */
    function imprimir_cierre_curso($cierre=NULL) {
        satelite_validar();
        if($cierre != NULL) {
            $where = array();
            $where['dcg_id'] = $cierre;
            $where['dcg_estado'] = 1;

            $data['seccion'] = $this->gsatelite->get_tabla('scc_seccion', array('scc_estado'=>1));
            $data['aula'] = $this->gsatelite->get_tabla('aul_aula', array('aul_estado'=>1));
            $data['empleados'] = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado'=>1));

            $data['grupos_cerrados'] = $this->registro_academico_model->get_cierre_grupo($where);
            $data['horario_grupo'] = $this->registro_academico_model->get_horario_grupo(array('gra_id'=>$data['grupos_cerrados'][0]['gra_id']));
            $frecuencia = $this->registro_academico_model->get_frecuencias(array('frh_id'=>$data['grupos_cerrados'][0]['gra_id_frh']));
            $iniciales = '';
            $horario = array();
            foreach ($frecuencia as $key => $value) {
                $iniciales .= $value['dia_nombre'][0].' ';
                array_push($horario, 'Desde: '.date("h:i A", strtotime($value['hrg_inicio'])).' Hasta:'.date("h:i A", strtotime($value['hrg_fin'])));
            }

            $data['horario'] = $horario;
            $data['iniciales'] = $iniciales;
            $this->load->library('pdf');
            $html = $this->load->view('registro_academico/procesos/imprimir_cierre_curso', $data, true);
            $this->pdf->makePDF($html, 'H');
            // echo $html;
        } else {
            $url = base_url('registro_academico/procesos/horarios_supervisor');
            $this->gsatelite->show_dialog('No se ha seleccionado ningun horario de supervisor', $url, 'error', 'Error en Imprimir Horario');
        }
    }

    public function chng_mod_stud(){
        $id_lxp = $this->input->post('lxp');
        $modali = $this->input->post('mod');
        $newmod = array('lxp_modalidad' => $modali,'lxp_fecha_mod' => date('Y-m-d H:i:s'), 'lxp_usu_mod' => $this->tank_auth->get_user_id());
        $update = $this->gsatelite->actualizar_array("lxp_alumnoxpensum", $newmod, array('lxp_id' => $id_lxp));
        echo $update;
    }

     /**
     * @author Edith Herrera
     * @since  11-12-2017
     * @return Grid de la inscripción de alumnos.
    * */
    function inscripcion() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        if ($_POST) {
            $post_array = $_POST;
            $alumno = $post_array['alumno'];
            
            $where = null;
            if ($alumno != '') {
                $where['alm_id '] = $alumno;
            }
            
            // Consultar registros por inscripción
            $where['gra_id_grd IS NULL'] = null;
            $registro = $this->registro_academico_model->get_registro_inscripcion($where);

            $where = null;
            if ($alumno != '') {
                $where['alm_id '] = $alumno;
            }
            //Consultar registros por grado.
            $where['gra_id_grd IS NOT NULL'] = null;
            $registro_grd= $this->registro_academico_model->get_registro_inscripcion($where, 'gra_id_grd');
           
            $reg_final = array_merge($registro, $registro_grd);
            $data['detalles'] = $reg_final;
           
            $html = $this->load->view('registro_academico/procesos/detalles_inscripcion', $data, true);
            echo $html;
        } else {            
            $select         = $this->gsatelite->get_dropdown('alm_alumno', '{alm_nombre} {alm_apellido}', '', array('alm_estado' => 1), null, '', 'alm_id', true);
            $select         = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $select);
            $data["alumno"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
            $data['titulo_personal'] = "Inscripción de alumnos";
            $this->_cargarvista($data);
        }
    }

    function reenviar_credenciales($alumno_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            satelite_validar();
            $alumno = $this->gsatelite->get_registro('alm_alumno', 'alm_id', $alumno_id);            
            $pass = $this->encript_clave($alumno->alm_codigo);
            if ($this->users->change_password($alumno->alm_id_usu, $pass['password']) == true) {
                if(isset($alumno->alm_email) && $alumno->alm_email != '') {
                    $data["nombre_curso"] = null;
                    $data["carnet_alumno"] = $alumno->alm_codigo;
                    $data["url_plataforma"] = base_url().'auth/login';
                    $data["confirmar_primer_curso"] = true;
                    $data["firma_alfa"] = $this->load->view('correo_electronico/firma_alfa', '', true);

                    $message = $this->load->view('registro_academico/correo_electronico/inscripcion_curso', $data, true);

                    $this->gsatelite->envio_correo("", "", $alumno->alm_email, "Reenvío de Credenciales", $message, "alejandrofigueroa416@gmail.com");
                }

                $alerta = array('tipo_alerta'=> 'success', 'titulo_alerta'=> "Reenvío de Credenciales", 'texto_alerta'=> "Se reenvió el correo electrónico al alumno junto a sus credenciales.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Reenvío de Credenciales", 'texto_alerta' => "No pudo reenviarse el correo electrónico, intente nuevamente.");
            }
            
            $this->session->set_flashdata($alerta);
            redirect('registro_academico/procesos/inscripcion');
        }
    }


     /**
     * @author Edith Herrera
     * @since  11-12-2017
     * @return Grid de la inscripción de alumnos.
    * */
    function alumno_inscripcion($lxp_id=null, $alm_id=null) {
        satelite_validar();
        if ($_POST) {
            $post_array = $_POST;

            log_message('info', 'POST Data: ' . json_encode($post_array));

            $proyeccion_id = $post_array['slcProyeccion'];
            $area_id = $post_array['slcArea'];
            $alumno_id = $post_array['slcAlumno'];
            $tipo_ins = $post_array['slcEstadoReg'];
            $listado_precio = $post_array['slcListaPrecio'];     
            $id_cfg = $post_array['id_cfg'];
            $grado = $post_array['id_grado'];

            log_message('info', "Variables: proyeccion_id=$proyeccion_id, area_id=$area_id, alumno_id=$alumno_id, tipo_ins=$tipo_ins, listado_precio=$listado_precio, id_cfg=$id_cfg, grado=$grado");

            if($grado>0){
                log_message('info', 'PROCESO PARA GENERAR CLG');

                /******************************* Proceso de inscripción grado **********************************/
                $this->load->library('../controllers/facturacion/facturar');                
                $masiva = $this->facturar->generar_inscripcion_grado(null, $grado, null, null, $alumno_id, $tipo_ins, $id_cfg, $listado_precio, $proyeccion_id, $area_id);
                log_message('info', 'Resultados generar_inscripcion_grado: ' . ($masiva ? 'Success' : 'Failed'));

            }else{
                log_message('info', 'PROCESO PARA GENERAR CMC');
                /******************** Proceso de inscripción por nivel (no posee grado). ***********************/
                $confirmar_primer_curso = false;
                
                $alumno = $this->gsatelite->get_registro('alm_alumno', 'alm_id', $alumno_id);
                log_message('info', 'Alumno data: ' . json_encode($alumno));

                // Áreas por alumno
                $reg_lxa = $this->gsatelite->get_tabla('lxa_alumnoxarea', array('lxa_id_ard'=>$area_id, 'lxa_id_alm'=>$alumno_id));                
                log_message('info', 'lxa_alumnoxarea: ' . json_encode($reg_lxa));
                
                // Se crea área asociada si el alumno no posee una. 
                if(count($reg_lxa)<=0 && empty($reg_lxa)){
                    $lxa_array = array(
                            "lxa_id_alm" => $alumno_id,
                            'lxa_id_ard' => $area_id,
                            'lxa_fecha_incripcion' => date('Y-m-d'),
                            'lxa_estado' => 1,
                            'lxa_usu_crea' => $this->tank_auth->get_user_id(),
                            'lxa_usu_mod' => $this->tank_auth->get_user_id(),
                            'lxa_fecha_crea' => date('Y-m-d H:i:s'),
                            'lxa_fecha_mod' => date('Y-m-d H:i:s')
                        );
                    $lxa_id = $this->gsatelite->ingresar('lxa_alumnoxarea', $lxa_array);
                    log_message('info', 'Insert into de lxa_alumnoxarea, lxa_id: ' . $lxa_id);
                    $confirmar_primer_curso = true;
                }else{
                    $lxa_id = $reg_lxa[0]['lxa_id'];
                    log_message('info', 'Caso cuando existe reg_lxa, lxa_id: ' . $lxa_id);
                }
                if($lxa_id>0){                    
                    // Tipo de inscripción -> 1= pre-inscripcion, 2 = Inscripcion (oficial)                    
                    // Fechas de acuerdo al proceso seleccionado (Inscripción o pre-inscripción).
                    if($post_array['slcEstadoReg']==1){
                        $fecha_pre = date('Y-m-d H:i:s');
                        $fecha_ins = date('Y-m-d H:i:s');
                    }else{
                        $fecha_pre = null;
                        $fecha_ins = date('Y-m-d H:i:s'); 
                    }                    
                    $inscripcion = array(
                            'lxp_id_lxa'=>$lxa_id,
                            'lxp_id_gra'=>$post_array['slcGrupo'],
                            'lxp_id_fac'=>($post_array['slcFactura']>0)?$post_array['slcFactura']:null,
                            'lxp_id_def'=>($post_array['slcFactura']>0)?$post_array['slcNivel']:null,
                            'lxp_condicion'=>1, 
                            'lxp_fecha_inscripcion'=>$fecha_ins,
                            'lxp_fecha_preinscripcion'=>$fecha_pre,
                            'lxp_observacion'=>'',
                            'lxp_exam_ubicacion'=>$post_array['id_ubic'],
                            'lxp_tipo_inscripcion'=>$post_array['slcEstadoReg'], 
                            'lxp_modalidad'=>($post_array['hdnModalidadEdu']>=0)?$post_array['hdnModalidadEdu']:null,
                            'lxp_estado'=>1,
                            'lxp_usu_crea'=>$this->tank_auth->get_user_id(),
                            'lxp_fecha_crea'=>date('Y-m-d H:i:s'),
                            'lxp_usu_mod'=>$this->tank_auth->get_user_id(),
                            'lxp_fecha_mod'=>date('Y-m-d H:i:s')
                    );
                    log_message('info', 'LXP array: ' . json_encode($inscripcion));
                    $ingreso = $this->gsatelite->ingresar('lxp_alumnoxpensum', $inscripcion);
                    log_message('info', 'Insert into lxp_alumnoxpensum, ingreso: ' . $ingreso);
                    if($ingreso > 0) {
                        
                                       $this->db->join('mod_modulo', 'mod_id=pen_id_mod', 'inner');
                                       $this->db->join('dfc_detalle_configuracion_cargo', 'dfc_id_art=mod_id_art', 'inner');
                        $cfg_materia = $this->gsatelite->get_registro('pen_pensum', array('pen_id' => $post_array['slcNivel']));

                        log_message('info', 'Consulta ejecutada (cfg_materia): ' . $this->db->last_query());

                        log_message('info', 'cfg_materia: ' . json_encode($cfg_materia));

                        $grupo_acad = $this->gsatelite->get_registro('gra_grupo_academico', array('gra_id' => $post_array['slcGrupo']));
                        log_message('info', 'Consulta ejecutada (grupo_acad): ' . $this->db->last_query());
                        log_message('info', 'grupo_acad: ' . json_encode($grupo_acad));
                        
                        $detalles = $this->gsatelite->get_tabla('dfc_detalle_configuracion_cargo', array('dfc_id_cfg'=>$id_cfg, 'dfc_id_art'=>$cfg_materia->dfc_id_art));
                        log_message('info', 'Consulta ejecutada (detalles): ' . $this->db->last_query());
                        log_message('info', 'detalles: ' . json_encode($detalles));

                        foreach ($detalles as $det) {
                                $i=1;
                                $articulo = $this->gsatelite->get_registro('art_articulo', array('art_id'=>$det['dfc_id_art']));
                                
                                log_message('info', 'articulo: ' . json_encode($articulo));

                                // Cargos generados según cantidad de cuotas
                                for ($i=1; $i <= $det['dfc_numero_cuota'] ; $i++) {
                                    $where_array = array(
                                        "lip_id_art" => $det['dfc_id_art'],
                                        "lip_desde <=" => $i,
                                        "lip_hasta >=" => $i,
                                        "tlp_id" => $listado_precio
                                    );

                                                $this->db->join("tlp_tipo_lista_precio", "tlp_id = lip_id_tlp" );
                                    $reg_precio = $this->gsatelite->get_registro("lip_listado_precio", $where_array);

                                    log_message('info', 'Consulta ejecutada (reg_precio): ' . $this->db->last_query());
                                    log_message('info', 'reg_precio: ' . json_encode($reg_precio));

                                    // Validar el resultado de reg_precio
                                    $cmc_monto = 0;
                                    if (!empty($reg_precio) && is_object($reg_precio) && isset($reg_precio->lip_precio)) {
                                        $cmc_monto = $reg_precio->lip_precio;
                                    } elseif (is_array($reg_precio) && count($reg_precio) > 0) {
                                        // En caso de que devuelva un arreglo (múltiples registros), tomar el primero
                                        $cmc_monto = isset($reg_precio[0]['lip_precio']) ? $reg_precio[0]['lip_precio'] : 0;
                                    }

                                                $this->db->join('imp_impuesto', 'imp_id = ixr_id_imp');
                                    $registros_ixr = $this->gsatelite->get_tabla('ixr_impuestox_tipo_articulo', array('ixr_id_tia'=>$articulo->art_id_tia, 'ixr_estado'=>1));
                                    log_message('info', 'Consulta ejecutada (registrs_ixr): ' . $this->db->last_query());
                                    log_message('info', 'registros_ixr: ' . json_encode($registros_ixr));

                                    $total_impuesto = 0;

                                    foreach ($registros_ixr as $ixr) {
                                        if($ixr['imp_valor'] > 0) {
                                            $total_impuesto = $total_impuesto + $ixr['imp_valor'];
                                        } else {
                                            $porcentaje_impuesto = $cmc_monto * ($ixr['imp_porcentaje']/100);
                                            $total_impuesto = $total_impuesto + $porcentaje_impuesto;
                                        }
                                    }

                                    log_message('info', 'total_impuesto: ' . $total_impuesto);

                                    $listado_meses = array('01'=>'ENERO', '02'=>'FEBRERO', '03'=>'MARZO', '04'=>'ABRIL', '05'=>'MAYO', '06'=>'JUNIO', '07'=>'JULIO', '08'=>'AGOSTO', '09'=>'SEPTIEMBRE', '10'=>'OCTUBRE',  '11'=>'NOVIEMBRE', '12'=>'DICIEMBRE');

                                    $fecha_inicial = date('Y-m-d', strtotime($grupo_acad->gra_fecha_inicio));

                                    if($i>1){
                                        $mas = (int)$i-1;
                                        $fecha_mes = date('Y-m-d', strtotime( '+'.$mas.' month' , strtotime($fecha_inicial))); 
                                    }else{
                                        $fecha_mes = $fecha_inicial;
                                    }

                                    $periodo = date('Ym' , strtotime($fecha_mes));
                                    $mes = date('m', strtotime($fecha_mes));
                                    $anio = date('Y', strtotime($fecha_mes));

                                    /***************** Fecha de vencimiento ****************************/
                                    $fecha = date($anio.'-'.$mes.'-'.$det['dfc_dia_fecha_cargo']);
                                    $dias_plazo = $det['dfc_dias_plazo'] - 1;
                                    $nuevafecha = strtotime('+'.$dias_plazo.' day' , strtotime($fecha)) ;
                                    $nuevafecha = date('Y-m-d', $nuevafecha);                                        
                                    $nombre_mes_fecha = $listado_meses[$mes];

                                    log_message('info', "Verificando fechas: fecha_inicial=$fecha_inicial, fecha_mes=$fecha_mes, periodo=$periodo, fecha=$fecha, nuevafecha=$nuevafecha");

                                    // Se agregan cargos al alumno.
                                    $array_cmc = array(
                                            'cmc_id_lxp' => $ingreso,
                                            'cmc_id_cfg' => $id_cfg,
                                            'cmc_id_fac' => null,
                                            'cmc_id_tlp' => $listado_precio,
                                            'cmc_fecha' => $fecha,
                                            'cmc_nombre' => 'PAGO MES '.$nombre_mes_fecha,
                                            'cmc_cuota' => $i,
                                            'cmc_monto' => $cmc_monto,
                                            'cmc_impuestos' => number_format($total_impuesto, 6, '.',''),
                                            'cmc_periodo' => $periodo,
                                            'cmc_codigo_barra' => null,
                                            'cmc_fecha_vencimiento' => $nuevafecha,
                                            'cmc_dias_mora' => null,
                                            'cmc_monto_mora' => null,
                                            'cmc_fecha_pago' => null,
                                            'cmc_estado_cargo' => 1,
                                            'cmc_observacion' => null,
                                            'cmc_estado' => 1,
                                            'cmc_total_cuota' => null,
                                            'cmc_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'cmc_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'cmc_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'cmc_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );                                    
                                    log_message('info', 'cmc array: ' . json_encode($array_cmc));
                                    $this->gsatelite->ingresar('cmc_cargo_alumnoxcurso', $array_cmc);
                                }
                        }

                        $alumno = $this->gsatelite->get_registro('alm_alumno', 'alm_id', $alumno_id);

                        if(isset($alumno->alm_email) && $alumno->alm_email != '') {
                            $data["nombre_curso"] = $cfg_materia->mod_nombre;
                            $data["carnet_alumno"] = $alumno->alm_codigo;
                            $data["url_plataforma"] = base_url().'auth/login';
                            $data["confirmar_primer_curso"] = $confirmar_primer_curso;
                            $data["firma_alfa"] = $this->load->view('correo_electronico/firma_alfa', '', true);

                            $message = $this->load->view('registro_academico/correo_electronico/inscripcion_curso', $data, true);
                            
                            $this->gsatelite->envio_correo("", "", $alumno->alm_email, "Inscripción de curso", $message);
                        } 

                    }

                }
    
            } // Fin de inscripción sin grado
           
            $redirect = $post_array['redireccion'];
            if(($ingreso && $ingreso>0) || $masiva==true){
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro agregado", 'texto_alerta' => "El registro se agregó correctamente.");            
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no agregado", 'texto_alerta' => "El registro no pudo ser agregado, intente de nuevo.");
            }

            $this->session->set_flashdata($alerta);
            if($redirect==0){
                redirect('registro_academico/procesos/alumno_inscripcion/'.$ingreso);
            }else{
                redirect('registro_academico/procesos/inscripcion');
            }
        }else{
            $data['registro']='';
                      $this->db->join("lxa_alumnoxarea", 'lxa_id_ard=pyc_id_ard'); 
            $select = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);
            $data["proyeccion"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

            if($lxp_id!=null && $lxp_id>0){
                $registro=$this->registro_academico_model->get_registro_inscripcion(array('lxp_id'=>$lxp_id));
                $data['registro']=$registro[0];
                
                $data['alm_id'] = $registro[0]['alm_id'];
                $data['alumno'] = $registro[0]['alm_codigo'].' - '.$registro[0]['alm_nombre'].' '.$registro[0]['alm_apellido'];

                $select = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), $registro[0]['pyc_id'], '', 'pyc_id', true);
                $data["proyeccion"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
           
                $tpn_registros = $this->gsatelite->get_tabla("tpn_tipo_precio_cliente", array("tpn_id_cli" => $registro[0]['alm_id_cli']));
                $tpn_tlp = ($tpn_registros && count($tpn_registros) > 0) ? $tpn_registros[0]['tpn_id_tlp']: null;

                $tlp_registros = $this->gsatelite->get_tabla("tlp_tipo_lista_precio", array("tlp_defecto" => 1));
                $tlp_defecto = ($tlp_registros && count($tlp_registros) > 0) ? $tlp_registros[0]['tlp_id']: null;

                $tlp_id = isset($tpn_tlp) ? $tpn_tlp: $tlp_defecto;

                $select_tlp = $this->gsatelite->get_dropdown('tlp_tipo_lista_precio', '{tlp_nombre}', '', array("tlp_estado" => 1), null, '', 'tlp_id', true);
                $data["listado_precios"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select_tlp);
            }

            if($alm_id>0){
                $alumno = $this->gsatelite->get_registro('alm_alumno', array('alm_id'=>$alm_id));
               
                $data['alm_id'] = $alumno->alm_id;
                $data['alumno'] = $alumno->alm_codigo.' - '.$alumno->alm_nombre.' '.$alumno->alm_apellido;

                $fecha_actual = date('Y-m-d');

                    $this->db->where('date_format(pyc_fecha_maxima_inscripcion, "%Y-%m-%d") >= date_format("'.$fecha_actual.'", "%Y-%m-%d")', null, FALSE);
                    $this->db->or_where('date_format(pyc_fecha_inicio, "%Y-%m-%d") <= date_format("'.$fecha_actual.'", "%Y-%m-%d") AND date_format(pyc_fecha_fin, "%Y-%m-%d") >= date_format("'.$fecha_actual.'", "%Y-%m-%d")', null, FALSE);
                $select = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);
                $data["proyeccion"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

                $tpn_registros = $this->gsatelite->get_tabla("tpn_tipo_precio_cliente", array("tpn_id_cli" => $alumno->alm_id_cli));
                $tpn_tlp = ($tpn_registros && count($tpn_registros) > 0) ? $tpn_registros[0]['tpn_id_tlp']: null;

                $tlp_registros = $this->gsatelite->get_tabla("tlp_tipo_lista_precio", array("tlp_defecto" => 1));
                $tlp_defecto = ($tlp_registros && count($tlp_registros) > 0) ? $tlp_registros[0]['tlp_id']: null;

                $tlp_id = isset($tpn_tlp) ? $tpn_tlp: $tlp_defecto;

                $select_tlp = $this->gsatelite->get_dropdown('tlp_tipo_lista_precio', '{tlp_nombre}', '', array("tlp_estado" => 1), $tlp_id, '', 'tlp_id', true);
                $data["listado_precios"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select_tlp);
            }

            $data['titulo_personal'] = "Inscripción de alumnos";
            $this->_cargarvista($data);
        }
    }

    /**
     * @author Edith Herrera
     * @since  15-12-2017
     * @return Cargar grupos según curso/nivel seleccionado.
     **/
    function cargar_gruposxnivel(){
        satelite_validar(true);

        $nivel = $this->input->post('nivel');
        $area = $this->input->post('area');
        $id_frh = $this->input->post('frecuencia');
        $id_pyc = $this->input->post('proyeccion');

        $frecuencia = $this->gsatelite->get_tabla('frh_frecuencia_horario', array('frh_estado' => 1, 'frh_id_ard'=>$area));
        $ids_frh=array();
        if(count($frecuencia)>0){
            foreach ($frecuencia as $key) {
                $ids_frh[]=$key['frh_id'];
            }
        }

        if($id_frh!='' && $id_frh!='null'){
            $this->db->where('gra_id_frh', $id_frh); 
        }else if(!empty($ids_frh)){ 
            $this->db->where_in('gra_id_frh', $ids_frh); 
        }

        if($id_pyc!=null){
            $this->db->where('gra_id_pyc', $id_pyc);
        }

        $grupos_arr = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_finalizado IS NULL' => null,'gra_cerrado IS NULL' => null,'gra_estado' => 1, 'gra_id_pen'=>$nivel));
        //$select = $this->gsatelite->get_dropdown('gra_grupo_academico', '{gra_nombre}', '', array('gra_estado' => 1, 'gra_id_pen'=>$nivel), null, '', 'gra_id', true);
        //$grupos = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
        $grupos = '<option value=""></option>';
        foreach ($grupos_arr as $key) {
            $grupos .= '<option value="'.$key['gra_id'].'" data-frh="'.$key['gra_id_frh'].'">'.$key['gra_nombre'].'</option>';
        }
        echo $grupos;
    }

     /**
     * @author Edith Herrera
     * @since  15-12-2017
     * @return Cargar grupos según curso/nivel seleccionado.
     **/
    function get_info_grupo(){
        satelite_validar(true);
        $id_gra = $this->input->post('grupo');

                      $this->db->join('scc_seccion', 'scc_id = gra_id_scc', 'left');
                      $this->db->join('aul_aula', 'aul_id = gra_id_aul', 'left');
        $grupo = $this->gsatelite->get_registro('gra_grupo_academico', array('gra_id'=>$id_gra));

        echo json_encode(array('aula'=>$grupo->aul_nombre, 'seccion'=>$grupo->scc_nombre, 'grado'=>$grupo->gra_id_grd, 'frecuencia'=>$grupo->gra_id_frh));
    }

    /**
     * @author Edith Herrera
     * @since  15-12-2017
     * @return Cargar historial del alumno seleccionado (modal de inscripción).
     **/
    function get_historial_alumno(){
        satelite_validar(true);
        
        $id_alm = $this->input->post('id_alm');
        $activo = $this->input->post('activo');
        $area = $this->input->post('area');

        $where = array();

        if($activo!=''){
            if($activo==1){
                $where['lxp_condicion']=1;
            }else{
                $where['lxp_condicion !=']=1;
            }
        }

        if($area!=''){
            $where['ard_id']=$area;
        }

        if($id_alm>0){
            $where['lxa_id_alm'] = $id_alm;
            $data['registro'] = $this->registro_academico_model->obtener_cursos_alumno($where);
        }else{
            $data['registro']=array();
        }

         $html = $this->load->view('registro_academico/procesos/historial_alumno', $data, true);
        echo $html;
    }


     /**
     * @author Edith Herrera
     * @since  18-12-2017
     * @return Cargar áreas por alumno.
    * */
    function cargar_areas_alumno(){
        satelite_validar(true);
        $id_alm = $this->input->post('alumno');

        if($id_alm>0){ $where=array('lxa_id_alm'=>$id_alm); }
        $select = $this->registro_academico_model->cargar_areaxalumno($where);

        $option = '<option value=""></option>';
        if(count($select)>0){
            $becado = $select[0]['alm_becado'];
            foreach ($select as $key) {
                $option .= '<option value="'.$key['ard_id'].'">'.$key['ard_nombre'].'</option>';
            }
        }
        echo json_encode(array('option'=>$option, 'becado'=>$becado));
    }

    /**
     * @author Edith Herrera
     * @since  18-12-2017
     * @return Cargar facturas por alumno.
    * */
    function cargar_facturas_alumno(){
        satelite_validar(true);
        $id_alm = $this->input->post('alumno');
        $area = $this->input->post('area');
        
        $where = array();
        if($id_alm>0){
            $where['alm_id']=$id_alm;
        }

        if($area>0){
            $where['pen_id_ard']=$area;
        }

       //Se obtienen las facturas del alumno
                    $this->db->order_by('fac_id', 'ASC');
        $facturas = $this->registro_academico_model->obtener_facturas($where,'fac_id');
        //print_r($this->db->last_query()); die();
      
        $factura_slc = "<option value=''></option>";
        $fac_temp = '-1';
        $mod_temp = '-1';
        //print_r($facturas); die();
        foreach ($facturas as $key) { //recorremos las facturas del alumno
            /*
            $condicion_array = array();
            $condicion_array2 = array();
            $condicion_array3 = array();
            $contador = 0;
            $contador2 = 0;
            $contador3 = 0;
            $condiciones = explode(',', $key['condicion']); // separamos el campo condicion, que nos trae, cada registro separado por coma es un id del articulo y la condicion de este

            $condicion_temp = '-1';
            for ($x=0; $x < count($condiciones); $x++) { //recorremos las condiciones
                $condicion_art = explode('-', $condiciones[$x]); //sepramos el id del articulo con la condicion
                if($condicion_art[0] != $condicion_temp){ //nos crea el indice del arreglo
                    $condicion_array[$condicion_art[0]] = $condicion_art[1];
                    $condicion_temp = $condicion_art[0];
                }
                $condicion_array[$condicion_art[0]] = $condicion_art[1]; // sustituye el valor del indice hasta que quede el ultimo para verificar que estado viene
            }
                    
            foreach ($condicion_array as $key2) { //recorremos el array creado para verificar si esta en curso o aprobada
                if($key2 == 1 || $key2 == 2){
                    $contador++; //nos dara el resultado de 1 si esta en curso o aprobada
                }
            }

            $modulos = explode(',', $key['id_mod']); //nos trae todos los modulos de la factura y lo almacenamos en un array
            $condiciones2 = explode(',', $key['condicion2']); //separamos la cadena se ordena como articulo - condicion - modulo
            $condicion_temp2 = '-1';
            for ($x=0; $x < count($condiciones2); $x++) {
                $condicion2_art = explode('-', $condiciones2[$x]);
                if($condicion2_art[0] != $condicion_temp2){
                    $condicion_array2[$condicion2_art[0]] = array('condicion'=>$condicion2_art[1], 'modulo'=>$condicion2_art[2]); // Almacenamos la condicion y el modulo de los registros del alumno
                    $condicion_temp2 = $condicion2_art[0];
                }
                $condicion_array2[$condicion2_art[0]] = array('condicion'=>$condicion2_art[1], 'modulo'=>$condicion2_art[2]);
                        
            }
            
            $condiciones3 = explode(',', $key['condicion3']); //separamos la cadena modulo - modulo requisito
            $condicion_temp3 = '-1';
            for ($x=0; $x < count($condiciones3); $x++) {
                $condicion3_art = explode('-', $condiciones3[$x]); // modulos - prerequisitos

                if($condicion3_art[0] != $condicion_temp3){
                    $condicion_array3[$condicion3_art[0]] = array('requisito'=>$condicion3_art[1]); // guardamos el modulo como indice y el requisito como atributo
                    $condicion_temp3 = $condicion3_art[0];
                }
                $condicion_array3[$condicion3_art[0]] = array('requisito'=>$condicion3_art[1]);
            }

            //die(print_r($condicion_array3));
            $mods = explode(',', $key['prereq']);
            
            foreach ($modulos as $key2) { //recorremos los modulos que trae la factura
                $temp_estado = '';
                $registros = $condicion_array3[$key2]; // requisitos del modulo facturado
               
                foreach ($condicion_array2 as $key3) { //recorremos los requisitos del modulo actual
                    if($key3['modulo'] == $registros['requisito']){
                        $temp_estado = $key3['condicion'];
                    } else if(trim($registros['requisito']) != ''){
                        $temp_estado = 3;
                    }
                }
                //die(print_r($temp_estado));
                if($temp_estado == 2){
                    $contador2 = 1;
                } else if(trim($temp_estado) == ''){
                    $contador2 = 1;
                } else{
                    $contador2 = 0;
                }

                if($contador2 == 0){
                    $contador3++;
                }
                $temp_estado = '';
            }

            $error = 0;

            if($contador3 == count($modulos)){
                $error++;
            }

            $area = $key['ard_id'];
            $alumno = $key['alm_id'];
            
            $where = array();
           if(count($mods)>0){
            $where['pen_id_ard'] = $area;
            $where['lxa_id_alm'] = $alumno;
            $permit = 0;
            foreach ($mods as $md) {
                $where['mod_id'] = $md;
                $reg = $this->registro_academico_model->get_info_prerrequisito($where);
                
                if($reg['lxp_condicion']!=2){
                    $permit++;
                }
            }
           }*/
           //die(print_r($permit));


            //die(print_r($contador.'+'.$contador3.'=='.$key['products'].'|| '.$permit));
            //C if($contador+$contador3 != $key['products'] || $permit==0){
                // C $detalles = $this->registro_academico_model->get_detalles_fac(array('fac_id'=>$key['fac_id']));
               //die(print_r($detalles));
                //if($key['products'] != $contador && $error == 0 && ($key['lxp_condicion'] == '' || $key['lxp_condicion'] == 4 || $key['lxp_condicion'] == 3  )){
                //die(print_r($key['products'].'!='.$contador.' &&'. $error.' == 0 && '.$key['lxp_condicion'] ));
            //C if($key['products'] != $contador && ($error == 0 || $permit==0) && $key['lxp_condicion'] != 4 && $key['lxp_condicion'] != 3  && ($key['lxp_condicion'] == ''  || $detalles['detalle'] > $detalles['det_ins'] )){
                    $factura_slc .= '<option value="' . $key['fac_id'] . '" prue="'.$error.'" pru="'.$contador.'">' . $key['fac_numero'] . '</option>';
               //C }
            //C }
        }
        $data['facturas'] = $factura_slc;

        $becado = $this->registro_academico_model->obtener_becado($id_alm); //verifica si el alumno es becado
        
        echo json_encode(array('facturas'=>$factura_slc, 'becado'=>$becado));
    }

    /**
     * @author Edith Herrera
     * @since  27-12-2017
     * @return Cargar áreas por alumno.
    * */
    function cargar_proyeccionxalumno(){
        satelite_validar(true);
        $id_alm = $this->input->post('alumno');

                  $this->db->where('lxa_id_alm', $id_alm);
                  $this->db->join("lxa_alumnoxarea", 'lxa_id_ard=pyc_id_ard'); 
        $select = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);
        $proyeccion = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

        echo json_encode(array('proyeccion'=>$proyeccion));
    }

    /**
    * @author Luis Navarro
    * @since  03-01-2018
    * @return validar el horario de un docente.
    **/
    function validar_horario_docente() {
        satelite_validar(true);

        if($this->input->post()) {
            $estado = 1;
            $arr = array();
            $frhNuevo = $this->input->post('frecuenciaN');
            $frhAntiguo = $this->input->post('frecuenciaA');

            $consulta1 = $this->registro_academico_model->get_frecuencias(array('frh_id'=>$frhNuevo, 'frh_estado'=>1));

            $where['frh_id'] = $frhAntiguo;
            $where['frh_estado'] = 1;

            foreach ($consulta1 as $key => $value) {
                $this->db->where("((hrg_inicio >= '".$value['hrg_inicio']."' AND hrg_inicio < '".$value['hrg_fin']."') OR (hrg_fin > '".$value['hrg_inicio']."' AND  hrg_fin <= '".$value['hrg_fin']."') OR (hrg_inicio <  '".$value['hrg_inicio']."' AND hrg_fin >  '".$value['hrg_fin']."')) AND dia_id=".$value['dia_id']."", NULL, false);
                $consulta2 = $this->registro_academico_model->get_frecuencias($where);

                if(count($consulta2)>0) {
                    $estado = 0;
                }
            }
           // print_r($consulta2);die();
            $datos = array(
                'exito' => $estado
            );
            echo json_encode($datos);
        }
    }

    /**
    * @author Luis Navarro
    * @since  05-01-2018
    * @return Cargar proyecciones por nivel
    **/
    function cargar_proyeccion_nivel() {
        satelite_validar(true);

        if ($this->input->post()) {
            $proyeccion = $this->input->post("proyeccion");
            $where['pyc_id'] = $proyeccion;
            $where['pyc_estado'] = 1;

            $select = $this->registro_academico_model->get_proyeccion_x_nivel($where);
          
            $html = '<option value=""></option>';
            foreach ($select as $key => $value) {
                $html .= '<option value="'.$value['mod_id'].'">'.$value['mod_nombre'].'</option>';
            }
            $nivel = str_replace('<option value="0">Seleccione</option>', '', $html);

            echo json_encode($nivel);

        }
    }

    /**
    * @author Luis Navarro
    * @since  10-01-2018
    * @return Impresion de disponibilidad de docente
    **/
    function imprimir_disponibilidad($docente=NULL) {
        satelite_validar();
        if($docente!=NULL) {

            $where['dct_id'] = $docente;
            $where['dct_estado'] = 1;

            $html = '';
            $titulo_reporte = ''; // Titulo del reporte

            $this->db->join('emp_empleado', 'emp_id=dct_id_emp');
            $data['docente'] = $this->gsatelite->get_tabla('dct_docente', array('dct_id'=>$docente, 'dct_estado'=>1));
            $data['horarios'] = $this->registro_academico_model->get_dispo_docente($where);

            $dias = $this->registro_academico_model->get_dispo_docente($where, 'dia_id');

            $frh = array();
            $frecuencias = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id_dct'=>$docente, 'gra_estado'=>1));
            foreach ($frecuencias as $key => $value) {
                array_push($frh, $value['gra_id_frh']);
            }
            $data['gra_docente'] = $frh;
            // print_r($data['gra_docente']);die();

            $this->db->join('fxd_frecuenciaxdocente', 'dct_id=fxd_id_dct');
            $data['frecuencias'] = $this->gsatelite->get_tabla('dct_docente', array('dct_id'=>$docente, 'dct_estado'=>1));
            // print_r($data['frecuencias']);die();
            $data['frh_detalle'] = $this->gsatelite->get_tabla('frh_frecuencia_horario', array('frh_estado'=>1));

            $this->load->library('pdf');
            $header = $this->load->view('reporte/header', array('titulo' => $titulo_reporte, 'solotitulo' => true), true);
            $html = $this->load->view('registro_academico/procesos/imprimir_disp_docente', $data, true);
            $reporte = $header.$html;
            $this->pdf->makePDF($reporte, 'H');
            // echo $html;
        } else {
            $url = base_url('registro_academico/procesos/docente_disp');
            $this->gsatelite->show_dialog('No se ha seleccionado ningun Docente', $url, 'error', 'Error en Imprimir Disponibilidad');
        }

    }

    /**
    * @author Luis Navarro
    * @since  12-01-2018
    * @return Impresion de Inscripciones de Alumnos
    **/
    function impresion_inscripcion($alm_id=NULL) {
        satelite_validar();

        if ($alm_id != NULL) {
            $where['lxa_id_alm'] = $alm_id;
            $where['lxp_estado'] = 1;

            $data['inscripcion'] = $this->registro_academico_model->obtener_lxp_x_alumno($where);

            $data['aulas'] = $this->gsatelite->get_tabla('aul_aula', array('aul_estado' => 1));

            $this->db->order_by('fac_id', 'desc');
            $this->db->join('fac_factura', 'alm_id_cli=fac_id_cli', 'left');
            $data['alumno'] = $this->gsatelite->get_tabla('alm_alumno', array('alm_id' => $alm_id, 'alm_estado'=>1));

            $data['grupos'] = $this->registro_academico_model->obtener_lxp_x_alumno(array('lxa_id_alm'=>$data['alumno'][0]['alm_id'], 'gra_estado'=>1));
            $data['horarios'] = $this->registro_academico_model->get_frecuencias(array('frh_estado'=>1));

            $data['facturas'] = $this->gsatelite->get_tabla('fac_factura', array('fac_estado'=>2));

            $this->load->library('pdf');
            $header = $this->load->view('reporte/header', array('titulo' => 'Comprobante de inscripci&oacute;n', 'solotitulo' => true), true);
            $html = $this->load->view('registro_academico/procesos/impresion_inscripcion', $data, true);
            $reporte = $header.$html;
            $this->pdf->makePDF($reporte, 'H');
            // echo $html;
        }
    }


    /*
     * Added by: Edith Herrera
     * Función que busca los productos por nombre asignados a una categoria y bodega (saldos)
     * Si se les proporciona.
     * @return: Objeto json de la informacion resultante
     */

    public function get_productos_like() {
        satelite_validar(true);
        $categoria = ($this->input->post('categoria') != '') ? $this->input->post('categoria') : null;
        $tipo = ($this->input->post('tipo') != '') ? $this->input->post('tipo') : null;
        $producto = ($this->input->post('producto') != '') ? $this->input->post('producto') : null;
       
        $where = null;
        $like = null;
        $flag_consulta = 0;

        if ($categoria != null) {
            $where['art_id_tia'] = $categoria;
        }
        if ($tipo != '') {
            switch ($tipo) {
                case 1:
                    $where['art_tipo'] = 0; // Productos
                    break;
                case 2:
                    $where['art_tipo'] = 1; // Serivicios
                    break;
                case 3:
                    $flag_consulta = 1; // Se consultarán activos.
                    break;
            }
        }
        
        if ($producto != '') {
            $like['art_nombre'] = $producto;
            $like['art_codigo'] = $producto;
        }
        $where['art_venta'] = 1;
        $where['art_inventario'] = 1;

        $arreglo = array();
        $productos = $this->proyecto_model->get_productos_like($where, $like, $flag_consulta, $producto);

        if (count($productos) > 0 && $flag_consulta==0) {
            foreach ($productos as $key => $value) {
                $arreglo[$key]['producto'] = $value['art_id'];
                $arreglo[$key]['prod_nombre'] = $value['art_nombre'];
            }
        }else if(count($productos) > 0 && $flag_consulta==1){
            foreach ($productos as $key => $value) {
                $arreglo[$key]['producto'] = $value['act_id'];
                $arreglo[$key]['prod_nombre'] = $value['act_codigo'].' - '.$value['act_nombre'];
            }
        }
        echo json_encode($arreglo);
    }

    /**
    * @author Edith Herrera
    * @since  16-01-2018
    * @return Cargar pensums para la inscripción de alumnos.
    **/
    public function cargar_pensum_inscripcion($area=null, $alumno = null, $query=null, $tipo=null, $verif_exam=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id_area = ($area!=null)? $area : $this->input->post('id');
            $id_alm  = ($alumno!=null)? $alumno : $this->input->post('alumno');
            $examen  = $this->input->post('examen');
            $verif_grupo = ($this->input->post('verif_grupo'))?$this->input->post('verif_grupo'):null;
            $proyeccion = ($this->input->post('proyeccion'))?$this->input->post('proyeccion'):null;
           
            $where = array();
            if($id_area!=''){
                $where['lxa_id_ard'] = $id_area;
            }
            
            $incluir    = array(); // Módulos inscritos.
            $no_incluir = array();
            $no_pasa    = array(); // Módulos en curso o reprobados.
            if($id_alm!=''){
                $where['lxa_id_alm'] = $id_alm;
                if($verif_exam!=null){
                    $where['lxp_exam_ubicacion != '] = 1;
                }
                if($tipo != null){
                    $where['lxp_tipo_inscripcion'] = 2;
                }
                $registrados = $this->registro_academico_model->pensumxalumno_inscrito($where);

                if(count($registrados)>0){
                    foreach($registrados as $reg) {
                        $where['lxa_id_ard'] = $reg['lxa_id_ard'];
                        $where['lxa_id_alm'] = $reg['lxa_id_alm'];
                        $where['mod_id'] = $reg['pen_id_mod'];
                                    
                        $reg = $this->registro_academico_model->get_info_prerrequisito($where);
                        if($reg['lxp_condicion']!=2 ){
                            $no_pasa[] = $reg['pen_id_mod'];
                        }
                        if($reg['pen_id']>0 && !empty($reg['pen_id'] )){
                            if($query!=null && $reg['lxp_tipo_inscripcion'] == 2){
                                $no_incluir[] = $reg['pen_id'];
                            }else if($query==null){
                                $no_incluir[] = $reg['pen_id'];
                            }
                        }

                        if(isset($reg['pen_id_asociado'])>0 && !empty($reg['pen_id_asociado'])){
                            $no_incluir[] = $reg['pen_id_asociado'];
                        }
                                    $this->db->where('pen_id', $reg['pen_id']);
                                    $this->db->join('pre_prerrequisito', 'pen_id_mod = pre_id_mod');
                        $siguiente= $this->gsatelite->get_tabla('pen_pensum');
                        if(count($siguiente)>0){
                            foreach ($siguiente as $sig) {
                                if($sig['pre_id_pen']>0){
                                    $incluir[] = $sig['pre_id_pen'];
                                }
                            }
                        } 

                    }
                }else{ // Si no hay inscripciones para el alumno

                /// Verifica que exista una prenscripción con examen de ubicación para poder efectuar la inscripción ///
                    $where = array('lxa_id_alm'=> $id_alm, 'lxp_tipo_inscripcion'=> 1, 'lxp_exam_ubicacion'=>1); 
                    $preins = $this->registro_academico_model->pensumxalumno_inscrito($where, 1);
                    if(count($preins)>0){
                        $examen = 1;
                    }
                }
            }
            $where_md = array('ard_area_academica.ard_id' => $id_area);
            if(empty($no_incluir) && $examen<=0 && $verif_exam<=0){
                $this->db->where("pre_id IS NULL", null, FALSE);
            }
            if(empty($incluir) || $examen>0 || $verif_exam!=null){
                $incluir = null;
                $no_pasa = null;
            }


            if($proyeccion>0){
                $where_md['gra_id_pyc'] = $proyeccion;
            }
         
            $pensum = $this->registro_academico_model->obtener_pensum_x_ard($where_md, null, $no_incluir, $incluir, $no_pasa, $query, 1, $verif_grupo);
            
            $pensum_grado = $this->registro_academico_model->obtener_pensum_x_ard($where_md, null, $no_incluir, $incluir, $no_pasa, $query, 2, $verif_grupo);

            
            $data = array();
            if($query!=null){
                return $pensum;
            }else{
                $data['pensum'] = $pensum;
                $data['pensum_grd'] = $pensum_grado;
                echo json_encode($data);
                die();
            } 
        }
    }

   /**
    * @author Luis Navarro
    * @since  23-01-2018
    * @return Inactivar Alumno.
    **/
    function inactivar_alumno($alumno = NULL, $activar=null) {
        satelite_validar();
        
        if ($alumno != NULL) {
            if($activar!=null){
                 $array_alumno = array(
                        'alm_estado' => 1,
                        'alm_usu_mod' => $this->tank_auth->get_user_id(),
                        'alm_fecha_mod' => date('Y-m-d H:i:s')
                    );

                    $consulta_alm = $this->gsatelite->actualizar_array("alm_alumno", $array_alumno, array('alm_id' => $alumno));
                    $cliente = $this->gsatelite->get_tabla('alm_alumno', array('alm_id'=>$alumno));

                    $array_cliente = array(
                        'cli_estado' => 1,
                        'cli_usu_mod' => $this->tank_auth->get_user_id(),
                        'cli_fecha_mod' => date('Y-m-d H:i:s')
                    );

                    $consulta_cli = $this->gsatelite->actualizar_array("cli_cliente", $array_cliente, array('cli_id' => $cliente[0]['alm_id_cli']));

                    if ($consulta_alm > 0 && $consulta_cli > 0) {
                        $this->gsatelite->show_dialog('Alumno activado correctamente' , 'registro_academico/procesos/gestion_alumnos', 'success', 'Alumno activado');    
                    }
            }else{
                $areas_activos = $this->gsatelite->get_tabla('lxa_alumnoxarea', array('lxa_id_alm'=>$alumno, 'lxa_estado'=>1));

                $this->db->join('lxa_alumnoxarea', 'lxa_id=lxp_id_lxa');
                $inscritos_activos = $this->gsatelite->get_tabla('lxp_alumnoxpensum', array('lxa_id_alm'=>$alumno, 'lxp_condicion'=>1, 'lxp_estado'=>1));

                if (!count($areas_activos)>0 || !count($inscritos_activos)>0) {
                    
                    $array_alumno = array(
                        'alm_estado' => 0,
                        'alm_usu_mod' => $this->tank_auth->get_user_id(),
                        'alm_fecha_mod' => date('Y-m-d H:i:s')
                    );

                    $consulta_alm = $this->gsatelite->actualizar_array("alm_alumno", $array_alumno, array('alm_id' => $alumno));

                    $cliente = $this->gsatelite->get_tabla('alm_alumno', array('alm_id'=>$alumno));

                    $array_cliente = array(
                        'cli_estado' => 0,
                        'cli_usu_mod' => $this->tank_auth->get_user_id(),
                        'cli_fecha_mod' => date('Y-m-d H:i:s')
                    );

                    $consulta_cli = $this->gsatelite->actualizar_array("cli_cliente", $array_cliente, array('cli_id' => $cliente[0]['alm_id_cli']));

                    if ($consulta_alm > 0 && $consulta_cli > 0) {
                        $this->gsatelite->show_dialog('Alumno Inactivado correctamente' , 'registro_academico/procesos/gestion_alumnos', 'success', 'Alumno Inactivado');    
                    }

                } else {
                    $this->gsatelite->show_dialog('No se puede inactivar alumno ya que posee una área o inscripción activa' , 'registro_academico/procesos/gestion_alumnos', 'error', 'Error al Inactivar Alumno');
                }

            }
        }
    }


     /**
     * @author Edith Herrera
     * @since  22-12-2017
     * @return Grid de la finalizar grupo.
    * */
    function finalizar_grupo() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        if ($_POST) {
            $area           = $this->input->post('area');
            $nivel          = $this->input->post('nivel');
            $fecha          = $this->input->post('fecha');
            $frecuencia     = $this->input->post('frecuencia');
            $proyeccion     = $this->input->post('proyeccion'); 
            $sucursal_str   = $this->get_sucursales();    

            $where = array();
            if ($area != '') {
                $where['ard_id'] = $area;
            }
            if ($nivel != '') {
                $where['mod_id'] = $nivel;
            }
            if ($frecuencia != '') {
                $where['frh_id'] = $frecuencia;
            }
            if ($fecha != '') {
                $where['gra_fecha_inicio'] = $fecha;
            }
            if ($proyeccion != '') {
                $where['pyc_id'] = $proyeccion;
            }
            
            //$where['gra_id_suc in('.$sucursal_str.')'] = NULL;

            $this->db->where('(gra_cerrado IS NULL OR gra_cerrado = 0)', null, FALSE);
          
            $data['grupos'] = $this->registro_academico_model->obtener_grupos($where);
            $html = $this->load->view('registro_academico/procesos/detalle_fin_grupo', $data, true);
            echo $html;
        } else {

            $sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_estado'=>1,'usc_id_usu'=>$this->tank_auth->get_user_id()));

            $where = (count($sucursal) > 0) ? 'ard_estado = 1 AND (ard_id_suc IS NULL OR ard_id_suc = '.$sucursal[0]['usc_id_suc'].')': 'ard_estado = 1';

            $select = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', $where, null, '', 'ard_id', true);
            $data["areas"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $data['titulo_personal'] = "Finalizar grupo";
            $this->_cargarvista($data);
        }
    }

    /**
     * @author Edith Herrera
     * @since  23-11-2017
     * @return cargar información.
    * */
    function cargar_info_grupo($grupo_id = null){
        satelite_validar(true);

        $grupo = ($grupo_id!=null) ? $grupo_id : $this->input->post('id');
        
        $info = $this->registro_academico_model->obtener_grupos(array('gra_id'=>$grupo));
        
        $grupos = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_id_ard'=>$info[0]['ard_id']), null, '', 'pyc_id', true);
        $new_pyc = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $grupos);

            $return =array(
                    'pyc_actual'=>($info[0]['pyc_nombre']!='')?$info[0]['pyc_nombre']:'',
                    'pyc_id_actual' =>($info[0]['pyc_id']!='')?$info[0]['pyc_id']:'',
                    'mod_nombre'=>($info[0]['mod_nombre']!='')?$info[0]['mod_nombre']:'',
                    'mod_id'=>($info[0]['mod_id']!='')?$info[0]['mod_id']:'',
                    'proyecciones' => $new_pyc,
                    'gra_id'=>$info[0]['gra_id'],
                    'ard_id'=>$info[0]['ard_id'],
                    'grd_id'=>$info[0]['grd_id'], //Si existe grado asociado
                    'nombre'=>$info[0]['grd_nombre'] //Si existe grado asociado
                );

        if($grupo_id!=null){
            return $return;
        }else{ 
            echo json_encode($return);
        }
    }

    /**
     * @author Herberth Lucho
     * @since  12-09-2019
     * @return valida si el grupo tiene mas materias en el pensum
     **/
    function check_grupo_finalizar(){
        satelite_validar(true);

        $id_grado = $this->input->post('id_grado');
        $proyeccion = $this->input->post('proyeccion');

        $where = array();
        if($id_grado!=''){
            $where['gra_id'] = $id_grado;
        }
        if($proyeccion!=''){
            $where['pyc_id'] = $proyeccion;
        }

        $info = $this->registro_academico_model->check_grupo_finalizar($where); 
        $return = $info[0]['pen_id_mod_siguiente'];

        if($info[0]['pen_id_mod_siguiente'] != null)
            echo json_encode(1);
        else
            echo json_encode(0);
    }

    /**
     * @author Edith Herrera
     * @since  2017-11-23
     * @return cargar grupos por proyección.
    * */
    function get_gruposxproyeccion($area=null, $edit=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {                          
            $proyeccion = $this->input->post('pyc');
            $id_gra = $this->input->post('grupo');
            $id_area = $this->input->post('area');
            
            $where= array();
            if($id_area!=''){
                $where['lxa_id_ard'] = $id_area;
            }else if($proyeccion!=''){
                $where['lxa_id_ard'] = $this->gsatelite->get_campo('pyc_proyeccion', 'pyc_id_ard', array('pyc_id'=>$proyeccion));
            }

            if($id_gra!=''){
                $where['lxp_id_gra'] = $id_gra;
            }

            $mensaje = '';
            $where_sg = array();
            $grupo_ins = $this->registro_academico_model->pensumxalumno_inscrito($where); // Información del grupo en curso o aprobado.
            if(count($grupo_ins)>0){
                if($proyeccion!=''){
                    $where_sg['gra_id_pyc'] = $proyeccion;
                }
                
                $where_sg['mod_id']=$grupo_ins[0]['pen_id_mod'];
                $where_sg['pen_id_ard']=$grupo_ins[0]['pen_id_ard'];

                $siguiente = $this->registro_academico_model->get_info_siguientenivel($where_sg); // Debe existir un grupo para el siguiente nivel.
               
                $drop_grupos = '<option value=""></option>';
                if(count($siguiente)>0){
                   foreach ($siguiente as $sig ) {
                        $drop_grupos .= '<option value="'.$sig['gra_id'].'">'.$sig['gra_nombre'].'</option>';
                    } 
                }
            }

            echo json_encode($drop_grupos); 
        }
    }

    /**
     * @author Edith Herrera
     * @since  2017-11-23
     * @return cargar grupos por proyección.
    **/
    function procesar_fin_grupo($pyc_id=null, $gra_id=null, $ant=null, $grd_id=null, $rec=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else{
            $id_pyc     = ($pyc_id!=null) ? $pyc_id : $this->input->post('pyc');
            $id_gra     = ($gra_id!=null) ? $gra_id : $this->input->post('grupo');
            $id_gra_ant = ($ant!=null)?$ant : $this->input->post('grupo_ant');

            if($grd_id!=null){
                $grado = $grd_id;
            }else{
                $grado = ($this->input->post('grado')>0)?$this->input->post('grado'):null;
            }
            ////////////////////////////////// Configuración de decimales ////////////////////////////////////////
            $decimales    = json_decode($this->gsatelite->get_parametro("RA_DECIMALES"),true);
            $min_aproxima = (isset($decimales['min_aproxima'])>0)?(float)$decimales['min_aproxima']:0; // Cantidad mínima para aproximar promedios.
            $max_aproxima = (isset($decimales['max_aproxima'])>0)?(float)$decimales['max_aproxima']:0; // Cantidad máxima para aproximar promedios.

        /********************************* PROCESAMIENTO DE GRADO *******************************************/
                

            if($grado!=null){
                $where= array('grd_id'=>$grado);
                if($rec==null){
                    $where['lxp_condicion']=1;
                    $where['gxa_estado_grado'] = 2;
                }else{
                    $where['lxp_condicion <> 4']=null;
                    $where['gxa_estado_grado <> 3'] = null;
                }
                $materias = $this->registro_academico_model->get_materias_grado($where);
                
                $reprobado = 0;

                if(count($materias)>0){
                    /**************** Verifica materias aprobadas *************************************/
                 
                    foreach ($materias as $key => $value) {    
                        $_POST['area'] = $value['grd_id_ard'];
                        $ins = $this->gsatelite->get_registro('lxp_alumnoxpensum', array('lxp_id'=>$value['lxp_id'])); //Inscripción
                        $minima = $this->gsatelite->get_campo('ard_area_academica', 'ard_nota_minima', array('ard_id'=>$value['grd_id_ard']));

                        
                        if($rec==null){
                            $where_act = array('lxp_id'=>$value['lxp_id'], 'lxp_condicion'=>1);
                        }else{
                            $where_act = array('lxp_id'=>$value['lxp_id'], 'lxp_condicion <>'=>4);
                        }

                        ////////////////////////// Materia reprobada ///////////////////////////////
                        if((float)$ins->lxp_promedio < (float)$minima){
                            $reprobado++;
                            $this->gsatelite->actualizar_array('lxp_alumnoxpensum', array('lxp_condicion'=>3, 'lxp_fecha_mod'=>date('Y-m-d H:i:s'), 'lxp_usu_mod'=>$this->tank_auth->get_user_id()), $where_act); // Estado de inscripción
                           
                            $proceso = $this->gsatelite->actualizar_array('gra_grupo_academico', array('gra_cerrado'=>1), array('gra_id'=>$value['gra_id'])); // Cierre de grupo 
                        }else{
                            $this->gsatelite->actualizar_array('lxp_alumnoxpensum', array('lxp_condicion'=>2, 'lxp_fecha_mod'=>date('Y-m-d H:i:s'), 'lxp_usu_mod'=>$this->tank_auth->get_user_id()), $where_act); // Estado de inscripción
                             $proceso = $this->gsatelite->actualizar_array('gra_grupo_academico', array('gra_cerrado'=>1), array('gra_id'=>$value['gra_id'])); // Nivel reprobado  
                        }

                        $proceso = $this->gsatelite->actualizar_array('gxa_gradoxalumno', array('gxa_estado_grado'=>0), array('gxa_id'=>$value['gxa_id'])); // Grado reprobado - estado
                    }
                    
                    //preguntamos por las becas de los alumnos
                    $alumnos = $this->gsatelite->get_tabla('gxa_gradoxalumno',array('gxa_id' =>$grado));
                    foreach ($alumnos as $key => $valor) {
                         $this->db->join('tpb_tipo_beca','tpb_id = slb_id_tpb');
                        $this->db->join('apb_aprobacion_beca','apb_id_slb = slb_id');
                        $datos = $this->gsatelite->get_tabla('slb_solicitud_beca',array('slb_id_alm' => $valor['gxa_id_alm']));
                        foreach ($datos as $key => $value) {
                            if ($value['tpb_mes_vigencia'] == (int) date('m')) {
                                $this->gsatelite->actualizar_array('apb_aprobacion_beca',array('apb_estado' => 0),array('apb_id' =>$value['apb_id']));
                            }
                        }
                    }
                    /**************** Si no esta reprobado se realiza preinscripción al próximo grado *****************/
                    if($reprobado==0){
                        foreach ($materias as $key => $value) {
                            $pensum = $this->gsatelite->get_tabla('pen_pensum', array('pen_id'=>$value['gra_id_pen']));
                            $siguiente = $this->registro_academico_model->get_info_siguientenivel(array('gra_id_pyc'=>$id_pyc, 'pre_id_mod'=>$pensum[0]['pen_id_mod'])); // Debe existir un grupo para el siguiente nivel.
                            $grado_pre = 0;
                            if(count($siguiente)>0){
                                $grado_pre = $siguiente[0]['gra_id'];
                            }
                           

                            $result = $this->generar_finalizacion_grado($_POST, $value['lxp_id'], $grado_pre);
                            if($result>0){
                                $proceso = $this->gsatelite->actualizar_array('gxa_gradoxalumno', array('gxa_estado_grado'=>1), array('gxa_id'=>$value['gxa_id'])); // Grado aprobado
                            }
                        }
                    }
                }
            }else{
            /********************************* PROCESAMIENTO DE NIVEL *******************************************/
             
                //Inscripciones de alumnos al grupo antiguo.
                $inscripciones = $this->gsatelite->get_tabla('lxp_alumnoxpensum', array('lxp_id_gra'=>$id_gra_ant, 'lxp_estado'=>1));
                $area = $this->gsatelite->get_campo('gra_grupo_academico', 'gra_id_ard', array('gra_id'=>$id_gra_ant));            


                $proceso = 0;
                $promedio = 0;
                if(count($inscripciones)>0){
                    foreach ($inscripciones as $key) {
                        //obtenemos los id de los alumnos para preguntar sobre las becas
                           
                                $this->db->join('pen_pensum', 'pen_id = gra_id_pen');
                                $this->db->join('ard_area_academica', 'ard_id = pen_id_ard');
                                $this->db->join('lxa_alumnoxarea', 'lxa_id_ard = ard_id');
                                $this->db->join('lxp_alumnoxpensum', 'lxp_id_lxa = lxa_id');
                        $reg =  $this->gsatelite->get_tabla('gra_grupo_academico',array('gra_id' => $id_gra_ant));
                        $alumnos = array_column($reg,'lxa_id_alm');

                        foreach ($alumnos as $k => $valu) {

                                     $this->db->join('tpb_tipo_beca','tpb_id = slb_id_tpb');
                                     $this->db->join('apb_aprobacion_beca','apb_id_slb = slb_id');
                            $becas = $this->gsatelite->get_tabla('slb_solicitud_beca',array('slb_id_alm' => $valu));
                            
                            foreach ($becas as $ky => $val) {
                                if ($val['tpb_mes_vigencia'] == date('m')) {
                                    $this->gsatelite->actualizar_array('apb_aprobacion_beca',array('apb_estado' =>0 ),array('apb_id' =>$val['apb_id']));
                                }
                            }
                        }
                        //---------------------------------------///

                        $promedio = $key['lxp_promedio'];
                        // ************ Nota mínima por área para que un curso materia sea aprobada *******************
                        $minima = $this->gsatelite->get_campo('ard_area_academica', 'ard_nota_minima', array('ard_id'=>$area));

                        /************* Aproximación de promedio, si aplica ************************/
                        $prom = (float)$key['lxp_promedio'];
             
                        if($min_aproxima>0){
                            // Si el promedio está entre el mínimo y máximo se aproxima.
                            if($prom>=$min_aproxima && $prom <= $max_aproxima){
                                $promedio = round($key['lxp_promedio']);
                            }
                        }

                        // Comparar lxp_promedio con la nota mínima y si aprueba se hace la inscripción de cada alumno.
                        if((float)$promedio >= (float)$minima){
                            /************** verificar si el alumno ya posee inscripción en el siguiente grupo ***********/
                            $verifica_ins = $this->gsatelite->get_registro('lxp_alumnoxpensum', array('lxp_id_lxa'=>$key['lxp_id_lxa'], 'lxp_id_gra'=>$id_gra));
                            if(count($verifica_ins)<=0 && $id_gra){
                                $array_new = array(
                                        'lxp_id_lxa'=>$key['lxp_id_lxa'],
                                        'lxp_id_gra'=> $id_gra,
                                        'lxp_condicion'=>1,
                                        'lxp_fecha_inscripcion'=>date('Y-m-d H:i:s'),
                                        'lxp_exam_ubicacion'=>0,
                                        'lxp_tipo_inscripcion'=>1,
                                        'lxp_estado'=>1,
                                        'lxp_usu_crea'=>$this->tank_auth->get_user_id(),
                                        'lxp_fecha_crea'=>date('Y-m-d H:i:s'),
                                        'lxp_usu_mod'=>$this->tank_auth->get_user_id(),
                                        'lxp_fecha_mod'=>date('Y-m-d H:i:s')
                                    );
                                $proceso = $this->gsatelite->ingresar('lxp_alumnoxpensum', $array_new);
                            }

                            $proceso = $this->gsatelite->actualizar_array('lxp_alumnoxpensum', array('lxp_condicion'=>2, 'lxp_fecha_mod'=>date('Y-m-d H:i:s'), 'lxp_usu_mod'=>$this->tank_auth->get_user_id()), array('lxp_id'=>$key['lxp_id'])); // Nivel aprobado
                           
                        }else{
                            $proceso = $this->gsatelite->actualizar_array('lxp_alumnoxpensum', array('lxp_condicion'=>3, 'lxp_fecha_mod'=>date('Y-m-d H:i:s'), 'lxp_usu_mod'=>$this->tank_auth->get_user_id()), array('lxp_id'=>$key['lxp_id'])); // Nivel reprobado
                        }

                        /*********************************** Cierre de grupo *********************************/
                            $proceso = $this->gsatelite->actualizar_array('gra_grupo_academico', array('gra_cerrado'=>1), array('gra_id'=>$id_gra_ant)); // Nivel reprobado
                    }
                    $rec = $proceso;
                }
            }

            if($rec == 1){
                return true;
            }else{
                echo json_encode($this->db->last_query());
            }
        }
    }

    /**
     * @author Edith Herrera
     * @since  2018-02-05
     * @return Procceso de rectificación de notas.
    **/
    public function rectificacion_notas($proyeccion=null) {        
        $this->procesar_notas(1, $proyeccion);
        //$this->procesar_fin_grupo();
    }

    /**
     * @author Edith Herrera
     * @since  2018-02-21
     * @return Procceso de rectificación de notas.
    **/
    public function get_prerrequisitos(){
        satelite_validar(true);
        $area = $this->input->post('area');
        $nivel = $this->input->post('nivel');
        $contador = ($this->input->post('contador')) ? $this->input->post('contador') : 0;
        $docente = $this->input->post('docente');
        //die(print_r($_POST));
        $pre =  $this->registro_academico_model->prerrequisito_n(array('pen.pen_id_ard'=>$area, 'pen.pen_id'=>$nivel), $area);
       
        $prerrequisitos = array();
        $pen_actual;
        $filas = '';
        $existe= array();
        foreach ($pre as $key) {
            if($docente>0){
                $existe = $this->gsatelite->get_registro('mpd_modulo_pensumxdocente', array('mpd_id_pen'=>$key['pensum'], 'mpd_id_dct'=>$docente));
            }
                    if(count($existe)<=0){ 
                        $prerrequisitos[] = array(
                            'pensum'=>$key['pensum'],
                            'modulo'=>$key['mod_nombre'],
                            'area'=>$key['area'],
                            'ard_id'=>$area
                            );
                    }
            $pen_actual = $key['pensum'];
        }
       
        while ($pen_actual>0) {
           $child =  $this->registro_academico_model->prerrequisito_n(array('pen.pen_id_ard'=>$area, 'pen.pen_id'=>$pen_actual), $area);
            if(count($child)>0){
                foreach ($child as $ch) {
                    $existe = $this->gsatelite->get_registro('mpd_modulo_pensumxdocente', array('mpd_id_pen'=>$ch['pensum'], 'mpd_id_dct'=>$docente));
                    if(count($existe)<=0){  
                        $prerrequisitos[] = array(
                            'pensum'=>$ch['pensum'],
                            'modulo'=>$ch['mod_nombre'],
                            'area'=>$ch['area'],
                            'ard_id'=>$area
                            );
                    }
                    $pen_actual = $ch['pensum'];
                }
            }else{
                $pen_actual = 0;
            }
        }
       
        array_unique($prerrequisitos);
        foreach ($prerrequisitos as $pre ) {
            $filas.='<tr class="dato'.$contador.' " id="DH'.$area.$pre['pensum'].'" data-corr="'.$contador.'" clase="dato'.$contador.'"><td id="correlativo_td" style="display:none;">1</td><td class="td-input first">
                        <input type="hidden" value="'.$area.'" id="detalle_ar'.$contador.'" name="detalle_ar[]" >
                        <input type="hidden" value="'.$pre['pensum'].'" id="detalle_n'.$contador.'" name="detalle_n[]" >
                        <span id="area'.$contador.'"> '.$pre['area'].'</span> </td>
                        <td> <span id="frecuencia'.$contador.'">'.$pre['modulo'].'</span></td>
                        <td width="15%">
                        <button type="button" value="'.$contador.'" id="eliminar'.$contador.'"  class="btn btn-danger btn-mini delete_fila" style="width: 50px;float: left; margin-right:10%; height:30px; " >Eliminar</button></td>
                    </tr>';
            $contador++;
        }
        //

        echo json_encode(array('filas'=>$filas, 'cont'=>$contador));
    }

    /**
     * @author Luis Navarro
     * @since  2018-02-23
     * @return Obtener las aulas, secciones y supervisores que no estan ocupadas
    **/
    public function obtener_horario_validado() {
        satelite_validar(true);
        if($this->input->post()) {
            $aula       = $this->input->post("aula");
            $frecuencia = $this->input->post("frecuencia");
            $pluriclase = $this->input->post("pluriclase");
            $proyeccion = $this->input->post("proyeccion");
            $grado      = $this->input->post("grado");
            $nivel      = $this->input->post("nivel");

            if($proyeccion>0){ // obtener fechas de proyección
                $reg_pyc = $this->gsatelite->get_registro('pyc_proyeccion', array('pyc_id'=>$proyeccion, 'pyc_estado'=>1));
                $fecha_ini = formatear_fecha('Y-m-d', $reg_pyc->pyc_fecha_inicio);
                $fecha_fin = formatear_fecha('Y-m-d', $reg_pyc->pyc_fecha_fin);
            }
            if ($nivel > 0) {
                $where['gra_id_pen'] = $nivel;
            }


            $not_in = '0';
            // Verifica si se ha utilizado aula, seccción, supervisor y docente para la misma frecuencia según proyección.
            $where['((date_format(pyc_fecha_inicio,"%Y-%m-%d") <= "'.$fecha_ini.'" AND date_format(pyc_fecha_fin,"%Y-%m-%d") >= "'.$fecha_ini.'") OR (date_format(pyc_fecha_inicio,"%Y-%m-%d") <= "'.$fecha_fin.'" AND date_format(pyc_fecha_fin,"%Y-%m-%d") >= "'.$fecha_fin.'")) AND gra_id_frh = '.$frecuencia.' AND gra_estado = 1 AND (gra_cerrado IS NULL OR gra_cerrado=0)']=NULL;

            if ($frecuencia != null && $pluriclase != 1 && $grado<=0) {
                $asignado = $this->registro_academico_model->get_infoxfrecuencia($where, 'aul_id');
                //die(print_r($asignado));
                if(count($asignado)>0){ $not_in = array_column($asignado, "aul_id"); }
                $this->db->where_not_in('aul_id',$not_in);
            }
            
            // Obtener todas las aulas que estan asignadas a en las frecuencias
            if($grado>0){
                $gra_aul = $this->gsatelite->get_campo('gra_grupo_academico', 'gra_id_aul', array('gra_id'=>$grado));
                $aulas_drop = $this->gsatelite->get_dropdown('aul_aula', '{aul_nombre}', '', array('aul_estado' => 1), $gra_aul, '', 'aul_id', true); 
            }else{
                $aulas_drop = $this->gsatelite->get_dropdown('aul_aula', '{aul_nombre}', '', array('aul_estado' => 1), null, '', 'aul_id', true); 
            }
            $aulas = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $aulas_drop);


            $where_scc = array();
            if ($frecuencia != null && $pluriclase != 1 && $grado<=0) {
                $where_scc['pyc_id = '.$proyeccion.' AND gra_estado = 1 AND gra_id_pen = '.$nivel.' AND gra_id_frh = '.$frecuencia.' AND (gra_cerrado IS NULL OR gra_cerrado=0)'] = NULL; 
               
                $asignado = $this->registro_academico_model->get_infoxfrecuencia($where_scc, 'scc_id');  
            
                if(count($asignado)>0){  $not_in = array_column($asignado, "scc_id");  }
                    $this->db->where_not_in('scc_id',$not_in);
            }

            // Obtener todas las secciones que estan asignadas a en las frecuencias
             if($grado>0){
                $gra_scc = $this->gsatelite->get_campo('gra_grupo_academico', 'gra_id_scc', array('gra_id'=>$grado));

                $seccion_drop = $this->gsatelite->get_dropdown('scc_seccion', '{scc_nombre}', '', array('scc_estado' => 1), $gra_scc, '', 'scc_id', true); 
            }else{
                $seccion_drop = $this->gsatelite->get_dropdown('scc_seccion', '{scc_nombre}', '', array('scc_estado' => 1), null, '', 'scc_id', true); 
            }

            $seccion = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $seccion_drop);

            if ($frecuencia != null && $pluriclase != 1) {
                $asignado = $this->registro_academico_model->get_infoxfrecuencia($where, 'sug_id');     
        
                if(count($asignado)>0){ $not_in = array_column($asignado, "sug_id"); }
                $this->db->where_not_in('sug_id',$not_in);
            }
            // Obtener todos los supervisores que estan asignadas a en las frecuencias
            $this->db->join('emp_empleado', 'emp_id=sug_id_emp');
            $supervisor_drop = $this->gsatelite->get_dropdown('sug_supervisor_grupo', '{emp_nombre} {emp_apellido}', '', array('sug_estado' => 1), null, '', 'sug_id', true);
            $supervisores = str_replace('<option value="0">Seleccione</option>', '', $supervisor_drop);
            
            echo json_encode(array('aulas'=>$aulas, 'secciones'=>$seccion, 'supervisores'=>$supervisores));
            die();
        }
    }


     /**
    * @author Edith Herrera
    * @since  2018-03-05
    * @return Valida el horario del alumno.
    **/
    function validar_horario_alumno() {
        satelite_validar(true);

        if($this->input->post()) {
            $estado = 0;
            $arr = array();

            $frecuencia = $this->input->post('frecuencia');
            $alumno = $this->input->post('alumno');
            $proyeccion = $this->input->post('proyeccion');

            $frh_actual = $this->registro_academico_model->get_frecuencias(array('frh_id'=>$frecuencia, 'frh_estado'=>1, 'pyc_id'=>$proyeccion));
            $frh_alumno = $this->registro_academico_model->get_frecuenciasxalumno(array('lxa_id_alm'=>$alumno, 'lxp_condicion'=>1, 'gra_id_pyc'=>$proyeccion));
            
            $selected = array(0);
            if(count($frh_alumno)>0){
                $selected = array_column($frh_alumno, "gra_id_frh");
            }

            $where['frh_estado'] = 1;
            $where['pyc_id'] = $proyeccion;
            foreach ($frh_actual as $key => $value) {
                if(count($selected)>0){
                    $this->db->where_in('frh_id', $selected);
                }
                $this->db->where("((hrg_inicio >= '".$value['hrg_inicio']."' AND hrg_inicio <- '".$value['hrg_fin']."') OR (hrg_fin >= '".$value['hrg_inicio']."' AND  hrg_fin <= '".$value['hrg_fin']."')) AND dia_id=".$value['dia_id']."", NULL, false);
                $consulta2 = $this->registro_academico_model->get_frecuencias($where);
               
                if(count($consulta2)>0) {
                    $estado++;
                }
            }
            $datos = array(
                'exito' => $estado
            );
            echo json_encode($datos);
        }
    }


    public function efectuar_retiro_materias($post, $id_lxp=null){
        $motivo = $post['causas'];
        $lxp_id = ($id_lxp!=null)?$id_lxp:$post['lxp_id'];
        $estado = $post['estado'];
        $alm_id = $post['alm_id'];
        $lxa_id = $post['lxa_id'];
        $grado  = $post['grado']; // Si se retira una materia perteneciente a un grado
        $fecha = $post['fecha_retiro'];
        $observacion = $post['observacion'];

        $reg_lxp = $this->gsatelite->get_tabla('lxp_alumnoxpensum', array('lxp_id'=>$lxp_id));

        if($reg_lxp[0]['lxp_id_fac']!=null && $reg_lxp[0]['lxp_id_fac']>0){
            $id = $reg_lxp[0]['lxp_id_fac'];
            $factura = $this->gsatelite->get_registro('mxf_movimientoxfact',array('mxf_id_fac'=>$id, 'mxf_estado'=>1));
            if(count($factura)>0){

                $proceso = $this->gsatelite->get_campo('tip_tipo_proceso','tip_id_tip_entrada',array('tip_facturacion'=>1,'tip_estado'=>1));
                        
                $bodega =  $this->gsatelite->get_campo('moi_movimiento_inv','moi_id_bod', array('moi_id'=>$factura->mxf_id_moi));
                $producto_fila = $this->gsatelite->get_registro('dee_detalle_mov', array('dee_id_moi'=>$factura->mxf_id_moi));
                $array = json_decode(json_encode($producto_fila), true);
                $producto = array();
                $cantidad = array();
                $datos = array();
                        
                if(count($producto_fila)==1){
                    $producto[] = $array['dee_id_art'];
                    $cantidad[] = $array['dee_cantidad'];
                } else {
                    foreach ($array as $key => $value) {
                        $producto[] = $value['dee_id_art'];
                        $cantidad[] = $value['dee_cantidad'];
                    }
                }
                $datos[] = $producto;
                $datos[] = $cantidad;
                $datos[] = $bodega;
                $datos[] = $id;

                $this->load->library('../controllers/facturacion/consultas');
                $this->consultas->ingresar_productos_movimiento(true, $datos, $proceso, $motivo, $id);
            }
        }

            $this->db->where('(cmc_estado_cargo != 2 AND cmc_id_fac IS NULL) OR (cmc_estado_cargo != 2 AND cmc_confirma_externo IS NULL)');
            $this->db->where("cmc_estado_cargo = 1 AND cmc_fecha >= '$fecha'");
        $cmc_cuotas = $this->gsatelite->get_tabla('cmc_cargo_alumnoxcurso', array('cmc_id_lxp'=>$lxp_id));

        if(!empty($cmc_cuotas)) {
            foreach ($cmc_cuotas as $cuota) {
                $actualizar_cmc = array(
                        'cmc_estado_cargo' => 0,
                        'cmc_estado' => 0
                );
                $this->gsatelite->actualizar_array('cmc_cargo_alumnoxcurso', $actualizar_cmc, array('cmc_id' => $cuota['cmc_id']));
            }
        }

                           $this->db->where_not_in('lxp_id',$lxp_id);
                           $this->db->where('lxp_condicion', 1);
                           $this->db->where('lxa_id_alm',$alm_id);
                           $this->db->join('lxp_alumnoxpensum','lxa_id = lxp_id_lxa');
        $inscripcion_alm = $this->gsatelite->get_tabla('lxa_alumnoxarea'); 

        $data = array(
            'lxp_condicion' => $estado,
            'lxp_id_crt' => $motivo,
            'lxp_fecha_retiro' => ($fecha!='') ? date('Y-m-d', strtotime($fecha)) : date('Y-m-d'),
            'lxp_observacion' => ($observacion != '') ? $observacion : null,
            'lxp_usu_mod' => $this->tank_auth->get_user_id(),
            'lxp_fecha_mod' => date('Y-m-d H:i:s'),
            'lxp_estado'=>0
        );

        $result = $this->gsatelite->actualizar('lxp_alumnoxpensum', $data, 'lxp_id', $lxp_id);

        if ($result > 0) {                    
            return $result;
        }else{
            return 0;
        }
    }


    public function generar_finalizacion_grado($post, $id_lxp, $grupo_pre=null){
        $pyc_id = $post['pyc'];
        $grupo = $post['grupo']; 
        $grupo_ant = $post['grupo_ant'];
        $area = $post['area']; 

        //Inscripciones de alumnos al grupo antiguo.
        $ins = $this->gsatelite->get_registro('lxp_alumnoxpensum', array('lxp_id'=>$id_lxp)); //Inscripción

        $proceso = 0;
        if(count($ins)>0){
            $minima = $this->gsatelite->get_campo('ard_area_academica', 'ard_nota_minima', array('ard_id'=>$area));
                    
            // Comparar lxp_promedio con la nota mínima y si aprueba se hace la inscripción de cada alumno.
            if((float)$ins->lxp_promedio >= (float)$minima && $grupo>0){
                if($grupo_pre>0){
                    $array_new = array(
                        'lxp_id_lxa'=>$ins->lxp_id_lxa,
                        'lxp_id_gra'=>$grupo,
                        'lxp_condicion'=>1,
                        'lxp_fecha_inscripcion'=>date('Y-m-d H:i:s'),
                        'lxp_exam_ubicacion'=>0,
                        'lxp_tipo_inscripcion'=>1,
                        'lxp_estado'=>1,
                        'lxp_usu_crea'=>$this->tank_auth->get_user_id(),
                        'lxp_fecha_crea'=>date('Y-m-d H:i:s'),
                        'lxp_usu_mod'=>$this->tank_auth->get_user_id(),
                        'lxp_fecha_mod'=>date('Y-m-d H:i:s')
                    );

                    $proceso = $this->gsatelite->ingresar('lxp_alumnoxpensum', $array_new);
                }
                $proceso = $this->gsatelite->actualizar_array('lxp_alumnoxpensum', array('lxp_condicion'=>2, 'lxp_fecha_mod'=>date('Y-m-d H:i:s'), 'lxp_usu_mod'=>$this->tank_auth->get_user_id()), array('lxp_id'=>$ins->lxp_id, 'lxp_condicion'=>1)); // Nivel aprobado
            }

            /*********************************** Cierre de grupo *********************************/
            $proceso = $this->gsatelite->actualizar_array('gra_grupo_academico', array('gra_cerrado'=>1), array('gra_id'=>$grupo_ant)); // Nivel reprobado     
        }
        return $proceso;
                
    }

    /**
     * Descripción:
     * Función para obtener los detalles del cargo configurado al grado.
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-06-11
     * @param  Ninguno
     * @return Cargos configurados por grado.
     */
    function get_cargos_grd(){
        satelite_validar(true);

        $id_gra = $this->input->post('grupo');
        $id_grd = $this->input->post('grado');
        $id_nivel_materia_curso = $this->input->post('materia');


        if( $id_gra >0 ){
                     $this->db->join('grd_grado', 'gra_id_grd=grd_id', 'left');
            $grupo = $this->gsatelite->get_registro('gra_grupo_academico', array('gra_id'=>$id_gra));
        }else if($id_grd >0){
                      $this->db->limit(1);
                      $this->db->where('grd_id',$id_grd);
                      $this->db->join('grd_grado', 'gra_id_grd=grd_id', 'inner');
            $grupo = $this->gsatelite->get_registro('gra_grupo_academico');
        }
        
        $registro = array();
        $id_cfg = '';
        if(!empty($grupo) && $grupo->grd_id_cfg!=''){
            $id_cfg = $grupo->grd_id_cfg;
            $registro = $this->registro_academico_model->get_config_cargos(array('cfg_id'=>$grupo->grd_id_cfg));
        }  else if ($id_nivel_materia_curso > 0) {            

                $this->db->join('mod_modulo', 'mod_id=pen_id_mod', 'inner');
                $this->db->join('dfc_detalle_configuracion_cargo', 'dfc_id_art=mod_id_art', 'inner');
            $cfg_materia = $this->gsatelite->get_registro('pen_pensum', array('pen_id'=>$id_nivel_materia_curso));

            if(!empty($cfg_materia)) {
                $id_cfg = $cfg_materia->dfc_id_cfg;

                $registro = $this->registro_academico_model->get_config_cargos(array('cfg_id'=>$cfg_materia->dfc_id_cfg, 'dfc_id_art'=>$cfg_materia->dfc_id_art));
            }
        }

        $data['detalle'] = $registro;
        $html = $this->load->view('registro_academico/procesos/detalle_configuracion', $data, true);

        echo json_encode(array('html'=>$html, 'cfg_id'=>$id_cfg));
    }

    /**
     * Descripción:
     * Función para obtener toda la informacion de un alumno detallada
     * @author Israel Alfaro - Grupo Satélite
     * @since  2018-09-10
     * @param  ID del alumno
     * @return arrays de toda la informacion perteneciente al alumno.
     */
    function ficha_alumno($alm_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['alumno'] = $this->gsatelite->get_tabla('alm_alumno', array('alm_id' => $alm_id));
            $get_data_alumno = $this->gsatelite->get_tabla('alm_alumno', array('alm_id' => $alm_id));
            $genero = $this->gsatelite->get_tabla('gen_genero', array('gen_id' => $get_data_alumno[0]['alm_id_gen']));
            $data['genero'] = $genero[0]['gen_nombre'];

            $estado_civil = $this->gsatelite->get_tabla('esc_estado_civil', array('esc_id' => $get_data_alumno[0]['alm_id_esc']));
            $data['est_civil'] = $estado_civil[0]['esc_nombre'];

            $pais = $this->gsatelite->get_tabla('pai_pais', array('pai_id' => $get_data_alumno[0]['alm_id_pai']));
            $data['pais'] =$pais[0]['pai_nombre'];

            $departamento = $this->gsatelite->get_tabla('dep_departamento', array('dep_id' => $get_data_alumno[0]['alm_id_dep']));
            $data['departamento'] = $departamento[0]['dep_nombre'];

            $municipio = $this->gsatelite->get_tabla('mun_municipio', array('mun_id' => $get_data_alumno[0]['alm_id_mun']));
            $data['municipio'] = $municipio[0]['mun_nombre'];

            $pais_nac = $this->gsatelite->get_tabla('pai_pais', array('pai_id' => $get_data_alumno[0]['alm_id_pai_nacionalidad']));
            $data['pais_naci'] = $pais_nac[0]['pai_pais'];
            $data['nacionalidad'] = $pais_nac[0]['pai_nacionalidad'];

            $dep_nac = $this->gsatelite->get_tabla('dep_departamento', array('dep_id' => $get_data_alumno[0]['alm_id_dep_nacimiento']));
            $data['dep_nac'] = $dep_nac[0]['dep_nombre'];
            $mun_dep = $this->gsatelite->get_tabla('mun_municipio', array('mun_id' => $get_data_alumno[0]['alm_id_mun_nacimiento']));
            $data['mun_nac'] = $mun_dep[0]['mun_nombre'];
            $zona_nac = $this->gsatelite->get_tabla('zon_zona', array('zon_id' => $get_data_alumno[0]['alm_id_zon']));
            $data['zona_nac'] = $zona_nac[0]['zon_nombre'];
            //*********************************** DATOS GENERALES 2*********************************
            $religion = $this->gsatelite->get_tabla('rel_religion', array('rel_id' => $get_data_alumno[0]['alm_id_rel']));
            $data['religion'] = $religion[0]['rel_nombre'];

            $profesion = $this->gsatelite->get_tabla('pro_profesion', array('pro_id' => $get_data_alumno[0]['alm_id_pro']));
            $data['profesion'] = $profesion[0]['pro_nombre'];

            $grupo_fam = $this->gsatelite->get_tabla('gfa_grupo_familiar', array('gfa_id' => $get_data_alumno[0]['alm_id_gfa']));
            $data['grupo_fam'] = $grupo_fam[0]['gfa_nombre'];

            $estado_fam = $this->gsatelite->get_tabla('esf_estado_familia', array('esf_id' => $get_data_alumno[0]['alm_id_esf']));
            $data['estado_fam'] = $estado_fam[0]['esf_nombre'];

            $financiamiento = $this->gsatelite->get_tabla('fin_financiamiento', array('fin_id' => $get_data_alumno[0]['alm_id_fin']));
            $data['financiamiento'] = $financiamiento[0]['fin_nombre'];

            $empresa_convenio = $this->gsatelite->get_tabla('clm_cliente_alumno', array('clm_id_alm' => $alm_id));
            $empresa_conv_array = array();
            foreach ($empresa_convenio as $key) {
                $cliente_emp = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $key['clm_id_cli']));
                $empresa_conv_array[] = " ".$cliente_emp[0]['cli_nombre'] ." ". $cliente_emp[0]['cli_apellido'];
            }
            $data['empr_almno'] = implode(',', $empresa_conv_array);

            $tipo_transporte = $this->gsatelite->get_tabla('ttr_tipo_transporte', array('ttr_id' => $get_data_alumno['alm_id_ttr']));
            $data['tipo_tarnsporte'] = $tipo_transporte[0]['ttr_nombre'];

            $tipos_medios = array();
            $medio_alm = $this->gsatelite->get_tabla('mxl_medioxalumno', array('mxl_id_alm' => $alm_id));
            foreach ($medio_alm as $key) {
                $tipos_med = $this->gsatelite->get_tabla('tmc_tipo_medio', array('tmc_id' => $key['mxl_id_tmc']));
                $tipos_medios[] = $tipos_med[0]['tmc_nombre'];
            }
            $data['tipo_medios'] = implode(',', $tipos_medios);

            $caracteristicas_eleccion = array();
            $caracxalumno = $this->gsatelite->get_tabla('cea_caracteristica_eleccionxalumno', array('cea_id_alm' => $alm_id));
            foreach ($caracxalumno as $key) {
                $carac_eleccion = $this->gsatelite->get_tabla('cre_caracteristica_eleccion', array('cre_id' => $key['cea_id_cre']));
                $caracteristicas_eleccion[] = $carac_eleccion[0]['cre_nombre'];
            }
            $data['caracteristicas_eleccion'] = implode(',', $caracteristicas_eleccion);
            $tipo_ingreso = $this->gsatelite->get_tabla('tin_tipo_ingreso', array('tin_id' => $get_data_alumno[0]['alm_id_tin']));
            $data['tipo_ingreso'] = $tipo_ingreso[0]['tin_nombre'];

            $estado = $this->gsatelite->get_tabla('esa_estado_alumno', array('esa_id' => $get_data_alumno[0]['alm_id_esa']));
            $data['ese_estado'] = $estado[0]['esa_nombre'];

            $array_tipo_tel = array();
            $telefono_alm = $this->gsatelite->get_tabla('tal_telefonoxalumno', array('tal_id_alm' => $alm_id));
            for ($i = 0; $i < count($telefono_alm); $i++) {
                $tipo_tel_name = $this->gsatelite->get_tabla('tit_tipo_telefono', array('tit_id' => $telefono_alm[$i]['tal_id_tit']));
                $array_tipo_tel[] = $tipo_tel_name[0]['tit_nombre'];
            }
            $data['telefonoxalumno'] = $telefono_alm;
            $data['tipo_nombre'] = $array_tipo_tel;

            $array_tipo_reds = array();
            $redsocialxalumno = $this->gsatelite->get_tabla('rxa_red_socialxalumno', array('rxa_id_alm' => $alm_id));
            for ($i = 0; $i < count($redsocialxalumno); $i++) {
                $red_social = $this->gsatelite->get_tabla('res_red_social', array('res_id' => $redsocialxalumno[$i]['rxa_id_res']));
                $array_tipo_reds[] = $red_social[0]['res_nombre'];
            }
            $data['redsocialxalumno'] = $redsocialxalumno;
            $data['tipo_reds'] = $array_tipo_reds;

            #-------------------------------------------- DOCUMENTOS --------------------------------------------
            $documentoxalumno = $this->gsatelite->get_tabla('dca_documento_alumno', array('dca_id_alm' => $alm_id));
            $array_tipo_doc = array();
            $img_type = array();
            for ($i = 0; $i < count($documentoxalumno); $i++) {
                $name_tipo_doc = $this->gsatelite->get_tabla('tde_tipo_documento', array('tde_id' => $documentoxalumno[$i]['dca_id_tde']));
                $array_tipo_doc[] = $name_tipo_doc[0]['tde_nombre'];

                $type = strtolower(trim(end(explode('.', $documentoxalumno[$i]['dca_url']))));
                if ($type == "pdf") {
                    $img_type[] = "media/imagenes/sistema/pdf.png";
                } else if($type == "jpg") {
                    $img_type[] = "media/imagenes/sistema/jpg.png";
                }  else if($type == "jpeg") {
                    $img_type[] = "media/imagenes/sistema/jpeg.png";
                }  else if($type == "png") {
                    $img_type[] = "media/imagenes/sistema/png.png";
                }  else if($type == "doc") {
                    $img_type[] = "media/imagenes/sistema/doc.png";
                }  else if($type == "docx") {
                    $img_type[] = "media/imagenes/sistema/docx.png";
                }  else if($type == "xls") {
                    $img_type[] = "media/imagenes/sistema/xls.png";
                }  else if($type == "xlsx") {
                    $img_type[] = "media/imagenes/sistema/xlsx.png";
                }  else if($type == "txt") {
                    $img_type[] = "media/imagenes/sistema/txt.png";
                }  else if($type == "rar") {
                    $img_type[] = "media/imagenes/sistema/rar.png";
                }  else  {
                    $img_type[] = "media/imagenes/sistema/noposee.jpeg";
                } 
            }
            $data['documentoxalumno'] = $documentoxalumno;
            $data['tipo_doc'] = $array_tipo_doc;
            $data['img_docxalm'] = $img_type;

            #----------------------------------------------------------- FAMILIARES --------------------------------------------------------
            $familiares = $this->gsatelite->get_tabla('fal_familiar_alumno', array('fal_id_alm' => $alm_id));
            $array_parentesco = array();
            $array_profesion = array();
            for ($i = 0; $i < count($familiares); $i++) {
                $parentesco = $this->gsatelite->get_tabla('pat_parentesco', array('pat_id' => $familiares[$i]['fal_id_pat']));
                $profesion = $this->gsatelite->get_tabla('pro_profesion', array('pro_id' => $familiares[$i]['fal_id_pro']));

                $array_parentesco[] = $parentesco[0]['pat_nombre'];
                $array_profesion[] = $profesion[0]['pro_nombre'];
                
            }
            $data['familiares'] = $familiares;
            $data['parentesco'] = $array_parentesco;
            $data['profesion'] = $array_profesion;

            $data['eda_educacion'] = $this->personal_model->get_datos_academicos_alumnos(array('eda_id_alm' => $alm_id));
            $data['idioma_reg'] = $idiomaxalumno = $this->personal_model->get_idioma_alumnos(array('ial_id_alm' => $alm_id));
            $array_nivel_ling = array();
            for ($i = 0; $i < count($data['idioma_reg']); $i++) {
                $nivel_idi = $this->gsatelite->get_tabla('nii_nivel_idioma', array('nii_id' => $idiomaxalumno[$i]['eda_id_nii']));
                $array_nivel_ling[] = $nivel_idi[0]['nii_nombre'];
            }

            $data['anexo_perfil'] = $this->gsatelite->get_tabla('axl_anexoxalumno', array('axl_id_alm' => $alm_id, 'axl_img_perfil' => 1));
            $data['lvl_idioma'] = $array_nivel_ling;

            $data['clinicos_reg'] = $clinicos_reg = $this->personal_model->get_clinicos_alumnos(array('cla_id_alm' => $alm_id));
            $tipo_tratamiento = $this->gsatelite->get_tabla('ttm_tipo_tratamiento', array('ttm_id' => $clinicos_reg[0]['cla_id_ttm']));
            $parentesco_clinicos = $this->gsatelite->get_tabla('pat_parentesco', array('pat_id' => $clinicos_reg[0]['cla_id_ttm']));

            $data['tipo_tratamiento'] = $tipo_tratamiento[0]['ttm_nombre'];
            $data['parentesco_clinico'] = $parentesco_clinicos[0]['pat_nombre'];

            $data['ref_laborales_reg'] = $this->gsatelite->get_tabla('eal_empleo_alumno', array('eal_id_alm' => $alm_id));

            $data['habilidades_reg'] = $habilidades_reg = $this->personal_model->get_habilidades_alumnos(array('hxa_id_alm' => $alm_id));
            $array_name_hab = array();
            for ($i = 0; $i < count($habilidades_reg); $i++) {
                $name_hab = $this->gsatelite->get_tabla('hab_habilidad', array('hab_id' => $habilidades_reg[$i]['hxa_id_hab']));
                $array_name_hab [] = $name_hab[0]['hab_nombre'];
            }
            $data['name_hab'] = $array_name_hab;

            $data['pasatiempos_reg'] = $pasatiempos_reg = $this->personal_model->get_pasatiempo_alumno(array('psa_id_alm' => $alm_id));
            $array_pasatiempo =array();
            for ($i = 0; $i < count($pasatiempos_reg); $i++) {
                $pasatiempo = $this->gsatelite->get_tabla('pst_pasatiempo', array('pst_id' => $pasatiempos_reg[$i]['psa_id_pst']));
                $array_pasatiempo = $pasatiempo[0]['pst_nombre'];
            }
            $data['pasatipo'] = $array_pasatiempo;

            $data['anexos'] = $anexos = $this->gsatelite->get_tabla('axl_anexoxalumno', array('axl_id_alm' => $alm_id, 'axl_img_perfil' => 0));
            $name_anx = array();
            $img_type = array();
            foreach ($anexos as $key) {
                $name_anx[] = $key['axl_nombre'];

                $type = strtolower(trim(end(explode('.', $key['axl_url']))));
                if ($type == "pdf") {
                    $img_type[] = "media/imagenes/sistema/pdf.png";
                } else if($type == "jpg") {
                    $img_type[] = "media/imagenes/sistema/jpg.png";
                }  else if($type == "jpeg") {
                    $img_type[] = "media/imagenes/sistema/jpeg.png";
                }  else if($type == "png") {
                    $img_type[] = "media/imagenes/sistema/png.png";
                }  else if($type == "doc") {
                    $img_type[] = "media/imagenes/sistema/doc.png";
                }  else if($type == "docx") {
                    $img_type[] = "media/imagenes/sistema/docx.png";
                }  else if($type == "xls") {
                    $img_type[] = "media/imagenes/sistema/xls.png";
                }  else if($type == "xlsx") {
                    $img_type[] = "media/imagenes/sistema/xlsx.png";
                }  else if($type == "txt") {
                    $img_type[] = "media/imagenes/sistema/txt.png";
                }  else if($type == "rar") {
                    $img_type[] = "media/imagenes/sistema/rar.png";
                }  else  {
                    $img_type[] = "media/imagenes/sistema/noposee.jpeg";
                }                        
            }
            $data['nombre_anexo'] = $name_anx;
            $data['url_anexo'] = $img_type;
            $data['anexos'] = $anexos;
            
            //*****************************************************************
            $html = $this->load->view('reporte/header', array('titulo' => 'Ficha de alumno'), true);
            $html .= $this->load->view('registro_academico/procesos/ficha_alumno', $data, true);
            
            $this->pdf->reporteNombrePDF($html, explode(' ', trim($get_data_alumno[0]['alm_nombre']))[0].$get_data_alumno[0]['alm_codigo'], 'D', 1);
            //, 'none', 'L', 'D', $get_data_alumno[0]['alm_nombre'].$get_data_alumno[0]['alm_codigo']
        }
    }

    /**
     * Descripción:
     * 
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-09-26
     * @return Archivo SIRAI .CSV o .TXT, según el caso.
     */
    function generacion_sirai(){
        satelite_validar();
        if($_POST){
            $grado = $this->input->post('slcGrado');
            $materia = $this->input->post('slcMateria');
            $tipo_rpt = $this->input->post('tipo_rpt');

            $where = array();
            if($grado > 0){
                $where['grd_id'] = $grado;
            }

            if($materia > 0){
                $where['pen_id'] = $materia;
            }

            $registros = $this->registro_academico_model->get_materias_grado($where, 'mod_codigo');

            $array = array();
            if(count($registros)>0){
                foreach ($registros as $key) {
                $notas_alm = array();
                    $pensum = $key['pen_id'];
                    $lxp = $key['lxp_id'];
                    $notas = $this->registro_academico_model->get_promedio_periodo(array('pen_id'=>$pensum, 'noa_id_lxp'=>$lxp));

                    ///////////// Se forma arreglo de notas por alumno y materia recorrida////////////////
                    if(count($notas)>0){
                        $notas_alm = array_column($notas, 'nota');
                    }
                    
                    /////// Se rellenan los espacios para completar las 4 notas (promedio por periodo) /////
                    if(count($notas)<4){
                        $cant = 4- count($notas);
                        for ($i=1; $i <= $cant ; $i++) { 
                            $notas_alm[] = "";
                        }
                    }
                   
                    ///////// Se forma la cadena a enviar para su recorrido en la vista /////////////
                    $notas_txt = implode(";", $notas_alm);
                    $array[] = $key['mod_nombre'].';'.$key['mod_codigo'].';'.$key['alm_codigo_nie'].';'.$notas_txt;
                }
            }

            $data['registros'] = $array;
            $data['tipo'] = ($tipo_rpt>0)?$tipo_rpt:1;
            $this->load->view('registro_academico/procesos/exportar_sirai', $data);

        }else{            
            $grado = $this->gsatelite->get_dropdown('grd_grado', '{grd_nombre}', '', array('grd_estado' => 1), null, '', 'grd_id', true); 
            $data['grado'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $grado);

            
            $sucursal_str   = $this->get_sucursales();                          
            $this->db->where('alm_id_suc in('.$sucursal_str.')',NULL);
            $alumno_drop    = $this->gsatelite->get_dropdown('alm_alumno', '{alm_nombre} {alm_apellido}', '', array('alm_estado' => 1), null, '', 'alm_id', true); 
            $alumno_drop    = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $alumno_drop);
            $data['alumno'] = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $alumno_drop);
            $data['titulo_personal'] = "Generación de SIRAI";
            $this->_cargarvista($data);
        }
    }


    /**
     * @author Edith Herrera - Grupo Satéliteo
     * @since  2018-09-28
     * @return Opciones del dropdown de materias por grado.
     */
    function get_materiasxgrado(){
        satelite_validar(true);

        $grado = $this->input->post('grado');

        $where = array();
        if($grado>0){
            $where['grd_id'] = $grado; 
        }

        $materias = $this->registro_academico_model->get_materias_grado($where, null, 'pen_id');

        $options = '<option value=""></option>';
        if(count($materias)>0){
            foreach ($materias as $key) {
                $options .= '<option value="'.$key['pen_id'].'">'.$key['nombre'].'</option>';
            }
        }
        echo $options;
    }

    /**
     * @author Edith Herrera - Grupo Satéliteo
     * @since  2018-09-28
     * @return Validación sobre existencia del nombre del alumno a registrar.
    **/
    function validar_nombre_alm(){
        satelite_validar(true);
        $nombres = $this->input->post('nombres');
        $apellidos = $this->input->post('apellidos');
        $id_alm = $this->input->post('id_alm');

        $where = array();
        if($nombres != '' && $apellidos != ''){
            $where['alm_nombre'] = trim($nombres); 
            $where['alm_apellido'] = trim($apellidos); 
        }

        if($id_alm > 0 ){
            $where['alm_id <>'] = $id_alm; 
        }

        $alumno = $this->gsatelite->get_registro('alm_alumno', $where);

        if(count($alumno)>0){
            echo 1;
        }else{
            echo 0;
        }
    }

    /**
     * Descripción:
     * Función ajax para obtener los niveles por proyeccion y docente
     * @author Edith Herrera - Grupo Satélite
     * @since  2017-11-29
     * @param  ninguno
     * @return Dropdown por proyección y docente
     */
    function ajax_proyeccion_nivel() {
        satelite_validar();

        if($this->input->post()) {
            $proyeccion = (is_numeric($this->input->post('proyeccion')))?$this->input->post('proyeccion'):'';
            $docente = (is_numeric($this->input->post('docente')))?$this->input->post('docente'):'';

            $where = array();
            if($proyeccion>0){
                $where['pyc_id']=$proyeccion;
            }

            if($docente>0){
                $where['gra_id_dct']=$docente;
            }

            $niveles = $this->registro_academico_model->get_nivel_proyeccion($where);

            $html2 = '<option value=""></option>';
            foreach ($niveles as $key => $value) {
                $html2 .= '<option value="'.$value['pen_id'].'">'.$value['mod_nombre'].'</option>';
            }
            $nivel = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $html2);
            echo $nivel;
        }
    }

    /**
     * @author Nelson Soriano
     * @since  20-07-2019
     * @param  id solicitud
     * @return confirmacion del etado de la transaccion
    * */
    public function reactivarBeca(){
        satelite_validar(true);
        $slb     = $this->input->post('slb');

        $arreglo  = array(
            'slb_estado_solicitud' => 2, 
            'slb_usu_modificacion' => $this->tank_auth->get_user_id(), 
            'slb_fecha_modificacion' => date('Y-m-d H:m:s')
        );

        $resp    = $this->gsatelite->actualizar_array('slb_solicitud_beca',$arreglo,array('slb_id' => $slb));
        if ($resp) {
            echo json_encode(array('resp' => $resp));die();
        }else{
            echo json_encode(array('resp' => 0));die();
        }
    }

    function validar_evaluaciones(){
        satelite_validar(true);

        $proyeccion = $this->input->post('proyeccion');
        $grupo = $this->input->post('grupo');
        $proyeccion_dst = $this->input->post('proyeccion_dst');
        $grupo_dst = $this->input->post('grupo_dst');
        $resp = 0; //Indicador de evaluaciones 0= se continúa con el taslado.
                   // 1 = No existen evaluaciones en el grupo de destino.
                   // 2 = La configuración de evaluaciones no coincide.

        /***************** OBTENER DATOS DEL NUEVO GRUPO HACIA DONDE SE VA A TRASLADAR **********************/
        $grupo_reg = $this->gsatelite->get_registro('gra_grupo_academico',array('gra_id'=>$grupo_dst));
        $gra_pyc_dst = (count($grupo_reg)>0)?$grupo_reg->gra_id_pyc:0;
        $gra_pen_dst = (count($grupo_reg)>0)?$grupo_reg->gra_id_pen:0;
            /////// OBTENER EVALUACIONES ASOCIADAS AL NUEVO GRUPO //////
            $evm_new = $this->gsatelite->get_tabla('evm_evaluacion_modulo', array('evm_id_pyc'=>$gra_pyc_dst, 'evm_id_pen'=>$gra_pen_dst));
        

        if(count($evm_new)>0){
            /***************** OBTENER DATOS DEL GRUPO DEL CUAL SE VA A RETIRAR *************************/
            $grupo_reg = $this->gsatelite->get_registro('gra_grupo_academico',array('gra_id'=>$grupo));
            $gra_pyc = (count($grupo_reg)>0)?$grupo_reg->gra_id_pyc:0;
            $gra_pen = (count($grupo_reg)>0)?$grupo_reg->gra_id_pen:0;
                /// OBTENER EVALUACIONES ASOCIADAS AL PENSUM Y PROYECCIÓN ///
                $evm_act = $this->gsatelite->get_tabla('evm_evaluacion_modulo', array('evm_id_pyc'=>$gra_pyc, 'evm_id_pen'=>$gra_pen));
                if(count($evm_act)==count($evm_new)){
                    $resp = 0;
                }else{
                    $resp = 2;
                }
        }else{
            $resp=1;
        }

        echo $resp;
    }

    function _cargarvista($data = 0, $crud = 0) {
        
        $this->load->view('vacia', $crud);
        if ($data != 0){
            $data = array_merge($data, $this->masterpage->getUsuario());
        } else {
            $data = $this->masterpage->getUsuario();
        }
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    /**
     * Gestión de alumnos
     * 
     * @author Nelson Soriano
     * @since  24-07-2019
     * @param  area id
     * @return grados relacionados al area en espesifico
    **/
    public function get_grados(){
        satelite_validar();
        $area = $this->input->post('area');
        $data = $this->gsatelite->get_tabla('grd_grado',array('grd_estado' => 1, 'grd_id_ard' => $area));
        $html = '<option></option>';
        foreach ($data as $key => $valor) {
            $html .= '<option value="'.$valor['grd_id'].'">'.$valor['grd_nombre'].'</option>';
           
        }
        echo json_encode(array('html' => $html));
        die();

    }

    public function get_planilla_sustituto(){
        satelite_validar();
        $tipo_planilla = $this->input->post('tipo_planilla');
        $planilla_reg = $this->gsatelite->get_tabla('pla_planilla', array('pla_id_tpl' => $tipo_planilla, 'pla_estado' => 1));
        $select = '<option value=""></option>';
        foreach ($planilla_reg as $key => $value) {
            $select .= '<option value="'.$value['pla_id'].'">'.$value['pla_fecha_inicio'].'-'.$value['pla_fecha_fin'].'</option>';
        }
        echo json_encode(array('tabla' => $select));
    }

    public function formato_sustitucion($stm_id = NULL){
        $html = "";
        $data = array();
        if($stm_id != NULL){
            $where['stm_id'] = $stm_id;
            $where['stm_estado'] = 1;            
            $data['datos'] = $this->registro_academico_model->formato_sustitucion($where);
            $html = $this->load->view('registro_academico/procesos/formato_sustitucion', $data, true);
        }
        header('Content-type: application/vnd.ms-word');
        header('Content-Disposition: attachment;Filename=formato_sustitucion.doc');
        header("Pragma: no-cache");
        header("Expires: 0");
        echo '<html>';
        echo '<meta http-equiv=\'Content-Type\' content=\'text/html; charset=Windows-1252\'>';
        echo '<body style="font-family:Arial Narrow;" >';
        echo '<meta charset="utf-8" />';
        echo '<style type="text/css"> .inicio_contrato {  font-weight: bold;  }  .parrafo {    text-align: justify;  }</style>';
        echo $html;
        echo '</body></html>'; 
    }

    public function get_datos_docente(){
        if($this->input->post()){
            $docente = $this->input->post('docente');

            $data_docente = $this->gsatelite->get_tabla('dct_docente', array('dct_id' => $docente))[0];


            $this->db->join('txe_tipo_planillaxempleado', 'tpl_id = txe_id_tpl', 'inner');
            $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', array('tpl_estado' => 1, 'txe_id_emp' => $data_docente['dct_id_emp']), null, '', 'tpl_id', true);
            $planillas_empleado = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

            $this->db->join('exd_escalafonxdocente', 'tbe_id = exd_id_tbe', 'inner');
            $select = $this->gsatelite->get_dropdown('tbe_tabla_escalafon', '{tbe_codigo}', '', array('tbe_estado' => 1, 'exd_id_dct' => $data_docente['dct_id']), null, '', 'tbe_id', true);
            $escalafon_empleado = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);


            echo json_encode(
                array(
                    'combo_tipo_planilla' => $planillas_empleado,
                    'combo_escalafon' => $escalafon_empleado
                )
            );
        }
    }

    public function getListaCuota(){
        satelite_validar();
        $lxp = $this->input->post('idlxp');
        $actual = $this->gsatelite->get_tabla('cmc_cargo_alumnoxcurso', array('cmc_estado' => 1, 'cmc_estado_cargo' => 1, 'cmc_id_lxp' => $lxp));
        if (count($actual) > 0) {
            $tlps = array_unique(array_filter(array_column($actual, "cmc_id_tlp")));
            $slctd = (count($tlps) == 1) ? $tlps[0] : null; 
            $select_tlp = $this->gsatelite->get_dropdown('tlp_tipo_lista_precio', '{tlp_nombre}', '', array("tlp_estado" => 1), $slctd, '', 'tlp_id', true);
            $select = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option></option>', $select_tlp);
            $error = 0;            
        } else {
            $error = 1;
            $select = "";
        }
        echo json_encode(array('select' => $select, 'error' => $error));
    }

    public function actualiza_lip_cmc() {
        satelite_validar();
        $lxp = $this->input->post('idlxp');
        $lip = $this->input->post('idtlp');
        $art = $this->registro_academico_model->obtener_mat_x_lxp(array('lxp_id' => $lxp));
        foreach ($art as $k => $a) {
            $where_array = array(
                "lip_id_art" => $a['mod_id_art'],
                "lip_desde <=" => 1,
                "lip_hasta >=" => 1,
                "tlp_id" => $lip
            );
                      $this->db->join("tlp_tipo_lista_precio", "tlp_id = lip_id_tlp" );
            $precio = $this->gsatelite->get_tabla("lip_listado_precio", $where_array);
            $haytpn = $this->gsatelite->get_tabla("tpn_tipo_precio_cliente", array("tpn_id_cli" => $a['id_cli'], "tpn_id_tlp" => $lip));
            $total_impuesto = 0;
            if (count($precio) > 0) {
                $nwcuo = $precio[0]["lip_precio"];
                        $this->db->join('imp_impuesto', 'imp_id = ixr_id_imp');
                $imps = $this->gsatelite->get_tabla('ixr_impuestox_tipo_articulo', array('ixr_id_tia'=>$a['id_tia'], 'ixr_estado'=>1));
                if (count($imps) > 0) {
                    foreach ($imps as $i) {
                        if($i['imp_valor'] > 0) {
                            $total_impuesto += $i['imp_valor'];
                        } else {
                            $porcentaje_impuesto = $nwcuo * ($i['imp_porcentaje'] / 100);
                            $total_impuesto += $porcentaje_impuesto;
                        }
                    }
                }
                $cuota_updt = array(
                    "cmc_id_tlp" => $lip,
                    "cmc_monto" => $nwcuo,
                    "cmc_impuestos" => $total_impuesto,
                    "cmc_observacion" => "Cambio de lista precio, el día " . date('d-m-Y'),
                    "cmc_usu_modificacion" => $this->tank_auth->get_user_id(),
                    "cmc_fecha_modificacion" => date('Y-m-d H:i:s')
                );
                $exito = $this->gsatelite->actualizar_array('cmc_cargo_alumnoxcurso', $cuota_updt, array('cmc_id_lxp' => $lxp, 'cmc_estado_cargo' => 1));
                $error = 0;
                if (count($haytpn) == 0) {
                    $tpn = array(
                        'tpn_id_cli' => $a['id_cli'],
                        'tpn_id_tlp' => $lip,
                        'tpn_estado' => 1,
                        'tpn_usu_creacion' => $this->tank_auth->get_user_id(),
                        'tpn_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'tpn_fecha_creacion' => date('Y-m-d H:i:s'),
                        'tpn_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('tpn_tipo_precio_cliente', $tpn);
                }
            } else {
                $exito = 0;
                $error = 1;//la lista no tiene ese precio
            }
        }
        echo json_encode(array('exito' => $exito, 'error' => $error));
    }

    /**
         * Obtiene sucursales permitidas.      
         * @author Francisco Orozco
         * @since  07-10-2019         
         * @return string sucursales que tiene configuradas.
    **/
    function get_sucursales(){
        $usuario        = $this->tank_auth->get_user_id();    
        $sucurales_array= $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $usuario));
        $sucursales     = array_column($sucurales_array,'usc_id_suc');            
        $sucursal_str   = 0;
        if ( count($sucursales) > 0 ) {   
            $sucursal_str .= ','.implode(",", $sucursales);             
        }             
        return $sucursal_str;
    }

}

// End of class