<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Mantenimientos extends CI_Controller {
    protected $decimal_nota = 2;

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('consultas');
        $this->load->model('registro_academico_model');
        $this->load->model('personal_model');
        $this->load->model('cotizaciones_model');
        $this->decimal_nota=2;
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function gestion_aulas() {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $crud = new grocery_CRUD();
            $crud->set_table('aul_aula')
                    ->set_subject('Aulas')
                    ->columns('aul_nombre', 'aul_ubicacion', 'aul_capacidad', 'aul_modalidad', 'aul_estado')
                    ->display_as('aul_nombre', 'Nombre')
                    ->display_as('aul_ubicacion', 'Ubicación')
                    ->display_as('aul_capacidad', 'Capacidad')
                    ->display_as('aul_modalidad', 'Modalidad')
                    ->display_as('aul_estado', 'Estado')
                    ->required_fields('aul_nombre', 'aul_estado', 'aul_capacidad')
                    ->set_rules('aul_nombre', 'Nombre', 'trim|required|campo_unico[aul_aula.aul_nombre]')
                    ->callback_column('aul_modalidad', function ($value, $row) {
                        return $value ? 'Virtual' : 'Presencial';
                    })
                    ->callback_add_field('aul_modalidad', function () {
                        return '<input type="checkbox" id="chescurlb" class="nostyle"><input type="hidden" id="field-aul_modalidad" name="aul_modalidad" value="0">';
                    })
                    ->callback_edit_field('aul_modalidad', function ($value, $primary_key) {
                        $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
                        $defecto = ($value) ? 'checked' : ''; // Verificar si esta activo
                        return '<input type="checkbox" id="chescurlb" ' . $defecto . ' class="' . $leer . ' nostyle"><input type="hidden" id="field-aul_modalidad" name="aul_modalidad" value="' . $value . '">';
                    })
                    ->field_type('aul_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('aul_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('aul_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('aul_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
            ;

            $crud->add_fields('aul_nombre', 'aul_ubicacion', 'aul_capacidad', 'aul_modalidad', 'aul_usu_crea', 'aul_usu_mod', 'aul_fecha_crea', 'aul_fecha_mod', 'aul_estado');
            $crud->edit_fields('aul_nombre', 'aul_ubicacion', 'aul_capacidad', 'aul_modalidad', 'aul_usu_mod', 'aul_fecha_mod', 'aul_estado');

            $urlx= explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('aul_estado', 'hidden', 1);
            } else {  // Editar
                $crud->field_type('aul_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $data['titulo_personal'] = "Aulas";

            $output = $crud->render();
            $this->_cargarvista($data, $output);
        }
    }

    function gestion_areas() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $siglas = $this->gsatelite->get_parametro('SYS_SIGLAS');

            $crud = new grocery_CRUD();

            $column = array(
                'ard_codigo',
                'ard_nombre', 
                'ard_descripcion', 
                'ard_id_ard_padre', 
                'ard_nota_minima',
                'ard_estado'
            );

            $display_as = array(
                'codigo_padre'=>'Código dependencia',
                'ard_id_ard_padre' => 'Dependencia',
                'ard_codigo' => 'Código',
                'ard_nombre' => 'Nombre',
                'ard_descripcion' => 'Descripción',
                'ard_id_trd' => 'Tipo de área',
                'ard_id_suc' => 'Sucursal',
                'ard_precio_hora' => 'Precio por Hora',
                'ard_minutos_hora' => 'Minutos por Hora',
                'ard_defecto_precio' => 'Predeterminado',
                'ard_nota_minima' => 'Nota mínima',
                'ard_edad_minima' => 'Edad mínima',
                'ard_edad_maxima' => 'Edad maxima',
                'ard_estado' => 'Estado'
            );

            $add_columns = array(
                'ard_id_ard_padre', 
                'ard_codigo',
                'ard_nombre', 
                'ard_descripcion', 
                'ard_id_trd',
                'ard_defecto_precio',
                'ard_id_suc',
                'ard_nota_minima',
                'ard_estado', 
                'ard_usu_crea', 
                'ard_fecha_crea', 
                'ard_usu_mod', 
                'ard_fecha_mod'
            );

            if ($siglas != 'AG') {
                $add_columns = array_merge($add_columns, array('ard_edad_minima', 'ard_edad_maxima', 'ard_precio_hora', 'ard_minutos_hora'));
            }

            $edit_columns = array(
                'ard_id_ard_padre', 
                'ard_codigo',
                'ard_nombre', 
                'ard_descripcion', 
                'ard_id_trd',
                'ard_defecto_precio',
                'ard_id_suc',
                'ard_nota_minima',
                'ard_usu_mod', 
                'ard_fecha_mod',
                'ard_estado'
            );

            if ($siglas != 'AG') {
                $edit_columns = array_merge($edit_columns, array('ard_edad_minima', 'ard_edad_maxima', 'ard_precio_hora', 'ard_minutos_hora'));
            }

            $crud->set_table('ard_area_academica');
            $crud->set_subject('Áreas');
            $crud->set_relation('ard_id_ard_padre', 'ard_area_academica', 'ard_nombre', array('ard_estado' => '1'));
            $crud->set_relation('ard_id_trd', 'trd_tipo_area_academica', 'trd_nombre', array('trd_estado' => '1'));
            $crud->set_relation('ard_id_suc', 'suc_sucursal', 'suc_nombre', array());
            $crud->columns($column);
            $crud->display_as($display_as);
            $crud->required_fields('ard_nombre', 'ard_estado');
            $crud->field_type('ard_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('ard_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('ard_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->set_rules('ard_codigo', 'Código', 'trim|required|campo_unico[ard_area_academica.ard_codigo]');
            $crud->set_rules('ard_nombre', 'Nombre', 'trim|required|campo_unico[ard_area_academica.ard_nombre]');
            $crud->set_rules('ard_nota_minima', 'Nota mínima', 'trim|is_numeric');
            $crud->set_rules('ard_edad_minima', 'Edad minima', 'trim|is_numeric');
            $crud->set_rules('ard_edad_maxima', 'Edad maxima', 'trim|is_numeric');
            $crud->unset_delete();
            $crud->field_type('ard_usu_crea', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('ard_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('ard_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('ard_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('ard_defecto_precio', 'dropdown', array(1=>'Aplicar Valor predeterminado a grupos', 0=>'No aplicar valor predeterminado a grupos'));
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->add_action('Agregar pensum', 'icomoon-icon-book-2', 'registro_academico/mantenimientos/pensum');

            // AGREGAR EL CÓDIGO SEGÚN CORRELATIVO.
            $crud->callback_column('codigo_padre', function($value, $primary_key) {
                $tabla='ard_area_academica';                
                $reg=$this->consultas->get_tabla($tabla, array('ard_id'=>$primary_key->ard_id_ard_padre));
                if(count($reg)>0){
                    $codigo = $reg[0]['ard_codigo'];
                }else{
                    $codigo = '';
                }
                return $codigo;
            });

            // AGREGAR EL CÓDIGO SEGÚN CORRELATIVO.
            $crud->callback_add_field('ard_codigo', function () {
                $tabla='ard_area_academica';
                $campo='ard_codigo';
                $last=$this->consultas->get_max_codigo($tabla,$campo);
                $code=$last->codigo;
                $cod= (int)$code+1;
                $codigo = str_pad($cod, 6, '0', STR_PAD_LEFT);
                return '<input id="field-ard_codigo" name="ard_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
            });

            //cambiamos los campos para que solo acepten numeos
            $crud->callback_add_field('ard_edad_minima', function () {
                return '<input id="field-ard_edad_minima" name="ard_edad_minima" type="text" class="span12 text todo_mayuscula soloNumeros" value="" maxlength="19,2">';
            });

            $crud->callback_edit_field('ard_edad_minima', function ($value, $primary_key) {  
                return '<input id="field-ard_edad_minima" name="ard_edad_minima" type="text" class="span12 text todo_mayuscula soloNumeros" value="'.$value.'" maxlength="19,2">';
            });

            $crud->callback_add_field('ard_edad_maxima', function () {    
                return '<input id="field-ard_edad_maxima" name="ard_edad_maxima" type="text" class="span12 text todo_mayuscula soloNumeros" value="" maxlength="19,2">';
            });

            $crud->callback_edit_field('ard_edad_maxima', function ($value, $primary_key) {
                return '<input id="field-ard_edad_maxima" name="ard_edad_maxima" type="text" class="span12 text todo_mayuscula soloNumeros" value="'.$value.'" maxlength="19,2">';
            });

            $crud->callback_field('ard_minutos_hora', function ($value, $primary_key) {
                return '<input id="field-ard_minutos_hora" name="ard_minutos_hora" type="text" class="span12 text todo_mayuscula soloNumeros" value="'.$value.'" maxlength="3,2">';
            });


            $crud->callback_edit_field('ard_codigo', function ($value, $primary_key) {
                if($value==''){
                    $tabla='ard_area_academica';
                    $campo='ard_codigo';
                    $last=$this->consultas->get_max_codigo($tabla,$campo);

                    $code=$last->codigo;
                    $cod= (int)$code+1;
                    $codigo = str_pad($cod, 6, '0', STR_PAD_LEFT);
                    return '<input id="field-ard_codigo" name="ard_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                }else{
                    return '<input id="field-ard_codigo" name="ard_codigo" type="text" maxlength="99" value="'.$value.'" >';
                }
            });

            $state = $crud->getState();
            if($state== 'success'){
                $crud->callback_field('ard_codigo', function ($value, $primary_key) {
                    if($value==''){
                        $tabla='ard_area_academica';
                        $campo='ard_codigo';
                        $last=$this->consultas->get_max_codigo($tabla,$campo);

                        $code=$last->codigo;
                        $cod= (int)$code+1;
                        $codigo = str_pad($cod, 6, '0', STR_PAD_LEFT);
                        return '<input id="field-ard_codigo" name="ard_codigo" type="text" readonly maxlength="99" value="'.$codigo.'" >';
                    }else{
                        return '<input id="field-ard_codigo" name="ard_codigo" type="text" readonly maxlength="99" value="'.$value.'" >';
                    }
                });
            }

            $urlx= explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('ard_estado', 'hidden', 1);
            } else {  // Editar
                $crud->field_type('ard_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $data['titulo_personal'] = "Áreas";

            $output = $crud->render();
            $this->_cargarvista($data, $output);
        }
    }

    /**
     * Agregar alumno
     * 
     * @author Edith Herrera
     * @since 11-11-2015
     */
    function agregar_alumno() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //All your code goes here.
            $data['genero'] = $this->gsatelite->get_tabla('gen_genero');
            // $data['pais']=$this->personal_model->get_nacionalidad();
            // $data['estado_civil']=$this->personal_model->get_estado_civil();
            // $data['profesion']=$this->personal_model->get_profesion();
            // $data['tipo_telefono']=$this->personal_model->get_tipotelefono();
            // $data['doc_documentos']=$this->personal_model->get_documentos();
            // $tipos_doc = $this->gsatelite->get_dropdown('tde_tipo_documento', '{tde_nombre}','',array('tde_estado'=>1), null, '', 'tde_id', true);
            // $data['options_tipo_documento'] = str_replace('<option value="0">Seleccione</option>', '',$tipos_doc);
            // $data['departamentos']=$this->gsatelite->get_tabla('dep_departamento');


            $data["titulo_personal"] = "Ficha del estudiante";
        }
    }

    public function datos_imagen_gral($img, $id_alm, $carpeta, $titulo_doc, $tipo = 0) {
        $extencion = end(explode(".", $img));
        $datos_1 = $this->session->keep_flashdata('datos_1');
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        /* if($extencion=='jpg' || $extencion=='jepg' || $extencion=='png'){
          $tipo=1;
          }
          else{$tipo=0;} */

        $destino = "uploads/anexos_alumno/" . $titulo_doc . "." . trim($extencion) . "";
        $array_anex_doc = array(
            'axl_id_alm' => $id_alm,
            'axl_nombre' => $titulo_doc,
            'axl_url' => $destino,
            'axl_img_perfil' => $tipo,
            'axl_estado' => 1,
            'axl_usu_mod' => $this->tank_auth->get_user_id(),
            'axl_fecha_mod' => date('Y-m-d H:i:s')
        );

        $this->db->insert("axl_anexoxalumno", $array_anex_doc);
        $carpeta_destino = "uploads/anexos_alumno/" . $titulo_doc . "." . trim($extencion) . "";

        copy($ruta, $carpeta_destino);
        unlink($ruta);
    }

    public function datos_anexo_documento($img, $carpeta, $titulo_doc) {
        $extencion = end(explode(".", $img));
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        $carpeta_destino = "uploads/anexos_alumno/" . $titulo_doc . "." . trim($extencion) . "";
        copy($ruta, $carpeta_destino);
        unlink($ruta);
    }

    function nuevo_alumno() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // print_r($_POST);
            // exit();
            $nuevo = array(
                'alm_nombre' => $this->input->post('nombres'),
                'alm_apellido' => $this->input->post('apellidos'),
                'alm_estado' => 1,
                'alm_direccion' => $this->input->post('direccion'),
                'alm_id_mun' => ($this->input->post('municipio') != "") ? $this->input->post('municipio') : null,
                'alm_id_gen' => ($this->input->post('genero') != "") ? $this->input->post('genero') : null,
                'alm_id_esc' => ($this->input->post('estado_civil') != "") ? $this->input->post('estado_civil') : null,
                'alm_id_pro' => ($this->input->post('profesion') != "") ? $this->input->post('profesion') : null,
                'alm_id_pai' => ($this->input->post('nacionalidad') != "") ? $this->input->post('nacionalidad') : null,
                'alm_fecha_nacimiento' => date('Y-m-d', strtotime($this->input->post('fecha_nacimiento'))),
                'alm_email' => ($this->input->post('correo_alumno') != "") ? $this->input->post('correo_alumno') : null,
                'alm_usu_crea' => $this->tank_auth->get_user_id(),
                'alm_usu_mod' => $this->tank_auth->get_user_id(),
                'alm_fecha_crea' => date('Y-m-d h:i:s'),
                'alm_fecha_mod' => date('Y-m-d h:i:s')
            );

            $this->db->insert('alm_alumno', $nuevo);
            $alumno_id = $this->db->insert_id();

            // Pendinte tabla en la base, para los telefonos de los alumnos.

            $array = $this->input->post('telefono');
            $ver = array_pop($array);
            $array_tit = $this->input->post('tipo_telefono');
            $tipo_tel = $this->input->post('tipo_telefono');
            $ver_tit = array_pop($array_tit);
            $i = 0;

            foreach ($array as $key => $value) {
                if (trim($value) != "") {
                    $this->db->insert('txa_telefonoxalumno', array(
                        'txa_id_tit' => $tipo_tel[$i],
                        'txa_id_alm' => $alumno_id,
                        'txa_numero' => $value,
                        'txa_estado' => 1,
                        'txa_usu_mod' => $this->tank_auth->get_user_id(),
                        'txa_fecha_mod' => date('Y-m-d H:i:s')
                    ));

                    //$tel_id = $this->db->insert_id();
                }
                $i++;
            }

            // Fin telefonos
            // Documentos del Alumno
            $array2 = $this->input->post('numero_documento');
            //$ver2= array_pop($array2);
            $array2_1 = $this->input->post('documento');
            //$ver2_1 = array_pop($array2_1);
            $array_vence_doc = $this->input->post('vence_documento');
            $array_titulo_anexo = $this->input->post('titulo_anexo_doc');
            $array_nombre_anexo = $this->input->post('nombre_anexo_doc');
            $carpeta = $this->input->post("nombre_anexo_carpeta");

            $array_fexp_doc = $this->input->post('fecha_exp_doc');
            $array_lugarexp_doc = $this->input->post('lugar_exp_doc');

            $i = 0;
            foreach ($array2 as $key => $value2) {

                $titulo_a = trim($array_titulo_anexo[$i]);
                $url_anexo = "";
                $f_vence = (trim($array_vence_doc[$i]) != "" and $array_vence_doc[$i] != null ) ? date('Y-m-d', strtotime(trim($array_vence_doc[$i]))) : null;
                $f_exp = (trim($array_fexp_doc[$i]) != "" and $array_fexp_doc[$i] != null ) ? date('Y-m-d', strtotime(trim($array_fexp_doc[$i]))) : null;
                if ($titulo_a != "") {
                    $extencion = end(explode(".", $array_nombre_anexo[$i]));
                    //$url_anexo= "uploads/anexos_empleados/".trim($array_titulo_anexo[$i]).".".trim($extencion);
                    $url_anexo = trim($array_titulo_anexo[$i]) . "." . trim($extencion); //se modifico de esta manera porque se uso grocery para su edicion.
                    $this->datos_anexo_documento(trim($array_nombre_anexo[$i]), $carpeta, $titulo_a); //funcion para guardar el anexo
                }

                $this->db->insert('dca_documento_alum', array(
                    'dca_id_tde' => $array2_1[$i],
                    'dca_id_alm' => $alumno_id,
                    'dca_valor' => $value2,
                    'dca_fecha_registro' => date('Y-m-d'),
                    'dca_fecha_vence' => $f_vence,
                    'dca_fecha_expedicion' => $f_exp,
                    'dca_lugar_expedicion' => trim($array_lugarexp_doc[$i]),
                    'dca_nombre_anexo' => $titulo_a,
                    'dca_url' => $url_anexo,
                    'dca_usu_mod' => $this->tank_auth->get_user_id(),
                    'dca_fecha_mod' => date('Y-m-d H:i:s')));
                //  $dce_id= $this->db->insert_id();
                //  $this->db->where('dce_id',$dce_id);
                //  $this->db->update('dce_documento_emp',array('dce_id_tde' => $array2_1[$i]));
                $i++;
            }

            // Comienzan los Anexos

            $rutas = $this->input->post("ruta");
            $carpeta = $this->input->post("nombreCarpeta");

            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $this->input->post("titulo_doc" . $i);
                        $this->datos_imagen_gral($img, $alumno_id, $carpeta, $titulo);
                    }
                }
            }

            if ($this->input->post('foto_empleado') != "" and $this->input->post('titulo_foto_empleado') != "") { //guardar la foto del empleado
                $titulo = $this->input->post('titulo_foto_empleado');
                $img = $this->input->post('foto_empleado');
                $this->datos_imagen_gral($img, $alumno_id, $carpeta, $titulo, 1); //es de tipo foto
            }

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de alumno", 'texto_alerta' => "El registro se guardó correctamente");

            $this->session->set_flashdata($alerta);

            redirect('registro_academico/mantenimientos/gestion_alumnos?resultado=1');
        }
    }

    function obtener_municipios() {
        if ($_POST) {
            $id_depto = $this->input->post('id');
            $tabla_mun = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', array('mun_id_dep' => $id_depto), null, '', 'mun_id', true);
            $municipios = str_replace('<option value=""></option>', '', $tabla_mun);
            $arreglo = array('drop' => $municipios);
            echo json_encode($arreglo);
        } else {
            die("Error found!!!");
        }
    }

    function tipo_grupo() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                // When you send data from the Form
                //var_dump($_POST); die();
                $tipo = $this->gsatelite->get_parametro('SYS_TIPO_ARTICULO');

                $post_array = $_POST;

                /*$array_art = array(
                    'art_id_tia' => $tipo,
                    'art_nombre' => $post_array['nombre'],
                    'art_descripcion' => ($post_array['descripcion']) ? $post_array['descripcion'] : null,
                    'art_fecha' => date('Y-m-d H:i:s'),
                    'art_tipo' => 1,
                    'art_combo' => 0,
                    'art_compra' => 0,
                    'art_inventario' => 0,
                    'art_venta' => 1,
                    'art_materia_prima' => 0,
                    'art_gasto' => 1,
                    'art_costo' => 1,
                    'art_estado' => 1,
                    'art_usu_creacion' => $this->tank_auth->get_user_id(),
                    'art_fecha_creacion' => date('Y-m-d H:i:s'),
                    'art_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'art_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $art_id = $this->gsatelite->ingresar('art_articulo', $array_art);

                //Se agrega la conversion del articulo
                $unidad_defecto = $this->gsatelite->get_parametro('SYS_UNIDAD_MEDIDA');

                $conversion_array = array(
                    'cva_id_mep' => $unidad_defecto,
                    'cva_id_art' => $art_id,
                    'cva_conversion' => 1,
                    'cva_defecto' => 1,
                    'cva_estado' => 1,
                    'cva_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'cva_fecha_modificacion' => date('Y-m-d H:i:s'),
                    'cva_usu_creacion' => $this->tank_auth->get_user_id(),
                    'cva_fecha_creacion' => date('Y-m-d H:i:s'),
                );
                $this->gsatelite->ingresar('cva_conversion_articulo', $conversion_array);*/

                $hg_id = $post_array['horario'];
                $unidades = $post_array['unidades'];
                $grupos_academicos = array(
                    'gra_id_aul' => (!is_numeric($_POST['aula'])) ? NULL : $_POST['aula'],
                    'gra_id_dct' => (!is_numeric($_POST['docente'])) ? NULL : $_POST['docente'],
                    'gra_id_pen' => ($_POST['pensum'] > 0) ? $_POST['pensum'] : NULL,
                    'gra_id_hrg' => ($this->input->post('horario') != '') ? $this->input->post('horario') : null,
                    //'gra_id_art' => $art_id,
                    //'gra_horario' =>  $horario,
                    'gra_nombre' => $this->input->post('nombre'),
                    'gra_fecha_inicio' => date('Y-m-d', strtotime($this->input->post('fecha_inicio'))),
                    'gra_fecha_fin' => date('Y-m-d', strtotime($this->input->post('fecha_fin'))),
                    'gra_descripcion' => ($this->input->post('descripcion') != '') ? $this->input->post('descripcion') : null,
                    'gra_cupo' => $this->input->post('cupo'),
                    'gra_estado' => 1,
                    'gra_usu_crea' => $this->tank_auth->get_user_id(),
                    'gra_usu_mod' => $this->tank_auth->get_user_id(),
                    'gra_fecha_crea' => date('Y-m-d H:i:s'),
                    'gra_fecha_mod' => date('Y-m-d H:i:s'),
                    'gra_fecha_peruno' => date('Y-m-d', strtotime($this->input->post('fecha_nota_uno'))),
                    'gra_fecha_perdos' => date('Y-m-d', strtotime($this->input->post('fecha_nota_dos'))),
                );

                $registro = $this->gsatelite->ingresar('gra_grupo_academico', $grupos_academicos);
                $id_gra = $this->registro_academico_model->get_ultimo_id();

                foreach ($unidades as $id) {
                    $info = array(
                        'uxg_id_gra' => $id_gra[0]['id_gra'],
                        'uxg_id_unm' => $id,
                        'uxg_estado' => 1,
                        'uxg_usu_creacion' => $this->tank_auth->get_user_id(),
                        'uxg_fecha_creacion' => date('Y-m-d H:i:s'),
                        'uxg_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'uxg_fecha_modificacion' => date('Y-m-d H:i:s'),
                    );
                    $this->gsatelite->ingresar('uxg_uni_grupo', $info);
                }

                if ($registro > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información ingresada.");
                }
                $this->session->set_flashdata($alerta);
                $boton = $this->input->post('direccion');
                if ($boton == 1) {
                    redirect('registro_academico/mantenimientos/tipo_grupo');
                } else if ($boton == 2) {
                    redirect('registro_academico/mantenimientos/gestion_grupos');
                }
            } else {
                // Las carreras cargaran los niveles, y los niveles cargaran los modulos.
                $programas = $this->gsatelite->get_dropdown('prg_programa_estudio', '{prg_nombre}', '', array('prg_estado' => '1'), null, '', 'prg_id', true);
                $data["programas"] = str_replace('<option value=""></option>', '', $programas);

                //$programas = $this->gsatelite->get_dropdown('nva_nivel_area_academ', '{nva_nombre}','','', null, '', 'nva_id', true);
                $data["niveles"] = str_replace('<option value=""></option>', '', $programas);

                $programas = $this->gsatelite->get_dropdown('mod_modulo', '{mod_nombre}', '', array('mod_estado' => '1'), null, '', 'mod_id', true);

                $aulas = $this->gsatelite->get_dropdown('aul_aula', '{aul_nombre}', '', array('aul_estado' => '1'), null, '', 'aul_id', true);
                $data["aulas"] = str_replace('<option value=""></option>', '', $aulas);

                $data["docentes"] = $this->registro_academico_model->obtener_docentes(array('dct_estado' => '1'));

                $programas = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => '1'), null, '', 'ard_id', true);
                $data["modulos"] = str_replace('<option value=""></option>', '', $programas);
                $data["areas"] = str_replace('<option value=""></option>', '', $programas);

                $horario = $this->gsatelite->get_tabla('hrg_horario_grupo', array('hrg_estado' => 1));
                // $horarios=$this->gsatelite->get_dropdown('hrg_horario_grupo', '{hrg_inicio} - {hrg_fin} {hrg_observacion}','', array('hrg_estado'=>1), null, '', 'hrg_id', true);
                $hora = '<option value=""></option>';
                foreach ($horario as $key) {
                    $hora_inicio = date("h:i A", strtotime($key['hrg_inicio']));
                    $hora_fin = date("h:i A", strtotime($key['hrg_fin']));

                    $hora .= '<option value="' . $key['hrg_id'] . '">' . $hora_inicio . ' - ' . $hora_fin . ' ' . $key['hrg_observacion'] . '</option>';
                }
                $data["horarios"] = $hora;

                //$docentes = $this->gsatelite->get_dropdown('dct_docente', '{dct_nombre}  {dct_apellido}','', array('dct_estado' => '1'), null, '', 'dct_id', true);

                $data["titulo_personal"] = "Grupos académicos";
                $this->_cargarvista($data);
            }
        }
    }

    public function cargar_unidades() {
        $pen = $this->input->post('nivel');
        $mod_id = $this->gsatelite->get_campo('pen_pensum', 'pen_id_mod', array('pen_id' => $pen));
        $unidades = $this->registro_academico_model->unidades_modulo($mod_id);
        //  print_r($this->db->last_query());
        $opciones = '';
        foreach ($unidades as $key) {
            $opciones .= '<option selected="selected" value="' . $key['unm_id'] . '"> ' . $key['unm_nombre'] . '</option>';
        }
        echo json_encode(array('opc' => $opciones));
    }

    function cargar_niveles() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //$id_carrera = $this->input->post('id');
            $id_programa = $this->input->post('id');
            ;
            $nivel_id = $this->input->post('nivel');
            $id_select = '';
            if (isset($nivel_id)) {
                $id_select = $nivel_id;
            }
            //$id_programa = 6;
            //$niveles = $this->gsatelite->get_dropdown('niv_nivel', '{niv_nombre}','', array('niv_id_prg'=>$id_carrera,'niv_estado' => '1'), $id_select, '', 'niv_id', true);
            $where_nva = array('prg_programa_estudio.prg_id' => $id_programa);
            $niveles = $this->registro_academico_model->obtener_nva_x_programa($where_nva);
            $data['niveles'] = $niveles;
            //$data["niveles"] = str_replace('<option value=""></option>', '',$niveles);
            echo $data['niveles'];
        }
    }

    function cargar_modulos() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id_nivel = $this->input->post('id');
            $id_modulo = $this->input->post('modulo');
            $id_select = '';
            if (isset($id_modulo)) {
                $id_select = $id_modulo;
            }

            $where_md = array('nva_nivel_area_academ.nva_id' => $id_nivel);
            $modulos = $this->registro_academico_model->obtener_modulos_x_nva($where_md);
            $data['modulos'] = $modulos;
            echo $data['modulos'];
        }
    }

    function cargar_pensum($area=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($area!=null){
                $id_area = $area;
                $where_md = array('ard_area_academica.ard_id' => $id_area);
                $pensum = $this->registro_academico_model->obtener_pensum_x_ard($where_md);
                return $pensum;
            }else{
                $id_area = $this->input->post('id');
                $id_alm = $this->input->post('alumno');
                $examen = $this->input->post('examen');

                $where= array();
                if($id_area!=''){
                    $where['lxa_id_ard'] = $id_area;
                }
                
                $no_incluir= array();
                if($id_alm!=''){
                    $where['lxa_id_alm'] = $id_alm;
                    $registrados = $this->registro_academico_model->pensumxalumno_inscrito($where);
                    if(count($registrados)>0){
                        foreach ($registrados as $reg) {
                            $no_incluir[] = $reg['pen_id'];
                        }
                    }
                }
             
                $where_md = array('ard_area_academica.ard_id' => $id_area);
                $pensum = $this->registro_academico_model->obtener_pensum_x_ard($where_md, null, $no_incluir);
            
                $data['pensum'] = $pensum;
                echo $data['pensum'];
            }
        }
    }

    function validar_docente() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $hora = $this->input->post('hora');
            $aula = $this->input->post('aula');
            $docente = $this->input->post('docente');

            $fecha_ini = (trim($this->input->post('fecha_ini')) != '') ? date('Y-m-d', strtotime($this->input->post('fecha_ini'))) : '';
            $fecha_fin = (trim($this->input->post('fecha_fin')) != '') ? date('Y-m-d', strtotime($this->input->post('fecha_fin'))) : '';

            $id_aula = $this->input->post('id_aula');
            $id_doce = $this->input->post('id_doce');
            $id_hora = $this->input->post('id_hora');

            //print_r($_POST); die();
            $resp = 0;
            $resp2 = 0;
            $resp3 = 0;
            $resp4 = 0;
            if ($fecha_ini == '' or $fecha_fin == '') {
                $resp4 = 1;
            }
            if ($resp4 <= 0) {
                $grupos = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_fecha_inicio >=' => $fecha_ini, 'gra_fecha_fin <=' => $fecha_fin, 'gra_id_aul' => $aula, 'gra_id_hg' => $hora));
                //print_r($this->db->last_query()); die();
                //die(print_r($grupos));
                foreach ($grupos as $grd) {

                    if ($hora == $grd['gra_id_hg'] && $docente == $grd['gra_id_dct']) {
                        $resp3 = $resp3 + 1;
                    }
                    if ($hora == $grd['gra_id_hg'] && $aula == $grd['gra_id_aul']) {
                        $resp2 = $resp2 + 1;
                    }
                    if ($hora == $grd['gra_id_hg'] && $docente == $grd['gra_id_dct'] && $aula == $grd['gra_id_aul']) {
                        $resp = $resp + 1;
                    } else {
                        
                    }
                }
            } else {
                echo json_encode(array('resp' => $resp, 'resp2' => $resp2, 'resp3' => $resp3, 'resp4' => $resp4));
            }
            if ($id_aula == $aula && $id_doce == $docente && $id_hora == $hora && $resp == 1 && $resp2 == 1 && $resp3 == 1) {
                echo json_encode(array('resp' => 0, 'resp2' => 0, 'resp3' => 0, 'resp4' => 0));
                die();
            }
            echo json_encode(array('resp' => $resp, 'resp2' => $resp2, 'resp3' => $resp3, 'resp4' => $resp4));
        }
    }

    function validar_docente_act() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $hora = $this->input->post('hora');
            $aula = $this->input->post('aula');
            $docente = $this->input->post('docente');
            $grupos = $this->gsatelite->get_tabla('gra_grupo_academico');

            foreach ($grupos as $grd) {
                if ($hora == $grd['gra_id_hg'] && $docente == $grd['gra_id_dct'] && $aula == $grd['gra_id_aul']) {
                    echo json_encode(array('resp' => 1));
                    die();
                } else {
                    
                }
            }
        }
    }

    function tipo_grupo_edit($id_grupo = NULL) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                //die(var_dump($_POST));

                $hg_id = $this->input->post('horario');

                $grupo_editado = array(
                    'gra_nombre' => $this->input->post('nombre'),
                    'gra_id_pen' => ($_POST['pensum'] > 0) ? $_POST['pensum'] : NULL,
                    'gra_fecha_inicio' => date('Y-m-d', strtotime($this->input->post('fecha_inicio'))),
                    'gra_fecha_fin' => date('Y-m-d', strtotime($this->input->post('fecha_fin'))),
                    'gra_id_aul' => ($_POST['aula'] > 0) ? $_POST['aula'] : NULL,
                    'gra_id_dct' => ($_POST['docente'] > 0) ? $_POST['docente'] : NULL,
                    'gra_id_hrg' => ($this->input->post('horario') != '') ? $this->input->post('horario') : null,
                    'gra_descripcion' => ($this->input->post('descripcion') != '') ? $this->input->post('descripcion') : null,
                    'gra_cupo' => $this->input->post('cupo'),
                    'gra_estado' => $this->input->post('estado'),
                    'gra_usu_mod' => $this->tank_auth->get_user_id(),
                    'gra_fecha_mod' => date('Y-m-d H:i:s'),
                    'gra_fecha_peruno' => date('Y-m-d', strtotime($this->input->post('fecha_nota_uno'))),
                    'gra_fecha_perdos' => date('Y-m-d', strtotime($this->input->post('fecha_nota_dos'))),
                );

                $registro = $this->gsatelite->actualizar_array('gra_grupo_academico', $grupo_editado, array('gra_id' => $id_grupo));
                $uni = $this->gsatelite->get_parametro('SYS_UNIDAD_MEDIDA');
                $tipo = $this->gsatelite->get_parametro('SYS_TIPO_ARTICULO');
                $art_id = $this->gsatelite->get_campo('gra_grupo_academico', 'gra_id_art', array('gra_id' => $id_grupo));
                $array_art = array(
                    'art_id_tia' => $tipo,
                    'art_nombre' => $this->input->post('nombre'),
                    'art_descripcion' => ($this->input->post('descripcion')) ? $this->input->post('descripcion') : null,
                    'art_fecha' => date('Y-m-d H:i:s'),
                    'art_tipo' => 1,
                    'art_combo' => 0,
                    'art_compra' => 0,
                    'art_inventario' => 0,
                    'art_venta' => 1,
                    'art_materia_prima' => 0,
                    'art_gasto' => 1,
                    'art_costo' => 1,
                    'art_estado' => $this->input->post('estado'),
                    'art_usu_creacion' => $this->tank_auth->get_user_id(),
                    'art_fecha_creacion' => date('Y-m-d H:i:s'),
                    'art_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'art_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $art_id = $this->gsatelite->actualizar_array('art_articulo', $array_art, array('art_id' => $art_id));

                $unidades = $this->input->post('unidades');
                $this->gsatelite->borrado_general('uxg_uni_grupo', array('uxg_id_gra' => $id_grupo));
                foreach ($unidades as $id) {
                    $info = array(
                        'uxg_id_gra' => $id_grupo,
                        'uxg_id_unm' => $id,
                        'uxg_estado' => 1,
                        'uxg_usu_creacion' => $this->tank_auth->get_user_id(),
                        'uxg_fecha_creacion' => date('Y-m-d H:i:s'),
                        'uxg_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'uxg_fecha_modificacion' => date('Y-m-d H:i:s'),
                    );
                    $this->gsatelite->ingresar('uxg_uni_grupo', $info);
                }



                if ($registro > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro actualizado", 'texto_alerta' => "El registro se ha actualizado correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no actualizado", 'texto_alerta' => "El registro no pudo ser actualizado, verifique la información ingresada.");
                }

                $this->session->set_flashdata($alerta);
                $btn = $this->input->post('direccion');
                if ($btn == 1) {
                    redirect('registro_academico/mantenimientos/tipo_grupo_edit/' . $id_grupo);
                } else if ($btn == 2) {
                    redirect('registro_academico/mantenimientos/gestion_grupos');
                }
            } else {
                $data['registro'] = $this->registro_academico_model->obtener_grupos(array('gra_id' => $id_grupo));
                // Las carreras cargaran los niveles, y los niveles cargaran los modulos.

                /* if(isset($data['registro'][0]["gra_id_mod"])){
                  $where_programa = array("mod_modulo.mod_id"=>$data['registro'][0]["gra_id_mod"]);
                  $prg_id = $this->registro_academico_model->obtener_programa_x_modulo($where_programa);

                  $programas = $this->gsatelite->get_dropdown('prg_programa_estudio', '{prg_nombre}','', array('prg_estado' => '1'), $prg_id, '', 'prg_id', true);
                  $data["programas"] = str_replace('<option value=""></option>', '',$programas);

                  $where_nva = array("mod_modulo.mod_id"=>$data['registro'][0]["mod_id"],'prg_programa_estudio.prg_id'=>$prg_id);
                  $nva_id = $this->registro_academico_model->obtener_nva_x_modulo($where_nva);

                  $where_nva = array('prg_programa_estudio.prg_id'=>$prg_id);
                  $niveles = $this->registro_academico_model->obtener_nva_x_programa($where_nva);
                  $data['niveles'] = $niveles;

                  $where_mod = array('nva_nivel_area_academ.nva_id'=>$nva_id);
                  $modulos = $this->registro_academico_model->obtener_modulos_x_nva($where_mod);
                  $data['modulos']=$modulos;

                  $data['prg_id']= $prg_id;
                  $data['nva_id']= $nva_id;
                  $data['mod_id']= $data['registro'][0]["mod_id"];
                  } */
                if (isset($data['registro'][0]["gra_id_pen"])) {
                    $where_programa = array("pen_pensum.pen_id" => $data['registro'][0]["gra_id_pen"]);
                    $ard_id = $this->registro_academico_model->obtener_ard_x_pensum($where_programa);


                    //var_dump($where_md);

                    $data['ard_id'] = $ard_id[0]['ard_id'];
                    $data['pen_id'] = $data['registro'][0]["gra_id_pen"];
                    //$data['mod_id']= $data['registro'][0]["gra_id_pen"];
                } else {
                    $programas = $this->gsatelite->get_dropdown('prg_programa_estudio', '{prg_nombre}', '', array('prg_estado' => '1'), '', '', 'prg_id', true);
                    $data["programas"] = str_replace('<option value=""></option>', '', $programas);
                }

                $where_md = array('ard_area_academica.ard_id' => $ard_id[0]['ard_id']);
                $pensum = $this->registro_academico_model->obtener_pensum_x_ard($where_md, null);
                $data['pensum'] = $pensum;

                //die(print_r($data['registro'][0]));
                $programas = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => '1'), $data['registro'][0]['ard_id'], '', 'ard_id', true);
                $data['id_hora'] = '<input type="hidden" name="id_hora" id="id_hora" value="' . $data['registro'][0]['hg_id'] . '" />';

                $horario = $this->gsatelite->get_tabla('hrg_horario_grupo');

                $hora = '<option value=""></option>';
                foreach ($horario as $key) {
                    $hora_inicio = date("h:i A", strtotime($key['hrg_inicio']));
                    $hora_fin = date("h:i A", strtotime($key['hrg_fin']));

                    if ($data['registro'][0]['hrg_id'] == $key['hrg_id']) {
                        $hora .= '<option value="' . $key['hrg_id'] . '" selected>' . $hora_inicio . ' - ' . $hora_fin . ' ' . $key['hrg_observacion'] . '</option>';
                    } else {
                        $hora .= '<option value="' . $key['hrg_id'] . '">' . $hora_inicio . ' - ' . $hora_fin . ' ' . $key['hrg_observacion'] . '</option>';
                    }
                }
                $data["horarios"] = $hora;

                $data["areas"] = str_replace('<option value=""></option>', '', $programas);

                $aulas = $this->gsatelite->get_dropdown('aul_aula', '{aul_nombre}', '', array('aul_estado' => '1'), $data['registro'][0]['aul_id'], '', 'aul_id', true);
                $data['id_aula'] = '<input type="hidden" name="id_aula" id="id_aula" value="' . $data['registro'][0]['aul_id'] . '" />';
                $data["aulas"] = str_replace('<option value=""></option>', '', $aulas);

                $data['unidades'] = $this->registro_academico_model->unidades_grupo($id_grupo);
                $data['uni_grupo'] = $this->registro_academico_model->cargarUnidades_grupo($id_grupo);

                // die(print_r($data['unidades']));
                // die(print_r($this->db->last_query()));
                $this->db->join('emp_empleado', 'emp_id=dct_id_emp');
                $doc = $this->gsatelite->get_tabla('dct_docente', array('dct_estado' => 1));

                // $docentes = $this->gsatelite->get_dropdown('dct_docente', '{dct_nombre}  {dct_apellido}','', array('dct_estado' => '1'), $data['registro'][0]['dct_id'], $doc, 'dct_id', true);
                $docentes = '<option value=""></option>';
                foreach ($doc as $key => $emp) {
                    if ($emp['dct_id'] == $data['registro'][0]['dct_id']) {
                        $select = "selected";
                        $data["id_doce"] = ' <input type="hidden" name="id_doce" id="id_doce" value="' . $data['registro'][0]['dct_id'] . '" /> ';
                    } else {
                        $select = "";
                    }

                    $docentes .= '<option value="' . $emp['dct_id'] . '"  ' . $select . '>' . $emp['emp_nombre'] . ' ' . $emp['emp_apellido'] . '</option>';
                }
                $data["docentes"] = $docentes;

                $data["titulo_personal"] = "Grupos académicos";
                $this->_cargarvista($data);
            }
        }
    }

    function tipo_grupo_delete($id_grupo = NULL) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
          
            $gra = $this->gsatelite->get_campo('lxp_alumnoxpensum', 'lxp_id_gra', array('lxp_id_gra' => $id_grupo));
            if ($gra <= 0 || $gra == '') {
                $registro_uxg = $this->gsatelite->borrado_general('uxg_uni_grupo', array('uxg_id_gra' => $id_grupo));
                if($registro_uxg > 0){
                    $registro = $this->gsatelite->borrado_general('gra_grupo_academico', array('gra_id' => $id_grupo));
                    if ($registro > 0) {
                        $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro borrado", 'texto_alerta' => "El registro se ha borrado correctamente.");
                    }
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "NOTA", 'texto_alerta' => "El registro posee integridad referencial <br />&nbsp;No podrá ser eliminado.");
            }

            $this->session->set_flashdata($alerta);
            redirect('registro_academico/mantenimientos/gestion_grupos');
        }
    }

    function gestion_grupos() {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $area = $this->input->post('area');
                $nivel = $this->input->post('nivel');
                $horario = $this->input->post('horario');
                $fecha = $this->input->post('fecha');

                $where = array();
                if ($area != '') {
                    $where['ard_id'] = $area;
                }
                if ($nivel != '') {
                    $where['mod_id'] = $nivel;
                }
                if ($horario != '') {
                    $where['hrg_id'] = $horario;
                }
                if ($fecha != '') {
                    $where['gra_fecha_inicio'] = $fecha;
                }
                //die(print_r($where));
                $data['grupos'] = $this->registro_academico_model->obtener_grupos($where);
                $html = $this->load->view('registro_academico/mantenimientos/detalle_grupos', $data, true);
                echo $html;
            } else {

                $data['grupos'] = $this->registro_academico_model->obtener_grupos();
                $select = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1), null, '', 'ard_id', true);
                $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

                $select = $this->gsatelite->get_dropdown('mod_modulo', '{mod_nombre}', '', array('mod_estado' => 1), null, '', 'mod_id', true);
                $data["nivel"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

                $horario = $this->registro_academico_model->get_horario_order(array('hrg_estado' => 1));
                $hora = '<option value=""></option>';
                foreach ($horario as $key) {
                    $hora_inicio = date("h:i A", strtotime($key['hrg_inicio']));
                    $hora_fin = date("h:i A", strtotime($key['hrg_fin']));

                    $hora .= '<option value="' . $key['hrg_id'] . '">' . $hora_inicio . ' - ' . $hora_fin . '</option>';
                }
                //$select = $this->gsatelite->get_dropdown('hrg_horario_grupo', '{DATE_FORMAT(hrg_inicio,"%h:%i %p")} - {DATE_FORMAT(hrg_fin,"%h:%i %p")}', '', array('hrg_estado'=> 1), null, '', 'hrg_id', true);
                $data["horario"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $hora);

                $data['titulo_personal'] = "Grupos Académicos";

                $this->_cargarvista($data);
            }
        }
    }

    function gestion_modulos() {
        satelite_validar();
        try {
            $crud = new grocery_CRUD();
            $columnas = array(
                'mod_codigo',
                'mod_nombre',
                'mod_descripcion',
                'mod_id_art',
                'mod_estado'
            );

            $alias = array(
                'mod_codigo' => 'Código', 
                'mod_nombre' => 'Nivel / Curso / Materia',
                'mod_descripcion' => 'Descripción',
                'mod_id_art' => 'Categoría',
                'mod_estado' => 'Estado',
            );

            $columnas_insert = array(
                'mod_codigo',
                'mod_nombre',
                'mod_descripcion',
                'mod_id_art',
                'mod_estado',
                'mod_usu_crea',
                'mod_fecha_crea',
                'mod_usu_mod',
                'mod_fecha_mod'
            );

            $columnas_update = array(
                'mod_codigo',
                'mod_nombre',
                'mod_descripcion',
                'mod_id_art',
                'mod_estado',
                'mod_usu_mod',
                'mod_fecha_mod'
            );

            $crud->set_table('mod_modulo')
                    ->set_subject('')
                    ->columns($columnas)
                    ->display_as($alias)
                    //->add_fields($columnas_insert)
                    //->edit_fields($columnas_update)
                    ->field_type('mod_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('mod_fecha_mod', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('mod_fecha_crea', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('mod_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                    ->required_fields('mod_nombre', 'mod_estado')
                    ->set_rules('mod_codigo', 'Código', 'trim|required|campo_unico[mod_modulo.mod_codigo]')
                    ->set_rules('mod_nombre', 'Nombre', 'trim|required|campo_unico[mod_modulo.mod_nombre]')
                    ->unset_edit()
                    ->add_action('Contenido', 'icon16 icomoon-icon-book', 'registro_academico/mantenimientos/contenido_certificados')
                    ->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'registro_academico/mantenimientos/editar_modulo')
            // ->callback_before_delete(function($post_array,$primary_key){
            //     $fila = $this->gsatelite->get_registro('mod_modulo','mod_id',$post_array);
            //     $id=$fila->mod_id_art;
            //    // $this->gsatelite->borrado_general('art_articulo', array('art_id'=>$id));
            //    if($id>0 || $id != '' || $id != null){
            //        return false;
            //    }else{
            //        return true;
            //    }
            // })
            ;



             /*   // AGREGAR EL CÓDIGO SEGÚN CORRELATIVO.
                $crud->callback_add_field('mod_codigo', function () {
                    $tabla='mod_modulo';
                    $campo='mod_codigo';
                    $last=$this->consultas->get_max_codigo($tabla,$campo);

                    $code=$last->codigo;
                    $cod= (int)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

                    return '<input id="field-mod_codigo" name="mod_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                });

                $crud->callback_edit_field('mod_codigo', function ($value, $primary_key) {
                    if($value==''){
                      $tabla='mod_modulo';
                      $campo='mod_codigo';
                      $last=$this->consultas->get_max_codigo($tabla,$campo);

                      $code=$last->codigo;
                      $cod= (int)$code+1;
                      $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                      return '<input id="field-mod_codigo" name="mod_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                    }else{
                       return '<input id="field-mod_codigo" name="mod_codigo" type="text" maxlength="99" value="'.$value.'" >';
                    }
                });

                $state = $crud->getState();
                if($state== 'success'){
                    $crud->callback_field('mod_codigo', function ($value, $primary_key) {
                        if($value==''){
                          $tabla='mod_modulo';
                          $campo='mod_codigo';
                          $last=$this->consultas->get_max_codigo($tabla,$campo);

                          $code=$last->codigo;
                          $cod= (int)$code+1;
                          $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                          return '<input id="field-mod_codigo" name="mod_codigo" type="text" readonly maxlength="99" value="'.$codigo.'" >';
                        }else{
                           return '<input id="field-mod_codigo" name="mod_codigo" type="text" readonly maxlength="99" value="'.$value.'" >';
                        }
                    });
                }*/

            $crud->add_action('&nbsp;&nbsp;Desactivar', '', 'registro_academico/mantenimientos/baja_servicio/', 'desactivarx icomoon-icon-blocked',null,null,array('mod_estado' =>'Activo'));
            $urlx= explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('mod_estado', 'hidden', 1);
            } else {
                $crud->field_type('mod_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            $crud->field_type('mod_id_art', 'dropdown', $this->get_categoria());

            $output = $crud->render();
            $data['titulo_personal'] = "Nivel / Curso / Materia";

            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function baja_servicio(){
        satelite_validar();
        $resp =  array('resp' => 0);
        $id =(int) $this->input->post('serv');
        $ob = $this->input->post('ob'); 
        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al Procesar", 'texto_alerta' => "No pudimos procesar este registro, intenta nuevamente.");
        if (is_numeric($id)) {
            $info     = $this->gsatelite->get_tabla('mod_modulo',array('mod_id' => $id));
            $articulo = $this->gsatelite->get_tabla('art_articulo',array('art_id'=>$info[0]['mod_id_art']));
            $this->gsatelite->actualizar_array('art_articulo',array('art_estado' => 0),array('art_id' =>$articulo[0]['art_id']));
            $this->gsatelite->actualizar_array('mod_modulo',array('mod_estado' => 0,'mod_observacion' => $ob),array('mod_id' =>$id));
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Desactivacion exitosa", 'texto_alerta' => "El servicio seleccionado fue desactivado.");
            $resp = array('resp' => 1);
        }
        $this->session->set_flashdata($alerta);
        echo json_encode($resp);
        die();
    }

    function get_categoria(){
        $this->db->join('tia_tipo_articulo','tia_id = art_id_tia');
        $cat_reg = $this->gsatelite->get_tabla('art_articulo',array('art_estado'=>1));
        $regresar = array();
        foreach ($cat_reg as $key) {
            $regresar[$key['art_id']] = $key['tia_nombre'];
        }
        return $regresar;
    }

    function agregar_prerrequisito($registro, $pre_id_mod_actual) {
        $requisito = array(
            'pre_id_mod_actual' => $registro,
            'pre_id_mod_requisito' => $pre_id_mod_actual,
            'pre_estado' => 1,
            'pre_usu_crea' => $this->tank_auth->get_user_id(),
            'pre_usu_mod' => $this->tank_auth->get_user_id(),
            'pre_fecha_crea' => date('Y-m-d H:i:s'),
            'pre_fecha_mod' => date('Y-m-d H:i:s')
        );

        $requisito = $this->gsatelite->ingresar('pre_prerrequisito', $requisito);
        return $requisito;
    }

    function tipo_modulo() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            if ($_POST) {
                // When you send data from the Form
                $modulos = array(
                    'mod_nombre' => $_POST['nombre'],
                    //'mod_id_niv' => (!is_numeric($_POST['nivel'])) ? NULL : $_POST['nivel'],
                    'mod_descripcion' => $_POST['descripcion'],
                    'mod_estado' => 1,
                    'mod_usu_crea' => $this->tank_auth->get_user_id(),
                    'mod_usu_mod' => $this->tank_auth->get_user_id(),
                    'mod_fecha_crea' => date('Y-m-d H:i:s'),
                    'mod_fecha_mod' => date('Y-m-d H:i:s')
                );

                $registro = $this->gsatelite->ingresar('mod_modulo', $modulos);

                $this->session->set_flashdata($alerta);
                redirect('registro_academico/mantenimientos/gestion_modulos');
            } else {
                // Las carreras cargaran los niveles, y los niveles cargaran los prerrequisitos.
                $programas = $this->gsatelite->get_dropdown('prg_programa_estudio', '{prg_nombre}', '', array('prg_estado' => '1'), null, '', 'prg_id', true);
                $data["programas"] = str_replace('<option value=""></option>', '', $programas);

                $data["titulo_personal"] = "Agregar módulo";
                $this->_cargarvista($data);
            }
        }
    }

    function tipo_modulo_edit($id_modulo = NULL) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {

                $modulo_editado = array(
                    'mod_nombre' => $this->input->post('nombre'),
                    'mod_descripcion' => $this->input->post('descripcion'),
                    'mod_estado' => $this->input->post('estado'),
                    'mod_usu_mod' => $this->tank_auth->get_user_id(),
                    'mod_fecha_mod' => date('Y-m-d H:i:s')
                );

                $registro = $this->gsatelite->actualizar_array('mod_modulo', $modulo_editado, array('mod_id' => $id_modulo));


                if ($registro > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro actualizado", 'texto_alerta' => "El registro se ha actualizado correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no actualizado", 'texto_alerta' => "El registro no pudo ser actualizado, verifique la información ingresada.");
                }

                $this->session->set_flashdata($alerta);
                redirect('registro_academico/mantenimientos/gestion_modulos');
            } else {
                // primero obtengo el registro, y la tabla de prerrequisitos
                $data['modulos'] = $this->registro_academico_model->obtener_modulos(array('mod_id' => $id_modulo));
                $data['requisitos'] = $this->registro_academico_model->obtener_requisitos(array('pre_id_mod_actual' => $id_modulo, 'pre_estado' => 1));
                $id_nivel = $data['modulos'][0]['niv_id'];
                $req_id = array();

                foreach ($data['requisitos'] as $key => $value) {
                    foreach ($value as $key2 => $value2) {
                        $req_id[] = $value2;
                    }
                }


                //print_r($data['requisitos']); die();
                // Las carreras cargaran los niveles, y los niveles cargaran los prerrequisitos.
                $programas = $this->gsatelite->get_dropdown('prg_programa_estudio', '{prg_nombre}', '', array('prg_estado' => '1'), $data['modulos'][0]['prg_id'], '', 'prg_id', true);
                $data["programas"] = str_replace('<option value=""></option>', '', $programas);

                //$pre_req = $this->gsatelite->get_dropdown('mod_modulo', '{mod_nombre}','', array('mod_id_niv'=>$id_nivel,'mod_estado' => '1'), $req_id, '', 'mod_id', true);
                $data["pre_req"] = str_replace('<option value=""></option>', '', $pre_req);

                $data["titulo_personal"] = "Editar módulo";
                $this->_cargarvista($data);
            }
        }
    }

    function tipo_modulo_delete($id_modulo = NULL) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // Your code goes here.
            $registro = $this->gsatelite->borrado_general('mod_modulo', array('mod_id' => $id_modulo));

            if ($registro > 0) {
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro borrado", 'texto_alerta' => "El registro se ha borrado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser borrado, verifique la información ingresada.");
            }

            $this->session->set_flashdata($alerta);
            redirect('registro_academico/mantenimientos/gestion_modulos');
        }
    }

    /**
     * @author CHRISTIAN MENENDEZ
     * @return Agrega las materias en el pensum segun el area
     * @modified: 2018-03-03 - Edith Herrera
     **/

    public function pensum($id_area = 0) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('gestion_areas');

        $pensums = $this->gsatelite->get_tabla('pen_pensum', array('pen_id_ard' =>$id_area));
        
        $selected = '0';
        if(count($pensums)>0){
            $selected = implode(',', array_column($pensums, "pen_id_mod"));
        }

        try {
            $crud = new grocery_CRUD();

            $columnas = array(
                'codigo_mod',
                'nombre_mod',
                'pen_uni_valorativa',
                'prerrequisito',
                'pen_id_mod_siguiente',
                'pen_id_asociado',
                'pen_aplica_diploma',
                'pen_num_horas',
                'pen_estado'
            );

            $required = array(
                'pen_id_mod',
                'pen_uni_valorativa',
                'pen_estado',
            );

            $alias = array(
                'codigo_mod'=> 'Código',
                'nombre_mod'=> 'Materia',
                'pen_id_mod' => 'Materia',
                'prerrequisito' => 'Prerrequisitos',
                'pen_id_mod_siguiente'=>'Siguiente materia',
                'pen_uni_valorativa' => 'Unidades valorativas',
                'pen_id_asociado' => 'Materia asociada',
                'pen_aplica_diploma'=> "Aplica para diploma",
                'pen_num_horas' => "Horas",
                'pen_estado' => 'Estado',
            );

            $columnas_insert = array(
                'pen_id_ard',
                'pen_id_mod',
                'pen_uni_valorativa',
                'prerrequisito',
                'pen_id_mod_siguiente',
                'pen_id_asociado',
                'pen_aplica_diploma',
                'pen_num_horas',
                'pen_estado',
                'pen_usu_creacion',
                'pen_usu_modificacion',
                'pen_fecha_creacion',
                'pen_fecha_modificacion',
            );

            $columnas_update = array(
                'pen_id_mod',
                'pen_id_ard',
                'pen_uni_valorativa',
                'prerrequisito',
                'pen_id_mod_siguiente',
                'pen_id_asociado',
                'pen_aplica_diploma',
                'pen_num_horas',
                'pen_estado',
                'pen_usu_modificacion',
                'pen_fecha_modificacion'
            );

            $crud->set_table('pen_pensum')
                    ->set_subject('Pensum')
                    ->columns($columnas)
                    ->display_as($alias)
                    ->add_fields($columnas_insert)
                    ->edit_fields($columnas_update)
                    ->required_fields($required)
                    ->set_relation('pen_id_mod', 'mod_modulo', '{mod_codigo} - {mod_nombre}', array('mod_estado' => 1))
                    ->set_relation('pen_id_mod_siguiente', 'mod_modulo', '{mod_codigo} - {mod_nombre}', array('mod_estado' => 1))
                    ->set_relation_n_n('prerrequisito', 'pre_prerrequisito', 'mod_modulo', 'pre_id_pen', 'pre_id_mod', 'mod_nombre', null, 'mod_id IN ('.$selected.')')                    
                    ->field_type('pen_aplica_diploma', 'dropdown', array('1' => 'Si', '0' => 'No'))

                    ->field_type('pen_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('pen_fecha_mod', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('pen_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('pen_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('pen_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('pen_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('pen_id_ard', 'hidden', $id_area)
                    ->field_type('pre_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                    ->set_rules('pen_id_mod', 'Materia', 'required|callback_revisarModulo')
                    ->set_rules('pen_num_horas', 'Horas', 'is_numeric')


                    ->callback_column('pen_id_asociado', function($value, $row) {
                        $asoc = $row->pen_id_asociado;
                       
                        if($asoc!=''){
                            $area=explode('/',uri_string());
                            $ard=$area[count($area)-1];
                            
                             $selected = $this->db->query("SELECT pen2.pen_id as id, mod_nombre FROM pen_pensum as pen1
                                                       LEFT JOIN pen_pensum as pen2 ON pen1.pen_id_asociado=pen2.pen_id
                                                       LEFT JOIN mod_modulo ON mod_id=pen2.pen_id_mod WHERE pen1.pen_id_ard = $ard AND pen2.pen_id = $asoc")->row_array();
                            $asociado = $selected['mod_nombre'];
                        }else{
                            $asociado = '';
                        }
                        return $asociado;
                    })

                   
                    ->callback_edit_field('prerrequisito', function(){
                        $area=explode('/',uri_string());
                        $ard=$area[count($area)-3];
                        $pen=$area[count($area)-1];
                       
                        $query = $this->db->query("SELECT pen_id_mod, mod_nombre FROM pen_pensum INNER JOIN mod_modulo ON mod_id=pen_id_mod LEFT JOIN pre_prerrequisito ON pen_id=pre_id_pen where pen_id_ard = $ard AND pen_id != $pen")->result_array();

                        $selected = $this->db->query("SELECT pre_id_mod, mod_nombre, pre_id FROM pen_pensum
                                                      LEFT JOIN pre_prerrequisito ON pen_id=pre_id_pen 
                                                      LEFT JOIN mod_modulo ON mod_id=pre_id_mod where pen_id_ard = $ard AND pen_id = $pen")->result_array();

                        $mods = array();
                        if(count($selected)>0){
                            foreach ($selected as $sel) {
                                $mods[] = $sel['pre_id_mod'];
                            }
                        }
                       
                        $select = '<select id="field-prerrequisito" name="prerrequisito[]" multiple="multiple" size="8" class="chosen-multiple-select" data-placeholder=" Prerrequisitos" style="width: 100%; display: none;">';

                        $select.='<option value=""></option>';
                        if(count($query)>0){
                            foreach ($query as $mod) {
                                if(in_array($mod['pen_id_mod'], $mods)){
                                    $pre = 'selected="selected"';
                                }else{
                                    $pre = '';
                                }
                                    $select.='<option value="'.$mod['pen_id_mod'].'" '.$pre.' >'.$mod['mod_nombre'].'</option>';
                            }   
                        }
                        $select.='</select>';

                         return $select;
                    })

                    ->callback_add_field('pen_id_asociado', function(){
                        $area=explode('/',uri_string());
                        $area=$area[count($area)-2];

                       
                        $query = $this->db->query("SELECT pen_id, pen_id_mod, mod_nombre FROM pen_pensum INNER JOIN mod_modulo ON mod_id=pen_id_mod where pen_id_ard = $area ")->result_array();


                       
                        $select = '<select id="field-pen_id_asociado" name="pen_id_asociado" class="nostyle chosen-select" data-placeholder="Materia asociada" style="width: 100%; display: none;">';                       
                                             
                        $select.='<option value=""></option>';
                        if(count($query)>0){
                            foreach ($query as $mod) {
                               
                                    $select.='<option value="'.$mod['pen_id'].'" >'.$mod['mod_nombre'].'</option>';
                            }
                        }
                        $select.='</select>';

                         return $select;
                       
                    })

                    ->callback_edit_field('pen_id_asociado', function($post_array, $primary_key){
                        $area=explode('/',uri_string());
                        $ard=$area[count($area)-3];
                        $pen=$area[count($area)-1];

                       
                        $query = $this->db->query("SELECT pen_id, pen_id_mod, mod_nombre FROM pen_pensum INNER JOIN mod_modulo ON mod_id=pen_id_mod where pen_id_ard = $ard AND pen_id != $pen")->result_array();

                         $selected = $this->db->query("SELECT pen2.pen_id as id, mod_nombre FROM pen_pensum as pen1
                                                       LEFT JOIN pen_pensum as pen2 ON pen1.pen_id_asociado=pen2.pen_id
                                                       LEFT JOIN mod_modulo ON mod_id=pen2.pen_id_mod WHERE pen1.pen_id_ard = $ard AND pen1.pen_id = $pen")->row_array();


                        $select = '<select id="field-pen_id_asociado" name="pen_id_asociado" class="nostyle chosen-select" data-placeholder="Materia asociada" style="width: 100%; display: none;">';                       
                        $select.='<option value=""></option>';
                        if(count($query)>0){
                            foreach ($query as $mod) {


                                if($selected['id']==$mod['pen_id']){
                                    $pre = 'selected="selected"';
                                }else{
                                    $pre = '';
                                }
                                $select.='<option value="'.$mod['pen_id'].'" '.$pre.' >'.$mod['mod_nombre'].'</option>';
                            }
                        }
                        $select.='</select>';

                         return $select;
                    })



                    ->callback_column('prerrequisito', function($post_array, $primary_key) {
                                $this->db->join('mod_modulo', 'pre_id_mod=mod_id');
                        $pre = $this->gsatelite->get_tabla('pre_prerrequisito', array('pre_id_pen'=>$primary_key->pen_id));
                       
                        $modulos=array();
                        if(count($pre)>0){
                            foreach ($pre as $pr) {
                                $modulos[] = $pr['mod_nombre'];
                            }
                        }
                        $mods = implode(',', $modulos);
                        return $mods;
                    })


                    ->callback_column('codigo_mod', function($value, $row) {
                        
                        $mod_id = $row->pen_id_mod;
                        $codigo = $this->gsatelite->get_campo('mod_modulo', 'mod_codigo',array('mod_id'=>$mod_id));

                        return $codigo;
                    })

                    ->callback_column('nombre_mod', function($value, $row) {
                       
                        $mod_id = $row->pen_id_mod;
                        $nombre = $this->gsatelite->get_campo('mod_modulo', 'mod_nombre',array('mod_id'=>$mod_id));
                        
                        return $nombre;
                    })
                    ;



            $urlx= explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('pen_estado', 'hidden', 1);
            } else {
                $crud->field_type('pen_estado', 'dropdown', array('1' => 'Activo', '2' => 'Inactivo'));
            }

            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'registro_academico/mantenimientos/pensum/'.$id_area.'/read', 'icomoon-icon-search-3');
            }

            $crud->where('pen_id_ard', $id_area);
            $output = $crud->render();

            $data['area'] = $this->gsatelite->get_registro('ard_area_academica', array('ard_id' => $id_area));

            $data['titulo_personal'] = "Gestión de pensum";

            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /*
     * *@AUTOR: CHRISTIAN MENENDEZ
     * *@DESCRIPCION: Agrega las materias en el pensum segun el area
     */

    function revisarModulo() {
        $materia = $this->input->post('pen_id_mod');

        $area = $this->input->post('pen_id_ard');

        if (!is_numeric(end(explode('/', uri_string())))) {

            $where = array('pen_id_ard' => $area, 'pen_id_mod' => $materia);

            $count = $this->gsatelite->get_tabla('pen_pensum', $where);
        } else {
            $id = end(explode('/', uri_string()));
            $where = 'pen_id_ard  = "' . $area . '" AND pen_id_mod = ' . $materia . " AND pen_id <> " . $id;

            $count = $this->gsatelite->get_tabla('pen_pensum', $where);
        }


        if (count($count) > 0) {

            $this->form_validation->set_message('revisarModulo', 'La materia ya existe');
            return false;
        } else {
            //$this->form_validation->set_message('validar_subtipo','El sub tipo ingresado ya existe');
            return true;
        }
    }

    public function gestion_niveles() {
        $crud = new grocery_CRUD();

        $crud->set_table('nva_nivel_area_academ');
        $crud->set_subject("Nivel");
        $crud->columns('nva_nombre', 'nva_estado');


        $crud->display_as('nva_estado', 'Estado');
        $crud->display_as('nva_nombre', 'Nombre');

        $crud->fields('nva_nombre', 'nva_estado', 'nva_usu_crea', 'nva_usu_mod', 'nva_fecha_crea', 'nva_fecha_mod');
        $crud->required_fields('nva_nombre', 'nva_estado');

        $crud->set_rules('nva_nombre', 'Nombre', 'trim|required|campo_unico[nva_nivel_area_academ.nva_nombre]');
        //->set_rules('nva_estado', 'nva_nivel_area_academ', array('mod_estado'=>1));

        $crud->field_type('nva_usu_crea', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('nva_usu_mod', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('nva_fecha_crea', 'hidden', date('Y-m-d H:m:s'));
        $crud->field_type('nva_fecha_mod', 'hidden', date('Y-m-d H:m:s'));

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('nva_estado', 'hidden', 1);
        } else {
            $crud->field_type('nva_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Niveles";
        $this->_cargarvista($data, $output);
    }

    public function gestion_causas() {
        $crud = new grocery_CRUD();

        $crud->set_table('crt_causa_retiro');
        $crud->set_subject("Causas de retiro");
        $crud->columns('crt_nombre', 'crt_estado');


        $crud->display_as('crt_estado', 'Estado');
        $crud->display_as('crt_nombre', 'Causa');

        //$crud->fields('crt_nombre','nva_usu_crea','nva_usu_mod','nva_fecha_crea','nva_fecha_mod');
        $crud->required_fields('crt_nombre', 'crt_estado');

        $crud->set_rules('crt_nombre', 'Nombre', 'trim|required|campo_unico[crt_causa_retiro.crt_nombre]');

        $crud->field_type('crt_usu_crea', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('crt_usu_mod', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('crt_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('crt_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
        $crud->unset_export();
        $crud->unset_print();
        $urlx = explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->field_type('crt_estado', 'hidden', 1);
        } else {
            $crud->field_type('crt_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Causas de retiro";
        $this->_cargarvista($data, $output);
    }

    /**
     * @author Edith Herrera
     * @modified 25-10-2017
     * @return Grid del mantenimiento de evaluaciones.
    * */
    function gestion_ponderaciones() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        if ($_POST) {
            $post_array = $_POST;
            $proyeccion = $post_array['proyeccion'];
            
            $where = null;
            if ($proyeccion != '') {
                $where['evm_id_pyc '] = $proyeccion;
            }
            
            $registro= $this->registro_academico_model->get_evaluaciones($where, true);
            $data['detalles'] = $registro;
                   
            $html = $this->load->view('registro_academico/mantenimientos/detalles_evaluacion', $data, true);
            echo $html;
        } else {

            $select = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);
            $data["proyeccion"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

          
            $data['titulo_personal'] = "Evaluaciones por nivel";

            $this->_cargarvista($data);
        }
    }

    /**
     * @author Edith Herrera
     * @since  25-10-2017
     * @return Acción de evaluaciones (detalle).
    * */
    function evaluaciones($id_pyc, $pen_id=null) {   
        satelite_validar();
        if ($_POST) {
            //die(print_r($_POST));
            $post_array = $_POST;
            $redir = $post_array['redireccion'];
            $pen = $post_array['pen_id'];
            $pensum = $post_array['slcModulo'];
            $proyeccion = $post_array['hdnProyeccion'];
            $estado = ($post_array['slc_estado']!='')?$post_array['slc_estado']:1;
            $evm_id = $post_array['evm_id'];
            if (!is_array($evm_id)) { $evm_id = array();  }
            
            // DETALLES A INGRESAR
            $periodo = $post_array['detalle_per'];
            $porcentaje = $post_array['detalle_porc']; // Porcentaje asignado por el usuario
            $pct_general = $post_array['detalle_gen']; // Porcentaje general (calculado) 
            $orden = $post_array['detalle_orden'];
            $tipo = $post_array['detalle_tipo'];
            $fecha_ini = $post_array['detalle_inicio'];
            $fecha_fin = $post_array['detalle_fin'];
            $fecha_maxima = $post_array['detalle_max'];

            if($pen<=0){
                foreach ($pensum as $pens) {
                    $detalle_bd= $this->gsatelite->get_tabla('evm_evaluacion_modulo', array('evm_id_pyc'=>$proyeccion, 'evm_id_pen'=>$pens));
                    if(!empty($evm_id)){
                        foreach ($detalle_bd as $exist) {
                            if (!in_array($exist['evm_id'], $evm_id)) {
                                $this->gsatelite->borrado_general('evm_evaluacion_modulo', array('evm_id'=>$exist['evm_id']));
                            }
                        }
                    }else{
                        $this->gsatelite->borrado_general('evm_evaluacion_modulo', array('evm_id_pyc'=>$proyeccion, 'evm_id_pen'=>$pens));
                    }

                    foreach ($porcentaje as $key => $value) {
                        $array_evm = array(
                            'evm_porcentaje'=>$pct_general[$key],
                            'evm_orden'=>$orden[$key],
                            'evm_id_pen'=>$pens,
                            'evm_id_pyc'=>$proyeccion,
                            'evm_id_tev'=>$tipo[$key],
                            'evm_id_pev'=>$periodo[$key],
                            'evm_porcentaje_periodo'=>$value,
                            'evm_fecha_inicio'=>($fecha_ini[$key] != '' )?formatear_fecha('Y-m-d', $fecha_ini[$key]):null,
                            'evm_fecha_fin'=>($fecha_fin[$key] != '' )?formatear_fecha('Y-m-d', $fecha_fin[$key]):null,
                            'evm_fecha_max_nota'=>($fecha_maxima[$key] != '' )?formatear_fecha('Y-m-d', $fecha_maxima[$key]):null,
                            'evm_estado'=>$estado,
                            'evm_usu_creacion'=>$this->tank_auth->get_user_id(),
                            'evm_fecha_creacion'=>date('Y-m-d H:i:s'),
                            'evm_usu_modificacion'=>$this->tank_auth->get_user_id(),
                            'evm_fecha_modificacion'=>date('Y-m-d H:i:s')
                        );

                       $ingreso = $this->gsatelite->ingresar('evm_evaluacion_modulo', $array_evm);
                    }
                }
            }else{
                $detalle_bd= $this->gsatelite->get_tabla('evm_evaluacion_modulo', array('evm_id_pyc'=>$proyeccion, 'evm_id_pen'=>$pen));
                if(!empty($evm_id)){
                    foreach ($detalle_bd as $exist) {
                        if (!in_array($exist['evm_id'], $evm_id)) {
                            $this->gsatelite->borrado_general('evm_evaluacion_modulo', array('evm_id'=>$exist['evm_id']));
                        }
                    }
                }else{
                    $this->gsatelite->borrado_general('evm_evaluacion_modulo', array('evm_id_pyc'=>$proyeccion, 'evm_id_pen'=>$pen));
                }
                foreach ($porcentaje as $key => $value) {
                    $array_evm = array(
                        'evm_porcentaje'=>$pct_general[$key],
                        'evm_orden'=>$orden[$key],
                        'evm_id_pen'=>$pensum,
                        'evm_id_pyc'=>$proyeccion,
                        'evm_id_tev'=>$tipo[$key],
                        'evm_id_pev'=>$periodo[$key],
                        'evm_porcentaje_periodo'=>$value,
                        'evm_fecha_inicio'=>($fecha_ini[$key] != '' )?formatear_fecha('Y-m-d', $fecha_ini[$key]):null,
                        'evm_fecha_fin'=>($fecha_fin[$key] != '' )?formatear_fecha('Y-m-d', $fecha_fin[$key]):null,
                        'evm_fecha_max_nota'=>($fecha_maxima[$key] != '' )?formatear_fecha('Y-m-d', $fecha_maxima[$key]):null,
                        'evm_estado'=>$estado,
                        'evm_usu_creacion'=>$this->tank_auth->get_user_id(),
                        'evm_fecha_creacion'=>date('Y-m-d H:i:s'),
                        'evm_usu_modificacion'=>$this->tank_auth->get_user_id(),
                        'evm_fecha_modificacion'=>date('Y-m-d H:i:s')
                    );

                   $ingreso = $this->gsatelite->ingresar('evm_evaluacion_modulo', $array_evm);
                }
            }

             // DETALLES A ACTUALIZAR
            $porcentaje_bd = $post_array['detalle_porcbd']; // porcentaje asignado por el usuario
            $pct_general = $post_array['detalle_genbd']; // Porcentaje general (calculado) 
            $periodobd = $post_array['detalle_perbd'];
            $orden_bd = $post_array['detalle_ordenbd'];
            $tipo_bd = $post_array['detalle_tipobd'];
            $fecha_ini_bd = $post_array['detalle_iniciobd'];
            $fecha_fin_bd = $post_array['detalle_finbd'];
            $fecha_maxima_bd = $post_array['detalle_maxbd'];
             
            foreach ($evm_id as $bd => $valor) {  
                $array_act = array(
                    'evm_porcentaje'=>$pct_general[$bd],
                    'evm_orden'=>$orden_bd[$bd],
                    'evm_id_pen'=>$pensum,
                    'evm_id_pyc'=>$proyeccion,
                    'evm_id_tev'=>$tipo_bd[$bd],
                    'evm_id_pev'=>$periodobd[$bd],
                    'evm_porcentaje_periodo'=>$porcentaje_bd[$bd],
                    'evm_fecha_inicio'=>($fecha_ini_bd[$bd] != '' )?date('Y-m-d', strtotime($fecha_ini_bd[$bd])):null,
                    'evm_fecha_fin'=>($fecha_fin_bd[$bd] != '' )?date('Y-m-d', strtotime($fecha_fin_bd[$bd])):null,
                    'evm_fecha_max_nota'=>($fecha_maxima_bd[$bd] != '' )?formatear_fecha('Y-m-d', $fecha_maxima_bd[$bd]):null,
                    'evm_estado'=>$estado,
                    'evm_usu_modificacion'=>$this->tank_auth->get_user_id(),
                    'evm_fecha_modificacion'=>date('Y-m-d H:i:s')
                );
                //die(print_r($array_act));
                $actualiza = $this->gsatelite->actualizar_array('evm_evaluacion_modulo', $array_act, array('evm_id'=>$valor));
            }

            if ( $ingreso > 0 || $actualiza > 0 ) {
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información ingresada.");
            }
            $this->session->set_flashdata($alerta);

            if($redir>0){
                redirect('registro_academico/mantenimientos/gestion_ponderaciones');
            }else{
                if($pen>0){
                    redirect('registro_academico/mantenimientos/evaluaciones/'.$proyeccion.'/'.$pen);
                }else{
                    redirect('registro_academico/mantenimientos/evaluaciones/'.$proyeccion);
                }
            }
        }else{
            $data['proyeccion'] = $proyeccion = $this->gsatelite->get_registro('pyc_proyeccion', array('pyc_id'=>$id_pyc));

            
            if($pen_id>0){

                $registro = $this->registro_academico_model->get_evaluaciones(array('pen_id'=>$pen_id, 'pyc_id'=>$id_pyc), true);

                $data['reg'] = $registro[0];

                $usados = $this->registro_academico_model->get_evaluaciones(array('pyc_id'=>$id_pyc, 'pen_id !='=>$pen_id));
                //die(print_r($usados));
                $ids_ev = array();
                if(count($usados)>0){
                    foreach ($usados as $key) {
                        $ids_ev[]= $key['pen_id'];
                    }
                }
                if(!empty($ids_ev)){
                    $this->db->where_not_in('pen_id', $ids_ev);
                }
                /***************************************************************************************************************/

                          $this->db->join('mod_modulo', 'pen_id_mod=mod_id');
                $pensum = $this->gsatelite->get_tabla('pen_pensum', array('pen_id'=>$registro[0]['evm_id_pen']));

                $drop_pensum = '<option value=""></option>';

                if(count($pensum)>0){
                    foreach ($pensum as $pen) {
                        if($pen['pen_id']==$pen_id){$select='selected="selected"'; }else{ $select=''; }
                        $drop_pensum .= '<option value="'.$pen['pen_id'].'" '.$select.'>'.$pen['mod_nombre'].'</option>';
                    }
                }

                $data["modulos"] = $drop_pensum;

                    $this->db->join('pyc_proyeccion', 'pyc_id_ard=ard_id', 'LEFT');
                    $this->db->join('axy_areas_x_proyecion', 'axy_id_ard = ard_id', 'LEFT');
                    $this->db->group_by('ard_id');
                $programas = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array("(pyc_id = ".$id_pyc." OR axy_id_pyc = ".$id_pyc.")" => NULL, "ard_estado" => '1'), $registro[0]['pen_id_ard'], '', 'ard_id', true);
                $areas = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $programas);

                $data["areas"] = $areas;

                $data['detalles'] = $detalles = $this->registro_academico_model->get_evaluaciones(array('pen_id'=>$pen_id, 'pyc_id'=>$id_pyc), false, true, 'evm_orden');

                $data['pen_id'] = $pen_id;

                $periodo = $this->gsatelite->get_dropdown('pev_periodo_evaluacion', '{pev_nombre}', '', array('pev_estado' => 1), null, '', 'pev_id', true);
                $data["periodos"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $periodo); 

            }else{

                $detalles = $this->registro_academico_model->get_evaluaciones(array('pyc_id'=>$id_pyc));

                    $this->db->join('pyc_proyeccion', 'pyc_id_ard=ard_id', 'LEFT');
                    $this->db->join('axy_areas_x_proyecion', 'axy_id_ard = ard_id', 'LEFT');
                    $this->db->group_by('ard_id');
                $programas = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array("(pyc_id = ".$id_pyc." OR axy_id_pyc = ".$id_pyc.")" => NULL, "ard_estado" => '1'), null, '', 'ard_id', true);
                $areas = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $programas);

                $data["areas"] = $areas;

                $data["pen_id"] = 0;

                $periodo = $this->gsatelite->get_dropdown('pev_periodo_evaluacion', '{pev_nombre}', '', array('pev_estado' => 1), null, '', 'pev_id', true);
                $data["periodos"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $periodo);

            }
            

            $select = $this->gsatelite->get_dropdown('tev_tipo_evaluacion', '{tev_nombre}', '', array('tev_estado' => 1), null, '', 'tev_id', true);
            $data["tipos"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

            $data['maximo'] = ($this->gsatelite->get_parametro('SYS_DIAS_MAXIMO')!='')?$this->gsatelite->get_parametro('SYS_DIAS_MAXIMO'):0;
            
            $limite = strtotime ( '+'.$data['maximo'].' day' , strtotime ( $proyeccion->pyc_fecha_fin ) ) ;
            $data['limite'] = date ( 'd-m-Y' , $limite );
          
            $data['decimal'] = $this->decimal_nota;

            $data['id_pyc'] = $id_pyc;

            $data['titulo_personal'] = "Evaluaciones por nivel";
            $this->_cargarvista($data);
        }
       
    }

    //Funcion dedicada a obtener los modulos por el area y proyeccion seleccionada
    function obtener_modulos_area_proyeccion() {
            
        satelite_validar(true);

        $id_pyc = $this->input->post('proyeccion');
        $area_pyc = $this->input->post('area');
        $pen_id = $this->input->post('pensum');


        if($pen_id > 0) {

            $registro = $this->registro_academico_model->get_evaluaciones(array('pen_id'=>$pen_id, 'pyc_id'=>$id_pyc), true);

            $usados = $this->registro_academico_model->get_evaluaciones(array('pyc_id'=>$id_pyc, 'pen_id !='=>$pen_id));
            
            $ids_ev = array();
            if(count($usados)>0){
                foreach ($usados as $key) {
                    $ids_ev[] = $key['pen_id'];
                }
            }
            if(!empty($ids_ev)){
                $this->db->where_not_in('pen_id', $ids_ev);
            }

                      $this->db->join('mod_modulo', 'pen_id_mod=mod_id');
            $pensum = $this->gsatelite->get_tabla('pen_pensum', array('pen_id'=>$registro[0]['evm_id_pen']));

            $drop_pensum = '<option></option>';

            if(count($pensum)>0){
                foreach ($pensum as $pen) {
                    if($pen['pen_id']==$pen_id){$select='selected="selected"'; }else{ $select=''; }
                    $drop_pensum .= '<option value="'.$pen['pen_id'].'" '.$select.'>'.$pen['mod_nombre'].'</option>';
                }
            }

        } else {

                $this->db->group_by('evm_id_pen');
            $eval_exist = $this->gsatelite->get_tabla('evm_evaluacion_modulo', array('evm_id_pyc'=>$id_pyc));

            $existente = array();
            if(count($eval_exist)>0){
                foreach ($eval_exist as $eval ) {
                    $existente[] = $eval['evm_id_pen']; 
                }
            }

                    if(!empty($existente)){
                        $this->db->where_not_in('pen_id', $existente);
                    }
                    $this->db->join('mod_modulo', 'pen_id_mod=mod_id');
            $pensum = $this->gsatelite->get_tabla('pen_pensum', array('pen_id_ard'=>$area_pyc));
            
            $drop_pensum = '<option></option>';

            if(count($pensum)>0){
                foreach ($pensum as $pen) {
                    $drop_pensum .= '<option value="'.$pen['pen_id'].'" selected="selected">'.$pen['mod_nombre'].'</option>';
                }
            }
            
        }   

        echo json_encode(array('modulos'=>$drop_pensum));

    }


    function validar_modulo_proyeccion(){
        satelite_validar(true);

        $id_pen = $this->input->post('pensum');
        $proyect = $this->input->post('proyect');
        $edit = ($this->input->post('edit')>0)?$this->input->post('edit'):0;

        $validado1=0; //variable que cambiará de valor cuando no se cumpla una condición de validación
        if ((is_array($id_pen)) && (count($id_pen) == 0)) {
            $id_pen = '';die();
        }

        if( $id_pen != '' )
        {           
            //PREGUNTAR SI EXISTEN REGISTROS IGUALES. 
            if(count($edit)>0){   $this->db->where_not_in('evm_id', $edit);  }
            $id_pen = implode(',', $id_pen);
            $pregunta = $this->registro_academico_model->get_evaluaciones(array('evm_id_pen in('.$id_pen.')'=>null, 'evm_id_pyc'=>$proyect));
        
            if(count($pregunta)>0){
                $validado=1;
            }else {
               $validado=0; 
            }
            echo $validado;
        }else {
            echo $validado;
        }
    
    }

//==============================================================
// INICIO DE CALLBACKS
//======================================================================
    function _log_usuario_insert($post_array) {
        $pre_auditoria = array(
            'pre_usu_crea' => $this->tank_auth->get_user_id(),
            'pre_usu_mod' => $this->tank_auth->get_user_id(),
            'pre_fecha_crea' => date('Y-m-d H:i:s'),
            'pre_fecha_mod' => date('Y-m-d H:i:s'),
        );

        $this->gsatelite->actualizar_array('pre_prerrequisito', $pre_auditoria, array('pre_id_mod' => $post_array['pen_id_mod']));
        //print_r($post_array['pen_id_mod']);exit();
        /* reset($post_array);
          $sufijo = explode("_", key($post_array));
          $post_array[$sufijo[0] . '_usu_mod'] = $this->tank_auth->get_user_id();
          $post_array[$sufijo[0] . '_fecha_mod'] = date('Y-m-d H:i:s');
          $post_array[$sufijo[0] . '_usu_crea'] = $this->tank_auth->get_user_id();
          $post_array[$sufijo[0] . '_fecha_crea'] = date('Y-m-d H:i:s');
          return $post_array; */
    }

    function _log_usuario_update($post_array) {
        reset($post_array);
        $sufijo = explode("_", key($post_array));
        $post_array[$sufijo[0] . '_usu_mod'] = $this->tank_auth->get_user_id();
        $post_array[$sufijo[0] . '_fecha_mod'] = date('Y-m-d H:i:s');
        return $post_array;
    }

//======================================================================
// FIN DE CALLBACKS
//======================================================================


    function agregar_modulo() {
        satelite_validar();
        if ($_POST) {
            $uni=$this->gsatelite->get_parametro('SYS_UNIDAD_MEDIDA');
            $tipo=$this->gsatelite->get_parametro('SYS_TIPO_ARTICULO');
            $categoria = $this->input->post('slccategoria'); //categoria seleccionada para el nivel

                            $this->db->order_by('art_id', 'desc');
            $producto_reg = $this->gsatelite->get_tabla('art_articulo',  array('art_id_tia'=>$categoria));
            
            $codigos_array = array();
            $max_codigo = $producto_reg[0]['art_codigo'];
            foreach ($producto_reg as $key) {
                $codigos_array[] = $key['art_codigo'];
            }
    
            $correlativo = preg_replace('/[^A-Za-z]+/', '', $max_codigo);
            $codigo = intval(preg_replace('/[^0-9]+/', '', $max_codigo), 10);
            do{
                $codigo = $codigo + 1;
                $codigo_con_zeros = str_pad($codigo, 3, "0", STR_PAD_LEFT);
                $codigo_vdd = $correlativo.$codigo_con_zeros;
            } while (in_array($codigo_vdd, $codigos_array));

            //obtener codigo de categoria
            //Necesario para obtener el codigo del articulo.
            $codigo_categoria = $this->gsatelite->get_campo('tia_tipo_articulo','tia_codigo',array('tia_id' => $categoria) );
            //contar cantidad articulos
            $cantidad = $this->gsatelite->count('art_articulo',array('art_id_tia' => $categoria) );
            $cantidad = $cantidad + 1;
            $cantidad = str_pad($cantidad, 3, "0", STR_PAD_LEFT); 

            //$articulos = $this->input->post('slcProducto');

            //Se agrega la conversion del articulo para la tabla ( cva_conversion_articulo )
            $unidad_defecto = $this->gsatelite->get_parametro('SYS_UNIDAD_MEDIDA');
            // Validacion para verificar si existe el parametro
            if (!$unidad_defecto > 0 || $unidad_defecto == null) {
                $this->gsatelite->show_dialog('No se ha seleccionado ningun parametro', 'registro_academico/mantenimientos/agregar_modulo', 'error', 'Error en parametro');
            }
            // Validar que si existe registro en la tabla de conversion de articulo
            /* $conversion = $this->gsatelite->get_tabla('cva_conversion_articulo', array('cva_id'=>$unidad_defecto, 'cva_estado'=>1));
            if (!count($conversion)>0) {
                $this->gsatelite->show_dialog('No se encontro conversion de articulo', 'registro_academico/mantenimientos/agregar_modulo', 'error', 'Error en parametro');
            }*/

            $codigo = $codigo_categoria.$cantidad;
            $repetido = $this->gsatelite->get_tabla('art_articulo', array('art_codigo' => $codigo));
            if (count($repetido) > 0) {
                do {
                    $cantidad++;
                    $codigo = $codigo_categoria . str_pad($cantidad, 3, "0", STR_PAD_LEFT);
                    $revisar = $this->gsatelite->get_tabla('art_articulo', array('art_codigo' => $codigo));
                } while (count($revisar) > 0);
            }
            
            $array_art = array(
                'art_id_tia' => $categoria,
                'art_nombre' => $this->input->post('nombre'),
                'art_codigo' => $codigo,
                'art_descripcion' => ($this->input->post('descripcion')) ? $this->input->post('descripcion') : null,
                'art_fecha' => date('Y-m-d H:i:s'),
                'art_tipo' => 1,
                'art_combo' => 0,
                'art_compra' => 0,
                'art_inventario' => 0,
                'art_venta' => 1,
                'art_materia_prima' => 0,
                'art_gasto' => 1,
                'art_costo' => 1,
                'art_produccion' => 0,
                'art_estado' => 1,
                'art_usu_creacion' => $this->tank_auth->get_user_id(),
                'art_fecha_creacion' => date('Y-m-d H:i:s'),
                'art_usu_modificacion' => $this->tank_auth->get_user_id(),
                'art_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $art_id = $this->gsatelite->ingresar('art_articulo', $array_art);

            $productosData = json_decode($this->input->post('productosData'), true);
            if (!empty($productosData)) {
                foreach ($productosData as $producto) {
                    $articulo_update = array(
                        'art_precio_sugerido' => $producto['precio'],
                        'art_estado' => 1,
                        'art_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'art_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('art_articulo', $articulo_update, array('art_id' => $producto['id']));

                    $combo_array = array(
                        'cma_id_art' => $art_id,
                        'cma_id_art_combo' => $producto['id'],
                        'cma_cantidad' => $producto['existencias'],
                        'cma_estado' => 1,
                        'cma_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cma_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'cma_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cma_fecha_creacion' => date('Y-m-d H:i:s'),
                    );
                    $this->gsatelite->ingresar('cma_combo_articulo', $combo_array);
                }
            }

            /*if($articulos!='' && $articulos!=null){
                $articulo = explode(',', $articulos);
                foreach ($articulo as $key => $valor) {
                      $combo_array = array(
                        'cma_id_art' => $art_id,
                        'cma_id_art_combo' => $valor,
                        'cma_cantidad' => 1,
                        'cma_estado' => 1,
                        'cma_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cma_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'cma_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cma_fecha_creacion' => date('Y-m-d H:i:s'),
                    );
                    $combo = $this->gsatelite->ingresar('cma_combo_articulo', $combo_array);
                } 
            }*/

            $conversion_array = array(
                'cva_id_mep' => $unidad_defecto,
                'cva_id_art' => $art_id,
                'cva_conversion' => 1,
                'cva_defecto' => 1,
                'cva_estado' => 1,
                'cva_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cva_fecha_modificacion' => date('Y-m-d H:i:s'),
                'cva_usu_creacion' => $this->tank_auth->get_user_id(),
                'cva_fecha_creacion' => date('Y-m-d H:i:s'),
            );
            $this->gsatelite->ingresar('cva_conversion_articulo', $conversion_array);

            $unidades    = $this->input->post('unidades');
            $codigoMined = $this->input->post('txtCodigoMined');

            $codigo      = $this->input->post('txtCodigo');

            $verificar_codigo = $this->gsatelite->get_registro('mod_modulo', 'mod_codigo', $codigo);

            if(!empty($verificar_codigo)) {

                do {
                    $codigo = $codigo + 1;
                    $codigo = str_pad($cantidad, 6, "0", STR_PAD_LEFT);
                    $verificar_codigo = $this->gsatelite->get_registro('mod_modulo', 'mod_codigo', $codigo);
                } while (empty($verificar_codigo));
                
            }

            $array_mod = array(
                'mod_nombre' => $this->input->post('nombre'),
                'mod_codigo' => $codigo, 
                'mod_descripcion' => ($this->input->post('descripcion')) ? $this->input->post('descripcion') : null,
                'mod_estado' => 1,
                'mod_codigo_mined' => $codigoMined,
                'mod_usu_crea' => $this->tank_auth->get_user_id(),
                'mod_fecha_crea' => date('Y-m-d H:i:s'),
                'mod_usu_mod' => $this->tank_auth->get_user_id(),
                'mod_fecha_mod' => date('Y-m-d H:i:s'),
                'mod_id_art' => $art_id
            );

            $modulo = $this->gsatelite->ingresar('mod_modulo', $array_mod);

            $id_mod = $this->gsatelite->get_tabla('mod_modulo', array('mod_nombre' => $this->input->post('nombre')));
            
            foreach ($unidades as $id) {
                $info = array(
                    'uxm_id_unm' => $id,
                    'uxm_id_mod' => $id_mod[0]['mod_id'],
                    'uxm_estado' => 1,
                    'uxm_usu_creacion' => $this->tank_auth->get_user_id(),
                    'uxm_fecha_creacion' => date('Y-m-d H:i:s'),
                    'uxm_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'uxm_fecha_modificacion' => date('Y-m-d H:i:s'),
                );
                $this->gsatelite->ingresar('uxm_unidadxmodulo', $info);
            }

            $dir = $this->input->post('direccion');
            if ($dir == 1) {
                redirect('registro_academico/mantenimientos/agregar_modulo?resultado=1');
            } else if ($dir == 2) {
                redirect('registro_academico/mantenimientos/gestion_modulos?result=' . $modulo);
            }
        } else {
            // Codigo sugerido     
            $max_codigo = $this->gsatelite->get_max_numerico('mod_modulo', 'mod_codigo', null);
            $ultimo = $this->gsatelite->get_max('mod_modulo', 'mod_id', null);
            $max_codigo_id = $this->gsatelite->get_max_numerico('mod_modulo', 'mod_codigo', array('mod_id'=>$ultimo));

            // último código registrado en base de datos
            $cod_id = intval(preg_replace('/[^0-9]+/', '', $max_codigo_id), 10);
            // código maximo.
            $codigo = intval(preg_replace('/[^0-9]+/', '', $max_codigo), 10);

            if($codigo>$cod_id){
                $codigo = $codigo + 1;
            }else{
                $codigo = $cod_id + 1;
            }
            $codigo_con_zeros = str_pad($codigo, 3, "0", STR_PAD_LEFT);
            $data['codigo'] = $codigo_con_zeros;

            $data['unidades'] = $this->gsatelite->get_tabla('unm_unidad_modulo', array('unm_estado' => 1));
            $data['titulo_personal'] = "Nivel / Curso / Materia";
            $this->_cargarvista($data, null);
        }
    }

    function consultar_categoria($servicio = ""){
        $categoria = $this->input->post('categoria');
        $result = $this->registro_academico_model->get_categoria_like($categoria, $servicio);
        echo json_encode($result);
    }

    function get_precio_sugerido() {
        $producto_id = $this->input->post('producto_id');
        if (!$producto_id) {
            echo json_encode(['error' => 'ID de producto no proporcionado']);
            return;
        }

        $producto = $this->gsatelite->get_campo('art_articulo', 'art_precio_sugerido', array('art_id' => $producto_id));
        echo json_encode(['art_precio_sugerido' => $producto]);
    }

    function editar_modulo($mod_id) {
        satelite_validar();
        if ($_POST) {
            $uni = $this->gsatelite->get_parametro('SYS_UNIDAD_MEDIDA');
            $tipo = $this->gsatelite->get_parametro('SYS_TIPO_ARTICULO');

            $id_mod = $this->input->post('id_mod');
            $unidades = $this->input->post('unidades');
            $codigo = $this->input->post('txtCodigo');

            $verificar_codigo = $this->gsatelite->get_registro('mod_modulo', array('mod_codigo' => $codigo, 'mod_id <>' => $id_mod));
            if (!empty($verificar_codigo)) {
                do {
                    $codigo = $codigo + 1;
                    $codigo = str_pad($codigo, 6, "0", STR_PAD_LEFT);
                    $verificar_codigo = $this->gsatelite->get_registro('mod_modulo', array('mod_codigo' => $codigo, 'mod_id <>' => $id_mod));
                } while (!empty($verificar_codigo));
            }

            $codigoMined = $this->input->post('txtCodigoMined');

            $array_mod = array(
                'mod_codigo' => $codigo,
                'mod_nombre' => $this->input->post('nombre'),
                'mod_descripcion' => ($this->input->post('descripcion')) ? $this->input->post('descripcion') : null,
                'mod_codigo_mined' => $codigoMined,
                'mod_estado' => $this->input->post('estado'),
                'mod_usu_mod' => $this->tank_auth->get_user_id(),
                'mod_fecha_mod' => date('Y-m-d H:i:s')
            );

            $modulo = $this->gsatelite->actualizar_array('mod_modulo', $array_mod, array('mod_id' => $id_mod));

            $array_art = array(
                'art_id_tia' => $this->input->post('slccategoria'),
                'art_nombre' => $this->input->post('nombre'),
                'art_descripcion' => ($this->input->post('descripcion')) ? $this->input->post('descripcion') : null,
                'art_usu_modificacion' => $this->tank_auth->get_user_id(),
                'art_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('art_articulo', $array_art, array('art_id' => $this->input->post('id_pro')));

            $productosData = json_decode($this->input->post('productosData'), true);
            $this->gsatelite->borrado_general('cma_combo_articulo', array('cma_id_art' => $this->input->post('id_pro')));
            if (!empty($productosData)) {
                foreach ($productosData as $producto) {
                    $articulo_update = array(
                        'art_precio_sugerido' => $producto['precio'],
                        'art_estado' => 1,
                        'art_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'art_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('art_articulo', $articulo_update, array('art_id' => $producto['id']));

                    $combo_array = array(
                        'cma_id_art' => $this->input->post('id_pro'),
                        'cma_id_art_combo' => $producto['id'],
                        'cma_cantidad' => $producto['existencias'],
                        'cma_estado' => 1,
                        'cma_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cma_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'cma_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cma_fecha_creacion' => date('Y-m-d H:i:s'),
                    );
                    $this->gsatelite->ingresar('cma_combo_articulo', $combo_array);
                }
            }

            // Actualizar unidades por módulo
            $this->gsatelite->borrado_general('uxm_unidadxmodulo', array('uxm_id_mod' => $id_mod));
            if ($unidades) {
                foreach ($unidades as $id) {
                    $info = array(
                        'uxm_id_unm' => $id,
                        'uxm_id_mod' => $id_mod,
                        'uxm_estado' => 1,
                        'uxm_usu_creacion' => $this->tank_auth->get_user_id(),
                        'uxm_fecha_creacion' => date('Y-m-d H:i:s'),
                        'uxm_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'uxm_fecha_modificacion' => date('Y-m-d H:i:s'),
                    );
                    $this->gsatelite->ingresar('uxm_unidadxmodulo', $info);
                }
            }

            $dir = $this->input->post('direccion');
            if ($dir == 1) {
                redirect('registro_academico/mantenimientos/editar_modulo/' . $id_mod . '?resultado=1');
            } else if ($dir == 2) {
                redirect('registro_academico/mantenimientos/gestion_modulos?result=' . $id_mod);
            }
        } else {
            $data['unidades'] = $this->gsatelite->get_tabla('unm_unidad_modulo', array('unm_estado' => 1));
            $data['uxm'] = $this->gsatelite->get_tabla('uxm_unidadxmodulo', array('uxm_id_mod' => $mod_id, 'uxm_estado' => 1));
            
            $this->db->join('art_articulo', 'art_id = mod_id_art');
            $this->db->join('tia_tipo_articulo', 'tia_id = art_id_tia');
            $data['info'] = $this->gsatelite->get_tabla('mod_modulo', array('mod_id' => $mod_id));
            
            $this->db->join('art_articulo', 'cma_id_art_combo = art_id');
            $combo = $this->gsatelite->get_tabla('cma_combo_articulo', array('cma_estado' => 1, 'cma_id_art' => $data['info'][0]['art_id']));
            
            $productosData = [];
            foreach ($combo as $key) {
                $productosData[] = [
                    'id' => $key['cma_id_art_combo'],
                    'text' => str_replace(array("'"), array("\'"), $key['art_nombre']),
                    'precio' => number_format($key['art_precio_sugerido'], 2),
                    'existencias' => $key['cma_cantidad']
                ];
            }
            $data['productosData'] = json_encode($productosData);

            $data['mined'] = $this->gsatelite->get_campo('mod_modulo', 'mod_codigo_mined', array('mod_id' => $mod_id));
            $data['codigo'] = $this->gsatelite->get_campo('mod_modulo', 'mod_codigo', array('mod_id' => $mod_id));
            
            $data['titulo_personal'] = "Nivel / Curso / Materia";
            $this->_cargarvista($data, null);
        }
    }

    function validar_modulo() {
        $nombre = $this->input->post('nombre');
        $id = $this->input->post('id');

        if ($id > 0) {
            $validar_nombre = $this->db->select('mod_nombre,mod_id')
                            ->from('mod_modulo')
                            ->where('mod_id <>', $id)
                            ->where('mod_nombre', $nombre)
                            ->get()->result_array();
            if (count($validar_nombre) > 0) {
                if ($validar_nombre[0]['mod_id'] == $id) {
                    $id = $validar_nombre[0]['mod_id'];
                }
            } else {
                $id = 0;
            }
        } else {
            $validar_nombre = $this->db->select('mod_nombre,mod_id')
                            ->from('mod_modulo')
                            ->where('mod_nombre', $nombre)
                            ->get()->result_array();
            if (count($validar_nombre) > 0) {
                $id = $validar_nombre[0]['mod_id'];
            } else {
                $id = 0;
            }
        }
        $data = array(
            'id' => $id,
            'response' => true);
        echo json_encode($data);
    }

    function eliminar_relacion_notas($primary_key) {

        $this->gsatelite->borrado_general('noa_nota_alumno', array('noa_id_pod' => $primary_key));

        return true;
    }

    function validar_order($post_array) {
        $numero = $this->input->post('pod_orden');

        if (!is_numeric(end(explode('/', uri_string())))) {

            $where = array('pod_orden' => $numero);

            $count = $this->gsatelite->get_tabla('pod_ponderacion', $where);
        } else {
            $id = end(explode('/', uri_string()));

            $where = 'pod_orden  = ' . $numero . ' AND pod_id <> ' . $id;

            $count = $this->gsatelite->get_tabla('pod_ponderacion', $where);
        }

        if (count($count[0]) > 0) {

            $this->form_validation->set_message('validar_order', 'El número de orden debe ser único');
            return false;
        } else {
            return true;
        }
    }

    function validar_ponderaciones($post_array) {

        $ponderacion = $this->input->post('pod_ponderacion');

        /* if(!is_float($ponderacion)){

          $this->form_validation->set_message('validar_ponderaciones','El %s debe contener número decimal.');

          return false;
          } */


        if (!is_numeric(end(explode('/', uri_string())))) {

            $suma_pod = $this->gsatelite->get_suma('pod_ponderacion', 'pod_ponderacion');
        } else {

            $id = end(explode('/', uri_string()));

            $suma_pod = $this->gsatelite->get_suma('pod_ponderacion', 'pod_ponderacion', 'pod_id <>' . $id);
        }

        $suma_pod += $ponderacion;

        if (floatval($suma_pod) > 1) {

            $this->form_validation->set_message('validar_ponderaciones', 'Las ponderaciones deben sumar 100&#37;');
            return false;
        } else {

            return true;
        }
    }

    function validar_grupo() {
        $grupo = $this->input->post('nombre');
        $id = $this->input->post('id');
        if ($id > 0 && $id != '') {
            $gra = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_nombre' => trim($grupo), 'gra_id !=' => $id));

            if (!empty($gra)) {
                echo json_encode(array('gra' => 1));
            }
        } else {
            $grp = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_nombre' => trim($grupo)));

            if (!empty($grp)) {
                echo json_encode(array('gra' => 1));
            }
        }
    }

    public function nivel_idioma($id_area = 0, $ruta_vista=null) {
        satelite_validar();

         //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
        $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'registro_academico/mantenimientos/nivel_idioma'; //cuando viene la petición de otro modulo.
        $arreglo_url = explode('/', $ruta_permisos);
        $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
        $ruta_vista = (is_array($ruta_vista)) ? $ruta_vista[1] : null;
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();


            $columnas = array(
                'nii_nombre',
                'nii_estado'
            );

            $required = array(
                'nii_nombre',
                'nii_estado'
            );

            $alias = array(
                'nii_nombre' => 'Nombre',
                'nii_estado' => 'Estado'
            );

            $columnas_insert = array(
                'nii_nombre',
                'nii_estado',
                'nii_usu_crea',
                'nii_fecha_crea',
                'nii_usu_mod',
                'nii_fecha_mod'
            );

            $columnas_update = array(
                'nii_nombre',
                'nii_estado',
                'nii_usu_crea',
                'nii_fecha_crea',
                'nii_usu_mod',
                'nii_fecha_mod'
            );

            $crud->set_table('nii_nivel_idioma')
                    ->set_subject('Nivel lingüístico')
                    ->columns($columnas)
                    ->display_as($alias)
                    ->add_fields($columnas_insert)
                    ->edit_fields($columnas_update)
                    ->required_fields($required)
                    ->set_rules('nii_nombre', 'Nombre', 'trim|required|campo_unico[nii_nivel_idioma.nii_nombre]')
                    ->field_type('nii_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('nii_fecha_mod', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('nii_fecha_crea', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('nii_usu_crea', 'hidden', $this->tank_auth->get_user_id())
            ;

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('nii_estado', 'hidden', 1);
            } else {
                $crud->field_type('nii_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Gestión de nivel lingüístico";
            $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'registro_academico/mantenimientos/nivel_idioma';
            cargarvista($data, $output, $ruta_vista);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /*
    *   Funcionalidad Compartida con el modulo de seleccion de personal - Mantenimientos
    *    Funcionalidad Compartida con el modulo de expediente de personal - Catalogos
    */
    public function idiomas() {
        satelite_validar();
        try {

            satelite_validar();

            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $columnas = array(
                'idm_nombre',
                'idm_estado'
            );

            $required = array(
                'idm_nombre',
                'idm_estado'
            );

            $alias = array(
                'idm_nombre' => 'Nombre',
                'idm_estado' => 'Estado'
            );

            $columnas_insert = array(
                'idm_nombre',
                'idm_estado',
                'idm_usu_crea',
                'idm_fecha_crea',
                'idm_usu_mod',
                'idm_fecha_mod'
            );

            $columnas_update = array(
                'idm_nombre',
                'idm_estado',
                'idm_usu_crea',
                'idm_fecha_crea',
                'idm_usu_mod',
                'idm_fecha_mod'
            );

            $crud->set_table('idm_idioma')
                    ->set_subject('Idioma')
                    ->columns($columnas)
                    ->display_as($alias)
                    ->add_fields($columnas_insert)
                    ->edit_fields($columnas_update)
                    ->required_fields($required)
                    ->set_rules('idm_nombre', 'Nombre', 'trim|required|campo_unico[idm_idioma.idm_nombre]')
                    ->field_type('idm_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('idm_fecha_mod', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('idm_fecha_crea', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('idm_usu_crea', 'hidden', $this->tank_auth->get_user_id())
            ;

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('idm_estado', 'hidden', 1);
            } else {
                $crud->field_type('idm_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            } 

            $output = $crud->render();
            $data['titulo_personal'] = "Gestión de idioma";
            cargarvista($data, $output, "registro_academico/mantenimientos/idiomas");
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function financiamiento($id_area = 0) {
        satelite_validar();
        try {
            $crud = new grocery_CRUD();
            $columnas = array(
                'fin_nombre',
                'fin_estado'
            );

            $required = array(
                'fin_nombre',
                'fin_estado'
            );

            $alias = array(
                'fin_nombre' => 'Nombre',
                'fin_estado' => 'Estado'
            );

            $columnas_insert = array(
                'fin_nombre',
                'fin_estado',
                'fin_usu_crea',
                'fin_usu_mod',
                'fin_fecha_crea',
                'fin_fecha_mod'
            );

            $columnas_update = array(
                'fin_nombre',
                'fin_estado',
                'fin_usu_crea',
                'fin_usu_mod',
                'fin_fecha_crea',
                'fin_fecha_mod'
            );

            $crud->set_table('fin_financiamiento')
                    ->set_subject('Financiamiento')
                    ->columns($columnas)
                    ->display_as($alias)
                    ->add_fields($columnas_insert)
                    ->edit_fields($columnas_update)
                    ->required_fields($required)
                    ->set_rules('fin_nombre', 'Nombre', 'trim|required|campo_unico[idm_idioma.idm_nombre]')
                    ->field_type('fin_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('fin_fecha_mod', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('fin_fecha_crea', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('fin_usu_crea', 'hidden', $this->tank_auth->get_user_id())
            ;

            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('fin_estado', 'hidden', 1);
            } else {
                $crud->field_type('fin_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $output = $crud->render();

            $data['titulo_personal'] = "Gestión de financiamiento";

            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function tipo_educacion($value = null) {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();

            // if ($value != null) {
            //     $permisos = $value;
            // } else {
            //     $permisos = $this->gsatelite->get_permisos_opcion('registro_academico/mantenimientos/tipo_educacion');
            // }

            $columnas = array(
                'tie_nombre',
                'tie_estado'
            );

            $required = array(
                'tie_nombre',
                'tie_estado'
            );

            $alias = array(
                'tie_nombre' => 'Nombre',
                'tie_estado' => 'Estado'
            );

            $columnas_insert = array(
                'tie_nombre',
                'tie_estado',
                'tie_usu_crea',
                'tie_fecha_crea',
                'tie_usu_mod',
                'tie_fecha_mod'
            );

            $columnas_update = array(
                'tie_nombre',
                'tie_estado',
                'tie_usu_crea',
                'tie_fecha_crea',
                'tie_usu_mod',
                'tie_fecha_mod'
            );

            $crud->set_table('tie_tipo_educacion')
                    ->set_subject('Tipo de educación')
                    ->columns($columnas)
                    ->display_as($alias)
                    ->add_fields($columnas_insert)
                    ->edit_fields($columnas_update)
                    ->required_fields($required)
                    ->set_rules('tie_nombre', 'Nombre', 'trim|required|campo_unico[tie_tipo_educacion.tie_nombre]')
                    ->field_type('tie_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('tie_fecha_mod', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('tie_fecha_crea', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('tie_usu_crea', 'hidden', $this->tank_auth->get_user_id())
            ;

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tie_estado', 'hidden', 1);
            } else {
                $crud->field_type('tie_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            //permisos
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if(!$permisos["permite_ver"]){
                $crud->unset_read();
            }else{
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Gestión de tipo de educación";
            $this->_cargarvista($data, $output, 'registro_academico/mantenimientos/tipo_educacion');

        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function duplicar_grupo($id_grupo = null) {
        satelite_validar();
        $cantidad = 0;
        $ajax = false;
        if ($id_grupo == null) {
            $ajax = true;
            $id_grupo = $this->input->post('id_grupo');
            $cantidad = $this->input->post('cantidad');
        } else {
            $id_grupo = $id_grupo;
            $cantidad = 1;
        }

        $this->gsatelite->verificar_registro_real('gra_grupo_academico', $id_grupo);
        $reg = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id' => $id_grupo));
        $reg = $reg[0];

        $aul = $this->gsatelite->get_campo('aul_aula', 'aul_id', array('aul_id' => $reg['gra_id_aul']));
        if (count($aul) > 0) {
            $aula = $reg['gra_id_aul'];
        } else {
            $aula = null;
        }

        $dct = $this->gsatelite->get_campo('dct_docente', 'dct_id', array('dct_id' => $reg['gra_id_dct']));
        if (count($dct) > 0) {
            $docente = $reg['gra_id_dct'];
        } else {
            $docente = null;
        }

        $pen = $this->gsatelite->get_campo('pen_pensum', 'pen_id', array('pen_id' => $reg['gra_id_pen']));
        if (count($pen) > 0) {
            $pensum = $reg['gra_id_pen'];
        } else {
            $pensum = null;
        }

        $exito = 0;
        $tipo = $this->gsatelite->get_parametro('SYS_TIPO_ARTICULO');
        for ($i = 0; $i < $cantidad; $i++) {

            //Se ingresa el articulo a la base de datos.
            /*$array_art = array(
                'art_id_tia' => $tipo,
                'art_nombre' => $reg['gra_nombre'],
                'art_descripcion' => ($reg['gra_descripcion']) ? $reg['gra_descripcion'] : null,
                'art_fecha' => date('Y-m-d H:i:s'),
                'art_compra' => 0,
                'art_inventario' => 0,
                'art_venta' => 0,
                'art_estado' => 1,
                'art_usu_mod' => $this->tank_auth->get_user_id(),
                'art_fecha_mod' => date('Y-m-d H:i:s'),
            );
            $art_id = $this->gsatelite->ingresar('art_articulo', $array_art);*/

            $detalle = array(
                'gra_id_aul' => $aula,
                'gra_id_dct' => $docente,
                'gra_id_pen' => $pensum,
                //'gra_id_art' => $art_id,
                'gra_nombre' => $reg['gra_nombre'],
                'gra_descripcion' => $reg['gra_descripcion'],
                //'gra_fecha_inicio' => $reg['gra_fecha_inicio'],
                //'gra_fecha_fin' => $reg['gra_fecha_fin'],
                //'gra_fecha_peruno' => $reg['gra_fecha_perdos'],
                //'gra_fecha_perdos' => $reg['gra_fecha_perdos'],
                'gra_id_hrg' => $reg['gra_id_hrg'],
                'gra_estado' => $reg['gra_estado'],
                'gra_usu_crea' => $this->tank_auth->get_user_id(),
                'gra_fecha_crea' => date('Y-m-d H:i:s'),
                'gra_usu_mod' => $this->tank_auth->get_user_id(),
                'gra_fecha_mod' => date('Y-m-d H:i:s'),
                'gra_cupo' => $reg['gra_cupo'],
                'gra_fecha_nota' => $reg['gra_fecha_nota']
            );
            $id = $this->gsatelite->ingresar('gra_grupo_academico', $detalle);
            $grupoxuni_reg = $this->gsatelite->get_tabla('uxg_uni_grupo', array('uxg_id_gra' =>$id_grupo));
            if((count($grupoxuni_reg) > 0)){
                foreach ($grupoxuni_reg as $key) {
                    $info = array(
                        'uxg_id_gra' => $id,
                        'uxg_id_unm' => $key['uxg_id_unm'],
                        'uxg_estado' => 1,
                        'uxg_usu_creacion' => $this->tank_auth->get_user_id(),
                        'uxg_fecha_creacion' => date('Y-m-d H:i:s'),
                        'uxg_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'uxg_fecha_modificacion' => date('Y-m-d H:i:s'),
                    );
                    $this->gsatelite->ingresar('uxg_uni_grupo', $info);
                }
            }

            if ($id > 0) {
                $exito++;
            }
        }
        if ($exito > 0) {
            $alerta = array(
                'tipo_alerta' => 'success'
                , 'titulo_alerta' => 'Éxito'
                , 'texto_alerta' => "<b>$exito</b> Nuevo(s) grupo(s) duplicado(s) con éxito."
            );
            $this->session->set_flashdata($alerta);
        }
        if ($ajax) {
            echo json_encode(array('exito' => $exito));
            die();
        } else {

            if ($id > 0) {
                $this->gsatelite->show_dialog('Nuevo grupo ingresado con éxito.', 'registro_academico/mantenimientos/gestion_grupos');
            } else {
                $this->gsatelite->show_dialog('Error al duplicar grupo', 'registro_academico/mantenimientos/gestion_grupos', 'error');
            }
        }
    }

    function horario_grupo() {
        satelite_validar();
        $permisos           = $this->gsatelite->get_permisos_opcion();
        $crud               = new grocery_CRUD();
        $horarioxarea_array = array(
            'hxr_estado'            => 1,
            'hxr_usu_creacion'      => $this->tank_auth->get_user_id(),
            'hxr_fecha_creacion'    => date('Y-m-d H:i:s'),
            'hxr_usu_modificacion'  => $this->tank_auth->get_user_id(),
            'hxr_fecha_modificacion'=> date('Y-m-d H:i:s')
        );

        $columns = array(
            'hrg_inicio',
            'hrg_fin',
            'area',
            'hrg_observacion', 
            'hrg_estado'
        );

        $alias = array(
            'hrg_inicio'        => 'Inicio',
            'hrg_fin'           => 'Fin',
            'area'              => 'Área',
            'hrg_estado'        => 'Estado',
            'hrg_observacion'   => 'Observación',
        );    
        
        $add_fields= array(
            'hrg_inicio', 
            'hrg_fin',
            'area', 
            'hrg_observacion',
            'hrg_usu_creacion',
            'hrg_usu_modificacion',
            'hrg_fecha_creacion',
            'hrg_fecha_modificacion',
            'hrg_estado'
        );

        $edit_fields= array(
            'hrg_inicio', 
            'hrg_fin',
            'area', 
            'hrg_observacion',
            'hrg_usu_creacion',
            'hrg_usu_modificacion',
            'hrg_fecha_creacion',
            'hrg_fecha_modificacion',
            'hrg_estado'
        );
        
        $required = array(
            'hrg_inicio',             
            'hrg_fin', 
            'area',
            'hrg_estado'
        );
    
        $crud->set_table('hrg_horario_grupo')
                ->set_subject('Horario grupo')
                ->columns($columns)
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->display_as($alias)           
                ->required_fields($required)
             
                ->field_type('hrg_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('hrg_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                ->field_type('hrg_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
                ->field_type('hrg_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->set_relation_n_n('area', 'hxr_horarioxarea', 'ard_area_academica', 'hxr_id_hrg', 'hxr_id_ard', '{ard_nombre}',null ,null, $horarioxarea_array)
                ->set_rules('hrg_fin','Fin','trim|callback_validar_rango_hora_grupo|required')
                ->callback_after_insert(array($this,'insertar_auditoria'))
                ->callback_after_update(array($this,'insertar_auditoria_mod'))
                ->callback_before_insert(function($post_array) {
                    $post_array['hrg_inicio'] = date('H:i:s', strtotime($post_array['hrg_inicio']));
                    $post_array['hrg_fin'] = date('H:i:s', strtotime($post_array['hrg_fin']));
                    return $post_array;
                })
                ->callback_before_update(function($post_array, $primary_key) {
                    $post_array['hrg_inicio'] = date('H:i:s', strtotime($post_array['hrg_inicio']));
                    $post_array['hrg_fin'] = date('H:i:s', strtotime($post_array['hrg_fin']));
                    return $post_array;
                })
                ->callback_column('hrg_inicio', function($value, $row) {
                    if ($value != "") {
                        return date("h:i A", strtotime($value));
                    }
                })
                ->callback_column('hrg_fin', function($value, $row) {
                    if ($value != "") {
                        return date("h:i A", strtotime($value));
                    }
                })
        ;
        $urlx= explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->field_type('hrg_estado', 'hidden', 1);
        } else {
            $crud->field_type('hrg_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if(!$permisos["permite_editar"]) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Gestión de disponibilidad de horarios";

        $this->_cargarvista($data, $output);
    }

    function get_moduloxarea() {
        satelite_validar();

        $area = $this->input->post('area');

        $mod = $this->registro_academico_model->get_moduloxarea($area);
        if ($area == "") {
            $where_horario = null;
        } else {
            $where_horario = array('ard_id' => $area);
        }
        $hrg = $this->registro_academico_model->get_horarioxarea($where_horario);

        $options = '<option value=""></option>';
        foreach ($mod as $key) {
            $options .= '<option value="' . $key["mod_id"] . '" >' . $key["mod_nombre"] . '</option>';
        }

        $opciones["nivels"] = $options;
        $options = '<option value=""></option>';
        foreach ($hrg as $key) {
            $hora_ini = date("h:i A", strtotime($key['hrg_inicio']));
            $hora_fin = date("h:i A", strtotime($key['hrg_fin']));
            $options .= '<option value="' . $key["hrg_id"] . '" >' . $hora_ini . ' - ' . $hora_fin . '</option>';
        }
        $opciones["horarios"] = $options;


        echo json_encode($opciones);
    }

    public function unidades_grupo($id_area = 0) {
        satelite_validar();
        try {
            $crud = new grocery_CRUD();


            $columnas = array(
                'unm_codigo',
                'unm_nombre',
                'unm_estado'
            );

            $required = array(
                'unm_codigo',
                'unm_nombre',
                'unm_estado'
            );

            $alias = array(
                'unm_codigo' => 'C&oacute;digo',
                'unm_nombre' => 'Nombre',
                'unm_estado' => 'Estado'
            );

            $columnas_insert = array(
                'unm_codigo',
                'unm_nombre',
                'unm_estado',
                'unm_usu_creacion',
                'unm_fecha_creacion',
                'unm_usu_modificacion',
                'unm_fecha_modificacion'
            );

            $columnas_update = array(
                'unm_codigo',
                'unm_nombre',
                'unm_estado',
                'unm_usu_modificacion',
                'unm_fecha_modificacion'
            );

            $crud->set_table('unm_unidad_modulo')
                    ->set_subject('Unidades por materia')
                    ->columns($columnas)
                    ->display_as($alias)
                    ->add_fields($columnas_insert)
                    ->edit_fields($columnas_update)
                    ->required_fields($required)
                    //   ->set_relation('pen_id_mod','mod_modulo','mod_nombre',array('mod_estado'=>1))
                    //  ->set_relation_n_n( 'prerrequisito','pre_prerrequisito','mod_modulo','pre_id_pen','pre_id_mod','mod_nombre',null,array('mod_estado'=>1))
                    ->field_type('unm_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('unm_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('unm_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('unm_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                    // ->field_type('pen_fecha_creacion','hidden', date('Y-m-d h:i:s'))
                    // ->field_type('pen_usu_creacion','hidden',$this->tank_auth->get_user_id())
                    //  ->field_type('pen_id_ard','hidden',$id_area)
                    //  ->field_type('pre_usu_crea','hidden',$this->tank_auth->get_user_id())
                    //->set_rules('pen_id_mod','Materia','required|callback_revisarModulo')
                    ->set_rules('unm_nombre', 'Nombre', 'trim|required|campo_unico[unm_unidad_modulo.unm_nombre]')
            ;


            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('unm_estado', 'hidden', 1);
            } else {
                $crud->field_type('unm_estado', 'dropdown', array('1' => 'Activo', '2' => 'Inactivo'));
            }

            //  $crud->where('pen_id_ard', $id_area);

            $output = $crud->render();

            //   $data['area'] = $this->gsatelite->get_registro('ard_area_academica', array('ard_id' => $id_area));


            $data['titulo_personal'] = "Gestión unidades por materia";

            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    //Nota: catalogo compartido con expediente de personal==> controller: catalogos.php (function tipo_habilidad) //added by Rene Castaneda 07/12/2017
    function tipo_habilidades($vista=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();

            $crud = new grocery_CRUD();
            $crud->set_subject('Tipo de habilidad')->set_table('tih_tipo_habilidad');
            $crud->columns('tih_nombre', 'tih_descripcion', 'tih_estado');
            $crud->display_as('tih_nombre', 'Nombre')
                    ->display_as('tih_descripcion', 'Descripción')
                    ->display_as('tih_estado', 'Estado');
            $crud->add_fields('tih_nombre', 'tih_descripcion', 'tih_estado', 'tih_usu_modificacion', 'tih_fecha_modificacion', 'tih_usu_creacion', 'tih_fecha_creacion');
            $crud->edit_fields('tih_nombre', 'tih_descripcion', 'tih_estado', 'tih_usu_modificacion', 'tih_fecha_modificacion');
            $crud->required_fields('tih_nombre', 'tih_estado');
            $crud->set_rules('tih_nombre', 'nombre', 'trim|required|campo_unico[tih_tipo_habilidad.tih_nombre]');
            $crud->set_rules('tih_estado', 'estado', 'trim|required');
            $crud->field_type('tih_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tih_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tih_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('tih_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tih_estado', 'hidden', 1);
            } else {
                $crud->field_type('tih_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $vista1 = (is_array($vista) && trim($vista[1])!='')? $vista[1]:'registro_academico/mantenimientos/tipo_habilidades';
                $crud->add_action('&nbsp;&nbsp;Ver', '', "$vista1/read", 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Tipos de habilidades";
            $vista2 = (is_array($vista) && trim($vista[0])!='')? $vista[0]:'registro_academico/mantenimientos/tipo_habilidades';
            cargarvista($data, $output, $vista2);
            //$this->_cargarvista($data, $output);
        }
    }

    //Nota: catalogo compartido con expediente de personal==> controller: catalogos.php (function habilidad)  //added by Rene Castaneda 07/12/2017
    function habilidades($vista=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();

            $crud = new grocery_CRUD();
            $crud->set_subject('Habilidad')->set_table('hab_habilidad');
            $crud->columns('hab_nombre', 'hab_descripcion', 'hab_id_tih', 'hab_estado');
            $crud->display_as('hab_nombre', 'Nombre')
                    ->display_as('hab_descripcion', 'Descripción')
                    ->display_as('hab_id_tih', 'Tipo')
                    ->display_as('hab_estado', 'Estado');
            $crud->add_fields('hab_nombre', 'hab_descripcion', 'hab_id_tih', 'hab_estado', 'hab_usu_modificacion', 'hab_fecha_modificacion', 'hab_usu_creacion', 'hab_fecha_creacion');
            $crud->edit_fields('hab_nombre', 'hab_descripcion', 'hab_id_tih', 'hab_estado', 'hab_usu_modificacion', 'hab_fecha_modificacion');
            $crud->required_fields('hab_nombre', 'hab_estado');
            $crud->set_rules('hab_nombre', 'nombre', 'trim|required|campo_unico[hab_habilidad.hab_nombre]');
            $crud->set_rules('hab_estado', 'estado', 'trim|required');
            $crud->set_relation('hab_id_tih', 'tih_tipo_habilidad', 'tih_nombre', array('tih_estado' => 1));
            $crud->field_type('hab_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('hab_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('hab_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('hab_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('hab_estado', 'hidden', 1);
            } else {
                $crud->field_type('hab_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $vista1 = (is_array($vista) && trim($vista[1])!='')? $vista[1]:'registro_academico/mantenimientos/habilidades';
                $crud->add_action('&nbsp;&nbsp;Ver', '', "$vista1/read", 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Habilidades";
            //$this->_cargarvista($data, $output);
            $vista2 = (is_array($vista) && trim($vista[0])!='')? $vista[0]:'registro_academico/mantenimientos/habilidades';
            cargarvista($data, $output, $vista2);
        }
    }

    function grupo_habilidades() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('registro_academico/mantenimientos/grupo_habilidades');

            $crud = new grocery_CRUD();
            $crud->set_subject('Grupo de habilidades')->set_table('grh_grupo_habilidad');
            $crud->columns('grh_nombre', 'grh_descripcion', 'grh_id_hab', 'grh_estado');
            $crud->display_as('grh_nombre', 'Nombre')
                    ->display_as('grh_descripcion', 'Descripción')
                    ->display_as('grh_id_hab', 'Habilidad')
                    ->display_as('grh_estado', 'Estado');
            $crud->add_fields('grh_nombre', 'grh_descripcion', 'grh_id_hab', 'grh_estado', 'grh_usu_modificacion', 'grh_fecha_modificacion', 'grh_usu_creacion', 'grh_fecha_creacion');
            $crud->edit_fields('grh_nombre', 'grh_descripcion', 'grh_id_hab', 'grh_estado', 'grh_usu_modificacion', 'grh_fecha_modificacion');
            $crud->required_fields('grh_nombre', 'grh_estado', 'grh_id_hab');
            $crud->set_rules('grh_nombre', 'nombre', 'trim|required|campo_unico[grh_grupo_habilidad.grh_nombre]');
            $crud->set_rules('grh_estado', 'estado', 'trim|required');
            $crud->set_relation('grh_id_hab', 'hab_habilidad', 'hab_nombre', array('hab_estado' => 1));
            $crud->field_type('grh_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('grh_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('grh_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('grh_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('grh_estado', 'hidden', 1);
            } else {
                $crud->field_type('grh_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'registro_academico/mantenimientos/grupo_habilidades/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Grupos de habilidades";
            $this->_cargarvista($data, $output);
        }
    }

    function tipo_pasatiempo() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('registro_academico/mantenimientos/tipo_pasatiempo');

            $crud = new grocery_CRUD();
            $crud->set_subject('Pasatiempo')->set_table('pst_pasatiempo');
            $crud->columns('pst_nombre', 'pst_descripcion', 'pst_estado');
            $crud->display_as('pst_nombre', 'Nombre')
                    ->display_as('pst_descripcion', 'Descripción')
                    ->display_as('pst_estado', 'Estado');
            $crud->add_fields('pst_nombre', 'pst_descripcion', 'pst_estado', 'pst_usu_modificacion', 'pst_fecha_modificacion', 'pst_usu_creacion', 'pst_fecha_creacion');
            $crud->edit_fields('pst_nombre', 'pst_descripcion', 'pst_estado', 'pst_usu_modificacion', 'pst_fecha_modificacion');
            $crud->required_fields('pst_nombre', 'pst_estado');
            $crud->set_rules('pst_nombre', 'nombre', 'trim|required|campo_unico[pst_pasatiempo.pst_nombre]');
            $crud->set_rules('pst_estado', 'estado', 'trim|required');
            $crud->field_type('pst_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('pst_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('pst_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('pst_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('pst_estado', 'hidden', 1);
            } else {
                $crud->field_type('pst_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'registro_academico/mantenimientos/tipo_pasatiempo/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Pasatiempos";
            $this->_cargarvista($data, $output);
        }
    }

    function titulo_educacion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('registro_academico/mantenimientos/titulo_educacion');

            $crud = new grocery_CRUD();
            $crud->set_subject('Título educativo')->set_table('ted_titulo_educacion');
            $crud->columns('ted_nombre', 'ted_descripcion', 'ted_estado');
            $crud->display_as('ted_nombre', 'Nombre')
                    ->display_as('ted_descripcion', 'Descripción')
                    ->display_as('ted_estado', 'Estado');
            $crud->add_fields('ted_nombre', 'ted_descripcion', 'ted_estado', 'ted_usu_modificacion', 'ted_fecha_modificacion', 'ted_usu_creacion', 'ted_fecha_creacion');
            $crud->edit_fields('ted_nombre', 'ted_descripcion', 'ted_estado', 'ted_usu_modificacion', 'ted_fecha_modificacion');
            $crud->required_fields('ted_nombre', 'ted_estado');
            $crud->set_rules('ted_nombre', 'nombre', 'trim|required|campo_unico[ted_titulo_educacion.ted_nombre]');
            $crud->set_rules('ted_estado', 'estado', 'trim|required');
            $crud->field_type('ted_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('ted_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('ted_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('ted_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('ted_estado', 'hidden', 1);
            } else {
                $crud->field_type('ted_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'registro_academico/mantenimientos/titulo_educacion/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Títulos educativos";
            $this->_cargarvista($data, $output);
        }
    }

    function tipo_tratamiento() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('registro_academico/mantenimientos/tipo_tratamiento');

            $crud = new grocery_CRUD();
            $crud->set_subject('Tipo de tratamiento')->set_table('ttm_tipo_tratamiento');
            $crud->columns('ttm_nombre', 'ttm_descripcion', 'ttm_estado');
            $crud->display_as('ttm_nombre', 'Nombre')
                    ->display_as('ttm_descripcion', 'Descripción')
                    ->display_as('ttm_estado', 'Estado');
            $crud->add_fields('ttm_nombre', 'ttm_descripcion', 'ttm_estado', 'ttm_usu_modificacion', 'ttm_fecha_modificacion', 'ttm_usu_creacion', 'ttm_fecha_creacion');
            $crud->edit_fields('ttm_nombre', 'ttm_descripcion', 'ttm_estado', 'ttm_usu_modificacion', 'ttm_fecha_modificacion');
            $crud->required_fields('ttm_nombre', 'ttm_estado');
            $crud->set_rules('ttm_nombre', 'nombre', 'trim|required|campo_unico[ttm_tipo_tratamiento.ttm_nombre]');
            $crud->set_rules('ttm_estado', 'estado', 'trim|required');
            $crud->field_type('ttm_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('ttm_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('ttm_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('ttm_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('ttm_estado', 'hidden', 1);
            } else {
                $crud->field_type('ttm_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'registro_academico/mantenimientos/tipo_tratamiento/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Tipos de tratamientos";
            $this->_cargarvista($data, $output);
        }
    }

    function tipo_ingreso() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('registro_academico/mantenimientos/tipo_ingreso');

            $crud = new grocery_CRUD();
            $crud->set_subject('Tipo de ingreso')->set_table('tin_tipo_ingreso');
            $crud->columns('tin_nombre', 'tin_descripcion', 'tin_estado');
            $crud->display_as('tin_nombre', 'Nombre')
                    ->display_as('tin_descripcion', 'Descripción')
                    ->display_as('tin_estado', 'Estado');
            $crud->add_fields('tin_nombre', 'tin_descripcion', 'tin_estado', 'tin_usu_modificacion', 'tin_fecha_modificacion', 'tin_usu_creacion', 'tin_fecha_creacion');
            $crud->edit_fields('tin_nombre', 'tin_descripcion', 'tin_estado', 'tin_usu_modificacion', 'tin_fecha_modificacion');
            $crud->required_fields('tin_nombre', 'tin_estado');
            $crud->set_rules('tin_nombre', 'nombre', 'trim|required|campo_unico[tin_tipo_ingreso.tin_nombre]');
            $crud->set_rules('tin_estado', 'estado', 'trim|required');
            $crud->field_type('tin_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tin_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tin_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('tin_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tin_estado', 'hidden', 1);
            } else {
                $crud->field_type('tin_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'registro_academico/mantenimientos/tipo_ingreso/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Tipos de ingresos";
            $this->_cargarvista($data, $output);
        }
    }

    function tipo_transporte($ruta = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $ruta     = (trim($ruta) != '')? $ruta : 'registro_academico/mantenimientos';
            $data['ruta'] = $ruta;

            $display_as = array(
                'ttr_nombre'        => 'Nombre',
                'ttr_descripcion'   => 'Descripción',
                'ttr_estado'        => 'Estado'
            );

            $add_fields = array(
                'ttr_nombre', 
                'ttr_descripcion', 
                'ttr_estado', 
                'ttr_usu_modificacion', 
                'ttr_fecha_modificacion', 
                'ttr_usu_creacion', 
                'ttr_fecha_creacion'
            );

            $edit_fields = array(
                'ttr_nombre', 
                'ttr_descripcion', 
                'ttr_estado', 
                'ttr_usu_modificacion', 
                'ttr_fecha_modificacion'
            );

            $required = array(
                'ttr_nombre', 
                'ttr_estado'
            );

            $columns = array(
                'ttr_nombre', 
                'ttr_descripcion', 
                'ttr_estado'
            );

            $crud = new grocery_CRUD();
            $crud->set_subject('Tipo de transporte');
            $crud->set_table('ttr_tipo_transporte');
            $crud->columns($columns);
            $crud->display_as($display_as);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->required_fields($required);
            $crud->set_rules('ttr_nombre', 'nombre', 'trim|required|campo_unico[ttr_tipo_transporte.ttr_nombre]');
            $crud->set_rules('ttr_estado', 'estado', 'trim|required');
            $crud->field_type('ttr_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('ttr_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('ttr_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('ttr_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('ttr_estado', 'hidden', 1);
            } else {
                $crud->field_type('ttr_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Tipos de transporte";
            //$this->_cargarvista($data, $output);

            cargarvista($data, $output, 'registro_academico/mantenimientos/tipo_transporte');
        }
    }

    function estado_familiar() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('registro_academico/mantenimientos/estado_familiar');

            $crud = new grocery_CRUD();
            $crud->set_subject('Estado familiar')->set_table('esf_estado_familia');
            $crud->columns('esf_nombre', 'esf_descripcion', 'esf_estado');
            $crud->display_as('esf_nombre', 'Nombre')
                    ->display_as('esf_descripcion', 'Descripción')
                    ->display_as('esf_estado', 'Estado');
            $crud->add_fields('esf_nombre', 'esf_descripcion', 'esf_estado', 'esf_usu_modificacion', 'esf_fecha_modificacion', 'esf_usu_creacion', 'esf_fecha_creacion');
            $crud->edit_fields('esf_nombre', 'esf_descripcion', 'esf_estado', 'esf_usu_modificacion', 'esf_fecha_modificacion');
            $crud->required_fields('esf_nombre', 'esf_estado');
            $crud->set_rules('esf_nombre', 'nombre', 'trim|required|campo_unico[esf_estado_familia.esf_nombre]');
            $crud->set_rules('esf_estado', 'estado', 'trim|required');
            $crud->field_type('esf_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('esf_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('esf_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('esf_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('esf_estado', 'hidden', 1);
            } else {
                $crud->field_type('esf_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'registro_academico/mantenimientos/estado_familiar/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Estados familiares";
            $this->_cargarvista($data, $output);
        }
    }

    function estado_alumno() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('registro_academico/mantenimientos/estado_alumno');

            $crud = new grocery_CRUD();
            $crud->set_subject('Estado del alumno')->set_table('esa_estado_alumno');
            $crud->columns('esa_nombre', 'esa_descripcion', 'esa_estado');
            $crud->display_as('esa_nombre', 'Nombre')
                    ->display_as('esa_descripcion', 'Descripción')
                    ->display_as('esa_estado', 'Estado');
            $crud->add_fields('esa_nombre', 'esa_descripcion', 'esa_estado', 'esa_usu_modificacion', 'esa_fecha_modificacion', 'esa_usu_creacion', 'esa_fecha_creacion');
            $crud->edit_fields('esa_nombre', 'esa_descripcion', 'esa_estado', 'esa_usu_modificacion', 'esa_fecha_modificacion');
            $crud->required_fields('esa_nombre', 'esa_estado');
            $crud->set_rules('esa_nombre', 'nombre', 'trim|required|campo_unico[esa_estado_alumno.esa_nombre]');
            $crud->set_rules('esa_estado', 'estado', 'trim|required');
            $crud->field_type('esa_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('esa_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('esa_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('esa_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('esa_estado', 'hidden', 1);
            } else {
                $crud->field_type('esa_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'registro_academico/mantenimientos/estado_alumno/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Estados del alumno";
            $this->_cargarvista($data, $output);
        }
    }

    function grupo_familiar() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('registro_academico/mantenimientos/grupo_familiar');
            $crud = new grocery_CRUD();
            $crud->set_subject('Grupo familiar')->set_table('gfa_grupo_familiar');
            $crud->columns('gfa_nombre', 'gfa_estado');
            $crud->display_as('gfa_nombre', 'Nombre')
                    ->display_as('gfa_estado', 'Estado');
            $crud->add_fields('gfa_nombre', 'gfa_estado', 'gfa_usu_modificacion', 'gfa_fecha_modificacion', 'gfa_usu_creacion', 'gfa_fecha_creacion');
            $crud->edit_fields('gfa_nombre', 'gfa_estado', 'gfa_usu_modificacion', 'gfa_fecha_modificacion');
            $crud->required_fields('gfa_nombre', 'gfa_estado');
            $crud->set_rules('gfa_nombre', 'nombre', 'trim|required|campo_unico[gfa_grupo_familiar.gfa_nombre]');
            $crud->set_rules('gfa_estado', 'estado', 'trim|required');
            $crud->field_type('gfa_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('gfa_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('gfa_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('gfa_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('gfa_estado', 'hidden', 1);
            } else {
                $crud->field_type('gfa_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'registro_academico/mantenimientos/grupo_familiar/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Grupos familiares";
            $this->_cargarvista($data, $output);
        }
    }

    function agregar_grupo_familiar_modal(){

        satelite_validar();
        if($this->input->post()) {
                $nombre = (trim($this->input->post('txtNombre') != '')?$this->input->post('txtNombre'):'');
                $tipo_btn = $this->input->post('btnCrear');

                $datos_gfa = array(
                    'gfa_nombre' => $nombre,
                    'gfa_cantidad' => 0,
                    'gfa_estado' => 1,
                    'gfa_usu_creacion' => $this->tank_auth->get_user_id(),
                    'gfa_fecha_creacion' => date('Y-m-d H:i:s'),
                    'gfa_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'gfa_fecha_modificacion' => date('Y-m-d H:i:s') 
                );
                $consulta_gfa = $this->gsatelite->ingresar('gfa_grupo_familiar', $datos_gfa);

                $alerta = [
                    'tipo_alerta' => $consulta_gfa ? 'success' : 'error',
                    'titulo_alerta' => $consulta_gfa ? 'Éxito' : 'Error',
                    'texto_alerta' => $consulta_gfa ? 'Grupo familiar agregado correctamente' : 'El registro no pudo ser agregado'
                ];
                //$this->session->set_flashdata($alerta);

                if ($this->input->is_ajax_request()) {
                    
                    header('Content-Type: application/json');
                    echo json_encode([
                        'status' => $consulta_gfa ? 'success' : 'error',
                        'message' => $alerta['texto_alerta'],
                        'redirect' => ($consulta_gfa && $tipo_btn == 2) ? $this->http_referer() : null
                    ]);
                    exit;
                }

        } else {
            $this->session->unset_userdata(['tipo_alerta', 'titulo_alerta', 'texto_alerta']);
            $data['titulo_personal'] = "Grupos Familiares";
            $this->gsatelite->cargar_vista_masterpage('registro_academico/mantenimientos/agregar_grupo_familiar_modal', $data);
        }
        
    }

    function check_grupo_familiar_nombre() {
        $nombre = trim($this->input->post('nombre') ? $this->input->post('nombre'): '');
        $grupo_existente = $this->gsatelite->get_tabla('gfa_grupo_familiar', array('gfa_nombre' => $nombre));
        echo json_encode(['existente' => count($grupo_existente)]);
    }

    function http_referer() {
        $referer = $_SERVER['HTTP_REFERER'];
        if (strpos($referer, 'agregar_alumno') !== false) {
            return base_url('registro_academico/procesos/agregar_alumno');
        } elseif (strpos($referer, 'editar_alumno') !== false) {
            $alumno_id = $this->uri->segment(5);
            return base_url('registro_academico/procesos/editar_alumno/' . $alumno_id);
        }
        return null;
    }

    function motivo_eleccion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('registro_academico/mantenimientos/motivo_eleccion');

            $crud = new grocery_CRUD();
            $crud->set_subject('Motivo de elección')->set_table('cre_caracteristica_eleccion');
            $crud->columns('cre_nombre', 'cre_descripcion', 'cre_estado');
            $crud->display_as('cre_nombre', 'Nombre')
                    ->display_as('cre_descripcion', 'Descripción')
                    ->display_as('cre_estado', 'Estado');
            $crud->add_fields('cre_nombre', 'cre_descripcion', 'cre_estado', 'cre_usu_modificacion', 'cre_fecha_modificacion', 'cre_usu_creacion', 'cre_fecha_creacion');
            $crud->edit_fields('cre_nombre', 'cre_descripcion', 'cre_estado', 'cre_usu_modificacion', 'cre_fecha_modificacion');
            $crud->required_fields('cre_nombre', 'cre_estado');
            $crud->set_rules('cre_nombre', 'nombre', 'trim|required|campo_unico[cre_caracteristica_eleccion.cre_nombre]');
            $crud->set_rules('cre_estado', 'estado', 'trim|required');
            $crud->field_type('cre_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('cre_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('cre_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('cre_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('cre_estado', 'hidden', 1);
            } else {
                $crud->field_type('cre_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'registro_academico/mantenimientos/motivo_eleccion/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Motivos de elección";
            $this->_cargarvista($data, $output);
        }
    }

    function religion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('registro_academico/mantenimientos/religion');

            $crud = new grocery_CRUD();
            $crud->set_subject('Religion')->set_table('rel_religion');
            $crud->columns('rel_nombre', 'rel_descripcion', 'rel_estado');
            $crud->display_as('rel_nombre', 'Nombre')
                    ->display_as('rel_descripcion', 'Descripción')
                    ->display_as('rel_estado', 'Estado');
            $crud->add_fields('rel_nombre', 'rel_descripcion', 'rel_estado', 'rel_usu_modificacion', 'rel_fecha_modificacion', 'rel_usu_creacion', 'rel_fecha_creacion');
            $crud->edit_fields('rel_nombre', 'rel_descripcion', 'rel_estado', 'rel_usu_modificacion', 'rel_fecha_modificacion');
            $crud->required_fields('rel_nombre', 'rel_estado');
            $crud->set_rules('rel_nombre', 'nombre', 'trim|required|campo_unico[rel_religion.rel_nombre]');
            $crud->set_rules('rel_estado', 'estado', 'trim|required');
            $crud->field_type('rel_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('rel_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('rel_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('rel_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('rel_estado', 'hidden', 1);
            } else {
                $crud->field_type('rel_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'registro_academico/mantenimientos/religion/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Religiones";
            $this->_cargarvista($data, $output);
        }
    }

    function zona() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('registro_academico/mantenimientos/zona');

            $crud = new grocery_CRUD();
            $crud->set_subject('Zona')->set_table('zon_zona');
            $crud->columns('zon_nombre', 'zon_descripcion', 'zon_estado');
            $crud->display_as('zon_nombre', 'Nombre')
                    ->display_as('zon_descripcion', 'Descripción')
                    ->display_as('zon_estado', 'Estado');
            $crud->add_fields('zon_nombre', 'zon_descripcion', 'zon_estado', 'zon_usu_modificacion', 'zon_fecha_modificacion', 'zon_usu_creacion', 'zon_fecha_creacion');
            $crud->edit_fields('zon_nombre', 'zon_descripcion', 'zon_estado', 'zon_usu_modificacion', 'zon_fecha_modificacion');
            $crud->required_fields('zon_nombre', 'zon_estado');
            $crud->set_rules('zon_nombre', 'nombre', 'trim|required|campo_unico[zon_zona.zon_nombre]');
            $crud->set_rules('zon_estado', 'estado', 'trim|required');
            $crud->field_type('zon_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('zon_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('zon_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('zon_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('zon_estado', 'hidden', 1);
            } else {
                $crud->field_type('zon_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'registro_academico/mantenimientos/zona/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Zonas";
            $this->_cargarvista($data, $output);
        }
    }

    function red_social() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('registro_academico/mantenimientos/red_social');

            $crud = new grocery_CRUD();
            $crud->set_subject('Red social')->set_table('res_red_social');
            $crud->columns('res_nombre', 'res_descripcion', 'res_estado');
            $crud->display_as('res_nombre', 'Nombre')
                    ->display_as('res_descripcion', 'Descripción')
                    ->display_as('res_estado', 'Estado');
            $crud->add_fields('res_nombre', 'res_descripcion', 'res_estado', 'res_usu_modificacion', 'res_fecha_modificacion', 'res_usu_creacion', 'res_fecha_creacion');
            $crud->edit_fields('res_nombre', 'res_descripcion', 'res_estado', 'res_usu_modificacion', 'res_fecha_modificacion');
            $crud->required_fields('res_nombre', 'res_estado');
            $crud->set_rules('res_nombre', 'nombre', 'trim|required|campo_unico[res_red_social.res_nombre]');
            $crud->set_rules('res_estado', 'estado', 'trim|required');
            $crud->field_type('res_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('res_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('res_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('res_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('res_estado', 'hidden', 1);
            } else {
                $crud->field_type('res_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'registro_academico/mantenimientos/red_social/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Redes sociales";
            $this->_cargarvista($data, $output);
        }
    }

    public function maximo_alumnos() {
        $id_aula = $this->input->post('aula');
        $aula = $this->gsatelite->get_campo('aul_aula', 'aul_capacidad', array('aul_id' => $id_aula));
        $minimo = round($aula/2);
        echo json_encode(array('cupo' => $aula,'minimo'=>$minimo));
    }

    public function validar_cupo() {

        $id_aula = $this->input->post('aula');
        $cupo = $this->input->post('capacidad');

        $aula = $this->gsatelite->get_campo('aul_aula', 'aul_capacidad', array('aul_id' => $id_aula));

        if ($cupo > $aula) {
            echo json_encode(array('cupo' => 1));
        } else {
            echo json_encode(array('cupo' => 0));
        }
    }

    /**
     * @author Edith Herrera
     * @since 2017-10-16
     * @return Mantenimiento de recesos.
    * */
    function horario_receso() {
        satelite_validar();

        $permisos = $this->gsatelite->get_permisos_opcion();

        $crud = new grocery_CRUD();
        $crud->set_table('hrc_horario_receso')
                ->set_subject('Receso')
                ->columns('hrc_codigo', 'hrc_inicio', 'hrc_fin', 'hrc_estado')
                ->add_fields('hrc_codigo', 'hrc_inicio', 'hrc_fin', 'hrc_usu_creacion', 'hrc_usu_modificacion', 'hrc_fecha_creacion', 'hrc_fecha_modificacion', 'hrc_estado')
                ->edit_fields('hrc_codigo', 'hrc_inicio', 'hrc_fin', 'hrc_estado', 'hrc_usu_modificacion', 'hrc_fecha_modificacion')
                ->display_as('hrc_inicio', 'Inicio')
                ->display_as('hrc_fin', 'Fin')
                ->display_as('hrc_codigo', 'Código')
                ->display_as('hrc_estado', 'Estado')
                ->required_fields('hrc_inicio', 'hrc_fin', 'hrc_estado')
                ->field_type('hrc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('hrc_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                ->field_type('hrc_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
                ->field_type('hrc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->set_rules('hrc_fin','Fin','trim|callback_validacion_rango|required')
                ;
                // FORMATEAR HORAS PARA GUARDAR EN BASE DE DATOS.
                $crud->callback_before_insert(function($post_array, $primary_key) {
                    $post_array['hrc_inicio'] = date('H:i:s', strtotime($post_array['hrc_inicio']));
                    $post_array['hrc_fin'] = date('H:i:s', strtotime($post_array['hrc_fin']));
                    return $post_array;
                });

               $crud->callback_before_update(function($post_array, $primary_key) {
                    $post_array['hrc_inicio'] = date('H:i:s', strtotime($post_array['hrc_inicio']));
                    $post_array['hrc_fin'] = date('H:i:s', strtotime($post_array['hrc_fin']));
                    return $post_array;
                });
                // FORMATEAR HORAS PARA MOSTRAR EN COLUMNAS
                $crud->callback_column('hrc_inicio', function($value, $row) {
                    if ($value != "") {
                        return date("h:i A", strtotime($value));
                    }
                });
                $crud->callback_column('hrc_fin', function($value, $row) {
                    if ($value != "") {
                        return date("h:i A", strtotime($value));
                    }
                });
        
                $crud->callback_add_field('hrc_codigo', function () {
                    $tabla='hrc_horario_receso';
                    $campo='hrc_codigo';
                    $last=$this->consultas->get_max_codigo($tabla,$campo);

                    $code=$last->codigo;
                    $cod= (int)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

                    return '<input id="field-hrc_codigo" name="hrc_codigo" type="text" readonly maxlength="99" value="'.$codigo.'" >';
                });

                // AGREGAR EL CÓDIGO SEGÚN CORRELATIVO.
                $crud->callback_edit_field('hrc_codigo', function ($value, $primary_key) {
                    if($value==''){
                      $tabla='hrc_horario_receso';
                      $campo='hrc_codigo';
                      $last=$this->consultas->get_max_codigo($tabla,$campo);

                      $code=$last->codigo;
                      $cod= (int)$code+1;
                      $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                      return '<input id="field-hrc_codigo" name="hrc_codigo" type="text" readonly maxlength="99" value="'.$codigo.'" >';
                    }else{
                       return '<input id="field-hrc_codigo" name="hrc_codigo" type="text" readonly maxlength="99" value="'.$value.'" >';
                    }
                });

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('hrc_estado', 'hidden', 1);
            } else {
                $crud->field_type('hrc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }

        $output = $crud->render();
        $data['titulo_personal'] = "Recesos";
        $this->_cargarvista($data, $output);
    }

     /**
     * @author Edith Herrera
     * @since 2017-10-16
     * @return validación de rangos de horas para los recesos.
    * */
     public function validacion_rango($data) {
        if( $data != '' ) {
            $validado1=false; //variable que cambiará de valor cuando no se cumpla una condición de validación
            $validado2=false; //variable que cambiará de valor cuando no se cumpla la segunda condición de validación
            $f1=$this->input->post('hrc_inicio');
            $f2=$this->input->post('hrc_fin');
            $h1 = formatear_fecha('H:i:s', $this->input->post('hrc_inicio'));
            $h2 = formatear_fecha('H:i:s', $this->input->post('hrc_fin'));            
            if($h1<$h2){ 
                $validado1 = true; 
            }else{ 
                $this->form_validation->set_message('validacion_rango', 'Debe verificar el rango de horas.');
                return false; 
            }

            //PREGUNTAR SI EXISTEN REGISTROS IGUALES. 
            $url_array = explode('/', uri_string());//en el caso de edit
            $no_incluir = (is_numeric(end($url_array)) and end($url_array)>0 )? end($url_array):0;
            $pregunta = $this->gsatelite->get_tabla('hrc_horario_receso',array('hrc_id !='=>$no_incluir, 'hrc_inicio'=>date('H:i:s', strtotime($f1)), 'hrc_fin'=>date('H:i:s', strtotime($f2))));
            if(count($pregunta)>0){
                $this->form_validation->set_message('validacion_rango', 'El período seleccionado ya existe.');
                return false; 
            } else {
               $validado2=true; 
            }
            return ($validado1 and $validado2)? true:false;
        }else {
            return true;
        }
    }

    /**
     * @return validación de rangos de horarios para los grupos.
    * */
    public function validar_rango_hora_grupo($data) {
        if( $data != '' ){
            $valido1 = $valido2 = false; //variable que cambiará de valor cuando no se cumpla la segunda condición de validación
            $h1 = formatear_fecha('H:i:s', $this->input->post('hrg_inicio'));
            $h2 = formatear_fecha('H:i:s', $this->input->post('hrg_fin'));
            if($h1 < $h2){ 
                $validado1=true; 
            }else{ 
                $this->form_validation->set_message('validar_rango_hora_grupo', 'Debe verificar el rango de horas.');
                    return false; 
            }
           //PREGUNTAR SI EXISTEN REGISTROS IGUALES. 
            $url_array = explode('/', uri_string());//en el caso de edit
            $idno = (is_numeric(end($url_array)) and end($url_array)>0 )? end($url_array):0;   
            $pregunta = $this->gsatelite->get_tabla('hrg_horario_grupo', array('hrg_id !='=>$idno, 'hrg_inicio'=>date('H:i:s', strtotime($h1)), 'hrg_fin'=>date('H:i:s', strtotime($h2))));
        
            if(count($pregunta)>0){
                $this->form_validation->set_message('validar_rango_hora_grupo', 'El período seleccionado ya existe.');
                return false; 
            }
            else {
               $validado2=true; 
            }

           return ($validado1 and $validado2)? true:false;

        }else {
            return true;
        }
    }
  

    /**
     * @author Edith Herrera
     * @since 2017-10-18
     * @return Grid del mantenimiento de supervisores.
    * */
    function supervisores() {
        satelite_validar();

       $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

       $add_fields= array(
            'sug_id_emp',
            'sug_estado',
            'sug_usu_creacion',
            'sug_fecha_creacion',
            'sug_usu_modificacion',
            'sug_fecha_modificacion'
        );

       $edit_fields= array(
            'sug_id_emp',
            'sug_estado',
            'sug_usu_modificacion',
            'sug_fecha_modificacion'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('sug_supervisor_grupo')
                ->set_subject('Supervisor / Coordinador')
                ->columns('sug_id_emp', 'sug_estado')
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($edit_fields)
                ->display_as('sug_id_emp', 'Empleado')
                ->display_as('sug_estado', 'Estado')  
                ->set_relation('sug_id_emp', 'emp_empleado', '{emp_nombre} {emp_apellido}', array('emp_estado' => '1'))
                ->field_type('sug_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('sug_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('sug_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('sug_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('sug_id_emp', 'Empleado', 'trim|required|campo_unico[sug_supervisor_grupo.sug_id_emp]')
        ;    
   
     
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('sug_estado', 'hidden', 1);
        } else {
            $crud->field_type('sug_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }


        $output = $crud->render();

        $data['titulo_personal'] = "Supervisores / Coordinadores";

        $this->_cargarvista($data, $output);
    }

/**
     * @author Edith Herrera
     * @since 2017-10-18
     * @return Grid del mantenimiento de secciones.
    * */
    function secciones() {
        satelite_validar();

       $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

       $add_fields= array(
            'scc_codigo',
            'scc_nombre',
            'scc_estado',
            'scc_usu_creacion',
            'scc_fecha_creacion',
            'scc_usu_modificacion',
            'scc_fecha_modificacion'
        );

       $edit_fields= array(
            'scc_codigo',
            'scc_nombre',
            'scc_estado',
            'scc_usu_modificacion',
            'scc_fecha_modificacion'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('scc_seccion')
                ->set_subject('Secciones')
                ->columns('scc_codigo', 'scc_nombre','scc_estado')
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($edit_fields)
                ->display_as('scc_codigo', 'Código')
                ->display_as('scc_nombre', 'Nombre')
                ->display_as('scc_estado', 'Estado')  
                ->field_type('scc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('scc_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('scc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('scc_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('scc_nombre', 'Nombre', 'trim|required|campo_unico[scc_seccion.scc_nombre]')
        ;       

                // AGREGAR EL CÓDIGO SEGÚN CORRELATIVO.
                $crud->callback_add_field('scc_codigo', function () {
                    $tabla='scc_seccion';
                    $campo='scc_codigo';
                    $last=$this->consultas->get_max_codigo($tabla,$campo);

                    $code=$last->codigo;
                    $cod= (int)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

                    return '<input id="field-scc_codigo" name="scc_codigo" type="text" readonly maxlength="99" value="'.$codigo.'" >';
                });

                $crud->callback_edit_field('scc_codigo', function ($value, $primary_key) {
                    if($value==''){
                      $tabla='scc_seccion';
                      $campo='scc_codigo';
                      $last=$this->consultas->get_max_codigo($tabla,$campo);

                      $code=$last->codigo;
                      $cod= (int)$code+1;
                      $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                      return '<input id="field-scc_codigo" name="scc_codigo" type="text" readonly maxlength="99" value="'.$codigo.'" >';
                    }else{
                       return '<input id="field-scc_codigo" name="scc_codigo" type="text" readonly maxlength="99" value="'.$value.'" >';
                    }
                });

                $state = $crud->getState();
                if($state== 'success'){
                    $crud->callback_field('scc_codigo', function ($value, $primary_key) {
                        if($value==''){
                          $tabla='scc_seccion';
                          $campo='scc_codigo';
                          $last=$this->consultas->get_max_codigo($tabla,$campo);

                          $code=$last->codigo;
                          $cod= (int)$code+1;
                          $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                          return '<input id="field-scc_codigo" name="scc_codigo" type="text" readonly maxlength="99" value="'.$codigo.'" >';
                        }else{
                           return '<input id="field-scc_codigo" name="scc_codigo" type="text" readonly maxlength="99" value="'.$value.'" >';
                        }
                    });
                }
     
        $urlx= explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->field_type('scc_estado', 'hidden', 1);
        } else {
            $crud->field_type('scc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }


        $output = $crud->render();

        $data['titulo_personal'] = "Secciones";

        $this->_cargarvista($data, $output);
    }

      /**
     * @author Edith Herrera
     * @since 2017-10-19
     * @return Grid del mantenimiento de frecuencias.
    * */
    function frecuencia() {
        satelite_validar();

        $permisos = $this->gsatelite->get_permisos_opcion();

        $crud = new grocery_CRUD();
        $crud->set_table('frh_frecuencia_horario')
                ->set_subject('Frecuencia')
                ->columns('frh_codigo', 'frh_nombre', 'frh_id_ard', 'frh_descripcion','frh_estado')
                ->display_as('frh_codigo', 'Código')
                ->display_as('frh_nombre', 'Nombre')
                ->display_as('frh_id_ard', 'Área')
                ->display_as('frh_descripcion', 'Descripción')
                ->display_as('frh_estado', 'Estado')
                ->callback_column('frh_id_ard', function ($value, $row) {
                    if(isset($value)) {
                    
                        $this->db->join('ard_area_academica', 'ard_id = frh_id_ard');
                        $registro = $this->gsatelite->get_registro('frh_frecuencia_horario', 'frh_id', $row->frh_id);

                        return $registro->ard_nombre; 

                    } else {

                        $sql = "SELECT FRH.frh_id, GROUP_CONCAT(ARD.ard_nombre SEPARATOR ', ') as areas FROM frh_frecuencia_horario FRH
                            INNER JOIN fxa_frecuenciaxarea FXA ON FXA.fxa_id_frh = FRH.frh_id
                            INNER JOIN ard_area_academica ARD ON ARD.ard_id = FXA.fxa_id_ard
                            WHERE FRH.frh_id = ".$row->frh_id." GROUP BY FRH.frh_id";
                        
                        return $this->db->query($sql)->row()->areas;

                    }
                })
                ->unset_edit()
                ->unset_delete()
        ;
     
        $urlx= explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->field_type('frh_estado', 'hidden', 1);
        } else {
            $crud->field_type('frh_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if ($permisos['permite_editar']) {
                $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'registro_academico/mantenimientos/editar_frecuencia');
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'icon16 minia-icon-search', 'registro_academico/mantenimientos/ver_frecuencia');
            }
            if ($permisos['permite_eliminar']) {
               $crud->add_action('Borrar', 'icon16 icomoon-icon-remove', 'registro_academico/mantenimientos/eliminar_frecuencia');
            }

        $output = $crud->render();
        $data['titulo_personal'] = "Frecuencia";

        $this->_cargarvista($data, $output);
    }

    function agregar_frecuencia(){
        satelite_validar();
        if($_POST){
            $post_array = $this->input->post();

            $last = $this->consultas->get_max_codigo('frh_frecuencia_horario', 'frh_codigo');
            $code = $last->codigo;
            $cod = (int) $code+1;
            $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

            $nombre = $post_array['txtNombre'];
            $areas = $post_array['slcArea'];
            $descripcion = ($post_array['txtDescripcion']!='') ? $post_array['txtDescripcion']: null;
            $fecha = date('Y-m-d H:i:s'); 
           
            $redir = $post_array['redireccion'];

            $array_frh = array(
                    'frh_codigo' => $codigo,
                    'frh_id_ard' => null,
                    //'frh_id_ard' => $area,
                    'frh_descripcion'=>$descripcion,
                    'frh_nombre' => $nombre,
                    'frh_fecha' => $fecha,
                    'frh_estado' => 1,
                    'frh_usu_creacion' => $this->tank_auth->get_user_id(),
                    'frh_fecha_creacion' => date('Y-m-d H:i:s'),
                    'frh_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'frh_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            
            $ingreso = $this->gsatelite->ingresar('frh_frecuencia_horario', $array_frh);

            if($ingreso > 0) {

                foreach ($areas as $key => $area) {

                    $array_fxa = array(
                        'fxa_id_frh' => $ingreso,
                        'fxa_id_ard' => $area,
                        'fxa_estado' => 1,
                        'fxa_usu_crea' => $this->tank_auth->get_user_id(),
                        'fxa_usu_mod' => $this->tank_auth->get_user_id(),
                        'fxa_fecha_crea' => date('Y-m-d H:i:s'),
                        'fxa_fecha_mod' => date('Y-m-d H:i:s')
                    );
    
                    $this->gsatelite->ingresar('fxa_frecuenciaxarea', $array_fxa);
    
                }

            }

            // DETALLES
            $asistencia = $post_array['detalle_a'];
            $horario = $post_array['detalle_h'];
            $receso = $post_array['detalle_r'];
            if($ingreso > 0 ){
                foreach ($asistencia as $key => $value) {
                   $array_dfr = array(
                        'dfr_id_frh' => $ingreso,
                        'dfr_id_hrc' => ($receso[$key]!='')?$receso[$key]:null,
                        'dfr_id_hrg' => ($horario[$key]!='')?$horario[$key]:null,
                        'dfr_id_dia' => $asistencia[$key],
                        'dfr_estado' => 1,
                        'dfr_usu_creacion' => $this->tank_auth->get_user_id(),
                        'dfr_fecha_creacion' => date('Y-m-d H:i:s'),
                        'dfr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dfr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );

                   $this->gsatelite->ingresar('dfr_detalle_frecuencia', $array_dfr);
                }
            }

            if ($ingreso > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información ingresada.");
            }
            $this->session->set_flashdata($alerta);

            if($redir>0){
                redirect('registro_academico/mantenimientos/frecuencia');
            }else{
                redirect('registro_academico/mantenimientos/agregar_frecuencia');
            }

        }else{
            $last=$this->consultas->get_max_codigo('frh_frecuencia_horario', 'frh_codigo');
            $code=$last->codigo;
            $cod= (int)$code+1;
            $data['codigo'] = str_pad($cod, 4, '0', STR_PAD_LEFT);

                    $this->db->order_by('dia_id');
            $dias = $this->gsatelite->get_dropdown('dia_dia', '{dia_nombre}', '', array('dia_estado' => 1), null, '', 'dia_id', true);
            $data["dias"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $dias);

            $horarios = $this->gsatelite->get_tabla('hrg_horario_grupo', array('hrg_estado' => 1));
            $recesos = $this->gsatelite->get_tabla('hrc_horario_receso', array('hrc_estado' => 1));

            $option_hrg = '<option value=""></option>';
            if(count($horarios)>0){
                foreach ($horarios as $hr) {
                   $option_hrg .= '<option value="'.$hr['hrg_id'].'"  data-ini="'.date("H:i", strtotime($hr['hrg_inicio'])).'"  data-fin="'.date("H:i", strtotime($hr['hrg_fin'])).'" >'.date("h:i A", strtotime($hr['hrg_inicio'])).' - '.date("h:i A", strtotime($hr['hrg_fin'])).'</option>';
                }
            }

            $data["horarios"] = $option_hrg;

            $option_hrc = '<option value=""></option>';
            if(count($recesos)>0){
                foreach ($recesos as $rec) {
                   $option_hrc .= '<option value="'.$rec['hrc_id'].'" data-ini="'.date("H:i", strtotime($rec['hrc_inicio'])).'"  data-fin="'.date("H:i", strtotime($rec['hrc_fin'])).'">'.date("h:i A", strtotime($rec['hrc_inicio'])).' - '.date("h:i A", strtotime($rec['hrc_fin'])).'</option>';
                }
            }

            $data["recesos"] = $option_hrc;

            $programas = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => '1'), null, '', 'ard_id', true);
            $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $programas);

            $data['titulo_personal'] = "Frecuencia";
            $this->_cargarvista($data, null);
        }
    }

     function editar_frecuencia($id_frh){
        satelite_validar();
        if($_POST){
            $post_array = $this->input->post();
            $nombre = $post_array['txtNombre'];
            $areas = $post_array['slcArea'];
            $fecha = date('Y-m-d H:i:s'); 
            $redir = $post_array['redireccion'];
            $id_frh = $post_array['id_frh'];
            $descripcion = ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : null;
            $array_frh = array(
                    'frh_nombre' => $nombre,
                    'frh_id_ard' => null,
                    'frh_descripcion'=>$descripcion,
                    'frh_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'frh_fecha_modificacion' => date('Y-m-d H:i:s')
                );
            
            $ingreso = $this->gsatelite->actualizar_array('frh_frecuencia_horario', $array_frh, array('frh_id'=>$id_frh));
            if($ingreso > 0) {
                // $this->gsatelite->borrado_general('fxa_frecuenciaxarea', array('fxa_id_frh'=>$id_frh)); /* CONFLICTO EN  fxd_frecuenciaxdocente */
                $areasac = explode(',', $post_array['areas_actuales']);
                foreach ($areasac as $k => $val) {
                    if (!(in_array($val, $areas))) {
                        $apaga = array('fxa_estado' => 0, 'fxa_usu_mod' => $this->tank_auth->get_user_id(), 'fxa_fecha_mod' => date('Y-m-d H:i:s'));
                        $this->gsatelite->actualizar_array('fxa_frecuenciaxarea', $apaga, array('fxa_id_frh'=>$id_frh, 'fxa_id_ard'=> $val));
                    }
                }
                foreach ($areas as $key => $area) {
                    if (!(in_array($area, $areasac))) {
                    $array_fxa = array(
                        'fxa_id_frh' => $id_frh,
                        'fxa_id_ard' => $area,
                        'fxa_estado' => 1,
                        'fxa_usu_crea' => $this->tank_auth->get_user_id(),
                        'fxa_usu_mod' => $this->tank_auth->get_user_id(),
                        'fxa_fecha_crea' => date('Y-m-d H:i:s'),
                        'fxa_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('fxa_frecuenciaxarea', $array_fxa);
                }
            }
            }

            // DETALLES
            $receso = $post_array['detalle_r'];     //RECESO
            $horario = $post_array['detalle_h'];    //HORARIO
            $asistencia = $post_array['detalle_a']; //DIA
            $frc_actual = $post_array['frecuencias'];
            if($ingreso>0 ){
                // $this->gsatelite->borrado_general('dfr_detalle_frecuencia', array('dfr_id_frh'=>$id_frh)); /* CONFLICTO EN dhs_detalle_horario_sustituir */
                $act_det = array_column($this->gsatelite->get_tabla('dfr_detalle_frecuencia', array('dfr_id_frh' => $id_frh, 'dfr_estado' => 1)), 'dfr_id');
                if (count($act_det) > 0) {
                    foreach ($act_det as $k => $d) {
                        if (!(in_array($d, $frc_actual))) {
                            $apagar = array('dfr_estado' => 0, 'dfr_usu_modificacion' => $this->tank_auth->get_user_id(), 'dfr_fecha_modificacion' => date('Y-m-d H:i:s'));
                            $this->gsatelite->actualizar_array('dfr_detalle_frecuencia', $apagar, array('dfr_id' => $d));
                        }
                    }
                }
                foreach ($frc_actual as $key => $value) {
                   $array_dfr = array(
                        'dfr_id_frh'=>$id_frh,
                        'dfr_id_hrc'=>($receso[$key]!='')?$receso[$key]:null,
                        'dfr_id_hrg'=>($horario[$key]!='')?$horario[$key]:null,
                        'dfr_id_dia'=>$asistencia[$key],
                        'dfr_estado'=>1,
                        'dfr_usu_modificacion'=>$this->tank_auth->get_user_id(),
                        'dfr_fecha_modificacion'=>date('Y-m-d H:i:s')
                    );
                    if ($value > 0) {
                        $this->gsatelite->actualizar_array('dfr_detalle_frecuencia', $array_dfr, array('dfr_id' => $value));
                    } else {
                        $array_dfr['dfr_usu_creacion'] = $this->tank_auth->get_user_id();
                        $array_dfr['dfr_fecha_creacion'] = date('Y-m-d H:i:s');
                   $this->gsatelite->ingresar('dfr_detalle_frecuencia', $array_dfr);
                }

                }
            }
            if ($ingreso > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información ingresada.");
            }
            $this->session->set_flashdata($alerta);

            if($redir>0){
                redirect('registro_academico/mantenimientos/frecuencia');
            }else{
                redirect('registro_academico/mantenimientos/editar_frecuencia/'.$id_frh);
            }
        }else{
                          $this->db->order_by('dia_id');
            $frecuencia = $this->registro_academico_model->get_frecuencias(array('dfr_id_frh' => $id_frh, 'frh_estado' => 1, 'dfr_estado' => 1));
           //die(print_r($this->db->last_query()));
            $data['codigo'] = $frecuencia[0]['frh_codigo'];

                            $this->db->order_by('dia_id');
            $dias = $this->gsatelite->get_dropdown('dia_dia', '{dia_nombre}', '', array('dia_estado' => 1), null, '', 'dia_id', true);
            $data["dias"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $dias);

            $horarios = $this->gsatelite->get_tabla('hrg_horario_grupo', array('hrg_estado' => 1));
            $recesos = $this->gsatelite->get_tabla('hrc_horario_receso', array('hrc_estado' => 1));

            $option_hrg = '<option value=""></option>';
            if(count($horarios)>0){
                foreach ($horarios as $hr) {
                   $option_hrg .= '<option value="'.$hr['hrg_id'].'"  data-ini="'.date("H:i", strtotime($hr['hrg_inicio'])).'"  data-fin="'.date("H:i", strtotime($hr['hrg_fin'])).'" >'.date("h:i A", strtotime($hr['hrg_inicio'])).' - '.date("h:i A", strtotime($hr['hrg_fin'])).'</option>';
                }
            }

            $data["horarios"] = $option_hrg;

            $option_hrc = '<option value=""></option>';
            if(count($recesos)>0){
                foreach ($recesos as $rec) {
                   $option_hrc .= '<option value="'.$rec['hrc_id'].'" data-ini="'.date("H:i", strtotime($rec['hrc_inicio'])).'"  data-fin="'.date("H:i", strtotime($rec['hrc_fin'])).'">'.date("h:i A", strtotime($rec['hrc_inicio'])).' - '.date("h:i A", strtotime($rec['hrc_fin'])).'</option>';
                }
            }

            $data["recesos"] = $option_hrc;

            $ids_frecuenciaxarea_opt = [];
            $listado_frecuenciaxarea = $this->gsatelite->get_tabla('fxa_frecuenciaxarea', array('fxa_id_frh' => $id_frh, 'fxa_estado' => 1));
            foreach($listado_frecuenciaxarea as $key => $frecuenciaxarea) {
                array_push($ids_frecuenciaxarea_opt, $frecuenciaxarea['fxa_id_ard']);
            }

            $data["ids_frecuenciaxarea_opt"] = $ids_frecuenciaxarea_opt;
            $data["areas"] = $this->gsatelite->get_tabla('ard_area_academica', array('ard_estado' => '1'));

            $data['id_frh'] = $id_frh;
            $data['registro'] = $frecuencia;
            $data['titulo_personal'] = "Frecuencia";
            $this->_cargarvista($data, null);
        }
    }

     function ver_frecuencia($id_frh){
        satelite_validar();
        $data['registro'] = $frecuencia = $this->registro_academico_model->get_frecuencias(array('dfr_id_frh'=>$id_frh));
        $data['codigo'] = $frecuencia[0]['frh_codigo'];
        $data['id_frh'] = $id_frh;
        $data['titulo_personal'] = "Frecuencia";
        $this->_cargarvista($data, null);
    }

    /**
     * @author Edith Herrera
     * @since 2017-10-20
     * @return validación del nombre de frecuencia.
    * */
    public function frecuencia_unica(){
        $nombre = $this->input->post('nombre');
        $area = $this->input->post('area');
        $edit = ($this->input->post('edit')>0)?$this->input->post('edit'):0;
        $validado1=0; //variable que cambiará de valor cuando no se cumpla una condición de validación
        if( $nombre != '' && count($area) > 0 )
        {           
            //PREGUNTAR SI EXISTEN REGISTROS IGUALES. 
                        // $this->db->where_in('frh_id_ard', $area);  /* ***** */
            $pregunta = $this->gsatelite->get_tabla('frh_frecuencia_horario', array('frh_nombre'=>$nombre, 'frh_id !='=>$edit));
            if(count($pregunta)>0){
                $validado=1;
            } else {
               $validado=0; 
            }
            echo $validado;
        }else {
            echo $validado;
        }
    }

       /**
     * @author Edith Herrera
     * @since 2017-10-20
     * @return Elimina frecuencia.
    * */
     public function eliminar_frecuencia($id_frh)
    {
        satelite_validar();

        $detalle = $this->gsatelite->borrado_general('dfr_detalle_frecuencia', array('dfr_id_frh'=>$id_frh));
        if($detalle>0){
            $frecuencia = $this->gsatelite->borrado_general('frh_frecuencia_horario', array('frh_id'=>$id_frh));
            if($frecuencia>0){
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro eliminado", 'texto_alerta' => "El registro se ha eliminado correctamente.");
            }else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no eliminado", 'texto_alerta'=>"El registro posee integridad referencial <br />&nbsp;No podrá ser eliminado.");
            }
        }else{
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no eliminado", 'texto_alerta'=>"El registro posee integridad referencial <br />&nbsp;No podrá ser eliminado.");
        }
       $this->session->set_flashdata($alerta);
       redirect('registro_academico/mantenimientos/frecuencia');
    }

       /**
     * @author Edith Herrera
     * @since 2017-10-19
     * @return Grid del mantenimiento de proyección.
    * */
    function proyecciones() {
        satelite_validar();

        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        if ($_POST) {
            $post_array = $_POST;

            $fecha_inicio = $post_array['fecha_ini'];
            $fecha_fin = $post_array['fecha_fin'];

            $where = null;
            if ($fecha_inicio != '' && $fecha_fin != '') {
                $where['pyc_fecha_inicio >='] = formatear_fecha('Y-m-d', $fecha_inicio);
                $where['pyc_fecha_inicio <='] = formatear_fecha('Y-m-d', $fecha_fin);
            }

            $proyeccion = $this->registro_academico_model->obtener_proyecciones($where);

            /*$this->db->join('ard_area_academica', 'pyc_id_ard=ard_id');
            $proyeccion = $this->gsatelite->get_tabla('pyc_proyeccion', $where);*/
            $data['detalles'] = $proyeccion;
            
            $html = $this->load->view('registro_academico/mantenimientos/detalles_proyeccion', $data, true);
            echo $html;
        } else {
            $data['titulo_personal'] = "Proyección";
            $this->_cargarvista($data);
        }
    }


     function agregar_proyeccion(){
        satelite_validar();
        if($_POST){
            $post_array = $this->input->post();
            $nombre = $post_array['txtNombre'];
            $areas = $post_array['slcArea'];
            $fecha_ini= ($post_array['txtFecha_ini']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha_ini']):date('Y-m-d H:i:s');
            $fecha_fin= ($post_array['txtFecha_fin']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha_fin']):date('Y-m-d H:i:s');
            $fecha_max= ($post_array['txtFecha_max']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha_max']):null;
            $fecha_ins= ($post_array['txtFecha_ins']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha_ins']):null;
            $fecha_pago= ($post_array['txtFecha_pago']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha_pago']):null;
            $redir = $post_array['redireccion'];
            $suc_usu = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_defecto'=>1,'usc_estado'=>1,'usc_id_usu'=>$this->tank_auth->get_user_id()));

            $array_pyc = array(
                    'pyc_nombre' => $nombre,
                    'pyc_id_ard'=> null,
                    'pyc_id_suc'=> (count($suc_usu) > 0) ? $suc_usu[0]['usc_id_usu'] : null,
                    'pyc_fecha_inicio' => $fecha_ini,
                    'pyc_fecha_fin' => $fecha_fin,
                    'pyc_fecha_limite_nota' => $fecha_max,
                    'pyc_fecha_maxima_inscripcion'=>$fecha_ins,
                    'pyc_ultima_fecha_pago'=>$fecha_pago,
                    'pyc_estado' => 1,
                    'pyc_usu_creacion' => $this->tank_auth->get_user_id(),
                    'pyc_fecha_creacion' => date('Y-m-d H:i:s'),
                    'pyc_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'pyc_fecha_modificacion' => date('Y-m-d H:i:s')
                );
            
            $ingreso = $this->gsatelite->ingresar('pyc_proyeccion', $array_pyc);
            if ($ingreso > 0) {
                foreach ($areas as $k => $ard) {
                    $array_axy = array(
                        'axy_id_pyc' => $ingreso,
                        'axy_id_ard' => $ard,
                        'axy_estado' => 1,
                        'axy_usu_creacion' => $this->tank_auth->get_user_id(),
                        'axy_fecha_creacion' => date('Y-m-d H:i:s'),
                        'axy_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'axy_fecha_modificacion' => date('Y-m-d H:i:s')
                    );    
                    $this->gsatelite->ingresar('axy_areas_x_proyecion', $array_axy);    
                }

                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información ingresada.");
            }
            $this->session->set_flashdata($alerta);

            if($redir>0){
                redirect('registro_academico/mantenimientos/proyecciones');
            }else{
                redirect('registro_academico/mantenimientos/agregar_proyeccion');
            }
        }else{

            $sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_estado'=>1,'usc_id_usu'=>$this->tank_auth->get_user_id()));

            $where = (count($sucursal) > 0) ? 'padre.ard_estado = 1 AND (padre.ard_id_suc IS NULL OR padre.ard_id_suc = '.$sucursal[0]['usc_id_suc'].')': 'padre.ard_estado = 1';

            $areas = $this->registro_academico_model->get_areas_padre($where);
            $opt_areas='<option value=""></option>';
            if(count($areas)>0){
                foreach ($areas as $key) {
                    if($key['hijo']==''){
                        $opt_areas .= '<option value="'.$key['ard_padre'].'">'.$key['nombre'].'</option>';
                    }
                }
            }
            $data['areas'] = $opt_areas;

            $data['maximo'] = ($this->gsatelite->get_parametro('SYS_DIAS_MAXIMO')!='')?$this->gsatelite->get_parametro('SYS_DIAS_MAXIMO'):0;
            $data['titulo_personal'] = "Proyección";
            $this->_cargarvista($data, null);
        }
    }

function editar_proyeccion($id_pyc, $ver=null){
        satelite_validar();
        if($_POST){
            $post_array = $this->input->post();
            $id_pyc = $post_array['id_pyc'];
            $areas = $post_array['slcArea'];
            $nombre= $post_array['txtNombre'];
            $fecha_ini= ($post_array['txtFecha_ini']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha_ini']):date('Y-m-d H:i:s');
            $fecha_fin= ($post_array['txtFecha_fin']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha_fin']):date('Y-m-d H:i:s');
            $fecha_max= ($post_array['txtFecha_max']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha_max']):null;
            $fecha_ins= ($post_array['txtFecha_ins']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha_ins']):null;
            $fecha_pago= ($post_array['txtFecha_pago']!='')?formatear_fecha('Y-m-d', $post_array['txtFecha_pago']):null;
            $redir = $post_array['redireccion'];
            $estado= ($post_array['estado']!='')?$post_array['estado']:1;

            $array_pyc = array(
                'pyc_id_ard' => null,
                'pyc_nombre' => $nombre,
                'pyc_fecha_inicio' => $fecha_ini,
                'pyc_fecha_fin' => $fecha_fin,
                'pyc_fecha_limite_nota' => $fecha_max,
                'pyc_fecha_maxima_inscripcion'=>$fecha_ins,
                'pyc_ultima_fecha_pago'=>$fecha_pago,
                'pyc_estado' => $estado,
                'pyc_usu_modificacion' => $this->tank_auth->get_user_id(),
                'pyc_fecha_modificacion' => date('Y-m-d H:i:s')
            );            
            $actualiza = $this->gsatelite->actualizar_array('pyc_proyeccion', $array_pyc, array('pyc_id'=>$id_pyc));
            if ($actualiza > 0) {
                $this->gsatelite->borrado_general('axy_areas_x_proyecion', array('axy_id_pyc'=>$id_pyc));
                foreach ($areas as $k => $ard) {
                    $array_axy = array(
                        'axy_id_pyc' => $id_pyc,
                        'axy_id_ard' => $ard,
                        'axy_estado' => 1,
                        'axy_usu_creacion' => $this->tank_auth->get_user_id(),
                        'axy_fecha_creacion' => date('Y-m-d H:i:s'),
                        'axy_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'axy_fecha_modificacion' => date('Y-m-d H:i:s')
                    );    
                    $this->gsatelite->ingresar('axy_areas_x_proyecion', $array_axy);
                }
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro actualizado", 'texto_alerta' => "El registro se ha actualizado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no actualizado", 'texto_alerta' => "El registro no pudo ser actualizado, verifique la información ingresada.");
            }
            $this->session->set_flashdata($alerta);            

            if($redir>0){
                redirect('registro_academico/mantenimientos/proyecciones');
            }else{
                redirect('registro_academico/mantenimientos/editar_proyeccion/'.$id_pyc);
            }

        }else{
            $registro = $this->gsatelite->get_tabla('pyc_proyeccion', array('pyc_id'=>$id_pyc));
            $data['registro'] = $registro[0];
            
            $data['id_pyc']=$id_pyc;
            if($ver!=null){
                $data['ver']=1;
            }else{
                $data['ver']=0;
            }            
            $ids_pycxareas_opt = array(0);
            $listado_proyeccionxareas = $this->gsatelite->get_tabla('axy_areas_x_proyecion', array('axy_id_pyc' => $id_pyc));
            foreach($listado_proyeccionxareas as $key => $proyeccionxarea) {
                array_push($ids_pycxareas_opt, $proyeccionxarea['axy_id_ard']);
            }
            $data["ids_pycxareas_opt"] = $ids_pycxareas_opt;

            $sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_estado'=>1,'usc_id_usu'=>$this->tank_auth->get_user_id()));

            $where = (count($sucursal) > 0) ? 'padre.ard_estado = 1 AND (padre.ard_id_suc IS NULL OR padre.ard_id_suc = '.$sucursal[0]['usc_id_suc'].')': 'padre.ard_estado = 1';

            $areas = $this->registro_academico_model->get_areas_padre($where);
            
            $data['areas'] = $areas;
            $data['maximo'] = ($this->gsatelite->get_parametro('SYS_DIAS_MAXIMO')!='')?$this->gsatelite->get_parametro('SYS_DIAS_MAXIMO'):0;
            $data['titulo_personal'] = "Proyección";
            $this->_cargarvista($data, null);
        }
    }

    /**
     * @author Edith Herrera
     * @since 2017-10-24
     * @return valida que el registro de proyección sea único.
    * */
     public function verificar_registro()
    {
        $nombre = trim($this->input->post('nombre'));
        $inicio = ($this->input->post('inicio')!='')?formatear_fecha('Y-m-d', $this->input->post('inicio')):null;
        $fin = ($this->input->post('fin')!='')?formatear_fecha('Y-m-d', $this->input->post('fin')):null;
        $maximo = ($this->input->post('maximo')!='')?formatear_fecha('Y-m-d', $this->input->post('maximo')):null;

        $edit = ($this->input->post('edit')>0)?$this->input->post('edit'):0;

        $validado1=0; //variable que cambiará de valor cuando no se cumpla una condición de validación
        if( $nombre != '' && $inicio != '' && $fin != '' && $maximo != '' )
        {           
            //PREGUNTAR SI EXISTEN REGISTROS IGUALES. 
            $pregunta = $this->gsatelite->get_tabla('pyc_proyeccion', array('pyc_nombre'=>$nombre, 'pyc_fecha_inicio'=>$inicio, 'pyc_fecha_fin'=>$fin, 'pyc_fecha_limite_nota'=>$maximo, 'pyc_id !='=>$edit));
        
            if(count($pregunta)>0){
                $validado=1;
            }
            else {
               $validado=0; 
            }
            echo $validado;
        }else {
            echo $validado;
        }
    }

     /**
     * @author Edith Herrera
     * @since 24-10-2017
     * @return Grid del mantenimiento de tipos de evaluación.
    * */
    function tipo_evaluacion() {
        satelite_validar();

       $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

       $add_fields= array(
            'tev_codigo',
            'tev_nombre',
            'tev_estado',
            'tev_usu_creacion',
            'tev_fecha_creacion',
            'tev_usu_modificacion',
            'tev_fecha_modificacion'
        );

       $edit_fields= array(
            'tev_codigo',
            'tev_nombre',
            'tev_estado',
            'tev_usu_modificacion',
            'tev_fecha_modificacion'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('tev_tipo_evaluacion')
                ->set_subject('Tipo de evaluación')
                ->columns('tev_codigo', 'tev_nombre','tev_estado')
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($edit_fields)
                ->display_as('tev_codigo', 'Código')
                ->display_as('tev_nombre', 'Nombre')
                ->display_as('tev_estado', 'Estado')  
                ->field_type('tev_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tev_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('tev_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tev_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('tev_nombre', 'Nombre', 'trim|required|campo_unico[tev_tipo_evaluacion.tev_nombre]')
        ;    

            // AGREGAR EL CÓDIGO SEGÚN CORRELATIVO.
                $crud->callback_add_field('tev_codigo', function () {
                    $tabla='tev_tipo_evaluacion';
                    $campo='tev_codigo';
                    $last=$this->consultas->get_max_codigo($tabla,$campo);

                    $code=$last->codigo;
                    $cod= (int)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

                    return '<input id="field-tev_codigo" name="tev_codigo" type="text" readonly maxlength="99" value="'.$codigo.'" >';
                });

                $crud->callback_edit_field('tev_codigo', function ($value, $primary_key) {
                    if($value==''){
                      $tabla='tev_tipo_evaluacion';
                      $campo='tev_codigo';
                      $last=$this->consultas->get_max_codigo($tabla,$campo);

                      $code=$last->codigo;
                      $cod= (int)$code+1;
                      $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                      return '<input id="field-tev_codigo" name="tev_codigo" type="text" readonly maxlength="99" value="'.$codigo.'" >';
                    }else{
                       return '<input id="field-tev_codigo" name="tev_codigo" type="text" readonly maxlength="99" value="'.$value.'" >';
                    }
                });

     
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tev_estado', 'hidden', 1);
        } else {
            $crud->field_type('tev_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }


        $output = $crud->render();
        $data['titulo_personal'] = "Tipo de evaluación";

        $this->_cargarvista($data, $output);
    }

    /**
     * @descripcion
     * Filtra el select que muestra los horarios, filtrandolo por el cambio del select del nivel
     */
    function get_horarioxnivel() {
        satelite_validar();

        $nivel = $this->input->post('nivel');
        $area = $this->input->post('area');
        //si el select nivel esta vacio filtra el select de los horarios por el area
        if ($area == "" && $nivel == "") {
            $where_horario = null;
        } else if ($area == "") {
            $where_horario = array('pen_id_mod' => $nivel);
        } else if ($nivel == "") {
            $where_horario = array('ard_id' => $area);
        } else {
            $where_horario = array('pen_id_mod' => $nivel, 'ard_id' => $area);
        }

        $hrg = $this->registro_academico_model->get_horarioxarea($where_horario);

        $options = '<option value=""></option>';
        foreach ($hrg as $key) {
            $hora_ini = date("h:i A", strtotime($key['hrg_inicio']));
            $hora_fin = date("h:i A", strtotime($key['hrg_fin']));
            $options .= '<option value="' . $key["hrg_id"] . '" >' . $hora_ini . ' - ' . $hora_fin . '</option>';
        }
        $opciones["horarios"] = $options;
        echo json_encode($opciones);
    }


    /**
     * @author Edith Herrera
     * @since 2017-10-18
     * @return Grid del mantenimiento de tipos de beneficios
    * */
    function tipo_beneficio() {
        satelite_validar();

       $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

       $add_fields= array(
            'tbf_nombre',
            'tbf_descripcion',
            'tbf_porcentaje',
            'tbf_estado',
            'tbf_usu_creacion',
            'tbf_fecha_creacion',
            'tbf_usu_modificacion',
            'tbf_fecha_modificacion'
        );

       $edit_fields= array(
            'tbf_nombre',
            'tbf_descripcion',
            'tbf_porcentaje',
            'tbf_estado',
            'tbf_usu_modificacion',
            'tbf_fecha_modificacion'
        );

        $required_fields= array(
            'tbf_nombre',
            'tbf_estado',
            'tbf_usu_modificacion',
            'tbf_fecha_modificacion'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('tbf_tipo_beneficio')
                ->set_subject('Tipo de beneficio')
                ->columns('tbf_nombre', 'tbf_porcentaje', 'tbf_descripcion', 'tbf_estado')
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($required_fields)
                ->display_as('tbf_nombre', 'Nombre')
                ->display_as('tbf_porcentaje', 'Porcentaje')
                ->display_as('tbf_descripcion', 'Descripción')
                ->display_as('tbf_estado', 'Estado')  
                ->field_type('tbf_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tbf_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('tbf_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tbf_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('tbf_nombre', 'Nombre', 'trim|required|campo_unico[tbf_tipo_beneficio.tbf_nombre]')
                ->set_rules('tbf_porcentaje', 'Porcentaje', 'trim|required|is_numeric')
        ;       

               
     
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tbf_estado', 'hidden', 1);
        } else {
            $crud->field_type('tbf_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }


        $output = $crud->render();

        $data['titulo_personal'] = "Tipos de beneficios";

        $this->_cargarvista($data, $output);
    }

    /**
     * @author Edith Herrera
     * @since  08-11-2017
     * @return Agregar auditoría para las áreas asociadas al horario.
    * */
    public function insertar_auditoria($post_array,$key){          
        $actualizar=array('hxr_estado'=>1,
                          'hxr_usu_creacion'=>$this->tank_auth->get_user_id(),
                          'hxr_fecha_creacion'=>date('Y-m-d H:i:s'),
                          'hxr_usu_modificacion'=>$this->tank_auth->get_user_id(),
                          'hxr_fecha_modificacion'=>date('Y-m-d H:i:s'));
        $this->db->where('hxr_id_hrg',$key)
             ->update('hxr_horarioxarea',$actualizar);

        return true;
    }

    public function insertar_auditoria_mod($post_array,$key){
        $actualizar=array('hxr_estado'=>1,
                          'hxr_usu_modificacion'=>$this->tank_auth->get_user_id(),
                          'hxr_fecha_modificacion'=>date('Y-m-d H:i:s'));
        $this->db->where('hxr_id_hrg',$key)
             ->update('hxr_horarioxarea',$actualizar);

        return true;
    }


    /**
     * @author Edith Herrera
     * @since  2017-11-15
     * @return Grid del mantenimiento de tipos de becas
    * */
    function tipo_beca() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

        $crud = new grocery_CRUD();
        $crud->set_table('tpb_tipo_beca')
                ->set_subject('Tipo de beca')
                ->columns('tpb_nombre', 'tpb_nota_minima', 'tpb_porcentaje', 'tpb_descripcion', 'tpb_estado')
                ->display_as('tpb_nombre', 'Nombre')
                ->display_as('tpb_descripcion', 'Descripción')
                ->display_as('tpb_nota_minima', 'Nota mínima')
                ->display_as('tpb_porcentaje', 'Porcentaje')
                ->display_as('tpb_estado', 'Estado')
                ->unset_edit()
                ->unset_delete()
        ;
     
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tpb_estado', 'hidden', 1);
        } else {
            $crud->field_type('tpb_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if ($permisos['permite_editar']) {
                $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'registro_academico/mantenimientos/editar_tipo_beca');
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'icon16 minia-icon-search', 'registro_academico/mantenimientos/editar_tipo_beca', 'a_ver');
            }
            if ($permisos['permite_eliminar']) {
               $crud->add_action('Borrar', 'icon16 icomoon-icon-remove', 'registro_academico/mantenimientos/eliminar_tipo_beca');
            }

        $output = $crud->render();
        $data['titulo_personal'] = "Tipo de beca";

        $this->_cargarvista($data, $output);
    }

    function agregar_tipo_beca(){
        satelite_validar();
        if($_POST){
            $post_array = $this->input->post();
            $redir = $post_array['redireccion'];            
            $array_tpb = array(
                'tpb_nombre' => $post_array['txtNombre'],
                'tpb_descripcion'=>($post_array['txtDescripcion']!='')?$post_array['txtDescripcion']:null,
                'tpb_nota_minima' => ($post_array['txtNota']!='')?$post_array['txtNota']:null,
                'tpb_porcentaje' => $post_array['txtPorcentaje'],
                'tpb_estado' => 1,
                'tpb_mes_vigencia' => ($post_array['clsVigencia'] !='')?$post_array['clsVigencia']:null,
                'tpb_permanente' =>$this->input->post('bcompleta'),
                'tpb_usu_creacion' => $this->tank_auth->get_user_id(),
                'tpb_fecha_creacion' => date('Y-m-d H:i:s'),
                'tpb_usu_modificacion' => $this->tank_auth->get_user_id(),
                'tpb_fecha_modificacion' => date('Y-m-d H:i:s')
            );            
            $ingreso = $this->gsatelite->ingresar('tpb_tipo_beca', $array_tpb);
            // DETALLES
            $area = $post_array['detalle_a'];
            $nivel = $post_array['detalle_n'];
            if($ingreso>0 ){
                foreach ($area as $key => $value) {
                   $array_dxb = array(
                        'dxb_id_tpb'=>$ingreso,
                        'dxb_id_ard'=>$value,
                        'dxb_id_pen'=>$nivel[$key],
                        'dxb_estado'=>1,
                        'dxb_usu_creacion'=>$this->tank_auth->get_user_id(),
                        'dxb_fecha_creacion'=>date('Y-m-d H:i:s'),
                        'dxb_usu_modificacion'=>$this->tank_auth->get_user_id(),
                        'dxb_fecha_modificacion'=>date('Y-m-d H:i:s')
                    );
                   $this->gsatelite->ingresar('dxb_detallextipo_beca', $array_dxb);
                }
            }
            if ($ingreso > 0) {
                $cuenta   = $this->input->post('cuentaContable');
                $costo    = $this->input->post('centrosCosto');
                $tcuenta  = $this->input->post('tipoCuentas');
                if ( (is_array($cuenta)) && (count($cuenta) > 0) ) {
                    for ($i=0; $i < count($cuenta); $i++) { 
                        $arreglo  = array(
                            'fxb_id_tpb'              => $ingreso,
                            'fxb_id_cnt'              => $cuenta[$i],
                            'fxb_id_tcn'              => $tcuenta[$i],
                            'fxb_id_cec'              => $costo[$i],
                            'fxb_estado'              => 1,
                            'fxb_usu_creacion'        => $this->tank_auth->get_user_id(),
                            'fxb_fecha_creacion'      => date('Y-m-d H:m:s'),
                            'fxb_usu_modificacion'    => $this->tank_auth->get_user_id(),
                            'fxb_fecha_modificacion'  => date('Y-m-d H:m:s')
                            );
                        $this->gsatelite->ingresar('fxb_finanzaxtipo_beca',$arreglo);
                    }
                }
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                $alerta = array('tipo_alerta'=>'error', 'titulo_alerta'=>"Registro no ingresado", 'texto_alerta'=>"El registro no pudo ser ingresado, verifique la información ingresada.");
            }
            $this->session->set_flashdata($alerta);
            if($redir>0){
                redirect('registro_academico/mantenimientos/tipo_beca');
            }else{
                redirect('registro_academico/mantenimientos/agregar_tipo_beca');
            }
        }else{
            $programas = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => '1'), null, '', 'ard_id', true);
            $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $programas);
            $centro_costo = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $centro_costo);
            //tipo de cuenta
            $tipo_cuenta = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
            $data["tipo_cuenta"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_cuenta);
            //cuenta contable
            $cuenta = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
            $data["cuen_con"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $cuenta);
            $data['titulo_personal'] = "Agregar tipo de beca";
            $this->_cargarvista($data, null);
        }
    }



    /**
     * @author Edith Herrera
     * @since  2017-11-15
     * @return validación del nombre del tipo de beca.
    * */
     public function tipo_beca_unico()
    {
        satelite_validar(true);
        $nombre = $this->input->post('nombre');
        $edit = ($this->input->post('edit')>0)?$this->input->post('edit'):0;

            $validado=0; //variable que cambiará de valor cuando no se cumpla una condición de validación
        if( $nombre != '')
        {           
            //PREGUNTAR SI EXISTEN REGISTROS IGUALES. 
            $pregunta = $this->gsatelite->get_tabla('tpb_tipo_beca', array('tpb_nombre'=>$nombre, 'tpb_id !='=>$edit));
            
        
            if(count($pregunta)>0){
                $validado=1;
            }
            else {
               $validado=0; 
            }

            echo json_encode($validado);
        }else {
            echo json_encode($validado);
        }
    }

    function editar_tipo_beca($tpb_id=null, $ver=null){
        satelite_validar();
        if($_POST){
            $post_array = $this->input->post();
           
            $redir = $post_array['redireccion'];
            $id_tpb = $post_array['id_tpb'];

            $array_tpb = array(
                    'tpb_nombre' => $post_array['txtNombre'],
                    'tpb_descripcion'=>($post_array['txtDescripcion']!='')?$post_array['txtDescripcion']:null,
                    'tpb_nota_minima' => ($post_array['txtNota']!='')?$post_array['txtNota']:null,
                    'tpb_porcentaje' => $post_array['txtPorcentaje'],
                    'tpb_estado' => 1,
                    'tpb_mes_vigencia' => ($post_array['clsVigencia'] != '')?$post_array['clsVigencia']:null,
                    'tpb_permanente' => $this->input->post('bcompleta'),
                    'tpb_usu_creacion' => $this->tank_auth->get_user_id(),
                    'tpb_fecha_creacion' => date('Y-m-d H:i:s'),
                    'tpb_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'tpb_fecha_modificacion' => date('Y-m-d H:i:s')
            );
                    
            $ingreso = $this->gsatelite->actualizar_array('tpb_tipo_beca', $array_tpb, array('tpb_id'=>$id_tpb));

            // DETALLES
            $area = $post_array['detalle_a'];
            $nivel = $post_array['detalle_n'];
            if($id_tpb>0 && count($area)>0){
                $this->gsatelite->borrado_general('dxb_detallextipo_beca', array('dxb_id_tpb'=>$id_tpb));
                foreach ($area as $key => $value) {
                   $array_dxb = array(
                        'dxb_id_tpb'=>$id_tpb,
                        'dxb_id_ard'=>$value,
                        'dxb_id_pen'=>$nivel[$key],
                        'dxb_estado'=>1,
                        'dxb_usu_creacion'=>$this->tank_auth->get_user_id(),
                        'dxb_fecha_creacion'=>date('Y-m-d H:i:s'),
                        'dxb_usu_modificacion'=>$this->tank_auth->get_user_id(),
                        'dxb_fecha_modificacion'=>date('Y-m-d H:i:s')
                    );

                   $this->gsatelite->ingresar('dxb_detallextipo_beca', $array_dxb);
                }
            }

            if ($ingreso > 0) {
                    $cuenta   = $this->input->post('cuentaContable');
                    $costo    = $this->input->post('centrosCosto');
                    $tcuenta  = $this->input->post('tipoCuentas');
                    $this->gsatelite->borrado_general('fxb_finanzaxtipo_beca', array('fxb_id_tpb' => $tpb_id));
                    if ( (is_array($cuenta)) && (count($cuenta) > 0) ) {
                        for ($i=0; $i < count($cuenta); $i++) { 
                            $arreglo  = array(
                                'fxb_id_tpb'              => $tpb_id,
                                'fxb_id_cnt'              => $cuenta[$i],
                                'fxb_id_tcn'              => $tcuenta[$i],
                                'fxb_id_cec'              => $costo[$i],
                                'fxb_estado'              => 1,
                                'fxb_usu_creacion'        => $this->tank_auth->get_user_id(),
                                'fxb_fecha_creacion'      => date('Y-m-d H:m:s'),
                                'fxb_usu_modificacion'    => $this->tank_auth->get_user_id(),
                                'fxb_fecha_modificacion'  => date('Y-m-d H:m:s')
                                );
                            $this->gsatelite->ingresar('fxb_finanzaxtipo_beca',$arreglo);
                        }
                    }
 
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información ingresada.");
            }
            $this->session->set_flashdata($alerta);

            if($redir>0){
                redirect('registro_academico/mantenimientos/tipo_beca');
            }else{
                redirect('registro_academico/mantenimientos/editar_tipo_beca/'.$id_tpb);
            }

        }else{
            $data['registro'] = $this->registro_academico_model->get_detalles_tipo(array('tpb_id'=>$tpb_id));
            $programas = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => '1'), null, '', 'ard_id', true);
            $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $programas);
            $data['tpb_id']=$tpb_id;
            $data['ver'] = ($ver!=null)?$ver:0;
            $centro_costo = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $centro_costo);
            //tipo de cuenta
            $tipo_cuenta = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
            $data["tipo_cuenta"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_cuenta);
            //cuenta contable
            $data['finanzas'] = $this->registro_academico_model->get_becas_finanzas(array('fxb_id_tpb' => $tpb_id));
            $cuenta = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
            $data["cuen_con"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $cuenta);            
            $data['titulo_personal'] = ($ver != null) ? "Ver tipo de beca" : "Editar tipo de beca";
            $this->_cargarvista($data, null);
        }
    }

    /**
     * @author Edith Herrera
     * @since  2017-10-20
     * @return Elimina tipo de beca.
    * */
     public function eliminar_tipo_beca($id_tpb)
    {
        satelite_validar();

        $existe = $this->gsatelite->get_tabla('slb_solicitud_beca', array('slb_id_tpb'=>$id_tpb));

        if(count($existe)<=0){
            $detalle = $this->gsatelite->borrado_general('dxb_detallextipo_beca', array('dxb_id_tpb'=>$id_tpb));
            if($detalle>0){
                $tipo_beca = $this->gsatelite->borrado_general('tpb_tipo_beca', array('tpb_id'=>$id_tpb));
                if($tipo_beca>0){
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro eliminado", 'texto_alerta' => "El registro se ha eliminado correctamente.");
                }else{
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no eliminado", 'texto_alerta'=>"El registro posee integridad referencial <br/>&nbsp;No podrá ser eliminado.");
                }
            }else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no eliminado", 'texto_alerta'=>"El registro posee integridad referencial <br/>&nbsp;No podrá ser eliminado.");
            }
        }else{
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no eliminado", 'texto_alerta'=>"El registro posee integridad referencial <br/>&nbsp;No podrá ser eliminado.");
        }
       
       $this->session->set_flashdata($alerta);

       redirect('registro_academico/mantenimientos/tipo_beca');
    
    }


    /**
     * @author Edith Herrera
     * @since  15-11-2017
     * @return Grid del mantenimiento de tipos de beneficiarios
    * */
    function tipo_beneficiario() {
        satelite_validar();

       $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

       $add_fields= array(
            'tbs_nombre',
            'tbs_descripcion',
            'tbs_estado',
            'tbs_usu_creacion',
            'tbs_fecha_creacion',
            'tbs_usu_modificacion',
            'tbs_fecha_modificacion'
        );

       $edit_fields= array(
            'tbs_nombre',
            'tbs_descripcion',
            'tbs_estado',
            'tbs_usu_modificacion',
            'tbs_fecha_modificacion'
        );

        $required_fields= array(
            'tbs_nombre',
            'tbs_estado',
            'tbs_usu_modificacion',
            'tbs_fecha_modificacion'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('tbs_tipo_beneficiario_solicitud')
                ->set_subject('Tipo de beneficiario')
                ->columns('tbs_nombre', 'tbs_descripcion', 'tbs_estado')
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($required_fields)
                ->display_as('tbs_nombre', 'Nombre')
                ->display_as('tbs_descripcion', 'Descripción')
                ->display_as('tbs_estado', 'Estado')  
                ->field_type('tbs_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tbs_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('tbs_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tbs_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('tbs_nombre', 'Nombre', 'trim|required|campo_unico[tbs_tipo_beneficiario_solicitud.tbs_nombre]')
        ;       
     
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tbs_estado', 'hidden', 1);
        } else {
            $crud->field_type('tbs_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }

        $output = $crud->render();
        $data['titulo_personal'] = "Tipos de beneficiarios";

        $this->_cargarvista($data, $output);
    }


 /**
     * @author Edith Herrera
     * @since  17-11-2017
     * @return Grid del mantenimiento de lugares para practicas.
    * */
    function lugares() {
        satelite_validar();

       $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

       $add_fields= array(
            'lgp_nombre',
            'lgp_descripcion',
            'lgp_estado',
            'lgp_usu_creacion',
            'lgp_fecha_creacion',
            'lgp_usu_modificacion',
            'lgp_fecha_modificacion'
        );

       $edit_fields= array(
            'lgp_nombre',
            'lgp_descripcion',
            'lgp_estado',
            'lgp_usu_modificacion',
            'lgp_fecha_modificacion'
        );

        $required_fields= array(
            'lgp_nombre',
            'lgp_estado',
            'lgp_usu_modificacion',
            'lgp_fecha_modificacion'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('lgp_lugar_practicas')
                ->set_subject('Lugar')
                ->columns('lgp_nombre', 'lgp_descripcion', 'lgp_estado')
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($required_fields)
                ->display_as('lgp_nombre', 'Nombre')
                ->display_as('lgp_descripcion', 'Descripción')
                ->display_as('lgp_estado', 'Estado')  
                ->field_type('lgp_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('lgp_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('lgp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('lgp_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('lgp_nombre', 'Nombre', 'trim|required|campo_unico[lgp_lugar_practicas.lgp_nombre]')
        ;       

               
     
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('lgp_estado', 'hidden', 1);
        } else {
            $crud->field_type('lgp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }


        $output = $crud->render();

        $data['titulo_personal'] = "Lugar";

        $this->_cargarvista($data, $output);
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a tipo de Inasistencia (Tabla tpi_tipo_inasistencia).
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-20
     * @param Ninguno
     * @return Mantenimiento de Tipo de Inasistencia.
     */
    function tipo_inasistencia() {
        satelite_validar();

       $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

       $add_fields= array(
            'tpi_nombre',
            'tpi_descripcion',
            'tpi_estado',
            'tpi_usu_creacion',
            'tpi_fecha_creacion',
            'tpi_usu_modificacion',
            'tpi_fecha_modificacion'
        );

       $edit_fields= array(
            'tpi_nombre',
            'tpi_descripcion',
            'tpi_estado',
            'tpi_usu_modificacion',
            'tpi_fecha_modificacion'
        );

        $required_fields= array(
            'tpi_nombre',
            'tpi_estado'
        );

        $columns = array(
            'tpi_nombre',
            'tpi_descripcion',
            'tpi_estado'
        );

        $display_as = array(
            'tpi_nombre' => 'Tipo de Inasistencia',
            'tpi_descripcion' => 'Descripción',
            'tpi_estado' => 'Estado'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('tpi_tipo_inasistencia')
                ->set_subject('Tipo de inasistencia')
                ->columns($columns)
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($required_fields)
                ->display_as($display_as)  
                ->field_type('tpi_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tpi_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('tpi_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tpi_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('tpi_nombre', 'Tipo de Inasistencia', 'trim|required|campo_unico[tpi_tipo_inasistencia.tpi_nombre]')
        ;
     
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tpi_estado', 'hidden', 1);
        } else {
            $crud->field_type('tpi_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }


        $output = $crud->render();
        $data['titulo_personal'] = "Tipo de inasistencia";

        $this->_cargarvista($data, $output);
    }


    /**
     * @author Edith Herrera
     * @since  21-11-2017
     * @return Grid del mantenimiento de Escalafón.
    * */
    function escalafon() {
        satelite_validar();

       $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

       $add_fields= array(
            'tbe_codigo',
            'tbe_id_ctf',
            'tbe_clase',
            'tbe_monto',
            'tbe_estado',
            'tbe_usu_creacion',
            'tbe_fecha_creacion',
            'tbe_usu_modificacion',
            'tbe_fecha_modificacion'
        );

       $edit_fields= array(
            'tbe_codigo',
            'tbe_id_ctf',
            'tbe_clase',
            'tbe_monto',
            'tbe_estado',
            'tbe_usu_modificacion',
            'tbe_fecha_modificacion'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('tbe_tabla_escalafon')
                ->set_subject('Escalafón')
                ->columns('tbe_codigo', 'tbe_id_ctf','tbe_clase','tbe_monto', 'tbe_estado')
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($edit_fields)
                ->display_as('tbe_codigo', 'Código')
                ->display_as('tbe_id_ctf', 'Clasificación')
                ->display_as('tbe_clase', 'Clase')
                ->display_as('tbe_monto', 'Monto')
                ->display_as('tbe_estado', 'Estado') 

                ->set_relation('tbe_id_ctf', 'ctf_categoria_escalafon', '{ctf_nombre}', array('ctf_estado' => '1'))
                ->field_type('tbe_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tbe_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('tbe_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tbe_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('tbe_codigo', 'Código', 'trim|required|campo_unico[tbe_tabla_escalafon.tbe_codigo]')
                ->set_rules('tbe_monto', 'Monto', 'trim|required|is_numeric')
        ;    
   
     
        $urlx = explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->field_type('tbe_estado', 'hidden', 1);
        } else {
            $crud->field_type('tbe_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }

        $output = $crud->render();
        $data['titulo_personal'] = "Escalafón";

        $this->_cargarvista($data, $output);
    }


    /**
     * @author Edith Herrera
     * @since  21-11-2017
     * @return Grid del mantenimiento de Experiencia.
    * */
    function experiencia() {
        satelite_validar();

       $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

       $add_fields= array(
            'ctf_nombre',
            'ctf_descripcion',
            'ctf_estado',
            'ctf_usu_creacion',
            'ctf_fecha_creacion',
            'ctf_usu_modificacion',
            'ctf_fecha_modificacion'
        );

       $edit_fields= array(
            'ctf_nombre',
            'ctf_descripcion',
            'ctf_estado',
            'ctf_usu_modificacion',
            'ctf_fecha_modificacion'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('ctf_categoria_escalafon')
                ->set_subject('Experiencia')
                ->columns('ctf_nombre', 'ctf_descripcion', 'ctf_estado')
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($edit_fields)
                ->display_as('ctf_nombre', 'Nombre')
                ->display_as('ctf_descripcion', 'Descripción')
                ->display_as('ctf_estado', 'Estado') 
                ->field_type('ctf_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('ctf_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('ctf_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('ctf_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('ctf_nombre', 'Nombre', 'trim|required|campo_unico[ctf_categoria_escalafon.ctf_nombre]')
        ;    
   
     
        $urlx = explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->field_type('ctf_estado', 'hidden', 1);
        } else {
            $crud->field_type('ctf_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }

        $output = $crud->render();
        $data['titulo_personal'] = "Experiencia de escalafón";

        $this->_cargarvista($data, $output);
    }


    /**
     * @author Edith Herrera
     * @since  21-11-2017
     * @return Grid del mantenimiento de Periodo.
    * */
    function periodo() {
        satelite_validar();

       $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

       $add_fields= array(
            'pev_nombre',
            'pev_abreviacion',
            'pev_orden',
            'pev_estado',
            'pev_usu_creacion',
            'pev_fecha_creacion',
            'pev_usu_modificacion',
            'pev_fecha_modificacion'
        );

       $edit_fields= array(
            'pev_nombre',
            'pev_abreviacion',
            'pev_orden',
            'pev_estado',
            'pev_usu_modificacion',
            'pev_fecha_modificacion'
        );

       $required = array(
            'pev_nombre',
            'pev_orden',
            'pev_estado',
            'pev_usu_modificacion',
            'pev_fecha_modificacion'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('pev_periodo_evaluacion')
                ->set_subject('Periodos')
                ->columns('pev_nombre', 'pev_abreviacion', 'pev_orden','pev_estado')
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($required)
                ->display_as('pev_nombre', 'Nombre')
                ->display_as('pev_abreviacion', 'Abreviación')
                ->display_as('pev_orden', 'Orden')
                ->display_as('pev_estado', 'Estado') 
                ->field_type('pev_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('pev_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('pev_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('pev_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('pev_nombre', 'Nombre', 'trim|required|campo_unico[pev_periodo_evaluacion.pev_nombre]')
                ->set_rules('pev_orden', 'Orden', 'trim|required|is_numeric')
                ;  
     
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('pev_estado', 'hidden', 1);
        } else {
            $crud->field_type('pev_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }

        $output = $crud->render();
        $data['titulo_personal'] = "Periodos";

        $this->_cargarvista($data, $output);
    }

    /**
     * @author Edith Herrera
     * @since  24-11-2017
     * @return Duplicar proyección.
    **/
    function duplicar_proyeccion($id_pyc = null) {
        satelite_validar();

        $area = $this->input->post("area");
        $nombre = $this->input->post("nombre");
        $fechaIni = formatear_fecha('Y-m-d', $this->input->post("fechaIni"));
        $fechaFin = formatear_fecha('Y-m-d', $this->input->post("fechaFin"));
        $fecha_max = formatear_fecha('Y-m-d', $this->input->post("fecha_max"));
        $fecha_ins = formatear_fecha('Y-m-d', $this->input->post("fecha_ins"));

         $fechaIni_gra = ($this->input->post("fechaIni_gra")!='')?formatear_fecha('Y-m-d', $this->input->post("fechaIni_gra")):$fechaIni;
        $fechaFin_gra = ($this->input->post("fechaFin_gra")!='')?formatear_fecha('Y-m-d', $this->input->post("fechaFin_gra")):$fechaFin;

        $cantidad = 0;
        $ajax = false;
        $ajax = true;
        $id_pyc = $this->input->post('id_pyc');
        $cantidad =1;

        $registro = $this->gsatelite->get_registro('pyc_proyeccion', array('pyc_id'=>$id_pyc));

        $grupos = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id_pyc'=>$id_pyc, 'gra_estado'=>1));
        $evaluaciones = $this->gsatelite->get_tabla('evm_evaluacion_modulo', array('evm_id_pyc'=>$id_pyc, 'evm_estado'=>1));

        $exito = 0;
        for ($i = 0; $i < $cantidad; $i++) {
            $detalle = array(
                    'pyc_id_ard' => ($area >0) ? $area : $registro->pyc_id_ard,
                    'pyc_nombre' => ($nombre!='')?$nombre:$registro->pyc_nombre,
                    'pyc_fecha_inicio' => ($fechaIni != '')?$fechaIni:$registro->pyc_fecha_inicio,
                    'pyc_fecha_fin' => ($fechaFin != '')?$fechaFin:$registro->pyc_fecha_fin,
                    'pyc_fecha_limite_nota' => ($fecha_max != '')?$fecha_max:$registro->pyc_fecha_limite_nota,
                    'pyc_fecha_maxima_inscripcion' => ($fecha_ins != '')?$fecha_ins:$registro->pyc_fecha_maxima_inscripcion,
                    'pyc_estado' => $registro->pyc_estado,
                    'pyc_usu_creacion' => $this->tank_auth->get_user_id(),
                    'pyc_fecha_creacion' => date('Y-m-d H:i:s'),
                    'pyc_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'pyc_fecha_modificacion' => date('Y-m-d H:i:s')
                );
           
            $id = $this->gsatelite->ingresar('pyc_proyeccion', $detalle);

            if ($id > 0) {  //Si se ingresa la nueva proyeción
                $exito++;

                //Si existen grupos asociados
                if(count($grupos)>0){
                    for ($g=0; $g < count($grupos); $g++) { 
                        $insert_gra = $grupos[$g];
                        unset($insert_gra['gra_id']);
                        $insert_gra['gra_id_pyc']=$id;
                        $insert_gra['gra_cerrado']=null;
                        $insert_gra['gra_fecha_inicio']=$fechaIni_gra;
                        $insert_gra['gra_fecha_fin']=$fechaFin_gra;
                        $insert_gra['gra_usu_crea']=$this->tank_auth->get_user_id();
                        $insert_gra['gra_usu_mod']=$this->tank_auth->get_user_id();
                        $insert_gra['gra_fecha_crea']=date('Y-m-d H:i:s');
                        $insert_gra['gra_fecha_mod']=date('Y-m-d H:i:s');  

                        $this->gsatelite->ingresar('gra_grupo_academico', $insert_gra);
                    }
                }

                //Si existen evaluaciones asociadas
                if(count($evaluaciones)>0){
                    for ($e=0; $e < count($evaluaciones); $e++) { 
                        $insert_evm = $evaluaciones[$e];
                        unset($insert_evm['evm_id']);
                        $insert_evm['evm_id_pyc']=$id;
                        $insert_evm['evm_fecha_inicio']=null;
                        $insert_evm['evm_fecha_fin']=null;
                        $insert_evm['evm_usu_creacion']=$this->tank_auth->get_user_id();
                        $insert_evm['evm_usu_modificacion']=$this->tank_auth->get_user_id();
                        $insert_evm['evm_fecha_creacion']=date('Y-m-d H:i:s');
                        $insert_evm['evm_fecha_modificacion']=date('Y-m-d H:i:s');  

                        $this->gsatelite->ingresar('evm_evaluacion_modulo', $insert_evm);
                    }
                }

            }
        }
        if ($exito > 0) {
            $alerta = array(
                  'tipo_alerta' => 'success'
                , 'titulo_alerta' => 'Éxito'
                , 'texto_alerta' => "<b>$exito</b> Nueva(s) proyección(es) duplicado(s) con éxito."
            );
            $this->session->set_flashdata($alerta);
        }

        if ($ajax) {
            echo json_encode(array('exito' => $exito));
            die();
        } else {
            if ($id > 0) {
                $this->gsatelite->show_dialog('Nuevo(s) grupo(s) ingresado(s) con éxito.', 'registro_academico/mantenimientos/gestion_grupos');
            } else {
                $this->gsatelite->show_dialog('Error al duplicar grupo', 'registro_academico/mantenimientos/gestion_grupos', 'error');
            }
        }
    }

    /**
     * Descripción:
     * Función Ajax para informacion de la proyeccion
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-05
     * @param ninguno
     * @return Obtener la informacion de proyeccion
     */
    function ajax_duplicar_proyeccion() {
        satelite_validar();

        if($this->input->post()) {
            
            $proyeccion = $this->input->post('proyeccion');

            $where = array('pyc_id'=>$proyeccion, 'pyc_estado'=>1, 'lxp_condicion'=>1, 'lxp_estado'=>1);

            $alm_pyc = $this->registro_academico_model->get_alumnos_proyeccion($where);
            $cantidad_alm = count($alm_pyc);

            $areas = $this->registro_academico_model->get_areas_padre();
            $pyc_info = $this->gsatelite->get_registro('pyc_proyeccion', array('pyc_id'=>$proyeccion, 'pyc_estado'=>1));
            $fecha_inicio = formatear_fecha('d-m-Y', $pyc_info->pyc_fecha_inicio);
            $fecha_fin = formatear_fecha('d-m-Y', $pyc_info->pyc_fecha_fin);
            $fecha_max_nota = formatear_fecha('d-m-Y', $pyc_info->pyc_fecha_limite_nota);
            $fecha_ins = formatear_fecha('d-m-Y', $pyc_info->pyc_fecha_maxima_inscripcion);
            
            $opt_areas='<option value=""></option>';
            if(count($areas)>0){
                foreach ($areas as $key) {
                    if($key['hijo']==''){
                        if($key['ard_padre']==$pyc_info->pyc_id_ard){ $select='selected="selected"'; }else{ $select=''; }
                        $opt_areas .= '<option value="'.$key['ard_padre'].'" '.$select.' >'.$key['nombre'].'</option>';
                    }
                }
            }
            $areas = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $opt_areas);

            if (count($pyc_info)>0) {
                $datos = array(
                                'pyc'=>$pyc_info, 
                                'areas'=>$areas, 
                                'cantidad'=>$cantidad_alm,
                                'fecha_inicio'=>$fecha_inicio,
                                'fecha_fin'=>$fecha_fin,
                                'fecha_max_nota'=>$fecha_max_nota,
                                'fecha_ins'=>$fecha_ins
                            );
                echo json_encode($datos);
            } else {
                echo json_encode(array('exito'=>0));
            }
        }
    }

    /**
     * Descripción:
     * Función de vista de Contenido de Certificados
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-27
     * @param $nivel = ID del nivel
     * @return Obtener la vista de Contenido de Certificados
     */
    function contenido_certificados($nivel=NULL) {
        satelite_validar();

        if($nivel != NULL) {
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('registro_academico/mantenimientos/gestion_modulos');

        $where = array(
            'mod_id' => $nivel,
            'ctd_estado' => 1
        );

        $data['contenidos'] = $this->registro_academico_model->get_contenido_nivel($where);
        $data['nivel'] = $this->gsatelite->get_tabla('mod_modulo', array('mod_id'=>$nivel, 'mod_estado'=>1));
        $data['titulo_personal'] = "Contenido de Certificado";

        $this->_cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función de vista de agregar Contenido de Certificados
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-28
     * @param $nivel = ID del nivel
     * @return Obtener la vista de agregar Contenido de Certificados
     */
    function agregar_contenido_certificado($nivel=NULL) {
        satelite_validar();
        if($nivel != NULL){
            if($this->input->post()) {
                $id = (trim($this->input->post('slcCategoria') != '')?$this->input->post('slcCategoria'):'');
                $descripcion = (trim($this->input->post('txtdescripcion')) != '')?$this->input->post('txtdescripcion'):'';

                $consulta_ctd = '';
                $datos_ctd = array(
                    'ctd_id_ctc' => $id,
                    'ctd_id_mod' => $nivel,
                    'ctd_descripcion' => $descripcion,
                    'ctd_estado' => 1,
                    'ctd_usu_creacion' => $this->tank_auth->get_user_id(),
                    'ctd_fecha_creacion' => date('Y-m-d H:i:s'),
                    'ctd_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'ctd_fecha_modificacion' => date('Y-m-d H:i:s') 
                );
                $consulta_ctd = $this->gsatelite->ingresar('ctd_contenido_modulo', $datos_ctd);

                if(count($consulta_ctd)>0){
                    $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registros procesados",'texto_alerta'=>"Registros procesados correctamente");
                }
                else{
                     $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error de inserción",'texto_alerta'=>"El registro no pudo ser procesado");
                }
                $this->session->set_flashdata($alerta);

                $tipo_btn =  $this->input->post('btnCrear');
                if ($tipo_btn == 1) {
                    redirect('registro_academico/mantenimientos/agregar_contenido_certificado/'.$nivel);
                } else {//Regresar a la lista
                    redirect('registro_academico/mantenimientos/contenido_certificados/'.$nivel);  
                }

            } else {
                $data['nivel'] = $nivel;
                $data['categorias'] = $this->gsatelite->get_dropdown('ctc_categoria_contenido', '{ctc_nombre}', '', array('ctc_estado' => 1), null, '', 'ctc_id', true);
                $data['titulo_personal'] = "Contenido de Certificado";
                $this->_cargarvista($data);
            }
        }
    }

    /**
     * Descripción:
     * Función de vista de editar Contenido de Certificados
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-27
     * @param $nivel = ID del nivel, $contenido = ID de ctd_contenido_modulo
     * @return Obtener la vista de Editar Contenido de Certificados
     */
    function editar_contenido_certificado($nivel=NULL, $contenido=NULL) {
        satelite_validar();
        if($nivel != NULL && $contenido != NULL){
            if($this->input->post()) {
                // print_r($_POST);die();
                $id = (trim($this->input->post('slcCategoria') != '')?$this->input->post('slcCategoria'):'');
                $descripcion = (trim($this->input->post('txtdescripcion')) != '')?$this->input->post('txtdescripcion'):'';

                $datos_ctd = array(
                    'ctd_id_ctc' => $id,
                    'ctd_id_mod' => $nivel,
                    'ctd_descripcion' => trim($descripcion),
                    'ctd_estado' => 1,
                    'ctd_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'ctd_fecha_modificacion' => date('Y-m-d H:i:s') 
                );
                $consulta_ctd = $this->gsatelite->actualizar_array('ctd_contenido_modulo', $datos_ctd, array('ctd_id'=>$contenido));

                $consulta = $this->gsatelite->get_tabla('ctd_contenido_modulo', array('ctd_id'=>$contenido, 'ctd_estado'=>1));
                
                if(count($consulta_ctd)>0){
                    $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registros actualizados",'texto_alerta'=>"Registros actualizados correctamente");
                }
                else{
                     $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error de actualización",'texto_alerta'=>$mensaje);
                }
                $this->session->set_flashdata($alerta);

                $tipo_btn =  $this->input->post('btnCrear');
                if($tipo_btn == 1){
                    redirect('registro_academico/mantenimientos/editar_contenido_certificado/'.$nivel.'/'.$contenido);
                }
                else{//Regresar a la lista
                    redirect('registro_academico/mantenimientos/contenido_certificados/'.$nivel);  
                }


            } else {
                $data['nivel'] = $nivel;
                $data['detalle'] = $this->gsatelite->get_tabla('ctd_contenido_modulo', array('ctd_id'=>$contenido, 'ctd_estado'=>1));
                $data['categorias'] = $this->gsatelite->get_dropdown('ctc_categoria_contenido', '{ctc_nombre}', '', array('ctc_estado' => 1), $data['detalle'][0]['ctd_id_ctc'], '', 'ctc_id', true);
                $data['contenido'] = $this->gsatelite->get_tabla('ctc_categoria_contenido', array('ctc_id'=>$data['detalle'][0]['ctd_id_ctc'],'ctc_estado'=>1));
                $data['titulo_personal'] = "Contenido de Certificado";
                $this->_cargarvista($data);
            }
        }
    }

    /**
     * Descripción:
     * Función de vista de eliminar Contenido de Certificados
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-28
     * @param $nivel = ID del nivel, $contenido = ID de ctd_contenido_modulo
     * @return Obtener la vista de Eliminar Contenido de Certificados
     */
    function eliminar_contenido_certificado($nivel=NULL, $contenido=NULL) {
        satelite_validar();
        if($nivel != NULL && $contenido != NULL){
            $registro_ctd =  $this->gsatelite->borrado_general('ctd_contenido_modulo', array('ctd_id' => $contenido)); 
             
            if($registro_ctd>0){
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro borrado", 'texto_alerta' => "El registro se ha borrado correctamente.");            
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "NOTA", 'texto_alerta' => "El registro posee integridad referencial <br />&nbsp;No podrá ser eliminado.");
            }

            $this->session->set_flashdata($alerta);
            redirect('registro_academico/mantenimientos/contenido_certificados/'.$nivel);
        }
    }


    /**
     * @author Edith Herrera
     * @since 2017-01-25
     * @return categorías de contenido de niveles.
     */
    function categoria_contenido() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $add_fields= array(
                'ctc_nombre',
                'ctc_estado',
                'ctc_usu_creacion',
                'ctc_fecha_creacion',
                'ctc_usu_modificacion',
                'ctc_fecha_modificacion'
            );

           $edit_fields= array(
                'ctc_nombre',
                'ctc_estado',
                'ctc_usu_modificacion',
                'ctc_fecha_modificacion'
            );

           $display= array(
                'ctc_nombre'=>'Nombre',
                'ctc_estado'=>'Estado'
            );

            $crud = new grocery_CRUD();
            $crud->set_table('ctc_categoria_contenido')
                    ->set_subject('Categoría de contenido')
                    ->columns('ctc_nombre', 'ctc_estado')
                    ->display_as($display)
                    ->add_fields($add_fields)
                    ->edit_fields($edit_fields)
                    ->required_fields($add_fields)
                    ->set_rules('ctc_nombre', 'Nombre', 'trim|required|campo_unico[ctc_categoria_contenido.ctc_nombre]')
                    ->field_type('ctc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('ctc_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('ctc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('ctc_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
            ;

            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('ctc_estado', 'hidden', 1);
            } else {  // Editar
                $crud->field_type('ctc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $data['titulo_personal'] = "Categoría de contenido";

            $output = $crud->render();
            $this->_cargarvista($data, $output);
        }
    }

    /**
     * @author Edith Herrera
     * @since  2017-02-13
     * @return Tomar prerrequisito en el success del mantenimiento de pensum
     */
    public function get_prerrequisitos(){
        satelite_validar(true);
            $area = $this->input->post('area');

                  $this->db->where('mod_estado', 1);
                  $this->db->join('mod_modulo','pen_id_mod=mod_id');
        $pensum = $this->gsatelite->get_tabla('pen_pensum', array('pen_id_ard' => $area));

                $this->db->limit(1);
                $this->db->order_by('pen_id', 'desc');
                $this->db->join('mod_modulo','pen_id_mod=mod_id');
        $req =  $this->gsatelite->get_registro('pen_pensum', array('pen_id_ard' => $area));
        

        $option = '<option value=""></option>';
        foreach ($pensum as $key) {
            if($req->pen_id==$key['pen_id']){ $select = 'selected="selected"';
            }else{ $select = ''; }
            $option .= '<option value="'.$key['pen_id'].'" '.$select.' >'.$key['mod_nombre'].'</option>';
        }

        echo $option; 
    }

    function validar_codigo_modulo()
    {
        $codigo = $this->input->post('codigo');
        $id = $this->input->post('id');
        if($id>0){
            $this->db->where('mod_id <>', $id);
        }
        
        if(isset($id) && $id>0){
            $validar_codigo=$this->db->select('mod_codigo,mod_id')
                ->from('mod_modulo')
                ->where('mod_id <>',$id)
                ->where('mod_codigo',$codigo)
                ->get()->result_array();
            if(count($validar_codigo)>0){
                if($validar_codigo[0]['mod_id']==$id){
                    $id=$validar_codigo[0]['mod_id'];
                }
            }else{
                $id=0;
            }
        }else{
            $validar_codigo=$this->db->select('mod_codigo,mod_id')
                ->from('mod_modulo')
                ->where('mod_codigo',$codigo)
                ->get()->result_array();
            if(count($validar_codigo)>0){
                $id=$validar_codigo[0]['mod_id'];
            }
            else{
                $id=0;
            }
        }

        $max_codigo = $this->gsatelite->get_max_numerico('mod_modulo', 'mod_codigo', null);
        $ultimo = $this->gsatelite->get_max('mod_modulo', 'mod_id', null);
        $max_codigo_id = $this->gsatelite->get_max_numerico('mod_modulo', 'mod_codigo', array('mod_id'=>$ultimo));

        // último código registrado en base de datos
        $cod_id = intval(preg_replace('/[^0-9]+/', '', $max_codigo_id), 10);
        // código maximo.
        $codigo = intval(preg_replace('/[^0-9]+/', '', $max_codigo), 10);

        if($codigo > $cod_id){
            $codigo = $codigo + 1;
        }else{
            $codigo = $cod_id + 1;
        }
        $codigo_con_zeros = str_pad($codigo, 6, "0", STR_PAD_LEFT);
        $codigo_obtenido = $codigo_con_zeros;
        
        echo json_encode(array('id'=>$id, 'codigo'=>$codigo_obtenido));
    }
        
    /**
     * @author Edith Herrera
     * @since  2018-03-01
     * @return Duplicar grupos - proyección.
    **/
    function duplicar_grupos_pyc($id_pyc) {
        satelite_validar();
        if($_POST){
            $post_array = $_POST;
            $grupos = $post_array['grupos'];
            $proyeccion = $post_array['slcProyeccion'];
            $fecha_ini = formatear_fecha('Y-m-d', $post_array['txtFecha_ini']);
            $fecha_fin = formatear_fecha('Y-m-d', $post_array['txtFecha_fin']);

            foreach ($grupos as $gra) {
               $grupo_info = $this->gsatelite->get_registro('gra_grupo_academico', array('gra_id'=>$gra));
               $grupo_info->gra_id_pyc = $proyeccion;
               $grupo_info->gra_cerrado = null;
               $grupo_info->gra_fecha_inicio = $fecha_ini;
               $grupo_info->gra_fecha_fin = $fecha_fin;

               $grupo_info->gra_usu_crea = $this->tank_auth->get_user_id();
               $grupo_info->gra_fecha_crea = date('Y-m-d H:i:s');
               $grupo_info->gra_usu_mod = $this->tank_auth->get_user_id();
               $grupo_info->gra_fecha_mod = date('Y-m-d H:i:s');

               unset($grupo_info->gra_id);
               
               $registro = $this->gsatelite->ingresar('gra_grupo_academico', $grupo_info);
            }

            if ($registro > 0) {
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información agregada.");
            }
            $this->session->set_flashdata($alerta);
               
            redirect('registro_academico/mantenimientos/proyecciones');
               

        }else{
            $proyeccion = $this->gsatelite->get_tabla('pyc_proyeccion', array('pyc_estado'=>1, 'pyc_id !='=>$id_pyc));

            $opt_pyc = '<option value=""></option>';
            if(count($proyeccion)>0){
                foreach ($proyeccion as $key ) {
                    $inicio = formatear_fecha("d-m-Y", $key['pyc_fecha_inicio']);
                    $fin = formatear_fecha("d-m-Y", $key['pyc_fecha_fin']);

                    $opt_pyc .= '<option value="'.$key['pyc_id'].'" data-inicio="'.$inicio.'" data-fin="'.$fin.'">'.$key['pyc_nombre'].'</option>';
                }
            }
            $data['proyeccion'] = $opt_pyc;

            $data['pyc_name'] = $this->gsatelite->get_campo('pyc_proyeccion', 'pyc_nombre',array('pyc_id'=>$id_pyc));
            $data['grupos'] = $grupos = $this->registro_academico_model->get_grupos_pyc(array('pyc_id'=>$id_pyc, 'gra_estado'=>1));
            $data['pyc_id'] = $id_pyc;

            $data['titulo_personal'] = "Duplicar grupo";
            $this->_cargarvista($data);
        }
    }

    /**
     * @author Edith Herrera
     * @since  2018-03-02
     * @return Eliminar proyección (cuando no tiene registros dependientes).
    **/
    function proyeccion_delete($proyeccion) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {          
            $eva = $this->gsatelite->get_tabla('evm_evaluacion_modulo', array('evm_id_pyc' => $proyeccion));
            $gra = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id_pyc' => $proyeccion));
           
            if ( (count($eva) <= 0 || $eva == '') && (count($gra) <= 0 || $gra == '')) {
                $registro = $this->gsatelite->borrado_general('pyc_proyeccion', array('pyc_id' => $proyeccion));
                if ($registro > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro borrado", 'texto_alerta' => "El registro se ha borrado correctamente.");
                }
            }else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "NOTA", 'texto_alerta' => "Otros registros dependen de este <br />&nbsp;No podrá ser eliminado.");
            }

            $this->session->set_flashdata($alerta);
            redirect('registro_academico/mantenimientos/proyecciones');
        }
    }

    /**
     * @author Edith Herrera
     * @since  2017-03-05
     * @return Grid del mantenimiento de conversiones.
    * */
    function conversiones() {
        satelite_validar();
        $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

       $add_fields= array(
            'cvn_prefijo',
            'cvn_nombre',
            'cvn_desde',
            'cvn_hasta',
            'cvn_estado',
            'cvn_usu_creacion',
            'cvn_fecha_creacion',
            'cvn_usu_modificacion',
            'cvn_fecha_modificacion'
        );

       $edit_fields= array(
            'cvn_prefijo',
            'cvn_nombre',
            'cvn_desde',
            'cvn_hasta',
            'cvn_estado',
            'cvn_usu_modificacion',
            'cvn_fecha_modificacion'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('cvn_conversion_nota')
                ->set_subject('Conversión')
                ->columns('cvn_prefijo', 'cvn_nombre','cvn_desde','cvn_hasta','cvn_estado')
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($edit_fields)
                ->display_as('cvn_prefijo', 'Prefijo')
                ->display_as('cvn_nombre', 'Descripción')
                ->display_as('cvn_desde', 'Nota Desde')
                ->display_as('cvn_hasta', 'Nota Hasta')
                ->display_as('cvn_estado', 'Estado')  
                ->field_type('cvn_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('cvn_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('cvn_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('cvn_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('cvn_prefijo', 'Prefijo', 'trim|required|campo_unico[cvn_conversion_nota.cvn_prefijo]')
                ->set_rules('cvn_nombre', 'Descripción', 'trim|required|campo_unico[cvn_conversion_nota.cvn_nombre]')
                ->set_rules('cvn_desde', 'Nota Desde', 'trim|required|is_numeric|callback_validacion_rango_nota')
                ->set_rules('cvn_hasta', 'Nota Hasta', 'trim|required|is_numeric')

             /******** verificar que el rango de conversión no esté dentro de otro previanmente registrado *************/ 
                ->callback_before_insert(function($post_array, $primary_key) {
                    $desde=$post_array['cvn_desde'];
                    $hasta=$post_array['cvn_hasta'];
                   
                    $registros = $this->gsatelite->get_tabla('cvn_conversion_nota', array('cvn_estado'=>1));
                    if(count($registros)>0){
                        $count_d = 0;
                        $count_h = 0;
                        
                        foreach ($registros as $key) {
                            if($desde>=$key['cvn_desde'] && $desde<=$key['cvn_hasta']){
                                $count_d++;
                                return false; 
                            }else if($hasta>=$key['cvn_desde'] && $hasta<=$key['cvn_hasta']){
                                $count_h++;
                                return false;
                            }
                        }

                        if($count_d==0 && $count_h==0){
                            return true;
                        }else{
                            return false;
                        }
                    }else{
                        return true;         
                    }
                })
                ->callback_before_update(function($post_array, $primary_key) {
                    
                    $desde=$post_array['cvn_desde'];
                    $hasta=$post_array['cvn_hasta'];
                                    
                                 $this->db->where('cvn_id <>',$primary_key);
                    $registros = $this->gsatelite->get_tabla('cvn_conversion_nota', array('cvn_estado'=>1));
                    if(count($registros)>0){
                        $count_d = 0;
                        $count_h = 0;
                        
                        foreach ($registros as $key) {
                            if($desde>=$key['cvn_desde'] && $desde<=$key['cvn_hasta']){
                                $count_d++;
                                return false; 
                            }else if($hasta>=$key['cvn_desde'] && $hasta<=$key['cvn_hasta']){
                                $count_h++;
                                return false;
                            }
                        }

                        if($count_d==0 && $count_h==0){
                            return true;
                        }else{
                            return false;
                        }
                    }else{
                        return true;         
                    }
                })
                ->set_lang_string('insert_error', 'Algunas notas de este rango ya se encuentran en otra conversión.')
                ->set_lang_string('update_error', 'Algunas notas de este rango ya se encuentran en otra conversión.')
        ;       

           
        $urlx = explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->field_type('cvn_estado', 'hidden', 1);
        } else {
            $crud->field_type('cvn_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }

        $output = $crud->render();
        $data['titulo_personal'] = "Conversión";
        $this->_cargarvista($data, $output);
    }


    public function validacion_rango_nota($data){           
        $desde=$this->input->post('cvn_desde');
        $hasta=$this->input->post('cvn_hasta');

        if((float)$desde < 0){
            $this->form_validation->set_message('validacion_rango_nota', 'El campo Nota Desde no puede ser menor que 0.');
                return false; 
        }else if((float)$hasta < 0){
            $this->form_validation->set_message('validacion_rango_nota', 'El campo Nota Hasta no puede ser menor que 0.');
            return false; 
        }else{
            if((float)$desde > (float)$hasta){
                $this->form_validation->set_message('validacion_rango_nota', 'Verifique el rango de notas ingresado.');
                return false;     
            }else{
                return true;
            }  
        }
    }

    /**
     * @author Edith Herrera
     * @since  2017-03-16
     * @return Grid del mantenimiento de grados.
    * */
    function grados() {
        satelite_validar();
        $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

        try {
            $crud = new grocery_CRUD();
            $columnas = array(
                'grd_nombre',
                'grd_id_ard',
                'grd_id_cfg',
                'grd_descripcion',
                'grd_estado'
            );

            $alias = array(
                'grd_nombre' => 'Nombre',
                'grd_id_ard' => 'Área', 
                'grd_id_cfg' => 'Configuración de cargos',
                'grd_descripcion' => 'Descripción',
                'grd_estado' => 'Estado',
                'grd_orden' => 'Orden'
            );

            $crud->set_table('grd_grado')
                    ->set_subject('Grado')
                    ->columns($columnas)
                    ->display_as($alias)
                    ->set_relation('grd_id_ard', 'ard_area_academica', 'ard_nombre')
                    ->set_relation('grd_id_cfg', 'cfg_configuracion_cargo', 'cfg_nombre')

                    ->field_type('grd_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('grd_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('grd_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('grd_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('grd_id_art', 'hidden')
                    ->unset_edit() // Se agrega la acción independiente
            ;

            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('grd_estado', 'hidden', 1);
            } else {
                $crud->field_type('grd_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }


            // Validaciones
            //die(print_r($permisos))
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }
            if($permisos["permite_editar"]){
                $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'registro_academico/mantenimientos/editar_grado');
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
           
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }
            
            $output = $crud->render();
            $data['titulo_personal'] = "Grados";

            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }



     function agregar_grado() {
        satelite_validar();
        if ($_POST) {
            $uni=$this->gsatelite->get_parametro('SYS_UNIDAD_MEDIDA');
            $categoria=$this->gsatelite->get_parametro('SYS_TIPO_ARTICULO');

            $nombre = $this->input->post('txtNombre');
            $descripcion = $this->input->post('txtDescripcion');
            $area = $this->input->post('slcArea');
            $estado = $this->input->post('slcEstado');
            $orden = $this->input->post('txtOrden');
            $cfg_id = $this->input->post('slcConfig');
 
            if($categoria>0){
                $existe_cat = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_id'=>$categoria));
                if(count($existe_cat)>0){
                                      $this->db->order_by('art_id', 'desc');
                    $producto_reg = $this->gsatelite->get_tabla('art_articulo',  array('art_id_tia'=>$categoria));
                    $codigos_array = array();
                    $max_codigo = $producto_reg[0]['art_codigo'];
                    foreach ($producto_reg as $key) {
                        $codigos_array[] = $key['art_codigo'];
                    }
            
                    $correlativo = preg_replace('/[^A-Za-z]+/', '', $max_codigo);
                    $codigo = intval(preg_replace('/[^0-9]+/', '', $max_codigo), 10);
                    do{
                        $codigo = $codigo + 1;
                        $codigo_con_zeros = str_pad($codigo, 5, "0", STR_PAD_LEFT);
                        $codigo_vdd = $correlativo.$codigo_con_zeros;
                    } while (in_array($codigo_vdd, $codigos_array));

                    //obtener codigo de categoria
                    //Necesario para obtener el codigo del articulo.
                    $codigo_categoria = $this->gsatelite->get_campo('tia_tipo_articulo','tia_codigo',array('tia_id' => $categoria) );
                    //contar cantidad articulos
                    $cantidad = $this->gsatelite->count('art_articulo',array('art_id_tia' => $categoria) );
                    $cantidad = $cantidad + 1;
                    $cantidad = str_pad($cantidad, 5, "0", STR_PAD_LEFT); 


                    //Se agrega la conversion del articulo para la tabla ( cva_conversion_articulo )
                    $unidad_defecto = $this->gsatelite->get_parametro('SYS_UNIDAD_MEDIDA');
                    // Validacion para verificar si existe el parametro
                    if (!$unidad_defecto > 0 || $unidad_defecto == null) {
                        $this->gsatelite->show_dialog('No se ha seleccionado ningún parámetro', 'registro_academico/mantenimientos/agregar_grado', 'error', 'Error en parámetro');
                    }
                   
                    $codigo = $codigo_categoria.$cantidad;

                    $array_art = array(
                        'art_id_tia' => $categoria,
                        'art_nombre' => $nombre,
                        'art_codigo' => $codigo,
                        'art_descripcion' => ($descripcion) ? $descripcion : null,
                        'art_fecha' => date('Y-m-d H:i:s'),
                        'art_tipo' => 1,
                        'art_combo' => 0,
                        'art_compra' => 0,
                        'art_inventario' => 0,
                        'art_venta' => 1,
                        'art_materia_prima' => 0,
                        'art_gasto' => 1,
                        'art_costo' => 1,
                        'art_produccion' => 0,
                        'art_estado' => 1,
                        'art_usu_creacion' => $this->tank_auth->get_user_id(),
                        'art_fecha_creacion' => date('Y-m-d H:i:s'),
                        'art_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'art_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $art_id = $this->gsatelite->ingresar('art_articulo', $array_art);

                    $conversion_array = array(
                        'cva_id_mep' => $unidad_defecto,
                        'cva_id_art' => $art_id,
                        'cva_conversion' => 1,
                        'cva_defecto' => 1,
                        'cva_estado' => 1,
                        'cva_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cva_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'cva_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cva_fecha_creacion' => date('Y-m-d H:i:s'),
                    );
                    $this->gsatelite->ingresar('cva_conversion_articulo', $conversion_array);

                }
            }
            
            $array_grd = array(
                'grd_id_ard' => $area,
                'grd_id_art' => ($art_id!='') ? $art_id : null,
                'grd_id_cfg' => ($cfg_id!='') ? $cfg_id : null,
                'grd_nombre' => $nombre,
                'grd_descripcion' => ($descripcion) ? $descripcion : null,
                'grd_orden'  => $orden,
                'grd_estado' => 1,
                'grd_usu_creacion' => $this->tank_auth->get_user_id(),
                'grd_fecha_creacion' => date('Y-m-d H:i:s'),
                'grd_usu_modificacion' => $this->tank_auth->get_user_id(),
                'grd_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $grado = $this->gsatelite->ingresar('grd_grado', $array_grd);

            if ($grado > 0) {
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información ingresada.");
            }

            $dir = $this->input->post('direccion');
            $this->session->set_flashdata($alerta);

            if ($dir == 1) {
                redirect('registro_academico/mantenimientos/agregar_grado');
            } else if ($dir == 2) {
                redirect('registro_academico/mantenimientos/grados');
            }
        } else {
                      $this->db->join('pen_pensum', 'ard_id = pen_id_ard');
            $select = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1), null, '', 'ard_id', true);
            $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

            $defecto = $this->gsatelite->get_campo('cfg_configuracion_cargo', 'cfg_id', array('cfg_estado'=>1, 'cfg_defecto'=>1));
            $config = $this->gsatelite->get_dropdown('cfg_configuracion_cargo', '{cfg_nombre}', '', array('cfg_estado' => 1), $defecto, '', 'cfg_id', true);
            $data["config"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $config);
            

            $query_flag_curso = "SELECT CFG.cfg_id, CFG.cfg_codigo, CFG.cfg_nombre, 
                CFG.cfg_observacion, CFG.cfg_defecto, CFG.cfg_estado 
                FROM cfg_configuracion_cargo CFG
                INNER JOIN dfc_detalle_configuracion_cargo DFC on DFC.dfc_id_cfg = CFG.cfg_id
                INNER JOIN art_articulo ART ON ART.art_id = DFC.dfc_id_art
                INNER JOIN mod_modulo MODU ON MODU.mod_id_art = ART.art_id
                INNER JOIN pen_pensum PEN ON PEN.pen_id_mod = MODU.mod_id
                INNER JOIN ard_area_academica ARD ON ARD.ard_id = PEN.pen_id_ard
                INNER JOIN trd_tipo_area_academica TRD ON TRD.trd_id = ARD.ard_id_trd 
                WHERE (TRD.trd_es_curso_libre IS NULL OR TRD.trd_es_curso_libre = 0)
                GROUP BY CFG.cfg_id";

            $cfg_flag_curso = $this->db->query($query_flag_curso)->result_array();

            $query_no_es_modulo = "SELECT CFG.cfg_id, CFG.cfg_codigo, CFG.cfg_nombre, CFG.cfg_observacion, CFG.cfg_defecto, CFG.cfg_estado, 
                        (SELECT count(*) FROM mod_modulo WHERE mod_id_art = ART.art_id ) as verificar_modulo 
                FROM cfg_configuracion_cargo CFG
                INNER JOIN dfc_detalle_configuracion_cargo DFC on DFC.dfc_id_cfg = CFG.cfg_id
                INNER JOIN art_articulo ART ON ART.art_id = DFC.dfc_id_art 
                GROUP BY CFG.cfg_id
                HAVING verificar_modulo = 0";

            $cfg_no_es_modulo = $this->db->query($query_no_es_modulo)->result_array();

            $listado_cfg = array_merge($cfg_flag_curso, $cfg_no_es_modulo);

            $opt_cfg = '<option value=""></option>';
            if(count($listado_cfg)>0){
                foreach ($listado_cfg as $key ) {

                    $selected = ($key['cfg_id'] == $defecto) ? "selected" : "";

                    $opt_cfg .= '<option value="'.$key['cfg_id'].'" '.$selected.'>'.$key['cfg_nombre'].'</option>';

                }
            }
            $data['config'] = $opt_cfg;


            $data['titulo_personal'] = "Agregar grado";
            $this->_cargarvista($data, null);
        }
    }


     function editar_grado($grd_id) {
        satelite_validar();
        if ($_POST) {
            $uni=$this->gsatelite->get_parametro('SYS_UNIDAD_MEDIDA');
            $categoria=$this->gsatelite->get_parametro('SYS_TIPO_ARTICULO');
            $nombre = $this->input->post('txtNombre');
            $descripcion = $this->input->post('txtDescripcion');
            $area = $this->input->post('slcArea');
            $estado = $this->input->post('slcEstado');
            $grd_id = $this->input->post('id_grd');
            $articulo = $this->input->post('id_art');
            $orden = $this->input->post('txtOrden');
            $cfg_id = $this->input->post('slcConfig');


            $array_grd = array(
                'grd_id_ard' => $area,
                'grd_id_art' => ($articulo!='')?$articulo:null,
                'grd_id_cfg' => ($cfg_id!='') ? $cfg_id : null,
                'grd_nombre' => $nombre,
                'grd_descripcion' => ($descripcion!='') ? $descripcion : null,
                'grd_orden'  => $orden,
                'grd_estado' => ($estado!='') ? $estado : null,
                'grd_usu_modificacion' => $this->tank_auth->get_user_id(),
                'grd_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $grado = $this->gsatelite->actualizar_array('grd_grado', $array_grd, array('grd_id'=>$grd_id));

            $array_art = array(
                'art_usu_modificacion' => $this->tank_auth->get_user_id(),
                'art_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('art_articulo', $array_art, array('art_id' => $articulo));
          
            if ($grado > 0) {
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro actualizado", 'texto_alerta' => "El registro se ha actualizado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no actualizado", 'texto_alerta' => "El registro no pudo ser actualizado, verifique la información ingresada.");
            }

            $dir = $this->input->post('direccion');
            $this->session->set_flashdata($alerta);

            if ($dir == 1) {
                redirect('registro_academico/mantenimientos/editar_grado/'.$grd_id);
            } else if ($dir == 2) {
                redirect('registro_academico/mantenimientos/grados');
            }
        } else {

            $data['grado'] = $grado = $this->gsatelite->get_registro('grd_grado', array('grd_id'=>$grd_id));
           
                      $this->db->join('pen_pensum', 'ard_id = pen_id_ard');
            $select = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1), $grado->grd_id_ard, '', 'ard_id', true);
            $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

            $config = $this->gsatelite->get_dropdown('cfg_configuracion_cargo', '{cfg_nombre}', '', array('cfg_estado' => 1),  $grado->grd_id_cfg, '', 'cfg_id', true);
            $data["config"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $config);

            $query_flag_curso = "SELECT CFG.cfg_id, CFG.cfg_codigo, CFG.cfg_nombre, 
                CFG.cfg_observacion, CFG.cfg_defecto, CFG.cfg_estado 
                FROM cfg_configuracion_cargo CFG
                INNER JOIN dfc_detalle_configuracion_cargo DFC on DFC.dfc_id_cfg = CFG.cfg_id
                INNER JOIN art_articulo ART ON ART.art_id = DFC.dfc_id_art
                INNER JOIN mod_modulo MODU ON MODU.mod_id_art = ART.art_id
                INNER JOIN pen_pensum PEN ON PEN.pen_id_mod = MODU.mod_id
                INNER JOIN ard_area_academica ARD ON ARD.ard_id = PEN.pen_id_ard
                INNER JOIN trd_tipo_area_academica TRD ON TRD.trd_id = ARD.ard_id_trd 
                WHERE (TRD.trd_es_curso_libre IS NULL OR TRD.trd_es_curso_libre = 0)
                GROUP BY CFG.cfg_id";

            $cfg_flag_curso = $this->db->query($query_flag_curso)->result_array();

            $query_no_es_modulo = "SELECT CFG.cfg_id, CFG.cfg_codigo, CFG.cfg_nombre, CFG.cfg_observacion, CFG.cfg_defecto, CFG.cfg_estado, 
                        (SELECT count(*) FROM mod_modulo WHERE mod_id_art = ART.art_id ) as verificar_modulo 
                FROM cfg_configuracion_cargo CFG
                INNER JOIN dfc_detalle_configuracion_cargo DFC on DFC.dfc_id_cfg = CFG.cfg_id
                INNER JOIN art_articulo ART ON ART.art_id = DFC.dfc_id_art 
                GROUP BY CFG.cfg_id
                HAVING verificar_modulo = 0";

            $cfg_no_es_modulo = $this->db->query($query_no_es_modulo)->result_array();

            $listado_cfg = array_merge($cfg_flag_curso, $cfg_no_es_modulo);

            $opt_cfg = '<option value=""></option>';
            if(count($listado_cfg)>0){
                foreach ($listado_cfg as $key ) {

                    $selected = ($key['cfg_id'] == $grado->grd_id_cfg) ? "selected" : "";

                    $opt_cfg .= '<option value="'.$key['cfg_id'].'" '.$selected.'>'.$key['cfg_nombre'].'</option>';
                    
                }
            }
            $data['config'] = $opt_cfg;

            $data['titulo_personal'] = "Agregar grado";
            $this->_cargarvista($data, null);
        }
    }


    function validar_grado() {
        $nombre = $this->input->post('nombre');
        $id = $this->input->post('id');

        if ($id > 0) {
            $validar_nombre = $this->db->select('grd_nombre,grd_id')
                            ->from('grd_grado')
                            ->where('grd_id <>', $id)
                            ->where('grd_nombre', $nombre)
                            ->get()->result_array();
            if (count($validar_nombre) > 0) {
                if ($validar_nombre[0]['grd_id'] == $id) {
                    $id = $validar_nombre[0]['grd_id'];
                }
            } else {
                $id = 0;
            }
        } else {
            $validar_nombre = $this->db->select('grd_nombre,grd_id')
                            ->from('grd_grado')
                            ->where('grd_nombre', $nombre)
                            ->get()->result_array();
            if (count($validar_nombre) > 0) {
                $id = $validar_nombre[0]['grd_id'];
            } else {
                $id = 0;
            }
        }
        $data = array(
            'id' => $id,
            'response' => true);
        echo json_encode($data);
    }

    function validar_orden_grado() {
        $orden = $this->input->post('orden');
        $id = $this->input->post('id');
        $area = $this->input->post('area');

        if ($id > 0) {
            $validar_nombre = $this->db->select('grd_orden,grd_id')
                            ->from('grd_grado')
                            ->where('grd_id <>', $id)
                            ->where('grd_orden', $orden)
                            ->where('grd_id_ard', $area)
                            ->get()->result_array();
            if (count($validar_nombre) > 0) {
                if ($validar_nombre[0]['grd_id'] == $id) {
                    $id = $validar_nombre[0]['grd_id'];
                }
            } else {
                $id = 0;
            }
        } else {
            $validar_nombre = $this->db->select('grd_orden,grd_id')
                            ->from('grd_grado')
                            ->where('grd_orden', $orden)
                            ->where('grd_id_ard', $area)
                            ->get()->result_array();
            if (count($validar_nombre) > 0) {
                $id = $validar_nombre[0]['grd_id'];
            } else {
                $id = 0;
            }
        }
        $data = array(
            'id' => $id,
            'response' => true);
        echo json_encode($data);
    }


    /**
     * @author Edith Herrera
     * @modified 2017-04-20
     * @return Grid del mantenimiento de configuración de cargos.
    * */
    function configuracion_cargo() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        $query_flag_curso = "SELECT CFG.cfg_id, CFG.cfg_codigo, CFG.cfg_nombre, 
                CFG.cfg_observacion, CFG.cfg_defecto, CFG.cfg_estado 
            FROM cfg_configuracion_cargo CFG
            INNER JOIN dfc_detalle_configuracion_cargo DFC on DFC.dfc_id_cfg = CFG.cfg_id
            INNER JOIN art_articulo ART ON ART.art_id = DFC.dfc_id_art
            INNER JOIN mod_modulo MODU ON MODU.mod_id_art = ART.art_id
            INNER JOIN pen_pensum PEN ON PEN.pen_id_mod = MODU.mod_id
            INNER JOIN ard_area_academica ARD ON ARD.ard_id = PEN.pen_id_ard
            INNER JOIN trd_tipo_area_academica TRD ON TRD.trd_id = ARD.ard_id_trd 
            WHERE (TRD.trd_es_curso_libre IS NULL OR TRD.trd_es_curso_libre = 0)
            GROUP BY CFG.cfg_id";

        $cfg_flag_curso = $this->db->query($query_flag_curso)->result_array();

        $query_no_es_modulo = "SELECT CFG.cfg_id, CFG.cfg_codigo, CFG.cfg_nombre, CFG.cfg_observacion, CFG.cfg_defecto, CFG.cfg_estado, 
                    (SELECT count(*) FROM mod_modulo WHERE mod_id_art = ART.art_id ) as verificar_modulo 
            FROM cfg_configuracion_cargo CFG
            INNER JOIN dfc_detalle_configuracion_cargo DFC on DFC.dfc_id_cfg = CFG.cfg_id
            INNER JOIN art_articulo ART ON ART.art_id = DFC.dfc_id_art 
            GROUP BY CFG.cfg_id
            HAVING verificar_modulo = 0";

        $cfg_no_es_modulo = $this->db->query($query_no_es_modulo)->result_array();

        $data['detalles'] = array_merge($cfg_flag_curso, $cfg_no_es_modulo);
        
        $data['titulo_personal'] = "Configuración de cargos";
        $this->_cargarvista($data);
    }

    function configuracion_cargo_curso() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        //$data['detalles'] = $this->registro_academico_model->get_config_cargo_curso();

        $query = "SELECT CFG.cfg_id, CFG.cfg_codigo, CFG.cfg_nombre, 
                    CFG.cfg_observacion, CFG.cfg_defecto, CFG.cfg_estado 
                FROM cfg_configuracion_cargo CFG
                INNER JOIN dfc_detalle_configuracion_cargo DFC ON DFC.dfc_id_cfg = CFG.cfg_id
                INNER JOIN art_articulo ART ON ART.art_id = DFC.dfc_id_art
                INNER JOIN mod_modulo MODU ON MODU.mod_id_art = ART.art_id
                INNER JOIN pen_pensum PEN ON PEN.pen_id_mod = MODU.mod_id
                INNER JOIN ard_area_academica ARD ON ARD.ard_id = PEN.pen_id_ard
                INNER JOIN trd_tipo_area_academica TRD ON TRD.trd_id = ARD.ard_id_trd 
                WHERE TRD.trd_es_curso_libre = 1
                GROUP BY CFG.cfg_id";

        $data['detalles'] = $this->db->query($query)->result_array();
          
        $data['titulo_personal'] = "Configuración de cargos";
        $this->_cargarvista($data);
    }


     /**
     * @author Edith Herrera
     * @since  2017-04-20
     * @return Acción de configuración de cargos (detalle).
    * */
    function configuraciones($id_cfg=null) {   
        satelite_validar();
        if ($_POST) {
            $post_array = $_POST;

            /***********  Datos pincipales ***********************/
            $codigo = $post_array['txtCodigo'];
            $nombre = $post_array['txtNombre'];
            $observacion = ($post_array['txtObservacion']!='') ? $post_array['txtObservacion'] : null;
            $defecto = (isset($post_array['defecto'])) ? 1:0;
            $id_conf = $post_array['id_conf'];

            $redir = $post_array['redireccion'];

            /*********************** Compara registro BD y registro ****************************/
            $id_dfc = $post_array['id_dfc'];

            if (!is_array($id_dfc)) { $id_dfc = array(); }

            if(!empty($id_dfc)){
                $detalle_bd= $this->gsatelite->get_tabla('dfc_detalle_configuracion_cargo', array('dfc_id_cfg'=>$id_conf));

                foreach ($detalle_bd as $exist) {
                    if (!in_array($exist['dfc_id'], $id_dfc)) {
                        $this->gsatelite->borrado_general('dfc_detalle_configuracion_cargo', array('dfc_id'=>$exist['dfc_id']));
                    }
                }
            }

            if($id_conf<=0){
                 // Codigo sugerido     
                $max_codigo = $this->gsatelite->get_max('cfg_configuracion_cargo', 'cfg_codigo', null);
                  
                $codigo = intval(preg_replace('/[^0-9]+/', '', $max_codigo), 10);
                $codigo = $codigo + 1;
                $codigo_con_zeros = str_pad($codigo, 3, "0", STR_PAD_LEFT);
                $codigo = $codigo_con_zeros;
            }
            
            $array_conf = array(
                'cfg_codigo'=>$codigo,
                'cfg_nombre'=>$nombre,
                'cfg_observacion'=>$observacion,
                'cfg_defecto'=>$defecto,
                'cfg_estado'=>1,
                'cfg_usu_creacion'=>$this->tank_auth->get_user_id(),
                'cfg_fecha_creacion'=>date('Y-m-d H:i:s'),
                'cfg_usu_modificacion'=>$this->tank_auth->get_user_id(),
                'cfg_fecha_modificacion'=>date('Y-m-d H:i:s')
                );

            if($id_conf<=0){
                $conf = $this->gsatelite->ingresar('cfg_configuracion_cargo', $array_conf);
            }else{
                unset($array_conf['cfg_usu_creacion'], $array_conf['cfg_fecha_creacion']);
                $act = $this->gsatelite->actualizar_array('cfg_configuracion_cargo', $array_conf, array('cfg_id'=>$id_conf));
            }

    
            // DETALLES A INGRESAR
            $articulo = $post_array['detalle_articulo'];
            $cuota = $post_array['detalle_cuota'];
            $cargo = $post_array['detalle_cargo'];
            $plazo = $post_array['detalle_plazo'];
            $mora = ($post_array['detalle_mora']>0) ? $post_array['detalle_mora'] : null;
            $tipo_apl_mora = $post_array['detalle_tipo_apl_mora'];
            $valor_mora = $post_array['detalle_valor_mora'];

            $ingreso = 0;
            if($conf>0 || $act>0){
                foreach ($articulo as $key => $value) {
                    $array_dfc = array(
                            'dfc_id_cfg'=>($conf>0)?$conf:$id_conf,
                            'dfc_id_art'=>$value,
                            'dfc_id_art_mora'=>($mora[$key]>0)?$mora[$key]:null,
                            'dfc_numero_cuota'=>$cuota[$key],
                            'dfc_dia_fecha_cargo'=>$cargo[$key],
                            'dfc_dias_plazo'=>$plazo[$key],
                            'dfc_tipo_aplicacion_mora'=>$tipo_apl_mora[$key],
                            'dfc_valor_mora'=>$valor_mora[$key],
                            'dfc_estado'=>1,
                            'dfc_usu_creacion'=>$this->tank_auth->get_user_id(),
                            'dfc_fecha_creacion'=>date('Y-m-d H:i:s'),
                            'dfc_usu_modificacion'=>$this->tank_auth->get_user_id(),
                            'dfc_fecha_modificacion'=>date('Y-m-d H:i:s')
                    );

                    $ingreso = $this->gsatelite->ingresar('dfc_detalle_configuracion_cargo', $array_dfc);
            
                }
            }
  
            if ( $ingreso > 0 || $conf > 0 || $act > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro procesado", 'texto_alerta' => "Registro procesado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no procesado", 'texto_alerta' => "El registro no pudo ser procesado, verifique la información ingresada.");
            }
            

            $this->session->set_flashdata($alerta);
            if($redir>0){
                redirect('registro_academico/mantenimientos/configuracion_cargo'); // grid
            }else{
                if($id_conf>0){
                    redirect('registro_academico/mantenimientos/configuraciones/'.$id_conf); //editar
                }else{
                    redirect('registro_academico/mantenimientos/configuraciones'); // agregar
                }
            }
        }else{
            $data['id_conf'] = $id_cfg;

            if($id_cfg>0){
                $registro = $this->registro_academico_model->get_config_cargos(array('cfg_id'=>$id_cfg));
                $data['detalle'] = $registro;
                $data['registro'] = $registro[0];
                $data['codigo'] = $registro[0]['cfg_codigo'];
            }else{
                // Codigo sugerido     
                $max_codigo = $this->gsatelite->get_max('cfg_configuracion_cargo', 'cfg_codigo', null);
                  
                $codigo = intval(preg_replace('/[^0-9]+/', '', $max_codigo), 10);
                $codigo = $codigo + 1;
                $codigo_con_zeros = str_pad($codigo, 3, "0", STR_PAD_LEFT);
                $data['codigo'] = $codigo_con_zeros;
            }

            $data['titulo_personal'] = "Configuración de cargos";
            $this->_cargarvista($data);
        }
       
    }

    function get_cursos_libres() {
        satelite_validar(true);
        $curso  = (trim($this->input->post('curso')) != '') ? trim($this->input->post('curso')) : null;

        $arreglo = array();

        if(isset($curso)) {
            $query = "SELECT mod_id_art, mod_nombre FROM mod_modulo MODU
                INNER JOIN pen_pensum PEN ON PEN.pen_id_mod = MODU.mod_id
                INNER JOIN ard_area_academica ARD ON ARD.ard_id = PEN.pen_id_ard
                INNER JOIN trd_tipo_area_academica TRD ON TRD.trd_id = ARD.ard_id_trd
                INNER JOIN art_articulo ART ON ART.art_id = MODU.mod_id_art
                WHERE TRD.trd_es_curso_libre = 1 AND mod_nombre LIKE '%".$curso."%' AND ART.art_estado = 1";

            $resultado = $this->db->query($query)->result_array();

            if(count($resultado) > 0) {
                $arreglo = $resultado;
            }

        }

        echo json_encode($arreglo);
    }

    function configuraciones_cursos($id_cfg=null) {   
        satelite_validar();
        if ($_POST) {
            $post_array = $_POST;

            /***********  Datos pincipales ***********************/
            $codigo = $post_array['txtCodigo'];
            $nombre = $post_array['txtNombre'];
            $observacion = ($post_array['txtObservacion']!='') ? $post_array['txtObservacion'] : null;
            $defecto = (isset($post_array['defecto'])) ? 1:0;
            $redir = $post_array['redireccion'];
            $id_conf = $post_array['id_conf']; //ID PADRE - CASO EDITAR
            /*********************** Compara registro BD y registro ****************************/
            if(!($id_conf > 0)){
                // Codigo sugerido
                $max_codigo = $this->gsatelite->get_max('cfg_configuracion_cargo', 'cfg_codigo', null);
                $codigo = intval(preg_replace('/[^0-9]+/', '', $max_codigo), 10);
                $codigo = $codigo + 1;
                $codigo_con_zeros = str_pad($codigo, 3, "0", STR_PAD_LEFT);
                $codigo = $codigo_con_zeros;
            }
            $id_dfc = $post_array['id_dfc'];

            if (!is_array($id_dfc)) { $id_dfc = array(); }
            if( $id_conf > 0 && (!(empty($id_dfc))) ){
                $detalle_bd= $this->gsatelite->get_tabla('dfc_detalle_configuracion_cargo', array('dfc_id_cfg'=>$id_conf));
                foreach ($detalle_bd as $exist) {
                    if (!in_array($exist['dfc_id'], $id_dfc)) {
                        $this->gsatelite->borrado_general('dfc_detalle_configuracion_cargo', array('dfc_id'=>$exist['dfc_id']));
                    }
                }
            }
            $array_conf = array(
                'cfg_codigo'=>$codigo,
                'cfg_nombre'=>$nombre,
                'cfg_observacion'=>$observacion,
                'cfg_defecto'=>$defecto,
                'cfg_estado'=>1,
                'cfg_usu_creacion'=>$this->tank_auth->get_user_id(),
                'cfg_fecha_creacion'=>date('Y-m-d H:i:s'),
                'cfg_usu_modificacion'=>$this->tank_auth->get_user_id(),
                'cfg_fecha_modificacion'=>date('Y-m-d H:i:s')
                );
            if ($id_conf > 0) {
                unset($array_conf['cfg_usu_creacion']);
                unset($array_conf['cfg_fecha_creacion']);
                $cargo_curso = $this->gsatelite->actualizar_array('cfg_configuracion_cargo', $array_conf, array('cfg_id'=>$id_conf));
            }else{
                $cargo_curso = $this->gsatelite->ingresar('cfg_configuracion_cargo', $array_conf);
            }

    
            // DETALLES A INGRESAR
            $articulo = $post_array['detalle_articulo']; //articulos
            $cuota  = $post_array['detalle_cuota']; //ctdad cuotas
            $cargo  = $post_array['detalle_cargo']; // dia dell cargo
            $plazo  = $post_array['detalle_plazo'];// dias plazo
            $mora   = $post_array['detalle_mora']; // articulo mora
            $tipo_apl_mora = $post_array['detalle_tipo_apl_mora']; //tipo $|% si aplica
            $valor_mora = $post_array['detalle_valor_mora']; // monto en $  o   porcentaje

            $ingreso = 0;
            if($cargo_curso > 0){
                foreach ($id_dfc as $key => $value) {
                    $array_dfc = array(
                        'dfc_id_cfg' => ($id_conf > 0) ? $id_conf : $cargo_curso,
                        'dfc_id_art' => $articulo[$key],
                            'dfc_id_art_mora'=>($mora[$key]>0)?$mora[$key]:null,
                            'dfc_numero_cuota'=>$cuota[$key],
                            'dfc_dia_fecha_cargo'=>$cargo[$key],
                            'dfc_dias_plazo'=>$plazo[$key],
                        'dfc_tipo_aplicacion_mora' => ($tipo_apl_mora[$key] != "") ? intval($tipo_apl_mora[$key]) : null,
                        'dfc_valor_mora' => ($valor_mora[$key] != "") ? $valor_mora[$key] : null,
                            'dfc_estado'=>1,
                            'dfc_usu_modificacion'=>$this->tank_auth->get_user_id(),
                            'dfc_fecha_modificacion'=>date('Y-m-d H:i:s')
                    );
                    if ($value > 0) {
                        $ingreso += $this->gsatelite->actualizar_array('dfc_detalle_configuracion_cargo', $array_dfc, array('dfc_id' => $value));
                    } else {
                        $array_dfc['dfc_usu_creacion'] = $this->tank_auth->get_user_id();
                        $array_dfc['dfc_fecha_creacion'] = date('Y-m-d H:i:s');
                        $ingreso += $this->gsatelite->ingresar('dfc_detalle_configuracion_cargo', $array_dfc);                    
                }
            }
            }  
            if ($ingreso > 0 && $cargo_curso > 0 ) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro procesado", 'texto_alerta' => "Registro procesado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no procesado", 'texto_alerta' => "El registro no pudo ser procesado, verifique la información ingresada.");
            }
            $this->session->set_flashdata($alerta);
            if($redir>0){
                redirect('registro_academico/mantenimientos/configuracion_cargo_curso'); // grid
            }else{
                if($id_conf>0){
                    redirect('registro_academico/mantenimientos/configuraciones_cursos/'.$id_conf); //editar
                }else{
                    redirect('registro_academico/mantenimientos/configuraciones_cursos'); // agregar
                }
            }
        }else{
            $data['id_conf'] = $id_cfg;

            if($id_cfg>0){
                $registro = $this->registro_academico_model->get_config_cargos(array('cfg_id'=>$id_cfg));
                $data['detalle'] = $registro;
                $data['registro'] = $registro[0];
                $data['codigo'] = $registro[0]['cfg_codigo'];
            }else{
                // Codigo sugerido     
                $max_codigo = $this->gsatelite->get_max('cfg_configuracion_cargo', 'cfg_codigo', null);
                $codigo = intval(preg_replace('/[^0-9]+/', '', $max_codigo), 10);
                $codigo = $codigo + 1;
                $codigo_con_zeros = str_pad($codigo, 3, "0", STR_PAD_LEFT);
                $data['codigo'] = $codigo_con_zeros;
            }
            $data['titulo_personal'] = "Configuración de cargos";
            $this->_cargarvista($data);
        }
       
    }


    function validar_codigo_config()
    {
        $codigo=$this->input->post('codigo');
        $id=$this->input->post('id');
        if(isset($id) && $id>0){
            $validar_codigo=$this->db->select('cfg_codigo, cfg_id')
            ->from('cfg_configuracion_cargo')
            ->where('cfg_id <>',$id)
            ->where('cfg_codigo',$codigo)
                ->get()->result_array()
            ;
            if(count($validar_codigo)>0){

                if($validar_codigo[0]['cfg_id']==$id){
                    $id=$validar_codigo[0]['cfg_id'];
                }
            } else{
                $id=0;
            }
        }else{
            $validar_codigo=$this->db->select('cfg_codigo, cfg_id')
            ->from('cfg_configuracion_cargo')
            ->where('cfg_codigo',$codigo)
                ->get()->result_array()
            ;
            if(count($validar_codigo)>0){
                $id=$validar_codigo[0]['cfg_id'];
            } else{
                $id=0;
            }
        }
        echo json_encode($id);
    }

    public function validar_defecto_conf(){
        $id=$this->input->post('id');
        
        if(isset($id) && $id>0){
            $validar_codigo = $this->gsatelite->get_tabla('cfg_configuracion_cargo', array('cfg_id <>'=>$id, 'cfg_defecto'=>1));
            if(count($validar_codigo)>0){
                if($validar_codigo[0]['cfg_id']==$id){
                    $id=$validar_codigo[0]['cfg_id'];
                }
            }else{
                $id=0;
            }
        }else{
            $validar_codigo = $this->gsatelite->get_tabla('cfg_configuracion_cargo', array('cfg_defecto'=>1));
            if(count($validar_codigo)>0){
                $id=$validar_codigo[0]['cfg_id'];
            }else{
                $id=0;
            }
        }
        echo json_encode($id);
    }

    /**
     * @author Edith Herrera
     * @since  2018-09-26
     * @return Mantenimiento de configuración de grupos familiares.
    * */
    function conf_grupo_familiar() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('registro_academico/mantenimientos/grupo_familiar');
            $crud = new grocery_CRUD();
            $crud->set_subject('Configuración')->set_table('grf_grupo_familiar');
            $crud->columns('grf_cantidad', 'grf_porcentaje', 'grf_id_art', 'grf_estado');
            $crud->display_as('grf_cantidad', 'Cantidad')
                 ->display_as('grf_porcentaje', 'Porcentaje')
                 ->display_as('grf_id_art', 'Descuento')
                 ->display_as('grf_estado', 'Estado');
            $crud->add_fields('grf_cantidad', 'grf_porcentaje', 'grf_id_art', 'grf_estado', 'grf_usu_creacion', 'grf_fecha_creacion', 'grf_usu_modificacion', 'grf_fecha_modificacion');
            $crud->edit_fields('grf_cantidad', 'grf_porcentaje', 'grf_id_art', 'grf_estado', 'grf_usu_modificacion', 'grf_fecha_modificacion');
            $crud->required_fields('grf_cantidad', 'grf_porcentaje', 'grf_id_art', 'grf_estado');
            $crud->set_relation('grf_id_art', 'art_articulo', 'art_nombre', array('art_estado' => '1'));
            
            $crud->set_rules('grf_cantidad', 'Cantidad', 'trim|required|is_numeric');
            $crud->set_rules('grf_porcentaje', 'Porcentaje', 'trim|required|is_numeric');

            $crud->field_type('grf_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('grf_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('grf_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('grf_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('grf_estado', 'hidden', 1);
            } else {
                $crud->field_type('grf_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'registro_academico/mantenimientos/conf_grupo_familiar/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Configuracion de grupos familiares";

            $this->_cargarvista($data, $output);
            
        }
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de alergias  (tabla: coa_componente_alergico)
     * Funcionalidad Compartida del Modulo de Expediente Personal - coa_componente_alergico
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-11-06
     * @param ninguno
     * @return Mantenimiento de Alergias
     */
    public function alergia() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->alergia();
    }    

    /**
     * Descripción:
     * Función para dar mantenimiento de alergias  (tabla: tsr_tipo_sangre)
     * Funcionalidad Compartida del Modulo de Expediente Personal - tsr_tipo_sangre
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-11-06
     * @param ninguno
     * @return Mantenimiento de Tipo de Sangre
     */
    public function tipo_sangre() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->tipo_sangre();
    } 

    /**
     * Descripción:
     * Función para dar mantenimiento de alergias  (tabla: tds_tipo_discapacidad)
     * Funcionalidad Compartida del Modulo de Expediente Personal - tds_tipo_discapacidad
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-11-06
     * @param ninguno
     * @return Mantenimiento de Tipos de Discapacidad
     */
    public function tipo_discapacidad() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->tipo_discapacidad();
    }

    function _cargarvista($data = 0, $crud = 0, $ruta_vista='') {
        $this->load->view('vacia', $crud);
        if ($data != 0){
            $data = array_merge($data, $this->masterpage->getUsuario());
        }else{
            $data = $this->masterpage->getUsuario();
        }
        $vista = (trim($ruta_vista) != '' and substr_count(trim($ruta_vista),'/') > 1 )? trim($ruta_vista):$data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a los dias no laborales (tabla: dnl_dia_no_laboral)
     * @author Herberth Lucho - Grupo satélite
     * @since  2019-09-21
     * @param  Ninguno
     * @return Mantenimiento de dias no laborales
     */
    public function dias_no_laborales() {
        satelite_validar();

        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();

            $columnas = array(
                'dnl_descripcion',
                'dnl_tipo',
                'dnl_fecha_inicio',
                'dnl_fecha_fin'                
            );

            $alias = array(
                'dnl_tipo'=>'Tipo',
                'dnl_fecha_inicio'=> 'Fecha inicio',
                'dnl_fecha_fin'=> 'Fecha fin',
                'dnl_descripcion'=> 'Descripción'
            );

            $crud->set_table('dnl_dia_no_laboral')
                    ->set_subject('Días No Laborales')
                    ->columns($columnas)
                    ->display_as($alias)
                    ->field_type('dnl_fecha_inicio', 'date', date('d-m-Y'))
                    ->field_type('dnl_fecha_fin', 'date', date('d-m-Y'))
                    ->field_type('dnl_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('dnl_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('dnl_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('dnl_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('dnl_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'))
                    ->field_type('dnl_tipo', 'dropdown', array('1' => 'Fijo', '2' => 'Variable'))
                    ->add_action('Editar', '', "registro_academico/mantenimientos/editar_dias_no_laborales", 'icomoon-icon-pencil-5')
                    ->add_action('Eliminar', 'icon16 icomoon-icon-remove', 'registro_academico/mantenimientos/eliminar_dias_no_laborales', 'eliminar_dias_no_laborales')
                    ->unset_add()
                    ->unset_edit()
                    ->unset_read()
                    ->unset_delete()
            ;

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('dnl_estado', 'hidden', 1);
            } else {
                $crud->field_type('dnl_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            /*if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }*/

            $output = $crud->render();
            $data['titulo_personal'] = "Días No Laborales";

            cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function ingresar_dias_no_laborales() {
        satelite_validar();
        //$permisos = $this->gsatelite->get_permisos_opcion('facturacion/entradas/mantenimiento_caja');

        if ($this->input->post()) {
            // print_r($_POST);die();

            $nombre = (trim($this->input->post('nombre')) != "")?$this->input->post('nombre'):null;
            $fecha_inicio = $this->input->post('fecha_inicio_hidden');
            $fecha_fin = $this->input->post('fecha_fin_hidden');
            $dnl_descripcion = ($this->input->post('descripcion') != "")? $this->input->post('descripcion'):null;            
            $slc_tipo = ($this->input->post('slc_tipo') != "")? $this->input->post('slc_tipo'):null;

            $columnas_insert = array(
                'dnl_nombre' => $nombre,
                'dnl_fecha_inicio' => formatear_fecha('Y-m-d', $fecha_inicio),
                'dnl_fecha_fin' => formatear_fecha('Y-m-d', $fecha_fin),
                'dnl_descripcion' => $dnl_descripcion,
                'dnl_tipo' => $slc_tipo[0],
                'dnl_estado' => 1,
                'dnl_usu_creacion' => $this->tank_auth->get_user_id(),
                'dnl_fecha_creacion' => date('Y-m-d H:i:s'),
                'dnl_usu_modificacion' => $this->tank_auth->get_user_id(),
                'dnl_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $dia_id = $this->gsatelite->ingresar('dnl_dia_no_laboral', $columnas_insert);
            
            // Mostrar alerta
            if ($dia_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de día laboral", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de día laboral", 'texto_alerta' => "El registro no se guardó.");
            }

            $this->session->set_flashdata($alerta);
            $redireccion = $this->input->post("redireccion");

            if ($redireccion == 1) {
                redirect('registro_academico/mantenimientos/ingresar_dias_no_laborales');
            } else if ($redireccion == 2) {
                redirect('registro_academico/mantenimientos/dias_no_laborales');
            }
            die();
        } else {

            $data['titulo_personal'] = 'Agregar Días No Laborales';
            $this->_cargarvista($data);
        }
    }

    public function editar_dias_no_laborales($dia_ide){
        satelite_validar();
        //$permisos = $this->gsatelite->get_permisos_opcion('facturacion/entradas/mantenimiento_caja');

        $data_dias = $this->gsatelite->get_tabla('dnl_dia_no_laboral',array('dnl_estado' => 1, 'dnl_id' => $dia_ide));
        $data['dia_id']           = $data_dias[0]['dnl_id']; 
        $data['descripcion_dia']      = $data_dias[0]['dnl_descripcion'];
        $data['fechainicio']      = $data_dias[0]['dnl_fecha_inicio'];
        $data['fechafin']         = $data_dias[0]['dnl_fecha_fin'];
        $data['nombre']           = $data_dias[0]['dnl_nombre'];
        $data['estado']           = $data_dias[0]['dnl_estado'];
        $data['tipo_selected']             = $data_dias[0]['dnl_tipo'];

        if ($this->input->post()) {
            // print_r($_POST);die();

            $dias_id = (trim($this->input->post('id_dia')) != "")?$this->input->post('id_dia'):null;
            $nombre = (trim($this->input->post('nombre')) != "")?$this->input->post('nombre'):null;
            $fecha_inicio = $this->input->post('fecha_inicio_hidden');
            $fecha_fin = $this->input->post('fecha_fin_hidden');
            $dnl_descripcion = ($this->input->post('descripcion') != "")? $this->input->post('descripcion'):null;            
            $slc_tipo = ($this->input->post('slc_tipo') != "")? $this->input->post('slc_tipo'):null;

            $columnas_insert = array(
                'dnl_nombre' => $nombre,
                'dnl_fecha_inicio' => formatear_fecha('Y-m-d', $fecha_inicio),
                'dnl_fecha_fin' => formatear_fecha('Y-m-d', $fecha_fin),
                'dnl_descripcion' => $dnl_descripcion,
                'dnl_tipo' => $slc_tipo[0],
                'dnl_usu_modificacion' => $this->tank_auth->get_user_id(),
                'dnl_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $dia_id = $this->gsatelite->actualizar_array('dnl_dia_no_laboral', $columnas_insert, array('dnl_id' => $dias_id));
            // Mostrar alerta
            if ($dia_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de promocion", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de promocion", 'texto_alerta' => "El registro no se guardó.");
            }

            $this->session->set_flashdata($alerta);
            $redireccion = $this->input->post("redireccion");

            if ($redireccion == 1) {
                redirect('registro_academico/mantenimientos/editar_dias_no_laborales/'.$dias_id);
            } else if ($redireccion == 2) {
                redirect('registro_academico/mantenimientos/dias_no_laborales');
            }
            die();
        } else {
            $data['titulo_personal'] = 'Editar Días No Laborales';
            cargarvista($data, 0, 'registro_academico/mantenimientos/editar_dias_no_laborales');
        }
    }

    /**
    * @author Herberth Lucho
    * @since  2019-09-23
    * @param  id_dia
    * @return Mensaje de confirmacion si es posible eliminar el dia
    */
    public function  eliminar_dias_no_laborales(){
        satelite_validar();
        $id  =  $this->input->post('dias_id');
        
        $mov = $this->gsatelite->borrado_general('dnl_dia_no_laboral', array('dnl_id' => $id));

        if (!$mov) {
            echo json_encode(array('respuesta'=> 0));
            die();
        }else{
             echo json_encode(array('respuesta'=> 1));
        }
    }

     /**
        * Descripción:
        * Mantenimiento para la tabla de trd_tipo_area_academica
        * @author Francisco Orozco - Grupo Satélite
        * @since 2019-10-01
        * @param none
        * @return mantenimiento
    */
    public function tipo_area_academica(){
        satelite_validar();    
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();

        $columns = array(
            'trd_nombre',
            'trd_descripcion',
            'trd_es_curso_libre',
            'trd_estado',
        );

        $alias = array(
            'trd_nombre'        => 'Nombre',
            'trd_descripcion'   => 'Descripcion',
            'trd_es_curso_libre' => '¿Es curso libre?',
            'trd_estado'        => 'Estado'
        );     

        $add_fields= array(
            'trd_nombre', 
            'trd_descripcion',
            'trd_es_curso_libre',
            'trd_estado', 
            'trd_usu_creacion',
            'trd_fecha_creacion',
            'trd_usu_modificacion',
            'trd_fecha_modificacion'
        );

        $edit_fields= array(
            'trd_nombre', 
            'trd_descripcion',
            'trd_es_curso_libre',
            'trd_estado',            
            'trd_usu_modificacion',
            'trd_fecha_modificacion'
        );

        $required = array(
            'trd_nombre',            
            'trd_estado',            
            'trd_usu_modificacion',
            'trd_fecha_modificacion'
        );

        $crud->set_table('trd_tipo_area_academica')
            ->add_fields($add_fields)
            ->edit_fields($edit_fields)
            ->required_fields($required)
            ->display_as($alias)
            ->columns($columns)
            ->callback_column('trd_es_curso_libre', function ($value, $row) {
                return $value ? 'Sí' : 'No';
            })
            ->callback_add_field('trd_es_curso_libre', function () {
                return '<input type="checkbox" id="chescurlb" class="nostyle"><input type="hidden" id="field-trd_es_curso_libre" name="trd_es_curso_libre" value="0">';
            })
            ->callback_edit_field('trd_es_curso_libre', function ($value, $primary_key) {
                $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
                $defecto = ($value) ? 'checked' : ''; // Verificar si esta activo
                return '<input type="checkbox" id="chescurlb" ' . $defecto . ' class="' . $leer . ' nostyle"><input type="hidden" id="field-trd_es_curso_libre" name="trd_es_curso_libre" value="' . $value . '">';
            })
            ->field_type('trd_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('trd_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
        ;

        $urlx= explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->field_type('trd_estado', 'hidden', 1)
                    ->field_type('trd_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('trd_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $crud->field_type('trd_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if(!$permisos["permite_editar"]){
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Tipo de área';
        $this->_cargarvista($data, $output);
    }

    /**
        * Descripción:
        * Mantenimiento para mostrar los 
        * @author Grupo Satélite
        * @since 2023-05-11
        * @param none
        * @return mantenimiento
    */
    function medio_contacto_academico() {
        satelite_validar();
        // Variable para permisos. Agregado por Luis Navarro
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD;
        $alias = array('tmc_nombre' => 'Nombre',
            'tmc_estado' => 'Estado');
        $colums = array('tmc_nombre',
            'tmc_estado');
        $edit = array('tmc_nombre',
            'tmc_estado',
            'tmc_usu_modificacion',
            'tmc_fecha_modificacion');
        $add = array('tmc_nombre',
            'tmc_estado',
            'tmc_usu_creacion',
            'tmc_fecha_creacion',
            'tmc_usu_modificacion',
            'tmc_fecha_modificacion');

        $crud->set_table('tmc_tipo_medio')
                ->set_subject('')
                ->display_as($alias)
                ->columns($colums)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($add)
                ->field_type('tmc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tmc_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                ->set_rules('tmc_nombre', 'Nombre', 'trim|required|campo_unico[tmc_tipo_medio.tmc_nombre]')
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tmc_estado', 'hidden', 1)
                    ->field_type('tmc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('tmc_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
            ;
        } else {
            $crud->field_type('tmc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validar Permisos. Agregado por Luis Navarro
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }


        $output = $crud->render();
        $data['titulo_personal'] = "Medio de contacto Academico";
        $this->_cargarvista($data, $output);
    }

    function academic_institution(){
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->institucion(array("registro_academico\mantenimientos/academic_institution", ""));
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */