<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Consultas extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('registro_academico_model');
        $this->load->model('personal_model');

        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
    }

    function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {            
            $this->_cargarvista();
        }
    }

    function notas_modulo()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $areasAcademicas = $this->gsatelite->get_tabla('ard_area_academica');

            $data["areas_academicas"] = $areasAcademicas;    
            $data["titulo_personal"] ="Reporte de notas por nivel";

            $this->_cargarvista($data);
        }
    }


    public function consultar_notas_modulos($imprimir)
    {
            $modulo= $this->input->post('modulo');
            $area= $this->input->post('area');
            $fecha_ini= $this->input->post('fecha_ini');
            $fecha_fin = $this->input->post('fecha_fin');

            if ($fecha_ini != null && $fecha_fin != null ) {
                $fecha_inicio=date('Y-m-d', strtotime($fecha_ini));
                $fecha_fn=date('Y-m-d', strtotime($fecha_fin));
            }else{
                $fecha_inicio='';
                $fecha_fn='';
            }

            
            $sucursal_str = $this->get_sucursales();                          
            //$this->db->where('gra_id_suc in('.$sucursal_str.')',NULL);
            //$this->db->where('alm_id_suc in('.$sucursal_str.')',NULL);
            $data['datos_notas_mod'] = $datos_notas_mod = $this->personal_model->obtener_notas_modulos($fecha_inicio, $fecha_fn, $modulo, null, 1, 'gra_id');

            $array_grupo = array();
            $array_alm = array();
            foreach ($datos_notas_mod as $grp) {
                $grupo = $grp['gra_id'];

            //////////////////////////////////////////////////////////////////////////////////////////

                $frh = $this->gsatelite->get_campo('gra_grupo_academico', 'gra_id_frh', array('gra_id'=>$grupo));
                
                $this->db->where('gra_id_suc in('.$sucursal_str.')',NULL);
                $data['registro'] =  $this->registro_academico_model->get_frecuencias(array('dfr_id_frh'=>$frh));

                //////////////////////////// Info grupos ////////////////////////////////////////////////////////
                $this->db->where('gra_id_suc in('.$sucursal_str.')',NULL);
                $grd =  $this->gsatelite->get_registro('gra_grupo_academico', array('gra_id'=>$grupo));
                
                //////////////////////// SI EL GRUPO ES DE BACHILLERATO ///////////////////////////////////////////
                if(count($grd)>0 && $grd->gra_id_grd>0){
                    $where['pen_id'] = $grd->gra_id_pen;
                    $where['lxp_condicion !='] = (4);
                    $registros = $this->registro_academico_model->get_materias_grado($where, 'alm_id');

                    
                    $cant_notas = 0;
                    if(count($registros)>0){
                        foreach ($registros as $key) {
                            $array = array(); // Array de datos del alumno
                            $notas_alm = array(); // Array de notas por alumno
                            $promedio = array(); // Array de promedios por alumno.
                            $pensum = $key['pen_id'];
                            $lxp = $key['lxp_id'];

                            array_push($array, $key['gra_nombre']);
                            array_push($array, $key['aul_nombre']);
                            array_push($array, $key['alm_codigo']);
                            array_push($array, $key['alumno']);
                            array_push($array, $key['ard_nota_minima']);

                            $notas = $this->registro_academico_model->get_promedio_periodo(array('pen_id'=>$pensum, 'noa_id_lxp'=>$lxp));

                            ///////////// Se forma arreglo de notas por alumno y materia recorrida////////////////
                            if(count($notas)>0){
                                $notas_alm = array_column($notas, 'nota');
                                $promedio = array_column($notas, 'promedio');
                            }
                            
                            /////// Se rellenan los espacios para completar las 4 notas (promedio por periodo) /////
                            if(count($notas)<4){
                                $cant = 4- count($notas);
                                for ($i=1; $i <= $cant ; $i++) { 
                                    $notas_alm[] = "";
                                }
                            }

                            $total_prom = array_sum($promedio);
                            array_push($array, $total_prom);
                            $notas_imp = implode(',', $notas_alm); 
                            array_push($array, $notas_imp);

                            $cant_notas = count($notas_alm);
                            $array_alm[] = $array;
                        }
                    }
                    $data['cant_notas'] = $cant_notas;
                    $data['registros'] = $array_alm;

                }else{  //////////////////////// SI EL GRUPO ES DE CURSO LIBRE ////////////////////////////////////////
                    $where = array('lxp_condicion !='=>(4),'gra_id'=>$grupo);
                    if($alumno>0){
                        $where['lxa_id_alm']=$alumno;
                    }

                    $registros = $this->registro_academico_model->obtener_info_grupos(null,null,null,$where, null, 'alm_id, gra_id');
                  
                    $cant_notas = 0;
                    $where= array();
                    if(count($registros)>0){ 
                        foreach ($registros as $key) {
                            $array = array(); // Array por alumno
                            $notas_alm = array(); // Array de notas por alumno
                            $promedio = 0; // Promedio por alumno

                            array_push($array, $key['gra_nombre']);
                            array_push($array, $key['aul_nombre']);
                            array_push($array, $key['Codigo']);
                            array_push($array, $key['Participante']);
                            array_push($array, $key['minima']);

                            $where['lxp_estado']=1;
                            $where['lxp_id']=$key['lxp_id'];
                            $where['gra_id']=$key['gra_id'];
                            $where['pen_id_ard']=$key['ard_id'];
                            $where['lxp_condicion !=']=(4);  
                                                        
                            $sucursal_str = $this->get_sucursales();                          
                            $where['alm_id_suc in('.$sucursal_str.')'] = NULL;
                            $where['gra_id_suc in('.$sucursal_str.')'] = NULL;                            

                            $notas = $this->registro_academico_model->get_AlumnosxGruposAcademicos($where, null, null, 'evm_orden');
                            ///////////// Se forma arreglo de notas por alumno y materia recorrida////////////////
                            if(count($notas)>0){

                                $notas_alm = array_column($notas, 'noa_nota');
                                $promedio = $notas[0]['promedio'];
                            }
                            
                            /////// Se rellenan los espacios para completar las 4 notas (promedio por periodo) /////
                            if(count($notas)<4){
                                $cant = 4- count($notas);
                                for ($i=1; $i <= $cant ; $i++) { 
                                    $notas_alm[] = "";
                                }
                            }
                            
                            array_push($array, $promedio);
                            $notas_imp = implode(',', $notas_alm); 
                            array_push($array, $notas_imp);
                            $cant_notas = count($notas_alm);
                            $cant_notas = count($notas_alm);
                            $array_alm[] = $array;
                        }
                    } 
                    $data['cant_notas'] = $cant_notas;
                    $data['registros'] = $array_alm;
                }
            } // End foreach
           
                ////////////////////////////////////////////////////////////////////////////////////////////////
               
                $data['datos_grupos'] = $registros;
                $data ['grupo_info'] = $grupo_info=$this->registro_academico_model->get_info_grupo($grupo);
                ///////////////////////////////////////////////////////////////////////////////////////////////////////////

                ////////////////////////////////// Configuración de decimales ////////////////////////////////////////
                $decimales = json_decode($this->gsatelite->get_parametro("RA_DECIMALES"),true);
                $data['cant_decimales'] = $decimales['decimales']; // Cantidad de decimales a mostrar en las notas.
                $data['min_aproxima'] = (isset($decimales['min_aproxima'])>0)?$decimales['min_aproxima']:0; // Cantidad mínima para aproximar promedios.
                $data['max_aproxima'] = (isset($decimales['max_aproxima'])>0)?$decimales['max_aproxima']:0; // Cantidad máxima para aproximar promedios.
            
                
                if ($imprimir == 1) {
                    $html = $this->load->view('registro_academico/consultas/consulta_alm_modulo', $data, true);
                    echo json_encode($html);
                    die();
                }elseif($imprimir == 2){
                    $data['encabezado'] =$this->load->view('reporte/header_excel', array('titulo' => "Notas Nivel"), true);
                    $this->load->view('registro_academico/consultas/reporte_alm_modulo_excel', $data);
                }
    }



    public function mostrar_modulos($value='')
    {
        if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
        } else {
            $area= $_POST['idP'];
            $modulos_extraidos = $this->personal_model->obtener_modulos($area);

            if (!empty($modulos_extraidos)) {
                $cadena="<option value='' selected></option>";

                foreach ($modulos_extraidos as $key => $value) {
                    $cadena.="<option value='".$value['mod_id']."'>".$value['mod_nombre']."</option>";
                }
                echo json_encode(array('modulosjson' => $cadena));
            } else {   
                echo json_encode(array('modulosjson' => "<option>no existen modulos para esta área</option>" ));

            }     
        }
    }

    public function mostrar_alumnos_()
    {
        if (!$this->tank_auth->is_logged_in()) {
                    redirect('/auth/login/');
        } else {
            $programa       = $this->input->post('programa');
            $where          = 'lxp_alumnoxpensum.lxp_condicion IN (1,2)';
            //$sucursal_str   = $this->get_sucursales();                          
            //$where['alm_id_suc in('.$sucursal_str.')'] = NULL;
            $alumnos = $this->registro_academico_model->obtener_alumnos_grupos($programa,  $where);

            if (!empty($alumnos)) {
                $cadena="<option value='' selected></option>";
                foreach ($alumnos as $key => $value) {
                    $cadena.="<option value='".$value['alm_id']."'>".$value['Participante']."</option>";
                }
                echo json_encode(array('modulosjson' => $cadena));
            } else {
                echo json_encode(array('modulosjson' => "<option>No se encontraron alumnos</option>" ));
            }
        }
    }
    

    public function reporte_notas_modulos($id,$area=null)
        {
             $modulo= $this->input->post('modulo');
            $area= $this->input->post('area');
            $fecha_ini= $this->input->post('fecha_ini');
            $fecha_fin = $this->input->post('fecha_fin');

            if ($fecha_ini != null && $fecha_fin != null ) {
                $fecha_inicio=date('Y-m-d', strtotime($fecha_ini));
                $fecha_fn=date('Y-m-d', strtotime($fecha_fin));
            }else{
                $fecha_inicio='';
                $fecha_fn='';
            }
            $data['datos_notas_mod'] = $datos_notas_mod = $this->personal_model->obtener_notas_modulos($fecha_inicio, $fecha_fn, $modulo, null, 1, 'gra_id');

            $array_grupo = array();
            $array_alm = array();
            foreach ($datos_notas_mod as $grp) {
                $grupo = $grp['gra_id'];

            //////////////////////////////////////////////////////////////////////////////////////////

                $frh = $this->gsatelite->get_campo('gra_grupo_academico', 'gra_id_frh', array('gra_id'=>$grupo));

                $data['registro'] = $frecuencia =  $this->registro_academico_model->get_frecuencias(array('dfr_id_frh'=>$frh));

                //////////////////////////// Info grupos ////////////////////////////////////////////////////////
                $grd =  $this->gsatelite->get_registro('gra_grupo_academico', array('gra_id'=>$grupo));
                
                //////////////////////// SI EL GRUPO ES DE BACHILLERATO ///////////////////////////////////////////
                if(count($grd)>0 && $grd->gra_id_grd>0){
                    $where['pen_id'] = $grd->gra_id_pen;
                    $where['lxp_condicion !='] = (4);
                    $registros = $this->registro_academico_model->get_materias_grado($where, 'alm_id');

                    
                    $cant_notas = 0;
                    if(count($registros)>0){
                        foreach ($registros as $key) {
                            $array = array(); // Array de datos del alumno
                            $notas_alm = array(); // Array de notas por alumno
                            $promedio = array(); // Array de promedios por alumno.
                            $pensum = $key['pen_id'];
                            $lxp = $key['lxp_id'];

                            array_push($array, $key['gra_nombre']);
                            array_push($array, $key['aul_nombre']);
                            array_push($array, $key['alm_codigo']);
                            array_push($array, $key['alumno']);
                            array_push($array, $key['ard_nota_minima']);

                            $notas = $this->registro_academico_model->get_promedio_periodo(array('pen_id'=>$pensum, 'noa_id_lxp'=>$lxp));

                            ///////////// Se forma arreglo de notas por alumno y materia recorrida////////////////
                            if(count($notas)>0){
                                $notas_alm = array_column($notas, 'nota');
                                $promedio = array_column($notas, 'promedio');
                            }
                            
                            /////// Se rellenan los espacios para completar las 4 notas (promedio por periodo) /////
                            if(count($notas)<4){
                                $cant = 4- count($notas);
                                for ($i=1; $i <= $cant ; $i++) { 
                                    $notas_alm[] = "";
                                }
                            }

                            $total_prom = array_sum($promedio);
                            array_push($array, $total_prom);
                            $notas_imp = implode(',', $notas_alm); 
                            array_push($array, $notas_imp);

                            $cant_notas = count($notas_alm);
                            $array_alm[] = $array;
                        }
                    }
                    $data['cant_notas'] = $cant_notas;
                    $data['registros'] = $array_alm;

                }else{  //////////////////////// SI EL GRUPO ES DE CURSO LIBRE ////////////////////////////////////////
                    $where = array('lxp_condicion !='=>(4),'gra_id'=>$grupo);
                    if($alumno>0){
                        $where['lxa_id_alm']=$alumno;
                    }

                    $registros = $this->registro_academico_model->obtener_info_grupos(null,null,null,$where, null, 'alm_id, gra_id');
                  
                    $cant_notas = 0;
                    $where= array();
                    if(count($registros)>0){ 
                        foreach ($registros as $key) {
                            $array = array(); // Array por alumno
                            $notas_alm = array(); // Array de notas por alumno
                            $promedio = 0; // Promedio por alumno

                            array_push($array, $key['gra_nombre']);
                            array_push($array, $key['aul_nombre']);
                            array_push($array, $key['Codigo']);
                            array_push($array, $key['Participante']);
                            array_push($array, $key['minima']);

                            $where['lxp_estado']=1;
                            $where['lxp_id']=$key['lxp_id'];
                            $where['gra_id']=$key['gra_id'];
                            $where['pen_id_ard']=$key['ard_id'];
                            $where['lxp_condicion !=']=(4);    
                            $notas = $this->registro_academico_model->get_AlumnosxGruposAcademicos($where, null, null, 'evm_orden');
                            ///////////// Se forma arreglo de notas por alumno y materia recorrida////////////////
                            if(count($notas)>0){

                                $notas_alm = array_column($notas, 'noa_nota');
                                $promedio = $notas[0]['promedio'];
                            }
                            
                            /////// Se rellenan los espacios para completar las 4 notas (promedio por periodo) /////
                            if(count($notas)<4){
                                $cant = 4- count($notas);
                                for ($i=1; $i <= $cant ; $i++) { 
                                    $notas_alm[] = "";
                                }
                            }
                            
                            array_push($array, $promedio);
                            $notas_imp = implode(',', $notas_alm); 
                            array_push($array, $notas_imp);
                            $cant_notas = count($notas_alm);
                            $cant_notas = count($notas_alm);
                            $array_alm[] = $array;
                        }
                    } 
                    $data['cant_notas'] = $cant_notas;
                    $data['registros'] = $array_alm;
                }
            } // End foreach
           
            ////////////////////////////////////////////////////////////////////////////////////////////////
               
                $data['datos_grupos'] = $registros;
                $data ['grupo_info'] = $grupo_info=$this->registro_academico_model->get_info_grupo($grupo);

            ////////////////////////////////// Configuración de decimales ////////////////////////////////////////
            $decimales = json_decode($this->gsatelite->get_parametro("RA_DECIMALES"),true);
            $data['cant_decimales'] = (isset($decimales['decimales'])>0)?$decimales['decimales']:2; // Cantidad de decimales a mostrar en las notas.
            $data['min_aproxima'] = (isset($decimales['min_aproxima'])>0)?$decimales['min_aproxima']:0; // Cantidad mínima para aproximar promedios.
            $data['max_aproxima'] = (isset($decimales['max_aproxima'])>0)?$decimales['max_aproxima']:0; // Cantidad máxima para aproximar promedios.

            
            $rows=$this->load->view('reporte/header', array('titulo' => "Notas por nivel"), true);
            $data['table_header'] = $rows;
            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']     = $rows;
            $data['filename']         = $filename;

            
            //$this->pdf->reportePDF('registro_academico/consultas/reporte_notas_modulos.php', $data,null, 'L');
            $this->pdf->reportePDF('registro_academico/consultas/reporte_notas_nivel.php', $data,null, 'L');
    }




public function mostrar_alumnos($value='')
{
    if (!$this->tank_auth->is_logged_in()) {
        redirect('/auth/login/');
    } else {
        $area= $_POST['idP'];
        $alumnos_extraidos = $this->personal_model->obtener_alumnos($area);

        if (!empty($alumnos_extraidos)) {
            $cadena="<option value=''></option>";
            foreach ($alumnos_extraidos as $key => $value) {
                    $cadena.="<option value='".$value['alm_id']."'>".$value['alm_nombre'].' '.$value['alm_apellido']."</option>";
            }
            echo json_encode(array('alumjson' => $cadena));
        } else {
            echo json_encode(array('alumjson' => "<option>No existen alumnos para esta área</option>" ));
        }
    }
}

  function pensum_modulo()
        {
           if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                $data["areas_academicas"] = $this->gsatelite->get_tabla('ard_area_academica');
                $data["titulo_personal"] ="Reporte de pensum por nivel ";

                $this->_cargarvista($data);
            }
        }

  /**
   * @author Christian Menendez
   * @return 
   */

    public function consultar_pensum_modulo()
    {           
            $area = $this->input->post('area');
            $where = array('ard_id'=>$area);
            $grupos=$this->registro_academico_model->obtener_pensum_nivel($where);
           
            $cadena="";
            if (!empty($grupos)) {
               foreach ($grupos as $key => $grp) {
                $cadena.="<td>".$grp['Area']."</td>";
                $cadena.="<td>".$grp['Modulo']."</td>";
                $cadena.="<td>".$grp['UV']."</td>";
                if (!empty($grp['nombre'])) {
                $cadena.="<td>".$grp['nombre']."</td>";
                }else{
                     $cadena.="<td>No tiene prerrequisito</td>";
                }
                
                $cadena.="</tr>";   
            }
            $cadena.='</table>';
            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
            $data['table_header']     = $rows;
            $data['table_tbody']      = $cadena;
            $data['filename']         = $filename;
            }else {
                $cadena.="<thead><tr>";
                $cadena.="<td colspan='5'>No se encontraron resultados</td>";
                $cadena.="</tr></thead>";
            }
            // if($tipo==1){
            //     $this->load->view('inventario/reportes/reporte_furgon.php', $data);
            // }
            // else if($tipo==2){
               //  $this->pdf->reportePDF('inventario/reportes/reporte_existencia_pdf.php', $data);
                 //}
                // $this->load->view('registro_academico/consultas/consultar_notas_modulos');
           // print_r($this->db->last_query());
           // print_r($this->db->last_query());
            $contenido=$cadena;
            $data['contenido']=$contenido;            
            $html = $this->load->view('registro_academico/consultas/consulta_pen_modulo', $data, true);
            echo json_encode($html);
           

           
    }   

    public function reporte_pensum_nivel($id)
    {
            $id_mod = $this->input->post('modulo');
            $area = $this->input->post('area');
            $where = array('ard_id'=>$area, 'modl.mod_id'=>$id_mod);
            $datos_pesum_nivel=$this->registro_academico_model->obtener_pensum_nivel($where);

            $cadena="";

            //$rows="REPORTES DE NOTAS POR ALUMNO";

                $rows=$this->load->view('reporte/header', array('titulo' => "Pensum por Nivel"), true);
                $cadena='<meta http-equiv="content-type" content="text/html; charset=utf-8"><table class="tabla" style="border:1px solid black;">';
                $cadena.='<tr style="background-color: #C0C0C0;">';
                $cadena.='<th style="text-align:center; font-weight:bold; width:40%; border: 1px solid black; width: 30%;">&Aacute;rea</th>';
                $cadena.='<th style="text-align:center; font-weight:bold; width:25%; border: 1px solid black; width: 30%;">Nivel</th>';
                $cadena.='<th style="text-align:center; font-weight:bold; width:5%; border: 1px solid black; width: 15%;">UV</th>';
                 $cadena.='<th style="text-align:center; font-weight:bold; width:30%; border: 1px solid black; width: 25%;">Prerrequisito</th>';
                $cadena.='</tr>';

            foreach ($datos_pesum_nivel as $key => $sld) {
                //$numero=explode(',', $sld['precios_costos']);
                //$dos="";
              

                 $cadena.='<tr ><td  style="text-align:center; width:40%; border: 1px solid black; width: 30%; ">'.$sld['Area'].'</td>';
                $cadena.='<td style="text-align:center; width:25%; border: 1px solid black; width: 30%; ">'.$sld['Modulo'].'</td>';
                $cadena.='<td style="text-align:center; width:5%; border: 1px solid black; width: 15%;">'.$sld['UV'].'</td>';
                if (!empty($grp['nombre'])) {
                    $cadena.='<td style="text-align:center; width:30%; border: 1px solid black; width: 25%; ">'.$sld['nombre'].'</td></tr>';
                }else{
                    $cadena.='<td style="text-align:center; width:30%; border: 1px solid black; width: 25%; ">NO tiene prerrequisito</td></tr>';
                }
               
                
            }

            $cadena.='</table>';

            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']     = $rows;
            $data['table_tbody']      = $cadena;
            $data['filename']         = $filename;

                if ($id == 1) {
                    $this->pdf->reportePDF('inventario/reportes/reporte_existencia_pdf.php', $data, null, 'L');
                }else{
                    $this->load->view('registro_academico/consultas/reporte_pensum_nivel_excel', $data);
                }      
    }
    //CALLBACKS

    function _fecha_inscripcion($value,$row){
        $date = new DateTime($value);

        return '<div>'.$date->format('d/m/Y').'</div>';
    }
    ///

    function reporte_grupo() {
        if (!$this->tank_auth->is_logged_in()){
                redirect('/auth/login/');
        } else{ 
            $fecha_ini  =   $this->input->post('fecha_ini');
            $fecha_fin  =   $this->input->post('fecha_fin');
            $programa   =   $this->input->post('programa');
            $alumno     =   $this->input->post('alumno');
            $where      =   null;

            if($fecha_ini != '' && $fecha_fin != '') {
                $fecha_ini=date('Y-m-d', strtotime($fecha_ini));
                $fecha_fin=date('Y-m-d', strtotime($fecha_fin));
            }

            //$sucursal_str = $this->get_sucursales();                          
            //$where['alm_id_suc in('.$sucursal_str.')'] = NULL;
            //$where['pyc_id_suc in('.$sucursal_str.')'] = NULL;
            //$where['gra_id_suc in('.$sucursal_str.')'] = NULL;
                              
            if($_POST) {                    
                if($alumno<=0){$alumno = null;}
                $this->db->group_by('alm_id', 'gra_id');
                $grupos =   $this->registro_academico_model->obtener_info_grupos($fecha_ini,$fecha_fin,$programa,$where,$alumno);
                $data['grupos'] = $grupos;  

                $html =   $this->load->view('registro_academico/consultas/consulta_alm_grupo', $data, true);
                echo json_encode($html);
                die();

            } else {
                $where = 'lxp_alumnoxpensum.lxp_condicion IN (1,2)';
            }
            $programa           = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}','', array('ard_estado'=>1), null, '', 'ard_id', true);
            $data['programa']   = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $programa);
            $data["titulo_personal"] = "Reporte de alumnos por área";

            $this->_cargarvista($data);
            }
    }

    public function imprimir_reporte_grupos_individual($gra_id, $alm_id, $tipo_reporte)
    {
         $grupos=$this->registro_academico_model->onbtener_info_grupo_individual($gra_id,$alm_id);
         $data['grupos'] = $grupos;  
        if ( $tipo_reporte == 1) {
            $data['grupo_alm'] = 1;
            $this->load->library('pdf');
            $html=$this->load->view('reporte/header', array('titulo' => "Alumnos"), true);
            $html.= $this->load->view('registro_academico/consultas/reporte_individual', $data, true);
            $this->pdf->makePDF($html, 'L');
        }
        if ( $tipo_reporte == 2) {
            $data['donde_imprimir'] = 2;
            $this->load->view('registro_academico/consultas/reporte_alm_grupo_excel', $data);
        }
            
    }

   public function reporte_pdf_grupos($id){

        $fecha_ini = $this->input->post('fecha_ini');
        $fecha_fin = $this->input->post('fecha_fin');
        $programa  = $this->input->post('programa');
        $alumno    = $this->input->post('alumno');

         if($fecha_ini != '' && $fecha_fin != ''){
            $fecha_ini = date('Y-m-d', strtotime($fecha_ini));
            $fecha_fin = date('Y-m-d', strtotime($fecha_fin));
        }

        $this->db->group_by('alm_id', 'gra_id');
        $where  = 'lxp_alumnoxpensum.lxp_condicion IN (1,2)';
        $grupos = $this->registro_academico_model->obtener_info_grupos($fecha_ini,$fecha_fin,$programa,$where,$alumno);

        $cadena = "";

        $rows    = $this->load->view('reporte/header', array('titulo' => "Alumnos por área"), true);
        $cadena  ='<meta http-equiv="content-type" content="text/html; charset=utf-8"><table class="tabla"  cellpadding="2">';
        $grupos_nivel  = (count($grupos)>0)? $grupos[0]['Nivel']:'';
        $grupos_modulo = (count($grupos)>0)? $grupos[0]['Modulo']:'';
        $cadena .= '<tr>
                    <th  style="text-align:center; width:25%;"><b>Área: </b></th>
                    <td  colspan="8" style="text-align:left; width:75%;"> '.$grupos_nivel.'</td></tr>';
        $cadena .= '<tr>
                    <td  style="text-align:center; width:100%;"></td></tr></table>';

        $cadena .= '<table class="tabla" border="1" cellpadding="2" style="border:1px solid black;"><tr>';
        $cadena .= '<th style="text-align:center; font-weight:bold; width:5%;">#</th>';
        $cadena .= '<th style="text-align:center; font-weight:bold; width:10%;">Fecha</th>';
        $cadena .= '<th style="text-align:center; font-weight:bold; width:10%;">Código</th>';
        $cadena .= '<th style="text-align:center; font-weight:bold; width:20%;">Alumno</th>';
        $cadena .= '<th style="text-align:center; font-weight:bold; width:15%;">Nivel</th>';
        $cadena .= '<th style="text-align:center; font-weight:bold; width:15%;">Grupo</th>';
        $cadena .= '<th style="text-align:center; font-weight:bold; width:15%;">Frecuencia</th>';
        $cadena .= '<th style="text-align:center; font-weight:bold; width:10%;">Estado</th>';
        $cadena  .= '</tr>';
        $alum_num=1;

        if (!empty($grupos)) {  
            foreach ($grupos as $key => $grp) {
                $becado = ($grp['alm_becado'] == 1) ? 'Becado':'No Becado'; 
                $cadena .= "<tr>";
                $cadena .= "<td>".$alum_num++."</td>";
                $cadena .= "<td>".date('d-m-Y', strtotime($grp['Fecha']))."</td>";
                $cadena .= "<td>".$grp['Codigo']."</td>";
                $cadena .= "<td>".$grp['Participante']."</td>";
                $cadena .= "<td>".$grp['Modulo']."</td>";
                $cadena .= "<td>".$grp['Grupo']."</td>";
                $cadena .= "<td>".$grp['frh_nombre']."</td>";
                $cadena .= "<td>".$becado."</td>";
                $cadena .= "</tr>";
            }
        }else{
            $cadena     .= "<tr style='text-align:center; font-weight:bold;'><td colspan='9'>No se encontraron registros</td></tr>";
        }

        $cadena.='</table>';

        $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

        $data['table_header']     = $rows;
        $data['table_tbody']      = $cadena;
        $data['filename']         = $filename;
        $data['grupos']           = $grupos;
        $data['grupo_nivel']      = $grupos_nivel;
        $data['grupo_modulo']     = $grupos_modulo;
        
        if ($id == 1) {

            $this->pdf->reportePDF('registro_academico/consultas/reporte_grupos_pdf', $data,NULL ,'L');

        }else{

            $data['donde_imprimir'] = 1;
            $this->load->view('registro_academico/consultas/reporte_alm_grupo_excel', $data);
        }
                          
    }
 

  function reporte_grupoxmodulo()
        {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                $data["areas_academicas"] = $this->gsatelite->get_tabla('ard_area_academica');
                $data["titulo_personal"] ="Reporte de grupos por nivel";

                $this->_cargarvista($data);
            }
        }

        public function consultar_grupos_modulo()
        {
            $id_mod = $this->input->post('modulo');
            $area = $this->input->post('area');

            $where = array('ard_id'=>$area, 'mod_id'=>$id_mod);
            

            //$sucursal_str = $this->get_sucursales();                          
            //$this->db->where('gra_id_suc in('.$sucursal_str.')',NULL);
            $grupos=$this->registro_academico_model->grupos_modulo($where);            

            $data['grupos'] = $grupos;
            $html=$this->load->view('registro_academico/consultas/consulta_rpt_grupo', $data, true);
            $regresar["html"] = $html;

            echo json_encode($regresar);
        }   
        public function reporte_grupos_modulo($id)
        {
            $id_mod = $this->input->post('modulo');
            $area = $this->input->post('area');
            $where = array('ard_id'=>$area, 'mod_id'=>$id_mod);
            $data['grupos'] = $grupos = $this->registro_academico_model->grupos_modulo($where);
          
            foreach ($grupos as $key => $modulo) {
                $modulo=$modulo['Modulo'];
            }
                $data['grupo_nivel'] = (count($grupos)>0)? $grupos[0]['Nivel'] : "";
                $data['grupo_modulo'] = (count($grupos)>0)? $grupos[0]['Modulo'] : "";
                $rows=$this->load->view('reporte/header', array('titulo' => "Grupos por nivel"), true);

            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            if ($id == 1) {
                $data['table_header']     = $rows;
                $data['filename']         = $filename;
                $this->pdf->reportePDF('inventario/reportes/reporte_existencia_pdf.php', $data, NULL, 'L');
            }else{
                 $data['table_header']     = $rows;
                $data['filename']         = $filename;
                $this->load->view('registro_academico/consultas/reporte_grupos_nivel_excel', $data);
            }
        }   

    function reporte_listado_alumnos(){
        if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
        } else {
            $data['alumnos']=$this->registro_academico_model->reporte_listado_alumno();   
            $data["titulo_personal"] ="Listado de Alumnos";

            $this->_cargarvista($data);
        }
    }

     function reporte_becados(){
        if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
        } else {
            $data['financiamiento'] = $this->gsatelite->get_tabla('fin_financiamiento');  
            $data["titulo_personal"] ="Alumnos con Financiamiento";

            $this->_cargarvista($data);
        }
    }

    /** 
     * Modified by Edith Herrera
     * Date  12-01-2018
     * @return Cosulta de alumnos.
    **/
    public function consultar_alumnos_beca()
    {
        satelite_validar(true);
            $beca= $this->input->post('beca');
            $fina= $this->input->post('finan');
            
            $where = array();
            if($fina>0){
                $where['alm_id_fin']=$fina;
            }

            if($beca>=0 && $beca<2){
                $where['alm_becado']=$beca;
            }
            $sucursal_str = $this->get_sucursales();                          
            $where['alm_id_suc in('.$sucursal_str.')'] = NULL;
            $data['alumnos'] = $this->registro_academico_model->reporte_listado_alumno($where);
            
        $html=$this->load->view('registro_academico/consultas/consulta_alm_becado', $data, true);
        echo json_encode($html);
    }

    public function imprimir_reporte_becados_individual($alm_id_fin, $alm_id, $tipo_reporte)
    {
         $alumnos=$this->registro_academico_model->reporte_listado_alumno_individual($alm_id_fin, $alm_id);
         $data['alumnos'] = $alumnos;  

        if ( $tipo_reporte == 1) {
            $data['becado'] = 1;
            $this->load->library('pdf');
            $html=$this->load->view('reporte/header', array('titulo' => "Listado de Alumnos"), true);
            $html.= $this->load->view('registro_academico/consultas/reporte_individual', $data, true);
            $this->pdf->makePDF($html, 'L');
        }
        if ($tipo_reporte == 2) {
            $data['donde_imprimir'] = 2;
            $data['titulo'] = "Listado de alumnos";
            $this->load->view('registro_academico/consultas/reporte_listado_alumnos_excel', $data);
        }
            
    }

    public function reporte_pdf_listado_alumnos($id, $beca=null)
        {
            $beca       = $this->input->post('beca');
            $fina       = $this->input->post('finan');
          
            $where      = array();
            if($fina>0){
                $where['alm_id_fin'] = $fina;
            }

            if($beca >= 0 && $beca <2 ){
                $where['alm_becado'] = $beca;
            }
            $this->db->group_by('alm_id');
            $alumnos    = $this->registro_academico_model->reporte_listado_alumno($where);
           
            $cadena     = "";
            
               $rows    = $this->load->view('reporte/header', array('titulo' => "Listado de Alumnos"), true);
               $cadena  = '<meta http-equiv="content-type" content="text/html; charset=utf-8"><table class="tabla" border="1" cellpadding="2" style="border:1px solid black;">';
               $cadena  .= '<tr>';
               $cadena  .= '<th style="text-align:center; font-weight:bold; width:3%;">#</th>';
               $cadena  .= '<th style="text-align:center; font-weight:bold; width:8%;">Código</th>';
               $cadena  .= '<th style="text-align:center; font-weight:bold; width:22%;">Alumno</th>';
               $cadena  .= '<th style="text-align:center; font-weight:bold; width:11%;">Departamento</th>';
               $cadena  .= '<th style="text-align:center; font-weight:bold; width:13%;">Municipio</th>';
               $cadena  .= '<th style="text-align:center; font-weight:bold; width:8%;">Estado Civil</th>';
               $cadena  .= '<th style="text-align:center; font-weight:bold; width:16%;">Profesión</th>';
               $cadena  .= '<th style="text-align:center; font-weight:bold; width:7%;">Becado</th>';
               $cadena  .= '<th style="text-align:center; font-weight:bold; width:12%;">Financiamiento</th>';
               $cadena  .= '</tr>';
            if (!empty($alumnos)) {
               $num_alum=1;
                foreach ($alumnos as $alm) {
                    $becado     = ($alm['alm_becado']==1)?'Si':'No';
                    
                    $cadena .= '<tr>';
                    $cadena .= "<td>".$num_alum++."</td>";
                    $cadena .= "<td>".$alm['alm_codigo']."</td>";
                    $cadena .= "<td>".$alm['alm_nombre'].' '.$alm['alm_apellido']."</td>";
                    $cadena .= "<td>".$alm['dep_nombre']."</td>";
                    $cadena .= "<td>".$alm['mun_nombre']."</td>";
                    $cadena .= "<td>".$alm['esc_nombre']."</td>";
                    $cadena .= "<td>".$alm['pro_nombre']."</td>";
                    $cadena .= "<td>".$becado."</td>";
                    $cadena .= "<td>".$alm['fin_nombre']."</td>";
                    $cadena .= "</tr>";
                }
            }else{
                $cadena .='<tr>';
                $cadena .='<td colspan="9">No se encontraron resultados</td>';
                $cadena .="</tr>";
            }
            $cadena     .='</table>';

            $filename   = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']     = $rows;
            $data['table_tbody']      = $cadena;
            $data['filename']         = $filename;
            $data['alumnos']          = $alumnos;

            if ($id == 1) {
                
                $data['becado'] = 1;
                $html=$this->load->view('reporte/header', array('titulo' => "Listado de Alumnos"), true);
                $html.= $this->load->view('registro_academico/consultas/reporte_listado_alumnos_pdf', $data, true);
                $this->pdf->makePDF($html, 'L');
                
            }else{
                $data['donde_imprimir'] = 1;
                $this->load->view('registro_academico/consultas/reporte_listado_alumnos_excel', $data);
            }            
    }


    function reporte_causas(){
        if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
        } else {
            $inicio=$this->input->post('fecha_ini');
            $fin=$this->input->post('fecha_fin');
            $alumno=$this->input->post('alumno');
            $sucursal_str = $this->get_sucursales();         

            if($inicio!='' && $fin!=''){
                $inicio = date('Y-m-d',strtotime($inicio));
                $fin = date('Y-m-d',strtotime($fin));

                $where = array('DATE(lxp_fecha_retiro) >= '=>$inicio,'DATE(lxp_fecha_retiro) <= '=>$fin);
                $order_by = 'gra_grupo_academico.gra_nombre ASC';
                if($alumno>0){
                    $where['alm_id'] = $alumno;
                }
                $where['alm_id_suc in('.$sucursal_str.')'] = NULL;
                $where['gra_id_suc in('.$sucursal_str.')'] = NULL;    
                $data['causas'] = $this->registro_academico_model->reporte_causas($where, null); 

                $html=$this->load->view('registro_academico/consultas/consulta_alm_causas', $data, true);
                echo json_encode($html);
                die();
            }else{ 
                $order_by = 'gra_grupo_academico.gra_nombre ASC';
                $data['causas']=$this->registro_academico_model->reporte_causas(null, $order_by); 
            }
                             
            //$where['alm_id_suc in('.$sucursal_str.')'] = NULL;
            //$where['gra_id_suc in('.$sucursal_str.')'] = NULL;            
            $data['almunos'] = $this->registro_academico_model->reporte_causas_alumnos($where);

            $data["titulo_personal"] ="Listado de Causas";

            $this->_cargarvista($data);
        }
    }

    public function imprimir_reporte_causas_individual($gra_id, $alm_id, $tipo_reporte)
    {
         $causas=$this->registro_academico_model->reporte_causas_individual($gra_id, $alm_id);

         $data['causas'] = $causas;  
        if ( $tipo_reporte == 1) {
            $data['causa'] = 1;
            $this->load->library('pdf');
            $html=$this->load->view('reporte/header', array('titulo' => "Causas de retiro"), true);
            $html.= $this->load->view('registro_academico/consultas/reporte_individual', $data, true);
            $this->pdf->makePDF($html, 'L');
        }
        if ( $tipo_reporte == 2) {
            $data['donde_imprimir'] = 2;
            $data['titulo'] = 'Causas de retiro';
            $this->load->view('registro_academico/consultas/reporte_causas_retiro_excel', $data);
        }
            
    }

    public function reporte_pdf_causas($id)
        {
            satelite_validar();
            $where = null;
            $inicio=$this->input->post('fecha_ini');
            $fin=$this->input->post('fecha_fin');
            $alumno=$this->input->post('alumno');

            if($inicio!='' && $fin!=''){
                $inicio = date('Y-m-d',strtotime($inicio));
                $fin = date('Y-m-d',strtotime($fin));
                $where = array('DATE(lxp_fecha_retiro) >= '=>$inicio,'DATE(lxp_fecha_retiro) <= '=>$fin);
            }
            
            if($alumno>0){
                $where['alm_id'] = $alumno;
            }

            $order_by = 'gra_nombre ASC';
            $data['causas']=$this->registro_academico_model->reporte_causas($where, $order_by,$alumno); 
            
            $rows=$this->load->view('reporte/header', array('titulo' => "Causas de retiro"), true);
            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']     = $rows;
            $data['filename']         = $filename;

            if ($id == 1) {
                $this->pdf->reportePDF('registro_academico/consultas/causas_retiro_pdf.php', $data, NULL, 'L');
            }else{
                $data['titulo'] = "Causas de retiro";
                $this->load->view('registro_academico/consultas/reporte_causas_retiro_excel', $data);
            } 
    }


    function reporte_notas_grupo(){
        if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
        } else {
            $where = 'lxp_condicion IN (1,2)';
            $data['grupos']=$this->registro_academico_model->obtener_info_grupos($where);

            
            $sucursal_str = $this->get_sucursales();                          
            $this->db->where('pyc_id_suc in('.$sucursal_str.')',NULL);
            $this->db->join('ard_area_academica', 'pyc_id_ard=ard_id','left');
            $proyeccion = $this->gsatelite->get_tabla('pyc_proyeccion');

            $pyc_drop = '<option value=""></option>';
            foreach ($proyeccion as $key ) {
                $pyc_drop .= '<option value="'.$key['pyc_id'].'" data-ard_id="'.$key['pyc_id_ard'].'" data-area="'.$key['ard_nombre'].'">'.$key['pyc_nombre'].'</option>';
            }
                
            $data["proyeccion"] = $pyc_drop;

            $data["areas_academicas"] = $areasAcademicas;    
            $data["titulo_personal"] ="Reporte de notas por grupo";

            $this->_cargarvista($data);
        }
    }

    public function mostrar_grupos_area($value='')
    {
        if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
        } else {
            $area = $_POST['idP'];
            $proyeccion = $_POST['proyeccion'];

            $pensums = $this->gsatelite->get_tabla('pen_pensum', array('pen_id_ard'=>$area));

            $arr_asoc = array();
            if(count($pensums)>0){
                foreach ($pensums as $pen) {
                    if($pen['pen_id_asociado']!=''){
                        $arr_asoc[]=$pen['pen_id_asociado'];
                    }
                }
            }

            $where = array();

            if($area>0){
                $where['ard_id'] = $area;
            }
            if($proyeccion>0){
                $where['gra_id_pyc'] = $proyeccion;
            }
            if(count($arr_asoc)>0){
                $this->db->where_not_in('pen_id', $arr_asoc);
            }
            $sucursal_str = $this->get_sucursales();                          
            //$where['gra_id_suc in('.$sucursal_str.')'] = NULL;

            $grupos_extraidos = $this->registro_academico_model->get_GruposAcademicosxArea($where,1);
            echo $grupos_extraidos;
        }
    }

    /** 
     * @author Edith Herrera
     * @since  10-01-2018 (modificado)
     * @return Grid del reporte de notas por grupo.
    **/
    public function consultar_notas_grupos_area()
    {   
        satelite_validar(true);
        $grupo= $this->input->post('grupo');
        $alumno= $this->input->post('alumno');

        $frh = $this->gsatelite->get_campo('gra_grupo_academico', 'gra_id_frh', array('gra_id'=>$grupo));
        $data['registro'] = $frecuencia =  $this->registro_academico_model->get_frecuencias(array('dfr_id_frh'=>$frh));

        //////////////////////////// Info grupos ////////////////////////////////////////////////////////
        $grd = $this->gsatelite->get_registro('gra_grupo_academico', array('gra_id'=>$grupo));
        
        //////////////////////// SI EL GRUPO ES DE BACHILLERATO ///////////////////////////////////////////
        if(count($grd)>0 && $grd->gra_id_grd>0){
            $where['pen_id'] = $grd->gra_id_pen;
            $where['lxp_condicion !='] = (4);
            $registros = $this->registro_academico_model->get_materias_grado($where, 'alm_id');

            $array_alm = array();
            $cant_notas = 0;
            if(count($registros)>0){
                foreach ($registros as $key) {
                $array = array();
                $notas_alm = array();
                $promedio = array();
                    $pensum = $key['pen_id'];
                    $lxp = $key['lxp_id'];

                    array_push($array, $key['alm_codigo']);
                    array_push($array, $key['alumno']);
                    array_push($array, $key['ard_nota_minima']);

                    $notas = $this->registro_academico_model->get_promedio_periodo(array('pen_id'=>$pensum, 'noa_id_lxp'=>$lxp));

                    ///////////// Se forma arreglo de notas por alumno y materia recorrida////////////////
                    if(count($notas)>0){
                        $notas_alm = array_column($notas, 'nota');
                        $promedio = array_column($notas, 'promedio');
                    }
                    //die(print_r($notas_alm));
                    
                    /////// Se rellenan los espacios para completar las 4 notas (promedio por periodo) /////
                    if(count($notas)<4){
                        $cant = 4- count($notas);
                        for ($i=1; $i <= $cant ; $i++) { 
                            $notas_alm[] = "";
                        }
                    }

                    $total_prom = array_sum($promedio);
                    array_push($array, $total_prom);
                    $notas_imp = implode(',', $notas_alm); 
                    array_push($array, $notas_imp);

                    $cant_notas = count($notas_alm);
                    $array_alm[] = $array;
                }
            }
            $data['cant_notas'] = $cant_notas;
            $data['registros'] = $array_alm;

        }else{  //////////////////////// SI EL GRUPO ES DE CURSO LIBRE ////////////////////////////////////////
            
            $where = array('lxp_condicion !='=>(4),'gra_id'=>$grupo);
            if($alumno>0){
                $where['lxa_id_alm']=$alumno;
            }

            $registros = $this->registro_academico_model->obtener_info_grupos(null,null,null,$where, null, 'alm_id, gra_id');
            //die(print_r($registros));

            $array_alm = array();
            $cant_notas = 0;
            $where= array();
            if(count($registros)>0){ 
                foreach ($registros as $key) {
                    $array = array(); // Array por alumno
                    $notas_alm = array(); // Array de notas por alumno
                    $promedio = 0; // Promedio por alumno

                    array_push($array, $key['Codigo']);
                    array_push($array, $key['Participante']);
                    array_push($array, $key['minima']);

                    $where['lxp_estado']=1;
                    $where['gra_id']=$key['gra_id'];
                    $where['pen_id_ard']=$key['ard_id'];
                    $where['lxp_condicion !=']=(4);
                    $where['alm_id']=$key['alm_id'];
                          
                    $notas = $this->registro_academico_model->get_AlumnosxGruposAcademicos($where, null, null, 'evm_orden');


                    ///////////// Se forma arreglo de notas por alumno y materia recorrida////////////////
                    if(count($notas)>0){

                        $notas_alm = array_column($notas, 'noa_nota');
                        $promedio = $notas[0]['promedio'];
                    }
                    
                    /////// Se rellenan los espacios para completar las 4 notas (promedio por periodo) /////
                    if(count($notas)<4){
                        $cant = 4- count($notas);
                        for ($i=1; $i <= $cant ; $i++) { 
                            $notas_alm[] = "";
                        }
                    }
                    
                   
                    array_push($array, $promedio);
                    $notas_imp = implode(',', $notas_alm); 
                    array_push($array, $notas_imp);

                    $cant_notas = count($notas_alm);
                    $cant_notas = count($notas_alm);

                    $array_alm[] = $array;
                }
            }
                
            $data['cant_notas'] = $cant_notas;
            $data['registros'] = $array_alm;
        }
        ////////////////////////////////////////////////////////////////////////////////////////////////
       
        $data['datos_grupos'] = $registros;
        $data ['grupo_info'] = $grupo_info=$this->registro_academico_model->get_info_grupo($grupo);

        ////////////////////////////////// Configuración de decimales ////////////////////////////////////////
        $decimales = json_decode($this->gsatelite->get_parametro("RA_DECIMALES"),true);
        $data['cant_decimales'] = (isset($decimales['decimales'])>0)?$decimales['decimales']:2; // Cantidad de decimales a mostrar en las notas.
        $data['min_aproxima'] = (isset($decimales['min_aproxima'])>0)?$decimales['min_aproxima']:0; // Cantidad mínima para aproximar promedios.
        $data['max_aproxima'] = (isset($decimales['max_aproxima'])>0)?$decimales['max_aproxima']:0; // Cantidad máxima para aproximar promedios.

        $html = $this->load->view('registro_academico/consultas/consulta_nts_grupo_area', $data, true);
        echo json_encode($html);
}

    /** 
     * @author Edith Herrera
     * @since  11-01-2018 (modificado)
     * @return Exportar reporte de notas por grupo.
    **/
    public function reporte_pdf_notas_grupos($id, $grupo=null, $alumno=null)
    {
        satelite_validar();
            $frh = $this->gsatelite->get_campo('gra_grupo_academico', 'gra_id_frh', array('gra_id'=>$grupo));
            $data['registro'] = $frecuencia =  $this->registro_academico_model->get_frecuencias(array('dfr_id_frh'=>$frh));

        //////////////////////////// Info grupos ////////////////////////////////////////////////////////
        $grd = $this->gsatelite->get_registro('gra_grupo_academico', array('gra_id'=>$grupo));
        
        //////////////////////// SI EL GRUPO ES DE BACHILLERATO ///////////////////////////////////////////
        if(count($grd)>0 && $grd->gra_id_grd>0){
            $where['pen_id'] = $grd->gra_id_pen;
            $where['lxp_condicion !='] = (4);
            $registros = $this->registro_academico_model->get_materias_grado($where, 'alm_id');

            $array_alm = array();
            $cant_notas = 0;
            if(count($registros)>0){
                foreach ($registros as $key) {
                $array = array();
                $notas_alm = array();
                $promedio = array();
                    $pensum = $key['pen_id'];
                    $lxp = $key['lxp_id'];

                    array_push($array, $key['alm_codigo']);
                    array_push($array, $key['alumno']);
                    array_push($array, $key['ard_nota_minima']);

                    $notas = $this->registro_academico_model->get_promedio_periodo(array('pen_id'=>$pensum, 'noa_id_lxp'=>$lxp));

                    ///////////// Se forma arreglo de notas por alumno y materia recorrida////////////////
                    if(count($notas)>0){
                        $notas_alm = array_column($notas, 'nota');
                        $promedio = array_column($notas, 'promedio');
                    }
                    
                    /////// Se rellenan los espacios para completar las 4 notas (promedio por periodo) /////
                    if(count($notas)<4){
                        $cant = 4- count($notas);
                        for ($i=1; $i <= $cant ; $i++) { 
                            $notas_alm[] = "";
                        }
                    }

                    $total_prom = array_sum($promedio);
                    array_push($array, $total_prom);
                    $notas_imp = implode(',', $notas_alm); 
                    array_push($array, $notas_imp);

                    $cant_notas = count($notas_alm);
                    $array_alm[] = $array;
                }
            }
            $data['cant_notas'] = $cant_notas;
            $data['registros'] = $array_alm;

        }else{  //////////////////////// SI EL GRUPO ES DE CURSO LIBRE ////////////////////////////////////////
            
            $where = array('lxp_condicion !='=>(4),'gra_id'=>$grupo);
            if($alumno>0){
                $where['lxa_id_alm']=$alumno;
            }

            $registros = $this->registro_academico_model->obtener_info_grupos(null,null,null,$where, null, 'alm_id, gra_id');

            $array_alm = array();
            $cant_notas = 0;
            $where= array();
            if(count($registros)>0){ 
                foreach ($registros as $key) {
                    $array = array(); // Array por alumno
                    $notas_alm = array(); // Array de notas por alumno
                    $promedio = 0; // Promedio por alumno

                    array_push($array, $key['Codigo']);
                    array_push($array, $key['Participante']);
                    array_push($array, $key['minima']);

                    $where['lxp_estado']=1;
                    $where['gra_id']=$key['gra_id'];
                    $where['pen_id_ard']=$key['ard_id'];
                    $where['lxp_condicion !=']=(4);  
                    $where['alm_id']=$key['alm_id'];    
                    $notas = $this->registro_academico_model->get_AlumnosxGruposAcademicos($where, null, null, 'evm_orden');


                    ///////////// Se forma arreglo de notas por alumno y materia recorrida////////////////
                    if(count($notas)>0){

                        $notas_alm = array_column($notas, 'noa_nota');
                        $promedio = $notas[0]['promedio'];
                    }
                    
                    /////// Se rellenan los espacios para completar las 4 notas (promedio por periodo) /////
                    if(count($notas)<4){
                        $cant = 4- count($notas);
                        for ($i=1; $i <= $cant ; $i++) { 
                            $notas_alm[] = "";
                        }
                    }

                    array_push($array, $promedio);
                    $notas_imp = implode(',', $notas_alm); 
                    array_push($array, $notas_imp);

                    $cant_notas = count($notas_alm);
                    $cant_notas = count($notas_alm);

                    $array_alm[] = $array;
                }
            }
                
            $data['cant_notas'] = $cant_notas;
            $data['registros'] = $array_alm;
        }       
        $data['datos_grupos'] = $registros;
        $data ['grupo_info'] = $grupo_info=$this->registro_academico_model->get_info_grupo($grupo);

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        ////////////////////////////////// Configuración de decimales ////////////////////////////////////////
        $decimales = json_decode($this->gsatelite->get_parametro("RA_DECIMALES"),true);
        $data['cant_decimales'] = $decimales['decimales']; // Cantidad de decimales a mostrar en las notas.
        $data['min_aproxima'] = (isset($decimales['min_aproxima'])>0)?$decimales['min_aproxima']:0; // Cantidad mínima para aproximar promedios.
        $data['max_aproxima'] = (isset($decimales['max_aproxima'])>0)?$decimales['max_aproxima']:0; // Cantidad máxima para aproximar promedios.

            $cadena="";
            $rows=$this->load->view('reporte/header', array('titulo' => "Notas por Grupo"), true);
            $grupo_info=$this->registro_academico_model->get_info_grupo($grupo);

            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header'] = $rows;
            $data['table_tbody']  = $cadena;
            $data['grupo_info']   = $grupo_info;
            $data['filename']     = $filename;

            if ($id == 1) {
                $html.= $this->load->view('registro_academico/consultas/reporte_notas_modulos', $data, true);
                $this->pdf->makePDF($html, 'L');
                //$this->pdf->makePDF('registro_academico/consultas/reporte_notas_modulos', $data, NULL, 'L');
            }else{
                $this->load->view('registro_academico/consultas/reporte_notas_modulos_excel', $data);
            } 
    }

    /*
     * Modificado: 18/09/2017
     */ 
    function imprimir_diploma($lxp=null){
            
        satelite_validar();
        $rows = $this->load->view('reporte/header', array('titulo' => "Diploma"), true);
        $data['table_header']  = $rows;

        $this->load->library('EnLetras');
        $this->load->library('EnLetras_en');
          
            $where = array('lxp_alumnoxpensum.lxp_id '=>$lxp);
            $datos_grupo=$this->registro_academico_model->obtener_info_grupos(null,null,null,$where);
           
            $condicion=$datos_grupo[0]['condicion'];
            if($condicion==2){
                $pre=$datos_grupo[0]['pre_id'];
                if($pre!=''){
                             $where=array('pre_id'=>$pre);
                    $mat=$this->registro_academico_model->get_modulo_siguiente($where);
                    $materia=$mat->materia;
                }
            }else{
                $materia=$datos_grupo[0]['Modulo'];
            }


                         $where = array('noa_id_lxp'=>$lxp);
                $notas = $this->registro_academico_model->get_NotasxAlumno($where);
             
                $promedio = 0;
                $cant=0;
                $calif='';
                foreach($notas as $nota){
                    //$promedio += ($nota['noa_nota']*$nota['pod_ponderacion']);
                    $calif .= "<td>".$nota['noa_nota']."</td>";
                $cant++;
                }

                $minimo = $this->gsatelite->get_parametro('SYS_NOTA_MINIMA');

                $rep='';
                $apr='';

                if (round($promedio,1) >= 6.5 && round($promedio,1) <7 ) {
                    $promedio=7;
                }

                if($promedio<$minimo){
                    $rep = 'X';
                }
                else{
                    $apr = 'X';
                }

                $genero_ini = strtolower(substr($datos_grupo[0]['gen_nombre'], 0, 1));
                $pre = "pro_prefijo_".$genero_ini;
                $prefijo = $datos_grupo[0][$pre];
                             $this->db->join('ctc_categoria_contenido', 'ctd_id_ctc= ctc_id');
                $contenido = $this->gsatelite->get_tabla('ctd_contenido_modulo', array('ctd_id_mod'=>$datos_grupo[0]['mod_id'], 'ctd_estado'=>1));

                $diploma_reg = $this->gsatelite->get_parametro('SYS_ID_DIPLOMA_NIVEL');
                $diploma = $this->gsatelite->get_campo('frd_formato_diploma', 'frd_configuraciones_formato', array('frd_id'=>$diploma_reg));
              
        $data['info']     = $datos_grupo[0];
        $data['contenido']= $contenido;
        $data['promedio'] = $promedio;
        $data['reprobado']= $rep;
        $data['aprobado'] = $apr;
        $data['materia']  = $materia;
        $data['docente']  = $prefijo.' '.$datos_grupo[0]['emp_nombre'].' '.$datos_grupo[0]['emp_apellido'];
        $data['diploma']  = $diploma;
 
        $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
        $this->pdf->setPrintFooter(false);
        $this->pdf->reportePDF('registro_academico/consultas/diploma_modulo.php', $data,null,'L');
    }

    function reporte_documentos($emp_id)
    {
         satelite_validar();
        $this->load->library('../controllers/expediente_personal/reportes');
        $info=$this->reportes->reporte_documentos($emp_id,null,true);
        $data['html']=$this->load->view('expediente_personal/reportes/reporte_documentos',$info, true);
        //$this->load->view('registro_academico/procesos/gestion_seguro',$data, true);
    }

    function generar_contrato_empleado($emp_id)
    {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/reportes');
        $info=$this->reportes->generar_contrato_empleado($emp_id,null,true);
        $data['html']=$this->load->view('expediente_personal/reportes/generar_contrato_empleado',$info, true);
    }

    public function programacion_mensual()
    {
        if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                $data["area"] = $this->gsatelite->get_tabla('ard_area_academica');
                $data["titulo_personal"] ="Reporte programaci&oacute;n mensual";
                $this->_cargarvista($data);
            }
    }

    function consultar_programacion_mensual(){
        $area=$this->input->post('area');
        if (is_array($area) && (count($area) > 0)) {
            $areas_id  = implode(',', $area);
            $where['ard_id in ('.$areas_id.')'] = null;
            $where_grupo['ard_id in ('.$areas_id.')'] = null;
        }

        //$sucursal_str = $this->get_sucursales();                          
        //$where['gra_id_suc in('.$sucursal_str.')'] = NULL;
        $data['horarios'] = $this->registro_academico_model->get_horarios_x_area($where);
        
        //$where_grupo['dct_id_suc in('.$sucursal_str.')'] = NULL;
        //$where_grupo['gra_id_suc in('.$sucursal_str.')'] = NULL;
        $data['grupos'] = $this->registro_academico_model->get_gruposacademicos_area($where_grupo);

        $respuesta=array(
            'html'=>$this->load->view('registro_academico/consultas/consulta_gra_academico', $data, true));
        echo json_encode($respuesta);
    }


    function imprimir_programacion_mensual($id){
        $area=$this->input->post('area');
        $data['tipo_fuente'] = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");

        $where['ard_id'] = $area;
        $area_data = $this->gsatelite->get_tabla("ard_area_academica",array('ard_id'=>$area));

        $nombre_area = $area_data[0]['ard_nombre'];
        $titulo_reporte = "<tr><td colspan='5'><center><h3>True Professionals in the teaching of English</h3></center></td></tr><tr><td colspan='5'><center><h3>ROOM AND TEACHER ALLOCATION FOR THE " . $nombre_area."</h3></td></center></tr><tr><td></td></tr>";

        $data['horarios'] = $this->registro_academico_model->get_horarios_x_area($where);

        $where_grupo['ard_id'] = $area;
        $data['grupos'] = $this->registro_academico_model->get_gruposacademicos_area($where_grupo);

        if ($id == 1) {
            $this->load->library('pdf');
            $html=$this->load->view('reporte/header', array('titulo' => $titulo_reporte, 'solotitulo' => true), true);
            $html.=$this->load->view('registro_academico/consultas/consulta_gra_academico_pdf', $data, true);
            $this->pdf->makePDF($html, 'L');
        }else{
            $data['titulo']= "Programación mensual";
            $data['titulo2']=$titulo_reporte;
            $this->load->view('registro_academico/consultas/reporte_gra_academico_excel', $data);
        }
    }

    public function certificado_notas()
    {
        if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
        } else {
            $data["area"] = $this->gsatelite->get_tabla('ard_area_academica');
            
            //$sucursal_str = $this->get_sucursales();                          
            //$this->db->where('pyc_id_suc in('.$sucursal_str.')',NULL);
            $this->db->join('ard_area_academica', 'pyc_id_ard=ard_id','left');
            $proyeccion = $this->gsatelite->get_tabla('pyc_proyeccion');

            $pyc_drop = '<option value=""></option>';
            foreach ($proyeccion as $key ) {
                $pyc_drop .= '<option value="'.$key['pyc_id'].'" data-ard_id="'.$key['pyc_id_ard'].'" data-area="'.$key['ard_nombre'].'">'.$key['pyc_nombre'].'</option>';
            }
                
            $data["proyeccion"] = $pyc_drop;
            $data["titulo_personal"] ="Reporte certificado de notas";

            $this->_cargarvista($data);
        }
    }

    function consultar_notas_para_certificados(){
        $area           = $this->input->post('area');
        $grupo          = $this->input->post('grupo');
        $modulo         = $this->input->post('modulo');
        $alumno         = $this->input->post('alumno');
        $sucursal_str   = $this->get_sucursales();            

        if($modulo>0 && $grupo>0 ){
            $where = array('lxp_alumnoxpensum.lxp_condicion !='=>(4),'ard_id'=>$area, 'mod_id'=>$modulo, 'gra_id'=> $grupo);
        }elseif($modulo>0){
            $where = array('lxp_alumnoxpensum.lxp_condicion !='=>(4),'ard_id'=>$area, 'mod_id'=>$modulo);
        }elseif ($grupo>0) {
            $where = array('lxp_alumnoxpensum.lxp_condicion !='=>(4),'ard_id'=>$area, 'gra_id'=> $grupo);
        }else{
            $where = array('lxp_alumnoxpensum.lxp_condicion !='=>(4),'ard_id'=>$area);
        }
        
        $frh = $this->gsatelite->get_campo('gra_grupo_academico', 'gra_id_frh', array('gra_id'=>$grupo));

        $data['registro'] = $this->registro_academico_model->get_frecuencias(array('dfr_id_frh'=>$frh));

        $where = array('lxp_alumnoxpensum.lxp_condicion !='=>(4),'gra_id'=>$grupo);
        $where['alm_id_suc in('.$sucursal_str.')'] = NULL;
       
        if(count($alumno)>0 && $alumno!='null'){
            $this->db->where_in('alm_id',$alumno);
        }
        $data['datos_grupos'] = $datos_grupos = $this->registro_academico_model->obtener_info_grupos(null,null,null,$where, null, 'alm_id');
            
        /******************** Notas según ponderación ****************************/
        $data['cant_notas'] = $cant_notas= $this->gsatelite->get_tabla('pod_ponderacion', array('pod_estado'=>1)); 
        /************************************************************************/

        //$this->db->where('gra_id_suc in('.$sucursal_str.')',NULL);
        $data ['grupo_info'] = $grupo_info=$this->registro_academico_model->get_info_grupo($grupo);

         ////////////////////////////////// Configuración de decimales ////////////////////////////////////////
        $decimales = json_decode($this->gsatelite->get_parametro("RA_DECIMALES"),true);
        $data['cant_decimales'] = $decimales['decimales']; // Cantidad de decimales a mostrar en las notas.
        $data['min_aproxima'] = (isset($decimales['min_aproxima'])>0)?$decimales['min_aproxima']:0; // Cantidad mínima para aproximar promedios.
        $data['max_aproxima'] = (isset($decimales['max_aproxima'])>0)?$decimales['max_aproxima']:0; // Cantidad máxima para aproximar promedios.


        $html = $this->load->view('registro_academico/consultas/consulta_certificados', $data, true);
        echo json_encode($html);
        
    }
    function imprimir_certificado($lxp=null){
        satelite_validar();
        $this->load->library('EnLetras');

        $area           = $this->input->post('hdnArea');
        $grupo          = $this->input->post('grupo');
        $modulo         = $this->input->post('modulo');
        $alumnos        = $this->input->post('slcAlumnos');
        $sucursal_str   = $this->get_sucursales();         

           // $where = 'lxp_alumnoxpensum.lxp_condicion NOT IN (4) AND gra_id = '.$grupo." ";
        if($modulo>0 && $grupo>0 ){
            $where = array('lxp_condicion !='=>(4),'ard_id'=>$area, 'mod_id'=>$modulo, 'gra_id'=> $grupo);
        }elseif($modulo>0){
            $where = array('lxp_condicion !='=>(4),'ard_id'=>$area, 'mod_id'=>$modulo);
        }elseif ($grupo>0) {
            $where = array('lxp_condicion !='=>(4),'ard_id'=>$area, 'gra_id'=> $grupo);
        }else{
            $where = array('lxp_condicion !='=>(4),'ard_id'=>$area);
        }

        //$where['alm_id_suc in('.$sucursal_str.')'] = NULL;     
        //$where['pyc_id_suc in('.$sucursal_str.')'] = NULL;     
        //$where['gra_id_suc in('.$sucursal_str.')'] = NULL;        
        $datos_grupos=$this->registro_academico_model->obtener_info_grupos_certificados($where, $alumnos);
        
        $mat=$this->registro_academico_model->get_modulo_siguiente_certificado();   
          
        $this->db->where('pen_id_ard',$area);
        $data['next_mat'] = $this->registro_academico_model->get_materia_siguiente();

        $cant_notas= $this->gsatelite->get_tabla('pod_ponderacion'); 
        $data['cant_th'] = $cant_th=count($cant_notas);
     
        $data['datos'] = $datos_grupos;
        $data['materia'] = $mat;

        $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
        $this->pdf->setPrintFooter(false);
        
        $cert = $this->load->view('registro_academico/consultas/certificado_modulo.php', $data, true);
        $this->pdf->makePDFcertificados($cert);
        $this->pdf->SetMargins(0,0,0);
    }

    public function cargar_alumnos_grupo(){
        satelite_validar(true);
        $area = $this->input->post('area');
        $grupo = $this->input->post('grupo');
        $grado = $this->input->post('grado');
       
        if($grado>0){
            $where = array('lxa_id_ard'=>$area, 'gra_id_grd'=>$grado, 'lxp_estado'=>1);
        }else{
            $where = array('lxa_id_ard'=>$area, 'lxp_id_gra'=>$grupo, 'lxp_estado'=>1);
        }

        $alumnos = $this->registro_academico_model->get_AlumnosxGruposAcademicos($where,1);
        
        echo json_encode($alumnos);
    }


    /**
     * Descripción:
     * Función para la vista de Reporte de sustituciones
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-13
     * @param ninguno
     * @return Obtener la vista de Reporte de Sustituciones
     */
    function reporte_sustituciones() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

        if($this->input->post()) {            
            if($this->input->post('exportar')>0) {
                $fechaDesd = $this->input->post('filtro_fechaDdesde');
                $fechaHast = $this->input->post('filtro_fechaHasta');
            } else {
                $fechaDesd = $this->input->post('fechaDesde');
                $fechaHast = $this->input->post('fechaHasta');
            }

            $fechaDesde = formatear_fecha('Y-m-d', $fechaDesd);
            $fechaHasta = formatear_fecha('Y-m-d', $fechaHast);

            $where = array();
            $html = '';
            $tipo_reporte = ($this->input->post('tipo_reporte'))?$this->input->post('tipo_reporte'):null;

            if($fechaDesde != '' && $fechaHasta != '') {
                $where = "( stm_fecha_creacion BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')";
            }
            
            //$sucursal_str = $this->get_sucursales();                          
            //$where['dct_id_suc in('.$sucursal_str.')'] = NULL;
            //$where['gra_id_suc in('.$sucursal_str.')'] = NULL;
            
            $data['opcion'] = 'reporte';
            $data['periodo'] = formatear_fecha('d-m-Y', $fechaDesde).' - '.formatear_fecha('d-m-Y', $fechaHasta); 
            $data['grupos'] = $this->registro_academico_model->obtener_maestros_sustituto($where);
            $data['escalafon'] = $this->gsatelite->get_tabla('tbe_tabla_escalafon', array('tbe_estado'=>1));
            $data['frecuencia'] = $this->registro_academico_model->get_frecuencias(array('frh_estado'=>1));
            $data['areas'] = $this->gsatelite->get_tabla('ard_area_academica', array('ard_estado'=>1));
            $detalle = $this->load->view('registro_academico/procesos/detalle_maestro_sustituto', $data, true);

           
            $data['titulo'] = 'Reporte de Sustituciones';
            $data['header'] = $rows = $this->load->view('reporte/header', array('titulo' => $titulo), true);

            if($tipo_reporte=='pdf'){
                    $data['user']=$this->tank_auth->get_user_id();
                    $html.= $this->load->view('registro_academico/consultas/sustituciones_export', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Cierre de curso'.date('dmY');

                    $this->pdf->makePdf($html,'L','Reporte de Sustituciones','Letter');
                    // echo $html;
            }else if($tipo_reporte == 'excel'){
           
                    $filename = 'rpt_sustituciones_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

                    $data['filename'] = $filename;
                    $data['excel'] = 1;
                    $html = $this->load->view('registro_academico/consultas/sustituciones_export',$data,true);
                    echo $html;
                    die();
            }else{
                echo $detalle;
                die();
            }

        } else {

            $data["titulo_personal"] ="Reporte de Sustituciones";
            $this->_cargarvista($data);
        }
    }


    /**
     * Descripción:
     * Función para la vista de reporte de grupos cerrados
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-13
     * @param ninguno
     * @return El reporte de Grupos Cerrados
     */
    function reporte_grupos_cerrados() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

        if($this->input->post()) {

            if ($this->input->post('exportar')>0) {
                $fechaDesde = $this->input->post('filtro_fechaInicio');
                $fechaHasta = $this->input->post('filtro_fechaCierre');
            } else {
                $fechaDesde = $this->input->post('fechaInicio');
                $fechaHasta = $this->input->post('fechaCierre');
            }
            $where2 = array();
            $html = '';
            $tipo_reporte = ($this->input->post('tipo_reporte'))?$this->input->post('tipo_reporte'):null;

            if($fechaDesde != '' && $fechaHasta != '') {
                $where2 = "( dcg_fecha_creacion BETWEEN '".$fechaDesde."' AND '".$fechaHasta."')";
            }
            
            $sucursal_str = $this->get_sucursales();                          
            //$where2['gra_id_suc in('.$sucursal_str.')'] = NULL;
            //$where2['pyc_id_suc in('.$sucursal_str.')'] = NULL;
            //$where2['pyc_id_suc in('.$sucursal_str.')'] = NULL;

            $data['opcion'] = 'reporte';
            $data['grupos_cerrados'] = $this->registro_academico_model->get_cierre_grupo(NULL, $where2);
            if (count($data['grupos_cerrados'])>0) {

                $data['frecuencia'] = $this->registro_academico_model->get_frecuencias(array('dfr_id_frh'=>$data['grupos_cerrados'][0]['gra_id_frh'],'gra_id_suc in('.$sucursal_str.')'=>null));
            }
            $detalle = $this->load->view('registro_academico/procesos/detalle_cierre_curso', $data, true);
            if($tipo_reporte=='pdf'){
                    $data['titulo'] = 'Reporte de Grupos Cerrados';

                    $data['user']=$this->tank_auth->get_user_id();
                    $html.= $this->load->view('registro_academico/consultas/grupos_cerrados_export', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Cierre de curso'.date('dmY');

                    $this->pdf->makePdf($html,'L','Reporte de Grupos Cerrados','Letter');
                    // echo $html;
            }else if($tipo_reporte == 'excel'){
           
                    $filename = 'rpt_cierre_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Reporte de Grupos Cerrados';
                    $data['filename'] = $filename;
                    $data['excel'] = 1;
                    $html = $this->load->view('registro_academico/consultas/grupos_cerrados_export',$data,true);
                    echo $html;
                    die();
            }else{
                echo $detalle;
                die();
            }


        } else {

            $data["titulo_personal"] ="Reporte de grupos cerrados";
            $this->_cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función para reporte de Horarios de Supervisor
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-28
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Reporte
     */
    public function horarios_supervisor($flag=NULL) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

        if($this->input->post()) {
            if ($flag) {
                $tipo_contrato = $this->input->post('tipo');
                $fechaDesde = formatear_fecha('Y-m-d', $this->input->post('fechaDesde'));
                $fechaHasta = formatear_fecha('Y-m-d', $this->input->post('fechaHasta'));
                
            } else {
                $tipo_contrato = $this->input->post('filtro_tipo_contrato');
                $fechaDesde = formatear_fecha('Y-m-d', $this->input->post('filtro_fechaDesde'));
                $fechaHasta = formatear_fecha('Y-m-d', $this->input->post('filtro_fechaHasta'));
                
            }
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = array();
            // Condiciones 
            if ($fechaDesde != '' && $fechaHasta != '') {
                $where['DATE(hrs_fecha_inicio) >= '] = $fechaDesde;
                $where['DATE(hrs_fecha_fin) <= '] = $fechaHasta;

            } 

            $where['hrs_estado'] = 1;                        
            $sucursal_str = $this->get_sucursales();                          
            $where['sug_id_suc in('.$sucursal_str.')'] = NULL;

            $this->db->join('dhr_detalle_horario_supervisor', 'dhr_id_hrs=hrs_id', 'left');
            $data['horarios'] = $this->registro_academico_model->obtener_horarios_supervisor($where);

            $filename = 'reporte_horario_supervisores' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['tipo_reporte'] = $tipo_reporte;
        
            $data['fechaDesde'] = $fechaDesde;
            $data['fechaHasta'] = $fechaHasta;
            $data['dias'] = $this->gsatelite->get_tabla('dia_dia', array('dia_estado'=>1));
            $data['hrg'] = $this->gsatelite->get_tabla('hrg_horario_grupo', array('hrg_estado'=>1));

            $detalle = $this->load->view('registro_academico/consultas/horarios_supervisor_export', $data, true);
            
            $titulo = 'Horarios de Supervisor';
            $rows    = $this->load->view('reporte/header', array('titulo' => $titulo), true);
            if ($flag) {
                echo ($detalle);
                die();

            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['pdf'] = 1;
                    $data['header'] = $rows;
                    $GLOBALS['nombre_reporte'] = 'reporte_horario_supervisores' . date('dmY');
                    $html = $this->load->view('registro_academico/consultas/horarios_supervisor_export', $data, true);
                    $reporte = $html;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_horario_supervisores', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_reporte_horarios_supervisor_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['header'] = $rows;
                    $data['excel'] = 1;
                    $data['filename'] = $filename;
                    $html = $this->load->view('registro_academico/consultas/horarios_supervisor_export', $data, true);
                    echo $html;
                }
            }
        } else {
            $data['titulo_personal']="Reporte de horarios de supervisor";
            $this->_cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función para reporte de Alumnos con Beneficio
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-29
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Reporte
     */
    function alumnos_con_beneficio($flag = NULL) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

        if($this->input->post()) {
            if ($flag) {
                $tipo_contrato = $this->input->post('tipo');
                $fechaDesde = formatear_fecha('Y-m-d', $this->input->post('fechaDesde'));
                $fechaHasta = formatear_fecha('Y-m-d', $this->input->post('fechaHasta'));
                
            } else {
                $tipo_contrato = $this->input->post('filtro_tipo_contrato');
                $fechaDesde = formatear_fecha('Y-m-d', $this->input->post('filtro_fechaDesde'));
                $fechaHasta = formatear_fecha('Y-m-d', $this->input->post('filtro_fechaHasta'));
                
            }
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = array();

            $where['apb_estado'] = 1;
            $where['slb_estado_solicitud'] = 2;
            $sucursal_str = $this->get_sucursales();                          
            $where['alm_id_suc in('.$sucursal_str.')'] = NULL;
            $groupby = 'alm_id';
            $data['alumnos']= $this->registro_academico_model->get_alm_con_beneficio($where, $groupby, $fechaDesde, $fechaHasta);            
            $filename       = 'reporte_alumnos_beneficio' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['tipo_reporte'] = $tipo_reporte;
        
            $data['fechaDesde'] = $fechaDesde;
            $data['fechaHasta'] = $fechaHasta;

            $titulo = 'Alumnos con beneficio';
            $data['header'] = $rows    = $this->load->view('reporte/header', array('titulo' => $titulo), true);
            $detalle = $this->load->view('registro_academico/consultas/alumnos_beneficio_export', $data, true);
            
            if ($flag) {
                echo ($detalle);
                die();

            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Alumnos con beneficio';
                    $data['pdf'] = 1;
                    $GLOBALS['nombre_reporte'] = 'reporte_alumnos_beneficio' . date('dmY');
                    $html = $this->load->view('registro_academico/consultas/alumnos_beneficio_export', $data, true);
                    $reporte = $html;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_alumnos_beneficio', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_reporte_alumnos_beneficio_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Alumnos con beneficio';

                    $data['excel'] = 1;
                    $data['filename'] = $filename;
                    $html = $this->load->view('registro_academico/consultas/alumnos_beneficio_export', $data, true);
                    echo $html;
                }
            }

        }else{
            $data['titulo_personal']="Reporte de alumnos con beneficio";
            $this->_cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función para reporte de Disponibilidad de Docentes
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-01-04
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Reporte
     */
    function disponibilidad_docente($flag = NULL) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

         if($this->input->post()) {
            if ($flag) {
                $tipo_contrato = $this->input->post('tipo');
                $area = $this->input->post('area');
                $frecuencia = $this->input->post('frecuencia');
                
            } else {
                $tipo_contrato = $this->input->post('filtro_tipo_contrato');
                $area = $this->input->post('filtro_area');
                $frecuencia = $this->input->post('filtro_frecuencia');
                
            }
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = array();
            if ($area != NULL && $frecuencia != NULL) {
                $where['area_fr.ard_id'] = $area;
                $where['frh_id'] = $frecuencia;
            }
            $where['dct_estado'] = 1;
            
            $sucursal_str = $this->get_sucursales();                          
            $where['dct_id_suc in('.$sucursal_str.')'] = NULL;
        
            $data['docentes'] = $this->registro_academico_model->get_docentes($where);
            $filename = 'reporte_disponibilidad_docente' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['tipo_reporte'] = $tipo_reporte;
        
            $data['area'] = $this->gsatelite->get_tabla('ard_area_academica', array('ard_id'=>$area, 'ard_estado'=>1));
            $data['frecuencia'] = $this->gsatelite->get_tabla('frh_frecuencia_horario', array('frh_id'=>$frecuencia, 'frh_estado'=>1));

            $detalle = $this->load->view('registro_academico/consultas/disponibilidad_docente_export', $data, true);
            
            
            $data['titulo'] = $titulo = 'Disponibilidad de docentes';
            $data['header'] = $rows    = $this->load->view('reporte/header', array('titulo' => $titulo), true);
            if ($flag) {
                echo ($detalle);
                die();

            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['pdf'] = 1;
                    $GLOBALS['nombre_reporte'] = 'reporte_alumnos_beneficio' . date('dmY');
                    $html = $this->load->view('registro_academico/consultas/disponibilidad_docente_export', $data, true);
                    $reporte = $html;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_disponibilidad_docente', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_reporte_disponibilidad_docente_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['excel'] = 1;
                    $data['filename'] = $filename;
                    $html = $this->load->view('registro_academico/consultas/disponibilidad_docente_export', $data, true);
                    echo $html;
                }
            }

        } else {

            $areas = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1), null, '', 'ard_id', true);
            $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $areas);
            $frecuencias = $this->gsatelite->get_dropdown('frh_frecuencia_horario', '{frh_nombre}', '', array('frh_estado' => 1), null, '', 'frh_id', true);
            $data["frecuencias"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $frecuencias);
            $data['titulo_personal']="Reporte de disponibilidad de docentes";
            $this->_cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función para reporte de Secciones por área y horario
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-01-06
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Reporte
     */
    function seccionesxarea_horario($flag=NULL) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

         if($this->input->post()) {
            if ($flag) {
                $proyeccion = $this->input->post('proyeccion');
                $area = $this->input->post('area');
                $frecuencia = $this->input->post('frecuencia');
                
            } else {
                $proyeccion = $this->input->post('filtro_proyeccion');
                $area = $this->input->post('filtro_area');
                $frecuencia = $this->input->post('filtro_frecuencia');
                
            }
           
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = array();

            if ($proyeccion != '') {
                $where['pyc_id'] = $proyeccion;
            }
            if ($area != '') {
                $where['ard_id'] = $area;
            }
            if ($frecuencia != '') {
                $where['frh_id'] = $frecuencia;
            }

            $sucursal_str = $this->get_sucursales();                          
            //$where['gra_id_suc in('.$sucursal_str.')'] = NULL;
            //$where['dct_id_suc in('.$sucursal_str.')'] = NULL;
            //$where['pyc_id_suc in('.$sucursal_str.')'] = NULL;           
            $data['grupos'] = $this->registro_academico_model->get_grupos($where);
            $data['detalles'] = $this->registro_academico_model->get_frecuencias();
          
            $filename = 'reporte_seccionesxarea_horario' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['tipo_reporte'] = $tipo_reporte;
        
            $data['proyeccion'] = $this->gsatelite->get_tabla('pyc_proyeccion', array('pyc_id'=>$proyeccion, 'pyc_estado'=>1));
            $data['area'] = $this->gsatelite->get_tabla('ard_area_academica', array('ard_id'=>$area, 'ard_estado'=>1));
            $data['frecuencia'] = $this->gsatelite->get_tabla('frh_frecuencia_horario', array('frh_id'=>$frecuencia, 'frh_estado'=>1));

            $detalle = $this->load->view('registro_academico/consultas/seccionesxarea_horario_export', $data, true);
            
            if ($flag) {
                echo ($detalle);
                die();

            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Secciones por &aacute;rea y horario';
                    $titulo_reporte = 'Secciones por &aacute;rea y horario';
                    $data['pdf'] = 1;

                    $GLOBALS['nombre_reporte'] = 'reporte_seccionesxarea_horario' . date('dmY');
                    $header = $this->load->view('reporte/header', array('titulo' => $titulo_reporte, 'solotitulo' => true), true);
                    $html = $this->load->view('registro_academico/consultas/seccionesxarea_horario_export', $data, true);
                    $reporte = $header.$html;

                    $this->pdf->makePdf($reporte, 'L', 'reporte_seccionesxarea_horario', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_reporte_seccionesxarea_horario_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Secciones por &Aacute;rea y Horario';

                    $data['excel'] = 1;
                    $data['filename'] = $filename;
                    $html = $this->load->view('registro_academico/consultas/seccionesxarea_horario_export', $data, true);
                    echo $html;
                }
            }

        } else {
            //$sucursal_str = $this->get_sucursales();                          
            //$this->db->where('pyc_id_suc in('.$sucursal_str.')',NULL);
            $proyeccion         = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);
            $proyeccion         = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $proyeccion);
            $data["proyeccion"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $proyeccion);
            $frecuencias = $this->gsatelite->get_dropdown('frh_frecuencia_horario', '{frh_nombre}', '', array('frh_estado' => 1), null, '', 'frh_id', true);
            $data["frecuencias"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $frecuencias);
            $data['titulo_personal']="Reporte de secciones por área y horario";
            $this->_cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función para obtener el area de una proyeccion
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-01-06
     * @param Ninguno
     * @return Obtener el area una proyeccion
     **/
    function ajax_cargar_area() {
        satelite_validar(true);
        if ($this->input->post()) {
            $pyc = $this->input->post('proyeccion');
            $campo = $this->gsatelite->get_tabla('pyc_proyeccion', array('pyc_id'=>$pyc, 'pyc_estado'=>1));            
            $pyc_area = $this->gsatelite->get_tabla('ard_area_academica', array('ard_id'=>$campo[0]['pyc_id_ard']));
            if (!(count($pyc_area) > 0)) {
                $pyc_area = $this->registro_academico_model->get_areasXproyeccion(array("axy_id_pyc" => $pyc, "ard_estado" => 1));
            }
            // print_r($pyc_area);die();
            echo json_encode($pyc_area);

        }
    }

    function ajax_get_areas() {
        satelite_validar(true);
        if ($this->input->post()) {
            $select = '<option></option>';
            $pyc = $this->input->post('proyeccion');
            $campo = $this->gsatelite->get_tabla('pyc_proyeccion', array('pyc_id'=>$pyc, 'pyc_estado'=>1));            
            $pyc_area = $this->gsatelite->get_tabla('ard_area_academica', array('ard_id'=>$campo[0]['pyc_id_ard']));
            if (!(count($pyc_area) > 0)) {
                $pyc_area = $this->registro_academico_model->get_areasXproyeccion(array("axy_id_pyc" => $pyc, "ard_estado" => 1));
            }
            foreach ($pyc_area as $k => $ard) {
                $select .= '<option value="'.$ard['ard_id'].'">'.$ard['ard_nombre'].'</option>';
            }
            echo $select;
        }
    }

    /**
     * Descripción:
     * Función para obtener las frecuencias por area y proyeccion
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-01-08
     * @param Ninguno
     * @return Obtener las frecuencias
     **/
    function ajax_frecuenciasxarea() {
        satelite_validar(true);

        if ($this->input->post()) {
            $pyc = $this->input->post('proyeccion');
            $area = $this->input->post('area');

            $frecuencias = $this->registro_academico_model->get_frecuencia_pyc_area(array('pyc_id'=>$pyc));
            // print_r($frecuencias);die();
            $html = '';
            foreach ($frecuencias as $key => $value) {
                $html .= '<option value="'.$value['frh_id'].'">'.$value['frh_nombre'].'</option>';
            }
            // print_r($pyc_area);die();
            echo json_encode($html);

        }
    }

    /**
     * Descripción:
     * Función para reporte de Alumnos por Área y Grupo
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-01-08
     * @param  $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Reporte
     */
    function alumnosxarea_grupo($flag=NULL) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        if($this->input->post()) {
            if ($flag) {
                $proyeccion = $this->input->post('proyeccion');
                $area = $this->input->post('area');
                $grupo = $this->input->post('grupo');                
            } else {
                $proyeccion = $this->input->post('filtro_proyeccion');
                $area = $this->input->post('filtro_area');
                $grupo = $this->input->post('filtro_grupo');
                
            }
            $where = array();
            $tipo_reporte = $this->input->post('tipo_reporte');
            if ($proyeccion > 0) {
                $where['gra_id_pyc'] = $proyeccion;
            }
            if ($area > 0) {
                $where['gra_id_ard'] = $area;
            }
            if ($grupo > 0) {
                $where['gra_id'] = $grupo;
            }
            $data['alumnos'] = $alumnos = $this->registro_academico_model->alumnosxarea_grupo($where);
            $data['detalles'] = $this->registro_academico_model->get_frecuencias();            
            $filename = 'reporte_alumnosxarea_grupo' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['tipo_reporte'] = $tipo_reporte;

            // Información del Grupo
            $data['grupo'] = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id'=>$grupo, 'gra_estado'=>1));
            $data['proyeccion'] = $this->gsatelite->get_tabla('pyc_proyeccion', array('pyc_id'=>$proyeccion, 'pyc_estado'=>1));
            $data['area'] = $this->gsatelite->get_tabla('ard_area_academica', array('ard_id'=>$area, 'ard_estado'=>1));
            $data['frecuencia'] = $this->gsatelite->get_tabla('frh_frecuencia_horario', array('frh_id'=>$data['grupo'][0]['gra_id_frh'], 'frh_estado'=>1));
            $data['seccion'] = $this->gsatelite->get_tabla('scc_seccion', array('scc_id'=>$data['grupo'][0]['gra_id_scc'], 'scc_estado'=>1));
            $this->db->join('mod_modulo', 'pen_id_mod=mod_id');
            $data['pensum'] = $this->gsatelite->get_tabla('pen_pensum', array('pen_id'=>$data['grupo'][0]['gra_id_pen'], 'pen_estado'=>1));
            $this->db->join('emp_empleado', 'emp_id=dct_id_emp');
            $data['docente'] = $this->gsatelite->get_tabla('dct_docente', array('dct_id'=>$data['grupo'][0]['gra_id_dct'], 'dct_estado'=>1));

            // Titulo del documento
            $titulo_reporte = 'Reporte de alumnos por área y grupo';
            $bachillerato = ($alumnos[0]['gra_id_grd']>0)?1:0;


            $header = $this->load->view('reporte/header', array('titulo' => $titulo_reporte, 'solotitulo' => true), true);
            $detalle = $this->load->view('registro_academico/consultas/alumnosxarea_grupo_export', $data, true);
            
            if ($flag) {
                echo json_encode(array('detalle'=>$detalle, 'tipo'=>$bachillerato));
                die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    ini_set('memory_limit', '1024M');
                    ini_set('max_execution_time', '9999');
                    $data['titulo'] = 'Alumnos por &aacute;rea y grupo';
                    $data['pdf'] = 1;
                    $GLOBALS['nombre_reporte'] = 'reporte_alumnosxarea_grupo' . date('dmY');
                    $html = $this->load->view('registro_academico/consultas/alumnosxarea_grupo_export', $data, true);
                    $reporte = $header.$html;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_alumnosxarea_grupo', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_reporte_alumnosxarea_grupo_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Alumnos por &aacute;rea y grupo';
                    $data['excel'] = 1;
                    $data['filename'] = $filename;
                    $html = $this->load->view('registro_academico/consultas/alumnosxarea_grupo_export', $data, true);
                    $reporte = $html;
                    echo $reporte;
                }
            }

        } else {
            $sucursal_str = $this->get_sucursales();
                          $this->db->where('pyc_id_suc in('.$sucursal_str.')',NULL);
            $proyeccion = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);            
            $proyeccion = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $proyeccion);
            $data["proyeccion"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $proyeccion);
            $data['titulo_personal']="Reporte de alumnos por área y grupo";
            $this->_cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función para obtener los grupos asociados a una proyeccion
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-01-08
     * @param Ninguno
     * @return Obtener los grupos
     */
    function ajax_grupoxproyeccion() {
        satelite_validar(true);
        if ($this->input->post()) {
            $pyc = $this->input->post('proyeccion');
            $area = $this->input->post('area');
            $user = $this->tank_auth->get_user_id();

                        $this->db->join('emp_empleado', 'usu_id_emp = emp_id', 'left');
                        $this->db->join('dct_docente', 'dct_id_emp = emp_id', 'left');
            $registro = $this->gsatelite->get_tabla('users', array('id'=>$user));

            $where = array('pyc_id' => $pyc, 'gra_estado' => 1);
            if (count($registro) > 0 && $registro[0]['dct_id'] > 0) {
                $where['gra_id_dct'] = $docente;
            }

            $grupos = $this->registro_academico_model->get_gruposxproyeccion($where);
            if (!(count($grupos) > 0)) {
                $grupos = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id_pyc' => $pyc, 'gra_id_ard' => $area, 'gra_estado' => 1));
            }

            $html = '<option value=""></option>';
            foreach ($grupos as $key => $value) {
                $html .= '<option value="'.$value['gra_id'].'">'.$value['gra_nombre'].'</option>';
            }
            // print_r($pyc_area);die();
            echo json_encode($html);

        }
    }

    /**
     * Descripción:
     * Función para reporte de Asistencia de Alumnos
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-01-16
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Reporte
     */
    function asistencia_alumnos($flag=NULL) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

         if($this->input->post()) {
            if ($flag) {
                $proyeccion = $this->input->post('proyeccion');
                $area       = $this->input->post('area');
                $grupo      = $this->input->post('grupo');
                $fechaInicio= formatear_fecha('Y-m-d', $this->input->post('fechaInicio'));
                $fechaFin   = formatear_fecha('Y-m-d', $this->input->post('fechaFin'));
                $exportar   = $this->input->post('exportar');
            } else {
                $proyeccion = $this->input->post('filtro_proyeccion');
                $area       = $this->input->post('filtro_area');
                $grupo      = $this->input->post('filtro_grupo');
                $fechaInicio= formatear_fecha('Y-m-d', $this->input->post('filtro_fechaInicio'));
                $fechaFin   = formatear_fecha('Y-m-d', $this->input->post('filtro_fechaFin'));
                $exportar   = $this->input->post('exportar');
            }
            
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = '';

            if ($grupo != '') {
                $where['asg_id_gra'] = $grupo;
            }

            // Proceso de Fechas
            $date1  = new DateTime($fechaInicio.' 00:00:00');
            $date2  = new DateTime($fechaFin.' 24:00:00');
            $diff   = $date1->diff($date2);
            // will output 2 days
            $data['dias_fechas'] = $diff->days;

            // Array de rango de fechas
            $period = new DatePeriod(
                 new DateTime($fechaInicio.' 00:00:00'),
                 new DateInterval('P1D'),
                 new DateTime($fechaFin.' 24:00:00')
            );
            
            $fechas = array();
            // recorrido de fechas
            foreach ($period as $key => $value) {
                array_push($fechas, $value->format('Y-m-d'));
            }
            
            $data['permisos']   = $permisos;
            $data['fechas']     = $fechas;

            // Fechas filtradas
            $data['fechaInicio']    = $fechaInicio;
            $data['fechaFin']       = $fechaFin;

            $data['alumnos'] = $this->registro_academico_model->obtener_dias_asistencia_grupo($where, 'alm_id', $fechaInicio, $fechaFin);
            //die(print_r($this->db->last_query()));
            // print_r($data['alumnos']);die();
            $filename = 'reporte_alumnosxarea_grupo' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']       = $filename;
            $data['tipo_reporte']   = $tipo_reporte;

            // Informacion del Grupo
            $data['grupo']      = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id'=>$grupo, 'gra_estado'=>1));
            $data['proyeccion'] = $this->gsatelite->get_tabla('pyc_proyeccion', array('pyc_id'=>$proyeccion, 'pyc_estado'=>1));
            $data['area']       = $this->gsatelite->get_tabla('ard_area_academica', array('ard_id'=>$area, 'ard_estado'=>1));
            $data['frecuencia'] = $this->gsatelite->get_tabla('frh_frecuencia_horario', array('frh_id'=>$data['grupo'][0]['gra_id_frh'], 'frh_estado'=>1));
            $this->db->join('emp_empleado', 'emp_id=sug_id_emp');
            $data['supervisor'] = $this->gsatelite->get_tabla('sug_supervisor_grupo', array('sug_id'=>$data['grupo'][0]['gra_id_sug'], 'sug_estado'=>1));
            $data['seccion']    = $this->gsatelite->get_tabla('scc_seccion', array('scc_id'=>$data['grupo'][0]['gra_id_scc'], 'scc_estado'=>1));
            $this->db->join('mod_modulo', 'pen_id_mod=mod_id');
            $data['pensum']     = $this->gsatelite->get_tabla('pen_pensum', array('pen_id'=>$data['grupo'][0]['gra_id_pen'], 'pen_estado'=>1));
            $this->db->join('emp_empleado', 'emp_id=dct_id_emp');
            $data['docente']    = $this->gsatelite->get_tabla('dct_docente', array('dct_id'=>$data['grupo'][0]['gra_id_dct'], 'dct_estado'=>1));

            // Titulo del documento
            $titulo_reporte = 'Reporte de asistencia';

            $header     = $this->load->view('reporte/header', array('titulo' => $titulo_reporte, 'solotitulo' => true), true);
            $detalle    = $this->load->view('registro_academico/consultas/asistencia_alumnos_export', $data, true);
            
            if ($flag) {
                
                echo ($detalle);
                die();

            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['pdf']    = 1;
                    $GLOBALS['nombre_reporte'] = 'reporte_alumnosxarea_grupo' . date('dmY');
                    $html       = $this->load->view('registro_academico/consultas/asistencia_alumnos_export', $data, true);
                    $reporte    = $header.$html;

                    // echo $reporte;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_alumnosxarea_grupo', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename       = 'rpt_reporte_alumnosxarea_grupo_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['excel']      = 1;
                    $data['filename']   = $filename;

                    $html    = $this->load->view('registro_academico/consultas/asistencia_alumnos_export', $data, true);
                    $reporte = $html;
                    echo $reporte;
                }
            }

        } else {
            $proyeccion = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);
            $data["proyeccion"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $proyeccion);

            $data['titulo_personal'] = "Reporte de asistencia";
            $this->_cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función para reporte de Estadisticas de Alumnos
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-01-19
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Reporte
     */
    function estadistica_alumnos($flag=NULL) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

         if($this->input->post()) {
            
            if ($flag) {
                $frecuencia = $this->input->post('frecuencia');
                $areas = $this->input->post('areas');
                $exportar = $this->input->post('exportar');
                
            } else {
                $frecuencia = $this->input->post('filtro_frecuencia');
                $areas = $this->input->post('filtro_areas');
                $exportar = $this->input->post('exportar');
            }
            
            $tipo_reporte = $this->input->post('tipo_reporte');

            if (count($areas)>0) {
                $ard = '';
                foreach ($areas as $key => $value) {
                    $ard .= $value.",";
                }

                $registros = substr($ard, 0, -1);
                $where["ard_id IN ('$registros')"] = null;
            }

            // Permisos
            $data['permisos'] = $permisos;
            
            $sucursal_str = $this->get_sucursales();                          
            $where['gra_id_suc in('.$sucursal_str.')'] = NULL;
            $this->db->where(array('gra_id_frh'=>$frecuencia));
            $data['estadisticas'] = $this->registro_academico_model->get_estadisticas_alumnos($where);
            
            // Detalle de horarios por frecuencia
            $data['detalles'] = $this->registro_academico_model->get_frecuencias(array('frh_id'=>$frecuencia));
            $data['frecuencia'] = $this->gsatelite->get_tabla('frh_frecuencia_horario', array('frh_id'=>$frecuencia));

            $filename = 'reporte_alumnosxarea_grupo' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['tipo_reporte'] = $tipo_reporte;

            // Titulo del documento
            $titulo_reporte = 'REPORTE DE ESTADISTICAS DE ALUMNOS ACTIVOS';

            $header = $this->load->view('reporte/header', array('titulo' => $titulo_reporte, 'solotitulo' => true), true);
            $detalle = $this->load->view('registro_academico/consultas/estadisticas_alumnos_export', $data, true);
            
            if ($flag) {
                
                echo ($detalle);
                die();

            } else {
                // PDF
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Estad&iacute;sticas de alumnos activos';
                    $data['pdf'] = 1;
                    $GLOBALS['nombre_reporte'] = 'reporte_estadisticas_alumnos' . date('dmY');
                    $html = $this->load->view('registro_academico/consultas/estadisticas_alumnos_export', $data, true);
                    $reporte = $header.$html;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_estadisticas_alumnos', 'Letter');
                // EXCEL
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_reporte_estadisticas_alumnos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Estad&iacute;sticas de alumnos activos';
                    $data['excel'] = 1;
                    $data['filename'] = $filename;
                    $html = $this->load->view('registro_academico/consultas/estadisticas_alumnos_export', $data, true);
                    $reporte = $html;
                    echo $reporte;
                }
            }

        } else {
            $areas = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1), null, '', 'ard_id', true);
            $data["areas"] = str_replace('<option value="0">Seleccione</option>', '', $areas);

            $data['titulo_personal']="Reporte de estadísticas de alumnos activos";
            $this->_cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función para obtener las frecuencias por areas
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-01-22
     * @param Ninguno
     * @return Obtener Reporte
     */
    function ajax_areasxfrecuencias() {
        satelite_validar(true);
        if ($this->input->post()) {
            $where = '';
            $areas = $this->input->post("areas");
            $ard = '';

            foreach ($areas as $key => $value) {
                $ard .= $value.",";
            }

            $registros = substr($ard, 0, -1);

                        $where = 'ard_id IN ('.$registros.')';
                        $this->db->group_by('frh_id');
                        $this->db->join('frh_frecuencia_horario', 'frh_id_ard=ard_id');
            $consulta = $this->gsatelite->get_tabla('ard_area_academica', $where);
      
            $html = "<option value=''></option>";
            foreach ($consulta as $key => $value) {
                $html .= "<option value='".$value['frh_id']."'>".$value['frh_nombre']."</option>";
            }

            echo json_encode(array('html'=> $html));
        }
    }

    /**
     * @author Edith Herrera - Grupo Satélite
     * @since 2018-01-27
     * @param Ninguno
     * @return Obtener Reporte de alumnos pre-inscritos.
     */
     function alumno_no_inscrito(){
        satelite_validar();
        if($_POST){
            $id_pyc = $this->input->post('proyeccion');
            $id_nivel = $this->input->post('nivel');
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = array();
            if ($id_pyc != '') {
                $where['pyc_id'] = $id_pyc;
            }
            if ($id_nivel != '') {
                $where['mod_id'] = $id_nivel;
            }
            
            $sucursal_str = $this->get_sucursales();                          
            $where['alm_id_suc in('.$sucursal_str.')'] = NULL;
            $where['lxp_condicion'] = 1; //Materia inscrita 
            $where['lxp_tipo_inscripcion'] = 1; //pre-inscrito
            $data['alumnos'] = $registro= $this->registro_academico_model->get_registro_inscripcion($where, 'alm_id');
           
            $html=$this->load->view('registro_academico/consultas/detalle_no_inscrito', $data, true);
            $rows = $this->load->view('reporte/header', array('titulo' => "Alumnos no inscritos"), true); 
            if($tipo_reporte==1){
                    $data['header'] = $rows;
            //die(print_r($data['header']));
                    $data['titulo'] = 'Reporte de Alumnos no inscritos';
                    $data['user']=$this->tank_auth->get_user_id();
                    $html= $this->load->view('registro_academico/consultas/no_inscrito_export', $data, true);
                    //$GLOBALS['nombre_reporte'] = 'Alumnos no inscritos'.date('dmY');
                    $this->pdf->makePdf($html,'L','Reporte de Alumnos no inscritos','Letter');

            }else if($tipo_reporte == 2){
                    $filename = 'rpt_alumnos_no_inscritos'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Reporte de Alumnos no inscritos';
                    $data['filename'] = $filename;
                    $data['excel'] = 1;
                    $html = $this->load->view('registro_academico/consultas/no_inscrito_export',$data,true);
                    echo $html;
                    die();
            }else{
                echo json_encode($html);
                die();
            }
        }else{
            $sucursal_str = $this->get_sucursales();                          
            $this->db->join('ard_area_academica', 'ard_id=pyc_id_ard');
            $this->db->where('pyc_id_suc in('.$sucursal_str.')',NULL);
            $proyeccion = $this->gsatelite->get_tabla('pyc_proyeccion', array('pyc_estado' => 1));

            $opt_proyeccion = '<option value=""></option>';
            foreach ($proyeccion as $pyc ) {
                $opt_proyeccion .= '<option value="'.$pyc['pyc_id'].'" data-area="'.$pyc['ard_nombre'].'">'.$pyc['pyc_nombre'].'</option>';
            }
            $data['proyeccion'] = $opt_proyeccion;

            $data["titulo_personal"] ="Alumnos no inscritos";
            $this->_cargarvista($data);
        }  
    }

    /**
     * Descripción:
     * Función para la generación de Diplomas
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-01-25
     * @param Ninguno
     * @return Obtener los diplomas por Grupos
     */
    function generacion_diplomas($flag=NULL) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        if ($this->input->post()) {
            $fecha='';
            if ($flag != NULL) {
                $tipo_diploma   = $this->input->post('tipo_diploma');
                $area           = $this->input->post('area');
                $proyeccion     = $this->input->post('proyeccion');
                $grupo          = $this->input->post('grupo');
            } else {
                $tipo_diploma   = $this->input->post('filtro_tipo_diploma');
                $area           = $this->input->post('filtro_area');
                $proyeccion     = $this->input->post('filtro_proyeccion');
                $grupo          = $this->input->post('filtro_grupo');
                $fecha          = $this->input->post('filtro_fecha');
                
                $tipo_reporte   = $this->input->post('tipo_reporte');
                $condicion      = $this->input->post('condicionImpresion');
                $imprimir       = $this->input->post('imprimirDiplomas');
                $todo           = $this->input->post('checkTodos');
                $exportar       = $this->input->post('exportar');
            }

            // consulta para obtener los alumnos
            $arrayFitro = array('lxp_id_gra'=>$grupo, 'lxp_condicion'=>2, 'lxp_promedio > '=>7);
            
            $sucursal_str = $this->get_sucursales();                          
            $this->db->where('alm_id_suc in('.$sucursal_str.')',NULL);
            $this->db->where('gra_id_suc in('.$sucursal_str.')',NULL);
            $alumnos = $this->registro_academico_model->get_alumnos_diplomas($arrayFitro); //print_r($alumnos);die();
            // Obtener el tipo de diploma
            $tipo_diploma       = $this->gsatelite->get_tabla('frd_formato_diploma', array('frd_id'=>$tipo_diploma, 'frd_activo'=>1));
            // Obtener las configuraciones para el formato de diploma
            $conf_frd           = $tipo_diploma[0]['frd_configuraciones_formato'];
            $conf_frd_array     = json_decode($conf_frd, true); //print_r($_POST);die();
            // Consulta enviada a la vista para procesar
            $data['alumnos']    = $alumnos;            
            // Array Asociativo con los parametros de la frd para mandarlos a la impresion de diplomas
            $data['parrafos']       = (isset($conf_frd_array['body']))?$conf_frd_array['body']:'';
            $data['municipio']  = (isset($conf_frd_array['MUNICIPIO']))?$conf_frd_array['MUNICIPIO']:'';
            if ( $flag ) {
                $detalle        = $this->load->view('registro_academico/consultas/detalle_generacion_diplomas', $data, true);
                echo $detalle;
                die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    if($fecha !=''){
                        $fec_diploma = formatear_fecha('d-m-Y', $fecha);
                    }else{
                        $fec_diploma =  date('d-m-Y');
                    }
                    
                    $data['fechaLetras_es'] = $this->convertir_fecha_larga_es($fec_diploma, false, false);                    
                    $data['fechaLetras_en'] = $this->convertir_fecha_larga_en($fec_diploma, false, false);//print_r($data['fechaLetras_en']);die();

                    $imprimirTitulo = array(); 
                    // Condicion para permitir imprimir el titulo por alumno
                    foreach ($imprimir as $key => $value) {
                       if ($condicion[$key] == 1) {
                            array_push($imprimirTitulo, $value);
                       }
                    }
                    
                    $data['imprimirTitulo'] = $imprimirTitulo;
                    $data['pdf'] = 1;                    
                    $html = $this->load->view('registro_academico/consultas/'.$tipo_diploma[0]['frd_archivo'], $data, true);

                    $GLOBALS['nombre_reporte'] = 'diploma_generado_alumnos_' . date('dmY');

                    if(isset($conf_frd_array['SETCELLPADDINGS']) != ''){

                        $orientacion        = (isset($conf_frd_array['ORIENTACION']))?$conf_frd_array['ORIENTACION']:'L';
                        $formato            = $conf_frd_array['FORMATO'];
                        $formato_array      = explode(",",$formato); //convierte el formato a array por si se quiere un formato personalizado de pagina
                        $setCellPaddings    = $conf_frd_array['SETCELLPADDINGS'];
                        $margins            = $conf_frd_array['MARGINS'];
                        $formato            = (count($formato_array) > 1)?$formato_array:$formato; //si tiene mas de un elemento se toma el array y si no el valor del formato

                        $this->pdf->setPrintHeader(false);
                        $this->pdf->SetFont('helvetica');
                        $this->pdf->setCellPaddings($setCellPaddings);
                        $this->pdf->SetAutoPageBreak(true, 0);
                        $this->pdf->SetMargins($margins); 
                        $this->pdf->AddPage($orientacion, $formato, array(
                            'family' => 'helvetica',
                            'style' => '',
                            'size' => 6)
                        );

                        $this->pdf->setPrintFooter(false);
                        $this->pdf->writeHTML($html, true, false, false, false, '');
                        $this->makePDF($html, $orientacion, null , 'Letter');

                    } else {
                        $orientacion = (isset($conf_frd_array['ORIENTACION']))?$conf_frd_array['ORIENTACION']:'L';
                        // $this->pdf->SetFont('helvetica');
                        $this->pdf->setPrintFooter(false);
                        $this->pdf->makePDF($html, $orientacion, null , 'Letter');
                        // echo $html;
                        
                    }

                }
            }


        } else {
            $tipo_diplomas = $this->gsatelite->get_dropdown('frd_formato_diploma', '{frd_nombre}', '', array('frd_estado' => 1, 'frd_id <>' => 4), null, '', 'frd_id', true);
            $data["tipo_diplomas"] = str_replace('<option value="0">Seleccione</option>', '', $tipo_diplomas);
            $areas = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1), null, '', 'ard_id', true);
            $data["areas"] = str_replace('<option value="0">Seleccione</option>', '', $areas);
            $data['titulo_personal']="Generación de Diplomas";
            $this->_cargarvista($data);
        }
        
    }

    /**
     * Descripción:
     * Función para obtener las proyecciones por area
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-01-25
     * @param Ninguno
     * @return Obtener las proyecciones
     */
    function get_areaxproyeccion() {
        satelite_validar(true);

        if ($this->input->post()) {
            $area        = $this->input->post('area');

            $this->db->join('ard_area_academica', 'pyc_id_ard=ard_id');
            $consulta    = $this->gsatelite->get_tabla('pyc_proyeccion', array('ard_id'=>$area, 'pyc_estado'=>1));

            $html        = '<option value=""></option>';
            foreach ($consulta as $key => $value) {
                $html   .= '<option value="'.$value['pyc_id'].'">'.$value['pyc_nombre'].'</option>';
            }

            $datos       = array('select'=>$html);

            echo json_encode($datos);
            die();
        }
    }

    /**
     * Descripción:
     * Función para convertir de fecha resumida (20/12/2015) a fecha extendida (20 de diciembre de 2015)
     * @author Elman Ortiz - Grupo Satélite
     * modified Luis Navarro
     * @since 2018-01-27
     * @param $fecha = Es la fecha a convertir, $complemento = Es el string entre dia y mes , y entre mes anio
     * @param $completa = Deternina si se devuelve un string con la fecha completa o los segmentos del dia, mes y anio
     * @return Retorna la fecha en formato largo ya sea en un solo string o en segmentos dentro de un array
     */
    public function convertir_fecha_larga_es($fecha, $complemento = null, $completa = null){
        $this->load->library('EnLetras');
        $meses_array=array('','Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre');
        $fecha_larga = [];

        $fechaDia = formatear_fecha('d',$fecha);
        $fechaAnio = formatear_fecha('Y',$fecha);

        $fecha_larga['dia'] = $this->enletras->num2letras($fechaDia) . ' '.$complemento;
        $fecha_larga['mes'] = $meses_array[(intval(formatear_fecha('m',$fecha)))]. ' '.$complemento ;
        $fecha_larga['anio'] = $this->enletras->num2letras($fechaAnio);
        if($completa){ 
            return $fecha_larga['dia']. ' ' . $fecha_larga['mes']. ' ' . $fecha_larga['anio'];
        }else{
            return $fecha_larga;
        }        
    }

    /**
     * Descripción:
     * Función para convertir de fecha resumida (20/12/2015) a fecha extendida (20 de diciembre de 2015)
     * @author Elman Ortiz - Grupo Satélite
     * modified Luis Navarro
     * @since 2018-01-27
     * @param $fecha = Es la fecha a convertir, $complemento = Es el string entre dia y mes , y entre mes anio
     * @param $completa = Deternina si se devuelve un string con la fecha completa o los segmentos del dia, mes y anio
     * @return Retorna la fecha en formato largo ya sea en un solo string o en segmentos dentro de un array
     */
    public function convertir_fecha_larga_en($fecha, $complemento = null, $completa = null){
        $this->load->library('EnLetras_en');
        $fecha_larga = [];
        $fecha_larga['dia'] = $this->enletras_en->num2letras(formatear_fecha('d',$fecha)) . ' '.$complemento;
        $fecha_larga['mes'] = $this->enletras_en->mes_anio(formatear_fecha('d-m-Y',$fecha), 3). ' '.$complemento ;
        $fecha_larga['anio'] = $this->enletras_en->SubValLetra(formatear_fecha('Y',$fecha));
        if($completa){ 
            return $fecha_larga['dia']. ' ' . $fecha_larga['mes']. ' ' . $fecha_larga['anio'];
        }else{
            return $fecha_larga;
        }        
    }

     /**
     * @author Edith Herrera - Grupo Satélite
     * @since 2018-01-29
     * @param Ninguno
     * @return Obtener Reporte de escalafón.
     */
     function escalafon_docente(){
        satelite_validar();
        if($_POST){
            $codigo = $this->input->post('codigo');
            $id_categ = $this->input->post('categoria');
            $id_docente = $this->input->post('docente');

            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = array();
            if ($codigo != '') {
                $where['tbe_codigo'] = $codigo; 
            }
            if ($id_categ != '') {
                $where['tbe_id_ctf'] = $id_categ; 
            }
            if ($id_docente != '') {
                $where['ctf_id'] = $id_docente; 
            }   
            

            //$sucursal_str = $this->get_sucursales();                          
            //$where['dct_id_suc in('.$sucursal_str.')'] = NULL;
            
            $data['registros'] = $registro= $this->registro_academico_model->get_docentes_escalafon($where, 'left');
         
            $decimal = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
            $data['decimales'] = ($decimal>0)?$decimal:2;
            
            $html=$this->load->view('registro_academico/consultas/detalle_escalafon', $data, true);

            $rows = $this->load->view('reporte/header', array('titulo' => "Escalafón de docente"), true); 

            if($tipo_reporte==1){
                    $data['header'] = $rows;
                    $data['titulo'] = 'Reporte de Escalafón de docente';
                    $data['user']=$this->tank_auth->get_user_id();
                    $html= $this->load->view('registro_academico/consultas/escalafon_export', $data, true);
                    $this->pdf->makePdf($html,'L','Reporte de Escalafón de docente','Letter');

            }else if($tipo_reporte == 2){
                    $filename = 'rpt_escalafon'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Reporte de Escalafón de docente';
                    $data['filename'] = $filename;
                    $data['excel'] = 1;
                    $html = $this->load->view('registro_academico/consultas/escalafon_export',$data,true);
                    echo $html;
                    die();
            }else{
                echo json_encode($html);
                die();
            }
        }else{

            $ctf_option = $this->gsatelite->get_dropdown('ctf_categoria_escalafon', '{ctf_nombre}','', array('ctf_estado'=>1), null, '', 'ctf_id', true);
            $data['categoria'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $ctf_option);

            //$sucursal_str = $this->get_sucursales();                          
            //$this->db->where('dct_id_suc in('.$sucursal_str.')',NULL);
            $this->db->join('emp_empleado', 'dct_id_emp=emp_id', 'inner');
            $docente = $this->gsatelite->get_tabla('dct_docente', array('dct_estado'=>1));

            $opt_docente = '<option value=""></option>';

            if(count($docente)>0){
                foreach ($docente as $dct) {
                    $opt_docente .= '<option value="'.$dct['dct_id'].'">'.$dct['emp_nombre'].' '.$dct['emp_apellido'].'</option>';
                }
            }

            $data['docente'] = $opt_docente;

            $data["titulo_personal"] ="Escalafón docente";
            $this->_cargarvista($data);
        }  
    }

    function cargar_docentesxcat_escalafon(){
        satelite_validar(true);

        $categoria = $this->input->post('categoria');

        $where = array();

        if($categoria!=null){
            $where['tbe_id_ctf'] = $categoria;
        }

        $docentes = $this->registro_academico_model->get_docentes_escalafon($where, 'inner');
        
        if(count($docentes)>0){
            $opt_docente = '<option value=""></option>';
            foreach ($docentes as $dct) {
                $opt_docente .= '<option value="'.$dct['dct_id'].'">'.$dct['emp_nombre'].' '.$dct['emp_apellido'].'</option>';
            }
        }else{
                       $this->db->join('emp_empleado', 'dct_id_emp=emp_id', 'inner');
            $docente = $this->gsatelite->get_tabla('dct_docente', array('dct_estado'=>1));

            $opt_docente = '<option value=""></option>';

            if(count($docente)>0){
                foreach ($docente as $dct) {
                    $opt_docente .= '<option value="'.$dct['dct_id'].'">'.$dct['emp_nombre'].' '.$dct['emp_apellido'].'</option>';
                }
            }
        }
        
        echo $opt_docente;
    }


    /**
     * @author Edith Herrera - Grupo Satélite
     * @since 2018-02-03
     * @param Ninguno
     * @return Obtener Reporte de historial del alumno.
     */
     function historial_alumno(){
        satelite_validar();
        if($_POST){
            $alumno = $this->input->post('slcAlumno');
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = array();
            if ($alumno != '') {
                $where['alm_id'] = $alumno;

                $data['fecha'] = $this->get_fecha_alumno($alumno);
            }

            $sucursal_str = $this->get_sucursales();                          
            $where['gra_id_suc in('.$sucursal_str.')'] = NULL;
            $where['alm_id_suc in('.$sucursal_str.')'] = NULL;
            $where['alm_id_suc in('.$sucursal_str.')'] = NULL;

            $data['registros'] = $registro= $this->registro_academico_model->get_registro_inscripcion($where);
            $html=$this->load->view('registro_academico/consultas/detalle_historial', $data, true);
            $rows = $this->load->view('reporte/header', array('titulo' => "Historial de alumno"), true); 

            if($tipo_reporte==1){
                    $data['header'] = $rows;
                    $data['titulo'] = 'Reporte de Historial de alumno';
                    $data['user']=$this->tank_auth->get_user_id();
                    $html= $this->load->view('registro_academico/consultas/historial_export', $data, true);
                    $this->pdf->makePdf($html,'L','Reporte de Historial de alumno','Letter');
            }else if($tipo_reporte == 2){
                    $filename = 'rpt_historial'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Reporte de Historial de alumno';
                    $data['filename'] = $filename;
                    $data['excel'] = 1;
                    $html = $this->load->view('registro_academico/consultas/historial_export',$data,true);
                    echo $html;
                    die();
            }else{
                echo json_encode($html);
                die();
            }
        }else{

            $ctf_option = $this->gsatelite->get_dropdown('ctf_categoria_escalafon', '{ctf_nombre}','', array('ctf_estado'=>1), null, '', 'ctf_id', true);
            $data['categoria'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $ctf_option);

            //$sucursal_str = $this->get_sucursales();                          
            //$this->db->where('dct_id_suc in('.$sucursal_str.')',NULL);
            $this->db->join('emp_empleado', 'dct_id_emp=emp_id', 'inner');
            $docente = $this->gsatelite->get_tabla('dct_docente', array('dct_estado'=>1));

            $opt_docente = '<option value=""></option>';

            if(count($docente)>0){
                foreach ($docente as $dct) {
                    $opt_docente .= '<option value="'.$dct['dct_id'].'">'.$dct['emp_nombre'].' '.$dct['emp_apellido'].'</option>';
                }
            }

            $data['docente'] = $opt_docente;

            $data["titulo_personal"] ="Historial de alumno";
            $this->_cargarvista($data);
        }  
    }

    function get_fecha_alumno($id_alm=null){
        //satelite_validar(true);
        $alumno = ($id_alm!=null)?$id_alm:$this->input->post('alumno');

        $reg_alm = $this->gsatelite->get_registro('alm_alumno', array('alm_id'=>$alumno));
        
        if($reg_alm->alm_estado==1){
            $fecha = formatear_fecha('d-m-Y', $reg_alm->alm_fecha_crea);
        }else{
           $fecha = formatear_fecha('d-m-Y', $reg_alm->alm_fecha_mod);
        }

        if($id_alm!=null){
            return $fecha;
        }else{
            echo $fecha;
        }
    }


    /**
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-02-06
     * @return Constancias.
     */
    public function constancias(){
        satelite_validar();
        $data['permisos']  = $this->gsatelite->get_permisos_opcion();

        //$sucursal_str = $this->get_sucursales();                          
        //$this->db->where('pyc_id_suc in('.$sucursal_str.')',NULL);
        $this->db->join('ard_area_academica', 'pyc_id_ard=ard_id', 'left');
        $proyecciones = $this->gsatelite->get_tabla('pyc_proyeccion', array('pyc_estado'=>1));

        $opt_pyc = '<option value=""></option>';
        if(count($proyecciones)>0){
            foreach ($proyecciones as $pyc) {
                $opt_pyc .= '<option value="'.$pyc['pyc_id'].'"  data-area="'.$pyc['ard_nombre'].'">'.$pyc['pyc_nombre'].'</option>';
            }
        }
        $data['proyeccion'] = $opt_pyc;
        $data['titulo_personal']="Constancias";
        $this->_cargarvista($data);
    }

    public function get_nivelxproyeccion(){
        satelite_validar(true);
        $id_pyc = $this->input->post('proyeccion');

        $where = array();
        if($id_pyc!=''){
            $where['pyc_id'] = $id_pyc; 
        }
        //$sucursal_str = $this->get_sucursales();        
        //$where['pyc_id_suc in('.$sucursal_str.')'] = NULL;
        //$where['gra_id_suc in('.$sucursal_str.')'] = NULL;
        //$where['alm_id_suc in('.$sucursal_str.')'] = NULL;
        $niveles = $this->registro_academico_model->get_info_alummno_cons($where, 'mod_id');
       
        $opt_nivel = '<option value=""></option>';
        if(count($niveles)>0){
            foreach ($niveles as $mod) {
                $opt_nivel .= '<option value="'.$mod['mod_id'].'">'.$mod['mod_nombre'].'</option>';
            }
        } 

        echo $opt_nivel;
    }

    public function get_alumnoxnivel(){
        satelite_validar(true);
        $id_pyc = $this->input->post('proyeccion');
        $id_mod = $this->input->post('nivel');

        $where = array();
        if($id_pyc!=''){
            $where['pyc_id'] = $id_pyc; 
        }

        if($id_mod!=''){
            $where['mod_id'] = $id_mod; 
        }

        $alumnos = $this->registro_academico_model->get_info_alummno_cons($where, 'alm_id');

        $opt_alumno = '<option value="" selected="selected"></option>';
        if(count($alumnos)>0){
            foreach ($alumnos as $alm) {
                $opt_alumno .= '<option value="'.$alm['alm_id'].'">'.$alm['alm_nombre'].' '.$alm['alm_apellido'].'</option>';
            }
        } 
        echo $opt_alumno;
    }

    public function get_tipo_constancia(){
        satelite_validar(true);
        $id_frm = $this->input->post('formato');

        $where = array();
        if($id_frm!=''){
            $this->db->where('frc_tipo', $id_frm); 
        }

        $formatos = $this->gsatelite->get_dropdown('frc_formato_constancia', '{frc_nombre}','', array('frc_estado'=>1), null, '', 'frc_id', true);
        $constancias = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $formatos);
        
        echo $constancias;
    }

    /**
     * @author Edith Herrera
     * @since  06-12-2017
     * @return Consulta de promedios finales.
    * */
    public function promedios_finales() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        if ($_POST) {
            $post_array = $_POST;
            $area = (isset($post_array['area']))?$post_array['area']:null;
            $proyeccion = ($post_array['filtro_proyeccion'])?$post_array['filtro_proyeccion']:$post_array['proyeccion'];
            $lugar = ($post_array['filtro_lugar'])?$post_array['filtro_lugar']:$post_array['lugar'];
            $tipo_reporte = ($post_array['tipo_reporte'])?$post_array['tipo_reporte']:null;

            $sucursal_str = $this->get_sucursales();                          
            if ($proyeccion > 0) {
               $this->db->where_in('pyc_id', $proyeccion);
            }

            $this->db->where('gra_id_suc in('.$sucursal_str.')',NULL);
            $this->db->where('alm_id_suc in('.$sucursal_str.')',NULL);
            $alumnos = $this->registro_academico_model->get_promedios_finales(null, $lugar);
            $data['alumnos'] = $alumnos;

            ////////////////////////////////// Configuración de decimales ////////////////////////////////////////
            $decimales = json_decode($this->gsatelite->get_parametro("RA_DECIMALES"),true);
            $data['cant_decimales'] = (isset($decimales['decimales'])>0)?$decimales['decimales']:2; // Cantidad de decimales a mostrar en las notas.
            $data['min_aproxima'] = (isset($decimales['min_aproxima'])>0)?$decimales['min_aproxima']:0; // Cantidad mínima para aproximar promedios.
            $data['max_aproxima'] = (isset($decimales['max_aproxima'])>0)?$decimales['max_aproxima']:0; // Cantidad máxima para aproximar promedios.

            $detalle = $this->load->view('registro_academico/consultas/detalle_promedio', $data, true);

            if($tipo_reporte=='pdf'){
                    $data['titulo'] = 'Promedios finales';

                    $data['user']=$this->tank_auth->get_user_id();
                    $html=$this->load->view('reporte/header', array('titulo' => "Promedios finales"), true);
                    $html.= $this->load->view('registro_academico/consultas/promedios_export', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Promedios finales'.date('dmY');

                    $this->pdf->makePdf($html,'L','Promedios finales','Letter');
            }else if($tipo_reporte == 'excel'){
           
                    $filename = 'rpt_promedios_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Promedios finales';
                    $data['filename'] = $filename;
                    $data['excel'] = 1;
                    $html = $this->load->view('registro_academico/consultas/promedios_export',$data,true);
                    echo $html;
                    die();
            }else{
                 echo $detalle;
            }
        } else {
            $select = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1), null, '', 'ard_id', true);
            $data["areas"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
            
            $data['titulo_personal'] = "Promedios finales";
            $this->_cargarvista($data);
        }

    }

    public function imprimir_constancia(){
        $this->load->library('EnLetras');
        $proyeccion = $this->input->post('slcProyeccion');
        $nivel = $this->input->post('slcNivel');
        $alumno =$this->input->post('slcAlumno');
        $tipo_formato = $this->input->post('slcTipoForm');
        $tipo_constancia = $this->input->post('slcTipoCons');
        $where = $where2 = $where3 = array();
        if($proyeccion > 0){
            $where['pyc_id'] = $proyeccion; 
            $where2['pyc_id'] = $proyeccion; 
            $where3['pyc_id'] = $proyeccion; 
        }
        if($nivel > 0){ 
            $where['mod_id'] = $nivel; 
            $where2['mod_id'] = $nivel; 
        }
        if($alumno > 0){ 
            $where['alm_id'] = $alumno; 
            $where2['alm_id'] = $alumno; 
            $where2['lxa_id_alm'] = $alumno; 
            $where3['alm_id'] = $alumno; 
        }
        // Inforrmación general del alumno
        $info = $this->registro_academico_model->get_info_alummno_cons($where, 'alm_id');
        $otra_info = $this->registro_academico_model->get_info_extra_cons($where2);//agregao sep/19 by R.E.
        // Formato de constancia a imprimir
        if($tipo_formato > 0){ $this->db->where('frc_tipo', $tipo_formato); }
        if($tipo_constancia > 0){ $this->db->where('frc_id', $tipo_constancia); }
        $formato = $this->gsatelite->get_campo('frc_formato_constancia', 'frc_configuraciones_formato', array('frc_estado'=>1));
        // Área padre (coordinación o unidad)
        $datos = $info[0];
        $area_padre = $this->registro_academico_model->get_area_padre(array('h.ard_id'=>$datos['ard_id']));
        if(count($area_padre) > 0){
            $area = ($area_padre[0]['padre']!='') ? $area_padre[0]['padre'] : ' - ';
        }else{
            $area = ($datos['ard_nombre']!='') ? $datos['ard_nombre'] : ' - ';
        }
        // NIE del alumno
        // $nie_par = $this->gsatelite->get_parametro('SYS_ID_NIE');
        // $documento = $this->gsatelite->get_registro('dca_documento_alumno', array('dca_id_alm'=>$datos['alm_id'], 'dca_id_tde'=>$nie_par));        
        if($datos['alm_codigo_nie'] != ''){
            $nie = $datos['alm_codigo_nie'];
        }else{
            $nie = ' - ';
        }
        //Cantidad de materias 
        $this->db->where('pen_id_asociado IS NOT NULL', null, FALSE);
        $asociados = $this->gsatelite->get_tabla('pen_pensum', array('pen_id_ard'=>$datos['ard_id']));
        $arr_asoc = array();
        if(count($asociados)>0){
            foreach ($asociados as $asoc) {
               $arr_asoc[] = $asoc['pen_id_asociado'];
            }
        }
        //Duración
        if($datos['gra_fecha_inicio']!='' && $datos['gra_fecha_fin']!=''){
            $fecha1 = new DateTime($datos['gra_fecha_inicio']);
            $fecha2 = new DateTime($datos['gra_fecha_fin']);
        }else{
            $fecha1 = new DateTime($datos['pyc_fecha_inicio']);
            $fecha2 = new DateTime($datos['pyc_fecha_fin']);
        }       
        $diff = $fecha1->diff($fecha2);
        $duracion = $diff->days;
        
        // Monto del nivel 
        if($datos['lxp_id_def']!=''){
            $total = (double)($datos['def_subtotal'] + $datos['def_impuesto'] - $datos['def_descuento'] - $datos['def_retencion']);
            $letra = $this->enletras->num2letras($total);
            $cad    = strpos($total, ".");
            if ($cad == false) { $total = number_format($total,2,'.',''); }            
            $decimales = explode(".",$total);
            $c = count($decimales);
            for ($i = 0; $i < 2; $i++) { 
                $num = $decimales[1];
                $total_decimales = strlen($num);
                if ($total_decimales == 1) {
                    $num .= 0;
                }
            }
            $monto = '<b>'.$letra . " con " . number_format($num, 0) . "/100 Dolares ($".$total.')</b>';
        }else{
            $monto = ' - ';
        }

                if(count($arr_asoc)>0){
                    $this->db->where_not_in('pen_id', $arr_asoc);
                }
        $cantidad = $this->gsatelite->count('pen_pensum', array('pen_id_ard'=>$datos['ard_id']));

        // Detalle de notas de alumno
        $notas = $this->registro_academico_model->obtener_notas_alumnos(array('noa_id_lxp'=>$datos['lxp_id']));
        $notas2 = $this->registro_academico_model->get_notas_alumnos2($where3);
        $notas_todas = array_column($notas2, 'noa_nota');
        $nota_prom_fin = array_sum($notas_todas) / count($notas_todas);
        $mes =  $this->enletras->mes_anio(date('Y-m-d'), 3); // Mes en letras
        $datos_emp = $this->gsatelite->get_tabla('emr_empresa', array('emr_id'=>$this->tank_auth->get_empresa_id()));       
        $data= array(
            'alumno'=>$datos['alm_nombre'].' '.$datos['alm_apellido'],
            'apellido'=>$datos['alm_apellido'],
            'nie_alumno'=>$nie,
            'area_padre'=>$area,
            'area'=>$datos['ard_nombre'],
            'nivel'=>$datos['mod_nombre'],
            'frecuencia'=>($datos['frh_descripcion']!='')?$datos['frh_descripcion']:' - ',
            'inicio'=>$datos['inicio'],
            'fin'=>$datos['fin'],
            'num_mod'=>$cantidad,
            'duracion'=>$duracion,
            'detalle_notas'=>$notas,
            'det_notas2'=>$notas2,
            'prom_final'=>$nota_prom_fin,
            'dia'=>$this->enletras->ValorEnLetras(date('d')),
            'mes'=>$mes,
            'anio'=>$this->enletras->ValorEnLetras(date('Y')),
            'monto'=>$monto,
            'monto_num'=>$total,
            'info' => $info,
            'info_extra' => $otra_info,
            'empresa_info' => $datos_emp,
            'formato'=> $formato,
            'tipo_formato'=> $tipo_formato,
            'tipo_constancia'=> $tipo_constancia
        );
        $html = $this->load->view('registro_academico/consultas/constancias_curso', $data);       
    }

    /**
     * @author Edith Herrera
     * @since  2018-03-07
     * @return Reporte de alumnos retirados.
     **/
    function reporte_alumnos_retiro(){
        satelite_validar();
        $proyeccion=$this->input->post('proyeccion');
        $nivel=$this->input->post('nivel');

        if($this->input->post()){
            $where = array('gra_id_pyc'=>$proyeccion);
            $order_by = 'gra_nombre ASC';
            if($nivel>0){
                $where['mod_id'] = $nivel;
            }
            //$sucursal_str   = $this->get_sucursales();                          
            //$where['pyc_id_suc in('.$sucursal_str.')'] = NULL;
            if ($sucursal_str) {
                $where['alm_alumno in('.$sucursal_str.')'] = NULL;
            }
            $data['causas'] = $this->registro_academico_model->reporte_causas($where, null); 

            $html=$this->load->view('registro_academico/consultas/detalle_alumnos_retiro', $data, true);
            echo json_encode($html);
            die();
        }

        
        $sucursal_str = $this->get_sucursales();                          
        $this->db->where('pyc_id_suc in('.$sucursal_str.')',NULL);
        $this->db->join('ard_area_academica', 'pyc_id_ard=ard_id');
        $pyc = $this->gsatelite->get_tabla('pyc_proyeccion', array('pyc_estado'=>1));

        $option = '<option value=""></option>';
        if(count($pyc)>0){
            foreach ($pyc as $key) {
                $option .= '<option value="'.$key['pyc_id'].'" data-ard="'.$key['ard_nombre'].'" >'.$key['pyc_nombre'].'</option>';
            }
        }
        $data['proyeccion'] = $option;

        $data["titulo_personal"] ="Alumnos retirados";
        $this->_cargarvista($data);
    }


     public function reporte_pdf_retiros($id)
        {
            $proyeccion=$this->input->post('slcProyeccion');
            $nivel=$this->input->post('slcNivel');

            
            $where = array('gra_id_pyc'=>$proyeccion);
            $order_by = 'gra_nombre ASC';
            if($nivel>0){
                    $where['mod_id'] = $nivel;
            }
            $data['causas'] = $causas = $this->registro_academico_model->reporte_causas($where, $order_by); 
               
            
            
            $rows=$this->load->view('reporte/header', array('titulo' => "Alumnos retirados"), true);
            //$grupo_info=$this->registro_academico_model->get_info_grupo($grupo);

            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header']     = $rows;
            $data['filename']         = $filename;

            if ($id == 1) {
                $html.= $this->load->view('registro_academico/consultas/reporte_retirados_export', $data, true);
                $this->pdf->makePDF($html, 'L');
                //$this->pdf->makePDF('registro_academico/consultas/reporte_notas_modulos', $data, NULL, 'L');
            }else{
                $data['excel']=1;
                $this->load->view('registro_academico/consultas/reporte_retirados_export', $data);
            } 
    }



    /**
     * Descripción:
     * Función obtener un informe de notas
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-05-16
     * @param  Ninguno
     * @return Informe de notas 
     */
    public function informe_notas() {
        satelite_validar();

        if ($this->input->post()) {
            $tipo_reporte   = ($this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';

            if ($tipo_reporte != null) {
                $proyeccion = ($this->input->post('filtro_proyeccion') > 0) ? $this->input->post('filtro_proyeccion') : null;
                $grado      = ($this->input->post('filtro_grado') > 0) ? $this->input->post('filtro_grado') : null;
                $alumnos    = ($this->input->post('filtro_alumnos') > 0) ? $this->input->post('filtro_alumnos') : null;
            } else {
                $proyeccion = $this->input->post('proyeccion');
                $grado      = $this->input->post('grado');
                $alumnos    = $this->input->post('alumnos'); // multiselect
            }

            /******************************** CONSULTA DE MATERIAS POR ALUMNO *******************************************/
            $where              = array('pyc_id'=>$proyeccion, 'gra_id_grd'=>$grado);            
            $sucursal_str       = $this->get_sucursales();                          
            $where['pyc_id_suc in('.$sucursal_str.')'] = NULL;
           
            if($alumnos != null && $alumnos != 'null' && count($alumnos)>0){ $this->db->where_in('alm_id', $alumnos); }
            $data['lstAlumnos'] = $lstAlumnos = $this->registro_academico_model->get_AlumnosxGruposAcademicos($where, null, 'alm_id', 'alm_id');
                      
           if($alumnos != null && $alumnos != 'null' && count($alumnos)>0){ $this->db->where_in('alm_id', $alumnos); }
            $data['materias']   = $materias = $this->registro_academico_model->get_AlumnosxGruposAcademicos($where, null, 'mod_id', 'mod_id');


            $evaluaciones       = $this->registro_academico_model->get_periodos_informe(array('evm_id_pyc'=>$materias[0]['pyc_id'], 'evm_id_pen'=>$materias[0]['pen_id']), 'pev_id');

            $data['periodos']   = $evaluaciones;

            /************************************************************************************************************* */
            $data['header']    = $this->load->view('reporte/header',  array('titulo' => 'Informe de notas'), true);
           
            $data['tipo_reporte'] = $tipo_reporte;
            if ($tipo_reporte != '') {
                switch ($tipo_reporte) {
                    case 'pdf':
                        $data['titulo'] = 'Informe de notas';
                       
                        $html = $this->load->view('registro_academico/consultas/export_informe_notas', $data, true);
                       
                        $this->pdf->makePdf($html, 'L', 'conteos', 'A4');
                        break;
                    case 'excel':
                        $filename = 'rpt_informe_notas' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                        $data['titulo'] = ' informe de notas';
                        $data['filename'] = $filename;
                        $data['excel'] = 1;

                        $html = $this->load->view('registro_academico/consultas/export_informe_notas', $data, true);
                        echo $html;
                        break;
                }
            } else {
                $data['proyeccion'] = $proyeccion;
                $data['grado'] = $grado;
                $data['alumnos'] = $alumnos;
                $html = $this->load->view('registro_academico/consultas/detalle_informe_notas', $data, true);
                echo json_encode(array('resultado' => $html, 'proyeccion'=>$proyeccion, 'grado'=>$grado, 'alumnos'=>$alumnos));
            }
        } else {
            $data["area"] = $this->gsatelite->get_tabla('ard_area_academica');

            //$sucursal_str = $this->get_sucursales();                          
            //$this->db->where('pyc_id_suc in('.$sucursal_str.')',NULL);
            $this->db->join('ard_area_academica', 'pyc_id_ard=ard_id','left');
            $proyeccion = $this->gsatelite->get_tabla('pyc_proyeccion');

            $pyc_drop = '<option value=""></option>';
            foreach ($proyeccion as $key ) {
                $pyc_drop .= '<option value="'.$key['pyc_id'].'" data-ard_id="'.$key['pyc_id_ard'].'" data-area="'.$key['ard_nombre'].'">'.$key['pyc_nombre'].'</option>';
            }
                
            $data["proyeccion"] = $pyc_drop;
            $data["titulo_personal"] ="Informe de notas";

            $this->_cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función obtener dropdown de grados según el área 
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-05-17
     * @param  Ninguno
     * @return Dropdown de grados
     */
    public function mostrar_grados_area($value='')
    {
        satelite_validar(true);
        
        $area= $this->input->post('area');
        $proyeccion= $this->input->post('proyeccion');

        $grados = $this->registro_academico_model->get_grados_pyc(array('grd_id_ard'=>$area, 'pyc_id'=>$proyeccion));

        $drop_grados = '<option value=""></option>';
        if(count($grados)>0){
            foreach ($grados as $grd) {
                $drop_grados .= '<option value="'.$grd['grd_id'].'">'.$grd['grd_nombre'].'</option>';
            }
        }
        echo $drop_grados;
    }


   /* public function cargar_alumnos_grado(){
        satelite_validar(true);

        $area = $this->input->post('area');
        $grado = ($this->input->post('grado')!=null)?$this->input->post('grado'):null;
        die(print_r($grado));
        $alumnos = $this->registro_academico_model->get_AlumnosxGruposAcademicos(array('lxa_id_ard'=>$area, 'lxp_id_gra'=>$grupo, 'lxp_estado'=>1),1);
        die(print_r($this->db->last_query()));
        
        echo json_encode($alumnos);
    }*/

    /**
     * Descripción:
     * Función para imprimir el talonario de cursos libres
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-05-27
     * @param  id de inscripción (lxp)
     * @return Impresión de talonario para cursos libres - en certificado de notas
     */
    function imprimir_talonario($lxp=null){
        satelite_validar();
        $this->load->library('EnLetras');

        $area=$this->input->post('hdnArea');
        $grupo= $this->input->post('grupo');
        $modulo= $this->input->post('modulo');
        $alumnos= $this->input->post('slcAlumnos');

        if($modulo>0 && $grupo>0 ){
            $where = array('lxp_condicion !='=>(4),'ard_id'=>$area, 'mod_id'=>$modulo, 'gra_id'=> $grupo);
        }elseif($modulo>0){
            $where = array('lxp_condicion !='=>(4),'ard_id'=>$area, 'mod_id'=>$modulo);
        }elseif ($grupo>0) {
            $where = array('lxp_condicion !='=>(4),'ard_id'=>$area, 'gra_id'=> $grupo);
        }else{
            $where = array('lxp_condicion !='=>(4),'ard_id'=>$area);
        }
        $datos_grupos=$this->registro_academico_model->obtener_info_grupos_certificados($where, $alumnos);
       
        $mat=$this->registro_academico_model->get_modulo_siguiente_certificado();   
          
                           $this->db->where('pen_id_ard',$area);
        $data['next_mat'] = $this->registro_academico_model->get_materia_siguiente();

        $cant_notas= $this->gsatelite->get_tabla('pod_ponderacion'); 
        $data['cant_th'] = $cant_th=count($cant_notas);
    
        $data['datos'] = $datos_grupos;
        $data['materia'] = $mat;

        $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
        $this->pdf->setPrintFooter(false);

        ////////////////////////////////// Configuración NPE ////////////////////////////////////////
            $cod = 0;
            $npe = json_decode($this->gsatelite->get_parametro("RA_NPE"),true);
            if(isset($npe['cuenta_cod'])){ $cod = $npe['cuenta_cod']; }
            $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

            $data['cuenta'] = $codigo;
            $data['parejas'] = (isset($npe['parejas'])>0)?$npe['parejas']:0;

        ////////////////////////////////// Configuración NPE ////////////////////////////////////////
            $codigo = json_decode($this->gsatelite->get_parametro("RA_CODIGO_BARRA"),true);
            $data['localizacion'] = (isset($codigo['localizacion'])>0)?$codigo['localizacion']:0;
            $data['banco'] = (isset($codigo['cuenta_banco'])>0)?$codigo['cuenta_banco']:0;
            $data['codigo2'] = (isset($codigo['codigo2'])>0)?$codigo['codigo2']:0; 
            $data['codigo3'] = (isset($codigo['codigo3'])>0)?$codigo['codigo3']:0; 
            $data['codigo4'] = (isset($codigo['codigo4'])>0)?$codigo['codigo4']:0;
        
        $cert = $this->load->view('registro_academico/consultas/talonario_cuota.php', $data, true);
        $this->pdf->makePDFcertificados($cert);
        $this->pdf->SetMargins(0,0,0);
    }

    /**
     * Descripción:
     * Función para imprimir el talonario de bachillerato
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-05-29
     * @param  id de inscripción (lxp)
     * @return Impresión de talonario para bachillerato - en alumnos por área y grupo
     */
    function imprimir_talonario_bach($lxp=null){
        satelite_validar();
        $this->load->library('EnLetras');

        $proyeccion = $this->input->post('slcProyeccion');
        $area=$this->input->post('txtarea');
        $grupo= $this->input->post('slcGrupo');
        
       if ($grupo>0) {
            $where = array('lxp_condicion !='=>(4),'ard_id'=>$area, 'gra_id'=> $grupo);
        }else{
            $where = array('lxp_condicion !='=>(4),'ard_id'=>$area);
        }
        $data['datos'] = $alumnos = $this->registro_academico_model->alumnosxarea_grupo($where);
        
        $data['cargos'] = $cargos = $this->registro_academico_model->get_cargos_alumno(array('clg_id_gxa'=>$alumnos[0]['gxa_id']));
       
        $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
        $this->pdf->setPrintFooter(false);

        ////////////////////////////////// Configuración NPE ////////////////////////////////////////
            $cod = 0;
            $npe = json_decode($this->gsatelite->get_parametro("RA_NPE"),true);
            if(isset($npe['cuenta_cod'])){ $cod = $npe['cuenta_cod']; }
            $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

            $data['cuenta'] = $codigo;
            $data['parejas'] = (isset($npe['parejas'])>0)?$npe['parejas']:0;

        ////////////////////////////////// Configuración NPE ////////////////////////////////////////
            $codigo = json_decode($this->gsatelite->get_parametro("RA_CODIGO_BARRA"),true);
            $data['localizacion'] = (isset($codigo['localizacion'])>0)?$codigo['localizacion']:0;
            $data['banco'] = (isset($codigo['cuenta_banco'])>0)?$codigo['cuenta_banco']:0;
            $data['codigo2'] = (isset($codigo['codigo2'])>0)?$codigo['codigo2']:0; 
            $data['codigo3'] = (isset($codigo['codigo3'])>0)?$codigo['codigo3']:0; 
            $data['codigo4'] = (isset($codigo['codigo4'])>0)?$codigo['codigo4']:0;
        
        $cert = $this->load->view('registro_academico/consultas/talonario_cuota_bach.php', $data, true);
        $this->pdf->makePDFcertificados($cert);
        $this->pdf->SetMargins(0,0,0);
    }

    /**
     * Descripción:
     * Función para cargar docente por grado
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-11-06
     * @param  Ninguno
     * @return El docente 
     */
    public function ajax_cargar_docentexgrado() {
        if($this->input->post()) {
            $grupo = $this->input->post("grupo");
            $obtener_grupo   = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id' => $grupo));
            $this->db->join('emp_empleado', 'emp_id = dct_id_emp');
            $obtener_docente = $this->gsatelite->get_tabla('dct_docente', array('dct_id' => $obtener_grupo[0]['gra_id_dct']));
            echo json_encode(array('docente' => $obtener_docente[0]['emp_nombre'].' '.$obtener_docente[0]['emp_apellido']));
            die();
        }
    }

    /**
     * Descripción:
     * Función para el reporte de porque medio se entero
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-12-05
     * @param  Ninguno
     * @return El reporte
     */    
    public function reporte_medio_se_entero($flag = null) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

         if($this->input->post()) {
            // print_r($this->input->post());die();
            // Variables obtenidas de POST
            if ($flag) {
                $slcMedio    = $this->input->post('medio_entero');
                $fechaInicio = $this->input->post('fechaInicio');
                $fechaFin    = $this->input->post('fechaFin');
                $exportar    = $this->input->post('exportar');
            } else {
                $slcMedio    = $this->input->post('filtro_medios_entero');
                $fechaInicio = $this->input->post('filtro_fecha_inicio');
                $fechaFin    = $this->input->post('filtro_fecha_fin');
                $exportar    = $this->input->post('exportar');
            }
            // Tipo de reporte que se mostrara
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where        = array();
            // Filtro de tipo de medio por el cual se entero
            $medios = '';
            if (is_array($slcMedio) && count($slcMedio)>0) {
                foreach ($slcMedio as $key => $value) {
                    $medios .= $value.",";
                }

                $medios = substr($medios, 0, -1);
                $where['mxl_id_tmc IN ('.$medios.')'] = null;
            } else {
                $medios = $slcMedio;
                $where['mxl_id_tmc IN ('.$slcMedio.')'] = null;
            }
            // Filtro de fecha
            if (trim($fechaInicio) != "" && trim($fechaFin) != "") {
                $where['DATE(mxl_fecha_creacion) BETWEEN "'.$fechaInicio.'" AND "'.$fechaFin.'"'] = null;
            }
            // Permisos
            $data['permisos'] = $permisos;
            // Consulta para obtener los registros del alumnos
            //$sucursal_str = $this->get_sucursales();                          
            //$where['alm_id_suc in('.$sucursal_str.')'] = NULL;
            $data['detalles'] = $this->registro_academico_model->get_reporte_medio_se_entero($where); //print_r($this->db->last_query());die();
            // Nombre del archivo
            $filename             = 'reporte_medio_se_entero' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']     = $filename;
            $data['tipo_reporte'] = $tipo_reporte;
            // Titulo del documento
            $titulo_reporte = 'REPORTE DE POR QUE MEDIO SE ENTERO';
            // Colocar datos para mostrar en el pdf o excel
            $medios_entero         = $this->gsatelite->get_tabla('tmc_tipo_medio', array('tmc_id IN ('.$medios.')' => null));
            $medios_entero         = array_column($medios_entero, 'tmc_nombre');
            $data['medios_entero'] = implode(', ', $medios_entero);
            $data['fechaInicio']   = $fechaInicio;
            $data['fechaFin']      = $fechaFin;
            // Cabecera del reporte
            $header = $this->load->view('reporte/header', array('titulo' => $titulo_reporte, 'solotitulo' => true), true);
            // Archivo para mostrar el contenido
            $detalle = $this->load->view('registro_academico/consultas/medio_se_entero_export', $data, true);
            
            if ($flag) {
                // HTML
                echo ($detalle);
                die();
            } else {
                // PDF
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = '¿Por qué medio se enteró de nuestro programa?';
                    $data['pdf'] = 1;
                    $GLOBALS['nombre_reporte'] = 'reporte_medio_se_entero' . date('dmY');
                    $html = $this->load->view('registro_academico/consultas/medio_se_entero_export', $data, true);
                    $reporte = $header.$html;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_medio_se_entero', 'Letter');
                // EXCEL
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_medio_se_entero_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = '¿Por qué medio se enteró de nuestro programa?';
                    $data['excel'] = 1;
                    $data['filename'] = $filename;
                    $html = $this->load->view('registro_academico/consultas/medio_se_entero_export', $data, true);
                    $reporte = $html;
                    echo $reporte;
                }
            }

        } else {
            // Se obtiene los medios por lo cual se entero del  programa
            $tipo_medio_drop = $this->gsatelite->get_dropdown('tmc_tipo_medio', '{tmc_nombre}', '', array('tmc_estado' => 1), null, '', 'tmc_id', true);
            $data['tipo_medio'] = str_replace('<option value="0">Seleccione</option>', '', $tipo_medio_drop);
            // Titulo de la vista
            $data['titulo_personal']="Reporte de Por Qué Medio se Enteró";
            $this->_cargarvista($data);
        }
        
    }

    /**
     * Descripción:
     * Función obtener un informe Cursos por edades
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2018-08-23
     * @param  edades
     * @return informacion de cursos
     */
    public function cursos_edades() {
        satelite_validar();

        if ($_POST) {

            $id_mod = $this->input->post('modulo');
            $area = $this->input->post('area');

            $where = array('ard_id'=>$area, 'mod_id'=>$id_mod);

            
            //$sucursal_str = $this->get_sucursales();                          
            //$this->db->where('gra_id_suc in('.$sucursal_str.')',NULL);
            $grupos=$this->registro_academico_model->grupos_modulo($where);            

            $data['grupos'] = $grupos;
            $html=$this->load->view('registro_academico/consultas/grid_cursos_edades', $data, true);
            $regresar["html"] = $html;

            echo json_encode($regresar);
            die();
        } else {
                // $data["areas_academicas"] = $this->gsatelite->get_tabla('ard_area_academica');
                // $data["titulo_personal"] ="Reporte de grupos por nivel";

            $areas_academicas = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', '','', '', 'ard_id', true);
            $areas_academicas = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $areas_academicas);
             $data['areas_academicas']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $areas_academicas);
                
            //$data["proyeccion"] = $pyc_drop;
            $data["titulo_personal"] ="Cursos por edades";

            $this->_cargarvista($data);
        }
    }

    public function reporte_grupos_xedades($id){

        $id_mod = $this->input->post('modulo');
        $area = $this->input->post('area');
        $where = array('ard_id'=>$area, 'mod_id'=>$id_mod);
        $data['grupos'] = $grupos = $this->registro_academico_model->grupos_modulo($where);
        
        foreach ($grupos as $key => $modulo) {
            $modulo=$modulo['Modulo'];
        }
            $data['grupo_nivel'] = (count($grupos)>0)? $grupos[0]['Nivel'] : "";
            $data['grupo_modulo'] = (count($grupos)>0)? $grupos[0]['Modulo'] : "";
            $rows=$this->load->view('reporte/header', array('titulo' => "Grupos por edades"), true);

        $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

        if ($id == 1) {
            $data['table_header']     = $rows;
            $data['filename']         = $filename;
            $this->pdf->reportePDF('registro_academico/consultas/reporte_grupos_xedades_pdf.php', $data, NULL, 'L');
        }else{
                $data['table_header']     = $rows;
            $data['filename']         = $filename;
            $this->load->view('registro_academico/consultas/reporte_grupos_xedades_exel', $data);
        }
    }  

    public function rpt_modalidad_estudio($flag=null){
        satelite_validar();
        if ($_POST) {
            $tipo  = $this->input->post('tipo');
            $grupo = $this->input->post('grupo_acad');
            $frecu = $this->input->post('frencuency');
            $alumn = $this->input->post('estudiante');
            $modal = $this->input->post('modalities');
            $where = array('lxp_estado' => 1);
            if ($grupo > 0) {
                $where['lxp_id_gra'] = $grupo;
            }
            if ($frecu > 0) {
                $where['gra_id_frh'] = $frecu;
            }
            if ($alumn > 0) {
                $where['lxa_id_alm'] = $alumn;
            }
            if (trim($modal) != "") {
                if ($modal > 0) {
                    $where['lxp_modalidad'] = 1;
                } else {
                    $where['(lxp_modalidad = 0 OR lxp_modalidad IS NULL)'] = null;
                }                
            }
            $registros = $this->registro_academico_model->modalidad_estudios($where);
            $html =  $this->load->view('registro_academico/consultas/grid_modalidad_estudios', array('registros' => $registros, 'tipo' => $tipo), true);
            if ($flag) {
                echo json_encode(array('html' => $html, 'filas' => count($registros)));
            } else {
                if ($tipo == 'exc') {
                    echo $html;
                } else {
                    $header = $this->load->view('reporte/header', array('titulo' => 'modalidad de estudio por alumno'), true);
                    $reporte = $header . $html;
                    $GLOBALS['nombre_reporte']  = "modalidad_estudio";
                    $this->pdf->makePdf($reporte, 'P', 'Reporte_modalidad_estudio_'.date('Ymd'), 'Letter');
                }                
            }            
        } else {
            $frecuencias = $this->gsatelite->get_dropdown('frh_frecuencia_horario', '{frh_nombre}', '', array('frh_estado' => 1), null, '', 'frh_id', true);
            $grupo_academico = $this->gsatelite->get_dropdown('gra_grupo_academico', '{gra_nombre}', '', array('gra_estado' => 1), null, '', 'gra_id', true);
            $data['frecuencias'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $frecuencias);
            $data['grupo_academico'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $grupo_academico);
            $data["titulo_personal"] = "Modalidad de Estudiante";
            $this->_cargarvista($data);
        }        
    }

    /**
     * Obtiene sucursales permitidas.      
     * @author Francisco Orozco
     * @since  07-10-2019         
     * @return string sucursales que tiene configuradas.
    **/
    function get_sucursales(){
        $usuario        = $this->tank_auth->get_user_id();    
        $sucurales_array= $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $usuario));
        $sucursales     = array_column($sucurales_array,'usc_id_suc');            
        $sucursal_str   = 0;
        if ( count($sucursales) > 0 ) {   
            $sucursal_str .= ','.implode(",", $sucursales);             
        }             
        return $sucursal_str;
    }

    function _cargarvista($data=0,$crud=0){   
        $this->load->view('vacia',$crud);   
        if($data!=0)
            $data=array_merge($data,$this->masterpage->getUsuario());
        else
            $data=$this->masterpage->getUsuario();      
        $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content',$data);
        $this->masterpage->show();
    }
} // End of class