<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Reportes extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('proyecto_model');
        $this->load->model('cotizaciones_model', 'cotModel');
        $this->load->model('consultas');
        $this->load->model('gsatelite');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
    }

    public function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    public function horas_extras() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('proyectos/reportes/horas_extras');
        $data['proveedores'] = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
        $data['titulo_personal'] = "Horas extras";
        cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * Reporte de Horas Extras (Detalla el listado de Horas Extras)
     * $flag 1 = Indica si el reporte es una consulta Ajax. Null = Impresión
     */
    function reporte_horas_extras($flag = null) {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = (isset($post_array['tipo_reporte']) && $post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : null;
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            $orden = null;
            $productos = null;
            if ($flag != null) {
                $orden = ($post_array['orden'] != '') ? $post_array['orden'] : null;
                $cliente = ($post_array['cliente'] != '') ? $post_array['cliente'] : null;
                $empleado = ($post_array['empleado'] != '') ? $post_array['empleado'] : null;
                $fecha_ini = ($post_array['fecha_ini'] != '') ? formatear_fecha('Y-m-d', $post_array['fecha_ini']) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? formatear_fecha('Y-m-d', $post_array['fecha_fin']) : null;
            } else {
                $orden = ($post_array['filtro_orden'] != '') ? $post_array['filtro_orden'] : null;
                $cliente = ($post_array['filtro_cliente'] != '') ? $post_array['filtro_cliente'] : null;
                $empleado = ($post_array['filtro_empleado'] != '') ? $post_array['filtro_empleado'] : null;
                $fecha_ini = ($post_array['filtro_fecha_inicio'] != '') ? formatear_fecha('Y-m-d', $post_array['filtro_fecha_inicio']) : null;
                $fecha_fin = ($post_array['filtro_fecha_fin'] != '') ? formatear_fecha('Y-m-d', $post_array['filtro_fecha_fin']) : null;
            }
            /*
             * Se aplican los filtros
             */
            $where = null;
            $data['orden'] = null;
            $data['fecha_inicio'] = null;
            $data['fecha_fin'] = null;
            $data['cliente'] = null;
            $data['empleado'] = null;
            if ($orden != null) {
                $where['hxe_id_ord'] = $orden;
                $data['orden'] = $this->proyecto_model->get_ordenes(array('ord_id' => $orden));
            }
            if ($empleado != null) {
                $where['hxe_id_emp'] = $empleado;
            }
            if ($cliente != null) {
                $where['ord_id_cli'] = $cliente;
            }
            if ($fecha_ini != null && $fecha_fin != null) {
                $where['DATE(hxe_fecha) >='] = $fecha_ini;
                $where['DATE(hxe_fecha) <='] = $fecha_fin;
                $data['fecha_inicio'] = formatear_fecha('d-m-Y', $fecha_ini);
                $data['fecha_fin'] = formatear_fecha('d-m-Y', $fecha_fin);
            }
            $data['reporte'] = $this->proyecto_model->get_reporte_horas_extras($where);
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_horas_extras_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('proyectos/reportes/reporte_horas_extras', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Horas extras';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_Horas_Extras_' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Horas_Extras', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_pagos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Cuentas Pagar Resumen';
                    $data['filename'] = $filename;
                    echo $html;
                }
            }
        }
    }

    public function orden_trabajo() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('proyectos/reportes/orden_trabajo');
        $data['tipo_orden'] = $this->gsatelite->get_dropdown('tio_tipo_orden', '{tio_nombre}', 'tipo_orden', array('tio_estado' => 1), null, null, null, true);
        $data['titulo_personal'] = "Orden de Trabajo - Servicio";
        $data['orden'] = $ord_id;
        cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * Reporte de Orden de Producción (Detalla los presupuestos de la orden)
     * $flag 1 = Indica si el reporte es una consulta Ajax. Null = Impresión
     */

    function reporte_orden_trabajo($flag = null) {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = (isset($post_array['tipo_reporte']) && $post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : null;
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            $orden = null;
            $productos = null;

            if ($flag != null) {
                $orden = ($post_array['orden'] != '') ? $post_array['orden'] : null;
                $productos = ($post_array['productos'] != '') ? $post_array['productos'] : null;
            } else {
                $orden = ($post_array['filtro_orden'] != '') ? $post_array['filtro_orden'] : null;
                $productos = ($post_array['filtro_productos'] != '' && $post_array['filtro_productos'] != 'null') ? explode(',', $post_array['filtro_productos']) : null;
            }

            /*
             * Se aplican los filtros
             */
            $where = null;
            $where['ord_id'] = $orden;
            $idsProductos = null;
            if ($productos != null && $productos != 'null') {
                $idsProductos = $productos; //explode(',', $productos);
            }

            $data['orden'] = $this->proyecto_model->get_ordenes($where);
            $data['detalle_orden'] = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $orden), $idsProductos);

            //var_dump($data['detalle_orden']);die();
            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_orden_trabajo_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;

            $html = $this->load->view('proyectos/reportes/reporte_orden_trabajo', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Orden de Trabajo';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Orden_Trabajo_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Pagos', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_pagos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Cuentas Pagar Resumen';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    public function get_ordenes_cliente() {
        if ($this->input->post()) {
            $post_array = $this->input->post();
            $cliente = $post_array['cliente'];
            $ver_finalizadas = isset($post_array['ver_finalizadas']) ? true : false;
            $where = null;
            $opciones = "<option></option>";
            if ($ver_finalizadas) {
                $where['ord_estado >'] = 0;
            } else {
                $where['ord_estado'] = 1;
            }
            if ($cliente != '') {
                $where['ord_id_cli'] = $cliente;
            }
            if ($post_array['tipo_orden'] != '') {
                $where['ord_id_tio'] = $post_array['tipo_orden'];
            }

            if ($where) {
                $ordenes = $this->gsatelite->get_tabla('ord_orden', $where);
                if (count($ordenes) > 0) {
                    foreach ($ordenes as $ord) {
                        $opciones .= '<option data-fecha="' . formatear_fecha('d-m-Y', $ord['ord_fecha']) . '" value="' . $ord['ord_id'] . '">' . $ord['ord_codigo'] . '</option>';
                    }
                }
            }

            $resultado = array('ordenes' => $opciones);

            echo json_encode($resultado);
        }
    }

    /**
     * @author Elman Ortiz
     * @return
     *
     */
    function reporte_avance_produccion_x_prod() {
        satelite_validar();
        $where = array('cli_estado' => 1);
        $resultado = $this->proyecto_model->get_clientes($where);
        if (count($resultado) > 0) {
            foreach ($resultado as $key => $value) {
                $arreglo[$key]['cliente'] = $value['cli_id'];
                $arreglo[$key]['cliente_nombre'] = $value['cliente'];
            }
        }
        $data['tipo_orden'] =   str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $this->gsatelite->get_dropdown('tio_tipo_orden', '{tio_nombre}', '', array('tio_estado' => 1), null, null, null, true));
        $data['cliente'] = $arreglo;
        $data['titulo_personal'] = "Reporte Avance de Producción por producto";
        cargarvista($data);
    }

    /**
     * @author Elman Ortiz
     * @since 2017-07-11
     * @return Obtiene los tipos de ordenes para las ordenes que tiene un cliente
     */
    function get_tipo_orden_cliente() {
        $idcliente = $this->input->post('cliente');
        $tp_ord = $this->proyecto_model->get_tipo_orden_cliente(array('ord_id_cli' => $idcliente));
        $opciones = "<option></option>";
        if (count($tp_ord)) {
            foreach ($tp_ord as $t_ord) {
                $opciones .= '<option value="' . $t_ord['tio_id'] . '">' . $t_ord['tio_nombre'] . '</option>';
            }
        }


        $resultado = array('tipo_orden' => $opciones);

        echo json_encode($resultado);
    }

    /* Obtener los productos por orden */

    function get_producto_x_orden() {
        $idorden = $this->input->post('orden');

        $productos = $this->proyecto_model->get_producto_x_orden(array('axo_id_ord' => $idorden));
        $opciones = "<option></option>";
        if (count($productos)) {
            foreach ($productos as $prod) {
                $opciones .= '<option value="' . $prod['axo_id'] . '">' .$prod['art_codigo']." - ". $prod['art_nombre'] . '</option>';
            }
        }

        $resultado = array('productos' => $opciones);
        echo json_encode($resultado);
    }

    public function avance_proyecto() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('proyectos/reportes/avance_proyecto');
        $data['tipo_orden'] = $this->gsatelite->get_dropdown('tio_tipo_orden', '{tio_nombre}', 'tipo_orden', array('tio_estado' => 1), null, null, null, true);
        $data['titulo_personal'] = "Avance total del proyecto";
        cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * Reporte de Avance Total de Proyecto.
     * $flag 1 = Indica si el reporte es una consulta Ajax. Null = Impresión
     */

    function reporte_avance_proyecto($flag = null) {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = (isset($post_array['tipo_reporte']) && $post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : null;
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            $orden = null;
            $productos = null;

            if ($flag != null) {
                $orden = ($post_array['orden'] != '') ? $post_array['orden'] : null;
                $productos = ($post_array['productos'] != '') ? $post_array['productos'] : null;
            } else {
                $orden = ($post_array['filtro_orden'] != '') ? $post_array['filtro_orden'] : null;
                $productos = ($post_array['filtro_productos'] != '' && $post_array['filtro_productos'] != 'null') ? explode(',', $post_array['filtro_productos']) : null;
            }

            /*
             * Se aplican los filtros
             */
            $where = null;
            $where['ord_id'] = $orden;
            $idsProductos = null;
            if ($productos != null && $productos != 'null') {
                $idsProductos = $productos; //explode(',', $productos);
            }

            $data['orden'] = $this->proyecto_model->get_ordenes($where);
            $data['detalle_orden'] = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $orden), $idsProductos);

            //var_dump($data['detalle_orden']);die();
            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_avance_proyecto_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;

            $html = $this->load->view('proyectos/reportes/reporte_avance_proyecto', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Avance de proyecto';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Orden_Trabajo_' . date('dmY');

                    $reporte = $header . $html;
                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Pagos', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    echo $html;
                }
            }
        }
    }

    public function costo_orden_produccion() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('proyectos/reportes/costo_orden_produccion');
        $data['tipo_orden'] = $this->gsatelite->get_dropdown('tio_tipo_orden', '{tio_nombre}', 'tipo_orden', array('tio_estado' => 1), null, null, null, true);
        $data['titulo_personal'] = "Costo por Orden de Producción";
        cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * Reporte de Costo por Orden de Producción (Detalla los presupuestos de la orden)
     * $flag 1 = Indica si el reporte es una consulta Ajax. Null = Impresión
     */

    function reporte_costo_orden_produccion($flag = null) {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = (isset($post_array['tipo_reporte']) && $post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : null;
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            $orden = null;

            if ($flag != null) {
                $orden = ($post_array['orden'] != '') ? $post_array['orden'] : null;
            } else {
                $orden = ($post_array['filtro_orden'] != '') ? $post_array['filtro_orden'] : null;
            }

            /*
             * Se aplican los filtros
             */
            $where = null;
            $where['ord_id'] = $orden;

            $data['orden'] = $this->proyecto_model->get_ordenes($where);
            $data['detalle_orden'] = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $orden));

            //var_dump($data['detalle_orden']);die();
            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_costo_orden_produccion_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;
            //print_r($data['detalle_orden']);die();
            $html = $this->load->view('proyectos/reportes/reporte_costo_orden_produccion', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Costo por Orden de Producción';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Costo_Orden_' . date('dmY');

                    $reporte = $header . $html;
                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Pagos', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    echo $html;
                }
            }
        }
    }

    public function requisicion_material() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('proyectos/reportes/requisicion_material');
        $data['tipo_orden'] = $this->gsatelite->get_dropdown('tio_tipo_orden', '{tio_nombre}', 'tipo_orden', array('tio_estado' => 1), null, null, null, true);
        $data['titulo_personal'] = "Requisición de Materiales";
        cargarvista($data);
    }

    public function reporte_requisicion_materiales($rxi_id = null, $tipo_reporte = null) {
        satelite_validar();
        if ($this->input->post() || $rxi_id != null) {
            $flag = null;
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = (isset($post_array['tipo_reporte']) && $post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : $tipo_reporte;
            $tipo_reporte = ($tipo_reporte == 1) ? "pdf" : 'excel';

            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            $requisicion = null;

            if ($rxi_id != null) {
                $requisicion = $rxi_id;
            } else {
                $requisicion = ($post_array['filtro_requisicion'] != '') ? $post_array['filtro_requisicion'] : null;
            }

            /*
             * Se aplican los filtros
             */
            $where = null;
            $where['rxi_id'] = $requisicion;

            $data['requisicion'] = $this->proyecto_model->get_requisiciones($where);
            $data['detalle_requisicion'] = $this->proyecto_model->get_detalle_requisicion(array('dri_id_rxi' => $requisicion));
            $data['producto'] = $this->proyecto_model->get_detalle_orden(array('axo_id' => $data['detalle_requisicion'][0]['axm_id_axo']));

            //var_dump($data['detalle_orden']);die();
            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_costo_orden_produccion_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;

            $html = $this->load->view('proyectos/reportes/reporte_requisicion_materiales', $data, true);
            echo $html;
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Requisición de Materiales';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Costo_Orden_' . date('dmY');

                    $reporte = $header . $html;
                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'I', 'Reporte_Pagos', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    echo $html;
                }
            }
        }
    }

    public function orden_produccion() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('proyectos/reportes/orden_produccion');
        $data['tipo_orden'] = $this->gsatelite->get_dropdown('tio_tipo_orden', '{tio_nombre}', 'tipo_orden', array('tio_estado' => 1), null, null, null, true);
        $data['titulo_personal'] = "Orden de Producción";
        cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * Reporte de Orden de Producción (Detalla los productos de la orden)
     * $flag 1 = Indica si el reporte es una consulta Ajax. Null = Impresión
     */

    function reporte_orden_produccion($flag = null) {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = (isset($post_array['tipo_reporte']) && $post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : null;
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            $orden = null;
            $productos = null;

            if ($flag != null) {
                $orden = ($post_array['orden'] != '') ? $post_array['orden'] : null;
                $productos = ($post_array['productos'] != '') ? $post_array['productos'] : null;
            } else {
                $orden = ($post_array['filtro_orden'] != '') ? $post_array['filtro_orden'] : null;
                $productos = ($post_array['filtro_productos'] != '' && $post_array['filtro_productos'] != 'null') ? explode(',', $post_array['filtro_productos']) : null;
            }

            /*
             * Se aplican los filtros
             */
            $where = null;
            $where['ord_id'] = $orden;
            $idsProductos = null;
            if ($productos != null && $productos != 'null') {
                $idsProductos = $productos; //explode(',', $productos);
            }

            $user_id = $this->tank_auth->get_user_id();
            $cond = array('emp_id_usu' => $user_id,'emp_estado'=> 1 );
            $data['usuario'] = $this->gsatelite->get_tabla('emp_empleado',$cond);
            $data['orden'] = $this->proyecto_model->get_ordenes($where);
            $data['detalle_orden'] = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $orden), $idsProductos);
            // print_r($this->db->last_query());die();

            //var_dump($data['detalle_orden']);die();
            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_orden_produccion_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;

            $html = $this->load->view('proyectos/reportes/reporte_orden_produccion', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Orden de Producción';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Orden_Produccion_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Orden_Produccion', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    echo $html;
                }
            }
        }
    }

    public function uso_materia_prima() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('proyectos/reportes/orden_produccion');
        $data['tipo_orden'] = $this->gsatelite->get_dropdown('tio_tipo_orden', '{tio_nombre}', 'tipo_orden', array('tio_estado' => 1), null, null, null, true);
        $data['titulo_personal'] = "Uso de materia prima";
        cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * Reporte de Uso de Materia Prima (Detalla el uso de la materia prima)
     * $flag 1 = Indica si el reporte es una consulta Ajax. Null = Impresión
     */

    function reporte_uso_materia_prima($flag = null) {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = (isset($post_array['tipo_reporte']) && $post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : null;
            /* Si es consulta ajax se toman los nombres del Jquery. De lo contrario, se toman los filtros de impresión */
            $orden = null;
            if ($flag != null) {
                $orden = ($post_array['orden'] != '') ? $post_array['orden'] : null;
            } else {
                $orden = ($post_array['filtro_orden'] != '') ? $post_array['filtro_orden'] : null;
                $productos = ($post_array['filtro_productos'] != '' && $post_array['filtro_productos'] != 'null') ? explode(',', $post_array['filtro_productos']) : null;
            }
            /* Se aplican los filtros */
            $where = null;
            $where['ord_id'] = $orden;
            $data['orden'] = $this->proyecto_model->get_ordenes($where);
            $data['detalle_orden'] = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $orden));

            //var_dump($data['detalle_orden']);die();
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_orden_trabajo_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;

            $html = $this->load->view('proyectos/reportes/reporte_uso_materia_prima', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Uso de Materia Prima';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Orden_Trabajo_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Pagos', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_pagos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Cuentas Pagar Resumen';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    /* Obtener las lote por producto */

    function get_lote_x_producto() {
        $idproducto = $this->input->post('producto');

        $lotes = $this->proyecto_model->get_lote_x_producto(array('lop_id_axo' => $idproducto));

        $opciones = "<option></option>";
        if (count($lotes)) {
            foreach ($lotes as $lote) {
                $opciones .= '<option value="' . $lote['lop_id'] . '">' . $lote['lop_nombre'] . '</option>';
            }
        }

        $resultado = array('lotes' => $opciones);
        echo json_encode($resultado);
    }

    function get_reporte_avance_produccion_producto($flag = null) {
        if ($_POST) {
            $idorden = $this->input->post('slcOrden');
            $idproducto = $this->input->post('slcProducto');
            $idlote = $this->input->post('slcLote');
            $where = null;
            if ($idorden != '') {
                $where['axo_id_ord'] = $idorden;
            }
            if ($idproducto != '') {
                $where['axo_id'] = $idproducto;
            }
            if ($idlote != '') {
                $where['lop_id'] = $idlote;
            }
            $datos = $this->proyecto_model->get_avance_proxprod($where);

            //Preparacion data
            $newdata = [];
            $i = 0;
            $ietapa = 0;
            $lop_id = $datos[0]['lop_id'];
            foreach ($datos as $key => $dato) {
                if ($dato['lop_id'] == $lop_id) {
                    $newdata[$i]['axo_id'] = $dato['axo_id'];
                    $newdata[$i]['ord_codigo'] = $dato['ord_codigo'];
                    $newdata[$i]['axo_descripcion'] = $dato['axo_descripcion'];
                    $newdata[$i]['lop_nombre'] = $dato['lop_nombre']; //Nombre del lote
                    $newdata[$i]['lop_cantidad'] = $dato['lop_cantidad']; //Cantidad total del lote
                    $newdata[$i]['lop_id'] = $dato['lop_id'];
                    $newdata[$i]['lop_nombre'] = $dato['lop_nombre'];
                    $newdata[$i]['exo_id'][$ietapa] = $dato['exo_id'];
                    $newdata[$i]['exo_cantidad'][$ietapa] = $dato['exo_cantidad']; //Cantidad por etapa
                    $newdata[$i]['etp_nombre'][$ietapa] = $dato['etp_nombre'];
                    $newdata[$i]['moe_fecha_salida'][$ietapa] = $dato['moe_fecha_salida'];
                    $ietapa++;
                } else {
                    $i++;
                    $ietapa = 0;
                    $lop_id = $dato['lop_id'];
                    if ($dato['lop_id'] == $lop_id) {
                        $newdata[$i]['axo_id'] = $dato['axo_id'];
                        $newdata[$i]['ord_codigo'] = $dato['ord_codigo'];
                        $newdata[$i]['axo_descripcion'] = $dato['axo_descripcion'];
                        $newdata[$i]['lop_nombre'] = $dato['lop_nombre']; //Nombre del lote
                        $newdata[$i]['lop_cantidad'] = $dato['lop_cantidad']; //Cantidad total del lote
                        $newdata[$i]['lop_id'] = $dato['lop_id'];
                        $newdata[$i]['lop_nombre'] = $dato['lop_nombre'];
                        $newdata[$i]['exo_id'][$ietapa] = $dato['exo_id'];
                        $newdata[$i]['exo_cantidad'][$ietapa] = $dato['exo_cantidad']; //Cantidad por etapa
                        $newdata[$i]['etp_nombre'][$ietapa] = $dato['etp_nombre'];
                        $newdata[$i]['moe_fecha_salida'][$ietapa] = $dato['moe_fecha_salida'];
                        $ietapa++;
                    }
                }
            }
            $tipo_reporte = $this->input->post('tipo_reporte');
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_avan_prodxproducto_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;

            $data['data'] = $newdata;
            $html = $this->load->view('proyectos/reportes/avance_produccion_x_prod', $data, true);

            if ($flag) {//Si flag distinto de null
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Avance produccion por producto';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'rpt_avan_prodxproducto_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;
                    $this->pdf->makePdf($reporte, 'P', 'Avance produccion por producto ', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_avan_prodxproducto_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Avance produccion por producto';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

//Fin get_reporte_avance_produccion_producto

    /**
     * @author Elman Ortiz
     * @since  2017-07-17
     * @return Reporte de Estandar de Producto
     */
    function reporte_estandar_producto() {
        $opciones = "<option></option>";
        $categorias = $this->gsatelite->get_tabla('tia_tipo_articulo');
        if (count($categorias)) {
            foreach ($categorias as $cat) {
                $opciones .= '<option value="' . $cat['tia_id'] . '">' . $cat['tia_codigo'] . ' - ' . $cat['tia_nombre'] . '</option>';
            }
        }
        $data['categorias'] = $opciones;
        $data['titulo_personal'] = "Reporte Estandar de Producto";
        cargarvista($data);
    }

    /**
     * @author Elman Ortiz
     * @since  2017-07-17
     * @return Reporte de Estandar de Producto
     */
    public function get_producto_x_categoria() {
        if ($this->input->post()) {
            $post_array = $this->input->post();
            $id_tia = $post_array['categoria'];
            $where = null;
            $opciones = "<option></option>";
            if ($id_tia != '') {
                $where['art_id_tia'] = $id_tia;
                // $where['art_produccion'] = 1;
                // $where['art_materia_prima'] = 1;
            }
            if ($where) {
                $productos = $this->proyecto_model->get_product_x_category($where);
                // $productos = $this->gsatelite->get_tabla('art_articulo', $where);
                if (count($productos)) {
                    foreach ($productos as $prod) {
                        $opciones .= '<option value="' . $prod['art_id'] . '">' . $prod['art_codigo'] . ' - ' . $prod['art_nombre'] . '</option>';
                    }
                }
            }
            $resultado = array('productos' => $opciones);
            echo json_encode($resultado);
        }
    }

    function get_reporte_estandar_producto($flag = null) {
        if ($_POST) {
            $idcategoria = $this->input->post('slcCategoria');
            $idproducto = $this->input->post('slcProducto');
            $valcategoria = $this->input->post('valCategoria');
            $valproducto = $this->input->post('valProducto');
            $valdescripcion = $this->input->post('valDescripcion');
            $where = null;
            if ($idproducto == '') {
                $idproducto = null;
            }
            $datos = $this->proyecto_model->get_estandar_producto($idproducto);
            $tipo_reporte = $this->input->post('tipo_reporte');
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_estandar_producto_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['filtros'] = array('categoria' => $valcategoria, 'producto' => $valproducto, 'descripcion' => $valdescripcion);
            $data['m_prima'] = $datos['prima'];
            $data['m_obra'] = $datos['obra'];
            $data['m_gasto'] = $datos['gasto'];
            $data['decimal'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            $html = $this->load->view('proyectos/reportes/grid_reporte_estandar_producto', $data, true);

            if ($flag) {//Si flag distinto de null
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Receta Estándar de Producto';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'rpt_rct_stdr_producto_' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'P', 'Avance produccion por producto ', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_avan_prodxproducto_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Avance produccion por producto';
                    $data['filename'] = $filename;
                    echo $html;
                }
            }
        }
    }

//Fin

    /**
     * @author Elman Ortiz
     * @since  2017-07-19
     * @return Devuelve los datos de un producto en especifico
     */
    function get_data_producto() {
        $idproducto = $this->input->post('slcProducto');
        if ($idproducto != '') {
            $where['art_id'] = $idproducto;
        }
        $tb_articulo = $this->gsatelite->get_tabla('art_articulo', $where);
        echo $tb_articulo[0]['art_descripcion'];
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    function ordenes_produccion($reporte = null) {
        satelite_validar();
        $tipo_reporte = $this->input->post('tipo_reporte');
        /*Filtros Cliente, fehca iniico, fecha fin*/
                            $this->db->group_by('cli_id');
                            $this->db->join('cli_cliente', 'ord_id_cli = cli_id');
        $data['clientes'] = $this->gsatelite->get_tabla('ord_orden', array('cli_estado' => 1));
        //$data['ordenes'] = $this->proyecto_model->get_ordenes();
        //$data['bancos'] = $this->gsatelite->get_tabla('ban_banco', array('ban_estado' => 1));
        $where = array();
        //Verificacion de valores filtro
        $cliente = ($this->input->post('slcFiltro')) ? $this->input->post('slcFiltro') : '' ;
        $fecha_inicio = ($this->input->post('txtFechaIni')) ? $this->input->post('txtFechaIni') : '' ;
        $fecha_fin = ($this->input->post('txtFechaFin')) ? $this->input->post('txtFechaFin') : '' ;
        //Asignacion de filtros
        if($fecha_inicio){
            $where['ord_fecha_creacion >='] = formatear_fecha('Y-m-d H:i:s', $fecha_inicio);
            $data['fecha_inicio'] = $fecha_inicio;
        }
        if($fecha_fin){
            $where['ord_fecha_creacion <='] = formatear_fecha('Y-m-d 23:59:59', $fecha_fin);
            $data['fecha_fin'] = $fecha_fin;
        }
        if($cliente){
            $where['cli_id ='] = $cliente;
        }
        if ($this->input->post() && $reporte != 1) {
            $data['ordenes'] = $this->proyecto_model->get_ordenes($where);
            $data['titulo_personal'] = "Ordenes de producción";
            $data['bancos'] = $this->gsatelite->get_tabla('ban_banco', array('ban_estado' => 1));
            $this->_cargarvista($data);
            die();
        }else{
            //print_r($data); die();
            $cliente = ($this->input->post('hslcFiltro')) ? $this->input->post('hslcFiltro') : '' ;
            $fecha_inicio = ($this->input->post('htxtFechaIni')) ? $this->input->post('htxtFechaIni') : '' ;
            $fecha_fin = ($this->input->post('htxtFechaFin')) ? $this->input->post('htxtFechaFin') : '' ;
            if($fecha_inicio){
                $where['ord_fecha_creacion >='] = formatear_fecha('Y-m-d H:i:s', $fecha_inicio);
                $data['fecha_inicio'] = $fecha_inicio;
            }
            if($fecha_fin){
                $where['ord_fecha_creacion <='] = formatear_fecha('Y-m-d 23:59:59', $fecha_fin);
                $data['fecha_fin'] = $fecha_fin;
            }
            if($cliente){
                $where['cli_id ='] = $cliente;
            }
            $data['ordenes'] = $this->proyecto_model->get_ordenes($where);
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_orden_produccion' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['titulo'] = 'Ordenes de Producción';
            $html = $this->load->view("proyectos/reportes/reporte_ordenes_produccion", $data, TRUE);

            if ($tipo_reporte == 'pdf') {
                $data['titulo'] = 'Ordenes de Producción';
                $header = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte'] = 'Reporte_compras_producto' . date('dmY');
                $reporte = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Reporte_compras_producto', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                //$data['tipo_reporte'] = 'excel';
                $filename = 'rpt_compras_producto_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['filename'] = $filename;
                echo $html;
                die();
            }
        }
        $this->db->group_by('cli_id');
        $this->db->join('cli_cliente', 'ord_id_cli = cli_id');
        $data['clientes'] = $this->gsatelite->get_tabla('ord_orden', array('cli_estado' => 1));
        //$data['ordenes'] = $this->proyecto_model->get_ordenes();
        //$data['bancos'] = $this->gsatelite->get_tabla('ban_banco', array('ban_estado' => 1));
        $data['titulo_personal'] = "Ordenes de producción";
        $this->_cargarvista($data);
    }

    /**
    * @author Habby Lovo
    * @since 2018-02-13
    * @return reporte consolidado de produccion por proyecto
    */
    public function consolidado_produccion_proyecto($consulta=0){
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        if ($_POST) {
            if ($consulta > 0) {
                $post_array = $_POST;

                $fecha_ini = $post_array['fecha_ini'];
                $fecha_fin = $post_array['fecha_fin'];
                $cliente = $post_array['cliente'];
                $proyecto = $post_array['proyecto'];
                $estado = $post_array['estado'];

                //$data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
                $data['fecha_ini']  = $fecha_ini;
                $data['fecha_fin']  = $fecha_fin;
                $data['cliente_id']  = $cliente;
                $data['proyecto']  = $proyecto;
                $data['estado']   = $estado;

                $where = null;

                if ($fecha_ini != '' && $fecha_fin != '') {
                    $where['ord_fecha >='] = date('Y-m-d', strtotime($fecha_ini));
                    $where['ord_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
                }

                if(trim($cliente) != ""){
                    $where['cli_id'] = $cliente;
                }
                if(trim($proyecto) != ""){
                    $where['pcl_id'] = $proyecto;
                }
                if(trim($estado) != ""){
                    $where['pcl_id_epr'] = $estado;
                }

                $proyectos = $this->proyecto_model->get_produccion_proyecto($where);

                $data['proyectos'] = $proyectos;
                $data['tipo_reporte'] = 'grid';
                $html = $this->load->view('proyectos/reportes/grid_consolidado_produccion_proyecto', $data, true);
                echo $html;
                die();
            }
        } else {
            $cli = $this->gsatelite->get_tabla('cli_cliente',array('cli_estado' =>1));
            $est = $this->gsatelite->get_tabla('epr_estado_proyecto',array('epr_estado' =>1));
            $data['clientes'] = $cli;
            $data['estados'] = $est;
            $data['titulo_personal'] = "Consolidado de ordenes de produccion por proyecto";
            cargarvista($data);
        }
    }

    public function imprimir_consolidado_produccion_proyecto(){
        $post_array = $_POST;

        $fecha_ini = $post_array['rpt_txtFechaIni'];
        $fecha_fin = $post_array['rpt_txtFechaFin'];
        $cliente = $post_array['rpt_cliente'];
        $proyecto = $post_array['rpt_proyecto'];
        $estado = $post_array['rpt_estado'];
        $tipo = $post_array['rpt_tipo'];

        $data['fecha_ini']  = $fecha_ini;
        $data['fecha_fin']  = $fecha_fin;
        $data['cliente_id']  = $cliente;
        $data['proyecto']  = $proyecto;
        $data['estado']   = $estado;

        $where = null;

        if ($fecha_ini != '' && $fecha_fin != '') {
            $where['ord_fecha >='] = date('Y-m-d', strtotime($fecha_ini));
            $where['ord_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
        }

        $nombre_cliente = '';
        if(trim($cliente) != ""){
            $where['cli_id'] = $cliente;

            $cliente_data = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $cliente));
            $nombre_cliente = $cliente_data[0]['cli_codigo'].' '.$cliente_data[0]['cli_nombre'].' '.$cliente_data[0]['cli_apellido'];
            if ($cliente_data[0]['cli_personeria'] == 2) {
                $nombre_cliente = $cliente_data[0]['cli_codigo'].' - '.$cliente_data [0]['cli_apellido'];
            }
        }
        $data['cliente'] = $nombre_cliente;

        $nombre_proyecto = '';
        if(trim($proyecto) != ""){
            $where['pcl_id'] = $proyecto;

            $proyecto_data = $this->gsatelite->get_tabla('pcl_proyecto_cliente', array('pcl_id' => $proyecto));
            $nombre_proyecto = $proyecto_data[0]['pcl_codigo'].' - '.$proyecto_data[0]['pcl_nombre'];
        }
        $data['pro'] = $nombre_proyecto;

        $estado_proyecto = '';
        if(trim($estado) != ""){
            $where['pcl_id_epr'] = $estado;
            $proyecto_data = $this->gsatelite->get_tabla('epr_estado_proyecto', array('epr_id' => $estado));
            $estado_proyecto = $proyecto_data[0]['epr_nombre'];
            //$data['estado_nombre'] = $estado_proyecto;
        }
        $data['estado_nombre'] = $estado_proyecto;

        $proyectos = $this->proyecto_model->get_produccion_proyecto($where);

        $data['proyectos'] = $proyectos;
        $data['tipo_reporte'] = $tipo;

        if($tipo == 'excel'){
            $filename = 'rpt_listado_proyectos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $this->load->view('proyectos/reportes/grid_consolidado_produccion_proyecto', $data);
            //$this->load->view('cotizaciones/consultas/reporte_listado_proyectos', $data);
        } else{
            $this->load->library('pdf');
            $data['titulo'] = 'Listado de ordenes de produccion por proyecto';
            $data['solotitulo'] = '1';

            $header = $this->load->view('reporte/header', $data, true);
            $html = $this->load->view('proyectos/reportes/grid_consolidado_produccion_proyecto', $data, true);
            $GLOBALS['nombre_reporte'] = 'rpt_listado_proyectos' . date('dmY');

            $this->pdf->makePdf($header.$html, 'L', 'rpt_listado_proyectos', 'Letter');
        }
    }

    public function reporte_prod_fabricados() {
        satelite_validar();
        if ($_POST) {
            $fecha_inicio = $this->input->post('fecha_ini') != "" ? formatear_fecha('Y-m-d', $this->input->post('fecha_ini')) : null;
            $fecha_final = $this->input->post('fecha_fin') != "" ? formatear_fecha('Y-m-d', $this->input->post('fecha_fin')) : null;
            $tipo_prodcto = $this->input->post('cat_prodc') != "" ? $this->input->post('cat_prodc') : null;
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = array();
            $where['ord_estado > '] = 0;
            $where['DATE(ord_fecha) >= '] = $fecha_inicio;
            $where['DATE(ord_fecha) <= '] = $fecha_final;
            if ($tipo_prodcto) {
                $where["art_id_tia"] = $tipo_prodcto;
            }
                         $this->db->group_by('art_id, ord_id');
                         $this->db->order_by('art_codigo');
                         $this->db->join('axo_articuloxorden', 'axo_id_art = art_id');
                         $this->db->join('ord_orden', 'ord_id = axo_id_ord');
            $productos = $this->gsatelite->get_tabla('art_articulo', $where);
            $data['productos'] = $productos;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['filename'] = 'Reporte_Productos_Fabricados';
            $html = $this->load->view('proyectos/reportes/rpt_productos_fabricados', $data, true); 
            if ($tipo_reporte == 'pdf') {
                $header = $this->load->view('reporte/header', array('titulo' => 'Productos Fabricados'), true);
                $reporte = $header . $html;
                $this->pdf->SetMargins(10, 10, 10, 50);
                $this->pdf->makePdf($reporte, 'L', 'Reporte_Productos_Fabricados', 'Letter');
            } else {
                echo $html;
            }
        } else {
            $cate_prod =  $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}','', array('tia_estado' => 1), null, '','tia_id', true);
            $data['cat_pro'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $cate_prod);
            $data['titulo_personal'] = "Reporte Productos Fabricados";
            cargarvista($data);
        }
        
    }

    public function detalle_reporte_prod_fabricados() {
        satelite_validar();
        ini_set( 'memory_limit', '2048M' ); 
        ini_set('max_execution_time', '9999');
        $fecha_inicio = $this->input->post('txtFechaIni') != "" ? formatear_fecha('Y-m-d', $this->input->post('txtFechaIni')) : null;
        $fecha_final = $this->input->post('txtFechaFin') != "" ? formatear_fecha('Y-m-d', $this->input->post('txtFechaFin')) : null;
        $tipo_prodcto = $this->input->post('slcTipoProd') != "" ? $this->input->post('slcTipoProd') : null;
        $where['ord_estado > '] = 0;
        $where['DATE(ord_fecha) >= '] = $fecha_inicio;
        $where['DATE(ord_fecha) <= '] = $fecha_final;
        if ($tipo_prodcto) {
            $where["art_id_tia"] = $tipo_prodcto;
        }
                     $this->db->group_by('art_id, ord_id');
                     $this->db->join('axo_articuloxorden', 'axo_id_art = art_id');
                     $this->db->join('ord_orden', 'ord_id = axo_id_ord');
        $productos = $this->gsatelite->get_tabla('art_articulo', $where);
        $data['productos'] = $productos;
        $html = $this->load->view('proyectos/reportes/detalle_prod_fabricados', $data, true);
        echo json_encode(array('tabla'=> $html, 'filas' => count($productos)));
    }

    /**
    * @author Francisco Orozco
    * @since 2018-11-05
    * @return reporte de cursograma analítico
    */
    public function cursograma_analitico(){
        satelite_validar();
        if ($_POST){
            $slc_categoria          = $this->input->post('slc_categoria');
            $slc_producto           = $this->input->post('slc_producto');
            $tipo_reporte           = ($this->input->post('tipo_reporte') != false) ? $this->input->post('tipo_reporte') : '';
           
            $where["cra_id_art"]    = $slc_producto;

            $data['analisis']       = $this->proyecto_model->etapas_cursograma_analitico($where);
            $creador_array          = $this->gsatelite->get_tabla("emp_empleado",array("emp_id_usu" => $data['analisis'][0]["cra_usu_creacion"]));
            $data['creador']        = $creador_array[0]["emp_nombre"]. " " .$creador_array[0]["emp_apellido"];
            $data["tipo_reporte"]   = $tipo_reporte;
            $filename               = 'reporte_cursograma_nalítico_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']         = 'Cursograma Analítico';
            $data['filename']       = $filename;
            $html                   = $this->load->view('proyectos/reportes/reporte_cursograma_analitico', $data, true);
            
            if ($tipo_reporte == '') {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            }  elseif ($tipo_reporte == 'pdf') {            
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'reporte_cursograma_nalítico_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'reporte_cursograma_nalítico_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            }
        } else {
            $categorias = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_nombre}', '', array('tia_estado' => 1), null, null, 'tia_id', true);
            $data['categorias'] = str_replace('<option value="0">Seleccione</option>', '', $categorias);
            $data['titulo_personal']    = 'Reporte de Cursograma Analítico';
            cargarvista($data);
        } 
    }


     /**
    * @author Francisco Orozco
    * @since 2018-11-05
    * @return obtiene los productos 
    */
    public function get_articuloxcategoria(){
        satelite_validar();
        $categoria          = $this->input->post('categoria');
        $productos_array    = $this->gsatelite->get_tabla("art_articulo", array("art_estado" => 1, "art_id_tia" => $categoria) );
        $productos_html     = '<option><option>';

        foreach ($productos_array as $key => $producto) {
            $productos_html .= '<option value="'.$producto["art_id"].'">' . $producto["art_codigo"] . ' - ' . $producto["art_nombre"].'<option>';
        }
        die(json_encode( array("productos" => $productos_html) ));
    }

    /*
     * @author: Elman Ortiz
     * @since: 07-11-2018
     * Reporte de Orden de Producción (Vista principal)     
     */
    public function resumen_orden_produccion() {        
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('proyectos/reportes/resumen_orden_produccion');
        $data['tipo_orden'] = $this->gsatelite->get_dropdown('tio_tipo_orden', '{tio_nombre}', 'tipo_orden', array('tio_estado' => 1), null, null, null, true);
        $data['titulo_personal'] = "Resumen Orden de Producción";
        cargarvista($data);
    }

    /*
     * @author: Elman Ortiz
     * Reporte de Orden de Producción (Detalla los productos de resumen orden)
     * $flag 1 = Indica si el reporte es una consulta Ajax. Null = Impresión
     */
    function filtrar_resumen_orden_produccion($flag = null) {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(print_r($post_array));
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = (isset($post_array['tipo_reporte']) && $post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : null;
            /* Si es consulta ajax se toman los nombres del Jquery De lo contrario, se toman los filtros de impresión */
            $orden = null;
            $productos = null;
            if ($flag != null) {
                $fecha_desde = ($post_array['fecha_desde'] != '') ? $post_array['fecha_desde'] : null;
                $fecha_hasta = ($post_array['fecha_hasta'] != '') ? $post_array['fecha_hasta'] : null;
            } else {
                $fecha_desde = ($post_array['filtro_fechadesde'] != '') ? $post_array['filtro_fechadesde'] : null;
                $fecha_hasta = ($post_array['filtro_fechahasta'] != '') ? $post_array['filtro_fechahasta'] : null;
            }

            /* Se aplican los filtros */
            $where = null;
            $where2 = null;
            if ($fecha_desde != null) {
                $where['DATE(ord_fecha) >='] = formatear_fecha('Y-m-d', $fecha_desde);                
            }
            if ($fecha_hasta != null) {
                $where['DATE(ord_fecha) <='] = formatear_fecha('Y-m-d', $fecha_hasta);                
            }
            $user_id = $this->tank_auth->get_user_id();
            $cond = array('emp_id_usu' => $user_id,'emp_estado'=> 1 );
            $data['usuario'] = $this->gsatelite->get_tabla('emp_empleado',$cond);
            $ordenes = $this->proyecto_model->get_ordenes($where);
            $data['orden'] = $ordenes;
            $array_idsordenes = null;
            if ($ordenes != null && $ordenes != 'null') {
                $array_idsordenes = array_column($ordenes, 'ord_id');
            }
            $data['detalle_orden'] = $this->proyecto_model->get_detalle_orden(null, null, $array_idsordenes);
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_resumen_orden_produccion_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('proyectos/reportes/filtrar_resumen_orden_produccion', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Resumen Orden de Producción';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Resumen_Reporte_Orden_Produccion_' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'P', 'Reporte_Resumen_Orden_Produccion', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    echo $html;
                }
            }
        }
    }

    /**
    	* @author Francisco Orozco
    	* @since 2018-12-17
    	* @return Reporte de programación semanal de producción
    */
	function programacion_semanal(){
		satelite_validar();
		if ($_POST) {
			$fecha_inicio = ($this->input->post('txtFechaIni') != '' ) ? formatear_fecha('Y-m-d', $this->input->post('txtFechaIni')) : null;
            $fecha_fin    = ($this->input->post('txtFechaFin') != '') ? formatear_fecha('Y-m-d', $this->input->post('txtFechaFin')) : null;
            $tipo_reporte = ($this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';
            
			$where["ord_estado"]		= 1;
			$where_in					= null;
			if ( $fecha_inicio != "" ) {
				$where["DATE(dpp_fecha_inicio) >="]	= $fecha_inicio;
			}

			if ( $fecha_fin != "" ) {
				$where["DATE(dpp_fecha_inicio) <="]	= $fecha_fin;
			}
		                            $this->db->order_by('ord_id ASC');
            $data['consulta']     = $this->proyecto_model->get_orden($where);
            $data["tipo_reporte"] = $tipo_reporte;
            $filename               = 'Reporte_programacion_semanal_produccion_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']         = 'programación semanal de producción';
			$data['filename']       = $filename;
			$data['desde']			= date('d-m-Y', strtotime( $fecha_inicio ) );
			$data['fin']			= date('d-m-Y', strtotime( $fecha_fin ) );
            $html 					= $this->load->view('proyectos/reportes/reporte_programacion_semanal', $data, true);
            
            if ($tipo_reporte == 'pdf') {
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_programacion_semanal_produccion_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Reporte_programacion_semanal_produccion_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            } else {
				$data2['html'] = $html;
				echo json_encode($data2);
				die();
			}

		} else {
            $data['titulo_personal']= 'Reporte de programación de producción por período';
            cargarvista($data);
		}
	}

    /**
    * @author Nelson Soriano
    * @since  06/02/2019
    * @return vista con los controles y filtros para generar el reporte
    * Descripcion: Funcion para generar un reporte de las etapas de produccion de un producto x 
    */
    public function produccion_por_etapas(){
        satelite_validar();
        $data['titulo_personal'] = 'Reporte de Produccion por etapas';
        $data['permisos']        =  $this->gsatelite->get_permisos_opcion('proyectos/reportes/produccion_por_etapas');
        $data['clientes']        =  $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]", '', array('cli_estado' => 1), null, null, null, true);
        cargarvista($data);
    }

    /**
    * @author Nelson Soriano
    * @since  06/02/2019
    * @return Devuelve las etaoas del job tracking planeado por un priducto,
    * 
    */
    public function get_etapas_productos(){
        satelite_validar();
        if ( (isset($_POST['producto'])) && ($_POST['producto'] != '') ) {
            $producto  = $this->input->post('producto');
            //$info      = $this->proyecto_model->get_etapas_producto_orden_board(array('axo_id_art'=>$producto),'etp_id');
            $info      = $this->proyecto_model->get_etapas_producto_orden_reporte(array('axo_id_art'=>$producto),'etp_id');
            $options   = '';
            foreach ($info as $key => $data) {
                $options.= '<option value="'.$data['etp_id'].'">'.$data['etp_nombre'].'</option>';
            }
            echo json_encode(array('etapas'=> $options));
            die();
        }else{
            echo json_encode(array('etapas'=> '<option></option>'));
        }

    }

    /**
    * @author Nelson Soriano
    * @since  06/02/2019
    * @return Devuelve los productos de una orden de produccion
    * 
    */
    public function get_productoS_por_orden() {
        $idorden = $this->input->post('orden');

        $productos = $this->proyecto_model->get_producto_x_orden(array('axo_id_ord' => $idorden));
        $opciones = "<option></option>";
        if (count($productos)) {
            foreach ($productos as $prod) {
                $opciones .= '<option value="' . $prod['art_id'] . '">' . $prod['art_codigo'] . ' - ' . $prod['art_nombre'] . '</option>';
            }
        }

        $resultado = array('productos' => $opciones);
        echo json_encode($resultado);
    }

    /**
    * @author Nelson Soriano
    * @since  06/02/2019
    * @return Devuelve las ordenes de venta de un cliente,
    * 
    */
    public function get_ordenes_venta(){
        $cliente  =  $this->input->post('cliente');
        $info     =  $this->gsatelite->get_dropdown('orv_orden_venta', "{orv_numero_orden} - {orv_nombre_factura}", '', array('orv_estado <>' => 3,'orv_id_cli'=>$cliente), null, null, null, true);
        $array    = array('<option value="0">Sin Registros</option>','<option value="0">Seleccione</option>');
        echo json_encode(array('ordenes'=>str_replace($array, '', $info)));
        die();
    }

    /**
    * @author Nelson Soriano
    * @since  06/02/2019
    * @return Vista del reporte de produccion por etapas
    * 
    */
    public function show_reporte_etapas($es_reporte = null){
        satelite_validar();
        $inicio  = ($this->input->post('fecha_ini') != '')?$this->input->post('fecha_ini'):null;
        $fin     = ($this->input->post('fecha_fin') != '')?$this->input->post('fecha_fin'):null;
        $cliente = ($this->input->post('cliente') != '')?$this->input->post('cliente'):null;
        $ordenP  = ($this->input->post('slcOrdenes') != '')?$this->input->post('slcOrdenes'):null;
        $ordenV  = ($this->input->post('slcOrdenVenta') != '')?$this->input->post('slcOrdenVenta'):null;
        $etapa   = ($this->input->post('slcEtapas') != '')?$this->input->post('slcEtapas'):null;
        $prod    = ($this->input->post('slcProductos') != '')?$this->input->post('slcProductos'):null;
        if ($inicio && $fin) {
            $where['date_format(ord_fecha,"%Y-%m-%d") >='] = date_format(date_create($inicio),'Y-m-d');
            $where['date_format(ord_fecha,"%Y-%m-%d") <='] = date_format(date_create($fin),'Y-m-d');
        }
        if ($cliente) {
            $where['ord_id_cli'] = $cliente;
        }
        if ($ordenP) {
            $where['ord_id'] = $ordenP;
        }
        if ($ordenV) {
           $where['orv_id'] = $ordenV;
        }        
        if ($etapa) {
           $where['axm_id_etp'] = $etapa;
           $array_where['etp_id'] = $etapa;
        }
        if ($prod) {
            $where['axo_id_art'] = $prod;
        }
        $tipo_reporte = $this->input->post('rpt_tipo');
        $data['info']           =  $this->proyecto_model->get_data_produccion($where,'axo_id_art');
        $axo_id                 =  $data['info'][0]['id'];
        $array_where['axo_id']  =  $axo_id;
        $data['detalle_etapas'] =  $this->proyecto_model->get_insumos($array_where,'axm_id_etp','axm_id_art_materia');
        $data['tipo_reporte']   =  $tipo_reporte;
        $html = $this->load->view('proyectos/reportes/show_reporte_etapas',$data,true);
        if ($es_reporte) {
            switch ($tipo_reporte) {
                case 'pdf':
                    $this->load->library('pdf');
                    $html_header='';
                     $this->pdf->setPrintFooter(false);
                    $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                    $this->pdf->makePDF($html_header.str_replace('font-size: 14px;','font-size: 10px;',$html),'P');
                    break;
                
                case 'excel':
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=Produccion_etapas-".date('d-m-Y_His').".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='0'>
                    <tr><th colspan='5' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                    <tr><th colspan='5' align='center' >Produccion por etapas</th></tr>
                    <tr><th colspan='5' align='center' >".$filtro_titulo. "</th></tr>
                    </table>";
                    echo $html;
                  die();
                    break;
            }
        }
        echo $html;
        die();
    }   

    public function get_productos_x_orv(){
        satelite_validar();
        $orv     = $this->input->post('orv');
        $datos   = $this->gsatelite->get_tabla('dov_detalle_orden_venta',array('dov_id_orv'=>$orv));
        $op      = implode(',',array_column($datos, 'dov_id_art'));
        $prods   = $this->gsatelite->get_tabla('art_articulo',array('art_id in('.$op.')'=>null));
        $options = '';
        foreach ($prods as $key => $valores) {
            $options.='<option value="'.$valores['art_id'].'">'.$valores['art_nombre'].'</option>';
        }

        $resultado = array('productos' => $options);
        echo json_encode($resultado);
        die();
    }

    function costo_venta_producto($flag = null){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

        if($this->input->post()) {
            $post_array     = $this->input->post();
            if ($flag) {
                $fecha_inicio   = ($post_array['txtFechaIni'] != '')? date('Y-m-d', strtotime($post_array['txtFechaIni'])) : null;
                $fecha_fin      = ($post_array['txtFechaFin'] != '')? date('Y-m-d', strtotime($post_array['txtFechaFin'])) : null;
                $categoria      = ($post_array['categoria'] != '') ? $post_array['categoria'] : null;
            } else {
                $fecha_inicio   = ($post_array['h_fecha_ini'] != '')? date('Y-m-d', strtotime($post_array['h_fecha_ini'])) : null;
                $fecha_fin      = ($post_array['h_fecha_fin'] != '')? date('Y-m-d', strtotime($post_array['h_fecha_fin'])) : null;
                $categoria      = ($post_array['h_categ_id'] != '') ? $post_array['h_categ_id'] : null;
                $catego_text    = ($post_array['h_categ_text'] != '') ? $post_array['h_categ_text'] : '';
                $data['fecha_inicio_t'] = ($fecha_inicio != '') ? '<b>Fecha inicial: ' . date('d-m-Y', strtotime($fecha_inicio)) . '</b>' : '';
                $data['fecha_fin_t']    = ($fecha_fin != '') ? '<b>Fecha final: ' . date('d-m-Y', strtotime($fecha_fin)) . '</b>' : '';
                $data['category_t']     = ($categoria != '') ? '<b>Categoria:' . $catego_text . '</b>' : '';                
            }
            $tipo_reporte   = ($post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : '';
            $where          = null;                        
            if ($fecha_inicio != '' && $fecha_fin != '') {
                $where['fac_fecha_fact >=']  = date_format(date_create($fecha_inicio),'Y-m-d');
                $where['fac_fecha_fact <=']  = date_format(date_create($fecha_fin),'Y-m-d');
            }
            $info                   = $this->proyecto_model->get_costos($where, $categoria);
            $data['rows']           = count($info);
            $data['info']           = $info;
            $filename               = 'Reporte_costo_venta_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']       = $filename;
            $data['tipo_reporte']   = $tipo_reporte;
            $data['titulo']         = 'costo promedio de venta';
            $html                   = $this->load->view('proyectos/reportes/filtrar_costo_venta',$data,true);

            if ($flag) {
                $data['html'] = $html;
                echo json_encode($data);
                die();
            } elseif ($tipo_reporte == 'pdf') {
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_costo_venta_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'reporte_costo_promedio_producto', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                $data['excel']          = 1;
//              $data['titulo']         = 'Análisis de cotización de compra';
  //            $filename               = 'Reporte_analisis_cotizaciones_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                echo $html;
            }
            
        } else {
            $data['categorias']      = $this->gsatelite->get_tabla('tia_tipo_articulo',"tia_padre is null and tia_estado = 1");
            $data['permisos']        = $permisos;
            $data['titulo_personal'] = 'Reporte costo de venta promedio de producto';
            $this->_cargarvista($data);
        }
    }

    function materia_prima_x_orden(){
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        $data['tipo_orden'] = $this->gsatelite->get_dropdown('tio_tipo_orden', '{tio_nombre}', 'tipo_orden', array('tio_estado' => 1), null, null, null, true);
        $data['titulo_personal'] = "Materia Prima por Orden de Producción";
        cargarvista($data);        
    }

    function reporte_materia_prima_x_orden($flag = NULL, $id_orden = NULL, $tipo = NULL){
        satelite_validar();
        $orden_id     = ($id_orden != null) ? $id_orden : $this->input->post('orden');
        $tipo_reporte = ($tipo != null) ? 'pdf' : $this->input->post('tipo_reporte');
        $where['ord_id'] = $orden_id;
        $data['orden'] = $this->proyecto_model->get_mat_prim_x_ord($where);
        $data['tipo_reporte'] = $tipo_reporte;
        $filename = 'rpt_mat_orden_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        $data['filename'] = $filename;
        $html = $this->load->view('proyectos/reportes/rpte_mat_prim_x_ord', $data, true);
        if ($flag > 0) {
            echo $html;
        } else {
            if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Materia Prima por Orden';
                    $header = $this->load->view('reporte/header', $data, true);
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'P', 'Reporte_Mat_x_Orden', 'Letter');
            } else {
                echo $html;
            }
            
        }
    }

    public function inventario_requisiciones($consulta = 0){
        satelite_validar();
        if ($_POST) {
            if ($consulta > 0) {
                $this->load->model('inventario_model');
                $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
                $flujos_array = json_decode($flujos, true);
                $post_array = $_POST;
                $bodega = $post_array['bodega'];
                $fecha_inicio = $post_array['fecha_ini'];
                $fecha_fin = $post_array['fecha_fin'];
                $modulo = $post_array['modulo'];
                $data['bodega_id'] = $bodega;
                $data['fecha_ini'] = $fecha_inicio;
                $data['fecha_fin'] = $fecha_fin;
                $data['modulo'] = $modulo;
                $where = null;
                if($modulo == 1){
                    $where['rxi_id_flu'] = $flujos_array['REQ_INV'];
                } else if($modulo == 2){
                    $where['rxi_id_flu'] = $flujos_array['REQ_COMP'];
                }
                if ($fecha_inicio != '' && $fecha_fin != '') {
                    $where['rxi_fecha >='] = date('Y-m-d', strtotime($fecha_inicio));
                    $where['rxi_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
                }
                if(trim($bodega) != "" && $modulo == 1){
                    $where['rxi_id_bod'] = $bodega;
                }
                $requisiciones = $this->inventario_model->get_reporte_requisiciones($where, $modulo);
                $data['requisiciones'] = $requisiciones;
                $data['tipo_reporte'] = 'grid';
                $html = $this->load->view('proyectos/reportes/imprimir_reporte_requisicion', $data, true);
                echo $html;
                die();
            }
        } else {
            $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
            $flujos_array = json_decode($flujos, true);
            $data['flu'] = $flujos_array['REQ_INV'];
            if(!(trim($flujos) != '' && trim($flujos_array['REQ_INV']) != '')){
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Atención", 'texto_alerta' => "Falta configuracion de parametro.");
                $this->session->set_flashdata($alerta);
                redirect('/proyectos/index');
            }
            $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, '', 'bod_id', true);
            $data['bodegas'] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $data['titulo_personal'] = "Reporte de requisiciones por bodega";
            $this->_cargarvista($data);
        }        
    }

    public function produccion_general($flag = null){
        satelite_validar();
        if ($_POST) {
            if ($flag) {
                $fecha_ini = $this->input->post('fecha_ini');
                $fecha_fin = $this->input->post('fecha_fin');
                $articulos = $this->input->post('articulos');
                $categoria = $this->input->post('categoria');
                $tipo_reporte = "";
            } else {
                $fecha_ini = $this->input->post('hdn_fec_ini');
                $fecha_fin = $this->input->post('hdn_fec_fin');
                $articulos = $this->input->post('hdn_article');
                $categoria = $this->input->post('hdn_categor');
                $tipo_reporte = $this->input->post('tipo_reporte');
            }
            $where['ord_estado >'] = 0;
            if ($fecha_ini != "" && $fecha_fin != "") {
                $where['DATE(ord_fecha) >='] = formatear_fecha('Y-m-d', $fecha_ini);
                $where['DATE(ord_fecha) <='] = formatear_fecha('Y-m-d', $fecha_fin);
            }
            if ($articulos != "") {
                if ($categoria != "") {
                    $where["(axo_id_art IN ($articulos) OR art_id_tia IN ($categoria))"] = null;
                } else {
                    $where["axo_id_art IN ($articulos)"] = null;
                }            
            } else {
                if ($categoria != "") {
                    $where["art_id_tia IN ($categoria)"] = null;
                }
            }
            $ordenes = $this->proyecto_model->get_ordenes_general($where);
            $data['ordenes'] = $ordenes;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['filename'] = 'reporte_produccion_general';
            $html = $this->load->view('proyectos/reportes/reporte_ordenes_general', $data, true);
            if ($flag) {
                $resultado = array('filas' => $html, 'cantidad' => count($ordenes));
                echo json_encode($resultado);
            } else {
                if ($tipo_reporte == 'excel') {
                    echo $html;
                } else {
                    $data['titulo'] = 'Producción General';
                    $header = $this->load->view('reporte/header', $data, true);
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'L', 'produccion_general', 'Letter');
                }
                
            }
            
        } else {
            $slc_art = "";
            $productos = $this->gsatelite->get_tabla('art_articulo', array('art_estado' => 1, 'art_produccion' => 1));
            $tias = implode(',', array_filter(array_unique(array_column($productos, 'art_id_tia'))));
            $tias = ($tias != "") ? $tias : 0;
            $slc_tia = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array("tia_estado" => 1, "tia_id IN ($tias)" => null), null, '', 'tia_id', true);
            foreach ($productos as $key => $value) {
                $slc_art .= '<option value="' . $value['art_id'] . '">' . $value['art_codigo'] . ' - ' . $value['art_nombre'] . '</option>';
            }
            $data['productos'] = $slc_art;
            $data['categoria'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $slc_tia);
            $data['titulo_personal'] = "Reporte de Producción General";
            $this->_cargarvista($data);
        }        
    }

    public function consumo_orden($flag = null){
        satelite_validar();
        if ($_POST) {
            $materias_primas = $gastos_indirectos = $mano_obra_directa =  $total_axos = $estima_mob = $estima_mpa = array();
            if ($flag) {
                $id_ord  = $this->input->post('orden');
                $reporte = "";
            } else {
                $id_ord  = $this->input->post('hdn_orden');
                $reporte = $this->input->post('tipo_reporte');
            }
            $detalle_mat_prim_orden = $this->proyecto_model->get_mp_axo(array('axo_id_ord' => $id_ord));
            foreach ($detalle_mat_prim_orden as $k1 => $val) {
                $materias_primas[$val['axm_id_art_materia']]['es_nueva'] = 1;
                $materias_primas[$val['axm_id_art_materia']]['se_uso'] = 1;
                $materias_primas[$val['axm_id_art_materia']]['axo'] = $val['axo_id'];
                $materias_primas[$val['axm_id_art_materia']]['costo_uni'] = $val['axm_precio'];
                $materias_primas[$val['axm_id_art_materia']]['uni_usada'] = $val['axm_cantidad'];
                $materias_primas[$val['axm_id_art_materia']]['nombre'] = $val['art_codigo'] . ' - ' . $val['art_nombre'];
                $materias_primas[$val['axm_id_art_materia']]['medida'] = $val['medida'];
                if (!(in_array($val['axo_id'], $total_axos))) {
                    $total_axos[] = $val['axo_id'];
                }
                if (!(array_key_exists($val['axm_id_art_materia'], $estima_mpa))) {
                    $estima_mpa[$val['axm_id_art_materia']]['costeo'] = $val['axm_estimacion_porcentaje'];
                    $estima_mpa[$val['axm_id_art_materia']]['monto'] = ($val['axm_precio'] * $val['axm_cantidad']);
                } 
            }
            $mat_prima_receta = $this->proyecto_model->get_mp_receta(array('ord_id' => $id_ord));
            foreach ($mat_prima_receta as $k2 => $vle) {
                if (array_key_exists($vle['mpa_id_art_materia'], $materias_primas)) {
                    $materias_primas[$vle['mpa_id_art_materia']]['es_nueva'] = 0;
                    $materias_primas[$vle['mpa_id_art_materia']]['uni_estim'] = ($vle['mpa_cantidad'] * $vle['axo_cantidad']);
                    if (array_key_exists($vle['mpa_id_art_materia'], $estima_mpa)) {
                        $estima_mpa[$vle['mpa_id_art_materia']]['receta'] = $vle['mpa_estimacion_porcentaje'];
                    }
                } else {
                    $materias_primas[$vle['mpa_id_art_materia']]['es_nueva'] = 0;
                    $materias_primas[$vle['mpa_id_art_materia']]['se_uso'] = 0;                    
                    $materias_primas[$vle['mpa_id_art_materia']]['axo'] = $vle['axo_id'];
                    $materias_primas[$vle['mpa_id_art_materia']]['uni_estim'] = ($vle['mpa_cantidad'] * $vle['axo_cantidad']);
                }
            }
            $mobd_orden = $this->proyecto_model->get_mob_axo(array('axo_id_ord' => $id_ord));
            foreach ($mobd_orden as $k3 => $vlm) {
                $mano_obra_directa[$vlm['mob_id']]['es_nueva'] = 1;
                $mano_obra_directa[$vlm['mob_id']]['se_uso'] = 1;
                $mano_obra_directa[$vlm['mob_id']]['axo'] = $vlm['axo_id'];
                $mano_obra_directa[$vlm['mob_id']]['costo_uni'] = $vlm['mxo_precio'];
                $mano_obra_directa[$vlm['mob_id']]['uni_usada'] = $vlm['mxo_cantidad'];
                $mano_obra_directa[$vlm['mob_id']]['nombre'] = $vlm['mob_codigo'] . ' - ' . $vlm['mob_nombre'];
                $mano_obra_directa[$vlm['mob_id']]['responsable'] = $vlm['responsable'];
                if (!(in_array($vlm['axo_id'], $total_axos))) {
                    $total_axos[] = $vlm['axo_id'];
                }
                if (!(array_key_exists($vlm['mob_id'], $estima_mob))) {
                    $estima_mob[$vlm['mob_id']]['costeo'] = $vlm['mxo_estimacion_porcentaje'];
                    $estima_mob[$vlm['mob_id']]['monto'] = ($vlm['mxo_precio'] * $vlm['mxo_cantidad']);
                } 
            }
            $mobd_receta = $this->proyecto_model->get_mob_receta(array('axo_id_ord' => $id_ord));
            foreach ($mobd_receta as $k4 => $vmr) {
                if (array_key_exists($vmr['mob_id'], $mano_obra_directa)) {
                    $mano_obra_directa[$vmr['mob_id']]['es_nueva'] = 0;
                    $mano_obra_directa[$vmr['mob_id']]['uni_estim'] = ($vmr['mob_calculo_etapa'] > 0) ? $vmr['suma_hora_etapa'] : ($vmr['moa_cantidad'] * $vmr['axo_cantidad']);
                    if (array_key_exists($vmr['mob_id'], $estima_mob)) {
                        $estima_mob[$vmr['mob_id']]['receta'] = $vmr['moa_estimacion_porcentaje'];
                    }
                } else {
                    $mano_obra_directa[$vmr['mob_id']]['es_nueva'] = 0;
                    $mano_obra_directa[$vmr['mob_id']]['se_uso'] = 0;                    
                    $mano_obra_directa[$vmr['mob_id']]['axo'] = $vmr['axo_id'];
                    $mano_obra_directa[$vmr['mob_id']]['uni_estim'] = ($vmr['mob_calculo_etapa'] > 0) ? $vmr['suma_hora_etapa'] : ($vmr['moa_cantidad'] * $vmr['axo_cantidad']);
                }
            }
            $gifs_orden = $this->proyecto_model->get_gif_axo(array('axo_id_ord' => $id_ord));
            foreach ($gifs_orden as $k5 => $val) {
                $gastos_indirectos[$val['esm_id']]['es_nueva'] = 1;
                $gastos_indirectos[$val['esm_id']]['se_uso'] = 1;
                $gastos_indirectos[$val['esm_id']]['axo'] = $val['axo_id'];
                $gastos_indirectos[$val['esm_id']]['monto_calculo'] = $val['exr_monto_calculo'];
                $gastos_indirectos[$val['esm_id']]['uni_usada'] = $val['exr_cantidad'];
                $gastos_indirectos[$val['esm_id']]['nombre'] = $val['esm_codigo'] . ' - ' . $val['esm_nombre'];
                $gastos_indirectos[$val['esm_id']]['tipo'] = $val['esm_tipo_calculo'];
                $gastos_indirectos[$val['esm_id']]['precio'] = $val['exr_precio'];
                if (!(in_array($val['axo_id'], $total_axos))) {
                    $total_axos[] = $val['axo_id'];
                }
            }
            $gifs_receta = $this->proyecto_model->get_gif_receta(array('axo_id_ord' => $id_ord));
            foreach ($gifs_receta as $k6 => $vgf) {
                if (array_key_exists($vgf['esm_id'], $gastos_indirectos)) {
                    $cantidad = ($vgf['esm_tipo_calculo'] > 0) ? ($vgf['esr_cantidad'] * $vgf['axo_cantidad']) : $vgf['esr_cantidad'];
                    $gastos_indirectos[$vgf['esm_id']]['es_nueva'] = 0;
                    $gastos_indirectos[$vgf['esm_id']]['uni_estim'] = ($vgf['esm_calculo_etapa'] > 0) ? $vgf['suma_hora_etapa'] : $cantidad;
                } else {
                    $cantidad = ($vgf['esm_tipo_calculo'] > 0) ? ($vgf['esr_cantidad'] * $vgf['axo_cantidad']) : $vgf['esr_cantidad'];
                    $gastos_indirectos[$vgf['esm_id']]['es_nueva'] = 0;
                    $gastos_indirectos[$vgf['esm_id']]['se_uso'] = 0;                    
                    $gastos_indirectos[$vgf['esm_id']]['axo'] = $vgf['axo_id'];
                    $gastos_indirectos[$vgf['esm_id']]['uni_estim'] = ($vgf['esm_calculo_etapa'] > 0) ? $vgf['suma_hora_etapa'] : $cantidad;
                }
            }
            $data['orden'] =  $this->proyecto_model->get_ordenes_general(array('ord_id' => $id_ord));
            $data['total_axos'] = $total_axos;
            $data['materias'] = $materias_primas;
            $data['mano_obra'] = $mano_obra_directa;
            $data['gastos_indirectos'] = $gastos_indirectos;
            $data['estimacion_mat'] = $estima_mpa;
            $data['estimacion_mob'] = $estima_mob;
            $data['tipo_reporte'] = $reporte;
            $data['mostrar_costo'] = 1;
            $data['filename'] = 'consumo_ord_' . $id_ord;
            $html = $this->load->view('proyectos/reportes/detalle_reporte_consumo', $data, true);
            if ($flag) {
                $resultado = array('filas' => $html, 'cantidad' => count($materias_primas));
                echo json_encode($resultado);
            } else {
                if ($reporte == 'pdf') {
                    $data['titulo'] = 'Consumo por Orden de Producción';
                    $header = $this->load->view('reporte/header', $data, true);
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'L', 'consumo_orden', 'Letter');
                } else {
                    echo $html;
                }
            }            
        } else {
            $data['titulo_personal'] = "Reporte de Consumo por Orden";
            $dropdown = $this->gsatelite->get_dropdown('tio_tipo_orden', '{tio_nombre}', 'tipo_orden', array('tio_estado' => 1), null, null, null, true);
            $data['tipo_orden'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $dropdown);
            $this->_cargarvista($data);
        }
    }

    public function rpt_prod_valor($flag = null){
        satelite_validar();
        if ($_POST) {
            $fecha_ini = ($flag) ? $this->input->post('txtFechaIni') : $this->input->post('hdn_fecha_ini');
            $fecha_fin = ($flag) ? $this->input->post('txtFechaFin') : $this->input->post('hdn_fecha_fin');
            $categoria = ($flag) ? $this->input->post('slcTipoProd') : $this->input->post('hdn_categoria');
            $tipo_reporte = ($flag) ? "" : $this->input->post('tipo_reporte');
            if ($fecha_ini != "" && $fecha_fin != "") {
                $where['DATE(moi_fecha_mov) >='] = formatear_fecha('Y-m-d', $fecha_ini);
                $where['DATE(moi_fecha_mov) <='] = formatear_fecha('Y-m-d', $fecha_fin);
            }
            if ($categoria != "") {
                $where['tia_id'] = $categoria;
            }
            $detalles =  $this->proyecto_model->get_produc_valorizada($where);
            $data['detalles'] = $detalles;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['filename'] = 'prod_valor_jb' . date('dmY_His');
            $data['periodo'] = 'Del ' . formatear_fecha('d-m-Y', $fecha_ini) . ' Al ' . formatear_fecha('d-m-Y', $fecha_fin);
            $html = $this->load->view('proyectos/reportes/detalle_prod_valor', $data, true);
            if ($flag) {
                $resultado = array('filas' => $html, 'cantidad' => count($detalles));
                echo json_encode($resultado);
            } else {
                if ($tipo_reporte == 'excel') {
                    echo $html;
                } else {
                    $data['titulo'] = 'Producción Mensual Valorizada';
                    $header = $this->load->view('reporte/header', $data, true);
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'L', 'consumo_orden', 'Letter');
                }                
            }
        } else {
            $this->db->join('art_articulo', 'tia_id = art_id_tia');
            $dropdown = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('art_produccion' => 1, 'art_materia_prima' => 0, 'art_estado' => 1, 'tia_estado' => 1), null, null, null, true);
            $data['cat_pro'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $dropdown);
            $data['titulo_personal'] = "Reporte de Producción Valorizada";
            $this->_cargarvista($data);
        }
        
    }

    /**
    * Descripción:
    * Reporte de programacion en produccion
    * @author Marlon Olmedo - Grupo Satélite
    * @since 2020-06-26
    * @param ninguno
    * @return Obtener los padres de las actividades especificas
    */  
    function rep_produccion_detallada($datas = null){
        satelite_validar();
        if ($datas == null) {
            $permisos = $this->gsatelite->get_permisos_opcion();
        }
        if($_POST) {
            // var_dump($_POST);die();
            $fecha_desde  = $this->input->post("txt_fecha_ini");
            $fecha_hasta  = $this->input->post("txt_fecha_fin");
            $tipo_reporte = ($this->input->post("tipo_reporte") != '') ? $this->input->post("tipo_reporte") : '';
            $programacion = ($this->input->post("txt_progra_id") != '') ? $this->input->post("txt_progra_id") : '';
            $filtro_progr = (is_array($this->input->post("filtro_progra")) && count($this->input->post("filtro_progra")) > 0) ? $this->input->post("filtro_progra") : array();
            if ($tipo_reporte != "") {
                $filtro_progr = (trim($this->input->post("filtro_progra")) != "") ? explode(',', $this->input->post("filtro_progra")) : array();
            }

            $where = null;                        
            if ($fecha_desde != '' && $fecha_hasta != '') {
                $where['DATE(dpg_fecha) >=']  = date_format(date_create($fecha_desde),'Y-m-d');
                $where['DATE(dpg_fecha) <=']  = date_format(date_create($fecha_hasta),'Y-m-d');
            }
            if ($programacion != "") {
                $where['dpp_id_ppd'] = $programacion;
            }
            if (count($filtro_progr) > 0) {
                $ppds = implode(',', $filtro_progr);
                $where["dpp_id_ppd IN ($ppds)"] = null;
            }            
            $info = '';
            $this->db->join('emp_empleado', 'opr_id_emp = emp_id', "left");
            $operarios = $this->gsatelite->get_tabla('opr_operario', array('opr_estado' => 1));

            $earlier = new DateTime("$fecha_desde");
            $later = new DateTime("$fecha_hasta");

            $diff = $later->diff($earlier)->format("%a");
            foreach ($operarios as $key => $value) { 
                $detalle_progra = "";
                $where["dpo_id_opr"] = $value["opr_id"];
                $cantidad = 0;
                for ($i=0; $i <= $diff; $i++) {
                    $dia_a_dia = date("Y-m-d",strtotime($fecha_desde."+ $i days"));
                    $where["DATE(dpg_fecha)"] = $dia_a_dia;
                    $datos = $this->proyecto_model->get_detalle_programacion($where);
                    $detalle_progra[$dia_a_dia] = $datos;
                    $cantidad = (count($datos) > $cantidad) ? count($datos) : $cantidad;
                }
                $nombre_oprerio = $value["emp_nombre"]." ".$value["emp_apellido"];
                $info[$key] = array("operario" => $nombre_oprerio,
                                    "info_operario" => $detalle_progra,
                                    "cantidad" => $cantidad);
            }
            $data["fecha_desde"] = $fecha_desde;
            $data["fecha_hasta"] = $fecha_hasta;
            $data['dias']           = $diff;
            $data['info']           = $info;
            $data['programacion']   = $programacion;
            $filename               = 'Reporte_prod_semanal_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']       = $filename;
            $data['tipo_reporte']   = $tipo_reporte;
            $data['titulo']         = 'Reporte semanal detallado';
            $html                   = $this->load->view('proyectos/reportes/grid_rep_produccion_detall_seman',$data,true);
            // echo $html;
            // die();
            if ($tipo_reporte == '') {
                $data['html'] = $html;
                echo json_encode(array("html" => $html));
                die();
            } elseif ($tipo_reporte == 'pdf') {
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_costo_venta_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'reporte_costo_promedio_producto', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                $data['excel']          = 1;
                echo $html;
                die();
            }
            
        } else {
            //$data['categorias']      = $this->gsatelite->get_tabla('tia_tipo_articulo',"tia_padre is null and tia_estado = 1");
            $data["prgfiltro"] = 1;
            if ($datas != null) {
                $data["fecha_ini"] = $datas["fecha_ini"];
                $data["fecha_fin"] = $datas["fecha_fin"];
                $data["progra_id"] = $datas["progra_id"];
                $data["prgfiltro"] = $datas["filtro"];
            }
            $data['titulo_personal'] = 'Reporte de Producción Detallada';
            //$this->_cargarvista($data);
            cargarvista($data, 0, 'proyectos/reportes/rep_produccion_detall_seman');
        }
    }

    /**
    * Descripción:
    * Reporte de Comparativo de Costo  Planeado Vrs. Real, por Orden de fabricación
    * @author Marlon Olmedo - Grupo Satélite
    * @since 2020-06-29
    * @param ninguno
    * @return Obtener los los costos segun receta y costeo
    */  
    function proco_x_of($sin_costo=null){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        
        if($_POST) {
            //print_r($_POST);die();
            $fecha_desde = formatear_fecha("Y-m-d",$this->input->post("txt_fecha_ini"));
            $fecha_hasta = formatear_fecha("Y-m-d",$this->input->post("txt_fecha_fin"));
            $orden   = ($this->input->post("slc_orden") != '') ? $this->input->post("slc_orden") : null;
            $tipo_reporte   = ($this->input->post("tipo_reporte") != '') ? $this->input->post("tipo_reporte") : '';
            $sin_costo_p   = $this->input->post("sin_costo");

            $where          = null;                        
            if ($fecha_desde != '' && $fecha_hasta != '') {
                $where["date(ord_fecha) BETWEEN '$fecha_desde' and '$fecha_hasta'"]  = NULL;
            }
            if ($orden != null) {
                $where["ord_id"]  = $orden;
            }
            
            $ordenes = $this->proyecto_model->get_art_cant_real($where);

            foreach ($ordenes as $key => $value) { 
                $axo_id = $value["axo_id"];
                $art_id = $value["axo_id_art"];
                $componentes = $this->proyecto_model->get_rec_x_cost_ord($axo_id,$art_id,NULL,"art_id",1);
                $mano_obra = $this->proyecto_model->get_rec_x_cost_ord($axo_id,$art_id,NULL,"mob_id",2);
                $viaticos = $this->proyecto_model->get_rec_x_cost_ord($axo_id,$art_id,NULL,"esm_id",3);
               
                $ordenes[$key]["componentes"] = $componentes;
                $ordenes[$key]["mano_obra"] = $mano_obra;
                $ordenes[$key]["viaticos"] = $viaticos;
            }

            if ($sin_costo != null) {
                $data["sin_costo"] = $sin_costo;
            } else {
                $data["sin_costo"] = 0;
            }

            $data["fecha_desde"] = $fecha_desde;
            $data["fecha_hasta"] = $fecha_hasta;
            
            $data['info']           = $ordenes;
            if ($sin_costo != null) {
                $filename = ' Comparativo_Costo_C_C_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            } else {
                $filename = 'Comparativo_Costo_S_C_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            }
            
            $data['filename']       = $filename;
            $data['tipo_reporte']   = $tipo_reporte;
            $data['titulo']         = 'semana detallado';
            $data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
            $html                   = $this->load->view('proyectos/reportes/grid_procox_of',$data,true);
            // echo $html;
            // die();
            if ($tipo_reporte == '') {
                $data['html'] = $html;
                echo json_encode(array("html" => $html));
                die();
            } elseif ($tipo_reporte == 'pdf') {
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_costo_venta_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'reporte_costo_promedio_producto', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                $data['excel']          = 1;
                echo $html;
                die();
            }
            
        } else {

            if ($sin_costo != null) {
                $data["sin_costo"] = $sin_costo;
            } else {
                $data["sin_costo"] = 0;
            }
            $dropdown = $this->gsatelite->get_dropdown('ord_orden', '{ord_codigo} - {ord_concepto}', '', array('ord_estado' => 1), null, null, "ord_id", true);
            $data['orden'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $dropdown);
            $data['titulo_personal'] = 'Reporte de producción costeado por Orden de fabricación';
            
            cargarvista($data, 0, 'proyectos/reportes/proco_x_of');
        }
    }

    /**
    * Descripción:
    * Reporte de Comparativo de Costo  sin costo 
    * @author Marlon Olmedo - Grupo Satélite
    * @since 2020-06-29
    * @param ninguno
    * @return Obtener la funcion con diferentes campos activos
    */  
    function proco_x_of_sin_cost(){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $this->proco_x_of(1);
    }

    /**
    * Descripción:
    * Reporte de Comparativo de Costo  Planeado Vrs. Real, por Orden de fabricación
    * @author Marlon Olmedo - Grupo Satélite
    * @since 2020-06-29
    * @param ninguno
    * @return Obtener los los costos segun receta y costeo
    */  
    function producto_costeo($sin_costo=null){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        
        if($_POST) {
            //print_r($_POST);die();
            $fecha_desde = formatear_fecha("Y-m-d",$this->input->post("txt_fecha_ini"));
            $fecha_hasta = formatear_fecha("Y-m-d",$this->input->post("txt_fecha_fin"));
            $caracteristica = $this->input->post("slc_caracteristica");
            $tipo_reporte   = ($this->input->post("tipo_reporte") != '') ? $this->input->post("tipo_reporte") : '';

            $where          = null;                        
            if ($fecha_desde != '' && $fecha_hasta != '') {
                $where["date(ord_fecha) BETWEEN '$fecha_desde' and '$fecha_hasta'"]  = NULL;
            }
            if ($caracteristica != null) {
                $where["art_id_tia"]  = $caracteristica;
            }
            
            $ordenes = $this->proyecto_model->get_art_cant_real($where);
            //print_r($this->db->last_query());die();

            $data["fecha_desde"] = $fecha_desde;
            $data["fecha_hasta"] = $fecha_hasta;
            
            $data['info']           = $ordenes;
            $filename               = 'producción_Costeado' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']       = $filename;
            $data['tipo_reporte']   = $tipo_reporte;
            $data['titulo']         = 'Producción Costeado';
            $data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
            $html                   = $this->load->view('proyectos/reportes/grid_producto_costeo',$data,true);
            // echo $html;
            // die();
            if ($tipo_reporte == '') {
                $data['html'] = $html;
                echo json_encode(array("html" => $html));
                die();
            } elseif ($tipo_reporte == 'pdf') {
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Producción_Costeado' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Producción_Costeado', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                $data['excel']          = 1;
                echo $html;
                die();
            }
            
        } else {

            $dropdown = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => 1), null, null, "tia_id", true);
            $data['caracteristica'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $dropdown);
            $data['titulo_personal'] = 'Reporte de producción costeado';
            
            cargarvista($data, 0, 'proyectos/reportes/producto_costeo');
        }
    }

    public function get_programaciones_fechas(){
        $select = '<option value=""></option>';
        $fecha_desde = formatear_fecha("Y-m-d", $this->input->post("fecha_ini"));
        $fecha_hasta = formatear_fecha("Y-m-d", $this->input->post("fecha_fin"));
        $where = array('ppd_estado' => 1, 'DATE(ppd_fecha_inicio) >=' => $fecha_desde, 'DATE(ppd_fecha_inicio) <=' => $fecha_hasta);
        $programaciones = $this->gsatelite->get_tabla('ppd_programacion_produccion', $where);
        foreach ($programaciones as $key => $value) {
            $select .= '<option value="' . $value['ppd_id'] .  '">#' . $value['ppd_id'] . ' (' . $value['ppd_concepto'] . ')</option>';
        }
        echo $select;
    }


    /**
    * Descripción: Hoja de Trabajo
    * @author Raul E.
    * @since Ago - 2020
    * @return Ficha con detalles de la produccion
    */  
    public function hoja_trabajo(){
        satelite_validar();
        if ($_POST) {
            $respuesta = "";
            $fecha_desde = formatear_fecha("Y-m-d", $this->input->post("fecha_ini"));
            $fecha_hasta = formatear_fecha("Y-m-d", $this->input->post("fecha_fin"));
            $cliente = $this->input->post("cliente");
            $where['ord_estado'] = 1;
            if ($fecha_desde != "" && $fecha_hasta != "") {
                $where['DATE(ord_fecha) >='] = $fecha_desde;
                $where['DATE(ord_fecha) <='] = $fecha_hasta;
            }
            if ($cliente != "") {
                $where['ord_id_cli'] = $cliente;
            }
                       $this->db->order_by('ord_fecha DESC');
                       $this->db->join('cli_cliente', 'cli_id = ord_id_cli', 'left');
            $ordenes = $this->gsatelite->get_tabla('ord_orden', $where);
            if (count($ordenes) > 0) {
                foreach ($ordenes as $key => $value) {
                    $respuesta .= '<tr><td>' . $value['ord_codigo'] . '</td><td>' . formatear_fecha('d-m-Y', $value['ord_fecha']) . '</td><td>'; 
                    $respuesta .= ($value['cli_personeria'] > 1) ? $value['cli_apellido'] : $value['cli_nombre'] . ' ' .  $value['cli_apellido'];
                    $respuesta .= '</td><td style="text-align: center;"><a href="' . base_url('proyectos/procesos/hoja_trabajo_op/'.$value['ord_id']) . '" target="_blank" ';
                    $respuesta .= 'class="btn btn-info"><span class="icomoon-icon-printer-3">Imprimir Hoja de Trabajo</span></a></td></tr>';
                }
            } else {
                $respuesta .= '<tr><td colspan="4" style="text-align: center;"><b>No se encontraron registros.</b></td></tr>';
            }
            echo $respuesta;
            die();
        } else {
            $data['titulo_personal'] = "Hoja de Trabajo por Orden";
            $this->_cargarvista($data);
        }
        
    }

    /**
    * Descripción:
    * Reporte de Ordenes Finalizadas 
    * @author Raul E.
    * @since Ago - 2020
    * @return Reporte con el detalle del cierre de las ordenes de produccion
    */  
    public function ordenes_finalizadas($flag = null){
        satelite_validar();
        if ($_POST) {
            if ($flag) {
                $cliente = $this->input->post("cliente");
                $fecha_desde = $this->input->post("fecha_ini");
                $fecha_hasta = $this->input->post("fecha_fin");
                $tipo_reporte = $this->input->post("tipo_reporte");
            } else {
                $cliente = $this->input->post("hdn_cliente");
                $fecha_desde = $this->input->post("hdn_fec_ini");
                $fecha_hasta = $this->input->post("hdn_fec_fin");
                $tipo_reporte = $this->input->post("tipo_reporte");
            }            
            $where['ord_estado'] = 2;
            if ($fecha_desde != "" && $fecha_hasta != "") {
                $where['DATE(ord_fecha_ejecucion) >='] = formatear_fecha('Y-m-d', $fecha_desde);
                $where['DATE(ord_fecha_ejecucion) <='] = formatear_fecha('Y-m-d', $fecha_hasta);
            }
            if ($cliente != "") {
                $where['ord_id_cli'] = $cliente;
            }
            $data['filename'] = 'reporte_orden_finalizada' . date('dmY_His');
            $data['tipo_reporte'] = $tipo_reporte;
            $data['datos'] = $this->proyecto_model->get_rpt_ordenes_finalizadas($where,'ord_id, axo_id');
            $html = $this->load->view('proyectos/reportes/reporte_ordenes_finalizadas', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Ordenes Finalizadas';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_Ordenes_Finalizadas' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'P', 'Reporte_Ordenes_Finalizadas', 'Letter');
                } else {
                    echo $html;
                }                
            }
            
        } else {
            $data['titulo_personal'] = "Reporte de Ordenes Finalizadas";
            $this->_cargarvista($data);
        }
        
    }

    /**
    * Descripción:
    * Reporte de Ordenes Finalizadas 
    * @author Raul E.
    * @since Ago - 2020
    * @return Reporte con el detalle del cierre de las ordenes de produccion
    */  
    public function pruebas_control_calidad($ord_id = null){
        satelite_validar();
        if ($ord_id) {
            $where['ord_id'] = $ord_id;
            $pruebas_realizadas = $this->proyecto_model->get_rpt_pruebas_calidad($where);
            $data['pruebas'] = $pruebas_realizadas;
            $html = $this->load->view('proyectos/reportes/detalle_reporte_control_calidad', $data, true);
            $data['titulo'] = 'Pruebas de Control de Calidad';
            $header = $this->load->view('reporte/header', $data, true);
            $GLOBALS['nombre_reporte'] = 'Reporte_Control_Calidad';
            $reporte = $header . $html;
            $this->pdf->makePdf($reporte, 'L', 'Reporte_Control_Calidad', 'Letter');            
        }        
    }

    public function cantidad_consumo_orden($flag = null){
        satelite_validar();
        if ($_POST) {
            $materias_primas = $gastos_indirectos = $mano_obra_directa =  $total_axos = array();
            if ($flag) {
                $id_ord  = $this->input->post('orden');
                $reporte = "";
            } else {
                $id_ord  = $this->input->post('hdn_orden');
                $reporte = $this->input->post('tipo_reporte');
            }
            $detalle_mat_prim_orden = $this->proyecto_model->get_mp_axo(array('axo_id_ord' => $id_ord));
            foreach ($detalle_mat_prim_orden as $k1 => $val) {
                $materias_primas[$val['axm_id_art_materia']]['es_nueva'] = 1;
                $materias_primas[$val['axm_id_art_materia']]['se_uso'] = 1;
                $materias_primas[$val['axm_id_art_materia']]['axo'] = $val['axo_id'];
                $materias_primas[$val['axm_id_art_materia']]['costo_uni'] = $val['axm_precio'];
                $materias_primas[$val['axm_id_art_materia']]['uni_usada'] = $val['axm_cantidad'];
                $materias_primas[$val['axm_id_art_materia']]['nombre'] = $val['art_codigo'] . ' - ' . $val['art_nombre'];
                $materias_primas[$val['axm_id_art_materia']]['medida'] = $val['medida'];
                if (!(in_array($val['axo_id'], $total_axos))) {
                    $total_axos[] = $val['axo_id'];
                }
            }
            $mat_prima_receta = $this->proyecto_model->get_mp_receta(array('ord_id' => $id_ord));
            foreach ($mat_prima_receta as $k2 => $vle) {
                if (array_key_exists($vle['mpa_id_art_materia'], $materias_primas)) {
                    $materias_primas[$vle['mpa_id_art_materia']]['es_nueva'] = 0;
                    $materias_primas[$vle['mpa_id_art_materia']]['uni_estim'] = ($vle['mpa_cantidad'] * $vle['axo_cantidad']);
                } else {
                    $materias_primas[$vle['mpa_id_art_materia']]['es_nueva'] = 0;
                    $materias_primas[$vle['mpa_id_art_materia']]['se_uso'] = 0;                    
                    $materias_primas[$vle['mpa_id_art_materia']]['axo'] = $vle['axo_id'];
                    $materias_primas[$vle['mpa_id_art_materia']]['uni_estim'] = ($vle['mpa_cantidad'] * $vle['axo_cantidad']);
                }
            }
            $mobd_orden = $this->proyecto_model->get_mob_axo(array('axo_id_ord' => $id_ord));
            foreach ($mobd_orden as $k3 => $vlm) {
                $mano_obra_directa[$vlm['mob_id']]['es_nueva'] = 1;
                $mano_obra_directa[$vlm['mob_id']]['se_uso'] = 1;
                $mano_obra_directa[$vlm['mob_id']]['axo'] = $vlm['axo_id'];
                $mano_obra_directa[$vlm['mob_id']]['costo_uni'] = $vlm['mxo_precio'];
                $mano_obra_directa[$vlm['mob_id']]['uni_usada'] = $vlm['mxo_cantidad'];
                $mano_obra_directa[$vlm['mob_id']]['nombre'] = $vlm['mob_codigo'] . ' - ' . $vlm['mob_nombre'];
                $mano_obra_directa[$vlm['mob_id']]['responsable'] = $vlm['responsable'];
                if (!(in_array($vlm['axo_id'], $total_axos))) {
                    $total_axos[] = $vlm['axo_id'];
                }
            }
            $mobd_receta = $this->proyecto_model->get_mob_receta(array('axo_id_ord' => $id_ord));
            foreach ($mobd_receta as $k4 => $vmr) {
                if (array_key_exists($vmr['mob_id'], $mano_obra_directa)) {
                    $mano_obra_directa[$vmr['mob_id']]['es_nueva'] = 0;
                    $mano_obra_directa[$vmr['mob_id']]['uni_estim'] = ($vmr['mob_calculo_etapa'] > 0) ? $vmr['suma_hora_etapa'] : ($vmr['moa_cantidad'] * $vmr['axo_cantidad']);
                } else {
                    $mano_obra_directa[$vmr['mob_id']]['es_nueva'] = 0;
                    $mano_obra_directa[$vmr['mob_id']]['se_uso'] = 0;                    
                    $mano_obra_directa[$vmr['mob_id']]['axo'] = $vmr['axo_id'];
                    $mano_obra_directa[$vmr['mob_id']]['uni_estim'] = ($vmr['mob_calculo_etapa'] > 0) ? $vmr['suma_hora_etapa'] : ($vmr['moa_cantidad'] * $vmr['axo_cantidad']);
                }
            }
            $gifs_orden = $this->proyecto_model->get_gif_axo(array('axo_id_ord' => $id_ord));
            foreach ($gifs_orden as $key => $val) {
                $gastos_indirectos[$val['esm_id']]['es_nueva'] = 1;
                $gastos_indirectos[$val['esm_id']]['se_uso'] = 1;
                $gastos_indirectos[$val['esm_id']]['axo'] = $val['axo_id'];
                $gastos_indirectos[$val['esm_id']]['monto_calculo'] = $val['exr_monto_calculo'];
                $gastos_indirectos[$val['esm_id']]['uni_usada'] = $val['exr_cantidad'];
                $gastos_indirectos[$val['esm_id']]['nombre'] = $val['esm_codigo'] . ' - ' . $val['esm_nombre'];
                $gastos_indirectos[$val['esm_id']]['tipo'] = $val['esm_tipo_calculo'];
                $gastos_indirectos[$val['esm_id']]['precio'] = $val['exr_precio'];
                if (!(in_array($val['axo_id'], $total_axos))) {
                    $total_axos[] = $val['axo_id'];
                }
            }
            $gifs_receta = $this->proyecto_model->get_gif_receta(array('axo_id_ord' => $id_ord));
            foreach ($gifs_receta as $k6 => $vgf) {
                if (array_key_exists($vgf['esm_id'], $gastos_indirectos)) {
                    $cantidad = ($vgf['esm_tipo_calculo'] > 0) ? ($vgf['esr_cantidad'] * $vgf['axo_cantidad']) : $vgf['esr_cantidad'];
                    $gastos_indirectos[$vgf['esm_id']]['es_nueva'] = 0;
                    $gastos_indirectos[$vgf['esm_id']]['uni_estim'] = ($vgf['esm_calculo_etapa'] > 0) ? $vgf['suma_hora_etapa'] : $cantidad;
                } else {
                    $cantidad = ($vgf['esm_tipo_calculo'] > 0) ? ($vgf['esr_cantidad'] * $vgf['axo_cantidad']) : $vgf['esr_cantidad'];
                    $gastos_indirectos[$vgf['esm_id']]['es_nueva'] = 0;
                    $gastos_indirectos[$vgf['esm_id']]['se_uso'] = 0;                    
                    $gastos_indirectos[$vgf['esm_id']]['axo'] = $vgf['axo_id'];
                    $gastos_indirectos[$vgf['esm_id']]['uni_estim'] = ($vgf['esm_calculo_etapa'] > 0) ? $vgf['suma_hora_etapa'] : $cantidad;
                }
            }
            $data['orden'] =  $this->proyecto_model->get_ordenes_general(array('ord_id' => $id_ord));
            $data['total_axos'] = $total_axos;
            $data['materias'] = $materias_primas;
            $data['mano_obra'] = $mano_obra_directa;
            $data['gastos_indirectos'] = $gastos_indirectos;
            $data['estimacion_mat'] = array();
            $data['estimacion_mob'] = array();
            $data['tipo_reporte'] = $reporte;
            $data['mostrar_costo'] = 0;
            $data['filename'] = 'consumo_ord_' . $id_ord;
            $html = $this->load->view('proyectos/reportes/detalle_reporte_consumo', $data, true);
            if ($flag) {
                $resultado = array('filas' => $html, 'cantidad' => count($materias_primas));
                echo json_encode($resultado);
            } else {
                if ($reporte == 'pdf') {
                    $data['titulo'] = 'Consumo por Orden de Producción';
                    $header = $this->load->view('reporte/header', $data, true);
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'L', 'consumo_orden', 'Letter');
                } else {
                    echo $html;
                }
            }
        } else {
            $data['titulo_personal'] = "Reporte de Consumo por Orden";
            $dropdown = $this->gsatelite->get_dropdown('tio_tipo_orden', '{tio_nombre}', 'tipo_orden', array('tio_estado' => 1), null, null, null, true);
            $data['tipo_orden'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $dropdown);
            $this->_cargarvista($data);
        }
    }    

    /**
    * Descripción:
    * Reporte de Job tracking
    * @author Raul E.
    * @since Ago - 2020
    * @return Reporte con el detalle del job tracking en ordenes activas
    */  
    public function rptjob_tracking($flag = null){
        satelite_validar();
        if ($_POST) {
            if ($flag) {
                $orden = $this->input->post('orden');
                $etapa = $this->input->post('etapa');
                $f_ini = $this->input->post('f_ini');
                $f_fin = $this->input->post('f_fin');
                $tipo_reporte = "";
            } else {
                $orden = $this->input->post('hdn_orden');
                $etapa = $this->input->post('hdn_etapa');
                $f_ini = $this->input->post('hdn_fecha_ini');
                $f_fin = $this->input->post('hdn_fecha_fin');
                $tipo_reporte = $this->input->post('tipo_reporte');
            }
            $where['ord_estado'] = 1;
            $having['exo_cantidad >= '] = 0;
            if ($orden != "") {
                $where["ord_id IN ($orden)"] = null;
            }
            if ($etapa) {
                $having['exo_id_etp'] = $etapa;
            }
            if ($f_ini != "") {
                $where['DATE(ord_fecha) >= '] = formatear_fecha('Y-m-d', $f_ini);
            }
            if ($f_fin != "") {
                $where['DATE(ord_fecha) <= '] = formatear_fecha('Y-m-d', $f_fin);
            }
            $detalles = $this->proyecto_model->get_rpt_job_tracking($where, $having);
            $data['tipo_reporte'] = $tipo_reporte;
            $data['detalles'] = $detalles;
            $data['filename'] = 'rpt_job_tracking_' . date('dmY_His');
            $html = $this->load->view('proyectos/reportes/detalle_reporte_job_tracking', $data, true);
            if ($flag) {
                $resultado = array('filas' => $html, 'cantidad' => count($detalles));
                echo json_encode($resultado);
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Job Tracking de Ordenes Activas';
                    $header = $this->load->view('reporte/header', $data, true);
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'L', 'jobtracking_orden', 'Letter');
                } else {
                    echo $html;
                }
            }
        } else {
            $data['titulo_personal'] = "Reporte de Job Tracking";
            $dropdown = $this->gsatelite->get_dropdown('ord_orden', 'Orden #{ord_codigo}', '', array('ord_estado' => 1), null, null, null, true);
            $drop_eta = $this->gsatelite->get_dropdown('etp_etapa', '{etp_nombre}', '', array('etp_estado' => 1), null, null, null, true);
            $data['ordenes'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $dropdown);
            $data['etapas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $drop_eta);
            $this->_cargarvista($data);
        }
    }

    /*
    *  Raul E. 
    */
    public function costeo_receta($flag = null){
        satelite_validar();
        if ($_POST) {
            $art_id = $this->input->post('producto');
            $report = $this->input->post('tipo_reporte');
            $materia_prima = $this->proyecto_model->get_materia_prima_producto_segun_receta(array('mpa_id_art' => $art_id));
            $mano_obra_dir = $this->cotModel->get_mano_obra_presupuesto(array('moa_id_art' => $art_id));
            $gastos_indirc = $this->cotModel->get_gastos_indirectos_presupuesto(array('esr_id_art' => $art_id));
            if (!(count($materia_prima) > 0) && !(count($mano_obra_dir) > 0) && !(count($gastos_indirc) > 0)) {
                $data['vacio'] = 1;
                $filas = 0;
            } else {
                $data['vacio'] = 0;
                $data['mat_prima'] = $materia_prima;
                $data['mano_obra'] = $mano_obra_dir;
                $data['otros_gts'] = $gastos_indirc;
                $filas = count($materia_prima) + count($mano_obra_dir) + count($gastos_indirc);
            }
                                  $this->db->limit(1);
                                  $this->db->join('cva_conversion_articulo', 'cva_id_mep = mep_id');
            $data['cva_medida'] = $this->gsatelite->get_campo('mep_medida_producto', 'mep_nombre', array('cva_id_art' => $art_id, 'cva_defecto' => 1, 'cva_estado' => 1));
            $data['articulo'] = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $art_id));
            $data['reporte'] = $report;
            $data['filename'] = 'Costeo_Producto';
            $data['decimal'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            $html = $this->load->view('proyectos/reportes/informe_costeo_receta', $data, true);
            if ($flag) {
                $resultado = array('filas' => $html, 'cantidad' => $filas);
                echo json_encode($resultado);
                die();
            } else {
                if ($report == 'pdf') {
                    $data['titulo'] = 'Costeo de Producto';
                    $header = $this->load->view('reporte/header', $data, true);
                    $reporte = $header . $html;
                    $GLOBALS['nombre_reporte'] = 'rpt_costeo_producto' . date('dmY');
                    $this->pdf->makePdf($reporte, 'L', 'costeo_producto', 'Letter');
                } else {
                    echo $html;
                }
            }
        } else {
            $data['titulo_personal'] = "Costeo de Producto";
            $this->_cargarvista($data);
        }
    }

}//END CLASS
?>
