<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Procesos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('proyecto_model');
        $this->load->model('inventario_model');
        $this->load->model('planilla_model');
        $this->load->model('desarrollo_model');
        $this->load->model('personal_model');
        $this->load->model('compras_model');
        $this->load->model('gsatelite');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
        $this->load->model('cotizaciones_model', 'cotModel');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function orden_produccion($reporte = null) {
        satelite_validar();
        $con_lot_aut   = [];
        $con_anula_aut = [];
        $etapa_final   = [];
        $tipo_reporte  = $this->input->post('tipo_reporte');
        $estadox       = $this->input->post('SlcEstado');

        /*Filtros Cliente, fehca iniico, fecha fin*/
        $this->db->group_by('cli_id');
        $this->db->join('cli_cliente', 'ord_id_cli = cli_id');
        $data['clientes'] = $this->gsatelite->get_tabla('ord_orden', array('cli_estado' => 1));
        $where = array();
        //Verificacion de valores filtro
        $cliente = ($this->input->post('slcFiltro')) ? $this->input->post('slcFiltro') : '' ;
        $fecha_inicio = ($this->input->post('txtFechaIni')) ? $this->input->post('txtFechaIni') : '' ;
        $fecha_fin = ($this->input->post('txtFechaFin')) ? $this->input->post('txtFechaFin') : '' ;
        //Asignacion de filtros
        if($fecha_inicio){
            $where['ord_fecha_creacion >='] = formatear_fecha('Y-m-d H:i:s', $fecha_inicio);
            $data['fecha_inicio'] = $fecha_inicio;
        }
        if($fecha_fin){
            $where['ord_fecha_creacion <='] = formatear_fecha('Y-m-d H:i:s', $fecha_fin.' 23:59:59');
            $data['fecha_fin'] = $fecha_fin;
        }
        if($cliente){
            $where['cli_id ='] = $cliente;
        }

        if($estadox != ''){
            $where['ord_estado ='] = $estadox;
        }

        if ($this->input->post() && $reporte != 1) {
            // All your code goes here
            $estado = array();
            $data['ordenes'] = $this->proyecto_model->get_ordenes($where);
            foreach ($data['ordenes'] as $key => $ord) {
                $tiene = $this->proyecto_model->get_tiene_lote(array('axo_id_ord' => $ord['ord_id']));
                $tiene = (count($tiene) > 0) ? true : false ;
                array_push($con_lot_aut, $tiene);

                $cantidad_val = $this->proyecto_model->get_tracking_movimiento_moi(array('ord_id'=>$ord['ord_id']));
                $tiene_moi = (trim($cantidad_val[0]['cantidad']) > 0)?true: false;
                array_push($con_anula_aut, $tiene_moi);

                $totales_etapa = $this->proyecto_model->get_etapas_producto_orden_estado(array('ord_id'=>$ord['ord_id'],'exo_fin' => 1));
                //suma de envios
                $exos = $this->proyecto_model->get_etapas_producto_orden_board(array('ord_id'=>$ord['ord_id']));
                $exo_inicio = array_shift($exos);
                $exo_fin    = end($exos);
                if ( ($exo_inicio['exo_id'] != '') && ($exo_fin['exo_id'] != '')) {
                      $suma_en    = $this->proyecto_model->sumar_envios(array('moe_id_exo >=' => $exo_inicio['exo_id'], 'moe_id_exo <=' => $exo_fin['exo_id'], 'moe_id_moi <>'=> ''));
                }

                
                $a = $totales_etapa[0]['sum_exo_cantidad'];
                $b = $totales_etapa[0]['sum_lop_cant'];
                if ( ($a !='') && ($b != '') && ($suma_en->total != '') ) {
                    if(($a == $b) && ($a == $suma_en->total) && ($b == $suma_en->total) ){
                    $est = true;
                    $estado[] = $est;
                    }else{
                        $est = false;
                        $estado[] = $est;
                    } 
                }else $estado[] = null;
                              
                
            }
            //print_r($cantidad_val); die();exit();
            $data['con_anula_aut'] = $con_anula_aut;
            $data['estados'] = $estado;
            $data['con_lot_aut'] = $con_lot_aut;
            $data['titulo_personal'] = "Ordenes de producción";
            $this->_cargarvista($data);
            die();
        }else{
            //print_r($data); die();
            $cliente = ($this->input->post('hslcFiltro')) ? $this->input->post('hslcFiltro') : '' ;
            $fecha_inicio = ($this->input->post('htxtFechaIni')) ? $this->input->post('htxtFechaIni') : '' ;
            $fecha_fin = ($this->input->post('htxtFechaFin')) ? $this->input->post('htxtFechaFin') : '' ;

            if($fecha_inicio){
                $where['ord_fecha_creacion >='] = formatear_fecha('Y-m-d H:i:s', $fecha_inicio);
                $data['fecha_inicio'] = $fecha_inicio;
            }
            if($fecha_fin){
                $where['ord_fecha_creacion <='] = formatear_fecha('Y-m-d H:i:s', $fecha_fin);
                $data['fecha_fin'] = $fecha_fin;
            }
            if($cliente){
                $where['cli_id ='] = $cliente;
            }
            $data['ordenes'] = $this->proyecto_model->get_ordenes($where);
            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_orden_produccion' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['titulo'] = 'Ordenes de Producción';
            // trae el id del cliente por defecto para preseleccionarlo en el select de cliente
            $a = $this->gsatelite->get_parametro('SYS_CLIENTE_DEFECTO',1,1);
            $data['cliente_defecto_op'] = $a->par_default;
            //$data['titulo_personal'] = "Ordenes de producción";
            $html = $this->load->view("proyectos/procesos/reporte_orden_produccion", $data, TRUE);

            if ($tipo_reporte == 'pdf') {

                $data['titulo'] = 'Ordenes de Producción';


                $header = $this->load->view('reporte/header', $data, true);

                $GLOBALS['nombre_reporte'] = 'Reporte_compras_producto' . date('dmY');

                $reporte = $header . $html;

                //echo $reporte;
                $this->pdf->makePdf($reporte, 'L', 'Reporte_compras_producto', 'Letter');

            } elseif ($tipo_reporte == 'excel') {
                //$data['tipo_reporte'] = 'excel';
                $filename = 'rpt_compras_producto_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                //$data['titulo'] = 'control de ingresos';

                $data['filename'] = $filename;

                echo $html;
                die();
            }
        }

        // All your code goes here
        $this->db->group_by('cli_id');
        $this->db->join('cli_cliente', 'ord_id_cli = cli_id');
        $data['clientes'] = $this->gsatelite->get_tabla('ord_orden', array('cli_estado' => 1));

        $where['DATE(ord_fecha_creacion) >='] = date('Y-m-d');
        $where['DATE(ord_fecha_creacion) <='] = date('Y-m-d');

        $data['ordenes'] = $this->proyecto_model->get_ordenes($where);
        $data['titulo_personal'] = "Ordenes de producción";
        $this->_cargarvista($data);
    }

    function orden_detalle($axo_id = NULL) {
        satelite_validar();
        if ($this->input->post()) {
            
            $post_array = $this->input->post();
            $hdnDetalleMateria = $post_array['hdnDetalleMateria'];
            $materiaPrima = $post_array['materiaPrima'];
            $conversionesMateria = $post_array['conversionesMateria'];
            $proveedoresMateria = $post_array['proveedoresMateria'];
            $cantidadesMateria = $post_array['cantidadesMateria'];
            $preciosMateria = $post_array['preciosMateria'];
            $chkEstMateria = $post_array['chkEstMateria'];

            $hdnDetalleMob = $post_array['hdnDetalleMob'];
            $manoObra = $post_array['manoObra'];
            $responsanblesMob = $post_array['responsanblesMob'];
            $cantidadesMob = $post_array['cantidadesMob'];
            $preciosMob = $post_array['preciosMob'];
            $chkestmob = $post_array['chkEstMob'];

            $hdnDetalleGst = $post_array['hdnDetalleGst'];
            $estimacionesGasto = $post_array['estimacionesGasto'];
            $cantidadesGasto = $post_array['cantidadesGasto'];
            $preciosGasto = $post_array['preciosGasto'];
            $ord_id = $this->gsatelite->get_campo('axo_articuloxorden', 'axo_id_ord', array('axo_id' => $axo_id));

            $subtotalesGasto = $post_array['subtotalesGasto'];
            $etapas = $post_array['hdnEtapas'];
            $resultado = 0;
            //Se procesan los detalles ingresados
            //Materia Prima
            $idsMateria = array();
            if (count($hdnDetalleMateria) > 0) {
                for ($i = 0; $i < count($hdnDetalleMateria); $i++) {
                    if ($hdnDetalleMateria[$i] > 0) {
                        $idsMateria[] = $hdnDetalleMateria[$i];
                    }
                }
            }
                //Se eliminan los detalles que no se procesaron.
                $dataMateria = $this->gsatelite->get_tabla('axm_articulo_matxarticulo_ord', array('axm_id_axo' => $axo_id));
                if (count($dataMateria) > 0) {
                    foreach ($dataMateria as $row) {
                        if (!in_array($row['axm_id'], $idsMateria)) {
                            $this->gsatelite->borrado_general('axm_articulo_matxarticulo_ord', array('axm_id' => $row['axm_id']));
                        }
                    }
                }

            if (count($hdnDetalleMateria) > 0) {
                for ($i = 0; $i < count($hdnDetalleMateria); $i++) {
                    $cantidadMateria = convertirFloat($cantidadesMateria[$i]);
                    $precioMateria = convertirFloat($preciosMateria[$i]);
                    $materia_array = array(
                        'axm_id_axo' => $axo_id,
                        'axm_id_art_materia' => $materiaPrima[$i],
                        'axm_id_cva' => ($conversionesMateria[$i] != '') ? $conversionesMateria[$i] : null,
                        'axm_id_prv' => ($proveedoresMateria[$i] != '') ? $proveedoresMateria[$i] : null,
                        'axm_id_etp' => ($etapas[$i]>0)? $etapas[$i]:null,
                        'axm_cantidad' => $cantidadMateria,
                        'axm_precio' => $precioMateria,
                        'axm_estimacion_porcentaje' => ($chkEstMateria[$i] != "") ? $chkEstMateria[$i] : 0,
                        'axm_estado' => 1,
                        'axm_usu_creacion' => $this->tank_auth->get_user_id(),
                        'axm_fecha_creacion' => date('Y-m-d H:i:s'),
                        'axm_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'axm_fecha_modificacion' => date('Y-m-d H:i:s')
                    );

                    if ($hdnDetalleMateria[$i] > 0) {
                        unset($materia_array['axm_id_axo']);
                        unset($materia_array['axm_usu_creacion']);
                        unset($materia_array['axm_fecha_creacion']);
                        $resultado += $this->gsatelite->actualizar_array('axm_articulo_matxarticulo_ord', $materia_array, array('axm_id' => $hdnDetalleMateria[$i]));
                    } else {
                        $resultado += $this->gsatelite->ingresar('axm_articulo_matxarticulo_ord', $materia_array);
                    }
                }
            }

            //Mano de Obra
             $idsMob = array();
            if (count($hdnDetalleMob) > 0) {
                for ($i = 0; $i < count($hdnDetalleMob); $i++) {
                    if ($hdnDetalleMob[$i] > 0) {
                        $idsMob[] = $hdnDetalleMob[$i];
                    }
                }
            }

                //Se eliminan los detalles que no se procesaron.
                $dataMob = $this->gsatelite->get_tabla('mxo_mano_obraxarticulo_ord', array('mxo_id_axo' => $axo_id));

                if (count($dataMob) > 0) {
                    foreach ($dataMob as $row) {
                        if (!in_array($row['mxo_id'], $idsMob)) {
                            $this->gsatelite->borrado_general('mxo_mano_obraxarticulo_ord', array('mxo_id' => $row['mxo_id']));
                        }
                    }
                }

            if (count($hdnDetalleMob) > 0) {
                for ($i = 0; $i < count($hdnDetalleMob); $i++) {
                    $cantidadMob = convertirFloat($cantidadesMob[$i]);
                    $precioMob = convertirFloat($preciosMob[$i]);
                    $mano_obra_array = array(
                        'mxo_id_axo' => $axo_id,
                        'mxo_id_mob' => $manoObra[$i],
                        'mxo_cantidad' => $cantidadMob,
                        'mxo_precio' => $precioMob,
                        'mxo_estimacion_porcentaje' => ($chkestmob[$i] != "") ? $chkestmob[$i] : 0,
                        'mxo_estado' => 1,
                        'mxo_usu_creacion' => $this->tank_auth->get_user_id(),
                        'mxo_fecha_creacion' => date('Y-m-d H:i:s'),
                        'mxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'mxo_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'mxo_id_emp' => ($responsanblesMob[$i]!='')?$responsanblesMob[$i]:null
                    );

                    if ($hdnDetalleMob[$i] > 0) {
                        unset($materia_array['mxo_id_axo']);
                        unset($materia_array['mxo_usu_creacion']);
                        unset($materia_array['mxo_fecha_creacion']);
                        $resultado += $this->gsatelite->actualizar_array('mxo_mano_obraxarticulo_ord', $mano_obra_array, array('mxo_id' => $hdnDetalleMob[$i]));
                    } else {
                        $resultado += $this->gsatelite->ingresar('mxo_mano_obraxarticulo_ord', $mano_obra_array);
                    }
                }
            }

            //Gastos Indirectos
            if (count($hdnDetalleGst) > 0) {
                $idsGastos = array();
                for ($i = 0; $i < count($hdnDetalleGst); $i++) {
                    if ($hdnDetalleGst[$i] > 0) {
                        $idsGastos[] = $hdnDetalleGst[$i];
                    }
                }
            }

            //Se eliminan los detalles que no se procesaron.
            $dataGastos = $this->gsatelite->get_tabla('exr_estimacionxarticulo', array('exr_id_axo' => $axo_id));
            if (count($dataGastos) > 0) {
                foreach ($dataGastos as $row) {
                    if (!in_array($row['exr_id'], $idsGastos)) {
                        $this->gsatelite->borrado_general('exr_estimacionxarticulo', array('exr_id' => $row['exr_id']));
                    }
                }
            }

            if (count($hdnDetalleGst) > 0) {
                for ($i = 0; $i < count($hdnDetalleGst); $i++) {
                    $cantidadGasto = convertirFloat($cantidadesGasto[$i]);
                    $precioGasto = convertirFloat($preciosGasto[$i]);
                    $subtot_gasto = convertirFloat($subtotalesGasto[$i]);
                    $gastos_exr = array(
                        'exr_id_esm' => $estimacionesGasto[$i],
                        'exr_id_axo' => $axo_id,
                        'exr_cantidad' => $cantidadGasto,
                        'exr_precio' => $precioGasto,
                        'exr_monto_calculo' => $subtot_gasto,
                        'exr_estado' => 1,
                        'exr_usu_creacion' => $this->tank_auth->get_user_id(),
                        'exr_fecha_creacion' => date('Y-m-d H:i:s'),
                        'exr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'exr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );

                    if ($hdnDetalleGst[$i] > 0) {
                        unset($gastos_exr['exr_id_axo']);
                        unset($gastos_exr['exr_usu_creacion']);
                        unset($gastos_exr['exr_fecha_creacion']);
                        $resultado += $this->gsatelite->actualizar_array('exr_estimacionxarticulo', $gastos_exr, array('exr_id' => $hdnDetalleGst[$i]));
                    } else {
                        $resultado += $this->gsatelite->ingresar('exr_estimacionxarticulo', $gastos_exr);
                    }
                }
            }

            if ($resultado > 0) {

                //Se actualiza el detalle de la cotización
                $txtTotalMateriaPrima = convertirFloat($post_array['txtTotalMateria']);
                $txtTotalManoObra = convertirFloat($post_array['txtTotalManoObra']);
                $txtTotalGastos = convertirFloat($post_array['txtTotalGastos']);
                $totalCosto = convertirFloat($post_array['txtTotalCostos']);
                $txtObservacion = $post_array['txtObservacion'];


                $articulo_array = array(
                    'axo_total_materia_prima' => $txtTotalMateriaPrima,
                    'axo_total_mano_obra' => $txtTotalManoObra,
                    'axo_total_gastos' => $txtTotalGastos,
                    'axo_total' => $totalCosto,
                    'axo_observacion_presupuesto' => $txtObservacion,
                    'axo_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'axo_fecha_modificacion' => date('Y-m-d H:i:s')
                );

                $this->gsatelite->actualizar_array('axo_articuloxorden', $articulo_array, array('axo_id' => $axo_id));

                $detallesOrden = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $ord_id));

                $totalMateriaPrima = array_sum(array_column($detallesOrden, 'axo_total_materia_prima'));
                $totalManoObra = array_sum(array_column($detallesOrden, 'axo_total_mano_obra'));
                $totalGastos = array_sum(array_column($detallesOrden, 'axo_total_gastos'));
                $totalCostos = array_sum(array_column($detallesOrden, 'axo_total'));

                $orden_array = array(
                    'ord_total_materia_prima' => $totalMateriaPrima,
                    'ord_total_mano_obra' => $totalManoObra,
                    'ord_total_gastos' => $totalGastos,
                    'ord_total' => $totalCostos,
                    'ord_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'ord_fecha_modificacion' => date('Y-m-d H:i:s')
                );

                $this->gsatelite->actualizar_array('ord_orden', $orden_array, array('ord_id' => $ord_id));

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Presupuestos", 'texto_alerta' => "Información procesada correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Presupuestos", 'texto_alerta' => "No se proceso ningun registro, favor verificar información.");
            }

            $this->session->set_flashdata($alerta);

            $tipoBtn = $post_array['btnCrear'];

            if ($tipoBtn == 1) {
                redirect('proyectos/procesos/orden_detalle/' . $axo_id);
            } else {
                redirect('proyectos/procesos/presupuestos_orden/' . $ord_id);
            }
        }
        satelite_validar();
        $data['articulo'] = $this->proyecto_model->listaarticulo($axo_id);
        $data['axo_id'] = $axo_id;
        $producto = $this->proyecto_model->get_detalle_orden(array('axo_id' => $axo_id));
        $data['producto'] = $producto[0];
        $data['bodega'] = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado'=>1), null, '', 'bod_id', true);
        $data['proveedores'] = $this->gsatelite->get_dropdown('prv_proveedor', "[CASE WHEN prv_tipo_pers = 1 THEN CONCAT(prv_codigo,' - ',prv_nombre,' ',prv_apellido) ELSE CONCAT(prv_codigo,' - ',prv_nombre) End]", 'proveedores', array('prv_estado' => 1), null, null, null, true);
        $data['materia_prima'] = $this->gsatelite->get_dropdown('art_articulo', '{art_codigo} - {art_nombre}', 'materia_prima', array('art_materia_prima' => 1, 'art_estado' => 1), null, null, null, true);
        $data['mano_obra'] = $this->gsatelite->get_tabla('mob_mano_obra', array('mob_estado' => 1));
        $data['estimaciones'] = $this->gsatelite->get_tabla('esm_estimacion', array('esm_estado' => 1));
        //Si ya contienen un presupuesto en la orden, se carga.
        $data['permite_actualizar'] = 1;
        $data['materia_prima_prod'] = $this->proyecto_model->get_materia_prima_presupuesto(array('axm_id_axo' => $axo_id));
        $data['mano_obra_prod'] = $this->proyecto_model->get_mano_obra_presupuesto(array('mxo_id_axo' => $axo_id));
        $data['gastos_indirectos'] = $this->proyecto_model->get_gastos_indirectos_presupuesto(array('exr_id_axo' => $axo_id));
        // Si no hay presupuesto de la orden se carga el del producto en caso de que exista.
        if (count($data['materia_prima_prod']) <= 0 && count($data['mano_obra_prod']) <= 0 && count($data['gastos_indirectos']) <= 0) {
            $data['permite_actualizar'] = 0;
            if ($producto[0]['axo_id_rea'] > 0) {
                $receta = $producto[0]['axo_id_rea'];
            } else {
                //receta por defecto
                $receta = $this->gsatelite->get_campo('rea_receta_articulo', 'rea_id', array('rea_estado' => 1, 'rea_id_art' => $producto[0]['art_id'], 'rea_defecto' => 1));
            }
            $data['materia_prima_prod'] = $this->proyecto_model->get_materia_prima_producto_segun_receta(array('mpa_id_art' => $producto[0]['axo_id_art'], 'mpa_id_rea' => $receta));
            $data['mano_obra_prod'] = $this->proyecto_model->get_mano_obra_producto(array('moa_id_art' => $producto[0]['axo_id_art'], 'moa_id_rea' => $receta));
            $data['gastos_indirectos'] = $this->proyecto_model->get_gastos_indirectos_producto(array('esr_id_art' => $producto[0]['axo_id_art'], 'esr_id_rea' => $receta));
        }
        //print_r($data['gastos_indirectos']);exit();die();
        $data['lista'] = $this->gsatelite->get_tabla('art_articulo');
        $data['obra'] = $this->gsatelite->get_tabla('mob_mano_obra', array('mob_estado' => 1));
        $data['resp'] = $this->gsatelite->get_tabla('emp_empleado');
        $data['est'] = $this->gsatelite->get_tabla('esm_estimacion');
        $data['art'] = $this->gsatelite->get_campo('axo_articuloxorden', 'axo_id_art', array('axo_id' => $axo_id));

        $orden = $this->proyecto_model->get_ordenes(array('ord_id' => $producto[0]['axo_id_ord']));
        $data['orden'] = $orden[0];

        $decimales_json = $this->gsatelite->get_parametro('SYS_NUMERO_DECIMALES_PRODUCCION');
        $decimales = 2;

        if ( $decimales_json != "" ) {
            $decimales_array = json_decode($decimales_json, true);
            if ( $decimales_array["presupuesto"]  != NULL) {
                $decimales = ($decimales_array["presupuesto"] != "")?$decimales_array["presupuesto"]:2;
            } 
        } else {
            $decimales  = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;                    
        }

        $data['decimales']      = $decimales;

        $decimales_monetarios           = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $data['decimales_monetarios']   = ( $decimales_monetarios !='')? $decimales_monetarios:2;      

        $data['emp_default'] = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre}'.' '.'{emp_apellido}','',array('emp_estado'=>1), null, '', 'emp_id', true);

        //Validar si tiene etapas
        $result_etapas = $this->proyecto_model->verificar_tiene_etapas_procesos(array('axo_id'=>$axo_id));
        
        if(count($result_etapas) > 0){
            $data['etapas'] = $result_etapas;                
        }else{                
            $data['etapas'] = $this->gsatelite->get_tabla('etp_etapa');
        }          

        $data['titulo_personal'] = "Costeo";
        $this->_cargarvista($data);
    }

    public function print_detalle($axo_id = null){
        satelite_validar();
        if ($axo_id) {
            $this->load->library('pdf');
            $producto = $this->proyecto_model->get_detalle_orden(array('axo_id' => $axo_id));
            $orden = $this->proyecto_model->get_ordenes(array('ord_id' => $producto[0]['axo_id_ord']));
            $data['producto'] = $producto[0];
            $data['orden'] = $orden[0];
            $data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            $data['materia_prima'] = $this->proyecto_model->get_materia_prima_presupuesto(array('axm_id_axo' => $axo_id));
            $data['mano_obra'] = $this->proyecto_model->get_mano_obra_presupuesto(array('mxo_id_axo' => $axo_id));
            $data['otros_gastos'] = $this->proyecto_model->get_gastos_indirectos_presupuesto(array('exr_id_axo' => $axo_id));
            $html  = $this->load->view('reporte/header', array('titulo' => 'Costeo de Producto para Orden ' . $orden[0]['ord_codigo'], 'solotitulo'=>true), true);
            $html .= $this->load->view('proyectos/procesos/print_orden_detalles', $data, true);                  
            $this->pdf->makePDF($html, 'L');
        }
    }

    /**
     * @autor:  Edith Herrera
     * Descripcion: consulta de datos segun la opcion seleccionada de Detalle Materiales.
     */
    function data_articulo() {
        satelite_validar();
        $this->db->join('mep_medida_producto', 'mep_id=art_id_mep');
        $data['prod'] = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $this->input->post('art_id')));
        $data['desc'] = $this->gsatelite->get_tabla('axo_articuloxorden', array('axo_id_art' => $this->input->post('art_id')));
        $data['pre'] = $this->gsatelite->get_tabla('sar_saldo_articulo', array('sar_id_art' => $this->input->post('art_id'), 'sar_cant_actual' => 0));
        $data['cod_obra'] = $this->gsatelite->get_tabla('mob_mano_obra', array('mob_id' => $this->input->post('mob_id')));
        $data['cod_esm'] = $this->gsatelite->get_tabla('esm_estimacion', array('esm_id' => $this->input->post('esm_id')));
        $art = $this->load->view("proyectos/procesos/data_articulo.php", $data, TRUE);
        $arreglo = array('dato' => $art);
        echo json_encode($arreglo);
    }

    /*
     * @Modify by: Mario Marquez
     * @since: 26/06/2017
     */

    function get_articulos_cotizacion() {
        satelite_validar();
        $id_cot = $this->input->post('cotizacion');
        $cli_data = $this->proyecto_model->get_cli_proy('cot_cotizacion',['cot_id'=>$id_cot]);
        $cot_proy = [];
        $cli_option = '<option></option>';
        $cot_id_cli=0;
        $pcl_option = '<option></option>';
        foreach ($cli_data as $value) {
            $cot_id_cli = $value['cli_id'];
            $cli_option .= '<option value="'.$value['cli_id'].'">'.$value['cli_codigo']." - ".$value['cli_nombre']." ".$value['cli_apellido'].'</option>';
        
            $cot_proy['cot_id_pcl'] = $value['cot_id_pcl'];
            //COMO PROYECTO ES UN LEFT JOIN NO SIEMPRE RETORNA REGISTRO
            //POR LO TANTO SE VERIFICA QUE NO SEA VACIO O NULL PARA CREAR OPTION DE PROYECTO
            if($value['pcl_id']!='' || $value['pcl_id']!=null){
                $pcl_option .= '<option selected value="'.$value['pcl_id'].'">'.$value['pcl_codigo']." - ".$value['pcl_nombre'].'</option>';    
            }
        }
        $resul = $this->proyecto_model->get_detalle_cotizacion(array('axc_id_cot' => $id_cot, 'axc_estado' => 1));        
        $data['articulos'] = $resul;
        //$this->gsatelite->get_tabla('axc_articuloxcotizacion', array('axc_id_cot' => $id_cot));
        $data['cli_proy'] = $cli_proy;
        $html = $this->load->view('proyectos/procesos/articulos_por_cotizacion', $data, true);
        $cotizacion = $this->gsatelite->get_tabla('cot_cotizacion', array('cot_id' => $id_cot, 'cot_estado' => 1));
        $concepto = $cotizacion[0]['cot_concepto'];
        $cog_numero_orden = $resul[0]['cog_numero_orden'];
        //proceso para obtener los contactos relacionados al cliente
        $contactos = $this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $cot_id_cli, 'con_estado' => 1));
        $opciones = "<option></option>";
            if (count($contactos) > 0) {
                foreach ($contactos as $con) {

                    $nombre = $con['con_nombre'] . ' ' . $con['con_apellidos'];

                    $opciones .= "<option value='" . $con['con_id'] . "'>" . $nombre . "</option>";
                }
            }
        echo json_encode(array('productos' => $html, 'concepto' => $concepto, 'cot_proy'=>$cot_proy,'cli_cliente'=>$cli_option,'cli_id'=>$cot_id_cli,'contactos'=>$opciones,'pcl_option'=>$pcl_option, 'cog_numero_orden' => $cog_numero_orden));
    }

    function get_articulos2() {
        satelite_validar();
        $id_orden = $this->input->post('id');
        $data['articulos'] = $this->gsatelite->get_tabla('axo_articuloxorden', array('axo_id_ord' => $id_orden));
        $html = $this->load->view('proyectos/procesos/articulos_por_cotizacion_editar', $data, true);
        echo json_encode(array('drop' => $html));
    }

    /*
     * @modify by: Mario Marquez
     * @since: 26/06/2017
     * $cli_busqueda: Parametro de busqueda, desde otra funcion
     * Si no se llena sera un Json
     * Descripción: Devuelve la información del cliente utilizada en el modulo.
     */
    function get_cotizacion_cliente(){
        $cot = $this->input->post('cotizacion');
        $resultado = null;
        $arreglo = array();
        if ($cot != null) {
            $where = array(
                'cot_produccion' => 1
            );

            $like = array("cot_codigo" => $cot);

            $resultado = $this->proyecto_model->get_cotizacion_cli($where, $like);

            if (count($resultado) > 0) {
                foreach ($resultado as $key => $value) {
                    $arreglo[$key]['cotizacion'] = $value['cot_id'];
                    $arreglo[$key]['codigo'] = $value['cot_codigo'];
                }
            }
        }
        
            echo  json_encode($arreglo);
        
    }
    function get_contactos_y_cotizaciones($cli_busqueda = null) {
        $cliente = ($cli_busqueda != null) ? $cli_busqueda : $this->input->post('id');
        $tipo = ($this->input->post('tipo') != null) ? $this->input->post('tipo') : null;
        $pcl_id = $this->input->post('proyecto');

        $arreglo = array('contactos', 'cotizaciones');
        $arreglo_return = array('contactos', 'cotizaciones');
        if ($cliente != null) {
            // Se obtienen los conctactos del cliente.
            $contactos = $this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $cliente, 'con_estado' => 1));
            $arreglo_return['contactos'] = $contactos;

            $opciones = "<option></option>";
            if (count($contactos) > 0) {
                foreach ($contactos as $con) {

                    $nombre = $con['con_nombre'] . ' ' . $con['con_apellidos'];

                    $opciones .= "<option value='" . $con['con_id'] . "'>" . $nombre . "</option>";
                }
            }

            $arreglo['contactos'] = $opciones;

            if ($tipo != null && $tipo == 1) {

                $this->db->join('cot_cotizacion', 'cot_id = ord_id_cot', 'inner');
                $ordenes_cotizacion = $this->gsatelite->get_tabla('ord_orden', array('ord_id_cli' => $cliente));
                if (count($ordenes_cotizacion) > 0) {
                    $idsCotizaciones = array_column($ordenes_cotizacion, 'ord_id_cot');

                    $this->db->where_not_in('cot_id', $idsCotizaciones);
                }
            }
            $this->db->join('cog_cotiz_ganada', 'cog_id_cot = cot_id', 'inner');

            $cotizacion = array();
            $cotizacion_data=array();
            if($pcl_id != ''){
                $cotizacion = $this->gsatelite->get_tabla('cot_cotizacion', array('cot_id_cli' => $cliente, 'cot_produccion' => 1, 'cot_id_pcl'=>$pcl_id));
            } else{
                $cotizacion = $this->gsatelite->get_tabla('cot_cotizacion', array('cot_id_cli' => $cliente, 'cot_produccion' => 1));
            }

            $arreglo_return['cotizaciones'] = $cotizacion;

            $opciones = "<option></option>";
            if (count($cotizacion) > 0) {
                foreach ($cotizacion as $cot) {
                    $cotizacion_data[$cot['cot_id']]['id']=$cot['cot_id'];
                    $cotizacion_data[$cot['cot_id']]['proyecto']=$cot['cot_id_pcl'];
                    $cotizacion_data[$cot['cot_id']]['text']=$cot['cot_codigo'];
                    $opciones .= "<option value='" . $cot['cot_id'] . "' data-proyecto='".$cot['cot_id_pcl'] ."'>" . $cot['cot_codigo'] . "</option>";
                }
            }
            $arreglo['cotizaciones'] = $opciones;
            $arreglo['cotizacionesData'] = $cotizacion_data;
            //Se obtienen los proyectos
            $this->db->join('epr_estado_proyecto','epr_id = pcl_id_epr', 'inner');
            $proyectos = $this->gsatelite->get_tabla('pcl_proyecto_cliente', array('pcl_id_cli' => $cliente, 'pcl_estado' => 1, 'epr_cierre'=>0));
            $opciones = "<option></option>";
            if (count($proyectos) > 0) {
                foreach ($proyectos as $pcl) {
                    $nombre = $pcl['pcl_codigo'] . ' - ' . $pcl['pcl_nombre'];
                    $opciones .= "<option value='" . $pcl['pcl_id'] . "' >" . $nombre . "</option>";
                }
            }
            $arreglo['proyecto'] = $opciones;
        }
        if ($cli_busqueda != null) {
            return $arreglo_return;
        }

        echo json_encode($arreglo);
    }
    
    function agregar_orden() {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            $slcTipoOrden = $post_array['slcTipoOrden'];
            $txtCodigoOrden = $post_array['txtCodigoOrden'];
            $slcCliente = $post_array['slcCliente'];
            $correlativo = $post_array['correlativo_grid'];
            $slcContacto = ($post_array['slcContacto'] != '') ? $post_array['slcContacto'] : null;
            $hdnVendedor = ($post_array['hdnVendedor'] != '') ? $post_array['hdnVendedor'] : null;
            $slcCotizacion = ($post_array['slcCotizacion'] != '') ? $post_array['slcCotizacion'] : null;
            $txtConcepto = ($post_array['txtConcepto'] != '') ? $post_array['txtConcepto'] : null;
            $txtFechaOrden = ($post_array['txtFechaOrden'] != '') ? formatear_fecha('Y-m-d', $post_array['txtFechaOrden']) : null;
            $slcProyecto = ($post_array['slcProyecto'] != '') ? $post_array['slcProyecto'] : null;
            $txtFechaEntrega = ($post_array['txtFechaEntrega'] != '') ? formatear_fecha('Y-m-d', $post_array['txtFechaEntrega']) : null;
            $txtDescripcion = ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : null;
            $txtReferencia = ($post_array['txtReferencia'] != '') ? $post_array['txtReferencia'] : null;
            
            $orden_array = array(
                'ord_id_cli' => $slcCliente,
                'ord_id_ven' => $hdnVendedor,
                'ord_id_tio' => $slcTipoOrden,
                'ord_codigo' => $txtCodigoOrden,
                'ord_id_con' => $slcContacto,
                'ord_id_cot' => $slcCotizacion,
                'ord_id_pcl' => $slcProyecto,
                'ord_fecha' => $txtFechaOrden,
                'ord_fecha_entr' => $txtFechaEntrega,
                'ord_concepto' => $txtConcepto,
                'ord_comentario' => $txtDescripcion,
                'ord_referencia' => $txtReferencia,
                'ord_estado' => 1,
                'ord_usu_creacion' => $this->tank_auth->get_user_id(),
                'ord_fecha_creacion' => date('Y-m-d H:i:s'),
                'ord_usu_modificacion' => $this->tank_auth->get_user_id(),
                'ord_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $ord_id = $this->gsatelite->ingresar('ord_orden', $orden_array);
            // $ord_id = 23;
            if ($ord_id > 0) {
                $hdnProductoCot = $post_array['hdnProductoCot'];
                $productos = $post_array['productos'];
                $conversiones = $post_array['conversiones'];
                $cantidades = $post_array['cantidades'];
                $descripciones = $post_array['descripciones'];
                $recetas_base = $post_array['receta'];
                if (count($productos) > 0) {
                    for ($i = 0; $i < count($productos); $i++) {
                        $detalle_orden = array(
                            'axo_id_ord' => $ord_id,
                            'axo_id_art' => $productos[$i],
                            'axo_id_axc' => ($hdnProductoCot[$i] != '') ? $hdnProductoCot[$i] : null,
                            'axo_id_cva' => ($conversiones[$i] != '') ? $conversiones[$i] : null,
                            'axo_id_rea' => ($recetas_base[$i] != '') ? $recetas_base[$i] : null,
                            'axo_descripcion' => ($descripciones[$i]) ? $descripciones[$i] : '',
                            'axo_cantidad' => $cantidades[$i],
                            'axo_estado' => 1,
                            'axo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'axo_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'axo_usu_creacion' => $this->tank_auth->get_user_id(),
                            'axo_fecha_creacion' => date('Y-m-d H:i:s')
                        );
                        $axo_id = $this->gsatelite->ingresar('axo_articuloxorden', $detalle_orden);
                        // $axo_id = 23;
                        if ($axo_id > 0) {
                            //Se procesan los presupuestos creados para el detalle si viene de una cotización
                            if ($hdnProductoCot[$i] > 0) {
                                $d1 = $this->gsatelite->get_tabla('axr_articulo_materiaxarticulo', array('axr_id_axc' => $hdnProductoCot[$i]));
                                $d2 = $this->gsatelite->get_tabla('mxa_mano_obraxarticulo', array('mxa_id_axc' => $hdnProductoCot[$i]));
                                $d3 = $this->gsatelite->get_tabla('exa_estimacionxarticulo', array('exa_id_axc' => $hdnProductoCot[$i]));
                                $d4 = $this->gsatelite->get_tabla('acs_articulo_costo', array('acs_id_axc' => $hdnProductoCot[$i]));
                                if ($d1 > 0) {
                                    foreach ($d1 as $key => $value) {
                                        $array_axm = array(
                                            'axm_id_axo' => $axo_id,
                                            'axm_id_art_materia' => $value['axr_id_art_materia'],
                                            'axm_cantidad' => $value['axr_cantidad'],
                                            'axm_precio' => $value['axr_precio'],
                                            'axm_estado' => 1,
                                            'axm_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'axm_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'axm_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'axm_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'axm_id_cva' => null//$value['axr_id_mep']
                                        );
                                        $this->gsatelite->ingresar('axm_articulo_matxarticulo_ord', $array_axm);
                                    }
                                }
                                if ($d2 > 0) {
                                    foreach ($d2 as $dato => $val) {
                                        $array_mxo = array(
                                            'mxo_id_axo' => $axo_id,
                                            'mxo_id_mob' => $val['mxa_id_mob'],
                                            'mxo_cantidad' => $val['mxa_cantidad'],
                                            'mxo_precio' => $val['mxa_precio'],
                                            'mxo_estado' => 1,
                                            'mxo_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'mxo_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'mxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'mxo_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'mxo_id_emp' => $val['mxa_id_emp']
                                        );
                                        $this->gsatelite->ingresar('mxo_mano_obraxarticulo_ord', $array_mxo);
                                    }
                                }
                                if ($d3 > 0) {
                                    foreach ($d3 as $est => $valor) {
                                        $array_exr = array(
                                            'exr_id_esm' => $valor['exa_id_esm'],
                                            'exr_id_axo' => $axo_id,
                                            'exr_cantidad' => $valor['exa_cantidad'],
                                            'exr_precio' => $valor['exa_precio'],
                                            //'exr_observacion' => $valor['exa_observacion'],
                                            'exr_estado' => 1,
                                            'exr_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'exr_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'exr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'exr_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );
                                        $this->gsatelite->ingresar('exr_estimacionxarticulo', $array_exr);
                                    }
                                }
                                if ($d4 > 0) {
                                    foreach ($d4 as $k => $info) {
                                        $array_acr = array(
                                            'acr_id_axo' => $axo_id,
                                            'acr_costo' => $info['acs_costo'],
                                            'acr_observacion' => $info['acs_observacion'],
                                            'acr_estado' => 1,
                                            'acr_usu_mod' => $this->tank_auth->get_user_id(),
                                            'acr_fecha_mod' => date('Y-m-d H:i:s')
                                        );
                                        $idacs = $this->gsatelite->get_campo('acr_articulo_costo_prod', 'acr_id_axo', array('acr_id_axo' => $axo_id));
                                        if (count($idacs) > 0) {
                                            $registro = $this->gsatelite->actualizar_array('acr_articulo_costo_prod', $array_acr, array('acr_id_axo' => $axo_id));
                                        } else {
                                            $registro = $this->gsatelite->ingresar('acr_articulo_costo_prod', $array_acr);
                                        }
                                    }
                                }
                            }

                            //Se procesan las caracteristicas
                            //Se procesan los detalles de las caracteristicas
                            if (isset($post_array['caracteristicas_' . $productos[$i].'_'.$correlativo[$i]]) && count($post_array['caracteristicas_' . $productos[$i].'_'.$correlativo[$i]]) > 0) {
                                $caracteristicas = $post_array['caracteristicas_' . $productos[$i].'_'.$correlativo[$i]];
                                $valores = $post_array['valoresCarac_' . $productos[$i].'_'.$correlativo[$i]];
                                for ($j = 0; $j < count($post_array['caracteristicas_' . $productos[$i].'_'.$correlativo[$i]]); $j++) {
                                    if ($caracteristicas[$j] != '') {
                                        $detalle_carac_array = array(
                                            'cdo_id_cxu' => $caracteristicas[$j],
                                            'cdo_id_axo' => $axo_id,
                                            'cdo_valor' => $valores[$j],
                                            'cdo_estado' => 1,
                                            'cdo_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'cdo_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'cdo_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'cdo_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );
                                        $this->gsatelite->ingresar('cdo_caracteristicaxdetalle_orden', $detalle_carac_array);
                                    }
                                }
                            }
                        }
                    }
                }
                $ruta = $this->input->post('ruta');
                $carpeta = $this->input->post("nombreCarpeta");
                $titulos = $this->input->post("titulo_doc");               
                if (count($ruta) > 0) {
                    for ($i = 0; $i < count($ruta); $i++) {                            
                        if ($ruta[$i] != "") {
                            $img = $ruta[$i];
                            $titulo = $titulos[$i];
                            $this->datos_anexo($img, $ord_id, $carpeta, $titulo);
                        }
                    }
                }
                /*
                 * Agregado por: Nelson Soriano
                 * Descripcion: crea de forma automatica los siguientes procesos:
                 * Lotes,job tracking, presupuesto
                 * 26-12-2018
                */
                if ($post_array['doAutomatic'] == 1) {
                   $this->automatic_configs($ord_id);
                }
                /**************************************************************/
                
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Orden de Producción", 'texto_alerta' => "La orden se ingresó con el nombre " . $txtCodigoOrden);
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Orden no ingresada, favor verificar información");
            }

            $this->session->set_flashdata($alerta);

            $tipoBtn = $post_array['btnCrear'];

            if ($tipoBtn == 1) {
                redirect('proyectos/procesos/agregar_orden');
            } else {
                redirect('proyectos/procesos/orden_produccion');
            }
        } // Fin del post
        else {
            //parametro para saber si se permite agregar mas de un producto
            $permite_mas_productos = $this->gsatelite->get_parametro('SYS_PERMITE_DUPLICAR_PRODUCTO');
            $data['permite_mas_productos'] = (trim($permite_mas_productos) != '')?$permite_mas_productos:0;

            //$data['tipo_orden'] = $this->gsatelite->get_dropdown('tio_tipo_orden', '{tio_nombre}', 'tipo_orden', array('tio_estado' => 1), null, null, null, true);
            $select = '<option value=""></option>';
            $tipo_ord_reg = $this->gsatelite->get_tabla('tio_tipo_orden', array('tio_estado' => 1));
            foreach ($tipo_ord_reg as $key) {
                $select .= '<option value="'.$key['tio_id'].'" pre="'.$key['tio_prefijo'].'">'.$key['tio_nombre'].'</option>';
            }

            $a = $this->gsatelite->get_parametro('SYS_CLIENTE_DEFECTO',1,1);
            $data['cliente_defecto_op']        = $a->par_default;
            $nombrex = $this->gsatelite->get_tabla('cli_cliente',array('cli_id' => $a->par_default));
            if ($nombrex[0]['cli_personeria'] == 2) {
                $data['cliente_defecto_op_nombre'] = $nombrex[0]['cli_codigo'].'-'.$nombrex[0]['cli_apellido'];
            }else{
                $data['cliente_defecto_op_nombre'] = $nombrex[0]['cli_personeria'].'-'.$nombrex[0]['cli_nombre'].' '.$nombrex[0]['cli_apellido'];
            }
            $data['tipo_orden'] = $select;
            $data['clientes'] = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
            $data['vendedores'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), null, '', 'ven_id', true);
            $data['articulos'] = $this->gsatelite->get_dropdown('art_articulo', '{art_nombre}', '', array('art_estado' => 1), null, '', 'art_id', true);
            $data['etapa'] = $this->gsatelite->get_dropdown('etp_etapa', '{etp_nombre}', '', array('etp_estado' => 1), null, '', 'etp_id', true);
            $data['categoria']      = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_nombre}', '', array('tia_estado' => 1), null, '', 'tia_id', true);
            $data['marca']          = $this->gsatelite->get_dropdown('mrp_marca_producto', '{mrp_nombre}', '', array('mrp_estado' => 1), null, '', 'mrp_id', true);
            $data['presentacion']   = $this->gsatelite->get_dropdown('ppr_presentacion_producto', '{ppr_nombre}', '', array('ppr_estado' => 1), null, '', 'ppr_id', true);
            $data['titulo_personal'] = "Nueva orden de producción";
            cargarvista($data);
        }
    }

    /**
     *Descripcion: Funcion que realiza de forma automatica los procesos de creacion de lotes, job Tracking, presupuestos
     * @author: Nelson Soriano
     * @since:  21-12-2018 
     * @param:  id de la orden de produccion
    **/

    public function  automatic_configs($ord_id = null){
        if ($ord_id != null) {
            // Punto 1 obtenemos la data de los productos que pertenecen a la orden de compra 
            $data_productos = $this->gsatelite->get_tabla('axo_articuloxorden',array('axo_id_ord' => $ord_id));
            $i = 1;
            foreach ($data_productos as $key => $value) {
                $data_lote   = array(
                    'lop_id_axo'              => $value['axo_id'],
                    'lop_nombre'              => 'lote - '.$i,
                    'lop_cantidad'            => $value['axo_cantidad'],
                    'lop_estado'              => 1,
                    'lop_usu_creacion'        => $this->tank_auth->get_user_id(),
                    'lop_fecha_creacion'      => date('Y-m-d H-i-s'),
                    'lop_usu_modificacion'    => $this->tank_auth->get_user_id(),
                    'lop_fecha_modificacion'  => date('Y-m-d H-i-s')
                );
                $this->gsatelite->ingresar('lop_lote_produccion',$data_lote);
                $i++;
            }
            // Paso 2 job tracking, si el producto ya tiene definidas las etapas se procede
            foreach ($data_productos as $key => $value) {
                $etapas = $this->proyecto_model->get_etapas_articulo(array('eta_id_art' => $value['axo_id_art']));
                $lote   = $this->gsatelite->get_campo('lop_lote_produccion','lop_id', array('lop_id_axo' => $value['axo_id']));
                if (count($etapas) > 0) {
                    foreach ($etapas as $key => $etapa) {
                        $etapas_array            =  array(
                            'exo_id_etp'             => $etapa['eta_id_etp'],
                            'exo_id_lop'             => $lote,
                            'exo_duracion'           => $etapa['eta_duracion'],
                            'exo_duracion_mano_obra' => $etapa['eta_duracion_mod'],
                            'exo_comentario'         => $etapa['eta_comentario'],
                            'exo_orden'              => $etapa['eta_orden'],
                            'exo_fin'                => $etapa['eta_final'],
                            'exo_estado'             => 1,
                            'exo_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'exo_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'exo_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'exo_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );
                        $this->gsatelite->ingresar('exo_etapaxarticulo_orden', $etapas_array);
                    }
                }
            }
            // Paso 3 presupuestos, si esta configurado a un producto o proviene de una cotizacion
            foreach ($data_productos as $key => $value) {
                // se verifica si hay algun presupuesto en las configuraciones del producto
                $axc_id = 0;
                if ($value['axo_id_axc'] != "") {
                    $id     = $this->cotModel->get_axc('axc_articuloxcotizacion', 'axc_id', array('axc_id_art' => $value['axo_id_art'], 'axc_estado' => 1),'axc_id');
                    $axc_id = $id->axc_id; 
                }                
                $materia_prima_prod = $this->cotModel->get_materia_prima_presupuesto_cot(array('axr_id_axc' => $axc_id));
                $mano_obra_prod     = $this->cotModel->get_mano_obra_presupuesto_cot(array('mxa_id_axc' => $axc_id));
                $gastos_indirectos  = $this->cotModel->get_gastos_indirectos_presupuesto_cot(array('exa_id_axc' => $axc_id));                      
                if (count($materia_prima_prod) > 0  && count($mano_obra_prod) > 0 && count($gastos_indirectos) > 0) {
                    // Se ingresa el presupuesto de la cotizacion
                    foreach ($materia_prima_prod    as $key => $materia_cot) {
                        $materia_prima               =  array(
                            'axm_id_axo'                => $value['axo_id'],
                            'axm_id_cva'                => $materia_cot['axr_id_cva'],
                            'axm_id_prv'                => $materia_cot['axr_id_prv'],
                            'axm_id_etp'                => $materia_cot['axr_id_etp'],
                            'axm_cantidad'              => $materia_cot['axr_cantidad'],
                            'axm_id_art_materia'        => $materia_cot['axr_id_art_materia'],
                            'axm_precio'                => ($materia_cot['axr_precio'] == null) ? 0 : $materia_cot['axr_precio'],
                            'axm_estimacion_porcentaje' => ($materia_cot['axr_estimacion_porcentaje'] > 0) ? $materia_cot['axr_estimacion_porcentaje'] : 0,
                            'axm_estado'                => 1,
                            'axm_usu_creacion'          => $this->tank_auth->get_user_id(),
                            'axm_fecha_creacion'        => date('Y-m-d H-i-s'),
                            'axm_usu_modificacion'      => $this->tank_auth->get_user_id(),
                            'axm_fecha_modificacion'    => date('Y-m-d H-i-s')
                        );
                        $this->gsatelite->ingresar('axm_articulo_matxarticulo_ord',$materia_prima);
                    }
                    foreach ($mano_obra_prod as $k  => $mano_cot) {
                        $mano_obra                   =  array(
                            'mxo_id_axo'                => $value['axo_id'],
                            'mxo_id_mob'                => $mano_cot['mxa_id_mob'],
                            'mxo_id_emp'                => $mano_cot['mxa_id_emp'],
                            'mxo_cantidad'              => $mano_cot['mxa_cantidad'],
                            'mxo_precio'                => ($mano_cot['mxa_precio'] == null) ? 0 : $mano_cot['mxa_precio'],
                            'mxo_estimacion_porcentaje' => ($mano_cot['mxa_estimacion_porcentaje'] > 0) ? $mano_cot['mxa_estimacion_porcentaje'] : 0,
                            'mxo_estado'                => 1,
                            'mxo_usu_creacion'          => $this->tank_auth->get_user_id(),
                            'mxo_fecha_creacion'        => date('Y-m-d H-i-s'),
                            'mxo_usu_modificacion'      => $this->tank_auth->get_user_id(),
                            'mxo_fecha_modificacion'    => date('Y-m-d H-i-s')
                        );
                        $this->gsatelite->ingresar('mxo_mano_obraxarticulo_ord',$mano_obra);
                    }
                    foreach ($gastos_indirectos as $key => $gastos_cot) {
                        if ($gastos_cot['esm_tipo_calculo'] > 0) {
                            $precio = ($gastos_cot['esm_calculo_etapa'] > 0) ? $gastos_cot['esm_monto'] : $gastos_cot['exa_precio'];
                            $montoC = ($gastos_cot['exa_monto_calculo'] != "") ? $gastos_cot['exa_monto_calculo'] : ($precio * $gastos_cot['exa_cantidad']);
                        } else {
                            $precio = ($gastos_cot['exa_precio'] != null) ? $gastos_cot['exa_precio'] : 0;
                            $montoC = ($gastos_cot['exa_monto_calculo'] != "") ? $gastos_cot['exa_monto_calculo'] : ($precio * $gastos_cot['exa_cantidad']);
                        }
                        $gastos_indirectos          =  array(
                            'exr_id_esm'            => $gastos_cot['exa_id_esm'],
                            'exr_id_axo'            => $value['axo_id'],
                            'exr_cantidad'          => $gastos_cot['exa_cantidad'],
                            'exr_precio'            => ($precio != null) ? $precio : 0,
                            'exr_monto_calculo'     => $montoC,
                            'exr_estado'            => 1,
                            'exr_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'exr_fecha_creacion'    => date('Y-m-d H-i-s'),
                            'exr_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'exr_fecha_modificacion'=> date('Y-m-d H-i-s')
                        );
                        $this->gsatelite->ingresar('exr_estimacionxarticulo',$gastos_indirectos);
                    }
                }else{
                    // Se ingresa el presupuesto por defecto del producto
                    if ($value['axo_id_rea'] > 0) {
                        $receta = $value['axo_id_rea'];
                    } else {
                        $receta = $this->gsatelite->get_campo('rea_receta_articulo', 'rea_id', array('rea_estado' => 1, 'rea_id_art' => $value['axo_id_art'], 'rea_defecto' => 1));
                    }
                    $materia_prima_prod =  $this->proyecto_model->get_materia_prima_producto_segun_receta(array('mpa_id_art' => $value['axo_id_art'], 'mpa_id_rea' => $receta));
                    $mano_obra_prod     =  $this->proyecto_model->get_mano_obra_producto(array('moa_id_art' => $value['axo_id_art'], 'moa_id_rea' => $receta));
                    $gastos_indirectos  =  $this->proyecto_model->get_gastos_indirectos_producto(array('esr_id_art' => $value['axo_id_art'], 'esr_id_rea' => $receta));
                    $converion = $this->gsatelite->get_campo('cva_conversion_articulo', 'cva_conversion', array('cva_id' => $value['axo_id_cva']));
                    $solicitud_orden = $value['axo_cantidad'] * $converion;                      
                    if (count($materia_prima_prod) > 0  && count($mano_obra_prod) > 0 && count($gastos_indirectos) > 0) {
                        foreach ($materia_prima_prod    as $key => $materia) {
                            $materia_prima               =  array(
                                'axm_id_axo'                => $value['axo_id'],
                                'axm_id_cva'                => $materia['mpa_id_cva'],
                                'axm_id_prv'                => $materia['mpa_id_prv'],
                                'axm_id_etp'                => $materia['mpa_id_etp'],
                                'axm_cantidad'              => ($materia['mpa_cantidad'] * $solicitud_orden),
                                'axm_id_art_materia'        => $materia['mpa_id_art_materia'],
                                'axm_precio'                => ($materia['tipos_precio'] == null) ? 0 : $materia['tipos_precio'],
                                'axm_estimacion_porcentaje' => ($materia['mpa_estimacion_porcentaje'] > 0) ? $materia['mpa_estimacion_porcentaje'] : 0,
                                'axm_estado'                => 1,
                                'axm_usu_creacion'          => $this->tank_auth->get_user_id(),
                                'axm_fecha_creacion'        => date('Y-m-d H-i-s'),
                                'axm_usu_modificacion'      => $this->tank_auth->get_user_id(),
                                'axm_fecha_modificacion'    => date('Y-m-d H-i-s')
                            );
                            $this->gsatelite->ingresar('axm_articulo_matxarticulo_ord',$materia_prima);
                        }
                        foreach ($mano_obra_prod as $k  => $mano) {
                            $mano_obra                   =  array(
                                'mxo_id_axo'                => $value['axo_id'],
                                'mxo_id_mob'                => $mano['moa_id_mob'],
                                'mxo_id_emp'                => $mano['moa_id_emp'],
                                'mxo_cantidad'              => ($mano['mob_calculo_etapa'] > 0) ? $mano['moa_cantidad'] : ($mano['moa_cantidad'] * $solicitud_orden),
                                'mxo_precio'                => ($mano['mob_precio'] == null) ? 0 : $mano['mob_precio'],
                                'mxo_estimacion_porcentaje' => ($mano['moa_estimacion_porcentaje'] > 0) ? $mano['moa_estimacion_porcentaje'] : 0,
                                'mxo_estado'                => 1,
                                'mxo_usu_creacion'          => $this->tank_auth->get_user_id(),
                                'mxo_fecha_creacion'        => date('Y-m-d H-i-s'),
                                'mxo_usu_modificacion'      => $this->tank_auth->get_user_id(),
                                'mxo_fecha_modificacion'    => date('Y-m-d H-i-s')
                            );
                            $this->gsatelite->ingresar('mxo_mano_obraxarticulo_ord',$mano_obra);
                        }
                        foreach ($gastos_indirectos as $key => $gastos) {
                            $gto_fijo_var = (isset($gastos['esr_tipo_costo']) && $gastos['esr_tipo_costo'] > 0) ? 1 : $value['axo_cantidad'];
                            if ($gastos['esm_tipo_calculo'] > 0) {
                                $precio = ($gastos['esm_calculo_etapa'] > 0) ? $gastos['esm_monto'] : $gastos['esr_precio'];
                                $montoC = ($gastos['esr_monto_calculo'] != "") ? $gastos['esr_monto_calculo'] : ($precio * $gastos['esr_cantidad'] * $gto_fijo_var);
                            } else {
                                $precio = ($gastos['esr_precio'] != null) ? $gastos['esr_precio'] : 0;
                                $montoC = ($gastos['esr_monto_calculo'] != "") ? $gastos['esr_monto_calculo'] : ($precio * $gastos['esr_cantidad']);
                                $gto_fijo_var = 1;//un solo porcentaje
                            }
                            $gastos_indirectos          =  array(
                                'exr_id_esm'            => $gastos['esr_id_esm'],
                                'exr_id_axo'            => $value['axo_id'],
                                'exr_cantidad'          => ($gastos['esr_cantidad'] * $gto_fijo_var),
                                'exr_precio'            => ($precio != null) ? $precio : 0,
                                'exr_monto_calculo'     => $montoC,
                                'exr_estado'            => 1,
                                'exr_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'exr_fecha_creacion'    => date('Y-m-d H-i-s'),
                                'exr_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'exr_fecha_modificacion'=> date('Y-m-d H-i-s')
                            );
                            $this->gsatelite->ingresar('exr_estimacionxarticulo',$gastos_indirectos);
                        }
                    }

                }
            }
            // Actualizar el axo_total 
            foreach ($data_productos as $key => $value) {
                $axo_total = $axo_total_mat_prim = $axo_total_mob = $axo_total_gif =  0;
                $valores = $this->proyecto_model->get_total_axo_automatico(array('axo_id' => $value['axo_id']));
                if (count($valores) > 0) {
                    $axo_total = ($valores[0]['materia_prima'] + $valores[0]['mano_obra'] + $valores[0]['gif_monto_fijo'] + $valores[0]['gif_porc_axm'] + $valores[0]['gif_porc_mob']);
                    $axo_total_mat_prim = $valores[0]['materia_prima'];
                    $axo_total_mob = $valores[0]['mano_obra'];
                    $axo_total_gif = ($valores[0]['gif_monto_fijo'] + $valores[0]['gif_porc_axm'] + $valores[0]['gif_porc_mob']);
                }
                $actualizar = array('axo_total_materia_prima' => $axo_total_mat_prim, 'axo_total_mano_obra' => $axo_total_mob, 'axo_total_gastos' => $axo_total_gif, 'axo_total' => $axo_total);
                $this->gsatelite->actualizar_array('axo_articuloxorden', $actualizar, array('axo_id' => $value['axo_id']));
            }
        }
    }

    public function actualizar_precio_mat_prima($axc_ord = 0){
        if ($_POST) {
            $nu_price = array();
            $datos = json_decode($this->input->post('datos'), true);
            $art_p = $this->input->post('axc_id');
            if ($axc_ord > 0) {                
                $matts = $this->gsatelite->get_tabla('axr_articulo_materiaxarticulo', array('axr_id_axc' => $art_p));
                $ids = implode(',', array_column($matts, 'axr_id_art_materia'));
                $materias_primas = $this->proyecto_model->get_act_price_mat_prima(array("axr_id_axc" => $art_p, "mpa_id_art_materia IN ($ids)" => null), 1);
            } else {
                $matts = $this->gsatelite->get_tabla('axm_articulo_matxarticulo_ord', array('axm_id_axo' => $art_p));
                $ids = implode(',', array_column($matts, 'axm_id_art_materia'));
                $materias_primas = $this->proyecto_model->get_act_price_mat_prima(array("axm_id_axo" => $art_p, "mpa_id_art_materia IN ($ids)" => null), 0);
            }
            if (count($materias_primas) > 0) {
                $error = 0;
                $nu_price['error'] = 0;
                foreach ($datos as $k => $value) {
                    foreach ($materias_primas as $key => $val) {
                        if ($val['mpa_id_art_materia'] == $value) {
                            $nu_price[strval($k)] = $val['tipos_precio'];
                            unset($materias_primas[$key]);
                        }
                    }
                }
            } else {
                $nu_price['error'] = 1;
                $error = 1;
            }
            echo json_encode( array('error' => $error, 'valores' => json_encode($nu_price)));
        }
    }

    public function datos_anexo($img, $ord_id, $carpeta, $titulo_doc, $url_anexo_base='') {      
        $extencion = end(explode(".", $img));
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        $nombre_doc = $titulo_doc . time() . "." . trim($extencion) . "";
        if (trim($url_anexo_base) != '') {
            $carpeta_destino = "uploads/anx_proyectos/" . $url_anexo_base;
        } else {
            $carpeta_destino = "uploads/anx_proyectos/" . $nombre_doc;
        }
        copy($ruta, $carpeta_destino);
        unlink($ruta);
        $arrAnexo = [
            'aop_id_ord'=> $ord_id,
            'aop_url'=>$carpeta_destino,
            'aop_nombre'=>$nombre_doc,
            'aop_estado'=>1,
            'aop_usu_creacion'=>$this->tank_auth->get_user_id(),
            'aop_fecha_creacion'=>date('Y-m-d H:i:s'),
            'aop_usu_modificacion'=>$this->tank_auth->get_user_id(),
            'aop_fecha_modificacion'=>date('Y-m-d H:i:s')
        ];
        $this->gsatelite->ingresar('aop_anexo_orden_produccion',$arrAnexo);
    }
    public function eliminar_orden($id = null) {

        $registro = $this->gsatelite->actualizar_array('ord_orden', array('ord_estado' => -1), array('ord_id' => $id));

        if ($registro == 1) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Orden Eliminada", 'texto_alerta' => "Se elimino la orden correctamente");
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "No se pudo eliminar la orden.");
        }

        $this->session->set_flashdata($alerta);
        redirect('proyectos/procesos/orden_produccion');
    }

    public function editar_orden($ord_id = null) {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            // var_dump($post_array);die();
            $slcTipoOrden = $post_array['slcTipoOrden'];
            $txtCodigoOrden = $post_array['txtCodigoOrden'];
            $slcCliente = $post_array['slcCliente'];
            $correlativo = $post_array['correlativo_grid'];
            $slcContacto = ($post_array['slcContacto'] != '') ? $post_array['slcContacto'] : null;
            $hdnVendedor = ($post_array['hdnVendedor'] != '') ? $post_array['hdnVendedor'] : null;
            $slcCotizacion = ($post_array['slcCotizacion'] != '') ? $post_array['slcCotizacion'] : null;
            $txtConcepto = ($post_array['txtConcepto'] != '') ? $post_array['txtConcepto'] : null;
            $txtFechaOrden = ($post_array['txtFechaOrden'] != '') ? formatear_fecha('Y-m-d', $post_array['txtFechaOrden']) : null;
            $slcProyecto = ($post_array['slcProyecto'] != '') ? $post_array['slcProyecto'] : null;
            $txtFechaEntrega = ($post_array['txtFechaEntrega'] != '') ? formatear_fecha('Y-m-d', $post_array['txtFechaEntrega']) : null;
            $txtDescripcion = ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : null;
            $txtReferencia = ($post_array['txtReferencia'] != '') ? $post_array['txtReferencia'] : null;
            
            $orden_array = array(
                'ord_id_cli' => $slcCliente,
                'ord_id_ven' => $hdnVendedor,
                'ord_id_tio' => $slcTipoOrden,
                'ord_codigo' => $txtCodigoOrden,
                'ord_id_con' => $slcContacto,
                'ord_id_cot' => $slcCotizacion,
                'ord_id_pcl' => $slcProyecto,
                'ord_fecha' => $txtFechaOrden,
                'ord_fecha_entr' => $txtFechaEntrega,
                'ord_concepto' => $txtConcepto,
                'ord_comentario' => $txtDescripcion,
                'ord_referencia' => $txtReferencia,
                'ord_estado' => 1,
                'ord_usu_modificacion' => $this->tank_auth->get_user_id(),
                'ord_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $resultado = $this->gsatelite->actualizar_array('ord_orden', $orden_array, array('ord_id' => $ord_id));

            if ($resultado > 0) {
                //Se procesan los productos agregados
                //Campo de Detalle, para verificar si es nuevo o se actualizara
                $hdnDetalle = $post_array['hdnDetalle'];
                $hdnProductoCot = $post_array['hdnProductoCot'];
                $productos = $post_array['productos'];
                $conversiones = $post_array['conversiones'];
                $cantidades = $post_array['cantidades'];
                $descripciones = $post_array['descripciones'];
                $recetas_base = $post_array['receta'];
                //$detalle_orden = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $ord_id));
                $arrayIds = array();
                if (count($hdnDetalle) > 0) {
                    for ($i = 0; $i < count($hdnDetalle); $i++) {
                        if ($hdnDetalle[$i] > 0) {
                            $arrayIds[] = $hdnDetalle[$i];
                        }
                    }
                }
                //Se eliminan los detalles que no han sido usados
                /*foreach ($detalle_orden as $axo) {
                    if (!in_array($axo['axo_id'], $arrayIds)) {
                        $this->gsatelite->borrado_general('cdo_caracteristicaxdetalle_orden', array('cdo_id_axo' => $axo['axo_id']));
                        $this->gsatelite->borrado_general('axo_articuloxorden', array('axo_id' => $axo['axo_id']));
                    }
                }*/

                if (count($productos) > 0) {
                    for ($i = 0; $i < count($productos); $i++) {

                        $detalle_orden = array(
                            'axo_id_ord' => $ord_id,
                            'axo_id_art' => $productos[$i],
                            'axo_id_axc' => ($hdnProductoCot[$i] != '') ? $hdnProductoCot[$i] : null,
                            'axo_id_cva' => ($conversiones[$i] != '') ? $conversiones[$i] : null,
                            'axo_id_rea' => ($recetas_base[$i] != '') ? $recetas_base[$i] : null,
                            'axo_descripcion' => ($descripciones[$i]) ? $descripciones[$i] : '',
                            'axo_cantidad' => $cantidades[$i],
                            'axo_estado' => 1,
                            'axo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'axo_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'axo_usu_creacion' => $this->tank_auth->get_user_id(),
                            'axo_fecha_creacion' => date('Y-m-d H:i:s')
                        );

                        //Si es mayor a cero se actualiza sino se ingresa
                        if ($hdnDetalle[$i] > 0) {
                            unset($detalle_orden['axo_usu_creacion']);
                            unset($detalle_orden['axo_fecha_creacion']);
                            unset($detalle_orden['axo_id_ord']);
                            $this->gsatelite->actualizar_array('axo_articuloxorden', $detalle_orden, array('axo_id' => $hdnDetalle[$i]));
                            $axo_id = $hdnDetalle[$i];
                        } else {
                            $axo_id = $this->gsatelite->ingresar('axo_articuloxorden', $detalle_orden);
                        }
                        if ($axo_id > 0) {
                            $hdnProductoCot[$i] = null;
                            //Se procesan los presupuestos creados para el detalle si viene de una cotización
                            if ($hdnProductoCot[$i] > 0) {
                                $d1 = $this->gsatelite->get_tabla('axr_articulo_materiaxarticulo', array('axr_id_axc' => $hdnProductoCot[$i]));
                                $d2 = $this->gsatelite->get_tabla('mxa_mano_obraxarticulo', array('mxa_id_axc' => $hdnProductoCot[$i]));
                                $d3 = $this->gsatelite->get_tabla('exa_estimacionxarticulo', array('exa_id_axc' => $hdnProductoCot[$i]));
                                $d4 = $this->gsatelite->get_tabla('acs_articulo_costo', array('acs_id_axc' => $hdnProductoCot[$i]));

                                if ($d1 > 0) {
                                    foreach ($d1 as $key => $value) {
                                        $array_axm = array(
                                            'axm_id_axo' => $axo_id,
                                            'axm_id_art_materia' => $value['axr_id_art_materia'],
                                            'axm_cantidad' => $value['axr_cantidad'],
                                            'axm_precio' => $value['axr_precio'],
                                            'axm_estado' => 1,
                                            'axm_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'axm_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'axm_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'axm_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'axm_id_cva' => null
                                        );
                                        $this->gsatelite->ingresar('axm_articulo_matxarticulo_ord', $array_axm);
                                    }
                                }

                                if ($d2 > 0) {
                                    foreach ($d2 as $dato => $val) {
                                        $array_mxo = array(
                                            'mxo_id_axo' => $axo_id,
                                            'mxo_id_mob' => $val['mxa_id_mob'],
                                            'mxo_cantidad' => $val['mxa_cantidad'],
                                            'mxo_precio' => $val['mxa_precio'],
                                            'mxo_estado' => 1,
                                            'mxo_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'mxo_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'mxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'mxo_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'mxo_id_emp' => $val['mxa_id_emp']
                                        );
                                        $this->gsatelite->ingresar('mxo_mano_obraxarticulo_ord', $array_mxo);
                                    }
                                }

                                if ($d3 > 0) {
                                    foreach ($d3 as $est => $valor) {
                                        $array_exr = array(
                                            'exr_id_esm' => $valor['exa_id_esm'],
                                            'exr_id_axo' => $axo_id,
                                            'exr_cantidad' => $valor['exa_cantidad'],
                                            'exr_precio' => $valor['exa_precio'],
                                            //'exr_observacion' => $valor['exa_observacion'],
                                            'exr_estado' => 1,
                                            'exr_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'exr_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'exr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'exr_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );
                                        $this->gsatelite->ingresar('exr_estimacionxarticulo', $array_exr);
                                    }
                                }

                                if ($d4 > 0) {
                                    foreach ($d4 as $k => $info) {
                                        $array_acr = array(
                                            'acr_id_axo' => $axo_id,
                                            'acr_costo' => $info['acs_costo'],
                                            'acr_observacion' => $info['acs_observacion'],
                                            'acr_estado' => 1,
                                            'acr_usu_mod' => $this->tank_auth->get_user_id(),
                                            'acr_fecha_mod' => date('Y-m-d H:i:s')
                                        );

                                        $idacs = $this->gsatelite->get_campo('acr_articulo_costo_prod', 'acr_id_axo', array('acr_id_axo' => $axo_id));

                                        if (count($idacs) > 0) {
                                            $registro = $this->gsatelite->actualizar_array('acr_articulo_costo_prod', $array_acr, array('acr_id_axo' => $axo_id));
                                        } else {
                                            $registro = $this->gsatelite->ingresar('acr_articulo_costo_prod', $array_acr);
                                        }
                                    }
                                }
                            }

                            //Se eliminan primero las caracteristicas ingresadas
                            $this->gsatelite->borrado_general('cdo_caracteristicaxdetalle_orden', array('cdo_id_axo' => $axo_id));
                            //Se procesan las caracteristicas
                            //Se procesan los detalles de las caracteristicas

                            if (isset($post_array['caracteristicas_' . $productos[$i].'_'.$correlativo[$i]]) && count($post_array['caracteristicas_' . $productos[$i].'_'.$correlativo[$i]]) > 0) {
                                $caracteristicas = $post_array['caracteristicas_' . $productos[$i].'_'.$correlativo[$i]];
                                $valores = $post_array['valoresCarac_' . $productos[$i].'_'.$correlativo[$i]];

                                for ($j = 0; $j < count($post_array['caracteristicas_' . $productos[$i].'_'.$correlativo[$i]]); $j++) {
                                    if ($caracteristicas[$j] != '') {
                                        $detalle_carac_array = array(
                                            'cdo_id_cxu' => $caracteristicas[$j],
                                            'cdo_id_axo' => $axo_id,
                                            'cdo_valor' => $valores[$j],
                                            'cdo_estado' => 1,
                                            'cdo_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'cdo_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'cdo_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'cdo_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );
                                        $this->gsatelite->ingresar('cdo_caracteristicaxdetalle_orden', $detalle_carac_array);
                                    }
                                }
                            }
                        }
                    }
                }
                $ruta = $this->input->post('ruta');
                $carpeta = $this->input->post("nombreCarpeta");
                $titulos = $this->input->post("titulo_doc");
                $aop_ids = $this->input->post('id_aop');
                if (count($ruta) > 0) {

                    for ($i = 0; $i < count($ruta); $i++) {
                        
                        if ($ruta[$i] != "") {
                            $img = $ruta[$i];
                            $titulo = $titulos[$i];

                            $this->datos_anexo($img, $ord_id, $carpeta, $titulo);
                        }
                    }
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Orden de Producción", 'texto_alerta' => "La orden se ingresó con el nombre " . $txtConcepto);
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Orden no ingresada, favor verificar información");
            }

            $this->session->set_flashdata($alerta);

            $tipoBtn = $post_array['btnCrear'];

            if ($tipoBtn == 1) {
                redirect('proyectos/procesos/editar_orden/' . $ord_id);
            } else {
                redirect('proyectos/procesos/orden_produccion');
            }
        } else {
            //parametro para saber si se permite agregar mas de un producto
            $permite_mas_productos = $this->gsatelite->get_parametro('SYS_PERMITE_DUPLICAR_PRODUCTO');
            $data['permite_mas_productos'] = (trim($permite_mas_productos) != '')?$permite_mas_productos:0;

            $orden = $this->proyecto_model->get_ordenes(array('ord_id' => $ord_id));
            $data['contactos'] = null;
            $data['cotizaciones'] = null;
            if ($orden[0]['ord_id_cli'] != null) {
                $data_cliente = $this->get_contactos_y_cotizaciones($orden[0]['ord_id_cli']);
                $data['contactos'] = $data_cliente['contactos'];
                $data['cotizaciones'] = $data_cliente['cotizaciones'];
            }

            $data['detalle_orden'] = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $ord_id));
            //$data['tipo_orden'] = $this->gsatelite->get_dropdown('tio_tipo_orden', '{tio_nombre}', 'tipo_orden', array('tio_estado' => 1), $orden[0]['ord_id_tio'], null, null, true);
            $data['cliente'] = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $orden[0]['ord_id_cli']));

            //Se obtienen los proyectos
            $this->db->join('epr_estado_proyecto','epr_id = pcl_id_epr', 'inner');
            $proyectos = $this->gsatelite->get_tabla('pcl_proyecto_cliente', array('pcl_id_cli' => $orden[0]['ord_id_cli'], 'pcl_estado' => 1, 'epr_cierre'=>0));
            $opciones = "<option></option>";
            if (count($proyectos) > 0) {
                foreach ($proyectos as $pcl) {
                    $selected = '';
                    if($pcl['pcl_id'] == $orden[0]['ord_id_pcl']){
                        $selected = 'selected';
                    }
                    $nombre = $pcl['pcl_codigo'] . ' ' . $pcl['pcl_nombre'];
                    $opciones .= "<option value='" . $pcl['pcl_id'] . "' ".$selected.">" . $nombre . "</option>";
                }
            }
            $data['proyecto'] = $opciones;

            $data['vendedores'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), $orden[0]['ord_id_ven'], '', 'ven_id', true);
            $select = '<option value=""></option>';
            $tipo_ord_reg = $this->gsatelite->get_tabla('tio_tipo_orden', array('tio_estado' => 1));
            foreach ($tipo_ord_reg as $key) {
                if($key['tio_id'] == $orden[0]['ord_id_tio']){
                    $select .= '<option value="'.$key['tio_id'].'" pre="'.$key['tio_prefijo'].'" selected>'.$key['tio_nombre'].'</option>';
                } else{
                    $select .= '<option value="'.$key['tio_id'].'" pre="'.$key['tio_prefijo'].'">'.$key['tio_nombre'].'</option>';
                }
            }
            $data['tipo_orden'] = $select;
            $data['categoria']      = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_nombre}', '', array('tia_estado' => 1), null, '', 'tia_id', true);
            $data['marca']          = $this->gsatelite->get_dropdown('mrp_marca_producto', '{mrp_nombre}', '', array('mrp_estado' => 1), null, '', 'mrp_id', true);
            $data['presentacion']   = $this->gsatelite->get_dropdown('ppr_presentacion_producto', '{ppr_nombre}', '', array('ppr_estado' => 1), null, '', 'ppr_id', true);
            //$data['etapa'] = $this->gsatelite->get_dropdown('etp_etapa', '{etp_nombre}', '', array('etp_estado' => 1), null, '', 'etp_id', true);
            $data['orden'] = $orden[0];
            $data['titulo_personal'] = "Editar Orden";

            ///SE OBTIENEN LOS ANEXOS 
            $anexos = $this->gsatelite->get_tabla('aop_anexo_orden_produccion',['aop_id_ord'=>$ord_id]);
            $data['anexos']=$anexos;

            cargarvista($data);
        }
    }
    //METODO PARA ELIMINAR ANEXOS DE ORDEN DE COMPRA, SE LLAMA DESDE AJAX EN EL ARCHIVO frmOrden.js
    function delete_anexo_orden(){
        $id = $this->input->post('id_aop');
        $this->gsatelite->borrado_general('aop_anexo_orden_produccion', ['aop_id' => $id]);
        echo 1;
    }
    function procesar_orden() {
        satelite_validar();
        $this->db->group_by("emp_id");
        $this->db->join("mxo_mano_obraxarticulo_ord", "mxo_id_emp = emp_id");
        $data['empleados']          = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
        $data['ordenes']            = $this->gsatelite->get_dropdown('ord_orden', '{ord_codigo} - {ord_concepto}', '', array('ord_estado' => 1), null, '', 'ord_id', true);
        $data['titulo_personal']    = "Procesar orden";
        $this->_cargarvista($data);
    }

    function procesar_planilla() {
        satelite_validar();
        $this->db->group_by("emp_id");
        $this->db->join("mxo_mano_obraxarticulo_ord", "mxo_id_emp = emp_id");
        $data['empleados']          = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
        $data['ordenes'] = $this->gsatelite->get_dropdown('ord_orden', '{ord_codigo} - {ord_concepto}', '', array('ord_estado' => 1), null, '', 'ord_id', true);
        $data['titulo_personal'] = "Procesar planilla";
        $this->_cargarvista($data);
    }

    function get_detalles() {
        $id_orden = $this->input->post('id');

        $productos = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $id_orden));

        $detalles = "<option></option>";
        if (count($productos) > 0) {
            foreach ($productos as $axo) {
                $detalles .= "<option value='" . $axo['axo_id'] . "'>" . $axo['art_codigo'] . ' - ' . $axo['art_nombre'] . "</option>";
            }
        }
        //$detalles = $this->gsatelite->get_dropdown('axo_articuloxorden', '{axo_descripcion}', '', array('axo_id_ord' => $id_orden), null, '', 'axo_id', true);
        echo json_encode(array('drop' => $detalles));
    }

    function get_mano_obra() {
        $id_detalle             = $this->input->post('id');
        $orden                  = $this->input->post('orden');
        $responsable             = $this->input->post('responsable');

        $data['planilla']       = $this->input->post('planilla');

        $where = null;

        if ( $id_detalle != "" ){
            $where['mxo_id_axo'] = $id_detalle;
        }

        if ( $orden != "" ){
            $where['axo_id_ord'] = $orden;
        }

        if ( $responsable != "" ){
            $where['emp_id'] = $responsable;
        }
        $where['mxo_estado'] = 1;

        $data['mano_obra'] = $this->proyecto_model->consultar_mano_obra($where);
        $data['id_detalle'] = $id_detalle;
        $html = $this->load->view('proyectos/procesos/detalle_mano_obra', $data, true);
        echo json_encode(array('drop' => $html));
    }

    function get_mano_obra_detalles($id_axo, $id_mxo, $planilla = NULL) {
        $info_general   = $this->proyecto_model->get_mano_obra($id_axo, $id_mxo);

        $this->db->join("ord_orden","ord_id = axo_id_ord");
        $this->db->join("pcl_proyecto_cliente","pcl_id = ord_id_pcl");
        $proyecto       = $this->gsatelite->get_campo("axo_articuloxorden","pcl_codigo",array("axo_id" => $id_axo) );

        // Traerse los detalles
        $condiciones = array(
            'sxm_id_mxo' => $id_mxo,
            'sxm_estado' => 1,
        );
        $tabla_detalles['detalle']  = $this->proyecto_model->get_seguimiento_mano_obra($condiciones);
        $tabla_detalles['info']     = $info_general[0];
        $tabla_detalles['planilla'] = $planilla;
        $data['tabla_detalles']     = $this->load->view('proyectos/procesos/tabla_mano_obra', $tabla_detalles, true); // Si existen registros

        $data['info']       = $info_general[0];
        $data['id_obra']    = $id_mxo;
        $data['id_axo']     = $id_axo;
        $data['planilla']   = $planilla;
        $data['proyecto']   = $proyecto;

        $this->gsatelite->cargar_vista_masterpage('proyectos/procesos/porcentaje_trabajado', $data); // Carga las librerias de la Masterpage
    }

    function guardar_detalle_mano_obra() {
        satelite_validar();
        if ($_POST) {
            //die(var_dump($_POST));
            $fecha = $this->input->post('fecha');
            $porcentaje = $this->input->post('porcentaje');
            $precio = $this->input->post('precio');
            $obs = $this->input->post('observaciones');
            $avance = $this->input->post('avance');
            $id_detalle = $_POST['id_detalle_mxo'];
            $id_axo = $_POST['id_axo'];
            $id_sxm_procesado = (isset($_POST['procesado'])) ? $_POST['procesado'] : array();
            $en_progreso_drop = (isset($_POST['en_progreso_drop'])) ? $_POST['en_progreso_drop'] : array();
            $en_progreso = (isset($_POST['en_progreso'])) ? $_POST['en_progreso'] : array();

            // Filtro de las filas que NO seran eliminadas
            $filtro = array_merge($id_sxm_procesado, $en_progreso);

            if (isset($_POST['en_progreso_drop'])) {
                // Obtener los registros que aun no han sido procesados
                $en_progreso_array = explode("#", $en_progreso_drop);
                $pendientes = $this->proyecto_model->no_procesados(array('sxm_id_mxo' => $id_detalle));
                // Traemos una matriz, se neceita un Array unidimensional.
                $pendientes_array = array();
                foreach ($pendientes as $valor1) {
                    foreach ($valor1 as $valor2) {
                        $pendientes_array[] = $valor2;
                    }
                }

                foreach ($pendientes_array as $key2 => $value) {
                    if (in_array($en_progreso_array[$key2], $pendientes_array)) {
                        $id_inn = $this->gsatelite->get_campo('sxm_seguimiento_mano_obraxarticulo_ord', 'sxm_id_inn', array('sxm_id' => $en_progreso_array[$key2]));
                        $sxm_padre = $this->gsatelite->borrado_general('sxm_seguimiento_mano_obraxarticulo_ord', array('sxm_id' => $en_progreso_array[$key2], 'sxm_id_mxo' => $id_detalle));
                        if ($sxm_padre != 0) {
                            $inn_hijo = $this->gsatelite->borrado_general('inn_ingreso', array('inn_id' => $id_inn));
                        }
                    }
                }
            }

            // Hacer un borrado general, unicamente de los que NO hayan sido procesados en planilla.
            if (!empty($filtro)) {
                $this->db->where_not_in('sxm_id', $filtro);
            }
            $borrado = $this->gsatelite->borrado_general('sxm_seguimiento_mano_obraxarticulo_ord', array('sxm_id_mxo' => $id_detalle, 'sxm_id_inn' => null));

            foreach ($porcentaje as $key => $value) {
                if (empty($filtro[$key])) {
                    $detalle = array(
                        'sxm_id_mxo' => $id_detalle,
                        'sxm_fecha' => formatear_fecha('Y-m-d H:i:s', $fecha[$key] . ' ' . date('H:i:s')),
                        'sxm_porcentaje' => $value,
                        'sxm_precio' => $precio[$key],
                        'sxm_porcentaje_avance' => $avance[$key],
                        'sxm_observacion' => $obs[$key],
                        'sxm_estado' => 1,
                        'sxm_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sxm_fecha_creacion' => date('Y-m-d H:i:s'),
                        'sxm_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sxm_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $registro = $this->gsatelite->ingresar('sxm_seguimiento_mano_obraxarticulo_ord', $detalle);
                } else {
                    $this->gsatelite->actualizar_array('sxm_seguimiento_mano_obraxarticulo_ord', array('sxm_porcentaje_avance' => $avance[$key]), array('sxm_id' => $filtro[$key]));
                }
            }
            if ($registro > 0 || $borrado > 0 || $inn_hijo > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Procesado", 'texto_alerta' => "Se procesó el registro correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Registro no ingresado, favor verificar información");
            }

            $this->session->set_flashdata($alerta);
            redirect('proyectos/procesos/get_mano_obra_detalles/' . $id_axo . '/' . $id_detalle);
        }
    }

    function procesar_en_planilla() {
        $id_sxm = $this->input->post('id');
        $info_planilla = $this->proyecto_model->info_planilla($id_sxm);
        $data['info_planilla'] = $info_planilla[0];

        $planillas_empleado = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $info_planilla[0]['emp_id']));
        $idsPlanillas = array_column($planillas_empleado, 'txe_id_tpl');

        $this->db->where_in('tpl_id', $idsPlanillas);
        $data['tipo_planilla'] = $this->gsatelite->get_tabla('tpl_tipo_planilla');
        $html = $this->load->view('proyectos/procesos/formulario_planilla', $data, true);
        echo json_encode(array('drop' => $html));
    }

    function registrar_planilla() {
        if ($_POST) {
            $tig_id         = $this->gsatelite->get_parametro('ID_TIG_TIPO_INGRESO');
            $id_planilla    = $this->input->post('planilla');
            $periodo        = $this->input->post('slcPeriodo');
            $id_empleado    = $this->input->post('id_empleado');
            $motivo         = $this->input->post('motivo');
            $valor          = $this->input->post('valor');
            $fecha          = $this->input->post('fecha');
            $observacion    = $this->input->post('observacion');
            $id_mxo         = $this->input->post('id_mxo');
            $id_axo         = $this->input->post('id_axo');
            $id_sxm         = $this->input->post('id_sxm');
            $codigo         = $this->input->post('proyecto');

            $ingreso = array(
                'inn_id_tig'        => $tig_id,
                'inn_id_emp'        => $id_empleado,
                'inn_motivo'        => $motivo,
                'inn_valor'         => $valor,
                'inn_fecha_desde'   => date('Y-m-d H:i:s', strtotime($fecha)),
                'inn_cuota'         => 1,
                'inn_id_tpl'        => $id_planilla,
                'inn_observacion'   => $observacion,
                'inn_referencia'    => $codigo,
                'inn_estado'        => 1,
                'inn_usu_mod'       => $this->tank_auth->get_user_id(),
                'inn_fecha_mod'     => date('Y-m-d H:i:s')
            );

            $registro = $this->gsatelite->ingresar('inn_ingreso', $ingreso);

            if ($registro > 0) {
                $this->gsatelite->actualizar_array('sxm_seguimiento_mano_obraxarticulo_ord', array('sxm_id_inn' => $registro, 'sxm_id_pla' => $periodo), array('sxm_id' => $id_sxm));
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Procesado", 'texto_alerta' => "Se procesó el registro correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Registro no ingresado, favor verificar información");
            }

            $this->session->set_flashdata($alerta);
            redirect('proyectos/procesos/get_mano_obra_detalles/' . $id_axo . '/' . $id_mxo . '/pla');
        }
    }

    /*
     * @author: Mario Marquez
     * Función que busca los productos por nombre asignados a una categoria y bodega (saldos)
     * Si se les proporciona.
     * @return: Objeto json de la informacion resultante
     */

    public function get_productos_like() {
        satelite_validar(true);
        $categoria = ($this->input->post('categoria') != '') ? $this->input->post('categoria') : null;
        $tipo = ($this->input->post('tipo') != '') ? $this->input->post('tipo') : null;
        $producto = ($this->input->post('producto') != '') ? $this->input->post('producto') : null;
        $tip_productos = ($this->input->post('producto_invent') != '') ? $this->input->post('producto_invent') : null;

        $where = null;
        $like = null;
        $flag_consulta = 0;
        $where['art_estado'] = 1;
        if ($categoria != null) {
            $where['art_id_tia'] = $categoria;
        }
        if ($tipo != '') {
            switch ($tipo) {
                case 1:
                    $where['art_tipo'] = 0; // Productos
                    break;
                case 2:
                    $where['art_tipo'] = 1; // Serivicios
                    break;
                case 3:
                    $flag_consulta = 1; // Se consultarán activos.
                    break;
            }
        }

        if ($producto != '') {
            $like["concat_ws(' ',trim(art_codigo), trim(art_nombre), trim(ppr_nombre))"] = $producto;
            //$like['art_codigo'] = $producto;
        }
        if($tip_productos != null){
            $where['art_produccion'] = 1;
        }

        $arreglo = array();
                     $this->db->limit(500); //limitar los resultados a pocas coincidencias.
        $productos = $this->proyecto_model->get_productos_like($where, $like, $flag_consulta, $producto);
        //die(print_r($this->db->last_query()));

        if (count($productos) > 0 && $flag_consulta==0) {
            foreach ($productos as $key => $value) {
                $arreglo[$key]['producto'] = $value['art_id'];
                $marca = ($value['mrp_nombre'] != "") ? " ( " . $value['mrp_nombre'] . " )" : "";
                $presentacion = ($value['ppr_nombre'] != null)?'-'.$value['ppr_nombre']:null;
                $arreglo[$key]['prod_nombre'] = $value['art_codigo'].' - '.$value['art_nombre'] . $marca . $presentacion;
            }
        }else if(count($productos) > 0 && $flag_consulta==1){
            foreach ($productos as $key => $value) {
                $arreglo[$key]['producto'] = $value['act_id'];
                $presentacion = ($value['ppr_nombre'] != null)?'-'.$value['ppr_nombre']:null;
                $arreglo[$key]['prod_nombre'] = $value['act_codigo'].' - '.$value['act_nombre'].$presentacion;
            }
        }
        echo json_encode($arreglo);
    }

    /*
     * @author: Mario Marquez
     * $cli_busqueda: Parametro de busqueda, desde otra funcion
     * Si no se llena sera un Json
     */

    public function get_clientes_like($cli_busqueda = null) {

        $cliente = ($cli_busqueda != null) ? $cli_busqueda : $this->input->post('cliente');

        $resultado = null;
        $arreglo = array();
        if ($cliente != null) {

            $where = array(
                'cli_estado' => 1
            );

            $like = array("CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido)" => $cliente);

            $resultado = $this->proyecto_model->get_clientes($where, $like);



            if (count($resultado) > 0) {
                foreach ($resultado as $key => $value) {
                    $arreglo[$key]['cliente'] = $value['cli_id'];
                    $arreglo[$key]['cliente_nombre'] = $value['cliente'];
                }
            }
        }
        if ($cli_busqueda != null) {
            return $resultado;
        }

        echo json_encode($arreglo);
    }

    /*
     * @author: Mario Marquez
     * $idProc: Id del producto a solicitar
     * @detalle: Se obtiene toda la informacion en general del producto (Inpuestos, Cuentas, Caracteristicas, Etc)
     */
    public function get_detalles_producto($idProc = null, $flag = false) {
        $producto = ($idProc > 0) ? $idProc : $this->input->post('producto');
        $where = array('cva_id_art' => $producto, 'cva_estado' => 1);
        //Se obtienen las medidas del producto
        $conversiones = $this->inventario_model->get_conversiones_producto($where);
        $var = "<option></option>";
        $etiqueta = 0;
        foreach ($conversiones as $fila) {
            $selected = "";
            if ($fila['cva_defecto'] == 1) {
                $selected = "selected=selected";
            }
            $var .= "<option data-def='".$fila['cva_defecto']."' data-conv='".$fila['cva_conversion']."' ".$selected." value='".$fila['cva_id']."' id='opt_conv".$etiqueta."'>".$fila['mep_nombre']."</option>";
            $etiqueta++;
        }
        //Se obtienen los impuestos del articulo
        $where_imp = array('ixa_id_art' => $producto);
        $impuestos_array = $this->inventario_model->get_impuestos_producto($where_imp);
        $etiqueta = 0;
        $impuestos = '';
        if (count($impuestos_array) > 0) {
            foreach ($impuestos_array as $imp) {
                $impuestos .= "<option data-ixa='" . $imp['ixa_id'] . "' data-porcentaje='" . $imp['imp_porcentaje'] . "' value='" . $imp['imp_id'] . "' id='opt_ixa" . $etiqueta . "'>" . $imp['imp_nombre'] . "</option>";
                $etiqueta++;
            }
        }
        //Se obtiene la bodega asignada al procutdo
        $bodegaProducto = $this->gsatelite->get_campo('art_articulo', 'art_id_bod', array('art_id' => $producto));
        $sectorProducto = $this->gsatelite->get_campo('art_articulo', 'art_id_sxb', array('art_id' => $producto));
        //Se obtienen las bodegas activas
        $bodegas = $this->gsatelite->get_tabla('bod_bodega', array('bod_estado' => 1));
        $bodegas_opciones = "<option></option>";
        if (count($bodegas) > 0) {
            foreach ($bodegas as $bod) {
                $selected = ($bod['bod_id'] == $bodegaProducto) ? "selected=selected" : "";
                $bodegas_opciones .= "<option " . $selected . " value='" . $bod['bod_id'] . "'>" . $bod['bod_nombre'] . "</option>";
            }
        }
        $sector_opciones = "<option></option>";
        if ($bodegaProducto > 0) {
            //Se obtiene los sectores de la bodega asignada
            $sectores = $this->inventario_model->get_sector_grid($bodegaProducto);
            foreach ($sectores as $sec) {
                $selected = ($sec['sxb_id'] == $sectorProducto) ? "selected=selected" : "";
                $sector_opciones .= "<option " . $selected . " value='" . $sec['sxb_id'] . "'>" . $sec['seb_nombre'] . "</option>";
            }
        }
        $caracteristicas = $this->inventario_model->get_caracteristicas_producto(array('cxu_id_art' => $producto, 'cxu_estado' => 1));
        $opciones_carac = "<option></option>";
        if (count($caracteristicas) > 0) {
            foreach ($caracteristicas as $car) {
                $opciones_carac .= "<option data-valor='" . $car['cxu_valor'] . "' data-car='" . $car['car_id'] . "' data-cxr='" . $car['cxu_id_cxr'] . "' value='" . $car['cxu_id'] . "'>" . $car['car_nombre'] . "</option>";
            }
        }
        $producto_data = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $producto));
        $info_producto = array(
            'producto' => $producto_data[0]['art_id'],
            'prod_codigo' => $producto_data[0]['art_codigo'],
            'prod_nombre' => $producto_data[0]['art_nombre'],
            'prod_desc' => $producto_data[0]['art_descripcion'],
        );
        $receta_art = $this->gsatelite->get_tabla('rea_receta_articulo', array('rea_id_art' => $producto, 'rea_estado' => 1));
        $slct_receta = "<option></option>";
        foreach ($receta_art as $key => $value) {
            $slct_receta .= '<option value="' . $value['rea_id'] . '">' . $value['rea_codigo'] . ' - ' . $value['rea_nombre'] . '</option>';
        }
        $arreglo = array(
            'medidas' => $var,
            'impuestos' => $impuestos,
            'bodegas' => $bodegas_opciones,
            'sectores' => $sector_opciones,
            'producto' => $info_producto,
            'caracteristicas' => $opciones_carac,
            'recetas' => $slct_receta,
            'ctdad_recetas' => count($receta_art)
        );
        if (!$flag) {
            echo json_encode($arreglo);
        } else {
            return $arreglo;
        }
    }

    /*
     * @author: Mario Marquez
     * $idCot: Id de la cotizacion
     * @detalle: Se obtiene las ordenes y productos asociados a una cotización
     */

    public function get_ordenes_productos_cotizacion() {
        $cotizacion = $this->input->post('cotizacion');

        if ($cotizacion > 0) {

            $arreglo = array(
                'ordenes',
                'productos'
            );

            //Se obtienen las ordenes de producción
            $opciones = "<option></option>";
            $ordenes = $this->gsatelite->get_tabla('ord_orden', array('ord_id_cot' => $cotizacion));
            if (count($ordenes) > 0) {
                foreach ($ordenes as $ord) {
                    $opciones .= "<option value='" . $ord['ord_id'] . "'>" . $ord['ord_codigo'] . "</option>";
                }
            }

            $arreglo['ordenes'] = $opciones;

            $opciones = "<option></option>";
            $productos = $this->proyecto_model->get_detalle_cotizacion(array('axc_id_cot' => $cotizacion));

            if (count($productos) > 0) {
                foreach ($productos as $prod) {

                    $caracteristicas = $this->inventario_model->get_caracteristicas_producto(array('cxu_id_art' => $prod['axc_id_art']));
                    $opciones_carac = "<option></option>";
                    if (count($caracteristicas) > 0) {
                        foreach ($caracteristicas as $car) {
                            $opciones_carac .= "<option data-valor='" . $car['cxu_valor'] . "' data-car='" . $car['car_id'] . "' data-cxr='" . $car['cxu_id_cxr'] . "' value='" . $car['cxu_id'] . "'>" . $car['car_nombre'] . "</option>";
                        }
                    }

                    $opciones .= "<option data-codigo='" . $prod['art_codigo'] . "' data-medida='" . $prod['mep_nombre'] . "' data-conversion='" . $prod['axc_id_cva'] . "' data-cantidad='" . $prod['axc_cantidad'] . "' data-descripcion='" . $prod['axc_descripcion'] . "'  value='" . $prod['axc_id_art'] . "'>" . $prod['art_nombre'] . "</option>";
                }
            }

            $arreglo['productos'] = $opciones;

            echo json_encode($arreglo);
        }
    }

    function lotes($ord_id = null) {
        satelite_validar();
        if ($ord_id == null) {
            redirect('proyectos/procesos/orden_produccion');
        }

        $orden = $this->gsatelite->get_tabla('ord_orden', array('ord_id' => $ord_id));
        $this->db->join('lop_lote_produccion', 'lop_id_axo = axo_id', 'inner');
        $this->db->group_by('axo_id');
        $detalle_orden = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $ord_id));
        $data['orden'] = $orden[0];


        $data['detalle_orden'] = $detalle_orden;
        $data['titulo_personal'] = "Lotes por Orden de Producción";
        cargarvista($data);
    }

    function agregar_lotes($ord_id = null) {
        satelite_validar();
        if ($ord_id == null) {
            redirect('proyectos/procesos/orden_produccion');
        }
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));

            $productos = $post_array['productos'];
            $nombreLotes = $post_array['nombreLotes'];
            $cantidades = $post_array['cantidades'];

            if (count($productos) > 0) {
                for ($i = 0; $i < count($productos); $i ++) {
                    $lotes_array = array(
                        'lop_id_axo' => $productos[$i],
                        'lop_nombre' => $nombreLotes[$i],
                        'lop_cantidad' => $cantidades[$i],
                        'lop_estado' => 1,
                        'lop_usu_creacion' => $this->tank_auth->get_user_id(),
                        'lop_fecha_creacion' => date('Y-m-d H:i:s'),
                        'lop_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'lop_fecha_modificacion' => date('Y-m-d H:i:s'),
                    );

                    $lop_id += $this->gsatelite->ingresar('lop_lote_produccion', $lotes_array);
                }
            }

            if ($lop_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Lotes por Orden de Producción", 'texto_alerta' => "La información se proceso correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Orden no ingresada, favor verificar información");
            }

            $this->session->set_flashdata($alerta);

            $tipoBtn = $post_array['btnCrear'];

            if ($tipoBtn == 1) {
                redirect('proyectos/procesos/agregar_lotes/' . $ord_id);
            } else {
                redirect('proyectos/procesos/lotes/' . $ord_id);
            }
        }
        $orden = $this->gsatelite->get_tabla('ord_orden ', array('ord_id' => $ord_id));
        $detalle_orden = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $ord_id));
        $data['orden'] = $orden[0];
        $data['detalle_orden'] = $detalle_orden;
        $data['titulo_personal'] = "Agregar Lotes por Orden de Producción";
        cargarvista($data);
    }

    function editar_lotes($axo_id = null) {
        satelite_validar();
        if ($axo_id == null) {
            redirect('proyectos/procesos/orden_produccion');
        }

        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            $ord_id = $post_array['hdnOrden'];
            $hdnDetalle = $post_array['hdnDetalle'];
            $productos = $post_array['productos'];
            $nombreLotes = $post_array['nombreLotes'];
            $cantidades = $post_array['cantidades'];

            if (count($productos) > 0) {

                //Primero se eliminan los registros que no existan
                $dataIds = array();
                for ($i = 0; $i < count($productos); $i ++) {
                    if ($hdnDetalle[$i] > 0) {
                        $dataIds[] = $hdnDetalle[$i];
                    }
                }
                $dataLotes = $this->proyecto_model->get_lotes(array('lop_id_axo' => $axo_id));
                foreach ($dataLotes as $lop) {
                    if (!in_array($lop['lop_id'], $dataIds) && $lop['num_etapas'] == 0) {
                        $this->gsatelite->borrado_general('lop_lote_produccion', array('lop_id' => $lop['lop_id']));
                    }
                }
                for ($i = 0; $i < count($productos); $i ++) {
                    $lotes_array = array(
                        'lop_id_axo' => $productos[$i],
                        'lop_nombre' => $nombreLotes[$i],
                        'lop_cantidad' => $cantidades[$i],
                        'lop_estado' => 1,
                        'lop_usu_creacion' => $this->tank_auth->get_user_id(),
                        'lop_fecha_creacion' => date('Y-m-d H:i:s'),
                        'lop_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'lop_fecha_modificacion' => date('Y-m-d H:i:s'),
                    );
                    //Si el id detalle existe se actualiza, sino se ingresa
                    if ($hdnDetalle[$i] > 0) {
                        unset($lotes_array['lop_usu_creacion']);
                        unset($lotes_array['lop_fecha_creacion']);

                        $lop_id += $this->gsatelite->actualizar_array('lop_lote_produccion', $lotes_array, array('lop_id' => $hdnDetalle[$i]));
                    } else {
                        $lop_id += $this->gsatelite->ingresar('lop_lote_produccion', $lotes_array);
                    }
                }
            }

            if ($lop_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Lotes por Orden de Producción", 'texto_alerta' => "La información se proceso correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Orden no ingresada, favor verificar información");
            }

            $this->session->set_flashdata($alerta);

            $tipoBtn = $post_array['btnCrear'];

            if ($tipoBtn == 1) {
                redirect('proyectos/procesos/editar_lotes/' . $axo_id);
            } else {
                redirect('proyectos/procesos/lotes/' . $ord_id);
            }
        }

        $detalle_orden = $this->proyecto_model->get_detalle_orden(array('axo_id' => $axo_id));
        $ord_id = $detalle_orden[0]['axo_id_ord'];
        $orden = $this->gsatelite->get_tabla('ord_orden ', array('ord_id' => $ord_id));
        $data['orden'] = $orden[0];
        $data['detalle_orden'] = $detalle_orden;

        $data['lotes'] = $this->proyecto_model->get_lotes(array('lop_id_axo' => $axo_id));

        $data['titulo_personal'] = "Editar Lotes por Orden de Producción";
        cargarvista($data);
    }

    function envios_parciales($ord_id = null) {
        satelite_validar();
        if ($ord_id == null) {
            redirect('inicio');
        }

        $crud = new grocery_CRUD();

        $columns = array(
            'eno_id_usu',
            'eno_fecha_envio',
            'total_enviados',
            'eno_estado'
        );

        //Alias para las columnas
        $alias = array(
            'eno_id_usu' => 'Realizado por',
            'eno_fecha_envio' => 'Fecha de envío',
            'total_enviados' => 'Productos enviados',
            'eno_estado' => 'Estado',
        );

        $crud->set_table('eno_envio_orden')
                ->set_subject('Envío Parcial')
                ->where('eno_id_ord', $ord_id)
                ->columns($columns)
                ->display_as($alias)
                ->unset_export()
                ->unset_print()
                ->unset_edit()
                ->unset_delete()
                ->unset_add()
                ->add_action('Ver', 'minia-icon-search', 'proyectos/procesos/editar_envio_parcial/1')
                ->add_action('Imprimir', 'icomoon-icon-printer imprimir', 'proyectos/procesos/imprimir_envio_parcial/'.$ord_id,'print_doc',null,null,array('eno_estado' => 'Activo'))
                ->add_action('Anular', ' icomoon-icon-cancel-3 ', '', 'anular ver-accion-modal', function($primary_key, $row) {
                    $ids = ($row->eno_estado == 'Activo') ? $row->eno_id : 'cancelar';
                    return base_url("proyectos/procesos/anular_envio_parcial/1/" . $ids);
                })
                ->callback_column('eno_id_usu', function($value, $primary_key) {
                    $user_id = $value;
                    $informacion = $this->inventario_model->informacion_empleado($user_id);

                    $nombre = "";
                    if ($informacion[0]['emp_nombre'] != '') {
                        $nombre = $informacion[0]['emp_nombre'] . " " . $informacion[0]['emp_apellido'];
                    }

                    return $nombre;
                })
                ->callback_column('total_enviados', function($value, $primary_key) {
                    $total_enviados = $this->gsatelite->get_suma('deo_detalle_envio_orden', 'deo_cantidad', array('deo_id_eno' => $primary_key->eno_id));
                    return $total_enviados;
                })
                ->field_type('eno_estado', 'dropdown', array('1' => 'Activo', '0' => 'Anulado'))
        ;

        $this->db->join('eno_envio_orden', 'eno_id = deo_id_eno');
        $total_enviados = $this->gsatelite->get_suma('deo_detalle_envio_orden', 'deo_cantidad', array('eno_id_ord' => $ord_id));
        
        $orden = $this->proyecto_model->get_ordenes(array('ord_id' => $ord_id));
        $total_productos_orden = $this->gsatelite->get_suma('axo_articuloxorden', 'axo_cantidad', array('axo_id_ord' => $ord_id));
        $data['no_add'] = 0;
        if ($total_enviados == $total_productos_orden) {
            $data['no_add'] = 1;
        }

        $output = $crud->render();
        $data['orden'] = $orden[0];
        $data['total_productos'] = $total_productos_orden;
        $data['titulo_personal'] = "Envíos Parciales";
        $this->_cargarvista($data, $output);
    }

    function agregar_envio_parcial($ord_id = null) {
        satelite_validar();
        if ($ord_id == null) {
            redirect('inicio');
        }
        if ($this->input->post()) {
            $post_array = $this->input->post();
            $tipo_btn = $post_array['btnCrear'];
            $envio_array = array(
                'eno_id_usu' => $this->tank_auth->get_user_id(),
                'eno_id_ord' => $ord_id,
                'eno_fecha_envio' => date('Y-m-d H:i:s'),
                'eno_estado' => 1,
                'eno_usu_creacion' => $this->tank_auth->get_user_id(),
                'eno_fecha_creacion' => date('Y-m-d H:i:s'),
                'eno_usu_modificacion' => $this->tank_auth->get_user_id(),
                'eno_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $eno_id = $this->gsatelite->ingresar('eno_envio_orden', $envio_array);
            if ($eno_id > 0) {

                $productos          = $post_array['productos'];
                $fechasEnvio        = $post_array['fechasEnvio'];
                $sucursalProducto   = $post_array['sucursalProducto'];
                $cantidades         = $post_array['cantidades'];
                $horasEnvio         = $post_array['horasEnvio'];
                $direccionEnvio     = $post_array['direccionEnvio'];
                $contactoEnvio      = $post_array['contactoEnvio'];

                if (count($productos) > 0) {
                    for ($i = 0; $i < count($productos); $i++) {
                        $fechaConvert   = new DateTime($fechasEnvio[$i]);
                        $horaConvert    = new DateTime($horasEnvio[$i]);
                        $detalle_array = array(
                            'deo_id_eno'            => $eno_id,
                            'deo_id_scl'            => $sucursalProducto[$i],
                            'deo_id_axo'            => $productos[$i],
                            'deo_cantidad'          => $cantidades[$i],
                            'deo_fecha'             => $fechaConvert->format('Y-m-d'),
                            'deo_hora'              => $horaConvert->format('H:i:s'),
                            'deo_direccion'         => $direccionEnvio[$i],
                            'deo_id_con'            => $contactoEnvio[$i],
                            'deo_estado'            => 1,
                            'deo_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'deo_fecha_creacion'    => date('Y-m-d H:i:s'),
                            'deo_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'deo_fecha_modificacion'=> date('Y-m-d H:i:s')
                        );
                        $den_id = $this->gsatelite->ingresar('deo_detalle_envio_orden', $detalle_array);
                    }
                }
                if ($den_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Envío Parcial", 'texto_alerta' => "El registro se guardó correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Envío Parcial", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Envío Parcial", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $this->session->set_flashdata($alerta);

            if ($tipo_btn == 1) {
                redirect('proyectos/procesos/agregar_envio_parcial/' . $ord_id);
            } else {
                redirect('proyectos/procesos/envios_parciales/' . $ord_id);
            }
        }
        $orden                  = $this->proyecto_model->get_ordenes(array('ord_id' => $ord_id));
        $data['orden']          = $orden[0];
        $data['sucursales']     = $this->gsatelite->get_dropdown('scl_sucursal_cliente', 'scl_nombre', 'surcursales', array('scl_id_cli' => $orden[0]['ord_id_cli']), null, null, null, true);
        $data['detalle_orden']  = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $ord_id));
        $data['contactos']     = $this->gsatelite->get_dropdown('con_contacto', '{con_nombre} {con_apellidos}', 'contactos', array('con_id_cli' => $orden[0]['ord_id_cli']), null, null, null, true);
        $data['titulo_personal']= "Agregar Envío Parcial";
        cargarvista($data);
    }

    function editar_envio_parcial($eno_id = null, $ver = null) {
        satelite_validar();
        if ($eno_id == null) {
            redirect('inicio');
        }
        if ($ver != null) {
            $eno_id = $ver;
            $ver = 1;
        }

        if ($this->input->post() && $ver == null) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            $tipo_btn = $post_array['btnCrear'];
            $envio_array = array(
                'eno_id_usu' => $this->tank_auth->get_user_id(),
                'eno_id_ord' => $ord_id,
                'eno_fecha_envio' => date('Y-m-d H:i:s'),
                'eno_estado' => 1,
                'eno_usu_creacion' => $this->tank_auth->get_user_id(),
                'eno_fecha_creacion' => date('Y-m-d H:i:s'),
                'eno_usu_modificacion' => $this->tank_auth->get_user_id(),
                'eno_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $eno_id = $this->gsatelite->ingresar('eno_envio_orden', $envio_array);
            if ($eno_id > 0) {

                $productos = $post_array['productos'];
                $fechasEnvio = $post_array['fechasEnvio'];
                $sucursalProducto = $post_array['sucursalProducto'];
                $cantidades = $post_array['cantidades'];

                if (count($productos) > 0) {
                    for ($i = 0; $i < count($productos); $i++) {
                        $fechaConvert = new DateTime($fechasEnvio[$i]);

                        $detalle_array = array(
                            'deo_id_eno' => $eno_id,
                            'deo_id_scl' => $sucursalProducto[$i],
                            'deo_id_axo' => $productos[$i],
                            'deo_cantidad' => $cantidades[$i],
                            'deo_fecha' => $fechaConvert->format('Y-m-d'),
                            'deo_estado' => 1,
                            'deo_usu_creacion' => $this->tank_auth->get_user_id(),
                            'deo_fecha_creacion' => date('Y-m-d H:i:s'),
                            'deo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'deo_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $den_id = $this->gsatelite->ingresar('deo_detalle_envio_orden', $detalle_array);
                    }
                }
                if ($den_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Envío Parcial", 'texto_alerta' => "El registro se guardó correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Envío Parcial", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Envío Parcial", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $this->session->set_flashdata($alerta);

            if ($tipo_btn == 1) {
                redirect('proyectos/procesos/editar_envio_parcial/' . $eno_id);
            } else {
                redirect('proyectos/procesos/envios_parciales/' . $ord_id);
            }
        }
        $envio = $this->gsatelite->get_tabla('eno_envio_orden', array('eno_id' => $eno_id));
        $ord_id = $envio[0]['eno_id_ord'];
        $orden = $this->proyecto_model->get_ordenes(array('ord_id' => $ord_id));
        $data['orden'] = $orden[0];

        $data['sucursales']    = $this->gsatelite->get_dropdown('scl_sucursal_cliente', 'scl_nombre', 'surcursales', array('scl_id_cli' => $orden[0]['ord_id_cli']), null, null, null, true);
        $data['contactos']     = $this->gsatelite->get_dropdown('con_contacto', '{con_nombre} {con_apellidos}', 'contactos', array('con_id_cli' => $orden[0]['ord_id_cli']), null, null, null, true);
        $data['detalle_orden'] = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $ord_id));
        $data['detalle_envio'] = $this->proyecto_model->get_detalle_envio(array('deo_id_eno' => $eno_id));
        $data['ver'] = $ver;
        if ($ver != null) {
            $data['titulo_personal'] = "Ver Envío Parcial";
        } else {
            $data['titulo_personal'] = "Editar Envío Parcial";
        }

        cargarvista($data);
    }

    function job_tracking_planeado($ord_id = null) {
        satelite_validar();
        if ($ord_id == null) {
            redirect('proyectos/procesos/orden_produccion');
        }

        $orden = $this->gsatelite->get_tabla('ord_orden', array('ord_id' => $ord_id));

        $this->db->group_by('lop_id');
        $this->db->join('exo_etapaxarticulo_orden', 'exo_id_lop = lop_id', 'inner');
        $detalle_orden = $this->proyecto_model->get_lotes(array('axo_id_ord' => $ord_id));
        $data['orden'] = $orden[0];

        $data['detalle_orden'] = $detalle_orden;
        $data['titulo_personal'] = "Job Tracking Planeado";
        cargarvista($data);
    }

    function agregar_job_tracking_pla($ord_id = null) {
        satelite_validar();
        if ($ord_id == null) {
            redirect('proyectos/procesos/orden_produccion');
        }

        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));

            $slcProducto = $post_array['slcProducto'];
            $slcLotes = $post_array['slcLotes'];
            $etapas = $post_array['etapas'];
            $duraciones = $post_array['duraciones'];
            $duracionesMod = $post_array['duracionesMod'];
            $hdnFinaliza = $post_array['hdnFinaliza'];
            $numOrden = $post_array['numOrden'];
            $comentarios = $post_array['comentarios'];

            if (count($etapas) > 0) {
                for ($i = 0; $i < count($etapas); $i ++) {
                    $etapas_array = array(
                        'exo_id_etp' => $etapas[$i],
                        'exo_id_lop' => $slcLotes,
                        'exo_duracion' => $duraciones[$i],
                        'exo_duracion_mano_obra' => $duracionesMod[$i],
                        'exo_comentario' => $comentarios[$i],
                        'exo_orden' => $numOrden[$i],
                        'exo_fin' => $hdnFinaliza[$i],
                        'exo_estado' => 1,
                        'exo_usu_creacion' => $this->tank_auth->get_user_id(),
                        'exo_fecha_creacion' => date('Y-m-d H:i:s'),
                        'exo_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'exo_fecha_modificacion' => date('Y-m-d H:i:s'),
                    );
                    $exo_id += $this->gsatelite->ingresar('exo_etapaxarticulo_orden', $etapas_array);
                }
            }

            if ($exo_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Job Tracking Planeado", 'texto_alerta' => "La información se proceso correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Orden no ingresada, favor verificar información");
            }

            $this->session->set_flashdata($alerta);

            $tipoBtn = $post_array['btnCrear'];

            if ($tipoBtn == 1) {
                redirect('proyectos/procesos/agregar_job_tracking_pla/' . $ord_id);
            } else {
                redirect('proyectos/procesos/job_tracking_planeado/' . $ord_id);
            }
        }

        $orden = $this->gsatelite->get_tabla('ord_orden ', array('ord_id' => $ord_id));
        $detalle_orden = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $ord_id));
        $data['orden'] = $orden[0];
        $data['detalle_orden'] = $detalle_orden;

        $data['etapas'] = $this->proyecto_model->get_etapas(array('etp_estado' => 1));
        $data['titulo_personal'] = "Agregar Job Tracking Planeado";
        cargarvista($data);
    }

    function editar_job_tracking_pla($lop_id = null) {
        satelite_validar();
        if ($lop_id == null) {
            redirect('proyectos/procesos/orden_produccion');
        }

        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));

            $ord_id = $post_array['hdnOrden'];
            $hdnDetalle = $post_array['hdnDetalle'];
            $slcLotes = $post_array['slcLotes'];
            $etapas = $post_array['etapas'];
            $duraciones = $post_array['duraciones'];
            $duracionesMod = $post_array['duracionesMod'];
            $hdnFinaliza = $post_array['hdnFinaliza'];
            $numOrden = $post_array['numOrden'];
            $comentarios = $post_array['comentarios'];

            $idsEtapas = array();
            if (count($etapas) > 0) {

                $error_moe = 0;
                for ($i = 0; $i < count($etapas); $i ++) {
                    if ($hdnDetalle[$i] > 0) {
                        $idsEtapas[] = $hdnDetalle[$i];
                    }
                }
                //Se eliminan los que no existan
                $dataEtapas = $this->proyecto_model->get_etapas_lotes(array('exo_id_lop' => $lop_id));
                //die(var_dump($dataEtapas));

                foreach ($dataEtapas as $row) {
                    $moe_data_exist = $this->gsatelite->get_tabla('moe_movimiento_etapa', array('moe_id_exo'=>$row['exo_id']));
                    if(!(count($moe_data_exist) > 0)){
                        if (!in_array($row['exo_id'], $idsEtapas)) {
                            $this->gsatelite->borrado_general('exo_etapaxarticulo_orden', array('exo_id' => $row['exo_id']));
                        }
                    } else{
                        $error_moe = 1;
                    }
                }

                if($error_moe == 0){
                    for ($i = 0; $i < count($etapas); $i ++) {
                        $etapas_array = array(
                            'exo_id_etp' => $etapas[$i],
                            'exo_id_lop' => $slcLotes,
                            'exo_duracion' => $duraciones[$i],
                            'exo_duracion_mano_obra' => $duracionesMod[$i],
                            'exo_comentario' => $comentarios[$i],
                            'exo_orden' => $numOrden[$i],
                            'exo_fin' => $hdnFinaliza[$i],
                            'exo_estado' => 1,
                            'exo_usu_creacion' => $this->tank_auth->get_user_id(),
                            'exo_fecha_creacion' => date('Y-m-d H:i:s'),
                            'exo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'exo_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );
                        //Si el detalle existe se actualiza sino se ingresa
                        if ($hdnDetalle[$i] != '0') {
                            unset($etapas_array['exo_id_lop']);
                            unset($etapas_array['exo_usu_creacion']);
                            unset($etapas_array['exo_fecha_creacion']);

                            $exo_id += $this->gsatelite->actualizar_array('exo_etapaxarticulo_orden', $etapas_array, array('exo_id' => $hdnDetalle[$i]));
                        } else {
                            $exo_id += $this->gsatelite->ingresar('exo_etapaxarticulo_orden', $etapas_array);
                        }
                    }
                }

            }

            if ($exo_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Job Tracking Planeado", 'texto_alerta' => "La información se proceso correctamente.");
            } else if($error_moe == 1){
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Orden no ingresada, no se puede editar, otros registros dependen de ellos.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Orden no ingresada, favor verificar información");
            }

            $this->session->set_flashdata($alerta);

            $tipoBtn = $post_array['btnCrear'];

            if ($tipoBtn == 1) {
                redirect('proyectos/procesos/editar_job_tracking_pla/' . $lop_id);
            } else {
                redirect('proyectos/procesos/job_tracking_planeado/' . $ord_id);
            }
        }

        $data['detalle_etapas'] = $this->proyecto_model->get_etapas_lotes(array('exo_id_lop' => $lop_id));
        //print_r($data['detalle_etapas']);exit();die();
        $ord_id = $data['detalle_etapas'][0]['axo_id_ord'];
        $producto = $data['detalle_etapas'][0]['axo_id'];

        $data['lotes'] = $this->proyecto_model->get_lotes(array('axo_id' => $producto));
        $lote = $this->gsatelite->get_tabla('lop_lote_produccion ', array('lop_id' => $lop_id));
        $orden = $this->gsatelite->get_tabla('ord_orden ', array('ord_id' => $ord_id));
        $detalle_orden = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $ord_id));

        $data['orden'] = $orden[0];
        $data['lote'] = $lote[0];
        $data['detalle_orden'] = $detalle_orden;
        $data['etapas'] = $this->proyecto_model->get_etapas(array('etp_estado' => 1));
        $data['titulo_personal'] = "Editar Job Tracking Planeado";
        cargarvista($data);
    }

    function eliminar_job_tracking_planeado($lop_id, $ord_id) {
        if ($lop_id != null) {

            $detalle_etapas = $this->proyecto_model->get_etapas_lotes(array('exo_id_lop' => $lop_id));

            $movimientos = 0;

            if (count($detalle_etapas) > 0) {
                $movimientos = array_sum(array_column($detalle_etapas, 'movimientos'));
            }
            //var_dump($detalle_etapas);die();
            if ($movimientos == 0) {
                $this->gsatelite->borrado_general('exo_etapaxarticulo_orden', array('exo_id_lop' => $lop_id));

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Job Tracking Planeado", 'texto_alerta' => "La información se proceso correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Job tracking planeado", 'texto_alerta' => "No puede eliminar el registro, ya que otros dependen de este.");
            }

            $this->session->set_flashdata($alerta);

            redirect('proyectos/procesos/job_tracking_planeado/' . $ord_id);
        }
    }

    /*
     * @author: Mario Marquez
     * Funcion que devuelve el listado de lotes asociado a un producto de orden de producción
     */

    public function get_info_producto_orden($pro_id = null, $lotes = null) {
        $producto = ($pro_id != null) ? $pro_id : $this->input->post('producto');
        $lotes_etapa = ($lotes != null) ? $lotes : $this->input->post('lotes_etapa');
        if ($producto > 0) {
            $arreglo = array(
                'lotes',
            );

            //Se obtienen las ordenes de producción
            $opciones = "<option></option>";
            $lotes = $this->proyecto_model->get_lotes(array('axo_id' => $producto));
            if (count($lotes) > 0) {
                foreach ($lotes as $lop) {
                    if ($lotes_etapa == 1) {
                        if ($lop['num_etapas'] == 0) {
                            $opciones .= "<option value='" . $lop['lop_id'] . "'>" . $lop['lop_nombre'] . "</option>";
                        }
                    } else {
                        $opciones .= "<option value='" . $lop['lop_id'] . "'>" . $lop['lop_nombre'] . "</option>";
                    }
                }
            }

            $arreglo['lotes'] = $opciones;

            //Se verifica si el producto ya contiene etapas generadas
            $art_id = $this->gsatelite->get_campo('axo_articuloxorden', 'axo_id_art', array('axo_id' => $producto));
            $etapas = $this->proyecto_model->get_etapas_articulo(array('eta_id_art' => $art_id));
            //print_r($this->db->last_query());
            //die();
            $html = '';

            if (count($etapas) > 0) {
                $data['detalle_etapas'] = $etapas;
                $html = $this->load->view('proyectos/procesos/etapas_producto', $data, true);
            }

            $arreglo['etapas'] = $html;

            if ($pro_id != null) {
                return $arreglo['lotes'];
            }
            echo json_encode($arreglo);
        }
    }

    function job_tracking_movimiento($ord_id = null) {
        satelite_validar();
        if ($ord_id == null) {
            redirect('proyectos/procesos/orden_produccion');
        }

        $orden = $this->gsatelite->get_tabla('ord_orden', array('ord_id' => $ord_id));

        $this->db->group_by('lop_id');
        $this->db->join('exo_etapaxarticulo_orden', 'exo_id_lop = lop_id', 'inner');
        $detalle_orden = $this->proyecto_model->get_lotes(array('axo_id_ord' => $ord_id));
        $data['orden'] = $orden[0];
        //print_r($detalle_orden); die();

        $data['detalle_orden'] = $detalle_orden;
        $data['titulo_personal'] = "Gestión de Job Tracking Movimiento";
        cargarvista($data);
    }

    function gestionar_job_tracking_mov($lop_id = null) {
        satelite_validar();
        if ($lop_id == null) {
            redirect('proyectos/procesos/orden_produccion');
        }
        if ($this->input->post()) {
            $post_array = $this->input->post();
            // die(var_dump($post_array));

            $ingreso_inv = $post_array['ingresoInv'];
            $hdnDetalle = $post_array['hdnDetalle'];
            $cantidadEtapa = $post_array['cantidadEtapa'];
            $duraciones = $post_array['duraciones'];
            $duracionesMod = $post_array['duracionesMod'];
            $ord_id = $post_array['hdnOrden'];
            $bod_id = $post_array['hdnbodega'];
            $secxbod_id = (trim($post_array['secbodega']) != '')?$post_array['secbodega']:null;
            $ord_numero = $post_array['ordNumero'];
            $axo_id = $post_array['slcProducto'];
            $art_id = $post_array['producto_id_slc'];
            $ingresoInv = $post_array['ingresoInv'];
            $cantidad_intocable = $post_array['cantidad_intocable'];
            $tip_entrada_par = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS');
            $tipos_array = json_decode($tip_entrada_par, true);
            $cantidad_nueva = $post_array['cant_real'];
            $precio_unitario = $post_array['cant_unitaria'];
            //print_r($this->input->post());die();

            $resultado = 0;
            if (count($hdnDetalle) > 0) {
                if($ingresoInv == 1){
                    $tip_entrada = $tipos_array['TRACKING'];
                    if (trim($bod_id) != "" && trim($tip_entrada) != "") {
                        //aca
                        $detalle_moi_array = array(
                            'moi_id_tip' => $tip_entrada,
                            'moi_id_bod' => $bod_id,
                            //'moi_id_fac'=> $doc_cliente_dcc,
                            'moi_documento'=> $ord_numero,
                            'moi_descripcion' => "Entrada desde produccion",
                            'moi_fecha_mov' => date('Y-m-d H:i:s'),
                            'moi_estado' => 1,
                            'moi_usu_creacion' => $this->tank_auth->get_user_id(),
                            'moi_fecha_creacion' => date('Y-m-d H:i:s'),
                            'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $cantidad = $cantidad_intocable - $cantidadEtapa[(count($cantidadEtapa)-1)];
                        $moi_id = $this->gsatelite->ingresar('moi_movimiento_inv', $detalle_moi_array);
                    }

                    for ($i = 0; $i < count($hdnDetalle); $i++) {
                        $cantidad_prod = str_replace(',', '', $cantidadEtapa[$i]);

                        $etapas_array = array(
                            'exo_cantidad' => ($cantidad_prod != '') ? $cantidad_prod : 0,
                            'exo_duracion' => $duraciones[$i],
                            'exo_duracion_mano_obra' => $duracionesMod[$i],
                            'exo_estado' => 1,
                            'exo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'exo_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $resultado += $this->gsatelite->actualizar_array('exo_etapaxarticulo_orden', $etapas_array, array('exo_id' => $hdnDetalle[$i]));

                        if ($resultado > 0) {
                            if (count($post_array['cantidadesDetalle_' . $hdnDetalle[$i]]) > 0) {
                                $cantidadDetalle = $post_array['cantidadesDetalle_' . $hdnDetalle[$i]];
                                $hdnEtapaDestino = $post_array['hdnEtapaDestino_' . $hdnDetalle[$i]];
                                $hdnEtapaOrigen = $post_array['hdnEtapaOrigen_' . $hdnDetalle[$i]];
                                $hdnfechaEntrada = $post_array['hdnfechaEntrada_' . $hdnDetalle[$i]];
                                $hdnfechaSalida = $post_array['hdnfechaSalida_' . $hdnDetalle[$i]];

                                for ($j = 0; $j < count($post_array['cantidadesDetalle_' . $hdnDetalle[$i]]); $j++) {
                                    if ($cantidadDetalle[$j] != '') {

                                        $fechaEntrada = ($hdnfechaEntrada[$j] != '') ? formatear_fecha('Y-m-d H:i:s', $hdnfechaEntrada[$j]) : null;
                                        $horaEntrada = ($hdnfechaEntrada[$j] != '') ? formatear_fecha('H:i:s', $hdnfechaEntrada[$j]) : null;
                                        $fechaSalida = ($hdnfechaSalida[$j] != '') ? formatear_fecha('Y-m-d H:i:s', $hdnfechaSalida[$j]) : null;
                                        $horaSalida = ($hdnfechaSalida[$j] != '') ? formatear_fecha('H:i:s', $hdnfechaSalida[$j]) : null;

                                        $cantidad = str_replace(',', '', $cantidadDetalle[$j]);

                                        $detalle_moe_array = array(
                                            'moe_id_exo' => $hdnDetalle[$i],
                                            'moe_id_exo_origen' => ($hdnEtapaOrigen[$j] != '') ? $hdnEtapaOrigen[$j] : null,
                                            'moe_id_exo_destino' => ($hdnEtapaDestino[$j] != '') ? $hdnEtapaDestino[$j] : null,
                                            'moe_id_usu_entrada' => $this->tank_auth->get_user_id(),
                                            'moe_id_usu_salida' => ($fechaSalida != null) ? $this->tank_auth->get_user_id() : null,
                                            'moe_cantidad' => $cantidad,
                                            'moe_fecha_entrada' => $fechaEntrada,
                                            'moe_hora_entrada' => $horaEntrada,
                                            'moe_fecha_salida' => $fechaSalida,
                                            'moe_hora_salida' => $horaSalida,
                                            'moe_estado' => 1,
                                            'moe_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'moe_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'moe_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'moe_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );

                                        $moe_id = $this->gsatelite->ingresar('moe_movimiento_etapa', $detalle_moe_array);
                                    }
                                }
                            }
                            /*print_r(count($moe_id));
                            exit();die();*/
                        }
                    }

                    //Se cierran las fechas que estaban pendientes.
                    $hdnMoe = $post_array['hdnMoe'];
                    $fechasSalidasAct = $post_array['fechasSalidasAct'];
                    $hdnEtapaDestinoAct = $post_array['hdnEtapaDestinoAct'];
                    if (count($hdnMoe) > 0) {
                        for ($i = 0; $i < count($hdnMoe); $i++) {
                            if ($hdnMoe[$i] != '') {
                                $fechaSalida = ($fechasSalidasAct[$i] != '') ? formatear_fecha('Y-m-d H:i:s', $fechasSalidasAct[$i]) : null;
                                $horaSalida = ($fechasSalidasAct[$i] != '') ? formatear_fecha('H:i:s', $fechasSalidasAct[$i]) : null;


                                $detalle_moe_array = array(
                                    'moe_id_exo_destino' => ($hdnEtapaDestinoAct[$i] != '') ? $hdnEtapaDestinoAct[$i] : null,
                                    'moe_id_usu_salida' => ($fechaSalida != null) ? $this->tank_auth->get_user_id() : null,
                                    'moe_fecha_salida' => $fechaSalida,
                                    'moe_hora_salida' => $horaSalida,
                                    'moe_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'moe_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                                $this->gsatelite->actualizar_array('moe_movimiento_etapa', $detalle_moe_array, array('moe_id' => $hdnMoe[$i]));
                            }
                        }
                    }

                    if ($moe_id > 0) {
                        $detalle_moe_array2 = array(
                            'moe_id_moi' => $moi_id,
                            'moe_ingreso_inventario' => 1
                        );
                        $this->gsatelite->actualizar_array('moe_movimiento_etapa', $detalle_moe_array2, array('moe_id' => $moe_id));
                    }

                    if($moi_id > 0){
                                         $this->db->join('cva_conversion_articulo','cva_id=axo_id_cva', 'left');
                        $articulos_reg = $this->gsatelite->get_tabla('axo_articuloxorden', array('axo_id' =>$axo_id));

                        foreach ($articulos_reg as $key) {
                            
                            $multiplicar_conversion = ($key['cva_conversion'])? $key['cva_conversion']:1;
                            
                            $cantidad_axo = (double)$cantidad_nueva;
                            //cambie esto----------------------------------------------------
                            $cantidad_axo = str_replace(',', '', $cantidad_axo);
                            //---------------------------------------------------------------
                            //$precio_total_axo = (double)$key['axo_total'];
                            $precio_unitario = (double)$precio_unitario;
                            //$precio_unitario = $precio_total_axo/($cantidad_axo * $multiplicar_conversion);

                            $precio_subtotal = $precio_unitario*($cantidad * $multiplicar_conversion);
                            $sar_detalle_array = array(
                                'sar_id_art' => $key['axo_id_art'],
                                'sar_id_bod' => $bod_id,
                                'sar_cant_actual' => ($cantidad_axo * $multiplicar_conversion),
                                'sar_precio' => $precio_unitario,//PREGUNTAR
                                'sar_fecha_caducidad' => null,
                                'sar_id_sxb' => $secxbod_id,
                                'sar_estado' => 1,
                                'sar_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sar_fecha_creacion' => date('Y-m-d H:i:s'),
                                'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sar_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $sar_id = $this->gsatelite->ingresar('sar_saldo_articulo', $sar_detalle_array);
                            $dee_detalle_array = array(
                                'dee_id_moi' => $moi_id,
                                'dee_id_art' => $key['axo_id_art'],
                                'dee_id_sar' => $sar_id,
                                'dee_id_cva' => $key['axo_id_cva'],
                                'dee_id_sxb' => $secxbod_id,
                                'dee_cantidad' => ($cantidad_axo * $multiplicar_conversion),
                                'dee_fecha_caducidad' => null,
                                'dee_precio' => $precio_unitario,//PREGUNTAR
                                'dee_subtotal' => $precio_subtotal,//PREGUNTAR
                                'dee_estado' => 1,
                                'dee_usu_creacion' => $this->tank_auth->get_user_id(),
                                'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                                'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dee_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('dee_detalle_mov', $dee_detalle_array);
                        }
                    }
                } else{
                    for ($i = 0; $i < count($hdnDetalle); $i++) {
                        $cantidad_prod = str_replace(',', '', $cantidadEtapa[$i]);

                        $etapas_array = array(
                            'exo_cantidad' => ($cantidad_prod != '') ? $cantidad_prod : 0,
                            'exo_duracion' => $duraciones[$i],
                            'exo_duracion_mano_obra' => $duracionesMod[$i],
                            'exo_estado' => 1,
                            'exo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'exo_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $resultado += $this->gsatelite->actualizar_array('exo_etapaxarticulo_orden', $etapas_array, array('exo_id' => $hdnDetalle[$i]));
                        if ($resultado > 0) {
                            if (count($post_array['cantidadesDetalle_' . $hdnDetalle[$i]]) > 0) {
                                $cantidadDetalle = $post_array['cantidadesDetalle_' . $hdnDetalle[$i]];
                                $hdnEtapaDestino = $post_array['hdnEtapaDestino_' . $hdnDetalle[$i]];
                                $hdnEtapaOrigen = $post_array['hdnEtapaOrigen_' . $hdnDetalle[$i]];
                                $hdnfechaEntrada = $post_array['hdnfechaEntrada_' . $hdnDetalle[$i]];
                                $hdnfechaSalida = $post_array['hdnfechaSalida_' . $hdnDetalle[$i]];

                                for ($j = 0; $j < count($post_array['cantidadesDetalle_' . $hdnDetalle[$i]]); $j++) {
                                    if ($cantidadDetalle[$j] != '') {

                                        $fechaEntrada = ($hdnfechaEntrada[$j] != '') ? formatear_fecha('Y-m-d H:i:s', $hdnfechaEntrada[$j]) : null;
                                        $horaEntrada = ($hdnfechaEntrada[$j] != '') ? formatear_fecha('H:i:s', $hdnfechaEntrada[$j]) : null;
                                        $fechaSalida = ($hdnfechaSalida[$j] != '') ? formatear_fecha('Y-m-d H:i:s', $hdnfechaSalida[$j]) : null;
                                        $horaSalida = ($hdnfechaSalida[$j] != '') ? formatear_fecha('H:i:s', $hdnfechaSalida[$j]) : null;

                                        $cantidad = str_replace(',', '', $cantidadDetalle[$j]);
                                        $detalle_moe_array = array(
                                            'moe_id_exo' => $hdnDetalle[$i],
                                            'moe_id_exo_origen' => ($hdnEtapaOrigen[$j] != '') ? $hdnEtapaOrigen[$j] : null,
                                            'moe_id_exo_destino' => ($hdnEtapaDestino[$j] != '') ? $hdnEtapaDestino[$j] : null,
                                            'moe_id_usu_entrada' => $this->tank_auth->get_user_id(),
                                            'moe_id_usu_salida' => ($fechaSalida != null) ? $this->tank_auth->get_user_id() : null,
                                            'moe_cantidad' => $cantidad,
                                            'moe_fecha_entrada' => $fechaEntrada,
                                            'moe_hora_entrada' => $horaEntrada,
                                            'moe_fecha_salida' => $fechaSalida,
                                            'moe_hora_salida' => $horaSalida,
                                            'moe_estado' => 1,
                                            'moe_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'moe_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'moe_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'moe_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );
                                        $moe_id = $this->gsatelite->ingresar('moe_movimiento_etapa', $detalle_moe_array);
                                    }
                                }
                            }
                        }
                    }
                    //Se cierran las fechas que estaban pendientes.
                    $hdnMoe = $post_array['hdnMoe'];
                    $fechasSalidasAct = $post_array['fechasSalidasAct'];
                    $hdnEtapaDestinoAct = $post_array['hdnEtapaDestinoAct'];
                    if (count($hdnMoe) > 0) {
                        for ($i = 0; $i < count($hdnMoe); $i++) {
                            if ($hdnMoe[$i] != '') {
                                $fechaSalida = ($fechasSalidasAct[$i] != '') ? formatear_fecha('Y-m-d H:i:s', $fechasSalidasAct[$i]) : null;
                                $horaSalida = ($fechasSalidasAct[$i] != '') ? formatear_fecha('H:i:s', $fechasSalidasAct[$i]) : null;


                                $detalle_moe_array = array(
                                    'moe_id_exo_destino' => ($hdnEtapaDestinoAct[$i] != '') ? $hdnEtapaDestinoAct[$i] : null,
                                    'moe_id_usu_salida' => ($fechaSalida != null) ? $this->tank_auth->get_user_id() : null,
                                    'moe_fecha_salida' => $fechaSalida,
                                    'moe_hora_salida' => $horaSalida,
                                    'moe_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'moe_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                                $this->gsatelite->actualizar_array('moe_movimiento_etapa', $detalle_moe_array, array('moe_id' => $hdnMoe[$i]));
                            }
                        }
                    }

                    $cantidad_ultima_etapa = $cantidadEtapa[(count($cantidadEtapa)-1)];
                    if ($moe_id > 0 && $cantidad_ultima_etapa > $cantidad_intocable ) {
                        $detalle_moe_array2 = array(
                            'moe_ingreso_inventario' => 1
                        );
                        $this->gsatelite->actualizar_array('moe_movimiento_etapa', $detalle_moe_array2, array('moe_id' => $moe_id));
                    }

                }

            }

            if ($resultado > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Job Tracking Movimiento", 'texto_alerta' => "La información se proceso correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Orden no ingresada, favor verificar información");
            }

            $this->session->set_flashdata($alerta);

            $tipoBtn = $post_array['btnCrear'];

            if ($tipoBtn == 1) {
                redirect('proyectos/procesos/gestionar_job_tracking_mov/' . $lop_id);
            } else {
                redirect('proyectos/procesos/job_tracking_movimiento/' . $ord_id);
            }
        }
        $data['cantidad_intocable'] = $this->proyecto_model->get_cantidad_tracking(array('moe_ingreso_inventario' => 1, 'lop_id' => $lop_id)); 
        $data['detalle_etapas'] = $this->proyecto_model->get_etapas_lotes(array('exo_id_lop' => $lop_id));
        // print_r($this->db->last_query()); die();
        $ord_id = $data['detalle_etapas'][0]['axo_id_ord'];
        $producto = $data['detalle_etapas'][0]['axo_id'];
        $data['cantidad_total_ord'] = number_format($data['detalle_etapas'][0]['axo_cantidad'], 2);
        $data['bodega_inventario'] = 0;
        foreach ($data['detalle_etapas'] as $key => $value) {
            if ($value['etp_id_bod'] != "" && $value['exo_fin'] > 0) {
                $data['bodega_inventario']++;
            }
        }
        $data['lotes'] = $this->proyecto_model->get_lotes(array('axo_id' => $producto));
        $lote = $this->gsatelite->get_tabla('lop_lote_produccion ', array('lop_id' => $lop_id));
        $orden = $this->gsatelite->get_tabla('ord_orden ', array('ord_id' => $ord_id));
        $detalle_orden = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $ord_id));

        $data['orden'] = $orden[0];
        $data['lote'] = $lote[0];
        $decimles = json_decode($this->gsatelite->get_parametro('SYS_NUMERO_DECIMALES_PRODUCCION'),true);
        $data['decimales'] = $decimles['orden_producion'];

        $data['detalle_orden'] = $detalle_orden;
        $data['etapas'] = $this->proyecto_model->get_etapas(array('etp_estado' => 1));
        $data['titulo_personal'] = "Job Tracking Movimiento";
        cargarvista($data);
    }

    function presupuestos_orden($ord_id = null) {
        satelite_validar();
        if ($ord_id == null) {
            redirect('proyectos/procesos/orden_produccion');
        }
        $orden = $this->gsatelite->get_tabla('ord_orden', array('ord_id' => $ord_id));
        $detalle_orden = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $ord_id));
        $data['orden'] = $orden[0];
        $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='') ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
        $data['detalle_orden'] = $detalle_orden;
        $data['titulo_personal'] = "Listado de Costeos";
        cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * Funcion devuelve el precio utilizado en los presupuestos de Detalles de Materiales
     */

    public function get_calculo_precio() {
        $post_array = $this->input->post();

        //Se filtran los precios en base al campo enviado.
        $producto = ($post_array['producto'] != null) ? $post_array['producto'] : null;
        $tipo_precio = ($post_array['tipo_precio'] != null) ? $post_array['tipo_precio'] : null;
        $proveedor = ($post_array['proveedor'] != null) ? $post_array['proveedor'] : null;
        $bodega = (isset($post_array['bodega']) && $post_array['bodega'] != null) ? $post_array['bodega'] : null;
        $precio_sugerido = 0;
        if ($producto > 0) {
            $where = array(
                'sar_id_art' => $producto,
            );
            //Tipo dos se obtiene el ultimo precio ingresado
            if ($tipo_precio == 2) {
                $this->db->limit(1);
                $this->db->order_by('moi_id desc');
                $where['tip_entrada'] = 1;
            }
            if ($proveedor != null) {
                $where['moi_id_prv'] = $proveedor;
            }
            if ($bodega != null) {
                $where['sar_id_bod'] = $bodega;
            }
            $movimientos = $this->proyecto_model->get_movimientos_producto($where);
            if (count($movimientos) > 0) {
                if($tipo_precio == 2){
                    $precios_producto = array_sum(array_column($movimientos, 'dxd_precio_unitario'));
                    $cantidad_entradas = count(array_column($movimientos, 'dxd_precio_unitario'));
                } else{
                    $precios_producto = 0;
                    foreach ($movimientos as $key) {
                        $precios_producto += $key['sar_precio'] * $key['sar_cant_actual'];
                    }
                    $cantidad_entradas = array_sum(array_column($movimientos, 'sar_cant_actual'));
                }
                $precio_sugerido = $precios_producto / $cantidad_entradas;
            }
        }
        $precio_sugerido = number_format($precio_sugerido, 2);
        echo json_encode(array('precio' => $precio_sugerido));
    }

    /*
     * @author: Mario Marquez
     * Función que busca los productos por nombre asignados a una categoria y bodega (saldos)
     * Si se les proporciona.
     * @return: Objeto json de la informacion resultante
     */

    public function get_empleados_like() {
        satelite_validar(true);
        $empleado = $this->input->post('empleado');

        $where = null;
        $like = null;

        $like = array(
            "CONCAT_WS(' ',emp_codigo,' - ',emp_nombre, emp_apellido)" => $empleado,
        );
        $where['emp_estado'] = 1;

        $arreglo = array();
        $empleados = $this->proyecto_model->get_empleados_like($where, $like);
        //print_r($this->db->last_query());die();
        if (count($empleados) > 0) {
            foreach ($empleados as $key => $value) {
                $arreglo[$key]['empleado'] = $value['emp_id'];
                $arreglo[$key]['emp_nombre'] = $value['empleado'];
            }
        }
        echo json_encode($arreglo);
    }

    function solicitud_materiales($ord_id = null) {
        satelite_validar();
        if ($this->input->post()) { 
            $post_array     = $this->input->post();
            $orden          = $this->proyecto_model->get_ordenes(array('ord_id' => $ord_id));
            $clienteOrden   = $orden[0]['cli_nombre'];
            if ($orden[0]['cli_personeria'] == 1) {
                $clienteOrden .= ' ' . $orden[0]['cli_apellido'];
            }
            $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
            $flujos_array = json_decode($flujos, true);
            $flujo_id = ($post_array['slcTipo'] == 1) ? $flujos_array['REQ_INV'] : $flujos_array['REQ_COMP'];
            $num_actual = $this->gsatelite->count('rxi_requisicion_inventario', array('rxi_id_flu' => $flujo_id));
            $id_usuario = $this->tank_auth->get_user_id();
            $empleado = $this->inventario_model->listado_empleados(array('id' => $id_usuario));
            $codigo = $num_actual + 1;
            $num_requisicion = generar_codigo_cor($codigo, 5);
            $requisicion_array = array(
                'rxi_id_usu_solicita' => $this->tank_auth->get_user_id(),
                'rxi_id_emp' => ($empleado[0]['emp_id'] != null) ? $empleado[0]['emp_id'] : null,
                'rxi_id_flu' => $flujo_id,
                'rxi_id_ord' => $ord_id,
                'rxi_id_pcl' => $orden[0]['ord_id_pcl'],
                'rxi_id_bod' => ($post_array['slcBodega'] != '') ? $post_array['slcBodega'] : null,
                'rxi_numero' => $num_requisicion,
                'rxi_cliente' => $clienteOrden,
                'rxi_descripcion' => $orden[0]['ord_comentario'],
                'rxi_tipo' => 1,
                'rxi_proceso_requisicion' => $post_array['slcTipo'],
                'rxi_fecha' => date('Y-m-d H:i:s'),
                'rxi_estado' => 1,
                'rxi_usu_modificacion' => $this->tank_auth->get_user_id(),
                'rxi_fecha_modificacion' => date('Y-m-d H:i:s'),
                'rxi_fecha_creacion' => date('Y-m-d H:i:s'),
                'rxi_usu_creacion' => $this->tank_auth->get_user_id()
            );
            $req_id = $this->gsatelite->ingresar('rxi_requisicion_inventario', $requisicion_array);
            $resultados = 0;
            if ($req_id > 0) {
                $primer_paso = $this->inventario_model->get_primer_paso_flujo($flujo_id);
                if (count($primer_paso) > 0) {
                    $seguimiento_requisicion = array(
                        'sgr_id_rxi'            => $req_id,
                        'sgr_id_psf'            => $primer_paso[0]['psf_id'],
                        'sgr_id_usu'            => $this->tank_auth->get_user_id(),
                        'sgr_fecha_entrada'     => date('Y-m-d H:i:s'),
                        'sgr_estado'            => 1,
                        'sgr_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'sgr_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'sgr_fecha_creacion'    => date('Y-m-d h:i:s'),
                        'sgr_fecha_modificacion'=> date('Y-m-d h:i:s')
                    );
                    $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);
                }
                $materiaPrima       = $post_array['materiaPrima'];
                $articuloMateria    = $post_array['articuloMateria'];
                $conversionMateria  = $post_array['conversionMateria'];
                $cantidadSolicitada = $post_array['cantidadSolicitada'];
                $cantidadPendiente  = $post_array['cantidadPendiente'];
                $cantidadDespachada = $post_array['cantidadDespachada'];
                $solicitadoActual   = $post_array['totalSolicitado'];
                $modifica_costeo    = $post_array['modifica_costeo'];
                $modifica_cantidad  = $post_array['modifica_ctdad'];
                if (count($materiaPrima) > 0) {
                    for ($i = 0; $i < count($materiaPrima); $i++) {
                        $detalle_req = array(
                            'dri_id_rxi'            => $req_id,
                            'dri_id_axm'            => $materiaPrima[$i],
                            'dri_id_art'            => $articuloMateria[$i],
                            'dri_id_cva'            => ($conversionMateria[$i] != '') ? $conversionMateria[$i] : null,
                            'dri_cantidad'          => convertirFloat($cantidadSolicitada[$i]),
                            'dri_estado'            => 1,
                            'dri_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'dri_fecha_modificacion'=> date('Y-m-d H:i:s'),
                            'dri_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'dri_fecha_creacion' => date('Y-m-d H:i:s')
                        );
                        $dri_id += $this->gsatelite->ingresar('dri_detalle_requisicion_inventario', $detalle_req);
                        if ($dri_id > 0) {

                            $pendiente = convertirFloat($cantidadSolicitada[$i]) + convertirFloat($solicitadoActual[$i])  - convertirFloat($cantidadDespachada[$i]);
                            $despachada = convertirFloat($cantidadDespachada[$i]);
                            // $pendiente = ($cantidadPendiente[$i] > 0) ? convertirFloat(($cantidadPendiente[$i] + $pendiente)) : $pendiente;
                            //Se actualiza el detalle de la materia prima.
                            $axm_array = array(
                                'axm_pendiente'         => $pendiente,
                                'axm_despachada'        => $despachada,
                                'axm_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'axm_fecha_modificacion'=> date('Y-m-d H:i:s')
                            );
                            if ($modifica_costeo[$i] > 0) {
                                // $axm_array['axm_cantidad'] = $modifica_cantidad[$i];
                            }
                            $this->gsatelite->actualizar_array('axm_articulo_matxarticulo_ord', $axm_array, array('axm_id' => $materiaPrima[$i]));
                            $resultados ++;
                        }
                    }
                }

                // Variables a utilizar
                $tipo_btn   = $post_array['btnCrear'];
                $tipo_flujo = 1; // tipo flujo: 1- Requisiciones
                $flujo      = 1; // Flujo: 3 - Requisicion de Inventario
                // Parametro para determinar la autorizacion de la requisicion
                $autorizar = $this->gsatelite->get_parametro('SYS_AUTORIZAR_REQUISICION', null, null, array('SOLICITUD_MAT'));
                if ($tipo_btn === '3' && $req_id > 0) {
                    $this->load->library('../controllers/inventario/gestion_productos');
                    $this->gestion_productos->autorizar_requisicion_automatica($req_id, $tipo_flujo, $flujo);
                    if (isset($autorizar) && $autorizar > 0) {
                        if ($this->input->post('txt_afecta_inventario') !== false) {
                            $afecta_inventario = $this->input->post('txt_afecta_inventario');
                            if ( $afecta_inventario == 1 ) {
                                $this->gestion_productos->salida_inventario_automatica_x_orden($req_id);
                            }
                        }
                    }                    
                }
            }

            if ($resultados > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Solicitud de Materiales", 'texto_alerta' => "La solicitud #" . $num_requisicion . " se proceso correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Orden no ingresada, favor verificar información.");
            }
            $this->session->set_flashdata($alerta);

            //$tipoBtn = $post_array['btnCrear'];
            redirect('proyectos/procesos/orden_produccion');
        }
        $data['titulo_personal']    = "Solicitud de Materiales";
        $orden = $this->proyecto_model->get_ordenes(array('ord_id' => $ord_id));
        $data['orden'] = $orden[0];
        $data['sucursales'] = $this->gsatelite->get_dropdown('scl_sucursal_cliente', 'scl_nombre', 'surcursales', array('scl_id_cli' => $orden[0]['ord_id_cli']), null, null, null, true);
        $data['detalle_orden'] = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $ord_id));
        $data['bodegas'] = $this->inventario_model->get_bodegas_usuario();
        /* ************************************************** */
        /* Obtener los permisos para autorizar la requisicion */
        /* ************************************************** */
        $groupby = null;
        $orderby = null;
        $where   = null;
        // agrupador
        $groupby = 'rol_id';
        $where   = array('psf_orden'=>2, 'psf_id_flu'=>1, 'axr_id_acc'=>2, 'id'=>$this->tank_auth->get_user_id());
        $data['autorizar'] = $this->inventario_model->get_permisos_autorizar_requisicion($where, $groupby, $orderby);
        $data['parametro'] = $this->gsatelite->get_parametro('SYS_AUTORIZAR_REQUISICION', 0, null, array('SOLICITUD_MAT') );         
        cargarvista($data);
    }

    public function get_detalles_materia_prima() {
        $post_array     = $this->input->post();
        $orden          = ($post_array['orden'] != '') ? $post_array['orden'] : null;
        $producto       = ($post_array['producto'] != '') ? $post_array['producto'] : null;
        $precargados    = ($post_array['existentes'] != '') ? $post_array['existentes'] : null;
        $bodega         = ($post_array['bodega'] != '') ? $post_array['bodega'] : null;
        $tipo        = ($post_array['tipo'] != '') ? $post_array['tipo'] : null;
        //Se valida los que ya fueron ingresados
        $where = null;
        $idsAgregados = array();
        if ($precargados != null) {
            $idsAgregados = explode(',', $precargados);
            $this->db->where_not_in('axo_id', $idsAgregados);
        }
        //Se obtiene el detalle seleccionado
        if ($producto != null) {
            $where['axo_id'] = $producto;
        }
        $where['axo_id_ord']    = $orden;
        $data['bodega']         = $bodega;
        $data['tipo']           = $tipo;
        $data['detalles']       = $data['detalle_orden'] = $this->proyecto_model->get_detalle_orden($where);
        $html = $this->load->view('proyectos/procesos/consultar_detalles_materia_prima', $data, true);
        echo $html;
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    /*
     * @author: Elman Ortiz
     * @descripcion: Recupera los datos para ser usados al agregar horas extras
     */
    function hora_extra() {
        satelite_validar();
        if ($_POST) {
            // var_dump($_POST);die();
            $post = $this->input->post();
            $lis_tphex = $post['lis_tphrex']; //Tipo hora extra
            $lis_emp = $post['lis_emp']; //Empleados
            $lis_fec = $post['lis_fec']; //Fechas
            $lis_hinicio = $post['lis_hinicio']; //Horas de inicio
            $lis_hfin = $post['lis_hfin']; //Horas de fin
            $lis_hcant = $post['lis_hcant']; //Cantidad de horas
            $lis_tot = $post['lis_tot']; //Totales
            $lis_plan = $post['lis_plas']; //planilla a cancelar
            $lis_ord = $post['lis_ord']; //Id Ordenes
            $lis_concep = $post['lis_concep'];
            $btncrear = $post['btnCrear'];
            foreach ($lis_emp as $key => $value) {
                $hora = array(
                    'hxe_id_pla' => $lis_plan[$key],
                    'hxe_id_the' => $lis_tphex[$key],
                    'hxe_id_emp' => $lis_emp[$key],
                    'hxe_id_ord' => ($lis_ord[$key] > 0) ? $lis_ord[$key] : null,
                    'hxe_num_hora' => $lis_hcant[$key],
                    'hxe_observacion' => $lis_concep[$key],
                    'hxe_fecha' => formatear_fecha('Y-m-d', $lis_fec[$key]),
                    'hxe_hora_inicio' => ($lis_hinicio[$key] != "") ? $lis_hinicio[$key] : null,
                    'hxe_hora_fin' => ($lis_hfin[$key] != "") ? $lis_hfin[$key] : null,
                    'hxe_estado' => 1,
                    'hxe_usu_crea' => $this->tank_auth->get_user_id(),
                    'hxe_fecha_crea' => date('Y-m-d H:i:s'),
                    'hxe_usu_mod' => $this->tank_auth->get_user_id(),
                    'hxe_fecha_mod' => date('Y-m-d H:i:s')
                );
                $registro = $this->gsatelite->ingresar('hxe_hora_extraxempleado', $hora);
            }
            if ($btncrear == 1) {//Guardar y retornar a la misma pagina
                $this->gsatelite->show_dialog('', 'proyectos/procesos/hora_extra', 'success', 'Se procesaron los datos.');
            }
        } else {
            $idcliente = array();
            $codcliente = array();
            $nomcliente = array();
            $cliente = array();
            $ti_ord = array();
            $empleado = array();
            //Cliente
                            $this->db->join('ord_orden', 'cli_id = ord_id_cli');
            $data_cliente = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1, 'ord_estado' => 1));
            foreach ($data_cliente as $k => $val) {
                array_push($idcliente, $val['cli_id']);
                array_push($codcliente, $val['cli_codigo']);
                if ($val['cli_personeria'] == 1) {
                    array_push($nomcliente, $val['cli_nombre'] . ' ' . $val['cli_apellido']); //Persona Natural
                } else {
                    array_push($nomcliente, $val['cli_apellido']); //Persona Juridica
                }
            }
            $idcliente = array_values(array_unique($idcliente));
            $codcliente = array_values(array_unique($codcliente));
            $nomcliente = array_values(array_unique($nomcliente));
            foreach ($idcliente as $key => $value) {
                $cliente[$key]['id'] = $idcliente[$key];
                $cliente[$key]['cod_cliente'] = $codcliente[$key];
                $cliente[$key]['nombre_cliente'] = $nomcliente[$key];
            }
            $data['cliente'] = $cliente;
            //Tipo de hora extra
            $data_tp_orden = $this->gsatelite->get_tabla('the_tipo_hora_extra', array('the_estado' => 1));
            foreach ($data_tp_orden as $key => $value) {
                $ti_ord[$key]['id'] = $value['the_id'];
                $ti_ord[$key]['tp_nombre'] = $value['the_nombre'];
                $ti_ord[$key]['factor'] = $value['the_factor'];
            }
            $data['tp_orden'] = $ti_ord;
            //Empleado
            $data_empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado' => 1));
            foreach ($data_empleado as $key => $value) {
                $empleado[$key]['id'] = $value['emp_id'];
                $empleado[$key]['cod_emp'] = $value['emp_codigo'];
                $empleado[$key]['nom_emp'] = $value['emp_nombre'] . ' ' . $value['emp_apellido'];
                $empleado[$key]['salario'] = $value['emp_salario'];
            }
            $data['empleado'] = $empleado;
            $data['titulo_personal'] = "Horas extras";
            $this->_cargarvista($data);
        }
    }

    public function get_planillas_empleado($tipo = 0, $slectd = null){
        $id_emp = $this->input->post('emp_id');
        $id_pla = $this->input->post('pla_id');
        if ($tipo > 0) {
            $where = array('pla_id_tpl' => $id_pla, 'pla_estado >= ' => 1, 'pla_estado <= ' => 2);
                    $this->db->order_by('pla_fecha_inicio', 'DESC');
            $slct = $this->gsatelite->get_dropdown('pla_planilla','{pla_fecha_inicio} # {pla_fecha_fin}', '', $where, $slectd, '', 'pla_id', true);
            $data["select_plas"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $slct);
        } else {
            $ids_tpl = array(0);
            $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id_emp));
            foreach ($pregunta as $fila) {
                $ids_tpl[] = $fila['txe_id_tpl'];
            }
            $this->db->where_in('tpl_id', $ids_tpl);
            $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, $slectd, '', 'tpl_id', true);
            $data["select_tpls"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);
        }
        echo json_encode($data);
    }

    function cargar_select_ordenes_cliente($soloOpciones = false) {
        $id_cli = $this->input->post('id');
        $select = $this->gsatelite->get_dropdown('ord_orden', '{ord_codigo} - {ord_concepto}', 'orden', array('ord_id_cli' => $id_cli, 'ord_estado' => 1), null, 'placeholder="Seleccione" id="orden" style="width:100%;" class="nostyle hora_campo"', null, $soloOpciones);
        $datos['ordenes_select'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value="" ></option>', $select);
        die(json_encode($datos));
    }

    function cargar_select_ordenes_cliente_modal($soloOpciones = false) {
        $id_cli = $this->input->post('id'); //id del cliente
        $slctd = ($this->input->post('selected') > 0) ? $this->input->post('selected') : null; 
        $select = $this->gsatelite->get_dropdown('ord_orden', '{ord_codigo} - {ord_concepto}', 'ordenmo', array('ord_id_cli'=> $id_cli, 'ord_estado'=> 1), $slctd, 'placeholder="Seleccione" id="ordenmo" style="width:100%;" class="nostyle hora_campo"', null, $soloOpciones);
        $datos['ordenes_select'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value="" ></option>', $select);        
        die(json_encode($datos));
    }

    function historico_solicitudes($ord_id = null) {
        satelite_validar();

        $orden = $this->proyecto_model->get_ordenes(array('ord_id' => $ord_id));
        $data['orden'] = $orden[0];
        $data['requisiciones'] = $this->gsatelite->get_tabla('rxi_requisicion_inventario', array('rxi_id_ord' => $ord_id));
        $data['titulo_personal'] = "Histórico de Solicitud de Materiales";
        $this->_cargarvista($data);
    }

    function get_planillas_tipo($tipo_estado = 0) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $opciones = '<option value=""></option>';
            $tipo_planilla = $this->input->post('tipo');

            $where = array(
                'pla_id_tpl' => $tipo_planilla,
                'pla_estado <>' => 3
            );
            $periodos = $this->gsatelite->get_tabla('pla_planilla', $where);

            foreach ($periodos as $key) {
                switch ($key['pla_estado']) {
                    case '1':
                        $estado = "Creada";
                        break;
                    case '2':
                        $estado = "Generada";
                        break;
                    case '3':
                        $estado = "Autorizada";
                        break;

                    default:
                        # code...
                        break;
                }
                $opciones .= "<option value='" . $key['pla_id'] . "'>" . $key['pla_fecha_inicio'] . "  --  " . $key['pla_fecha_fin'] . " " . $estado . "</option>";
            }

            $arreglo = array(
                "periodos" => $opciones,
            );

            echo json_encode($arreglo);
        }
    }

    public function get_productos_orden() {
        if ($this->input->post()) {
            $post_array = $this->input->post();
            $where = null;
            if ($post_array['orden'] != '') {
                $where['axo_id_ord'] = $post_array['orden'];
            }
            $productos = $this->proyecto_model->get_detalle_orden($where);
            $opciones = "<option></option>";
            if (count($productos)) {
                foreach ($productos as $prod) {
                    $opciones .= "<option data-codigo='".$prod['art_codigo']."' data-medida='".$prod['mep_nombre']."' data-conversion='".$prod['axo_id_cva']."' data-cantidad='".$prod['axo_cantidad']."' data-descripcion='".$prod['axo_descripcion']."'  value='".$prod['axo_id']."'>" . $prod['art_codigo'] . ' - ' . $prod['art_nombre'] . "</option>";
                }
            }
            $resultado = array('productos' => $opciones);
            echo json_encode($resultado);
        }
    }

    function anular_envio_parcial($eno_id = null, $iframe = null) {
        if ($iframe != null) {
            $eno_id = $iframe;
            $iframe = 1;
        }
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));


            $doc_array = array(
                'eno_id_usu_anulacion' => $this->tank_auth->get_user_id(),
                'eno_fecha_anulacion' => date('Y-m-d H:i:s'),
                'eno_observacion_anulacion' => $post_array['txtComentario'],
                'eno_estado' => 0,
                'eno_usu_modificacion' => $this->tank_auth->get_user_id(),
                'eno_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $resultado = $this->gsatelite->actualizar_array('eno_envio_orden', $doc_array, array('eno_id' => $eno_id));

            //Si es iframe se enviar un parametro para cerrar el modal
            //Sino se redirecciona a la url configurada
            if ($iframe == 1) {
                $data['cerrar_modal'] = 1;
                $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Envio Parcial Anulado", 'texto_alerta' => "La anulación se procesó correctamente.");
            } else {
                $redireccionar = $post_array['redireccion'];
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Envio Parcial Anulado", 'texto_alerta' => "La anulación se procesó correctamente.");
                $this->session->set_flashdata($alerta);
                redirect($redireccionar);
            }
        }

        $envio = $this->gsatelite->get_tabla('eno_envio_orden', array('eno_id' => $eno_id));
        $ord_id = $envio[0]['eno_id_ord'];
        $orden = $this->proyecto_model->get_ordenes(array('ord_id' => $ord_id));
        $data['envio'] = $envio[0];
        $data['orden'] = $orden[0];
        $data['detalle_envio'] = $this->proyecto_model->get_detalle_envio(array('deo_id_eno' => $eno_id));
        $data['iframe'] = $iframe;
        $data['Titulo Personal'] = "Anular Envio Parcial";
        if ($iframe != null) {
            $this->gsatelite->cargar_vista_masterpage('proyectos/procesos/anular_envio_parcial', $data);
        } else {
            cargarvista($data);
        }
    }

    function eliminar_lotes($axo_id, $ord_id) {
        if ($axo_id != null) {


            $detalle_etapas = $this->proyecto_model->get_etapas_lotes(array('axo_id' => $axo_id));
            //var_dump($detalle_etapas);
            //die();
            if (count($detalle_etapas) == 0) {
                $this->gsatelite->borrado_general('lop_lote_produccion', array('lop_id_axo' => $axo_id));

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Lotes", 'texto_alerta' => "La información se elimino correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Lotes", 'texto_alerta' => "No puede eliminar el registro, ya que otros dependen de este.");
            }

            $this->session->set_flashdata($alerta);

            redirect('proyectos/procesos/lotes/' . $ord_id);
        }
    }

    public function generar_codigo_orden(){
        $tipo = $this->input->post('tipo');
        $id = $this->input->post('id');
        $prefijo = (trim($this->input->post('prefijo')) != null)?$this->input->post('prefijo'):  null;

        $respuesta = '';
        $estado = false;
        if($tipo == 1){//genera nuevo codigo
            $codigo_actual = $this->proyecto_model->generar_codigo_validar(array('ord_id_tio'=>$id));//verificamos en que numero va el codigo y contamos todos los del mismo tipo
            $estado = (count($codigo_actual) > 0)?true:false;//si devuelve algo es true
            $registros_codigo = $codigo_actual[0]['codigos']; //guardamos el codigo actual
            $respuesta = $prefijo.$registros_codigo; //generamos el codigo con el correlativo
            $estado2 = false;
            do {
                $registros_codigo++;//se suma 1 al correlativo
                $respuesta = $prefijo.$registros_codigo;//se genera el codigo con el correlativo+1
                $codigo_actual2 = $this->proyecto_model->generar_codigo_validar(array('ord_codigo'=>$respuesta)); //verificamos si existe el codigo generado
                $estado2 = ($codigo_actual2[0]['codigos'] == 0)?true:false; //si no existe es true y si existe es false y repite
                $estado = $estado2; //igualamos el estado al estado q mandaremos como respuesta
            } while ($estado2 != true);
        } else{
            $codigo_actual = $this->proyecto_model->generar_codigo_validar(array('ord_codigo'=>$id));
            $estado = ($codigo_actual[0]['codigos'] == 0)?true:false;
            $respuesta = $prefijo.$codigo_actual[0]['codigos'];
        }
        echo json_encode(array('resp'=>$respuesta, 'estado'=>$estado));
    }

    function generar_lotes_automaticos($idorden) {
        $articuloxorden = $this->gsatelite->get_tabla('axo_articuloxorden', array('axo_id_ord' => $idorden));
        $con = 1;
        foreach ($articuloxorden as $key => $artxord) {
            $lotes_array = array(
                        'lop_id_axo' => $artxord['axo_id'],
                        'lop_nombre' => 'Lote - '.$con,
                        'lop_cantidad' => $artxord['axo_cantidad'],
                        'lop_estado' => 1,
                        'lop_usu_creacion' => $this->tank_auth->get_user_id(),
                        'lop_fecha_creacion' => date('Y-m-d H:i:s'),
                        'lop_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'lop_fecha_modificacion' => date('Y-m-d H:i:s'),
                    );

            $res = $this->gsatelite->ingresar('lop_lote_produccion', $lotes_array);
            $con++;
        }

        if($res > 0){
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Lotes automaticos", 'texto_alerta' => "Lotes creados con éxito.");
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Lotes automaticos", 'texto_alerta' => "Los lotes no pudieron ser creados.");
        }

        $this->session->set_flashdata($alerta);

        if($res > 0){
            echo json_encode(array('estado' => 1));
        }else{
            echo json_encode(array('estado' => 0));
        }
    }

    /*
     * @author: Francisco Orozco
     * @descripcion: De vuelve tala de productos para el modal de agregar orden.
     */
    public function get_productos_masivo() {
        $result = "";
        if ( $_POST) {
            $categoria      = $this->input->post("categoria");
            $marca          = $this->input->post("marca");
            $presentacion   = $this->input->post("presentacion");
            $excepciones    = $this->input->post("excepciones");
            $where          = null;
            $where_not_in   = null;
            if ( $categoria != "" ) {
                $where["tia_id"] = $categoria;
            }
            if ( $marca != "" ) {
                $where["mrp_id"] = $marca;
            }
            if ( $presentacion != "" ) {
                $where["ppr_id"] = $presentacion;
            }
            if ( $excepciones != "" ) {
                $excepciones_array  = explode(",", $excepciones);
                $where_not_in       = $excepciones_array;
            }
            $data["productos"]  = $this->proyecto_model->get_productos_masivo($where,$where_not_in);
            $result = $this->load->view('proyectos/procesos/productos_masivos', $data, true);
        }
        echo $result;
        die();
    }

    /**
        * @author Francisco Orozco
        * @since  2018-1-15
        * @return Impresión de envío parcial
    */
    function imprimir_envio_parcial($ord_id, $id_envio=null){
        satelite_validar();
        $this->gsatelite->verificar_registro_real('ord_orden', $ord_id);
     
        $decimales_par      = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $data["detalle"]    =  $this->proyecto_model->get_envio_orden(array('ord_id' => $ord_id, 'eno_estado' => 1, 'eno_id' => $id_envio) );
        $data['esreporte']  = true;
        $html               = $this->load->view('proyectos/procesos/imprimir_envio_parcial', $data, true);

        $this->load->library('Pdf'); //libreria pdf
            if ($this->gsatelite->get_parametro('COT_APLICA_PIE_PAGINA') == 1) {
                $GLOBALS['es_cotizacion'] = 1;
                $this->pdf->setPrintFooter(false);
            } else {
                $this->pdf->setPrintFooter(false);
            }
        $this->pdf->makePDF_cotizacion($html, 'P', $nombre_pdf, 'Letter', 'I');
     }

    /*
     * @author: Elman Ortiz
     * @descripcion: Devuelve las etapas del producto para ser cargadas en la solicitud materiales
     */
    public function consultar_job_tracking_board() {        
        satelite_validar();
        $codorden = $this->input->post('codorden');
        $orden_id = $this->input->post('orden_id');
        $codproducto = $this->input->post('codproducto');
        $idlot_selected = $this->input->post('idlote');     
        $where = null;
        if ($codorden != '') {
            $where['ord_codigo'] = $codorden;
        }
        if ($codproducto != '') {
            $where['art_codigo'] = $codproducto;
        }
        if ($orden_id != '') {
            $where['ord_id'] = $orden_id;
        }
        //La consulta trae registros con id_art, id lote, id orden
        $etapas = $this->proyecto_model->get_etapas_producto_orden_board($where);
        $lotes  = $this->proyecto_model->get_etapas_producto_orden_board($where, 'lop_id');
        // print_r($this->db->last_query());die();
        $totalProceso = $this->gsatelite->get_suma('exo_etapaxarticulo_orden', 'exo_cantidad', array('exo_id_lop' => $idlot_selected, 'exo_estado' => 1));
        //obtener el primer registro y obtener la primer id lote
        if(count($etapas) > 0){
            if($idlot_selected != 0){//lote seleccionado                
                $row_primer_lote = $etapas[array_search($idlot_selected,array_unique(array_column($etapas,'lop_id')))];
            }else{
                $row_primer_lote = array_shift(array_values($etapas));
            }
            $primer_lote = $row_primer_lote['lop_id'];
            $where['exo_id_lop'] = $primer_lote;
            $fecha_orden = $row_primer_lote['fecha_orden'];    
            $fecha_orden_entrega = $row_primer_lote['fecha_entrega'];    
            $cliente = $row_primer_lote['cliente'];
            $cantidad_lote = $row_primer_lote['lop_cantidad'];
            $ctdad_ord = $row_primer_lote['axo_cantidad'];
            $nombre_articulo = ($idlot_selected > 0) ? $row_primer_lote['art_nombre'] : "";
            $codego_articulo = ($idlot_selected > 0) ? $row_primer_lote['art_codigo'] : "";
            $exo_id = $row_primer_lote['exo_id'];
            $exo_cantidad = $row_primer_lote['exo_cantidad'];
            $etapas_mostrar = $this->proyecto_model->get_etapas_producto_orden_board($where, null, 'exo_fin');
            $data['etapas'] = $etapas_mostrar;
            $data['fecha_orden'] = $fecha_orden;
            //Obtener la ultima etapa
            $idUltimaEtapa = $etapas_mostrar[0]['etp_final'];
            //Fichas iniciales                
            $fichas_iniciales = $this->proyecto_model->get_etapas_lotes(array('exo_id_lop' => $primer_lote));
            $data['fichas_iniciales'] = $fichas_iniciales;
            if ($idlot_selected > 0) {
                $html = $this->load->view('proyectos/procesos/consultar_job_tracking_board', $data,true);
            } else {
                $html = "";
            }
            $slc_lotes = '<option></option>';
            if(count($lotes) > 0){
                if ($idlot_selected > 0) {
                    foreach ($lotes as $m => $lote) {
                        if($lote['lop_id'] == $idlot_selected){
                            $slc_lotes .= '<option value="'.$lote['lop_id'].'" selected  data-codigo="'.$lote['ord_codigo'].'.'.$lote['art_codigo'].'">'.$lote['lop_nombre'].'</option>';
                        }else{
                            $slc_lotes .= '<option value="'.$lote['lop_id'].'" data-codigo="'.$lote['ord_codigo'].'.'.$lote['art_codigo'].'">'.$lote['lop_nombre'].'</option>';
                        }
                    }
                } else {
                    foreach ($lotes as $m => $lote) {
                        $slc_lotes .= '<option value="' . $lote['lop_id'] . '" data-codigo="' . $lote['ord_codigo'] . '.' . $lote['art_codigo'].'">'.$lote['lop_nombre'].'</option>';
                    }
                }
            }
            $code_producto = ($codproducto != '') ? $codproducto : $codego_articulo;
            echo json_encode(array('pizarron' => 1,'consulta' => $html, 'slcLotes' =>$slc_lotes, 'fecha_orden' => $fecha_orden, 'fecha_orden_entrega' => $fecha_orden_entrega, 'cliente' => $cliente, 'cantidad_lote' => $cantidad_lote, 'nombre_articulo' => $nombre_articulo, 'cod_producto' => $code_producto, 'exo_id' => $exo_id, 'exo_cantidad' => $exo_cantidad, 'totalProceso' => $totalProceso, 'idUltimaEtapa' => $idUltimaEtapa, 'cantidad_orden' => $ctdad_ord, 'total_etapas' => count($etapas)));      
        } else{
            echo json_encode(array('pizarron' => 0)); 
        } 
        die();
    }
    
    /**
     * @author Elman Ortiz
     * @return Pizarra de job tracking
     */
    function job_tracking_board() {
        satelite_validar();    
        $ordenes = $this->gsatelite->get_dropdown('ord_orden', '{ord_codigo}', '', array('ord_estado' => 1), null, null, 'ord_id', true);
        $data['opciones'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option></option>', $ordenes);
        $data['titulo_personal'] = 'Job Tracking Movimiento';
        $this->_cargarvista($data);
    }

    /**
     * @author: Elman Ortiz
     * @descripcion: Sirve para agregar la primera ficha del movimiento
     */
    public function insertar_ficha_movimiento_job_tracking() {
        $exo_id = $this->input->post('exo_id');
        $nueva_cantidad = $this->input->post('nueva_cantidad');        

        $array_moe_movimiento_etapa = array(
            'moe_id_exo' => $exo_id,
            'moe_id_usu_entrada' => $this->tank_auth->get_user_id(),
            'moe_cantidad' => $nueva_cantidad, 
            'moe_ingreso_inventario' => 0, 
            'moe_estado' => 1,
            'moe_usu_creacion' => $this->tank_auth->get_user_id(),
            'moe_fecha_entrada' => date('Y-m-d H:i:s'),
            'moe_hora_entrada' => date('H:i:s'),
            'moe_fecha_creacion' => date('Y-m-d H:i:s'),
            'moe_usu_modificacion' => $this->tank_auth->get_user_id(),
            'moe_fecha_modificacion' => date('Y-m-d H:i:s')
            );

        $resultado = $this->gsatelite->ingresar('moe_movimiento_etapa', $array_moe_movimiento_etapa);
        
        //Nuevo valor a guardar
        $cant_actual = $this->gsatelite->get_campo('exo_etapaxarticulo_orden', 'exo_cantidad', array('exo_id' => $exo_id));        
        $exo_cant_actualizar = $cant_actual + $nueva_cantidad;
        $this->gsatelite->actualizar_array('exo_etapaxarticulo_orden', array('exo_cantidad' =>$exo_cant_actualizar), array('exo_id' => $exo_id));

        if($resultado > 0){
            return true;
        }else{
            return false;
        }
    }

    /**
     * @author: Elman Ortiz
     * @descripcion: Sirve para agregar la primera ficha del movimiento
     */
    public function set_actualizar_ficha_etapa() {
        $idexo = $this->input->post('idexo');
        $etapa = $this->input->post('etapa');
        $cantidadficha = $this->input->post('cantidadficha');
        $exoid_inicio = $this->input->post('exoid_inicio');
        $ultimaEtapa = $this->input->post('ultimaEtapa');
        //Nuevo valor a guardar
        $cant_actual = $this->gsatelite->get_campo('exo_etapaxarticulo_orden', 'exo_cantidad', array('exo_id' => $idexo));        
        $exo_cant_actualizar = $cant_actual + $cantidadficha;
        $this->gsatelite->actualizar_array('exo_etapaxarticulo_orden', array('exo_cantidad' =>$exo_cant_actualizar), array('exo_id' => $idexo));
        $this->gsatelite->actualizar_array('exo_etapaxarticulo_orden', array('exo_cantidad' =>0.00), array('exo_id' => $exoid_inicio));
        $array_moe_movimiento_etapa = array(
            'moe_id_exo' => $idexo,
            'moe_id_exo_origen' => $exoid_inicio,
            'moe_id_exo_destino' => $idexo,
            'moe_estado' => 1,
            'moe_id_usu_entrada' => $this->tank_auth->get_user_id(),
            'moe_cantidad' => $cantidadficha,
            'moe_ingreso_inventario' => 0,
            'moe_fecha_entrada' => date('Y-m-d'),
            'moe_hora_entrada' => date('H:i:s'),                        
            'moe_usu_creacion' => $this->tank_auth->get_user_id(),
            'moe_fecha_creacion' => date('Y-m-d H:i:s'),            
            'moe_usu_modificacion' => $this->tank_auth->get_user_id(),
            'moe_fecha_modificacion' => date('Y-m-d H:i:s')
        );
        $moe_id = $this->gsatelite->ingresar('moe_movimiento_etapa', $array_moe_movimiento_etapa);
        //Actualizar datos del movimiento etapa
        $array_update_moe_movimiento_etapa = array(            
            'moe_id_exo_destino' => $idexo,
            'moe_estado' => 1,
            'moe_id_usu_salida' => $this->tank_auth->get_user_id(),                        
            'moe_fecha_salida' => date('Y-m-d'),
            'moe_hora_salida' => date('H:i:s'),                                    
            'moe_usu_modificacion' => $this->tank_auth->get_user_id(),
            'moe_fecha_modificacion' => date('Y-m-d H:i:s')
        );
        $this->gsatelite->actualizar_array('moe_movimiento_etapa',$array_update_moe_movimiento_etapa, array('moe_id_exo' => $exoid_inicio, 'moe_fecha_salida' => null));
        if($etapa == $ultimaEtapa){
            $tip_entrada_par = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS');
            $tipos_array = json_decode($tip_entrada_par, true);
            $tip_entrada = $tipos_array['TRACKING'];
            $bod_x_etapa = $this->proyecto_model->get_bodega_x_etapa(array('exo_id' => $idexo));
            $bod_id = $bod_x_etapa[0]['bod_id'];
            $orden = $this->proyecto_model->get_ord_x_exo(array('exo_id' => $idexo));
            if ($bod_id != "" && $tip_entrada != "" && $orden[0]['axo_total'] != "") {
                $ya_ingresado = $this->proyecto_model->get_cantidad_tracking(array('moe_ingreso_inventario' => 1, 'lop_id' => $orden[0]['lop_id'])); 
                $cantidad_intocable = (is_null($ya_ingresado[0]['cantidad'])) ? 0 : $ya_ingresado[0]['cantidad'];
                $detalle_moi_arrayy = array(
                    'moi_id_tip' => $tip_entrada,
                    'moi_id_bod' => $bod_id,    
                    'moi_documento' => $orden[0]['ord_codigo'],
                    'moi_descripcion' => "Entrada desde produccion",
                    'moi_fecha_mov' => date('Y-m-d H:i:s'),
                    'moi_estado' => 1,
                    'moi_usu_creacion' => $this->tank_auth->get_user_id(),
                    'moi_fecha_creacion' => date('Y-m-d H:i:s'),
                    'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $moi_id = $this->gsatelite->ingresar('moi_movimiento_inv', $detalle_moi_arrayy);
                                $this->db->join('cva_conversion_articulo','cva_id=axo_id_cva', 'left');
                $articulo_reg = $this->gsatelite->get_tabla('axo_articuloxorden', array('axo_id' => $orden[0]['axo_id']));
                foreach ($articulo_reg as $key) {                
                    $multiplicar_conversion = ($key['cva_conversion'])? $key['cva_conversion']:1;                            
                    $cantidad_axo = (double)str_replace(',', '', $cantidadficha);
                    $proporcion = $cantidad_axo / $orden[0]['axo_cantidad'];
                    $prec_unit = ($orden[0]['axo_total'] * $proporcion) / $cantidadficha;
                    $precio_subtotal = $prec_unit * ($cantidadficha * $multiplicar_conversion);
                    $sar_detalle_array = array(
                        'sar_id_art' => $key['axo_id_art'],
                        'sar_id_bod' => $bod_id,
                        'sar_cant_actual' => ($cantidad_axo * $multiplicar_conversion),
                        'sar_precio' => $prec_unit,
                        'sar_fecha_caducidad' => null,
                        'sar_id_sxb' => ($key['etp_id_sxb'] != "") ? $key['etp_id_sxb'] : null,
                        'sar_estado' => 1,
                        'sar_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sar_fecha_creacion' => date('Y-m-d H:i:s'),
                        'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sar_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $sar_id = $this->gsatelite->ingresar('sar_saldo_articulo', $sar_detalle_array);
                    $dee_detalle_array = array(
                        'dee_id_moi' => $moi_id,
                        'dee_id_art' => $key['axo_id_art'],
                        'dee_id_sar' => $sar_id,
                        'dee_id_cva' => $key['axo_id_cva'],
                        'dee_id_sxb' => ($key['etp_id_sxb'] != "") ? $key['etp_id_sxb'] : null,
                        'dee_cantidad' => ($cantidad_axo * $multiplicar_conversion),
                        'dee_fecha_caducidad' => null,
                        'dee_precio' => $prec_unit,
                        'dee_subtotal' => $precio_subtotal,
                        'dee_estado' => 1,
                        'dee_usu_creacion' => $this->tank_auth->get_user_id(),
                        'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                        'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dee_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('dee_detalle_mov', $dee_detalle_array);
                }
                if ($moi_id > 0) {
                    $detalle_moe_array2 = array(
                        'moe_id_moi' => $moi_id,
                        'moe_ingreso_inventario' => 1
                    );
                    $this->gsatelite->actualizar_array('moe_movimiento_etapa', $detalle_moe_array2, array('moe_id' => $moe_id));
                }
            }
        }
    }   

    /**
     * @author: Elman Ortiz
     * @descripcion: Se obtienen los movimientos de cada etapa
     */
    public function get_movimiento_etapa() {
        $idexo = $this->input->post('idexo');
        //print_r()
        $mov_etapas = $this->gsatelite->get_tabla('moe_movimiento_etapa', array('moe_id_exo' => $idexo));
        $data['mov_etapas'] = $mov_etapas;
        //$data['titulo_personal'] = "Ordenes de producción";
        $html = $this->load->view("proyectos/procesos/datalles_movimiento_etapa", $data, true);

        echo $html;
        //print_r($mov_etapas); die();
    }

    /**
    * @author René Castaneda
    * @since 2018-12-19
    * @return generación de codigos de barra
    */
    public function impresion_codigos($id_orden=0){   
        $where['ord_id'] = $id_orden;
        $data["registros"] = $this->proyecto_model->get_orden_produccion_cod($where);
        $this->load->library('pdf');
        $html  = $this->load->view('reporte/header', array('titulo' => 'Codigos para orden de producción','solotitulo'=>true), true);
        $html .= $this->load->view('proyectos/procesos/impresion_codigos', $data, true);                  
        $reporte=$this->pdf->makePDF($html, 'P');
    }

        /*
     * @author: Elman Ortiz
     * @descripcion: Devuelve las etapas del producto para ser cargadas en la solicitud materiales
     */
    public function get_etapas_producto_solicitud_materiales() {
        
        $idproducto = $this->input->post('idproducto');
        $idorden = $this->input->post('idorden');
        $etapas = $this->proyecto_model->get_etapas_producto_solicitud_materiales(array('art_id' => $idproducto, 'axo_id_ord' => $idorden));
        //print_r($etapas); die();
        $opciones = '<option></option>';
        if(count($etapas) > 0){
            foreach ($etapas as $m => $etapa) {
                $opciones .= '<option value="'.$etapa['etp_id'].'">'.$etapa['etp_nombre'].'</option>';
            }
        }else{
            $etapas = $this->gsatelite->get_tabla('etp_etapa');
            foreach ($etapas as $n => $etapa) {
                $opciones .= '<option value="'.$etapa['etp_id'].'">'.$etapa['etp_nombre'].'</option>';
            }
        }        

        echo $opciones;
    }

     /**
    * @author Nelson Soriano
    * @since  14/02/2019
    * @param  id de la orden a duplicar
    * @return Duplica la orden seleccionada, y devuelve al usuario un mensaje de confirmacion del estado de la operacion
    * Descripcion: Funcion para duplicar una orden de produccion, se duplica lotes, etapas, job tracking planeado
    */

     public function duplicar_orden($ord_id = null){
        satelite_validar();
        //creamos el codigo de la orden
        $tio_id           = $this->gsatelite->get_campo('ord_orden','ord_id_tio',array('ord_id' => $ord_id));
        $prefijo          = $this->gsatelite->get_campo('tio_tipo_orden','tio_prefijo',array('tio_id' => $tio_id));
        $prefijo          = ($prefijo != '') ? $prefijo : null;
        $respuesta        = '';
        $codigo_actual    = $this->proyecto_model->generar_codigo_validar(array('ord_id_tio' => $tio_id));
        $estado           = (count($codigo_actual) > 0) ? true : false;
        $registros_codigo = $codigo_actual[0]['codigos'];
        $respuesta        = $prefijo.$registros_codigo;
        $estado2          = false;
        do {
            $registros_codigo++;
            $respuesta = $prefijo . $registros_codigo;
            $codigo_actual2 = $this->proyecto_model->generar_codigo_validar(array('ord_codigo' => $respuesta));
            $estado2 = ($codigo_actual2[0]['codigos'] == 0) ? true : false; 
            $estado = $estado2; 
            } while ($estado2 != true);
        $nuevo_codigo = $respuesta;
        //--------------------------------//

        if ($ord_id > 0) {
            $orden = $this->proyecto_model->get_ordenes(array('ord_id' => $ord_id));
            foreach ($orden as $key => $valores) {
                $orden_array = array(
                    'ord_id_cli'             => $valores['ord_id_cli'],
                    'ord_id_ven'             => $valores['ord_id_ven'],
                    'ord_id_tio'             => $valores['ord_id_tio'],
                    'ord_codigo'             => $nuevo_codigo,
                    'ord_id_con'             => $valores['ord_id_con'],
                    'ord_id_cot'             => $valores['ord_id_cot'],
                    'ord_id_pcl'             => $valores['ord_id_pcl'],
                    'ord_fecha'              => $valores['ord_fecha'],
                    'ord_fecha_entr'         => $valores['ord_fecha_entr'],
                    'ord_concepto'           => $valores['ord_concepto'],
                    'ord_comentario'         => $valores['ord_comentario'],
                    'ord_referencia'         => $valores['ord_referencia'],
                    'ord_estado'             => 1,
                    'ord_usu_creacion'       => $this->tank_auth->get_user_id(),
                    'ord_fecha_creacion'     => date('Y-m-d H:i:s'),
                    'ord_usu_modificacion'   => $this->tank_auth->get_user_id(),
                    'ord_fecha_modificacion' => date('Y-m-d H:i:s')
                );
            }
            $ord_id_add = $this->gsatelite->ingresar('ord_orden', $orden_array);
            if($ord_id_add){
                $detalle = $this->proyecto_model->get_detalle_orden(array('axo_id_ord' => $ord_id));
                foreach ($detalle as $key => $valores) {
                    $detalle_orden = array(
                        'axo_id_ord'        => $ord_id_add,
                        'axo_id_art'        => $valores['axo_id_art'],
                        'axo_id_axc'        => ($valores['axo_id_axc'] != '') ? $valores['axo_id_axc'] : null,
                        'axo_id_cva'        => ($valores['axo_id_cva'] != '') ? $$valores['axo_id_cva'] : null,
                        'axo_id_rea'        => ($valores['axo_id_rea'] != '') ? $$valores['axo_id_rea'] : null,
                        'axo_descripcion'   => ($valores['axo_descripcion'])?$valores['axo_descripcion'] : '',
                        'axo_cantidad'      => $valores['axo_cantidad'],
                        'axo_estado'        => 1,
                        'axo_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'axo_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'axo_usu_creacion'       => $this->tank_auth->get_user_id(),
                        'axo_fecha_creacion'     => date('Y-m-d H:i:s')
                    );  
                    $axo_id = $this->gsatelite->ingresar('axo_articuloxorden', $detalle_orden);
                    $lotes_creados = array();
                    if($axo_id){
                        // creamos los lotes del producto
                        $lote = $this->gsatelite->get_tabla('lop_lote_produccion',array('lop_id_axo' => $valores['axo_id']));
                        foreach ($lote as $key => $lotes) {
                            $lotes_array = array(
                                'lop_id_axo'                => $axo_id,
                                'lop_nombre'                => $lotes['lop_nombre'],
                                'lop_cantidad'              => $lotes['lop_cantidad'],
                                'lop_estado'                => 1,
                                'lop_usu_creacion'          => $this->tank_auth->get_user_id(),
                                'lop_fecha_creacion'        => date('Y-m-d H:i:s'),
                                'lop_usu_modificacion'      => $this->tank_auth->get_user_id(),
                                'lop_fecha_modificacion'    => date('Y-m-d H:i:s')
                            );
                            $lotes_creados[] = $this->gsatelite->ingresar('lop_lote_produccion',$lotes_array);
                        }
                        // creamos las etapas de la orden
                        $i = 0;
                        foreach ($lote as $key => $lotes_exo) {
                            $etapas_exos       = $this->gsatelite->get_tabla('exo_etapaxarticulo_orden',array('exo_id_lop' => $lotes_exo['lop_id']));
                            foreach ($etapas_exos as $key => $etapa) {
                                $etapas_array            =  array(
                                    'exo_id_etp'             => $etapa['exo_id_etp'],
                                    'exo_id_lop'             => $lotes_creados[$i],
                                    'exo_duracion'           => $etapa['exo_duracion'],
                                    'exo_comentario'         => $etapa['exo`_comentario'],
                                    'exo_orden'              => $etapa['exo_orden'],
                                    'exo_fin'                => $etapa['exo_fin'],
                                    'exo_cantidad'           => $etapa['exo_cantidad'],
                                    'exo_estado'             => 1,
                                    'exo_usu_creacion'       => $this->tank_auth->get_user_id(),
                                    'exo_fecha_creacion'     => date('Y-m-d H:i:s'),
                                    'exo_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                    'exo_fecha_modificacion' => date('Y-m-d H:i:s'),
                                );
                                $this->gsatelite->ingresar('exo_etapaxarticulo_orden', $etapas_array);                                
                            }
                            $i++;
                        }

                        // creamos los presupuestos de la orden
                        $materia_ord = $this->gsatelite->get_tabla('axm_articulo_matxarticulo_ord',array('axm_id_axo'=>$valores['axo_id']));
                        foreach ($materia_ord    as $key => $materia_cot) {
                            $materia_prima               =  array(
                                'axm_id_axo'                => $axo_id,
                                'axm_id_cva'                => $materia_cot['axm_id_cva'],
                                'axm_id_prv'                => $materia_cot['axm_id_prv'],
                                'axm_id_etp'                => $materia_cot['axm_id_etp'],
                                'axm_id_art_materia'        => $materia_cot['axm_id_art_materia'],
                                'axm_cantidad'              => $materia_cot['axm_cantidad'],
                                'axm_precio'                => ($materia_cot['axm_precio'] == null)?0:$materia_cot['axm_precio'],
                                'axm_estimacion_porcentaje' => $materia_cot['axm_estimacion_porcentaje'],
                                'axm_estado'                => 1,
                                'axm_usu_creacion'          => $this->tank_auth->get_user_id(),
                                'axm_fecha_creacion'        => date('Y-m-d H-i-s'),
                                'axm_usu_modificacion'      => $this->tank_auth->get_user_id(),
                                'axm_fecha_modificacion'    => date('Y-m-d H-i-s')
                            );
                            $this->gsatelite->ingresar('axm_articulo_matxarticulo_ord',$materia_prima);
                        }

                        $mano_obra_ord = $this->gsatelite->get_tabla('mxo_mano_obraxarticulo_ord',array('mxo_id_axo'=>$valores['axo_id']));
                        foreach ($mano_obra_ord as $k  => $mano_cot) {
                            $mano_obra                   =  array(
                                'mxo_id_axo'                => $axo_id,
                                'mxo_id_mob'                => $mano_cot['mxo_id_mob'],
                                'mxo_id_emp'                => $mano_cot['mxo_id_emp'],
                                'mxo_cantidad'              => $mano_cot['mxo_cantidad'],
                                'mxo_precio'                => ($mano_cot['mxo_precio'] == null)?0:$mano_cot['mxo_precio'],
                                'mxo_estimacion_porcentaje' => $mano_cot['mxo_estimacion_porcentaje'],
                                'mxo_estado'                => 1,
                                'mxo_usu_creacion'          => $this->tank_auth->get_user_id(),
                                'mxo_fecha_creacion'        => date('Y-m-d H-i-s'),
                                'mxo_usu_modificacion'      => $this->tank_auth->get_user_id(),
                                'mxo_fecha_modificacion'    => date('Y-m-d H-i-s')
                            );
                            $this->gsatelite->ingresar('mxo_mano_obraxarticulo_ord',$mano_obra);
                        }
                        $estimacion = $this->gsatelite->get_tabla('exr_estimacionxarticulo',array('exr_id_axo'=>$valores['axo_id']));
                        foreach ($estimacion as $key => $gastos_cot) {
                            $gastos_indirectos          =  array(
                                'exr_id_esm'            => $gastos_cot['exr_id_esm'],
                                'exr_id_axo'            => $axo_id,
                                'exr_cantidad'          => $gastos_cot['exr_cantidad'],
                                'exr_precio'            => ($gastos_cot['exr_precio'] == null) ? 0 : $gastos_cot['exr_precio'],
                                'exr_estado'            => 1,
                                'exr_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'exr_fecha_creacion'    => date('Y-m-d H-i-s'),
                                'exr_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'exr_fecha_modificacion'=> date('Y-m-d H-i-s')
                            );
                            $this->gsatelite->ingresar('exr_estimacionxarticulo',$gastos_indirectos);
                        }

                        $caracteristicas = $this->gsatelite->get_tabla('cdo_caracteristicaxdetalle_orden',array('cdo_id_axo' => $axo_id));
                        foreach ($$caracteristicas as $key => $valor) {
                            $detalle_carac_array = array(
                                'cdo_id_cxu'             => $valor['cdo_id_axo'],
                                'cdo_id_axo'             => $axo_id,
                                'cdo_valor'              =>  $valor['cdo_valor'],
                                'cdo_estado'             => 1,
                                'cdo_usu_creacion'       => $this->tank_auth->get_user_id(),
                                'cdo_fecha_creacion'     => date('Y-m-d H:i:s'),
                                'cdo_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                'cdo_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('cdo_caracteristicaxdetalle_orden', $detalle_carac_array);
                        }

                        //anexos
                        $anexos = $this->gsatelite->get_tabla('aop_anexo_orden_produccion',array('aop_id_ord' => $ord_id));
                        foreach ($anexos as $key => $value) {
                            $anexos = array(
                                'aop_id_ord'             => $ord_id_add,
                                'aop_url'                => $value['aop_url'],
                                'aop_nombre'             => $value['aop_nombre'],
                                'aop_estado'             => 1,
                                'aop_usu_creacion'       => $this->tank_auth->get_user_id(),
                                'aop_fecha_creacion'     => date('Y-m-d H:i:s'),
                                'aop_usu_modificacion'   => date('Y-m-d H:i:s'),
                                'aop_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('aop_anexo_orden_produccion',$anexos);
                        }
                    }// IF AXO_ID                      
                }// FOREACH
            }//ORD_ID
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Orden de Producción", 'texto_alerta' => "La orden fue duplicada. ");
            //ORD_ID AGREGAR
        }else{
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Orden no pudo ser Duplicada");
        }
        $this->session->set_flashdata($alerta);
        redirect('proyectos/procesos/editar_orden/'.$ord_id_add);
    }

    public function get_proyecto_x(){
        satelite_validar();
        $cliente    = $this->input->post('cliente');
        $pcl_option = '<option></option>';
        $data       = $this->gsatelite->get_tabla('pcl_proyecto_cliente',array('pcl_id_cli' => $cliente,'pcl_estado'=> 1, 'pcl_fecha_cierre' => NULL));
        foreach ($data as $key => $value) {
            $pcl_option .= '<option value="'.$value['pcl_id'].'">'.$value['pcl_codigo']." - ".$value['pcl_nombre'].'</option>';    
        }
        echo json_encode(array('proyectos' => $pcl_option));
        die();
    }

    /**
    * @author Nelson Soriano
    * @since  14/08/2019
    * @param  none
    * @return Vista con las ordenes que aplican para anulacion
    * Descripcion: Funcion para crear la vista para anulacion de ordenes de produccion
    */

    public function anulacion_orden(){
        satelite_validar();
        $data['permisos']        = $this->gsatelite->get_permisos_opcion();
        $data['titulo_personal'] = 'Anulacion de ordenes de producción'; 

          /* Estados de una requisicion
                1 = Creada
                2 = Pendiente de Autorizacion
                3 = Autorizada
                4 = Rechazada
                5 = Anulada
                6 = Parcial
                0 = Despachada
            */

        if ($_POST) {
                //Procesamos el post
                $estadox             = '1';//,2,3,4,6,0';
                $cliente             = ($this->input->post('slcFiltro')) ? $this->input->post('slcFiltro') : '' ;
                $fecha_inicio        = ($this->input->post('txtFechaIni')) ? $this->input->post('txtFechaIni') : '' ;
                $fecha_fin           = ($this->input->post('txtFechaFin')) ? $this->input->post('txtFechaFin') : '' ;
                $where               = array();

                if($fecha_inicio){
                    $where['date_format(ord_fecha,"%Y-%m-%d") >='] =  date_format(date_create($fecha_inicio),'Y-m-d');
                    $data['fecha_inicio'] = $fecha_inicio;
                  }
                if($fecha_fin){
                    $where['date_format(ord_fecha,"%Y-%m-%d") <='] = date_format(date_create($fecha_fin),'Y-m-d');
                    $data['fecha_fin'] = $fecha_fin;
                }
                if($cliente){
                   $where['cli_id'] = $cliente;
                }
                if($estadox != ''){
                    $where['ord_estado in ('.$estadox.')'] = null;
                }

                $data['ordenes'] = $this->proyecto_model->get_ordenes($where);
            }

            $this->db->group_by('cli_id');
            $this->db->join('cli_cliente', 'ord_id_cli = cli_id');
            $data['clientes'] = $this->gsatelite->get_tabla('ord_orden', array('cli_estado' => 1));
            $this->_cargarvista($data);
    }

    /**
    * @author Nelson Soriano
    * @since  14/08/2019
    * @param  id de la orden para anular
    * @return 1 ó 0 si se ejecuta la solicitud
    * Descripcion: Funcion para anular una orden de venta, cambiando el estado, y revirtiendo los materiales que    hayan sido sacdos del inventario
    */

    public function generar_anulacion_orden(){
        satelite_validar();
        $id_orden      = $this->input->post('ord');
        $resp          =  1;
        if ($id_orden != '') {
            /* Estados de una orden
                0 = Anulada
                1 = Activa
                2 = Finalizada
            */
            ## paso 1 cambio de estado de la orden de produccion ##
           $this->gsatelite->actualizar_array('ord_orden',array('ord_estado' => 0),array('ord_id' => $id_orden));
            
            ## paso 2 Obtenemos las requisiciones de inventario que se hayan realizado
            $req_inventario = $this->gsatelite->get_tabla('rxi_requisicion_inventario',array('rxi_id_ord' => $id_orden));
            $info_orden     = $this->gsatelite->get_tabla('ord_orden',array('ord_id' => $id_orden));
            $orden_cod      = $info_orden[0]['ord_codigo'];
            /* Estados de una requisicion
                1 = Creada
                2 = Pendiente de Autorizacion
                3 = Autorizada
                4 = Rechazada
                5 = Anulada
                6 = Parcial
                0 = Despachada
            */

            // Preguntamos si hay productos terminados que entraron a inventario
            $tip_salida   = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS', null, null, array("SAL_ANULA_OP")); 
            $where['ord_id'] = $id_orden;
            $where['!ISNULL(moe_id_moi)'] = NULL;
            $productos  = $this->proyecto_model->get_productos_detalle_ingreso($where);              
            //print_r($productos); die();

            $respuesta = $this->db->insert('moi_movimiento_inv', array(
                'moi_id_prv'            => $val['moi_id_prv'],
                'moi_id_tip'            => $tip_salida,
                'moi_id_bod'            => $val['moi_id_bod'],
                'moi_documento'         => ($val['moi_documento'] != null)?$val['moi_documento']:null,
                'moi_descripcion'       => 'Salida por anulacion de orden de produccion',
                'moi_fecha_mov'         => date('Y-m-d H:i:s'),
                'moi_estado'            => 1,
                'moi_usu_creacion'      => $this->tank_auth->get_user_id(),
                'moi_fecha_creacion'    => date('Y-m-d H:i:s'),
                'moi_usu_modificacion'  => $this->tank_auth->get_user_id(),
                'moi_fecha_modificacion'=> date('Y-m-d H:i:s')
            ));

            $moi_id = $this->db->insert_id();

            while (list($key,$val) = each($productos)) { 
             $cantidades   = $this->inventario_model->get_sar_cantidades($val['dee_id_art'], null,null);           
             $this->load->library('../controllers/inventario/gestion_productos');
             $sector = ($val['dee_id_sxb'] != '')?$val['dee_id_sxb']:null;
             $this->gestion_productos->peps_salida($val['dee_id_art'], null, $moi_id, $val['dee_id_cva'], $val['dee_cantidad'], $sector, $cantidades[0]['sar_cant_actual'], $val['moi_id_bod'], null, null, $val['dee_codigo_lote']);
            }


            while (list($key,$value) = each($req_inventario)) {
                $estado = (int) $value['rxi_estado'];
                $rxi_id = (int) $value['rxi_id'];
                switch ($estado) {
                    case 0:
                        $resp = $this->anula_rxi_detalle($rxi_id,$orden_cod);
                        
                        break;
                    case 1:
                        $resp = $this->anular_rxi($rxi_id);
                        break;
                    case 2:
                        $resp = $this->anular_rxi($rxi_id);
                        break;
                    case 3:
                        $resp = $this->anular_rxi($rxi_id);
                        break;
                    case 4:
                        $resp = $this->anular_rxi($rxi_id);
                        break;
                    case 6:
                        $resp = $this->anula_rxi_detalle($rxi_id,$orden_cod,1);
                        break;
                }

            }
        }
        if ($resp) {
             $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Entrada de productos", 'texto_alerta' => "El registro se guardó correctamente");
        }else{
            $alerta  = array('error','Error al procesar la solicitud','Por favor intenta nuevamente');
        }
      
        $this->session->set_flashdata($alerta);
        echo json_encode(array('resp' => $resp));die();
    }

    public function anular_rxi($rxi_id = null){
        if ($rxi_id !== null) {
           $resp = $this->gsatelite->actualizar_array('rxi_requisicion_inventario',array('rxi_estado' => 5),array('rxi_id' => $rxi_id));
           if ($resp) {
               return 1;
           }else{ 
            return 0;
           }
        }
    }

    public function anula_rxi_detalle($rxi_id = null,$cod = null,$parcial = null){
        if ($rxi_id !== null) {
            $materiales = $this->proyecto_model->get_detalle_requisicion_inventx(array('dri_id_rxi' => $rxi_id),'dri_id');
            //print_r($materiales); die();
            $tip2  = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS', null, null, array("ENT_ANULA_OP")); 
           
            while(list($key,$value) = each($materiales)) {
                $ent_anula_op  = array(
                'moi_id_tip'             => $tip2,
                'moi_id_bod'             => $value['rxi_id_bod'],
                'moi_descripcion'        => 'Entrada por anulacion de orden de Produccion',
                'moi_fecha_mov'          => date('Y-m-d H:i:s'),
                'moi_estado'             => 1,
                'moi_usu_creacion'       => $this->tank_auth->get_user_id(),
                'moi_fecha_creacion'     => date('Y-m-d H:i:s'),
                'moi_usu_modificacion'   => $this->tank_auth->get_user_id(),
                'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $id_moi = $this->gsatelite->ingresar('moi_movimiento_inv',$ent_anula_op);
                $actual =  $value['dri_cantidad_despacho'];
               $respuesta = $this->db->insert('sar_saldo_articulo', array(
                'sar_id_art'             => $value['sar_id_art'],
                'sar_id_bod'             => $value['sar_id_bod'],
                'sar_cant_actual'        => $actual,
                'sar_precio'             => $value['sar_precio'],
                'sar_fecha_caducidad'    => $value['sar_fecha_caducidad'],
                'sar_id_sxb'             => $value['sar_id_sxb'],
                'sar_estado'             => 1,
                'sar_usu_creacion'       => $this->tank_auth->get_user_id(),
                'sar_fecha_creacion'     => date('Y-m-d H:i:s'),
                'sar_usu_modificacion'   => $this->tank_auth->get_user_id(),
                'sar_fecha_modificacion' => date('Y-m-d H:i:s')
                ));
             $sar_id = $this->db->insert_id();

             $dee_array = array(
                        'dee_id_moi'             => $id_moi,
                        'dee_id_art'             => $value['dee_id_art'],
                        'dee_id_sar'             => $sar_id,
                        'dee_id_cva'             => $value['dee_id_cva'],
                        'dee_id_sxb'             => $value['dee_id_sxb'],
                        'dee_cantidad'           => $value['dee_cantidad'],
                        'dee_fecha_caducidad'    => $value['dee_fecha_caducidad'],
                        'dee_precio'             => $value['dee_precio'],
                        'dee_subtotal'           => $value['dee_precio'],
                        'dee_codigo_lote'        =>(($value['dee_codigo_lote']) != "") ? $value['dee_codigo_lote'] : null,
                        'dee_estado'             => 1,
                        'dee_usu_creacion'       => $this->tank_auth->get_user_id(),
                        'dee_fecha_creacion'     => date('Y-m-d H:i:s'),
                        'dee_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'dee_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                $dee_id  = $this->gsatelite->ingresar('dee_detalle_mov', $dee_array);
                $axm = array(
                    'axm_cantidad'               => $value['axm_cantidad'],
                    'axm_precio'                 => $value['axm_precio'],
                    'axm_pendiente'              => $value['axm_despachada'],
                    'axm_despachada'             => 0,
                    'axm_estimacion_porcentaje'  => $value['axm_estimacion_porcentaje'],
                    'axm_estado'                 => 1,
                    'axm_usu_creacion'           => $this->tank_auth->get_user_id(),
                    'axm_fecha_creacion'         => date('Y-m-d H:i:s'),
                    'axm_usu_modificacion'       => $this->tank_auth->get_user_id(),
                    'axm_fecha_modificacion'     => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('axm_articulo_matxarticulo_ord',$axm,array('axm_id' => $value['axm_id']));
                
            }            
            return 1;
        }else{ return 0;}
    }

    public function planificacion_produccion(){
        satelite_validar();
        if ($_POST) {
            $html = "";
            $post_array = $this->input->post();
            $fecha_ini = formatear_fecha('Y-m-d', $post_array['fecha_ini']);
            $fecha_fin = formatear_fecha('Y-m-d', $post_array['fecha_fin']);
            $tabla = $this->gsatelite->get_tabla('plf_planificacion', array('plf_estado' => 1, 'DATE(plf_fecha_registro) >=' => $fecha_ini, 'DATE(plf_fecha_registro) <=' => $fecha_fin));
            foreach ($tabla as $key => $value) {
                $html .= '<tr>';
                $html .= '<td>' . $value['plf_id'] . '</td>';
                $html .= '<td><label>' . formatear_fecha('d-m-Y', $value['plf_fecha_inicio']) . '</label></td>';
                $html .= '<td><label>' . formatear_fecha('d-m-Y', $value['plf_fecha_fin']) . '</label></td>';
                $html .= '<td><label>' . $value['plf_concepto'] . '</label></td>';
                $html .= '<td><div class="tools"><div class="btn-group"><button class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button>';
                $html .= '<button class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button><ul class="dropdown-menu">';
                $html .= '<li><a href="' . base_url('proyectos/procesos/ver_planificacion') . '/' . $value['plf_id'] . '"><span class="icon16 minia-icon-search"> Ver Detalles</span></a></li>';
                $html .= '<li><a target="_blank" href="' . base_url('proyectos/procesos/reporte_planificacion_produccion') . '/' . $value['plf_id'] . '"><span class="icomoon-icon-printer-3"> Exportar a Excel</span></a></li>';
                $html .= '<li><a target="_blank" href="' . base_url('proyectos/procesos/explosion_materiales') . '/0/' . $value['plf_id'] . '"><span class="icomoon-icon-printer-3"> Explosión de Mat.</span></a></li>';
                $html .= '</ul></div></div></td></tr>';
            }
            echo $html;
        } else {
            $data['titulo_personal'] = "Planificación de Producción";
            $this->_cargarvista($data);
        }
    }

    public function ver_planificacion($plf_id) {
        satelite_validar();
        $data['planificacion'] = $this->proyecto_model->get_reporte_planificacion(array('plf_id' => $plf_id));
        $data['titulo_personal'] = "Planificación de Producción";
        $this->_cargarvista($data);
    }

    /**
    * @author Raul Escalante
    * @since  Dic/2019
    * Descripcion: Agendar una planificacion y realiza la explosion de materiales insertando una reqx de compra para los materiales faltantes y una orden de produccion para productos intermedios
    */
    public function agregar_planificacion(){
        satelite_validar();
        if ($_POST) {
            $decimal = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
            $post_array = $this->input->post();
            $ordenes_id = array();
            $configuracion =  json_decode($this->gsatelite->get_parametro('SYS_PLANIFICACION_PRODUCCION'), true);
            $txt_fecha_ini = $post_array['txt_fecha_ini'];
            $txt_fecha_fin = $post_array['txt_fecha_fin'];
            $txt_concepto  = $post_array['txt_concepto'];
            $plf_array = array(
                'plf_id_usu' => $this->tank_auth->get_user_id(),
                'plf_fecha_registro' => date('Y-m-d H:i:s'), 
                'plf_fecha_inicio' => formatear_fecha('Y-m-d', $txt_fecha_ini),
                'plf_fecha_fin' => formatear_fecha('Y-m-d', $txt_fecha_fin),
                'plf_concepto' => trim($txt_concepto),
                'plf_estado' => 1,
                'plf_usu_creacion' => $this->tank_auth->get_user_id(),
                'plf_fecha_creacion' => date('Y-m-d H:i:s'),
                'plf_usu_modificacion' => $this->tank_auth->get_user_id(),
                'plf_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $plf_id = $this->gsatelite->ingresar('plf_planificacion', $plf_array);
            if ($plf_id > 0) {
                $id_art = $post_array['id_art'];
                $id_cva = $post_array['id_cva'];
                $ctdad_prod = $post_array['ctdad_producir'];
                $last_ord = $post_array['last_ord'];
                $inv_proce = $post_array['inv_proce'];
                $inv_act = $post_array['inv_act'];
                $last_prod = $post_array['last_prod'];
                $last_date = $post_array['last_date'];
                $prom_1 = $post_array['prom_1'];
                $prom_2 = $post_array['prom_2'];
                $prom_3 = $post_array['prom_3'];
                $prom_6 = $post_array['prom_6'];
                $prom_12 = $post_array['prom_12'];
                $alc_act = $post_array['alc_act'];
                $alc_proy = $post_array['alc_proy'];
                $vta_proy3 = $post_array['vta_proy3'];
                $vta_proy6 = $post_array['vta_proy6'];
                $chk_producir = $post_array['chk_producir'];
                for ($i = 0; $i < count($id_art); $i++) {
                    if ($chk_producir[$i] > 0) {
                        $dpf_array = array(
                            'dpf_id_plf' => $plf_id, 
                            'dpf_id_art' => $id_art[$i], 
                            'dpf_id_cva' => $id_cva[$i],
                            'dpf_cantidad_producir' => $ctdad_prod[$i], 
                            'dpf_inventario_op_anterior' => is_numeric($last_ord[$i]) ? $last_ord[$i] : NULL, 
                            'dpf_inventario_proceso' => ($inv_proce[$i] > 0) ? $inv_proce[$i] : NULL, 
                            'dpf_inventario_actual' => $inv_act[$i], 
                            'dpf_ultima_produccion' => is_numeric($last_prod[$i]) ? $last_prod[$i] : NULL, 
                            'dpf_fecha_produccion' => ($last_date[$i] != "---") ? formatear_fecha('Y-m-d', $last_date[$i]) : NULL, 
                            'dpf_promedio_venta1' => $prom_1[$i], 
                            'dpf_promedio_venta2' => $prom_2[$i], 
                            'dpf_promedio_venta3' => $prom_3[$i], 
                            'dpf_promedio_venta4' => $prom_6[$i],
                            'dpf_promedio_venta5' => $prom_12[$i],
                            'dpf_alcance_actual' => $alc_act[$i],
                            'dpf_alcance_proyectado' => $alc_proy[$i],
                            'dpf_venta_proyectada1' => $vta_proy3[$i],
                            'dpf_venta_proyectada2' => $vta_proy6[$i],
                            'dpf_producir' => $chk_producir[$i],
                            'dpf_estado' => 1,
                            'dpf_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dpf_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dpf_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dpf_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $dpf_id = $this->gsatelite->ingresar('dpf_detalle_planificacion', $dpf_array);
                        //Orden de produccion para el producto
                        $cod_act = $this->proyecto_model->generar_codigo_validar(array('ord_id_tio' => $configuracion['TIPO_ORDEN']));
                        $new_num = ($cod_act[0]['codigos'] > 0) ? ($cod_act[0]['codigos'] + 1) : 1;
                        $prefijo = $this->gsatelite->get_campo('tio_tipo_orden', 'tio_prefijo', array('tio_id' => $configuracion['TIPO_ORDEN']));
                        $new_cod = $prefijo . $new_num;
                        $ord_array = array(
                            'ord_id_cli' => $configuracion['CLIENTE'], 
                            'ord_id_tio' => $configuracion['TIPO_ORDEN'],
                            'ord_codigo' => $new_cod,
                            'ord_fecha' => date('Y-m-d H:i:s'),
                            'ord_concepto' => 'Orden de Producción generada por Planificación',
                            'ord_estado' => 1,
                            'ord_usu_creacion' => $this->tank_auth->get_user_id(),
                            'ord_fecha_creacion' => date('Y-m-d H:i:s'),
                            'ord_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'ord_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $ord_id_prod = $this->gsatelite->ingresar('ord_orden', $ord_array);
                        $axo_array = array(
                            'axo_id_ord' => $ord_id_prod,
                            'axo_id_art' => $id_art[$i],
                            'axo_id_cva' => $id_cva[$i],
                            'axo_cantidad' => number_format($ctdad_prod[$i], $decimal, '.', ''),
                            'axo_estado' => 1,
                            'axo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'axo_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'axo_usu_creacion' => $this->tank_auth->get_user_id(),
                            'axo_fecha_creacion' => date('Y-m-d H:i:s')
                        );
                        $axo_id = $this->gsatelite->ingresar('axo_articuloxorden', $axo_array);
                        if ($configuracion['AUTOMATICO'] > 0) {
                            $this->automatic_configs($ord_id_prod);
                        }
                        $ordenes_id[] = $ord_id_prod;
                    }
                }
                $req_compras = array();
                $id_art_mat = $post_array['id_art_mat'];
                $id_cva_mat = $post_array['id_cva_mat'];
                $ctdad_disp = $post_array['ctdad_disp'];
                $ctdad_falt = $post_array['ctdad_falt'];
                $ctdad_rexi = $post_array['ctdad_requi'];
                $tipo_orden = $post_array['tipo_orden'];
                $do_solicit = $post_array['solicitar'];
                for ($i = 0; $i < count($id_art_mat); $i++) {
                    $dex_array = array(
                        'dex_id_plf' => $plf_id,
                        'dex_id_art' => $id_art_mat[$i],
                        'dex_id_cva' => $id_cva_mat[$i],
                        'dex_cantidad_requerida' => $ctdad_rexi[$i],
                        'dex_cantidad_existencia' => $ctdad_disp[$i],
                        'dex_cantidad_faltante' => $ctdad_falt[$i],
                        'dex_tipo' => 3,
                        'dex_estado' => 1,
                        'dex_solicitar' => $do_solicit[$i],
                        'dex_usu_creacion' => $this->tank_auth->get_user_id(),
                        'dex_fecha_creacion' => date('Y-m-d H:i:s'),
                        'dex_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dex_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $dex_id = $this->gsatelite->ingresar('dex_detalle_explosion', $dex_array);
                    if ($tipo_orden[$i] == 'com' && $do_solicit[$i] > 0) {
                        $req_compras[$i]['art_id'] = $id_art_mat[$i];
                        $req_compras[$i]['cva_id'] = $id_cva_mat[$i];
                        $req_compras[$i]['cantid'] = ceil(number_format($ctdad_falt[$i], $decimal, '.', ''));
                        $req_compras[$i]['dex_id'] = $dex_id;
                    } elseif ($tipo_orden[$i] == 'pro' && $do_solicit[$i] > 0) {
                        //Solo se crea la orden de produccion para productos intermedios
                        $cod_act = $this->proyecto_model->generar_codigo_validar(array('ord_id_tio' => $configuracion['TIPO_ORDEN']));
                        $new_num = ($cod_act[0]['codigos'] > 0) ? ($cod_act[0]['codigos'] + 1) : 1;
                        $prefijo = $this->gsatelite->get_campo('tio_tipo_orden', 'tio_prefijo', array('tio_id' => $configuracion['TIPO_ORDEN']));
                        $new_cod = $prefijo . $new_num;
                        $ord_array = array(
                            'ord_id_cli' => $configuracion['CLIENTE'], 
                            'ord_id_tio' => $configuracion['TIPO_ORDEN'],
                            'ord_codigo' => $new_cod,
                            'ord_fecha' => date('Y-m-d H:i:s'),
                            'ord_concepto' => 'Orden para Productos Intermedios por Planificación de Producción',
                            'ord_estado' => 1,
                            'ord_usu_creacion' => $this->tank_auth->get_user_id(),
                            'ord_fecha_creacion' => date('Y-m-d H:i:s'),
                            'ord_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'ord_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $ord_id = $this->gsatelite->ingresar('ord_orden', $ord_array);
                        $this->gsatelite->actualizar_array('dex_detalle_explosion', array('dex_id_ord' => $ord_id, 'dex_tipo' => 2), array('dex_id' => $dex_id));
                        $axo_array = array(
                            'axo_id_ord' => $ord_id,
                            'axo_id_art' => $id_art_mat[$i],
                            'axo_id_cva' => $id_cva_mat[$i],
                            'axo_cantidad' => number_format($ctdad_falt[$i], $decimal, '.', ''),
                            'axo_estado' => 1,
                            'axo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'axo_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'axo_usu_creacion' => $this->tank_auth->get_user_id(),
                            'axo_fecha_creacion' => date('Y-m-d H:i:s')
                        );
                        $axo_id = $this->gsatelite->ingresar('axo_articuloxorden', $axo_array);
                        if ($configuracion['AUTOMATICO'] > 0) {
                            $this->automatic_configs($ord_id);
                        }
                    }
                }
                if (count($req_compras) > 0) {
                    $flujo = json_decode($this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO'), true);

                                $this->db->where('rxi_id_flu', $flujo['REQ_COMP']);
                    $num_actu = $this->inventario_model->num_max_requi();
                    
                    $cod_req = generar_codigo_cor(($num_actu[0]['maximo'] + 1), 5);
                    $concepto = 'Requisición de compras por Planificación de Producción';
                    $concepto .= (count($ordenes_id) > 1) ? ' de varios artículos' : '';
                    $rxi_array = array(
                        'rxi_id_usu_solicita' => $this->tank_auth->get_user_id(),
                        'rxi_id_flu' => $flujo['REQ_COMP'], 
                        'rxi_numero' => $cod_req,
                        'rxi_id_ord' => (count($ordenes_id) == 1) ? $ordenes_id[0] : null,
                        'rxi_descripcion' => $concepto,
                        'rxi_tipo' => 1,
                        'rxi_fecha' => date('Y-m-d H:i:s'),
                        'rxi_estado' => 1,
                        'rxi_usu_creacion' => $this->tank_auth->get_user_id(),
                        'rxi_fecha_creacion' => date('Y-m-d H:i:s'),
                        'rxi_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rxi_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $rxi_id = $this->gsatelite->ingresar('rxi_requisicion_inventario', $rxi_array);
                    if ($rxi_id > 0) {                    
                        $primer_paso = $this->inventario_model->get_primer_paso_flujo($flujo['REQ_COMP']);
                        if (count($primer_paso) > 0) {
                            $seguimiento_requisicion = array(
                                'sgr_id_rxi' => $rxi_id,
                                'sgr_id_psf' => $primer_paso[0]['psf_id'],
                                'sgr_id_usu' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                                'sgr_estado' => 1,
                                'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_creacion' => date('Y-m-d h:i:s'),
                                'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                            );
                            $id_detalle = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);
                        }
                        foreach ($req_compras as $key => $value) {                    
                            $dri_array = array(
                                'dri_id_rxi' => $rxi_id, 
                                'dri_id_art' => $value['art_id'],
                                'dri_id_cva' => $value['cva_id'],
                                'dri_cantidad' => $value['cantid'],
                                'dri_estado' => 1,
                                'dri_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dri_fecha_modificacion' => date('Y-m-d H:i:s'),
                                'dri_usu_creacion' => $this->tank_auth->get_user_id(),
                                'dri_fecha_creacion' => date('Y-m-d H:i:s')
                            );
                            $dri_id = $this->gsatelite->ingresar('dri_detalle_requisicion_inventario', $dri_array);
                            $this->gsatelite->actualizar_array('dex_detalle_explosion', array('dex_id_rxi' => $rxi_id, 'dex_tipo' => 1), array('dex_id' => $value['dex_id']));
                        }     
                    }               
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Planificación de Producción", 'texto_alerta' => "El registro se ingresó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "No se pudo guardar el registro");
            }
            $this->session->set_flashdata($alerta);
            redirect('proyectos/procesos/planificacion_produccion');
        } else {
                     $this->db->group_by('tia_id');
                     $this->db->join('art_articulo', 'art_id_tia = tia_id');
            $categ = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo}-{tia_nombre}', '', array('art_estado' => 1,'tia_aplica_tipo_venta' => 1, 'tia_estado'=>1), null, null, null, true);
            $bodeg = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, null, null, true);
            $data['categorias'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $categ);
            $data['bodegas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $bodeg);
            $data['titulo_personal'] = "Planificación";
            $this->_cargarvista($data);
        }
    }

    /**
    * @author Raul Escalante
    * @since  Dic/2019
    * Descripcion: Obtiene los articulos de una categoria especifica
    */
    public function get_articulos_tia(){
        if ($_POST) {
            $select = '<option value=""></option>';
            $incluida = $this->input->post('tia_id');
            $actuales = (is_array($this->input->post('select'))) ? $this->input->post('select') : array();

                         $this->db->where_in('art_id_tia', $incluida);
                         $this->db->join('tia_tipo_articulo', 'art_id_tia = tia_id');
            $articulos = $this->gsatelite->get_tabla('art_articulo', array('art_estado' => 1, 'tia_estado' => 1));
            foreach ($articulos as $key => $value) {
                $selected = (in_array($value['art_id'], $actuales)) ? 'selected' : '';
                $select .= '<option ' . $selected . ' value="' . $value['art_id'] .'" >' . $value['art_codigo'] .  ' - ' .  $value['art_nombre'] . '</option>';
            }
            echo trim($select);
            die();
        }
    }

    /**
    * @author Raul Escalante
    * @since  Dic/2019
    * Descripcion: Obtiene el detalle de planificacion para los articulos filtrados
    */
    public function get_planificacion(){
        if ($_POST) {
            $promedios = array();
            $html = "";
            $having = NULL;
            $decimal = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
            $articulos = $this->input->post('articulo');
            $categoria = $this->input->post('categoria');
            $bodegas = $this->input->post('bodegas');
            $stock = $this->input->post('stock');
            if (is_array($categoria) && count($categoria) > 0) {
                $where_categoria = implode(',', $categoria);
                $where["tia_id IN ($where_categoria)"] = NULL;
            }
            if (is_array($articulos) && count($articulos) > 0) {    
                $where_articulos = implode(',', $articulos);
                $where["art_id IN ($where_articulos)"] = NULL;
            }
            if (is_array($bodegas) && count($bodegas) > 0) {
                $where_bodegas = implode(',', $bodegas);
            }else{
                $where_bodegas = NULL;
            }
            if ($stock > 0) {
                $having = 'inv_actual < art_stock_seguridad';
            }
            $productos = $this->proyecto_model->get_datos_producto_plan($where, $where_bodegas, $having);
            if (count($productos) > 0) {
                $meses = array(12,6,3,2,1);
                $hoy = date('Ym');
                $i = 0;
                foreach ($productos as $key => $value) {
                    $vta_proy3 = $vta_proy6 = $avg3 = $avg6 = 0;
                    $en_proceso = $this->proyecto_model->get_producto_plan_proceso($value['art_id'], $value['cva_id']);
                    $inv_proces = (count($en_proceso) > 0) ? $en_proceso[0]['en_proceso'] : 0;
                    if ($en_proceso[0]['ultima_ord'] != '') {
                        $last_orden = $this->proyecto_model->get_last_ord_plan(array('ord_id'=>$en_proceso[0]['ultima_ord'], 'axo_id_art'=>$value['art_id'], 'axo_id_cva'=>$value['cva_id']));
                        $last_ord = $last_orden[0]['ord_codigo'];
                        $last_ord_id = $last_orden[0]['ord_id'];
                        $last_produc = number_format($last_orden[0]['axo_cantidad'], $decimal, '.', '');
                        $last_fecha = formatear_fecha('d-m-Y', $last_orden[0]['ord_fecha']);
                    } else {
                        $last_ord = $last_produc = $last_fecha = $last_ord_id = "---";
                    }
                    foreach ($meses as $k2 => $mes) {
                        $where_prom = array("def_id_art" => $value["art_id"], "fac_fecha_fact >= DATE_ADD(CURDATE(),INTERVAL -$mes MONTH)" => NULL);
                        $prom = $this->proyecto_model->get_prom_fact_prod_plan($where_prom);
                        $promedios[$mes] = number_format($prom[0]['promedio'], $decimal, '.', '');
                    }
                    for ($j = 1; $j < 4 ; $j++) { 
                        $periodo = date('Ym', strtotime($hoy . "+ $j month"));
                        $where_proy = array('pyv_id_art' => $value["art_id"], 'pyv_periodo' => $periodo);
                        $proyecc = $this->proyecto_model->get_prom_proy_prod_plan($where_proy);
                        $avg3 += (empty($proyecc)) ? 0 : $proyecc[0]['cantidad'];
                    }
                    for ($k = 1; $k < 7 ; $k++) { 
                        $periodo = date('Ym', strtotime($hoy . "+ $k month"));
                        $where_proy = array('pyv_id_art' => $value["art_id"], 'pyv_periodo' => $periodo);
                        $proyecc = $this->proyecto_model->get_prom_proy_prod_plan($where_proy);
                        $avg6 += (empty($proyecc)) ? 0 : $proyecc[0]['cantidad'];
                    }
                    $vta_proy3 = $avg3 / 3;
                    $vta_proy6 = $avg6 / 6;
                    $ctdad_produc = number_format((($value['art_stock_seguridad'] + $vta_proy3) - $value['inv_actual']), $decimal, '.', '');
                    $alcance_actual = ($promedios[1] != 0) ? ($value['inv_actual'] / $promedios[1]) : 0 ;
                    $alcance_proyectado = ($promedios[1] != 0) ? (($value['inv_actual'] + $inv_proces + $ctdad_produc) / $promedios[1]) : 0 ;
                    $html .= '<tr class="produccion" id="tr_' . $i . '">';
                    $html .= '<td><input type="hidden" name="id_tia[]" value="'.$value['tia_id'].'"><label style="text-align: center;">'.$value['tia_nombre']. '</label></td>';
                    $html .= '<td><input type="hidden" name="id_art[]" value="'.$value['art_id'].'" class="article">';
                    $html .= '<label style="text-align: center;">'.$value['art_codigo'].' - ' . $value['art_nombre'] . '</label></td>';
                    $html .= '<td><input type="hidden" name="id_cva[]" value="' . $value['cva_id'] . '"><label style="text-align: center;">' . $value['mep_nombre'] . '</label></td>';
                    $html .= '<td><input type="text" name="ctdad_producir[]" class="soloDecimales quantity" value="'; 
                    $html .= ($ctdad_produc > 0) ? number_format($ctdad_produc, $decimal, '.', '') : number_format(0, $decimal, '.', ''); 
                    $html .= '" style="text-align: right;width:100%;"></td>';
                    $html .= '<td><input type="hidden" name="chk_producir[]" value="1" id="chkProducir_' . $i . '" class="producirse" data-art="' . $value['art_id'] . '"/>';
                    $html .= '<input type="checkbox" id="chk_' . $i . '" class="nostyle chk_producir" data-id="' . $i . '" checked/></td>';
                    $html .= '<td><input type="hidden" name="inv_act[]" value="' . number_format($value['inv_actual'],$decimal, '.', '') . '">';
                    $html .= '<label style="text-align: right;">' . number_format($value['inv_actual'],$decimal) . '</label></td>';
                    $html .= '<td><input type="hidden" name="inv_proce[]" value="' . number_format($inv_proces, $decimal, '.', '') . '">';
                    $html .= '<label style="text-align: right;">' . number_format($inv_proces, $decimal) . '</label></td>';
                    $html .= '<td><input type="hidden" name="last_ord[]" value="' . $last_ord_id . '"><label style="text-align: center;">' . $last_ord . '</label></td>';
                    $html .= '<td><input type="hidden" name="last_prod[]" value="' . $last_produc . '"><label style="text-align: right;">' . $last_produc . '</label></td>';
                    $html .= '<td><input type="hidden" name="last_date[]" value="' . $last_fecha . '"><label style="text-align: center;">' . $last_fecha . '</label></td>';
                    $html .= '<td><input type="hidden" name="prom_12[]" value="' . $promedios[12] . '"><label style="text-align: right;">' . $promedios[12] . '</label></td>';
                    $html .= '<td><input type="hidden" name="prom_6[]" value="' . $promedios[6] . '"><label style="text-align: right;">' . $promedios[6] . '</label></td>';
                    $html .= '<td><input type="hidden" name="prom_3[]" value="' . $promedios[3] . '"><label style="text-align: right;">' . $promedios[3] . '</label></td>';
                    $html .= '<td><input type="hidden" name="prom_2[]" value="' . $promedios[2] . '"><label style="text-align: right;">' . $promedios[2] . '</label></td>';
                    $html .= '<td><input type="hidden" name="prom_1[]" value="' . $promedios[1] . '"><label style="text-align: right;">' . $promedios[1] . '</label></td>';
                    $html .= '<td><input type="hidden" name="alc_act[]" value="' . number_format($alcance_actual, $decimal, '.', '') . '">';
                    $html .= '<label style="text-align: right;">' . number_format($alcance_actual, $decimal) . '</label></td>';
                    $html .= '<td><input type="hidden" name="alc_proy[]" value="' . number_format($alcance_proyectado, $decimal, '.', '') . '">';
                    $html .= '<label style="text-align: right;">' . number_format($alcance_proyectado, $decimal) . '</label></td>';
                    $html .= '<td><input type="hidden" name="vta_proy3[]" value="' . number_format($vta_proy3, $decimal, '.', '') . '">';
                    $html .= '<label style="text-align: right;">' . number_format($vta_proy3, $decimal) . '</label></td>';
                    $html .= '<td><input type="hidden" name="vta_proy6[]" value="' . number_format($vta_proy6, $decimal, '.', '') . '">';
                    $html .= '<label style="text-align: right;">' . number_format($vta_proy6, $decimal) . '</label></td>';
                    $html .= '</tr>';
                    $i++;
                }
            } else{
                $html .= '<tr><td colspan="19" style="font-weight: bold; text-align: center;">﻿﻿No se Encontrarón Registros. Por Favor Revise los Filtros Aplicados</td></tr>';
            }
            echo $html;
            die();
        }
    }

    /**
    * @author Raul Escalante
    * @since  Dic/2019
    * Descripcion: Realiza la explosion de materiales de los articulos filtrados
    */
    public function get_explosion(){
        $string = "";
        $valido = 0;
        $decimal = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $articulos = $this->input->post('articulos');
        $pro_inter = ($this->input->post('intermedios') != "") ? $this->input->post('intermedios') : null;
        $mat_prima = ($this->input->post('materiales') != "") ? $this->input->post('materiales') : null;
        $arrayTmp = array();
        if (is_array($articulos) && count($articulos) > 0) {
            foreach ($articulos as $key => $value) {
                $arrayOriginal = $this->proyecto_model->get_explosion_plan($value['art'], $value['ctd'], $pro_inter, $mat_prima); 
                foreach ($arrayOriginal as $key2 => $elemento) {
                    if (array_key_exists($elemento['array_key'], $arrayTmp)) {
                        $arrayTmp[$elemento['array_key']]['total_requerido'] += $elemento['total_requerido'];
                    } else {
                        $arrayTmp[$elemento['array_key']] = array(
                            'mpa_id_art_materia'    => $elemento['mpa_id_art_materia'],
                            'mpa_id_cva'            => $elemento['mpa_id_cva'],
                            'material_tia'          => $elemento['material_tia'],
                            'art_codigo'            => $elemento['art_codigo'],
                            'material_nombre'       => $elemento['art_nombre'],
                            'material_presentacion' => $elemento['material_presentacion'],
                            'total_requerido'       => $elemento['total_requerido'],
                            'produccion'            => $elemento['art_produccion'],
                            'disponible'            => $elemento['disponible']
                        );
                    }
                }
            }
            if (count($arrayTmp > 0)) {
                $i = 0;
                foreach ($arrayTmp as $key => $value) {
                    $valido++;
                    $faltan = (($value['total_requerido'] - $value['disponible']) > 0) ? number_format(($value['total_requerido'] - $value['disponible']), $decimal, '.', '') : 0;
                    $tipo = 'Inventario';
                    $tipo_num = 3;
                    if ($faltan > 0) {
                        $tipo = ($value['produccion'] > 0) ? 'Producción' : 'Compras';
                        $tipo_num = ($value['produccion'] > 0) ? 2 : 1;
                    }
                    $pedir = ($faltan > 0) ? $faltan : number_format($value['total_requerido'], $decimal, '.','');
                    $string .= '<tr>';
                    $string .= '<td><input type="hidden" name="id_art_mat[]" value="' . $value['mpa_id_art_materia'] . '"><label>' . $value['material_tia'] . '</label></td>';
                    $string .= '<td><input type="hidden" name="id_cva_mat[]" value="' . $value['mpa_id_cva'] . '">';
                    $string .= '<label>' . $value['art_codigo'] . '</label></td>';
                    $string .= '<td><label>' . $value['material_nombre'] . '</label></td>';
                    $string .= '<td><label>' . $value['material_presentacion'] . '</label></td>';
                    $string .= '<td><input type="hidden" name="ctdad_requi[]" value="' . number_format($value['total_requerido'], $decimal, '.', '') . '">';
                    $string .= '<label style="text-align: right;">' . number_format($value['total_requerido'], $decimal) . '</label></td>';
                    $string .= '<td><input type="hidden" name="ctdad_disp[]" value="' . number_format($value['disponible'], $decimal, '.', '') . '">';
                    $string .='<label style="text-align: right;">' . number_format($value['disponible'], $decimal) . '</label></td>';
                    $string .= '<td><input type="hidden" name="ctdad_falt[]" value="' . number_format($faltan, $decimal, '.', '') . '">';
                    $string .= '<label style="text-align: right;">' . number_format($faltan, $decimal) . '</label></td>';
                    $string .= '<td><input type="hidden" name="tipo_orden[]" value="' . substr(strtolower($tipo), 0,3)  . '"><label>' . $tipo . '</label></td>';
                    $string .= '<td><input type="checkbox" class="do_rxi nostyle" data-tipo="' . $tipo_num . '" data-id="' . $i . '" checked>';
                    $string .= '<input type="hidden" name="solicitar[]" id="solicitar_' . $i . '" value="1"></td>';
                    $string .= '</tr>';
                    $i++;
                }
            }
            $arreglo = array('tabla' => $string, 'valido' => $valido);
            echo json_encode($arreglo);
            die();
        }
    }
    
    public function programacion_produccion(){
        satelite_validar();
        if ($_POST) {
            $html = "";
            $post_array = $this->input->post();
            $fecha_ini = formatear_fecha('Y-m-d', $post_array['fecha_ini']);
            $fecha_fin = formatear_fecha('Y-m-d', $post_array['fecha_fin']);
            $tabla = $this->gsatelite->get_tabla('ppd_programacion_produccion', array('ppd_estado' => 1, 'DATE(ppd_fecha_registro) >=' => $fecha_ini, 'DATE(ppd_fecha_registro) <=' => $fecha_fin));
            foreach ($tabla as $key => $value) {
                $html .= '<tr>';
                $html .= '<td>' . $value['ppd_id'] . '</td>';
                $html .= '<td><label>' . formatear_fecha('d-m-Y', $value['ppd_fecha_inicio']) . '</label></td>';
                $html .= '<td><label>' . formatear_fecha('d-m-Y', $value['ppd_fecha_fin']) . '</label></td><td><label>' . $value['ppd_concepto'] . '</label></td>';
                $html .= '<td><div class="tools"><div class="btn-group"><button class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button>';
                $html .= '<button class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button><ul class="dropdown-menu">';
                $html .= '<li><a href="' . base_url('proyectos/procesos/agregar_programacion_ver') . '/' . $value['ppd_id'] . '" title="Ver"><span class="icon16 minia-icon-search"></span> Ver</a></li>';
                $html .= '<li><a target="_blank" href="' . base_url('proyectos/procesos/reporte_programacion_produccion') . '/' . $value['ppd_id'] . '"><span class="icomoon-icon-printer-3"></span> Exportar a Excel</a></li>';
                $html .= '<li><a class="rep_op" href="' . base_url('proyectos/procesos/reporte_programacion_detallada') . '/' . $value['ppd_id'] . '"><span class="icomoon-icon-printer-3"></span> Program. Detallada</a></li>';
                $html .= '<li><a target="_blank" href="' . base_url('proyectos/procesos/explosion_materiales') . '/1/' . $value['ppd_id'] . '"><span class="icomoon-icon-printer-3"> Explosión de Mat.</span></a></li>';
                $html .= '</ul></div></div></td></tr>';
            }
            echo $html;
        } else {
            $data['titulo_personal'] = "Programación de Producción";
            $this->_cargarvista($data);
        }
    }

    /**
    * @author Raul Escalante
    * @since  Dic/2019
    * Descripcion: Agenda la ejecucion de las ordenes de produccion asignandole maquina y operario
    */
    public function agregar_programacion(){
        satelite_validar();
        $decimal = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);        
        if ($_POST) {
            $post_array = $this->input->post();
            $txt_fecha_ini = $post_array['txt_fecha_ini'];
            $txt_fecha_fin = $post_array['txt_fecha_fin'];
            $txt_concepto  = $post_array['txt_concepto'];
            $ppd_array = array(
                'ppd_id_usu' => $this->tank_auth->get_user_id(),
                'ppd_fecha_registro' => date('Y-m-d H:i:s'), 
                'ppd_fecha_inicio' => formatear_fecha('Y-m-d', $txt_fecha_ini),
                'ppd_fecha_fin' => formatear_fecha('Y-m-d', $txt_fecha_fin),
                'ppd_concepto' => trim($txt_concepto),
                'ppd_estado' => 1,
                'ppd_usu_creacion' => $this->tank_auth->get_user_id(),
                'ppd_fecha_creacion' => date('Y-m-d H:i:s'),
                'ppd_usu_modificacion' => $this->tank_auth->get_user_id(),
                'ppd_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $ppd_id = $this->gsatelite->ingresar('ppd_programacion_produccion', $ppd_array);
            if ($ppd_id > 0) {
                $id_ord = $post_array['ord'];
                $id_axo = $post_array['axo'];
                $id_tia = $post_array['tia'];
                $id_art = $post_array['art'];
                $id_cva = $post_array['cva'];
                $cntdad = $post_array['ctdad'];
                $priord = $post_array['prioridad'];
                $programar = $post_array['programar'];
                $ini_fecha = $post_array['ini_fecha'];
                $count = count($id_axo);
                $datos = $post_array['datos'];
                for ($i = 0; $i < $count; $i++) { 
                    if ($programar[$i] > 0 && $ini_fecha[$i] != "") {     
                        $dpp_array = array(
                            'dpp_id_ppd' => $ppd_id, 
                            'dpp_id_art' => $id_art[$i],
                            'dpp_id_cva' => $id_cva[$i],
                            'dpp_id_ord' => $id_ord[$i],
                            'dpp_fecha_inicio' => formatear_fecha('Y-m-d', $ini_fecha[$i]),
                            'dpp_prioridad' => (is_numeric($priord[$i])) ? $priord[$i] : NULL,
                            'dpp_cantidad_orden' => $cntdad[$i],
                            'dpp_estado' => 1,
                            'dpp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dpp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dpp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dpp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $dpp_id = $this->gsatelite->ingresar('dpp_detalle_programacion_produccion', $dpp_array);
                        if ($dpp_id > 0) {
                            $datos_etapas = explode('#', $datos[$i]);
                            $count2 =  count($datos_etapas);
                            for ($j = 0; $j < $count2; $j++) { 
                                $json = json_decode($datos_etapas[$j], true);
                                $dpg_array = array(
                                    'dpg_id_dpp' => $dpp_id, 
                                    'dpg_id_etp' => $json['eta'],
                                    'dpg_id_maq' => ($json['maq'] > 0) ? $json['maq'] : null,
                                    'dpg_fecha'  => formatear_fecha('Y-m-d', $json['fec']),
                                    'dpg_horas'  => ($json['hor'] > 0) ? $json['hor']:null,
                                    'dpg_estado' => 1,
                                    'dpg_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'dpg_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'dpg_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'dpg_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                                $dpg_id = $this->gsatelite->ingresar('dpg_detalle_programacion', $dpg_array);
                                if ($dpg_id > 0 && is_array($json['ope'])) {
                                    foreach ($json['ope'] as $k => $v) {
                                        $dpo_array = array( //2021042911378 
                                            'dpo_id_dpg' => $dpg_id,
                                            'dpo_id_opr' => $v,
                                            'dpo_estado' => 1,
                                            'dpo_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'dpo_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'dpo_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'dpo_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );
                                        $dpo_id = $this->gsatelite->ingresar('dpo_detalle_programacion_operario', $dpo_array);
                                    }
                                }
                                $axo_array = array(
                                    'axo_fecha_ejecucion' => formatear_fecha('Y-m-d', $json['fec']),
                                    'axo_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'axo_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                                $resultado = $this->gsatelite->actualizar_array('axo_articuloxorden', $axo_array, array('axo_id' => $json['axo']));
                            }
                        }   
                    }
                }
                $requix_inv = array();
                $requix_itr = array();
                $id_art_mat = $post_array['id_art_mat'];
                $bod_rx_inv = $post_array['slc_bod_mat_pr'];
                $bod_rx_int = $post_array['slc_bod_inter'];
                $id_cva_mat = $post_array['id_cva_mat'];
                $ctdad_disp = $post_array['ctdad_disp'];
                $ctdad_falt = $post_array['ctdad_falt'];
                $tipo_orden = $post_array['tipo_orden'];
                $do_solicit = $post_array['solicitar'];
                $ctdad_requi = $post_array['ctdad_requi'];
                $conteo = count($id_art_mat);
                for ($i = 0; $i < $conteo; $i++) { 
                    $edp_array = array(
                        'edp_id_ppd' => $ppd_id,
                        'edp_id_cva' => $id_cva_mat[$i],
                        'edp_id_art' => $id_art_mat[$i],
                        'edp_cantidad_requerida' => $ctdad_requi[$i],
                        'edp_cantidad_existencia' => $ctdad_disp[$i],
                        'edp_cantidad_faltante' => $ctdad_falt[$i],
                        'edp_tipo' => 1,
                        'edp_solicitar' => $do_solicit[$i],
                        'edp_estado' => 1,
                        'edp_usu_creacion' => $this->tank_auth->get_user_id(),
                        'edp_fecha_creacion' => date('Y-m-d H:i:s'),
                        'edp_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'edp_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $edp_id = $this->gsatelite->ingresar('edp_explosion_detalle_programacion', $edp_array);
                    if ($tipo_orden[$i] == 'inv' && $do_solicit[$i] > 0) {
                        $prod_intermedio = $this->gsatelite->get_campo('art_articulo', 'art_produccion', array('art_id' => $id_art_mat[$i]));
                        if ($prod_intermedio > 0) {
                            $requix_itr[$i]['art_id'] = $id_art_mat[$i];
                            $requix_itr[$i]['cva_id'] = $id_cva_mat[$i];
                            $requix_itr[$i]['cantid'] = number_format($ctdad_requi[$i], $decimal, '.', '');
                            $requix_itr[$i]['edp_id'] = $edp_id;
                        } else {
                            $requix_inv[$i]['art_id'] = $id_art_mat[$i];
                            $requix_inv[$i]['cva_id'] = $id_cva_mat[$i];
                            $requix_inv[$i]['cantid'] = number_format($ctdad_requi[$i], $decimal, '.', '');
                            $requix_inv[$i]['edp_id'] = $edp_id;
                        }                        
                    }
                }
                if (count($requix_inv) > 0) {
                    $flujo = json_decode($this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO'), true);
                                $this->db->where('rxi_id_flu', $flujo['REQ_INV']);
                    $num_actu = $this->inventario_model->num_max_requi();
                    $cod_req = generar_codigo_cor(($num_actu[0]['maximo'] + 1), 5);
                    $emp_id = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id' => $this->tank_auth->get_user_id()));
                    $rxi_array = array(
                        'rxi_id_bod' => $bod_rx_inv,
                        'rxi_id_usu_solicita' => $this->tank_auth->get_user_id(),
                        'rxi_id_emp' => $emp_id,
                        'rxi_id_flu' => $flujo['REQ_INV'], 
                        'rxi_numero' => $cod_req,
                        'rxi_descripcion' => 'Requisición de Inventario por Programación de Producción',
                        'rxi_justificacion' => 'Requisición de Inventario por Programación de Producción',
                        'rxi_tipo' => 1,
                        'rxi_fecha' => date('Y-m-d H:i:s'),
                        'rxi_estado' => 1,
                        'rxi_usu_creacion' => $this->tank_auth->get_user_id(),
                        'rxi_fecha_creacion' => date('Y-m-d H:i:s'),
                        'rxi_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rxi_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $rxi_id = $this->gsatelite->ingresar('rxi_requisicion_inventario', $rxi_array);
                    if ($rxi_id > 0) {
                        $primer_paso = $this->inventario_model->get_primer_paso_flujo($flujo['REQ_INV']);
                        if (count($primer_paso) > 0) {
                            $seguimiento_requisicion = array(
                                'sgr_id_rxi' => $rxi_id,
                                'sgr_id_psf' => $primer_paso[0]['psf_id'],
                                'sgr_id_usu' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                                'sgr_estado' => 1,
                                'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_creacion' => date('Y-m-d h:i:s'),
                                'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                            );
                            $id_detalle = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);
                        }
                        foreach ($requix_inv as $key => $value) {                    
                            $dri_array = array(
                                'dri_id_rxi' => $rxi_id, 
                                'dri_id_art' => $value['art_id'],
                                'dri_id_cva' => $value['cva_id'],
                                'dri_cantidad' => $value['cantid'],
                                'dri_estado' => 1,
                                'dri_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dri_fecha_modificacion' => date('Y-m-d H:i:s'),
                                'dri_usu_creacion' => $this->tank_auth->get_user_id(),
                                'dri_fecha_creacion' => date('Y-m-d H:i:s')
                            );
                            $dri_id = $this->gsatelite->ingresar('dri_detalle_requisicion_inventario', $dri_array);
                            $this->gsatelite->actualizar_array('edp_explosion_detalle_programacion', array('edp_id_rxi' => $rxi_id, 'edp_tipo' => 3), array('edp_id' => $value['edp_id']));
                        }     
                    }
                }
                if (count($requix_itr) > 0) {
                    $flujo = json_decode($this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO'), true);
                                $this->db->where('rxi_id_flu', $flujo['REQ_INV']);
                    $num_actu = $this->inventario_model->num_max_requi();
                    $cod_req = generar_codigo_cor(($num_actu[0]['maximo'] + 1), 5);
                    $emp_id = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id' => $this->tank_auth->get_user_id()));
                    $rxi_array = array(
                        'rxi_id_bod' => ($bod_rx_int != "") ? $bod_rx_int : $bod_rx_inv,
                        'rxi_id_usu_solicita' => $this->tank_auth->get_user_id(),
                        'rxi_id_emp' => $emp_id,
                        'rxi_id_flu' => $flujo['REQ_INV'], 
                        'rxi_numero' => $cod_req,
                        'rxi_descripcion' => 'Requisición de Inventario por Programación de Producción',
                        'rxi_justificacion' => 'Requisición de Inv. Prod. Intermedios por Programación de Producción',
                        'rxi_tipo' => 1,
                        'rxi_fecha' => date('Y-m-d H:i:s'),
                        'rxi_estado' => 1,
                        'rxi_usu_creacion' => $this->tank_auth->get_user_id(),
                        'rxi_fecha_creacion' => date('Y-m-d H:i:s'),
                        'rxi_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rxi_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $rxi_id = $this->gsatelite->ingresar('rxi_requisicion_inventario', $rxi_array);
                    if ($rxi_id > 0) {
                        $primer_paso = $this->inventario_model->get_primer_paso_flujo($flujo['REQ_INV']);
                        if (count($primer_paso) > 0) {
                            $seguimiento_requisicion = array(
                                'sgr_id_rxi' => $rxi_id,
                                'sgr_id_psf' => $primer_paso[0]['psf_id'],
                                'sgr_id_usu' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                                'sgr_estado' => 1,
                                'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_creacion' => date('Y-m-d h:i:s'),
                                'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                            );
                            $id_detalle = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);
                        }
                        foreach ($requix_itr as $key => $value) {                    
                            $dri_array = array(
                                'dri_id_rxi' => $rxi_id, 
                                'dri_id_art' => $value['art_id'],
                                'dri_id_cva' => $value['cva_id'],
                                'dri_cantidad' => $value['cantid'],
                                'dri_estado' => 1,
                                'dri_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dri_fecha_modificacion' => date('Y-m-d H:i:s'),
                                'dri_usu_creacion' => $this->tank_auth->get_user_id(),
                                'dri_fecha_creacion' => date('Y-m-d H:i:s')
                            );
                            $dri_id = $this->gsatelite->ingresar('dri_detalle_requisicion_inventario', $dri_array);
                            $this->gsatelite->actualizar_array('edp_explosion_detalle_programacion', array('edp_id_rxi' => $rxi_id, 'edp_tipo' => 3), array('edp_id' => $value['edp_id']));
                        }     
                    }
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Programación de Producción", 'texto_alerta' => "El registro se ingresó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "No se pudo guardar el registro");
            }           
            $this->session->set_flashdata($alerta);
            redirect('proyectos/procesos/programacion_produccion');
        } else {
            $detalles = $this->get_detalle_programacion();
            $bodeg = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, null, null, true);
            $data['detalles'] = $detalles['detalles'];
            $data['category'] = $detalles['slc_tia'];
            $data['articulo'] = $detalles['slc_art'];
            $data['decimal'] = $decimal;
            $data['bodegas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $bodeg);
            $data['titulo_personal'] = "Programación";
            $this->_cargarvista($data);
        }
    }


    /**
    * @author Raul Escalante
    * @since  Dic/2019
    * Descripcion: Obtener la grid para programacion de produccion
    */
    public function get_detalle_programacion($flag = null, $categoria = null, $producto = null,$ex_datos =null){
        $respuesta = array();
        $where = null;
        if ($flag) {
            $categoria = $this->input->post('categoria');
            $producto = $this->input->post('articulo');
            if (is_array($categoria) && count($categoria) > 0) {
                $where_categoria = implode(',', $categoria);
                $where["tia_id IN ( $where_categoria )"] = NULL;
            }
            if (is_array($producto) && count($producto) > 0) {
               $where_producto = implode(',', $producto);
               $where["art_id IN ( $where_producto )"] = NULL;
            }
        }        
        //print_r($this->db->last_query());die();
        $detalles = $this->proyecto_model->get_detalles_prog($where);
        $data['detalles'] = $detalles;
        $data['decimal'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        if (count($detalles) > 0) {
            $tias_ids = array_unique(array_column($detalles, 'tia_id'));
            $arts_ids = array_unique(array_column($detalles, 'art_id'));
            $this->db->where_in('tia_id', $tias_ids);
            $categorias = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => 1), null, '', 'tia_id', true);
            $respuesta['slc_tia'] = str_replace('<option value="0">Seleccione</option>', '<option value="" ></option>', $categorias);
            $this->db->where_in('art_id', $arts_ids);
            $articulos = $this->gsatelite->get_dropdown('art_articulo', '{art_codigo} - {art_nombre}', '', array('art_estado' => 1), null, '', 'art_id', true);
            $respuesta['slc_art'] = str_replace('<option value="0">Seleccione</option>', '<option value="" ></option>', $articulos);
        }        
        $html = $this->load->view("proyectos/procesos/grid_programacion", $data, TRUE);
        $respuesta['detalles'] = $html;
        if ($flag) {
            echo json_encode($respuesta);
        } else {
            return $respuesta;
        }
    }

    

    /**
    * @author Raul Escalante
    * @since  Dic/2019
    * Descripcion: Obtiene las etapas de produccion de los articulos filtrados, los operarios y las maquinarias disponibles
    */
    public function get_etapas_art(){
        $producto = $this->input->post('art_id');
        $orden = $this->input->post('orden');
        $respuesta = array();        
                     $this->db->join('emp_empleado', 'opr_id_emp = emp_id');
        $operarios = $this->gsatelite->get_dropdown('opr_operario', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'opr_id', true);
                  $this->db->order_by('exo_orden');
                  $this->db->join('exo_etapaxarticulo_orden', 'etp_id = exo_id_etp');
                  $this->db->join('lop_lote_produccion', 'exo_id_lop = lop_id');
                  $this->db->join('axo_articuloxorden', 'axo_id = lop_id_axo');
        $etapas = $this->gsatelite->get_dropdown('etp_etapa', 'etp_nombre', '', array('etp_estado' => 1, 'axo_id_art' => $producto, 'axo_id_ord' => $orden), null, '', 'etp_id', true);
        
        $maquinas = $this->gsatelite->get_dropdown('maq_maquina', 'maq_nombre', '', array('maq_estado' => 1), null, '', 'maq_id', true);
        $respuesta['operarios'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value="" ></option>', $operarios);
        $respuesta['maquinas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value="" ></option>', $maquinas);
        $respuesta['etapas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value="" ></option>', $etapas);
        echo json_encode($respuesta);
    }

    /**
    * @author Raul Escalante
    * @since  Dic/2019
    * Descripcion: Obtiene las horas ya reservadas de la maquina seleccionada
    */
    public function get_datos_maquina(){
        $maquina = $this->input->post('maquina');
        $article = $this->input->post('article');
        $etapa = $this->input->post('etapa');
        $orden = $this->input->post('orden');
        $fecha = formatear_fecha('Y-m-d', $this->input->post('fecha'));
        $respuesta = array();
        $horas_usadas = $this->gsatelite->get_suma('dpg_detalle_programacion', 'dpg_horas', array('dpg_estado' => 1, 'dpg_id_maq' => $maquina, 'DATE(dpg_fecha)' => $fecha));
        $horas_maquina = $this->gsatelite->get_campo('maq_maquina', 'maq_hora', array('maq_id' => $maquina));
                        
                        //$this->db->join('etp_etapa', 'etp_id = eta_id_etp');
                        $this->db->join('exo_etapaxarticulo_orden', 'etp_id = exo_id_etp');
                        $this->db->join('lop_lote_produccion', 'exo_id_lop = lop_id');
                        $this->db->join('axo_articuloxorden', 'axo_id = lop_id_axo');
        $horas_etapas = $this->gsatelite->get_campo('etp_etapa', 'exo_duracion', array('exo_estado' => 1, 'axo_id_art' => $article, 'etp_id' => $etapa, 'axo_id_ord' => $orden));
        
        $respuesta['horas_etap'] = number_format($horas_etapas, 2, '.', '');
        $respuesta['horas_disp'] = number_format(($horas_maquina - $horas_usadas), 2, '.', '');
        echo json_encode($respuesta);
    }

    /**
    * @author Raul Escalante
    * @since  Dic/2019
    * Descripcion: Grid con las ordenes de produccion a las que se les hara control de calidad
    */
    public function control_calidad(){
        satelite_validar();
        if ($_POST) {
            $tabla = "";
            $fecha_ini = formatear_fecha('Y-m-d', $this->input->post('fecha_ini'));
            $fecha_fin = formatear_fecha('Y-m-d', $this->input->post('fecha_fin'));
                       $this->db->join('cli_cliente', 'cli_id = ord_id_cli');
            $ordenes = $this->gsatelite->get_tabla('ord_orden', array('ord_estado >' => 0, 'DATE(ord_fecha) >=' => $fecha_ini, 'DATE(ord_fecha) <=' => $fecha_fin));
            if (count($ordenes) > 0) {
                foreach ($ordenes as $key => $value) {
                    $cliente = ($value['cli_personeria'] == 2) ? $value['cli_apellido'] : $value['cli_nombre'] . ' ' . $value['cli_apellido'];
                    $estado = ($value['ord_estado'] > 1) ? 'Finalizado' : 'Activo';
                    $tabla .= '<tr><td>' . $value['ord_codigo'] . '</td><td>' . $cliente . '</td><td>' . formatear_fecha('d-m-Y', $value['ord_fecha']) . '</td>';
                    $tabla .= '<td>' . $value['ord_concepto'] . '</td><td>' . $estado . '</td><td style="text-align: center;"><div class="tools"><div class="btn-group">';
                    $tabla .= '<button class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button><button class="btn dropdown-toggle" data-toggle="dropdown">';
                    $tabla .= '<span class="caret"></span></button><ul class="dropdown-menu">';
                    if ($value['ord_estado'] < 2) {
                        $tabla .= '<li><a class="tipB" title="Pruebas de control de calidad" href="' . base_url("proyectos/procesos/pruebas_calidad/" . $value['ord_id']) . '">';
                        $tabla .= '<span aria-hidden="true" class="icomoon-icon-lab"> Pruebas realizadas</span></a></li>';
                    }
                    $tabla .= '<li><a class="tipB" target="_blank" title="Reporte de pruebas realizadas" href="' . base_url("proyectos/reportes/pruebas_control_calidad/" . $value['ord_id']) . '">';
                    $tabla .= '<span aria-hidden="true" class="silk-icon-checklist"> Reporte de pruebas</span></a></li>';
                    $tabla .= '</ul></div></div></td></tr>';
                }
            }
            echo $tabla;
            die();
        } else {
            $data['titulo_personal'] = "Control de Calidad";
            $this->_cargarvista($data);
        }        
    }

    /**
    * @author Raul Escalante
    * @since  Dic/2019
    * Descripcion: Grid con los controles de calidad realizados para una orden
    */
    public function pruebas_calidad($ord_id){
        satelite_validar();
        $pruebas = $this->gsatelite->get_tabla('ccr_control_calidad_orden', array('ccr_id_ord' => $ord_id));                   
                   $this->db->join('cli_cliente', 'cli_id = ord_id_cli');
        $ordenes = $this->gsatelite->get_tabla('ord_orden', array('ord_id' => $ord_id));
        $data['orden'] = $ordenes[0];
        $data['pruebas'] = $pruebas;
        $data['titulo_personal'] = "Pruebas de Calidad";
        $this->_cargarvista($data);        
    }

    /**
    * @author Raul Escalante
    * @since  Dic/2019
    * Descripcion: Agregar los resultados de una prueba de calidad
    */
    public function agregar_prueba($ord_id = null){
        satelite_validar();
        if ($_POST) {
            $post_array = $this->input->post();
            $orden      = $this->input->post('orden_id');
            $cliente    = $this->input->post('cliente_id');
            $fecha_test = $this->input->post('fecha_prueba');
            $hora_ini   = $this->input->post("hora_ini");
            $hora_fin   = $this->input->post("hora_fin");
            //DETALLES
            $articulo   = $this->input->post("articulo");
            $axo_id     = $this->input->post("axo");
            $fcc_id     = $this->input->post("fcc");
            $fca_id     = $this->input->post("fca");
            $resultado  = $this->input->post("resultado");
            $referencia = $this->input->post("referencia");
            $unidad     = $this->input->post("unidad");
            $comentario = $this->input->post("comentario");
            //ANEXOS
            $files      = $this->input->post('files');
            $id_actu    = $this->input->post('id_actu');
            $ruta       = $this->input->post('ruta');
            $carpeta    = $this->input->post("nombreCarpeta");
            $titulos    = $this->input->post("titulo_doc"); 
            $ccr_array = array(
                'ccr_id_usu' => $this->tank_auth->get_user_id(),
                'ccr_id_ord' => $orden,
                'ccr_fecha' => formatear_fecha('Y-m-d', $fecha_test),
                'ccr_hora_inicio' => formatear_fecha('H:i:s', $hora_ini),
                'ccr_hora_fin' => formatear_fecha('H:i:s', $hora_fin),
                'ccr_fecha_registro' => date('Y-m-d H:i:s'),
                'ccr_estado' => 1,
                'ccr_usu_creacion' => $this->tank_auth->get_user_id(),
                'ccr_fecha_creacion' => date('Y-m-d H:i:s'),
                'ccr_usu_modificacion' => $this->tank_auth->get_user_id(),
                'ccr_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $ccr_id = $this->gsatelite->ingresar('ccr_control_calidad_orden', $ccr_array);
            if ($ccr_id > 0) {
                $count = count($resultado);
                for ($i = 0; $i < $count; $i++) { 
                    $dci_array = array(
                        'dci_id_ccr' => $ccr_id,
                        'dci_id_fcc' => $fcc_id[$i],
                        'dci_id_axo' => $axo_id[$i],
                        'dci_valor' => $resultado[$i],
                        'dci_valor_referencia' => $referencia[$i],
                        'dci_comentario' => $comentario[$i],
                        'dci_estado' => 1,
                        'dci_usu_creacion' => $this->tank_auth->get_user_id(),
                        'dci_fecha_creacion' => date('Y-m-d H:i:s'),
                        'dci_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dci_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $dci_id = $this->gsatelite->ingresar('dci_detalle_control_calidad', $dci_array);
                }
                //GUARDAR ANEXOS
                if (count($ruta) > 0) {
                    for ($i = 0; $i < count($ruta); $i++) {
                        if ($ruta[$i] != "") {
                            $img = $ruta[$i];
                            $titulo = $titulos[$i];
                            $this->datos_anexo($img, $orden, $carpeta, $titulo);
                        }
                    }
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Control de Calidad", 'texto_alerta' => "El registro se ingresó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "No se pudo guardar el registro");
            }
            $this->session->set_flashdata($alerta);
            redirect('proyectos/procesos/pruebas_calidad/' . $orden);
        } else {
            $select = '<option value=""></option>';
                       $this->db->join('cli_cliente', 'cli_id = ord_id_cli');
            $ordenes = $this->gsatelite->get_tabla('ord_orden', array('ord_id' => $ord_id));
                         $this->db->join('axo_articuloxorden', 'art_id = axo_id_art');
            $productos = $this->gsatelite->get_tabla('art_articulo', array('axo_estado' => 1, 'axo_id_ord' => $ord_id));
            if (count($productos) > 0) {
                foreach ($productos as $key => $value) {
                    $select .= '<option value="' . $value['art_id'] . '" data-axo="' . $value['axo_id'] . '">' . $value['art_codigo'] . ' - ' . $value['art_nombre'] . '</option>';
                }
            }
            $data['orden'] = $ordenes[0];
            $data['productos'] = $select;
            $data['titulo_personal'] = "Pruebas de Calidad";
            $this->_cargarvista($data);
        }
    } 

    /**
    * @author Raul Escalante
    * @since  Dic/2019
    * Descripcion: Agregar los resultados de una prueba de calidad
    */
    public function editar_prueba($prueba_id = null, $view = null){
        satelite_validar();
        if ($_POST) {
            $post_array = $this->input->post();
            // var_dump($post_array);die();
            $orden      = $this->input->post('orden_id');
            $ccr_id     = $this->input->post('ccr_id');
            $cliente    = $this->input->post('cliente_id');
            $original   = $this->input->post('original');
            $fecha_test = $this->input->post('fecha_prueba');
            $hora_ini   = $this->input->post("hora_ini");
            $hora_fin   = $this->input->post("hora_fin");
            //DETALLES
            $articulo   = $this->input->post("articulo");
            $axo_id     = $this->input->post("axo");
            $dci_id     = $this->input->post("hdn_dci");
            $fcc_id     = $this->input->post("fcc");
            $fca_id     = $this->input->post("fca");
            $resultado  = $this->input->post("resultado");
            $referencia = $this->input->post("referencia");
            $unidad     = $this->input->post("unidad");
            $comentario = $this->input->post("comentario");
            //ANEXOS
            $files      = $this->input->post('files');
            $id_actu    = $this->input->post('id_actu');
            $ruta       = $this->input->post('ruta');
            $carpeta    = $this->input->post("nombreCarpeta");
            $titulos    = $this->input->post("titulo_doc"); 
            $ccr_array = array(
                'ccr_id_usu' => $this->tank_auth->get_user_id(),
                'ccr_id_ord' => $orden,
                'ccr_fecha' => formatear_fecha('Y-m-d', $fecha_test),
                'ccr_hora_inicio' => formatear_fecha('H:i:s', $hora_ini),
                'ccr_hora_fin' => formatear_fecha('H:i:s', $hora_fin),
                'ccr_fecha_registro' => date('Y-m-d H:i:s'),
                'ccr_estado' => 1,
                'ccr_usu_creacion' => $this->tank_auth->get_user_id(),
                'ccr_fecha_creacion' => date('Y-m-d H:i:s'),
                'ccr_usu_modificacion' => $this->tank_auth->get_user_id(),
                'ccr_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $resultado = $this->gsatelite->actualizar_array('ccr_control_calidad_orden', $ccr_array, array('ccr_id' => $ccr_id));
            if ($resultado > 0) {
                $eliminar = $update = $add = array();
                $anterior = explode(',', $original);
                $count = count($dci_id);
                if (count($anterior) > 0) {
                    //Buscar si  se elimino alguna
                    foreach ($anterior as $key => $value) {
                        if (!(in_array($value, $dci_id))) {
                            array_push($eliminar, $value);
                        }
                    }
                    //Si hay eliminadas, borrarlas
                    if (count($eliminar) > 0) {
                        foreach ($eliminar as $key => $value) {
                            $this->gsatelite->borrado_general('dci_detalle_control_calidad', array('dci_id' => $value));
                        }
                    }
                    //Actualizar o agregar
                    for ($i = 0; $i < $count; $i++) {
                        if (in_array($dci_id[$i], $anterior)) {
                            //Actualiza el existente
                            $dci_array = array(
                                'dci_id_ccr' => $ccr_id,
                                'dci_id_fcc' => $fcc_id[$i],
                                'dci_id_axo' => $axo_id[$i],
                                'dci_valor' => $resultado[$i],
                                'dci_valor_referencia' => $referencia[$i],
                                'dci_comentario' => $comentario[$i],
                                'dci_estado' => 1,
                                'dci_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dci_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $resultado = $this->gsatelite->actualizar_array('dci_detalle_control_calidad', $dci_array, array('dci_id' => $dci_id[$i]));   
                        } else {                            
                            //Agrega el nuevo
                            $dci_array = array(
                                'dci_id_ccr' => $ccr_id,
                                'dci_id_fcc' => $fcc_id[$i],
                                'dci_id_axo' => $axo_id[$i],
                                'dci_valor' => $resultado[$i],
                                'dci_valor_referencia' => $referencia[$i],
                                'dci_comentario' => $comentario[$i],
                                'dci_estado' => 1,
                                'dci_usu_creacion' => $this->tank_auth->get_user_id(),
                                'dci_fecha_creacion' => date('Y-m-d H:i:s'),
                                'dci_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dci_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $dci_id = $this->gsatelite->ingresar('dci_detalle_control_calidad', $dci_array);
                        }
                    }
                }
                //GUARDAR ANEXOS
                if (count($ruta) > 0) {
                    for ($i = 0; $i < count($ruta); $i++) {
                        if ($ruta[$i] != "") {
                            $img = $ruta[$i];
                            $titulo = $titulos[$i];
                            $this->datos_anexo($img, $orden, $carpeta, $titulo);
                        }
                    }
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Control de Calidad", 'texto_alerta' => "El registro se actualizó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "No se pudo guardar el registro");
            }
            $this->session->set_flashdata($alerta);
            redirect('proyectos/procesos/pruebas_calidad/' . $orden);
        } else {
            $select = '<option value=""></option>';
            $controles = $this->gsatelite->get_tabla('ccr_control_calidad_orden', array('ccr_id' => $prueba_id));

                         $this->db->join('axo_articuloxorden', 'art_id = axo_id_art');
            $productos = $this->gsatelite->get_tabla('art_articulo', array('axo_estado' => 1, 'axo_id_ord' => $controles[0]['ccr_id_ord']));
            if (count($productos) > 0) {
                foreach ($productos as $key => $value) {
                    $select .= '<option value="' . $value['art_id'] . '" data-axo="' . $value['axo_id'] . '">' . $value['art_nombre'] . '</option>';
                }
            }
                       $this->db->join('cli_cliente', 'cli_id = ord_id_cli');
            $ordenes = $this->gsatelite->get_tabla('ord_orden', array('ord_id' => $controles[0]['ccr_id_ord']));
            $anexos = $this->gsatelite->get_tabla('aop_anexo_orden_produccion', array('aop_estado' => 1, 'aop_id_ord' => $controles[0]['ccr_id_ord']));
            $detalles = $this->proyecto_model->get_detalle_prueba_calidad(array('dci_id_ccr' => $prueba_id));
            $original = implode(',', array_column($detalles, 'dci_id'));
            $data['orden'] = $ordenes[0];
            $data['con_cal'] = $controles[0];
            $data['productos'] = $select;
            $data['anexos'] = $anexos; 
            $data['detalles'] = $detalles;
            $data['original'] = $original;
            $data['prueba_id'] = $prueba_id;
            $data['editar'] = ($view != null) ? 0 : 1;
            $data['titulo_personal'] = ($view != null) ? "Prueba de Calidad" : "Editar Prueba de Calidad";
            $this->_cargarvista($data);
        }
    } 

    /**
    * @author Raul Escalante
    * @since  Dic/2019
    * Descripcion: Elimina un control de calidad para un articulo
    */
    public function borrar_prueba($ccr_id = null, $ord_id = null){
        $this->gsatelite->borrado_general('dci_detalle_control_calidad', array('dci_id_ccr' => $ccr_id));
        $this->gsatelite->borrado_general('ccr_control_calidad_orden', array('ccr_id' => $ccr_id));
        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Control de Calidad", 'texto_alerta' => "El registro se eliminó correctamente");
        $this->session->set_flashdata($alerta);
        redirect('proyectos/procesos/pruebas_calidad/' . $ord_id);
    }

    /**
    * @author Raul Escalante
    * @since  Dic/2019
    * Descripcion: Devuelve los factores de calidad para un articulo
    */
    public function get_factores_calidad_art($producto = null)    {
        $producto = $this->input->post('producto');
        $select = '<option value=""></option>';
        $respuesta = array();
                    $this->db->join('fca_factores_calidad_articulo', 'fca_id_fcc = fcc_id');
        $factores = $this->gsatelite->get_tabla('fcc_factor_calidad', array('fca_id_art' => $producto, 'fcc_estado' => 1));
        if (count($factores) > 0) {
            foreach ($factores as $key => $value) {
                $select .= '<option value="' . $value['fca_id'] . '" data-unidad="' . $value['fcc_unidad'] . '" data-refer="' . $value['fca_referencia'] . '" data-factor="' . $value['fcc_id'] . '">' . $value['fcc_nombre'] . '</option>';
            }
        }
        $respuesta['factores'] = $select;
        echo json_encode($respuesta);
    }

    /**
    * @author Raul Escalante
    * @since  Dic/2019
    * Descripcion: Maestro - Detalle para ingresar datos proyectados de venta
    */
    public function ventas_proyectadas(){
        satelite_validar();
        $meses = array("",'Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio', 'Agosto','Septiembre','Octubre','Noviembre','Diciembre');
        if ($_POST) {
            $tabla = "";
            $anio = $this->input->post('year');
            $mes  = $this->input->post('month');
            $tia  = $this->input->post('category');
            $art  = $this->input->post('product');
            $where['pyv_estado'] = 1;
            if ($anio != "") {
                $where['pyv_anio'] = intval($anio);
            }
            if ($mes != "") {
                $where['pyv_mes'] = intval($mes);
            }
            if ($tia != "") {
                $where['art_id_tia'] = $tia;
            }
            if ($art != "") {
                $where['art_id'] = $art;
            }
            $detalles = $this->proyecto_model->get_detalle_proyeccion($where);
            if (count($detalles) > 0) {
                foreach ($detalles as $key => $value) {
                    $tabla .= '<tr><td>' . $value['categoria'] . '</td><td>' . $value['art_codigo'] . '</td><td>' . $value['art_nombre'] . '</td><td>' . $value['unidad'] . '</td>';
                    $tabla .= '<td>' . $value['pyv_anio'] . '</td><td>' . $meses[$value['pyv_mes']] . '</td><td style="text-align: right;">' . number_format($value['pyv_cantidad'], 2) . '</td>';
                    $tabla .= '<td><div class="tools"><div class="btn-group"><button class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button>';
                    $tabla .= '<button class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button><ul class="dropdown-menu"><li>';
                    $tabla .= '<a href="' . base_url("proyectos/procesos/editar_proyeccion_venta/" . $value['pyv_id']) . '"><span aria-hidden="true" class="icomoon-icon-pencil-5"> Editar</span>';
                    $tabla .= '</a></li><li><a class="del_proy" data-borrar="' . $value['pyv_id'] . '"><span aria-hidden="true" class="icomoon-icon-remove-5">Eliminar</span></a></li></ul>';
                    $tabla .= '</div></div></td></tr>';
                }
            }
            echo $tabla;
            die();
        } else {
            $select_m = $select_y = '<option value=""></option>';
            $anio = date('Y');
            for ($i = ($anio - 10); $i <= ($anio + 10); $i++) { 
                $selected = ($i == $anio) ? "selected" : "";
                $select_y .= '<option value="' . $i . '" ' . $selected . '>' . $i . '</option>';
            }
            foreach ($meses as $key => $value) {
                if ($value != "") {
                    $select_m .= '<option value="' . $key . '">' . $value . '</option>';
                }
            }
            $data['years'] = $select_y;
            $data['meses'] = $select_m;
            $data['titulo_personal'] = "Proyección de Ventas";
            $this->_cargarvista($data);
        }        
    }

    public function agregar_proyeccion_venta(){
        satelite_validar();
        $decimal = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $meses = array("",'Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio', 'Agosto','Septiembre','Octubre','Noviembre','Diciembre');
        if ($_POST) {
            $pyv_id = 0;
            $repetido = 0;
            $repetido_array = array();
            $post_array = $this->input->post();
            $cva_id = $post_array['slc_unity'];
            $art_id = $post_array['slc_product'];
            $pyv_anio = $post_array['slc_year'];
            $pyv_mes = $post_array['slc_month'];
            $pyv_cantidad = $post_array['txt_cantidad'];
            $repetir = $post_array['hdn_repetir'];
            $redirect = $post_array['btnCrear'];
            $mes_periodo = ($pyv_mes >= 10) ? $pyv_mes : '0' . $pyv_mes;    
            $periodo  = $pyv_anio . $mes_periodo;
            $existentes = $this->gsatelite->get_tabla('pyv_pryeccion_venta', array('pyv_anio' => $pyv_anio, 'pyv_estado' => 1, 'pyv_id_art' => $art_id, 'pyv_id_cva' => $cva_id));
            if (count($existentes) > 0) {//HAY ALGO DE ESE ANIO
                foreach ($existentes as $key => $value) {
                    $repetido += ($value['pyv_periodo'] == $periodo) ? 1 : 0;
                    $repetido_array[$value['pyv_mes']] = $value['pyv_id'];
                }
                if ($repetido > 0) {//EXISTE UN VALOR REPETIDO
                    if ($repetir > 0) {//SE HACE INSERT && UPDATE
                        for ($i = 1; $i < 13; $i++) { 
                            $mes_per = ($i >= 10) ? $i : '0' . $i;    
                            $periode  = $pyv_anio . $mes_per;
                            if (array_key_exists($i, $repetido_array)) {//EL MES EXISTE, SE ACTUALIZA
                                $pyv_array = array(
                                    'pyv_anio' => intval($pyv_anio),
                                    'pyv_mes' => intval($i),
                                    'pyv_periodo' => $periode,
                                    'pyv_cantidad' => number_format($pyv_cantidad, $decimal, '.', ''),
                                    'pyv_estado' => 1,
                                    'pyv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'pyv_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                                $pyv_id += $this->gsatelite->actualizar_array('pyv_pryeccion_venta', $pyv_array, array('pyv_id' => $repetido_array[$i]));
                            } else {//NO EXISTE MES SE HACE INSERT
                                $pyv_array = array(
                                    'pyv_id_cva' => $cva_id,
                                    'pyv_id_art' => $art_id,
                                    'pyv_id_usu' => $this->tank_auth->get_user_id(),
                                    'pyv_anio' => intval($pyv_anio),
                                    'pyv_mes' => intval($i),
                                    'pyv_periodo' => $periode,
                                    'pyv_cantidad' => number_format($pyv_cantidad, $decimal, '.', ''),
                                    'pyv_fecha_registro' => date('Y-m-d H:i:s'),
                                    'pyv_estado' => 1,
                                    'pyv_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'pyv_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'pyv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'pyv_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                                $pyv_id += $this->gsatelite->ingresar('pyv_pryeccion_venta', $pyv_array);
                            }
                        }
                    } else {//NO SE HARA INSERT
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Ya existía una Proyección en este Período");
                        $redirect = 1;
                    }                    
                } else {//EL PERIODO QUE INGRESAMOS NO ESTA EN LOS YA SUBIDOS
                    if ($repetir > 0) {//SE HACE INSERT && UPDATE
                        for ($i = 1; $i < 13; $i++) { 
                            $mes_per = ($i >= 10) ? $i : '0' . $i;    
                            $periode  = $pyv_anio . $mes_per;
                            if (array_key_exists($i, $repetido_array)) {//EL MES EXISTE, SE ACTUALIZA
                                $pyv_array = array(
                                    'pyv_anio' => intval($pyv_anio),
                                    'pyv_mes' => intval($i),
                                    'pyv_periodo' => $periode,
                                    'pyv_cantidad' => number_format($pyv_cantidad, $decimal, '.', ''),
                                    'pyv_estado' => 1,
                                    'pyv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'pyv_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                                $pyv_id += $this->gsatelite->actualizar_array('pyv_pryeccion_venta', $pyv_array, array('pyv_id' => $repetido_array[$i]));
                            } else {//NO EXISTE MES SE HACE INSERT
                                $pyv_array = array(
                                    'pyv_id_cva' => $cva_id,
                                    'pyv_id_art' => $art_id,
                                    'pyv_id_usu' => $this->tank_auth->get_user_id(),
                                    'pyv_anio' => intval($pyv_anio),
                                    'pyv_mes' => intval($i),
                                    'pyv_periodo' => $periode,
                                    'pyv_cantidad' => number_format($pyv_cantidad, $decimal, '.', ''),
                                    'pyv_fecha_registro' => date('Y-m-d H:i:s'),
                                    'pyv_estado' => 1,
                                    'pyv_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'pyv_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'pyv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'pyv_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                                $pyv_id += $this->gsatelite->ingresar('pyv_pryeccion_venta', $pyv_array);
                            }
                        }
                    } else {
                        $pyv_array = array(
                            'pyv_id_cva' => $cva_id,
                            'pyv_id_art' => $art_id,
                            'pyv_id_usu' => $this->tank_auth->get_user_id(),
                            'pyv_anio' => intval($pyv_anio),
                            'pyv_mes' => intval($pyv_mes),
                            'pyv_periodo' => $periodo,
                            'pyv_cantidad' => number_format($pyv_cantidad, $decimal, '.', ''),
                            'pyv_fecha_registro' => date('Y-m-d H:i:s'),
                            'pyv_estado' => 1,
                            'pyv_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pyv_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pyv_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pyv_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $pyv_id = $this->gsatelite->ingresar('pyv_pryeccion_venta', $pyv_array);
                    }                    
                }
            } else {//NO HAY NADA DE ESE ANIO
                if ($repetir > 0) {
                    for ($i = 1; $i < 13; $i++) { 
                        $mes_per = ($i >= 10) ? $i : '0' . $i;    
                        $periode  = $pyv_anio . $mes_per;
                        $pyv_array = array(
                            'pyv_id_cva' => $cva_id,
                            'pyv_id_art' => $art_id,
                            'pyv_id_usu' => $this->tank_auth->get_user_id(),
                            'pyv_anio' => intval($pyv_anio),
                            'pyv_mes' => intval($i), //intval($pyv_mes),
                            'pyv_periodo' => $periode,
                            'pyv_cantidad' => number_format($pyv_cantidad, $decimal, '.', ''),
                            'pyv_fecha_registro' => date('Y-m-d H:i:s'),
                            'pyv_estado' => 1,
                            'pyv_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pyv_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pyv_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pyv_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $pyv_id += $this->gsatelite->ingresar('pyv_pryeccion_venta', $pyv_array);
                    }
                } else {//NO REPETIR, SOLO INSERTAR 1
                    $pyv_array = array(
                        'pyv_id_cva' => $cva_id,
                        'pyv_id_art' => $art_id,
                        'pyv_id_usu' => $this->tank_auth->get_user_id(),
                        'pyv_anio' => intval($pyv_anio),
                        'pyv_mes' => intval($pyv_mes),
                        'pyv_periodo' => $periodo,
                        'pyv_cantidad' => number_format($pyv_cantidad, $decimal, '.', ''),
                        'pyv_fecha_registro' => date('Y-m-d H:i:s'),
                        'pyv_estado' => 1,
                        'pyv_usu_creacion' => $this->tank_auth->get_user_id(),
                        'pyv_fecha_creacion' => date('Y-m-d H:i:s'),
                        'pyv_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'pyv_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $pyv_id = $this->gsatelite->ingresar('pyv_pryeccion_venta', $pyv_array);
                }
                if ($pyv_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Proyección de Ventas", 'texto_alerta' => "El registro se ingresó correctamente");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "No se pudo guardar el registro");
                }            
            }
            $this->session->set_flashdata($alerta);
            if ($redirect > 1) {
                redirect('proyectos/procesos/ventas_proyectadas');
            } else {
                redirect('proyectos/procesos/agregar_proyeccion_venta');
            }
        } else {
            $anio = date('Y');
            $select_m = $select_y = '<option value=""></option>';            
            for ($i = ($anio - 10); $i <= ($anio + 10); $i++) { 
                $selected = ($i == $anio) ? "selected" : "";
                $select_y .= '<option value="' . $i . '" ' . $selected . '>' . $i . '</option>';
            }
            foreach ($meses as $key => $value) {
                if ($value != "") {
                    $select_m .= '<option value="' . $key . '">' . $value . '</option>';
                }
            }
            $data['years'] = $select_y;
            $data['meses'] = $select_m;
            $data['titulo_personal'] = "Nueva Proyección de Ventas";
            $this->_cargarvista($data);
        }
    }

    public function editar_proyeccion_venta($pyv_id = null){
        satelite_validar();
        $decimal = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $meses = array("",'Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio', 'Agosto','Septiembre','Octubre','Noviembre','Diciembre');
        if ($_POST) {
            $post_array = $this->input->post();
            $cva_id = $post_array['slc_unity'];
            $art_id = $post_array['slc_producto'];
            $pyv_anio = $post_array['slc_year'];
            $pyv_mes = $post_array['slc_month'];
            $pyv_cantidad = $post_array['txt_cantidad'];
            $repetir = $post_array['hdn_repetir'];
            $redirect = $post_array['btnCrear'];
            $mes_periodo = ($pyv_mes >= 10) ? $pyv_mes : '0' . $pyv_mes;    
            $periodo  = $pyv_anio . $mes_periodo;
            if ($repetir > 0) {
                # code...
            } else {
                $pyv_array = array(
                    'pyv_id_cva' => $cva_id,
                    'pyv_id_art' => $art_id,
                    'pyv_id_usu' => $this->tank_auth->get_user_id(),
                    'pyv_anio' => intval($pyv_anio),
                    'pyv_mes' => intval($pyv_mes),
                    'pyv_periodo' => $periodo,
                    'pyv_cantidad' => number_format($pyv_cantidad, $decimal, '.', ''),
                    'pyv_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'pyv_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $afectados = $this->gsatelite->actualizar_array('pyv_pryeccion_venta', $pyv_array, array('pyv_id' => $pyv_id));
                if ($afectados > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Proyección de Ventas", 'texto_alerta' => "El registro se actualizó correctamente");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "No se pudo actualizar el registro");
                }
            }
            $this->session->set_flashdata($alerta);
            if ($redirect > 1) {
                redirect('proyectos/procesos/ventas_proyectadas');
            } else {
                redirect('proyectos/procesos/editar_proyeccion_venta/' . $pyv_id);
            }
        } else {
            $anio = date('Y');
            $select_m = $select_y = $select_cva = '<option value=""></option>';
                        $this->db->join('art_articulo', 'pyv_id_art = art_id');
            $detalles = $this->gsatelite->get_tabla('pyv_pryeccion_venta', array('pyv_estado' => 1, 'pyv_id' => $pyv_id));
            $conversiones = $this->inventario_model->get_conversiones_producto(array('cva_estado' => 1, 'cva_id_art' => $detalles[0]['art_id']));
            if (count($conversiones) > 0) {
                foreach ($conversiones as $key => $value) {
                    $selected = ($value['cva_id'] == $detalles[0]['pyv_id_cva']) ? "selected" : "";
                    $select_cva .= '<option value="' . $value['cva_id'] . '" ' . $selected . '>' . $value['mep_nombre'] . '</option>';
                }
            }
            for ($i = ($anio - 10); $i <= ($anio + 10); $i++) { 
                $selected = ($i == $detalles[0]['pyv_anio']) ? "selected" : "";
                $select_y .= '<option value="' . $i . '" ' . $selected . '>' . $i . '</option>';
            }
            foreach ($meses as $key => $value) {
                if ($value != "") {
                    $selected = ($key == $detalles[0]['pyv_mes']) ? "selected" : "";
                    $select_m .= '<option value="' . $key . '" ' . $selected .'>' . $value . '</option>';
                }
            }
            $data['years'] = $select_y;
            $data['meses'] = $select_m;
            $data['medidas'] = $select_cva;
            $data['detalles'] = $detalles[0];
            $data['titulo_personal'] = "Editar Proyección de Ventas";
            $this->_cargarvista($data);
        }        
    }

    public function eliminar_proyeccion_venta($pyv_id = null){
        $this->gsatelite->borrado_general('pyv_pryeccion_venta', array('pyv_id' => $pyv_id));
        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Proyección de Ventas", 'texto_alerta' => "El registro se eliminó correctamente");
        $this->session->set_flashdata($alerta);
        redirect('proyectos/procesos/ventas_proyectadas');
    }

    /**
    * @author Raul Escalante
    * @since  Mar/2020
    * Descripcion: Ingresar datos proyectados de venta por medio de archivo xls
    */
    public function venta_proyectada_masiva(){
        satelite_validar();
        $dec = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        if ($_POST) {
            $pyv_id = 0;
            $repetido_cva = array();
            $post_array = $this->input->post();
            $art_id = $post_array['arts'];
            $cva_id = $post_array['cvas'];            
            $pyv_anio = $post_array['anio'];
            $pyv_mes = $post_array['mes'];
            $pyv_cantidad = $post_array['cantidad'];
            $filas = count($art_id);      
            $art_in = implode(',', array_unique($art_id));      
            $existentes = $this->gsatelite->get_tabla("pyv_pryeccion_venta", array("pyv_estado" => 1, "pyv_id_art IN ($art_in)" => NULL));
            if (count($existentes) > 0) {
                foreach ($existentes as $key => $value) {
                    $clave = $value['pyv_periodo'] . $value['pyv_id_art'] . $value['pyv_id_cva'];
                    $repetido_array[$clave] = $value['pyv_id'];
                }
                foreach ($art_id as $k => $val) {
                    $mes_periodo = ($pyv_mes[$k] >= 10) ? $pyv_mes[$k] : '0' . $pyv_mes[$k];
                    $periodo  = $pyv_anio[$k] . $mes_periodo;
                    $clave = $periodo . $val . $cva_id[$k];
                    if (array_key_exists($clave, $repetido_array)) {
                        $pyv_array = array(
                            'pyv_anio' => $pyv_anio[$k],
                            'pyv_mes' => $pyv_mes[$k],
                            'pyv_periodo' => $periodo,
                            'pyv_cantidad' => number_format($pyv_cantidad[$k], $dec, '.', ''),
                            'pyv_estado' => 1,
                            'pyv_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pyv_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $pyv_id += $this->gsatelite->actualizar_array('pyv_pryeccion_venta', $pyv_array, array('pyv_id' => $repetido_array[$clave]));
                    } else {
                        $pyv_array = array(
                            'pyv_id_cva' => $cva_id[$k],
                            'pyv_id_art' => $val,
                            'pyv_id_usu' => $this->tank_auth->get_user_id(),
                            'pyv_anio' => $pyv_anio[$k],
                            'pyv_mes' => $pyv_mes[$k],
                            'pyv_periodo' => $periodo,
                            'pyv_cantidad' => number_format($pyv_cantidad[$k], $dec, '.', ''),
                            'pyv_fecha_registro' => date('Y-m-d H:i:s'),
                            'pyv_estado' => 1,
                            'pyv_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pyv_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pyv_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pyv_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $pyv_id += $this->gsatelite->ingresar('pyv_pryeccion_venta', $pyv_array);
                    }                 
                }
            } else {
                foreach ($art_id as $k => $val) {
                    $mes_periodo = ($pyv_mes[$k] >= 10) ? $pyv_mes[$k] : '0' . $pyv_mes[$k];
                    $periodo  = $pyv_anio[$k] . $mes_periodo;
                    $pyv_array = array(
                        'pyv_id_cva' => $cva_id[$k],
                        'pyv_id_art' => $val,
                        'pyv_id_usu' => $this->tank_auth->get_user_id(),
                        'pyv_anio' => $pyv_anio[$k],
                        'pyv_mes' => $pyv_mes[$k],
                        'pyv_periodo' => $periodo,
                        'pyv_cantidad' => number_format($pyv_cantidad[$k], $dec, '.', ''),
                        'pyv_fecha_registro' => date('Y-m-d H:i:s'),
                        'pyv_estado' => 1,
                        'pyv_usu_creacion' => $this->tank_auth->get_user_id(),
                        'pyv_fecha_creacion' => date('Y-m-d H:i:s'),
                        'pyv_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'pyv_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $pyv_id += $this->gsatelite->ingresar('pyv_pryeccion_venta', $pyv_array);
                }
            }
            if ($pyv_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Proyección de Ventas", 'texto_alerta' => "Los registros se ingresaron correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "No se pudo guardar el registro");
            }            
            $this->session->set_flashdata($alerta);
            redirect('proyectos/procesos/ventas_proyectadas');
            die();
        } else {
            $data['titulo_personal'] = "Proyecciones de Ventas";
            $this->_cargarvista($data, null);
        } 
    }

    public function cargar_vta_proy_masiva(){
        if ($_FILES) {
            $dec = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
            $articulos_validos = $medidas_validas = array();
            $this->load->library('excel/excel_reader.php');
            $excel = new Excel_reader;
            $excel->read($_FILES["file"]["tmp_name"]);
            $nr_sheets = count($excel->sheets);
            $excel_tabla = '<table border="1" class="responsive table table-bordered contenedor" id="data_expand" name="data_expand">';
            $excel_tabla .= '<thead><tr><th colspan="1">ID Artículo</th><th colspan="1">Código</th><th colspan="1">Nombre</th><th colspan="1">ID Unidad</th>';
            $excel_tabla .= '<th colspan="1">Mes</th><th colspan="1">Año</th><th colspan="1">Cantidad</th></tr></thead><tbody>';
            $errores = 0;
            if ($nr_sheets > 0) {
                $excel->sheets[0]['cells'] = array_values($excel->sheets[0]['cells']); //reordena el array que empieza con 1 a 0
                unset($excel->sheets[0]['cells'][0]); // elimina la posicion 0 del array
                $arreglo = $excel->sheets[0]['cells'];
                if (count($arreglo) > 0) {
                    $id_art = array_unique(array_filter(array_column($arreglo, 1)));
                    $id_mep = array_unique(array_filter(array_column($arreglo, 4)));
                    $id_art = (count($id_art) > 0) ? $id_art : array(0);
                    $id_mep = (count($id_mep) > 0) ? $id_mep : array(0);
                    $producto = $this->db->select('art_id')->where('art_estado', 1)->where_in('art_id', $id_art)->from('art_articulo')->get()->result_array();
                    $articulos_validos = array_column($producto, 'art_id');
                               $this->db->join('cva_conversion_articulo', 'cva_id_mep = mep_id');
                    $medidas = $this->db->select('mep_id')->where('mep_estado', 1)->where_in('mep_id', $id_mep)->where_in('cva_id_art', $articulos_validos)->from('mep_medida_producto')->get()->result_array();
                    $medidas_validas = array_column($medidas, 'mep_id'); 
                    $meses = array('', 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
                    $error = '<tr><td colspan="7" style="text-align: center;"><b>No todos los datos cargados poseen congruencia. Por favor verifique el contenido del archivo e intente nuevamente.</b></td></tr>';
                    $exito = '';
                    $year = date('Y');
                    $future = $year + 2;
                    foreach ($arreglo as $key => $value) {
                        if (in_array($value[1], $articulos_validos)) {
                            if (in_array($value[4], $medidas_validas)) {
                                if (is_numeric($value[5]) && ($value[5] % 1 == 0) && $value[5] > 0 && $value[5] < 13) {
                                    if (is_numeric($value[6]) && ($value[6] % 1 == 0) && $value[6] >= $year && $value[6] <= $future) {
                                        if (is_numeric($value[7]) && $value[7] > 0) {
                                                      $this->db->join('cva_conversion_articulo', 'cva_id_mep = mep_id');
                                            $cvamep = $this->gsatelite->get_tabla('mep_medida_producto', array('mep_id' => $value[4], 'cva_id_art' => $value[1], 'cva_estado' => 1));
                                            $exito .= '<tr><td><input type="hidden" name="arts[]" value="' . $value[1] . '"><input type="hidden" name="cvas[]" value="' . $cvamep[0]['cva_id'] . '">';
                                            $exito .= '<label>' . $value[1] . '</label></td><td><label>' . $value[2] . '</label></td><td><label>' . $value[3] . '</label></td><td>';
                                            $exito .= '<label>' . $cvamep[0]['mep_nombre'] . '</label></td><td><input type="hidden" name="mes[]" value="' . intval($value[5]) . '"><label>';
                                            $exito .= $meses[intval($value[5])] . '</label></td><td><input type="hidden" name="anio[]" value="' . intval($value[6]) . '"><label>' . intval($value[6]);
                                            $exito .= '</label></td><td style="text-align: right;"><input type="hidden" name="cantidad[]" value="' . number_format($value[7], $dec, '.', '') . '">';
                                            $exito .= '<label>' . number_format($value[7], $dec) . '</label></td></tr>';
                                        } else {
                                            $errores++;
                                        }
                                    } else {
                                        $errores++;
                                    }                                    
                                } else {
                                    $errores++;
                                }                                
                            } else {
                                $errores++;
                            }                            
                        } else {
                            $errores++;
                        }
                    }
                    $excel_tabla .= ($errores > 0) ? $error : $exito;
                }else{
                    $excel_tabla .= '<tr><td colspan="7" style="text-align: center;"><b>No se han cargado datos válidos. Por favor verifique.</b></td></tr>';
                    $errores++;
                }
            }
            $excel_tabla .= '</tbody></table>';
            $respuesta = array('tabla' => $excel_tabla, 'errores' => $errores);
            echo json_encode($respuesta);
            die();
        }        
    }

    /**
    * @autor Raul Escalante
    * Exporta los detalles de la programacion de produccion a Excel
    */
    public function reporte_programacion_produccion($ppd_id){
        satelite_validar();
        $data['filename'] = 'reporte_programacion';
        $data['tipo_reporte'] = 'excel';
        $data['programacion'] = $this->proyecto_model->get_reporte_programacion(array('ppd_id' => $ppd_id));
        $html = $this->load->view("proyectos/procesos/report_program_produc", $data, TRUE);
        echo $html;
    }

    /**
    * @autor Raul Escalante
    * Exporta los detalles de la planificacion de produccion a Excel
    */
    public function reporte_planificacion_produccion($plf_id){
        satelite_validar();
        $data['filename'] = 'reporte_planificacion_' . $plf_id;
        $data['tipo_reporte'] = 'excel';
        $data['planificacion'] = $this->proyecto_model->get_reporte_planificacion(array('plf_id' => $plf_id));
        $html = $this->load->view("proyectos/procesos/report_planifica_produc", $data, TRUE);
        echo $html;
    }

    public function devolver_materiales(){
        satelite_validar();
        if ($_POST) {
            $exito = 0;
            $ord_id = $this->input->post('slcOrden');
            $bodega = $this->input->post('slcBodega');
            $axo_id = $this->input->post('axo_id');            
            $axm_id = $this->input->post('axm_id');
            $etapas = $this->input->post('etapas');            
            $art_materia = $this->input->post('art_materia');
            $cva_materia = $this->input->post('cva_materia');
            $ctdad_orig = $this->input->post('total_orig');
            $ctdad_max = $this->input->post('ctdad_max');
            $devolucion = $this->input->post('devolucion');
            $ya_devuelt = $this->input->post('devueltas');
            $ctdad_nva = $this->input->post('ctdad_nva');
            $costo_promedio = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
            $tip_entrada = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS', null, null, array('DEV_MAT_OP'));
            $moi_mov = array(
                'moi_id_tip' => $tip_entrada, 
                'moi_id_bod' => $bodega,
                'moi_descripcion' => 'Ingreso por devolucion de materia prima de OP',
                'moi_estado' => 1,
                'moi_fecha_mov' => date('Y-m-d H:i:s'),
                'moi_fecha_creacion' => date('Y-m-d H:i:s'),
                'moi_fecha_modificacion' => date('Y-m-d H:i:s'),
                'moi_usu_creacion' => $this->tank_auth->get_user_id(),
                'moi_usu_modificacion' => $this->tank_auth->get_user_id()
            );
            $id_moi = $this->gsatelite->ingresar('moi_movimiento_inv',$moi_mov);
            foreach ($axm_id as $k => $val) {
                if ($ctdad_orig[$k] > $ctdad_nva[$k] && $devolucion[$k] > 0) {
                    $diferencia =  ($ya_devuelt[$k] != "") ? ($devolucion[$k] + $ya_devuelt[$k]) : $devolucion[$k];
                    $axm_update = array(
                        'axm_devolucion' => $diferencia,
                        'axm_fecha_modificacion' => date('Y-m-d H:i:s'), 
                        'axm_usu_modificacion' => $this->tank_auth->get_user_id()
                    );
                    $axm_mov = $this->gsatelite->actualizar_array('axm_articulo_matxarticulo_ord', $axm_update, array('axm_id' => $val));
                    if ($costo_promedio == 1) {
                        $precio = $this->gsatelite->get_max('sar_saldo_articulo', 'sar_precio', array('sar_id_bod' => $bodega, 'sar_id_art' => $art_materia[$k]));
                    } else {
                        // Pendiente definir costo para el PEPS, mientras tanto se deja igual que costo promedio
                        $precio = $this->gsatelite->get_max('sar_saldo_articulo', 'sar_precio', array('sar_id_bod' => $bodega, 'sar_id_art' => $art_materia[$k]));
                    }
                    $sar_mov = array(
                        'sar_id_art' => $art_materia[$k],
                        'sar_id_bod' => $bodega,
                        'sar_cant_actual' => $devolucion[$k],
                        'sar_precio' => $precio,
                        'sar_estado' => 1,
                        'sar_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sar_fecha_creacion' => date('Y-m-d H:i:s'),
                        'sar_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $id_sar = $this->gsatelite->ingresar('sar_saldo_articulo',$sar_mov);
                    $dee_mov = array(
                        'dee_id_moi' => $id_moi,
                        'dee_id_art' => $art_materia[$k],
                        'dee_id_sar' => $id_sar,
                        'dee_id_cva' => $cva_materia[$k],
                        'dee_cantidad' => $devolucion[$k],
                        'dee_precio' => $precio,
                        'dee_subtotal' => ($precio * $devolucion[$k]),
                        'dee_estado' => 1,
                        'dee_usu_creacion' => $this->tank_auth->get_user_id(),
                        'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                        'dee_fecha_modificacion' =>  date('Y-m-d H:i:s')
                    );
                    $id_dee = $this->gsatelite->ingresar('dee_detalle_mov',$dee_mov);
                    if ($id_moi > 0 && $axm_mov > 0 && $id_sar > 0 && $id_dee > 0) {
                        $exito++;
                    }                    
                }
            }
            if ($exito > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Devolución de Materiales", 'texto_alerta' => "Los registros se modificaron correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "No se pudo modificar el registro");
            }            
            $this->session->set_flashdata($alerta);
            redirect('proyectos/procesos/devolver_materiales');
            die();
        } else {
            $data['titulo_personal'] = "Devolución de Materiales por Orden";
            $dropdown = $this->gsatelite->get_dropdown('tio_tipo_orden', '{tio_nombre}', 'tipo_orden', array('tio_estado' => 1), null, null, null, true);
            $data['tipo_orden'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $dropdown);
            $this->_cargarvista($data);
        }        
    }

    public function get_materiales_devolucion(){
        $orden = $this->input->post('orden');
        $axo = $this->input->post('axo');
        $respuesta = array();
        $where = array('axo_id_ord' => $orden);
        if (trim($axo) != "") {
            $where['axo_id'] = $axo;
        }
        $detalles = $this->proyecto_model->get_mp_axo($where);
        $despachada = array_sum(array_column($detalles, 'axm_despachada'));
        $this->db->limit(1);
        $bod_id = ($despachada > 0) ? $this->gsatelite->get_campo('rxi_requisicion_inventario', 'rxi_id_bod', array('rxi_id_ord' => $orden, 'rxi_estado' => 0)) : null;
        $dropdown = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, null, null, true);
        $data['detalles'] = $detalles;
        $html = $this->load->view('proyectos/procesos/consultar_devolver_materiales', $data, true);        
        $respuesta['tabla'] = $html;
        $respuesta['despa'] = $despachada;
        $respuesta['filas'] = count($detalles);
        $respuesta['dropd'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option></option>', $dropdown);
        echo json_encode($respuesta);
    }

    /**
     *@author: Marlon Olmedo
     *Fecha: 2019/07/22
     *Descripción: trae el reporte en proyectos de los operarios segun la fechas de programacion
     */
    public function reporte_programacion_detallada($ppd_id){
        satelite_validar();
        $proyecto = $this->gsatelite->get_tabla('ppd_programacion_produccion', array('ppd_id' => $ppd_id));
        $data["fecha_ini"] = formatear_fecha('d-m-Y', $proyecto[0]['ppd_fecha_inicio']);
        $data["fecha_fin"] = formatear_fecha('d-m-Y', $proyecto[0]['ppd_fecha_fin']);
        $data["progra_id"] = $ppd_id;
        $data["filtro"] = 0;
        $this->load->library('../controllers/proyectos/reportes');
        $this->reportes->rep_produccion_detallada($data);
    }

    /**
     *@author: Marlon Olmedo
     *Fecha: 2019/07/22
     *Descripción: hoja de trabajos para operarios sobre orden de compra
     */
    public function hoja_trabajo_op($ord_id){
        satelite_validar();
        //print_r($ord_id);die();
        $this->db->join('ord_orden', 'axo_id_ord = ord_id', "left");
        $this->db->join('art_articulo', 'axo_id_art = art_id', "left");
        $orden = $this->gsatelite->get_tabla('axo_articuloxorden', array('axo_id_ord' => $ord_id));

        foreach ($orden as $key => $value) {
            $where["axm_id_axo"] = $value["axo_id"];
            $order_by = "etp_id";
            $detalles = $this->proyecto_model->get_detalle_hoja_OP($where,$order_by);
            $this->db->join('ord_orden', 'axo_id_ord = ord_id', "left");
            $ordenxart =  $this->proyecto_model->get_penultimo_reg('axo_articuloxorden', array('axo_id_art' => $value["axo_id_art"]),"axo_id_ord");
            $orden[$key]["detalles"] = $detalles;
            $orden[$key]["pen_orden"] = $ordenxart[0];
        }
        $filename               = 'Reporte_hojas_OP_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        $data['filename']       = $filename;
        $data['titulo']         = 'Hojas de Trabajo de la OP';
        $data["orden"] = $orden;

        $html = $this->load->view('proyectos/procesos/grid_hoja_trabajo_ord',$data,true);
        //print_r($html);die();
        $header                     = $this->load->view('reporte/header', $data, true);
        $GLOBALS['nombre_reporte']  = 'Reporte_hojas_OP_' . date('dmY');
        $reporte                    =  $header . $html;
        $this->pdf->makePdf($reporte, 'P', 'Reporte_hojas_OP_', 'Letter');
        die();
    }


    public function verificar_materiales_explosion(){
        $decimal = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $articulos = $this->input->post('articulos');
        $pro_inter = ($this->input->post('intermedios') != "") ? $this->input->post('intermedios') : null;
        $mat_prima = ($this->input->post('materiales') != "") ? $this->input->post('materiales') : null;
        $array_productos = $array_index = $array_respuesta = array();
        if (is_array($articulos) && count($articulos) > 0) {
            foreach ($articulos as $key => $value) {
                if (array_key_exists($value['art'], $array_productos)) {
                    $array_productos[$value['art']]['cantidad'] += $value['ctd'];
                    array_push($array_index[$value['art']], $value['id']);                    
                } else {
                    $array_productos[$value['art']] = array('art_id' => $value['art'], 'cantidad' => $value['ctd']);
                    $array_index[$value['art']] = array($value['id']);
                }                
            }
            if (count($array_productos) > 0) {
                foreach ($array_productos as $key => $value) {
                    $array_totales = $this->proyecto_model->get_total_explosion($value['art_id'], $value['cantidad'], $pro_inter, $mat_prima); 
                    if (count($array_totales) > 0) {
                        $array_disponible = array();
                        foreach ($array_totales as $k0 => $val0) {
                            $array_disponible[$val0['array_key']] = $val0['disponible'];
                        }
                        foreach ($articulos as $k1 => $val1) {
                            if ($val1['art'] == $value['art_id']) {
                                $array_unidad = $this->proyecto_model->get_total_explosion($val1['art'], $val1['ctd'], $pro_inter, $mat_prima); 
                                $faltantes = 0;
                                foreach ($array_disponible as $k2 => $val2) {
                                    foreach ($array_unidad as $k3 => $val3) {
                                        if ($val3['array_key'] == $k2) {
                                            $dif = $val2 - $val3['total_requerido'];
                                            if ($dif < 0) {
                                                $faltantes++;
                                            } else {
                                                $array_disponible[$k2] = $dif;
                                            }                                            
                                        }
                                    }
                                }
                                if ($faltantes > 0) {
                                    $array_respuesta[$val1['id']] = 0;
                                } else {
                                    $array_respuesta[$val1['id']] = 1;
                                }                                
                            }
                        }
                    } else {
                        foreach ($array_index as $k2 => $val) {
                            if ($value['art_id'] == $k2) {
                                foreach ($val as $k3 => $v) {
                                    $array_respuesta[$v] = 0;
                                }
                            }
                        }
                    }
                    
                }
            }
            ksort($array_respuesta);
        }
        $arreglo = array('respuesta' => $array_respuesta);
        echo json_encode($arreglo);
        die();    
    }

    /**
    * @author Marlon Olmedo
    * @since  03/07/2020
    * Descripcion: Agenda la ejecucion de las ordenes de produccion asignandole maquina y operario
    */
    public function agregar_programacion_ver($ppd_id){
        satelite_validar();
            $data['programacion'] = $this->gsatelite->get_tabla('ppd_programacion_produccion', array('ppd_id' => $ppd_id));
            $where["dpp_id_ppd"] = $ppd_id;
            $detalles = $this->proyecto_model->get_detalle_programacionxdet($where,"dpp_id");
            foreach ($detalles as $key => $value) {
                $array = explode("&&",$value["det_progra"]);
                foreach ($array as $key2 => $value2) {
                    $campos = explode(";uwu;",$value2);
                    $array_to_json = array(
                        "key" => $key2,
                        "art" => $value["dpp_id_art"],
                        "cva" => $value["dpp_id_cva"],
                        "ord" => $value["ord_id"],
                        "axo" => $value["axo_id"],
                        "eta" => $campos[0],
                        "maq" => $campos[1],
                        "ope" => $campos[6],
                        "hor" => $campos[4],
                        "fec" => formatear_fecha("d-m-Y",$campos[5]),
                        "etapa_nombre" => $campos[2],
                        "maqui_nombre" => $campos[3],
                        "opera_nombre" => $campos[7]
                    );
                    $details[$key2] = json_encode($array_to_json);
                }
                $detalles[$key]["det_progra"] = implode("#",$details);
            }
            $data["detalles"] = $detalles;
            $data['decimal'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES',2);
            //print_r($detalles);die();
            $html = $this->load->view("proyectos/procesos/grid_programacion", $data, TRUE);            
            $data["detalles"] = $html;
            $data['titulo_personal'] = "Programación";
            $this->_cargarvista($data);
    }

    /**
    * @author Raul E.
    * @since  20/07/2020
    * Descripcion: Genera el reporte detalle de la explosion de materiales de la planificacion o programacion
    * $tipo: Define la tabla buscar segun si es planificacion, ($tipo = 0) o es programacion ($tipo = 1)
    * $codigo: ID de la planificacion / programacion referenciado
    */
    public function explosion_materiales($tipo, $codigo){
        satelite_validar();
        if ($tipo > 0) {
            $nombre = 'programacion_' . $codigo;
            $where = array('edp_id_ppd' => $codigo);
        } else {
            $nombre = 'planificacion_' . $codigo;
            $where = array('dex_id_plf' => $codigo);
        }
        $data['filename'] = 'explosion_materiales_' . $nombre;
        $data['tipo'] = $tipo;
        $data['tipo_reporte'] = 'excel';
        $data['dec'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
        $data['detalles'] = $this->proyecto_model->get_reporte_explosion_mat($tipo, $where);
        $html = $this->load->view("proyectos/procesos/detalle_rpte_explosion_materiales", $data, TRUE);
        echo $html;
    }

    /**
    * @author Raul E.
    * @since  28/07/2020
    * Descripcion: Establece el estado de la orden en Finalizado
    * Recalcula el costeo de la orden tomando en cuenta devoluciones de materiales o sobreproduccion
    */
    public function finiquitar_orden($orden){
        satelite_validar();
        $respuesta = $axm_upt = $mob_upt = $gif_upt = $axo_upt = 0;
        $datos_actualizar = array();
        $datos_finales = $this->proyecto_model->get_detalles_cierre_orden(array('axo_id_ord' => $orden));
        if (count($datos_finales) > 0) {
            if ($datos_finales[0]['ctdad_real'] > 0) { 
                $datos_actualizar = array();
                foreach ($datos_finales as $key => $val) {
                    if (array_key_exists($val['axo_id'], $datos_actualizar)) {
                        $datos_actualizar[$val['axo_id']]['mat_prima'][$val['mpa_id_art_materia']]['ctdad_neta'] = ($val['total_solicitado'] - $val['material_devuelto']);
                    } else {
                        $datos_actualizar[$val['axo_id']]['articulo'] = $val['axo_id_art'];
                        $datos_actualizar[$val['axo_id']]['ctdad_mob'] = $val['sum_mob'];
                        $datos_actualizar[$val['axo_id']]['ctdad_gif_fijo'] = $val['sum_gif'];
                        $datos_actualizar[$val['axo_id']]['ctdad_real_prod'] = $val['ctdad_real'];
                        $datos_actualizar[$val['axo_id']]['mat_prima'][$val['mpa_id_art_materia']]['ctdad_neta'] = ($val['total_solicitado'] - $val['material_devuelto']);
                    }
                    
                }
            }
            if (count($datos_actualizar) > 0) {
                foreach ($datos_actualizar as $key => $value) {
                    foreach ($value['mat_prima'] as $ky => $val) {//axm
                        $array_axm = array();
                        $nuevo_precio = $this->proyecto_model->get_costo_mpa(array('mpa_id_art' => $value['articulo'], 'mpa_id_art_materia' => $ky));
                        if (count($nuevo_precio) > 0) {
                            $array_axm['axm_precio'] = $nuevo_precio['costo'];
                        }
                        if ($val['ctdad_neta'] > 0) {
                            $array_axm['axm_cantidad'] = $val['ctdad_neta'];
                        }
                        $array_axm['axm_usu_modificacion'] = $this->tank_auth->get_user_id();
                        $array_axm['axm_fecha_modificacion'] = date('Y-m-d H:i:s');
                        $axm_upt += $this->gsatelite->actualizar_array('axm_articulo_matxarticulo_ord', $array_axm, array('axm_id_axo' => $key, 'axm_id_art_materia' => $ky));
                    }
                    if ($value['ctdad_mob'] > 0) {
                        $array_axo = array('mxo_cantidad' => $value['ctdad_mob'], 'mxo_usu_modificacion' => $this->tank_auth->get_user_id(), 'mxo_fecha_modificacion' => date('Y-m-d H:i:s'));
                        $mob_upt += $this->gsatelite->actualizar_array('mxo_mano_obraxarticulo_ord', $array_axo, array('mxo_id_axo' => $key));
                    }
                    if ($value['ctdad_gif_fijo'] > 0) {
                        $gifs = $this->gsatelite->get_tabla('esm_estimacion', array('esm_tipo_calculo' => 1, 'esm_calculo_etapa' => 1, 'esm_estado' => 1));                        
                        $esms = (count($gifs) > 0) ? implode(',', array_column($gifs, 'esm_id')) : 0;
                        $array_exr = array("exr_cantidad" => $value['ctdad_gif_fijo'], 'exr_usu_modificacion' => $this->tank_auth->get_user_id(), 'exr_fecha_modificacion' => date('Y-m-d H:i:s'));
                        $gif_upt += $this->gsatelite->actualizar_array("exr_estimacionxarticulo", $array_exr, array("exr_id_axo" => $key, "exr_id_esm IN ($esms)" => null)); 
                    }
                    if ($axm_upt > 0 || $mob_upt > 0 || $gif_upt) {
                        $amx = $this->gsatelite->get_suma('axm_articulo_matxarticulo_ord', 'axm_id_art_materia', array('axm_id_axo' => $key));
                        $mob = $this->gsatelite->get_suma('mxo_mano_obraxarticulo_ord', '(mxo_cantidad * mxo_precio)', array('mxo_id_axo' => $key));
                        $array_axo = array(
                            'axo_cantidad' => $value['ctdad_real_prod'], 
                            // 'axo_total_materia_prima' => ($value['ctdad_real_prod'] * $amx),
                            // 'axo_total_mano_obra' => $mob,
                            // 'axo_total_gastos' => $pdte_gif
                            // 'axo_total' => $pdte_suma,
                            'axo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'axo_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $axo_upt += $this->gsatelite->actualizar_array("axo_articuloxorden", $array_axo, array("axo_id" => $key)); 
                    }
                }
                if ($axo_upt > 0) {
                    $array_orden = array(
                        "ord_estado" => 2,
                        "ord_fecha_ejecucion" => date('Y-m-d H:i:s'),
                        "ord_usu_modificacion" => $this->tank_auth->get_user_id(),
                        "ord_fecha_modificacion" => date('Y-m-d H:i:s')
                    );
                    $respuesta += $this->gsatelite->actualizar_array('ord_orden', $array_orden, array('ord_id' => $orden));
                }
            }            
        }        
        if($respuesta > 0){
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cierre de Orden", 'texto_alerta' => "La orden fue procesada con éxito.");
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Cierre de Orden", 'texto_alerta' => "No se pudo finalizar la orden. Verifique que se hayan completado todas las etapas.");
        }
        $this->session->set_flashdata($alerta);
        echo json_encode(array('exitos' => $respuesta));
        die();
    }

    public function ingresos_empleado(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['total_empleados'] = $this->personal_model->listado_empleados(array('emp_estado' => 1));
            $titulo['titulo_personal'] = "Ingresos y Descuentos";
            $this->_cargarvista($data);
        }
    }

    public function ingresos_emp($id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['info'] = $info = $this->personal_model->info_empleado($id);
            $data['id_empleado_crud'] = $id;
            $nombre_empleado          = $data['info'][0]['emp_apellido'] . ', ' . $data['info'][0]['emp_nombre'];
            $data['ver_ingresos']     = $this->personal_model->ingresos_empleado($id);
            $data['ver_descuentos']   = $this->personal_model->descuentos_empleado($id);

            if ($data['info'][0]['emp_salario'] <= 0) {
                $data['tipo_ingreso'] = $this->personal_model->tipo_ingreso(null, null, true);
            } else {
                $data['tipo_ingreso'] = $this->personal_model->tipo_ingreso();
            }
            $data['titulo_personal'] = "Ingresos y descuentos <b style='font-size:14px;'>($nombre_empleado)</b>";
            $data['tipo_descuento']  = $this->personal_model->tipo_descuento();
            $data['estado']          = $this->personal_model->tipo_descuento();
            $ids_tpl  = array(0);
            $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id));
            foreach ($pregunta as $fila) {$ids_tpl[] = $fila['txe_id_tpl'];}
            $this->db->where_in('tpl_id', $ids_tpl);
            $select                = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, null, '', 'tpl_id', true);
            $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $id_descuento_isss                                      = $this->gsatelite->get_parametro('DESCUENTO_ISS');
            $configuracion_incapacidad                              = explode('##', $this->gsatelite->get_parametro('CONFIGURACION_INCAPCIDAD_EMPLEADO'));
            $data['n_dias_cubierto_empresa']                        = $configuracion_incapacidad[0];
            $data['porcentaje_n_dias_cubierto_empresa']             = $configuracion_incapacidad[1];
            $data['porcentaje_n_dias_cubierto_empresa_adicionales'] = $configuracion_incapacidad[2];
            $data['porcentaje_n_dias_cubierto_seguro_adicionales']  = $this->gsatelite->get_parametro('PORCENTAJE_INCAPACIDA_SEGURO');
            $registro_isss                = $this->gsatelite->get_tabla('tdc_tipo_descuento', array('tdc_id' => $id_descuento_isss));
            $salario_base_calculo          = ($data['info'][0]['emp_salario'] > $registro_isss[0]['tdc_maximo']) ? $registro_isss[0]['tdc_maximo'] : $data['info'][0]['emp_salario'];
            $data['salario_base_calculo']  = $salario_base_calculo;
            $data['salario_base_empleado'] = $data['info'][0]['emp_salario'];
            $per = false;
            $c   = ($this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA') != '') ? $this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA') : null;
            if ($c != null) {
                $array_id = explode(',', $c);
                if (in_array($this->tank_auth->get_user_id(), $array_id)) {
                    $per = true;
                }
            }
            $data['permiso_param'] = $per;
            $proyectos_reg         = $this->compras_model->get_proyectos(array('pcl_estado' => 1, 'cli_estado' => 1, 'epr_cierre' => 0));
            $select_proyecto       = '<option value=""></option>';
            foreach ($proyectos_reg as $key) {
                $selected = '';
                if ($rxi_id != null) {
                    $selected = ($data['requisicion_data'][0]['rxi_id_pcl'] == $key['pcl_id']) ? 'selected' : '';
                }
                $nombre_cliente = (trim($key['cli_personeria']) == 1) ? trim($key['cli_nombre'] . ' ' . $key['cli_apellido']) : trim($key['cli_apellido']);
                $nombre         = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
                $select_proyecto .= '<option value="' . $key['pcl_id'] . '" data-cliente="' . $nombre_cliente . '" ' . $selected . '>' . $nombre . '</option>';
            }
            $data['proyectos'] = $select_proyecto;
            $this->_cargarvista($data);
        }    
    }

    function nuevo_ingreso() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($this->input->post('id_emp') <= 0 || $this->input->post('tipo_planilla_in') <= 0 || $this->input->post('tipo_ingreso') <= 0) {
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"No se registro el ingreso",'texto_alerta'=>"Verifique la informacion a ingresar");
                $this->session->set_flashdata($alerta);
                redirect('proyectos/procesos/ingresos_empleado');
            }
            $fecha1 = str_replace('/', '-', $this->input->post('fecha_desde_in') );
            $fecha1 = date("Y-m-d",strtotime($fecha1));
            $emp    = $this->input->post('id_emp');
            $fac_cn = (float)$this->input->post('factor_conv');
            $monto  = (float)$this->input->post('monto_aumentar');
            $valor  = $monto * $fac_cn;
            $ingreso = array(
                'inn_id_emp'      => $this->input->post('id_emp'),
                'inn_id_tpl'      => $this->input->post('tipo_planilla_in'),
                'inn_id_tig'      => $this->input->post('tipo_ingreso'),
                'inn_referencia'  => $this->input->post('txt_referencia_desde_in'),
                'inn_motivo'      => $this->input->post('con_ingreso'),
                'inn_observacion' => $this->input->post('observaciones_in'),
                'inn_permanente'  => ($this->input->post('permanente_in')==1)? 1:0,
                'inn_valor'       => $valor,
                'inn_fecha_desde' => $fecha1,
                'inn_id_psp'      => ($this->input->post('slc_presupuesto') != '')?$this->input->post('slc_presupuesto'):null, 
                'inn_id_acg'      => ($this->input->post('slc_actividad_general') != '')?$this->input->post('slc_actividad_general'):null,
                'inn_id_ace'      => ($this->input->post('slc_actividad_espeficifica') != '')?$this->input->post('slc_actividad_espeficifica'):null,
                'inn_cuota'=> $this->input->post('cuotas_in'),
                'inn_cuota_pagada'=> 0,
                'inn_estado'=> $this->input->post('estado_in'),
                'inn_fecha_crea'=> date("Y-m-d H:i:s"),
                'inn_usu_crea'=> $this->tank_auth->get_user_id(),
                'inn_fecha_mod'=> date("Y-m-d H:i:s"),
                'inn_usu_mod'=> $this->tank_auth->get_user_id()
            );
            $existe = $this->gsatelite->get_tabla("inn_ingreso",$ingreso);
            if($existe) {
                $alerta = array('tipo_alerta'=> 'error','titulo_alerta'=>"Ingreso existente",'texto_alerta'=>"Verifique la informacion a ingresar");
                $this->session->set_flashdata($alerta);
                redirect('proyectos/procesos/ingresos_emp/'.$emp);
            }
            $this->db->insert('inn_ingreso', $ingreso);
            $inn_id = $this->db->insert_id();
            $urls = $this->input->post('ruta2');
            $names = $this->input->post('ruta');
            $max = count($names)/2;
            $i = 0;
            foreach ($urls as $key => $value2) {
                if ($i < $max ) {
                    $this->db->insert('axg_anexo_ingreso', array(
                        'axg_id_inn' => $inn_id,
                        'axg_nombre' => $names[$i],
                        'axg_url' => $value2,
                        'axg_estado' =>1,
                        'axg_fecha_creacion' => date('Y-m-d H:i:s'),
                        'axg_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'axg_usu_creacion' => $this->tank_auth->get_user_id(),
                        'axg_usu_modificacion' => $this->tank_auth->get_user_id()
                    ));
                }
                $i++;
            }
            if (!empty($inn_id)){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Inserción de ingreso completo",'texto_alerta'=>"Puede ver el ingreso en la pestaña de ver ingresos");
                $this->session->set_flashdata($alerta);
            } else {
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"No se registro el ingreso",'texto_alerta'=>"Verifique la informacion a ingresar");
                $this->session->set_flashdata($alerta);
            }
            redirect('proyectos/procesos/ingresos_emp/'.$emp);
        }
    }

    function edit_ingresos($id_emp = null, $id_est = 1, $estado_emp=1, $read_only = false) {
        satelite_validar();
        $arreglo_tipo_planilla_empleado=array();
                $this->db->join('tpl_tipo_planilla','tpl_id=txe_id_tpl');
        $pregunta=$this->gsatelite->get_tabla('txe_tipo_planillaxempleado',array('txe_id_emp'=>$id_emp));
        foreach ($pregunta as $fila) { $arreglo_tipo_planilla_empleado[$fila['txe_id_tpl']]= $fila['tpl_nombre'];   }
        $data['aplica_incapacidad'] = false;
        $url_registro = explode('/',uri_string());
        if(end($url_registro)>0 and prev($url_registro)=='edit') {
            $id_ing = end($url_registro);
            $es_incapacidad = $this->gsatelite->get_tabla('inc_incapacidad',array('inc_id_inn'=>$id_ing));
            $data['aplica_incapacidad'] = (count($es_incapacidad)>0) ? true : false;
            $query = $this->db->select('pla_id, inn_id, ddi_id_inn, pla_estado')
                ->from('pla_planilla')
                ->join('ddi_detalle_ingreso','pla_id=ddi_id_pla')
                ->join('inn_ingreso','inn_id= ddi_id_inn')
                ->where('ddi_id_inn',$id_ing)
                ->where('pla_estado', 3)
                ->get()
            ;
            $result = $query->row();
        }
        if(count($result)>0){
            $edit=array('inn_id_tpl','inn_id_tig','inn_motivo','inn_observacion','inn_valor','inn_estado','inn_usu_mod','inn_fecha_mod');
        }else{
            $edit=array('inn_id_tpl','inn_id_tig', 'inn_motivo','inn_observacion','inn_valor','inn_estado','inn_usu_mod','inn_fecha_mod');
        }
        $crud = new grocery_CRUD();
        $crud->set_table('inn_ingreso')
            ->set_subject('Listado de Ingresos')
            ->columns('inn_id_tpl','inn_id_tig','inn_motivo','inn_observacion','inn_fecha_desde','inn_valor','inn_estado','auditoria')
            ->set_relation('inn_id_tig', 'tig_tipo_ingreso', 'tig_nombre',null)
            ->edit_fields($edit)
            ->display_as('inn_motivo', 'Concepto')
            ->display_as('inn_observacion', 'Observación')
            ->display_as('inn_valor', 'Monto')
            ->display_as('inn_permanente', 'Permanente')
            ->display_as('inn_estado', 'Estado')
            ->display_as('inn_id_tpl', 'Tipo Planilla')
            ->display_as('inn_id_tig', 'Tipo de ingreso')
            ->display_as('inn_fecha_desde', 'Fecha Inicio')
            ->display_as('auditoria', 'Crea/Modifica')
            ->required_fields('inn_id_tpl','inn_id_tig','inn_motivo','inn_valor','inn_permanente','inn_estado','inn_usu_mod','inn_fecha_mod')
            ->set_rules('inn_valor','Monto','required|is_numeric')
            ->field_type('inn_usu_mod', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('inn_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('inn_estado', 'dropdown', array(1=>'Activo',0=>'Inactivo'))
            ->field_type('inn_id_tpl', 'dropdown', $arreglo_tipo_planilla_empleado)
            ->field_type('inn_permanente', 'dropdown', array(1=>'Sí',0=>'No'))
            ->where('inn_id_emp',$id_emp)
            ->where('inn_estado', $id_est)
            ->unset_add()
            ->unset_delete()
            ->unset_export()
            ->unset_print()
            ->callback_column('inn_fecha_desde',function($value, $row){
                return date("d-m-Y",strtotime($value));
            })
            ->callback_column('auditoria',function($value, $row){
                $ids = array();
                $ids[] = ($row->inn_usu_crea) ? $row->inn_usu_crea:0;
                $ids[] = ($row->inn_usu_mod)? $row->inn_usu_mod:0;
                $CI = & get_instance();
                $auditoria = $CI->personal_model->auditoria_ingreso_descuento($ids);
                return $auditoria;     
            })
        ;
        if ($estado_emp==1) {
            if ($read_only == null) {
                $crud->add_action('Editar', '', "proyectos/procesos/edit_inn/$id_emp/$id_est",'icomoon-icon-pencil-2 ver_en_modal');
                // $crud->add_action('Eliminar', '', 'personal/empleado/eliminar_ingreso_crud',' icomoon-icon-remove');//SOLO ELIMINAR DESDE PLANILLAS
            }else{
                $crud->unset_operations();
            }
        } else {
            $crud->unset_operations();
        }
        $output = $crud->render();
        $data['id_empleado'] = $id_emp;
        $this->gsatelite->cargar_vista_masterpage('personal/empleado/mantenimiento_edit_ingresos',$data,$output);
    }

    function edit_inn($id_emp = null, $id_est = null, $ingreso_id = null){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $inn_id = $this->input->post('id_inn');
                $fac_cn = (float)$this->input->post('factor_conv_i');
                $monto  = (float)$this->input->post('monto_aumentar');
                $valor  = $monto * $fac_cn;
                $psp    = ($this->input->post('slc_presupuesto') != '')?$this->input->post('slc_presupuesto'):null;
                $acg    = ($this->input->post('slc_actividad_general')!= '')?$this->input->post('slc_actividad_general'):null;
                $ace    = ($this->input->post('slc_actividad_espeficifica') != '')?$this->input->post('slc_actividad_espeficifica'):null;

                $editar = array(
                    'inn_permanente' => ($this->input->post('permanente_in') != "") ? $this->input->post('permanente_in') : 0,
                    'inn_id_tig' => $this->input->post('tipo_ingreso'),
                    'inn_motivo' => $this->input->post('con_ingreso'),
                    'inn_id_psp' => $psp,
                    'inn_id_acg' => $acg,
                    'inn_id_ace' => $ace,
                    'inn_id_tpl' => $this->input->post('tipo_planilla_in'),
                    'inn_valor' => str_replace(',', '', $valor),
                    'inn_fecha_desde' => date('Y-m-d',strtotime($this->input->post('fecha_desde_in'))),
                    'inn_cuota' => ($this->input->post('permanente_in') == 1) ? 0 : $this->input->post('cuotas_in'),
                    'inn_observacion' => $this->input->post('observaciones_in'),
                    'inn_estado' => ($this->input->post('estado_in')>0)? 1:0,
                    'inn_usu_mod' => $this->tank_auth->get_user_id(),
                    'inn_fecha_mod' => date('Y-m-d h:i:s') 
                );
                $respuesta = $this->gsatelite->actualizar_array('inn_ingreso', $editar, array('inn_id'=>$inn_id));

                $urls=$this->input->post('ruta2');
                $names=$this->input->post('ruta');
                $i=0;
                foreach ($urls as $key => $value2) {
                    $this->db->insert('axg_anexo_ingreso', array(
                        'axg_id_inn' => $inn_id,
                        'axg_nombre' => $names[$i],
                        'axg_url' => $value2,
                        'axg_estado' =>1,
                        'axg_fecha_creacion' => date('Y-m-d H:i:s'),
                        'axg_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'axg_usu_creacion' => $this->tank_auth->get_user_id(),
                        'axg_usu_modificacion' => $this->tank_auth->get_user_id()));
                    $i++;
                }
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registro Ingresado",'texto_alerta'=>"El registro se ha actualizado correctamente.");
                $this->session->set_flashdata($alerta);
                redirect('personal/empleado/mantenimiento_edit_ingresos');
            }else{
                $data['id_inn'] = $ingreso_id;
                $data['tipo_ingreso'] = $this->gsatelite->get_tabla('tig_tipo_ingreso',array('tig_estado'=>1));
                $this->db->where('txe_id_emp',$id_emp);
                $this->db->join('txe_tipo_planillaxempleado','txe_id_tpl=tpl_id');
                $data['planilla'] = $this->gsatelite->get_tabla('tpl_tipo_planilla');
                $ingreso = $this->gsatelite->get_tabla('inn_ingreso',array('inn_id'=>$ingreso_id));
                $factor  = $this->gsatelite->get_campo('tig_tipo_ingreso','tig_factor',array('tig_id'=>$ingreso[0]['inn_id_tig']));
                $data['ingreso'] = $ingreso;
                $per = false;
                $c   = ($this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA') != '')?$this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA'):null;
                if ($c != null) {
                    $array_id = explode(',', $c);
                    if (in_array($this->tank_auth->get_user_id(), $array_id)) {
                        $per = true;
                    }
                }                   
                $data['permiso_param'] = $per;
                $psp = ($ingreso[0]['inn_id_psp'] != '')?$ingreso[0]['inn_id_psp']:null;
                $acg = ($ingreso[0]['inn_id_acg'] != '')?$ingreso[0]['inn_id_acg']:null;
                $ace = ($ingreso[0]['inn_id_ace'] != '')?$ingreso[0]['inn_id_ace']:null;
                $proyectos_reg = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
                $select_proyecto = '<option value=""></option>';
                foreach ($proyectos_reg as $key) {
                    $selected = '';
                    if($psp != null){
                        $proye    = $this->gsatelite->get_campo('psp_presupuesto','psp_id_pcl',array('psp_id' => $psp));
                        $selected = ($proye == $key['pcl_id'])?'selected':'';
                    }
                    $nombre_cliente = (trim($key['cli_personeria']) == 1)?trim($key['cli_nombre'].' '.$key['cli_apellido']):trim($key['cli_apellido']);
                    $nombre = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
                    $select_proyecto .= '<option value="'.$key['pcl_id'].'" data-cliente="'.$nombre_cliente.'" '.$selected.'>'.$nombre.'</option>';
                }
                $data['proyectos'] = $select_proyecto;
                $proyec  = $this->gsatelite->get_campo('psp_presupuesto','psp_id_pcl',array('psp_id' => $psp));
                $slc_presupuesto            = ($psp != "" )?$this->get_presupuestoxproyecto($proyec, $psp) : '<option value=""></option>';
                $data['presupuesto']        = $slc_presupuesto;
                $slc_general                = ($acg != "" )?$this->get_actividades_generalesxpresupusto($psp, $acg) : '<option value=""></option>';
                $data['general']            = $slc_general;
                $slc_especifica             = ($ace != "" )?$this->get_actividades_especificas_x_actividad_general($acg, $psp, $ace,true):'<option value=""></option>';
                $data['especifica']         = $slc_especifica;
                $data['factor']  = ($factor != null && $factor != '') ? $factor : '1.00';
                $data['mod_pro'] = 1;
                $data['anexos']  = $this->gsatelite->get_tabla('axg_anexo_ingreso',array('axg_id_inn'=>$ingreso_id));
                $titulo['titulo_personal'] = "Ingresos";
                $this->gsatelite->cargar_vista_masterpage('personal/empleado/editar_ingreso',$data,true);
            }
        }
    }

    public function get_presupuestoxproyecto($proyecto = "", $seleccionado = "") {
        $where = array(
            'psp_estado'            => 1,
            'psp_id_pcl'            => $proyecto,
            'psp_estado_prespuesto' => 2
        );
        $presupuestos   = $this->gsatelite->get_tabla("psp_presupuesto",$where);
        $html           = '<option value=""></option>';
        foreach ($presupuestos as $value) {
            $selected   = "";
            if ( $value['psp_id'] == $seleccionado) {
                $selected = "selected";
            }
            $html .= '<option value="'.$value['psp_id'].'" '.$selected.'>'.$value['psp_nombre'].'</option>';
        }
        return trim($html);       
    }

    public function get_actividades_generalesxpresupusto($presupuesto = "", $seleccionado = "") {
        satelite_validar();
        $where = array(
            'dps_estado'    => 1,
            'dps_id_psp'    => $presupuesto
        );
        $select = "*, (SUM(dps_presupuesto_actividad) - IFNULL((SELECT SUM(dgp_monto) FROM dgp_detalle_gasto_prespuesto WHERE dgp_id_dps = dps_id AND dgp_estado = 1), 0)) AS total,
        (SELECT IFNULL((SUM(orc_total) - SUM(dpv_total)) + SUM(dpv_monto_pendiente), 0) FROM orc_orden_compra LEFT JOIN dpv_documento_proveedor ON dpv_id_orc = orc_id
        WHERE orc_id_psp = dps_id_psp AND orc_id_acg = dps_id_acg AND dpv_id = NULL) AS monto_comprometido, (SELECT GROUP_CONCAT(uxa_id_usu) FROM uxa_usuarioxactividad_general
        WHERE uxa_id_acg = acg_id) AS usuarios";
        $group_by               = "acg_id";
        $actividades_generales  = $this->compras_model->get_actividades_x_presupusto($select, $where, $group_by); 
        $html                   = '<option value=""></option>';
        foreach ($actividades_generales as $value) {
            $selected           = "";
            $usuarios_permitidos = array( $this->tank_auth->get_user_id() );
            $disponible = $value['total'] - $value['monto_comprometido'];
            if ( $value['acg_id'] == $seleccionado) {
                $selected = "selected";
            }
            if ( in_array( $this->tank_auth->get_user_id(), $usuarios_permitidos ) ) {
                $html .= '<option value="'.$value['acg_id'].'" '.$selected.'>'.$value['acg_codigo'].' - '.$value['acg_nombre'].' ($'.number_format($disponible,2,".",",").')</option>';
            }
        }
        return trim($html);
    }

    public function get_actividades_especificas_x_actividad_general($general = "", $presupuesto = "", $seleccionado = "", $edicion = false, $evaluar_post = true, $evaluar_usuario = true){
        satelite_validar();
        $periodo    = date('Ym');
        $fecha      = date('Y-m-d');
        $where = array(
            'dps_estado'    => 1,
            'dps_id_psp'    => $presupuesto,
            'dps_id_acg'    => $general
        );
        $group_by               = "ace_id";
        $actividades_generales  = $this->compras_model->get_actividades_especificas_x_actividad_general($fecha, $periodo, $where, $group_by);  
        $html                   = '<option value=""></option>';
        foreach ($actividades_generales as $value) {
            $selected           = "";
            $usuarios_permitidos = array( $this->tank_auth->get_user_id() );
            if ($evaluar_usuario == true) {
                $usuarios_permitidos= explode(",",$value['usuarios_permitidos']); 
            } 
            $disponible         = ($value['total'] - $value['monto_comprometido']) ;
            $disponible_mensual = "";
            $disponible_mensual = $value['permitido'] - ($value['monto_comprometido_mensual'] + $value['monto_pagado_mensual']);
            $disponible_mensual = number_format($disponible_mensual,2,".",",");
            if ( $value['ace_id'] == $seleccionado) {
                $selected = "selected";
            }
            if ( in_array( $this->tank_auth->get_user_id(), $usuarios_permitidos ) ) {
                if ($disponible > 0 or $edicion == true) {
                    $html .= '<option data-monto_disponible_mensual="'.$disponible_mensual.'" data-monto_disponible="'.number_format($disponible,2,".","").'" data-nombre="'.$value['ace_nombre'].'" value="'.$value['ace_id'].'" '.$selected.'>'.$value['ace_codigo'].' - '.$value['ace_nombre'].' ('.number_format($disponible,2,".",",").')</option>';
                }
            }
        }
        return trim($html);
    }

// End of class
}