<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Mantenimientos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('proyecto_model');
        $this->load->model('inventario_model');
        $this->load->model('cotizaciones_model');
        $this->load->model('gsatelite');
        $this->load->model('personal_model');
        $this->load->model('expediente_personal_model');
        //$this->load->library('../controllers/cotizaciones/cotizaciones');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }


    /* Descripción:
     * Función para dar mantenimiento de Marcas (tabla: mrp_marca_producto)
     * Funcionalidad Compartida del Modulo de inventario - Marcas
     * @param ninguno
     * @return Mantenimiento de Marcas
     */
    public function marcas_productos(){
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->marca_producto();
    }

    /* Descripción:
     * Función para dar mantenimiento de Tipos de Clientes (tabla: tpc_tipo_cliente)
     * @param ninguno
     * @return Mantenimiento de Marcas
     */
    public function tipo_cliente() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $crud = new grocery_CRUD();
            $crud->set_table('tpc_tipo_cliente');
            $crud->set_subject('Tipos de cliente');
            $crud->fields('tpc_nombre', 'tpc_descripcion', 'tpc_estado', 'tpc_usu_mod', 'tpc_fecha_mod', 'tpc_usu_crea', 'tpc_fecha_crea');
            $crud->required_fields('tpc_nombre', 'tpc_estado');
            $crud->columns('tpc_nombre', 'tpc_descripcion');
            $crud->display_as('tpc_nombre', 'Nombre');
            $crud->display_as('tpc_descripcion', 'Descripción');
            $crud->field_type('tpc_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tpc_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('tpc_usu_crea', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tpc_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
            $crud->set_rules('tpc_nombre', 'Nombre', 'trim|required|campo_unico[tpc_tipo_cliente.tpc_nombre]');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tpc_estado', 'hidden', 1);
            } else {  // Editar
                $crud->field_type('tpc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Tipos de clientes";
            $this->_cargarvista($data, $output);
        }
    }

    function factores_calidad(){
        satelite_validar();
        $crud = new grocery_CRUD();
        $crud->set_table('fcc_factor_calidad')
                ->set_subject('Factores de calidad')
                ->columns('fcc_nombre','fcc_descripcion','fcc_unidad','fcc_estado')
                ->display_as('fcc_nombre','Nombre')
                ->display_as('fcc_descripcion','Descripción')
                ->display_as('fcc_unidad','Unidad')
                ->display_as('fcc_estado','Estado')
                ->required_fields('fcc_nombre', 'fcc_estado')
                ->set_rules('fcc_nombre', 'Nombre', 'trim|required|campo_unico[fcc_factor_calidad.fcc_nombre]')
                ->field_type('fcc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('fcc_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('fcc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('fcc_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
        ;
        $crud->add_fields('fcc_nombre', 'fcc_descripcion', 'fcc_unidad', 'fcc_usu_creacion', 'fcc_usu_modificacion', 'fcc_fecha_creacion', 'fcc_fecha_modificacion', 'fcc_estado');
        $crud->edit_fields('fcc_nombre', 'fcc_descripcion', 'fcc_unidad', 'fcc_usu_modificacion', 'fcc_fecha_modificacion', 'fcc_estado');
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('fcc_estado', 'hidden', 1);
        } else {  // Editar
            $crud->field_type('fcc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $data['titulo_personal'] = "Factores de calidad";
        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    function condicion() {

        satelite_validar();

        $crud = new grocery_CRUD();
        $crud->set_table('cod_condicion')
                ->set_subject('condición')
                ->columns('cod_nombre', 'cod_descripcion', 'cod_estado')
                ->display_as('cod_nombre', 'Nombre')
                ->display_as('cod_descripcion', 'Descripción')
                ->display_as('cod_estado', 'Estado')
                ->required_fields('cod_nombre', 'cod_estado')
                ->set_rules('cod_nombre', 'Nombre', 'trim|required|campo_unico[cod_condicion.cod_nombre]')
                ->field_type('cod_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('cod_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('cod_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('cod_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
        ;

        $crud->add_fields('cod_nombre', 'cod_descripcion', 'cod_usu_crea', 'cod_usu_mod', 'cod_fecha_crea', 'cod_fecha_mod', 'cod_estado');
        $crud->edit_fields('cod_nombre', 'cod_descripcion', 'cod_usu_mod', 'cod_fecha_mod', 'cod_estado');

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('cod_estado', 'hidden', 1);
        } else {  // Editar
            $crud->field_type('cod_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $data['titulo_personal'] = "Condiciones";

        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    function sector_cliente() {

        satelite_validar();

        $crud = new grocery_CRUD();
        //Columnas a mostrar en READ
        $columns = array(
            'sec_nombre',
            'sec_estado',
        );

        //Alias para las columnas
        $alias = array(
            'sec_nombre' => 'Nombre',
            'sec_estado' => 'Estado',
        );

        //Columnas a mostrar en ADD
        $add_columns = array(
            'sec_nombre',
            'sec_estado',
            'sec_fecha_mod',
            'sec_usu_mod',
        );

        //Columnas a mostrar en EDIT
        $edit_columns = $add_columns;

        $crud->set_table('sec_sector_cliente')
                ->set_subject('Sector cliente')
                ->where('sec_estado <>', -1)
                ->unset_delete()
                ->columns($columns)
                ->display_as($alias)
                ->add_fields($add_columns)
                ->edit_fields($edit_columns)
                ->required_fields($add_columns)
                ->field_type('sec_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('sec_nombre', 'Nombre', 'trim|required|campo_unico[sec_sector_cliente.sec_nombre]')
                ->field_type('sec_usu_mod', 'hidden', $this->tank_auth->get_user_id());

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('sec_estado', 'hidden', 1);
        } else {
            $crud->field_type('sec_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }


        $output = $crud->render();

        $data['titulo_personal'] = "Sector cliente";
        $this->_cargarvista($data, $output);
    }

    function segmento_cliente() {

        satelite_validar();

        try {
            $crud = new grocery_CRUD();
            //Columnas a mostrar en READ
            $columns = array(
                'cac_nombre',
                'cac_comision',
                'cac_estado',
            );

            //Alias para las columnas
            $alias = array(
                'cac_nombre' => 'Nombre',
                'cac_estado' => 'Estado',
                'cac_comision' => 'Comisión %',
            );

            //Columnas a mostrar en ADD
            $add_columns = array(
                'cac_nombre',
                'cac_estado',
                'cac_comision',
                'cac_fecha_mod',
                'cac_usu_mod',
            );

            //Columnas a mostrar en EDIT
            $edit_columns = $add_columns;

            $crud->set_table('cac_cartera_cliente')
                    ->set_subject('Segmento de cliente')
                    ->where('cac_estado <>', -1)
                    ->unset_delete()
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->required_fields($add_columns)
                    ->field_type('cac_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->set_rules('cac_nombre', 'Nombre', 'trim|required|campo_unico[cac_cartera_cliente.cac_nombre]')
                    ->set_rules('cac_comision', 'Comisión', 'trim|required|is_numeric')
                    ->field_type('cac_usu_mod', 'hidden', $this->tank_auth->get_user_id());

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('cac_estado', 'hidden', 1);
            } else {
                $crud->field_type('cac_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
            }

            $output = $crud->render();

            $data['titulo_personal'] = "Segmento de cliente";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * Cotizaciones::clientes()
     * 
     * @return vista de la tabla clientes 
     * (solo para redireccionar a diversas acciones como ver los contactos, dar seguimiento y ver cotizacioens)
     */
    function cliente($modal = 'no', $otro_modulo = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos = $this->gsatelite->get_permisos_opcion();
                $datos = array();
                //preguntar si el usuario es supervisor o vendedor
                $condicion1 = array('sup_id_usu' => $this->tank_auth->get_user_id(), 'sup_estado' => 1);
                $esSup = $this->cotizaciones_model->Existe_Registro("sup_supervisor", $condicion1);
                $condicion2 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
                $esVen = $this->cotizaciones_model->Existe_Registro("ven_vendedor", $condicion2);

                $cli_id = end(explode('/', uri_string()));
                if ($cli_id > 0) {
                    $datosCliente = $this->cotizaciones_model->get_registro('cli_cliente', 'cli_id', $cli_id);
                    $id_vendedor = $datosCliente->cli_id_ven;
                } else {
                    $id_vendedor = "0";
                }
                $crud = new grocery_CRUD();
                //Columnas a mostrar en READ
                $columns = array(
                    'cli_codigo',
                    'cli_nombre',
                    'cli_apellido',
                    'cli_direccion',
                    'Documento',
                    'Teléfono',
                    'Contacto',
                    'cli_observacion',
                    'cli_estado'
                );

                //Alias para las columnas
                $alias = array(
                    'cli_codigo' => 'Código',
                    'cli_nombre' => 'Razón comercial',
                    'cli_apellido' => 'Razón social',
                    'cli_email' => 'E-mail',
                    'cli_estado' => 'Estado',
                    'cli_personeria' => 'Personería',
                    'cli_observacion' => 'Observación',
                    'cli_sitio_web' => 'Sitio Web',
                    'cli_id_sec' => 'Sector',
                    'cli_id_cac' => 'Cartera',
                    'cli_id_ven' => 'Vendedor',
                    'cli_id_tmc' => 'Medio de contacto',
                    'cli_id_tpc' => 'Tipo de cliente',
                    'cli_direccion' => 'Direccion'
                );

                //Columnas a mostrar en ADD
                $add_columns = array(
                    'cli_personeria',
                    'cli_nombre',
                    'cli_apellido',
                    // 'cli_razon_comercial',
                    'cli_email',
                    'cli_observacion',
                    'cli_id_sec',
                    'cli_id_cac',
                    'cli_id_ven',
                    'cli_sitio_web',
                    'cli_id_tmc',
                    'cli_estado',
                    'cli_fecha_mod',
                    'cli_usu_mod',
                    'cli_id_tpc'
                );

                $required_fields = array(
                    'cli_apellido',
                    'cli_id_ven',
                    'cli_estado',
                    'cli_id_sec',
                    'cli_id_cac',
                    'cli_id_tmc',
                    'cli_personeria'
                );

                //Columnas a mostrar en EDIT
                $edit_columns = $add_columns;
                $crud->set_table('cli_cliente')
                        ->set_subject('')
                        ->where('cli_estado <>', -1)
                        ->unset_delete()
                        ->columns($columns)
                        ->display_as($alias)
                        ->edit_fields($edit_columns)
                        ->set_relation('cli_id_sec', 'sec_sector_cliente', 'sec_nombre')
                        ->set_relation('cli_id_tpc', 'tpc_tipo_cliente', 'tpc_nombre')
                        ->set_relation('cli_id_cac', 'cac_cartera_cliente', 'cac_nombre')
                        ->set_relation('cli_id_tmc', 'tmc_tipo_medio', 'tmc_nombre', array('tmc_estado' => 1))
                        //->unset_add()
                        ->field_type('cli_personeria', 'dropdown', array('1' => 'Natural', '2' => 'Jurídica'))
                        ->field_type('cli_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'))
                        ->set_rules('cli_email', 'Email', 'valid_email')
                        ->set_rules('cli_nombre', 'Nombre o Razón social', 'required')

                        /* ->set_rules('cli_id_ven','Vendedor','required')
                          ->set_rules('cli_estado','Estado','required')
                          ->set_rules('cli_id_sec','Sector','required')
                          ->set_rules('cli_id_cac','Cartera Cliente','required') */
                        ->required_fields($required_fields)
                ;

                $crud->callback_column('Documento', function($value, $row) {
                    $cliente = $row->cli_id;
                    $getPersoneria = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $cliente));
                    $getPersoneria = $getPersoneria[0]['cli_personeria'];
                    //QUEDO OBSOLETO ESTE PARAMETRO, porque si retorna un valor(revisar la BDD) deberia filtrar por el mismo, pero si se desea filtrar
                    //segun el tipo de personeria juridica se podria filtrar aunque si igual viene ese parametro no mostrara nada, asi que por eso.
                    //$tipo_documento =$this->gsatelite->get_parametro('SYS_TIPO_DOC');
                    $documento = $this->gsatelite->get_tabla('dcc_documento_cliente', array('dcc_id_cli' => $cliente, 'dcc_estado' => 1));
                    return (isset($documento[0]['dcc_valor'])) ? $documento[0]['dcc_valor'] : null;                    
                });

                $crud->callback_column('Contacto', function($value, $row) {
                    $cliente = $row->cli_id;
                    $conta = $this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $cliente, 'con_estado' => 1));
                    if (count($conta)>0) {
                        return $conta[0]['con_nombre'].' '.$conta[0]['con_apellidos'];
                    }else{
                        return false;
                    }
                });


                $crud->callback_column('Teléfono', function($value, $row) {
                    $cliente = $row->cli_id;
                    //txc_telefonoxcliente
                    $telefonos = $this->gsatelite->get_tabla('txc_telefonoxcliente', array('txc_id_cli' => $cliente));
                    //$telefonos=$this->cotizaciones_model->get_telxcliente($cliente);
                    if(count($telefonos) > 0){
                        return $telefonos[0]['txc_numero'];
                    } else{
                        return null;
                    }
                });
                // ->add_action('Ver Cotizaciones', '', 'cotizaciones/cotizaciones/cotizacion_cliente','icomoon-icon-file')
                if ($permisos['permite_editar']) {
                    $crud->add_action('Editar', '', 'proyectos/mantenimientos/editar_cliente', 'icomoon-icon-pencil-5');
                }
                //->add_action('Borrar', '', 'cotizaciones/mantenimientos/estado/ini?t=cli_cliente?clientes',' icomoon-icon-remove')
                $crud->field_type('cli_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('cli_usu_mod', 'hidden', $this->tank_auth->get_user_id());

                $crud->callback_column('cliente', function($value, $row) {
                    $str = $row->cli_nombre;
                    return $str;
                });

                $crud->callback_column('cli_razon_comercial', function($value, $row) {
                    if ($row->cli_apellido != '') {
                        $str = $row->cli_apellido;
                    } else {
                        $str = $row->cli_razon_comercial;
                    }
                    return $str;
                });
                if ($esSup > 0) { //es supervisor
                    $queryIdVen = $this->cotizaciones_model->get_idsVendedoresxSupervisor($this->tank_auth->get_user_id());
                    if ($id_vendedor != 0) {
                        if (!in_array($id_vendedor, (explode(',', $queryIdVen)))) {
                            $queryIdVen = "0";
                        }
                    }

                    $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', "ven_id in ( {$queryIdVen} )");
                } else if ($esVen > 0) { //es vendedor
                    $usu_id = $this->gsatelite->get_campo('ven_vendedor', 'ven_id_usu', array('ven_id' => $id_vendedor));
                    if ($id_vendedor != 0) {
                        if ($usu_id == $this->tank_auth->get_user_id()) {
                            $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => $this->tank_auth->get_user_id()));
                        } else {
                            $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => 0));
                        }
                    } else {
                        $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => $this->tank_auth->get_user_id()));
                    }
                } else {
                    $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => 0));
                }

                //se agrego where en la consulta  (Francisco Orozco 2017-01-13)
                $cli_id = 0;
                if ($_POST) {                    
                    $cliente_filtro    = $this->input->post('txt_cliente');
                    $segmento  = $this->input->post('slcSegmentos');
                    $documento_filtro  = $this->input->post('txt_documento');
                    $vendedor_filtro = $this->input->post('slcVendedor');
                    $clasific_filtro = $this->input->post('slcClasific');
                    $zona_filtro = $this->input->post('slcZona');
                    $departamento = $this->input->post('slc_dep');
                    $municipio = $this->input->post('slc_muni');
                    $where = $like = $like2 = null;

                    if($cliente_filtro != ""){
                        $where['cli_id'] = $cliente_filtro;    
                    }
                    if($vendedor_filtro != ""){
                        $where['cli_id_ven'] = $vendedor_filtro;
                    }
                    if($segmento != ""){
                        $where['cli_id_cac'] = $segmento;
                    }
                    if($zona_filtro != ""){
                        $where['cli_id_zog'] = $zona_filtro;
                    }
                    if($clasific_filtro != ""){
                        $where['cli_id_cfc'] = $clasific_filtro;
                    }                                        
                    if ( $cliente_filtro != "") {
                        $like = $cliente_filtro;
                    }
                    if ($documento_filtro != "") {
                        $like2['dcc_valor'] = $documento_filtro;
                    }
                    if ($departamento != '' && $municipio == '') {
                        $where["cli_id_mun IN (SELECT mun_id FROM mun_municipio WHERE mun_id_dep = $departamento)"] = NULL;
                    }
                    if($municipio != ""){
                        $where['cli_id_mun'] = $municipio;
                    } 
                    $clientes_array = $this->cotizaciones_model->get_clientes_like($where, null,$like2);
                   
                    if ( count($clientes_array) > 0 ) {
                        $cli_id = implode(',', array_unique(array_column($clientes_array, 'cli_id')));
                    }
                    if ($cli_id == ""){
                        $cli_id = 0;
                    }
                    $data_filtro['clientes'] = $this->clientes_x_segmento($segmento, true);
                    //$data_filtro['cliente_filtro']    = $cliente_filtro;
                    $data_filtro['documento_filtro']  = $documento_filtro; 
                } else {
                    $data_filtro['cliente_filtro']    = "";
                    $data_filtro['documento_filtro']  = "";
                }
                $crud->where('cli_id IN (' . $cli_id . ')');

                // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                $data_filtro['servicios'] = $this->gsatelite->get_tabla('art_articulo', array('art_estado' => 1, 'art_tipo' => 1) );

                if($_POST){
                    //Sector seleccionado
                    $select = $this->gsatelite->get_dropdown('cac_cartera_cliente', '{cac_nombre}', '', array('cac_estado' => 1), $segmento, '', 'cac_id', true);
                    $data_filtro["segmentos"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
                    //Cliente seleccionado                    
                    $cliente_selected = array();// $this->gsatelite->get_tabla('cli_cliente',array('cli_estado' => 1));
                    $data_filtro['cliente_slctd'] = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1, 'cli_id' => $cliente_filtro));
                    $client = '';
                    foreach ($cliente_selected as $cli) {
                        $seleccionado = ( $cli['cli_id'] ==  $cliente_filtro )? "selected" : "";
                        //$seleccionado = '';

                        if ($cli['cli_codigo'] != '') {
                            $codigo = trim($cli['cli_codigo']) . ' - ';
                        } else {
                            $codigo = '';
                        }                    
                        $nombre_cliente = ($cli['cli_personeria'] == 1) ? $codigo . $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $codigo . $cli['cli_apellido'];
                        $client .= '<option value="' . $cli['cli_id'] . '" '.$seleccionado.'>' . $nombre_cliente . '</option>';
                    }
                    $data_filtro['clientes'] = $client;
                    //vendedores
                    $select_v = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), $vendedor_filtro, '', 'ven_id', true);
                    $data_filtro["vendedores"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select_v);
                    //clasificaciones
                    $select_c = $this->gsatelite->get_dropdown('cfc_clasificacion_cliente', 'cfc_nombre', '', array('cfc_estado' => 1), $clasific_filtro, '', 'cfc_id', true);
                    $data_filtro["clasificaciones"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select_c);
                    //zonas
                    $select_z = $this->gsatelite->get_dropdown('zog_zona_geografica', 'zog_nombre', '', array('zog_estado' => 1), $zona_filtro, '', 'zog_id', true);
                    $data_filtro["zonas"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select_z);
                    //dep y mun

                    $select_d = $this->gsatelite->get_dropdown('dep_departamento', 'dep_nombre', '', array('dep_estado' => 1), $departamento, '', 'dep_id', true);
                    $data_filtro["departamento"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select_d);
                    $dpto = ($departamento != "") ? $departamento : 0;
                    $select_m = $this->gsatelite->get_dropdown('mun_municipio', 'mun_nombre', '', array('mun_estado' => 1, 'mun_id_dep' => $dpto), $municipio, '', 'mun_id', true);
                    $data_filtro["municipios"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select_m);
                    // var_dump($select_v);die();
                }else{                
                    //clientes
                    $clientes = array();// $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
                    $client = '';
                    foreach ($clientes as $cli) {
                        if ($cli['cli_codigo'] != '') {
                            $codigo = trim($cli['cli_codigo']) . ' - ';
                        } else {
                            $codigo = '';
                        }                    
                        $nombre_cliente = ($cli['cli_personeria'] == 1) ? $codigo . $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $codigo . $cli['cli_apellido'];
                        $client .= '<option value="' . $cli['cli_id'] . '">' . $nombre_cliente . '</option>';
                    }
                    $data_filtro['clientes'] = $client;
                    //"segmento"
                    $select = $this->gsatelite->get_dropdown('cac_cartera_cliente', '{cac_nombre}', '', array('cac_estado' => 1), null, '', 'cac_id', true);
                    $data_filtro["segmentos"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
                    //vendedores
                    $select_v = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), null, '', 'ven_id', true);
                    $data_filtro["vendedores"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select_v);
                    //clasificaciones
                    $select_c = $this->gsatelite->get_dropdown('cfc_clasificacion_cliente', 'cfc_nombre', '', array('cfc_estado' => 1), null, '', 'cfc_id', true);
                    $data_filtro["clasificaciones"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select_c);
                    //zonas
                    $select_z = $this->gsatelite->get_dropdown('zog_zona_geografica', 'zog_nombre', '', array('zog_estado' => 1), null, '', 'zog_id', true);
                    $data_filtro["zonas"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select_z);
                    //dep y mun
                    $select_d = $this->gsatelite->get_dropdown('dep_departamento', 'dep_nombre', '', array('dep_estado' => 1), null, '', 'dep_id', true);
                    $data_filtro["departamento"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select_d);
                    $data_filtro["municipios"] = "";
                }  
                $select = $this->gsatelite->get_dropdown('dep_departamento', 'dep_nombre', '', array('dep_estado' => 1), null, '', 'dep_id', true);
                $data_filtro["departamento"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                $data_filtro["new_filtros"] = true;             
                $datos['html_filtro_clientes'] = $this->load->view('cotizaciones/mantenimientos/filtro_clientes', $data_filtro, true);

                $datos['esmodal'] = '';
                $datos['titulo_personal'] = "Clientes";
                $crud->unset_edit();
                $output = $crud->render();
                $this->_cargarvista($datos, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * COPIA DEL MANTENIMIENTO DE CLIENTES DE CRM
     * NO ES POSIBLE USAR LA MISMA FUNCIONALIDAD POR CONFLICTOS YA QUE AMBOS CONTROLADORES SE LLAMAN IGUAL
     * */
    function nuevo_cliente($esmodal = null, $id_tabla = null, $otro_modulo = null) {
        satelite_validar();
        $condicion1 = array('sup_id_usu' => $this->tank_auth->get_user_id(), 'sup_estado' => 1);
        $esSup = $this->cotizaciones_model->Existe_Registro("sup_supervisor", $condicion1);
        $condicion2 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
        $esVen = $this->cotizaciones_model->Existe_Registro("ven_vendedor", $condicion2);
        $datos['doc_documentos'] = $this->personal_model->get_documentos();
        $tipos_doc = $this->expediente_personal_model->get_dropdown('tde_tipo_documento', '{tde_nombre}', '', array('tde_estado' => 1), null, '', 'tde_id', true);
        $datos['options_tipo_documento'] = str_replace('<option value="0">Seleccione</option>', '', $tipos_doc);
        // Obtener las Condiciones
        $datos['tipo_telefono'] = $this->gsatelite->get_tabla('tit_tipo_telefono', array('tit_id >' => 0));
        $datos['departamentos'] = $this->gsatelite->get_tabla('dep_departamento', array('dep_estado' => 1));
        //Tipo de lista de precio
        $datos['tipo_lista_precio'] = $this->gsatelite->get_tabla('tlp_tipo_lista_precio', array('tlp_estado' => 1));
        $datos['giros'] = $this->gsatelite->get_tabla('gir_giro', array('gir_estado' => 1));
        $datos['clasificaciones'] = $this->gsatelite->get_tabla('cfc_clasificacion_cliente', array('cfc_estado' => 1));
        //Centro de costos
        $datos["centro_costo"] = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
        //tipo de cuenta
        $datos["tipo_cuenta"] = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
        $datos["bancos"] = $this->gsatelite->get_dropdown('ban_banco', '{ban_nombre}', '', array('ban_estado' => 1), null, '', 'ban_id', true);
        //cuenta contable
        $datos["cuen_con"] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
        //zona geografias
        $datos["zonas"]     = $this->gsatelite->get_tabla("zog_zona_geografica",array("zog_estado" => 1) );
        //telefonos
        $datos['tipo_telefonos'] = $this->gsatelite->get_tabla('tit_tipo_telefono', array('tit_estado' => 1));
        $datos["tipos_tel"] = $this->gsatelite->get_dropdown('tit_tipo_telefono', '{tit_nombre}', '', array('tit_estado' => 1), null, '', '', true);
        if ($esSup > 0) { //es supervisor
            $queryIdVen = $this->cotizaciones_model->get_idsVendedoresxSupervisor($this->tank_auth->get_user_id());
            $datos['ids_ven'] = $queryIdVen;
            $datos['ven_selec'] = null;
        }
        if ($esVen > 0) { //es vendedor
            $ven_id = $this->gsatelite->get_campo('ven_vendedor', 'ven_id', array('ven_id_usu' => $this->tank_auth->get_user_id()));
            $datos['ids_ven'] = $ven_id;
            $datos['ven_selec'] = $ven_id;
        } else {
            $datos['ids_ven'] = 0;
            $datos['ven_selec'] = null;
        }
        $datos['base_datos'] = null;
        if ($esmodal) {
            $datos['esmodal'] = 1;
            if (isset($id_tabla)) {
                $datos['llamada_info'] = $this->gsatelite->get_registro('tbl_tabla_llamadas', array('tbl_id' => $id_tabla));
                $datos['medios'] = $this->gsatelite->get_tabla('txt_tabla_llamadaxtipo_medio', array('txt_id_tbl' => $id_tabla));
                $datos['giro'] = $this->gsatelite->get_tabla('gir_giro', array('gir_estado' => 1));
            }
            $this->gsatelite->cargar_vista_masterpage('cotizaciones/mantenimientos/nuevo_cliente', $datos);
        } else {
            $datos['titulo_personal'] = "Nuevo Cliente";
            if ($otro_modulo)
                return $datos;
            $this->_cargarvista($datos);
        }
    }

    /**
     * COPIA DEL MANTENIMIENTO DE CLIENTES DE CRM
     * NO ES POSIBLE USAR LA MISMA FUNCIONALIDAD POR CONFLICTOS YA QUE AMBOS CONTROLADORES SE LLAMAN IGUAL
     * */
    function guardar_cliente() {
        if ($_POST) {
            // var_dump($_POST);die();
            $esmodal = $this->input->post('es_agregar_modal'); // Este me sirve para diferenciar de donde vengo.
            $modal = $this->input->post('modal'); // Este me sirve para diferenciar de donde vengo.
            $id_tabla = $this->input->post('id_tabla');  // Actualizar tbl_tabla_llamadas
            $person = $this->input->post('personeria');
            $idstlp = $this->input->post('slc_tipo_lista_precio');
            //validacion de los dias plazo
            $tipo_vencimiento   = $this->input->post('slc_tipo_vencimiento');
            $tipo_vencimiento   = ($tipo_vencimiento == "") ? null : $tipo_vencimiento;
            $dias_plazo         = null;
            if ( $tipo_vencimiento  == 1) {
                $txt_dias_plazo =  $this->input->post('txt_dias_plazo');
                $dias_plazo = ( $txt_dias_plazo != "" and is_numeric( $txt_dias_plazo ) ) ? $txt_dias_plazo : null;
            } else if ( $tipo_vencimiento  == 2 ) {
                $slc_dia_especifico =  $this->input->post('slc_dia_especifico');
                $dias_plazo = ( $slc_dia_especifico != "" and is_numeric( $slc_dia_especifico ) ) ? $slc_dia_especifico : null;
            } else {
                $tipo_vencimiento = null;
            }
            $detalle = array(
                'cli_codigo' => (trim($this->input->post('codigo_cli')) != "")? trim($this->input->post('codigo_cli')):"", 
                'cli_id_sec' => ($this->input->post('sector') != "" && $this->input->post('sector') > 0) ? $this->input->post('sector') : null, 
                'cli_id_cac' => ($this->input->post('cartera') != "" && $this->input->post('cartera') > 0) ? $this->input->post('cartera') : null, 
                'cli_id_ven' => ($this->input->post('vendedor') != "") ? $this->input->post('vendedor') : null, 
                'cli_apellido' => trim($this->input->post('apellidos')), 
                'cli_nombre' => trim($this->input->post('nombres')), 
                'cli_nombre_comercio' => trim($this->input->post('nom_comercial')), 
                'cli_personeria' => $this->input->post('personeria'), 
                'cli_id_pro' => ($_POST['ocupacion']) ? $this->input->post('ocupacion') : null, 
                'cli_lugar_trabajo' => ($_POST['lugar_trabajo']) ? $_POST['lugar_trabajo'] : null, 
                'cli_cargo' => ($_POST['cargo']) ? $_POST['cargo'] : null, 
                'cli_persona_aut' => $_POST['persona_autorizada'], 
                'cli_observacion' => $this->input->post('observ'), 
                'cli_id_rtc' => ($this->input->post('ruta_cliente') != "") ? $this->input->post('ruta_cliente') : null, 
                'cli_es_gran_contribuyente' => $this->input->post('hdngranCont'), 
                'cli_id_mun' => (!empty($_POST['municipio'])) ? $_POST['municipio'] : NULL, 
                'cli_id_tif' => ($_POST['comprobante']) ? $_POST['comprobante'] : null, 
                'cli_factura_elect' => (isset($_POST['factura_electronica'])) ? 1 : null, 
                'cli_id_pai' => ($_POST['nacionalidad']) ? $_POST['nacionalidad'] : null, 
                'cli_id_tpg' => ($_POST['condicion'] != '') ? $_POST['condicion'] : null, 
                'cli_id_frp' => ($_POST['slc_forma_pago'] != '') ? $_POST['slc_forma_pago'] : null, 
                'cli_estado' => 1, 
                'cli_sitio_web' => $this->input->post('sitio_web'), 
                'cli_email' => $this->input->post('correo'), 
                'cli_usu_mod' => $this->tank_auth->get_user_id(), 
                'cli_fecha_mod' => date('Y-m-d H:i:s'), 
                'cli_fecha_crea' => date('Y-m-d H:i:s'), 
                'cli_usu_crea' => $this->tank_auth->get_user_id(), 
                'cli_direccion' => $this->input->post('direccion_cli'), 
                'cli_id_tpc' => ($this->input->post('tip_cliente') != "") ? $this->input->post('tip_cliente') : null, 
                'cli_id_gir' => ($this->input->post('giro') != "") ? $this->input->post('giro') : null, 
                'cli_representante' => ($_POST['representante']) ? $_POST['representante'] : null, 
                'cli_registro' => ($_POST['registro']) ? $_POST['registro'] : null, 
                'cli_fotografia' => ($this->input->post('foto_empleado') != "") ? "uploads/anexos_cliente/" . $this->input->post('foto_empleado') : null, 
                'cli_fecha_nacimiento' => ($_POST['txt_fecha_nacimiento'] != "") ? formatear_fecha('Y-m-d', $_POST['txt_fecha_nacimiento']) : null, 
                'cli_fecha_registro' => ($_POST['txt_fecha_registro'] != "") ? formatear_fecha('Y-m-d', $_POST['txt_fecha_registro']) : null, 
                'cli_id_cfc' => ($_POST['slc_clasificacion'] != "") ? $_POST['slc_clasificacion'] : null, 
                'cli_dias_plazo'          => $dias_plazo, 
                'cli_monto_credito'       => ($_POST['txt_monto_credito'] != "") ? $_POST['txt_monto_credito'] : null, 
                'cli_nombre_factura'      => ($_POST['txt_nombre_factura'] != "") ? $_POST['txt_nombre_factura'] : null, 
                'cli_descuento_sugerido'  => ($_POST['txt_descuento_sugerido'] != "")?$_POST['txt_descuento_sugerido'] : 0, 
                'cli_id_zog'              => ($_POST['slc_zona_geografica'] != "")?$_POST['slc_zona_geografica'] : null, 
                'cli_tipo_fac_vence'      => $tipo_vencimiento, 
                'cli_id_ban'            => ($_POST['slc_banco_paga'] != "") ? $_POST['slc_banco_paga'] : null, 
                'cli_encargado_pago'      => ($_POST['txt_encargado_pago'] != "") ? $_POST['txt_encargado_pago'] : null, 
                'cli_comentario_finanzas' => ($_POST['txt_comentario_adicional'] != "") ? $_POST['txt_comentario_adicional'] : null, 
                'cli_suspender_facturacion' => $_POST['hdn_suspende_fact']
            );
            $id_cliente = $this->gsatelite->ingresar('cli_cliente', $detalle);
            foreach ($idstlp as $key => $idtlp) {
                $tipo_precio_cliente_array = array(
                    'tpn_id_cli' => $id_cliente,
                    'tpn_id_tlp' => $idtlp,
                    'tpn_estado' => 1,
                    'tpn_usu_creacion' => $this->tank_auth->get_user_id(),
                    'tpn_fecha_creacion' => date('Y-m-d H:i:s'),
                    'tpn_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'tpn_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('tpn_tipo_precio_cliente', $tipo_precio_cliente_array);
            }
            // Guardar los numeros de telefono
            $telefonos = $this->input->post('medios_contacto');
            $telefonos_valor = $this->input->post('medio');
            for ($i = 0; $i < count($telefonos); $i++) {
                if ($telefonos[$i] != '' && $telefonos_valor[$i] != '') {                
                    if ($telefonos[$i] > 0 && $telefonos_valor[$i] > 0) {
                        $cadena = array(
                            'txc_id_cli' => $id_cliente,
                            'txc_id_tit' => $telefonos[$i],
                            'txc_numero' => $telefonos_valor[$i],
                            'txc_estado' => 1,
                            'txc_usu_mod' => $this->tank_auth->get_user_id(),
                            'txc_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('txc_telefonoxcliente', $cadena);
                    }
                }
            }
            $medio_contacto = $this->input->post('medio_contacto');
            for ($i = 0; $i < count($medio_contacto); $i++) {
                if ($medio_contacto[$i] > 0) {
                    $this->gsatelite->ingresar('cxm_clientexmediocontacto', array('cxm_id_cli' => $id_cliente, 'cxm_id_tmc' => $medio_contacto[$i]));
                }
            }
            $uno = 1;
            if (isset($id_tabla) && isset($esmodal)) {
                $personeria = $this->cotizaciones_model->actualizarCampo('tbl_tabla_llamadas', 'tbl_id', $id_tabla, 'tbl_nuevo', $uno);
                $registro = $this->cotizaciones_model->actualizarCampo('tbl_tabla_llamadas', 'tbl_id', $id_tabla, 'tbl_id_cli', $id_cliente);
            }
            //ingresar los impuestos que seran aplicados al cliente de forma automatica. Estara siendo manejado al momento de crear una nueva cotizacion.
            $imp_clientes = $this->input->post('impuestos_cliente');
            for ($j = 0; $j < count($imp_clientes); $j++) {
                if ($imp_clientes[$j] > 0) {
                    $arreglo_imp = array(
                        'ixc_id_cli'            => $id_cliente,
                        'ixc_id_imp'            => $imp_clientes[$j],
                        'ixc_aplica'            => 1,
                        'ixc_estado'            => 1,
                        'ixc_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'ixc_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'ixc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'ixc_fecha_modificacion'=> date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('ixc_impuestoxcliente', $arreglo_imp);
                }
            }
            //se ingresaran los impuestos que no aplicara al cliente.
            $imp_clientes_no = $this->input->post('no_impuestos_cliente');
            foreach ($imp_clientes_no as $imp_cliente_no){
                $arreglo_imp_no = array(
                    'ixc_id_cli'            => $id_cliente,
                    'ixc_id_imp'            => $imp_cliente_no,
                    'ixc_aplica'            => 0,
                    'ixc_estado'            => 1,
                    'ixc_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'ixc_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'ixc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'ixc_fecha_modificacion'=> date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('ixc_impuestoxcliente', $arreglo_imp_no);
            }
            //se ingresaran los retenciones del cliente.
            $retenciones_cliente = $this->input->post('retenciones_cliente');
            foreach ($retenciones_cliente as $retencion_cliente){
                $arreglo_cli_ret = array(
                    'rxc_id_cli'            => $id_cliente,
                    'rxc_id_ret'            => $retencion_cliente,
                    'rxc_estado'            => 1,
                    'rxc_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'rxc_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'rxc_usu_modificacion'   => $this->tank_auth->get_user_id(),
                    'rxc_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('rxc_retencionxcliente', $arreglo_cli_ret);
            }
            //ingresar a los contactos
            $contacto_nom = $this->input->post('contacto_nombre');
            $contacto_ape = $this->input->post('contacto_apellido');
            $contacto_cargo = $this->input->post('contacto_cargo');
            $tiposTelefono = $this->input->post('tiposTelefono');       
            $contacto_tel = $this->input->post('contacto_telefono');
            $contacto_email = $this->input->post('contacto_email');
            for ($k = 0; $k < count($contacto_nom); $k++) {
                if (trim($contacto_nom[$k]) != "") {
                    $detalle_con = array(
                        'con_id_cli' => $id_cliente,
                        'con_id_tit' => (trim($tiposTelefono[$k]) > 0) ? trim($tiposTelefono[$k]) : NULL,
                        'con_nombre' => trim($contacto_nom[$k]),
                        'con_apellidos' => trim($contacto_ape[$k]),
                        'con_cargo' => trim($contacto_cargo[$k]),
                        'con_telefono' => trim($contacto_tel[$k]),
                        'con_email' => trim($contacto_email[$k]),
                        'con_estado' => 1,
                        'con_usu_mod' => $this->tank_auth->get_user_id(),
                        'con_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('con_contacto', $detalle_con);
                }
            } // End ingreso de contactos
            // Ingresar Referencias
            $referencia_nombre = $this->input->post('referencia_nombre');
            $referencia_fijo = $this->input->post('referencia_fijo');
            $referencia_movil = $this->input->post('referencia_movil');
            $referencia_tipo = $this->input->post('referencia_tipo');
            for ($k = 0; $k < count($referencia_nombre); $k++) {
                if (trim($referencia_nombre[$k]) != "") {
                    $detalle_ref = array(
                        'rfc_id_cli' => $id_cliente, 
                        'rfc_nombre' => trim($referencia_nombre[$k]), 
                        'rfc_tel_fijo' => trim($referencia_fijo[$k]), 
                        'rfc_tel_movil' => trim($referencia_movil[$k]), 
                        'rfc_tipo' => trim($referencia_tipo[$k]), 
                        'rfc_estado' => 1, 
                        'rfc_usu_mod' => $this->tank_auth->get_user_id(), 
                        'rfc_usu_crea' => $this->tank_auth->get_user_id(), 
                        'rfc_fecha_mod' => date('Y-m-d H:i:s'), 
                        'rfc_fecha_crea' => date('Y-m-d H:i:s') 
                    );
                    $this->gsatelite->ingresar('rfc_referencia_cliente', $detalle_ref);
                }
            }
            // Agregar documentos del Cliente
            $numeros_array = $this->input->post('numero_documento');
            $documentos_array = $this->input->post('documento');
            $vence_documento_array = $this->input->post('vence_documento');
            $fecha_exp_doc_array = $this->input->post('fecha_exp_doc');
            $array_titulo_anexo = $this->input->post('titulo_anexo_doc');
            $array_nombre_anexo = $this->input->post('nombre_anexo_doc');
            $array_lugarexp_doc = $this->input->post('lugar_exp_doc');
            $carpeta = $this->input->post("nombre_anexo_carpeta");
            foreach ($numeros_array as $key => $value) {
                $titulo_a = trim($array_titulo_anexo[$key]);
                $url_anexo = "";
                if ($titulo_a != "") {
                    $extencion = end(explode(".", $array_nombre_anexo[$key]));
                    $url_anexo = trim($array_titulo_anexo[$key]) . "." . trim($extencion); //se modifico de esta manera porque se uso grocery para su edicion.
                    $this->mover_img_gral('public/temp/archivos/', 'uploads/anexos_cliente', $array_nombre_anexo[$key]);
                }
                $cadena = array(
                    'dcc_id_tde' => $documentos_array[$key],
                    'dcc_id_cli' => $id_cliente,
                    'dcc_valor' => $value,
                    'dcc_fecha_vence' => formatear_fecha('Y-m-d', $vence_documento_array[$key]),
                    'dcc_fecha_expedicion' => formatear_fecha('Y-m-d', $fecha_exp_doc_array[$key]),
                    'dcc_nombre_anexo' => $titulo_a,
                    'dcc_url' => $url_anexo,
                    'dcc_lugar_expedicion' => $array_lugarexp_doc[$key],
                    'dcc_estado' => 1,
                    'dcc_usu_mod' => $this->tank_auth->get_user_id(),
                    'dcc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dcc_usu_crea' => $this->tank_auth->get_user_id(),
                    'dcc_fecha_crea' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('dcc_documento_cliente', $cadena);
            }
            //Cuentas Contables
            $centrosCosto   = $this->input->post('centrosCosto');
            $cuentaContable = $this->input->post('cuentaContable');
            $tipoCuentas    = $this->input->post('tipoCuentas');
            $tipo_pago      = $this->input->post('tipo_pago');
            //Cuentas Contables
            if (count($centrosCosto) > 0 && $centrosCosto != '') {
                for ($i = 0; $i < count($centrosCosto); $i++) {
                    $cuentas_array = array(
                        'cxn_id_cli'    => $id_cliente,
                        'cxn_id_cnt'    => $cuentaContable[$i],
                        'cxn_id_tcn'    => $tipoCuentas[$i],
                        'cxn_id_cec'    => $centrosCosto[$i],
                        'cxn_id_tpg'    => $tipo_pago[$i],
                        'cxn_estado'    => 1,
                        'cxn_usu_crea'  => $this->tank_auth->get_user_id(),
                        'cxn_fecha_crea'=> date('Y-m-d H:i:s'),
                        'cxn_usu_mod'   => $this->tank_auth->get_user_id(),
                        'cxn_fecha_mod' => date('Y-m-d H:i:s'),
                    );
                    $this->gsatelite->ingresar('cxn_cuentaxcliente', $cuentas_array);
                }
            }
            // Agregar los Anexos por cliente
            $rutas = $this->input->post("ruta");
            $carpeta = $this->input->post("nombreCarpeta");
            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $this->input->post("titulo_doc" . $i);
                        $this->datos_imagen_gral($img, $id_cliente, $carpeta, $titulo);
                    }
                }
            }
            //agregar imagen del clientes
            if ($this->input->post('foto_empleado') != "" and $this->input->post('titulo_foto_empleado') != "") { //guardar la foto del eclienteleado
                $titulo = $this->input->post('titulo_foto_empleado');
                $img = $this->input->post('foto_empleado');
                $this->datos_imagen_gral2($img, $id_emp, 'uploads/anexos_cliente/fotos/', $titulo, 1); //es de tipo foto
            }
            if ($_POST['hdnBaseDatos'] != '') {
                $base_array = array(
                    'drn_id_cli' => $id_cliente,
                    'drn_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'drn_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('drn_directorio_contacto', $base_array, array('drn_id' => $_POST['hdnBaseDatos']));
                //buscar si habia seguimientos y trasladarlos a la SEC
                $seguimientos = $this->cotizaciones_model->get_seguimientos_base_datos(array('cli_id' => $id_cliente));
                if (count($seguimientos) > 0) {
                    foreach ($seguimientos as $k => $v) {
                        $old_seg = array(
                            'sec_id_tsg' => $v['sgd_id_tsg'],
                            'sec_id_con' => $v['contacto'],
                            'sec_fecha' => $v['sgd_fecha'],
                            'sec_fecha_proximo' => $v['sgd_fecha_proximo'],
                            'sec_comentario' => $v['sgd_comentario'],
                            'sec_lugar' => $v['sgd_lugar'],
                            'sec_invitados' => $v['sgd_invitados'],
                            'sec_estado' => $v['sgd_estado'],
                            'sec_usu_crea' => $v['sgd_usu_creacion'],
                            'sec_fecha_crea' => $v['sgd_fecha_creacion'],
                            'sec_usu_mod' => $this->tank_auth->get_user_id(),
                            'sec_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('sec_seguimiento_cliente', $old_seg);
                    }
                }                
            }
            $tipo_boton = $this->input->post('btnCrear');
            $this->session->set_userdata('id_cliente_llamada', $id_cliente);
            if ($tipo_boton == 1) {
                // Verificar si viene del modal de CRM
                if ($modal === '1') {                    
                    //$modulo = (int)$mod;
                    $alerta['registroProcesado'] = 1;
                    $alerta['direccion'] = 2;
                    $this->session->set_flashdata($alerta);
                    redirect('cotizaciones/mantenimientos/nuevo_cliente');
                    die();
                }
                if ($_POST['modulo_contratos']) {
                    $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "modulo_contratos/catalogos/nuevo_cliente");
                }
                if ($_POST['facturacion']) {
                    //Si llega desde el modal de facturacion
                    if ($modal === '2') {
                        redirect('facturacion/entradas/nuevo_cliente');
                    } else {
                        $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "facturacion/entradas/nuevo_cliente");
                    }                    
                }
                if ($_POST['cuentasxcobrar']) {
                    $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "modulo_cuentas_cobrar/mantenimiento/nuevo_cliente");
                }
                $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "proyectos/mantenimientos/nuevo_cliente$esmodal");
            } else {
                if ($_POST['modulo_contratos']) {
                    $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "modulo_contratos/catalogos/clientes");
                }
                if ($_POST['facturacion']) {
                    $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "facturacion/entradas/clientes");
                }
                if ($_POST['cuentasxcobrar']) {
                    $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "modulo_cuentas_cobrar/mantenimiento/clientes");
                }
                if ($_POST['hdnBaseDatos'] != '') {
                    $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "cotizaciones/cotizaciones/base_datos");
                }
                $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "proyectos/mantenimientos/cliente$esmodal");
            }             
        }
    }

    /**
     * COPIA DEL MANTENIMIENTO DE CLIENTES DE CRM
     * NO ES POSIBLE USAR LA MISMA FUNCIONALIDAD POR CONFLICTOS YA QUE AMBOS CONTROLADORES SE LLAMAN IGUAL
     * */
    function editar_cliente($id_cliente = null, $esmodal = null, $otro_modulo = null, $traspaso = null) {
        satelite_validar();
        if ($traspaso != null && $id_cliente != null) {
            $datos['es_traspaso']  = true;
            $id_tbl                = $traspaso;
            $datos['id_tbl']       = $id_tbl;
            $datos['cliente_id']   = $id_cliente; 
        }
        $this->gsatelite->verificar_registro_real('cli_cliente', $id_cliente);
                            $this->db->join('mun_municipio','mun_id = cli_id_mun','left');
        $registro_cliente = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $id_cliente));
        $id_vendedor = $registro_cliente[0]['cli_id_ven'];
        $datos['reg_cliente'] = $registro_cliente[0];
        $datos['id_cliente'] = $id_cliente;
        $ven_seleccionado = null;
        //Mientras no esta el campo en la base solo se mostrara todos los bancos
        $datos["bancos"] = $this->gsatelite->get_dropdown('ban_banco', '{ban_nombre}', '', array('ban_estado' => 1), null, '', 'ban_id', true);
        //Contacto
        $datos['contactos'] = $this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $id_cliente, 'con_estado' => 1));
        //Referencias
        $datos['referencias'] = $this->gsatelite->get_tabla('rfc_referencia_cliente', array('rfc_id_cli' => $id_cliente, 'rfc_estado' => 1));
        $datos['anexos'] = $this->cotizaciones_model->anexo_cliente($id_cliente);
        //  Traerse los telefonos por cliente
        $datos['tel_cliente'] = $this->db->join('tit_tipo_telefono', 'tit_id=txc_id_tit')->where('txc_id_cli', $id_cliente)->get('txc_telefonoxcliente')->result_array();
        $datos['telefonos'] = $this->gsatelite->get_tabla('tit_tipo_telefono', array('tit_id >' => 0));
        $con_cliente = $this->gsatelite->get_tabla('cxl_condicionxcliente', array('cxl_id_cli' => $id_cliente, 'cxl_estado' => 1));
        $condicion_array = array();
        foreach ($con_cliente as $key => $value) {
            $condicion_array[] = $value['cxl_id_cod'];
        }
        $condiciones = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => '1'), $condicion_array, '', 'tpg_id', true);
        $datos["condicion_tabla"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $condiciones);
        //preguntar si el usuario es supervisor o vendedor
        $condicion1 = array('sup_id_usu' => $this->tank_auth->get_user_id(), 'sup_estado' => 1);
        $esSup = $this->cotizaciones_model->Existe_Registro("sup_supervisor", $condicion1);
        $condicion2 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
        $esVen = $this->cotizaciones_model->Existe_Registro("ven_vendedor", $condicion2);
        if ($esSup > 0) { //es supervisor
            $queryIdVen = $this->cotizaciones_model->get_idsVendedoresxSupervisor($this->tank_auth->get_user_id());
            $hay_coma = strpos($queryIdVen, ',');
            if (!$hay_coma === false) {
                if (!in_array($id_vendedor, (explode(',', $queryIdVen)))) {
                    $queryIdVen = "0";
                } else {
                    $ven_seleccionado = $id_vendedor;
                }
            } else {
                if ($id_vendedor != $queryIdVen) {
                    $queryIdVen = "0";
                } else {
                    $ven_seleccionado = $id_vendedor;
                }
            }
            $datos['ids_ven'] = $queryIdVen;
            $datos['ven_selec'] = $ven_seleccionado;
        } else if ($esVen > 0) { //es vendedor
            $ven_id = $this->gsatelite->get_campo('ven_vendedor', 'ven_id', array('ven_id_usu' => $this->tank_auth->get_user_id()));
            $ven_seleccionado = $ven_id;
            if ($id_vendedor != $ven_id) {
                $ven_id = "0";
                $ven_seleccionado = null;
            }
            $datos['ids_ven'] = $ven_id;
            $datos['ven_selec'] = $ven_seleccionado;
        } else {
            $datos['ids_ven'] = 0;
            $datos['ven_selec'] = null;
        }
        $datos['cuentas_clien'] = $this->gsatelite->get_tabla('cxn_cuentaxcliente', array('cxn_id_cli' => $id_cliente, 'cxn_estado' => 1));
        $datos['cuenta_conta'] = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1));
        $datos['titulo_personal'] = "Editar Cliente";
        $datos['esmodal'] = $esmodal;
        //Obtener los documentos para el select tipo de documento
        $datos['doc_documentos'] = $this->personal_model->get_documentos();
        $tipos_doc = $this->expediente_personal_model->get_dropdown('tde_tipo_documento', '{tde_nombre}', '', array('tde_estado' => 1), null, '', 'tde_id', true);
        $datos['options_tipo_documento'] = str_replace('<option value="0">Seleccione</option>', '', $tipos_doc);
        //Obtener documentos guardados
                                       $this->db->join('dcc_documento_cliente', 'tde_id = dcc_id_tde');
        $datos['documentosxcliente'] = $this->gsatelite->get_tabla('tde_tipo_documento', array('dcc_id_cli' =>$id_cliente, 'dcc_estado' => 1));
        //Centro de costos
        $datos["centro_costo"] = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
        //tipo de cuenta
        $datos["tipo_cuenta"] = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
        //cuenta contable
        $datos["cuen_con"] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
        $datos['cuentas_contables'] = $this->cotizaciones_model->get_cuentas_cliente(array('cxn_id_cli' => $id_cliente));
        //zona geografias
        $datos["zonas"]     = $this->gsatelite->get_tabla("zog_zona_geografica",array("zog_estado" => 1) );
        //Tipo lista precio
        $idstpn = [];
        $id_para_opt = [];
                     $this->db->join('cli_cliente', 'cli_id = tpn_id_cli');
        $idtpn_res = $this->gsatelite->get_tabla('tpn_tipo_precio_cliente', array('tpn_id_cli' => $id_cliente));
        $idtlp = (count($idtpn_res) > 0) ? $idtpn_res[0]['tpn_id_tlp'] : 0;
        foreach ($idtpn_res as $key => $idtpn_re) {
            array_push($idstpn, $idtpn_re['tpn_id']);
            array_push($id_para_opt, $idtpn_re['tpn_id_tlp']);
        }
        $datos['idtlp'] = $idtlp;
        $datos['idstpn'] = $idstpn;
        $datos['id_para_opt'] = $id_para_opt;        
        //cargar tipos de telefonos
        $etiquetas  = $this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $id_cliente));
        $select = array();
        foreach ($etiquetas as $cont) {
            $select_temp  = $this->gsatelite->get_dropdown('tit_tipo_telefono', 'tit_nombre', 'etiquetas', array('tit_estado' => 1), $cont['con_id_tit'], null, null, true);
            $select[$cont['con_id']] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Regristros</option>'),'', $select_temp);
        }
        $datos['etiquetasX'] = $select;
        $select_temp  = $this->gsatelite->get_dropdown('tit_tipo_telefono', 'tit_nombre', 'etiquetas', array('tit_estado' => 1), null, null, null, true);
        $datos['etiquetasX2']  = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Regristros</option>'),'', $select_temp);
        $datos["fotos"] = $this->gsatelite->get_tabla('cli_cliente',array('cli_id' => $id_cliente));
        $datos['departamentos'] = $this->gsatelite->get_tabla('dep_departamento', array('dep_estado' => 1));
        if ($esmodal) {
            $this->gsatelite->cargar_vista_masterpage('cotizaciones/mantenimientos/editar_cliente', $datos);
        } else {
            if ($otro_modulo)
                return $datos;
            $this->_cargarvista($datos);
        }
    }

    /**
     * COPIA DEL MANTENIMIENTO DE CLIENTES DE CRM
     * NO ES POSIBLE USAR LA MISMA FUNCIONALIDAD POR CONFLICTOS YA QUE AMBOS CONTROLADORES SE LLAMAN IGUAL
     * */
    function guardar_edit_cliente() {
        if ($_POST) {
            // var_dump($_POST);die();
            $id_cliente = $this->input->post('id_cliente');
            $id_tbl_assoc  = ($this->input->post('tbl_id') != '')?$this->input->post('tbl_id') : null;
            if ($id_tbl_assoc) {
                $this->gsatelite->actualizar_array('tbl_tabla_llamadas',array('tbl_id_cli'=>$id_cliente),array('tbl_id'=>$id_tbl_assoc));
            }
            $esmodal = $this->input->post('es_edicion_modal');
            $foto_anterior = (file_exists($_POST['id_foto']) && $_POST['imagen_defecto'] == 0) ? $_POST['id_foto'] : null;

            //validacion de los dias plazo
            $tipo_vencimiento   = $this->input->post('slc_tipo_vencimiento');
            $tipo_vencimiento   = ($tipo_vencimiento == "")? null:$tipo_vencimiento;
            $dias_plazo         = null;
            if ( $tipo_vencimiento  == 1) {
                $txt_dias_plazo =  $this->input->post('txt_dias_plazo');
                $dias_plazo = ( $txt_dias_plazo != "" and is_numeric( $txt_dias_plazo ) )?$txt_dias_plazo:null;
            } else if ( $tipo_vencimiento  == 2 ) {
                $slc_dia_especifico =  $this->input->post('slc_dia_especifico');
                $dias_plazo = ( $slc_dia_especifico != "" and is_numeric( $slc_dia_especifico ) )?$slc_dia_especifico:null;
            } else {
                $tipo_vencimiento = null;
            }
            $detalle = array(
                'cli_codigo' => (trim($this->input->post('codigo_cli')) != "")? trim($this->input->post('codigo_cli')):"",
                'cli_id_sec' => ($this->input->post('sector') != "") ? $this->input->post('sector') : null,
                'cli_id_cac' => ($this->input->post('cartera') != "") ? $this->input->post('cartera') : null,
                'cli_id_ven' => ($this->input->post('vendedor') != "") ? $this->input->post('vendedor') : null,
                'cli_apellido' => trim($this->input->post('apellidos')),
                'cli_nombre' => trim($this->input->post('nombres')),
                'cli_nombre_comercio' => ($this->input->post('nom_comercial')),
                'cli_personeria' => $this->input->post('personeria'),
                'cli_id_pro' => ($_POST['ocupacion']) ? $this->input->post('ocupacion') : null,
                'cli_lugar_trabajo' => ($_POST['lugar_trabajo']) ? $_POST['lugar_trabajo'] : null,
                'cli_cargo' => ($_POST['cargo']) ? $_POST['cargo'] : null,
                'cli_persona_aut' => $_POST['persona_autorizada'],
                'cli_observacion' => $this->input->post('observ'),
                'cli_id_rtc' => ($this->input->post('ruta_cliente') != "") ? $this->input->post('ruta_cliente') : null,
                'cli_id_mun' => (!empty($_POST['municipio'])) ? $_POST['municipio'] : null,
                'cli_id_tif' => ($_POST['comprobante']) ? $_POST['comprobante'] : null,
                'cli_factura_elect' => (isset($_POST['factura_electronica'])) ? 1 : null, 
                'cli_id_pai' => ($_POST['nacionalidad']) ? $_POST['nacionalidad'] : null,
                'cli_id_tpg' => ($_POST['condicion'] != '') ? $_POST['condicion'] : null,
                'cli_id_frp' => ($_POST['slc_forma_pago'] != '') ? $_POST['slc_forma_pago'] : null,
                'cli_sitio_web' => $this->input->post('sitio_web'),
                'cli_es_gran_contribuyente' => $this->input->post('hdngranCont'),
                'cli_email' => $this->input->post('correo'),
                'cli_usu_mod' => $this->tank_auth->get_user_id(),
                'cli_fecha_mod' => date('Y-m-d H:i:s'),
                'cli_direccion' => $this->input->post('direccion_cli'),
                'cli_id_tpc' => ($this->input->post('tip_cliente') != "") ? $this->input->post('tip_cliente') : null,
                'cli_id_gir' => ($this->input->post('giro') != "") ? $this->input->post('giro') : null,
                'cli_representante' => ($_POST['representante']) ? $_POST['representante'] : null,
                'cli_registro' => ($_POST['registro']) ? $_POST['registro'] : null,
                'cli_fotografia' => ($this->input->post('foto_empleado') != "") ? "uploads/anexos_cliente/" . $this->input->post('foto_empleado') : $foto_anterior,  
                'cli_fecha_nacimiento' => ($_POST['txt_fecha_nacimiento'] != "") ? formatear_fecha('Y-m-d', $_POST['txt_fecha_nacimiento']) : null,
                'cli_fecha_registro' => ($_POST['txt_fecha_registro'] != "") ? $_POST['txt_fecha_registro'] : null,
                'cli_id_cfc' => ($_POST['slc_clasificacion'] != "") ? $_POST['slc_clasificacion'] : null,
                'cli_dias_plazo'          => $dias_plazo,
                'cli_monto_credito'       => ($_POST['txt_monto_credito'] != "") ? $_POST['txt_monto_credito'] : null,
                'cli_nombre_factura'      => ($_POST['txt_nombre_factura'] != "") ? $_POST['txt_nombre_factura'] : null,
                'cli_descuento_sugerido'  => ($_POST['txt_descuento_sugerido'] != "")?$_POST['txt_descuento_sugerido']:0,
                'cli_estado'              => ($_POST['slc_estado'] != "") ? $_POST['slc_estado'] : 0, 
                'cli_id_zog'              => ($_POST['slc_zona_geografica'] != "")?$_POST['slc_zona_geografica']:null, 
                'cli_tipo_fac_vence'      => $tipo_vencimiento,
                'cli_id_ban'            => ($_POST['slc_banco_paga'] != "") ? $_POST['slc_banco_paga'] : null, 
                'cli_encargado_pago'      => ($_POST['txt_encargado_pago'] != "") ? $_POST['txt_encargado_pago'] : null, 
                'cli_comentario_finanzas' => ($_POST['txt_comentario_adicional'] != "") ? $_POST['txt_comentario_adicional'] : null, 
                'cli_suspender_facturacion' => $_POST['hdn_suspende_fact']
            );//var_dump($detalle);die();
            $this->gsatelite->actualizar_array('cli_cliente', $detalle, array('cli_id' => $id_cliente));

            //Actualizar Tipo lista precio
            $idtlp_array = $this->input->post('slc_tipo_lista_precio');
            $this->gsatelite->borrado_general('tpn_tipo_precio_cliente', array('tpn_id_cli' => $id_cliente));
            foreach ($idtlp_array as $key => $idtlp_elem) {
                $tpn_array = array(
                    'tpn_id_cli' => $id_cliente,
                    'tpn_id_tlp' => $idtlp_elem,
                    'tpn_estado' => 1,
                    'tpn_usu_creacion' => $this->tank_auth->get_user_id(),
                    'tpn_fecha_creacion' => date('Y-m-d H:i:s'),
                    'tpn_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'tpn_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('tpn_tipo_precio_cliente', $tpn_array);
            }

            // Guardar los numeros de telefono
            $telefonos = $this->input->post('medios_contacto');            
            $telefonos_valor = $this->input->post('medio');
            $telefonos_valor = ($_POST['medio'] != "") ? $_POST['medio'] : null;
            $this->gsatelite->borrado_general('txc_telefonoxcliente', array('txc_id_cli' => $id_cliente));
            for ($i = 0; $i < count($telefonos); $i++) {
                if ($telefonos[$i] > 0) {
                    $cadena = array(
                        'txc_id_cli' => $id_cliente,
                        'txc_id_tit' => $telefonos[$i],
                        'txc_numero' => $telefonos_valor[$i],
                        'txc_estado' => 1,
                        'txc_usu_mod' => $this->tank_auth->get_user_id(),
                        'txc_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('txc_telefonoxcliente', $cadena);
                }
            }

            $this->gsatelite->borrado_general('ixc_impuestoxcliente', array('ixc_id_cli' => $id_cliente));
            $imp_clientes = $this->input->post('impuestos_cliente');
            for ($j = 0; $j < count($imp_clientes); $j++) {
                if ($imp_clientes[$j] > 0) {
                    $arreglo_imp = array(
                        'ixc_id_cli' => $id_cliente,
                        'ixc_id_imp' => $imp_clientes[$j],
                        'ixc_aplica'            => 1,
                        'ixc_estado'            => 1,
                        'ixc_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'ixc_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'ixc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'ixc_fecha_modificacion'=> date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('ixc_impuestoxcliente', $arreglo_imp);
                }
            }

            //se ingresaran los impuestos que no aplicara al cliente.
            $imp_clientes_no = ($this->input->post('no_impuestos_cliente') != null) ? $this->input->post('no_impuestos_cliente') : array();
            foreach ($imp_clientes_no as $imp_cliente_no){
                $arreglo_imp_no = array(
                    'ixc_id_cli'            => $id_cliente,
                    'ixc_id_imp'            => $imp_cliente_no,
                    'ixc_aplica'            => 0,
                    'ixc_estado'            => 1,
                    'ixc_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'ixc_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'ixc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'ixc_fecha_modificacion'=> date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('ixc_impuestoxcliente', $arreglo_imp_no);
            }

            //se ingresaran los retenciones del cliente.
            $this->gsatelite->borrado_general('rxc_retencionxcliente', array('rxc_id_cli' => $id_cliente));
            $retenciones_cliente = ($this->input->post('retenciones_cliente') != null) ? $this->input->post('retenciones_cliente') : array();
            foreach ($retenciones_cliente as $retencion_cliente){
                $arreglo_cli_ret = array(
                    'rxc_id_cli'            => $id_cliente,
                    'rxc_id_ret'            => $retencion_cliente,
                    'rxc_estado'            => 1,
                    'rxc_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'rxc_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'rxc_usu_modificacion'   => $this->tank_auth->get_user_id(),
                    'rxc_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('rxc_retencionxcliente', $arreglo_cli_ret);
            }

            //Cuentas Contables
            $detalleCuentas = $this->input->post('hdnCuentaProv');
            $centrosCosto = $this->input->post('centrosCosto');
            $cuentaContable = $this->input->post('cuentaContable');
            $tipoCuentas = $this->input->post('tipoCuentas');
            $tipo_pago      = $this->input->post('tipo_pago');

            //Se obtienen las Cuentas guardadas, si existen se verifica si se eliminara
            $dataCuentas = $this->gsatelite->get_tabla('cxn_cuentaxcliente', array('cxn_id_cli' => $id_cliente));
            if (!is_array($detalleCuentas)) {
                $detalleCuentas = array();
            }
            foreach ($dataCuentas as $data) {
                if (!in_array($data['cxn_id'], $detalleCuentas)) {
                    $this->gsatelite->borrado_general('cxn_cuentaxcliente', array('cxn_id' => $data['cxn_id']));
                }
            }
            //Cuentas Contables
            if (count($centrosCosto) > 0 && $centrosCosto != '') {
                for ($i = 0; $i < count($centrosCosto); $i++) {
                    $cuentas_array = array(
                        'cxn_id_cli'    => $id_cliente,
                        'cxn_id_cnt'    => $cuentaContable[$i],
                        'cxn_id_tcn'    => $tipoCuentas[$i],
                        'cxn_id_cec'    => $centrosCosto[$i],
                        'cxn_id_tpg'    => $tipo_pago[$i],
                        'cxn_estado'    => 1,
                        'cxn_usu_crea'  => $this->tank_auth->get_user_id(),
                        'cxn_fecha_crea'=> date('Y-m-d H:i:s'),
                        'cxn_usu_mod'   => $this->tank_auth->get_user_id(),
                        'cxn_fecha_mod' => date('Y-m-d H:i:s'),
                    );
                    $this->gsatelite->ingresar('cxn_cuentaxcliente', $cuentas_array);
                }
            }

            // Agregar los Anexos por cliente
            $rutas = $this->input->post("ruta");
            $carpeta = $this->input->post("nombreCarpeta");

            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $this->input->post("titulo_doc" . $i);
                        $this->datos_imagen_gral($img, $id_cliente, $carpeta, $titulo);
                    }
                }
            }

            $this->gsatelite->borrado_general('cxm_clientexmediocontacto', array('cxm_id_cli' => $id_cliente));
            $medio_contacto = $this->input->post('medio_contacto');
            for ($i = 0; $i < count($medio_contacto); $i++) {
                if ($medio_contacto[$i] > 0) {
                    $this->gsatelite->ingresar('cxm_clientexmediocontacto', array('cxm_id_cli' => $id_cliente, 'cxm_id_tmc' => $medio_contacto[$i]));
                }
            }
            //Contacto
            $new = $this->input->post('txtTablaNew');
            $contacto_nombre = ($this->input->post('contacto_nombre') != null) ? $this->input->post('contacto_nombre') : array();
            $contacto_apellido = $this->input->post('contacto_apellido');
            $contacto_cargo = $this->input->post('contacto_cargo');
            $contacto_telefono = $this->input->post('contacto_telefono');
            $contacto_email = $this->input->post('contacto_email');
            $tipo_telefono  = $this->input->post('tip_telefono');

            //obtener los detalles antiguos
            $contactos_antiguos = $this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $id_cliente));

            foreach ($contactos_antiguos as $con) {
                if (!in_array($con['con_id'], $new)) {
                    $this->gsatelite->actualizar_array('con_contacto', array('con_estado' => 0),array('con_id' => $con['con_id']));
                }
            }
            foreach ($contacto_nombre as $key => $value) {
                if(trim($value)){
                    if ( $new[$key] == "" ) {
                        $array_con = array(
                            'con_id_cli'        => $id_cliente,
                            'con_id_tit'     => ( $tipo_telefono[$key] > 0) ? $tipo_telefono[$key] : null,
                            'con_nombre'        => ( $value != '') ? $value : null,
                            'con_apellidos'     => ( $contacto_apellido[$key] != '') ? $contacto_apellido[$key] : "",
                            'con_cargo'         => ( $contacto_cargo[$key] != '') ? $contacto_cargo[$key] : null,
                            'con_telefono'      => ( $contacto_telefono[$key] != '') ? $contacto_telefono[$key] : null,
                            'con_email'         => ( $contacto_email[$key] != '') ? $contacto_email[$key] : null,
                            'con_estado'        => 1,
                            'con_usu_mod'       => $this->tank_auth->get_user_id(),
                            'con_fecha_mod'     => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('con_contacto', $array_con);
                    } else {
                        $array_con = array(
                            'con_id_cli'        => $id_cliente,
                            'con_id_tit'        => ( $tipo_telefono[$key] > 0) ? $tipo_telefono[$key] : null,
                            'con_nombre'        => ( $value != '') ? $value : null,
                            'con_apellidos'     => ( $contacto_apellido[$key] != '') ? $contacto_apellido[$key] : "",
                            'con_cargo'         => ( $contacto_cargo[$key] != '') ? $contacto_cargo[$key] : null,
                            'con_telefono'      => ( $contacto_telefono[$key] != '') ? $contacto_telefono[$key] : null,
                            'con_email'         => ( $contacto_email[$key] != '') ? $contacto_email[$key] : null,
                            'con_estado'        => 1,
                            'con_usu_mod'       => $this->tank_auth->get_user_id(),
                            'con_fecha_mod'     => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('con_contacto', $array_con,array('con_id' => $new[$key]));
                    }
                }
            }
            $new = $this->input->post('txtTablaNewDoc');
            $documento = $this->input->post('documento');
            $numero_documento = $this->input->post('numero_documento');
            $vence_documento = $this->input->post('vence_documento');
            $fecha_exp_doc = $this->input->post('fecha_exp_doc');
            $lugar_exp_doc = $this->input->post('lugar_exp_doc');
            $nombre_anexo_doc = $this->input->post('nombre_anexo_doc');
            $titulo_anexo_doc = $this->input->post('titulo_anexo_doc');

            //obtener los documentos antiguos
            $documentos_antiguos = $this->gsatelite->get_tabla('dcc_documento_cliente', array('dcc_id_cli' => $id_cliente,'dcc_estado' => 1));
            foreach ($documentos_antiguos as $doc) {
                if (!in_array($doc['dcc_id'], $new)) {
                    $this->gsatelite->actualizar_array('dcc_documento_cliente', array('dcc_estado' => 0),array('dcc_id' => $doc['dcc_id']));
                    $this->eliminar_imagen_gral2($doc['dcc_url']);
                }
            }

            foreach ($documento as $key => $value) {
                if(trim($value)){
                    if ( $new[$key] == "" ) {
                        $array_doc = array(
                            'dcc_id_tde'            => $documento[$key],
                            'dcc_id_cli'            => $id_cliente,
                            'dcc_valor'             => ( $numero_documento[$key] != '') ? $numero_documento[$key] : null,
                            'dcc_fecha_vence'       => ( $vence_documento[$key] != '') ? formatear_fecha('Y-m-d', $vence_documento[$key]) : null,
                            'dcc_nombre_anexo'      => ( $titulo_anexo_doc[$key] != '') ? $titulo_anexo_doc[$key] : null,
                            'dcc_url'               => ( $nombre_anexo_doc[$key] != '') ? $nombre_anexo_doc[$key] : null,
                            'dcc_fecha_expedicion'  => ( $fecha_exp_doc[$key] != '') ? formatear_fecha('Y-m-d', $fecha_exp_doc[$key]) : null,
                            'dcc_lugar_expedicion'  => ( $lugar_exp_doc[$key] != '') ? $lugar_exp_doc[$key] : null,
                            'dcc_estado'            => 1,
                            'dcc_usu_crea'          => $this->tank_auth->get_user_id(),
                            'dcc_fecha_crea'        => date('Y-m-d H:i:s'),
                            'dcc_usu_mod'           => $this->tank_auth->get_user_id(),
                            'dcc_fecha_mod'         => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('dcc_documento_cliente', $array_doc);
                    } else {
                        $array_doc = array(
                            'dcc_id_tde'            => $documento[$key],
                            'dcc_id_cli'            => $id_cliente,
                            'dcc_valor'             => ( $numero_documento[$key] != '') ? $numero_documento[$key] : null,
                            'dcc_fecha_vence'       => ( $vence_documento[$key] != '') ? formatear_fecha('Y-m-d',$vence_documento[$key]) : null,
                            'dcc_nombre_anexo'      => ( $titulo_anexo_doc[$key] != '') ? $titulo_anexo_doc[$key] : null,
                            'dcc_url'               => ( $nombre_anexo_doc[$key] != '') ? $nombre_anexo_doc[$key] : null,
                            'dcc_fecha_expedicion'  => ( $fecha_exp_doc[$key] != '') ? formatear_fecha('Y-m-d', $fecha_exp_doc[$key]) : null,
                            'dcc_lugar_expedicion'  => ( $lugar_exp_doc[$key] != '') ? $lugar_exp_doc[$key] : null,
                            'dcc_estado'            => 1,
                            //'con_usu_ingreso'   => $this->tank_auth->get_user_id(),
                            //'con_fecha_ingreso' => date('Y-m-d H:i:s'),
                            'dcc_usu_mod'           => $this->tank_auth->get_user_id(),
                            'dcc_fecha_mod'         => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('dcc_documento_cliente', $array_doc,array('dcc_id' => $new[$key]));
                    }
                    $this->mover_img_gral('public/temp/archivos/', 'uploads/anexos_cliente', $nombre_anexo_doc[$key]);
                }
            }

            $new = $this->input->post('txtTablaNewRef');
            $referencia_nombre = $this->input->post('referencia_nombre_edit');
            $referencia_fijo = $this->input->post('referencia_fijo_edit');
            $referencia_movil = $this->input->post('referencia_movil_edit');
            $referencia_tipo = $this->input->post('referencia_tipo_edit');
            //obtener los detalles antiguos
            $referencias_antiguas = $this->gsatelite->get_tabla('rfc_referencia_cliente', array('rfc_id_cli' => $id_cliente));

            //eliminacion de detalles que no existen
            foreach ($referencias_antiguas as $ref) {
                if (!in_array($ref['rfc_id'], $new)) {
                    $this->gsatelite->actualizar_array('rfc_referencia_cliente', array('rfc_estado' => 0),array('rfc_id' => $ref['rfc_id']));
                }
            }

            foreach ($referencia_nombre as $key => $value) {
                if(trim($value)){
                    if ( $new[$key] == "" ) {
                        $array_ref = array(
                            'rfc_id_cli'        => $id_cliente,
                            'rfc_nombre'        => ( $value != '') ? $value : null,
                            'rfc_tel_fijo'      => ( $referencia_fijo[$key] != '') ? $referencia_fijo[$key] : null,
                            'rfc_tel_movil'     => ( $referencia_movil[$key] != '') ? $referencia_movil[$key] : null,
                            'rfc_tipo'          => ( $referencia_tipo[$key] != '') ? $referencia_tipo[$key] : null,
                            'rfc_estado'        => 1,
                            'rfc_usu_crea'   => $this->tank_auth->get_user_id(),
                            'rfc_fecha_crea' => date('Y-m-d H:i:s'),
                            'rfc_usu_mod'       => $this->tank_auth->get_user_id(),
                            'rfc_fecha_mod'     => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('rfc_referencia_cliente', $array_ref);
                    } else {
                        $array_ref = array(
                            'rfc_id_cli'     => $id_cliente,
                            'rfc_nombre'     => ( $value != '') ? $value : null,
                            'rfc_tel_fijo'   => ( $referencia_fijo[$key] != '') ? $referencia_fijo[$key] : null,
                            'rfc_tel_movil'  => ( $referencia_movil[$key] != '') ? $referencia_movil[$key] : null,
                            'rfc_tipo'       => ( $referencia_tipo[$key] != '') ? $referencia_tipo[$key] : null,
                            'rfc_estado'     => 1,
                            'rfc_usu_mod'    => $this->tank_auth->get_user_id(),
                            'rfc_fecha_mod'  => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('rfc_referencia_cliente', $array_ref,array('rfc_id' => $new[$key]));
                    }
                }
            }

            if ($this->input->post('foto_empleado') != "" and $this->input->post('titulo_foto_empleado') != "") { //guardar la foto del eclienteleado
                $titulo = $this->input->post('titulo_foto_empleado');
                $img = $this->input->post('foto_empleado');
                $this->datos_imagen_gral2($img, $id_emp, 'uploads/anexos_cliente/fotos/', $titulo, 1); //es de tipo foto
            }

            $tipo_boton = $this->input->post('btnCrear');
            //Se redirecciona en base al boton
            if ($tipo_boton == 1) {
                if ($_POST['facturacion']) {
                    $this->gsatelite->show_dialog('Cliente actualizado con éxito!', "facturacion/entradas/editar_cliente/" . $id_cliente);
                }
                if ($_POST['modulo_contratos']) {
                    $this->gsatelite->show_dialog('Cliente actualizado con éxito!', "modulo_contratos/catalogos/editar_cliente/" . $id_cliente);
                }
                if ($_POST['cuentasxcobrar']) {
                    $this->gsatelite->show_dialog('Cliente actualizado con éxito!', "modulo_cuentas_cobrar/mantenimiento/editar_cliente/" . $id_cliente);
                }
                $this->gsatelite->show_dialog('Cliente actualizado con éxito!', "proyectos/mantenimientos/editar_cliente/" . $id_cliente);
            } else {
                if ($_POST['modulo_contratos']) {
                    $this->gsatelite->show_dialog('Cliente actualizado con éxito!', "modulo_contratos/catalogos/clientes");
                }
                if ($_POST['facturacion']) {
                    $this->gsatelite->show_dialog('Cliente actualizado con éxito!', "facturacion/entradas/clientes");
                }
                if ($_POST['cuentasxcobrar']) {
                    $this->gsatelite->show_dialog('Cliente actualizado con éxito!', "modulo_cuentas_cobrar/mantenimiento/clientes");
                }
                $this->gsatelite->show_dialog('Cliente actualizado con éxito!', "proyectos/mantenimientos/cliente$esmodal");
            }
        }
    }


    function contactos($id_cliente) {

        satelite_validar();

        try {
            if (!isset($id_cliente))
                $id_cliente = 0;
            $crud = new grocery_CRUD();
            //Columnas a mostrar en READ
            $columns = array(
                'con_nombre',
                'con_apellidos',
                'con_cargo',
                'con_telefono',
                'con_email',
                'con_estado',
            );

            //Alias para las columnas
            $alias = array(
                'con_nombre' => 'Nombre',
                'con_apellidos' => 'Apellidos',
                'con_email' => 'E-mail',
                'con_estado' => 'Estado',
                'con_cargo' => 'Cargo',
                'con_telefono' => 'Teléfono',
            );


            //Columnas a mostrar en ADD
            $add_columns = array(
                'con_id_cli',
                'con_nombre',
                'con_apellidos',
                'con_cargo',
                'con_telefono',
                'con_email',
                'con_estado',
                'con_fecha_mod',
                'con_usu_mod',
            );

            //Columnas a mostrar en EDIT
            $edit_columns = $add_columns;

            $required_fields = array('con_nombre',
                'con_apellidos',
                'con_estado',
                'con_email',
                'con_telefono',
                'con_cargo');

            $crud->set_table('con_contacto')
                    ->set_subject('Contacto')
                    ->where('con_estado <>', -1)
                    ->where('con_id_cli', $id_cliente)
                    ->unset_delete()
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->required_fields($required_fields)
                    ->field_type('con_id_cli', 'hidden', $id_cliente)
                    ->field_type('con_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('con_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->set_rules('con_email', 'E-mail', 'required|valid_email')
            ;
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('con_estado', 'hidden', 1);
            } else {
                $crud->field_type('con_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
            }

            $output = $crud->render();

            $data['titulo_personal'] = "Contactos Cliente"; # Antonio
            $data['esmodal'] = 0;
            $this->_cargarvista(null, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function contactos_iframe($id_cliente) {
        satelite_validar();
        if (!isset($id_cliente))
            $id_cliente = 0;
        $crud = new grocery_CRUD();
        //Columnas a mostrar en READ
        $columns = array(
            'con_nombre',
            'con_apellidos',
            'con_cargo',
            'con_telefono',
            'con_email',
            'con_estado',
        );

        //Alias para las columnas
        $alias = array(
            'con_nombre' => 'Nombre',
            'con_apellidos' => 'Apellidos',
            'con_email' => 'E-mail',
            'con_estado' => 'Estado',
            'con_cargo' => 'Cargo',
            'con_telefono' => 'Teléfono',
        );


        //Columnas a mostrar en ADD
        $add_columns = array(
            'con_id_cli',
            'con_nombre',
            'con_apellidos',
            'con_cargo',
            'con_telefono',
            'con_email',
            'con_estado',
            'con_fecha_mod',
            'con_usu_mod',
        );

        //Columnas a mostrar en EDIT
        $edit_columns = $add_columns;

        $required_fields = array('con_nombre',
            'con_apellidos',
            'con_estado',
            'con_email',
            'con_telefono',
            'con_cargo');

        $crud->set_table('con_contacto')
                ->set_subject('Contacto')
                ->where('con_estado <>', -1)
                ->where('con_id_cli', $id_cliente)
                ->unset_delete()
                ->columns($columns)
                ->display_as($alias)
                ->add_fields($add_columns)
                ->edit_fields($edit_columns)
                ->required_fields($required_fields)
                ->field_type('con_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'))
                ->field_type('con_id_cli', 'hidden', $id_cliente)
                ->field_type('con_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('con_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->unset_export()
                ->unset_print()
        ;
        $output = $crud->render();
        $data['esmodal'] = true;
        $output = array_merge($data, (array) $output);
        //$this->_cargarvista(null,$output);
        $this->gsatelite->cargar_vista_masterpage('proyectos/mantenimientos/contactos', $output);
    }

    public function unidad_medida() {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->medida_producto('proyectos/mantenimientos/unidad_medida');
        // satelite_validar();
        //  try{
        //   		 $crud = new grocery_CRUD();
        //            //Columnas a mostrar en READ
        //    $columns = array(
        //      'mep_codigo',
        //      'mep_nombre',
        //      'mep_estado'
        //      );
        //            //Alias para las columnas
        //    $alias = array(
        //      'mep_id' => 'Id',
        //      'mep_nombre' => 'Nombre de la Medida',
        //      'mep_estado' => 'Estado',
        //      'mep_codigo' => 'Código'
        //      );
        //            //Columnas a mostrar en ADD
        //    $add_columns = array(
        //      'mep_nombre',
        //      'mep_codigo',
        //      'mep_estado',
        //      'mep_usu_mod',
        //      'mep_fecha_mod'
        //      );
        //             //Columnas a mostrar en EDIT
        //    $edit_columns = array(
        //      'mep_nombre',
        //      'mep_codigo',
        //      'mep_estado',
        //      'mep_usu_mod',
        //      'mep_fecha_mod'
        //      );
        //    $crud->set_table('mep_medida_producto')
        //    ->set_subject('unidad de medida')
        //    ->columns($columns)
        //    ->display_as($alias)
        //    ->add_fields($add_columns)
        //    ->required_fields($edit_columns)
        //    ->field_type('mep_usu_mod','hidden',$this->tank_auth->get_user_id())
        //    ->field_type('mep_fecha_mod','hidden',date('Y-m-d h:i:s'))
        //    ->set_rules('mep_nombre','Nombre','callback_username_check_insert2')
        //    ->set_rules('mep_codigo','Codigo','callback_username_check_insert22')
        //    ->edit_fields($edit_columns);
        //    $crud->set_rules('mep_nombre','Nombre de la medida','required');
        //    $crud->set_rules('mep_codigo','Código','required');
        //     if(end(explode('/',uri_string()))=='add') {
        //    $crud->field_type('mep_estado','hidden',1);
        //    }
        //    else {
        //    $crud->field_type('mep_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        //    }
        //    $output = $crud->render();
        //    $data['titulo_personal'] = "Catálogo de  unidades de medida";
        //    $this->_cargarvista($data,$output);
        //  }
        //  catch(Exception $e){
        //    show_error($e->getMessage().' --- '.$e->getTraceAsString());
        //  }
    }

    /**
    * @author Habby Lovo
    * @since  13/11/2017 - modificado
    * @return Mantenimiento tabla mob_mano_obra
    * Módulos padre: Sistema.
    */
    public function mano_obra() { 
        satelite_validar();
        $this->load->library('../controllers/sistema/mantenimientos_compartidos');
        $permisos = $this->gsatelite->get_permisos_opcion('proyectos/mantenimientos/mano_obra');
        $this->mantenimientos_compartidos->mano_obra("proyectos", $permisos);
    }

    public function verificar_codigo() {
        $codigo = $this->input->post('codigo');
        $existe = $this->db->where('mob_codigo', $codigo)->get('mob_mano_obra')->result_array();
        $arreglo = array('drop' => count($existe));
        //$arreglo=array('drop'=>0); //quitar la validación para ylufa
        echo json_encode($arreglo);
    }

    /**
    * @author Edith Herrera
    * @since  03/10/2017 - modificado
    * @return Mantenimiento tabla esn_estado_atencion
    * Módulos padre: Sistema.
    */

    function estimacion() {
        $this->load->library('../controllers/sistema/mantenimientos_compartidos');
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('proyectos/mantenimientos/estimacion');
        $this->mantenimientos_compartidos->estimacion($permisos, 'proyectos');

    }

    public function verificar_codigo_esm() {
        $codigo = $this->input->post('codigo');
        $existe = $this->db->where('esm_codigo', $codigo)->get('esm_estimacion')->result_array();
        $arreglo = array('drop' => count($existe));
        //$arreglo=array('drop'=>0); //quitar la validación para ylufa
        echo json_encode($arreglo);
    }

    function vendedor_supervisor($id_supervisor) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {

                $crud = new grocery_CRUD();
                $crud->set_table('vxs_vendedorxsupervisor')
                        ->set_subject('Vendedor - Supervisor')
                        ->where('vxs_id_sup', $id_supervisor)
                        ->columns('vxs_id_ven')
                        ->fields('vxs_id_sup', 'vxs_id_ven')
                        ->display_as('vxs_id_ven', 'Nombre Vendedor')
                        // ->display_as('tsg_estado', 'Estado')
                        ->required_fields('vxs_id_ven')
                        ->set_relation('vxs_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1))
                        ->field_type('vxs_id_sup', 'hidden', $id_supervisor)
                        // ->field_type('tsg_estado','dropdown',array('1' => 'Activado', '0' => 'Desactivado'))
                        ->callback_before_insert(function($post_array, $primary_key) {
                            //VALIDAR QUE NO REGISTRE UN VENDEDOR YA REGISTRADO  
                            $existe = $this->proyecto_model->existeRegistroEtapa('vxs_vendedorxsupervisor', 'vxs_id_ven', $post_array['vxs_id_ven'], 'vxs_id_sup', $post_array['vxs_id_sup'], 0, 0);
                            if ($existe > 0) {
                                return FALSE;
                            } else {
                                return TRUE;
                            }
                        })
                        ->callback_before_update(function($post_array, $primary_key) {
                            //VALIDAR QUE NO REGISTRE UN VENDEDOR YA REGISTRADO     
                            $filaVenSup = $this->proyecto_model->get_registro('vxs_vendedorxsupervisor', 'vxs_id', $primary_key);
                            $idVenactual = $filaVenSup->vxs_id_ven;

                            $existe = $this->proyecto_model->existeRegistroEtapa('vxs_vendedorxsupervisor', 'vxs_id_ven', $post_array['vxs_id_ven'], 'vxs_id_sup', $post_array['vxs_id_sup'], 1, $idVenactual);
                            if ($existe > 0) {
                                return FALSE;
                            } else {
                                return TRUE;
                            }
                        })
                        ->set_lang_string('update_error', 'Error!\nFavor Verificar lo Siguiente:\n\n*El Vendedor elegido ya fue registrado anteriormente.')
                        ->set_lang_string('insert_error', 'Error!\nFavor Verificar lo Siguiente:\n\n*El Vendedor elegido ya fue registrado anteriormente.')
                        ->unset_delete()
                ;
                $datos["datos_supervisor"] = $this->proyecto_model->get_registro('sup_supervisor', 'sup_id', $id_supervisor); //obtener registro
                $datos["titulo_personal"] = "Vendedores por Supervisor";

                $output = $crud->render();
                $this->_cargarvista($datos, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    function supervisores() {

        satelite_validar();
        try {

            $query = $this->proyecto_model->getusername();

            $sup_id = end(explode('/', uri_string()));
            if ($sup_id > 0) {
                $usu_id = $this->gsatelite->get_campo('sup_supervisor', 'sup_id_usu', array('sup_id' => $sup_id));
                if ($usu_id > 0) {
                    if ($query != "") {
                        $query .= ",{$usu_id}";
                    } else {
                        $query .= "{$usu_id}";
                    }
                }
            }

            /*  Se incluyó una restriccion para que solamente aparescan los usuarios que no han sido asignados como
              supervisor o como vendedor
             */
            if (strlen($query) > 0) {
                $query = $query;
            } else {
                $query = "0";
            }
            $crud = new grocery_CRUD();
            //Columnas a mostrar en READ
            $columns = array(
                'sup_nombre',
                'sup_apellido',
                'sup_email',
                'sup_estado',
            );

            //Alias para las columnas
            $alias = array(
                'sup_nombre' => 'Nombre',
                'sup_apellido' => 'Apellidos',
                'sup_email' => 'E-mail',
                'sup_estado' => 'Estado',
                'sup_id_usu' => 'Usuario',
                'sup_codigo' => 'Código',
                'sup_telefono' => 'Teléfono',
                'sup_extension' => 'Extensión'
            );


            //Columnas a mostrar en ADD
            $add_columns = array(
                'sup_id_usu',
                'sup_nombre',
                'sup_apellido',
                'sup_email',
                'sup_codigo',
                'sup_estado',
                'sup_fecha_mod',
                'sup_usu_mod', 'vendedores',
                'sup_telefono',
                'sup_extension'
            );

            //Columnas a mostrar en EDIT
            $edit_columns = $add_columns;

            $required_fields = array(
                'sup_nombre',
                'sup_apellido',
                'sup_estado',
                'sup_email',
                /* 'vendedores', */
                'sup_codigo');

            $crud->set_table('sup_supervisor')
                    ->set_subject('supervisores')
                    ->where('sup_estado <>', -1)
                    ->unset_delete()
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->required_fields($required_fields)
                    ->set_relation('sup_id_usu', 'users', 'username', "id in ( {$query} )")
                    ->set_rules('sup_estado', 'Estado', 'required')
                    ->set_rules('sup_email', 'E-mail', 'trim|required|valid_email')
                    ->set_rules('sup_extencion', 'Extensión', 'trim|is_numeric')
                    ->set_rules('sup_codigo', 'Código', 'trim|required|campo_unico[sup_supervisor.sup_codigo]');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('sup_estado', 'hidden', 1);
            } else {
                $crud->field_type('sup_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
            }
            //->add_action('Borrar', '', 'cotizaciones/mantenimientos/estado/ini?t=sup_supervisor?supervisores',' icomoon-icon-remove')
            $crud->field_type('sup_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('sup_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    /**
                     * 
                     * 
                     * @autor Rene Castaneda
                     * @since 17/05/2014 
                     *
                     * @return Mantenimiento de Tipo se seguimiento. (CRUD)
                     * Unicamente se agrego un add_action para el mantenimiento de vendedoresxsupervisor
                     * y un set_ralation_n_n
                     */
                    ->set_relation_n_n('vendedores', 'vxs_vendedorxsupervisor', 'ven_vendedor', 'vxs_id_sup', 'vxs_id_ven', '{ven_nombre} {ven_apellidos}', NULL, array('ven_estado' => 1))
                    ->add_action('Vendedores', '', 'proyectos/mantenimientos/vendedor_supervisor', 'icomoon-icon-stack');

            $output = $crud->render();
            $data['titulo_personal'] = "Supervisores";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function categorias() {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->tipo_articulo('proyectos/mantenimientos');
    }

    public function columna_padres($value, $row) {
        $valores = $this->proyecto_model->categorias_hijas_padres($row->tia_id);
        return $valores[0]['departamento'];
    }

    public function insertar_auditoria($post_array, $key) {
        $actualizar = array('cxr_estado' => 1,
            'cxr_usu_mod' => $this->tank_auth->get_user_id(),
            'cxr_fecha_mod' => date('Y-m-d H:i:s'));
        $this->db->where('cxr_id_tia', $key)
                ->update('cxr_caractxtipo_articulo', $actualizar);

        return true;
    }

    public function caracteristica() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $url_array = explode('/', uri_string());
            $crud = $this->new_crud();

//Columnas a mostrar en READ
            $columns = array(
                'car_codigo',
                'car_nombre',
                'car_descripcion'
            );

//Alias para las columnas
            $alias = array(
                'car_codigo' => 'Código',
                'car_nombre' => 'Nombre',
                'car_descripcion' => 'Descripción',
                'car_estado' => 'Estado'
            );

//Columnas a mostrar en ADD
            $add_columns = array(
                'car_codigo',
                'car_nombre',
                'car_descripcion',
                'car_estado',
                'car_usu_mod',
                'car_fecha_mod',
                'car_usu_crea',
                'car_fecha_crea'
            );


            $req_columns = array(
                'car_nombre',
                'car_estado'
            );

            $crud->set_table('car_caracteristica')->set_subject('Característica')->columns($columns)->display_as($alias)->add_fields($add_columns)->required_fields($req_columns)->field_type('car_usu_mod', 'hidden', $this->tank_auth->get_user_id())->field_type('car_fecha_mod', 'hidden', date('Y-m-d H:i:s'))->field_type('car_usu_crea', 'hidden', $this->tank_auth->get_user_id())->field_type('car_fecha_crea', 'hidden', date('Y-m-d H:i:s'))->set_rules('car_nombre', 'Nombre de la característica', 'trim|required|callback_caracteristica_nombre_unico');            
            if (end($url_array) == 'add') {
                $crud->field_type('car_estado', 'hidden', 1);
            } else {
                $crud->field_type('car_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $crud->callback_add_field('car_codigo', function () {
                $tabla = 'car_caracteristica';
                $campo = 'car_codigo';
                $last = $this->inventario_model->get_max_codigo($tabla, $campo);

                $code = $last->codigo;
                $cod = (int) $code + 1;
                $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);

                return '<input id="field-car_codigo" name="car_codigo" type="text" maxlength="99" value="' . $codigo . '" >';
            });

            $crud->callback_edit_field('car_codigo', function ($value, $primary_key) {
                if ($value == '') {
                    $tabla = 'car_caracteristica';
                    $campo = 'car_codigo';
                    $last = $this->inventario_model->get_max_codigo($tabla, $campo);

                    $code = $last->codigo;
                    $cod = (int) $code + 1;
                    $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);
                    return '<input id="field-car_codigo" name="car_codigo" type="text" maxlength="99" value="' . $codigo . '" >';
                } else {
                    return '<input id="field-car_codigo" name="car_codigo" type="text" maxlength="99" value="' . $value . '" >';
                }
            });

            $crud->edit_fields($add_columns);

// Validaciones
            $crud->unset_add();
            $data['agregar'] = true;
            if (!$permisos['permite_agregar']) {
                $data['agregar'] = false;
            }

            $crud->unset_edit();
            if ($permisos['permite_editar']) {
                //$crud->unset_edit();
                $crud->add_action('Editar', 'minia-icon-pencil', base_url().'proyectos/mantenimientos/caracteristicas_editar/');
            }

            $crud->unset_delete();
            if ($permisos['permite_eliminar']) {
                //$crud->unset_delete();
                $crud->add_action('Eliminar', 'icon16 icomoon-icon-remove', base_url().'proyectos/mantenimientos/caracteristicas_eliminar/');
            }

            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', base_url().'proyectos/mantenimientos/caracteristicas_ver/');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de características";

            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function cuentas_contables() {
        satelite_validar();

        $crud = new grocery_CRUD();
        $crud->set_table('cco_cuenta_contable')
                ->set_subject('cuentas')
                ->columns('cco_codigo', 'cco_nombre', 'cco_padre')
                ->display_as('cco_codigo', 'Código')
                ->display_as('cco_nombre', 'Nombre')
                ->display_as('cco_padre', 'Padre')
                ->required_fields('cco_nombre', 'cco_codigo')
                ->set_rules('cco_nombre', 'Nombre', 'trim|required|campo_unico[cco_cuenta_contable.cco_nombre]')
        ;

        $crud->fields('cco_codigo', 'cco_nombre', 'cco_padre');
        $crud->set_relation('cco_padre', 'cco_cuenta_contable', 'cco_nombre');
        $crud->unset_delete();

        $data['titulo_personal'] = "Cuentas contables";

        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    public function articulo() { 
        satelite_validar();
        $titulo = "Catálogo de productos";
        $this->load->library('../controllers/inventario/mantenimiento');
        $permisos = $this->gsatelite->get_permisos_opcion('proyectos/mantenimientos/articulo');
        $this->mantenimiento->articulo($titulo, 'proyectos', $permisos, "proyectos/mantenimientos");
    }

    function agregar_articulo($modulo = null) {
        
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        if($modulo==''){ $modulo = 2; }
        $info = $this->mantenimiento->agregar_articulo($modulo, true, 'proyectos/mantenimientos');

        $data['html'] = $this->load->view('inventario/mantenimiento/agregar_articulo', $info, true);
        $this->_cargarvista(null, $data);
    }

    public function agregar_pro_articulo() {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $html = $this->mantenimiento->agregar_pro_articulo('proyectos/mantenimientos/agregar_pro_articulo', 'proyectos/mantenimientos/categorias');
        $data['html'] = $html;
        $this->_cargarvista($data);
    }

    public function editar_pro_articulo($id_tia) {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $html = $this->mantenimiento->editar_pro_articulo($id_tia, 'proyectos/mantenimientos/editar_pro_articulo', 'proyectos/mantenimientos/categorias');
        $data['html'] = $html;
        $this->_cargarvista($data);
    }

    public function delete_pxa($primary_key) {
        $this->db->where('pxa_id_art', $primary_key);
        $this->db->delete('pxa_proveedorxarticulo');
        return true;
    }

// public function agregar_articulo(){
//   $data['categorias']=$this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado'=>1));
//   $data['medidas']=$this->gsatelite->get_tabla('mep_medida_producto', array('mep_estado'=>1));
//   $data['propositos']=$this->gsatelite->get_tabla('pra_proposito_articulo', array('pra_estado'=>1));
//   $data['proveedor']=$this->gsatelite->get_tabla('prv_proveedor', array('prv_estado'=>1));
//   $data['titulo_personal']="Agregar artículo";
//   $this->_cargarvista($data);
// }

    public function guardar_articulo() {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->guardar_articulo('proyectos/mantenimientos');
    }

    public function actualizar_articulo() {
        //print_r($_POST);exit();
        $articulo_cabezera = array(
            'art_id_tia' => $_POST['categoria'],
            'art_id_mep' => $_POST['medida'],
            'art_nombre' => $_POST['nombre'],
            'art_descripcion' => $_POST['descripcion'],
            'art_codigo' => $_POST['codigo'],
            'art_foto' => ($_POST['edit_foto']) ? $_POST['edit_foto'] : $_POST['id_foto'],
            'art_minimo' => ($_POST['minimo'] == "") ? null : $_POST['minimo'],
            'art_maximo' => ($_POST['maximo'] == "") ? null : $_POST['maximo'],
            'art_fecha' => date('Y-m-d H:i:s'),
            'art_estado' => $_POST['estado'],
            'art_usu_mod' => $this->tank_auth->get_user_id(),
            'art_fecha_mod' => date('Y-m-d H:i:s'),
            'art_aplica_serie' => $_POST['serie'],
            'art_codigo_proveedor' => $_POST['codigo_proveedor'],
            'art_inventario' => ($this->input->post('art_inventario')) ? 1 : 0,
            'art_venta' => ($this->input->post('art_venta')) ? 1 : 0,
            'art_compra' => ($this->input->post('art_compra')) ? 1 : 0
        );
        $this->db->where('art_id', $_POST['articulo'])->update('art_articulo', $articulo_cabezera);
        $this->db->where('axp_id_art', $_POST['articulo']);
        $this->db->delete('axp_articuloxproposito');

        $this->db->where('pxa_id_art', $_POST['articulo']);
        $this->db->delete('pxa_proveedorxarticulo');

        $art_id = $this->input->post('articulo');

        $proveedores = $this->input->post('proveedor');
        //die(print_r($proveedores));
        for ($k = 0; $k < count($proveedores); $k++) {
            if ($proveedores[$k] > 0) {
                $prvxart = array(
                    'pxa_id_art' => $art_id,
                    'pxa_id_prv' => $proveedores[$k],
                    'pxa_estado' => 1,
                    'pxa_usu_mod' => $this->tank_auth->get_user_id(),
                    'pxa_fecha_mod' => date('Y-m-d-H-i-s')
                );
                $cxu = $this->gsatelite->ingresar('pxa_proveedorxarticulo', $prvxart);
            }
        }

        $this->db->where('cxu_id_art', $_POST['articulo']);
        $this->db->delete('cxu_caracxarticulo');

        $caracteristica = $_POST['caracteristicas'];
        $caracteristica_valor = $_POST['valor_cxc'];
        $caracteristica_estado = $_POST['estado_cxc'];

        for ($i = 0; $i < count($caracteristica); $i++) {
            if ($caracteristica[$i] != "") {
                $caracxart = array(
                    'cxu_id_cxr' => $caracteristica[$i],
                    'cxu_id_art' => $_POST['articulo'],
                    'cxu_valor' => $caracteristica_valor[$i],
                    'cxu_estado' => $caracteristica_estado[$i],
                    'cxu_usu_mod' => $this->tank_auth->get_user_id(),
                    'cxu_fecha_mod' => date('Y-m-d-H-i-s')
                );
                $cxu = $this->gsatelite->ingresar('cxu_caracxarticulo', $caracxart);
            }
        }

        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Actualización de artículos", 'texto_alerta' => "El registro se actualizo correctamente");
        $this->session->set_flashdata($alerta);
        redirect('/proyectos/mantenimientos/articulo');
    }

    function editar_articulo($id_art) {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $info = $this->mantenimiento->editar_articulo($id_art, '7', 'proyectos/mantenimientos');
        //$data['html'] = $this->load->view('inventario/mantenimiento/editar_articulo', $info, true);

        //$this->_cargarvista(null, $data);
    }

    /* public function editar_articulo($articulo)
      {
      $data['categorias']=$this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado'=>1));
      $data['medidas']=$this->gsatelite->get_tabla('mep_medida_producto', array('mep_estado'=>1));
      $data['propositos']=$this->gsatelite->get_tabla('pra_proposito_articulo', array('pra_estado'=>1));
      $data['cabezera']=$this->db->get_where('art_articulo',array('art_id' => $articulo))->result_array();
      $data['articulo']=$articulo;
      $data['consul'] = $this->gsatelite->get_tabla('pxa_proveedorxarticulo',array('pxa_id_art'=>$articulo));
      $data['caracxart']=$this->db->join('cxr_caractxtipo_articulo','cxr_id=cxu_id_cxr')
      ->join('car_caracteristica','car_id=cxr_id_car')
      ->where('cxu_id_art', $articulo)
      ->get('cxu_caracxarticulo')->result_array();
      $data['caracxtia']=$this->db->join('car_caracteristica','car_id=cxr_id_car')
      ->where('cxr_id_tia',$data['cabezera'][0]['art_id_tia'])
      ->get('cxr_caractxtipo_articulo')->result_array();

      $data['titulo_personal']="Edición de artículo";
      $this->_cargarvista($data);
      } */

    function precios_articulo($id_art) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('art_articulo', $id_art);
        // $crud = new grocery_CRUD();
        $crud = new grocery_CRUD();
        $crud->set_table('lip_listado_precio')
                ->set_subject('Precio Producto')
                ->where('lip_id_art', $id_art)
                ->columns('lip_desde', 'lip_hasta', 'lip_precio', 'lip_estado')
                ->fields('lip_id_art', 'lip_desde', 'lip_hasta', 'lip_precio', 'lip_id_mep', 'lip_estado', 'lip_usu_mod', 'lip_fecha_mod')
                ->display_as('lip_desde', 'Cantidad Desde')
                ->display_as('lip_hasta', 'Cantidad Hasta')
                ->display_as('lip_precio', 'Precio')
                ->display_as('lip_estado', 'Estado')
                ->display_as('lip_id_mep', 'Unidad')
                ->required_fields('lip_id_art', 'lip_desde', 'lip_hasta', 'lip_precio', 'lip_estado', 'lip_id_mep')
                ->set_rules('lip_desde', 'Cantidad Desde', 'trim|is_numeric|required|callback_validacion_rango')
                ->set_rules('lip_hasta', 'Cantidad Hasta', 'trim|required|is_numeric')
                ->set_rules('lip_precio', 'Precio', 'trim|required|is_numeric')
                ->field_type('lip_id_art', 'hidden', $id_art)
                ->field_type('lip_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('lip_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->unset_delete()
        ;
        $crud->set_relation('lip_id_mep', 'mep_medida_producto', 'mep_nombre', array('mep_estado' => '1'));
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('lip_estado', 'hidden', 1);
        } else {  // Editar
            $crud->field_type('lip_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $data['titulo_personal'] = "Listado de Precios";
        $data['registro_art'] = $this->gsatelite->get_registro('art_articulo', 'art_id', $id_art);

        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    public function validacion_rango($data) {
        if ($data != '') {
            //  die(var_dump($_POST));
            $validado1 = false; //variable que cambiará de valor cuando no se cumpla una condición de validación
            $validado2 = false; //variable que cambiará de valor cuando no se cumpla la segunda condición de validación

            $f1 = $this->input->post('lip_desde');
            $f2 = $this->input->post('lip_hasta');
            $id_art = $this->input->post('lip_id_art');
            if ($f2 >= $f1) {
                $validado1 = true;
            } //primera condición
            else {
                $this->form_validation->set_message('validacion_rango', 'El campo desde debe ser menor al campos hasta');
                return false;
            }

            //PREGUNTAR SI EXISTEN REGISTROS DE FECHA DESDE MAYOR A LA INGRESADA. (PARA EVITAR REGISTRO CRUZADOS) 
            $url_array = explode('/', uri_string()); //en el caso de edit
            $no_incluir = (is_numeric(end($url_array)) and end($url_array) > 0 ) ? end($url_array) : 0;
            $pregunta = $this->gsatelite->get_tabla('lip_listado_precio', array('lip_id !=' => $no_incluir, 'lip_hasta' => $f2, 'lip_desde' => $f1, 'lip_id_art' => $id_art));
            $pregunta2 = $this->gsatelite->get_tabla('lip_listado_precio', array('lip_id !=' => $no_incluir, 'lip_hasta >=' => $f1, 'lip_id_art' => $id_art));

            if (count($pregunta) > 0) {
                $this->form_validation->set_message('validacion_rango', 'Ya existen otro registro con un rango similar');
                return false;
            }
            if (count($pregunta2) > 0 and ! is_numeric(end($url_array))) {
                $this->form_validation->set_message('validacion_rango', 'Ya existen otro registro que contiene la cantidad desde');
                return false;
            } else {
                $validado2 = true;
            }
            return ($validado1 and $validado2) ? true : false;
        } else {
            return true;
        }
    }

    public function verificar_codigo_edit() {
        $codigo = $this->input->post('codigo');
        $articulo = $this->input->post('articulo');
        $existe = $this->db->where(array('art_codigo' => $codigo, 'art_id <>' => $articulo))->get('art_articulo')->result_array();
        $arreglo = array('drop' => count($existe));

        echo json_encode($arreglo);
    }

    public function caracteristicasxtipoarticulo() {
        $categoria = $this->input->post('categoria');

        $this->db->where('car_modulo', 1); //condicionar que sean las del modulo inventarios las caracteristicas que carguen
        $caracteristicas = $this->db->join('car_caracteristica', 'car_id=cxr_id_car')->where('cxr_id_tia', $categoria)->get('cxr_caractxtipo_articulo')->result_array();
        $cadena = "";
        $cadena = '<option value="0" selected="selected"></opction>';
        foreach ($caracteristicas as $k) {
            $cadena .= '<option value="' . $k['car_id'] . '">' . $k['car_nombre'] . '</option>';
        }
        $arreglo = array('drop' => $cadena);
        echo json_encode($arreglo);
    }

    function vendedores($modulo = NULL) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $crud = new grocery_CRUD();

            $crud->set_table('ven_vendedor')
                    ->set_subject('Vendedor')
                    ->columns('ven_nombre', 'ven_apellidos', 'ven_estado')
                    ->display_as('ven_nombre', 'Nombre')
                    ->display_as('ven_apellidos', 'Apellido')
                    ->display_as('ven_estado', 'Estado')
                    ->unset_delete()
                    ->unset_edit()
                    ->unset_add()
            ;


            $crud->add_action('Editar', '', 'proyectos/mantenimientos/editar_vendedores', 'icomoon-icon-pencil-5');


            //->add_action('Contactos', '','cotizaciones/mantenimientos/contactos/','icomoon-icon-user')


            /*
              ->field_type('cod_usu_mod', 'hidden', $this->tank_auth->get_user_id())
              ->field_type('cod_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
              ->field_type('cod_usu_crea','hidden', $this->tank_auth->get_user_id())
              ->field_type('cod_fecha_crea','hidden', date('Y-m-d H:i:s'))
              ; */
            /*
              $crud->add_fields('cod_nombre','cod_descripcion','cod_usu_crea','cod_usu_mod','cod_fecha_crea','cod_fecha_mod','cod_estado');
              $crud->edit_fields('cod_nombre','cod_descripcion','cod_usu_mod','cod_fecha_mod','cod_estado');
             */
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('ven_estado', 'hidden', 1);
            } else {  // Editar
                $crud->field_type('ven_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $data['titulo_personal'] = "Vendedores";

            $output = $crud->render();
            $this->_cargarvista($data, $output);
        }
    }

    function ingresar_vendedores($modulo = NULL) {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            //satelite_validar();
            $this->db->join("emp_empleado", "emp_id_usu=id");

            $data['usuarios_act'] = $this->gsatelite->get_tabla('users');

            $data['supervisores'] = $this->gsatelite->get_dropdown('sup_supervisor', 'sup_nombre', '', array('sup_estado' => 1), null, '', 'sup_id', true);


            if ($_POST) {
                // die(print_r($_POST,TRUE));
                $array_vendendor = array(
                    'ven_id_usu' => $this->input->post('usuario'),
                    'ven_codigo' => $this->input->post('codigo_vendedor'),
                    'ven_nombre' => $this->input->post('nombre'),
                    'ven_apellidos' => $this->input->post('apellido'),
                    'ven_meta_cotizado' => (!empty($_POST['meta_mensual_cotizaciones'])) ? $_POST['meta_mensual_cotizaciones'] : NULL,
                    'ven_meta_ventas' => (!empty($_POST['meta_mensual_ventas'])) ? $_POST['meta_mensual_ventas'] : NULL,
                    'ven_numero_visitas' => (!empty($_POST['visitas_clientes'])) ? $_POST['visitas_clientes'] : NULL,
                    'ven_telefono' => $this->input->post('telefono'),
                    'ven_email' => $this->input->post('email'),
                    'ven_estado' => 1,
                    'ven_usu_mod' => $this->tank_auth->get_user_id(),
                    'ven_fecha_mod' => date('Y-m-d H:i:s'),
                );
                // die(print_r($array_vendendor,true));

                $contrato_id = $this->gsatelite->ingresar('ven_vendedor', $array_vendendor);

                $supervisor = $this->input->post('supervisor');

                //for de ingreso de supervisores
                foreach ($supervisor as $key => $value) {
                    $ingresarSup[] = array('vxs_id_sup' => $supervisor[$key], 'vxs_id_ven' => $contrato_id);
                    $this->gsatelite->ingresar('vxs_vendedorxsupervisor', $ingresarSup[$key]);
                }

                // Mostrar alerta
                if ($contrato_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro se guardó correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro no se guardó.");
                }

                $this->session->set_flashdata($alerta);
                if ($_POST['facturacion'])
                    $this->gsatelite->show_dialog('Cajero ingresado con éxito!', "facturacion/entradas/vendedores");
                redirect('/proyectos/mantenimientos/vendedores');
            } else {
                //$data['departamentos'] = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}','', array('dep_estado' => '1'), null, '', 'dep_id', true);
                //$data['proveedores'] = $this->gsatelite->get_dropdown('prv_proveedor', '{prv_nombre} {prv_apellido}','', array('prv_estado' => '1'), null, '', 'prv_id', true);

                $data['titulo_personal'] = "Agregar vendedor";
                if ($modulo)
                    return $data;
                $this->_cargarvista($data);
            }
        }
    }

    /*
      public function validar_vendedor($str)
      {

      $id=  end(explode("/",uri_string()));
      if(is_numeric($id) )
      {
      $username_old = $this->db->where("ven_id",$id)->get('ven_vendedor')->row()->mep_nombre;
      $num_row = $this->db->where('ven_codigo',$str)->where('ven_id !=',$id)->get('ven_vendedor')->num_rows();
      if ($num_row >= 1)
      {
      $this->form_validation->set_message('validar_vendedor', 'El código del vendedor ya existe');
      return false;
      }
      else
      {
      return TRUE;
      }
      }
      else{
      $num_row = $this->db->where('ven_codigo',$str)->get('ven_vendedor')->num_rows();
      if ($num_row >= 1)
      {
      $this->form_validation->set_message('validar_vendedor', 'El código del vendedor ya existe');
      return FALSE;
      }
      else
      {
      return TRUE;
      }
      }
      } */

    /**
     * ====================
     * @Autor: CHRISTIAN
     * ===================
     * */
    function editar_vendedores($id_vendedor, $modulo = NULL) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            //satelite_validar();
            // mostrar  informacion
            $data['id_vendedor'] = $id_vendedor;

            $vendedor = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id' => $id_vendedor));
            $user = $this->gsatelite->get_campo('ven_vendedor', 'ven_id_usu', array('ven_id' => $id_vendedor));
            $vendedor_emp = $this->gsatelite->get_tabla('emp_empleado', array('emp_id_usu' => $user));

            foreach ($vendedor as $key => $value) {

                $id_usuario_vendedor = $value['ven_id_usu'];

                $data['usuarios_act_editar'] = $this->gsatelite->get_tabla('users', array('id' => $id_usuario_vendedor));
            }


            $data['vendedor'] = $vendedor;
            $data['vendedor_emp'] = $vendedor_emp;





            //preguntar supervisores

            $supxvendedor = $this->gsatelite->get_tabla('vxs_vendedorxsupervisor', array('vxs_id_ven' => $id_vendedor));

            //mostrar arreglo de supervisores

            $supervSelec = array();

            foreach ($supxvendedor as $key => $value) {

                $supervSelec[] = $value['vxs_id_sup'];
            }

            $data['supervisores'] = $this->gsatelite->get_dropdown('sup_supervisor', 'sup_nombre', '', array('sup_estado' => 1), $supervSelec, '', 'sup_id', true);


            $data['titulo_personal'] = "Editar vendedor";
            if ($modulo)
                return $data;
            $this->_cargarvista($data);
        }
    }

    public function ingresarEdicionVendedores() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                //die(print_r($_POST));
                $id_vendedor = $this->input->post('id_vendedor');

                $meta_venta = $this->input->post('meta_mensual_ventas');
                if ($meta_venta != '') {
                    $meta_venta = $this->input->post('meta_mensual_ventas');
                } else {
                    $meta_venta = NULL;
                }
                //die(print_r($meta_venta));
                $array_vendendor = array(
                    'ven_id_usu' => $this->input->post('usuario'),
                    'ven_codigo' => $this->input->post('codigo_vendedor'),
                    'ven_nombre' => $this->input->post('nombre'),
                    'ven_apellidos' => $this->input->post('apellido'),
                    'ven_meta_cotizado' => (!empty($_POST['meta_mensual_cotizaciones']) ) ? $_POST['meta_mensual_cotizaciones'] : null,
                    'ven_meta_ventas' => (!empty($_POST['meta_mensual_ventas']) ) ? $_POST['meta_mensual_ventas'] : null,
                    'ven_numero_visitas' => (!empty($_POST['visitas_clientes'])) ? $_POST['visitas_clientes'] : NULL,
                    'ven_telefono' => $this->input->post('telefono'),
                    'ven_email' => $this->input->post('email'),
                    'ven_estado' => (!empty($_POST['estado'])) ? 1 : $_POST['estado'],
                    'ven_usu_mod' => $this->tank_auth->get_user_id(),
                    'ven_fecha_mod' => date('Y-m-d H:i:s'),
                );

                //die(print_r($array_vendendor,true));

                $contrato_id = $this->gsatelite->actualizar_array('ven_vendedor', $array_vendendor, array('ven_id' => $id_vendedor));





                //borrar supervisores actuales

                $this->gsatelite->borrado_general('vxs_vendedorxsupervisor', array('vxs_id_ven' => $id_vendedor));

                //capturar nuevos supervisores
                $supervisor = $this->input->post('supervisor');


                //for de ingreso de supervisores
                foreach ($supervisor as $key => $value) {


                    $ingresarSup[] = array('vxs_id_sup' => $supervisor[$key], 'vxs_id_ven' => $id_vendedor);

                    $respuesta = $this->gsatelite->ingresar('vxs_vendedorxsupervisor', $ingresarSup[$key]);
                }




                // Alcamenado de las Obligaciones
                // Mostrar alerta
                if ($contrato_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro se guardó correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro no se guardó.");
                }

                $this->session->set_flashdata($alerta);
                if ($_POST['facturacion'])
                    $this->gsatelite->show_dialog('El registro se editó correctamente', "facturacion/entradas/vendedores");
                redirect('/proyectos/mantenimientos/vendedores');
            } else {
                //$data['departamentos'] = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}','', array('dep_estado' => '1'), null, '', 'dep_id', true);
                //$data['proveedores'] = $this->gsatelite->get_dropdown('prv_proveedor', '{prv_nombre} {prv_apellido}','', array('prv_estado' => '1'), null, '', 'prv_id', true);

                $data['titulo_personal'] = "Editar vendedor";
                $this->_cargarvista($data);
            }
        }
    }

    /**
     * @author: Mario Marquez
     * @since: 24/06/2017
     * Mantenimiento de tipos de orden de producción
     */
    function tipo_orden() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('proyectos/mantenimientos/tipo_orden');
        $crud = new grocery_CRUD();
        $crud->set_table('tio_tipo_orden');
        $crud->set_subject('Tipo de Orden');

        $columns = array(
            'tio_nombre',
            'tio_prefijo',
            'tio_descripcion',
            'tio_estado'
        );

        $required = array(
            'tio_nombre',
            'tio_estado'
        );

        $display_as = array(
            'tio_nombre' => 'Nombre',
            'tio_prefijo' => 'Prefijo',
            'tio_descripcion' => 'Descripción',
            'tio_estado' => 'Estado',
        );

        $add_fields = array(
            'tio_nombre',
            'tio_prefijo',
            'tio_descripcion',
            'tio_estado',
            'tio_usu_creacion',
            'tio_fecha_creacion',
            'tio_usu_modificacion',
            'tio_fecha_modificacion'
        );

        $edit_fields = array(
            'tio_nombre',
            'tio_prefijo',
            'tio_descripcion',
            'tio_estado',
            'tio_usu_modificacion',
            'tio_fecha_modificacion'
        );

        $crud->required_fields($required);
        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->add_fields($add_fields);
        $crud->edit_fields($edit_fields);
        $crud->field_type('tio_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('tio_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->set_rules('tio_nombre', 'Nombre', 'trim|required|campo_unico[tio_tipo_orden.tio_nombre]');
        $crud->set_rules('tio_prefijo', 'Prefijo', 'trim|campo_unico[tio_tipo_orden.tio_prefijo]');


        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tio_estado', 'hidden', 1);
            $crud->field_type('tio_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tio_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {  // Editar
            $crud->field_type('tio_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Tipos de Orden";
        $this->_cargarvista($data, $output);
    }

    /**
     * @author: Mario Marquez
     * @since: 24/06/2017
     * Mantenimiento de tipos de orden de producción
     */
    function etapas() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('proyectos/mantenimientos/etapas');
        $crud = new grocery_CRUD();
        $crud->set_table('etp_etapa');
        $crud->set_subject('Etapas');

        $columns = array(
            'etp_nombre',
            'etp_descripcion',
            'etp_id_bod',
            // 'Sector',
            // 'etp_horas',
            'etp_estado'
        );

        $required = array(
            'etp_nombre',
            'etp_estado'
        );

        $display_as = array(
            'etp_nombre' => 'Nombre',
            'etp_descripcion' => 'Descripción',
            'etp_id_bod' => 'Bodega',
            // 'etp_horas' => 'Duración/Horas',
            'etp_estado' => 'Estado',
            // 'etp_id_sxb' => 'Sector',
        );

        $add_fields = array(
            'etp_nombre',
            'etp_descripcion',
            'etp_id_bod',
            // 'etp_horas',
            // 'etp_id_sxb',
            'etp_estado',
            'etp_usu_creacion',
            'etp_fecha_creacion',
            'etp_usu_modificacion',
            'etp_fecha_modificacion'
        );

        $edit_fields = array(
            'etp_id',
            'etp_nombre',
            'etp_descripcion',
            'etp_id_bod',
            // 'etp_horas',
            'etp_estado',
            // 'etp_id_sxb',
            'etp_usu_modificacion',
            'etp_fecha_modificacion'
        );
        // Se aregró en el Grid la columna de Sector por Bodega. Agregó por Luis Navarro
        $crud->callback_column('Sector', function($value, $row) {
            $consulta = $this->gsatelite->get_tabla('etp_etapa', array('etp_id'=>$row->etp_id, 'etp_estado'=>1));
            if (trim($consulta[0]['etp_id_sxb'])>0) {
                $sectores = $this->proyecto_model->get_sector_por_bodega(array('sxb_id'=>$consulta[0]['etp_id_sxb'], 'sxb_estado'=>1));
                foreach ($sectores as $key => $sector) {
                    return $sector['seb_nombre'];
                }
            }
        });

        $crud->required_fields($required);
        $crud->columns($columns);
        $crud->add_fields($add_fields);
        $crud->edit_fields($edit_fields);
        $crud->display_as($display_as);
        $crud->set_relation('etp_id_bod', 'bod_bodega', '{bod_nombre}', array('bod_estado' => 1));
        $crud->field_type('etp_id', 'hidden');
        $crud->field_type('etp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('etp_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->set_relation('etp_id_sxb','sxb_sectorxbodega','{sxb_id_bod}');
        $crud->set_rules('etp_nombre', 'Nombre', 'trim|required|campo_unico[etp_etapa.etp_nombre]');

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('etp_estado', 'hidden', 1);
            $crud->field_type('etp_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('etp_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {  // Editar
            $crud->field_type('etp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Etapas";
        $this->_cargarvista($data, $output);
    }

    /**
    * @descripcion
    * Se realizo la creacion de una funcion para poder agregar factores de calidad a un articulo
    * @author Elmer Hernandez
    * @since 17/10/2019
    * @param integer $art_id
    * @return Mantenimiento de factores de calidad por producto.
    * 
    */

     function factor_calidad_articulo($art_id = null){
        satelite_validar();
        if ($art_id == null) {
            redirect('proyectos/mantenimientos/articulo');
        }
        if ($this->input->post()) {
            $post_array = $this->input->post();     
            $id = $this->input->post('txt_codigo_articulo'); 
            //fca_factores_calidad_articulo
            $hdnDetalle  = $post_array['hdnDetalle'];
            $factores    = $post_array['factores'];//Nuevos factores
            $unidades    = $post_array['unidades'];//unidades de los factores
            $referencias = $post_array['referencias'];//Nuevas referencias            
            
            $fac_id = 0;
            $idsFactores = array();
            if (count($factores) > 0) {
                for ($i = 0; $i < count($factores); $i ++) {
                    if ($hdnDetalle[$i] > 0) {
                        $idsFactores[] = $hdnDetalle[$i];
                    }
                }
                //Se eliminan los que no existan
                $dataFactores = $this->gsatelite->get_tabla('fca_factores_calidad_articulo', array('fca_id_art' => $art_id));
                foreach ($dataFactores as $row) {   
                    if (!in_array($row['fca_id'], $idsFactores)) {
                        $this->gsatelite->borrado_general('fca_factores_calidad_articulo', array('fca_id' => $row['fca_id']));
                    }
                }

                for ($i = 0; $i < count($factores); $i ++) {
                    $factores_array = array(
                        'fca_id_fcc'            => $factores[$i],
                        'fca_id_art'            => $art_id,
                        'fca_referencia'        => $referencias[$i],
                        'fca_unidad'            => $unidades[$i],
                        'fca_estado'            => 1,
                        'fca_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'fca_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'fca_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'fca_fecha_modificacion'=> date('Y-m-d H:i:s'),
                    );

                    $dataValidacion[$i] = $this->gsatelite->get_tabla('fca_factores_calidad_articulo', array('fca_id_art' => $art_id, 'fca_id_fcc' => $factores[$i]));
                    //Si factor por articulo ya existe se actualiza sino se ingresa
                    if (count($dataValidacion[$i])>0) {
                        unset($factores_array['fca_id_art']);
                        unset($factores_array['fca_id_fcc']);                        
                        unset($factores_array['fca_estado']);
                        unset($factores_array['fca_usu_creacion']);
                        unset($factores_array['fca_fecha_creacion']);

                        $fac_id += $this->gsatelite->actualizar_array('fca_factores_calidad_articulo', $factores_array, array('fca_id' => $hdnDetalle[$i]));
                    }else{
                        $fac_id += $this->gsatelite->ingresar('fca_factores_calidad_articulo', $factores_array);
                    }
                }
            }

            if ($fac_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Factores de calidad", 'texto_alerta' => "La información se proceso correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Datos no ingresados, favor verificar información");
            }

            $this->session->set_flashdata($alerta);

            $tipoBtn = $post_array['btnCrear'];

            if ($tipoBtn == 1) {
                redirect('proyectos/mantenimientos/factor_calidad_articulo/' . $art_id);
            } else {
                redirect('proyectos/mantenimientos/articulo');
            }
        }else{
            $option = "";
            $producto = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $art_id));
            $data['producto'] = $producto[0];
            $factores = $this->gsatelite->get_tabla('fcc_factor_calidad', array('fcc_estado' => 1));
            foreach ($factores as $key => $value) {
                $option .= '<option value="' . $value['fcc_id'] . '" data-unidad="' . $value['fcc_unidad'] . '">' . $value['fcc_nombre'] . '</option>';
            }
            $data['factores_calidad'] = $option;
                                                     $this->db->join('fcc_factor_calidad','fcc_id = fca_id_fcc');
            $data['factores_calidad_por_articulo'] = $this->gsatelite->get_tabla('fca_factores_calidad_articulo', array('fca_estado' => 1, 'fca_id_art' => $art_id));            
            $data['titulo_personal'] = "Factores de calidad por producto";
            cargarvista($data);

        }
    }

    function etapas_produccion($art_id = null) {
        satelite_validar();
        if ($art_id == null) {
            redirect('proyectos/mantenimientos/articulo');
        }

        if ($this->input->post()) {
            $post_array = $this->input->post();     
           
            //art_articulo
            $art_cantidad_prod_etapa = $this->input->post('txtcantidad');
            $art_id_cva_prod_etapa   = $this->input->post('slc_medida');
            $id                      = $this->input->post('txt_codigo_articulo'); 

            $art_articulo  = array (
                'art_cantidad_prod_etapa'   => $art_cantidad_prod_etapa,
                'art_id_cva_prod_etapa'     => $art_id_cva_prod_etapa
            );        

            $this->gsatelite->actualizar_array('art_articulo', $art_articulo, array('art_id' => $id));

            //eta_etapa_articulo
            $hdnDetalle         = $post_array['hdnDetalle'];
            $etapas             = $post_array['etapas'];
            $duraciones         = $post_array['duraciones'];
            $hdnFinaliza        = $post_array['hdnFinaliza'];
            $numOrden           = $post_array['numOrden'];
            $eta_duracion_mod   = $this->input->post('mod');
            $exo_id             = 0;
                        
            $idsEtapas = array();
            if (count($etapas) > 0) {
                for ($i = 0; $i < count($etapas); $i ++) {
                    if ($hdnDetalle[$i] > 0) {
                        $idsEtapas[] = $hdnDetalle[$i];
                    }
                }
                //Se eliminan los que no existan
                $dataEtapas = $this->gsatelite->get_tabla('eta_etapa_articulo', array('eta_id_art' => $art_id));
                foreach ($dataEtapas as $row) {
                    if (!in_array($row['eta_id'], $idsEtapas)) {
                        $this->gsatelite->borrado_general('eta_etapa_articulo', array('eta_id' => $row['eta_id']));
                    }
                }

                for ($i = 0; $i < count($etapas); $i ++) {
                    $etapas_array = array(
                        'eta_id_etp'            => $etapas[$i],
                        'eta_id_art'            => $art_id,
                        'eta_id_cva'            => $art_id_cva_prod_etapa,
                        'eta_duracion'          => $duraciones[$i],
                        'eta_duracion_mod'      => $eta_duracion_mod[$i],
                        'eta_orden'             => $numOrden[$i],
                        'eta_final'             => $hdnFinaliza[$i],
                        'eta_estado'            => 1,
                        'eta_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'eta_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'eta_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'eta_fecha_modificacion'=> date('Y-m-d H:i:s'),
                    );
                    //Si el detalle existe se actualiza sino se ingresa
                    if ($hdnDetalle[$i] != '0') {
                        unset($etapas_array['eta_id_art']);
                        unset($etapas_array['eta_usu_creacion']);
                        unset($etapas_array['eta_fecha_creacion']);

                        $exo_id += $this->gsatelite->actualizar_array('eta_etapa_articulo', $etapas_array, array('eta_id' => $hdnDetalle[$i]));
                    } else {
                        $exo_id += $this->gsatelite->ingresar('eta_etapa_articulo', $etapas_array);
                    }
                }
            }

            if ($exo_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Etapas de Producción", 'texto_alerta' => "La información se proceso correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Orden no ingresada, favor verificar información");
            }

            $this->session->set_flashdata($alerta);

            $tipoBtn = $post_array['btnCrear'];

            if ($tipoBtn == 1) {
                redirect('proyectos/mantenimientos/etapas_produccion/' . $art_id);
            } else {
                redirect('proyectos/mantenimientos/articulo');
            }
        } else {
            $this->db->order_by('eta_orden ASC');
            $data['detalle_etapas'] = $this->proyecto_model->get_etapas_articulo(array('eta_id_art' => $art_id));
    
            $producto           = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $art_id));
            $data['producto']   = $producto[0];
            $data['etapas']     = $this->proyecto_model->get_etapas(array('etp_estado' => 1));
                             
            $this->db->join('mep_medida_producto','mep_id = cva_id_mep');
            $data['medidas']    = $this->gsatelite->get_tabla('cva_conversion_articulo', array('mep_estado' => '1', 'cva_id_art' => $art_id) );   
            $data['titulo_personal'] = "Etapas de Producción por Producto";
            cargarvista($data);
        }
    }

    /**
     * @author Elman Ortiz
     * @date 15/08/2017
     */
    function caracteristicas_agregar(){        
        satelite_validar();        
        if ($this->input->post('tipoboton') == 'cancel') {
            redirect('proyectos/mantenimientos/caracteristica');
        }

        if ($this->input->post()) {//Para guardar las caracteristicas            
            //Crear arreglo caracteristicas
            $caracteristica_array = array(
                'car_codigo' => ($this->input->post('car_codigo')) ? $this->input->post('car_codigo') : null,
                'car_nombre' => $this->input->post('inpNombre'),
                'car_descripcion' => $this->input->post('inpDescripcion'),
                'car_tipo' => $this->input->post('slcTipo'),
                'car_estado' => 1,
                'car_usu_crea' => $this->tank_auth->get_user_id(),
                'car_fecha_crea' => date('Y-m-d H:i:s'),
                'car_usu_mod' => $this->tank_auth->get_user_id(),
                'car_fecha_mod' => date('Y-m-d H:i:s')
            );

            $car_id = $this->gsatelite->ingresar('car_caracteristica', $caracteristica_array);
            $valor  = $this->input->post('valores');
            $precio = $this->input->post('preciosCa');
            $lista  = array_combine($valor, $precio);
            if ($lista) {
                //$elem = " ";
                foreach ($lista as $key => $value) {                    
                    //vrl_valores_lista
                    $valores_lista_array = array(                
                        'vrl_id_car' => $car_id,
                        'vrl_valor' => $key,
                        'vrl_precio_valor' => ($value != '')?$value:null,
                        'vrl_estado' => 1,
                        'vrl_usu_creacion' => $this->tank_auth->get_user_id(),
                        'vrl_fecha_creacion' => date('Y-m-d H:i:s'),
                        'vrl_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'vrl_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $result = $this->gsatelite->ingresar('vrl_valores_lista', $valores_lista_array);
                }                                
            }/*else{
                //vrl_valores_lista
                $valores_lista_array = array(                
                    'vrl_id_car' => $car_id,
                    'vrl_valor' => ($this->input->post('inpValorUnico')) ? $this->input->post('inpValorUnico') : null,
                    'vrl_estado' => 1,
                    'vrl_usu_creacion' => $this->tank_auth->get_user_id(),
                    'vrl_fecha_creacion' => date('Y-m-d H:i:s'),
                    'vrl_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'vrl_fecha_modificacion' => date('Y-m-d H:i:s')
                );  
            }*/
            
            if ($car_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "El registro se guardó correctamente.");
            }else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            $this->session->set_flashdata($alerta);

            if ($this->input->post('tipoboton') == 'save') {
                redirect('proyectos/mantenimientos/caracteristicas_agregar/');
            } else {
                redirect('proyectos/mantenimientos/caracteristica');
            }
        }else{//Mostrar vista para caracteristicas            
            $last = $this->inventario_model->get_max_codigo('car_caracteristica', 'car_codigo');
            $code = $last->codigo;
            $cod = (int) $code + 1;
            $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);            

            $data['titulo_personal'] = "Catálogo de características";
            $data['codigo'] = $codigo;
            $this->_cargarvista($data);
        }
    }

    /**
     * @author Elman Ortiz
     * @date 17/08/2017
     */
    function caracteristicas_ver($car_id){                            
        satelite_validar();        
        $carac = $this->inventario_model->get_caracteristicas($car_id);
        $data['caracteristica'] = $carac;
        $data['titulo_personal'] = "Ver características";                    
        $this->_cargarvista($data);
    }

    /**
     * @author Elman Ortiz
     * @date 17/08/2017
     */
    function caracteristicas_eliminar($car_id){        
        $tbl_vrl = $this->gsatelite->get_tabla('vrl_valores_lista', array('vrl_id_car' => $car_id));        
        $result1 = $this->gsatelite->borrado_general('vrl_valores_lista', array('vrl_id_car' => $car_id));        
        $result2 = $this->inventario_model->delete_caracteristica(array('car_id' => $car_id));        
        if ($result2 < 1 && count($tbl_vrl) > 0) {//No se pudo borrar y reversion de los datos eliminados
            $vrl_array = array(                
                'vrl_id_car' => $tbl_vrl[0]['vrl_id_car'],
                'vrl_valor' => $tbl_vrl[0]['vrl_valor'],                
                'vrl_estado' => $tbl_vrl[0]['vrl_estado'],
                'vrl_usu_modificacion' => $tbl_vrl[0]['vrl_usu_modificacion'],
                'vrl_fecha_modificacion' => $tbl_vrl[0]['vrl_fecha_modificacion'],
                'vrl_usu_creacion' => $tbl_vrl[0]['vrl_usu_creacion'],
                'vrl_fecha_creacion' => $tbl_vrl[0]['vrl_fecha_creacion']
            );
            $registro = $this->gsatelite->ingresar('vrl_valores_lista', $vrl_array);
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Eliminar caracteristica", 'texto_alerta' => "No se puede eliminar porque esta asignado.");
        }else{
            if($result2 == 0){
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Eliminar caracteristica", 'texto_alerta' => "No se puede eliminar porque esta asignado.");
            }else{
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Eliminar caracteristica", 'texto_alerta' => "El registro se elimino correctamente.");
            }            
        }
        $this->session->set_flashdata($alerta);
        redirect('proyectos/mantenimientos/caracteristica');
    }
    
    public function new_crud() {
        $db_driver = $this->db->platform();
        $model_name = 'grocery_crud_model_' . $db_driver;
        $model_alias = 'm' . substr(md5(rand()), 0, rand(4, 15));

        unset($this->{$model_name});
        $this->load->library('grocery_CRUD');
        $crud = new Grocery_CRUD();
        if (file_exists(APPPATH . '/models/' . $model_name . '.php')) {
            $this->load->model('grocery_crud_generic_model');
            $this->load->model($model_name, $model_alias);
            $crud->basic_model = $this->{$model_alias};
        }
        return $crud;
    }    

     /**
     * @author Edith Herrera
     * @since 16/08/2017
     * @return acción de presupuesto para el producto.
     * Observación: esta función es similar a la que se encuentra en el módulo de cotizaciones.
     * @modify 16/06/2021 / Raul E. / Se agrega un Maestro - Detalle para tener varias recetas por producto
     */
    function presupuesto($art_id = null) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('art_articulo', $art_id);
        $articulo = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $art_id));
        $data['art_id'] = $art_id;
        $data['articulo'] = $articulo[0];
        $data['recetas'] = $this->gsatelite->get_tabla('rea_receta_articulo', array('rea_id_art' => $art_id));
        $data['recetas_activas'] = $this->gsatelite->get_tabla('rea_receta_articulo', array('rea_id_art' => $art_id, 'rea_estado' => 1));
        $data['titulo_personal'] = "Costeo Producto";
        cargarvista($data);        
    }

    public function presupuesto_producto($art_id = null, $rea_id = 0){
        satelite_validar();
        $max_cod_rea_art = $this->gsatelite->get_max('rea_receta_articulo', 'rea_correlativo', array('rea_id_art' => $art_id));
        if ($_POST) {
            $post_array = $this->input->post();
            $cantidadBase = ($post_array['cantidad_producir'] != "") ? floatval($post_array['cantidad_producir']) : 1;
            $codigo_receta = $post_array['codigo_receta'];
            $nombre_receta = $post_array['nombre_receta'];
            $art_id = $post_array['art_id'];
            $rea_id = $post_array['rea_id'];
            $hdnDetalleMateria = $post_array['hdnDetalleMateria'];
            $etapas = $post_array['hdnEtapas'];
            $materiaPrima = $post_array['materiaPrima'];
            $conversionesMateria = $post_array['conversionesMateria'];
            $proveedoresMateria = $post_array['proveedoresMateria'];
            $precioUnitarioFijo = $post_array['pre_fijo_uni'];
            $tipo_precio = $post_array['tipo_precio'];
            $cantidadesMateria = $post_array['cantidadesMateria'];
            $chkEstMateria = $post_array['chkEstMateria'];
            $hdnDetalleMob = $post_array['hdnDetalleMob'];
            $manoObra = $post_array['manoObra'];
            $responsanblesMob = $post_array['responsanblesMob'];
            $cantidadesMob = $post_array['cantidadesMob'];
            $chkestmob = $post_array['chkEstMob'];
            $hdnDetalleGst = $post_array['hdnDetalleGst'];
            $estimacionesGasto = $post_array['estimacionesGasto'];
            $cantidadesGasto = $post_array['cantidadesGasto'];
            $preciosGasto = $post_array['preciosGasto'];
            $receta_defecto = $post_array['receta_defecto'];
            $receta = array(
                'rea_id_art' => $art_id,
                'rea_codigo' => $codigo_receta,
                'rea_nombre' => $nombre_receta,
                'rea_cantidad_producir' => $cantidadBase,
                'rea_defecto' => $receta_defecto,
                'rea_estado' => 1,
                'rea_usu_modificacion' => $this->tank_auth->get_user_id(),
                'rea_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            if ($rea_id > 0) {
                $id_rea = $rea_id;
                $this->gsatelite->actualizar_array('rea_receta_articulo', $receta, array('rea_id' => $rea_id));
            } else {
                $receta['rea_fecha'] = date('Y-m-d H:i:s');
                $receta['rea_correlativo'] = intval($max_cod_rea_art) + 1;
                $receta['rea_usu_creacion'] = $this->tank_auth->get_user_id();
                $receta['rea_fecha_creacion'] = date('Y-m-d H:i:s');
                $id_rea = $this->gsatelite->ingresar('rea_receta_articulo', $receta);
            }
            if ($receta_defecto > 0) {
                $this->gsatelite->actualizar_array('rea_receta_articulo', array('rea_defecto' => 0), array('rea_id_art' => $art_id, 'rea_id <> ' => $id_rea));
            }
            $resultado = 0;
            /**************** MATERIA PRIMA ****************/
            $idsMateria = array();
            if (count($hdnDetalleMateria) > 0) {
                for ($i = 0; $i < count($hdnDetalleMateria); $i++) {
                    if ($hdnDetalleMateria[$i] > 0) {
                        $idsMateria[] = $hdnDetalleMateria[$i];
                    }
                }
            }
            //Se eliminan los detalles que no se procesaron.
            $dataMateria = $this->gsatelite->get_tabla('mpa_materia_prima_articulo', array('mpa_id_art' => $art_id, 'mpa_id_rea' => $id_rea));
            if (count($dataMateria) > 0) {
                foreach ($dataMateria as $row) {
                    if (!in_array($row['mpa_id'], $idsMateria)) {
                        $this->gsatelite->borrado_general('mpa_materia_prima_articulo', array('mpa_id' => $row['mpa_id']));
                    }
                }
            }
            if (count($hdnDetalleMateria) > 0) {
                for ($i = 0; $i < count($hdnDetalleMateria); $i++) {
                    $cantidadMateria = convertirFloat($cantidadesMateria[$i]);
                    $materia_array = array(
                        'mpa_id_art' => $art_id,
                        'mpa_id_rea' => $id_rea,
                        'mpa_id_art_materia' => $materiaPrima[$i],
                        'mpa_id_cva' => ($conversionesMateria[$i] != '') ? $conversionesMateria[$i] : null,
                        'mpa_id_prv' => ($proveedoresMateria[$i] != '') ? $proveedoresMateria[$i] : null,
                        'mpa_id_etp' => ($etapas[$i] != '') ? $etapas[$i] : null,                        
                        'mpa_cantidad' => ($cantidadMateria / $cantidadBase),
                        'mpa_cantidad_base' => $cantidadBase,
                        'mpa_tipo_precio' => $tipo_precio[$i],
                        'mpa_estimacion_porcentaje' => $chkEstMateria[$i],
                        'mpa_estado' => 1,
                        'mpa_usu_creacion' => $this->tank_auth->get_user_id(),
                        'mpa_fecha_creacion' => date('Y-m-d H:i:s'),
                        'mpa_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'mpa_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    if ($tipo_precio[$i] == 4 && $precioUnitarioFijo[$i] > 0) {
                        $materia_array['mpa_precio'] = ($precioUnitarioFijo[$i] / $cantidadBase);
                    }
                    if ($hdnDetalleMateria[$i] > 0) {
                        unset($materia_array['mpa_id_art']);
                        unset($materia_array['mpa_usu_creacion']);
                        unset($materia_array['mpa_fecha_creacion']);
                        $resultado += $this->gsatelite->actualizar_array('mpa_materia_prima_articulo', $materia_array, array('mpa_id' => $hdnDetalleMateria[$i]));
                    } else {
                        $resultado += $this->gsatelite->ingresar('mpa_materia_prima_articulo', $materia_array);
                    }
                }
            }
            /**************** MANO DE OBRA ****************/
            $idsMob = array();
            if (count($hdnDetalleMob) > 0) {
                for ($i = 0; $i < count($hdnDetalleMob); $i++) {
                    if ($hdnDetalleMob[$i] > 0) {
                        $idsMob[] = $hdnDetalleMob[$i];
                    }
                }
            }
            //Se eliminan los detalles que no se procesaron.
            $dataMob = $this->gsatelite->get_tabla('moa_mano_obra_articulo', array('moa_id_art' => $art_id, 'moa_id_rea' => $id_rea));
            if (count($dataMob) > 0) {
                foreach ($dataMob as $row) {
                    if (!in_array($row['moa_id'], $idsMob)) {
                        $this->gsatelite->borrado_general('moa_mano_obra_articulo', array('moa_id' => $row['moa_id']));
                    }
                }
            }
            if (count($hdnDetalleMob) > 0) {
                for ($i = 0; $i < count($hdnDetalleMob); $i++) {
                    $cantidadMob = convertirFloat($cantidadesMob[$i]);
                    $mano_obra_array = array(
                        'moa_id_art' => $art_id,
                        'moa_id_rea' => $id_rea,
                        'moa_id_mob' => $manoObra[$i],
                        'moa_id_emp' => ($responsanblesMob[$i]!='')?$responsanblesMob[$i]:null,
                        'moa_cantidad' => ($cantidadMob / $cantidadBase),
                        'moa_cantidad_base' => $cantidadBase,
                        'moa_estimacion_porcentaje' => $chkestmob[$i],
                        'moa_estado' => 1,
                        'moa_usu_creacion' => $this->tank_auth->get_user_id(),
                        'moa_fecha_creacion' => date('Y-m-d H:i:s'),
                        'moa_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'moa_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    if ($hdnDetalleMob[$i] > 0) {
                        unset($materia_array['moa_id_axo']);
                        unset($materia_array['moa_usu_creacion']);
                        unset($materia_array['moa_fecha_creacion']);
                        $resultado += $this->gsatelite->actualizar_array('moa_mano_obra_articulo', $mano_obra_array, array('moa_id' => $hdnDetalleMob[$i]));
                    } else {
                        $resultado += $this->gsatelite->ingresar('moa_mano_obra_articulo', $mano_obra_array);
                    }
                }
            }
            /**************** OTROS GASTOS ****************/
            $idsGastos = array();
            if (count($hdnDetalleGst) > 0) {
                for ($i = 0; $i < count($hdnDetalleGst); $i++) {
                    if ($hdnDetalleGst[$i] > 0) {
                        $idsGastos[] = $hdnDetalleGst[$i];
                    }
                }
            }
            //Se eliminan los detalles que no se procesaron.
            $dataGastos = $this->gsatelite->get_tabla('esr_estimacion_articulo', array('esr_id_art' => $art_id, 'esr_id_rea' => $id_rea));
            if (count($dataGastos) > 0) {
                foreach ($dataGastos as $row) {
                    if (!in_array($row['esr_id'], $idsGastos)) {
                        $this->gsatelite->borrado_general('esr_estimacion_articulo', array('esr_id' => $row['esr_id']));
                    }
                }
            }
            $tipo_gasto = $post_array['hdnTipoGastos'];
            if (count($hdnDetalleGst) > 0) {
                for ($i = 0; $i < count($hdnDetalleGst); $i++) {
                    $cantidadGasto = convertirFloat($cantidadesGasto[$i]);
                    $precioGasto = convertirFloat($preciosGasto[$i]);
                    $gastos_exr = array(
                        'esr_id_esm' => $estimacionesGasto[$i],
                        'esr_id_art' => $art_id,
                        'esr_id_rea' => $id_rea,
                        'esr_cantidad' => ($cantidadGasto / $cantidadBase),
                        'esr_tipo_costo' => $tipo_gasto[$i],
                        'esr_precio' => ($precioGasto / $cantidadBase),
                        'esr_cantidad_base' => $cantidadBase,
                        'esr_estado' => 1,
                        'esr_usu_creacion' => $this->tank_auth->get_user_id(),
                        'esr_fecha_creacion' => date('Y-m-d H:i:s'),
                        'esr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'esr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    if ($hdnDetalleGst[$i] > 0) {
                        unset($gastos_exr['esr_id_art']);
                        unset($gastos_exr['esr_usu_creacion']);
                        unset($gastos_exr['esr_fecha_creacion']);
                        $resultado += $this->gsatelite->actualizar_array('esr_estimacion_articulo', $gastos_exr, array('esr_id' => $hdnDetalleGst[$i]));
                    } else {
                        $resultado += $this->gsatelite->ingresar('esr_estimacion_articulo', $gastos_exr);
                    }
                }
            }
            if ($resultado > 0) {
                //Se actualizan los totales en el artículo.
                $txtTotalMateriaPrima = ($post_array['txtTotalMateria'] > 0) ? convertirFloat($post_array['txtTotalMateria']) : null;
                $txtTotalManoObra = ($post_array['txtTotalManoObra'] > 0) ? convertirFloat($post_array['txtTotalManoObra']) : null;
                $txtTotalGastos = ($post_array['txtTotalGastos'] > 0) ? convertirFloat($post_array['txtTotalGastos']) : null;
                $totalCosto = ($post_array['txtTotalCostos'] > 0) ? convertirFloat($post_array['txtTotalCostos']) : null;
                $txtObservacion = ($post_array['txtObservacion'] != '') ? $post_array['txtObservacion'] : null;
                $articulo_array = array(//ACTUALIZA EL ARTICULO CON LA ULTIMA RECETA
                    'art_total_materia_prima' => $txtTotalMateriaPrima,
                    'art_total_mano_obra' => $txtTotalManoObra,
                    'art_total_gastos' => $txtTotalGastos,
                    'art_total_presupuesto' => $totalCosto,
                    'art_observacion_presupuesto' => $txtObservacion,
                    'art_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'art_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('art_articulo', $articulo_array, array('art_id' => $art_id));
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Costeo", 'texto_alerta' => "Información procesada correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Costeo", 'texto_alerta' => "No se procesó ningun registro, favor verificar información.");
            }
            $this->session->set_flashdata($alerta);
            $tipoBtn = $post_array['btnCrear'];
            if ($tipoBtn > 1) {
                redirect('proyectos/mantenimientos/presupuesto/' . $art_id);
            } else {
                redirect("proyectos/mantenimientos/presupuesto_producto/" . $art_id . "/" . $id_rea);
            }
        } else {
            $articulo = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $art_id));
            $data['receta'] = $this->gsatelite->get_tabla('rea_receta_articulo', array('rea_id_art' => $art_id, 'rea_id' => $rea_id));
            //Validar si tiene etapas
            $result_etapas = $this->proyecto_model->verificar_tiene_etapas(array('art_id'=>$art_id));
            $decimales_json = $this->gsatelite->get_parametro('SYS_NUMERO_DECIMALES_PRODUCCION');
            $map = $this->gsatelite->get_dropdown('art_articulo', '{art_codigo} - {art_nombre}', '', array('art_materia_prima' => 1, 'art_estado' => 1), null, null, 'art_id', true);
            $prv = $this->gsatelite->get_dropdown('prv_proveedor', "[IF(prv_tipo_pers = 1, CONCAT(prv_codigo, ' - ', prv_nombre, ' ', prv_apellido), CONCAT(prv_codigo, ' - ', prv_apellido))]", '',array('prv_estado' => 1), null, null, 'prv_id', true);
            if ($decimales_json != "") {
                $decimales_array = json_decode($decimales_json, true);
                $data['decimales'] = ($decimales_array["presupuesto"] != NULL && $decimales_array["presupuesto"] != "") ? $decimales_array["presupuesto"] : 2;
            } else {
                $data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            }
                                       $this->db->join('cva_conversion_articulo', 'cva_id_mep = mep_id');
            $data['articulo_medida'] = $this->gsatelite->get_tabla('mep_medida_producto', array('mep_estado' => 1, 'cva_estado' => 1, 'cva_defecto' => 1, 'cva_id_art' => $art_id));
            $data['decimales_monetarios'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);            
            $data['emp_default'] = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre}'.' '.'{emp_apellido}','',array('emp_estado'=>1), null, '', 'emp_id', true);
            $data['etapas'] = (count($result_etapas) > 0) ? $result_etapas : $this->gsatelite->get_tabla('etp_etapa', array('etp_estado' => 1));
            $data['art_id'] = $art_id;
            $data['rea_id'] = $rea_id;
            $data['articulo'] = $articulo[0];
            $data['cod_sug'] = generar_codigo_cor((intval($max_cod_rea_art) + 1), 3);
            $data['lista'] = $this->gsatelite->get_tabla('art_articulo');
            $data['obra'] = $this->gsatelite->get_tabla('mob_mano_obra', array('mob_estado' => 1));
            $data['resp'] = $this->gsatelite->get_tabla('emp_empleado');
            $data['est'] = $this->gsatelite->get_tabla('esm_estimacion');
            // Se carga el presupuesto agregado al producto, si existe.
            $data['materia_prima_prod'] = $this->cotizaciones_model->get_materia_prima_presupuesto(array('mpa_id_art' => $art_id, 'mpa_id_rea' => $rea_id));
            $data['mano_obra_prod'] = $this->cotizaciones_model->get_mano_obra_presupuesto(array('moa_id_art' => $art_id, 'moa_id_rea' => $rea_id));
            $data['gastos_indirectos'] = $this->cotizaciones_model->get_gastos_indirectos_presupuesto(array('esr_id_art' => $art_id, 'esr_id_rea' => $rea_id)); 
            $data['mano_obra'] = $this->gsatelite->get_tabla('mob_mano_obra', array('mob_estado' => 1));
            $data['estimaciones'] = $this->gsatelite->get_tabla('esm_estimacion', array('esm_estado' => 1));
            $data['proveedores'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $prv);
            $data['materia_prima'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $map);
        }
        $data['titulo_personal'] = "Costeo Producto";
        cargarvista($data);
    }

    public function verificar_codigo_receta($tipo){
        $valor = $this->input->post('codigo');
        $receta = $this->input->post('receta');
        $product = $this->input->post('article');
        $where['rea_id_art'] = $product;
        if ($tipo > 1) {
            $where['TRIM(rea_nombre)'] = trim($valor);
        } else {
            $where['TRIM(rea_codigo)'] = trim($valor);
        }
        if ($receta > 0) {
            $where['rea_id != '] = $receta;
        }
        $registros = $this->gsatelite->get_tabla('rea_receta_articulo', $where);
        echo count($registros);
    }

    public function active_inactivate_recipe($art_id,$rea_id,$estado){
        $actualizar = array('rea_estado' => $estado, 'rea_usu_modificacion' => $this->tank_auth->get_user_id(), 'rea_fecha_modificacion' => date('Y-m-d H:i:s'));
        if ($estado > 0) {
            $actualizar['rea_fecha'] = date('Y-m-d H:i:s');
        }
        $exito = $this->gsatelite->actualizar_array('rea_receta_articulo', $actualizar, array('rea_id' => $rea_id, 'rea_id_art' => $art_id));
        if ($exito > 0) {
            $this->gsatelite->show_dialog("El Estado del Costeo se procesó correctamente.", "proyectos/mantenimientos/presupuesto/$art_id", "success", "Éxito");
        } else {
            $this->gsatelite->show_dialog("No se pudo procesar el Nuevo Estado",  "proyectos/mantenimientos/presupuesto/$art_id", "error", "Ocurrió un error");
        }        
    }

    /**
     * @author Elman Ortiz
     * @date 22/08/2017
     */
    function caracteristicas_editar($car_id = null){        
        satelite_validar();
        if($_POST){//Guardar datos

            $car_id = $this->input->post('car_id');            
            //Crear arreglo caracteristicas            
            $caracteristica_array = array(
                'car_codigo' => ($this->input->post('car_codigo')) ? $this->input->post('car_codigo') : null,
                'car_nombre' => $this->input->post('inpNombre'),
                'car_descripcion' => $this->input->post('inpDescripcion'),
                'car_tipo' => $this->input->post('slcTipo'),
                'car_estado' => $this->input->post('slcEstado'),
                'car_usu_crea' => $this->tank_auth->get_user_id(),
                'car_fecha_crea' => date('Y-m-d H:i:s'),
                'car_usu_mod' => $this->tank_auth->get_user_id(),
                'car_fecha_mod' => date('Y-m-d H:i:s')
            );

            $this->gsatelite->actualizar_array('car_caracteristica', $caracteristica_array, array('car_id'=>$car_id));            
            $res = $this->gsatelite->borrado_general('vrl_valores_lista', array('vrl_id_car' => $car_id));                            
            $valor = $this->input->post('valores');
            $precio = $this->input->post('preciosCaUpdate');
            $lista = array_combine($valor, $precio);
            //print_r(count($lista)); die();
            if ($lista) {
                //$elem = " ";                                
                foreach ($lista as $key => $value) {                    
                    //vrl_valores_lista
                    $valores_lista_array = array(                
                        'vrl_id_car' => $car_id,
                        'vrl_valor' => $key,
                        'vrl_precio_valor' => ($value != '')?$value:null,
                        'vrl_estado' => 1,
                        'vrl_usu_creacion' => $this->tank_auth->get_user_id(),
                        'vrl_fecha_creacion' => date('Y-m-d H:i:s'),
                        'vrl_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'vrl_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $result = $this->gsatelite->ingresar('vrl_valores_lista', $valores_lista_array);
                }                
            }
            
            if ($car_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "El registro se guardó correctamente.");
            }else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            $this->session->set_flashdata($alerta);
            
            if ($this->input->post('tipoboton') == 'save') {
                redirect('proyectos/mantenimientos/caracteristicas_editar/'.$car_id);
            } else {
                redirect('proyectos/mantenimientos/caracteristica/');
            }
        }else{//Cargar datos
            satelite_validar();
            $this->db->join('vrl_valores_lista','car_id =vrl_id_car','left');
            $carac = $this->gsatelite->get_tabla('car_caracteristica', array('car_id'=>$car_id));                                                        
            $data['caracteristica'] = $carac;
            $data['car_id'] = $car_id;
            $data['car_codigo'] = $carac[0]['car_codigo'];
            $data['titulo_personal'] = "Editar características";                    
            $this->_cargarvista($data);
        }            
    }//caracteristicas editar

    function _cargarvista($data=0,$crud=0)
    {   
        $this->load->view('vacia',$crud);   
        if($data!=0)
            $data=array_merge($data,$this->masterpage->getUsuario());
        else
            $data=$this->masterpage->getUsuario();
        $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content',$data);
        $this->masterpage->show();
    }

    /**
     * @author Habby Lovo
     * @since  12/10/2017
     * @return Verifica si hay registros en los presupuestos del producto
     */
    function verificar_presupuesto(){
        $art_id = $this->input->post('producto');
        $respuesta = $this->cotizaciones_model->get_verificar_presupuesto(array('art_id'=>$art_id));
        $producto = $respuesta[0]['art_nombre'];
        if(trim($respuesta[0]['art_codigo']) != null){
            $producto = $respuesta[0]['art_codigo'].' - '.$respuesta[0]['art_nombre'];
        }
        
        echo json_encode(array('producto'=>$respuesta[0]['suma'], 'nombre_producto'=>$producto));
    }

    /**
     * @author Francisco Orozco
     * @since  25/10/2017
     * @return Verifica si hay registros en etapas analiticas
     */
    function verificar_etapas_analiticas(){
        $art_id     = $this->input->post('producto');
        $this->db->join("cra_cursograma_analitico","cra_id_art = art_id","left");
        $respuesta  = $this->gsatelite->get_tabla("art_articulo", array("art_id" => $art_id) );
        $producto   = $respuesta[0]['art_nombre'];
        $analisis   = ($respuesta[0]['cra_id'] != "")?$respuesta[0]['cra_id']:0;
        if(trim($respuesta[0]['art_codigo']) != null){
            $producto = $respuesta[0]['art_codigo'].' - '.$respuesta[0]['art_nombre'];
        }
        echo json_encode( array('analisis' => $analisis, 'nombre_producto' => $producto) );
    }

    public function get_productos_like() {
        satelite_validar(true);
        $producto = $this->input->post('producto');

        $where = null;
        $like = null;
        if ($producto != '') {
            $like['art_nombre'] = $producto;
        }
        $arreglo = array();
        $productos = $this->cotizaciones_model->get_verificar_presupuesto($where, $producto);

        if (count($productos) > 0) {
            foreach ($productos as $key => $value) {
                if($value['suma'] != 0){
                    $arreglo[$key]['producto'] = $value['art_id'];
                    $arreglo[$key]['prod_nombre'] = $value['art_codigo'].' - '.$value['art_nombre'];
                }
            }
        }
        echo json_encode($arreglo);
    }
    public function get_productos_like_analisis() {
        satelite_validar(true);
        $producto = $this->input->post('producto');

        $where = null;
        $like = null;
        if ($producto != '') {
            $like['art_nombre'] = $producto;
        }
        $where["cra_id_art IS NOT NULL"] = null;
        $productos = $this->cotizaciones_model->get_productos_like($where, $producto);
        $arreglo = array();
        if (count($productos) > 0) {
            foreach ($productos as $key => $value) {
                $arreglo[$key]['producto']  = $value['art_id'];
                $arreglo[$key]['nombre']    = $value['art_codigo'].' - '.$value['art_nombre'];
            }
        }
        echo json_encode($arreglo);
    }

    /**
     * @author Habby Lovo
     * @since  12/10/2017
     * @return Duplica el presupuesto
     */
    function duplicar_presupuesto(){
        $producto_destino = $this->input->post('producto_des');
        $producto_origen = $this->input->post('producto_org');
        $url = $this->input->post('url');
        $receta = $this->gsatelite->get_campo('rea_receta_articulo', 'rea_id', array('rea_estado'=> 1, 'rea_defecto' => 1, 'rea_id_art'=> $producto_origen));
        $materia_prima_reg = $this->gsatelite->get_tabla('mpa_materia_prima_articulo',array('mpa_id_rea' => $receta, 'mpa_id_art'=>$producto_origen));
        $estimacion_articulo_reg = $this->gsatelite->get_tabla('esr_estimacion_articulo',array('esr_id_rea' => $receta, 'esr_id_art'=>$producto_origen));
        $mano_obra_articulo_reg = $this->gsatelite->get_tabla('moa_mano_obra_articulo',array('moa_id_rea' => $receta, 'moa_id_art'=>$producto_origen));
        $codigo_art = $this->gsatelite->get_campo('art_articulo', 'art_codigo', array('art_id' => $producto_destino));
        $new_receta = array(
            'rea_id_art' => $producto_destino,
            'rea_codigo' => $codigo_art . '-001',
            'rea_correlativo' => 1,
            'rea_nombre' => 'Receta por defecto',
            'rea_cantidad_producir' => 1,
            'rea_fecha' => date('Y-m-d H:i:s'),
            'rea_defecto' => 1,
            'rea_estado' => 1,
            'rea_usu_creacion' => $this->tank_auth->get_user_id(),
            'rea_fecha_creacion' => date('Y-m-d H:i:s'),
            'rea_usu_modificacion' => $this->tank_auth->get_user_id(),
            'rea_fecha_modificacion' => date('Y-m-d H:i:s')
        );
        $nueva_rea = $this->gsatelite->ingresar('rea_receta_articulo', $new_receta);
        $materia_prima = array();
        foreach ($materia_prima_reg as $key) {
            $materia_prima[] = array(
                    'mpa_id_art' => $producto_destino,
                    'mpa_id_art_materia' => $key['mpa_id_art_materia'],
                    'mpa_id_cva' => $key['mpa_id_cva'],
                    'mpa_id_prv' => $key['mpa_id_prv'],
                    'mpa_id_etp' => $key['mpa_id_etp'],
                    'mpa_id_rea' => $nueva_rea,
                    'mpa_cantidad' => $key['mpa_cantidad'],
                    'mpa_precio' => $key['mpa_precio'],
                    'mpa_estado' => 1,
                    'mpa_usu_creacion' => $this->tank_auth->get_user_id(),
                    'mpa_fecha_creacion' => date('Y-m-d H:i:s'),
                    'mpa_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'mpa_fecha_modificacion' => date('Y-m-d H:i:s')
                );
        }

        $estimacion_articulo = array();
        foreach ($estimacion_articulo_reg as $key) {
            $estimacion_articulo[] = array(
                    'esr_id_esm' => $key['esr_id_esm'],
                    'esr_id_art' => $producto_destino,
                    'esr_id_rea' => $nueva_rea,
                    'esr_cantidad' => $key['esr_cantidad'],
                    'esr_precio' => $key['esr_precio'],
                    'esr_estado' => 1,
                    'esr_usu_creacion' => $this->tank_auth->get_user_id(),
                    'esr_fecha_creacion' => date('Y-m-d H:i:s'),
                    'esr_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'esr_fecha_modificacion' => date('Y-m-d H:i:s')
                );
        }

        $mano_obra_articulo = array();
        foreach ($mano_obra_articulo_reg as $key) {
            $mano_obra_articulo[] = array(
                    'moa_id_art' => $producto_destino,
                    'moa_id_mob' => $key['moa_id_mob'],
                    'moa_id_emp' => $key['moa_id_emp'],
                    'moa_cantidad' => $key['moa_cantidad'],
                    'moa_precio' => $key['moa_precio'],
                    'moa_id_rea' => $nueva_rea,
                    'moa_estado' => 1,
                    'moa_usu_creacion' => $this->tank_auth->get_user_id(),
                    'moa_fecha_creacion' => date('Y-m-d H:i:s'),
                    'moa_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'moa_fecha_modificacion' => date('Y-m-d H:i:s')
                );
        }

        $estado = false;
        if(count($materia_prima_reg) > 0){
            $this->gsatelite->ingresar('mpa_materia_prima_articulo', $materia_prima, true);
            $estado = true;
        }
        if(count($estimacion_articulo_reg) > 0){
            $this->gsatelite->ingresar('esr_estimacion_articulo', $estimacion_articulo, true);
            $estado = true;
        }
        if(count($mano_obra_articulo_reg) > 0){
            $this->gsatelite->ingresar('moa_mano_obra_articulo', $mano_obra_articulo, true);
            $estado = true;
        }
        
        echo json_encode(array('estado'=>$estado));
        

/*
        $respuesta = $this->cotizaciones_model->get_verificar_presupuesto(array('art_id'=>$art_id));
        $producto = $respuesta[0]['art_codigo'].' - '.$respuesta[0]['art_nombre'];
        echo json_encode(array('producto'=>$respuesta[0]['suma'], 'nombre_producto'=>$producto));*/
    }

    /**
     * Descripción:
     * Función para retornar los sectores de una bodega
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-11-13
     * @param $bodega = El ID de la bodega que se desea obtener los sectores
     * @return Los Sectores por bodega.
     */

    function select_sector_por_bodega($bodega=null){
        satelite_validar(); 
        $id_sect = $this->input->post('id_sector');
        if (is_numeric($bodega) && $bodega!=null) {
            $html = '<option value=""></option>';
            $consulta = $this->proyecto_model->get_sector_por_bodega(array('sxb_id_bod'=>$bodega, 'sxb_estado'=>1));

            foreach ($consulta as $key => $value) {
                $selected = ($value['sxb_id'] == $id_sect)? ' selected ':'';
                $html .= '<option '. $selected.' value="'.$value['sxb_id'].'">'.$value['seb_nombre'].'</option>';
            }
            echo $html;
        }
    }

    /**
     * @author Francisco Orozco 
     * @since  23/10/2018
     * @return reporte de etapas analiticas.
     */
    public function etapas_analiticas() {
        satelite_validar();
        $permisos   = $this->gsatelite->get_permisos_opcion();
        $crud       = new grocery_CRUD;

        $colums = array(
            'eca_nombre',
            'eca_tiempo',
            'eca_distancia',
            'eca_proceso',
            'eca_estado',
        );

        $alias = array(
            'eca_nombre'        => 'Nombre',
            'eca_tiempo'        => 'Valor tiempo',
            'eca_distancia'     => 'Valor distancia',
            'eca_descripcion'   => 'Descripcion',
            'eca_proceso'       => 'Proceso',
            'eca_estado'        => 'Estado'
        );

        $add = array(
            'eca_nombre',
            'eca_tiempo',
            'eca_distancia',
            'eca_descripcion',
            'eca_proceso',
            'eca_estado',
            'eca_usu_creacion',
            'eca_fecha_creacion',
            'eca_usu_modificacion',
            'eca_fecha_modificacion'
        );

        $edit = array(
            'eca_nombre',
            'eca_tiempo',
            'eca_distancia',
            'eca_descripcion',
            'eca_proceso',
            'eca_estado',
            'eca_usu_modificacion',
            'eca_fecha_modificacion'
        );

        $required = array(
            'eca_nombre',
            'eca_proceso',
            'eca_estado',
            'eca_usu_creacion',
            'eca_fecha_creacion',
            'eca_usu_modificacion',
            'eca_fecha_modificacion'
        );

        
        $crud->set_table('eca_etapa_cursograma_analitico')
                ->set_subject('Etapas analíticas')
                ->display_as($alias)
                ->columns($colums)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($required)
                ->field_type('eca_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('eca_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                ->field_type('eca_proceso', 'dropdown', array('1' => 'Operación', '2' => 'Inspección','3' => 'Demora','4' => 'Transporte','5' => 'Almacenamiento') )
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('eca_estado', 'hidden', 1)
                    ->field_type('eca_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('eca_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('eca_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
         //   $crud->add_action('Ver', 'minia-icon-search', 'proyectos/mantenimientos/etapas_analiticas/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Etapas analíticas";
        $this->_cargarvista($data, $output);

    }
    
    public function etapas_cursograma_analitico($articulo = "", $articulo_duplicar = "") {
        satelite_validar();
        if ($_POST) {
            $codigo             = $this->input->post('txt_codigo');
            $fecha              = $this->input->post('txt_fecha');
            $lugar              = $this->input->post('txt_lugar');
            $actividad          = $this->input->post('txt_actividad');
            $responsable        = $this->input->post('slc_responsable');
            $etapa_array        = $this->input->post('tbl_etapa');
            $orden_array        = $this->input->post('tbl_orden');
            $cantidad_array     = $this->input->post('tbl_cantidad');
            $tiempo_array       = $this->input->post('tbl_tiempo');
            $distancia_array    = $this->input->post('tbl_distancia');
            $observacion_array  = $this->input->post('tbl_observacion');
           
            $analisis_previo    = $this->gsatelite->get_tabla("cra_cursograma_analitico",array("cra_id_art" => $articulo));            
          
            if ( count($analisis_previo) > 0 ) {
                //edicion
                $cra_id             = $this->input->post('txt_cursograma'); 
                $etapa_xcurso_array = $this->input->post('tbl_etapaxcursograma'); 
                
                $cra_cursograma_analitico = array(
                    'cra_id_art'            => $articulo,
                    'cra_codigo'            => $codigo,
                    'cra_actividad'         => $actividad,
                    'cra_lugar'             => $lugar,
                    'cra_fecha'             => date('Y-m-d', strtotime($fecha) ),
                    'cra_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'cra_fecha_modificacion'=> date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('cra_cursograma_analitico', $cra_cursograma_analitico, array('cra_id' => $cra_id));
            
                $rca_responsable_cursograma_analitico = array(
                    'rca_id_emp'            => $responsable,
                    'rca_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'rca_fecha_modificacion'=> date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('rca_responsable_cursograma_analitico', $rca_responsable_cursograma_analitico, array("rca_id_cra" => $cra_id));
               
                //Se eliminan los detalles que no se procesaron.
                $detalles = $this->gsatelite->get_tabla('exg_etapasxcursograma_analitico', array('exg_id_cra' => $cra_id));

                if (count($etapa_xcurso_array) > 0) {
                    foreach ($detalles as $row) {
                        if (!in_array($row['exg_id'], $etapa_xcurso_array)) {
                            $this->gsatelite->borrado_general('exg_etapasxcursograma_analitico', array('exg_id' => $row['exg_id']));
                        }
                    }
                }

                foreach ($etapa_xcurso_array  as $key => $etapa) {
                    $exg_etapasxcursograma_analitico = array(
                        'exg_id_eca'            => $etapa_array[$key],
                        'exg_id_cra'            => $cra_id,
                        'exg_orden'             => $orden_array[$key],
                        'exg_cantidad'          => $cantidad_array[$key],
                        'exg_tiempo'            => $tiempo_array[$key],
                        'exg_distancia'         => $distancia_array[$key],
                        'exg_observacion'       => $observacion_array[$key],
                        'exg_estado'            => 1,
                        'exg_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'exg_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'exg_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'exg_fecha_modificacion'=> date('Y-m-d H:i:s')
    
                    );
                    if ($etapa != "" ) {
                        unset($exg_etapasxcursograma_analitico['exg_id_cra']);
                        unset($exg_etapasxcursograma_analitico['exg_usu_creacion']);
                        unset($exg_etapasxcursograma_analitico['exg_usu_modificacion']);
                        $this->gsatelite->actualizar_array('exg_etapasxcursograma_analitico', $exg_etapasxcursograma_analitico, array('exg_id' => $etapa));
                    } else {
                        $this->gsatelite->ingresar('exg_etapasxcursograma_analitico', $exg_etapasxcursograma_analitico);
                    }
                }
                
            } else {
                //agregar nuevo
                $cra_cursograma_analitico = array(
                    'cra_id_art'            => $articulo,
                    'cra_codigo'            => $codigo,
                    'cra_actividad'         => $actividad,
                    'cra_lugar'             => $lugar,
                    'cra_fecha'             => date('Y-m-d', strtotime($fecha) ),
                    'cra_estado'            => 1,
                    'cra_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'cra_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'cra_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'cra_fecha_modificacion'=> date('Y-m-d H:i:s')
                );
                $cra_id = $this->gsatelite->ingresar('cra_cursograma_analitico', $cra_cursograma_analitico);
  
                $rca_responsable_cursograma_analitico = array(
                    'rca_id_cra'            => $cra_id,
                    'rca_id_emp'            => $responsable,
                    'rca_estado'            => 1,
                    'rca_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'rca_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'rca_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'rca_fecha_modificacion'=> date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('rca_responsable_cursograma_analitico', $rca_responsable_cursograma_analitico);
    
                foreach ($etapa_array  as $key => $etapa) {
                    $exg_etapasxcursograma_analitico = array(
                        'exg_id_eca'            => $etapa,
                        'exg_id_cra'            => $cra_id,
                        'exg_orden'             => $orden_array[$key],
                        'exg_cantidad'          => $cantidad_array[$key],
                        'exg_tiempo'            => $tiempo_array[$key],
                        'exg_distancia'         => $distancia_array[$key],
                        'exg_observacion'       => $observacion_array[$key],
                        'exg_estado'            => 1,
                        'exg_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'exg_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'exg_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'exg_fecha_modificacion'=> date('Y-m-d H:i:s')
    
                    );
                    $this->gsatelite->ingresar('exg_etapasxcursograma_analitico', $exg_etapasxcursograma_analitico);
                }
            }
            $btnCrear = $this->input->post('btnCrear');
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Etapas de cursograma analítico", 'texto_alerta' => "Se agregaron las etapas correctamente.");
            $this->session->set_flashdata($alerta);
            if ($btnCrear == 1) {
                redirect('proyectos/mantenimientos/etapas_cursograma_analitico/'.$articulo);
            } else {
                redirect('proyectos/mantenimientos/articulo');
            }
        } else {
            if ($articulo > 0 ) {
                $articulo_evaluar       = ($articulo_duplicar != "")?$articulo_duplicar:$articulo;
                $where["cra_id_art"]    = $articulo_evaluar;
                $data['analisis']       = $this->proyecto_model->etapas_cursograma_analitico($where);

                $responsable            = (count($data['analisis']) > 0)?$data['analisis'][0]['rca_id_emp']:null;
                $empleados              = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre}', '', array('emp_estado' => '1'), $responsable, '', 'emp_id', true);
                $data["empleados"]      = $empleados; 
                $data['articulo']       = $this->gsatelite->get_tabla("art_articulo",array("art_id" => $articulo) );
                $etapas_array           = $this->gsatelite->get_tabla('eca_etapa_cursograma_analitico', array('eca_estado' => '1'));
                $etapas                 = '<option value=""></option>';
                foreach ($etapas_array as $etapa) {
                    $etapas.= '<option data-distancia="'.$etapa["eca_distancia"].'" data-tiempo="'.$etapa["eca_tiempo"].'" data-proceso="'.$etapa["eca_proceso"].'" value="'.$etapa["eca_id"].'">'.$etapa["eca_nombre"].'</option>';
                }
                $data["etapas"]         = $etapas;      
                $data['decimales']      = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;                    
                $data['titulo_personal']= "Listas de etapas de cursograma analítico";

                $this->_cargarvista($data);
            } else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Artículo", 'texto_alerta' => "Artículo no fue encontrado.");
                $this->session->set_flashdata($alerta);
                redirect('/proyectos/mantenimientos/articulo');
            }   
        }
    }    

    function operarios(){
        if (!($this->tank_auth->is_logged_in())) {
            redirect('/auth/login/');
        } else {
            $emp_opr = array();
            $opr_ya = array(0);
            $url_array = explode('/', uri_string());
            $crud = new grocery_CRUD();
            $crud->set_table('opr_operario');
            $crud->set_subject('Operario');
            $crud->fields('opr_id_emp', 'opr_descripcion', 'opr_estado', 'opr_usu_creacion', 'opr_fecha_creacion', 'opr_usu_modificacion', 'opr_fecha_modificacion');
            $crud->columns('opr_id_emp', 'opr_descripcion', 'opr_estado');
            $crud->required_fields('opr_id_emp', 'opr_estado');
            $crud->display_as('opr_id_emp', 'Operario');
            $crud->display_as('opr_descripcion', 'Comentarios');
            $crud->display_as('opr_estado', 'Estado');
            $crud->field_type('opr_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('opr_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('opr_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('opr_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('opr_estado', 'hidden', 1);
                $emp_opr = $this->gsatelite->get_tabla("opr_operario", array("opr_estado" => 1));
            } else {  // Editar
                $crud->field_type('opr_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                if (is_numeric(end($url_array)) && end($url_array) > 0 ) {
                    $este_emp = $this->gsatelite->get_campo('opr_operario', 'opr_id_emp', array('opr_id' => end($url_array)));
                    $emp_opr = $this->gsatelite->get_tabla("opr_operario", array("opr_estado" => 1, "opr_id_emp != " => $este_emp));
                }                
            }
            foreach ($emp_opr as $key => $val) {
                $opr_ya[] = $val['opr_id_emp'];
            }
            $filtro = implode(',', array_unique($opr_ya));
            $crud->set_relation('opr_id_emp', 'emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', array("emp_estado" => 1, "emp_id NOT IN ($filtro)" => null));
            $crud->unset_delete();
            $crud->unset_read();
            $data['titulo_personal'] = "Operarios";
            $output = $crud->render();
            $this->_cargarvista($data, $output);
        }
        
            
    }

    function maquinaria(){
        if (!($this->tank_auth->is_logged_in())) {
            redirect('/auth/login/');
        } else {
            $crud = new grocery_CRUD();
            $crud->set_table('maq_maquina');
            $crud->set_subject('Maquinaria');
            $crud->fields('maq_nombre', 'maq_hora', 'maq_descripcion', 'maq_estado', 'maq_usu_creacion', 'maq_fecha_creacion', 'maq_usu_modificacion', 'maq_fecha_modificacion');
            $crud->required_fields('maq_nombre', 'maq_hora');
            $crud->display_as('maq_nombre', 'Nombre Máquina');
            $crud->display_as('maq_hora', 'Horas por día');
            $crud->display_as('maq_estado', 'Estado');
            $crud->display_as('maq_descripcion', 'Comentarios');
            $crud->columns('maq_nombre', 'maq_hora', 'maq_descripcion', 'maq_estado');
            $crud->field_type('maq_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('maq_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('maq_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('maq_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->callback_field('maq_hora', function ($value = '', $primary_key = null) {
                return '<input id="field-maq_hora" name="maq_hora" type="text" class="soloDecimales" maxlength="19,2" value="' . $value . '">';
            });
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('maq_estado', 'hidden', 1);
            } else {  // Editar
                $crud->field_type('maq_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }             
            $crud->unset_delete();
            $crud->unset_read();
            $data['titulo_personal'] = "Maquinarias";
            $output = $crud->render();
            $this->_cargarvista($data, $output);
        }
    }

    public function monto_detalle_mano_obra() {
        $mano_obra = $this->input->post('mano_obra');
        $suma = $this->gsatelite->get_suma('dec_detalle_calculo', 'dec_monto', array('dec_id_mob' => $mano_obra, 'dec_estado' => 1));
        $decimales = $this->gsatelite->get_parametro("NUMERO_DECIMALES");
        $arreglo = array('monto_total' => number_format($suma, $decimales,'.',''));
        //$arreglo=array('drop'=>0); //quitar la validación para ylufa
        echo json_encode($arreglo);
    }

     /**
    * @author Mario Marquez
    * @since  18/12/2019
    * @return Mantenimiento tabla dec_detalle_calculo
    * Módulos padre: Sistema.
    */
    public function detalle_calculo_mano_obra($mob_id) {
        satelite_validar();
        $this->load->library('../controllers/sistema/mantenimientos_compartidos');
        $permisos = $this->gsatelite->get_permisos_opcion('proyectos/mantenimientos/mano_obra');
        $this->mantenimientos_compartidos->detalle_calculo_mano_obra($mob_id);
    }

     /**
    * @author Mario Marquez
    * @since  18/12/2019
    * @return Mantenimiento tabla dxe_detallexestimacion
    * Módulos padre: Sistema.
    */
    public function detalle_calculo_estimacion($esm_id) {
        satelite_validar();
        $this->load->library('../controllers/sistema/mantenimientos_compartidos');
        $permisos = $this->gsatelite->get_permisos_opcion('proyectos/mantenimientos/estimacion');
        $this->mantenimientos_compartidos->detalle_calculo_estimacion($esm_id);
    }

    public function monto_detalle_estimacion() {
        $esm_id = $this->input->post('estimacion');
        $suma = $this->gsatelite->get_suma('dxe_detallexestimacion', 'dxe_monto', array('dxe_id_esm' => $esm_id, 'dxe_estado' => 1));
        $decimales = $this->gsatelite->get_parametro("NUMERO_DECIMALES");
        $arreglo = array('monto_total' => number_format($suma, $decimales,'.',''));
        //$arreglo=array('drop'=>0); //quitar la validación para ylufa
        echo json_encode($arreglo);
    }

    public function get_suma_horas_mob_gif(){
        $horas_mob = $horas_gif = 0;
        if ($_POST) {
            $art_id = $this->input->post('art');
            $cva_id = $this->input->post('cva');
            $mob_id = $this->input->post('mob');
            $gif_id = $this->input->post('gif');
            if ($mob_id > 0) {
                $suma = $this->gsatelite->get_suma('eta_etapa_articulo', 'eta_duracion_mod', array('eta_id_cva' => $cva_id, 'eta_id_art' => $art_id, 'eta_estado' => 1));
                if ($suma > 0) {
                    $horas_mob = $suma;
                }
            }
            if ($gif_id > 0) {
                $suma = $this->gsatelite->get_suma('eta_etapa_articulo', 'eta_duracion', array('eta_id_cva' => $cva_id, 'eta_id_art' => $art_id, 'eta_estado' => 1));
                if ($suma > 0) {
                    $horas_gif = $suma;
                }
            }
        }
        $arreglo = array('ctdad_mob' => $horas_mob, 'ctdad_gif' => $horas_gif);
        echo json_encode($arreglo);
    }

    public function duplicar_articulo($id_art){
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $permisos = $this->gsatelite->get_permisos_opcion('proyectos/mantenimientos/articulo');
        $this->mantenimiento->duplicar_articulo($id_art, "proyectos/mantenimientos");
    }

    function mover_img_gral($ruta, $destino, $archivo) {
        if (is_dir($ruta)) {
            if (copy($ruta . '/' . $archivo, $destino . '/' . $archivo)) {
                return unlink($ruta . '/' . $archivo);
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function clientes_x_segmento($idcac = null, $ajax = null) {        
        if($idcac == null){
            $idcac = $this->input->post('idcac');        
        }

        //clientes
        if($idcac != ''){
            $clientes = $this->gsatelite->get_tabla('cli_cliente', array('cli_id_cac' => $idcac,'cli_estado' => 1));
        }else{
            $clientes = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
        }

        $client = '<option></option>';
        foreach ($clientes as $cli) {
            if ($cli['cli_codigo'] != '') {
                $codigo = trim($cli['cli_codigo']) . ' - ';
            } else {
                $codigo = '';
            }                    
            $nombre_cliente = ($cli['cli_personeria'] == 1) ? $codigo . $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $codigo . $cli['cli_apellido'];
            $client .= '<option value="' . $cli['cli_id'] . '">' . $nombre_cliente . '</option>';
        }

        if($ajax){
            return $client;
        }else{
            echo $client;    
        }         
    }
    
}
