<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Reportes extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->library('grocery_CRUD');
		$this->load->library('Procesos');
		$this->load->model('gsatelite');
		$this->load->model('planilla_model');
		$this->load->model('contabilidad_model');
		$this->load->library('tank_auth');
		$this->load->library('pdf');
		$this->driver =  $this->planilla_model;
	}

	public function reporte_planilla()
	{
		satelite_validar();
		$emr_id = $this->tank_auth->get_empresa_id();
		$data['titulo_personal'] = "Impresión de boletas y planillas";
		$data['tipo_planilla'] = $this->planilla_model->get_tipo_contrato();
		$sucursales = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} - {suc_nombre}', '', array('suc_id_emr' => $emr_id), null, '', 'suc_id', true);
		$data['sucursales'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $sucursales);
		$this->_cargarvista($data);
	}

	public function rpt_revisiones()
	{
		satelite_validar();
		$data['tipo_planilla'] = $this->planilla_model->get_tipo_contrato();
		$data['permisos'] = $this->gsatelite->get_permisos_opcion();
		$data['titulo_personal'] = "Revisión mensual";
		$this->_cargarvista($data);
	}

	public function detalle_planilla()
	{
		satelite_validar();
		$data['titulo_personal'] = "Detalle de Planilla";
		$data['tipo_planilla'] = $this->planilla_model->get_tipo_contrato();
		$this->_cargarvista($data);
	}

	/*
	* Edith Herrera
	*/
	public function planillas_ylufa()
	{
		satelite_validar();
		$data['titulo_personal'] = "Impresión de planillas";
		$data['tipo_planilla'] = $this->planilla_model->get_tipo_contrato();
		$this->_cargarvista($data);
	}

	//funcion de prueba
	public function crear_txt()
	{
		//Creamos el archivo datos.txt
		//ponemos tipo 'a' para añadir lineas sin borrar
		$file = fopen("uploads/txt_planilla/datos.txt", "a") or die("Problemas");
		//vamos añadiendo el contenido
		//fwrite($file,"primera linea \n");
		//fwrite($file,"segunda linea \n");
		//fwrite($file,"tercera linea \n");
		fputs($file, "primera linea");
		fputs($file, chr(13) . chr(10));
		fputs($file, "segunda linea");
		fputs($file, chr(13) . chr(10));
		fputs($file, "tercera linea");
		fputs($file, chr(13) . chr(10));
		fclose($file);
		// header("Location: uploads/txt_planilla/datos.txt");
		//header()
	}

	//funcion de prueba
	public function comparar_separar()
	{
		//diciembre 2014
		//$ae1 = "006352730,025244912,002943149,020819178,034351530,024447038,021351393,008783694,013481859,026391055,006046779,009290369,007545750,022668866,011528697,013557375,043131395,015095345,003692254,010236695,001116286,023040469,001985643,001781374,037639898,025426093,036235219,036106680,027533375,020331675,003755298,038122616,040535207,036575627,025298945,006817227,019112775,031356175,041309316,018747624,041122683,001001292,028440787,024474297,040030176,020881620,043023607,029349015,046476273,017621485,017664857,011768530,018210067,026993661,043084297,028089905,049103748,017564447,038015974,022490629,000517683,049734963,042890548,029080263,040867840,013098800,032281828,029969661,003879335,035476480,013203798,016502662,011136763,001055210,001000804,040508446,038173772,008802642,037892828,039083093,037907356,038697425,047049485,027132608,041143435,042983618,015396987,032706161,017362756,011420263";
		//$ab2 = "006352730,025244912,002943149,025426093,022668866,041122683,021351393,008783694,006046779,015095345,013481859,009290369,001781374,037639898,027533375,031356175,041309316,020819178,034351530,024447038,026391055,007545750,001116286,023040469,001985643,036235219,036106680,020331675,003755298,036575627,025298945,006817227,019112775,018747624,011528697,013557375,043131395,003692254,010236695,038122616,040535207,001001292,017621485,011768530,018210067,026993661,043084297,028089905,017564447,038015974,022490629,000517683,029080263,013098800,032281828,003879335,049103748,049734963,043023607,029349015,017664857,046476273,024474297,040030176,028440787,001000804,013203798,035476480,039083093,038697425,027132608,041143435,015396987,032706161,037892828,040508446,038173772,016502662,011136763,001055210,008802642,037907356,042983618,017362756,011420263";
		//NOVIEMBRE
		$ae1 = "006352730,025244912,002943149,020819178,034351530,024447038,021351393,008783694,013481859,026391055,006046779,009290369,007545750,022668866,011528697,013557375,043131395,015095345,003692254,010236695,001116286,023040469,001985643,001781374,037639898,025426093,036235219,036106680,027533375,020331675,003755298,038122616,036575627,025298945,006817227,019112775,031356175,018747624,041122683,001001292,000055730,028440787,024474297,040030176,023601532,020881620,043023607,029349015,046476273,017621485,017664857,011768530,018210067,026993661,033949217,043084297,028089905,001230276,049103748,017564447,038015974,022490629,000517683,009065031,034580896,049734963,042890548,015904585,040014331,029080263,040867840,013098800,032281828,029969661,003879335,036557027,035476480,013203798,016502662,011136763,001055210,001000804,040508446,038173772,008802642,037892828,039083093,037907356,038697425,004749485,027132608,041143435,042983618,015396987,032706161,017362756,011420263";
		$ab2 = "006352730,025244912,002943149,025426093,022668866,041122683,021351393,008783694,006046779,015095345,013481859,009290369,001781374,037639898,027533375,031356175,020819178,034351530,024447038,026391055,007545750,001116286,023040469,001985643,036235219,036106680,020331675,003755298,036575627,025298945,006817227,019112775,018747624,011528697,013557375,043131395,003692254,010236695,038122616,001001292,017621485,011768530,018210067,026993661,043084297,028089905,017564447,038015974,022490629,000517683,029080263,013098800,032281828,003879335,049103748,049734963,043023607,029349015,017664857,046476273,024474297,040030176,028440787,001000804,013203798,035476480,039083093,038697425,027132608,041143435,015396987,032706161,037892828,040508446,038173772,016502662,011136763,001055210,008802642,037907356,042983618,017362756,011420263";
		//OCTUBRE
		$ae1 = "006352730,025244912,002943149,020819178,034351530,024447038,021351393,008783694,013481859,026391055,006046779,009290369,007545750,022668866,011528697,013557375,043131395,015095345,003692254,010236695,001116286,023040469,001985643,001781374,037639898,025426093,036235219,036106680,027533375,020331675,003755298,039331551,038122616,036575627,025298945,006817227,019112775,031356175,018747624,041122683,001001292,000055730,028440787,024474297,040030176,023601532,043023607,029349015,046476273,017621485,017664857,011768530,018210067,026993661,033949217,043084297,028089905,001230276,049103748,017564447,038015974,022490629,015290000,000517683,020018722,009065031,034580896,049734963,042890548,050886082,033791761,015904585,035350228,031842914,040014331,036557027,035476480,013203798,016502662,011136763,001055210,001000804,040508446,038173772,008802642,037892828,033231737,039083093,037907356,038697425,047049485,027132608,041143435,042983618,017362756,011420263";
		$ab2 = "006352730,025244912,002943149,025426093,022668866,041122683,021351393,008783694,006046779,015095345,013481859,009290369,001781374,037639898,027533375,031356175,020819178,034351530,024447038,026391055,007545750,001116286,023040469,001985643,036235219,036106680,020331675,003755298,036575627,025298945,006817227,019112775,018747624,011528697,013557375,043131395,003692254,010236695,038122616,001001292,017621485,011768530,018210067,026993661,043084297,028089905,017564447,038015974,022490629,000517683,049103748,049734963,043023607,029349015,017664857,046476273,024474297,040030176,028440787,001000804,013203798,035476480,039083093,038697425,027132608,041143435,037892828,040508446,038173772,016502662,011136763,001055210,008802642,037907356,042983618,017362756,011420263";
		//MARZO
		$ae1 = "025426093,022668866,034471885,006352730,025244912,002943149,039252082,034351530,024447038,021351393,008783694,013481859,026391055,006046779,009290369,007545750,011528697,036318740,013557375,043131395,015095345,003692254,010236695,001116286,023040469,001985643,001781374,046393310,037639898,036235219,036106680,037178478,020331675,003755298,038122616,036575627,025298945,006817227,019112775,031356175,041309316,018747624,001001292,046476273,028440787,023487441,002352893,040030176,039006180,043023607,029349015,017621485,017664857,011768530,018210067,026993661,043084297,028089905,038015974,022490629,049734963,029080263,019357618,022251693,010089276,035285504,024354950,023595812,005359072,037296268,030538091,023190175,018023020,017934498,018834049,001000804,035476480,013203798,016502662,011136763,001055210,040508446,008802642,037892828,039083093,037907356,038697425,047049485,027132608,041143435,043327255,042983618,015396987,032706161,017362756,011420263";
		$ab2 = "006352730,025244912,002943149,025426093,022668866,021351393,008783694,006046779,015095345,013481859,009290369,001781374,037639898,031356175,041309316,034351530,024447038,026391055,007545750,001116286,023040469,001985643,036235219,036106680,020331675,003755298,036575627,025298945,006817227,019112775,018747624,011528697,013557375,043131395,003692254,010236695,038122616,001001292,017621485,011768530,018210067,026993661,043084297,028089905,038015974,022490629,029080263,049734963,043023607,029349015,017664857,046476273,040030176,028440787,001000804,013203798,035476480,039083093,038697425,027132608,041143435,015396987,032706161,037892828,040508446,016502662,011136763,001055210,008802642,037907356,042983618,017362756,011420263,034471885,037178478,039252082,023595812,019357618,022251693,010089276,039006180,023487441,037296268,002352893,005359072,024354950,035285504,017934498,023190175,030538091,043327255,046393310,018023020,036318740,018834049";
		$a1 = explode(',', $ae1);
		$a2 = explode(',', $ab2);

		$res = array();
		for ($i = 0; $i < count($a1); $i++) {
			//	in_array(needle, haystack)
			if (!in_array($a1[$i], $a2)) {
				$res[] = $a1[$i];
			}
		}
		echo implode(',<br>', $res);
	}

	/**
	 *@author René Castaneda
	 */
	public function reporte_detalle_descuento()
	{
		satelite_validar();
		$emr_id = $this->tank_auth->get_empresa_id();
		$data['titulo_personal'] = "Reporte Detalle Descuento";
		$data['tipo_planilla'] = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', array('tpl_estado' => 1, 'tpl_id_emr' => $emr_id), null, '', 'tpl_id', true);
		$data['select_des'] = $this->gsatelite->get_dropdown('tdc_tipo_descuento', '{tdc_nombre}', '', array('tdc_estado' => 1), null, '', 'tdc_id', true);
		$this->_cargarvista(null, $data);
	}

	/**
	 *@author René Castaneda
	 */
	public function get_reporte_detalle_descuento()
	{
		satelite_validar();
		// var_dump($_POST);die();
		$where = array();
		$tipo_reporte = $this->input->post('tipo_reporte');
		$fecha_inicio = $this->input->post('fecha_ini');
		$fecha_final = $this->input->post('fecha_fin');
		$tipo_planilla = $this->input->post('tipo_pla');
		$periodos = $this->input->post('periodo');
		$id_descuento = $this->input->post('descuento');
		$arraydescs = explode(",", $id_descuento);
		$id_descuento_afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');
		$vista_default = "get_reporte_detalle_descuento";

		if ($fecha_inicio != "") {
			$where["pla_fecha_inicio >= "] = formatear_fecha("Y-m-d", $fecha_inicio);
		}
		if ($fecha_final != "") {
			$where["pla_fecha_fin <= "] = formatear_fecha("Y-m-d", $fecha_final);
		}
		if ($tipo_planilla > 0) {
			$where["pla_id_tpl"] = $tipo_planilla;
		}
		if ($periodos != "") {
			$where["pla_id IN ( $periodos )"] = null;
		}
		if ($id_descuento != "") {
			$where["tdc_id IN ( $id_descuento )"] = null;
		}
		$order_by = "emp_id_are ASC, emp_id ASC, tdc_id ASC";
		if (is_array($arraydescs) && count($arraydescs) == 1 && in_array($id_descuento_afp, $arraydescs)) {
			$vista_default = "get_reporte_detalle_descuento_afp";
			$order_by = "emp_id_afp ASC, emp_id_are ASC, emp_id ASC, tdc_id ASC";
		}
		$data['fecha_fin'] = $fecha_final;
		$data['fecha_ini'] = $fecha_inicio;
		$data['tipo_reporte'] = $tipo_reporte;
		$data['consulta'] = $this->planilla_model->get_rpte_descuento_planilla($where, $order_by);
		$tabla_html = $this->load->view("personal/reportes/$vista_default", $data, true);
		if ($tipo_reporte == 'excel') {
			echo $tabla_html;
		} elseif ($tipo_reporte == 'pdf') {
			$html = $this->load->view('reporte/header', array('titulo' => "Descuentos"), true);
			$html .= $tabla_html;
			$this->pdf->setPrintFooter(true);
			$this->pdf->makePDF($html, 'L');
		} else {
			echo json_encode(array('tabla' => trim($tabla_html), 'filas' => count($data['consulta'])));
		}
	}

	/**
	 *@author Raul E.
	 */
	public function reporte_descuento_bancarios()
	{
		satelite_validar();
		if ($_POST) {
			// var_dump($_POST);die();
			$ids_bancos = $ids_tipos = array();
			$tipo_planilla 			= $this->input->post('tipo_pla');
			$periodo 				= $this->input->post('periodo');
			$tipo_reporte 			= $this->input->post('tipo_reporte');
			$bancos 				= $this->input->post('banco_aplica');
			$tipos 					= $this->input->post('tipos_aplica');
			$periodos_consolidado 	= $this->input->post('periodos_consolidado');
			if ($tipo_reporte != "") {
				if (trim($bancos) != "") {
					$ids_bancos = array_merge($ids_bancos, explode(',', $bancos));
				}
				if (trim($tipos) != "") {
					$ids_tipos = array_merge($ids_tipos, explode(',', $tipos));
				}
			} else {
				if (is_array($bancos)) {
					$ids_bancos = array_merge($ids_bancos, $bancos);
				}
				if (is_array($tipos)) {
					$ids_tipos = array_merge($ids_tipos, $tipos);
				}
			}
			if ($tipo_reporte != "") {
				$periodos_consolidado = ($this->input->post('aplica_consolidado') == 1) ? $periodos_consolidado : null;
			}
			$data['estilo'] = "";
			if (count($ids_tipos) > 0) {
				$this->db->where_in('ddd_id_tdc', $ids_tipos);
			}
			if (count($ids_bancos) > 0) {
				$this->db->where_in('dss_id_ban', $ids_bancos);
			}
			if ($periodos_consolidado != null && $periodos_consolidado != "null") {
				$this->db->where_in('ddd_id_pla', $periodos_consolidado);
			} else {
				$this->db->where('ddd_id_pla', $periodo);
			}
			$where = array("tdc_prestamo_bancario" => 1);
			$data['consulta'] = $this->planilla_model->get_rpte_descuentos_bancarios($where);
			// print_r($this->db->last_query());die();
			$periode = ($periodos_consolidado != null && $periodos_consolidado != "null") ? implode(',', $periodos_consolidado) : $periodo;
			$fec_min = $this->gsatelite->get_min("pla_planilla", "pla_fecha_inicio", array("pla_id IN ($periode)" => null));
			$fec_max = $this->gsatelite->get_max("pla_planilla", "pla_fecha_fin", array("pla_id IN ($periode)" => null));
			$title = "<h3>NÓMINA CORRESPONDIENTE AL PERÍODO DE " . formatear_fecha('d-m-Y', $fec_min) . " A " . formatear_fecha('d-m-Y', $fec_max) . "</h3>";
			$data['titulo_reporte_banco'] = $title;
			if ($tipo_reporte == 'excel') {
				$data['esreporte'] = true;
				header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
				header("Content-Disposition: attachment;filename = Reporte_descuentos_banca.xls");
				header("Pragma: no-cache");
				header("Expires: 0");
				$data['titulo_reporte_excel'] = "<h3>Reporte de Descuentos Bancarios</h3>";
				$data['es_excel'] = true;
				$this->load->view("personal/reportes/get_reporte_detalle_descuento_ban", $data, false);
			} elseif ($tipo_reporte == 'pdf') {
				$data['estilo'] = 'style="font-size:7px;"';
				$data['esreporte'] = true;
				$data['es_pdf'] = true;
				$html = $this->load->view('reporte/header', array('titulo' => "Descuento Bancarios"), true);
				$html .= $this->load->view("personal/reportes/get_reporte_detalle_descuento_ban", $data, true);
				$this->pdf->setPrintFooter(true);
				$this->pdf->makePDF($html, 'L');
			} else {
				$this->load->view("personal/reportes/get_reporte_detalle_descuento_ban", $data, false);
			}
		} else {
			$emr_id = $this->tank_auth->get_empresa_id();
			$data['tipo_descuento'] = $this->gsatelite->get_dropdown('tdc_tipo_descuento', '{tdc_nombre}', '', array('tdc_estado' => 1, 'tdc_prestamo_bancario' => 1), null, '', 'tdc_id', true);
			$data['entidad_banco'] = $this->gsatelite->get_dropdown('ban_banco', '{ban_nombre}', '', array('ban_estado' => 1), null, '', 'ban_id', true);
			$data['tipo_planilla'] = $this->gsatelite->get_tabla('tpl_tipo_planilla', array('tpl_id_emr' => $emr_id));
			$data['titulo_personal'] = "Reporte Detalle Ingreso";
			$this->_cargarvista(null, $data);
		}
	}

	/**
	 * @author Raul E
	 */
	public function rpte_otros_descuentos($flag = null)
	{
		satelite_validar();
		if ($_POST) {
			$tipo_planilla = $this->input->post('tipo_pla');
			$texto_tipo_pl = $this->input->post('txt_plan');
			$periodos_plan = ($this->input->post('prdo_pla') != "") ? $this->input->post('prdo_pla') : 0;
			$tipo_reporte = $this->input->post('reporte');
			$registros = $this->planilla_model->get_otros_descuentos(array("pla_id IN ($periodos_plan)" => null));
			$data['registros'] = $registros;
			$data['tipo_plan'] = $texto_tipo_pl;
			$data['filename'] = 'otros_desc_pla_' . $texto_tipo_pl;
			$data['reporte'] = $tipo_reporte;
			$html = $this->load->view('personal/reportes/detalle_otros_desc', $data, true);
			if ($flag) {
				echo json_encode(array('tabla' => $html, 'filas' => count($registros)));
			} else {
				if ($tipo_reporte == 'excel') {
					echo $html;
				} else {
					$periodo = (count($registros) > 0) ? 'Del ' . formatear_fecha('d/m/Y', $registros[0]['desde']) . ' al ' . formatear_fecha('d/m/Y', $registros[0]['hasta']) : "";
					$header = $this->load->view('reporte/header', array('titulo' => 'Otros Descuentos por Empleada/o en Planilla: ' . $texto_tipo_pl, 'subtitulo' => $periodo), true);
					$documento = $header . $html;
					$this->pdf->makePdf($documento, 'P');
				}
			}
		} else {
			$data['titulo_personal'] = "Reporte Otros Descuentos";
			$data['tipo_planilla'] = $this->planilla_model->get_tipo_contrato();
			$this->_cargarvista(null, $data);
		}
	}

	/**
	 * @author Raul E
	 */
	public function rpt_prom_com($flag = null)
	{
		satelite_validar();
		if ($_POST) {
			$empleado = ($this->input->post('empleado') > 0) ? $this->input->post('empleado') : null;
			$fecha_ref = ($this->input->post('fecha_ref') != "") ? $this->input->post('fecha_ref') : null;
			$tipo_reporte = $this->input->post('tipo_reporte');
			$registros = $this->planilla_model->get_prom_comisiones_rpt($fecha_ref, $empleado);
			$data['registros'] = $registros;
			$data['reporte'] = $tipo_reporte;

			$html = $this->load->view('personal/reportes/detalle_comisiones_prom', $data, true);
			if ($flag) {
				echo json_encode(array('tabla' => $html, 'filas' => count($registros)));
			} else {
				if ($tipo_reporte == 'excel') {
					echo $html;
				} else {
					$header = $this->load->view('reporte/header', array('titulo' => 'Promedio de ingreso por comisiones por empleado', 'solotitulo' => true), true);
					$documento = $header . $html;
					$this->pdf->makePdf($documento, 'L');
				}
			}
		} else {
			$data['titulo_personal'] = "Promedio de Comisiones";
			$emps = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
			$data['empleado'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $emps);
			$this->_cargarvista(null, $data);
		}
	}

	/**
	 *@author René Castaneda
	 */
	public function reporte_detalle_ingreso()
	{
		satelite_validar();
		$emr_id = $this->tank_auth->get_empresa_id();
		$data['tipo_planilla'] = $this->gsatelite->get_tabla('tpl_tipo_planilla', array('tpl_id_emr' => $emr_id));
		$data['titulo_personal'] = "Reporte Detalle Ingreso";
		$this->_cargarvista(null, $data);
	}

	public function rpt_ingresos_anuales($flag = null)
	{
		satelite_validar();
		if ($_POST) {
			$periodo   = $this->input->post('slct_year');
			$ingresos  = $this->input->post('slct_inns');
			$empleados = $this->input->post('slct_emps');
			$stado_emp = $this->input->post('slct_stat');
			$tipoPlani = $this->input->post('slct_tpla');
			$reporte   = $this->input->post('tipo_reporte');
			$where_emp = ($stado_emp < 2) ? array('emp_estado' => $stado_emp) : array();
			$nom_ingresos = array();
			if ($periodo != '') {
				$where_emp["YEAR(pla_fecha)"] = $periodo;
			}
			if (trim($empleados) != '') {
				$where_emp["emp_id IN ($empleados)"] = null;
			}
			if (trim($tipoPlani) != '') {
				$where_emp["tpl_id IN ($tipoPlani)"] = null;
			}
			$array_empleados = $this->planilla_model->info_empleados_activos($where_emp);
			$dias_mes = array();
			for ($i = 1; $i <= 12; $i++) {
				$m = ($i < 10) ? '0' . $i : $i;
				foreach ($array_empleados as &$val) {
					$where_inn = array();
					$where_intp = array();
					$plan_ids = ($val['planillas'] != "") ? $val['planillas'] : 0;
					$where_inn["ddi_id_emp"] = $val["emp_id"];
					$where_inn["MONTH(pla_fecha_fin)"] = $i;
					$where_inn["ddi_id_pla IN ($plan_ids)"] = null;
					if (trim($ingresos) != "") {
						$where_inn["ddi_id_tig IN ($ingresos)"] = null;
					}
					if (trim($tipoPlani) != "") {
						$where_inn["tpl_id IN ($tipoPlani)"] = null;
					}
					$val["ingresos"][$i] = $this->planilla_model->get_ings_mes_emp($where_inn);
				}
				$dias_mes[$i] = $this->gsatelite->get_campo('djm_dias_trajado_mes', 'djm_dias', array('djm_estado' => 1, 'CAST(djm_periodo AS CHAR) = ' => $periodo . $m));
			}
			$texto1 = $texto2 = '';
			$nuevo_array = '';
			if ($ingresos != '') {
				$nom_ingresos["TIG.tig_id IN ($ingresos)"] = null;
				$array_ingresos = $this->planilla_model->get_nombre_ingresos($nom_ingresos);
				$nuevo_array = array_column($array_ingresos, 'tig_nombre');
				$texto1 = implode(', ', $nuevo_array);
			}
			if (trim($tipoPlani) != '') {
				$array_tpls = $this->gsatelite->get_tabla('tpl_tipo_planilla', array("tpl_id IN ($tipoPlani)" => null));
				$nombres = array_column($array_tpls, 'tpl_nombre');
				$texto2 = implode(', ', $nombres);
			}
			$data['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

			$data['det_dias'] = $dias_mes;
			$data['reporte'] = $reporte;
			$data['periode'] = 'Año ' . $periodo;
			$data['dias_mes'] = $this->gsatelite->get_suma('djm_dias_trajado_mes', 'djm_dias', array('djm_estado' => 1, 'CAST(djm_periodo AS CHAR(4)) = ' => $periodo));
			$data['filename'] = 'rpt_ing_anual_' . $periodo . '_' . date('dmY') . substr(uniqid(md5(rand()), true), 0, 5);
			$data['registros'] = $array_empleados;
			$data['ingresos'] = $texto1;
			$data['tip_plan'] = $texto2;
			$html = $this->load->view('personal/reportes/detalle_ingr_anual', $data, true);
			if ($flag) {
				echo json_encode(array('tabla' => $html, 'filas' => count($array_empleados)));
			} else {
				if ($reporte == 'pdf') {
					ini_set('memory_limit', '512M');
					ini_set('max_execution_time', '9999');
					$header = $this->load->view('reporte/header',  array('titulo' => 'Ingresos Anuales Año ' . $periodo), true);
					$documento = $header . $html;
					$this->pdf->makePdf($documento, 'L', '', 'Letter', 'I', array(5, 5, 5));
				} else {
					echo $html;
				}
			}
		} else {
			$select_years = '';
			$years_array = $this->db->select("DISTINCT(YEAR(pla_fecha)) AS years", false)->from('pla_planilla')->order_by('years DESC')->get()->result_array();
			$tipo_ings = $this->gsatelite->get_dropdown('tig_tipo_ingreso', '{tig_nombre}', '', array('tig_estado' => 1), null, '', 'tig_id', true);
			$tipo_plan = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', array('tpl_estado' => 1), null, '', 'tpl_id', true);
			$dropdown = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
			foreach ($years_array as $k => $val) {
				$select_years .= '<option value="' . $val['years'] . '">' . $val['years'] . '</option>';
			}
			$data['empleado'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $dropdown);
			$data['ingresos'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $tipo_ings);
			$data['planillas'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $tipo_plan);
			$data['select_years'] = $select_years;
			$data['titulo_personal'] = "Detalle Ingresos Anuales";
			$this->_cargarvista($data);
		}
	}

	/**
	 *@author René Castaneda
	 */
	public function get_reporte_detalle_ingreso()
	{
		satelite_validar();
		$data['estilo'] = "";

		$tipo_planilla = $this->input->post('tipo_pla');
		$periodo = $this->input->post('periodo');
		$id_ingreso = $this->input->post('ingreso');
		$tipo_reporte = $this->input->post('tipo_reporte');
		$vista_default = "get_reporte_detalle_ingreso";
		$periodos_consolidado = $this->input->post('periodos_consolidado');

		// Preguntar por los parametros correspondientes a vacacion y prima de vacacion
		$id_prima = $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION');
		$id_vaca = $this->gsatelite->get_parametro('INGRESO_VACACIONES');
		//Id aguinaldo parametrizado
		$id_ingreso_aguinaldo = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO');
		$data['id_prima_v'] = $id_prima;
		$data['id_vaca'] = $id_vaca;
		$es_vacacion = false;

		if ($tipo_reporte == 'pdf' or $tipo_reporte == 'excel') {
			$periodos_consolidado = ($this->input->post('aplica_consolidado') == 1) ? $periodos_consolidado : null;
		}

		if ($periodos_consolidado != null and $periodos_consolidado != "null") {
			$this->db->where_in('ddi_id_pla', $periodos_consolidado);
		} else {
			$this->db->where('ddi_id_pla', $periodo);
		}

		if ($id_ingreso == "vaca_prima") {
			$vista_default = "get_reporte_detalle_ingreso2";
			$where = null;
			$es_vacacion = true;
			$this->db->where_in('ddi_id_tig', array($id_prima, $id_vaca));
		} elseif ($id_ingreso == $id_ingreso_aguinaldo) {
			$vista_default = "get_reporte_detalle_ingreso_aguinaldo";
			$where = array('ddi_id_tig' => $id_ingreso);
		} else {
			$where = array('ddi_id_tig' => $id_ingreso);
		}

		$data['consulta'] = $this->planilla_model->get_reporte_ingreso_planilla($where, $es_vacacion);
		//echo $this->db->last_query(); die();
		$ing = $this->gsatelite->get_registro('tig_tipo_ingreso', 'tig_id', $id_ingreso);
		$data['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

		if ($tipo_reporte == 'excel') {
			$data['esreporte'] = true;
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header("Content-Disposition: attachment;filename=Reporte_detalle_ingresos.xls");
			header("Pragma: no-cache");
			header("Expires: 0");
			$nombre_ingreso = ($ing->tig_nombre) ? $ing->tig_nombre : "Vacación y prima de vacación";
			$data['titulo_reporte_excel'] = "<h3>Reporte de ingreso $nombre_ingreso</h3>";
			$data['es_excel'] = true;
			$this->load->view("personal/reportes/$vista_default", $data, FALSE);
		} elseif ($tipo_reporte == 'pdf') {
			$data['estilo'] = 'style="font-size:7px;"';
			$nombre_ingreso = ($ing->tig_nombre) ? $ing->tig_nombre : "Vacación y prima de vacación";
			$html = $this->load->view('reporte/header', array('titulo' => "ingreso $nombre_ingreso"), true);
			$data['esreporte'] = true;
			$html .= $this->load->view("personal/reportes/$vista_default", $data, true);
			$this->load->library('Pdf'); //libreria pdf
			$this->pdf->setPrintFooter(true);
			$this->pdf->makePDF($html, 'L');
		} else {
			$data['esreporte'] = false;
			$this->load->view("personal/reportes/$vista_default", $data, FALSE);
		}
	}

	/**
	 *@author René Castaneda
	 */
	function obtener_periodo_planilla()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
			$var         = '';
			$t_planilla  = $this->input->post('t_planilla');
			$tipo = $this->input->post('tipo');
			$periodos  = $this->planilla_model->obtener_periodo_planilla($t_planilla, $tipo);
			foreach ($periodos as $key) {
				switch ($key['pla_estado']) {
					case '1':
						$estado = "Creada";
						break;
					case '2':
						$estado = "Generada";
						break;
					case '3':
						$estado = "Autorizada";
						break;
					default:
						break;
				}
				if ($key['pla_estado'] != 1) {
					$var .= "<option value='" . $key['pla_id'] . "'>" . formatear_fecha('d-m-Y', $key['pla_fecha_inicio']) . "  --  " . formatear_fecha('d-m-Y', $key['pla_fecha_fin']) . " " . $estado . "</option>";
				}
			}
			$arreglo = array(
				"drop" => $var,
			);
			echo json_encode($arreglo);
		}
	}

	public function get_empleado()
	{
		satelite_validar();
		$suc_id = $this->input->post('suc_id');
		$slcArea = $this->input->post('slcArea');

		$where_array['emp_id_emr'] = $this->tank_auth->get_empresa_id(); //where de la empresa
		if ($slcArea > 0) {
			$where_array['emp_id_are'] = $slcArea;
		}
		if ($suc_id > 0) {
			$where_array['emp_id_suc'] = $suc_id;
		}

		$empleados = $this->db->select()->from('emp_empleado')->where($where_array)->order_by('emp_nombre', 'ASC')->get()->result_array();
		// var_dump($this->db->last_query());die();

		$cadena = "";
		foreach ($empleados as $key => $value) {
			$cadena .= "<option value='" . $value['emp_id'] . "'>" . $value['emp_codigo'] . " - " . $value['emp_nombre'] . " " . $value['emp_apellido'] . (($value['emp_estado'] != 1) ? ' (INACTIVO)' : '') . "</option>";
		}

		$arreglo = array('lista' => $cadena);
		echo json_encode($arreglo);
	}

	public function get_empleado_x_stado()
	{
		satelite_validar();
		$estado = $this->input->post('estado');
		$states = ($estado < 2) ? array('emp_estado' => $estado) : null;
		$empleados = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', $states, null, '', 'emp_id', true);
		echo str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $empleados);
	}

	/**
	 *@author René Castaneda
	 *@return Select con los tipo de planilla a las que pertenece el empleado
	 */
	public function get_tipo_planilla_empleado()
	{
		satelite_validar();
		$id_empleado = $this->input->post('emp_id');
		$this->db->join('txe_tipo_planillaxempleado', 'txe_id_tpl=tpl_id');
		$select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', array('txe_id_emp' => $id_empleado), null, '', 'tpl_id', true);
		$data["select_tipo_pla"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
		die(json_encode($data));
	}

	/**
	 *@author Herberh Lucho
	 *@return Select con los tipo de contrato a las que pertenece el empleado
	 */
	public function get_tipo_contrato_empleado()
	{
		satelite_validar();
		$id_empleado = $this->input->post('emp_id');
		$this->db->join('emp_empleado', 'emp_id_tic = tic_id');
		$select = $this->gsatelite->get_dropdown('tic_tipo_contrato', '{tic_nombre}', '', array('emp_id' => $id_empleado), null, '', 'tic_id', true);
		$data["select_tipo_contrato"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
		die(json_encode($data));
	}

	/*
	 * Modificado: 19/09/2017 por Edith Herrera (Formato).
	 */
	public function imprimir_constancia(){
		satelite_validar();
		// var_dump($_POST);die();
		$this->load->library('EnLetras');
		$empleado = $_POST['empleado'];
		$tipo = $_POST['constancia'];
		$tipo_planilla = ($_POST['tipo_planilla'] > 0) ? $_POST['tipo_planilla'] : 0;
		$anio = ($this->input->post('year') > 0) ? $this->input->post('year') : date('Y');
		$fecha = date('Y-m-d');
		$dirigido = (isset($_POST['persona']) AND trim($_POST['persona']) != "") ? $_POST['persona'] : '';
		$lugar = ($this->input->post('lugar') != "") ? $this->input->post('lugar') : null;
		$tipo_salario = (isset($_POST['tipo_salario']) AND $_POST['tipo_salario'] > 0) ? $_POST['tipo_salario'] : 1; //POR DEFECTO EL PROMEDIADO REAL
		$tipo_desc = (isset($_POST['tipo_descuento']) != '') ? $_POST['tipo_descuento'] : null; //SOLO PARA CONSTACIA-FORMATO=11 
		$codigo_ingreso01 = $this->planilla_model->codigo_ingreso01($empleado, $tipo_planilla);
		//"{"sueldo":0,"renta":0}" TIG_GRAVADO==1 Pero si ya paso la 1er quincena solo sale eso SE DEBE REVISAR
		$codigo_ingreso11 = $this->planilla_model->codigo_ingreso11($empleado, $tipo_planilla); 
		//"{"comision":"3624.44","renta":0}" NO SIRVE solo saca el porcentaje del total pero de la tabla isr
		/* SOLO SIRVE PARA SALARIO NORMAL Y RENTA ISR SEGUN TABLA, CASO SAT HONORARIOS Y RENTA10 NO ESTA SOPORTADO, DEVUELVE 0 SE RECOMIENDA REVISAR CASO DE USI*/
		$tipo_dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
		$rep_legal = $this->gsatelite->get_parametro('ID_REPRESENTANTE_LEGAL');
		$cons_trabajo = $this->db->select("*, if(gen_nombre LIKE 'femenino', pro_prefijo_f, pro_prefijo_m) as titulo, 
							(SELECT mun_nombre FROM mun_municipio JOIN suc_sucursal ON suc_id_mun = mun_id JOIN emp_empleado ON suc_id = emp_id_suc WHERE emp_id = $rep_legal) AS mun_rh", FALSE)
			->from('emp_empleado')
			->where('emp_id', $empleado)
			->join('suc_sucursal', 'suc_id=emp_id_suc', 'left')
			->join('gen_genero', 'emp_id_gen=gen_id', 'left')
			->join('pro_profesion', 'pro_id=emp_id_pro', 'left')
			->join('mun_municipio', 'suc_id_mun=mun_id', 'left')
			->join('dep_departamento', 'mun_id_dep=dep_id', 'left')
			->join("dce_documento_emp", "dce_id_emp = emp_id AND dce_id_tde = $tipo_dui", "left")
			->join('plz_plaza', 'plz_id = emp_id_plz', 'left')
			->join('are_area', 'are_id = plz_id_are', 'left')
			->join('pto_puesto', 'pto_id = plz_id_pto', 'left')
			->join('afp_afp', 'afp_id=emp_id_afp', 'left')
			->get()->result_array();
		$ultimo_sueldo = floatval($this->planilla_model->ultimo_sueldo($empleado, 1, $tipo_planilla));
		$ingresos = $this->planilla_model->get_ingresosxplanilla($empleado, $tipo_planilla);
		$sueldo_base = 0;
		$sueldo_promedio = 0;
		$actual_com = 0;
		$parametro_calculo_vacacion_meses = $this->gsatelite->get_parametro('NUM_PLANILLAS_CALCULO_VACACION');
		$par_com = $this->gsatelite->get_parametro('INGRESO_COMISIONES');
		//if($tipo_salario == 1 || $tipo_salario == 3){ //promedio
		//Promedio total
		$promedio = $this->planilla_model->get_promedio_ingreso_empleado($empleado, $parametro_calculo_vacacion_meses, 1, $tipo_planilla);
		$sueldo_promedio = $promedio[0];
		$num_planilla = $promedio[1];
		//Promedio sin comisiones (EMI)
		$comision = ($par_com > 0) ? $par_com : null;
		$prom_scom = $this->planilla_model->get_promedio_ingreso_empleado($empleado, $parametro_calculo_vacacion_meses, 1, $tipo_planilla, $comision, $solo_com = false);
		$promedio_sin_com = $prom_scom[0];
		//Promedio de comisiones (EMI)
		$prom_com = $this->planilla_model->get_promedio_ingreso_empleado($empleado, $parametro_calculo_vacacion_meses, 1, $tipo_planilla, $comision, $num_planilla);
		$promedio_com = $prom_com[0];
		//} else {
		$sueldo_base = $this->gsatelite->get_campo('emp_empleado', 'emp_salario', array('emp_id' => $empleado));
		$arr_ult_reg_pla = array('ddi_id_emp' => $empleado, 'pla_estado' => 3); /////
		if ($tipo_planilla > 0) { ///////
			$arr_ult_reg_pla['pla_id_tpl'] = $tipo_planilla; ////////////
		} //////////////
		$this->db->join('pla_planilla', 'pla_id = ddi_id_pla');
		$this->db->limit(1);
		$this->db->order_by('pla_fecha_fin', 'DESC');
		$ultimo_reg_pla = $this->gsatelite->get_tabla('ddi_detalle_ingreso', $arr_ult_reg_pla);
		$fecha_mes_anio = ($ultimo_reg_pla) ? formatear_fecha('Ym', $ultimo_reg_pla[0]['pla_fecha_inicio']) : date('Ym');
		$arr_com_act = array('ddi_id_tig' => $par_com, 'DATE_FORMAT(pla_fecha_inicio, "%Y%m") =' => $fecha_mes_anio, 'ddi_id_emp' => $empleado);
		if ($tipo_planilla > 0) { ///////////////
			$arr_com_act['pla_id_tpl'] = $tipo_planilla; ////////////////
		} ///////////////
		$comisiones_act = $this->planilla_model->get_ultimo_ingreso($arr_com_act); //////////////////////
		if (count($comisiones_act) > 0) {
			$actual_com = $comisiones_act->mensual;
		}
		// var_dump($actual_com);die();
		// print_r($this->db->last_query());die();
		//}
		if ($tipo_salario == 3) {
			$desc_ley = $this->planilla_model->descuentos_ley_vivo($empleado, $sueldo_promedio, $tipo_planilla);
		} elseif ($tipo_salario == 1) {
			$desc_ley = $this->planilla_model->descuentos_ley_promediado($empleado, null, $tipo_planilla);
		} else {
			$desc_ley = $this->planilla_model->descuentos_ley($empleado, null, $tipo_planilla);
		}
		//print_r($desc_ley);die();
		$documentos = $this->planilla_model->documentos_emp($empleado);
		$nup = $this->planilla_model->info_completa_empleado($empleado)[0]['emp_afp'];
		$id_planilla = $this->db->select('pla_id as planilla')
			->from('pla_planilla');
		if ($tipo_planilla > 0) {
			$this->db->where('pla_id_tpl', $tipo_planilla);
		}
		$this->db->where('pla_fecha_inicio <=', $fecha)
			->where('pla_fecha_fin >=', $fecha)
			->limit(1)
			->order_by('pla_fecha_fin', 'DESC')
			->get()->row();
		$pla_id = $id_planilla->planilla;
		/****************** DESCUENTOS PARA CONSTANCIA ANUAL ***********************/
		$renta10_des = 0;
		$renta_des = 0;
		$banco_des = 0;
		$descuento_anual = $this->planilla_model->get_descuentos_anual($empleado, $tipo_planilla, $anio);
		$isss = $this->gsatelite->get_parametro('DESCUENTO_ISS');
		$renta = $this->gsatelite->get_parametro('DESCUENTO_ISR');
		$id_afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');
		$renta10 = $this->gsatelite->get_parametro('DESCUENTO_ISR10');
		$renta10 = $this->gsatelite->get_parametro('DESCUENTO_ISR10');
		$otros_internos = $this->gsatelite->get_parametro('ID_DESCUENTO_INTERNO_RENTA');
		$otros_desc = explode(',', $otros_internos);
		foreach ($descuento_anual as $ds => $dss) {
			if ($isss == $dss['tdc_id']) {
				$isss_des = $dss['ddd_valor'];
				$afecto_isss = $dss['afecto'];
			} else if ($renta == $dss['tdc_id']) {
				$renta_des = $dss['ddd_valor'];
				$afecto_renta = $dss['afecto'];
			} else if ($id_afp == $dss['tdc_id']) {
				$afp_des = $dss['ddd_valor'];
				$afecto_afp = $dss['afecto'];
			} else if ($renta10 == $dss['tdc_id']) {
				$renta10_des = $dss['ddd_valor'];
				$afecto_renta10 = $dss['afecto'];
			} else if (in_array($dss['tdc_id'], $tipo_desc)) {
				$otrosdescv[] = $dss['ddd_valor'];
				$otrosdesca[] = $dss['afecto'];
				$otrosdescn[] = $dss['tdc_nombre'];
				// } else if(in_array($banco,$dss['tdc_id'])==$dss['tdc_id']){ //compara si existe el id en el array y luego si es igual para guardar la cantidad
				// 	$banco_des=$dss['ddd_valor']; 
				// 	$afecto_banco=$dss['afecto']; 
			} else if (in_array($dss['tdc_id'], $otros_desc)) {
				$otros_dss = $dss['ddd_valor'];
			}
		}
		$porcen_renta = $this->gsatelite->get_campo('tdc_tipo_descuento', 'tdc_porcentaje', array('tdc_id' => $renta10));
		/****************** INGRESOS PARA CONSTANCIA ANUAL ***********************/
		$ingreso_anual = $this->planilla_model->get_ingresos_anual($empleado, $tipo_planilla, $anio);
		//$reg_afp=$this->gsatelite->get_campo('emp_empleado','emp_id_afp', array('emp_id'=>$empleado));
		//$porcen_afp=$this->gsatelite->get_campo('afp_afp', 'afp_porcentaje', array('afp_id'=>$reg_afp));			
		$vacacion = $this->gsatelite->get_parametro('ID_TIG_VACACION');
		$prima_vacacion = $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION');
		$horas_extra = $this->gsatelite->get_parametro('ID_INGRESO_HORAS_EXTRAS'); //Parametro para horas extras 
		$hrs_extra = explode(',', $horas_extra);
		$salario_ing = $this->gsatelite->get_parametro('INGRESO_SALARIO');
		$bonificacion = $this->gsatelite->get_parametro('INGRESO_BONIFICACIONES');
		$aguinaldo = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO');
		$comision = $this->gsatelite->get_parametro('INGRESO_COMISIONES');
		$indemnizacion = $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION');
		$aguinaldo_no_grav = 0;
		$salario_otros = 0;
		foreach ($ingreso_anual as $in => $inn) {
			if ($vacacion == $inn['tig_id']) {
				$vacacion_inn = $inn['valor'];
			} else if ($prima_vacacion == $inn['tig_id']) {
				$prima_inn = $inn['valor'];
			} else if (in_array($inn['tig_id'], $hrs_extra)) {
				$extra_inn = $inn['valor'];
			} else if ($bonificacion == $inn['tig_id']) {
				$bonif_inn = $inn['valor'];
			} else if ($aguinaldo == $inn['tig_id']) {
				$aguinaldo_inn = $inn['valor'];
			} else if ($comision == $inn['tig_id']) {
				$comision_inn = $inn['valor'];
			} else if ($indemnizacion == $inn['tig_id']) {
				$indemnizacion_inn = $inn['valor'];
			} else if ($salario_ing == $inn['tig_id']) {
				$solo_salario += $inn['valor'];
			} else {
				$otros += $inn['ddi_valor'];
			}
		}
		$salario_otros = $solo_salario + $otros; // salario y otros ingresos (plailla de renta original)
		$subtotal_gravadas = $vacacion_inn + $bonif_inn + $aguinaldo_inn + $comision_inn + $salario_otros + $prima_inn;
		$total_gravadas = $subtotal_gravadas - ($afp_des + $isss_des);
		$total_no_grav = $aguinaldo_no_grav + $indemnizacion_inn;
		$empleado = $cons_trabajo[0]['emp_id'];
				   $this->db->limit(1);
				   $this->db->order_by('pps_id', 'DESC');
				   $this->db->join('plz_plaza', 'pps_id_plz = plz_id');
		$pps_reg = $this->gsatelite->get_tabla('pps_promocion_plaza_salarioxemp', array('pps_id_emp' => $empleado));
		$plaza_pps = (count($pps_reg) > 0) ? $pps_reg[0]['plz_nombre'] : '';
		$constancia_salario_agrupador = ($tipo_salario == 4) ? $this->planilla_model->datos_constancia_agrupador($empleado) : array();
		$carta_ingreso_renta = $this->planilla_model->get_ingresos_anual_full($empleado, $anio);
		$data = array(
			'cons_trabajo'  => $cons_trabajo,
			'ultimo_sueldo' => $ultimo_sueldo,
			'sueldo_base'	=> $sueldo_base,
			'descuentos'	=> $desc_ley,
			'tipo_cons' 	=> $tipo,
			'documentos'	=> $documentos,
			'nup'			=> $nup,
			'codigo01' 		=> $codigo_ingreso01,
			'dirigidoa' 	=> $dirigido,
			'codigo11' 		=> $codigo_ingreso11,
			'fechas' 		=> $fechas,
			'sueldoProm'	=> $sueldo_promedio, // Promedio de sueldo total (6 meses según parámetro) 
			'anio'			=> $anio,
			'vacacion_inn'	=> $vacacion_inn,
			'bonif_inn'		=> $bonif_inn,
			'aguinaldo_inn' => $aguinaldo_inn,
			'comision_inn'  => $comision_inn,
			'salario_otros' => $salario_otros, // Consolidado de salario y otros ingresos de hace 6 meses
			'subtotal_grav' => $subtotal_gravadas,
			'afp'			=> $afp_des,
			'total_gravadas' => $total_gravadas,
			'indemnizacion' => $indemnizacion_inn,
			'isss_des'		=> $isss_des,
			'renta'			=> $renta_des,
			'renta10'		=> $renta10_des,
			'porcen_renta'  => $porcen_renta,
			'aguinaldo_no'  => $aguinaldo_no_grav,
			'total_no_grav' => $total_no_grav,
			'banco' 		=> $banco_des,
			'num_planilla'	=> $num_planilla,
			'lugar'			=> $lugar,		  // Lugar en el que se presentará la constancia de sueldo (TROQUELES)
			'prima_vacacion' => $prima_inn, 	 // Prima de vacación - 30% (ESPUMAR)
			'extra_inn'		=> $extra_inn,	 // Ingresos de horas extra diurnas y nocturnas (ESPUMAR)
			'salario_inn' 	=> $solo_salario, // Solo salario para constancia anual (ESPUMAR)
			'otros_inn'		=> $otros, 		 // Otros ingresos anuales (ESPUMAR)
			'afecto_isss'   => $afecto_isss,
			'afecto_afp'    => $afecto_afp,		//-- INGRESO AFECTO POR CADA DESCUENTO.
			'afecto_renta10' => $afecto_renta10,
			'afecto_renta'  => $afecto_renta,
			'otros_dss'		=> $otros_dss, 	// descuentos internos para renta anual (ESPUMAR)
			'det_ingresos'	=> $ingresos,
			'promedio_com' => $promedio_com, // Promedio únicamente de comisiones (EMI)
			'promedio_sin_com' => $promedio_sin_com, // Promedio sin comisiones (EMI)
			'actual_com' => $actual_com,
			'otrosdescuentosv' => $otrosdescv,
			'otrosdescuentosn' => $otrosdescn,
			'datos_const_salario_agrupa' => $constancia_salario_agrupador,
			'plaza_pps' => $plaza_pps,
			'carta_renta' => $carta_ingreso_renta
		);
		$this->load->library('pdf');
		//$html = $this->load->view('personal/reportes/plantillas_constancias', $data);
		//$formato = $this->gsatelite->get_parametro('SYS_FORMATO_CONSTANCIA');
		$data['tipo_salario'] = $tipo_salario;
		$emr = $this->tank_auth->get_empresa_id();
		$correo = $this->db->select('emr_correo')
			->from('emr_empresa')
			->where('emr_id', $emr)->get()->row();
		$data['correo'] = $correo->emr_correo;
		// Según el número indicado en el parametro se llama a la vista correspondiente a cada cliente, los cuáles son:
		// 1=Por defecto (SAT) 2=EMI 3=PROLINGUA 4=YLUFA 5=TROQUELES 6=ESPUMAR 7=INTERVISION 8=CENTRO CULTURAL 9=CAISA 
		$tipo_enc = $this->gsatelite->get_parametro('SYS_ENCABEZADO_CONSTANCIAS');
		if ($tipo_enc == 1) {
			$data['header'] = $this->load->view('reporte/header_cons', array('titulo' => "prueba1"), true);//header_utm
			$data['pie_pag'] = 1;
		} elseif ($tipo_enc == 2) {
			$data['header'] = "";
			$data['pie_pag'] = 1;
		} elseif ($tipo_enc == 3) {
			$data['header'] = $this->load->view('reporte/header_cons_sn_logo', array('titulo' => ""), true);
			$data['pie_pag'] = 0;
		} else {
			$data['header'] = $this->load->view('reporte/header_detalle_cons', array('titulo' => "prueba2"), true);
			$data['pie_pag'] = 0; // Si el encabezado tiene detalle no se coloca pie de página
		}
		$data['tipo_enc'] = $tipo_enc;
		$suc =  $cons_trabajo[0]['emp_id_suc'];
		$sucursal_nombre  = $this->gsatelite->get_tabla('suc_sucursal', array('suc_id' => $suc));
		$data['sucursal_x'] = $sucursal_nombre[0]['suc_nombre'];
		$tipo_descarga = $_POST['word_pdf'];		
		$data['tipo_descarga'] = $tipo_descarga;
		$existe_file = $this->gsatelite->get_tabla("fre_formato_constancia_empleado", array("fre_estado" => 1, "fre_id_tpo" => $tipo, "fre_archivo IS NOT NULL" => null));
		// var_dump($data);die();
		if ($tipo_descarga > 0) {
			$pdf = $this->pdf;
			if (count($existe_file) > 0) {
				$file = $existe_file[0]['fre_archivo'];
				$html = $this->load->view("personal/reportes/$file", $data, true);
			} else {
				$html = $this->load->view('personal/reportes/constancias2', $data, true);
			}			
        	$pdf->setPrintFooter(false);
			$pdf->setPrintFooter(false);
			$pdf->addPagina($html, "P");
			$pdf->boletaPDF('I');
		} else {
			$html = $this->load->view('personal/reportes/constancias2', $data);
		}		
		// var_dump($html);die();
		// var_dump($data);die();
		// if($formato!=''){
		// 	$html = $this->load->view('personal/reportes/constancias'.$formato, $data);
		// }else{
		// 	$html = $this->load->view('personal/reportes/constancias1', $data); // Por defecto SAT
		// }
		// $html = $this->load->view('personal/reportes/constancias2', $data);
	}

	function plantillas_constancias()
	{
		$this->_cargarvista();
	}

	/**
	 * Consultas:consulta de registros
	 * @author René Castaneda
	 */
	function reporte_empleado()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {

			if ($_POST) {
				$tipo = $this->input->post('tipo_accion');
				$filtro = $this->input->post('filtro_hidden');
				$valor_filtro = $this->input->post('filtro_valor_hidden');
				$colum_report = $this->input->post('colums');
				//		echo var_dump($colum_report);
				//		echo count($colum_report); die();
				$columnas = array();
				for ($i = 0; $i < count($colum_report); $i++) {
					$columnas[] = $colum_report[$i];
				}

				if ($tipo == 'pdf') {
					//imprimir pdf
					$data["consulta"] = $this->filtro_reporte_empleado($filtro, $valor_filtro, false, true);
					$data["columnas_reporte"] = $columnas;
					$data["columnas"] = $colum_report;
					$html = $this->load->view('reporte/header', array('titulo' => 'Empleadas/os'), true);
					$html .= $this->load->view('personal/reportes/reporte_empleado_pdf', $data, true);

					$this->load->library('Pdf'); //libreria pdf
					$this->pdf->setPrintFooter(true);
					$this->pdf->makePDF($html, 'L');
				}
				if ($tipo == 'excel') {
					//exportar excel
					$data["consulta"] = $this->filtro_reporte_empleado($filtro, $valor_filtro, false, true);
					$data["columnas_reporte"] = $columnas;
					$data["columnas"] = $colum_report;
					$this->load->view('personal/reportes/reporte_empleado_excel', $data);
				}
			} else {
				$select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', null, null, '', 'suc_id', true);
				$data["select_emp_id_suc"] = str_replace('<option value="0">Seleccione</option>', '', $select);
				$select = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', null, null, '', 'are_id', true);
				$data["select_emp_id_are"] = str_replace('<option value="0">Seleccione</option>', '', $select);
				$select = $this->gsatelite->get_dropdown('pto_puesto', '{pto_nombre}', '', array('pto_estado' => 1), null, '', 'pto_id', true);
				$data["select_emp_id_pto"] = str_replace('<option value="0">Seleccione</option>', '', $select);
				$select = $this->gsatelite->get_dropdown('gen_genero', '{gen_nombre}', '', null, null, '', 'gen_id', true);
				$data["select_emp_id_gen"] = str_replace('<option value="0">Seleccione</option>', '', $select);
				$select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, null, '', 'tpl_id', true);
				$data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '', $select);

				$data["titulo_personal"] = "REPORTE DE EMPLEADAS/OS";
				$this->_cargarvista($data, null);
			}
		}
	}
	/* René Castaneda*/
	function filtro_reporte_empleado($filtro = null, $valor = null, $retorna_html = false, $retornarconsulta = false)
	{
		$vista = "filtro_reporte_empleado";
		$noes_reporte = $this->input->post('noesreporte');
		if ($noes_reporte == 1) {
			$vista = "filtro_consulta_empleado";
			$this->db->where('emp_empleado.emp_estado', 1);
			$this->db->where('tpl_tipo_planilla.tpl_id', $this->input->post('id_tipo_planilla'));
		}

		if ($filtro == null and $valor == null) {
			$filtro = $this->input->post('filtro');
			$valor = $this->input->post('valor');
		}
		$where = null;
		if ($filtro == 'emp_fecha_contrato') {
			$f = explode('#', $valor);
			$where = array('date_format(' . $filtro . ',"%Y-%m-%d") >=' => date('Y-m-d', strtotime($f[0])), 'date_format(' . $filtro . ',"%Y-%m-%d") <=' => date('Y-m-d', strtotime($f[1])));
		} elseif ($filtro == 'emp_nombre' or $filtro == 'emp_apellido') {
			$this->db->like("$filtro", trim($valor));
		} else {
			$where = array("$filtro" => trim($valor));
		}
		$consulta = $this->planilla_model->get_empleados_reporte($where);
		$data["consulta"] = $consulta;
		$html = $this->load->view("personal/reportes/$vista", $data, true);
		//$html='<script>$(document).ready( function($){ $("#check_emp_apellido").iButton();  });</script><input type="checkbox" id="check_emp_apellido" value="emp_apellido" name="colums[]" />';
		if ($retorna_html) {
			return $html;
		} elseif ($retornarconsulta) {
			return $consulta;
		} else {
			echo json_encode(array('resultado' => $html));
		}
	}


	/**
	 *@author Edith Herrera
	 */
	public function reporte_afp()
	{
		satelite_validar();
		$emr_id = $this->tank_auth->get_empresa_id();
		$this->db->where(array('dtp_id_tdc' => $this->gsatelite->get_parametro('DESCUENTO_AFP'), 'tpl_id_emr' => $emr_id));
		$this->db->join('dtp_descuentoxtipo_planilla', 'dtp_id_tpl = tpl_id');
		$data['tipo_planilla'] = $this->gsatelite->get_tabla('tpl_tipo_planilla');
		$select = $this->gsatelite->get_dropdown('afp_afp', '{afp_nombre}', '', null, null, '', 'afp_id', true);
		$data['afp'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
		$data['titulo_personal'] = "Reporte AFP";
		$this->_cargarvista(null, $data);
	}

	public function planilla_afp_excel()
	{
		// print_r($_POST);die();
		satelite_validar();
		$id_descuento_afp = ($this->gsatelite->get_parametro('DESCUENTO_AFP') > 0) ? $this->gsatelite->get_parametro('DESCUENTO_AFP') : null;
		$nit = ($this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT') > 0) ? $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT') : null;
		$dui = ($this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI') > 0) ? $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI') : null;

		// Variables provenientes de POST
		// $tipo_planilla = $this->input->post('tipo_planilla');
		// $periodo 	  = $this->input->post('periodo');
		$txtFechaInicio = $this->input->post("txtFechaInicio");
		$txtFechaFin    = $this->input->post("txtFechaFin");
		$slcAfp    		= $this->input->post("slcAfp");
		// Declaracion de variables
		$where 	 = array();
		$groupby = array();
		$orderby = array();

		if ($txtFechaInicio  != "" && $txtFechaFin != "") {
			$encabezado = "<table><tr><td colspan='4'><h3>" . $this->gsatelite->get_parametro('SYS_EMPRESA') . "</h3></td></tr><tr><td colspan='4'>Generación de Planilla</td></tr>";
			$txtFechaInicio = formatear_fecha('Y-m-d', $txtFechaInicio);
			$txtFechaFin    = formatear_fecha('Y-m-d', $txtFechaFin);
			$where["pla_fecha_corte >= '" . $txtFechaInicio . "' AND pla_fecha_corte <= '" . $txtFechaFin . "'"] = null;
			// $where["afp_codigo IS NOT NULL"] = null;
			$where["ddd_id_tdc"] = $id_descuento_afp;
			if ($slcAfp > 0) {
				$where['afp_id'] = $slcAfp;
			}
			$groupby = 'emp_id';
			$orderby = 'emp_id_are, ddd_id_pla';
			// $data['consulta'] = $this->planilla_model->get_reporte_afp($where, $groupby, $orderby);
			$data['consulta'] = $this->planilla_model->get_reporte_afp2($where, $txtFechaInicio, $txtFechaFin);
			// var_dump($this->db->last_query());die();
			$data['tipo_doc'] = $this->gsatelite->get_campo('tde_tipo_documento', 'tde_nombre', array('tde_id' => $dui));
			$data['esreporte'] = true;
			$max_dias = ($this->gsatelite->get_intervalo_dias($txtFechaInicio, $txtFechaFin) + 1);
			$data['max_dias'] = ($max_dias < $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES', 30)) ? $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES', 30) : $max_dias; //CASO FEBRERO
			$data['fecha_ini'] = $txtFechaInicio;
			$data['fecha_fin'] = $txtFechaFin;
			ob_end_clean();
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header("Content-Disposition: attachment;filename=reporte_afp.xls");
			header("Pragma: no-cache");
			header("Expires: 0");
			// $des = $this->gsatelite->get_registro('tdc_tipo_descuento','tdc_id',$id_descuento);
			// $data['titulo_reporte_excel'] = "<h3>Reporte de descuento $des->tdc_nombre</h3>";
			$data['es_excel'] = true;
			$this->load->view("personal/reportes/planilla_afp_excel", $data, FALSE);
		}
	}

	public function planilla_unica($flag = null)
	{
		satelite_validar();
		if ($_POST) {
			$tipo_rep = $this->input->post('tipo_rep');
			$periodo = $this->input->post('fecha_filtro');
			$fini = formatear_fecha('Y-m-d', $periodo);
			$ffin = formatear_fecha('Y-m-t', $periodo);
			$max_dias = ($this->gsatelite->get_intervalo_dias($fini, $ffin) + 1);
			$dias_par = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES', 30);
			$where["pla_fecha_inicio >= "] = $fini;
			$where["pla_fecha_fin <= "] = $ffin;
			$data['consulta'] = $this->planilla_model->get_detalles_plan_unica($where, $fini, $ffin);
			// var_dump($this->db->last_query());
			$data['max_dias'] = ($max_dias < $dias_par) ? $dias_par : $max_dias;
			$data['fecha_ini'] = $fini;
			$data['fecha_fin'] = $ffin;
			$data['tipo_reporte'] = $tipo_rep;
			$html = $this->load->view("personal/reportes/detalle_planilla_unica", $data, true);
			if ($flag) {
				echo json_encode(array('html' => $html, 'filas' => count($data['consulta'])));
			} else {
				switch ($tipo_rep) {
					case 'pdf':
						$head = $this->load->view('reporte/header', array('titulo' => 'Planilla Unica Previsional', 'solotitulo' => true), true);
						$this->pdf->makePDF($head . $html, 'L');
						break;
					case 'csv':
						$linea = array();
						$perio = formatear_fecha('mY', $fini);
						$nit_epr = $this->gsatelite->get_parametro('SYS_NIT');
						$iss_epr = $this->gsatelite->get_parametro('SYS_ISSS_PATRONAL');
						$sal_min = $this->gsatelite->get_parametro('MONTO_SALARIO_MINIMO');
						$hora_di = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA', 8);
						$tdc_dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI', 0);
						$max_dia = ($this->gsatelite->get_intervalo_dias($fini, $ffin) + 1); //SI MES DE 31 O 28
						$dia_par = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES', 30); //SI MES DE 31 O 28
						$registros = $this->planilla_model->get_detalles_plan_unica($where, $fini, $ffin);
						// var_dump($this->db->last_query());die();
						foreach ($registros as $key => $value) {
							$obs2 = '';
							$obs1 = 1; // 01 Sin cambios con respecto al mes anterior. 
							if (formatear_fecha('Ymd', $value['emp_fecha_contrato']) >= formatear_fecha('Ymd', $fini) && formatear_fecha('Ymd', $value['emp_fecha_contrato']) <= formatear_fecha('Ymd', $ffin) && trim($value['emp_fecha_retiro']) == '') {
								// 08 Ingreso o reingreso de un trabajador 
								$obs1 = 8;
							}
							if (trim($value['emp_fecha_retiro']) != '' && formatear_fecha('Ymd', $value['emp_fecha_retiro']) >= formatear_fecha('Ymd', $fini) && formatear_fecha('Ymd', $value['emp_fecha_retiro']) <= formatear_fecha('Ymd', $ffin)) {
								// 07 Retiro del trabajador de la empresa
								if ($obs1 == 8) {
									$obs2 = 7; //En el mismo mes entro y se retiro
								} else {
									$obs1 = 7;
								}
							}
							if ($value['adicional'] > 0 && $value['vacaciones'] == 0 && $value['prima_vacaciones'] == 0) {
								// 02 Pagos adicionales unicamente
								if ($obs1 > 1) {
									if ($obs2 != 7) {
										$obs2 = 2;
									}
								} else {
									$obs1 = 2;
								}
							}
							if (($value['vacaciones'] > 0 || $value['prima_vacaciones'] > 0) && $value['adicional'] == 0) {
								// 09 Vacaciones unicamente 
								if ($obs1 > 1) {
									if ($obs2 != 8) {
										$obs2 = 9;
									}
								} else {
									$obs1 = 9;
								}
							}
							if (($value['vacaciones'] > 0 || $value['prima_vacaciones'] > 0) && $value['adicional'] > 0) {
								// 10 Vacaciones más pagos adicionales
								if ($obs1 > 1) {
									if ($obs2 != 8) {
										$obs2 = 10;
									}
								} else {
									$obs1 = 10;
								}
							}
							if ($value['emp_salario'] < $sal_min) {
								// 03 Aprendices (empleados con estatus de aprendices generalmente cobran solo la mitad o un porcentaje del salario normal)
								if ($obs1 > 1) {
									if ($obs2 != 7) {
										$obs2 = 3;
									}
								} else {
									$obs1 = 3;
								}
							}
							if ($value['emp_es_jubilado'] > 0) {
								// 04 Pensionado, si la persona no está pensionada y se consigna este código, se generará error (caso a la inversaa tambien) 
								if ($obs1 == 7 || $obs1 == 8) {
									$obs2 = 4;
								} else {
									$obs1 = 4;
								}
							}
							if ($value['incapacidades'] > 0) {
								// 06 Incapacidades
								if ($obs1 > 1) {
									if ($obs2 != 7 && $obs2 != 9 && $obs2 != 4) {
										$obs2 = 6;
									}
								} else {
									$obs1 = 6;
								}
							}
							if ($value['permiso_sin_goce'] > 0) {
								// 05 Licencias (Permisos sin goce de salario 
								if ($obs1 > 1) {
									if ($obs2 != 7 && $obs2 != 9 && $obs2 != 4) {
										$obs2 = 5;
									}
								} else {
									$obs1 = 5;
								}
							}
							if ($value['max_frecuencia'] < 15) {
								// 11 Planilla catorcenales y semanales fraccionadas (empleados con las modalidades de pago semanal y catorcenales)
								if ($obs1 > 1) {
									if ($obs2 != 7 && $obs2 != 9 && $obs2 != 4) {
										$obs2 = 11;
									}
								} else {
									$obs1 = 11;
								}
							}
							if (trim($value['afp_codigo']) == "") {
								// 13 Cotizante al IPSFA (Actualmente IPSFA se tienen como otra AFP pero es la unica que no tienen codigo)
								if ($obs1 > 1) {
									if ($obs2 != 7 && $obs2 != 9 && $obs2 != 4) {
										$obs2 = 13;
									}
								} else {
									$obs1 = 13;
								}
							}
							$linea_texto = array();
							$d = explode('##', $value['doc_emp']);
							$n = explode(' ', trim($value['emp_nombre']));
							$a = explode(' ', trim($value['emp_apellido']));
							// var_dump(isset($a[1]) && mb_strtolower(trim($a[1]), 'UTF-8') == 'de'	);die();
							if (isset($n[1]) && (mb_strtolower(trim($n[1]), 'UTF-8') == 'de' || mb_strtolower(trim($n[1]), 'UTF-8') == 'del') && isset($n[2])) {
								$sgnm = ucfirst(mb_strtolower(trim($n[1]), 'UTF-8')) . ' ' . ucfirst(mb_strtolower(trim($n[2]), 'UTF-8'));
							} else {
								$sgnm = (isset($n[1])) ? ucfirst(mb_strtolower(trim($n[1]), 'UTF-8')) : '';
							}
							if (isset($a[1]) && mb_strtolower(trim($a[1]), 'UTF-8') == 'de') {
								if (trim($value['ape_casada']) != '') {
									$sgap = '';
									$apcs = ucfirst(mb_strtolower(trim($value['ape_casada']), 'UTF-8'));
								} else {
									$apcs = '';
									$sgap = (isset($a[2])) ? ucfirst(mb_strtolower(trim($a[1]), 'UTF-8')) . ' ' . ucfirst(mb_strtolower(trim($a[2]), 'UTF-8')) : ucfirst(mb_strtolower(trim($a[1]), 'UTF-8'));
								}
							} else {
								$apcs = '';
								$sgap = (isset($a[2])) ? ucfirst(mb_strtolower(trim($a[1]), 'UTF-8')) . ' ' . ucfirst(mb_strtolower(trim($a[2]), 'UTF-8')) : ucfirst(mb_strtolower(trim($a[1]), 'UTF-8'));
							}
							$dias_max = ($max_dia < $dia_par) ? $dia_par : $max_dia; //DE MONENTO NO SE USO
							$dt = (($value['dias_trabajados'] - $value['incapacidades'] - $value['permiso_sin_goce']) < 0) ? 0 : ($value['dias_trabajados'] - $value['incapacidades'] - $value['permiso_sin_goce']);
							$linea_texto[] = substr(str_replace('-', '', $nit_epr), 0, 14);
							$linea_texto[] = substr(str_replace('-', '', $iss_epr), 0, 9);
							$linea_texto[] = $perio;
							$linea_texto[] = str_pad(1, 3, " ", STR_PAD_LEFT);
							$linea_texto[] = substr(str_replace('-', '', $d[2]), 0, 20);
							$linea_texto[] = ($d[0] == $tdc_dui) ? '01' : '';
							$linea_texto[] = $value['emp_seguro'];
							$linea_texto[] = $value['afp_codigo'];
							$linea_texto[] = mb_substr(ucfirst(mb_strtolower(trim($n[0]), 'UTF-8')), 0, 40, 'UTF-8');
							$linea_texto[] = mb_substr($sgnm, 0, 40, 'UTF-8');
							$linea_texto[] = mb_substr(ucfirst(mb_strtolower(trim($a[0]), 'UTF-8')), 0, 40, 'UTF-8');
							$linea_texto[] = mb_substr($sgap, 0, 40, 'UTF-8');
							$linea_texto[] = mb_substr(ucfirst(mb_strtolower($apcs, 'UTF-8')), 0, 40, 'UTF-8');
							$linea_texto[] = substr(number_format($value['sal_dev_no_vac'], 2), 0, 9);
							$linea_texto[] = substr(number_format($value['adicional'], 2), 0, 9);
							$linea_texto[] = substr(number_format(($value['vacaciones'] + $value['prima_vacaciones']), 2), 0, 9);
							$linea_texto[] = substr($dt, 0, 2);
							$linea_texto[] = substr($hora_di, 0, 2);
							$linea_texto[] = substr($value['vaca_dias'], 0, 2);
							$linea_texto[] = str_pad($obs1, 2, "0", STR_PAD_LEFT);
							$linea_texto[] = ($obs2 > 0) ? str_pad($obs2, 2, "0", STR_PAD_LEFT) : '';
							$linea[] = trim(implode(',', $linea_texto));
						}
						$ruta_carga = 'uploads/txt_planilla/';
						if (file_exists("uploads/txt_planilla/planilla_unica_$perio.csv")) {
							unlink("uploads/txt_planilla/planilla_unica_$perio.csv");
						}
						$ruta_completa  = $ruta_carga . "planilla_unica_$perio.csv";
						$separador      = chr(13) . chr(10);
						$texto_completo = $separador . implode($separador, $linea);
						// var_dump($texto_completo);die();
						$archivo        = fopen($ruta_completa, "w+") or die("Sin permisos de escritura en el servidor");
						$texto_completo = trim($texto_completo);
						fputs($archivo, $texto_completo);
						fclose($archivo);
						if (ob_get_contents()) ob_end_clean();
						header("Content-Type: text/html; charset=utf-8");
						header("Content-Type: application/octet-stream");
						header("Content-Disposition: attachment; filename=planilla_unica_$perio.csv");
						readfile("uploads/txt_planilla/planilla_unica_$perio.csv");
						die();
						break;
					default:
						// EXCEL
						echo $html;
						break;
				}
			}
		} else {
			$data['permisos'] = $this->gsatelite->get_permisos_opcion();
			$data['titulo_personal'] = "Revisión mensual";
			$this->_cargarvista($data);
		}
	}

	/**
	 * Esta funcionalidad se retomado del modulo de contabilidad y al realizar un cambio
	 * aqui es necesario hacerlo en ese otro lugar para que los cambios se vean reflejados
	 **/
	function listado_partida_planilla()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
			$this->db->join('tpd_tipo_partida', 'tpd_id=pct_id_tpd');
			$data['id_ptd'] = $this->gsatelite->get_tabla('pct_partida_contable');

			$tipo = $this->gsatelite->get_dropdown('tpd_tipo_partida', '{tpd_nombre} ', '', null, null, '', 'tpd_id', true);
			$data["tipo"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo);
			$data["titulo_personal"] = "Listado de partidas";

			$this->_cargarvista($data);
		}
	}

	/**
	 * Esta funcionalidad se retomado del modulo de contabilidad y al realizar un cambio
	 * aqui es necesario hacerlo en ese otro lugar para que los cambios se vean reflejados
	 **/
	function consultar_listado_partidas()
	{
		$fecha_ini = $this->input->post('fecha_ini');
		$fecha_fin = $this->input->post('fecha_fin');
		$tipo = $this->input->post('tipo');

		$where = null;
		if ($fecha_ini != '' && $fecha_fin != '') {
			$fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
			$fecha_fn = date('Y-m-d', strtotime($fecha_fin));
			$where = array('date_format(pct_fecha, "%Y-%m-%d") >=' => $fecha_inicio, 'date_format(pct_fecha, "%Y-%m-%d") <=' => $fecha_fn);
		}
		if ($tipo > 0) {
			$where['tpd_id'] = $tipo;
		}
		if ($fecha_ini == '' && $fecha_fin == '' && $tipo == '') {
			$where = null;
		}
		$this->db->where($where);
		$this->db->join('tpd_tipo_partida', 'tpd_id=pct_id_tpd');
		$partidas = $this->gsatelite->get_tabla('pct_partida_contable');
		$detalles = $this->contabilidad_model->listado_partida($where);
		$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

		$cadena = '';

		if (!empty($detalles) && !empty($partidas)) {
			foreach ($partidas as $key) {
				$cadena .= '<tr>
				                <td colspan="5"><span style="margin-left:2%"><strong>' . $key['tpd_nombre'] . " #: " . $key['pct_codigo'] . '</strong></span> 
				                	<span style="margin-left:20%"><strong>' . date('d-m-Y', strtotime($key['pct_fecha'])) . '</strong></span>
				                </td>
				              </tr>';
				$cadena .= '<tr >
                                <th style="border: 1px solid #000; border-right: none;">Cuenta</th>
                                <th style="border: 1px solid #000; border-left: none; border-right: none;">Concepto</th>
                                <th style="border: 1px solid #000; border-left: none; border-right: none;">Parciales</th>
                                <th style="border: 1px solid #000; border-left: none; border-right: none;">Debe (' . $simbolo . ')</th>
                                <th style="border: 1px solid #000; border-left: none;">Haber (' . $simbolo . ')</th>
                                </tr>';
				/*                 * ********************************** CUENTAS PADRE ******************************************* */

				$detxpartida = $this->contabilidad_model->listado_partida(array('pct_id' => $key['pct_id']), 1);

				foreach ($detxpartida as $deta) {
					$cadena .= '<tr>
						                        <td style="border: none;font-weight:bold;">' . $deta['cnt_cuenta'] . '</td>
						                        <td style="border: none;font-weight:bold;">' . $deta['cnt_nombre'] . '</td>
						                        <td style="text-align:right; border: none;"></td>
						                        <td style="text-align:right; border: none;">' . $deta['debe'] . '</td>
						                        <td style="text-align:right; border: none;">' . $deta['haber'] . '</td>
						                      </tr>';

					$cadena .= $this->get_detalles_parcial($key['pct_id'], $deta['cnt_cuenta']);
				}
				/*                 * *********************************************************************************************** */

				$cadena .= '<tr>
	                            <td colspan="3" style="text-align:right; border: none;"><strong>Totales:</strong></td>
	                            <td style="text-align:right; border: none; border-top:1px solid #000;"><strong>' . $key['pct_total'] . '</strong></td>
	                            <td style="text-align:right;  border: none; border-top:1px solid #000;"><strong>' . $key['pct_total'] . '</strong></td>
	                          </tr>
	                          <tr>
	                            <td colspan="5" style="border: none;">
	                                <span><strong>Concepto:</strong></span><br>
	                                <span style="margin-left:3%">' . $key['pct_concepto'] . '</span>
	                            </td>
	                          </tr>';
			}
		} else {
			$cadena .= '<tr>
            				<td colspan="4" style="text-align:center"> No se encontraron resultados</td>
            			  </tr>';
		}

		echo json_encode($cadena);
	}

	/**
	 * Esta funcionalidad se retomado del modulo de contabilidad y al realizar un cambio
	 * aqui es necesario hacerlo en ese otro lugar para que los cambios se vean reflejados
	 **/
	function get_detalles_parcial($partida, $cuenta)
	{
		$where = array();
		$where['pct_id'] = $partida;
		$where['cnt_cuenta'] = $cuenta;
		$detalles = $this->contabilidad_model->listado_partida($where);

		$cadena = '';
		foreach ($detalles as $det) {
			if ($det['dpc_debe'] > 0) {
				$monto = $det['dpc_debe'];
			} else {
				$monto = $det['dpc_haber'];
			}

			$cadena .= '<tr>
			                        <td style="border: none;"></td>
			                        <td style="border: none;">' . $det['dpc_concepto'] . '</td>
			                        <td style="text-align:right; border: none;">' . $monto . '</td>
			                        <td style="text-align:right; border: none;"></td>
			                        <td style="text-align:right; border: none;"></td>
			                      </tr>';
		}
		return $cadena;
	}

	/**
	 *@author René Castaneda
	 *@since 19-02-2018
	 *@return Select con las areas de segun sucursal-empleado
	 */
	public function get_area_empleado()
	{
		satelite_validar();
		$id_sucursal = $this->input->post('suc_id');
		$area = $this->input->post('area');
		// var_dump($_POST);die();

		$id_area = null;
		$where = null;
		if ($id_sucursal > 0) {
			$where['emp_id_suc'] = $id_sucursal;
		}

		$this->db->join('emp_empleado', 'emp_id_are=are_id');
		$this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
		$this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda 02-03-2018  
		$this->db->group_by('are_id');
		$select = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', $where, null, '', 'are_id', true);

		if ($area != null) {
			$id_area = $this->planilla_model->get_areaXsucursal('SUC.suc_id = ' . $id_sucursal . ' AND ARE.are_id = ' . $area . '');
			// var_dump($this->db->last_query());die();
			// print_r($id_area);die();
		}

		$data["select_area"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
		$data['area'] = count($id_area);
		die(json_encode($data));
	}

	/**
	 * Descripción:
	 * Función para obtener la renta coplementaria 
	 * según la tabla de retención mensual
	 * @author Edith Herrera - Grupo Satélite
	 * @since  2018-07-17
	 * @param  ninguno
	 * @return Registros de renta complementaria por empleado.
	 */
	function renta_complementaria()
	{
		satelite_validar();
		if ($this->input->post()) {
			$tipo_reporte = ($this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';
			if ($tipo_reporte != '') {
				$anio_per = $this->input->post('filtro_year');
				$tipo_plan = $this->input->post('filtro_tipo');
				$recalculo = $this->input->post('filtro_recalculo');
				$empleados = $this->input->post('filtro_empleado');
			} else {
				$anio_per = $this->input->post('year');
				$tipo_plan = $this->input->post('tipo');
				$recalculo = $this->input->post('recalculo');
				$empleados = $this->input->post('empleado');
			}
			/***************************** CONSULTA *****************************************/
			$isr = $this->gsatelite->get_parametro('DESCUENTO_ISR');
			if (!($isr > 0)) {
				echo json_encode(array('mensaje' => 'Se requiere configuración de parámetro del <b> impuesto sobre la renta</b>', 'error' => 1));
				die();
			}
			$tipo = $where = null;
			$inicio = formatear_fecha('Y-m-d', $anio_per . '-01-01');
			$fin = ($recalculo > 1) ? formatear_fecha('Y-m-d', $anio_per . '-12-31') : formatear_fecha('Y-m-d', $anio_per . '-06-30');
			$where['pla_fecha_inicio >='] = formatear_fecha('Y-m-d', $inicio);
			$where['pla_fecha_fin <='] = formatear_fecha('Y-m-d', $fin);
			if ($tipo_plan != '') {
				$where['pla_id_tpl'] = $tipo_plan;
				$tipo = $tipo_plan;
			}
			if ($empleados != '') {
				$where['emp_id'] = $empleados;
			}
			$detalles = $this->planilla_model->get_renta_complementaria(formatear_fecha('Y-m-d', $inicio), formatear_fecha('Y-m-d', $fin), $where, $tipo);
			// $data['detalle'] = $detalle = $this->planilla_model->get_isr_planilla($where, null, null, formatear_fecha('Y-m-d', $inicio), formatear_fecha('Y-m-d', $fin));
			$data['detalle'] = $detalles;
			/****************************************************************************************************** */
			$data['header'] = $this->load->view('reporte/header',  array('titulo' => 'Renta complementaria'), true);
			$data['tipo_reporte'] = $tipo_reporte;
			if ($tipo_reporte != '') {
				switch ($tipo_reporte) {
					case 'pdf':
						$data['titulo'] = 'Renta complementaria';
						$html = $this->load->view('personal/reportes/export_renta_complementaria', $data, true);
						$this->pdf->makePdf($html, 'L', 'conteos', 'Letter');
						break;
					case 'excel':
						$filename = 'rpt_renta_complementaria' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
						$data['titulo'] = ' renta complementaria';
						$data['filename'] = $filename;
						$data['excel'] = 1;
						$html = $this->load->view('personal/reportes/export_renta_complementaria', $data, true);
						echo $html;
						break;
				}
			} else {
				$html = $this->load->view('personal/reportes/detalle_renta_complementaria', $data, true);
				echo json_encode(array('resultado' => $html, 'anio' => $anio_per, 'tipo_planilla' => $tipo_plan, 'recalculo' => $recalculo, 'empleado' => $empleados, 'error' => 0));
			}
		} else {
			$planillas = '<option value=""></option>';
			$tipo_plan = $this->planilla_model->get_tipos_planillas_isr();
			if (count($tipo_plan) > 0) {
				foreach ($tipo_plan as $key => $value) {
					$planillas .= '<option value="' . $value['tpl_id'] . '">' . $value['tpl_prefijo'] . '-' . $value['tpl_nombre'] .  '</option>';
				}
			}
			$empleado = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo}-{emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
			$data['planillas'] = $planillas;
			$data['empleados'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $empleado);
			$data["titulo_personal"] = "Renta complementaria";
			$this->_cargarvista($data);
		}
	}


	/**
	 * Descripción:
	 * Función para obtener la renta por mes
	 * @author Edith Herrera - Grupo Satélite
	 * @since  2018-07-17
	 * @param  ninguno
	 * @return Registros de renta por mes de cada empleado.
	 */
	/*function rpt_renta(){
		satelite_validar();
        if ($this->input->post()) {
            $tipo_reporte = ($this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';

            if ($tipo_reporte != null) {
                $year = ($this->input->post('filtro_year') > 0) ? $this->input->post('filtro_year') : null;
                $empleado = ($this->input->post('filtro_empleado') > 0) ? $this->input->post('filtro_empleado') : null;
            } else {
                $year = $this->input->post('year');
                $empleado = $this->input->post('empleado');
            }

           
				$where = null;
				
				$isr = $this->gsatelite->get_parametro('DESCUENTO_ISR');

				if($isr>0){
					$where['ddd_id_tdc']=$isr;
				}else{
					echo json_encode(array('mensaje'=>'Se requiere configuración de parámetro del <b> impuesto sobre la renta</b>', 'error'=>1));
					die();

				}
		    	
		    	if ($year!='') {
		    		$where['DATE_FORMAT(pla_fecha_inicio,"%Y")']=$year;
				}
				
		    	if ($empleado>0) {
		    		$where['emp_id']=$empleado;
				}

				$data['where'] = $where;

				$data['empleados'] = $this->planilla_model->get_isr_planilla($where, 'emp_id', $year);

            
            $data['header'] = $this->load->view('reporte/header',  array('titulo' => 'Renta'), true);
           
            $data['tipo_reporte'] = $tipo_reporte;
            if ($tipo_reporte != '') {
                switch ($tipo_reporte) {
                    case 'pdf':
                        $data['titulo'] = 'Renta';
                        $html = $this->load->view('personal/reportes/export_renta', $data, true);
                        $this->pdf->makePdf($html, 'L', 'conteos', 'A4');
                        break;
                    case 'excel':
                        $filename = 'rpt_renta' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                        $data['titulo'] = ' renta';
                        $data['filename'] = $filename;
                        $data['excel'] = 1;

                        $html = $this->load->view('personal/reportes/export_renta', $data, true);
                        echo $html;
                        break;
                }
            }else{
                $html = $this->load->view('personal/reportes/detalle_renta', $data, true);
                echo json_encode(array('resultado' => $html, 'year'=>$year, 'empleado'=>$empleado, 'error'=>0));
            }
        }else{
        	$fecha = date('Y-m-d');
        	$data['ndias'] = date( "t", strtotime( $fecha ));

        	$religion_drop = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', null, null, '', 'emp_id', true);
            $data['empleado'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $religion_drop);

            $data["titulo_personal"] ="Renta";
            $this->_cargarvista($data);
        }
	}*/

	/**
	 * Descripción:
	 * Función para obtener los descuentos, según el tipo seleccionado. 
	 * @author Edith Herrera - Grupo Satélite
	 * @since  2018-07-23
	 * @param  ninguno
	 * @return Registros descuentos por cada empleado.
	 */
	function rpt_descuentos_mensuales()
	{
		satelite_validar();
		if ($this->input->post()) {
			$tipo_reporte = ($this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';
			if ($tipo_reporte != null) {
				$inicio = ($this->input->post('filtro_inicio') != '') ? $this->input->post('filtro_inicio') : null;
				$fin = ($this->input->post('filtro_fin') != '') ? $this->input->post('filtro_fin') : null;
				$descuento = ($this->input->post('filtro_descuento') != "") ? $this->input->post('filtro_descuento') : "";
				$empleado = ($this->input->post('filtro_empleado') > 0) ? $this->input->post('filtro_empleado') : null;
			} else {
				$inicio = $this->input->post('inicio');
				$fin = $this->input->post('fin');
				$descuento = $this->input->post('descuento');
				$empleado = $this->input->post('empleado');
			}
			$where = array();
			if ($inicio != '') {
				$where['DATE_FORMAT(pla_fecha_inicio,"%Y-%m-%d") >= '] = date('Y-m-d', strtotime($inicio));
				$inicio = date('Y-m-d', strtotime($inicio));
			}
			if ($fin != '') {
				$where['DATE_FORMAT(pla_fecha_fin,"%Y-%m-%d") <= '] = date('Y-m-d', strtotime($fin));
				$fin = date('Y-m-d', strtotime($fin));
			}
			if ($descuento != "") {
				$where["tdc_id IN ($descuento)"] = null;
			}
			if ($empleado > 0) {
				$where['emp_id'] = $empleado;
			}
			$data['registros'] = $this->planilla_model->get_descuentos_empleado($inicio, $fin, $where);
			$data['header'] = $this->load->view('reporte/header',  array('titulo' => 'Descuentos', 'subtitulo' => 'Del ' . formatear_fecha('d-m-Y', $inicio) . ' al ' . formatear_fecha('d-m-Y', $fin)), true);
			$data['tipo_reporte'] = $tipo_reporte;
			if ($tipo_reporte != '') {
				switch ($tipo_reporte) {
					case 'pdf':
						$data['titulo'] = 'Descuentos';
						$html = $this->load->view('personal/reportes/rpt_descuentos_export', $data, true);
						$this->pdf->makePdf($html, 'L', 'conteos', 'Letter');
						break;
					case 'excel':
						$filename = 'rpt_descuentos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
						$data['titulo'] = ' Reporte de descuentos';
						if ($inicio != "" && $fin != "") {
							$data['subtitulo'] = 'Del ' . formatear_fecha('d-m-Y', $inicio) . ' al ' . formatear_fecha('d-m-Y', $fin);
						}
						$data['filename'] = $filename;
						$data['excel'] = 1;
						$html = $this->load->view('personal/reportes/rpt_descuentos_export', $data, true);
						echo $html;
						break;
				}
			} else {
				$html = $this->load->view('personal/reportes/detalle_desc_mensual', $data, true);
				echo json_encode(array('resultado' => $html, 'inicio' => $inicio, 'fin' => $fin, 'descuento' => $descuento, 'empleado' => $empleado));
			}
		} else {
			$fecha = date('Y-m-d');
			$data['ndias'] = date("t", strtotime($fecha));
			$religion_drop = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', null, null, '', 'emp_id', true);
			$data['empleado'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $religion_drop);
			$tipo_desc = $this->gsatelite->get_dropdown('tdc_tipo_descuento', '{tdc_nombre}', '', null, null, '', 'tdc_id', true);
			$data['descuentos'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $tipo_desc);
			$data["titulo_personal"] = "Descuentos mensual";
			$this->_cargarvista($data);
		}
	}

	/**
	 *@author Raul E.
	 */
	function rpt_ingresos_mensuales($flag = null)
	{
		satelite_validar();
		if ($_POST) {
			$fecha_ini = $this->input->post('fecha_ini');
			$fecha_fin = $this->input->post('fecha_fin');
			$tipo_ingr = $this->input->post('tipo_ingr');
			$filt_empl = $this->input->post('filt_empl');
			$reporte = $this->input->post('tipo_reporte');
			$where = array();
			if ($fecha_ini != '') {
				$where['pla_fecha_inicio >= '] = formatear_fecha('Y-m-d', $fecha_ini);
			}
			if ($fecha_fin != '') {
				$where['pla_fecha_fin <= '] = formatear_fecha('Y-m-d', $fecha_fin);
			}
			if ($tipo_ingr != '') {
				$where["tig_id IN($tipo_ingr)"] = null;
			}
			if ($filt_empl != '') {
				$where['emp_id'] = $filt_empl;
			}
			$registros = $this->planilla_model->get_ingresos_mensuales($where);
			$data['reporte'] = $reporte;
			$data['periode'] = 'Del ' . $fecha_ini . ' al ' . $fecha_fin;
			$data['filename'] = 'rpt_ingresos_plan_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 5);
			$data['registros'] = $registros;
			$html = $this->load->view('personal/reportes/detalle_ingr_mensual', $data, true);
			if ($flag) {
				echo json_encode(array('tabla' => $html, 'filas' => count($registros)));
			} else {
				if ($reporte == 'pdf') {
					$header = $this->load->view('reporte/header',  array('titulo' => 'Ingresos', 'subtitulo' => 'Del ' . $fecha_ini . ' al ' . $fecha_fin), true);
					$documento = $header . $html;
					$this->pdf->makePdf($documento, 'P');
				} else {
					echo $html;
				}
			}
		} else {
			$tipo_ings = $this->gsatelite->get_dropdown('tig_tipo_ingreso', '{tig_nombre}', '', array('tig_estado' => 1), null, '', 'tig_id', true);
			$dropdown = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
			$data['empleado'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $dropdown);
			$data['ingresos'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $tipo_ings);
			$data["titulo_personal"] = "Ingresos mensuales";
			$this->_cargarvista($data);
		}
	}

	/**
	 *@author Raul E.
	 */
	function det_proporcion_descuento($flag = null)
	{
		satelite_validar();
		if ($_POST) {
			$tipo_plan = $this->input->post('tipo_plan');
			$prdo_plan = $this->input->post('prdo_plan');
			$tipo_ingr = $this->input->post('tipo_ingr');
			$filt_empl = $this->input->post('filt_empl');
			$reporte = $this->input->post('tipo_reporte');
			$where = array();
			if ($tipo_plan != '') {
				$where['inn_id_tpl '] = $tipo_plan;
			}
			if ($prdo_plan != '') {
				$where['ddi_id_pla'] = $prdo_plan;
			}
			if ($tipo_ingr != '') {
				$where['ddi_id_tig'] = $tipo_ingr;
			}
			if ($filt_empl != '') {
				$where['ddi_id_emp'] = $filt_empl;
			}
			$registros = $this->planilla_model->get_ingresos_mensuales_ddi($where);
			$data['reporte'] = $reporte;
			$data['filename'] = 'rpt_prop_desc_plan_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 5);
			$data['registros'] = $registros;
			$fecha_pla = $this->gsatelite->get_campo('pla_planilla', 'pla_codigo', array('pla_id' => $prdo_plan));
			$html = $this->load->view('personal/reportes/detalle_prop_descs', $data, true);
			if ($flag) {
				echo json_encode(array('tabla' => $html, 'filas' => count($registros)));
			} else {
				if ($reporte == 'pdf') {
					$header = $this->load->view('reporte/header',  array('titulo' => 'Detalle de Descuentos', 'subtitulo' => 'Planilla: ' . $fecha_pla), true);
					$documento = $header . $html;
					$this->pdf->makePdf($documento, 'P');
				} else {
					echo $html;
				}
			}
		} else {
			$tipo_ings = $this->gsatelite->get_dropdown('tig_tipo_ingreso', '{tig_nombre}', '', array('tig_estado' => 1), null, '', 'tig_id', true);
			$dropdown = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
			$tipo_plas = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', array('tpl_estado' => 1, 'tpl_id_emr' => $this->tank_auth->get_empresa_id()), null, '', 'tpl_id', true);
			$data['empleado'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $dropdown);
			$data['ingresos'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $tipo_ings);
			$data['tipo_planilla'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $tipo_plas);
			$data["titulo_personal"] = "Proporción Descuento";
			$this->_cargarvista($data);
		}
	}

	public function detalle_empleado($flag=null){
		satelite_validar();
		if ($_POST) {
			// var_dump($_POST);die();
			$emp = $_POST['id_emp'];
			$tpl = $_POST['id_tpl'];
			$pla = $_POST['id_pla'];
			$trp = $_POST['tipo_reporte'];
			$winn = $wdss = array();
			if ($emp > 0) {
				$winn["emp_id"] = $emp;
				$wdss["emp_id"] = $emp;
			}
			if ($tpl > 0) {
				$winn['tpl_id'] = $tpl;
				$wdss["tpl_id"] = $tpl;
			}
			if ($pla != "") {
				$winn["ddi_id_pla IN ($pla)"] = null;
				$wdss["ddd_id_pla IN ($pla)"] = null;
			}			
			$detalles = $this->planilla_model->get_detalle_empleado($winn, $wdss);
			$data['tipo_reporte'] = $trp;
			$data['registros'] = $detalles;
			$html = $this->load->view('personal/reportes/get_reporte_detalleXempleado', $data, true);
			if ($flag) {
				echo json_encode(array('tabla' => $html, 'filas' => count($detalles)));
			} else {
				if ($trp == 'pdf') {
					$header = $this->load->view('reporte/header',  array('titulo' => 'Detalle de Ingresos y Descuentos', 'solotitulo' => true), true);
					$documento = $header . $html;
					$this->pdf->makePdf($documento, 'P');
				} else {
					echo $html;
				}
			}
		} else {
			$planillas = $this->gsatelite->get_dropdown('tpl_tipo_planilla','{tpl_prefijo} - {tpl_nombre}', '',array('tpl_id_emr' => $this->tank_auth->get_empresa_id()), null, '', 'tpl_id', true);
			$empleados = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
			$data['empleados'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $empleados);
			$data['tipo_planillla'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $planillas);
			$data["titulo_personal"] = "Detalle por empleado";
			$this->_cargarvista($data);
		}		
	}



	/**
	 * Descripción:
	 * Función para obtener el reporte de horario 
	 * @author Edith Herrera - Grupo Satélite
	 * @since  2018-08-13
	 * @param  ninguno
	 * @return Registros de horario por empleado.
	 */
	function rpt_horario()
	{
		satelite_validar();
		if ($this->input->post()) {
			$tipo_reporte = ($this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';

			if ($tipo_reporte != null) {
				//die(print_r($_POST));
				$area = ($this->input->post('filtro_area') > 0) ? $this->input->post('filtro_area') : null;
				$empleado = ($this->input->post('filtro_empleado') > 0) ? explode(',', $this->input->post('filtro_empleado')) : null;
				$fecha = ($this->input->post('filtro_fecha') > 0) ? $this->input->post('filtro_fecha') : null;
			} else {
				$area = $this->input->post('area');
				$empleado = $this->input->post('empleado');
				$fecha = $this->input->post('fecha');
			}
			$this->load->library('EnLetras');
			/******************************************** CONSULTA ************************************************/
			$where = null;

			if ($empleado != 'null' && count($empleado) > 0) {
				$this->db->where_in('hxe_id_emp', $empleado);
			}

			if ($fecha != '') {
				$fecha_ini = formatear_fecha("Y-m-d", $fecha);
				$fecha_fin = date('Y-m-d', strtotime('+15 Day', strtotime($fecha)));

				$this->db->where('((DATE_FORMAT(hxe_fecha, "%Y-%m-%d")>= "' . $fecha_ini . '" AND DATE_FORMAT(hxe_fecha, "%Y-%m-%d")<= "' . $fecha_fin . '" ) OR (DATE_FORMAT(hxe_fecha_fin, "%Y-%m-%d") >= "' . $fecha_ini . '" AND DATE_FORMAT(hxe_fecha_fin, "%Y-%m-%d")<= "' . $fecha_fin . '" ))', null, false);
			}

			$detalle = $this->gsatelite->get_tabla('hxe_hora_extraxempleado', array('hxe_estado' => 1));

			$data['horas'] = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA');
			$data['fecha_ini'] = $fecha;

			/****************************************************************************************************** */
			if ($area > 0) {
				$this->db->where('emp_id_are', $area);
			}

			if ($empleado != 'null' && count($empleado) > 0) {
				$this->db->where_in('emp_id', $empleado);
			}
			$empleados = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado' => 1));

			$array_empleados = array();

			foreach ($empleados as $emp) {
				$nombre = $emp['emp_nombre'] . ' ' . $emp['emp_apellido'];
				$array_empleados[$nombre] = array();
			}

			$array_horas = array();
			$id_emp = 0;
			$k = 0;
			foreach ($detalle as $det) {
				$id = $det['hxe_id_emp'];
				$det_ini = formatear_fecha("d-m-Y", $det['hxe_fecha']);
				$det_fin = ($det['hxe_fecha_fin'] != '') ? $det['hxe_fecha_fin'] : $det['hxe_fecha'];

				/**************** Días por registro  *****************/
				$fecha1 = new DateTime($det_ini);
				$fecha2 = new DateTime($det_fin);
				$fecha_diff = $fecha1->diff($fecha2);

				if ($fecha_diff->d > 0) {
					for ($i = 0; $i <= $fecha_diff->d; $i++) {
						if (!array_key_exists($det_ini, $array_horas)) {
							$array_horas[$det_ini] = $det['hxe_num_hora'];
						} else {
							$array_horas[$det_ini] += $det['hxe_num_hora'];
						}
						$det_ini = date('d-m-Y', strtotime('+1 Day', strtotime($det_ini)));
					}
				} else {
					if (!array_key_exists($det_ini, $array_horas)) {
						$array_horas[$det_ini] = $det['hxe_num_hora'];
					} else {
						$array_horas[$det_ini] += $det['hxe_num_hora'];
					}
				}

				////// Asignación de fecha por empleado //////
				$emp = $this->gsatelite->get_registro('emp_empleado', array('emp_id' => $id));
				$nombre = $emp->emp_nombre . ' ' . $emp->emp_apellido;
				if ($k + 1 == count($detalle)) {
					$array_empleados[$nombre] = $array_horas;
				}
				$id_emp = $id;
				//////////////////////////////////////////////

				/***************************************************/
				$k++;
			}


			$data['detalle'] = $array_empleados;

			$data['header'] = $this->load->view('reporte/header',  array('titulo' => 'Horario laboral'), true);

			$data['tipo_reporte'] = $tipo_reporte;
			if ($tipo_reporte != '') {
				switch ($tipo_reporte) {
					case 'pdf':
						$data['titulo'] = 'Horario laboral';
						$html = $this->load->view('personal/reportes/export_horario', $data, true);
						$this->pdf->makePdf($html, 'L', 'horario', 'A4');
						break;
					case 'excel':
						$filename = 'rpt_horario_laboral' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
						$data['titulo'] = ' horario laboral';
						$data['filename'] = $filename;
						$data['excel'] = 1;

						$html = $this->load->view('personal/reportes/export_horario', $data, true);
						echo $html;
						break;
				}
			} else {
				$html = $this->load->view('personal/reportes/detalle_horario_laboral', $data, true);
				echo json_encode(array('resultado' => $html, 'empleado' => $empleado, 'fecha' => $fecha, 'area' => $area));
			}
		} else {

			/*$empleados = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', '', true);
        	$data['empleados'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>',$empleados);*/

			$areas = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
			$data['areas'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $areas);

			$data["titulo_personal"] = "Horario laboral";
			$this->_cargarvista($data);
		}
	}



	function _cargarvista($data = 0, $crud = 0)
	{
		$this->load->view('vacia', $crud);
		if ($data != 0)
			$data = array_merge($data, $this->masterpage->getUsuario());
		else
			$data = $this->masterpage->getUsuario();
		$vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content', $data);
		$this->masterpage->show();
	}

	/**
	 * Descripción:
	 * Reporte de los ingresos catalogados como permanentes para un empleado
	 * @author Raul. E. - Grupo Satélite
	 * @since  2020-feb
	 * @param  ninguno
	 */
	public function reporte_ingresos_permanentes($flag = null)
	{
		if ($_POST) {
			if ($flag) {
				$empleado = $this->input->post('empleado');
				$planilla = $this->input->post('planilla');
				$ingresos = (is_array($this->input->post('ingresos'))) ? implode(',', $this->input->post('ingresos')) : "";
				$tipo_reporte = '';
			} else {
				$empleado = $this->input->post('hdn_empleado');
				$planilla = $this->input->post('hdn_planilla');
				$ingresos = $this->input->post('hdn_ingresos');
				$tipo_reporte = $this->input->post('tipo_reporte');
			}
			$where = $where2 = array();
			if ($empleado != "") {
				$where['emp_id'] = $empleado;
			}
			if ($planilla != "") {
				$where2['planilla'] = $planilla;
			}
			if ($ingresos != "") {
				$where2['ingresos'] = $ingresos;
			}
			$consulta = $this->planilla_model->get_ingresos_permanentes($where, $where2);
			$filas = count($consulta);
			$data['filas'] = $filas;
			$data['consulta'] = $consulta;
			$data['filename'] = 'rpt_ingresos_permanentes_' . substr(uniqid(md5(rand()), true), 0, 7);
			$data['titulo'] = 'Ingresos permanentes';
			$data['tipo_reporte'] = $tipo_reporte;
			$html = $this->load->view('personal/reportes/filtrar_ingresos_permanentes', $data, true);
			if ($flag) {
				echo json_encode(array('tabla' => $html, 'filas' => $filas));
				die();
			} else {
				if ($tipo_reporte == 'pdf') {
					$header = $this->load->view('reporte/header', $data, true);
					$GLOBALS['nombre_reporte'] = 'Reporte_Ingresos_Permanentes_' . date('dmY');
					$reporte = $header . $html;
					$this->pdf->makePdf($reporte, 'P', 'Reporte_Ingresos_Permanentes', 'Letter');
				} elseif ($tipo_reporte == 'excel') {
					echo $html;
					die();
				}
			}
		} else {
			$id_salary = $this->gsatelite->get_parametro('INGRESO_SALARIO');
			$ingresos  = $this->gsatelite->get_dropdown('tig_tipo_ingreso', '{tig_nombre}', '', array('tig_estado' => 1, 'tig_id !=' => $id_salary), null, '', 'tig_id', true);
			$planillas = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', array('tpl_estado' => 1), null, '', 'tpl_id', true);
			$empleados = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
			$data['tipos_inn'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $ingresos);
			$data['empleados'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $empleados);
			$data['tipos_pla'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $planillas);
			$data["titulo_personal"] = "Ingresos Permanentes";
			$this->_cargarvista($data);
		}
	}

	/**
	 * Descripción:
	 * Reporte detallado de los descuentos catalogados como permanentes para un empleado
	 * @author Raul. E. - Grupo Satélite
	 * @since  2020-sep
	 * @param  ninguno
	 */
	public function descuentosxempleado($flag = null)
	{
		satelite_validar();
		$data['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

		if ($_POST) {
			$where = null;
			$emp_id = $this->input->post('id_emp');
			$tdc_id = $this->input->post('id_tdc');
			$tpl_id = $this->input->post('id_tpl');
			$tipo_reporte = $this->input->post('tipo_reporte');
			if ($emp_id != "") {
				$where['ddd_id_emp'] = $emp_id;
			}
			if ($tdc_id != "") {
				$where['ddd_id_tdc'] = $tdc_id;
			}
			if ($tpl_id != "") {
				$where['tpl_id'] = $tpl_id;
			}
			$consulta = $this->planilla_model->get_detalle_otros_desc_emp($where);
			$data['detalles'] = $consulta;
			$data['filename'] = "Reporte_descuento_emp" . date('dmYHis');
			$data['tipo_reporte'] = $tipo_reporte;
			$html = $this->load->view('personal/reportes/detalle_desc_x_empleado', $data, true);
			if ($flag) {
				echo json_encode(array('tabla' => $html, 'filas' => count($consulta)));
				die();
			} else {
				if ($tipo_reporte == 'excel') {
					echo $html;
				} else {
					$data['titulo'] = 'Descuento por Empleada/o';
					$header = $this->load->view('reporte/header', $data, true);
					$GLOBALS['nombre_reporte'] = 'Reporte_Descuento_Empleado_' . date('dmY');
					$reporte = $header . $html;
					$this->pdf->makePdf($reporte, 'P', 'reporte_descuento_empleado_', 'Letter');
				}
			}
		} else {
			$planillas = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_prefijo} - {tpl_nombre}', '', array('tpl_id_emr' => $this->tank_auth->get_empresa_id()), null, '', 'tpl_id', true);
			$empleados = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
			$data['empleados'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $empleados);
			$data['tipo_planillla'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $planillas);
			$data["titulo_personal"] = "Descuentos por empleado";
			$this->_cargarvista($data);
		}
	}

	public function planillas_renta($flag = null)
	{
		satelite_validar();
		if ($_POST) {
			$data['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

			$id_emp = $this->input->post('slct_emps');
			$year = $this->input->post('slct_year');
			$tipo = $this->input->post('tipo_reporte');
			$html = "";
			if ($id_emp > 0 && $year > 0) {
				$data['detalles'] = $this->planilla_model->get_detalle_planillas_renta($id_emp, $year);
				$data['filename'] = "Rpte_pla_renta_emp" . date('dmYHis');
				$data['tipo_reporte'] = $tipo;
				$html = $this->load->view('personal/reportes/detalle_plans_renta', $data, true);
			}
			if ($tipo == 'pdf') {
				$emp = $this->gsatelite->get_registro('emp_empleado', array('emp_id' => $id_emp));
				$data['titulo'] = 'Consolidado de Planillas para Renta';
				$data['subtitulo'] = 'Empleada/o: ' . $emp->emp_codigo . ' - ' . $emp->emp_nombre . ' ' . $emp->emp_apellido;
				$header = $this->load->view('reporte/header', $data, true);
				$GLOBALS['nombre_reporte'] = 'rep_planilla_calculo_isr_' . date('dmY');
				$reporte = $header . $html;
				$this->pdf->makePdf($reporte, 'P', 'reporte_planillas_renta', 'Letter');
			} else {
				echo $html;
			}
		} else {
			$select_years = '';
			$years_array = $this->db->select("DISTINCT(YEAR(pla_fecha)) AS years", false)->from('pla_planilla')->order_by('years DESC')->get()->result_array();
			$dropdown = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
			foreach ($years_array as $k => $val) {
				$select_years .= '<option value="' . $val['years'] . '">' . $val['years'] . '</option>';
			}
			$data['empleado'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $dropdown);
			$data['select_years'] = $select_years;
			$data['titulo_personal'] = "Planillas para Renta";
			$data['permisos'] = $this->gsatelite->get_permisos_opcion();
			cargarvista($data);
		}
	}

	public function get_descuentos_x_empleado()
	{
		$select = '<option value=""></option>';
		$emp_id = $this->input->post('id_emp');
		$descts = $this->planilla_model->get_otros_descuentos_empleado(array('dss_id_emp' => $emp_id));
		foreach ($descts as $key => $val) {
			$select .= '<option value="' . $val['tdc_id'] . '">' . $val['tdc_nombre'] . '</option>';
		}
		echo $select;
	}
}
