<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Planilla extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('gsatelite');
        $this->load->library('grocery_CRUD');
        $this->load->model('planilla_model');
        $this->load->model('compras_model');
        $this->load->model('contabilidad_model');
        $this->load->model('inventario_model');
        $this->load->model('registro_academico_model');
        $this->load->library('tank_auth');
        $this->load->library('pdf');
        $this->load->library('texto');
        $this->driver = $this->planilla_model;
        $this->load->library('excel/excel_reader.php');
        $this->load->library('EnLetras');
    }

    public function crear_tabla()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id_pla      = $this->input->post('planilla');
            $informacion = $this->planilla_model->tabla_generada_planilla($id_pla);
            $numero_fila = 1;
            $cadena      = '';
            foreach ($informacion as $key) {
                $cadena .= '<tr>';
                $cadena .= '<td>' . $numero_fila++ . '</td>';
                $cadena .= '<td>' . $key->nombres . '</td>';
                $cadena .= '<td>' . $key->salario . '</td>';
                $cadena .= '<td>' . $key->ingresos . '</td>';
                $cadena .= '<td>' . $key->descuentos . '</td>';
                $cadena .= '<td>' . $key->total . '</td>';
                $cadena .= '</tr>';
            }

            $arreglo = array(
                "drop" => $cadena,
            );
            echo json_encode($arreglo);
        }
    }

    public function tipo_planilla(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $estado_tipo = 0;
            $urlx = explode('/', uri_string());
            if ($_POST) {
                // obtengo valor estado
                $estado_tipo = 0;
                $estado_tipo = $this->input->post('slcEstado');
            }
            $emr_id = $this->tank_auth->get_empresa_id();
            //Added by René Castaneda 08-03-2018
            //actualizar al id de empresa según la sessión del usuario (dado que es un cambio nuevo)
            $permisos = $this->gsatelite->get_permisos_opcion();
            $this->gsatelite->actualizar_empresa_id('tpl_tipo_planilla');

            $permiso_rol = false;
            $roles_jefes = explode(",", $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD',0) );
            $mis_roles   = $this->gsatelite->get_tabla("uxr_usuarioxrol",array("uxr_id_usu" => $this->tank_auth->get_user_id()));
            foreach ($mis_roles as $rol) {
                if ( in_array($rol["uxr_id_rol"], $roles_jefes) ) {
                    $permiso_rol = true;
                }
            }
            $crud = new grocery_CRUD();
            $crud->set_subject('')->set_table('tpl_tipo_planilla');
            $crud->columns('tpl_nombre', 'tpl_prefijo', 'tpl_desc', 'tpl_cantidad', 'tpl_frecuencia', 'tpl_estado');
            $crud->display_as('tpl_nombre', 'Nombre')
                ->display_as('tpl_prefijo', 'Prefijo')
                ->display_as('tpl_desc', 'Descripción')
                ->display_as('tpl_cantidad', 'Cantidad')
                ->display_as('tpl_frecuencia', 'Frecuencia')
                ->display_as('tpl_id_tag', 'Agrupador Reporte')
                ->display_as('tpl_tipo_liquidacion', 'Planilla de Liquidación')
                ->display_as('tpl_estado', 'Estado')
                ->set_relation('tpl_id_tag', 'tag_tipo_agrupador', 'tag_nombre', array("tag_estado" => 1))
                ->required_fields('tpl_nombre', 'tpl_prefijo', 'tpl_cantidad', 'tpl_frecuencia', 'tpl_estado')
                ->field_type('tpl_id_emr', 'hidden', $emr_id)
                ->field_type('tpl_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tpl_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('tpl_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tpl_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('tpl_nombre', 'Nombre', 'trim|required|campo_unico2[tpl_tipo_planilla.tpl_nombre.tpl_id_emr.' . $emr_id . ']')
                ->set_rules('tpl_prefijo', 'Prefijo', 'trim|required|campo_unico2[tpl_tipo_planilla.tpl_prefijo.tpl_id_emr.' . $emr_id . ']')
                ->where('tpl_id_emr', $emr_id)
            ;
            if ($permiso_rol) {
                $crud->display_as('tpl_letra_archivo_prn', 'Letra Archivo Banco');
                $crud->display_as('tpl_identificador_prn', 'N° Identificador Archivo Banco');
                $crud->display_as('tpl_siglas_archivo_prn', 'Siglas Empresa Archivo Banco');
                $crud->add_fields('tpl_nombre', 'tpl_prefijo', 'tpl_desc', 'tpl_cantidad', 'tpl_frecuencia', 'tpl_id_tag', 'tpl_tipo_liquidacion', 'tpl_letra_archivo_prn', 'tpl_identificador_prn', 'tpl_siglas_archivo_prn', 'tpl_id_emr', 'tpl_estado', 'tpl_usu_creacion', 'tpl_fecha_creacion', 'tpl_usu_modificacion', 'tpl_fecha_modificacion');
                $crud->edit_fields('tpl_nombre', 'tpl_prefijo', 'tpl_desc', 'tpl_cantidad', 'tpl_frecuencia', 'tpl_id_tag', 'tpl_tipo_liquidacion', 'tpl_letra_archivo_prn', 'tpl_identificador_prn', 'tpl_siglas_archivo_prn', 'tpl_estado', 'tpl_usu_modificacion', 'tpl_fecha_modificacion');
            } else {
                $crud->add_fields('tpl_nombre', 'tpl_prefijo', 'tpl_desc', 'tpl_cantidad', 'tpl_frecuencia', 'tpl_id_tag', 'tpl_id_emr', 'tpl_usu_creacion', 'tpl_fecha_creacion', 'tpl_tipo_liquidacion', 'tpl_estado');
                $crud->edit_fields('tpl_nombre', 'tpl_prefijo', 'tpl_desc', 'tpl_cantidad', 'tpl_frecuencia', 'tpl_id_tag', 'tpl_usu_modificacion', 'tpl_fecha_modificacion', 'tpl_tipo_liquidacion', 'tpl_estado');
            }
            

            $crud->callback_add_field('tpl_tipo_liquidacion', function () {
                return '<input type="checkbox" id="chk_liquidar" class="nostyle"><input type="hidden" id="field-tpl_tipo_liquidacion" name="tpl_tipo_liquidacion" value="0">';
            });
            $crud->callback_edit_field('tpl_tipo_liquidacion', function ($value, $primary_key) {
                $ver = ($this->uri->rsegments[3] == 'read') ? 'readonly ' : '';
                $dft = ($value) ? 'checked' : '';
                return '<input type="checkbox" id="chk_liquidar" ' . $dft . ' class="nostyle" ' . $ver . '><input type="hidden" id="field-tpl_tipo_liquidacion" name="tpl_tipo_liquidacion" value="' . $value . '">';
            });
            $crud->callback_after_insert(function ($post_array, $primary_key) {
                if ($post_array['tpl_tipo_liquidacion'] > 0) {
                    $CI = &get_instance();
                    $CI->gsatelite->actualizar_array('tpl_tipo_planilla', array('tpl_tipo_liquidacion' => 0), array('tpl_id != ' => $primary_key));
                    $valor_act = json_decode($CI->gsatelite->get_parametro('SYS_CONFIGURACION_LIQUIDACION', null, null, true), true);
                    $valor_act['ID_TIPO_PLANILLA_LIQ'] = strval($primary_key);
                    $nu_val = json_encode($valor_act);
                    $CI->gsatelite->actualizar('par_parametro', array("par_valor" => $nu_val), 'par_codigo', 'SYS_CONFIGURACION_LIQUIDACION');
                }
                return $post_array;
            });
            $crud->callback_after_update(function ($post_array, $primary_key) {
                if ($post_array['tpl_tipo_liquidacion'] > 0) {
                    $CI = &get_instance();
                    $CI->gsatelite->actualizar_array('tpl_tipo_planilla', array('tpl_tipo_liquidacion' => 0), array('tpl_id != ' => $primary_key));
                    $valor_act = json_decode($CI->gsatelite->get_parametro('SYS_CONFIGURACION_LIQUIDACION', null, null, true), true);
                    $valor_act['ID_TIPO_PLANILLA_LIQ'] = strval($primary_key);
                    $nu_val = json_encode($valor_act);
                    $CI->gsatelite->actualizar('par_parametro', array("par_valor" => $nu_val), 'par_codigo', 'SYS_CONFIGURACION_LIQUIDACION');
                }
                return $post_array;
            });

            if (end($urlx) == 'add') {
                $crud->field_type('tpl_estado', 'hidden', 1);
            } else {
                $crud->field_type('tpl_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if ($estado_tipo != '') {
                $crud->where('tpl_estado', $estado_tipo);
            }

            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_export();
                $crud->unset_print();
                $crud->unset_read();
            }
            if ($permisos['permite_agregar'] || $permisos['permite_editar']) {
                $crud->add_action(' Gestionar', '', 'personal/catalogos/ing_des_pla', 'icomoon-icon-cogs')
                    ->add_action(' ISR', '', 'personal/catalogos/pla_isr', 'brocco-icon-list');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Tipo de Planilla";
            $this->_cargarvista($data, $output);
        }
    }

    public function periodo_planilla()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $fecha_ini = '';
            $fecha_fin = '';
            $estado_planilla = 0;
            if ($_POST) {
                //Obtener valores del filtro
                $tipo     = $this->input->post('slcTipo');
                $proyecto = $this->input->post('slcProyecto');
                $fec_ini  = $this->input->post('txtFechaIni');
                $fec_fin  = $this->input->post('txtFechaFin');
                $estado_planilla = $this->input->post('slcEstado');
                if ($fec_ini != '') {
                    $fecha_ini = formatear_fecha('Y-m-d', $fec_ini);
                }
                if ($fec_fin != '') {
                    $fecha_fin = formatear_fecha('Y-m-d', $fec_fin);
                }
                $data['proyecto']  = $proyecto;
                $data['tipo']      = $tipo;
                $data['fecha_ini'] = $fec_ini;
                $data['fecha_fin'] = $fec_fin;
                $data['estado_planilla'] = $estado_planilla;
            } else {
                $tipo     = 0;
                $proyecto = 0;
                /************** Se identifica el primer y último día del mes ******************/
                $first_day  = date('01-m-Y');
                $last_day   = date('t-m-Y');
                //SAT_7074 FECHAS DE FILTRO SOLO MES ACTUAL POR DEFAUTL
                $fecha_ini = formatear_fecha('Y-m-d', $first_day);
                $fecha_fin = formatear_fecha('Y-m-d', $last_day);
                $data['fecha_ini'] = formatear_fecha('d-m-Y', $first_day);
                $data['fecha_fin'] = formatear_fecha('d-m-Y', $last_day);
            }
            $where_fecha_ini = array("DATE(pla_fecha_inicio) >= " => formatear_fecha('Y-m-d', $fecha_ini));
            $where_fecha_fin = array("DATE(pla_fecha_fin) <= " => formatear_fecha('Y-m-d', $fecha_fin));
            $emr_id = $this->tank_auth->get_empresa_id();
            $tpls   = $this->gsatelite->get_tabla('tpl_tipo_planilla', array('tpl_id_emr' => $emr_id, 'tpl_estado' => 1));

            $selected = '0';
            if (count($tpls) > 0) {
                $selected = implode(',', array_column($tpls, "tpl_id"));
            }
            // Verificar los proyectos no finalizados
            $eprs        = $this->gsatelite->get_tabla('epr_estado_proyecto', array('epr_cierre != ' => 1, 'epr_estado' => 1));
            $selectedPcl = '0';
            if (count($eprs) > 0) {
                $selectedPcl = implode(',', array_column($eprs, "epr_id"));
            }
            if ($tipo > 0) {
                $tipo_drop = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', array('tpl_id_emr' => $emr_id, 'tpl_estado' => 1), $tipo, '', 'tpl_id', true);
            } else {
                $tipo_drop = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', array('tpl_id_emr' => $emr_id, 'tpl_estado' => 1), null, '', 'tpl_id', true);
            }
            // Proyectos Iniciados
            if ($proyecto > 0) {
                // $proyectos = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array("pcl_id_epr IN( $selectedPcl )"=>null, 'pcl_estado'=>1), $proyecto, '', 'pcl_id', true);
            } else {
                // $proyectos = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array("pcl_id_epr IN( $selectedPcl )"=>null, 'pcl_estado'=>1), null, '', 'pcl_id', true);
            }
            $data['tipo']      = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $tipo_drop);
            $data['proyectos'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $proyectos);

            $display_as = array(
                'pla_id_tpl'       => 'Tipo de planilla',
                'pla_codigo'       => 'Código de planilla',
                'pla_fecha_inicio' => 'Fecha inicio',
                'pla_fecha_fin'    => 'Fecha fin',
                'pla_fecha_pago'   => 'Fecha pago',
                'pla_fecha_corte'  => 'Fecha corte',
                'pla_comentario'   => 'Comentarios',
                'pla_estado'       => 'Estado',
            );

            $required_fields = array(
                'pla_fecha_inicio',
                'pla_fecha_fin',
                'pla_id_tpl',
                'pla_codigo',
                'pla_fecha',
                'pla_fecha_corte',
                'pla_fecha_pago',
            );

            $add_fields = array(
                'pla_id_tpl',
                'pla_fecha_inicio',
                'pla_codigo',
                'pla_fecha_fin',
                'pla_fecha_pago',
                'pla_fecha_corte',
                'pla_comentario',
                'pla_usu_mod',
                'pla_fecha_mod',
                'pla_estado',
                'pla_fecha',
            );

            $edit_fields = array(
                'pla_id',
                'pla_id_tpl',
                'pla_codigo',
                'pla_fecha_inicio',
                'pla_fecha_fin',
                'pla_fecha_pago',
                'pla_fecha_corte',
                'pla_comentario',
            );

            $columns = array(
                'pla_codigo',
                'pla_id_tpl',
                'pla_fecha_inicio',
                'pla_fecha_fin',
                'pla_fecha_pago',
                'pla_fecha_corte',
                'pla_estado',
            );
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            //$crud->set_subject('Período de planilla');
            $crud->set_subject('');
            $crud->set_table('pla_planilla');
            $crud->display_as($display_as);
            $crud->field_type('pla_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('pla_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('pla_fecha', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('pla_estado', 'hidden', 1);
            $crud->field_type('pla_id', 'hidden');
            $crud->required_fields($required_fields);
            $crud->edit_fields($edit_fields);
            $crud->add_fields($add_fields);
            $crud->columns($columns);
            $crud->callback_column('pla_fecha_inicio', function ($value, $row) {
                return ($value != "" || $value != null) ? formatear_fecha("d-m-Y", $value) : '';
            });
            $crud->callback_column('pla_fecha_fin', function ($value, $row) {
                return ($value != "" || $value != null) ? formatear_fecha("d-m-Y", $value) : '';
            });
            $crud->callback_column('pla_fecha_corte', function ($value, $row) {
                return ($value != "" || $value != null) ? formatear_fecha("d-m-Y", $value) : '';
            });
            $crud->callback_column('pla_fecha_pago', function ($value, $row) {
                return ($value != "" || $value != null) ? formatear_fecha("d-m-Y", $value) : '';
            });
            $crud->set_relation('pla_id_tpl', 'tpl_tipo_planilla', 'tpl_nombre', array("tpl_id IN( $selected )" => null));
            $crud->set_relation('pla_id_plc', 'pcl_proyecto_cliente', '{pcl_nombre}', array("pcl_id_epr IN( $selectedPcl )" => null));
            if ($estado_planilla > 0) {
                $crud->where('pla_estado', $estado_planilla);
                if ($estado_planilla == 3) {
                    $crud->unset_delete();
                    $crud->unset_edit();
                }
            } else {
                // $crud->where('pla_estado < ', 3);//EN MAYA NO MOSTRAR POR DEFAULT LAS AUTORIZADAS
            }
            $crud->where("pla_id_tpl IN( $selected )", null, false);

            //Crear el where para la consulta
            if ($tipo > 0) {
                $crud->where("pla_id_tpl", $tipo);
            }
            if ($proyecto > 0) {
                //$crud->where("pla_id_plc", $proyecto);
            }
            if ($fecha_ini != '' && $fecha_fin != '') {
                $crud->where($where_fecha_ini);
                $crud->where($where_fecha_fin);
            }
            $crud->set_rules('pla_codigo', 'Código de planilla', 'trim|required|callback_codigo_planilla'); //campo_unico[pla_planilla.pla_codigo
            if ($permisos['permite_agregar']) {
                $crud->add_action('Autorizar', '', 'personal/planilla/autorizar_planilla', 'cut-icon-checkbox-checked confirm autorizar_x', null, null, "[pla_estado] == 'Generada'");
            }

            $crud->callback_column('pla_estado', array($this, 'columna_estado'));
            $crud->set_language('spanish');
            $crud->callback_before_update(function ($post_array, $primary_key) {
                $codigo = trim($post_array['pla_codigo']);
                array_push($post_array, $codigo);

                return $post_array;
            });

            $crud->callback_add_field('pla_fecha_inicio', function () {
                return '<input type="text" id="field-pla_fecha_inicio"  class="datePicker" name="pla_fecha_inicio">';
            });
            $crud->callback_add_field('pla_fecha_fin', function () {
                return '<input type="text" id="field-pla_fecha_fin"  class="datePicker" name="pla_fecha_fin">';
            });
            $crud->callback_add_field('pla_fecha_pago', function () {
                return '<input type="text" id="field-pla_fecha_pago"  class="datePicker" name="pla_fecha_pago">';
            });
            $crud->callback_add_field('pla_fecha_corte', function () {
                return '<input type="text" id="field-pla_fecha_corte"  class="datePicker" name="pla_fecha_corte">';
            });

            $crud->callback_edit_field('pla_fecha_inicio', function ($value, $row) {
                return '<input type="text" value="' . formatear_fecha('d-m-Y', $value) . '" id="field-pla_fecha_inicio"  class="datePicker" name="pla_fecha_inicio">';
            });
            $crud->callback_edit_field('pla_fecha_fin', function ($value, $row) {
                return '<input type="text" value="' . formatear_fecha('d-m-Y', $value) . '" id="field-pla_fecha_fin"  class="datePicker" name="pla_fecha_fin">';
            });
            $crud->callback_edit_field('pla_fecha_pago', function ($value, $row) {
                return '<input type="text" value="' . formatear_fecha('d-m-Y', $value) . '" id="field-pla_fecha_pago"  class="datePicker" name="pla_fecha_pago">';
            });
            $crud->callback_edit_field('pla_fecha_corte', function ($value, $row) {
                return '<input type="text" value="' . formatear_fecha('d-m-Y', $value) . '" id="field-pla_fecha_corte"  class="datePicker" name="pla_fecha_corte">';
            });
            $crud->callback_before_insert(function ($post_array) {
                $post_array['pla_fecha_inicio'] = formatear_fecha('Y-m-d', $post_array['pla_fecha_inicio']);
                $post_array['pla_fecha_fin'] = formatear_fecha('Y-m-d', $post_array['pla_fecha_fin']);
                $post_array['pla_fecha_pago'] = formatear_fecha('Y-m-d', $post_array['pla_fecha_pago']);
                $post_array['pla_fecha_corte'] = formatear_fecha('Y-m-d', $post_array['pla_fecha_corte']);
                return $post_array;
            });

            $crud->callback_before_update(function ($post_array, $primary_key) {
                $post_array['pla_fecha_inicio'] = formatear_fecha('Y-m-d', $post_array['pla_fecha_inicio']);
                $post_array['pla_fecha_fin'] = formatear_fecha('Y-m-d', $post_array['pla_fecha_fin']);
                $post_array['pla_fecha_pago'] = formatear_fecha('Y-m-d', $post_array['pla_fecha_pago']);
                $post_array['pla_fecha_corte'] = formatear_fecha('Y-m-d', $post_array['pla_fecha_corte']);
                return $post_array;
            });

            //Por si es necesario algun dia validar las fechas
            //$crud->set_rules('pla_fecha_inicio','Fecha de Finalización','callback_validar_rango_fechas[pla_fecha_fin]');
            $crud->set_rules('pla_id_tpl', "Tipo de planilla", "callback_validar_fechas_por_tipo_planilla");
            if (!$permisos['permite_ver']) {
                $crud->unset_read()
                    ->unset_print()
                    ->unset_export();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }

            $output                  = $crud->render();
            $data['titulo_personal'] = "Períodos de planilla";
            $this->_cargarvista($data, $output);
        }
    }

    public function validar_fechas_por_tipo_planilla()
    {
        $valido = true;
        if ($this->input->post("pla_id_tpl")) {

            $tipo_planilla = $this->input->post("pla_id_tpl");
            $id_plani = $this->input->post("pla_id");
            $data_fechas   = $this->gsatelite->get_tabla('pla_planilla', array('pla_id_tpl' => (int) $tipo_planilla, 'pla_id !=' => (int) $id_plani));
            $newFI         = $this->input->post("pla_fecha_inicio");
            $newFF         = $this->input->post("pla_fecha_fin");
            $newFI         = date("Y-m-d", strtotime($newFI));
            $newFF         = date("Y-m-d", strtotime($newFF));

            if (count($data_fechas) > 0) {
                for ($i = 0; $i < count($data_fechas); $i++) {
                    if ($newFI == $data_fechas[$i]["pla_fecha_inicio"] && $newFF == $data_fechas[$i]["pla_fecha_fin"]) {
                        $this->form_validation->set_message('validar_fechas_por_tipo_planilla', "El rango de fecha inicio y fin ya estan tomandos en este tipo de planilla.");
                        $valido = false;
                    }
                }
            }
        }
        return $valido;
    }

    public function validar_rango_fechas($fecha_i = null, $fecha_f = null)
    {
        if ($fecha_i != "" && $fecha_f != "") {
            $newFI = explode("-", $this->input->post("pla_fecha_inicio"));
            $newFF = explode("-", $this->input->post("pla_fecha_fin"));
            // var_dump($newFI);
            if ((int) $newFF[0] >= (int) $newFI[0]) {
                if ((int) $newFF[1] >= (int) $newFI[1]) {
                    if ((int) $newFF[2] > (int) $newFI[2]) {
                        return true;
                    } else {
                        $this->form_validation->set_message('validar_rango_fechas', "La fecha de inicio debe ser anterior a la fecha de finalización. 2");
                        return false;
                    }
                } else {
                    $this->form_validation->set_message('validar_rango_fechas', "La fecha de inicio debe ser anterior a la fecha de finalización. 1");
                    return false;
                }
            } else {
                $this->form_validation->set_message('validar_rango_fechas', "La fecha de inicio debe ser anterior a la fecha de finalización. 0");
                return false;
            }
        } else {
            return false;
        }
    }

    public function columna_estado($value, $row)
    {
        if ($value == 1) {
            return "Creada";
        } elseif ($value == 2) {
            return "Generada";
        } elseif ($value == 3) {
            return "Autorizada";
        }
    }
    /**
     *@author Nelson Soriano
     *@since  19-08-2019
     **/
    public function procesar_autoriza()
    {
        satelite_validar();
        $pla_id = $this->input->post('orden');
        if ($pla_id !== '') {
            //Primero se valida si la planilla esta dentro de los periodos contables
            $planilla_array = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $pla_id));
            $ver_prdo_conta = $this->gsatelite->get_parametro('SYS_VER_PRDO_CONTA', 1);
            if (count($planilla_array) > 0) {
                if (!validarFechaPeriodoContable(formatear_fecha('Y-m-d', $planilla_array[0]['pla_fecha_inicio'])) && $ver_prdo_conta > 0) {
                    echo json_encode(array('html' => '', 'redirect' => 0, 'aplica_proyecto' => 0, 'tipo_alerta' => "error", 'titulo_alerta' => "La planilla fuera de los periodos contables", 'texto_alerta' => "Por favor verifique sus periodos contables activos."));
                    die();
                }
            }

            $estado = $this->db->get_where('pla_planilla', array('pla_id' => $pla_id))->result_array();
            if ($estado[0]['pla_estado'] == 2) {
                $ing_presu = $this->planilla_model->get_ingresos_proyectos($pla_id);
                // obtenemos el Disponible por cada proyecto
                $datos_ing = array();
                foreach ($ing_presu as $key => $valor) {
                    $fecha = date_format(date_create($valor['pla_fecha_fin']), 'Ym');
                    $psp   = $valor['psp_id'];
                    $acg   = $valor['ddi_id_acg'];
                    $ace   = $valor['ddi_id_ace'];

                    $where       = array('pcp_estado' => 1, 'pcp_periodo' => $fecha, 'dps_id_acg' => $acg, 'dps_id_ace' => $ace);
                    $dispo       = $this->planilla_model->get_disponible_pcp($where, $fecha);
                    $datos_ing[] = array_merge($valor, $dispo);
                }

                if (count($datos_ing) > 0) {
                    $data['info'] = $datos_ing;
                    $config       = $this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA', 1, 1);
                    $data['conf'] = json_decode($config->par_default);
                    if (!is_object($data['conf'])) {
                        die(print_r('configura PAR_DEFAULT del parametro SYS_PRESUPUESTO_COMPRA ejemplo {"compras":"1","planillas":"2"}'));
                    }
                    $html   = $this->load->view('personal/planilla/procesar_autoriza', $data, true);
                    $alerta = array('html' => $html, 'redirect' => 1, 'aplica_proyecto' => 1, 'tipo_alerta' => "", 'titulo_alerta' => "", 'texto_alerta' => "");
                    echo json_encode($alerta);
                    die();
                } else {
                    if ($this->autorizar_planilla($pla_id)) {
                        $alerta = array('html' => '', 'redirect' => 1, 'aplica_proyecto' => 0, 'tipo_alerta' => "success", 'titulo_alerta' => "Planilla autorizada con éxito", 'texto_alerta' => "Los registros del periodo de planilla fueron autorizados");
                        $this->session->set_flashdata($alerta);
                        echo json_encode($alerta);
                        die();
                    } else {
                        echo json_encode(array('html' => '', 'redirect' => 0, 'aplica_proyecto' => 0, 'tipo_alerta' => "error", 'titulo_alerta' => "La planilla debe de ser generada", 'texto_alerta' => "Por favor genere antes la planilla para poder ser autorizada"));
                        die();
                    }
                }
            } else {
                echo json_encode(array('html' => '', 'redirect' => 0, 'aplica_proyecto' => 0, 'tipo_alerta' => "error", 'titulo_alerta' => "La planilla debe de ser generada", 'texto_alerta' => "Por favor genere antes la planilla para poder ser autorizada"));
                die();
            }
        }
    }

    /**
     *@author Nelson Soriano
     *@since  19-08-2019
     **/

    public function aplicar_montos_proyectos_planilla()
    {
        satelite_validar();
        $dps        = $this->input->post('presupuestos_idx');
        $tgp        = $this->input->post('tgp_idx');
        $referencia = $this->input->post('referencia_det');
        $monto      = $this->input->post('monto_aplicarx');
        $planilla   = $this->input->post('planilla');
        $fecha      = $this->input->post('fecha_finx');
        if ((count($dps) > 0) && (is_array($dps))) {
            for ($i = 0; $i < count($dps); $i++) {
                $dpg_array = array(
                    'dgp_id_dps'             => $dps[$i],
                    'dgp_id_tgp'             => $tgp[$i],
                    'dgp_fecha'              => date_format(date_create($fecha[$i]), 'Y-m-d H:i:s'),
                    'dgp_referencia'         => $referencia[$i],
                    'dgp_cantidad'           => 1,
                    'dgp_monto'              => $monto[$i],
                    'dgp_origen'             => 2,
                    'dgp_estado'             => 1,
                    'dgp_total_retencion'    => 0,
                    'dgp_total_impuesto'     => 0,
                    'dgp_referencia_origen'  => 'Módulo Planillas',
                    'dgp_sub_monto'          => $monto[$i],
                    'dgp_usu_creacion'       => $this->tank_auth->get_user_id(),
                    'dgp_fecha_creacion'     => date('Y-m-d H:i:s'),
                    'dgp_usu_modificacion'   => $this->tank_auth->get_user_id(),
                    'dgp_fecha_modificacion' => date('Y-m-d H:i:s'),
                );
                $this->gsatelite->ingresar('dgp_detalle_gasto_prespuesto', $dpg_array);
            }

            if ($this->autorizar_planilla($planilla[0])) {
                $alerta = array('tipo_alerta' => "success", 'titulo_alerta' => "Planilla autorizada con éxito", 'texto_alerta' => "Los registros del periodo de planilla fueron autorizados");
                $this->session->set_flashdata($alerta);
                redirect('/personal/planilla/periodo_planilla');
            } else {
                $alerta = array('tipo_alerta' => "error", 'titulo_alerta' => "Error al autorizar la planilla", 'texto_alerta' => "Los registros del periodo de planilla no fueron actualizados");
                $this->session->set_flashdata($alerta);
                redirect('/personal/planilla/periodo_planilla');
            }
        } else {
            if ($this->autorizar_planilla($planilla[0])) {
                $alerta = array('tipo_alerta' => "success", 'titulo_alerta' => "Planilla autorizada con éxito", 'texto_alerta' => "Los registros del periodo de planilla fueron autorizados");
                $this->session->set_flashdata($alerta);
                redirect('/personal/planilla/periodo_planilla');
            } else {
                $alerta = array('tipo_alerta' => "error", 'titulo_alerta' => "Error al autorizar la planilla", 'texto_alerta' => "Los registros del periodo de planilla no fueron actualizados");
                $this->session->set_flashdata($alerta);
                redirect('/personal/planilla/periodo_planilla');
            }
        }
    }

    public function autorizar_planilla($pla_id)
    {
        $ingreso_salario = $this->gsatelite->get_parametro('INGRESO_SALARIO');
        $datos_pla_liqui = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_LIQUIDACION'), true);
        $datos_pla_indem = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_INDEMNIZACION_VOLUNTARIA'), true);
        $estado          = $this->db->get_where('pla_planilla', array('pla_id' => $pla_id))->result_array();
        if ($estado[0]['pla_estado'] == 2) {
            // DATOS DE LA PLANILLA Y LUEGO VER SI ES DE LIQUIDACION O INDEMNIZACION
            $tpl = $this->db->select()->join('tpl_tipo_planilla', 'tpl_id=pla_id_tpl')->get_where('pla_planilla', array('pla_id' => $pla_id))->row();
            if ($tpl->tpl_id == $datos_pla_indem['ID_TIPO_PLANILLA_INDEMNIZACION']) {
                // PLANILLA DE LIQUIDACION INDIVIDUAL
                $empleados = $this->db->select()->join('inv_indemnizacion_voluntaria', 'inv_id = lqe_id_inv')->get_where('lqe_liquidacion_empleado', array('lqe_id_pla' => $pla_id))->result_array();
                $emp = 'inv_id_emp';
            } elseif ($tpl->tpl_id == $datos_pla_liqui['ID_TIPO_PLANILLA_LIQ']) {
                // PLANILLA DE BAJAS Y RETIROS
                $empleados = $this->db->select()->join('rte_retiro_empleado', 'rte_id = lqe_id_rte')->get_where('lqe_liquidacion_empleado', array('lqe_id_pla' => $pla_id))->result_array();
                $emp = 'rte_id_emp';
            } else {
                // PLANILLAS NORMALES
                $empleados = $this->db->select()->get_where('txe_tipo_planillaxempleado', array('txe_id_tpl' => $tpl->tpl_id))->result_array();
                $emp = 'txe_id_emp';
            }
            $tpl_id = $tpl->tpl_id;
            // var_dump($this->db->last_query());die();
            // var_dump($tpl_id, $emp, $empleados);die();
            foreach ($empleados as $key => $value) {
                $emp_id = $value[$emp];
                $ingresos = $this->db->select()->join('inn_ingreso', 'inn_id=ddi_id_inn')
                    ->get_where('ddi_detalle_ingreso', array('ddi_id_emp' => $emp_id, 'ddi_id_pla' => $pla_id))->result_array();
                $descuentos = $this->db->select()->join('dss_descuento', 'dss_id=ddd_id_dss')
                    ->get_where('ddd_detalle_descuento', array('ddd_id_emp' => $emp_id, 'ddd_id_pla' => $pla_id))->result_array();
                foreach ($ingresos as $inn => $data) {
                    if ($data['inn_permanente'] == 0) {
                        $cuotas = $data['inn_cuota'] - $data['inn_cuota_pagada'];
                        if ($cuotas <= 1) {
                            $datos = array(
                                'inn_cuota_pagada' => $data['inn_cuota_pagada'] + 1,
                                'inn_estado'       => 0,
                            );
                        } else {
                            $datos = array(
                                'inn_cuota_pagada' => $data['inn_cuota_pagada'] + 1,
                            );
                        }
                        if (isset($datos) && count($datos) > 0) {
                            $this->db->update('inn_ingreso', $datos, array('inn_id' => $data['ddi_id_inn'], 'inn_id_emp' => $emp_id, 'inn_id_tpl' => $tpl_id));
                        }
                    }
                }
                foreach ($descuentos as $dss => $data_dss) {
                    if ($data_dss['dss_permanente'] == 0) {
                        $cuotas = $data_dss['dss_cuota'] - $data_dss['dss_cuota_pagada'];
                        if ($cuotas <= 1) {
                            $estado_dss = 0;
                        } else {
                            $estado_dss = 1;
                        }
                        if (isset($estado_dss) and is_numeric($estado_dss)) {
                            $this->db->set('dss_cuota_pagada', 'dss_cuota_pagada + 1', false);
                            $this->db->set('dss_estado', $estado_dss, false);
                            $this->db->where('dss_id', $data_dss['ddd_id_dss']);
                            $this->db->where('dss_id_emp', $emp_id);
                            $this->db->where('dss_id_tpl', $tpl_id);
                            $this->db->update('dss_descuento');
                        }
                    }
                }
                //Se verifica el empleado para crearle un cheque de pago.
                $cuenta_bancaria = $this->gsatelite->get_campo('emp_empleado', 'emp_numero_cuenta', array('emp_id' => $emp_id));
                // Verificar que forma de pago de salario posee el empleado
                $forma_pago_sal = $this->gsatelite->get_campo('emp_empleado', 'emp_metodo_pago', array('emp_id' => $emp_id));
                if (($cuenta_bancaria == '' || $forma_pago_sal == 2)) {
                    $where = array(
                        'ddi_id_pla' => $pla_id,
                        'emp_id'     => $emp_id,
                    );
                    $empleado_salario = $this->planilla_model->get_salario_empleado($where, $pla_id, $ingreso_salario);
                    if (count($empleado_salario) > 0 && $forma_pago_sal == 2) {
                        $salario_total = $empleado_salario[0]['total'];
                        $empleado      = $empleado_salario[0]['nombre'];
                        $cheque_array = array(
                            'chp_id_emp'             => $emp_id,
                            'chp_id_pla'             => $pla_id,
                            'chp_id_usu_genera'      => $this->tank_auth->get_user_id(),
                            'chp_monto'              => $salario_total,
                            'chp_orden'              => $empleado,
                            'chp_concepto'           => 'Pago de salario',
                            'chp_fecha'              => date('Y-m-d'),
                            'chp_generado'           => 0,
                            'chp_estado'             => 1,
                            'chp_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'chp_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'chp_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'chp_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );
                        $this->gsatelite->ingresar('chp_cheque_pendiente', $cheque_array);
                    }
                }
                if ($tpl_id == $datos_pla_indem['ID_TIPO_PLANILLA_INDEMNIZACION'] || $tpl_id == $datos_pla_liqui['ID_TIPO_PLANILLA_LIQ']) {
                    // FUNCION QUE ACTUALICE LAS FECHAS DE LIQUIDACION, VACACION, AGUINALDO, ETC
                    $this->planilla_model->actualizar_fechas_empleado($emp_id, $pla_id, $tpl_id);
                }
            }
            $this->db->update('pla_planilla', array('pla_estado' => 3), array('pla_id' => $pla_id));
            $alerta = array('tipo_alerta' => "success", 'titulo_alerta' => "Planilla autorizada con éxito", 'texto_alerta' => "Los registros del periodo de planilla fueron autorizados");
            //===================================
            //GENERAR PARTIDA CONTABLE
            //===================================
            $permite_generar = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_PLANILLA');
            if ($permite_generar == 1 and $pla_id > 0) {
                //generar partida de planilla
                $pla_id_pct = $this->generar_partida_automatica_planilla($pla_id, 2);
                //actualizar el planilla
                if ($pla_id_pct > 0) {
                    $pla_planilla = array(
                        "pla_id_pct" => $pla_id_pct,
                    );
                    $this->gsatelite->actualizar_array("pla_planilla", $pla_planilla, array("pla_id" => $pla_id));
                }
            }
        } else {
            $alerta = array('tipo_alerta' => "error", 'titulo_alerta' => "La planilla debe de ser generada", 'texto_alerta' => "Por favor genere antes la planilla para poder ser autorizada");
            return false;
        }
        //$this->session->set_flashdata($alerta);
        //redirect('/personal/planilla/periodo_planilla');
        return true;
    }

    public function get_emp_x_pla()
    {
        $select = '<option value=""></option>';
        $pla_id = $this->input->post('planilla');
        $emplds = $this->planilla_model->get_empl_x_plan(array('pla_id' => $pla_id));
        foreach ($emplds as $key => $value) {
            $select .= '<option value="' . $value['emp_id'] . '">' . $value['emp_codigo'] . ' - ' . $value['emp_nombre'] . ' ' . $value['emp_apellido'] . '</option>';
        }
        echo $select;
    }

    public function generar_boletas($pla_id = null, $doble = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            ini_set('memory_limit', '1024M');
            ini_set('max_execution_time', '9999');
            $pla_id      = ($this->input->post('planilla')) ? $this->input->post('planilla') : $pla_id;
            $emp_id      = ($this->input->post('filtro_empleado') != "") ? $this->input->post('filtro_empleado') : null;
            $doble       = ($this->input->post('doble')) ? $this->input->post('doble') : $doble;
            $datos       = $this->planilla_model->generar_boletas($pla_id, $emp_id);
            $empresa     = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));
            $header_html = $this->load->view('reporte/header_boleta_pago', array('solotitulo' => true, 'titulo' => ' BOLETA PAGO ', 'empresa' => $empresa, 'doble' => $doble), true);
            //libreria pdf
            $this->load->library('pdf');
            $pdf = $this->pdf;
            $total_empleados = count($datos);
            if ($total_empleados > 0) {
                $k     = 0;
                $html2 = "";
                $p     = 0;
                foreach ($datos as $row) {
                    $p++;
                    $dar_saltos            = ($k == 0 or (($p == $total_empleados and ($total_empleados % 2) != 0))) ? false : true;
                    $row['permite_saltos'] = $dar_saltos;
                    $row['cabezera']       = $header_html;
                    $row['doble']          = $doble;
                    $row['tipo_ant']       = $this->gsatelite->get_parametro('ID_TIPO_DESCUENTO_ANTICIPO');
                    $row['empresa']        = $empresa;
                    $row['correlativo']    = $p;
                    $row['total_empleado'] = $total_empleados;
                    $row['mensaje_personalizado'] = 'Incapacidades de 1 a 3 días, paga la empresa';

                    $existe_fri = $this->gsatelite->get_tabla('fri_formato_impresion', array('fri_estado' => 1, 'fri_activo' => 1, 'fri_tipo_formato' => 5));
                    // var_dump($row);die();
                    if (count($existe_fri) > 0) {
                        $html = $this->load->view('personal/planilla/' . $existe_fri[0]['fri_archivo'], $row, true);
                    } else {
                        $html = $this->load->view('personal/planilla/rpt_boletas', $row, true);
                    }
                    $html2 .= $html;
                    if ($doble == 0) {
                        if ($k == 1) {
                            if ($empresa != 'unillantas' && $empresa != 'rino' && $empresa != 'isdemu') {
                                $font = '';
                                $pdf->setPrintFooter(true);
                            } else {
                                $font = ($empresa == 'isdemu') ? 'pdfahelvetica' : 'lucida_console' ;
                                $pdf->setPrintFooter(false);
                            }
                            $pdf->SetAutoPageBreak(true, 0);
                            $pdf->addBoleta_planilla($html2, null, 'P', $font);
                            $html2 = "";
                            $k     = 0;
                        } else {
                            $k = 1;
                            if ($p == count($datos) and (count($datos) % 2) != 0) {
                                //cuando es impar
                                if ($empresa != 'unillantas' && $empresa != 'rino' && $empresa != 'isdemu') {
                                    $font = '';
                                    $pdf->setPrintFooter(true);
                                } else {
                                    $font = ($empresa == 'isdemu') ? 'pdfahelvetica' : 'lucida_console' ;
                                    $pdf->setPrintFooter(false);
                                }
                                $pdf->addBoleta_planilla($html2, null, 'P', $font);
                            }
                        }
                    } else if ($doble == 1) {
                        if ($empresa == 'isdemu') {
                            $font = 'pdfahelvetica';
                        }
                        $pdf->setPrintFooter(true);
                        $pdf->SetAutoPageBreak(true, 0);
                        $pdf->addBoleta_planilla($html2, null, 'P', $font);
                        $html2 = "";
                        $k     = 0;
                    }
                }
                //Imprimimos PDF
                if (($empresa == 'unillantas' || $empresa == 'rino' || $empresa == 'isdemu') && $doble == 0) {
                    $pdf->setPrintFooter(false);
                } else {
                    if ($empresa != 'isdemu' && $empresa != 'la paz este') {                        
                        $pdf->setPrintFooter(true);
                    } else {
                        $pdf->setPrintFooter(false);
                    }
                }
                $pdf->SetTitle('Boletas de Pago');
                $pdf->boletaPDF('I'); //'D'
            } else {
                /* $alerta = array(
                'tipo_alerta'=> 'note_error',
                'titulo_alerta'=>"Imposible Generar.",
                'texto_alerta'=>"Error: Generación de boletas.");
                $this->ci->session->set_flashdata($alerta); */
                redirect();
            }
        }
    }

    public function pla_print()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $pla_id = $this->input->post('planilla');
            $tipo   = $this->input->post('tipo_reporte');
            if ($pla_id > 0) {
                /* print_r($tipo);
                exit(); */
                $this->load->library('pdf');
                $usuarios = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
                //preguntar si es emi
                if ($this->gsatelite->get_parametro('SYS_IDENTIFICADOR_EMPRESA') == "2") {
                    //se trata de la empresa emi
                    $html = $this->planilla_model->print_planilla_emi($pla_id, $usuarios, $tipo);
                } else {
                    $html = $this->planilla_model->print_planilla($pla_id, $usuarios, $tipo);
                }

                //die($html);
                // $this->pdf->setPageOrientation('L');
                $this->pdf->makePDF($html, 'L', '', 'ledger');
            }
        }
    }

    // Este me lo puedo evitar.
    public function imprimir_planilla_excel_plazas($pla_id = null, $tipo = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // All your code here
            if ($_POST) {
                //die(print_r($_POST));
                die(print_r($_POST));
            }
        }
    }

    public function imprimir_planilla_excel($pla_id = null, $tipo = null, $plaza = null, $es_ylufa = null){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $pla_id = ($this->input->post('planilla')) ? $this->input->post('planilla') : $pla_id;
            if ($es_ylufa == 1) {
                $tipo = ($this->input->post('tipo_reporte')) ? $this->input->post('tipo_reporte') : $tipo;
            } else {
                $tipo = 'salario';
            }
            //$plaza = ($this->input->post('plaza'))? $this->input->post('plaza'): $plaza;
            $plaza = ($this->input->post('por_plaza')) ? $this->input->post('por_plaza') : $plaza;
            if ($pla_id > 0) {
                $usuarios = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
                //encabezado del reporte
                $encabezado = "<table><tr><td colspan='4'><h3>" . $this->gsatelite->get_parametro('SYS_EMPRESA') . "</h3></td></tr><tr><td colspan='4'>Generación de Planilla</td></tr>";
                if ($es_ylufa == 1) {
                    $html = $encabezado . $this->planilla_model->print_planilla($pla_id, $usuarios, $tipo, 1);
                } else {
                    $encabezado = "";
                    if (!empty($plaza)) {
                        $html = $encabezado . $this->planilla_model->print_planilla_emi_plazas($pla_id, $usuarios, $tipo, 1);
                    } else {
                        $html = $encabezado . $this->planilla_model->print_planilla_emi($pla_id, $usuarios, $tipo, 1);
                    }
                }

                // print_r($html); die();
                $data['datos'] = str_replace('border="0.5"', 'border="1"', $html);
                $this->load->view('personal/planilla/imprimir_planilla_excel', $data);
            }
        }
    }

    public function pla_print_txt($banco = null)
    {
        satelite_validar();
        $pla_id = $this->input->post('planilla');
        $tipo   = 'salario';
        // Added by Edith Herrera. 17/07/2018
        /* ===== GENERAR ARCHIVO TXT DE BANCO PROMERICA Y BANCO AZUL ===== */
        if ($banco == 1) {
            $this->generar_archivo_txt_prom($pla_id);
            die('Exito!');
        } elseif ($banco == 2) {
            $this->generar_archivo_txt_azul($pla_id);
            die('Exito!');
        } elseif ($banco == 3) {
            $this->generar_txt_hipotecario($pla_id);
            die('Exito!');
        } elseif ($banco == 4) {
            $this->generar_txt_cuscatlan($pla_id);
            die('Exito!');
        }
        /* ==========   FIN GENERAR ARCHIVO TXT DE BANCOS   ========== */
        if ($pla_id > 0) {
            $usuarios = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            if ($this->gsatelite->get_parametro('FORMATO_ARCHIVO_BANCO') == 2) {
                $txt = $this->planilla_model->print_planilla_bnk($pla_id, $usuarios, $tipo, 1, true);
                // var_dump($this->db->last_query());die();
            } else {
                $txt = $this->planilla_model->print_planilla_emi($pla_id, $usuarios, $tipo, 1, true);
            }
            if ($txt) {
                $fecha = date('Y-m-d');
                $var   = explode('-', $fecha);
                $dia   = $var[0] . $var[1] . $var[2];
                $hora  = date('H:i');
                $hr    = explode(':', $hora);
                $hora  = $hr[0] . $hr[1];
                $archivo = "PLA_ACL" . $dia . $hora . ".bnk-";
                $base_url = base_url();
                if ($this->gsatelite->get_parametro('FORMATO_ARCHIVO_BANCO') == 2) {
                    @copy("uploads/txt_planilla/datos_planilla.txt", "uploads/txt_planilla/" . $archivo);
                    header("Content-Type: application/octet-stream");
                    header('Content-Disposition: attachment; filename="' . $archivo . '"');
                    header("Location: " . $base_url . "uploads/txt_planilla/" . $archivo);
                    //readfile($base_url."uploads/txt_planilla/datos_planilla.txt");
                } else {
                    header("Content-Type: application/octet-stream");
                    header('Content-Disposition: attachment; filename="datos_planilla.txt"');
                    header("Location: " . $base_url . "uploads/txt_planilla/datos_planilla.txt");
                }
            }
            die("<h1>ERROR EN LA CREACIÓN DEL ARCHIVO</h1>");
        }
    }

    public function pla_print_isss_txt($imprimir_excel = null)
    {
        satelite_validar();
        $pla_id           = $this->input->post('planilla');
        $tipo_reportes    = $this->input->post('tipo_reporte_consolidado'); // Tipo de reporte
        $planila_periodo  = $this->input->post('planilla_consolidado');
        $tipo_planilla    = $this->input->post('tipo_planilla_consolidado');
        $tipo_consolidado = 2;
        $es_excel         = 0;
        $tipo     = 'salario';
        $usuarios = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
        $base_url = base_url();
        /*         * ********************** TXT PARA UNA PLANILLA *********************************************** */
        if ($pla_id > 0) {
            $txt = $this->planilla_model->print_planilla_isss($pla_id, $usuarios, $tipo, 1, true);
            //print_planilla_emi($pla_id,$usuarios,$tipo, 1,true,$consolidado);
            if ($txt) {
                header("Content-Type: application/octet-stream");
                header('Content-Disposition: attachment; filename="datos_planilla.txt"');
                header("Location: " . $base_url . "uploads/txt_planilla/datos_planilla.txt");
            }
            die("<h1>ERROR EN LA CREACIÓN DEL ARCHIVO</h1>");
        }

        /*         * ********************** TXT PARA PLANILLAS CONSOLIDADAS *********************************************** */
        if (count($planila_periodo) > 0) {
            //que no se trate de un consolidado en excel y el array tenga al menos un elemento
            $txt_consolidado = true;
            if (file_exists("uploads/txt_planilla/datos_planilla_consolidado.txt")) {
                unlink("uploads/txt_planilla/datos_planilla_consolidado.txt"); //eliminar el archivo si existiese
            }
            $file_txt_consolidado = fopen("uploads/txt_planilla/datos_planilla_consolidado.txt", "w") or die("Problemas en creación del archivo");
        }

        $pln_excel_iss = array();
        $pln_excel_iss2 = array();
        $identificar_empleado = array();
        if (count($tipo_planilla) > 0) {
            $n_periodos  = count($planila_periodo);
            $consolidado = array($tipo_consolidado, $es_excel);
            $longitud_valores = 9;
            for ($i = 0; $i < $n_periodos; $i++) {
                $plani_id = $planila_periodo[$i];
                $tipo     = $tipo_reportes[$i];

                if ($plani_id > 0 && !$ejecucion_unica) {
                    $respuesta = $this->planilla_model->print_planilla_isss($plani_id, $usuarios, $tipo, 1, true, $consolidado);
                    //die(print_r($respuesta));
                    if ($respuesta) {
                        //Se trate de archivo txt generado
                        //Leer el archivo creado
                        $file_txt = fopen("uploads/txt_planilla/datos_planilla.txt", "r") or die("Problemas en leer el archivo");
                        while (!feof($file_txt)) {
                            $fila_empleado = fgets($file_txt);
                            $identificador_unico = substr($fila_empleado, 0, 27);
                            // echo $identificador_unico.'<br />'; 
                            // echo substr($fila_empleado, 0,67).'<br />';
                            // echo substr($fila_empleado,  67,9).' SALARIO<br />';
                            // echo substr($fila_empleado, 76,9).' PAGO<br />';
                            // echo substr($fila_empleado,  85,9).' VACA<br />';
                            // echo substr($fila_empleado, 94).' FINAL<br />';

                            if (array_key_exists($identificador_unico, $identificar_empleado)) {
                                $mantener_inicio = substr($fila_empleado, 0, 67);
                                $fila_empleado_existe = $identificar_empleado[$identificador_unico];
                                $salario_final_1  = ltrim(substr($fila_empleado, 67, $longitud_valores), 0);
                                $pago_adicional_1 = ltrim(substr($fila_empleado, 76, $longitud_valores), 0);
                                $monto_vacacion_1 = ltrim(substr($fila_empleado, 85, $longitud_valores), 0);

                                $salario_final_2  = ltrim(substr($fila_empleado_existe, 67, $longitud_valores), 0);
                                $pago_adicional_2 = ltrim(substr($fila_empleado_existe, 76, $longitud_valores), 0);
                                $monto_vacacion_2 = ltrim(substr($fila_empleado_existe, 85, $longitud_valores), 0);

                                $salario_final_3  = str_pad(($salario_final_1 + $salario_final_2), $longitud_valores, '0', STR_PAD_LEFT);
                                $pago_adicional_3 = str_pad(($pago_adicional_1 + $pago_adicional_2), $longitud_valores, '0', STR_PAD_LEFT);;
                                $monto_vacacion_3 = str_pad(($monto_vacacion_2 + $monto_vacacion_2), $longitud_valores, '0', STR_PAD_LEFT);;
                                $mantener_final = substr($fila_empleado, 94);

                                $nueva_fila_empleado = $mantener_inicio . $salario_final_3 . $pago_adicional_3 . $monto_vacacion_3 . $mantener_final;
                                $identificar_empleado[$identificador_unico] = $nueva_fila_empleado;
                            } else {
                                $identificar_empleado[$identificador_unico] = $fila_empleado;
                            }
                            array_push($pln_excel_iss, utf8_encode($fila_empleado));
                            //fputs($file_txt_consolidado, $fila_empleado);
                            array_push($pln_excel_iss2, $fila_empleado);
                        }
                        fclose($file_txt);
                    }

                    // print_r($pln_excel_iss); die();

                    // Se verifica que se imprimira el excel
                    if ($imprimir_excel != null && $imprimir_excel > 0) {
                        $filename             = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                        $data['table_header'] = "Planilla de ISSS";
                        $data['filename']     = $filename;
                        $data['pln_registro'] = $pln_excel_iss;
                        $html                 = $this->load->view('personal/planilla/consulta_pla_print_isss_excel', $data, true);
                        echo $html;
                        die();
                    }
                }
            }
        }

        if ($txt_consolidado) {
            // $fila_todo_empleado = implode("", $pln_excel_iss2);
            $fila_todo_empleado = implode("", $identificar_empleado); //imprimir consolidado
            //print_r($pln_excel_iss); die();
            fputs($file_txt_consolidado, $fila_todo_empleado);
            fclose($file_txt_consolidado);
            header("Content-Type: application/octet-stream");
            header('Content-Disposition: attachment; filename="datos_planilla_consolidado.txt"');
            header("Location: " . $base_url . "uploads/txt_planilla/datos_planilla_consolidado.txt");
        }
    }

    public function pla_print_consolidado($tipo_consolidado = 2, $es_excel = 0)
    {
        //tipo_consolidado == 1 solo con numero de cuenta
        //tipo_consolidado == 2 sin numero de cuenta
        satelite_validar();
        //add by René Castaneda. 22/08/2017
        /*=================================================================================*/
        //          GENERAR ARCHIVO PRN CONSOLIDADO CON CUENTAS DE BANCO CREDOMATIC
        /*=================================================================================*/
        if ($tipo_consolidado == 'prn') {
            $this->generar_archivo_prn();
            die('Exito!');
        }
        if ($tipo_consolidado == 'rpt') {
            $this->generar_archivo_hipotecario();
            die('Exito!');
        }
        /*=================================================================================*/
        //         FIN GENERAR ARCHIVO PRN CONSOLIDADO CON CUENTAS DE BANCO
        /*=================================================================================*/

        $tipo_reportes = $this->input->post('tipo_reporte_consolidado'); // Tipo de reporte
        $planila_periodo = $this->input->post('planilla_consolidado');

        if (count($planila_periodo) > 0 and $es_excel == 0) {
            //que no se trate de un consolidado en excel y el array tenga al menos un elemento
            if (file_exists("uploads/txt_planilla/datos_planilla_consolidado.txt")) {
                unlink("uploads/txt_planilla/datos_planilla_consolidado.txt"); //eliminar el archivo si existiese
            }
            $file_txt_consolidado = fopen("uploads/txt_planilla/datos_planilla_consolidado.txt", "w") or die("Problemas en creación del archivo");
        }
        $txt_consolidado = true;
        $consolidado     = array($tipo_consolidado, $es_excel);
        //die(print_r($consolidado));
        $usuarios = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
        $n_periodos = count($planila_periodo);
        if ($es_excel and $n_periodos == 1) {
            //redirecionar a un reporte normal de solo una planilla
            $this->imprimir_planilla_excel($planila_periodo[0], $tipo_reportes[0], $_POST['plaza2']);
        }
        $html_consolidado_excel = "";
        $totales_de_planilla    = array();
        $total_saldo_bnk        = array();
        $total_salario          = array();
        for ($i = 0; $i < $n_periodos; $i++) {
            $pla_id = $planila_periodo[$i];
            $tipo   = $tipo_reportes[$i];
            if ($pla_id > 0) {
                if ($this->gsatelite->get_parametro('FORMATO_ARCHIVO_BANCO') == 2 && $es_excel == 0) {
                    $respuesta = $this->planilla_model->print_planilla_bnk($pla_id, $usuarios, $tipo, 1, true, $consolidado);
                } else {
                    if ($_POST['plaza2'] != '') {
                        $respuesta = $this->planilla_model->print_planilla_emi_plazas($pla_id, $usuarios, $tipo, 1, true, $consolidado);
                    } else {

                        $respuesta = $this->planilla_model->print_planilla_emi($pla_id, $usuarios, $tipo, 1, true, $consolidado);
                    }
                }

                if ($respuesta and $es_excel == 0) {
                    // se trate de archivo txt generado y no sea excel
                    //Leer el archivo creado
                    $file_txt          = fopen("uploads/txt_planilla/datos_planilla.txt", "r") or die("Problemas en leer el archivo");
                    $total_saldo_bnk[] = $respuesta['total'];
                    $total_salario[]   = $respuesta[1]; // Salario por empleado agregado al txt
                    while (!feof($file_txt)) {
                        $fila_empleado = fgets($file_txt);
                        fputs($file_txt_consolidado, $fila_empleado);
                    }
                    fclose($file_txt);
                } elseif (count($respuesta) > 0 and $es_excel == 1) {
                    //se trata de un excel
                    //capturar los datos cuando se trate de un consolidado de excel
                    $html_consolidado_excel .= $respuesta[0]; //html
                    $totales_de_planilla[] = $respuesta[1];
                }
            }
        }
        /*         * ********************* Última fila para el archivo .bnk ***************************** */

        $fijo2      = $respuesta[0]['fijo'];
        $cuenta_emp = $respuesta[0]['cuenta'];
        $periodo    = $respuesta[0]['periodo'];

        // if($total_saldo_bnk > 0 ){
        //     $suma=array_sum($total_saldo_bnk);
        //die(print_r($total_salario));
        if ($total_salario[1] > 0) {
            // Se verifica que el array no se encuentre igual a cero.
            $salarios_emp = array_sum($total_salario);

            // $su = explode('.',$suma);
            // $sueldo = $su[0].$su[1];
            // $suma_salario = str_pad($sueldo, 9, '0', STR_PAD_LEFT);
            $salarios_emp          = number_format($salarios_emp, 2);
            $posicion_coincidencia = strpos($salarios_emp, ',');
            if ($posicion_coincidencia == true) {
                $sin_coma     = explode(',', $salarios_emp);
                $salarios_emp = $sin_coma[0] . $sin_coma[1];
            }
            $su           = explode('.', $salarios_emp);
            $sueldo       = $su[0] . $su[1];
            $suma_salario = str_pad($sueldo, 9, '0', STR_PAD_LEFT);
            $archivo_txt  = $fijo2 . '          ' . $cuenta_emp . $periodo . $suma_salario;

            fputs($file_txt_consolidado, $archivo_txt);
            fputs($file_txt_consolidado, chr(13) . chr(10));
        }
        //}
        /*         * **************************************************************************************** */

        if (trim($html_consolidado_excel) != "" and $n_periodos > 1) {

            $t1 = $t2 = $t3 = $t4 = $t5 = $t6 = $t7 = $t8 = $t9 = $t10 = $t11 = $t12 = $t13 = $t14 = $t15 = $t16 = $t17 = $t18 = $t19 = $t20 = $t21 = 0;
            foreach ($totales_de_planilla as $fila_pla) {
                $t1 += $fila_pla['t1'];
                $t2 += $fila_pla['t2'];
                $t3 += $fila_pla['t3'];
                $t4 += $fila_pla['t4'];
                $t5 += $fila_pla['t5'];
                $t6 += $fila_pla['t6'];
                $t7 += $fila_pla['t7'];
                $t8 += $fila_pla['t8'];
                $t9 += $fila_pla['t9'];
                $t10 += $fila_pla['t10'];
                $t11 += $fila_pla['t11'];
                $t12 += $fila_pla['t12'];
                $t13 += $fila_pla['t13'];
                $t14 += $fila_pla['t14'];
                $t15 += $fila_pla['t15'];
                $t16 += $fila_pla['t16'];
                $t17 += $fila_pla['t17'];
                $t18 += $fila_pla['t18'];
                $t19 += $fila_pla['t19'];
                $t20 += $fila_pla['t20'];
                $t21 += $fila_pla['t21'];
            }
            $data['total_salario_final']     = $t1;
            $data['total_ing_comision']      = $t2;
            $data['total_ing_anticipo']      = $t3;
            $data['total_ing_vacacion']      = $t4;
            $data['total_ing_prima_vaca']    = $t5;
            $data['total_ing_depreciacion']  = $t6;
            $data['total_ing_premio']        = $t7;
            $data['total_ing_otros']         = $t8;
            $data['total_ing_total']         = $t9;
            $data['renta']                   = $t10;
            $data['afp']                     = $t11;
            $data['isss']                    = $t12;
            $data['total_des_anticipo']      = $t13;
            $data['total_des_prestamo_ban']  = $t14;
            $data['total_des_emi_fam']       = $t15;
            $data['total_des_prestamos_int'] = $t16;
            $data['des_otros']               = $t17;
            $data['des_total']               = $t18;
            $data['cancelar']                = $t19;
            $data['afp_patronal']            = $t20;
            $data['isss_patronal']           = $t21;

            //encabezado del reporte
            $encabezado = "<h3>" . $this->gsatelite->get_parametro('SYS_EMPRESA') . "</h3>";
            $encabezado .= "<h3>Generación de planilla</h3>";
            $data['encabezado']       = "";
            $data['usuario']          = $usuarios;
            $data['detalle_planilla'] = $html_consolidado_excel;
            if ($_POST['plaza2'] != '') {
                $this->load->view('personal/planilla/imprimir_planilla_excel_consolidado_plazas', $data);
            } else {
                $this->load->view('personal/planilla/imprimir_planilla_excel_consolidado', $data);
            }
        } elseif ($es_excel == 0) {

            fclose($file_txt_consolidado);

            if ($txt_consolidado) {
                $base_url = base_url();
                if ($this->gsatelite->get_parametro('FORMATO_ARCHIVO_BANCO') == 2) {
                    $fecha = date('Y-m-d');
                    $var   = explode('-', $fecha);
                    $dia   = $var[0] . $var[1] . $var[2];
                    $hora  = date('H:i');
                    $hr    = explode(':', $hora);
                    $hora  = $hr[0] . $hr[1];

                    $archivo = "PLA_ACL" . $dia . $hora . ".bnk-";
                    @copy("uploads/txt_planilla/datos_planilla_consolidado.txt", "uploads/txt_planilla/" . $archivo);
                    header("Content-Type: application/octet-stream");
                    header('Content-Disposition: attachment; filename="' . $archivo . '"');
                    header("Location: " . $base_url . "uploads/txt_planilla/" . $archivo);
                    //readfile($base_url."uploads/txt_planilla/datos_planilla.txt");
                } else {
                    //header('Content-type: text/plain');
                    //readfile($base_url."uploads/txt_planilla/datos_planilla.txt");
                    header("Content-Type: application/octet-stream");
                    header('Content-Disposition: attachment; filename="datos_planilla_consolidado.txt"');
                    header("Location: " . $base_url . "uploads/txt_planilla/datos_planilla_consolidado.txt");
                }
            }
            die("<h1>ERROR EN LA CRACIÓN DEL ARCHIVO</h1>");
            header("Content-Type: application/octet-stream");
            header('Content-Disposition: attachment; filename="datos_planilla_consolidado.txt"');
            header("Location: " . $base_url . "uploads/txt_planilla/datos_planilla_consolidado.txt");
        }
    }

    public function generar_planilla_index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['slctd_tpl'] = ($_POST) ? $this->input->post('tpl_id') : "";
            $data['slctd_pla'] = ($_POST) ? $this->input->post('pla_id') : "";
            $data['titulo_personal'] = "Generación de planilla";
            $data['tipo_planilla']   = $this->planilla_model->get_select_tipo_planillas_actuales();
            $data['tipo_puesto']     = $this->planilla_model->get_tipo_puesto();
            $data['titulo_personal'] = "Generación de planilla";
            $this->_cargarvista(null, $data);
        }
    }

    public function generar_planilla()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

            if ($this->input->post('periodo') && $this->input->post('tipo_planilla')) {
                $this->db->where('ddd_id_pla', $this->input->post('periodo'))->delete('ddd_detalle_descuento');
                $this->db->where('ddi_id_pla', $this->input->post('periodo'))->delete('ddi_detalle_ingreso');
                $data['tpl_id']      = $this->input->post('tipo_planilla');
                $data['id_planilla'] = $this->input->post('periodo');

                /* FUNCION DEFASADA YA NO APLICA */
                $id_tipo_planilla_aplica_inde = 0; //$this->gsatelite->get_parametro('ID_TIPO_PLANILLA_APLICA_INDEMNIZACION');
                if ($this->input->post('tipo_planilla') == $id_tipo_planilla_aplica_inde) {
                    //preguntar si corresponde al id para aplicar el calculo
                    $generar_indemnizacion = $this->planilla_model->calcular_indemnizacion($data);
                }
                /* FUNCION DEFASADA YA NO APLICA */
                $id_tipo_planilla_aplica_aguinaldo = 0; //$this->gsatelite->get_parametro('ID_TIPO_PLANILLA_APLICA_AGUINALDO');
                if ($this->input->post('tipo_planilla') == $id_tipo_planilla_aplica_aguinaldo) {
                    //preguntar si corresponde al id para aplicar el calculo
                    $generar_aguinaldo = $this->planilla_model->calcular_aguinaldo($data);
                }

                $recalculo_jun = $this->gsatelite->get_parametro('ID_RECALCULO_JUNIO');
                $recalculo_dic = $this->gsatelite->get_parametro('ID_RECALCULO_DICIEMBRE');
                $tipo_planilla = $this->input->post('tipo_planilla');
                $id_planilla   = $this->input->post('periodo');

                $this->db->join('tpl_tipo_planilla', 'tpl_id=pla_id_tpl');
                $periodo = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $id_planilla));

                $mes = date('n', strtotime($periodo[0]['pla_fecha_inicio']));
                $isr = $this->planilla_model->get_isr($tipo_planilla, $mes);

                $where_anteriores = array(
                    "DATE_FORMAT(pla_fecha_inicio,'%Y%m')" => formatear_fecha('Ym', $periodo[0]['pla_fecha_inicio']),
                    "pla_fecha_inicio < " => formatear_fecha('Y-m-d', $periodo[0]['pla_fecha_inicio']),
                    "pla_id_tpl" => $periodo[0]['pla_id_tpl']
                );
                $pla_ant = $this->gsatelite->count('pla_planilla', $where_anteriores);
                if (isset($isr[0]['tis_recalculo'])) {
                    if (($pla_ant + 1) == $periodo[0]['tpl_cantidad']) {
                        $tis_isr = array_column($isr, 'tis_recalculo', 'tis_id');
                        if (array_key_exists($recalculo_jun, $tis_isr) || array_key_exists($recalculo_dic, $tis_isr)) {
                            $recalculo = (array_key_exists($recalculo_jun, $tis_isr)) ? $tis_isr[$recalculo_jun] : $tis_isr[$recalculo_dic];
                        } else {
                            $recalculo = $isr[0]['tis_recalculo'];
                        }
                    } else {
                        $recalculo = $isr[0]['tis_recalculo'];
                    }
                } else {
                    $recalculo = 0;
                }
                // $recalculo = isset($isr[0]['tis_recalculo']) ? $isr[0]['tis_recalculo'] : 0;
                // var_dump($recalculo, $data);die();
                if ($recalculo == 1) {
                    // si es recalculo
                    $planilla = $this->driver->generar_planilla($data, 1);
                    //$planilla = $this->driver->generar_recalculo($data);
                } else {
                    // si es planilla normal
                    $planilla = $this->driver->generar_planilla($data);
                }
                $id_pla = $this->input->post('periodo');
                $ingreso_salario = $this->gsatelite->get_parametro('INGRESO_SALARIO');
                // $ids=explode(',', $ingreso_salario);
                // if(count($ids)>1){
                //     $ingreso_in=$ids;
                // }else{
                //     $ingreso=$ingreso_salario;
                // }
                $data["periodo"]         = $periodo[0]["tpl_nombre"] . ' - ' . $periodo[0]["pla_codigo"] . ' (' . formatear_fecha("d-m-Y", $periodo[0]["pla_fecha_inicio"]) . ' / ' . formatear_fecha("d-m-Y", $periodo[0]["pla_fecha_fin"]) . ')';
                $data['titulo_personal'] = "Generación de planilla";
                $data['informacion']     = $this->planilla_model->tabla_generada_planilla($id_pla, $ingreso_salario);
                $this->_cargarvista(null, $data);
            }
        }
    }

    public function obtener_periodo_planilla($tipo_estado = 0)
    {
        satelite_validar();
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $option     = "";
            $var        = '<option value="0" selected >Seleccione un período de planilla</option>';
            $t_planilla = $this->input->post('t_planilla');
            $tipo       = $this->input->post('tipo');
            if ($tipo_estado) {
                $periodos = $this->planilla_model->obtener_periodo_planilla2($t_planilla, $tipo);
            } else {
                $periodos = $this->planilla_model->obtener_periodo_planilla($t_planilla, $tipo);
            }
            foreach ($periodos as $key) {
                switch ($key['pla_estado']) {
                    case '1':
                        $estado = "Creada";
                        break;
                    case '2':
                        $estado = "Generada";
                        break;
                    case '3':
                        $estado = "Autorizada";
                        break;
                    default:
                        break;
                }
                $var .= '<option value="' . $key['pla_id'] . '" data-fec_ini="' . formatear_fecha('d-m-Y', $key['pla_fecha_inicio']) . '" data-fec_fin="' . formatear_fecha('d-m-Y', $key['pla_fecha_fin']) . '" >';
                $var .= formatear_fecha('d-m-Y', $key['pla_fecha_inicio']) . "  --  " . formatear_fecha('d-m-Y', $key['pla_fecha_fin']) . " " . $estado . "</option>";
            }

            $arreglo = array(
                "drop" => $var,
            );

            echo json_encode($arreglo);
        }
    }

    public function boleta_vacacion()
    {
        satelite_validar();
        $data['titulo_personal'] = "Boleta de Vacación";
        $this->_cargarvista(null, $data);
    }

    public function get_empleado_boleta_vacacion()
    {
        satelite_validar();
        $mes  = $this->input->post('mes_elegido');
        $tipo = $this->input->post('tipo');

        if ($this->input->post('mes_elegido') != "" and $this->input->post('mes_elegido') > 0) {
            $data['esreporte'] = ($tipo != "" and $tipo != null) ? 1 : 0;
            $mes = ($mes < 10) ? '0' . $mes : $mes;
            $fecha             = date('Y-' . $mes . '-01');
            $data['consulta']  = $this->planilla_model->get_cumplen_anio_laboral($fecha);
            //die($this->db->last_query());
            $data['mes'] = $mes;
            $html        = $this->load->view('personal/planilla/get_empleado_boleta_vacacion', $data, true);
        }

        if ($tipo == null or $tipo == "") {
            echo $html;
        } else if ($tipo == 2) {
            $this->load->library('pdf');
            $html_header = $this->load->view('reporte/header', array('titulo' => 'Empleadas/os con año laboral'), true);
            $reporte     = $this->pdf->makePDF($html_header . $html, 'L');
        } else {
            header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            header("Content-Disposition: attachment;filename=Reporte_empleados_anio_laboral.xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $html;
        }
    }

    public function generar_boleta_vacacion($id_empleado)
    {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('emp_empleado', $id_empleado);
        $this->load->library('EnLetras');
        $registro_emp = $this->gsatelite->get_registro('emp_empleado', 'emp_id', $id_empleado);
        //el salario de 15 dias división entre 2
        $quince   = round(($registro_emp->emp_salario / 2), 2);
        $mas      = round($quince * 0.30, 2);
        $ntotal   = $quince + $mas;
        $isss_afp = 0;
        $total_p  = $ntotal - $isss_afp;

        $deci    = (string) number_format($total_p, 2);
        $decimal = str_replace('.', '', substr($deci, strpos($deci, ".")));

        $data['sueldo_prom']     = number_format($quince, 2);
        $data['mas']             = number_format($mas, 2);
        $data['total1']          = number_format($ntotal, 2);
        $data['apf_isss']        = number_format($isss_afp, 2); //pendiente
        $data['total_pagar']     = number_format($total_p, 2);
        $data['empleado']        = $registro_emp;
        $data['cantidad_letras'] = $this->enletras->ValorEnLetras(floor($total_p), "");
        $data['fraccion']        = "$decimal/100";

        $this->load->library('pdf');
        $html_header = '';
        //$html_header  = $this->load->view('reporte/header', array('titulo' => 'Productos más vendidos'), true);
        $html    = $this->load->view('personal/planilla/detalle_boleta_vacacion', $data, true);
        $reporte = $this->pdf->makePDF($html_header . $html, 'P');
    }

    public function detalle_pla_bnk()
    {
        satelite_validar();
        $tipo   = 'salario';
        $pla_id = $this->input->post('planilla');
        $forma_pago = $this->input->post('forma_pago');
        if ($pla_id > 0) {
            $filtro = 0;
            if ($forma_pago > 0) {
                $filtro = $forma_pago;
            }
            $usuarios = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            // if($this->gsatelite->get_parametro('FORMATO_ARCHIVO_BANCO')==2){
            $txt = $this->planilla_model->print_detalle_planilla_bnk($pla_id, $usuarios, $tipo, null, false, null, $filtro);
            // }
            // else{
            //     $txt = $this->planilla_model->print_planilla_emi($pla_id,$usuarios,$tipo, 1,true);
            // }
            // die(var_dump($txt));
            //die(print_r($txt));
            $tipo_pla = $this->gsatelite->get_campo('pla_planilla', 'pla_id_tpl', array('pla_id' => $pla_id));
            $nombre_planilla = $this->gsatelite->get_campo('tpl_tipo_planilla', 'tpl_nombre', array('tpl_id' => $tipo_pla));
            if ($txt) {
                $fecha          = date('Y-m-d');
                $var            = explode('-', $fecha);
                $dia            = $var[0] . $var[1] . $var[2];
                $hora           = date('H:i');
                $hr             = explode(':', $hora);
                $hora           = $hr[0] . $hr[1];
                $nombre_reporte = "PLA_ACL" . $dia . $hora;
                $archivo        = "PLA_ACL" . $dia . $hora . ".bnk";

                $base_url = base_url();

                $data['planilla']        = $txt;
                $data['nombre_planilla'] = $nombre_planilla;
                $data['archivo']         = $archivo;
                $html                    = $this->load->view('personal/planilla/detalle_planilla', $data, true);
                //$this->pdf->reportePDF('personal/planilla/detalle_planilla.php',$txt,'');
                $GLOBALS['detalle_pla']    = 1;
                $GLOBALS['nombre_reporte'] = $nombre_reporte;
                $reporte                   = $this->pdf->makePDF($html);
            }
        }
    }

    /**
     * @author René Castaneda
     * @since 2017-07-22
     * @return generación de la partida contable apartir de la autorización de la planilla
     * @return en por defecto el metodo crea la partida, en caso de que la peticion sea para
     * @return devolver los datos nada mas el parametro $crear debe ser false
     */
    public function partida_contable_planilla($id_planilla, $fecha = false, $crear = true)
    {
        //El falg $crear indica si deseamos la creacion de la partida o la devolucion de los datos
        if ($crear) {
            //Obtener la planilla y la fecha para la partida
            $pla_datos     = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $id_planilla));
            $tpl_name      = $this->gsatelite->get_campo('tpl_tipo_planilla', 'tpl_nombre', array('tpl_id' => $pla_datos[0]['pla_id_tpl']));
            $pla_fecha_fin = $pla_datos[0]['pla_fecha_fin'];
            if ($pla_fecha_fin) {
                $pct_fecha = $pla_fecha_fin;
            } else {
                $pct_fecha = date('Y-m-d H:i:s');
            }

            //Concepto por factura sin afectar inventario
            $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 14));
            if (count($pct_concepto) > 0) {
                $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
            } else {
                $pct_concepto = 'Concepto no definido';
            }

            $origen = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_tabla' => 'pla_planilla'));

            $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');
            $tipo_partida    = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('GASTO'));
            $consultar       = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $tipo_partida));
            if (count($consultar) > 0) {
                $id_tipo_partida = $tipo_partida;
            }

            $dato_planilla       = $this->planilla_model->get_informacion_planilla(array('pla_id' => $id_planilla));
            $concepto_partida    = "Pago Planilla - Código: " . $dato_planilla['pla_codigo'];
            $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo');
            $codigo_planilla     = ($dato_planilla['pla_codigo']) ? $dato_planilla['pla_codigo'] : '';
            $array_insert        = array(
                'pct_id_orp' => (count($origen) > 0) ? $origen[0]['orp_id'] : null, 
                'pct_id_tpd' => ($id_tipo_partida > 0) ? $id_tipo_partida : null, 
                'pct_concepto' => $pct_concepto . " " . trim($tpl_name) . " " . $dato_planilla['pla_codigo'], 
                'pct_total' => 0, //posteriormente se actualizará 
                'pct_fecha' => $pct_fecha, 
                'pct_correlativo' => ($correlativo_partida > 0) ? ($correlativo_partida + 1) : 1, 
                'pct_codigo' => $codigo_planilla, 
                'pct_estado' => 1, 
                'pct_usu_crea' => $this->tank_auth->get_user_id(), 
                'pct_fecha_crea' => date('Y-m-d H:i:s'), 
                'pct_usu_mod' => $this->tank_auth->get_user_id(), 
                'pct_fecha_mod' => date('Y-m-d H:i:s')
            );

            $datos_ingresos       = $this->planilla_model->get_informacion_planilla_ingresos(array('ddi_id_pla' => $id_planilla));
            $datos_descuentos     = $this->planilla_model->get_informacion_planilla_descuentos(array('ddd_id_pla' => $id_planilla));
            $datos_descuentos_afp = $this->planilla_model->get_informacion_planilla_descuentos_afp(array('ddd_id_pla' => $id_planilla));
            $datos_salario        = $this->planilla_model->get_informacion_planilla_pagos(array($id_planilla), array('txe_id_tpl' => $dato_planilla['pla_id_tpl']));
            /*print_r($datos_ingresos);
            print_r($datos_descuentos);
            print_r($datos_descuentos_afp);
            print_r($datos_salario); die();*/
            $id_partida = 0;
            if (count($datos_salario) > 0) {
                //si existen datos procesar contablemente
                $id_partida = $this->gsatelite->ingresar('pct_partida_contable', $array_insert);

                //actualizar la partida en la planilla
                $this->gsatelite->actualizar_array('pla_planilla', array('pla_id_pct' => $id_partida), array('pla_id' => $id_planilla));

                //GENERAR LOS DETALLES PARA LA PARTIDA CONTABLE
                $total_partida        = 0;
                $array_insert_ingreso = array();
                foreach ($datos_ingresos as $fila_in) {
                    $total_partida += $fila_in['valor'];
                    $array_insert_ingreso[] = array(
                        'dpc_id_cnt' => $fila_in['id_cuenta_contable'], 'dpc_id_pct' => $id_partida, 
                        'dpc_concepto' => 'Ingreso planilla ' . $codigo_planilla . ' - ' . $fila_in['centro_costo'], 'dpc_debe' => $fila_in['valor'], 
                        'dpc_haber' => 0, 
                        'dpc_estado' => 1, 
                        'dpc_usu_crea' => $this->tank_auth->get_user_id(), 
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'), 
                        'dpc_usu_mod' => $this->tank_auth->get_user_id(), 
                        'dpc_fecha_mod' => date('Y-m-d H:i:s')
                    );

                    // $n_detalles_ingresos = $this->gsatelite->ingresar('dpc_detalle_partida', $array_insert_ingreso); //ejecutar uno a uno

                }

                if (count($array_insert_ingreso) > 0) {
                    $n_detalles_ingresos = $this->gsatelite->ingresar('dpc_detalle_partida', $array_insert_ingreso, true); //ejecutar insert batch
                }

                //actualizar el total de partida
                $this->gsatelite->actualizar_array('pct_partida_contable', array('pct_total' => $total_partida), array('pct_id' => $id_partida));

                $array_insert_descuento = array();
                foreach ($datos_descuentos as $fila_des) {
                    $array_insert_descuento[] = array(
                        'dpc_id_cnt' => $fila_des['id_cuenta_contable'], 
                        'dpc_id_pct' => $id_partida, 
                        'dpc_concepto' => 'Descuento planilla ' . $codigo_planilla, 
                        'dpc_debe' => 0, 
                        'dpc_haber' => $fila_des['valor'], 
                        'dpc_estado' => 1, 
                        'dpc_usu_crea' => $this->tank_auth->get_user_id(), 
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'), 
                        'dpc_usu_mod' => $this->tank_auth->get_user_id(), 
                        'dpc_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    // $n_detalles_descuentos = $this->gsatelite->ingresar('dpc_detalle_partida', $array_insert_descuento); //ejecutar uno a uno
                }

                if (count($array_insert_descuento) > 0) {
                    $n_detalles_descuentos = $this->gsatelite->ingresar('dpc_detalle_partida', $array_insert_descuento, true); //ejecutar insert batch
                }

                $array_insert_descuento_afp = array();
                foreach ($datos_descuentos_afp as $fila_des_afp) {
                    $array_insert_descuento_afp[] = array(
                        'dpc_id_cnt' => $fila_des_afp['id_cuenta_contable'], 
                        'dpc_id_pct' => $id_partida, 
                        'dpc_concepto' => 'Descuento planilla ' . $codigo_planilla, 
                        'dpc_debe' => 0, 
                        'dpc_haber' => $fila_des_afp['valor'], 
                        'dpc_estado' => 1, 
                        'dpc_usu_crea' => $this->tank_auth->get_user_id(), 
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'), 
                        'dpc_usu_mod' => $this->tank_auth->get_user_id(), 
                        'dpc_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    // $n_detalles_descuentos = $this->gsatelite->ingresar('dpc_detalle_partida', $array_insert_descuento); //ejecutar uno a uno
                }
                if (count($array_insert_descuento_afp) > 0) {
                    $n_detalles_descuentos_afp = $this->gsatelite->ingresar('dpc_detalle_partida', $array_insert_descuento_afp, true); //ejecutar insert batch
                }

                $array_insert_pago = array();

                foreach ($datos_salario as $fila_pa) {
                    $array_insert_pago[] = array(
                        'dpc_id_cnt' => $fila_pa['id_cuenta_contable'], 
                        'dpc_id_pct' => $id_partida, 
                        'dpc_concepto' => 'Salario planilla ' . $codigo_planilla, 
                        'dpc_debe' => 0, 
                        'dpc_haber' => ($fila_pa['ingresos'] - $fila_pa['descuentos']), 
                        'dpc_estado' => 1, 
                        'dpc_usu_crea' => $this->tank_auth->get_user_id(), 
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'), 
                        'dpc_usu_mod' => $this->tank_auth->get_user_id(), 
                        'dpc_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    //$n_detalles_pagos = $this->gsatelite->ingresar('dpc_detalle_partida', $array_insert_pago);
                }
                if (count($array_insert_pago) > 0) {
                    $n_detalles_pagos = $this->gsatelite->ingresar('dpc_detalle_partida', $array_insert_pago, true); //ejecutar insert batch
                }
            }
            return $id_partida;
        } else {
            //Si se necesita retornar el arreglo en lugar de crear la partida
            //El parametro recibido $id_planilla en este caso hace referencia al tipo de planilla
            $id_tipo_pla = $id_planilla;
            //$datos_x_planilla = [];
            $datos_todas_planillas = [];
            //Obtener las planillas con el tipo de id seleccionado, pero que ya esten autorizadas
            $planillas = $this->contabilidad_model->get_planilla_x_tipo(array('tpl_id' => $id_tipo_pla, 'DATE(pla_fecha_pago)' => $fecha, 'pla_id_pct' => null, 'pla_estado' => 3));
            //print_r($planillas); die();
            foreach ($planillas as $key => $planilla) {
                $datos_x_planilla = [];
                $dato_planilla    = $this->planilla_model->get_informacion_planilla(array('pla_id' => $planilla['pla_id']));
                //print_r($dato_planilla); die();
                $datos_ingresos       = $this->planilla_model->get_informacion_planilla_ingresos(array('ddi_id_pla' => $planilla['pla_id']));
                $datos_descuentos_provision     = $this->planilla_model->get_informacion_planilla_descuentos_patrono(array('ddd_id_pla' => $planilla['pla_id']), 1);
                if (count($datos_descuentos_provision) > 0) {
                    $datos_ingresos = array_merge($datos_ingresos, $datos_descuentos_provision);
                }
                $datos_descuentos_provision_afp     = $this->planilla_model->get_informacion_planilla_descuentos_afp_patrono(array('ddd_id_pla' => $planilla['pla_id']), 1);
                if (count($datos_descuentos_provision_afp) > 0) {
                    $datos_ingresos = array_merge($datos_ingresos, $datos_descuentos_provision_afp);
                }

                $datos_descuentos     = $this->planilla_model->get_informacion_planilla_descuentos(array('ddd_id_pla' => $planilla['pla_id']));

                $datos_descuentos_afp = $this->planilla_model->get_informacion_planilla_descuentos_afp(array('ddd_id_pla' => $planilla['pla_id']));

                $datos_descuentos_patrono_afp     = $this->planilla_model->get_informacion_planilla_descuentos_afp_patrono(array('ddd_id_pla' => $planilla['pla_id']), 0);

                if (count($datos_descuentos_patrono_afp) > 0) {
                    $datos_descuentos_afp = array_merge($datos_descuentos_afp, $datos_descuentos_patrono_afp);
                }

                $datos_salario        = $this->planilla_model->get_informacion_planilla_pagos(array($planilla['pla_id']));
                //var_dump($datos_salario);die();
                //print_r($this->db->last_query());die();
                $datos_descuentos_patrono     = $this->planilla_model->get_informacion_planilla_descuentos_patrono(array('ddd_id_pla' => $planilla['pla_id']), 0);

                if (count($datos_descuentos_patrono) > 0) {
                    $datos_salario = array_merge($datos_salario, $datos_descuentos_patrono);
                }
                //print_r($datos_salario); die();
                array_push($datos_x_planilla, $datos_ingresos);
                array_push($datos_x_planilla, $datos_descuentos);
                array_push($datos_x_planilla, $datos_descuentos_afp);
                array_push($datos_x_planilla, $datos_salario);
                //array_push($datos_x_planilla, $dato_planilla);//Son los datos como codigo etc

                array_push($datos_todas_planillas, $datos_x_planilla);
                unset($datos_x_planilla);
            }

            //return print_r($datos_todas_planillas); die();
            return $datos_todas_planillas;
        }
    }
    //de forma rapida
    public function generar_prn()
    {
        satelite_validar();
        $query = "
        SELECT 'T' letraT,'6877' identificador,'00029' codigo , REPLACE(dce_valor,'-','') nit, '1' correlativo,'PLAN 6877 1RA QUINC.AGOSTO' periodo, CONCAT(trim(emp_nombre),' ',trim(emp_apellido)) nombre_empleado, emp_numero_cuenta,
        REPLACE(ROUND(((SELECT SUM(d2.ddi_valor) from ddi_detalle_ingreso d2 where d2.ddi_id_pla=pla_id and d2.ddi_id_emp=emp_id)
         - (SELECT SUM(d3.ddd_valor) from ddd_detalle_descuento d3 where d3.ddd_id_pla=pla_id and d3.ddd_id_emp=emp_id)
        ),2),'.','') total_pagar
        ,
        ROUND(((SELECT SUM(d2.ddi_valor) from ddi_detalle_ingreso d2 where d2.ddi_id_pla=pla_id and d2.ddi_id_emp=emp_id)
         - (SELECT SUM(d3.ddd_valor) from ddd_detalle_descuento d3 where d3.ddd_id_pla=pla_id and d3.ddd_id_emp=emp_id)
        ),2) normal
         from emp_empleado
        JOIN ddi_detalle_ingreso on ddi_id_emp=emp_id
        JOIN pla_planilla on pla_id=ddi_id_pla
        JOIN tpl_tipo_planilla on tpl_id=pla_id_tpl
        JOIN dce_documento_emp on dce_id_emp=emp_id and dce_id_tde=2
        WHERE date_format(pla_fecha_inicio,'%Y-%m')='2017-08' and dce_id_tde=2 and emp_numero_cuenta!='' and emp_numero_cuenta is not null
        GROUP BY emp_id
        ORDER BY pla_id_tpl, pla_id, emp_id";
        $datos   = $this->db->query($query)->result_array();
        $linea   = array();
        $i       = 0;
        $linea[] = "B687700029                         20170814      1777343   66";
        foreach ($datos as $fila) {
            //25/18/13/32/35
            $i++;
            $linea_texto = str_pad(($fila['letraT'] . $fila['identificador'] . $fila['codigo'] . trim($fila['nit'])), 24, ' ', STR_PAD_LEFT);
            $linea_texto .= str_pad(($i . '20170814'), 19, ' ', STR_PAD_LEFT);
            $linea_texto .= str_pad(number_format($fila['normal'], 2, '', ''), 13, ' ', STR_PAD_LEFT);
            $linea_texto .= str_pad($fila['periodo'], 31, ' ', STR_PAD_LEFT);
            $linea_texto .= '     ';
            $linea_texto .= str_pad(substr(trim(strtoupper(utf8_decode($fila['nombre_empleado']))), 0, 30), 30, ' ', STR_PAD_RIGHT);
            $linea_texto .= str_pad(trim($fila['emp_numero_cuenta']), 9, ' ', STR_PAD_RIGHT);
            $linea[] = trim($linea_texto);
        }

        $ruta_carga = 'uploads/txt_planilla/';

        $nombre        = 'PLAN_6877_EMI_EL_SALVADOR_' . date('d-m-Y_H_i_s') . '.prn';
        $ruta_completa = $ruta_carga . $nombre;
        $separador     = chr(13) . chr(10);

        //$this->load->view('uatm/clesa/generar_archivo_clesa', $data, true);
        // $separador = chr(13);
        $texto_completo = implode($separador, $linea);

        $archivo        = fopen($ruta_completa, 'w+') or die('Sin permisos de escritura en el servidor');
        $texto_completo = trim($texto_completo);
        fputs($archivo, $texto_completo);
        fclose($archivo);
        header('Content-Type: text/html; charset=utf-8');
        header("Content-Type: application/octet-stream");
        header('Content-Disposition: attachment; filename="' . $nombre . '"');
        header("Location: " . base_url() . "uploads/txt_planilla/$nombre");
    }

    /**
     * @author René Castaneda
     * @since 2017-08-22
     * @return Generar archivo prn para banco credomatic (emi)
     */
    public function generar_archivo_prn(){
        $meses_array     = array('', 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
        $id_tipo_doc_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $config          = $this->gsatelite->get_parametro('SYS_CONFIG_PLA_PRN');
        $config          = (array) json_decode($config);
        // SI EL TIPO DE PLANILLA TIENE OTROS DATOS SE SUSTITUYE POR EL PRIMERO
        $tpls = implode(",", $this->input->post("tipo_planilla_consolidado"));
        $tpl_tbl = $this->gsatelite->get_tabla("tpl_tipo_planilla", array("tpl_id IN ($tpls)" => null))[0];//TOMAREMOS EL PRIMERO DE MOMENTO

        $correlativo_envio                     = $this->input->post('txtCorrelativoPRN'); //codigo de planilla
        $fecha_pago_planilla                   = $this->input->post('txtFechaPRN'); //fecha de planilla
        $identificador = (isset($tpl_tbl['tpl_identificador_prn'])&& trim($tpl_tbl['tpl_identificador_prn'])!="")? trim($tpl_tbl['tpl_identificador_prn']) : $config['IDENTIFICADOR'];
        $empresa_nombre = (isset($tpl_tbl['tpl_siglas_archivo_prn'])&&trim($tpl_tbl['tpl_siglas_archivo_prn'])!="")? mb_strtoupper(trim($tpl_tbl['tpl_siglas_archivo_prn'])) : $config['SIGLAS_ARCHIVO'];
        $letra = (isset($tpl_tbl['tpl_letra_archivo_prn'])&& trim($tpl_tbl['tpl_letra_archivo_prn'])!="")? mb_strtoupper(trim($tpl_tbl['tpl_letra_archivo_prn'])) : $config['LETRA'];
        $datos_complementario['letra']         = $letra;
        $datos_complementario['identificador'] = $identificador;
        $datos_complementario['codigo_pla']    = str_pad($correlativo_envio, 5, '0', STR_PAD_LEFT);
        //$datos_complementario['periodo_pla'] = 'PLAN 6877 1RA QUINC.AGOSTO';
        $id_tipo_doc_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $planillas       = $this->input->post('planilla_consolidado');

        if (count($planillas) <= 0 or !is_array($planillas)) {
            // condicnoar si existen los datos en el post
            $this->gsatelite->show_dialog('', 'personal/reportes/reporte_planilla', 'error', 'Perdida en el envío de datos, favor intentar de nuevo');
            die();
        }
        //'dce_id_tde' => $id_tipo_doc_nit, 
        $datos = $this->planilla_model->get_informacion_planilla_prn($planillas, array('emp_metodo_pago' => 1, 'TRIM(emp_numero_cuenta) !=' => '', 'emp_numero_cuenta IS NOT NULL' => null), $datos_complementario);
        // var_dump( $this->db->last_query() ); die();
        $linea      = array();
        $i          = 0;
        $total_pla  = 0;
        $fecha_pago = (trim($fecha_pago_planilla) != "") ? formatear_fecha("Ymd", $fecha_pago_planilla) : "";
        foreach ($datos as $fila) {
            //25/18/13/32/35
            $i++;
            $fecha_pago = ($fecha_pago == '') ? $fila['fecha_pago'] : $fecha_pago;
            $total_pla += number_format($fila['normal'], 2, '.', '');
            $document = str_pad(trim($fila['nit']), 14, ' ', STR_PAD_RIGHT);
            $linea_texto = str_pad(($fila['identificador'] . $fila['codigo'] . $document), 24, ' ', STR_PAD_LEFT);
            $linea_texto .= str_pad(($i . $fecha_pago), 19, ' ', STR_PAD_LEFT);
            $linea_texto .= str_pad(number_format($fila['normal'], 2, '', ''), 13, ' ', STR_PAD_LEFT);
            $linea_texto .= '     ';
            $linea_texto .= str_pad(($fila['periodo'] . (strtoupper($meses_array[intval($fila['mes_planilla'])]))), 31, ' ', STR_PAD_RIGHT);
            $linea_texto .= str_pad(substr(trim(strtoupper(utf8_decode($fila['nombre_empleado']))), 0, 30), 30, ' ', STR_PAD_RIGHT);
            $linea_texto .= str_pad(trim($fila['emp_numero_cuenta']), 9, ' ', STR_PAD_RIGHT);
            $linea[] = trim($linea_texto);
        }
        $total_final = number_format($total_pla, 2, '', '');

        $linea_inicio = str_pad(($config['LETRA_INICIO'] . $identificador . $datos_complementario['codigo_pla']), 24, ' ', STR_PAD_RIGHT);
        $linea_inicio .= str_pad((' ' . $fecha_pago), 19, ' ', STR_PAD_LEFT);
        $linea_inicio .= str_pad($total_final, 13, ' ', STR_PAD_LEFT) . str_pad($i, 5, ' ', STR_PAD_LEFT); // "   $i";
        //$linea_inicio = "B".$identificador."00029                         $fecha_pago      $total_final   $i";
        $ruta_carga = 'uploads/txt_planilla/';

        $nombre_archivo = 'PLAN_' . $identificador . '_' . $empresa_nombre . '_' . date('Ym') . '.prn';

        if (file_exists("uploads/txt_planilla/$nombre_archivo")) {
            unlink("uploads/txt_planilla/$nombre_archivo"); //eliminar el archivo si existiese
        }

        $ruta_completa = $ruta_carga . $nombre_archivo;
        $separador     = chr(13) . chr(10);

        $texto_completo = $linea_inicio . $separador . implode($separador, $linea);

        $archivo        = fopen($ruta_completa, 'w+') or die('Sin permisos de escritura en el servidor');
        $texto_completo = trim($texto_completo);
        fputs($archivo, $texto_completo);
        fclose($archivo);
        header('Content-Type: text/html; charset=utf-8');
        header("Content-Type: application/octet-stream");
        header('Content-Disposition: attachment; filename="' . $nombre_archivo . '"');

        //header('Content-type: application/txt');
        //header('Content-Transfer-Encoding: binary');
        //header('Content-Description: File Transfer');
        //header('Content-Transfer-Encoding: binary');
        //header('Cache-Control: must-revalidate');

        ob_clean(); //limpia(elimina) el bufer de salida, es decir limpia todo lo que ya no es necesario dado que ya se tiene lo que se quiere mostrar al usuario final en el navegador.
        flush(); //vacia todo el backend (codigo escrito) y trata de enviar todo lo que se tiene hasta el momento al navegador (usuario)
        //Mencionar que la linea del ob_clean(); fue incluida porque con ello hace que la salida del archivo sean legibles los caracteres raros (ejem. la ñ )

        readfile("uploads/txt_planilla/$nombre_archivo");
        #header("Location: " . base_url() . "uploads/txt_planilla/$nombre_archivo"); //para que esta linea funcione debe comentarse las lineas del ob_clean y flush.
        die();
    }

    public function generar_archivo_hipotecario()
    {
        $tipo_reportes = $this->input->post('tipo_reporte_consolidado'); // Tipo de reporte
        $planila_periodo = $this->input->post('planilla_consolidado');
        $n_periodos = count($planila_periodo);
        if ($n_periodos > 0) {
            $data['respuesta'] = $this->planilla_model->planilla_bnk_hipotec($planila_periodo);
            $html = $this->load->view('personal/planilla/detalle_hipotecario', $data, true);
        } else {
            $html = '<table style="width: 100%;"><tr><td style="text-align: center;">No se encontró información. Verifique los datos.</td></tr></table>';
        }
        $txt_rpt = $this->load->view('reporte/header', array('titulo' => '', 'solotitulo' => true), true);
        $txt_rpt = $txt_rpt . $html;
        $reporte = $this->pdf->makePDF($txt_rpt, 'P');
    }

    /**
     * Descripción:
     * Función para generar un archivo en excel con una planilla personalizada.
     * @author René Castaneda - Grupo Satélite
     * @since 2018-02-09
     * @param ninguno
     * @return excel-html
     */
    public function imprimir_planilla_excel_per($solototales = false, $totalizar_emp = false, $resumen = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $pla_id          = $this->input->post('planilla');
            $pla_tipo        = $this->input->post('tipo_planilla');
            $pla_consolidado = $this->input->post('planilla_consolidado');
            $planilla_text   = $this->input->post('txt_planilla');
            $periodo_text    = $this->input->post('txt_periodo');
            $sucursal        = $this->input->post('filtro_sucursal');
            $array_planillas = array($pla_id);
            if (is_array($pla_consolidado) && count($pla_consolidado) > 0) {
                $array_planillas = $pla_consolidado;
            }
            $n_pla    = count($array_planillas);

            $usuarios = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['usuario_genera'] = ($usuarios) ? $usuarios[0] : null;
            $data['es_resumen']     = $resumen;
            $data['solo_total']     = $solototales;
            $data['totalizar_emp']  = $totalizar_emp;
            $data['info_planilla']  = array();
            $data['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

            if ($n_pla > 0) {
                if ($totalizar_emp == 1) {
                    //procesar multiples planillas en una sola petición enviado como parametro el arreglo.
                    $data['info_planilla'][] = $this->planilla_model->datos_planilla_personalizada($array_planillas, $sucursal);
                } else {
                    //procesar multiples planillas una a una
                    for ($i = 0; $i < $n_pla; $i++) {
                        $data['info_planilla'][] = $this->planilla_model->datos_planilla_personalizada($array_planillas[$i], $sucursal);
                    }
                }
                $codigo_planilla                = $this->gsatelite->get_campo("pla_planilla", "pla_codigo", array("pla_id" => $pla_id));
                $data['titulo_codigo_planilla'] = $codigo_planilla;
                $data['titulo_periodo']         = $periodo_text;
                $data['titulo_tipo_planilla']   = $planilla_text;
                $this->load->view('personal/planilla/imprimir_planilla_excel_per', $data);
            } else {
                $this->gsatelite->show_dialog('Error en recepción de los datos, favor intentar de nuevo', '', 'error');
            }
        }
    }

    public function print_revision_mensual()
    {
        satelite_validar();
        $periodo = $this->input->post('hdn_fecha');
        $periodo_text = $this->input->post('txt_mes');
        $tipo_rep = $this->input->post('tipo_reporte');
        $pla_tipo = $this->input->post('tipo_planilla'); //SIN USO DE MOMENTO
        if ($tipo_rep != "" && $periodo != "") {
            $fini = formatear_fecha('Y-m-d', $periodo);
            $ffin = formatear_fecha('Y-m-t', $periodo);
            $max_dias = ($this->gsatelite->get_intervalo_dias($fini, $ffin) + 1);
            $dias_par = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES', 30);
            switch ($tipo_rep) {
                case 'afp':
                case 'excel_afp':
                    $tipo = (explode('_', $tipo_rep));
                    $id_descuento_afp = $this->gsatelite->get_parametro('DESCUENTO_AFP', 0);
                    $where["ddd_id_tdc"] = $id_descuento_afp;
                    $where["pla_fecha_inicio >= "] = $fini;
                    $where["pla_fecha_fin <= "] = $ffin;
                    $data['consulta'] = $this->planilla_model->get_reporte_afp2($where, $fini, $ffin, 1);
                    $data['max_dias'] = ($max_dias < $dias_par) ? $dias_par : $max_dias;
                    $data['fecha_ini'] = $fini;
                    $data['fecha_fin'] = $ffin;
                    $data['es_excel'] = ($tipo[0] == 'excel') ? true : false;
                    $documento = $this->load->view("personal/reportes/reporte_revision_afp", $data, true);
                    if ($tipo[0] == 'excel') {
                        echo $documento;
                    } else {
                        $this->pdf->makePdf($documento, 'P');
                    }
                    break;
                case 'isss_rev':
                case 'excel_isss_rev':
                    $tipo = (explode('_', $tipo_rep));
                    $id_desc_isss = $this->gsatelite->get_parametro('DESCUENTO_ISS', 0);
                    $where["ddd_id_tdc"] = $id_desc_isss;
                    $where["pla_fecha_inicio >= "] = $fini;
                    $where["pla_fecha_fin <= "] = $ffin;
                    $data['consulta'] = $this->planilla_model->get_reporte_isss_rev($where, $fini, $ffin, 1);
                    $data['max_dias'] = ($max_dias < $dias_par) ? $dias_par : $max_dias;
                    $data['fecha_ini'] = $fini;
                    $data['fecha_fin'] = $ffin;
                    $data['periodo_text'] = $periodo_text;
                    $data['es_excel'] = ($tipo[0] == 'excel') ? true : false;
                    $documento = $this->load->view("personal/reportes/reporte_revision_isss", $data, true);
                    if ($tipo[0] == 'excel') {
                        echo $documento;
                    } else {
                        $this->pdf->makePdf($documento, 'L');
                    }
                    die();
                    break;
                case 'isss_pre':
                    $id_desc_isss = $this->gsatelite->get_parametro('DESCUENTO_ISS', 0);
                    $where["ddd_id_tdc"] = $id_desc_isss;
                    $where["pla_fecha_inicio >= "] = $fini;
                    $where["pla_fecha_fin <= "] = $ffin;
                    $data['fecha_ini'] = $fini;
                    $data['fecha_fin'] = $ffin;
                    $data['max_dias'] = ($max_dias < $dias_par) ? $dias_par : $max_dias;
                    $empleados = $this->planilla_model->get_reporte_isss_rev($where, $fini, $ffin, 1);
                    $consulta = array_chunk($empleados, 20);
                    $data['consulta'] = $consulta;
                    $fila_empresa = $this->gsatelite->get_tabla('emr_empresa', array('emr_id' => $this->tank_auth->get_empresa_id()));
                    $data['empresa'] = (count($fila_empresa) > 0) ? $fila_empresa[0] : array();
                    $data['periodo_text'] = $periodo_text;
                    $data['hay_resultado'] = (count($empleados) > 0); // ? true : false;
                    $documento = $this->load->view("personal/reportes/rpte_revision_isss_pre", $data, true);
                    $this->pdf->makePdf($documento, 'L');
                    break;
                case 'isss_txt':
                    $base_url = base_url();
                    $dias_max = ($max_dias < $dias_par) ? $dias_par : $max_dias;
                    $sal_min = $this->gsatelite->get_parametro('MONTO_SALARIO_MINIMO');
                    $id_desc_isss = $this->gsatelite->get_parametro('DESCUENTO_ISS', 0);
                    $num_isss_patronal = $this->gsatelite->get_parametro('SYS_ISSS_PATRONAL');
                    $horas_dia = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA', 8);
                    $where = array("pla_fecha_inicio >= " => $fini, "pla_fecha_fin <= " => $ffin, "ddd_id_tdc" => $id_desc_isss);
                    $consulta = $this->planilla_model->get_reporte_isss_rev($where, $fini, $ffin, 1);
                    if (file_exists("uploads/txt_planilla/datos_isss.txt")) {
                        unlink("uploads/txt_planilla/datos_isss.txt");
                    }
                    $file_txt = fopen("uploads/txt_planilla/datos_isss.txt", "w") or die("Problemas en creación del archivo");
                    foreach ($consulta as $k => $fila) {
                        $obs_codigo = 0; //SIN CAMBIOS
                        $dias = (floor($fila['dias_trabajados']) > $max_dias) ? $max_dias :  floor($fila['dias_trabajados']);
                        $dias_vaca = floor($fila['vaca_dias']);
                        if ($fila['permiso_sin_goce'] > 0) {
                            $dias = $dias - $fila['permiso_sin_goce'];
                        }
                        if ($fila['incapacidades'] > 0) {
                            $dias = $dias - $fila['incapacidades'];
                        }
                        if ($dias_vaca > 0) {
                            $dias -= $dias_vaca;
                        }
                        $dias = ($dias < 0) ? 0 : $dias;
                        if (formatear_fecha('Ymd', $fila['emp_fecha_contrato']) >= formatear_fecha('Ymd', $fecha_ini) && formatear_fecha('Ymd', $fila['emp_fecha_contrato']) <= formatear_fecha('Ymd', $fecha_fin) && trim($fila['emp_fecha_retiro']) == '') {
                            $obs_codigo = 7; //ENTRO A LA EMPRESA EN ESE PERIODO
                        } elseif (trim($fila['emp_fecha_retiro']) != '' && formatear_fecha('Ymd', $fila['emp_fecha_retiro']) >= formatear_fecha('Ymd', $fecha_ini) && formatear_fecha('Ymd', $fila['emp_fecha_retiro']) <= formatear_fecha('Ymd', $fecha_fin)) {
                            $obs_codigo = 6; //RETIRO DE LA EMPRESA EN ESE PERIODO
                        } elseif ($fila['incapacidades'] > 0) {
                            $obs_codigo = 5; //INCAPACIDADES
                        } elseif ($fila['total_ingreso_afecto'] < $sal_min) {
                            $obs_codigo = 2; //APRENDICES   SALARIO MENOR AL MINIMO
                        } elseif ($fila['emp_es_jubilado'] > 0) {
                            $obs_codigo = 3;
                        } elseif ($fila['adicional'] > 0 && $fila['vacaciones'] == 0 && $fila['prima_vacaciones'] == 0) {
                            $obs_codigo = 1; //SI SOLAMENTE POSEE PAGOS ADICIONALES MAS EL SALARIO
                        } elseif ($fila['adicional'] == 0 && ($fila['vacaciones'] > 0 || $fila['prima_vacaciones'] > 0)) {
                            $obs_codigo = 8; //SI SOLAMENTE POSEE PAGOS POR VACACION / PRIMA VACACION MAS EL SALARIO
                        } elseif ($fila['adicional'] > 0 && $fila['vacaciones'] > 0 && $fila['prima_vacaciones'] > 0) {
                            $obs_codigo = 9; //CAMBIAR  SI POSEE PAGOS POR VACACION Y PAGOS ADICIONALES
                        }
                        $empleado = mb_substr(trim($fila['emp_nombre']) . ' ' . trim($fila['emp_apellido']), 0, 40, "UTF-8");
                        $salario = number_format($fila['salario'], 2, '', '');
                        $adicional = number_format($fila['adicional'], 2, '', '');
                        $vacaciones = number_format(($fila['vacaciones'] + $fila['prima_vacaciones']), 2, '', '');
                        $linea_texto = array();
                        $linea_texto[] = str_pad($num_isss_patronal, 9, '0', STR_PAD_LEFT); /* Número Patronal 9 */
                        $linea_texto[] = formatear_fecha('Ym', $periodo); /* Período 6 */
                        $linea_texto[] = "001"; /* Correlativo Centro Trabajo 3 */
                        $linea_texto[] = str_pad($fila['emp_seguro'], 9, '0', STR_PAD_LEFT); /* Número Afiliación 9  */
                        $linea_texto[] = str_pad($empleado, 40, ' ', STR_PAD_RIGHT); /* Nombre 40 */
                        $linea_texto[] = str_pad($salario, 9, '0', STR_PAD_LEFT); /* Salario 9  */
                        $linea_texto[] = str_pad($adicional, 9, '0', STR_PAD_LEFT); /* Pago Adicional 9  */
                        $linea_texto[] = str_pad($vacaciones, 9, '0', STR_PAD_LEFT); /* Pago Adicional 9  */
                        $linea_texto[] = str_pad($dias, 2, '0', STR_PAD_LEFT); /* Días 2 */
                        $linea_texto[] = str_pad($horas_dia, 2, '0', STR_PAD_LEFT); /* Horas 2 */
                        $linea_texto[] = str_pad($dias_vaca, 2, '0', STR_PAD_LEFT); /* Días Vacación 2 */
                        $linea_texto[] = str_pad($obs_codigo, 2, '0', STR_PAD_LEFT); /* Código Observación 2 */
                        $archivo_txt = trim(implode("", $linea_texto));
                        fputs($file_txt, $archivo_txt);
                        fputs($file_txt, chr(13) . chr(10));
                    }
                    fclose($file_txt);
                    //descarga el archivo
                    header("Content-type: text/plain");
                    header("Content-Disposition: attachment; filename=datos_isss.txt");
                    ob_clean();
                    readfile($base_url . "uploads/txt_planilla/datos_isss.txt");
                    // header("Content-Type: application/octet-stream");
                    // header('Content-Disposition: attachment; filename="datos_isss.txt"');
                    // header("Location: " . $base_url . "uploads/txt_planilla/datos_isss.txt");
                    break;
                default:
                    $this->gsatelite->show_dialog('Error en recepción de los datos, favor intente de nuevo', '', 'error');
                    break;
            }
        } else {
            $this->gsatelite->show_dialog('Error en recepción de los datos, favor intentar de nuevo', '', 'error');
        }
    }

    /**
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-03-19
     * @param  El valor del código de planilla
     * @return true o false según existencia de código en las planillas registradas
     */
    public function codigo_planilla($value)
    {
        $emr_id = $this->tank_auth->get_empresa_id();
        $tpls   = $this->gsatelite->get_tabla('tpl_tipo_planilla', array('tpl_id_emr' => $emr_id));

        $selected = '0';
        if (count($tpls) > 0) {
            $selected = implode(',', array_column($tpls, "tpl_id"));
        }

        if (!is_numeric(end(explode('/', uri_string())))) {
            $where = array("pla_codigo" => $value, "pla_id_tpl IN ($selected)" => null);
            $count = $this->gsatelite->get_tabla('pla_planilla', $where);
        } else {
            $id    = end(explode('/', uri_string()));
            $where = array("pla_codigo" => $value, "pla_id <> " => $id, "pla_id_tpl IN ($selected)" => null);
            $count = $this->gsatelite->get_tabla('pla_planilla', $where);
        }

        if (count($count) > 0) {
            $this->form_validation->set_message('codigo_planilla', 'El campo Código de planilla debe ser único');
            return false;
        } else {
            return true;
        }
    }

    public function carga_masiva()
    {
        $data['tipo_planillas'] = $this->planilla_model->get_select_tipo_planillas_actuales();
        $tipo_carga = $this->gsatelite->get_dropdown('tac_tipo_carga', 'tac_nombre', '', array('tac_estado' => 1), null, '', 'tac_id', true);
        $data['tipo_carga'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $tipo_carga);
        $data['titulo_personal'] = "Registro masivo de ingresos o descuentos";
        $this->_cargarvista($data);
    }

    public function procesar_xls()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->load->library('../controllers/personal/empleado');
            $excel = new Excel_reader;
            $excel->read($_FILES["excelfile"]["tmp_name"]);

            $nombre_planilla       = $this->db->get_where('tpl_tipo_planilla', array('tpl_id' => $_POST['tipo_planilla']))->row_array();
            $data['tipo_planilla'] = $nombre_planilla['tpl_nombre'];
            $data['id_planilla']   = $nombre_planilla['tpl_id'];

            //obtener el id del periodo de planilla y consultar por la fecha de inicio y sumar le un dia para que entre dentro
            //de dicho periodo el ingreso o descuento respectivo
            $id_plani              = $this->input->post('periodo_planilla');
            $pla                   = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $id_plani));
            $fecha                 = $pla[0]['pla_fecha_inicio'];
            $fecha_p               = date("Y-m-d", strtotime("$fecha +1 day")); //adelantarme un dia para estar mas seguro de la captura del descuento en dicho periodo
            $data['fecha_periodo'] = $fecha_p;

            //$data['fecha_periodo']=$_POST['fecha_periodo'];
            $tipo_carga             = $this->inventario_model->cargar_todo('tac_tipo_carga', array('tac_id' => $_POST['tipo_carga']));
            $data['tac_tipo_carga'] = $tipo_carga[0]['tac_id'];

            $excel->sheets[0]["cells"] = array_values($excel->sheets[0]["cells"]);
            unset($excel->sheets[0]["cells"][0]);
            $excel->sheets[0]["numRows"] = $excel->sheets[0]["numRows"] - 1;


            $nr_sheets  = count($excel->sheets); // gets the number of sheets
            $excel_data = '';
            //print_r($excel->sheets[0]["numRows"]);die();
            // to store the the html tables with data of each sheet

            // traverses the number of sheets and sets html table with each sheet data in $excel_data
            for ($i = 0; $i < $nr_sheets; $i++) {
                if ($excel->sheets[$i]['numCols'] <= 6) {
                    $re_h = '<center><table border="1" class="responsive table table-bordered contenedor" style="width:100%; font-size: 14px;" id="data_expand" name="data_expand">'; // starts html table
                    $re_h .= '<thead>';
                    $re_h .= '<tr>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'CÓDIGO EMPLEADO';
                    $re_h .= '</th>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'CÓDIGO ' . $tipo_carga[0]['tac_nombre'];
                    $re_h .= '</th>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'CANTIDAD';
                    $re_h .= '</th>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'MONTO';
                    $re_h .= '</th>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'CONCEPTO';
                    $re_h .= '</th>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'PERMANENTE';
                    $re_h .= '</th>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'CUOTAS';
                    $re_h .= '</th>';
                    $re_h .= '</tr>';
                    $re_h .= '</thead>';

                    $excel_data .= '<center><h4>(<em>' . $excel->boundsheets[$i]['name'] . '</em>)</h4></center>' . $re_h . $this->empleado->sheetData($excel->sheets[$i], $nombre_planilla['tpl_id'], $_POST['tipo_carga']) . '<br/>';
                } else {
                    $excel_data .= '<center><h4>(<em>' . $excel->boundsheets[$i]['name'] . '</em>)</h4></center><br/><center><h3>';
                    $excel_data .= 'La hoja actual no cumple con el formato de dos columnas: " [COD_EMPLEADO][COD_DESCUENTO Ó INGRESO][MONTO][CONCEPTO][PERMANENTE][CUOTAS] "</h3><br/>';
                    $excel_data .= '<h4>Favor revisar documento de excel y cantidad de columas seleccionadas</h4></center><br/>';
                }
            }

            $data['tabla_html'] = $excel_data;

            $data['tipo_transaccion'] = $this->inventario_model->cargar_todo('tip_tipo_proceso', array('tip_ajuste' => 1));
            $data['titulo_personal']  = 'Carga masiva de ' . (($data['tac_tipo_carga'] == 1) ? "Ingresos" : "Descuentos");
            $this->_cargarvista($data);
        }
    }

    public function ingresos_descuentos()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //$this->load->library('../controllers/personal/empleado');
            $this->load->model('personal_model');
            $where['emp_estado']       = (isset($_POST['slcEstado']) && $_POST['slcEstado'] == 0) ? 0 : 1;
            $data['estado_emp']        = $where['emp_estado'];
            $data['total_empleados']   = $this->personal_model->listado_empleados($where);
            $titulo['titulo_personal'] = "Ingresos y descuentos";
            cargarvista($data, null, 'personal/empleado/ingresos_descuentos');
            //$this->_cargarvista($titulo, $data);
        }
    }

    public function ingreso_descuento_empleado($id)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->load->model('personal_model');
            $data['info']             = $this->personal_model->info_empleado($id);
            $data['id_empleado_crud'] = $id;
            $nombre_empleado          = $data['info'][0]['emp_apellido'] . ', ' . $data['info'][0]['emp_nombre'];
            $data['ver_ingresos']     = $this->personal_model->ingresos_empleado($id);
            $data['ver_descuentos']   = $this->personal_model->descuentos_empleado($id);

            if ($data['info'][0]['emp_salario'] <= 0) {
                $data['tipo_ingreso'] = $this->personal_model->tipo_ingreso(null, null, true);
            } else {
                $data['tipo_ingreso'] = $this->personal_model->tipo_ingreso();
            }
            $data['titulo_personal'] = "Ingresos y descuentos <b style='font-size:14px;'>($nombre_empleado)</b>";
            $data['tipo_descuento']  = $this->personal_model->tipo_descuento(false, null, 1);
            $data['estado']          = $this->personal_model->tipo_descuento();

            $ids_tpl  = array(0);
            $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id));
            foreach ($pregunta as $fila) {
                $ids_tpl[] = $fila['txe_id_tpl'];
            }
            $this->db->where_in('tpl_id', $ids_tpl);
            $select                = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, null, '', 'tpl_id', true);
            $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $id_descuento_isss                                      = $this->gsatelite->get_parametro('DESCUENTO_ISS');
            $configuracion_incapacidad                              = explode('##', $this->gsatelite->get_parametro('CONFIGURACION_INCAPCIDAD_EMPLEADO'));
            $data['n_dias_cubierto_empresa']                        = $configuracion_incapacidad[0];
            $data['porcentaje_n_dias_cubierto_empresa']             = $configuracion_incapacidad[1];
            $data['porcentaje_n_dias_cubierto_empresa_adicionales'] = $configuracion_incapacidad[2];
            $data['porcentaje_n_dias_cubierto_seguro_adicionales']  = $this->gsatelite->get_parametro('PORCENTAJE_INCAPACIDA_SEGURO');

            $data['salario_base_calculo'] =
                $registro_isss                = $this->gsatelite->get_tabla('tdc_tipo_descuento', array('tdc_id' => $id_descuento_isss));
            //preguntar si el salario del empleado no sobrepasa el techo permitido para cálculo del isss
            $salario_base_calculo          = ($data['info'][0]['emp_salario'] > $registro_isss[0]['tdc_maximo']) ? $registro_isss[0]['tdc_maximo'] : $data['info'][0]['emp_salario'];
            $data['salario_base_calculo']  = $salario_base_calculo;
            $data['salario_base_empleado'] = $data['info'][0]['emp_salario'];

            // Datos de proyectos //////////////////////////
            $per = false;
            $c   = ($this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA') != '') ? $this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA') : null;
            if ($c != null) {
                $array_id = explode(',', $c);
                if (in_array($this->tank_auth->get_user_id(), $array_id)) {
                    $per = true;
                }
            }

            $data['permiso_param'] = $per;
            $proyectos_reg         = $this->compras_model->get_proyectos(array('pcl_estado' => 1, 'cli_estado' => 1, 'epr_cierre' => 0));
            $select_proyecto       = '<option value=""></option>';
            foreach ($proyectos_reg as $key) {
                $selected = '';
                if (isset($rxi_id) && $rxi_id != null) {
                    $selected = ($data['requisicion_data'][0]['rxi_id_pcl'] == $key['pcl_id']) ? 'selected' : '';
                }
                $nombre_cliente = (trim($key['cli_personeria']) == 1) ? trim($key['cli_nombre'] . ' ' . $key['cli_apellido']) : trim($key['cli_apellido']);
                $nombre         = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
                $select_proyecto .= '<option value="' . $key['pcl_id'] . '" data-cliente="' . $nombre_cliente . '" ' . $selected . '>' . $nombre . '</option>';
            }
            $data['proyectos'] = $select_proyecto;
            ////////////////////////////////////////////////
            cargarvista($data, null, 'personal/empleado/ingreso_descuento_empleado');
            //$this->_cargarvista($titulo,$data);
        }
    }

    /**
     * Descripción:
     * Función generar el código de planilla con formato
     * prefijo + año + mes + corr   elativo
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-07-11
     * @param  ninguno
     * @return Código de planilla
     */
    public function generar_codigo_planilla()
    {
        satelite_validar(true);
        $tipo  = $this->input->post('tipo');
        $fecha = date_format(date_create($this->input->post('fecha')), 'Y-m-d');
        $edit  = $this->input->post('edit');

        // print_r($_POST); die();

        $prefijo = $this->gsatelite->get_campo('tpl_tipo_planilla', 'tpl_prefijo', array('tpl_id' => $tipo));

        if ($edit > 0) {
            $this->db->where('pla_id <>', $edit);
        }
        $reg_corr      = $this->gsatelite->get_tabla('pla_planilla', array('pla_id_tpl' => $tipo, 'date_format(pla_fecha_inicio, "%Y-%m")=' => formatear_fecha('Y-m', $fecha)));
        // print_r($this->db->last_query());die();
        $corr          = count($reg_corr) + 1;
        $codigo_format = str_pad($corr, 2, '0', STR_PAD_LEFT);

        $codigo = trim($prefijo) . '-' . formatear_fecha('mY', $fecha) . '-' . $codigo_format;
        //print_r($codigo); die();

        echo json_encode($codigo);
    }

    /**
     * @author Edith Herrera
     * @since  2018-07-17
     * @return Generar archivo txt para banco Promerica.
     */
    public function generar_archivo_txt_prom($pla_id = null)
    {
        $id_tipo_doc_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        if (count($pla_id) <= 0 or $pla_id == null) {
            // condicnoar si existen los datos en el post
            $this->gsatelite->show_dialog('', 'personal/reportes/reporte_planilla', 'error', 'Perdida en el envío de datos, favor intentar de nuevo');
            die();
        }
        //'dce_id_tde' => $id_tipo_doc_nit, // SE COMENTA PORQUE ESTA DE MAS, EN LA FUNCION SE VUELVE A DEFINIR
        $datos = $this->planilla_model->get_informacion_planilla_txt(array('TRIM(emp_numero_cuenta) !=' => '', 'emp_numero_cuenta IS NOT NULL' => null, 'pla_id' => $pla_id));
        $linea = array();
        $i     = 0;
        foreach ($datos as $fila) {
            $i++;
            $linea_texto = ($fila['cuenta'] != '') ? trim($fila['cuenta']) : ' ';
            $linea_texto .= chr(9); // Tabulación
            $linea_texto .= trim(strtoupper(utf8_decode($fila['nombre_empleado'])));
            $linea_texto .= chr(9); // Tabulación
            $linea_texto .= number_format($fila['normal'], 2, '.', '');
            $linea[] = trim($linea_texto);
        }
        $ruta_carga = 'uploads/txt_planilla/';
        if (file_exists("uploads/txt_planilla/datos_planilla.txt")) {
            unlink("uploads/txt_planilla/datos_planilla.txt"); //eliminar el archivo si existiese
        }
        $ruta_completa = $ruta_carga . 'datos_planilla.txt';
        $separador     = chr(13) . chr(10);
        $texto_completo = $separador . implode($separador, $linea);

        $archivo        = fopen($ruta_completa, 'w+') or die('Sin permisos de escritura en el servidor');
        $texto_completo = trim($texto_completo);
        ob_clean();
        fputs($archivo, $texto_completo);
        fclose($archivo);
        header('Content-Type: text/html; charset=utf-8');
        header("Content-Type: application/octet-stream");
        header('Content-Disposition: attachment; filename=datos_planilla.txt');
        readfile("uploads/txt_planilla/datos_planilla.txt");
        #header("Location: " . base_url() . "uploads/txt_planilla/$nombre_archivo"); //para que esta linea funcione debe comentarse las lineas del ob_clean y flush.
        die();
    }

    public function generar_txt_hipotecario($pla_id = null)
    {
        if (count($pla_id) <= 0 or $pla_id == null) {
            $this->gsatelite->show_dialog('', 'personal/reportes/reporte_planilla', 'error', 'Perdida en el envío de datos, favor intentar de nuevo');
            die();
        }
        $datos = $this->planilla_model->get_informacion_planilla_txt(array('TRIM(emp_numero_cuenta) !=' => '', 'emp_numero_cuenta IS NOT NULL' => null, 'pla_id' => $pla_id));
        $i     = 0;
        $linea = array();
        foreach ($datos as $fila) {
            $i++;
            $linea_texto = ($fila['cuenta'] != '') ? trim($fila['cuenta']) : ' ';
            $linea_texto .= ',';
            $linea_texto .= number_format($fila['normal'], 2, '.', '');
            $linea_texto .= ',';
            $linea_texto .= 'Cancelacion de Planilla #' . trim(strtoupper(utf8_decode($fila['pla_codigo'])));
            $linea[] = trim($linea_texto);
        }
        $ruta_carga = 'uploads/txt_planilla/';
        if (file_exists("uploads/txt_planilla/datos_planilla.txt")) {
            unlink("uploads/txt_planilla/datos_planilla.txt"); //eliminar el archivo si existiese
        }
        $ruta_completa = $ruta_carga . 'datos_planilla.txt';
        $separador     = chr(13) . chr(10);
        $texto_completo = $separador . implode($separador, $linea);
        $archivo        = fopen($ruta_completa, 'w+') or die('Sin permisos de escritura en el servidor');
        $texto_completo = trim($texto_completo);
        ob_clean();
        fputs($archivo, $texto_completo);
        fclose($archivo);
        header('Content-Type: text/html; charset=utf-8');
        header("Content-Type: application/octet-stream");
        header('Content-Disposition: attachment; filename=datos_planilla.txt');
        readfile("uploads/txt_planilla/datos_planilla.txt");
        die();
    }

    /**
     * @author Elman Ortiz
     * @since 2018-08-17
     * @return generación de la partida contable aporte patronal a partir de la autorización de la planilla
     */
    public function partida_contable_aporte_patronal($id_planilla)
    {
        //Concepto para la partida de aporte patronal
        $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 14));
        if (count($pct_concepto) > 0) {
            $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
        } else {
            $pct_concepto = 'Concepto no definido';
        }

        //Obtener la planilla y la fecha para la partida
        $pla_datos     = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $id_planilla));
        $pla_fecha_fin = $pla_datos[0]['pla_fecha_fin'];
        if ($pla_fecha_fin) {
            $pct_fecha = $pla_fecha_fin;
        } else {
            $pct_fecha = date('Y-m-d H:i:s');
        }

        $origen = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_tabla' => 'pla_planilla'));

        $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');
        $tipo_partida    = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('GASTO'));
        $consultar       = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $tipo_partida));
        if (count($consultar) > 0) {
            $id_tipo_partida = $consultar[0]['tpd_id'];
        }

        $dato_planilla = $this->planilla_model->get_informacion_planilla(array('pla_id' => $id_planilla));
        //$concepto_partida = "Pago Planilla - Código: ".$dato_planilla['pla_codigo'];
        $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo');
        $codigo_planilla     = ($dato_planilla['pla_codigo']) ? $dato_planilla['pla_codigo'] : '';
        $array_insert        = array(
            'pct_id_orp' => (count($origen) > 0) ? $origen[0]['orp_id'] : null, 
            'pct_id_tpd' => ($id_tipo_partida > 0) ? $id_tipo_partida : null, 
            'pct_concepto' => $pct_concepto . " " . $dato_planilla['pla_codigo'], 
            'pct_total' => 0, //posteriormente se actualizará
            'pct_fecha' => $pct_fecha, //date('Y-m-d H:i:s')
            'pct_correlativo' => ($correlativo_partida > 0) ? ($correlativo_partida + 1) : 1, 
            'pct_codigo' => $codigo_planilla, 
            'pct_estado' => 1, 
            'pct_usu_crea' => $this->tank_auth->get_user_id(), 
            'pct_fecha_crea' => date('Y-m-d H:i:s'), 
            'pct_usu_mod' => $this->tank_auth->get_user_id(), 
            'pct_fecha_mod' => date('Y-m-d H:i:s')
        );

        $aportes_patronales = $this->planilla_model->partida_contable_aporte_patronal(array('pla_id' => $id_planilla));

        /*print_r($array_insert);
        print_r("aaaaa");
        print_r($aportes_patronales);
        die();*/

        if (count($aportes_patronales) > 0) {
            //si existen datos procesar contablemente
            $id_partida = $this->gsatelite->ingresar('pct_partida_contable', $array_insert);

            //actualizar la partida en la planilla
            $this->gsatelite->actualizar_array('pla_planilla', array('pla_id_pct' => $id_partida), array('pla_id' => $id_planilla));

            //GENERAR LOS DETALLES PARA LA PARTIDA CONTABLE
            $total_partida                = 0;
            $array_insert_aporte_patronal = array();
            foreach ($aportes_patronales as $fila_in) {
                $total_partida += $fila_in['valor'];
                $array_insert_aporte_patronal[] = array(
                    'dpc_id_cnt' => $fila_in['id_cuenta_contable'], 
                    'dpc_id_pct' => $id_partida, 
                    'dpc_concepto' => $fila_in['nombre_tipo_descuento'], 
                    'dpc_debe' => $fila_in['valor'], 
                    'dpc_haber' => 0, 
                    'dpc_estado' => 1, 
                    'dpc_usu_crea' => $this->tank_auth->get_user_id(), 
                    'dpc_fecha_crea' => date('Y-m-d H:i:s'), 
                    'dpc_usu_mod' => $this->tank_auth->get_user_id(), 
                    'dpc_fecha_mod' => date('Y-m-d H:i:s')
                );

                // $n_detalles_ingresos = $this->gsatelite->ingresar('dpc_detalle_partida', $array_insert_ingreso); //ejecutar uno a uno

            }

            if (count($array_insert_aporte_patronal) > 0) {
                $n_detalles_ingresos = $this->gsatelite->ingresar('dpc_detalle_partida', $array_insert_aporte_patronal, true); //ejecutar insert batch
            }

            //actualizar el total de partida
            $this->gsatelite->actualizar_array('pct_partida_contable', array('pct_total' => $total_partida), array('pct_id' => $id_partida));
            //return $id_partida;
        }

        /**************************Obligaciones_patronales*****************************************/
        $obligaciones_patronales = $this->planilla_model->partida_contable_obligacion_patronal(array('pla_id' => $id_planilla));
        if (count($obligaciones_patronales) > 0) {
            //si existen datos procesar contablemente
            foreach ($obligaciones_patronales as $fila_pa) {
                $array_insert_pago[] = array(
                    'dpc_id_cnt' => $fila_pa['id_cuenta_contable'], 
                    'dpc_id_pct' => $id_partida, 
                    'dpc_concepto' => 'Obligacion patronal - ' . $codigo_planilla, 
                    'dpc_debe' => 0, 
                    'dpc_haber' => ($fila_pa['valor']), 
                    'dpc_estado' => 1, 
                    'dpc_usu_crea' => $this->tank_auth->get_user_id(), 
                    'dpc_fecha_crea' => date('Y-m-d H:i:s'), 
                    'dpc_usu_mod' => $this->tank_auth->get_user_id(), 
                    'dpc_fecha_mod' => date('Y-m-d H:i:s')
                );
                //$n_detalles_pagos = $this->gsatelite->ingresar('dpc_detalle_partida', $array_insert_pago);
            }
            if (count($array_insert_pago) > 0) {
                $n_detalles_pagos = $this->gsatelite->ingresar('dpc_detalle_partida', $array_insert_pago, true); //ejecutar insert batch
            }
        }
        /***************************************************************************************/

        //return FALSE;
    }

    public function _cargarvista($data = 0, $crud = 0)
    {
        $this->load->view('vacia', $crud);
        if ($data != 0) {
            $data = array_merge($data, $this->masterpage->getUsuario());
        } else {
            $data = $this->masterpage->getUsuario();
        }

        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    /*
     * @author: Mario Marquez
     * @date: 13/11/2018
     * @Descripcion: Generacion masiva de partidas contables para planillas autorizadas
     */

    public function generar_partida_contable_planilla()
    {
        if ($this->input->post()) {
            //Se obtiene los abonos de clientes que no continen partidas
            $planillas = $this->gsatelite->get_tabla('pla_planilla', array('pla_id_pct is null' => null, 'pla_estado' => 3));

            if (count($planillas) > 0) {
                foreach ($planillas as $planilla) {

                    $pla_id = $planilla['pla_id'];

                    //generar partida de planilla
                    $pct_id = $this->partida_contable_planilla($pla_id);
                    //generar partida de aportes patronales(Provision social)
                    //$this->partida_contable_aporte_patronal($pla_id);

                    $PartidasIds[] = array('partida_id' => $pct_id);
                }
            }
            //print_r($PartidasIds);die();
            echo json_encode(array('cantidad_partidas' => count($PartidasIds)));
        } else {
            echo "Debe realizar un metodo de envio de datos";
        }
    }

    /*
     * @author: Raul Escalante
     * @date: 02/05/19
     * @Descripcion: Obtiene el factor de ingreso o descuento para una consulta ajax
     */
    public function get_factor($flag = null)
    {
        if ($this->input->post()) {
            $id = $this->input->post('id');
            if ($flag) {
                //descuentos
                $factor = $this->gsatelite->get_campo('tdc_tipo_descuento', 'tdc_factor', array('tdc_id' => $id));
            } else {
                //ingresos
                $factor = $this->gsatelite->get_campo('tig_tipo_ingreso', 'tig_factor', array('tig_id' => $id));
            }
            echo ($factor != '') ? $factor : '1.00';
        }
    }

    /**
     * @author Raul Escalante
     * @since  2019-06-19
     * @return Generar archivo txt para banco Azul.
     */
    public function generar_archivo_txt_azul($pla_id = null)
    {
        $id_tipo_doc_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        if (count($pla_id) <= 0 || $pla_id == null) {
            $this->gsatelite->show_dialog('', 'personal/reportes/reporte_planilla', 'error', 'Perdida en el envío de datos, favor intentar de nuevo');
            die();
        }
        $meses_array = array('', 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
        $condiciones = array(
            'dce_id_tde'                    => $id_tipo_doc_nit,
            'TRIM(emp_numero_cuenta) != ""' => null,
            'emp_numero_cuenta is not null' => null,
            //'emp_id_ban' = 5,//ID del Banco Azul (NO USADO ACTUALMENTE PUES EN LA BASE DEL CLIENTE LOS EMPLEADOS NO TIENEN DEFINIDO ID DE BANCO)
            'pla_id'                        => $pla_id,
        );
        $datos = $this->planilla_model->get_informacion_planilla_txt($condiciones);
        $mes   = ltrim($datos[0]['mes_planilla'], "0");
        $corte = explode('-', $datos[0]['pla_fecha_corte']);
        if ($datos[0]['tpl_frecuencia'] == 15) {
            $periodo = ($corte[2] > 16) ? 'Segunda quincena ' : 'Primera quincena ';
            $periodo .= $meses_array[$mes] . ' ' . $corte[0];
        } else {
            $periodo = 'Fecha de Corte: ' . formatear_fecha('d-m-Y', $datos[0]['pla_fecha_corte']);
        }
        $linea = array();
        foreach ($datos as $fila) {
            if (trim($fila['cuenta']) != 'CHEQUE') {
                $linea_texto = array();
                // $linea_texto = ($fila['cuenta'] != '') ? trim($fila['cuenta']) : ' ';
                // $linea_texto .= chr(9); // Tabulación
                // $linea_texto .= number_format($fila['normal'], 2, '.', '');
                // $linea_texto .= chr(9); // Tabulación
                // $linea_texto .= trim(strtoupper(utf8_decode($periodo)));
                // $linea_texto .= chr(9); // Tabulación
                // $linea_texto .= trim(strtoupper(mb_substr($fila['nombre_empleado'], 0, null, 'UTF-8')));
                // $linea_texto = str_replace('ñ', 'Ñ', $linea_texto);
                $linea_texto[] = trim($fila['cuenta']);
                $linea_texto[] = trim($fila['normal']);
                $linea_texto[] = trim($periodo);
                $linea[]     = trim(implode(',', $linea_texto));
            }
        }
        $ruta_carga = 'uploads/txt_planilla/';
        if (file_exists("uploads/txt_planilla/datos_planilla.csv")) {
            unlink("uploads/txt_planilla/datos_planilla.csv"); //eliminar el archivo si existiese
        }
        $ruta_completa  = $ruta_carga . 'datos_planilla.csv';
        $separador      = chr(13) . chr(10);
        $texto_completo = $separador . implode($separador, $linea);
        $archivo        = fopen($ruta_completa, 'w+') or die('Sin permisos de escritura en el servidor');
        $texto_completo = trim($texto_completo);
        fputs($archivo, $texto_completo);
        fclose($archivo);
        if (ob_get_contents()) ob_end_clean();
        header('Content-Type: text/html; charset=utf-8');
        header("Content-Type: application/octet-stream");
        header('Content-Disposition: attachment; filename=datos_planilla.csv');
        readfile("uploads/txt_planilla/datos_planilla.csv");
        die();
    }

    /**
     * @author Raul Escalante
     * @since  2023-08
     * @return Generar archivo txt para banco Cuscatlan
     */
    public function generar_txt_cuscatlan($pla_id = null)
    {
        if (count($pla_id) <= 0 || $pla_id == null) {
            $this->gsatelite->show_dialog('', 'personal/reportes/reporte_planilla', 'error', 'Perdida en el envío de datos, favor intentar de nuevo');
            die();
        }
        $meses_array = array('', 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
        $condiciones = array(
            'TRIM(emp_numero_cuenta) != ""' => null,
            'emp_numero_cuenta is not null' => null,
            //'emp_id_ban' = 5,//ID del Banco Azul (NO USADO ACTUALMENTE PUES EN LA BASE DEL CLIENTE LOS EMPLEADOS NO TIENEN DEFINIDO ID DE BANCO)
            'pla_id'                        => $pla_id,
        );
        $datos = $this->planilla_model->get_info_planilla_txt_cusca($condiciones);
        $mes   = formatear_fecha('n', $datos[0]['mes_planilla']);
        $corte = explode('-', $datos[0]['pla_fecha_corte']);
        if ($datos[0]['tpl_frecuencia'] == 15) {
            $periodo = ($corte[2] > 16) ? 'Segunda quincena ' : 'Primera quincena ';
            $periodo .= $meses_array[$mes] . ' ' . $corte[0];
        } else {
            $periodo = 'Fecha de Corte: ' . formatear_fecha('d-m-Y', $datos[0]['pla_fecha_corte']);
        }
        $linea = array();
        $linea_fecha = str_replace(' ', '_', trim(strtoupper(utf8_decode($periodo))));
        foreach ($datos as $fila) {
            if (trim($fila['cuenta']) != 'CHEQUE') {
                $linea_texto = array();
                $linea_texto[] = trim($fila['monto']);
                $linea_texto[] = str_pad($fila['cuenta'], 15, '0', STR_PAD_LEFT);
                $linea_texto[] = 4; // SEGUN BANCO CUSCATLAN 3=CTA-CORRIENTE / 4=CTA AHORROS
                $name_empleado = trim(strtoupper(mb_substr($fila['nombre_empleado'], 0, null, 'UTF-8')));
                $linea_texto[] = str_replace('ñ', 'Ñ', $name_empleado);
                $linea[]     = trim(implode(chr(9), $linea_texto));
            }
        }
        $ruta_carga = 'uploads/txt_planilla/';
        if (file_exists("uploads/txt_planilla/datos_planilla_$linea_fecha.txt")) {
            unlink("uploads/txt_planilla/datos_planilla_$linea_fecha.txt");
        }
        $ruta_completa  = $ruta_carga . "datos_planilla_$linea_fecha.txt";
        $separador     = chr(13) . chr(10);
        $texto_completo = $separador . implode($separador, $linea);
        $texto_completo = trim($texto_completo);
        $archivo        = fopen($ruta_completa, 'w+') or die('Sin permisos de escritura en el servidor');
        ob_clean();
        fputs($archivo, $texto_completo);
        fclose($archivo);
        header("Content-Type: text/html; charset=utf-8");
        header("Content-Type: application/octet-stream");
        header("Content-Disposition: attachment; filename=datos_planilla_$linea_fecha.txt");
        readfile("uploads/txt_planilla/datos_planilla_$linea_fecha.txt");
        die();
    }

    /**
     * @author Francisco Orozco
     * @since  15/07/2019
     * @param  INT pla_id
     * @param  INT tipo_proceso
     * @return INT Id de partida o si es error retorna 0
     * Descripcion: si tipo = 1 crear un arreglo de la partida contable y si es 2 realiza una insercion en la bd
     * proceso evaluar automaticamente si es de editar
     */
    public function generar_partida_automatica_planilla($pla_id = null, $tipo_proceso = 1)
    {
        //tipo_proceso = 1 : return array
        //tipo_proceso = 2 : Insercion
        if ($pla_id > 0) {
            //declaracion de varaibles globales
            $proceso_partida = null;
            $fecha_global    = date('Y-m-d H:i:s');
            $usuario_global  = $this->tank_auth->get_user_id();
            //variables para aproximacion
            $porcentaje_debe  = 0;
            $porcentaje_haber = 0;
            $contador_debe    = 0;
            $contador_haber   = 0;
            $pct_total        = 0;
            $suma_descuentos  = 0;
            $valor_empleados  = 0;
            $prorrateos       = 0;
            //Obtener la planilla y la fecha para la partida
            $pla_datos     = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $pla_id));
            $pla_fecha_fin = $pla_datos[0]['pla_fecha_fin'];
            $pct_fecha     = ($pla_datos[0]['pla_fecha_fin'] != "") ? $pla_datos[0]['pla_fecha_fin'] : date('Y-m-d H:i:s');

            $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 14));
            if (count($pct_concepto) > 0) {
                $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
            } else {
                $pct_concepto = 'Concepto no definido';
            }

            $pct_id_orp      = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_tabla' => 'pla_planilla'));
            $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');
            $tipo_partida    = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('GASTO'));
            $consultar       = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $tipo_partida));
            $pct_correlativo = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo');
            $centro_defecto  = $this->gsatelite->get_tabla('cec_centro_costo', array('cec_defecto' => 1));
            if (count($consultar) > 0) {
                $id_tipo_partida = $tipo_partida;
            }

            ///verificacion de periodo contable
            $this->db->limit(1);
            $this->db->order_by("prc_id", "DESC");
            $pct_id_prc   = $this->gsatelite->get_tabla("prc_periodo_contable", array("prc_estado" => 1));
            $tipo_des_afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');

            $where_ingreso["pla_id"]                  = $pla_id;
            $where_descuento["pla_id"]                = $pla_id;
            $where_descuento["ddd_id_tdc !="]         = $tipo_des_afp;
            $where_descuento["ddd_valor >"]           = 0;
            $where_afp["pla_id"]                      = $pla_id;
            $where_afp["ddd_id_tdc"]                  = $tipo_des_afp;
            $where_afp["ddd_valor >"]                 = 0;
            $where_afp_patron["pla_id"]               = $pla_id;
            $where_afp_patron["ddd_id_tdc"]           = $tipo_des_afp;
            $where_afp_patron["ddd_valor_patronal >"] = 0;
            $where_patronal["pla_id"]                 = $pla_id;
            $where_patronal["ddd_id_tdc !="]          = $tipo_des_afp;
            $where_patronal["ddd_valor_patronal >"]   = 0;
            $where_salarios["txe_id_tpl"]             = $pla_datos[0]["pla_id_tpl"];
            $where_salarios["txe_estado"]             = 1;
            $where_salarios["emp_estado"]             = 1;

            $cuenta_defecto       = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
            $cuenta_defecto_array = $this->gsatelite->get_tabla("cnt_cuenta_contable", array("cnt_id" => $cuenta_defecto));

            ///////DEBE///////
            //INGRESOS
            $ingresos = $this->planilla_model->get_ingresos_partidas($where_ingreso, $cuenta_defecto, 15);
            //PROVISION DTO. APORTE PATRONAL
            $patronales = $this->planilla_model->get_descuentos_partidas_patronal($where_patronal, $cuenta_defecto, 23);
            //DESCUENTO PLANILLA EMPLEADO
            $afps_patronal = $this->planilla_model->get_descuentos_partidas_afp($where_afp_patron, $cuenta_defecto, 15);

            //////HABER//////
            //DESCUENTO PLANILLA EMPLEADO
            $descuentos_empleado = $this->planilla_model->get_descuentos_partidas($where_descuento, $cuenta_defecto, 15);
            //DESCUENTO APORTE PATRONAL
            $descuentos_patronal = $this->planilla_model->get_descuentos_partidas($where_descuento, $cuenta_defecto, 22);
            //DESCUENTO PLANILLA EMPLEADO
            $afps = $this->planilla_model->get_descuentos_partidas_afp($where_afp, $cuenta_defecto, 15);
            //CALCULO DE PORCENTAJES
            $salarios        = $this->planilla_model->get_planilla_partidas($where_salarios, $centro_defecto[0]['cec_id']);
            $suma_descuentos = array_sum(array_column($descuentos_empleado, 'calculo')) + array_sum(array_column($descuentos_patronal, 'calculo')) + array_sum(array_column($afps, 'calculo'));
            $pct_total       = array_sum(array_column($ingresos, 'calculo')) + array_sum(array_column($patronales, 'calculo')) + array_sum(array_column($afps_patronal, 'patronal'));
            $valor_empleados = $pct_total - $suma_descuentos;
            $prorrateos      = array_sum(array_column($salarios, 'porcentajes'));

            if (count($ingresos) > 0) {
                //Se creara el arreglo encabezado de la partida contable
                $proceso_partida["Encabezado_partida_contable"] = array(
                    'pct_id_tpd'      => $id_tipo_partida,
                    'pct_id_prc'      => $pct_id_prc[0]["prc_id"],
                    'pct_id_padre'    => null,
                    'pct_id_orp'      => (isset($pct_id_orp[0]["orp_id"])) ? $pct_id_orp[0]["orp_id"] : null,
                    'pct_concepto'    => $pct_concepto . " " . $ingresos[0]['pla_codigo'],
                    'pct_total'       => $pct_total,
                    'pct_fecha'       => $pct_fecha,
                    'pct_correlativo' => $pct_correlativo + 1,
                    'pct_codigo'      => $ingresos[0]['pla_codigo'],
                    'pct_modulo'      => 3,
                    'pct_observacion' => "",
                    'pct_estado'      => 1,
                    'pct_fecha_crea'  => $fecha_global,
                    'pct_fecha_mod'   => $fecha_global,
                    'pct_usu_crea'    => $usuario_global,
                    'pct_usu_mod'     => $usuario_global,
                );

                // se obtendran los centros de costos
                $centros_array_ingresos = array_column($ingresos, 'dcl_id_cec');
                $centros_array          = array_unique($centros_array_ingresos);
                $contador_centros       = 0;


                //se creara arreglo de los detalles de la partidas
                foreach ($centros_array as $key1 => $centros) {
                    //creacion de pcc
                    $proceso_partida["pcc_partida_centro_costo"][] = array(
                        'pcc_id_cec'             => ($centros > 0) ? $centros : $centro_defecto[0]['cec_id'],
                        'pcc_codigo'             => $ingresos[0]['pla_codigo'],
                        'pcc_descripcion'        => "",
                        'pcc_estado'             => 1,
                        'pcc_usu_creacion'       => $usuario_global,
                        'pcc_fecha_creacion'     => $fecha_global,
                        'pcc_usu_modificacion'   => $usuario_global,
                        'pcc_fecha_modificacion' => $fecha_global,
                    );

                    ////////////////////////// DEBE //////////////////////////
                    // INGRESOS
                    foreach ($ingresos as $key2 => $ingreso) {
                        if ($centros == $ingreso['dcl_id_cec']) {
                            $nombre_cuenta_debe = ($ingreso['cuenta_contable'] != $cuenta_defecto) ? $ingreso['cuenta_contable'] : $cuenta_defecto_array[0]["cnt_nombre"];
                            $dpc_debe           = number_format($ingreso['calculo'], 4, '.', '');
                            $contador_debe += number_format($ingreso['calculo'], 4, '.', '');
                            $proceso_partida["dpc_detalle_partida"]["debe"][$contador_centros][] = array(
                                'dpc_id_cnt'               => $ingreso['cuenta_contable'],
                                'dpc_concepto'             => $nombre_cuenta_debe,
                                'dpc_debe'                 => $dpc_debe,
                                'dpc_haber'                => 0.0000,
                                'dpc_porcentaje_prorrateo' => $ingreso["dcl_porcentaje"],
                                'dpc_estado'               => 1,
                                'dpc_fecha_crea'           => $fecha_global,
                                'dpc_fecha_mod'            => $fecha_global,
                                'dpc_usu_crea'             => $usuario_global,
                                'dpc_usu_mod'              => $usuario_global,
                            );
                        }
                    }

                    // DESCUENTOS
                    foreach ($patronales as $key4 => $patronal) {
                        if ($centros == $patronal['dcl_id_cec']) {
                            $nombre_cuenta_debe = ($patronal['cuenta_contable'] != $cuenta_defecto) ? $patronal['cuenta_contable'] : $cuenta_defecto_array[0]["cnt_nombre"];
                            $dpc_debe           = number_format($patronal['calculo'], 4, '.', '');
                            $contador_debe += number_format($patronal['calculo'], 4, '.', '');
                            $proceso_partida["dpc_detalle_partida"]["debe"][$contador_centros][] = array(
                                'dpc_id_cnt'               => $patronal['cuenta_contable'],
                                'dpc_concepto'             => $nombre_cuenta_debe,
                                'dpc_debe'                 => $dpc_debe,
                                'dpc_haber'                => 0.0000,
                                'dpc_porcentaje_prorrateo' => $patronal["dcl_porcentaje"],
                                'dpc_estado'               => 1,
                                'dpc_fecha_crea'           => $fecha_global,
                                'dpc_fecha_mod'            => $fecha_global,
                                'dpc_usu_crea'             => $usuario_global,
                                'dpc_usu_mod'              => $usuario_global,
                            );
                        }
                    }

                    //AFP
                    foreach ($afps_patronal as $key3 => $afp) {
                        if ($centros == $afp['dcl_id_cec']) {
                            $nombre_cuenta_debe = ($afp['cuenta_contable'] != $cuenta_defecto) ? $afp['cuenta_contable'] : $cuenta_defecto_array[0]["cnt_nombre"];
                            $dpc_debe           = number_format($afp['patronal'], 4, '.', '');
                            $contador_debe += number_format($afp['patronal'], 4, '.', '');
                            $proceso_partida["dpc_detalle_partida"]["debe"][$contador_centros][] = array(
                                'dpc_id_cnt'               => $afp['cuenta_contable'],
                                'dpc_concepto'             => $nombre_cuenta_debe,
                                'dpc_debe'                 => $dpc_debe,
                                'dpc_haber'                => 0.0000,
                                'dpc_porcentaje_prorrateo' => $afp["dcl_porcentaje"],
                                'dpc_estado'               => 1,
                                'dpc_fecha_crea'           => $fecha_global,
                                'dpc_fecha_mod'            => $fecha_global,
                                'dpc_usu_crea'             => $usuario_global,
                                'dpc_usu_mod'              => $usuario_global,
                            );
                        }
                    }

                    ////////////////////////// HABER //////////////////////////
                    //AFP
                    foreach ($afps as $key4 => $afp) {
                        if ($centros == $afp['dcl_id_cec']) {
                            $nombre_cuenta_debe = ($afp['cuenta_contable'] != $cuenta_defecto) ? $afp['cuenta_contable'] : $cuenta_defecto_array[0]["cnt_nombre"];
                            $dpc_haber          = number_format($afp['calculo'], 4, '.', '');
                            $contador_haber += number_format($afp['calculo'], 4, '.', '');
                            $proceso_partida["dpc_detalle_partida"]["haber"][$contador_centros][] = array(
                                'dpc_id_cnt'               => $afp['cuenta_contable'],
                                'dpc_concepto'             => $nombre_cuenta_debe,
                                'dpc_debe'                 => 0.0000,
                                'dpc_haber'                => $dpc_haber,
                                'dpc_porcentaje_prorrateo' => $afp["dcl_porcentaje"],
                                'dpc_estado'               => 1,
                                'dpc_fecha_crea'           => $fecha_global,
                                'dpc_fecha_mod'            => $fecha_global,
                                'dpc_usu_crea'             => $usuario_global,
                                'dpc_usu_mod'              => $usuario_global,
                            );
                        }
                    }

                    // DESCUENTOS EMPLEADO
                    foreach ($descuentos_empleado as $key5 => $descuento) {
                        if ($centros == $descuento['dcl_id_cec']) {
                            $nombre_cuenta_debe = ($descuento['cuenta_contable'] != $cuenta_defecto) ? $descuento['cuenta_contable'] : $cuenta_defecto_array[0]["cnt_nombre"];
                            $dpc_haber          = number_format($descuento['calculo'], 4, '.', '');
                            $contador_haber += number_format($descuento['calculo'], 4, '.', '');
                            $proceso_partida["dpc_detalle_partida"]["haber"][$contador_centros][] = array(
                                'dpc_id_cnt'               => $descuento['cuenta_contable'],
                                'dpc_concepto'             => $nombre_cuenta_debe,
                                'dpc_debe'                 => 0.0000,
                                'dpc_haber'                => $dpc_haber,
                                'dpc_porcentaje_prorrateo' => $descuento["dcl_porcentaje"],
                                'dpc_estado'               => 1,
                                'dpc_fecha_crea'           => $fecha_global,
                                'dpc_fecha_mod'            => $fecha_global,
                                'dpc_usu_crea'             => $usuario_global,
                                'dpc_usu_mod'              => $usuario_global,
                            );
                        }
                    }

                    // DESCUENTOS EMPLEADO
                    foreach ($descuentos_patronal as $key5 => $descuento) {
                        if ($centros == $descuento['dcl_id_cec']) {
                            $nombre_cuenta_debe = ($descuento['cuenta_contable'] != $cuenta_defecto) ? $descuento['cuenta_contable'] : $cuenta_defecto_array[0]["cnt_nombre"];
                            $dpc_haber          = number_format($descuento['calculo'], 4, '.', '');
                            $contador_haber += number_format($descuento['calculo'], 4, '.', '');
                            $proceso_partida["dpc_detalle_partida"]["haber"][$contador_centros][] = array(
                                'dpc_id_cnt'               => $descuento['cuenta_contable'],
                                'dpc_concepto'             => $nombre_cuenta_debe,
                                'dpc_debe'                 => 0.0000,
                                'dpc_haber'                => $dpc_haber,
                                'dpc_porcentaje_prorrateo' => $descuento["dcl_porcentaje"],
                                'dpc_estado'               => 1,
                                'dpc_fecha_crea'           => $fecha_global,
                                'dpc_fecha_mod'            => $fecha_global,
                                'dpc_usu_crea'             => $usuario_global,
                                'dpc_usu_mod'              => $usuario_global,
                            );
                        }
                    }

                    // valor de planilla
                    foreach ($salarios as $key5 => $salario) {
                        if ($centros == $salario['centro']) {
                            $nombre_cuenta_debe = ($salario['cnt_nombre'] != "") ? $salario['cnt_nombre'] : $cuenta_defecto_array[0]["cnt_nombre"];
                            $cuenta_defecto     = ($salario['cnt_id'] != "") ? $salario['cnt_id'] : $cuenta_defecto_array[0]["cnt_id"];
                            $porcentaje         = ($salario["porcentajes"] * 100) / $prorrateos;
                            $dpc_haber          = (($valor_empleados * $porcentaje) / 100);
                            $contador_haber += $dpc_haber;
                            $proceso_partida["dpc_detalle_partida"]["haber"][$contador_centros][] = array(
                                'dpc_id_cnt'               => $cuenta_defecto,
                                'dpc_concepto'             => $nombre_cuenta_debe,
                                'dpc_debe'                 => 0.0000,
                                'dpc_haber'                => $dpc_haber,
                                'dpc_porcentaje_prorrateo' => $porcentaje,
                                'dpc_estado'               => 1,
                                'dpc_fecha_crea'           => $fecha_global,
                                'dpc_fecha_mod'            => $fecha_global,
                                'dpc_usu_crea'             => $usuario_global,
                                'dpc_usu_mod'              => $usuario_global,
                            );
                        }
                    }

                    $contador_centros++;
                }

                $proceso_partida["Encabezado_partida_contable"]["pct_total"] = $pct_total;
                if ($tipo_proceso == 1) {
                    //para pruebas, agregar tipo 1 en el link 
                    //print_r($proceso_partida);die();
                    return $proceso_partida;
                } else {
                    //insertar en pct_partida_contable
                    $id_pct = $this->gsatelite->ingresar('pct_partida_contable', $proceso_partida["Encabezado_partida_contable"]);
                    foreach ($proceso_partida["pcc_partida_centro_costo"] as $centro_contador => $partida_centro) {
                        //se agregaran partdas por centro de costo
                        $partida_centro["pcc_id_pct"] = $id_pct;
                        $id_pcc                       = $this->gsatelite->ingresar('pcc_partida_centro_costo', $partida_centro);

                        //se agregaran los detalles de partida
                        //debe
                        foreach ($proceso_partida["dpc_detalle_partida"]["debe"][$centro_contador] as $debe_contador => $debe) {
                            $debe["dpc_id_pcc"] = $id_pcc;
                            $debe["dpc_id_pct"] = $id_pct;
                            $this->gsatelite->ingresar('dpc_detalle_partida', $debe);
                        }

                        //haber
                        foreach ($proceso_partida["dpc_detalle_partida"]["haber"][$centro_contador] as $contador_haber => $haber) {
                            $haber["dpc_id_pcc"] = $id_pcc;
                            $haber["dpc_id_pct"] = $id_pct;
                            $this->gsatelite->ingresar('dpc_detalle_partida', $haber);
                        }
                    }
                    return $id_pct;
                }
            } else {
                return 0;
            }
        } else {
            redirect('/auth/login/');
        }
    }

    public function configuracion_pago_docente()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            if ($_POST) {
                $area       = $this->input->post('area');
                $docente    = $this->input->post('docente');
                $frecuencia = $this->input->post('frecuencia');
                $fecha      = $this->input->post('fecha');
                $proyeccion = $this->input->post('proyeccion');

                $where = array();
                if ($area != '') {
                    $where['ard_id'] = $area;
                }
                if ($docente != '') {
                    $where['gra_id_dct'] = $docente;
                }
                if ($frecuencia != '') {
                    $where['frh_id'] = $frecuencia;
                }
                if ($fecha != '') {
                    $where['gra_fecha_inicio'] = $fecha;
                }
                if ($proyeccion != '') {
                    $where['pyc_id'] = $proyeccion;
                }

                $data['docente']                   = $docente;
                $where['IFNULL(gra_finalizado,0)'] = 0;
                $data['grupos']                    = $this->registro_academico_model->obtener_grupos($where);
                $html                              = $this->load->view('personal/planilla/detalle_pago_grupos', $data, true);

                echo $html;
            } else {
                $data['grupos'] = $this->registro_academico_model->obtener_grupos();
                $select         = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1), null, '', 'ard_id', true);
                $data["areas"]  = str_replace('<option value="0">Seleccione</option>', '', $select);

                $proyeccion         = $this->gsatelite->get_dropdown('pyc_proyeccion', '{pyc_nombre}', '', array('pyc_estado' => 1), null, '', 'pyc_id', true);
                $data["proyeccion"] = str_replace('<option value="0">Seleccione</option>', '', $proyeccion);

                $select        = $this->gsatelite->get_dropdown('mod_modulo', '{mod_nombre}', '', array('mod_estado' => 1), null, '', 'mod_id', true);
                $data["nivel"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                $frecuencia         = $this->gsatelite->get_dropdown('frh_frecuencia_horario', '{frh_nombre}', '', array('frh_estado' => 1), null, '', 'frh_id', true);
                $data["frecuencia"] = str_replace('<option value="0">Seleccione</option>', '', $frecuencia);

                $data["docentes"] = $this->registro_academico_model->obtener_docentes(array('dct_estado' => '1'));

                $data['titulo_personal'] = "Grupos Académicos";

                $this->_cargarvista($data);
            }
        }
    }

    public function procesar_configuracion_grupo()
    {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //var_dump($post_array);die();

            $configuracion_ids = $post_array['configuracion'];
            $tipoPlanilla      = $post_array['tipoPlanilla'];
            $escalafon         = $post_array['escalafon'];
            $valorHora         = $post_array['valorHora'];
            $grupo             = $post_array['grupo'];
            $tipoPago          = $post_array['tipoPago'];
            $observaciones     = $post_array['observaciones'];

            //Se verifica el conteo de registros
            if (count($tipoPlanilla) > 0) {
                $contador = 0;
                for ($i = 0; $i < count($tipoPlanilla); $i++) {
                    $configuracion_array = array(
                        'cpg_id_gra'             => $grupo[$i],
                        'cpg_id_tpl'             => $tipoPlanilla[$i],
                        'cpg_id_tbe'             => ($escalafon[$i] > 0) ? $escalafon[$i] : null,
                        'cpg_id_usu'             => $this->tank_auth->get_user_id(),
                        'cpg_fecha_registro'     => date('Y-m-d H:i:s'),
                        'cpg_tipo_pago'          => ($tipoPago[$i] > 0) ? $tipoPago[$i] : 0,
                        'cpg_valor_hora'         => ($valorHora[$i] > 0) ? $valorHora[$i] : 0,
                        'cpg_observacion'        => (isset($observaciones[$i])) ? $observaciones[$i] : null,
                        'cpg_estado'             => 1,
                        'cpg_usu_creacion'       => $this->tank_auth->get_user_id(),
                        'cpg_fecha_creacion'     => date('Y-m-d H:i:s'),
                        'cpg_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'cpg_fecha_modificacion' => date('Y-m-d H:i:s'),
                    );

                    //Se actualizara
                    if ($configuracion_ids[$i] > 0 && $tipoPlanilla[$i] > 0) {
                        unset($configuracion_array['cpg_estado']);
                        unset($configuracion_array['cpg_fecha_creacion']);
                        unset($configuracion_array['cpg_usu_creacion']);
                        unset($configuracion_array['cpg_id_gra']);

                        $this->gsatelite->actualizar_array('cpg_configuracion_pago_grupo', $configuracion_array, array('cpg_id' => $configuracion_ids[$i]));
                        $contador++;
                    } else if ($configuracion_ids[$i] == 0 && $tipoPlanilla[$i] > 0) {
                        //Se ingresara
                        $this->gsatelite->ingresar('cpg_configuracion_pago_grupo', $configuracion_array);
                        $contador++;
                    }
                }

                if ($contador > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Configuración de grupo", 'texto_alerta' => "Se procesaron " . $contador . " grupos");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Configuración de grupo", 'texto_alerta' => "No se proceso ningun grupo.");
                }

                $this->session->set_flashdata($alerta);
                redirect('/personal/planilla/configuracion_pago_docente');
            }
        }
    }

    public function pago_docentes_sustitutos($consulta = null)
    {
        satelite_validar();
        if ($this->input->post()) {
            if ($consulta == null) {
                $post_array = $this->input->post();
                // var_dump($post_array);die();
                $contador = 0;
                if (count($post_array['hdnAplicarSustitucion']) > 0) {
                    for ($i = 0; $i < count($post_array['hdnAplicarSustitucion']); $i++) {
                        $sustituto_array = array(
                            'stm_pagado_planilla' => 1,
                            'stm_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'stm_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        if ($post_array['slcPlanilla'][$i] != '') {
                            $sustituto_array['stm_id_pla'] = $post_array['slcPlanilla'][$i];
                        }

                        $this->gsatelite->actualizar_array('stm_sustituto_maestro', $sustituto_array, array('stm_id' => $post_array['hdnAplicarSustitucion'][$i]));
                        $contador++;
                    }
                }

                if ($contador > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Pago de sustitutos", 'texto_alerta' => "Se autorizaron " . $contador . " registros");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Pago de sustitutos", 'texto_alerta' => "No se proceso ningun registros.");
                }

                $this->session->set_flashdata($alerta);
                redirect('/personal/planilla/pago_docentes_sustitutos');
            } else {
                $area    = $this->input->post('area');
                $docente = $this->input->post('docente');

                $data['docente']                   = $docente;
                $where['IFNULL(gra_finalizado,0)'] = 0;
                $where['IFNULL(stm_pagado_planilla,0)'] = 0;
                if ($area != '') {
                    $where['ard_id'] = $area;
                }
                if ($docente != '') {
                    $where['gra_id_dct'] = $docente;
                }

                $where['stm_id_pla IS NOT NULL'] = null;
                $data['sustitutos'] = $this->registro_academico_model->obtener_maestros_sustituto($where);
                // var_dump($data['sustitutos']);die();
                $html = $this->load->view('personal/planilla/detalle_pago_sustitutos', $data, true);

                echo $html;
                die();
            }
        }

        $data["docentes"]        = $this->registro_academico_model->obtener_docentes(array('dct_estado' => '1'));
        $select                  = $this->gsatelite->get_dropdown('ard_area_academica', '{ard_nombre}', '', array('ard_estado' => 1), null, '', 'ard_id', true);
        $data["areas"]           = str_replace('<option value="0">Seleccione</option>', '', $select);
        $data['titulo_personal'] = "Pago Docentes Sustitutos";
        cargarvista($data);
    }
}
