<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

	class Empleado extends CI_Controller
	{
		public function __construct()
		{
			parent::__construct();
			$this->load->model('personal_model');
			// $this->load->model('consultas');
			$this->load->model('consultas');
			$this->load->model('gsatelite');
			$this->load->model('inventario_model');
			$this->load->model('compras_model');
			$this->load->library('grocery_CRUD');
			$this->load->library('Procesos');
			$this->load->model('planilla_model');
			$this->load->library('tank_auth');
			$this->driver =  $this->planilla_model;
			$this->load->library('excel/excel_reader.php');
		}

		public function ficha_empleado($id_emp)
		{
			if (!$this->tank_auth->is_logged_in()) {
				redirect('/auth/login/');
			} else {
				$data['empleado'] = $this->planilla_model->info_completa_empleado($id_emp);
				$data['documentos'] = $this->planilla_model->documentos_emp($id_emp);
				$data['familiares'] = $this->planilla_model->familiares_empleado($id_emp);
				$data['more_info'] = $this->planilla_model->get_empleados_reporte(array('emp_id'=>$id_emp));
				$data['foto'] = $this->personal_model->foto_empleado($id_emp);
				$html  = $this->load->view('reporte/header', array('titulo' => 'Ficha de empleado'), true);
				$html .= $this->load->view('personal/empleado/ficha_empleado', $data, true);
				$this->load->library('pdf');
				$reporte=$this->pdf->reportePDF2($html);

			}

		}

		public function carga_masiva()
		{ //se movio a personal/empleado
			redirect('personal/planilla/carga_masiva');
			$data['titulo_personal']="Registro masivo de ingresos o descuentos";
			$this->_cargarvista($data);	
		}

		public function procesar_xls(){ //se movio a personal/empleado
			if (!$this->tank_auth->is_logged_in()) {
				redirect('/auth/login/');
			} else {
				$excel = new Excel_reader;
				$excel->read($_FILES["excelfile"]["tmp_name"]);

				$nombre_planilla=$this->db->get_where('tpl_tipo_planilla', array('tpl_id' => $_POST['tipo_planilla']))->row_array();
				$data['tipo_planilla']= $nombre_planilla['tpl_nombre'];
				$data['id_planilla']=$nombre_planilla['tpl_id'];

				//obtener el id del periodo de planilla y consultar por la fecha de inicio y sumar le un dia para que entre dentro
				//de dicho periodo el ingreso o descuento respectivo
				$id_plani = $this->input->post('periodo_planilla');
				$pla = $this->gsatelite->get_tabla('pla_planilla',array('pla_id'=>$id_plani));
				$fecha =$pla[0]['pla_fecha_inicio']; 
  		        $fecha_p = date("Y-m-d",strtotime("$fecha +1 day")); //adelantarme un dia para estar mas seguro de la captura del descuento en dicho periodo
				$data['fecha_periodo']=$fecha_p;
				
				//$data['fecha_periodo']=$_POST['fecha_periodo'];
				$tipo_carga=$this->inventario_model->cargar_todo('tac_tipo_carga',array('tac_id'=>$_POST['tipo_carga']));
				$data['tac_tipo_carga']=$tipo_carga[0]['tac_id'];

	    		$nr_sheets = count($excel->sheets);       // gets the number of sheets
	    		$excel_data = '';
	     		// to store the the html tables with data of each sheet

	    		// traverses the number of sheets and sets html table with each sheet data in $excel_data
				for($i=0; $i<$nr_sheets; $i++) {
					if($excel->sheets[$i]['numCols']<=6){
						$re_h = '<center><table border="1" class="responsive table table-bordered contenedor" style="width:75%" id="data_expand" name="data_expand">';     // starts html table
						$re_h.='<thead>';
						$re_h.='<tr>';
						$re_h.='<th colspan="1">';
						$re_h.='CÓDIGO EMPLEADO';
						$re_h.='</th>';
						$re_h.='<th colspan="1">';
						$re_h.='CÓDIGO '.$tipo_carga[0]['tac_nombre'];
						$re_h.='</th>';
						$re_h.='<th colspan="1">';
						$re_h.='CANTIDAD';
						$re_h.='</th>';
						$re_h.='<th colspan="1">';
						$re_h.='MONTO';
						$re_h.='</th>';
						$re_h.='<th colspan="1">';
						$re_h.='CONCEPTO';
						$re_h.='</th>';
						$re_h.='<th colspan="1">';
						$re_h.='PERMANENTE';
						$re_h.='</th>';
						$re_h.='<th colspan="1">';
						$re_h.='CUOTAS';
						$re_h.='</th>';
						$re_h.='</tr>';
						$re_h.='</thead>';

						$excel_data .= '<center><h4>(<em>'. $excel->boundsheets[$i]['name'] .'</em>)</h4></center>'.$re_h. $this->sheetData($excel->sheets[$i],$nombre_planilla['tpl_id'],$_POST['tipo_carga']) .'<br/>';  
					}else{
						$excel_data .='<center><h4>(<em>'. $excel->boundsheets[$i]['name'] .'</em>)</h4></center><br/><center><h3>';
						$excel_data .='La hoja actual no cumple con el formato de dos columnas: " [COD_EMPLEADO][COD_DESCUENTO Ó INGRESO][MONTO][CONCEPTO][PERMANENTE][CUOTAS] "</h3><br/>';
						$excel_data .='<h4>Favor revisar documento de excel y cantidad de columas seleccionadas</h4></center><br/>';
					}
				}

				$data['tabla_html']=$excel_data;

				$data['tipo_transaccion'] =$this->inventario_model->cargar_todo('tip_tipo_proceso',array('tip_ajuste'=>1));
				$data['titulo_personal']='Carga de '.$data['tac_tipo_carga'];
				$this->_cargarvista($data);
			}
		}

	function sheetData($sheet,$tipo_planilla,$ingreso_descuento=null) {
		$re='<tbody id="contenedor">';

		$unpacker=$this->procesar_info($sheet,$tipo_planilla,$ingreso_descuento);		
		$x = 1;
		while($x <= $sheet['numRows']) {
			$re .= "<tr>\n";
			$y = 1;
			while($y < $sheet['numCols']) {

				$cell = isset($sheet['cells'][$x][$y]) ? $sheet['cells'][$x][$y] : '';
				$re .= "<td style='text-align: left;'>";

				if($unpacker[$y-1][$x-1]!="Empleada/o no encontrado para este tipo de planilla"){
					if($unpacker[$y-1][$x-1]!=''){
						switch($y){
							case 1:
							$re .= "[".$cell."] ".$unpacker[$y-1][$x-1]."<input type='hidden' name='empleado[]' class='empleado' value='".$cell."'/></td>\n";
							break;
							case 2:
							//descuento o ingreso
							$datosing_des = explode('#', $unpacker[$y-1][$x-1]); //extraer los valores a  mostrar
							$cantidad = ($unpacker[$y]['factor_'.($x-1)] != 1)? $unpacker[$y][$x-1]:1;
							$re.="<input type='hidden' name='descuento[]' value='".$datosing_des[0]."'/>"." [".$datosing_des[0]."] ".$datosing_des[1]. "</td>\n";
							$re.="<td style='text-align: left;'>".$cantidad."<input type='hidden' name='cantidad[]' value='".$cantidad."'/></td>";

							//monto
							

							if($unpacker[$y][$x-1]=='.00'){
								$re.="<td style='text-align: left;'><input type='hidden' name='factor[]' value='1'/>
									<input type='hidden' name='monto[]' id='monto' class='detalle_monto' value='".$unpacker[$y][$x-1]."'/>"; 
								$re.='$ '.number_format(($unpacker[$y][$x-1]),2,'.','')."</td>\n";
							}else{
								$re.="<td style='text-align: left;'><input type='hidden' name='factor[]' value='".$unpacker[$y]['factor_'.($x-1)]."'/>
									<input type='hidden' class='detalle_monto' name='monto[]' id='monto' value='".($unpacker[$y][$x-1]*$unpacker[$y]['factor_'.($x-1)])."'/>";
								$re.= '$ '.number_format(($unpacker[$y][$x-1]*$unpacker[$y]['factor_'.($x-1)]),2,'.','')."</td>\n";
							}
							break;
							case 3:
								if ($unpacker[$y][$x-1] != ""){
									$re.=$unpacker[$y][$x-1] . "<input type='hidden' name='concepto[]' value='".$unpacker[$y][$x-1]."'/></td>";
								} else{
									$re.="<input type='hidden' name='concepto[]' value=''/>-</td>";
								}
							break;
							case 4:
								if ($unpacker[$y][$x-1] != ""){
									$re.=$unpacker[$y][$x-1] . "<input type='hidden' name='permanente[]'  value='".$unpacker[$y][$x-1]."'/></td>";
								} else{
									$re.="<input type='hidden' name='permanente[]' value='0'/>-</td>";
								}
							break;
							case 5:
								if (trim($unpacker[$y][$x-1]) != ""){
									$re.=$unpacker[$y][$x-1] . "<input type='hidden' name='cuotas[]' value='".$unpacker[$y][$x-1]."'/></td>";
								} else{
									$re.="<input type='hidden' name='cuotas[]' value='1'/>-</td>";
								}

							break;
							default:
							$re.="<td style='text-align: left;'>---</td>";
							break;
						}
					}else{
						if($y==2){
							$re.="-</td><td class='noencontrado' >-</td>\n";
						}else{
							$re.="-</td>\n";
						}
					}
				}else{
					if($y==2){
						$re.="-</td>\n";
					}else{
						$re.=$unpacker[$y-1][$x-1]."-</td><td></td>\n";
					}
				}
				$y++;
			}  
			$re .= "</tr>\n";
			$x++;
		}
		
	    return $re .'</tbody></table></center>';     // ends and returns the html table
	}

	  function procesar_info($hoja,$planilla,$ingreso_des=null){
		$condiciones[0]	= array();//Empleado
	    $condiciones[1]	= array();//descuento/ingresos
		$condiciones[2]	= array();//cantidad/monto
		$condiciones[3]	= array();//concepto
		$condiciones[4]	= array();//permanente
	    $condiciones[5]	= array();//cuotas
	 
		$result 		= [];
	    $x = 1;
	    while($x <= $hoja['numRows']) {
	      $y = 1;
	      while($y <= $hoja['numCols']) {
	          $cell = isset($hoja['cells'][$x][$y]) ? $hoja['cells'][$x][$y] : '';

	            $condiciones[$y-1]=array_merge($condiciones[$y-1],array($cell));

	          $y++;
		  }
		  //echo $x.'<br />';
	      $x++;
		}
		//echo utf8_encode($condiciones[0][0]);
		//print_r($condiciones[0]); die();
	    foreach ($condiciones[0] as $key => $valor) {
			$factor_total	= 1;
			$valor_factor	= false;
				if($condiciones[0][$key]!=''){
				$id_emp=$this->db->select('emp_id')->where('emp_codigo',trim($condiciones[0][$key]))->from('emp_empleado')->get()->result_array();
			//echo $this->db->last_query(); die();

				$resulters=$this->db->select()
									->join('emp_empleado','emp_id=txe_id_emp')
									->where('txe_id_tpl',$planilla)
									->where('txe_id_emp',@$id_emp[0]['emp_id'])
									->from('txe_tipo_planillaxempleado')->get()->row_array();
			

				//preguntar si el descuento o ingreso existe
				if($ingreso_des== 1){
					$valor_ingre_des="0#no existe ingreso";
					$pre = $this->gsatelite->get_tabla('tig_tipo_ingreso',array('tig_codigo'=>$condiciones[1][$key]));
					if(count($pre)>0){ 
						$valor_ingre_des	= $condiciones[1][$key]."#".$pre[0]['tig_nombre']; 
						$factor_total 	= ($pre[0]["tig_factor"] != "" or $pre[0]["tig_factor"] != null)?$pre[0]["tig_factor"]:"1";
						$valor_factor	= ($pre[0]["tig_factor"] != "" or $pre[0]["tig_factor"] != null)?true:false;
					}

				} elseif ($ingreso_des==2) {
					$valor_ingre_des="0#no existe descuento";
					$pre = $this->gsatelite->get_tabla('tdc_tipo_descuento',array('tdc_codigo'=>$condiciones[1][$key]));
					if(count($pre)>0){ 
						$valor_ingre_des= $condiciones[1][$key]."#".$pre[0]['tdc_nombre']; 
						$factor_total 	= ($pre[0]["tdc_factor"] != "" or $pre[0]["tdc_factor"] != null)?$pre[0]["tdc_factor"]:"1";
						$valor_factor	= ($pre[0]["tdc_factor"] != "" or $pre[0]["tdc_factor"] != null)?true:false;
				}
			}
		
	        if(isset($resulters['txe_id_emp'])){

	          $result[0][$key]= $resulters['emp_nombre'].' '.$resulters['emp_apellido'];
			  $result[1][$key]= ($valor_factor == true)? $valor_ingre_des. " (factor: ".round($factor_total,2).")":$valor_ingre_des;
			  $result[2][$key]= $condiciones[2][$key];
			  $result[3][$key]= utf8_encode($condiciones[3][$key]);
			  $result[4][$key]= $condiciones[4][$key];
			  $result[5][$key]= ($condiciones[4][$key] ==1 )? 0 :$condiciones[5][$key];
			  $result[2]["factor_".$key]= $factor_total;
	        }else{
				$result[0][$key]="Empleada/o no encontrado para este tipo de planilla";
	          	$result[1][$key]="";
			  	$result[2][$key]="";
			  	$result[3][$key]="";
				$result[4][$key]="";
				$result[5][$key]="";
	        }
	      }else{
	        $result[0][$key]="";
	        $result[1][$key]="";
			$result[2][$key]="";
			$result[3][$key]="";
			$result[4][$key]="";
			$result[5][$key]="";
	      }
		}
	    return $result;
	  }

	  public function insertar_masivo(){
		  
	  	$empleado=$_POST['empleado'];
	  	$dssoinn=$_POST['descuento'];
		$monto=$_POST['monto'];
		
		$concepto=$_POST['concepto'];
		$permanente=$_POST['permanente'];
		$cuotas=$_POST['cuotas'];

		$cantidades=$_POST['cantidad'];
		$factor=$_POST['factor'];
		
	  	$fecha=date("Y-m-d",strtotime($_POST['fecha_periodo']));
	  	$planilla=$_POST['tipo_planilla'];
	  	$tipo_mov=$_POST['tipo'];
	  	$cantidad=count($empleado);
	  	$ids_insertados=array(0);
		$j=0;		
		
		$id_usuario = $this->tank_auth->get_user_id();
		$fecha_auditoria = date('Y-m-d H:i:s');
		$clave_reporte = $id_usuario."_".str_replace(array('-',' ',':'), '', $fecha_auditoria);
	  	for ($i=0; $i < $cantidad ; $i++) { 
			$existe_emp=$this->db->get_where('emp_empleado', array('emp_codigo' => trim($empleado[$i]) ))->result_array();

	  		if($tipo_mov==1 && $monto[$i] > 0 && $existe_emp[0]['emp_id'] > 0 ){
				$exite_inn=$this->db->get_where('tig_tipo_ingreso', array('tig_codigo' => trim($dssoinn[$i]) ))->result_array();		
	  			$array=array(
	  				'inn_id_tig'		=> $exite_inn[0]["tig_id"],
	  				'inn_id_emp'		=> $existe_emp[0]['emp_id'],
	  				'inn_motivo'		=> ( $concepto[$i] != "")?$concepto[$i]:"Carga Masiva",
	  				'inn_valor'			=> $monto[$i],
	  				'inn_fecha_desde'	=> $fecha,
	  				'inn_cuota'			=> (trim($cuotas[$i]) > 0 && trim($permanente[$i]) != 1 ) ? $cuotas[$i] : ((trim($permanente[$i]) == 1) ? 0 : 1),
	  				'inn_cuota_pagada'	=> 0,
	  				'inn_id_tpl'		=> $planilla,
					'inn_permanente'	=> $permanente[$i],
					'inn_masivo'		=> 1,  
					'inn_cantidad'		=> $cantidades[$i],
					'inn_factor'		=> $factor[$i],
	  				'inn_estado'		=> 1,
	  				'inn_usu_crea'		=> $id_usuario,
	  				'inn_fecha_crea'	=> $fecha_auditoria,
	  				'inn_usu_mod'		=> $id_usuario,
	  				'inn_fecha_mod'		=> $fecha_auditoria
	  				);
	  			if(count($exite_inn)> 0 && count($existe_emp) > 0){
	  				$id_ing 			= $this->gsatelite->ingresar('inn_ingreso',$array);
	  				$ids_insertados[] 	= $id_ing;
	  				//$this->db->insert('inn_ingreso',$array);
	  				$j++;
				  }
			  }
	  		elseif($tipo_mov==2 && $monto[$i] > 0 && $existe_emp[0]['emp_id'] > 0 ){
	  			$exite_tdc	=	$this->db->get_where('tdc_tipo_descuento', array('tdc_codigo' => trim($dssoinn[$i]) ))->result_array();
	  			$array=array(
	  				'dss_id_tdc'		=> $exite_tdc[0]["tdc_id"],
	  				'dss_id_emp'		=> $existe_emp[0]['emp_id'],
	  				'dss_motivo'		=> ( $concepto[$i] != "")?$concepto[$i]:"Carga Masiva",
	  				'dss_valor'			=> $monto[$i],
	  				'dss_fecha_desde'	=> $fecha,
	  				'dss_fecha'			=> $fecha,
	  				'dss_cuota'			=> (trim($cuotas[$i]) > 0 && trim($permanente[$i]) != 1 ) ? $cuotas[$i] : ((trim($permanente[$i]) == 1) ? 0 : 1),
	  				'dss_cuota_pagada'	=> 0,
	  				'dss_id_tpl'		=> $planilla,
					'dss_permanente'	=> $permanente[$i],
					'dss_masivo'		=> 1,
					'dss_cantidad'		=> $cantidades[$i],
					'dss_factor'		=> $factor[$i],
	  				'dss_estado'		=> 1,
	  				'dss_usu_crea'		=> $id_usuario,
	  				'dss_fecha_crea'	=> $fecha_auditoria,
	  				'dss_usu_mod'		=> $id_usuario,
	  				'dss_fecha_mod'		=> $fecha_auditoria
	  			);
	  			if(count($exite_tdc)>0 && count($existe_emp)>0){
	  				//$this->db->insert('dss_descuento',$array);
	  				$id_des 			= $this->gsatelite->ingresar('dss_descuento',$array);
	  				$ids_insertados[] 	= $id_des;
	  				$j++;
	  			}
	  		}
	  	}
		$this->session->set_flashdata('clave_reporte', $clave_reporte);
	  	$this->session->set_flashdata('tipo_carga', $tipo_mov);
	  	$this->session->set_flashdata('ids_insertados', $ids_insertados);
	  	$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Carga masiva",'texto_alerta'=>"Los registros fueron ingresados");
		$this->session->set_flashdata($alerta);
		redirect('personal/planilla/carga_masiva');
	  		
	  	
	  }

	  function reporte_carga_masiva($key_reporte="", $tipo=0) {
	  	if($this->session->flashdata('tipo_carga')!="" || trim($key_reporte) != '' ) {
	  		$ids = $this->session->flashdata('ids_insertados');
			$tipo = ($tipo > 0 )? $tipo:$this->session->flashdata('tipo_carga');
			$titulo = ($tipo == 1)?"INGRESOS":"DESCUENTOS";  
	       //   	echo	var_dump($ids); die();
	  		if($tipo==1){
	  		$this->db->join('emp_empleado','emp_id=inn_id_emp');
			$this->db->join('tig_tipo_ingreso','tig_id=inn_id_tig');
			if(trim($key_reporte) != "")
				$this->db->where("CONCAT(inn_usu_crea,'_',DATE_FORMAT(inn_fecha_crea,'%Y%m%d%H%i%s'))",$key_reporte);
			else
				$this->db->where_in('inn_id',$ids);
	  		$data['consulta'] = $this->gsatelite->get_tabla('inn_ingreso');
	  		}
	  		elseif ($tipo==2) {
	  		$this->db->join('emp_empleado','emp_id=dss_id_emp');
	  		$this->db->join('tdc_tipo_descuento','tdc_id=dss_id_tdc');
	  		if(trim($key_reporte) != "")
	  			$this->db->where("CONCAT(dss_usu_crea,'_',DATE_FORMAT(dss_fecha_crea,'%Y%m%d%H%i%s'))",$key_reporte);
	  		else
	  			$this->db->where_in('dss_id',$ids);
	  		$data['consulta'] = $this->gsatelite->get_tabla('dss_descuento');
	  		 }
	  		// echo $this->db->last_query(); die();
	  		$data['tipo']=$tipo;
	  		$html = $this->load->view('personal/empleado/reporte_carga_masiva', $data, true);
	  		$html_header  = $this->load->view('reporte/header', array('solotitulo'=>true,'titulo' => $titulo." PROCESADOS"), true);
	  		$this->load->library('pdf');
	  		$this->pdf->makePDF($html_header.$html);

	  	}
	  	else {
	  	echo "<h3>No existe datos procesados</h3>";
	  	}
	  }

		public function index_agregar_empleado()
		{
			if (!$this->tank_auth->is_logged_in()) {
				redirect('/auth/login/');
			} else {
				$data['total_empleados'] = $this->personal_model->listado_empleados();
				$titulo['titulo_personal'] = "Gestión de empleados";
				$this->_cargarvista($titulo, $data);
			}
		}
		public function ingresos_descuentos()
		{ //se movio a personal/empleado
			if (!$this->tank_auth->is_logged_in()) {
				redirect('/auth/login/');
			} else {
				$where['emp_estado'] = (isset($_POST['slcEstado']) && $_POST['slcEstado'] == 0)? 0:1;
				$data['estado_emp'] = $where['emp_estado'];
				$data['total_empleados'] = $this->personal_model->listado_empleados($where);
				$titulo['titulo_personal'] = "Ingresos y descuentos empleado";
				$this->_cargarvista($titulo, $data);
			}
		}
		public function guardar_gral($parametros, $carpeta=null)
	    {
	    	
	        $datos= @explode($parametros);
	        $carpeta=$parametros;

	        $image = $this->upload_gral($carpeta);

	        //echo base_url().'/public/temp/'.$image['upload_data']['raw_name'].$image['upload_data']['file_ext'];
	        echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
	        //echo $image['upload_data']['client_name'];
	    }
	    function upload_gral($carpeta)
	    {
	    	if ($carpeta=="assets") {
	    		$ruta=FCPATH . "assets/uploads/images";
	    	}else{
	    		$ruta=FCPATH . "public/temp/" . $carpeta;
	    	}
	        
	        if(!file_exists($ruta)){
	            mkdir($ruta, 0777);
	        }

	        $obj = &get_instance();
	        $config['upload_path'] = $ruta;
	        $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx';
	        $obj->load->library('upload', $config);
	        if (!$obj->upload->do_upload()) {
	            $error = array('error' => $obj->upload->display_errors());
	            return true;
	        } else {
	            $data = array('upload_data' => $obj->upload->data());
	            return $data;
	        }
	        print_r($data);
	    }
	    function eliminar_imagen_gral($carpeta="")
	    {
	       
	        $url = $this->input->post("url");
	        echo $url;
	        $carp = ($carpeta != "") ? $carpeta : "documentos";
	        
	        unlink("./public/temp/$carp/" . $url);
	    }
		public function eliminar_empleado($emp_id)
		{
			if (!$this->tank_auth->is_logged_in()) {
				redirect('/auth/login/');
			} else {
				$array = array('emp_estado' => 0 );
				$this->db->where('emp_id',$emp_id)
						 ->update('emp_empleado',$array);
				$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Empleada/o desactivado",'texto_alerta'=>"La operación a sido realizada con exito");
				$this->session->set_flashdata($alerta);
				redirect ('personal/empleado/index_agregar_empleado');
			}
		}

		public function reactivar_empleado($emp_id)
		{
			if (!$this->tank_auth->is_logged_in()) {
				redirect('/auth/login/');
			} else {
				$array = array('emp_estado' => 1 );
				$this->db->where('emp_id',$emp_id)
						 ->update('emp_empleado',$array);
				$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Empleada/o reactivado",'texto_alerta'=>"La operación a sido realizada con exito");
				$this->session->set_flashdata($alerta);
				redirect ('personal/empleado/index_agregar_empleado');
			}
		}
		
		function editar_ingreso($id_emp = null, $id_est = null, $ingreso_id = null){
			if (!$this->tank_auth->is_logged_in()) {
				redirect('/auth/login/');
			} else {
				if ($_POST) {
					$inn_id = $this->input->post('id_inn');
					$emp_id = $this->input->post('id_emp');
					$fac_cn = (float)$this->input->post('factor_conv_i');
					$monto  = (float)$this->input->post('monto_aumentar');
					$valor 	= $monto * $fac_cn;
					$psp    = ($this->input->post('slc_presupuesto') != '')?$this->input->post('slc_presupuesto'):null;
					$acg    = ($this->input->post('slc_actividad_general')!= '')?$this->input->post('slc_actividad_general'):null;
					$ace    = ($this->input->post('slc_actividad_espeficifica') != '')?$this->input->post('slc_actividad_espeficifica'):null;

					$editar = array(
						'inn_permanente' => ($this->input->post('permanente_in') != "") ? $this->input->post('permanente_in') : 0,
						'inn_id_tig' => $this->input->post('tipo_ingreso'),
						'inn_motivo' => $this->input->post('con_ingreso'),
						'inn_id_psp' => $psp,
						'inn_id_acg' => $acg,
						'inn_id_ace' => $ace,
						'inn_id_tpl' => $this->input->post('tipo_planilla_in'),
						'inn_valor' => str_replace(',', '', $valor),
						'inn_fecha_desde' => date('Y-m-d',strtotime($this->input->post('fecha_desde_in'))),
						'inn_cuota' => ($this->input->post('permanente_in') == 1) ? 0 : $this->input->post('cuotas_in'),
						'inn_observacion' => $this->input->post('observaciones_in'),
						'inn_estado' => ($this->input->post('estado_in')>0)? 1:0,
						'inn_usu_mod' => $this->tank_auth->get_user_id(),
						'inn_fecha_mod' => date('Y-m-d h:i:s') 
					);
					$respuesta = $this->gsatelite->actualizar_array('inn_ingreso', $editar, array('inn_id'=>$inn_id));

					$urls=$this->input->post('ruta2');
					$names=$this->input->post('ruta');
					$i=0;
					foreach ($urls as $key => $value2) {
						$this->db->insert('axg_anexo_ingreso', array(
						'axg_id_inn' => $inn_id,
						'axg_nombre' => $names[$i],
						'axg_url' => $value2,
						'axg_estado' =>1,
						'axg_fecha_creacion' => date('Y-m-d H:i:s'),
						'axg_fecha_modificacion' => date('Y-m-d H:i:s'),
						'axg_usu_creacion' => $this->tank_auth->get_user_id(),
						'axg_usu_modificacion' => $this->tank_auth->get_user_id()));
						$i++;
					}
					$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registro Ingresado",'texto_alerta'=>"El registro se ha actualizado correctamente.");
					$this->session->set_flashdata($alerta);
					redirect('personal/planilla/ingreso_descuento_empleado/' . $emp_id);
				}else{
					$data['id_inn'] = $ingreso_id;
					$data['tipo_ingreso'] = $this->gsatelite->get_tabla('tig_tipo_ingreso',array('tig_estado'=>1));
					$this->db->where('txe_id_emp',$id_emp);
					$this->db->join('txe_tipo_planillaxempleado','txe_id_tpl=tpl_id');
					$data['planilla'] = $this->gsatelite->get_tabla('tpl_tipo_planilla');
					$ingreso = $this->gsatelite->get_tabla('inn_ingreso',array('inn_id'=>$ingreso_id));
					$factor  = $this->gsatelite->get_campo('tig_tipo_ingreso','tig_factor',array('tig_id'=>$ingreso[0]['inn_id_tig']));
					$data['ingreso'] = $ingreso;
					// Obtenemos el permiso del parametro para pintar los controles de otros datos					  
		            $per = false;
		            $c   = ($this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA') != '')?$this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA'):null;
		            if ($c != null) {
		                $array_id = explode(',', $c);
		                if (in_array($this->tank_auth->get_user_id(), $array_id)) {
		                    $per = true;
		                }
		            }		            
		            $data['permiso_param'] = $per;
		            // Preseleccionamos el proyecto ligado al ingreso
		            $psp = ($ingreso[0]['inn_id_psp'] != '')?$ingreso[0]['inn_id_psp']:null;
	                $acg = ($ingreso[0]['inn_id_acg'] != '')?$ingreso[0]['inn_id_acg']:null;
	                $ace = ($ingreso[0]['inn_id_ace'] != '')?$ingreso[0]['inn_id_ace']:null;
		            $proyectos_reg = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
	                $select_proyecto = '<option value=""></option>';
	                foreach ($proyectos_reg as $key) {
	                    $selected = '';
	                    if($psp != null){
	                    	$proye    = $this->gsatelite->get_campo('psp_presupuesto','psp_id_pcl',array('psp_id' => $psp));
	                        $selected = ($proye == $key['pcl_id'])?'selected':'';
	                    }
	                    $nombre_cliente = (trim($key['cli_personeria']) == 1)?trim($key['cli_nombre'].' '.$key['cli_apellido']):trim($key['cli_apellido']);
	                    $nombre = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
	                    $select_proyecto .= '<option value="'.$key['pcl_id'].'" data-cliente="'.$nombre_cliente.'" '.$selected.'>'.$nombre.'</option>';
	                }
	                $data['proyectos'] = $select_proyecto;
	                $proyec  = $this->gsatelite->get_campo('psp_presupuesto','psp_id_pcl',array('psp_id' => $psp));
	                $slc_presupuesto            = ($psp != "" )?$this->get_presupuestoxproyecto($proyec, $psp):'<option value=""></option>';
		            $data['presupuesto']        = $slc_presupuesto;
		            $slc_general                = ($acg != "" )?$this->get_actividades_generalesxpresupusto($psp, $acg,false,false):'<option value=""></option>';
		            $data['general']            = $slc_general;
		            $slc_especifica             = ($ace != "" )?$this->get_actividades_especificas_x_actividad_general($acg, $psp, $ace,true):'<option value=""></option>';
		            $data['especifica']         = $slc_especifica;
		            //fin de proyectos
					$data['empid'] = $id_emp;
					$data['factor']  = ($factor != null && $factor != '') ? $factor : '1.00';
					$data['anexos']  = $this->gsatelite->get_tabla('axg_anexo_ingreso',array('axg_id_inn'=>$ingreso_id));
					$data['titulo_personal'] = "Editar Ingreso";
					$titulo['titulo_personal'] = "Ingresos";
					//$this->gsatelite->cargar_vista_masterpage('personal/empleado/editar_ingreso',$data,true);
            		cargarvista($data, null, 'personal/empleado/editar_ingreso');
				}
			}
		}

    public function agregar_ingreso($id)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->load->model('personal_model');
            $data['info']             = $this->personal_model->info_empleado($id);
            $data['id_empleado_crud'] = $id;
            $nombre_empleado          = $data['info'][0]['emp_apellido'] . ', ' . $data['info'][0]['emp_nombre'];
            $data['ver_ingresos']     = $this->personal_model->ingresos_empleado($id);
            $data['ver_descuentos']   = $this->personal_model->descuentos_empleado($id);

            if ($data['info'][0]['emp_salario'] <= 0) {
                $data['tipo_ingreso'] = $this->personal_model->tipo_ingreso(null, null, true);
            } else {
                $data['tipo_ingreso'] = $this->personal_model->tipo_ingreso();
            }
            $data['titulo_personal'] = "Ingresos y descuentos <b style='font-size:14px;'>($nombre_empleado)</b>";
            $data['tipo_descuento']  = $this->personal_model->tipo_descuento(false, null, 1);
            $data['estado']          = $this->personal_model->tipo_descuento();

            $ids_tpl  = array(0);
            $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id));
            foreach ($pregunta as $fila) {$ids_tpl[] = $fila['txe_id_tpl'];}
            $this->db->where_in('tpl_id', $ids_tpl);
            $select                = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, null, '', 'tpl_id', true);
            $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $id_descuento_isss                                      = $this->gsatelite->get_parametro('DESCUENTO_ISS');
            $configuracion_incapacidad                              = explode('##', $this->gsatelite->get_parametro('CONFIGURACION_INCAPCIDAD_EMPLEADO'));
            $data['n_dias_cubierto_empresa']                        = $configuracion_incapacidad[0];
            $data['porcentaje_n_dias_cubierto_empresa']             = $configuracion_incapacidad[1];
            $data['porcentaje_n_dias_cubierto_empresa_adicionales'] = $configuracion_incapacidad[2];
            $data['porcentaje_n_dias_cubierto_seguro_adicionales']  = $this->gsatelite->get_parametro('PORCENTAJE_INCAPACIDA_SEGURO');

            $data['salario_base_calculo'] =
            $registro_isss                = $this->gsatelite->get_tabla('tdc_tipo_descuento', array('tdc_id' => $id_descuento_isss));
            //preguntar si el salario del empleado no sobrepasa el techo permitido para cálculo del isss
            $salario_base_calculo          = ($data['info'][0]['emp_salario'] > $registro_isss[0]['tdc_maximo']) ? $registro_isss[0]['tdc_maximo'] : $data['info'][0]['emp_salario'];
            $data['salario_base_calculo']  = $salario_base_calculo;
            $data['salario_base_empleado'] = $data['info'][0]['emp_salario'];

            // Datos de proyectos //////////////////////////
            $per = false;
            $c   = ($this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA') != '') ? $this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA') : null;
            if ($c != null) {
                $array_id = explode(',', $c);
                if (in_array($this->tank_auth->get_user_id(), $array_id)) {
                    $per = true;
                }
            }

            $data['permiso_param'] = $per;
            $proyectos_reg         = $this->compras_model->get_proyectos(array('pcl_estado' => 1, 'cli_estado' => 1, 'epr_cierre' => 0));
            $select_proyecto       = '<option value=""></option>';
            foreach ($proyectos_reg as $key) {
                $selected = '';
                if ($rxi_id != null) {
                    $selected = ($data['requisicion_data'][0]['rxi_id_pcl'] == $key['pcl_id']) ? 'selected' : '';
                }
                $nombre_cliente = (trim($key['cli_personeria']) == 1) ? trim($key['cli_nombre'] . ' ' . $key['cli_apellido']) : trim($key['cli_apellido']);
                $nombre         = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
                $select_proyecto .= '<option value="' . $key['pcl_id'] . '" data-cliente="' . $nombre_cliente . '" ' . $selected . '>' . $nombre . '</option>';
            }
            $data['proyectos'] = $select_proyecto;
            ////////////////////////////////////////////////
            cargarvista($data, null, 'personal/empleado/agregar_ingreso');
            //$this->_cargarvista($titulo,$data);
        }
    }

    public function agregar_descuento($id)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->load->model('personal_model');
            $data['info']             = $this->personal_model->info_empleado($id);
            $data['id_empleado_crud'] = $id;
            $nombre_empleado          = $data['info'][0]['emp_apellido'] . ', ' . $data['info'][0]['emp_nombre'];
            $data['ver_ingresos']     = $this->personal_model->ingresos_empleado($id);
            $data['ver_descuentos']   = $this->personal_model->descuentos_empleado($id);

            if ($data['info'][0]['emp_salario'] <= 0) {
                $data['tipo_ingreso'] = $this->personal_model->tipo_ingreso(null, null, true);
            } else {
                $data['tipo_ingreso'] = $this->personal_model->tipo_ingreso();
            }
            $data['titulo_personal'] = "Ingresos y descuentos <b style='font-size:14px;'>($nombre_empleado)</b>";
            $data['tipo_descuento']  = $this->personal_model->tipo_descuento(false, null, 1);
            $data['estado']          = $this->personal_model->tipo_descuento();

            $ids_tpl  = array(0);
            $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id));
            foreach ($pregunta as $fila) {$ids_tpl[] = $fila['txe_id_tpl'];}
            $select = '';
            			$this->db->where_in('tpl_id', $ids_tpl);
            $tablaTpl = $this->gsatelite->get_tabla('tpl_tipo_planilla', array('tpl_estado' => 1));
            foreach ($tablaTpl as $key => $val) {
            	$select .= '<option value="'.$val['tpl_id'].'" data-cantidad="'.$val['tpl_cantidad'].'" >'.$val['tpl_nombre'].'</option>';
            }
            $data["select_tpl_id"] = $select;

            $id_descuento_isss                                      = $this->gsatelite->get_parametro('DESCUENTO_ISS');
            $configuracion_incapacidad                              = explode('##', $this->gsatelite->get_parametro('CONFIGURACION_INCAPCIDAD_EMPLEADO'));
            $data['n_dias_cubierto_empresa']                        = $configuracion_incapacidad[0];
            $data['porcentaje_n_dias_cubierto_empresa']             = $configuracion_incapacidad[1];
            $data['porcentaje_n_dias_cubierto_empresa_adicionales'] = $configuracion_incapacidad[2];
            $data['porcentaje_n_dias_cubierto_seguro_adicionales']  = $this->gsatelite->get_parametro('PORCENTAJE_INCAPACIDA_SEGURO');

            $data['salario_base_calculo'] =
            $registro_isss                = $this->gsatelite->get_tabla('tdc_tipo_descuento', array('tdc_id' => $id_descuento_isss));
            //preguntar si el salario del empleado no sobrepasa el techo permitido para cálculo del isss
            $salario_base_calculo          = ($data['info'][0]['emp_salario'] > $registro_isss[0]['tdc_maximo']) ? $registro_isss[0]['tdc_maximo'] : $data['info'][0]['emp_salario'];
            $data['salario_base_calculo']  = $salario_base_calculo;
            $data['salario_base_empleado'] = $data['info'][0]['emp_salario'];

            // Datos de proyectos //////////////////////////
            $per = false;
            $c   = ($this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA') != '') ? $this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA') : null;
            if ($c != null) {
                $array_id = explode(',', $c);
                if (in_array($this->tank_auth->get_user_id(), $array_id)) {
                    $per = true;
                }
            }

            $data['permiso_param'] = $per;
            $proyectos_reg         = $this->compras_model->get_proyectos(array('pcl_estado' => 1, 'cli_estado' => 1, 'epr_cierre' => 0));
            $select_proyecto       = '<option value=""></option>';
            foreach ($proyectos_reg as $key) {
                $selected = '';
                if ($rxi_id != null) {
                    $selected = ($data['requisicion_data'][0]['rxi_id_pcl'] == $key['pcl_id']) ? 'selected' : '';
                }
                $nombre_cliente = (trim($key['cli_personeria']) == 1) ? trim($key['cli_nombre'] . ' ' . $key['cli_apellido']) : trim($key['cli_apellido']);
                $nombre         = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
                $select_proyecto .= '<option value="' . $key['pcl_id'] . '" data-cliente="' . $nombre_cliente . '" ' . $selected . '>' . $nombre . '</option>';
            }
            $data['proyectos'] = $select_proyecto;
            ////////////////////////////////////////////////
            cargarvista($data, null, 'personal/empleado/agregar_descuento');
            //$this->_cargarvista($titulo,$data);
        }
    }

		//funciones
		 public function get_presupuestoxproyecto($proyecto = "", $seleccionado = "" , $evaluar_post = true) {
        if ($_POST && $evaluar_post) { 
            $proyecto = ($this->input->post('proyecto') != false)? $this->input->post('proyecto'): $proyecto;
        }
        $where = array(
            'psp_estado'            => 1,
            'psp_id_pcl'            => $proyecto,
            'psp_estado_prespuesto' => 2
        );
        $presupuestos   = $this->gsatelite->get_tabla("psp_presupuesto",$where);
        $html           = '<option value=""></option>';
        foreach ($presupuestos as $value) {
            $selected   = "";
            if ( $value['psp_id'] == $seleccionado) {
                $selected = "selected";
            }
            $html .= '<option value="'.$value['psp_id'].'" '.$selected.'>'.$value['psp_nombre'].'</option>';
        }
        if ($_POST && $evaluar_post) {
            echo trim($html);
        } else {
            return trim($html);
        }
    }

    function get_actividades_generalesxpresupusto($presupuesto = "", $seleccionado = "", $evaluar_post = true, $evaluar_usuario = true) {
        satelite_validar();
        if ($_POST && $evaluar_post) { 
            $presupuesto = $this->input->post('presupuesto');
        }
        $where = array(
            'dps_estado'    => 1,
            'dps_id_psp'    => $presupuesto
        );
        $select                 = "*, 
        (
        sum(dps_presupuesto_actividad) - IFNULL(
        (
        SELECT
        SUM(dgp_monto)
        FROM
        dgp_detalle_gasto_prespuesto
        WHERE
        dgp_id_dps = dps_id
        AND dgp_estado = 1
        ),
        0
        )
        ) AS total,
        (
        SELECT
        IFNULL(
        (
        sum(orc_total) - sum(dpv_total)
        ) + sum(dpv_monto_pendiente),
        0
        )
        FROM
        orc_orden_compra
        LEFT JOIN dpv_documento_proveedor ON dpv_id_orc = orc_id
        WHERE
        orc_id_psp = dps_id_psp
        AND orc_id_acg = dps_id_acg
        AND dpv_id = NULL
        ) AS monto_comprometido,
        (
        SELECT
        GROUP_CONCAT(uxa_id_usu)
        FROM
        uxa_usuarioxactividad_general
        WHERE
        uxa_id_acg = acg_id
    ) AS usuarios";
    $group_by               = "acg_id";
    $actividades_generales  = $this->compras_model->get_actividades_x_presupusto($select,$where,$group_by); 

    $html                   = '<option value=""></option>';
    foreach ($actividades_generales as $value) {
        $selected           = "";
        $usuarios_permitidos = array( $this->tank_auth->get_user_id() );
        if ($evaluar_usuario == true) {
            $usuarios_permitidos= explode(",",$value['usuarios']); 
        } 

        $disponible = $value['total'] - $value['monto_comprometido'];
        if ( $value['acg_id'] == $seleccionado) {
            $selected = "selected";
        }
        if ( in_array( $this->tank_auth->get_user_id(), $usuarios_permitidos ) ) {
            $html .= '<option value="'.$value['acg_id'].'" '.$selected.'>'.$value['acg_codigo'].' - '.$value['acg_nombre'].' ($'.number_format( $disponible,2,".",",").')</option>';
        }
    }
    if ($_POST && $evaluar_post) {
        echo trim($html);
    } else {
        return trim($html);
    }   
}

 function get_actividades_especificas_x_actividad_general($general = "", $presupuesto = "", $seleccionado = "", $edicion = false, $evaluar_post = true, $evaluar_usuario = true) {
        satelite_validar();
        
        if ($_POST && $evaluar_post) { 
            $general    = ($this->input->post('general') != false)? $this->input->post('general'): $general;
            $presupuesto= ($this->input->post('presupuesto') != false)? $this->input->post('presupuesto'): $presupuesto;
            $periodo    = ($this->input->post('fecha') != false)? date('Ym', strtotime( $this->input->post('fecha') )): date('Ym');
            $fecha      = ($this->input->post('fecha') != false)? date('Y-m-d', strtotime( $this->input->post('fecha') )): date('Y-m-d');
        } else {
            $periodo    = date('Ym');
            $fecha      = date('Y-m-d');
        }

        $where = array(
            'dps_estado'    => 1,
            'dps_id_psp'    => $presupuesto,
            'dps_id_acg'    => $general
        );
        $group_by               = "ace_id";
        $actividades_generales  = $this->compras_model->get_actividades_especificas_x_actividad_general($fecha, $periodo, $where, $group_by);  
        $html                   = '<option value=""></option>';
        foreach ($actividades_generales as $value) {
            $selected           = "";
            $usuarios_permitidos = array( $this->tank_auth->get_user_id() );
            if ($evaluar_usuario == true) {
                $usuarios_permitidos= explode(",",$value['usuarios_permitidos']); 
            } 
            $disponible         = ($value['total'] - $value['monto_comprometido']) ;
            $disponible_mensual = "";
            //if ( $value['planes'] > 0 ) {
            $disponible_mensual = $value['permitido'] - ($value['monto_comprometido_mensual'] + $value['monto_pagado_mensual']);
            $disponible_mensual = number_format($disponible_mensual,2,".",",");
            //}
            if ( $value['ace_id'] == $seleccionado) {
                $selected = "selected";
            }
            if ( in_array( $this->tank_auth->get_user_id(), $usuarios_permitidos ) ) {
                if ($disponible > 0 or $edicion == true) {
                    $html .= '<option data-monto_disponible_mensual="'.$disponible_mensual.'" data-monto_disponible="'.number_format($disponible,2,".","").'" data-nombre="'.$value['ace_nombre'].'" value="'.$value['ace_id'].'" '.$selected.'>'.$value['ace_codigo'].' - '.$value['ace_nombre'].' ('.number_format($disponible,2,".",",").')</option>';
                }
            }
        }
        if ($_POST && $evaluar_post) {
            echo trim($html);
        } else {
            return trim($html);
        }   
    }




		function editar_descuento_anex($id_emp = null, $id_est = null, $descuento_id = null){
			if (!$this->tank_auth->is_logged_in()) {
				redirect('/auth/login/');
			} else {
				if ($_POST) {
					// var_dump($_POST);die();
					$id_emp = $this->input->post('emp_id');
					$dss_id = $this->input->post('dss_id_id');
					$fac_cn = (float)$this->input->post('factor_conv_d');
					$monto  = (float)$this->input->post('monto_descontar');
					$valor 	= $monto * $fac_cn;
					$editar = array(
						'dss_permanente' => ($this->input->post('permanente_des') != "")?$this->input->post('permanente_des'):0,
						'dss_id_tdc' => $this->input->post('tipo_descuento'),
						'dss_motivo' => $this->input->post('con_descuento'),
						'dss_observacion' => $this->input->post('observaciones_des'),
						'dss_valor' => str_replace(',', '', $valor),
						'dss_referencia' => $this->input->post('referencia_des'),
						'dss_id_tpl' => $this->input->post('tipo_planilla_des'),
						'dss_id_ban' => ($this->input->post('banco_descuento') > 0) ? $this->input->post('banco_descuento') : null,
						'dss_factor' => $fac_cn,
						'dss_fecha_desde' => date('Y-m-d',strtotime($this->input->post('fecha_desde_des'))),
						'dss_cuota' => ($this->input->post('cuotas_des') != "")?$this->input->post('cuotas_des'):0,
						'dss_estado' => ($this->input->post('estado_des')>0)? 1:0,
						'dss_usu_mod' => $this->tank_auth->get_user_id(),
						'dss_fecha_mod' => date('Y-m-d h:i:s') 
                    );
					$respuesta = $this->gsatelite->actualizar_array('dss_descuento', $editar, array('dss_id'=>$dss_id));
					$urls=$this->input->post('ruta2');
					$names=$this->input->post('ruta');
					$i=0;
					foreach ($urls as $key => $value2) {
						$this->db->insert('axd_anexo_descuento', array(
							'axd_id_dss' => $dss_id,
							'axd_nombre' => $names[$i],
							'axd_url' => $value2,
							'axd_estado' =>1,
							'axd_fecha_creacion' => date('Y-m-d H:i:s'),
							'axd_fecha_modificacion' => date('Y-m-d H:i:s'),
							'axd_usu_creacion' => $this->tank_auth->get_user_id(),
							'axd_usu_modificacion' => $this->tank_auth->get_user_id()));
						$i++;
					}
					$inactivar = array('dss_estado' => 0, 'dss_usu_mod' => $this->tank_auth->get_user_id(), 'dss_fecha_mod' => date("Y-m-d H:i:s"));
					if ($dss_id > 0 && $this->input->post('cuotas_hijas') > 0) {
						// PONER TODO EN ESTADO CERO LUEGO EN EL UPDATE SE VUELVE A ESTADO 1
						$this->gsatelite->actualizar_array('dss_descuento', $inactivar, array('dss_id_dss_padre' => $dss_id));
						$ids_hijos = $this->input->post('id_dss');
						$hijo_fecha = $this->input->post('fecha_hija');
						$hijo_refer = $this->input->post('referencia_hija');
						$hijo_valor = $this->input->post('monto_hijo');
						$hijo_concp = $this->input->post('concepto_hijo');
						foreach ($hijo_fecha as $k => $val) {
							if (trim($val) != "") {
								$desc_asoc = array(
									'dss_id_tpl' 	   => $this->input->post('tipo_planilla_des'),
									'dss_id_tdc' 	   => $this->input->post('tipo_descuento'),
									'dss_id_dss_padre' => $dss_id,
									'dss_referencia'   => $hijo_refer[$k],
									'dss_motivo'	   => $hijo_concp[$k],
									'dss_observacion'  => $this->input->post('observaciones_des'),
									'dss_permanente'   => ($this->input->post('permanente_des') == 1) ? 1 : 0,
									'dss_id_ban' 	   => ($this->input->post('banco_descuento') > 0) ? $this->input->post('banco_descuento') : null,
									'dss_valor' 	   => ($hijo_valor[$k] * $fac_cn),
									'dss_factor'	   => $fac_cn,
									'dss_fecha_desde'  => formatear_fecha('Y-m-d', $val),
									'dss_cuota' 	   => $this->input->post('cuotas_des'),
									'dss_estado' 	   => $this->input->post('estado_des'),
									'dss_fecha_mod'    => date("Y-m-d H:i:s"),
									'dss_usu_mod' 	   => $this->tank_auth->get_user_id()
								);
								if ($ids_hijos[$k] > 0) {
									$this->gsatelite->actualizar_array('dss_descuento', $desc_asoc, array('dss_id' => $ids_hijos[$k]));
								} else {
									$desc_asoc['dss_id_emp'] = $id_emp;
									$desc_asoc['dss_cuota_pagada'] = 0;
									$desc_asoc['dss_fecha'] = date('Y-m-d H:i:s');
									$desc_asoc['dss_fecha_crea'] = date("Y-m-d H:i:s");
									$desc_asoc['dss_usu_crea'] = $this->tank_auth->get_user_id();
									$id_new = $this->gsatelite->ingresar('dss_descuento', $desc_asoc);
								}							
							}
						}
					} else {
						// acp_id_dss | acp_accion_personal  NO SE SI SE SIGUE USANDO  || axd_id_dss aqui no aplica
						// SI HA QUEDADO PASARLOS A ESTADO 0  O SINO  LUEGO  BORRAR/-1
						$this->gsatelite->actualizar_array('dss_descuento', $inactivar, array('dss_id_dss_padre' => $dss_id));
						// ddd_detalle_descuento  | BUSCAR CADA UNO DE LOS HIJOS, SI NO HAY NADA, BORRARLO, SINO ESTADO -1 ?
					}
					$exito = 1;
					$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registro Ingresado",'texto_alerta'=>"El registro se ha actualizado correctamente.");
					$this->session->set_flashdata($alerta);
					redirect('personal/empleado/mantenimiento_edit_descuentos');
				}else{
					$data['dss_id'] = $descuento_id;
					$data['tipo_descuento'] = $this->gsatelite->get_tabla('tdc_tipo_descuento');					
					$descuento = $this->gsatelite->get_tabla('dss_descuento',array('dss_id'=>$descuento_id));
					$factor    = $this->gsatelite->get_campo('tdc_tipo_descuento','tdc_factor',array('tdc_id'=>$descuento[0]['dss_id_tdc']));

					$select = '';
								$this->db->join('txe_tipo_planillaxempleado', 'tpl_id = txe_id_tpl');
					$tablaTpl = $this->gsatelite->get_tabla('tpl_tipo_planilla', array('tpl_estado' => 1, 'txe_id_emp' => $descuento[0]['dss_id_emp']));
					foreach ($tablaTpl as $key => $val) {
						$slcted = ($val['tpl_id'] == $descuento[0]['dss_id_tpl']) ? 'selected' : '';
						$select .= '<option value="'.$val['tpl_id'].'" data-cantidad="'.$val['tpl_cantidad'].'" '.$slcted.' >'.$val['tpl_nombre'].'</option>';
					}
					$data["planilla"] = $select;

					$data['descuento'] = $descuento;
					$data['factor']  = ($factor != null && $factor != '') ? $factor : '1.00';
					$data['anexos'] = $this->gsatelite->get_tabla('axd_anexo_descuento',array('axd_id_dss'=>$descuento_id));
					$data['asociados'] = $this->gsatelite->get_tabla('dss_descuento', array('dss_estado' =>1, 'dss_id_dss_padre' => $descuento_id));
					$data['tipo_plan'] = $this->gsatelite->get_tabla('tpl_tipo_planilla', array('tpl_id' => $descuento[0]['dss_id_tpl']));
					$titulo['titulo_personal'] = "Ingresos";
					// cargarvista($data, null, 'personal/empleado/editar_descuento_anex');
					$this->gsatelite->cargar_vista_masterpage('personal/empleado/editar_descuento_anex',$data,true);
				}
			}
		}

		public function eliminar_anex_dss($anexo=null){
  		if($_POST){
  			$anexo = $this->input->post('anexo');
  			$emp = $this->input->post('emp');
  		}
		if($anexo!=null){
			$axe = $this->gsatelite->borrado_general('axd_anexo_descuento',array('axd_id'=>$anexo));
			
			$where_anx = array('axd_id'=>$anexo);
			$url = $this->gsatelite->get_campo('axd_anexo_descuento','axd_url',$where_anx);
			$result = $this->gsatelite->borrado_general('axd_anexo_descuento',$where_anx);
			if(unlink($url)){
				echo $result;
			}
		}
	}


	public function eliminar_anex_inn($anexo=null){
  		if($_POST){
  			$anexo = $this->input->post('anexo');
  			
  		}
		if($anexo!=null){
			$axe = $this->gsatelite->borrado_general('axg_anexo_ingreso',array('axg_id'=>$anexo));
			
			$where_anx = array('axg_id'=>$anexo);
			$url = $this->gsatelite->get_campo('axg_anexo_ingreso','axg_url',$where_anx);
			$result = $this->gsatelite->borrado_general('axg_anexo_ingreso',$where_anx);
			if(unlink($url)){
				echo $result;
			}
		}
	}

		function ingreso_editar()
		{
			if (!$this->tank_auth->is_logged_in()) {
				redirect('/auth/login/');
			} else {
				$ingreso = $this->input->post('inn_id');
				$resultado = $this->planilla_model->editar_ingreso($ingreso);
				if($resultado === TRUE)
				{

					$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Actualización Completada",'texto_alerta'=>"La actualización de los datos a sido exitosa");
					$this->session->set_flashdata($alerta);
					redirect('personal/empleado/index_agregar_empleado');
				}
				else{
					$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"No se pudo actualizar el registro",'texto_alerta'=>"Corrobore los datos y vuelva a intentar");

					$this->session->set_flashdata($alerta);
					redirect('personal/empleado/editar_ingreso/'.$descuento);
				}
			}
		}
		function editar_descuento($descuento_id)
		{
			if (!$this->tank_auth->is_logged_in()) {
				redirect('/auth/login/');
			} else {
				$data['tipo_descuento'] = $this->personal_model->tipo_descuento();
			/*print_r($this->db->last_query());
			exit();*/
			$data['informacion'] = $this->planilla_model->editar_descuento_info($descuento_id);
			$titulo['titulo_personal'] = "Edición de descuento";

			$this->_cargarvista($titulo,$data);
		}
	}

	function descuento_editar($id_emp,$id_est,$descuento)
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
			$descuento = $this->input->post('dss_id');
			$resultado = $this->planilla_model->editar_descuento($descuento);

			if($resultado === TRUE)
			{

				$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Actualización Completada",'texto_alerta'=>"La actualización de los datos a sido exitosa");
				$this->session->set_flashdata($alerta);
				redirect('personal/empleado/index_agregar_empleado');
			}
			else{
				$alerta=array('tipo_alerta'=> 'notice','titulo_alerta'=>"No se pudo actualizar el registro",'texto_alerta'=>"Corrobore los datos y vuelva a intentar");
				
				$this->session->set_flashdata($alerta);
				redirect('personal/empleado/editar_descuento/'.$descuento);
			}
		}
	}
	function agregar_empleado()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
			$data['genero']=$this->personal_model->get_genero();
			$data['nacionalidad']=$this->personal_model->get_nacionalidad();
			$data['estado_civil']=$this->personal_model->get_estado_civil();
			$data['profesion']=$this->personal_model->get_profesion();
			$data['tipo_telefono']=$this->personal_model->get_tipotelefono();
			$data['afp']=$this->personal_model->get_afp();
			$data['doc_documentos']=$this->personal_model->get_documentos();
			$tipos_doc = $this->gsatelite->get_dropdown('tde_tipo_documento', '{tde_nombre}','',array('tde_estado'=>1), null, '', 'tde_id', true);
			$data['options_tipo_documento'] = str_replace('<option value="0">Seleccione</option>', '',$tipos_doc);
			$data['puesto']=$this->personal_model->get_puesto();
			$data['departamento']=$this->personal_model->get_departamento();
			$data['sucursal']=$this->personal_model->get_sucursal();
			$data['tipo_contrato']=$this->personal_model->get_tipo_contrato();
			//$data['imagenes']=$this->utm
			$data['parentescos']=$this->personal_model->get_parentesco();
			$titulo['titulo_personal'] = "Nuevo empleado";
			$this->_cargarvista($titulo,$data);		

		}
	}
	public function editar_empleado($emp_id)
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {

			$data['genero']=$this->personal_model->get_genero();
			$data['nacionalidad']=$this->personal_model->get_nacionalidad();
			$data['estado_civil']=$this->personal_model->get_estado_civil();
			$data['profesion']=$this->personal_model->get_profesion();
			$data['tipo_telefono']=$this->personal_model->get_tipotelefono();
			$data['afp']=$this->personal_model->get_afp();
			$data['doc_documentos']=$this->personal_model->get_documentos();
			$data['parentescos_cat']=$this->personal_model->get_parentesco();
			$data['puesto']=$this->personal_model->get_puesto();
			$data['departamento']=$this->personal_model->get_departamento();
			$data['sucursal']=$this->personal_model->get_sucursal();
			$data['tipo_contrato']=$this->personal_model->get_tipo_contrato();
			$data['informacion'] = $this->personal_model->editar_empleado($emp_id);
			$data['telefonos'] = $this->personal_model->editar_tel_empleado($emp_id);
			$data['documentos'] = $this->personal_model->editar_doc_empleado($emp_id);
			$data['parentescos'] = $this->personal_model->editar_fam_empleado($emp_id);
			$data['anexos'] = $this->personal_model->anexo_empleado($emp_id);
			$data['foto'] = $this->personal_model->foto_empleado($emp_id);
			$titulo['titulo_personal'] = "Gestión de empleados";
			$this->_cargarvista($titulo,$data);
		}
	}
	function nuevo_empleado()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
			//print_r($_POST);
			//exit();
			$nuevo  = array(
				'emp_id_suc' => $this->input->post('sucursal') ,
				'emp_id_pto' => $this->input->post('puesto'), 
				'emp_id_afp' => $this->input->post('afp'),
				'emp_codigo' => $this->input->post(''),
				'emp_nombre' => $this->input->post('nombres'),
				'emp_apellido' => $this->input->post('apellidos'),
				'emp_estado' => $this->input->post('estado'),
				'emp_direccion' => $this->input->post('direccion'),
				'emp_id_are' => $this->input->post('departamento'),
				'emp_telefono' =>$this->input->post(''),
				'emp_lugar_nac' => $this->input->post('lugar_nacimiento'),
				'emp_id_pai' => $this->input->post('nacionalidad'),
				'emp_fecha_nac' => date('Y-m-d',strtotime($this->input->post('fecha_nacimiento'))),
				'emp_id_gen' => $this->input->post('genero'),
				'emp_id_pro' => $this->input->post('profesion'),
				'emp_id_esc' => $this->input->post('estado_civil'),
				'emp_fecha_contrato' => date('Y-m-d',strtotime($this->input->post('fecha_contratacion'))),
				'emp_fecha_retiro' => $this->input->post(''),
				'emp_salario' => $this->input->post('salario'),
				'emp_usu_mod' => $this->tank_auth->get_user_id(),
				'emp_fecha_mod' => date('Y-m-d h:i:s'),
				'emp_codigo' =>$this->input->post('codigo_emp'),			
				);
	$this->db->insert('emp_empleado', $nuevo);
	$emp_id = $this->db->insert_id();
	 
	$tpl=$this->input->post('tipo_contrato');
	for ($i=0; $i <count($tpl) ; $i++) { 
	$this->db->insert('txe_tipo_planillaxempleado',array('txe_id_tpl' => $tpl[$i] , 'txe_id_emp' => $emp_id));
	}

	$array= $this->input->post('telefono');
	$ver = array_pop($array);
	$array_tit=$this->input->post('tipo_telefono');
	$ver_tit=array_pop($array_tit);
	$i=0;
	foreach ($array as $key => $value) {
	 if(trim($value) !="") { 
		$this->db->insert('tel_telefono',array(
			'tel_numero' => $value,
			'tel_id_tit'=> $array_tit[$i]));
		
		$tel_id = $this->db->insert_id();
		$this->db->insert('txm_telefonoxempleado',array(
			'txm_id_tel'=> $tel_id,
			'txm_id_emp'=>$emp_id));
		}
	$i++;
		
	}


	$array2=$this->input->post('numero_documento');
	//$ver2= array_pop($array2);
	$array2_1 = $this->input->post('documento');
	//$ver2_1 = array_pop($array2_1);
	$array_vence_doc = $this->input->post('vence_documento');
	$array_titulo_anexo = $this->input->post('titulo_anexo_doc');
	$array_nombre_anexo = $this->input->post('nombre_anexo_doc');
	$carpeta = $this->input->post("nombre_anexo_carpeta"); 

	$i=0;
	foreach ($array2 as $key => $value2) {
		
		$titulo_a = trim($array_titulo_anexo[$i]);
		$url_anexo="";
		$f_vence = (trim($array_vence_doc[$i])!="" and $array_vence_doc[$i] != null )? date('Y-m-d',strtotime(trim($array_vence_doc[$i]))):null;
		if($titulo_a!="") {
		$extencion =end(explode(".",$array_nombre_anexo[$i]));
		//$url_anexo= "uploads/anexos_empleados/".trim($array_titulo_anexo[$i]).".".trim($extencion);
		$url_anexo = trim($array_titulo_anexo[$i]).".".trim($extencion); //se modifico de esta manera porque se uso grocery para su edicion.
		$this->datos_anexo_documento(trim($array_nombre_anexo[$i]),$carpeta,$titulo_a); //funcion para guardar el anexo
		}

		$this->db->insert('dce_documento_emp', array(
			'dce_id_tde' => $array2_1[$i],
			'dce_id_emp' => $emp_id,
			'dce_valor' => $value2,
			'dce_fecha_registro' => date('Y-m-d') ,
			'dce_fecha_vence' => $f_vence,
			'dce_nombre_anexo' => $titulo_a ,
			'dce_url' => $url_anexo,
			'dce_usu_mod' => $this->tank_auth->get_user_id(),
			'dce_fecha_mod' => date('Y-m-d H:i:s')));
	//	$dce_id= $this->db->insert_id();
	//	$this->db->where('dce_id',$dce_id);
	//	$this->db->update('dce_documento_emp',array('dce_id_tde' => $array2_1[$i]));
		$i++;
	}



	$array3=$this->input->post('familiar_nombre');
	$array3_1 = $this->input->post('familiar_apellido');
	$array3_2 = $this->input->post('familiar_tipo');
	$array3_3 = $this->input->post('familiar_telefono');
	$i=0;
	foreach ($array3 as $key => $value3) {
		if($value3 != ""){
		$this->db->insert('fam_familiar', array(
			'fam_nombre' => $value3,
			'fam_apellido' => $array3_1[$i],
			'fam_estado' => 1,
			'fam_id_pat' =>$array3_2[$i],
			'fam_id_emp' =>$emp_id,
			'fam_telefono' => $array3_3[$i],
			'fam_usu_mod' =>$this->tank_auth->get_user_id(),
			'fam_fecha_mod' => date('Y-m-d H:i:s')));
		}
		$i++;
	}

	$rutas = $this->input->post("ruta");
	$carpeta = $this->input->post("nombreCarpeta");

	if (count($rutas) > 0) {
		$carpeta = $carpeta;
		for ($i = 0; $i < count($rutas); $i++) {
			if ($rutas[$i] != "") {
				$img = $rutas[$i];
				$titulo = $this->input->post("titulo_doc" . $i);
				$this->datos_imagen_gral($img,$emp_id,$carpeta,$titulo);
			}
		}
	}

	if($this->input->post('foto_empleado')!="" and $this->input->post('titulo_foto_empleado')!="") { //guardar la foto del empleado
		$titulo=$this->input->post('titulo_foto_empleado');
		$img=$this->input->post('foto_empleado');
		$this->datos_imagen_gral($img,$emp_id,$carpeta,$titulo,1);//es de tipo foto
	}


		$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registro de personal",'texto_alerta'=>"El registro se guardo correctamente");
	                    
	          $this->session->set_flashdata($alerta);


		redirect('personal/empleado/index_agregar_empleado?resultado=1');

	}
	}

	public function datos_imagen_gral($img,$id_emp,$carpeta,$titulo_doc,$tipo=0){
		$extencion =end(explode(".",$img));
		$datos_1 = $this->session->keep_flashdata('datos_1');
		$nombre= trim($img);
		$ruta= "public/temp/".$carpeta."/".$nombre;
		/*if($extencion=='jpg' || $extencion=='jepg' || $extencion=='png'){
			$tipo=1;
		}
		else{$tipo=0;} */

		$destino= "uploads/anexos_empleados/".$titulo_doc.".".trim($extencion)."";
		$array_anex=array(
			'anx_url'=> $destino,
			'anx_nombre'=>$titulo_doc,
			'anx_estado'=>1,
			'anx_usu_mod'=>$this->tank_auth->get_user_id(),
			'anx_fecha_mod'=>date('Y-m-d H:i:s'),
			'anx_usu_crea'=>$this->tank_auth->get_user_id(),
			'anx_fecha_crea'=>date('Y-m-d H:i:s'),
			'anx_imagen'=>$tipo
			);
		$this->db->insert("anx_anexo",$array_anex);
		$id_anexo= $this->db->insert_id();
		$array_anex_doc=array(
			'axe_id_emp'=> $id_emp,
			'axe_id_anx' => $id_anexo,
			'axe_estado'=>1,
			'axe_usu_mod'=>$this->tank_auth->get_user_id(),
			'axe_fecha_mod'=>date('Y-m-d H:i:s')

			);
		$this->db->insert("axe_anexoxempleado",$array_anex_doc);
		$carpeta_destino="uploads/anexos_empleados/".$titulo_doc.".".trim($extencion)."";

	    copy($ruta,$carpeta_destino);
		unlink($ruta);

	}
	public function datos_anexo_documento($img,$carpeta,$titulo_doc){
		$extencion =end(explode(".",$img));
		$nombre= trim($img);
		$ruta= "public/temp/".$carpeta."/".$nombre;
		$carpeta_destino="uploads/anexos_empleados/".$titulo_doc.".".trim($extencion)."";
	    copy($ruta,$carpeta_destino);
		unlink($ruta);
	}

	function validar_codigo($tipo=null)
	{

		if($tipo==2){ $campo = 'emp_expediente';
		}else{ $campo = 'emp_codigo'; }

		$codigo=$this->input->post('codigo');
		$id=$this->input->post('id');


		if(isset($id) && $id>0){
			$validar_codigo=$this->db->select('emp_codigo, emp_expediente, emp_id')
			->from('emp_empleado')
			->where('emp_id <>',$id)
			->where($campo,$codigo)
			->get()->result_array();

			if(count($validar_codigo)>0){

				if($validar_codigo[0]['emp_id']==$id){
					$id=$validar_codigo[0]['emp_id'];
				}
				$codigo=$this->gsatelite->get_campo('emp_empleado', $campo, array('emp_id'=>$id));
			}
			else{
				$id=0;
			}
		}
		else
		{
			$validar_codigo=$this->db->select('emp_codigo, emp_expediente, emp_id')
			->from('emp_empleado')
			->where($campo,$codigo)
			->get()->result_array();
			if(count($validar_codigo)>0){
				$id=$validar_codigo[0]['emp_id'];
			}
			else{
				$id=0;
			}
			$codigo='';
	        if($id>0){
	            $last=$this->consultas->get_max_codigo('emp_empleado',$campo);
	            $code=$last->codigo;
	            $cod= (float)$code+1;
	            $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
	        }
		}
		

		$data=array(
			'id'=>$id,
			'codigo'=>$codigo,
			'response'=>true);
		echo json_encode($data);

	}

	function validar_codigo2($tipo=null)
	{

		if($tipo==2){ $campo = 'sle_expediente';
		}else{ $campo = 'sle_codigo'; }

		$codigo=$this->input->post('codigo');
		$id=$this->input->post('id');


		if(isset($id) && $id>0){
			$validar_codigo=$this->db->select('sle_codigo, sle_expediente, sle_id')
			->from('sle_solicitante_empleo')
			->where('sle_id <>',$id)
			->where($campo,$codigo)
			->get()->result_array();

			if(count($validar_codigo)>0){

				if($validar_codigo[0]['sle_id']==$id){
					$id=$validar_codigo[0]['sle_id'];
				}
				$codigo=$this->gsatelite->get_campo('sle_solicitante_empleo', $campo, array('sle_id'=>$id));
			}
			else{
				$id=0;
			}
		}
		else
		{
			$validar_codigo=$this->db->select('sle_codigo, sle_expediente,sle_id')
			->from('sle_solicitante_empleo')
			->where($campo,$codigo)
			->get()->result_array();
			if(count($validar_codigo)>0){
				$id=$validar_codigo[0]['sle_id'];
			}
			else{
				$id=0;
			}
			$codigo='';
	        if($id>0){
	            $last=$this->consultas->get_max_codigo('sle_solicitante_empleo',$campo);
	            $code=$last->codigo;
	            $cod= (float)$code+1;
	            $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
	        }
		}
		

		$data=array(
			'id'=>$id,
			'codigo'=>$codigo,
			'response'=>true);
		echo json_encode($data);

	}




	function descuentos_empleado()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
			$titulo['titulo_personal'] = "Editar descuento";
			$data['tipo_descuento'] = $this->personal_model->tipo_descuento();
			$this->_cargarvista($titulo,$data);
		}
	}

	function eliminar_ingreso($id_inn=null){
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
			$emp = $this->db->select('inn_id_emp')->from('inn_ingreso')->where('inn_id',$id_inn)->get()->result_array();
			//PREGUNTAR SI NO POSEE UN DETALLE DE HORAS EXTRAS EN LAS TABLA hxe_hora_extraxempleado
			$registro =  $this->gsatelite->get_registro('inn_ingreso','inn_id',$id_inn);
			$tiene_detalle = $this->gsatelite->get_tabla('ddi_detalle_ingreso',array('ddi_id_inn'=>$id_inn));
			if(count($tiene_detalle) > 0) {
				$registro_pla = $this->gsatelite->get_tabla('pla_planilla',array('pla_id'=>$tiene_detalle[0]['ddi_id_pla']));
				if($registro_pla[0]['pla_estado']==3) {
					//esta autorizada, el registro no podra ser eliminado
					//actualizarlo a estado inactivo y no eliminarlo para que este como referencia
					// $this->gsatelite->actualizar_array('inn_ingreso',array('inn_estado'=>'-1'),array('inn_id'=>$id_inn));
					if($this->input->post('id_ingreso')) { //existe post del ajax
						echo json_encode(array('exito'=>0));
						die();
					} else {
						$alerta = array('tipo_alerta'=> 'error','titulo_alerta'=>"El registro no ha sido eliminado",'texto_alerta'=>"El ingreso ya ha sido autorizado en una planilla");
						$this->session->set_flashdata($alerta);
						redirect('personal/empleado/ingreso_descuento_empleado/'.$emp[0]['inn_id_emp']);
					}
				} else {
					if($registro->inn_id_hxe !="" and $registro->inn_id_hxe != null ){
						$this->gsatelite->borrado_general('hxe_hora_extraxempleado',array('hxe_id'=>$registro->inn_id_hxe));
					}
					//PREGUNTAR SI NO POSEE UN DETALLE DE VACACIONES EN LAS TABLA gva_goce_vacacion
					if($registro->inn_id_gva !="" and $registro->inn_id_gva != null ){
						$this->gsatelite->actualizar_array('gva_goce_vacacion',array('gva_estado'=>'0'),array('gva_id'=>$registro->inn_id_gva));
					}
					//actualizarlo a estado inactivo y no eliminarlo para que este como referencia
					$this->gsatelite->actualizar_array('inn_ingreso',array('inn_estado'=>'-1'),array('inn_id'=>$id_inn));
					/*
					$this->db->where('ddi_id_inn',$id_inn)
					->delete('ddi_detalle_ingreso');
					$this->db->where('inn_id',$id_inn)
					->delete('inn_ingreso');
					*/
				}
			} else {
				if($registro->inn_id_hxe !="" and $registro->inn_id_hxe != null ){
					$this->gsatelite->borrado_general('hxe_hora_extraxempleado',array('hxe_id'=>$registro->inn_id_hxe));
				}
				//PREGUNTAR SI NO POSEE UN DETALLE DE VACACIONES EN LAS TABLA gva_goce_vacacion
				if($registro->inn_id_gva !="" and $registro->inn_id_gva != null ){
				  $this->gsatelite->actualizar_array('gva_goce_vacacion',array('gva_estado'=>'0'),array('gva_id'=>$registro->inn_id_gva));
				}
				//actualizarlo a estado inactivo y no eliminarlo para que este como referencia
				$this->gsatelite->actualizar_array('inn_ingreso',array('inn_estado'=>'-1'),array('inn_id'=>$id_inn));
			}
			//si existe una peticion de ajax para elminar el registro
			if($this->input->post('id_ingreso')) {
				echo json_encode(array('exito'=>1));
				die();
			} else {
				$alerta = array('tipo_alerta'=> 'success','titulo_alerta'=>"El registro a sido eliminado",'texto_alerta'=>"El ingreso para el empleado a sido eliminado");
				$this->session->set_flashdata($alerta);
				redirect('personal/empleado/ingreso_descuento_empleado/'.$emp[0]['inn_id_emp']);
			}
		}
	}   

	function eliminar_descuento($id_dss=null)
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
			$emp = $this->db->select('dss_id_emp')->from('dss_descuento')->where('dss_id',$id_dss)->get()->result_array();
			
			//PREGUNTAR SI NO POSEE UN DETALLE DE VACACIONES EN LAS TABLA gva_goce_vacacion
			$registro =  $this->gsatelite->get_registro('dss_descuento','dss_id',$id_dss);
			
			$tiene_detalle = $this->gsatelite->get_tabla('ddd_detalle_descuento',array('ddd_id_dss'=>$id_dss));
			if(count($tiene_detalle)>0) {
				$registro_pla = $this->gsatelite->get_tabla('pla_planilla',array('pla_id'=>$tiene_detalle[0]['ddd_id_pla']));
				
				if($registro_pla[0]['pla_estado']==3) {
					//esta autorizada, el registro no podra ser eliminado
					//$this->gsatelite->actualizar_array('dss_descuento',array('dss_estado'=>'-1'),array('dss_id'=>$id_dss));
					if($this->input->post('id_descuento')) {
						echo json_encode(array('exito'=>0));
						die();
					} else {
						$alerta = array('tipo_alerta'=> 'error','titulo_alerta'=>"El registro no ha  sido eliminado",'texto_alerta'=>"El descuento ya ha sido autorizado en una planilla");
						$this->session->set_flashdata($alerta);
						redirect('personal/empleado/ingreso_descuento_empleado/'.$emp[0]['dss_id_emp']);
					} 
				} else {
					if($registro->dss_id_gva !="" and $registro->dss_id_gva != null ){
						$this->gsatelite->actualizar_array('gva_goce_vacacion',array('gva_estado'=>'0'),array('gva_id'=>$registro->dss_id_gva));
					}
					//PREGUNTAR SI NO POSEE UN DETALLE DE HORAS EXTRAS EN LAS TABLA hxe_hora_extraxempleado
					if($registro->dss_id_hxe !="" and $registro->dss_id_hxe != null ){
						$this->gsatelite->borrado_general('hxe_hora_extraxempleado',array('hxe_id'=>$registro->dss_id_hxe));
					}
					$this->gsatelite->actualizar_array('dss_descuento',array('dss_estado'=>'-1'),array('dss_id'=>$id_dss));
		
					/*
					$this->db->where('ddd_id_dss',$id_dss)
					->delete('ddd_detalle_descuento');
					$this->db->where('dss_id',$id_dss)
					->delete('dss_descuento'); */
				}

			} else {

				if($registro->dss_id_gva !="" and $registro->dss_id_gva != null ){
				  $this->gsatelite->actualizar_array('gva_goce_vacacion',array('gva_estado'=>'0'),array('gva_id'=>$registro->dss_id_gva));
				}

				//PREGUNTAR SI NO POSEE UN DETALLE DE HORAS EXTRAS EN LAS TABLA hxe_hora_extraxempleado
				if($registro->dss_id_hxe !="" and $registro->dss_id_hxe != null ){
					$this->gsatelite->borrado_general('hxe_hora_extraxempleado',array('hxe_id'=>$registro->dss_id_hxe));
				}
				$this->gsatelite->actualizar_array('dss_descuento',array('dss_estado'=>'-1'),array('dss_id'=>$id_dss));
				/*
				$this->db->where('dss_id',$id_dss)
				->delete('dss_descuento');*/
			}

		

			/*
			$this->db->where('ddd_id_dss',$id_dss)
			->delete('ddd_detalle_descuento');
			$this->db->where('dss_id',$id_dss)
			->delete('dss_descuento');
			*/
			//si existe una peticion de ajax para elminar el registro
			if($this->input->post('id_descuento')) {
				echo json_encode(array('exito'=>1));
			} 
			else{
			$alerta = array('tipo_alerta'=> 'success','titulo_alerta'=>"El registro a sido eliminado",'texto_alerta'=>"El descuento para el empleado a sido eliminado");
			$this->session->set_flashdata($alerta);
			redirect('personal/empleado/ingreso_descuento_empleado/'.$emp[0]['dss_id_emp']);
			}
		}
	}


	function ingreso_descuento_empleado($id) 
	{ //se movio a personal/empleado
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
			redirect('personal/planilla/ingreso_descuento_empleado/'.$id);
			$data['info']= $this->personal_model->info_empleado($id);
            $data['id_empleado_crud'] = $id;
			$nombre_empleado = $data['info'][0]['emp_apellido'] .' '.$data['info'][0]['emp_nombre'];
			$data['ver_ingresos']= $this->personal_model->ingresos_empleado($id);
			$data['ver_descuentos']= $this->personal_model->descuentos_empleado($id);

			if($data['info'][0]['emp_salario']<=0){
				$data['tipo_ingreso'] = $this->personal_model->tipo_ingreso(null,null,true);
			}else{
				$data['tipo_ingreso'] = $this->personal_model->tipo_ingreso();
			}
			$titulo['titulo_personal'] = "Ingresos y descuentos <b style='font-size:14px;'>($nombre_empleado)</b>";
			$data['tipo_descuento'] = $this->personal_model->tipo_descuento();
			$data['estado']= $this->personal_model->tipo_descuento();
			
			$ids_tpl=array(0);
			$pregunta=$this->gsatelite->get_tabla('txe_tipo_planillaxempleado',array('txe_id_emp'=>$id));
			foreach ($pregunta as $fila) {	$ids_tpl[]=$fila['txe_id_tpl'];	}
			$this->db->where_in('tpl_id',$ids_tpl);
			$select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}','', null, null, '', 'tpl_id', true);
	        $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '',$select);
	  		
	  		$id_descuento_isss=$this->gsatelite->get_parametro('DESCUENTO_ISS');
	  		$configuracion_incapacidad=explode('##',$this->gsatelite->get_parametro('CONFIGURACION_INCAPCIDAD_EMPLEADO'));
	  		$data['n_dias_cubierto_empresa']=$configuracion_incapacidad[0];
	  		$data['porcentaje_n_dias_cubierto_empresa']=$configuracion_incapacidad[1];
	  		$data['porcentaje_n_dias_cubierto_empresa_adicionales']=$configuracion_incapacidad[2];
	  		$data['porcentaje_n_dias_cubierto_seguro_adicionales']=$this->gsatelite->get_parametro('PORCENTAJE_INCAPACIDA_SEGURO');
	  		
	  		
	  		$data['salario_base_calculo']=
	  		$registro_isss= $this->gsatelite->get_tabla('tdc_tipo_descuento',array('tdc_id'=>$id_descuento_isss));
	  		//preguntar si el salario del empleado no sobrepasa el techo permitido para cálculo del isss
	  		$salario_base_calculo=($data['info'][0]['emp_salario']>$registro_isss[0]['tdc_maximo'])? $registro_isss[0]['tdc_maximo']:$data['info'][0]['emp_salario']; 
	  		$data['salario_base_calculo']=$salario_base_calculo;
	  		$data['salario_base_empleado']=$data['info'][0]['emp_salario'];

			$this->_cargarvista($titulo,$data);
		}
	}



	function nuevo_descuento() {
		// var_dump($_POST); die();
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
			if($this->input->post('emp_id') <= 0 || $this->input->post('tipo_planilla_des') <= 0 || $this->input->post('tipo_descuento') <= 0){
				$alerta = array('tipo_alerta'=> 'error','titulo_alerta'=>"No se registro el descuento",'texto_alerta'=>"Verifique la informacion a ingresar");
				$this->session->set_flashdata($alerta);
				redirect('personal/empleado/ingresos_descuentos');
			}
			$fecha1 = date('Y-m-d',strtotime($this->input->post('fecha_desde_des') ));
			$emp = $this->input->post('emp_id');
			$fac_cn = (float)$this->input->post('factor_conv_d');
			$monto  = (float)$this->input->post('monto_descontar');
			$valor 	= $monto * $fac_cn;
			$descuento = array(
				'dss_id_emp' 	   => $this->input->post('emp_id'),
				'dss_id_tpl' 	   => $this->input->post('tipo_planilla_des'),
				'dss_id_tdc' 	   => $this->input->post('tipo_descuento'),
				'dss_referencia'   => $this->input->post('referencia_des'),
				'dss_motivo' 	   => $this->input->post('con_descuento'),
				'dss_observacion'  => $this->input->post('observaciones_des'),
				'dss_permanente'   => ($this->input->post('permanente_des') == 1) ? 1 : 0,
				'dss_id_ban'	   => ($this->input->post('banco_descuento') > 0) ? $this->input->post('banco_descuento') : null,
				'dss_valor' 	   => str_replace(',', '', $valor),
				'dss_factor'	   => $fac_cn,
				'dss_fecha' 	   => date('Y-m-d H:i:s'),
				'dss_fecha_desde'  => $fecha1,
				'dss_cuota' 	   => $this->input->post('cuotas_des'),
				'dss_cuota_pagada' => 0,
				'dss_estado' 	   => $this->input->post('estado_des'),
				'dss_fecha_crea'   => date("Y-m-d H:i:s"),
				'dss_usu_crea' 	   => $this->tank_auth->get_user_id(),
				'dss_fecha_mod'    => date("Y-m-d H:i:s"),
				'dss_usu_mod' 	   => $this->tank_auth->get_user_id()
			);
			$existe = $this->gsatelite->get_tabla("dss_descuento",$descuento);
			if($existe) {
				$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Descuento ya ingresado",'texto_alerta'=>"Verifique la informacion a ingresar");
				$this->session->set_flashdata($alerta);
				redirect('personal/empleado/ingreso_descuento_empleado/'.$emp);
			}
			$this->db->insert('dss_descuento',$descuento);
			$dss_id = $this->db->insert_id();
			$urls = $this->input->post('ruta2');
			$names = $this->input->post('ruta');
			$i=0;
			foreach ($urls as $key => $value2) {
				$this->db->insert('axd_anexo_descuento', array(
					'axd_id_dss' => $dss_id,
					'axd_nombre' => $names[$i],
					'axd_url' => $value2,
					'axd_estado' =>1,
					'axd_fecha_creacion' => date('Y-m-d H:i:s'),
					'axd_fecha_modificacion' => date('Y-m-d H:i:s'),
					'axd_usu_creacion' => $this->tank_auth->get_user_id(),
					'axd_usu_modificacion' => $this->tank_auth->get_user_id()));
				$i++;
			}
			if ($dss_id > 0 && $this->input->post('cuotas_hijas') > 0) {
				$hijo_fecha = $this->input->post('fecha_hija');
				$hijo_refer = $this->input->post('referencia_hija'); //
				$hijo_valor = $this->input->post('monto_hijo');
				$hijo_concp = $this->input->post('concepto_hijo');
				foreach ($hijo_fecha as $k => $value) {
					$desc_asoc = array(
						'dss_id_emp'	   => $emp,
						'dss_id_tpl' 	   => $this->input->post('tipo_planilla_des'),
						'dss_id_tdc' 	   => $this->input->post('tipo_descuento'),
						'dss_id_dss_padre' => $dss_id,
						'dss_referencia'   => $hijo_refer[$k],
						'dss_motivo'	   => $hijo_concp[$k],
						'dss_observacion'  => $this->input->post('observaciones_des'),
						'dss_permanente'   => ($this->input->post('permanente_des') == 1) ? 1 : 0,
						'dss_id_ban' 	   => ($this->input->post('banco_descuento') > 0) ? $this->input->post('banco_descuento') : null,
						'dss_valor' 	   => (str_replace(',', '', $hijo_valor[$k]) * $fac_cn),
						'dss_factor'	   => $fac_cn,
						'dss_fecha' 	   => date('Y-m-d H:i:s'),
						'dss_fecha_desde'  => formatear_fecha('Y-m-d', $value),
						'dss_cuota' 	   => $this->input->post('cuotas_des'),
						'dss_cuota_pagada' => 0,
						'dss_estado' 	   => $this->input->post('estado_des'),
						'dss_fecha_crea'   => date("Y-m-d H:i:s"),
						'dss_usu_crea' 	   => $this->tank_auth->get_user_id(),
						'dss_fecha_mod'    => date("Y-m-d H:i:s"),
						'dss_usu_mod' 	   => $this->tank_auth->get_user_id()
					);
					$id_new = $this->gsatelite->ingresar('dss_descuento', $desc_asoc);
				}
			}
			if (!empty($dss_id)){
				$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Inserción de descuento completo",'texto_alerta'=>"Puede ver el descuento en la pestaña de ver descuentos");
				$this->session->set_flashdata($alerta);
			} else {
				$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"No se ingreso el descuento",'texto_alerta'=>"Verifique la informacion a ingresar");
				$this->session->set_flashdata($alerta);
			}
			redirect('personal/empleado/ingreso_descuento_empleado/'.$emp);
		}

	}

	function nuevo_ingreso()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
			if($this->input->post('id_emp')<=0 || $this->input->post('tipo_planilla_in')<=0 || $this->input->post('tipo_ingreso')<=0) {
				$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"No se registro el ingreso",'texto_alerta'=>"Verifique la informacion a ingresar");
				$this->session->set_flashdata($alerta);
				redirect('personal/empleado/ingresos_descuentos');
			}

			$fecha1 = str_replace('/', '-', $this->input->post('fecha_desde_in') );
			$fecha1 = date("Y-m-d",strtotime($fecha1));
			$emp 	= $this->input->post('id_emp');
			$fac_cn = (float)$this->input->post('factor_conv');
			$monto  = (float)$this->input->post('monto_aumentar');
			$valor 	= $monto * $fac_cn;

			$ingreso = array(
				'inn_id_emp'	  => $this->input->post('id_emp'),
				'inn_id_tpl'	  => $this->input->post('tipo_planilla_in'),
				'inn_id_tig'	  => $this->input->post('tipo_ingreso'),
				'inn_referencia'  => $this->input->post('txt_referencia_desde_in'),
				'inn_motivo'	  => $this->input->post('con_ingreso'),
				'inn_observacion' => $this->input->post('observaciones_in'),
				'inn_permanente'  => ($this->input->post('permanente_in')==1)? 1:0,
				'inn_valor'		  => $valor,
				'inn_fecha_desde' => $fecha1,
				'inn_id_psp'      => ($this->input->post('slc_presupuesto') != '')?$this->input->post('slc_presupuesto'):null, 
				'inn_id_acg'      => ($this->input->post('slc_actividad_general') != '')?$this->input->post('slc_actividad_general'):null,
				'inn_id_ace'      => ($this->input->post('slc_actividad_espeficifica') != '')?$this->input->post('slc_actividad_espeficifica'):null,
				'inn_cuota'=> $this->input->post('cuotas_in'),
				'inn_cuota_pagada'=> 0,
				'inn_estado'=> $this->input->post('estado_in'),
				'inn_fecha_crea'=> date("Y-m-d H:i:s"),
				'inn_usu_crea'=> $this->tank_auth->get_user_id(),
				'inn_fecha_mod'=> date("Y-m-d H:i:s"),
				'inn_usu_mod'=> $this->tank_auth->get_user_id()
				);

			$existe = $this->gsatelite->get_tabla("inn_ingreso",$ingreso);
			if($existe) {
				$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Ingreso existente",'texto_alerta'=>"Verifique la informacion a ingresar");
				$this->session->set_flashdata($alerta);
				redirect('personal/empleado/ingreso_descuento_empleado/'.$emp);
			}


			$this->db->insert('inn_ingreso',$ingreso);
			$inn_id=$this->db->insert_id();
			$urls=$this->input->post('ruta2');
			$names=$this->input->post('ruta');
			$max = count($names)/2;
			$i=0;
			
				foreach ($urls as $key => $value2) {
					if ($i < $max ) {
						$this->db->insert('axg_anexo_ingreso', array(
							'axg_id_inn' => $inn_id,
							'axg_nombre' => $names[$i],
							'axg_url' => $value2,
							'axg_estado' =>1,
							'axg_fecha_creacion' => date('Y-m-d H:i:s'),
							'axg_fecha_modificacion' => date('Y-m-d H:i:s'),
							'axg_usu_creacion' => $this->tank_auth->get_user_id(),
							'axg_usu_modificacion' => $this->tank_auth->get_user_id()));
						
					}
					$i++;
				}
	
			if (!empty($inn_id)){

				$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Inserción de ingreso completo",'texto_alerta'=>"Puede ver el ingreso en la pestaña de ver ingresos");
				$this->session->set_flashdata($alerta);
			}
			else{
				$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"No se registro el ingreso",'texto_alerta'=>"Verifique la informacion a ingresar");
				$this->session->set_flashdata($alerta);
			}
			redirect('personal/empleado/ingreso_descuento_empleado/'.$emp);
		}
	}

	function empleado_editar()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
		
	 //die(var_dump($_POST));
			$emp_id = $this->input->post('id');
			$editar  = array(
				'emp_id_suc' => $this->input->post('sucursal') ,
				'emp_id_pto' => $this->input->post('puesto'), 
				'emp_id_afp' => $this->input->post('afp'),
				'emp_codigo' => $this->input->post(''),
				'emp_nombre' => $this->input->post('nombres'),
				'emp_apellido' => $this->input->post('apellidos'),
				'emp_estado' => $this->input->post('estado'),
				'emp_direccion' => $this->input->post('direccion'),
				'emp_telefono' => $this->input->post(''),
				'emp_lugar_nac' => $this->input->post('lugar_nacimiento'),
				'emp_id_pai' => $this->input->post('nacionalidad'),
				'emp_fecha_nac' => date('Y-m-d',strtotime($this->input->post('fecha_nacimiento'))),
				'emp_id_gen' => $this->input->post('genero'),
				'emp_id_pro' => $this->input->post('profesion'),
				'emp_id_esc' => $this->input->post('estado_civil'),
				'emp_fecha_contrato' => date('Y-m-d',strtotime($this->input->post('fecha_contratacion'))),
				'emp_fecha_retiro' => $this->input->post(''),
				'emp_salario' => $this->input->post('salario'),
				'emp_usu_mod' =>  $this->tank_auth->get_user_id(),
				'emp_fecha_mod' => date('Y-m-d h:i:s'),
				'emp_codigo' =>$this->input->post('codigo_emp'),

				);
	$this->db->where('emp_id',$emp_id)
	->update('emp_empleado',$editar);



	$this->db->where('txe_id_emp',$emp_id)
	->delete('txe_tipo_planillaxempleado');

	$tpl=$this->input->post('tipo_contrato');
	for ($i=0; $i < count($tpl) ; $i++) { 
	$this->db->insert('txe_tipo_planillaxempleado',array('txe_id_tpl' => $tpl[$i] , 'txe_id_emp' => $emp_id));
	}




	$this->db->where('txm_id_emp',$emp_id)
	->delete('txm_telefonoxempleado');

	$array= $this->input->post('telefono');
	$ver = array_pop($array);
	$array_tit=$this->input->post('tipo_telefono');
	$ver_tit=array_pop($array_tit);
	$i=0;
	foreach ($array as $key => $value) {
	  if(trim($value)!="") { 
		$this->db->insert('tel_telefono',array(
			'tel_numero' => $value,
			'tel_id_tit'=> $array_tit[$i]));	
		$tel_id = $this->db->insert_id();
		$this->db->insert('txm_telefonoxempleado',array(
			'txm_id_tel'=> $tel_id,
			'txm_id_emp'=>$emp_id));
		}
		$i++;
	}

	/*
	$this->db->where('dce_id_emp',$emp_id)
	->delete('dce_documento_emp');

	$array2=$this->input->post('numero_documento');
	$ver2= array_pop($array2);
	$array2_1 = $this->input->post('documento');
	$ver2_1 = array_pop($array2_1);

	$i=0;
	foreach ($array2 as $key => $value2) {
		$this->db->insert('dce_documento_emp', array(
			'dce_id_tde' => 1,
			'dce_id_emp' => $emp_id,
			'dce_valor' => $value2,
			'dce_fecha_registro' => date('Y-m-d') ,
			'dce_fecha_vence' => date('Y-m-d') ,
			'dce_usu_mod' => $this->tank_auth->get_user_id(),
			'dce_fecha_mod' => date('Y-m-d')));
		$dce_id= $this->db->insert_id();
		$this->db->where('dce_id',$dce_id);
		$this->db->update('dce_documento_emp',array('dce_id_tde' => $array2_1[$i]));
		$i++;
	}

	*/
	$this->db->where('fam_id_emp',$emp_id)
	->delete('fam_familiar');

	$array3=$this->input->post('familiar_nombre');
	$array3_1 = $this->input->post('familiar_apellido');
	$array3_2 = $this->input->post('familiar_tipo');
	$array3_3 = $this->input->post('familiar_telefono');

	$i=0;
	foreach ($array3 as $key => $value3) {
		if($value3 != ""){
		$this->db->insert('fam_familiar', array(
			'fam_nombre' => $value3,
			'fam_apellido' => $array3_1[$i],
			'fam_estado' => 1,
			'fam_id_pat' =>$array3_2[$i],
			'fam_id_emp' =>$emp_id,
			'fam_telefono' => $array3_3[$i],
			'fam_usu_mod' =>$this->tank_auth->get_user_id(),
			'fam_fecha_mod' => date('Y-m-d H:i:s')));
		}
		$i++;
	}



	$rutas = $this->input->post("ruta");
		$carpeta = $this->input->post("nombreCarpeta");
		if (count($rutas) > 0) {
			$carpeta = $carpeta;
			for ($i = 0; $i < count($rutas); $i++) {
				if ($rutas[$i] != "") {
					$img = $rutas[$i];
					$titulo = $this->input->post("titulo_doc" . $i);
					$this->datos_imagen_gral($img,$emp_id,$carpeta,$titulo);
				}
			}
		}

		$id_foto=$this->input->post('id_foto');
		$foto_editar=$this->input->post('edit_foto');

		if(trim($foto_editar) !="")
		{
			$img = $foto_editar;
			$titulo = $this->input->post("titulo_edit");
			$eliminar=$this->input->post('foto_eliminar');
			if(!empty($eliminar)){
			$this->datos_reemplazar_imagen($img,$id_foto,$carpeta,$titulo,$eliminar);
		}
		else{
			$this->datos_imagen_gral($foto_editar,$emp_id,$carpeta,$titulo,1);
		}
		}
		$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"El registro fue actualizado correctamente",'texto_alerta'=>"Actualización de datos del empleado completo");
		$this->session->set_flashdata($alerta);
	redirect('personal/empleado/index_agregar_empleado?resultado=1');
	}
	}

	function datos_reemplazar_imagen($img,$id_foto,$carpeta,$titulo,$eliminar)
	{
		unlink($eliminar);
		$extencion =end(explode(".",$img));
		$datos_1 = $this->session->keep_flashdata('datos_1');
		$nombre= trim($img);
		$ruta= "public/temp/".$carpeta."/".$nombre;
		$destino= "uploads/anexos_empleados/".$titulo.".".trim($extencion)."";
		$array=array('anx_nombre'=>$titulo,
					 'anx_url'=>$destino,
					 'anx_usu_mod'=>$this->tank_auth->get_user_id(),
					 'anx_fecha_mod'=>date('Y-m-d H:i:s'));
		$this->db->where('anx_id',$id_foto)
				 ->update('anx_anexo',$array);
		$carpeta_destino="uploads/anexos_empleados/".$titulo.".".trim($extencion)."";

	    copy($ruta,$carpeta_destino);
		unlink($ruta);

	}

	  public function check_documento($tipo=1)
	  {
				if($tipo==1) { 
				if( $this->input->post('doc') != null && $this->input->post('doc') != "") {
					$result = $this->gsatelite->get_tabla('dce_documento_emp',
						array('dce_valor'=>$this->input->post('doc')
							,'dce_id_tde' => $this->input->post('Tdoc') ));

					if(count($result)>0) {
						print json_encode(
							array('exists'  => true )
							);
					}
					else {
						print json_encode(
							array('exists'  => false)	
							);
					}
				}

			}
			elseif ($tipo==2) {
			 		if( $this->input->post('cod') != null and $this->input->post('cod') != ""   ) {
					$result = $this->gsatelite->get_tabla('emp_empleado',
						array('emp_codigo'=>$this->input->post('cod')));

					if(count($result)>0) {
						print json_encode(
							array('exists'  => true )
							);
					}
					else {
						print json_encode(
							array('exists'  => false)	
							);
					}
				}
			}
			elseif ($tipo==3) {
			 		if( $this->input->post('exp') != null and $this->input->post('exp') != ""   ) {
					$result = $this->gsatelite->get_tabla('emp_empleado',
						array('emp_expediente'=>$this->input->post('exp')));

					if(count($result)>0) {
						print json_encode(
							array('exists'  => true )
							);
					}
					else {
						print json_encode(
							array('exists'  => false)	
							);
					}
				}
			 }  


		}

	 /**
	   * @author René Castaneda
	   * @return Mantenimiento documentos por empleado
	   */
	 function documentos_empleado_crud($id_empleado=null) 
	    {
	        if (!$this->tank_auth->is_logged_in()) {
	            redirect('/auth/login/');
	        } else {
	            try
	            {
	            
	                $crud = new grocery_CRUD();
	                $this->load->config('grocery_crud');
	                $this->config->set_item('grocery_crud_file_upload_allow_file_types','pdf|jpeg|jpg|png');
	                    
	                $crud->set_table('dce_documento_emp')
	                     ->set_subject('Documento')
	                     ->where('dce_documento_emp.dce_id_emp',$id_empleado)
	                     ->columns('dce_id_tde','dce_valor','dce_fecha_vence','dce_url')
	                     ->set_relation('dce_id_tde', 'tde_tipo_documento', 'tde_nombre')
	                     ->add_fields('dce_id_tde','dce_id_emp','dce_valor','dce_fecha_vence','dce_fecha_registro','dce_url','dce_nombre_anexo','dce_usu_mod','dce_fecha_mod')
	                     ->edit_fields('dce_id_tde','dce_id_emp','dce_valor','dce_fecha_vence','dce_url','dce_nombre_anexo','dce_usu_mod','dce_fecha_mod')
	                     ->display_as('dce_id_tde', 'Documento')
	                     ->display_as('dce_valor', 'Valor')
	                     ->display_as('dce_fecha_vence', 'Vence')
	                     ->display_as('dce_url', 'Anexo')
	                     ->display_as('dce_nombre_anexo', 'Titulo Anexo')
	                     ->required_fields('dce_id_tde','dce_valor')
	                     ->set_rules('dce_valor','Valor','trim|required|campo_unico[dce_documento_emp.dce_valor]')
	                     ->field_type('dce_id_emp', 'hidden', $id_empleado)
	                     ->field_type('dce_usu_mod', 'hidden', $this->tank_auth->get_user_id())
	                     ->field_type('dce_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
	                     ->field_type('dce_fecha_registro', 'hidden', date('Y-m-d'))
	                     //->field_type('dce_fecha_vence', 'date', null)
	                     ->set_field_upload('dce_url','uploads/anexos_empleados')
	                  // ->set_upload_file_types('jpg','jpeg','png','pdf') //pdf|jpg|png|jpeg'
	                     //->unset_delete()
	                     ->unset_print()
	                     ->unset_export()
	                     ;
	                     $data['array_documento'] = $this->gsatelite->get_tabla("tde_tipo_documento");
	                     $data['id_empleado'] = $id_empleado;
	              		 $output = $crud->render();
	                     $output = array_merge($data,(array)$output); 
	                
	               		$this->load->view('personal/empleado/documentos_empleado_crud',$output);
	            }
	            catch(Exception $e)
	            {
	                show_error($e->getMessage().' --- '.$e->getTraceAsString());
	            }
	            
	        }
	    }

			
	/**
	* @author René Castaneda
	*/
   	function mantenimiento_edit_ingresos($id_emp = null, $id_est = 1, $estado_emp = 1, $read_only = false) {
   		satelite_validar();
   		$arreglo_tipo_planilla_empleado=array();
   	  			$this->db->join('tpl_tipo_planilla','tpl_id=txe_id_tpl');
   	  	$pregunta=$this->gsatelite->get_tabla('txe_tipo_planillaxempleado',array('txe_id_emp'=>$id_emp));
   	  	foreach ($pregunta as $fila) { $arreglo_tipo_planilla_empleado[$fila['txe_id_tpl']]= $fila['tpl_nombre'];	}
   	  	//preguntar si el id del ingreso a editar no pertenece a una incapacidad
   	  	$data['aplica_incapacidad'] = false;
   	  	$url_registro = explode('/',uri_string());
   	  	$result = array();
		if(end($url_registro)>0 and prev($url_registro)=='edit') {
			$id_ing = end($url_registro);
			$es_incapacidad = $this->gsatelite->get_tabla('inc_incapacidad',array('inc_id_inn'=>$id_ing));
			$data['aplica_incapacidad'] = (count($es_incapacidad)>0) ? true : false;
			$query = $this->db->select('pla_id, inn_id, ddi_id_inn, pla_estado')
				->from('pla_planilla')
				->join('ddi_detalle_ingreso','pla_id=ddi_id_pla')
				->join('inn_ingreso','inn_id= ddi_id_inn')
				->where('ddi_id_inn',$id_ing)
				->where('pla_estado', 3)
				->get()
			;
			$result = $query->row();
		}
		if(count($result)>0){
			$edit=array('inn_id_tpl','inn_id_tig','inn_motivo','inn_observacion','inn_valor','inn_estado','inn_usu_mod','inn_fecha_mod');
		}else{
			$edit=array('inn_id_tpl','inn_id_tig', 'inn_motivo','inn_observacion','inn_valor','inn_estado','inn_usu_mod','inn_fecha_mod');
		}
		$crud = new grocery_CRUD();
		$crud->set_table('inn_ingreso')
			->set_subject('Listado de Ingresos')
			->columns('inn_id_tpl','inn_id_tig','inn_motivo','inn_observacion','inn_fecha_desde','inn_valor','inn_estado','auditoria')
			->set_relation('inn_id_tig', 'tig_tipo_ingreso', 'tig_nombre',null)
			->edit_fields($edit)
			->display_as('inn_motivo', 'Concepto')
			->display_as('inn_observacion', 'Observación')
			->display_as('inn_valor', 'Monto')
			->display_as('inn_permanente', 'Permanente')
			->display_as('inn_estado', 'Estado')
			->display_as('inn_id_tpl', 'Tipo Planilla')
			->display_as('inn_id_tig', 'Tipo de ingreso')
			->display_as('inn_fecha_desde', 'Fecha Inicio')
			->display_as('auditoria', 'Crea/Modifica')
			->required_fields('inn_id_tpl','inn_id_tig','inn_motivo','inn_valor','inn_permanente','inn_estado','inn_usu_mod','inn_fecha_mod')
			->set_rules('inn_valor','Monto','required|is_numeric')
			->field_type('inn_usu_mod', 'hidden', $this->tank_auth->get_user_id())
			->field_type('inn_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
			->field_type('inn_estado', 'dropdown', array(1=>'Activo',0=>'Inactivo'))
			->field_type('inn_id_tpl', 'dropdown', $arreglo_tipo_planilla_empleado)
			->field_type('inn_permanente', 'dropdown', array(1=>'Sí',0=>'No'))
			->where('inn_id_emp',$id_emp)
			->where('inn_estado', $id_est)
			->unset_add()
			->unset_delete()
			->unset_export()
			->unset_print()
			->callback_column('inn_fecha_desde',function($value, $row){
				return date("d-m-Y",strtotime($value));
			})
			->callback_column('auditoria',function($value, $row){
				$ids = array();
				$ids[] = ($row->inn_usu_crea) ? $row->inn_usu_crea:0;
				$ids[] = ($row->inn_usu_mod)? $row->inn_usu_mod:0;
				$CI = & get_instance();
				$auditoria = $CI->personal_model->auditoria_ingreso_descuento($ids);
				return $auditoria;     
			})
		;
		if ($estado_emp==1) {
			if ($read_only == null) {
				$crud->add_action('Editar', '', "personal/empleado/editar_ingreso/$id_emp/$id_est",'icomoon-icon-pencil-2 openintab');
				$crud->add_action('Eliminar', '', 'personal/empleado/eliminar_ingreso_crud',' icomoon-icon-remove ');
			}else{
				$crud->unset_operations();
			}
		} else {
			$crud->unset_operations();
		}
		$output = $crud->render();
		$data['id_empleado'] = $id_emp;
		$this->gsatelite->cargar_vista_masterpage('personal/empleado/mantenimiento_edit_ingresos',$data,$output);
	}

	/**
	* @author René Castaneda
	*/
   	function mantenimiento_edit_descuentos($id_emp = null, $id_est = 1, $estado_emp = 1,$read_only = null) {
   		satelite_validar();
   		$url = explode('/', uri_string());
   		$id_edit = end($url);
   		$edit = prev($url);
   		$pregunta = $resp =array();
   		$id_tipo_descuento = 0;
   		$id_descuento_prestamo_banco = $this->gsatelite->get_parametro('ID_TIPO_DESCUENTO_PRESTAMO_BANCO');
   		if(is_numeric($id_edit) and $edit=='edit') {
   			$pregunta = $this->gsatelite->get_tabla('dss_descuento',array('dss_id'=>$id_edit));
   			$id_tipo_descuento=$pregunta[0]['dss_id_tdc'];

   			$query=$this->db->select('pla_id, dss_id, ddd_id_dss, pla_estado')
	   			->from('pla_planilla')
	   			->join('ddd_detalle_descuento','pla_id=ddd_id_pla')
	   			->join('dss_descuento','dss_id= ddd_id_dss')
	   			->where('ddd_id_dss',$id_edit)
	   			->where('pla_estado', 3)
	   			->get();

			$resp = $query->row();
		}

		if(count($resp)>0){
			$editar=array('dss_id_tpl','dss_id_tdc','dss_motivo','dss_valor','dss_observacion','dss_id_ban','dss_estado','dss_usu_mod','dss_fecha_mod');
		}else{
			$editar=array('dss_id_tpl','dss_id_tdc','dss_motivo','dss_valor','dss_observacion','dss_id_ban','dss_estado','dss_usu_mod','dss_fecha_mod');
		}

   	  $data['aplica_ban']=false;
   	  
   	  $arreglo_tipo_planilla_empleado=array();
   	  			$this->db->join('tpl_tipo_planilla','tpl_id=txe_id_tpl');
   	  $pregunta=$this->gsatelite->get_tabla('txe_tipo_planillaxempleado',array('txe_id_emp'=>$id_emp));
   	  foreach ($pregunta as $fila) { $arreglo_tipo_planilla_empleado[$fila['txe_id_tpl']]= $fila['tpl_nombre'];	}

   	   // $id_est = $this->input->get('id_estado');
   	   // 	print_r($estado);

   	   // if($id_est != ''){
   	   // 	$estado= $this->input->get('id_estado');
   	   // }

   	  $crud = new grocery_CRUD();
   	  $crud->set_table('dss_descuento')
   	       ->set_subject('Listado de Descuentos')
   	       ->where('dss_id_emp',$id_emp)
   	       //->where('dss_estado <>','-1')
   	       ->where('dss_estado', $id_est)
   	       ->columns('dss_id_tpl','dss_id_tdc','dss_motivo','dss_observacion','dss_fecha_desde','dss_valor','dss_estado','auditoria')
   	       ->set_relation('dss_id_tdc', 'tdc_tipo_descuento', 'tdc_nombre',null)
   	       ->set_relation('dss_id_ban', 'ban_banco', 'ban_nombre',array('ban_estado'=>1));
   	    	$crud->edit_fields($editar);
   	     
   	       	$data['aplica_ban']=($id_tipo_descuento==$id_descuento_prestamo_banco)? true:false;
		    
   	       $crud->display_as('dss_motivo', 'Concepto')
   	       ->display_as('dss_observacion', 'Observación')
   	       ->display_as('dss_valor', 'Monto')
   	       ->display_as('dss_permanente', 'Permanente')
   	       ->display_as('dss_id_ban', 'Banco')
   	       ->display_as('dss_estado', 'Estado')
   	       ->display_as('dss_id_tpl', 'Tipo Planilla')
   	       ->display_as('dss_id_tdc', 'Tipo de descuento')
   	       ->display_as('dss_fecha_desde', 'Fecha Inicio')
   	       ->display_as('auditoria', 'Crea/Modifica')
   	       ->required_fields('dss_id_tpl','dss_id_tdc','dss_valor','dss_permanente','dss_estado','dss_usu_mod','dss_fecha_mod')
   	        ->set_rules('dss_valor','Monto','required|is_numeric')
   	       ->field_type('dss_usu_mod', 'hidden', $this->tank_auth->get_user_id())
   	       ->field_type('dss_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
   	       ->field_type('dss_estado', 'dropdown', array(1=>'Activo',0=>'Inactivo'))
   	       ->field_type('dss_id_tpl', 'dropdown', $arreglo_tipo_planilla_empleado)
   	       ->field_type('dss_permanente', 'dropdown', array(1=>'Sí',0=>'No'))
           ->unset_add()->unset_edit()
   	       ->unset_delete()
   	       ->unset_export()
   	       ->unset_print()
   	       ->callback_column('dss_fecha_desde',function($value, $row){
    			return date("d-m-Y",strtotime($value));	        
            })
   	       ->callback_column('auditoria',function($value, $row){
   	       		 $ids = array();
   	       		 $ids[] = ($row->dss_usu_crea)? $row->dss_usu_crea:0;
   	       		 $ids[] = ($row->dss_usu_mod)? $row->dss_usu_mod:0;
   	       		 $CI = & get_instance();
    			 $auditoria = $CI->personal_model->auditoria_ingreso_descuento($ids);
    			 return $auditoria;     
            })
   	       ;

   	       if ($estado_emp==1) {
   	  			if ($read_only == null) {
   	  				//$crud->add_action('Editar', '', "personal/empleado/editar_descuento_anex/$id_emp/$id_est",'icomoon-icon-pencil-2 ver_en_modal');
   	  				$crud->add_action('Editar', '', "personal/empleado/editar_descuento_anex/$id_emp/$id_est",'icomoon-icon-pencil-2', null, '', "![dss_id_dss_padre] > 0");
   	            	$crud->add_action('Eliminar', '', 'personal/empleado/eliminar_ingreso_crud',' icomoon-icon-remove');
   	  			}else{
   	  				$crud->unset_operations();
   	  			}
   	  		} else {
   	  			$crud->unset_operations();
   	  		}

   	        $output = $crud->render();
   	        $data['id_empleado'] = $id_emp;
   	        $this->gsatelite->cargar_vista_masterpage('personal/empleado/mantenimiento_edit_descuentos',$data,$output);

   	 		//$this->load->view('personal/empleado/documentos_empleado_crud',$output);
   }


	/**
	*@author René Castaneda
	*/
  	function get_periodos_planilla() {
  		$id_tip_pla=$this->input->post('id_pla');
  		if($id_tip_pla>0){
  					  $this->db->order_by('pla_fecha_inicio', 'DESC');
  			$select = $this->gsatelite->get_dropdown('pla_planilla', '{pla_fecha_inicio} - {pla_fecha_fin}','', array('pla_id_tpl'=>$id_tip_pla,'pla_estado <>'=>3), null, '', 'pla_id', true);
  			$opciones = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);
  			echo json_encode(array('opciones'=>$opciones));
  		} else {
  			echo json_encode(array('opciones'=>'<option value=""></option>'));
  		}
  	}

	function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}
	}
	?>