<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Catalogos extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		//$this->load->model('utm_model');
	  //$this->load->model('consultas');
		//$this->load->model('gsatelite');
		$this->load->library('grocery_CRUD');
		$this->load->library('Procesos');
    $this->load->model('consultas');
    $this->load->model('personal_model');
    $this->load->library('tank_auth');
		//$this->driver =  $this->planilla_model;
 }
 public function index()
 {
  if (!$this->tank_auth->is_logged_in())
  {
    redirect('/auth/login/');
  } else
  {
    $this->_cargarvista();
  }
}


function parentesco()
{
   if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  } else { 
    $crud =  new grocery_CRUD();
    $crud->set_subject('Parentescos')->set_table('pat_parentesco');
    $crud->columns('pat_nombre', 'pat_estado');
    $crud->display_as('pat_nombre', 'Nombre')
    ->display_as('pat_estado', 'Estado');
    $crud->fields('pat_nombre', 'pat_estado','pat_usu_mod','pat_fecha_mod');
    $crud->required_fields('pat_nombre','pat_estado');
    $crud->field_type('pat_fecha_mod','hidden',date('Y-m-d H:i:s'));
    $crud->field_type('pat_usu_mod','hidden',$this->tank_auth->get_user_id());
    $crud->field_type('pat_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
    $crud->set_rules('pat_nombre','Nombre','trim|required|campo_unico[pat_parentesco.pat_nombre]');
    $output = $crud->render();
    $data['titulo_personal']="Parentescos";
    $this->_cargarvista($data, $output);
  }
}

function tipo_carga_archivo()
{
   if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  } else { 
    $crud =  new grocery_CRUD();
    $crud->set_subject('Archivo de configuración')->set_table('tac_tipo_carga');
    $crud->columns('tac_nombre','tac_estado');
    $crud->display_as('tac_nombre', 'Nombre');
    $crud->display_as('tac_estado', 'Estado');
    $crud->fields('tac_nombre','tac_estado','tac_fecha_mod','tac_usu_mod');
    $crud->required_fields('tac_nombre','tac_estado');
    $crud->field_type('tac_fecha_mod','hidden',date('Y-m-d H:i:s'));
    $crud->field_type('tac_usu_mod','hidden',$this->tank_auth->get_user_id());
    $crud->field_type('tac_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
    $crud->set_rules('tac_nombre','Nombre','trim|required|campo_unico[tac_tipo_carga.tac_nombre]');
    $output = $crud->render();
    $data['titulo_personal']="Archivo de configuración";
    $this->_cargarvista($data, $output);
  }
}

function profesion()
  {
    if (!$this->tank_auth->is_logged_in()) {
      redirect('/auth/login/');
    } else {
      $crud = new grocery_CRUD();
      $crud->set_subject('Profesión');
      $crud->set_table('pro_profesion');
      $crud->display_as('pro_nombre','Nombre')
         ->display_as('pro_estado','Estado')
         ->add_fields('pro_nombre','pro_estado', 'pro_usu_mod', 'pro_fecha_mod')
         ->edit_fields('pro_nombre','pro_estado', 'pro_usu_mod', 'pro_fecha_mod')
         ->columns('pro_nombre','pro_estado')
         ->required_fields('pro_nombre','pro_estado')
         ->set_rules('pro_nombre','Nombre','campo_unico[pro_profesion.pro_nombre]|required')
         ->field_type('pro_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                 ->field_type('pro_usu_mod', 'hidden', $this->tank_auth->get_user_id());

        if(end(explode('/',uri_string()))=='add') {
                $crud->field_type('pro_estado','hidden',1);
                }
                else {
                $crud->field_type('pro_estado','dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
                }
      $output=$crud->render();
      $data['titulo_personal']="Profesiones";
      $this->_cargarvista($data,$output);

    }
  }

function area_empresa()
{
  if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  } else { 
    $crud =  new grocery_CRUD();
    $crud->set_subject('Área')->set_table('are_area');
    $crud->columns('are_nombre');
    $crud->display_as('are_nombre', 'Nombre');
    $crud->fields('are_nombre');
    $crud->required_fields('are_nombre');
    $crud->set_rules('are_nombre','Nombre','trim|required|campo_unico[are_area.are_nombre]');
    $output = $crud->render();
    $data['titulo_personal']="Áreas";
    $this->_cargarvista($data, $output);
  }
}

function tipo_documento()
  {
    if (!$this->tank_auth->is_logged_in()) {
      redirect('/auth/login/');
    } else {
      $crud = new grocery_CRUD();
      $crud->set_subject('Tipo documento');
      $crud->set_table('tde_tipo_documento');
      $crud->display_as('tde_nombre','Nombre')
         ->display_as('tde_estado','Estado')
         ->fields('tde_nombre','tde_estado','tde_usu_mod','tde_fecha_mod')
         ->columns('tde_nombre','tde_estado')
         ->required_fields('tde_nombre','tde_estado')
         ->set_rules('tde_nombre','Nombre','campo_unico[tde_tipo_documento.tde_nombre]|required')
         ->field_type('tde_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                 ->field_type('tde_usu_mod', 'hidden', $this->tank_auth->get_user_id());
                 if(end(explode('/',uri_string()))== 'add'){
                  $crud->field_type('tde_estado','hidden',1);
                 }else{
                  $crud->field_type('tde_estado','dropdown',array('1'=>'Activado', '0'=>'Desactivado'));
                 }
      $output=$crud->render();
      $data['titulo_personal']="Tipos de documentos";
      $this->_cargarvista($data,$output);

    }
  }


function puesto()
{
  if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  } else {      
    $crud =  new grocery_CRUD();
    $crud->set_subject('Puesto')->set_table('pto_puesto');
    $crud->columns('pto_nombre', 'pto_estado');
    $crud->display_as('pto_nombre', 'Nombre')
    ->display_as('pto_estado', 'Estado')
    ->display_as('pto_id_tpt', 'Tipo de puesto');
    $crud->fields('pto_nombre','pto_id_tpt', 'pto_estado');
    $crud->required_fields('pto_nombre','pto_estado');
    $crud->field_type('pto_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
    $crud->set_rules('pto_nombre','Nombre','trim|required|campo_unico[pto_puesto.pto_nombre]');
    $crud->set_relation('pto_id_tpt','tpt_tipo_puesto','tpt_nombre');
    $output = $crud->render();
    $this->_cargarvista(null, $output);
  }
}
function sucursal()
{
  if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  } else {      
    $crud =  new grocery_CRUD();
    $crud->set_subject('Sucursal')->set_table('suc_sucursal');
    $crud->columns('suc_codigo', 'suc_nombre', 'suc_id_mun');
    $crud->display_as('suc_codigo', 'Código')
    ->display_as('suc_nombre', 'Nombre')
    ->display_as('suc_id_mun', 'Municipio')
    ->display_as('suc_direccion', 'Dirección');
    $crud->fields('suc_codigo','suc_nombre', 'suc_id_mun','suc_usu_mod','suc_fecha_mod','suc_direccion');
    $crud->required_fields('suc_nombre','suc_codigo');
    $crud->set_relation('suc_id_mun','mun_municipio','mun_nombre',array('mun_id_dep' => 9));
    $crud->set_rules('suc_nombre','Nombre','trim|required|campo_unico[suc_sucursal.suc_nombre]');
    $crud->set_rules('suc_codigo','Código','trim|required|campo_unico[suc_sucursal.suc_codigo]');
    $crud->field_type('suc_usu_mod','hidden',$this->tank_auth->get_user_id());
    $crud->field_type('suc_fecha_mod','hidden',date('Y-m-d'));
    $output = $crud->render();
    $this->_cargarvista(null, $output);
  }
}

    function tipos_descuento(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        }
        $permisos = $this->gsatelite->get_permisos_opcion();
        $id_descuento_isss=$this->gsatelite->get_parametro('DESCUENTO_ISS');
        $id_descuento_renta=$this->gsatelite->get_parametro('DESCUENTO_ISR');
        $id_descuento_afp=$this->gsatelite->get_parametro('DESCUENTO_AFP');
        $id_descuento_renta10=$this->gsatelite->get_parametro('DESCUENTO_ISR10');

        $campos = array(
            'tdc_nombre'    => 'Nombre',
            'tdc_cuota'     => 'Cuota',
            'tdc_id'     => 'ID',
            'tdc_porcentaje' => 'Porcentaje',
            'tdc_porcentaje_patronal' => 'Aporte Patronal',
            'tdc_desde'     => 'Desde',
            'tdc_hasta'     => 'Hasta',
            'tdc_minimo'    => 'Mínimo',
            'tdc_maximo'    => 'Máximo',
            'tdc_codigo'    => 'Código'
        );

        $columns=array(
            'tdc_codigo',
            'tdc_nombre', 
            'tdc_porcentaje'
        );
        $required_fields=array(
            'tdc_nombre'
        );
        $id_editar = end(explode('/', uri_string()));
        $data['id_editar'] = "$id_editar";
        $crud = new grocery_CRUD();
        $crud->set_table('tdc_tipo_descuento')
            ->set_subject('Descuento')
            ->columns($columns)
            //->fields('tdc_nombre', 'tdc_cuota', 'tdc_porcentaje', 'tdc_desde', 'tdc_hasta', 'tdc_minimo', 'tdc_maximo', 'tdc_agrupador')
        ;
        if(is_numeric($id_editar)) {
            if($id_descuento_isss==$id_editar) {
                $crud->required_fields('tdc_nombre','tdc_porcentaje','tdc_porcentaje_patronal','tdc_maximo')
                    ->fields('tdc_nombre','tdc_porcentaje','tdc_porcentaje_patronal','tdc_maximo')
                ;
            } elseif ($id_descuento_renta10 == $id_editar) {
                $crud->required_fields('tdc_nombre','tdc_porcentaje')
                    ->fields('tdc_nombre','tdc_porcentaje')
                ;
            } else {
                $crud->required_fields($required_fields)
                    ->fields('tdc_nombre')
                ;
            }
        } else {
            $crud->required_fields($required_fields)
                ->fields('tdc_nombre')
            ;  
        }
        $crud->display_as($campos)
            ->set_rules('tdc_nombre','Nombre','trim|required|campo_unico[tdc_tipo_descuento.tdc_nombre]')
            //->field_type('tdc_tipo', 'dropdown', array(1=>'Monto Definido', 2=> 'Porcentaje', 3=> 'Minimo y Maximo', 4=> 'Renta (min_max+porcentaje)'))
            ->unset_edit()
        ;
        if ($permisos['permite_editar']) {
            $crud->add_action('Editar','icon16 icomoon-icon-pencil-5','personal/catalogos/editar_tipo_descuento');
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        $crud->unset_add();//EXISTE OTRO BOTON EN LA VISTA
        $crud->set_relation('tdc_agrupador', 'tag_tipo_agrupador', '{tag_nombre}');
        $data['titulo_personal']="Tipo de descuento";
        $this->_cargarvista($data, $crud->render());
    }

function tipos_ingreso(){
  if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  }
  $id_ingreso_sueldo=$this->gsatelite->get_parametro('INGRESO_SALARIO');
  $data['id_ingreso_sueldo']=$id_ingreso_sueldo;
  $data['id_editar'] = end(explode('/', uri_string()));
  $permisos = $this->gsatelite->get_permisos_opcion();
  $columns = array(
    'tig_codigo',
    'tig_nombre',
    'tig_id_cgi',
    'tig_estado'
  );

  $campos = array(
    'tig_id'    => 'ID',
    'tig_id_cgi'    => 'Categoría',
    'tig_codigo'    => 'Código',
    'tig_nombre'    => 'Nombre',
    'tig_cuenta_contable' => 'Cuenta Contable',
    'tig_estado'    => 'Estado',
    'tig_descripcion' => 'Descripción',
    'tig_gravado'=>'Gravado'
  );

  $add_columns=array(
    'tig_codigo',
    //'cgi_nombre',
    'tig_nombre',
    'tig_estado',
    'tig_descripcion',
    'tig_gravado'
  );

  $required_fields=array(
    'tig_codigo',
    //'cgi_nombre',
    'tig_nombre',
    'tig_estado',
    'tig_gravado'
  );

  $crud = new grocery_CRUD();
  //$this->db->join('cgi_categoria_tipo_ingreso','cgi_id = tig_id_cgi','inner');
  $crud->set_table('tig_tipo_ingreso')
  ->set_subject('Ingreso')
  ->columns($columns)
  ->display_as($campos)
  ->add_fields($add_columns)
  ->edit_fields($add_columns)
  ->required_fields($required_fields)
  ->unset_edit()
  ->unset_add()
  ->set_relation( 'tig_id_cgi','cgi_categoria_tipo_ingreso','cgi_nombre')
  ->field_type( 'tig_gravado' , 'dropdown', array(0=>'No aplica', 1=> 'Aplica'))
  ->set_rules('tig_nombre','Nombre','trim|required|campo_unico[tig_tipo_ingreso.tig_nombre]')
  ->set_rules('tig_codigo','Código','trim|required|campo_unico[tig_tipo_ingreso.tig_codigo]');
   if(end(explode('/',uri_string()))=='add') {
    $crud->field_type('tig_estado','hidden',1);
  } else {
    $crud->field_type('tig_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
  }
  if (!$permisos['permite_agregar']) {
    $crud->unset_add();
  }
  if (!$permisos['permite_agregar']) {
    $crud->unset_delete();
  }
  if (!$permisos['permite_ver']) {
    $crud->unset_read()
    ->unset_print()
    ->unset_export();
  }
  if ($permisos['permite_editar']) {
    $crud->add_action('Editar','icon16 icomoon-icon-pencil-5','personal/catalogos/editar_tipo_ingreso');
  }
  $data['titulo_personal']="Tipo de ingreso";
  $this->_cargarvista($data, $crud->render());
}

function categoria_ingreso(){
    if(!$this->tank_auth->is_logged_in()){
        redirect('/auth/login/');
    } else {
        $permisos = $this->gsatelite->get_permisos_opcion('personal/catalogos/categoria_ingreso');
        
        $crud =  new grocery_CRUD();
        $crud->set_subject('Categoría de tipo de ingreso')->set_table('cgi_categoria_tipo_ingreso');
        $crud->columns('cgi_nombre', 'cgi_descripcion', 'cgi_estado');
        $crud->display_as('cgi_nombre', 'Nombre')
        ->display_as('cgi_descripcion', 'Descripción')
        ->display_as('cgi_estado', 'Estado');
        $crud->add_fields('cgi_nombre','cgi_descripcion','cgi_estado','cgi_usu_modificacion','cgi_fecha_modificacion','cgi_usu_creacion','cgi_fecha_creacion');
        $crud->edit_fields('cgi_nombre','cgi_descripcion','cgi_estado','cgi_usu_modificacion','cgi_fecha_modificacion');
        $crud->required_fields('cgi_nombre','cgi_estado');
        $crud->set_rules('cgi_nombre','nombre','trim|required|campo_unico[cgi_categoria_tipo_ingreso.cgi_nombre]');
        $crud->set_rules('cgi_estado','estado','trim|required');
        $crud->field_type('cgi_usu_creacion','hidden',$this->tank_auth->get_user_id());
        $crud->field_type('cgi_usu_modificacion','hidden',$this->tank_auth->get_user_id());
        $crud->field_type('cgi_fecha_creacion','hidden',date('Y-m-d H:i:s'));
        $crud->field_type('cgi_fecha_modificacion','hidden',date('Y-m-d H:i:s'));
        if(end(explode('/',uri_string()))=='add') {
            $crud->field_type('cgi_estado','hidden',1);
        }else {
            $crud->field_type('cgi_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        
        if(!$permisos["permite_editar"]){
            $crud->unset_edit();
        }
        if(!$permisos["permite_eliminar"]){
            $crud->unset_delete();
        }
        if(!$permisos["permite_agregar"]){
            $crud->unset_add();
        }
        if(!$permisos["permite_ver"]){
            $crud->unset_read();
        }
        $output = $crud->render();
        $data['titulo_personal']="Categoría de tipo de ingreso";
        $this->_cargarvista($data, $output);
    }
}
  
    function afp() {
        //El mantenimiento existe tambien en /expediente_personal/catalogos/afp
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('personal/catalogos/afp');
            $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
            $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
            $crud = new grocery_CRUD();
            $crud->set_subject('AFP')->set_table('afp_afp');
            $crud->columns('afp_nombre', 'afp_porcentaje', 'afp_porcentaje_patrono', 'afp_activo');
            $crud->set_relation('afp_id_cnt', 'cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', array('cnt_estado'=>1));
            $crud->set_relation('afp_id_cnt_patrono', 'cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', array("cnt_estado" => 1, "cnt_id NOT IN ( $padres )" => null));
            $crud->display_as('afp_nombre', 'Nombre')
                    ->display_as('afp_porcentaje', 'Porcentaje descuento empleado')
                    ->display_as('afp_activo', 'Activo')
                    ->display_as('afp_id_cnt', 'Cuenta contable aporte empleado')
                    ->display_as('afp_porcentaje_patrono', 'Porcentaje descuento patrono')
                    ->display_as('afp_maximo', 'Techo salarial')
                    ->display_as('afp_id_cnt_patrono', 'Cuenta contable aporte patronal');
            $crud->fields('afp_nombre','afp_porcentaje', 'afp_porcentaje_patrono','afp_maximo','afp_id_cnt','afp_id_cnt_patrono','afp_activo');
            $crud->required_fields('afp_nombre','afp_porcentaje_patrono', 'afp_porcentaje','afp_activo', 'afp_maximo');
            $crud->set_rules('afp_nombre','Nombre','trim|required|campo_unico[afp_afp.afp_nombre]');
            $crud->unset_edit();
            $crud->unset_read();
            $crud->unset_delete();
            if(end(explode('/',uri_string()))=='add') {
                $crud->field_type('afp_activo','hidden',1);
            }else {
                $crud->field_type('afp_activo','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if($permisos["permite_editar"]){
                $crud->add_action('&nbsp;&nbsp;Editar', '', 'personal/catalogos/editar_afp','icomoon-icon-pencil-5');  
            }
            if($permisos["permite_eliminar"]){
                $crud->add_action('&nbsp;&nbsp;Inactivar', '', 'personal/catalogos/eliminar_afp','icomoon-icon-remove');
            }
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }
            if($permisos["permite_ver"]){
                //$crud->add_action('&nbsp;&nbsp;Ver', '', 'personal/catalogos/afp/read','icomoon-icon-search-3');
            }
            $output = $crud->render();
            $this->_cargarvista(null, $output);
        }
    }

function isr(){
  if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  } else {

    $permisos = $this->gsatelite->get_permisos_opcion();
    $crud =  new grocery_CRUD();
    $crud->set_subject('ISR')->set_table('isr_isr');
    $crud->columns('isr_desc', 'isr_desde','isr_hasta', 'isr_porcentaje','isr_exceso','isr_cuota','isr_id_tis');
    $crud->display_as('isr_id_tis','Tipo tabla');
    $crud->display_as('isr_desc','ISR');
    $crud->display_as('isr_desde','Desde');
    $crud->display_as('isr_hasta','Hasta');
    $crud->display_as('isr_porcentaje','Porcentaje');
    $crud->display_as('isr_exceso','Exceso');
    $crud->display_as('isr_cuota','Cuota');
    $crud->required_fields('isr_desc', 'isr_desde','isr_hasta', 'isr_porcentaje','isr_exceso','isr_cuota'); 
    $crud->fields('isr_id_tis', 'isr_desc', 'isr_desde','isr_hasta', 'isr_porcentaje','isr_exceso','isr_cuota');
    $crud->order_by('isr_id_tis');
    //$crud->unset_delete();
    $crud->unset_export();
    $crud->unset_print();
    if(($cub_id = $this->input->get('cub_id')) > 0){
      $crud->where(array('isr_id_tis' => $cub_id));
    }
    if (!$permisos['permite_agregar']) {
      $crud->unset_add();
    }
    if (!$permisos['permite_editar']) {
      $crud->unset_edit();
    }
    if (!$permisos['permite_ver']) {
      $crud->unset_read();
    }
    if (!$permisos['permite_eliminar']) {
      $crud->unset_delete();
    }

    $crud->set_primary_key('isr_id','isr_isr')
    ->set_relation('isr_id_tis','tis_tipo_isr','cuenta');
    $crud->set_relation('isr_id_tis','tis_tipo_isr','tis_desc');

    $output = $crud->render();
    $cuentas[0] = 'Seleccione';
    foreach($this->db->get('tis_tipo_isr')->result() as $row){
      $cuentas[$row->tis_id] = $row->tis_desc;
    }
    $data = array (
      'cuentas' => $cuentas
      );

    $this->_cargarvista($data, $output);
  }
}
function tipo_isr(){
  if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  } else {

    $crud = new grocery_CRUD;
    $crud =  new grocery_CRUD();
    $crud->set_subject('tipo ISR')->set_table('tis_tipo_isr');
    $crud->columns('tis_desc', 'tis_vigente');
    $crud->display_as('tis_desc', 'Tipo de ISR');
    $crud->display_as('tis_vigente', 'Estado');
    $crud->fields('tis_desc', 'tis_vigente');
    $crud->required_fields('tis_desc', 'tis_vigente');
    $crud->unset_delete();
    $crud->unset_export();
    $crud->unset_print();
    $output = $crud->render();
    $data="";
    $this->_cargarvista($data, $output);
  }
}
function ing_des_pla($id)
{
  if (!$this->tank_auth->is_logged_in())
  {
    redirect('/auth/login/');
  } else
  {
    $data['titulo_personal']="Ingresos y Descuentos de Planilla";
    $data['tpl']=$this->personal_model->get_tabla('tpl_tipo_planilla',array('tpl_id'=>$id));            
    $data['desxpla']=$this->personal_model->get_ing_des('dtp_descuentoxtipo_planilla',array('dtp_id_tpl'=>$id),1);
    //$data['descuentos']=$this->personal_model->get_det_ing_des('tdc_tipo_descuento',$data['desxpla'],'dtp_id_tdc','tdc_id','tdc_agrupador');
    //echo $this->db->last_query(); die();
    $data['ingxpla']=$this->personal_model->get_ing_des('itp_ingresoxtipo_planilla',array('itp_id_tpl'=>$id),2);
   //echo $this->db->last_query(); die();
    //$data['ingresos']=$this->personal_model->get_det_ing_des('tig_tipo_ingreso',$data['ingxpla'],'itp_id_tig','tig_id',null);
                        
    $data['descuentos']=$this->personal_model->tipo_descuento(true,$id);
    $data['ingresos']=$this->personal_model->tipo_ingreso(true,$id);
    if($_POST)
      {  /*print_r($_POST);
        exit(); */
        if($_POST['boton']=='ingreso')
        {
          $ingreso=array(
            'itp_id_tpl'=>(int)$id,
            'itp_porcentaje'=>($_POST['porcentaje_ingreso']>0)? $_POST['porcentaje_ingreso']:100,
            'itp_id_tig'=>(int)$_POST['ingreso'],
            'itp_estado'=>1,
            'itp_usu_creacion'=>$this->tank_auth->get_user_id(),
            'itp_fecha_creacion'=>date("Y-m-d H:i:s"),
            'itp_usu_modificacion'=>$this->tank_auth->get_user_id(),
            'itp_fecha_modificacion'=>date("Y-m-d H:i:s")
            );
          $registro=$this->personal_model->add_regitro('itp_ingresoxtipo_planilla',$ingreso);
          if($registro>0)
            $alerta=array('registro'=>$registro,'tipo_alerta'=> 'success','titulo_alerta'=>"Registro ingresado",'texto_alerta'=>"El registro se ha ingresado correctamente");                
          else
            $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Registro no ingresado",'texto_alerta'=>"El registro no se pudo ingresar verifique la informacion ingresada");
          $this->session->set_flashdata($alerta);       
          redirect('personal/catalogos/ing_des_pla/'.$id);   
        }
        if($_POST['boton']=='descuento')
        {
          $id_descuento_renta=$this->gsatelite->get_parametro('DESCUENTO_ISR');
          $msj_extra="";
          if($_POST['descuento']==$id_descuento_renta or $_POST['descuento']==$id_descuento_renta10){
            $msj_extra="<br /><b><strong>VERIFICAR QUE EL TIPO DE PLANILLA <br />TENGA ASOCIADA UNA TABLA DE CÁLCULO PARA LA RENTA</strong></b>";
          }
          $descuento=array(
            'dtp_id_tpl'=>(int)$id,
            'dtp_porcentaje'=>100,
            'dtp_id_tdc'=>(int)$_POST['descuento'],
            'dtp_estado'=>1,
            'dtp_usu_creacion'=>$this->tank_auth->get_user_id(),
            'dtp_fecha_creacion'=>date("Y-m-d H:i:s"),
            'dtp_usu_modificacion'=>$this->tank_auth->get_user_id(),
            'dtp_fecha_modificacion'=>date("Y-m-d H:i:s")
            );
          $registro=$this->personal_model->add_regitro('dtp_descuentoxtipo_planilla',$descuento);
          if($registro>0)
            $alerta=array('registro'=>$registro,'tipo_alerta'=> 'success','titulo_alerta'=>"Registro ingresado",'texto_alerta'=>"El registro se ha ingresado correctamente $msj_extra");                
          else
            $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Registro no ingresado",'texto_alerta'=>"El registro no se pudo ingresar verifique la informacion ingresada");
          $this->session->set_flashdata($alerta);       
          redirect('personal/catalogos/ing_des_pla/'.$id);
        }
      }
      $this->_cargarvista($data);
    }
  }

    public function eliminar($tipo,$id_tipo,$planilla){
        if($tipo=="ing"){
            $this->db->where('itp_id', $id_tipo)
                ->where('itp_id_tpl', $planilla)
                ->delete('itp_ingresoxtipo_planilla');
            $alerta=array('registro'=>$registro,'tipo_alerta'=> 'success','titulo_alerta'=>"Registro eliminado",'texto_alerta'=>"El registro se ha eliminado correctamente");
            redirect('personal/catalogos/ing_des_pla/'.$planilla);
        }else if($tipo=="des"){
            $this->db->where('dtp_id',$id_tipo)
                ->where('dtp_id_tpl',$planilla)
                ->delete('dtp_descuentoxtipo_planilla');
            $alerta=array('registro'=>$registro,'tipo_alerta'=> 'success','titulo_alerta'=>"Registro eliminado",'texto_alerta'=>"El registro se ha eliminado correctamente");
            redirect('personal/catalogos/ing_des_pla/'.$planilla);
        }else if($tipo=="isr"){
            $meses = $this->personal_model->get_pla_meses($id_tipo,$planilla);
            if (count($meses) > 0) {
                $this->db->where('pis_id_txt', $id_tipo)->delete('pis_periodo_isr');
                $this->db->where('txt_id', $id_tipo)->where('txt_id_tpl', $planilla)->delete('txt_tipo_planillaxtipo_isr');
            } else {
                $this->db->where('txt_id', $id_tipo)->where('txt_id_tpl', $planilla)->delete('txt_tipo_planillaxtipo_isr');
            }
            $alerta = array('registro' => $registro, 'tipo_alerta'=> 'success', 'titulo_alerta' => "Registro eliminado", 'texto_alerta' => "El registro se ha eliminado correctamente");
            redirect('personal/catalogos/pla_isr/'.$planilla);
        }
    }

    function pla_isr($id){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal']="Planilla por ISR";
            $data['tpl']=$this->personal_model->get_tabla('tpl_tipo_planilla',array('tpl_id'=>$id));            
            $data['isrxpla']=$this->personal_model->get_ing_des('txt_tipo_planillaxtipo_isr',array('txt_id_tpl'=>$id),3);
            $data['isr']=$this->personal_model->get_det_ing_des('tis_tipo_isr',$data['isrxpla'],'txt_id_tis','tis_id');
            if($_POST) {
                //preguntar si ya tiene asociada una tabla de cálculo de renta
                $consulta=$this->gsatelite->get_tabla('txt_tipo_planillaxtipo_isr',array('txt_id_tpl'=>$id));                
                $tis_recalculo_junio=$this->gsatelite->get_parametro('ID_RECALCULO_JUNIO');
                $tis_recalculo_diciembre=$this->gsatelite->get_parametro('ID_RECALCULO_DICIEMBRE');
                $ids=array($tis_recalculo_junio,$tis_recalculo_diciembre);

                               $this->db->where_not_in('txt_id_tis',$ids);
                               $this->db->where('txt_id_tpl',$id);
                $tipo_planilla=$this->gsatelite->get_tabla('txt_tipo_planillaxtipo_isr');
                $tis_actual=$_POST['isr'];
                if(count($consulta)>=3){
                    $alerta=array('tipo_alerta'=> 'info','titulo_alerta'=>"Registro no ingresado",'texto_alerta'=>"Ya existe tabla de renta asociada a la planilla");
                    $this->session->set_flashdata($alerta);       
                    redirect('personal/catalogos/pla_isr/'.$id);  
                }else if(count($consulta)==1 || count($consulta)<3){
                    $id_tis=$consulta[0]['txt_id_tis'];
                    /*********************** VALIDACION DE TABLAS DE RENTA ASOCIADAS A LA PLANILLA *********************/
                    if($tis_recalculo_junio!=$tis_actual && $tis_recalculo_diciembre!=$tis_actual){
                        if(count($tipo_planilla)>0){
                            $alerta=array('tipo_alerta'=> 'info','titulo_alerta'=>"Registro no ingresado",'texto_alerta'=>"Ya existe tabla de renta asociada a la planilla");
                        }
                    }
                    if($alerta!=''){
                        $this->session->set_flashdata($alerta);       
                        redirect('personal/catalogos/pla_isr/'.$id);
                    }
                }else if(count($consulta)<=0){
                    if($tis_actual==$tis_recalculo_junio || $tis_actual==$tis_recalculo_diciembre){
                        $alerta=array('tipo_alerta'=> 'info','titulo_alerta'=>"Registro no ingresado",'texto_alerta'=>"Para asignar una tabla de recálculo, debe tener asociada una tabla según el periodo de la planilla");
                        $this->session->set_flashdata($alerta);       
                        redirect('personal/catalogos/pla_isr/'.$id);
                    }
                }
                $id_tis=$consulta[0]['txt_id_tis'];
                $tis_actual=$_POST['isr'];
                if($id_tis!=$tis_recalculo_junio){
                    $tipo=$id_tis;
                }else{
                    $tipo=$tis_actual;
                }

                $ingreso=array(
                    'txt_id_tpl'=>(int)$id,
                    'txt_id_tis'=>(int)$_POST['isr']
                );
                $registro=$this->personal_model->add_regitro('txt_tipo_planillaxtipo_isr',$ingreso);
       
                if($registro>0)
                    $alerta=array('registro'=>$registro,'tipo_alerta'=> 'success','titulo_alerta'=>"Registro ingresado",'texto_alerta'=>"El registro se ha ingresado correctamente");
                else
                    $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Registro no ingresado",'texto_alerta'=>"El registro no se pudo ingresar verifique la informacion ingresada");
                $this->session->set_flashdata($alerta);       
                redirect('personal/catalogos/pla_isr/'.$id);   
            }
            $this->_cargarvista($data);
        }
    }

    /**
    * @author Boris Estrada
    */
    function agrupadores(){
        //preguntar por los ids de los agrupadores para salario,vacacion, isss,renta, renta10% y afp
        $id_agrupador_vacacion = $this->gsatelite->get_parametro('SYS_CONFIGURACION_VACACION', null,null, array('ID_AGRUPADOR_VACACION'));
        $id_agrupador_vacacion = (trim($id_agrupador_vacacion) !='')? $id_agrupador_vacacion:0;
        $id_agrupador_aguinaldo = $this->gsatelite->get_parametro('SYS_CONFIGURACION_AGUINALDO',null,null,array('ID_AGRUPADOR_AGUINALDO'));
        $id_agrupador_aguinaldo = (trim($id_agrupador_aguinaldo) !='')? $id_agrupador_aguinaldo:0;
        $id_agrupador_aguinaldo_variable = $this->gsatelite->get_parametro('SYS_CONFIGURACION_AGUINALDO',null,null,array('ID_AGRUPADOR_AGUINALDO_VARIABLE'));
        $id_agrupador_aguinaldo_variable = (trim($id_agrupador_aguinaldo_variable) !='')? $id_agrupador_aguinaldo_variable:0;
        $id_agrupador_indemnizacion = $this->gsatelite->get_parametro('SYS_CONFIGURACION_INDEMNIZACION',null,null,array('ID_AGRUPADOR_INDEMNIZACION'));
        $id_agrupador_indemnizacion = (trim($id_agrupador_indemnizacion) !='')? $id_agrupador_indemnizacion:0;
        $codigos = array("AGRUPADOR_ISR","AGRUPADOR_ISS","AGRUPADOR_SALARIO","AGRUPADOR_ISR10","ID_AGRUPADOR_AFP",'SYS_ID_AGRUPADOR_PROMEDIO_SALARIO','SYS_ID_AGRUPADOR_PLANILLA_REPORTE',"SYS_ID_AGRUPADOR_CONTRATO");
                      $this->db->where_in('par_codigo',$codigos);
        $parametros = $this->gsatelite->get_tabla('par_parametro');
        $ids_valor_par = array($id_agrupador_vacacion, $id_agrupador_aguinaldo,$id_agrupador_aguinaldo_variable, $id_agrupador_indemnizacion);
        foreach ($parametros as $valor){
            $ids_valor_par[]=$valor['par_valor'];    
        }
        $ids_permitidos = implode(',', $ids_valor_par);
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();
        $crud->set_table('tag_tipo_agrupador')
            ->set_subject('Agrupadores')
            // ->where("tag_id in ($ids_permitidos)")
            ->where("tag_estado > 0")
            ->columns('tag_nombre','ingresos', 'descuentos')
            ->fields('tag_nombre', 'ingresos', 'descuentos')
            ->set_rules('tag_nombre','Nombre','trim|required|campo_unico[tag_tipo_agrupador.tag_nombre]')
            ->display_as('tag_estado','Estado')
            // ->display_as('tag_tipo','Tipo')->field_type('tag_tipo', 'dropdown', array('C'=>'C', 'R'=>'R'))
            ->display_as('tag_nombre','Nombre')
            ->display_as('tag_descripcion','Descripción')
            ->required_fields('tag_nombre','tag_tipo', 'tag_estado')
        ;
        $ingresos = $this->consultas->ingresos();
        $descuentos = $this->consultas->descuentos();
        $crud->set_relation_n_n('ingresos','deg_detalle_agrupador','tig_tipo_ingreso','deg_id_tag','deg_id_tig','tig_nombre', null, "tig_id in ($ingresos)");
        $crud->set_relation_n_n('descuentos','deg_detalle_agrupador','tdc_tipo_descuento','deg_id_tag','deg_id_tdc','tdc_nombre', null, "tdc_id in ($descuentos)");
        $crud->callback_after_insert(function($post_array,$primary_key){
            $CI =& get_instance();
            $CI->personal_model->agrupadores(array('deg_id_tag'=>$primary_key),$primary_key,$post_array);
            return TRUE; 
        });
        $crud->callback_after_update(function($post_array,$primary_key){
            $CI =& get_instance();
            $CI->personal_model->agrupadores(array('deg_id_tag'=>$primary_key),$primary_key,$post_array);
            return TRUE; 
        });
        $crud->callback_column('ingresos', function($value, $row) { return $value; });
        $crud->callback_column('descuentos', function($value, $row) { return $value; });
        $crud->unset_delete();
        $crud->unset_edit();
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
            $crud->unset_export();
            $crud->unset_print();
        }
        if ($permisos['permite_editar']) {
            $crud->add_action('Editar','icon16 icomoon-icon-pencil-5', 'personal/catalogos/agrupadores_agregar');
        }
        if ($permisos['permite_eliminar']) {
            $crud->add_action('Eliminar', '', 'personal/catalogos/tag_eliminar', 'icomoon-icon-remove-5 borrar_tag', null, null, "[tag_tipo] == 'C'");
        }
        if(end(explode('/',uri_string()))=='add') {
            $crud->field_type('tag_estado','hidden',1);
        } else {
            $crud->field_type('tag_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        } 
        $data['titulo_personal'] = "Agrupadores";
        $this->_cargarvista($data, $crud->render());
    }

    public function tag_eliminar($tag_id = 0){
        if ($this->tank_auth->is_logged_in()){
            $datos_agrupador = $this->gsatelite->get_registro('tag_tipo_agrupador', array("tag_id" => $tag_id));
            if (is_object($datos_agrupador) && $datos_agrupador->tag_tipo == "C") {
                //eliminar llave del tipo de planilla
                $this->gsatelite->actualizar('tpl_tipo_planilla', array('tpl_id_tag' => null), 'tpl_id_tag', $datos_agrupador->tag_id);
                // elimimar detalles si existen
                $this->gsatelite->borrado_general('deg_detalle_agrupador', array('deg_id_tag' => $datos_agrupador->tag_id));
                //borrar el agrupador
                $this->gsatelite->borrado_general('tag_tipo_agrupador', array('tag_id' => $datos_agrupador->tag_id));
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tipo Agrupadores", 'texto_alerta' => "El registro se eliminó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Tipo Agrupadores", 'texto_alerta' => "No es posible eliminar el registro");
            }
            $this->session->set_flashdata($alerta);
            redirect('personal/catalogos/agrupadores');
        } else {
            redirect('/auth/login/');
        }
    }

  public function configurar()
  {
    satelite_validar();
      $permisos = $this->gsatelite->get_permisos_opcion();
      $crud =  new grocery_CRUD();
      $crud->where('par_codigo','DIAS_TRABAJADOS_MES');
      $crud->set_subject('Configurar parámetros')->set_table('par_parametro');
      $crud->columns('par_codigo','par_nombre', 'par_valor');
      $crud->display_as('par_codigo', 'Código');
      $crud->display_as('par_nombre', 'Descripción');
      $crud->display_as('par_valor', 'Valor');
      $crud->edit_fields('par_valor','par_tipo');
      $crud->field_type('par_valor','dropdown', array('28' => '28', '29' => '29', '30' =>'30', '31' => '31'));
      $crud->field_type('par_tipo','hidden');
      $crud->required_fields('par_valor');
      $crud->unset_delete();
      $crud->unset_add();
      $crud->unset_print();
      $crud->unset_export();
      if (!$permisos['permite_editar']) {
        $crud->unset_edit();
      }
      if (!$permisos['permite_ver']) {
        $crud->unset_read();
      }
      $output = $crud->render();
      $data['titulo_personal']="Configuración de parámetros";
      $this->_cargarvista($data, $output);
  }


    function pla_isr_meses($id=null,$txt_id=null, $cambio=null){
        if (!$this->tank_auth->is_logged_in()){
            redirect('/auth/login/');
        } else {
            $data['titulo_personal']="Meses para ISR por planilla";
            $data['tpl'] = $this->personal_model->get_tabla('tpl_tipo_planilla',array('tpl_id'=>$id));
            $isr = $this->personal_model->get_ing_des('txt_tipo_planillaxtipo_isr',array('txt_id'=>$txt_id),3);
            $data['isrxpla'] = $isr;
            $data['isr'] = $this->gsatelite->get_tabla('tis_tipo_isr',array('tis_id'=>$isr[0]['txt_id_tis']));
            $data['txt'] = $txt_id;
            $mes = $this->gsatelite->get_tabla('pis_periodo_isr', array('pis_id_txt'=>$txt_id));
            //die(print_r($mes));
            $meses=array();
            if(count($mes)>0){
                foreach ($mes as $key) {
                    $meses[]=$key['pis_periodo'];
                }
                $data['meses']=$meses;
            }
            if($_POST){
                $periodos=$this->gsatelite->borrado_general('pis_periodo_isr', array('pis_id_txt'=>$txt_id));
                $meses = array();
                foreach ($_POST as $key => $value) {
                    if (is_numeric($key)) {
                        $meses[$i] = $value;
                        $pis_bd = $this->gsatelite->get_tabla('pis_periodo_isr', array('pis_id_txt' => $txt_id, 'pis_periodo' => $value));
                        if(count($pis_bd) <= 0 && $value > 0){
                            $ingreso=array(
                                'pis_id_txt' => (int)$txt_id,
                                'pis_periodo' => (int)$value,
                                'pis_estado' => 1,
                                'pis_usu_creacion' => $this->tank_auth->get_user_id(),
                                'pis_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'pis_fecha_creacion' => date('Y-m-d H:i:s'),
                                'pis_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $registro = $this->personal_model->add_regitro('pis_periodo_isr',$ingreso);
                        }
                    }
                }
                if($registro > 0){
                    $alerta = array('registro'=>$registro,'tipo_alerta'=> 'success','titulo_alerta'=>"Registro ingresado",'texto_alerta'=>"El registro se ha ingresado correctamente");
                } else {
                    $alerta = array('tipo_alerta'=> 'error','titulo_alerta'=>"Registro no ingresado",'texto_alerta'=>"El registro no se pudo ingresar verifique la informacion ingresada");
                }
                $this->session->set_flashdata($alerta);
                if ($_POST['btnCrear'] > 0) {
                    redirect('personal/catalogos/pla_isr/' . $id);
                } else {
                    redirect('personal/catalogos/pla_isr_meses/'.$id.'/'.$txt_id);
                }
            }else{
                if($cambio==1){
                    $periodos=$this->gsatelite->borrado_general('pis_periodo_isr', array('pis_id_txt'=>$txt_id));
                    if($periodos>0){
                        $alerta=array('registro'=>$periodos,'tipo_alerta'=> 'success','titulo_alerta'=>"Registro actualizado",'texto_alerta'=>"Cambios realizados correctamente");
                    } else {
                        $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error",'texto_alerta'=>"Los cambios no pudieron ser aplicados");
                    }
                    $this->session->set_flashdata($alerta);
                    redirect('personal/catalogos/pla_isr_meses/'.$id.'/'.$txt_id);
                }
                $this->_cargarvista($data);
            }
        }
    }

    public function agregar_tipo_ingreso(){
        if ($_POST) {
            //pestaña general
            $tip_ingreso = (trim($this->input->post('tip_ingreso')) != "") ? $this->input->post('tip_ingreso') : null; //cgi
            $descripcion = (trim($this->input->post('descripcion')) != "") ? $this->input->post('descripcion') : null;
            $codigo = (trim($this->input->post('codigo')) != "") ? $this->input->post('codigo') : null;
            $gravado = (trim($this->input->post('gravado')) != "") ? $this->input->post('gravado') : null;
            $nombre = (trim($this->input->post('nombre')) != "") ? $this->input->post('nombre') : null;
            $ge_factor = (trim($this->input->post('ge_factor')) != "") ? $this->input->post('ge_factor') : null;

            //grid de la pestaña de finanzas
            $fin_cuenta = $this->input->post('fin_cuenta'); //array cnt
            $fin_tipo_cuenta = $this->input->post('fin_tipo_cuenta'); //array tipo de cuenta
            $fin_costo = $this->input->post('fin_costo'); //array cec
            $fin_porcentaje = $this->input->post('fin_porcentaje'); //array

            if($codigo != ''){
                $tig_registros = array(
                    'tig_id_cgi'=> $tip_ingreso,
                    'tig_codigo' => $codigo,
                    'tig_descripcion' => $descripcion,
                    'tig_nombre' => $nombre,
                    'tig_tipo_calculo' => 0,
                    'tig_cta_contable' => null,
                    'tig_factor' => $ge_factor,
                    'tig_estado' => 1
                    //'tig_id_tag' => $tag,
                    // 'tig_gravado' => $gravado
                    //'tig_orden' => $orden,
                );
                $tig_id = $this->gsatelite->ingresar('tig_tipo_ingreso', $tig_registros);
                $dti_registros = array();
                for ($x = 0; $x < count($fin_cuenta) ; $x++) {
                    $fin_cuenta_reg = (trim($fin_cuenta[$x]) != "") ? $fin_cuenta[$x] : null;
                    $fin_tipo_cuenta_reg = (trim($fin_tipo_cuenta[$x]) != "") ? $fin_tipo_cuenta[$x] : null;
                    $fin_costo_reg = (trim($fin_costo[$x]) != "") ? $fin_costo[$x] : null;
                    $fin_porcentaje_reg = (trim($fin_porcentaje[$x]) != "") ? $fin_porcentaje[$x] : 0;

                    if($fin_cuenta_reg != null){
                        $dti_registros[] = array(
                            'dti_id_cec' => $fin_costo_reg,
                            'dti_id_cnt' => $fin_cuenta_reg,
                            'dti_id_tig' => $tig_id,
                            'dti_id_tcn' => $fin_tipo_cuenta_reg,
                            'dti_porcentaje' => null, //$fin_porcentaje_reg,
                            'dti_estado' => 1,
                            'dti_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dti_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dti_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dti_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    }
                }//End For
                if(count($dti_registros) > 0){
                    $this->gsatelite->ingresar('dti_detalle_tipo_ingreso', $dti_registros, true);
                }
                $respuesta = 1;
            } else{
                $respuesta = 0;
            }

            //$respuesta = $this->db->insert('tig_tipo_ingreso', $art_array);
            if($respuesta>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Procesado",'texto_alerta'=>"Registro(s) ingresado(s) con éxito");
            }else{
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error",'texto_alerta'=>"Ocurrió un error al ingresar la información");
            }
            $this->session->set_flashdata($alerta);

            $dir=$this->input->post('direccion');
            if($dir == 1){
                redirect('personal/catalogos/agregar_tipo_ingreso');
            }else if($dir == 2){
                redirect('personal/catalogos/tipos_ingreso');  
            }
        }else{
        $id_ingreso_sueldo=$this->gsatelite->get_parametro('INGRESO_SALARIO');
        $data['id_ingreso_sueldo'] = $id_ingreso_sueldo;
        $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
        $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
        $data['cuen_con']          = $this->gsatelite->get_tabla('cnt_cuenta_contable', array("cnt_estado" => 1, "cnt_id NOT IN ( $padres )" => NULL));
        $select                    = $this->gsatelite->get_dropdown('cgi_categoria_tipo_ingreso', '{cgi_nombre}', '', array('cgi_estado' => 1), null, '', 'cgi_id', true);
        $data["categoria_ingreso"] = str_replace('<option value="0">Seleccione</option>', '', $select);
        $select                    = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
        $data["costos"]            = str_replace('<option value="0">Seleccione</option>', '', $select);

        //Tipo de cuenta contable
        $select              = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
        $data["tcn_cnt_con"] = str_replace('<option value="0">Seleccione</option>', '', $select);
        $codigo              = ($this->gsatelite->get_max("tig_tipo_ingreso","tig_id"))+1;
        while ( count($this->gsatelite->get_tabla("tig_tipo_ingreso",array("tig_codigo"=> $codigo)) )>0 ) {
          $codigo++;
        }
        $data["codigo"] =  $codigo;
        $data['titulo_personal'] = "Tipo de ingreso";
        $this->_cargarvista($data);
    }
}

public function editar_tipo_ingreso($id_tipo){
    satelite_validar();
    if ($_POST) {
        $tipo = $this->input->post('tipo');
        //pestaña general
        $tip_ingreso = (trim($this->input->post('tip_ingreso')) != "") ? $this->input->post('tip_ingreso') : null; //cgi
        $descripcion = (trim($this->input->post('descripcion')) != "") ? $this->input->post('descripcion') : null;

        $codigo = (trim($this->input->post('codigo')) != "") ? $this->input->post('codigo') : null;
        $gravado = (trim($this->input->post('gravado')) != "") ? $this->input->post('gravado') : null;

        $nombre = (trim($this->input->post('nombre')) != "") ? $this->input->post('nombre') : null;
        $ge_factor = (trim($this->input->post('ge_factor')) != "") ? $this->input->post('ge_factor') : null;
        $estado = ($this->input->post('estado') != "") ? $this->input->post('estado') : 1;
        $aplica_fijo = ($this->input->post('hdn_chk_fijo') != null) ? $this->input->post('hdn_chk_fijo') : null;
        $montos_fijo = (trim($this->input->post('monto_fijo')) != "") ? str_replace(',', '', $this->input->post('monto_fijo')) : 0;
        //grid de la pestaña de finanzas
        $fin_cuenta = $this->input->post('fin_cuenta'); //array cnt
        $fin_tipo_cuenta= $this->input->post('fin_tipo_cuenta'); //array cnt
        $fin_costo = $this->input->post('fin_costo'); //array cec
        $fin_porcentaje = $this->input->post('fin_porcentaje'); //array

        if($codigo != null){
            $tig_registros = array(
                    'tig_id_cgi'=> $tip_ingreso,
                    'tig_codigo' => $codigo,
                    'tig_descripcion' => $descripcion,
                    'tig_nombre' => $nombre,
                    'tig_tipo_calculo' => 0,
                    'tig_cta_contable' => null,
                    'tig_factor' => $ge_factor,
                    'tig_estado' => $estado,
                    'tig_aplica_valor_fijo' => $aplica_fijo,
                    'tig_valor_fijo' => $montos_fijo
                    //'tig_orden' => $orden,
                );
            $this->gsatelite->actualizar_array('tig_tipo_ingreso', $tig_registros, array('tig_id' => $tipo));
            
            $this->gsatelite->borrado_general('dti_detalle_tipo_ingreso', array('dti_id_tig'=>$tipo));
            $dti_registros = array();
            for ($x = 0; $x < count($fin_cuenta) ; $x++) {
                $fin_cuenta_reg = (trim($fin_cuenta[$x]) != "") ? $fin_cuenta[$x] : null;
                $fin_tipo_cuenta_reg = (trim($fin_tipo_cuenta[$x]) != "") ? $fin_tipo_cuenta[$x] : null;
                $fin_costo_reg = (trim($fin_costo[$x]) != "") ? $fin_costo[$x] : null;
                $fin_porcentaje_reg = (trim($fin_porcentaje[$x]) != "") ? $fin_porcentaje[$x] : 0;
                if($fin_cuenta_reg != null){
                    $dti_registros[] = array(
                            'dti_id_cec' => $fin_costo_reg,
                            'dti_id_cnt' => $fin_cuenta_reg,
                            'dti_id_tig' => $tipo,
                            'dti_id_tcn' => $fin_tipo_cuenta_reg,
                            'dti_porcentaje' => null, //$fin_porcentaje_reg,
                            'dti_estado' => 1,
                            'dti_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dti_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dti_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dti_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                }
            }
            if(count($dti_registros) > 0){
                $this->gsatelite->ingresar('dti_detalle_tipo_ingreso', $dti_registros, true);
            }
            $respuesta = 1;
        } else{
            $respuesta = 0;
        }

        if($respuesta>0){
            $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Procesado",'texto_alerta'=>"Registro(s) ingresado(s) con éxito");
        }else{
            $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error",'texto_alerta'=>"Ocurrió un error al ingresar la información");
        }
        $this->session->set_flashdata($alerta);
        $dir = $this->input->post('direccion');
        if($dir == 1){
            redirect('personal/catalogos/editar_tipo_ingreso/'.$tipo);
        }else if($dir == 2){
            redirect('personal/catalogos/tipos_ingreso');  
        }
    }else{
        $id_ingreso_sueldo = $this->gsatelite->get_parametro('INGRESO_SALARIO');
        $data['id_ingreso_sueldo'] = $id_ingreso_sueldo; 
        $data['id_horas_extras'] = $this->gsatelite->get_parametro('ID_INGRESO_HORAS_EXTRAS', 0);
        $data['tipo'] = $id_tipo;
        $data['datos'] = $this->gsatelite->get_tabla('tig_tipo_ingreso', array('tig_id' => $id_tipo ));//registros de la tabla tig
        $data['cuentas'] = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1));

        $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
        $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
        $data['cuen_con']=$this->gsatelite->get_tabla('cnt_cuenta_contable', array("cnt_estado" => 1, "cnt_id NOT IN ( $padres )" => NULL));
        //select de categoria de ingreso
        $select = $this->gsatelite->get_dropdown('cgi_categoria_tipo_ingreso', '{cgi_nombre}', '', array('cgi_estado' => 1), $data['datos'][0]['tig_id_cgi'], '', 'cgi_id', true);
        $data["categoria_ingreso"] = str_replace('<option value="0">Seleccione</option>', '', $select);
        $select = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
        $data["costos"] = str_replace('<option value="0">Seleccione</option>', '', $select);

        //Tipo de cuenta contable
        $select = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
        $data["tcn_cnt_con"] = str_replace('<option value="0">Seleccione</option>', '', $select);

        $this->db->join('cnt_cuenta_contable','cnt_id = dti_id_cnt','inner')
                ->join('cec_centro_costo','cec_id = dti_id_cec','inner')
                ->join('tcn_tipo_cuenta','tcn_id = dti_id_tcn','left');
        $data['grid_finanza'] = $this->gsatelite->get_tabla('dti_detalle_tipo_ingreso', array('dti_id_tig'=>$id_tipo ));

        $data['titulo_personal'] = "Tipo de ingreso";

        $this->_cargarvista($data, null);
    }
}

public function validar_codigo()
{
    $codigo = $this->input->post('codigo');
    $code = $this->input->post('code');
    $codigos = $this->gsatelite->get_tabla('tig_tipo_ingreso');
    $resp = 0;
    if ($codigo == $code ) {
        echo json_encode(array('resp'=>$resp));
        die();
    }
    $codigo1 = strtolower($codigo);
    foreach ($codigos as $cod) {
      $codigo_base = strtolower($cod['tig_codigo']);
        if ($codigo_base == $codigo1) {
            $resp = 1;
            echo json_encode(array('resp'=>$resp));
            die();
        }
    }
    echo json_encode(array('resp'=>$resp));
}

    public function agregar_tipo_descuento(){
        if ($_POST) {
            // var_dump($_POST);die();
            //pestaña general
            $nombre = (trim($this->input->post('nombre')) != "") ? $this->input->post('nombre') : null;
            $es_prestamo  = $this->input->post('ptmo_banc');
            //grid de la pestaña de finanzas
            $fin_cuenta     = $this->input->post('fin_cuenta'); //array cnt
            $fin_tipo_cuenta = $this->input->post('fin_tipo_cuenta'); //array tipo de cuenta
            $fin_costo      = $this->input->post('fin_costo'); //array cec        
            $fin_porcentaje = $this->input->post('fin_porcentaje'); //array
            $tdc_codigo     = $this->input->post('txt_codigo'); 
            if($nombre != null){
                $tdc_registros = array(
                    'tdc_nombre'            => $nombre,
                    'tdc_codigo'            => $tdc_codigo,
                    'tdc_prestamo_bancario' => $es_prestamo,
                    'tdc_tipo_calculo'  => 0,
                    'tdc_tipo'          => 0,
                    'tdc_orden_calculo' => 0,
                    'tdc_estado' => 1,
                    'tdc_usu_creacion' => $this->tank_auth->get_user_id(),
                    'tdc_fecha_creacion' => date('Y-m-d H:i:s'),
                    'tdc_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'tdc_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $tdc_id = $this->gsatelite->ingresar('tdc_tipo_descuento', $tdc_registros);
                $dtd_registros = array();
                for ($x = 0; $x < count($fin_cuenta) ; $x++) {
                    $fin_cuenta_reg = (trim($fin_cuenta[$x]) != "") ? $fin_cuenta[$x] : null;
                    $fin_tipo_cuenta_reg = (trim($fin_tipo_cuenta[$x]) != "") ? $fin_tipo_cuenta[$x] : null;
                    $fin_costo_reg = (trim($fin_costo[$x]) != "") ? $fin_costo[$x] : null;
                    $fin_porcentaje_reg = (trim($fin_porcentaje[$x]) != "") ? $fin_porcentaje[$x] : 0;
                    if($fin_cuenta_reg != null){
                        $dtd_registros[] = array(
                            'dtd_id_cec' => $fin_costo_reg,
                            'dtd_id_cnt' => $fin_cuenta_reg,
                            'dtd_id_tdc' => $tdc_id,
                            'dtd_id_tcn' => $fin_tipo_cuenta_reg,
                            'dtd_porcentaje' => null, //$fin_porcentaje_reg,
                            'dtd_estado' => 1,
                            'dtd_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dtd_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dtd_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dtd_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    }
                }
                if(count($dtd_registros) > 0){
                    $this->gsatelite->ingresar('dtd_detalle_tipo_descuento', $dtd_registros, true);
                }
                $respuesta = 1;
            } else{
                $respuesta = 0;
            }
            if($respuesta>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Procesado",'texto_alerta'=>"Registro(s) ingresado(s) con éxito");
            }else{
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error",'texto_alerta'=>"Ocurrió un error al ingresar la información");
            }
            $this->session->set_flashdata($alerta);
            $dir=$this->input->post('direccion');
            if($dir == 1){
                redirect('personal/catalogos/agregar_tipo_descuento');
            }else if($dir == 2){
                redirect('personal/catalogos/tipos_descuento');  
            }
        }else{
            $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
            $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
                      $this->db->order_by('cnt_id','asc');
            $select = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array("cnt_estado" => 1, "cnt_id NOT IN ( $padres )" => NULL), null, '', 'cnt_id', true);
            $data["cuen_con"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data["costos"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            //Tipo de cuenta contable
            $select = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
            $data["tcn_cnt_con"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $codigo = ($this->gsatelite->get_max("tdc_tipo_descuento","tdc_id"))+1;
            while ( count($this->gsatelite->get_tabla("tdc_tipo_descuento",array("tdc_codigo"=> $codigo)) ) >0 ) {
                $codigo++;
            }
            $data["codigo"] =  $codigo;
            $data['titulo_personal'] = "Tipo de descuento";
            $this->_cargarvista($data);
        }
    }

    public function editar_tipo_descuento($id_tipo){
        satelite_validar();
        $id_descuento_isss=$this->gsatelite->get_parametro('DESCUENTO_ISS');
        $id_descuento_renta=$this->gsatelite->get_parametro('DESCUENTO_ISR');
        $id_descuento_afp=$this->gsatelite->get_parametro('DESCUENTO_AFP');
        $id_descuento_renta10=$this->gsatelite->get_parametro('DESCUENTO_ISR10');
        if ($_POST) {
            // var_dump($_POST); die();
            $tipo = $this->input->post('tipo');
            $es_prestamo = $this->input->post('ptmo_banc');
            //pestaña general
            $nombre = (trim($this->input->post('nombre')) != "") ? $this->input->post('nombre') : null;
            //grid de la pestaña de finanzas
            $fin_cuenta     = $this->input->post('fin_cuenta'); //array cnt
            $fin_tipo_cuenta= $this->input->post('fin_tipo_cuenta'); //array cnt
            $fin_costo      = $this->input->post('fin_costo'); //array cec
            $fin_porcentaje = $this->input->post('fin_porcentaje'); //array
            $tdc_codigo     = $this->input->post('txt_codigo'); 
            if($nombre != null){
                if ($id_descuento_isss == $tipo) {
                    $art_array = array(
                        'tdc_porcentaje'          => $this->input->post('porcentaje'),
                        'tdc_maximo'              => $this->input->post('maximo'),
                        'tdc_porcentaje_patronal' => $this->input->post('aporte'),
                        'tdc_codigo'              => $tdc_codigo
                    );
                }elseif ($id_descuento_renta10 == $tipo) {
                    $art_array = array(
                        'tdc_porcentaje'  => $this->input->post('porcentaje'),
                        'tdc_codigo'      => $tdc_codigo
                    );
                }else{
                    $art_array = array(
                        'tdc_nombre'  => $this->input->post('nombre'),
                        'tdc_codigo'  => $tdc_codigo
                    );
                }
                $art_array['tdc_prestamo_bancario'] = $es_prestamo;
                $art_array['tdc_usu_modificacion'] = $this->tank_auth->get_user_id();
                $art_array['tdc_fecha_modificacion'] = date('Y-m-d H:i:s');
                $respuesta = $this->gsatelite->actualizar_array('tdc_tipo_descuento',$art_array, array('tdc_id' => $tipo));
                $this->gsatelite->borrado_general('dtd_detalle_tipo_descuento', array('dtd_id_tdc'=>$tipo));
                $dtd_registros = array();
                for ($x = 0; $x < count($fin_cuenta) ; $x++) {
                    $fin_cuenta_reg = (trim($fin_cuenta[$x]) != "") ? $fin_cuenta[$x] : null;
                    $fin_tipo_cuenta_reg = (trim($fin_tipo_cuenta[$x]) != "") ? $fin_tipo_cuenta[$x] : null;
                    $fin_costo_reg = (trim($fin_costo[$x]) != "") ? $fin_costo[$x] : null;
                    $fin_porcentaje_reg = (trim($fin_porcentaje[$x]) != "") ? $fin_porcentaje[$x] : 0;
                    if($fin_cuenta_reg != null){
                        $dtd_registros[] = array(
                            'dtd_id_cec' => $fin_costo_reg,
                            'dtd_id_cnt' => $fin_cuenta_reg,
                            'dtd_id_tdc' => $tipo,
                            'dtd_id_tcn' => $fin_tipo_cuenta_reg,
                            'dtd_porcentaje' => null, //$fin_porcentaje_reg,
                            'dtd_estado' => 1,
                            'dtd_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dtd_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dtd_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dtd_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    }
                }
                if(count($dtd_registros) > 0){
                    $this->gsatelite->ingresar('dtd_detalle_tipo_descuento', $dtd_registros, true);
                }
                $respuesta = 1;
            } else{
                $respuesta = 0;
            }
            if($respuesta>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Procesado",'texto_alerta'=>"Registro(s) ingresado(s) con éxito");
            }else{
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error",'texto_alerta'=>"Ocurrió un error al ingresar la información");
            }
            $this->session->set_flashdata($alerta);
            $dir=$this->input->post('direccion');
            if($dir==1){
                redirect('personal/catalogos/editar_tipo_descuento/'.$tipo);
            }else if($dir==2){
                redirect('personal/catalogos/tipos_descuento');  
            }
        }else{
            $data['id_descuento_isss'] =$id_descuento_isss;
            $data['id_descuento_renta'] =$id_descuento_renta;
            $data['id_descuento_afp'] =$id_descuento_afp;
            $data['id_descuento_renta10'] =$id_descuento_renta10;
            $id_ingreso_sueldo=$this->gsatelite->get_parametro('INGRESO_SALARIO');
            $data['id_ingreso_sueldo']=$id_ingreso_sueldo;
            $data['tipo'] =$id_tipo;
            $data['datos'] = $this->gsatelite->get_tabla('tdc_tipo_descuento', array('tdc_id' => $id_tipo ));
            $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
            $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
                      $this->db->order_by('cnt_id','asc');
            $select = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array("cnt_estado" => 1, "cnt_id NOT IN ( $padres )" => NULL), null, '', 'cnt_id', true);
            $data["cuen_con"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data["costos"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            //Tipo de cuenta contable
            $select = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
            $data["tcn_cnt_con"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $this->db->join('cnt_cuenta_contable','cnt_id = dtd_id_cnt','inner')
                ->join('cec_centro_costo','cec_id = dtd_id_cec','inner')
                ->join('tcn_tipo_cuenta','tcn_id = dtd_id_tcn','left');
            $data['grid_finanza'] = $this->gsatelite->get_tabla('dtd_detalle_tipo_descuento', array('dtd_id_tdc'=>$id_tipo));
            $data['titulo_personal'] = "Tipo de descuento";
            $this->_cargarvista($data, null);
        }
    }

  public function validar_nombre()
    {
        $nombre = $this->input->post('nombre');
        $nombre_1 = $this->input->post('nombre_1');
        $nombres = $this->gsatelite->get_tabla('tdc_tipo_descuento');
        $resp = 0;
        if ($nombre == $nombre_1 ) {
            echo json_encode(array('resp'=>$resp));
            die();
        }
        $nombre_min = strtolower($nombre);
        foreach ($nombres as $nom) {
          $nombre_base = strtolower($nom['tdc_nombre']);
            if ($nombre_base == $nombre_min) {
                $resp = 1;
                echo json_encode(array('resp'=>$resp));
                die();
            }
        }
        print_r($_POST);
        echo json_encode(array('resp'=>$resp));
    }

  public function validar_codigo_tipo_descuento(){
    $codigo     = $this->input->post('codigo');
    $id_omitir  = ($this->input->post('codigo_tipo_descuendo') != "")?$this->input->post('codigo_tipo_descuendo'):0;
    $codigos    = $this->gsatelite->get_tabla("tdc_tipo_descuento",array("tdc_codigo" => $codigo, "tdc_id <>" => $id_omitir));
    $result = 0;
    if ( count($codigos) > 0  ) {
      $result = 1;
    } 
    echo $result;
  }
     /**
    * @author Jose Marlon
    * @since: 29/05/2019
    * @return: inserta los tipos de agrupadores
    */
    public function agrupadores_agregar($id=null){
        if ($_POST) {
            $id_ingresos = ($this->input->post('ingresos') != '') ? $this->input->post('ingresos') : null; 
            $id_descuentos = ($this->input->post('descuentos') != '') ? $this->input->post('descuentos') : null;
            $btn = $this->input->post('btnguardar');
            if ($id) {
                $this->gsatelite->borrado_general('deg_detalle_agrupador', array('deg_id_tag'=>$id));
            } else {
                $existe_nom = $this->gsatelite->get_tabla('tag_tipo_agrupador', array('tag_estado' => 1, 'LOWER(TRIM(tag_nombre))' => strtolower(trim($this->input->post('tag_nombre')))));
                $tag_nombre = (count($existe_nom) > 0) ? trim($this->input->post('tag_nombre')) . '_1' : trim($this->input->post('tag_nombre'));
                $array_insert = array('tag_nombre' => $tag_nombre, 'tag_tipo' => 'C', 'tag_estado' => 1);
                $tag_id = $this->gsatelite->ingresar('tag_tipo_agrupador', $array_insert);
            }
            for ($i=0; $i < count($id_ingresos) ; $i++) {
                $datos = array(
                    'deg_id_tag' => ($id) ? $id : $tag_id,
                    'deg_id_tig' => $id_ingresos[$i],
                    'deg_id_tdc' => null,
                    'deg_signo' => '+',
                    'deg_aplicacion' => 'P',
                    'deg_valor' => '100'
                );
                $deg_id = $this->gsatelite->ingresar('deg_detalle_agrupador', $datos);
            }
            for ($i=0; $i < count($id_descuentos); $i++) {
                $datos = array(
                    'deg_id_tag' => ($id) ? $id : $tag_id,
                    'deg_id_tig' => null,
                    'deg_id_tdc' => $id_descuentos[$i],
                    'deg_signo' => '-',
                    'deg_aplicacion' => 'P',
                    'deg_valor' => '100'
                );
                $deg_id = $this->gsatelite->ingresar('deg_detalle_agrupador', $datos);
            }
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tipo Agrupadores", 'texto_alerta' => "El registro se procesó correctamente");
            $this->session->set_flashdata($alerta);
            if ($btn > 0) {
                redirect('personal/catalogos/agrupadores');
            }
            $id_tag = ($id) ? $id : $tag_id;
            redirect('personal/catalogos/agrupadores_agregar/' . $id_tag);
        }
        $deg_detalle_agrupador = $this->gsatelite->get_tabla("deg_detalle_agrupador",array("deg_id_tag" => $id));
        $id_descuento = array(0);
        $id_ingreso = array(0);
        foreach ($deg_detalle_agrupador as $key) {
            if ($key['deg_id_tig'] > 0) {
                $id_ingreso[] = $key['deg_id_tig'];
            } else if($key['deg_id_tdc']>0) {
                $id_descuento[] = $key['deg_id_tdc'];
            }
        }
        $wheretdc = '('.implode(',', $id_descuento).')';
        $wheretig = '('.implode(',', $id_ingreso).')';
        $data['dropdown_desc'] = $this->personal_model->tdc_descuentos(array("tdc_id NOT IN $wheretdc" => null));
        $data['dropdown_ing'] = $this->personal_model->tig_ingresos(array("tig_id NOT IN $wheretig" => null));
        $data['nombre'] = $this->gsatelite->get_campo('tag_tipo_agrupador','tag_nombre', array('tag_id' => $id));
        $data['detalle_agrupador'] = $this->personal_model->tipo_agrupadores(array('deg_id_tag' => $id));
        $data['id_deg'] = $id;
        $data['titulo_personal'] = ($id) ? "Editar Agrupadores" : "Agregar Agrupadores";
        $this->_cargarvista($data);
}

    public function agregar_afp(){
        satelite_validar();
        if ( $this->input->post() ) {
            $afp_nombre             = ($this->input->post('txt_nombre_afp') != '')? $this->input->post('txt_nombre_afp') : ""; 
            $afp_maximo             = ($this->input->post('txt_salario') != '')? $this->input->post('txt_salario') : 0;
            $afp_porcentaje         = ($this->input->post('txt_porcentaje_empleado') != '')? $this->input->post('txt_porcentaje_empleado') : 0;
            $afp_porcentaje_patrono = ($this->input->post('txt_porcentaje_patrono') != '')? $this->input->post('txt_porcentaje_patrono') : 0;
            $codigo_del_usuario     = ($this->input->post('afp_internal_code') != '')? $this->input->post('afp_internal_code') : null;
            $afp_afp = array (
                "afp_codigo_interno"    => $codigo_del_usuario,
                "afp_nombre"            => $afp_nombre, 
                "afp_porcentaje"        => $afp_porcentaje,
                "afp_porcentaje_patrono"=> $afp_porcentaje_patrono,
                "afp_maximo"            => $afp_maximo,
                "afp_activo"            => 1
            );      
            $id_afp = $this->gsatelite->ingresar('afp_afp', $afp_afp );
            $centro_costo           = ($this->input->post('dtll_centro_costo') != '')? $this->input->post('dtll_centro_costo') : null;
            $tipo_cuenta            = ($this->input->post('dtll_tipo_cuenta') != '')? $this->input->post('dtll_tipo_cuenta') : null;
            $cuentas                = ($this->input->post('dtll_cuenta') != '')? $this->input->post('dtll_cuenta') : null;
            $dff_detalle_finanza_afp= [];
            foreach ($cuentas as $key => $cuenta) {
                $dff_detalle_finanza_afp[] = array(
                    "dff_id_afp"            => $id_afp,
                    "dff_id_cnt"            => $cuenta,
                    "dff_id_tcn"            => $tipo_cuenta[$key],
                    "dff_id_cec"            => $centro_costo[$key],
                    "dff_estado"            => 1,
                    "dff_usu_creacion"      => $this->tank_auth->get_user_id(),
                    "dff_fecha_creacion"    => date('Y-m-d h:i:s'),
                    "dff_usu_modificacion"  => $this->tank_auth->get_user_id(),
                    "dff_fecha_modificacion"=> date('Y-m-d h:i:s'),
                );
            }
            if ( count($dff_detalle_finanza_afp) >0 ) {
                $this->gsatelite->ingresar('dff_detalle_finanza_afp', $dff_detalle_finanza_afp, true);
            }
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de AFP", 'texto_alerta' => "El registro se ingreso correctamente.");
            $this->session->set_flashdata($alerta);
            $redireccion = ($this->input->post('crear') != '')? $this->input->post('crear') : 1;
            if ($redireccion == 1) {
                redirect('personal/catalogos/agregar_afp');
            } else {
                redirect('personal/catalogos/afp');
            }
            die();
        } else {
            //Centro de costos
            $centro_costo           = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data["centro_costo"]   = str_replace('<option value="0">Seleccione</option>', '', $centro_costo);      
            //tipo de cuenta
            $tipo_cuenta            = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
            $data["tipo_cuenta"]    = str_replace('<option value="0">Seleccione</option>', '', $tipo_cuenta);
            //cuenta contable
            $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
            $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
            $cuenta = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array("cnt_estado" => 1, "cnt_id NOT IN ($padres)" => null), null, '', 'cnt_id', true);
            $data["cuentas"]  = str_replace('<option value="0">Seleccione</option>', '', $cuenta);

            $data['titulo_personal']="Agregar AFP";
            $data['decimales']      = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $this->_cargarvista($data);
        }
    }

    public function editar_afp($afp = null){
        satelite_validar();
        if ( $this->input->post() ) {
            $afp_nombre             = ($this->input->post('txt_nombre_afp') != '')? $this->input->post('txt_nombre_afp') : ""; 
            $afp_maximo             = ($this->input->post('txt_salario') != '')? $this->input->post('txt_salario') : 0;
            $afp_porcentaje         = ($this->input->post('txt_porcentaje_empleado') != '')? $this->input->post('txt_porcentaje_empleado') : 0;
            $afp_porcentaje_patrono = ($this->input->post('txt_porcentaje_patrono') != '')? $this->input->post('txt_porcentaje_patrono') : 0;
            $codigo_del_usuario     = ($this->input->post('afp_internal_code') != '')? $this->input->post('afp_internal_code') : null;
            $afp_activo             = ($this->input->post('slc_estado') != '')? $this->input->post('slc_estado') : 0;
            $afp                    = ($this->input->post('txt_afp') != '')? $this->input->post('txt_afp') : 0;

            $afp_afp = array (
                "afp_codigo_interno"    => $codigo_del_usuario,
                "afp_nombre"            => $afp_nombre, 
                "afp_porcentaje"        => $afp_porcentaje,
                "afp_porcentaje_patrono"=> $afp_porcentaje_patrono,
                "afp_maximo"            => $afp_maximo,
                "afp_activo"            => $afp_activo
            );      
            $this->gsatelite->actualizar_array('afp_afp', $afp_afp, array('afp_id' => $afp) );

            $centro_costo           = ($this->input->post('dtll_centro_costo') != '')? $this->input->post('dtll_centro_costo') : null;
            $tipo_cuenta            = ($this->input->post('dtll_tipo_cuenta') != '')? $this->input->post('dtll_tipo_cuenta') : null;
            $cuentas                = ($this->input->post('dtll_cuenta') != '')? $this->input->post('dtll_cuenta') : null;
            $old_detalle            = ($this->input->post('dtll_old') != '')? $this->input->post('dtll_old') : null;
            $dff_detalle_finanza_afp= [];

            $dff_detalle_finanza_old= $this->gsatelite->get_tabla("dff_detalle_finanza_afp",array("dff_id_afp"=>$afp));

            foreach ($dff_detalle_finanza_old as $data) {
                if (!in_array($data['dff_id'], $old_detalle)) {
                    //Se elimina el detalle
                    $this->gsatelite->borrado_general('dff_detalle_finanza_afp', array('dff_id' => $data['dff_id']));
                }
            }

            foreach ($cuentas as $key => $cuenta) {
                if ($old_detalle[$key] == "") {
                    $dff_detalle_finanza_afp[] = array(
                        "dff_id_afp"            => $afp,
                        "dff_id_cnt"            => $cuenta,
                        "dff_id_tcn"            => $tipo_cuenta[$key],
                        "dff_id_cec"            => $centro_costo[$key],
                        "dff_estado"            => 1,
                        "dff_usu_creacion"      => $this->tank_auth->get_user_id(),
                        "dff_fecha_creacion"    => date('Y-m-d h:i:s'),
                        "dff_usu_modificacion"  => $this->tank_auth->get_user_id(),
                        "dff_fecha_modificacion"=> date('Y-m-d h:i:s'),
                    );
                } else {
                    $dff_detalle_finanza_afp_update = array(
                        "dff_id_cnt"            => $cuenta,
                        "dff_id_tcn"            => $tipo_cuenta[$key],
                        "dff_id_cec"            => $centro_costo[$key],
                        "dff_estado"            => 1,
                        "dff_usu_modificacion"  => $this->tank_auth->get_user_id(),
                        "dff_fecha_modificacion"=> date('Y-m-d h:i:s'),
                    );
                    $this->gsatelite->actualizar_array('dff_detalle_finanza_afp', $dff_detalle_finanza_afp_update, array('dff_id' => $old_detalle[$key]) );
                }
            }
      
            if ( count($dff_detalle_finanza_afp) >0 ) {
                $this->gsatelite->ingresar('dff_detalle_finanza_afp', $dff_detalle_finanza_afp, true);
            }
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de AFP", 'texto_alerta' => "El registro se ingreso correctamente.");
            $this->session->set_flashdata($alerta);
            $redireccion = ($this->input->post('crear') != '')? $this->input->post('crear') : 1;

            if ($redireccion == 1) {
                redirect('personal/catalogos/editar_afp/'.$afp);
            } else {
                redirect('personal/catalogos/afp');
            }
            die();
        } else {
            //Centro de costos
            $centro_costo           = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data["centro_costo"]   = str_replace('<option value="0">Seleccione</option>', '', $centro_costo);
            //tipo de cuenta
            $tipo_cuenta            = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
            $data["tipo_cuenta"]    = str_replace('<option value="0">Seleccione</option>', '', $tipo_cuenta);

            //cuenta contable
            $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
            $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
            $cuenta = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array("cnt_estado" => 1, "cnt_id NOT IN ($padres)" => null), null, '', 'cnt_id', true);
            $data["cuentas"]        = str_replace('<option value="0">Seleccione</option>', '', $cuenta);

            $data["afp"]            = $this->personal_model->get_detalles_afp(array("afp_id" => $afp),null);
            $data['titulo_personal']="Editar AFP";
            $data['decimales']      = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $this->_cargarvista($data);
        }
    }

  public function eliminar_afp($afp = null){ 
    satelite_validar();
    $this->gsatelite->actualizar_array('afp_afp', array('afp_activo'=>0), array('afp_id'=>$afp) );   
    redirect('personal/catalogos/afp');
    die();
  }

  function _cargarvista($data=0,$crud=0)
  {	
    $this->load->view('vacia',$crud);	
    if($data!=0)
     $data=array_merge($data,$this->masterpage->getUsuario());
   else
     $data=$this->masterpage->getUsuario();
   $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
   $this->masterpage->setMasterPage('masterpage_default');
   $this->masterpage->addContentPage($vista, 'content',$data);
   $this->masterpage->show();
 }

}