<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Perfil extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->library('grocery_CRUD');
	}

	function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {			
			$this->_cargarvista();
		}
	}

	function cambiar($id)
	{
		if ($id != null)
		{
			$nick = $this->sistema->obtenerNickUser($id);
			$data['titulo_personal'] = 'Cambiar Clave para '.$nick->username;
			$data['llave_u'] = $id;
			$this->_cargarvista($data);
		}
	}

	function cambiar_clave()
	{
		if (($_POST['clave_viej'] && $_POST['clave'] && $_POST['clave_conf']) != true)
		{
			$this->session->set_flashdata('menFaltanTodos', '$.pnotify({
			type: "Aviso",
		    title: "Importante",
    		text: "Debe especificar todos los valores solicitados.",
		    icon: "picon icon24 typ-icon-cancel white",
		    opacity: 0.95,
		    history: false,
		    sticker: false
			});');	
			redirect('perfil/perfil/cambiar/'.$_POST['llave']);		
		}
		else
		{
			if ($_POST['clave'] != $_POST['clave_conf'])
			{
				$this->session->set_flashdata('menNoIguales', '$.pnotify({
				type: "Aviso",
			    title: "Importante",
	    		text: "Los valores para \'Clave\' y \'Confirmar Clave\' deben ser iguales.",
			    icon: "picon icon24 typ-icon-info white",
			    opacity: 0.95,
			    history: false,
			    sticker: false
				});');	
				redirect('perfil/perfil/cambiar/'.$_POST['llave']);
			}
			else
			{
				$user = $this->users->get_user_by_id($_POST['llave'], TRUE);
				$hasher = new PasswordHash(
					$this->config->item('phpass_hash_strength', 'tank_auth'),
					$this->config->item('phpass_hash_portable', 'tank_auth'));
				if ($hasher->CheckPassword($_POST['clave_viej'], $user->password)) 
				{			
					$hashed_password = $hasher->HashPassword($_POST['clave']);
					$salio = $this->users->change_password($_POST['llave'], $hashed_password);
					if ($salio == true)
					{
						/*$this->session->set_flashdata('menSISeCambio', '$.pnotify({
						type: "Aviso",
					    title: "Cambiar Clave",
			    		text: "Cambio de Clave realizado con exito.",
					    icon: "picon icon24 typ-icon-info white",
					    opacity: 0.95,
					    history: false,
					    sticker: false
						});');*/
						 $alerta =   array('tipo_alerta'=> 'success','titulo_alerta'=>"Cambiar Clave",'texto_alerta'=>"Cambio de Clave realizado con exito.");
                                            $this->session->set_flashdata($alerta); 
                                            redirect('');
					}
					else
					{
						$this->session->set_flashdata('menNoSeCambio', '$.pnotify({
						type: "Aviso",
					    title: "Cambiar Clave",
			    		text: "Imposible realizar cambio de Clave.",
					    icon: "picon icon24 typ-icon-info white",
					    opacity: 0.95,
					    history: false,
					    sticker: false
						});');	
					}

					redirect('perfil/perfil/cambiar/'.$_POST['llave']);
				} 
				else 
				{															
					$this->session->set_flashdata('menClaveMala', '$.pnotify({
					type: "Aviso",
				    title: "Importante",
		    		text: "Valor para \'Clave\' incorrecto.",
				    icon: "picon icon24 typ-icon-cancel white",
				    opacity: 0.95,
				    history: false,
				    sticker: false
					});');	
					redirect('perfil/perfil/cambiar/'.$_POST['llave']);
				}
			}
		}
		
	}

	function setear_clave($post_array) 
	{
	  $hasher = new PasswordHash(
		$this->config->item('phpass_hash_strength', 'tank_auth'),
		$this->config->item('phpass_hash_portable', 'tank_auth'));

	  $hashed_password = $hasher->HashPassword($post_array['username']);
	  $post_array['password'] = $hashed_password;

	  return $post_array;
	} 


	function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();		
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */