<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Slp_procesos extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('gsatelite');
        $this->load->library('grocery_CRUD');
        $this->load->model('seleccion_personal_model');
        $this->load->library('tank_auth');
        $this->load->library('pdf');
        $this->load->library('texto');
        $this->load->model('personal_model');
        $this->load->model('expediente_personal_model');
        $this->load->model('consultas');
        $this->load->library('tank_auth');
        $this->load->model('planilla_model');
    }

    public function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    /**
    *@author Nelson Soriano
    *@since  11-06-2019
    *@param  none
    *@return Vista html para crear un candidato
    *
    **/
    public function solicitante_empleo(){
        satelite_validar();
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $where = null;
                $estado = ($this->input->post('estado') != '')?$this->input->post('estado'):null;
                if ($estado !== null) {
                    $where['sle_estado'] = $estado;
                }
                $data['permisos_emp']      = $this->gsatelite->get_permisos_opcion('expediente_personal/empleado/index_agregar_empleado');
                $data['info']              = $this->seleccion_personal_model->get_solicitantes($where);
                echo $html = $this->load->view('modulo_seleccion_personal/slp_procesos/get_solicitantes',$data,true);
                
            }else{
                $data['permisos']          = $this->gsatelite->get_permisos_opcion();
                $data['total_empleados']   = ''; 
                $titulo['titulo_personal'] = "Crear Candidato";
                $this->_cargarvista($titulo, $data);
            }
            
        }
    }

     /**
    *@author Nelson Soriano
    *@since  12-06-2019
    *@param  none
    *@return Confirmacion de transaccion realizada, agregar solicitante
    *
    **/
     public function agregar_solicitante(){
        satelite_validar();
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {   
            if ($_POST) {
                //Procesamos el post
            $cod_post = trim($this->input->post('codigo_emp'));
            $reg_cod = $this->gsatelite->get_registro('sle_solicitante_empleo', array('sle_codigo'=>$cod_post));
            if(count($reg_cod)>0){
                $last=$this->consultas->get_max_codigo('sle_solicitante_empleo','sle_codigo');
                $code=$last->codigo;
                $cod= (float)$code+1;
                $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
            }else{
                $codigo = $cod_post;
            }
            if ($this->input->post("fecha_prox_vac")!='') {//Fecha insertada menos 365 dias como ultima Vacacion
                $actual   =  strtotime($this->input->post("fecha_prox_vac"));
                $anterior =  strtotime('-365 day', $actual);
                $fecha_anterior =  date('d-m-Y', $anterior);
            }
            
            $nuevo = array(
                'sle_id_suc'    => ($this->input->post('sucursal') > 0) ? $this->input->post('sucursal') : null,
                'sle_id_plz'    => ($this->input->post('puesto') > 0) ? $this->input->post('puesto') : null,
                'sle_id_afp'    => ($this->input->post('afp') > 0 ) ? $this->input->post('afp') : null,
                'sle_id_emr'    => $this->tank_auth->get_empresa_id(), //id de empresa added by René Castaneda
                'sle_nombre'    => $this->input->post('nombres'),
                'sle_apellido'  => $this->input->post('apellidos'),
                'sle_estado'    => 1,
                'sle_direccion' => $this->input->post('direccion'),
                'sle_id_are'    => ($this->input->post('departamento') > 0) ? $this->input->post('departamento') : null,
                'sle_lugar_nac' => $this->input->post('lugar_nacimiento'),
                //'sle_id_pai'  => ($this->input->post('nacionalidad') != "") ? $this->input->post('nacionalidad') : null,
                'sle_fecha_nac' => date('Y-m-d', strtotime($this->input->post('fecha_nacimiento'))),
                'sle_id_gen'    => ($this->input->post('genero') != "") ? $this->input->post('genero') : null,
                //'sle_id_cnt'    => ($this->input->post('slcCuentaCont') > 0) ? $this->input->post('slcCuentaCont') : null,
                'sle_id_pro'    => ($this->input->post('profesion') != "") ? $this->input->post('profesion') : null,
                'sle_id_esc'    => ($this->input->post('estado_civil') != "") ? $this->input->post('estado_civil') : null,
                'sle_fecha_contrato' => date('Y-m-d', strtotime($this->input->post('fecha_contratacion'))),
                'sle_fecha_retiro'  => null, //$this->input->post(''),
                'sle_salario'       => ($this->input->post('salario') != "") ? $this->input->post('salario') : 0,
                'sle_salario_hora'  => ($this->input->post('salario_hora') != "") ? $this->input->post('salario_hora') : null,
                'sle_salario_hora_nocturna' => ($this->input->post('salario_hora_noc') != "") ? $this->input->post('salario_hora_noc') : null,
                'sle_metodo_pago'   => ($this->input->post('forma_pago_salario') > 0) ? $this->input->post('forma_pago_salario') : 0,
                'sle_usu_modificacion'=> $this->tank_auth->get_user_id(),
                'sle_fecha_modificacion'=> date('Y-m-d H:i:s'),
                'sle_usu_creacion'      => $this->tank_auth->get_user_id(),
                'sle_fecha_creacion'    => date('Y-m-d H:i:s'),
                'sle_codigo'        => $codigo,
                'sle_afp'           => $this->input->post('num_afp'),
                'sle_seguro'        => $this->input->post('num_seg'),
                'sle_id_ban'        => ($this->input->post('banco') != "") ? $this->input->post('banco') : null,
                'sle_numero_cuenta' => $this->input->post('cuenta_banco'),
                'sle_observacion_contrato' => trim($this->input->post('observacion_contratacion')),
                'sle_id_tic'        => ($this->input->post('tipo_contrato_empleado') != "") ? $this->input->post('tipo_contrato_empleado') : null,
                //'emp_color_icono' => strtoupper($this->input->post('color_emp')),
                'sle_id_pat_contacto' => ($this->input->post("contact_parentesco") != "") ? $this->input->post("contact_parentesco") : null, //id_parentesco
                'sle_estatura'      => ($this->input->post("enf_estatura") != "") ? $this->input->post("enf_estatura") : null,
                'sle_peso'          => ($this->input->post("enf_peso") != "") ? $this->input->post("enf_peso") : null,
                //'emp_tipo_sangre' => $this->input->post("enf_sangre"),
                'sle_id_tsr'        => ($this->input->post("slcTipoSangre") > 0)? $this->input->post("slcTipoSangre"):null,
                'sle_discapacidad'  => $this->input->post("enf_discapacidad"),
                'sle_id_tds'        => ($this->input->post("enf_discapacidad") == 1 && $this->input->post("slcTipoDiscapacidad") > 0 )? $this->input->post("slcTipoDiscapacidad"):null,
                'sle_observacion_clinica' => $this->input->post("enf_observacion"),
                'sle_contacto_emergencia' => $this->input->post("contact_a"),
                'sle_direccion_emergencia' => $this->input->post("contact_direccion"),
                'sle_telefono_emergencia' => $this->input->post("contact_telefono"),
                'sle_id_zon'        => ($this->input->post("slcZona") > 0)? $this->input->post("slcZona"):null,
                'sle_id_tiv'        => ($this->input->post("slcTipoCasa") > 0)? $this->input->post("slcTipoCasa"):null,
                'sle_id_tcv'        => ($this->input->post("slcTipoConstruccion") > 0)? $this->input->post("slcTipoConstruccion"):null,
                'sle_expediente'    => (trim($this->input->post("expediente_emp")) !='')? trim($this->input->post("expediente_emp")):null,
                'sle_id_mun'        => ($this->input->post("slcMunicipio") != '')? $this->input->post("slcMunicipio"):null,
                'sle_id_pai'        => ($this->input->post("slcNacionalidad") > 0)? $this->input->post("slcNacionalidad"):null,
                'sle_es_reingreso'  => ($this->input->post("ckcReingreso") > 0)? 1:0,
                'sle_es_jubilado'   => ($this->input->post("ckcJubilado") > 0)? 1:0,
                'sle_fecha_jubilado' => ($this->input->post("txtFechaJubilacion") !='' )? formatear_fecha('Y-m-d', $this->input->post('txtFechaJubilacion')):null,
                'sle_id_tps' => ($this->input->post("slcTipoSalario") > 0)? $this->input->post("slcTipoSalario"):null,
                'sle_id_cta' => ($this->input->post("slcCatAguinaldo") > 0)? $this->input->post("slcCatAguinaldo"):null,
                'sle_id_fnr' => ($this->input->post("slcFuenteReclutamiento") > 0)? $this->input->post("slcFuenteReclutamiento"):null,
                'sle_realizo_poligrafo' => ($this->input->post("ckcRealizaPoligrafo") > 0)? 1:0,
                'sle_codigo_referencia' => (trim($this->input->post("codigo_referencia")) !='')? trim($this->input->post("codigo_referencia")):null,
                'sle_id_tpc'        => ($this->input->post("slcTipoCuenta") > 0)? $this->input->post("slcTipoCuenta"):null,
                'sle_aplica_afp'    => ($this->input->post("ckcAplicaAfp") > 0)? 1:0,
                'sle_aplica_isss'   => ($this->input->post("ckcAplicaIsss") > 0)? 1:0,
                'sle_fecha_ult_liquidacion' => ($this->input->post("fecha_ult_liquidacion") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_ult_liquidacion')):null,
                'sle_fecha_fin_contrato' => ($this->input->post("fecha_fin_contrato") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_fin_contrato')):null,
                'sle_fecha_antiguedad' => ($this->input->post("fecha_antiguedad") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_antiguedad')):null,
                'sle_fecha_ult_aguinaldo'=> ($this->input->post("fecha_ult_aguinaldo") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_ult_aguinaldo')):null,
                'sle_fecha_ult_vacacion'=> ($this->input->post("fecha_prox_vac") !='' )? formatear_fecha('Y-m-d', $fecha_anterior):null

            );
            $this->db->insert('sle_solicitante_empleo', $nuevo);
            $emp_id = $this->db->insert_id();

            $correos = $this->input->post('correo_empleado');
            for ($i = 0; $i < count($correos); $i++) {
                if ($correos[$i] != null and trim($correos[$i]) != '') {
                    $this->db->insert('cse_correo_solicitante_empleo', array(
                        'cse_id_sle' => $emp_id,
                        'cse_correo' => $correos[$i],
                        'cse_estado' => 1,
                        'cse_fecha_creacion' => date('Y-m-d H:i:s'),
                        'cse_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cse_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cse_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
            }
            //Telefonos pq?
            $array = $this->input->post('numeros_telefons');
            $array_tit = $this->input->post('tipos_telefons');

            for ($x = 0; $x < count($array); $x++) {
                if ($array[$x] != "" && trim($array_tit[$x]) != "") {
                    $this->db->insert('tsl_telefono_solicitante', array(
                        'tsl_id_sle' => $emp_id,
                        'tsl_numero' => $array[$x],
                        'tsl_id_tit' => $array_tit[$x],
                        'tsl_estado' => 1,
                        'tsl_usu_creacion' => $this->tank_auth->get_user_id(),
                        'tsl_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'tsl_fecha_creacion' => date('Y-m-d H:i:s'),
                        'tsl_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                    $tel_id = $this->db->insert_id();
                }
            }

            
            $enf_alergia = $this->input->post("enf_alergia"); //id_cos_componente
            $enf_tipo = $this->input->post("enf_tipo"); //id_enf_enfermedad
            foreach ($enf_tipo as $key) {
                if (trim($key) != "") {
                    $this->db->insert('exs_enfermedaxsolicitante', array(
                        'exs_id_enf' => $key,
                        'exs_id_sle' => $emp_id,
                        'exs_estado' => 1,
                        'exs_fecha_creacion' => date('Y-m-d H:i:s'),
                        'exs_usu_creacion' => $this->tank_auth->get_user_id(),
                        'exs_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'exs_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
            }

            foreach ($enf_alergia as $key) {
                if (trim($key) != "") {
                    $this->db->insert('cas_componente_alergico_solicitante', array(
                        'cas_id_coa' => $key,
                        'cas_id_sle' => $emp_id,
                        'cas_estado' => 1,
                        'cas_fecha_creacion' => date('Y-m-d H:i:s'),
                        'cas_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cas_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cas_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
            }

            //coducmentos pq?
              $array2 = $this->input->post('numero_documento');
            //$ver2= array_pop($array2);
            $array2_1 = $this->input->post('documento');
            //$ver2_1 = array_pop($array2_1);
            $array_vence_doc = $this->input->post('vence_documento');
            $array_titulo_anexo = $this->input->post('titulo_anexo_doc');
            $array_nombre_anexo = $this->input->post('nombre_anexo_doc');
            $carpeta = $this->input->post("nombre_anexo_carpeta");

            $array_fexp_doc = $this->input->post('fecha_exp_doc');
            /* $array_lugarexp_doc = $this->input->post('lugar_
              $titulo_a = trim($array_titulo_anexo[$i]);
              $url_anexo="";exp_doc'); */
            $array_lugarexp_doc = $this->input->post('lugar_exp_doc');
            $array_munexp_doc = $this->input->post('mun_exp');
            $array_nombre_segun_doc = $this->input->post('nombre_segun_doc');
            $array_observacion_doc = $this->input->post('observacion_doc');

            $i = 0;

            foreach ($array2 as $key => $value2) {

                $f_vence = (trim($array_vence_doc[$i]) != "" and $array_vence_doc[$i] != null ) ? date('Y-m-d', strtotime(trim($array_vence_doc[$i]))) : null;
                $f_exp = (trim($array_fexp_doc[$i]) != "" and $array_fexp_doc[$i] != null ) ? date('Y-m-d', strtotime(trim($array_fexp_doc[$i]))) : null;
                //Se obtiene el titulo del anexo
                $titulo_a = trim($array_titulo_anexo[$i]);
                $url_anexo = "";

                if ($titulo_a != "") {
                    $tUnico = time();
                    $extencion = end(explode(".", $array_nombre_anexo[$i]));
                    //$url_anexo= "uploads/anexos_empleados/".trim($array_titulo_anexo[$i]).".".trim($extencion);
                    $url_anexo = clean_string(trim($array_titulo_anexo[$i])) . $tUnico . "." . trim($extencion); //se modifico de esta manera porque se uso grocery para su edicion.
                    
                    $this->datos_anexo_documento(trim($array_nombre_anexo[$i]), $carpeta, $titulo_a, $url_anexo); //funcion para guardar el anexo
                }

                $this->db->insert('dcs_documento_solicitante', array(
                    'dcs_id_tde' => $array2_1[$i],
                    'dcs_id_sle' => $emp_id,
                    'dcs_valor' => $value2,
                    'dcs_fecha_registro' => date('Y-m-d'),
                    'dcs_fecha_vence' => $f_vence,
                    'dcs_fecha_expedicion' => $f_exp,
                    'dcs_lugar_expedicion' => trim($array_lugarexp_doc[$i]),
                    'dcs_id_mun' => (trim($array_munexp_doc[$i]) != '')?trim($array_munexp_doc[$i]):NULL,
                    'dcs_nombre_segun_doc' => trim($array_nombre_segun_doc[$i]),
                    'dcs_observacion' => trim($array_observacion_doc[$i]),
                    'dcs_nombre_anexo' => $titulo_a,
                    'dcs_url' => $url_anexo,
                    'dcs_estado' => 1,
                    'dcs_usu_creacion' => $this->tank_auth->get_user_id(),
                    'dcs_fecha_creacion' => date('Y-m-d H:i:s'),
                    'dcs_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'dcs_fecha_modificacion' => date('Y-m-d H:i:s')
                ));
                //  $dce_id= $this->db->insert_id();
                //  $this->db->where('dce_id',$dce_id);
                //  $this->db->update('dce_documento_emp',array('dce_id_tde' => $array2_1[$i]));
                $i++;
            }

            // programas y equipos

             $array6 = $this->input->post('tipo_program');
            $array6_1 = $this->input->post('nivel_program');
            $i = 0;
            foreach ($array6 as $key => $value4) {
                if (trim($value4) != "" && trim($array6_1[$i]) != "")
                   $a[] = $this->db->insert('pxs_programaxsolicitante', array(
                        'pxs_id_peq' => $value4,
                        'pxs_id_sle' => $emp_id,
                        'pxs_id_nie' => $array6_1[$i],
                        'pxs_estado' => 1,
                        'pxs_fecha_creacion' => date('Y-m-d H:i:s'),
                        'pxs_usu_creacion' => $this->tank_auth->get_user_id(),
                        'pxs_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'pxs_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                $i++;
            }

             $array7 = $this->input->post('program_cer');
            $array7_1 = $this->input->post('tipo_program_cer');
            $array7_2 = $this->input->post('program_puntaje_cert');
            $array7_3 = $this->input->post('program_fecha_cert');
            $array7_4 = $this->input->post('program_institucion_cert');
            $array7_5 = $this->input->post('program_modalidad_cert');

            $i = 0;
            foreach ($array7 as $key => $value5) {
                if (trim($value5) != "" && trim($array7_1[$i]) != "" && trim($array7_2[$i]) != "" && trim($array7_3[$i]) != "") {
                    $this->db->insert('cps_certificacion_programa_solicitante', array(
                        'cps_id_sle' => $emp_id,
                        'cps_id_cer' => $array7_1[$i],
                        'cps_id_peq' => $value5,
                        'cps_puntaje' => $array7_2[$i],
                        'cps_id_mde'  => $array7_5[$i],
                        'cps_id_icp'  => $array7_4[$i],
                        'cps_fecha_certificacion' => (trim($array7_3[$i]) != "") ? date('Y-m-d', strtotime($array7_3[$i])) : null,
                        'cps_estado' => 1,
                        'cps_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cps_fecha_creacion' => date('Y-m-d H:i:s'),
                        'cps_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cps_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
                $i++;
            }


            //Datos Familiares

             $array3 = $this->input->post('nombres_familiares');
            $array3_1 = $this->input->post('apellidos_familiares');
            $array3_2 = $this->input->post('parentesco_familiares');
            $array3_3 = $this->input->post('telefono_familiares');
            $array3_4 = $this->input->post('fechas_familiares');
            $array3_5 = $this->input->post('dependencia_familiares');
            $array3_6 = $this->input->post('institucion_familiares');
            $array3_7 = $this->input->post('id_empleado_familiares');
            $array3_8 = $this->input->post('reside_con_empleado_familiares');
            $array3_9 = $this->input->post('beneficiario_familiares');
            $array3_10 = $this->input->post('beneficia_porcentaje_familiares');
            $i = 0;
            foreach ($array3 as $key => $value3) {
                /*print_r($array3_3);die();*/
                if (trim($value3) != "" && trim($array3_1[$i]) != "" && trim($array3_2[$i]) != "" && trim($array3_5[$i]) != "") 
                {
                    $query = array(
                        'fas_nombre' => $value3,
                        'fas_apellido' => $array3_1[$i],
                        'fas_fecha_nacimiento' => (trim($array3_4[$i]) != "") ? date('Y-m-d', strtotime($array3_4[$i])) : null,
                        'fas_dependiente' => $array3_5[$i],
                        'fas_empresa' => (is_numeric($array3_6[$i]))? $array3_6[$i]:null, //si familia en institucion
                        'fas_estado' => 1,
                        'fas_id_pat' => $array3_2[$i],
                        'fas_id_sle' => $emp_id,
                        //'fas_id_emp_familiar' => ($array3_7[$i]) ? $array3_7[$i] : null,
                        'fas_reside_empleado' => ($array3_8[$i] !='')?$array3_8[$i]:null,
                        'fas_beneficiario' =>  $array3_9[$i],
                        'fas_porcentaje_beneficio' =>  ($array3_10[$i] != '')?$array3_10[$i]:NULL,
                        'fas_telefono' => $array3_3[$i],
                        'fas_usu_creacion' => $this->tank_auth->get_user_id(),
                        'fas_fecha_creacion' => date('Y-m-d H:i:s'),
                        'fas_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'fas_fecha_modificacion' => date('Y-m-d H:i:s'));
                    $result = $this->db->insert('fas_familiar_solicitante',$query);
                    /*print_r($result);die();*/
                }
                $i++;
            }


            // Datos de idiomas

            $array4 = $this->input->post('idioma');
            $array4_1 = $this->input->post('nivel');
            $array4_2 = $this->input->post('leer');
            $array4_3 = $this->input->post('escribir');
            $array4_4 = $this->input->post('hablar');
            $array4_5 = $this->input->post('traductor');
            for ($x = 0; $x < count($array4); $x++) {
                if ($array4[$x] != "" && $array4_1[$x] != "") {
                    $this->db->insert('ids_idioma_solicitante', array(
                        'ids_id_nii' => $array4_1[$x],
                        'ids_id_idm' => $array4[$x],
                        'ids_id_sle' => $emp_id,
                        'ids_leer' => ($array4_2[$x] != "") ? $array4_2[$x] : 0,
                        'ids_escribir' => ($array4_3[$x] != "") ? $array4_3[$x] : 0,
                        'ids_hablar' => ($array4_4[$x] != "") ? $array4_4[$x] : 0,
                        'ids_traductor' => ($array4_5[$x] != "") ? $array4_5[$x] : 0,
                        'ids_estado' => 1,
                        'ids_usu_creacion' => $this->tank_auth->get_user_id(),
                        'ids_fecha_creacion' => date('Y-m-d H:i:s'),
                        'ids_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'ids_fecha_modificacion' => date('Y-m-d H:i:s')));
                }
            }

            //Cestificado de idiomas

            $array5 = $this->input->post('idioma_cert');
            $array5_1 = $this->input->post('tipo_cert');
            $array5_2 = $this->input->post('puntaje_cert');
            $array5_3 = $this->input->post('fecha_cert');
            for ($x = 0; $x < count($array5); $x++) {
                if ($array5[$x] != "" && $array5_1[$x] != "" && $array5_2[$x] != "" && $array5_3[$x] != "") {
                    $this->db->insert('cis_certificacion_idioma', array(
                        'cis_id_sle' => $emp_id,
                        'cis_id_cer' => $array5_1[$x],
                        'cis_id_idm' => $array5[$x],
                        'cis_puntaje' => $array5_2[$x],
                        'cis_fecha_certificacion' => (trim($array5_3[$x]) != "") ? date('Y-m-d', strtotime($array5_3[$x])) : null,
                        'cis_estado' => 1,
                        'cis_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cis_fecha_creacion' => date('Y-m-d H:i:s'),
                        'cis_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cis_fecha_modificacion' => date('Y-m-d H:i:s')));
                }
            }

            //Referencias Personales

            $array8 = $this->input->post('tipo_refpersonal');
            $array8_1 = $this->input->post('nombre_refpersonal');
            $array8_2 = $this->input->post('ltrabajo_refpersonal');
            $array8_3 = $this->input->post('ocupacion_refpersonal');
            $array8_4 = $this->input->post('telefono_refpersonal');
            $array8_5 = $this->input->post('referencia_refpersonal');

            for ($x = 0; $x < count($array8); $x++) {
                if ($array8[$x] != "" && $array8_1[$x] != "" && $array8_2[$x] != "" && $array8_4[$x] != "") {
                    $this->db->insert('rps_referencia_personal_solicitante', array(
                        'rps_id_trr' => $array8[$x],
                        'rps_id_sle' => $emp_id,
                        'rps_nombre' => $array8_1[$x],
                        'rps_lugar_trabajo' => $array8_2[$x],
                        'rps_ocupacion' => (trim($array8_3[$x]) != "") ? $array8_3[$x] : null,
                        'rps_telefono' => $array8_4[$x],
                        'rps_descripcion_referencia' => (trim($array8_5[$x]) != '')? $array8_5[$x]:null,
                        'rps_estado' => 1,
                        'rps_fecha_creacion' => date('Y-m-d H:i:s'),
                        'rps_usu_creacion' => $this->tank_auth->get_user_id(),
                        'rps_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rps_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
            }

            //Referencias La borales

            $array9 = $this->input->post('lugar_tra_reflab');
            $array9_1 = $this->input->post('direccion_reflab');
            $array9_2 = $this->input->post('telefono_reflab');
            $array9_3 = $this->input->post('puesto_reflab');
            $array9_4 = $this->input->post('jefe_inmediato_reflab');
            $array9_5 = $this->input->post('salario_deven_reflab');
            $array9_6 = $this->input->post('mot_retiro_reflab');

            $array9_7 = $this->input->post('nombre_referencia_reflab');
            $array9_8 = $this->input->post('desde_reflab');
            $array9_9 = $this->input->post('hasta_reflab');
            $array9_10 = $this->input->post('referencia_reflab');

            for ($x = 0; $x < count($array9); $x++) {
                if ($array9[$x] != "" && $array9_1[$x] != "" && $array9_3[$x] != "") {
                    $this->db->insert('rls_referencia_laboral_solicitante', array(
                        'rls_id_sle' => $emp_id,
                        'rls_lugar_trabajo' => $array9[$x],
                        'rls_direccion' => $array9_1[$x],
                        'rls_telefono' => $array9_2[$x],
                        'rls_puesto' => $array9_3[$x],
                        'rls_jefe' => $array9_4[$x],
                        'rls_salario_devengado' => ($array9_5[$x] != '')?$array9_5[$x]:NULL,
                        'rls_motivo_retiro' => $array9_6[$x],
                        'rls_nombre_ref' => $array9_7[$x],
                        'rls_fecha_desde' => (trim($array9_8[$x]) != '')? formatear_fecha('Y-m-d',$array9_8[$x]):null,
                        'rls_fecha_hasta' => (trim($array9_9[$x]) != '')? formatear_fecha('Y-m-d',$array9_9[$x]):null,
                        'rls_referencia' => $array9_10[$x],
                        'rls_estado' => 1,
                        'rls_fecha_creacion' => date('Y-m-d H:i:s'),
                        'rls_usu_creacion' => $this->tank_auth->get_user_id(),
                        'rls_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rls_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
            }

            //Datos Academicos

            $array10 = $this->input->post('tipo_datacademicos');
            $array10_1 = $this->input->post('profesion_datacademicos');
            $array10_2 = $this->input->post('institucion_datacademicos');
            $array10_3 = $this->input->post('estestudio_datacademicos');
            $array10_4 = $this->input->post('pais_datacademicos');
            $array10_5 = $this->input->post('explaboral_datacademicos');
            $array10_6 = $this->input->post('fecha_datacademicos');
            $array10_7 = $this->input->post('observacion_datacademicos');

            $array10_8 = $this->input->post('anios_cursado_estudio_datacademicos');

            foreach ($array10 as $key => $value) {
                if ($array10[$key] > 0/*  && $array10_3[$key] != "" && $array10_4[$key] != "" && $array10_5[$key]*/) {
                    $this->db->insert('das_dato_academico_solicitante', array(
                        'das_id_pai' => ($array10_4[$key] > 0)? $array10_4[$key]:null,
                        'das_id_tie' => $array10[$key],
                        'das_id_pro' => ($array10_1[$key] > 0)? $array10_1[$key]:null,
                        'das_id_ese' => ($array10_3[$key] > 0)? $array10_3[$key]:null,
                        'das_id_sle' => $emp_id,
                        'das_id_exl' => ($array10_5[$key]  > 0) ? $array10_5[$key] : null,
                        'das_id_ina' => ($array10_2[$key]) ? $array10_2[$key] : null,
                        'das_fecha_finalizacion' => (trim($array10_6[$key]) != "") ? formatear_fecha('Y-m-d', $array10_6[$key]) : null,
                        'das_observacion' => $array10_7[$key],
                        'das_anios_cursado' => ($array10_8[$key] > 0)? $array10_8[$key]:null,
                        'das_estado' => 1,
                        'das_fecha_creacion' => date('Y-m-d H:i:s'),
                        'das_usu_creacion' => $this->tank_auth->get_user_id(),
                        'das_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'das_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
            }

            //INICIO GUARDADO DE HABILIDADES EMPLEADO

            $hablidad_empleado = $this->input->post('hablidad_empleado');
            $nivel_hablidad_empleado = $this->input->post('nivel_hablidad_empleado');

            for ($hab_emp=0; $hab_emp < count($hablidad_empleado) ; $hab_emp++) { 
                if ($hablidad_empleado[$hab_emp] > 0) {
                   $array_insert_reg = array(
                    'hxs_id_hab' => $hablidad_empleado[$hab_emp],
                    'hxs_id_sle' => $emp_id,
                    'hxs_id_nih' => ($nivel_hablidad_empleado[$hab_emp] > 0)? $nivel_hablidad_empleado[$hab_emp]:null,
                    'hxs_estado' => 1,
                    'hxs_usu_creacion' => $this->tank_auth->get_user_id(),
                    'hxs_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'hxs_fecha_creacion' => date('Y-m-d H:i:s'),
                    'hxs_fecha_modificacion' => date('Y-m-d H:i:s')
                   );

                   $id_hxm = $this->gsatelite->ingresar('hxs_habilidadxsolicitante', $array_insert_reg);
                }
            }

            // Agrupaciones empleado

            $agrupacion_emp = $this->input->post('agrupacion_emp');
              $anio_afiliacion = $this->input->post('anio_afiliacion');
              $estado_afiliacion = $this->input->post('estado_afiliacion');

              for ($agru_emp=0; $agru_emp < count($agrupacion_emp) ; $agru_emp++) { 
                  if (trim($agrupacion_emp[$agru_emp]) != '') {
                     $array_insert_reg = array(
                      'ags_nombre' => $agrupacion_emp[$agru_emp],
                      'ags_anio_afiliacion' => ($anio_afiliacion[$agru_emp] >0)? $anio_afiliacion[$agru_emp]:null,
                      'ags_estado_agrupacion' => ($estado_afiliacion[$agru_emp] >0)? 1:0,
                      'ags_id_sle' => $emp_id,
                      'ags_estado' => 1,
                      'ags_usu_creacion' => $this->tank_auth->get_user_id(),
                      'ags_usu_modificacion' => $this->tank_auth->get_user_id(),
                      'ags_fecha_creacion' => date('Y-m-d H:i:s'),
                      'ags_fecha_modificacion' => date('Y-m-d H:i:s')
                     );

                     $id_age = $this->gsatelite->ingresar('ags_agrupacion_solicitante', $array_insert_reg);
                  }
              }

              //Servicios Basicos

              /*
              $slcServiciosBasicos = $this->input->post('slcServiciosBasicos');
                for ($sbi = 0; $sbi < count($slcServiciosBasicos); $sbi++) {
                    if ($slcServiciosBasicos[$sbi] > 0 ) {
                        $array_insert_reg = array(
                         'sre_id_srb' => $slcServiciosBasicos[$sbi],
                         'sre_id_emp' => $emp_id,
                         'sre_estado' => 1,
                         'sre_usu_creacion' => $this->tank_auth->get_user_id(),
                         'sre_usu_modificacion' => $this->tank_auth->get_user_id(),
                         'sre_fecha_creacion' => date('Y-m-d H:i:s'),
                         'sre_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $id_sre = $this->gsatelite->ingresar('sre_servicio_empleado', $array_insert_reg);
                    }
                }*/
            //insumos empleados
                 $tipo_insumo_array = $this->input->post('tipo_insumo_array');
                $insumo_array = $this->input->post('insumo_array');
                $cantidad_insumo_array = $this->input->post('cantidad_insumo_array');
                $costo_insumo_array = $this->input->post('costo_insumo_array');
                $fecha_insumo_array = $this->input->post('fecha_insumo_array');

                foreach ($insumo_array as $key => $insumo) {
                    $array_ixe_insumoxempleado = array(                        
                        'ise_id_inm' => $insumo_array[$key],
                        'ise_id_sle' => $emp_id,
                        'ise_cantidad' => $cantidad_insumo_array[$key],
                        'ise_costo' => $costo_insumo_array[$key],
                        'ise_fecha_entrega' => formatear_fecha('Y-m-d',$fecha_insumo_array[$key]),
                        'ise_estado' => 1,
                        'ise_usu_creacion' => $this->tank_auth->get_user_id(),
                        'ise_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'ise_fecha_creacion' => date('Y-m-d H:i:s'),
                        'ise_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $id_ixe = $this->gsatelite->ingresar('ise_isumo_solicitante_empleo', $array_ixe_insumoxempleado);                    
                } 

                //Capacitaciones empleado

                  $nombre_capa_array = $this->input->post('nombre_capa_array');
                  $institucion_capa_array = $this->input->post('institucion_capa_array');
                  $fecha_inicio_capa_array = $this->input->post('fecha_inicio_capa_array');
                  $fecha_fin_capa_array = $this->input->post('fecha_fin_capa_array');
                  $hora_duracion_capa_array = $this->input->post('hora_duracion_capa_array');
                  $costo_capa_array = $this->input->post('costo_capa_array');
                  $costo_cubierto_insa_array = $this->input->post('costo_cubierto_insa_array');
                  $costo_cubierto_prov_array = $this->input->post('costo_cubierto_prov_array');
                  $estado_capa_array = $this->input->post('estado_capa_array');

                  foreach ($nombre_capa_array as $key => $nomcap) {
                      $array_cpe_capacitacion_empleado = array(                                                  
                          'ccs_id_sle' => $emp_id,
                          'ccs_id_ese' => is_numeric($estado_capa_array[$key])? $estado_capa_array[$key]:null,
                          'ccs_id_icp' => is_numeric($institucion_capa_array[$key])? $institucion_capa_array[$key]:null,
                          'ccs_nombre' => $nomcap,
                          'ccs_duracion' => $hora_duracion_capa_array[$key],
                          'ccs_costo_empresa' => $costo_capa_array[$key],
                          'ccs_costo_insaforp' => $costo_cubierto_insa_array[$key],
                          'ccs_costo_proveedor' => $costo_cubierto_prov_array[$key],
                          'ccs_fecha_inicio' => formatear_fecha('Y-m-d',$fecha_inicio_capa_array[$key]),
                          'ccs_fecha_fin' => formatear_fecha('Y-m-d',$fecha_fin_capa_array[$key]),                          
                          'ccs_estado' => 1,
                          'ccs_usu_creacion' => $this->tank_auth->get_user_id(),
                          'ccs_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'ccs_fecha_creacion' => date('Y-m-d H:i:s'),
                          'ccs_fecha_modificacion' => date('Y-m-d H:i:s')
                      );
                      $id_ixe = $this->gsatelite->ingresar('ccs_capacitacion_solicitante', $array_cpe_capacitacion_empleado);                    
                  }

                  //Anexos

                $rutas = $this->input->post("ruta");
                $carpeta = $this->input->post("nombreCarpeta");

                if (count($rutas) > 0) {
                    $carpeta = $carpeta;
                    for ($i = 0; $i < count($rutas); $i++) {
                        if ($rutas[$i] != "") {
                            $img = $rutas[$i];
                            $titulo = $this->input->post("titulo_doc" . ($i));
                            $this->datos_imagen_gral($img, $emp_id, $carpeta, $titulo);
                        }
                    }
                }

                if ($this->input->post('foto_empleado') != "" and $this->input->post('titulo_foto_empleado') != "") { //guardar la foto del empleado
                $titulo = $this->input->post('titulo_foto_empleado');
                $img = $this->input->post('foto_empleado');
                $this->datos_imagen_gral($img, $emp_id, $carpeta, $titulo, 1); //es de tipo foto
                }

                

                /* ===============================================================================================================================
              =                                         ACTUALIZACION DE PLAZAS
              =================================================================================================================================
             */

              
              $cnp   = $this->input->post('concursos_activos');
              $sele  = $this->input->post('seleccionadox');
              $ob    = $this->input->post('observaciones');
               if ((is_array($cnp)) && (count($cnp) >0)){
                    for ($i=0; $i < count($cnp); $i++) { 
                    $array_plazas  = array(
                        'csp_id_sle'            => $emp_id,
                        'csp_id_cnp'            => $cnp[$i],
                        'csp_seleccionado'      => 0,
                        'csp_fecha_seleccion'   => null,
                        'csp_observacion'       => ($ob != '')?$ob[$i]:null,
                        'csp_estado'            => 1,
                        'csp_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'csp_fecha_creacion'    => date('Y-m-d H:m:s'),
                        'csp_usu_modificacion'  => $this->tank_auth->get_user_id(), 
                        'csp_fecha_modificacion'=> date('Y-m-d H:m:s')

                    );
                    $this->gsatelite->ingresar('csp_concurso_xsolicitante_empleo',$array_plazas);

                  }
                }

                //entrevista

                  $ens_id = $this->input->post('ens_id');
                  $tipo_entrevista = $this->input->post('tipo_entrevista');
                  $fecha_entrevista = $this->input->post('fecha_gen');
                  $lugar_entrevista = $this->input->post('lugar_ent');
                  $ponderacion_entrevista = $this->input->post('ponde_ent');
                  $descripcion_entrevista = $this->input->post('descr_ent');
                  $nombre_realizo = $this->input->post('nom_entre');

                  foreach ($ens_id as $key => $value) {
                      $array_entrevista = array(                                                  
                          'ens_id_tnv' => $tipo_entrevista[$key],
                          'ens_id_sle' => $emp_id,
                          'ens_fecha' => formatear_fecha("Y-m-d",$fecha_entrevista[$key]),
                          'ens_persona_realiza' => $nombre_realizo[$key],
                          'ens_lugar' => $lugar_entrevista[$key],
                          'ens_ponderacion' => $ponderacion_entrevista[$key],
                          'ens_descripcion' => $descripcion_entrevista[$key],                      
                          'ens_estado' => 1,
                          'ens_usu_creacion' => $this->tank_auth->get_user_id(),
                          'ens_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'ens_fecha_creacion' => date('Y-m-d H:i:s'),
                          'ens_fecha_modificacion' => date('Y-m-d H:i:s')
                      );
                      $id_ens = $this->gsatelite->ingresar('ens_entrevista_solicitante_empleo', $array_entrevista);                    
                  }

                  //PRUEBASSSSSS

                  $pse_id = $this->input->post('pse_id');
                  $tipo_prueba = $this->input->post('tipo_prueba');
                  $nombre_realizo_prueba = $this->input->post('nom_prueba');
                  $fecha_prueba = $this->input->post('fecha_prueba');
                  $lugar_prueba = $this->input->post('lugar_prueba');
                  $nota_prueba = $this->input->post('nota_prueba');
                  $descripcion_prueba = $this->input->post('descr_prueba');

                  foreach ($pse_id as $key => $value) {
                      $array_prueba = array(                                                  
                          'pse_id_tib' => $tipo_prueba[$key],
                          'pse_id_sle' => $emp_id,
                          'pse_fecha' => formatear_fecha("Y-m-d",$fecha_prueba[$key]),
                          'pse_persona_califica' => $nombre_realizo_prueba[$key],
                          'pse_lugar' => $lugar_prueba[$key],
                          'pse_resultado' => $nota_prueba[$key],
                          'pse_descripcion' => $descripcion_prueba[$key],                      
                          'pse_estado' => 1,
                          'pse_usu_creacion' => $this->tank_auth->get_user_id(),
                          'pse_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'pse_fecha_creacion' => date('Y-m-d H:i:s'),
                          'pse_fecha_modificacion' => date('Y-m-d H:i:s')
                      );
                      $id_pse = $this->gsatelite->ingresar('pse_pruebas_solicitante_empleo', $array_prueba);                    
                  }

            

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de solicitante", 'texto_alerta' => "El registro se guardó correctamente");
                $this->session->set_flashdata($alerta);
                // Redireccion
                $redireccion = $this->input->post('redireccion');
                if ($redireccion == 1) {
                    redirect('modulo_seleccion_personal/slp_procesos/agregar_solicitante');
                } else {
                    redirect('modulo_seleccion_personal/slp_procesos/solicitante_empleo');
                }
                
            

            }else{
                //Creamos los controles necesarios
                $data['genero'] = $this->personal_model->get_genero();
                $data['nacionalidad'] = $this->personal_model->get_nacionalidad();
                $data['estado_civil'] = $this->personal_model->get_estado_civil();
                $data['profesion'] = $this->personal_model->get_profesion();
                $data['tipo_telefono'] = $this->personal_model->get_tipotelefono();
                $data['afp'] = $this->personal_model->get_afp();
                $data['doc_documentos'] = $this->personal_model->get_documentos();
                $tipos_doc = $this->expediente_personal_model->get_dropdown('tde_tipo_documento', '{tde_nombre}', '', array('tde_estado' => 1), null, '', 'tde_id', true);
                $data['options_tipo_documento'] = str_replace('<option value="0">Seleccione</option>', '', $tipos_doc);

                $arreglo_ids = $this->expediente_personal_model->get_permitidos_plaza_solicita();
                $this->db->where_not_in('plz_id', $arreglo_ids);
                $where_plaza = array('plz_estado' => '1');


                $this->db->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are');
                $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda 02-03-2018  
                $data['plaza'] = $this->gsatelite->get_tabla('plz_plaza', $where_plaza);
                $data['departamento'] = $this->personal_model->get_departamento();
                $data['sucursal'] = $this->personal_model->get_sucursal();
                $data['tipo_contrato'] = $this->personal_model->get_tipo_contrato();
                $data['parentescos'] = $this->personal_model->get_parentesco();

                $titulo['titulo_personal'] = "Nuevo solicitante";

                $select = $this->expediente_personal_model->get_dropdown('idm_idioma', '{idm_nombre}', '', array('idm_estado' => 1), null, '', 'idm_id', true);
                $data["idm_idioma"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $select = $this->expediente_personal_model->get_dropdown('nii_nivel_idioma', '{nii_nombre}', '', array('nii_estado' => 1), null, '', 'nii_id', true);
                $data["nivel_idioma"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                $select = "";
                $datos = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 1));
                foreach ($datos as $key) {
                    $select .= '<option value = "' . $key['cer_id'] . '">' . $key['cer_nombre'] . '</option>';
                }
                $data["cert_idioma_d"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                $data["alergico"] = $this->gsatelite->get_tabla('coa_componente_alergico', array('coa_estado' => 1));
                $data["enfermedad"] = $this->gsatelite->get_tabla('enf_enfermedad', array('enf_estado' => 1));

                //programas
                $select = $this->expediente_personal_model->get_dropdown('nie_nivel_experiencia', '{nie_nombre}', '', array('nie_estado' => 1), null, '', 'nie_id', true);
                $data["nivel_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $select = $this->expediente_personal_model->get_dropdown('peq_programa_equipo', '{peq_nombre}', '', array('peq_estado' => 1), null, '', 'peq_id', true);
                $data["tipo_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $select = "";
                $datos = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 2));
                foreach ($datos as $key) {
                    $select .= '<option value = "' . $key['cer_id'] . '">' . $key['cer_nombre'] . '</option>';
                }
                $data["cert_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                $select = $this->expediente_personal_model->get_dropdown('icp_institucion_capacitacion', '{icp_nombre}', '', array('icp_estado' => 1), null, '', 'icp_id', true);
                $data["institucion_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                $select = $this->expediente_personal_model->get_dropdown('mde_modalidad_estudio', '{mde_nombre}', '', array('mde_estado' => 1), null, '', 'mde_id', true);
                $data["modalidad_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);



                //RefPersonales
                $select = $this->expediente_personal_model->get_dropdown('trr_tipo_referencia', '{trr_nombre}', '', array('trr_estado' => 1), null, '', 'trr_id', true);
                $data["tipo_referencia"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                //DatAcademicos
                $select = $this->expediente_personal_model->get_dropdown('tie_tipo_educacion', '{tie_nombre}', '', array('tie_estado' => 1), null, '', 'tie_id', true);
                $data["tipo_educacion"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $select = $this->expediente_personal_model->get_dropdown('pro_profesion', '{pro_nombre}', '', array('pro_estado' => 1), null, '', 'pro_id', true);
                $data["pro_profesion"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $select = $this->expediente_personal_model->get_dropdown('ina_institucion_academica', '{ina_nombre}', '', array('ina_estado' => 1), null, '', 'ina_id', true);
                $data["institucion_academica"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $select = $this->expediente_personal_model->get_dropdown('ese_estado_estudio', '{ese_nombre}', '', array('ese_estado' => 1), null, '', 'ese_id', true);
                $data["estado_estudio"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $select2 = $this->expediente_personal_model->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), null, '', 'pai_id', true);
                $data["pai_pais"] = str_replace('<option value="0">Seleccione</option>', '', $select2);
                $select = $this->expediente_personal_model->get_dropdown('exl_experiencia_laboral', '{exl_nombre}', '', array('exl_estado' => 1), null, '', 'exl_id', true);
                $data["experiencia_laboral"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                $select = $this->gsatelite->get_dropdown('hab_habilidad', '{hab_nombre}', '', array('hab_estado' => 1), null, '', 'hab_id', true);
                $data["habilidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

                $select = $this->gsatelite->get_dropdown('nih_nivel_habilidad', '{nih_nombre}', '', array('nih_estado' => 1), null, '', 'nih_id', true);
                $data["nivel_habilidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
                $select = $this->gsatelite->get_dropdown('zon_zona', '{zon_nombre}', '', array('zon_estado' => 1), null, '', 'zon_id', true);
                $data["slcZona"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
                $select = $this->gsatelite->get_dropdown('tiv_tipo_vivienda', '{tiv_nombre}', '', array('tiv_estado' => 1), null, '', 'tiv_id', true);
                $data["slcTipoCasa"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
                $select = $this->gsatelite->get_dropdown('srb_servicio_basico', '{srb_nombre}', '', array('srb_estado' => 1), null, '', 'srb_id', true);
                $data["slcServiciosBasicos"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
                $select = $this->gsatelite->get_dropdown('tcv_tipo_construccion_vivienda', '{tcv_nombre}', '', array('tcv_estado' => 1), null, '', 'tcv_id', true);
                $data["slcTipoConstruccion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
                $select = $this->gsatelite->get_dropdown('gen_genero', '{gen_nombre}', '', array('gen_estado' => 1), null, '', 'gen_id', true);
                $data["genero"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

                $select = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', array('dep_estado' => 1), null, '', 'dep_id', true);
                $data["slcDepartamento"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
                $select = $this->gsatelite->get_dropdown('pai_pais', '{pai_nacionalidad}', '', array('pai_estado' => 1), null, '', 'pai_id', true);
                $data["slcNacionalidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
                $select = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', array('mun_estado' => 1, 'mun_id_dep' => 0), null, '', 'mun_id', true);
                $data["slcMunicipio"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

                $select = $this->gsatelite->get_dropdown('tps_tipo_salario', '{tps_nombre}', '', array('tps_estado' => 1), null, '', 'tps_id', true);
                $data["slcTipoSalario"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
                $select = $this->gsatelite->get_dropdown('cta_categoria_aguinaldo', '{cta_nombre}', '', array('cta_estado' => 1), null, '', 'cta_id', true);
                $data["slcCatAguinaldo"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
                $select = $this->gsatelite->get_dropdown('fnr_fuente_reclutamiento', '{fnr_nombre}', '', array('fnr_estado' => 1), null, '', 'fnr_id', true);
                $data["slcFuenteReclutamiento"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
                
                $select = $this->gsatelite->get_dropdown('tpc_tipo_cuenta', '{tpc_nombre}', '', array('tpc_estado' => 1), null, '', 'tpc_id', true);
                $data["slcTipoCuenta"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

                //Tab insumos
                $select = $this->gsatelite->get_dropdown('tim_tipo_insumo', '{tim_nombre}', '', array('tim_estado' => 1), null, '', 'tim_id', true);
                $data["slcTipoInsumo"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

                //Tab capacitaciones
                $select = $this->gsatelite->get_dropdown('icp_institucion_capacitacion', '{icp_nombre}', '', array('icp_estado' => 1), null, '', 'icp_id', true);
                $data["slcInstitucionCapacitacion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

                $select = $this->gsatelite->get_dropdown('ese_estado_estudio', '{ese_nombre}', '', array('ese_estado' => 1), null, '', 'ese_id', true);
                $data["slcEstadoEstudio"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

                //Documentos                                    
                $select = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', array('mun_estado' => 1), null, '', 'mun_id', true);
                $data["slcMunicipioExp"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);            

                // Concursos
                $select = $this->gsatelite->get_dropdown('cnp_concurso_plaza', '{cnp_nombre}', '', array('cnp_estado' => 2), null, '', 'cnp_id', true);
                $data["concurso"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select); 
                
                // Tipo entrevista
                $select = $this->gsatelite->get_dropdown('tnv_tipo_entrevista', '{tnv_nombre}', '', array('tnv_estado' => 1), null, '', 'tnv_id', true);
                $data["slc_entrevista"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                // Tipo prueba
                $select = $this->gsatelite->get_dropdown('tib_tipo_prueba', '{tib_nombre}', '', array('tib_estado' => 1), null, '', 'tib_id', true);
                $data["slc_pruebas"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                //////////////// CODIGO DEL EMPLEADO //////////////////////////////////////
                $last=$this->consultas->get_max_codigo('sle_solicitante_empleo','sle_codigo');
                $code=$last->codigo;
                $cod= (float)$code+1;
                $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                $data['codigo'] = $codigo;

                //////////////// N° DE EXPEDIENTE  //////////////////////////////////////
                $last_e=$this->consultas->get_max_codigo('sle_solicitante_empleo','sle_expediente');
                $exped=$last_e->codigo;
                $exp= (float)$exped+1;
                $empediente = str_pad($exp, 4, '0', STR_PAD_LEFT);
                $data['expediente'] = $empediente;
                $this->_cargarvista($titulo, $data);
            }       
            
        }

     }

     /**
    *@author Nelson Soriano
    *@since  13-06-2019
    *@param  none
    *@return PDF ficha solicitante
    *
    **/

     public function ficha_solicitante($id_emp = null){
       satelite_validar();
          if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['empleado']   = $this->planilla_model->info_completa_solicitante($id_emp);
            $data['documentos'] = $this->planilla_model->documentos_solicitante($id_emp);
            $data['familiares'] = $this->planilla_model->familiares_solicitante($id_emp);
            $data['more_info']  = $this->planilla_model->get_solicitante_reporte(array('sle_id' => $id_emp));
            $data['foto']       = $this->personal_model->foto_solicitante($id_emp);
            //*******************************************************************************************************************

            $data['informacion'] = $this->gsatelite->get_tabla('sle_solicitante_empleo',array('sle_id'=>$id_emp));
            $getDatosempleado    = $data['informacion'];
            //--------------------------------------------------------------------------------------------------------------------------------
            //                                                      ALERGIAS
            //---------------------------------------------------------------------------------------------------------------------------------
            $alergico             = $this->gsatelite->get_tabla('cas_componente_alergico_solicitante', array('cas_estado' => 1, 'cas_id_sle' => $id_emp));
            $alerg_select         = $this->gsatelite->get_tabla('coa_componente_alergico', array('coa_estado' => 1));
            $ids_alergias         = array();
            $array_alergias       = array();
            foreach ($alergico as $key) {
                $ids_alergias[]   = $key["cas_id_coa"];
            }
            foreach ($alerg_select as $key) {
                if (in_array($key['coa_id'], $ids_alergias)) {
                    $array_alergias[] = $key['coa_nombre'];
                }
            }
            $label_alergias = implode(", ", $array_alergias);
            $data['alergico'] = $label_alergias;
            //----------------------------------------------- TERMINA ALERGIAS ----------------------------------------------------------------
            $data['tipo_sangre'] = $this->gsatelite->get_tabla('tsr_tipo_sangre', array('tsr_estado' => 1, 'tsr_id' => $getDatosempleado[0]['sle_id_tsr']));

            //--------------------------------------------------------------------------------------------------------------------------------
            //                                                      DISCAPACIDAD
            //---------------------------------------------------------------------------------------------------------------------------------

            //$data['discapacidad'] 
            $discapacidad = $getDatosempleado[0]['sle_discapacidad'] == 0 ? "No" : "Si";
            if ($discapacidad == "Si") {
                $tipo_discapacidad = $this->gsatelite->get_tabla('tds_tipo_discapacidad', array('tds_estado' => 1, 'tds_id' => $getDatosempleado[0]['sle_id_tds']));
                $discapacidad = $tipo_discapacidad[0]['tds_nombre'];
            }
            $data['discapacidad'] = $discapacidad;
            //--------------------------------------------------------------------------------------------------------------------------------
            //                                                       ENFERMEDADES
            //---------------------------------------------------------------------------------------------------------------------------------
            $enfermedad = $this->gsatelite->get_tabla('exs_enfermedaxsolicitante', array('exs_estado' => 1, 'exs_id_sle' => $id_emp));
            $enf_select = $this->gsatelite->get_tabla('enf_enfermedad', array('enf_estado' => 1));
            $id_enfermedades = array();
            $enfe = array();
            foreach ($enfermedad as $key) {
                $id_enfermedades[] = $key['exs_id_enf'];
            }
            foreach ($enf_select as $key) {
                if (in_array($key['enf_id'], $id_enfermedades)) {
                    $enfe[] = $key['enf_nombre'];
                }
            }
            //el array devuelto en el foreahc anterios devolveras todos los name d elas enfermedades y convertimos en 1 string para mostrar
            $labels_enfermedades = implode(", ", $enfe);
            $data['enfermedades'] = $labels_enfermedades;
            //---------------------------------------------- TERMINA ENFERMEDADES ---------------------------------------------------------------

            $data['contactar_a'] = $getDatosempleado[0]['sle_contacto_emergencia'];
            $data['direccion'] = $getDatosempleado[0]['sle_direccion_emergencia'];
            $data['telefono'] = $getDatosempleado[0]['sle_telefono_emergencia'];
            $parentesco = $this->gsatelite->get_tabla('pat_parentesco', array('pat_id' => $getDatosempleado[0]['sle_id_pat_contacto']));

            $data['parentesco'] = $parentesco[0]['pat_nombre'];
            //--------------------------------------------------------------------------------------------------------------------------------
            //                                                      DATOS ACADEMICOS
            //---------------------------------------------------------------------------------------------------------------------------------
            $datos_academicos = $this->gsatelite->get_tabla('das_dato_academico_solicitante', array('das_estado' => 1, 'das_id_sle' => $id_emp));
            //Arrays donde se agregara toda la data segun el empleado actual
            $tipo_educacion = array();
            $profesion = array();
            $institucion = array();
            $estado = array();
            $anios = array();
            $fecha_finaliza = array();
            $observaciones_aca = array();
            $pais = array();
            $experiencia_pro = array();
            foreach ($datos_academicos as $key) {
                $label_tipo_educacion = $this->gsatelite->get_tabla('tie_tipo_educacion', array('tie_id' => $key['das_id_tie'], 'tie_estado' => 1));
                $tipo_educacion[] = $label_tipo_educacion[0]['tie_nombre'];

                $label_profesion = $this->gsatelite->get_tabla('pro_profesion', array('pro_id' => $key['das_id_pro'], 'pro_estado' => 1));
                $profesion[] = $label_profesion[0]['pro_nombre'];

                $label_institucion = $this->gsatelite->get_tabla('ina_institucion_academica', array('ina_id' => $key['das_id_ina'], 'ina_estado' => 1));
                $institucion[] = $label_institucion[0]['ina_nombre'];

                $label_estado = $this->gsatelite->get_tabla('ese_estado_estudio', array('ese_id' => $key['das_id_ese'], 'ese_estado' => 1));
                $estado[] = $label_estado[0]['ese_nombre'];

                $anios[] = $key['das_anios_cursado'];

                $fecha_finaliza[] = $key['das_fecha_finalizacion'];

                $observaciones_aca[] = $key['das_observacion'];

                $label_pais = $this->gsatelite->get_tabla('pai_pais', array('pai_id' => $key['das_id_pai'], 'pai_estado' => 1));
                $pais[] = $label_pais[0]['pai_nombre'];

                $label_experiencia = $this->gsatelite->get_tabla('exl_experiencia_laboral', array('exl_id' => $key['das_id_exl'], 'exl_estado' => 1));
                $experiencia_pro[] = $label_experiencia[0]['exl_nombre'];
            }
            $data['tipo_edu'] = $tipo_educacion;
            $data['profe'] = $profesion;
            $data['insti'] = $institucion;
            $data['esta'] = $estado;
            $data['anios'] = $anios;
            $data['fech_da'] = $fecha_finaliza;
            $data['obser_da'] = $observaciones_aca;
            $data['pais'] = $pais;
            $data['expe'] = $experiencia_pro; 

            $data['datos_academicos'] = $datos_academicos;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                          PROGRAMAS Y EQUIPOS
            //---------------------------------------------------------------------------------------------------------------------------------
            $tipo_programas = array();
            $nivel_pq = array();
            $programas = $this->gsatelite->get_tabla('pxs_programaxsolicitante', array('pxs_estado' => 1, 'pxs_id_sle' => $id_emp));
            foreach ($programas as $key) {
                $label_tipo_pro = $this->gsatelite->get_tabla('peq_programa_equipo', array('peq_estado' => 1, 'peq_id' => $key['pxs_id_peq']));
                $tipo_programas[] = $label_tipo_pro[0]['peq_nombre'];

                $label_nivel = $this->gsatelite->get_tabla('nie_nivel_experiencia', array('nie_estado' => 1, 'nie_id' => $key['pxs_id_nie']));
                $nivel_pq[] = $label_nivel[0]['nie_nombre']; 
            }
            $data['tipo_pq'] = $tipo_programas;
            $data['nivel_pq'] = $nivel_pq;

            $data['programas_equi'] = $programas;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                  CERTIFICACIONES
            //---------------------------------------------------------------------------------------------------------------------------------
            $tipo_programas_cer = array();
            $certificacion = array();
            $impartido_por = array();
            $modalidad = array();
            $puntaje = array();
            $fecha_certi = array();

            $certificaciones = $this->gsatelite->get_tabla('cps_certificacion_programa_solicitante', array('cps_estado' => 1, 'cps_id_sle' => $id_emp));
            foreach ($certificaciones as $key) {
                $label_tipo_pro = $this->gsatelite->get_tabla('peq_programa_equipo', array('peq_estado' => 1, 'peq_id' => $key['cps_id_peq']));
                $tipo_programas_cer[] = $label_tipo_pro[0]['peq_nombre'];

                $label_certificacion = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_id' => $key['cps_id_cer']));
                $certificacion[] = $label_certificacion[0]['cer_nombre'];

                $label_impar_por = $this->gsatelite->get_tabla('icp_institucion_capacitacion', array('icp_estado' => 1, 'icp_id' => $key['cps_id_icp']));
                $impartido_por[] = $label_impar_por[0]['icp_nombre'];

                $label_modalidad = $this->gsatelite->get_tabla('mde_modalidad_estudio', array('mde_estado' => 1, 'mde_id' => $key['cps_id_mde']));
                $modalidad[] = $label_modalidad[0]['mde_nombre'];

                $puntaje[] = $key['cps_puntaje'];
                $fecha_certi[] = $key['cps_fecha_certificacion'];
            }
            $data['tipo_cer'] = $tipo_programas_cer;
            $data['certi'] = $certificacion;
            $data['impart'] = $impartido_por;
            $data['modali'] = $modalidad;
            $data['puntaje'] = $puntaje;
            $data['fech_cert'] = $fecha_certi;

            $data['certificaciones'] = $certificaciones;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                  REF LABORALES
            //---------------------------------------------------------------------------------------------------------------------------------
            $empresa = array();
            $direccion_ref = array();
            $telefono_ref = array();
            $puesto = array();
            $nombrE_ref = array();
            $jefe_ref = array();
            $salario_ref = array();
            $motivo_retiro = array();
            $desde_ref = array();
            $hasta_ref = array();
            $referencia_ref = array();

            $referencias = $this->gsatelite->get_tabla('rls_referencia_laboral_solicitante', array('rls_estado' => 1, 'rls_id_sle' => $id_emp));
            $data['referencias'] = $referencias;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                      IDIOMAS
            //---------------------------------------------------------------------------------------------------------------------------------
            $idioma = array();
            $nivel =  array();
            $leer = array();
            $escribir = array();
            $hablar = array();
            $traductor = array();

            $idiomas = $this->gsatelite->get_tabla('ids_idioma_solicitante', array('ids_estado' => 1, 'ids_id_sle' => $id_emp));
            foreach ($idiomas as $key) {
                $label_idioma = $this->gsatelite->get_tabla('idm_idioma', array('idm_estado' => 1, 'idm_id' => $key['ids_id_idm']));
                $idioma[] = $label_idioma[0]['idm_nombre'];

                $label_nivel_i = $this->gsatelite->get_tabla('nii_nivel_idioma', array('nii_estado' => 1, 'nii_id' => $key['iem_id_nii']));
                $nivel[] = $label_nivel_i[0]['nii_nombre'];

                $leer[] = $key['ids_leer'] == 1 ? "SI": "NO";
                $escribir[] = $key['ids_escribir'] == 1 ? "SI": "NO";
                $hablar[] = $key['ids_hablar'] == 1 ? "SI": "NO";
                $traductor[] = $key['ids_traductor'] == 1 ? "SI": "NO";
            }
            $data['idioma'] = $idioma;
            $data['nivel'] = $nivel;
            $data['leer'] = $leer;
            $data['escribir'] = $escribir;
            $data['hablar'] = $hablar;
            $data['traductor'] = $traductor;
            $data['idiomas'] = $idiomas;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                      CERTIFICACIONES INGLES
            //---------------------------------------------------------------------------------------------------------------------------------
            $c_idiomas = $this->gsatelite->get_tabla('cis_certificacion_idioma', array('cis_estado' => 1, 'cis_id_sle' => $id_emp));

            $c_idioma = array();
            $certi_c = array();
            $puntaje_c = array();
            $fecha_cer = array();
            foreach ($c_idiomas as $key) {
                $label_cidioma = $this->gsatelite->get_tabla('idm_idioma', array('idm_estado' => 1, 'idm_id' => $key['cis_id_idm']));
                $c_idioma[] = $label_cidioma[0]['idm_nombre'];

                $label_ccerti = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_id' => $key['cri_id_cer']));
                $certi_c[] = $label_ccerti[0]['cer_nombre'];

                $puntaje_c[] = $key['cri_puntaje'];
                $fecha_cer[] = $key['cri_fecha_certificacion'];
            }
            $data['c_idioma'] = $c_idioma;
            $data['certi_c'] = $certi_c;
            $data['puntaje_c'] = $puntaje_c;
            $data['fecha_c'] = $fecha_cer;
            $data['c_idiomas'] = $c_idiomas;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                      REFS PERSONALES
            //---------------------------------------------------------------------------------------------------------------------------------
            $ref_personal = $this->gsatelite->get_tabla('rps_referencia_personal_solicitante', array('rps_estado' => 1, 'rps_id_sle' => $id_emp));

            $ref_tipo = array();
            $ref_nombre = array();
            $ref_lugar = array();
            $ref_ocupacion = array();
            $ref_telefono = array();
            $ref_referencia = array();

            foreach ($ref_personal as $key) {
                $label_ref_tipo = $this->gsatelite->get_tabla('trr_tipo_referencia', array('trr_estado' => 1, 'trr_id' => $key['rps_id_trr']));
                $ref_tipo[] = $label_ref_tipo[0]['trr_nombre'];

                $ref_nombre[]     = $key['rps_nombre'];
                $ref_lugar[]      = $key['rps_lugar_trabajo'];
                $ref_ocupacion[]  = $key['rps_ocupacion'];
                $ref_telefono[]   = $key['rps_telefono'];
                $ref_referencia[] = $key['rps_descripcion_referencia'];
            }
            $data['ref_tipo'] = $ref_tipo;
            $data['ref_nombre'] = $ref_nombre;
            $data['ref_lugar'] = $ref_lugar;
            $data['ref_ocupacion'] = $ref_ocupacion;
            $data['ref_telefono'] = $ref_telefono;
            $data['ref_referencia'] = $ref_referencia;
            $data['ref_personal'] =  $ref_personal;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                      DATOS VIVIENDA
            //---------------------------------------------------------------------------------------------------------------------------------
            $zona = $this->gsatelite->get_tabla('zon_zona', array('zon_id' => $getDatosempleado[0]['sle_id_zon']));
            $data['zona_residencia'] = $zona[0]['zon_nombre'];

            $nameTipoCasa = $this->gsatelite->get_tabla('tiv_tipo_vivienda', array('tiv_id' => $getDatosempleado[0]['sle_id_tiv']));
            $data['tipo_casa'] = $nameTipoCasa[0]['tiv_nombre'];

            $nameConstruccion = $this->gsatelite->get_tabla('tcv_tipo_construccion_vivienda', array('tcv_id' => $getDatosempleado[0]['sle_id_tcv']));
            $data['tipo_construccion'] = $nameConstruccion[0]['tcv_nombre'];

            $sre = $this->gsatelite->get_tabla('srs_servicio_solicitante', array('srs_estado' => 1, 'srs_id_sle' => $id_emp));
            $servicios = array();
            foreach ($sre as $key) {
                $label_serv = $this->gsatelite->get_tabla('srb_servicio_basico', array('srb_estado' => 1, 'srb_id' => $key['srs_id_srb']));
                $servicios[] = $label_serv[0]['srb_nombre'];
            }
            $data['servicios'] = implode(', ', $servicios);
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                   HABILIDADES EMPLEADO
            //---------------------------------------------------------------------------------------------------------------------------------
            $habilidades_emp = $this->gsatelite->get_tabla('hxs_habilidadxsolicitante', array('hxs_id_sle' => $id_emp));
            $habilidad = array();
            $nivel_hab = array();

            foreach ($habilidades_emp as $key) {
                $label_hab = $this->gsatelite->get_tabla('hab_habilidad', array('hab_estado' => 1, 'hab_id' => $key['hxs_id_hab']));
                $habilidad[] = $label_hab[0]['hab_nombre'];

                $label_nivelhab = $this->gsatelite->get_tabla('nih_nivel_habilidad', array('nih_estado' => 1, 'nih_id' => $key['hxs_id_nih']));
                $nivel_hab[] = $label_nivelhab[0]['nih_nombre'];
            }
            $data['habilidad'] = $habilidad;
            $data['nivel_hab'] = $nivel_hab;
            $data['habilidad_emp'] = $habilidades_emp;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                   AGRUPACIONES EMPLEADO
            //---------------------------------------------------------------------------------------------------------------------------------
            $agrupaciones_emp = $this->gsatelite->get_tabla('ags_agrupacion_solicitante', array('ags_estado' => 1, 'ags_id_sle' => $id_emp));
            $data['agrupaciones'] = $agrupaciones_emp;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                   INSUMOS EMPLEADO
            //---------------------------------------------------------------------------------------------------------------------------------
            $insumos = $this->gsatelite->get_tabla('ise_isumo_solicitante_empleo', array('ise_id_sle' => $id_emp));
            $tipo_ins = array();
            $insumo = array();
            $cantidad_ins = array();
            $costo = array();
            $fecha_ins = array();
            foreach ($insumos as $key) {
                $id_inm = $this->gsatelite->get_tabla('inm_insumo', array('inm_estado' => 1, 'inm_id' => $key['ise_id_inm']));
                $label_tipoins = $this->gsatelite->get_tabla('tim_tipo_insumo', array('tim_estado' => 1, 'tim_id' => $id_inm[0]['inm_id_tim']));
                $tipo_ins[] = $label_tipoins[0]['tim_nombre'];

                $label_insumo = $this->gsatelite->get_tabla('inm_insumo', array('inm_estado' => 1, 'inm_id' => $key['ise_id_inm']));
                $insumo[] = $id_inm[0]['inm_nombre'];

                $cantidad_ins[] = explode(".", $key['ise_cantidad'])[0];
                $costo[] = $key['ise_costo'];
                $fecha_ins[] = explode(" ", $key['ise_fecha_entrega'])[0];
            }
            $data['tipo_insumo'] = $tipo_ins;
            $data['insumo'] = $insumo;
            $data['cantidad_insumo'] = $cantidad_ins;
            $data['costo_insumo'] = $costo;
            $data['fecha_insumo'] = $fecha_ins;
            $data['insumos'] = $insumos;
            //-----------------------------------------------------------------------------------------------------------------------------
            //                                                   CAPACITACIONES
            //-----------------------------------------------------------------------------------------------------------------------------
            $capacitaciones = $this->gsatelite->get_tabla('ccs_capacitacion_solicitante', array('ccs_id_sle' => $id_emp));
            $nombre_cp = array();
            $institucion_cp = array();
            $fecha_inicio_cp = array();
            $fecha_fin_cp = array();
            $horas_cp = array();
            $costo_emp_cp = array();
            $costo_ins_cp = array();
            $costo_pro_cp = array();
            $estado_cp = array();
            foreach ($capacitaciones as $key) {
                $nombre_cp[] = $key['cpe_nombre'];

                $label_nombre = $this->gsatelite->get_tabla('icp_institucion_capacitacion', array('icp_id' => $key['ccs_id_icp']));
                $institucion_cp[] = $label_nombre[0]['icp_nombre'];

                $fecha_inicio_cp[] = explode(" ", $key['ccs_fecha_inicio'])[0];

                $fecha_fin_cp[] = explode(" ", $key['ccs_fecha_fin'])[0];

                $horas_cp[] = $key['ccs_duracion'];

                $costo_emp_cp[] = $key['ccs_costo_empresa'];

                $costo_ins_cp[] = $key['cpe_costo_insaforp'];

                $costo_pro_cp[] = $key['ccs_costo_proveedor'];

                $label_estado = $this->gsatelite->get_tabla('ese_estado_estudio', array('ese_id' => $key['ccs_id_ese']));
                $estado_cp[] = $label_estado[0]['ese_nombre'];
            }
            $data['nombre_cp'] = $nombre_cp;
            $data['institucion_cp'] = $institucion_cp;
            $data['fecha_inicio_cp'] = $fecha_inicio_cp;
            $data['fecha_fin_cp'] = $fecha_fin_cp;
            $data['horas_cp'] = $horas_cp;
            $data['costo_emp_cp'] = $costo_emp_cp;
            $data['costo_ins_cp'] = $costo_ins_cp;
            $data['costo_pro_cp'] = $costo_pro_cp;
            $data['estado_cp'] = $estado_cp;
            $data['capacitaciones'] = $capacitaciones;
            //---------------------------------------------- TERMINA CAPACITACIONES -------------------------------------------------------
            /*$anexos = $this->gsatelite->get_tabla('ans_anexo_solicitante', array('ans_id_sle' => $id_emp));
            $name_anx = array();
            $img_type = array();
            foreach ($anexos as $key) {
                //$data_anx = $this->gsatelite->get_tabla('ans_anexo', array('ans_id' => $key['axe_id_anx']));
                $name_anx[] = $key['ans_nombre'];

                $type = strtolower(trim(end(explode('.', $key['ans_url']))));
                if ($type == "pdf") {
                    $img_type[] = "media/imagenes/sistema/pdf.png";
                } else if($type == "jpg") {
                    $img_type[] = "media/imagenes/sistema/jpg.png";
                }  else if($type == "jpeg") {
                    $img_type[] = "media/imagenes/sistema/jpeg.png";
                }  else if($type == "png") {
                    $img_type[] = "media/imagenes/sistema/png.png";
                }  else if($type == "doc") {
                    $img_type[] = "media/imagenes/sistema/doc.png";
                }  else if($type == "docx") {
                    $img_type[] = "media/imagenes/sistema/docx.png";
                }  else if($type == "xls") {
                    $img_type[] = "media/imagenes/sistema/xls.png";
                }  else if($type == "xlsx") {
                    $img_type[] = "media/imagenes/sistema/xlsx.png";
                }  else if($type == "txt") {
                    $img_type[] = "media/imagenes/sistema/txt.png";
                }  else if($type == "rar") {
                    $img_type[] = "media/imagenes/sistema/rar.png";
                }  else  {
                    $img_type[] = "media/imagenes/sistema/noposee.jpeg";
                }                        
            }
            $data['nombre_anexo'] = $name_anx;
            $data['url_anexo'] = $img_type;
            $data['anexos'] = $anexos;*/
             $anexos = $this->gsatelite->get_tabla('ans_anexo_solicitante', array('ans_id_sle' => $id_emp,'ans_estado ' => 1));
            $list_anx = array();
            $i = 0;
            foreach ($anexos as $key) {
                //$data_anx = $this->gsatelite->get_tabla('ans_anexo', array('anx_id' => $key['axe_id_anx']));
                $type = strtolower(trim(end(explode('.', $key['ans_url']))));
                $list_anx[$i]['name'] = $key['ans_nombre'];
                $list_anx[$i]['link'] = $key['ans_url'];
                $list_anx[$i]['type'] = $type;
                $list_anx[$i]['icon'] = "media/imagenes/sistema/" . $key['ans_url'] . ".png";                  
                $i++;
            }
            //$data['anexos'] = $anexos;
            $data['lista_anexos'] = $list_anx;

            //////////////////////////////////////////////// ENTREVISTA ////////////////////////////////////////////////////////////////////////
            $this->db->join('tnv_tipo_entrevista', 'ens_id_tnv = tnv_id',"left");
            $data["entrevista_solicitante"] = $this->gsatelite->get_tabla('ens_entrevista_solicitante_empleo', array('ens_id_sle'=>$id_emp));

            //////////////////////////////////////////////// PRUEBAS //////////////////////////////////////////////////////////////////////////
            $this->db->join('tib_tipo_prueba', 'pse_id_tib = tib_id',"left");
            $data["prueba_solicitante"] = $this->gsatelite->get_tabla('pse_pruebas_solicitante_empleo', array('pse_id_sle'=>$id_emp));

            //*****************************************************************
            $html = $this->load->view('reporte/header', array('titulo' => 'Ficha de solicitante'), true);
            $html .= $this->load->view('modulo_seleccion_personal/slp_procesos/ficha_solicitante', $data, true);
            $this->load->library('pdf');
            $this->pdf->reporteNombrePDF($html, explode(' ', trim($getDatosempleado[0]['sle_nombre']))[0].$getDatosempleado[0]['sle_codigo'], 'D', 1);
        }
     }

    /**
    *@author Nelson Soriano
    *@since  21-06-2019
    *@param  POST con la informacion a actuaizar
    *@return Confirmacion de la transaccion
    *
    **/

    public function solicitante_editar(){
         //ini_set('max_input_vars', '300000');  
       if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else { 
            
            $emp_id = $this->input->post('id');
            $cod_post = trim($this->input->post('codigo_emp'));
            $reg_cod = $this->gsatelite->get_registro('sle_solicitante_empleo', array('sle_codigo'=>$cod_post, 'sle_id <>'=>$emp_id));
            if(count($reg_cod)>0){
                $last=$this->consultas->get_max_codigo('sle_solicitante_empleo','sle_codigo');
                $code=$last->codigo;
                $cod= (float)$code+1;
                $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
            }else{
                $codigo = $cod_post;
            }

            
            //print_r($_POST); die();
            /*
            if ($this->input->post("fecha_prox_vac")!='') {//Fecha insertada menos 365 dias
                $actual   =  strtotime($this->input->post("fecha_prox_vac"));
                $anterior =  strtotime('-365 day', $actual);
                $fecha_anterior =  date('d-m-Y', $anterior);
            }
            */
            $editar = array(
                'sle_id_suc' => ($this->input->post('sucursal') > 0) ? $this->input->post('sucursal') : null,
                'sle_id_plz' => ($this->input->post('puesto') > 0) ? $this->input->post('puesto') : null,
                'sle_id_afp' => ($this->input->post('afp') > 0) ? $this->input->post('afp') : null,
                'sle_id_are' => ($this->input->post('departamento') > 0) ? $this->input->post('departamento') : null,
                'sle_nombre' => $this->input->post('nombres'),
                'sle_apellido' => $this->input->post('apellidos'),
                //'emp_estado' => 1, //$this->input->post('estado'),//siempre en uno porque la acción de desactivar es independiente no en el editar
                'sle_direccion' => $this->input->post('direccion'),
                'sle_lugar_nac' => $this->input->post('lugar_nacimiento'),
               // 'emp_id_pai' => ($this->input->post('slcNacionalidad') > 0) ? $this->input->post('slcNacionalidad') : null,
                'sle_fecha_nac' => date('Y-m-d', strtotime($this->input->post('fecha_nacimiento'))),
                'sle_id_gen' => ($this->input->post('genero') != "") ? $this->input->post('genero') : null,
                //'sle_id_cnt' => ($this->input->post('slcCuentaCont') > 0) ? $this->input->post('slcCuentaCont') : null,
                'sle_id_pro' => ($this->input->post('profesion') != "") ? $this->input->post('profesion') : null,
                'sle_id_esc' => ($this->input->post('estado_civil') != "") ? $this->input->post('estado_civil') : null,
                'sle_fecha_contrato' => date('Y-m-d', strtotime($this->input->post('fecha_contratacion'))),
                'sle_salario' => ($this->input->post('salario') != "") ? $this->input->post('salario') : 0,
                'sle_salario_hora' => ($this->input->post('salario_hora') != "") ? $this->input->post('salario_hora') : null,
                'sle_salario_hora_nocturna' => ($this->input->post('salario_hora_noc') != "") ? $this->input->post('salario_hora_noc') : null,
                'sle_usu_modificacion' => $this->tank_auth->get_user_id(),
                'sle_fecha_modificacion' => date('Y-m-d H:i:s'),
                'sle_codigo' => $codigo,
                'sle_afp' => $this->input->post('num_afp'),
                'sle_fecha_retiro' => (trim($this->input->post('fecha_retiro')) != "") ? date('Y-m-d', strtotime($this->input->post('fecha_retiro'))) : null,
                'sle_seguro' => $this->input->post('num_seg'),
                'sle_id_ban' => ($this->input->post('banco') != "") ? $this->input->post('banco') : null,
                'sle_numero_cuenta' => $this->input->post('cuenta_banco'),
                'sle_observacion_contrato' => trim($this->input->post('observacion_contratacion')),
                'sle_id_tic' => ($this->input->post('tipo_contrato_empleado') != "") ? $this->input->post('tipo_contrato_empleado') : null,
                'sle_metodo_pago' => ($this->input->post('forma_pago_salario') != "") ? $this->input->post('forma_pago_salario') : null,
                //'emp_color_icono' => strtoupper($this->input->post('color_emp')),
                'sle_id_pat_contacto' => ($this->input->post("contact_parentesco") != "") ? $this->input->post("contact_parentesco") : null, //id_parentesco
                'sle_estatura' => ($this->input->post("enf_estatura") != "") ? $this->input->post("enf_estatura") : null,
                'sle_peso' => ($this->input->post("enf_peso") != "") ? $this->input->post("enf_peso") : null,
                //'emp_tipo_sangre' => $this->input->post("enf_sangre"),
                'sle_id_tsr' => ($this->input->post("slcTipoSangre") > 0)? $this->input->post("slcTipoSangre"):null,
                'sle_discapacidad' => $this->input->post("enf_discapacidad"),
                'sle_id_tds' => ($this->input->post("enf_discapacidad") == 1 && $this->input->post("slcTipoDiscapacidad") > 0 )? $this->input->post("slcTipoDiscapacidad"):null,
                'sle_observacion_clinica' => $this->input->post("enf_observacion"),
                'sle_contacto_emergencia' => $this->input->post("contact_a"),
                'sle_direccion_emergencia' => $this->input->post("contact_direccion"),
                'sle_telefono_emergencia' => $this->input->post("contact_telefono"),
                'sle_id_zon' => ($this->input->post("slcZona") > 0)? $this->input->post("slcZona"):null,
                'sle_id_tiv' => ($this->input->post("slcTipoCasa") > 0)? $this->input->post("slcTipoCasa"):null,
                'sle_id_tcv' => ($this->input->post("slcTipoConstruccion") > 0)? $this->input->post("slcTipoConstruccion"):null,
                'sle_expediente' => (trim($this->input->post("expediente_emp")) !='')? trim($this->input->post("expediente_emp")):null,
                'sle_id_mun' => ($this->input->post("slcMunicipio") > 0)? $this->input->post("slcMunicipio"):null,
                'sle_id_pai' => ($this->input->post("slcNacionalidad") > 0)? $this->input->post("slcNacionalidad"):null,
                'sle_es_reingreso' => ($this->input->post("ckcReingreso") > 0)? 1:0,
                'sle_es_jubilado' => ($this->input->post("ckcJubilado") > 0)? 1:0,
                'sle_fecha_jubilado' => ($this->input->post("txtFechaJubilacion") !='' )? formatear_fecha('Y-m-d', $this->input->post('txtFechaJubilacion')):null,
                'sle_id_tps' => ($this->input->post("slcTipoSalario") > 0)? $this->input->post("slcTipoSalario"):null,
                'sle_id_cta' => ($this->input->post("slcCatAguinaldo") > 0)? $this->input->post("slcCatAguinaldo"):null,
                'sle_id_fnr' => ($this->input->post("slcFuenteReclutamiento") > 0)? $this->input->post("slcFuenteReclutamiento"):null,
                'sle_realizo_poligrafo' => ($this->input->post("ckcRealizaPoligrafo") > 0)? 1:0,
                'sle_codigo_referencia' => (trim($this->input->post("codigo_referencia")) !='')? trim($this->input->post("codigo_referencia")):null,
                'sle_id_tpc' => ($this->input->post("slcTipoCuenta") > 0)? $this->input->post("slcTipoCuenta"):null,
                'sle_aplica_afp' => ($this->input->post("ckcAplicaAfp") > 0)? 1:0,
                'sle_aplica_isss' => ($this->input->post("ckcAplicaIsss") > 0)? 1:0,
                'sle_fecha_ult_liquidacion' => ($this->input->post("fecha_ult_liquidacion") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_ult_liquidacion')):null,
                'sle_fecha_fin_contrato' => ($this->input->post("fecha_fin_contrato") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_fin_contrato')):null,
                'sle_fecha_antiguedad' => ($this->input->post("fecha_antiguedad") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_antiguedad')):null,
                'sle_fecha_ult_aguinaldo' => ($this->input->post("fecha_ult_aguinaldo") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_ult_aguinaldo')):null,
                'sle_fecha_ult_vacacion'=> ($this->input->post("fecha_prox_vac") !='' )? formatear_fecha('Y-m-d', $fecha_anterior):null

            );

            $this->db->where('sle_id', $emp_id)
                    ->update('sle_solicitante_empleo', $editar);

            /************Ingresar en la tabla promocion_plaza_salarioxemp*********************/
            //Esta edicion solo esta permitida si el empleado solo posee un registro en pps_promocion_plaza_salarioxemp por tal motivo al editar solo se usa
            //el id del empleado para actualizar el registro en dicha tabla, si tienen mas de 2 registros ya no podra actualizarse desde aca
            
            /*
            $num_promos = count($this->gsatelite->get_tabla('pps_promocion_plaza_salarioxemp', array('pps_id_emp' => $emp_id)));
            if($num_promos <= 1 ){
                if($this->input->post('puesto') > 0){            
                    $this->gsatelite->actualizar_array('pps_promocion_plaza_salarioxemp', array('pps_id_plz' => $this->input->post('puesto'),
                                'pps_id_emp' => $emp_id,
                                'pps_tipo' => 0,
                                'pps_salario' => ($this->input->post('salario') != "") ? $this->input->post('salario') : 0,
                                'pps_fecha_efectiva' => formatear_fecha('Y-m-d', $this->input->post('fecha_contratacion')),
                                'pps_fecha_desde' => formatear_fecha('Y-m-d', $this->input->post('fecha_contratacion')),                        
                                'pps_fecha_hasta' => null,                        
                                'pps_estado' => 1,
                                'pps_usu_creacion' => $this->tank_auth->get_user_id(),
                                'pps_fecha_creacion' => date('Y-m-d H:i:s'),
                                'pps_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'pps_fecha_modificacion' => date('Y-m-d H:i:s')
                            ), array('pps_id_emp' => $emp_id));
                }
            } elseif ($num_promos == 0) { //si no existe insertarlo.
                $this->db->insert('pps_promocion_plaza_salarioxemp', array('pps_id_plz' => $this->input->post('puesto'),
                            'pps_id_emp' => $emp_id,
                            'pps_id_emr' => $this->tank_auth->get_empresa_id(),
                            'pps_tipo' => 0,
                            'pps_salario' => ($this->input->post('salario') != "") ? $this->input->post('salario') : 0,
                            'pps_fecha_efectiva' => formatear_fecha('Y-m-d', $this->input->post('fecha_contratacion')),
                            'pps_fecha_desde' => formatear_fecha('Y-m-d', $this->input->post('fecha_contratacion')),                        
                            'pps_fecha_hasta' => null,                        
                            'pps_estado' => 1,
                            'pps_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pps_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pps_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pps_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
            }
            */
            /*****************************************************/
/*
            $this->db->where('txe_id_emp', $emp_id)
                    ->delete('txe_tipo_planillaxempleado');

            $tpl = $this->input->post('tipo_contrato');
            for ($i = 0; $i < count($tpl); $i++) {
                if ($tpl[$i] != null) {
                    $this->db->insert('txe_tipo_planillaxempleado', array('txe_id_tpl' => $tpl[$i], 'txe_id_emp' => $emp_id));
                }
            }
            //ACTUALIZAR LOS TIPOS DE SEGURO DEL EMPLEADO
            //preguntar por los existentes
            $consul = $this->gsatelite->get_tabla('sxe_seguroxempleado', array('sxe_id_emp' => $emp_id));
            $seleccionados_activos = array();
            foreach ($consul as $f) {
                $seleccionados_activos[] = $f['sxe_id_seg'];
            }

            $tseg = $this->input->post('tipo_seguro');
            for ($i = 0; $i < count($tseg); $i++) {
                if ($tseg[$i] > 0) {
                    if (!in_array($tseg[$i], $seleccionados_activos)) { //preguntar si se ha elegido uno nuevo
                        $this->db->insert('sxe_seguroxempleado', array('sxe_id_seg' => $tseg[$i],
                            'sxe_id_emp' => $emp_id,
                            'sxe_estado' => 1,
                            'sxe_usu_mod' => $this->tank_auth->get_user_id(),
                            'sxe_fecha_mod' => date('Y-m-d H:i:s')
                        ));
                    } else {// si existe unicamente actualizar los campos de auditoria
                        $cadena = array(
                            'sxe_estado' => 1,
                            'sxe_usu_mod' => $this->tank_auth->get_user_id(),
                            'sxe_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('sxe_seguroxempleado', $cadena, array('sxe_id_seg' => $tseg[$i], 'sxe_id_emp' => $emp_id));
                    }
                }
            }
            */


//AHORA RECORRER LOS EXISTENTES Y PREGUNTAR CUAL NO SE HA ELEGIDO
            /*for ($i = 0; $i < count($seleccionados_activos); $i++) {
                if (!in_array($seleccionados_activos[$i], $tseg)) {
                    $cadena = array(
                        'sxe_estado' => 0
                        , 'sxe_usu_mod' => $this->tank_auth->get_user_id()
                        , 'sxe_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('sxe_seguroxempleado', $cadena, array('sxe_id_seg' => $seleccionados_activos[$i], 'sxe_id_emp' => $emp_id));
                }
            }*/
/////////////////FIN ACTUALIZACIÓN DE TIPOS DE SEGURO
///INICIO ACTUALIZACION DE LOS CORREOS DEL EMPLEADO
            $this->db->where('cse_id_sle', $emp_id)
                    ->delete('cse_correo_solicitante_empleo');

            $correos = $this->input->post('correo_empleado');
            for ($i = 0; $i < count($correos); $i++) {
                if ($correos[$i] != null and trim($correos[$i]) != '') {
                    $this->db->insert('cse_correo_solicitante_empleo', array(
                        'cse_id_sle' => $emp_id,
                        'cse_correo' => $correos[$i],
                        'cse_estado' => 1,
                        'cse_fecha_creacion'     => date('Y-m-d H:i:s'),
                        'cse_usu_creacion'       => $this->tank_auth->get_user_id(),
                        'cse_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'cse_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
            }

//FIN DE LA ACTUALIZACION DE LOS CORREOS DEL EMPLEADO
////////Inicio de modificacion de telefonos
            //obtenemos los ids de la relacion del empleado con los telefonos
            $telefonos_empleado = $this->gsatelite->get_tabla('tsl_telefono_solicitante',array('tsl_id_sle' => $emp_id));
            $telefonos_seleccionados_ids = array();
            //guardamos los id de los telefonos que el usuario tiene actualmente
            foreach ($telefonos_empleado as $tel_emp) {
                $telefonos_seleccionados_ids[] = $tel_emp['tsl_id'];
            }

            //toma de datos del formulario
            $array_ids_telefono = $this->input->post('ids_telefono_empleado');
            $array              = $this->input->post('numeros_telefons'); //numeros de telefonos
            $array_tit          = $this->input->post('tipos_telefons');

            //verificamos si en el array de los telefonos del usuario coinciden con los del formulario
            for ($x = 0; $x < count($array); $x++) {
                if (trim($array[$x]) != "" && trim($array_tit[$x]) != "") {
                    //si no existe el id en el array se inserta
                    if (!in_array($array_ids_telefono[$x], $telefonos_seleccionados_ids)) {
                        $this->db->insert('tsl_telefono_solicitante', array(
                            'tsl_id_sle' => $emp_id,
                            'tsl_id_tit' => $array_tit[$x],
                            'tsl_numero' => $array[$x],
                            'tsl_estado' => 1,
                            'tsl_usu_creacion' => $this->tank_auth->get_user_id(),
                            'tsl_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'tsl_fecha_creacion' => date('Y-m-d H:i:s'),
                            'tsl_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena_tel = array(
                            'tsl_numero' => $array[$x],
                            'tsl_id_tit' => $array_tit[$x],
                            'tsl_estado' => 1,
                            'tsl_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'tsl_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('tsl_telefono_solicitante', $cadena_tel, array('tsl_id' => $array_ids_telefono[$x]));
                    }
                }
            }
            //Si el id se a eliminado del formulario entonces el estado pasa a 0
            for ($z = 0; $z < count($telefonos_seleccionados_ids); $z++) {
                if (!in_array($telefonos_seleccionados_ids[$z], $array_ids_telefono)) {
                    $cadena = array(
                        'tsl_estado' => 0,
                        'tsl_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'tsl_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('tsl_telefono_solicitante', $cadena, array('tsl_id' => $telefonos_seleccionados_ids[$z]));
                }
            }
            /* ====================================================================================================================
              =                             ACTUALIZAR ENFERMEDAD
              ======================================================================================================================
             */
            $enfermedad = $this->gsatelite->get_tabla('exs_enfermedaxsolicitante', array('exs_estado' => 1, 'exs_id_sle' => $emp_id));
            $exe_enf_ids = array();
            $enf_ids = array();
            foreach ($enfermedad as $key) {
                $exe_enf_ids[] = $key["exs_id"];
                $enf_ids[] = $key["exs_id_enf"];
            }
            $exe_id_enf = $this->input->post("exe_id_enf");
            $enf_tipo = $this->input->post("enf_tipo"); //id_enf_enfermedad

            $exe_id = 0;
            foreach ($enf_tipo as $key) {
                if (trim($key) != "") {
                    if (!in_array($key, $enf_ids)) {
                        $this->db->insert('exs_enfermedaxsolicitante', array(
                            'exs_id_enf' => $key,
                            'exs_id_sle' => $emp_id,
                            'exs_estado' => 1,
                            'exs_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'exs_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'exs_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'exs_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena_enf = array(
                            'exs_estado' => 1,
                            'exs_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'exs_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('exs_enfermedaxsolicitante', $cadena_enf, array('exs_id' => $exe_enf_ids[$exe_id]));
                    }
                }
                $exe_id ++;
            }

            for ($enf_del = 0; $enf_del < count($enf_ids); $enf_del++) {
                if (!in_array($enf_ids[$enf_del], $enf_tipo)) {
                    $cadena = array(
                        'exs_estado' => 0,
                        'exs_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'exs_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('exs_enfermedaxsolicitante', $cadena, array('exs_id' => $exe_enf_ids[$enf_del]));
                }
            }


            $alergico = $this->gsatelite->get_tabla('cas_componente_alergico_solicitante', array('cas_estado' => 1, 'cas_id_sle' => $emp_id));

            $cae_aler_ids = array(); //Se almacenan los ids de la relacion de la alergia con el empleado
            $aler_ids = array(); //Se almacenan los ids de la relacion de la alergia con el empleado
            foreach ($alergico as $key) {
                $cae_aler_ids[] = $key["cas_id"];
                $aler_ids[] = $key["cas_id_coa"];
            }
            $cae_id_enf = $this->input->post("cae_id_enf");
            $enf_alergia = $this->input->post("enf_alergia"); //id_cos_componente

            $cae_id = 0;
            foreach ($enf_alergia as $key) {
                if (trim($key) != "") {
                    if (!in_array($key, $aler_ids)) {
                        $this->db->insert('cas_componente_alergico_solicitante', array(
                            'cas_id_coa' => $key,
                            'cas_id_sle' => $emp_id,
                            'cas_estado' => 1,
                            'cas_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cas_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cas_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cas_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena_aler = array(
                            'cas_estado' => 1,
                            'cas_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cas_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cas_componente_alergico_solicitante', $cadena_aler, array('cas_id' => $cae_id_enf[$cae_id]));
                    }
                }
                $cae_id++;
            }

            for ($aler_del = 0; $aler_del < count($aler_ids); $aler_del++) {
                if (!in_array($aler_ids[$aler_del], $enf_alergia)) {
                    $cadena = array(
                        'cas_estado' => 0,
                        'cas_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cas_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cas_componente_alergico_solicitante', $cadena, array('cas_id' => $cae_aler_ids[$aler_del]));
                }
            }

            



            /* =====================================================================================================================
              =                                 EDITAR DATOS FAMILIARES
              =======================================================================================================================
             */

            /*
              $this->db->where('fam_id_emp',$emp_id)
              ->delete('fam_familiar');
             */

            /* Verificar los familiares que tiene ese empleado */
            $consul = $this->gsatelite->get_tabla('fas_familiar_solicitante', array('fas_id_sle' => $emp_id, 'fas_estado' => 1));
            $seleccionados_activos = array();
            foreach ($consul as $f) {
                $seleccionados_activos[] = $f['fas_id'];
            }
            
            /* Se obtiene los datos ha capturar de los familiares de empleado */
            $array3 = $this->input->post('nombres_familiares');
            $array3_1 = $this->input->post('apellidos_familiares');
            $array3_2 = $this->input->post('parentesco_familiares');
            $array3_3 = $this->input->post('telefono_familiares');
            $array3_4 = $this->input->post('fechas_familiares');
            $array3_5 = $this->input->post('dependencia_familiares');
            $array3_6 = $this->input->post('institucion_familiares');
            $array3_7 = $this->input->post('id_empleado_familiares');
            $array3_82 = $this->input->post('reside_con_empleado_familiares');
            $array3_8 = $this->input->post('familiar_ids');
            $array3_9 = $this->input->post('beneficiario_familiares');
            $array3_10 = $this->input->post('beneficia_porcentaje_familiares');
            $i = 0;
            foreach ($array3 as $key => $value3) {
                if (trim($value3) != "" && trim($array3_1[$i]) != "" && trim($array3_2[$i]) != "" && trim($array3_5[$i]) != "") {
                    if (in_array($array3_8[$i], $seleccionados_activos)) {
                            $cadena = array(
                            'fas_id_sle' => $emp_id,
                            'fas_nombre' => $value3,
                            'fas_apellido' => $array3_1[$i],
                            'fas_fecha_nacimiento' => (trim($array3_4[$i]) != "")? date('Y-m-d', strtotime($array3_4[$i])) : null,
                            'fas_dependiente' => (is_numeric($array3_5[$i]))? $array3_5[$i]:null,
                            'fas_empresa' => (is_numeric($array3_6[$i]))? $array3_6[$i]:null,
                            'fas_estado' => 1,
                            'fas_id_pat' => $array3_2[$i],
                            'fas_telefono' => $array3_3[$i],
                            'fas_beneficiario' =>  (is_numeric($array3_9[$i]))?  $array3_9[$i]:null,
                            'fas_porcentaje_beneficio' =>  (is_numeric($array3_10[$i]))? $array3_10[$i]:null,
                            'fas_reside_empleado' => ($array3_82[$i] > 0) ? $array3_82[$i] :0,
                            'fas_usu_modificacion ' => $this->tank_auth->get_user_id(),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
                            'fas_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                            /*print_r($cadena);die();*/
                        $this->gsatelite->actualizar_array('fas_familiar_solicitante', $cadena, array('fas_id' => $array3_8[$i], 'fas_id_sle' => $emp_id));
                    } else {
                        $cadena2 = array(
                            'fas_nombre' => $value3,
                            'fas_apellido' => $array3_1[$i],
                            'fas_fecha_nacimiento' => (trim($array3_4[$i]) != "") ? date('Y-m-d', strtotime($array3_4[$i])) : null,
                            'fas_dependiente' => (is_numeric($array3_5[$i]))? $array3_5[$i]:null, 
                            'fas_empresa' => (is_numeric($array3_6[$i]))? $array3_6[$i]:null, 
                            'fas_estado' => 1,
                            'fas_id_pat' => $array3_2[$i],
                            'fas_id_sle' => $emp_id,
                            //'fas_id_sle_familiar' => ($array3_7[$i]) ? $array3_7[$i] : null,
                            'fas_reside_empleado' => ($array3_82[$i] > 0) ? $array3_82[$i] :0,
                            'fas_beneficiario' =>  (is_numeric($array3_9[$i]))? $array3_9[$i]:null, 
                            'fas_porcentaje_beneficio' =>  (is_numeric($array3_10[$i]))? $array3_10[$i]:null, 
                            'fas_telefono' => $array3_3[$i],
                            'fas_usu_creacion' => $this->tank_auth->get_user_id(),
                            'fas_fecha_creacion' => date('Y-m-d H:i:s'),
                            'fas_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'fas_fecha_modificacion' => date('Y-m-d H:i:s'));
                        $fam_id = $this->db->insert('fas_familiar_solicitante',$cadena2);
                        /*print_r($fam_id);die();*/
                    }
                } 
                $i++;
            }

            for ($j = 0; $j < count($seleccionados_activos); $j++) {
                if (!in_array($seleccionados_activos[$j], $array3_8)) {
                    $cadena = array(
                        'fas_estado' => 0,
                        'fas_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'fas_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('fas_familiar_solicitante', $cadena, array('fas_id' => $seleccionados_activos[$j], 'fas_id_sle' => $emp_id));
                }
            }

            /* ===============================================================================================================================
              =                                         ACTUALIZACION DE PLAZAS
              =================================================================================================================================
             */

              $this->gsatelite->borrado_general('csp_concurso_xsolicitante_empleo',array('csp_id_sle'=>$emp_id));
              $cnp   = $this->input->post('concursos_activos');
              $sele  = $this->input->post('seleccionadox');
              $ob    = $this->input->post('observaciones');
               if ((is_array($cnp)) && (count($cnp) >0)){
                    for ($i=0; $i < count($cnp); $i++) { 
                    $selec = explode(',', $sele[$i]);
                    $array_plazas  = array(
                        'csp_id_sle'            => $emp_id,
                        'csp_id_cnp'            => $cnp[$i],
                        'csp_seleccionado'      => ($selec[0] != '')?$selec[0]:0,
                        'csp_fecha_seleccion'   => ($selec[1] != '')?$selec[1]:null,
                        'csp_observacion'       => ( $ob != '')?$ob[$i]:null,
                        'csp_estado'            => 1,
                        'csp_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'csp_fecha_creacion'    => date('Y-m-d H:m:s'),
                        'csp_usu_modificacion'  => $this->tank_auth->get_user_id(), 
                        'csp_fecha_modificacion'=> date('Y-m-d H:m:s')

                    );
                    $this->gsatelite->ingresar('csp_concurso_xsolicitante_empleo',$array_plazas);

                  }
                }

            /* ===============================================================================================================================
              =                                         ACTUALIZACION DE IDIOMAS
              =================================================================================================================================
             */

            $consul_idioma_emp = $this->gsatelite->get_tabla('ids_idioma_solicitante', array('ids_id_sle' => $emp_id, 'ids_estado' => 1));
            //se guardan los ids de los familiares existentes
            $ids_idioma_emp = array();
            foreach ($consul_idioma_emp as $key) {
                $ids_idioma_emp[] = $key['ids_id'];
            }

            //Guarda los datos de los idiomas
            $array4 = $this->input->post('idioma');
            $array4_1 = $this->input->post('nivel');
            $array4_2 = $this->input->post('leer');
            $array4_3 = $this->input->post('escribir');
            $array4_4 = $this->input->post('hablar');
            $array4_5 = $this->input->post('traductor');
            $array4_6 = $this->input->post('id_iem_idioma');

            for ($i_d = 0; $i_d < count($array4); $i_d++) {
                if ($array4[$i_d] != "" && $array4_1[$i_d] != "") {
                    if (!in_array($array4_6[$i_d], $ids_idioma_emp)) {
                        $this->db->insert('ids_idioma_solicitante', array(
                            'ids_id_nii' => $array4_1[$i_d],
                            'ids_id_idm' => $array4[$i_d],
                            'ids_id_sle' => $emp_id,
                            'ids_leer' => ($array4_2[$i_d] != "") ? $array4_2[$i_d] : 0,
                            'ids_escribir' => ($array4_3[$i_d] != "") ? $array4_3[$i_d] : 0,
                            'ids_hablar' => ($array4_4[$i_d] != "") ? $array4_4[$i_d] : 0,
                            'ids_traductor' => ($array4_5[$i_d] != "") ? $array4_5[$i_d] : 0,
                            'ids_estado' => 1,
                            'ids_usu_creacion' => $this->tank_auth->get_user_id(),
                            'ids_fecha_creacion' => date('Y-m-d H:i:s'),
                            'ids_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'ids_fecha_modificacion' => date('Y-m-d H:i:s'))
                        );
                    } else {
                        $cadena = array(
                            'ids_id_nii' => ($array4_1[$i_d] != '')?$array4_1[$i_d]:0,
                            'ids_id_idm' => ($array4[$i_d] != '')?$array4[$i_d]:0,
                            'ids_leer' => ($array4_2[$i_d] != '')?$array4_2[$i_d]:0,
                            'ids_escribir' => ($array4_3[$i_d] != '')?$array4_3[$i_d]:0,
                            'ids_hablar' => ($array4_4[$i_d] != '')?$array4_4[$i_d]:0,
                            'ids_traductor' => ($array4_5[$i_d] != '')?$array4_5[$i_d]:0,
                            'ids_estado' => 1,
                            'ids_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'ids_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('ids_idioma_solicitante', $cadena, array('ids_id' => $array4_6[$i_d], 'ids_id_sle' => $emp_id));
                    }
                }
            }

            for ($i_dd = 0; $i_dd < count($ids_idioma_emp); $i_dd++) {
                if (!in_array($ids_idioma_emp[$i_dd], $array4_6)) {
                    $cadena = array(
                        'ids_estado' => 0,
                        'ids_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'ids_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('ids_idioma_solicitante', $cadena, array('ids_id' => $ids_idioma_emp[$i_dd], 'ids_id_sle' => $emp_id));
                }
            }


            /* ===============================================================================================================================
              =                                         ACTUALIZACION DE CERTIFICADOS DE IDIOMA
              =================================================================================================================================
             */

            $consul_cer_idioma_emp = $this->gsatelite->get_tabla('cis_certificacion_idioma', array('cis_id_sle' => $emp_id, 'cis_estado' => 1));
            $ids_cer_idioma_emp = array();
            foreach ($consul_cer_idioma_emp as $key) {
                $ids_cer_idioma_emp[] = $key['cis_id'];
            }

            $array5 = $this->input->post('idioma_cert');
            $array5_1 = $this->input->post('tipo_cert');
            $array5_2 = $this->input->post('puntaje_cert');
            $array5_3 = $this->input->post('fecha_cert');
            $array5_4 = $this->input->post('id_cri_idioma');

            for ($c_d = 0; $c_d < count($array5); $c_d++) {
                if ($array5[$c_d] != "" && $array5_1[$c_d] != "" && $array5_2[$c_d] != "" && $array5_3[$c_d] != "") {
                    if (!in_array($array5_4[$c_d], $ids_cer_idioma_emp)) {
                        $this->db->insert('cis_certificacion_idioma', array(
                            'cis_id_sle ' => $emp_id,
                            'cis_id_cer' => $array5_1[$c_d],
                            'cis_id_idm' => $array5[$c_d],
                            'cis_puntaje' => $array5_2[$c_d],
                            'cis_fecha_certificacion' => (trim($array5_3[$c_d]) != "") ? date('Y-m-d', strtotime($array5_3[$c_d])) : null,
                            'cis_estado' => 1,
                            'cis_usu_creacion' => $this->tank_auth->get_user_id(),
                            'ciis_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cis_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cis_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'cis_id_cer' => $array5_1[$c_d],
                            'cis_id_idm' => $array5[$c_d],
                            'cis_puntaje' => $array5_2[$c_d],
                            'cis_fecha_certificacion' => (trim($array5_3[$c_d]) != "") ? date('Y-m-d', strtotime($array5_3[$c_d])) : null,
                            'cis_estado' => 1,
                            'cis_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cis_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cis_certificacion_idioma', $cadena, array('cis_id' => $array5_4[$c_d], 'cis_id_sle' => $emp_id));
                    }
                }
            }

            for ($c_dd = 0; $c_dd < count($ids_cer_idioma_emp); $c_dd++) {
                if (!in_array($ids_cer_idioma_emp[$c_dd], $array5_4)) {
                    $cadena = array(
                        'cis_estado' => 0,
                        'cis_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cis_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cis_certificacion_idioma', $cadena, array('cis_id' => $ids_cer_idioma_emp[$c_dd], 'cis_id_sle' => $emp_id));
                }
            }

            /* ===============================================================================================================================
              =                                         ACTUALIZACION DE PROGRAMAS
              =================================================================================================================================
             */

            $consul_programa_emp = $this->gsatelite->get_tabla('pxs_programaxsolicitante', array('pxs_id_sle' => $emp_id, 'pxs_estado' => 1));
            //se guardan los ids de los familiares existentes
            $ids_programa_emp = array();
            foreach ($consul_programa_emp as $key) {
                $ids_programa_emp[] = $key['pxs_id'];
            }

            //Guarda los datos de los idiomas
            $array4 = $this->input->post('tipo_program');
            $array4_1 = $this->input->post('nivel_program');

            $array4_2 = $this->input->post('id_pxe_program');

            for ($i_p = 0; $i_p < count($array4); $i_p++) {
                if ($array4[$i_p] != "" && $array4_1[$i_p] != "") {
                    if (!in_array($array4_2[$i_p], $ids_programa_emp)) {
                        $this->db->insert('pxs_programaxsolicitante', array(
                            'pxs_id_peq' => $array4[$i_p],
                            'pxs_id_sle' => $emp_id,
                            'pxs_id_nie' => $array4_1[$i_p],
                            'pxs_estado' => 1,
                            'pxs_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pxs_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pxs_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxs_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'pxs_id_peq' => $array4[$i_p],
                            'pxs_id_nie' => $array4_1[$i_p],
                            'pxs_estado' => 1,
                            'pxs_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxs_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('pxs_programaxsolicitante', $cadena, array('pxs_id' => $array4_2[$i_d], 'pxs_id_sle' => $emp_id));
                    }
                }
            }

            for ($i_pp = 0; $i_pp < count($ids_programa_emp); $i_pp++) {
                if (!in_array($ids_programa_emp[$i_pp], $array4_2)) {
                    $cadena = array(
                        'pxs_estado' => 0,
                        'pxs_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'pxs_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('pxs_programaxsolicitante', $cadena, array('pxs_id' => $ids_programa_emp[$i_pp], 'pxs_id_sle' => $emp_id));
                }
            }


            /* ===============================================================================================================================
              =                                         ACTUALIZACION DE CERTIFICADOS DE PROGRAMAS
              =================================================================================================================================
             */

            $consul_cer_program_cep = $this->gsatelite->get_tabla('cps_certificacion_programa_solicitante', array('cps_id_sle' => $emp_id, 'cps_estado' => 1));
            $ids_cer_program_cep = array();
            foreach ($consul_cer_program_cep as $key) {
                $ids_cer_program_cep[] = $key['cps_id'];
            }

            $array5   = $this->input->post('program_cer');
            $array5_1 = $this->input->post('tipo_program_cer');
            $array5_2 = $this->input->post('program_puntaje_cert');
            $array5_3 = $this->input->post('program_fecha_cert');
            $array5_4 = $this->input->post('program_institucion_cert');
            $array5_5 = $this->input->post('program_modalidad_cert');
           // print_r($this->input->post('program_institucion_cert')); die();

            //$array5_4 = $this->input->post('id_cep_program_cer');

            for ($c_p = 0; $c_p < count($array5); $c_p++) {
                if ($array5[$c_p] != "" && $array5_1[$c_p] != "" && $array5_2[$c_p] != "" && $array5_3[$c_p] != "" && $array5_4[$c_p] != "") {
                    if (!in_array($array5_4[$c_p], $ids_cer_program_cep)) {
                        $this->db->insert('cps_certificacion_programa_solicitante', array(
                            'cps_id_sle' => $emp_id,
                            'cps_id_cer' => $array5_1[$c_p],
                            'cps_id_peq' => $array5[$c_p],
                            'cps_puntaje' => $array5_2[$c_p],
                            'cps_id_mde'  => $array5_5[$c_p],
                            'cps_id_icp'  => $array5_4[$c_p],
                            'cps_fecha_certificacion' => (trim($array5_3[$c_p]) != "") ? date('Y-m-d', strtotime($array5_3[$c_p])) : null,
                            'cps_estado' => 1,
                            'cps_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cps_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cps_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cps_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'cps_id_cer' => $array5_1[$c_p],
                            'cps_id_peq' => $array5[$c_p],
                            'cps_puntaje' => $array5_2[$c_p],
                            'cps_id_mde'  => $array5_5[$c_p],
                            'cps_id_icp'  => $array5_4[$c_p],
                            'cps_fecha_certificacion' => (trim($array5_3[$c_p]) != "") ? date('Y-m-d', strtotime($array5_3[$c_p])) : null,
                            'cps_estado' => 1,
                            'cps_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cps_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cps_certificacion_programa_solicitante', $cadena, array('cps_id' => $array5_4[$c_p], 'cps_id_sle' => $emp_id));
                    }
                }
            }

            for ($c_pp = 0; $c_pp < count($ids_cer_program_cep); $c_pp++) {
                if (!in_array($ids_cer_program_cep[$c_pp], $array5_4)) {
                    $cadena = array(
                        'cps_estado' => 0,
                        'cps_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cps_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cps_certificacion_programa_solicitante', $cadena, array('cps_id' => $ids_cer_program_cep[$c_pp], 'cps_id_sle' => $emp_id));
                }
            }

            /* =================================================================================================================
              =                                 REFERENCIAS PERSONALES
              ===================================================================================================================
             */
            $array8 = $this->input->post('tipo_refpersonal');
            $array8_1 = $this->input->post('nombre_refpersonal');
            $array8_2 = $this->input->post('ltrabajo_refpersonal');
            $array8_3 = $this->input->post('ocupacion_refpersonal');
            $array8_4 = $this->input->post('telefono_refpersonal');
            $array8_refDescipcion = $this->input->post('referencia_refpersonal');

            $consul_refpersonal = $this->gsatelite->get_tabla('rps_referencia_personal_solicitante', array('rps_estado' => 1, 'rps_id_sle' => $emp_id));
            $ids_refpersonal = array();
            foreach ($consul_refpersonal as $key) {
                $ids_refpersonal[] = $key['rps_id'];
            }

            $array8_5 = $this->input->post('id_refpersonal');

            for ($rf = 0; $rf < count($array8); $rf++) {
                if ($array8[$rf] != "" && $array8_1[$rf] != "" && $array8_2[$rf] != "" && $array8_4[$rf] != "") {
                    if (!in_array($array8_5[$rf], $ids_refpersonal)) {
                        $this->db->insert('rps_referencia_personal_solicitante', array(
                            'rps_id_trr' => $array8[$rf],
                            'rps_id_sle' => $emp_id,
                            'rps_nombre' => $array8_1[$rf],
                            'rps_lugar_trabajo' => $array8_2[$rf],
                            'rps_ocupacion' => (trim($array8_3[$rf]) != "") ? $array8_3[$rf] : null,
                            'rps_telefono' => $array8_4[$rf],
                            'rps_descripcion_referencia' => (trim($array8_refDescipcion[$rf]) != '')? $array8_refDescipcion[$rf]:null,
                            'rps_estado' => 1,
                            'rps_fecha_creacion' => date('Y-m-d H:i:s'),
                            'rps_usu_creacion' => $this->tank_auth->get_user_id(),
                            'rps_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rps_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'rps_id_trr' => $array8[$rf],
                            'rps_nombre' => $array8_1[$rf],
                            'rps_lugar_trabajo' => $array8_2[$rf],
                            'rps_ocupacion' => (trim($array8_3[$rf]) != "") ? $array8_3[$rf] : null,
                            'rps_telefono' => $array8_4[$rf],
                            'rps_descripcion_referencia' => (trim($array8_refDescipcion[$rf]) != '')? $array8_refDescipcion[$rf]:null,
                            'rps_estado' => 1,
                            'rps_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rps_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('rps_referencia_personal_solicitante', $cadena, array('rps_id' => $array8_5[$rf], 'rps_id_sle' => $emp_id));
                    }
                }
            }

            for ($rff = 0; $rff < count($ids_refpersonal); $rff++) {
                if (!in_array($ids_refpersonal[$rff], $array8_5)) {
                    $cadena = array(
                        'rps_estado' => 0,
                        'rps_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rps_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('rps_referencia_personal_solicitante', $cadena, array('rps_id' => $ids_refpersonal[$rff], 'rps_id_sle' => $emp_id));
                }
            }

            /* =================================================================================================================
              =                                 REFERENCIAS PERSONALES
              ===================================================================================================================
             */
            $array9 = $this->input->post('lugar_tra_reflab');
            $array9_1 = $this->input->post('direccion_reflab');
            $array9_2 = $this->input->post('telefono_reflab');
            $array9_3 = $this->input->post('puesto_reflab');
            $array9_4 = $this->input->post('jefe_inmediato_reflab');
            $array9_5 = $this->input->post('salario_deven_reflab');
            $array9_6 = $this->input->post('mot_retiro_reflab');


            $array9_8 = $this->input->post('nombre_referencia_reflab');
            $array9_9 = $this->input->post('desde_reflab');
            $array9_10 = $this->input->post('hasta_reflab');
            $array9_11 = $this->input->post('referencia_reflab');

            $consul_reflaboral = $this->gsatelite->get_tabla('rls_referencia_laboral_solicitante', array('rls_estado' => 1, 'rls_id_sle' => $emp_id));
            $ids_reflaboral = array();
            foreach ($consul_reflaboral as $key) {
                $ids_reflaboral[] = $key['rls_id'];
            }

            $array9_7 = $this->input->post('id_reflaboral');

            for ($rl = 0; $rl < count($array9); $rl++) {
                if ($array9[$rl] != "" && $array9_1[$rl] != "" && $array9_3[$rl] != "") {
                    if (!in_array($array9_7[$rl], $ids_reflaboral)) {
                        $this->db->insert('rls_referencia_laboral_solicitante', array(
                            'rls_id_sle' => $emp_id,
                            'rls_lugar_trabajo' => $array9[$rl],
                            'rls_direccion' => $array9_1[$rl],
                            'rls_telefono' => $array9_2[$rl],
                            'rls_puesto' => $array9_3[$rl],
                            'rls_jefe' => $array9_4[$rl],
                            'rls_salario_devengado' => $array9_5[$rl],
                            'rls_motivo_retiro' => $array9_6[$rl],
                            'rls_nombre_ref' => $array9_8[$rl],
                            'rls_fecha_desde' => (trim($array9_9[$rl]) != '')? formatear_fecha('Y-m-d',$array9_9[$rl]):null,
                            'rls_fecha_hasta' => (trim($array9_10[$rl]) != '')? formatear_fecha('Y-m-d',$array9_10[$rl]):null,
                            'rls_referencia' => $array9_11[$rl],
                            'rls_estado' => 1,
                            'rls_fecha_creacion' => date('Y-m-d H:i:s'),
                            'rls_usu_creacion' => $this->tank_auth->get_user_id(),
                            'rls_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rls_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'rls_lugar_trabajo' => $array9[$rl],
                            'rls_direccion' => $array9_1[$rl],
                            'rls_telefono' => $array9_2[$rl],
                            'rls_puesto' => $array9_3[$rl],
                            'rls_jefe' => $array9_4[$rl],
                            'rls_salario_devengado' => $array9_5[$rl],
                            'rls_motivo_retiro' => $array9_6[$rl],
                            'rls_estado' => 1,
                            'rls_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rls_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('rls_referencia_laboral_solicitante', $cadena, array('rls_id' => $array9_7[$rl], 'rls_id_sle' => $emp_id));
                    }
                }
            }

            for ($rll = 0; $rll < count($ids_reflaboral); $rll++) {
                if (!in_array($ids_reflaboral[$rll], $array9_7)) {
                    $cadena = array(
                        'rls_estado' => 0,
                        'rls_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rls_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('rls_referencia_laboral_solicitante', $cadena, array('rls_id' => $ids_reflaboral[$rll], 'rls_id_sle' => $emp_id));
                }
            }

            /* =================================================================================================================
              =                                 DATOS ACADEMICOS
              ===================================================================================================================
             */
            $array10   = $this->input->post('tipo_datacademicos');
            $array10_1 = $this->input->post('profesion_datacademicos');
            $array10_2 = $this->input->post('institucion_datacademicos');
            $array10_3 = $this->input->post('estestudio_datacademicos');
            $array10_4 = $this->input->post('pais_datacademicos');
            $array10_5 = $this->input->post('explaboral_datacademicos');
            $array10_6 = $this->input->post('fecha_datacademicos');
            $array10_7 = $this->input->post('observacion_datacademicos');

            $array10_9 = $this->input->post('anios_cursado_estudio_datacademicos');


            $consul_dacacademic = $this->gsatelite->get_tabla('das_dato_academico_solicitante', array('das_estado' => 1, 'das_id_sle' => $emp_id));
            
            $ids_dacacademic = array();
            foreach ($consul_dacacademic as $key) {
                $ids_dacacademic[] = $key['das_id'];
            }

            $array10_8 = $this->input->post('id_datacademic');

            for ($dta = 0; $dta < count($array10); $dta++) {
                if ($array10[$dta] > 0/* && $array10_3[$dta] != "" && $array10_4[$dta] != "" && $array10_5[$dta] */) {
                    if (!in_array($array10_8[$dta], $ids_dacacademic)) {
                        $this->db->insert('das_dato_academico_solicitante', array(
                            'das_id_pai' => ($array10_4[$dta] > 0)? $array10_4[$dta]:null,
                            'das_id_tie' => $array10[$dta],
                            'das_id_pro' => ($array10_1[$dta] > 0)? $array10_1[$dta] : null,
                            'das_id_ese' => ($array10_3[$dta] > 0)? $array10_3[$dta]:null,
                            'das_id_sle' => $emp_id,
                            'das_id_exl' => ($array10_5[$dta] > 0 ) ? $array10_5[$dta] : null,
                            'das_id_ina' => ($array10_2[$dta] > 0 ) ? $array10_2[$dta] : null,
                            'das_fecha_finalizacion' => date('Y-m-d', strtotime($array10_6[$dta])),
                            'das_anios_cursado' => ($array10_9[$dta] > 0 ) ? $array10_9[$dta] : null,
                            'das_observacion' => $array10_7[$dta],
                            'das_estado' => 1,
                            'das_fecha_creacion' => date('Y-m-d H:i:s'),
                            'das_usu_creacion' => $this->tank_auth->get_user_id(),
                            'das_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'das_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                       // print_r($this->db->last_query()); die();
                    } else {
                        $cadena = array(
                            'das_id_pai' => ($array10_4[$dta] > 0 )? $array10_4[$dta]:null,
                            'das_id_tie' => $array10[$dta],
                            'das_id_pro' => ($array10_1[$dta] != '') ? $array10_1[$dta] : null,
                            'das_id_ese' => ($array10_3[$dta] > 0)? $array10_3[$dta]:null,
                            'das_id_exl' => ($array10_5[$dta] != '') ? $array10_5[$dta] : null,
                            'das_id_ina' => ($array10_2[$dta] != '') ? $array10_2[$dta] : null,
                            'das_fecha_finalizacion' => (trim($array10_6[$dta]) != "") ? date('Y-m-d', strtotime($array10_6[$dta])) : null,
                            'das_anios_cursado' => ($array10_9[$dta] > 0 ) ? $array10_9[$dta] : null,
                            'das_observacion' => $array10_7[$dta],
                            'das_estado' => 1,
                            'das_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'das_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('das_dato_academico_solicitante', $cadena, array('das_id' => $array10_8[$dta], 'das_id_sle' => $emp_id));
                    }
                }
            }

            for ($dtaa = 0; $dtaa < count($ids_dacacademic); $dtaa++) {
                if (!in_array($ids_dacacademic[$dtaa], $array10_8)) {
                    $cadena = array(
                        'das_estado' => 0,
                        'das_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'das_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('das_dato_academico_solicitante', $cadena, array('das_id' => $ids_dacacademic[$dtaa], 'das_id_sle' => $emp_id));
                }
            }



            /* =================================================================================================================
              =                              INICIO GUARDADO DE HABILIDADES EMPLEADO
              ===================================================================================================================
             */

            $this->gsatelite->borrado_general('hxs_habilidadxsolicitante',array('hxs_id_sle'=>$emp_id));
            $hablidad_empleado = $this->input->post('hablidad_empleado');
            $nivel_hablidad_empleado = $this->input->post('nivel_hablidad_empleado');
            for ($hab_emp=0; $hab_emp < count($hablidad_empleado) ; $hab_emp++) { 
                if ($hablidad_empleado[$hab_emp] > 0) {
                   $array_insert_reg = array(
                    'hxs_id_hab' => $hablidad_empleado[$hab_emp],
                    'hxs_id_sle' => $emp_id,
                    'hxs_id_nih' => ($nivel_hablidad_empleado[$hab_emp] > 0)? $nivel_hablidad_empleado[$hab_emp]:null,
                    'hxs_estado' => 1,
                    'hxs_usu_creacion' => $this->tank_auth->get_user_id(),
                    'hxs_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'hxs_fecha_creacion' => date('Y-m-d H:i:s'),
                    'hxs_fecha_modificacion' => date('Y-m-d H:i:s')
                   );

                   $id_hxm = $this->gsatelite->ingresar('hxs_habilidadxsolicitante', $array_insert_reg);
                }
            }

            /* =================================================================================================================
              =                              FIN GUARDADO DE HABILIDADES EMPLEADO
              ===================================================================================================================
             */
              
              /* =================================================================================================================
              =                              INICIO EDITAR INSUMOS
              ===================================================================================================================
             */
              //Contacto
              $new = $this->input->post('txtTablaNew');
              $tipo_insumo_array = $this->input->post('tipo_insumo_array');
              $insumo_array = $this->input->post('insumo_array');
              $cantidad_insumo_array = $this->input->post('cantidad_insumo_array');
              $costo_insumo_array = $this->input->post('costo_insumo_array');
              $fecha_insumo_array = $this->input->post('fecha_insumo_array');            
              
              //obtener los detalles antiguos
              $insumos_antiguos = $this->gsatelite->get_tabla('ise_isumo_solicitante_empleo', array('ise_id_sle' => $emp_id));
              
              //eliminacion de insumos que no existen 
              foreach ($insumos_antiguos as $insu) {
                  if (!in_array($insu['ise_id'], $new)) {
                      $this->gsatelite->actualizar_array('ise_isumo_solicitante_empleo', array('ise_estado' => 0),array('ise_id' => $insu['ise_id']));
                  }
              }

              foreach ($insumo_array as $key => $id_insu) {
                  if(trim($id_insu)){
                      if ( $new[$key] == "" ) {
                          $array_ixe_insumoxempleado = array(                        
                              'ise_id_inm' => $insumo_array[$key],
                              'ise_id_sle' => $emp_id,
                              'ise_cantidad' => $cantidad_insumo_array[$key],
                              'ise_costo' => $costo_insumo_array[$key],
                              'ise_fecha_entrega' => formatear_fecha('Y-m-d',$fecha_insumo_array[$key]),
                              'ise_estado' => 1,
                              'ise_usu_creacion' => $this->tank_auth->get_user_id(),
                              'ise_usu_modificacion' => $this->tank_auth->get_user_id(),
                              'ise_fecha_creacion' => date('Y-m-d H:i:s'),
                              'ise_fecha_modificacion' => date('Y-m-d H:i:s')
                          );
                          $this->gsatelite->ingresar('ise_isumo_solicitante_empleo', $array_ixe_insumoxempleado);
                      } else {
                          $array_ixe_insumoxempleado = array(                        
                              'ise_id_inm' => $insumo_array[$key],
                              'ise_id_sle' => $emp_id,
                              'ise_cantidad' => $cantidad_insumo_array[$key],
                              'ise_costo' => $costo_insumo_array[$key],
                              'ise_fecha_entrega' => formatear_fecha('Y-m-d',$fecha_insumo_array[$key]),
                              'ise_estado' => 1,
                              //'ixe_usu_creacion' => $this->tank_auth->get_user_id(),
                              //'ixe_usu_modificacion' => $this->tank_auth->get_user_id(),
                              'ise_fecha_creacion' => date('Y-m-d H:i:s'),
                              'ise_fecha_modificacion' => date('Y-m-d H:i:s')
                          );    
                          $this->gsatelite->actualizar_array('ise_isumo_solicitante_empleo', $array_ixe_insumoxempleado,array('ise_id' => $new[$key]));
                      }                    
                  }
              }            
              /* =================================================================================================================
              =                              FIN EDITAR INSUMOS
              ===================================================================================================================
              */
                
                 /* =================================================================================================================
                 =                              INICIO EDITAR CAPACITACIONES
                 ===================================================================================================================
                */
                 //Contacto
                 $new = $this->input->post('txtTablaNewCapa');
                 $nombre_capa_array = $this->input->post('nombre_capa_array');
                 $institucion_capa_array = $this->input->post('institucion_capa_array');
                 $fecha_inicio_capa_array = $this->input->post('fecha_inicio_capa_array');                 
                 $fecha_fin_capa_array = $this->input->post('fecha_fin_capa_array');
                 $hora_duracion_capa_array = $this->input->post('hora_duracion_capa_array');
                 $costo_capa_array = $this->input->post('costo_capa_array');   
                 $costo_cubierto_insa_array = $this->input->post('costo_cubierto_insa_array');
                 $costo_cubierto_prov_array = $this->input->post('costo_cubierto_prov_array');            
                 $estado_capa_array = $this->input->post('estado_capa_array');            
                 
                 //obtener los detalles antiguos
                 $capacitaciones_antiguos = $this->gsatelite->get_tabla('ccs_capacitacion_solicitante', array('ccs_id_sle' => $emp_id));
                 
                 //eliminacion de insumos que no existen 
                 foreach ($capacitaciones_antiguos as $capa) {
                     if (!in_array($capa['ccs_id'], $new)) {
                         $this->gsatelite->actualizar_array('ccs_capacitacion_solicitante', array('ccs_estado' => 0),array('ccs_id' => $capa['ccp_id']));
                     }
                 }

                 foreach ($nombre_capa_array as $key => $nomca) {
                     if(trim($nomca)){
                         if ( $new[$key] == "" ) {
                             $array_cpe_capacitacion_empleado = array(                                                         
                                 'ccs_id_sle' => $emp_id,
                                 'ccs_id_ese' => is_numeric($estado_capa_array[$key])? $estado_capa_array[$key]:null,
                                 'ccs_id_icp' => is_numeric($institucion_capa_array[$key])? $institucion_capa_array[$key]:null,
                                 'ccs_nombre' => $nomca,
                                 'ccs_duracion' => $hora_duracion_capa_array[$key],
                                 'ccs_costo_empresa' => $costo_capa_array[$key],
                                 'ccs_costo_insaforp' => $costo_cubierto_insa_array[$key],
                                 'ccs_costo_proveedor' => $costo_cubierto_prov_array[$key],
                                 'ccs_fecha_inicio' => formatear_fecha('Y-m-d', $fecha_inicio_capa_array[$key]),
                                 'ccs_fecha_fin' => formatear_fecha('Y-m-d', $fecha_fin_capa_array[$key]),                                 
                                 'ccs_estado' => 1,
                                 'ccs_usu_creacion' => $this->tank_auth->get_user_id(),
                                 'ccs_usu_modificacion' => $this->tank_auth->get_user_id(),
                                 'ccs_fecha_creacion' => date('Y-m-d H:i:s'),
                                 'ccs_fecha_modificacion' => date('Y-m-d H:i:s')
                             );
                             $this->gsatelite->ingresar('ccs_capacitacion_solicitante', $array_cpe_capacitacion_empleado);
                         } else {
                             $array_cpe_capacitacion_empleado = array(                                                         
                                 'ccs_id_sle' => $emp_id,
                                 'ccs_id_ese' => is_numeric($estado_capa_array[$key])? $estado_capa_array[$key]:null,
                                 'ccs_id_icp' => is_numeric($institucion_capa_array[$key])? $institucion_capa_array[$key]:null,
                                 'ccs_nombre' => $nomca,
                                 'ccs_duracion' => $hora_duracion_capa_array[$key],
                                 'ccs_costo_empresa' => $costo_capa_array[$key],
                                 'ccs_costo_insaforp' => $costo_cubierto_insa_array[$key],
                                 'ccs_costo_proveedor' => $costo_cubierto_prov_array[$key],
                                 'ccs_fecha_inicio' => formatear_fecha('Y-m-d', $fecha_inicio_capa_array[$key]),
                                 'ccs_fecha_fin' => formatear_fecha('Y-m-d', $fecha_fin_capa_array[$key]),                                 
                                 'ccs_estado' => 1,
                                 //'cpe_usu_creacion' => $this->tank_auth->get_user_id(),
                                 'ccs_usu_modificacion' => $this->tank_auth->get_user_id(),
                                 //'cpe_fecha_creacion' => date('Y-m-d H:i:s'),
                                 'ccs_fecha_modificacion' => date('Y-m-d H:i:s')
                             );    
                             $this->gsatelite->actualizar_array('ccs_capacitacion_solicitante', $array_cpe_capacitacion_empleado, array('ccs_id' => $new[$key]));
                         }                    
                     }
                 }            
                 /* =================================================================================================================
                 =                              FIN EDITAR CAPACITACIONES
                 ===================================================================================================================
                 */                            


              /* =================================================================================================================
                =                              INICIO GUARDADO DE AGRUPACIONES EMPLEADO
                ===================================================================================================================
               */
            $this->gsatelite->borrado_general('ags_agrupacion_solicitante',array('ags_id_sle'=>$emp_id));
              $agrupacion_emp = $this->input->post('agrupacion_emp');
              $anio_afiliacion = $this->input->post('anio_afiliacion');
              $estado_afiliacion = $this->input->post('estado_afiliacion');

              for ($agru_emp=0; $agru_emp < count($agrupacion_emp) ; $agru_emp++) { 
                  if (trim($agrupacion_emp[$agru_emp]) != '') {
                     $array_insert_reg = array(
                      'ags_nombre' => $agrupacion_emp[$agru_emp],
                      'ags_anio_afiliacion' => ($anio_afiliacion[$agru_emp] >0)? $anio_afiliacion[$agru_emp]:null,
                      'ags_estado_agrupacion' => ($estado_afiliacion[$agru_emp] >0)? 1:0,
                      'ags_id_sle' => $emp_id,
                      'ags_estado' => 1,
                      'ags_usu_creacion' => $this->tank_auth->get_user_id(),
                      'ags_usu_modificacion' => $this->tank_auth->get_user_id(),
                      'ags_fecha_creacion' => date('Y-m-d H:i:s'),
                      'ags_fecha_modificacion' => date('Y-m-d H:i:s')
                     );

                     $id_age = $this->gsatelite->ingresar('ags_agrupacion_solicitante', $array_insert_reg);
                  }
              }

              /* =================================================================================================================
                =                              FIN GUARDADO DE AGRUPACIONES EMPLEADO
                ===================================================================================================================
               */

             /* =================================================================================================================
             =                              INICIO GUARDADO DE SERVICION BASICOS EMPLEADO
             ===================================================================================================================
            */
                $this->gsatelite->borrado_general('srs_servicio_solicitante',array('srs_id_sle'=>$emp_id));
                 $slcServiciosBasicos = $this->input->post('slcServiciosBasicos');
                 for ($sbi = 0; $sbi < count($slcServiciosBasicos); $sbi++) {
                     if ($slcServiciosBasicos[$sbi] > 0 ) {
                         $array_insert_reg = array(
                          'srs_id_srb' => $slcServiciosBasicos[$sbi],
                          'srs_id_sle' => $emp_id,
                          'srs_estado' => 1,
                          'srs_usu_creacion' => $this->tank_auth->get_user_id(),
                          'srs_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'srs_fecha_creacion' => date('Y-m-d H:i:s'),
                          'srs_fecha_modificacion' => date('Y-m-d H:i:s')
                         );

                         $id_sre = $this->gsatelite->ingresar('srs_servicio_solicitante', $array_insert_reg);
                     }
                 }

              /* =================================================================================================================
              =                              FIN GUARDADO DE SERVICION BASICOS EMPLEADO
              ===================================================================================================================
             */

             //entrevista

                 $this->gsatelite->borrado_general('ens_entrevista_solicitante_empleo',array('ens_id_sle'=>$emp_id));
                  $ens_id = $this->input->post('ens_id');
                  $tipo_entrevista = $this->input->post('tipo_entrevista');
                  $fecha_entrevista = $this->input->post('fecha_gen');
                  $lugar_entrevista = $this->input->post('lugar_ent');
                  $ponderacion_entrevista = $this->input->post('ponde_ent');
                  $descripcion_entrevista = $this->input->post('descr_ent');
                  $nombre_realizo = $this->input->post('nom_entre');

                  foreach ($ens_id as $key => $nomcap) {
                      $array_entrevista = array(                                                  
                          'ens_id_tnv' => $tipo_entrevista[$key],
                          'ens_id_sle' => $emp_id,
                          'ens_fecha' => formatear_fecha("Y-m-d",$fecha_entrevista[$key]),
                          'ens_persona_realiza' => $nombre_realizo[$key],
                          'ens_lugar' => $lugar_entrevista[$key],
                          'ens_ponderacion' => $ponderacion_entrevista[$key],
                          'ens_descripcion' => $descripcion_entrevista[$key],                      
                          'ens_estado' => 1,
                          'ens_usu_creacion' => $this->tank_auth->get_user_id(),
                          'ens_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'ens_fecha_creacion' => date('Y-m-d H:i:s'),
                          'ens_fecha_modificacion' => date('Y-m-d H:i:s')
                      );
                      $id_ens = $this->gsatelite->ingresar('ens_entrevista_solicitante_empleo', $array_entrevista);                    
                  }

                  //PRUEBASSSSSS

                  $this->gsatelite->borrado_general('pse_pruebas_solicitante_empleo',array('pse_id_sle'=>$emp_id));
                  $pse_id = $this->input->post('pse_id');
                  $tipo_prueba = $this->input->post('tipo_prueba');
                  $nombre_realizo_prueba = $this->input->post('nom_prueba');
                  $fecha_prueba = $this->input->post('fecha_prueba');
                  $lugar_prueba = $this->input->post('lugar_prueba');
                  $nota_prueba = $this->input->post('nota_prueba');
                  $descripcion_prueba = $this->input->post('descr_prueba');

                  foreach ($pse_id as $key => $value) {
                      $array_prueba = array(                                                  
                          'pse_id_tib' => $tipo_prueba[$key],
                          'pse_id_sle' => $emp_id,
                          'pse_fecha' => formatear_fecha("Y-m-d",$fecha_prueba[$key]),
                          'pse_persona_califica' => $nombre_realizo_prueba[$key],
                          'pse_lugar' => $lugar_prueba[$key],
                          'pse_resultado' => $nota_prueba[$key],
                          'pse_descripcion' => $descripcion_prueba[$key],                      
                          'pse_estado' => 1,
                          'pse_usu_creacion' => $this->tank_auth->get_user_id(),
                          'pse_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'pse_fecha_creacion' => date('Y-m-d H:i:s'),
                          'pse_fecha_modificacion' => date('Y-m-d H:i:s')
                      );
                      $id_pse = $this->gsatelite->ingresar('pse_pruebas_solicitante_empleo', $array_prueba);                    
                  }

                  


            /* ===============================================================================================================================
              =                                         ACTUALIZACION
              =================================================================================================================================
             */

            $rutas = $this->input->post("ruta");
            $carpeta = $this->input->post("nombreCarpeta");
            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $this->input->post("titulo_doc" . $i);
                        $this->datos_imagen_gral($img, $emp_id, $carpeta, $titulo);
                    }
                }
            }
            // here-
            $id_foto = $this->input->post('id_foto');
            $foto_editar = $this->input->post('edit_foto');


            if (trim($foto_editar) != "") {
                $img = $foto_editar;
                $titulo = $this->input->post("titulo_edit");
                $eliminar = $this->input->post('foto_eliminar');
                if (!empty($eliminar)) {
                    $this->datos_reemplazar_imagen($img, $id_foto, $carpeta, $titulo, $eliminar);
                } else {
                    $this->datos_imagen_gral($foto_editar, $emp_id, $carpeta, $titulo, 1);
                }
            }

                $redireccion = $this->input->post('redireccion');
                $id          = $this->input->post('id');
                $tipo        = $this->input->post('txttipo');
                $alerta      = array('tipo_alerta' => 'success', 'titulo_alerta' => "El registro fue actualizado correctamente", 'texto_alerta' => "Actualización de datos del solicitante completo");

                $this->session->set_flashdata($alerta);
                if ($redireccion == 1) {
                    redirect('modulo_seleccion_personal/slp_procesos/editar_ficha_solicitante/'.$id.'/2');
                } else {
                    redirect('modulo_seleccion_personal/slp_procesos/solicitante_empleo');
                }
            
        }
    }

    public function editar_ficha_solicitante($emp_id, $tipo, $ver_detalle = null){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');   
        } else {
            $registro = $this->gsatelite->get_registro('sle_solicitante_empleo', 'sle_id', $emp_id);
            //$data['genero'] = $this->personal_model->get_genero();
            //$data['nacionalidad'] = $this->personal_model->get_nacionalidad();
            $data['estado_civil'] = $this->personal_model->get_estado_civil();
            $data['profesion'] = $this->personal_model->get_profesion();
            $data['tipo_telefono'] = $this->personal_model->get_tipotelefono();
            $data['afp'] = $this->personal_model->get_afp();
            $data['doc_documentos'] = $this->personal_model->get_documentos();
            $data['parentescos_cat'] = $this->personal_model->get_parentesco();
            $data['informacion'] = $informacion = $this->gsatelite->get_tabla('sle_solicitante_empleo', array('sle_id' => $emp_id));
            $data['departamento'] = $this->personal_model->get_departamento();
            $data['telefonos'] = $this->personal_model->get_telefonos_solicitante(array('tsl_id_sle' => $emp_id,'tsl_estado' => 1));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $tel_sty = 'style="display:none;"';
            if (!(empty($data['telefonos']))) {
                $tel_sty = '';
            }
            $data['tel_sty'] = $tel_sty;
            $data['alergico'] = $this->gsatelite->get_tabla('cas_componente_alergico_solicitante', array('cas_estado' => 1, 'cas_id_sle' => $emp_id));
            $data['enfermedad'] = $this->gsatelite->get_tabla('exs_enfermedaxsolicitante', array('exs_estado' => 1, 'exs_id_sle' => $emp_id));
            $data['enf_select'] = $this->gsatelite->get_tabla('enf_enfermedad', array('enf_estado' => 1));
            $data['alerg_select'] = $this->gsatelite->get_tabla('coa_componente_alergico', array('coa_estado' => 1));
            $data['parentescos_enf'] = $this->gsatelite->get_tabla('pat_parentesco');
            $data['documentos'] = $this->personal_model->editar_doc_solicitante($emp_id);
            $data['parentescos'] = $this->gsatelite->get_tabla('fas_familiar_solicitante',array('fas_id_sle' => $emp_id,'fas_estado' => 1));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $paren_sty = "display:none;";
            if (!(empty($data['parentescos']))) {
                $paren_sty = "";
            }
            $data['paren_sty'] = $paren_sty;
            //programas y equipo
            $select = $this->expediente_personal_model->get_dropdown('nie_nivel_experiencia', '{nie_nombre}', '', array('nie_estado' => 1), null, '', 'nie_id', true);
            $data["nivel_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('peq_programa_equipo', '{peq_nombre}', '', array('peq_estado' => 1), null, '', 'peq_id', true);
            $data["tipo_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = "";
            $datos = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 2));
            foreach ($datos as $key) {
                $select .= '<option value = "' . $key['cer_id'] . '">' . $key['cer_nombre'] . '</option>';
            }
            $data["cert_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('icp_institucion_capacitacion', '{icp_nombre}', '', array('icp_estado' => 1), null, '', 'icp_id', true);
            $data["institucion_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('mde_modalidad_estudio', '{mde_nombre}', '', array('mde_estado' => 1), null, '', 'mde_id', true);
            $data["modalidad_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $data['nivel_programa_select2'] = $this->gsatelite->get_tabla('nie_nivel_experiencia', array('nie_estado' => 1,));
            $data['tipo_programa_select2'] = $this->gsatelite->get_tabla('peq_programa_equipo', array('peq_estado' => 1));
            $data['cert_programa_select2'] = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 2));
            $data['institucion_programa_select2'] = $this->gsatelite->get_tabla('icp_institucion_capacitacion', array('icp_estado' => 1));
            $data['modalidad_programa_select2'] = $this->gsatelite->get_tabla('mde_modalidad_estudio', array('mde_estado' => 1));
            $data['programa'] = $this->gsatelite->get_tabla('pxs_programaxsolicitante', array('pxs_estado' => 1, 'pxs_id_sle' => $emp_id));
            $data['programa_certificacion'] = $this->gsatelite->get_tabla('cps_certificacion_programa_solicitante', array('cps_estado' => 1, 'cps_id_sle' => $emp_id));
            $program_sty = "display:none;";
            if (!(empty($data['tipo_programa_select2']))) {
                $program_sty = "";
            }
            $data['program_sty'] = $program_sty;
            $program_cert_sty = "display:none;";
            if (!(empty($data['programa_certificacion']))) {
                $program_cert_sty = "";
            }
            $data['program_cert_sty'] = $program_cert_sty;
            $data['anexos'] = $this->personal_model->anexo_solicitante($emp_id);
            $data['foto'] = $this->personal_model->foto_solicitante($emp_id);
            $data['tipo'] = $tipo;
            /* ============================================================================================
              =                 DATOS DE LOS IDIOMAS
              ==============================================================================================             */
            //controles para los select
            $select = $this->expediente_personal_model->get_dropdown('idm_idioma', '{idm_nombre}', '', null, null, '', 'idm_id', true);
            $data["idm_idioma"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('nii_nivel_idioma', '{nii_nombre}', '', null, null, '', 'nii_id', true);
            $data["nivel_idioma"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = "";
            $datos = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 1));
            foreach ($datos as $key) {
                $select .= '<option value = "' . $key['cer_id'] . '">' . $key['cer_nombre'] . '</option>';
            }
            $data["cert_idioma_d"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            //fin de controles
            //tablas para mostrar los idiomas y certificacion del empleado
            $data['idiomas'] = $this->gsatelite->get_tabla('ids_idioma_solicitante', array('ids_estado' => 1, 'ids_id_sle' => $emp_id));
            $data['certificado'] = $this->gsatelite->get_tabla('cis_certificacion_idioma', array('cis_estado' => 1, 'cis_id_sle' => $emp_id));
            //idiomas
            $data['select_idiomas'] = $this->gsatelite->get_tabla('idm_idioma', array('idm_estado' => 1));
            $data['select_nivel'] = $this->gsatelite->get_tabla('nii_nivel_idioma', array('nii_estado' => 1));
            //certificado
            $data['select_certificacion'] = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 1));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $idi_sty = 'style = "display:none"';
            $cer_sty = 'style = "display:none"';
            if (!(empty($data['idiomas']))) {
                $idi_sty = '';
            }
            if (!(empty($data['certificado']))) {
                $cer_sty = '';
            }
            $data['tabla_idm'] = $idi_sty;
            $data['tabla_cer'] = $cer_sty;
            /* ============================================================================================
              =                 DATOS DE LAS REFERENCIAS PERSONALES
              ============================================================================================             */
            //controles para los select
            $select = $this->expediente_personal_model->get_dropdown('trr_tipo_referencia', '{trr_nombre}', '', array('trr_estado' => 1), null, '', 'trr_id', true);
            $data["tipo_referencia"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            //tabla relacionada con el empleado
            $data["referencia_personal"] = $this->gsatelite->get_tabla('rps_referencia_personal_solicitante', array('rps_estado' => 1, 'rps_id_sle' => $emp_id));
           // print_r($data['referencia_personal']); die();
            //tablas para mostrar los idiomas y certificacion del empleado
            $data['tipo_referencia_select'] = $this->gsatelite->get_tabla('trr_tipo_referencia', array('trr_estado' => 1));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $refpersonal_sty = 'style = "display:none"';
            if (!(empty($data['referencia_personal']))) {
                $refpersonal_sty = '';
            }
            $data['refpersonal_sty'] = $refpersonal_sty;
            /* ============================================================================================
              =                 DATOS DE LAS REFERENCIAS PERSONALES
              =============================================================================================             */
            //tabla relacionada con el empleado
            $data["referencia_laboral"] = $this->gsatelite->get_tabla('rls_referencia_laboral_solicitante', array('rls_estado' => 1, 'rls_id_sle' => $emp_id));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $reflaboral_sty = 'display:none;';
            if (!(empty($data['referencia_laboral']))) {
                $reflaboral_sty = '';
            }
            $data['reflaboral_sty'] = $reflaboral_sty;            
            /* ============================================================================================
              =                 INSUMOS EMPLEADO
              ==============================================================================================
             */                    
            $data["insumos_grid"] = $this->expediente_personal_model->get_insumos_soli(array('ise_estado' => 1,'ise_id_sle' => $emp_id));            
            /* ============================================================================================
              =                 INSUMOS EMPLEADO
              ==============================================================================================
             */                    
            $data["capacitaciones_grid"] = $this->expediente_personal_model->get_capacitaciones_soli(array('ccs_estado' => 1,'ccs_id_sle' => $emp_id));            
            /* ============================================================================================
              =                     DATOS ACADEMICOS
              ==============================================================================================
             */
            //tabla relacionada con el empleado
            $data["datos_academicos"] = $this->gsatelite->get_tabla('das_dato_academico_solicitante', array('das_estado' => 1, 'das_id_sle' => $emp_id));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $datacademic_sty = 'style = "display:none"';
            if (!(empty($data['datos_academicos']))) {
                $datacademic_sty = '';
            }
            $data['datacademic_sty'] = $datacademic_sty;
            $select = $this->expediente_personal_model->get_dropdown('tie_tipo_educacion', '{tie_nombre}', '', array('tie_estado' => 1), null, '', 'tie_id', true);
            $data["tipo_educacion"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('pro_profesion', '{pro_nombre}', '', array('pro_estado' => 1), $registro->sle_id_pro,'', 'pro_id', true);
            $data["pro_profesion"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('ina_institucion_academica', '{ina_nombre}', '', array('ina_estado' => 1), null, '', 'ina_id', true);
            $data["institucion_academica"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('ese_estado_estudio', '{ese_nombre}', '', array('ese_estado' => 1), null, '', 'ese_id', true);
            $data["estado_estudio"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select2 = $this->expediente_personal_model->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), null, '', 'pai_id', true);
            $data["pai_pais"] = str_replace('<option value="0">Seleccione</option>', '', $select2);
            $select = $this->expediente_personal_model->get_dropdown('exl_experiencia_laboral', '{exl_nombre}', '', array('exl_estado' => 1), null, '', 'exl_id', true);
            $data["experiencia_laboral"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $data["sel_tipo_educacion"] = $this->expediente_personal_model->get_select('tie_tipo_educacion', array('tie_nombre', 'asc'), array('tie_estado' => 1));
            $data["sel_pro_profesion"] = $this->expediente_personal_model->get_select('pro_profesion', array('pro_nombre', 'asc'), array('pro_estado' => 1));
            $data["sel_institucion_academica"] = $this->expediente_personal_model->get_select('ina_institucion_academica', array('ina_nombre', 'asc'), array('ina_estado' => 1));
            $data["sel_estado_estudio"] = $this->expediente_personal_model->get_select('ese_estado_estudio', array('ese_nombre', 'asc'), array('ese_estado' => 1));
            $data["sel_pai_pais"] = $this->expediente_personal_model->get_select('pai_pais', array('pai_nombre', 'asc'), array('pai_estado' => 1));
            $data["sel_experiencia_laboral"] = $this->expediente_personal_model->get_select('exl_experiencia_laboral', array('exl_nombre', 'asc'), array('exl_estado' => 1));
            $select = $this->gsatelite->get_dropdown('hab_habilidad', '{hab_nombre}', '', array('hab_estado' => 1), null, '', 'hab_id', true);
            $data["habilidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('nih_nivel_habilidad', '{nih_nombre}', '', array('nih_estado' => 1), null, '', 'nih_id', true);
            $data["nivel_habilidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $data['habilidades_emple'] = $this->expediente_personal_model->get_habilidades_solicitante(array('hxs_id_sle'=>$emp_id));
            $data['agrupaciones_emple'] = $this->gsatelite->get_tabla('ags_agrupacion_solicitante',array('ags_id_sle'=>$emp_id));
            $select = $this->gsatelite->get_dropdown('zon_zona', '{zon_nombre}', '', array('zon_estado' => 1), $registro->sle_id_zon, '', 'zon_id', true);
            $data["slcZona"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tiv_tipo_vivienda', '{tiv_nombre}', '', array('tiv_estado' => 1), $registro->sle_id_tiv, '', 'tiv_id', true);
            $data["slcTipoCasa"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tcv_tipo_construccion_vivienda', '{tcv_nombre}', '', array('tcv_estado' => 1), $registro->sle_id_tcv, '', 'tcv_id', true);
            $data["slcTipoConstruccion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $servicicios_emp  = array();
            $reg_srv = $this->gsatelite->get_tabla('srs_servicio_solicitante',array('srs_id_sle'=>$emp_id));
            foreach ($reg_srv as $rs) {
                $servicicios_emp[]=$rs['srs_id_srb'];
            }
            //print_r( $reg_srv); die();
            $select = $this->gsatelite->get_dropdown('srb_servicio_basico', '{srb_nombre}', '', array('srb_estado' => 1), $servicicios_emp, '', 'srb_id', true);
            $data["slcServiciosBasicos"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $reg_municipio = $this->gsatelite->get_tabla('mun_municipio',array('mun_id'=>$registro->sle_id_mun));
            $id_departamento =  ($reg_municipio)? $reg_municipio[0]['mun_id_dep']:null;
            $id_municipio =  ($reg_municipio)? $reg_municipio[0]['mun_id']:null;
            $select = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', array('dep_estado' => 1), $id_departamento, '', 'dep_id', true);
            $data["slcDepartamento"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('pai_pais', '{pai_nacionalidad}', '', array('pai_estado' => 1), $registro->sle_id_pai, '', 'pai_id', true);
            $data["slcNacionalidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', array('mun_estado' => 1, 'mun_id_dep' => $id_departamento), $id_municipio, '', 'mun_id', true);
            $data["slcMunicipio"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tps_tipo_salario', '{tps_nombre}', '', array('tps_estado' => 1), $registro->sle_id_tps, '', 'tps_id', true);
            $data["slcTipoSalario"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('cta_categoria_aguinaldo', '{cta_nombre}', '', array('cta_estado' => 1), $registro->sle_id_cta, '', 'cta_id', true);
            $data["slcCatAguinaldo"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('fnr_fuente_reclutamiento', '{fnr_nombre}', '', array('fnr_estado' => 1), $registro->sle_id_fnr, '', 'fnr_id', true);
            $data["slcFuenteReclutamiento"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tpc_tipo_cuenta', '{tpc_nombre}', '', array('tpc_estado' => 1), $registro->sle_id_tpc, '', 'tpc_id', true);
            $data["slcTipoCuenta"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('gen_genero', '{gen_nombre}', '', array('gen_estado' => 1), $registro->sle_id_gen, '', 'gen_id', true);
            $data["genero"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            //Tab insumos
            $select = $this->gsatelite->get_dropdown('tim_tipo_insumo', '{tim_nombre}', '', array('tim_estado' => 1), null, '', 'tim_id', true);
            $data["slcTipoInsumo"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            //Tab capacitaciones            
            $select = $this->gsatelite->get_dropdown('icp_institucion_capacitacion', '{icp_nombre}', '', array('icp_estado' => 1), null, '', 'icp_id', true);
            $data["slcInstitucionCapacitacion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            $select = $this->gsatelite->get_dropdown('ese_estado_estudio', '{ese_nombre}', '', array('ese_estado' => 1), null, '', 'ese_id', true);
            $data["slcEstadoEstudio"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $data['ver_detalle']  = ($ver_detalle == null || $ver_detalle == 0) ? null : $ver_detalle;

            // Tipo entrevista
            $select = $this->gsatelite->get_dropdown('tnv_tipo_entrevista', '{tnv_nombre}', '', array('tnv_estado' => 1), null, '', 'tnv_id', true);
            $data["slc_entrevista"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $this->db->join('tnv_tipo_entrevista', 'ens_id_tnv = tnv_id',"left");
            $data["entrevista_solicitante"] = $this->gsatelite->get_tabla('ens_entrevista_solicitante_empleo', array('ens_id_sle'=>$registro->sle_id));

            // Tipo prueba
            $select = $this->gsatelite->get_dropdown('tib_tipo_prueba', '{tib_nombre}', '', array('tib_estado' => 1), null, '', 'tib_id', true);
            $data["slc_pruebas"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $this->db->join('tib_tipo_prueba', 'pse_id_tib = tib_id',"left");
            $data["prueba_solicitante"] = $this->gsatelite->get_tabla('pse_pruebas_solicitante_empleo', array('pse_id_sle'=>$registro->sle_id));
            //print_r($data["entrevista_solicitante"]);die();

            if($informacion[0]['sle_codigo']!=''){
                $data['codigo'] = $informacion[0]['sle_codigo'];
            }else{
                $last=$this->consultas->get_max_codigo('sle_solicitante_empleo','sle_codigo');
                $code=$last->codigo;
                $cod= (float)$code+1;
                $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                $data['codigo'] = $codigo;
            }

            $titulo['titulo_personal'] = "Editar solicitante";

            //Datos de concursos
            $ids              = array_column($this->gsatelite->get_tabla('csp_concurso_xsolicitante_empleo',array('csp_id_sle' => $emp_id,'csp_estado' => 1)), 'csp_id_cnp');
            $select           = $this->gsatelite->get_dropdown('cnp_concurso_plaza', 'cnp_nombre', '', array('cnp_estado' => 2), $ids, '', 'cnp_id', true);
            $data['slex']     = $emp_id;
            $data["concurso"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $data['existentes']  = $this->seleccion_personal_model->get_solicitantesxconcurso(array('cnp_estado in (2,3)' => null,'csp_estado' => 1,'sle_id' => $emp_id));
            if ($ver_detalle == 1) {
                $titulo['titulo_personal'] = "Ver datos del solicitante";
                cargarvista($titulo, $data, 'modulo_seleccion_personal/slp_procesos/ver_ficha_solicitante');
            } else {
                $this->_cargarvista($titulo, $data);
            }            
        }
    }


    /**
    *@author Nelson Soriano
    *@since  21-06-2019
    *@param  ID solicitante
    *@return Estado de la transaccion
    *
    **/

      public function traslado_solicitante($id_solicitante = null,$viene_concurso = null){
        satelite_validar();
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');   
        } else {
            // creamos el codigo del empleado
            $id_sle = (int) $id_solicitante;
            if ($id_sle > 0) {
                $last=$this->consultas->get_max_codigo('emp_empleado','emp_codigo');
                $code=$last->codigo;
                $cod= (float)$code+1;
                $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                // Si viene de un concurso procesamos la area y plaza
                $plaza_cnp = null;
                $area_cnp  = null;
                if ($viene_concurso != null) {
                    $plaza_cnp = ($this->gsatelite->get_campo('cnp_concurso_plaza','cnp_id_plz',array('cnp_id' => $viene_concurso)) != '') ? $this->gsatelite->get_campo('cnp_concurso_plaza','cnp_id_plz',array('cnp_id' => $viene_concurso)) : null;
                    $area_cnp  = ($this->gsatelite->get_campo('cnp_concurso_plaza','cnp_id_are',array('cnp_id' => $viene_concurso)) != '') ? $this->gsatelite->get_campo('cnp_concurso_plaza','cnp_id_are',array('cnp_id' => $viene_concurso)) : null;
                }

                $datos_solicitante  = $this->gsatelite->get_registro('sle_solicitante_empleo',array('sle_id' => $id_sle));
                $nuevo = array(
                    'emp_id_suc'    =>  ($datos_solicitante->sle_id_suc != '')?$datos_solicitante->sle_id_suc:null,
                    'emp_id_plz'    =>  $plaza_cnp,
                    'emp_id_afp'    =>  ($datos_solicitante->sle_id_afp != '')?$datos_solicitante->sle_id_afp:null,
                    'emp_id_emr'    =>  ($datos_solicitante->sle_id_emr != '')?$datos_solicitante->sle_id_emr:null,
                    'emp_nombre'    =>  ($datos_solicitante->sle_nombre != '')?$datos_solicitante->sle_nombre:null,
                    'emp_apellido'  =>  ($datos_solicitante->sle_apellido != '')?$datos_solicitante->sle_apellido:null,
                    'emp_estado'    =>  ($datos_solicitante->sle_estado != '')?$datos_solicitante->sle_estado:null,
                    'emp_direccion' =>  ($datos_solicitante->sle_direccion != '')?$datos_solicitante->sle_direccion:null,
                    'emp_id_are'    =>  $area_cnp,
                    'emp_lugar_nac' =>  ($datos_solicitante->sle_lugar_nac != '')?$datos_solicitante->sle_lugar_nac:null,
                    'emp_id_pai'    =>  ($datos_solicitante->sle_id_pai != '')?$datos_solicitante->sle_id_pai:null,
                    'emp_fecha_nac' =>  ($datos_solicitante->sle_fecha_nac != '')?$datos_solicitante->sle_fecha_nac:null,
                    'emp_id_gen'    =>  ($datos_solicitante->sle_id_gen != '')?$datos_solicitante->sle_id_gen:null,
                    //'emp_id_cnt'    =>  ($datos_solicitante->sle_id_cnt != '')?$datos_solicitante->sle_id_cnt:null,
                    'emp_id_pro'    =>  ($datos_solicitante->sle_id_pro != '')?$datos_solicitante->sle_id_pro:null,
                    'emp_id_esc'    =>  ($datos_solicitante->sle_id_esc != '')?$datos_solicitante->sle_id_esc:null,
                    'emp_fecha_contrato' => ($datos_solicitante->sle_fecha_contrato != '')?$datos_solicitante->sle_fecha_contrato:null,
                    'emp_fecha_retiro'   => ($datos_solicitante->sle_fecha_retiro != '')?$datos_solicitante->sle_fecha_retiro:null,
                    'emp_salario'        => ($datos_solicitante->sle_salario != '')?$datos_solicitante->sle_salario:null,
                    'emp_salario_hora'   => ($datos_solicitante->sle_salario_hora != '')?$datos_solicitante->sle_salario_hora:null,
                    'emp_salario_hora_nocturna' => ($datos_solicitante->sle_salario_hora_nocturna != '')?$datos_solicitante->sle_salario_hora_nocturna:null,
                    'emp_metodo_pago'   =>  ($datos_solicitante->sle_metodo_pago != '')?$datos_solicitante->sle_metodo_pago:null,
                    'emp_usu_mod'       => $this->tank_auth->get_user_id(),
                    'emp_fecha_mod'     => date('Y-m-d H:m:s'),
                    'emp_usu_crea'      => $this->tank_auth->get_user_id(),
                    'emp_fecha_crea'    => date('Y-m-d H:m:s'),
                    'emp_codigo'        => $codigo,
                    'emp_afp'           => ($datos_solicitante->sle_afp != '')?$datos_solicitante->sle_afp:null,
                    'emp_seguro'        => ($datos_solicitante->sle_seguro != '')?$datos_solicitante->sle_seguro:null,
                    'emp_id_ban'        => ($datos_solicitante->sle_id_ban != '')?$datos_solicitante->sle_id_ban:null,
                    'emp_numero_cuenta' => ($datos_solicitante->sle_numero_cuenta != '')?$datos_solicitante->sle_numero_cuenta:null,
                    'emp_observacion_contrato' => ($datos_solicitante->sle_observacion_contrato != '')?$datos_solicitante->sle_observacion_contrato:null,
                    'emp_id_tic'               => ($datos_solicitante->sle_id_tic != '')?$datos_solicitante->sle_id_tic:null,
                    'emp_id_pat_contacto'      => ($datos_solicitante->sle_id_pat_contacto != '')?$datos_solicitante->sle_id_pat_contacto:null,
                    'emp_estatura'             => ($datos_solicitante->sle_estatura != '')?$datos_solicitante->sle_estatura:null,
                    'emp_peso'                 => ($datos_solicitante->sle_peso != '')?$datos_solicitante->sle_peso:null,
                    'emp_tipo_sangre'          => ($datos_solicitante->sle_tipo_sangre != '')?$datos_solicitante->sle_tipo_sangre:null,
                    'emp_id_tsr'               => ($datos_solicitante->sle_id_tsr != '')?$datos_solicitante->sle_id_tsr:null,
                    'emp_discapacidad'         => ($datos_solicitante->sle_discapacidad != '')?$datos_solicitante->sle_discapacidad:0,
                    'emp_id_tds'               => ($datos_solicitante->sle_id_tds != '')?$datos_solicitante->sle_id_tds:null,
                    'emp_observacion_clinica'  => ($datos_solicitante->sle_observacion_clinica != '')?$datos_solicitante->sle_observacion_clinica:null,
                    'emp_contacto_emergencia'  => ($datos_solicitante->sle_contacto_emergencia != '')?$datos_solicitante->sle_contacto_emergencia:null,
                    'emp_direccion_emergencia' => ($datos_solicitante->sle_direccion_emergencia != '')?$datos_solicitante->sle_direccion_emergencia:null,
                    'emp_telefono_emergencia'  => ($datos_solicitante->sle_telefono_emergencia != '')?$datos_solicitante->sle_metodo_pago:null,
                    'emp_id_zon'        =>        ($datos_solicitante->sle_id_zon != '')?$datos_solicitante->sle_id_zon:null,
                    'emp_id_tiv'        =>        ($datos_solicitante->sle_id_tiv != '')?$datos_solicitante->sle_id_tiv:null,
                    'emp_id_tcv'        =>        ($datos_solicitante->sle_id_tcv != '')?$datos_solicitante->sle_id_tcv:null,
                    'emp_expediente'    =>        ($datos_solicitante->sle_expediente != '')?$datos_solicitante->sle_expediente:null,
                    'emp_id_mun'        =>        ($datos_solicitante->sle_id_mun != '')?$datos_solicitante->sle_id_mun:null,
                    'emp_id_pai'        =>        ($datos_solicitante->sle_id_pai != '')?$datos_solicitante->sle_id_pai:null,
                    'emp_es_reingreso'  =>        ($datos_solicitante->sle_es_reingreso != '')?$datos_solicitante->sle_es_reingreso:null,
                    'emp_es_jubilado'   =>        ($datos_solicitante->sle_es_jubilado != '')?$datos_solicitante->sle_es_jubilado:0,
                    'emp_fecha_jubilado' =>       ($datos_solicitante->sle_fecha_jubilado != '')?$datos_solicitante->sle_fecha_jubilado:null,
                    'emp_id_tps' =>               ($datos_solicitante->sle_id_tps != '')?$datos_solicitante->sle_id_tps:null,
                    'emp_id_cta' =>               ($datos_solicitante->sle_id_cta != '')?$datos_solicitante->sle_id_cta:null,
                    'emp_id_fnr' =>               ($datos_solicitante->sle_id_fnr != '')?$datos_solicitante->sle_id_fnr:null,
                    'emp_realizo_poligrafo' =>    ($datos_solicitante->sle_realizo_poligrafo != '')?$datos_solicitante->sle_realizo_poligrafo:0,
                    'emp_codigo_referencia' =>    ($datos_solicitante->sle_codigo_referencia != '')?$datos_solicitante->sle_codigo_referencia:null,
                    'emp_id_tpc'        =>        ($datos_solicitante->sle_id_tpc != '')?$datos_solicitante->sle_id_tpc:null,
                    'emp_aplica_afp'    =>        ($datos_solicitante->sle_aplica_afp != '')?$datos_solicitante->sle_aplica_afp:null,
                    'emp_aplica_isss'   =>        ($datos_solicitante->sle_aplica_isss != '')?$datos_solicitante->sle_aplica_isss:null,
                    'emp_fecha_ult_liquidacion' =>($datos_solicitante->sle_fecha_ult_liquidacion != '')?$datos_solicitante->sle_fecha_ult_liquidacion:null, 
                    'emp_fecha_fin_contrato' =>   ($datos_solicitante->sle_fecha_fin_contrato != '')?$datos_solicitante->sle_fecha_fin_contrato:null, 
                    'emp_fecha_antiguedad' =>     ($datos_solicitante->sle_fecha_antiguedad != '')?$datos_solicitante->sle_fecha_antiguedad:null,
                    'emp_fecha_ult_aguinaldo'=>   ($datos_solicitante->sle_fecha_ult_aguinaldo != '')?$datos_solicitante->sle_fecha_ult_aguinaldo:null,
                    'emp_fecha_ult_vacacion'=>    ($datos_solicitante->sle_fecha_ult_vacacion != '')?$datos_solicitante->sle_fecha_ult_vacacion:null,
                    'emp_id_origen_traslado' => $this->tank_auth->get_user_id(),
                    'emp_fecha_traslado' => date('Y-m-d H:m:s'),
                    'emp_id_emr_tralado' => ($datos_solicitante->sle_id_emr != '')?$datos_solicitante->sle_id_emr:null
                );
                $this->db->insert('emp_empleado', $nuevo);
                $emp_id = $this->db->insert_id();

                // correos del solicitante
                $correos  = $this->gsatelite->get_tabla('cse_correo_solicitante_empleo',array('cse_id_sle' => $id_sle,'cse_estado' => 1));
                foreach ($correos as $key => $value) {
                    $this->db->insert('cxp_correoxempleado', array(
                        'cxp_id_emp' => $emp_id,
                        'cxp_correo' => $value['cse_correo'],
                        'cxp_estado' => 1,
                        'cxp_usu_mod' => $this->tank_auth->get_user_id(),
                        'cxp_fecha_mod' => date('Y-m-d H:i:s')
                    ));
                }

                //Telefonos
                $telefonos  = $this->gsatelite->get_tabla('tsl_telefono_solicitante', array('tsl_id_sle' => $id_sle,'tsl_estado ' => 1));             
                foreach ($telefonos as $key => $tel) {
                    $this->db->insert('tel_telefono', array(
                        'tel_numero' => $tel['tsl_numero'],
                        'tel_id_tit' => $tel['tsl_id_tit'],
                        'tel_estado' => 1,
                        'tel_usu_crea' => $this->tank_auth->get_user_id(),
                        'tel_usu_mod' => $this->tank_auth->get_user_id(),
                        'tel_fecha_crea' => date('Y-m-d H:i:s'),
                        'tel_fecha_mod' => date('Y-m-d H:i:s')
                    ));
                    $tel_id = $this->db->insert_id();
                    $this->db->insert('txm_telefonoxempleado', array(
                        'txm_id_tel' => $tel_id,
                        'txm_id_emp' => $emp_id
                    ));
                }

                //Enfermedades
                $enfermedades = $this->gsatelite->get_tabla('exs_enfermedaxsolicitante',array('exs_id_sle' => $id_sle,'exs_estado' => 1));
                foreach ($enfermedades as $key => $enf) {
                    if (trim($key) != "") {
                        $this->db->insert('exe_enfermedadxempleado', array(
                            'exe_id_enf' => $enf['exs_id_enf'],
                            'exe_id_emp' => $emp_id,
                            'exe_estado' => 1,
                            'exe_fecha_creacion' => date('Y-m-d H:i:s'),
                            'exe_usu_creacion' => $this->tank_auth->get_user_id(),
                            'exe_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'exe_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    }
                }

                //componente alergico
                $componente = $this->gsatelite->get_tabla('cas_componente_alergico_solicitante', array('cas_id_sle' => $id_sle,'cas_estado' => 1));
                foreach ($componente as $key => $cas) {
                    if (trim($key) != "") {
                        $this->db->insert('cae_componente_alergico_empleado', array(
                            'cae_id_coa' => $cas['cas_id_coa'],
                            'cae_id_emp' => $emp_id,
                            'cae_estado' => 1,
                            'cae_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cae_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cae_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cae_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    }
                }

                //Documentos
                $documentos = $this->gsatelite->get_tabla('dcs_documento_solicitante',array('dcs_id_sle' => $id_sle,'dcs_estado' => 1));
                foreach ($documentos as $key => $docu) {
                    $this->db->insert('dce_documento_emp', array(
                        'dce_id_tde' => $docu['dcs_id_tde'],
                        'dce_id_emp' => $emp_id,
                        'dce_valor'  => $docu['dcs_valor'], 
                        'dce_fecha_registro' => date('Y-m-d H:m:s'),
                        'dce_fecha_vence' => $docu['dcs_fecha_vence'],
                        'dce_fecha_expedicion' => $docu['dcs_fecha_expedicion'],
                        'dce_lugar_expedicion' => $docu['dcs_lugar_expedicion'],
                        'dce_id_mun' => $docu['dcs_id_mun'],
                        'dce_nombre_segun_doc' => $docu['dcs_nombre_segun_doc'],
                        'dce_observacion' => $docu['dcs_observacion'],
                        'dce_nombre_anexo' => $docu['dcs_nombre_anexo'],
                        'dce_url' => $docu['dcs_url'],
                        'dce_estado' => 1,
                        'dce_usu_creacion' => $this->tank_auth->get_user_id(),
                        'dce_fecha_creacion' => date('Y-m-d H:i:s'),
                        'dce_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dce_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }

                // programas y equipos
                $programas = $this->gsatelite->get_tabla('pxs_programaxsolicitante', array('pxs_id_sle' => $id_sle ,'pxs_estado' => 1 ));
                $i = 0;
                foreach ($programas as $key => $program) {
                    $this->db->insert('pxe_programaxempleado', array(
                        'pxe_id_peq' => $program['pxs_id_peq'],
                        'pxe_id_emp' => $emp_id,
                        'pxe_id_nie' => $program['pxs_id_nie'],
                        'pxe_estado' => 1,
                        'pxe_fecha_creacion' => date('Y-m-d H:i:s'),
                        'pxe_usu_creacion' => $this->tank_auth->get_user_id(),
                        'pxe_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'pxe_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
                // Certificaciones
                $certificaciones  = $this->gsatelite->get_tabla('cps_certificacion_programa_solicitante', array('cps_id_sle' => $id_sle,'cps_estado' => 1));
                foreach ($certificaciones as $key => $certi) {
                    if($certi['cps_id_peq'] != ''){
                        $this->db->insert('cep_certificacion_programa', array(
                            'cep_id_emp' =>  $emp_id,
                            'cep_id_cer' =>  $certi['cps_id_cer'],
                            'cep_id_peq' =>  $certi['cps_id_peq'],
                            'cep_puntaje' => $certi['cps_puntaje'],
                            'cep_id_mde'  => $certi['cps_id_mde'],
                            'cep_id_icp'  => $certi['cps_id_icp'],
                            'cep_fecha_certificacion' => $certi['cps_fecha_certificacion'],
                            'cep_estado' => 1,
                            'cep_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cep_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cep_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cep_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));  
                    }             
                }

                // datos familiares
                $datos_fam = $this->gsatelite->get_tabla('fas_familiar_solicitante', array('fas_id_sle' => $id_sle,'fas_estado' => 1));
                foreach ($datos_fam as $key => $fam) {                
                    $query = array(
                        'fam_nombre' => $fam['fas_nombre'],
                        'fam_apellido' => $fam['fas_apellido'],
                        'fam_fecha_nacimiento' => $fam['fas_fecha_nacimiento'],
                        'fam_dependiente' => $fam['fas_dependiente'],
                        'fam_empresa' => $fam['fas_empresa'],
                        'fam_estado' => 1,
                        'fam_id_pat' => $fam['fas_id_pat'],
                        'fam_id_emp' => $emp_id,
                        'fam_id_emp_familiar' => $fam['fas_id_sle_familiar'],
                        'fam_reside_empleado' => $fam['fas_reside_empleado'],
                        'fam_beneficiario' =>  $fam['fas_beneficiario'],
                        'fam_porcentaje_beneficio' => $fam['fas_porcentaje_beneficio'],
                        'fam_telefono' => $fam['fas_telefono'],
                        'fam_usu_crea' => $this->tank_auth->get_user_id(),
                        'fam_fecha_crea' => date('Y-m-d H:i:s'),
                        'fam_usu_mod' => $this->tank_auth->get_user_id(),
                        'fam_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $result = $this->db->insert('fam_familiar',$query);
                }
                // Datos de idiomas
                $idiomax = $this->gsatelite->get_tabla('ids_idioma_solicitante', array('ids_id_sle' =>$id_sle,'ids_estado' => 1));
                foreach ($idiomax as $key => $idioma) {
                    $this->db->insert('iem_idioma_empleado', array(
                        'iem_id_nii' => $idioma['ids_id_nii'],
                        'iem_id_idm' => $idioma['ids_id_idm'],
                        'iem_id_emp' => $emp_id,
                        'iem_leer' =>   ($idioma['ids_leer'] != "") ? $idioma['ids_leer'] : 0,
                        'iem_escribir' => ($idioma['ids_escribir'] != "") ? $idioma['ids_escribir'] : 0,
                        'iem_hablar' => ($idioma['ids_hablar'] != "") ? $idioma['ids_hablar'] : 0,
                        'iem_traductor' => ($idioma['ids_traductor'] != "")?$idioma['ids_traductor'] : 0,
                        'iem_estado' => 1,
                        'iem_usu_creacion' => $this->tank_auth->get_user_id(),
                        'iem_fecha_creacion' => date('Y-m-d H:i:s'),
                        'iem_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'iem_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }

                // Certificacion de idiomas
                $certifica  = $this->gsatelite->get_tabla('cis_certificacion_idioma',array('cis_id_sle' => $id_sle,'cis_estado' => 1));
                foreach($certifica as $key => $certi) {
                    $this->db->insert('cri_certificacion_idioma', array(
                        'cri_id_emp' => $emp_id,
                        'cri_id_cer' => $certi['cis_id_cer'],
                        'cri_id_idm' => $certi['cis_id_idm'],
                        'cri_puntaje' => $certi['cis_puntaje'],
                        'cri_fecha_certificacion' => $certi['cis_fecha_certificacion'],
                        'cri_estado' => 1,
                        'cri_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cri_fecha_creacion' => date('Y-m-d H:i:s'),
                        'cri_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cri_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }

                // referencias personales
                $rpersonal    = $this->gsatelite->get_tabla('rps_referencia_personal_solicitante',array('rps_id_sle' => $id_sle, 'rps_estado' => 1));
                foreach($rpersonal as $key => $rpers) {
                    $this->db->insert('rfp_referencia_personal', array(
                        'rfp_id_trr' => $rpers['rps_id_trr'],
                        'rfp_id_emp' => $emp_id,
                        'rfp_nombre' => $rpers['rps_nombre'],
                        'rfp_lugar_trabajo' => $rpers['rps_lugar_trabajo'],
                        'rfp_ocupacion' => $rpers['rps_ocupacion'],
                        'rfp_telefono' => $rpers['rps_telefono'],
                        'rfp_descripcion_referencia' => $rpers['rps_descripcion_referencia'],
                        'rfp_estado' => 1,
                        'rfp_fecha_creacion' => date('Y-m-d H:i:s'),
                        'rfp_usu_creacion' => $this->tank_auth->get_user_id(),
                        'rfp_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rfp_fecha_modificacion' => date('Y-m-d H:i:s')
                    )); 
                }

                // Referencias Laborales
                $rlaboralesi = $this->gsatelite->get_tabla('rls_referencia_laboral_solicitante', array('rls_id_sle' => $id_sle,'rls_estado' => 1));
                foreach($rlaboralesi as $key => $rlaborales) {
                    $this->db->insert('rfl_referencia_laboral', array(
                        'rfl_id_emp' => $emp_id,
                        'rfl_lugar_trabajo' => $rlaborales['rls_lugar_trabajo'],
                        'rfl_direccion' => $rlaborales['rls_direccion'],
                        'rfl_telefono' => $rlaborales['rls_telefono'],
                        'rfl_puesto' => $rlaborales['rls_puesto'],
                        'rfl_jefe' => $rlaborales['rls_jefe'],
                        'rfl_salario_devengado' => $rlaborales['rls_salario_devengado'],
                        'rfl_motivo_retiro' => $rlaborales['rls_motivo_retiro'],
                        'rfl_nombre_ref' =>     $rlaborales['rls_nombre_ref'],
                        'rfl_fecha_desde' => $rlaborales['rls_fecha_desde'],
                        'rfl_fecha_hasta' => $rlaborales['rls_fecha_hasta'],
                        'rfl_referencia' => $rlaborales['rls_referencia'],
                        'rfl_estado' => 1,
                        'rfl_fecha_creacion' => date('Y-m-d H:i:s'),
                        'rfl_usu_creacion' => $this->tank_auth->get_user_id(),
                        'rfl_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rfl_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }

                // Datos Academicos
                $dacademicos = $this->gsatelite->get_tabla('das_dato_academico_solicitante',array('das_id_sle' => $id_sle,'das_estado' => 1));
                foreach ($dacademicos as $key => $dato) {
                    $this->db->insert('dac_dato_academico', array(
                        'dac_id_pai' => $dato['das_id_pai'],
                        'dac_id_tie' => $dato['das_id_tie'],
                        'dac_id_pro' => $dato['das_id_pro'],
                        'dac_id_ese' => $dato['das_id_ese'],
                        'dac_id_emp' => $emp_id,
                        'dac_id_exl' => $dato['das_id_exl'],
                        'dac_id_ina' => $dato['das_id_ina'],
                        'dac_fecha_finalizacion' => $dato['das_fecha_finalizacion'],
                        'dac_observacion' => $dato['das_observacion'],
                        'dac_anios_cursado' => $dato['das_anios_cursado'],
                        'dac_estado' => 1,
                        'dac_fecha_creacion' => date('Y-m-d H:i:s'),
                        'dac_usu_creacion' => $this->tank_auth->get_user_id(),
                        'dac_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dac_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
            }
            //Habilidades
            $habilidades = $this->gsatelite->get_tabla('hxs_habilidadxsolicitante',array('hxs_id_sle' => $id_sle, 'hxs_estado' => 1));
            foreach($habilidades as $key => $hab) { 
                   $array_insert_reg = array(
                    'hxm_id_hab' => $hab['hxs_id_hab'],
                    'hxm_id_emp' => $emp_id,
                    'hxm_id_nih' => $hab['hxs_id_nih'],
                    'hxm_estado' => 1,
                    'hxm_usu_creacion' => $this->tank_auth->get_user_id(),
                    'hxm_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'hxm_fecha_creacion' => date('Y-m-d H:i:s'),
                    'hxm_fecha_modificacion' => date('Y-m-d H:i:s')
                   );

                   $id_hxm = $this->gsatelite->ingresar('hxm_habilidadxempleado', $array_insert_reg);
                
            }

            // Agrupaciones
                $agrup  = $this->gsatelite->get_tabla('ags_agrupacion_solicitante',array('ags_id_sle' => $id_sle, 'ags_estado' => 1));
                foreach($agrup as $key => $ag) { 
                     $array_insert_reg = array(
                      'age_nombre' => $ag['ags_nombre'],
                      'age_anio_afiliacion'   => $ag['ags_anio_afiliacion'],
                      'age_estado_agrupacion' => $ag['ags_estado_agrupacion'],
                      'age_id_emp' => $emp_id,
                      'age_estado' => 1,
                      'age_usu_creacion' => $this->tank_auth->get_user_id(),
                      'age_usu_modificacion' => $this->tank_auth->get_user_id(),
                      'age_fecha_creacion' => date('Y-m-d H:i:s'),
                      'age_fecha_modificacion' => date('Y-m-d H:i:s')
                     );

                     $id_age = $this->gsatelite->ingresar('age_agrupacion_empleado', $array_insert_reg);
                  
              }

              //servicios
              $servicios = $this->gsatelite->get_tabla('srs_servicio_solicitante', array('srs_id_sle' => $id_sle,'srs_estado' => 1));
               foreach($servicios as $key => $servi) {
                   
                        $array_insert_reg = array(
                         'sre_id_srb' => $servi['srs_id_srb'],
                         'sre_id_emp' => $emp_id,
                         'sre_estado' => 1,
                         'sre_usu_creacion' => $this->tank_auth->get_user_id(),
                         'sre_usu_modificacion' => $this->tank_auth->get_user_id(),
                         'sre_fecha_creacion' => date('Y-m-d H:i:s'),
                         'sre_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $id_sre = $this->gsatelite->ingresar('sre_servicio_empleado', $array_insert_reg);
                    
                }
                // insumos empleados 
                $insumos = $this->gsatelite->get_tabla('ise_isumo_solicitante_empleo',array('ise_id_sle' => $id_sle,'ise_estado' => 1));
                foreach ($insumos as $key => $insumo) {
                    $array_ixe_insumoxempleado = array(                        
                        'ixe_id_inm' => $insumo['ise_id_inm'],
                        'ixe_id_emp' => $emp_id,
                        'ixe_cantidad' => $insumo['ise_cantidad'],
                        'ixe_costo' => $insumo['ise_costo'],
                        'ixe_fecha_entrega' => $insumo['ise_fecha_entrega'],
                        'ixe_estado' => 1,
                        'ixe_usu_creacion' => $this->tank_auth->get_user_id(),
                        'ixe_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'ixe_fecha_creacion' => date('Y-m-d H:i:s'),
                        'ixe_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $id_ixe = $this->gsatelite->ingresar('ixe_insumoxempleado', $array_ixe_insumoxempleado);                    
                }   

                //Capacitaciones

                $capacitacion = $this->gsatelite->get_tabla('ccs_capacitacion_solicitante' , array('ccs_id_sle' => $id_sle , 'ccs_estado' => 1));

                foreach ($capacitacion as $key => $cap) {
                      $array_cpe_capacitacion_empleado = array(                                                  
                          'cpe_id_emp' => $emp_id,
                          'cpe_id_ese' => $cap['ccs_id_ese'],
                          'cpe_id_icp' => $cap['ccs_id_icp'],
                          'cpe_nombre' => $cap['ccs_nombre'],
                          'cpe_duracion' => $cap['ccs_duracion'],
                          'cpe_costo_empresa' => $cap['ccs_costo_empresa'],
                          'cpe_costo_insaforp' => $cap['ccs_costo_insaforp'],
                          'cpe_costo_proveedor' => $cap['ccs_costo_proveedor'],
                          'cpe_fecha_inicio' => $cap['ccs_fecha_inicio'],
                          'cpe_fecha_fin' => $cap['ccs_fecha_fin'],                          
                          'cpe_estado' => 1,
                          'cpe_usu_creacion' => $this->tank_auth->get_user_id(),
                          'cpe_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'cpe_fecha_creacion' => date('Y-m-d H:i:s'),
                          'cpe_fecha_modificacion' => date('Y-m-d H:i:s')
                      );
                      $id_ixe = $this->gsatelite->ingresar('cpe_capacitacion_empleado', $array_cpe_capacitacion_empleado);                    
                  }  

                  //entrevista
                   $entrevistas = $this->gsatelite->get_tabla('ens_entrevista_solicitante_empleo',array('ens_id_sle' => $id_sle,'ens_estado' => 1));
                    foreach ($entrevistas as $key => $value) {
                        $array_entrevista = array(                                                  
                          'enm_id_tnv' => $value["ens_id_tnv"],
                          'enm_id_emp' => $emp_id,
                          'enm_fecha' => $value["ens_fecha"],
                          'enm_persona_realiza' => $value["ens_persona_realiza"],
                          'enm_lugar' => $value["ens_lugar"],
                          'enm_ponderacion' => $value["ens_ponderacion"],
                          'enm_descripcion' => $value["ens_descripcion"],                      
                          'enm_estado' => 1,
                          'enm_usu_creacion' => $this->tank_auth->get_user_id(),
                          'enm_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'enm_fecha_creacion' => date('Y-m-d H:i:s'),
                          'enm_fecha_modificacion' => date('Y-m-d H:i:s')
                      );
                      $id_enm = $this->gsatelite->ingresar('enm_entrevista_empleado', $array_entrevista);       
                    }

                    //pruebassssss
                   $prueba = $this->gsatelite->get_tabla('pse_pruebas_solicitante_empleo',array('pse_id_sle' => $id_sle,'pse_estado' => 1));
                    foreach ($prueba as $key => $value) {
                        $array_prueba = array(                                                  
                          'pbe_id_tib' => $value["pse_id_tib"],
                          'pbe_id_emp' => $emp_id,
                          'pbe_fecha' => $value["pse_fecha"],
                          'pbe_persona_califica' => $value["pse_persona_califica"],
                          'pbe_lugar' => $value["pse_lugar"],
                          'pbe_resultado' => $value["pse_resultado"],
                          'pbe_descripcion' => $value["pse_descripcion"],                      
                          'pbe_estado' => 1,
                          'pbe_usu_creacion' => $this->tank_auth->get_user_id(),
                          'pbe_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'pbe_fecha_creacion' => date('Y-m-d H:i:s'),
                          'pbe_fecha_modificacion' => date('Y-m-d H:i:s')
                      );
                      $id_pbe = $this->gsatelite->ingresar('pbe_prueba_empleado', $array_prueba);     
                    }

                  // Anexos
                    $anexos        = $this->gsatelite->get_tabla('ans_anexo_solicitante',array('ans_id_sle' => $id_sle,'ans_estado' => 1));
                    foreach ($anexos as $key => $ans) {
                    $url = str_replace('uploads/anexos_solicitante', 'uploads/anexos_empleados', $ans['ans_url']);
                    $array_anex    = array(
                    'anx_url'      => $url,
                    'anx_nombre'   => $ans['ans_nombre'],
                    'anx_estado'   => 1,
                    'anx_imagen'   => $ans['ans_imagen'],
                    'anx_usu_crea' => $this->tank_auth->get_user_id(),
                    'anx_usu_mod'  => $this->tank_auth->get_user_id(),
                    'anx_fecha_crea'  => date('Y-m-d H:i:s'),
                    'anx_fecha_mod'   => date('Y-m-d H:i:s'),
                    'anx_imagen'      => ($ans['ans_imagen'] != '')?$ans['ans_imagen']:0,
                    );

                    $this->db->insert("anx_anexo", $array_anex);
                    $id_anexo = $this->db->insert_id();
                    $array_anex_doc = array(
                        'axe_id_emp' => $emp_id,
                        'axe_id_anx' => $id_anexo,
                        'axe_estado' => 1,
                        'axe_usu_mod' => $this->tank_auth->get_user_id(),
                        'axe_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->db->insert("axe_anexoxempleado", $array_anex_doc);
                    //$titulo_doc      =  $ans['ans_nombre'];
                    $ruta            =  $ans['ans_url'];
                    $extencion = end(explode(".", $url));
                    $carpeta_destino = "uploads/anexos_empleados/" . $titulo_doc . time() . "." . trim($extencion) . "";
                    copy($ruta, $carpeta_destino);
                    //unlink($ruta);
                    }
                    $this->gsatelite->actualizar_array('sle_solicitante_empleo',array('sle_estado' => 2),array('sle_id' => $id_sle));
                    if ($viene_concurso !== null) {
                        return $emp_id;
                    }else{
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Solicitante trasladado con Éxito", 'texto_alerta' => "El registro se guardó correctamente");
                        if (is_null($viene_concurso)) {
                            $alerta['texto_alerta'] = "El registro se guardó correctamente, Verifique el área y plaza del empleado";
                        }
                        $this->session->set_flashdata($alerta);
                        redirect('expediente_personal/empleado/editar_empleado/'.$emp_id.'/1/0/1');
                    }           

        }

      }

     /**
     *Descripcion: funcion para el guardado de adjuntos
     **/

      public function datos_imagen_gral($img, $id_emp, $carpeta, $titulo_doc, $tipo = 0) {
        $extencion = end(explode(".", $img));
        $datos_1 = $this->session->keep_flashdata('datos_1');
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;

        $destino = "uploads/anexos_solicitante/" . $titulo_doc . time() . "." . trim($extencion) . "";
        $dir = $this->gsatelite->get_campo('ans_anexo_solicitante', 'ans_url', array('ans_url' => $destino, 'ans_estado' => 1));
   
        if (count($dir) <= 0) {
            $array_anex = array(
                'ans_id_sle' => $id_emp,
                'ans_url' => $destino,
                'ans_nombre' => $titulo_doc,
                'ans_imagen' => $tipo,
                'ans_estado' => 1,
                'ans_usu_creacion' => $this->tank_auth->get_user_id(),
                'ans_usu_modificacion' => $this->tank_auth->get_user_id(),
                'ans_fecha_creacion' => date('Y-m-d H:i:s'),
                'ans_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $this->db->insert("ans_anexo_solicitante", $array_anex);

            $id_anexo = $this->db->insert_id();
            /*
            $array_anex_doc = array(
                'axe_id_emp' => $id_emp,
                'axe_id_anx' => $id_anexo,
                'axe_estado' => 1,
                'axe_usu_mod' => $this->tank_auth->get_user_id(),
                'axe_fecha_mod' => date('Y-m-d H:i:s')
            );
            $this->db->insert("axe_anexoxempleado", $array_anex_doc);
            */
            $carpeta_destino = "uploads/anexos_solicitante/" . $titulo_doc . time() . "." . trim($extencion) . "";

            copy($ruta, $carpeta_destino);
            unlink($ruta);
        }
    }

     public function eliminar_anexo($anexo = null, $emp = null) {
        if ($_POST) {
            $anexo = $this->input->post('anexo');
            $emp = $this->input->post('emp');
        }
        if ($anexo != null && $emp != null) {
            $axe = $this->gsatelite->borrado_general('ans_anexo_solicitante', array('ans_id_sle' => $emp, 'ans_id' => $anexo));

            $where_anx = array('ans_id' => $anexo);
            $url = $this->gsatelite->get_campo('ans_anexo_solicitante', 'ans_url', $where_anx);
            $result = $this->gsatelite->borrado_general('ans_anexo', $where_anx);
            if (unlink($url)) {
                echo $result;
            }
        }
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    function datos_reemplazar_imagen($img, $id_foto, $carpeta, $titulo, $eliminar) {
        unlink($eliminar);
        $extencion = end(explode(".", $img));
        $datos_1 = $this->session->keep_flashdata('datos_1');
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        $destino = "uploads/anexos_solicitante/" . $titulo . "." . trim($extencion) . "";
        $array = array('ans_nombre' => $titulo,
            'ans_url' => $destino,
            'ans_usu_modificacion' => $this->tank_auth->get_user_id(),
            'ans_fecha_modificacion' => date('Y-m-d H:i:s'));
        $this->db->where('ans_id', $id_foto)
                ->update('ans_anexo_solicitante', $array);
        $carpeta_destino = "uploads/anexos_solicitante/" . $titulo . "." . trim($extencion) . "";

        copy($ruta, $carpeta_destino);
        unlink($ruta);
    }

    /**
    *@author Nelson Soriano
    *@since  01-07-2019
    *@param  none
    *@return Devuelve vista para generar un concurso de plaza
    *
    **/

    public function concurso_plazas(){
        satelite_validar();
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos']          = $this->gsatelite->get_permisos_opcion();
            $titulo['titulo_personal'] = 'Concurso de plazas';
                                         $this->db->join('cnp_concurso_plaza', 'cnp_id_are = are_id');//areas que poseen un concurso
            $areas                     = $this->gsatelite->get_dropdown('are_area','are_nombre','',array('are_estado' => 1),'',null,'are_id', true);
                                         $this->db->join('cnp_concurso_plaza', 'cnp_id_plz = plz_id');//solo plazas que estan en concurso
            $plaza                     = $this->gsatelite->get_dropdown('plz_plaza','plz_nombre','',array('plz_estado' => 1),'',null,'plz_id', true);
            $data['areas']             = str_replace('<option value=""></option>', '', $areas);
            $data['plazas']            = str_replace('<option value=""></option>', '', $plaza);
            $this->_cargarvista($titulo, $data);
        }
    }

    /**
    *@author Nelson Soriano
    *@since  01-07-2019
    *@param  none
    *@return confirmacion de la transaccion
    */

    public function agregar_concurso(){
        satelite_validar();
        if ($_POST) {
            // var_dump($_POST);die();
            $concurso = array(
                'cnp_id_pto'  => ($this->input->post('slcPuestos') != '')?$this->input->post('slcPuestos'):null,
                'cnp_id_are'  => ($this->input->post('slcAreas') != '')?$this->input->post('slcAreas'):null,
                'cnp_id_plz'  => ($this->input->post('slcPlazas') != '')?$this->input->post('slcPlazas'):null,
                'cnp_id_ted'  => ($this->input->post('slcTed') != '')?$this->input->post('slcTed'):null,
                'cnp_id_gen'  => ($this->input->post('slcGenero') != '')?$this->input->post('slcGenero'):null,
                'cnp_id_pai'  => ($this->input->post('slcPais') != '')?$this->input->post('slcPais'):null,
                'cnp_id_dep'  => ($this->input->post('slcDepartamento') != '')?$this->input->post('slcDepartamento'):null,
                'cnp_id_tic'  => ($this->input->post('slcTipoContratacion') != '')?$this->input->post('slcTipoContratacion'):null,
                'cnp_id_usu'  => $this->tank_auth->get_user_id(),
                'cnp_nombre'         => ($this->input->post('txtNombre') != '')?$this->input->post('txtNombre'):null,
                'cnp_edad_minima'    => ($this->input->post('slcEdadMinima') != '')?$this->input->post('slcEdadMinima'):null,
                'cnp_edad_maxima'    => ($this->input->post('slcMaxima') != '')?$this->input->post('slcMaxima'):null,
                'cnp_salario_minimo' => ($this->input->post('txtSalarioMin') != '')?$this->input->post('txtSalarioMin'):null,
                'cnp_salario_maximo' => ($this->input->post('txtSalarioMaximo') != '')?$this->input->post('txtSalarioMaximo'):null,
                'cnp_cantidad'       => ($this->input->post('txtCantidadVacantes') != '')?$this->input->post('txtCantidadVacantes'):0,
                'cnp_funcion'        => ($this->input->post('txtFunciones') != '')?$this->input->post('txtFunciones'):null,
                'cnp_descripcion'    => ($this->input->post('txtDescripcion') != '')?$this->input->post('txtDescripcion'):null,
                'cnp_fecha_desde'    => ($this->input->post('desde') != '')?date_format(date_create($this->input->post('desde')),'Y-m-d H:m:s'):null,
                'cnp_fecha_hasta'    => ($this->input->post('hasta') != '')?date_format(date_create($this->input->post('hasta')),'Y-m-d H:m:s'):null,
                'cnp_elegir_segun_edad' => ($this->input->post('ckc_edad'))? $this->input->post('ckc_edad') : 0,
                'cnp_elegir_segun_genero' => ($this->input->post('ckc_genero'))? $this->input->post('ckc_genero') : 0,
                'cnp_elegir_segun_depto' => ($this->input->post('ckc_departamento'))? $this->input->post('ckc_departamento') : 0,
                'cnp_elegir_segun_mun' => ($this->input->post('ckc_municipio'))? $this->input->post('ckc_municipio') : 0,
                'cnp_elegir_segun_profesion' => ($this->input->post('ckc_profesion'))? $this->input->post('ckc_profesion') : 0,
                'cnp_fecha'          => date('Y-m-d H:m:s'),
                'cnp_estado'         => 1,
                'cnp_usu_creacion'   => $this->tank_auth->get_user_id(),
                'cnp_fecha_creacion' => date('Y-m-d H:m:s'),
                'cnp_usu_modificacion'   => $this->tank_auth->get_user_id(),
                'cnp_fecha_modificacion' => date('Y-m-d H:m:s')
            );
            $insert   = $this->gsatelite->ingresar('cnp_concurso_plaza', $concurso);
            $slcGrado = $this->input->post('slcGrado');
            $slcNivEd = $this->input->post('slcNivel');
            if (is_array($slcNivEd) && count($slcNivEd) > 0) {
                foreach ($slcNivEd as $key => $value) {
                    $nivel_edu = array(
                        'edn_id_tie' => $value,
                        'edn_id_cnp' => $insert,
                        'edn_estado' => 1,
                        'edn_usu_creacion' => $this->tank_auth->get_user_id(),
                        'edn_fecha_creacion' => date('Y-m-d H:m:s'),
                        'edn_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'edn_fecha_modificacion' => date('Y-m-d H:m:s')
                    );
                    $this->gsatelite->ingresar('edn_educacion_concurso_plaza', $nivel_edu);
                }
            }
            if (is_array($slcGrado) && (count($slcGrado) >0) ) {
                foreach ($slcGrado as $k => $valor) {
                    $grados = array(
                        'pxp_id_cnp'            => $insert,
                        'pxp_id_pro'            => $valor,
                        'pxp_estado'            => 1,
                        'pxp_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'pxp_fecha_creacion'    => date('Y-m-d H:m:s'),
                        'pxp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'pxp_fecha_modificacion'=> date('Y-m-d H:m:s')
                    );
                    $this->gsatelite->ingresar('pxp_profesionxconcurso_plaza', $grados);                    
                }
            }
            $tipo   = $this->input->post('btnCrear');
            if ($insert > 0) {
                switch ($tipo) {
                    case '1':
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de concurso", 'texto_alerta' => "El registro se guardó correctamente");
                        $this->session->set_flashdata($alerta);
                        redirect('modulo_seleccion_personal/slp_procesos/concurso_plazas');              
                        break;                    
                    case '2':
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de concurso", 'texto_alerta' => "El registro se guardó correctamente");
                        $this->session->set_flashdata($alerta);                        
                        redirect('modulo_seleccion_personal/slp_procesos/agregar_concurso');
                        break;
                }
            }else{
                switch ($tipo) {
                    case '1':
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de concurso", 'texto_alerta' => "El registro no se guardó, intenta nuevamente");
                        $this->session->set_flashdata($alerta);
                        redirect('modulo_seleccion_personal/slp_procesos/concurso_plazas');              
                        break;                    
                    case '2':
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de concurso", 'texto_alerta' => "El registro no se guardó, intenta nuevamente");
                        $this->session->set_flashdata($alerta);                        
                        redirect('modulo_seleccion_personal/slp_procesos/agregar_concurso');
                        break;
                }
            }
        }else{
            $titulo['titulo_personal'] = 'Concurso de Plazas';
            $arreglo_ids = $this->expediente_personal_model->get_permitidos_plaza();
                              $this->db->where_not_in('plz_id', $arreglo_ids);
                              $this->db->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are');
            $data['plazas'] = $this->gsatelite->get_tabla('plz_plaza', array('plz_estado' => 1, 'mxr_id_emr' => $this->tank_auth->get_empresa_id()));
                     $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
            $data['areas'] = $this->gsatelite->get_dropdown('are_area','are_nombre','',array('are_estado' => 1, 'mxr_id_emr' => $this->tank_auth->get_empresa_id()),'',null,'are_id', true);
            $edades = explode('/', $this->gsatelite->get_parametro('SYS_EDADES_PLAZAS'));
            $data['menor_edad'] = $edades[0];
            $data['mayor_edad'] = $edades[1];
            $data['genero'] = $this->gsatelite->get_dropdown('gen_genero','gen_nombre','',array('gen_estado' => 1),'',null,'gen_id', true);
            $data['nivel'] = $this->gsatelite->get_dropdown('tie_tipo_educacion','tie_nombre','',array('tie_estado' => 1),'',null,'tie_id', true);
            $data['grado'] = $this->gsatelite->get_dropdown('pro_profesion','pro_nombre','',array('pro_estado' => 1),'',null,'pro_id', true);
            $data['puestos'] = $this->gsatelite->get_dropdown('pto_puesto','pto_nombre','',array('pto_estado' => 1),'',null,'pto_id', true);
            $data['paises'] = $this->gsatelite->get_dropdown('pai_pais','pai_nombre','',array('pai_estado' => 1),'',null,'pai_id', true);
            $data['tiposContratacion'] = $this->gsatelite->get_dropdown('tic_tipo_contrato','tic_nombre','',array('tic_estado' => 1),'',null,'tic_id', true);
            // $data['ted'] = $this->gsatelite->get_dropdown('ted_titulo_educacion','ted_nombre','',array('ted_estado' => 1),'',null,'ted_id', true);//SE ELIMINA SAT6959
            $this->_cargarvista($titulo, $data);
        }

    }


    /**
    *@author Nelson Soriano
    *@since  01-07-2019
    *@param  id_cnp
    *@return confirmacion de la transaccion
    */

    public function  editar_concurso($id = null){
        satelite_validar();
        if ($_POST) {
            if ($id !== null) {
                // var_dump($_POST);die();
                $concurso_update = array(
                    'cnp_id_pto'  => ($this->input->post('slcPuestos') != '')?$this->input->post('slcPuestos'):null,
                    'cnp_id_are'  => ($this->input->post('slcAreas') != '')?$this->input->post('slcAreas'):null,
                    'cnp_id_plz'  => ($this->input->post('slcPlazas') != '')?$this->input->post('slcPlazas'):null,
                    'cnp_id_ted'  => ($this->input->post('slcTed') != '')?$this->input->post('slcTed'):null,
                    'cnp_id_gen'  => ($this->input->post('slcGenero') != '')?$this->input->post('slcGenero'):null,
                    'cnp_id_pai'  => ($this->input->post('slcPais') != '')?$this->input->post('slcPais'):null,
                    'cnp_id_dep'  => ($this->input->post('slcDepartamento') != '')?$this->input->post('slcDepartamento'):null,
                    'cnp_id_tic'  => ($this->input->post('slcTipoContratacion') != '')?$this->input->post('slcTipoContratacion'):null,
                    'cnp_id_usu'  => $this->tank_auth->get_user_id(),
                    'cnp_nombre'         => ($this->input->post('txtNombre') != '')?$this->input->post('txtNombre'):null,
                    'cnp_edad_minima'    => ($this->input->post('slcEdadMinima') != '')?$this->input->post('slcEdadMinima'):null,
                    'cnp_edad_maxima'    => ($this->input->post('slcMaxima') != '')?$this->input->post('slcMaxima'):null,
                    'cnp_salario_minimo' => ($this->input->post('txtSalarioMin') != '')?$this->input->post('txtSalarioMin'):null,
                    'cnp_salario_maximo' => ($this->input->post('txtSalarioMaximo') != '')?$this->input->post('txtSalarioMaximo'):null,
                    'cnp_cantidad'       => ($this->input->post('txtCantidadVacantes') != '')?$this->input->post('txtCantidadVacantes'):0,
                    'cnp_funcion'        => ($this->input->post('txtFunciones') != '')?$this->input->post('txtFunciones'):null,
                    'cnp_descripcion'    => ($this->input->post('txtDescripcion') != '')?$this->input->post('txtDescripcion'):null,
                    'cnp_fecha_desde'    => ($this->input->post('desde') != '')?date_format(date_create($this->input->post('desde')),'Y-m-d H:m:s'):null,
                    'cnp_fecha_hasta'    => ($this->input->post('hasta') != '')?date_format(date_create($this->input->post('hasta')),'Y-m-d H:m:s'):null,
                    'cnp_elegir_segun_edad' => ($this->input->post('ckc_edad'))? $this->input->post('ckc_edad') : 0,
                    'cnp_elegir_segun_genero' => ($this->input->post('ckc_genero'))? $this->input->post('ckc_genero') : 0,
                    'cnp_elegir_segun_depto' => ($this->input->post('ckc_departamento'))? $this->input->post('ckc_departamento') : 0,
                    'cnp_elegir_segun_profesion' => ($this->input->post('ckc_profesion'))? $this->input->post('ckc_profesion') : 0,
                    'cnp_estado'         => ($this->input->post('slcEstado') != '')?$this->input->post('slcEstado'):0,
                    'cnp_usu_creacion'   => $this->tank_auth->get_user_id(),
                    'cnp_fecha_creacion' => date('Y-m-d H:m:s'),
                    'cnp_usu_modificacion'   => $this->tank_auth->get_user_id(),
                    'cnp_fecha_modificacion' => date('Y-m-d H:m:s')
                );
                $resp = $this->gsatelite->actualizar_array('cnp_concurso_plaza', $concurso_update, array('cnp_id' => $id));
                $slcGrado = $this->input->post('slcGrado');
                $slcNivEd = $this->input->post('slcNivel');
                $this->gsatelite->borrado_general('pxp_profesionxconcurso_plaza', array('pxp_id_cnp' => $id));
                if (is_array($slcGrado) && count($slcGrado) >0) {
                    foreach ($slcGrado as $k => $valor) {
                        $grados = array(
                            'pxp_id_cnp'            => $id,
                            'pxp_id_pro'            => $valor,
                            'pxp_estado'            => 1,
                            'pxp_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'pxp_fecha_creacion'    => date('Y-m-d H:m:s'),
                            'pxp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'pxp_fecha_modificacion'=> date('Y-m-d H:m:s')
                        );
                        $this->gsatelite->ingresar('pxp_profesionxconcurso_plaza', $grados);                    
                    }
                }
                $this->gsatelite->borrado_general('edn_educacion_concurso_plaza',array('edn_id_cnp' => $id));
                if (is_array($slcNivEd) && count($slcNivEd) > 0) {
                    foreach ($slcNivEd as $key => $value) {
                        $nivel_edu = array(
                            'edn_id_tie' => $value,
                            'edn_id_cnp' => $id,
                            'edn_estado' => 1,
                            'edn_usu_creacion' => $this->tank_auth->get_user_id(),
                            'edn_fecha_creacion' => date('Y-m-d H:m:s'),
                            'edn_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'edn_fecha_modificacion' => date('Y-m-d H:m:s')
                        );
                        $this->gsatelite->ingresar('edn_educacion_concurso_plaza', $nivel_edu);
                    }
                }
                $tipo   = $this->input->post('btnCrear');
                if ($resp > 0) {
                    switch ($tipo) {
                        case '1':
                            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de concurso", 'texto_alerta' => "Registro actualizado correctamente");
                            $this->session->set_flashdata($alerta);
                            redirect('modulo_seleccion_personal/slp_procesos/concurso_plazas');              
                            break;                    
                        case '2':
                            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de concurso", 'texto_alerta' => "Registro actualizado correctamente");
                            $this->session->set_flashdata($alerta);                        
                            redirect('modulo_seleccion_personal/slp_procesos/editar_concurso/'.$id);
                            break;
                    }
                }else{
                    switch ($tipo) {
                        case '1':
                            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de concurso", 'texto_alerta' => "El registro no se pudo actualizar, intenta nuevamente");
                            $this->session->set_flashdata($alerta);
                            redirect('modulo_seleccion_personal/slp_procesos/concurso_plazas');              
                            break;                    
                        case '2':
                            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de concurso", 'texto_alerta' => "El registro no se pudo actualizar, intenta nuevamente");
                            $this->session->set_flashdata($alerta);                        
                            redirect('modulo_seleccion_personal/slp_procesos/editar_concurso'.$id);
                            break;
                    }
                }
            }
        }else{
            $empresa = $this->tank_auth->get_empresa_id();
            $con = $this->gsatelite->get_registro('cnp_concurso_plaza',array('cnp_id' => $id));
                             $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
            $data['areas'] = $this->gsatelite->get_dropdown('are_area', 'are_nombre', '', array('are_estado' => 1,'mxr_id_emr' => $empresa), $con->cnp_id_are, null, 'are_id', true);
            $edades = explode('/', $this->gsatelite->get_parametro('SYS_EDADES_PLAZAS'));
            $data['menor_edad'] = $edades[0];
            $data['mayor_edad'] = $edades[1];
            $data['selected_min'] = ($con->cnp_edad_minima != '') ? number_format($con->cnp_edad_minima) : "";
            $data['selected_max'] = ($con->cnp_edad_maxima != '') ? number_format($con->cnp_edad_maxima) : "";
            $ids_niveles = array_column($this->gsatelite->get_tabla('edn_educacion_concurso_plaza',array('edn_id_cnp' => $id)), 'edn_id_tie');
            $ids_profesn = array_column($this->gsatelite->get_tabla('pxp_profesionxconcurso_plaza',array('pxp_id_cnp' => $id)), 'pxp_id_pro');
            $data['nivel'] = $this->gsatelite->get_dropdown('tie_tipo_educacion', 'tie_nombre', '', array('tie_estado' => 1), $ids_niveles, null, 'tie_id', true);
            $data['grado'] = $this->gsatelite->get_dropdown('pro_profesion', 'pro_nombre', '', array('pro_estado' => 1), $ids_profesn, null, 'pro_id', true);
            $data['genero'] = $this->gsatelite->get_dropdown('gen_genero','gen_nombre','',array('gen_estado' => 1), $con->cnp_id_gen, null,'gen_id', true); 
            $data['puestos'] = $this->gsatelite->get_dropdown('pto_puesto','pto_nombre','',array('pto_estado' => 1), $con->cnp_id_pto, null,'pto_id', true);
            $data['paises'] = $this->gsatelite->get_dropdown('pai_pais','pai_nombre','',array('pai_estado' => 1),$con->cnp_id_pai,null,'pai_id', true);
            $data['depto'] = $this->gsatelite->get_dropdown('dep_departamento','dep_nombre','',array('dep_estado' => 1, 'dep_id_pai' => $con->cnp_id_pai), $con->cnp_id_dep,null,'dep_id', true);
            $data['tiposContratacion'] = $this->gsatelite->get_dropdown('tic_tipo_contrato','tic_nombre','',array('tic_estado' => 1), $con->cnp_id_tic, null,'tic_id', true);
            $data['plaza_concurso'] = $con->cnp_id_plz;
            $arreglo_ids = $this->expediente_personal_model->get_permitidos_plaza();
                              $this->db->where_not_in('plz_id', $arreglo_ids);
                              $this->db->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are');
            $data['plazax'] = $this->gsatelite->get_tabla('plz_plaza', array('plz_estado' => 1, 'mxr_id_emr' => $this->tank_auth->get_empresa_id()));
            $data['nombre'] = $con->cnp_nombre;
            $data['info'] = $con;
            $data['id_concurso'] = $id;
            $data['estadox'] = (int) $con->cnp_estado;
            $titulo['titulo_personal'] = 'Editar Concurso de Plazas';            
            // $data['ted']               = $this->gsatelite->get_dropdown('ted_titulo_educacion','ted_nombre','',array('ted_estado' => 1),$con->cnp_id_ted,null,'ted_id', true);//SE ELIMINA SAT6959
            $this->_cargarvista($titulo, $data);
        }
    }


    /**
    *@author Nelson Soriano
    *@since  04-07-2019
    *@param  cnp_id
    *@return PDF
    */

    public function imprimir($id= null){
        satelite_validar();
        $this->load->library('pdf');
        if ((int) $id) {
            $data['info'] = $this->seleccion_personal_model->get_concursos(array('cnp_id' => $id));
            $html = $this->load->view('reporte/header', array('titulo' => 'Concurso de Plazas'), true);
            $html .= $this->load->view('modulo_seleccion_personal/slp_reportes/imprimir',$data,true);
            $this->pdf->setPageOrientation('P');
            $this->pdf->makePDF($html);
        }
        
    }


    /**
    *@author Nelson Soriano
    *@since  01-07-2019
    *@param  plaza, area
    *@return confirmacion de la transaccion
    */

    public function consultar_concurso(){
        satelite_validar();
        $plaza                   = ($this->input->post('plaza') != '')?$this->input->post('plaza'):null;
        $area                    = ($this->input->post('area')  != '')?$this->input->post('area'):null;
        $s_editar                = ($this->input->post('solo_editar')  != '')?$this->input->post('solo_editar'):null;
        $where = array();

        if ($plaza !== null) {
            $where['cnp_id_plz'] = $plaza;
        }

        if ($area !== null) {
            $where['cnp_id_are'] = $area;
        }

        if ($s_editar !== null) {
            $where['cnp_estado'] = 1;            
        }
        $data['solo_editar'] = $s_editar;

        $data['permisos']        = $this->gsatelite->get_permisos_opcion('modulo_seleccion_personal/slp_procesos/concurso_plazas');
        $data['info'] = $this->seleccion_personal_model->get_concursos($where);
        $html= $this->load->view('modulo_seleccion_personal/slp_procesos/consultar_concurso',$data,true);
        echo $html;
        die();
    }

    /**
    *@author Nelson Soriano
    *@since  01-07-2019
    *@param  area
    *@return select de plazas
    */

    public function get_plazas(){
        satelite_validar();
        $area   = $this->input->post('area');
        $emp_plz = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado' => 1, 'emp_id_are' => $area, 'emp_id_plz IS NOT NULL' => NULL));
        $excluir = (count($emp_plz) > 0) ? implode(',', array_unique(array_column($emp_plz, 'emp_id_plz'))) : 0;
        $data   = $this->gsatelite->get_tabla("plz_plaza", array("plz_id_are" => $area, "plz_estado" => 1, "plz_id NOT IN ($excluir)" => null));
        $select = '<option value=""></option>';
        foreach ($data as $key => $plaza) {
           $select .= '<option value="'.$plaza['plz_id'].'">'.$plaza['plz_nombre'].'</option>';
        }
        echo $select;
    }

    /**
    *@author Nelson Soriano
    *@since  03-07-2019
    *@param  pais
    *@return select de departamentos
    */

    public function get_deptos(){
        satelite_validar();
        $pai    = $this->input->post('pai');
        $data   = $this->gsatelite->get_tabla('dep_departamento',array('dep_id_pai' => $pai));
        $select = '';
        foreach ($data as $key => $plaza) {
           $select .= '<option value="'.$plaza['dep_id'].'">'.$plaza['dep_nombre'].'</option>';
        }
        echo $select;
    }

    /**
    *@author Nelson Soriano
    *@since  05-07-2019
    *@param  
    *@return Vista para actualizar plazas
    */

    public function autorizar_concurso(){
        satelite_validar();
        $data2['permisos2']        = $this->gsatelite->get_permisos_opcion();
        $titulo['titulo_personal'] = 'Autorizar';
        $data['permisos']          = $this->gsatelite->get_permisos_opcion('modulo_seleccion_personal/slp_procesos/concurso_plazas');
                                     $this->db->join('cnp_concurso_plaza', 'cnp_id_are = are_id');//areas que poseen un concurso
        $areas                     = $this->gsatelite->get_dropdown('are_area','are_nombre','',array('are_estado' => 1),'',null,'are_id', true);
                                     $this->db->join('cnp_concurso_plaza', 'cnp_id_plz = plz_id');//solo plazas que estan en concurso
        $plaza                     = $this->gsatelite->get_dropdown('plz_plaza','plz_nombre','',array('plz_estado' => 1),'',null,'plz_id', true);
        $data['solo_editar']       = 1;
        $data['areas']             = str_replace('<option value=""></option>', '', $areas);
        $data['plazas']            = str_replace('<option value=""></option>', '', $plaza);
        $data2['html']             = $this->load->view('modulo_seleccion_personal/slp_procesos/concurso_plazas',$data,true);
        $this->_cargarvista($titulo, $data2);
        
    }

     /**
    *@author Nelson Soriano
    *@since  05-07-2019
    *@param  
    *@return Vista para actualizar plazas
    */

     public function autorizar($id_concurso = null){
        satelite_validar();
        //print_r('id '.$id_concurso);die();
        if ($id_concurso !== null) {
            if($_POST) {
                $o       = $this->input->post('observacion');
                $array = array(
                    'cnp_observacion_autoriza' => $o,
                    'cnp_estado'               => 2,
                    'cnp_id_usu_autoriza'      => $this->tank_auth->get_user_id(),
                    'cnp_fecha_autoriza'       => date('Y-m-d H:m:s')
                );
                    $resp = $this->gsatelite->actualizar_array('cnp_concurso_plaza',$array,array('cnp_id' => $id_concurso));
                    echo json_encode(array('resp' =>$resp));
                    die();
            }else{
                $data['id_concursox'] = $id_concurso;
                echo $html            = $this->load->view('modulo_seleccion_personal/slp_procesos/autorizar',$data,true);
                die();
            }
        }
     }

    /**
    *@author Nelson Soriano
    *@since  09-07-2019
    *@param  
    *@return Vista para aplicaciones
    */
     public function aplicaciones($id_concurso = null){
        satelite_validar();
        if ($id_concurso !== null) {
            if ($_POST) {
                # code...
            }else{
            $data['concurso_id'] = $id_concurso;
            $data['vacantes']    = $this->gsatelite->get_campo('cnp_concurso_plaza','cnp_cantidad',array('cnp_id' => $id_concurso));
            $data['nombre']      = $this->gsatelite->get_campo('cnp_concurso_plaza','cnp_nombre',array('cnp_id' => $id_concurso));
            $data['aplicantes']  = $this->seleccion_personal_model->get_solicitantesxconcurso(array('cnp_estado in (2,3)' => null,'csp_estado' => 1,'sle_estado' => 1,'cnp_id' => $id_concurso));
            $cantidad_sys        = $this->seleccion_personal_model->get_cantidad_plazas_ap($id_concurso);
            $data['cantidad']    = $data['aplicantes'][0]['cnp_cantidad'];
            $data['tiene']       = (count( $this->seleccion_personal_model->get_solicitantesxconcurso(array('cnp_estado in(2,3)' => null,'sle_estado in (1,2)' => null,'cnp_id' => $id_concurso,'csp_seleccionado' => 1)))>0)?$this->seleccion_personal_model->get_solicitantesxconcurso(array('cnp_estado in(2,3)' => null,'sle_estado in (1,2)' => null,'cnp_id' => $id_concurso,'csp_seleccionado' => 1)):null;
            echo $html           = $this->load->view('modulo_seleccion_personal/slp_procesos/aplicaciones',$data,true);
            die();
            }
        }
        
     }

    /**
    *@author Nelson Soriano
    *@since  05-07-2019
    *@param  info aplicaciones
    *@return response
    */
    public function definir_ganadores(){
        satelite_validar();
        if ($this->input->post('todos') != '') {
            //Elimina todo para un concurso
            $cnp = $this->input->post('todos');
            //$this->gsatelite->borrado_general('csp_concurso_xsolicitante_empleo',array('csp_id_cnp' => $cnp,'csp_seleccionado' => 1 ));      
            $this->gsatelite->actualizar_array('csp_concurso_xsolicitante_empleo',array('csp_seleccionado' => 0),array('csp_id_cnp' => $ncp));
            $this->gsatelite->actualizar_array('cnp_concurso_plaza',array('cnp_estado' => 2),array('cnp_id' => $cnp));
        }else{
            parse_str($_POST['formulario'], $ganadores);
            $resp = false;
            // eliminar los que no vienen en el post
            $existentes = array_column($this->seleccion_personal_model->get_solicitantesxconcurso(array('cnp_estado in (2,3)' => null,'csp_estado' => 1,'sle_estado' => 1,'cnp_id' => $ganadores['concurso_id'])),'csp_id');
            $enviados   = $ganadores['ganadores'];
            for ($i=0; $i < count($ganadores['ganadores']) ; $i++) { 
                $data   = explode(',', $ganadores['ganadores'][$i]);
                $cspx[] = $data[0];
            }
            foreach ($existentes as $key => $val) {
                if (!(in_array($val, $cspx))) {
                    $i= $this->gsatelite->actualizar_array('csp_concurso_xsolicitante_empleo',array('csp_seleccionado' => 0),array('csp_id' => $val));
                    $this->gsatelite->actualizar_array('cnp_concurso_plaza',array('cnp_estado' => 2),array('cnp_id' => $ganadores['concurso_id']));
                }
            }
            //fin del borrado
            if (count($ganadores['ganadores'])>0) {
                for ($i=0; $i < count($ganadores['ganadores']); $i++) { 
                    $data = explode(',', $ganadores['ganadores'][$i]);
                    $csp  = $data[0];
                    $cnp  = $data[1];
                    $sle  = $data[2];
                    $obs  = ($ganadores['observacion'][$i] != '')?$ganadores['observacion'][$i]:null;
                    $array_update = array(
                        'csp_seleccionado'       => 1,
                        'csp_fecha_seleccion'    => date('Y-m-d H:m:s'),
                        'csp_observacion'        => $obs,
                        'csp_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'csp_fecha_modificacion' => date('Y-m-d H:m:s')
                    );                    
                    $resp = $this->gsatelite->actualizar_array('csp_concurso_xsolicitante_empleo',$array_update,array('csp_id' => $csp));
                }
                if ($resp){
                    $cantidad_sys = $this->seleccion_personal_model->get_cantidad_plazas_ap($ganadores['concurso_id']);
                    $cnp_cantidad = $this->gsatelite->get_campo('cnp_concurso_plaza','cnp_cantidad',array('cnp_id' => $ganadores['concurso_id']));
                    if ($cantidad_sys[0]['total'] == $cnp_cantidad) {
                        $this->gsatelite->actualizar_array('cnp_concurso_plaza',array('cnp_estado' => 3),array('cnp_id' => $cnp));
                    }
                    echo json_encode(array('resp' => true));
                }else{
                    echo json_encode(array('resp' => false));
                }
            }
        }
    }

    /**
    *@author Nelson Soriano
    *@since  11-07-2019
    *@param  id concurso, id solicitante
    *@return confirmacion de la transaccion
    */
    public function traslado_concurso(){
        satelite_validar();
        $cnp = $this->input->post('cnp');
        $csp = $this->input->post('csp');
        $sle = $this->input->post('sle');
        $nam = $this->gsatelite->get_campo('cnp_concurso_plaza','cnp_nombre',array('cnp_id' => $cnp));
        $update = array(
                    'csp_trasladado'          => 1,
                    'csp_fecha_modificacion'  => date('Y-m-d H:m:s'),
                    'csp_usu_modificacion'    => $this->tank_auth->get_user_id()
                );        
            $resp = $this->gsatelite->actualizar_array('csp_concurso_xsolicitante_empleo',$update,array('csp_id' => $csp));
            if ($resp) { 
               $result = $this->traslado_solicitante($sle,$cnp);
               echo json_encode(array('resp' => 1,'sle' => $result,'cnp'=>$cnp));
            }else{
                echo json_encode(array('resp' => 0));
            }
    }

    /**
    *@author Marlon Olmedo
    *@since  09-06-2019
    *@param  null
    *@return asignar empleados a plaza
    */
    public function plaza_empleado($plz_id){
        satelite_validar();
        if ($_POST) {
            //print_r($_POST);die();
            $edad_maxima = $this->input->post('slc_edad_max');
            $edad_minima = $this->input->post('slc_edad_min');
            $genero = $this->input->post('slc_genero');
            $departamento = $this->input->post('slc_departamento');
            $municipio = $this->input->post('slc_municipio');
            $profesion = $this->input->post('slc_profesion');
            $data["permisos_emp"] = NULL;
            $where = null;
            $participantes_act = $this->gsatelite->get_tabla('csp_concurso_xsolicitante_empleo', array('csp_id_cnp' => $plz_id));
            $participantes_act = array_column($participantes_act,"csp_id_sle");
            $participantes_act = implode(",",$participantes_act);
            if ($participantes_act != null) {
                $where["sle_id NOT IN($participantes_act)"] = NULL;
            }
            if ($edad_minima != '') { 
                $fecha_nac_min =  date('Y-m-d', strtotime("-$edad_minima year"));
                //$where["date(sle_fecha_nac) BETWEEN '$fecha_nac_min' and date(now())"] = NULL;
                $where["date(sle_fecha_nac) <= '$fecha_nac_min'"] = NULL;
            } 
            if ($edad_maxima != '') {
                $fecha_nac_max =  date('Y-m-d', strtotime("-$edad_maxima year"));
                //$where["date(sle_fecha_nac) BETWEEN '$fecha_nac_max' and date(now())"] = null;
                $where["date(sle_fecha_nac) >= '$fecha_nac_max'"] = null;
            }
            if ($genero != '') {
                $gen_ = implode(",",$genero);
                $where["sle_id_gen IN($gen_)"] = NULL;
            }
            if ($departamento != '' &&  $municipio == '') {
                $municipios = $this->gsatelite->get_tabla('mun_municipio', array('mun_id_dep' => $departamento));
                $munici_ = array_column($municipios,"mun_id");
                $mun_ = implode(",",$munici_);
                $where["sle_id_mun IN($mun_)"] = NULL;
            }
            if ($municipio != '') {
                $where["sle_id_mun"] = $municipio;
            }
            if ($profesion != '') {
                $prof_ = implode(",",$profesion);
                $where["sle_id_pro IN($prof_)"] = NULL;
            }
            
            $data["one_accion"] = true;
            $data['info']              = $this->seleccion_personal_model->get_solicitantes($where);
            //print_r($this->db->last_query());
            $html = $this->load->view('modulo_seleccion_personal/slp_procesos/get_solicitantes',$data,true);
            echo $html;
            die();
        }
        $this->db->join('plz_plaza', 'cnp_id_plz = plz_id',"left");
        $plaza = $this->gsatelite->get_tabla('cnp_concurso_plaza', array('cnp_id' => $plz_id))[0];
        $gen_id = '';
        $edad_max = '';
        $edad_min = '';
        $dep_id = '';
        $mun_id = '';
        $prof_id = "";
        
        if ($plaza["cnp_elegir_segun_edad"] == 1) {
            if ($plaza["cnp_edad_maxima"] != null) {
                $edad_max = $plaza["cnp_edad_maxima"];
            } else {
                $edad_max = $plaza["plz_edad_maxima"];
            }

            if ($plaza["cnp_edad_minima"] != null) {
                $edad_min = $plaza["cnp_edad_minima"];
            } else {
                $edad_min = $plaza["plz_edad_minima"];
            }
            $data["edad_base_max"] = $edad_max;
            $data["edad_base_min"] = $edad_min;
        }
        
        if ($plaza["cnp_elegir_segun_genero"] == 1) {
            if ($plaza["cnp_id_gen"] != null) {
                $gen_id = array($plaza["cnp_id_gen"]);
            } else {
                $generos = $this->gsatelite->get_tabla('gxp_generoxplaza', array('gxp_id_plz' => $plaza["plz_id"]));
                $generos = array_column($generos,"gxp_id_gen");
                $gen_id = $generos;
            }
        }
        
        if ($plaza["cnp_elegir_segun_depto"] == 1) { 
            if  ($plaza["cnp_id_dep"] != null) {
                $dep_id = $plaza["cnp_id_dep"];
            }
        }

        // if ($plaza["cnp_elegir_segun_mun"] == 1) {
        //     $muni = $this->gsatelite->get_tabla('mun_municipio', array('mun_id_dep' => $plaza["cnp_id_dep"]))[0];
        //     if (!empty($muni)) {
        //         $mun_id = $muni["mun_id"];
        //     }
        // }

        if ($plaza["cnp_elegir_segun_profesion"] == 1) { 
            $profesiones_concurzo = $this->gsatelite->get_tabla('pxp_profesionxconcurso_plaza', array('pxp_id_cnp' => $plaza["cnp_id"]));
            if (!empty($profesiones_concurzo)) {
                $prof_id = array_column($profesiones_concurzo,"pxp_id_pro");
            } else {
                $profesiones_plaza = $this->gsatelite->get_tabla('prp_profesion_plaza', array('prp_id_plz' => $plaza["plz_id"]));
                $prof_id = array_column($profesiones_plaza,"prp_id_pro");
            }
        } 
        //print_r($mun_id);die();
        $edades                    = explode('/', $this->gsatelite->get_parametro('SYS_EDADES_PLAZAS'));
        $data['menor']             = $edades[0];
        $data['mayor']             = $edades[1];
        $data["genero"] = $this->gsatelite->get_dropdown('gen_genero', '{gen_nombre}', '', array('gen_estado' => 1), $gen_id, '', 'gen_id', true);
        $data["departamento"] = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', array('dep_estado' => 1), $dep_id, '', 'dep_id', true);
        $data["municipio"] = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', array('mun_estado' => 1), $mun_id, '', 'mun_id', true);
        $data["profesion"] = $this->gsatelite->get_dropdown('pro_profesion', '{pro_nombre}', '', array('pro_estado' => 1), $prof_id, '', 'pro_id', true);
        $data["cnp_id"] = $plz_id;
        $data["plaza_nombre"] = $plaza["cnp_nombre"];
        $data['titulo_personal'] = "Participantes";
        $this->_cargarvista($data);
    }

    /**
    *@author Marlon Olmedo
    *@since  09-06-2019
    *@param  null
    *@return asignar empleados a plaza
    */
    public function guardar_plaza_empleado(){
        satelite_validar();
        //print_r($_POST);die();
        $cnp   = $this->input->post("id_concurso");
        $sele  = $this->input->post('id_solicitante');
        $ob    = $this->input->post('txtObservacion');

        $array_plazas  = array(
            'csp_id_sle'            => $sele,
            'csp_id_cnp'            => $cnp,
            'csp_seleccionado'      => 0,
            'csp_fecha_seleccion'   => null,
            'csp_observacion'       => ($ob != '')?$ob:null,
            'csp_estado'            => 1,
            'csp_usu_creacion'      => $this->tank_auth->get_user_id(),
            'csp_fecha_creacion'    => date('Y-m-d H:m:s'),
            'csp_usu_modificacion'  => $this->tank_auth->get_user_id(), 
            'csp_fecha_modificacion'=> date('Y-m-d H:m:s')

        );
        $csp = $this->gsatelite->ingresar('csp_concurso_xsolicitante_empleo',$array_plazas);
        if ($csp) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de participante", 'texto_alerta' => "El registro se guardó correctamente");
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de participante", 'texto_alerta' => "El registro no se guardó, intenta nuevamente");
        }
        
        $this->session->set_flashdata($alerta);   
        redirect("modulo_seleccion_personal/slp_procesos/plaza_empleado/$cnp");
    }

    /**
    *@author Marlon Olmedo
    *@since  17-06-2020
    *@param  null
    *@return asignar empleados a plaza
    */
    public function get_datos_plaza(){
        satelite_validar();
        $plaza_id = $this->input->post("plaza");
        $plaza_datos = $this->gsatelite->get_tabla('plz_plaza', array('plz_id' => $plaza_id))[0];
        $generos = $this->gsatelite->get_tabla('gxp_generoxplaza', array('gxp_id_plz' => $plaza_id));
        $profesion = $this->gsatelite->get_tabla('prp_profesion_plaza', array('prp_id_plz' => $plaza_id));
        $genero = (isset($generos[0]["gxp_id_gen"])) ? $generos[0]["gxp_id_gen"] : null;
        $datos = array("puesto" => $plaza_datos["plz_id_pto"],
                        "genero" => $genero,
                        "profesion" => array_column($profesion,"prp_id_pro"),
                        "edad_max" => $plaza_datos["plz_edad_maxima"],
                        "edad_min" => $plaza_datos["plz_edad_minima"],
                        "area_plz" => $plaza_datos['plz_id_are'],
                        "nivel_edu" => $plaza_datos["plz_id_tie"]);
        echo json_encode($datos);
        die();
    }

}
/* End of file slp_procesos.php */
/* Location: ./application/controllers/modulo_seleccion_personal */