<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Slp_mantenimientos extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('consultas');
        $this->load->model('seleccion_personal_model');
    }

    public function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a los tipos de referencias (tabla: trr_tipo_referencia)
     * Funcionalidad Compartida del Modulo de Expediente Personal - Tipo de Referencia
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-03-28
     * @param ninguno
     * @return Mantenimiento de tipo de referencia
     */
    public function tipo_referencia() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->tipo_referencia();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a las profesines (tabla: pro_profesion)
     * Funcionalidad Compartida del Modulo de Expediente Personal - Profesiones
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-03-28
     * @param ninguno
     * @return Mantenimiento de Profesiones
     */
    public function profesion() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->profesion();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a los Generos (tabla: gen_genero)
     * Funcionalidad Compartida del Modulo de Expediente Personal - Genero
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-03-28
     * @param ninguno
     * @return Mantenimiento de Genero
     */
    public function generos() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->generos();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a las Nacionalidades (tabla: pai_pais)
     * Funcionalidad Compartida del Modulo de Expediente Personal - Paises
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-03-28
     * @param ninguno
     * @return Mantenimiento de Nacionalidades
     */
    public function paises() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->paises();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a las Estado civil (tabla: esc_estado_civil)
     * Funcionalidad Compartida del Modulo de Expediente Personal - Estado civil
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-03-28
     * @param ninguno
     * @return Mantenimiento de Estado civil
     */
    public function estado_civil() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->estado_civil();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a las Estado civil (tabla: pto_puesto)
     * Funcionalidad Compartida del Modulo de Expediente Personal - Puesto
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-03-28
     * @param ninguno
     * @return Mantenimiento de Puesto
     */
    public function puesto() {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->puestos('modulo_seleccion_personal/slp_mantenimientos');
    }

    /**
     * Descripción:
     * Función para agregar puesto (tabla pto_puesto)
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-03-28
     * @param Ninguno
     * @return Obtener la vista para agregar un puesto
     */
    public function agregar_puesto() {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->agregar_puesto('modulo_seleccion_personal/slp_mantenimientos', 'puesto');    
    }

    /**
     * Descripción:
     * Función para editar el puesto (tabla pto_puesto)
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-03-28
     * @param Ninguno
     * @return Obtener la vista para editar puesto
     */
    public function editar_puesto($pto_id = null) {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->editar_puesto($pto_id, 'modulo_seleccion_personal/slp_mantenimientos', 'puesto');
    }

    /**
     * Descripción:
     * Función para obtener la vista de ver el registro de puesto
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-03-28
     * @param $pto_id = ID del puesto que se desea ver
     * @return Obtener Vista de puesto
     */
    public function ver_puesto($pto_id = null) {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->ver_puesto($pto_id, 'modulo_seleccion_personal/slp_mantenimientos', 'puesto');
    }

    /**
     * Descripción:
     * Función para eliminar un puesto (tabla pto_puesto)
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-03-28
     * @param $pto_id = ID del puesto
     * @return Eliminar un registro de puesto
     */
    public function eliminar_puesto($pto_id = null) {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->eliminar_puesto($pto_id, 'modulo_seleccion_personal/slp_mantenimientos', 'puesto');
    }

    /**
     * Descripción:
     * Función para Gestionar los tipos de documentos (tabla tde_tipo_documento)
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-04-04
     * @param Ninguno
     * @return Mantenimiento de Tipo de Documento
     */
    public function tipo_documento(){
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->tipo_documento();
    }



    /**
     * Descripción:
     * Función para dar mantenimiento de alergias  (tabla: coa_componente_alergico)
     * Funcionalidad Compartida del Modulo de Expediente Personal - Alegias
     * @author Edith Herrera - Grupo Satélite
     * @since 2018-04-07
     * @param ninguno
     * @return Mantenimiento de Alergias
     */
    public function alergia() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->alergia();
    }


    /**
     * Descripción:
     * Función para dar mantenimiento de Tipo de discapacidad  (tabla: coa_componente_alergico)
     * Funcionalidad Compartida del Modulo de Expediente Personal - Tipo de discapacidad
     * @author Edith Herrera - Grupo Satélite
     * @since 2018-04-07
     * @param ninguno
     * @return Mantenimiento de Tipo de discapacidad
     */
    public function tipo_discapacidad() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->tipo_discapacidad();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Tipo de sangre  (tabla: coa_componente_alergico)
     * Funcionalidad Compartida del Modulo de Expediente Personal - Tipo de sangre
     * @author Edith Herrera - Grupo Satélite
     * @since 2018-04-07
     * @param ninguno
     * @return Mantenimiento de Tipo de sangre
     */
    public function tipo_sangre() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->tipo_sangre();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Parentesco (tabla: pat_parentesco)
     * Funcionalidad Compartida del Modulo de Expediente Personal - Parentesco
     * @author Edith Herrera - Grupo Satélite
     * @since 2018-04-09
     * @param ninguno
     * @return Mantenimiento de Tipo de sangre
     */
    public function parentesco() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->parentesco();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Tipo de educación (tabla: tie_tipo_educacion)
     * Funcionalidad Compartida del Modulo de Registro académico - Tipo de educación
     * @author Edith Herrera - Grupo Satélite
     * @since 2018-04-09
     * @param ninguno
     * @return Mantenimiento de Tipo de educación
     */
     function tipo_educacion(){
        satelite_validar();
        $this->load->library('../controllers/registro_academico/mantenimientos');
        $this->mantenimientos->tipo_educacion();      
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Estado de estudio (tabla: ese_estado_estudio)
     * Funcionalidad Compartida del Modulo de Expediente Personal - Estado de estudio
     * @author Edith Herrera - Grupo Satélite
     * @since 2018-04-09
     * @param ninguno
     * @return Mantenimiento de Estado de estudio
     */
     function estado_estudio(){
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->estado_estudio();      
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de País (tabla: pai_pais)
     * Funcionalidad Compartida del Modulo de Expediente Personal - País
     * @author Edith Herrera - Grupo Satélite
     * @since 2018-04-09
     * @param ninguno
     * @return Mantenimiento de País
     */
    public function pais()
     {
        satelite_validar();
        $this->load->library('../controllers/sistema/catalogo');
        $this->catalogo->pais();
     }

    /**
     * Descripción:
     * Función para dar mantenimiento de Institucion  (tabla: ina_institucion_academica)
     * Funcionalidad Compartida del Modulo de Expediente Personal - institucion
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-04-09
     * @param ninguno
     * @return Mantenimiento de Institucion
     */
    public function institucion() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->institucion();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Experiencia Laboral  (tabla: exl_experiencia_laboral)
     * Funcionalidad Compartida del Modulo de Expediente Personal - experiencia_laboral
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-04-09
     * @param ninguno
     * @return Mantenimiento de Experiencia Laboral
     */
    public function experiencia_laboral() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->experiencia_laboral();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Idioma  (tabla: idm_idioma)
     * Funcionalidad Compartida del Modulo de Registro Academico - idiomas
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-04-09
     * @param ninguno
     * @return Mantenimiento de Idiomas
     */
    public function idiomas() {
        satelite_validar();
        $this->load->library('../controllers/registro_academico/mantenimientos');
        $this->mantenimientos->idiomas();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Nivel lingüístico  (tabla: nii_nivel_idioma)
     * Funcionalidad Compartida del Modulo de Registro Academico - nivel_idioma
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-04-09
     * @param ninguno
     * @return Mantenimiento de Nivel lingüístico
     */
    public function nivel_idioma() {
        satelite_validar();
        $this->load->library('../controllers/registro_academico/mantenimientos');
        $this->mantenimientos->nivel_idioma();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Certificación  (tabla: cer_certificacion)
     * Funcionalidad Compartida del Modulo de Expediente Personal - certificacion
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-04-09
     * @param ninguno
     * @return Mantenimiento de Certificación
     */
    public function certificacion() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->certificacion();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Programa y equipo  (tabla: peq_programa_equipo)
     * Funcionalidad Compartida del Modulo de Expediente Personal - programa_y_equipo
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-04-09
     * @param ninguno
     * @return Mantenimiento de Programa y equipo
     */
    public function programa_y_equipo() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->programa_y_equipo();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Nivel de programa y equipo  (tabla: peq_programa_equipo)
     * Funcionalidad Compartida del Modulo de Expediente Personal - nivel_programa_equipo
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-04-09
     * @param ninguno
     * @return Mantenimiento de Nivel de programa y equipo
     */
    public function nivel_programa_equipo() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->nivel_programa_equipo();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Instituciones  (tabla: icp_institucion_capacitacion)
     * Funcionalidad Compartida del Modulo de Expediente Personal - instituciones
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-04-09
     * @param ninguno
     * @return Mantenimiento de Instituciones
     */
    public function instituciones() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->instituciones();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Modalidades  (tabla: mde_modalidad_estudio)
     * Funcionalidad Compartida del Modulo de Expediente Personal - modalidad
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-04-09
     * @param ninguno
     * @return Mantenimiento de Modalidades
     */
    public function modalidad() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->modalidad();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Tipo Salario  (tabla: mde_modalidad_estudio)
     * Funcionalidad Compartida del Modulo de Expediente Personal - tipo_salario
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-04-09
     * @param ninguno
     * @return Mantenimiento de Tipo Salario
     */
    public function tipo_salario() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->tipo_salario();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Tipo de contrato  (tabla: tic_tipo_contrato)
     * Funcionalidad Compartida del Modulo de Expediente Personal - tipo_contrato
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-04-09
     * @param ninguno
     * @return Mantenimiento de Tipo de contrato
     */
    public function tipo_contrato() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->tipo_contrato();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Tipo de telefono  (tabla: tit_tipo_telefono)
     * Funcionalidad Compartida del Modulo de Expediente Personal - tipo_telefono
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-04-09
     * @param ninguno
     * @return Mantenimiento de Tipo de telefono
     */
    public function tipo_telefono() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->tipo_telefono();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a Jornada Laboral  (tabla: jrl_jornada_laboral)
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-04-09
     * @param $ruta_vista = Asignar otra vista(opcional)
     * @return Mantenimiento de Jornada Laboral
     */
    public function jornada_laboral($ruta_vista = null){
        satelite_validar();

        //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
        //cuando viene la petición de otro modulo.
        $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'modulo_seleccion_personal/slp_mantenimientos/jornada_laboral'; 
        $arreglo_url = explode('/', $ruta_permisos);
        $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
        $ruta_vista = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

        $columns = array(
            'jrl_codigo', 
            'jrl_nombre',
            'jrl_descripcion',
            'jrl_estado'
        );

        $display_as = array(
            'jrl_codigo'        => 'Código',
            'jrl_nombre'        => 'Nombre',
            'jrl_descripcion'   => 'Descripción',
            'jrl_estado'        => 'Estado'
        );

        $add_fields = array(
            'jrl_codigo', 
            'jrl_nombre',
            'jrl_descripcion',
            'jrl_estado',
            'jrl_usu_creacion',
            'jrl_fecha_creacion',
            'jrl_usu_modificacion',
            'jrl_fecha_modificacion'
        );

        $edit_fields = array(
            'jrl_codigo', 
            'jrl_nombre',
            'jrl_descripcion',
            'jrl_estado',
            'jrl_usu_modificacion',
            'jrl_fecha_modificacion'
        );

        $required = array(
            'jrl_codigo',
            'jrl_nombre',
            'jrl_estado'
        );

        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud =  new grocery_CRUD();
        $crud->set_subject('Jornada Laboral');
        $crud->set_table('jrl_jornada_laboral');
        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->add_fields($add_fields);
        $crud->edit_fields($edit_fields);
        $crud->required_fields($required);
        $crud->set_rules('jrl_nombre','nombre','trim|required|campo_unico[jrl_jornada_laboral.jrl_nombre]');
        $crud->set_rules('jrl_estado','estado','trim|required');
        $crud->field_type('jrl_usu_creacion','hidden',$this->tank_auth->get_user_id());
        $crud->field_type('jrl_usu_modificacion','hidden',$this->tank_auth->get_user_id());
        $crud->field_type('jrl_fecha_creacion','hidden',date('Y-m-d H:i:s'));
        $crud->field_type('jrl_fecha_modificacion','hidden',date('Y-m-d H:i:s'));

        if(end(explode('/',uri_string()))=='add') {
            $crud->field_type('jrl_estado','hidden',1);
        }else {
            $crud->field_type('jrl_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        
        if(!$permisos["permite_editar"]){
            $crud->unset_edit();
        }
        if(!$permisos["permite_eliminar"]){
            $crud->unset_delete();
        }
        if(!$permisos["permite_agregar"]){
            $crud->unset_add();
        }
        if(!$permisos["permite_ver"]){
            $crud->unset_read();
        } else {
            $data_url = $this->masterpage->getUsuario();
            $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
            $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
        }

        $output = $crud->render();
        $data['titulo_personal']="Jornada Laboral";
        $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'modulo_seleccion_personal/slp_mantenimientos/jornada_laboral';
        cargarvista($data, $output, $ruta_vista);
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a Tipo de entrevista (tabla: tnv_tipo_entrevista)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 04-06-2020
     * @param null
     * @return Mantenimiento de Tipo de entrevista
     */
    public function tipo_entrevista(){
        satelite_validar();

        $columns = array(
            'tnv_nombre', 
            'tnv_descripcion',
            'tnv_estado'
        );

        $display_as = array(
            'tnv_nombre'        => 'Nombre',
            'tnv_descripcion'   => 'Descripcion',
            'tnv_estado'        => 'Estado'
        );

        $add_fields = array(
            'tnv_nombre', 
            'tnv_descripcion',
            'tnv_estado',
            'tnv_usu_creacion',
            'tnv_fecha_creacion',
            'tnv_usu_modificacion',
            'tnv_fecha_modificacion'
        );

        $edit_fields = array(
            'tnv_nombre', 
            'tnv_descripcion',
            'tnv_estado',
            'tnv_usu_modificacion',
            'tnv_fecha_modificacion'
        );

        $required = array(
            'tnv_nombre',
            'tnv_descripcion'
        );

        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud =  new grocery_CRUD();
        $crud->set_subject('Tipo de entrevista');
        $crud->set_table('tnv_tipo_entrevista');
        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->add_fields($add_fields);
        $crud->edit_fields($edit_fields);
        $crud->required_fields($required);
        $crud->set_rules('tnv_nombre','nombre','trim|required|campo_unico[tnv_tipo_entrevista.tnv_nombre]');
        $crud->set_rules('tnv_estado','estado','trim|required');
        $crud->field_type('tnv_usu_creacion','hidden',$this->tank_auth->get_user_id());
        $crud->field_type('tnv_usu_modificacion','hidden',$this->tank_auth->get_user_id());
        $crud->field_type('tnv_fecha_creacion','hidden',date('Y-m-d H:i:s'));
        $crud->field_type('tnv_fecha_modificacion','hidden',date('Y-m-d H:i:s'));

        if(end(explode('/',uri_string()))=='add') {
            $crud->field_type('tnv_estado','hidden',1);
        }else {
            $crud->field_type('tnv_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        
        if(!$permisos["permite_editar"]){
            $crud->unset_edit();
        }
        if(!$permisos["permite_eliminar"]){
            $crud->unset_delete();
        }
        if(!$permisos["permite_agregar"]){
            $crud->unset_add();
        }
        if(!$permisos["permite_ver"]){
            $crud->unset_read();
        } 
        // else {
        //     $data_url = $this->masterpage->getUsuario();
        //     $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
        //     $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
        // }

        $output = $crud->render();
        $data['titulo_personal']="Tipo Entrevista";
        //$ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'modulo_seleccion_personal/slp_mantenimientos/jornada_laboral';
        cargarvista($data, $output, 'modulo_seleccion_personal/slp_mantenimientos/tipo_entrevista');
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a Tipo de pruebas (tabla: tib_tipo_prueba)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 05-06-2020
     * @param null
     * @return Mantenimiento de Tipo de pruebas
     */
    public function tipo_prueba(){
        satelite_validar();

        $columns = array(
            'tib_nombre', 
            'tib_descripcion',
            'tib_estado'
        );

        $display_as = array(
            'tib_nombre'        => 'Nombre',
            'tib_descripcion'   => 'Descripcion',
            'tib_estado'        => 'Estado'
        );

        $add_fields = array(
            'tib_nombre', 
            'tib_descripcion',
            'tib_estado',
            'tib_usu_creacion',
            'tib_fecha_creacion',
            'tib_usu_modificacion',
            'tib_fecha_modificacion'
        );

        $edit_fields = array(
            'tib_nombre', 
            'tib_descripcion',
            'tib_estado',
            'tib_usu_modificacion',
            'tib_fecha_modificacion'
        );

        $required = array(
            'tib_nombre',
            'tib_descripcion'
        );

        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud =  new grocery_CRUD();
        $crud->set_subject('Tipo de prueba');
        $crud->set_table('tib_tipo_prueba');
        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->add_fields($add_fields);
        $crud->edit_fields($edit_fields);
        $crud->required_fields($required);
        $crud->set_rules('tib_nombre','nombre','trim|required|campo_unico[tib_tipo_prueba.tib_nombre]');
        $crud->set_rules('tib_estado','estado','trim|required');
        $crud->field_type('tib_usu_creacion','hidden',$this->tank_auth->get_user_id());
        $crud->field_type('tib_usu_modificacion','hidden',$this->tank_auth->get_user_id());
        $crud->field_type('tib_fecha_creacion','hidden',date('Y-m-d H:i:s'));
        $crud->field_type('tib_fecha_modificacion','hidden',date('Y-m-d H:i:s'));

        if(end(explode('/',uri_string()))=='add') {
            $crud->field_type('tib_estado','hidden',1);
        }else {
            $crud->field_type('tib_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        
        if(!$permisos["permite_editar"]){
            $crud->unset_edit();
        }
        if(!$permisos["permite_eliminar"]){
            $crud->unset_delete();
        }
        if(!$permisos["permite_agregar"]){
            $crud->unset_add();
        }
        if(!$permisos["permite_ver"]){
            $crud->unset_read();
        } 
        // else {
        //     $data_url = $this->masterpage->getUsuario();
        //     $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
        //     $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
        // }

        $output = $crud->render();
        $data['titulo_personal']="Tipo Prueba";
        //$ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'modulo_seleccion_personal/slp_mantenimientos/jornada_laboral';
        cargarvista($data, $output, 'modulo_seleccion_personal/slp_mantenimientos/tipo_prueba');
    }

}
/* End of file slp_mantenimientos.php */
/* Location: ./application/controllers/modulo_seleccion_personal */