<?php
/**
 * pre_reportes.php
 * Descripción:
 * Funcionalidad de reporteria del sistema.
 *
 * @package ERP
 * @subpackage Modulo - Presupuesto
 * @copyright Copyright (c) 2018 Grupo Satélite S.A. DE C.V.
 * @author Edith Herrera - Grupo Satélite
 * @version 2018 - 1
 * @since Archivo disponible desde 2018-04-02
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Pre_reportes extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('gsatelite');
        $this->load->library('grocery_CRUD');
        $this->load->model('presupuesto_model');
        $this->load->library('tank_auth');
        $this->load->library('pdf');
        $this->load->model('compras_model');
    }

    /**
     * Descripción:
     * Función para la vista index
     * @author Edith Herrara - Grupo Satélite
     * @since 2018-04-02
     * @param ninguno
     * @return la vista de inicio del modulo
     */
    public function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }
    
    /**
     * Descripción:
     * Función para la vista y generar reporte de presupuesto
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-12-19
     * @param ninguno
     * @return HTML, PDF, Excel para reporte
     */
   public function reporte_presupuesto(){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        
        if ($this->input->post()) {
            $rpt_proyecto           = ( is_numeric($this->input->post('rpt_proyecto')) && $this->input->post('rpt_proyecto') > 0 )?  $this->input->post('rpt_proyecto') : null;
            $rpt_tipo_presupuesto   = ( is_numeric($this->input->post('rpt_tipo_presupuesto')) && $this->input->post('rpt_tipo_presupuesto') > 0 )?  $this->input->post('rpt_tipo_presupuesto') : null;
            $rpt_estado_presupuesto = ( is_numeric($this->input->post('rpt_estado_presupuesto')) && $this->input->post('rpt_estado_presupuesto') > 0 )?  $this->input->post('rpt_estado_presupuesto') : null;
            $rpt_presupuesto        = ( is_numeric($this->input->post('rpt_presupuesto')) && $this->input->post('rpt_presupuesto') > 0 )?  $this->input->post('rpt_presupuesto') : null;
            $tipo_reporte   = ( $this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';
            
            $where  = array();
            if ( $rpt_proyecto != null ) {
                $where["psp_id_pcl"]           = $rpt_proyecto;
            }
            
            if ( $rpt_tipo_presupuesto != null ) {
                $where["psp_id_tpp"]           = $rpt_tipo_presupuesto;
            }
            
            if ( $rpt_estado_presupuesto != null ) {
                $where['psp_estado_prespuesto'] =  $rpt_estado_presupuesto;
            }
            
            if ( $rpt_presupuesto != null ) {
                $where['psp_id']                = $rpt_presupuesto;
            }
            
            $groupby = 'psp_id';
            
            // Parametro para obtener la cantidad de decimales
            $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
            
            $data['consulta']       = $this->presupuesto_model->obtener_presupuesto_grid($where, $groupby); // print_r($this->db->last_query());die();
            $data["tipo_reporte"]   = $tipo_reporte;
            $filename               = 'Reporte_general_presupuesto_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']         = 'General de Presupuesto';
            $data['filename']       = $filename;
            // $data['desde']           = date('d-m-Y', strtotime( $fecha_inicio ) );
            // $data['fin']         = date('d-m-Y', strtotime( $fecha_fin ) );
            $html                   = $this->load->view('modulo_presupuesto/pre_reportes/reporte_general_presupuesto', $data, true);
            
            if ($tipo_reporte == 'pdf') {
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_general_presupuesto_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Reporte_general_presupuesto_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            } else {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            }
            
        } else {
            // Filtros de la vista
            $select                   = $this->gsatelite->get_dropdown('tpp_tipo_presupuesto', '{tpp_codigo} - {tpp_nombre}', '', array('tpp_estado' => '1'), null, '', 'tpp_id', true);
            $data['tipo_presupuesto'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array('pcl_estado' => '1'), null, '', 'pcl_id', true);
            $data['proyectos']        = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('psp_presupuesto', '{psp_codigo} - {psp_nombre}', '', array('psp_estado' => '1'), null, '', 'psp_id', true);
            $data['presupuestos']     = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            // Parametro para obtener la cantidad de decimales
            $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
            
            // Mostrar la vista para el reporte
            $data['titulo_personal']= 'Reporte General de Presupuestos';
            cargarvista($data);
        }
    }
    
    /**
     * Descripción:
     * Función para obtener los presupuestos por tipo
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-12-19
     * @param Ninguno
     * @return HTML con los datos de los presupuestos segun tipo
     */
    public function obtener_presupuestosxtipo() {
        satelite_validar(); // validar si se esta logueado
        
        if ($this->input->post()) {
            // Obtener los datos POST
            $id_tipo_presupuesto   = (is_numeric($this->input->post("id_tipo_presupuesto")) && $this->input->post("id_tipo_presupuesto") > 0) ? $this->input->post("id_tipo_presupuesto") : null;
            $estado_presupuesto    = (is_numeric($this->input->post("estado_presupuesto")) && $this->input->post("estado_presupuesto") > 0) ? $this->input->post("id_tipo_presupuesto") : null;
            
            // Filtrar
            $where = array();
            if (is_numeric($id_tipo_presupuesto) && $id_tipo_presupuesto > 0) {
                $where['psp_id_tpp']            = $id_tipo_presupuesto;
            }
            if (is_numeric($estado_presupuesto) && $estado_presupuesto > 0) {
                $where['psp_estado_prespuesto'] = $estado_presupuesto;
            }
            // $where['psp_estado']         = 1;
            
            // Obtener los presupuestos segun el tipo
            $select     = $this->gsatelite->get_dropdown('psp_presupuesto', '{psp_codigo} - {psp_nombre}', '', $where, null, '', 'psp_id', true);
            $select     = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            echo json_encode(array('html' => $select));
            die();
        }
    }

    /**
     * Descripción:
     * Función para la vista y generar reporte de ejecucion de gastos
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-12-20
     * @param  ninguno
     * @return HTML, PDF, Excel para reporte
     */
    public function reporte_ejecucion_gastos() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        
        if ($this->input->post()) {
            $rpt_proyecto           = ( is_numeric($this->input->post('rpt_proyecto')) && $this->input->post('rpt_proyecto') > 0 )?  $this->input->post('rpt_proyecto') : null;
            $rpt_tipo_presupuesto   = ( is_numeric($this->input->post('rpt_tipo_presupuesto')) && $this->input->post('rpt_tipo_presupuesto') > 0 )?  $this->input->post('rpt_tipo_presupuesto') : null;
            $rpt_presupuesto        = ( is_numeric($this->input->post('rpt_presupuesto')) && $this->input->post('rpt_presupuesto') > 0 )?  $this->input->post('rpt_presupuesto') : null;
            $tipo_reporte           = ( $this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';
            
            $where  = array();
            if ( $rpt_proyecto != null ) {
                $where["psp_id_pcl"]	       = $rpt_proyecto;
            }
            
            if ( $rpt_tipo_presupuesto != null ) {
                $where["psp_id_tpp"]	       = $rpt_tipo_presupuesto;
            }
            
            if ( $rpt_presupuesto != null ) {
                $where['psp_id']                = $rpt_presupuesto;
            } else {
                $this->gsatelite->show_dialog("No se ha seleccionado ningun presupuesto", "modulo_presupuesto/pre_reportes/reporte_ejecucion_gastos", "error", "Reporte de Ejecucion de Gastos");
                die();
            }
            
            $groupby = '';
            
            // Procesar los datos del presupuesto
            $presupuesto            = $this->presupuesto_model->obtener_presupuesto(array("psp_id" => $rpt_presupuesto));
            $data['presupuesto']    = $presupuesto;          
            // Obtener los ID de los detalles
            $dtll_presupuesto = $this->gsatelite->get_tabla("dps_detalle_presupuesto", array("dps_id_psp" => $rpt_presupuesto));
            $dtll_pre_ids     = array_column($dtll_presupuesto, "dps_id"); 
            
            $data['fecha_inicio']   = formatear_fecha("Y-m-d", $presupuesto[0]['psp_fecha_desde']);
            $data['fecha_fin']      = formatear_fecha("Y-m-d", $presupuesto[0]['psp_fecha_hasta']);
            
            // Procesar fechas de presupuesto
            $f1 = new DateTime( formatear_fecha("Y-m-d", $presupuesto[0]['psp_fecha_desde']) );
            $f2 = new DateTime( formatear_fecha("Y-m-d", $presupuesto[0]['psp_fecha_hasta']) );
            
            // obtener la diferencia de fechas
            $diferencia = $f1->diff($f2);
            
            // Obtener la cantidad de meses entre un rango de fechas
            $data['cant_meses'] = ( ( $diferencia->y * 12 ) + $diferencia->m ); 
            
            // Parametro para obtener la cantidad de decimales
            $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
            
            // Query principal para obtener los datos del reporte
            $orderby                = "acg_id, acg_nombre";
            $data['consulta'] 		= $this->presupuesto_model->obtener_detalle_ejecucion_gastos($where, $groupby, $orderby);
            $data['detalles']       = $this->presupuesto_model->reporte_detalle_gastos_ejecucion(array("dps_id_psp" => $rpt_presupuesto));
            $data["tipo_reporte"]   = $tipo_reporte;
            
            $filename               = 'Reporte_ejecucion_gastos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']         = 'Ejecución de Gastos';
            $data['filename']       = $filename;
            $html 					= $this->load->view('modulo_presupuesto/pre_reportes/consulta_ejecucion_gastos', $data, true);
            if ($tipo_reporte == 'pdf') {
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_ejecucion_gastos_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Reporte_ejecucion_gastos_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            } else {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            }
            
        } else {
            // Filtros de la vista
            $select                   = $this->gsatelite->get_dropdown('tpp_tipo_presupuesto', '{tpp_codigo} - {tpp_nombre}', '', array('tpp_estado' => '1'), null, '', 'tpp_id', true);
            $data['tipo_presupuesto'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array('pcl_estado' => '1'), null, '', 'pcl_id', true);
            $data['proyectos']        = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('psp_presupuesto', '{psp_codigo} - {psp_nombre}', '', array('psp_estado_prespuesto' => 2,'psp_estado' => '1'), null, '', 'psp_id', true);
            $data['presupuestos']     = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            // Parametro para obtener la cantidad de decimales
            $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
            
            // Mostrar la vista para el reporte
            $data['titulo_personal']= 'Reporte de Ejecución de Gastos';
            cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función para la vista y generar reporte de presupuesto por area.
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-01-08
     * @param  ninguno
     * @return HTML, PDF, Excel para reporte
     */
    public function presupuesto_area_servicio() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        if ( $this->input->post() ) { 
            $rpt_proyecto           = ( is_numeric($this->input->post('rpt_proyecto')) && $this->input->post('rpt_proyecto') > 0 )?  $this->input->post('rpt_proyecto') : null;
            $rpt_tipo_presupuesto   = ( is_numeric($this->input->post('rpt_tipo_presupuesto')) && $this->input->post('rpt_tipo_presupuesto') > 0 )?  $this->input->post('rpt_tipo_presupuesto') : null;
            $rpt_presupuesto        = ( is_numeric($this->input->post('rpt_presupuesto')) && $this->input->post('rpt_presupuesto') > 0 )?  $this->input->post('rpt_presupuesto') : null;
            $tipo_reporte           = ( $this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';
            $rpt_areas              = ( is_numeric($this->input->post('rpt_areas')) && $this->input->post('rpt_areas') > 0 )?  $this->input->post('rpt_areas') : null;
            
            $where  = array();
            if ( $rpt_proyecto != null ) {
                $where["psp_id_pcl"]	       = $rpt_proyecto;
            }
            
            if ( $rpt_tipo_presupuesto != null ) {
                $where["psp_id_tpp"]	       = $rpt_tipo_presupuesto;
            }

            if ( $rpt_areas != null ) {
                $where["dps_id_ace"]	       = $rpt_areas;
            }
           
            if ( $rpt_presupuesto != null ) {
                $where['psp_id']                = $rpt_presupuesto;
            } else {
                $this->gsatelite->show_dialog("No se ha seleccionado ningun presupuesto", "modulo_presupuesto/pre_reportes/reporte_ejecucion_gastos", "error", "Reporte de Ejecucion de Gastos");
                die();
            }
           
            $groupby = '';
            
            // Procesar los datos del presupuesto
            $presupuesto            = $this->presupuesto_model->obtener_presupuesto(array("psp_id" => $rpt_presupuesto));
            $data['presupuesto']    = $presupuesto;          

            // Obtener los ID de los detalles
            $dtll_presupuesto = $this->gsatelite->get_tabla("dps_detalle_presupuesto", array("dps_id_psp" => $rpt_presupuesto));
            $dtll_pre_ids     = array_column($dtll_presupuesto, "dps_id");
            
            $data['fecha_inicio']   = formatear_fecha("Y-m-d", $presupuesto[0]['psp_fecha_desde']);
            $data['fecha_fin']      = formatear_fecha("Y-m-d", $presupuesto[0]['psp_fecha_hasta']);
            
            // Procesar fechas de presupuesto
            $f1 = new DateTime( formatear_fecha("Y-m-d", $presupuesto[0]['psp_fecha_desde']) );
            $f2 = new DateTime( formatear_fecha("Y-m-d", $presupuesto[0]['psp_fecha_hasta']) );
            
            // obtener la diferencia de fechas
            $diferencia = $f1->diff($f2);
            
            // Obtener la cantidad de meses entre un rango de fechas
            $data['cant_meses'] = ( ( $diferencia->y * 12 ) + $diferencia->m ); 
            
            // Parametro para obtener la cantidad de decimales
            $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
            
            // Query principal para obtener los datos del reporte
            $groupby                = "dps_id_ace";
            $data['consulta'] 		= $this->presupuesto_model->obtener_detalle_ejecucion_gastos_agrupado($where, $groupby,null);
            $orderby                = "";
            $data['detalles']       = $this->presupuesto_model->reporte_detalle_gastos_ejecucion_area(array("dps_id_psp" => $rpt_presupuesto),null,null);            
            $data["tipo_reporte"]   = $tipo_reporte;

            $filename               = 'Reporte_presupuesto_por_actividad_especifica_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']         = 'Presupuesto de área de servicio';
            $data['filename']       = $filename;
            $html 					= $this->load->view('modulo_presupuesto/pre_reportes/consultar_area_servicio', $data, true);
            if ($tipo_reporte == 'pdf') {
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_presupuesto_por_actividad_especifica__' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Reporte_presupuesto_actividad_especifica_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            } else {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            }            
        } else {
            // Filtros de la vista
            $select                   = $this->gsatelite->get_dropdown('tpp_tipo_presupuesto', '{tpp_codigo} - {tpp_nombre}', '', array('tpp_estado' => '1'), null, '', 'tpp_id', true);
            $data['tipo_presupuesto'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array('pcl_estado' => '1'), null, '', 'pcl_id', true);
            $data['proyectos']        = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('psp_presupuesto', '{psp_codigo} - {psp_nombre}', '', array('psp_estado_prespuesto' => 2,'psp_estado' => '1'), null, '', 'psp_id', true);
            $data['presupuestos']     = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            // Parametro para obtener la cantidad de decimales
            $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
            
            // Mostrar la vista para el reporte
            $data['titulo_personal']= 'Reporte de Presupuesto por actividad específica';
            cargarvista($data);
        }
    }

    public function get_areas(){
        satelite_validar();
        if ($_POST) {
            $presupuesto = $this->input->post('presupuesto');
            $this->db->group_by("ace_id");
            $this->db->join("dps_detalle_presupuesto","dps_id_ace = ace_id");
            $result = $this->gsatelite->get_dropdown('ace_actividad_especifica', '{ace_codigo} - {ace_nombre}', '', array('dps_id_psp' => $presupuesto), null, '', 'ace_id', true);
            $result = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $result);
            $result = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $result);
            echo ($result);
        }
    }

    /**
     * Descripción:
     * Función para la vista y generar reporte de presupuesto por comprometido
     * @author Francisco Orozco - Grupo Satélite
     * @since  2019-02-22
     * @param  ninguno
     * @return HTML, PDF, Excel para reporte
    */
    public function presupuesto_comprometido(){
        if ($_POST) {
            $txtFechaFin                = $this->input->post('txtFechaFin');         
            $slcProyecto                = ( is_numeric($this->input->post('slcProyecto')) && $this->input->post('slcProyecto') > 0 )?  $this->input->post('slcProyecto') : null;
            $slc_presupuesto            = ( is_numeric($this->input->post('slc_presupuesto')) && $this->input->post('slc_presupuesto') > 0 )?  $this->input->post('slc_presupuesto') : null;
            $slc_actividad_general      = ( is_numeric($this->input->post('slc_actividad_general')) && $this->input->post('slc_actividad_general') > 0 )?  $this->input->post('slc_actividad_general') : null;
            $slc_actividad_espeficifica = ( is_numeric($this->input->post('slc_actividad_espeficifica')) && $this->input->post('slc_actividad_espeficifica') > 0 )?  $this->input->post('slc_actividad_espeficifica') : null;
            $tipo_reporte               = ( $this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';
         
            if ( $txtFechaFin != "" ) {
                $where['date(psp_fecha_desde) <='] = formatear_fecha('Y-m-d',$txtFechaFin);
            }
            
            if ( $slcProyecto != "" ) {
                $where['psp_id_pcl'] = $slcProyecto;
            }

            if ( $slc_presupuesto != "" ) {
                $where['psp_id'] = $slc_presupuesto;
            }

            if ( $slc_actividad_general != "" ) {
                $where['acg_id'] = $slc_actividad_general;
            }
            
            if ( $slc_actividad_espeficifica != "" ) {
                $where['ace_id'] = $slc_actividad_espeficifica;
            }
            $group_by               = 'dps_id_ace';
            $consulta               = $this->presupuesto_model->get_detalles_presupuesto($where,$group_by);
            $data["consulta"]       = $consulta;
            $data["tipo_reporte"]   = $tipo_reporte;
            $data["fecha"]          = formatear_fecha('d-m-Y',$txtFechaFin);
            $filename               = 'Reporte_presupuesto_comprometido_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']         = 'Reporte de presupuesto comprometido';
            $data['filename']       = $filename;
            $html 					= $this->load->view('modulo_presupuesto/pre_reportes/consultar_presupuesto_comprometido', $data, true);

            if ($tipo_reporte == 'pdf') {
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_presupuesto_comprometido_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte,'L', 'Reporte_presupuesto_comprometido_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            } else {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            } 

        } else{
            $proyectos              = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array('pcl_estado' => 1), null, null, 'pcl_id', true);
            $data['proyectos']      = str_replace('<option value="0">Seleccione</option>', '', $proyectos);
            $data['titulo_personal']= 'Reporte de Presupuesto comprometido';
            cargarvista($data);
        }
    }

     /** 
        * @author Francisco Orozco
        * @since: 21/02/2019
        * Descripcion: Se obtienen los presupuestos que depende de un proyecto
        * @return presupuestos
    */
    function get_presupuestoxproyecto($proyecto = "", $seleccionado = "") {
        if ($_POST) { 
            $proyecto = $this->input->post('proyecto');
        }
        $where = array(
            'psp_estado'                    => 1,
            '(psp_id_pcl = '.$proyecto.')'  => NULL
        );
        $presupuestos   = $this->gsatelite->get_tabla("psp_presupuesto",$where);
        $html           = '<option value=""></option>';
        foreach ($presupuestos as $value) {
            $selected   = "";
            if ( $value['psp_id'] == $seleccionado) {
                $selected = "selected";
            }
            $html .= '<option value="'.$value['psp_id'].'" '.$selected.'>'.$value['psp_nombre'].'</option>';
        }
        if ($_POST) {
            echo trim($html);
        } else {
            return trim($html);
        }       
    }

    /**
        * @author Francisco Orozco
        * @since: 21/02/2019
        * Descripcion: Se obtienen las actividades general de un presupuesto
        * @return actividades generales
    */
    function get_actividades_generalesxpresupusto($presupuesto = "", $seleccionado = "") {
        satelite_validar();
        if ($_POST) {
            $presupuesto = $this->input->post('presupuesto');
        } 

        $where = array(
            'acg_estado'    => 1,
            'dps_id_psp'    => $presupuesto
        );

        $this->db->group_by("acg_id");
        $this->db->join("dps_detalle_presupuesto","dps_id_acg = acg_id");
        $actividades_generales_array= $this->presupuesto_model->get_actividades_generales($where);
        $actividades_generales      = '<option value=""></option>';               
        foreach ($actividades_generales_array as $value) {
            $usuarios_permitidos= explode(",",$value['usuarios']); 
            
            if ( in_array( $this->tank_auth->get_user_id(), $usuarios_permitidos ) ) {
                $actividades_generales .= '<option value="'.$value['acg_id'].'">'.$value['acg_codigo'].' - '.$value['acg_nombre'].'</option>';
            }
        }

        $html = $actividades_generales;

        if ($_POST) {
            echo trim($html);
        } else {
            return trim($html);
        }   
    }

    /**
        * @author Francisco Orozco
        * @since: 21/02/2019
        * Descripcion: Se obtienen las actividades especificas de un de una actividad general
        * @return actividades especificas
    */
    function get_actividades_especificas_x_actividad_general($general = "", $presupuesto = "", $seleccionado = "") {
        satelite_validar();
        if ($_POST) { 
            $general    = $this->input->post('general');
            $presupuesto= $this->input->post('presupuesto');
        }
        $where = array(
            'dps_estado'    => 1,
            'dps_id_psp'    => $presupuesto,
            'dps_id_acg'    => $general
        );
        $select                 = "*, SUM(dps_presupuesto_actividad - (IFNULL(dps_presupuesto_ejecutado,0)) ) as total";
        $group_by               = "ace_id";
        $actividades_generales  = $this->compras_model->get_actividades_x_presupusto($select, $where, $group_by);
        $html                   = '<option value=""></option>';
        foreach ($actividades_generales as $value) {
            $selected   = "";
            if ( $value['ace_id'] == $seleccionado) {
                $selected = "selected";
            }
            $html .= '<option value="'.$value['ace_id'].'" '.$selected.'>'.$value['ace_codigo']." - ".$value['ace_nombre'].' ('.number_format($value['total'],2,".",",").')</option>';
        }
        if ($_POST) {
            echo trim($html);
        } else {
            return trim($html);
        }   
    }

     /**
        * @author Francisco Orozco
        * @since: 05/04/2019
        * Descripcion: Reporte de gastos
        * @return reporte de gastos
    */
    public function gastos(){
        if ($_POST) { 
            $slcProyecto                = ( is_numeric($this->input->post('slcProyecto')) && $this->input->post('slcProyecto') > 0 )?  $this->input->post('slcProyecto') : null;
            $slc_presupuesto            = ( is_numeric($this->input->post('slc_presupuesto')) && $this->input->post('slc_presupuesto') > 0 )?  $this->input->post('slc_presupuesto') : null;
            $slc_actividad_general      = ( is_numeric($this->input->post('slc_actividad_general')) && $this->input->post('slc_actividad_general') > 0 )?  $this->input->post('slc_actividad_general') : null;
            $slc_actividad_espeficifica = ( is_numeric($this->input->post('slc_actividad_espeficifica')) && $this->input->post('slc_actividad_espeficifica') > 0 )?  $this->input->post('slc_actividad_espeficifica') : null;
            $tipo_reporte               = ( $this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';

            if ( $slcProyecto != "" ) {
                $where['psp_id_pcl'] = $slcProyecto;
            }

            if ( $slc_presupuesto != "" ) {
                $where['psp_id'] = $slc_presupuesto;
            }

            if ( $slc_actividad_general != "" ) {
                $where['dps_id_acg'] = $slc_actividad_general;
            }
            
            if ( $slc_actividad_espeficifica != "" ) {
                $where['dps_id_ace'] = $slc_actividad_espeficifica;
            }

            $group_by               = 'dgp_id';
            $order_by               = 'dgp_fecha';
            $consulta               = $this->presupuesto_model->reporte_detalle_gastos_ejecucion($where,$group_by,$order_by);
            //var_dump($this->db->last_query());die();
            $data["consulta"]       = $consulta;
            $data["tipo_reporte"]   = $tipo_reporte;
            $filename               = 'Reporte_gastos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']         = 'Reporte de gastos';
            $data['filename']       = $filename;
            $html 					= $this->load->view('modulo_presupuesto/pre_reportes/consultar_gastos', $data, true);

            if ($tipo_reporte == 'pdf') {
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_gastos_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte,'L', 'Reporte_gastos_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            } else {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            } 
        } else {
            $proyectos              = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array('pcl_estado' => 1), null, null, 'pcl_id', true);
            $data['proyectos']      = str_replace('<option value="0">Seleccione</option>', '', $proyectos);
            $data['titulo_personal']= 'Reporte de Presupuesto comprometido';
            cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función para cargar los datos en la vista o pdf, excel del reporte plan de compras
     * @author Francisco Orozco - Grupo Satélite
     * @since  2019-05-09
     * @param  Ninguno
     * @return Datos o vista del reporte de plan de compras
     */
    public function plan_compras(){
        satelite_validar();
        if ($this->input->post()) {
            $rpt_proyecto           = ( is_numeric($this->input->post('rpt_proyecto')) && $this->input->post('rpt_proyecto') > 0 )?  $this->input->post('rpt_proyecto') : null;
            $rpt_tipo_presupuesto   = ( is_numeric($this->input->post('rpt_tipo_presupuesto')) && $this->input->post('rpt_tipo_presupuesto') > 0 )?  $this->input->post('rpt_tipo_presupuesto') : null;
            $rpt_presupuesto        = ( is_numeric($this->input->post('rpt_presupuesto')) && $this->input->post('rpt_presupuesto') > 0 )?  $this->input->post('rpt_presupuesto') : null;
            $tipo_reporte           = ( $this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';
            
            $where  = array();
            if ( $rpt_proyecto != null ) {
                $where["psp_id_pcl"]	       = $rpt_proyecto;
            }
            
            if ( $rpt_tipo_presupuesto != null ) {
                $where["psp_id_tpp"]	       = $rpt_tipo_presupuesto;
            }
            
            if ( $rpt_presupuesto != null ) {
                $where['psp_id']                = $rpt_presupuesto;
            } else {
                $this->gsatelite->show_dialog("No se ha seleccionado ningun presupuesto", "modulo_presupuesto/pre_reportes/plan_compras", "error", "Reporte de Ejecucion de Gastos");
                die();
            }

            $groupby = '';
            
            // Procesar los datos del presupuesto
            $presupuesto            = $this->presupuesto_model->obtener_presupuesto(array("psp_id" => $rpt_presupuesto));
            $data['presupuesto']    = $presupuesto;          
            // Obtener los ID de los detalles
            $dtll_presupuesto = $this->gsatelite->get_tabla("dps_detalle_presupuesto", array("dps_id_psp" => $rpt_presupuesto));
            $dtll_pre_ids     = array_column($dtll_presupuesto, "dps_id"); 
            
            $data['fecha_inicio']   = formatear_fecha("Y-m-d", $presupuesto[0]['psp_fecha_desde']);
            $data['fecha_fin']      = formatear_fecha("Y-m-d", $presupuesto[0]['psp_fecha_hasta']);
            
            // Procesar fechas de presupuesto
            $f1 = new DateTime( formatear_fecha("Y-m-d", $presupuesto[0]['psp_fecha_desde']) );
            $f2 = new DateTime( formatear_fecha("Y-m-d", $presupuesto[0]['psp_fecha_hasta']) );
            
            // obtener la diferencia de fechas
            $diferencia = $f1->diff($f2);
            
            // Obtener la cantidad de meses entre un rango de fechas
            $data['cant_meses'] = ( ( $diferencia->y * 12 ) + $diferencia->m ); 
            
            // Parametro para obtener la cantidad de decimales
            $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
            
            // Query principal para obtener los datos del reporte
            $orderby                = "acg_nombre, acg_id, ace_nombre, ace_id";
            $data['consulta'] 		= $this->presupuesto_model->obtener_detalle_ejecucion_gastos($where, $groupby, $orderby);
            //$orderby                = "acg_nombre, acg_id, ace_nombre, ace_id";
            $data['detalles']       = $this->presupuesto_model->get_plan_compras_mensual(array("dps_id_psp" => $rpt_presupuesto),null,$orderby);
            $data["tipo_reporte"]   = $tipo_reporte;
            
            $filename               = 'Reporte_plan_compras_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']         = 'Plan de compras';
            $data['filename']       = $filename;
            $html 					= $this->load->view('modulo_presupuesto/pre_reportes/consulta_plan_compras', $data, true);
            if ($tipo_reporte == 'pdf') {
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_plan_compras_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Reporte_plan_compras_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            } else {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            }

        } else {
            // Filtros de la vista
            $select                   = $this->gsatelite->get_dropdown('tpp_tipo_presupuesto', '{tpp_codigo} - {tpp_nombre}', '', array('tpp_estado' => '1'), null, '', 'tpp_id', true);
            $data['tipo_presupuesto'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array('pcl_estado' => '1'), null, '', 'pcl_id', true);
            $data['proyectos']        = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('psp_presupuesto', '{psp_codigo} - {psp_nombre}', '', array('psp_estado_prespuesto' => 2,'psp_estado' => '1'), null, '', 'psp_id', true);
            $data['presupuestos']     = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            // Parametro para obtener la cantidad de decimales
            $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
            
            // Mostrar la vista para el reporte
            $data['titulo_personal']= 'Reporte de Ejecución de Gastos';
            cargarvista($data);
        }

    }

            /**
        * @author Marlon Olmedo
        * @since: 26/06/2019
        * Descripcion: reporte el cual muestre el porcentaje de ejecución que se ha tenido de un presupuesto
        * @return vista del porcentaje del presupuesto
    */
    public function porcentaje_ejecucion_presupuesto() {
        satelite_validar();

        if ($_POST) { 
            $slcProyecto                = ( is_numeric($this->input->post('slcProyecto')) && $this->input->post('slcProyecto') > 0 )?  $this->input->post('slcProyecto') : null;
            $slc_presupuesto            = ( is_numeric($this->input->post('slc_presupuesto')) && $this->input->post('slc_presupuesto') > 0 )?  $this->input->post('slc_presupuesto') : null;
            $slc_actividad_general      = ( is_numeric($this->input->post('slc_actividad_general')) && $this->input->post('slc_actividad_general') > 0 )?  $this->input->post('slc_actividad_general') : null;
            $slc_actividad_espeficifica = ( is_numeric($this->input->post('slc_actividad_espeficifica')) && $this->input->post('slc_actividad_espeficifica') > 0 )?  $this->input->post('slc_actividad_espeficifica') : null;
            $tipo_reporte               = ( $this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';
            $meses                      = ( $this->input->post('slcMes') != '') ? $this->input->post('slcMes') : '';
/*
            if ( $slcProyecto != "" ) {
                $where['psp_id_pcl'] = $slcProyecto;
            } */

            if ( $slc_presupuesto != "" ) {
                //$data['detalle_agrupador'] = $this->gsatelite->get_tabla("dps_detalle_presupuesto",array("tdc_codigo" => $codigo));
                $where['dps_id_psp'] =  $slc_presupuesto;
            }

            if ( $slc_actividad_general != "" ) {
                $where['acg_id'] = $slc_actividad_general;
            }
            
            if ( $slc_actividad_espeficifica != "" ) {
                $where['ace_id'] = $slc_actividad_espeficifica;
            }

            if ( $meses != "" ) {
                $yeard = date('Y');
                $mesinicio = $yeard.'-'.$meses.'-01';
                $mesfin = $yeard.'-'.$meses.'-30';
                $where["pcp_fecha BETWEEN '$mesinicio' and '$mesfin'"] = null;
                $pcp_fecha = "and pcp_fecha BETWEEN '$mesinicio' and '$mesfin'";
                $dgp_fecha = "and dgp_fecha BETWEEN '$mesinicio' and '$mesfin'";
                $dpv_fecha = "and dpv_fecha_documento BETWEEN '$mesinicio' and '$mesfin'";
                $orc_fecha = "and orc_fecha_orden BETWEEN '$mesinicio' and '$mesfin'";
            }
            //$group_by               = 'dgp_id';
           //$order_by               = 'dgp_fecha';
            //$consulta               = $this->presupuesto_model->reporte_detalle_gastos_ejecucion($where,$group_by,$order_by);
           // $data["consulta"]       = $consulta;
            $data["tipo_reporte"]   = $tipo_reporte;
            $filename               = 'Reporte_Porcentaje_Ejecución_Mensual' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']         = 'Reporte De Porcentaje De Ejecución Mensual';
            $data['filename']       = $filename;

            $data['consulta'] = $this->presupuesto_model->get_porcentaje_eje_mensual($where, $pcp_fecha, $dgp_fecha, $dpv_fecha, $orc_fecha);
            //print_r($this->db->last_query());die();
            $html = $this->load->view('modulo_presupuesto/pre_reportes/grid_ejecucion_presupuesto', $data, true);


            if ($tipo_reporte == 'pdf') {
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_gastos_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte,'L', 'Reporte_gastos_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
                die();
            } else {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            } 
        } else {

        $proyectos              = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array('pcl_estado' => 1), null, null, 'pcl_id', true);
        $data['proyectos']      = str_replace('<option value="0">Seleccione</option>', '', $proyectos);

        }
         $data['titulo_personal']= 'Porcentaje de Ejecución Mensual';
        cargarvista($data);
    
}

public function comparativo_presupuesto(){
    satelite_validar();
      $permisos = $this->gsatelite->get_permisos_opcion();
        
        if ($this->input->post()) {
            $rpt_proyecto           = ( is_numeric($this->input->post('rpt_proyecto')) && $this->input->post('rpt_proyecto') > 0 )?  $this->input->post('rpt_proyecto') : null;
            $rpt_tipo_presupuesto   = ( is_numeric($this->input->post('rpt_tipo_presupuesto')) && $this->input->post('rpt_tipo_presupuesto') > 0 )?  $this->input->post('rpt_tipo_presupuesto') : null;
            $rpt_estado_presupuesto = ( is_numeric($this->input->post('rpt_estado_presupuesto')) && $this->input->post('rpt_estado_presupuesto') > 0 )?  $this->input->post('rpt_estado_presupuesto') : null;
            $rpt_presupuesto        = ( is_numeric($this->input->post('rpt_presupuesto')) && $this->input->post('rpt_presupuesto') > 0 )?  $this->input->post('rpt_presupuesto') : null;
            $tipo_reporte   = ( $this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';
            
            $where  = array();
            if ( $rpt_proyecto != null ) {
                $where["psp_id_pcl"]           = $rpt_proyecto;
            }
            
            if ( $rpt_tipo_presupuesto != null ) {
                $where["psp_id_tpp"]           = $rpt_tipo_presupuesto;
            }
            
            if ( $rpt_estado_presupuesto != null ) {
                $where['psp_estado_prespuesto'] =  $rpt_estado_presupuesto;
            }
            
            if ( $rpt_presupuesto != null ) {
                $where['psp_id']                = $rpt_presupuesto;
            }
            
            $groupby = 'psp_id';
            
            // Parametro para obtener la cantidad de decimales
            $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
            
            $data['consulta']       = $this->presupuesto_model->obtener_presupuesto_grid($where, $groupby); // print_r($this->db->last_query());die();
            $data["tipo_reporte"]   = $tipo_reporte;
            $filename               = 'Reporte_general_presupuesto_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']         = 'General de Presupuesto';
            $data['filename']       = $filename;
            // $data['desde']           = date('d-m-Y', strtotime( $fecha_inicio ) );
            // $data['fin']         = date('d-m-Y', strtotime( $fecha_fin ) );
            $html                   = $this->load->view('modulo_presupuesto/pre_reportes/reporte_general_presupuesto', $data, true);
            
            if ($tipo_reporte == 'pdf') {
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_general_presupuesto_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Reporte_general_presupuesto_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            } else {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            }
            
        } else {
            // Filtros de la vista
            $select                   = $this->gsatelite->get_dropdown('tpp_tipo_presupuesto', '{tpp_codigo} - {tpp_nombre}', '', array('tpp_estado' => '1'), null, '', 'tpp_id', true);
            $data['tipo_presupuesto'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array('pcl_estado' => '1'), null, '', 'pcl_id', true);
            $data['proyectos']        = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('psp_presupuesto', '{psp_codigo} - {psp_nombre}', '', array('psp_estado' => '1'), null, '', 'psp_id', true);
            $data['presupuestos']     = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            // Parametro para obtener la cantidad de decimales
            $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
            
            // Mostrar la vista para el reporte
            $data['titulo_personal']= 'Reporte General de Presupuestos';
            cargarvista($data);
        }
} 


    /**
    * @author Nelson Soriano
    * @since: 23-09-2019
    * Descripcion:Reporte comparativo de presupuestos agrupado por actividades generales y filtrado por años
    * @return  Gernera Preview, reporte en EXCEL y PDF
    */
    public function procesar_reporte_comp($es_reporte = null){
        satelite_validar();
        $inicio       = $this->input->post('inicio');
        $fin          = $this->input->post('fin');
        $tipo_reporte = $this->input->post('tipo_reporte');
        if ($inicio != '' and $fin != '') {
            $where['date_format(psp_fecha_desde,"%Y") BETWEEN '.$inicio.' AND '.$fin.' '] = null;
        }
        $data['titulo']       = 'Reporte Comparativo de presupuestos:<br>Del '.$inicio.' Al '.$fin;
        $data['decimales']    = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!= '')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        $where['dgp_estado']  = 1;
        $where['dps_estado']  = 1;
        $where['acg_estado']  = 1;
        $where['psp_estado']  = 1;
        $data['tipo_reporte'] = $tipo_reporte;
        $data['filename']     = 'Reporte_comparativo_presupuesto_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        $data['info'] = $this->presupuesto_model->get_presupuestos_comp($where);
        $html         = $this->load->view('modulo_presupuesto/pre_reportes/procesar_reporte_comp',$data,true);
        
        if ($tipo_reporte == 'pdf') {
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_general_presupuesto_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Reporte_general_presupuesto_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            } else {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            }
        
    }


    
}

?>