<?php
/**
 * procesos.php
 * Descripción:
 * Funcionalidad del sistema.
 *
 * @package ERP
 * @subpackage Modulo - Presupuesto
 * @copyright Copyright (c) 2018 Grupo Satélite S.A. DE C.V.
 * @author Edith Herrera - Grupo Satélite
 * @version 2018 - 1
 * @since Archivo disponible desde 2018-04-02
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Pre_procesos extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('gsatelite');
        $this->load->library('grocery_CRUD');
        $this->load->model('presupuesto_model');
        $this->load->model('compras_model');        
        $this->load->library('tank_auth');
        $this->load->library('pdf');
        $this->load->library('texto');
    }

    /**
    * Descripción:
    * Función para la vista index
    * @author Edith Herrara - Grupo Satélite
    * @since 2018-04-02
    * @param ninguno
    * @return la vista de inicio del modulo
    */
    public function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }
    
    /**
    * Descripción:
    * Función para la vista index
    * @author Luis Navarro - Grupo Satélite
    * @since 2018-12-10
    * @param ninguno
    * @return Proceso de presupuesto, retonar grid de los presupuestos agregados
    */    
    public function presupuesto() {
        satelite_validar();
        $permisos           = $this->gsatelite->get_permisos_opcion();
        $data['permisos']   = $permisos;
        
        if ($this->input->post()) {
            $estado                  = $this->input->post("estado");
            
            // Obtener el rol que permtiria otorgale permisos de aprobar el presupuesto
            $jefe_unidad             = (trim($this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD')) != "") ? $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD') : '0';
            // usuario logueado
            $usuario                 = $this->tank_auth->get_user_id(); 
            
            // Verifcar y filtrar los datos
            $where                   = array('uxr_id_usu' => $usuario, 'uxr_id_rol IN ('.$jefe_unidad.')' => null);
            // Verificar si logra aprobar o rechazar presupuesto
            $data['tiene_autoridad'] = $this->gsatelite->get_tabla('uxr_usuarioxrol', $where);
            
            // Parametrizacion de los decimales
            $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
            
            // condicional
            $where   = array();
            
            // Verificar el estado del presupuesto
            if (is_numeric($estado) && $estado > 0) {
                $where['psp_estado_prespuesto'] = $estado;
            }
            
            $groupby = 'psp_id';
            $data['detalles'] = $this->presupuesto_model->obtener_presupuesto_grid($where, $groupby); //print_r($this->db->last_query());die();
            $html   = $this->load->view('modulo_presupuesto/pre_procesos/detalle_presupuesto', $data, true);
            echo json_encode(array('html'=>$html));
        } else {
            
            // Cargar la vista
            $data['titulo_personal'] = "Prespuesto";
            cargarvista($data);
        }
        
    }
    
    /**
    * Descripción:
    * Función para la vista index
    * @author Luis Navarro - Grupo Satélite
    * @since 2018-12-10
    * @param ninguno
    * @return Obtener los padres de las actividades especificas
    */  
    public function get_dependencias_actividad_especifica() {
        if ($this->input->post()) {
            $padre        = $this->input->post('padre');
            $act_general  = $this->input->post('actividad_general');

            //$this->db->where('tia_padre', $padre);
            $where = array();
            if (is_numeric($act_general) && $act_general > 0) {
                $where['ace_id_acg'] = $act_general;
            }
            if (is_numeric($padre) && $padre > 0) {
                $where['ace_id_dependencia'] = $padre;
            }
            $hijos  = $this->gsatelite->get_tabla('ace_actividad_especifica', $where);
            $cadena = "<option value='0' selected>Seleccione una opción</option>";

            foreach ($hijos as $key => $value) {
                $cadena .= '<option value="' . $value['ace_id'] . '">'.$value['ace_codigo'].' - '.$value['ace_nombre'] . '</option>';
            }

            if (count($hijos) == 0) {
                $cadena = "";
            }
            
            $arreglo = array('drop' => $cadena, 'padre' => $padre);
            echo json_encode($arreglo);
            die();
        }
    }
    
    /**
    * Descripción:
    * Función para la vista index
    * @author Luis Navarro - Grupo Satélite
    * @since 2018-12-10
    * @param ninguno
    * @return Proceso para agregar presupuesto
    */     
    public function agregar_presupuesto() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('modulo_presupuesto/pre_procesos/presupuesto');
        if ($this->input->post()) {
            // Procesar datos ingresados
            $pre_codigo             = (trim($this->input->post("pre_codigo")) != "") ? $this->input->post("pre_codigo") : null;
            $pre_presupuesto_total  = (is_numeric($this->input->post("pre_presupuesto_total")) && $this->input->post("pre_presupuesto_total") > 0) ? $this->input->post("pre_presupuesto_total"): null;
            $pre_tipo_presupuesto   = (is_numeric($this->input->post("pre_tipo_presupuesto")) && $this->input->post("pre_tipo_presupuesto") > 0) ? $this->input->post("pre_tipo_presupuesto") : null;
            $pre_area               = (is_numeric($this->input->post("pre_area")) && $this->input->post("pre_area") > 0) ? $this->input->post("pre_area") : null;
            $pre_nombre             = (trim($this->input->post("pre_nombre")) != "") ? $this->input->post("pre_nombre") : null;
            $pre_centro_costo       = (is_numeric($this->input->post("pre_centro_costo")) && $this->input->post("pre_centro_costo") > 0) ? $this->input->post("pre_centro_costo") : null;
            $pre_fecha_desde        = (trim($this->input->post("pre_fecha_desde")) != "") ? $this->input->post("pre_fecha_desde") : null;
            $pre_proyecto           = (is_numeric($this->input->post("pre_proyecto")) && $this->input->post("pre_proyecto") > 0) ? $this->input->post("pre_proyecto") : null;
            $pre_fecha_hasta        = (trim($this->input->post("pre_fecha_hasta")) != "") ? $this->input->post("pre_fecha_hasta") : null;
            $pre_ejecutor           = (is_numeric($this->input->post("pre_ejecutor")) && $this->input->post("pre_ejecutor") > 0) ? $this->input->post("pre_ejecutor") : null;
            //$pre_sucursal           = (is_numeric($this->input->post("pre_sucursal")) && $this->input->post("pre_sucursal") > 0) ? $this->input->post("pre_sucursal") : null;
            $pre_seguimiento        = (is_numeric($this->input->post("pre_seguimiento")) && $this->input->post("pre_seguimiento") > 0) ? $this->input->post("pre_seguimiento") : null;
            $pre_financiador        = (is_numeric($this->input->post("pre_financiador")) && $this->input->post("pre_financiador") > 0) ? $this->input->post("pre_financiador") : null;
            $pre_moneda             = (is_numeric($this->input->post("slc_moneda")) && $this->input->post("slc_moneda") > 0) ? $this->input->post("slc_moneda") : null;
            $pre_taza_cambio        = (is_numeric($this->input->post("taza_cambio")) && $this->input->post("taza_cambio") > 0) ? $this->input->post("taza_cambio") : null;
            $pre_tipo_financiador   = (is_numeric($this->input->post("slc_tipo_financiador")) && $this->input->post("slc_tipo_financiador") > 0) ? $this->input->post("slc_tipo_financiador") : null;
            
            // Obtener datos por array 
            $dt_objetivo              = (is_array($this->input->post("dt_objetivo")) && count($this->input->post("dt_objetivo") > 0)) ? $this->input->post("dt_objetivo") : array();
            $dt_fuente_financiamiento = (is_array($this->input->post("dt_fuente_financiamiento")) && count($this->input->post("dt_fuente_financiamiento")) > 0) ? $this->input->post("dt_fuente_financiamiento") : array();
            $dtll_area_servicio       = (is_array($this->input->post("dtll_area_servicio")) && count($this->input->post("dtll_area_servicio")) > 0) ? $this->input->post("dtll_area_servicio") : array();
            $dtll_actividad_general   = (is_array($this->input->post("dtll_actividad_general")) && count($this->input->post("dtll_actividad_general")) > 0) ? $this->input->post("dtll_actividad_general") : array();
            $dtll_actividad_especifica= (is_array($this->input->post("dtll_actividad_especifica")) && count($this->input->post("dtll_actividad_especifica")) > 0) ? $this->input->post("dtll_actividad_especifica") : array();
            $dtll_fecha_desde         = (is_array($this->input->post("dtll_fecha_desde")) && count($this->input->post("dtll_fecha_desde")) > 0) ? $this->input->post("dtll_fecha_desde") : array();
            $dtll_fecha_hasta         = (is_array($this->input->post("dtll_fecha_hasta")) && count($this->input->post("dtll_fecha_hasta")) > 0) ? $this->input->post("dtll_fecha_hasta") : array();
            $dtll_pre_actividad       = (is_array($this->input->post("dtll_pre_actividad")) && count($this->input->post("dtll_pre_actividad")) > 0) ? $this->input->post("dtll_pre_actividad") : array();
            $dtll_aporte_externo      = (is_array($this->input->post("dtll_aporte_externo")) && count($this->input->post("dtll_aporte_externo")) > 0) ? $this->input->post("dtll_aporte_externo") : array();
            $dtll_aporte_interno      = (is_array($this->input->post("dtll_aporte_interno")) && count($this->input->post("dtll_aporte_interno")) > 0) ? $this->input->post("dtll_aporte_interno") : array();
            $dtll_fuente_verificacion = (is_array($this->input->post("dtll_fuente_verificacion")) && count($this->input->post("dtll_fuente_verificacion")) > 0) ? $this->input->post("dtll_fuente_verificacion") : array();

            $dtll_articulos_json            = (is_array($this->input->post("dtll_articulos")) && count($this->input->post("dtll_articulos")) > 0) ? $this->input->post("dtll_articulos") : array();
            $dtll_articulos                 = json_decode($dtll_articulos_json[0],true);

            $dtll_usuarios_permitidos_json  = (is_array($this->input->post("dtll_usuarios_permitidos")) && count($this->input->post("dtll_usuarios_permitidos")) > 0) ? $this->input->post("dtll_usuarios_permitidos") : array();
            $dtll_usuarios_permitidos       = json_decode($dtll_usuarios_permitidos_json[0],true);
            
            //agregar sucursales
            $pre_sucursal_array             = (is_array($this->input->post("pre_sucursal")) && count($this->input->post("pre_sucursal") > 0)) ? $this->input->post("pre_sucursal") : array();            

            // Array con los datos del presupuesto para su ingreso
            $presupuesto_guardar = array(
                'psp_id_tpp'            => $pre_tipo_presupuesto,
                //'psp_id_suc'            => $pre_sucursal,
                'psp_id_fnc'            => $pre_financiador,
                'psp_id_emp_ejecutor'   => $pre_ejecutor,
                'psp_id_emp_seguimiento'=> $pre_seguimiento,
                'psp_id_are'            => $pre_area,
                'psp_id_cec'            => $pre_centro_costo,
                'psp_id_pcl'            => $pre_proyecto,
                'psp_id_tfn'            => $pre_tipo_financiador,
                'psp_id_usu_genera'     => $this->tank_auth->get_user_id(),
                'psp_id_usu_rechaza'    => null,
                'psp_id_usu_aprueba'    => null,
                'psp_id_mon'            => $pre_moneda,
                'psp_taza_cambio'       => $pre_taza_cambio,
                'psp_codigo'            => $pre_codigo,
                'psp_nombre'            => $pre_nombre,
                'psp_fecha_desde'       => formatear_fecha('Y-m-d', $pre_fecha_desde),
                'psp_fecha_hasta'       => formatear_fecha('Y-m-d', $pre_fecha_hasta),
                'psp_total'             => convertirFloat($pre_presupuesto_total),
                'psp_monto_ejecutado'   => 0.0,
                'psp_pendiente_ejecutar'=> 0.0,
                'psp_estado_prespuesto' => 1,
                'psp_observacion_rechaza'   => null,
                'psp_observacion_aprobado'  => null,
                'psp_estado'            => 1,
                'psp_usu_creacion'      => $this->tank_auth->get_user_id(),
                'psp_fecha_creacion'    => date('Y-m-d H:i:s'),
                'psp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                'psp_fecha_modificacion'=> date('Y-m-d H:i:s')
            );
            
            $pre_id = $this->gsatelite->ingresar('psp_presupuesto', $presupuesto_guardar);
            
            // Procesar los detalles del presupuesto
            $dtll_presupuesto_guardar = array();
            foreach ($dtll_actividad_especifica as $key => $dtll_act_especifica) {
                $dtll_presupuesto_guardar = array(
                    'dps_id_psp'                => $pre_id,
                    'dps_id_ars'                => (is_numeric($dtll_area_servicio[$key]) && $dtll_area_servicio[$key] > 0) ? $dtll_area_servicio[$key] : null,
                    'dps_id_acg'                => (is_numeric($dtll_actividad_general[$key]) && $dtll_actividad_general[$key] > 0) ? $dtll_actividad_general[$key] : null,
                    'dps_id_ace'                => (is_numeric($dtll_actividad_especifica[$key]) && $dtll_actividad_especifica[$key] > 0) ? $dtll_actividad_especifica[$key] : null,
                    'dps_id_fuv'                => (is_numeric($dtll_fuente_verificacion[$key]) && $dtll_fuente_verificacion[$key] > 0) ? $dtll_fuente_verificacion[$key] : null,
                    'dps_id_fnf'                => (is_numeric($dt_fuente_financiamiento[$key]) && $dt_fuente_financiamiento[$key] > 0) ? $dt_fuente_financiamiento[$key] : null,
                    'dps_objetivo'              => (trim($dt_objetivo[$key]) != "") ? $dt_objetivo[$key] : null,
                    'dps_fecha_desde'           => formatear_fecha('Y-m-d', $dtll_fecha_desde[$key]),
                    'dps_fecha_hasta'           => formatear_fecha('Y-m-d', $dtll_fecha_hasta[$key]),
                    'dps_presupuesto_actividad' => convertirFloat($dtll_pre_actividad[$key]),
                    'dps_aporte_externo'        => convertirFloat($dtll_aporte_externo[$key]),
                    'dps_aporte_interno'        => convertirFloat($dtll_aporte_interno[$key]),
                    'dps_presupuesto_ejecutado' => null,
                    'dps_estado'                => 1,
                    'dps_usu_creacion'          => $this->tank_auth->get_user_id(),
                    'dps_fecha_creacion'        => date('Y-m-d H:i:s'),
                    'dps_usu_modificacion'      => $this->tank_auth->get_user_id(),
                    'dps_fecha_modificacion'    => date('Y-m-d H:i:s')
                );

                $dps_id = $this->gsatelite->ingresar('dps_detalle_presupuesto', $dtll_presupuesto_guardar);

                $dtll_usuarios_permitidos = json_decode($dtll_usuarios_permitidos_json[$key],true);
                
                foreach ($dtll_usuarios_permitidos as $detalle) {
                    if ($detalle['valor'] == 1)  {
                        
                        $udp_usuarioxdetalle_presupuesto = array(
                            'udp_id_usu'            => $detalle['codigo'],
                            'udp_id_dps'            => $dps_id,
                            'udp_estado'            => 1,
                            'udp_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'udp_fecha_creacion'    => date('Y-m-d H:i:s'),
                            'udp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'udp_fecha_modificacion'=>  date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('udp_usuarioxdetalle_presupuesto', $udp_usuarioxdetalle_presupuesto);
                    }
                }

                $dtll_articulos = json_decode($dtll_articulos_json[$key],true);
                
                foreach ($dtll_articulos as $detalle) {
                    $atp_articulo_detalle_presupuesto = array(
                        'atp_id_art'            => $detalle['id'],
                        'atp_id_dps'            => $dps_id,
                        'atp_estado'            => $detalle['valor'],
                        'atp_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'atp_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'atp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'atp_fecha_modificacion'=>  date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('atp_articulo_detalle_presupuesto', $atp_articulo_detalle_presupuesto);
                }
            }                    
            
            // procesar sucursales
            if ( count($pre_sucursal_array)  > 0 ) {
                foreach ($pre_sucursal_array as $key => $sucursal) {
                    $sxp_sucursalesxpresupuesto[] = array(
                        'sxp_id_psp'            => $pre_id,
                        'sxp_id_suc'            => $sucursal,
                        'sxp_estado'            => 1,
                        'sxp_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'sxp_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'sxp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'sxp_fecha_modificacion'=> date('Y-m-d H:i:s')
                    );
                }
                $this->gsatelite->ingresar('sxp_sucursalesxpresupuesto', $sxp_sucursalesxpresupuesto, true);
            }

            // Guardar los Anexos
            $rutas      = $this->input->post("ruta");
            $carpeta    = $this->input->post("nombreCarpeta");            
            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $this->input->post("titulo_doc" . $i);
                        $this->anexos_prespuestos($img, $carpeta, $titulo, $pre_id);
                    }
                }
            } // End guardar anexos
            
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de Presupuesto", 'texto_alerta' => "El registro se guardó correctamente.");
            /* ===========================================================================================================
                                        REDIRECCIONES
            =========================================================================================================== */
            $redireccion = $this->input->post('redireccion');
            $this->session->set_flashdata($alerta);

            if ($redireccion == 0) {
                redirect('modulo_presupuesto/pre_procesos/agregar_presupuesto/');
            } else if ($redireccion == 1) {
                redirect('modulo_presupuesto/pre_procesos/presupuesto/');
            }
            die();            
            
        } else {
            // Datos Necesarios para procesar los elementos del formulario
            $id_empresa               = $this->tank_auth->get_empresa_id();
            // Agregar los datos que contendran los selectores en el proceso de presupuesto
            $select                   = $this->gsatelite->get_dropdown('tpp_tipo_presupuesto', '{tpp_codigo} - {tpp_nombre}', '', array('tpp_estado' => '1'), null, '', 'tpp_id', true);
            $data['tipo_presupuesto'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado' => '1'), null, '', 'are_id', true);
            $data['areas']            = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_codigo} - {cec_nombre}', '', array('cec_estado' => '1', 'cec_id_emr' => $id_empresa), null, '', 'cec_id', true);
            $data['centro_costo']     = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} - {suc_nombre}', '', array('suc_id_emr' => $id_empresa), null, '', 'suc_id', true);
            $data['sucursal']         = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), null, '', 'emp_id', true);
            $data['empleados']        = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('fnc_financiador', '{fnc_nombre}', '', array('fnc_estado' => '1'), null, '', 'fnc_id', true);
            $data['financiadores']    = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('ars_area_servicio', '{ars_codigo} - {ars_nombre}', '', array('ars_estado' => '1'), null, '', 'ars_id', true);
            $data['area_servicio']    = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('tfn_tipo_financiador', '{tfn_nombre}', '', array('tfn_estado' => 1), null, '', 'tfn_id', true);
            $data['tipo_financiador'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $where = array(
                'acg_estado'    => 1
            );

            $actividades_generales_array= $this->presupuesto_model->get_actividades_generales($where);
            $actividades_generales      = "";               
            foreach ($actividades_generales_array as $value) {
                $usuarios_permitidos= explode(",",$value['usuarios']); 
                
                if ( in_array( $this->tank_auth->get_user_id(), $usuarios_permitidos ) ) {
                    $actividades_generales .= '<option value="'.$value['acg_id'].'">'.$value['acg_codigo'].' - '.$value['acg_nombre'].')</option>';
                }
            }
            

            $proyectos                = $this->presupuesto_model->get_proyectos( array('pcl_estado' => '1','epr_cierre' => '0') );
            $select                   = "";
                        
            foreach ($proyectos as $proyecto) {
                $valor  = ($proyecto['pcl_monto_solicitado'] == "")?"Monto no asignado":$proyecto['calculo']; 
                $select .= '<option data-presupuesto="'.$proyecto['calculo'].'" value="'.$proyecto['pcl_id'].'">'.$proyecto['pcl_codigo'].' - '.$proyecto['pcl_nombre']. ' ( '.$valor.' )</option>';
            }

            $data['proyectos']        = $select;

            $data['actividad_general']= $actividades_generales;
            
            $select                   = $this->gsatelite->get_dropdown('fnf_fuente_financiamiento', '{fnf_nombre}', '', array('fnf_estado' => 1), null, '', 'fnf_id', true);
            $data['fnt_fuente_finan'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('fuv_fuente_verificacion', '{fuv_codigo} - {fuv_nombre}', '', array('fuv_estado' => 1), null, '', 'fuv_id', true);
            $data['fnt_verificacion'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            $data['moneda']           = $this->gsatelite->get_tabla('mon_moneda', array('mon_estado' => 1) );
            
            // Obtener los dias
            $fecha                    = new DateTime();
            $fecha->modify('first day of this month');
            $data['primer_dia']       = $fecha->format('d/m/Y');
            
            $fecha                    = new DateTime();
            $fecha->modify('last day of this month');
            $data['ultmo_dia']       = $fecha->format('d/m/Y');
            
            // Parametro para obtener la cantidad de decimales
            $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
            
            // Generar codigo automatico
            $codigo                  = $this->gsatelite->get_max('psp_presupuesto', 'psp_id')+1;
            $data['codigo']          = "PRE-" . str_pad($codigo, 5, '0', STR_PAD_LEFT);
            
            $data['titulo_personal'] = "Agregar Prespuesto";
            cargarvista($data);
        }
    }
    
    /**
    * Descripción:
    * Función para la vista index
    * @author Luis Navarro - Grupo Satélite
    * @since 2018-12-13
    * @param $id = ID del presupuesto a editar
    * @return Proceso para editar presupuesto
    */     
    public function editar_presupuesto($id_pre = null, $es_ver = null) {
        satelite_validar();
        $permisos       = $this->gsatelite->get_permisos_opcion('modulo_presupuesto/pre_procesos/presupuesto'); // Obtener los permisos del padre
        $this->gsatelite->verificar_registro_real('psp_presupuesto', $id_pre); // Verificar si es un registro en la tabla
        $reg_pre        = $this->gsatelite->get_tabla('psp_presupuesto', array('psp_id' => $id_pre)); // registro del presupuesto
        $data['reg_pre']= $reg_pre;
        $data['id_pre'] = $id_pre;
         
        // Obtener los datos del POST
        if ($this->input->post()) {
            // Procesar datos ingresados
            $pre_codigo             = (trim($this->input->post("pre_codigo")) != "") ? $this->input->post("pre_codigo") : null;
            $pre_presupuesto_total  = (is_numeric($this->input->post("pre_presupuesto_total")) && $this->input->post("pre_presupuesto_total") > 0) ? $this->input->post("pre_presupuesto_total"): null;
            $pre_tipo_presupuesto   = (is_numeric($this->input->post("pre_tipo_presupuesto")) && $this->input->post("pre_tipo_presupuesto") > 0) ? $this->input->post("pre_tipo_presupuesto") : null;
            $pre_area               = (is_numeric($this->input->post("pre_area")) && $this->input->post("pre_area") > 0) ? $this->input->post("pre_area") : null;
            $pre_nombre             = (trim($this->input->post("pre_nombre")) != "") ? $this->input->post("pre_nombre") : null;
            $pre_centro_costo       = (is_numeric($this->input->post("pre_centro_costo")) && $this->input->post("pre_centro_costo") > 0) ? $this->input->post("pre_centro_costo") : null;
            $pre_fecha_desde        = (trim($this->input->post("pre_fecha_desde")) != "") ? $this->input->post("pre_fecha_desde") : null;
            $pre_proyecto           = (is_numeric($this->input->post("pre_proyecto")) && $this->input->post("pre_proyecto") > 0) ? $this->input->post("pre_proyecto") : null;
            $pre_fecha_hasta        = (trim($this->input->post("pre_fecha_hasta")) != "") ? $this->input->post("pre_fecha_hasta") : null;
            $pre_ejecutor           = (is_numeric($this->input->post("pre_ejecutor")) && $this->input->post("pre_ejecutor") > 0) ? $this->input->post("pre_ejecutor") : null;
            //$pre_sucursal           = (is_numeric($this->input->post("pre_sucursal")) && $this->input->post("pre_sucursal") > 0) ? $this->input->post("pre_sucursal") : null;
            $pre_seguimiento        = (is_numeric($this->input->post("pre_seguimiento")) && $this->input->post("pre_seguimiento") > 0) ? $this->input->post("pre_seguimiento") : null;
            $pre_financiador        = (is_numeric($this->input->post("pre_financiador")) && $this->input->post("pre_financiador") > 0) ? $this->input->post("pre_financiador") : null;
            $permisos               = (is_numeric($this->input->post("permisos")))? $this->input->post("permisos") : 0;
            $pre_moneda             = (is_numeric($this->input->post("slc_moneda")) && $this->input->post("slc_moneda") > 0) ? $this->input->post("slc_moneda") : null;
            $pre_taza_cambio        = (is_numeric($this->input->post("taza_cambio")) && $this->input->post("taza_cambio") > 0) ? $this->input->post("taza_cambio") : null;
            $pre_tipo_financiador   = (is_numeric($this->input->post("slc_tipo_financiador")) && $this->input->post("slc_tipo_financiador") > 0) ? $this->input->post("slc_tipo_financiador") : null;
            // Obtener datos por array 
            $dt_objetivo              = (is_array($this->input->post("dt_objetivo")) && count($this->input->post("dt_objetivo") > 0)) ? $this->input->post("dt_objetivo") : array();
            $dt_fuente_financiamiento = (is_array($this->input->post("dt_fuente_financiamiento")) && count($this->input->post("dt_fuente_financiamiento")) > 0) ? $this->input->post("dt_fuente_financiamiento") : array();
            $dtll_area_servicio       = (is_array($this->input->post("dtll_area_servicio")) && count($this->input->post("dtll_area_servicio")) > 0) ? $this->input->post("dtll_area_servicio") : array();
            $dtll_actividad_general   = (is_array($this->input->post("dtll_actividad_general")) && count($this->input->post("dtll_actividad_general")) > 0) ? $this->input->post("dtll_actividad_general") : array();
            $dtll_actividad_especifica= (is_array($this->input->post("dtll_actividad_especifica")) && count($this->input->post("dtll_actividad_especifica")) > 0) ? $this->input->post("dtll_actividad_especifica") : array();
            $dtll_fecha_desde         = (is_array($this->input->post("dtll_fecha_desde")) && count($this->input->post("dtll_fecha_desde")) > 0) ? $this->input->post("dtll_fecha_desde") : array();
            $dtll_fecha_hasta         = (is_array($this->input->post("dtll_fecha_hasta")) && count($this->input->post("dtll_fecha_hasta")) > 0) ? $this->input->post("dtll_fecha_hasta") : array();
            $dtll_pre_actividad       = (is_array($this->input->post("dtll_pre_actividad")) && count($this->input->post("dtll_pre_actividad")) > 0) ? $this->input->post("dtll_pre_actividad") : array();
            $dtll_aporte_externo      = (is_array($this->input->post("dtll_aporte_externo")) && count($this->input->post("dtll_aporte_externo")) > 0) ? $this->input->post("dtll_aporte_externo") : array();
            $dtll_aporte_interno      = (is_array($this->input->post("dtll_aporte_interno")) && count($this->input->post("dtll_aporte_interno")) > 0) ? $this->input->post("dtll_aporte_interno") : array();
            $dtll_fuente_verificacion = (is_array($this->input->post("dtll_fuente_verificacion")) && count($this->input->post("dtll_fuente_verificacion")) > 0) ? $this->input->post("dtll_fuente_verificacion") : array();
            $detalle_pre              = (is_array($this->input->post("detalle_pre")) && count($this->input->post("detalle_pre")) > 0) ? $this->input->post("detalle_pre") : array();
            $permitir_eliminar        = (is_array($this->input->post("permitir_eliminar")) && count($this->input->post("permitir_eliminar")) > 0) ? $this->input->post("permitir_eliminar") : array();

            $dtll_articulos_json            = (is_array($this->input->post("dtll_articulos")) && count($this->input->post("dtll_articulos")) > 0) ? $this->input->post("dtll_articulos") : array();             
            $dtll_usuarios_permitidos_json  = (is_array($this->input->post("dtll_usuarios_permitidos")) && count($this->input->post("dtll_usuarios_permitidos")) > 0) ? $this->input->post("dtll_usuarios_permitidos") : array();

            //agregar sucursales
            $pre_sucursal_array             = (is_array($this->input->post("pre_sucursal")) && count($this->input->post("pre_sucursal") > 0)) ? $this->input->post("pre_sucursal") : array();            
            
            if ($permisos == 1) {
                // Array con los datos del presupuesto para su ingreso
                $presupuesto_guardar = array(
                    'psp_id_tpp'            => $pre_tipo_presupuesto,
                    //'psp_id_suc'            => $pre_sucursal,
                    'psp_id_fnc'            => $pre_financiador,
                    'psp_id_emp_ejecutor'   => $pre_ejecutor,
                    'psp_id_emp_seguimiento'=> $pre_seguimiento,
                    'psp_id_are'            => $pre_area,
                    'psp_id_cec'            => $pre_centro_costo,
                    'psp_id_pcl'            => $pre_proyecto,
                    'psp_id_tfn'            => $pre_tipo_financiador,
                    //'psp_id_usu_genera'     => $this->tank_auth->get_user_id(),
                    'psp_id_usu_rechaza'    => null,
                    'psp_id_usu_aprueba'    => null,
                    'psp_id_mon'            => $pre_moneda,
                    'psp_taza_cambio'       => $pre_taza_cambio,
                    // 'psp_codigo'            => $pre_codigo,
                    'psp_nombre'            => $pre_nombre,
                    'psp_fecha_desde'       => formatear_fecha('Y-m-d', $pre_fecha_desde),
                    'psp_fecha_hasta'       => formatear_fecha('Y-m-d', $pre_fecha_hasta),
                    'psp_total'             => convertirFloat($pre_presupuesto_total),
                    // 'psp_monto_ejecutado'   => 0.0,
                    // 'psp_pendiente_ejecutar'=> 0.0,
                    'psp_observacion_rechaza'   => null,
                    'psp_observacion_aprobado'  => null,
                    'psp_estado'            => 1,
                    'psp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'psp_fecha_modificacion'=> date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('psp_presupuesto', $presupuesto_guardar, array('psp_id' => $id_pre));
            }
            
            // Procesar para determinar si no tiene dependencia en registro
            $tmp_detalles_pre = $this->gsatelite->get_tabla('dps_detalle_presupuesto', array('dps_id_psp' => $id_pre));
            
            if (count($tmp_detalles_pre) > 0) {
                foreach ($tmp_detalles_pre as $clave => $valor) {
                        //Eliminar todos los permisos del detalle
                        $this->gsatelite->borrado_general('udp_usuarioxdetalle_presupuesto', array('udp_id_dps'=>$valor['dps_id']));
                        //Eliminar todos los articulos del detalle
                        $this->gsatelite->borrado_general('atp_articulo_detalle_presupuesto', array('atp_id_dps'=>$valor['dps_id']));
                        if (!in_array($valor['dps_id'], $detalle_pre)) {
                        // Eliminar detalles asociados al presupuesto
                        $this->gsatelite->borrado_general('dps_detalle_presupuesto', array('dps_id'=>$valor['dps_id']));
                    }
                }
            }
            
            // Procesar los detalles del presupuesto
            $dtll_presupuesto_guardar    = array();
            $dtll_presupuesto_actualizar = array(); 

            if (count($detalle_pre) > 0) {
                foreach ($detalle_pre as $key => $dps_id) {
                    $new_dps = $dps_id;
                    if (intval($dps_id) > 0) {
                        $dtll_presupuesto_actualizar = array(
                            'dps_id_psp'                => $id_pre,
                            'dps_id_ars'                => (is_numeric($dtll_area_servicio[$key]) && $dtll_area_servicio[$key] > 0) ? $dtll_area_servicio[$key] : null,
                            'dps_id_acg'                => (is_numeric($dtll_actividad_general[$key]) && $dtll_actividad_general[$key] > 0) ? $dtll_actividad_general[$key] : null,
                            'dps_id_ace'                => (is_numeric($dtll_actividad_especifica[$key]) && $dtll_actividad_especifica[$key] > 0) ? $dtll_actividad_especifica[$key] : null,
                            'dps_id_fuv'                => (is_numeric($dtll_fuente_verificacion[$key]) && $dtll_fuente_verificacion[$key] > 0) ? $dtll_fuente_verificacion[$key] : null,
                            'dps_id_fnf'                => (is_numeric($dt_fuente_financiamiento[$key]) && $dt_fuente_financiamiento[$key] > 0) ? $dt_fuente_financiamiento[$key] : null,
                            'dps_objetivo'              => (trim($dt_objetivo[$key]) != "") ? $dt_objetivo[$key] : null,
                            'dps_fecha_desde'           => formatear_fecha('Y-m-d', $dtll_fecha_desde[$key]),
                            'dps_fecha_hasta'           => formatear_fecha('Y-m-d', $dtll_fecha_hasta[$key]),
                            'dps_presupuesto_actividad' => convertirFloat($dtll_pre_actividad[$key]),
                            'dps_aporte_externo'        => convertirFloat($dtll_aporte_externo[$key]),
                            'dps_aporte_interno'        => convertirFloat($dtll_aporte_interno[$key]),
                            'dps_presupuesto_ejecutado' => null,
                            'dps_estado'                => 1,
                            'dps_usu_modificacion'      => $this->tank_auth->get_user_id(),
                            'dps_fecha_modificacion'    => date('Y-m-d H:i:s')
                        );
                        
                        $this->gsatelite->actualizar_array('dps_detalle_presupuesto', $dtll_presupuesto_actualizar, array('dps_id' => $dps_id));
                    } else {
                        
                        $dtll_presupuesto_guardar = array(
                            'dps_id_psp'                => $id_pre,
                            'dps_id_ars'                => (is_numeric($dtll_area_servicio[$key]) && $dtll_area_servicio[$key] > 0) ? $dtll_area_servicio[$key] : null,
                            'dps_id_acg'                => (is_numeric($dtll_actividad_general[$key]) && $dtll_actividad_general[$key] > 0) ? $dtll_actividad_general[$key] : null,
                            'dps_id_ace'                => (is_numeric($dtll_actividad_especifica[$key]) && $dtll_actividad_especifica[$key] > 0) ? $dtll_actividad_especifica[$key] : null,
                            'dps_id_fuv'                => (is_numeric($dtll_fuente_verificacion[$key]) && $dtll_fuente_verificacion[$key] > 0) ? $dtll_fuente_verificacion[$key] : null,
                            'dps_id_fnf'                => (is_numeric($dt_fuente_financiamiento[$key]) && $dt_fuente_financiamiento[$key] > 0) ? $dt_fuente_financiamiento[$key] : null,
                            'dps_objetivo'              => (trim($dt_objetivo[$key]) != "") ? $dt_objetivo[$key] : null,
                            'dps_fecha_desde'           => formatear_fecha('Y-m-d', $dtll_fecha_desde[$key]),
                            'dps_fecha_hasta'           => formatear_fecha('Y-m-d', $dtll_fecha_hasta[$key]),
                            'dps_presupuesto_actividad' => convertirFloat($dtll_pre_actividad[$key]),
                            'dps_aporte_externo'        => convertirFloat($dtll_aporte_externo[$key]),
                            'dps_aporte_interno'        => convertirFloat($dtll_aporte_interno[$key]),
                            'dps_presupuesto_ejecutado' => null,
                            'dps_estado'                => 1,
                            'dps_usu_creacion'          => $this->tank_auth->get_user_id(),
                            'dps_fecha_creacion'        => date('Y-m-d H:i:s'),
                            'dps_usu_modificacion'      => $this->tank_auth->get_user_id(),
                            'dps_fecha_modificacion'    => date('Y-m-d H:i:s')
                        );
                        $new_dps = $this->gsatelite->ingresar('dps_detalle_presupuesto', $dtll_presupuesto_guardar);
                    }
                    
                    $dtll_usuarios_permitidos = ($dtll_usuarios_permitidos_json[$key] !="")?json_decode($dtll_usuarios_permitidos_json[$key],true):null;
                    
                    if (count($dtll_usuarios_permitidos) > 0 ) {
                        foreach ($dtll_usuarios_permitidos as $detalle) {
                            if ($detalle['valor'] == 1)  {
                                $udp_usuarioxdetalle_presupuesto = array(
                                    'udp_id_usu'            => $detalle['codigo'],
                                    'udp_id_dps'            => $new_dps,
                                    'udp_estado'            => 1,
                                    'udp_usu_creacion'      => $this->tank_auth->get_user_id(),
                                    'udp_fecha_creacion'    => date('Y-m-d H:i:s'),
                                    'udp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                    'udp_fecha_modificacion'=>  date('Y-m-d H:i:s')
                                );
                                $this->gsatelite->ingresar('udp_usuarioxdetalle_presupuesto', $udp_usuarioxdetalle_presupuesto);
                            }
                        }
                    }

                    $dtll_articulos = ($dtll_articulos_json[$key] !="")?json_decode($dtll_articulos_json[$key],true):null;
                    
                    if (count($dtll_articulos) > 0 ) {
                        foreach ($dtll_articulos as $detalle) {
                            $atp_articulo_detalle_presupuesto = array(
                                'atp_id_art'            => $detalle['id'],
                                'atp_id_dps'            => $dps_id,
                                'atp_estado'            => $detalle['valor'],
                                'atp_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'atp_fecha_creacion'    => date('Y-m-d H:i:s'),
                                'atp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'atp_fecha_modificacion'=>  date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('atp_articulo_detalle_presupuesto', $atp_articulo_detalle_presupuesto);
                        }
                    }
                }
            }

            //Editar anexos

            $Anexo_proyecto  = $this->input->post('Anexo_proyecto');
            $dataAnexos = $this->gsatelite->get_tabla('aps_anexo_presupuesto', array('aps_id_psp' => $id_pre));
            if (!is_array($Anexo_proyecto)) {
                $Anexo_proyecto = array();
            }
            foreach ($dataAnexos as $data) {
                if (!in_array($data['aps_id'], $Anexo_proyecto)) {
                    $this->gsatelite->borrado_general('aps_anexo_presupuesto', array('aps_id' => $data['aps_id']));
                    $ruta_nxp = $data['aps_url'];
                    unlink($ruta_nxp);
                }
            }

            $rutas = $this->input->post("ruta");
            $carpeta = $this->input->post("nombreCarpeta");
            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $this->input->post("titulo_doc" . $i);
                        $this->anexos_prespuestos($img, $carpeta, $titulo, $id_pre);

                    }
                }
            }
        

            // procesar sucursales    
            $tmp_sxp_sucursalesxpresupuesto = $this->gsatelite->get_tabla('sxp_sucursalesxpresupuesto', array('sxp_id_psp' => $id_pre));
            
            if (count($tmp_sxp_sucursalesxpresupuesto) > 0) {
                foreach ($tmp_sxp_sucursalesxpresupuesto as $clave => $valor) {
                    if (!in_array($valor['sxp_id_suc'], $pre_sucursal_array)) {
                        // Eliminar sucursales
                        $this->gsatelite->borrado_general('sxp_sucursalesxpresupuesto', array('sxp_id_suc'=>$valor['sxp_id_suc']));
                    } else {
                        
                    }
                }
            }
        
            $array_sxp_tmp = array_column($tmp_sxp_sucursalesxpresupuesto,'sxp_id_suc');
            
            if ( count($pre_sucursal_array)  > 0 ) {
                foreach ($pre_sucursal_array as $key => $sucursal) {
                    if (!in_array($sucursal, $array_sxp_tmp)) {
                        $sxp_sucursalesxpresupuesto[] = array(
                            'sxp_id_psp'            => $id_pre,
                            'sxp_id_suc'            => $sucursal,
                            'sxp_estado'            => 1,
                            'sxp_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'sxp_fecha_creacion'    => date('Y-m-d H:i:s'),
                            'sxp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'sxp_fecha_modificacion'=> date('Y-m-d H:i:s')
                        );
                    }
                }

                if(count($sxp_sucursalesxpresupuesto) > 0){
                    $this->gsatelite->ingresar('sxp_sucursalesxpresupuesto', $sxp_sucursalesxpresupuesto, true);
                }
            }
            
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de Presupuesto", 'texto_alerta' => "El registro se actualizó correctamente.");
            /* ===========================================================================================================
                                        REDIRECCIONES
            =========================================================================================================== */
            $redireccion = $this->input->post('redireccion');
            $this->session->set_flashdata($alerta);

            if ($redireccion == 0) {
                redirect('modulo_presupuesto/pre_procesos/editar_presupuesto/' . $id_pre);
            } else if ($redireccion == 1) {
                redirect('modulo_presupuesto/pre_procesos/presupuesto/');
            }
            die();            
            
        } else {
            //verifiacer permisos para editar
            $data['permiso']          = false;
            $permisos_parametro       = $this->gsatelite->get_parametro('SYS_EDICION_PRESUPUESTO');
            $permisos_parametro       = ($permisos_parametro != "")?$permisos_parametro:null;
            $permisos_array           = explode(",", $permisos_parametro);  
            $array_roles              = $this->gsatelite->get_tabla("uxr_usuarioxrol",array("uxr_id_usu" => $this->tank_auth->get_user_id()) );

            foreach ($array_roles as $key => $value) {
                if ( in_array($value["uxr_id_rol"],$permisos_array) ) {
                    $data['permiso']     = true;
                }
            }

            // Datos Necesarios para procesar los elementos del formulario
            $id_empresa               = $this->tank_auth->get_empresa_id();
            // Agregar los datos que contendran los selectores en el proceso de presupuesto
            $select                   = $this->gsatelite->get_dropdown('tpp_tipo_presupuesto', '{tpp_codigo} - {tpp_nombre}', '', array('tpp_estado' => '1'), $reg_pre[0]['psp_id_tpp'], '', 'tpp_id', true);
            $data['tipo_presupuesto'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado' => '1'), $reg_pre[0]['psp_id_are'], '', 'are_id', true);
            $data['areas']            = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_codigo} - {cec_nombre}', '', array('cec_estado' => '1', 'cec_id_emr' => $id_empresa), $reg_pre[0]['psp_id_cec'], '', 'cec_id', true);
            $data['centro_costo']     = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array('pcl_estado' => '1'), $reg_pre[0]['psp_id_pcl'], '', 'pcl_id', true);
            $data['proyectos']        = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
                        
            $data['sucursales']       = $this->gsatelite->get_tabla('suc_sucursal', array('suc_id_emr' => $id_empresa) );
            
            $data['sucxpres']         = $this->gsatelite->get_tabla('sxp_sucursalesxpresupuesto', array('sxp_id_psp' => $id_pre) );

            $select                   = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), $reg_pre[0]['psp_id_emp_ejecutor'], '', 'emp_id', true);
            $data['emp_ejecutor']        = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), $reg_pre[0]['psp_id_emp_seguimiento'], '', 'emp_id', true);
            $data['emp_seguimiento']  = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);            
            
            $select                   = $this->gsatelite->get_dropdown('fnc_financiador', '{fnc_nombre}', '', array('fnc_estado' => '1'), $reg_pre[0]['psp_id_fnc'], '', 'fnc_id', true);
            $data['financiadores']    = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            $select                   = $this->gsatelite->get_dropdown('tfn_tipo_financiador', '{tfn_nombre}', '', array('tfn_estado' => 1), $reg_pre[0]['psp_id_tfn'], '', 'tfn_id', true);
            $data['tipo_financiador'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            // ***************************************************************************************************************************************************** \\
            // Datos para los detalles de presupuesto 
            $select                   = $this->gsatelite->get_dropdown('ars_area_servicio', '{ars_codigo} - {ars_nombre}', '', array('ars_estado' => '1'), null, '', 'ars_id', true);
            $data['area_servicio']    = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $where = array(
                'acg_estado'    => 1
            );

            $actividades_generales_array= $this->presupuesto_model->get_actividades_generales($where);
            $actividades_generales      = "";               
            foreach ($actividades_generales_array as $value) {
                $usuarios_permitidos= explode(",",$value['usuarios']); 
                
                if ( in_array( $this->tank_auth->get_user_id(), $usuarios_permitidos ) ) {
                    $actividades_generales .= '<option value="'.$value['acg_id'].'">'.$value['acg_codigo'].' - '.$value['acg_nombre'].')</option>';
                }
            }

            $data['actividad_general']= $actividades_generales;

            $select                      = $this->gsatelite->get_dropdown('ace_actividad_especifica', '{ace_codigo} - {ace_nombre}', '', array('ace_estado' => 1), null, '', 'ace_id', true);
            $data['actividad_especifica']= str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('fnf_fuente_financiamiento', '{fnf_nombre}', '', array('fnf_estado' => 1), null, '', 'fnf_id', true);
            $data['fnt_fuente_finan'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                   = $this->gsatelite->get_dropdown('fuv_fuente_verificacion', '{fuv_codigo} - {fuv_nombre}', '', array('fuv_estado' => 1), null, '', 'fuv_id', true);
            $data['fnt_verificacion'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            $data['moneda']           = $this->gsatelite->get_tabla('mon_moneda', array('mon_estado' => 1) );
            
            // Obtener los dias
            $fecha                      = new DateTime();
            $fecha->modify('first day of this month');
            $data['primer_dia']         = $fecha->format('d/m/Y');
            
            $fecha                      = new DateTime();
            $fecha->modify('last day of this month');
            $data['ultmo_dia']          = $fecha->format('d/m/Y');
            
            // Cargar datos para la grid de detalle
            $data['detalle_pre']        = $this->cargar_detalle_presupuesto($id_pre,$data['permiso']); 
            
            // Parametro para obtener la cantidad de decimales
            $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
            
            // Generar codigo automatico
            $codigo                     = $this->gsatelite->get_max('psp_presupuesto', 'psp_id')+1;
            $data['codigo']             = "PRE-" . str_pad($codigo, 5, '0', STR_PAD_LEFT);
            $data['anexos']             = $this->gsatelite->get_tabla('aps_anexo_presupuesto',array('aps_id_psp' => $id_pre));
            
            $data['titulo_personal']    = "Editar Prespuesto";
            cargarvista($data);
        }
    }

    /**
    * Descripción:
    * Función para cargar el html de la tabla de detalles de presupuesto
    * @author Luis Navarro - Grupo Satélite
    * @since 2018-12-13
    * @param $id = ID del presupuesto a editar
    * @return HTML
    */ 
    public function cargar_detalle_presupuesto($id_pre = null, $permiso = true) {
        satelite_validar();
        if (is_numeric($id_pre) && $id_pre > 0) {
            $registros          = array();
            $articulos_ids      = array();
            $where              = array('dps_id_psp' => $id_pre);
            $registros          = $this->presupuesto_model->obtener_detalle_presupuesto_grid($where);
            $listado_articulos  = array();
            //obtener articulos permitidos
            foreach ($registros as $registro) {
                if ( $registro["articulos"] != null) {
                    $articulos_tmp = (explode(",",$registro["articulos"] ));
                    foreach ($articulos_tmp as $tmp) {
                        if (!in_array($tmp, $articulos_ids)) {
                            array_push($articulos_ids, $tmp);
                        }
                       
                    }
                }
            }

            $listado_articulos = $this->presupuesto_model->get_articulos_like(null,null,$articulos_ids);
            
            // Procesar si debe mostrar la opcion de eliminar en editar presupuesto
            $permitir_eliminar  = array_column($registros, "dps_id");
            $listado_ids        = array_column($listado_articulos, "id");
            // Parametro para obtener la cantidad de decimales
            $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;            
            $data['registros']          = $registros;
            $data['listado_articulos']  = $listado_articulos;
            $data['listado_ids']        = $listado_ids;
            $data['permiso']            = $permiso;
            $html = (count($registros) > 0)?$this->load->view('modulo_presupuesto/pre_procesos/grid_detalle_presupuesto', $data, true):'';
            return array('tabla'=>trim($html),'contador'=>(count($registros)+1));
        }
    }

    /**
    * Descripción:
    * Función para Aprobar presupuesto
    * @author Luis Navarro - Grupo Satélite
    * @since 2018-12-13
    * @param $id = ID del presupuesto para aprobacion
    * @return Ninguno
    */
    public function aprobacion_presupuesto() {
        satelite_validar();
        if ($this->input->post()) {
            // Datos provenientes del metodo POST
            $id             = $this->input->post('id_aprobacion');
            $comentario     = $this->input->post('aprobacion_motivo');
            $nombreCarpeta  = (trim($this->input->post('nombreCarpeta')) != "")?$this->input->post('nombreCarpeta'):null;
            $aprobador_por  = (trim($this->input->post('aprobado')) != "")?$this->input->post('aprobado'):null;
            $titulo_doc     = (trim($this->input->post('titulo_doc')) != "")?$this->input->post('titulo_doc'):null;
            $ruta           = (trim($this->input->post('ruta')) != "")?$this->input->post('ruta'):null;
            $this->gsatelite->verificar_registro_real('psp_presupuesto', $id); // Verificar si es un registro en la tabla

            $destino = "uploads/".$nombreCarpeta."/".$ruta;
            // Array con los datos para actualizar el registro de presupuesto
            $presupuesto_actualizar = array(
                'psp_url_anexo_accion'      => $destino,
                'psp_id_usu_aprueba'        => $this->tank_auth->get_user_id(),
                'psp_estado_prespuesto'     => 2,
                'psp_estado'                => 1,
                'psp_observacion_aprobado'  => $comentario,
                'psp_quien_aprueba'         => $aprobador_por,
                'psp_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'psp_fecha_modificacion'    => date('Y-m-d H:i:s')
            );
            $aprobacion = $this->gsatelite->actualizar_array('psp_presupuesto', $presupuesto_actualizar, array('psp_id' => $id));
            // Mostrar mensaje al usuario si se aprobo o no se aprobo el presupuesto
            if ($aprobacion > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de Presupuesto", 'texto_alerta' => "El registro se aprobó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de Presupuesto", 'texto_alerta' => "El registro no se Aprobó correctamente.");
            }
            $this->session->set_flashdata($alerta);
            redirect('modulo_presupuesto/pre_procesos/presupuesto');

        }
    }
    
    /**
    * Descripción:
    * Función para Rechazar presupuesto
    * @author Luis Navarro - Grupo Satélite
    * @since 2018-12-13
    * @param $id = ID del presupuesto para aprobacion
    * @return Ninguno
    */
    public function rechazar_presupuesto() {
        satelite_validar();
        if ($this->input->post()) {
            // Datos provenientes del metodo POST
            $id         = $this->input->post('id_rechazo');
            $comentario = $this->input->post('rechazo_motivo');
            $nombreCarpeta  = (trim($this->input->post('nombreCarpeta')) != "")?$this->input->post('nombreCarpeta'):null;
            $rechazado_por  = (trim($this->input->post('rechazado')) != "")?$this->input->post('rechazado'):null;
            $titulo_doc     = (trim($this->input->post('titulo_doc')) != "")?$this->input->post('titulo_doc'):null;
            $ruta           = (trim($this->input->post('ruta')) != "")?$this->input->post('ruta'):null;
            $this->gsatelite->verificar_registro_real('psp_presupuesto', $id); // Verificar si es un registro en la tabla
            $destino = "uploads/".$nombreCarpeta."/".$ruta;
            // Array con los datos para actualizar el registro de presupuesto
            $presupuesto_actualizar = array(
                'psp_url_anexo_accion'      => $destino,
                'psp_id_usu_rechaza'        => $this->tank_auth->get_user_id(),
                'psp_estado_prespuesto'     => 3,
                'psp_estado'                => 0,
                'psp_observacion_rechaza'   => $comentario,
                'psp_quien_rechaza'         => $rechazado_por,
                'psp_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'psp_fecha_modificacion'    => date('Y-m-d H:i:s')
            );
            $rechazo = $this->gsatelite->actualizar_array('psp_presupuesto', $presupuesto_actualizar, array('psp_id' => $id));
            // Mostrar mensaje al usuario si se realizo o no el rechazo del presupuesto
            if ($rechazo > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de Presupuesto", 'texto_alerta' => "El registro se rechazó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de Presupuesto", 'texto_alerta' => "El registro no se rechazó correctamente.");
            }
            $this->session->set_flashdata($alerta);
            redirect('modulo_presupuesto/pre_procesos/presupuesto');

        }
    }

    /**
    * Descripción:
    * Función para agregar gastos al presupuesto
    * @author Luis Navarro - Grupo Satélite
    * @since 2018-12-13
    * @param $id = ID del presupuesto para aprobacion
    * @return Vista para agregar los gastos del presupuesto seleccionado
    */    
    public function agregar_gastos() {
        satelite_validar(); // Validacion para verificar si esta logueado el usuario
        $permisos       = $this->gsatelite->get_permisos_opcion(); // Obtener los permisos
        
        if ($this->input->post()) {
            // Obtener los datos del POST
            $tipo_presupuesto       = (is_numeric($this->input->post("id_tipo_presupuesto")) && $this->input->post("id_tipo_presupuesto") > 0) ? $this->input->post("id_tipo_presupuesto") : null;
            $presupuesto            = (is_numeric($this->input->post("presupuesto")) && $this->input->post("presupuesto") > 0) ? $this->input->post("presupuesto") : null;
            $actividad_general      = (is_numeric($this->input->post("actividad_general")) && $this->input->post("actividad_general") > 0) ? $this->input->post("actividad_general") : null;
            $actividad_especifica   = (is_numeric($this->input->post("actividad_especifica")) && $this->input->post("actividad_especifica") > 0) ? $this->input->post("actividad_especifica") : null;
            $texto                  = ( $this->input->post("texo") )? $this->input->post("texo") : "Agregar Gasto";

            // Datos del presupuesto seleccionado
            $reg_presupuesto    = $this->gsatelite->get_tabla('psp_presupuesto', array('psp_id' => $presupuesto));
            $where              = null;

            if ( $presupuesto != null ) {
                $where['dps_id_psp']= $presupuesto;
            }   

            if ( $actividad_general != null ) {
                $where['dps_id_acg'] = $actividad_general;
            }   

            if ( $actividad_especifica != null ) {
                $where['dps_id_ace'] = $actividad_especifica;
            }  
            // Cargar datos para la grid de detalle
            $detalle_pre        = $this->cargar_detalle_gastos($where);           
            echo json_encode($detalle_pre);
            die();
            
        } else {    
            $sobre_giro             = $this->gsatelite->get_parametro('SYS_SOBREGIRO_GASTO_PRESUPUESTO ');
            $data["sobre_giro"]     = ($sobre_giro != "" )?$sobre_giro:0;

            $select                     = $this->gsatelite->get_dropdown('tpp_tipo_presupuesto', '{tpp_codigo} - {tpp_nombre}', '', array('tpp_estado' => '1'), null, '', 'tpp_id', true);
            $data['tipo_presupuesto']   = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                     = $this->gsatelite->get_dropdown('psp_presupuesto', '{psp_codigo} - {psp_nombre}', '', array('psp_estado_prespuesto' => 2, 'psp_estado' => '1'), null, '', 'psp_id', true);
            $data['presupuestos']       = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $where = array(
                'acg_estado'    => 1
            );

            $actividades_generales_array= $this->presupuesto_model->get_actividades_generales($where);
            $actividades_generales      = "";               
            foreach ($actividades_generales_array as $value) {
                $usuarios_permitidos= explode(",",$value['usuarios']); 
                
                if ( in_array( $this->tank_auth->get_user_id(), $usuarios_permitidos ) ) {
                    $actividades_generales .= '<option value="'.$value['acg_id'].'">'.$value['acg_codigo'].' - '.$value['acg_nombre'].')</option>';
                }
            }
            $data['actividad_general'] = $actividades_generales;

           // $select                   = $this->gsatelite->get_dropdown('acg_actividad_general', '{acg_codigo} - {acg_nombre}', '', array('acg_estado' => 1), null, '', 'acg_id', true);
            //$data['actividad_general']= str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                      = $this->gsatelite->get_dropdown('ace_actividad_especifica', '{ace_codigo} - {ace_nombre}', '', array('ace_estado' => 1), null, '', 'ace_id', true);
            $data['actividad_especifica']= str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                     = $this->gsatelite->get_dropdown('tgp_tipo_gasto_presupuesto', '{tgp_nombre}', '', array('tgp_estado' => '1'), null, '', 'tgp_id', true);
            $data['tipo_gasto']         = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            // Parametro para obtener la cantidad de decimales
            $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;            
            $data['retenciones']        = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
            $data['impuestos']          = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1)); 
            $this->db->join("suc_sucursal","suc_id = emp_id_suc"); 
            $sucursal_empleado          = $this->gsatelite->get_tabla("emp_empleado",array("emp_id_usu" => $this->tank_auth->get_user_id()) );       
            $data['sucursal']           = $sucursal_empleado[0]["suc_id"];
            $data['nombre_sucusal']     = $sucursal_empleado[0]["suc_nombre"];
            $data['titulo_personal']    = "Registrar Gastos";
            cargarvista($data);
            
        }
    }

    /**
     * Descripción:
     * Función para obtener los presupuestos por tipo
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-12-14
     * @param Ninguno
     * @return HTML con los datos de los presupuestos segun tipo
     */
    public function obtener_presupuestosxtipo() {
        satelite_validar(); // validar si se esta logueado
        
        if ($this->input->post()) {
            // Obtener los datos POST
            $id_tipo_presupuesto = (is_numeric($this->input->post("id_tipo_presupuesto")) && $this->input->post("id_tipo_presupuesto") > 0) ? $this->input->post("id_tipo_presupuesto") : null;
            
            // Filtrar
            $where      = array('psp_id_tpp' => $id_tipo_presupuesto, 'psp_estado_prespuesto' => 2, 'psp_estado' => 1);
            
            // Obtener los presupuestos segun el tipo
            $select     = $this->gsatelite->get_dropdown('psp_presupuesto', '{psp_codigo} - {psp_nombre}', '', $where, null, '', 'psp_id', true);
            $select     = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'),'<option value=""></option>', $select);
            
            echo json_encode(array('html' => $select));
            die();
        }
    }
    
    /**
     * Descripción:
     * Función para cargar el html de la tabla de detalles de presupuesto para gastos
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-12-14
     * @param $id = ID del presupuesto a editar
     * @return HTML
     */
    public function cargar_detalle_gastos($where = null) {
        satelite_validar();
        $texto                  = ( $this->input->post("texto") )? $this->input->post("texto") : "Agregar Gasto"; 
        $registros              = array(); 
        $aporte_interno         = 0;
        $aporte_externo         = 0;
        $monto_ejecutado        = 0;
        $presupuesto_actividad  = 0;
        $montoxejecutar         = 0;
        $registros              = $this->presupuesto_model->obtener_detalle_presupuesto_grid($where);        
        // Parametro para obtener la cantidad de decimales
        $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
        
        foreach ($registros as $registro) {
            $presupuesto_actividad  += $registro['dps_presupuesto_actividad'];
            $monto_ejecutado        =  $monto_ejecutado + ($registro['dps_presupuesto_actividad'] - $registro['monto_ejecutado']);
            $aporte_externo         += $registro['dps_aporte_externo'];
            $montoxejecutar         += $registro['monto_ejecutado'];
            $aporte_interno         += $registro['dps_aporte_interno'];
        }
        
        $data['registros']          = $registros;
        $data['texto']              = $texto;
        $data['sucursal_empleado']  = $this->gsatelite->get_campo("emp_empleado","emp_id_suc",array("emp_id_usu" => $this->tank_auth->get_user_id()) );
        $html = (count($registros) > 0)?$this->load->view('modulo_presupuesto/pre_procesos/grid_detalle_gastos', $data, true):'';
        $return = array(
            'tabla'                 => trim($html),
            'contador'              => (count($registros)+1),
            'presupuesto_actividad' => $presupuesto_actividad,
            'monto_ejecutado'       => $montoxejecutar,
            'aporte_interno'        => $aporte_interno,
            'aporte_externo'        => $aporte_externo,
            'montoxejecutar'        => $monto_ejecutado
        );
        return $return;
    }
    
    /**
     * Descripción:
     * Función para Guardar los gastos asociados a los detalls del presupuesto
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-12-18
     * @param Ninguno
     * @return true o false
     */
    public function guardar_gasto() {
        satelite_validar();
        if ($this->input->post()) {
            // Obtener los datos provenientes del POST
            $tmp_id_gasto       = (is_numeric($this->input->post("id_gasto")) && $this->input->post("id_gasto") > 0) ? $this->input->post("id_gasto") : null;
            // Validar que sean Array POST
            $tmp_fecha_gasto    = (is_array($this->input->post("tmp_fecha_gasto")) && count($this->input->post("tmp_fecha_gasto") > 0)) ? $this->input->post("tmp_fecha_gasto") : array();
            $tmp_tipo_gasto     = (is_array($this->input->post("tmp_tipo_gasto")) && count($this->input->post("tmp_tipo_gasto") > 0)) ? $this->input->post("tmp_tipo_gasto") : array();
            $tmp_descripcion    = (is_array($this->input->post("tmp_descripcion")) && count($this->input->post("tmp_descripcion") > 0)) ? $this->input->post("tmp_descripcion") : array();
            $tmp_referencia     = (is_array($this->input->post("tmp_referencia")) && count($this->input->post("tmp_referencia") > 0)) ? $this->input->post("tmp_referencia") : array();
            $tmp_monto_gasto    = (is_array($this->input->post("tmp_monto_gasto")) && count($this->input->post("tmp_monto_gasto") > 0)) ? $this->input->post("tmp_monto_gasto") : array();
            $tmp_origen_gasto   = (is_array($this->input->post("tmp_origen_gasto")) && count($this->input->post("tmp_origen_gasto") > 0)) ? $this->input->post("tmp_origen_gasto") : array();  
            $tmp_sub_monto_gasto= (is_array($this->input->post("tmp_sub_monto_gasto")) && count($this->input->post("tmp_sub_monto_gasto") > 0)) ? $this->input->post("tmp_sub_monto_gasto") : array();
            $tmp_impuesto       = (is_array($this->input->post("tmp_impuesto")) && count($this->input->post("tmp_impuesto") > 0)) ? $this->input->post("tmp_impuesto") : array();
            $tmp_retenciones    = (is_array($this->input->post("tmp_retenciones")) && count($this->input->post("tmp_retenciones") > 0)) ? $this->input->post("tmp_retenciones") : array();
            $tmp_cantidad       = (is_array($this->input->post("tmp_cantidad")) && count($this->input->post("tmp_cantidad") > 0)) ? $this->input->post("tmp_cantidad") : array();
            $tmp_sucursal       = (is_array($this->input->post("tmp_sucursal")) && count($this->input->post("tmp_sucursal") > 0)) ? $this->input->post("tmp_sucursal") : array();

            $slc_impuestos          = ($this->input->post("slc_impuestos") != "" ) ? $this->input->post("slc_impuestos") : null;
            $slc_retenciones        = ($this->input->post("slc_retenciones") != "") ? $this->input->post("slc_retenciones") : null;
            $porcentaje_impuestos   = ($this->input->post("porcentaje_impuestos") != "" ) ? $this->input->post("porcentaje_impuestos") : "";
            $porcentaje_retenciones = ($this->input->post("porcentaje_retenciones") != "") ? $this->input->post("porcentaje_retenciones") : "";
            
            // Eliminar detalles asociados al presupuesto
            $detalles_antiguos = $this->gsatelite->get_tabla("dgp_detalle_gasto_prespuesto",array('dgp_id_dps'=>$tmp_id_gasto));
           
            foreach ($detalles_antiguos as $detalle) {
                $this->gsatelite->borrado_general('rgp_retencion_gasto_presupuesto', array('rgp_id_dgp'=>$detalle["dgp_id"]));
                $this->gsatelite->borrado_general('idp_impuesto_detalle_presupuesto', array('idp_id_dgp'=>$detalle["dgp_id"]));
            }
         
            $this->gsatelite->borrado_general('dgp_detalle_gasto_prespuesto', array('dgp_id_dps'=>$tmp_id_gasto));
            // Procesar los detalles del presupuesto         
            $dtll_gasto_guardar = array();
            foreach ($tmp_fecha_gasto as $key => $tmp_fecha) {
                $dtll_gasto_guardar = array(
                    'dgp_id_dps'                => $tmp_id_gasto,
                    'dgp_id_tgp'                => (is_numeric($tmp_tipo_gasto[$key]) && $tmp_tipo_gasto[$key] > 0) ? $tmp_tipo_gasto[$key] : null,
                    'dgp_fecha'                 => (trim($tmp_fecha) != "") ? formatear_fecha('Y-m-d', $tmp_fecha) : null,
                    'dgp_descripcion'           => (trim($tmp_descripcion[$key]) != "") ? $tmp_descripcion[$key] : null,
                    'dgp_referencia'            => (trim($tmp_referencia[$key]) != "") ? $tmp_referencia[$key] : null,
                    'dgp_cantidad'              => convertirFloat($tmp_cantidad[$key]),
                    'dgp_sub_monto'             => convertirFloat($tmp_sub_monto_gasto[$key]),
                    'dgp_total_retencion'       => convertirFloat($tmp_retenciones[$key]),
                    'dgp_total_impuesto'        => convertirFloat($tmp_impuesto[$key]),
                    'dgp_monto'                 => convertirFloat($tmp_monto_gasto[$key]),
                    'dgp_id_suc'                => convertirFloat($tmp_sucursal[$key]),
                    'dgp_origen'                => 1,
                    'dgp_referencia_origen'     => (trim($tmp_origen_gasto[$key]) != "") ? $tmp_origen_gasto[$key] : null,
                    'dgp_estado'                => 1,
                    'dgp_usu_creacion'          => $this->tank_auth->get_user_id(),
                    'dgp_fecha_creacion'        => date('Y-m-d H:i:s'),
                    'dgp_usu_modificacion'      => $this->tank_auth->get_user_id(),
                    'dgp_fecha_modificacion'    => date('Y-m-d H:i:s')
                ); 
                $dgp_id = $this->gsatelite->ingresar('dgp_detalle_gasto_prespuesto', $dtll_gasto_guardar);
              
                $impuestos_array                    = explode(',',$slc_impuestos[$key]);
                $imp_porcentaje_array               = explode(',',$porcentaje_impuestos[$key]);
                $idp_impuesto_detalle_presupuesto   = [];
                
                foreach ($impuestos_array as $imp => $impuesto) {
                    if ($impuesto != "") {
                        $idp_impuesto_detalle_presupuesto[] = array(
                            'idp_id_imp'            => $impuesto,
                            'idp_id_dgp'            => $dgp_id,
                            'idp_monto'             => convertirFloat($tmp_sub_monto_gasto[$key]),
                            'idp_porcentaje '       => convertirFloat($imp_porcentaje_array[$imp]),
                            'idp_estado'            => 1,
                            'idp_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'idp_fecha_creacion'    => date('Y-m-d H:i:s'),
                            'idp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'idp_fecha_modificacion'=> date('Y-m-d H:i:s') 
                        );
                    }
                }
               

                if ( count($idp_impuesto_detalle_presupuesto) > 0) {
                    $this->gsatelite->ingresar('idp_impuesto_detalle_presupuesto', $idp_impuesto_detalle_presupuesto, true);
                }

                $retenciones_array              = explode(',',$slc_retenciones[$key]);
                $ret_porcentaje_array           = explode(',',$porcentaje_retenciones[$key]);
                $rgp_retencion_gasto_presupuesto= [];
                foreach ($retenciones_array as $ret => $retencion) {
                    if ( $retencion != "" ) {
                        $rgp_retencion_gasto_presupuesto[] = array(
                            'rgp_id_ret'            => $retencion,
                            'rgp_id_dgp'            => $dgp_id,
                            'rgp_monto'             => convertirFloat($tmp_sub_monto_gasto[$key]),
                            'rgp_porcentaje '       => convertirFloat($ret_porcentaje_array[$ret]),
                            'rgp_estado'            => 1,
                            'rgp_usu_creacion'      => date('Y-m-d H:i:s'),
                            'rgp_fecha_creacion'    => $this->tank_auth->get_user_id(),
                            'rgp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'rgp_fecha_modificacion'=> date('Y-m-d H:i:s') 
                        );
                    }
                }
                
                if ( count($rgp_retencion_gasto_presupuesto) > 0) {
                    $this->gsatelite->ingresar('rgp_retencion_gasto_presupuesto', $rgp_retencion_gasto_presupuesto, true);
                }
                
            }
            
            //$alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de Gasto", 'texto_alerta' => "El registro se guardó correctamente.");
        
            //$this->session->set_flashdata($alerta);
            die(); 
        }
    }

    /**
     * Descripción:
     * Función para obtener los detalles del Gasto asociado al presupuesto
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-12-18
     * @param Ninguno
     * @return HTML de los detalles del gasto
     */
    public function obtener_detalles_gastos($id_gasto = null) {
        satelite_validar();
        $id_gasto = (is_numeric($this->input->post("id_gasto")) && $this->input->post("id_gasto") > 0) ? $this->input->post("id_gasto") : $id_gasto;
        if (is_numeric($id_gasto) && $id_gasto > 0) {
            $registros = array();
            
            $where = array('dgp_id_dps' => $id_gasto, 'dgp_estado' =>1);
            $registros = $this->presupuesto_model->obtener_detalle_gastos_presupuesto($where);

            // Parametro para obtener la cantidad de decimales
            $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
            
            $data['registros'] = $registros;
            $html = (count($registros) > 0)?$this->load->view('modulo_presupuesto/pre_procesos/consultar_detalle_gastos_presupuesto', $data, true):'';
            echo json_encode(array('tabla'=>trim($html),'contador'=>(count($registros)+1)));
        }
    }

    /**
         * Descripción:
         * Función para obtener las actividades generales
         * @author Francisco Orozco - Grupo Satélite
         * @since 2019-02-18
         * @param Ninguno
         * @return HTML de las actividades generales
     */
    function get_actividad_general_x_presupuesto() {
        satelite_validar();
        $presupuesto    = $this->input->post('presupuesto');

        $where = array(
            'acg_estado'    => 1,
            'dps_id_psp'    => $presupuesto
        );

        $this->db->group_by("acg_id");
        $this->db->join("dps_detalle_presupuesto","dps_id_acg = acg_id");
        $actividades_generales_array= $this->presupuesto_model->get_actividades_generales($where);
        $actividades_generales      = '<option value=""></option>';               
        foreach ($actividades_generales_array as $value) {
            $usuarios_permitidos= explode(",",$value['usuarios']); 
            
            if ( in_array( $this->tank_auth->get_user_id(), $usuarios_permitidos ) ) {
                $actividades_generales .= '<option value="'.$value['acg_id'].'">'.$value['acg_codigo'].' - '.$value['acg_nombre'].'</option>';
            }
        }

        $html = $actividades_generales;

        echo trim($html);   
    }

    /**
         * Descripción:
         * Función para obtener las actividades especificas.
         * @author Francisco Orozco - Grupo Satélite
         * @since 2019-02-18
         * @param Ninguno
         * @return HTML de las actividades especificas
    */
    function get_actividades_especificas_x_actividad_general() {
        satelite_validar();
        $general                = $this->input->post('general');
        $presupuesto            = ($this->input->post('presupuesto'))?$this->input->post('presupuesto'):null;        
        $where['ace_estado']    = 1;
        $where['ace_id_acg']    = $general;
        if ($presupuesto != null) {
            $where['dps_id_psp'] = $presupuesto;
        }
        $select                 = "*, SUM(dps_presupuesto_actividad - (IFNULL(dps_presupuesto_ejecutado,0)) ) as total";
        $group_by               = "ace_id";
        $actividades_generales  = $this->compras_model->get_actividades_x_presupusto($select, $where, $group_by);
        $html                   = '<option value=""></option>';

        foreach ($actividades_generales as $value) {
            $html .= '<option data-presupuesto="'.$value['dps_id'].'" data-valor="'.number_format($value['total'],2,".",",").'" value="'.$value['ace_id'].'">'.$value['ace_codigo']." - ".$value['ace_nombre'].'</option>';
        }

        echo trim($html);
    }

    /**
         * Descripción:
         * Función para subir arhivos de presupuesto
         * @author Francisco Orozco - Grupo Satélite
         * @since 2019-04-10
         * @param img
         * @param carpeta
         * @param titulo_doc
         * @param id
    */
    public function anexos_prespuestos($img, $carpeta, $titulo_doc, $id) {
        $extencion  = end(explode(".", $img));
        $datos_1    = $this->session->keep_flashdata('datos_1');
        $nombre     = trim($img);
        $ruta       = "public/temp/" . $carpeta . "/" . $nombre;
        $destino    = "uploads/anexos_presupuesto/" . $titulo_doc . "." . trim($extencion) . "";
        $dir        = $this->gsatelite->get_campo('aps_anexo_presupuesto', 'aps_url', array('aps_url' => $destino, 'aps_estado' => 1));

        if (count($dir) <= 0) {
            $aps_anexo_presupuesto = array(
                'aps_id_psp'                => $id,
                'aps_nombre'                => $titulo_doc,
                'aps_url'                   => $destino,
                'aps_estado'                => 1,
                'aps_fecha_modificacion'    => date('Y-m-d H:i:s'),
                'aps_fecha_creacion'        => date('Y-m-d H:i:s'),
                'aps_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'aps_usu_creacion'          => $this->tank_auth->get_user_id()
            );
            $this->db->insert("aps_anexo_presupuesto", $aps_anexo_presupuesto);
            copy($ruta, $destino);
            unlink($ruta);
        }
    }

    /**
         * Descripción:
         * proceso de plan de compras o gastos.
         * @author Francisco Orozco - Grupo Satélite
         * @since 2019-04-12     
    */
    public function plan_compras(){
        satelite_validar();
        $data['cantidad_decimales']      = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
        if ($this->input->post()) {
            $actividad              = (is_numeric($this->input->post("actividad")) && $this->input->post("actividad") > 0) ? $this->input->post("actividad") : 0;
            $where["dps_id"]        = $actividad;
            $detalle_presupuesto    = $this->presupuesto_model->get_planes_compras($where);
            
            if ( count($detalle_presupuesto) > 0 ) {
                $data["detalles"]       = $detalle_presupuesto;
                $data['decimales']      = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
                $data['columna_periodo']= array_column($detalle_presupuesto, "pcp_periodo"); 
                $return = array(
                    'encontrado'    => 1,
                    'html'          => $this->load->view('modulo_presupuesto/pre_procesos/detalles_planes', $data, true),                   
                    'rubro'         => $detalle_presupuesto[0]['ace_nombre'],
                    'presupuesto'   => $detalle_presupuesto[0]['dps_presupuesto_actividad'],
                    'desde'         => formatear_fecha('d-m-Y', $detalle_presupuesto[0]['dps_fecha_desde'] ),
                    'hasta'         => formatear_fecha('d-m-Y', $detalle_presupuesto[0]['dps_fecha_hasta'] ),
                    'actividad'     => $actividad
                );
            } else {
                $return = array(
                    'encontrado'    => 0,
                );
            }
           
            echo json_encode($return);
            die();
        } else {
            $select                     = $this->gsatelite->get_dropdown('tpp_tipo_presupuesto', '{tpp_codigo} - {tpp_nombre}', '', array('tpp_estado' => '1'), null, '', 'tpp_id', true);
            $data['tipo_presupuesto']   = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $select                     = $this->gsatelite->get_dropdown('psp_presupuesto', '{psp_codigo} - {psp_nombre}', '', array('psp_estado_prespuesto' => 2, 'psp_estado' => '1'), null, '', 'psp_id', true);
            $data['presupuestos']       = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            $data['titulo_personal']    = "Plan de Compras";
            cargarvista($data);
        }
    }
    
    /**
         * Descripción:
         * Guardar plan de compras o gastos.
         * @author Francisco Orozco - Grupo Satélite
         * @since 2019-04-22     
    */
    public function guardar_plan_compras() {
        $dps_id         = $this->input->post("gasto");
        $pcp_periodo    = $this->input->post("periodo");
        $pcp_monto      = $this->input->post("monto");
        $pcp_comentario = $this->input->post("descripcion");

        $this->gsatelite->borrado_general('pcp_plan_compra_presupuesto', array('pcp_id_dps'=>$dps_id) );

        $pcp_plan_compra_presupuesto= [];
        foreach ($pcp_periodo as $fila => $periodo) {
            if ( $periodo != "" ) {
                $pcp_plan_compra_presupuesto[] = array(
                    'pcp_id_dps'            => $dps_id,
                    'pcp_periodo'           => $pcp_periodo[$fila],
                    'pcp_fecha'             => formatear_fecha('Y-m-d', $pcp_periodo[$fila]."01"),
                    'pcp_monto'             => convertirFloat($pcp_monto[$fila]),
                    'pcp_comentario'        => $pcp_comentario[$fila],
                    'pcp_estado'            => 1,
                    'pcp_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'pcp_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'pcp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'pcp_fecha_modificacion'=> date('Y-m-d H:i:s') 
                );
            }
        }

        if ( count($pcp_plan_compra_presupuesto) > 0) {
            $this->gsatelite->ingresar('pcp_plan_compra_presupuesto', $pcp_plan_compra_presupuesto, true);
            $return = array(
                'realizado'    => 1,
            );
        } else {
            $return = array(
                'realizado'    => 0,
            );
        }

        echo json_encode($return);
        die();
    }

    /**
         * Descripción:
         * Se obtienen los usuarios permitidos de las actividades generales
         * @author Francisco Orozco - Grupo Satélite
         * @since 2019-05-15     
         * @return JSON
    */
    public function get_usuarios_permitidos_generales() {
        satelite_validar();
        $actividad_general  = $this->input->post("actividad_general");

        $this->db->join("users","id = uxa_id_usu");    
        $usuarios   = $this->gsatelite->get_tabla("uxa_usuarioxactividad_general",array("uxa_id_acg" => $actividad_general));       
        $resultado     = array();
        $array_permisos = array();

        foreach ($usuarios as $usuario) {
            $array_permisos = array(
                "codigo"   => $usuario["id"],
                "nombre"   => clean_string($usuario["username"]),
                "valor"    => "1"
            ); 
            array_push($resultado,$array_permisos);
        }
        echo json_encode($resultado);
        die();
    }

    /**
        * @author Francsico Orozco
        * @since 2019-06-10
        * @return JSON productos/ servicios
        * @param $like string para condicionar.
    */
    public function get_articulos_like(){
        if ($_POST) {
            $like               = $this->input->post('articulo_servicio');
            $where['art_estado']= 1;
            $where['art_compra']= 1;            
            $result             = $this->presupuesto_model->get_articulos_like($where,$like);
            echo json_encode($result);
        }
    }

    
    /**
        * Descripción:
        * proceso de traslados de fondos
        * @author Francisco Orozco - Grupo Satélite
        * @since 2019-08-12     
    */
    public function traslados_fondos() {
        satelite_validar();
        if ($this->input->post()) { 
            $proyecto           = $this->input->post("slcProyecto");
            $presupuesto        = $this->input->post("slc_presupuesto");

            $where["dps1.dps_id_psp"]= $presupuesto;

            $detalles           = $this->presupuesto_model->get_traslados($where);            
            $data["detalles"]   = $detalles;
            $html               = $this->load->view('modulo_presupuesto/pre_procesos/detalle_traslados', $data, true);
            echo json_encode(array('html'=>$html));
        } else{
            $this->db->join("epr_estado_proyecto","epr_id = pcl_id_epr","inner");
            $select                   = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array('pcl_estado' => '1', 'epr_cierre' => 0), null, '', 'pcl_id', true);
            $data['proyectos']        = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);            
            $data['titulo_personal'] = "Traslado de fondos";
            cargarvista($data);
        }

    }

    /**
        * Descripción:
        * proceso de traslados de fondos
        * @author Francisco Orozco - Grupo Satélite
        * @since 2019-08-12     
    */
    public function realizar_traslados($presupuesto = null) {
        satelite_validar();
     
        if ( $this->input->post() ) { 
            $presupuesto        = $this->input->post("txt_presupuesto");
            $tmp_id_dps_origen  = $this->input->post("txt_detalle_origen");
            $tmp_id_dps_destino = $this->input->post("txt_detalle_destino");
            $tmp_monto_origen   = $this->input->post("txt_monto_presupuesto_origen");
            $tmp_monto_destino  = $this->input->post("txt_monto_presupuesto");
            $tmp_monto          = $this->input->post("txt_total_movimiento_2");   
            $tmp_saldo_origen   = $this->input->post("total_disponble_1");                
            $tmp_saldo_destino  = $this->input->post("total_disponble_2");               

            $tmp_traslado_monto_plan = array(
                'tmp_id_usu'            => $this->tank_auth->get_user_id(),
                'tmp_id_dps_origen'     => $tmp_id_dps_origen,
                'tmp_id_dps_destino'    => $tmp_id_dps_destino,
                'tmp_fecha'             => date('Y-m-d H:i:s'),
                'tmp_monto'             => $tmp_monto,
                'tmp_monto_origen'      => $tmp_monto_origen,
                'tmp_descripcion'       => "",
                'tmp_monto_destino'     => $tmp_monto_destino,
                'tmp_saldo_destino'     => $tmp_saldo_destino,
                'tmp_saldo_origen'      => $tmp_saldo_origen,
                'tmp_estado'            => 1,
                'tmp_usu_creacion'      => $this->tank_auth->get_user_id(),
                'tmp_fecha_creacion'    => date('Y-m-d H:i:s'),
                'tmp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                'tmp_fecha_modificacion'=> date('Y-m-d H:i:s')
            );
            
            
            $tmp_id = $this->gsatelite->ingresar("tmp_traslado_monto_plan", $tmp_traslado_monto_plan);

            //variables de plan origen
            $origenes           = $this->input->post("txt_monto_movimiento_1");
            $ptr_id_pcp         = $this->input->post("plan_1");
            $ptr_monto          = $this->input->post("txt_monto_movimiento_1");
            $ptr_monto_origen   = $this->input->post("txt_monto_mensual_1");
            $ptr_saldo_origen   = $this->input->post("txt_monto_disponible_1");            
            
            foreach ($origenes as $key => $origen) {
                $ptr_plan_traslado_origen = array(
                    'ptr_id_tmp'            => $tmp_id,
                    'ptr_id_pcp'            => $ptr_id_pcp[$key],
                    'ptr_monto'             => ($ptr_monto[$key] != "")?$ptr_monto[$key]:0,
                    'ptr_monto_origen'      => $ptr_monto_origen[$key],
                    'ptr_saldo_origen'      => $ptr_saldo_origen[$key],
                    'ptr_estado'            => 1,
                    'ptr_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'ptr_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'ptr_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'ptr_fecha_modificacion'=> date('Y-m-d H:i:s')
                );              
                
                $this->gsatelite->ingresar("ptr_plan_traslado_origen", $ptr_plan_traslado_origen);  

                 //actualizar detalle de presupuesto
                 if ( $ptr_monto[$key] != "" && $ptr_monto[$key] > 0) {
                    $pcp_plan_compra_presupuesto = array(
                        'pcp_monto'             => $ptr_monto_origen[$key]-$ptr_monto[$key],
                        'pcp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'pcp_fecha_modificacion'=> date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('pcp_plan_compra_presupuesto', $pcp_plan_compra_presupuesto, array('pcp_id' => $ptr_id_pcp[$key]) );
                }

            }        

            //actualizar detalle de presupuesto origen
            $origen_restar           = $this->input->post("txt_total_movimiento_1");             
            $dps_detalle_presupuesto = array(
                'dps_presupuesto_actividad' => $tmp_monto_origen-$origen_restar,
                'dps_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'dps_fecha_modificacion'    => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('dps_detalle_presupuesto', $dps_detalle_presupuesto, array('dps_id' => $tmp_id_dps_origen) );
            
            //variables de plan destino
            $destinos           = $this->input->post("txt_monto_movimiento_2");
            $ptd_id_pcp         = $this->input->post("plan_2");
            $ptd_monto          = $this->input->post("txt_monto_movimiento_2");
            $ptd_monto_origen   = $this->input->post("txt_monto_mensual_2");
            $ptd_saldo_origen   = $this->input->post("txt_monto_disponible_2"); 
            
            foreach ($destinos as $key2 => $destino) {
                $ptd_plan_traslado_destino = array(
                    'ptd_id_tmp'            => $tmp_id,
                    'ptd_id_pcp'            => $ptd_id_pcp[$key2],
                    'ptd_monto'             => ($ptd_monto[$key2] != "")?$ptd_monto[$key2]:0,
                    'ptd_monto_origen'      => $ptd_monto_origen[$key2],
                    'ptd_saldo_origen'      => $ptd_saldo_origen[$key2],
                    'ptd_estado'            => 1,
                    'ptd_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'ptd_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'ptd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'ptd_fecha_modificacion'=> date('Y-m-d H:i:s')
                );   
                $this->gsatelite->ingresar("ptd_plan_traslado_destino", $ptd_plan_traslado_destino);               

                //actualizar detalle de presupuesto
                if ( $ptd_monto[$key2] != "" && $ptd_monto[$key2] > 0) {
                    $pcp_plan_compra_presupuesto = array(
                        'pcp_monto'             => $ptd_monto_origen[$key]+$ptd_monto[$key2],
                        'pcp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'pcp_fecha_modificacion'=> date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('pcp_plan_compra_presupuesto', $pcp_plan_compra_presupuesto, array('pcp_id' => $ptd_id_pcp[$key2]) );
                }
            }

            //actualizar detalle de presupuesto destino
            $destino_sumar           = $this->input->post("txt_total_movimiento_2");             
            $dps_detalle_presupuesto = array(
                'dps_presupuesto_actividad' => $tmp_monto_destino+$destino_sumar,
                'dps_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'dps_fecha_modificacion'    => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('dps_detalle_presupuesto', $dps_detalle_presupuesto, array('dps_id' => $tmp_id_dps_destino) );
            

            // Agregar los Anexos por cliente
            $rutas = $this->input->post("ruta");
            $carpeta = $this->input->post("nombreCarpeta");
            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $this->input->post("titulo_doc" . $i);
                        $this->datos_imagen_gral($img, $tmp_id, $carpeta, $titulo);

                    }
                }
            }       
            
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Traslados", 'texto_alerta' => "Los registros se ingresaron con éxito.");
            $this->session->set_flashdata($alerta);
            redirect('modulo_presupuesto/pre_procesos/traslados_fondos/'.$$presupuesto );
        } else if ($presupuesto > 0) {
            $where["dps_id_psp"]    = $presupuesto;
            $acvidades_generales    = $this->presupuesto_model->get_actividades_generalesxpresupuesto( $where );
            $select                 = '<option></option>';
            foreach ($acvidades_generales as $key => $actividad) {
                $select .= '<option value="'.$actividad["acg_id"].'">'.$actividad["acg_codigo"].' - '.$actividad["acg_nombre"].'</option>';
            }
            $this->db->join("pcl_proyecto_cliente","pcl_id = psp_id_pcl");
            $data['presupuesto']    = $this->gsatelite->get_tabla("psp_presupuesto", array("psp_id" => $presupuesto) );
            $data['generales']      = $select;
            $data['titulo_personal']= "Realizar Traslado de fondos";
            cargarvista($data);
        } else{
            redirect('inicio/index/');
        }
    }

    function get_plan_compras(){
        satelite_validar();
        $data['cantidad_decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
        if ($this->input->post()) { 
            $actividad              = (is_numeric($this->input->post("actividad")) && $this->input->post("actividad") > 0) ? $this->input->post("actividad") : 1;
            $tipo                   = (is_numeric($this->input->post("tipo")) && $this->input->post("tipo") > 0) ? $this->input->post("tipo") : 1;
            $where["dps_id"]        = $actividad;
            $detalle_presupuesto    = $this->presupuesto_model->get_planes_compras($where);
            
            if ( count($detalle_presupuesto) > 0 ) {
                $data["detalles"]       = $detalle_presupuesto;
                $data['decimales']      = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
                $data['columna_periodo']= array_column($detalle_presupuesto, "pcp_periodo"); 
                $data['tipo']           = $tipo;
                $return = array(
                    'encontrado'    => 1,
                    'html'          => $this->load->view('modulo_presupuesto/pre_procesos/traslado_plan_compras', $data, true),                   
                    'rubro'         => $detalle_presupuesto[0]['ace_nombre'],
                    'presupuesto'   => $detalle_presupuesto[0]['dps_presupuesto_actividad'],
                    'desde'         => formatear_fecha('d-m-Y', $detalle_presupuesto[0]['dps_fecha_desde'] ),
                    'hasta'         => formatear_fecha('d-m-Y', $detalle_presupuesto[0]['dps_fecha_hasta'] ),
                    'plan'          => $detalle_presupuesto[0]['pcp_id'],
                    'actividad'     => $actividad
                );
            } else {
                $return = array(
                    'encontrado'    => 0,
                );
            }
           
            echo json_encode($return);
            die();
        }
    }   

      // funcion para agregar anexos al presupuestos
      public function datos_imagen_gral($img, $proyecto, $carpeta, $titulo_doc, $tipo = 0) {
        $extencion = end(explode(".", $img));
        $datos_1 = $this->session->keep_flashdata('datos_1');
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        $destino = "uploads/anexos_traslados_presupuestos/" . $titulo_doc . "." . trim($extencion) . "";
        $dir = $this->gsatelite->get_campo('ats_anexo_traslado_plan', 'ats_url', array('ats_url' => $destino, 'ats_estado' => 1));
        // Si ya existe, no se ingresa.

        if (count($dir) <= 0) {
            $array_anex = array(
                'ats_id_tmp'            => $proyecto,
                'ats_url'               => $destino,
                'ats_nombre'            => $nombre,
                'ats_estado'            => 1,
                'ats_usu_creacion'      => $this->tank_auth->get_user_id(),
                'ats_fecha_creacion'    => date('Y-m-d H:i:s'),
                'ats_usu_modificacion'  => $this->tank_auth->get_user_id(),
                'ats_fecha_modificacion'=> date('Y-m-d H:i:s')
            );

            $this->db->insert("ats_anexo_traslado_plan", $array_anex);
            $id_anexo = $this->db->insert_id();
            $carpeta_destino = "uploads/anexos_traslados_presupuestos/" . $titulo_doc . "." . trim($extencion) . "";

            copy($ruta, $carpeta_destino);
            unlink($ruta);
        }
    }

    /**
    * Descripción:
    * proceso de ver traslados de fondos
    * @author Francisco Orozco - Grupo Satélite
    * @since 2019-08-12     
    */
    public function ver_traslados($traslado = null) { 
        if ($traslado > 0) {
            $where['tmp_id']        = $traslado;
            $data['traslado']       = $this->presupuesto_model->get_traslados($where);         
            $data['origen']         = $this->presupuesto_model->get_traslados_origen( array( "ptr_id_tmp" => $traslado) ); 
            $data['destino']        = $this->presupuesto_model->get_traslados_destino( array( "ptd_id_tmp" => $traslado) ); 
            $data['anexos']         = $this->gsatelite->get_tabla('ats_anexo_traslado_plan',array('ats_id_tmp' => $traslado));
            $data['titulo_personal']= "Traslado de fondos";
            cargarvista($data);
        } else{
            redirect('inicio/index/');
        }
    }

    /**
         * Descripción:
         * Función para obtener las actividades especificas.
         * @author Francisco Orozco - Grupo Satélite
         * @since 2019-02-18
         * @param Ninguno
         * @return HTML de las actividades especificas
    */
    function get_rubros() {
        satelite_validar();
        $general                = $this->input->post('general');
   
        $where['ace_estado']    = 1;
        $where['ace_id_acg']    = $general;
       
        $actividades_generales  = $this->compras_model->get_rubros($where);
        $html                   = '<option value=""></option>';

        foreach ($actividades_generales as $value) {
            $html .= '<option value="'.$value['ace_id'].'">'.$value['ace_codigo']." - ".$value['ace_nombre'].'</option>';
        }

        echo trim($html);

    }

}
?>
