<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Pre_mantenimientos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('consultas');
        $this->load->model('presupuesto_model');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    /**
     * Descripción:
     * Mantenimieto de áreas - Funcionalidad compartida de Estructura Organizativa>index(área)
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-03-24
     */
    function areas($per_inv=null) {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->index('modulo_presupuesto/pre_mantenimientos');
    }

    /**
     * Descripción:
     * Mantenimieto de niveles_areas - Funcionalidad compartida de Estructura Organizativa
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-03-24
     */
    function niveles_areas($per_inv=null) {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/mantenimientos');
        $this->mantenimientos->niveles_areas('modulo_presupuesto/pre_mantenimientos');
    }


    /**
     * @author Edith Herrera
     * @since  2018-03-24
     * @return Grid del mantenimiento de áreas de servicio.
    * */
    function area_servicio() {
        satelite_validar();

       $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

       $add_fields= array(
            'ars_codigo',
            'ars_nombre',
            'ars_descripcion',
            'ars_estado',
            'ars_usu_creacion',
            'ars_fecha_creacion',
            'ars_usu_modificacion',
            'ars_fecha_modificacion'
        );

       $edit_fields= array(
            'ars_codigo',
            'ars_nombre',
            'ars_descripcion',
            'ars_estado',
            'ars_usu_modificacion',
            'ars_fecha_modificacion'
        );

       $req_fields= array(
            'ars_codigo',
            'ars_nombre',
            'ars_estado',
            'ars_usu_modificacion',
            'ars_fecha_modificacion'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('ars_area_servicio')
                ->set_subject('Área general de gastos')
                ->columns('ars_codigo', 'ars_nombre', 'ars_descripcion', 'ars_estado')
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($req_fields)
                ->display_as('ars_codigo', 'Código')
                ->display_as('ars_nombre', 'Nombre')
                ->display_as('ars_descripcion', 'Descripción')
                ->display_as('ars_estado', 'Estado')  
                ->field_type('ars_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('ars_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('ars_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('ars_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('ars_codigo', 'Código', 'trim|required|campo_unico[ars_area_servicio.ars_codigo]')
                ->set_rules('ars_nombre', 'Nombre', 'trim|required|campo_unico[ars_area_servicio.ars_nombre]')
                ->unset_read()
        ;       

                // AGREGAR EL CÓDIGO SEGÚN CORRELATIVO.
                $crud->callback_add_field('ars_codigo', function () {
                    $tabla='ars_area_servicio';
                    $campo='ars_codigo';
                    $last=$this->consultas->get_max_codigo($tabla,$campo);

                    $code=$last->codigo;
                    $cod= (int)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

                    return '<input id="field-ars_codigo" name="ars_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                });

                $crud->callback_edit_field('ars_codigo', function ($value, $primary_key) {
                    if($value==''){
                      $tabla='ars_area_servicio';
                      $campo='ars_codigo';
                      $last=$this->consultas->get_max_codigo($tabla,$campo);

                      $code=$last->codigo;
                      $cod= (int)$code+1;
                      $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                      return '<input id="field-ars_codigo" name="ars_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                    }else{
                       return '<input id="field-ars_codigo" name="ars_codigo" type="text" maxlength="99" value="'.$value.'" >';
                    }
                });

                $state = $crud->getState();
                if($state== 'success'){
                    $crud->callback_field('ars_codigo', function ($value, $primary_key) {
                        if($value==''){
                          $tabla='ars_area_servicio';
                          $campo='ars_codigo';
                          $last=$this->consultas->get_max_codigo($tabla,$campo);

                          $code=$last->codigo;
                          $cod= (int)$code+1;
                          $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                          return '<input id="field-ars_codigo" name="ars_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                        }else{
                           return '<input id="field-ars_codigo" name="ars_codigo" type="text" maxlength="99" value="'.$value.'" >';
                        }
                    });
                }
     
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('ars_estado', 'hidden', 1);
        } else {
            $crud->field_type('ars_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }

        $output = $crud->render();
        $data['titulo_personal'] = "Área general de gastos";
        $this->_cargarvista($data, $output);
    }


     /**
     * @author Edith Herrera
     * @since  2018-03-24
     * @return Grid del mantenimiento de tipo de presupuesto.
    * */
    function tipo_presupuesto() {
        satelite_validar();

       $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

       $add_fields= array(
            'tpp_codigo',
            'tpp_nombre',
            'tpp_descripcion',
            'tpp_estado',
            'tpp_usu_creacion',
            'tpp_fecha_creacion',
            'tpp_usu_modificacion',
            'tpp_fecha_modificacion'
        );

       $edit_fields= array(
            'tpp_codigo',
            'tpp_nombre',
            'tpp_descripcion',
            'tpp_estado',
            'tpp_usu_modificacion',
            'tpp_fecha_modificacion'
        );

       $req_fields= array(
            'tpp_codigo',
            'tpp_nombre',
            'tpp_estado',
            'tpp_usu_modificacion',
            'tpp_fecha_modificacion'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('tpp_tipo_presupuesto')
                ->set_subject('Tipo de presupuesto')
                ->columns('tpp_codigo', 'tpp_nombre', 'tpp_descripcion', 'tpp_estado')
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($req_fields)
                ->display_as('tpp_codigo', 'Código')
                ->display_as('tpp_nombre', 'Nombre')
                ->display_as('tpp_descripcion', 'Descripción')
                ->display_as('tpp_estado', 'Estado')  
                ->field_type('tpp_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tpp_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('tpp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tpp_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('tpp_codigo', 'Código', 'trim|required|campo_unico[tpp_tipo_presupuesto.tpp_codigo]')
                ->set_rules('tpp_nombre', 'Nombre', 'trim|required|campo_unico[tpp_tipo_presupuesto.tpp_nombre]')
                ->unset_read()
        ;       

                // AGREGAR EL CÓDIGO SEGÚN CORRELATIVO.
                $crud->callback_add_field('tpp_codigo', function () {
                    $tabla='tpp_tipo_presupuesto';
                    $campo='tpp_codigo';
                    $last=$this->consultas->get_max_codigo($tabla,$campo);

                    $code=$last->codigo;
                    $cod= (int)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

                    return '<input id="field-tpp_codigo" name="tpp_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                });

                $crud->callback_edit_field('tpp_codigo', function ($value, $primary_key) {
                    if($value==''){
                      $tabla='tpp_tipo_presupuesto';
                      $campo='tpp_codigo';
                      $last=$this->consultas->get_max_codigo($tabla,$campo);

                      $code=$last->codigo;
                      $cod= (int)$code+1;
                      $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                      return '<input id="field-tpp_codigo" name="tpp_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                    }else{
                       return '<input id="field-tpp_codigo" name="tpp_codigo" type="text" maxlength="99" value="'.$value.'" >';
                    }
                });

                $state = $crud->getState();
                if($state== 'success'){
                    $crud->callback_field('tpp_codigo', function ($value, $primary_key) {
                        if($value==''){
                          $tabla='tpp_tipo_presupuesto';
                          $campo='tpp_codigo';
                          $last=$this->consultas->get_max_codigo($tabla,$campo);

                          $code=$last->codigo;
                          $cod= (int)$code+1;
                          $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                          return '<input id="field-tpp_codigo" name="tpp_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                        }else{
                           return '<input id="field-tpp_codigo" name="tpp_codigo" type="text" maxlength="99" value="'.$value.'" >';
                        }
                    });
                }
     
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tpp_estado', 'hidden', 1);
        } else {
            $crud->field_type('tpp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }

        $output = $crud->render();
        $data['titulo_personal'] = "Tipo de presupuesto";
        $this->_cargarvista($data, $output);
    }


     /**
     * @author Edith Herrera
     * @since  2018-03-24
     * @return Grid del mantenimiento de actividad general.
    * */
    function actividad_general() {
        satelite_validar();

       $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

       $add_fields= array(
            'acg_codigo',
            'acg_nombre',
            'Usuarios',
            'acg_detalles',
            'acg_descripcion',
            'acg_estado',
            'acg_usu_creacion',
            'acg_fecha_creacion',
            'acg_usu_modificacion',
            'acg_fecha_modificacion',
           
        );

       $edit_fields= array(
            'acg_codigo',
            'acg_nombre',
            'Usuarios',
            'acg_descripcion',
            'acg_detalles',
            'acg_estado',
            'acg_usu_modificacion',
            'acg_fecha_modificacion'
        );

       $req_fields= array(
            'acg_codigo',
            'acg_nombre',
            'acg_estado',
            'acg_usu_modificacion',
            'acg_fecha_modificacion'
        );

        $campos_auditoria = array(
            'uxa_estado'                => 1,
            'uxa_usu_creacion'          => $this->tank_auth->get_user_id(),
            'uxa_fecha_creacion'        => date('Y-m-d H:i:s'),
            'uxa_usu_modificacion'      => $this->tank_auth->get_user_id(),
            'uxa_fecha_modificacion'    => date('Y-m-d H:i:s')
            
        );

        $crud = new grocery_CRUD();
        $crud->set_table('acg_actividad_general')
                ->set_subject('Actividad general')
                ->columns('acg_codigo', 'acg_nombre','acg_detalles', 'acg_descripcion', 'acg_estado')
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($req_fields)
                ->display_as('acg_codigo', 'Código')
                ->display_as('acg_nombre', 'Nombre')
                ->display_as('acg_descripcion', 'Descripción')
                ->display_as('acg_detalles', 'Detalles')
                ->display_as('acg_estado', 'Estado')  
                ->field_type('acg_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('acg_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('acg_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('acg_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('acg_codigo', 'Código', 'trim|required|campo_unico[acg_actividad_general.acg_codigo]')
                ->set_rules('acg_nombre', 'Nombre', 'trim|required|campo_unico[acg_actividad_general.acg_nombre]')
                ->set_relation_n_n("Usuarios","uxa_usuarioxactividad_general","users","uxa_id_acg","uxa_id_usu","{username}",null, array('activated' => 1),$campos_auditoria)              
        ;       

        // AGREGAR EL CÓDIGO SEGÚN CORRELATIVO.
        $crud->callback_add_field('acg_codigo', function () {
            $tabla='acg_actividad_general';
            $campo='acg_codigo';
            $last=$this->consultas->get_max_codigo($tabla,$campo);

            $code=$last->codigo;
            $cod= (int)$code+1;
            $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

            return '<input id="field-acg_codigo" name="acg_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
        });

        $crud->callback_edit_field('acg_codigo', function ($value, $primary_key) {
            if($value==''){
                $tabla='acg_actividad_general';
                $campo='acg_codigo';
                $last=$this->consultas->get_max_codigo($tabla,$campo);

                $code=$last->codigo;
                $cod= (int)$code+1;
                $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                return '<input id="field-acg_codigo" name="acg_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
            }else{
                return '<input id="field-acg_codigo" name="acg_codigo" type="text" maxlength="99" value="'.$value.'" >';
            }
        });

        $state = $crud->getState();
        if($state== 'success'){
            $crud->callback_field('acg_codigo', function ($value, $primary_key) {
                if($value==''){
                    $tabla='acg_actividad_general';
                    $campo='acg_codigo';
                    $last=$this->consultas->get_max_codigo($tabla,$campo);

                    $code=$last->codigo;
                    $cod= (int)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                    return '<input id="field-acg_codigo" name="acg_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                }else{
                    return '<input id="field-acg_codigo" name="acg_codigo" type="text" maxlength="99" value="'.$value.'" >';
                }
            });
        }
     
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('acg_estado', 'hidden', 1);
        } else {
            $crud->field_type('acg_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if(!$permisos["permite_editar"]){
            $crud->unset_edit();
        }

        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'modulo_presupuesto/pre_mantenimientos/actividad_general/read');
        }

        if(!$permisos["permite_eliminar"]){
            $crud->unset_delete();
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Actividad general";
        $this->_cargarvista($data, $output);
    }

    /**
     * Descripción:
     * Mantenimieto de centros de costo - Funcionalidad compartida de Estructura organizativa
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-03-24
     */
    function centro_costos() {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/mantenimientos');
        $this->mantenimientos->centro_costos('modulo_presupuesto/pre_mantenimientos', 'centros_costo');
    }


     /**
     * @author Edith Herrera
     * @since  2018-03-24
     * @modify 2018-12-10
     * @author modif Manuel Anzora
     * @return Grid del mantenimiento de actividad específica.
    * */
    function actividad_especifica() {
        satelite_validar();

        $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion('modulo_presupuesto/pre_mantenimientos/actividad_especifica');
        try {
            $add_fields = array(
                'ace_id_acg',
                'ace_id_dependencia',
                'ace_codigo',
                'ace_nombre',
                'ace_descripcion',
                'ace_estado',
                'ace_usu_creacion',
                'ace_fecha_creacion',
                'ace_usu_modificacion',
                'ace_fecha_modificacion'
            );

            $edit_fields = array(
                'ace_id',
                'ace_id_acg',
                'ace_id_dependencia',
                'ace_codigo',
                'ace_nombre',
                'ace_descripcion',
                'ace_estado',
                'ace_usu_modificacion',
                'ace_fecha_modificacion'
            );

            $req_fields= array(
                'ace_codigo',
                'ace_nombre',
                'ace_estado',
                'ace_usu_modificacion',
                'ace_fecha_modificacion'
            );

            $crud = new grocery_CRUD();
            $crud->set_table('ace_actividad_especifica')
                    ->set_relation('ace_id_acg', 'acg_actividad_general', '{acg_codigo} {acg_nombre}')
                    ->set_relation('ace_id_dependencia', 'ace_actividad_especifica', '{ace_codigo} {ace_nombre}')
                    ->set_subject('Pda. Presup. / Rubro')
                    ->columns('ace_id_acg','ace_id_dependencia','ace_codigo', 'ace_nombre', 'ace_descripcion', 'ace_estado')
                    ->add_fields($add_fields)
                    ->edit_fields($edit_fields)
                    ->required_fields($req_fields)
                    ->display_as('ace_codigo', 'Código')
                    ->display_as('ace_nombre', 'Nombre')
                    ->display_as('ace_descripcion', 'Descripción')
                    ->display_as('ace_estado', 'Estado')
                    ->display_as('ace_id_acg', 'Actividad general')
                    ->display_as('ace_id_dependencia', 'Dependencia')  
                    ->field_type('ace_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('ace_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('ace_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('ace_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('ace_id','hidden')
                    ->set_rules('ace_codigo', 'Código', 'trim|required|campo_unico[ace_actividad_especifica.ace_codigo]')
                    ->set_rules('ace_nombre', 'Nombre', 'trim|required|[ace_actividad_especifica.ace_nombre]')
            ;       
            
            // AGREGAR EL CÓDIGO SEGÚN CORRELATIVO.
            $crud->callback_add_field('ace_codigo', function () {
                $tabla='ace_actividad_especifica';
                $campo='ace_codigo';
                $last=$this->consultas->get_max_codigo($tabla,$campo);

                $code=$last->codigo;
                $cod= (int)$code+1;
                $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

                return '<input id="field-ace_codigo" name="ace_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
            });

            $crud->callback_edit_field('ace_codigo', function ($value, $primary_key) {
                if($value==''){
                    $tabla='ace_actividad_especifica';
                    $campo='ace_codigo';
                    $last=$this->consultas->get_max_codigo($tabla,$campo);

                    $code=$last->codigo;
                    $cod= (int)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                    return '<input id="field-ace_codigo" name="ace_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                }else{
                    return '<input id="field-ace_codigo" name="ace_codigo" type="text" maxlength="99" value="'.$value.'" >';
                }
            });

            $state = $crud->getState();
            if($state== 'success'){
                $crud->callback_field('ace_codigo', function ($value, $primary_key) {
                    if($value==''){
                        $tabla='ace_actividad_especifica';
                        $campo='ace_codigo';
                        $last=$this->consultas->get_max_codigo($tabla,$campo);

                        $code=$last->codigo;
                        $cod= (int)$code+1;
                        $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                        return '<input id="field-ace_codigo" name="ace_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                    }else{
                        return '<input id="field-ace_codigo" name="ace_codigo" type="text" maxlength="99" value="'.$value.'" >';
                    }
                });
            }
        
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('ace_estado', 'hidden', 1);
            } else {
                $crud->field_type('ace_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            /*if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }*/
            if (!$permisos['permite_ver']) {
              $crud->unset_read();
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }

        $output = $crud->render();
        $data['titulo_personal'] = "Pda. Presup. / Rubro";
        $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }


     /**
     * @author Edith Herrera
     * @since  2018-04-05
     * @return Grid del mantenimiento de fuente de verificación
    * */
    function fuente_verificacion() {
        satelite_validar();

       $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();

       $add_fields= array(
            'fuv_codigo',
            'fuv_nombre',
            'fuv_descripcion',
            'fuv_estado',
            'fuv_usu_creacion',
            'fuv_fecha_creacion',
            'fuv_usu_modificacion',
            'fuv_fecha_modificacion'
        );

       $edit_fields= array(
            'fuv_codigo',
            'fuv_nombre',
            'fuv_descripcion',
            'fuv_estado',
            'fuv_usu_modificacion',
            'fuv_fecha_modificacion'
        );

       $req_fields= array(
            'fuv_codigo',
            'fuv_nombre',
            'fuv_estado',
            'fuv_usu_modificacion',
            'fuv_fecha_modificacion'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('fuv_fuente_verificacion')
                ->set_subject('Fuente de verificación')
                ->columns('fuv_codigo', 'fuv_nombre', 'fuv_descripcion', 'fuv_estado')
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($req_fields)
                ->display_as('fuv_codigo', 'Código')
                ->display_as('fuv_nombre', 'Nombre')
                ->display_as('fuv_descripcion', 'Descripción')
                ->display_as('fuv_estado', 'Estado')  
                ->field_type('fuv_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('fuv_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('fuv_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('fuv_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('fuv_codigo', 'Código', 'trim|required|campo_unico[fuv_fuente_verificacion.fuv_codigo]')
                ->set_rules('fuv_nombre', 'Nombre', 'trim|required|campo_unico[fuv_fuente_verificacion.fuv_nombre]')
                ->unset_read()
        ;       

                // AGREGAR EL CÓDIGO SEGÚN CORRELATIVO.
                $crud->callback_add_field('fuv_codigo', function () {
                    $tabla='fuv_fuente_verificacion';
                    $campo='fuv_codigo';
                    $last=$this->consultas->get_max_codigo($tabla,$campo);

                    $code=$last->codigo;
                    $cod= (int)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

                    return '<input id="field-fuv_codigo" name="fuv_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                });

                $crud->callback_edit_field('fuv_codigo', function ($value, $primary_key) {
                    if($value==''){
                      $tabla='fuv_fuente_verificacion';
                      $campo='fuv_codigo';
                      $last=$this->consultas->get_max_codigo($tabla,$campo);

                      $code=$last->codigo;
                      $cod= (int)$code+1;
                      $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                      return '<input id="field-fuv_codigo" name="fuv_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                    }else{
                       return '<input id="field-fuv_codigo" name="fuv_codigo" type="text" maxlength="99" value="'.$value.'" >';
                    }
                });

                $state = $crud->getState();
                if($state== 'success'){
                    $crud->callback_field('fuv_codigo', function ($value, $primary_key) {
                        if($value==''){
                          $tabla='fuv_fuente_verificacion';
                          $campo='fuv_codigo';
                          $last=$this->consultas->get_max_codigo($tabla,$campo);

                          $code=$last->codigo;
                          $cod= (int)$code+1;
                          $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                          return '<input id="field-fuv_codigo" name="fuv_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                        }else{
                           return '<input id="field-fuv_codigo" name="fuv_codigo" type="text" maxlength="99" value="'.$value.'" >';
                        }
                    });
                }
     
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('fuv_estado', 'hidden', 1);
        } else {
            $crud->field_type('fuv_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

         // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }

        $output = $crud->render();
        $data['titulo_personal'] = "Fuente de verificación";
        $this->_cargarvista($data, $output);
    }


    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }
    /**
     * @author Manuel Anzora
     * @since  2018-12-10
     * @return obtiene actividades vinculadas a una actividad general
    * */
    public function get_dependencia($id=null){
      
      if($_POST){
        $general = $this->input->post('act_general');
        $band=0;
        if($this->input->post('id')>0){
          //para el editar
          $info_actividad = $this->gsatelite->get_tabla('ace_actividad_especifica', array('ace_id'=>$this->input->post('id')));
          $cod_ace='';
          foreach ($info_actividad as $value) {
            if($value['ace_id_acg'] == $general){
              $band=1;
              $cod_ace = $value['ace_codigo'];
            }
          }
          if($band==0){
            $dependientes = $this->gsatelite->get_tabla('ace_actividad_especifica', array('ace_id_acg'=>$general));
            //codigo sugerido segun la actividad general seleccionada
            $html = '<option value=""></option>';
            foreach ($dependientes as $value) {
              $html .= '<option value="'.$value['ace_id'].'">'.$value['ace_codigo'].' '.$value['ace_nombre'].'</option>';
            }
            $codigo = $this->get_codigo($this->input->post('act_general')); 
          }else{
            $dependientes = $this->gsatelite->get_tabla('ace_actividad_especifica', array('ace_id_acg'=>$general,'ace_id !='=>$this->input->post('id')));
            //codigo sugerido segun la actividad general seleccionada
            $html = '<option value=""></option>';
            foreach ($dependientes as $value) {
              $html .= '<option value="'.$value['ace_id'].'">'.$value['ace_codigo'].' '.$value['ace_nombre'].'</option>';
            }
            //codigo sugerido segun la actividad general seleccionada
            $codigo = $cod_ace;
          }
        }else{
          //PARA EL ADD O AGREGAR
          //$html = $this->gsatelite->get_dropdown('ace_actividad_especifica', '{ace_codigo} {ace_nombre}', '', array('ace_id_acg'=>$this->input->post('act_general')) ,null,null,'ace_id',true);

          $dependientes = $this->gsatelite->get_tabla('ace_actividad_especifica', array('ace_id_acg'=>$general));
            //codigo sugerido segun la actividad general seleccionada
            $html = '<option value=""></option>';
            foreach ($dependientes as $value) {
              $html .= '<option value="'.$value['ace_id'].'">'.$value['ace_codigo'].' '.$value['ace_nombre'].'</option>';
            }
          //codigo sugerido segun la actividad general seleccionada
          $codigo = $this->get_codigo($this->input->post('act_general'));  
        } 
      }
      
      echo json_encode(['options'=>$html,'codigo'=>$codigo,'estado'=>'exito']);
      
      
    }
    /**
     * @author Manuel Anzora
     * @since  2018-12-10
     * @return retorna el codigo de la actividad general seleccionada
    * */
    public function get_codigo($id, $noid=null){
      //OBTIENE EL CODIGO DE LA ACTIVDIAD GENERAL
      $data = $this->gsatelite->get_tabla('acg_actividad_general', array('acg_id'=>$id));
      $code = '';
      foreach ($data as $value) {
        $code = $value['acg_codigo'];
      }
      //CALCULA EL CORRELATIVO
      if($noid!=null){
        
        $childs = $this->gsatelite->get_tabla('ace_actividad_especifica', array('ace_id_acg'=>$id, 'ace_id !='=>$noid));
      }else{
        $childs = $this->gsatelite->get_tabla('ace_actividad_especifica', array('ace_id_acg'=>$id));
      }
      
      $num_childs = (count($childs)==0)?1:(count($childs))+1;
      $codigo_sugerido = $code.'.'.$num_childs;
      return $codigo_sugerido;
    }
    /**
     * @author Manuel Anzora
     * @since  2018-12-10
     * @return retorna 1 si el codigo que recibe existe en algun registro
    * */
    public function val_unique_code($band=null){
      if($this->input->post('id')>0){
        $info = $this->gsatelite->get_tabla('ace_actividad_especifica', array('ace_codigo'=>$this->input->post('codigo'),'ace_id !='=>$this->input->post('id')));
      }else{
        $info = $this->gsatelite->get_tabla('ace_actividad_especifica', array('ace_codigo'=>$this->input->post('codigo')));
      }
      if(count($info)>0){
        echo 1;
      }else{
        echo 0;
      }
    }
    public function get_code_dependencia($band=null){
      //OBTIENE EL CODIGO DE LA ACTIVDIAD GENERAL
      $id = $this->input->post('ace_dependencia');
      $data = $this->gsatelite->get_tabla('ace_actividad_especifica', array('ace_id'=>$id));
      $code = '';
      foreach ($data as $value) {
        $code = $value['ace_codigo'];
      }
      //CALCULA EL CORRELATIVO
      $childs = $this->gsatelite->get_tabla('ace_actividad_especifica', array('ace_id_dependencia'=>$id));
      $num_childs = (count($childs)==0)?1:(count($childs))+1;
      echo $code.'.'.$num_childs;
      
    }
    /**
     * @author Manuel Anzora
     * @since  2018-12-11
     * @return Grid del mantenimiento de financiadores del presupuesto.
    * */
    public function financiador_presupuesto(){
      satelite_validar();
      $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion('modulo_presupuesto/pre_mantenimientos/financiador_presupuesto');
      try {
       $add_fields= array(
            'fnc_nombre',
            'fnc_descripcion',
            'fnc_estado',
            'fnc_usu_creacion',
            'fnc_fecha_creacion',
            'fnc_usu_modificacion',
            'fnc_fecha_modificacion'
        );

       $edit_fields= array(
            'fnc_id',
            'fnc_nombre',
            'fnc_descripcion',
            'fnc_estado',
            'fnc_usu_modificacion',
            'fnc_fecha_modificacion'
        );

       $req_fields= array(
            'fnc_nombre',
            'fnc_estado'
        );

      $crud = new grocery_CRUD();
      $crud->set_table('fnc_financiador')
                ->set_subject('Financiador')
                ->columns('fnc_nombre', 'fnc_descripcion', 'fnc_estado')
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($req_fields)
                ->display_as('fnc_nombre', 'Nombre')
                ->display_as('fnc_descripcion', 'Descripción')
                ->display_as('fnc_estado', 'Estado')
                ->field_type('fnc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('fnc_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('fnc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('fnc_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('fnc_id','hidden')
                ->set_rules('fnc_nombre', 'Nombre', 'trim|required|campo_unico[fnc_financiador.fnc_nombre]');
      if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('fnc_estado', 'hidden', 1);
        } else {
            $crud->field_type('fnc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if (!$permisos['permite_ver']) {
              $crud->unset_read();
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }
        $output = $crud->render();
        $data['titulo_personal'] = "Financiador";
        $this->_cargarvista($data, $output);  
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }  
    }

    /**
     *
     * @author Manuel Anzora
     * @since 2018-12-11
     * @return Grid del mantenimiento de tipo de gastos, modulo presupuesto.
     */
    public function tipo_gasto() {
        satelite_validar();
        $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();
        try {
            $add_fields = array(
                'tgp_nombre',
                'tgp_descripcion',
                'tgp_estado',
                'tgp_usu_creacion',
                'tgp_fecha_creacion',
                'tgp_usu_modificacion',
                'tgp_fecha_modificacion'
            );

            $edit_fields = array(
                'tgp_id',
                'tgp_nombre',
                'tgp_descripcion',
                'tgp_estado',
                'tgp_usu_modificacion',
                'tgp_fecha_modificacion'
            );

            $req_fields = array(
                'tgp_nombre',
                'tgp_estado'
            );

            $display_as = array(
                'tgp_nombre' => 'Nombre',
                'tgp_descripcion' => 'Descripción',
                'tgp_estado' => 'Estado'
            );

            $column = array(
                'tgp_nombre',
                'tgp_descripcion',
                'tgp_estado'
            );

            $crud = new grocery_CRUD();
            $crud->set_table('tgp_tipo_gasto_presupuesto')
                ->set_subject('Tipo de gasto')
                ->columns($column)
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($req_fields)
                ->display_as($display_as)
                ->field_type('tgp_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tgp_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('tgp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tgp_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('tgp_id', 'hidden')
                ->set_rules('tgp_nombre', 'Nombre', 'trim|required|campo_unico[tgp_tipo_gasto_presupuesto.tgp_nombre]');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tgp_estado', 'hidden', 1);
            } else {
                $crud->field_type('tgp_estado', 'dropdown', array(
                    '1' => 'Activo',
                    '0' => 'Inactivo'
                ));
            }

            // Validaciones
            if (! $permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (! $permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (! $permisos['permite_ver']) {
                $crud->unset_read();
            }
            if (! $permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Tipo de gasto";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * Descripción:
     * Función de Mantenimiento de Fuente de Financiamiento
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-12-14
     * @param Ninguno
     * @return HTML
     */
    public function fuente_financiamiento() {
        satelite_validar();
        $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion();
        try {
            $add_fields = array(
                'fnf_nombre',
                'fnf_descripcion',
                'fnf_estado',
                'fnf_usu_creacion',
                'fnf_fecha_creacion',
                'fnf_usu_modificacion',
                'fnf_fecha_modificacion'
            );

            $edit_fields = array(
                'fnf_id',
                'fnf_nombre',
                'fnf_descripcion',
                'fnf_estado',
                'fnf_usu_modificacion',
                'fnf_fecha_modificacion'
            );

            $req_fields = array(
                'fnf_nombre',
                'fnf_estado'
            );
            
            $display_as = array(
                'fnf_nombre'      => 'Nombre',
                'fnf_descripcion' => 'Descripción',
                'fnf_estado'      => 'Estado'
            );
            
            $columns = array('fnf_nombre', 'fnf_descripcion', 'fnf_estado');

            $crud = new grocery_CRUD();
            $crud->set_table('fnf_fuente_financiamiento')
                ->set_subject('Fuente de Financiamiento')
                ->columns($columns)
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($req_fields)
                ->display_as($display_as)
                ->field_type('fnf_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('fnf_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('fnf_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('fnf_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('fnf_id', 'hidden')
                ->set_rules('fnf_nombre', 'Nombre', 'trim|required|campo_unico[fnf_fuente_financiamiento.fnf_nombre]');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('fnf_estado', 'hidden', 1);
            } else {
                $crud->field_type('fnf_estado', 'dropdown', array(
                    '1' => 'Activo',
                    '0' => 'Inactivo'
                ));
            }

            // Validaciones
            if (! $permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (! $permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (! $permisos['permite_ver']) {
                $crud->unset_read();
            }
            if (! $permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Fuente de Financiamiento";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * Descripción:
     * Función de Mantenimiento de proyectos
     * @author Francisco Orozco - Grupo Satélite
     * @since 2019-05-14
     * @param Ninguno
     * @return HTML
    */
    public function proyectos() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD;
        $colums = array(
            'pcl_codigo',
            'pcl_id_padre',
            'pcl_nombre',
            'pcl_id_scl',
            'pcl_id_epr'
        );

        $alias = array(
            'pcl_id_padre'      => 'Nivel superior',
            'pcl_id_scl'        => 'Sucursal',
            'pcl_id_epr'        => 'Estado del proyecto',
            'pcl_codigo'        => 'Código',
            'pcl_nombre'        => 'Nombre'   ,
            'pcl_descripcion'   => 'Descripción',
            'pcl_estado'        => 'Estado',
        );

        $crud->set_table('pcl_proyecto_cliente')
            ->set_subject('')
            ->display_as($alias)
            ->columns($colums)
            ->field_type('pcl_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('pcl_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('pcl_id_cli', 'hidden', $cli_id)
            ->set_relation('pcl_id_scl', 'scl_sucursal_cliente', 'scl_nombre', array('scl_estado' => 1, 'scl_id_cli' => $cli_id))            
        ;

        $crud->set_relation('pcl_id_padre', 'pcl_proyecto_cliente', '{pcl_nombre}', array('pcl_id_cli' => $cli_id, 'pcl_estado' => 1, 'pcl_id !=' => $idno),'pcl_nombre');
        
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('pcl_estado', 'hidden', 1)
                    ->field_type('pcl_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('pcl_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $crud->field_type('pcl_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $crud->unset_add();
        $crud->unset_edit();

        $ruta = explode('/', uri_string());
        

        if (in_array("read", $ruta)) {
            $crud->set_relation('pcl_id_epr', 'epr_estado_proyecto', 'epr_nombre', array('epr_estado' => 1));
        } else {
            $crud->set_relation('pcl_id_epr', 'epr_estado_proyecto', 'epr_nombre', array('epr_estado' => 1, 'epr_cierre <>' => 1));
        }

        // Validaciones
        if ( $permisos['permite_agregar'] ) {
            $data['agregar'] = true;
        }
       
        if ($permisos['permite_editar']) {
            $crud->add_action('Editar', ' icomoon-icon-pencil-5', "modulo_presupuesto/pre_mantenimientos/editar_proyecto",'');
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
           // $crud->add_action('Ver', 'minia-icon-search', "cotizaciones/mantenimientos/proyectos/$cli_id/read",'ver_proyectos');
        }

        $crud->add_action('Finalizar proyecto', 'brocco-icon-checkmark', 'cotizaciones/mantenimientos/proyectos','finalizar');

        $output = $crud->render();
        $data['titulo_personal'] = 'Proyectos';
        $this->_cargarvista($data, $output);
    }

    function agregar_proyecto() {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->agregar_proyectos(null,'modulo_presupuesto/pre_mantenimientos/');
    }

    function editar_proyecto($proyecto) {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->editar_proyecto($proyecto,'modulo_presupuesto/pre_mantenimientos/');
    }

    /**
     * Descripción:
     * Función de Mantenimiento de tipo de fineanciador
     * @author Francisco Orozco - Grupo Satélite
     * @since 2019-08-09
     * @param Ninguno
     * @return HTML
    */
    public function tipo_financiador() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD;

        $colums = array(
            'tfn_nombre',
            'tfn_descripcion',
            'tfn_estado',
        );

        $alias = array(
            'tfn_nombre'        => 'Financiador',
            'tfn_descripcion'   => 'Descripción',
            'tfn_estado'        => 'Estado',
        );

        $add_fields= array(
            'tfn_nombre',
            'tfn_descripcion',
            'tfn_estado',
            'tfn_usu_creacion',
            'tfn_fecha_creacion',
            'tfn_usu_modificacion',
            'tfn_fecha_modificacion'
        );

       $edit_fields= array(
            'tfn_nombre',
            'tfn_descripcion',
            'tfn_estado',
            'tfn_usu_modificacion',
            'tfn_fecha_modificacion'
        );

       $req_fields= array(
            'tfn_nombre',
            'tfn_estado',
            'tfn_usu_modificacion',
            'tfn_fecha_modificacion'
        );

        $crud->set_table('tfn_tipo_financiador')
            ->set_subject('Tipo de financiador')
            ->add_fields($add_fields)
            ->edit_fields($edit_fields)
            ->required_fields($req_fields)
            ->display_as($alias)
            ->columns($colums)
            ->field_type('tfn_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tfn_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
        ;

        
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tfn_estado', 'hidden', 1)
                    ->field_type('tfn_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('tfn_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $crud->field_type('tfn_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }


        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if(!$permisos["permite_editar"]){
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Tipo de financiador';
        $this->_cargarvista($data, $output);
    }
    
} // End of class

?>