<?php
/**
 * Created by PhpStorm.
 * pla_plan_operativo.php
 * Descripción:
 * Funcionalidad del sistema.
 *
 * @package ERP
 * @subpackage Modulo - Planificación (Plan Operativo)
 * @copyright Copyright (c) 2018 Grupo Satélite S.A. DE C.V.
 * @author Mario Marquez - Grupo Satélite
 * @version 2020 - 1
 * @since Archivo disponible desde 2020-03-05
 */

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Pla_riesgos extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->library('texto');
        $this->load->model('plan_operativo_model');
    }

    /**
     * Descripción:
     * Función para la vista index
     * @author Mario Marquez - Grupo Satélite
     * @since 2020-06-08
     */
    public function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    /**
     * Descripción:
     * Catalogo de Plan Estrategicos
     * @author Mario Marquez - Grupo Satélite
     * @since 2020-01-24
     * @param ninguno
     */
    function activar_matriz(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos = $this->gsatelite->get_permisos_opcion();
                $flujos_parametro = json_decode($this->gsatelite->get_parametro("SYS_FLUJO_PLANIFICACION"), true);

                $add_fields = array(
                    'mai_nombre',
                    'mai_anio',
                    'mai_estado',
                    'mai_usu_creacion',
                    'mai_usu_modificacion',
                    'mai_fecha_creacion',
                    'mai_fecha_modificacion'
                );

                $edit_fields = array(
                    'mai_nombre',
                    'mai_anio',
                    'mai_estado',
                    'mai_usu_modificacion',
                    'mai_fecha_modificacion'
                );

                $display_as = array(
                    'mai_nombre' => 'Nombre',
                    'mai_anio' => 'Año del Plan',
                    'mai_estado' => 'Estado'
                );

                $required_fields = array(
                    'mai_nombre',
                    'mai_anio',
                    'mai_estado',
                    'mai_usu_modificacion',
                    'mai_fecha_modificacion'
                );

                $columns = array(
                    'mai_nombre',
                    'mai_anio'
                );

                $crud = new grocery_CRUD();
                $crud->set_table('mai_matriz_riesgo');
                $crud->set_subject('Matriz de Riesgo Anual');
                $crud->display_as($display_as);
                $crud->display_as('poa_estado', 'Estado');
                $crud->columns($columns);
                $crud->add_fields($add_fields);
                $crud->edit_fields($edit_fields);
                $crud->required_fields($required_fields);
                $crud->set_rules('mai_nombre', 'Nombre', 'campo_unico[mai_matriz_riesgo.mai_nombre]|required');
                $crud->set_rules('mai_anio', 'Año del Plan', 'campo_unico[mai_matriz_riesgo.mai_anio]|required');
                $crud->field_type('mai_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('mai_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));

                //Se lista los años 3 atras y 5 adelante.
                $anio_array = array();

                for ($i = (date('Y') - 3); $i <= (date('Y') + 5); $i++) {
                    $anio_array[$i] = $i;
                }

                $crud->field_type('mai_anio', 'dropdown', $anio_array);

                $crud->callback_after_insert(function ($post_array, $primary_key) {
                    //Se obtienen los puestos por los planes estrategicos asignados

                    $areas = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1));
                    $flujos_parametro = json_decode($this->gsatelite->get_parametro("SYS_FLUJO_PLANIFICACION"), true);

                    //Se ingresan los Poa por Unidad
                    foreach ($areas as $are) {
                        $pxu_array = array(
                            'mxu_id_are' => $are['are_id'],
                            'mxu_id_mai' => $primary_key,
                            'mxu_id_flu' => $flujos_parametro['POA']['FORMULACION'],
                            "mxu_estado" => 1,
                            "mxu_usu_creacion" => $this->tank_auth->get_user_id(),
                            "mxu_usu_modificacion" => $this->tank_auth->get_user_id(),
                            "mxu_fecha_creacion" => date('Y-m-d H:i:s'),
                            "mxu_fecha_modificacion" => date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('mxu_matrizxunidad', $pxu_array);
                    }
                    return true;
                });

                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('mai_estado', 'hidden', 1);
                    $crud->field_type('mai_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                    $crud->field_type('mai_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));

                } else {
                    //$data['pes_id'] = end(explode('/', uri_string()));
                    $crud->field_type('mai_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                $crud->unset_export();
                $crud->unset_print();
                $url = explode('/', uri_string());

                // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                } else {
                    //$crud->add_action('Planes Activos', 'icon16 icomoon-icon-rock', 'modulo_planificacion/pla_plan_operativo/plan_operativos_unidad');
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                if (!$permisos['permite_ver']) {
                    $crud->unset_read();
                    // $crud->add_action('Ver', 'minia-icon-search', 'modulo_planificacion/Pla_riesgos/activar_matriz/read');
                }

                $output = $crud->render();
                $data['titulo_personal'] = "Matríz de Riesgo Anual";
                cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function riesgos($matriz = 0, $area = 0, $plan_unidad = null, $tipo_flujo = null, $registro_seg = null){
        satelite_validar();
        $permisos = array();
        if (is_null($tipo_flujo)) {
            $permisos = $this->gsatelite->get_permisos_opcion();
        }
        $where = $mai_id = $plan_area = null;
        $registro = $mxus = array();
        if ($_POST) {
            $post_array = $this->input->post();
            if ($post_array['slcMatriz'] > 0) {
                $where['mai_id'] = $post_array['slcMatriz'];
            }
            if ($post_array['slcArea'] > 0) {
                $where['are_id'] = $post_array['slcArea'];
            }
        } else {
            if ($matriz > 0) {
                $where['mai_id'] = $matriz;
            }
            if ($area > 0) {
                $where['are_id'] = $area;
            }
        }
        if ($where) {
            $mxus = $this->plan_operativo_model->get_riesgos($where);
        }        
        if (count($mxus) > 0) {
            $registro = $mxus;
            $mai_id = $mxus[0]['mai_id'];
            if ($post_array['slcArea'] > 0 || $area > 0) {
                $plan_area['are_id'] = $mxus[0]['are_id'];
                $plan_area['are_nombre'] = $mxus[0]['are_nombre'];
            }
        }
        $matriz_riesgo = $this->gsatelite->get_dropdown('mai_matriz_riesgo', '{mai_nombre}', '', array('mai_estado' => 1), $mai_id, '', 'mai_id', true);
        $data['matriz'] = $mai_id;
        $data['plan_area'] = $plan_area;
        $data['filas_consulta'] = $registro;
        $data['permisos'] = $permisos;
        $data['matrices'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $matriz_riesgo);
        $data['titulo_personal'] = "Riesgos";
        cargarvista($data);
    }

    public function agregar_riesgos($plan_unidad = null, $tipo_flujo = null, $registro_seg = null){
        if ($this->input->post()) {
            // var_dump($_POST);die();
            $post = $this->input->post();
            $obj = explode('_', $post['slcObjetivo']);
            $tbl_mxu = $this->gsatelite->get_tabla('mxu_matrizxunidad', array('mxu_id_mai' => $post['slcMatUnidad'], 'mxu_id_are' => $post['slcAreaMatriz'], 'mxu_estado' => 1));
            if (count($tbl_mxu) > 0) {
                $riesgo = array(
                    'rsg_id_mxu' => $tbl_mxu[0]['mxu_id'],
                    'rsg_id_clr' => $post['slcClasificiacion'],
                    'rsg_id_imr_pre_control' => $post['slc_impact_a'],
                    'rsg_id_imr_post_control' => $post['slc_impact_d'],
                    'rsg_id_prb_pre_control' => $post['slc_probability_a'],
                    'rsg_id_prb_post_control' => $post['slc_probability_d'],
                    'rsg_id_evt' => $post['txt_eval_id'],
                    'rsg_id_plz' => $post['slcResponsable'],
                    'rsg_id_obo' => ($post['tipo_objetivo'] == 'o') ? $obj[0] : null,
                    'rsg_id_obe' => ($post['tipo_objetivo'] == 'e') ? $obj[0] : null,
                    'rsg_codigo' => $post['txtCodigo'],
                    'rsg_nombre' => $post['txtNombre'],
                    'rsg_consecuencia' => $post['txtConsecuencia'],
                    'rsg_propuesta' => $post['txtPropuesta'],
                    'rsg_fecha_inicio_prop' => formatear_fecha('Y-m-d', $post['txtFechaInicio']),
                    'rsg_fecha_fin_prop' => formatear_fecha('Y-m-d', $post['txtFechaFin']),
                    'rsg_estado' => 1,
                    'rsg_usu_creacion' => $this->tank_auth->get_user_id(),
                    'rsg_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'rsg_fecha_creacion' => date('Y-m-d H:i:s'),
                    'rsg_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $id_rsg = $this->gsatelite->ingresar('rsg_riesgos', $riesgo);
                for ($i = 0; $i < count($post['ids_fac']); $i++) { 
                    $factor = array(
                        'fxr_id_rsg' => $id_rsg,
                        'fxr_id_fae' => ($post['tipo_fac'][$i] == 1) ? $post['ids_fac'][$i] : null,
                        'fxr_id_fai' => ($post['tipo_fac'][$i] == 2) ? $post['ids_fac'][$i] : null,
                        'fxr_descripcion' => $post['desc_fac'][$i],
                        'fxr_usu_creacion' => $this->tank_auth->get_user_id(),
                        'fxr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'fxr_fecha_creacion' => date('Y-m-d H:i:s'),
                        'fxr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('fxr_factoresxriesgo', $factor);
                }
                foreach ($post['indicadores'] as $k => $value) {
                    $indicador = array(
                        'inr_id_rsg' => $id_rsg,
                        'inr_nombre' => $value,
                        'inr_estado' => 1,
                        'inr_usu_creacion' => $this->tank_auth->get_user_id(),
                        'inr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'inr_fecha_creacion' => date('Y-m-d H:i:s'),
                        'inr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('inr_indicador_riesgo', $indicador);
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Riesgos registro", 'texto_alerta' => "El registro se guardó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "No se pudo guardar el registro", 'texto_alerta' => "Corrobore los datos y vuelva a intentar");
            }
            $this->session->set_flashdata($alerta);
            if ($post['btnCrear'] > 0) {
                redirect('modulo_planificacion/pla_riesgos/riesgos');
            } else {
                redirect('modulo_planificacion/pla_riesgos/agregar_riesgos');
            }
        }
        $select_mai = $this->gsatelite->get_dropdown('mai_matriz_riesgo', '{mai_nombre}', '', array('mai_estado' => 1), null, '', 'mai_id', true);
        $select_imr = $this->gsatelite->get_dropdown('imr_impacto_riesgo', '{imr_nombre}', '', array('imr_estado' => 1), null, '', 'imr_id', true);
        $select_clr = $this->gsatelite->get_dropdown('clr_clasificacion_riesgo', '{clr_nombre}', '', array('clr_estado' => 1), null, '', 'clr_id', true);
        $select_cac = $this->gsatelite->get_dropdown('cac_control_actual', '{cac_nombre}', '', array('cac_estado' => 1), null, '', 'cac_id', true);
        $select_prb = $this->gsatelite->get_dropdown('prb_probabilidad_riesgo', '{prb_nombre}', '', array('prb_estado' => 1), null, '', 'prb_id', true);
        $data['impacto'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select_imr);
        $data['probabilidad'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select_prb);
        $data['controles_act'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select_cac);
        $data['matriz_riesgo'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select_mai);
        $data['clasificacion'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select_clr);
        $data['titulo_personal'] = "Agregar Riesgo";
        cargarvista($data);
    }

    public function viedit_riesgo($mai_id = 0, $are_id = 0, $rsg_id = 0,  $ver = null){
        satelite_validar();
        if ($_POST) {
            // var_dump($_POST);die();
            $post = $this->input->post();
            $obj = explode('_', $post['slcObjetivo']);
            $tbl_mxu = $this->gsatelite->get_tabla('mxu_matrizxunidad', array('mxu_id_mai' => $post['slcMatUnidad'], 'mxu_id_are' => $post['slcAreaMatriz'], 'mxu_estado' => 1));
            if (count($tbl_mxu) > 0) {
                $riesgo = array(
                    'rsg_id_mxu' => $tbl_mxu[0]['mxu_id'],
                    'rsg_id_clr' => $post['slcClasificiacion'],
                    'rsg_id_imr_pre_control' => $post['slc_impact_a'],
                    'rsg_id_imr_post_control' => $post['slc_impact_d'],
                    'rsg_id_prb_pre_control' => $post['slc_probability_a'],
                    'rsg_id_prb_post_control' => $post['slc_probability_d'],
                    'rsg_id_evt' => $post['txt_eval_id'],
                    'rsg_id_plz' => $post['slcResponsable'],
                    'rsg_id_obo' => ($post['tipo_objetivo'] == 'o') ? $obj[0] : null,
                    'rsg_id_obe' => ($post['tipo_objetivo'] == 'e') ? $obj[0] : null,
                    'rsg_nombre' => $post['txtNombre'],
                    'rsg_consecuencia' => $post['txtConsecuencia'],
                    'rsg_propuesta' => $post['txtPropuesta'],
                    'rsg_fecha_inicio_prop' => formatear_fecha('Y-m-d', $post['txtFechaInicio']),
                    'rsg_fecha_fin_prop' => formatear_fecha('Y-m-d', $post['txtFechaFin']),
                    'rsg_estado' => 1,////////////////////////////////////////////////////////////////// falta select estado pdte si llevara o no
                    'rsg_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'rsg_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $id_rsg = $this->gsatelite->actualizar_array('rsg_riesgos', $riesgo, array('rsg_id' => $rsg_id));
                $ids_fxr = $this->gsatelite->get_tabla('fxr_factoresxriesgo', array('fxr_id_rsg' => $rsg_id));
                foreach ($ids_fxr as $k => $val) {
                    if (!(in_array($val['fxr_id'], $post['ids_fxr']))) {
                        $this->gsatelite->borrado_general('fxr_factoresxriesgo', array('fxr_id' => $val['fxr_id']));
                    }
                }
                for ($i = 0; $i < count($post['ids_fxr']); $i++) {
                    $factor = array(
                        'fxr_id_rsg' => $rsg_id,
                        'fxr_id_fae' => ($post['tipo_fac'][$i] == 1) ? $post['ids_fac'][$i] : null,
                        'fxr_id_fai' => ($post['tipo_fac'][$i] == 2) ? $post['ids_fac'][$i] : null,
                        'fxr_descripcion' => $post['desc_fac'][$i],
                        'fxr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'fxr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    if ($post['ids_fxr'][$i] > 0) {
                        $this->gsatelite->actualizar_array('fxr_factoresxriesgo', $factor, array('fxr_id' => $post['ids_fxr'][$i]));
                    } else {
                        $factor['fxr_usu_creacion'] = $this->tank_auth->get_user_id(); 
                        $factor['fxr_fecha_creacion'] = date('Y-m-d H:i:s');
                        $this->gsatelite->ingresar('fxr_factoresxriesgo', $factor);
                    }
                }
                $inr_fxr = $this->gsatelite->get_tabla('inr_indicador_riesgo', array('inr_id_rsg' => $rsg_id));
                foreach ($inr_fxr as $k => $val) {
                    if (!(in_array($val['inr_id'], $post['inr_ids']))) {
                        $this->gsatelite->borrado_general('inr_indicador_riesgo', array('inr_id' => $val['inr_id']));
                    }
                }
                foreach ($post['indicadores'] as $k => $value) {
                    $indicador = array(
                        'inr_id_rsg' => $rsg_id,
                        'inr_nombre' => $value,
                        'inr_estado' => 1,
                        'inr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'inr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    if ($post['inr_ids'][$k] > 0) {
                        $this->gsatelite->actualizar_array('inr_indicador_riesgo', $indicador, array('inr_id' => $post['inr_ids'][$k]));
                    } else {
                        $indicador['inr_usu_creacion'] = $this->tank_auth->get_user_id(); 
                        $indicador['inr_fecha_creacion'] = date('Y-m-d H:i:s');
                        $this->gsatelite->ingresar('inr_indicador_riesgo', $indicador);
                    }
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Riesgos registro", 'texto_alerta' => "El registro se actualizó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "No se pudo actualizar el registro", 'texto_alerta' => "Corrobore los datos y vuelva a intentar");
            }
            $this->session->set_flashdata($alerta);
            if ($post['btnCrear'] > 0) {
                redirect('modulo_planificacion/pla_riesgos/riesgos/' . $mai_id . '/'. $are_id);
            } else {
                redirect('modulo_planificacion/pla_riesgos/viedit_riesgo/' . $post['slcMatUnidad'] . '/'. $post['slcAreaMatriz'] . '/' . $rsg_id);
            }
        } else {
            $dato_rsg = $this->gsatelite->get_tabla('rsg_riesgos', array('rsg_id' => $rsg_id));
            $ctrl_act = $this->gsatelite->get_campo('evt_evaluacion_riesgo_total', 'evt_id_cac'. array('evt_id' => $dato_rsg[0]['rsg_id_evt']));
            $mxu = $this->gsatelite->get_registro('mxu_matrizxunidad', array('mxu_id' => $dato_rsg[0]['rsg_id_mxu']));
            $select_mai = $this->gsatelite->get_dropdown('mai_matriz_riesgo', '{mai_nombre}', '', array('mai_estado' => 1), $mxu->mxu_id_mai, '', 'mai_id', true);
            $select_clr = $this->gsatelite->get_dropdown('clr_clasificacion_riesgo', '{clr_nombre}', '', array('clr_estado' => 1), $dato_rsg[0]['rsg_id_clr'], '', 'clr_id', true);
            $select_imr1 = $this->gsatelite->get_dropdown('imr_impacto_riesgo', '{imr_nombre}', '', array('imr_estado' => 1), $dato_rsg[0]['rsg_id_imr_pre_control'], '', 'imr_id', true);
            $select_imr2 = $this->gsatelite->get_dropdown('imr_impacto_riesgo', '{imr_nombre}', '', array('imr_estado' => 1), $dato_rsg[0]['rsg_id_imr_post_control'], '', 'imr_id', true);
            $select_prb1 = $this->gsatelite->get_dropdown('prb_probabilidad_riesgo', '{prb_nombre}', '', array('prb_estado' => 1), $dato_rsg[0]['rsg_id_prb_pre_control'], '', 'prb_id', true); 
            $select_prb2 = $this->gsatelite->get_dropdown('prb_probabilidad_riesgo', '{prb_nombre}', '', array('prb_estado' => 1), $dato_rsg[0]['rsg_id_prb_post_control'], '', 'prb_id', true); 
            $select_cac = $this->gsatelite->get_dropdown('cac_control_actual', '{cac_nombre}', '', array('cac_estado' => 1), $ctrl_act->evt_id_cac, '', 'cac_id', true);
            $tipo_obj = ($dato_rsg[0]['rsg_id_obo'] != "") ? 'o' : 'e';
            $obj_slctd = ($dato_rsg[0]['rsg_id_obo'] != "") ? $dato_rsg[0]['rsg_id_obo'] : $dato_rsg[0]['rsg_id_obe'];
            $data['ver'] = $ver;
            $data['objtype'] = $tipo_obj;
            $data['flt_id_mai'] = $mai_id;
            $data['flt_id_are'] = $are_id;
            $data['datos'] = $dato_rsg[0];
                                      $this->db->join('fai_factor_interno', 'fai_id = fxr_id_fai', 'LEFT'); 
                                      $this->db->join('fae_factor_externo', 'fae_id = fxr_id_fae', 'LEFT'); 
            $data['tabla_factores'] = $this->gsatelite->get_tabla('fxr_factoresxriesgo', array('fxr_id_rsg' => $rsg_id)); 
            $data['areas_rsg'] = $this->get_areas_por_matriz($mxu->mxu_id_mai, $mxu->mxu_id_are);
            $data['objetivos_rsg'] = $this->get_objetivos_mxu($mxu->mxu_id_mai, $mxu->mxu_id_are, $tipo_obj, $obj_slctd);
            $data['responsable_rsg'] = $this->get_responsable_obj($mxu->mxu_id_are, $obj_slctd, $tipo_obj, $dato_rsg[0]['rsg_id_plz']);

            $data['impacto_antes'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select_imr1);
            $data['impacto_despues'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select_imr2);
            $data['probabilidad_antes'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select_prb1);
            $data['probabilidad_despues'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select_prb2);
            $data['controles_act'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select_cac);
            
            $data['matriz_riesgo'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select_mai);
            $data['clasificacion'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select_clr);
            $data['tabla_indicador']= $this->gsatelite->get_tabla('inr_indicador_riesgo', array('inr_estado' => 1, 'inr_id_rsg' => $rsg_id));
            $data['titulo_personal'] = ($ver) ? "Ver Riesgo" : "Editar Riesgo";
            cargarvista($data);
        }
    }

    public function get_areas_por_matriz($id_matriz = null, $selected = null){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        }
        $mai = ($id_matriz) ? $id_matriz : $this->input->post('matriz');
        //SI NO POSEE EL ROL DE JEFE DE UNIDAD SOLO SE LE MOSTRARA SU AREA
        $autorizado_ver  = false;
        $autorizar_array = explode(",", $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD'));
        $roles_array     = $this->gsatelite->get_tabla("uxr_usuarioxrol", array("uxr_id_usu" => $this->tank_auth->get_user_id()));
        foreach ($roles_array as $r) {
            if (in_array($r["uxr_id_rol"], $autorizar_array)) {
                $autorizado_ver = true;
            }
        }
        $where = array('are_estado' => 1, 'mxu_id_mai' => $mai);
        if (!$autorizado_ver) {
            $datos = $this->plan_operativo_model->get_informacion_empleado($this->tank_auth->get_user_id());
            $area_user = (count($datos) > 0) ? $datos[0]['are_id'] : 0;
            $area_user = (is_numeric($area_user)) ? $area_user : 0;
            $where['mxu_id_are'] = $area_user;
        }
                $this->db->join('mxu_matrizxunidad', 'mxu_id_are = are_id');
        $opts = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', $where, $selected, '', 'are_id', true);
        if ($id_matriz) {
            return str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $opts);
        } else {
            echo str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $opts);
        }
    }

    public function get_objetivos_mxu($id_matriz = null, $id_area = null, $tipo = null, $slctd = 0){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        }
        $are = ($id_area) ? $id_area : $this->input->post('area');
        $mai = ($id_matriz) ? $id_matriz : $this->input->post('matriz');
        $select = '<option value=""></option>';
        $year   = $this->gsatelite->get_campo('mai_matriz_riesgo', 'mai_anio', array('mai_id' => $mai));
        $datos  = $this->plan_operativo_model->get_objetivos_riesgos_pei_poa($year, $are);
        foreach ($datos as $k => $v) {
            $slcd = ($v['tipo_ob'] == $tipo && $v['id_ob'] == $slctd) ? "selected" : "";
            $select .= '<option value="' . $v['id_ob'] . '_' . $v['tipo_ob'] . '" data-tipo="' . $v['tipo_ob'] . '" ' . $slcd . ' >' . $v['name_ob'] . '</option>';
        }
        if ($tipo) {
            return $select;
        } else {
            echo $select;
        }
    }

    public function get_responsable_obj($id_area = null, $id_objet = null, $tipo = null, $slctd = null){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        }
        $are = ($id_area) ? $id_area : $this->input->post('area');
        $obj = ($id_objet) ? $id_objet : $this->input->post('objetivo');
        $typ = ($tipo) ? $tipo : $this->input->post('tipo');
        $obj_val = explode('_', $obj);
        $id_objt = $obj_val[0];
        $where = array();
        if ($typ == 'e') {
            $plzs_pei = $this->plan_operativo_model->get_involucrados_act_pei($id_objt);
            $permitidas = (count($plzs_pei) > 0) ? array_column($plzs_pei, 'plaza') : array(0);
        }elseif ($typ == 'o') {
            $plzs_poa = $this->plan_operativo_model->get_involucrados_act_poa(array('ino_id_obo' => $id_objt));
            $permitidas = (count($plzs_poa) > 0) ? array_column($plzs_poa, 'plaza') : array(0);
        }
                $this->db->where_in("plz_id", $permitidas);
                $this->db->join("pto_puesto", "pto_id = plz_id_pto", "inner");
        $opts = $this->gsatelite->get_dropdown("plz_plaza", "{pto_nombre} - {plz_nombre}", "", array("plz_estado" => 1), $slctd, "", "plz_id", true);
        if ($id_area) {
            return str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $opts);
        } else {
            echo str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $opts);
        }
    }

    public function get_evaluacion_riesgo(){
        $imp = $this->input->post('impact');
        $prb = $this->input->post('probab');
        $color = $this->gsatelite->get_tabla('evr_evaluacion_riesgo', array('evr_estado' => 1, 'evr_id_imr' => $imp, 'evr_id_prb' => $prb));
        echo json_encode(array('filas' => count($color), 'id' => $color[0]['evr_id'], 'texto' => $color[0]['evr_nombre'], 'color' => $color[0]['evr_color_alerta']));
    }

    public function get_evaluacion_riesgo_final(){
        $ctrls_act = $this->input->post('ctrl');
        $evr_antes = $this->input->post('antes');
        $evr_despu = $this->input->post('despues');
        $color = $this->gsatelite->get_tabla('evt_evaluacion_riesgo_total', array('evt_estado' => 1, 'evt_id_cac' => $ctrls_act, 'evt_id_evr_antes' => $evr_antes, 'evt_id_evr_despues' => $evr_despu));
        echo json_encode(array('filas' => count($color), 'id' => $color[0]['evt_id'], 'texto' => $color[0]['evt_nombre'], 'color' => $color[0]['evt_color_alerta']));
    }

    public function get_factores($tipo_fact = null)    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        }
        $tipo = ($tipo_fact) ? $tipo_fact : $this->input->post('tipo');
        if ($tipo == 1) { //externo 
            $opts = $this->gsatelite->get_dropdown('fae_factor_externo', '{fae_nombre}', '', array('fae_estado' => 1), null, '', 'fae_id', true);
        }elseif ($tipo == 2) { //interno
            $opts = $this->gsatelite->get_dropdown('fai_factor_interno', '{fai_nombre}', '', array('fai_estado' => 1), null, '', 'fai_id', true);
        }
        if ($tipo_fact) {
            return str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $opts);
        } else {
            echo str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $opts);
        }
    }

    public function seguimiento_riesgo($matriz = 0, $area = 0){
        satelite_validar();
        $where = $mai_id = $plan_area = null;
        $registro = $mxus = array();
        if ($_POST) {
            $post_array = $this->input->post();
            if ($post_array['slcMatriz'] > 0) {
                $where['mai_id'] = $post_array['slcMatriz'];
            }
            if ($post_array['slcArea'] > 0) {
                $where['are_id'] = $post_array['slcArea'];
            }
        } else {
            if ($matriz > 0) {
                $where['mai_id'] = $matriz;
            }
            if ($area > 0) {
                $where['are_id'] = $area;
            }
        }
        if ($where) {
            $mxus = $this->plan_operativo_model->get_riesgos($where, 1);
        }        
        if (count($mxus) > 0) {
            $registro = $mxus;
            $mai_id = $mxus[0]['mai_id'];
            if ($post_array['slcArea'] > 0 || $area > 0) {
                $plan_area['are_id'] = $mxus[0]['are_id'];
                $plan_area['are_nombre'] = $mxus[0]['are_nombre'];
            }
        }
        $matriz_riesgo = $this->gsatelite->get_dropdown('mai_matriz_riesgo', '{mai_nombre}', '', array('mai_estado' => 1), $mai_id, '', 'mai_id', true);
        $data['matriz'] = $mai_id;
        $data['plan_area'] = $plan_area;
        $data['filas_consulta'] = $registro;
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();    
        $data['matrices'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $matriz_riesgo);
        $data['titulo_personal'] = "Tratamiento Riesgos";
        cargarvista($data);
    }

    public function get_codigo_riesgo($return = null, $matriz_rgo = null, $departamento = null, $tipo_obj = null){
        $codigo = "";
        $mair = ($matriz_rgo) ? $matriz_rgo : $this->input->post('matriz');
        $area = ($departamento) ? $departamento : $this->input->post('area_mat');
        $tipo = ($tipo_obj) ? $tipo_obj : $this->input->post('tipo_obj');
        $mxu = $this->gsatelite->get_campo('mxu_matrizxunidad', 'mxu_id', array('mxu_id_are' => $area, 'mxu_id_mai' => $mair));
        $where['rsg_id_mxu'] = $mxu;
        if ($tipo == 'o') {
            $codigo .= "RO";
            $where['rsg_id_obo IS NOT NULL'] = null;
        }elseif ($tipo == 'e') {
            $codigo .= "RE";
            $where['rsg_id_obe IS NOT NULL'] = null;
        }
        $cantidad = ($this->gsatelite->count('rsg_riesgos', $where) + 1);
        $codigo .= str_pad($cantidad, 4, "0", STR_PAD_LEFT);
        if ($return) {
            return $codigo;
        } else {
            echo json_encode(array('codigo' => $codigo));
        }        
    }

    public function segtra_riesgo($mai_id = 0, $are_id = 0, $rsg_id = 0, $sgr_id = 0){  
        satelite_validar();
        if ($sgr_id > 0) {
                          $this->db->join('sgu_seguimiento_resumen', 'sgu_id = sgr_id_sgu');
            $seg_riesgo = $this->gsatelite->get_tabla('sgr_seguimiento_riesgo', array('sgr_id' => $sgr_id))[0];
        } else {
            $seg_riesgo = array();
        }
        if ($_POST) {
            // var_dump($_POST);die();
            $post = $this->input->post();
            $riesgo = $this->gsatelite->get_tabla('rsg_riesgos', array('rsg_id' => $rsg_id))[0];
            $flujos = json_decode($this->gsatelite->get_parametro('SYS_FLUJO_PLANIFICACION'), true);
            $id_flujo = $flujos['RIESGO']['SEGUIMIENTO'];
            if ($seg_riesgo['sgu_id'] > 0) {
                $sgu_id = $seg_riesgo['sgu_id'];
                $sgu_array = array(
                    'sgu_observacion' => $post['txt_observ'],
                    'sgu_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sgu_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('sgu_seguimiento_resumen', $sgu_array, array('sgu_id' => $sgu_id));
            } else {
                $sgu_array = array(
                    'sgu_id_flu' => $id_flujo,
                    'sgu_id_mxu' => $post['hdn_mxu'],
                    'sgu_observacion' => $post['txt_observ'],
                    'sgu_fecha' => date('Y-m-d H:i:s'),
                    'sgu_estado' => 1,
                    'sgu_usu_creacion' => $this->tank_auth->get_user_id(),
                    'sgu_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sgu_fecha_creacion' => date('Y-m-d H:i:s'),
                    'sgu_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $sgu_id = $this->gsatelite->ingresar('sgu_seguimiento_resumen', $sgu_array);
            }
            if ($sgu_id > 0) {
                if ($sgr_id > 0) {
                    $sgr_array = array(
                        'sgr_id_sgu' => $sgu_id,
                        'sgr_id_rsg' => $rsg_id,
                        'sgr_id_rsd' => $post['slc_residual'],
                        'sgr_estado' => 1,
                        'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sgr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('sgr_seguimiento_riesgo', $sgr_array, array('sgr_id' => $sgr_id));
                } else {
                    $sgr_array = array(
                        'sgr_id_sgu' => $sgu_id,
                        'sgr_id_rsg' => $rsg_id,
                        'sgr_id_rsd' => $post['slc_residual'],
                        'sgr_id_imr' => $post['hdn_imr'],
                        'sgr_id_prb' => $post['hdn_prb'],
                        'sgr_acciones_cont' => $riesgo['rsg_propuesta'],
                        'sgr_fecha_inicio' => formatear_fecha('Y-m-d', $riesgo['rsg_fecha_inicio_prop']),
                        'sgr_fecha_final' => formatear_fecha('Y-m-d', $riesgo['rsg_fecha_fin_prop']),
                        'sgr_estado' => 1,
                        'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sgr_fecha_creacion' => date('Y-m-d H:i:s'),
                        'sgr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $sgr_id = $this->gsatelite->ingresar('sgr_seguimiento_riesgo', $sgr_array);
                }
                $this->gsatelite->borrado_general('ixs_indicadoresxseguimiento', array('ixs_id_sgr' => $sgr_id));
                foreach ($post['id_ixs'] as $k => $val) {
                    $ixs_array = array(
                        'ixs_id_sgr' => $sgr_id, 
                        'ixs_id_inr' => $post['indicador'][$k],
                        'ixs_id_stl' => $post['estado'][$k],
                        'ixs_fecha_accion_seguimiento' => ($post['fecha_logro'][$k] != "") ? formatear_fecha('Y-m-d', $post['fecha_logro'][$k]) : null,
                        'ixs_fecha_seguimiento' => date('Y-m-d H:i:s'),
                        'ixs_limitaciones' => (trim($post['limitante'][$k]) != "") ? trim($post['limitante'][$k]) : null,
                        'ixs_logros_obtenidos' => (trim($post['logros'][$k]) != "") ? trim($post['logros'][$k]) : null,
                        'ixs_porcentaje_ind' => $post['porc'][$k],
                        'ixs_estado' => 1,
                        'ixs_usu_creacion' => $this->tank_auth->get_user_id(),
                        'ixs_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'ixs_fecha_creacion' => date('Y-m-d H:i:s'),
                        'ixs_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('ixs_indicadoresxseguimiento', $ixs_array);
                }
                $ruta_anexos = $post['ruta'];
                $titulo_anexo = $post['titulo_doc'];
                if (!empty($ruta_anexos)) {
                    for ($i = 0; $i < count($ruta_anexos); $i++) {
                        $extension = end(explode('.', $ruta_anexos[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($ruta_anexos[$i]);
                        $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                        $carpeta_destino_anx = "uploads/anx_seguim_riesgos/" . $nombreArchivo;
                        $dir = $this->gsatelite->get_tabla('ans_anexo_seguim_riesgo', array('ans_url' => $carpeta_destino_anx, 'ans_estado' => 1));
                        if (!(count($dir) > 0)) {
                            $documentos_array = array(
                                'ans_id_sgr'             => $sgr_id,
                                'ans_url'                => $carpeta_destino_anx,
                                'ans_nombre'             => $nombreArchivo,
                                'ans_estado'             => 1,
                                'ans_usu_creacion'       => $this->tank_auth->get_user_id(),
                                'ans_fecha_creacion'     => date('Y-m-d H:i:s'),
                                'ans_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                'ans_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $anh_id = $this->gsatelite->ingresar('ans_anexo_seguim_riesgo', $documentos_array);
                            if ($anh_id > 0) {
                                copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                unlink($carpeta_temporal_anx);
                            }
                        }
                    }
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tratamiento Riesgos", 'texto_alerta' => "El registro se procesó exitosamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "No se pudo procesar el registro", 'texto_alerta' => "Ocurrió un error. Favor corroborar los datos");
            }
            if ($post['btnCrear'] > 0) {
                redirect('modulo_planificacion/pla_riesgos/seguimiento_riesgo/' . $mai_id . '/'. $are_id);
            } else {
                redirect('modulo_planificacion/pla_riesgos/segtra_riesgo/' . $mai_id . '/'. $are_id . '/' . $rsg_id . '/' . $sgr_id);
            }
            
        } else {
            $data['flt_id_sgr'] = $sgr_id;
            $data['flt_id_mai'] = $mai_id;
            $data['flt_id_are'] = $are_id;
            $datos_rsg = $this->plan_operativo_model->get_seguim_riesgos(array('rsg_id' => $rsg_id));
            $select_rsd = $this->gsatelite->get_dropdown('rsd_riesgo_residual', '{rsd_nombre}', '', array('rsd_estado' => 1), $seg_riesgo['sgr_id_rsd'], '', 'rsd_id', true);
            $select_lgr = $this->gsatelite->get_dropdown('stl_estado_logro', '{stl_nombre}', '', array('stl_estado' => 1), null, '', 'stl_id', true);
            $tipo_obj = ($datos_rsg[0]['rsg_id_obo'] != "") ? 'o' : 'e';
            $data['objtype'] = $tipo_obj;
            $data['edicion'] = $seg_riesgo;
            $data['datos'] = $datos_rsg[0];
            $tbl_indi = $this->plan_operativo_model->get_avance_seguim_riesgo(array('inr_estado' => 1, 'inr_id_rsg' => $rsg_id));
            $slct_indicador = '<option value=""></option>';
            foreach ($tbl_indi as $k => $v) {
                $slct_indicador .= '<option value="'.$v['inr_id'].'" data-avance="'.$v['avance'].'" >'.$v['inr_nombre'].'</option>';
            }
            $data['tbl_ixs_acts'] = $tbl_indi;
            $data['rsg_residual'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select_rsd);
            $data['estado_logro'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select_lgr);
            $data['anx'] = $this->gsatelite->get_tabla('ans_anexo_seguim_riesgo', array('ans_id_sgr' => $sgr_id, 'ans_estado' => 1));
            $data['tabla_indicador'] = $slct_indicador;
            $data['titulo_personal'] = "Tratamiento del Riesgo";
            cargarvista($data);
        }        
    }

}