<?php
/**
 * Created by PhpStorm.
 * User: mario.marquez
 * Date: 2/7/2020
 * Time: 13:49
 */


if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Pla_reporte_poa extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('plan_estrategico_model');
        $this->load->model('plan_operativo_model');
        $this->load->library('texto');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
    }

    /**
     * Descripción:
     * Función para la vista index
     * @author Mario Marquez - Grupo Satélite
     * @since 2020-01-24
     */
    public function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function formulacion_poa(){
        satelite_validar();
        $data['permiso_ver'] = $this->gsatelite->get_permisos_opcion('modulo_planificacion/pla_reporte_poa/formulacion_poa', 'ver', null, true);
        $select = $this->gsatelite->get_dropdown('poa_plan_operativo', '{poa_nombre}', '', array('poa_estado' => '1'), null, '', 'poa_id', true);
        $data['plan_operativo'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);
        $data['titulo_personal'] = "Reporte Formulación POA";
        cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */
    function reporte_formulacion_poa($flag = null) {
        if ($this->input->post()) {
            $post_array = $this->input->post();
            // var_dump($post_array);die();
            /* Si es consulta ajax se toman los nombres del Jquery De lo contrario, se toman los filtros de impresión */
            $plan_operativo = null;
            $area = null;
            $plan_split = null;
            $area_split = null;
            if ($flag == 1) {
                $plan_operativo = ($post_array['plan_operativo'] != '') ? $post_array['plan_operativo'] : null;
                $area = ($post_array['area'] != '') ? $post_array['area'] : null;
            } else {
                /* Los valores de filtro vienen concatenados junto a tu texto i.e. Estado = "1#Creado". Se separan los filtros */
                $plan_split = ($post_array['filtro_plan'] != '') ? explode("#", $post_array['filtro_plan']) : null;
                $area_split = ($post_array['filtro_area'] != '') ? explode("#", $post_array['filtro_area']) : null;
                //Se asignan los valores de filtro
                $plan_operativo = $plan_split[0];
                $data['nombrePlan'] = $plan_split[1];
                $area = $area_split[0];
                $data['nombreArea'] = $area_split[1];
                //si no viene de esa manera se toman los valores como en el ajax
                $plan_operativo = ($plan_operativo) ? $plan_operativo : $post_array['slcPlanOperativo'];
                $area = ($area) ? $area : $post_array['slcArea'];
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = (isset($post_array['tipo_reporte'])) ? $post_array['tipo_reporte']: null;
            //SI NO POSEE EL ROL DE JEFE DE UNIDAD SOLO SE MOSTRARAN LAS DE SU AREA
            $autorizado_ver  = false;
            $autorizar_array = explode(",", $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD'));
            $roles_array     = $this->gsatelite->get_tabla("uxr_usuarioxrol", array("uxr_id_usu" => $this->tank_auth->get_user_id()));
            foreach ($roles_array as $r) {
                if (in_array($r["uxr_id_rol"], $autorizar_array)) {
                    $autorizado_ver = true;
                }
            } 
            $where = null;
            if ($plan_operativo) {
                $where['poa_id'] = $plan_operativo;
            }
            if ($area) {
                $where['pxu_id_are'] = $area;
            }
            if (!$autorizado_ver) {
                $datos = $this->plan_operativo_model->get_informacion_empleado($this->tank_auth->get_user_id());
                $area_user = (count($datos) > 0) ? $datos[0]['are_id'] : 0;
                $area_user = (is_numeric($area_user)) ? $area_user : 0;
                $where['pxu_id_are'] = $area_user;
            }
                            $this->db->order_by('obo_id, ino_id, met_id ASC');
            $filas_report = $this->plan_operativo_model->get_metas_operativas($where);
            // print_r($this->db->last_query());die();
            $data['are_nombre'] = ($area) ? $this->gsatelite->get_campo("are_area", "are_nombre", array('are_id' => $area)) : "Todas";
            $data['tipo_reporte'] = $tipo_reporte;
            $data['reporte'] = $filas_report;
            $filename = 'rpt_formulacion_poa_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('modulo_planificacion/pla_reporte_poa/reporte_formulacion_poa', $data, true);
            if ($flag) {
                echo json_encode(array('tabla' => $html, 'puede_ver' => $autorizado_ver, 'ctdad' => count($filas_report)));
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Formulación POA';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_Formulacion_POA_' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Formulacion_POA', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    echo $html;
                }
            }
        }
    }

    function cumplimiento_actividad(){
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        $select = $this->gsatelite->get_dropdown('poa_plan_operativo', '{poa_nombre}', '', array('poa_estado' => '1'), null, '', 'poa_id', true);
        $data['plan_operativo'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);
        $data['titulo_personal'] = "Reporte Cumplimiento Actividades";
        cargarvista($data);
    }

    public function reporte_cumplimiento_actividad(){
        if ($this->tank_auth->is_logged_in()) {
            $poa = $_POST['slcPlanOperativo'];
            $are = $_POST['slcArea'];
            $fini = $_POST['fecha_ini'];
            $ffin = $_POST['fecha_fin'];
            $where["poa_id"] = $poa;
            if ($are > 0) {
                $where["pxu_id_are"] = $are;
            }
            if ($fini != "" && $ffin != "") {
                $codigos = "0";
                $ini = formatear_fecha('Y-m-d', '01-' . $fini);
                $fin = formatear_fecha('Y-m-d', '01-' . $ffin);
                if ($ini != $fin) {
                    $f1 = new DateTime($ini);
                    $f2 = new DateTime($fin);
                    $d = $f1->diff($f2);
                    $difmes =  $d->format('%m');
                    $impf = $f1;
                    $codigos = formatear_fecha('Ym', $ini) . ',';
                    for($i = 1; $i <= $difmes; $i++){
                        $impf->add(new DateInterval('P1M'));
                        $m = $impf->format('d-m-Y');
                        $codigos .= formatear_fecha('Ym', $m);
                        $codigos .= ($i == $difmes) ? '' : ',';
                    }
                } else {
                    $codigos = formatear_fecha('Ym', $ini);
                }
                $where["per_codigo IN ($codigos)"] = null;
            }
            $data['are_nom'] = ($are > 0) ? $this->gsatelite->get_campo('are_area', 'are_nombre', array('are_id' => $are)) : 'Todas las Áreas';
            $data['fec_ini'] = $fini;
            $data['fec_fin'] = $ffin;
            $data['headers'] = $this->load->view('reporte/header_cons', array("solotitulo" => true), true);
            $data['reporte'] = $this->plan_operativo_model->get_actividades_realizadas($where);
            $html = $this->load->view('modulo_planificacion/pla_reporte_poa/reporte_cumplimiento_actividad', $data);
        } else {
            redirect('/auth/login/');
        }        
    }

    /* SE ELIMINA LA OPCION POR CREARSE REPORTE QUE LO ABSORBE SAT 7305 */
    /*
    function seguimiento_poa(){
        satelite_validar();
        $select = $this->gsatelite->get_dropdown('poa_plan_operativo', '{poa_nombre}', '', array('poa_estado' => '1'), null, '', 'poa_id', true);
        $data['plan_operativo'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);
        $data['titulo_personal'] = "Reporte Seguimiento Mensual POA";
        cargarvista($data);
    }
    // @author: Mario Marquez // $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
    function reporte_seguimiento_poa($flag = null) {
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //var_dump($post_array);die();
            // Si es consulta ajax se toman los nombres del Jquery De lo contrario, se toman los filtros de impresión
            $plan_operativo = null;
            $area = null;
            $plan_split = null;
            $area_split = null;
            if ($flag == 1) {
                $plan_operativo = ($post_array['plan_operativo'] != '') ? $post_array['plan_operativo'] : null;
                $area = ($post_array['area'] != '') ? $post_array['area'] : null;
            } else {
                // Los valores de filtro vienen concatenados junto a tu texto i.e. Estado = "1#Creado" Se separan los filtros
                $plan_split = ($post_array['filtro_plan'] != '') ? explode("#", $post_array['filtro_plan']) : null;
                $area_split = ($post_array['filtro_area'] != '') ? explode("#", $post_array['filtro_area']) : null;
                //Se asignan los valores de filtro
                $plan_operativo = $plan_split[0];
                $data['nombrePlan'] = $plan_split[1];
                $area = $area_split[0];
                $data['nombreArea'] = $area_split[1];
                $plan_operativo = ($plan_operativo) ? $plan_operativo : $post_array['slcPlanOperativo'];
                $area = ($area) ? $area : $post_array['slcArea'];
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = (isset($post_array['tipo_reporte'])) ? $post_array['tipo_reporte']: null;
            $where = null;
            if ($plan_operativo) {
                $where['poa_id'] = $plan_operativo;
            }
            if ($area) {
                $where['pxu_id_are'] = $area;
            }
            $data['reporte'] = $this->plan_operativo_model->get_metas_operativas($where);
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_formulacion_poa_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('modulo_planificacion/pla_reporte_poa/reporte_seguimiento_poa', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Seguimiento POA';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_Seguimiento_POA_' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Seguimiento_POA', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_seguimiento_poa_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Formulación POA';
                    $data['filename'] = $filename;
                    echo $html;
                }
            }
        }
    }
    */

    function resumen_actividades(){
        satelite_validar();

        $select = $this->gsatelite->get_dropdown('poa_plan_operativo', '{poa_nombre}', '', array('poa_estado' => '1'), null, '', 'poa_id', true);
        $data['plan_operativo'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);

        $data['titulo_personal'] = "Reporte Resumen de Actividades POA";
        cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */

    function reporte_resumen_actividades($flag = null) {
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //var_dump($post_array);die();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            $plan_operativo = null;
            $area = null;
            $plan_split = null;
            $area_split = null;

            if ($flag == 1) {
                $plan_operativo = ($post_array['plan_operativo'] != '') ? $post_array['plan_operativo'] : null;
                $area = ($post_array['area'] != '') ? $post_array['area'] : null;
            } else {

               $plan_operativo = ($post_array['slcPlanOperativo'] != '') ? $post_array['slcPlanOperativo'] : null;
               $area = ($post_array['slcArea'] != '') ? $post_array['slcArea'] : null;
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = (isset($post_array['tipo_reporte'])) ? $post_array['tipo_reporte']: null;

            $where = null;

            if ($plan_operativo) {
                $where['poa_id'] = $plan_operativo;
            }
            if ($area) {
                $where['pxu_id_are'] = $area;
            }

            $data['reporte'] = $this->plan_operativo_model->get_resumen_actividades_poa($where);

            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_resumen_actividades_poa_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;
            $html = $this->load->view('modulo_planificacion/pla_reporte_poa/reporte_resumen_actividades', $data, true);

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Resumen Actividades POA';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Resumen_Actividades_POA_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Resumen_Actividades_POA', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_Resumen_Actividades_poa_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Resumen Actividades POA';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

     public function cumplimiento_mensual(){
        satelite_validar();
        $data['permiso_ver'] = $this->gsatelite->get_permisos_opcion('modulo_planificacion/pla_reporte_poa/cumplimiento_mensual', 'ver', null, true);
        $select = $this->gsatelite->get_dropdown('poa_plan_operativo', '{poa_nombre}', '', array('poa_estado' => '1'), null, '', 'poa_id', true);
        $data['plan_operativo'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);
        $data['titulo_personal'] = "Cumplimiento Mensual";
        cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */
    function reporte_cumplimiento_mensual($flag = null) {
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //var_dump($post_array);die();
            /* i es consulta ajax se toman los nombres del Jquery De lo contrario, se toman los filtros de impresión */
            $plan_operativo = null;
            $area = null;
            $mes = null;
            $plan_split = null;
            $area_split = null;
            if ($flag == 1) {
                $plan_operativo = ($post_array['plan_operativo'] != '') ? $post_array['plan_operativo'] : null;
                $area = ($post_array['area'] != '') ? $post_array['area'] : null;
            } else {
                $plan_operativo = ($post_array['slcPlanOperativo'] != '') ? $post_array['slcPlanOperativo'] : null;
                $area = ($post_array['slcArea'] != '') ? $post_array['slcArea'] : null;
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = (isset($post_array['tipo_reporte'])) ? $post_array['tipo_reporte']: null;
            $where = null;
            // $data['poa'] = $this->plan_operativo_model->get_planes_operativos_unidad(array('pxu_id_poa' => $plan_operativo))[0];
            if ($plan_operativo) {
                $where['poa_id'] = $plan_operativo;
            }
            if ($area) {
                $where['pxu_id_are'] = $area;
            }
                               $this->db->order_by('obo_id, ino_id, are_id ASC');
            $data['reporte'] = $this->plan_operativo_model->get_indicadores_operativos($where);
            $data['are_nombre'] = ($area) ? $this->gsatelite->get_campo("are_area", "are_nombre", array('are_id' => $area)) : "Todas";
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_cumplimiento_mensual_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('modulo_planificacion/pla_reporte_poa/reporte_cumplimiento_mensual', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Cumplimiento Mensual';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_Cumplimiento_Mensual_' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Cumplimiento_Mensual', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    echo $html;
                }
            }
        }
    }
}