<?php
/**
 * Created by PhpStorm.
 * User: mario.marquez
 * Date: 2/7/2020
 * Time: 13:49
 */


if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Pla_reporte_pei extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('plan_estrategico_model');
        $this->load->model('plan_operativo_model');
        $this->load->library('texto');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
    }

    /**
     * Descripción:
     * Función para la vista index
     * @author Mario Marquez - Grupo Satélite
     * @since 2020-01-24
     */
    public function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function formulacion_pei(){
        satelite_validar();
        $data['permiso_ver'] = $this->gsatelite->get_permisos_opcion('modulo_planificacion/pla_reporte_pei/formulacion_pei', 'ver', null, true);
        $select = $this->gsatelite->get_dropdown('pes_plan_estrategico', '{pes_nombre}', '', array('pes_estado' => '1'), null, '', 'pes_id', true);
        $data['plan_estrategico'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);
        $data['titulo_personal'] = "Reporte Formulación PEI";
        cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */
    function reporte_formulacion_pei($flag = null) {
        if ($this->input->post()) {
            $post_array = $this->input->post();
            // var_dump($post_array);die();
            if ($flag) {
                $plan_operativo = ($post_array['plan'] != '') ? $post_array['plan'] : null;
                $flt_pie = ($post_array['pie'] != '') ? $post_array['pie'] : null;
                $flt_obe = ($post_array['obe'] != '') ? $post_array['obe'] : null;
                $flt_aca = ($post_array['aca'] != '') ? $post_array['aca'] : null;
                $flt_aco = ($post_array['aco'] != '') ? $post_array['aco'] : null;
            } else {
                $plan_operativo = ($post_array['slcPlan'] != '') ? $post_array['slcPlan'] : null;
                $flt_pie = ($post_array['slc_pie'] != '') ? $post_array['slc_pie'] : null;
                $flt_obe = ($post_array['slc_obe'] != '') ? $post_array['slc_obe'] : null;
                $flt_aca = ($post_array['slc_aca'] != '') ? $post_array['slc_aca'] : null;
                $flt_aco = ($post_array['slc_aco'] != '') ? $post_array['slc_aco'] : null;
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = (isset($post_array['tipo_reporte'])) ? $post_array['tipo_reporte'] : null;
            $where = null;
            if ($plan_operativo) {
                $where['pes_id'] = $plan_operativo;
            }
            if ($flt_pie) {
                $where['pie_id'] = $flt_pie;
            }
            if ($flt_obe) {
                $where['obe_id'] = $flt_obe;
            }
            if ($flt_aca) {
                $where['aca_id'] = $flt_aca;
            }
            if ($flt_aco) {
                $where['aco_id'] = $flt_aco;
            }
            $data['pilares'] = $this->plan_estrategico_model->get_metas_estrategicas($where,'pie_id','pie_pilar_estrategico.*'); //LE LINEA EST
            $data['objetivos'] = $this->plan_estrategico_model->get_metas_estrategicas($where, 'obe_id','obe_objetivo_estrategico.*');// OE OBJ ESTRAT
            $data['acciones_estra'] = $this->plan_estrategico_model->get_metas_estrategicas($where,'aca_id','aca_accion_estrategica.*');
                                $this->db->order_by('per_codigo', 'ASC');
            $data['periodos'] = $this->plan_estrategico_model->get_programacion_plan_estrategico($where, 'per_id', 'per_periodo.*');
            //SI NO POSEE EL ROL DE JEFE DE UNIDAD SOLO SE MOSTRARAN EN LAS QUE PARTICIPA O ES REPONSABLE
            $autorizado_ver  = false;
            $autorizar_array = explode(",", $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD'));
            $roles_array     = $this->gsatelite->get_tabla("uxr_usuarioxrol", array("uxr_id_usu" => $this->tank_auth->get_user_id()));
            foreach ($roles_array as $r) {
                if (in_array($r["uxr_id_rol"], $autorizar_array)) {
                    $autorizado_ver = true;
                }
            }
            if (!$autorizado_ver) {
                $datos = $this->plan_operativo_model->get_informacion_empleado($this->tank_auth->get_user_id());
                $plz = (count($datos) > 0) ? $datos[0]['plz_id'] : 0;
                $plz = (is_numeric($plz)) ? $plz : 0;
                $where["(reo_id_plz = $plz OR pao_id_plz = $plz)"] = null;
            }           
                               $this->db->order_by('pie_id, obe_id, aca_id, aco_id ASC');
            $data['reporte'] = $this->plan_estrategico_model->get_metas_est_form_pei($where);
            // print_r($this->db->last_query());die();
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_formulacion_pei_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('modulo_planificacion/pla_reporte_pei/reporte_formulacion_pei', $data, true);
            if ($flag) {
                echo json_encode(array('tabla' => $html, 'puede_ver' => $autorizado_ver));
                // echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Formulación PEI';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_Formulacion_PEI_' . date('dmY');
                    $reporte = $header . $html;
                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Formulacion_PEI', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    echo $html;
                }
            }
        }
    }

    function seguimiento_pei(){
        satelite_validar();

        $select = $this->gsatelite->get_dropdown('pes_plan_estrategico', '{pes_nombre}', '', array('pes_estado' => '1'), null, '', 'pes_id', true);
        $data['plan_estrategico'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);

        $data['titulo_personal'] = "Reporte Seguimiento PEI";
        cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */

    function reporte_seguimiento_pei($flag = null) {
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //var_dump($post_array);die();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            $plan_operativo = null;
            $area = null;
            $plan_split = null;
            $area_split = null;

            if ($flag == 1) {
                $plan_operativo = ($post_array['plan'] != '') ? $post_array['plan'] : null;
                $area = ($post_array['area'] != '') ? $post_array['area'] : null;
            } else {

                /*
                 * Los valores de filtro vienen concatenados junto a tu texto i.e. Estado = "1#Creado"
                 * Se separan los filtros
                 */
                $plan_split = ($post_array['filtro_plan'] != '') ? explode("#", $post_array['filtro_plan']) : null;
                $area_split = ($post_array['filtro_area'] != '') ? explode("#", $post_array['filtro_area']) : null;

                //Se asignan los valores de filtro
                $plan_operativo = ($post_array['slcPlan'] != '') ? $post_array['slcPlan'] : null;
                $data['nombrePlan'] = $plan_split[1];

                $area = ($post_array['slcArea'] != '') ? $post_array['slcArea'] : null;
                $data['nombreArea'] = $area_split[1];
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = (isset($post_array['tipo_reporte'])) ? $post_array['tipo_reporte']: null;

            $where = null;

            if ($plan_operativo) {
                $where['pes_id'] = $plan_operativo;
            }
            if ($area) {
                $where['pxu_id_are'] = $area;
            }
            ///var_dump($where);die();

            //$data['pilares'] = $this->plan_estrategico_model->get_metas_estrategicas($where,'pie_id','pie_pilar_estrategico.*');
            //$data['objetivos'] = $this->plan_estrategico_model->get_metas_estrategicas($where, 'obe_id','obe_objetivo_estrategico.*');
            //$data['acciones_estra'] = $this->plan_estrategico_model->get_metas_estrategicas($where,'aca_id','aca_accion_estrategica.*');
            $data['reporte'] = $this->plan_estrategico_model->get_metas_estrategicas($where);
            //print_r($this->db->last_query());die();
            $data['periodos'] = $this->plan_estrategico_model->get_programacion_plan_estrategico($where, 'per_id', 'per_periodo.*');
            
            $data['tipo_reporte'] = $tipo_reporte;
            //var_dump($data);die();
            $filename = 'reporte_seguimiento_pei_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;
            $html = $this->load->view('modulo_planificacion/pla_reporte_pei/reporte_seguimiento_pei', $data, true);

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Seguimiento PEI';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Seguimiento_PEI_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Seguimiento_PEI', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_seguimiento_pei_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Seguimiento PEI';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    public function get_pie_x_pes(){
        $flt = $this->input->post('plan');
        $dropdown = $this->gsatelite->get_dropdown('pie_pilar_estrategico', '{pie_nombre}', '', array('pie_estado' => 1, 'pie_id_pes' => $flt), null, '', 'pie_id', true);
        echo str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $dropdown);
    }

    public function get_obe_x_pie(){
        $flt = $this->input->post('pie');
        $dropdown = $this->gsatelite->get_dropdown('obe_objetivo_estrategico', '{obe_nombre}', '', array('obe_estado' => 1, 'obe_id_pie' => $flt), null, '', 'obe_id', true);
        echo str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $dropdown);
    }

    public function get_aca_x_obe(){
        $flt = $this->input->post('obe');
        $dropdown = $this->gsatelite->get_dropdown('aca_accion_estrategica', '{aca_nombre}', '', array('aca_estado' => 1, 'aca_id_obe' => $flt), null, '', 'aca_id', true);
        echo str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $dropdown);
    }

    public function get_aco_x_aca(){
        $flt = $this->input->post('aca');
        $dropdown = $this->gsatelite->get_dropdown('aco_accion_operativa', '{aco_nombre}', '', array('aco_estado' => 1, 'aco_id_aca' => $flt), null, '', 'aco_id', true);
        echo str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $dropdown);
    }
}