<?php
/**
 * Created by PhpStorm.
 * pla_plan_operativo.php
 * Descripción:
 * Funcionalidad del sistema.
 *
 * @package ERP
 * @subpackage Modulo - Planificación (Plan Operativo)
 * @copyright Copyright (c) 2018 Grupo Satélite S.A. DE C.V.
 * @author Mario Marquez - Grupo Satélite
 * @version 2020 - 1
 * @since Archivo disponible desde 2020-03-05
 */

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Pla_plan_operativo extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('plan_estrategico_model');
        $this->load->model('plan_operativo_model');
        $this->load->library('texto');
    }

    /**
     * Descripción:
     * Función para la vista index
     * @author Mario Marquez - Grupo Satélite
     * @since 2020-01-24
     */
    public function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    /**
     * Descripción:
     * Catalogo de Plan Estrategicos
     * @author Mario Marquez - Grupo Satélite
     * @since 2020-01-24
     * @param ninguno
     */
    function activar_poa()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {

                $permisos = $this->gsatelite->get_permisos_opcion('activar_poa');
                $flujos_parametro = json_decode($this->gsatelite->get_parametro("SYS_FLUJO_PLANIFICACION"), true);

                $add_fields = array(
                    'poa_nombre',
                    'poa_anio',
                    'pei',
                    'poa_estado',
                    'poa_usu_creacion',
                    'poa_usu_modificacion',
                    'poa_fecha_creacion',
                    'poa_fecha_modificacion'
                );

                $edit_fields = array(
                    'poa_nombre',
                    'poa_anio',
                    'pei',
                    'poa_estado',
                    'poa_usu_modificacion',
                    'poa_fecha_modificacion'
                );

                $display_as = array(
                    'poa_nombre' => 'POA Nombre',
                    'pxu_nombre' => 'Nombre',
                    'poa_anio' => 'Año del Plan',
                    'poa_estado' => 'Estado',
                    'pei' => 'PEI'
                );

                $required_fields = array(
                    'poa_nombre',
                    'poa_anio',
                    'poa_estado',
                    'poa_usu_modificacion',
                    'poa_fecha_modificacion'
                );

                $columns = array(
                    'poa_anio',
                    'poa_nombre'
                );

                $crud = new grocery_CRUD();
                $crud->set_table('poa_plan_operativo');
                $crud->set_subject('Plan Operativo Anual');
                $crud->display_as($display_as);
                $crud->display_as('poa_estado', 'Estado');
                $crud->columns($columns);
                $crud->add_fields($add_fields);
                $crud->edit_fields($edit_fields);
                $crud->required_fields($required_fields);
                //$crud->set_relation('pes_id_tpl','tpl_tipo_plan_estrategico','tpl_nombre',array('tpl_estado' => 1));
                $crud->set_relation_n_n('pei', 'pop_plan_operativoxplan_estrategico', 'pes_plan_estrategico', 'pop_id_poa', 'pop_id_pes', 'pes_nombre');
                $crud->set_rules('poa_nombre', 'Nombre', 'campo_unico[poa_plan_operativo.poa_nombre]|required');
                $crud->set_rules('poa_anio', 'Año del Plan', 'campo_unico[poa_plan_operativo.poa_anio]|required');
                $crud->field_type('poa_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('poa_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));

                //Se lista los años 6 atras y 6 adelante.
                $anio_array = array();

                for ($i = (date('Y') - 6); $i <= (date('Y') + 6); $i++) {
                    $anio_array[$i] = $i;
                }

                $crud->field_type('poa_anio', 'dropdown', $anio_array);

                $crud->callback_after_insert(function ($post_array, $primary_key) {
                    //Se obtienen los puestos por los planes estrategicos asignados
                    $pei_ids = implode(",", $post_array['pei']);

                    $where = array();
                    $where['pes_id IN(' . $pei_ids . ")"] = NULL;

                    $areas = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1)); //$this->plan_estrategico_model->get_responsables_plan_estrategico($where, "are_id, are_nombre", "are_area.*");
                    $flujos_parametro = json_decode($this->gsatelite->get_parametro("SYS_FLUJO_PLANIFICACION"), true);

                    //Se ingresan los Poa por Unidad
                    foreach ($areas as $are) {
                        $pxu_array = array(
                            'pxu_id_are' => $are['are_id'],
                            'pxu_id_poa' => $primary_key,
                            'pxu_id_flu' => $flujos_parametro['POA']['FORMULACION'],
                            "pxu_estado" => 1,
                            "pxu_usu_creacion" => $this->tank_auth->get_user_id(),
                            "pxu_usu_modificacion" => $this->tank_auth->get_user_id(),
                            "pxu_fecha_creacion" => date('Y-m-d H:i:s'),
                            "pxu_fecha_modificacion" => date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('pxu_plan_operativoxunidad', $pxu_array);
                    }
                    return true;
                });

                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('poa_estado', 'hidden', 1);
                    $crud->field_type('poa_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                    $crud->field_type('poa_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));

                } else {
                    //$data['pes_id'] = end(explode('/', uri_string()));
                    $crud->field_type('poa_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                $crud->unset_export();
                $crud->unset_print();
                $url = explode('/', uri_string());

                // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                } else {
                    $crud->add_action('Planes Activos', 'icon16 icomoon-icon-rock', 'modulo_planificacion/pla_plan_operativo/plan_operativos_unidad');
                    // $crud->add_action('Objetivo Operativo', 'icon16 icomoon-icon-racing', 'modulo_planificacion/pla_plan_operativo/objetivo_operativo');
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                if ($permisos['permite_ver']) {
                    $crud->add_action('Ver', 'minia-icon-search', 'modulo_planificacion/pla_plan_operativo/activar_poa/read');
                }

                $output = $crud->render();
                $data['titulo_personal'] = "Plan Operativo Anual";
                cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function areas_by_poa(){
        $poa = $this->input->post('poa_id');
        $select = '<option value=""></option>';
                $this->db->join('are_area', 'are_id = pxu_id_are');
        $area = $this->gsatelite->get_tabla('pxu_plan_operativoxunidad', array('are_estado' => 1, 'pxu_estado' => 1, 'pxu_id_poa' => $poa));
        foreach ($area as $key => $val) {
            $select .= '<option value="' . $val['are_id'] . '">' . $val['are_nombre'] . '</option>';
        }
        echo $select;
    }

    public function obj_operativo($plan_op = 0, $area = 0){
        satelite_validar();
        $where = $poa_id = $plan_area = null;
        $registro = array();
        if ($_POST) {
            $post_array = $this->input->post();
            if ($post_array['slcPlanOperativo'] > 0) {
                $where['poa_id'] = $post_array['slcPlanOperativo'];
            }
            if ($post_array['slcArea'] > 0) {
                $where['are_id'] = $post_array['slcArea'];
            }
        } else {
            if ($plan_op > 0) {
                $where['poa_id'] = $plan_op;
            }
            if ($area > 0) {
                $where['are_id'] = $area;
            }
        }
        if ($where) {
            $pxus = $this->plan_operativo_model->get_objs_operativos($where);
        }        
        if (count($pxus) > 0) {
            $registro = $pxus;
            $poa_id = $pxus[0]['poa_id'];
            if ($post_array['slcArea'] > 0 || $area > 0) {
                $plan_area['are_id'] = $pxus[0]['are_id'];
                $plan_area['are_nombre'] = $pxus[0]['are_nombre'];
            }
        }else{
            if ($_POST) {
                if ($post_array['slcPlanOperativo'] > 0) {
                    $poa_id = $post_array['slcPlanOperativo'];
                }
                if ($post_array['slcArea'] > 0) {
                    $area = $this->gsatelite->get_registro('are_area', array('are_id' => $post_array['slcArea']));
                    $plan_area['are_id'] = $area->are_id;
                    $plan_area['are_nombre'] = $area->are_nombre;
                }
            }
        }
        $plan_operativo = $this->gsatelite->get_dropdown('poa_plan_operativo', '{poa_nombre}', '', array('poa_estado' => 1), $poa_id, '', 'poa_id', true);
        $data['plan'] = $poa_id;
        $data['plan_area'] = $plan_area;
        $data['filas_consulta'] = $registro;
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();    
        $data['plan_operativo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $plan_operativo);
        $data['titulo_personal'] = "Objetivo Operativo";
        cargarvista($data);
    }

    public function agregar_obj_operativo($pxu_id = null){
        satelite_validar();
        if ($_POST) {
            // var_dump($_POST);die();
            $btn = $this->input->post('btnCrear');
            $id_poa = $this->input->post('slc_poa');
            $id_are = $this->input->post('slc_are');
            $pxu = $this->gsatelite->get_campo('pxu_plan_operativoxunidad', 'pxu_id', array('pxu_id_poa' => $id_poa, 'pxu_id_are' => $id_are));
            if ($pxu > 0) {
                $obj = array(
                    'obo_id_pxu' => $pxu,
                    'obo_codigo' => $this->input->post('codigo'),
                    'obo_nombre' => $this->input->post('nombre'),
                    'obo_estado' => 1,
                    'obo_usu_creacion' => $this->tank_auth->get_user_id(),
                    'obo_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'obo_fecha_creacion' => date('Y-m-d H:i:s'),
                    'obo_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $obj_id = $this->gsatelite->ingresar('obo_objetivo_operativo', $obj);
            } else {
                $obj_id = 0;
            }
            $url = ($btn > 0) ? "modulo_planificacion/pla_plan_operativo/obj_operativo" : "modulo_planificacion/pla_plan_operativo/agregar_obj_operativo";
            if ($obj_id > 0) {
                $this->gsatelite->show_dialog("El Objetivo se procesó correctamente.", $url, "success", "Éxito");
            } else {
                $this->gsatelite->show_dialog("No se pudo procesar el Objetivo",  $url, "error", "Ocurrió un error");
            }
        } else {
            $plan_operativo = $this->gsatelite->get_dropdown('poa_plan_operativo', '{poa_nombre}', '', array('poa_estado' => 1), null, '', 'poa_id', true);
            $data['plan_operativo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $plan_operativo);
            $data['titulo_personal'] = "Agregar Objetivo Operativo";
            cargarvista($data);
        }
    }

    public function edit_obj_opera($plan_id = 0, $are_id = 0, $obo_id = 0,  $ver = null){
        satelite_validar();
        if ($_POST) {
            // var_dump($_POST);die();
            $btn = $this->input->post('btnCrear');
            $id_poa = $this->input->post('slc_poa');
            $id_are = $this->input->post('slc_are');
            $obo = $this->input->post('obo_id');
            $pxu = $this->gsatelite->get_campo('pxu_plan_operativoxunidad', 'pxu_id', array('pxu_id_poa' => $id_poa, 'pxu_id_are' => $id_are));
            if ($pxu > 0) {
                $obj = array(
                    'obo_id_pxu' => $pxu,
                    'obo_codigo' => $this->input->post('codigo'),
                    'obo_nombre' => $this->input->post('nombre'),
                    'obo_estado' => ($this->input->post('estado') != "") ? $this->input->post('estado') : 1,
                    'obo_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'obo_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $obj_id = $this->gsatelite->actualizar_array('obo_objetivo_operativo', $obj, array('obo_id' => $obo));
            } else {
                $obj_id = 0;
            }
            $url = ($btn > 0) ? "modulo_planificacion/pla_plan_operativo/obj_operativo/$plan_id/$are_id" : "modulo_planificacion/pla_plan_operativo/edit_obj_opera/" . $obo;
            if ($obj_id > 0) {
                $this->gsatelite->show_dialog("El Objetivo se procesó correctamente.", $url, "success", "Éxito");
            } else {
                $this->gsatelite->show_dialog("No se pudo procesar el Objetivo",  $url, "error", "Ocurrió un error");
            }
        } else {
            $datos_obj = $this->gsatelite->get_tabla('obo_objetivo_operativo', array('obo_id' => $obo_id));
            $pxu = $this->gsatelite->get_registro('pxu_plan_operativoxunidad', array('pxu_id' => $datos_obj[0]['obo_id_pxu']));
            $plan_ope = $this->gsatelite->get_dropdown('poa_plan_operativo', '{poa_nombre}', '', array('poa_estado' => 1), $pxu->pxu_id_poa, '', 'poa_id', true);
                        $this->db->join('pxu_plan_operativoxunidad', 'pxu_id_are = are_id');
            $area_poa = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado' => 1, 'pxu_id_poa' => $pxu->pxu_id_poa), $pxu->pxu_id_are, '', 'are_id', true);
            $data['ver'] = $ver;
            $data['area_id'] = $are_id;
            $data['plan_id'] = $plan_id;
            $data['datos'] = $datos_obj[0];
            $data['areas_poa'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $area_poa);
            $data['plan_operativo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $plan_ope);
            $data['titulo_personal'] = ($ver) ? "Ver Objetivo Operativo" : "Editar Objetivo Operativo";
            cargarvista($data);
        }
    }

    public function validar_codigo_obj(){
        $code = trim($this->input->post('codigo'));
        $id_poa = $this->input->post('poa_id');
        $id_are = $this->input->post('are_id');
        $dist = ($this->input->post('obo_id') != "") ? $this->input->post('obo_id') : 0;
        $id_pxu = $this->gsatelite->get_campo('pxu_plan_operativoxunidad', 'pxu_id', array('pxu_id_poa' => $id_poa, 'pxu_id_are' => $id_are));
        $tabla = $this->gsatelite->get_tabla('obo_objetivo_operativo', array('obo_estado' => 1, 'obo_codigo' => $code, 'obo_id_pxu' => $id_pxu, 'obo_id != ' => $dist));
        echo count($tabla);
    }

    public function indicador_op($plan = 0, $area = 0, $obo_id = 0){
        satelite_validar();
        try {
                        $this->db->join('pxu_plan_operativoxunidad', 'pxu_id = obo_id_pxu');
                        $this->db->join('poa_plan_operativo', 'poa_id = pxu_id_poa');
                        $this->db->join('are_area', 'are_id = pxu_id_are');                        
            $obj_oper = $this->gsatelite->get_tabla('obo_objetivo_operativo', array('obo_id' => $obo_id))[0];
            $permisos = $this->gsatelite->get_permisos_opcion('modulo_planificacion/pla_plan_operativo/obj_operativo');
            $add_fields = array(
                'ino_id_obo',
                'ino_nombre',
                'ino_forma_calculo',
                'ino_frecuencia_medicion',
                'ino_meta',
                'Responsables',
                'ino_estado',
                'ino_usu_creacion',
                'ino_usu_modificacion',
                'ino_fecha_creacion',
                'ino_fecha_modificacion'
            );
            $edit_fields = array(
                'ino_id_obo',
                'ino_nombre',
                'ino_forma_calculo',
                'ino_frecuencia_medicion',
                'ino_meta',
                'Responsables',
                'ino_estado',
                'ino_usu_modificacion',
                'ino_fecha_modificacion'
            );
            $display_as = array(
                'ino_nombre' => 'Nombre',
                'ino_forma_calculo' => 'Forma de Cálculo',
                'ino_frecuencia_medicion' => 'Frecuencia de Medición',
                'ino_meta' => 'Meta',
                'ino_estado' => 'Estado'
            );
            $required_fields = array(
                'ino_id_obo',
                'ino_nombre',
                'ino_estado'
            );
            $columns = array(
                'ino_nombre',
                'ino_forma_calculo',
                'ino_frecuencia_medicion',
                'ino_meta',
                'ino_estado'
            );
            $auditoria_acciones = array(
                'rei_estado' => 1,
                'rei_usu_creacion' => $this->tank_auth->get_user_id(),
                'rei_usu_modificacion' => $this->tank_auth->get_user_id(),
                'rei_fecha_modificacion' => date('Y-m-d H:i:s'),
                'rei_fecha_creacion' => date('Y-m-d H:i:s')
            );

            $crud = new grocery_CRUD();
            $crud->set_table('ino_indicador_operativo');
            $crud->set_subject('Indicador Operativo');
            $crud->display_as($display_as);
            $crud->callback_column('ino_nombre', function($value, $row) {
                return '<span >' . $value . '</span>';
            });
            $crud->columns($columns);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->required_fields($required_fields);
            $crud->where('ino_id_obo', $obo_id);
            $crud->field_type('ino_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('ino_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('ino_id_obo', 'hidden', $obo_id);
            $crud->set_relation_n_n('Responsables', 'rei_responsable_indicador', 'plz_plaza', 'rei_id_ino', 'rei_id_plz', 'plz_nombre', null, array('plz_estado' => 1), $auditoria_acciones);
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('ino_estado', 'hidden', 1);
                $crud->field_type('ino_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('ino_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('ino_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            $crud->unset_export();
            $crud->unset_print();
            if ($permisos['permite_agregar']) {
                $crud->add_action('Actividad Operativa', 'icon16 icomoon-icon-target', "modulo_planificacion/pla_plan_operativo/meta_operativa/$plan/$area");
            } else {                
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }
            $output = $crud->render();
            $data['plan'] = $plan;
            $data['area'] = $area;
            $data['objetivo_ope'] = $obj_oper;
            $data['titulo_personal'] = "Indicador Operativo";
            cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }


    public function plan_operativos_unidad($poa_id)
    {
        satelite_validar();

        $add_fields = array(
            'pxu_id_poa',
            'pxu_id_are',
            'pxu_estado',
            'pxu_usu_creacion',
            'pxu_usu_modificacion',
            'pxu_fecha_creacion',
            'pxu_fecha_modificacion'
        );

        $edit_fields = array(
            'pxu_id_poa',
            'pxu_id_are',
            'pxu_estado',
            'pxu_usu_modificacion',
            'pxu_fecha_modificacion'
        );

        $display_as = array(
            'pxu_id_poa' => 'Plan Operativo',
            'pxu_id_are' => 'Área',
            'pxu_estado' => 'Estado'
        );

        $required_fields = array(
            'poa_nombre',
            'poa_anio',
            'poa_estado',
            'poa_usu_modificacion',
            'poa_fecha_modificacion'
        );

        $columns = array(
            'pxu_id_poa',
            'pxu_id_are'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('pxu_plan_operativoxunidad');
        $crud->set_subject('Plan Operativo Anual Por Unidad');
        $crud->display_as($display_as);
        $crud->display_as('pxu_estado', 'Estado');
        $crud->columns($columns);
        $crud->add_fields($add_fields);
        $crud->edit_fields($edit_fields);
        $crud->required_fields($required_fields);
        $crud->set_relation('pxu_id_poa', 'poa_plan_operativo', 'poa_nombre', array('poa_id' => $poa_id));
        $crud->set_relation('pxu_id_are', 'are_area', 'are_nombre', array('are_estado' => 1));
        $crud->field_type('pxu_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('pxu_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->set_rules('pxu_id_poa', 'Plan Operativo', 'required');
        $crud->set_rules('pxu_id_are', 'Área', 'required|campo_unico2[pxu_plan_operativoxunidad.pxu_id_are.pxu_id_poa.$poa_id]');
        $crud->where('pxu_id_poa', $poa_id);

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('pxu_estado', 'hidden', 1);
            $crud->field_type('pxu_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('pxu_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));

        } else {
            //$data['pes_id'] = end(explode('/', uri_string()));
            $crud->field_type('pxu_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        //$crud->unset_add();
        //$crud->unset_edit();
        //$crud->unset_delete();
        //$crud->unset_read();

        $output = $crud->render();
        $data['titulo_personal'] = "Plan Operativo Anual por Unidad";
        cargarvista($data, $output);
    }


    public function meta_operativa($plan = 0, $area = 0, $indic_ope = null, $tipo_flujo = null, $registro_seg = null){
        satelite_validar();
        if ($indic_ope) {
                            $this->db->join('obo_objetivo_operativo', 'obo_id = ino_id_obo');
                            $this->db->join('pxu_plan_operativoxunidad', 'pxu_id = obo_id_pxu');
                            $this->db->join('poa_plan_operativo', 'poa_id = pxu_id_poa');
                            $this->db->join('are_area', 'are_id = pxu_id_are');                        
            $indicador_op = $this->gsatelite->get_tabla('ino_indicador_operativo', array('ino_id' => $indic_ope))[0];
            $ind_ope = $indicador_op['ino_id'];
            $datos['plan'] = $plan;
            $datos['area'] = $area;
            $datos['plan_unidad'] = $ind_ope;
            $datos['tipo_flujo'] = ($tipo_flujo != null) ? $tipo_flujo : 0;
            $datos['registro_seg'] = ($registro_seg != null) ? $registro_seg : 0;
            $datos['metas'] = $this->plan_operativo_model->get_metas_operativas(array('met_id_ino' => $ind_ope));
            $datos['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_planificacion/pla_plan_operativo/obj_operativo');
            $html = $this->load->view('modulo_planificacion/pla_plan_operativo/consultar_metas_operativas', $datos, true);
        } else {
            $html = "";
            $ind_ope = 0;
            $indicador_op = array();
        }
        $data['plan'] = $plan;
        $data['area'] = $area;
        $data['consulta'] = $html;
        $data['indicador'] = $indicador_op;
        $data['ind_plan_unidad'] = $ind_ope;
        $data['registro_seg'] = ($registro_seg != null) ? $registro_seg : 0;
        $data['tipo_flujo'] = ($tipo_flujo != null) ? $tipo_flujo : 0;
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_planificacion/pla_plan_operativo/obj_operativo');
        $data['titulo_personal'] = "Actividad Operativa";
        cargarvista($data);
    }

    public function anular_meta($plan = 0, $area = 0, $met_id = 0, $indic_ope = 0){
        $exito = 0;
        // se eliminara si no hay dependencias con otras tablas
        $prm = $this->gsatelite->get_tabla('prm_programacion_meta', array('prm_id_met' => $met_id));
        $acm = $this->gsatelite->get_tabla('acm_actividad_meta_operativa', array('acm_id_met' => $met_id));
        $xms = $this->gsatelite->get_tabla('mxs_metasxsolicitud_reprogramacion', array('mxs_id_met' => $met_id));
        if (count($prm) == 0 && count($acm) == 0 && count($xms) == 0) {
            $exito = $this->gsatelite->borrado_general('met_meta_operativa', array('met_id' => $met_id));
        }
        if ($exito > 0) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Actividad Operativa", 'texto_alerta' => "Fue eliminada correctamente");
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Actividad Operativa", 'texto_alerta' => "No se eliminó. Otros registros dependen de este.");
        }
        $this->session->set_flashdata($alerta);
        redirect("modulo_planificacion/pla_plan_operativo/meta_operativa/$plan/$area/$indic_ope");
    }

    public function agregar_meta_operativa($plan = 0, $area = 0, $indic_ope = null, $tipo_flujo = null, $registro_seg = null){
        satelite_validar();
        $ruta_flujo = ($indic_ope > 0) ? '/' . $plan . '/' . $area . '/' . $indic_ope . '/' . $tipo_flujo . '/' . $registro_seg : "";
        if ($this->input->post()) {
            // var_dump($_POST);die();
            $post_array = $this->input->post();
            $codigo_meta = $this->get_codigo_meta($post_array['slcTipoMeta'], $post_array['slcPlanOperativo'], 1);
            $meta_array = array(
                "met_id_aco" => ($post_array['slcMetaEstrategica'] != '') ? $post_array['slcMetaEstrategica'] : null,
                "met_id_ino" => ($post_array['indicador_op'] != '') ? $post_array['indicador_op'] : null,
                "met_id_tmd" => ($post_array['slcTipoMedicion'] != '') ? $post_array['slcTipoMedicion'] : null,
                "met_id_pxu" => ($post_array['slcPlanOperativo'] != '') ? $post_array['slcPlanOperativo'] : null,
                "met_codigo" => $codigo_meta,
                "met_tipo_meta" => ($post_array['slcTipoMeta'] != '') ? $post_array['slcTipoMeta'] : null,
                "met_nombre" => ($post_array['txtNombreMet'] != '') ? $post_array['txtNombreMet'] : null,
                "met_unidad_program" => ($post_array['txtUnidades'] != '') ? $post_array['txtUnidades'] : null,
                "met_indicador" => null, // ($post_array['txtIndicador'] != '') ? $post_array['txtIndicador'] : null,
                "met_descripcion" => ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : null,
                "met_unidad_reprog" => null,
                "met_asignacion_presupuesto" => ($post_array['txtAsignacionPre'] != '') ? convertirFloat($post_array['txtAsignacionPre']) : 0,
                "met_estado" => 1,
                "met_usu_creacion" => $this->tank_auth->get_user_id(),
                "met_usu_modificacion" => $this->tank_auth->get_user_id(),
                "met_fecha_creacion" => date('Y-m-d H:i:s'),
                "met_fecha_modificacion" => date('Y-m-d H:i:s')
            );
            $met_id = $this->gsatelite->ingresar('met_meta_operativa', $meta_array);
            if ($met_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Actividad Operativa", 'texto_alerta' => "Actividad #" . $codigo_meta . " creada correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Actividad Operativa", 'texto_alerta' => "Ocurrio un error, intentelo nuevamente.");
            }
            $this->session->set_flashdata($alerta);
            $btnCrear = $post_array['btnCrear'];
            if ($btnCrear == 1) {
                redirect('modulo_planificacion/pla_plan_operativo/meta_operativa' . $ruta_flujo);
            } else {
                redirect('modulo_planificacion/pla_plan_operativo/agregar_meta_operativa' . $ruta_flujo);
            }
        } else {
                        $this->db->join('obo_objetivo_operativo', 'obo_id = ino_id_obo');
                        $this->db->join('pxu_plan_operativoxunidad', 'pxu_id = obo_id_pxu');
                        $this->db->join('poa_plan_operativo', 'poa_id = pxu_id_poa');
                        $this->db->join('are_area', 'are_id = pxu_id_are');                        
            $indic_op = $this->gsatelite->get_tabla('ino_indicador_operativo', array('ino_id' => $indic_ope))[0];
            $select = $this->gsatelite->get_dropdown('tmd_tipo_medicion', '{tmd_nombre}', '', array('tmd_estado' => '1'), null, '', 'tmd_id', true);
            $data['plan'] = $plan;
            $data['area'] = $area;
            $data['indicador'] = $indic_op;
            $data['ruta_flujo'] = $ruta_flujo;
            $data['ind_plan_unidad'] = ($indic_ope != null) ? $indic_ope : 0;
            $data['tipo_flujo'] = ($tipo_flujo != null) ? $tipo_flujo : 0;
            $data['registro_seg'] = ($registro_seg != null) ? $registro_seg : 0;
            $data['tipo_medicion'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);
            $data['titulo_personal'] = "Agregar Actividad Operativa";
            cargarvista($data);
        }
    }

    public function editar_meta_operativa($plan = 0, $area = 0, $met_id, $indic_ope = null, $tipo_flujo = null, $registro_seg = null){
        satelite_validar();
        $ruta_flujo = ($indic_ope > 0) ? '/' . $indic_ope . '/' . $tipo_flujo . '/' . $registro_seg : "";
        $data['ruta_flujo'] = $ruta_flujo;
        if ($this->input->post()) {
            $post_array = $this->input->post();
            // die(var_dump($post_array));
            $meta_array = array(
                "met_id_tmd" => ($post_array['slcTipoMedicion'] != '') ? $post_array['slcTipoMedicion'] : null,
                "met_nombre" => ($post_array['txtNombreMet'] != '') ? $post_array['txtNombreMet'] : null,
                "met_unidad_program" => ($post_array['txtUnidades'] != '') ? $post_array['txtUnidades'] : null,
                "met_indicador" => null, // ($post_array['txtIndicador'] != '') ? $post_array['txtIndicador'] : null,
                "met_descripcion" => ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : null,
                "met_unidad_reprog" => null,
                "met_asignacion_presupuesto" => ($post_array['txtAsignacionPre'] != '') ? convertirFloat($post_array['txtAsignacionPre']) : 0,
                "met_usu_modificacion" => $this->tank_auth->get_user_id(),
                "met_fecha_modificacion" => date('Y-m-d H:i:s')
            );
            $act_met_id = $this->gsatelite->actualizar_array('met_meta_operativa', $meta_array, array('met_id' => $met_id));
            if ($act_met_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Indicador Operativo", 'texto_alerta' => "Indicador actualizado correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Indicador Operativo", 'texto_alerta' => "Ocurrio un error, intentelo nuevamente.");
            }
            $this->session->set_flashdata($alerta);
            $btnCrear = $post_array['btnCrear'];
            if ($btnCrear == 1) {
                redirect('modulo_planificacion/pla_plan_operativo/meta_operativa/'.$plan.'/'.$area.$data['ruta_flujo']);
            } else {
                redirect('modulo_planificacion/pla_plan_operativo/editar_meta_operativa/'.$plan.'/'.$area.'/'.$met_id . $data['ruta_flujo']);
            }
        } else {
                        $this->db->join('obo_objetivo_operativo', 'obo_id = ino_id_obo');
                        $this->db->join('pxu_plan_operativoxunidad', 'pxu_id = obo_id_pxu');
                        $this->db->join('poa_plan_operativo', 'poa_id = pxu_id_poa');
                        $this->db->join('are_area', 'are_id = pxu_id_are');                        
            $indic_op = $this->gsatelite->get_tabla('ino_indicador_operativo', array('ino_id' => $indic_ope))[0];
            $meta = $this->gsatelite->get_tabla('met_meta_operativa', array('met_id' => $met_id))[0];
            $select = $this->gsatelite->get_dropdown('tmd_tipo_medicion', '{tmd_nombre}', '', array('tmd_estado' => '1'), $meta['met_id_tmd'], '', 'tmd_id', true);
            $data['plan'] = $plan;
            $data['area'] = $area;
            $data['meta'] = $meta;
            $data['indicador'] = $indic_op;
            $data['meta'] = $this->gsatelite->get_tabla('met_meta_operativa', array('met_id' => $met_id))[0];            
            $data['tipo_medicion'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);
            $data['titulo_personal'] = "Editar Actividad Operativa";
            cargarvista($data);
        }
    }

    function actividades_meta($met_id, $plan_ope = null, $tipo_flujo = null, $registro_seg = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {

                $add_fields = array(
                    'acm_id_met',
                    'acm_orden',
                    'acm_nombre',
                    'acm_descripcion',
                    'acm_estado',
                    'acm_usu_creacion',
                    'acm_usu_modificacion',
                    'acm_fecha_creacion',
                    'acm_fecha_modificacion'
                );

                $edit_fields = array(
                    'acm_orden',
                    'acm_nombre',
                    'acm_descripcion',
                    'acm_estado',
                    'acm_usu_modificacion',
                    'acm_fecha_modificacion'
                );

                $display_as = array(
                    'acm_orden' => "Orden",
                    'acm_nombre' => 'Nombre',
                    'acm_descripcion' => 'Descripción',
                    'acm_estado' => 'Estado'
                );

                $required_fields = array(
                    'acm_id_met',
                    'acm_orden',
                    'acm_nombre',
                    'acm_estado',
                    'acm_usu_creacion',
                    'acm_usu_modificacion',
                    'acm_fecha_creacion',
                    'acm_fecha_modificacion'
                );

                $columns = array(
                    'acm_orden',
                    'acm_nombre',
                    'acm_descripcion'
                );

                $crud = new grocery_CRUD();
                $crud->set_table('acm_actividad_meta_operativa');
                $crud->set_subject('Actividades Operativas');
                $crud->display_as($display_as);
                $crud->display_as('acm_estado', 'Estado');
                $crud->columns($columns);
                $crud->add_fields($add_fields);
                $crud->edit_fields($edit_fields);
                $crud->required_fields($required_fields);
                $crud->set_rules('acm_orden', 'Orden', 'required|campo_unico2[acm_actividad_meta_operativa.acm_orden.acm_id_met.' . $met_id . ']|required');
                $crud->field_type('acm_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('acm_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
                $crud->field_type('acm_id_met', 'hidden', $met_id);
                $crud->field_type('acm_fecha_inicio', 'string');
                $crud->field_type('acm_fecha_fin', 'string');

                $orden_array = array();

                for ($i = 1; $i <= 10; $i++) {
                    $orden_array[$i] = $i;
                }

                $crud->field_type('acm_orden', 'dropdown', $orden_array);

                $data['acm_id'] = 0;
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('acm_estado', 'hidden', 1);
                    $crud->field_type('acm_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                    $crud->field_type('acm_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));

                } else {
                    $data['acm_id'] = end(explode('/', uri_string()));
                    $crud->field_type('acm_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                $crud->unset_export();
                $crud->unset_print();
                $output = $crud->render();
                $data['titulo_personal'] = "Actividades Operativas";
                $data['ruta_flujo'] = ($plan_ope > 0) ? '/' . $plan_ope . '/' . $tipo_flujo . '/' . $registro_seg : "";
                $data['meta'] = $this->gsatelite->get_tabla('met_meta_operativa', array('met_id' => $met_id))[0];
                cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function programacion_mensual($plan = 0, $area = 0, $met_id, $plan_ope = null, $tipo_flujo = null, $registro_seg = null){
        satelite_validar();
        try {
            $display_as = array(
                'prm_id_per' => "Período",
                'prm_programa' => "Valor",
                'prm_monto_asignado' => "Monto Asignado ($)"
            );
            $columns = array(
                'prm_id_per',
                'prm_programa',
                'prm_monto_asignado'
            );
            $crud = new grocery_CRUD();
            $crud->set_table('prm_programacion_meta');
            $crud->set_subject('Programación Mensual');
            $crud->display_as($display_as);
            $crud->columns($columns);
            $crud->callback_column("prm_monto_asignado", function($value, $row) {
                return number_format($value, 2);
            });
            $crud->callback_column("prm_id_per", function($value, $row) {
                $valor = $this->gsatelite->get_campo('per_periodo', 'per_codigo', array('per_id' => $value));
                if (strlen($valor) == 6) {
                    $mes = substr($valor, -2);
                    $yea = substr($valor, 0, 4);
                    $periodo = $mes . '-' . $yea;
                } else {
                    $periodo = $valor;
                }
                return $periodo;
            });
            $crud->unset_read();
            $crud->unset_delete();
            $crud->unset_add();
            $crud->unset_edit();
            $crud->unset_export();
            $crud->unset_print();
            $crud->where('prm_id_met', $met_id);
            $output = $crud->render();
            $data['plan'] = $plan;
            $data['area'] = $area;
            $data['titulo_personal'] = "Programación Mensual";
            $data['ruta_flujo'] = ($plan_ope > 0) ? '/' . $plan_ope . '/' . $tipo_flujo . '/' . $registro_seg : "";
                            $this->db->join('ino_indicador_operativo', 'ino_id = met_id_ino');
                            $this->db->join('obo_objetivo_operativo', 'obo_id = ino_id_obo');
                            $this->db->join('pxu_plan_operativoxunidad', 'pxu_id = obo_id_pxu');
                            $this->db->join('poa_plan_operativo', 'poa_id = pxu_id_poa');
                            $this->db->join('are_area', 'are_id = pxu_id_are');
            $data['meta'] = $this->gsatelite->get_tabla('met_meta_operativa', array('met_id' => $met_id))[0];
            $data['programacion'] = $this->gsatelite->count('prm_programacion_meta', array('prm_id_met' => $met_id));
            cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function agregar_programacion_meta($plan = 0, $area = 0, $met_id, $plan_ope = null, $registro_seg = null, $tipo_flujo = null){
        satelite_validar();
        $data['plan'] = $plan;
        $data['area'] = $area;
        $data['ruta_flujo'] = ($plan_ope > 0) ? '/' . $plan_ope . '/' . $registro_seg . '/' . $tipo_flujo : "";
        if ($this->input->post()) {
            $post_array = $this->input->post();
            // die(var_dump($post_array ));
            if (count($post_array['hdnPeriodo']) > 0) {
                for ($i = 0; $i < count($post_array['hdnPeriodo']); $i++) {
                    //Se obtiene el id del Periodo
                    $periodo = $this->plan_estrategico_model->get_periodo_planificacion($post_array['hdnPeriodo'][$i], 1);
                    $programa_array = array(
                        'prm_id_per' => $periodo['per_id'],
                        'prm_id_met' => $met_id,
                        'prm_programa' => ($post_array['txtProg'][$i] != "") ? $post_array['txtProg'][$i] : 0,
                        'prm_monto_asignado' => ($post_array['txtMonto'][$i] != "") ? str_replace(',', '', $post_array['txtMonto'][$i])  : 0,
                        'prm_descripcion' => "",
                        'prm_estado' => 1,
                        'prm_usu_creacion' => $this->tank_auth->get_user_id(),
                        'prm_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'prm_fecha_creacion' => date('Y-m-d H:i:s'),
                        'prm_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    if ($post_array['hdnPrograma'][$i] > 0) {
                        unset($programa_array['prp_estado']);
                        unset($programa_array['prm_usu_creacion']);
                        unset($programa_array['prm_fecha_creacion']);
                        unset($programa_array['prm_id_per']);
                        unset($programa_array['prm_id_met']);

                        $this->gsatelite->actualizar_array('prm_programacion_meta', $programa_array, array('prm_id' => $post_array['hdnPrograma'][$i]));
                    } else {
                        $this->gsatelite->ingresar('prm_programacion_meta', $programa_array);
                    }
                }
                if (count($post_array['hdnPeriodo']) > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Pogramación Mensual", 'texto_alerta' => "Información procesada correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Pogramación Mensual", 'texto_alerta' => "Ocurrio un error, intentelo nuevamente.");
                }
                $this->session->set_flashdata($alerta);
                $btnCrear = $post_array['btnCreprogramacion_mensualar'];
                if ($btnCrear == 1) {
                    redirect('modulo_planificacion/pla_plan_operativo/agregar_programacion_meta/'.$plan.'/'.$area.'/'. $met_id . $data['ruta_flujo']);
                } else {
                    redirect('modulo_planificacion/pla_plan_operativo/programacion_mensual/'.$plan.'/'.$area.'/'. $met_id . $data['ruta_flujo']);
                }
            }
        }
        $data['meta'] = $this->plan_operativo_model->get_metas_operativas(array('met_id' => $met_id))[0];
        $data['titulo_personal'] = "Programación Indicador";
        $data['meses'] = array('1' => "Enero", '2' => "Febrero", '3' => "Marzo", '4' => "Abril", '5' => "Mayo", '6' => "Junio", '7' => "Julio", '8' => "Agosto", '9' => "Septiembre", '10' => "Octubre", '11' => "Noviembre", '12' => "Diciembre");
        //Se obtiene la programación existente
                                $this->db->join('per_periodo', 'per_id = prm_id_per', 'inner');
        $data['programacion'] = $this->gsatelite->get_tabla('prm_programacion_meta', array('prm_id_met' => $met_id));
        cargarvista($data);
    }

    public function seguimiento($plan_op = 0, $area = 0, $mes = 0, $plan_unidad = null, $tipo_flujo = null, $periodo = null){
        satelite_validar();
        $data['filtro_mes'] = $mes;
        $data['filtro_area'] = $area;
        $data['filtro_plan'] = $plan_op;
        $data['filtro_area_name'] = ($area > 0) ? $this->gsatelite->get_campo('are_area', 'are_nombre', array('are_id' => $area)) : "";
        $data['plan_unidad'] = ($plan_unidad != null) ? $plan_unidad : 0;
        $data['plan_ope'] = ($plan_unidad != null) ? $this->gsatelite->get_campo('pxu_plan_operativoxunidad', 'pxu_id_poa', array('pxu_id' => $plan_unidad)) : 0;
        $data['periodo'] = ($periodo != null) ? $periodo : 0;
        $data['periodo_data'] = ($periodo != null) ? $this->gsatelite->get_tabla('per_periodo', array('per_id' => $periodo))[0] : null;
        $data['tipo_flujo'] = ($tipo_flujo != null) ? $tipo_flujo : 0;
        $data['plan_area'] = ($plan_unidad != null) ? $this->plan_operativo_model->get_planes_operativos_unidad(array('pxu_id' => $plan_unidad))[0] : null;
        $data['plan_operativo'] = $this->gsatelite->get_tabla('poa_plan_operativo', array('poa_estado' => 1));
        $data['ruta_flujo'] = ($plan_unidad > 0) ? '/' . $plan_unidad . '/' . $tipo_flujo . '/' . $periodo : "";
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array););
            $where = null;
            if ($post_array['plan_operativo'] != '') {
                $where['poa_id'] = $post_array['plan_operativo'];
            }
            if ($post_array['area'] != '') {
                $where['pxu_id_are'] = $post_array['area'];
            }
            $mes = $post_array['mes'];
            $data['poa'] = $this->plan_operativo_model->get_planes_operativos_unidad(array('pxu_id_poa' => $post_array['plan_operativo']))[0];
            // print_r($this->db->last_query());die();
            $data['codigo_mes'] = ($mes < 10) ? $data['poa']['poa_anio'] . '0' . $mes : $data['poa']['poa_anio'] . $mes;
            $data['mes'] = $post_array['mes'];
            $data['area'] = $post_array['area'];
            $data['plan'] = $post_array['plan_operativo'];
            $data['metas'] = $this->plan_operativo_model->get_metas_operativas($where);
            // print_r($this->db->last_query());die();
            $html = $this->load->view('modulo_planificacion/pla_plan_operativo/consultar_seguimiento', $data, true);
            echo json_encode(array('html' => $html));
            die();
        }
        $data['titulo_personal'] = "Seguimiento Mensual";
        cargarvista($data);
    }

    public function seguimiento_mensual($plan_op = 0, $area = 0, $met_id, $mes, $plan_unidad = null, $tipo_flujo = null, $periodo = nulll){
        $data['ruta_flujo'] = ($plan_unidad > 0) ? '/' . $plan_unidad . '/' . $tipo_flujo . '/' . $periodo : "";
        //Se obtiene la meta
        $data['meta'] = $this->plan_operativo_model->get_metas_operativas(array('met_id' => $met_id))[0];
        $data['plan_operativo'] = $this->plan_operativo_model->get_planes_operativos_unidad(array('pxu_id' => $data['meta']['met_id_pxu']))[0];
        $codigo_mes = ($mes < 10) ? $data['plan_operativo']['poa_anio'] . '0' . $mes : $data['plan_operativo']['poa_anio'] . $mes;
        $programacion_mes = $this->plan_operativo_model->get_programacion_meta(array('per_codigo' => $codigo_mes, 'prm_id_met' => $met_id))[0];
        if ($this->input->post()) {
            $post_array = $this->input->post();
            // die(var_dump($post_array));
            //Se obtiene el periodo
            $periodo = $this->gsatelite->get_tabla('per_periodo', array('per_codigo' => $codigo_mes))[0];
            //Anexos
            $TitulosAnexo = $post_array['titulo_doc'];
            $NombreAnexo = $post_array['ruta'];
            $seguimiento_resumen = $this->gsatelite->get_tabla('sgn_seguimiento_resumen_poa', array('sgn_id_per' => $periodo['per_id'], 'sgn_id_pxu' => $data['plan_operativo']['pxu_id']));
            $sgn_id = 0;
            $sgm_id = 0;
            if (count($seguimiento_resumen) == 0) {
                $flujos_parametro = json_decode($this->gsatelite->get_parametro("SYS_FLUJO_PLANIFICACION"), true);
                //Se ingresa primero el seguimiento resumen si no existe para el periodo
                $resumen_array = array(
                    'sgn_id_flu' => $flujos_parametro['POA']['SEGUIMIENTO'],
                    'sgn_id_per' => $periodo['per_id'],
                    'sgn_id_pxu' => $data['plan_operativo']['pxu_id'],
                    'sgn_fecha' => date('Y-m-d H:i:s'),
                    'sgn_estado' => 1,
                    'sgn_usu_creacion' => $this->tank_auth->get_user_id(),
                    'sgn_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sgn_fecha_creacion' => date('Y-m-d H:i:s'),
                    'sgn_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $sgn_id = $this->gsatelite->ingresar('sgn_seguimiento_resumen_poa', $resumen_array);
            } else {
                $sgn_id = $seguimiento_resumen[0]['sgn_id'];
            }
            $seguimiento_array = array(
                'sgm_id_prm' => $programacion_mes['prm_id'],
                'sgm_id_sgn' => $sgn_id,
                'sgm_ejecutado' => $post_array['txtEjecucion'],
                'sgm_monto_ejecutado' => ($post_array['txtMontoEjec'] != "") ? str_replace(',', '', $post_array['txtMontoEjec']) : 0,
                'sgm_descripcion' => $post_array['txtDescripcion'],
                'sgm_causa_atraso' => $post_array['txtCausa'],
                'sgm_estado' => 1,
                'sgm_usu_creacion' => $this->tank_auth->get_user_id(),
                'sgm_usu_modificacion' => $this->tank_auth->get_user_id(),
                'sgm_fecha_creacion' => date('Y-m-d H:i:s'),
                'sgm_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            //Si el seguimiento ya existe se actualiza
            if ($post_array['hdnSeguimiento'] > 0) {
                unset($seguimiento_array['sgm_id_sgn']);
                unset($seguimiento_array['sgm_estado']);
                unset($seguimiento_array['sgm_usu_creacion']);
                unset($seguimiento_array['sgm_fecha_creacion']);
                $sgm_id =  $post_array['hdnSeguimiento'];
                $this->gsatelite->actualizar_array('sgm_seguimiento_mensual', $seguimiento_array, array('sgm_id' => $post_array['hdnSeguimiento']));
            } else {
                $sgm_id =  $this->gsatelite->ingresar('sgm_seguimiento_mensual', $seguimiento_array);
            }
            //Anexos
            if (count($NombreAnexo) > 0) {
                for ($i = 0; $i < count($NombreAnexo); $i++) {
                    $extension = end(explode('.', $NombreAnexo[$i]));
                    $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);
                    $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);
                    $carpeta_destino_anx = "uploads/modulo_planificacion/anexo_seguimiento_mensual/" . $nombreArchivo;
                    $documentos_array = array(
                        'ang_id_sgm' => $sgm_id,
                        'ang_url' => $carpeta_destino_anx,
                        'ang_nombre' => $nombreArchivo,
                        'ang_estado' => 1,
                        'ang_usu_creacion' => $this->tank_auth->get_user_id(),
                        'ang_fecha_creacion' => date('Y-m-d H:i:s'),
                        'ang_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'ang_fecha_modificacion' => date('Y-m-d H:i:s'),
                    );
                    $nxp_id = $this->gsatelite->ingresar('ang_anexo_seguimiento', $documentos_array);
                    if ($nxp_id > 0) {
                        copy($carpeta_temporal_anx, $carpeta_destino_anx);
                        unlink($carpeta_temporal_anx);
                    }
                }
            }
            if ($sgn_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Seguimiento Mensual", 'texto_alerta' => "Información procesada correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Seguimiento Mensual", 'texto_alerta' => "Ocurrio un error, intentelo nuevamente.");
            }
            $this->session->set_flashdata($alerta);
            $btnCrear = $post_array['btnCrear'];
            $p = $post_array['filtro_plan'];
            $a = $post_array['filtro_area'];
            $m = $post_array['filtro_mes'];
            if ($btnCrear == 1) {
                redirect('modulo_planificacion/pla_plan_operativo/seguimiento_mensual/'.$p.'/'.$a.'/'.$met_id.'/'.$m.$data['ruta_flujo']);
            } else {
                redirect('modulo_planificacion/pla_plan_operativo/seguimiento/'.$p.'/'.$a.'/'.$m.$data['ruta_flujo']);
            }
        }
        //Se obtiene la programación acumulada de los otros meses
        $programacion_acumulada = $this->plan_operativo_model->get_programacion_meta(array('per_codigo <= ' . $codigo_mes => null, 'prm_id_met' => $met_id));
        $data['acumulada'] = array_sum(array_column($programacion_acumulada, 'prm_programa'));
        //Se obtiene el seguimiento del mes si existe.
        $data['seguimiento'] = $this->gsatelite->get_tabla('sgm_seguimiento_mensual', array('sgm_id_prm' => $programacion_mes['prm_id']));
        $data['programacion'] = $programacion_mes;
        $array_meses = get_array_meses();
        $data['mes'] = $mes;
        $data['area'] = $area;
        $data['plan'] = $plan_op;
        $data['mes_nombre'] = $array_meses[$mes];
        $data['titulo_personal'] = "Seguimiento Mensual";
        cargarvista($data);
    }

    public function reprogramacion($mes = null, $plan_ope = null, $registro_seg = null, $tipo_flujo = null)
    {

        satelite_validar();
        $data['plan_ope'] = ($plan_ope != null) ? $plan_ope : 0;
        $data['registro_seg'] = ($registro_seg != null) ? $registro_seg : 0;
        $data['tipo_flujo'] = ($tipo_flujo != null) ? $tipo_flujo : 0;
        $data['plan_operativo'] = $this->gsatelite->get_tabla('poa_plan_operativo', array('poa_estado' => 1));

        $data['ruta_flujo'] = ($plan_ope > 0) ? '/' . $plan_ope . '/' . $registro_seg . '/' . $tipo_flujo : "";
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array););

            $where = null;
            if ($post_array['plan_operativo'] != '') {
                $where['poa_id'] = $post_array['plan_operativo'];
            }

            if ($post_array['area'] != '') {
                $where['pxu_id_are'] = $post_array['area'];
            }
            $data['poa'] = $this->plan_operativo_model->get_planes_operativos_unidad(array('pxu_id_poa' => $post_array['plan_operativo']))[0];

            $data['codigo_mes'] = ($mes < 10) ? $data['poa']['poa_anio'] . '0' . $mes : $data['poa']['poa_anio'] . $mes;

            $data['mes'] = ($post_array['mes'] != '') ? $post_array['mes'] : 0;
            $data['metas'] = $this->plan_operativo_model->get_metas_operativas($where);

            $html = $this->load->view('modulo_planificacion/pla_plan_operativo/consultar_reprogramacion', $data, true);
            echo json_encode(array('html' => $html));
            die();
        }

        $data['titulo_personal'] = "Reprogramación";
        $data['mes'] = ($mes != '') ? $mes : 0;
        cargarvista($data);

    }

    public function reprogramacion_mensual($met_id, $mes = null, $plan_ope = null, $registro_seg = null, $tipo_flujo = null){
        $data['ruta_flujo'] = ($plan_ope > 0) ? '/' . $plan_ope . '/' . $registro_seg . '/' . $tipo_flujo : "";
        //Se obtiene la meta
        $data['meta'] = $this->plan_operativo_model->get_metas_operativas(array('met_id' => $met_id))[0];
        $data['plan_operativo'] = $this->plan_operativo_model->get_planes_operativos_unidad(array('pxu_id' => $data['meta']['met_id_pxu']))[0];

        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));

            //Se obtiene la reprogramacion encabezado si existe para este poa
            $reprogramacion_resumen = $this->gsatelite->get_tabla('rpr_reprogramacion_resumen', array('rpr_id_pxu' => $data['plan_operativo']['pxu_id']));

            $rpr_id = 0;
            //Si no existe se ingresa en la BD.
            if (count($reprogramacion_resumen) == 0) {
                $flujos_parametro = json_decode($this->gsatelite->get_parametro("SYS_FLUJO_PLANIFICACION"), true);
                $resumen_array = array(
                    'rpr_id_flu' => $flujos_parametro['POA']['REPROGRAMACION'],
                    'rpr_id_pxu' => $data['plan_operativo']['pxu_id'],
                    'rpr_fecha' => date('Y-m-d H:i:s'),
                    'rpr_observacion' => $post_array['txtObservaciones'],
                    'rpr_estado' => 1,
                    'rpr_usu_creacion' => $this->tank_auth->get_user_id(),
                    'rpr_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'rpr_fecha_creacion' => date('Y-m-d H:i:s'),
                    'rpr_fecha_modificacion' => date('Y-m-d H:i:s')
                );

                $rpr_id = $this->gsatelite->ingresar('rpr_reprogramacion_resumen', $resumen_array);
            } else {
                $rpr_id = $reprogramacion_resumen[0]['rpr_id'];
            }

            for ($i = 0; $i < count($post_array['hdnProgramaMes']); $i++) {
                $repro_array = array(
                    'rpd_id_rpr' => $rpr_id,
                    'rpd_id_prm' => $post_array['hdnProgramaMes'][$i],
                    'rpd_programacion_nueva' => $post_array['txtProgNueva'][$i],
                    'rpd_justificacion' => $post_array['txtJustificacion'][$i],
                    'rpd_estado' => 1,
                    'rpd_usu_creacion' => $this->tank_auth->get_user_id(),
                    'rpd_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'rpd_fecha_creacion' => date('Y-m-d H:i:s'),
                    'rpd_fecha_modificacion' => date('Y-m-d H:i:s')
                );

                if ($post_array['hdnReprogramaMes'][$i] > 0) {

                    unset($repro_array['rpd_id_prm']);
                    unset($repro_array['rpd_id_rpr']);
                    unset($repro_array['rpd_estado']);
                    unset($repro_array['rpd_usu_creacion']);
                    unset($repro_array['rpd_fecha_creacion']);

                    $this->gsatelite->actualizar_array('rpd_reprogramacion_detalle', $repro_array, array('rpd_id' => $post_array['hdnReprogramaMes'][$i]));
                } else {
                    $this->gsatelite->ingresar('rpd_reprogramacion_detalle', $repro_array);
                }
            }

            if ($rpr_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Reprogramación Mensual", 'texto_alerta' => "Información procesada correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Reprogramación Mensual", 'texto_alerta' => "Ocurrio un error, intentelo nuevamente.");
            }

            $this->session->set_flashdata($alerta);

            $btnCrear = $post_array['btnCrear'];
            if ($btnCrear == 1) {
                redirect('modulo_planificacion/pla_plan_operativo/reprogramacion_mensual/' . $met_id . '/' . $mes . $data['ruta_flujo']);
            } else {
                redirect('modulo_planificacion/pla_plan_operativo/reprogramacion/' . $data['ruta_flujo']);
            }
        }

        $data['mes'] = ($mes != '') ? $mes : 0;
        $data['meses'] = get_array_meses();
        //Se obtiene la programacion de la meta
        $data['programacion'] = $this->plan_operativo_model->get_programacion_meta(array('prm_id_met' => $met_id), 'per_codigo ASC');
        $data['titulo_personal'] = "Reprogramación Mensual";
        cargarvista($data);
    }

    public function solicitud_reprogramacion($mes = null, $plan_ope = null, $registro_seg = null, $tipo_flujo = null)
    {
        satelite_validar();
        $data['plan_ope'] = ($plan_ope != null) ? $plan_ope : 0;
        $data['registro_seg'] = ($registro_seg != null) ? $registro_seg : 0;
        $data['tipo_flujo'] = ($tipo_flujo != null) ? $tipo_flujo : 0;
        $data['plan_operativo'] = $this->gsatelite->get_tabla('poa_plan_operativo', array('poa_estado' => 1));

        $data['ruta_flujo'] = ($plan_ope > 0) ? '/' . $plan_ope . '/' . $registro_seg . '/' . $tipo_flujo : "";
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array););

            $where = null;
            if ($post_array['plan_operativo'] != '') {
                $where['poa_id'] = $post_array['plan_operativo'];
            }

            if ($post_array['area'] != '') {
                $where['pxu_id_are'] = $post_array['area'];
            }

            $data['poa'] = $this->plan_operativo_model->get_planes_operativos_unidad(array('pxu_id_poa' => $post_array['plan_operativo']))[0];
            $data['solicitudes'] = $this->plan_operativo_model->get_solicitudes_reprogramacion($where);

            $html = $this->load->view('modulo_planificacion/pla_plan_operativo/consultar_solicitud_repro', $data, true);
            echo json_encode(array('html' => $html));
            die();
        }

        $data['titulo_personal'] = "Solicitudes de Reprogramación";
        $data['mes'] = $mes;
        cargarvista($data);
    }

    public function agregar_solicitud_repro($mes = null, $plan_ope = null, $registro_seg = null, $tipo_flujo = null)
    {
        satelite_validar();
        $data['plan_ope'] = ($plan_ope != null) ? $plan_ope : 0;
        $data['registro_seg'] = ($registro_seg != null) ? $registro_seg : 0;
        $data['tipo_flujo'] = ($tipo_flujo != null) ? $tipo_flujo : 0;
        $data['plan_operativo'] = $this->gsatelite->get_tabla('poa_plan_operativo', array('poa_estado' => 1));

        $data['ruta_flujo'] = ($plan_ope > 0) ? '/' . $plan_ope . '/' . $registro_seg . '/' . $tipo_flujo : "";
        //$permisos = $this->gsatelite->get_permisos_opcion('usuarios', 'agregar');

        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            //Se busca el periodo asociado al Mes y año del poa.
            $periodo = null;
            if ($post_array['hdnPeriodo'] != '') {
                $periodo = $this->plan_estrategico_model->get_periodo_planificacion($post_array['hdnPeriodo'], 1);
            }

            $flujos_parametro = json_decode($this->gsatelite->get_parametro("SYS_FLUJO_PLANIFICACION"), true);

            $solicitud_array = array(
                'slr_id_pxu' => $post_array['hdnPlanOperativo'],
                'slr_id_per' => $periodo['per_id'],
                'slr_id_flu' => $flujos_parametro['POA']['SOLICITUD_REPRO'],
                'slr_fecha' => date('Y-m-d H:i:s'),
                'slr_id_usu' => $this->tank_auth->get_user_id(),
                'slr_justificacion' => $post_array['txtJustificacion'],
                'slr_comentarios' => $post_array['txtComentarios'],
                'slr_estado' => 1,
                'slr_usu_creacion' => $this->tank_auth->get_user_id(),
                'slr_fecha_creacion' => date('Y-m-d H:i:s'),
                'slr_usu_modificacion' => $this->tank_auth->get_user_id(),
                'slr_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $slr_id = $this->gsatelite->ingresar('slr_solicitud_reprogramacion', $solicitud_array);

            $alerta = array();
            if ($slr_id > 0) {
                if (count($post_array['hdnMeta']) > 0) {
                    //Se ingresan los roles
                    for ($i = 0; $i < count($post_array['hdnMeta']); $i++) {
                        $metas_array = array(
                            'mxs_id_slr' => $slr_id,
                            'mxs_id_met' => $post_array['hdnMeta'][$i],
                            'mxs_estado' => 1,
                            'mxs_usu_creacion' => $this->tank_auth->get_user_id(),
                            'mxs_fecha_creacion' => date('Y-m-d H:i:s'),
                            'mxs_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'mxs_usu_modificacion' => $this->tank_auth->get_user_id()
                        );

                        $this->gsatelite->ingresar('mxs_metasxsolicitud_reprogramacion', $metas_array);
                    }
                }

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Solicitud de Reprogramación", 'texto_alerta' => "Información procesada correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Solicitud de Reprogramación", 'texto_alerta' => "Ocurrio un problema intentelo de nuevo");
            }

            $this->session->set_flashdata($alerta);
            $btnCrear = $post_array['btnCrear'];
            if ($btnCrear == 1) {
                redirect('modulo_planificacion/pla_plan_operativo/agregar_solicitud_repro' . $data['ruta_flujo']);
            } else {
                redirect('modulo_planificacion/pla_plan_operativo/solicitud_reprogramacion' . $data['ruta_flujo']);
            }
            return false;
        }

        //$select = $this->gsatelite->get_dropdown('poa_plan_operativo', '{poa_nombre}', '', array('poa_estado' => '1'), null, '', 'poa_id', true);
        //$data['poa'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);

        $data['titulo_personal'] = "Agregar Solicitud Reprogramación";
        cargarvista($data);
    }

    public function editar_solicitud_repro($slr_id, $plan_ope = null, $registro_seg = null, $tipo_flujo = null)
    {
        satelite_validar();
        $data['plan_ope'] = ($plan_ope != null) ? $plan_ope : 0;
        $data['registro_seg'] = ($registro_seg != null) ? $registro_seg : 0;
        $data['tipo_flujo'] = ($tipo_flujo != null) ? $tipo_flujo : 0;
        $data['plan_operativo'] = $this->gsatelite->get_tabla('poa_plan_operativo', array('poa_estado' => 1));

        $data['ruta_flujo'] = ($plan_ope > 0) ? '/' . $plan_ope . '/' . $registro_seg . '/' . $tipo_flujo : "";
        //$permisos = $this->gsatelite->get_permisos_opcion('usuarios', 'agregar');

        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            //Se busca el periodo asociado al Mes y año del poa.
            $periodo = null;
            if ($post_array['hdnPeriodo'] != '') {
                $periodo = $this->plan_estrategico_model->get_periodo_planificacion($post_array['hdnPeriodo'], 1);
            }

            $solicitud_array = array(
                'slr_fecha' => date('Y-m-d H:i:s'),
                'slr_justificacion' => $post_array['txtJustificacion'],
                'slr_comentarios' => $post_array['txtComentarios'],
                'slr_usu_modificacion' => $this->tank_auth->get_user_id(),
                'slr_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $this->gsatelite->actualizar_array('slr_solicitud_reprogramacion', $solicitud_array, array('slr_id' => $slr_id));

            $alerta = array();
            if ($slr_id > 0) {
                if (count($post_array['hdnMeta']) > 0) {


                    //Se ingresan los nuevos
                    for ($i = 0; $i < count($post_array['hdnMeta']); $i++) {
                        $metas_array = array(
                            'mxs_id_slr' => $slr_id,
                            'mxs_id_met' => $post_array['hdnMeta'][$i],
                            'mxs_estado' => 1,
                            'mxs_usu_creacion' => $this->tank_auth->get_user_id(),
                            'mxs_fecha_creacion' => date('Y-m-d H:i:s'),
                            'mxs_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'mxs_usu_modificacion' => $this->tank_auth->get_user_id()
                        );

                        if ($post_array['hdnSeccion'][$i] == 0) {
                            $this->gsatelite->ingresar('mxs_metasxsolicitud_reprogramacion', $metas_array);
                        }
                    }
                }

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Solicitud de Reprogramación", 'texto_alerta' => "Información procesada correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Solicitud de Reprogramación", 'texto_alerta' => "Ocurrio un problema intentelo de nuevo");
            }

            $this->session->set_flashdata($alerta);
            $btnCrear = $post_array['btnCrear'];
            if ($btnCrear == 1) {
                redirect('modulo_planificacion/pla_plan_operativo/editar_solicitud_repro/' . $slr_id . $data['ruta_flujo']);
            } else {
                redirect('modulo_planificacion/pla_plan_operativo/solicitud_reprogramacion' . $data['ruta_flujo']);
            }
            return false;
        }

        $data['solicitud'] = $this->plan_operativo_model->get_solicitudes_reprogramacion(array('slr_id' => $slr_id))[0];
        $data['metas_solicitud'] = $this->plan_operativo_model->get_metas_solicitudes_reprogramacion(array('mxs_id_slr' => $slr_id));
        //$select = $this->gsatelite->get_dropdown('poa_plan_operativo', '{poa_nombre}', '', array('poa_estado' => '1'), null, '', 'poa_id', true);
        //$data['poa'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);

        $data['titulo_personal'] = "Editar Solicitud Reprogramación";
        cargarvista($data);
    }

    public function solicitud_modificacion($plan_ope = null, $registro_seg = null, $tipo_flujo = null)
    {
        satelite_validar();
        $data['plan_ope'] = ($plan_ope != null) ? $plan_ope : 0;
        $data['registro_seg'] = ($registro_seg != null) ? $registro_seg : 0;
        $data['tipo_flujo'] = ($tipo_flujo != null) ? $tipo_flujo : 0;
        $data['plan_operativo'] = $this->gsatelite->get_tabla('poa_plan_operativo', array('poa_estado' => 1));

        $data['ruta_flujo'] = ($plan_ope > 0) ? '/' . $plan_ope . '/' . $registro_seg . '/' . $tipo_flujo : "";
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array););

            $where = null;
            if ($post_array['plan_operativo'] != '') {
                $where['poa_id'] = $post_array['plan_operativo'];
            }

            if ($post_array['area'] != '') {
                $where['pxu_id_are'] = $post_array['area'];
            }

            $data['poa'] = $this->plan_operativo_model->get_planes_operativos_unidad(array('pxu_id_poa' => $post_array['plan_operativo']))[0];
            $data['solicitudes'] = $this->plan_operativo_model->get_solicitudes_reprogramacion($where);

            $html = $this->load->view('modulo_planificacion/pla_plan_operativo/consultar_solicitud_repro', $data, true);
            echo json_encode(array('html' => $html));
            die();
        }

        $data['titulo_personal'] = "Solicitudes de Reprogramación";
        cargarvista($data);
    }

    public function agregar_solicitud_modificacion($mes = null, $plan_ope = null, $registro_seg = null, $tipo_flujo = null)
    {
        satelite_validar();
        $data['plan_ope'] = ($plan_ope != null) ? $plan_ope : 0;
        $data['registro_seg'] = ($registro_seg != null) ? $registro_seg : 0;
        $data['tipo_flujo'] = ($tipo_flujo != null) ? $tipo_flujo : 0;
        $data['plan_operativo'] = $this->gsatelite->get_tabla('poa_plan_operativo', array('poa_estado' => 1));

        $data['ruta_flujo'] = ($plan_ope > 0) ? '/' . $plan_ope . '/' . $registro_seg . '/' . $tipo_flujo : "";
        //$permisos = $this->gsatelite->get_permisos_opcion('usuarios', 'agregar');

        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            //Se busca el periodo asociado al Mes y año del poa.
            $periodo = null;
            if ($post_array['hdnPeriodo'] != '') {
                $periodo = $this->plan_estrategico_model->get_periodo_planificacion($post_array['hdnPeriodo'], 1);
            }

            $flujos_parametro = json_decode($this->gsatelite->get_parametro("SYS_FLUJO_PLANIFICACION"), true);

            $solicitud_array = array(
                'slm_id_pxu' => $post_array['hdnPlanOperativo'],
                'slm_fecha' => date('Y-m-d H:i:s'),
                'slm_id_usu' => $this->tank_auth->get_user_id(),
                'slm_id_flu' => $flujos_parametro['POA']['SOLICITUD_REPRO'],
                'slm_justificacion' => $post_array['txtJustificacion'],
                'slm_comentarios' => $post_array['txtComentarios'],
                'slm_estado' => 1,
                'slm_usu_creacion' => $this->tank_auth->get_user_id(),
                'slm_fecha_creacion' => date('Y-m-d H:i:s'),
                'slm_usu_modificacion' => $this->tank_auth->get_user_id(),
                'slm_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $slr_id = $this->gsatelite->ingresar('slm_solicitud_modificacion', $solicitud_array);

            $alerta = array();
            if ($slr_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Solicitud de Reprogramación", 'texto_alerta' => "Información procesada correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Solicitud de Reprogramación", 'texto_alerta' => "Ocurrio un problema intentelo de nuevo");
            }

            $this->session->set_flashdata($alerta);
            $btnCrear = $post_array['btnCrear'];
            if ($btnCrear == 1) {
                redirect('modulo_planificacion/pla_plan_operativo/agregar_solicitud_modificacion' . $data['ruta_flujo']);
            } else {
                redirect('modulo_planificacion/pla_plan_operativo/solicitud_modificacion' . $data['ruta_flujo']);
            }
            return false;
        }

        //$select = $this->gsatelite->get_dropdown('poa_plan_operativo', '{poa_nombre}', '', array('poa_estado' => '1'), null, '', 'poa_id', true);
        //$data['poa'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);

        $data['titulo_personal'] = "Agregar Solicitud Modificación";
        cargarvista($data);
    }

    public function editar_solicitud_modificacion($slr_id, $plan_ope = null, $registro_seg = null, $tipo_flujo = null)
    {
        satelite_validar();
        $data['plan_ope'] = ($plan_ope != null) ? $plan_ope : 0;
        $data['registro_seg'] = ($registro_seg != null) ? $registro_seg : 0;
        $data['tipo_flujo'] = ($tipo_flujo != null) ? $tipo_flujo : 0;
        $data['plan_operativo'] = $this->gsatelite->get_tabla('poa_plan_operativo', array('poa_estado' => 1));

        $data['ruta_flujo'] = ($plan_ope > 0) ? '/' . $plan_ope . '/' . $registro_seg . '/' . $tipo_flujo : "";
        //$permisos = $this->gsatelite->get_permisos_opcion('usuarios', 'agregar');

        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            //Se busca el periodo asociado al Mes y año del poa.
            $periodo = null;
            if ($post_array['hdnPeriodo'] != '') {
                $periodo = $this->plan_estrategico_model->get_periodo_planificacion($post_array['hdnPeriodo'], 1);
            }

            $solicitud_array = array(
                'slm_fecha' => date('Y-m-d H:i:s'),
                'slm_justificacion' => $post_array['txtJustificacion'],
                'slm_comentarios' => $post_array['txtComentarios'],
                'slm_usu_modificacion' => $this->tank_auth->get_user_id(),
                'slm_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $this->gsatelite->actualizar_array('slm_solicitud_modificacion', $solicitud_array, array('slm_id' => $slr_id));

            $alerta = array();
            if ($slr_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Solicitud de Reprogramación", 'texto_alerta' => "Información procesada correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Solicitud de Reprogramación", 'texto_alerta' => "Ocurrio un problema intentelo de nuevo");
            }

            $this->session->set_flashdata($alerta);
            $btnCrear = $post_array['btnCrear'];
            if ($btnCrear == 1) {
                redirect('modulo_planificacion/pla_plan_operativo/editar_solicitud_modificacion/' . $slr_id . $data['ruta_flujo']);
            } else {
                redirect('modulo_planificacion/pla_plan_operativo/solicitud_modificacion' . $data['ruta_flujo']);
            }
            return false;
        }

        $data['solicitud'] = $this->plan_operativo_model->get_solicitudes_reprogramacion(array('slr_id' => $slr_id))[0];
        $data['metas_solicitud'] = $this->plan_operativo_model->get_metas_solicitudes_reprogramacion(array('mxs_id_slr' => $slr_id));
        //$select = $this->gsatelite->get_dropdown('poa_plan_operativo', '{poa_nombre}', '', array('poa_estado' => '1'), null, '', 'poa_id', true);
        //$data['poa'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);

        $data['titulo_personal'] = "Editar Solicitud Modificación";
        cargarvista($data);
    }

    //region Funciones Personalizadas
    public function get_codigo_meta($tipo_meta = null, $pxu_id = null, $return = false)
    {
        if ($this->input->post('tipo_meta') != '') {
            $post_array = $this->input->post();

            $tipo_meta = $post_array['tipo_meta'];
            $pxu_id = $post_array['plan_operativo'];
        }
        //Se cuentan las metas segun el tipo de meta
        $numero = $this->gsatelite->count('met_meta_operativa', array('met_id_pxu' => $pxu_id, 'met_tipo_meta' => $tipo_meta)) + 1;
        $codigo = "";

        if ($tipo_meta == 1) {
            $codigo = "IO";
        } else {
            $codigo = "IE";
        }

        $codigo .= ($numero < 10) ? "0" . $numero : $numero;
        if (!$return) {
            echo json_encode(array('codigo_meta' => $codigo));
        } else {
            return $codigo;
        }
    }

    public function get_metas_estra_plan(){
        if ($this->input->post()) {
            $post_array = $this->input->post();
            $pxu_id = $post_array['plan_operativo'];
            //Si se envia el Id se obtiene la seleccionada
            $aco_id = ($post_array['accion_estra'] != "") ? $post_array['accion_estra'] : null;
            //Se obtienen las metas que sean del tipo estrategicas para el POA, para excluir las ya asociadas
            $metas_estra = $this->gsatelite->get_tabla('met_meta_operativa', array('met_id_pxu' => $pxu_id, 'met_tipo_meta' => 2));
            $idsMetas_array = (count($metas_estra) > 0) ? array_column($metas_estra, 'met_id_aco') : array("0");
            if ($aco_id != null) {
                if (($key = array_search($aco_id, $idsMetas_array)) !== false) {
                    unset($idsMetas_array[$key]);
                }
            }
            $idsMetas = (count($idsMetas_array) > 0) ? implode(',', $idsMetas_array) : 0;
            $acciones_operativas = $this->plan_operativo_model->get_actividades_operativas_plan(
                array('pxu_id' => $pxu_id, 'aco_id NOT IN(' . $idsMetas . ')' => null),
                "aco_id",
                "aco_accion_operativa.aco_id AS registro,aco_accion_operativa.aco_nombre as nombre"
            );
            echo json_encode($acciones_operativas);
        }
    }

    public function get_metas_operativas()
    {
        if ($this->input->post()) {
            $post_array = $this->input->post();
            $pxu_id = $post_array['plan_operativo'];

            $metas = $this->gsatelite->get_tabla('met_meta_operativa', array('met_id_pxu' => $pxu_id));

            if (count($metas)) {
                //Se elimina el prefijo de la tabla
                foreach ($metas as $key => $value) {

                    foreach ($value as $key2 => $val) {
                        $partes = explode('_', $key2);
                        $metas[$key][str_replace($partes[0] . '_', '', $key2)] = $value[$key2];
                        unset($metas[$key][$key2]);
                    }
                }
            }


            echo json_encode($metas);
        }
    }

    public function get_datos_accion_operativa(){
        if ($this->input->post()) {
            $post_array = $this->input->post();
            $aco_id = $post_array['accion_ope'];
            $pxu_id = ($post_array['pxu_id'] > 0) ? $post_array['pxu_id'] : 0;
                        $this->db->join('poa_plan_operativo', 'poa_id = pxu_id_poa');
            $poa_year = $this->gsatelite->get_tabla('pxu_plan_operativoxunidad', array('pxu_id' => $pxu_id));
            $year = (count($poa_year) > 0) ? $poa_year[0]['poa_anio'] : 0;
            $accion_operativa = $this->plan_operativo_model->get_info_accion_operativa(array('aco_id' => $aco_id), $year);
            if (count($accion_operativa) > 0) {
                //Se elimina el prefijo de la tabla
                foreach ($accion_operativa as $key => $value) {
                    foreach ($value as $key2 => $val) {
                        $accion_operativa[$key][str_replace('aco_', '', $key2)] = $value[$key2];
                        unset($accion_operativa[$key][$key2]);
                    }
                }
                echo json_encode($accion_operativa[0]);
            }
        }
    }

    public function get_datos_plan_operativo()
    {
        if ($this->input->post()) {
            $post_array = $this->input->post();
            $poa_id = $post_array['plan_operativo'];
            $area_id = $post_array['area'];

            $plan_operativo = $this->plan_operativo_model->get_planes_operativos_unidad(array('pxu_id_poa' => $poa_id, 'pxu_id_are' => $area_id), "pxu_plan_operativoxunidad.*");

            if (count($plan_operativo)) {

                //Se elimina el prefijo de la tabla
                foreach ($plan_operativo as $key => $value) {

                    foreach ($value as $key2 => $val) {
                        $partes = explode('_', $key2);
                        $plan_operativo[$key][str_replace($partes[0] . '_', '', $key2)] = $value[$key2];
                        unset($plan_operativo[$key][$key2]);
                    }
                }

                echo json_encode($plan_operativo[0]);
            }
        }
    }
    //endregion

    public function get_objetivo_plan(){
        $select = '<option value=""></option>';
        $poa_id = ($this->input->post('plan') != "") ? $this->input->post('plan') : 0;
        $are_id = ($this->input->post('area') != "") ? $this->input->post('area') : null;
        $pxu_id = ($this->input->post('plan_operativo') != "") ? $this->input->post('plan_operativo') : null;
        if ($pxu_id) {
            $where['pxu_id'] = $pxu_id;
        } else {
            $where['pxu_id_poa'] = $poa_id;
            if ($are_id) {
                $where['pxu_id_are'] = $are_id;
            }
        }
        $planes = $this->gsatelite->get_tabla('pxu_plan_operativoxunidad', $where);
        if (count($planes) > 0) {
            $pxus = array_column($planes, 'pxu_id');
        } else {
            $pxus = array(0);
        }        
                $this->db->where_in('obo_id_pxu', $pxus);
        $objs = $this->gsatelite->get_tabla('obo_objetivo_operativo', array('obo_estado' => 1));
        foreach ($objs as $k => $v) {
            $sltd = ($v['obo_id'] == $obo_id) ? "selected" : "";
            $select .= '<option ' . $sltd . ' value="' . $v['obo_id'] . '">' . $v['obo_codigo'] . ' - ' . $v['obo_nombre'] . '</option>';
        }
        echo $select;
    }

}