<?php
/**
 * pla_plan_estrategico.php
 * Descripción:
 * Funcionalidad del sistema.
 *
 * @package ERP
 * @subpackage Modulo - Planificación (Plan Estrategico)
 * @copyright Copyright (c) 2018 Grupo Satélite S.A. DE C.V.
 * @author Mario Marquez - Grupo Satélite
 * @version 2020 - 1
 * @since Archivo disponible desde 2020-01-24
 */
if (!defined('BASEPATH'))
    exit('No direct script access allowed');


class Pla_plan_estrategico extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('plan_estrategico_model');
    }


    /**
     * Descripción:
     * Función para la vista index
     * @author Mario Marquez - Grupo Satélite
     * @since 2020-01-24
     */
    public function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    /**
     * Descripción:
     * Catalogo de Plan Estrategicos
     * @author Mario Marquez - Grupo Satélite
     * @since 2020-01-24
     * @param ninguno
     */
    function plan_estrategico()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {

                $permisos = $this->gsatelite->get_permisos_opcion('plan_estrategico');
                $flujos_parametro = json_decode($this->gsatelite->get_parametro("SYS_FLUJO_PLANIFICACION"), true);

                $add_fields = array(
                    'pes_codigo',
                    'pes_nombre',
                    'pes_id_tpl',
                    'pes_id_flu',
                    'pes_fecha_inicio',
                    'pes_fecha_fin',
                    'pes_observacion',
                    'pes_estado',
                    'pes_usu_creacion',
                    'pes_usu_modificacion',
                    'pes_fecha_creacion',
                    'pes_fecha_modificacion'
                );

                $edit_fields = array(
                    'pes_codigo',
                    'pes_nombre',
                    'pes_id_tpl',
                    'pes_fecha_inicio',
                    'pes_fecha_fin',
                    'pes_observacion',
                    'pes_estado',
                    'pes_usu_modificacion',
                    'pes_fecha_modificacion'
                );

                $display_as = array(
                    'pes_codigo' => "Código",
                    'pes_nombre' => 'Nombre',
                    'pes_fecha_inicio' => 'Fecha Inicio Periodo',
                    'pes_fecha_fin' => 'Fecha Fin Periodo',
                    'pes_id_tpl' => 'Tipo de Plan Estratégico',
                    'pes_observacion' => 'Observación',
                    'pes_estado' => 'Estado'
                );

                $required_fields = array(
                    'pes_codigo',
                    'pes_nombre',
                    'pes_id_tpl',
                    'pes_fecha_inicio',
                    'pes_fecha_fin',
                    'pes_estado',
                    'pes_usu_modificacion',
                    'pes_fecha_modificacion'
                );

                $columns = array(
                    'pes_codigo',
                    'pes_nombre',
                    'pes_id_tpl',
                    'pes_fecha_inicio',
                    'pes_fecha_fin'
                );

                $crud = new grocery_CRUD();
                $crud->set_table('pes_plan_estrategico');
                $crud->set_subject('Plan Estratégico');
                $crud->display_as($display_as);
                $crud->display_as('pes_estado', 'Estado');
                $crud->columns($columns);
                $crud->add_fields($add_fields);
                $crud->edit_fields($edit_fields);
                $crud->required_fields($required_fields);
                $crud->set_relation('pes_id_tpl', 'tpl_tipo_plan_estrategico', 'tpl_nombre', array('tpl_estado' => 1));
                $crud->set_rules('pes_nombre', 'Nombre', 'campo_unico[pes_plan_estrategico.pes_nombre]|required');
                $crud->field_type('pes_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('pes_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
                $crud->field_type('pes_id_flu', 'hidden', $flujos_parametro['PEI']['FORMULACION']);
                $crud->field_type('pes_fecha_inicio', 'string');
                $crud->field_type('pes_fecha_fin', 'string');
                $crud->callback_column('pes_fecha_inicio', function($value, $row) {
                    return ($value != '') ? '<span style="display: none;">'.formatear_fecha('Ymd', $value).'</span><span>'.formatear_fecha('d-m-Y', $value).'</span>' : '';
                });
                $crud->callback_column('pes_fecha_fin', function($value, $row) {
                    return ($value != '') ? '<span style="display: none;">'.formatear_fecha('Ymd', $value).'</span><span>'.formatear_fecha('d-m-Y', $value).'</span>' : '';
                });

                $crud->callback_edit_field('pes_fecha_inicio', function ($value, $primary_key) {
                    return '<input id="field-pes_fecha_inicio" name="pes_fecha_inicio" type="text" class="span12 text hasDatepicker" value="' . formatear_fecha('d-m-Y', $value) . '" autocomplete="off">';
                });
                $crud->callback_edit_field('pes_fecha_fin', function ($value, $primary_key) {
                    return '<input id="field-pes_fecha_fin" name="pes_fecha_fin" type="text" class="span12 text hasDatepicker" value="' . formatear_fecha('d-m-Y', $value) . '" autocomplete="off">';
                });
                $crud->callback_before_insert(function ($post_array) {
                    $post_array['pes_fecha_inicio'] = formatear_fecha('Y-m-d', $post_array['pes_fecha_inicio']);
                    $post_array['pes_fecha_fin'] = formatear_fecha('Y-m-d', $post_array['pes_fecha_fin']);

                    return $post_array;
                });

                $crud->callback_before_update(function ($post_array, $primary_key) {
                    $post_array['pes_fecha_inicio'] = formatear_fecha('Y-m-d', $post_array['pes_fecha_inicio']);
                    $post_array['pes_fecha_fin'] = formatear_fecha('Y-m-d', $post_array['pes_fecha_fin']);

                    return $post_array;
                });
                $data['pes_id'] = 0;
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('pes_estado', 'hidden', 1);
                    $crud->field_type('pes_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                    $crud->field_type('pes_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));

                } else {
                    $data['pes_id'] = end(explode('/', uri_string()));
                    $crud->field_type('pes_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                $crud->unset_export();
                $crud->unset_print();
                $url = explode('/', uri_string());

                // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                } else {
                    $crud->add_action('Línea estratégica', 'icon16 icomoon-icon-rock', 'modulo_planificacion/pla_plan_estrategico/linea_estrategica');
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                if ($permisos['permite_ver']) {
                    $crud->add_action('Ver', 'minia-icon-search', 'modulo_planificacion/pla_plan_estrategico/plan_estrategico/read');
                }

                $output = $crud->render();
                $data['titulo_personal'] = "Plan Estratégico";
                cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    function linea_estrategica($pes_id){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('modulo_planificacion/pla_plan_estrategico/plan_estrategico');
            $this->plan_estrategico = $this->gsatelite->get_tabla('pes_plan_estrategico', array('pes_id' => $pes_id))[0];
            $add_fields = array(
                'pie_id_pes',
                'pie_codigo',
                'pie_nombre',
                'pie_descripcion',
                'pie_estado',
                'pie_usu_creacion',
                'pie_usu_modificacion',
                'pie_fecha_creacion',
                'pie_fecha_modificacion'
            );

            $edit_fields = array(
                'pie_codigo',
                'pie_nombre',
                'pie_id_pes',
                'pie_descripcion',
                'pie_estado',
                'pie_usu_modificacion',
                'pie_fecha_modificacion'
            );

            $display_as = array(
                'pie_codigo' => "Código",
                'pie_nombre' => 'Nombre',
                'pie_id_pes' => 'Plan Estratégico',
                'pie_descripcion' => 'Observación',
                'pie_estado' => 'Estado'
            );

            $required_fields = array(
                'pie_codigo',
                'pie_nombre',
                'pie_id_pes',
                'pie_estado',
                'pie_usu_creacion',
                'pie_usu_modificacion',
                'pie_fecha_creacion',
                'pie_fecha_modificacion'
            );

            $columns = array(
                'pie_codigo',
                'pie_nombre',
                'pie_descripcion',
                'pie_estado'
            );

            $crud = new grocery_CRUD();
            $crud->set_table('pie_pilar_estrategico');
            $crud->set_subject('Línea Estratégica');
            $crud->display_as($display_as);
            $crud->columns($columns);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->required_fields($required_fields);
            $crud->where('pie_id_pes', $pes_id);
            $crud->field_type('pie_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('pie_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('pie_id_pes', 'hidden', $pes_id);
            $crud->set_rules('pie_codigo', 'Código', 'campo_unico2[pie_pilar_estrategico.pie_codigo.pie_id_pes.$pes_id]|required');

            $crud->callback_add_field('pie_codigo', function () {
                $count = $this->gsatelite->count('pie_pilar_estrategico', array('pie_id_pes' => $this->plan_estrategico['pes_id']));
                return '<input id="field-pie_codigo" name="pie_codigo" type="text" class="span12 text" value="LI' . ($count + 1) . '" maxlength="100" autocomplete="off">';
            });

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('pie_estado', 'hidden', 1);
                $crud->field_type('pie_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('pie_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $data['pes_id'] = end(explode('/', uri_string()));
                $crud->field_type('pie_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            $crud->unset_export();
            $crud->unset_print();
            $url = explode('/', uri_string());

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            } else {
                $crud->add_action('Obj. estratégico', 'icon16 icomoon-icon-target', 'modulo_planificacion/pla_plan_estrategico/objetivo_estrategico');
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                // $crud->add_action('Ver', 'minia-icon-search', 'modulo_planificacion/pla_plan_estrategico/linea_estrategica/read');
            }
            $output = $crud->render();
            $data['plan_estrategico'] = $this->plan_estrategico;
            $data['titulo_personal'] = "Línea Estratégica";
            cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function get_max_correl(){
        $tabla = $this->input->post('tabla');
        $donde = $this->input->post('donde');
        $valor = $this->input->post('valor');
        $count = $this->gsatelite->count($tabla, array($donde => $valor));//'', array('' => $this->plan_estrategico['pes_id'])
        echo (intval($count) + 1);
    }

    function objetivo_estrategico($pie_id){
        satelite_validar();
        try {

            $add_fields = array(
                'obe_id_pie',
                'obe_numero',
                'obe_nombre',
                'obe_descripcion',
                'obe_estado',
                'obe_usu_creacion',
                'obe_usu_modificacion',
                'obe_fecha_creacion',
                'obe_fecha_modificacion'
            );

            $edit_fields = array(
                'obe_numero',
                'obe_nombre',
                'obe_id_pie',
                'obe_descripcion',
                'obe_estado',
                'obe_usu_modificacion',
                'obe_fecha_modificacion'
            );

            $display_as = array(
                'obe_numero' => "Número",
                'obe_nombre' => 'Nombre',
                'obe_id_pie' => 'Linéa Estratégica',
                'obe_descripcion' => 'Observación',
                'obe_estado' => 'Estado'
            );

            $required_fields = array(
                'obe_numero',
                'obe_nombre',
                'obe_estado',
                'obe_usu_creacion',
                'obe_usu_modificacion',
                'obe_fecha_creacion',
                'obe_fecha_modificacion'
            );

            $columns = array(
                'obe_numero',
                'obe_nombre',
                'obe_descripcion',
                'obe_estado'
            );

            $crud = new grocery_CRUD();
            $crud->set_table('obe_objetivo_estrategico');
            $crud->set_subject('Objetivo Estratégico');
            $crud->display_as($display_as);
            $crud->columns($columns);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->required_fields($required_fields);
            $crud->where('obe_id_pie', $pie_id);
            $crud->field_type('obe_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('obe_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('obe_id_pie', 'hidden', $pie_id);
            $crud->set_rules('obe_numero', 'Número', 'campo_unico2[obe_objetivo_estrategico.obe_numero.obe_id_pie.$pie_id]|required');

            $permisos = $this->gsatelite->get_permisos_opcion('modulo_planificacion/pla_plan_estrategico/plan_estrategico');
            $linea_estrategica = $this->gsatelite->get_tabla('pie_pilar_estrategico', array('pie_id' => $pie_id))[0];
            $plan_estrategico = $this->gsatelite->get_tabla('pes_plan_estrategico', array('pes_id' => $linea_estrategica['pie_id_pes']))[0];

            $this->linea_estrategica = $linea_estrategica;
            $crud->callback_add_field('obe_numero', function () {
                $count = $this->gsatelite->count('obe_objetivo_estrategico', array('obe_id_pie' => $this->linea_estrategica['pie_id']));
                return '<input id="field-obe_numero" readonly="readonly" name="obe_numero" type="text" class="span12 text soloNumeros" value="' . ($count + 1) . '" maxlength="100" autocomplete="off">';
            });
            $crud->callback_add_field('obe_nombre', function () {
                return '<textarea id="field-obe_nombre" style="width: 100%;" name="obe_nombre" class="uniform soloPermitidos" maxlength="999"></textarea>';
            });
            $crud->callback_edit_field('obe_nombre', function ($value, $primary_key) {
                return '<textarea id="field-obe_nombre" style="width: 100%;" name="obe_nombre" class="uniform soloPermitidos" maxlength="999">'.$value.'</textarea>';
            });

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('obe_estado', 'hidden', 1);
                $crud->field_type('obe_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('obe_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $data['pes_id'] = end(explode('/', uri_string()));
                $crud->field_type('obe_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            $crud->unset_export();
            $crud->unset_print();
            $url = explode('/', uri_string());

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            } else {
                $crud->add_action('Acc. estratégica', 'icon16  icomoon-icon-clipboard-3', 'modulo_planificacion/pla_plan_estrategico/accion_estrategica');
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                // $crud->add_action('Ver', 'minia-icon-search', 'modulo_planificacion/pla_plan_estrategico/objetivo_estrategico/read');
            }

            $output = $crud->render();
            $data['plan_estrategico'] = $plan_estrategico;
            $data['linea_estrategica'] = $linea_estrategica;
            $data['titulo_personal'] = "Objetivo Estratégico";
            cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function accion_estrategica($obe_id){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('modulo_planificacion/pla_plan_estrategico/plan_estrategico');
            $obj_estrategico = $this->gsatelite->get_tabla('obe_objetivo_estrategico', array('obe_id' => $obe_id))[0];
            $linea_estrategica = $this->gsatelite->get_tabla('pie_pilar_estrategico', array('pie_id' => $obj_estrategico['obe_id_pie']))[0];
            $plan_estrategico = $this->gsatelite->get_tabla('pes_plan_estrategico', array('pes_id' => $linea_estrategica['pie_id_pes']))[0];

            $add_fields = array(
                'aca_id_obe',
                'aca_nombre',
                'aca_descripcion',
                'aca_estado',
                'aca_usu_creacion',
                'aca_usu_modificacion',
                'aca_fecha_creacion',
                'aca_fecha_modificacion'
            );

            $edit_fields = array(
                'aca_nombre',
                'aca_descripcion',
                'aca_estado',
                'aca_usu_modificacion',
                'aca_fecha_modificacion'
            );

            $display_as = array(
                'aca_nombre' => 'Nombre',
                'aca_id_obe' => 'Obj. Estratégico',
                'aca_descripcion' => 'Observación',
                'aca_estado' => 'Estado'
            );

            $required_fields = array(
                'aca_nombre',
                'aca_estado',
                'aca_id_obe',
                'aca_usu_creacion',
                'aca_usu_modificacion',
                'aca_fecha_creacion',
                'aca_fecha_modificacion'
            );

            $columns = array(
                'aca_nombre',
                'aca_descripcion',
                'aca_estado'
            );

            $crud = new grocery_CRUD();
            $crud->set_table('aca_accion_estrategica');
            $crud->set_subject('Acción Estratégica');
            $crud->display_as($display_as);
            $crud->columns($columns);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->where('aca_id_obe', $obe_id);
            $crud->required_fields($required_fields);
            $crud->field_type('aca_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('aca_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('aca_id_obe', 'hidden', $obe_id);

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('aca_estado', 'hidden', 1);
                $crud->field_type('aca_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('aca_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $data['pes_id'] = end(explode('/', uri_string()));
                $crud->field_type('aca_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            $crud->unset_export();
            $crud->unset_print();
            $url = explode('/', uri_string());

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            } else {
                $crud->add_action('Acc. Operativa', 'icon16  icomoon-icon-clipboard-3', 'modulo_planificacion/pla_plan_estrategico/accion_operativa');
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                unset_read();
                // $crud->add_action('Ver', 'minia-icon-search', 'modulo_planificacion/pla_plan_estrategico/accion_estrategica/read');
            }

            $output = $crud->render();
            $data['plan_estrategico'] = $plan_estrategico;
            $data['linea_estrategica'] = $linea_estrategica;
            $data['obj_estrategico'] = $obj_estrategico;
            $data['titulo_personal'] = "Acción Estratégica";
            cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function accion_operativa($aca_id){
        satelite_validar();
        try {

            $permisos = $this->gsatelite->get_permisos_opcion('modulo_planificacion/pla_plan_estrategico/plan_estrategico');
            $accion_estra = $this->gsatelite->get_tabla('aca_accion_estrategica', array('aca_id' => $aca_id))[0];
            $obj_estrategico = $this->gsatelite->get_tabla('obe_objetivo_estrategico', array('obe_id' => $accion_estra['aca_id_obe']))[0];
            $linea_estrategica = $this->gsatelite->get_tabla('pie_pilar_estrategico', array('pie_id' => $obj_estrategico['obe_id_pie']))[0];
            $plan_estrategico = $this->gsatelite->get_tabla('pes_plan_estrategico', array('pes_id' => $linea_estrategica['pie_id_pes']))[0];

            $display_as = array(
                'aco_nombre' => 'Nombre',
                'aco_id_aca' => 'Acc. Estratégica',
                'aco_entregable' => 'Entregable',
                'aco_unidad_program' => 'Unidades Prog.',
                'aco_fecha_inicio' => 'Fecha Inicio',
                'aco_fecha_fin' => 'Fecha Fin',
                'aco_estado' => 'Estado'
            );

            $columns = array(
                'aco_nombre',
                'aco_entregable',
                'aco_fecha_inicio',
                'aco_fecha_fin',
                'aco_unidad_program',
                'aco_estado'
            );

            $crud = new grocery_CRUD();
            $crud->set_table('aco_accion_operativa');
            $crud->set_subject('Acción Operativa');
            $crud->display_as($display_as);
            $crud->columns($columns);
            $crud->callback_column('aco_fecha_inicio', function($value, $row) {
                return ($value != '') ? '<span style="display: none;">'.formatear_fecha('Ymd', $value).'</span><span>'.formatear_fecha('d-m-Y', $value).'</span>' : '';
            });
            $crud->callback_column('aco_fecha_fin', function($value, $row) {
                return ($value != '') ? '<span style="display: none;">'.formatear_fecha('Ymd', $value).'</span><span>'.formatear_fecha('d-m-Y', $value).'</span>' : '';
            });
            $crud->where('aco_id_aca', $aca_id);

            $crud->unset_export();
            $crud->unset_print();
            $crud->unset_add();
            $crud->unset_edit();
            $crud->unset_read();
            $crud->field_type('aco_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->unset_delete();
            $url = explode('/', uri_string());

            // Validaciones
            if ($permisos['permite_editar']) {
                $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'modulo_planificacion/pla_plan_estrategico/editar_accion_operativa');
            }

            if ($permisos['permite_eliminar']) {
                $crud->add_action('Inactivar', 'icon16 icomoon-icon-remove btn-eliminar', 'modulo_planificacion/pla_plan_estrategico/inactivar_accion_operativa');
            }

            $output = $crud->render();
            $data['permisos'] = $permisos;
            $data['plan_estrategico'] = $plan_estrategico;
            $data['linea_estrategica'] = $linea_estrategica;
            $data['obj_estrategico'] = $obj_estrategico;
            $data['accion_estra'] = $accion_estra;
            $data['titulo_personal'] = "Acción Operativa";
            cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }


    function agregar_accion_operativa($aca_id){
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            $accion_ope = array(
                'aco_id_aca' => $aca_id,
                'aco_nombre' => $post_array['txtAccionOperativa'],
                'aco_unidad_program' => $post_array['txtUnidadesMet'],
                'aco_entregable' => $post_array['txtEntregable'],
                'aco_descripcion' => $post_array['txtDescripcion'],
                'aco_fecha_inicio' => formatear_fecha('Y-m-d', $post_array['txtFechaInicio']),
                'aco_fecha_fin' => formatear_fecha('Y-m-d', $post_array['txtFechaFin']),
                'aco_estado' => 1,
                'aco_usu_creacion' => $this->tank_auth->get_user_id(),
                'aco_usu_modificacion' => $this->tank_auth->get_user_id(),
                'aco_fecha_creacion' => date('Y-m-d H:i:s'),
                'aco_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $aco_id = $this->gsatelite->ingresar('aco_accion_operativa', $accion_ope);

            if ($aco_id > 0) {

                //Se ingresan los responsables de la Acción
                if (count($post_array['slcResponsable']) > 0) {
                    for ($i = 0; $i < count($post_array['slcResponsable']); $i++) {
                        $responsable_array = array(
                            "reo_id_aco" => $aco_id,
                            "reo_id_plz" => $post_array['slcResponsable'][$i],
                            "reo_estado" => 1,
                            "reo_usu_creacion" => $this->tank_auth->get_user_id(),
                            "reo_usu_modificacion" => $this->tank_auth->get_user_id(),
                            "reo_fecha_creacion" => date('Y-m-d H:i:s'),
                            "reo_fecha_modificacion" => date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('reo_responsable_actividad_ope', $responsable_array);
                    }
                }

                //Se ingresan los participantes
                if (count($post_array['slcParticipantes']) > 0) {
                    for ($i = 0; $i < count($post_array['slcParticipantes']); $i++) {
                        $participante_array = array(
                            "pao_id_aco" => $aco_id,
                            "pao_id_plz" => $post_array['slcParticipantes'][$i],
                            "pao_estado" => 1,
                            "pao_usu_creacion" => $this->tank_auth->get_user_id(),
                            "pao_usu_modificacion" => $this->tank_auth->get_user_id(),
                            "pao_fecha_creacion" => date('Y-m-d H:i:s'),
                            "pao_fecha_modificacion" => date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('pao_participante_accion_ope', $participante_array);
                    }
                }

                //Se ingresan las programaciones
                if (count($post_array['hdnFila']) > 0) {
                    for ($i = 0; $i < count($post_array['hdnFila']); $i++) {

                        //Se busca el año en la tabla de periodos, si existe se usa el id sino se ingresaa
                        $periodo = $this->plan_estrategico_model->get_periodo_planificacion($post_array['hdnAnio'][$i], 2);

                        $participante_array = array(
                            "pxn_id_aco" => $aco_id,
                            "pxn_id_per" => $periodo['per_id'],
                            "pxn_porcentaje" => $post_array['hdnPorcentaje'][$i],
                            "pxn_programa" => $post_array['hdnUnidades'][$i],
                            "pxn_asignacion" => $post_array['hdnMontoAsig'][$i],
                            "pxn_fecha_inicio" => formatear_fecha('Y-m-d H:i:s', $post_array['hdnFechaDesde'][$i]),
                            "pxn_fecha_fin" => formatear_fecha('Y-m-d H:i:s', $post_array['hdnFechaHasta'][$i]),
                            "pxn_estado" => 1,
                            "pxn_usu_creacion" => $this->tank_auth->get_user_id(),
                            "pxn_usu_modificacion" => $this->tank_auth->get_user_id(),
                            "pxn_fecha_creacion" => date('Y-m-d H:i:s'),
                            "pxn_fecha_modificacion" => date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('pxn_periodoxaccion_operativa', $participante_array);
                    }
                }
            }
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Acción Operativa", 'texto_alerta' => "Registro creado correctamente");
            $this->session->set_flashdata($alerta);

            $btnCrear = $post_array['btnCrear'];
            if ($btnCrear == 1) {
                redirect('modulo_planificacion/pla_plan_estrategico/accion_operativa/' . $aca_id);
            } else {
                redirect('modulo_planificacion/pla_plan_estrategico/agregar_accion_operativa/' . $aca_id);
            }
        }

        $accion_estra = $this->gsatelite->get_tabla('aca_accion_estrategica', array('aca_id' => $aca_id))[0];
        $obj_estrategico = $this->gsatelite->get_tabla('obe_objetivo_estrategico', array('obe_id' => $accion_estra['aca_id_obe']))[0];
        $linea_estrategica = $this->gsatelite->get_tabla('pie_pilar_estrategico', array('pie_id' => $obj_estrategico['obe_id_pie']))[0];
        $plan_estrategico = $this->gsatelite->get_tabla('pes_plan_estrategico', array('pes_id' => $linea_estrategica['pie_id_pes']))[0];

        $this->db->join('pto_puesto', 'pto_id = plz_id_pto', 'inner');
        $select = $this->gsatelite->get_dropdown('plz_plaza', '{pto_nombre} - {plz_nombre}', '', array('plz_estado' => '1'), null, '', 'plz_id', true);

        $data['puestos'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);

        $data['plan_estrategico'] = $plan_estrategico;
        $data['linea_estrategica'] = $linea_estrategica;
        $data['obj_estrategico'] = $obj_estrategico;
        $data['accion_estra'] = $accion_estra;
        $data['titulo_personal'] = "Agregar Acción Operativa";

        cargarvista($data);
    }

    function editar_accion_operativa($aco_id)
    {
        satelite_validar();
        //Se obtiene la programación de la acción
        $data['programacion_accion'] = $this->plan_estrategico_model->get_programacion_accion_operativa(array('pxn_id_aco' => $aco_id));
        //Se obtiene la accion operativa
        $aco_array = $this->gsatelite->get_tabla('aco_accion_operativa', array('aco_id' => $aco_id))[0];
        $aca_id = $aco_array['aco_id_aca'];

        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            $accion_ope = array(
                'aco_nombre' => $post_array['txtAccionOperativa'],
                'aco_unidad_program' => $post_array['txtUnidadesMet'],
                'aco_entregable' => $post_array['txtEntregable'],
                'aco_descripcion' => $post_array['txtDescripcion'],
                'aco_fecha_inicio' => formatear_fecha('Y-m-d', $post_array['txtFechaInicio']),
                'aco_fecha_fin' => formatear_fecha('Y-m-d', $post_array['txtFechaFin']),
                'aco_estado' => 1,
                'aco_usu_creacion' => $this->tank_auth->get_user_id(),
                'aco_usu_modificacion' => $this->tank_auth->get_user_id(),
                'aco_fecha_creacion' => date('Y-m-d H:i:s'),
                'aco_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $this->gsatelite->actualizar_array('aco_accion_operativa', $accion_ope, array('aco_id' => $aco_id));

            if ($aco_id > 0) {

                //Se eliminan los responsables y se vuelven a ingresar nuevamente.
                $this->gsatelite->borrado_general('reo_responsable_actividad_ope', array('reo_id_aco' => $aco_id));

                //Se ingresan los responsables de la Acción
                if (count($post_array['slcResponsable']) > 0) {
                    for ($i = 0; $i < count($post_array['slcResponsable']); $i++) {
                        $responsable_array = array(
                            "reo_id_aco" => $aco_id,
                            "reo_id_plz" => $post_array['slcResponsable'][$i],
                            "reo_estado" => 1,
                            "reo_usu_creacion" => $this->tank_auth->get_user_id(),
                            "reo_usu_modificacion" => $this->tank_auth->get_user_id(),
                            "reo_fecha_creacion" => date('Y-m-d H:i:s'),
                            "reo_fecha_modificacion" => date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('reo_responsable_actividad_ope', $responsable_array);
                    }
                }

                //Se eliminan los participantes y se vuelven a ingresar nuevamente.
                $this->gsatelite->borrado_general('pao_participante_accion_ope', array('pao_id_aco' => $aco_id));

                //Se ingresan los participantes
                if (count($post_array['slcParticipantes']) > 0) {
                    for ($i = 0; $i < count($post_array['slcParticipantes']); $i++) {
                        $participante_array = array(
                            "pao_id_aco" => $aco_id,
                            "pao_id_plz" => $post_array['slcParticipantes'][$i],
                            "pao_estado" => 1,
                            "pao_usu_creacion" => $this->tank_auth->get_user_id(),
                            "pao_usu_modificacion" => $this->tank_auth->get_user_id(),
                            "pao_fecha_creacion" => date('Y-m-d H:i:s'),
                            "pao_fecha_modificacion" => date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('pao_participante_accion_ope', $participante_array);
                    }
                }

                //Se borran las programaciones que ya no existen
                foreach($data['programacion_accion'] as $pro){
                    if(count($post_array['hdnFila']) > 0){
                        if(!in_array($pro['pxn_id'], $post_array['hdnFila'])){
                            //Se elimina la programación que no esta dentro del POST
                            $this->gsatelite->borrado_general('pxn_periodoxaccion_operativa', array('pxn_id' => $pro['pxn_id']));
                        }
                    }
                }

                //Se ingresan las programaciones
                if (count($post_array['hdnFila']) > 0) {

                    for ($i = 0; $i < count($post_array['hdnFila']); $i++) {

                        //Se busca el año en la tabla de periodos, si existe se usa el id sino se ingresaa
                        $periodo = $this->plan_estrategico_model->get_periodo_planificacion($post_array['hdnAnio'][$i], 2);

                        //Si la fila es Mayor a 0 se actualiza, sino se ingresa.

                        $participante_array = array(
                            "pxn_id_aco" => $aco_id,
                            "pxn_id_per" => $periodo['per_id'],
                            "pxn_porcentaje" => $post_array['hdnPorcentaje'][$i],
                            "pxn_programa" => $post_array['hdnUnidades'][$i],
                            "pxn_asignacion" => $post_array['hdnMontoAsig'][$i],
                            "pxn_fecha_inicio" => formatear_fecha('Y-m-d H:i:s', $post_array['hdnFechaDesde'][$i]),
                            "pxn_fecha_fin" => formatear_fecha('Y-m-d H:i:s', $post_array['hdnFechaHasta'][$i]),
                            "pxn_estado" => 1,
                            "pxn_usu_creacion" => $this->tank_auth->get_user_id(),
                            "pxn_usu_modificacion" => $this->tank_auth->get_user_id(),
                            "pxn_fecha_creacion" => date('Y-m-d H:i:s'),
                            "pxn_fecha_modificacion" => date('Y-m-d H:i:s')
                        );

                        if($post_array['hdnFila'][$i] > 0){
                            unset($participante_array['pxn_usu_creacion']);
                            unset($participante_array['pxn_fecha_creacion']);
                            unset($participante_array['pxn_id_aco']);
                            unset($participante_array['pxn_id_per']);
                            $this->gsatelite->actualizar_array('pxn_periodoxaccion_operativa', $participante_array, array('pxn_id' => $post_array['hdnFila'][$i]));
                        }
                        else{
                            $this->gsatelite->ingresar('pxn_periodoxaccion_operativa', $participante_array);
                        }
                    }
                }
            }
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Acción Operativa", 'texto_alerta' => "Registro creado correctamente");
            $this->session->set_flashdata($alerta);

            $btnCrear = $post_array['btnCrear'];
            if ($btnCrear == 1) {
                redirect('modulo_planificacion/pla_plan_estrategico/editar_accion_operativa/' . $aco_id);
            } else {
                redirect('modulo_planificacion/pla_plan_estrategico/accion_operativa/' . $aca_id);
            }
        }


        $responsables_aco = $this->gsatelite->get_tabla('reo_responsable_actividad_ope', array('reo_id_aco' => $aco_id));
        $participantes_aco = $this->gsatelite->get_tabla('pao_participante_accion_ope', array('pao_id_aco' => $aco_id));

        $reo_ids = array_column($responsables_aco, 'reo_id_plz');
        $pao_ids = array_column($participantes_aco, 'pao_id_plz');

        $accion_estra = $this->gsatelite->get_tabla('aca_accion_estrategica', array('aca_id' => $aca_id))[0];
        $obj_estrategico = $this->gsatelite->get_tabla('obe_objetivo_estrategico', array('obe_id' => $accion_estra['aca_id_obe']))[0];
        $linea_estrategica = $this->gsatelite->get_tabla('pie_pilar_estrategico', array('pie_id' => $obj_estrategico['obe_id_pie']))[0];
        $plan_estrategico = $this->gsatelite->get_tabla('pes_plan_estrategico', array('pes_id' => $linea_estrategica['pie_id_pes']))[0];

        $this->db->join('pto_puesto', 'pto_id = plz_id_pto', 'inner');
        $select = $this->gsatelite->get_dropdown('plz_plaza', '{pto_nombre} - {plz_nombre}', '', array('plz_estado' => '1'), $reo_ids, '', 'plz_id', true);

        $data['puestos_responsanbles'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);

        $this->db->join('pto_puesto', 'pto_id = plz_id_pto', 'inner');
        $select = $this->gsatelite->get_dropdown('plz_plaza', '{pto_nombre} - {plz_nombre}', '', array('plz_estado' => '1'), $pao_ids, '', 'plz_id', true);

        $data['puestos_participantes'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);

        $data['plan_estrategico'] = $plan_estrategico;
        $data['linea_estrategica'] = $linea_estrategica;
        $data['obj_estrategico'] = $obj_estrategico;
        $data['accion_estra'] = $accion_estra;
        $data['titulo_personal'] = "Agregar Acción Operativa";
        $data['accion_operativa'] = $aco_array;
        cargarvista($data);
    }

    public function inactivar_accion_operativa($aco_id){

        if($aco_id > 0){

            $accion_operativa = $this->gsatelite->get_tabla('aco_accion_operativa', array('aco_id' => $aco_id))[0];


            $accion_array = array(
                'aco_estado' => 0,
                'aco_usu_modificacion' => $this->tank_auth->get_user_id(),
                'aco_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $this->gsatelite->actualizar_array('aco_accion_operativa', $accion_array, array('aco_id' => $aco_id));

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Acción Operativa", 'texto_alerta' => "Registro anulado correctamente");
            $this->session->set_flashdata($alerta);
            redirect('modulo_planificacion/pla_plan_estrategico/accion_operativa/'.$accion_operativa['aco_id_aca']);
        }
        else{
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Acción Operativa", 'texto_alerta' => "El registro no existe.");
            $this->session->set_flashdata($alerta);
            redirect('/');
        }

    }
}