<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Pla_mantenimiento extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

     /**
     * @author Mario Marquez
     * @return mantenimiento de rangos de evaluacion de PEI
     * @since 15-08-2020
     */
    function evaluacion_pei() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();

        $add = array(
            'evs_nombre',
            'evs_rango_inicio',
            'evs_rango_fin',
            'evs_color',
            'evs_estado',
            'evs_usu_modificacion',
            'evs_fecha_modificacion',
            'evs_usu_creacion',
            'evs_fecha_creacion'
        );

        $edit = array(
            'evs_nombre',
            'evs_rango_inicio',
            'evs_rango_fin',
            'evs_color',
            'evs_estado',
            'evs_usu_modificacion',
            'evs_fecha_modificacion'
        );

        $column = array(
            'evs_nombre',
            'evs_rango_inicio',
            'evs_rango_fin',
            'evs_color'
        );

        $display = array(
            'evs_nombre' => 'Nombre',
            'evs_rango_inicio' => 'Rango Inicio',
            'evs_rango_fin' => 'Rango Fin',
            'evs_color' => 'Color',
            'evs_estado' => 'Estado'
        );

        $requeridos = array(
            'evs_nombre',
            'evs_rango_inicio',
            'evs_rango_fin',
            'evs_color',
            'evs_estado'
        );

        $crud->set_table('evs_evaluacion_meta_estrategica')
                ->set_subject('Rangos de Evaluación PEI')
                ->columns($column)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($requeridos)
                ->display_as($display)
                ->field_type('evs_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('evs_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('evs_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('evs_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('evs_nombre', 'Nombre', 'trim|required|campo_unico[evs_evaluacion_meta_estrategica.evs_nombre]')
        ;

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('evs_estado', 'hidden', 1);
        } else {
            $crud->field_type('evs_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }

        $data['titulo_personal'] = "Rangos de Evaluación PEI";

        $output = $crud->render();
        cargarvista($data, $output);
    }

}