<?php
/**
 * Created by PhpStorm.
 * User: mario.marquez
 * Date: 20/4/2020
 * Time: 13:11
 */

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Pla_inicio extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('plan_estrategico_model');
        $this->load->model('configuracion_model');
        $this->load->model('plan_operativo_model');
        $this->load->library('texto');
    }


    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function tareas_pendientes($consulta=0){
        satelite_validar();
        if($_POST){
            if($consulta!=0){
                $post_array = $_POST;
                $html = "";

                $tipo_solicitud = $post_array['tipo'];
                $where_general  = array('requisiciones', 'ordenes');
                //$fecha_inicio   = ($post_array['fecha_ini'] != '') ? $post_array['fecha_ini'] : null;
                //$fecha_fin      = ($post_array['fecha_fin'] != '') ? $post_array['fecha_fin'] : null;
                $slc_sucursal   = ($post_array['slc_sucursal'] != '') ? $post_array['slc_sucursal'] : null;


                /*if ($fecha_inicio != null && $fecha_fin != null) {
                    $where_general['requisiciones']['DATE(rxi_fecha) >=']   = date('Y-m-d', strtotime($fecha_inicio));
                    $where_general['requisiciones']['DATE(rxi_fecha) <=']   = date('Y-m-d', strtotime($fecha_fin));

                    $where_general['ordenes']['DATE(orc_fecha_orden) >=']   = date('Y-m-d', strtotime($fecha_inicio));
                    $where_general['ordenes']['DATE(orc_fecha_orden) <=']   = date('Y-m-d', strtotime($fecha_fin));

                    $where_general['comparativo']['DATE(ccc_fecha) >=']     = date('Y-m-d', strtotime($fecha_inicio));
                    $where_general['comparativo']['DATE(ccc_fecha) <=']     = date('Y-m-d', strtotime($fecha_fin));
                }*/

                if ($slc_sucursal != '' or $slc_sucursal != null) {
                    $where_general['formulacion']["pxu_id_are"] = $slc_sucursal;
                    $where_general['seguimiento']["pxu_id_are"] = $slc_sucursal;
                    $where_general['reprogramacion']["pxu_id_are"] = $slc_sucursal;
                    $where_general['modificacion']["pxu_id_are"] = $slc_sucursal;
                    $where_general['solicitud']["pxu_id_are"] = $slc_sucursal;
                }

                $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
                $flujos_array = json_decode($flujos, true);

                $roles_jefes = explode(",", $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD',0) );
                $mis_roles   = $this->gsatelite->get_tabla("uxr_usuarioxrol",array("uxr_id_usu" => $this->tank_auth->get_user_id()) );
                $permiso_rol = false;

                foreach ($mis_roles as $rol) {
                    if ( in_array($rol["uxr_id_rol"], $roles_jefes) ) {
                        $permiso_rol = true;
                    }
                }

                $where_general['formulacion']['sgf_fecha_salida'] = null;
                $where_general['seguimiento']['sgp_fecha_salida']       = null;
                $where_general['reprogramacion']['spr_fecha_entrada']   = null;
                $where_general['modificacion']['sgf_fecha_salida']   = null;

                //$where_general['solicitud']['scm_fecha_salida']   = null;

                $backlog = $this->configuracion_model->get_backlog_planificacion($where_general,$tipo_solicitud);
                $data['listado'] = $backlog;

                $html = $this->load->view('modulo_planificacion/pla_inicio/consultar_tareas', $data, true);

                echo $html;
                die();
            }
        } else {
            $data['titulo_personal'] = "Aprobaciones";
            cargarvista($data);
        }
    }

    /*
     * tipo flujo: 1- Requisiciones, 2- Orden de Compra.
     */
    function paso_siguiente($iframe = false,$registro,$tipo_flujo){

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($_POST){
                //var_dump($_POST);die();
                $post_array = $_POST;
                $paso_actual = $post_array['hdnActualPaso'];
                $paso_siguiente = $post_array['hdnSigPaso'];
                $txtComentario = $post_array['txtComentario'];

                //Se cierra el paso actual y se ingresa el siguiente paso si existe
                switch ($tipo_flujo) {
                    case 1:
                        //Se cierra el paso actual
                        $seguimiento_anterior = array(
                            'sgf_usu_cierra' => $this->tank_auth->get_user_id(),
                            'sgf_observacion' => $txtComentario,
                            'sgf_fecha_salida' => date('Y-m-d H:i:s'),
                            'sgf_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sgf_fecha_modificacion' => date('Y-m-d h:i:s')
                        );

                        $this->gsatelite->actualizar_array('sgf_seguim_formulacion', $seguimiento_anterior,array('sgf_id'=>$paso_actual));

                        //Si existe un siguiente paso se ingresa
                        if ($paso_siguiente > 0){
                            $seguimiento_array = array(
                                'sgf_id_pxu' => $registro,
                                'sgf_id_psf' => $paso_siguiente,
                                'sgf_usu_apertura' => $this->tank_auth->get_user_id(),
                                'sgf_fecha_entrada' => date('Y-m-d H:i:s'),
                                'sgf_estado' => 1,
                                'sgf_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sgf_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sgf_fecha_creacion' => date('Y-m-d h:i:s'),
                                'sgf_fecha_modificacion' => date('Y-m-d h:i:s')
                            );

                            $seguimiento = $this->gsatelite->ingresar('sgf_seguim_formulacion', $seguimiento_array);
                        }
                        break;
                }

                $this->configuracion_model->ingresar_paso_siguiente($registro, $tipo_flujo, $paso_actual, $paso_siguiente, $txtComentario);

                //Si es iframe se enviar un parametro para cerrar el modal
                //Sino se redirecciona a la url configurada
                if($iframe==1){
                    $data['cerrar_modal'] = 1;
                    $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                }
                else{
                    $redireccionar = $post_array['redireccion'];
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                    $this->session->set_flashdata($alerta);
                    redirect($redireccionar);
                }
            }
            $data['titulo_personal'] = "Siguiente Paso";
            $data['iframe'] = $iframe;
            $data['registro'] = $registro;
            $data['tipo_flujo'] = $tipo_flujo;

            switch ($tipo_flujo) {
                case 1:

                    $plan_operativo = $this->plan_operativo_model->get_planes_operativos_unidad(array('pxu_id' => $registro));

                    $data['nombre_registro'] = $plan_operativo[0]['poa_nombre'].' - '.$plan_operativo[0]['are_nombre'];
                    $data['titulo_registro'] = "Plan:";
                    break;
                case 2:

                    $this->db->join('sgn_seguimiento_resumen_poa', 'sgn_id_pxu = pxu_id','inner');
                    $plan_operativo = $this->plan_operativo_model->get_planes_operativos_unidad(array('sgn_id' => $registro));

                    $data['nombre_registro'] = $plan_operativo[0]['poa_nombre'].' - '.$plan_operativo[0]['are_nombre'];
                    $data['titulo_registro'] = "Plan:";
                    break;
            }

            $paso_actual = $this->configuracion_model->get_paso_actual_planificacion($registro,$tipo_flujo);
            $paso_siguiente = $this->configuracion_model->get_paso_siguiente_planificacion($registro,$tipo_flujo);

            $data['paso_actual'] = $paso_actual[0];
            $data['paso_siguiente'] = $paso_siguiente[0];

            if ($iframe) {
                $this->gsatelite->cargar_vista_masterpage('modulo_planificacion/pla_inicio/finalizar_paso',$data);
            } else {
                $this->_cargarvista($data);
            }
        }
    }

    function regresar_paso($iframe = false,$registro,$tipo_flujo){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($_POST){
                $post_array     = $_POST;
                //var_dump($post_array);die();
                $paso_actual    = $post_array['hdnActualPaso'];
                $paso_anterior  = $post_array['hdnAntPaso'];
                $txtComentario  = $post_array['txtComentario'];

                $this->configuracion_model->regresar_paso($registro, $tipo_flujo, $paso_actual, $paso_anterior, $txtComentario);

                //Si es iframe se enviar un parametro para cerrar el modal
                //Sino se redirecciona a la url configurada
                if($iframe==1){
                    $data['cerrar_modal'] = 1;
                    $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                }
                else{
                    $redireccionar = $post_array['redireccion'];
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                    $this->session->set_flashdata($alerta);
                    redirect($redireccionar);
                }
            }
            $data['titulo_personal']= "Regresar(Rechazar)";
            $data['iframe']         = $iframe;
            $data['registro']       = $registro;
            $data['tipo_flujo']     = $tipo_flujo;

            $paso_actual            = $this->configuracion_model->get_paso_actual_planificacion($registro,$tipo_flujo);
            $paso_anterior          = $this->configuracion_model->get_paso_anterior($registro,$tipo_flujo);
            $data['paso_actual']    = $paso_actual[0];
            $data['paso_anterior']  = $paso_anterior[0];
            $data['paso_actual_id'] =  $paso_actual[0]['id_seguimiento'];
            $data['titulo_registro'] = "Plan:";
            switch ($tipo_flujo) {
                case 1:
                    $plan_operativo = $this->plan_operativo_model->get_planes_operativos_unidad(array('pxu_id' => $registro));
                    $data['nombre_registro'] = $plan_operativo[0]['poa_nombre'].' - '.$plan_operativo[0]['are_nombre'];

                    break;
                case 2:

                    break;
                case 4:

                    break;
            }

            if ($iframe) {
                $this->gsatelite->cargar_vista_masterpage('modulo_planificacion/pla_inicio/regresar_paso',$data);
            } else {
                $this->_cargarvista($data);
            }
        }
    }

    function historial_pasos($iframe = 0, $registro = null, $tipo_flujo = null){
        satelite_validar();

        $data['iframe'] = $iframe;
        $data['registro'] = $registro;
        $data['tipo_flujo'] = $tipo_flujo;

        $historial = $this->configuracion_model->get_historial_paso($registro,$tipo_flujo);

        $data['historial'] = $historial;

        $this->gsatelite->cargar_vista_masterpage('modulo_planificacion/pla_inicio/historial_pasos', $data, true);
    }

}