<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Pla_configuracion extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('configuracion_model');
        $this->load->model('plan_operativo_model');
        //$this->load->library('encode');
        $this->load->library('grocery_CRUD');
        $this->load->library('session');
    }

    function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data["titulo_personal"] = "Configuracion";
            $this->_cargarvista($data);
        }
    }

    function flujos(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud = new grocery_CRUD();
                $crud->set_table('flu_flujo');
                $crud->set_subject('');
                $columns = array(
                    'flu_nombre',
                    'flu_descripcion',
                    'flu_estado',
                );
                $display_as = array(
                    'flu_nombre' => 'Nombre',
                    'flu_descripcion' => 'Descripción',
                    'flu_estado' => 'Estado',
                );
                $crud->columns($columns)
                    ->display_as($display_as)
                    ->unset_export()
                    ->unset_print()
                    ->unset_add()
                    ->unset_edit()
                ;
                $crud->field_type('flu_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
                if ($permisos['permite_editar']) {
                    $crud->add_action('&nbsp;Editar', '', 'modulo_planificacion/pla_configuracion/editar_flujo', 'icon16 icomoon-icon-pencil-5');
                }
                $crud->add_action('&nbsp;Pasos por flujo', '', 'modulo_planificacion/pla_configuracion/pasos_flujo', 'icomoon-icon-forward');
                $crud->unset_delete();
                $output = $crud->render();
                $data['permisos'] = $permisos;
                $data['titulo_personal'] = 'Flujo de trabajo';
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    function agregar_flujo()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST['nombre_flujo']) {
                //var_dump($_POST);die();

                $nombre = $this->input->post('nombre_flujo');
                $descripcion = $this->input->post('descripcion_flujo');
                $tipo_btn = $this->input->post('tipo_btn');

                $flujo_array = array(
                    'flu_nombre' => $nombre,
                    'flu_descripcion' => $descripcion,
                    'flu_estado' => 1,
                    'flu_usu_creacion' => $this->tank_auth->get_user_id(),
                    'flu_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'flu_fecha_creacion' => date('Y-m-d H:i:s'),
                    'flu_fecha_modificacion' => date('Y-m-d H:i:s'),
                );

                $flu_id = $this->gsatelite->ingresar('flu_flujo', $flujo_array);

                if ($flu_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro procesado", 'texto_alerta' => "Proceso realizado con éxito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");
                }

                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_planificacion/pla_configuracion/agregar_flujo');
                } else if ($tipo_btn == 2) {
                    redirect('modulo_planificacion/pla_configuracion/flujos');
                }
            }


            $data['titulo_personal'] = "Agregar Flujo de trabajo";
            $this->_cargarvista($data);
        }
    }

    function editar_flujo($flu_id = null){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                //var_dump($_POST);die();
                $nombre = $this->input->post('nombre_flujo');
                $descripcion = $this->input->post('descripcion_flujo');
                $estado = ($this->input->post('estado') == 2) ? 0 : 1;
                $tipo_btn = $this->input->post('tipo_btn');

                $flujo_array = array(
                    'flu_nombre' => $nombre,
                    'flu_descripcion' => $descripcion,
                    'flu_estado' => $estado,
                    'flu_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'flu_fecha_modificacion' => date('Y-m-d H:i:s'),
                );
                $where = array('flu_id' => $flu_id);
                $result = $this->gsatelite->actualizar_array('flu_flujo', $flujo_array, $where);

                if ($result > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro actualizado", 'texto_alerta' => "Proceso realizado con éxito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");
                }

                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_planificacion/pla_configuracion/editar_flujo/' . $flu_id);
                } else if ($tipo_btn == 2) {
                    redirect('modulo_planificacion/pla_configuracion/flujos');
                }
            }
            if ($flu_id == null) {
                redirect('/auth/login/');
            }
            $data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $flu_id));
            $data['titulo_personal'] = "Editar Flujo de trabajo";
            $this->_cargarvista($data);
        }
    }

    public function conf_reportes_poa(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $add_columns = array(
                'evp_nombre',
                'evp_rango_inicio',
                'evp_rango_fin',
                'evp_color',
                'evp_estado',
                'evp_usu_creacion',
                'evp_usu_modificacion',
                'evp_fecha_creacion',
                'evp_fecha_modificacion'
            );
            $edit_columns = array(
                'evp_nombre',
                'evp_rango_inicio',
                'evp_rango_fin',
                'evp_color',
                'evp_estado',
                'evp_usu_modificacion',
                'evp_fecha_modificacion'
            );
            $required_fields = array(
                'evp_nombre',
                'evp_rango_inicio',
                'evp_rango_fin',
                'evp_color',
                'evp_estado'
            );
            $alias = array(
                'evp_nombre' => 'Nombre',
                'evp_estado' => 'Estado',
                'evp_rango_inicio' => 'Inicio Rango',
                'evp_rango_fin' => 'Final Rango',
                'evp_color' => 'Color Indicador'
            );
            $columns = array(
                'evp_nombre',
                'evp_rango_inicio',
                'evp_rango_fin',
                'evp_estado'
            );
            $crud = new grocery_CRUD();
            $crud->set_table('evp_evaluacion_meta_poa');
            $crud->set_subject('');
            $crud->display_as($alias);
            $crud->columns($columns);
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->required_fields($required_fields);
            $crud->callback_field('evp_color', function ($value = '', $primary_key = null) {
                $ver = '<table width="10%"><tr><td style="height: 30px; border: solid black 1px; background-color:'.$value.'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td></tr></table>';
                return '<div class="span10" style="display: flex">
                <input type="text" id="field-evp_color" name="evp_color" style="width:35% !important;display: inline-block;" readonly value="' . $value . '">
                <div id="colorSelector" style="margin-left:7px;"><div style="background-color:' . $value . '"></div></div>
                <div id="read_color" style="margin-left:7px; display: none;">' . $ver . '</div></div>';
            });
            $crud->callback_field('evp_rango_inicio', function ($value = '', $primary_key = null) {
                return '<input id="field-evp_rango_inicio" name="evp_rango_inicio" type="text" class="soloDecimales span12" maxlength="19,2" value="' . $value . '">';
            });
            $crud->callback_field('evp_rango_fin', function ($value = '', $primary_key = null) {
                return '<input id="field-evp_rango_fin" name="evp_rango_fin" type="text" class="soloDecimales span12" maxlength="19,2" value="' . $value . '">';
            });
            $crud->callback_column('evp_rango_inicio', function($value, $row) {
                return number_format($value, 2);
            });
            $crud->callback_column('evp_rango_fin', function($value, $row) {
                return number_format($value, 2);
            });
            $crud->field_type('evp_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('evp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('evp_nombre', 'Nombre', 'trim|required|campo_unico[evp_evaluacion_meta_poa.evp_nombre]');
            $crud->set_rules('evp_rango_inicio', 'Inicio Rango', 'trim|is_numeric|required|callback_validacion_rango_poa');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('evp_estado', 'hidden', 1);
                $crud->field_type('evp_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('evp_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('evp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = 'Configuración Reporte POA';
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function conf_evalua_rsg(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $add_columns = array(
                'evr_nombre',
                'evr_id_prb',
                'evr_id_imr',
                'evr_color_alerta',
                'evr_estado',
                'evr_usu_creacion',
                'evr_usu_modificacion',
                'evr_fecha_creacion',
                'evr_fecha_modificacion'
            );
            $edit_columns = array(
                'evr_nombre',
                'evr_id_prb',
                'evr_id_imr',
                'evr_color_alerta',
                'evr_estado',
                'evr_usu_modificacion',
                'evr_fecha_modificacion'
            );
            $required_fields = array(
                'evr_nombre',
                'evr_id_prb',
                'evr_id_imr',
                'evr_color_alerta',
                'evr_estado',
            );
            $alias = array(
                'evr_nombre' => 'Nombre',
                'evr_estado' => 'Estado',
                'evr_id_imr' => 'Consecuencia',
                'evr_id_prb' => 'Probabilidad',
                'evr_color_alerta' => 'Color Indicador'
            );
            $columns = array(
                'evr_nombre',
                'evr_id_imr',
                'evr_id_prb',
                'evr_estado'
            );
            $crud = new grocery_CRUD();
            $crud->set_table('evr_evaluacion_riesgo');
            $crud->set_subject('');
            $crud->display_as($alias);
            $crud->columns($columns);
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->required_fields($required_fields);
            $crud->set_relation('evr_id_imr', 'imr_impacto_riesgo', 'imr_nombre', array('imr_estado' => 1));
            $crud->set_relation('evr_id_prb', 'prb_probabilidad_riesgo', 'prb_nombre', array('prb_estado' => 1));
            $crud->callback_field('evr_color_alerta', function ($value = '', $primary_key = null) {
                $ver = '<table width="10%"><tr><td style="height: 30px; border: solid black 1px; background-color:'.$value.'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td></tr></table>';
                return '<div class="span10" style="display: flex">
                <input type="text" id="field-evr_color_alerta" name="evr_color_alerta" style="width:35% !important;display: inline-block;" readonly value="' . $value . '">
                <div id="colorSelector" style="margin-left:7px;"><div style="background-color:' . $value . '"></div></div>
                <div id="read_color" style="margin-left:7px; display: none;">' . $ver . '</div></div>';
            });
            $crud->field_type('evr_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('evr_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('evr_nombre', 'Nombre', 'trim|required|campo_unico[evr_evaluacion_riesgo.evr_nombre]');
            $crud->set_rules('evr_id_imr', 'Consecuencia y Probabilidad', 'required|callback_evaluar_combinacion');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('evr_estado', 'hidden', 1);
                $crud->field_type('evr_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('evr_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('evr_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = 'Análisis de Riesgo';
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function conf_evaluacion_final(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $add_columns = array(
                'evt_nombre',
                'evt_id_evr_antes',
                'evt_id_evr_despues',
                'evt_id_cac',
                'evt_color_alerta',
                'evt_estado',
                'evt_usu_creacion',
                'evt_usu_modificacion',
                'evt_fecha_creacion',
                'evt_fecha_modificacion'
            );
            $edit_columns = array(
                'evt_nombre',
                'evt_id_evr_antes',
                'evt_id_evr_despues',
                'evt_id_cac',
                'evt_color_alerta',
                'evt_estado',
                'evt_usu_modificacion',
                'evt_fecha_modificacion'
            );
            $required_fields = array(
                'evt_nombre',
                'evt_id_evr_antes',
                'evt_id_evr_despues',
                'evt_id_cac',
                'evt_color_alerta',
                'evt_estado'
            );
            $alias = array(
                'evt_nombre' => 'Nombre',
                'evt_estado' => 'Estado',
                'evt_id_evr_antes' => 'Antes de Controles',
                'evt_id_evr_despues' => 'Despues de Controles',
                'evt_id_cac' => 'Controles Actuales',
                'evt_color_alerta' => 'Color Indicador'
            );
            $columns = array(
                'evt_nombre',
                'evt_id_evr_antes',
                'evt_id_evr_despues',
                'evt_estado'
            );
            $crud = new grocery_CRUD();
            $crud->set_table('evt_evaluacion_riesgo_total');
            $crud->set_subject('');
            $crud->display_as($alias);
            $crud->columns($columns);
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->required_fields($required_fields);
            $crud->set_relation('evt_id_cac', 'cac_control_actual', 'cac_nombre', array('cac_estado' => 1));
            $crud->set_relation('evt_id_evr_antes', 'evr_evaluacion_riesgo', 'evr_nombre', array('evr_estado' => 1));
            $crud->set_relation('evt_id_evr_despues', 'evr_evaluacion_riesgo', 'evr_nombre', array('evr_estado' => 1));
            $crud->callback_field('evt_color_alerta', function ($value = '', $primary_key = null) {
                $ver = '<table width="10%"><tr><td style="height: 30px; border: solid black 1px; background-color:'.$value.'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td></tr></table>';
                return '<div class="span10" style="display: flex">
                <input type="text" id="field-evt_color_alerta" name="evt_color_alerta" style="width:35% !important;display: inline-block;" readonly value="' . $value . '">
                <div id="colorSelector" style="margin-left:7px;"><div style="background-color:' . $value . '"></div></div>
                <div id="read_color" style="margin-left:7px; display: none;">' . $ver . '</div></div>';
            });
            $crud->field_type('evt_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('evt_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('evt_nombre', 'Nombre', 'trim|required');//|campo_unico[evt_evaluacion_riesgo_total.evt_nombre] PUEDEN REPETIR NOMBRES PERO NO COMBINACIONES
            $crud->set_rules('evt_id_evr_antes', 'Evaluación', 'required|callback_evaluar_combinacion_final');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('evt_estado', 'hidden', 1);
                $crud->field_type('evt_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('evt_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('evt_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = 'Evaluación de Riesgo';
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function evaluar_combinacion(){
        $this->load->library('form_validation');
        $ruta_url = explode('/', uri_string());
        $id = is_numeric(end($ruta_url)) ? end($ruta_url) : 0;
        $impac = $this->input->post('evr_id_imr');
        $proba = $this->input->post('evr_id_prb');
        $query = $this->gsatelite->get_tabla('evr_evaluacion_riesgo', array('evr_estado' => 1, 'evr_id_imr' => $impac, 'evr_id_prb' => $proba, 'evr_id != ' => $id));
        if (count($query) > 0) {
            $this->form_validation->set_message('evaluar_combinacion', 'Esta Combinación de Análisis ya fue registrada.');
            return false;
        } else {
            return true;
        }
    }

    function evaluar_combinacion_final(){
        $this->load->library('form_validation');
        $ruta_url = explode('/', uri_string());
        $id = is_numeric(end($ruta_url)) ? end($ruta_url) : 0;
        $evr_antes = $this->input->post('evt_id_evr_antes');
        $evr_despu = $this->input->post('evt_id_evr_despues');
        $query = $this->gsatelite->get_tabla('evt_evaluacion_riesgo_total', array('evt_estado' => 1, 'evt_id_evr_antes' => $evr_antes, 'evt_id_evr_despues' => $evr_despu, 'evt_id != ' => $id));
        if (count($query) > 0) {
            $this->form_validation->set_message('evaluar_combinacion_final', 'Esta Combinación de Evaluaciones ya fue registrada.');
            return false;
        } else {
            return true;
        }
    }

    public function conf_clasifica_rsg(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $add_columns = array(
                'clr_nombre',
                'clr_descripcion',
                'clr_estado',
                'clr_usu_creacion',
                'clr_usu_modificacion',
                'clr_fecha_creacion',
                'clr_fecha_modificacion'
            );
            $edit_columns = array(
                'clr_nombre',
                'clr_descripcion',
                'clr_estado',
                'clr_usu_modificacion',
                'clr_fecha_modificacion'
            );
            $required_fields = array(
                'clr_nombre',
                'clr_estado'
            );
            $alias = array(
                'clr_nombre' => 'Nombre',
                'clr_descripcion' => 'Descripción',
                'clr_estado' => 'Estado'
            );
            $columns = array(
                'clr_nombre',
                'clr_estado',
            );
            $crud = new grocery_CRUD();
            $crud->set_table('clr_clasificacion_riesgo');
            $crud->set_subject('');
            $crud->display_as($alias);
            $crud->columns($columns);
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->required_fields($required_fields);
            $crud->field_type('clr_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('clr_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('clr_nombre', 'Nombre', 'trim|required|campo_unico[clr_clasificacion_riesgo.clr_nombre]');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('clr_estado', 'hidden', 1);
                $crud->field_type('clr_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('clr_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('clr_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = 'Clasificación de Riesgos';
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function conf_probab_rsg(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $add_columns = array(
                'prb_nombre',
                'prb_descripcion',
                'prb_estado',
                'prb_usu_creacion',
                'prb_usu_modificacion',
                'prb_fecha_creacion',
                'prb_fecha_modificacion'
            );
            $edit_columns = array(
                'prb_nombre',
                'prb_descripcion',
                'prb_estado',
                'prb_usu_modificacion',
                'prb_fecha_modificacion'
            );
            $required_fields = array(
                'prb_nombre',
                'prb_estado'
            );
            $alias = array(
                'prb_nombre' => 'Nombre',
                'prb_descripcion' => 'Descripción',
                'prb_estado' => 'Estado'
            );
            $columns = array(
                'prb_nombre',
                'prb_estado',
            );
            $crud = new grocery_CRUD();
            $crud->set_table('prb_probabilidad_riesgo');
            $crud->set_subject('');
            $crud->display_as($alias);
            $crud->columns($columns);
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->required_fields($required_fields);
            $crud->field_type('prb_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('prb_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('prb_nombre', 'Nombre', 'trim|required|campo_unico[prb_probabilidad_riesgo.prb_nombre]');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('prb_estado', 'hidden', 1);
                $crud->field_type('prb_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('prb_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('prb_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = 'Probabilidad de Riesgo';
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function conf_impact_rsg(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $add_columns = array(
                'imr_nombre',
                'imr_descripcion',
                'imr_estado',
                'imr_usu_creacion',
                'imr_usu_modificacion',
                'imr_fecha_creacion',
                'imr_fecha_modificacion'
            );
            $edit_columns = array(
                'imr_nombre',
                'imr_descripcion',
                'imr_estado',
                'imr_usu_modificacion',
                'imr_fecha_modificacion'
            );
            $required_fields = array(
                'imr_nombre',
                'imr_estado'
            );
            $alias = array(
                'imr_nombre' => 'Nombre',
                'imr_descripcion' => 'Descripción',
                'imr_estado' => 'Estado'
            );
            $columns = array(
                'imr_nombre',
                'imr_estado',
            );
            $crud = new grocery_CRUD();
            $crud->set_table('imr_impacto_riesgo');
            $crud->set_subject('');
            $crud->display_as($alias);
            $crud->columns($columns);
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->required_fields($required_fields);
            $crud->field_type('imr_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('imr_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('imr_nombre', 'Nombre', 'trim|required|campo_unico[imr_impacto_riesgo.imr_nombre]');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('imr_estado', 'hidden', 1);
                $crud->field_type('imr_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('imr_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('imr_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = 'Consecuencia de Riesgo';
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function conf_factores_int(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $add_columns = array(
                'fai_nombre',
                'fai_descripcion',
                'fai_estado',
                'fai_usu_creacion',
                'fai_usu_modificacion',
                'fai_fecha_creacion',
                'fai_fecha_modificacion'
            );
            $edit_columns = array(
                'fai_nombre',
                'fai_descripcion',
                'fai_estado',
                'fai_usu_modificacion',
                'fai_fecha_modificacion'
            );
            $required_fields = array(
                'fai_nombre',
                'fai_estado'
            );
            $alias = array(
                'fai_nombre' => 'Nombre',
                'fai_descripcion' => 'Descripción',
                'fai_estado' => 'Estado'
            );
            $columns = array(
                'fai_nombre',
                'fai_estado',
            );
            $crud = new grocery_CRUD();
            $crud->set_table('fai_factor_interno');
            $crud->set_subject('');
            $crud->display_as($alias);
            $crud->columns($columns);
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->required_fields($required_fields);
            $crud->field_type('fai_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('fai_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('fai_nombre', 'Nombre', 'trim|required|campo_unico[fai_factor_interno.fai_nombre]');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('fai_estado', 'hidden', 1);
                $crud->field_type('fai_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('fai_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('fai_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = 'Factores Internos de Riesgo';
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function conf_controles_act(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $add_columns = array(
                'cac_nombre',
                'cac_descripcion',
                'cac_estado',
                'cac_usu_creacion',
                'cac_usu_modificacion',
                'cac_fecha_creacion',
                'cac_fecha_modificacion'
            );
            $edit_columns = array(
                'cac_nombre',
                'cac_descripcion',
                'cac_estado',
                'cac_usu_modificacion',
                'cac_fecha_modificacion'
            );
            $required_fields = array(
                'cac_nombre',
                'cac_estado'
            );
            $alias = array(
                'cac_nombre' => 'Nombre',
                'cac_descripcion' => 'Descripción',
                'cac_estado' => 'Estado'
            );
            $columns = array(
                'cac_nombre',
                'cac_descripcion',
                'cac_estado',
            );
            $crud = new grocery_CRUD();
            $crud->set_table('cac_control_actual');
            $crud->set_subject('');
            $crud->display_as($alias);
            $crud->columns($columns);
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->required_fields($required_fields);
            $crud->field_type('cac_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('cac_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('cac_nombre', 'Nombre', 'trim|required|campo_unico[fai_factor_interno.fai_nombre]');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('cac_estado', 'hidden', 1);
                $crud->field_type('cac_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('cac_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('cac_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = 'Controles Actuales de Riesgo';
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function conf_factores_ext(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $add_columns = array(
                'fae_nombre',
                'fae_descripcion',
                'fae_estado',
                'fae_usu_creacion',
                'fae_usu_modificacion',
                'fae_fecha_creacion',
                'fae_fecha_modificacion'
            );
            $edit_columns = array(
                'fae_nombre',
                'fae_descripcion',
                'fae_estado',
                'fae_usu_modificacion',
                'fae_fecha_modificacion'
            );
            $required_fields = array(
                'fae_nombre',
                'fae_estado'
            );
            $alias = array(
                'fae_nombre' => 'Nombre',
                'fae_descripcion' => 'Descripción',
                'fae_estado' => 'Estado'
            );
            $columns = array(
                'fae_nombre',
                'fae_estado',
            );
            $crud = new grocery_CRUD();
            $crud->set_table('fae_factor_externo');
            $crud->set_subject('');
            $crud->display_as($alias);
            $crud->columns($columns);
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->required_fields($required_fields);
            $crud->field_type('fae_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('fae_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('fae_nombre', 'Nombre', 'trim|required|campo_unico[fae_factor_externo.fae_nombre]');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('fae_estado', 'hidden', 1);
                $crud->field_type('fae_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('fae_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('fae_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = 'Factores Externos de Riesgo';
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function export_conf_rpte_poa(){
        $data['tabla'] = $this->gsatelite->get_tabla('evp_evaluacion_meta_poa');
        $tabla = $this->load->view('modulo_planificacion/pla_configuracion/export_excel_poa', $data, true);
        ob_end_clean();
        echo $tabla;
    }

    public function conf_reportes_pei(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $add_columns = array(
                'evs_nombre',
                'evs_rango_inicio',
                'evs_rango_fin',
                'evs_color',
                'evs_estado',
                'evs_usu_creacion',
                'evs_usu_modificacion',
                'evs_fecha_creacion',
                'evs_fecha_modificacion'
            );
            $edit_columns = array(
                'evs_nombre',
                'evs_rango_inicio',
                'evs_rango_fin',
                'evs_color',
                'evs_estado',
                'evs_usu_modificacion',
                'evs_fecha_modificacion'
            );
            $required_fields = array(
                'evs_nombre',
                'evs_rango_inicio',
                'evs_rango_fin',
                'evs_color',
                'evs_estado'
            );
            $alias = array(
                'evs_nombre' => 'Nombre',
                'evs_estado' => 'Estado',
                'evs_rango_inicio' => 'Inicio Rango',
                'evs_rango_fin' => 'Final Rango',
                'evs_color' => 'Color Indicador'
            );
            $columns = array(
                'evs_nombre',
                'evs_rango_inicio',
                'evs_rango_fin',
                'evs_estado'
            );
            $crud = new grocery_CRUD();
            $crud->set_table('evs_evaluacion_meta_estrategica');
            $crud->set_subject('');
            $crud->display_as($alias);
            $crud->columns($columns);
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->required_fields($required_fields);
            $crud->callback_field('evs_color', function ($value = '', $primary_key = null) {
                $ver = '<table width="10%"><tr><td style="height: 30px; border: solid black 1px; background-color:'.$value.'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td></tr></table>';
                return '<div class="span10" style="display: flex">
                <input type="text" id="field-evs_color" name="evs_color" style="width:35% !important;display: inline-block;" readonly value="' . $value . '">
                <div id="colorSelector" style="margin-left:7px;"><div style="background-color:' . $value . '"></div></div>
                <div id="read_color" style="margin-left:7px; display: none;">' . $ver . '</div></div>';
            });
            $crud->callback_field('evs_rango_inicio', function ($value = '', $primary_key = null) {
                return '<input id="field-evs_rango_inicio" name="evs_rango_inicio" type="text" class="soloDecimales span12" maxlength="19,2" value="' . $value . '">';
            });
            $crud->callback_field('evs_rango_fin', function ($value = '', $primary_key = null) {
                return '<input id="field-evs_rango_fin" name="evs_rango_fin" type="text" class="soloDecimales span12" maxlength="19,2" value="' . $value . '">';
            });
            $crud->callback_column('evs_rango_inicio', function($value, $row) {
                return number_format($value, 2);
            });
            $crud->callback_column('evs_rango_fin', function($value, $row) {
                return number_format($value, 2);
            });
            $crud->field_type('evs_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('evs_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('evs_nombre', 'Nombre', 'trim|required|campo_unico[evs_evaluacion_meta_estrategica.evs_nombre]');
            $crud->set_rules('evs_rango_inicio', 'Inicio Rango', 'trim|is_numeric|required|callback_validacion_rango_pei');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('evs_estado', 'hidden', 1);
                $crud->field_type('evs_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('evs_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('evs_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = 'Configuración Reporte PEI';
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function export_conf_rpte_pei(){
        $data['tabla'] = $this->gsatelite->get_tabla('evs_evaluacion_meta_estrategica');
        $tabla = $this->load->view('modulo_planificacion/pla_configuracion/export_excel_pei', $data, true);
        ob_end_clean();
        echo $tabla;
    }
    
    public function validacion_rango_poa($data) {
        if ($data != '') {
            $validado1 = false;
            $validado2 = false;
            $f1 = $this->input->post('evp_rango_inicio');
            $f2 = $this->input->post('evp_rango_fin');
            if ($f2 >= $f1) {
                $validado1 = true;
            } else {
                $this->form_validation->set_message('validacion_rango_poa', 'El inicio del rango debe ser menor al final del rango');
                return false;
            }
            $url_array = explode('/', uri_string()); 
            $no_incluir = (is_numeric(end($url_array)) and end($url_array) > 0 ) ? end($url_array) : 0; //en el caso de edit
            $pregunta1 = $this->gsatelite->get_tabla('evp_evaluacion_meta_poa', array('evp_id != ' => $no_incluir, 'evp_rango_fin' => $f2, 'evp_rango_inicio' => $f1));
            $pregunta2 = $this->gsatelite->get_tabla('evp_evaluacion_meta_poa', array('evp_id != ' => $no_incluir, 'evp_rango_fin >=' => $f1));
            if (count($pregunta1) > 0) {
                $this->form_validation->set_message('validacion_rango_poa', 'Ya existen otro registro con un rango similar');
                return false;
            }
            if (count($pregunta2) > 0 && !is_numeric(end($url_array))) {
                $this->form_validation->set_message('validacion_rango_poa', 'Ya existen otro registro que contiene el inicio del rango');
                return false;
            } else {
                $validado2 = true;
            }
            return ($validado1 && $validado2) ? true : false;
        } else {
            return true;
        }
    }

    public function validacion_rango_pei($data) {
        if ($data != '') {
            $validado1 = false;
            $validado2 = false;
            $f1 = $this->input->post('evs_rango_inicio');
            $f2 = $this->input->post('evs_rango_fin');
            if ($f2 >= $f1) {
                $validado1 = true;
            } else {
                $this->form_validation->set_message('validacion_rango_pei', 'El inicio del rango debe ser menor al final del rango');
                return false;
            }
            $url_array = explode('/', uri_string()); 
            $no_incluir = (is_numeric(end($url_array)) and end($url_array) > 0 ) ? end($url_array) : 0; //en el caso de edit
            $pregunta1 = $this->gsatelite->get_tabla('evs_evaluacion_meta_estrategica', array('evs_id != ' => $no_incluir, 'evs_rango_fin' => $f2, 'evs_rango_inicio' => $f1));
            $pregunta2 = $this->gsatelite->get_tabla('evs_evaluacion_meta_estrategica', array('evs_id != ' => $no_incluir, 'evs_rango_fin >=' => $f1));
            if (count($pregunta1) > 0) {
                $this->form_validation->set_message('validacion_rango_pei', 'Ya existen otro registro con un rango similar');
                return false;
            }
            if (count($pregunta2) > 0 && !is_numeric(end($url_array))) {
                $this->form_validation->set_message('validacion_rango_pei', 'Ya existen otro registro que contiene el inicio del rango');
                return false;
            } else {
                $validado2 = true;
            }
            return ($validado1 && $validado2) ? true : false;
        } else {
            return true;
        }
    }

    function validar_nombre_flujo($flu_nombre = null, $flu_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $flu_nombre = $this->input->post('nombre');
                $flu_id = $this->input->post('flujo');
            }

            if ($flu_id != null && $flu_id != '') {
                $where = "flu_nombre = '" . $flu_nombre . "' AND flu_id <> " . $flu_id;

                $count = $this->gsatelite->count('flu_flujo', $where);
            } else {
                $where = array('flu_nombre' => $flu_nombre);

                $count = $this->gsatelite->count('flu_flujo', $where);
            }


            if ($_POST) {
                if ($count > 0) {
                    echo json_encode(array('existe' => 1));
                } else {
                    echo json_encode(array('existe' => 0));
                }
            } else {
                if ($count > 0) {
                    return false;
                } else {
                    return true;
                }
            }
        }
    }

    function pasos_flujo($flu_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($flu_id == null) {
                redirect('/auth/login/');
            }

            $crud = new grocery_CRUD();

            $crud->set_table('psf_paso_flujo');
            $crud->set_subject('');

            $columns = array(
                'psf_orden',
                'psf_nombre',
                'psf_descripcion',
                'psf_estado',
            );

            $display_as = array(
                'psf_orden' => 'Orden',
                'psf_nombre' => 'Etapa',
                'psf_descripcion' => 'Descripción',
                'psf_estado' => 'Estado',
            );


            $crud->columns($columns)
                ->display_as($display_as)
                ->unset_export()
                ->unset_print()
                ->unset_add()
                ->unset_edit()
                ->where('psf_id_flu', $flu_id)
                ->order_by('psf_orden', 'asc')
                ->field_type('psf_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));

            $crud->add_action('&nbsp;Editar', '', 'modulo_planificacion/pla_configuracion/editar_paso/' . $flu_id, 'icon16 icomoon-icon-pencil-5');
            $crud->add_action('&nbsp;Roles', '', 'modulo_planificacion/pla_configuracion/roles_paso', 'icomoon-icon-users');

            $output = $crud->render();
            $data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $flu_id));
            $data['titulo_personal'] = 'Flujo ' . $data['flujo'][0]['flu_nombre'] . " - Pasos por flujo";

            $this->_cargarvista($data, $output);
        }
    }

    function agregar_paso($flu_id = null){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($flu_id == null) {
                redirect('/auth/login/');
            }
            if (isset($_POST['nombre_paso'])) {
                // var_dump($_POST);die();
                $nombre_paso = trim($this->input->post('nombre_paso'));
                $orden = $this->input->post('orden_paso');
                $siguiente_paso = $this->input->post('siguiente_paso');
                $obligatorio = $this->input->post('obligatorio');
                $area = $this->input->post('area');
                $descripcion = $this->input->post('descripcion_paso');
                $tipo_btn = $this->input->post('tipo_btn');
                $aplica_firma = ($this->input->post('firma_check') != '') ? $this->input->post('firma_check') : 0;
                $enunciado_firma = ($this->input->post('titulofirma_paso') != '') ? $this->input->post('titulofirma_paso') : null;
                $paso_array = array(
                    'psf_id_flu' => $flu_id,
                    'psf_nombre' => $nombre_paso,
                    'psf_descripcion' => $descripcion,
                    'psf_obligatorio' => $obligatorio,
                    'psf_orden' => $orden,
                    'psf_paso_siguiente' => $siguiente_paso,
                    'psf_area' => $area,
                    'psf_aplica_firma' => $aplica_firma,
                    'psf_enunciado_firma' => $enunciado_firma, 
                    'psf_estado' => 1,
                    'psf_usu_creacion' => $this->tank_auth->get_user_id(),
                    'psf_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'psf_fecha_creacion' => date('Y-m-d H:i:s'),
                    'psf_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                /*print_r($paso_array);die();*/
                $psf_id = $this->gsatelite->ingresar('psf_paso_flujo', $paso_array);
                if ($psf_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro procesado", 'texto_alerta' => "Proceso realizado con éxito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");
                }
                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_planificacion/pla_configuracion/agregar_paso/' . $flu_id);
                } else if ($tipo_btn == 2) {
                    redirect('modulo_planificacion/pla_configuracion/pasos_flujo/' . $flu_id);
                }
            }
            $data['titulo_personal'] = 'Agregar paso';
            $data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $flu_id));
            $this->_cargarvista($data);
        }
    }

    function editar_paso($flu_id = null, $psf_id = null){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($flu_id == null || $psf_id == null) {
                redirect('/auth/login/');
            }
            if (isset($_POST['nombre_paso'])) {
                // var_dump($_POST);die();
                $nombre_paso = trim($this->input->post('nombre_paso'));
                $orden = $this->input->post('orden_paso');
                $obligatorio = $this->input->post('obligatorio');
                $siguiente_paso = $this->input->post('siguiente_paso');
                $area = $this->input->post('area');                
                $descripcion = $this->input->post('descripcion_paso');
                $estado = ($this->input->post('estado') == 2) ? 0 : 1;
                $tipo_btn = $this->input->post('tipo_btn');
                $aplica_firma = ($this->input->post('firma_check') != '') ? $this->input->post('firma_check') : 0;
                $enunciado_firma = ($this->input->post('titulofirma_paso') != '' and $this->input->post('firma_check') > 0) ? $this->input->post('titulofirma_paso') : null;
                $paso_array = array(
                    'psf_nombre' => $nombre_paso,
                    'psf_descripcion' => $descripcion,
                    'psf_obligatorio' => $obligatorio,
                    'psf_orden' => $orden,
                    'psf_paso_siguiente' => $siguiente_paso,
                    'psf_area' => $area,
                    'psf_aplica_firma' => $aplica_firma,
                    'psf_enunciado_firma' => $enunciado_firma,
                    'psf_estado' => $estado,
                    'psf_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'psf_fecha_modificacion' => date('Y-m-d H:i:s'),
                );
                $where = array('psf_id' => $psf_id);
                $result = $this->gsatelite->actualizar_array('psf_paso_flujo', $paso_array, $where);
                if ($result > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro actualizado", 'texto_alerta' => "Proceso actualizado con éxito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");
                }
                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_planificacion/pla_configuracion/editar_paso/' . $flu_id . '/' . $psf_id);
                } else if ($tipo_btn == 2) {
                    redirect('modulo_planificacion/pla_configuracion/pasos_flujo/' . $flu_id);
                }
            }
            $data['titulo_personal'] = 'Editar paso';
            $data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $flu_id));
            $data['paso'] = $this->gsatelite->get_tabla('psf_paso_flujo', array('psf_id' => $psf_id));
            $this->_cargarvista($data);
        }
    }

    function acciones()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $permisos = $this->gsatelite->get_permisos_opcion();

            $crud = new grocery_CRUD();

            $crud->set_table('acc_accion');
            $crud->set_subject('');

            $columns = array(
                'acc_nombre',
                'acc_icono',
                'acc_url',
                'acc_estado',
            );

            $required = array(
                'acc_nombre',
                'acc_icono',
                'acc_url',
                'acc_estado',
            );

            $display_as = array(
                'acc_nombre' => 'Nombre',
                'acc_icono' => 'Icono',
                'acc_url' => 'Url',
                'acc_estado' => 'Estado',
            );

            $add_fields = array(
                'acc_nombre',
                'acc_url',
                'acc_icono',
                'acc_estado',
                'acc_usu_creacion',
                'acc_usu_modificacion',
                'acc_fecha_creacion',
                'acc_fecha_modificacion'
            );

            $edit_fields = array(
                'acc_nombre',
                'acc_url',
                'acc_icono',
                'acc_estado',
                'acc_usu_modificacion',
                'acc_fecha_modificacion'
            );

            $crud->columns($columns)
                ->display_as($display_as)
                ->unset_export()
                ->unset_print()
                ->set_rules('acc_nombre', 'Nombre', 'required|campo_unico[acc_accion.acc_nombre]')
                ->set_rules('acc_icono', 'Icono', 'required')
                ->required_fields($required)
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->set_field_upload('acc_icono', 'uploads/anx_acciones')
                ->field_type('acc_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'))
                ->field_type('acc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('acc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('acc_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('acc_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));

            //$this->load->config('grocery_crud');
            //$this->config->set_item('grocery_crud_file_upload_allow_file_types',
            //'jpeg|jpg|png');


            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }

            $output = $crud->render();
            $data['permisos'] = $permisos;
            $data['titulo_personal'] = "Acciones";
            //$data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $flu_id));
            $this->_cargarvista($data, $output);
        }
    }

    function roles_paso($psf_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($psf_id == null) {
                redirect('/auth/login/');
            }

            $data['paso'] = $this->gsatelite->get_tabla('psf_paso_flujo', array('psf_id' => $psf_id));

            $data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $data['paso'][0]['psf_id_flu']));

            $data['roles'] = $this->configuracion_model->get_roles_paso(array('rxp_id_psf' => $psf_id));

            $data['titulo_personal'] = 'Asociar rol a flujo de trabajo';

            $this->_cargarvista($data);
        }
    }

    function agregar_rol_paso($psf_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($psf_id == null) {
                redirect('/auth/login/');
            }

            if ($_POST) {
                //var_dump($_POST);die();

                $rol = $this->input->post('rol');
                $acciones = $this->input->post('acciones');
                $tipo_btn = $this->input->post('tipo_btn');

                $rxp_array = array(
                    'rxp_id_psf' => $psf_id,
                    'rxp_id_rol' => $rol,
                    'rxp_estado' => 1,
                    'rxp_usu_creacion' => $this->tank_auth->get_user_id(),
                    'rxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'rxp_fecha_creacion' => date('Y-m-d H:i:s'),
                    'rxp_fecha_modificacion' => date('Y-m-d H:i:s'),
                );

                $rxp_id = $this->gsatelite->ingresar('rxp_rolxpaso', $rxp_array);

                if (count($acciones) > 0 && $acciones != null) {
                    for ($i = 0; $i < count($acciones); $i++) {
                        $axr_array = array(
                            'axr_id_rxp' => $rxp_id,
                            'axr_id_acc' => $acciones[$i],
                            'axr_estado' => 1,
                            'axr_usu_creacion' => $this->tank_auth->get_user_id(),
                            'axr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'axr_fecha_creacion' => date('Y-m-d H:i:s'),
                            'axr_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $axr_id = $this->gsatelite->ingresar('axr_accionxrol_paso', $axr_array);
                    }
                }

                if ($rxp_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro procesado", 'texto_alerta' => "Proceso procesado con éxito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");
                }

                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_planificacion/pla_configuracion/agregar_rol_paso/' . $psf_id);
                } else if ($tipo_btn == 2) {
                    redirect('modulo_planificacion/pla_configuracion/roles_paso/' . $psf_id);
                }
            }

            $data['roles'] = $this->gsatelite->get_dropdown('rol_rol', '{rol_nombre}', 'roles', array('rol_estado' => 1), null, null, 'rol_id', true);

            $data['acciones'] = $this->gsatelite->get_dropdown('acc_accion', '{acc_nombre}', 'acciones', array('acc_estado' => 1), null, null, 'acc_id', true);

            $data['paso'] = $this->gsatelite->get_tabla('psf_paso_flujo', array('psf_id' => $psf_id));

            $data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $data['paso'][0]['psf_id_flu']));

            $data['titulo_personal'] = 'Asociar rol a flujo de trabajo';

            $this->_cargarvista($data);
        }
    }

    function editar_rol_paso($psf_id = null, $rxp_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($psf_id == null) {
                redirect('/auth/login/');
            }

            if ($_POST) {
                //var_dump($_POST);die();

                $rol = $this->input->post('rol');
                $estado = ($this->input->post('estado') == 2) ? 0 : 1;
                $acciones = $this->input->post('acciones');
                $tipo_btn = $this->input->post('tipo_btn');

                $rxp_array = array(
                    'rxp_id_rol' => $rol,
                    'rxp_estado' => $estado,
                    'rxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'rxp_fecha_modificacion' => date('Y-m-d H:i:s'),
                );

                $where = array('rxp_id' => $rxp_id);

                $result = $this->gsatelite->actualizar_array('rxp_rolxpaso', $rxp_array, $where);

                if (count($acciones) > 0 && $acciones != null) {

                    $del = $this->gsatelite->borrado_general('axr_accionxrol_paso', array('axr_id_rxp' => $rxp_id));

                    for ($i = 0; $i < count($acciones); $i++) {
                        $axr_array = array(
                            'axr_id_rxp' => $rxp_id,
                            'axr_id_acc' => $acciones[$i],
                            'axr_estado' => 1,
                            'axr_usu_creacion' => $this->tank_auth->get_user_id(),
                            'axr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'axr_fecha_creacion' => date('Y-m-d H:i:s'),
                            'axr_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $axr_id = $this->gsatelite->ingresar('axr_accionxrol_paso', $axr_array);
                    }
                }

                if ($result > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro actualizado", 'texto_alerta' => "Proceso actualizado con éxito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");
                }

                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_planificacion/pla_configuracion/editar_rol_paso/' . $psf_id . '/' . $rxp_id);
                } else if ($tipo_btn == 2) {
                    redirect('modulo_planificacion/pla_configuracion/roles_paso/' . $psf_id);
                }
            }

            $rxp_info = $this->configuracion_model->get_roles_paso(array('rxp_id' => $rxp_id));

            $data['rxp_info'] = $rxp_info;

            $data['roles'] = $this->gsatelite->get_dropdown('rol_rol', '{rol_nombre}', 'roles', array('rol_estado' => 1), $rxp_info[0]['rxp_id_rol'], null, 'rol_id', true);

            // $data['acciones'] = $this->gsatelite->get_dropdown('acc_accion','{acc_nombre}','acciones',array('acc_estado'=>1),null,null,null,true);

            $data['acciones'] = $this->gsatelite->get_tabla('acc_accion', array('acc_estado' => 1));

            $axr_data = $this->configuracion_model->get_acciones_rol(array('axr_id_rxp' => $rxp_id));

            $data['axr_list'] = array_column($axr_data, 'axr_id_acc');

            $data['rxp_id'] = $rxp_id;

            $data['paso'] = $this->gsatelite->get_tabla('psf_paso_flujo', array('psf_id' => $psf_id));

            $data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $data['paso'][0]['psf_id_flu']));

            $data['titulo_personal'] = 'Asociar rol a flujo de trabajo';

            $this->_cargarvista($data);
        }
    }

    function eliminar_rol_paso($rxp_id = null, $psf_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($rxp_id == null) {
                redirect('/auth/login/');
            } else {

                $del = $this->gsatelite->borrado_general('axr_accionxrol_paso', array('axr_id_rxp' => $rxp_id));
                $where = array('rxp_id' => $rxp_id);
                $del_rxp = $this->gsatelite->borrado_general('rxp_rolxpaso', $where);

                $this->session->set_flashdata($alerta);

                redirect('modulo_planificacion/pla_configuracion/roles_paso/' . $psf_id);
            }
        }
    }

    function validar_orden_paso($psf_id = null, $orden = null, $flu_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $psf_id = $this->input->post('paso');
                $orden = $this->input->post('orden');
                $flu_id = $this->input->post('flujo');
            }

            if ($psf_id == null) {

                $where = array('psf_id_flu' => $flu_id, 'psf_orden' => $orden);

                $count = $this->gsatelite->count('psf_paso_flujo', $where);
            } else if ($psf_id != null) {

                $where = 'psf_id_flu = ' . $flu_id . ' AND psf_orden = ' . $orden . ' AND psf_id <> ' . $psf_id;

                $count = $this->gsatelite->count('psf_paso_flujo', $where);
            } else {

            }

            if ($_POST) {
                if ($count > 0) {
                    echo json_encode(array('existe' => 1));
                } else {
                    echo json_encode(array('existe' => 0));
                }
            } else {
                if ($count > 0) {
                    return false;
                } else {
                    return true;
                }
            }
        }
    }

    function validar_nombre_paso($psf_nombre = null, $psf_id = null, $flu_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $psf_nombre = trim($this->input->post('nombre'));
                $psf_id = $this->input->post('paso');
                $flu_id = $this->input->post('flujo');
            }

            if ($psf_id != null && $psf_id != '') {
                $where = "psf_nombre = '" . $psf_nombre . "' AND psf_id_flu = " . $flu_id . " AND psf_id <> " . $psf_id;

                $count = $this->gsatelite->count('psf_paso_flujo', $where);
            } else {
                $where = array('psf_nombre' => $psf_nombre, 'psf_id_flu' => $flu_id);

                $count = $this->gsatelite->count('psf_paso_flujo', $where);
            }


            if ($_POST) {
                if ($count > 0) {
                    echo json_encode(array('existe' => 1));
                } else {
                    echo json_encode(array('existe' => 0));
                }
            } else {
                if ($count > 0) {
                    return false;
                } else {
                    return true;
                }
            }
        }
    }

    function tiempo_evaluacion()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $permisos = $this->gsatelite->get_permisos_opcion();

            $crud = new grocery_CRUD();

            $crud->set_table('tie_tiempo_evaluacion');
            $crud->set_subject('');

            $columns = array(
                'tie_inicio',
                'tie_fin',
                'tie_color',
                'tie_estado',
            );

            $required = array(
                'tie_inicio',
                'tie_fin',
                'tie_color',
                'tie_estado',
            );

            $display_as = array(
                'tie_inicio' => 'Rango inicio',
                'tie_fin' => 'Rango Fin',
                'tie_color' => 'Color',
                'tie_estado' => 'Estado',
            );

            $add_fields = array(
                'tie_inicio',
                'tie_fin',
                'tie_color',
                'tie_estado',
                'tie_usu_creacion',
                'tie_usu_modificacion',
                'tie_fecha_creacion',
                'tie_fecha_modificacion'
            );

            $edit_fields = array(
                'tie_inicio',
                'tie_fin',
                'tie_color',
                'tie_estado',
                'tie_usu_modificacion',
                'tie_fecha_modificacion'
            );

            $crud->columns($columns)
                ->display_as($display_as)
                ->unset_export()
                ->unset_print()
                ->set_rules('tie_inicio', 'Rango inicio', 'required|campo_unico[tie_tiempo_evaluacion.tie_inicio]')
                ->set_rules('tie_fin', 'Rango Fin', 'required|campo_unico[tie_tiempo_evaluacion.tie_fin]')
                ->required_fields($required)
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->field_type('tie_estado', 'hidden', 1)
                //->field_type('tie_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'))
                ->field_type('tie_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tie_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tie_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('tie_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));

            $crud->callback_column('tie_color', function ($value, $primary_key) {
                return "<div style='background-color:" . $value . " '>" . $value . "</div>";
            });


            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }

            $output = $crud->render();
            $data['permisos'] = $permisos;
            $data['titulo_personal'] = "Rango de Evaluación";
            //$data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $flu_id));
            $this->_cargarvista($data, $output);
        }
    }

    function _cargarvista($data = 0, $crud = 0)
    {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    /*
    * @author: Mario Marquez
    * $tipo 1 = Busca Nacionalidades 2 = Busca Departamentos 3 = Busca Municipios
    */

    public function get_localidades($id_filtro = null, $tipo = null)
    {
        $idLocalizacion = ($id_filtro != null) ? $id_filtro : $this->input->post('filtro');
        $tipoLocalidad = ($tipo != null) ? $tipo : $this->input->post('tipo');

        $opciones = "<option></option>";

        $where = null;
        switch ($tipoLocalidad) {
            case 1:
                if ($idLocalizacion != null) {
                    $where['pai_id'] = $idLocalizacion;
                }
                $registros = $this->gsatelite->get_tabla('pai_pais', $where);

                foreach ($registros as $row) {
                    $opciones .= "<option value='" . $row['pai_id'] . "'>" . $row['pai_nombre'] . "</option>";
                }
                break;
            case 2:
                if ($idLocalizacion != null) {
                    $where['dep_id_pai'] = $idLocalizacion;
                }
                $registros = $this->gsatelite->get_tabla('dep_departamento', $where);

                foreach ($registros as $row) {
                    $opciones .= "<option value='" . $row['dep_id'] . "'>" . $row['dep_nombre'] . "</option>";
                }

                break;

            case 3:
                if ($idLocalizacion != null) {
                    $where['mun_id_dep'] = $idLocalizacion;
                }
                $registros = $this->gsatelite->get_tabla('mun_municipio', $where);

                foreach ($registros as $row) {
                    $opciones .= "<option value='" . $row['mun_id'] . "'>" . $row['mun_nombre'] . "</option>";
                }
                break;
        }

        if ($tipo != null) {
            return $opciones;
        }

        echo $opciones;
    }

    public function habilitar_tareas()
    {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array););

            $where = null;
            if ($post_array['plan_operativo'] != '') {
                $where['poa_id'] = $post_array['plan_operativo'];
            }

            $data['planes'] = $this->plan_operativo_model->get_planes_operativos_unidad($where);

            $html = $this->load->view('modulo_planificacion/pla_configuracion/consultar_planes_operativos', $data, true);
            echo json_encode(array('html' => $html));
            die();
        }
        $data['plan_operativo'] = $this->gsatelite->get_tabla('poa_plan_operativo', array('poa_estado' => 1));
        $data['titulo_personal'] = "Habilitar tareas";
        cargarvista($data);
    }

    public function habilita_tarea_rsg(){
        satelite_validar();
        if ($_POST) {
            // code...
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $matriz_riesgo = $this->gsatelite->get_dropdown('mai_matriz_riesgo', '{mai_nombre}', '', array('mai_estado' => 1), null, '', 'mai_id', true);
            $data['matriz_riesgo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $matriz_riesgo);
            $data['titulo_personal'] = "Habilitar tareas riesgos";
            cargarvista($data);
        }
        
        if ($this->input->post()) {
            $post_array = $this->input->post();
            die(var_dump($post_array));
            $where = null;
            if ($post_array['plan_operativo'] != '') {
                $where['poa_id'] = $post_array['plan_operativo'];
            }
            $data['planes'] = $this->plan_operativo_model->get_planes_operativos_unidad($where);
            $html = $this->load->view('modulo_planificacion/pla_configuracion/consultar_planes_operativos', $data, true);
            echo json_encode(array('html' => $html));
            die();
        }
        
        
    }


    public function habilitaciones()
    {
        satelite_validar(true);
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //var_dump($post_array);die();

            $fechaInicio = formatear_fecha('Y-m-d', $post_array['fechaInicio']);
            $fechaFin = formatear_fecha('Y-m-d', $post_array['fechaFin']);
            //Se obtiene la unidad
            $unidad = ($post_array['masivo'] != '') ? 0 : $post_array['unidad'];

            //Se obtienen los valores generales y se envian atraves de un array
            $dataExtra = array(
                'fechaInicio' => $fechaInicio,
                'fechaFin' => $fechaFin,
                'comentarios' => $post_array['comentario']
            );

            $planes = 0;

            switch ($post_array['tipoHabilitacion']) {

                case 1:
                    $planes = $this->habilitacionFormulacion($post_array['planOperativo'], $unidad, $dataExtra);
                    break;
            }

            echo json_encode(array('planes' => $planes));
        }
    }

    public function habilitacionFormulacion($planOperativo, $unidad, $dataExtra)
    {

        //Se obtienen los planes por unidad
        $where = array('pxu_id_poa' => $planOperativo);
        if ($unidad > 0) {
            $where['pxu_id_are'] = $unidad;
        }

        $planes_unidad = $this->plan_operativo_model->get_planes_operativos_unidad($where);

        //Se obtiene el parametro de flujos
        $flujos = json_decode($this->gsatelite->get_parametro('SYS_FLUJO_PLANIFICACION'), true);
        //Se Lista el primer Paso del flujo
        $primer_paso = $this->configuracion_model->get_primer_paso_flujo($flujos['POA']['FORMULACION']);

        $paso_id = 0;

        if (count($primer_paso) > 0) {
            //Se recorren los planes Operativos por unidad
            foreach ($planes_unidad as $pxu) {
                //Se verifica que no exista un flujo actualmente en ejecución
                $paso_actual = $this->configuracion_model->get_paso_actual_planificacion($pxu['pxu_id'], 1);

                if(count($paso_actual) > 0 ){
                    $paso_id = $paso_actual[0]['psf_id'];
                }
                else{
                    //Se ingresa el paso inicial del flujo.
                    $paso_id = $primer_paso[0]['psf_id'];

                    $paso_array = array(
                        'sgf_id_psf' => $paso_id,
                        'sgf_id_pxu' => $pxu['pxu_id'],
                        'sgf_usu_apertura' => $this->tank_auth->get_user_id(),
                        'sgf_usu_cierra' => null,
                        'sgf_fecha_entrada' => date('Y-m-d H:i:s'),
                        'sgf_fecha_salida' => null,
                        'sgf_observacion' => null,
                        'sgf_anexo' => null,
                        'sgf_estado' => 1,
                        'sgf_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sgf_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sgf_fecha_creacion' => date('Y-m-d H:i:s'),
                        'sgf_fecha_modificacion' => date('Y-m-d H:i:s')
                    );

                    $this->gsatelite->ingresar('sgf_seguim_formulacion', $paso_array);
                }

                if($paso_id){
                    //Se obtienen los usuarios a notificar
                    // --- PENDIENTE ---

                    //Se ingresa el periodo habilitado
                    $periodo_array = array(
                        'pea_id_usu'=> $this->tank_auth->get_user_id(),
                        'pea_id_per'=> null,
                        'pea_fecha_inicio'=> $dataExtra['fechaInicio'],
                        'pea_fecha_cierre'=> $dataExtra['fechaFin'],
                        'pea_observacion'=> $dataExtra['comentarios'],
                        'pea_tipo'=> 1,
                        'pea_anexo'=> null,
                        'pea_envio_notificacion'=> 0,
                        'pea_estado'=> 1,
                        'pea_usu_creacion'=> $this->tank_auth->get_user_id(),
                        'pea_usu_modificacion'=> $this->tank_auth->get_user_id(),
                        'pea_fecha_creacion'=> date('Y-m-d H:i:s'),
                        'pea_fecha_modificacion'=> date('Y-m-d H:i:s')
                    );

                    $pea_id = $this->gsatelite->ingresar('pea_periodo_activacion', $periodo_array);

                    //Se enlaza el periodo de activación con el plan por unidad
                    $pxo_array = array(
                        'pxo_id_pxu' => $pxu['pxu_id'],
                        'pxo_id_pea' => $pea_id,
                        'pxo_estado' => 1,
                        'pxo_usu_creacion' => $this->tank_auth->get_user_id(),
                        'pxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'pxo_fecha_creacion' => date('Y-m-d H:i:s'),
                        'pxo_fecha_modificacion' => date('Y-m-d H:i:s')
                    );

                    $pea_id = $this->gsatelite->ingresar('pxo_periodoxpoa', $pxo_array);
                }
            }
        }
        return count($planes_unidad);
    }

    public function conf_rsg_resid(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $add_columns = array(
                'rsd_nombre',
                'rsd_descripcion',
                'rsd_estado',
                'rsd_usu_creacion',
                'rsd_usu_modificacion',
                'rsd_fecha_creacion',
                'rsd_fecha_modificacion'
            );
            $edit_columns = array(
                'rsd_nombre',
                'rsd_descripcion',
                'rsd_estado',
                'rsd_usu_modificacion',
                'rsd_fecha_modificacion'
            );
            $required_fields = array(
                'rsd_nombre',
                'rsd_estado'
            );
            $alias = array(
                'rsd_nombre' => 'Nombre',
                'rsd_descripcion' => 'Descripción',
                'rsd_estado' => 'Estado'
            );
            $columns = array(
                'rsd_nombre',
                'rsd_estado',
            );
            $crud = new grocery_CRUD();
            $crud->set_table('rsd_riesgo_residual');
            $crud->set_subject('');
            $crud->display_as($alias);
            $crud->columns($columns);
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->required_fields($required_fields);
            $crud->field_type('rsd_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('rsd_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('rsd_nombre', 'Nombre', 'trim|required|campo_unico[rsd_riesgo_residual.rsd_nombre]');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('rsd_estado', 'hidden', 1);
                $crud->field_type('rsd_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('rsd_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('rsd_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = 'Riesgos Residuales';
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function conf_estado_logro(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $add_columns = array(
                'stl_nombre',
                'stl_descripcion',
                'stl_estado',
                'stl_usu_creacion',
                'stl_usu_modificacion',
                'stl_fecha_creacion',
                'stl_fecha_modificacion'
            );
            $edit_columns = array(
                'stl_nombre',
                'stl_descripcion',
                'stl_estado',
                'stl_usu_modificacion',
                'stl_fecha_modificacion'
            );
            $required_fields = array(
                'stl_nombre',
                'stl_estado'
            );
            $alias = array(
                'stl_nombre' => 'Nombre',
                'stl_descripcion' => 'Descripción',
                'stl_estado' => 'Estado'
            );
            $columns = array(
                'stl_nombre',
                'stl_estado',
            );
            $crud = new grocery_CRUD();
            $crud->set_table('stl_estado_logro');
            $crud->set_subject('');
            $crud->display_as($alias);
            $crud->columns($columns);
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->required_fields($required_fields);
            $crud->field_type('stl_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('stl_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('stl_nombre', 'Nombre', 'trim|required|campo_unico[stl_estado_logro.stl_nombre]');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('stl_estado', 'hidden', 1);
                $crud->field_type('stl_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('stl_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('stl_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = 'Estado del Logro';
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

}
