<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Med_reportes extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('contabilidad_model');
        $this->load->model('medico_model');
        $this->load->model('gsatelite');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Contabilidad';
            $this->_cargarvista();
        }
    }

   /**
    * @author Elmer Hernández
    * @since 2019-11-09
    * @descripcion Creador de formularios para aseguradoras.
     */
    function formularios_aseguradoras(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Formularios Aseguradoras';
            $paciente_drop = $this->gsatelite->get_dropdown('epp_expediente_paciente', '{epp_numero_expediente} - {epp_nombre} {epp_apellido} - {epp_id}', '', array('epp_estado' => 1), null, '', 'epp_id', true);
            $data['paciente'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $paciente_drop);
            cargarvista($data);
        }
    }

  /**
    * @author Elmer Hernández
    * @since 2019-11-11
    * @descripcion Función utilizada para traer las consultas dependiendo del paciente seleccionado.
     */

    /*function consultas_paciente(){

        $paciente = $this->input->post('paciente');
        
        $select_consultas = '<option value=""></option>';
        $select_aseguradoras = '<option value=""></option>';
        $select_formularios = '<option value=""></option>';

        $datos_formulario = $this->medico_model->datos_formulario(array('cnm_estado' => 1, 'ase_estado' => 1, 'epp_id' => $paciente));
      
        $select_aseguradoras .= '<option selected="selected" value="'.$datos_formulario[0]['ase_id'].'" >'.$datos_formulario[0]['ase_nombre'].'</option>';

        $datos_select_formularios = $this->medico_model->formularios_aseguradora(array('frm_id_ase' => $datos_formulario[0]['ase_id']));

        foreach ($datos_select_formularios as $key) {
             $select_formularios .= '<option value="'.$key['frm_id'].'" >'.$key['frm_nombre'].'</option>';
        }

        foreach ($datos_formulario as $key) {

            $select_consultas .= '<option value="'.$key['cnm_id'].'" >'.$key['cnm_numero'].'</option>';
        }

        echo json_encode(array('select_consultas' => $select_consultas, 'select_aseguradoras' => $select_aseguradoras, 'select_formularios' => $select_formularios));
    }
*/
   /**
    * @author Andrea Rivera
    * @since 2020-02-28
    * @descripcion, consulta de pacientes.
     */
   function consulta_pacientes()
   {
    $paciente = $this->input->post('paciente');        
    $html = "<option></option>";

    $where['epp_id'] = $paciente;
    $group_by = 'cnm_id';
    $consultas_paciente = $this->medico_model->datos_formulario($where, $group_by);

    foreach ($consultas_paciente as $key => $value) {
        $html .= '<option value="'.$value['cnm_id'].'">'.$value['cnm_numero'].'</option>';
    }  

    echo json_encode($html);
}

   /**
    * @author Andrea Rivera
    * @since 2020-02-28
    * @descripcion, consulta de aseguradora pacientes.
     */
    function aseguradoras_pacientes(){
        $paciente = $this->input->post('paciente');
        $html = "<option></option>";
        $where['epp_id'] = $paciente;
        $where['sep_estado'] = 1;
        $where['pol_estado'] = 1;
        $where['ase_estado'] = 1;
        $aseguradoras_pacientes = $this->medico_model->get_seguro_paciente($where);
        // print_r($this->db->last_query());die();
        foreach ($aseguradoras_pacientes as $key => $value) {
            $html .= '<option value="'.$value['ase_id'].'">'.$value['ase_nombre'].'</option>';
        }  
        echo json_encode($html);
    }

    /**
    * @author Andrea Rivera
    * @since 2020-02-28
    * @descripcion. formularios
     */
    function formulario_select(){
        $aseguradora = $this->input->post('aseguradora');
        $html = "<option></option>";
        $where['ase_id'] = $aseguradora;
        $where['frm_estado'] = 1;
        $where['frm_activo'] = 1;
        $formularios = $this->medico_model->formularios_aseguradora($where);
        // print_r($this->db->last_query());die();
        foreach ($formularios as $key => $value) {
            $html .= '<option value="'.$value['frm_id'].'" data-url="'.$value['frm_archivo'].'">'.$value['frm_nombre'].' -- '.$value['frm_id'].'</option>';
        }
        echo json_encode($html);
    }

function generar_formulario(){
    print_r($_POST);die();
}

       /**
    * @author Andrea Rivera
    * @since 2020-02-28
    * @descripcion, consulta formularios.
     */
       function mostrar_formulario_aseguradora()
       {
        if ($_POST) {
            $paciente = $this->input->post('slcpaciente');
            //$consulta = $this->input->post('slcconsulta');
            $slcformulario = $this->input->post('slcformulario');
            $tipo_doc_dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
            if ($paciente != '' && $slcformulario != '') {
                
                $formulario_reg = $this->medico_model->formularios_aseguradora(array('frm_id' => $slcformulario));
                $expediente_reg = $this->gsatelite->get_tabla('epp_expediente_paciente', array('epp_id' => $paciente));
                $expediente_reg='';
                $contacto_paciente = $this->gsatelite->get_tabla('cpt_contacto_paciente', array('cpt_id_epp' => $paciente)); 
                $documentos_paciente = $this->gsatelite->get_tabla('dop_documento_paciente', array('dop_id_epp' => $paciente));
                $dui_paciente = '';   
                if ($documentos_paciente) {
                    $dui_paciente = array_column($documentos_paciente, 'dop_valor','dop_id_tde');
                    $dui_paciente = (isset($dui_paciente[$tipo_doc_dui])) ? $dui_paciente[$tipo_doc_dui] : '';
                }             
                $data['datos_paciente'] = $expediente_reg;                
                $data['datos_contacto'] = $contacto_paciente;    
                $data['dui_paciente'] = $dui_paciente;           
                $data['datos_consulta'] = $this->medico_model->informacion_consulta(array("cnm_id" => $consulta));
                $data['datos_receta'] = $this->medico_model->informacion_receta(array("rct_id_cnm" => $consulta));
                $data['datos_seguro'] = $this->medico_model->get_seguro_paciente(array('sep_id_epp'=>$paciente));     
                $data['enfermedades'] = $this->gsatelite->get_tabla("enf_enfermedad",array("enf_estado" => 1)); 
                $anexos = $this->gsatelite->get_tabla("aci_anexo_consulta_medica",array("aci_id_cnm" => $consulta));     
                // $data['procedimiento'] = $this->medico_model->get_procedimiento_quirurgico(array('pgp_id_epp'=>$paciente),'pgp_id');
                // var_dump($data['procedimiento']);die();
                $data['anexos'] = array_column($anexos, 'aci_comentario');
                $this->db->join('enf_enfermedad', 'enp_id_enf = enf_id','left');
                $data['enfermedad'] = $this->gsatelite->get_tabla("enp_enfermedad_paciente",array("enp_id_epp" => $paciente));
                $formulario = $formulario_reg[0]['frm_archivo'];

                /* Configuraciones ancho y alto de tabla */
                $conf_formato = $formulario_reg[0]['frm_configuraciones_formato'];
                $conf_formato_array = json_decode($conf_formato, true);
                $data['width_conf']  = $conf_formato_array['WIDTH'];
                $data['height_conf'] = $conf_formato_array['HEIGHT'];
                /*****************************************/

                $this->load->library('pdf');
                ini_set('memory_limit', '-1');
                ini_set('max_execution_time', '9999');

                $html = $this->load->view('modulo_medico/med_reportes/'.$formulario, $data, true);
                
                $reporte = $this->pdf->makePDF(/*$html_header .*/ $html, 'P');
            }

        }
    }
    
}//Fin clase
