<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Med_procesos extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('medico_model');
        $this->load->model('facturacion_model');
        $this->load->model('inventario_model');
        $this->load->library('pdf');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    /**
     * Descripción:
     * Función para mostrar los datos de los expedientes del paciente creados
     * @author Habby Lovo - Grupo satélite
     * @since  2019-08-12
     * @param  Ninguno
     * @return registros de paciente
     */
    function expediente_paciente(){
        if($this->input->post()){
            $slcFilPaciente = $this->input->post('slcFilPaciente');
            $where = array();
            if($slcFilPaciente != ''){
                $where['epp_id' ] = $slcFilPaciente;
            }

            $tipo = ($this->input->post('tipo_reporte') != '')?$this->input->post('tipo_reporte'):'';

            $reporte_reg = $this->medico_model->get_tabla_expediente_paciente($where);
            $data["reporte_reg"] = $reporte_reg;
            $data['tipo'] = $tipo;
            $html = $this->load->view('modulo_medico/med_procesos/tabla_expediente_paciente', $data, true);
            echo $html;
            die();
        }
        $data['titulo_personal'] = 'Expediente de Paciente';
        cargarvista($data);
    }

    /**
     * Descripción:
     * Función para guardar el expediente del paciente
     * @author Habby Lovo - Grupo satélite
     * @since  2019-08-12
     * @param  Ninguno
     * @return 
     */
    function agregar_expediente_paciente($modal = 0){
        satelite_validar();
        if ($this->input->post()) {
            // var_dump($this->input->post());die();
            /* tab generales */
            $slcClasificacion = $this->input->post('slcClasificacion'); //epp_id_cfc
            $txtNoExpediente = $this->input->post('txtNoExpediente'); //epp_numero_expediente

            /* fotografia */
            $txtFotografiaGeneral = $this->input->post('txtFotografiaGeneral'); //epp_url_fotografia
            $txtCarpetaFotografiaGeneral = $this->input->post('txtCarpetaFotografiaGeneral'); //epp_url_fotografia

            $txtNombre = $this->input->post('txtNombre'); //epp_nombre
            $slcNacionalidad = $this->input->post('slcNacionalidad'); //epp_id_pai
            $txtApellido = $this->input->post('txtApellido'); //epp_apellido
            $slcDepartamento = $this->input->post('slcDepartamento'); //epp_id_dep
            $txtApellidoCasada = (trim($this->input->post('txtApellidoCasada')) != "") ? $this->input->post('txtApellidoCasada') : "";  //epp_apellido_casada
            // EN LINUX NO APARECE BIEN EN EL CALENDARIO SI CASADA ES NULL, DEBE SER "" **********************
            $apellido_full = ($txtApellidoCasada) ? $txtApellido . ' ' . $txtApellidoCasada : $txtApellido;
            $slcCiudad = $this->input->post('slcCiudad'); //epp_id_ciu
            $slcMunicipio = $this->input->post('slcMunicipio'); //epp_id_mun
            $slcDistritos = $this->input->post('slcDistrito'); //epp_id_dis
            $slcGenero = $this->input->post('slcGenero'); //epp_id_gen
            $slcEstadoCivil = $this->input->post('slcEstadoCivil'); //epp_id_esc
            $txtDireccion = $this->input->post('txtDireccion'); //epp_direccion
            $txtFechaNacimiento = $this->input->post('txtFechaNacimiento'); //epp_fecha_nacimiento
            $txtEmail = $this->input->post('txtEmail'); //epp_correo
            $txtEdad = $this->input->post('txtEdad');
            $slcReferidoPor = $this->input->post('slcReferidoPor'); //epp_id_ref
            $slcProfesion = $this->input->post('slcProfesion'); //epp_id_pro
            $txtNombreReferidoPor = $this->input->post('txtNombreReferidoPor'); //no esta-----------------------------
            $txtOcupacion = $this->input->post('txtOcupacion'); //epp_ocupacion
            $slcMedico = $this->input->post('slcMedico'); //epp_id_med
            $txtComentario = $this->input->post('txtComentario'); //txtComentario

            /* tab seguro */
            $txtEdicionSeguro = $this->input->post('txtEdicionSeguro'); //array
            $slcAseguradoraSeguro = $this->input->post('slcAseguradoraSeguro'); //array
            $slcPolizaSeguro = $this->input->post('slcPolizaSeguro'); //array
            $slcNumeroSeguro = $this->input->post('slcNumeroSeguro'); //array sep_id_pol
            $chkTipoSeguro = $this->input->post('chkTipoSeguro'); //array sep_tipo
            $txtPorSeguroSeguro = $this->input->post('txtPorSeguroSeguro'); //array sep_porcentaje_seguro
            $txtPorPacienteSeguro = $this->input->post('txtPorPacienteSeguro'); //array sep_porcentaje_paciente
            $txtCertificadoSeguro = $this->input->post('txtCertificadoSeguro'); //array sep_certificado

            /* tab contactos */
            $txtEdicionContacto = $this->input->post('txtEdicionContacto'); //array
            $txtNombreContacto = $this->input->post('txtNombreContacto'); //array
            $slcTipoTelefonoContacto = $this->input->post('slcTipoTelefonoContacto'); //array
            $txtObservacionContacto = $this->input->post('txtObservacionContacto'); //array
            $txtNumeroContacto = $this->input->post('txtNumeroContacto'); //array

            /* tab documentos */
            $txtEdicionDocumento = $this->input->post('txtEdicionDocumento'); //array
            $slcTipoDocDocumento = $this->input->post('slcTipoDocDocumento'); //array
            $txtNoDocDocumento = $this->input->post('txtNoDocDocumento'); //array
            $txtLugarExpDocumento = $this->input->post('txtLugarExpDocumento'); //array
            $txtFechaExpDocumento = $this->input->post('txtFechaExpDocumento'); //array
            $txtFechaVenDocumento = $this->input->post('txtFechaVenDocumento'); //array
                /*anexo*/
            $txtCarpetaAnexoDocumento = $this->input->post('txtCarpetaAnexoDocumento'); //array
            $txtAnexoDocumento = $this->input->post('txtAnexoDocumento'); //array

            /* tab datos clinicos */
            $txtEmergenciaLLamarClinico = $this->input->post('txtEmergenciaLLamarClinico'); //epp_emergencia_llamar
            $slcPoseeCirugiasPreviasClinico = $this->input->post('slcPoseeCirugiasPreviasClinico'); //epp_posee_cirugias

            $txtMencioneCirujia = $this->input->post('txtMencioneCirujia'); //epp_descripcion_cirugias

            $slcParentezcoClinico = $this->input->post('slcParentezcoClinico'); //epp_id_pat
            $slcControlesEspecialidadClinico = $this->input->post('slcControlesEspecialidadClinico'); //epp_id_epm

            $txtNumeroClinico = $this->input->post('txtNumeroClinico'); //epp_telefono_emergencia
            $slcTipoSangreClinico = $this->input->post('slcTipoSangreClinico'); //epp_id_tsr

            $txtMotivoControlClinico = $this->input->post('txtMotivoControlClinico'); //epp_motivo_control

            $txtAlergicoClinico = $this->input->post('txtAlergicoClinico'); //array

            $txtPadeceAlgunaEnfermedadClinico = $this->input->post('txtEnfermedad'); //array epp_id_enf
            $txtTratamientoPrevio = $this->input->post('txtTratamientoPrevio'); //array enp_tratamientoprevio
            $txtEvolucion = $this->input->post('txtEvolucion'); //array epp_evolucion
            $txtExamenPrevio = $this->input->post('txtExamenPrevio'); //array epp_examenprevio

            $txtAceptaTrafucionClinico = $this->input->post('txtAceptaTrafucionClinico'); //epp_acepta_tranfusion
            $slcDiscapacidadClinico = $this->input->post('slcDiscapacidadClinico'); //epp_posee_discapacidad

            $txtComentarioClinico = $this->input->post('txtComentarioClinico'); //epp_comentario_datos_clinicos

            $txtMencioneDiscapacidadClinico = $this->input->post('txtMencioneDiscapacidadClinico'); //epp_descripcion_discapacidad

            /* tab anexos */
            $txtArchivo = $this->input->post('txtArchivo');
            $txtArchivoOriginal = $this->input->post('txtArchivoOriginal');
            $txtRutaArchivo = $this->input->post('txtRutaArchivo');
            $txtTamanio = $this->input->post('txtTamanio');
            $txtEdicionAdjunto = $this->input->post('txtEdicionAdjunto');
            $txtNombreDocumento = $this->input->post('txtNombreDocumento');
            
            
            $rutaGuardarFotografia = '';
            $carpetaDestinoFotografia = FCPATH."uploads/modulo_medico/expediente_documentos_fotografia/";
            $carpetaTemporalFotografia = FCPATH.$txtCarpetaFotografiaGeneral;
            if($txtCarpetaFotografiaGeneral != ''){

                $archivoFotografia_guardar = '';
                $archivosFotografia_array = explode('.', $txtFotografiaGeneral); //se separa el nombre de la imagen en el punto
                if(count($archivosFotografia_array) > 2){ //en el caso que se encuentren varios puntos
                    $extension = $archivosFotografia_array[(count($archivosFotografia_array) -1)];
                    unset($archivosFotografia_array[(count($archivosFotografia_array) -1)]);
                    $archivoFotografia_guardar = implode('', $archivosFotografia_array).date('his').'.'.$extension;
                } else if(count($archivosFotografia_array) > 1){ //si solo es un punto
                    $extension = $archivosFotografia_array[(count($archivosFotografia_array) -1)];
                    $archivoFotografia_guardar = $archivosFotografia_array[0].date('his').'.'.$extension;
                }

                if (file_exists($carpetaTemporalFotografia.trim($txtFotografiaGeneral))) {
                    copy($carpetaTemporalFotografia.trim($txtFotografiaGeneral), $carpetaDestinoFotografia.trim($archivoFotografia_guardar));
                    unlink($carpetaTemporalFotografia.trim($txtFotografiaGeneral));
                    $rutaGuardarFotografia = "uploads/modulo_medico/expediente_documentos_fotografia/".trim($archivoFotografia_guardar);
                }

            }
            /* BUSCAR SI EXISTE UN TIPO DE PAGO POR DEFECTO PUES SI EXISTE FACTURACION LE PEDIRA UN TIPO DE PAGO */
            $tpg_defecto = $this->gsatelite->get_tabla("tpg_tipo_pago", array("tpg_estado" => 1, "tpg_defecto" => 1));
            $lista_precio_defecto = $this->gsatelite->get_tabla("tlp_tipo_lista_precio", array("tlp_estado" => 1, "tlp_defecto" => 1));
            $tpg_value = (count($tpg_defecto) > 0) ? $tpg_defecto[0]['tpg_id'] : null;

            $guardar_cliente = array(
                'cli_id_pai' => ($slcNacionalidad > 0)?$slcNacionalidad:null, //pais
                'cli_id_pro' => ($slcProfesion > 0)?$slcProfesion:null, //profesion
                'cli_id_mun' => ($slcMunicipio > 0)?$slcMunicipio:null,
                'cli_id_dis' => ($slcDistritos > 0)?$slcDistritos:null,
                'cli_id_cfc' => ($slcClasificacion > 0)?$slcClasificacion:null,
                'cli_codigo' => $txtNoExpediente,
                'cli_apellido' => $apellido_full,
                'cli_nombre' => $txtNombre,
                'cli_personeria' => 1,
                'cli_email' => $txtEmail,
                'cli_direccion' => $txtDireccion,
                'cli_id_tpg' => $tpg_value,
                'cli_fecha_registro' => date('Y-m-d h:i:s'),
                'cli_fecha_nacimiento' => ($txtFechaNacimiento != '')?formatear_fecha("Y-m-d", $txtFechaNacimiento):null,
                'cli_fotografia' => $rutaGuardarFotografia,
                'cli_estado' => 1,
                'cli_usu_crea' => $this->tank_auth->get_user_id(),
                'cli_fecha_crea' => date('Y-m-d h:i:s'),
                'cli_usu_mod' => $this->tank_auth->get_user_id(),
                'cli_fecha_mod' => date('Y-m-d h:i:s')
            );

            $cli_id = $this->gsatelite->ingresar('cli_cliente', $guardar_cliente);
            /* REVISAR SI EXISTE UNA LISTA DE PRECIOS POR DEFECTO PUES SI TIENE FACTURACION, TENDRA UNA LISTA DE PRECIOS POR DEFECTO */
            if (count($lista_precio_defecto) > 0) {
                $lista_X_def = array(
                    'tpn_id_cli' => $cli_id,
                    'tpn_id_tlp' => $lista_precio_defecto[0]['tlp_id'],
                    'tpn_estado' => 1,
                    'tpn_usu_creacion' => $this->tank_auth->get_user_id(),
                    'tpn_fecha_creacion' => date('Y-m-d h:i:s'),
                    'tpn_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'tpn_fecha_modificacion' => date('Y-m-d h:i:s')
                );
                $tpn_id = $this->gsatelite->ingresar('tpn_tipo_precio_cliente', $lista_X_def);
            }


            $guardar_expediente = array(
                'epp_id_cfc' => ($slcClasificacion > 0)?$slcClasificacion:null,
                'epp_id_gen' => ($slcGenero > 0)?$slcGenero:null,
                'epp_id_pro' => ($slcProfesion > 0)?$slcProfesion:null,
                'epp_id_pai' => ($slcNacionalidad > 0)?$slcNacionalidad:null,
                'epp_id_dep' => ($slcDepartamento > 0)?$slcDepartamento:null,
                'epp_id_mun' => ($slcMunicipio > 0)?$slcMunicipio:null,
                'epp_id_dis' => ($slcDistritos > 0)?$slcDistritos:null,
                'epp_id_ciu' => ($slcCiudad > 0)?$slcCiudad:null,
                'epp_id_ref' => ($slcReferidoPor > 0)?$slcReferidoPor:null,
                'epp_id_esc' => ($slcEstadoCivil > 0)?$slcEstadoCivil:null,
                'epp_id_epm' => ($slcControlesEspecialidadClinico > 0)?$slcControlesEspecialidadClinico:null,
                'epp_id_pat' => ($slcParentezcoClinico > 0)?$slcParentezcoClinico:null,
                'epp_id_tsr' => ($slcTipoSangreClinico > 0)?$slcTipoSangreClinico:null,
                'epp_id_cli' => $cli_id, //cliente
                'epp_id_med' => ($slcMedico > 0)?$slcMedico:null,
                'epp_numero_expediente' => $txtNoExpediente,
                'epp_nombre' => $txtNombre,
                'epp_apellido' => $txtApellido,
                'epp_apellido_casada' => $txtApellidoCasada,
                'epp_fecha_nacimiento' => ($txtFechaNacimiento != '')?formatear_fecha("Y-m-d", $txtFechaNacimiento):null,
                'epp_ocupacion' => $txtOcupacion,
                'epp_url_fotografia' => $rutaGuardarFotografia,
                'epp_direccion' => $txtDireccion,
                'epp_correo' => $txtEmail,
                'epp_comentario' => $txtComentario,
                'epp_nombre_ref_por' => $txtNombreReferidoPor,
                'epp_descripcion_cirugia' => $txtMencioneCirujia,
                'epp_emergencia_llamar' => $txtEmergenciaLLamarClinico,
                'epp_telefono_emergencia' => $txtNumeroClinico,
                'epp_acepta_tranfusion' => ($txtAceptaTrafucionClinico != '')?$txtAceptaTrafucionClinico:0,
                'epp_posee_discapacidad' => ($slcDiscapacidadClinico != '')?$slcDiscapacidadClinico:0,
                'epp_descripcion_discapacidad' => $txtMencioneDiscapacidadClinico,
                'epp_posee_cirugias' => ($slcPoseeCirugiasPreviasClinico != '')?$slcPoseeCirugiasPreviasClinico:0,
                'epp_motivo_control' => $txtMotivoControlClinico,
                'epp_comentario_datos_clinicos' => $txtComentarioClinico,
                'epp_estado' => 1,
                'epp_usu_creacion' => $this->tank_auth->get_user_id(),
                'epp_fecha_creacion' => date('Y-m-d h:i:s'),
                'epp_usu_modificacion' => $this->tank_auth->get_user_id(),
                'epp_fecha_modificacion' => date('Y-m-d h:i:s')
            );
            
            $epp_id = $this->gsatelite->ingresar('epp_expediente_paciente', $guardar_expediente);

            $guardar_SeguroPaciente = [];
            if(is_array($txtEdicionSeguro) && count($txtEdicionSeguro) > 0){
                foreach ($txtEdicionSeguro as $key => $value) {
                    $guardar_SeguroPaciente[] = array(
                        'sep_id_pol' => $slcNumeroSeguro[$key],
                        'sep_id_epp' => $epp_id,
                        'sep_certificado' => $txtCertificadoSeguro[$key],
                        'sep_porcentaje_seguro' => $txtPorSeguroSeguro[$key],
                        'sep_porcentaje_paciente' => $txtPorPacienteSeguro[$key],
                        'sep_tipo' => $chkTipoSeguro[$key],
                        'sep_estado' => 1,
                        'sep_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sep_fecha_creacion' => date('Y-m-d h:i:s'),
                        'sep_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sep_fecha_modificacion' => date('Y-m-d h:i:s')
                    );
                }
            }
            if(count($guardar_SeguroPaciente) > 0){
                $this->gsatelite->ingresar('sep_seguro_paciente', $guardar_SeguroPaciente, true);
            }

            $guardar_ContactoPaciente = [];
            if(is_array($txtEdicionContacto) && count($txtEdicionContacto) > 0){
                foreach ($txtEdicionContacto as $key => $value) {
                    $guardar_ContactoPaciente[] = array(
                        'cpt_id_tit' => $slcTipoTelefonoContacto[$key],
                        'cpt_id_epp' => $epp_id,
                        'cpt_nombre' => $txtNombreContacto[$key],
                        'cpt_telefono' => $txtNumeroContacto[$key],
                        'cpt_observacion' => $txtObservacionContacto[$key],
                        'cpt_estado' => 1,
                        'cpt_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cpt_fecha_creacion' => date('Y-m-d h:i:s'),
                        'cpt_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cpt_fecha_modificacion' => date('Y-m-d h:i:s')
                    );
                }
            }
            if(count($guardar_ContactoPaciente) > 0){
                $this->gsatelite->ingresar('cpt_contacto_paciente', $guardar_ContactoPaciente, true);
            }


            $guardar_DocumentoPaciente = [];
            if(is_array($txtEdicionDocumento) && count($txtEdicionDocumento) > 0){
                foreach ($txtEdicionDocumento as $key => $value) {
                    $rutaGuardarAnexo = '';
                    $carpetaDestinoAnexo = FCPATH."uploads/modulo_medico/expediente_documentos/";
                    $carpetaTemporalAnexo = FCPATH.$txtCarpetaAnexoDocumento[$key];
                    if($txtCarpetaAnexoDocumento[$key] != ''){

                        $archivoFotografia_guardar = '';
                        $archivosFotografia_array = explode('.', $txtAnexoDocumento[$key]); //se separa el nombre de la imagen en el punto
                        if(count($archivosFotografia_array) > 2){ //en el caso que se encuentren varios puntos
                            $extension = $archivosFotografia_array[(count($archivosFotografia_array) -1)];
                            unset($archivosFotografia_array[(count($archivosFotografia_array) -1)]);
                            $archivoFotografia_guardar = implode('', $archivosFotografia_array).date('his').'.'.$extension;
                        } else if(count($archivosFotografia_array) > 1){ //si solo es un punto
                            $extension = $archivosFotografia_array[(count($archivosFotografia_array) -1)];
                            $archivoFotografia_guardar = $archivosFotografia_array[0].date('his').'.'.$extension;
                        }

                        if (file_exists($carpetaTemporalAnexo.trim($txtAnexoDocumento[$key]))) {
                            copy($carpetaTemporalAnexo.trim($txtAnexoDocumento[$key]), $carpetaDestinoAnexo.trim($archivoFotografia_guardar));
                            unlink($carpetaTemporalAnexo.trim($txtAnexoDocumento[$key]));
                            $rutaGuardarAnexo = "uploads/modulo_medico/expediente_documentos/".trim($archivoFotografia_guardar);
                        }

                    }
                    $guardar_DocumentoPaciente[] = array(
                        'dop_id_tde' => $slcTipoDocDocumento[$key],
                        'dop_id_epp' => $epp_id,
                        'dop_valor' => $txtNoDocDocumento[$key],
                        'dop_fecha_registro' => date('Y-m-d h:i:s'),
                        'dop_fecha_vence' => ($txtFechaVenDocumento[$key] != '')?formatear_fecha("Y-m-d", $txtFechaVenDocumento[$key]):null,
                        'dop_fecha_expedicion' => ($txtFechaExpDocumento[$key] != '')?formatear_fecha("Y-m-d", $txtFechaExpDocumento[$key]):null,
                        'dop_lugar_expedicion' => $txtLugarExpDocumento[$key],
                        // 'dop_observacion' => $txtNombreContacto[$key],
                        'dop_titulo_anexo' => $txtAnexoDocumento[$key],
                        'dop_url_anexo' => $rutaGuardarAnexo,
                        'dop_estado' => 1,
                        'dop_usu_creacion' => $this->tank_auth->get_user_id(),
                        'dop_fecha_creacion' => date('Y-m-d h:i:s'),
                        'dop_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dop_fecha_modificacion' => date('Y-m-d h:i:s')
                    );
                }
            }
            if(count($guardar_DocumentoPaciente) > 0){
                $this->gsatelite->ingresar('dop_documento_paciente', $guardar_DocumentoPaciente, true);
            }

            $guardar_AlergicoPaciente = [];
            if(is_array($txtAlergicoClinico) && count($txtAlergicoClinico) > 0){
                foreach ($txtAlergicoClinico as $key => $value) {
                    $guardar_AlergicoPaciente[] = array(
                        'cap_id_coa' => $value,
                        'cap_id_epp' => $epp_id,
                        'cap_estado' => 1,
                        'cap_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cap_fecha_creacion' => date('Y-m-d h:i:s'),
                        'cap_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cap_fecha_modificacion' => date('Y-m-d h:i:s')
                    );
                }
            }
            if(count($guardar_AlergicoPaciente) > 0){
                $this->gsatelite->ingresar('cap_componente_alergico_paciente', $guardar_AlergicoPaciente, true);
            }

            $guardar_PadeceEnfermedadPaciente = [];
            if(is_array($txtPadeceAlgunaEnfermedadClinico) && count($txtPadeceAlgunaEnfermedadClinico) > 0){
                foreach ($txtPadeceAlgunaEnfermedadClinico as $key => $value) {
                    $guardar_PadeceEnfermedadPaciente[] = array(
                        'enp_id_enf' => $value,
                        'enp_id_epp' => $epp_id,
                        'enp_estado' => 1,
                        'enp_tratamiento_previo' => $txtTratamientoPrevio[$key],
                        'enp_evolucion' => $txtEvolucion[$key],
                        'enp_examen_previsto' => $txtExamenPrevio[$key],
                        'enp_usu_creacion' => $this->tank_auth->get_user_id(),
                        'enp_fecha_creacion' => date('Y-m-d h:i:s'),
                        'enp_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'enp_fecha_modificacion' => date('Y-m-d h:i:s')
                    );
                }
            }
            if(count($guardar_PadeceEnfermedadPaciente) > 0){
                $this->gsatelite->ingresar('enp_enfermedad_paciente', $guardar_PadeceEnfermedadPaciente, true);
            }

            $guardar_AnexoPaciente = [];
            if(is_array($txtEdicionAdjunto) && count($txtEdicionAdjunto) > 0){
                foreach ($txtEdicionAdjunto as $key => $value) {
                    $rutaGuardarAnexoPaciente = '';
                    $carpetaDestinoAnexo = FCPATH."uploads/modulo_medico/expediente_documentos_anexo/";
                    $carpetaTemporalAnexo = FCPATH."uploads/modulo_medico/expediente_documentos_anexo_temp/";
                    if($txtArchivo[$key] != ''){

                        $archivoAnexo_guardar = '';
                        $archivosFotografia_array = explode('.', $txtArchivo[$key]); //se separa el nombre de la imagen en el punto
                        if(count($archivosFotografia_array) > 2){ //en el caso que se encuentren varios puntos
                            $extension = $archivosFotografia_array[(count($archivosFotografia_array) -1)];
                            unset($archivosFotografia_array[(count($archivosFotografia_array) -1)]);
                            $nombre_limpio = clean_string($txtNombreDocumento[$key]);
                            $archivoAnexo_guardar = $nombre_limpio.date('his').'.'.$extension;
                        } else if(count($archivosFotografia_array) > 1){ //si solo es un punto
                            $extension = $archivosFotografia_array[(count($archivosFotografia_array) -1)];
                            $nombre_limpio = clean_string($txtNombreDocumento[$key]);
                            $archivoAnexo_guardar = $nombre_limpio.date('his').'.'.$extension;
                        }

                        if (file_exists($carpetaTemporalAnexo.trim($txtArchivo[$key]))) {
                            copy($carpetaTemporalAnexo.trim($txtArchivo[$key]), $carpetaDestinoAnexo.trim($archivoAnexo_guardar));
                            unlink($carpetaTemporalAnexo.trim($txtAnexoDocumento[$key]));
                            $rutaGuardarAnexoPaciente = "uploads/modulo_medico/expediente_documentos_anexo/".trim($archivoAnexo_guardar);
                        }

                    }
                    $nombre_limpio = clean_string($txtNombreDocumento[$key]);
                    $guardar_AnexoPaciente[] = array(
                        'apa_id_epp' => $epp_id,
                        'apa_url' => $rutaGuardarAnexoPaciente,
                        'apa_nombre' => $nombre_limpio,
                        'apa_estado' => 1,
                        'apa_usu_creacion' => $this->tank_auth->get_user_id(),
                        'apa_fecha_creacion' => date('Y-m-d h:i:s'),
                        'apa_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'apa_fecha_modificacion' => date('Y-m-d h:i:s')
                    );

                }
            }
            if(count($guardar_AnexoPaciente) > 0){
                $this->gsatelite->ingresar('apa_anexo_paciente', $guardar_AnexoPaciente, true);
            }

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Expediente de Paciente", 'texto_alerta' => "El registro se guardó correctamente.");

            /* ===========================================================================================================
                                            REDIRECCIONES
            =========================================================================================================== */
            $redireccion = $this->input->post('redireccion');
            $this->session->set_flashdata($alerta);

            if ($modal > 0) {
                echo $epp_id;
                die();
            } else {
                if ($redireccion == 0) {
                    redirect('modulo_medico/med_procesos/agregar_expediente_paciente/');
                } else if ($redireccion == 1) {
                    redirect('modulo_medico/med_procesos/expediente_paciente/');
                }
            }  
            
            die();
        }

        $clasificacion_cliente_reg = $this->gsatelite->get_tabla('cfc_clasificacion_cliente', array('cfc_estado' => 1));
        $select = "";
        foreach ($clasificacion_cliente_reg as $key => $value) {
            $selected = ($value['cfc_defecto'] == 1)?'selected':'';
            $select .= '<option value="'.$value['cfc_id'].'" '.$selected.'>'.$value['cfc_nombre'].'</option>';
        }
        $data['slcClasificacionCliente'] = $select;

        $row_pai_defecto = $this->gsatelite->get_registro('pai_pais', array('pai_estado' => 1, 'pai_defecto' => 1));
        $idpai = (is_object($row_pai_defecto)) ? $row_pai_defecto->pai_id : null;
        $select = $this->gsatelite->get_dropdown('pai_pais', '{pai_nacionalidad}', '', array('pai_estado' => 1), $idpai, '', 'pai_id', true);
        $data['slcNacionalidad'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('gen_genero', '{gen_nombre}', '', array('gen_estado' => 1), null, '', 'gen_id', true);
        $data['slcGenero'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('esc_estado_civil', '{esc_nombre}', '', array('esc_estado' => 1), null, '', 'esc_id', true);
        $data['slcEstadoCivil'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('ref_referido', '{ref_nombre}', '', array('ref_estado' => 1), null, '', 'ref_id', true);
        $data['slcReferidoPor'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);        
        $select = $this->gsatelite->get_dropdown('med_medico', '{med_nombre}', '', array('med_estado' => 1), null, '', 'med_id', true);
        $data['slcMedico'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('pro_profesion', '{pro_nombre}', '', array('pro_estado' => 1), null, '', 'pro_id', true);
        $data['slcProfesion'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);        
        /* tab seguro */
        $select = $this->gsatelite->get_dropdown('ase_aseguradora', '{ase_nombre}', '', array('ase_estado' => 1), null, '', 'ase_id', true);
        $data['slcAseguradoraSeguro'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        // pol_poliza
        // sep_seguro_paciente
        /* tab contactos */
        $select = $this->gsatelite->get_dropdown('tit_tipo_telefono', '{tit_nombre}', '', array('tit_estado' => 1), null, '', 'tit_id', true);
        $data['slcTipoTelefonoContacto'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

        /* tab documentos */
        $tipo_documento_reg = $this->gsatelite->get_tabla('tde_tipo_documento', array('tde_estado' => 1));
        $select = "";
        foreach ($tipo_documento_reg as $key => $value) {
            $select .= '<option value="'.$value['tde_id'].'" data-mascara="'.$value['tde_mascara'].'">'.$value['tde_nombre'].'</option>';
        }
        $data['slcTipoDocDocumento'] = $select;

        /* tab datos clinicos */
        $select = $this->gsatelite->get_dropdown('pat_parentesco', '{pat_nombre}', '', array('pat_estado' => 1), null, '', 'pat_id', true);
        $data['slcParentezcoClinico'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

        $select = $this->gsatelite->get_dropdown('epm_especialidad_medica', '{epm_nombre}', '', array('epm_estado' => 1), null, '', 'epm_id', true);
        $data['slcControlesEspecialidadClinico'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

        $select = $this->gsatelite->get_dropdown('tsr_tipo_sangre', '{tsr_nombre}', '', array('tsr_estado' => 1), null, '', 'tsr_id', true);
        $data['slcTipoSangreClinico'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

        $select = $this->gsatelite->get_dropdown('coa_componente_alergico', '{coa_nombre}', '', array('coa_estado' => 1), null, '', 'coa_id', true);
        $data['txtAlergicoClinico'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

        $select = $this->gsatelite->get_dropdown('enf_enfermedad', '{enf_nombre}', '', array('enf_estado' => 1), null, '', 'enf_id', true);
        $data['txtPadeceAlgunaEnfermedadClinico'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        
        

        $data['modal'] = $modal;

        if ($modal == 1) {
            $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_procesos/agregar_expediente_paciente',$data);
        }else{
            cargarvista($data);
        } 
    }


    /**
     * Descripción:
     * Función para obtener el último número de expediente del paciente dependiendo de la clasificación
     * @author Elmer Hernández - Grupo satélite
     * @since  2019-11-18
     * @param  Ninguno
     * @return 
     */

    function obtener_ultimo_num_expediente(){
        $clasificacion = $cla = $this->input->post('clasificacion');
        $tbl_clasificacion = $this->gsatelite->get_tabla('cfc_clasificacion_cliente', array('cfc_id' => $clasificacion));
        $prefijo = $pre = ($tbl_clasificacion[0]['cfc_prefijo'] != "") ? ($tbl_clasificacion[0]['cfc_prefijo']) : '';
        //OBTIENE EL MAX NUMERO DE EXPEDIENTE SIN TOMAR EN CUENTA LAS LETRAS
        $num = $this->db->select("MAX(CAST(REPLACE(epp_numero_expediente,'$pre','') AS UNSIGNED)) AS num", false)->where('epp_id_cfc', $cla)->from('epp_expediente_paciente')->get()->result_array();
        if (count($num) > 0) {
            $num_corr = intval($num[0]['num']) + 1;
        } else {
            $num_corr = 1;
        }
        $correlativo = str_pad($num_corr, 4, "0", STR_PAD_LEFT);
        $data = $prefijo . $correlativo;
        echo json_encode($data);
    }

    public function ver_expediente_paciente($eppid){
        satelite_validar();
        $this->editar_expediente_paciente($eppid, null, 1);
    }

    /**
     * Descripción:
     * Función para editar el expediente del paciente
     * @author Habby Lovo - Grupo satélite
     * @since  2019-08-12
     * @param  Ninguno
     * @return 
     */
    public function editar_expediente_paciente($id, $id_cli = null, $read = null){
        satelite_validar();
        if ($this->input->post()) {
            // var_dump($this->input->post());die();
            /* tab generales */
            $slcClasificacion = $this->input->post('slcClasificacion'); //epp_id_cfc
            $txtNoExpediente = $this->input->post('txtNoExpediente'); //epp_numero_expediente
            /* fotografia */
            $txtFotografiaGeneral = $this->input->post('txtFotografiaGeneral'); //epp_url_fotografia
            $txtCarpetaFotografiaGeneral = $this->input->post('txtCarpetaFotografiaGeneral'); //epp_url_fotografia
            $txtNombre = $this->input->post('txtNombre'); //epp_nombre
            $slcNacionalidad = $this->input->post('slcNacionalidad'); //epp_id_pai
            $txtApellido = $this->input->post('txtApellido'); //epp_apellido
            $slcDepartamento = $this->input->post('slcDepartamento'); //epp_id_dep
            $txtApellidoCasada = $this->input->post('txtApellidoCasada'); //epp_apellido_casada
            $slcCiudad = $this->input->post('slcCiudad'); //epp_id_ciu
            $slcMunicipio = $this->input->post('slcMunicipio'); //epp_id_mun
            $apellido_full = (trim($txtApellidoCasada) != "") ? $txtApellido . ' ' . $txtApellidoCasada : $txtApellido;
            $slcDistrito = $this->input->post('slcDistrito');

            $slcGenero = $this->input->post('slcGenero'); //epp_id_gen
            $slcEstadoCivil = $this->input->post('slcEstadoCivil'); //epp_id_esc
            $txtDireccion = $this->input->post('txtDireccion'); //epp_direccion
            $txtFechaNacimiento = $this->input->post('txtFechaNacimiento'); //epp_fecha_nacimiento
            $txtEmail = $this->input->post('txtEmail'); //epp_correo
            $txtEdad = $this->input->post('txtEdad');
            $slcReferidoPor = $this->input->post('slcReferidoPor'); //epp_id_ref
            $slcProfesion = $this->input->post('slcProfesion'); //epp_id_pro
            $txtNombreReferidoPor = $this->input->post('txtNombreReferidoPor'); //no esta-----------------------------
            $txtOcupacion = $this->input->post('txtOcupacion'); //epp_ocupacion
            $slcMedico = $this->input->post('slcMedico'); //epp_id_med
            $txtComentario = $this->input->post('txtComentario'); //txtComentario
            /* tab seguro */
            $txtEdicionSeguro = $this->input->post('txtEdicionSeguro'); //array
            $slcAseguradoraSeguro = $this->input->post('slcAseguradoraSeguro'); //array
            $slcPolizaSeguro = $this->input->post('slcPolizaSeguro'); //array
            $slcNumeroSeguro = $this->input->post('slcNumeroSeguro'); //array sep_id_pol
            $chkTipoSeguro = $this->input->post('chkTipoSeguro'); //array sep_tipo
            $txtPorSeguroSeguro = $this->input->post('txtPorSeguroSeguro'); //array sep_porcentaje_seguro
            $txtPorPacienteSeguro = $this->input->post('txtPorPacienteSeguro'); //array sep_porcentaje_paciente
            $txtCertificadoSeguro = $this->input->post('txtCertificadoSeguro'); //array sep_certificado

            /* tab contactos */
            $txtEdicionContacto = $this->input->post('txtEdicionContacto'); //array
            $txtNombreContacto = $this->input->post('txtNombreContacto'); //array
            $slcTipoTelefonoContacto = $this->input->post('slcTipoTelefonoContacto'); //array
            $txtObservacionContacto = $this->input->post('txtObservacionContacto'); //array
            $txtNumeroContacto = $this->input->post('txtNumeroContacto'); //array

            /* tab documentos */
            $txtEdicionDocumento = $this->input->post('txtEdicionDocumento'); //array
            $slcTipoDocDocumento = $this->input->post('slcTipoDocDocumento'); //array
            $txtNoDocDocumento = $this->input->post('txtNoDocDocumento'); //array
            $txtLugarExpDocumento = $this->input->post('txtLugarExpDocumento'); //array
            $txtFechaExpDocumento = $this->input->post('txtFechaExpDocumento'); //array
            $txtFechaVenDocumento = $this->input->post('txtFechaVenDocumento'); //array
                /*anexo*/
            $txtCarpetaAnexoDocumento = $this->input->post('txtCarpetaAnexoDocumento'); //array
            $txtAnexoDocumento = $this->input->post('txtAnexoDocumento'); //array

            /* tab datos clinicos */
            $txtEmergenciaLLamarClinico = $this->input->post('txtEmergenciaLLamarClinico'); //epp_emergencia_llamar
            $slcPoseeCirugiasPreviasClinico = $this->input->post('slcPoseeCirugiasPreviasClinico'); //epp_posee_cirugias

            $txtMencioneCirujia = $this->input->post('txtMencioneCirujia'); //epp_descripcion_posee_cirugias

            $slcParentezcoClinico = $this->input->post('slcParentezcoClinico'); //epp_id_pat
            $slcControlesEspecialidadClinico = $this->input->post('slcControlesEspecialidadClinico'); //epp_id_epm

            $txtNumeroClinico = $this->input->post('txtNumeroClinico'); //epp_telefono_emergencia
            $slcTipoSangreClinico = $this->input->post('slcTipoSangreClinico'); //epp_id_tsr

            $txtMotivoControlClinico = $this->input->post('txtMotivoControlClinico'); //epp_motivo_control

            $txtAlergicoClinico = $this->input->post('txtAlergicoClinico'); //array

            $txtPadeceAlgunaEnfermedadClinico = $this->input->post('txtEnfermedad'); //array epp_id_enf
            $txtTratamientoPrevio = $this->input->post('txtTratamientoPrevio'); //array enp_tratamientoprevio
            $txtEvolucion = $this->input->post('txtEvolucion'); //array epp_evolucion
            $txtExamenPrevio = $this->input->post('txtExamenPrevio'); //array epp_examenprevio

            $txtAceptaTrafucionClinico = $this->input->post('txtAceptaTrafucionClinico'); //epp_acepta_tranfusion
            $slcDiscapacidadClinico = $this->input->post('slcDiscapacidadClinico'); //epp_posee_discapacidad

            $txtComentarioClinico = $this->input->post('txtComentarioClinico'); //epp_comentario_datos_clinicos

            $txtMencioneDiscapacidadClinico = $this->input->post('txtMencioneDiscapacidadClinico'); //epp_descripcion_discapacidad

            /* tab anexos */
            $txtArchivo = $this->input->post('txtArchivo');
            $txtArchivoOriginal = $this->input->post('txtArchivoOriginal');
            $txtRutaArchivo = $this->input->post('txtRutaArchivo');
            $txtTamanio = $this->input->post('txtTamanio');
            $txtEdicionAdjunto = $this->input->post('txtEdicionAdjunto');
            $txtNombreDocumento = $this->input->post('txtNombreDocumento');

            //////////////////////////////////////////////////////////
            $txtImagenNueva = $this->input->post('imagen_nueva');
            /////////////////////////////////////////////////////////
            //print_r($txtImagenNueva);die();
            if ($txtImagenNueva > 0){
                $rutaGuardarFotografia = '';
                $carpetaDestinoFotografia = FCPATH."uploads/modulo_medico/expediente_documentos_fotografia/";
                $carpetaTemporalFotografia = FCPATH.$txtCarpetaFotografiaGeneral;
                if($txtCarpetaFotografiaGeneral != ''){

                    $archivoFotografia_guardar = '';
                    //se separa el nombre de la imagen en el punto
                    $archivosFotografia_array = explode('.', $txtFotografiaGeneral); 
                    //en el caso que se encuentren varios puntos
                    if(count($archivosFotografia_array) > 2){ 
                        $extension = $archivosFotografia_array[(count($archivosFotografia_array) -1)];
                        unset($archivosFotografia_array[(count($archivosFotografia_array) -1)]);
                        $archivoFotografia_guardar = implode('', $archivosFotografia_array).date('his').'.'.$extension;
                        //si solo es un punto
                    } else if(count($archivosFotografia_array) > 1){ 
                        $extension = $archivosFotografia_array[(count($archivosFotografia_array) -1)];
                        $archivoFotografia_guardar = $archivosFotografia_array[0].date('his').'.'.$extension;
                    }

                    if (file_exists($carpetaTemporalFotografia.trim($txtFotografiaGeneral))) {
                        copy($carpetaTemporalFotografia.trim($txtFotografiaGeneral), $carpetaDestinoFotografia.trim($archivoFotografia_guardar));
                        unlink($carpetaTemporalFotografia.trim($txtFotografiaGeneral));
                        $rutaGuardarFotografia = "uploads/modulo_medico/expediente_documentos_fotografia/".trim($archivoFotografia_guardar);
                    }
                }
            }

            $guardar_cliente = array(
                'cli_id_pai' => ($slcNacionalidad > 0)?$slcNacionalidad:null, //pais
                'cli_id_pro' => ($slcProfesion > 0)?$slcProfesion:null, //profesion
                'cli_id_mun' => ($slcMunicipio > 0)?$slcMunicipio:null,
                'cli_id_dis' => ($slcDistrito > 0)?$slcDistrito:null,
                'cli_id_cfc' => ($slcClasificacion > 0)?$slcClasificacion:null,
                'cli_codigo' => $txtNoExpediente,
                'cli_apellido' => $apellido_full,
                'cli_nombre' => $txtNombre,
                'cli_email' => $txtEmail,
                'cli_direccion' => $txtDireccion,
                // 'cli_representante' => $nosedondesesaca, ver 
                'cli_fecha_registro' => date('Y-m-d h:i:s'),
                'cli_fecha_nacimiento' => ($txtFechaNacimiento != '')?formatear_fecha("Y-m-d", $txtFechaNacimiento):null,
                'cli_fotografia' => ($txtImagenNueva > 0)? $rutaGuardarFotografia : $txtFotografiaGeneral,
                'cli_usu_mod' => $this->tank_auth->get_user_id(),
                'cli_fecha_mod' => date('Y-m-d h:i:s')
            );

            $cli_id = $this->gsatelite->actualizar_array('cli_cliente', $guardar_cliente, array('cli_id' =>$id_cli));

            $guardar_expediente = array(
                'epp_id_cfc' => ($slcClasificacion > 0)?$slcClasificacion:null,
                'epp_id_gen' => ($slcGenero > 0)?$slcGenero:null,
                'epp_id_pro' => ($slcProfesion > 0)?$slcProfesion:null,
                'epp_id_pai' => ($slcNacionalidad > 0)?$slcNacionalidad:null,
                'epp_id_dep' => ($slcDepartamento > 0)?$slcDepartamento:null,
                'epp_id_mun' => ($slcMunicipio > 0)?$slcMunicipio:null,
                'epp_id_dis' => ($slcDistrito > 0) ? $slcDistrito : null,
                'epp_id_ciu' => ($slcCiudad > 0)?$slcCiudad:null,
                'epp_id_ref' => ($slcReferidoPor > 0)?$slcReferidoPor:null,
                'epp_id_esc' => ($slcEstadoCivil > 0)?$slcEstadoCivil:null,
                'epp_id_epm' => ($slcControlesEspecialidadClinico > 0)?$slcControlesEspecialidadClinico:null,
                'epp_id_pat' => ($slcParentezcoClinico > 0)?$slcParentezcoClinico:null,
                'epp_id_tsr' => ($slcTipoSangreClinico > 0)?$slcTipoSangreClinico:null,
                'epp_id_med' => ($slcMedico > 0)?$slcMedico:null,
                'epp_numero_expediente' => $txtNoExpediente,
                'epp_nombre' => $txtNombre,
                'epp_apellido' => $txtApellido,
                'epp_apellido_casada' => $txtApellidoCasada,
                'epp_fecha_nacimiento' => ($txtFechaNacimiento != '')?formatear_fecha("Y-m-d", $txtFechaNacimiento):null,
                'epp_ocupacion' => $txtOcupacion,
                'epp_url_fotografia' => ($txtImagenNueva > 0)? $rutaGuardarFotografia : $txtFotografiaGeneral,
                'epp_direccion' => $txtDireccion,
                'epp_correo' => $txtEmail,
                'epp_comentario' => $txtComentario,
                'epp_nombre_ref_por' => $txtNombreReferidoPor,
                'epp_descripcion_cirugia' => $txtMencioneCirujia,
                'epp_emergencia_llamar' => $txtEmergenciaLLamarClinico,
                'epp_telefono_emergencia' => $txtNumeroClinico,
                'epp_acepta_tranfusion' => ($txtAceptaTrafucionClinico != '')?$txtAceptaTrafucionClinico:0,
                'epp_posee_discapacidad' => ($slcDiscapacidadClinico != '')?$slcDiscapacidadClinico:0,
                'epp_descripcion_discapacidad' => $txtMencioneDiscapacidadClinico,
                'epp_posee_cirugias' => ($slcPoseeCirugiasPreviasClinico != '')?$slcPoseeCirugiasPreviasClinico:0,
                'epp_motivo_control' => $txtMotivoControlClinico,
                'epp_comentario_datos_clinicos' => $txtComentarioClinico,
                'epp_estado' => 1,
                'epp_usu_modificacion' => $this->tank_auth->get_user_id(),
                'epp_fecha_modificacion' => date('Y-m-d h:i:s')
            );
            
            $epp_id = $this->gsatelite->actualizar_array('epp_expediente_paciente', $guardar_expediente, array('epp_id' => $id));

            $guardar_SeguroPaciente = [];
            $this->gsatelite->borrado_general('sep_seguro_paciente', array('sep_id_epp'=>$id));
            if(is_array($txtEdicionSeguro) && count($txtEdicionSeguro) > 0){
                foreach ($txtEdicionSeguro as $key => $value) {
                    $guardar_SeguroPaciente[] = array(
                        'sep_id_pol' => $slcNumeroSeguro[$key],
                        'sep_id_epp' => $id,
                        'sep_certificado' => $txtCertificadoSeguro[$key],
                        'sep_porcentaje_seguro' => $txtPorSeguroSeguro[$key],
                        'sep_porcentaje_paciente' => $txtPorPacienteSeguro[$key],
                        'sep_tipo' => $chkTipoSeguro[$key],
                        'sep_estado' => 1,
                        'sep_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sep_fecha_creacion' => date('Y-m-d h:i:s'),
                        'sep_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sep_fecha_modificacion' => date('Y-m-d h:i:s')
                    );
                }
            }
            if(count($guardar_SeguroPaciente) > 0){
                $this->gsatelite->ingresar('sep_seguro_paciente', $guardar_SeguroPaciente, true);
            }

            $guardar_ContactoPaciente = [];
            $this->gsatelite->borrado_general('cpt_contacto_paciente', array('cpt_id_epp'=>$id));
            if(is_array($txtEdicionContacto) && count($txtEdicionContacto) > 0){
                foreach ($txtEdicionContacto as $key => $value) {
                    $guardar_ContactoPaciente[] = array(
                        'cpt_id_tit' => $slcTipoTelefonoContacto[$key],
                        'cpt_id_epp' => $id,
                        'cpt_nombre' => $txtNombreContacto[$key],
                        'cpt_telefono' => $txtNumeroContacto[$key],
                        'cpt_observacion' => $txtObservacionContacto[$key],
                        'cpt_estado' => 1,
                        'cpt_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cpt_fecha_creacion' => date('Y-m-d h:i:s'),
                        'cpt_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cpt_fecha_modificacion' => date('Y-m-d h:i:s')
                    );
                }
            }
            if(count($guardar_ContactoPaciente) > 0){
                $this->gsatelite->ingresar('cpt_contacto_paciente', $guardar_ContactoPaciente, true);
            }


            $guardar_DocumentoPaciente = [];
            $documento = $this->gsatelite->get_tabla("dop_documento_paciente",array("dop_id_epp" => $id));
            $documento_id = array_column($documento ,'dop_id');
            if(is_array($txtEdicionDocumento) && count($txtEdicionDocumento) > 0){

                foreach ($txtEdicionDocumento as $key => $value) {
                    // print_r('id'.$value);
                    // print_r($documento_id);
                    // print_r(in_array($value , $documento_id));
                    if (!in_array($value , $documento_id)) {
                        $rutaGuardarAnexo = '';
                        $carpetaDestinoAnexo = FCPATH."uploads/modulo_medico/expediente_documentos/";
                        $carpetaTemporalAnexo = FCPATH.$txtCarpetaAnexoDocumento[$key];
                        if($txtCarpetaAnexoDocumento[$key] != ''){

                            $archivoFotografia_guardar = '';
                            $archivosFotografia_array = explode('.', $txtAnexoDocumento[$key]); //se separa el nombre de la imagen en el punto
                            if(count($archivosFotografia_array) > 2){ //en el caso que se encuentren varios puntos
                                $extension = $archivosFotografia_array[(count($archivosFotografia_array) -1)];
                                unset($archivosFotografia_array[(count($archivosFotografia_array) -1)]);
                                $archivoFotografia_guardar = implode('', $archivosFotografia_array).date('his').'.'.$extension;
                            } else if(count($archivosFotografia_array) > 1){ //si solo es un punto
                                $extension = $archivosFotografia_array[(count($archivosFotografia_array) -1)];
                                $archivoFotografia_guardar = $archivosFotografia_array[0].date('his').'.'.$extension;
                            }

                            if (file_exists($carpetaTemporalAnexo.trim($txtAnexoDocumento[$key]))) {
                                copy($carpetaTemporalAnexo.trim($txtAnexoDocumento[$key]), $carpetaDestinoAnexo.trim($archivoFotografia_guardar));
                                unlink($carpetaTemporalAnexo.trim($txtAnexoDocumento[$key]));
                                $rutaGuardarAnexo = "uploads/modulo_medico/expediente_documentos/".trim($archivoFotografia_guardar);
                            }

                        }
                        $guardar_DocumentoPaciente[] = array(
                            'dop_id_tde' => $slcTipoDocDocumento[$key],
                            'dop_id_epp' => $id,
                            'dop_valor' => $txtNoDocDocumento[$key],
                            'dop_fecha_registro' => date('Y-m-d h:i:s'),
                            'dop_fecha_vence' => ($txtFechaVenDocumento[$key] != '')?formatear_fecha("Y-m-d", $txtFechaVenDocumento[$key]):null,
                            'dop_fecha_expedicion' => ($txtFechaExpDocumento[$key] != '')?formatear_fecha("Y-m-d", $txtFechaExpDocumento[$key]):null,
                            'dop_lugar_expedicion' => $txtLugarExpDocumento[$key],
                            // 'dop_observacion' => $txtNombreContacto[$key],
                            'dop_titulo_anexo' => $txtAnexoDocumento[$key],
                            'dop_url_anexo' => $rutaGuardarAnexo,
                            'dop_estado' => 1,
                            'dop_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dop_fecha_creacion' => date('Y-m-d h:i:s'),
                            'dop_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dop_fecha_modificacion' => date('Y-m-d h:i:s')
                        );
                    }
                }
                
                foreach ($documento as $key => $value) {
                    if (!in_array($value['dop_id'] , $txtEdicionDocumento) ) {
                        $this->gsatelite->borrado_general('dop_documento_paciente', array('dop_id'=>$value['dop_id']));
                        unlink(FCPATH.$value['dop_url_anexo']);
                    }
                }

            }
            if(count($guardar_DocumentoPaciente) > 0){
                $this->gsatelite->ingresar('dop_documento_paciente', $guardar_DocumentoPaciente, true);
            }

            $guardar_AlergicoPaciente = [];
            $this->gsatelite->borrado_general('cap_componente_alergico_paciente', array('cap_id_epp'=>$id));
            if(is_array($txtAlergicoClinico) && count($txtAlergicoClinico) > 0){
                foreach ($txtAlergicoClinico as $key => $value) {
                    $guardar_AlergicoPaciente[] = array(
                        'cap_id_coa' => $value,
                        'cap_id_epp' => $id,
                        'cap_estado' => 1,
                        'cap_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cap_fecha_creacion' => date('Y-m-d h:i:s'),
                        'cap_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cap_fecha_modificacion' => date('Y-m-d h:i:s')
                    );
                }
            }
            if(count($guardar_AlergicoPaciente) > 0){
                $this->gsatelite->ingresar('cap_componente_alergico_paciente', $guardar_AlergicoPaciente, true);
            }

            $guardar_PadeceEnfermedadPaciente = [];
            $this->gsatelite->borrado_general('enp_enfermedad_paciente', array('enp_id_epp'=>$id));
            if(is_array($txtPadeceAlgunaEnfermedadClinico) && count($txtPadeceAlgunaEnfermedadClinico) > 0){
                foreach ($txtPadeceAlgunaEnfermedadClinico as $key => $value) {
                    $guardar_PadeceEnfermedadPaciente[] = array(
                        'enp_id_enf' => $value,
                        'enp_id_epp' => $id,
                        'enp_estado' => 1,
                        'enp_tratamiento_previo' => $txtTratamientoPrevio[$key],
                        'enp_evolucion' => $txtEvolucion[$key],
                        'enp_examen_previsto' => $txtExamenPrevio[$key],
                        'enp_usu_creacion' => $this->tank_auth->get_user_id(),
                        'enp_fecha_creacion' => date('Y-m-d h:i:s'),
                        'enp_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'enp_fecha_modificacion' => date('Y-m-d h:i:s')
                    );
                }
            }
            if(count($guardar_PadeceEnfermedadPaciente) > 0){
                $this->gsatelite->ingresar('enp_enfermedad_paciente', $guardar_PadeceEnfermedadPaciente, true);
            }

            $guardar_AnexoPaciente = [];
            $anexo = $this->gsatelite->get_tabla("apa_anexo_paciente",array("apa_id_epp" => $id));
            $anexo_id = array_column($anexo ,'apa_id');
            if(is_array($txtEdicionAdjunto) && count($txtEdicionAdjunto) > 0){
                foreach ($txtEdicionAdjunto as $key => $value) {
                    if (!in_array($value , $anexo_id)) {
                        $rutaGuardarAnexoPaciente = '';
                        $carpetaDestinoAnexo = FCPATH."uploads/modulo_medico/expediente_documentos_anexo/";
                        $carpetaTemporalAnexo = FCPATH."uploads/modulo_medico/expediente_documentos_anexo_temp/";
                        if($txtArchivo[$key] != ''){

                            $archivoAnexo_guardar = '';
                            $archivosFotografia_array = explode('.', $txtArchivo[$key]); //se separa el nombre de la imagen en el punto
                            if(count($archivosFotografia_array) > 2){ //en el caso que se encuentren varios puntos
                                $extension = $archivosFotografia_array[(count($archivosFotografia_array) -1)];
                                unset($archivosFotografia_array[(count($archivosFotografia_array) -1)]);
                                $nombre_limpio = clean_string($txtNombreDocumento[$key]);
                                $archivoAnexo_guardar = $nombre_limpio.date('his').'.'.$extension;
                            } else if(count($archivosFotografia_array) > 1){ //si solo es un punto
                                $extension = $archivosFotografia_array[(count($archivosFotografia_array) -1)];
                                $nombre_limpio = clean_string($txtNombreDocumento[$key]);
                                $archivoAnexo_guardar = $nombre_limpio.date('his').'.'.$extension;
                            }

                            if (file_exists($carpetaTemporalAnexo.trim($txtArchivo[$key]))) {
                                copy($carpetaTemporalAnexo.trim($txtArchivo[$key]), $carpetaDestinoAnexo.trim($archivoAnexo_guardar));
                                unlink($carpetaTemporalAnexo.trim($txtAnexoDocumento[$key]));
                                $rutaGuardarAnexoPaciente = "uploads/modulo_medico/expediente_documentos_anexo/".trim($archivoAnexo_guardar);
                            }

                        }
                        $nombre_limpio = clean_string($txtNombreDocumento[$key]);
                        $guardar_AnexoPaciente[] = array(
                            'apa_id_epp' => $id,
                            'apa_url' => $rutaGuardarAnexoPaciente,
                            'apa_nombre' => $nombre_limpio,
                            'apa_estado' => 1,
                            'apa_usu_creacion' => $this->tank_auth->get_user_id(),
                            'apa_fecha_creacion' => date('Y-m-d h:i:s'),
                            'apa_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'apa_fecha_modificacion' => date('Y-m-d h:i:s')
                        );
                    } else {
                        $nombre_limpio = clean_string($txtNombreDocumento[$key]);
                        $this->gsatelite->actualizar_array('apa_anexo_paciente',array('apa_nombre' => $nombre_limpio), array('apa_id' => $value));
                    }
                }

                foreach ($anexo as $key => $value) {
                    if (!in_array($value['apa_id'] , $txtEdicionAdjunto) ) {
                        $this->gsatelite->borrado_general('apa_anexo_paciente', array('apa_id'=>$value['apa_id']));
                        unlink(FCPATH.$value['apa_url']);
                    }
                }

            }
            if(count($guardar_AnexoPaciente) > 0){
                $this->gsatelite->ingresar('apa_anexo_paciente', $guardar_AnexoPaciente, true);
            }

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Expediente de Paciente", 'texto_alerta' => "El registro se guardó correctamente.");

            /* ===========================================================================================================
                                            REDIRECCIONES
            =========================================================================================================== */
            $redireccion = $this->input->post('redireccion');
            $this->session->set_flashdata($alerta);

            if ($redireccion == 0) {
                redirect('modulo_medico/med_procesos/editar_expediente_paciente/'.$id);
            } else if ($redireccion == 1) {
                redirect('modulo_medico/med_procesos/expediente_paciente/');
            }
            
            die();
        }
        $paciente = $this->medico_model->get_tabla_expediente_paciente(array('epp_id' => $id));
        $data['paciente'] = $paciente[0];
        $cap_componente_alergico_paciente = $this->gsatelite->get_tabla("cap_componente_alergico_paciente",array("cap_id_epp" => $paciente[0]['epp_id']));
        $alergia = array_column($cap_componente_alergico_paciente, 'cap_id_coa');
        // $enfermedad_paciente = $this->gsatelite->get_tabla("enp_enfermedad_paciente",array("enp_id_epp" => $paciente[0]['epp_id']));
        // $enfermedad = array_column($enfermedad_paciente, 'enp_id_enf');
        $clasificacion_cliente_reg = $this->gsatelite->get_tabla('cfc_clasificacion_cliente', array('cfc_estado' => 1));
        $select = "";
        foreach ($clasificacion_cliente_reg as $key => $value) {
            $selected = ($value['cfc_id'] == $paciente[0]['epp_id_cfc'])?'selected':'';
            $select .= '<option value="'.$value['cfc_id'].'" '.$selected.'>'.$value['cfc_nombre'].'</option>';
        }
        $data['slcClasificacionCliente'] = $select;
        $select = $this->gsatelite->get_dropdown('pai_pais', '{pai_nacionalidad}', '', array('pai_estado' => 1), $paciente[0]['epp_id_pai'], '', 'pai_id', true);
        $data['slcNacionalidad'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', array('dep_estado' => 1, 'dep_id_pai' => $paciente[0]['epp_id_pai']), $paciente[0]['epp_id_dep'], '', 'dep_id', true);
        $data['slcDepartamento'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', array('mun_estado' => 1, 'mun_id_dep' => $paciente[0]['epp_id_dep']), $paciente[0]['epp_id_mun'], '', 'mun_id', true);
        $data['slcCiudad'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('dis_distrito', '{dis_nombre}', '', array('dis_estado' => 1, 'dis_id_mun' => $paciente[0]['epp_id_mun']), $paciente[0]['epp_id_dis'], '', 'dis_id', true);
        $data['slcDistritos'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('gen_genero', '{gen_nombre}', '', array('gen_estado' => 1), $paciente[0]['epp_id_gen'], '', 'gen_id', true);
        $data['slcGenero'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('esc_estado_civil', '{esc_nombre}', '', array('esc_estado' => 1), $paciente[0]['epp_id_esc'], '', 'esc_id', true);
        $data['slcEstadoCivil'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('ref_referido', '{ref_nombre}', '', array('ref_estado' => 1), $paciente[0]['epp_id_ref'], '', 'ref_id', true);
        $data['slcReferidoPor'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);        
        $select = $this->gsatelite->get_dropdown('med_medico', '{med_nombre}', '', array('med_estado' => 1), $paciente[0]['epp_id_med'], '', 'med_id', true);
        $data['slcMedico'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('pro_profesion', '{pro_nombre}', '', array('pro_estado' => 1), $paciente[0]['epp_id_pro'], '', 'pro_id', true);
        $data['slcProfesion'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);        
        /* tab seguro */
        $select = $this->gsatelite->get_dropdown('ase_aseguradora', '{ase_nombre}', '', array('ase_estado' => 1), null, '', 'ase_id', true);
        $data['slcAseguradoraSeguro'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        /* tab contactos */
        $select = $this->gsatelite->get_dropdown('tit_tipo_telefono', '{tit_nombre}', '', array('tit_estado' => 1), null, '', 'tit_id', true);
        $data['slcTipoTelefonoContacto'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        /* tab documentos */
        $tipo_documento_reg = $this->gsatelite->get_tabla('tde_tipo_documento', array('tde_estado' => 1));
        $select = "";
        foreach ($tipo_documento_reg as $key => $value) {
            $select .= '<option value="'.$value['tde_id'].'" data-mascara="'.$value['tde_mascara'].'">'.$value['tde_nombre'].'</option>';
        }
        $data['slcTipoDocDocumento'] = $select;
        /* tab datos clinicos */
        $select = $this->gsatelite->get_dropdown('pat_parentesco', '{pat_nombre}', '', array('pat_estado' => 1), $paciente[0]['epp_id_pat'], '', 'pat_id', true);
        $data['slcParentezcoClinico'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('epm_especialidad_medica', '{epm_nombre}', '', array('epm_estado' => 1), $paciente[0]['epp_id_epm'], '', 'epm_id', true);
        $data['slcControlesEspecialidadClinico'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('tsr_tipo_sangre', '{tsr_nombre}', '', array('tsr_estado' => 1), $paciente[0]['epp_id_tsr'], '', 'tsr_id', true);
        $data['slcTipoSangreClinico'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('coa_componente_alergico', '{coa_nombre}', '', array('coa_estado' => 1), $alergia, '', 'coa_id', true);
        $data['txtAlergicoClinico'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('enf_enfermedad', '{enf_nombre}', '', array('enf_estado' => 1), NULL, '', 'enf_id', true);
        $data['txtPadeceAlgunaEnfermedadClinico'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);        
        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $data['seguro'] = $this->medico_model->get_seguro_paciente(array('sep_id_epp' => $paciente[0]['epp_id']));
        $data['html_seguro'] = $this->load->view('modulo_medico/med_procesos/grid_seguro_paciente',$data,true);
        $data['contacto'] = $this->medico_model->get_contacto_paciente(array('cpt_id_epp' => $paciente[0]['epp_id']));
        $data['html_contacto'] = $this->load->view('modulo_medico/med_procesos/grid_contacto_paciente',$data,true);
        $data['documento'] = $this->medico_model->get_documento(array('dop_id_epp' => $paciente[0]['epp_id']));
        $data['html_documento'] = $this->load->view('modulo_medico/med_procesos/grid_documentos',$data,true);
        $data['anexo'] = $this->gsatelite->get_tabla("apa_anexo_paciente",array("apa_id_epp" => $paciente[0]['epp_id']));
        $data['html_anexo'] = $this->load->view('modulo_medico/med_procesos/grid_anexo_medico',$data,true);
        $this->db->join('enf_enfermedad', 'enp_id_enf = enf_id','left');
        $data['enfermedad'] = $this->gsatelite->get_tabla("enp_enfermedad_paciente",array("enp_id_epp" => $paciente[0]['epp_id']));
        $data['html_enfermedad'] = $this->load->view('modulo_medico/med_procesos/grid_enfermedades',$data,true);
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $data['es_read'] = ($read) ? 1 : 0;
        $data['titulo_personal'] = 'Editar Expediente de Paciente';
        cargarvista($data, null, 'modulo_medico/med_procesos/editar_expediente_paciente');
    }

        /**
     * Descripción:
     * vista de las citas que tiene los pacientes (tabla: epp_expediente_paciente)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-10
     * @param none
     * @return none
     */
    public function citas_medicas() {
        satelite_validar();
        if ($_POST) {
            $paciente = $this->input->post('slcpaciente');
            $fecha_desde = formatear_fecha('Y-m-d',$this->input->post('txtfdesde'));
            $fecha_hasta = formatear_fecha('Y-m-d',$this->input->post('txtfhasta'));
            $estado = $this->input->post('slcestado');
            if ($paciente != '') {
                $where['epp_id'] = $paciente;
            }
            if ($fecha_desde != '') {
                $where["DATE(cim_fecha_cita) >= "] = $fecha_desde;
            }
            if ($fecha_hasta != '') {
                $where["DATE(cim_fecha_cita) <= "] = $fecha_hasta;
            }
            if ($estado != '') {
                $where["cim_estado_cita"] = $estado;
            }
            if (isset($where)) {
                               $this->db->group_by('cim_id');
                $cita_medica = $this->medico_model->informacion_cita($where);
            } else {
                               $this->db->group_by('cim_id');
                $cita_medica = $this->medico_model->informacion_cita();
            }
            $data['cita_medica'] = $cita_medica;
            $html = $this->load->view('modulo_medico/med_procesos/grid_citas_medicas',$data,true);
            if (!(count($cita_medica) > 0)) {
                $html = '<td colspan="7">No se encontraron registros</td>';
            }
            echo json_encode(array('tabla' => trim($html), 'filas' => count($cita_medica)));
            die();
        }
        //                $this->db->group_by('cim_id');
        // $cita_medica = $this->medico_model->informacion_cita();
        $data['cita_medica'] = array();// $cita_medica; //NO SE CARGARAN DATOS POR DEFECTO PARA MEJORAR EL DESEMPEÑO
        $data['html'] = $this->load->view('modulo_medico/med_procesos/grid_citas_medicas',$data,true);
        $pacienta_dropdown = $this->gsatelite->get_dropdown('epp_expediente_paciente', '{epp_nombre}', '', '','', '', 'epp_id', true);
        $pacienta_dropdown = str_replace('<option value="0">Sin Registros</option>', '', $pacienta_dropdown); 
        $data['pacienta_dropdown']     = str_replace('<option value="0">Seleccione</option>', '', $pacienta_dropdown);
        $data['titulo_personal'] = "Citas";
        cargarvista($data);
    }

    public function exportar_citas(){
        satelite_validar();
        $where = array();
        $tpr = $this->input->post('export');
        $epp = $this->input->post('xpednte');
        $stt = $this->input->post('estados');
        $fds = formatear_fecha('Y-m-d', $this->input->post('fecha_d'));
        $fhs = formatear_fecha('Y-m-d', $this->input->post('fecha_h'));
        if ($epp > 0) {
            $where['epp_id'] = $epp;
        }
        if ($fds != '') {
            $where["DATE(cim_fecha_cita) >= "] = $fds;
        }
        if ($fhs != '') {
            $where["DATE(cim_fecha_cita) <= "] = $fhs;
        }
        if ($stt != '') {
            $where["cim_estado_cita"] = $stt;
        }
        $periodo = (trim($fds) != "") ? "Desde: " . formatear_fecha('d-m-Y', $fds) . " " : "";
        $periodo .= (trim($fhs) != "") ? "Hasta: " . formatear_fecha('d-m-Y', $fhs) : "";
        $data['periodo'] = $periodo;
        $data['tipo_repo'] = $tpr;
                            $this->db->group_by('cim_id');
        $data['registro'] = $this->medico_model->informacion_cita($where);
        $html = $this->load->view('modulo_medico/med_procesos/grid_citas_medicas_export',$data,true);
        if ($tpr == "exc") {
            echo $html;
        } else {
            $reporte = $this->load->view('reporte/header', array('titulo' => 'Listado de citas medicas agendadas', 'subtitulo' => $periodo), true);
            $reporte .= $html;
            $this->pdf->makePDF($reporte, 'P');
        }
    }

    /**
     * Descripción:
     * funcion para agregar cita
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-08-15
     * @param  Ninguno
     * @return 
     */
    public function agregar_cita(){
        satelite_validar();
        if ($_POST) {
            $desde = formatear_fecha('H:i:s', $this->input->post('txthdesde'));
            $new_hora = date_create($desde);
            date_add($new_hora, date_interval_create_from_date_string("+1 second"));
            $paciente = $this->input->post('slcpaciente');
            $fecha_consulta = formatear_fecha('Y-m-d', $this->input->post('txtfconsulta'));
            $tipo_consulta = ($this->input->post('slctipoconsulta') != '')? $this->input->post('slctipoconsulta') : NULL;
            $codigo_cita = $this->input->post('txtnocita');
            $hora_desde = date_format($new_hora, 'H:i:s');
            $hora_hasta = formatear_fecha('H:i:s', $this->input->post('txthhasta'));
            $medico = ($this->input->post('slcmedico') != '')? $this->input->post('slcmedico') : NULL;
            $lugar = ($this->input->post('slclugar') != '')? $this->input->post('slclugar') : NULL;
            $observacion = $this->input->post('txaobservacion');
            $ruta_anexos = $this->input->post('ruta');
            $titulo_anexo = $this->input->post('titulo_doc');
            $btn = $this->input->post('btnCrear');

            $cita = array(
                'cim_id_usu' => $this->tank_auth->get_user_id(),
                'cim_id_epp' => $paciente,
                'cim_id_tcm' => $tipo_consulta,
                'cim_id_med' => $medico,
                'cim_id_luc' => $lugar,
                'cim_numero' => $codigo_cita,
                'cim_observacion' => $observacion,
                'cim_fecha_cita' => $fecha_consulta,
                'cim_hora_desde' => $hora_desde,
                'cim_hora_hasta' => $hora_hasta,
                'cim_fecha_registro' => date('Y-m-d H:i:s'),
                'cim_estado' => 1,
                'cim_usu_creacion' => $this->tank_auth->get_user_id(),
                'cim_fecha_creacion' => date('Y-m-d H:i:s'),
                'cim_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cim_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $cim_id = $this->gsatelite->ingresar('cim_cita_medica',$cita);

            //Si vienen anexos
            if (!empty($ruta_anexos)) {
                for ($i = 0; $i < count($ruta_anexos); $i++) {
                    $extension = end(explode('.', $ruta_anexos[$i]));
                    $carpeta_temporal_anx = $ruta = "public/temp/anexos_medicos/" . trim($ruta_anexos[$i]);
                    $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                    $carpeta_destino_anx = "uploads/anexos_medicos/" . $nombreArchivo;
                    $documentos_array = array(
                        'acd_id_cim'             => $cim_id,
                        'acd_url'                => $carpeta_destino_anx,
                        'acd_nombre'             => $nombreArchivo,
                        'acd_estado'             => 1,
                        'acd_usu_creacion'       => $this->tank_auth->get_user_id(),
                        'acd_fecha_creacion'     => date('Y-m-d H:i:s'),
                        'acd_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'acd_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $ant_id = $this->gsatelite->ingresar('acd_anexo_cita_medica', $documentos_array);
                    if ($ant_id > 0) {
                        copy($carpeta_temporal_anx, $carpeta_destino_anx);
                        unlink($carpeta_temporal_anx);
                    }
                }
            }
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cita", 'texto_alerta' => "El registro se guardado correctamente");
            $this->session->set_flashdata($alerta);

            if ($btn == 1) {
                redirect('/modulo_medico/med_procesos/agregar_cita');
            } else {
                redirect('/modulo_medico/med_procesos/citas_medicas');
            }
        }

        $tipo_consulta = $this->gsatelite->get_dropdown('tcm_tipo_consulta_medica', '{tcm_nombre}', '', '','', '', 'tcm_id', true);
        $tipo_consulta = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $tipo_consulta); 
        $data['tipo_consulta']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_consulta);

        $medico_dropdown = $this->gsatelite->get_dropdown('med_medico', '{med_nombre}', '', '','', '', 'med_id', true);
        $medico_dropdown = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $medico_dropdown); 
        $data['medico_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $medico_dropdown);

        $lugar_dropdown = $this->gsatelite->get_dropdown('luc_lugar_cita', '{luc_nombre}', '', array('luc_estado'=>1), null, '', 'luc_id', true);
        $lugar_dropdown = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $lugar_dropdown); 
        $data['lugar_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $lugar_dropdown);

        $correlativo = ($this->gsatelite->get_max('cim_cita_medica','cim_id') != null)? $this->gsatelite->get_max('cim_cita_medica','cim_id') + 1 : 1;

        $correlativo = str_pad($correlativo, 4, "0", STR_PAD_LEFT);

        $data['correlativo'] = 'CI-'.$correlativo;
        //print_r('CI-'.$correlativo);die();

        $data['titulo_personal'] = 'Agregar Cita';
        cargarvista($data);
    }

        /**
     * Descripción:
     * funcion para editar cita
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-08-15
     * @param  Ninguno
     * @return 
     */
    public function editar_cita($cim_id){
        satelite_validar();
        if ($_POST) {
            $paciente = $this->input->post('slcpaciente');
            $codigo_cita = $this->input->post('txtnocita');
            $tipo_consulta = ($this->input->post('slctipoconsulta') != '')? $this->input->post('slctipoconsulta') : NULL;            
            $medico = ($this->input->post('slcmedico') != '')? $this->input->post('slcmedico') : NULL;            
            $lugar = ($this->input->post('slclugar') != '')? $this->input->post('slclugar') : NULL;            
            $observacion = $this->input->post('txaobservacion');
            $ruta_anexos = $this->input->post('ruta');
            $titulo_anexo = $this->input->post('titulo_doc');
            $btn = $this->input->post('btnCrear');
            
            $fecha_consulta = formatear_fecha('Y-m-d', $this->input->post('txtfconsulta'));
            $hora_hasta = formatear_fecha('H:i:s', $this->input->post('txthhasta'));
            $desde = formatear_fecha('H:i:s', $this->input->post('txthdesde'));
            $new_hora = date_create($desde);
            date_add($new_hora, date_interval_create_from_date_string("+1 second"));
            $hora_desde = date_format($new_hora, 'H:i:s');

            $cita = array(
                'cim_id_usu' => $this->tank_auth->get_user_id(),
                'cim_id_epp' => $paciente,
                'cim_id_tcm' => $tipo_consulta,
                'cim_id_med' => $medico,
                'cim_id_luc' => $lugar,
                'cim_numero' => $codigo_cita,
                'cim_observacion' => $observacion,
                'cim_fecha_cita' => $fecha_consulta,
                'cim_hora_desde' => $hora_desde,
                'cim_hora_hasta' => $hora_hasta,
                'cim_fecha_registro' => date('Y-m-d H:i:s'),
                'cim_estado' => 1,
                'cim_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cim_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('cim_cita_medica',$cita, array('cim_id' => $cim_id));

            //Si vienen anexos
            if (!empty($ruta_anexos)) {
                for ($i = 0; $i < count($ruta_anexos); $i++) {
                    $extension = end(explode('.', $ruta_anexos[$i]));
                    $carpeta_temporal_anx = $ruta = "public/temp/anexos_medicos/" . trim($ruta_anexos[$i]);
                    $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                    $carpeta_destino_anx = "uploads/anexos_medicos/" . $nombreArchivo;

                    $documentos_array = array(
                        'acd_id_cim'             => $cim_id,
                        'acd_url'                => $carpeta_destino_anx,
                        'acd_nombre'             => $nombreArchivo,
                        'acd_estado'             => 1,
                        'acd_usu_creacion'       => $this->tank_auth->get_user_id(),
                        'acd_fecha_creacion'     => date('Y-m-d H:i:s'),
                        'acd_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'acd_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $ant_id = $this->gsatelite->ingresar('acd_anexo_cita_medica', $documentos_array);

                    if ($ant_id > 0) {
                        copy($carpeta_temporal_anx, $carpeta_destino_anx);
                        unlink($carpeta_temporal_anx);
                        die();
                    }
                }
            }
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cita", 'texto_alerta' => "El registro se guardado correctamente");
            $this->session->set_flashdata($alerta);

            if ($btn == 1) {
                redirect('/modulo_medico/med_procesos/editar_cita/'.$cim_id);
            } else {
                redirect('/modulo_medico/med_procesos/citas_medicas');
            }

        }
        $cita = $this->medico_model->informacion_cita(array('cim_id' => $cim_id));
        $data['cita'] = $cita;

        $anexos_cita = $this->gsatelite->get_tabla("acd_anexo_cita_medica",array("acd_id_cim" => $cim_id));
        $data['anexos'] = $anexos_cita;

        $tipo_consulta = $this->gsatelite->get_dropdown('tcm_tipo_consulta_medica', '{tcm_nombre}', '', '',$cita[0]['cim_id_tcm'], '', 'tcm_id', true);
        $tipo_consulta = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $tipo_consulta);
        $data['tipo_consulta']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_consulta);
        $data['tconsulta'] = $cita[0]['cim_id_tcm'];

        $medico_dropdown = $this->gsatelite->get_dropdown('med_medico', '{med_nombre}', '', '',$cita[0]['cim_id_med'], '', 'med_id', true);
        $data['idMedico']=$cita[0]['cim_id_med'];
        $medico_dropdown = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $medico_dropdown);
        $data['medico_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $medico_dropdown);

        $lugar_dropdown = $this->gsatelite->get_dropdown('luc_lugar_cita', '{luc_nombre}', '', '',$cita[0]['cim_id_luc'], '', 'luc_id', true);
        $lugar_dropdown = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $lugar_dropdown);
        $data['lugar_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $lugar_dropdown);

        $data['titulo_personal'] = 'Editar Cita';
        cargarvista($data);
    }

        /**
     * Descripción:
     * funcion para editar cita
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-08-15
     * @param  Ninguno
     * @return 
     */
    public function ver_cita($cim_id){
        satelite_validar();
        
        $cita = $this->medico_model->informacion_cita(array('cim_id' => $cim_id));
        $data['cita'] = $cita;

        $anexos_cita = $this->gsatelite->get_tabla("acd_anexo_cita_medica",array("acd_id_cim" => $cim_id));
        $data['anexos'] = $anexos_cita;

        //$sgt_id = $this->gsatelite->ingresar('sgt_seguimiento_cita', $seguimiento);
        $seguimiento_cita = $this->gsatelite->get_tabla("sgt_seguimiento_cita",array("sgt_id_cim" => $cim_id));
        $data['seguimiento_cita'] = $seguimiento_cita;


        $tipo_consulta = $this->gsatelite->get_dropdown('tcm_tipo_consulta_medica', '{tcm_nombre}', '', '',$cita[0]['cim_id_tcm'], '', 'tcm_id', true);
        $tipo_consulta = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $tipo_consulta);
        $data['tipo_consulta']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_consulta);

        $medico_dropdown = $this->gsatelite->get_dropdown('med_medico', '{med_nombre}', '', '',$cita[0]['cim_id_med'], '', 'med_id', true);
        $medico_dropdown = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $medico_dropdown);
        $data['medico_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $medico_dropdown);
        $lugar_dropdown = $this->gsatelite->get_dropdown('luc_lugar_cita', '{luc_nombre}', '', '',$cita[0]['cim_id_luc'], '', 'luc_id', true);
        $lugar_dropdown = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $lugar_dropdown);
        $data['lugar_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $lugar_dropdown);

        $data['titulo_personal'] = 'Ver Cita';
        cargarvista($data);
    }

    /**
        * Descripción:
        * seguimiento de las citas
        * @author Marlon Olmedo - Grupo Satélite
        * @since  2019-08-15
        * @param  Ninguno
        * @return modal
    */
    public function seguimiento($cim_id=null){
        satelite_validar();
        if ($_POST) {        
            $comentario = $this->input->post('txtcomentario');
            $foto_ruta = $this->input->post('nombre_imagen') ;
            $foto_titulo = $this->input->post('nombre_foto_nueva');
            $fecha = $this->input->post('fecha');
            $hora = $this->input->post('hora');
            $txtsgt_id = $this->input->post('txtsgt_id');
            $contador = 0;

            $seguimiento_table = $this->gsatelite->get_tabla("sgt_seguimiento_cita",array("sgt_id_cim" => $cim_id));
            $seguimiento_id = array_column($seguimiento_table, "sgt_id");

            
            $cantidad = count($txtsgt_id);        
            for ($i=0; $i < $cantidad; $i++) {

                if (is_array($txtsgt_id) && count($txtsgt_id) > 0) {
                    if (!in_array($txtsgt_id[$i] , $seguimiento_id)) {

                        if ($foto_ruta[$i] != null or $foto_titulo[$i] != null) {
                            $extension = end(explode('.', $foto_ruta[$i]));
                            $carpeta_temporal_anx = $ruta = "public/temp/anexos_medicos/" . trim($foto_ruta[$i]);
                            $nombreArchivo = trim($foto_titulo[$i]) . "." . trim($extension);
                            $carpeta_destino_anx = "uploads/anexos_medicos/" . $nombreArchivo;
                            } else {
                                $nombreArchivo = null;
                            }

                            $seguimiento = array('sgt_id_cim' => $cim_id,
                                                'sgt_id_usu' => $this->tank_auth->get_user_id(),
                                                'sgt_fecha' => $fecha[$i],
                                                'sgt_hora' => $hora[$i],
                                                'sgt_comentario' => $comentario[$i],
                                                'sgt_url_anexo' => $nombreArchivo,
                                                'sgt_nombre_anexo' => ($foto_titulo[$i] != '')? $foto_titulo[$i] : null,
                                                'sgt_estado' => 1,
                                                'sgt_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'sgt_fecha_creacion' => date('Y-m-d H:i:s'),
                                                'sgt_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'sgt_fecha_modificacion' => date('Y-m-d H:i:s'),);
                            //print_r($seguimiento);
                            $sgt_id = $this->gsatelite->ingresar('sgt_seguimiento_cita', $seguimiento);

                                        if ($sgt_id > 0) {
                                            if (isset($carpeta_temporal_anx) && $carpeta_destino_anx) {
                                                copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                                unlink($carpeta_temporal_anx);
                                            }
                                            $contador++;
                                        }
                        }
                    
                }
            }

            foreach ($seguimiento_table as $key => $value) {
                    if (!in_array($value['sgt_id'] , $txtsgt_id) ) {
                        $this->gsatelite->borrado_general('sgt_seguimiento_cita', array('sgt_id'=>$value['sgt_id']));
                        if ($value['sgt_url_anexo'] != null) {
                            unlink(FCPATH."uploads/anexos_medicos/".$value['sgt_url_anexo']);
                        }
                }
            }
                    //die();    

            // $datos_table = array('sgt_id' => $sgt_id,
            //                      'fecha' => formatear_fecha('d-m-Y', $fecha).' '.$hora,
            //                      'nueva_ruta' => $nombreArchivo);

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "seguimiento", 'texto_alerta' => "El segumiento se a almacenado exitosamente");
            $this->session->set_flashdata($alerta);

            echo $contador;
            die();
        }
        $seguimiento_cita = $this->gsatelite->get_tabla("sgt_seguimiento_cita",array("sgt_id_cim" => $cim_id));

        $data['seguimiento_cita'] = $seguimiento_cita;

        $data['cim_id'] = $cim_id;

        $data['titulo_personal'] = 'Seguimiento';

        $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_procesos/seguimiento',$data);
    }

        /**
     * Descripción:
     * Eliminar seguimiento de cita
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-08-15
     * @param  Ninguno
     * @return modal
     */
    public function eliminar_seguimiento(){
        satelite_validar();

        $sgt_id = $this->input->post('sgc_id');
        $ruta_foto = "uploads/anexos_medicos/".$this->input->post('ruta');

        $rows_afectadas['afectadas'] = $this->gsatelite->borrado_general('sgt_seguimiento_cita', array('sgt_id'=>$sgt_id));

        if ($rows_afectadas['afectadas'] > 0) {
           unlink($ruta_foto);
        }

        echo json_encode($rows_afectadas);
    }

        /**
     * Descripción:
     * Eliminar seguimiento de cita
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-08-15
     * @param  Ninguno
     * @return modal
     */
    public function eliminar_anexo_medico(){
        satelite_validar();

        $acd_id = $this->input->post('id');

        $ruta_foto = "uploads/anexos_medicos/".$this->input->post('url');

        $rows_afectadas['afectadas'] = $this->gsatelite->borrado_general('acd_anexo_cita_medica', array('acd_id'=>$acd_id));

        if ($rows_afectadas['afectadas'] > 0) {
           unlink($ruta_foto);
        }

        echo json_encode($rows_afectadas);
    }

    /**
     * Descripción:
     * Agregar expediente en cita 
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-08-15
     * @param  Ninguno
     * @return modal
     */
    public function cita_expediente(){
        satelite_validar();
        if ($_POST) {
            $clasificacion = $this->input->post('slcclasificacion');
            $numero_exp = $this->input->post('txtnumeroexp');
            $poliza = $this->input->post('slcpoliza');
            $nombre = $this->input->post('txtnombres');
            $numero_poliza = $this->input->post('slcnumero');
            $apellido = $this->input->post('txtapellido');
            $certificado = $this->input->post('txtcertificado');
            $apellido_casada = $this->input->post('txtcertificado');
            $tipo = $this->input->post('rbtipo');
            $genero = ($this->input->post('slcgenero') != '')? $this->input->post('slcgenero') : NULL;

            $cliente = array(
                'cli_nombre' => $nombre,
                'cli_nombre' => $apellido,
                'cli_personeria' => 1,
                'cli_fecha_registro' => date('Y-m-d H:i:s'),
                'cli_codigo' => $numero_exp,
                'cli_estado' => 1,
                'cli_usu_crea' => $this->tank_auth->get_user_id(),
                'cli_fecha_crea' => date('Y-m-d H:i:s'),
                'cli_usu_mod' => $this->tank_auth->get_user_id(),
                'cli_fecha_mod' => date('Y-m-d H:i:s')
            );
            $cli_id = $this->gsatelite->ingresar('cli_cliente', $cliente);

            if ($cli_id > 0) {
                $expediente = array(
                    'epp_id_cfc' => $clasificacion,
                    'epp_id_gen' => $genero,
                    'epp_numero_expediente' => $numero_exp,
                    'epp_nombre' => $nombre,
                    'epp_apellido' => $apellido,
                    'epp_id_cli' => $cli_id,
                    'epp_apellido_casada' => $apellido_casada,
                    'epp_estado' => 1,
                    'epp_usu_creacion' => $this->tank_auth->get_user_id(),
                    'epp_fecha_creacion' => date('Y-m-d H:i:s'),
                    'epp_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'epp_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $epp_id = $this->gsatelite->ingresar('epp_expediente_paciente', $expediente);                
            }

            if ($epp_id > 0 && $poliza != '') {
                $seguro_paciente = array(
                    'sep_id_pol' => $poliza,
                    'sep_id_epp' => $epp_id,
                    'sep_certificado' => $certificado,
                    'sep_tipo' => $tipo,
                    'sep_estado' => 1,
                    'sep_usu_creacion' => $this->tank_auth->get_user_id(),
                    'sep_fecha_creacion' => date('Y-m-d H:i:s'),
                    'sep_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sep_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $sep_id = $this->gsatelite->ingresar('sep_seguro_paciente', $seguro_paciente);
            }

            if ($cli_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Expediente", 'texto_alerta' => "El expediente se a agregado exitosamente");
                $this->session->set_flashdata($alerta);
                $validate = 1; 
                echo $validate;
                die();
            }
            

        }

        $aseguradora = $this->gsatelite->get_dropdown('ase_aseguradora', '{ase_nombre}', '', array('ase_estado'=>1),'', '', 'ase_id', true);
        $data['aseguradora'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $aseguradora);
        $clasificacion = $this->gsatelite->get_dropdown('cfc_clasificacion_cliente', '{cfc_nombre}', '', array('cfc_estado'=>1),'', '', 'cfc_id', true);
        $data['clasificacion'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $clasificacion);
        $genero = $this->gsatelite->get_dropdown('gen_genero', '{gen_nombre}', '', array('gen_estado'=>1),'', '', 'gen_id', true);
        $data['genero'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $genero);
        $data['titulo_personal'] = 'Agregar Expediente';
        $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_procesos/cita_expediente',$data);
    }

    /**
        * Descripción:
        * Modal para la confirmacion de una cita 
        * @author Marlon Olmedo - Grupo Satélite
        * @since  2019-08-15
        * @param  Ninguno
        * @return modal
    */
    public function confirmar_cita($cim_id, $calendario=null){ // variable calendario, es si viene de la vista de calendario para inavilitar los campos
        satelite_validar();
        if ($_POST) {
            // var_dump($_POST);die();
            $paciente = $this->input->post('slcpaciente');
            $fecha_consulta = formatear_fecha('Y-m-d', $this->input->post('txtfconsulta'));
            $tipo_consulta = $this->input->post('slctipoconsulta');
            $desde = formatear_fecha('H:i:s', $this->input->post('txthdesde'));
            $new_hora = date_create($desde);
            date_add($new_hora, date_interval_create_from_date_string("+1 second"));
            $hora_desde = date_format($new_hora, 'H:i:s');
            $hora_hasta = ($this->input->post('txthhasta') != "") ? formatear_fecha('H:i:s', $this->input->post('txthhasta')) : null;
            $medico = $this->input->post('slcmedico');
            $lugar = $this->input->post('slclugar');
            $observacion = $this->input->post('txaobservacion');
            $confirmar_cita = $this->input->post('confirmar_cita');
            $btn = $this->input->post('btnCrear');
            $cita = array(
                'cim_id_usu' => $this->tank_auth->get_user_id(),
                'cim_id_epp' => $paciente,
                'cim_id_tcm' => ($tipo_consulta>0)?$tipo_consulta:null,
                'cim_id_med' => ($medico>0)?$medico:null,
                'cim_id_luc' => ($lugar>0)?$lugar:null,
                'cim_observacion' => $observacion,
                'cim_fecha_cita' => $fecha_consulta,
                'cim_hora_desde' => $hora_desde,
                'cim_hora_hasta' => $hora_hasta,
                'cim_fecha_registro' => date('Y-m-d H:i:s'),
                'cim_estado_cita' => $confirmar_cita,
                'cim_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cim_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $cim_ids = $this->gsatelite->actualizar_array('cim_cita_medica',$cita, array('cim_id' => $cim_id));
            $comentario = $this->input->post('txtcomentario');
            $foto_ruta = $this->input->post('nombre_imagen') ;
            $foto_titulo = $this->input->post('nombre_foto_nueva');
            $fecha = $this->input->post('fecha');
            $hora = $this->input->post('hora');
            $txtsgt_id = $this->input->post('txtsgt_id');
            $contador = 0;
            $seguimiento_table = $this->gsatelite->get_tabla("sgt_seguimiento_cita",array("sgt_id_cim" => $cim_id));
            $seguimiento_id = array_column($seguimiento_table, "sgt_id");
            $cantidad = count($txtsgt_id);
            //print_r($seguimiento);die();
            for ($i=0; $i < $cantidad; $i++) {
                if (is_array($txtsgt_id) && count($txtsgt_id) > 0) {
                    if (!in_array($txtsgt_id[$i] , $seguimiento_id)) {
                        if ($foto_ruta[$i] != null or $foto_titulo[$i] != null) {
                            $extension = end(explode('.', $foto_ruta[$i]));
                            $carpeta_temporal_anx = $ruta = "public/temp/anexos_medicos/" . trim($foto_ruta[$i]);
                            $nombreArchivo = trim($foto_titulo[$i]) . "." . trim($extension);
                            $carpeta_destino_anx = "uploads/anexos_medicos/" . $nombreArchivo;
                        } else {
                            $nombreArchivo = null;
                        }
                        $seguimiento = array(
                            'sgt_id_cim' => $cim_id,
                            'sgt_id_usu' => $this->tank_auth->get_user_id(),
                            'sgt_fecha' => $fecha[$i],
                            'sgt_hora' => $hora[$i],
                            'sgt_comentario' => $comentario[$i],
                            'sgt_url_anexo' => $nombreArchivo,
                            'sgt_nombre_anexo' => ($foto_titulo[$i] != '')? $foto_titulo[$i] : null,
                            'sgt_estado' => 1,
                            'sgt_usu_creacion' => $this->tank_auth->get_user_id(),
                            'sgt_fecha_creacion' => date('Y-m-d H:i:s'),
                            'sgt_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sgt_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $sgt_id = $this->gsatelite->ingresar('sgt_seguimiento_cita', $seguimiento);
                        if ($sgt_id > 0) {
                            if (isset($carpeta_temporal_anx) && $carpeta_destino_anx) {
                                copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                unlink($carpeta_temporal_anx);
                            }
                            $contador++;
                        }
                    }
                }
            }
            foreach ($seguimiento_table as $key => $value) {
                if (!in_array($value['sgt_id'] , $txtsgt_id) ) {
                    $this->gsatelite->borrado_general('sgt_seguimiento_cita', array('sgt_id'=>$value['sgt_id']));
                    if ($value['sgt_url_anexo'] != null) {
                        unlink(FCPATH."uploads/anexos_medicos/".$value['sgt_url_anexo']);
                    }
                }
            }
            if ($confirmar_cita == '2' && $cim_ids > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Confirmar cita", 'texto_alerta' => "La cita a sido confirmada exitosamente");
                $this->session->set_flashdata($alerta);
            } elseif($confirmar_cita == '0' && $cim_ids > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cancelada cita", 'texto_alerta' => "La cita a sido Cancelada exitosamente");
                $this->session->set_flashdata($alerta);
            }
            echo json_encode(array('cim_id' => $cim_ids));
            die();

        }
        $cita_medica = $this->medico_model->informacion_cita(array('cim_id' => $cim_id));
        $data['cim_id'] = $cim_id;
        $data['cita_medica'] = $cita_medica;
        $data['seguimiento_cita'] = $this->gsatelite->get_tabla("sgt_seguimiento_cita",array("sgt_id_cim" => $cim_id));
        $tipo_consulta = $this->gsatelite->get_dropdown('tcm_tipo_consulta_medica', '{tcm_nombre}', '', '',$cita_medica[0]['cim_id_tcm'], '', 'tcm_id', true);
        $tipo_consulta = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $tipo_consulta);
        $data['tipo_consulta']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_consulta);
        $medico_dropdown = $this->gsatelite->get_dropdown('med_medico', '{med_nombre}', '', '',$cita_medica[0]['cim_id_med'], '', 'med_id', true);
        $medico_dropdown = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $medico_dropdown);
        $data['medico_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $medico_dropdown);
        $lugar_dropdown = $this->gsatelite->get_dropdown('luc_lugar_cita', '{luc_nombre}', '', '',$cita_medica[0]['cim_id_luc'], '', 'luc_id', true);
        $lugar_dropdown = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $lugar_dropdown);
        $data['lugar_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $lugar_dropdown);
        $data['calendario'] = $calendario;
        $data['titulo_personal'] = 'Confirmar cita';
        $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_procesos/confirmar_cita',$data);
    }

    /**
     * Descripción:
     * Busca paciente para la seleccion en ajax 
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-08-15
     * @param  Ninguno
     * @return modal
     */
    public function get_pacientes_like(){
        satelite_validar(true);
        $caracteristica = $this->input->post('categoria');
        $where["CONCAT_WS(' ',epp_numero_expediente, epp_nombre, epp_apellido, epp_apellido_casada) LIKE '%$caracteristica%'"] = null;
        $detalle_paciente = $this->gsatelite->get_tabla("epp_expediente_paciente",$where);
        echo json_encode($detalle_paciente);
    }

    public function get_clientes_like(){
        $cliente = $this->input->post('cliente');
        if ($cliente != null) {
            $where = array('cli_estado' => 1);
            $like = array("CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido)" => $cliente);
            $resultado = $this->medico_model->get_clientes($where, $like);
        }
        echo json_encode($resultado);
    }

    /**
     * Descripción:
     * verifica que las horas para dicha fecha esten disponibles
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-08-15
     * @param  fecha, hora_desde, hora_hasta
     * @return true
     */
    public function verificacion_horas($cita_act = 0){
        satelite_validar();
        $hora_desde = '';
        $fecha = formatear_fecha('Y-m-d', $this->input->post('fecha'));
        // $hora_hasta = $this->input->post('hora_hasta');
        $horaDesde = formatear_fecha('H:i:s', $this->input->post('hora_desde'));
        $hora_hasta = formatear_fecha('H:i:s', $this->input->post('hora_hasta'));
        if ($horaDesde) {
            $new_hora = date_create($horaDesde);
            date_add($new_hora, date_interval_create_from_date_string("+1 second"));
            $hora_desde = date_format($new_hora, 'H:i:s');
        }
        $medico = ($this->input->post('medico') > 0) ? $this->input->post('medico') : null;
        $lugar  = $this->input->post('lugar');
        $paciente = $this->input->post('paciente');
        $tipo_con = intval($this->input->post('tipo_consulta'));
        if($paciente != '' && $lugar != ''){
            $where = array(
                'cim_id != ' => $cita_act,
                'cim_id_epp' => $paciente,
                'cim_id_med' => $medico,
                'cim_fecha_cita' => $fecha,
                'cim_estado_cita > ' => 0,
                "(('$hora_desde' BETWEEN cim_hora_desde AND cim_hora_hasta) OR ('$hora_hasta' BETWEEN cim_hora_desde AND cim_hora_hasta))" => null,
                'cim_id_luc' => $lugar,
                'cim_id_tcm' => $tipo_con
            );
        }else{
            $where = array(
                'cim_id_med' => $medico,
                'cim_fecha_cita' => $fecha,
                'cim_estado_cita > ' => 0,
                'cim_id != ' => $cita_act,
                'cim_id_tcm' => $tipo_con,
                "(('$hora_desde' BETWEEN cim_hora_desde AND cim_hora_hasta) OR ('$hora_hasta' BETWEEN cim_hora_desde AND cim_hora_hasta))" => null
            ); 
        }
        $validar_cita = $this->gsatelite->get_tabla("cim_cita_medica", $where);
        // var_dump($this->db->last_query()); die();
        $cita['cim_id'] = count($validar_cita);
        echo json_encode($cita);
    }

    /**
     * Descripción:
     * opera con la funcion consulta_select 
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-08-15
     * @param  Ninguno
     * @return modal
     */
    public function consulta_select(){
        satelite_validar();
        $campo_id = $this->input->post('id');
        $nombre_poliza = $this->input->post('nombre');
        $html = '<option></option>';
        if ($nombre_poliza != '') {
            $detalle = $this->gsatelite->get_tabla("pol_poliza",array('pol_id_ase' => $campo_id, 'pol_nombre' => $nombre_poliza));
            foreach ($detalle as $key => $value) {
                $html .= '<option value="'.$value['pol_id'].'">'.$value['pol_numero'].'</option>';
            }
        } else {
            $this->db->group_by('pol_nombre');
            $detalle = $this->gsatelite->get_tabla("pol_poliza",array('pol_id_ase' => $campo_id));
            foreach ($detalle as $key => $value) {
                $html .= '<option value="'.$value['pol_id'].'">'.$value['pol_nombre'].'</option>';
            }
        }
        echo json_encode($html);
    }

    /**
     * Descripción: agrega nuevos numeros de poliza para una aseguradora
     * @since  2021-dic
     * @param  Ninguno
     */
    public function agregar_num_pol($aseg = 0, $name = 0){
        satelite_validar();
        if ($_POST) {
            $btn = $this->input->post('btnCrear');
            $id_poliza = $this->input->post('id_aseg');
            $ids_polizas = $this->input->post('id_polizas');
            $nombrepoliza = $this->input->post('txtnombrepoliza');
            $numeropoliza = $this->input->post('txtnumeropoliza');
            $descripcionpoliza = $this->input->post('txtdescripcionpoliza');
            $pol_existe = $this->gsatelite->get_tabla('pol_poliza', array('pol_id_ase' => $id_poliza));
            foreach ($pol_existe as $k => $val) {
                if (!(in_array($val['pol_id'], $ids_polizas))) {
                    $this->gsatelite->borrado_general('pol_poliza', array('pol_id_ase' => $id_poliza, "pol_id" => $val['pol_id']));
                }
            }
            for ($i = 0; $i < count($ids_polizas); $i++) { 
                $poliza = array(
                    'pol_id_ase' => $id_poliza,
                    'pol_numero' => $numeropoliza[$i],
                    'pol_nombre' => $nombrepoliza[$i],
                    'pol_descripcion' => $descripcionpoliza[$i],
                    'pol_estado' => 1,
                    'pol_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'pol_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                if ($ids_polizas[$i] > 0) {
                    $this->gsatelite->actualizar_array('pol_poliza', $poliza, array('pol_id' => $ids_polizas[$i]));
                } else {
                    $poliza['pol_fecha_creacion'] = date('Y-m-d H:i:s');
                    $poliza['pol_usu_creacion'] = $this->tank_auth->get_user_id();
                    $this->gsatelite->ingresar('pol_poliza', $poliza);
                }                
            }
            $this->session->set_flashdata('exito', 1);
            redirect('modulo_medico/med_procesos/agregar_num_pol/' . $id_poliza);
        } else {
            $aseguradora = $nom_poliza = "";
            if ($aseg > 0) {
                $aseguradora = $this->gsatelite->get_campo('ase_aseguradora', 'ase_nombre', array('ase_id' => $aseg));
            }
            if ($name > 0) {
                $nom_poliza = $this->gsatelite->get_campo('pol_poliza', 'pol_nombre', array('pol_id' => $name));
            }
            $data['ase_id'] = $aseg;
            $data['poliza'] = $this->medico_model->aseguradoraxpoliza(array('ase_id' => $aseg));
            $data['aseguradora'] = $aseguradora;
            $data['nombre_poliza'] = $nom_poliza;
            $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_mantenimientos/agregar_num_poliz_aseg',$data);
        }
    }

    /**
     * Descripción:
     * calendario de control de citas
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-08-15
     * @param  Ninguno
     * @return modal
     */
    function calendario_cita() {
        satelite_validar();
        $today = date('Y-m-d');
        $limit = date_create($today);
        date_add($limit, date_interval_create_from_date_string("-1 year"));
        $desde = date_format($limit, 'Y-m-d');

                       $this->db->group_by('cim_id');
        $cita_medica = $this->medico_model->informacion_cita(array("DATE(cim_fecha_cita) >= " => $desde));
        //se repasa la informacion para el ordenamiento de la informacion que se imprimira en el JS
        foreach ($cita_medica as $key => $value) {
            switch ($value['cim_estado_cita']) {
                case 0:
                    $color = '#E01010';
                break;
                case 1:
                    $color = '#FFA600';
                break;
                case 2:
                    if (trim($value['tcm_color_alerta']) != "") {
                        $color = trim($value['tcm_color_alerta']);
                    } else {
                        $color = '#206F0A';
                    }
                break;
                case 3:
                    $color = '#001FFF';
                break;
                
            }
            $informacion[$key] = array('title' => '"'.$value['nombre_paciente'].'"',
                                        'description' => '"<br>CITA: '.$value['cim_numero'].'"',
                                        'consulta' => '"'.'<b>Consulta: </b>'.$value['tcm_nombre'].'"',
                                        'medico' => '"'.'<b>Medico: </b>'.$value['med_nombre'].'"',
                                        'consultaen' => '"'.'<b>Consulta en: </b>'.$value['luc_nombre'].'"',
                                        'start' => '"'.formatear_fecha('Y-m-d', $value['cim_fecha_cita']).' '.$value['cim_hora_desde'].'"',
                                        'end' => '"'.formatear_fecha('Y-m-d', $value['cim_fecha_cita']).' '.$value['cim_hora_hasta'].'"',
                                        'color' => '"'.$color.'"',
                                        'allday' => 0,
                                        'url' => '"'.base_url("modulo_medico/med_procesos/confirmar_cita/".$value['cim_id']."/1").'"',
                                        'estado' => $value['cim_estado_cita']);
        }
        // var_dump($informacion);die();
        $data['informacion'] = $informacion;
        $data['titulo_personal'] = "Calendario de citas";
        //$data['permisos'] = $permisos;

        cargarvista($data);
    }

    /**
     * Descripción:
     * vista para la consulta
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-08-15
     * @param  none
     * @return informacion de la consulta
     */
    function consulta_medica(){
        satelite_validar();
        if ($_POST) {
            //print_r($_POST);die();
            $paciente = $this->input->post('slcpaciente');
            $fecha_desde = formatear_fecha('Y-m-d',$this->input->post('txtfdesde'));
            $fecha_hasta = formatear_fecha('Y-m-d',$this->input->post('txtfhasta'));
            $estado = $this->input->post('slcestado');
            if ($paciente != '') {
                $where['epp_id'] = $paciente;
            }
            if ($fecha_desde != '') {
                $where["DATE(cnm_fecha_registro) >= "] = $fecha_desde;
            }
            if ($fecha_hasta != '') {
                $where["DATE(cnm_fecha_registro) <= "] = $fecha_hasta;
            }
            if ($estado != '') {
                $where["cnm_estado"] = $estado;
            } else {
                $where["cnm_estado >= 0"] = null;
            }
            if (isset($where)) {
                $consultas = $this->medico_model->informacion_consulta($where);
            } else {
                $consultas = $this->medico_model->informacion_consulta();
            }
            // print_r($this->db->last_query());die();
            $data['consultas'] = $consultas;
            $data['empresa'] = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));
            $html = $this->load->view('modulo_medico/med_procesos/grid_consulta_medica',$data,true);
            if (!(count($consultas) > 0)) {
                $html = '<td colspan="6">No se encontraron registros</td>';
            }
            //print_r($html);die();
            echo json_encode($html);
            die();
        }
        $consulta_medica = array();// $this->medico_model->informacion_consulta();
        $data['consultas'] = $consulta_medica;
        //print_r($cita_medica);die();
        $data['html'] = $this->load->view('modulo_medico/med_procesos/grid_consulta_medica',$data,true);
        $pacienta_dropdown = $this->gsatelite->get_dropdown('epp_expediente_paciente', '{epp_nombre}', '', '','', '', 'epp_id', true);
        $pacienta_dropdown = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $pacienta_dropdown);
        $data['pacienta_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $pacienta_dropdown);
        $data['empresa'] = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));
        $data['titulo_personal'] = 'Consulta';
        cargarvista($data);
    }

    /**
     * Descripción:
     * Función para imprimir la receta
     * @author Elmer Hernandez
     * @since  2019-11-14
     */

    public function imprimir_receta($id_cnm = null, $precio = null){
        $cnm_id = ($id_cnm) ? $id_cnm : $this->input->post('id_cnm');
        if ($cnm_id != '') {
            $where["rct_estado"] = 1;
            $where["rct_id_cnm"] = $cnm_id;
            $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));
            if ($empresa != "") {
                $data['recetas'] = $this->medico_model->recetas_por_consulta($where);
                if ($precio) {
                    $html = $this->load->view('modulo_medico/med_procesos/detalle_impresion_receta_simgcoin', $data, true);
                } else {
                    $html = $this->load->view('modulo_medico/med_procesos/detalle_impresion_receta_simg', $data, true);
                }
                $this->pdf->AddPage('P', 'Letter', array('family' => "helvetica", 'style' => '', 'size' => 6), true);
                $this->pdf->writeHTML($html, true, false, false, false, '');
                $this->pdf->setPrintFooter(false);
                $this->pdf->boletaPDF('I');     
            } else {
                $prms = $this->gsatelite->get_tabla("prm_parametro_empresa", array("prm_codigo IN ('SYS_LOGOTIPO','SYS_HORARIO','SYS_DIRECCION','IMG_LOGO_DIMENSIONES_CALVO')"=>null));
                $data['parametros'] = array_column($prms, "prm_valor", "prm_codigo");
                $data['recetas'] = $this->medico_model->recetas_por_consulta2($where);
                $html = $this->load->view('modulo_medico/med_procesos/detalle_impresion_receta', $data, true);
                $GLOBALS['es_receta'] = 1;
                $this->pdf->SetFont("helvetica");
                $this->pdf->SetAutoPageBreak(true, 0);
                $this->pdf->SetMargins(0,5,3);
                $this->pdf->AddPage('P', 'Letter', array('family' => "helvetica", 'style' => '', 'size' => 6), true);
                $this->pdf->writeHTML($html, true, false, false, false, '');
                $this->pdf->setPrintFooter(true);
                $this->pdf->boletaPDF('I');          
            }
        }
    }

        /**
     * Descripción:
     * agregar consulta
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-08-15
     * @param  none
     * @return informacion de la consulta
     */
    /*function agregar_consulta($cim_id,$modal=NULL){
        satelite_validar();
        if ($_POST) {
            // var_dump($_POST);die();
            $peso =               ($this->input->post('txtpeso') != '')? $this->input->post('txtpeso')  : null;
            $numero_consulta =    ($this->input->post('correlativo') != '')? $this->input->post('correlativo') : null ;
            $respidracion =       ($this->input->post('txtrespiracion') != '')? $this->input->post('txtrespiracion') : null;
            $temperatura =        ($this->input->post('txttemperatura') != '')? $this->input->post('txttemperatura') : null ;
            $saturacion_oxi =     ($this->input->post('txtsatoxig') != '')? $this->input->post('txtsatoxig') : null;
            $preautorizacion =    ($this->input->post('txtpreautorizacion') != '')? $this->input->post('txtpreautorizacion') : null;
            $talla =              ($this->input->post('txttalla') != '')? $this->input->post('txttalla') : null;
            $sentido =            ($this->input->post('sentido') != '')? $this->input->post('sentido') : null;
            $tension_sistolica =  ($this->input->post('txttension_syst') != '') ? $this->input->post('txttension_syst') : "";
            $tension_diastolica = ($this->input->post('txttension_dias') != '') ? $this->input->post('txttension_dias') : "";
            $cintura =            ($this->input->post('txtcintura') != '')? $this->input->post('txtcintura') : null ;
            $frecuencia_car =     ($this->input->post('txtcardiaca') != '')? $this->input->post('txtcardiaca') : null;
            $impc =               ($this->input->post('txtimpc') != '')? $this->input->post('txtimpc') : null ;
            $historial =          ($this->input->post('txahistorial') != '')? $this->input->post('txahistorial') : null ;
            $diagnostico =        ($this->input->post('txadiagnostico') != '')? $this->input->post('txadiagnostico') : null ;
            $plan =               ($this->input->post('txaplan') != null)? $this->input->post('txaplan') : null ;         
            $nombre_constancia =  (trim($this->input->post('txtNombreConstancia')) != '')? $this->input->post('txtNombreConstancia') : null ;
            $fecha_constancia =   (trim($this->input->post('txtFechaConstancia')) != '')? formatear_fecha("Y-m-d", $this->input->post('txtFechaConstancia')) : null ;
            $detalle_constancia = (trim($this->input->post('txtConstancia')) != '')? $this->input->post('txtConstancia') : null ;
            $tension =            ($tension_sistolica != "" && $tension_diastolica != "") ? $tension_sistolica . "/" . $tension_diastolica : null;
            $consulta = array(
                'cnm_id_cim' => ($cim_id > 0) ? $cim_id : null,
                'cnm_id_cdm' => $sentido,
                'cnm_numero' => $numero_consulta,
                'cnm_id_usu' => $this->tank_auth->get_user_id(),
                'cnm_fecha_consulta' => date('Y-m-d H:i:s'),
                'cnm_fecha_registro' => date('Y-m-d H:i:s'),
                'cnm_peso' => $peso,
                'cnm_temperatura' => $temperatura,
                'cnm_talla' => $talla,
                'cnm_cintura_abdominal' => $cintura,
                'cnm_imc' => $impc,
                'cnm_pre_autorizacion_examen' => $preautorizacion,
                'cnm_respiracion' => $respidracion,
                'cnm_saturacion_oxigeno' => $saturacion_oxi,
                'cnm_tension_arterial' => $tension,
                'cnm_historial_clinico' => $historial,
                'cnm_frecuencia_cardiaca' => $frecuencia_car,
                'cnm_diagnostico' => $diagnostico,
                'cnm_plan_seguir' => $plan,
                'cnm_nombre_constancia' => $nombre_constancia,
                'cnm_fecha_constancia' => $fecha_constancia,
                'cnm_detalle_constancia' => $detalle_constancia,
                'cnm_estado' => 1,
                'cnm_usu_creacion' => $this->tank_auth->get_user_id(),
                'cnm_fecha_creacion' => date('Y-m-d H:i:s'),
                'cnm_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cnm_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $cnm_id = $this->gsatelite->ingresar('cnm_consulta_medica', $consulta);
            if ($cnm_id > 0) {

                if ($cim_id > 0) {
                    $cim_id = $this->gsatelite->actualizar_array('cim_cita_medica',array('cim_estado_cita' => 3), array('cim_id' => $cim_id));//actualizamos estado de la cita como realizada
                }
                
                $medicamento = $this->input->post('txtmedicamento');
                $presentacion = $this->input->post('txtpresentacion');
                $cantidad = $this->input->post('txtcantidad');
                $dosis = $this->input->post('txtdosis');
                $comentario = $this->input->post('txtcomentariomed');
                if (is_array($medicamento) && count($medicamento) > 0) {
                    for ($i=0; $i < count($medicamento); $i++) { 
                        $receta = array(
                            'rct_id_cnm' => $cnm_id,
                            'rct_id_art' => $medicamento[$i],
                            'rct_cantidad' => ($cantidad[$i] > 0) ? $cantidad[$i] : 1,
                            'rct_dosis' => $dosis[$i],
                            'rct_comentario' => $comentario[$i],
                            'rct_estado' => 1,
                            'rct_usu_creacion' => $this->tank_auth->get_user_id(),
                            'rct_fecha_creacion' => date('Y-m-d H:i:s'),
                            'rct_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rct_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $rct_id = $this->gsatelite->ingresar('rct_receta', $receta);
                    }
                }
            }
            $ruta_anexos = $this->input->post('txtruta');
            $titulo_anexo = $this->input->post('txtnombreanex');
            $fecha_anex = $this->input->post('txtfecha');
            $comentario = $this->input->post('txtcomentarioanex');
            //Si vienen anexos
            if (is_array($ruta_anexos) && count($ruta_anexos) > 0) {
                for ($i = 0; $i < count($ruta_anexos); $i++) {
                    $extension = end(explode('.', $ruta_anexos[$i]));
                    $carpeta_temporal_anx = $ruta = "public/temp/anexos_medicos/" . trim($ruta_anexos[$i]);
                    $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                    $carpeta_destino_anx = "uploads/anexos_medicos/" . $nombreArchivo;
                    $documentos_array = array(
                        'aci_id_cnm'             => $cnm_id,
                        'aci_url'                => $carpeta_destino_anx,
                        'aci_nombre'             => $nombreArchivo,
                        'aci_fecha_registro'     => $fecha_anex[$i],
                        'aci_estado'             => 1,
                        'aci_usu_creacion'       => $this->tank_auth->get_user_id(),
                        'aci_fecha_creacion'     => date('Y-m-d H:i:s'),
                        'aci_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'aci_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'aci_comentario'         => $comentario[$i]
                    );
                    $aci_id = $this->gsatelite->ingresar('aci_anexo_consulta_medica', $documentos_array);
                    if ($aci_id > 0) {
                        copy($carpeta_temporal_anx, $carpeta_destino_anx);
                        unlink($carpeta_temporal_anx);
                    }
                }
            }
            if ($cnm_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Consulta", 'texto_alerta' => "La consulta se almacenado correctamente");
                $this->session->set_flashdata($alerta);
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Consulta", 'texto_alerta' => "Se produjo un error a la hora de guardar la consulta");
                $this->session->set_flashdata($alerta);
            }
            if ($modal > 0) {
                echo $cnm_id;
                die();
            } else {
                redirect("modulo_medico/med_procesos/consulta_medica");
            }
        }
        $cita_medica = $this->medico_model->informacion_cita(array("cim_id" => $cim_id));
        // var_dump($cita_medica);die();
        $data['cita_medica'] = $cita_medica;
        $correlativo = ($this->gsatelite->get_max('cnm_consulta_medica','cnm_id') != null)? $this->gsatelite->get_max('cnm_consulta_medica','cnm_id') + 1 : 1;
        $correlativo = str_pad($correlativo, 4, "0", STR_PAD_LEFT);
        $data['correlativo'] = 'CO-'.$correlativo;
        $condicion_medida = $this->gsatelite->get_dropdown('cdm_condicion_medida', '{cdm_nombre}', '', '','', '', 'cdm_id', true);
        $condicion_medida = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $condicion_medida);
        $data['condicion_medida']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $condicion_medida);
        $data['titulo_personal'] = 'Agregar consulta';
        $data['modulo'] = $modal;
        if ($modal > 0) {
            $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_procesos/agregar_consulta',$data);
        } else {
            cargarvista($data);
        }
    }*/
    
    function ping_backend() {
        satelite_validar();
    
        $response = [
            'status' => 'success',
            'message' => 'Ping exitoso'
        ];
        
        header('Content-Type: application/json');
        echo json_encode($response);
    }

    function consulta_emergencia($clp_id, $cim_id, $es_chequeo = NULL){
        return $this->agregar_consulta($cim_id, null, $clp_id, $es_chequeo);
    }

    function agregar_consulta($cim_id, $modal = NULL, $clp_id = NULL, $es_chequeo = NULL) {
        satelite_validar();

        if ($clp_id) {
                        $this->db->join('cxc_consultaxclasificacion_paciente', 'cxc_id_cnm = cnm_id');
            $draft = $this->gsatelite->get_registro('cnm_consulta_medica', array('cxc_id_clp' => $clp_id, 'cnm_estado' => -1));
        } else {
            $draft = $this->gsatelite->get_registro('cnm_consulta_medica', array('cnm_id_cim' => $cim_id, 'cnm_estado' => -1));
        }
        //$cnm_id = is_object($draft) ? $draft->cnm_id : null;
        
        // Manejo de guardado periódico vía AJAX
        if ($this->input->is_ajax_request() && $this->input->post('action') == 'save_draft') {
            $cnm_id = $this->input->post('cnm_id');

            // Si ya tiene estado 1 no realizar guardado automatico
            $consulta = $this->gsatelite->get_registro('cnm_consulta_medica', array('cnm_id' => $cnm_id));
            if ($consulta && $consulta->cnm_estado == 1) {
                echo json_encode(['status' => 'success', 'cnm_id' => $cnm_id, 'message' => 'La consulta ha sido guardada correctamente. No es necesario realizar un guardado automático.']);
                exit;                
            } 
                        
            $data = $this->_prepare_consulta_data($cim_id); // Función auxiliar para preparar datos
            $data['cnm_estado'] = -1; // Estado borrador
            $data['cnm_usu_modificacion'] = $this->tank_auth->get_user_id();
            $data['cnm_fecha_modificacion'] = date('Y-m-d H:i:s');

            // Actualizar registro existente
            $this->gsatelite->actualizar_array('cnm_consulta_medica', $data, array('cnm_id' => $cnm_id));

            // Guardar recetas y anexos si existen
            $this->_save_recetas($cnm_id);
            $this->_save_anexos($cnm_id, 'borrador');
            
            echo json_encode(['status' => 'success', 'cnm_id' => $cnm_id]);
            exit;
        }

        // Guardado final
        if ($_POST && $this->input->post('action') != 'save_draft') {
            $cnm_id = $this->input->post('cnm_id') ?: $this->_create_draft_consulta($cim_id); // Usar cnm_id existente o crear nuevo
            $data = $this->_prepare_consulta_data($cim_id);
            $data['cnm_estado'] = 1; // Estado finalizado
            $data['cnm_usu_modificacion'] = $this->tank_auth->get_user_id();
            $data['cnm_fecha_modificacion'] = date('Y-m-d H:i:s');

            // Actualizar consulta
            $this->gsatelite->actualizar_array('cnm_consulta_medica', $data, array('cnm_id' => $cnm_id));

            // Guardar recetas y anexos
            $this->_save_recetas($cnm_id);
            $this->_save_anexos($cnm_id, 'guardado_final');

            // Actualizar clp si en dado caso exista 
            $clp_id = $this->input->post('clp_id') ?: null;            
            $this->actualizar_clasificacion_paciente($clp_id, $cnm_id);

            // Actualizar estado de la cita
            $this->gsatelite->actualizar_array('cim_cita_medica', ['cim_estado_cita' => 3], ['cim_id' => $cim_id]);

            // Crear requisicion de la receta
            $this->agregarRequisicionReceta();            

            $alerta = [
                'tipo_alerta' => 'success',
                'titulo_alerta' => 'Consulta',
                'texto_alerta' => 'La consulta se almacenó correctamente'
            ];
            $this->session->set_flashdata($alerta);

            /*if ($modal > 0) {
                echo $cnm_id;
                exit;
            } else {
                redirect('modulo_medico/med_procesos/consulta_medica');
            }*/

            //corrigiendo problema de redirect encontrado
            if ($this->input->is_ajax_request()) { 
                header('Content-Type: application/json');
                echo json_encode([
                    'status' => 'success',
                    'cnm_id' => $cnm_id,
                    'modal' => $modal,
                    'redirect' => ($modal > 0) ? null : base_url('modulo_medico/med_procesos/consulta_medica')
                ]);
                exit;
            } else {
                redirect('modulo_medico/med_procesos/consulta_medica');
            }
        }

        $id_cdm = null;

        // Crear registro preliminar al cargar la vista
        if(!is_object($draft)){
            $cnm_id = $this->_create_draft_consulta($cim_id, $clp_id);

            $data['draft_data'] = $this->gsatelite->get_registro('cnm_consulta_medica', ['cnm_id' => $cnm_id]);
            $data['draft_recetas'] = [];
            $data['draft_anexos'] = [];
            $data['existe_borrador'] = false;
        } else {
            $cnm_id = $draft->cnm_id;
            $data['draft_data'] = $draft;
            $data['draft_recetas'] = $this->medico_model->informacion_receta(array("rct_id_cnm" => $cnm_id));
            $data['draft_anexos'] = $this->gsatelite->get_tabla('aci_anexo_consulta_medica', ['aci_id_cnm' => $cnm_id]);
            $data['existe_borrador'] = true;
            $id_cdm = $draft->cnm_id_cdm;
        }

        // Cargar datos de la cita
        $cita_medica = $this->medico_model->informacion_cita(['cim_id' => $cim_id]);
        $data['cita_medica'] = $cita_medica;
        $data['cnm_id'] = $cnm_id; // Pasar cnm_id a la vista
        $correlativo = str_pad($cnm_id, 4, '0', STR_PAD_LEFT);
        $data['correlativo'] = 'CO-' . $correlativo;
        $condicion_medida = $this->gsatelite->get_dropdown('cdm_condicion_medida', '{cdm_nombre}', '', '', $id_cdm, '', 'cdm_id', true);
        $condicion_medida = str_replace(['<option value="0">Sin Registros</option>', '<option value="0">Seleccione</option>'], '<option value=""></option>', $condicion_medida);
        $data['condicion_medida'] = $condicion_medida;
        $data['titulo_personal'] = 'Agregar consulta';
        $data['modulo'] = $modal;
        $data['clp_id'] = $clp_id;
        $data['es_chequeo'] = $es_chequeo;

        //bodega - consultorio
                              $this->db->join('med_medico', 'med_id = con_id_med');
        $bodega_consultorio = $this->gsatelite->get_tabla('con_consultorio', array('con_estado_disponible' => 1, 'con_estado' => 1, 'med_id_usu' => $this->tank_auth->get_user_id()));
        $data['bodega_consultorio'] = (count($bodega_consultorio) > 0) ? $bodega_consultorio[0]['con_id_bod'] : 0;     

        if ($modal > 0) {
            $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_procesos/agregar_consulta', $data);
        } else {
            cargarvista($data, null, 'modulo_medico/med_procesos/agregar_consulta');
        }
    }

    // Función auxiliar para crear el borrador
    private function _create_draft_consulta($cim_id, $clp_id = null) {
        $consulta = [
            'cnm_id_cim' => $cim_id,
            'cnm_id_usu' => $this->tank_auth->get_user_id(),
            'cnm_fecha_consulta' => date('Y-m-d H:i:s'),
            'cnm_fecha_registro' => date('Y-m-d H:i:s'),
            'cnm_estado' => -1, // Borrador
            'cnm_usu_creacion' => $this->tank_auth->get_user_id(),
            'cnm_fecha_creacion' => date('Y-m-d H:i:s'),
            'cnm_usu_modificacion' => $this->tank_auth->get_user_id(),
            'cnm_fecha_modificacion' => date('Y-m-d H:i:s')
        ];

        $cnm_id =  $this->gsatelite->ingresar('cnm_consulta_medica', $consulta);

        // Si existe clp se asocia con la consulta
        if ($clp_id) {
            $cxc_consultaxclasificacion_paciente = [
                'cxc_id_clp' => $clp_id,
                'cxc_id_cnm' => $cnm_id,
                'cxc_estado' => 1,
                'cxc_usu_creacion' => $this->tank_auth->get_user_id(),
                'cxc_fecha_creacion' => date('Y-m-d H:i:s'),
                'cxc_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cxc_fecha_modificacion' => date('Y-m-d H:i:s')

            ]; 
            $this->gsatelite->ingresar('cxc_consultaxclasificacion_paciente', $cxc_consultaxclasificacion_paciente);
        }

        return $cnm_id;
    }

    // Función auxiliar para preparar datos de consulta
    private function _prepare_consulta_data($cim_id) {
        $peso = $this->input->post('txtpeso') ?: null;
        $numero_consulta = $this->input->post('correlativo') ?: null;
        $respiracion = $this->input->post('txtrespiracion') ?: null;
        $temperatura = $this->input->post('txttemperatura') ?: null;
        $saturacion_oxi = $this->input->post('txtsatoxig') ?: null;
        $preautorizacion = $this->input->post('txtpreautorizacion') ?: null;
        $talla = $this->input->post('txttalla') ?: null;
        $sentido = $this->input->post('sentido') ?: null;
        $tension_sistolica = $this->input->post('txttension_syst') ?: '';
        $tension_diastolica = $this->input->post('txttension_dias') ?: '';
        $cintura = $this->input->post('txtcintura') ?: null;
        $frecuencia_car = $this->input->post('txtcardiaca') ?: null;
        $imc = $this->input->post('txtimpc') ?: null;
        $historial = $this->input->post('txahistorial') ?: null;
        $diagnostico = $this->input->post('txadiagnostico') ?: null;
        $plan = $this->input->post('txaplan') ?: null;
        $nombre_constancia = trim($this->input->post('txtNombreConstancia')) ?: null;
        $fecha_constancia = trim($this->input->post('txtFechaConstancia')) ? formatear_fecha('Y-m-d', $this->input->post('txtFechaConstancia')) : null;
        $detalle_constancia = trim($this->input->post('txtConstancia')) ?: null;
        $tension = ($tension_sistolica && $tension_diastolica) ? $tension_sistolica . '/' . $tension_diastolica : null;

        return [
            'cnm_id_cim' => $cim_id,
            'cnm_id_cdm' => $sentido,
            'cnm_numero' => $numero_consulta,
            'cnm_peso' => $peso,
            'cnm_temperatura' => $temperatura,
            'cnm_talla' => $talla,
            'cnm_cintura_abdominal' => $cintura,
            'cnm_imc' => $imc,
            'cnm_pre_autorizacion_examen' => $preautorizacion,
            'cnm_respiracion' => $respiracion,
            'cnm_saturacion_oxigeno' => $saturacion_oxi,
            'cnm_tension_arterial' => $tension,
            'cnm_historial_clinico' => $historial,
            'cnm_frecuencia_cardiaca' => $frecuencia_car,
            'cnm_diagnostico' => $diagnostico,
            'cnm_plan_seguir' => $plan,
            'cnm_nombre_constancia' => $nombre_constancia,
            'cnm_fecha_constancia' => $fecha_constancia,
            'cnm_detalle_constancia' => $detalle_constancia
        ];
    }

    // Función para guardar recetas
    private function _save_recetas($cnm_id) {
        $medicamento = $this->input->post('txtmedicamento');
        $presentacion = $this->input->post('txtpresentacion');
        $cantidad = $this->input->post('txtcantidad');
        $dosis = $this->input->post('txtdosis');
        $comentario = $this->input->post('txtcomentariomed');

        if (is_array($medicamento) && count($medicamento) > 0) {
            // Eliminar recetas anteriores para evitar duplicados
            $this->gsatelite->borrado_general('rct_receta', array('rct_id_cnm'=>$cnm_id));
            foreach ($medicamento as $i => $med) {
                $receta = [
                    'rct_id_cnm' => $cnm_id,
                    'rct_id_art' => $med,
                    'rct_cantidad' => ($cantidad[$i] > 0) ? $cantidad[$i] : 1,
                    'rct_dosis' => $dosis[$i],
                    'rct_comentario' => $comentario[$i],
                    'rct_estado' => 1,
                    'rct_usu_creacion' => $this->tank_auth->get_user_id(),
                    'rct_fecha_creacion' => date('Y-m-d H:i:s'),
                    'rct_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'rct_fecha_modificacion' => date('Y-m-d H:i:s')
                ];
                $this->gsatelite->ingresar('rct_receta', $receta);
            }
        }
    }

    // Función para guardar anexos
    private function _save_anexos($cnm_id, $flag_estado_cnm) {
        $ruta_anexos = $this->input->post('txtruta');
        $titulo_anexo = $this->input->post('txtnombreanex');
        $fecha_anex = $this->input->post('txtfecha');
        $comentario = $this->input->post('txtcomentarioanex');

        $anexos_existentes = $this->gsatelite->get_tabla('aci_anexo_consulta_medica', array('aci_id_cnm' => $cnm_id));
        $anexos_existentes_map = array();
        foreach ($anexos_existentes as $anexo) {
            $anexos_existentes_map[$anexo["aci_url"]] = $anexo;
        }

        $anexos_nuevos = array();
        if (is_array($ruta_anexos) && count($ruta_anexos) > 0) {
            foreach ($ruta_anexos as $i => $ruta) {
                if (empty($ruta)) {
                    continue; // Saltar si la ruta está vacía
                }

                $extension = pathinfo($ruta, PATHINFO_EXTENSION);
                $carpeta_temporal_anx = "public/temp/anexos_medicos/" . trim($ruta);

                //Para evitar el caso en que la extension se ponga 'n' veces
                $nombreArchivo_base = pathinfo(trim($titulo_anexo[$i]), PATHINFO_FILENAME);

                $nombreArchivo = $nombreArchivo_base . "." . $extension;
                $carpeta_destino_anx = "Uploads/anexos_medicos/" . $nombreArchivo;

                // Verificar si el anexo ya existe (comparar por URL)
                if (array_key_exists($carpeta_destino_anx, $anexos_existentes_map)) {
                    // El anexo ya existe, no se actualiza, solo se marca como procesado
                    unset($anexos_existentes_map[$carpeta_destino_anx]);
                    continue;
                }

                $anexo_data = array(
                    'aci_id_cnm' => $cnm_id,
                    'aci_url' => $carpeta_destino_anx,
                    'aci_nombre' => $nombreArchivo,
                    'aci_fecha_registro' => $fecha_anex[$i],
                    'aci_estado' => 1,
                    'aci_usu_creacion' => $this->tank_auth->get_user_id(),
                    'aci_fecha_creacion' => date('Y-m-d H:i:s'),
                    'aci_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'aci_fecha_modificacion' => date('Y-m-d H:i:s'),
                    'aci_comentario' => !empty($comentario[$i]) ? $comentario[$i] : null
                );
                
                $aci_id = $this->gsatelite->ingresar('aci_anexo_consulta_medica', $anexo_data);
                if ($aci_id > 0) {
                    //Con esto se evita la excepcion cuando se re abre una consulta cuando ya haya pasado n autoguardados
                    //Para ocasiones futuras siempre utilizar un file_exists si se utilizan los copy y unlink para evitar excepciones fatales
                    if(file_exists($carpeta_temporal_anx)) {
                        copy($carpeta_temporal_anx, $carpeta_destino_anx);
                        if($flag_estado_cnm == "guardado_final"){
                            unlink($carpeta_temporal_anx);
                        }
                    } else {
                        log_message("info", "No se encontro la carpeta temporal ".$carpeta_temporal_anx);
                    }
                }
                $anexos_nuevos[$carpeta_destino_anx] = true;
            }
        }

        // Eliminar anexos que ya no están en el POST
        foreach ($anexos_existentes_map as $anexo_existente) {
            $this->gsatelite->borrado_general('aci_anexo_consulta_medica', array('aci_id' => $anexo_existente["aci_id"]));
            // Opcional: Eliminar archivo físico si es necesario
            if (file_exists($anexo_existente["aci_url"])) {
                unlink($anexo_existente["aci_url"]);
            }
        }

        /*if (is_array($ruta_anexos) && count($ruta_anexos) > 0) {
            // Eliminar anexos anteriores para evitar duplicados
            $this->gsatelite->borrado_general('aci_anexo_consulta_medica', array('aci_id_cnm'=>$cnm_id));
            foreach ($ruta_anexos as $i => $ruta) {
                $extension = pathinfo($ruta, PATHINFO_EXTENSION);
                $carpeta_temporal_anx = "public/temp/anexos_medicos/" . trim($ruta);
                $nombreArchivo = trim($titulo_anexo[$i]) . "." . $extension;
                $carpeta_destino_anx = "Uploads/anexos_medicos/" . $nombreArchivo;

                $documentos_array = [
                    'aci_id_cnm' => $cnm_id,
                    'aci_url' => $carpeta_destino_anx,
                    'aci_nombre' => $nombreArchivo,
                    'aci_fecha_registro' => $fecha_anex[$i],
                    'aci_estado' => 1,
                    'aci_usu_creacion' => $this->tank_auth->get_user_id(),
                    'aci_fecha_creacion' => date('Y-m-d H:i:s'),
                    'aci_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'aci_fecha_modificacion' => date('Y-m-d H:i:s'),
                    'aci_comentario' => $comentario[$i]
                ];
                $aci_id = $this->gsatelite->ingresar('aci_anexo_consulta_medica', $documentos_array);
                if ($aci_id > 0) {
                    copy($carpeta_temporal_anx, $carpeta_destino_anx);
                    unlink($carpeta_temporal_anx);
                }
            }
        }*/
    }


     /**
     * Descripción:
     * editar consulta
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-08-15
     * @param  none
     * @return informacion de la consulta
     */
    function editar_consulta($cnm_id=NULL ,$cim_id=NULL,$onlyReceta=0){
        satelite_validar();
        $cim_id = ($cim_id=='00') ? null : $cim_id;
        if ($_POST) {
            // var_dump($_POST);die();
            $peso =                 ($this->input->post('txtpeso') != '')? $this->input->post('txtpeso')  : null;
            $numero_consulta =      ($this->input->post('correlativo') != '')? $this->input->post('correlativo') : null ;
            $respidracion =         ($this->input->post('txtrespiracion') != '')? $this->input->post('txtrespiracion') : null;
            $temperatura =          ($this->input->post('txttemperatura') != '')? $this->input->post('txttemperatura') : null ;
            $saturacion_oxi =       ($this->input->post('txtsatoxig') != '')? $this->input->post('txtsatoxig') : null;
            $preautorizacion =      ($this->input->post('txtpreautorizacion') != '')? $this->input->post('txtpreautorizacion') : null;
            $talla =                ($this->input->post('txttalla') != '')? $this->input->post('txttalla') : null;
            $sentido =              ($this->input->post('sentido') != '')? $this->input->post('sentido') : null;
            $tension_sistolica =    ($this->input->post('txttension_syst') != '') ? $this->input->post('txttension_syst') : "";
            $tension_diastolica =   ($this->input->post('txttension_dias') != '') ? $this->input->post('txttension_dias') : "";
            $tension =              ($tension_sistolica != "" && $tension_diastolica != "") ? $tension_sistolica . "/" . $tension_diastolica : null;
            $cintura =              ($this->input->post('txtcintura') != '')? $this->input->post('txtcintura') : null ;
            $frecuencia_car =       ($this->input->post('txtcardiaca') != '')? $this->input->post('txtcardiaca') : null;
            $impc =                 ($this->input->post('txtimpc') != '')? $this->input->post('txtimpc') : null ;
            $historial =            ($this->input->post('txahistorial') != '')? $this->input->post('txahistorial') : null ;
            $diagnostico =          ($this->input->post('txadiagnostico') != '')? $this->input->post('txadiagnostico') : null ;
            $plan =                 ($this->input->post('txaplan') != null)? $this->input->post('txaplan') : null ;
            $AnexoCot =             $this->input->post('AnexoCot');
            $nombre_constancia =    (trim($this->input->post('txtNombreConstancia')) != '')? $this->input->post('txtNombreConstancia') : null ;
            $fecha_constancia =     (trim($this->input->post('txtFechaConstancia')) != '')? formatear_fecha("Y-m-d", $this->input->post('txtFechaConstancia')) : null ;
            $detalle_constancia =   (trim($this->input->post('txtConstancia')) != '')? $this->input->post('txtConstancia') : null ;

            $consulta = array(
                'cnm_id_cim' => $cim_id,
                'cnm_id_cdm' => $sentido,
                'cnm_id_usu' => $this->tank_auth->get_user_id(),
                'cnm_fecha_consulta' => date('Y-m-d H:i:s'),
                'cnm_peso' => $peso,
                'cnm_temperatura' => $temperatura,
                'cnm_talla' => $talla,
                'cnm_cintura_abdominal' => $cintura,
                'cnm_imc' => $impc,
                'cnm_pre_autorizacion_examen' => $preautorizacion,
                'cnm_respiracion' => $respidracion,
                'cnm_saturacion_oxigeno' => $saturacion_oxi,
                'cnm_tension_arterial' => $tension,
                'cnm_historial_clinico' => $historial,
                'cnm_frecuencia_cardiaca' => $frecuencia_car,
                'cnm_diagnostico' => $diagnostico,
                'cnm_plan_seguir' => $plan,
                'cnm_nombre_constancia' => $nombre_constancia,
                'cnm_fecha_constancia' => $fecha_constancia,
                'cnm_detalle_constancia' => $detalle_constancia,
                'cnm_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cnm_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('cnm_consulta_medica',$consulta, array('cnm_id' => $cnm_id));
            if ($cnm_id > 0) {
                $recetadas = $this->input->post('id_rct');
                $medicamento = $this->input->post('txtmedicamento');
                $presentacion = $this->input->post('txtpresentacion');
                $cantidad = $this->input->post('txtcantidad');
                $dosis = $this->input->post('txtdosis');
                $comentario = $this->input->post('txtcomentariomed');
                $delete_rct = array_column($this->gsatelite->get_tabla('rct_receta', array('rct_id_cnm'=>$cnm_id)), "rct_id");
                // inactivar las que se quitaron
                if (count($delete_rct) > 0) {
                    foreach ($delete_rct as $kb => $vd) {
                        if (!(in_array($vd, $recetadas))) {
                            $receta = array(
                                'rct_estado' => 0,
                                'rct_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'rct_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->actualizar_array('rct_receta', $receta, array('rct_id' => $vd));
                        }
                    }
                }
                if (is_array($recetadas) && count($recetadas) > 0) {
                    foreach ($recetadas as $i => $vrct) {
                        $receta = array(
                            'rct_id_cnm' => $cnm_id,
                            'rct_id_art' => $medicamento[$i],
                            'rct_cantidad' => ($cantidad[$i] > 0) ? $cantidad[$i] : 1,
                            'rct_dosis' => $dosis[$i],
                            'rct_comentario' => $comentario[$i],
                            'rct_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rct_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        if ($vrct > 0) {
                            $this->gsatelite->actualizar_array('rct_receta',$receta, array('rct_id' => $vrct));
                        } else {
                            $receta['rct_estado'] = 1;
                            $receta['rct_fecha_creacion'] = date('Y-m-d H:i:s');
                            $receta['rct_usu_creacion'] = $this->tank_auth->get_user_id();
                            $this->gsatelite->ingresar('rct_receta', $receta);
                        }
                    }
                }
            }
            $dataAnexos = $this->gsatelite->get_tabla('aci_anexo_consulta_medica', array('aci_id_cnm' => $cnm_id));
            if (!is_array($AnexoCot)) {
                $AnexoCot = array();
            }
            /* BORRAR ANEXOS QUE NO VENGAN*/
            foreach ($dataAnexos as $data) {
                if (!in_array($data['aci_id'], $AnexoCot)) {
                    $this->gsatelite->borrado_general('aci_anexo_consulta_medica', array('aci_id' => $data['aci_id']));
                    $ruta_nxp = $data['aci_url'];
                    unlink($ruta_nxp);
                }
            }
            //Si vienen anexos
            $ruta_anexos = $this->input->post('txtruta');
            $titulo_anexo = $this->input->post('txtnombreanex');
            $fecha_anex = $this->input->post('txtfecha');
            $comentario = $this->input->post('txtcomentarioamex');
            if (!empty($ruta_anexos)) {
                for ($i = 0; $i < count($AnexoCot); $i++) {
                    if (!($AnexoCot[$i] > 0)) {
                        $extension = end(explode('.', $ruta_anexos[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anexos_medicos/" . trim($ruta_anexos[$i]);
                        $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                        $carpeta_destino_anx = "uploads/anexos_medicos/" . $nombreArchivo;
                        $documentos_array = array(
                            'aci_id_cnm'             => $cnm_id,
                            'aci_url'                => $carpeta_destino_anx,
                            'aci_nombre'             => $nombreArchivo,                        
                            'aci_fecha_registro'      => $fecha_anex[$i],
                            'aci_estado'             => 1,
                            'aci_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'aci_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'aci_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'aci_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'aci_comentario'         => $comentario[$i]
                        );
                    }
                    $aci_id = $this->gsatelite->ingresar('aci_anexo_consulta_medica', $documentos_array);
                    if ($aci_id > 0) {
                        copy($carpeta_temporal_anx, $carpeta_destino_anx);
                        unlink($carpeta_temporal_anx);
                    }
                }
            }
            if ($cnm_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Consulta", 'texto_alerta' => "La consulta se almacenado correctamente");
                $this->session->set_flashdata($alerta);
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Consulta", 'texto_alerta' => "Se produjo un error a la hora de guardar la consulta");
                $this->session->set_flashdata($alerta);
            }
            redirect("modulo_medico/med_procesos/consulta_medica");
        }
        $consulta = $this->medico_model->informacion_consulta(array("cnm_id" => $cnm_id));
        $data['consulta'] = $consulta;
        // print_r($this->db->last_query());die();
        $data['receta'] = $this->gsatelite->medico_model->informacion_receta(array("rct_id_cnm" => $cnm_id, 'rct_estado > ' => 0));
        //print_r($this->db->last_query());die();
        $data['anexos'] = $this->gsatelite->get_tabla("aci_anexo_consulta_medica",array("aci_id_cnm" => $cnm_id));
        $condicion_medida = $this->gsatelite->get_dropdown('cdm_condicion_medida', '{cdm_nombre}', '', '',$consulta[0]['cnm_id_cdm'], '', 'cdm_id', true);
        $condicion_medida = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $condicion_medida);
        $data['condicion_medida']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $condicion_medida);
        $data['titulo_personal'] = 'Editar consulta';
        cargarvista($data);
    }

    /**
     * Descripción:
     * editar consulta
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-08-15
     * @param  none
     * @return informacion de la consulta
     */
    function ver_consulta($cnm_id=NULL ,$modal=NULL){
        satelite_validar();
        
        $consulta = $this->medico_model->informacion_consulta(array("cnm_id" => $cnm_id));
        $data['consulta'] = $consulta;
        //print_r($consulta);die();
        $data['receta'] = $this->gsatelite->medico_model->informacion_receta(array("rct_id_cnm" => $cnm_id));
        //print_r($this->db->last_query());die();
        $data['anexos'] = $this->gsatelite->get_tabla("aci_anexo_consulta_medica",array("aci_id_cnm" => $cnm_id));

        $condicion_medida = $this->gsatelite->get_dropdown('cdm_condicion_medida', '{cdm_nombre}', '', '',$consulta[0]['cnm_id_cdm'], '', 'cdm_id', true);
        $condicion_medida = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $condicion_medida);
        $data['condicion_medida']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $condicion_medida);

        $data['titulo_personal'] = 'Editar consulta';

        if ($modal > 0) {
          $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_procesos/ver_consulta',$data);
          //die();
        } else {
          cargarvista($data);
        }
        
    }

       /**
     * Descripción:
     * Finalizar consulta
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-08-15
     * @param  none
     * @return informacion de la consulta
     */
    function finalizar_consulta($cnm_id){
        satelite_validar();
        
        $cnm_afectados = $this->gsatelite->actualizar_array('cnm_consulta_medica',array("cnm_estado" => 0), array('cnm_id' => $cnm_id));

        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Consulta", 'texto_alerta' => "La consulta fue finalizada exitosamente");
                  $this->session->set_flashdata($alerta);

        echo $cnm_afectados;
        
    }

    /**
     * Descripción:
     * consultas anteriores
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-08-15
     * @param  none
     * @return informacion de la consulta
     */
    function consultas_anteriores($cim_id){
        satelite_validar();
        $fecha_desde = ($this->input->post('txtfdesde') != '') ? $this->input->post('txtfdesde') : NULL;
        $fecha_hasta = ($this->input->post('txtfhasta') != '') ? $this->input->post('txtfhasta') : NULL;
        if ($fecha_desde != null &&  $fecha_desde != null) {
            $fecha_desde = formatear_fecha('Y-m-d',$fecha_desde);
            $fecha_hasta = formatear_fecha('Y-m-d',$fecha_hasta);
            $where = array("cim_id_epp" => $cim_id, "DATE(cnm_fecha_consulta) BETWEEN '$fecha_desde' AND '$fecha_hasta'" => NULL);
        } else {
            $fecha_desde = date('Y-m-d', strtotime('-3 month'));
            $fecha_hasta = date('Y-m-d');
            $where = array("cim_id_epp" => $cim_id, "DATE(cnm_fecha_consulta) BETWEEN '$fecha_desde' AND '$fecha_hasta'" => null);
        }
        
        $where["cnm_estado >= 0"] = null;

        $consultas_anteriores = $this->medico_model->informacion_consulta_anteriores($where);
        // print_r($this->db->last_query());die();
        // var_dump($consultas_anteriores);die();
        $dato['expediente'] = $cim_id;
        $dato['consultas_anteriores'] = $consultas_anteriores;
        $data['html'] = $this->load->view('modulo_medico/med_procesos/grid_consulta_anteriores',$dato,true);
        if(!$_POST){
            $data['titulo_personal'] = 'Agregar consulta';
            $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_procesos/consultas_anteriores',$data);
        }else{
            echo json_encode(array('html' => $data['html']));
        }
    }

    /**
     * Descripción:
     * ajax de articulo (tabla: art_articulo)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param 
     * @return true
     */
    public function get_articulo_like()
    {
        satelite_validar();
        $nombre = $this->input->post('nombre');
        $bodega = ($this->input->post('bodega')) ? $this->input->post('bodega') : 0;
        $where["CONCAT_WS(' ',art_nombre,art_codigo,art_sinonimo) LIKE '%$nombre%'"] = null;        
        $detalle_medicamntos = $this->medico_model->articulo_like($where, $bodega);
        echo json_encode($detalle_medicamntos);
        die();
    }    

    /**
     * Descripción:
     * ajax de presentacion (tabla: tia_tipo_articulo,art_articulo)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param 
     * @return true
     */
    public function get_presentacion()
    {
        satelite_validar();
        $id = $this->input->post('id');

        $where["art_id"] = $id;
        $this->db->join('ppr_presentacion_producto', 'art_id_ppr = ppr_id','left');
        $detalle_presentacion = $this->gsatelite->get_tabla("art_articulo",$where);

        //print_r($detalle_presentacion);die();

        echo json_encode($detalle_presentacion[0]);

    }

    /**
     * Descripción:
     * Subir archivos
     * @author Habby Lovo - Grupo Satélite
     * @since 2019-08-08
     * @param 
     * @return true
    */
    public function registrar_archivo($parametros, $carpeta = null) {
        $datos = @explode($parametros);
        $carpeta = $parametros;
        $image = $this->subir_archivo($carpeta);
        // echo $image['upload_data']['raw_name'].$image['upload_data']['file_ext'];
        $json = json_encode($image['upload_data']);
        // print_r($json);die();
        echo ($json == "null") ? "" : $json;
    }

    public function subir_archivo($carpeta) {
        $carpeta = str_replace("-", "/", $carpeta);
        $ruta = FCPATH . "uploads/" . $carpeta;
        if (!file_exists($ruta)) {
            mkdir($ruta, 0777);
        }
        $obj = &get_instance();
        $config['upload_path'] = $ruta;
        $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx|zip|rar|txt|ppt|pptx|zip|rar|flv|mp4|mp3';
        $config['max_size'] = 100000;
        // $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx';
        $obj->load->library('upload', $config);
        // print_r($obj->upload);

        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return true;
        } else {
            $data = array('upload_data' => $obj->upload->data());
            // print_r($data['upload_data']['orig_name']);
            // $prueba = filesize($ruta.'/'.$data['upload_data']['orig_name']) ;
            // print_r($prueba);
            return $data;
        }
        print_r($data);
    }

    public function eliminar_anexo(){
        $carpeta_archivo = $this->input->post("carpeta_archivo");
        $nombre_archivo = $this->input->post("nombre_archivo");
        $regresar = 0;
        $carp = ($carpeta_archivo != "") ? $carpeta_archivo : "documentos";
        if ($carpeta_archivo != '' && $nombre_archivo != '') {
            $carpeta = FCPATH.$carpeta_archivo;
            if (file_exists($carpeta.trim($nombre_archivo))) {
                // print_r($carpeta.trim($nombre_archivo));
                unlink($carpeta.trim($nombre_archivo) );
            }
            $regresar = 1;
        } 
        echo json_encode(array('error' => $regresar));
    }

    public function get_departamento(){
        $pais = $this->input->post('pais');
        $departamento_reg = $this->gsatelite->get_tabla('dep_departamento', array('dep_estado' => 1, 'dep_id_pai' => $pais));
        $select = '<option value=""></option>';
        foreach ($departamento_reg as $key => $value) {
            $select .= '<option value="'.$value['dep_id'].'">'.$value['dep_nombre'].'</option>';
        }

        echo json_encode(array('slcDepartamento' => $select));
    }

    public function get_ciudades_municipio(){
        $departamento = $this->input->post('departamento');
        $tipo = ($this->input->post('tipo') != '')?$this->input->post('tipo'):0;

        if($tipo != 0){
            //$this->db->group_by('mun_id');
            $this->db->join('ciu_ciudad', 'ciu_id_mun = mun_id', 'INNER');
        }
        $municipio_reg = $this->gsatelite->get_tabla('mun_municipio', array('mun_estado' => 1, 'mun_id_dep' => $departamento));
        $select = '<option value=""></option>';
        //print_r($municipio_reg);die();
        foreach ($municipio_reg as $key => $value) {
            $select .= '<option value="'.(($tipo==0)?$value['mun_id']:$value['ciu_id']).'" data-municipio="'.$value['mun_id'].'">'.(($tipo==0)?$value['mun_nombre']:$value['ciu_nombre']).'</option>';
        }

        echo json_encode(array('slcMunicipioCiudad' => $select));
    }

    public function get_distritos_municipio(){
        $munid = $this->input->post('municipio');
        $slctd = $this->gsatelite->get_dropdown('dis_distrito','{dis_nombre}','', array('dis_id_mun'=>$munid, "dis_estado"=>1), null, '', 'dis_id', true);
        $distr = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'),'<option value=""></option>',$slctd);
        echo json_encode(array('distrito' => $distr));
    }

    /**
    * Descripción:
    * ajax para la elexion de medico (tabla: tia_tipo_articulo,art_articulo)
    * @author Marlon Olmedo - Grupo Satélite
    * @since 2019-08-08
    * @param 
    * @return true
    */
    public function get_medico()
    {
        satelite_validar();
        $id = $this->input->post('id');
        $where["epp_id"] = $id;
        $medico = $this->gsatelite->get_tabla("epp_expediente_paciente",$where);
        echo json_encode($medico[0]);
    }

    public function get_duracion_prom(){
        $id = $this->input->post('id');
        if ($id > 0) {
            $pcm_row = $this->gsatelite->get_tabla("pcm_procedimiento_medico", array('pcm_id' => $id));
            $prom = (count($pcm_row) > 0) ? number_format($pcm_row[0]['pcm_duraccion_aprox'], 2) : "";
        } else {
            $prom = "";
        }
        echo $prom;
    }

    /**
    * Descripción:
    * ajax para la elexion de medico (tabla: tia_tipo_articulo,art_articulo)
    * @author Francisco Orozco - Grupo Satélite
    * @since 2019-09-16
    * @param 
    * @return true
    */
    public function procedimiento_quirurgico(){
        satelite_validar();
        if( $this->input->post() ) {
            // var_dump($_POST);die();
            $where = null;
            $pgp_fecha_fin = $this->input->post('hasta');
            $pgp_fecha_inicio = $this->input->post('desde');
            $pgp_id_epp = $this->input->post('slc_paciente');
            $pgp_numero = $this->input->post('procedimiento');
            $pgp_estado_programacion = $this->input->post('slcestado');
            if ( $pgp_numero != "") {
                $where['pgp_numero'] = $pgp_numero;
            }
            if ( $pgp_fecha_inicio != "") {
                $where['DATE(pgp_fecha_procedimiento) >='] = date('Y-m-d', strtotime($pgp_fecha_inicio)); 
            }
            if ( $pgp_fecha_fin != "") {
                $where['DATE(pgp_fecha_procedimiento) <='] = date('Y-m-d', strtotime($pgp_fecha_fin)); 
            }
            if ( $pgp_id_epp != "") {
                $where['pgp_id_epp'] = $pgp_id_epp;
            }
            if ( $pgp_estado_programacion != "") {
                $where['pgp_id_epp'] = $pgp_estado_programacion;
            }
            $data['destalles']  = $this->medico_model->get_procedimiento_quirurgico($where,"pgp_id");  
            $html               = $this->load->view('modulo_medico/med_procesos/ver_procedimiento_quirurgico', $data, true);                
            $resultado['html']  = $html;
            echo json_encode($resultado);
            die();
        } else {
            $data['titulo_personal']= 'Programación de procedimiento quirúrgico';
            cargarvista($data);
        }
    }

     /**
    * Descripción:
    * Agregar procedimiente quirurgico.
    * @author Francisco Orozco - Grupo Satélite
    * @since 2019-09-16
    * @param 
    * @return view
    */
    public function agregar_procedimiento(){ 
        satelite_validar();
        if( $this->input->post() ) {
            $pgp_id_epp             = $this->input->post('slc_paciente');
            $pgp_id_pcm             = $this->input->post('slc_tipo_procedimiento');
            $pgp_id_med             = $this->input->post('slc_medico');
            $pgp_id_med_anestesia   = $this->input->post('slc_anestesiologo');
            $pgp_id_med_ayudante    = $this->input->post('slc_ayudante');
            $pgp_id_luc             = $this->input->post('slc_lugar');
            $pgp_id_tan             = $this->input->post('slsc_anestesia');
            $pgp_numero             = $this->input->post('txt_promgracion');
            $pgp_tipo               = $this->input->post('slc_tipo');
            $pgp_fecha_procedimiento= $this->input->post('txt_fecha_procedimiento');
            $pgp_hora_desde         = $this->input->post('txthdesde');
            $pgp_duracion_promedio  = $this->input->post('txt_horas'); 
            $pgp_observacion        = $this->input->post('txt_observacion');   
            $especialidad        = $this->input->post('slc_especialidad');  
            $tipo_btn               = $this->input->post('btnCrear');  
        
            $pgp_programacion_procedimiento = array (
                'pgp_id_epp'            => ( $pgp_id_epp != "" )?$pgp_id_epp:null,
                'pgp_id_pcm'            => ( $pgp_id_pcm != "" )?$pgp_id_pcm:null,
                'pgp_id_med'            => ( $pgp_id_med != "")?$pgp_id_med:null,
                'pgp_id_epm'            => ( $especialidad != "")?$especialidad:null,
                'pgp_id_med_anestesia'  => ( $pgp_id_med_anestesia != "")?$pgp_id_med_anestesia:null,
                'pgp_id_med_ayudante'   => ( $pgp_id_med_ayudante!= "")?$pgp_id_med_ayudante:null,
                'pgp_id_luc'            => ( $pgp_id_luc != "")?$pgp_id_luc:null,
                'pgp_id_tan'            => ( $pgp_id_tan != "")?$pgp_id_tan:null,
                'pgp_numero'            => ( $pgp_numero != "")?$pgp_numero:null,
                'pgp_tipo'              => ( $pgp_tipo != "")?$pgp_tipo:null,     
                'pgp_fecha_procedimiento'=>( $pgp_fecha_procedimiento != "")?date('Y-m-d', strtotime($pgp_fecha_procedimiento)):null,               
                'pgp_hora_desde'        => ( $pgp_hora_desde != "")?$pgp_hora_desde:null, 
                'pgp_duracion_promedio' => ( $pgp_duracion_promedio != "")?$pgp_duracion_promedio:null, 
                'pgp_observacion'       => ( $pgp_observacion != "")?$pgp_observacion:null, 
                'pgp_estado_programacion'=> 1,
                'pgp_estado'            => 1, 
                'pgp_usu_creacion'      => $this->tank_auth->get_user_id(),
                'pgp_fecha_creacion'    => date('Y-m-d h:i:s'), 
                'pgp_usu_modificacion'  => $this->tank_auth->get_user_id(), 
                'pgp_fecha_modificacion'=> date('Y-m-d h:i:s')
            );

            $pgp_id = $this->gsatelite->ingresar('pgp_programacion_procedimiento', $pgp_programacion_procedimiento);

            //Array con datos de los anexos
            $ruta_anexos    = $this->input->post('ruta');
            $titulo_anexo   = $this->input->post('titulo_doc');

            //Si vienen anexos
            if (!empty($ruta_anexos)) {
                for ($i = 0; $i < count($ruta_anexos); $i++) {

                    $extension = end(explode('.', $ruta_anexos[$i]));
                    $carpeta_temporal_anx = $ruta = "public/temp/anexos_medicos/" . trim($ruta_anexos[$i]);
                    $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                    $carpeta_destino_anx = "uploads/anexos_medicos/" . $nombreArchivo;

                    $documentos_array = array(
                        'apg_id_pgp'             => $pgp_id,
                        'apg_url'                => $carpeta_destino_anx,
                        'apg_nombre'             => $nombreArchivo,
                        'apg_estado'             => 1,
                        'apg_usu_creacion'       => $this->tank_auth->get_user_id(),
                        'apg_fecha_creacion'     => date('Y-m-d H:i:s'),
                        'apg_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'apg_fecha_modificacion' => date('Y-m-d H:i:s')
                    );

                    $apg_id = $this->gsatelite->ingresar('apg_anexo_programacion', $documentos_array);

                    if ($apg_id > 0) {
                        copy($carpeta_temporal_anx, $carpeta_destino_anx);
                        unlink($carpeta_temporal_anx);
                    }
                }
            }


            if ($pgp_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procedimiento quirúrgico", 'texto_alerta' => "El registro se guardó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "procedimiento quirúrgico", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $this->session->set_flashdata($alerta);
            if ($tipo_btn == 1) {
                redirect('/modulo_medico/med_procesos/agregar_procedimiento');
            } else {
                redirect('modulo_medico/med_procesos/procedimiento_quirurgico');
            }

        } else { 
            $tipos_procedimiento = $this->gsatelite->get_tabla('pcm_procedimiento_medico', array('pcm_estado' => 1) );
            $data['tipos_procedimiento'] = $tipos_procedimiento;

            $medico_dropdown= $this->gsatelite->get_dropdown('med_medico', '{med_nombre}', '', array('med_estado'=>1),'', '', 'med_id', true);
            $data['medicos'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $medico_dropdown);

            $lugar_dropdown = $this->gsatelite->get_dropdown('luc_lugar_cita', '{luc_nombre}', '', array('luc_estado'=>1),'', '', 'luc_id', true);
            $data['lugares'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $lugar_dropdown);

            $anestesia_slc  = $this->gsatelite->get_dropdown('tan_tipo_anestesia', '{tan_nombre}', '', array('tan_estado'=>1),'', '', 'tan_id', true);
            $data['anestesias'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $anestesia_slc);

            $data['pacnt_perm'] = $this->gsatelite->get_permisos_opcion('expediente_paciente','agregar',null,true);
            $data['espec_perm'] = $this->gsatelite->get_permisos_opcion('modulo_medico/med_mantenimientos/especialidad','agregar',null,true);
            $data['procd_perm'] = $this->gsatelite->get_permisos_opcion('modulo_medico/med_mantenimientos/tipo_procedimiento','agregar',null,true);
            $data['medic_perm'] = $this->gsatelite->get_permisos_opcion('modulo_medico/med_mantenimientos/medico','agregar',null,true);

            $max_pgp = $this->gsatelite->get_max('pgp_programacion_procedimiento','pgp_id');
            $now_pgp = ( $max_pgp != null) ? $max_pgp + 1 : 1;
            $correlativo = str_pad($now_pgp, 4, "0", STR_PAD_LEFT);
            $data['correlativo']    = 'PCD-'.$correlativo;
            $data['titulo_personal']= 'Agregar programación de procedimiento quirúrgico';
            cargarvista($data);
        }
    }


    /**
    * Descripción:
    * Editar procedimiente quirurgico.
    * @author Francisco Orozco - Grupo Satélite
    * @since 2019-09-16
    * @param INT = pgp_id 
    * @return view
    */
    public function editar_procedimiento($pgp_id = null,$modal = null){
        satelite_validar();
        if( $this->input->post() ) {
            // var_dump($this->input->post());die();
            $pgp_id_epp             = $this->input->post('slc_paciente');
            $pgp_id_pcm             = $this->input->post('slc_tipo_procedimiento');
            $pgp_id_med             = $this->input->post('slc_medico');
            $pgp_id_med_anestesia   = $this->input->post('slc_anestesiologo');
            $pgp_id_med_ayudante    = $this->input->post('slc_ayudante');
            $pgp_id_luc             = $this->input->post('slc_lugar');
            $pgp_id_tan             = $this->input->post('slsc_anestesia');            
            $pgp_tipo               = $this->input->post('slc_tipo');
            $pgp_fecha_procedimiento= $this->input->post('txt_fecha_procedimiento');
            $pgp_hora_desde         = $this->input->post('txthdesde');
            $pgp_duracion_promedio  = $this->input->post('txt_horas'); 
            $pgp_observacion        = $this->input->post('txt_observacion');    
            $tipo_btn               = $this->input->post('btnCrear'); 
            $pgp_id                 = $this->input->post('txt_procedimiento');  

            $pgp_programacion_procedimiento = array (
                'pgp_id_epp'            => ( $pgp_id_epp != "" )?$pgp_id_epp:null,
                'pgp_id_pcm'            => ( $pgp_id_pcm != "" )?$pgp_id_pcm:null,
                'pgp_id_med'            => ( $pgp_id_med != "")?$pgp_id_med:null,
                'pgp_id_med_anestesia'  => ( $pgp_id_med_anestesia != "")?$pgp_id_med_anestesia:null,
                'pgp_id_med_ayudante'   => ( $pgp_id_med_ayudante!= "")?$pgp_id_med_ayudante:null,
                'pgp_id_luc'            => ( $pgp_id_luc != "")?$pgp_id_luc:null,
                'pgp_id_tan'            => ( $pgp_id_tan != "")?$pgp_id_tan:null,
                'pgp_tipo'              => ( $pgp_tipo != "")?$pgp_tipo:null,     
                'pgp_fecha_procedimiento'=>( $pgp_fecha_procedimiento != "")?date('Y-m-d', strtotime($pgp_fecha_procedimiento)):null,               
                'pgp_hora_desde'        => ( $pgp_hora_desde != "")?$pgp_hora_desde:null, 
                'pgp_duracion_promedio' => ( $pgp_duracion_promedio != "")?$pgp_duracion_promedio:null, 
                'pgp_observacion'       => ( $pgp_observacion != "")?$pgp_observacion:null, 
                'pgp_estado_programacion'=> 1,
                'pgp_estado'            => 1,                 
                'pgp_usu_modificacion'  => $this->tank_auth->get_user_id(), 
                'pgp_fecha_modificacion'=> date('Y-m-d h:i:s')
            );

            $this->gsatelite->actualizar_array('pgp_programacion_procedimiento', $pgp_programacion_procedimiento, array('pgp_id' => $pgp_id));

            $ruta_anexos  = $this->input->post('ruta');
            $titulo_anexo = $this->input->post('titulo_doc');
            //Si vienen anexos
            if (!empty($ruta_anexos)) {
                for ($i = 0; $i < count($ruta_anexos); $i++) {

                    $extension = end(explode('.', $ruta_anexos[$i]));
                    $carpeta_temporal_anx = $ruta = "public/temp/anexos_medicos/" . trim($ruta_anexos[$i]);
                    $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                    $carpeta_destino_anx = "uploads/anexos_medicos/" . $nombreArchivo;

                    $documentos_array = array(
                        'apg_id_cim'             => $pgp_id,
                        'apg_url'                => $carpeta_destino_anx,
                        'apg_nombre'             => $nombreArchivo,
                        'apg_estado'             => 1,
                        'apg_usu_creacion'       => $this->tank_auth->get_user_id(),
                        'apg_fecha_creacion'     => date('Y-m-d H:i:s'),
                        'apg_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'apg_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    
                    $ant_id = $this->gsatelite->ingresar('apg_anexo_programacion', $documentos_array);

                    if ($ant_id > 0) {
                        copy($carpeta_temporal_anx, $carpeta_destino_anx);
                        unlink($carpeta_temporal_anx);
                        die();
                    }
                }
            }

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cita", 'texto_alerta' => "El registro se guardado correctamente");
            $this->session->set_flashdata($alerta);

            if ($tipo_btn == 1) {
                redirect('/modulo_medico/med_procesos/editar_procedimiento/'.$pgp_id);
            } else {
                redirect('/modulo_medico/med_procesos/procedimiento_quirurgico');
            }
            
        } else {
            $where['pgp_id']            = $pgp_id;
            $procedimiento              = $this->medico_model->get_procedimiento_quirurgico($where);  
            //print_r($this->db->last_query());die();           
            $data['procedimiento']      = $procedimiento;
            $tipos_procedimiento        = $this->gsatelite->get_tabla('pcm_procedimiento_medico', array('pcm_estado' => 1) );
            $data['tipos_procedimiento']= $tipos_procedimiento;
        
            $medico_dropdown= $this->gsatelite->get_dropdown('med_medico', '{med_nombre}', '', '', $procedimiento[0]['pgp_id_med'], '', 'med_id', true);
            $medico_dropdown= str_replace('<option value="0">Sin Registros</option>', '', $medico_dropdown); 
            $data['medicos']= str_replace('<option value="0">Seleccione</option>', '', $medico_dropdown);

            $Anestesiologo  = $this->gsatelite->get_dropdown('med_medico', '{med_nombre}', '', '', $procedimiento[0]['pgp_id_med_anestesia'], '', 'med_id', true);
            $Anestesiologo  = str_replace('<option value="0">Sin Registros</option>', '', $Anestesiologo); 
            $data['anestesiologo']= str_replace('<option value="0">Seleccione</option>', '', $Anestesiologo);

            $ayudantes      = $this->gsatelite->get_dropdown('med_medico', '{med_nombre}', '', '', $procedimiento[0]['pgp_id_med_ayudante'], '', 'med_id', true);
            $ayudantes      = str_replace('<option value="0">Sin Registros</option>', '', $ayudantes); 
            $data['ayudantes']= str_replace('<option value="0">Seleccione</option>', '', $ayudantes);

            $lugar_dropdown = $this->gsatelite->get_dropdown('luc_lugar_cita', '{luc_nombre}', '', '',$procedimiento[0]['pgp_id_luc'], '', 'luc_id', true);
            $lugar_dropdown = str_replace('<option value="0">Sin Registros</option>', '', $lugar_dropdown); 
            $data['lugares']= str_replace('<option value="0">Seleccione</option>', '', $lugar_dropdown);

            $anestesia_slc  = $this->gsatelite->get_dropdown('tan_tipo_anestesia', '{tan_nombre}', '', '',$procedimiento[0]['pgp_id_tan'], '', 'tan_id', true);
            $anestesia_slc  = str_replace('<option value="0">Sin Registros</option>', '', $anestesia_slc); 
            $data['anestesias']= str_replace('<option value="0">Seleccione</option>', '', $anestesia_slc);

            $anexos         = $this->gsatelite->get_tabla("apg_anexo_programacion",array("apg_id_pgp" => $pgp_id));
            $data['anexos'] = $anexos;
            $data['solo_consulta'] = 0;

            $data['pacnt_perm'] = $this->gsatelite->get_permisos_opcion('expediente_paciente','agregar',null,true);
            $data['espec_perm'] = $this->gsatelite->get_permisos_opcion('modulo_medico/med_mantenimientos/especialidad','agregar',null,true);
            $data['procd_perm'] = $this->gsatelite->get_permisos_opcion('modulo_medico/med_mantenimientos/tipo_procedimiento','agregar',null,true);
            $data['medic_perm'] = $this->gsatelite->get_permisos_opcion('modulo_medico/med_mantenimientos/medico','agregar',null,true);
                    
            $data['correlativo']    = $procedimiento[0]['pgp_numero'];
            $data['titulo_personal']= 'Editar programación de procedimiento quirúrgico';
            if ($modal==1) {
                $data['solo_consulta'] = 1;
                $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_procesos/editar_procedimiento',$data);
            }else{
                cargarvista($data);
            }
            
        }
    }

    /**
        * Descripción:
        * seguimiento de programacion
        * @author Francisco Orozco - Grupo Satélite
        * @since  2019-09-30
        * @param  Ninguno
        * @return modal
    */
    public function seguimiento_programacion($pgp_id=null){
        satelite_validar();        
        if( $this->input->post() ) { 
            $comentario = $this->input->post('txtcomentario');
            $foto_ruta  = $this->input->post('nombre_imagen') ;
            $foto_titulo= $this->input->post('nombre_foto_nueva');
            $fecha      = $this->input->post('fecha');
            $hora       = $this->input->post('hora');
            $txt_sgp_id = $this->input->post('txt_seguimiento');
            $contador   = 0;

            $seguimiento_table = $this->gsatelite->get_tabla("sgp_seguimiento_programacion_procedimiento",array("sgp_id_pgp" => $pgp_id));
            $seguimiento_id     = array_column($seguimiento_table, "sgp_id");
            
            $cantidad = count($txt_sgp_id);        
            for ($i=0; $i < $cantidad; $i++) {
                if (is_array($txt_sgp_id) && count($txt_sgp_id) > 0) {
                    if (!in_array($txt_sgp_id[$i] , $seguimiento_id)) {

                        if ($foto_ruta[$i] != null or $foto_titulo[$i] != null) {
                            $extension              = end(explode('.', $foto_ruta[$i]));
                            $carpeta_temporal_anx   = "public/temp/anexos_medicos/" . trim($foto_ruta[$i]);
                            $nombreArchivo          = trim($foto_titulo[$i]) . "." . trim($extension);                            
                            $carpeta_destino_anx    = "uploads/anexos_medicos/" . $nombreArchivo;
                            } else {
                                $nombreArchivo      = null;
                            }
                            $sgp_seguimiento_programacion_procedimiento = 
                                array('sgp_id_pgp'          => $pgp_id,
                                    'sgp_id_usu'            => $this->tank_auth->get_user_id(),
                                    'sgp_fecha'             => $fecha[$i],
                                    'sgp_hora'              => $hora[$i],
                                    'sgp_comentario'        => $comentario[$i],
                                    'sgp_url_anexo'         => $nombreArchivo,
                                    'sgp_nombre_anexo'      => ($foto_titulo[$i] != '')? $foto_titulo[$i] : null,
                                    'sgp_estado'            => 1,
                                    'sgp_usu_creacion'      => $this->tank_auth->get_user_id(),
                                    'sgp_fecha_creacion'    => date('Y-m-d H:i:s'),
                                    'sgp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                    'sgp_fecha_modificacion'=> date('Y-m-d H:i:s')
                                );
                        
                            $sgp_id = $this->gsatelite->ingresar('sgp_seguimiento_programacion_procedimiento', $sgp_seguimiento_programacion_procedimiento);

                            if ($sgp_id > 0) {
                                if (isset($carpeta_temporal_anx) && $carpeta_destino_anx) {
                                    copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                    unlink($carpeta_temporal_anx);
                                }
                                $contador++;
                            }
                        }
                    
                }
            }

            foreach ($seguimiento_table as $key => $value) {
                if (!in_array($value['sgp_id'] , $txt_sgp_id) ) {
                    $this->gsatelite->borrado_general('sgp_seguimiento_programacion_procedimiento', array('sgp_id'=>$value['sgp_id']));
                    if ($value['sgp_url_anexo'] != null) {
                        unlink(FCPATH."uploads/anexos_medicos/".$value['sgp_url_anexo']);
                    }
                }
            }
    
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "seguimiento", 'texto_alerta' => "El segumiento se a almacenado exitosamente");
            $this->session->set_flashdata($alerta);
            echo $contador;
            die();

        } else {
            $seguimientos           = $this->gsatelite->get_tabla("sgp_seguimiento_programacion_procedimiento",array("sgp_id_pgp" => $pgp_id));
            $data['seguimientos']   = $seguimientos;
            $data['programacion']   = $pgp_id;
            $data['titulo_personal']= 'Seguimiento';    
            $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_procesos/seguimiento_programacion',$data);
        }
    }

     /**
        * Descripción:
        * Modal para la programacion
        * @author Francisco Orozco - Grupo Satélite
        * @since  2019-08-15
        * @param  Ninguno
        * @return modal
    */
    public function confirmar_programacion($pgp_id = null){ 
        satelite_validar();
        if ($_POST) {
            
            $pgp_estado_programacion= $this->input->post('confirmacion');
            $txt_procedimiento      = $this->input->post('txt_procedimiento');

            $pgp_programacion_procedimiento = array(
                'pgp_estado_programacion'   => $pgp_estado_programacion,
                'pgp_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'pgp_fecha_modificacion'    => date('Y-m-d H:i:s')
            );
         
            $this->gsatelite->actualizar_array('pgp_programacion_procedimiento',$pgp_programacion_procedimiento, array('pgp_id' => $txt_procedimiento));

            if ($pgp_estado_programacion == '2') {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Confirmar cita", 'texto_alerta' => "La cita a sido confirmada exitosamente");
                $this->session->set_flashdata($alerta);
            } else {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cancelada cita", 'texto_alerta' => "La cita a sido Cancelada exitosamente");
                $this->session->set_flashdata($alerta);
            }
            
            echo json_encode(array('procedimiento' => $txt_procedimiento));
            die();

        } else {        
            $where['pgp_id']            = $pgp_id;
            $procedimiento              = $this->medico_model->get_procedimiento_quirurgico($where);             
            $data['procedimiento']      = $procedimiento;
            $tipos_procedimiento        = $this->gsatelite->get_tabla('pcm_procedimiento_medico', array('pcm_estado' => 1) );
            $data['tipos_procedimiento']= $tipos_procedimiento;
        
            $medico_dropdown= $this->gsatelite->get_dropdown('med_medico', '{med_nombre}', '', '', $procedimiento[0]['pgp_id_med'], '', 'med_id', true);
            $medico_dropdown= str_replace('<option value="0">Sin Registros</option>', '', $medico_dropdown); 
            $data['medicos']= str_replace('<option value="0">Seleccione</option>', '', $medico_dropdown);

            $Anestesiologo  = $this->gsatelite->get_dropdown('med_medico', '{med_nombre}', '', '', $procedimiento[0]['pgp_id_med_anestesia'], '', 'med_id', true);
            $Anestesiologo  = str_replace('<option value="0">Sin Registros</option>', '', $Anestesiologo); 
            $data['anestesiologo']= str_replace('<option value="0">Seleccione</option>', '', $Anestesiologo);

            $ayudantes      = $this->gsatelite->get_dropdown('med_medico', '{med_nombre}', '', '', $procedimiento[0]['pgp_id_med_ayudante'], '', 'med_id', true);
            $ayudantes      = str_replace('<option value="0">Sin Registros</option>', '', $ayudantes); 
            $data['ayudantes']= str_replace('<option value="0">Seleccione</option>', '', $ayudantes);

            $lugar_dropdown = $this->gsatelite->get_dropdown('luc_lugar_cita', '{luc_nombre}', '', '',$procedimiento[0]['pgp_id_luc'], '', 'luc_id', true);
            $lugar_dropdown = str_replace('<option value="0">Sin Registros</option>', '', $lugar_dropdown); 
            $data['lugares']= str_replace('<option value="0">Seleccione</option>', '', $lugar_dropdown);

            $anestesia_slc  = $this->gsatelite->get_dropdown('tan_tipo_anestesia', '{tan_nombre}', '', '',$procedimiento[0]['pgp_id_tan'], '', 'tan_id', true);
            $anestesia_slc  = str_replace('<option value="0">Sin Registros</option>', '', $anestesia_slc); 
            $data['anestesias']= str_replace('<option value="0">Seleccione</option>', '', $anestesia_slc);

            $anexos         = $this->gsatelite->get_tabla("apg_anexo_programacion",array("apg_id_pgp" => $pgp_id));
            $data['anexos'] = $anexos;
                    
            $data['correlativo']    = $procedimiento[0]['pgp_numero'];
            
            $data['titulo_personal']= 'Confirmar programación de procedimiento quirúrgico';
            $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_procesos/confirmar_programacion',$data);
        }
    }

    /**
        * Descripción:
        * Cuenta de cliente
        * @author Nelson Soriano
        * @since  2019-12-17
        * @param  None
        * @return view
    */

    public function cuenta_paciente($fecha_inicio = null, $fecha_fin = null, $tipo = null){
        if (!$this->tank_auth->is_logged_in()) {
           redirect('/auth/login/');
       } else {
            $es_jefe = false;
            $roles_usuario = $this->facturacion_model->get_roles_usuario($this->tank_auth->get_user_id());
            $rol_jefe = $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD');
            $rol_admit = 0;
            foreach ($roles_usuario as $key => $value) {
                if($value == 1){
                    $rol_admit = 1;
                }
                if ($value == $rol_jefe) {
                    $es_jefe = true;
                }
            }
            $permisos = $this->gsatelite->get_permisos_opcion();
            if ($tipo) {
                $url_padre =  $_SERVER['HTTP_REFERER'];
            } else {
                $url_padre = uri_string();
            }
            $es_anulacion = ((substr_count($url_padre, 'orden_venta_anular') > 0 || $permisos['funcion'] == 'orden_venta_anular')) ? true : false;
            if ($fecha_inicio == null && $fecha_fin == null) {
                $fecha_inicio = $this->input->post('txtFechaIni');
                $fecha_fin = $this->input->post('txtFechaFin');
            }
            $output = null;
            $crud = new grocery_CRUD();
            if (trim($fecha_inicio) != '') {
                if ($fecha_inicio != '' && $fecha_fin != '') {
                    $crud->where('orv_fecha_orden >=', date('Y-m-d', strtotime($fecha_inicio)));
                    $crud->where('orv_fecha_orden <=', date('Y-m-d H:i:s', strtotime($fecha_fin . " 23:59:59")));                    
                   
                }
                if($rol_admit != 1){
                    // $crud->where('orv_usu_creacion', $this->tank_auth->get_user_id());
                }
                $filEstado = $this->input->post('filEstado');
                if($filEstado != ""){
                    $crud->where('orv_estado', $filEstado);
                }

                $txtcliente = $this->input->post("txtcliente");
                if($txtcliente != ""){
                    $crud->where('orv_id_cli', $txtcliente);
                }
                $display_as = array(
                    'orv_numero_orden'   => 'No. Cuenta',
                    //'orv_nombre_factura' => 'Nombre factura',
                    'orv_fecha_orden'    => 'Fecha/Hora',
                    'orv_id_cli'         => 'Paciente',
                    //'orv_total'          => 'Monto',
                    'orv_estado'         => 'Estado'
                );
                $columns = array(
                    'orv_numero_orden',
                    //'orv_nombre_factura',
                    'orv_fecha_orden',
                    'orv_id_cli',
                    //'orv_total',
                    'orv_estado'
                );
                $crud->set_subject('Cuenta de Paciente')
                    ->set_table('orv_orden_venta')
                    ->columns($columns)
                    ->display_as($display_as)
                    ->callback_column('orv_id_cli', function($value, $row) {
                        $cliente_array = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $row->orv_id_cli));
                        $cliente = ($cliente_array[0]["cli_personeria"] == 1)?($cliente_array[0]["cli_codigo"]." - ".$cliente_array[0]["cli_nombre"]." ".$cliente_array[0]["cli_apellido"]):$cliente_array[0]["cli_codigo"]." - ".$cliente_array[0]["cli_apellido"];
                        return $cliente;
                    })
                    ->callback_column('orv_fecha_orden', function($value, $row) {
                        $urlFull = explode("/", $_SERVER['REQUEST_URI']);
                        if (in_array("print", $urlFull)) {
                            $fecha = formatear_fecha('d-m-Y',$row->orv_fecha_orden);
                        } else {
                            $fecha = '<span style="display:none;">'.formatear_fecha('Ymd',$row->orv_fecha_orden).'</span>'.formatear_fecha('d-m-Y',$row->orv_fecha_orden);
                        }
                        return $fecha;
                    })
                    ->callback_column('orv_total', function($value, $row) {
                        $total = '$' . number_format($row->orv_total, 2);
                        return $total;
                    })
                    ->field_type('orv_estado', 'dropdown', array('1' => 'Pendiente de facturar', '2' => 'Facturado',  '3' => 'Anulada'))
                ;

                $crud->unset_add();
                $crud->unset_edit();
                $crud->unset_delete();
                // $crud->unset_print();
                // $crud->unset_export();
                $crud->unset_read();

               if ($es_anulacion) { //verificar si se esta accediendo desde la opción anular orden de venta
                    //$crud->add_action('&nbsp;&nbsp;Anular', '', 'facturacion/facturar/anular_orden_venta', 'icomoon-icon-cancel-2 anular_orden', null,'' , array('orv_estado'=>'Pendiente de facturar'));
                    if ($es_jefe) {
                        //$crud->add_action('&nbsp;&nbsp;Duplicar', '', 'facturacion/facturar/duplicar_orden_venta', 'icomoon-icon-copy-2 duplicar_orden', null, '', null);
                    }                    
                } else {
                    $crud->add_action('&nbsp;Imprimir', '', 'facturacion/facturar/imprimir_orden_venta', 'icomoon-icon-printer-2 imprimir', null,''/*, array('orv_estado'=>'Pendiente de facturar')*/);
                    $crud->add_action('&nbsp;&nbsp;Editar', '', 'modulo_medico/med_procesos/editar_cuenta', 'icomoon-icon-copy-2 editar', null,'' , array('orv_estado'=>'Pendiente de facturar'));
                    //$crud->add_action('&nbsp;&nbsp;Facturar', '', 'facturacion/facturar/crear_factura', 'icomoon-icon-copy-2 facturar', null,'' , array('orv_estado'=>'Pendiente de facturar'));

                    //$crud->add_action('&nbsp;Nota envio', '', 'facturacion/facturar/imprimir_nota_envio', 'icomoon-icon-printer-2 imprimir nota_envio_x', null,'', array('orv_estado <>'=>'Anulada'));
                }


                $output = $crud->render();
            }

            $data['output'] = $output;
            $data['add'] = ($es_anulacion)? 0:$permisos["permite_agregar"];
            $data['titulo_personal'] = ($es_anulacion)? "Anulación Orden de venta":"Cuenta de Cliente";

            if ($tipo == null) {
                
                cargarvista($data,$output,'modulo_medico/med_procesos/cuenta_paciente');
            } else {
                print($output->output);
            }

        }
    }

    public function crear_cuenta(){
        satelite_validar();
        if ($_POST) {
            $dtg_Norden         = (trim($this->input->post('dtg_Norden')) != "") ? $this->input->post('dtg_Norden') : "";
            $dtg_cliente        = (trim($this->input->post('dtg_cliente')) != "") ? $this->input->post('dtg_cliente') : "";
            $dtg_nombre_factura = (trim($this->input->post('dtg_nombre_factura')) != "") ? $this->input->post('dtg_nombre_factura') : null;
            $dtf_area           = (trim($this->input->post('dtf_area')) != "") ? $this->input->post('dtf_area') : null;
            $personal           = $this->input->post('personal');//NULL
            $dtg_vendedor       = (trim($this->input->post('dtf_vendedor')) != "") ? $this->input->post('dtf_vendedor') : null;
            $observaciones      = (trim($this->input->post('observaciones')) != "") ? $this->input->post('observaciones') : null;
            $suma_factura_total = (trim($this->input->post('suma_factura_total')) != "") ? $this->input->post('suma_factura_total') : 0;
            $descuentoT_factura_total  = (trim($this->input->post('descuentoT_factura_total')) != "") ? $this->input->post('descuentoT_factura_total') : 0;
            $subtotal_factura_total    = (trim($this->input->post('subtotal_factura_total')) != "") ? $this->input->post('subtotal_factura_total') : 0;
            $impuesto_factura_total    = (trim($this->input->post('impuesto_factura_total')) != "") ? $this->input->post('impuesto_factura_total') : 0;
            $retencion_factura_total   = (trim($this->input->post('retencion_factura_total')) != "") ? $this->input->post('retencion_factura_total') : 0;
            $total_factura_total       = (trim($this->input->post('total_factura_total')) != "") ? $this->input->post('total_factura_total') : 0;
            $total_factura_total_origi = (trim($this->input->post('total_factura_total_origi'))!="") ? $this->input->post('total_factura_total_origi'):0;
            $orv_condicion_pago        = (trim($this->input->post('slc_cond_pago')) != "") ? $this->input->post('slc_cond_pago') : null;
            $orv_comentario            = (trim($this->input->post('txt_comentarios')) != "") ? $this->input->post('txt_comentarios') : null;
            $orv_aplica_picking        = $this->input->post('hdn_picking');
            $id_anticipo = 0;
            $saldo_restante = 0;
            $fin_anticipo = 0;
            $fin_anticipo_2 = 0;
            $monto_guardar = 0;
            $monto_actualizar = 0;
            $productos_id_moi = array();
            $produtos_cantidad_moi = array();
            $productos_medida_moi = array();
            $alerta = "";
            $procedure         = (trim($this->input->post('procedure')) != "") ? $this->input->post('procedure') : null;

            if ($dtg_Norden != "" && $dtg_cliente != "") {
                if ($total_factura_total < 0) {
                   $total_factura_total = 0;
                }
                $ordenes = $this->gsatelite->get_tabla('orv_orden_venta');
                $orden_n = (count($ordenes) + 1);
                
                           $this->db->order_by('orv_id', 'DESC');
                           $this->db->limit(1);
                $ordenes = $this->gsatelite->get_tabla('orv_orden_venta');
                $orden_n = (isset($ordenes[0]['orv_numero_orden']))? ($ordenes[0]['orv_numero_orden'] + 1):1;
                $orden_array = array(
                    'orv_id_arf' => $dtf_area,
                    'orv_id_cli' => $dtg_cliente,
                    'orv_id_ven' => $dtg_vendedor,
                    //'orv_id_fac' => $dtf_serie,
                    'orv_numero_orden' => $orden_n,
                    'orv_fecha_orden' => date('Y-m-d H:i:s'),
                    'orv_nombre_factura' => $dtg_nombre_factura,
                    'orv_total_retencion' => $retencion_factura_total,
                    'orv_subtotal' => $subtotal_factura_total,
                    'orv_descuento' => $descuentoT_factura_total,
                    'orv_impuesto' => $impuesto_factura_total,
                    'orv_total' => convertirFloat($total_factura_total),
                    'orv_observacion' => $observaciones,
                    'orv_condicion_pago' => $orv_condicion_pago,
                    'orv_comentario' => $orv_comentario,
                    'orv_aplica_picking_list' => $orv_aplica_picking,
                    /*'orv_motivo_anulacion' => $slcProyecto,
                    'orv_fecha_anulacion' => $dtf_factura,*/
                    'orv_estado' => 1,
                    'orv_id_pgp' => $procedure,
                    'orv_fecha_creacion' => date('Y-m-d H:i:s'),
                    'orv_usu_creacion' => $this->tank_auth->get_user_id(),
                    'orv_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'orv_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $orv_id = $this->gsatelite->ingresar('orv_orden_venta', $orden_array);
                //Se guarda el personal de la factura
                for ($x = 0; $x < count($personal); $x++) {
                    if (trim($personal[$x]) != "") {
                        //tabla pxf_personalxfactura
                        $detalle_personal = array(
                            'pxo_id_orv' => $orv_id,
                            'pxo_id_emp' => $personal[$x],
                            'pxo_estado' => 1,
                            'pxo_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pxo_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxo_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('pxo_personalxorden_venta', $detalle_personal);
                    }
                }
                //columna codigo
                $combo_agrupacion = $this->input->post('combo_agrupacion');
                $aplica_descarga = $this->input->post('aplica_descarga'); //array
                $fecha_garantia = $this->input->post('garantia_factura');
                $fecha_text_garantia = $this->input->post('txtgarantia_factura');
                $tip_producto = $this->input->post('tip_producto');
                $productos_factura = $this->input->post('producto_factura'); //array
                $correlativo = $this->input->post('producto_correlativo'); //array
                $medida_factura = $this->input->post('medida_factura'); //array
                $codigo_factura = $this->input->post('codigo_factura'); //array
                //columna descripcion
                $descripcion_factura = $this->input->post('descripcion_factura'); //array
                //columna cantidad
                $cantidad_factura = $this->input->post('cantidad_factura'); //array
                //columna precio
                $precio_factura = $this->input->post('precio_factura'); //array
                //impuesto
                $impuesto_factura = $this->input->post('impuesto_factura'); //array
                $impuesto_por_factura = $this->input->post('impuesto_por_factura'); //array
                $impuesto_array = $this->input->post('impuesto_array'); //array
                $impuesto_por_array = $this->input->post('impuesto_por_array'); //array
                //retencion
                $retencion_factura = $this->input->post('retencion_factura'); //array
                $retencion_por_factura = $this->input->post('retencion_por_factura'); //array
                $retencion_array = $this->input->post('retencion_array'); //array
                $retencion_por_array = $this->input->post('retencion_por_array'); //array
                //descuento
                $descuento_factura = $this->input->post('descuento_factura'); //array
                $descuento_por_factura = $this->input->post('descuento_por_factura'); //array
                //subtotal
                $subtotal_factura = $this->input->post('subtotal_factura'); //array
                //total
                $total_factura = $this->input->post('total_factura'); //array
                $tipo_venta = $this->input->post('tipo_venta'); //array
                $bodega_producto = $this->input->post('bodega_producto'); //array
                //Array costo de venta de producto por detalle
                $dov_costo_venta_por_producto = ($this->input->post('costo_venta_por_producto') != '') ? $this->input->post('costo_venta_por_producto') : null; //array
                //datos de caracteristica
                /*
                  Recorremos las caracteristicas de cada producto, usando su Id para identificar los input relacionados, con los input
                  se obtienen los ids de las caracteristicas asociadas con el producto y con esta obtenemos el valor de la caja usando
                  el id del producto con el id de la caracteristica para guardar la relacion
                */
                $id_tlp_array_post = $this->input->post('id_tipo_lista_precio');
                $precio_sugerido_array = $this->input->post('precio_sugerido_array');
                $tipo = $this->input->post('tipo_caracteristica');
                for ($x = 0; $x < count($productos_factura); $x++) {
                    if (trim($productos_factura[$x]) != "" && trim($cantidad_factura[$x]) != "" && trim($precio_factura[$x]) != "" && trim($descripcion_factura[$x]) != "") {
                        //es el id de la caracteristica que cuenta el producto
                        $idart = (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null;
                        $idlip_res = $this->inventario_model->get_tipo_lista_precio(array('lip_id_art' => $idart, 'tpn_id_cli' => $dtg_cliente, 'lip_id_tlp' => $id_tlp_array_post[$x]));
                        $idlip = (count($idlip_res) > 0) ? $idlip_res[0]['lip_id']: null;
                        if ($aplica_descarga[$x] == 1 && $tip_producto[$x] == 0) {
                            if($combo_agrupacion[$x] == 1){
                                $combos_articulo_array = $this->input->post('combo_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                $cantidad_temp_combo = $this->input->post('combo_cantidad_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                $combos_cantidad_array = $cantidad_factura[$x]*$cantidad_temp_combo;
                                $combos_medida_array = $this->input->post('combo_medida_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                for($k = 0; $k < count($combos_articulo_array); $k++){
                                    $productos_id_moi[] = $combos_articulo_array[$k];
                                    $produtos_cantidad_moi[] = $combos_cantidad_array[$k];
                                    $productos_medida_moi[] = $combos_medida_array[$k];
                                }
                            } else{
                                $productos_id_moi[] = $productos_factura[$x];
                                $produtos_cantidad_moi[] = $cantidad_factura[$x];
                                $productos_medida_moi[] = $medida_factura[$x];
                            }
                        }
                        $fecha_def = null;
                        if (trim($fecha_text_garantia[$x]) != '') {
                            $fecha_def = formatear_fecha('Y-m-d', $fecha_garantia[$x]);
                        }
                        $detalle_factura = array(
                            'dov_id_orv' => $orv_id,
                            'dov_id_art' => (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null,
                            'dov_id_cva' => (trim($medida_factura[$x]) != "") ? $medida_factura[$x] : null,
                            'dov_id_lip' => $idlip,
                            'dov_id_tpv' => (trim($tipo_venta[$x]) != "") ? $tipo_venta[$x] : null,
                            'dov_id_bod' => (trim($bodega_producto[$x]) != "") ? $bodega_producto[$x] : null,
                            'dov_descripcion' => (trim($descripcion_factura[$x]) != "") ? $descripcion_factura[$x] : null,
                            'dov_cantidad' => (trim($cantidad_factura[$x]) != "") ? $cantidad_factura[$x] : null,
                            'dov_precio' => (trim($precio_factura[$x]) != "") ? $precio_factura[$x] : null,
                            'dov_precio_sugerido_lista' => trim($precio_sugerido_array[$x]) ? $precio_sugerido_array[$x] : null,
                            'dov_porcentaje_retencion' => (trim($retencion_por_factura[$x]) != "") ? $retencion_por_factura[$x] : null,
                            'dov_porcentaje_impuesto' => (trim($impuesto_por_factura[$x]) != "") ? $impuesto_por_factura[$x] : null,
                            'dov_porcentaje_descuento' => (trim($descuento_por_factura[$x]) != "") ? $descuento_por_factura[$x] : null,
                            'dov_retencion' => (trim($retencion_factura[$x]) != "") ? $retencion_factura[$x] : null,
                            'dov_descuento' => (trim($descuento_factura[$x]) != "") ? $descuento_factura[$x] : 0,
                            'dov_impuesto' => (trim($impuesto_factura[$x]) != "") ? $impuesto_factura[$x] : 0.00,
                            'dov_subtotal' => (trim($subtotal_factura[$x]) != "") ? $subtotal_factura[$x] : null,
                            'dov_combo' => (trim($combo_agrupacion[$x]) != "") ? $combo_agrupacion[$x] : null,
                            'dov_precio_inventario' => $dov_costo_venta_por_producto[$x],
                            'dov_estado' => 1,
                            'dov_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dov_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dov_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dov_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $dov_id = $this->gsatelite->ingresar('dov_detalle_orden_venta', $detalle_factura);
                        //separamos el impuesto de cada producto total y porcentual para almacenarlo en la tabla para el detalle de cada impuesto
                        $impuesto_ids = explode(",", $impuesto_array[$x]);
                        $impuesto_por = explode(",", $impuesto_por_array[$x]);
                        for ($k = 0; $k < count($impuesto_ids); $k++) {
                            if ($impuesto_ids[$k] != 0) {
                                if (trim($impuesto_por[$k]) != "") {
                                    //hacemos el calculo de el monto aplicado para ese impuesto especifico
                                    $monto_temp = $subtotal_factura[$x] * ($impuesto_por[$k] / 100);
                                    //tabla ixf_impuestoxfactura
                                    $detalle_impuesto = array(
                                        'ixv_id_dov' => $dov_id,
                                        'ixv_id_imp' => (trim($impuesto_ids[$k]) != "") ? $impuesto_ids[$k] : null,
                                        'ixv_monto' => $monto_temp,
                                        'ixv_porcentaje' => $impuesto_por[$k],
                                        'ixv_estado' => 1,
                                        'ixv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'ixv_fecha_modificacion' => date('Y-m-d H:i:s'),
                                        'ixv_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'ixv_usu_creacion' => $this->tank_auth->get_user_id()
                                    );
                                    $this->gsatelite->ingresar('ixv_impuestoxorden_venta', $detalle_impuesto);
                                }
                            }
                        }
                        $retencion_ids = explode(",", $retencion_array[$x]);
                        $retencion_por = explode(",", $retencion_por_array[$x]);
                        for ($k = 0; $k < count($retencion_ids); $k++) {
                            if ($retencion_ids[$k] != 0) {
                                if (trim($retencion_por[$k]) != "") {
                                    $monto_temp = $subtotal_factura[$x] * ($retencion_por[$k] / 100);
                                    //tabla rxf_retencionxdetalle_factura
                                    $detalle_retencion = array(
                                        'rxv_id_dov' => $dov_id,
                                        'rxv_id_ret' => (trim($retencion_ids[$k]) != "") ? $retencion_ids[$k] : null,
                                        'rxv_monto' => $monto_temp,
                                        'rxv_porcentaje' => $retencion_por[$k],
                                        'rxv_estado' => 1,
                                        'rxv_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'rxv_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'rxv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'rxv_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->ingresar('rxv_retencionxorden_venta', $detalle_retencion);
                                }
                            }
                        }
                        /* ==========================================================================================
                                    COMPONENTES
                        ===========================================================================================*/
                        $identificador = '_'.$productos_factura[$x].'_'.$correlativo[$x];
                        /* para descargar de bodega             type array*/
                        /*$descargar_componente = $this->input->post('producto_descargar_componente'.$identificador);
                        $tipo_componente = $this->input->post('producto_tipo_componente'.$identificador);
                        $bodega_componente = $this->input->post('bodega_componente_id'.$identificador); // no es arreglo*/
                        /* detalle para guardar                 type array*/
                        $producto_componente = ($this->input->post('producto_componente'.$identificador) != '')?$this->input->post('producto_componente'.$identificador):'';
                        $medida_componente = $this->input->post('medida_componente'.$identificador);
                        $cantidad_componente = $this->input->post('cantidad_conv_componente'.$identificador);
                        $precio_componente = $this->input->post('precio_componente'.$identificador);
                        $subtotal_componente = $this->input->post('subtotal_componente'.$identificador);
                        $descripcion_componente = $this->input->post('descripcion_componente'.$identificador);
                        $alternar_componente = $this->input->post('alternar_componente'.$identificador);
                        $mostrar_descripcion_componete = $this->input->post('showdesc_componente'.$identificador);
                        $fecha_creacion = date('Y-m-d H:i:s');
                        $componente_sav = array();
                        if($producto_componente != ''){
                            foreach ($producto_componente as $id_comp => $comp) {
                                /*if ($descargar_componente[$id_comp] == 1 && $tipo_componente[$id_comp] == 0) {
                                    $productos_id_moi[] = $comp;
                                    $produtos_cantidad_moi[] = $cantidad_componente[$id_comp];
                                    $productos_medida_moi[] = $medida_componente[$id_comp];
                                    $producto_bodega_moi[] = $bodega_componente;
                                }*/
                                $componente_sav[] = array(
                                    'cdv_id_dov' => $dov_id,
                                    'cdv_id_cva' => $medida_componente[$id_comp],
                                    'cdv_descripcion' => $descripcion_componente[$id_comp],
                                    'cdv_cantidad' => $cantidad_componente[$id_comp],
                                    'cdv_precio' => $precio_componente[$id_comp],
                                    'cdv_subtotal' => $subtotal_componente[$id_comp],
                                    'cdv_total' => $subtotal_componente[$id_comp],
                                    'cdv_altera_precio' => $alternar_componente[$id_comp],
                                    'cdv_muestra_descripcion' => $mostrar_descripcion_componete[$id_comp],
                                    'cdv_estado' => 1,
                                    'cdv_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'cdv_fecha_creacion' =>  $fecha_creacion,
                                    'cdv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'cdv_fecha_modificacion' =>  $fecha_creacion
                                );
                            }
                            $this->gsatelite->ingresar('cdv_componente_detallexorden_venta', $componente_sav, true);
                        }
                        /* ====================================================================================================================
                                    FIN COMPONENTES
                        ======================================================================================================================*/
                        /* ====================================================================================================================
                                    CENTRO COSTO
                        ======================================================================================================================*/
                        $centro_costo_costo = ($this->input->post('centro_costo_costo'.$identificador) != '')?$this->input->post('centro_costo_costo'.$identificador):'';
                        $tipo_cuenta_costo = $this->input->post('tipo_cuenta_costo'.$identificador);
                        $cuenta_contable_costo = $this->input->post('cuenta_contable_costo'.$identificador);
                        $porcentaje_costo = $this->input->post('porcentaje_costo'.$identificador);
                        $subtotal_costo = $this->input->post('subtotal_costo'.$identificador);
                        $pais_costo = $this->input->post('pais'.$identificador);
                        $costo_sav = array();
                        if($centro_costo_costo != ''){
                            foreach ($centro_costo_costo as $id_cost => $costo) {
                                $costo_sav[] = array(
                                    'dcv_id_dov' => $dov_id,
                                    'dcv_id_cec' => $centro_costo_costo[$id_cost],
                                    'dcv_id_tcn' => $tipo_cuenta_costo[$id_cost],
                                    'dcv_id_cnt' => $cuenta_contable_costo[$id_cost],
                                    'dcv_id_pai' => ($pais_costo[$id_cost] != "")?$pais_costo[$id_cost]:null,
                                    'dcv_porcentaje' => $porcentaje_costo[$id_cost],
                                    'dcv_monto' => $subtotal_costo[$id_cost],
                                    'dcv_estado' => 1,  
                                    'dcv_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'dcv_fecha_creacion' =>  $fecha_creacion,
                                    'dcv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'dcv_fecha_modificacion' =>  $fecha_creacion
                                );
                            }
                            $this->gsatelite->ingresar('dcv_detalle_centrocostoxorden_venta', $costo_sav, true);
                        }
                        
                    }
                }
                if (count($productos_id_moi) > 0) {
                    //se comento porque no aplica descarga de inventario en ordend e venta // add by René Castaneda
                    //$this->crear_movimiento($orv_id, $productos_id_moi, $produtos_cantidad_moi, $productos_medida_moi);
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de factura", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de factura", 'texto_alerta' => "El registro no se guardó, revise la información a ingresar.");
            }
            $redireccion = $this->input->post('redireccionar');
            $this->session->set_flashdata($alerta);
            //$this->session->set_flashdata('id_orden_venta', $orv_id);
            if ($redireccion == 0) {
                redirect('modulo_medico/med_procesos/crear_cuenta/');
            } else if ($redireccion == 1) {
                redirect('modulo_medico/med_procesos/cuenta_paciente');
            } else {
                $this->session->set_flashdata('id_orden', $orv_id);
                redirect('modulo_medico/med_procesos/crear_cuenta/');
            }
        }
        $datos["titulo_personal"] = "Agregar Cuenta de Cliente";
        $this->db->order_by('orv_id', 'DESC');
        $this->db->limit(1);
        $ordenes = $this->gsatelite->get_tabla('orv_orden_venta');
        //$datos["numero_orden"] = (count($ordenes) + 1);
        $datos["numero_orden"] = (isset($ordenes[0]['orv_numero_orden'])) ? ($ordenes[0]['orv_numero_orden'] + 1) : 1;
        $cliente_array = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
        $cliente_drop = "";
        foreach ($cliente_array as $key) {
            $cliente_temp = ($key["cli_personeria"] == 1)?($key["cli_codigo"]." - ".$key["cli_nombre"]." ".$key["cli_apellido"]):$key["cli_codigo"]." - ".$key["cli_apellido"];
            $cliente_drop .= '<option value="'.$key['cli_id'].'">'.$cliente_temp.'</option>';
        }
        $datos["cliente"] = $cliente_drop;
        $permite_mas_productos = $this->gsatelite->get_parametro('SYS_PERMITE_DUPLICAR_PRODUCTO');
        $datos['permite_mas_productos'] = (trim($permite_mas_productos) != '')?$permite_mas_productos:0;
        $arf_defecto = $this->gsatelite->get_campo('arf_area_factura', 'arf_id', array('arf_defecto'=> 1, 'arf_estado'=> 1));
        $area_drop = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}', '', array('arf_estado' => '1'), $arf_defecto, '', 'arf_id', true);
        $datos["area"] = str_replace('<option value="0">Seleccione</option>', '', $area_drop);
        $vendedor_reg = $this->facturacion_model->obtener_usuarios_rol(array('rol_id'=>5,'id'=>$this->tank_auth->get_user_id()));
        $empleados_select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), null, '', 'emp_id', true);
        $datos["empleados"] = str_replace('<option value="0">Seleccione</option>', '', $empleados_select);
        $vendedores_select = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => '1'), (count($vendedor_reg) > 0?$vendedor_reg[0]['ven_id']:null), '', 'ven_id', true);
        $datos["vendedores"] = str_replace('<option value="0">Seleccione</option>', '', $vendedores_select);
        $datos['vendedor_reg'] = (count($vendedor_reg) > 0) ? 1 : 0;
        $datos['vendedor_defecto']  = $vendedor_reg[0]['ven_id'];
        $select = "";
        $tip_venta_reg = $this->gsatelite->get_tabla('tpv_tipo_venta', array('tpv_estado' => 1, 'tpv_aplica_venta' => 1));
        foreach ($tip_venta_reg as $key) {
            $select .= '<option value="' . $key['tpv_id'] . '" abrv="' . $key['tpv_abreviacion'] . '">' . $key['tpv_nombre'] . '-' . $key['tpv_abreviacion'] . '</option>';
        }
        $datos["tipo_venta"] = $select;
        $datos["categorias"] = $this->obtener_categoriaxbodega2();
        // $datos["cliente_defecto"] = $this->gsatelite->get_parametro('SYS_CLIENTE_DEFECTO');
        $clidefct = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1, 'cli_id' => $this->gsatelite->get_parametro('SYS_CLIENTE_DEFECTO')));
        if (count($clidefct) > 0) {
            $datos['iddf'] = $clidefct[0]['cli_id'];
            $datos["cliente_defecto"] = $clidefct[0]['cli_id'];
            $nombre_def = $clidefct[0]['cli_codigo'] . ' - ';
            $nombre_def .= ($clidefct[0]['cli_personeria'] > 1) ? $clidefct[0]['cli_apellido'] : $clidefct[0]['cli_nombre'] . ' ' . $clidefct[0]['cli_apellido'];
            $datos['namedf'] = $nombre_def;
        } else {
            $datos['iddf'] = "";
            $datos['namedf'] = "";
            $datos["cliente_defecto"] = "";
        }

        $datos["activar_alerta_productox"] = $this->gsatelite->get_parametro('SYS_NOTIFICACION_EXISTENCIAX');
        $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $datos['decimales'] = ($decimales != '')?$decimales:2;
        $user=$this->tank_auth->get_user_id();
        $bodegas_reg = $this->facturacion_model->bodegas_cliente(array('uxb_id_usu'=>$user));
        $select = "";
        foreach ($bodegas_reg as $key) {
            $selected = ($key['uxb_defecto'] == 1)?'selected':'';
            $select .= '<option value="'.$key['bod_id'].'" '.$selected.'>'.$key['bod_nombre'].'</option>';
        }
        $datos["bodega_prefe"] = $select;
        $this->_cargarvista($datos, null);
    }

    function obtener_categoriaxbodega2() {
        $permite_combinar = $this->gsatelite->get_parametro('SYS_PERMITE_FACTURAR_PRODUCTO_SERVICIO');
        $categoria_productos = $this->inventario_model->get_categoria_factura3("tia_nombre");
        //print_r($this->db->last_query());exit();die();
        //print_r($this->db->last_query());die();exit();
        $categorias_array = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1));
        $select = "";
        $categorias_id = array();
        $categorias_codigo = array();
        $categorias_nombre = array();
        $venta = array();
        $inventario = array();
        foreach ($categoria_productos as $key) {
            if ($key["tia_padre"] == "") {
                if (!in_array($key["tia_nombre"], $categorias_nombre)) {
                    $categorias_nombre[] = $key["tia_nombre"];
                    $categorias_codigo[] = $key["tia_codigo"];
                    $categorias_id[] = $key["tia_id"];
                    $venta[] = $key["art_venta"];
                    $inventario[] = $key["art_inventario"];
                }
            } else {
                $arreglo = $this->obtener_padre($key["tia_id"], $categorias_array);
                if (!in_array($arreglo[0], $categorias_nombre)) {
                    $categorias_nombre[] = $arreglo[0];
                    $categorias_id[] = $arreglo[1];
                    $categorias_codigo[] = $arreglo[2];
                    $venta[] = $key["art_venta"];
                    $inventario[] = $key["art_inventario"];
                }
            }
        }
        for ($x = 0; $x < count($categorias_nombre); $x++) {
            $select .= '<option value="' . $categorias_id[$x] . '">'.$categorias_codigo[$x].' - '.$categorias_nombre[$x] . '</option>';
        }
        return $select;
    }


     function obtener_padre($tia_id, $categorias_array = null) {

        //$registros = $this->inventario_model->get_papa_tia(array('tia_id'=>$tia_id));
        $tia_id_ = '';
        $tia_codigo = '';
        $tia_padre = '';
        $tia_nombre = '';
        foreach ($categorias_array as $key) {
            if ($tia_id == $key['tia_id']) {
                $tia_id = $key['tia_id'];
                $tia_codigo = $key['tia_codigo'];
                $tia_padre = $key['tia_padre'];
                $tia_nombre = $key['tia_nombre'];
            }
        }
        if ($tia_padre != null) {
            do {
                foreach ($categorias_array as $key) {
                    if ($tia_padre == $key['tia_id']) {
                        $tia_id = $key['tia_id'];
                        $tia_codigo = $key['tia_codigo'];
                        $tia_padre = $key['tia_padre'];
                        $tia_nombre = $key['tia_nombre'];
                    }
                }
            } while ($tia_padre != null);
        }
        //echo $tia_nombre;
        return array($tia_nombre, $tia_id, $tia_codigo);
    }

    function _cargarvista($data = 0, $crud = 0, $ruta_vista = ""){
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = (trim($ruta_vista) != '' and substr_count(trim($ruta_vista), '/') > 1 ) ? trim($ruta_vista) : $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    } 

    public function editar_cuenta($id){
        satelite_validar();
        if ($_POST) {
            $dtg_Norden = (trim($this->input->post('dtg_Norden')) != "") ? $this->input->post('dtg_Norden') : null;
            $dtg_cliente = (trim($this->input->post('dtg_cliente')) != "") ? $this->input->post('dtg_cliente') : null;
            $dtg_nombre_factura = (trim($this->input->post('dtg_nombre_factura')) != "") ? $this->input->post('dtg_nombre_factura') : null;
            $dtf_area = (trim($this->input->post('dtf_area')) != "") ? $this->input->post('dtf_area') : null;
            $personal = $this->input->post('personal');
            $dtg_vendedor = (trim($this->input->post('dtf_vendedor')) != "") ? $this->input->post('dtf_vendedor') : null;
            $observaciones = (trim($this->input->post('observaciones')) != "") ? $this->input->post('observaciones') : null;
            $suma_factura_total = (trim($this->input->post('suma_factura_total')) != "") ? $this->input->post('suma_factura_total') : 0;
            $descuentoT_factura_total = (trim($this->input->post('descuentoT_factura_total')) != "") ? $this->input->post('descuentoT_factura_total') : 0;
            $subtotal_factura_total = (trim($this->input->post('subtotal_factura_total')) != "") ? $this->input->post('subtotal_factura_total') : 0;
            $impuesto_factura_total = (trim($this->input->post('impuesto_factura_total')) != "") ? $this->input->post('impuesto_factura_total') : 0;
            $retencion_factura_total = (trim($this->input->post('retencion_factura_total')) != "") ? $this->input->post('retencion_factura_total') : 0;
            $total_factura_total = (trim($this->input->post('total_factura_total')) != "") ? $this->input->post('total_factura_total') : 0;
            $total_factura_total_origi = (trim($this->input->post('total_factura_total_origi')) != "") ? $this->input->post('total_factura_total_origi'):0;
            $orv_condicion_pago        = (trim($this->input->post('slc_cond_pago')) != "") ? $this->input->post('slc_cond_pago') : null;
            $orv_comentario            = (trim($this->input->post('txt_comentarios')) != "") ? $this->input->post('txt_comentarios') : null;
            $id_anticipo = 0;
            $saldo_restante = 0;
            $fin_anticipo = 0;
            $fin_anticipo_2 = 0;
            $monto_guardar = 0;
            $monto_actualizar = 0;
            $productos_id_moi = array();
            $produtos_cantidad_moi = array();
            $productos_medida_moi = array();
            $alerta = "";
            //print_r($_POST);die();exit();
            if ($dtg_Norden != "" && $dtg_cliente != "") {
                if ($total_factura_total < 0) {
                   $total_factura_total = 0;
                }
                $orden_array = array(
                    'orv_id_arf' => $dtf_area,                    
                    'orv_id_cli' => $dtg_cliente,
                    'orv_id_ven' => $dtg_vendedor,
                    'orv_nombre_factura' => $dtg_nombre_factura,
                    'orv_total_retencion' => $retencion_factura_total,
                    'orv_subtotal' => $subtotal_factura_total,
                    'orv_descuento' => $descuentoT_factura_total,
                    'orv_impuesto' => $impuesto_factura_total,
                    'orv_condicion_pago' => $orv_condicion_pago,
                    'orv_comentario' => $orv_comentario,
                    'orv_total' => convertirFloat($total_factura_total),
                    'orv_observacion' => $observaciones,
                    'orv_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'orv_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('orv_orden_venta', $orden_array, array('orv_id'=>$id));
                //$orv_id = $this->gsatelite->ingresar('orv_orden_venta', $orden_array);
                //Se guarda el personal de la factura
                $this->gsatelite->borrado_general("pxo_personalxorden_venta", array('pxo_id_orv'=>$id));
                for ($x = 0; $x < count($personal); $x++) {
                    if (trim($personal[$x]) != "") {
                        //tabla pxo_personalxorden_venta
                        $detalle_personal = array(
                            'pxo_id_orv' => $id,
                            'pxo_id_emp' => $personal[$x],
                            'pxo_estado' => 1,
                            'pxo_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pxo_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxo_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('pxo_personalxorden_venta', $detalle_personal);
                    }
                }
                //columna codigo
                $dov_id_grid = $this->input->post('dov_id');
                $combo_agrupacion = $this->input->post('combo_agrupacion');
                $aplica_descarga = $this->input->post('aplica_descarga'); //array
                $fecha_garantia = $this->input->post('garantia_factura');
                $fecha_text_garantia = $this->input->post('txtgarantia_factura');
                $tip_producto = $this->input->post('tip_producto');
                $productos_factura = $this->input->post('producto_factura'); //array
                $correlativo = $this->input->post('producto_correlativo'); //array
                $medida_factura = $this->input->post('medida_factura'); //array
                $codigo_factura = $this->input->post('codigo_factura'); //array
                //columna descripcion
                $descripcion_factura = $this->input->post('descripcion_factura'); //array
                //columna cantidad
                $cantidad_factura = $this->input->post('cantidad_factura'); //array
                //columna precio
                $precio_factura = $this->input->post('precio_factura'); //array
                //impuesto
                $impuesto_factura = $this->input->post('impuesto_factura'); //array
                $impuesto_por_factura = $this->input->post('impuesto_por_factura'); //array
                $impuesto_array = $this->input->post('impuesto_array'); //array
                $impuesto_por_array = $this->input->post('impuesto_por_array'); //array
                //retencion
                $retencion_factura = $this->input->post('retencion_factura'); //array
                $retencion_por_factura = $this->input->post('retencion_por_factura'); //array
                $retencion_array = $this->input->post('retencion_array'); //array
                $retencion_por_array = $this->input->post('retencion_por_array'); //array
                //descuento
                $descuento_factura = $this->input->post('descuento_factura'); //array
                $descuento_por_factura = $this->input->post('descuento_por_factura'); //array
                //subtotal
                $subtotal_factura = $this->input->post('subtotal_factura'); //array
                //total
                $total_factura = $this->input->post('total_factura'); //array
                $tipo_venta = $this->input->post('tipo_venta'); //array
                //datos de caracteristica
                /*Recorremos las caracteristicas de cada producto, usando su Id para identificar los input relacionados, con los input
                  se obtienen los ids de las caracteristicas asociadas con el producto y con esta obtenemos el valor de la caja usando
                  el id del producto con el id de la caracteristica para guardar la relacion*/
                $id_tlp_array_post = $this->input->post('id_tipo_lista_precio');
                $precio_sugerido_array = $this->input->post('precio_sugerido_array');
                $dov_array = $this->gsatelite->get_tabla('dov_detalle_orden_venta', array('dov_id_orv'=>$id));
                foreach ($dov_array as $key3) {
                    if(!in_array($key3['dov_id'], $dov_id_grid)){
                        $this->gsatelite->borrado_general("ixv_impuestoxorden_venta", array('ixv_id_dov'=>$key3['dov_id']));
                        $this->gsatelite->borrado_general("rxv_retencionxorden_venta", array('rxv_id_dov'=>$key3['dov_id']));
                        $this->gsatelite->borrado_general('cdv_componente_detallexorden_venta', array('cdv_id_dov' => $key3['dov_id']));
                        $this->gsatelite->borrado_general('dcv_detalle_centrocostoxorden_venta', array('dcv_id_dov' => $key3['dov_id']));
                        $this->gsatelite->borrado_general("dov_detalle_orden_venta", array('dov_id'=>$key3['dov_id']));
                    }
                }
                for ($x = 0; $x < count($productos_factura); $x++) {
                    if (trim($productos_factura[$x]) != "" && trim($cantidad_factura[$x]) != "" && trim($precio_factura[$x]) != "" && trim($descripcion_factura[$x]) != "") {
                        //es el id de la caracteristica que cuenta el producto
                        $idart = (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null;
                        $idlip_res = $this->inventario_model->get_tipo_lista_precio(array('lip_id_art' => $idart, 'tpn_id_cli' => $dtg_cliente, 'lip_id_tlp' => $id_tlp_array_post[$x]));
                        $idlip = (count($idlip_res) > 0) ? $idlip_res[0]['lip_id']: null;
                        if(trim($dov_id_grid[$x]) != ''){
                            $detalle_factura = array(
                                'dov_id_orv' => $id,
                                'dov_id_cva' => (trim($medida_factura[$x]) != "") ? $medida_factura[$x] : null,
                                'dov_id_lip' => $idlip,
                                'dov_id_tpv' => (trim($tipo_venta[$x]) != "") ? $tipo_venta[$x] : null,
                                'dov_descripcion' => (trim($descripcion_factura[$x]) != "") ? $descripcion_factura[$x] : null,
                                'dov_cantidad' => (trim($cantidad_factura[$x]) != "") ? $cantidad_factura[$x] : null,
                                'dov_precio' => (trim($precio_factura[$x]) != "") ? $precio_factura[$x] : null,
                                'dov_precio_sugerido_lista' => trim($precio_sugerido_array[$x]) ? $precio_sugerido_array[$x] : null,
                                'dov_porcentaje_retencion' => (trim($retencion_por_factura[$x]) != "") ? $retencion_por_factura[$x] : null,
                                'dov_porcentaje_impuesto' => (trim($impuesto_por_factura[$x]) != "") ? $impuesto_por_factura[$x] : null,
                                'dov_porcentaje_descuento' => (trim($descuento_por_factura[$x]) != "") ? $descuento_por_factura[$x] : null,
                                'dov_retencion' => (trim($retencion_factura[$x]) != "") ? $retencion_factura[$x] : null,
                                'dov_descuento' => (trim($descuento_factura[$x]) != "") ? $descuento_factura[$x] : null,
                                'dov_impuesto' => (trim($impuesto_factura[$x]) != "") ? $impuesto_factura[$x] : null,
                                'dov_subtotal' => (trim($subtotal_factura[$x]) != "") ? $subtotal_factura[$x] : null,
                                'dov_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dov_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->actualizar_array('dov_detalle_orden_venta', $detalle_factura, array('dov_id'=>$dov_id_grid[$x]));
                            $dov_id = $dov_id_grid[$x];
                        } else{
                            $detalle_factura = array(
                                'dov_id_orv' => $id,
                                'dov_id_art' => (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null,
                                'dov_id_cva' => (trim($medida_factura[$x]) != "") ? $medida_factura[$x] : null,
                                'dov_id_lip' => $idlip,
                                'dov_id_tpv' => (trim($tipo_venta[$x]) != "") ? $tipo_venta[$x] : null,
                                'dov_descripcion' => (trim($descripcion_factura[$x]) != "") ? $descripcion_factura[$x] : null,
                                'dov_cantidad' => (trim($cantidad_factura[$x]) != "") ? $cantidad_factura[$x] : null,
                                'dov_precio' => (trim($precio_factura[$x]) != "") ? $precio_factura[$x] : null,
                                'dov_precio_sugerido_lista' => trim($precio_sugerido_array[$x]) ? $precio_sugerido_array[$x] : null,
                                'dov_porcentaje_retencion' => (trim($retencion_por_factura[$x]) != "") ? $retencion_por_factura[$x] : null,
                                'dov_porcentaje_impuesto' => (trim($impuesto_por_factura[$x]) != "") ? $impuesto_por_factura[$x] : null,
                                'dov_porcentaje_descuento' => (trim($descuento_por_factura[$x]) != "") ? $descuento_por_factura[$x] : null,
                                'dov_retencion' => (trim($retencion_factura[$x]) != "") ? $retencion_factura[$x] : null,
                                'dov_descuento' => (trim($descuento_factura[$x]) != "") ? $descuento_factura[$x] : null,
                                'dov_impuesto' => (trim($impuesto_factura[$x]) != "") ? $impuesto_factura[$x] : null,
                                'dov_subtotal' => (trim($subtotal_factura[$x]) != "") ? $subtotal_factura[$x] : null,
                                'dov_combo' => (trim($combo_agrupacion[$x]) != "") ? $combo_agrupacion[$x] : null,
                                'dov_estado' => 1,
                                'dov_usu_creacion' => $this->tank_auth->get_user_id(),
                                'dov_fecha_creacion' => date('Y-m-d H:i:s'),
                                'dov_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dov_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $dov_id = $this->gsatelite->ingresar('dov_detalle_orden_venta', $detalle_factura);
                        }
                        //separamos el impuesto de cada producto total y porcentual para almacenarlo en la tabla para el detalle de cada impuesto
                        $impuesto_ids = explode(",", $impuesto_array[$x]);
                        $impuesto_por = explode(",", $impuesto_por_array[$x]);
                        $this->gsatelite->borrado_general("ixv_impuestoxorden_venta", array('ixv_id_dov'=>$dov_id));
                        for ($k = 0; $k < count($impuesto_ids); $k++) {
                            if ($impuesto_ids[$k] != 0) {
                                if (trim($impuesto_por[$k]) != "") {
                                    //hacemos el calculo de el monto aplicado para ese impuesto especifico
                                    $monto_temp = $subtotal_factura[$x] * ($impuesto_por[$k] / 100);
                                    //tabla ixf_impuestoxfactura
                                    $detalle_impuesto = array(
                                        'ixv_id_dov' => $dov_id,
                                        'ixv_id_imp' => (trim($impuesto_ids[$k]) != "") ? $impuesto_ids[$k] : null,
                                        'ixv_monto' => $monto_temp,
                                        'ixv_porcentaje' => $impuesto_por[$k],
                                        'ixv_estado' => 1,
                                        'ixv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'ixv_fecha_modificacion' => date('Y-m-d H:i:s'),
                                        'ixv_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'ixv_usu_creacion' => $this->tank_auth->get_user_id()
                                    );
                                    $this->gsatelite->ingresar('ixv_impuestoxorden_venta', $detalle_impuesto);
                                }
                            }
                        }
                        $retencion_ids = explode(",", $retencion_array[$x]);
                        $retencion_por = explode(",", $retencion_por_array[$x]);
                        $this->gsatelite->borrado_general("rxv_retencionxorden_venta", array('rxv_id_dov'=>$dov_id));
                        for ($k = 0; $k < count($retencion_ids); $k++) {
                            if ($retencion_ids[$k] != 0) {
                                if (trim($retencion_por[$k]) != "") {
                                    $monto_temp = $subtotal_factura[$x] * ($retencion_por[$k] / 100);
                                    //tabla rxf_retencionxdetalle_factura
                                    $detalle_retencion = array(
                                        'rxv_id_dov' => $dov_id,
                                        'rxv_id_ret' => (trim($retencion_ids[$k]) != "") ? $retencion_ids[$k] : null,
                                        'rxv_monto' => $monto_temp,
                                        'rxv_porcentaje' => $retencion_por[$k],
                                        'rxv_estado' => 1,
                                        'rxv_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'rxv_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'rxv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'rxv_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->ingresar('rxv_retencionxorden_venta', $detalle_retencion);
                                }
                            }
                        }
                        /* ==========================================================================
                                    COMPONENTES
                        ==========================================================================*/
                        $identificador = '_'.$productos_factura[$x].'_'.$correlativo[$x];
                        /* para descargar de bodega             type array*/
                        $tipo_estado = $this->input->post('tipo_estado'.$identificador);
                        $descargar_componente = $this->input->post('producto_descargar_componente'.$identificador);
                        $tipo_componente = $this->input->post('producto_tipo_componente'.$identificador);
                        $bodega_componente = $this->input->post('bodega_componente_id'.$identificador); // no es arreglo
                        /* detalle para guardar                 type array*/
                        $producto_componente = ($this->input->post('producto_componente'.$identificador) != '')?$this->input->post('producto_componente'.$identificador):'';
                        $medida_componente = $this->input->post('medida_componente'.$identificador);
                        $cantidad_componente = $this->input->post('cantidad_conv_componente'.$identificador);
                        $precio_componente = $this->input->post('precio_componente'.$identificador);
                        $subtotal_componente = $this->input->post('subtotal_componente'.$identificador);
                        $descripcion_componente = $this->input->post('descripcion_componente'.$identificador);
                        $alternar_componente = $this->input->post('alternar_componente'.$identificador);
                        $mostrar_descripcion_componete = $this->input->post('showdesc_componente'.$identificador);
                        $componentes_reg = $this->gsatelite->get_tabla('cdv_componente_detallexorden_venta', array('cdv_id_dov'=>$dov_id));
                        $fecha_creacion = date('Y-m-d H:i:s');
                        //$componente_up = array();
                        if($tipo_estado != ''){
                            foreach ($componentes_reg as $comp_reg) {
                                if(!in_array($comp_reg['cdv_id'], $tipo_estado)){
                                    $this->gsatelite->borrado_general('cdv_componente_detallexorden_venta', array('cdv_id' => $comp_reg['cdv_id']));
                                } else{
                                    $indice_comp = array_search($comp_reg['cdv_id'], $tipo_estado);
                                    $componente_up = array(
                                        'cdv_descripcion' => $descripcion_componente[$indice_comp],
                                        'cdv_cantidad' => $cantidad_componente[$indice_comp],
                                        'cdv_precio' => $precio_componente[$indice_comp],
                                        'cdv_subtotal' => $subtotal_componente[$indice_comp],
                                        'cdv_total' => $subtotal_componente[$indice_comp],
                                        'cdv_altera_precio' => $alternar_componente[$indice_comp],
                                        'cdv_muestra_descripcion' => $mostrar_descripcion_componete[$indice_comp],
                                        'cdv_estado' => 1,
                                        'cdv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'cdv_fecha_modificacion' =>  $fecha_creacion
                                    );
                                    $this->gsatelite->actualizar_array('cdv_componente_detallexorden_venta', $componente_up, array('cdv_id' => $comp_reg['cdv_id']));
                                }
                            }
                        } else{
                            $this->gsatelite->borrado_general('cdv_componente_detallexorden_venta', array('cdv_id_dov' => $dov_id));
                        }
                        $fecha_creacion = date('Y-m-d H:i:s');
                        $componente_sav = array();
                        if($producto_componente != ''){
                            foreach ($producto_componente as $id_comp => $comp) {
                                if($tipo_estado[$id_comp] == 0){
                                    $componente_sav[] = array(
                                        'cdv_id_dov' => $dov_id,
                                        'cdv_id_cva' => $medida_componente[$id_comp],
                                        'cdv_descripcion' => $descripcion_componente[$id_comp],
                                        'cdv_cantidad' => $cantidad_componente[$id_comp],
                                        'cdv_precio' => $precio_componente[$id_comp],
                                        'cdv_subtotal' => $subtotal_componente[$id_comp],
                                        'cdv_total' => $subtotal_componente[$id_comp],
                                        'cdv_altera_precio' => $alternar_componente[$id_comp],
                                        'cdv_muestra_descripcion' => $mostrar_descripcion_componete[$id_comp],
                                        'cdv_estado' => 1,
                                        'cdv_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'cdv_fecha_creacion' =>  $fecha_creacion,
                                        'cdv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'cdv_fecha_modificacion' =>  $fecha_creacion
                                    );
                                }
                            }
                            if(count($componente_sav) > 0){
                                $this->gsatelite->ingresar('cdv_componente_detallexorden_venta', $componente_sav, true);
                            }
                        }
                        /* ====================================================================================================================
                                    FIN COMPONENTES
                        ======================================================================================================================*/
                        /* ====================================================================================================================
                                    CENTRO COSTO
                        ======================================================================================================================*/                        
                        $this->gsatelite->borrado_general('dcv_detalle_centrocostoxorden_venta', array('dcv_id_dov' => $dov_id));
                        $centro_costo_costo = ($this->input->post('centro_costo_costo'.$identificador) != '')?$this->input->post('centro_costo_costo'.$identificador):'';
                        $tipo_cuenta_costo = $this->input->post('tipo_cuenta_costo'.$identificador);
                        $cuenta_contable_costo = $this->input->post('cuenta_contable_costo'.$identificador);
                        $porcentaje_costo = $this->input->post('porcentaje_costo'.$identificador);
                        $subtotal_costo = $this->input->post('subtotal_costo'.$identificador);
                        $pais_costo = $this->input->post('pais'.$identificador);
                        $costo_sav = array();
                        if($centro_costo_costo != ''){
                            foreach ($centro_costo_costo as $id_cost => $costo) {
                                $costo_sav[] = array(
                                    'dcv_id_dov' => $dov_id,
                                    'dcv_id_cec' => $centro_costo_costo[$id_cost],
                                    'dcv_id_tcn' => $tipo_cuenta_costo[$id_cost],
                                    'dcv_id_cnt' => $cuenta_contable_costo[$id_cost],
                                    'dcv_id_pai' => ($pais_costo[$id_cost] != "")?$pais_costo[$id_cost]:null,
                                    'dcv_porcentaje' => $porcentaje_costo[$id_cost],
                                    'dcv_monto' => $subtotal_costo[$id_cost],
                                    'dcv_estado' => 1,  
                                    'dcv_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'dcv_fecha_creacion' =>  $fecha_creacion,
                                    'dcv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'dcv_fecha_modificacion' =>  $fecha_creacion
                                );
                            }
                            $this->gsatelite->ingresar('dcv_detalle_centrocostoxorden_venta', $costo_sav, true);
                        }
                    }
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de orden de venta", 'texto_alerta' => "El registro se guardó correctamente.");
            } else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de orden de venta", 'texto_alerta' => "El registro no se guardó, revise la información a ingresar.");
            }
            $redireccion = $this->input->post('redireccionar');
            $this->session->set_flashdata($alerta);
            //$this->session->set_flashdata('id_orden_venta', $orv_id);
            if ($redireccion == 0) {
                redirect('modulo_medico/med_procesos/editar_cuenta/'.$id);
            } else if ($redireccion == 1) {
                redirect('modulo_medico/med_procesos/cuenta_paciente/');
            }
            exit();die();
        }
        $datos["titulo_personal"] = "Editar Cuenta de Paciente";
        $orv_id = $id;
        $orden_venta_datos = $this->gsatelite->get_tabla('orv_orden_venta', array('orv_id' => $orv_id));
        /* =============    CARGA DE DATOS      ===========*/
        $datos['datos_orden'] = $orden_venta_datos[0];
        $datos['orv_id'] = $orv_id;
        $tipos_pago = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => '1'), $orden_venta_datos[0]['orv_condicion_pago'], '', 'tpg_id', true);
        $datos['tipos_pago'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipos_pago);
        //  regresa datos de parametro
        $permite_mas_productos = $this->gsatelite->get_parametro('SYS_PERMITE_DUPLICAR_PRODUCTO');
        $datos['permite_mas_productos'] = (trim($permite_mas_productos) != '')?$permite_mas_productos:0;
        //  regresa el cliente
        $cliente_array = $this->gsatelite->get_tabla('cli_cliente');
        $cliente_drop = "";
        foreach ($cliente_array as $key) {
            $selected_cli = '';
            $estado_cli = 0;
            if($key['cli_id'] == $orden_venta_datos[0]['orv_id_cli']){
                $selected_cli = 'selected';
                $estado_cli = 1;
            } else if($key['cli_estado'] == 1){
                $estado_cli = 1;
            }
            if($estado_cli == 1){
                $cliente_temp = ($key["cli_personeria"] == 1)?($key["cli_codigo"]." - ".$key["cli_nombre"]." ".$key["cli_apellido"]):$key["cli_codigo"]." - ".$key["cli_apellido"];
                $cliente_drop .= '<option value="'.$key['cli_id'].'" '.$selected_cli.'>'.$cliente_temp.'</option>';
            }
        }
        $datos["cliente"] = $cliente_drop;

        $id     =   $orden_venta_datos[0]['orv_id_pgp'];
        $where['pgp_id'] = $id;
        $group_by        = "pgp_id";
        
        $row     = $this->medico_model->get_procedimiento_quirurgico($where,$group_by);
        $opc     = '<option></option>';  
        
        foreach ($row as $key => $valor) {
           if ($valor['pgp_id'] == $id) {
               $opc .= '<option selected data-procedure="'.$valor['pcm_id'].'" value="'.$valor['pcm_id'].'">'.$valor['pcm_nombre'].'</option>';
           }else{
               $opc .= '<option data-procedure="'.$valor['pcm_id'].'" value="'.$valor['pcm_id'].'">'.$valor['pcm_nombre'].'</option>';
           }
        }  

        $datos['opcx'] = $opc;
    

        //  regresa las areas
        $arf_defecto = $this->gsatelite->get_campo('arf_area_factura', 'arf_id', array('arf_defecto'=> 1, 'arf_estado'=> 1));
        $area_drop = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}', '', array('arf_estado' => '1'), $arf_defecto, '', 'arf_id', true);
        $datos["area"] = str_replace('<option value="0">Seleccione</option>', '', $area_drop);
        //por si esta el valor de la orden de venta, si no se carga el area por defecto
        $valor = $orden_venta_datos[0]['orv_id_arf'] != "" ? $orden_venta_datos[0]['orv_id_arf'] : $arf_defecto;
        $area_drop = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}', '', array('arf_estado' => '1'),  $valor, '', 'arf_id', true);
        $datos["area"] = str_replace('<option value="0">Seleccione</option>', '', $area_drop);
        //  regresa los empleados
        $personalxorden_array = $this->gsatelite->get_tabla('pxo_personalxorden_venta', array('pxo_id_orv' => $orv_id));
        //tabla de la relacion entre el empleado y la orden de venta
        $pxo_id_emp = array(); //guardaremos los ids de los empleado
        foreach ($personalxorden_array as $key) {
            $pxo_id_emp[] = $key['pxo_id_emp'];
        }
        $empleados_drop = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), $pxo_id_emp, '', 'emp_id', true);
        $datos["empleados"] = str_replace('<option value="0">Seleccione</option>', '', $empleados_drop);
        //  fin regresa los empleados
        $vendedores_select = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => '1'), $orden_venta_datos[0]['orv_id_ven'], '', 'ven_id', true);
        $datos["vendedores"] = str_replace('<option value="0">Seleccione</option>', '', $vendedores_select);
        //  regresa las categorias de los productos
        $datos["categorias"] = $this->obtener_categoriaxbodega2();
        $select = "";
        $tip_venta_reg = $this->gsatelite->get_tabla('tpv_tipo_venta', array('tpv_estado' => 1, 'tpv_aplica_venta' => 1));
        foreach ($tip_venta_reg as $key) {
            $select .= '<option value="' . $key['tpv_id'] . '" abrv="' . $key['tpv_abreviacion'] . '">' . $key['tpv_nombre'] . '-' . $key['tpv_abreviacion'] . '</option>';
        }
        $datos["tipo_venta"] = $select;
        //$data["detalle_orden"] = $this->gsatelite->get_tabla('dov_detalle_orden_venta', array('dov_id_orv' => $orv_id));
        $data_grid['detalle_orden'] = $this->facturacion_model->get_detalle_orden_venta(array('dov_id_orv' =>$orv_id));
        
        $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $data_grid['decimales'] = ($decimales != '')?$decimales:2;
        $datos['decimales'] = ($decimales != '')?$decimales:2;
        $data_grid['cliente'] = $orden_venta_datos[0]['orv_id_cli'];
        $datos["limite_credito"] = $this->gsatelite->get_campo('cli_cliente', 'cli_monto_credito', array('cli_id' => $orden_venta_datos[0]['orv_id_cli']));
        $datos["html"] = $this->load->view('modulo_medico/med_procesos/grid_cuenta', $data_grid, true);
        //print_r( $datos["html"] ); die();
        $datos["cliente_defecto"] = $this->gsatelite->get_parametro('SYS_CLIENTE_DEFECTO');
        $tiene_lista = 0;
        foreach ($data_grid['detalle_orden'] as $key) {
            $id_tlp = $key['lip_id_tlp'];
            $tiene_lista += (trim($id_tlp) != '')?1:0;
        }
        $datos['tiene_lista'] = $tiene_lista;
        $user=$this->tank_auth->get_user_id();
        $bodegas_reg = $this->facturacion_model->bodegas_cliente(array('uxb_id_usu'=>$user));
        $select = "";
        foreach ($bodegas_reg as $key) {
            $selected = ($key['uxb_defecto'] == 1)?'selected':'';
            $select .= '<option value="'.$key['bod_id'].'" '.$selected.'>'.$key['bod_nombre'].'</option>';
        }
        $datos["bodega_prefe"] = $select;
        $this->_cargarvista($datos, null);
    }


    /**
     * @autor Habby Lovo
     * @since 09/02/2018
     *
     * @description : Nos obtiene la grid de componentes con los detalles.
    */
    public function obtener_componente_edit($producto, $correlativo, $dov_id, $cliente, $bodega = null, $tipo = 1, $productos_valid_array = array()){
        //$this->load->library('../controllers/facturacion/facturar');
        //$correlativo = ($this->input->post('correlativo') != '')?$this->input->post('correlativo'):null;
        //$producto = ($this->input->post('producto') != '')?$this->input->post('producto'):null;
        // lista de precio
        $id_tipl = 0;
        $data_grid['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
        $tipos_lista2 = $this->inventario_model->get_tipo_lista_precio(array('tpn_id_cli' => $cliente));
        $select_tipo_lista_cliente = "<option value=''></option>";
        foreach ($tipos_lista2 as $key => $value) {
            if($key == 0){
                $select_tipo_lista_cliente .= "<option data-des_min=". $value["lip_descuento_min"] ." data-des_max=". $value["lip_descuento_max"] ." data-tlp=" . $value["tlp_id"] . " value=" . $value["tlp_id"] . " selected>" . $value["tlp_nombre"] . "</option>";
                $id_tipl = $value["tlp_id"];
            }else{
                $select_tipo_lista_cliente .= "<option data-des_min=". $value["lip_descuento_min"] ." data-des_max=". $value["lip_descuento_max"] ." data-tlp=" . $value["tlp_id"] . " value=" . $value["tlp_id"] . ">" . $value["tlp_nombre"] . "</option>";
            }
        }
        //carga la grid de componentes
        $html = '';
        //if($correlativo != null && $correlativo >= 0){
        if($correlativo > -1){
            $data_grid['bodega_nombre'] = '';
            $data_grid['bodega_id'] = '';
            if($bodega != null){
                $bodega_reg = $this->gsatelite->get_tabla('bod_bodega', array('bod_id'=>$bodega));
                $data_grid['bodega_nombre'] = $bodega_reg[0]['bod_nombre'];
                $data_grid['bodega_id'] = $bodega;
            }
            $data_grid['detalles_validar'] = $productos_valid_array;

            $data_grid['ident'] = "_".$producto."_".$correlativo;
            $data_grid['correlativo'] = $correlativo;
            $data_grid['producto'] = $producto;
            $data_grid['lista_id'] = $id_tipl;
            $data_grid['lista_cliente'] = $select_tipo_lista_cliente;
            $data_grid['productos'] = $this->gsatelite->get_tabla('art_articulo', array('art_componente'=>1, 'art_estado'=>1));
            if($tipo == 1){
                $data_grid['componentes'] = $this->facturacion_model->get_componente_orden_venta(array('cdv_id_dov'=>$dov_id));
            } else if($tipo == 2) {
                $data_grid['componentes'] = $this->facturacion_model->get_componente_factura(array('cdf_id_def'=>$dov_id));
            } else {
                $this->load->model('cotizaciones_model');
                $data_grid['componentes'] = $this->cotizaciones_model->get_componente_cotizacion(array('cdc_id_axc'=>$dov_id));
            }
            $html = $this->load->view('facturacion/facturar/grid_componentes', $data_grid, true);
        }
        $json_validar = explode('%%%%%%%', $html);
        $arreglo_valid = json_decode(str_replace(array(' ','</div>'), '', $json_validar[1]), true);
        $html = str_replace('<div style="display: none;" id="json">', '', $json_validar[0]);
        return array('html'=>$html,'componente_validar'=>(array)$arreglo_valid);
    }   

    public function get_procedimientos(){
        satelite_validar();
        $cliente = $this->input->post('cliente');
        $row     = $this->gsatelite->get_tabla('epp_expediente_paciente',array('epp_id_cli' => $cliente));
        $exp_id  = $row[0]['epp_id'];
        
        $where['pgp_id_epp'] = $exp_id;
        $group_by           = "pgp_id";

        $row     = $this->medico_model->get_procedimiento_quirurgico($where,$group_by);
        $opc     = '<option></option>';  
        foreach ($row as $key => $valor) {
            $opc .= '<option data-procedure="'.$valor['pcm_id'].'" value="'.$valor['pcm_id'].'">'.$valor['pcm_nombre'].'</option>';
        }

        echo json_encode(array('options'=>$opc)); die();




    }

    /**
     * Descripción:
     * Busca campso para la seleccion en ajax 
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2020-08-03
     * @param  Ninguno
     * @return modal
     */
    public function get_campos_like($tabla){
        satelite_validar();
        $caracteristica = $this->input->post('categoria');
        $campo = $this->input->post('campo');
        // $this->db->like("CONCAT_WS(' ', epp_numero_expediente, epp_nombre, epp_apellido)", $where);
        $where["$campo LIKE '%$caracteristica%'"] = null;

        $detalle_campo = $this->gsatelite->get_tabla($tabla,$where);

        echo json_encode($detalle_campo);

    }

    /**
     * Descripción:
     * Busca medicos para la seleccion en ajax 
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2020-08-03
     * @param  Ninguno
     * @return modal
     */
    public function get_medico_like(){
        satelite_validar();
        $caracteristica = $this->input->post('categoria');
        $campo = $this->input->post('campo');
        $where["$campo LIKE '%$caracteristica%'"] = null;
                         $this->db->join("tmd_tipo_medico","med_id_tmd = tmd_id");
        $detalle_campo = $this->gsatelite->get_tabla("med_medico",$where);
        echo json_encode($detalle_campo);
    }

    /**
     * Descripción:
     * Función para imprimir constancia/incapacidad
     * @author René Castaneda
     * @since  2021-07-17
     */

    public function imprimir_constancia($id_cnm = null){
        satelite_validar();
        $this->load->library('EnLetras');
        $id_cnm = ($id_cnm != null) ? $id_cnm : $this->input->post('id_cnm');
        if ($id_cnm != '') {
            $where["cnm_id"] = $id_cnm;
        }
        if (isset($where)) {
            $data['consultas'] = $this->medico_model->informacion_consulta($where);
        }
        $firma = $this->gsatelite->get_parametro('SYS_FIRMA_CONSTANCIA'); //////////////////////////////////////PARAMETRIZAR  ////****/////
        $html = $this->load->view('modulo_medico/med_procesos/imprimir_constancia', $data, true);
        $this->load->library('pdf');
        $html_footer = '<table style=" padding-left: 10px!important; " width="100%">
                    <tr><td align="right">'.$firma.'<br /><br /><br /></td></tr>
                    <tr><td>Próxima cita: _______________________________________<br /></td></tr>
                    <tr><td><hr color="blue" size=3></td></tr>
                    <tr>
                        <td align="center"><h4>'.$this->gsatelite->get_parametro('SYS_EMPRESA').'</h4></td>
                    </tr>
                    </table>';
        $this->pdf->setPrintHeader(false);
        $this->pdf->SetFont("helvetica");
        $this->pdf->SetAutoPageBreak(true, 0);
        $this->pdf->SetMargins(10,0,10); //274, 155
        $this->pdf->AddPage('P', 'Letter', array(
            'family' => "helvetica",
            'style' => '',
            'size' => 6) , true
        );
        $this->pdf->setPrintFooter(false);
        $this->pdf->writeHTML($html, true, false, false, false, '');
        // Posisionamieto a -50 mm del eje y
        $this->pdf->SetY(-50);
                // Numero de pagina
        $this->pdf->writeHTML($html_footer, true, 0, true, true, '');
        $this->pdf->SetTitle('Constancias Médicas');
        $this->pdf->boletaPDF('I');
    }

    /**
     * Descripción:
     * Función para imprimir consulta
     * @author René Castaneda
     * @since  2021-07-17
     */
    public function imprimir_consulta($id_consulta = null) {
        satelite_validar();
        $consultas = $this->medico_model->informacion_consulta(array('cnm_id' => $id_consulta));
        $paciente = $this->medico_model->get_tabla_expediente_paciente(array('epp_id' => $consultas[0]['epp_id']));
        $data['paciente'] = $paciente[0];
        $data['consulta'] = $consultas[0];
        // var_dump($consultas); die();
        $this->load->library('pdf');
        $html  = $this->load->view('reporte/header', array('titulo' => 'Historial de consulta',"solotitulo"=>1), true);
        $html .= $this->load->view('modulo_medico/med_procesos/imprimir_consulta', $data, true);       
        $reporte=$this->pdf->makePDF($html);
    }

    public function notas_seguimiento($id_cita){
        satelite_validar();
                        $this->db->order_by('sgt_fecha_creacion DESC');
                        $this->db->join('cim_cita_medica', 'cim_id = sgt_id_cim');
                        $this->db->join('epp_expediente_paciente', 'epp_id = cim_id_epp');
        $seguimientos = $this->gsatelite->get_tabla('sgt_seguimiento_cita', array('sgt_estado' => 1, 'sgt_id_cim' => $id_cita));
        $data['seguimientos'] = $seguimientos;
        $data['titulo_personal'] = 'Seguimimentos realizados';
        $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_procesos/ver_seguimientos',$data);
    }

    public function anexos_seguimiento($id){
        $data['anexo'] = $this->gsatelite->get_tabla("apa_anexo_paciente", array("apa_id_epp" => $id));
        $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_procesos/cita_anexos',$data); 
    }

    /**
     * OPCIONES GROCERY DE AGREGAR
    */
    public function add_especialidad() {
        satelite_validar();
        $crud = new grocery_CRUD();
        $columns = array('epm_nombre','epm_descripcion','epm_estado');
        $alias = array('epm_nombre' => 'Nombre','epm_descripcion' => 'Descripcion','epm_estado' => 'Estado');
        $add_fields = array('epm_nombre','epm_descripcion','epm_estado','epm_usu_creacion','epm_fecha_creacion','epm_usu_modificacion','epm_fecha_modificacion');
        $crud->set_table('epm_especialidad_medica')->set_subject('')->add_fields($add_fields)->columns($columns)->display_as($alias)->required_fields('epm_nombre');
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('epm_estado', 'hidden', 1);
        } else {
            $crud->field_type('epm_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $crud->field_type('epm_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('epm_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('epm_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('epm_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->unset_edit()->unset_delete()->unset_read()->unset_print()->unset_export();
        $output = $crud->render();
        $data['modal'] = 1;
        $data['titulo_personal'] = "Especialidades";
        $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_mantenimientos/especialidad', $data, $output);
    }
    public function add_procedimiento() {
        satelite_validar();
        $crud = new grocery_CRUD();
        $columns = array('pcm_nombre','pcm_duraccion_aprox','pcm_descripcion','pcm_estado');
        $alias = array('pcm_nombre' => 'Nombre','pcm_duraccion_aprox' => 'Duración apróximada','pcm_descripcion' => 'Descripción', 'pcm_estado' => 'Estado');     
        $add_fields = array('pcm_nombre','pcm_duraccion_aprox','pcm_descripcion','pcm_estado','pcm_usu_creacion','pcm_fecha_creacion','pcm_usu_modificacion','pcm_fecha_modificacion');
        $required = array('pcm_nombre','pcm_duraccion_aprox','pcm_estado','pcm_usu_modificacion','pcm_fecha_modificacion');
        $crud->set_table('pcm_procedimiento_medico')->set_subject('')->add_fields($add_fields)->columns($columns)->display_as($alias)->required_fields($required);
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('pcm_estado', 'hidden', 1);
        } else {
            $crud->field_type('pcm_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $crud->field_type('pcm_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('pcm_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('pcm_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('pcm_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->unset_edit()->unset_delete()->unset_read()->unset_print()->unset_export();
        $output = $crud->render();
        $data['modal'] = 1;
        $data['titulo_personal'] = 'Tipo de procedimientos';
        $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_mantenimientos/tipo_procedimiento',$data,$output);
    }
    public function add_medico() {
        satelite_validar();        
        $crud = new grocery_CRUD();
        $columns = array('med_nombre','med_descripcion','med_id_epm','med_id_tmd','med_telefono','med_estado');
        $alias = array('med_nombre' => 'Nombre','med_descripcion'  => 'Descripcion','med_id_epm'  => 'Especialidad','med_id_tmd' => 'Tipo','med_telefono' => 'Telefono','med_estado'=> 'Estado','med_direccion' => 'Direccion','med_correo' => 'Correo','med_numero_jvpm' => 'No. JVPM');
        $add = array('med_nombre','med_descripcion','med_id_epm','med_id_tmd','med_telefono','med_estado','med_direccion','med_correo','med_numero_jvpm','med_usu_creacion','med_fecha_creacion','med_usu_modificacion','med_fecha_modificacion');
        $crud->set_table('med_medico')->set_subject('')->add_fields($add)->columns($columns)->display_as($alias)->required_fields('med_nombre','med_id_epm','med_id_tmd');
        $crud->set_relation('med_id_epm', 'epm_especialidad_medica', 'epm_nombre', array('epm_estado'=>1))->set_relation('med_id_tmd', 'tmd_tipo_medico', 'tmd_nombre', array('tmd_estado'=>1));
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('med_estado','hidden', 1)->field_type('med_usu_creacion', 'hidden', $this->tank_auth->get_user_id())->field_type('med_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $crud->field_type('med_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $crud->field_type('med_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())->field_type('med_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
        ->callback_field('med_telefono', function($value, $primary_key) {
            return '<input type="text" class="nostyle " id="telefono" name="med_telefono" value="'.$value.'">';
        })
        ->callback_field('med_numero_jvpm', function($value, $primary_key) {
            return '<input type="text" class="nostyle soloNumeros" name="med_numero_jvpm" value="'.$value.'">';
        });
        $crud->unset_edit()->unset_delete()->unset_read()->unset_print()->unset_export();
        $output = $crud->render();
        $data['titulo_personal'] = "Medico";
        $data['modal'] = 1;
        $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_mantenimientos/medico',$data,$output);
    }

    /**
     * Descripción:
     * Vista principal de clasificacion de pacientes segun nivel de emergencia
     * @author Eduardo Mejia - Grupo Satélite
     * @since  2024-06-24
     * @return view
     */
    public function clasificacion_paciente(){
        satelite_validar();  
        $permisos = $this->gsatelite->get_permisos_opcion();
        $userId = $this->tank_auth->get_user_id();
        $data = [];

        $usc_usuario_sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $userId));
        $whereSlcSucursal = null;
        $selectedSucursal = null;

        // Se obtendran solo las sucursales que tenga asignado el usuario
        // Si no tiene asignada sucursal se mostraran todas las sucursales
        if (count($usc_usuario_sucursal) > 0) {
            $sucursalesId = array_column($usc_usuario_sucursal, 'usc_id_suc');
            $sucursalesId = implode(',', $sucursalesId);

            // Si solo es un registro se selecciona por defecto
            if (count($usc_usuario_sucursal) == 1) {
                $selectedSucursal = $sucursalesId;
            }

            $whereSlcSucursal["suc_id IN ({$sucursalesId})"] = null;
        }

        $data['slcUbicacion'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', $whereSlcSucursal, $selectedSucursal, '', 'suc_id', true);
        $data['titulo_personal'] = "Clasifiación de Paciente";
        $data['permisos'] = $permisos;
        cargarvista($data);
    }

    /**
     * Descripción:
     * Grid de clasificacion paciente
     * Si es consulta = 1, se muestran opciones para el medico que realizara la consulta
     * @param $esConsulta int 
     * @author Eduardo Mejia - Grupo Satélite
     * @since  2024-06-24
     * @return 
     */
    public function grid_clasificacion_paciente($idConsultorio = null){
        $postData = $this->input->post();
        $slcUbicacion = isset($postData['slcUbicacion']) ? $postData['slcUbicacion'] : ''; // Este campo no se envia en vista llamar_paciente
        $slcEstado = $postData['slcEstado'];
        $txtFecha_desde = $postData['txtFecha_desde'];
        $txtFecha_hasta = $postData['txtFecha_hasta'];

        $where = [];
        $where['clp_estado'] = 1;
        if ($slcUbicacion > 0) {
            $where['suc_id'] = $slcUbicacion;
        }

        if ($slcEstado != '') {
            $where['clp_estado_consulta'] = $slcEstado;
        }

        if ($txtFecha_desde != '') {
            $where['date_format(clp_fecha,"%Y-%m-%d")>='] = date_format(date_create($txtFecha_desde),'Y-m-d');
        }

        if ($txtFecha_hasta != '') {
            $where['date_format(clp_fecha,"%Y-%m-%d")<='] = date_format(date_create($txtFecha_hasta),'Y-m-d'); 
        }


        if ($idConsultorio) {
        // Consultar si tiene pacientes en consulta pasarlos a pendiente
                        $this->db->join('clp_clasificacion_paciente', 'clp_id = cxc_id_clp');
            $pacientes = $this->gsatelite->get_tabla('cxc_clasificacion_pacientexconsultorio', ['cxc_id_con' => $idConsultorio, 'cxc_estado' => 1, 'clp_estado_consulta' => 2]);
            $clp_ids = array_column($pacientes, 'clp_id');
            $clp_ids = (implode(',', $clp_ids) != "") ? implode(',', $clp_ids) : 0;

            $cxc_ids = array_column($pacientes, 'cxc_id');
            $cxc_ids = (implode(',', $cxc_ids) != "") ? implode(',', $cxc_ids) : 0;
            if ($cxc_ids != 0 && $clp_ids != 0) {
                $this->gsatelite->actualizar_array('clp_clasificacion_paciente', ['clp_estado_consulta' => 1], ["clp_id IN ({$clp_ids})" => null]);
                $this->gsatelite->borrado_general('cxc_clasificacion_pacientexconsultorio', ["cxc_id IN ($cxc_ids)" => null]);
            }

            $clasificacionEmergenciaxConsultorio = $this->gsatelite->get_tabla('cxc_clasificacion_emergenciaxconsultorio', ['cxc_id_con' => $idConsultorio]);
            $idsClasificacionEmergencia = array_column($clasificacionEmergenciaxConsultorio, 'cxc_id_cle'); 
            if (count($idsClasificacionEmergencia) > 0) {
                $ids = implode(',', $idsClasificacionEmergencia);
                $where["cle_id IN ({$ids})"] = null;
                // $where["clp_estado_consulta != 3"] = null;
            }           

            $tipoConsultaxConsultorio = $this->gsatelite->get_tabla('txc_tipo_consultaxconsultorio', ['txc_id_con' => $idConsultorio]);
            $idsTipoConsulta = array_column($tipoConsultaxConsultorio, 'txc_id_tcm'); 
            if (count($idsTipoConsulta) > 0) {
                $ids_ = implode(',', $idsTipoConsulta);
                $where["tcm_id IN ({$ids_})"] = null;
                // $where["clp_estado_consulta != 3"] = null;
            }  

            $consultorio = $this->gsatelite->get_tabla('con_consultorio', ['con_id' => $idConsultorio]);
            if (count($consultorio) > 0) {
                $where['suc_id'] = $consultorio[0]['con_id_suc'];

            }
        }
        $registros = $this->medico_model->clasificacion_paciente($where);

        $data = [];
        $data['registros'] = $registros;
        $data['idConsultorio'] = $idConsultorio;
        $html = $this->load->view('modulo_medico/med_procesos/grid_clasificacion_paciente', $data, true);   
        echo $html;
        die();
    }

    /**
     * Descripción:
     * Ingresar paciente en la clasificacion triage
     * @author Eduardo Mejia - Grupo Satélite
     * @since  2024-06-24
     * @return 
     */
    public function ingreso_paciente(){
        satelite_validar();  
        // $permisos = $this->gsatelite->get_permisos_opcion();    
        $userId = $this->tank_auth->get_user_id();
        if ($this->input->post()){
            $postData = $this->input->post();
            $slcFilPaciente = $postData['slcFilPaciente'];
            $slcUbicacion = $postData['slcUbicacion'];
            $slcClasificacionEmergencia = $postData['slcClasificacionEmergencia'];
            $slcTipoConsulta = $postData['slcTipoConsulta'];
            $slcMotivoEmergencia = ($postData['slcMotivoEmergencia'] > 0) ? $postData['slcMotivoEmergencia'] : null;
            $txtDetalleMotivoEmergencia = ($postData['txtDetalleMotivoEmergencia'] != '') ? $postData['txtDetalleMotivoEmergencia'] : null;
            $redireccion = $postData['redireccion'];

            $insert = [
                'clp_id_epp' => $slcFilPaciente,
                'clp_id_cle' => $slcClasificacionEmergencia,
                'clp_id_suc' => $slcUbicacion,
                'clp_fecha' => date('Y-m-d H:i:s'),
                'clp_estado_consulta' => 1,
                'clp_es_referido' => 0,
                'clp_id_tcm' => $slcTipoConsulta,
                'clp_id_mem' => $slcMotivoEmergencia,
                'clp_detalle_emergencia' => $txtDetalleMotivoEmergencia,
                'clp_estado' => 1,
                'clp_usu_creacion' => $userId,
                'clp_fecha_creacion' => date('Y-m-d H:i:s'),
                'clp_usu_modificacion' => $userId,
                'clp_fecha_modificacion' => date('Y-m-d H:i:s'),
            ];

            $idClasificacionPaciente = $this->gsatelite->ingresar('clp_clasificacion_paciente', $insert);
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Paciente", 'texto_alerta' => "El registro se guardó correctamente.");

            $this->session->set_flashdata($alerta);

            if ($redireccion == 0) {
                redirect('modulo_medico/med_procesos/ingreso_paciente');
            } else if ($redireccion == 1) {
                redirect('modulo_medico/med_procesos/clasificacion_paciente');
            }
            
            die();            

        } else {
            $usc_usuario_sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $userId));
            $whereSlcSucursal = null;
            $selectedSucursal = null;

            // Se obtendran solo las sucursales que tenga asignado el usuario
            // Si no tiene asignada sucursal se mostraran todas las sucursales
            if (count($usc_usuario_sucursal) > 0) {
                $sucursalesId = array_column($usc_usuario_sucursal, 'usc_id_suc');
                $sucursalesId = implode(',', $sucursalesId);

                // Si solo es un registro se selecciona por defecto
                if (count($usc_usuario_sucursal) == 1) {
                    $selectedSucursal = $sucursalesId;
                }

                $whereSlcSucursal["suc_id IN ({$sucursalesId})"] = null;
            }

            $select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', $whereSlcSucursal, $selectedSucursal, '', 'suc_id', true);     
            $data['slcUbicacion'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            $select = $this->gsatelite->get_dropdown('cle_clasificacion_emergencia', '{cle_nombre}', '', null, null, '', 'cle_id', true);     
            $data['slcClasificacionEmergencia'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select); 

            $select = $this->gsatelite->get_dropdown('mem_motivo_emergencia', '{mem_motivo}', '', ['mem_estado' => 1], null, '', 'mem_id', true);     
            $data['slcMotivoEmergencia'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select); 

            $tipoConsultaEmergencia = $this->gsatelite->get_parametro('SYS_TIPO_CONSULTA_EMERGENCIA');
            $tipo_consulta = $this->gsatelite->get_dropdown('tcm_tipo_consulta_medica', '{tcm_nombre}', '', '', $tipoConsultaEmergencia, '', 'tcm_id', true);
            $tipo_consulta = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $tipo_consulta); 
            $data['slcTipoConsulta']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_consulta);
            $data['titulo_personal'] = "Ingreso paciente";
            cargarvista($data);

        }
    }

    /**
     * Descripción:
     * Editar paciente en la clasificacion triage
     * @author Eduardo Mejia - Grupo Satélite
     * @since  2024-06-24
     * @return 
     */
    public function editar_ingreso_paciente($idClasificacionPaciente, $esVer = 0){
        $userId = $this->tank_auth->get_user_id();

        if ($this->input->post()){
            $postData = $this->input->post();
            $slcUbicacion = $postData['slcUbicacion'];
            $slcClasificacionEmergencia = $postData['slcClasificacionEmergencia'];
            $slcTipoConsulta = $postData['slcTipoConsulta'];
            $slcMotivoEmergencia = ($postData['slcMotivoEmergencia'] > 0) ? $postData['slcMotivoEmergencia'] : null;
            $txtDetalleMotivoEmergencia = ($postData['txtDetalleMotivoEmergencia'] != '') ? $postData['txtDetalleMotivoEmergencia'] : null;

            $redireccion = $postData['redireccion'];

            $update = [
                'clp_id_cle' => $slcClasificacionEmergencia,
                'clp_id_suc' => $slcUbicacion,
                'clp_id_tcm' => $slcTipoConsulta,
                'clp_id_mem' => $slcMotivoEmergencia,
                'clp_detalle_emergencia' => $txtDetalleMotivoEmergencia,                
                'clp_usu_modificacion' => $userId,
                'clp_fecha_modificacion' => date('Y-m-d H:i:s'),
            ];


            $where = [
                'clp_id' => $idClasificacionPaciente 
            ];

            $flagUpdate = $this->gsatelite->actualizar_array('clp_clasificacion_paciente', $update, $where);
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Paciente", 'texto_alerta' => "El registro se actualizó correctamente.");

            $this->session->set_flashdata($alerta);

            if ($redireccion == 0) {
                redirect('modulo_medico/med_procesos/editar_ingreso_paciente/' . $idClasificacionPaciente);
            } else if ($redireccion == 1) {
                redirect('modulo_medico/med_procesos/clasificacion_paciente');
            }
            
            die();             
        } else {
            $where = [];
            $where['clp_id'] = $idClasificacionPaciente;
            $result = $this->medico_model->clasificacion_paciente($where);
            $registro = $result[0];
            $data['registro'] = $registro;

            $usc_usuario_sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $userId));
            $whereSlcSucursal = null;
            $selectedSucursal = null;

            // Se obtendran solo las sucursales que tenga asignado el usuario
            // Si no tiene asignada sucursal se mostraran todas las sucursales
            if (count($usc_usuario_sucursal) > 0) {
                $sucursalesId = array_column($usc_usuario_sucursal, 'usc_id_suc');
                $sucursalesId = implode(',', $sucursalesId);

                // Si solo es un registro se selecciona por defecto
                if (count($usc_usuario_sucursal) == 1) {
                    $selectedSucursal = $sucursalesId;
                }

                $whereSlcSucursal["suc_id IN ({$sucursalesId})"] = null;
            }

            $select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', $whereSlcSucursal, $registro['suc_id'], '', 'suc_id', true);     
            $data['slcUbicacion'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            $select = $this->gsatelite->get_dropdown('cle_clasificacion_emergencia', '{cle_nombre}', '', null, $registro['cle_id'], '', 'cle_id', true);     
            $data['slcClasificacionEmergencia'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);              

            $select = $this->gsatelite->get_dropdown('mem_motivo_emergencia', '{mem_motivo}', '', null, $registro['mem_id'], '', 'mem_id', true);     
            $data['slcMotivoEmergencia'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);    

            $tipo_consulta = $this->gsatelite->get_dropdown('tcm_tipo_consulta_medica', '{tcm_nombre}', '', '', $registro['clp_id_tcm'], '', 'tcm_id', true);
            $tipo_consulta = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $tipo_consulta); 
            $data['slcTipoConsulta']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_consulta); 

            $data['esVer'] = $esVer;   
            $data['titulo_personal'] = ($esVer) ? "Ver ingreso paciente" : "Editar ingreso paciente";


            cargarvista($data, 0, 'modulo_medico/med_procesos/editar_ingreso_paciente');
        }
    }

    /**
     * Descripción:
     * Ver paciente en la clasificacion triage
     * @author Eduardo Mejia - Grupo Satélite
     * @since  2024-06-24
     * @return 
     */
    public function ver_ingreso_paciente($idClasificacionPaciente){
        return $this->editar_ingreso_paciente($idClasificacionPaciente, 1);
    }

    /**
     * Descripción:
     * Cambia a estado 0 el paciente de planificacion triage
     * @author Eduardo Mejia - Grupo Satélite
     * @since  2024-06-24
     * @return 
     */
    public function borrar_ingreso_paciente($idClasificacionPaciente){
        $userId = $this->tank_auth->get_user_id();
        $respuesta = true;
        $update = [
            'clp_estado' => 0,
            'clp_usu_modificacion' => $userId,
            'clp_fecha_modificacion' => date('Y-m-d H:i:s')
        ];

        $where = [
            'clp_id' => $idClasificacionPaciente 
        ];

        $flagUpdate = $this->gsatelite->actualizar_array('clp_clasificacion_paciente', $update, $where);

        // Si tiene cita relacionada pasar a estado 0 
        $existeRegistro = $this->gsatelite->get_tabla('clp_clasificacion_paciente', ['clp_id' => $idClasificacionPaciente, 'clp_estado' => 1]);
        $registro = !empty($existeRegistro) ? $existeRegistro[0] : null;
        if (!is_null($registro['clp_id_cim'])) {


        }



        if (!$flagUpdate) { 
            $respuesta = false;
        } 
        echo json_encode(array('respuesta' => $respuesta));
        die();
    } 

       public function consultorio() {
        // El usuario debe estar asignado a un medico
        // El medico debe tener asignado un consultorio
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $userId = $this->tank_auth->get_user_id();
                            $this->db->join('con_consultorio', 'con_id_med = med_id');
        $medicoConsultorio = $this->gsatelite->get_tabla('med_medico', ['med_id_usu' => $userId, 'med_estado' => 1]);

        if (empty($medicoConsultorio)) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Consultorio", 'texto_alerta' => "El usuario no tiene médico asignado.");
            $this->session->set_flashdata($alerta);
            redirect('modulo_medico/index');
        }

        $idConsultorio = $medicoConsultorio[0]['con_id'];

        $data['permisos'] = $permisos;
        $data['idConsultorio'] = $idConsultorio;

        cargarvista($data, 0,'modulo_medico/med_procesos/llamar_paciente');        

    }

    public function clasificacionPacientexConsultorio(){
        $asignado = false;
        $exito = 0;
        $asignado = 0;

        $idConsultorio = $this->input->post('idConsultorio');
        $idClasificacionPaciente = $this->input->post('idClasificacionPaciente');

        $existeRegistro = $this->gsatelite->get_tabla('cxc_clasificacion_pacientexconsultorio', ['cxc_id_clp' => $idClasificacionPaciente, 'cxc_estado' => 1]);

        // Verifica que no exista registro
        if(count($existeRegistro) > 0) {
            $asignado = 1;
            echo json_encode(['exito' => $exito, 'asignado' => $asignado]);
            die();            
        }
        
        $insert = [
            'cxc_id_clp' => $idClasificacionPaciente,
            'cxc_id_con' => $idConsultorio,
            'cxc_estado' => 1,
            'cxc_usu_creacion' => $this->tank_auth->get_user_id(),
            'cxc_fecha_creacion' => date('Y-m-d H:i:s'),
            'cxc_usu_modificacion' => $this->tank_auth->get_user_id(),
            'cxc_fecha_modificacion' => date('Y-m-d H:i:s'),
        ];

        $id = $this->gsatelite->ingresar('cxc_clasificacion_pacientexconsultorio', $insert);
        if ($id) {
            $exito = 1;
        }

        echo json_encode(['exito' => $exito, 'asignado' => $asignado]);
        die();
    }

    public function inhabilitarClasificacionPacientexConsultorio(){
        $exito = 0;

        $idConsultorio = $this->input->post('idConsultorio');
        $idClasificacionPaciente = $this->input->post('idClasificacionPaciente');

        $existeRegistro = $this->gsatelite->get_tabla('cxc_clasificacion_pacientexconsultorio', ['cxc_id_clp' => $idClasificacionPaciente, 'cxc_estado' => 1]);


        // Verifica que no exista registro
        if(count($existeRegistro) > 0) {
            $registro = $existeRegistro[0];
            $flagDelete = $this->gsatelite->borrado_general('cxc_clasificacion_pacientexconsultorio', ['cxc_id' => $registro['cxc_id']]);

            if ($flagDelete > 0) {
                $exito = 1;
            }

        }
        echo json_encode(['exito' => $exito]);
        die();            
    }

    public function cambiarEstadoConsulta(){
        $exito = 0;
        $idClasificacionPaciente = $this->input->post('idClasificacionPaciente');
        $existeRegistro = $this->gsatelite->get_tabla('clp_clasificacion_paciente', ['clp_id' => $idClasificacionPaciente, 'clp_estado' => 1]);

        if (count($existeRegistro) > 0) {
            $registro = $existeRegistro[0];

            $update = [
                'clp_estado_consulta' => 2,
                'clp_usu_modificacion' => $this->tank_auth->get_user_id(),
                'clp_fecha_modificacion' => date('Y-m-d H:i:s'),
            ];  

            $cim_id = $this->obtenerCitaClasificacionPaciente($idClasificacionPaciente);
            
            $update['clp_id_cim'] = $cim_id;
            $flagUpdate = $this->gsatelite->actualizar_array('clp_clasificacion_paciente', $update, ['clp_id' => $registro['clp_id']]);


            if ($flagUpdate > 0) {
                $exito = 1;
            }
        }
        echo json_encode(['exito' => $exito, 'cim_id' => $cim_id]);
        die(); 
    }

    private function actualizar_clasificacion_paciente($clp_id, $cnm_id)
    {

        if (!is_null($clp_id)) {
            $update_clasificacion_paciente_emergencia = [
                'clp_estado_consulta' => 3,
                'clp_usu_modificacion' => $this->tank_auth->get_user_id(),
                'clp_fecha_modificacion' => date('Y-m-d H:i:s'),
            ];      
            $this->gsatelite->actualizar_array('clp_clasificacion_paciente', $update_clasificacion_paciente_emergencia, ['clp_id' => $clp_id]);               
        }

        // Actualizar medico de la cita medica
        // Obtenemos el medico mediante el usuario y consultorio activo
                        $this->db->join('med_medico', 'med_id = con_id_med');
                        $this->db->join('users', 'med_id_usu = id');
        $consultorio = $this->gsatelite->get_tabla('con_consultorio', ['id' => $this->tank_auth->get_user_id(), 'con_estado' => 1]);

        $cnm_consulta = $this->gsatelite->get_tabla('cnm_consulta_medica', ['cnm_id' => $cnm_id]);
        $cnm_consulta = (count($cnm_consulta) > 0) ? $cnm_consulta[0] : null;

        if (count($consultorio) > 0 && $cnm_consulta && $cnm_consulta['cnm_id_cim']) {
            $consultorio = $consultorio[0];

            $this->gsatelite->actualizar_array('cim_cita_medica', ['cim_id_med' => $consultorio['med_id']], ['cim_id' => $cnm_consulta['cnm_id_cim']]);
        }

    }

    public function agregarRequisicionReceta($cnm_id = 0){
        $id_detalle = 0;
        $usuario = $this->tank_auth->get_user_id();

        // Si parametro no esta activo no permite la creacion de la requisicion
        $sistema_permite_requisicion_receta = $this->gsatelite->get_parametro_emp('SYS_REQUISICION_RECETA', 0);
        if ($sistema_permite_requisicion_receta == 0) {
            return;
        }


        $medicamento = $this->input->post('txtmedicamento');
        $cantidad = $this->input->post('txtcantidad');
        $receta = [];

                    $this->db->join('med_medico', 'med_id_usu = id');
                    $this->db->join('con_consultorio', 'con_id_med = med_id');
                    $this->db->join('emp_empleado', 'emp_id = usu_id_emp');
        $medico = $this->gsatelite->get_tabla('users', ['id' => $usuario, 'con_estado' => 1]);

        if (count($medico) > 0 && is_array($medicamento)) {
            $medico = $medico[0];

            foreach($medicamento as $key => $value) {
                if (isset($cantidad[$key]) && $cantidad[$key] !== '' && floatval($cantidad[$key]) > 0) {   

                    // Verificar cantidad del saldo del articulo
                    $infoArticulo = $this->inventario_model->datos_generles_articulo($value);
                    $saldoActual = $this->inventario_model->get_sum_sar_cantidades($value, $medico['con_id_bod']);         
                    if ($saldoActual[0]['cantidad'] != "" && floatval($saldoActual[0]['cantidad']) > 0 && $infoArticulo[0]['cva_id'] > 0) {
                        $receta[] = [
                            'art_id' => $value,
                            'cantidad' => $cantidad[$key],
                            'cva_id' => $infoArticulo[0]['cva_id']
                        ];                        
                    }
                }
            }
        }

        if (!empty($medico) && count($receta) > 0){
            $slcBodega = $medico['con_id_bod'];
            $slcEmpleado = $medico['emp_id'];
            $tipoRequisicion = 1;
            $fecha = date('Y-m-d H:i:s');
            $txtDescripcion = 'Receta';

            $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
            $flujos_array = json_decode($flujos, true);
            $flujoRequisicionesInv = $flujos_array['REQ_INV'];


            $num_actual = $this->gsatelite->count('rxi_requisicion_inventario', array('rxi_id_flu' => $flujoRequisicionesInv));

            $codigo = $num_actual + 1;

            $cod_requisicion = generar_codigo_cor($codigo, 5);

            $ingresar_requisicion = array(
                'rxi_numero' => $cod_requisicion,
                'rxi_id_bod' => $slcBodega,
                'rxi_id_usu_solicita' => $usuario,
                'rxi_id_emp' => $slcEmpleado,
                'rxi_id_flu' => $flujoRequisicionesInv,
                'rxi_fecha' => date('Y-m-d', strtotime($fecha)),
                'rxi_descripcion' => $txtDescripcion,
                'rxi_estado' => 1,
                'rxi_tipo' => $tipoRequisicion,
                'rxi_id_cnm' => ($cnm_id > 0) ? $cnm_id : null,
                'rxi_usu_creacion' => $this->tank_auth->get_user_id(),
                'rxi_fecha_creacion' => date('Y-m-d h:i:s'),
                'rxi_usu_modificacion' => $this->tank_auth->get_user_id(),
                'rxi_fecha_modificacion' => date('Y-m-d h:i:s')
            );

            $id_req = $this->gsatelite->ingresar('rxi_requisicion_inventario', $ingresar_requisicion);                
            if ($id_req > 0) {
                $primer_paso = $this->inventario_model->get_primer_paso_flujo($flujoRequisicionesInv);
                if (count($primer_paso) > 0) {
                    $seguimiento_requisicion = array(
                        'sgr_id_rxi' => $id_req,
                        'sgr_id_psf' => $primer_paso[0]['psf_id'],
                        'sgr_id_usu' => $usuario,
                        'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                        'sgr_estado' => 1,
                        'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sgr_fecha_creacion' => date('Y-m-d h:i:s'),
                        'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                    );
                    $id_detalle = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);
                }

                if (count($receta) > 0) {
                    for ($i = 0; $i < count($receta); $i++) {

                        $id_cant = $receta[$i]['cantidad'];
                        $art_id = null;
                        $cva_id = null;
                        $act_id = null;
                        $dri_id = null;
                        $sri_id = null;

                        switch ($tipoRequisicion) {
                            case 1:
                            $art_id = $receta[$i]['art_id'];
                            $cva_id = $receta[$i]['cva_id'];
                            break;
                            case 2:
                            $art_id = $productos[$i];
                            break;
                            case 3:
                            $act_id = $productos[$i];
                            break;
                        }

                        $detalle_req = array(
                            'dri_id_rxi' => $id_req,
                            'dri_id_art' => $art_id,
                            'dri_id_cva' => $cva_id,
                            'dri_id_act' => $act_id,
                            //'dri_id_sri' => $sri_id,
                            'dri_cantidad' => convertirFloat($receta[$i]['cantidad']),
                            'dri_estado' => 1,
                            'dri_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dri_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'dri_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dri_fecha_creacion' => date('Y-m-d H:i:s')
                        );

                        $id_detalle = $this->gsatelite->ingresar('dri_detalle_requisicion_inventario', $detalle_req);
                    }
                }

            }

            $this->load->library('../controllers/inventario/gestion_productos');
            $this->gestion_productos->autorizar_requisicion_automatica($id_req, 1, $flujoRequisicionesInv);
            return;
        }
    }

    public function get_estado_consulta_emergencia(){
        $enConsulta = false;
        $idClasificacionPaciente = $this->input->post('idClasificacionPaciente');
                                $this->db->join('cxc_clasificacion_pacientexconsultorio', 'cxc_id_clp = clp_id AND cxc_estado = 1', 'LEFT');
        $clasificacionPaciente = $this->gsatelite->get_tabla('clp_clasificacion_paciente', ['clp_id' => $idClasificacionPaciente]);
        if (count($clasificacionPaciente) > 0) {
            $clasificacionPaciente = $clasificacionPaciente[0];
            $enConsulta = $clasificacionPaciente['clp_estado_consulta'] != 1 || $clasificacionPaciente['cxc_id'] > 0;
        }
        
        $cim_id = $this->obtenerCitaClasificacionPaciente($idClasificacionPaciente);
        die(json_encode(['en_consulta' => $enConsulta, 'cim_id' => intval($cim_id)]));
    }

    /**
     * @author Erick Mejia
     * @since 2025-09-04
     * @return Obtiene el id de cita de clasificacion paciente si no existe crea la cita y lo asocia
     * */
    public function obtenerCitaClasificacionPaciente($clp_id){
        $registro = $this->gsatelite->get_registro('clp_clasificacion_paciente', ['clp_id' => $clp_id, 'clp_estado' => 1]);
        $registro = (array) $registro;

        if (is_null($registro['clp_id_cim'])) {
            // Se crea la cita medica
            $correlativo = ($this->gsatelite->get_max('cim_cita_medica','cim_id') != null)? $this->gsatelite->get_max('cim_cita_medica','cim_id') + 1 : 1;
            $correlativo = str_pad($correlativo, 4, "0", STR_PAD_LEFT);
            // $medicoConsultorio = $this->gsatelite->get_tabla('med_medico', ['med_id_usu' => $userId, 'med_estado' => 1]);
            $cim_cita_medica = [
                'cim_id_usu' => $this->tank_auth->get_user_id(),
                'cim_id_epp' => $registro['clp_id_epp'],
                'cim_observacion' => 'Cita de emergencia generada por atención inmediata sin cita previa.',
                'cim_fecha_cita' => date('Y-m-d H:i:s'),
                'cim_hora_desde' => date('H:i:s'),
                'cim_fecha_registro' => date('Y-m-d H:i:s'),
                'cim_numero' => 'CI-' . $correlativo,                
                'cim_id_tcm' => $registro['clp_id_tcm'],             
                'cim_estado_cita' => 2,
                'cim_estado' => 1,
                'cim_usu_creacion' => $this->tank_auth->get_user_id(),
                'cim_fecha_creacion' => date('Y-m-d H:i:s'),
                'cim_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cim_fecha_modificacion' => date('Y-m-d H:i:s'),
            ];

            $cim_id = $this->gsatelite->ingresar('cim_cita_medica',$cim_cita_medica);                
            $update['clp_id_cim'] = $cim_id;
            $flagUpdate = $this->gsatelite->actualizar_array('clp_clasificacion_paciente', $update, ['clp_id' => $clp_id]);
        } else {
            $cim_id = $registro['clp_id_cim'];
        }

        return $cim_id;
    }

    public function turnos_paciente(){
        satelite_validar();
        $userId = $this->tank_auth->get_user_id();
        $data = [];

        $usc_usuario_sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $userId));
        $whereSlcSucursal = null;

        // Se obtendran solo las sucursales que tenga asignado el usuario
        // Si no tiene asignada sucursal se mostraran todas las sucursales
        if (count($usc_usuario_sucursal) > 0) {
            $sucursalesId = array_column($usc_usuario_sucursal, 'usc_id_suc');
            $sucursalesId = implode(',', $sucursalesId);
            $whereSlcSucursal["suc_id IN ({$sucursalesId})"] = null;
        }   
        
        $sucursales = $this->gsatelite->get_tabla('suc_sucursal', $whereSlcSucursal);
        
        if (empty($sucursales)) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Turnos Pacientes", 'texto_alerta' => "Debe tener una sucursal asignada.");
            $this->session->set_flashdata($alerta);
            redirect('modulo_medico/index');
        }
        
        $sucursal = $sucursales[0];
        $wherePacienteTurno = [];
        $wherePacienteTurno['con_id_suc'] = $sucursal['suc_id'];
        $wherePacienteTurno['cxc_estado'] = 1;
        $wherePacienteTurno['clp_estado_consulta != 3'] = null;
        $pacientes = $this->medico_model->consultar_turnos_pacientes($wherePacienteTurno);
        
        $data['sucursal'] = $sucursal;
        $data['pacientes'] = $pacientes;
        cargarvista($data);

    }

    public function consulta_turno_paciente($sucursal = 0) {
        $wherePacienteTurno['con_id_suc'] = $sucursal;
        $wherePacienteTurno['cxc_estado'] = 1;
        $wherePacienteTurno['clp_estado_consulta != 3'] = null;
        $pacientes = $this->medico_model->consultar_turnos_pacientes($wherePacienteTurno);
        die(json_encode(['pacientes' => $pacientes]));        
    }     



}

?>