<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Med_mantenimientos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('medico_model');
        $this->load->model('inventario_model');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    /**
     * Descripción:
     * clasificacion de los pacientes
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de clasificacion de paciente
     */
    public function clasificacion_paciente() {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->clasificacion_cliente();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a los Generos (tabla: gen_genero)
     * Funcionalidad Compartida del Modulo de Expediente Personal - Genero
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de Genero
     */
    public function generos() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->generos();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a las Estado civil (tabla: esc_estado_civil)
     * Funcionalidad Compartida del Modulo de Expediente Personal - Estado civil
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de Estado civil
     */
    public function estado_civil() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->estado_civil();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a las Profeciones (tabla: pro_profesion)
     * Funcionalidad Compartida del Modulo de seguridad - seguridad
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de profesion
     */
    public function profesiones() {
        satelite_validar();
        $this->load->library('../controllers/sistema/catalogo');
        $this->catalogo->profesion();
    }

        /**
     * Descripción:
     * Función para dar mantenimiento de País (tabla: pai_pais)
     * Funcionalidad Compartida del Modulo de seguridad - País
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de País
     */
        public function nacionalidad()
        {
            satelite_validar();
            $this->load->library('../controllers/sistema/catalogo');
            $this->catalogo->pais();
        }

    /**
     * Descripción:
     * Función para dar mantenimiento de departamento (tabla: dep_departamento)
     * Funcionalidad Compartida del Modulo de seguridad - departamento
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de departamento
     */
    public function departamentos()
    {
        satelite_validar();
        $this->load->library('../controllers/sistema/catalogo');
        $this->catalogo->departamentos();
    }

         /**
     * Descripción:
     * Función para dar mantenimiento de parentesco (tabla: pat_parentesco)
     * Funcionalidad Compartida del Modulo de expediente personal - parentesco
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de parentezco
     */
         public function parentesco()
         {
            satelite_validar();
            $this->load->library('../controllers/expediente_personal/catalogos');
            $this->catalogos->parentesco();
        }

         /**
     * Descripción:
     * Función para dar mantenimiento de tipo de sangre (tabla: tsr_tipo_sangre)
     * Funcionalidad Compartida del Modulo de expediente personal - tipo de sangre
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de tipo de sangre
     */
         public function tipo_sangre()
         {
            satelite_validar();
            $this->load->library('../controllers/expediente_personal/catalogos');
            $this->catalogos->tipo_sangre();
        }

         /**
     * Descripción:
     * Función para dar mantenimiento de Alergias (tabla: coa_componente_alergico)
     * Funcionalidad Compartida del Modulo de expediente personal - Alergias
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de Alergias
     */
         public function alergias()
         {
            satelite_validar();
            $this->load->library('../controllers/expediente_personal/catalogos');
            $this->catalogos->alergia();
        }

         /**
     * Descripción:
     * Función para dar mantenimiento de Enfermedades (tabla: enf_enfermedad)
     * Funcionalidad Compartida del Modulo de expediente personal - Enfermedades
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de Enfermedades
     */
         public function enfermedades()
         {
            satelite_validar();
            $this->load->library('../controllers/expediente_personal/catalogos');
            $this->catalogos->enfermedades();
        }

         /**
     * Descripción:
     * Función para dar mantenimiento de tipos de documentos (tabla: tde_tipo_documentos)
     * Funcionalidad Compartida del Modulo de expediente personal - tipos de documentos
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de tipos de documentos
     */
         public function tipo_documentos()
         {
            satelite_validar();
            $this->load->library('../controllers/expediente_personal/catalogos');
            $this->catalogos->tipo_documento();
        }

              /**
     * Descripción:
     * Función para dar mantenimiento de Tipo teléfono (tabla: tit_tipo_telefono)
     * Funcionalidad Compartida del Modulo de expediente personal - Tipo teléfono
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de Tipo teléfono
     */
              public function tipo_telefono()
              {
                satelite_validar();
                $this->load->library('../controllers/expediente_personal/catalogos');
                $this->catalogos->tipo_telefono();
            }

    /**
     * Descripción:
     * Función para dar mantenimiento de Categorias (tabla: tia_tipo_articulos)
     * Funcionalidad Compartida del Modulo de inventario - categorias
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de categorias
     */
    public function categorias_medicamentos()
    {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->tipo_articulo('modulo_medico/med_mantenimientos');
    }

         /**
     * Descripción:
     * Función para habilitar la vista de categoria_medica
     * Funcionalidad Compartida del Modulo de inventario - categorias
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de categorias
     */
         public function agregar_pro_articulo()
         {
            satelite_validar();
            $this->load->library('../controllers/inventario/mantenimiento');
            $html = $this->mantenimiento->agregar_pro_articulo('modulo_medico/med_mantenimientos/agregar_pro_articulo', 'modulo_medico/med_mantenimientos/categorias_medicamentos');
            $data['html'] = $html;
            $this->_cargarvista($data);
        }

    /**
     * Descripción:
     * Función para dar mantenimiento de Caracteristicas
     * @return Mantenimiento de caracteristicas
     */
    public function caracteristicas_med(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $url_array = explode('/', uri_string());
            $crud = $this->new_crud();
            $columns = array(
                'car_nombre',
                'car_descripcion'
            );
            $alias = array(
                'car_nombre' => 'Nombre',
                'car_descripcion' => 'Descripción',
                'car_estado' => 'Estado'
            );
            $add_columns = array(
                'car_nombre',
                'car_descripcion',
                'car_estado',
                'car_usu_mod',
                'car_fecha_mod',
                'car_usu_crea',
                'car_fecha_crea'
            );
            $req_columns = array(
                'car_nombre',
                'car_estado'
            );
            $crud->set_table('car_caracteristica')->set_subject('')->columns($columns)->display_as($alias)->add_fields($add_columns)->required_fields($req_columns)->field_type('car_usu_mod', 'hidden', $this->tank_auth->get_user_id())->field_type('car_fecha_mod', 'hidden', date('Y-m-d H:i:s'))->field_type('car_usu_crea', 'hidden', $this->tank_auth->get_user_id())->field_type('car_fecha_crea', 'hidden', date('Y-m-d H:i:s'))->set_rules('car_nombre', 'Nombre de la característica', 'trim|required|callback_caracteristica_nombre_unico');
            if (end($url_array) == 'add') {
                $crud->field_type('car_estado', 'hidden', 1);
            } else {
                $crud->field_type('car_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            $crud->callback_add_field('car_codigo', function () {
                $tabla = 'car_caracteristica';
                $campo = 'car_codigo';
                $last = $this->inventario_model->get_max_codigo($tabla, $campo);
                $code = $last->codigo;
                $cod = (int) $code + 1;
                $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);
                return '<input id="field-car_codigo" name="car_codigo" type="text" maxlength="99" value="' . $codigo . '" >';
            });
            $crud->callback_edit_field('car_codigo', function ($value, $primary_key) {
                if ($value == '') {
                    $tabla = 'car_caracteristica';
                    $campo = 'car_codigo';
                    $last = $this->inventario_model->get_max_codigo($tabla, $campo);
                    $code = $last->codigo;
                    $cod = (int) $code + 1;
                    $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);
                    return '<input id="field-car_codigo" name="car_codigo" type="text" maxlength="99" value="' . $codigo . '" >';
                } else {
                    return '<input id="field-car_codigo" name="car_codigo" type="text" maxlength="99" value="' . $value . '" >';
                }
            });
            $crud->edit_fields($add_columns);
            $crud->unset_add();
            $data['agregar'] = ($permisos['permite_agregar']) ? true : false;
            $crud->unset_edit();
            if ($permisos['permite_editar']) {
                $crud->add_action('Editar', 'icomoon-icon-pencil-5', base_url() . "modulo_medico/med_mantenimientos/caracteristicas_editar/");
            }
            $crud->unset_read();
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', base_url() . "modulo_medico/med_mantenimientos/caracteristicas_ver/");
            }
            $crud->unset_delete();
            if ($permisos['permite_eliminar']) {
                $crud->add_action('Borrar', 'icon16 icomoon-icon-remove', base_url() . "modulo_medico/med_mantenimientos/caracteristicas_eliminar/", 'borrado');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de características";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function caracteristicas_agregar(){
        satelite_validar();        
        if ($this->input->post('tipoboton') == 'cancel') {
            redirect('modulo_medico/med_mantenimientos/caracteristicas_med');
        }
        if ($this->input->post()) {
            $caracteristica_array = array(
                'car_codigo' => ($this->input->post('car_codigo')) ? $this->input->post('car_codigo') : null,
                'car_nombre' => $this->input->post('inpNombre'),
                'car_descripcion' => $this->input->post('inpDescripcion'),
                'car_tipo' => $this->input->post('slcTipo'),
                'car_estado' => 1,
                'car_usu_crea' => $this->tank_auth->get_user_id(),
                'car_fecha_crea' => date('Y-m-d H:i:s'),
                'car_usu_mod' => $this->tank_auth->get_user_id(),
                'car_fecha_mod' => date('Y-m-d H:i:s')
            );
            $car_id  = $this->gsatelite->ingresar('car_caracteristica', $caracteristica_array);
            $valores = $this->input->post('valores'); 
            $precios = $this->input->post('preciosCa');   
            $lista   = array_combine($valores, $precios);
            if ($lista) {
                foreach ($lista as $key => $value) {
                    $valores_lista_array = array(
                        'vrl_id_car'                => $car_id,
                        'vrl_valor'                 => $key,
                        'vrl_precio_valor'          => ($value != '')?$value:null,
                        'vrl_estado'                => 1,
                        'vrl_usu_creacion'          => $this->tank_auth->get_user_id(),
                        'vrl_fecha_creacion'        => date('Y-m-d H:i:s'),
                        'vrl_usu_modificacion'      => $this->tank_auth->get_user_id(),
                        'vrl_fecha_modificacion'    => date('Y-m-d H:i:s')
                    );
                    $result = $this->gsatelite->ingresar('vrl_valores_lista', $valores_lista_array);
                }
            }
            if ($car_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "El registro se guardó correctamente.");
            }else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            $this->session->set_flashdata($alerta);
            if ($this->input->post('tipoboton') == 'save') {
                redirect('modulo_medico/med_mantenimientos/caracteristicas_agregar/');
            } else {
                redirect('modulo_medico/med_mantenimientos/caracteristicas_med');
            }
        }else{
            $last = $this->inventario_model->get_max_codigo('car_caracteristica', 'car_codigo');
            $code = $last->codigo;
            $cod = (int) $code + 1;
            $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);
            $data['titulo_personal'] = "Catálogo de características";
            $data['codigo'] = $codigo;
            $this->_cargarvista($data);
        }
    }

    function caracteristicas_editar($car_id = null){        
        satelite_validar();
        if($_POST){
            $car_id = $this->input->post('car_id');            
            $caracteristica_array = array(
                'car_codigo' => ($this->input->post('car_codigo')) ? $this->input->post('car_codigo') : null,
                'car_nombre' => $this->input->post('inpNombre'),
                'car_descripcion' => $this->input->post('inpDescripcion'),
                'car_tipo' => $this->input->post('slcTipo'),
                'car_estado' => $this->input->post('slcEstado'),
                'car_usu_crea' => $this->tank_auth->get_user_id(),
                'car_fecha_crea' => date('Y-m-d H:i:s'),
                'car_usu_mod' => $this->tank_auth->get_user_id(),
                'car_fecha_mod' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('car_caracteristica', $caracteristica_array, array('car_id'=>$car_id));
            $res = $this->gsatelite->borrado_general('vrl_valores_lista', array('vrl_id_car' => $car_id));
            $valores = $this->input->post('valores');   
            $precios = $this->input->post('preciosCaUpdate');    
            $lista   = array_combine($valores, $precios);     
            if ($lista) {
                foreach ($lista as $key => $value) {
                    $valores_lista_array = array(
                        'vrl_id_car'             => $car_id,
                        'vrl_valor'              => $key,
                        'vrl_precio_valor'       => ($value != '')?$value:null,
                        'vrl_estado'             => 1,
                        'vrl_usu_creacion'       => $this->tank_auth->get_user_id(),
                        'vrl_fecha_creacion'     => date('Y-m-d H:i:s'),
                        'vrl_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'vrl_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $result = $this->gsatelite->ingresar('vrl_valores_lista', $valores_lista_array);
                }                
            }
            if ($car_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "El registro se guardó correctamente.");
            }else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "Ocurrio un problema al editar el registro.");
            }
            $this->session->set_flashdata($alerta);
            if ($this->input->post('tipoboton') == 'save') {
                redirect('modulo_medico/med_mantenimientos/caracteristicas_editar/'.$car_id);
            } else {
                redirect('modulo_medico/med_mantenimientos/caracteristicas_med');
            }
        }else{
            satelite_validar();
            $this->db->join('vrl_valores_lista','car_id =vrl_id_car','left');
            $carac = $this->gsatelite->get_tabla('car_caracteristica', array('car_id'=>$car_id));
            $data['caracteristica'] = $carac;
            $data['car_id'] = $car_id;
            $data['car_codigo'] = $carac[0]['car_codigo'];
            $data['titulo_personal'] = "Editar características";                    
            $this->_cargarvista($data);
        }            
    }

    function caracteristicas_ver($car_id){
        satelite_validar();
                                  $this->db->join('vrl_valores_lista','car_id =vrl_id_car','left');
        $data['caracteristica'] = $this->gsatelite->get_tabla('car_caracteristica', array('car_id'=>$car_id));        
        $data['titulo_personal'] = "Ver características";                    
        $this->_cargarvista($data);
    }

    function caracteristicas_eliminar($car_id){
        $tbl_vrl = $this->gsatelite->get_tabla('vrl_valores_lista', array('vrl_id_car' => $car_id));
        $result2 = $this->inventario_model->delete_caracteristica(array('car_id' => $car_id));
        if ($result2 < 1 && count($tbl_vrl) > 0) {//No se pudo borrar y reversion de los datos eliminados
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Eliminar característica", 'texto_alerta' => "Otros registros dependen de este, por lo tanto no podrá ser eliminado.");
        }else{
            if($result2 == 0){
                $alerta = array('tipo_alerta' =>'error', 'titulo_alerta' => "Eliminar característica", 'texto_alerta' => "Otros registros dependen de este, por lo tanto no podrá ser eliminado.");
            }else{
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Eliminar característica", 'texto_alerta' => "El registro se eliminó correctamente.");
            }            
        }
        $this->session->set_flashdata($alerta);
        redirect('modulo_medico/med_mantenimientos/caracteristicas_med');
    }

    /**
     * Descripción:
     * Función para habilitar el editar de categoria_medica
     * Funcionalidad Compartida del Modulo de inventario - categorias
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de categorias
     */
    public function editar_pro_articulo($id)
    {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $html = $this->mantenimiento->editar_pro_articulo($id,'modulo_medico/med_mantenimientos/agregar_pro_articulo', 'modulo_medico/med_mantenimientos/categorias_medicamentos');
        $data['html'] = $html;
        $this->_cargarvista($data);
    }

         /**
     * Descripción:
     * Función para dar mantenimiento de Marcas (tabla: mrp_marca_producto)
     * Funcionalidad Compartida del Modulo de inventario - Marcas
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de Marcas
     */
         public function marcas()
         {
            satelite_validar();
            $this->load->library('../controllers/inventario/mantenimiento');
            $this->mantenimiento->marca_producto();
        }

         /**
     * Descripción:
     * Función para dar mantenimiento de Presentación de producto (tabla: ppr_presentacion_producto)
     * Funcionalidad Compartida del Modulo de inventario - Presentación de producto
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de Presentación de producto
     */
         public function presentacion()
         {
            satelite_validar();
            $this->load->library('../controllers/inventario/mantenimiento');
            $this->mantenimiento->presentacion();
        }

    /**
     * Descripción:
     * Función para dar mantenimiento de Mantenimientos Aseguradoras (tabla: )
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Mantenimiento de Presentación de producto
     */
    public function aseguaradoras() {
        satelite_validar();

        $crud = new grocery_CRUD();
        //Columnas a mostrar en READ
        $columns = array(
            'ase_nombre',
            'ase_descripcion',
            'ase_estado'
        );

        //Alias para las columnas
        $alias = array(
            'ase_nombre' => 'Nombre',
            'ase_descripcion' => 'Descripcion',
            'ase_estado' => 'Estado'
        );

        $crud->set_table('ase_aseguradora')
        ->set_subject('')
        ->columns($columns)
        ->display_as($alias)
        ->unset_export()
        ->unset_print()
        ->unset_read()
        ->unset_edit()
        ->unset_delete()
        ;
        $crud->field_type('ase_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        $crud->add_action('Ver', 'minia-icon-search', 'modulo_medico/med_mantenimientos/ver_aseguradora');
        $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'modulo_medico/med_mantenimientos/editar_aseguradora');
        $crud->add_action('Borrar', 'icon16 icomoon-icon-remove', 'modulo_medico/med_mantenimientos/delete_aseguradora');
        $crud->add_action('Agregar formato', 'icon16 icomoon-icon-clipboard-3', 'modulo_medico/med_mantenimientos/agregar_formato_aseguradora');


        $data['titulo_personal'] = "Aseguradoras";
        //$data['reg_id']          = (is_numeric(end(explode('/', uri_string()))))?end(explode('/', uri_string())):0;
        $output = $crud->render();
        $this->_cargarvista($data, $output);
        //cargarvista($data,$output,'cotizaciones/mantenimientos/clasificacion_cliente');
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Aseguradora (tabla: ase_aseguradora, pol_poliza)
     * se agrega la informacion dada
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param ninguno
     * @return Agregar aseguradora
     */
    public function agregar_aseguradora()
    {
        satelite_validar();
        if ($_POST) {
            $nombreaseguradora = $this->input->post('txtnomgeneral');
            $descripciongeneral = $this->input->post('txtdesgeneral');
            $btn = $this->input->post('btnCrear');

            $dataaseguradora = array('ase_nombre' => $nombreaseguradora,
               'ase_descripcion' => $descripciongeneral,
               'ase_estado' => 1,
               'ase_usu_creacion' => $this->tank_auth->get_user_id(),
               'ase_fecha_creacion' => date('Y-m-d H:i:s'),
               'ase_usu_modificacion' => $this->tank_auth->get_user_id(),
               'ase_fecha_modificacion' => date('Y-m-d H:i:s')
           );
            $id_aseguradora = $this->gsatelite->ingresar('ase_aseguradora', $dataaseguradora);

            $nombrepoliza = $this->input->post('txtnombrepoliza');
            $numeropoliza = $this->input->post('txtnumeropoliza');
            $descripcionpoliza = $this->input->post('txtdescripcionpoliza');
            //print_r($nombrepoliza[0]);die();
            $polizamasiva = array();

            if (!empty($nombrepoliza)) {
                for ($i=0; $i < count($nombrepoliza); $i++) { 
                    $polizamasiva[$i] = array('pol_id_ase' => $id_aseguradora,
                        'pol_numero' => $numeropoliza[$i],
                        'pol_nombre' => $nombrepoliza[$i],
                        'pol_descripcion' => $descripcionpoliza[$i],
                        'pol_estado' => 1,
                        'pol_usu_creacion' => $this->tank_auth->get_user_id(),
                        'pol_fecha_creacion' => date('Y-m-d H:i:s'),
                        'pol_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'pol_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                }
            }
            if (count($polizamasiva) > 0) {
                $variable = $this->gsatelite->ingresar('pol_poliza', $polizamasiva, true);
            }

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Aseguradora", 'texto_alerta' => "El registro se almacenado correctamente");
            $this->session->set_flashdata($alerta);
            if ($btn == 1) {
                redirect('modulo_medico/med_mantenimientos/agregar_aseguradora');
            } else {
                redirect('modulo_medico/med_mantenimientos/aseguaradoras');
            }
        }
        
        $data['titulo_personal'] = "Aseguradoras";
        $this->_cargarvista($data);
    }

    /**
    * Descripción: Editar mantenimiento (tabla: ase_aseguradora, pol_poliza)
    * @author Marlon Olmedo - Grupo Satélite
    * @since 2019-08-08
    * @param id poliza
    */
    public function editar_aseguradora($id_poliza=null){
        satelite_validar();
        if ($_POST) {
            // var_dump($_POST);die();
            $nombreaseguradora = $this->input->post('txtnomgeneral');
            $descripciongeneral = $this->input->post('txtdesgeneral');
            $btn = $this->input->post('btnCrear');
            $dataaseguradora = array('ase_nombre' => $nombreaseguradora,
                'ase_descripcion' => $descripciongeneral,
                'ase_estado' => 1,
                'ase_usu_creacion' => $this->tank_auth->get_user_id(),
                'ase_fecha_creacion' => date('Y-m-d H:i:s'),
                'ase_usu_modificacion' => $this->tank_auth->get_user_id(),
                'ase_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $id_aseguradora = $this->gsatelite->actualizar_array('ase_aseguradora', $dataaseguradora, array('ase_id' => $id_poliza));

            $ids_polizas = $this->input->post('id_polizas');
            $nombrepoliza = $this->input->post('txtnombrepoliza');
            $numeropoliza = $this->input->post('txtnumeropoliza');
            $descripcionpoliza = $this->input->post('txtdescripcionpoliza');
            // ir a traer las polizas y buscar si se borra alguna si no viene en el nuevo arreglo
            $pol_existe = $this->gsatelite->get_tabla('pol_poliza', array('pol_id_ase'=>$id_poliza));
            foreach ($pol_existe as $k => $val) {
                if (!(in_array($val['pol_id'], $ids_polizas))) {
                    $this->gsatelite->borrado_general('pol_poliza', array('pol_id_ase' => $id_poliza, "pol_id" => $val['pol_id']));
                }
            }
            for ($i = 0; $i < count($ids_polizas); $i++) { 
                $poliza = array(
                    'pol_id_ase' => $id_poliza,
                    'pol_numero' => $numeropoliza[$i],
                    'pol_nombre' => $nombrepoliza[$i],
                    'pol_descripcion' => $descripcionpoliza[$i],
                    'pol_estado' => 1,
                    'pol_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'pol_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                if ($ids_polizas[$i] > 0) {
                    $this->gsatelite->actualizar_array('pol_poliza', $poliza, array('pol_id' => $ids_polizas[$i]));
                } else {
                    $poliza['pol_fecha_creacion'] = date('Y-m-d H:i:s');
                    $poliza['pol_usu_creacion'] = $this->tank_auth->get_user_id();
                    $this->gsatelite->ingresar('pol_poliza', $poliza);
                }                
            }
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Aseguradora", 'texto_alerta' => "El registro se actualizo correctamente");
            $this->session->set_flashdata($alerta);
            if ($btn == 1) {
                redirect('modulo_medico/med_mantenimientos/editar_aseguradora/'.$id_poliza);
            } else {
                redirect('modulo_medico/med_mantenimientos/aseguaradoras');
            }
        }
        $data['poliza'] = $this->medico_model->aseguradoraxpoliza(array('ase_id' => $id_poliza));
        $data['id_poliza'] = $id_poliza;
        $data['titulo_personal'] = "Aseguradoras";
        $this->_cargarvista($data);
    }

    /**
     * Descripción:
     * Ver datos del mantenimientob aseguradora (tabla: ase_aseguradora, pol_poliza)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param id poliza
     * @return true
     */
    public function ver_aseguradora($id_poliza=null)
    {
        satelite_validar();
        $where = array('ase_id' => $id_poliza);
        $data['poliza'] = $this->medico_model->aseguradoraxpoliza($where);
        $data['titulo_personal'] = "Aseguradoras";
        $this->_cargarvista($data);
    }

    /**
     * Descripción:
     * elimina las aseguradoras (tabla: ase_aseguradora, pol_poliza)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param id_ase
     * @return alerta
     */
    public function delete_aseguradora($id_ase)
    {
        satelite_validar();

        $aseguradora = $this->gsatelite->get_tabla("pol_poliza",array('pol_id_ase' => $id_ase));

        if (!(count($aseguradora) > 0)) {
           $aseguradora_rows = $this->gsatelite->borrado_general('ase_aseguradora', array('ase_id'=>$id_ase));
           $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Aseguradora", 'texto_alerta' => "El registro se eliminado correctamente");
           $this->session->set_flashdata($alerta);
           redirect('modulo_medico/med_mantenimientos/aseguaradoras');
       }

       $poliza = array_column($aseguradora, 'pol_id');

       $poliza = implode(",", $poliza);

       $eliminar_pol = $this->gsatelite->get_tabla("sep_seguro_paciente",array("sep_id IN ($poliza)" => NULL));

       if (count($eliminar_pol) > 0) {
        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al eliminar", 'texto_alerta' => "El registro no se a eliminado");
        $this->session->set_flashdata($alerta);
        redirect('modulo_medico/med_mantenimientos/aseguaradoras');
    } 

    $poliza_rows = $this->gsatelite->borrado_general('pol_poliza', array('pol_id_ase'=>$id_ase));
    $aseguradora_rows = $this->gsatelite->borrado_general('ase_aseguradora', array('ase_id'=>$id_ase));

    if ($poliza_rows > 0 && $aseguradora_rows > 0) {
        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Aseguradora", 'texto_alerta' => "El registro se eliminado correctamente");
        $this->session->set_flashdata($alerta);
        redirect('modulo_medico/med_mantenimientos/aseguaradoras');
    } else {
        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al eliminar", 'texto_alerta' => "El registro no se a eliminado");
        $this->session->set_flashdata($alerta);
        redirect('modulo_medico/med_mantenimientos/aseguaradoras');
    }

}

    /**
     * Descripción:
     * mantenimiento de hospital (tabla: hos_hospital)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-10
     * @param none
     * @return none
     */
    public function hospital() {
        satelite_validar();
        
        $crud = new grocery_CRUD();
        //Columnas a mostrar en READ
        $columns = array(
            'hos_nombre',
            'hos_descripcion',
            'hos_estado'
        );

        //Alias para las columnas
        $alias = array(
            'hos_nombre' => 'Nombre',
            'hos_descripcion' => 'Descripcion',
            'hos_estado' => 'Estado'
        );

        $crud->set_table('hos_hospital')
        ->set_subject('')
        ->columns($columns)
        ->display_as($alias)
        ->required_fields('hos_nombre')
        ;
        if(end(explode('/',uri_string()))=='add') {
           $crud->field_type('hos_estado','hidden',1);
       } else {
           $crud->field_type('hos_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
       }
       $crud->field_type('hos_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
       $crud->field_type('hos_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
       $crud->field_type('hos_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
       $crud->field_type('hos_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        /*            $crud->add_action('Ver', 'minia-icon-search', 'modulo_medico/med_mantenimientos/ver_aseguradora');
        $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'modulo_medico/med_mantenimientos/editar_aseguradora');*/
        $output = $crud->render();

        $data['titulo_personal'] = "Hospital";
        $this->_cargarvista($data,$output);
    }

         /**
     * Descripción:
     * mantenimiento de especialidades (tabla: epm_especialidad_medica)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-10
     * @param none
     * @return none
     */
    public function especialidad() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();
        $columns = array(
            'epm_nombre',
            'epm_descripcion',
            'epm_estado'
        );
        $alias = array(
            'epm_nombre' => 'Nombre',
            'epm_descripcion' => 'Descripcion',
            'epm_estado' => 'Estado'
        );
        $add_fields = array(
            'epm_nombre',
            'epm_descripcion',
            'epm_estado',
            'epm_usu_creacion',
            'epm_fecha_creacion',
            'epm_usu_modificacion',
            'epm_fecha_modificacion'
        );
        $edit_fields = array(
            'epm_nombre',
            'epm_descripcion',
            'epm_estado',
            'epm_usu_modificacion',
            'epm_fecha_modificacion'
        );
        $crud->set_table('epm_especialidad_medica')
            ->set_subject('')
            ->columns($columns)
            ->add_fields($add_fields)
            ->edit_fields($edit_fields)
            ->display_as($alias)
            ->required_fields('epm_nombre')
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('epm_estado', 'hidden', 1);
            $crud->field_type('epm_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('epm_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        } else {
            $crud->field_type('epm_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $crud->field_type('epm_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('epm_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
            $crud->unset_print();
            $crud->unset_export();
        }
        $output = $crud->render();
        $data['modal'] = 0;
        $data['titulo_personal'] = "Especialidades";
        $this->_cargarvista($data,$output);
    }

    /**
     * Descripción:
     * mantenimiento de referido (tabla: ref_referido)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-10
     * @param none
     * @return none
     */
    public function referido() {
        satelite_validar();
        
        $crud = new grocery_CRUD();
        //Columnas a mostrar en READ
        $columns = array(
            'ref_nombre',
            'ref_descripcion',
            'ref_estado'
        );

        //Alias para las columnas
        $alias = array(
            'ref_nombre' => 'Nombre',
            'ref_descripcion' => 'Descripcion',
            'ref_estado' => 'Estado'
        );

        $crud->set_table('ref_referido')
        ->set_subject('')
        ->columns($columns)
        ->display_as($alias)
        ->required_fields('ref_nombre')
        ;
        if(end(explode('/',uri_string()))=='add') {
           $crud->field_type('ref_estado','hidden',1);
       } else {
           $crud->field_type('ref_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
       }
       $crud->field_type('ref_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
       $crud->field_type('ref_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
       $crud->field_type('ref_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
       $crud->field_type('ref_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
/*            $crud->add_action('Ver', 'minia-icon-search', 'modulo_medico/med_mantenimientos/ver_aseguradora');
$crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'modulo_medico/med_mantenimientos/editar_aseguradora');*/
$output = $crud->render();

$data['titulo_personal'] = "Referido";
$this->_cargarvista($data,$output);
}

    /**
     * Descripción:
     * mantenimiento de medicamento (tabla: ref_referido)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-10
     * @param none
     * @return none
     */
    public function medicamentos() {
        satelite_validar();
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        $crud = new grocery_CRUD();

        //Columnas a mostrar en READ
        $columns = array(
            'art_id_tia',
            'art_codigo',
            'art_nombre',
            'art_sinonimo',
            'art_id_ppr',
            'art_id_mrp',
            'art_estado'
        );

        //Alias para las columnas
        $alias = array(
            'art_id_tia' => 'Categorias',
            'art_codigo'  => 'Código',
            'art_nombre'  => 'Nombre',
            'art_sinonimo'=> 'Genérico',
            'art_id_ppr'  => 'Presentación',
            'art_id_mrp'  => 'Marca',
            'art_estado'  => 'Estado'
        );

        $dir = explode('/', uri_string());
        $crud->set_table('art_articulo')
            ->set_subject('')
            ->columns($columns)
            ->display_as($alias)
            ->set_relation('art_id_tia', 'tia_tipo_articulo', 'tia_nombre')
            ->field_type('art_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'))
            ->set_relation('art_id_mrp','mrp_marca_producto','mrp_nombre')
            ->set_relation('art_id_ppr','ppr_presentacion_producto','ppr_nombre')
            ->unset_edit()
            ->unset_read()
            ->unset_add()
        ;
        $crud->add_action('Editar', 'icon16 icon16 icomoon-icon-pencil-5', 'modulo_medico/med_mantenimientos/editar_medicamentos');
        $crud->add_action('Ver', 'minia-icon-search', 'modulo_medico/med_mantenimientos/ver_medicamentos');
        if ($_POST) {
            $categoria = $this->input->post('categoria');
            $producto = $this->input->post('producto');
            if($categoria > 0){
                $where['art_id_tia'] = $categoria;
            }
            if ($producto != '') {
                $where["art_nombre LIKE '%$producto%' OR art_codigo LIKE '%$producto%' OR art_sinonimo LIKE '%$producto%'"] = NULL;
            }
            if ($categoria != '' or $producto != '') {
                $crud->where($where);
            }
        }
        $output = $crud->render();
        $data['titulo_personal'] = "Medicamentos";
        $this->_cargarvista($data,$output);
    }

         /**
     * Descripción:
     * ajax de articulo (tabla: tia_tipo_articulo)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param 
     * @return true
     */
         public function get_caracteristica_like()
         {
            satelite_validar();
            $caracteristica = $this->input->post('categoria');

            $where["tia_nombre LIKE '%$caracteristica%'"] = null;

            $detalle_categoria = $this->gsatelite->get_tabla("tia_tipo_articulo",$where);

        //print_r($this->db->last_query());die();

            echo json_encode($detalle_categoria);

        }

    /**
     * Descripción:
     * Agregar medicamento en la tabla art_articulo (tabla: art_articulo)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param 
     * @return true
     */
    public function agregar_medicamentos($modal=null)
    {
        satelite_validar();
        if ($_POST) {
            //print_r($_POST);die();
            $categoria = ($this->input->post('slccategoria') != '')? $this->input->post('slccategoria') : NULL ;
            $codigo = ($this->input->post('txtcodigo') != '')? $this->input->post('txtcodigo') : NULL ;
            $nombre = ($this->input->post('txtnombre') != '')? $this->input->post('txtnombre') : NULL ;
            $sinonimo = ($this->input->post('txtgenerico') != '')? $this->input->post('txtgenerico') : NULL ;
            $marca = ($this->input->post('slcmarca') != '')? $this->input->post('slcmarca') : NULL ;
            $presentacion = ($this->input->post('slcpresentacion') != '')? $this->input->post('slcpresentacion') : NULL ;
            $fotografia = ($this->input->post('foto_empleado') != '')? $this->input->post('foto_empleado') : NULL ;
            $descripcion = ($this->input->post('txadescripcion') != '')? $this->input->post('txadescripcion') :  NULL ;
            $btn = ($this->input->post('btnCrear') != '')? $this->input->post('btnCrear') : NULL ;

            $articulo = array(
                'art_id_tia' => $categoria,
                'art_id_cda' => NULL,
                'art_id_tgr' => NULL,
                'art_id_mrp' => $marca,
                'art_nombre' => $nombre,
                'art_codigo' => $codigo,
                //'art_codigo_barra' => $art_codigo_barra_tab1,
                'art_sinonimo' => $sinonimo,
                'art_descripcion' => $descripcion,
                'art_foto' => $fotografia,
                'art_minimo' => NULL,
                'art_maximo' => NULL,
                'art_fecha' => date('Y-m-d H:i:s'),
                'art_tipo' => 0,
                'art_aplica_serie' => NULL,
                'art_combo' => 0,
                'art_compra' => 1,
                'art_inventario' => 1,
                'art_venta' => 1,
                'art_materia_prima' => 0,
                'art_gasto' => 0,
                'art_costo' => 0,
                'art_activo_fijo' => 0,
                'art_produccion'    => 0,
                'art_componente'    => 0,
                'art_id_bod'        => null,
                'art_id_sxb'        => NULL,
                'art_aplica_empaque'=> NULL,
                'art_aplica_para_web'=> NULL,
                'art_aplica_cuota'  => NULL, 
                'art_numero_cuota'  => NULL,
                'art_id_ppr'  => $presentacion,
                //'art_codigo_proveedor' => $art_codigo_tab1,
                'art_precio_sugerido' => NULL,
                'art_estado' => 1,
                'art_usu_creacion' => $this->tank_auth->get_user_id(),
                'art_fecha_creacion' => date('Y-m-d H:i:s'),
                'art_usu_modificacion' => $this->tank_auth->get_user_id(),
                'art_fecha_modificacion' => date('Y-m-d H:i:s'),
                'art_anticipo' => NULL);

            $this->gsatelite->ingresar('art_articulo',$articulo);

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Medicamento", 'texto_alerta' => "El registro se guardado correctamente");
            $this->session->set_flashdata($alerta);

            if ($btn == 1) {
                redirect('/modulo_medico/med_mantenimientos/agregar_medicamentos');
            } else {
                redirect('/modulo_medico/med_mantenimientos/medicamentos');
            }

        }

        $tia_dropdown      = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_nombre}', '', '','', '', 'tia_id', true);
        $data['tia_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tia_dropdown);

        $marca_dropdown      = $this->gsatelite->get_dropdown('mrp_marca_producto', '{mrp_nombre}', '', '','', '', 'mrp_id', true);
        $data['marca_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $marca_dropdown);

        $prese_dropdown      = $this->gsatelite->get_dropdown('ppr_presentacion_producto', '{ppr_nombre}', '', '','', '', 'ppr_id', true);
        $data['prese_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $prese_dropdown);

        $data['titulo_personal'] = "Agregar medicamento";

        if ($modal != null) {
            $data['modal'] = 1;
            $this->gsatelite->cargar_vista_masterpage('modulo_medico/med_mantenimientos/agregar_medicamentos',$data);
        } else {
            $data['modal'] = 0;
            $this->_cargarvista($data);
        }
        

    }

     /**
     * Descripción:
     * editar medicamento en la tabla art_articulo (tabla: art_articulo)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param id_articulo
     * @return true
     */
     public function editar_medicamentos($id_art)
     {
        satelite_validar();
        if ($_POST) {
            //print_r($_POST);die();
            $categoria = ($this->input->post('slccategoria') != '')? $this->input->post('slccategoria') : NULL ;
            $codigo = ($this->input->post('txtcodigo') != '')? $this->input->post('txtcodigo') : NULL ;
            $nombre = ($this->input->post('txtnombre') != '')? $this->input->post('txtnombre') : NULL ;
            $sinonimo = ($this->input->post('txtgenerico') != '')? $this->input->post('txtgenerico') : NULL ;
            $marca = ($this->input->post('slcmarca') != '')? $this->input->post('slcmarca') : NULL ;
            $presentacion = ($this->input->post('slcpresentacion') != '')? $this->input->post('slcpresentacion') : NULL ;
            $fotografia = ($this->input->post('foto_empleado') != '')? $this->input->post('foto_empleado') : NULL ;
            $descripcion = ($this->input->post('txadescripcion') != '')? $this->input->post('txadescripcion') :  NULL ;
            $estado = ($this->input->post('slcEstado') != '')? $this->input->post('slcEstado') : 1 ;
            $btn = ($this->input->post('btnCrear') != '')? $this->input->post('btnCrear') : NULL ;

            $articulo = array(
                'art_id_tia' => $categoria,
                'art_id_cda' => NULL,
                'art_id_tgr' => NULL,
                'art_id_mrp' => $marca,
                'art_nombre' => $nombre,
                'art_codigo' => $codigo,
                //'art_codigo_barra' => $art_codigo_barra_tab1,
                'art_sinonimo' => $sinonimo,
                'art_descripcion' => $descripcion,
                'art_foto' => $fotografia,
                'art_minimo' => NULL,
                'art_maximo' => NULL,
                'art_fecha' => date('Y-m-d H:i:s'),
                'art_tipo' => 0,
                'art_aplica_serie' => NULL,
                'art_combo' => 0,
                'art_compra' => 1,
                'art_inventario' => 1,
                'art_venta' => 1,
                'art_materia_prima' => 0,
                'art_gasto' => 0,
                'art_costo' => 0,
                'art_activo_fijo' => 0,
                'art_produccion'    => 0,
                'art_componente'    => 0,
                'art_id_bod'        => null,
                'art_id_sxb'        => NULL,
                'art_aplica_empaque'=> NULL,
                'art_aplica_para_web'=> NULL,
                'art_aplica_cuota'  => NULL, 
                'art_numero_cuota'  => NULL,
                'art_id_ppr'  => $presentacion,
                //'art_codigo_proveedor' => $art_codigo_tab1,
                'art_precio_sugerido' => NULL,
                'art_estado' => $estado,
                'art_usu_creacion' => $this->tank_auth->get_user_id(),
                'art_fecha_creacion' => date('Y-m-d H:i:s'),
                'art_usu_modificacion' => $this->tank_auth->get_user_id(),
                'art_fecha_modificacion' => date('Y-m-d H:i:s'),
                'art_anticipo' => NULL);

            $this->gsatelite->actualizar_array('art_articulo', $articulo, array('art_id' => $id_art));

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Medicamento", 'texto_alerta' => "El registro se Actualizado correctamente");
            $this->session->set_flashdata($alerta);

            if ($btn == 1) {
                redirect('/modulo_medico/med_mantenimientos/editar_medicamentos/'.$id_art);
            } else {
                redirect('/modulo_medico/med_mantenimientos/medicamentos');
            }

        }

        $medicamento = $this->gsatelite->get_tabla("art_articulo",array("art_id" => $id_art));

        $data['medicamento'] = $medicamento;

        $tia_dropdown      = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_nombre}', '', array('tia_estado' => 1),$medicamento[0]['art_id_tia'], '', 'tia_id', true);
        $data['tia_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tia_dropdown);

        $marca_dropdown      = $this->gsatelite->get_dropdown('mrp_marca_producto', '{mrp_nombre}', '', array('mrp_estado' => 1),$medicamento[0]['art_id_mrp'], '', 'mrp_id', true);
        $data['marca_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $marca_dropdown);

        $prese_dropdown      = $this->gsatelite->get_dropdown('ppr_presentacion_producto', '{ppr_nombre}', '', array('ppr_estado' => 1), $medicamento[0]['art_id_ppr'], '', 'ppr_id', true);
        $data['prese_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $prese_dropdown);

        $data['titulo_personal'] = "Agregar medicamento";
        $this->_cargarvista($data);

    }

    /**
     * Descripción:
     * ver medicamento en la tabla art_articulo (tabla: art_articulo)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param id_articulo
     * @return true
     */
    public function ver_medicamentos($id_art)
    {
        satelite_validar();

        $medicamento = $this->gsatelite->get_tabla("art_articulo",array("art_id" => $id_art));

        $data['medicamento'] = $medicamento;

        $tia_dropdown      = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_nombre}', '', array('tia_estado' => 1),$medicamento[0]['art_id_tia'], '', 'tia_id', true);
        $data['tia_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tia_dropdown);

        $marca_dropdown      = $this->gsatelite->get_dropdown('mrp_marca_producto', '{mrp_nombre}', '', array('mrp_estado' => 1),$medicamento[0]['art_id_mrp'], '', 'mrp_id', true);
        $data['marca_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $marca_dropdown);

        $prese_dropdown      = $this->gsatelite->get_dropdown('ppr_presentacion_producto', '{ppr_nombre}', '', array('ppr_estado' => 1), $medicamento[0]['art_id_ppr'], '', 'ppr_id', true);
        $data['prese_dropdown']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $prese_dropdown);

        $data['titulo_personal'] = "Agregar medicamento";
        $this->_cargarvista($data);

    }

    /**
     * Descripción:
     * Mantenimiento para la tabla de medico (tabla: med_medico)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param none
     * @return mantenimiento
     */
    public function medico() {
        satelite_validar();        
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        $crud = new grocery_CRUD();
        $columns = array(
            'med_nombre',
            'med_descripcion',
            'med_id_usu',
            'med_id_epm',
            'med_id_tmd',
            'med_telefono',
            'med_estado',
        );
        $add = array(
            'med_id_usu',
            'med_nombre',
            'med_descripcion',
            'med_id_epm',
            'med_id_tmd',
            'med_telefono',
            'med_estado',
            'med_direccion',
            'med_correo',
            'med_numero_jvpm',
            'med_usu_creacion',
            'med_fecha_creacion',
            'med_usu_modificacion',
            'med_fecha_modificacion',
        );
        $edit = array(        
            'med_id_usu',
            'med_nombre',
            'med_descripcion',
            'med_id_epm',
            'med_id_tmd',
            'med_telefono',
            'med_estado',
            'med_direccion',
            'med_correo',
            'med_numero_jvpm',
            'med_usu_modificacion',
            'med_fecha_modificacion',
        );
        $alias = array(
            'med_id_usu' => 'Usuario',            
            'med_nombre' => 'Nombre',
            'med_descripcion'  => 'Descripcion',
            'med_id_epm'  => 'Especialidad',
            'med_id_tmd' => 'Tipo',
            'med_telefono' => 'Telefono',
            'med_estado'=> 'Estado',
            'med_direccion' => 'Direccion',
            'med_correo' => 'Correo',
            'med_numero_jvpm' => 'No. JVPM'
        );

        $dir = explode('/', uri_string());

        $crud->set_table('med_medico')
        ->set_subject('')
        ->columns($columns)
        ->add_fields($add)
        ->edit_fields($edit)
        ->display_as($alias)
        ->required_fields('med_nombre','med_id_epm')
        ->set_relation('med_id_usu', 'users', 'username', array('activated' => 1))     
        ->set_rules('med_id_usu', 'Usuario', 'trim|required|campo_unico[med_medico.med_id_usu]')
        ->set_relation('med_id_epm', 'epm_especialidad_medica', 'epm_nombre', array('epm_estado'=>1))
        ->set_relation('med_id_tmd', 'tmd_tipo_medico', 'tmd_nombre', array('tmd_estado'=>1))
        ->field_type('med_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('med_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
        //->field_type('med_tipo', 'dropdown', array('1' => 'Externo', '0' => 'Interno'))
        ->callback_field('med_telefono', function($value, $primary_key) {
            return '<input type="text" class="nostyle " id="telefono" name="med_telefono" value="'.$value.'">';
        })
        ->callback_field('med_numero_jvpm', function($value, $primary_key) {
            return '<input type="text" class="nostyle soloNumeros" name="med_numero_jvpm" value="'.$value.'">';
        })
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('med_estado','hidden', 1)
            ->field_type('med_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('med_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $crud->field_type('med_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $output = $crud->render();
        $data['titulo_personal'] = "Medico";
        $data['modal'] = 0;
        $this->_cargarvista($data,$output);
    }

    /**
     * Descripción:
     * Mantenimiento para la tabla de tipo consulta medica (tabla: tcm_tipo_consulta_medica)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param none
     * @return mantenimiento
     */
    public function tipo_consulta_medica(){
        satelite_validar();
        $crud = new grocery_CRUD();
        $columns = array(
            'tcm_nombre',
            'tcm_descripcion',
            'tcm_estado'
        );
        $alias = array(
            'tcm_nombre' => 'Nombre',
            'tcm_descripcion'  => 'Descripcion',
            'tcm_color_alerta' => 'Color',
            'tcm_estado'=> 'Estado'
        );
        $add_columns = array(
            'tcm_nombre',
            'tcm_descripcion',
            'tcm_color_alerta',
            'tcm_estado',
            'tcm_usu_creacion',
            'tcm_fecha_creacion',
            'tcm_usu_modificacion',
            'tcm_fecha_modificacion'
        );
        $edit_columns = array(
            'tcm_nombre',
            'tcm_descripcion',
            'tcm_color_alerta',
            'tcm_estado',
            'tcm_usu_modificacion',
            'tcm_fecha_modificacion'
        );
        $dir = explode('/', uri_string());
        $crud->set_table('tcm_tipo_consulta_medica')
            ->set_subject('')
            ->columns($columns)
            ->display_as($alias)
            ->add_fields($add_columns)
            ->edit_fields($edit_columns)
            ->required_fields('tcm_nombre')
            ->field_type('tcm_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tcm_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
        ;
        if(end(explode('/',uri_string()))=='add') {
            $crud->field_type('tcm_estado','hidden', 1)
                ->field_type('tcm_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tcm_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
            ;
        } else {
            $crud->field_type('tcm_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $crud->callback_field('tcm_color_alerta', function ($value = '', $primary_key = null) {
            $ver = '<table width="10%"><tr><td style="height: 30px; border: solid black 1px; background-color:'.$value.'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td></tr></table>';
            return '<div class="span10" style="display: flex">
                <input type="text" id="field-tcm_color_alerta" name="tcm_color_alerta" style="width:35% !important;display: inline-block;" readonly value="' . $value . '">
                <div id="colorSelector" style="margin-left:7px;"><div style="background-color:' . $value . '"></div></div>
                <div id="read_color" style="margin-left:7px; display: none;">' . $ver . '</div></div>';
        });
        $output = $crud->render();
        $data['titulo_personal'] = "Tipo consulta medica";
        $this->_cargarvista($data,$output);

    }

    /**
     * Descripción:
     * Mantenimiento para la tabla de lugar de cita (tabla: luc_lugar_cita)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-08
     * @param none
     * @return mantenimiento
     */
    public function lugar_cita()
    {
        satelite_validar();
        
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        $crud = new grocery_CRUD();

            //Columnas a mostrar en READ
        $columns = array(
            'luc_nombre',
            'luc_descripcion',
            'luc_estado'
        );

            //Alias para las columnas
        $alias = array(
            'luc_nombre' => 'Nombre',
            'luc_descripcion'  => 'Descripcion',
            'luc_estado'=> 'Estado'
        );

        $dir = explode('/', uri_string());
        $crud->set_table('luc_lugar_cita')
        ->set_subject('')
        ->columns($columns)
        ->display_as($alias)
        ->required_fields('luc_nombre')
        ->field_type('luc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('luc_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
        ->field_type('luc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('luc_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
        ;

        if(end(explode('/',uri_string()))=='add') {
            $crud->field_type('luc_estado','hidden',1);
        } else {
            $crud->field_type('luc_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Lugar cita";
        $this->_cargarvista($data,$output);
    }

    /**
        * Descripción:
        * Mantenimiento para la tabla de tipo procedimientos
        * @author Francisco Orozco - Grupo Satélite
        * @since 2019-09-12
        * @param none
        * @return mantenimiento
    */
    public function tipo_procedimiento(){
        satelite_validar();    
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();
        $columns = array(
            'pcm_nombre',
            'pcm_duraccion_aprox',
            'pcm_descripcion',
            'pcm_estado'
        );
        $alias = array(
            'pcm_nombre'        => 'Nombre',
            'pcm_duraccion_aprox'=> 'Duración apróximada',
            'pcm_descripcion'   => 'Descripción',
            'pcm_estado'        => 'Estado'
        );
        $add_fields= array(
            'pcm_nombre', 
            'pcm_duraccion_aprox',
            'pcm_descripcion',
            'pcm_estado', 
            'pcm_usu_creacion',
            'pcm_fecha_creacion',
            'pcm_usu_modificacion',
            'pcm_fecha_modificacion'
        );
        $edit_fields= array(
            'pcm_nombre', 
            'pcm_duraccion_aprox',
            'pcm_descripcion',
            'pcm_estado', 
            'pcm_usu_modificacion',
            'pcm_fecha_modificacion'
        );
        $required = array(
            'pcm_nombre', 
            'pcm_duraccion_aprox',
            'pcm_estado', 
            'pcm_usu_modificacion',
            'pcm_fecha_modificacion'
        );
        $crud->set_table('pcm_procedimiento_medico')
        ->add_fields($add_fields)
        ->edit_fields($edit_fields)
        ->required_fields($required)
        ->display_as($alias)
        ->columns($columns)
        ->field_type('pcm_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('pcm_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('pcm_estado', 'hidden', 1)
            ->field_type('pcm_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('pcm_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $crud->field_type('pcm_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if(!$permisos["permite_editar"]){
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }
        $output = $crud->render();
        $data['titulo_personal'] = 'Tipo de procedimientos';
        $data['modal'] = 0;
        $this->_cargarvista($data,$output);
    }

    /**
        * Descripción:
        * Mantenimiento para la tabla de anestesia
        * @author Francisco Orozco - Grupo Satélite
        * @since 2019-09-23
        * @param none
        * @return mantenimiento
    */
    public function anestesia(){
        satelite_validar();    
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();

        $columns = array(
            'tan_nombre',
            'tan_descripcion',
            'tan_estado'
        );

        $alias = array(
            'tan_nombre'        => 'Nombre',
            'tan_descripcion'   => 'Descripcion',
            'tan_estado'        => 'Estado'
        );     

        $add_fields= array(
            'tan_nombre', 
            'tan_descripcion',
            'tan_estado', 
            'tan_usu_creacion',
            'tan_fecha_creacion',
            'tan_usu_modificacion',
            'tan_fecha_modificacion'
        );

        $edit_fields= array(
            'tan_nombre', 
            'tan_descripcion',
            'tan_estado', 
            'tan_usu_modificacion',
            'tan_fecha_modificacion'
        );

        $required = array(
            'tan_nombre',             
            'tan_estado', 
            'tan_usu_modificacion',
            'tan_fecha_modificacion'
        );

        $crud->set_table('tan_tipo_anestesia')
        ->add_fields($add_fields)
        ->edit_fields($edit_fields)
        ->required_fields($required)
        ->display_as($alias)
        ->columns($columns)
        ->field_type('tan_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('tan_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
        ;

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tan_estado', 'hidden', 1)
            ->field_type('tan_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tan_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $crud->field_type('tan_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if(!$permisos["permite_editar"]){
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {

        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Tipo de Anestesias';
        $this->_cargarvista($data, $output);
    }

    /**
     * Descripción:
     * mantenimiento de tipo_medico (tabla: tmd_tipo_medico)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2019-08-10
     * @param none
     * @return none
     */
    public function tipo_medico() {
        satelite_validar();

        $crud = new grocery_CRUD();
        //Columnas a mostrar en READ
        $columns = array(
            'tmd_nombre',
            'tmd_descripcion',
            'tmd_estado'
        );

        $add_fields= array(
            'tmd_nombre', 
            'tmd_descripcion',
            'tmd_principal', 
            'tmd_anestesia',
            'tmd_ayudante',
            'tmd_estado',
            'tmd_usu_creacion',
            'tmd_fecha_creacion',
            'tmd_usu_modificacion',
            'tmd_fecha_modificacion'
        );

        $edit_fields= array(
            'tmd_nombre', 
            'tmd_descripcion',
            'tmd_principal', 
            'tmd_anestesia',
            'tmd_ayudante',
            'tmd_estado',
            'tmd_usu_modificacion',
            'tmd_fecha_modificacion'
        );

        //Alias para las columnas
        $alias = array(
            'tmd_nombre' => 'Nombre',
            'tmd_descripcion' => 'Descripcion',
            'emd_estado' => 'Estado',
            'tmd_principal' => 'Medico' ,
            'tmd_anestesia' => 'Anestesiólogo',
            'tmd_ayudante' => 'Ayudante'
        );

        $crud->set_table('tmd_tipo_medico')
        ->set_subject('')
        ->add_fields($add_fields)
        ->edit_fields($edit_fields)
        ->columns($columns)
        ->display_as($alias)
        ->required_fields('tmd_nombre')
        ;

        $crud->callback_add_field('tmd_principal', function() {
            return '<input type="checkbox" id="chb_principal" data-name="tmd_principal" class="nostyle check_box"><input type="hidden" id="field-tmd_principal" name="tmd_principal" value="0">';
        });
        $crud->callback_edit_field('tmd_principal', function ($value, $primary_key) {
            $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
            $defecto =  ($value) ? 'checked' : '';
            return '<input type="checkbox" id="chb_principal" data-name="tmd_principal" class="' . $leer . ' nostyle check_box" ' . $defecto . '><input type="hidden" id="field-tmd_principal" name="tmd_principal" value="' . $value . '">';
        });
        $crud->callback_add_field('tmd_anestesia', function() {
            return '<input type="checkbox" id="chb_anestesia" data-name="tmd_anestesia" class="nostyle check_box"><input type="hidden" id="field-tmd_anestesia" name="tmd_anestesia" value="0">';
        });
        $crud->callback_edit_field('tmd_anestesia', function ($value, $primary_key) {
            $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
            $defecto =  ($value) ? 'checked' : '';
            return '<input type="checkbox" id="chb_anestesia" data-name="tmd_anestesia" class="' . $leer . ' nostyle check_box" ' . $defecto . '><input type="hidden" id="field-tmd_anestesia" name="tmd_anestesia" value="' . $value . '">';
        });
        $crud->callback_add_field('tmd_ayudante', function() {
            return '<input type="checkbox" id="chb_ayudante"  data-name="tmd_ayudante" class="nostyle check_box"><input type="hidden" id="field-tmd_ayudante" name="tmd_ayudante" value="0">';
        });
        $crud->callback_edit_field('tmd_ayudante', function ($value, $primary_key) {
            $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
            $defecto =  ($value) ? 'checked' : '';
            return '<input type="checkbox" id="chb_ayudante" data-name="tmd_ayudante" class="' . $leer . ' nostyle check_box" ' . $defecto . '><input type="hidden" id="field-tmd_ayudante" name="tmd_ayudante" value="' . $value . '">';
        });

        if(end(explode('/',uri_string()))=='add') {
           $crud->field_type('tmd_estado','hidden',1);
       } else {
           $crud->field_type('tmd_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
       }
       $crud->field_type('tmd_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
       $crud->field_type('tmd_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
       $crud->field_type('tmd_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
       $crud->field_type('tmd_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
/*            $crud->add_action('Ver', 'minia-icon-search', 'modulo_medico/med_mantenimientos/ver_aseguradora');
$crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'modulo_medico/med_mantenimientos/editar_aseguradora');*/
$output = $crud->render();

$data['titulo_personal'] = "Tipo Medico";
$this->_cargarvista($data,$output);
}

public function agregar_formato_aseguradora($id=0)
{
    satelite_validar();
    $data['id_aseguradora'] = $id;
    $data['archivos'] = $this->medico_model->get_archivos_aseguradora($id);

    $data['titulo_personal'] = "Agregar Formato Aseguradoras";
    $this->_cargarvista($data);

}

public function guardar_formato_aseguradora()
{

    if ($this->input->post('txtNombreDocumento')=="" || $this->input->post('txtNombreDocumento') == null) {
        redirect('modulo_medico/med_mantenimientos/agregar_formato_aseguradora/'.$this->input->post('idAseguradora'));
    }

    $guardar_Formato = array(
        'frm_id_ase' => $this->input->post('idAseguradora'),
        'frm_nombre' => $this->input->post('txtNombreDocumento'),
        'frm_descripcion' => $this->input->post('txtDescripcionDocumento'),
        'frm_archivo' => $this->input->post('txtRutaArchivo'),
        'frm_estado' => 1,
        'frm_activo' => 1,
        'frm_usu_creacion' => $this->tank_auth->get_user_id(),
        'frm_fecha_creacion' => date('Y-m-d h:i:s'),
        'frm_usu_modificacion' => $this->tank_auth->get_user_id(),
        'frm_fecha_modificacion' => date('Y-m-d h:i:s')
    );

    $save = $this->gsatelite->ingresar('frm_formulario_medico', $guardar_Formato, false);

    if ($save>0 ) {
        redirect('modulo_medico/med_mantenimientos/agregar_formato_aseguradora/'.$this->input->post('idAseguradora'));
    }else{

    }
}

public function new_crud() {
    $db_driver = $this->db->platform();
    $model_name = 'grocery_crud_model_' . $db_driver;
    $model_alias = 'm' . substr(md5(rand()), 0, rand(4, 15));
    unset($this->{$model_name});
    $this->load->library('grocery_CRUD');
    $crud = new Grocery_CRUD();
    if (file_exists(APPPATH . '/models/' . $model_name . '.php')) {
        $this->load->model('grocery_crud_generic_model');
        $this->load->model($model_name, $model_alias);
        $crud->basic_model = $this->{$model_alias};
    }
    return $crud;
}

public function delete_formato()
{
    $delete = $this->medico_model->delete_formato($this->input->post('frm_id'));

    if ($delete>0) {
        $json['error'] = 0;
        $url = $this->medico_model->get_url_archivo($this->input->post('frm_id'));
        unlink($url->frm_archivo);
    }else{
        $json['error'] = 1;
    }

    echo json_encode($json);
}

    public function motivo_emergencia(){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();
        $columns = array(
            'mem_codigo',
            'mem_motivo',
            'mem_descripcion',
            'mem_estado',
        );

        $alias = array(
            'mem_codigo' => 'Código',
            'mem_motivo' => 'Nombre',
            'mem_descripcion' => 'Descripción',
            'mem_estado' => 'Estado',
        );

        $add_fields = array(
            'mem_codigo',
            'mem_motivo',
            'mem_descripcion',
            'mem_estado',
            'mem_usu_creacion',
            'mem_fecha_creacion',
            'mem_usu_modificacion',
            'mem_fecha_modificacion',
        );

        $edit_fields = array(
            'mem_codigo',
            'mem_motivo',
            'mem_descripcion',
            'mem_estado',
            'mem_usu_modificacion',
            'mem_fecha_modificacion'
        );

        $required = array(
            'mem_codigo',
            'mem_motivo',
            'mem_estado',
        );        

        $crud->set_table('mem_motivo_emergencia')
            ->set_subject('')
            ->columns($columns)
            ->add_fields($add_fields)
            ->edit_fields($edit_fields)
            ->display_as($alias)
            ->required_fields($required)
        ;

        $crud->set_rules('mem_estado', 'Estado', 'required');
        $crud->set_rules('mem_motivo', 'Nombre', 'trim|required|campo_unico[mem_motivo_emergencia.mem_motivo]');
        $crud->set_rules('mem_codigo', 'Código', 'trim|required|campo_unico[mem_motivo_emergencia.mem_codigo]');

        $uri_segments = explode('/', uri_string());
        if (end($uri_segments) == 'add') {
            $crud->field_type('mem_estado', 'hidden', 1);
            $crud->field_type('mem_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('mem_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        } else {
            $crud->field_type('mem_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $crud->field_type('mem_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('mem_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
            $crud->unset_print();
            $crud->unset_export();
        }
        
        $output = $crud->render();
        $data['titulo_personal'] = "Motivo Emergencia";

        cargarvista($data, $output);
    }  
    
    /**
    * Descripción:
    * Mantenimiento para la tabla de clasificacion emerencia
    * @author Eduardo Mejia - Grupo Satélite
    * @since 2024-06-20
    * @param none
    * @return mantenimiento
    */
    public function clasificacion_emergencia(){
        satelite_validar();    
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();

        $columns = array(
            'cle_nivel',
            'cle_codigo',
            'cle_nombre',
            'cle_color',
            'cle_tiempo'
        );

        $alias = array(
            'cle_codigo' => "Código",
            'cle_nombre' => "Tipo de urgencia",
            'cle_nivel' => "Nivel",
            'cle_color' => "Color",
            'cle_tiempo' => "Tiempo promedio",
            'cle_estado' => "Estado",
            // 'cle_id_tcm' => "Tipo consulta médica",
        );     

        $add_fields= array(
            'cle_codigo',
            'cle_nombre',
            'cle_nivel',
            'cle_color',
            'cle_tiempo',
            // 'cle_id_tcm',
            'cle_estado',
            'cle_usu_creacion',
            'cle_fecha_creacion',
            'cle_usu_modificacion',
            'cle_fecha_modificacion',
        );

        $edit_fields= array(
            'cle_codigo',
            'cle_nombre',
            'cle_nivel',
            'cle_color',
            'cle_tiempo',
            // 'cle_id_tcm',
            'cle_estado',
            'cle_usu_modificacion',
            'cle_fecha_modificacion',
        );

        $required = array(
            'cle_codigo',
            'cle_nombre',
            'cle_nivel',
            'cle_color',
            // 'cle_id_tcm',
        );

        $crud->set_table('cle_clasificacion_emergencia')
        ->add_fields($add_fields)
        ->set_subject('')        
        ->edit_fields($edit_fields)
        ->required_fields($required)
        ->display_as($alias)
        ->columns($columns)
        ->field_type('cle_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('cle_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
        ;

        $tipo_accion = $crud->getState();

        $crud->callback_column('cle_tiempo', array($this, '_add_min_text'));

        $tipo_accion = $crud->getState();        
        if ($tipo_accion != 'export' && $tipo_accion != 'print') {
            $crud->callback_column('cle_color',array($this,'_callback_column_color'));        
        }

        $crud->set_rules('cle_codigo', 'Código', 'trim|required|campo_unico[cle_clasificacion_emergencia.cle_codigo]');
        $crud->set_rules('cle_nombre', 'Tipo de urgencia', 'trim|required|campo_unico[cle_clasificacion_emergencia.cle_nombre]');
        $crud->set_rules('cle_nivel', 'Nivel', 'trim|required|campo_unico[cle_clasificacion_emergencia.cle_nivel]');
        $crud->set_rules('cle_color', 'Color', 'trim|required');

        $crud->callback_before_insert(array($this, '_set_default_cle_tiempo'));
        $crud->callback_before_update(array($this, '_set_default_cle_tiempo'));    

        $esVer = ($tipo_accion == 'read') ? 'display:none;' : '';
        $crud->callback_field('cle_color', function ($value = '', $primary_key = null) use ($esVer) {
            return '<input type="text" id="field-cle_color" name="cle_color" style="width:35% !important;display: inline-block;" readonly="" value="'. $value .'" class="text">
            <input type="color" id="select_color" name="select_color" style="width:10% !important;display: inline-block;" value="'. $value .'"> <span style="text-color: #0A25E3; text-decoration: underline; margin-left:10px; cursor: pointer; '. $esVer .'" id="clean_color">Limpiar</>';
        });             

        // $crud->set_relation('cle_id_tcm','tcm_tipo_consulta_medica','tcm_nombre', ['tcm_estado' => 1]);       


        $uri_segments = explode('/', uri_string());
        if (end($uri_segments) == 'add') {
            $crud->field_type('cle_estado', 'hidden', 1)
            ->field_type('cle_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('cle_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $crud->field_type('cle_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if(!$permisos["permite_editar"]){
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {

        }

        $crud->set_subject('Clasificación Emergencia');
        $output = $crud->render();
        $data['titulo_personal'] = 'Clasificación Emergencia';
        $this->_cargarvista($data, $output);
    } 

    public function _add_min_text($value, $row)
    {
        $text = "";
        if ($value != null && $value != "" && $value != 0){
            $text = $value . ' min';
        }
        return $text;
    }

    public function _callback_column_color($value, $row) {
      return "<div style='padding: 5px; background-color: white; text-align: center;'><div style='border:1px solid black; width:60% !important; height:16px; display: inline-block; background-color: " . htmlspecialchars($value) . "'></div></div>";
    } 

    public function configuracion_consultorio(){
        satelite_validar();  
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();     

        // Indica si una peticion ajax
        $flag = $this->input->post('flag');
        $flag = isset($flag) ? $flag : null;
        $medico = null;

        if ($flag != null) {
            $slcUbicacion = $this->input->post('slcUbicacion');
            $slcMedico = $this->input->post('slcMedico');

            $where = [];
            if ($slcUbicacion > 0) {
                $where['con_id_suc'] = $slcUbicacion;
            }
            if ($slcMedico != '') {
                $where['con_id_med'] = $slcMedico;
                $medico = $slcMedico;
            }

            $crud->where($where);  
        }

        $auditoria_cxc = array(
           'cxc_estado' => 1,
           'cxc_usu_creacion' => $this->tank_auth->get_user_id(),
           'cxc_usu_modificacion' => $this->tank_auth->get_user_id(),
           'cxc_fecha_modificacion' => date('Y-m-d H:i:s'),
           'cxc_fecha_creacion' => date('Y-m-d H:i:s')
        );

        $auditoria_txc = array(
           'txc_estado' => 1,
           'txc_usu_creacion' => $this->tank_auth->get_user_id(),
           'txc_usu_modificacion' => $this->tank_auth->get_user_id(),
           'txc_fecha_modificacion' => date('Y-m-d H:i:s'),
           'txc_fecha_creacion' => date('Y-m-d H:i:s')
        );

        $columns = array(
            'con_id_suc',
            'con_nombre',
            'con_id_med',
            'con_id_bod',
            // 'con_estado_disponible',
            'clasificacion_emergencia',
            'tipo_consulta'
        );

        $alias = array(
            'con_id_suc' => "Ubicación",
            'con_nombre' => "Nombre consultorio",
            'con_id_med' => "Médico asignado",
            'con_id_bod' => "Bodega",
            'con_descripcion' => "Descripción",
            'con_estado_disponible' => "Estado",
            'con_estado' => "Estado",
            'clasificacion_emergencia' => 'Clasificación emergencia',
            'tipo_consulta' => 'Tipo de consulta'
        );     

        $add_fields= array(
            'con_id_suc',
            'con_nombre',
            'con_descripcion',
            'con_id_med',
            'con_id_bod',
            'con_estado',
            'con_estado_disponible',
            'con_usu_creacion',
            'con_fecha_creacion',
            'con_usu_modificacion',
            'con_fecha_modificacion',
            'clasificacion_emergencia',
            'tipo_consulta'
        );

        $edit_fields= array(
            'con_id_suc',
            'con_nombre',
            'con_descripcion',
            'con_id_med',
            'con_id_bod',
            'con_estado',
            // 'con_estado_disponible',
            'con_usu_modificacion',
            'con_fecha_modificacion',
            'clasificacion_emergencia',
            'tipo_consulta'
        );

        $required = array(
            'con_id_suc',
            'con_nombre',
            'con_id_med',
            'con_id_bod',
        );

        $crud->set_table('con_consultorio')
        ->add_fields($add_fields)
        ->set_subject('')        
        ->edit_fields($edit_fields)
        ->required_fields($required)
        ->display_as($alias)
        ->columns($columns)
        ->field_type('con_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('con_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
        ->field_type('con_estado_disponible', 'hidden', 1)
        ->set_relation('con_id_suc','suc_sucursal','suc_nombre')        
        ->set_relation('con_id_med','med_medico','med_nombre', array('med_estado'=>'1'))   
        ->set_relation('con_id_bod','bod_bodega','bod_nombre', array('bod_estado'=>'1'))   
        ->set_relation_n_n('clasificacion_emergencia','cxc_clasificacion_emergenciaxconsultorio', 'cle_clasificacion_emergencia', 
          'cxc_id_con', 'cxc_id_cle', '{cle_nombre}', null,null, $auditoria_cxc)

        ->set_relation_n_n('tipo_consulta','txc_tipo_consultaxconsultorio', 'tcm_tipo_consulta_medica', 
          'txc_id_con', 'txc_id_tcm', '{tcm_nombre}', null,null, $auditoria_txc);
        $crud->set_rules('tac_nombre','Nombre del tipo de activo fijo','required');
        ;

        $tipo_accion = $crud->getState();  
        if ($tipo_accion != 'export' && $tipo_accion != 'print') {
            $crud->callback_column('con_estado_disponible', function($value, $row) use ($medico) {
                return $this->_callback_column_estado_consultorio($value, $row, $medico);
            });            
        }

        $uri=explode('/',uri_string());
        $url=$uri[0].'/'.$uri[1];            
        // $crud->add_action('Llamar paciente', 'minia-icon-user', 'modulo_medico/med_procesos/llamar_paciente','ui-icon-plus llamar_paciente ');        

        $data['tipo_accion'] = $tipo_accion;

        $crud->set_rules('con_nombre', 'Nombre consultorio', 'trim|required|campo_unico[con_consultorio.con_nombre]');        

        $crud->set_rules('con_id_med', 'Médico', 'trim|required|campo_unico[con_consultorio.con_id_med]');

        $uri_segments = explode('/', uri_string());
        $crud->field_type('con_estado_disponible', 'hidden');
        if (end($uri_segments) == 'add') {
            $crud->field_type('con_estado', 'hidden', 1)
            ->field_type('con_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('con_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $crud->field_type('con_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $crud->callback_before_insert(array($this, '_set_default_con_estado_disponible'));
        // $crud->callback_before_update(array($this, '_set_default_con_estado_disponible'));         

        if ($tipo_accion == 'list' || $tipo_accion == 'success') {
            
            $userId = $this->tank_auth->get_user_id();
            $usc_usuario_sucursal = $this->gsatelite->get_tabla('usc_usuario_sucursal', array('usc_id_usu' => $userId));
            $whereSlcSucursal = null;
            $selectedSucursal = null;   

            // Se obtendran solo las sucursales que tenga asignado el usuario
            // Si no tiene asignada sucursal se mostraran todas las sucursales
            if (count($usc_usuario_sucursal) > 0) {
                $sucursalesId = array_column($usc_usuario_sucursal, 'usc_id_suc');
                $sucursalesId = implode(',', $sucursalesId);

                // Si solo es un registro se selecciona por defecto
                if (count($usc_usuario_sucursal) == 1) {
                    $selectedSucursal = $sucursalesId;
                }

                $whereSlcSucursal["suc_id IN ({$sucursalesId})"] = null;
            }

            $data['slcUbicacion'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', $whereSlcSucursal, $selectedSucursal, '', 'suc_id', true);     

            $data['slcMedico'] = $this->gsatelite->get_dropdown('med_medico', '{med_nombre}', '', ['med_estado' => 1], null, '', 'med_id', true);     
        }        

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if(!$permisos["permite_editar"]){
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        $crud->unset_print();
        $crud->unset_delete();
        $crud->unset_export();

        if ($permisos['permite_ver']) {

        }

        $crud->set_subject('Configuración consultorio');
        $output = $crud->render();
        $data['titulo_personal'] = 'Configuración consultorio';

        if ($flag == null) {
            $this->_cargarvista($data, $output);
        } else {
            print($output->output);
        }        
    }      

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */