<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Procesos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('gestion_documental_model');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Modulo de Compras';
            $this->_cargarvista(null, $data);
        }
    }

    /**
     * @author René Castaneda
     * @since 16-07-2018
     * @return mantenimiento ubicación de archivos
     */
    function ubicacion_archivo() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();

        $add = array(
            'uba_nombre',
            'uba_id_padre',
            'uba_descripcion',
            'uba_estado',
            'uba_usu_modificacion',
            'uba_fecha_modificacion',
            'uba_usu_creacion',
            'uba_fecha_creacion'
        );

        $edit = array(
            'uba_nombre',
            'uba_id_padre',
            'uba_descripcion',
            'uba_estado',
            'uba_usu_modificacion',
            'uba_fecha_modificacion'
        );

        $column = array(
            'uba_nombre',
            'uba_id_padre'
        );

        $display = array(
            'uba_nombre' => 'Nombre Ubicación',
            'uba_id_padre' => 'Dependencia',
            'uba_descripcion' => 'Descripción',
            'uba_estado' => 'Estado'
        );

        $requeridos = array(
            'uba_nombre',
            'uba_estado'
        );

        $crud->set_table('uba_ubicacion_archivo')
                ->set_subject('Ubicación archivo')
                ->columns($column)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($requeridos)
                ->display_as($display)
                ->set_relation('uba_id_padre', 'uba_ubicacion_archivo', 'uba_nombre', array('uba_estado' => 1))
                ->field_type('uba_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('uba_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('uba_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('uba_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
        //  ->set_rules('uba_nombre', 'Nombre', 'trim|required|campo_unico2[uba_ubicacion_archivo.uba_nombre.uba_id_padre.0]') 
        ;

        $crud->callback_after_insert(function($post_array, $primary_key) {


            //DESPUES DE QUE SE HAYA REALIZADO LA INSERCCION DEL REGISTRO 
            //SE DEBERAN CREAR LA CARPETA CORRESPONDIENTE

            $ruta_upload_files = $this->gsatelite->get_parametro('SYS_MASTER_ARCHIVE')??"archivos_modulo_gestion";

            $carpeta = clean_string($post_array["uba_nombre"]);
            if ($post_array["uba_id_padre"] > 0) {
                $ruta_carpeta = $this->formar_ruta_carpeta($post_array["uba_id_padre"]);
                $ruta = FCPATH . "uploads/$ruta_upload_files/" . $ruta_carpeta . $carpeta;
            } else {
                $ruta = FCPATH . "uploads/$ruta_upload_files/" . $carpeta;
            }
            
            $array_update = array(
                'uba_nombre_clean' => $carpeta,
                'uba_ruta' => str_replace(FCPATH, "", $ruta)
            );
            $this->gsatelite->actualizar_array("uba_ubicacion_archivo", $array_update, array('uba_id' => $primary_key));
            if (!file_exists($ruta)) {
                mkdir($ruta, 0777);
                //copiar el index.html para evitar listar el directorio
                @copy('uploads/'.$ruta_upload_files.'/index.html', (str_replace(FCPATH, '', $ruta).'/index.html'));
            }

            //print_r($post_array); die();
            return TRUE;
        });
        $crud->callback_after_update(function($post_array, $primary_key) {

            //DESPUES DE QUE SE HAYA REALIZADO LA ACTUALIZACION DEL REGISTRO 
            //SE DEBERAN ACTUALIZAR LA CARPETA
            return TRUE;
        });

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('uba_estado', 'hidden', 1);
        } else {
            $crud->field_type('uba_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        //$crud->unset_add();
        $crud->unset_edit();
        $crud->unset_delete();
        $crud->unset_export()->unset_print();

        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        /*
          if (!$permisos['permite_editar']) {
          $crud->unset_edit();
          }

          if (!$permisos['permite_eliminar']) {
          $crud->unset_delete();
          }

          if (!$permisos['permite_ver']) {
          $crud->unset_read();
          }
         */

        $data['titulo_personal'] = "Ubicación de archivos";

        $output = $crud->render();
        cargarvista($data, $output);
    }

    /**
     * @author René Castaneda - Grupo Satélite
     * @since 2018-07-17
     * @return ruta completa de ubicación
     * Descripción:
     * Función para genrar la ruta completa de una carpeta
     */
    public function formar_ruta_carpeta($key) {
        $establecer_ruta = "";
        if ($key > 0) {
            $query = $this->gsatelite->get_tabla("uba_ubicacion_archivo", array('uba_id' => $key));
            if ($query[0]["uba_id_padre"] > 0) {
                $establecer_ruta = $query[0]["uba_nombre_clean"] . "/" . $establecer_ruta;
                $establecer_ruta = $this->formar_ruta_carpeta($query[0]["uba_id_padre"]) . "/" . $establecer_ruta;
            } else {
                $establecer_ruta = $query[0]["uba_nombre_clean"] . "/" . $establecer_ruta;
            }
        }
        return $establecer_ruta;
    }

    /**
     * @author René Castaneda - Grupo Satélite
     * @since 2018-07-17
     * @return Gestión de archivos.
     * Descripción:
     * Función para gestionar archivos.
     */
    public function gestion_archivos() {

        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['titulo_personal'] = "Gestión de Archivos";
        cargarvista($data);
    }

    /**
     * @author René Castaneda - Grupo Satélite
     * @since 2018-07-17
     * @return Gestión de archivos.op2
     * Descripción:
     * Función para gestionar archivos.op2
     */
    public function navegador_archivos() {
        satelite_validar();
        $data['titulo_personal'] = "Archivos";
        $this->gsatelite->cargar_vista_masterpage('modulo_gestion_documental/procesos/navegador_archivos', $data);
        //cargarvista($data);
    }

    /**
     * @author René Castaneda - Grupo Satélite
     * @since 2018-07-17
     * @return Buscador Archivos.
     * Descripción:
     * Función para buscar archivos.
     */
    public function buscador_archivos() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['titulo_personal'] = "Buscador de archivos";
        $slcSelect = $this->gsatelite->get_dropdown('cag_categoria_gestion', '{cag_nombre}', '', array('cag_estado' => 1), null, '', 'cag_id', true);
        $data["slcCategoria"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $slcSelect);

        $slcSelect = $this->gsatelite->get_dropdown('eqa_etiqueta_archivo', '{eqa_nombre}', '', array('eqa_estado' => 1), null, '', 'eqa_id', true);
        $data["slcEtiqueta"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $slcSelect);

        $slcSelect = $this->gsatelite->get_dropdown('tpa_tipo_archivo', '{tpa_nombre}', '', array('tpa_estado' => 1), null, '', 'tpa_id', true);
        $data["slcTipo"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $slcSelect);

        $this->db->join("emp_empleado", "emp_id = usu_id_emp");
        $slcSelect = $this->gsatelite->get_dropdown('users', '{emp_nombre} {emp_apellido}', '', array('activated' => 1), null, '', 'id', true);
        $data["slcUsuario"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $slcSelect);

        $data["filtros_metadata"] = $this->gestion_documental_model->obtener_filtro_metadata_gestor_archivos();


        $data["mapping"] = $this->gsatelite->get_parametro_emp('SYS-FILE-MANAGER-MAPPING');


        $data['permisos'] = $permisos;
        cargarvista($data);
    }


    public function filtrar_buscador_archivos() {
        satelite_validar();
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('buscador_archivos');
        $data['permisos'] = $permisos;

        // Capturar los valores de los filtros estáticos
        $txtFecha_creacion_desde = $this->input->post('txtFecha_creacion_desde');
        $txtFecha_actualiza_desde = $this->input->post('txtFecha_actualiza_desde');


        $txtFecha_creacion_hasta = $this->input->post('txtFecha_creacion_hasta');
        $txtFecha_actualiza_hasta = $this->input->post('txtFecha_actualiza_hasta');


        $slcCategoria = $this->input->post('slcCategoria');
        $slcEtiqueta = $this->input->post('slcEtiqueta');
        $txtNombre = $this->input->post('txtNombre');
        $slcTipo = $this->input->post('slcTipo');
        $slcUsuario = $this->input->post('slcUsuario');
        $txtKeyword = $this->input->post('txtKeyword');

        // Capturar los valores de los filtros dinámicos
        $filtros_metadata = $this->input->post('filtros_metadata');

        $where['arh_estado'] = 1;
        if ($this->input->post()) {
            if (!empty($txtFecha_creacion_desde) && !empty($txtFecha_creacion_hasta)) {

                $where["DATE(arh_fecha) BETWEEN '$txtFecha_creacion_desde' AND '$txtFecha_creacion_hasta'"] = null;//formatear_fecha('Y-m-d', $txtFecha_creacion);

            }

            if (!empty($txtFecha_actualiza_desde) && !empty($txtFecha_actualiza_hasta)) {

                $where["DATE(arh_fecha_actualiza) BETWEEN '$txtFecha_actualiza_desde' AND '$txtFecha_actualiza_hasta'"] = null;//formatear_fecha('Y-m-d', $txtFecha_actualiza);

            }

            if (!empty($slcCategoria)) {
                $where['cag_id'] = $slcCategoria;
            }
            if (!empty($slcEtiqueta) && is_array($slcEtiqueta)) {
                $where['eqa_id in (' . implode(',', $slcEtiqueta) . ')'] = null;
            }
            if (!empty($slcTipo)) {
                $where['arh_id_tpa'] = $slcTipo;
            }
            if (!empty($slcUsuario)) {
                $where['arh_id_usu'] = $slcUsuario;
            }
            if (!empty($txtNombre)) {
                $where['arh_nombre LIKE'] = "%".$txtNombre."%";
            }
            if (!empty($txtKeyword)) {
                $where["arh_keywords LIKE"] = "%".$txtKeyword."%";
            }
        }

        $where_metadata = [];

        if (!empty($filtros_metadata) && is_array($filtros_metadata)) {
            foreach ($filtros_metadata as $campo => $valor) {
                if (!empty($valor)) {
                    if (strpos($campo, '_desde') !== false) {
                        $campo_real = str_replace('_desde', '', $campo);
                        $where_metadata[$campo_real]['desde'] = date('Y-m-d', strtotime($valor));
                    } elseif (strpos($campo, '_hasta') !== false) {
                        $campo_real = str_replace('_hasta', '', $campo);
                        $where_metadata[$campo_real]['hasta'] = date('Y-m-d', strtotime($valor));
                    } else {
                        $where_metadata[$campo] = $valor;
                    }
                }
            }
        }



        // Pasar filtros al modelo
        $registros = $this->gestion_documental_model->get_archivos($where, $where_metadata);

        $data['registros'] = $registros;
        $html = $this->load->view('modulo_gestion_documental/procesos/filtrar_buscador_archivos', $data, true);
        echo json_encode(array('html' => $html));
    }



    /**
     * @author Mario Marquez
     * @return mantenimiento de categoria de gestión de archivos
     * @since 11-07-2018
     */
    function archivos($consulta = 0) {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        if ($this->input->post()) {
            if ($consulta > 0) {
                $post_array = $this->input->post();

                $fecha_inicio = $post_array['fecha_ini'];
                $fecha_fin = $post_array['fecha_fin'];
                $categoria = $post_array['categoria'];

                $where = null;

                if ($fecha_inicio != '' && $fecha_fin != '') {
                    $where['DATE(arh_fecha) >='] = formatear_fecha('Y-m-d', $fecha_inicio);
                    $where['DATE(arh_fecha) <='] = formatear_fecha('Y-m-d', $fecha_fin);
                }
                if ($categoria != '') {
                    //$where['arh_id_cag'] = $categoria;
                }
                $archivos = $this->gestion_documental_model->get_archivos($where);

                $data['archivos'] = $archivos;

                $html = $this->load->view('modulo_gestion_documental/procesos/consultar_archivos', $data, true);

                echo $html;
                die();
            }
        } else {
            $data['lstCategorias'] = $this->gsatelite->get_dropdown('cag_categoria_gestion', 'cag_nombre', '', array('cag_estado' => 1), null, null, null, true);
            $data['titulo_personal'] = 'Listado de Archivos';
            cargarvista($data);
        }
    }

    function agregar_archivo() {
        satelite_validar();
        try {
            $num_actual = $this->gsatelite->count('arh_archivo');
            $num_actual += 1;
            //Se genera el codigo del aviso
            $codigo_archivo = 'AR' . generar_codigo_cor($num_actual, 4);
            if ($this->input->post()) {
                $post_array = $this->input->post();
                //print_r($post_array);die();
                //die(var_dump($post_array));
                $tipo_btn = $post_array['btnCrear'];
                $archivo_array = array(
                    "arh_id_usu" => $this->tank_auth->get_user_id(),
                    "arh_id_usu_actualiza" => $this->tank_auth->get_user_id(),
                    "arh_id_tpa" => $post_array['slcTipo'],
                    "arh_id_uba" => $post_array['slcUbicacion'],
                    "arh_codigo" => $post_array['txtCodigoArchivo'],
                    "arh_nombre" => $post_array['txtNombreArchivo'],
                    "arh_descripcion" => $post_array['txtDescripcion'],
                    "arh_url_archivo" => $post_array['hdnArchivo'],
                    "arh_size" => $post_array['hdnTamanio'],
                    "arh_fecha" => date('Y-m-d H:i:s'),
                    "arh_fecha_actualiza" => date('Y-m-d H:i:s'),
                    "arh_comentario" => "",
                    "arh_keywords" => $post_array['txtKeyword'],
                    "arh_estado" => 1,
                    "arh_usu_creacion" => $this->tank_auth->get_user_id(),
                    "arh_fecha_creacion" => date('Y-m-d H:i:s'),
                    "arh_usu_modificacion" => $this->tank_auth->get_user_id(),
                    "arh_fecha_modificacion" => date('Y-m-d H:i:s')
                );

                $arh_id = $this->gsatelite->ingresar('arh_archivo', $archivo_array);

                if ($arh_id > 0) {
                    //Se busca la ruta de la carpeta
                    $rutaUbicacion = $this->gsatelite->get_campo('uba_ubicacion_archivo', 'uba_ruta', array('uba_id' => $post_array['slcUbicacion']));

                    //Se mueve el archivo
                    $carpeta_destino_anx = ( $post_array['hdnArchivo'] != "") ? $rutaUbicacion . '/' . $post_array['hdnArchivo'] : "";
                    $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($post_array['hdnArchivo']);
                    if (file_exists($carpeta_temporal_anx)) {
                        copy($carpeta_temporal_anx, $carpeta_destino_anx);
                        unlink($carpeta_temporal_anx);
                    }

                    //Se ingresan las Categorias
                    $slcCategorias = $post_array["slcCategorias"];
                    if (count($slcCategorias) > 0) {
                        for ($i = 0; $i < count($slcCategorias); $i++) {
                            $categoria_array = array(
                                'cxh_id_arh' => $arh_id,
                                'cxh_id_cag' => $slcCategorias[$i],
                                'cxh_estado' => 1,
                                'cxh_usu_creacion' => $this->tank_auth->get_user_id(),
                                'cxh_fecha_creacion' => date('Y-m-d H:i:s'),
                                'cxh_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'cxh_fecha_modificacion' => date('Y-m-d H:i:s')
                            );

                            $this->gsatelite->ingresar('cxh_categoriaxarchivo', $categoria_array);
                        }
                    }

                    //Se ingresan las Etiquetas
                    $slcEtiquetas = $post_array["slcEtiquetas"];
                    if (count($slcEtiquetas) > 0) {
                        for ($i = 0; $i < count($slcEtiquetas); $i++) {
                            $etiqueta_array = array(
                                'exh_id_arh' => $arh_id,
                                'exh_id_eqa' => $slcEtiquetas[$i],
                                'exh_estado' => 1,
                                'exh_usu_creacion' => $this->tank_auth->get_user_id(),
                                'exh_fecha_creacion' => date('Y-m-d H:i:s'),
                                'exh_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'exh_fecha_modificacion' => date('Y-m-d H:i:s')
                            );

                            $this->gsatelite->ingresar('exh_etiquetaxarchivo', $etiqueta_array);
                        }
                    }

                    //Se ingresa la bitacora de creación del archivo 
                    $bitacora_array = array(
                        'bta_id_usu' => $this->tank_auth->get_user_id(),
                        'bta_id_arh' => $arh_id,
                        'bta_comentario' => "Creado",
                        'bta_fecha' => date('Y-m-d H:i:s'),
                        'bta_manual' => 0,
                        'bta_estado' => 1,
                        'bta_usu_creacion' => $this->tank_auth->get_user_id(),
                        'bta_fecha_creacion' => date('Y-m-d H:i:s'),
                        'bta_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'bta_fecha_modificacion' => date('Y-m-d H:i:s')
                    );

                    $this->gsatelite->ingresar('bta_bitacora_archivo', $bitacora_array);

                    //exh_etiquetaxarchivo
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Archivo", 'texto_alerta' => "El archivo " . $post_array['txtCodigoArchivo'] . " se guardo correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Archivo", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }

                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_gestion_documental/procesos/agregar_archivo');
                } else if ($tipo_btn == 2) {
                    redirect('modulo_gestion_documental/procesos/archivos');
                }
            }
            $data['codigo_archivo'] = $codigo_archivo;
            $data['lstTipo'] = $this->gsatelite->get_tabla('tpa_tipo_archivo', array('tpa_estado' => 1));
            $data['lstCategorias'] = $this->gsatelite->get_dropdown('cag_categoria_gestion', 'cag_nombre', '', array('cag_estado' => 1), null, null, null, true);
            $data['lstEtiquetas'] = $this->gsatelite->get_dropdown('eqa_etiqueta_archivo', 'eqa_nombre', '', array('eqa_estado' => 1), null, null, null, true);
            $data['lstUbicaciones'] = $this->gsatelite->get_dropdown('uba_ubicacion_archivo', 'uba_nombre', '', array('uba_estado' => 1), null, null, null, true);
            //print_r($this->db->last_query());die();
            $data['infoUsuario'] = $this->gestion_documental_model->get_info_usuario(array('id' => $this->tank_auth->get_user_id()));
            $data['titulo_personal'] = 'Agregar Archivo';
            cargarvista($data);
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    function editar_archivo($arh_id) {
        satelite_validar();
        try {
            $num_actual = $this->gsatelite->count('arh_archivo');
            $num_actual += 1;
            //Se genera el codigo del aviso
            $codigo_archivo = 'AR' . generar_codigo_cor($num_actual, 4);
            if ($this->input->post() && $arh_id > 0) {

                $post_array = $this->input->post();
                //die(var_dump($post_array));
                $tipo_btn = $post_array['btnCrear'];
                $archivo_array = array(
                    "arh_id_usu_actualiza" => $this->tank_auth->get_user_id(),
                    "arh_id_tpa" => $post_array['slcTipo'],
                    "arh_id_uba" => $post_array['slcUbicacion'],
                    "arh_nombre" => $post_array['txtNombreArchivo'],
                    "arh_descripcion" => $post_array['txtDescripcion'],
                    "arh_url_archivo" => $post_array['hdnArchivo'],
                    "arh_size" => $post_array['hdnTamanio'],
                    "arh_fecha_actualiza" => date('Y-m-d H:i:s'),
                    "arh_comentario" => "",
                    "arh_keywords" => $post_array['txtKeyword'],
                    "arh_estado" => 1,
                    "arh_usu_modificacion" => $this->tank_auth->get_user_id(),
                    "arh_fecha_modificacion" => date('Y-m-d H:i:s')
                );

                $resultado = $this->gsatelite->actualizar_array('arh_archivo', $archivo_array, array('arh_id' => $arh_id));

                if ($resultado > 0) {
                    //Se busca la ruta de la carpeta
                    $rutaUbicacion = $this->gsatelite->get_campo('uba_ubicacion_archivo', 'uba_ruta', array('uba_id' => $post_array['slcUbicacion']));

                    //Se mueve el archivo
                    $archivoInicial = $post_array['hdnRutaArchivo'];
                    $carpeta_destino_anx = ( $post_array['hdnArchivo'] != "") ? $rutaUbicacion . '/' . $post_array['hdnArchivo'] : "";
                    $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($post_array['hdnArchivo']);

                    if (file_exists($carpeta_temporal_anx)) {
                        copy($carpeta_temporal_anx, $carpeta_destino_anx);
                        unlink($carpeta_temporal_anx);
                        unlink($archivoInicial);
                    }

                    //Se elimina el detalle de categorias
                    $this->gsatelite->borrado_general('cxh_categoriaxarchivo', array('cxh_id_arh' => $arh_id));
                    //Se ingresan las Categorias
                    $slcCategorias = $post_array["slcCategorias"];
                    if (count($slcCategorias) > 0) {
                        for ($i = 0; $i < count($slcCategorias); $i++) {
                            $categoria_array = array(
                                'cxh_id_arh' => $arh_id,
                                'cxh_id_cag' => $slcCategorias[$i],
                                'cxh_estado' => 1,
                                'cxh_usu_creacion' => $this->tank_auth->get_user_id(),
                                'cxh_fecha_creacion' => date('Y-m-d H:i:s'),
                                'cxh_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'cxh_fecha_modificacion' => date('Y-m-d H:i:s')
                            );

                            $this->gsatelite->ingresar('cxh_categoriaxarchivo', $categoria_array);
                        }
                    }

                    //Se elimina el detalle de categorias
                    $this->gsatelite->borrado_general('exh_etiquetaxarchivo', array('exh_id_arh' => $arh_id));
                    //Se ingresan las Etiquetas
                    $slcEtiquetas = $post_array["slcEtiquetas"];
                    if (count($slcEtiquetas) > 0) {
                        for ($i = 0; $i < count($slcEtiquetas); $i++) {
                            $etiqueta_array = array(
                                'exh_id_arh' => $arh_id,
                                'exh_id_eqa' => $slcEtiquetas[$i],
                                'exh_estado' => 1,
                                'exh_usu_creacion' => $this->tank_auth->get_user_id(),
                                'exh_fecha_creacion' => date('Y-m-d H:i:s'),
                                'exh_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'exh_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('exh_etiquetaxarchivo', $etiqueta_array);
                        }
                    }

                    //exh_etiquetaxarchivo
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Archivo", 'texto_alerta' => "El Archivo se actualizó correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Archivo", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }

                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_gestion_documental/procesos/editar_archivo/' . $arh_id);
                } else if ($tipo_btn == 2) {
                    redirect('modulo_gestion_documental/procesos/archivos');
                }
            }

            $infoArchivo = $this->gsatelite->get_tabla('arh_archivo', array('arh_id' => $arh_id));
            $infoUbicacion = $this->gsatelite->get_tabla('uba_ubicacion_archivo', array('uba_id' => $infoArchivo[0]['arh_id_uba']));
            $lstEtiquetas = $this->gsatelite->get_tabla('exh_etiquetaxarchivo', array('exh_id_arh' => $infoArchivo[0]['arh_id']));
            $lstCategorias = $this->gsatelite->get_tabla('cxh_categoriaxarchivo', array('cxh_id_arh' => $infoArchivo[0]['arh_id']));

            $data['lstTipo'] = $this->gsatelite->get_tabla('tpa_tipo_archivo', array('tpa_estado' => 1));
            $data['lstCategorias'] = $this->gsatelite->get_dropdown('cag_categoria_gestion', 'cag_nombre', '', array('cag_estado' => 1), array_column($lstCategorias, 'cxh_id_cag'), null, null, true);
            $data['lstEtiquetas'] = $this->gsatelite->get_dropdown('eqa_etiqueta_archivo', 'eqa_nombre', '', array('eqa_estado' => 1), array_column($lstEtiquetas, 'exh_id_eqa'), null, null, true);
            $data['lstUbicaciones'] = $this->gsatelite->get_dropdown('uba_ubicacion_archivo', 'uba_nombre', '', array('uba_estado' => 1), $infoArchivo[0]['arh_id_uba'], null, null, true);
            $data['lstBitacora'] = $this->gestion_documental_model->get_bitacora_archivo(array('bta_id_arh' => $arh_id));

            $data['infoUsuario'] = $this->gestion_documental_model->get_info_usuario(array('id' => $this->tank_auth->get_user_id()));
            $data['infoArchivo'] = $infoArchivo[0];
            $data['infoUbicacion'] = $infoUbicacion[0];
            $data['titulo_personal'] = 'Editar Archivo';
            cargarvista($data);
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function guardar_gral($parametros, $mimes = null) {
        $carpeta = $parametros;
        //var_dump($mimes);
        if ($mimes != null) {
            $mimes = str_replace('-', '|', $mimes);
            $image = $this->upload_gral($carpeta, $mimes);
        } else {
            $image = $this->upload_gral($carpeta);
        }
        //$this->session->keep_flashdata('datos_1');
        //echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
        $json = json_encode(isset($image['upload_data'])?$image['upload_data']:$image);
        echo ($json == "null") ? "" : $json;
    }

    // function upload_gral($carpeta, $mimes = null) {
    //     $ruta = FCPATH . "public/temp/" . $carpeta;
    //     if (!file_exists($ruta)) {
    //         mkdir($ruta, 0777);
    //     }

    //     $obj = &get_instance();
    //     $config['upload_path'] = $ruta;
    //     if ($mimes != null) {
    //         $config['allowed_types'] = $mimes;
    //     }
    //      else {
    //         $config['allowed_types'] = '*';
    //     }

    //     $obj->load->library('upload', $config);
    //     if (!$obj->upload->do_upload()) {
    //         $error = array('error' => $obj->upload->display_errors());
    //         return true;
    //     } else {
    //         $data = array('upload_data' => $obj->upload->data());
    //         return $data;
    //     }
    //     print_r($data);
    // }


function upload_gral($carpeta, $mimes = null) {
    $ruta = FCPATH . "public/temp/" . $carpeta;
    if (!file_exists($ruta)) {
        mkdir($ruta, 0777, true);
    }

    $obj = &get_instance();
    $config['upload_path'] = $ruta;
    $config['allowed_types'] = ($mimes !== null) ? $mimes : '*';

     $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
        } else {
            $data = array('upload_data' => $obj->upload->data());
            
        }

    $uploadData = $obj->upload->data();
    $filePath = $uploadData['full_path']; 
    $fileExt = strtolower($uploadData['file_ext']); 
    $fileName = pathinfo($uploadData['file_name'], PATHINFO_FILENAME); 
    $newFilePath = $ruta . '/' . $fileName . '.png'; 


    if ($fileExt === '.png') {
        try {
            $image = new Imagick($filePath);
            $realFormat = strtolower($image->getImageFormat());



            if ($realFormat === 'tiff' || $realFormat === 'tif') {
                $image->setImageFormat('png');
                $image->writeImage($newFilePath);
                $image->destroy();
            }

        } catch (Exception $e) {
            return array('error' => 'Error al procesar la imagen: ' . $e->getMessage());
        }
    }

    return $data;
}





    function mover_img_gral($ruta, $destino, $archivo) {
        if (is_dir($ruta)) {
            if (copy($ruta . '/' . $archivo, $destino . '/' . $archivo)) {
                return unlink($ruta . '/' . $archivo);
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    function eliminar_imagen_gral($carpeta = "") {

        $url = $this->input->post("url");
        $ruta = $this->input->post("ruta");
        //echo $url;
        $carp = ($carpeta != "") ? $carpeta : "documentos";

        if ($ruta != null) {
            unlink("./" . $ruta . "/" . $url);
        } else {
            unlink("./public/temp/$carp/" . $url);
        }
    }

    //rene castaneda
    public function enviar_link_archivo() {
        $exito = 0;
        $id_archivo = $this->input->post("id_archivo");
        $url_archivo = $this->input->post("url_archivo");
        $correo_destino = $this->input->post("correo_destino");
        $txtComentario = $this->input->post("txtComentario");
        $link_url_archivo = '<a target="_blank" href="' . $url_archivo . '" >Click para abrir archivo</a>';
        $this->db->join("emp_empleado", "emp_id=usu_id_emp");
        $datos_usu = $this->gsatelite->get_tabla("users", array('id' => $this->tank_auth->get_user_id()));
        $email_envia = $datos_usu[0]["email"];
        $nombre_envia = $datos_usu[0]["emp_nombre"] . " " . $datos_usu[0]["emp_apellido"];
        $asunto = "LINK DE ARCHIVO - SISTEMA GESTIÓN DE ARCHIVOS";

        if (trim($email_envia) != "" && trim($url_archivo) != "" && trim($correo_destino) != "") {
            # code...
            $mensaje = '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <table width="100%"  style="border:1px solid black;">
                <thead style="background-color:#bcd6e2;">
                    <tr><th colspan="2">LINK DE ARCHIVO</th></tr>
                </thead><tbody>
                    <tr><th  width="30%" align="right" >Link:</th><td  width="70%" >' . $link_url_archivo . '</td></tr>
                    <tr><th  width="30%" align="right" >Comentario:</th><td  width="70%" >' . $txtComentario . '</td></tr>
                </tbody>
            </table>
            <hr />
            <small>Correo enviado desde sistema ' . date("d-m-Y H:i:s") . '</small>';
            $exito = $this->gsatelite->envio_correo($email_envia, $nombre_envia, $correo_destino, $asunto, $mensaje, $email_envia);
        }

        die(json_encode(array('exito' => $exito)));
    }

    //rene castaneda
    public function deshabilitar_archivo($id_archivo = 0) {
        $exito = 0;
        if ($id_archivo > 0) {
            $datos_update = array(
                'arh_estado' => 0,
                'arh_usu_modificacion' => $this->tank_auth->get_user_id(),
                'arh_fecha_modificacion' => date("Y-m-d H:i:s")
            );
            $exito = $this->gsatelite->actualizar_array("arh_archivo", $datos_update, array("arh_id" => $id_archivo));
        }
        if ($exito)
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Archivo", 'texto_alerta' => "Registro desactivado correctamente");
        else
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Archivo", 'texto_alerta' => "Error en desactivar registro, intentar nuevamente");

        $this->session->set_flashdata($alerta);
        redirect("modulo_gestion_documental/procesos/buscador_archivos");
    }

    /**
     * @author René Castaneda
     * @since 24-07-2018
     * @return mantenimiento comentarios
     */
    function comentario_archivo($id_archivo = 0) {
        satelite_validar();
        $crud = new grocery_CRUD();

        $add = array(
            'bta_id_usu',
            'bta_id_arh',
            'bta_comentario',
            'bta_fecha',
            'bta_notificar_propietario',
            'bta_manual',
            'bta_estado',
            'bta_usu_modificacion',
            'bta_fecha_modificacion',
            'bta_usu_creacion',
            'bta_fecha_creacion'
        );

        $edit = array(
            'bta_id_usu',
            'bta_id_arh',
            'bta_comentario',
            'bta_fecha',
            'bta_notificar_propietario',
            'bta_manual',
            'bta_estado',
            'bta_usu_modificacion',
            'bta_fecha_modificacion'
        );

        $column = array(
            'bta_id_usu',
            'bta_comentario',
            'bta_fecha'
        );

        $display = array(
            'bta_id_usu' => 'Usuario',
            'bta_comentario' => 'Comentario',
            'bta_fecha' => 'Fecha',
            'bta_notificar_propietario' => 'Notificar',
            'bta_estado' => 'Estado'
        );

        $requeridos = array(
            'bta_id_usu',
            'bta_comentario',
            'bta_fecha'
        );
        $crud->where('bta_id_arh', $id_archivo);
        $crud->where('bta_manual', 1);
        $crud->set_table('bta_bitacora_archivo')
                ->set_subject('Comentarios')
                ->columns($column)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($requeridos)
                ->display_as($display)
                ->set_relation('bta_id_usu', 'users', 'username', array('activated' => 1))
                ->field_type('bta_id_arh', 'hidden', $id_archivo)
                ->field_type('bta_fecha', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('bta_id_usu', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('bta_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('bta_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('bta_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('bta_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('bta_notificar_propietario', 'Notificar', 'trim|required')
                ->set_rules('bta_comentario', 'Comentario', 'trim|required')
        ;
        $crud->field_type('bta_manual', 'hidden', 1);
        $crud->field_type('bta_estado', 'hidden', 1);
        $crud->field_type('bta_notificar_propietario', 'dropdown', array('1' => 'Sí notificar propietario', '0' => 'No notificar propietario'));


        $crud->callback_after_insert(function($post_array, $primary_key) {
            //enviar correo de notificación.
            return TRUE;
        });

        // Validaciones
        //$crud->unset_add();
        $crud->unset_edit();
        $crud->unset_read();
        $crud->unset_delete();
        $crud->unset_export()->unset_print();

        $data['titulo_personal'] = "Comentario de archivos";

        $output = $crud->render();
        $this->gsatelite->cargar_vista_masterpage('modulo_gestion_documental/procesos/comentario_archivo', $data, $output);
        //cargarvista($data, $output);
    }

    function cambiar_estado_archivo($arh_id, $estado = 1) {
        satelite_validar();
        if ($arh_id > 0) {
            $archivo_array = array(
                'arh_estado' => $estado,
                "arh_usu_modificacion" => $this->tank_auth->get_user_id(),
                "arh_fecha_modificacion" => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('arh_archivo', $archivo_array, array('arh_id' => $arh_id));

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Archivo", 'texto_alerta' => "El Archivo se modificó correctamente.");

            $this->session->set_flashdata($alerta);
            redirect('modulo_gestion_documental/procesos/archivos');
            die();
        }
        redirect('inicio/index');
    }

    function bitacora_archivo($arh_id) {
        satelite_validar();
        if ($arh_id > 0) {

            $where_array = array('bta_id_arh' => $arh_id);
            $data['lstBitacora'] = $this->gestion_documental_model->get_bitacora_archivo($where_array);
            $infoArchivo = $this->gsatelite->get_tabla('arh_archivo', array('arh_id' => $arh_id));
            $data['infoArchivo'] = $infoArchivo[0];

            $data['titulo_personal'] = "Bitacora";
            $this->gsatelite->cargar_vista_masterpage('modulo_gestion_documental/procesos/bitacora_archivo', $data);
        } else {
            redirect('inicio/index');
        }
    }



    function leer_ficha($arh_id) {
        satelite_validar();
        try {
            $num_actual = $this->gsatelite->count('arh_archivo');
            $num_actual += 1;
            //Se genera el codigo del aviso
            $codigo_archivo = 'AR' . generar_codigo_cor($num_actual, 4);

            $infoArchivo = $this->gsatelite->get_tabla('arh_archivo', array('arh_id' => $arh_id));
            $infoUbicacion = $this->gsatelite->get_tabla('uba_ubicacion_archivo', array('uba_id' => $infoArchivo[0]['arh_id_uba']));
            $lstEtiquetas = $this->gsatelite->get_tabla('exh_etiquetaxarchivo', array('exh_id_arh' => $infoArchivo[0]['arh_id']));
            $lstCategorias = $this->gsatelite->get_tabla('cxh_categoriaxarchivo', array('cxh_id_arh' => $infoArchivo[0]['arh_id']));

            $data['lstTipo'] = $this->gsatelite->get_tabla('tpa_tipo_archivo', array('tpa_estado' => 1));
            $data['lstCategorias'] = $this->gsatelite->get_dropdown('cag_categoria_gestion', 'cag_nombre', '', array('cag_estado' => 1), array_column($lstCategorias, 'cxh_id_cag'), null, null, true);
            $data['lstEtiquetas'] = $this->gsatelite->get_dropdown('eqa_etiqueta_archivo', 'eqa_nombre', '', array('eqa_estado' => 1), array_column($lstEtiquetas, 'exh_id_eqa'), null, null, true);
            $data['lstUbicaciones'] = $this->gsatelite->get_dropdown('uba_ubicacion_archivo', 'uba_nombre', '', array('uba_estado' => 1), $infoArchivo[0]['arh_id_uba'], null, null, true);
            $data['lstBitacora'] = $this->gestion_documental_model->get_bitacora_archivo(array('bta_id_arh' => $arh_id));

            $data['infoUsuario'] = $this->gestion_documental_model->get_info_usuario(array('id' => $this->tank_auth->get_user_id()));

            $data["metaData"] = $this->gsatelite->get_tabla("mga_metadata_gestor_archivos", ["mga_id_arh" => $arh_id]);

            $data['infoArchivo'] = $infoArchivo[0];
            $data['infoUbicacion'] = $infoUbicacion[0];
            $data['titulo_personal'] = 'Editar Archivo';
            cargarvista($data);
        } catch (Exception $ex) {
            throw $ex;
        }
    }


    function carga_masiva_archivos(){
        $data['titulo_personal'] = 'Carga Masiva de Archivos';
        $data['ubicaciones'] = $this->gestion_documental_model->get_full_hierarchy();
        cargarvista($data);
    }



    public function uploadGeneralFile() {
        if (isset($_FILES["file"]) && is_array($_FILES["file"]["name"])) {

            $carpetaTemporal = FCPATH . 'public/temp/anx_temporales/';

            if (!is_dir($carpetaTemporal)) {
                mkdir($carpetaTemporal, 0755, true);
            }

            $_nombreTemporale = "";
            $nombreArchivo = "";
            $rutaCompleta = "";
            $realName = "";

            for ($i = 0; $i < count($_FILES["file"]["name"]); $i++) {

                $nombreOriginal = $_FILES['file']['name'][$i];
                $info = pathinfo($nombreOriginal);
                $realName = $info['filename'];

                $nombreArchivo = str_replace(" ", "_", $_FILES["file"]["name"][$i]);
                $archivoTemp = $_FILES["file"]["tmp_name"][$i];

                $nombreTemporal = time() . '_' . $nombreArchivo;
                $rutaCompleta = $carpetaTemporal . $nombreTemporal;

                if (move_uploaded_file($archivoTemp, $rutaCompleta)) {
                    $_nombreTemporale = str_replace(" ", "_", $nombreTemporal);
                    $rutaCompleta = $carpetaTemporal . $_nombreTemporale;
                } else {
                    echo json_encode(["error" => "Error al mover el archivo $nombreArchivo."]);
                    return;
                }
            }

            ob_clean();
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode([
                "NombreTemporal" => $_nombreTemporale,
                "NombreReal" => $realName,
                "RutaArchivos" => base_url('uploads/temp/' . $_nombreTemporale)
            ], JSON_UNESCAPED_UNICODE);
            exit;

            return;
        } else {
            ob_clean();
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode(["error" => "No se recibieron archivos válidos."], JSON_UNESCAPED_UNICODE);
            exit;
        }
    }

    public function deleteGeneralFile() {
        $requestData = json_decode(file_get_contents("php://input"), true);

        if (!isset($requestData['NombreTemporal'])) {
            echo json_encode(["error" => "No se proporcionó el nombre del archivo a eliminar."]);
            return;
        }

        $nombreArchivo = $requestData['NombreTemporal'];
        $rutaCompleta = FCPATH . 'public/temp/anx_temporales/' . $nombreArchivo;

        if (file_exists($rutaCompleta)) {
            unlink($rutaCompleta);

            $response = [
                'status' => 'success',
                'message' => 'Archivo eliminado',
                'NombreTemporal' => $nombreArchivo
            ];
        } else {
            $response = [
                'status' => 'error',
                'message' => 'Archivo no encontrado',
                'NombreTemporal' => $nombreArchivo
            ];
        }

        ob_clean();
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode($response, JSON_UNESCAPED_UNICODE);
        exit;
    }



public function procesarDocumentoMasivo() { 

    $usuario_id = $this->tank_auth->get_user_id();
    session_write_close(); 

    while (ob_get_level() > 0) ob_end_clean();
    ob_implicit_flush(true);

    header('Content-Type: text/event-stream');
    header('Cache-Control: no-cache');
    header('Connection: keep-alive');
    header('X-Accel-Buffering: no');

    ini_set('output_buffering', 'off');
    ini_set('implicit_flush', 1);
    ini_set('zlib.output_compression', 0);
    set_time_limit(0);

    $slc_destino = $this->input->post("slc_destino"); 
    $input_name = $this->input->post("input_name"); 

    if (!$slc_destino || !$input_name) {
        $this->enviar_mensaje_stream("Parámetros incompletos.");
        return;
    }

    $ruta = $this->gsatelite->get_campo("uba_ubicacion_archivo", "uba_ruta", ["uba_id" => $slc_destino]);
    $ruta_archivo = FCPATH . 'public/temp/anx_temporales/' . $input_name;
    $ruta_destino = FCPATH . $ruta; 

    if (!file_exists($ruta_archivo)) {
        $this->enviar_mensaje_stream("El archivo no existe en la ruta temporal.");
        return;
    }

    $this->procesar_archivo_comprimido($ruta_archivo, $ruta_destino, $slc_destino, $usuario_id);
    $this->enviar_mensaje_stream("Proceso completado.");
}


private function enviar_mensaje_stream($mensaje) {

    if (is_array($mensaje)) {
        $mensaje = array_map(function($v) {
            return preg_replace('/^\xEF\xBB\xBF/', '', $v);
        }, $mensaje);
    } else {
        $mensaje = preg_replace('/^\xEF\xBB\xBF/', '', $mensaje);
    }

    echo "data: " . json_encode($mensaje, JSON_UNESCAPED_UNICODE) . "\n\n";
    ob_flush();
    flush();
}

private function limpiar_bom($texto) {
    while (ob_get_level() > 0) ob_end_clean();
    ob_implicit_flush(true);

    $boms = [
        "\xEF\xBB\xBF",       
        "\xFF\xFE",          
        "\xFE\xFF",          
        "\xFF\xFE\x00\x00",   
        "\x00\x00\xFE\xFF",  
    ];

    foreach ($boms as $bom) {
        if (strpos($texto, $bom) === 0) {
            $texto = substr($texto, strlen($bom));
        }
    }

    return $texto;
}
   
private function procesar_archivo_comprimido($ruta_archivo, $ruta_destino, $mga_id_arh, $usuario_id) {

    while (ob_get_level() > 0) ob_end_clean();
    ob_implicit_flush(true);

    ini_set('memory_limit', '4096M');
    ini_set('max_execution_time', 21600);
    ini_set('max_input_time', 21600);
    ini_set('output_buffering', 'Off');
    ini_set('implicit_flush', 1);
    ini_set('zlib.output_compression', 0);

    set_time_limit(0); 



    $extension = strtolower(pathinfo($ruta_archivo, PATHINFO_EXTENSION));

    if (!in_array($extension, ['zip', 'rar'])) {
        return ['error' => 'Formato no compatible. Solo se admiten archivos ZIP y RAR.'];
    }

    if (!file_exists($ruta_destino)) {
        mkdir($ruta_destino, 0777, true);
    }

    $json_data = null;
    $extraccion_exitosa = false;
    $carpeta_principal = null;

    if ($extension === 'zip') {
        $zip = new ZipArchive;
        if ($zip->open($ruta_archivo) === true) {
            for ($i = 0; $i < $zip->numFiles; $i++) {
                $archivo_nombre = $zip->getNameIndex($i);

                if (substr($archivo_nombre, -1) === '/' && !$carpeta_principal) {
                    $carpeta_principal = trim($archivo_nombre, '/');
                    continue;
                }

                if ($carpeta_principal && strpos($archivo_nombre, $carpeta_principal . '/') === 0) {
                    $ruta_extraida = $ruta_destino . '/' . basename($archivo_nombre);
                    copy("zip://$ruta_archivo#$archivo_nombre", $ruta_extraida);
                    
                    if (preg_match('/\.(jpg|jpeg|png|bmp|gif)$/i', $archivo_nombre)) {
                        $this->convertir_a_png($ruta_extraida);
                        $extraccion_exitosa = true;
                    }

                    if (pathinfo($archivo_nombre, PATHINFO_EXTENSION) === 'json') {
                        $json_data = file_get_contents($ruta_extraida);
                    }
                }
            }
            $zip->close();
        } else {
            return ['error' => 'No se pudo abrir el archivo ZIP.'];
        }
    }  elseif ($extension === 'rar') {
    if (!class_exists('RarArchive')) {
        $this->enviar_mensaje_stream("La extensión RarArchive no está instalada en el servidor.");
        return;
    }

    $rar_file = RarArchive::open($ruta_archivo);
    if (!$rar_file) {
        $this->enviar_mensaje_stream("No se pudo abrir el archivo RAR.");        
        return;
    }

    $entries = $rar_file->getEntries();
    if ($entries === false) {
        $this->enviar_mensaje_stream("No se pudo leer el contenido del archivo RAR.");
        return;
    }

    $archivos = array_filter($entries, fn($entry) => !$entry->isDirectory());

    $totalArch = (count($archivos)-1);

    $this->enviar_mensaje_stream(["evento" => "Se encontraron <b>$totalArch</b> archivos para procesar"]);

    $iProc = 0;
    foreach ($entries as $entry) {
        $archivo_nombre = $entry->getName();

        if ($entry->isDirectory()) continue;

        $nombre_archivo = basename($archivo_nombre);
        $ruta_final = $ruta_destino . '/' . $nombre_archivo;

        $stream = $entry->getStream();
        if (!$stream) {
            return ['error' => "No se pudo abrir el archivo interno: $archivo_nombre"];
        }

        $contenido = stream_get_contents($stream);
        fclose($stream);

        if (file_put_contents($ruta_final, $contenido) === false) {
            return ['error' => "No se pudo guardar el archivo en: $ruta_final"];
        }

        if (preg_match('/\.(jpg|jpeg|png|bmp|gif)$/i', $nombre_archivo)) {
            $this->convertir_a_png($ruta_final);
            $extraccion_exitosa = true;
            $iProc++;
        }

        if (strtolower(pathinfo($nombre_archivo, PATHINFO_EXTENSION)) === 'json' && file_exists($ruta_final)) {
            $json_data = file_get_contents($ruta_final);
        }

        $this->enviar_mensaje_stream(["procesados"=>"Procesados $iProc de $totalArch"]);
    }

        $rar_file->close();
    }

    if (!$json_data) {
        return ['error' => 'No se encontró un archivo JSON en el ZIP/RAR.'];
    }

    $json_data = preg_replace('/^\xEF\xBB\xBF/', '', $json_data);
    $json_array = json_decode($json_data, true);

    if (!$json_array) {
        return ['error' => 'Error al decodificar el JSON.'];
    }

    if ($extraccion_exitosa && file_exists($ruta_archivo)) {
        unlink($ruta_archivo);
    }

    return $this->insertar_metadata($json_array, $mga_id_arh, $usuario_id);
}




private function convertir_a_png($filePath) {
    while (ob_get_level() > 0) ob_end_clean();
    ob_implicit_flush(true);

    $fileExt = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));

    if ($fileExt === 'png') {
        try {
            $image = new Imagick($filePath);
            $realFormat = strtolower($image->getImageFormat());

            if ($realFormat === 'tiff' || $realFormat === 'tif') {
                $newFilePath = $filePath;

                $image->setImageFormat('png');
                $image->writeImage($newFilePath);
                $image->clear();
                $image->destroy();
                return $newFilePath;
            }

        } catch (Exception $e) {
            return ['error' => 'Error al procesar la imagen: ' . $e->getMessage()];
        }
    }

    return $filePath;
}


private function insertar_metadata($json_data, $mga_id_arh, $usuario_id) {
    while (ob_get_level() > 0) ob_end_clean();
    ob_implicit_flush(true);

    $json_mapeo = $this->gsatelite->get_parametro_emp('SYS-FILE-MANAGER-MAPPING');
    $campos_map = json_decode($json_mapeo, true); 

    if (!$campos_map) {
        return ['error' => 'Error al obtener el mapeo de campos.'];
    }

    $mapa_campos = [];
    $mapa_database = []; 

     $this->enviar_mensaje_stream(["evento" => "Almacenando informacion en la base de datos"]);

    foreach ($campos_map as $campo) {
        if ($campo["tipo_campo"] === "DATABASE" && $campo["campo_interno"] === "CATEGORIA") {
            $mapa_database[$campo["campo_externo"]] = $campo["campo_interno"];
        } elseif ($campo["tipo_campo"] !== "DATABASE") {
            $mapa_campos[$campo["campo_externo"]] = [
                "campo_interno" => $campo["campo_interno"],
                "nombre_campo" => $campo["nombre_campo"],
                "tipo_campo" => $campo["tipo_campo"]
            ];
        }
    }

    foreach ($json_data as $fila) {
        $archivo_data = [
            'arh_id_usu' => $this->tank_auth->get_user_id(),
            'arh_id_usu_actualiza' => $this->tank_auth->get_user_id(),
            'arh_id_uba' => $mga_id_arh,
            'arh_nombre' => $fila['correlativo'] ?? 'SIN_NOMBRE',
            'arh_fecha_actualiza' => date('Y-m-d H:i:s'),
            'arh_fecha' => date('Y-m-d H:i:s'),
            'arh_descripcion' => $fila['correlativo'] ?? 'SIN_DESCRIPCION',
            'arh_url_archivo' => ($fila['correlativo'] ?? 'SIN_ARCHIVO') . '.png',
            'arh_estado' => 1,
            'arh_usu_creacion' => $this->tank_auth->get_user_id(),
            'arh_fecha_creacion' => date('Y-m-d H:i:s'),
            'arh_usu_modificacion' => $this->tank_auth->get_user_id(),
            'arh_fecha_modificacion' => date('Y-m-d H:i:s')
        ];

        $archivo_id = $this->gsatelite->ingresar('arh_archivo', $archivo_data);

        if (!$archivo_id) {
            return ['error' => 'No se pudo crear el archivo en la base de datos.'];
        }

        foreach ($fila as $campo => $valor) {
            if (isset($mapa_campos[$campo])) {

                if ($mapa_campos[$campo]["tipo_campo"] === "DATE") {
                    $valor = convertirFecha($valor);
                }

                $insert_metadata = [
                    'mga_id_arh' => $archivo_id,
                    'mga_campo_externo' => $campo,
                    'mga_nombre_campo' => $mapa_campos[$campo]["nombre_campo"],
                    'mga_campo' => $mapa_campos[$campo]["campo_interno"],
                    'mga_valor' => $valor,
                    'mga_tipo' => $mapa_campos[$campo]["tipo_campo"],
                    'mga_estado' => 1,
                    'mga_usu_creacion' => $usuario_id,
                    'mga_fecha_creacion' => date('Y-m-d H:i:s'),
                    'mga_usu_modificacion' => $usuario_id,
                    'mga_fecha_modificacion' => date('Y-m-d H:i:s')
                ];

                $this->gsatelite->ingresar('mga_metadata_gestor_archivos', $insert_metadata);
            }

            if (isset($mapa_database[$campo])) {
                $categoria_id = $this->gsatelite->get_campo(
                    'cag_categoria_gestion',
                    'cag_id',
                    array('cag_descripcion' => $valor)
                );

                if ($categoria_id) {
                    $categoriaxarchivo_data = [
                        'cxh_id_cag' => $categoria_id,
                        'cxh_id_arh' => $archivo_id,
                        'cxh_estado' => 1,
                        'cxh_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cxh_fecha_creacion' => date('Y-m-d H:i:s'),
                        'cxh_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cxh_fecha_modificacion' => date('Y-m-d H:i:s')
                    ];
                    $this->gsatelite->ingresar('cxh_categoriaxarchivo', $categoriaxarchivo_data);
                }
            }
        }

        unset($archivo_data);
        unset($insert_metadata);

    }

    $this->enviar_mensaje_stream(["evento" => "Los archivos fueron almacenados correctamente"]);
    exit;
}



public function get_archives() {
    $sEcho = intval($this->input->post('sEcho'));
    $iDisplayStart = intval($this->input->post('iDisplayStart')); 
    $iDisplayLength = intval($this->input->post('iDisplayLength')); 
    $sSearch = $this->input->post('sSearch'); 
    $iSortCol_0 = intval($this->input->post('iSortCol_0')); 
    $sSortDir_0 = $this->input->post('sSortDir_0'); 

    $where = [];

    $slcCategoria = $this->input->post('slcCategoria');
        $slcEtiqueta = $this->input->post('slcEtiqueta');
        $txtNombre = $this->input->post('txtNombre');
        $slcTipo = $this->input->post('slcTipo');
        $slcUsuario = $this->input->post('slcUsuario');
        $txtKeyword = $this->input->post('txtKeyword');


        $txtFecha_actualiza_hasta = $this->input->post('txtFecha_actualiza_hasta');
        $txtFecha_actualiza_desde = $this->input->post('txtFecha_actualiza_desde');
        $txtFecha_creacion_hasta = $this->input->post('txtFecha_creacion_hasta');
        $txtFecha_creacion_desde = $this->input->post('txtFecha_creacion_desde');

        $filtros_metadata = $this->input->post('filtros_metadata');

        $where['arh_estado'] = 1;
        if ($this->input->post()) {
            if (!empty($txtFecha_creacion_desde) && !empty($txtFecha_creacion_hasta)) {

                $where["DATE(arh_fecha) BETWEEN '$txtFecha_creacion_desde' AND '$txtFecha_creacion_hasta'"] = null;

            }

            if (!empty($txtFecha_actualiza_desde) && !empty($txtFecha_actualiza_hasta)) {

                $where["DATE(arh_fecha_actualiza) BETWEEN '$txtFecha_actualiza_desde' AND '$txtFecha_actualiza_hasta'"] = null;

            }

            if (!empty($slcCategoria)) {
                $where['cag_id'] = $slcCategoria;
            }
            if (!empty($slcEtiqueta) && is_array($slcEtiqueta)) {
                $where['eqa_id in (' . implode(',', $slcEtiqueta) . ')'] = null;
            }
            if (!empty($slcTipo)) {
                $where['arh_id_tpa'] = $slcTipo;
            }
            if (!empty($slcUsuario)) {
                $where['arh_id_usu'] = $slcUsuario;
            }
            if (!empty($txtNombre)) {
                $where['arh_nombre LIKE'] = "%".$txtNombre."%";
            }
            if (!empty($txtKeyword)) {
                $where["arh_keywords LIKE"] = "%".$txtKeyword."%";
            }
        }



    $where_metadata = [];
    $filtros_metadata = json_decode($this->input->post('filtros_metadata'), true);

    if (!empty($filtros_metadata) && is_array($filtros_metadata)) {
        foreach ($filtros_metadata as $campo => $valor) {
            if (!empty($valor)) {
                if (strpos($campo, '_desde') !== false) {
                    $campo_real = str_replace('_desde', '', $campo);
                    $where_metadata[$campo_real]['desde'] = date('Y-m-d', strtotime($valor));
                } elseif (strpos($campo, '_hasta') !== false) {
                    $campo_real = str_replace('_hasta', '', $campo);
                    $where_metadata[$campo_real]['hasta'] = date('Y-m-d', strtotime($valor));
                } else {
                    $where_metadata[$campo] = $valor;
                }
            }
        }
    }

    $mDataProp = [];
    for ($i = 0; $i < intval($this->input->post('iColumns')); $i++) {
        $mDataProp[] = $this->input->post('mDataProp_' . $i);
    }

    $order_column = isset($mDataProp[$iSortCol_0]) ? $mDataProp[$iSortCol_0] : 'arh_id';
    $order_dir = ($sSortDir_0 === 'desc') ? 'DESC' : 'ASC';

    $data = $this->gestion_documental_model->get_filtered_data_archive($sSearch, $iDisplayStart, $iDisplayLength, $order_column, $order_dir, $where, $where_metadata);
    $total_records = 100;
    $filtered_records = 100;

    $user_id = $this->tank_auth->get_user_id();
    foreach ($data as &$fila) {
        if (!empty($fila['ids_categoria'])) {
            $where_permiso = [
                'uxr_id_usu' => $user_id,
                "pmg_id_cag IN (" . $fila['ids_categoria'] . ")" => null
            ];
            $fila['permisos'] = $this->gestion_documental_model->get_permisos_gestion($where_permiso);
        } else {
            $fila['permisos'] = [
                'insertar' => 0, 'escritura' => 0, 'actualizar' => 0, 'descargar' => 0,
                'deshabilitar' => 0, 'comentario' => 0, 'enviar_vinculo' => 0, 'enviar_carpeta' => 0
            ];
        }
    }

    $response = [
        "sEcho" => $sEcho,
        "iTotalRecords" => $total_records,
        "iTotalDisplayRecords" => $filtered_records,
        "aaData" => $data
    ];

    ob_clean();
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit;
}

public function stream_recursos()
{
    while (ob_get_level() > 0) ob_end_clean();
    ob_implicit_flush(true);

    ini_set('memory_limit', '4096M');
    ini_set('max_execution_time', 21600);
    ini_set('max_input_time', 21600);
    ini_set('output_buffering', 'Off');
    ini_set('implicit_flush', 1);
    ini_set('zlib.output_compression', 0);
    set_time_limit(0);

    header('Content-Type: text/event-stream');
    header('Cache-Control: no-cache');
    header('Connection: keep-alive');
    header('X-Accel-Buffering: no'); 

    $os = strtoupper(PHP_OS);

    while (true) {
        if (connection_aborted()) break;

        if (strpos($os, 'WIN') === 0) {
            $cpu = $this->obtener_cpu_windows();
            $ram = $this->obtener_ram_windows();
        } elseif (strpos($os, 'LINUX') === 0 || strpos($os, 'DARWIN') === 0) {
            $cpu = $this->obtener_cpu_unix();
            $ram = $this->obtener_ram_unix();
        } else {
            $cpu = 0;
            $ram = 0;
        }

        $payload = json_encode([
            'os' => $os,
            'cpu' => round($cpu, 1),
            'ram' => round($ram, 1)
        ], JSON_UNESCAPED_UNICODE);

        $payload = preg_replace('/^\xEF\xBB\xBF/', '', $payload);

        echo "data: $payload\n\n";
        flush();

        sleep(1);
    }
}

private function obtener_cpu_unix()
{
    $salida = @shell_exec("LANG=C top -bn1 | grep 'Cpu(s)'");
    if (preg_match('/(\d+\.\d+)\s*us/', $salida, $matches)) {
        return floatval($matches[1]);
    }
    return 0;
}

private function obtener_ram_unix()
{
    $total = intval(@shell_exec("grep MemTotal /proc/meminfo | awk '{print $2}'"));
    $libre = intval(@shell_exec("grep MemAvailable /proc/meminfo | awk '{print $2}'"));

    if ($total > 0) {
        $usado = $total - $libre;
        return round(($usado / $total) * 100, 1);
    }
    return 0;
}

private function obtener_cpu_windows()
{
    $salida = [];
    @exec('wmic cpu get loadpercentage /value', $salida);

    foreach ($salida as $line) {
        if (stripos($line, "LoadPercentage") !== false) {
            $partes = explode("=", $line);
            return isset($partes[1]) ? floatval(trim($partes[1])) : 0;
        }
    }
    return 0;
}


private function obtener_ram_windows()
{
    $salida = [];
    @exec('wmic OS get FreePhysicalMemory,TotalVisibleMemorySize /Value', $salida);

    $total = 0;
    $free = 0;

    foreach ($salida as $line) {
        if (stripos($line, "TotalVisibleMemorySize") !== false) {
            $total = intval(trim(explode("=", $line)[1]));
        }
        if (stripos($line, "FreePhysicalMemory") !== false) {
            $free = intval(trim(explode("=", $line)[1]));
        }
    }

    if ($total > 0) {
        $usado = $total - $free;
        return round(($usado / $total) * 100, 1);
    }
    return 0;
}

function archivero_dte(){
        $data['titulo_personal'] = 'Archivos DTE';
        $data["sucursales"] = $this->gsatelite->get_tabla("suc_sucursal");
        cargarvista($data);
}


public function get_facturas_x_sucursal()
{
    while (ob_get_level() > 0) ob_end_clean();
    ob_implicit_flush(true);

    ini_set('memory_limit', '4096M');
    ini_set('max_execution_time', 21600);
    ini_set('max_input_time', 21600);
    ini_set('output_buffering', 'Off');
    ini_set('implicit_flush', 1);
    ini_set('zlib.output_compression', 0);
    set_time_limit(0);

    $sucursal = $this->input->post("sucursal");
    $anio     = $this->input->post("anio");
    $mes      = $this->input->post("mes");
    $dia      = $this->input->post("dia");
    $tipo     = $this->input->post("tipo");
    $busqueda = trim($this->input->post("search"));
    $page     = (int)$this->input->post("page");
    if ($page < 1) $page = 1;
    $limit    = 10;
    $offset   = ($page - 1) * $limit;




    if (!empty($busqueda)) {

        $this->db->from("fac_factura f");
        $this->db->join("tif_tipo_factura t", "t.tif_id = f.fac_id_tif");
        $this->db->join("cli_cliente c", "c.cli_id = f.fac_id_cli","left");
        $this->db->join("suc_sucursal s", "s.suc_id = f.fac_id_suc");
        $this->db->like("f.fac_codigo_generacion", $busqueda);
        $this->db->where("f.fac_sello_recepcion IS NOT NULL");
        $this->db->where("f.fac_comprobante_dte", 2);

        $count_query = clone $this->db;
        $total = $count_query->count_all_results();

        $this->db->select("
            CASE
                WHEN cli_nombre = cli_apellido OR cli_apellido IS NULL OR cli_apellido = ''
                    THEN cli_nombre
                ELSE CONCAT(cli_nombre, ' ', cli_apellido)
            END AS cliente,
            fac_total,
            s.suc_nombre AS sucursal,
            YEAR(f.fac_fecha_fact) AS anio,
            LPAD(MONTH(f.fac_fecha_fact),2,'0') AS mes,
            LPAD(DAY(f.fac_fecha_fact),2,'0') AS dia,
            t.tif_nombre AS tipo_nombre,
            t.tif_abreviacion AS tipo_abrev,
            f.fac_codigo_generacion AS archivo,
            CONCAT(
                IFNULL(
                    NULLIF(
                        (SELECT par_valor FROM par_parametro WHERE par_codigo = 'SYS_SIGLAS' LIMIT 1),
                        ''
                    ),
                    ''
                ),
                IF(
                    (SELECT par_valor FROM par_parametro WHERE par_codigo = 'SYS_SIGLAS' LIMIT 1) IS NULL 
                    OR (SELECT par_valor FROM par_parametro WHERE par_codigo = 'SYS_SIGLAS' LIMIT 1) = '',
                    '',
                    '/'
                ),
                s.suc_codigo,
                '/',
                DATE_FORMAT(f.fac_fecha_fact, '%Y/%m/%d/'),
                t.tif_abreviacion,
                '/',
                f.fac_codigo_generacion
            ) AS ruta_file
        ", FALSE);

        $this->db->order_by("f.fac_fecha_fact DESC");
        $this->db->limit($limit, $offset);

        $query = $this->db->get();
        $result = $query->result_array();

        $ruta_breadcrumb = [];
        if (!empty($result)) {
            $first = $result[0];
            $ruta_breadcrumb = [
                [
                    "label" => $first["sucursal"],
                    "filters" => ["sucursal" => $first["sucursal"]]
                ],
                [
                    "label" => $first["anio"],
                    "filters" => ["sucursal" => $first["sucursal"], "anio" => $first["anio"]]
                ],
                [
                    "label" => $first["mes"],
                    "filters" => ["sucursal" => $first["sucursal"], "anio" => $first["anio"], "mes" => $first["mes"]]
                ],
                [
                    "label" => $first["dia"],
                    "filters" => ["sucursal" => $first["sucursal"], "anio" => $first["anio"], "mes" => $first["mes"], "dia" => $first["dia"]]
                ],
                [
                    "label" => $first["tipo_nombre"],
                    "filters" => ["sucursal" => $first["sucursal"], "anio" => $first["anio"], "mes" => $first["mes"], "dia" => $first["dia"], "tipo" => $first["tipo_abrev"]]
                ],
            ];
        }


        $response = [
            "nivel" => "archivos",
            "total" => $total,
            "page"  => $page,
            "pages" => ($total > 0) ? ceil($total / $limit) : 1,
            "data"  => $result,
            "ruta"  => $ruta_breadcrumb
        ];

        $this->output
            ->set_content_type('application/json', 'utf-8')
            ->set_output(json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
        return;
    }

    if ($sucursal && $anio && $mes && $dia && $tipo) {

        $this->db->from("fac_factura f");
        $this->db->join("tif_tipo_factura t", "t.tif_id = f.fac_id_tif");
        $this->db->join("suc_sucursal s", "s.suc_id = f.fac_id_suc");
        $this->db->join("cli_cliente c", "c.cli_id = f.fac_id_cli", "left");
        $this->db->where("s.suc_nombre", $sucursal);
        $this->db->where("YEAR(f.fac_fecha_fact)", $anio);
        $this->db->where("MONTH(f.fac_fecha_fact)", $mes);
        $this->db->where("DAY(f.fac_fecha_fact)", $dia);
        $this->db->where("t.tif_abreviacion", $tipo);

        if (!empty($busqueda)) {
            $this->db->like("f.fac_codigo_generacion", $busqueda);
        }

        $count_query = clone $this->db;
        $total = $count_query->count_all_results();

        $this->db->select("
            CASE
                WHEN cli_nombre = cli_apellido OR cli_apellido IS NULL OR cli_apellido = ''
                    THEN cli_nombre
                ELSE CONCAT(cli_nombre, ' ', cli_apellido)
            END AS cliente,
            fac_total,
            s.suc_nombre AS sucursal,
            YEAR(f.fac_fecha_fact) AS anio,
            LPAD(MONTH(f.fac_fecha_fact),2,'0') AS mes,
            LPAD(DAY(f.fac_fecha_fact),2,'0') AS dia,
            t.tif_nombre AS tipo_nombre,
            t.tif_abreviacion AS tipo_abrev,
            f.fac_codigo_generacion AS archivo,
            CONCAT(
                IFNULL(
                    NULLIF(
                        (SELECT par_valor FROM par_parametro WHERE par_codigo = 'SYS_SIGLAS' LIMIT 1),
                        ''
                    ),
                    ''
                ),
                IF(
                    (SELECT par_valor FROM par_parametro WHERE par_codigo = 'SYS_SIGLAS' LIMIT 1) IS NULL 
                    OR (SELECT par_valor FROM par_parametro WHERE par_codigo = 'SYS_SIGLAS' LIMIT 1) = '',
                    '',
                    '/'
                ),
                s.suc_codigo,
                '/',
                DATE_FORMAT(f.fac_fecha_fact, '%Y/%m/%d/'),
                t.tif_abreviacion,
                '/',
                f.fac_codigo_generacion
            ) AS ruta_file
        ", FALSE);

        $this->db->limit($limit, $offset);
        $this->db->order_by("f.fac_fecha_fact DESC");

        $query = $this->db->get();
        $result = $query->result_array();

        $response = [
            "nivel" => "archivos",
            "total" => $total,
            "page"  => $page,
            "pages" => ($total > 0) ? ceil($total / $limit) : 1,
            "data"  => $result
        ];
    }

    else if ($sucursal && $anio && $mes && $dia) {
        $query = $this->db->query("
            SELECT DISTINCT 
                t.tif_nombre AS tipo_nombre,
                t.tif_abreviacion AS tipo_abrev
            FROM fac_factura f
            JOIN tif_tipo_factura t ON t.tif_id = f.fac_id_tif
            JOIN suc_sucursal s ON s.suc_id = f.fac_id_suc
            WHERE s.suc_nombre = ? 
              AND YEAR(f.fac_fecha_fact) = ? 
              AND MONTH(f.fac_fecha_fact) = ? 
              AND DAY(f.fac_fecha_fact) = ?
              AND f.fac_sello_recepcion IS NOT NULL
              AND f.fac_comprobante_dte = 2
            ORDER BY t.tif_nombre
        ", [$sucursal, $anio, $mes, $dia]);

        $response = [
            "nivel" => "tipos",
            "data"  => $query->result_array()
        ];
    }

    else if ($sucursal && $anio && $mes) {
        $query = $this->db->query("
            SELECT DISTINCT LPAD(DAY(f.fac_fecha_fact),2,'0') AS dia
            FROM fac_factura f
            JOIN suc_sucursal s ON s.suc_id = f.fac_id_suc
            WHERE s.suc_nombre = ? 
              AND YEAR(f.fac_fecha_fact) = ? 
              AND MONTH(f.fac_fecha_fact) = ?
              AND f.fac_sello_recepcion IS NOT NULL
              AND f.fac_comprobante_dte = 2
            ORDER BY dia
        ", [$sucursal, $anio, $mes]);

        $response = [
            "nivel" => "dias",
            "data"  => $query->result_array()
        ];
    }

    else if ($sucursal && $anio) {
        $query = $this->db->query("
            SELECT DISTINCT LPAD(MONTH(f.fac_fecha_fact),2,'0') AS mes
            FROM fac_factura f
            JOIN suc_sucursal s ON s.suc_id = f.fac_id_suc
            WHERE s.suc_nombre = ? 
              AND YEAR(f.fac_fecha_fact) = ?
              AND f.fac_sello_recepcion IS NOT NULL
              AND f.fac_comprobante_dte = 2
            ORDER BY mes
        ", [$sucursal, $anio]);

        $response = [
            "nivel" => "meses",
            "data"  => $query->result_array()
        ];
    }

    else if ($sucursal) {
        $query = $this->db->query("
            SELECT DISTINCT YEAR(f.fac_fecha_fact) AS anio
            FROM fac_factura f
            JOIN suc_sucursal s ON s.suc_id = f.fac_id_suc
            WHERE s.suc_nombre = ?
              AND f.fac_sello_recepcion IS NOT NULL
              AND f.fac_comprobante_dte = 2
            ORDER BY anio DESC
        ", [$sucursal]);

        $response = [
            "nivel" => "anios",
            "data"  => $query->result_array()
        ];
    }

    else {
        $response = [
            "nivel" => "vacio",
            "data"  => []
        ];
    }


    $this->output
        ->set_content_type('application/json', 'utf-8')
        ->set_output(json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
}


public function descargar_carpeta_multiple()
{
    $post = $this->input->post();
    $items = isset($post['items']) ? $post['items'] : [];
    $path = isset($post['path']) ? json_decode($post['path'], true) : [];

    if (is_string($items)) {
        $decoded = json_decode($items, true);
        if (is_array($decoded)) $items = $decoded;
    }

    $sucursal   = $path['sucursal'] ?? '';
    $suc_codigo = $path['suc_codigo'] ?? '';
    $anio = $path['anio'] ?? '';
    $mes  = $path['mes'] ?? '';
    $dia  = $path['dia'] ?? '';
    $tipo = $path['tipo'] ?? '';

    $root = FCPATH . 'uploads' . DIRECTORY_SEPARATOR . $this->gsatelite->get_parametro('SYS_MASTER_ARCHIVE') . DIRECTORY_SEPARATOR;
    $siglas = $this->gsatelite->get_parametro('SYS_SIGLAS');
    $log_msg = "";

    $pathFolder = $root . $siglas . DIRECTORY_SEPARATOR . "{$suc_codigo} - {$sucursal}";
    if ($anio) $pathFolder .= DIRECTORY_SEPARATOR . $anio;
    if ($mes)  $pathFolder .= DIRECTORY_SEPARATOR . $mes;
    if ($dia)  $pathFolder .= DIRECTORY_SEPARATOR . $dia;
    if ($tipo) $pathFolder .= DIRECTORY_SEPARATOR . $tipo;

    if (!is_dir($pathFolder)) {
        $log_msg = "No encontrado: {$pathFolder}";
        return rJson(['status' => 'error', 'msg' => 'Ruta base no encontrada', 'log' => $log_msg], 500, true);
    }

    $tempDir = FCPATH . 'public' . DIRECTORY_SEPARATOR . 'temp' . DIRECTORY_SEPARATOR . 'archivos' . DIRECTORY_SEPARATOR;
    if (!is_dir($tempDir)) mkdir($tempDir, 0777, true);

    $zipName = 'archivos_' . date('Ymd_His') . '.zip';
    $zipPath = $tempDir . $zipName;

    $zip = new ZipArchive();
    if ($zip->open($zipPath, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== TRUE) {
        $log_msg = "No se pudo crear el ZIP en {$zipPath}";
        return rJson(['status' => 'error', 'msg' => 'Error al crear ZIP', 'log' => $log_msg], 500, true);
    }

    $archivosAgregados = 0;
    foreach ($items as $item) {
        $rutaItem = $pathFolder . DIRECTORY_SEPARATOR . $item;

        if (file_exists($rutaItem . '.pdf')) {
            $zip->addFile($rutaItem . '.pdf', basename($rutaItem) . '.pdf');
            $archivosAgregados++;
        }
        if (file_exists($rutaItem . '.json')) {
            $zip->addFile($rutaItem . '.json', basename($rutaItem) . '.json');
            $archivosAgregados++;
        }

        elseif (is_dir($rutaItem)) {
            $files = new RecursiveIteratorIterator(
                new RecursiveDirectoryIterator($rutaItem, FilesystemIterator::SKIP_DOTS),
                RecursiveIteratorIterator::LEAVES_ONLY
            );
            foreach ($files as $file) {
                if (!$file->isDir()) {
                    $filePath = $file->getRealPath();
                    $relativePath = substr($filePath, strlen($root));
                    $zip->addFile($filePath, $relativePath);
                    $archivosAgregados++;
                }
            }
        } else {
            $log_msg .= "Elemento no encontrado: {$rutaItem}\n";
        }
    }

    $zip->close();
    clearstatcache();

    if (!file_exists($zipPath) || filesize($zipPath) < 100) {
        $log_msg .= "ZIP vacío o no creado correctamente: {$zipPath}";
        return rJson(['status' => 'error', 'msg' => 'El archivo ZIP no se generó correctamente', 'log' => $log_msg], 500, true);
    }

    return rJson([
        'status' => 'ok',
        'msg' => "ZIP generado correctamente con {$archivosAgregados} archivos",
        'zip' => base_url("public/temp/archivos/{$zipName}"),
        'log' => $log_msg
    ], 200, true);
}






}

