<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * @author Mario Marquez  
 * @method Controlador de Catalogos - Gestion Documental
 */
class Catalogos extends CI_Controller {

    //Constructor
    public function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->library('tank_auth');
        $this->load->model('gestion_documental_model');
    }

    /**
     * @author René Castaneda
     * @return mantenimiento de categoria de gestión de archivos
     * @since 11-07-2018
     */
    function categoria_archivo() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();

        $add = array(
            'cag_codigo',
            'cag_nombre',
            'cag_publico',
            'cag_descripcion',
            'cag_estado',
            'cag_usu_modificacion',
            'cag_fecha_modificacion',
            'cag_usu_creacion',
            'cag_fecha_creacion'
        );

        $edit = array(
            'cag_codigo',
            'cag_nombre',
            'cag_publico',
            'cag_descripcion',
            'cag_estado',
            'cag_usu_modificacion',
            'cag_fecha_modificacion'
        );

        $column = array(
            'cag_codigo',
            'cag_nombre',
            'cag_estado'
        );

        $display = array(
            'cag_publico' => 'Categoria publica',
            'cag_codigo' => 'Código',
            'cag_nombre' => 'Nombre',
            'cag_descripcion' => 'Descripción',
            'cag_estado' => 'Estado'
        );

        $requeridos = array(
            'cag_codigo',
            'cag_nombre',
            'cag_estado'
        );

        $crud->set_table('cag_categoria_gestion')
                ->set_subject('Categoría')
                ->columns($column)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($requeridos)
                ->display_as($display)
                ->field_type('cag_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('cag_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('cag_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('cag_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('cag_nombre', 'Nombre', 'trim|required|campo_unico[cag_categoria_gestion.cag_nombre]')
                ->set_rules('cag_nombre', 'Código', 'trim|required|campo_unico[cag_categoria_gestion.cag_codigo]')
        ;

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('cag_estado', 'hidden', 1);
        } else {
            $crud->field_type('cag_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $crud->field_type('cag_publico', 'dropdown', array('1' => 'Si', '0' => 'No'));

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        } else {
            $crud->add_action('Permisos', 'icomoon-icon-users', 'modulo_gestion_documental/catalogos/permisos_categoria');
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }


        $data["cod_correlativo"] = ($this->gsatelite->count('cag_categoria_gestion') + 1);
        $data['titulo_personal'] = "Categoría de archivos";

        $output = $crud->render();
        cargarvista($data, $output);
    }

    /**
     * @author René Castaneda
     * @return mantenimiento de tipo de archivos
     * @since 11-07-2018
     */
    function tipo_archivo() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();

        $add = array(
            'tpa_nombre',
            'tpa_extension_involucra',
            'tpa_descripcion',
            'tpa_estado',
            'tpa_usu_modificacion',
            'tpa_fecha_modificacion',
            'tpa_usu_creacion',
            'tpa_fecha_creacion'
        );

        $edit = array(
            'tpa_nombre',
            'tpa_extension_involucra',
            'tpa_descripcion',
            'tpa_estado',
            'tpa_usu_modificacion',
            'tpa_fecha_modificacion'
        );

        $column = array(
            'tpa_nombre',
            'tpa_extension_involucra',
            'tpa_estado'
        );

        $display = array(
            'tpa_nombre' => 'Nombre',
            'tpa_extension_involucra' => 'Extención(es)',
            'tpa_descripcion' => 'Descripción',
            'tpa_estado' => 'Estado'
        );

        $requeridos = array(
            'tpa_nombre',
            'tpa_extension_involucra',
            'tpa_estado'
        );

        $crud->set_table('tpa_tipo_archivo')
                ->set_subject('Tipo Archivo')
                ->columns($column)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($requeridos)
                ->display_as($display)
                ->field_type('tpa_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tpa_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('tpa_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tpa_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('tpa_nombre', 'Nombre', 'trim|required|campo_unico[tpa_tipo_archivo.tpa_nombre]')
        ;

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tpa_estado', 'hidden', 1);
        } else {
            $crud->field_type('tpa_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }
        $data['titulo_personal'] = "Tipo de archivos";

        $output = $crud->render();
        cargarvista($data, $output);
    }

    /**
     * @author René Castaneda
     * @return mantenimiento de etiquetas
     * @since 11-07-2018
     */
    function etiquetas() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();

        $add = array(
            'eqa_nombre',
            'eqa_descripcion',
            'eqa_estado',
            'eqa_usu_modificacion',
            'eqa_fecha_modificacion',
            'eqa_usu_creacion',
            'eqa_fecha_creacion'
        );

        $edit = array(
            'eqa_nombre',
            'eqa_descripcion',
            'eqa_estado',
            'eqa_usu_modificacion',
            'eqa_fecha_modificacion'
        );

        $column = array(
            'eqa_nombre',
            'eqa_estado'
        );

        $display = array(
            'eqa_nombre' => 'Nombre',
            'eqa_descripcion' => 'Descripción',
            'eqa_estado' => 'Estado'
        );

        $requeridos = array(
            'eqa_nombre',
            'eqa_estado'
        );

        $crud->set_table('eqa_etiqueta_archivo')
                ->set_subject('Etiqueta archivos')
                ->columns($column)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($requeridos)
                ->display_as($display)
                ->field_type('eqa_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('eqa_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('eqa_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('eqa_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('eqa_nombre', 'Nombre', 'trim|required|campo_unico[eqa_etiqueta_archivo.eqa_nombre]')
        ;

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('eqa_estado', 'hidden', 1);
        } else {
            $crud->field_type('eqa_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }
        $data['titulo_personal'] = "Etiquetas de archivos";

        $output = $crud->render();
        cargarvista($data, $output);
    }

    function permisos_categoria($cag_id) {
        satelite_validar();
        if ($cag_id > 0) {
            if ($this->input->post()) {
                $post_array = $this->input->post();
                //var_dump($cag_id);
                //die(var_dump($post_array));

                $hdnPermisos = $this->input->post('hdnPermisos');
                $hdnComboRol = $this->input->post('hdnComboRol');
                $hdnComboUsuario = $this->input->post('hdnComboUsuario');

                //Se borran todos los permisos
                $this->gsatelite->borrado_general('pmg_permiso_categoria', array('pmg_id_cag' => $cag_id
                ));

                if (count($hdnPermisos) > 0) {

                    for ($i = 0; $i < count($hdnPermisos); $i++) {

                        $lstPermisos = explode(",", $hdnPermisos[$i]);
                        if ($hdnComboRol[$i] != '' || $hdnComboUsuario[$i] != '') {
                            $permisos_array = array(
                                'pmg_id_cag' => $cag_id,
                                'pmg_id_rol' => ($hdnComboRol[$i] != '') ? $hdnComboRol[$i] : null,
                                'pmg_id_usu' => ($hdnComboUsuario[$i] != '') ? $hdnComboUsuario[$i] : null,
                                'pmg_insertar' => 0,
                                'pmg_escritura' => (in_array('escritura', $lstPermisos)) ? 1 : 0,
                                'pmg_actualizar' => (in_array('actualizar', $lstPermisos)) ? 1 : 0,
                                'pmg_descarga' => (in_array('descarga', $lstPermisos)) ? 1 : 0,
                                'pmg_deshabilitar' => (in_array('deshabilitar', $lstPermisos)) ? 1 : 0,
                                'pmg_comentario' => (in_array('comentario', $lstPermisos)) ? 1 : 0,
                                'pmg_enviar_vinculo' => (in_array('vinculo', $lstPermisos)) ? 1 : 0,
                                'pmg_enviar_carpeta' => (in_array('carpeta', $lstPermisos)) ? 1 : 0,
                                'pmg_estado' => 1,
                                "pmg_usu_creacion" => $this->tank_auth->get_user_id(),
                                "pmg_fecha_creacion" => date('Y-m-d H:i:s'),
                                "pmg_usu_modificacion" => $this->tank_auth->get_user_id(),
                                "pmg_fecha_modificacion" => date('Y-m-d H:i:s')
                            );

                            $this->gsatelite->ingresar('pmg_permiso_categoria', $permisos_array);
                        }
                    }

                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Permisos Categoria", 'texto_alerta' => "Los permisos se guardaron correctamente.");
                    $tipo_btn = $post_array['btnCrear'];
                    $this->session->set_flashdata($alerta);
                    if ($tipo_btn == 1) {
                        redirect('modulo_gestion_documental/catalogos/permisos_categoria/' . $cag_id);
                    } else if ($tipo_btn == 2) {
                        redirect('modulo_gestion_documental/catalogos/categoria_archivo');
                    }
                }
            }

            $infoCategoria = $this->gsatelite->get_tabla('cag_categoria_gestion', array('cag_id' => $cag_id));
            $data['infoCategoria'] = $infoCategoria[0];
            $data['lstRoles'] = $this->gsatelite->get_dropdown('rol_rol', 'rol_nombre', '', array('rol_estado' => 1), /* array_column($lstCategorias, 'cxh_id_cag') */ null, null, null, true);
            $data['lstUsuarios'] = $this->gsatelite->get_dropdown('users', 'username', '', array('activated' => 1), /* array_column($lstCategorias, 'cxh_id_cag') */ null, null, null, true);

            //Se obtienen los permisos por la categoria
            $data['lstPermisos'] = $this->gestion_documental_model->get_permisos_categoria(array('pmg_id_cag' => $cag_id
            ));

            $data['titulo_personal'] = "Permisos por categoría";
            cargarvista($data);
        } else {
            redirect('inicio/index');
        }
    }

}

// End class

    